import * as React from 'react';
import { GrowthBehavior, ErrorType } from '@workday/canvas-kit-react-common';
export interface TextAreaProps extends GrowthBehavior, React.TextareaHTMLAttributes<HTMLTextAreaElement> {
    disabled?: boolean;
    error?: ErrorType;
    inputRef?: React.Ref<HTMLTextAreaElement>;
    onChange?: React.ChangeEventHandler<HTMLTextAreaElement>;
    placeholder?: string;
    readOnly?: boolean;
    resize: TextAreaResizeDirection;
    value?: any;
}
export declare enum TextAreaResizeDirection {
    None = "none",
    Both = "both",
    Horizontal = "horizontal",
    Vertical = "vertical"
}
export default class TextArea extends React.Component<TextAreaProps> {
    static ErrorType: typeof ErrorType;
    static ResizeDirection: typeof TextAreaResizeDirection;
    static defaultProps: {
        resize: TextAreaResizeDirection;
    };
    render(): JSX.Element;
}
