"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var React = __importStar(require("react"));
var styled_1 = __importDefault(require("@emotion/styled"));
var canvas_kit_react_common_1 = require("@workday/canvas-kit-react-common");
var canvas_kit_react_core_1 = require("@workday/canvas-kit-react-core");
var TextAreaResizeDirection;
(function (TextAreaResizeDirection) {
    TextAreaResizeDirection["None"] = "none";
    TextAreaResizeDirection["Both"] = "both";
    TextAreaResizeDirection["Horizontal"] = "horizontal";
    TextAreaResizeDirection["Vertical"] = "vertical";
})(TextAreaResizeDirection = exports.TextAreaResizeDirection || (exports.TextAreaResizeDirection = {}));
var TextAreaContainer = styled_1.default('textarea')(__assign({}, canvas_kit_react_core_1.type.body, { border: "1px solid " + canvas_kit_react_core_1.inputColors.border, display: 'block', backgroundColor: canvas_kit_react_core_1.inputColors.background, borderRadius: canvas_kit_react_core_1.borderRadius.m, boxSizing: 'border-box', minHeight: 64, minWidth: 280, transition: '0.2s box-shadow, 0.2s border-color', padding: canvas_kit_react_core_1.spacingNumbers.xxs, margin: 0, '&::webkit-resizer': {
        display: 'none',
    }, '&::placeholder': {
        color: canvas_kit_react_core_1.inputColors.placeholder,
    }, '&:focus:not([disabled])': {
        borderColor: canvas_kit_react_core_1.inputColors.focusBorder,
        boxShadow: "inset 0 0 0 1px " + canvas_kit_react_core_1.inputColors.focusBorder,
        outline: 'none',
    }, '&:disabled': {
        backgroundColor: canvas_kit_react_core_1.inputColors.disabled.background,
        borderColor: canvas_kit_react_core_1.inputColors.disabled.border,
        color: canvas_kit_react_core_1.inputColors.disabled.text,
        '&::placeholder': {
            color: canvas_kit_react_core_1.inputColors.disabled.text,
        },
    } }), function (_a) {
    var error = _a.error;
    return (__assign({}, canvas_kit_react_common_1.errorRing(error)));
}, function (_a) {
    var resize = _a.resize, grow = _a.grow;
    return ({
        width: grow ? '100%' : undefined,
        resize: grow ? TextAreaResizeDirection.Vertical : resize,
    });
});
var TextArea = (function (_super) {
    __extends(TextArea, _super);
    function TextArea() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TextArea.prototype.render = function () {
        var _a = this.props, grow = _a.grow, inputRef = _a.inputRef, resize = _a.resize, inputProps = __rest(_a, ["grow", "inputRef", "resize"]);
        return React.createElement(TextAreaContainer, __assign({ ref: inputRef, grow: grow, resize: resize }, inputProps));
    };
    TextArea.ErrorType = canvas_kit_react_common_1.ErrorType;
    TextArea.ResizeDirection = TextAreaResizeDirection;
    TextArea.defaultProps = {
        resize: TextAreaResizeDirection.Both,
    };
    return TextArea;
}(React.Component));
exports.default = TextArea;
