var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import styled from '@emotion/styled';
import { ErrorType, errorRing } from '@workday/canvas-kit-react-common';
import { borderRadius, inputColors, spacingNumbers, type } from '@workday/canvas-kit-react-core';
export var TextAreaResizeDirection;
(function (TextAreaResizeDirection) {
    TextAreaResizeDirection["None"] = "none";
    TextAreaResizeDirection["Both"] = "both";
    TextAreaResizeDirection["Horizontal"] = "horizontal";
    TextAreaResizeDirection["Vertical"] = "vertical";
})(TextAreaResizeDirection || (TextAreaResizeDirection = {}));
var TextAreaContainer = styled('textarea')(__assign({}, type.body, { border: "1px solid " + inputColors.border, display: 'block', backgroundColor: inputColors.background, borderRadius: borderRadius.m, boxSizing: 'border-box', minHeight: 64, minWidth: 280, transition: '0.2s box-shadow, 0.2s border-color', padding: spacingNumbers.xxs, margin: 0, '&::webkit-resizer': {
        display: 'none',
    }, '&::placeholder': {
        color: inputColors.placeholder,
    }, '&:focus:not([disabled])': {
        borderColor: inputColors.focusBorder,
        boxShadow: "inset 0 0 0 1px " + inputColors.focusBorder,
        outline: 'none',
    }, '&:disabled': {
        backgroundColor: inputColors.disabled.background,
        borderColor: inputColors.disabled.border,
        color: inputColors.disabled.text,
        '&::placeholder': {
            color: inputColors.disabled.text,
        },
    } }), function (_a) {
    var error = _a.error;
    return (__assign({}, errorRing(error)));
}, function (_a) {
    var resize = _a.resize, grow = _a.grow;
    return ({
        width: grow ? '100%' : undefined,
        resize: grow ? TextAreaResizeDirection.Vertical : resize,
    });
});
var TextArea = (function (_super) {
    __extends(TextArea, _super);
    function TextArea() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TextArea.prototype.render = function () {
        var _a = this.props, grow = _a.grow, inputRef = _a.inputRef, resize = _a.resize, inputProps = __rest(_a, ["grow", "inputRef", "resize"]);
        return React.createElement(TextAreaContainer, __assign({ ref: inputRef, grow: grow, resize: resize }, inputProps));
    };
    TextArea.ErrorType = ErrorType;
    TextArea.ResizeDirection = TextAreaResizeDirection;
    TextArea.defaultProps = {
        resize: TextAreaResizeDirection.Both,
    };
    return TextArea;
}(React.Component));
export default TextArea;
