var __makeTemplateObject = (this && this.__makeTemplateObject) || function (cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import * as React from 'react';
import styled from '@emotion/styled';
import { borderRadius, colors, spacing, type } from '@workday/canvas-kit-react-core';
import { getTranslateFromOrigin } from '@workday/canvas-kit-react-common';
import { keyframes } from '@emotion/core';
var tooltipAnimation = function (transformOrigin) {
    var translate = getTranslateFromOrigin(transformOrigin, spacing.xxxs);
    return keyframes(templateObject_1 || (templateObject_1 = __makeTemplateObject(["\n    0% {\n      opacity: 0;\n      transform: translate(", "px, ", "px);\n    }\n    100% {\n      opacity: 1;\n      transform: translate(0);\n    }\n  "], ["\n    0% {\n      opacity: 0;\n      transform: translate(", "px, ", "px);\n    }\n    100% {\n      opacity: 1;\n      transform: translate(0);\n    }\n  "])), translate.x, translate.y);
};
var TooltipContainer = styled('div')(__assign({}, type.body, { display: 'inline-flex', borderRadius: borderRadius.m, padding: spacing.xxs, backgroundColor: 'rgba(0,0,0,.85)', color: colors.frenchVanilla100, fontSize: 13, margin: spacing.xxxs, a: {
        color: colors.frenchVanilla100,
        textDecoration: 'underline',
    } }), function (_a) {
    var transformOrigin = _a.transformOrigin;
    return ({
        animation: tooltipAnimation(transformOrigin),
        animationDuration: '150ms',
        animationTimingFunction: 'ease-out',
        transformOrigin: transformOrigin
            ? transformOrigin.vertical + " " + transformOrigin.horizontal
            : 'top center',
    });
});
var Tooltip = (function (_super) {
    __extends(Tooltip, _super);
    function Tooltip() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Tooltip.prototype.render = function () {
        return (React.createElement(TooltipContainer, __assign({}, this.props, { role: "tooltip" }), this.props.children));
    };
    Tooltip.defaultProps = {
        transformOrigin: {
            horizontal: 'center',
            vertical: 'bottom',
        },
    };
    return Tooltip;
}(React.Component));
export default Tooltip;
var templateObject_1;
