/**
 * workerpool.js
 * https://github.com/josdejong/workerpool
 *
 * Offload tasks to a pool of workers on node.js and in the browser.
 *
 * @version 2.3.3
 * @date    2018-09-12
 *
 * @license
 * Copyright (C) 2014-2016 Jos de Jong <wjosdejong@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
!function(r,e){"object"==typeof exports&&"object"==typeof module?module.exports=e():"function"==typeof define&&define.amd?define([],e):"object"==typeof exports?exports.workerpool=e():r.workerpool=e()}(this,function(){return function(r){function e(o){if(t[o])return t[o].exports;var n=t[o]={exports:{},id:o,loaded:!1};return r[o].call(n.exports,n,n.exports,e),n.loaded=!0,n.exports}var t={};return e.m=r,e.c=t,e.p="",e(0)}([function(r,e,t){var o=t(1);e.pool=function(r,e){return new(t(3))(r,e)},e.worker=function(r){t(9).add(r)},e.Promise=t(4),e.platform=o.platform,e.isMainThread=o.isMainThread,e.cpus=o.cpus},function(r,e,t){var o={require:t(2)};r.exports.platform="undefined"!=typeof Window||"undefined"!=typeof WorkerGlobalScope?"browser":"node",r.exports.isMainThread="browser"===r.exports.platform?"undefined"!=typeof Window:!process.connected,r.exports.cpus="browser"===r.exports.platform?self.navigator.hardwareConcurrency:o.require("os").cpus().length},function(r,e,t){function o(r){return t(n(r))}function n(r){return i[r]||function(){throw new Error("Cannot find module '"+r+"'.")}()}var i={"./Pool":3,"./Pool.js":3,"./Promise":4,"./Promise.js":4,"./WorkerHandler":5,"./WorkerHandler.js":5,"./environment":1,"./environment.js":1,"./generated/embeddedWorker":7,"./generated/embeddedWorker.js":7,"./header":8,"./header.js":8,"./worker":9,"./worker.js":9};o.keys=function(){return Object.keys(i)},o.resolve=n,r.exports=o,o.id=2},function(r,e,t){function o(r,e){"string"==typeof r?this.script=r||null:(this.script=null,e=r),this.workers=[],this.tasks=[],e=e||{},this.forkArgs=e.forkArgs||[],this.forkOpts=e.forkOpts||{},this.debugPortStart=e.debugPortStart||43210,e&&"maxWorkers"in e?(n(e.maxWorkers),this.maxWorkers=e.maxWorkers):this.maxWorkers=Math.max((f.cpus||4)-1,1),e&&"minWorkers"in e&&("max"===e.minWorkers?this.minWorkers=Math.max((f.cpus||4)-1,1):(i(e.minWorkers),this.minWorkers=e.minWorkers,this.maxWorkers=Math.max(this.minWorkers,this.maxWorkers)),this._ensureMinWorkers())}function n(r){if(!s(r)||!u(r)||r<1)throw new TypeError("Option maxWorkers must be an integer number >= 1")}function i(r){if(!s(r)||!u(r)||r<0)throw new TypeError("Option minWorkers must be an integer number >= 0")}function s(r){return"number"==typeof r}function u(r){return Math.round(r)==r}var c=t(4),a=t(5),f=t(1);o.prototype.exec=function(r,e){if(e&&!Array.isArray(e))throw new TypeError('Array expected as argument "params"');if("string"==typeof r){var t=c.defer(),o=this.tasks,n={method:r,params:e,resolver:t,timeout:null};o.push(n);var i=t.promise.timeout;return t.promise.timeout=function(r){return-1!==o.indexOf(n)?(n.timeout=r,t.promise):i.call(t.promise,r)},this._next(),t.promise}if("function"==typeof r)return this.exec("run",[String(r),e]);throw new TypeError('Function or string expected as argument "method"')},o.prototype.proxy=function(){if(arguments.length>0)throw new Error("No arguments expected");var r=this;return this.exec("methods").then(function(e){var t={};return e.forEach(function(e){t[e]=function(){return r.exec(e,Array.prototype.slice.call(arguments))}}),t})},o.prototype._next=function(){if(this.tasks.length>0){var r=this._getWorker();if(r){var e=this,t=this.tasks.shift();if(t.resolver.promise.pending){var o=r.exec(t.method,t.params,t.resolver).then(function(){e._next()}).catch(function(){r.terminated&&(e._removeWorker(r),e._ensureMinWorkers()),e._next()});"number"==typeof t.timeout&&o.timeout(t.timeout)}else e._next()}}},o.prototype._getWorker=function(){for(var r=0,e=this.workers.length;r<e;r++){var t=this.workers[r];if(!t.busy())return t}return this.workers.length<this.maxWorkers?(t=new a(this.script,{forkArgs:this.forkArgs,forkOpts:this.forkOpts,debugPort:this.debugPortStart+this.workers.length}),this.workers.push(t),t):null},o.prototype._removeWorker=function(r){r.terminate(),this._removeWorkerFromList(r)},o.prototype._removeWorkerFromList=function(r){var e=this.workers.indexOf(r);-1!=e&&this.workers.splice(e,1)},o.prototype.terminate=function(r,e){var t=function(r){this._removeWorkerFromList(r)},o=t.bind(this),n=[];return this.workers.slice().forEach(function(t){var i=t.terminateAndNotify(r,e).then(o);n.push(i)}),c.all(n)},o.prototype.clear=function(r){this.terminate(r)},o.prototype.stats=function(){var r=this.workers.length,e=this.workers.filter(function(r){return r.busy()}).length;return{totalWorkers:r,busyWorkers:e,idleWorkers:r-e,pendingTasks:this.tasks.length,activeTasks:e}},o.prototype._ensureMinWorkers=function(){if(this.minWorkers)for(var r=this.workers.length;r<this.minWorkers;r++)this.workers.push(new a(this.script,{forkArgs:this.forkArgs,forkOpts:this.forkOpts,debugPort:this.debugPortStart+r}))},r.exports=o},function(r,e){"use strict";function t(r,e){var s=this;if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");if("function"!=typeof r)throw new SyntaxError("Function parameter handler(resolve, reject) missing");var u=[],c=[];this.resolved=!1,this.rejected=!1,this.pending=!0;var a=function(r,e){u.push(r),c.push(e)};this.then=function(r,e){return new t(function(t,n){var i=r?o(r,t,n):t,s=e?o(e,t,n):n;a(i,s)},s)};var f=function(r){return s.resolved=!0,s.rejected=!1,s.pending=!1,u.forEach(function(e){e(r)}),a=function(e,t){e(r)},f=p=function(){throw new Error("Promise is already resolved")},s},p=function(r){return s.resolved=!1,s.rejected=!0,s.pending=!1,c.forEach(function(e){e(r)}),a=function(e,t){t(r)},f=p=function(){throw new Error("Promise is already resolved")},s};this.cancel=function(){return e?e.cancel():p(new n),s},this.timeout=function(r){if(e)e.timeout(r);else{var t=setTimeout(function(){p(new i("Promise timed out after "+r+" ms"))},r);s.always(function(){clearTimeout(t)})}return s},r(function(r){f(r)},function(r){p(r)})}function o(r,e,t){return function(o){try{var n=r(o);n&&"function"==typeof n.then&&"function"==typeof n.catch?n.then(e,t):e(n)}catch(r){t(r)}}}function n(r){this.message=r||"promise cancelled",this.stack=(new Error).stack}function i(r){this.message=r||"timeout exceeded",this.stack=(new Error).stack}t.prototype.catch=function(r){return this.then(null,r)},t.prototype.always=function(r){return this.then(r,r)},t.all=function(r){return new t(function(e,t){var o=r.length,n=[];o?r.forEach(function(r,i){r.then(function(r){n[i]=r,0==--o&&e(n)},function(r){o=0,t(r)})}):e(n)})},t.defer=function(){var r={};return r.promise=new t(function(e,t){r.resolve=e,r.reject=t}),r},n.prototype=new Error,n.prototype.constructor=Error,n.prototype.name="CancellationError",t.CancellationError=n,i.prototype=new Error,i.prototype.constructor=Error,i.prototype.name="TimeoutError",t.TimeoutError=i,r.exports=t},function(r,e,t){function o(){if("browser"==a.platform){if("undefined"==typeof Blob)throw new Error("Blob not supported by the browser");if(!window.URL||"function"!=typeof window.URL.createObjectURL)throw new Error("URL.createObjectURL not supported by the browser");var r=new Blob([t(7)],{type:"text/javascript"});return window.URL.createObjectURL(r)}return __dirname+"/worker.js"}function n(r){r=r||{};var e=process.execArgv.join(" "),t=-1!==e.indexOf("--inspect"),o=-1!==e.indexOf("--debug-brk"),n=[];return t&&(n.push("--inspect="+r.debugPort),o&&n.push("--debug-brk")),c({},r,{forkArgs:r.forkArgs,forkOpts:c({},r.forkOpts,{execArgv:(r.forkOpts&&r.forkOpts.execArgv||[]).concat(n)})})}function i(r){for(var e=new Error(""),t=Object.keys(r),o=0;o<t.length;o++)e[t[o]]=r[t[o]];return e}function s(r,e){function t(r){c.terminated=!0,c.terminating&&c.terminationHandler&&c.terminationHandler(c),c.terminating=!1;for(var e in c.processing)c.processing.hasOwnProperty(e)&&c.processing[e].resolver.reject(r);c.processing={}}function s(){c.requestQueue.forEach(c.worker.send.bind(c.worker)),c.requestQueue=[]}this.script=r||o();var u;if("browser"==a.platform){if("function"!=typeof Worker&&("object"!=typeof Worker||"function"!=typeof Worker.prototype.constructor))throw new Error("Web workers not supported by the browser");this.worker=new Worker(this.script),this.worker.on=function(r,e){this.addEventListener(r,function(r){e(r.data)})},this.worker.send=function(r){this.postMessage(r)}}else u=n(e),this.worker=f.require("child_process").fork(this.script,u.forkArgs,u.forkOpts);var c=this;r||(this.worker.ready=!0),this.requestQueue=[],this.worker.on("message",function(r){if("string"==typeof r&&"ready"===r)c.worker.ready=!0,s();else{var e=r.id,t=c.processing[e];t&&(delete c.processing[e],c.terminating&&c.terminate(),r.error?t.resolver.reject(i(r.error)):t.resolver.resolve(r.result))}}),this.worker.on("error",t),this.worker.on("exit",function(){t(new Error("Worker terminated unexpectedly"))}),this.processing={},this.terminating=!1,this.terminated=!1,this.terminationHandler=null,this.lastId=0}var u=t(4),c=t(6),a=t(1),f={require:t(2)};s.prototype.methods=function(){return this.exec("methods")},s.prototype.exec=function(r,e,t){t||(t=u.defer());var o=++this.lastId;this.processing[o]={id:o,resolver:t};var n={id:o,method:r,params:e};this.terminated?t.reject(new Error("Worker is terminated")):this.worker.ready?this.worker.send(n):this.requestQueue.push(n);var i=this;return t.promise.catch(function(r){(r instanceof u.CancellationError||r instanceof u.TimeoutError)&&(delete i.processing[o],i.terminate(!0))}),t.promise},s.prototype.busy=function(){return Object.keys(this.processing).length>0},s.prototype.terminate=function(r,e){if(r){for(var t in this.processing)this.processing.hasOwnProperty(t)&&this.processing[t].resolver.reject(new Error("Worker terminated"));this.processing={}}if("function"==typeof e&&(this.terminationHandler=e),this.busy())this.terminating=!0;else{if(this.worker){if("function"==typeof this.worker.kill)this.worker.kill();else{if("function"!=typeof this.worker.terminate)throw new Error("Failed to terminate worker");this.worker.terminate()}this.worker=null}this.terminating=!1,this.terminated=!0,this.terminationHandler&&this.terminationHandler(this)}},s.prototype.terminateAndNotify=function(r,e){var t=u.defer();return e&&(t.promise.timeout=e),this.terminate(r,function(r){t.resolve(r)}),t.promise},r.exports=s},function(r,e){/*
	object-assign
	(c) Sindre Sorhus
	@license MIT
	*/
"use strict";function t(r){if(null===r||void 0===r)throw new TypeError("Object.assign cannot be called with null or undefined");return Object(r)}var o=Object.getOwnPropertySymbols,n=Object.prototype.hasOwnProperty,i=Object.prototype.propertyIsEnumerable;r.exports=function(){try{if(!Object.assign)return!1;var r=new String("abc");if(r[5]="de","5"===Object.getOwnPropertyNames(r)[0])return!1;for(var e={},t=0;t<10;t++)e["_"+String.fromCharCode(t)]=t;if("0123456789"!==Object.getOwnPropertyNames(e).map(function(r){return e[r]}).join(""))return!1;var o={};return"abcdefghijklmnopqrst".split("").forEach(function(r){o[r]=r}),"abcdefghijklmnopqrst"===Object.keys(Object.assign({},o)).join("")}catch(r){return!1}}()?Object.assign:function(r,e){for(var s,u,c=t(r),a=1;a<arguments.length;a++){s=Object(arguments[a]);for(var f in s)n.call(s,f)&&(c[f]=s[f]);if(o){u=o(s);for(var p=0;p<u.length;p++)i.call(s,u[p])&&(c[u[p]]=s[u[p]])}}return c}},function(r,e){r.exports='!function(r){function e(n){if(o[n])return o[n].exports;var t=o[n]={exports:{},id:n,loaded:!1};return r[n].call(t.exports,t,t.exports,e),t.loaded=!0,t.exports}var o={};e.m=r,e.c=o,e.p="",e(0)}([function(module,exports,__webpack_require__){function convertError(r){return Object.getOwnPropertyNames(r).reduce(function(e,o){return Object.defineProperty(e,o,{value:r[o],enumerable:!0})},{})}function isPromise(r){return r&&"function"==typeof r.then&&"function"==typeof r.catch}var worker={};if("undefined"!=typeof self&&"function"==typeof postMessage&&"function"==typeof addEventListener)worker.on=function(r,e){addEventListener(r,function(r){e(r.data)})},worker.send=function(r){postMessage(r)};else{if("undefined"==typeof process)throw new Error("Script must be executed as a worker");worker.on=process.on.bind(process),worker.send=process.send.bind(process)}worker.methods={},worker.methods.run=function run(fn,args){var f=eval("("+fn+")");return f.apply(f,args)},worker.methods.methods=function(){return Object.keys(worker.methods)},worker.on("message",function(r){try{var e=worker.methods[r.method];if(!e)throw new Error(\'Unknown method "\'+r.method+\'"\');var o=e.apply(e,r.params);isPromise(o)?o.then(function(e){worker.send({id:r.id,result:e,error:null})}).catch(function(e){worker.send({id:r.id,result:null,error:convertError(e)})}):worker.send({id:r.id,result:o,error:null})}catch(e){worker.send({id:r.id,result:null,error:convertError(e)})}}),worker.register=function(r){if(r)for(var e in r)r.hasOwnProperty(e)&&(worker.methods[e]=r[e]);worker.send("ready")},exports.add=worker.register}]);'},function(r,e){},function(module,exports,__webpack_require__){function convertError(r){return Object.getOwnPropertyNames(r).reduce(function(e,t){return Object.defineProperty(e,t,{value:r[t],enumerable:!0})},{})}function isPromise(r){return r&&"function"==typeof r.then&&"function"==typeof r.catch}var worker={};if("undefined"!=typeof self&&"function"==typeof postMessage&&"function"==typeof addEventListener)worker.on=function(r,e){addEventListener(r,function(r){e(r.data)})},worker.send=function(r){postMessage(r)};else{if("undefined"==typeof process)throw new Error("Script must be executed as a worker");worker.on=process.on.bind(process),worker.send=process.send.bind(process)}worker.methods={},worker.methods.run=function run(fn,args){var f=eval("("+fn+")");return f.apply(f,args)},worker.methods.methods=function(){return Object.keys(worker.methods)},worker.on("message",function(r){try{var e=worker.methods[r.method];if(!e)throw new Error('Unknown method "'+r.method+'"');var t=e.apply(e,r.params);isPromise(t)?t.then(function(e){worker.send({id:r.id,result:e,error:null})}).catch(function(e){worker.send({id:r.id,result:null,error:convertError(e)})}):worker.send({id:r.id,result:t,error:null})}catch(e){worker.send({id:r.id,result:null,error:convertError(e)})}}),worker.register=function(r){if(r)for(var e in r)r.hasOwnProperty(e)&&(worker.methods[e]=r[e]);worker.send("ready")},exports.add=worker.register}])});
//# sourceMappingURL=workerpool.map