/**
 * workerpool.js
 * https://github.com/josdejong/workerpool
 *
 * Offload tasks to a pool of workers on node.js and in the browser.
 *
 * @version 3.1.2
 * @date    2019-03-14
 *
 * @license
 * Copyright (C) 2014-2016 Jos de Jong <wjosdejong@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
!function(r,e){"object"==typeof exports&&"object"==typeof module?module.exports=e(require("os"),function(){try{return require("worker_threads")}catch(r){}}(),require("child_process")):"function"==typeof define&&define.amd?define(["os","worker_threads","child_process"],e):"object"==typeof exports?exports.workerpool=e(require("os"),function(){try{return require("worker_threads")}catch(r){}}(),require("child_process")):r.workerpool=e(r.os,r.worker_threads,r.child_process)}(this,function(__WEBPACK_EXTERNAL_MODULE_2__,__WEBPACK_EXTERNAL_MODULE_12__,__WEBPACK_EXTERNAL_MODULE_13__){return function(r){function e(o){if(t[o])return t[o].exports;var n=t[o]={exports:{},id:o,loaded:!1};return r[o].call(n.exports,n,n.exports,e),n.loaded=!0,n.exports}var t={};return e.m=r,e.c=t,e.p="",e(0)}([function(r,e,t){var o=t(1);e.pool=function(r,e){return new(t(3))(r,e)},e.worker=function(r){t(11).add(r)},e.Promise=t(4),e.platform=o.platform,e.isMainThread=o.isMainThread,e.cpus=o.cpus},function(r,e,t){r.exports.platform="undefined"!=typeof Window||"undefined"!=typeof WorkerGlobalScope?"browser":"node",r.exports.isMainThread="browser"===r.exports.platform?"undefined"!=typeof Window:!process.connected,r.exports.cpus="browser"===r.exports.platform?self.navigator.hardwareConcurrency:t(2).cpus().length},function(r,e){r.exports=require("os")},function(r,e,t){function o(r,e){"string"==typeof r?this.script=r||null:(this.script=null,e=r),this.workers=[],this.tasks=[],e=e||{},this.forkArgs=e.forkArgs||[],this.forkOpts=e.forkOpts||{},this.debugPortStart=e.debugPortStart||43210,this.nodeWorker=e.nodeWorker,e&&"maxWorkers"in e?(n(e.maxWorkers),this.maxWorkers=e.maxWorkers):this.maxWorkers=Math.max((f.cpus||4)-1,1),e&&"minWorkers"in e&&("max"===e.minWorkers?this.minWorkers=Math.max((f.cpus||4)-1,1):(s(e.minWorkers),this.minWorkers=e.minWorkers,this.maxWorkers=Math.max(this.minWorkers,this.maxWorkers)),this._ensureMinWorkers()),this._boundNext=this._next.bind(this),"thread"===this.nodeWorker&&c.ensureWorkerThreads()}function n(r){if(!i(r)||!u(r)||r<1)throw new TypeError("Option maxWorkers must be an integer number >= 1")}function s(r){if(!i(r)||!u(r)||r<0)throw new TypeError("Option minWorkers must be an integer number >= 0")}function i(r){return"number"==typeof r}function u(r){return Math.round(r)==r}var a=t(4),c=t(5),f=t(1),p=t(8),d=new p;o.prototype.exec=function(r,e){if(e&&!Array.isArray(e))throw new TypeError('Array expected as argument "params"');if("string"==typeof r){var t=a.defer(),o=this.tasks,n={method:r,params:e,resolver:t,timeout:null};o.push(n);var s=t.promise.timeout;return t.promise.timeout=function(r){return-1!==o.indexOf(n)?(n.timeout=r,t.promise):s.call(t.promise,r)},this._next(),t.promise}if("function"==typeof r)return this.exec("run",[String(r),e]);throw new TypeError('Function or string expected as argument "method"')},o.prototype.proxy=function(){if(arguments.length>0)throw new Error("No arguments expected");var r=this;return this.exec("methods").then(function(e){var t={};return e.forEach(function(e){t[e]=function(){return r.exec(e,Array.prototype.slice.call(arguments))}}),t})},o.prototype._next=function(){if(this.tasks.length>0){var r=this._getWorker();if(r){var e=this,t=this.tasks.shift();if(t.resolver.promise.pending){var o=r.exec(t.method,t.params,t.resolver).then(e._boundNext).catch(function(){r.terminated&&(e._removeWorker(r),e._ensureMinWorkers()),e._next()});"number"==typeof t.timeout&&o.timeout(t.timeout)}else e._next()}}},o.prototype._getWorker=function(){for(var r=this.workers,e=0;e<r.length;e++){var t=r[e];if(!1===t.busy())return t}return r.length<this.maxWorkers?(t=new c(this.script,{forkArgs:this.forkArgs,forkOpts:this.forkOpts,debugPort:d.nextAvailableStartingAt(this.debugPortStart),nodeWorker:this.nodeWorker}),r.push(t),t):null},o.prototype._removeWorker=function(r){d.releasePort(r.debugPort),r.terminate(),this._removeWorkerFromList(r)},o.prototype._removeWorkerFromList=function(r){var e=this.workers.indexOf(r);-1!=e&&this.workers.splice(e,1)},o.prototype.terminate=function(r,e){var t=function(r){this._removeWorkerFromList(r)},o=t.bind(this),n=[];return this.workers.slice().forEach(function(t){var s=t.terminateAndNotify(r,e).then(o);n.push(s)}),a.all(n)},o.prototype.clear=function(r){this.terminate(r)},o.prototype.stats=function(){var r=this.workers.length,e=this.workers.filter(function(r){return r.busy()}).length;return{totalWorkers:r,busyWorkers:e,idleWorkers:r-e,pendingTasks:this.tasks.length,activeTasks:e}},o.prototype._ensureMinWorkers=function(){if(this.minWorkers)for(var r=this.workers.length;r<this.minWorkers;r++)this.workers.push(new c(this.script,{forkArgs:this.forkArgs,forkOpts:this.forkOpts,debugPort:d.nextAvailableStartingAt(this.debugPortStart)}))},r.exports=o},function(r,e){"use strict";function t(r,e){var i=this;if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");if("function"!=typeof r)throw new SyntaxError("Function parameter handler(resolve, reject) missing");var u=[],a=[];this.resolved=!1,this.rejected=!1,this.pending=!0;var c=function(r,e){u.push(r),a.push(e)};this.then=function(r,e){return new t(function(t,n){var s=r?o(r,t,n):t,i=e?o(e,t,n):n;c(s,i)},i)};var f=function(r){return i.resolved=!0,i.rejected=!1,i.pending=!1,u.forEach(function(e){e(r)}),c=function(e,t){e(r)},f=p=function(){},i},p=function(r){return i.resolved=!1,i.rejected=!0,i.pending=!1,a.forEach(function(e){e(r)}),c=function(e,t){t(r)},f=p=function(){},i};this.cancel=function(){return e?e.cancel():p(new n),i},this.timeout=function(r){if(e)e.timeout(r);else{var t=setTimeout(function(){p(new s("Promise timed out after "+r+" ms"))},r);i.always(function(){clearTimeout(t)})}return i},r(function(r){f(r)},function(r){p(r)})}function o(r,e,t){return function(o){try{var n=r(o);n&&"function"==typeof n.then&&"function"==typeof n.catch?n.then(e,t):e(n)}catch(r){t(r)}}}function n(r){this.message=r||"promise cancelled",this.stack=(new Error).stack}function s(r){this.message=r||"timeout exceeded",this.stack=(new Error).stack}t.prototype.catch=function(r){return this.then(null,r)},t.prototype.always=function(r){return this.then(r,r)},t.all=function(r){return new t(function(e,t){var o=r.length,n=[];o?r.forEach(function(r,s){r.then(function(r){n[s]=r,0==--o&&e(n)},function(r){o=0,t(r)})}):e(n)})},t.defer=function(){var r={};return r.promise=new t(function(e,t){r.resolve=e,r.reject=t}),r},n.prototype=new Error,n.prototype.constructor=Error,n.prototype.name="CancellationError",t.CancellationError=n,s.prototype=new Error,s.prototype.constructor=Error,s.prototype.name="TimeoutError",t.TimeoutError=s,r.exports=t},function(r,e,t){"use strict";function o(){var r=n("worker_threads");if(!r)throw new Error("WorkerPool: nodeWorkers = thread is not supported, Node >= 11.7.0 required");return r}function n(r){try{return t(7)(r)}catch(r){if("object"==typeof r&&null!==r&&"MODULE_NOT_FOUND"==r.code)return null;throw r}}function s(){if("browser"==l.platform){if("undefined"==typeof Blob)throw new Error("Blob not supported by the browser");if(!window.URL||"function"!=typeof window.URL.createObjectURL)throw new Error("URL.createObjectURL not supported by the browser");var r=new Blob([t(9)],{type:"text/javascript"});return window.URL.createObjectURL(r)}return __dirname+"/worker.js"}function i(r,e){var t=new e(r);return t.isBrowserWorker=!0,t.on=function(r,e){this.addEventListener(r,function(r){e(r.data)})},t.send=function(r){this.postMessage(r)},t}function u(r,e){var t=new e.Worker(r,{stdout:!1,stderr:!1});return t.isWorkerThread=!0,t.send=function(r){this.postMessage(r)},t.kill=function(){this.terminate()},t.disconnect=function(){this.terminate()},t}function a(r,e,t){var o=t.fork(r,e.forkArgs,e.forkOpts);return o.isChildProcess=!0,o}function c(r){r=r||{};var e=process.execArgv.join(" "),t=-1!==e.indexOf("--inspect"),o=-1!==e.indexOf("--debug-brk"),n=[];return t&&(n.push("--inspect="+r.debugPort),o&&n.push("--debug-brk")),h({},r,{forkArgs:r.forkArgs,forkOpts:h({},r.forkOpts,{execArgv:(r.forkOpts&&r.forkOpts.execArgv||[]).concat(n)})})}function f(r){for(var e=new Error(""),t=Object.keys(r),o=0;o<t.length;o++)e[t[o]]=r[t[o]];return e}function p(r,e){function p(r){w.terminated=!0,w.terminating&&w.terminationHandler&&w.terminationHandler(w),w.terminating=!1;for(var e in w.processing)void 0!==w.processing[e]&&w.processing[e].resolver.reject(r);w.processing=Object.create(null)}function d(){w.requestQueue.forEach(w.worker.send.bind(w.worker)),w.requestQueue=[]}this.script=r||s();var h=e||{};if(this.debugPort=h.debugPort,"browser"==l.platform){if("function"!=typeof Worker&&("object"!=typeof Worker||"function"!=typeof Worker.prototype.constructor))throw new Error("WorkerPool: Web workers not supported by the browser");this.worker=i(this.script,Worker)}else{var k;"thread"===h.nodeWorker?(k=o(),this.worker=u(this.script,k)):"auto"===h.nodeWorker?(k=n("worker_threads"),this.worker=k?u(this.script,k):a(this.script,c(h),t(13))):this.worker=a(this.script,c(h),t(13))}var w=this;r||(this.worker.ready=!0),this.requestQueue=[],this.worker.on("message",function(r){if("string"==typeof r&&"ready"===r)w.worker.ready=!0,d();else{var e=r.id,t=w.processing[e];void 0!==t&&(delete w.processing[e],!0===w.terminating&&w.terminate(),r.error?t.resolver.reject(f(r.error)):t.resolver.resolve(r.result))}});var m=this.worker;this.worker.on("error",p),this.worker.on("exit",function(r,e){var t="Workerpool Worker terminated Unexpectedly\n";t+="    exitCode: `"+r+"`\n",t+="    signalCode: `"+e+"`\n",t+="    workerpool.script: `"+w.script+"`\n",t+="    spawnArgs: `"+m.spawnargs+"`\n",t+="    spawnfile: `"+m.spawnfile+"`\n",t+="    stdout: `"+m.stdout+"`\n",t+="    stderr: `"+m.stderr+"`\n",p(new Error(t))}),this.processing=Object.create(null),this.terminating=!1,this.terminated=!1,this.terminationHandler=null,this.lastId=0}var d=t(4),h=t(6),l=t(1);p.prototype.methods=function(){return this.exec("methods")},p.prototype.exec=function(r,e,t){t||(t=d.defer());var o=++this.lastId;this.processing[o]={id:o,resolver:t};var n={id:o,method:r,params:e};this.terminated?t.reject(new Error("Worker is terminated")):this.worker.ready?this.worker.send(n):this.requestQueue.push(n);var s=this;return t.promise.catch(function(r){if(!(r instanceof d.CancellationError||r instanceof d.TimeoutError))throw r;delete s.processing[o],s.terminate(!0)}),t.promise},p.prototype.busy=function(){return Object.keys(this.processing).length>0},p.prototype.terminate=function(r,e){if(r){for(var t in this.processing)void 0!==this.processing[t]&&this.processing[t].resolver.reject(new Error("Worker terminated"));this.processing=Object.create(null)}if("function"==typeof e&&(this.terminationHandler=e),this.busy())this.terminating=!0;else{if(this.worker){if("function"==typeof this.worker.kill)this.worker.kill();else{if("function"!=typeof this.worker.terminate)throw new Error("Failed to terminate worker");this.worker.terminate()}this.worker=null}this.terminating=!1,this.terminated=!0,this.terminationHandler&&this.terminationHandler(this)}},p.prototype.terminateAndNotify=function(r,e){var t=d.defer();return e&&(t.promise.timeout=e),this.terminate(r,function(r){t.resolve(r)}),t.promise},r.exports=p,r.exports._tryRequire=n,r.exports._setupProcessWorker=a,r.exports._setupBrowserWorker=i,r.exports._setupWorkerThreadWorker=u,r.exports.ensureWorkerThreads=o},function(r,e){/*
	object-assign
	(c) Sindre Sorhus
	@license MIT
	*/
"use strict";function t(r){if(null===r||void 0===r)throw new TypeError("Object.assign cannot be called with null or undefined");return Object(r)}var o=Object.getOwnPropertySymbols,n=Object.prototype.hasOwnProperty,s=Object.prototype.propertyIsEnumerable;r.exports=function(){try{if(!Object.assign)return!1;var r=new String("abc");if(r[5]="de","5"===Object.getOwnPropertyNames(r)[0])return!1;for(var e={},t=0;t<10;t++)e["_"+String.fromCharCode(t)]=t;if("0123456789"!==Object.getOwnPropertyNames(e).map(function(r){return e[r]}).join(""))return!1;var o={};return"abcdefghijklmnopqrst".split("").forEach(function(r){o[r]=r}),"abcdefghijklmnopqrst"===Object.keys(Object.assign({},o)).join("")}catch(r){return!1}}()?Object.assign:function(r,e){for(var i,u,a=t(r),c=1;c<arguments.length;c++){i=Object(arguments[c]);for(var f in i)n.call(i,f)&&(a[f]=i[f]);if(o){u=o(i);for(var p=0;p<u.length;p++)s.call(i,u[p])&&(a[u[p]]=i[u[p]])}}return a}},function(r,e,t){function o(r){return t(n(r))}function n(r){return s[r]||function(){throw new Error("Cannot find module '"+r+"'.")}()}var s={"./Pool":3,"./Pool.js":3,"./Promise":4,"./Promise.js":4,"./WorkerHandler":5,"./WorkerHandler.js":5,"./debug-port-allocator":8,"./debug-port-allocator.js":8,"./environment":1,"./environment.js":1,"./generated/embeddedWorker":9,"./generated/embeddedWorker.js":9,"./header":10,"./header.js":10,"./worker":11,"./worker.js":11};o.keys=function(){return Object.keys(s)},o.resolve=n,r.exports=o,o.id=7},function(r,e){"use strict";function t(){this.ports=Object.create(null),this.length=0}r.exports=t,t.prototype.nextAvailableStartingAt=function(r){for(;!0===this.ports[r];)r++;if(r>=65535)throw new Error("WorkerPool debug port limit reached: "+r+">= 65535");return this.ports[r]=!0,this.length++,r},t.prototype.releasePort=function(r){delete this.ports[r],this.length--}},function(r,e){r.exports='!function(r){function e(n){if(o[n])return o[n].exports;var t=o[n]={exports:{},id:n,loaded:!1};return r[n].call(t.exports,t,t.exports,e),t.loaded=!0,t.exports}var o={};e.m=r,e.c=o,e.p="",e(0)}([function(module,exports,__webpack_require__){function convertError(r){return Object.getOwnPropertyNames(r).reduce(function(e,o){return Object.defineProperty(e,o,{value:r[o],enumerable:!0})},{})}function isPromise(r){return r&&"function"==typeof r.then&&"function"==typeof r.catch}var worker={};if("undefined"!=typeof self&&"function"==typeof postMessage&&"function"==typeof addEventListener)worker.on=function(r,e){addEventListener(r,function(r){e(r.data)})},worker.send=function(r){postMessage(r)};else{if("undefined"==typeof process)throw new Error("Script must be executed as a worker");var WorkerThreads;try{WorkerThreads=__webpack_require__(!function(){var r=new Error(\'Cannot find module "worker_threads"\');throw r.code="MODULE_NOT_FOUND",r}())}catch(r){if("object"!=typeof r||null===r||"MODULE_NOT_FOUND"!=r.code)throw r}if(WorkerThreads&&null!==WorkerThreads.parentPort){var parentPort=WorkerThreads.parentPort;worker.send=parentPort.postMessage.bind(parentPort),worker.on=parentPort.on.bind(parentPort)}else worker.on=process.on.bind(process),worker.send=process.send.bind(process)}worker.methods={},worker.methods.run=function run(fn,args){var f=eval("("+fn+")");return f.apply(f,args)},worker.methods.methods=function(){return Object.keys(worker.methods)},worker.on("message",function(r){try{var e=worker.methods[r.method];if(!e)throw new Error(\'Unknown method "\'+r.method+\'"\');var o=e.apply(e,r.params);isPromise(o)?o.then(function(e){worker.send({id:r.id,result:e,error:null})}).catch(function(e){worker.send({id:r.id,result:null,error:convertError(e)})}):worker.send({id:r.id,result:o,error:null})}catch(e){worker.send({id:r.id,result:null,error:convertError(e)})}}),worker.register=function(r){if(r)for(var e in r)r.hasOwnProperty(e)&&(worker.methods[e]=r[e]);worker.send("ready")},exports.add=worker.register}]);'},function(r,e){},function(module,exports,__webpack_require__){function convertError(r){return Object.getOwnPropertyNames(r).reduce(function(e,t){return Object.defineProperty(e,t,{value:r[t],enumerable:!0})},{})}function isPromise(r){return r&&"function"==typeof r.then&&"function"==typeof r.catch}var worker={};if("undefined"!=typeof self&&"function"==typeof postMessage&&"function"==typeof addEventListener)worker.on=function(r,e){addEventListener(r,function(r){e(r.data)})},worker.send=function(r){postMessage(r)};else{if("undefined"==typeof process)throw new Error("Script must be executed as a worker");var WorkerThreads;try{WorkerThreads=__webpack_require__(12)}catch(r){if("object"!=typeof r||null===r||"MODULE_NOT_FOUND"!=r.code)throw r}if(WorkerThreads&&null!==WorkerThreads.parentPort){var parentPort=WorkerThreads.parentPort;worker.send=parentPort.postMessage.bind(parentPort),worker.on=parentPort.on.bind(parentPort)}else worker.on=process.on.bind(process),worker.send=process.send.bind(process)}worker.methods={},worker.methods.run=function run(fn,args){var f=eval("("+fn+")");return f.apply(f,args)},worker.methods.methods=function(){return Object.keys(worker.methods)},worker.on("message",function(r){try{var e=worker.methods[r.method];if(!e)throw new Error('Unknown method "'+r.method+'"');var t=e.apply(e,r.params);isPromise(t)?t.then(function(e){worker.send({id:r.id,result:e,error:null})}).catch(function(e){worker.send({id:r.id,result:null,error:convertError(e)})}):worker.send({id:r.id,result:t,error:null})}catch(e){worker.send({id:r.id,result:null,error:convertError(e)})}}),worker.register=function(r){if(r)for(var e in r)r.hasOwnProperty(e)&&(worker.methods[e]=r[e]);worker.send("ready")},exports.add=worker.register},function(r,e){r.exports=require("worker_threads")},function(r,e){r.exports=require("child_process")}])});
//# sourceMappingURL=workerpool.map