/**
 * @license almond 0.3.0 Copyright (c) 2011-2014, The Dojo Foundation All Rights Reserved.
 * Available via the MIT or new BSD license.
 * see: http://github.com/jrburke/almond for details
 */

/*
 * Copyright 2003-2006, 2009, 2017, 2020 United States Government, as represented
 * by the Administrator of the National Aeronautics and Space Administration.
 * All rights reserved.
 *
 * The NASAWorldWind/WebWorldWind platform is licensed under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License
 * at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed
 * under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 *
 * NASAWorldWind/WebWorldWind also contains the following 3rd party Open Source
 * software:
 *
 *    ES6-Promise – under MIT License
 *    libtess.js – SGI Free Software License B
 *    Proj4 – under MIT License
 *    JSZip – under MIT License
 *
 * A complete listing of 3rd Party software notices and licenses included in
 * WebWorldWind can be found in the WebWorldWind 3rd-party notices and licenses
 * PDF found in code  directory.
 */

/**
 * @license
 * Copyright 2000, Silicon Graphics, Inc. All Rights Reserved.
 * Copyright 2015, Google Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice including the dates of first publication and
 * either this permission notice or a reference to http://oss.sgi.com/projects/FreeB/
 * shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * SILICON GRAPHICS, INC. BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Original Code. The Original Code is: OpenGL Sample Implementation,
 * Version 1.2.1, released January 26, 2000, developed by Silicon Graphics,
 * Inc. The Original Code is Copyright (c) 1991-2000 Silicon Graphics, Inc.
 * Copyright in any portions created by third parties is as indicated
 * elsewhere herein. All Rights Reserved.
 */

/*
 * Copyright 2015-2017 WorldWind Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*!
 * @overview es6-promise - a tiny implementation of Promises/A+.
 * @copyright Copyright (c) 2014 Yehuda Katz, Tom Dale, Stefan Penner and contributors (Conversion to ES6 API by Jake Archibald)
 * @license   Licensed under MIT license
 *            See https://raw.githubusercontent.com/stefanpenner/es6-promise/master/LICENSE
 * @version   v4.2.8+1e68dce6
 */

/*!

JSZip v3.2.2 - A JavaScript class for generating and reading zip files
<http://stuartk.com/jszip>

(c) 2009-2016 Stuart Knightley <stuart [at] stuartk.com>
Dual licenced under the MIT license or GPLv3. See https://raw.github.com/Stuk/jszip/master/LICENSE.markdown.

JSZip uses the library pako released under the MIT license :
https://github.com/nodeca/pako/blob/master/LICENSE
*/

/*!***********************!*\
          !*** ./lib/base64.js ***!
          \***********************/

/*! no static exports found */

/*!*********************************!*\
          !*** ./lib/compressedObject.js ***!
          \*********************************/

/*!*****************************!*\
          !*** ./lib/compressions.js ***!
          \*****************************/

/*!**********************!*\
          !*** ./lib/crc32.js ***!
          \**********************/

/*!*************************!*\
          !*** ./lib/defaults.js ***!
          \*************************/

/*!*************************!*\
          !*** ./lib/external.js ***!
          \*************************/

/*!**********************!*\
          !*** ./lib/flate.js ***!
          \**********************/

/*!***************************************!*\
          !*** ./lib/generate/ZipFileWorker.js ***!
          \***************************************/

/*!*******************************!*\
          !*** ./lib/generate/index.js ***!
          \*******************************/

/*!**********************!*\
          !*** ./lib/index.js ***!
          \**********************/

/*!*********************!*\
          !*** ./lib/load.js ***!
          \*********************/

/*!************************************************!*\
          !*** ./lib/nodejs/NodejsStreamInputAdapter.js ***!
          \************************************************/

/*!*************************************************!*\
          !*** ./lib/nodejs/NodejsStreamOutputAdapter.js ***!
          \*************************************************/

/*!****************************!*\
          !*** ./lib/nodejsUtils.js ***!
          \****************************/

/*!***********************!*\
          !*** ./lib/object.js ***!
          \***********************/

/*!****************************************!*\
          !*** ./lib/readable-stream-browser.js ***!
          \****************************************/

/*!***********************************!*\
          !*** ./lib/reader/ArrayReader.js ***!
          \***********************************/

/*!**********************************!*\
          !*** ./lib/reader/DataReader.js ***!
          \**********************************/

/*!****************************************!*\
          !*** ./lib/reader/NodeBufferReader.js ***!
          \****************************************/

/*!************************************!*\
          !*** ./lib/reader/StringReader.js ***!
          \************************************/

/*!****************************************!*\
          !*** ./lib/reader/Uint8ArrayReader.js ***!
          \****************************************/

/*!*********************************!*\
          !*** ./lib/reader/readerFor.js ***!
          \*********************************/

/*!**************************!*\
          !*** ./lib/signature.js ***!
          \**************************/

/*!*************************************!*\
          !*** ./lib/stream/ConvertWorker.js ***!
          \*************************************/

/*!**********************************!*\
          !*** ./lib/stream/Crc32Probe.js ***!
          \**********************************/

/*!***************************************!*\
          !*** ./lib/stream/DataLengthProbe.js ***!
          \***************************************/

/*!**********************************!*\
          !*** ./lib/stream/DataWorker.js ***!
          \**********************************/

/*!*************************************!*\
          !*** ./lib/stream/GenericWorker.js ***!
          \*************************************/

/*!************************************!*\
          !*** ./lib/stream/StreamHelper.js ***!
          \************************************/

/*!************************!*\
          !*** ./lib/support.js ***!
          \************************/

/*!*********************!*\
          !*** ./lib/utf8.js ***!
          \*********************/

/*!**********************!*\
          !*** ./lib/utils.js ***!
          \**********************/

/*!***************************!*\
          !*** ./lib/zipEntries.js ***!
          \***************************/

/*!*************************!*\
          !*** ./lib/zipEntry.js ***!
          \*************************/

/*!**************************!*\
          !*** ./lib/zipObject.js ***!
          \**************************/

/*!*****************************************!*\
          !*** ./node_modules/base64-js/index.js ***!
          \*****************************************/

/*!**************************************!*\
          !*** ./node_modules/buffer/index.js ***!
          \**************************************/

/*!***********************************************!*\
          !*** ./node_modules/core-util-is/lib/util.js ***!
          \***********************************************/

/*!***************************************!*\
          !*** ./node_modules/ieee754/index.js ***!
          \***************************************/

/*!***********************************************!*\
          !*** ./node_modules/immediate/lib/browser.js ***!
          \***********************************************/

/*!***************************************************!*\
          !*** ./node_modules/inherits/inherits_browser.js ***!
          \***************************************************/

/*!***************************************!*\
          !*** ./node_modules/isarray/index.js ***!
          \***************************************/

/*!*****************************************!*\
          !*** ./node_modules/lie/lib/browser.js ***!
          \*****************************************/

/*!**********************************************************************!*\
          !*** ./node_modules/node-libs-browser/node_modules/events/events.js ***!
          \**********************************************************************/

/*!**************************************************************************!*\
          !*** ./node_modules/node-libs-browser/node_modules/safe-buffer/index.js ***!
          \**************************************************************************/

/*!******************************************************************************************!*\
          !*** ./node_modules/node-libs-browser/node_modules/string_decoder/lib/string_decoder.js ***!
          \******************************************************************************************/

/*!*******************************************************************************!*\
          !*** ./node_modules/node-libs-browser/node_modules/timers-browserify/main.js ***!
          \*******************************************************************************/

/*!************************************!*\
          !*** ./node_modules/pako/index.js ***!
          \************************************/

/*!******************************************!*\
          !*** ./node_modules/pako/lib/deflate.js ***!
          \******************************************/

/*!******************************************!*\
          !*** ./node_modules/pako/lib/inflate.js ***!
          \******************************************/

/*!***********************************************!*\
          !*** ./node_modules/pako/lib/utils/common.js ***!
          \***********************************************/

/*!************************************************!*\
          !*** ./node_modules/pako/lib/utils/strings.js ***!
          \************************************************/

/*!***********************************************!*\
          !*** ./node_modules/pako/lib/zlib/adler32.js ***!
          \***********************************************/

/*!*************************************************!*\
          !*** ./node_modules/pako/lib/zlib/constants.js ***!
          \*************************************************/

/*!*********************************************!*\
          !*** ./node_modules/pako/lib/zlib/crc32.js ***!
          \*********************************************/

/*!***********************************************!*\
          !*** ./node_modules/pako/lib/zlib/deflate.js ***!
          \***********************************************/

/*!************************************************!*\
          !*** ./node_modules/pako/lib/zlib/gzheader.js ***!
          \************************************************/

/*!***********************************************!*\
          !*** ./node_modules/pako/lib/zlib/inffast.js ***!
          \***********************************************/

/*!***********************************************!*\
          !*** ./node_modules/pako/lib/zlib/inflate.js ***!
          \***********************************************/

/*!************************************************!*\
          !*** ./node_modules/pako/lib/zlib/inftrees.js ***!
          \************************************************/

/*!************************************************!*\
          !*** ./node_modules/pako/lib/zlib/messages.js ***!
          \************************************************/

/*!*********************************************!*\
          !*** ./node_modules/pako/lib/zlib/trees.js ***!
          \*********************************************/

/*!***********************************************!*\
          !*** ./node_modules/pako/lib/zlib/zstream.js ***!
          \***********************************************/

/*!*****************************************!*\
          !*** ./node_modules/process/browser.js ***!
          \*****************************************/

/*!********************************************************!*\
          !*** ./node_modules/readable-stream/duplex-browser.js ***!
          \********************************************************/

/*!************************************************************!*\
          !*** ./node_modules/readable-stream/lib/_stream_duplex.js ***!
          \************************************************************/

/*!*****************************************************************!*\
          !*** ./node_modules/readable-stream/lib/_stream_passthrough.js ***!
          \*****************************************************************/

/*!**************************************************************!*\
          !*** ./node_modules/readable-stream/lib/_stream_readable.js ***!
          \**************************************************************/

/*!***************************************************************!*\
          !*** ./node_modules/readable-stream/lib/_stream_transform.js ***!
          \***************************************************************/

/*!**************************************************************!*\
          !*** ./node_modules/readable-stream/lib/_stream_writable.js ***!
          \**************************************************************/

/*!*************************************************************************!*\
          !*** ./node_modules/readable-stream/lib/internal/streams/BufferList.js ***!
          \*************************************************************************/

/*!**********************************************************************!*\
          !*** ./node_modules/readable-stream/lib/internal/streams/destroy.js ***!
          \**********************************************************************/

/*!*****************************************************************************!*\
          !*** ./node_modules/readable-stream/lib/internal/streams/stream-browser.js ***!
          \*****************************************************************************/

/*!*********************************************************************************!*\
          !*** ./node_modules/readable-stream/node_modules/process-nextick-args/index.js ***!
          \*********************************************************************************/

/*!*****************************************************!*\
          !*** ./node_modules/readable-stream/passthrough.js ***!
          \*****************************************************/

/*!**********************************************************!*\
          !*** ./node_modules/readable-stream/readable-browser.js ***!
          \**********************************************************/

/*!***************************************************!*\
          !*** ./node_modules/readable-stream/transform.js ***!
          \***************************************************/

/*!**********************************************************!*\
          !*** ./node_modules/readable-stream/writable-browser.js ***!
          \**********************************************************/

/*!*******************************************!*\
          !*** ./node_modules/safe-buffer/index.js ***!
          \*******************************************/

/*!**************************************************!*\
          !*** ./node_modules/set-immediate-shim/index.js ***!
          \**************************************************/

/*!***************************************************!*\
          !*** ./node_modules/setimmediate/setImmediate.js ***!
          \***************************************************/

/*!*************************************************!*\
          !*** ./node_modules/stream-browserify/index.js ***!
          \*************************************************/

/*!************************************************!*\
          !*** ./node_modules/util-deprecate/browser.js ***!
          \************************************************/

/*!***********************************!*\
          !*** (webpack)/buildin/global.js ***!
          \***********************************/

/*!**********************!*\
          !*** util (ignored) ***!
          \**********************/

/*
 * Copyright 2003-2006, 2009, 2017, United States Government, as represented by the Administrator of the
 * National Aeronautics and Space Administration. All rights reserved.
 *
 * The NASAWorldWind/WebWorldWind platform is licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* 
 * Copyright (c) 2016, 2018 Bruce Schubert.
 * The MIT License
 * http://www.opensource.org/licenses/mit-license
 */

!function(e,t){"object"==typeof exports?module.exports=t():"function"==typeof define&&define.amd?define([],t):e.WorldWind=t()}(this,function(){var requirejs,require,define;!function(e){function t(e,t){return b.call(e,t)}function n(e,t){var n,r,i,s,o,a,l,h,u,c,d,f=t&&t.split("/"),p=m.map,g=p&&p["*"]||{};if(e&&"."===e.charAt(0))if(t){for(f=f.slice(0,f.length-1),e=e.split("/"),o=e.length-1,m.nodeIdCompat&&_.test(e[o])&&(e[o]=e[o].replace(_,"")),e=f.concat(e),u=0;u<e.length;u+=1)if("."===(d=e[u]))e.splice(u,1),u-=1;else if(".."===d){if(1===u&&(".."===e[2]||".."===e[0]))break;u>0&&(e.splice(u-1,2),u-=2)}e=e.join("/")}else 0===e.indexOf("./")&&(e=e.substring(2));if((f||g)&&p){for(n=e.split("/"),u=n.length;u>0;u-=1){if(r=n.slice(0,u).join("/"),f)for(c=f.length;c>0;c-=1)if((i=p[f.slice(0,c).join("/")])&&(i=i[r])){s=i,a=u;break}if(s)break;!l&&g&&g[r]&&(l=g[r],h=u)}!s&&l&&(s=l,a=h),s&&(n.splice(0,a,s),e=n.join("/"))}return e}function r(t,n){return function(){var r=y.call(arguments,0);return"string"!=typeof r[0]&&1===r.length&&r.push(null),u.apply(e,r.concat([t,n]))}}function i(e){return function(t){return n(t,e)}}function s(e){return function(t){f[e]=t}}function o(n){if(t(p,n)){var r=p[n];delete p[n],g[n]=!0,h.apply(e,r)}if(!t(f,n)&&!t(g,n))throw new Error("No "+n);return f[n]}function a(e){var t,n=e?e.indexOf("!"):-1;return n>-1&&(t=e.substring(0,n),e=e.substring(n+1,e.length)),[t,e]}function l(e){return function(){return m&&m.config&&m.config[e]||{}}}var h,u,c,d,f={},p={},m={},g={},b=Object.prototype.hasOwnProperty,y=[].slice,_=/\.js$/;c=function(e,t){var r,s=a(e),l=s[0];return e=s[1],l&&(l=n(l,t),r=o(l)),l?e=r&&r.normalize?r.normalize(e,i(t)):n(e,t):(e=n(e,t),s=a(e),l=s[0],e=s[1],l&&(r=o(l))),{f:l?l+"!"+e:e,n:e,pr:l,p:r}},d={require:function(e){return r(e)},exports:function(e){var t=f[e];return void 0!==t?t:f[e]={}},module:function(e){return{id:e,uri:"",exports:f[e],config:l(e)}}},h=function(n,i,a,l){var h,u,m,b,y,_,E=[],v=typeof a;if(l=l||n,"undefined"===v||"function"===v){for(i=!i.length&&a.length?["require","exports","module"]:i,y=0;y<i.length;y+=1)if(b=c(i[y],l),"require"===(u=b.f))E[y]=d.require(n);else if("exports"===u)E[y]=d.exports(n),_=!0;else if("module"===u)h=E[y]=d.module(n);else if(t(f,u)||t(p,u)||t(g,u))E[y]=o(u);else{if(!b.p)throw new Error(n+" missing "+u);b.p.load(b.n,r(l,!0),s(u),{}),E[y]=f[u]}m=a?a.apply(f[n],E):void 0,n&&(h&&h.exports!==e&&h.exports!==f[n]?f[n]=h.exports:m===e&&_||(f[n]=m))}else n&&(f[n]=a)},requirejs=require=u=function(t,n,r,i,s){if("string"==typeof t)return d[t]?d[t](n):o(c(t,n).f);if(!t.splice){if(m=t,m.deps&&u(m.deps,m.callback),!n)return;n.splice?(t=n,n=r,r=null):t=e}return n=n||function(){},"function"==typeof r&&(r=i,i=s),i?h(e,t,n,r):setTimeout(function(){h(e,t,n,r)},4),u},u.config=function(e){return u(e)},requirejs._defined=f,define=function(e,n,r){n.splice||(r=n,n=[]),t(f,e)||t(p,e)||(p[e]=[e,n,r])},define.amd={jQuery:!0}}(),define("../tools/almond",function(){}),define("formats/aaigrid/AAIGridConstants",[],function(){"use strict";return{N_COLS:"ncols",N_ROWS:"nrows",X_LL_CORNER:"xllcorner",Y_LL_CORNER:"yllcorner",CELL_SIZE:"cellsize",NO_DATA_VALUE:"NODATA_value"}}),define("formats/aaigrid/AAIGridMetadata",[],function(){"use strict";var e=function(){this._ncols=null,this._nrows=null,this._xllcorner=null,this._yllcorner=null,this._cellsize=null,this._NODATA_value=void 0};return Object.defineProperties(e.prototype,{ncols:{get:function(){return this._ncols},set:function(e){this._ncols=e}},nrows:{get:function(){return this._nrows},set:function(e){this._nrows=e}},xllcorner:{get:function(){return this._xllcorner},set:function(e){this._xllcorner=e}},yllcorner:{get:function(){return this._yllcorner},set:function(e){this._yllcorner=e}},cellsize:{get:function(){return this._cellsize},set:function(e){this._cellsize=e}},NODATA_value:{get:function(){return this._NODATA_value},set:function(e){this._NODATA_value=e}}}),e}),define("error/AbstractError",[],function(){"use strict";var e=function(e,t){this.name=e,this.message=t};return e.prototype.toString=function(){var e=this.name+": "+this.message;return this.stack&&(e+="\n"+this.stack.toString()),e},e}),define("error/ArgumentError",["../error/AbstractError"],function(e){"use strict";var t=function(t){e.call(this,"ArgumentError",t);var n;try{throw new Error}catch(e){n=e.stack}this.stack=n};return t.prototype=Object.create(e.prototype),t}),define("util/Logger",[],function(){"use strict";var e={LEVEL_NONE:0,LEVEL_SEVERE:1,LEVEL_WARNING:2,LEVEL_INFO:3,setLoggingLevel:function(e){t=e},getLoggingLevel:function(){return t},log:function(n,r){r&&n>0&&n<=t&&(n===e.LEVEL_SEVERE?console.error(r):n===e.LEVEL_WARNING?console.warn(r):n===e.LEVEL_INFO?console.info(r):console.log(r))},makeMessage:function(e,t,n){return e+"."+t+": "+(this.messageTable[n]?this.messageTable[n]:n)},logMessage:function(e,t,n,r){var i=this.makeMessage(t,n,r);return this.log(e,i),i},messageTable:{abstractInvocation:"The function called is abstract and must be overridden in a subclass.",indexOutOfRange:"The specified index is out of range.",invalidColumn:"The specified column is out of range.",invalidHeight:"The specified height is zero or negative.",invalidWidth:"The specified width is zero or negative.",invalidRow:"The specified row is out of range.",invalidSize:"The specified size is zero or negative.",missingAltitudeMode:"The specified altitude mode is null or undefined.",missingArrayBuffer:"The specified array buffer is null or undefined",missingAttributeName:"The specified DBase attribute file name is null or undefined.",missingArray:"The specified array is null, undefined or of insufficient length.",missingBoundaries:"The specified boundaries array is null or undefined.",missingBuffer:"The specified buffer descriptor is null or undefined.",missingColor:"The specified color is null or undefined.",missingConfig:"The specified config is null or undefined.",missingDc:"The specified draw context is null or undefined.",missingDomElement:"The specified DOM element is null or undefined.",missingEntry:"The specified entry is null or undefined.",missingFont:"The specified font is null or undefined.",missingFrustum:"The specified frustum is null or undefined.",missingFunction:"The specified function is null or undefined.",missingGlContext:"The specified WebGL rendering context is null or undefined.",missingGlobe:"The specified globe is null or undefined.",missingId:"The specified id is null or undefined.",missingImage:"The specified image is null or undefined.",missingImageFormat:"The specified image format is null or undefined.",missingIndices:"The specified indices array is null or undefined.",missingKey:"The specified key is null or undefined.",missingLevel:"The specified level is null or undefined.",missingLine:"The specified line is null or undefined.",missingList:"The specified list is null or undefined.",missingListener:"The specified listener is null or undefined",missingLocation:"The specified location is null or undefined.",missingMatrix:"The specified matrix is null or undefined.",missingOffset:"The specified offset is null or undefined.",missingPath:"The specified path is null or undefined.",missingPlacename:"The specified place name is null or undefined.",missingPlane:"The specified plane is null or undefined.",missingPoint:"The specified point is null or undefined.",missingPoints:"The specified points array is null or undefined.",missingPosition:"The specified position is null or undefined.",missingPositions:"The specified positions array is null or undefined.",missingProgram:"The specified program is null or undefined.",missingProjection:"The specified projection is null or undefined.",missingRectangle:"The specified rectangle is null or undefined.",missingRenderable:"The specified renderable is null or undefined.",missingResolution:"The specified resolution is null, undefined, or zero.",missingResource:"The specified resource is null or undefined.",missingResult:"The specified result variable is null or undefined.",missingResults:"The specified results array is null or undefined.",missingSector:"The specified sector is null or undefined.",missingShapeType:"The specified shape type is null or undefined.",missingSize:"The specified size is null or undefined.",missingText:"The specified text is null or undefined.",missingTexture:"The specified texture is null or undefined.",missingTile:"The specified tile is null or undefined.",missingType:"The specified type is null or undefined.",missingUrl:"The specified URL is null or undefined",missingVector:"The specified vector is null or undefined.",missingVertex:"The specified vertex is null or undefined.",missingViewport:"The specified viewport is null or undefined.",missingWebCoverageService:"The specified WebCoverageService is null or undefined.",missingWorldWindow:"The specified WorldWindow is null or undefined.",notYetImplemented:"This function is not yet implemented",unsupportedVersion:"The specified version is not supported.",webglNotSupported:"The browser does not support WebGL, or WebGL is disabled."}},t=1;return e}),define("formats/aaigrid/AAIGridReader",["./AAIGridConstants","./AAIGridMetadata","../../error/ArgumentError","../../util/Logger"],function(e,t,n,r){"use strict";var i=function(e){if(!e)throw new n(r.logMessage(r.LEVEL_SEVERE,"AAIGridReader","constructor","missingDataSource"));if("string"!=typeof e&&!(e instanceof ArrayBuffer))throw new n(r.logMessage(r.LEVEL_SEVERE,"AAIGridReader","constructor","invalidDataSource"));this._values=null,this._metadata=new t;var i=this.decodeData(e);this.parse(i)};return Object.defineProperties(i.prototype,{metadata:{get:function(){return this._metadata}}}),i.prototype.getImageData=function(){return this._values},i.prototype.decodeData=function(e){if("string"!=typeof e&&!(e instanceof ArrayBuffer))throw new n(r.logMessage(r.LEVEL_SEVERE,"AAIGridReader","decodeData","invalidDataSource"));if("string"==typeof e)return e;if("function"==typeof window.TextDecoder){return new TextDecoder("utf-8").decode(e)}for(var t="",i=new Uint8Array(e),s=65535,o=0,a=i.length;o<a;o+=s)o+s>a&&(s=a-o),t+=String.fromCharCode.apply(null,i.subarray(o,o+s));return t},i.prototype.parse=function(t){if("string"!=typeof t)throw new n(r.logMessage(r.LEVEL_SEVERE,"AAIGridReader","parse","invalidDataString"));for(var i=t.replace(/\r?\n|\r/g,"\n").split("\n"),s=[],o=!0,a=0,l=i.length;a<l;a++){var h=i[a];if(h){var u=h.trim().split(" ").map(function(e){return e.trim()}).filter(function(e){return""!==e});if(u[0]===e.N_COLS)this.metadata.ncols=+u[1];else if(u[0]===e.N_ROWS)this.metadata.nrows=+u[1];else if(u[0]===e.X_LL_CORNER)this.metadata.xllcorner=+u[1];else if(u[0]===e.Y_LL_CORNER)this.metadata.yllcorner=+u[1];else if(u[0]===e.CELL_SIZE)this.metadata.cellsize=+u[1];else if(u[0]===e.NO_DATA_VALUE)this.metadata.NODATA_value=+u[1];else if(isFinite(+u[0])){var c=u.map(function(e){var t=+e;return Math.floor(t)!==t&&(o=!1),t});s=s.concat(c)}}}this._values=o?new Int16Array(s):new Float32Array(s)},i.retrieveFromUrl=function(e,t){if(!e)throw new n(r.logMessage(r.LEVEL_SEVERE,"AAIGridReader","retrieveFromUrl","missingUrl"));if(!t)throw new n(r.logMessage(r.LEVEL_SEVERE,"AAIGridReader","retrieveFromUrl","The specified callback is null or undefined."));var s=new XMLHttpRequest;s.onload=function(){this.status>=200&&this.status<300?t(new i(this.response),s):(r.log(r.LEVEL_WARNING,"AAIGrid retrieval failed ("+s.statusText+"): "+e),t(null,s))},s.onerror=function(){r.log(r.LEVEL_WARNING,"AAIGrid retrieval failed: "+e),t(null,s)},s.ontimeout=function(){r.log(r.LEVEL_WARNING,"AAIGrid retrieval timed out: "+e),t(null,s)},s.open("GET",e,!0),s.responseType="arraybuffer",s.send(null)},i}),define("geom/Angle",[],function(){"use strict";return{DEGREES_TO_RADIANS:Math.PI/180,RADIANS_TO_DEGREES:180/Math.PI,TWO_PI:2*Math.PI,HALF_PI:Math.PI/2,normalizedDegrees:function(e){var t=e%360;return t>180?t-360:t<-180?360+t:t},normalizedDegreesLatitude:function(e){var t=e%180;return t>90?180-t:t<-90?-180-t:t},normalizedDegreesLongitude:function(e){var t=e%360;return t>180?t-360:t<-180?360+t:t},normalizedRadians:function(e){var t=e%this.TWO_PI;return t>Math.PI?t-this.TWO_PI:t<-Math.PI?this.TWO_PI+t:t},normalizedRadiansLatitude:function(e){var t=e%Math.PI;return t>this.HALF_PI?Math.PI-t:t<-this.HALF_PI?-Math.PI-t:t},normalizedRadiansLongitude:function(e){var t=e%this.TWO_PI;return t>Math.PI?t-this.TWO_PI:t<-Math.PI?this.TWO_PI+t:t},isValidLatitude:function(e){return e>=-90&&e<=90},isValidLongitude:function(e){return e>=-180&&e<=180},toString:function(e){return e.toString()+"°"},toDecimalDegreesString:function(e){return e.toString()+"°"},toDMSString:function(e){var t,n,r,i,s;return t=e<0?-1:1,n=t*e,r=Math.floor(n),n=60*(n-r),i=Math.floor(n),n=60*(n-i),s=Math.round(n),60==s&&(i++,s=0),60==i&&(r++,i=0),(-1==t?"-":"")+r+"° "+i+"’ "+s+"”"},toDMString:function(e){var t,n,r,i,s,o;return t=e<0?-1:1,n=t*e,r=Math.floor(n),n=60*(n-r),i=Math.floor(n),n=60*(n-i),s=Math.round(n),60==s&&(i++,s=0),60==i&&(r++,i=0),o=0==s?i:i+s/60,(-1==t?"-":"")+r+"° "+o+"’"}}}),define("util/Color",["../util/Logger"],function(e){"use strict";var t=function(e,t,n,r){this.red=e,this.green=t,this.blue=n,this.alpha=r};return t.WHITE=new t(1,1,1,1),t.BLACK=new t(0,0,0,1),t.RED=new t(1,0,0,1),t.GREEN=new t(0,1,0,1),t.BLUE=new t(0,0,1,1),t.CYAN=new t(0,1,1,1),t.YELLOW=new t(1,1,0,1),t.MAGENTA=new t(1,0,1,1),t.LIGHT_GRAY=new t(.75,.75,.75,1),t.MEDIUM_GRAY=new t(.5,.5,.5,1),t.DARK_GRAY=new t(.25,.25,.25,1),t.TRANSPARENT=new t(0,0,0,0),t.prototype.set=function(e,t,n,r){return this.red=e,this.green=t,this.blue=n,this.alpha=r,this},t.prototype.copy=function(t){if(!t)throw new ArgumentError(e.logMessage(e.LEVEL_SEVERE,"Color","copy","missingColor"));return this.red=t.red,this.green=t.green,this.blue=t.blue,this.alpha=t.alpha,this},t.prototype.clone=function(){return new t(this.red,this.green,this.blue,this.alpha)},t.prototype.premultipliedComponents=function(e){var t=this.alpha;return e[0]=this.red*t,e[1]=this.green*t,e[2]=this.blue*t,e[3]=t,e},t.colorFromByteArray=function(e){return new t(e[0]/255,e[1]/255,e[2]/255,e[3]/255)},t.colorFromBytes=function(e,n,r,i){return new t(e/255,n/255,r/255,i/255)},t.colorFromHex=function(e){var n=parseInt(e.substring(0,2),16),r=parseInt(e.substring(2,4),16),i=parseInt(e.substring(4,6),16),s=parseInt(e.substring(6,8),16);return t.colorFromBytes(n,r,i,s)},t.colorFromKmlHex=function(e){var n=parseInt(e.substring(0,2),16),r=parseInt(e.substring(2,4),16),i=parseInt(e.substring(4,6),16),s=parseInt(e.substring(6,8),16);return t.colorFromBytes(s,i,r,n)},t.prototype.nextColor=function(){var e=Math.round(255*this.red),t=Math.round(255*this.green),n=Math.round(255*this.blue);return e<255?this.red=(e+1)/255:t<255?(this.red=0,this.green=(t+1)/255):n<255?(this.red=0,this.green=0,this.blue=(n+1)/255):(this.red=1/255,this.green=0,this.blue=0),this},t.prototype.equals=function(e){var t=Math.round(255*this.red),n=Math.round(255*this.green),r=Math.round(255*this.blue),i=Math.round(255*this.alpha),s=Math.round(255*e.red),o=Math.round(255*e.green),a=Math.round(255*e.blue),l=Math.round(255*e.alpha);return t===s&&n===o&&r===a&&i===l},t.prototype.equalsBytes=function(e){var t=Math.round(255*this.red),n=Math.round(255*this.green),r=Math.round(255*this.blue),i=Math.round(255*this.alpha);return t===e[0]&&n===e[1]&&r===e[2]&&i===e[3]},t.prototype.toByteString=function(){return"("+Math.round(255*this.red)+","+Math.round(255*this.green)+","+Math.round(255*this.blue)+","+Math.round(255*this.alpha)+")"},t.prototype.toHexString=function(e){var t=Math.ceil(255*this.red).toString(16),n=Math.ceil(255*this.green).toString(16),r=Math.ceil(255*this.blue).toString(16),i=Math.ceil(255*this.alpha).toString(16),s="#";return s+=t.length<2?"0"+t:t,s+=n.length<2?"0"+n:n,s+=r.length<2?"0"+r:r,e&&(s+=i.length<2?"0"+i:i),s},t.prototype.toCssColorString=function(){return"rgba("+Math.round(255*this.red)+", "+Math.round(255*this.green)+", "+Math.round(255*this.blue)+", "+this.alpha+")"},t}),define("util/Font",["../error/ArgumentError","../util/Color","../util/Logger"],function(e,t,n){"use strict";var r=function(t,r,i,s,o,a){if(!t)throw new e(n.logMessage(n.LEVEL_SEVERE,"Font","constructor","missingSize"));if(t<=0)throw new e(n.logMessage(n.LEVEL_SEVERE,"Font","constructor","invalidSize"));this._size=t,this.style=r||"normal",this.variant=i||"normal",this.weight=s||"normal",this.family=o||"sans-serif",this.horizontalAlignment=a||"center"};return Object.defineProperties(r.prototype,{size:{get:function(){return this._size},set:function(e){this._fontString=null,this._size=e}},style:{get:function(){return this._style},set:function(e){this._fontString=null,this._style=e}},variant:{get:function(){return this._variant},set:function(e){this._fontString=null,this._variant=e}},weight:{get:function(){return this._weight},set:function(e){this._fontString=null,this._weight=e}},family:{get:function(){return this._family},set:function(e){this._fontString=null,this._family=e}},horizontalAlignment:{get:function(){return this._horizontalAlignment},set:function(e){this._toString=null,this._horizontalAlignment=e}},fontString:{get:function(){return this._fontString||(this._fontString=this._style+" "+this.variant+" "+this._weight+" "+this._size.toString()+"px "+this._family),this._fontString}}}),r.prototype.toString=function(){return this._toString&&this._fontString||(this._toString=this.fontString+" "+this.horizontalAlignment),this._toString},r}),define("util/Insets",["../error/ArgumentError","../util/Logger"],function(e,t){"use strict";var n=function(n,r,i,s){if(4!==arguments.length)throw new e(t.logMessage(t.LEVEL_SEVERE,"Insets","constructor","invalidArgumentCount"));this._top=n,this._left=r,this._bottom=i,this._right=s};return n.prototype.set=function(e,t,n,r){this._top=e,this._left=t,this._bottom=n,this._right=r},n.prototype.clone=function(){return new n(this._top,this._left,this._bottom,this._right)},n.prototype.toString=function(){return this._top+" "+this._left+" "+this._bottom+" "+this._right},Object.defineProperties(n.prototype,{top:{get:function(){return this._top},set:function(e){this._top=e}},left:{get:function(){return this._left},set:function(e){this._left=e}},bottom:{get:function(){return this._bottom},set:function(e){this._bottom=e}},right:{get:function(){return this._right},set:function(e){this._right=e}}}),n}),define("geom/Vec3",["../util/Logger","../error/ArgumentError"],function(e,t){"use strict";var n=function(e,t,n){this[0]=e,this[1]=t,this[2]=n};return n.prototype=new Float64Array(3),n.ZERO=new n(0,0,0),n.average=function(n,r){if(!n||n.length<1)throw new t(e.logMessage(e.LEVEL_SEVERE,"Vec3","average","missingArray"));if(!r)throw new t(e.logMessage(e.LEVEL_SEVERE,"Vec3","average","missingResult"));var i,s=n.length;r[0]=0,r[1]=0,r[2]=0;for(var o=0,a=n.length;o<a;o++)i=n[o],r[0]+=i[0]/s,r[1]+=i[1]/s,r[2]+=i[2]/s;return r},n.averageOfBuffer=function(n,r){if(!n||n.length<1)throw new t(e.logMessage(e.LEVEL_SEVERE,"Vec3","averageBuffer","missingArray"));if(!r)throw new t(e.logMessage(e.LEVEL_SEVERE,"Vec3","averageBuffer","missingResult"));var i=n.length/3;r[0]=0,r[1]=0,r[2]=0;for(var s=0;s<i;s++)r[0]+=n[3*s]/i,r[1]+=n[3*s+1]/i,r[2]+=n[3*s+2]/i;return r},n.areColinear=function(r,i,s){if(!r||!i||!s)throw new t(e.logMessage(e.LEVEL_SEVERE,"Vec3","areColinear","missingVector"));var o=new n(r[0]-i[0],r[1]-i[1],r[2]-i[2]).normalize(),a=new n(s[0]-i[0],s[1]-i[1],s[2]-i[2]).normalize();return Math.abs(o.dot(a))>.999},n.computeTriangleNormal=function(r,i,s){if(!r||!i||!s)throw new t(e.logMessage(e.LEVEL_SEVERE,"Vec3","areColinear","missingVector"));var o=(i[1]-r[1])*(s[2]-r[2])-(i[2]-r[2])*(s[1]-r[1]),a=(i[2]-r[2])*(s[0]-r[0])-(i[0]-r[0])*(s[2]-r[2]),l=(i[0]-r[0])*(s[1]-r[1])-(i[1]-r[1])*(s[0]-r[0]),h=o*o+a*a+l*l;return 0===h?new n(o,a,l):(h=Math.sqrt(h),new n(o/h,a/h,l/h))},n.findThreeIndependentVertices=function(e,t){var r=t&&t>0?t:3;if(!e||e.length<3*r)return null;for(var i=new n(e[0],e[1],e[2]),s=null,o=null,a=r;a<e.length&&(s=new n(e[a],e[a+1],e[a+2]),s[0]===i[0]&&s[1]===i[1]&&s[2]===i[2]);a+=r)s=null;if(!s)return null;for(a+=r;a<e.length&&(o=new n(e[a],e[a+1],e[a+2]),o[0]===i[0]&&o[1]===i[1]&&o[2]===i[2]||o[0]===s[0]&&o[1]===s[1]&&o[2]===s[2]||n.areColinear(i,s,o));a+=r)o=null;return o?[i,s,o]:null},n.computeBufferNormal=function(e,t){var r=n.findThreeIndependentVertices(e,t);return r?n.computeTriangleNormal(r[0],r[1],r[2]):null},n.fromVec3=function(e){return new n(e[0],e[1],e[2])},n.zero=function(){return new n(0,0,0)},n.prototype.set=function(e,t,n){return this[0]=e,this[1]=t,this[2]=n,this},n.prototype.copy=function(n){if(!n)throw new t(e.logMessage(e.LEVEL_SEVERE,"Vec3","copy","missingVector"));return this[0]=n[0],this[1]=n[1],this[2]=n[2],this},n.prototype.equals=function(e){return this[0]===e[0]&&this[1]===e[1]&&this[2]===e[2]},n.prototype.add=function(n){if(!n)throw new t(e.logMessage(e.LEVEL_SEVERE,"Vec3","add","missingVector"));return this[0]+=n[0],this[1]+=n[1],this[2]+=n[2],this},n.prototype.subtract=function(n){if(!n)throw new t(e.logMessage(e.LEVEL_SEVERE,"Vec3","subtract","missingVector"));return this[0]-=n[0],this[1]-=n[1],this[2]-=n[2],this},n.prototype.multiply=function(e){return this[0]*=e,this[1]*=e,this[2]*=e,this},n.prototype.divide=function(e){return this[0]/=e,this[1]/=e,this[2]/=e,this},n.prototype.multiplyByMatrix=function(n){if(!n)throw new t(e.logMessage(e.LEVEL_SEVERE,"Vec3","multiplyByMatrix","missingMatrix"));var r=n[0]*this[0]+n[1]*this[1]+n[2]*this[2]+n[3],i=n[4]*this[0]+n[5]*this[1]+n[6]*this[2]+n[7],s=n[8]*this[0]+n[9]*this[1]+n[10]*this[2]+n[11],o=n[12]*this[0]+n[13]*this[1]+n[14]*this[2]+n[15];return this[0]=r/o,this[1]=i/o,this[2]=s/o,this},n.prototype.mix=function(n,r){if(!n)throw new t(e.logMessage(e.LEVEL_SEVERE,"Vec3","mix","missingVector"));var i=1-r,s=r;return this[0]=this[0]*i+n[0]*s,this[1]=this[1]*i+n[1]*s,this[2]=this[2]*i+n[2]*s,this},n.prototype.negate=function(){return this[0]=-this[0],this[1]=-this[1],this[2]=-this[2],this},n.prototype.dot=function(n){if(!n)throw new t(e.logMessage(e.LEVEL_SEVERE,"Vec3","dot","missingVector"));return this[0]*n[0]+this[1]*n[1]+this[2]*n[2]},n.prototype.cross=function(n){if(!n)throw new t(e.logMessage(e.LEVEL_SEVERE,"Vec3","cross","missingVector"));var r=this[1]*n[2]-this[2]*n[1],i=this[2]*n[0]-this[0]*n[2],s=this[0]*n[1]-this[1]*n[0];return this[0]=r,this[1]=i,this[2]=s,this},n.prototype.magnitudeSquared=function(){return this.dot(this)},n.prototype.magnitude=function(){return Math.sqrt(this.magnitudeSquared())},n.prototype.normalize=function(){var e=this.magnitude(),t=1/e;return this[0]*=t,this[1]*=t,this[2]*=t,this},n.prototype.distanceToSquared=function(n){if(!n)throw new t(e.logMessage(e.LEVEL_SEVERE,"Vec3","distanceToSquared","missingVector"));var r=this[0]-n[0],i=this[1]-n[1],s=this[2]-n[2];return r*r+i*i+s*s},n.prototype.distanceTo=function(n){if(!n)throw new t(e.logMessage(e.LEVEL_SEVERE,"Vec3","distanceTo","missingVector"));return Math.sqrt(this.distanceToSquared(n))},n.prototype.swap=function(e){var t=this[0];return this[0]=e[0],e[0]=t,t=this[1],this[1]=e[1],e[1]=t,t=this[2],this[2]=e[2],e[2]=t,this},n.prototype.toString=function(){return"("+this[0]+", "+this[1]+", "+this[2]+")"},n}),define("geom/Vec2",["../util/Logger","../error/ArgumentError","../geom/Vec3"],function(e,t,n){"use strict";var r=function(e,t){this[0]=e,this[1]=t};return r.prototype=new Float64Array(2),r.prototype.set=function(e,t){return this[0]=e,this[1]=t,this},r.prototype.copy=function(n){if(!n)throw new t(e.logMessage(e.LEVEL_SEVERE,"Vec2","copy","missingVector"));return this[0]=n[0],this[1]=n[1],this},r.prototype.equals=function(e){return this[0]===e[0]&&this[1]===e[1]},r.average=function(n,r){if(!n||n.length<1)throw new t(e.logMessage(e.LEVEL_SEVERE,"Vec2","average","missingArray"));if(!r)throw new t(e.logMessage(e.LEVEL_SEVERE,"Vec2","average","missingResult"));var i,s=n.length;r[0]=0,r[1]=0;for(var o=0,a=n.length;o<a;o++)i=n[o],r[0]+=i[0]/s,r[1]+=i[1]/s;return r},r.prototype.add=function(n){if(!n)throw new t(e.logMessage(e.LEVEL_SEVERE,"Vec2","add","missingVector"));return this[0]+=n[0],this[1]+=n[1],this},r.prototype.subtract=function(n){if(!n)throw new t(e.logMessage(e.LEVEL_SEVERE,"Vec2","subtract","missingVector"));return this[0]-=n[0],this[1]-=n[1],this},r.prototype.multiply=function(e){return this[0]*=e,this[1]*=e,this},r.prototype.divide=function(e){return this[0]/=e,this[1]/=e,this},r.prototype.mix=function(n,r){if(!n)throw new t(e.logMessage(e.LEVEL_SEVERE,"Vec2","mix","missingVector"));var i=1-r,s=r;return this[0]=this[0]*i+n[0]*s,this[1]=this[1]*i+n[1]*s,this},r.prototype.negate=function(){return this[0]=-this[0],this[1]=-this[1],this},r.prototype.dot=function(n){if(!n)throw new t(e.logMessage(e.LEVEL_SEVERE,"Vec2","dot","missingVector"));return this[0]*n[0]+this[1]*n[1]},r.prototype.magnitudeSquared=function(){return this.dot(this)},r.prototype.magnitude=function(){return Math.sqrt(this.magnitudeSquared())},r.prototype.normalize=function(){var e=this.magnitude(),t=1/e;return this[0]*=t,this[1]*=t,this},r.prototype.distanceToSquared=function(n){if(!n)throw new t(e.logMessage(e.LEVEL_SEVERE,"Vec2","distanceToSquared","missingVector"));var r=this[0]-n[0],i=this[1]-n[1];return r*r+i*i},r.prototype.distanceTo=function(n){if(!n)throw new t(e.logMessage(e.LEVEL_SEVERE,"Vec2","distanceTo","missingVector"));return Math.sqrt(this.distanceToSquared(n))},r.prototype.toVec3=function(){return new n(this[0],this[1],0)},r.prototype.swap=function(e){var t=this[0];return this[0]=e[0],e[0]=t,t=this[1],this[1]=e[1],e[1]=t,this},r.prototype.toString=function(){return"("+this[0]+", "+this[1]+")"},r}),define("util/Offset",["../geom/Vec2"],function(e){"use strict";var t=function(e,t,n,r){this.x=t,this.y=r,this.xUnits=e,this.yUnits=n};return t.prototype.clone=function(){return new t(this.xUnits,this.x,this.yUnits,this.y)},t.prototype.offsetForSize=function(t,n){var r,i;return r=this.xUnits===WorldWind.OFFSET_FRACTION?t*this.x:this.xUnits===WorldWind.OFFSET_INSET_PIXELS?t-this.x:this.x,i=this.yUnits===WorldWind.OFFSET_FRACTION?n*this.y:this.yUnits===WorldWind.OFFSET_INSET_PIXELS?n-this.y:this.y,new e(r,i)},t.prototype.toString=function(){return this.xUnits+" "+this.x+" "+this.yUnits+" "+this.y},t}),define("shapes/TextAttributes",["../util/Color","../util/Font","../util/Offset"],function(e,t,n){"use strict";var r=function(r){this._color=r?r._color.clone():e.WHITE.clone(),this._font=r?r._font:new t(14),this._offset=r?r._offset:new n(WorldWind.OFFSET_FRACTION,.5,WorldWind.OFFSET_FRACTION,0),this._scale=r?r._scale:1,this._depthTest=!!r&&r._depthTest,this._enableOutline=!r||r._enableOutline,this._outlineWidth=r?r._outlineWidth:4,this._outlineColor=r?r._outlineColor:new e(0,0,0,.5),this.stateKeyInvalid=!0};return r.prototype.computeStateKey=function(){return"c "+this._color.toHexString(!0)+" f "+this._font.toString()+" o "+this._offset.toString()+" s "+this._scale+" dt "+this._depthTest+" eo "+this._enableOutline+" ow "+this._outlineWidth+" oc "+this._outlineColor.toHexString(!0)},Object.defineProperties(r.prototype,{stateKey:{get:function(){return this.stateKeyInvalid&&(this._stateKey=this.computeStateKey(),this.stateKeyInvalid=!1),this._stateKey}},color:{get:function(){return this._color},set:function(e){this._color=e,this.stateKeyInvalid=!0}},font:{get:function(){return this._font},set:function(e){this._font=e,this.stateKeyInvalid=!0}},offset:{get:function(){return this._offset},set:function(e){this._offset=e,this.stateKeyInvalid=!0}},scale:{get:function(){return this._scale},set:function(e){this._scale=e,this.stateKeyInvalid=!0}},depthTest:{get:function(){return this._depthTest},set:function(e){this._depthTest=e,this.stateKeyInvalid=!0}},enableOutline:{get:function(){return this._enableOutline},set:function(e){this._enableOutline=e,this.stateKeyInvalid=!0}},outlineWidth:{get:function(){return this._outlineWidth},set:function(e){this._outlineWidth=e,this.stateKeyInvalid=!0}},outlineColor:{get:function(){return this._outlineColor},set:function(e){this._outlineColor=e,this.stateKeyInvalid=!0}}}),r}),define("shapes/AnnotationAttributes",["../util/Color","../util/Font","../util/Insets","../shapes/TextAttributes"],function(e,t,n,r){"use strict";var i=function(t){this._cornerRadius=t?t._cornerRadius:0,this._insets=t?t._insets:new n(0,0,0,0),this._backgroundColor=t?t._backgroundColor.clone():e.WHITE.clone(),this._leaderGapWidth=t?t._leaderGapWidth:40,this._leaderGapHeight=t?t._leaderGapHeight:30,this._opacity=t?t._opacity:1,this._scale=t?t._scale:1,this._drawLeader=!t||t._drawLeader,this._width=t?t._width:200,this._height=t?t._height:100,this._textAttributes=t?t._textAttributes:this.createDefaultTextAttributes(),this.stateKeyInvalid=!0};return i.prototype.computeStateKey=function(){return"wi "+this._width+" he "+this._height+" cr "+this._cornerRadius+" in "+this._insets.toString()+" bg "+this.backgroundColor.toHexString(!0)+" dl "+this.drawLeader+" lgw "+this.leaderGapWidth+" lgh "+this.leaderGapHeight+" op "+this.opacity+" ta "+this._textAttributes.stateKey+" sc "+this.scale},i.prototype.createDefaultTextAttributes=function(){var e=new r(null);return e.enableOutline=!1,e},Object.defineProperties(i.prototype,{width:{get:function(){return this._width},set:function(e){this._width=e,this.stateKeyInvalid=!0}},height:{get:function(){return this._height},set:function(e){this._height=e,this.stateKeyInvalid=!0}},cornerRadius:{get:function(){return this._cornerRadius},set:function(e){this._cornerRadius=e,this.stateKeyInvalid=!0}},insets:{get:function(){return this._insets},set:function(e){this._insets=e,this.stateKeyInvalid=!0}},backgroundColor:{get:function(){return this._backgroundColor},set:function(e){this._backgroundColor=e,this.stateKeyInvalid=!0}},textAttributes:{get:function(){return this._textAttributes},set:function(e){this._textAttributes=e,this.stateKeyInvalid=!0}},drawLeader:{get:function(){return this._drawLeader},set:function(e){this._drawLeader=e,this.stateKeyInvalid=!0}},leaderGapWidth:{get:function(){return this._leaderGapWidth},set:function(e){this._leaderGapWidth=e,this.stateKeyInvalid=!0}},leaderGapHeight:{get:function(){return this._leaderGapHeight},set:function(e){this._leaderGapHeight=e,this.stateKeyInvalid=!0}},opacity:{get:function(){return this._opacity},set:function(e){this._opacity=e,this.stateKeyInvalid=!0}},scale:{get:function(){return this._scale},set:function(e){this._scale=e,this.stateKeyInvalid=!0}},stateKey:{get:function(){return this.stateKeyInvalid&&(this._stateKey=this.computeStateKey(),this.stateKeyInvalid=!1),this._stateKey}}}),i}),define("shaders/GpuShader",["../error/ArgumentError","../util/Logger"],function(e,t){"use strict";var n=function(n,r,i){if(r!==n.VERTEX_SHADER&&r!==n.FRAGMENT_SHADER)throw new e(t.logMessage(t.LEVEL_SEVERE,"GpuShader","constructor","The specified shader type is unrecognized."));if(!i)throw new e(t.logMessage(t.LEVEL_SEVERE,"GpuShader","constructor","The specified shader source is null or undefined."));var s=n.createShader(r);if(!s)throw new e(t.logMessage(t.LEVEL_SEVERE,"GpuShader","constructor","Unable to create shader of type "+(r==n.VERTEX_SHADER?"VERTEX_SHADER.":"FRAGMENT_SHADER.")));if(!this.compile(n,s,r,i)){var o=n.getShaderInfoLog(s);throw n.deleteShader(s),new e(t.logMessage(t.LEVEL_SEVERE,"GpuShader","constructor","Unable to compile shader: "+o))}this.shaderId=s};return n.prototype.compile=function(e,t,n,r){return e.shaderSource(t,r),e.compileShader(t),e.getShaderParameter(t,e.COMPILE_STATUS)},n.prototype.dispose=function(e){this.shaderId&&(e.deleteShader(this.shaderId),delete this.shaderId)},n}),define("shaders/GpuProgram",["../error/ArgumentError","../util/Color","../shaders/GpuShader","../util/Logger"],function(e,t,n,r){"use strict";var i=function(t,i,s,o){if(!i||!s)throw new e(r.logMessage(r.LEVEL_SEVERE,"GpuProgram","constructor","The specified shader source is null or undefined."));var a,l,h;try{l=new n(t,t.VERTEX_SHADER,i),h=new n(t,t.FRAGMENT_SHADER,s)}catch(e){
throw l&&l.dispose(t),h&&h.dispose(t),e}if(!(a=t.createProgram()))throw new e(r.logMessage(r.LEVEL_SEVERE,"GpuProgram","constructor","Unable to create shader program."));if(t.attachShader(a,l.shaderId),t.attachShader(a,h.shaderId),o)for(var u=0,c=o.length;u<c;u++)t.bindAttribLocation(a,u,o[u]);if(!this.link(t,a)){var d=t.getProgramInfoLog(a);throw t.detachShader(a,l.shaderId),t.detachShader(a,h.shaderId),t.deleteProgram(a),l.dispose(t),h.dispose(t),new e(r.logMessage(r.LEVEL_SEVERE,"GpuProgram","constructor","Unable to link shader program: "+d))}this.programId=a,this.attributeLocations={},this.uniformLocations={},this.vertexShader=l,this.fragmentShader=h,this.size=i.length+s.length,this.scratchArray=new Float32Array(16)};return i.prototype.dispose=function(e){this.programId&&(this.vertexShader&&e.detachShader(this.programId,this.vertexShader.shaderId),this.fragmentShader&&e.detachShader(this.programId,this.fragmentShader.shaderId),e.deleteProgram(this.programId),delete this.programId),this.vertexShader&&(this.vertexShader.dispose(e),delete this.vertexShader),this.fragmentShader&&(this.fragmentShader.dispose(e),delete this.fragmentShader),this.attributeLocations={},this.uniformLocations={}},i.prototype.attributeLocation=function(t,n){if(!n||0==n.length)throw new e(r.logMessage(r.LEVEL_SEVERE,"GpuProgram","attributeLocation","The specified attribute name is null, undefined or empty."));var i=this.attributeLocations[n];return i||(i=t.getAttribLocation(this.programId,n),this.attributeLocations[n]=i),i},i.prototype.uniformLocation=function(t,n){if(!n||0==n.length)throw new e(r.logMessage(r.LEVEL_SEVERE,"GpuProgram","uniformLocation","The specified uniform name is null, undefined or empty."));var i=this.uniformLocations[n];return i||(i=t.getUniformLocation(this.programId,n),this.uniformLocations[n]=i),i},i.prototype.link=function(e,t){return e.linkProgram(t),e.getProgramParameter(t,e.LINK_STATUS)},i.prototype.loadUniformMatrix=function(t,n,i){if(!n)throw new e(r.logMessage(r.LEVEL_SEVERE,"GpuProgram","loadUniformMatrix","missingMatrix"));var s=n.columnMajorComponents(this.scratchArray);t.uniformMatrix4fv(i,!1,s)},i.prototype.loadUniformColor=function(t,n,i){if(!n)throw new e(r.logMessage(r.LEVEL_SEVERE,"GpuProgram","loadUniformColor","missingColor"));var s=n.premultipliedComponents(this.scratchArray);t.uniform4f(i,s[0],s[1],s[2],s[3])},i.prototype.loadUniformColorComponents=function(e,t,n,r,i,s){e.uniform4f(s,t*i,n*i,r*i,i)},i}),define("shaders/BasicTextureProgram",["../error/ArgumentError","../util/Color","../shaders/GpuProgram","../util/Logger"],function(e,t,n,r){"use strict";var i=function(e){var t=["vertexPoint","normalVector","vertexTexCoord"];n.call(this,e,"attribute vec4 vertexPoint;\nattribute vec4 vertexTexCoord;\nattribute vec4 normalVector;\nuniform mat4 mvpMatrix;\nuniform mat4 mvInverseMatrix;\nuniform mat4 texCoordMatrix;\nuniform bool applyLighting;\nvarying vec2 texCoord;\nvarying vec4 normal;\nvoid main() {gl_Position = mvpMatrix * vertexPoint;\ntexCoord = (texCoordMatrix * vertexTexCoord).st;\nif (applyLighting) {normal = mvInverseMatrix * normalVector;}\n}","precision mediump float;\nuniform float opacity;\nuniform vec4 color;\nuniform bool enableTexture;\nuniform bool modulateColor;\nuniform sampler2D textureSampler;\nuniform bool applyLighting;\nvarying vec2 texCoord;\nvarying vec4 normal;\nvoid main() {\nvec4 textureColor = texture2D(textureSampler, texCoord);\nfloat ambient = 0.15; vec4 lightDirection = vec4(0, 0, 1, 0);\nif (enableTexture && !modulateColor)\n    gl_FragColor = textureColor * color * opacity;\nelse if (enableTexture && modulateColor)\n    gl_FragColor = color * ceil(textureColor.a);\nelse\n    gl_FragColor = color * opacity;\nif (gl_FragColor.a == 0.0) {discard;}\nif (applyLighting) {\n    vec4 n = normal * (gl_FrontFacing ? 1.0 : -1.0);\n    gl_FragColor.rgb *= clamp(ambient + dot(lightDirection, n), 0.0, 1.0);\n}\n}",t),this.vertexPointLocation=this.attributeLocation(e,"vertexPoint"),this.normalVectorLocation=this.attributeLocation(e,"normalVector"),this.vertexTexCoordLocation=this.attributeLocation(e,"vertexTexCoord"),this.mvpMatrixLocation=this.uniformLocation(e,"mvpMatrix"),this.mvInverseMatrixLocation=this.uniformLocation(e,"mvInverseMatrix"),this.colorLocation=this.uniformLocation(e,"color"),this.textureEnabledLocation=this.uniformLocation(e,"enableTexture"),this.modulateColorLocation=this.uniformLocation(e,"modulateColor"),this.textureUnitLocation=this.uniformLocation(e,"textureSampler"),this.textureMatrixLocation=this.uniformLocation(e,"texCoordMatrix"),this.opacityLocation=this.uniformLocation(e,"opacity"),this.applyLightingLocation=this.uniformLocation(e,"applyLighting")};return i.key="WorldWindGpuBasicTextureProgram",i.prototype=Object.create(n.prototype),i.prototype.loadModelviewInverse=function(t,n){if(!n)throw new e(r.logMessage(r.LEVEL_SEVERE,"BasicTextureProgram","loadModelviewInverse","missingMatrix"));this.loadUniformMatrix(t,n,this.mvInverseMatrixLocation)},i.prototype.loadModelviewProjection=function(t,n){if(!n)throw new e(r.logMessage(r.LEVEL_SEVERE,"BasicTextureProgram","loadModelviewProjection","missingMatrix"));this.loadUniformMatrix(t,n,this.mvpMatrixLocation)},i.prototype.loadColor=function(t,n){if(!n)throw new e(r.logMessage(r.LEVEL_SEVERE,"BasicTextureProgram","loadColor","missingColor"));this.loadUniformColor(t,n,this.colorLocation)},i.prototype.loadTextureEnabled=function(e,t){e.uniform1i(this.textureEnabledLocation,t?1:0)},i.prototype.loadModulateColor=function(e,t){e.uniform1i(this.modulateColorLocation,t?1:0)},i.prototype.loadTextureUnit=function(e,t){e.uniform1i(this.textureUnitLocation,t-e.TEXTURE0)},i.prototype.loadTextureMatrix=function(e,t){this.loadUniformMatrix(e,t,this.textureMatrixLocation)},i.prototype.loadOpacity=function(e,t){e.uniform1f(this.opacityLocation,t)},i.prototype.loadApplyLighting=function(e,t){e.uniform1i(this.applyLightingLocation,t)},i}),define("geom/Line",["../error/ArgumentError","../util/Logger","../geom/Vec3"],function(e,t,n){"use strict";var r=function(n,r){if(!n)throw new e(t.logMessage(t.LEVEL_SEVERE,"Line","constructor","Origin is null or undefined."));if(!r)throw new e(t.logMessage(t.LEVEL_SEVERE,"Line","constructor","Direction is null or undefined."));this.origin=n,this.direction=r};return r.fromSegment=function(i,s){if(!i||!s)throw new e(t.logMessage(t.LEVEL_SEVERE,"Line","fromSegment","missingPoint"));var o=new n(i[0],i[1],i[2]),a=new n(s[0]-i[0],s[1]-i[1],s[2]-i[2]);return new r(o,a)},r.prototype.pointAt=function(n,r){if(!r)throw new e(t.logMessage(t.LEVEL_SEVERE,"Line","pointAt","missingResult."));return r[0]=this.origin[0]+this.direction[0]*n,r[1]=this.origin[1]+this.direction[1]*n,r[2]=this.origin[2]+this.direction[2]*n,r},r.prototype.equals=function(e){return!!e&&(this.origin.equals(e.origin)&&this.direction.equals(e.direction))},r.prototype.clone=function(){var e=new r(new n(0,0,0),new n(0,0,0));return e.copy(this),e},r.prototype.copy=function(n){if(!n)throw new e(t.logMessage(t.LEVEL_SEVERE,"Line","copy","missingLine"));return this.origin.copy(n.origin),this.direction.copy(n.direction),this},r}),define("geom/Plane",["../error/ArgumentError","../geom/Line","../util/Logger","../geom/Vec3"],function(e,t,n,r){"use strict";var i=function(e,t,n,i){this.normal=new r(e,t,n),this.distance=i};return i.fromPoints=function(t,s,o){if(!t||!s||!o)throw new e(n.logMessage(n.LEVEL_SEVERE,"Plane","fromPoints","missingVector"));var a=new r(s[0],s[1],s[2]);a.subtract(t);var l=new r(o[0],o[1],o[2]);l.subtract(t),a.cross(l),a.normalize();var h=-a.dot(t);return new i(a[0],a[1],a[2],h)},i.prototype.dot=function(t){if(!t)throw new e(n.logMessage(n.LEVEL_SEVERE,"Plane","dot","missingVector"));return this.normal.dot(t)+this.distance},i.prototype.distanceToPoint=function(e){return this.dot(e)},i.prototype.transformByMatrix=function(t){if(!t)throw new e(n.logMessage(n.LEVEL_SEVERE,"Plane","transformByMatrix","missingMatrix"));var r=t[0]*this.normal[0]+t[1]*this.normal[1]+t[2]*this.normal[2]+t[3]*this.distance,i=t[4]*this.normal[0]+t[5]*this.normal[1]+t[6]*this.normal[2]+t[7]*this.distance,s=t[8]*this.normal[0]+t[9]*this.normal[1]+t[10]*this.normal[2]+t[11]*this.distance,o=t[12]*this.normal[0]+t[13]*this.normal[1]+t[14]*this.normal[2]+t[15]*this.distance;return this.normal[0]=r,this.normal[1]=i,this.normal[2]=s,this.distance=o,this},i.prototype.normalize=function(){var e=this.normal.magnitude();return 0===e?this:(this.normal.divide(e),this.distance/=e,this)},i.prototype.intersectsSegment=function(e,t){return this.dot(e)*this.dot(t)<=0},i.prototype.intersectsSegmentAt=function(e,t,n){var r=this.dot(e),i=this.dot(t);if(0===r&&0===i)return n[0]=e[0],n[1]=e[1],n[2]=e[2],!0;if(r===i)return!1;var s=-r/(i-r),o=1-s;return n[0]=s*e[0]+o*t[0],n[1]=s*e[1]+o*t[1],n[2]=s*e[2]+o*t[2],r*i<=0},i.prototype.onSameSide=function(t,r){if(!t||!r)throw new e(n.logMessage(n.LEVEL_SEVERE,"Plane","onSameSide","missingPoint"));var i=this.distanceToPoint(t),s=this.distanceToPoint(r);return i<0&&s<0?-1:i>0&&s>0?1:0},i.prototype.clip=function(i,s){if(!i||!s)throw new e(n.logMessage(n.LEVEL_SEVERE,"Plane","clip","missingPoint"));if(i.equals(s))return null;var o,a,l,h=t.fromSegment(i,s),u=this.normal.dot(h.direction);return 0===u?(o=this.dot(h.origin),0===o?[i,s]:null):(a=-this.dot(h.origin)/u)<0||a>1?null:(l=h.pointAt(a,new r(0,0,0)),u>0?[l,s]:[i,l])},i}),define("geom/Rectangle",["../util/Logger"],function(e){"use strict";var t=function(e,t,n,r){this.x=e,this.y=t,this.width=n,this.height=r};return t.prototype.set=function(e,t,n,r){this.x=e,this.y=t,this.width=n,this.height=r},t.prototype.getMinX=function(){return this.x},t.prototype.getMinY=function(){return this.y},t.prototype.getMaxX=function(){return this.x+this.width},t.prototype.getMaxY=function(){return this.y+this.height},t.prototype.containsPoint=function(e){return e[0]>=this.x&&e[0]<=this.x+this.width&&e[1]>=this.y&&e[1]<=this.y+this.height},t.prototype.intersects=function(e){return!(e.x+e.width<this.x)&&(!(e.x>this.x+this.width)&&(!(e.y+e.height<this.y)&&!(e.y>this.y+this.height)))},t.prototype.intersectsRectangles=function(e){if(e)for(var t=0;t<e.length;t++)if(this.intersects(e[t]))return!0;return!1},t.prototype.toString=function(){return this.x+", "+this.y+", "+this.width+", "+this.height},t}),define("util/WWMath",["../geom/Angle","../error/ArgumentError","../geom/Line","../util/Logger","../geom/Rectangle","../geom/Vec3"],function(e,t,n,r,i,s){"use strict";var o={clamp:function(e,t,n){return e<t?t:e>n?n:e},interpolate:function(e,t,n){return(1-e)*t+e*n},cbrt:function(e){return"function"==typeof Math.cbrt?Math.cbrt(e):Math.pow(e,1/3)},computeEllipsoidalGlobeIntersection:function(e,n,i,s){if(!e)throw new t(r.logMessage(r.LEVEL_SEVERE,"WWMath","computeEllipsoidalGlobeIntersection","missingLine"));if(!s)throw new t(r.logMessage(r.LEVEL_SEVERE,"WWMath","computeEllipsoidalGlobeIntersection","missingResult"));var o,a=e.direction[0],l=e.direction[1],h=e.direction[2],u=e.origin[0],c=e.origin[1],d=e.origin[2],f=n/i,p=f*f,m=n*n,g=a*a+p*l*l+h*h,b=2*(u*a+p*c*l+d*h),y=u*u+p*c*c+d*d-m,_=b*b-4*g*y;return!(_<0)&&(o=(-b-Math.sqrt(_))/(2*g),s[0]=u+a*o,s[1]=c+l*o,s[2]=d+h*o,!0)},computeTriangleNormal:function(e,n,i){if(!e||!n||!i)throw new t(r.logMessage(r.LEVEL_SEVERE,"WWMath","computeTriangleNormal","missingVertex"));var o=(n[1]-e[1])*(i[2]-e[2])-(n[2]-e[2])*(i[1]-e[1]),a=(n[2]-e[2])*(i[0]-e[0])-(n[0]-e[0])*(i[2]-e[2]),l=(n[0]-e[0])*(i[1]-e[1])-(n[1]-e[1])*(i[0]-e[0]),h=o*o+a*a+l*l;return 0==h?new s(o,a,l):(h=Math.sqrt(h),new s(o/h,a/h,l/h))},computeTriangleIntersection:function(e,n,i,s,o){if(!e)throw new t(r.logMessage(r.LEVEL_SEVERE,"WWMath","computeTriangleIntersection","missingLine"));if(!n||!i||!s)throw new t(r.logMessage(r.LEVEL_SEVERE,"WWMath","computeTriangleIntersection","missingVertex"));if(!o)throw new t(r.logMessage(r.LEVEL_SEVERE,"WWMath","computeTriangleIntersection","missingResult"));var a=e.direction[0],l=e.direction[1],h=e.direction[2],u=e.origin[0],c=e.origin[1],d=e.origin[2],f=i[0]-n[0],p=i[1]-n[1],m=i[2]-n[2],g=s[0]-n[0],b=s[1]-n[1],y=s[2]-n[2],_=l*y-h*b,E=h*g-a*y,v=a*b-l*g,w=f*_+p*E+m*v;if(w>-1e-5&&w<1e-5)return!1;var S=1/w,T=u-n[0],L=c-n[1],x=d-n[2],R=S*(T*_+L*E+x*v);if(R<-1e-5||R>1+1e-5)return!1;var A=L*m-x*p,C=x*f-T*m,M=T*p-L*f,k=S*(a*A+l*C+h*M);if(k<-1e-5||R+k>1+1e-5)return!1;var I=S*(g*A+b*C+y*M);return!(I<0)&&(o[0]=u+a*I,o[1]=c+l*I,o[2]=d+h*I,!0)},computeTriangleListIntersection:function(e,n,i){if(!e)throw new t(r.logMessage(r.LEVEL_SEVERE,"WWMath","computeIndexedTrianglesIntersection","missingLine"));if(!n)throw new t(r.logMessage(r.LEVEL_SEVERE,"WWMath","computeIndexedTrianglesIntersection","missingPoints"));if(!i)throw new t(r.logMessage(r.LEVEL_SEVERE,"WWMath","computeIndexedTrianglesIntersection","missingResults"));for(var a=new s(0,0,0),l=0,h=n.length;l<h;l+=3)o.computeTriangleIntersection(e,n[l],n[l+1],n[l+2],a)&&(i.push(a),a=new s(0,0,0));return i.length>0},computeIndexedTrianglesIntersection:function(e,n,i,a){if(!e)throw new t(r.logMessage(r.LEVEL_SEVERE,"WWMath","computeIndexedTrianglesIntersection","missingLine"));if(!n)throw new t(r.logMessage(r.LEVEL_SEVERE,"WWMath","computeIndexedTrianglesIntersection","missingPoints"));if(!i)throw new t(r.logMessage(r.LEVEL_SEVERE,"WWMath","computeIndexedTrianglesIntersection","missingIndices"));if(!a)throw new t(r.logMessage(r.LEVEL_SEVERE,"WWMath","computeIndexedTrianglesIntersection","missingResults"));for(var l=new s(0,0,0),h=new s(0,0,0),u=new s(0,0,0),c=new s(0,0,0),d=0,f=i.length;d<f;d+=3){var p=3*i[d],m=3*i[d+1],g=3*i[d+2];l[0]=n[p],l[1]=n[p+1],l[2]=n[p+2],h[0]=n[m],h[1]=n[m+1],h[2]=n[m+2],u[0]=n[g],u[1]=n[g+1],u[2]=n[g+2],o.computeTriangleIntersection(e,l,h,u,c)&&(a.push(c),c=new s(0,0,0))}return a.length>0},computeTriStripIntersections:function(e,n,i,o){if(!e)throw new t(r.logMessage(r.LEVEL_SEVERE,"WWMath","computeTriStripIntersections","missingLine"));if(!n)throw new t(r.logMessage(r.LEVEL_SEVERE,"WWMath","computeTriStripIntersections","missingPoints"));if(!i)throw new t(r.logMessage(r.LEVEL_SEVERE,"WWMath","computeTriStripIntersections","missingIndices"));if(!o)throw new t(r.logMessage(r.LEVEL_SEVERE,"WWMath","computeTriStripIntersections","missingResults"));var a,l,h,u,c,d,f,p,m,g,b,y,_,E,v,w,S,T,L,x,R,A,C,M,k,I,O,P,N,D,F=e.direction[0],B=e.direction[1],W=e.direction[2],V=e.origin[0],G=e.origin[1],j=e.origin[2];D=3*i[0],u=n[D++],c=n[D++],d=n[D],D=3*i[1],f=n[D++],p=n[D++],m=n[D];for(var U=2,z=i.length;U<z;U++)a=u,l=c,h=d,u=f,c=p,d=m,D=3*i[U],f=n[D++],p=n[D++],m=n[D],g=u-a,b=c-l,y=d-h,_=f-a,E=p-l,v=m-h,w=B*v-W*E,S=W*_-F*v,T=F*E-B*_,(P=g*w+b*S+y*T)>-1e-5&&P<1e-5||(N=1/P,L=V-a,x=G-l,R=j-h,(k=N*(L*w+x*S+R*T))<-1e-5||k>1+1e-5||(A=x*y-R*b,C=R*g-L*y,M=L*b-x*g,(I=N*(F*A+B*C+W*M))<-1e-5||k+I>1+1e-5||(O=N*(_*A+E*C+v*M))>=0&&o.push(new s(V+F*O,G+B*O,j+W*O))))},fabs:function(e){return e>=0?e:-e},fmod:function(e,t){return 0===t?0:e-Math.floor(e/t)*t},fract:function(e){return e-Math.floor(e)},mod:function(e,t){return(e%t+t)%t},max:function(e,t){return e>t?e:t},localCoordinateAxesAtPoint:function(e,n,i,s,o){if(!e)throw new t(r.logMessage(r.LEVEL_SEVERE,"WWMath","localCoordinateAxesAtPoint","missingVector"));if(!n)throw new t(r.logMessage(r.LEVEL_SEVERE,"WWMath","localCoordinateAxesAtPoint","missingGlobe"));if(!i||!s||!o)throw new t(r.logMessage(r.LEVEL_SEVERE,"WWMath","localCoordinateAxesAtPoint","missingResult"));var a=e[0],l=e[1],h=e[2];n.surfaceNormalAtPoint(a,l,h,o),n.northTangentAtPoint(a,l,h,s),i.set(s[0],s[1],s[2]),i.cross(o),i.normalize(),s.set(o[0],o[1],o[2]),s.cross(i),s.normalize()},perspectiveNearDistanceForFarDistance:function(e,n,i){if(e<0)throw new t(r.logMessage(r.LEVEL_SEVERE,"WWMath","perspectiveNearDistanceForFarDistance","The specified distance is negative."));if(n<0)throw new t(r.logMessage(r.LEVEL_SEVERE,"WWMath","perspectiveNearDistanceForFarDistance","The specified resolution is negative."));if(i<1)throw new t(r.logMessage(r.LEVEL_SEVERE,"WWMath","perspectiveNearDistanceForFarDistance","The specified depth bits is negative."));var s=(1<<i)-1;return e/(s/(1-n/e)-s+1)},perspectiveNearDistance:function(e,n){if(e<=0||e>=180)throw new t(r.logMessage(r.LEVEL_SEVERE,"WWMath","perspectiveNearDistance","invalidFieldOfView"));if(n<0)throw new t(r.logMessage(r.LEVEL_SEVERE,"WWMath","perspectiveNearDistance","The specified distance is negative."));var i=Math.tan(.5*e/180*Math.PI);return n/(2*Math.sqrt(2*i*i+1))},perspectiveFrustumRectangle:function(e,n,s){if(e<=0)throw new t(r.logMessage(r.LEVEL_SEVERE,"WWMath","perspectiveFrustumRectangle","invalidWidth"));if(n<=0)throw new t(r.logMessage(r.LEVEL_SEVERE,"WWMath","perspectiveFrustumRectangle","invalidHeight"));if(s<0)throw new t(r.logMessage(r.LEVEL_SEVERE,"WWMath","perspectiveFrustumRectangle","The specified distance is negative."));var o=s,a=s*n/e;return new i(-o/2,-a/2,o,a)},perspectivePixelSize:function(e,n,i){if(e<=0)throw new t(r.logMessage(r.LEVEL_SEVERE,"WWMath","perspectivePixelSize","invalidWidth"));if(n<=0)throw new t(r.logMessage(r.LEVEL_SEVERE,"WWMath","perspectivePixelSize","invalidHeight"));if(i<0)throw new t(r.logMessage(r.LEVEL_SEVERE,"WWMath","perspectivePixelSize","The specified distance is negative."));return o.perspectiveFrustumRectangle(e,n,i).height/n},boundingRectForUnitQuad:function(e){if(!e)throw new t(r.logMessage(r.LEVEL_SEVERE,"WWMath","boundingRectForUnitQuad","missingMatrix"));var n=e,s=n[3],o=n[7],a=n[0]+n[3],l=n[4]+n[7],h=n[1]+n[3],u=n[5]+n[7],c=n[0]+n[1]+n[3],d=n[4]+n[5]+n[7],f=Math.min(Math.min(s,a),Math.min(h,c)),p=Math.max(Math.max(s,a),Math.max(h,c)),m=Math.min(Math.min(o,l),Math.min(u,d)),g=Math.max(Math.max(o,l),Math.max(u,d));return new i(f,m,p-f,g-m)},isPowerOfTwo:function(e){return 0!=e&&0==(e&e-1)},signum:function(e){return e>0?1:e<0?-1:0},gudermannianInverse:function(t){return Math.log(Math.tan(Math.PI/4+t*e.DEGREES_TO_RADIANS/2))/Math.PI},epsg3857ToEpsg4326:function(t,n){var r=6378137,i=Math.PI/2-2*Math.atan(Math.exp(-n/r)),s=t/r;return[o.clamp(i*e.RADIANS_TO_DEGREES,-90,90),o.clamp(s*e.RADIANS_TO_DEGREES,-180,180)]},powerOfTwoFloor:function(e){var t=Math.floor(Math.log(e)/Math.log(2));return Math.pow(2,t)},normalizeAngle360:function(e){var t=e%360;return t>=0?t:t<0?360+t:360-t}};return o}),define("geom/Location",["../geom/Angle","../error/ArgumentError","../util/Logger","../geom/Plane","../geom/Vec3","../util/WWMath"],function(e,t,n,r,i,s){"use strict";var o=function(e,t){this.latitude=e,this.longitude=t};return o.ZERO=new o(0,0),o.fromRadians=function(t,n){return new o(t*e.RADIANS_TO_DEGREES,n*e.RADIANS_TO_DEGREES)},o.prototype.copy=function(e){if(!e)throw new t(n.logMessage(n.LEVEL_SEVERE,"Location","copy","missingLocation"));return this.latitude=e.latitude,this.longitude=e.longitude,this},o.prototype.set=function(e,t){return this.latitude=e,this.longitude=t,this},o.prototype.equals=function(e){return e&&e.latitude===this.latitude&&e.longitude===this.longitude},o.interpolateAlongPath=function(e,r,i,s,o){if(!i||!s)throw new t(n.logMessage(n.LEVEL_SEVERE,"Location","interpolateAlongPath","missingLocation"));if(!o)throw new t(n.logMessage(n.LEVEL_SEVERE,"Location","interpolateAlongPath","missingResult"));return e===WorldWind.GREAT_CIRCLE?this.interpolateGreatCircle(r,i,s,o):e&&e===WorldWind.RHUMB_LINE?this.interpolateRhumb(r,i,s,o):this.interpolateLinear(r,i,s,o)},o.interpolateGreatCircle=function(e,r,i,o){if(!r||!i)throw new t(n.logMessage(n.LEVEL_SEVERE,"Location","interpolateGreatCircle","missingLocation"));if(!o)throw new t(n.logMessage(n.LEVEL_SEVERE,"Location","interpolateGreatCircle","missingResult"));if(r.equals(i))return o.latitude=r.latitude,o.longitude=r.longitude,o;var a=s.clamp(e,0,1),l=this.greatCircleAzimuth(r,i),h=this.greatCircleDistance(r,i);return this.greatCircleLocation(r,l,a*h,o)},o.greatCircleAzimuth=function(r,i){if(!r||!i)throw new t(n.logMessage(n.LEVEL_SEVERE,"Location","greatCircleAzimuth","missingLocation"));var s,o,a,l=r.latitude*e.DEGREES_TO_RADIANS,h=i.latitude*e.DEGREES_TO_RADIANS,u=r.longitude*e.DEGREES_TO_RADIANS,c=i.longitude*e.DEGREES_TO_RADIANS;return l==h&&u==c?0:u==c?l>h?180:0:(o=Math.cos(h)*Math.sin(c-u),s=Math.cos(l)*Math.sin(h)-Math.sin(l)*Math.cos(h)*Math.cos(c-u),a=Math.atan2(o,s),isNaN(a)?0:a*e.RADIANS_TO_DEGREES)},o.greatCircleDistance=function(r,i){if(!r||!i)throw new t(n.logMessage(n.LEVEL_SEVERE,"Location","greatCircleDistance","missingLocation"));var s,o,a,l,h=r.latitude*e.DEGREES_TO_RADIANS,u=i.latitude*e.DEGREES_TO_RADIANS,c=r.longitude*e.DEGREES_TO_RADIANS,d=i.longitude*e.DEGREES_TO_RADIANS;return h==u&&c==d?0:(s=Math.sin((u-h)/2),o=Math.sin((d-c)/2),a=s*s+Math.cos(h)*Math.cos(u)*o*o,l=2*Math.asin(Math.sqrt(a)),isNaN(l)?0:l)},o.greatCircleLocation=function(r,i,s,o){if(!r)throw new t(n.logMessage(n.LEVEL_SEVERE,"Location","greatCircleLocation","missingLocation"));if(!o)throw new t(n.logMessage(n.LEVEL_SEVERE,"Location","greatCircleLocation","missingResult"));if(0==s)return o.latitude=r.latitude,o.longitude=r.longitude,o;var a,l,h=r.latitude*e.DEGREES_TO_RADIANS,u=r.longitude*e.DEGREES_TO_RADIANS,c=i*e.DEGREES_TO_RADIANS;return a=Math.asin(Math.sin(h)*Math.cos(s)+Math.cos(h)*Math.sin(s)*Math.cos(c)),l=u+Math.atan2(Math.sin(s)*Math.sin(c),Math.cos(h)*Math.cos(s)-Math.sin(h)*Math.sin(s)*Math.cos(c)),isNaN(a)||isNaN(l)?(o.latitude=r.latitude,o.longitude=r.longitude):(o.latitude=e.normalizedDegreesLatitude(a*e.RADIANS_TO_DEGREES),o.longitude=e.normalizedDegreesLongitude(l*e.RADIANS_TO_DEGREES)),o},o.interpolateRhumb=function(e,r,i,o){if(!r||!i)throw new t(n.logMessage(n.LEVEL_SEVERE,"Location","interpolateRhumb","missingLocation"));if(!o)throw new t(n.logMessage(n.LEVEL_SEVERE,"Location","interpolateRhumb","missingResult"));if(r.equals(i))return o.latitude=r.latitude,o.longitude=r.longitude,o;var a=s.clamp(e,0,1),l=this.rhumbAzimuth(r,i),h=this.rhumbDistance(r,i);return this.rhumbLocation(r,l,a*h,o)},o.rhumbAzimuth=function(r,i){if(!r||!i)throw new t(n.logMessage(n.LEVEL_SEVERE,"Location","rhumbAzimuth","missingLocation"));var o,a,l,h=r.latitude*e.DEGREES_TO_RADIANS,u=i.latitude*e.DEGREES_TO_RADIANS,c=r.longitude*e.DEGREES_TO_RADIANS,d=i.longitude*e.DEGREES_TO_RADIANS;return h==u&&c==d?0:(o=d-c,a=Math.log(Math.tan(u/2+Math.PI/4)/Math.tan(h/2+Math.PI/4)),s.fabs(o)>Math.PI&&(o=o>0?-(2*Math.PI-o):2*Math.PI+o),l=Math.atan2(o,a),isNaN(l)?0:l*e.RADIANS_TO_DEGREES)},o.rhumbDistance=function(r,i){if(!r||!i)throw new t(n.logMessage(n.LEVEL_SEVERE,"Location","rhumbDistance","missingLocation"));var o,a,l,h,u,c=r.latitude*e.DEGREES_TO_RADIANS,d=i.latitude*e.DEGREES_TO_RADIANS,f=r.longitude*e.DEGREES_TO_RADIANS,p=i.longitude*e.DEGREES_TO_RADIANS;return c==d&&f==p?0:(o=d-c,a=p-f,l=Math.log(Math.tan(d/2+Math.PI/4)/Math.tan(c/2+Math.PI/4)),h=o/l,(isNaN(l)||isNaN(h))&&(h=Math.cos(c)),s.fabs(a)>Math.PI&&(a=a>0?-(2*Math.PI-a):2*Math.PI+a),u=Math.sqrt(o*o+h*h*a*a),isNaN(u)?0:u)},o.rhumbLocation=function(r,i,o,a){if(!r)throw new t(n.logMessage(n.LEVEL_SEVERE,"Location","rhumbLocation","missingLocation"));if(!a)throw new t(n.logMessage(n.LEVEL_SEVERE,"Location","rhumbLocation","missingResult"));if(0==o)return a.latitude=r.latitude,a.longitude=r.longitude,a;var l,h,u=r.latitude*e.DEGREES_TO_RADIANS,c=r.longitude*e.DEGREES_TO_RADIANS,d=i*e.DEGREES_TO_RADIANS,f=u+o*Math.cos(d),p=Math.log(Math.tan(f/2+Math.PI/4)/Math.tan(u/2+Math.PI/4)),m=(f-u)/p;return(isNaN(p)||isNaN(m)||!isFinite(m))&&(m=Math.cos(u)),l=o*Math.sin(d)/m,s.fabs(f)>Math.PI/2&&(f=f>0?Math.PI-f:-Math.PI-f),h=s.fmod(c+l+Math.PI,2*Math.PI)-Math.PI,isNaN(f)||isNaN(h)?(a.latitude=r.latitude,a.longitude=r.longitude):(a.latitude=e.normalizedDegreesLatitude(f*e.RADIANS_TO_DEGREES),a.longitude=e.normalizedDegreesLongitude(h*e.RADIANS_TO_DEGREES)),a},o.interpolateLinear=function(e,r,i,o){if(!r||!i)throw new t(n.logMessage(n.LEVEL_SEVERE,"Location","interpolateLinear","missingLocation"));if(!o)throw new t(n.logMessage(n.LEVEL_SEVERE,"Location","interpolateLinear","missingResult"));if(r.equals(i))return o.latitude=r.latitude,o.longitude=r.longitude,o;var a=s.clamp(e,0,1),l=this.linearAzimuth(r,i),h=this.linearDistance(r,i);return this.linearLocation(r,l,a*h,o)},o.linearAzimuth=function(r,i){if(!r||!i)throw new t(n.logMessage(n.LEVEL_SEVERE,"Location","linearAzimuth","missingLocation"));var o,a,l,h=r.latitude*e.DEGREES_TO_RADIANS,u=i.latitude*e.DEGREES_TO_RADIANS,c=r.longitude*e.DEGREES_TO_RADIANS,d=i.longitude*e.DEGREES_TO_RADIANS;return h==u&&c==d?0:(o=d-c,a=u-h,s.fabs(o)>Math.PI&&(o=o>0?-(2*Math.PI-o):2*Math.PI+o),l=Math.atan2(o,a),isNaN(l)?0:l*e.RADIANS_TO_DEGREES)},o.linearDistance=function(r,i){if(!r||!i)throw new t(n.logMessage(n.LEVEL_SEVERE,"Location","linearDistance","missingLocation"));var o,a,l,h=r.latitude*e.DEGREES_TO_RADIANS,u=i.latitude*e.DEGREES_TO_RADIANS,c=r.longitude*e.DEGREES_TO_RADIANS,d=i.longitude*e.DEGREES_TO_RADIANS;return h==u&&c==d?0:(o=u-h,a=d-c,s.fabs(a)>Math.PI&&(a=a>0?-(2*Math.PI-a):2*Math.PI+a),l=Math.sqrt(o*o+a*a),isNaN(l)?0:l)},o.linearLocation=function(r,i,o,a){if(!r)throw new t(n.logMessage(n.LEVEL_SEVERE,"Location","linearLocation","missingLocation"));if(!a)throw new t(n.logMessage(n.LEVEL_SEVERE,"Location","linearLocation","missingResult"));if(0==o)return a.latitude=r.latitude,a.longitude=r.longitude,a;var l,h=r.latitude*e.DEGREES_TO_RADIANS,u=r.longitude*e.DEGREES_TO_RADIANS,c=i*e.DEGREES_TO_RADIANS,d=h+o*Math.cos(c);return s.fabs(d)>Math.PI/2&&(d=d>0?Math.PI-d:-Math.PI-d),l=s.fmod(u+o*Math.sin(c)+Math.PI,2*Math.PI)-Math.PI,isNaN(d)||isNaN(l)?(a.latitude=r.latitude,a.longitude=r.longitude):(a.latitude=e.normalizedDegreesLatitude(d*e.RADIANS_TO_DEGREES),a.longitude=e.normalizedDegreesLongitude(l*e.RADIANS_TO_DEGREES)),a},o.locationsCrossDateLine=function(e){if(!e)throw new t(n.logMessage(n.LEVEL_SEVERE,"Location","locationsCrossDateline","missingLocation"));for(var r=null,i=0,o=e.length;i<o;i+=1){var a=e[i];if(null!=r&&s.signum(r.longitude)!=s.signum(a.longitude)){var l=Math.abs(r.longitude-a.longitude);if(l>180&&l<360)return!0}r=a}return!1},o.greatCircleArcExtremeLocations=function(e){if(!e)throw new t(n.logMessage(n.LEVEL_SEVERE,"Location","greatCircleArcExtremeLocations","missingLocation"));for(var r=null,i=null,s=null,a=0,l=e.length;a<l;a+=1){var h=e[a];if(null!=s){var u=o.greatCircleArcExtremeForTwoLocations(s,h);if(null==u)continue;(null==r||r.latitude>u[0].latitude)&&(r=u[0]),(null==i||i.latitude<u[1].latitude)&&(i=u[1])}s=h}return[r,i]},o.greatCircleArcExtremeForTwoLocations=function(e,r){if(!e||!r)throw new t(n.logMessage(n.LEVEL_SEVERE,"Location","greatCircleArcExtremeForTwoLocations","missingLocation"));var i,a,l,h=null,u=null,c=90,d=-90,f=[e,r];for(i=0,a=f.length;i<a;i+=1)l=f[i],c>=l.latitude&&(c=l.latitude,h=l),d<=l.latitude&&(d=l.latitude,u=l);var p=o.greatCircleAzimuth(e,r),m=o.greatCircleDistance(e,r),g=o.greatCircleExtremeLocationsUsingAzimuth(e,p);for(i=0,a=g.length;i<a;i+=1){l=g[i];var b=o.greatCircleAzimuth(e,l),y=o.greatCircleDistance(e,l);s.signum(b)==s.signum(p)&&y>=0&&y<=m&&(c>=l.latitude&&(c=l.latitude,h=l),d<=l.latitude&&(d=l.latitude,u=l))}return[h,u]},o.greatCircleExtremeLocationsUsingAzimuth=function(r,i){if(!r)throw new t(n.logMessage(n.LEVEL_SEVERE,"Location","greatCircleArcExtremeLocationsUsingAzimuth","missingLocation"));var s=r.latitude,a=i*e.DEGREES_TO_RADIANS,l=-Math.tan(s)/Math.cos(a),h=Math.atan(l),u=h+Math.PI/2,c=h-Math.PI/2;return[o.greatCircleLocation(r,i,u,new o(0,0)),o.greatCircleLocation(r,i,c,new o(0,0))]},o.intersectionWithMeridian=function(e,t,n,s){var o=s.computePointFromLocation(e.latitude,e.longitude,new i(0,0,0)),a=s.computePointFromLocation(t.latitude,t.longitude,new i(0,0,0)),l=s.computePointFromLocation(90,n,new i(0,0,0)),h=s.computePointFromLocation(0,n,new i(0,0,0)),u=r.fromPoints(l,h,i.ZERO),c=new i(0,0,0);if(!u.intersectsSegmentAt(o,a,c))return null;var d=new WorldWind.Position(0,0,0);return s.computePositionFromPoint(c[0],c[1],c[2],d),d.latitude},o.meridianIntersection=function(e,t,n){var r=e.longitude<0?e.longitude+360:e.longitude,i=t.longitude<0?t.longitude+360:t.longitude;if(r===i)return null;var s=n<0?n+360:n,o=(t.latitude-e.latitude)/(i-r);return e.latitude+o*(s-r)},o.poles={NONE:0,NORTH:1,SOUTH:2},o}),define("geom/Position",["../geom/Angle","../error/ArgumentError","../geom/Location","../util/Logger","../util/WWMath"],function(e,t,n,r,i){"use strict";var s=function(e,t,n){this.latitude=e,this.longitude=t,this.altitude=n};return s.ZERO=new s(0,0,0),s.fromRadians=function(t,n,r){return new s(t*e.RADIANS_TO_DEGREES,n*e.RADIANS_TO_DEGREES,r)},s.prototype.copy=function(e){if(!e)throw new t(r.logMessage(r.LEVEL_SEVERE,"Position","copy","missingPosition"));return this.latitude=e.latitude,this.longitude=e.longitude,this.altitude=e.altitude,this},s.prototype.equals=function(e){return e&&e.latitude===this.latitude&&e.longitude===this.longitude&&e.altitude===this.altitude},s.interpolateGreatCircle=function(e,s,o,a){if(!s||!o)throw new t(r.logMessage(r.LEVEL_SEVERE,"Position","interpolateGreatCircle","missingPosition"));if(!a)throw new t(r.logMessage(r.LEVEL_SEVERE,"Position","interpolateGreatCircle","missingResult"));var l=i.clamp(e,0,1);return a.altitude=i.interpolate(l,s.altitude,o.altitude),n.interpolateGreatCircle(l,s,o,a),a},s.interpolateRhumb=function(e,s,o,a){if(!s||!o)throw new t(r.logMessage(r.LEVEL_SEVERE,"Position","interpolateRhumb","missingPosition"));if(!a)throw new t(r.logMessage(r.LEVEL_SEVERE,"Position","interpolateRhumb","missingResult"));var l=i.clamp(e,0,1);return a.altitude=i.interpolate(l,s.altitude,o.altitude),n.interpolateRhumb(l,s,o,a),a},s.interpolateLinear=function(e,s,o,a){if(!s||!o)throw new t(r.logMessage(r.LEVEL_SEVERE,"Position","interpolateLinear","missingPosition"));if(!a)throw new t(r.logMessage(r.LEVEL_SEVERE,"Position","interpolateLinear","missingResult"));var l=i.clamp(e,0,1);return a.altitude=i.interpolate(l,s.altitude,o.altitude),n.interpolateLinear(l,s,o,a),a},s.prototype.toString=function(){return"("+this.latitude.toString()+"°, "+this.longitude.toString()+"°, "+this.altitude.toString()+")"},s}),define("render/Texture",["../error/ArgumentError","../util/Logger","../util/WWMath"],function(e,t,n){"use strict";var r=function(r,i,s){if(!r)throw new e(t.logMessage(t.LEVEL_SEVERE,"Texture","constructor","missingGlContext"));if(!i)throw new e(t.logMessage(t.LEVEL_SEVERE,"Texture","constructor","missingImage"));s||(s=r.CLAMP_TO_EDGE);var o=r.createTexture(),a=n.isPowerOfTwo(i.width)&&n.isPowerOfTwo(i.height);this.originalImageWidth=i.width,this.originalImageHeight=i.height,s!==r.REPEAT||a||(i=this.resizeImage(i),a=!0),this.imageWidth=i.width,this.imageHeight=i.height,this.size=i.width*i.height*4,r.bindTexture(r.TEXTURE_2D,o),r.pixelStorei(r.UNPACK_PREMULTIPLY_ALPHA_WEBGL,1),r.texImage2D(r.TEXTURE_2D,0,r.RGBA,r.RGBA,r.UNSIGNED_BYTE,i),r.pixelStorei(r.UNPACK_PREMULTIPLY_ALPHA_WEBGL,0),a&&r.generateMipmap(r.TEXTURE_2D),this.textureId=o,this.creationTime=new Date,this.texParameters={},this.texParameters[r.TEXTURE_MIN_FILTER]=a?r.LINEAR_MIPMAP_LINEAR:r.LINEAR,this.texParameters[r.TEXTURE_WRAP_S]=s,this.texParameters[r.TEXTURE_WRAP_T]=s,this.anisotropicFilterExt=r.getExtension("EXT_texture_filter_anisotropic")||r.getExtension("WEBKIT_EXT_texture_filter_anisotropic")};return r.prototype.setTexParameter=function(e,t){this.texParameters[e]=t},r.prototype.getTexParameter=function(e){return this.texParameters[e]},r.prototype.clearTexParameters=function(){this.texParameters={}},r.prototype.dispose=function(e){e.deleteTexture(this.textureId),delete this.textureId},r.prototype.bind=function(e){var t=e.currentGlContext;return t.bindTexture(t.TEXTURE_2D,this.textureId),this.applyTexParameters(e),e.frameStatistics.incrementTextureLoadCount(1),!0},r.prototype.applyTexParameters=function(e){var t=e.currentGlContext,n=e.pickingMode?t.NEAREST:this.texParameters[t.TEXTURE_MIN_FILTER]||t.LINEAR;t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MIN_FILTER,n);var r=e.pickingMode?t.NEAREST:this.texParameters[t.TEXTURE_MAG_FILTER]||t.LINEAR;t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MAG_FILTER,r),
t.texParameteri(t.TEXTURE_2D,t.TEXTURE_WRAP_S,this.texParameters[t.TEXTURE_WRAP_S]||t.CLAMP_TO_EDGE),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_WRAP_T,this.texParameters[t.TEXTURE_WRAP_T]||t.CLAMP_TO_EDGE),r===t.LINEAR&&this.anisotropicFilterExt&&t.texParameteri(t.TEXTURE_2D,this.anisotropicFilterExt.TEXTURE_MAX_ANISOTROPY_EXT,4)},r.prototype.resizeImage=function(e){var t=document.createElement("canvas");return t.width=n.powerOfTwoFloor(e.width),t.height=n.powerOfTwoFloor(e.height),t.getContext("2d").drawImage(e,0,0,t.width,t.height),t},r}),define("geom/Matrix",["../geom/Angle","../error/ArgumentError","../util/Logger","../geom/Plane","../geom/Position","../geom/Rectangle","../render/Texture","../geom/Vec3","../util/WWMath"],function(e,t,n,r,i,s,o,a,l){"use strict";var h=function(e,t,n,r,i,s,o,a,l,h,u,c,d,f,p,m){this[0]=e,this[1]=t,this[2]=n,this[3]=r,this[4]=i,this[5]=s,this[6]=o,this[7]=a,this[8]=l,this[9]=h,this[10]=u,this[11]=c,this[12]=d,this[13]=f,this[14]=p,this[15]=m};return h.prototype=new Float64Array(16),h.fromIdentity=function(){return new h(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)},h.principalAxesFromPoints=function(e,r,i,s){if(!e||e.length<1)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","principalAxesFromPoints","missingPoints"));if(!r||!i||!s)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","principalAxesFromPoints","An axis argument is null or undefined."));var o=h.fromIdentity();o.setToCovarianceOfPoints(e),o.eigensystemFromSymmetricMatrix(r,i,s),r.normalize(),i.normalize(),s.normalize()},h.prototype.set=function(e,t,n,r,i,s,o,a,l,h,u,c,d,f,p,m){return this[0]=e,this[1]=t,this[2]=n,this[3]=r,this[4]=i,this[5]=s,this[6]=o,this[7]=a,this[8]=l,this[9]=h,this[10]=u,this[11]=c,this[12]=d,this[13]=f,this[14]=p,this[15]=m,this},h.prototype.setToIdentity=function(){this[0]=1,this[1]=0,this[2]=0,this[3]=0,this[4]=0,this[5]=1,this[6]=0,this[7]=0,this[8]=0,this[9]=0,this[10]=1,this[11]=0,this[12]=0,this[13]=0,this[14]=0,this[15]=1},h.prototype.copy=function(e){if(!e)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","copy","missingMatrix"));this[0]=e[0],this[1]=e[1],this[2]=e[2],this[3]=e[3],this[4]=e[4],this[5]=e[5],this[6]=e[6],this[7]=e[7],this[8]=e[8],this[9]=e[9],this[10]=e[10],this[11]=e[11],this[12]=e[12],this[13]=e[13],this[14]=e[14],this[15]=e[15]},h.prototype.clone=function(){var e=h.fromIdentity();return e.copy(this),e},h.prototype.equals=function(e){return e&&this[0]==e[0]&&this[1]==e[1]&&this[2]==e[2]&&this[3]==e[3]&&this[4]==e[4]&&this[5]==e[5]&&this[6]==e[6]&&this[7]==e[7]&&this[8]==e[8]&&this[9]==e[9]&&this[10]==e[10]&&this[11]==e[11]&&this[12]==e[12]&&this[13]==e[13]&&this[14]==e[14]&&this[15]==e[15]},h.prototype.columnMajorComponents=function(e){if(!e)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","columnMajorComponents","missingResult"));return e[0]=this[0],e[1]=this[4],e[2]=this[8],e[3]=this[12],e[4]=this[1],e[5]=this[5],e[6]=this[9],e[7]=this[13],e[8]=this[2],e[9]=this[6],e[10]=this[10],e[11]=this[14],e[12]=this[3],e[13]=this[7],e[14]=this[11],e[15]=this[15],e},h.prototype.setToTranslation=function(e,t,n){return this[0]=1,this[1]=0,this[2]=0,this[3]=e,this[4]=0,this[5]=1,this[6]=0,this[7]=t,this[8]=0,this[9]=0,this[10]=1,this[11]=n,this[12]=0,this[13]=0,this[14]=0,this[15]=1,this},h.prototype.setTranslation=function(e,t,n){return this[3]=e,this[7]=t,this[11]=n,this},h.prototype.setToScale=function(e,t,n){return this[0]=e,this[1]=0,this[2]=0,this[3]=0,this[4]=0,this[5]=t,this[6]=0,this[7]=0,this[8]=0,this[9]=0,this[10]=n,this[11]=0,this[12]=0,this[13]=0,this[14]=0,this[15]=1,this},h.prototype.setScale=function(e,t,n){return this[0]=e,this[5]=t,this[10]=n,this},h.prototype.setToTransposeOfMatrix=function(e){if(!e)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","setToTransposeOfMatrix","missingMatrix"));return this[0]=e[0],this[1]=e[4],this[2]=e[8],this[3]=e[12],this[4]=e[1],this[5]=e[5],this[6]=e[9],this[7]=e[13],this[8]=e[2],this[9]=e[6],this[10]=e[10],this[11]=e[14],this[12]=e[3],this[13]=e[7],this[14]=e[11],this[15]=e[15],this},h.prototype.setToMultiply=function(e,r){if(!e||!r)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","setToMultiply","missingMatrix"));var i=e,s=r;return this[0]=i[0]*s[0]+i[1]*s[4]+i[2]*s[8]+i[3]*s[12],this[1]=i[0]*s[1]+i[1]*s[5]+i[2]*s[9]+i[3]*s[13],this[2]=i[0]*s[2]+i[1]*s[6]+i[2]*s[10]+i[3]*s[14],this[3]=i[0]*s[3]+i[1]*s[7]+i[2]*s[11]+i[3]*s[15],this[4]=i[4]*s[0]+i[5]*s[4]+i[6]*s[8]+i[7]*s[12],this[5]=i[4]*s[1]+i[5]*s[5]+i[6]*s[9]+i[7]*s[13],this[6]=i[4]*s[2]+i[5]*s[6]+i[6]*s[10]+i[7]*s[14],this[7]=i[4]*s[3]+i[5]*s[7]+i[6]*s[11]+i[7]*s[15],this[8]=i[8]*s[0]+i[9]*s[4]+i[10]*s[8]+i[11]*s[12],this[9]=i[8]*s[1]+i[9]*s[5]+i[10]*s[9]+i[11]*s[13],this[10]=i[8]*s[2]+i[9]*s[6]+i[10]*s[10]+i[11]*s[14],this[11]=i[8]*s[3]+i[9]*s[7]+i[10]*s[11]+i[11]*s[15],this[12]=i[12]*s[0]+i[13]*s[4]+i[14]*s[8]+i[15]*s[12],this[13]=i[12]*s[1]+i[13]*s[5]+i[14]*s[9]+i[15]*s[13],this[14]=i[12]*s[2]+i[13]*s[6]+i[14]*s[10]+i[15]*s[14],this[15]=i[12]*s[3]+i[13]*s[7]+i[14]*s[11]+i[15]*s[15],this},h.prototype.setToCovarianceOfPoints=function(e){if(!e||e.length<1)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","setToCovarianceOfPoints","missingArray"));var r,i,s,o,l=0,h=0,u=0,c=0,d=0,f=0,p=0,m=new a(0,0,0);r=a.averageOfBuffer(e,new a(0,0,0));for(var g=0,b=e.length/3;g<b;g++)m[0]=e[3*g],m[1]=e[3*g+1],m[2]=e[3*g+2],i=m[0]-r[0],s=m[1]-r[1],o=m[2]-r[2],++l,h+=i*i,u+=s*s,c+=o*o,d+=i*s,f+=i*o,p+=s*o;return this[0]=h/l,this[1]=d/l,this[2]=f/l,this[3]=0,this[4]=d/l,this[5]=u/l,this[6]=p/l,this[7]=0,this[8]=f/l,this[9]=p/l,this[10]=c/l,this[11]=0,this[12]=0,this[13]=0,this[14]=0,this[15]=0,this},h.prototype.multiplyByTranslation=function(e,t,n){return this.multiply(1,0,0,e,0,1,0,t,0,0,1,n,0,0,0,1),this},h.prototype.multiplyByRotation=function(t,n,r,i){var s=Math.cos(i*e.DEGREES_TO_RADIANS),o=Math.sin(i*e.DEGREES_TO_RADIANS);return this.multiply(s+(1-s)*t*t,(1-s)*t*n-o*r,(1-s)*t*r+o*n,0,(1-s)*t*n+o*r,s+(1-s)*n*n,(1-s)*n*r-o*t,0,(1-s)*t*r-o*n,(1-s)*n*r+o*t,s+(1-s)*r*r,0,0,0,0,1),this},h.prototype.multiplyByScale=function(e,t,n){return this.multiply(e,0,0,0,0,t,0,0,0,0,n,0,0,0,0,1),this},h.prototype.setToUnitYFlip=function(){return this[0]=1,this[1]=0,this[2]=0,this[3]=0,this[4]=0,this[5]=-1,this[6]=0,this[7]=1,this[8]=0,this[9]=0,this[10]=1,this[11]=0,this[12]=0,this[13]=0,this[14]=0,this[15]=1,this},h.prototype.multiplyByLocalCoordinateTransform=function(e,r){if(!e)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","multiplyByLocalCoordinateTransform","Origin vector is null or undefined"));if(!r)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","multiplyByLocalCoordinateTransform","missingGlobe"));var i=new a(0,0,0),s=new a(0,0,0),o=new a(0,0,0);return l.localCoordinateAxesAtPoint(e,r,i,s,o),this.multiply(i[0],s[0],o[0],e[0],i[1],s[1],o[1],e[1],i[2],s[2],o[2],e[2],0,0,0,1),this},h.prototype.multiplyByTextureTransform=function(e){if(!e)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","multiplyByTextureTransform","missingTexture"));var r=e.originalImageWidth/e.imageWidth,i=e.originalImageHeight/e.imageHeight;return this.multiply(r,0,0,0,0,-i,0,i,0,0,1,0,0,0,0,1),this},h.prototype.extractTranslation=function(e){if(!e)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","extractTranslation","missingResult"));return e[0]=this[3],e[1]=this[7],e[2]=this[11],e},h.prototype.extractRotationAngles=function(r){if(!r)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","extractRotationAngles","missingResult"));var i=Math.atan2(this[6],this[10]),s=Math.atan2(-this[2],Math.sqrt(this[0]*this[0]+this[1]*this[1])),o=Math.cos(i),a=Math.sin(i),l=Math.atan2(a*this[8]-o*this[4],o*this[5]-a*this[9]);return r[0]=i*e.RADIANS_TO_DEGREES,r[1]=s*e.RADIANS_TO_DEGREES,r[2]=l*e.RADIANS_TO_DEGREES,r},h.prototype.multiplyByFirstPersonModelview=function(r,i,s,o,h){if(!r)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","multiplyByFirstPersonModelview","missingPosition"));if(!h)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","multiplyByFirstPersonModelview","missingGlobe"));var u,c,d,f,p,m,g,b,y,_,E,v,w,S,T=new a(0,0,0),L=new a(0,0,0),x=new a(0,0,0),R=new a(0,0,0);return u=Math.cos(o*e.DEGREES_TO_RADIANS),c=Math.sin(o*e.DEGREES_TO_RADIANS),this.multiply(u,c,0,0,-c,u,0,0,0,0,1,0,0,0,0,1),u=Math.cos(s*e.DEGREES_TO_RADIANS),c=Math.sin(s*e.DEGREES_TO_RADIANS),this.multiply(1,0,0,0,0,u,c,0,0,-c,u,0,0,0,0,1),u=Math.cos(i*e.DEGREES_TO_RADIANS),c=Math.sin(i*e.DEGREES_TO_RADIANS),this.multiply(u,-c,0,0,c,u,0,0,0,0,1,0,0,0,0,1),h.computePointFromPosition(r.latitude,r.longitude,r.altitude,T),d=T[0],f=T[1],p=T[2],l.localCoordinateAxesAtPoint(T,h,L,x,R),m=L[0],g=L[1],b=L[2],y=x[0],_=x[1],E=x[2],v=R[0],w=R[1],S=R[2],this.multiply(m,g,b,-m*d-g*f-b*p,y,_,E,-y*d-_*f-E*p,v,w,S,-v*d-w*f-S*p,0,0,0,1),this},h.prototype.multiplyByLookAtModelview=function(e,r,i,s,o,a){if(!e)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","multiplyByLookAtModelview","missingPosition"));if(r<0)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","multiplyByLookAtModelview","Range is less than zero"));if(!a)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","multiplyByLookAtModelview","missingGlobe"));return this.multiplyByTranslation(0,0,-r),this.multiplyByFirstPersonModelview(e,i,s,o,a),this},h.prototype.setToPerspectiveProjection=function(e,r,i,s,o){if(e<=0)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","setToPerspectiveProjection","invalidWidth"));if(r<=0)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","setToPerspectiveProjection","invalidHeight"));if(i<=0||i>=180)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","setToPerspectiveProjection","invalidFieldOfView"));if(s===o)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","setToPerspectiveProjection","Near and far distance are the same."));if(s<=0||o<=0)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","setToPerspectiveProjection","Near or far distance is less than or equal to zero."));var a=e/r,l=Math.tan(.5*i/180*Math.PI),h=2*s*l,u=h*a;return this[0]=2*s/u,this[1]=0,this[2]=0,this[3]=0,this[4]=0,this[5]=2*s/h,this[6]=0,this[7]=0,this[8]=0,this[9]=0,this[10]=-(o+s)/(o-s),this[11]=-2*s*o/(o-s),this[12]=0,this[13]=0,this[14]=-1,this[15]=0,this},h.prototype.setToScreenProjection=function(e,r){if(e<=0)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","setToScreenProjection","invalidWidth"));if(r<=0)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","setToScreenProjection","invalidHeight"));return this[0]=2/e,this[1]=0,this[2]=0,this[3]=-1,this[4]=0,this[5]=2/r,this[6]=0,this[7]=-1,this[8]=0,this[9]=0,this[10]=2,this[11]=-1,this[12]=0,this[13]=0,this[14]=0,this[15]=1,this},h.prototype.extractEyePoint=function(e){if(!e)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","extractEyePoint","missingResult"));return e[0]=-this[0]*this[3]-this[4]*this[7]-this[8]*this[11],e[1]=-this[1]*this[3]-this[5]*this[7]-this[9]*this[11],e[2]=-this[2]*this[3]-this[6]*this[7]-this[10]*this[11],e},h.prototype.extractHeading=function(t){var n=t*e.DEGREES_TO_RADIANS,r=Math.cos(n),i=Math.sin(n),s=r*this[0]-i*this[4],o=i*this[5]-r*this[1];return Math.atan2(o,s)*e.RADIANS_TO_DEGREES},h.prototype.extractTilt=function(){var t=this[10],n=Math.sqrt(this[2]*this[2]+this[6]*this[6]);return Math.atan2(n,t)*e.RADIANS_TO_DEGREES},h.prototype.extractForwardVector=function(e){if(!e)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","extractForwardVector","missingResult"));return e[0]=-this[8],e[1]=-this[9],e[2]=-this[10],e},h.prototype.extractViewingParameters=function(r,s,o,a){if(!r)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","extractViewingParameters","The specified origin is null or undefined."));if(!o)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","extractViewingParameters","missingGlobe"));if(!a)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","extractViewingParameters","missingResult"));var l,u,c,d,f,p,m,g,b,y=new i(0,0,0),_=h.fromIdentity();return o.computePositionFromPoint(r[0],r[1],r[2],y),_.copy(this),_.multiplyByLocalCoordinateTransform(r,o),l=-_[11],u=_[10],c=Math.sqrt(_[2]*_[2]+_[6]*_[6]),d=Math.atan2(c,u)*e.RADIANS_TO_DEGREES,f=Math.cos(s*e.DEGREES_TO_RADIANS),p=Math.sin(s*e.DEGREES_TO_RADIANS),m=f*_[0]-p*_[4],g=p*_[5]-f*_[1],b=Math.atan2(g,m)*e.RADIANS_TO_DEGREES,a.origin=y,a.range=l,a.heading=b,a.tilt=d,a.roll=s,a},h.prototype.offsetProjectionDepth=function(e){return this[10]*=1+e,this},h.prototype.multiplyMatrix=function(e){if(!e)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","multiplyMatrix","missingMatrix"));var r,i,s,o,a=this,l=e;return r=a[0],i=a[1],s=a[2],o=a[3],a[0]=r*l[0]+i*l[4]+s*l[8]+o*l[12],a[1]=r*l[1]+i*l[5]+s*l[9]+o*l[13],a[2]=r*l[2]+i*l[6]+s*l[10]+o*l[14],a[3]=r*l[3]+i*l[7]+s*l[11]+o*l[15],r=a[4],i=a[5],s=a[6],o=a[7],a[4]=r*l[0]+i*l[4]+s*l[8]+o*l[12],a[5]=r*l[1]+i*l[5]+s*l[9]+o*l[13],a[6]=r*l[2]+i*l[6]+s*l[10]+o*l[14],a[7]=r*l[3]+i*l[7]+s*l[11]+o*l[15],r=a[8],i=a[9],s=a[10],o=a[11],a[8]=r*l[0]+i*l[4]+s*l[8]+o*l[12],a[9]=r*l[1]+i*l[5]+s*l[9]+o*l[13],a[10]=r*l[2]+i*l[6]+s*l[10]+o*l[14],a[11]=r*l[3]+i*l[7]+s*l[11]+o*l[15],r=a[12],i=a[13],s=a[14],o=a[15],a[12]=r*l[0]+i*l[4]+s*l[8]+o*l[12],a[13]=r*l[1]+i*l[5]+s*l[9]+o*l[13],a[14]=r*l[2]+i*l[6]+s*l[10]+o*l[14],a[15]=r*l[3]+i*l[7]+s*l[11]+o*l[15],this},h.prototype.multiply=function(e,t,n,r,i,s,o,a,l,h,u,c,d,f,p,m){var g,b,y,_,E=this;return g=E[0],b=E[1],y=E[2],_=E[3],E[0]=g*e+b*i+y*l+_*d,E[1]=g*t+b*s+y*h+_*f,E[2]=g*n+b*o+y*u+_*p,E[3]=g*r+b*a+y*c+_*m,g=E[4],b=E[5],y=E[6],_=E[7],E[4]=g*e+b*i+y*l+_*d,E[5]=g*t+b*s+y*h+_*f,E[6]=g*n+b*o+y*u+_*p,E[7]=g*r+b*a+y*c+_*m,g=E[8],b=E[9],y=E[10],_=E[11],E[8]=g*e+b*i+y*l+_*d,E[9]=g*t+b*s+y*h+_*f,E[10]=g*n+b*o+y*u+_*p,E[11]=g*r+b*a+y*c+_*m,g=E[12],b=E[13],y=E[14],_=E[15],E[12]=g*e+b*i+y*l+_*d,E[13]=g*t+b*s+y*h+_*f,E[14]=g*n+b*o+y*u+_*p,E[15]=g*r+b*a+y*c+_*m,this},h.prototype.invertMatrix=function(e){if(!e)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","invertMatrix","missingMatrix"));var r=[[],[],[],[]];r[0][0]=e[0],r[0][1]=e[1],r[0][2]=e[2],r[0][3]=e[3],r[1][0]=e[4],r[1][1]=e[5],r[1][2]=e[6],r[1][3]=e[7],r[2][0]=e[8],r[2][1]=e[9],r[2][2]=e[10],r[2][3]=e[11],r[3][0]=e[12],r[3][1]=e[13],r[3][2]=e[14],r[3][3]=e[15];var i,s,o=[],a=h.ludcmp(r,o);for(i=0;i<4;i+=1)a*=r[i][i];if(Math.abs(a)<1e-8)return null;var l=[[],[],[],[]],u=[];for(s=0;s<4;s+=1){for(i=0;i<4;i+=1)u[i]=0;for(u[s]=1,h.lubksb(r,o,u),i=0;i<4;i+=1)l[i][s]=u[i]}return this[0]=l[0][0],this[1]=l[0][1],this[2]=l[0][2],this[3]=l[0][3],this[4]=l[1][0],this[5]=l[1][1],this[6]=l[1][2],this[7]=l[1][3],this[8]=l[2][0],this[9]=l[2][1],this[10]=l[2][2],this[11]=l[2][3],this[12]=l[3][0],this[13]=l[3][1],this[14]=l[3][2],this[15]=l[3][3],this},h.lubksb=function(e,t,n){var r,i,s,o=-1;for(r=0;r<4;r+=1){var a=t[r];if(s=n[a],n[a]=n[r],-1!=o)for(i=o;i<=r-1;i+=1)s-=e[r][i]*n[i];else 0!=s&&(o=r);n[r]=s}for(r=3;r>=0;r-=1){for(s=n[r],i=r+1;i<4;i+=1)s-=e[r][i]*n[i];n[r]=s/e[r][r]}},h.ludcmp=function(e,t){var n,r,i,s,o,a,l,h,u=[],c=1;for(r=0;r<4;r+=1){for(o=0,i=0;i<4;i+=1)(n=Math.abs(e[r][i]))>o&&(o=n);if(0==o)return 0;u[r]=1/o}for(i=0;i<4;i+=1){for(r=0;r<i;r+=1){for(a=e[r][i],s=0;s<r;s+=1)a-=e[r][s]*e[s][i];e[r][i]=a}for(o=0,l=-1,r=i;r<4;r+=1){for(a=e[r][i],s=0;s<i;s++)a-=e[r][s]*e[s][i];e[r][i]=a,(h=u[r]*Math.abs(a))>=o&&(o=h,l=r)}if(i!=l){for(s=0;s<4;s+=1)h=e[l][s],e[l][s]=e[i][s],e[i][s]=h;c=-c,u[l]=u[i]}if(t[i]=l,0==e[i][i]&&(e[i][i]=1e-20),3!=i)for(h=1/e[i][i],r=i+1;r<4;r+=1)e[r][i]*=h}return c},h.prototype.invertOrthonormalMatrix=function(e){if(!e)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","invertOrthonormalMatrix","missingMatrix"));var r=e;return this[0]=r[0],this[1]=r[4],this[2]=r[8],this[3]=0-r[0]*r[3]-r[4]*r[7]-r[8]*r[11],this[4]=r[1],this[5]=r[5],this[6]=r[9],this[7]=0-r[1]*r[3]-r[5]*r[7]-r[9]*r[11],this[8]=r[2],this[9]=r[6],this[10]=r[10],this[11]=0-r[2]*r[3]-r[6]*r[7]-r[10]*r[11],this[12]=0,this[13]=0,this[14]=0,this[15]=1,this},h.prototype.eigensystemFromSymmetricMatrix=function(e,r,i){if(!e||!r||!i)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","eigensystemFromSymmetricMatrix","missingResult"));if(this[1]!=this[4]||this[2]!=this[8]||this[6]!=this[9])throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","eigensystemFromSymmetricMatrix","Matrix is not symmetric"));for(var s,o,a,h,u,c,d,f,p,m,g,b=this[0],y=this[1],_=this[2],E=this[5],v=this[6],w=this[10],S=[[1,0,0],[0,1,0],[0,0,1]],T=0;T<32&&!(l.fabs(y)<1e-10&&l.fabs(_)<1e-10&&l.fabs(v)<1e-10);T++){if(0!=y)for(s=.5*(E-b)/y,o=s*s,a=o+1,h=a!=o?(s<0?-1:1)*(Math.sqrt(a)-l.fabs(s)):.5/s,u=1/Math.sqrt(h*h+1),c=u*h,b-=h*y,E+=h*y,y=0,d=u*_-c*v,v=c*_+u*v,_=d,f=0;f<3;f++)d=u*S[f][0]-c*S[f][1],S[f][1]=c*S[f][0]+u*S[f][1],S[f][0]=d;if(0!=_)for(s=.5*(w-b)/_,o=s*s,a=o+1,h=a!=o?(s<0?-1:1)*(Math.sqrt(a)-l.fabs(s)):.5/s,u=1/Math.sqrt(h*h+1),c=u*h,b-=h*_,w+=h*_,_=0,d=u*y-c*v,v=c*y+u*v,y=d,f=0;f<3;f++)d=u*S[f][0]-c*S[f][2],S[f][2]=c*S[f][0]+u*S[f][2],S[f][0]=d;if(0!=v)for(s=.5*(w-E)/v,o=s*s,a=o+1,h=a!=o?(s<0?-1:1)*(Math.sqrt(a)-l.fabs(s)):.5/s,u=1/Math.sqrt(h*h+1),c=u*h,E-=h*v,w+=h*v,v=0,d=u*y-c*_,_=c*y+u*_,y=d,f=0;f<3;f++)d=u*S[f][1]-c*S[f][2],S[f][2]=c*S[f][1]+u*S[f][2],S[f][1]=d}p=0,m=1,g=2,b<E&&(d=b,b=E,E=d,d=p,p=m,m=d),E<w&&(d=E,E=w,w=d,d=m,m=g,g=d),b<E&&(d=b,b=E,E=d,d=p,p=m,m=d),e[0]=S[0][p],e[1]=S[1][p],e[2]=S[2][p],r[0]=S[0][m],r[1]=S[1][m],r[2]=S[2][m],i[0]=S[0][g],i[1]=S[1][g],i[2]=S[2][g],e.normalize(),r.normalize(),i.normalize(),e.multiply(b),r.multiply(E),i.multiply(w)},h.prototype.upper3By3=function(){var e=h.fromIdentity();return e[0]=this[0],e[1]=this[1],e[2]=this[2],e[4]=this[4],e[5]=this[5],e[6]=this[6],e[8]=this[8],e[9]=this[9],e[10]=this[10],e},h.prototype.project=function(e,r,i,s,o){if(!s)throw new t(n.logMessage(n.ERROR,"Matrix","project","missingViewport"));if(!o)throw new t(n.logMessage(n.ERROR,"Matrix","project","missingResult"));var a=this[0]*e+this[1]*r+this[2]*i+this[3],l=this[4]*e+this[5]*r+this[6]*i+this[7],h=this[8]*e+this[9]*r+this[10]*i+this[11],u=this[12]*e+this[13]*r+this[14]*i+this[15];return 0!==u&&(a/=u,l/=u,!((h/=u)<-1||h>1)&&(a=.5*a+.5,l=.5*l+.5,h=.5*h+.5,a=a*s.width+s.x,l=l*s.height+s.y,o[0]=a,o[1]=l,o[2]=h,!0))},h.prototype.unProject=function(e,r,i){if(!e)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","unProject","missingPoint"));if(!r)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","unProject","missingViewport"));if(!i)throw new t(n.logMessage(n.LEVEL_SEVERE,"Matrix","unProject","missingResult"));var s=e[0],o=e[1],a=e[2];if(s=(s-r.x)/r.width,o=(o-r.y)/r.height,s=2*s-1,o=2*o-1,(a=2*a-1)<-1||a>1)return!1;var l=this[0]*s+this[1]*o+this[2]*a+this[3],h=this[4]*s+this[5]*o+this[6]*a+this[7],u=this[8]*s+this[9]*o+this[10]*a+this[11],c=this[12]*s+this[13]*o+this[14]*a+this[15];return 0!==c&&(i[0]=l/c,i[1]=h/c,i[2]=u/c,!0)},h.prototype.toString=function(){return"("+this[0]+", "+this[1]+", "+this[2]+", "+this[3]+")\n("+this[4]+", "+this[5]+", "+this[6]+", "+this[7]+")\n("+this[8]+", "+this[9]+", "+this[10]+", "+this[11]+")\n("+this[12]+", "+this[13]+", "+this[14]+", "+this[15]+")"},h}),define("pick/PickedObject",[],function(){"use strict";return function(e,t,n,r,i){this.color=e,this.userObject=t,this.position=n,this.parentLayer=r,this.isTerrain=i,this.isOnTop=!1}}),define("error/UnsupportedOperationError",["../error/AbstractError"],function(e){"use strict";var t=function(t){e.call(this,"UnsupportedOperationError",t);var n;try{throw new Error}catch(e){n=e.stack}this.stack=n};return t.prototype=Object.create(e.prototype),t}),define("render/Renderable",["../util/Logger","../error/UnsupportedOperationError"],function(e,t){"use strict";var n=function(){this.displayName="Renderable",this.enabled=!0,this.pickDelegate=null,this.userProperties={}};return n.prototype.render=function(n){throw new t(e.logMessage(e.LEVEL_SEVERE,"Renderable","render","abstractInvocation"))},n}),define("shapes/Annotation",["../shapes/AnnotationAttributes","../error/ArgumentError","../shaders/BasicTextureProgram","../util/Color","../util/Font","../util/Insets","../util/Logger","../geom/Matrix","../util/Offset","../pick/PickedObject","../render/Renderable","../shapes/TextAttributes","../geom/Vec2","../geom/Vec3","../util/WWMath"],function(e,t,n,r,i,s,o,a,l,h,u,c,d,f,p){"use strict";var m=function(n,r){if(!n)throw new t(o.logMessage(o.LEVEL_SEVERE,"Annotation","constructor","missingPosition"));u.call(this),this.position=n,this.attributes=r||new e(null),this.altitudeMode=WorldWind.ABSOLUTE,this.layer=null,this.lastStateKey=null,this.calloutTransform=a.fromIdentity(),this.calloutOffset=new WorldWind.Offset(WorldWind.OFFSET_FRACTION,.5,WorldWind.OFFSET_FRACTION,0),this.label="",this.labelTexture=null,this.labelTransform=a.fromIdentity(),this.placePoint=new f(0,0,0),this.depthOffset=-2.05,this.calloutPoints=null};return m.matrix=a.fromIdentity(),m.screenPoint=new f(0,0,0),m.scratchPoint=new f(0,0,0),m.prototype=Object.create(u.prototype),Object.defineProperties(m.prototype,{text:{get:function(){return this.label},set:function(e){this.label=e,this.lastStateKey=null}}}),m.prototype.renderOrdered=function(e){if(this.drawOrderedAnnotation(e),e.pickingMode){var t=new h(this.pickColor.clone(),this,this.position,this.layer,!1);e.pickPoint&&this.labelBounds.containsPoint(e.convertPointToViewport(e.pickPoint,m.scratchPoint))&&(t.labelPicked=!0),e.resolvePick(t)}},m.prototype.clone=function(){var e=new m(this.position);return e.copy(this),e.pickDelegate=this.pickDelegate?this.pickDelegate:this,e},m.prototype.copy=function(e){return this.position=e.position,this.enabled=e.enabled,this.attributes=e.attributes,this.label=e.label,this.altitudeMode=e.altitudeMode,this.pickDelegate=e.pickDelegate,this.depthOffset=e.depthOffset,this},m.prototype.render=function(e){if(this.enabled&&e.accumulateOrderedRenderables&&(!e.globe.projectionLimits||e.globe.projectionLimits.containsLocation(this.position.latitude,this.position.longitude))){var t;if(this.lastFrameTime!==e.timestamp)t=this.makeOrderedRenderable(e);else{t=this.clone().makeOrderedRenderable(e)}t&&(t.layer=e.currentLayer,this.lastFrameTime=e.timestamp,e.addOrderedRenderable(t))}},m.prototype.drawOrderedAnnotation=function(e){this.beginDrawing(e);try{this.doDrawOrderedAnnotation(e)}finally{this.endDrawing(e)}},m.prototype.makeOrderedRenderable=function(e){var t,n,r,i,s,o,a,l,h;if(this.attributes.width>0&&(this.label=e.textRenderer.wrap(this.label,this.attributes.width,this.attributes.height)),e.surfacePointForMode(this.position.latitude,this.position.longitude,this.position.altitude,this.altitudeMode,this.placePoint),this.eyeDistance=e.eyePoint.distanceTo(this.placePoint),!e.projectWithDepth(this.placePoint,this.depthOffset,m.screenPoint))return null;this.labelTexture=e.createTextTexture(this.label,this.attributes.textAttributes),t=this.labelTexture.imageWidth,n=this.labelTexture.imageHeight,r=this.attributes.scale,i=this.attributes.insets.left,s=this.attributes.insets.right,o=this.attributes.insets.top,a=this.attributes.insets.bottom,h=this.attributes.leaderGapHeight,l=this.calloutOffset.offsetForSize((t+i+s)*r,(n+o+a)*r),this.calloutTransform.setTranslation(m.screenPoint[0]-l[0],m.screenPoint[1]+h,m.screenPoint[2]),this.labelTransform.setTranslation(m.screenPoint[0]-l[0]+i*r,m.screenPoint[1]+h+a*r,m.screenPoint[2]),this.labelTransform.setScale(t*r,n*r,1),this.labelBounds=p.boundingRectForUnitQuad(this.labelTransform);var u=(t+i+s)*r,c=(n+o+a)*r,d=u/2,f=-h;return this.attributes.drawLeader||(f=0),this.attributes.stateKey!==this.lastStateKey&&(this.calloutPoints=this.createCallout(u,c,d,f,this.attributes.leaderGapWidth,this.attributes.cornerRadius)),this},m.prototype.beginDrawing=function(e){var t,r=e.currentGlContext;e.findAndBindProgram(n),t=e.currentProgram,r.enableVertexAttribArray(t.vertexPointLocation),r.enableVertexAttribArray(t.vertexTexCoordLocation),t.loadModulateColor(r,e.pickingMode)},m.prototype.endDrawing=function(e){var t=e.currentGlContext,n=e.currentProgram;t.disableVertexAttribArray(n.vertexPointLocation),t.disableVertexAttribArray(n.vertexTexCoordLocation),e.bindProgram(null)},m.prototype.drawCorner=function(e,t,n,r,i,s,o,a){if(n<1)return a;for(var l=(i-r)/(s-1),h=1;h<s-1;h++){var u=r+l*h,c=e+Math.cos(u)*n,d=t+Math.sin(u)*n;o[a++]=c,o[a++]=d}return a},m.prototype.createCallout=function(e,t,n,r,i,s){var o=2*(12+(s<1?0:56)),a=new Float32Array(o),l=0;return a[l++]=e/2+i/2,a[l++]=0,a[l++]=e-s,a[l++]=0,l=this.drawCorner(e-s,s,s,-Math.PI/2,0,16,a,l),a[l++]=e,a[l++]=s,a[l++]=e,a[l++]=t-s,l=this.drawCorner(e-s,t-s,s,0,Math.PI/2,16,a,l),a[l++]=e-s,a[l++]=t,a[l++]=s,a[l++]=t,l=this.drawCorner(s,t-s,s,Math.PI/2,Math.PI,16,a,l),a[l++]=0,a[l++]=t-s,a[l++]=0,a[l++]=s,l=this.drawCorner(s,s,s,Math.PI,1.5*Math.PI,16,a,l),a[l++]=s,a[l++]=0,a[l++]=e/2-i/2,a[l++]=0,a[l++]=n,a[l++]=r,a[l++]=e/2+i/2,a[l]=0,a},m.prototype.doDrawOrderedAnnotation=function(e){var t,n=e.currentGlContext,i=e.currentProgram,s=!1;e.pickingMode&&(this.pickColor=e.uniquePickColor()),i.loadOpacity(n,e.pickingMode?1:this.attributes.opacity*this.layer.opacity);var o=this.attributes.stateKey!==this.lastStateKey;this.calloutCacheKey&&!o||(this.calloutCacheKey=e.gpuResourceCache.generateCacheKey());var a=e.gpuResourceCache.resourceForKey(this.calloutCacheKey);a||(a=n.createBuffer(),e.gpuResourceCache.putResource(this.calloutCacheKey,a,4*this.calloutPoints.length),s=!0),o&&this.calloutCacheKey&&e.gpuResourceCache.removeResource(this.calloutCacheKey),this.lastStateKey=this.attributes.stateKey,m.matrix.copy(e.screenProjection),m.matrix.multiplyMatrix(this.calloutTransform),i.loadModelviewProjection(n,m.matrix),n.bindBuffer(n.ARRAY_BUFFER,a),s&&(n.bufferData(n.ARRAY_BUFFER,this.calloutPoints,n.STATIC_DRAW),e.frameStatistics.incrementVboLoadCount(1)),i.loadColor(n,e.pickingMode?this.pickColor:this.attributes.backgroundColor),i.loadTextureEnabled(n,!1),n.vertexAttribPointer(i.vertexPointLocation,2,n.FLOAT,!1,0,0),n.vertexAttribPointer(i.vertexTexCoordLocation,2,n.FLOAT,!1,0,0),n.drawArrays(n.TRIANGLE_FAN,0,this.calloutPoints.length/2),m.matrix.copy(e.screenProjection),m.matrix.multiplyMatrix(this.labelTransform),i.loadModelviewProjection(n,m.matrix),m.matrix.setToIdentity(),m.matrix.multiplyByTextureTransform(this.labelTexture),i.loadTextureMatrix(n,m.matrix),i.loadColor(n,e.pickingMode?this.pickColor:r.WHITE),t=this.labelTexture.bind(e),i.loadTextureEnabled(n,t),n.bindBuffer(n.ARRAY_BUFFER,e.unitQuadBuffer3()),n.vertexAttribPointer(i.vertexPointLocation,3,n.FLOAT,!1,0,0),n.bindBuffer(n.ARRAY_BUFFER,e.unitQuadBuffer()),n.vertexAttribPointer(i.vertexTexCoordLocation,2,n.FLOAT,!1,0,0),n.drawArrays(n.TRIANGLE_STRIP,0,4)},m}),define("util/measure/MeasurerUtils",["../../geom/Location","../../geom/Position"],function(e,t){"use strict";return{subdividePositions:function(n,r,i,s,o){var a,l=[],h=new e(0,0),u=new e(0,0),c=r[0];this.addPosition(n,l,c,i);for(var d=1;d<r.length;d++){var f=r[d],p=e.greatCircleDistance(c,f);h=e.interpolateAlongPath(s,.5,c,f,h);var m=p*n.radiusAt(h.latitude,h.longitude);if(m>o)for(var g=null,b=null,y=Math.ceil(m/o),_=1;_<y;_++){var E=_/y;s===WorldWind.LINEAR?u=e.interpolateLinear(E,c,f,u):s===WorldWind.RHUMB_LINE?(null==g&&(g=e.rhumbAzimuth(c,f),b=e.rhumbDistance(c,f)),u=e.rhumbLocation(c,g,E*b,u)):(null==g&&(g=e.greatCircleAzimuth(c,f),b=e.greatCircleDistance(c,f)),u=e.greatCircleLocation(c,g,E*b,u)),a=i?n.elevationAtLocation(u.latitude,u.longitude):c.altitude*(1-E)+f.altitude*E,l.push(new t(u.latitude,u.longitude,a))}this.addPosition(n,l,f,i),c=f}return l},addPosition:function(e,n,r,i){var s=r.altitude;return i&&(s=e.elevationAtLocation(r.latitude,r.longitude)),n.push(new t(r.latitude,r.longitude,s)),n},isLocationInside:function(e,t){for(var n=!1,r=t[0],i=1,s=t.length;i<s;i++){var o=t[i];(o.latitude<=e.latitude&&e.latitude<r.latitude||r.latitude<=e.latitude&&e.latitude<o.latitude)&&e.longitude<(r.longitude-o.longitude)*(e.latitude-o.latitude)/(r.latitude-o.latitude)+o.longitude&&(n=!n),r=o}return n},angleBetweenVectors:function(e,t){var n=e.dot(t),r=e.magnitude()*t.magnitude();return 0!==r&&1!==r&&(n/=r),n<-1?n=-1:n>1&&(n=1),Math.acos(n)}}}),define("geom/Sector",["../geom/Angle","../error/ArgumentError","../geom/Location","../util/Logger","../geom/Vec3","../util/WWMath"],function(e,t,n,r,i,s){"use strict";var o=function(e,t,n,r){this.minLatitude=e,this.maxLatitude=t,this.minLongitude=n,this.maxLongitude=r};return o.ZERO=new o(0,0,0,0),o.FULL_SPHERE=new o(-90,90,-180,180),o.prototype.copy=function(e){if(!e)throw new t(r.logMessage(r.LEVEL_SEVERE,"Sector","copy","missingSector"));return this.minLatitude=e.minLatitude,this.maxLatitude=e.maxLatitude,this.minLongitude=e.minLongitude,this.maxLongitude=e.maxLongitude,this},o.prototype.isEmpty=function(){return this.minLatitude===this.maxLatitude&&this.minLongitude===this.maxLongitude},o.prototype.deltaLatitude=function(){return this.maxLatitude-this.minLatitude},o.prototype.deltaLongitude=function(){return this.maxLongitude-this.minLongitude},o.prototype.centroidLatitude=function(){return.5*(this.minLatitude+this.maxLatitude)},o.prototype.centroidLongitude=function(){return.5*(this.minLongitude+this.maxLongitude)},o.prototype.centroid=function(e){if(!e)throw new t(r.logMessage(r.LEVEL_SEVERE,"Sector","centroid","missingResult"));return e.latitude=this.centroidLatitude(),e.longitude=this.centroidLongitude(),e},o.prototype.minLatitudeRadians=function(){return this.minLatitude*e.DEGREES_TO_RADIANS},o.prototype.maxLatitudeRadians=function(){return this.maxLatitude*e.DEGREES_TO_RADIANS},o.prototype.minLongitudeRadians=function(){return this.minLongitude*e.DEGREES_TO_RADIANS},o.prototype.maxLongitudeRadians=function(){return this.maxLongitude*e.DEGREES_TO_RADIANS},o.prototype.setToBoundingSector=function(e){if(!e||e.length<2)throw new t(r.logMessage(r.LEVEL_SEVERE,"Sector","setToBoundingSector","missingArray"));for(var n=90,i=-90,s=180,o=-180,a=0,l=e.length;a<l;a+=1){var h=e[a];h&&(n=Math.min(n,h.latitude),i=Math.max(i,h.latitude),s=Math.min(s,h.longitude),o=Math.max(o,h.longitude))}return this.minLatitude=n,this.maxLatitude=i,this.minLongitude=s,this.maxLongitude=o,this},o.splitBoundingSectors=function(e){if(!e||e.length<2)throw new t(r.logMessage(r.LEVEL_SEVERE,"Sector","splitBoundingSectors","missingArray"));for(var n=90,i=180,a=-90,l=-180,h=null,u=0,c=e.length;u<c;u+=1){var d=e[u],f=d.latitude;f<n&&(n=f),f>a&&(a=f);var p=d.longitude;if(p>=0&&p<i&&(i=p),p<=0&&p>l&&(l=p),null!=h){var m=h.longitude;s.signum(p)!=s.signum(m)&&Math.abs(p-m)<180&&(l=0,i=0)}h=d}return n===a&&i===l?null:[new o(n,a,i,180),new o(n,a,-180,l)]},o.prototype.intersects=function(e){return e&&this.minLongitude<=e.maxLongitude&&this.maxLongitude>=e.minLongitude&&this.minLatitude<=e.maxLatitude&&this.maxLatitude>=e.minLatitude},o.prototype.overlaps=function(e){return e&&this.minLongitude<e.maxLongitude&&this.maxLongitude>e.minLongitude&&this.minLatitude<e.maxLatitude&&this.maxLatitude>e.minLatitude},o.prototype.contains=function(e){return e&&this.minLatitude<=e.minLatitude&&this.maxLatitude>=e.maxLatitude&&this.minLongitude<=e.minLongitude&&this.maxLongitude>=e.maxLongitude},o.prototype.containsLocation=function(e,t){return this.minLatitude<=e&&this.maxLatitude>=e&&this.minLongitude<=t&&this.maxLongitude>=t},o.prototype.intersection=function(e){if(!e instanceof o)throw new t(r.logMessage(r.LEVEL_SEVERE,"Sector","intersection","missingSector"));return this.minLatitude<e.minLatitude&&(this.minLatitude=e.minLatitude),this.maxLatitude>e.maxLatitude&&(this.maxLatitude=e.maxLatitude),this.minLongitude<e.minLongitude&&(this.minLongitude=e.minLongitude),this.maxLongitude>e.maxLongitude&&(this.maxLongitude=e.maxLongitude),this.maxLatitude<this.minLatitude&&(this.maxLatitude=this.minLatitude),this.maxLongitude<this.minLongitude&&(this.maxLongitude=this.minLongitude),this},o.prototype.getCorners=function(){var e=[];return e.push(new n(this.minLatitude,this.minLongitude)),e.push(new n(this.minLatitude,this.maxLongitude)),e.push(new n(this.maxLatitude,this.maxLongitude)),e.push(new n(this.maxLatitude,this.minLongitude)),e},o.prototype.computeBoundingPoints=function(e,s){if(null===e)throw new t(r.logMessage(r.LEVEL_SEVERE,"Sector","computeBoundingBox","missingGlobe"));var o=e.minAndMaxElevationsForSector(this),a=o[0]*s,l=o[1]*s;a===l&&(l=a+10)
;for(var h=[],u=this.getCorners(),c=0;c<u.length;c++)h.push(e.computePointFromPosition(u[c].latitude,u[c].longitude,a,new i(0,0,0))),h.push(e.computePointFromPosition(u[c].latitude,u[c].longitude,l,new i(0,0,0)));var d=this.centroid(new n(0,0));if(h.push(e.computePointFromPosition(d.latitude,d.longitude,l,new i(0,0,0))),this.minLatitude<0&&this.maxLatitude>0?(h.push(e.computePointFromPosition(this.minLatitude,d.longitude,l,new i(0,0,0))),h.push(e.computePointFromPosition(this.maxLatitude,d.longitude,l,new i(0,0,0))),h.push(e.computePointFromPosition(0,this.minLongitude,l,new i(0,0,0))),h.push(e.computePointFromPosition(0,this.maxLongitude,l,new i(0,0,0)))):this.minLatitude<0?h.push(e.computePointFromPosition(this.maxLatitude,d.longitude,l,new i(0,0,0))):h.push(e.computePointFromPosition(this.minLatitude,d.longitude,l,new i(0,0,0))),this.deltaLongitude()>=360){var f=this.minLatitude;h.push(e.computePointFromPosition(f,0,l,new i(0,0,0))),h.push(e.computePointFromPosition(f,90,l,new i(0,0,0))),h.push(e.computePointFromPosition(f,-90,l,new i(0,0,0))),h.push(e.computePointFromPosition(f,180,l,new i(0,0,0)));var p=this.maxLatitude;h.push(e.computePointFromPosition(p,0,l,new i(0,0,0))),h.push(e.computePointFromPosition(p,90,l,new i(0,0,0))),h.push(e.computePointFromPosition(p,-90,l,new i(0,0,0))),h.push(e.computePointFromPosition(p,180,l,new i(0,0,0)))}else if(this.deltaLongitude()>180){var m=d.longitude,g=d.latitude,b=(this.minLongitude+m)/2;h.push(e.computePointFromPosition(g,b,l,new i(0,0,0))),b=(m+this.maxLongitude)/2,h.push(e.computePointFromPosition(g,b,l,new i(0,0,0))),h.push(e.computePointFromPosition(g,this.minLongitude,l,new i(0,0,0))),h.push(e.computePointFromPosition(g,this.maxLongitude,l,new i(0,0,0)))}return h},o.prototype.union=function(e){if(!e instanceof o)throw new t(r.logMessage(r.LEVEL_SEVERE,"Sector","union","missingSector"));return this.minLatitude>e.minLatitude&&(this.minLatitude=e.minLatitude),this.maxLatitude<e.maxLatitude&&(this.maxLatitude=e.maxLatitude),this.minLongitude>e.minLongitude&&(this.minLongitude=e.minLongitude),this.maxLongitude<e.maxLongitude&&(this.maxLongitude=e.maxLongitude),this},o.prototype.computeCenterPoint=function(e,n){if(null==e)throw new t(r.logMessage(r.Level.LEVEL_SEVERE,"Sector","computeCornerPoints","missingGlobe"));var s=.5*(this.minLatitude+this.maxLatitude),o=.5*(this.minLongitude+this.maxLongitude);return e.computePointFromPosition(s,o,n*e.elevationAtLocation(s,o),i.zero())},o.prototype.computeCornerPoints=function(e,n){if(!e)throw new t(r.logMessage(r.Level.LEVEL_SEVERE,"Sector","computeCornerPoints","missingGlobe"));var s=new Array(4),o=this.minLatitude,a=this.maxLatitude,l=this.minLongitude,h=this.maxLongitude;s[0]=e.computePointFromPosition(o,l,n*e.elevationAtLocation(o,l),i.zero()),s[1]=e.computePointFromPosition(o,h,n*e.elevationAtLocation(o,h),i.zero()),s[2]=e.computePointFromPosition(a,h,n*e.elevationAtLocation(a,h),i.zero()),s[3]=e.computePointFromPosition(a,l,n*e.elevationAtLocation(a,l),i.zero()),this.cornerPoints=new Array(s.length);for(var u=0,c=s.length;u<c;u++)this.cornerPoints[u]=i.fromVec3(s[u]);return s},o.prototype.distanceTo=function(e,n){if(!e)throw new t(r.logMessage(r.Level.LEVEL_SEVERE,"Sector","distanceTo","missingDc"));if(!n)throw new t(r.logMessage(r.Level.LEVEL_SEVERE,"Sector","distanceTo","missingPoint"));var i=this.computeCornerPoints(e.globe,e.verticalExaggeration),s=this.computeCenterPoint(e.globe,e.verticalExaggeration),o=n.distanceTo(i[0]),a=n.distanceTo(i[1]),l=n.distanceTo(i[2]),h=n.distanceTo(i[3]),u=n.distanceTo(s),c=o;return c>a&&(c=a),c>l&&(c=l),c>h&&(c=h),c>u&&(c=u),c},o});var libtess={};return libtess.DEBUG=!1,libtess.assert=function(e,t){if(libtess.DEBUG&&!e)throw new Error("Assertion failed"+(t?": "+t:""))},libtess.GLU_TESS_MAX_COORD=1e150,libtess.TRUE_PROJECT=!1,libtess.GLU_TESS_DEFAULT_TOLERANCE=0,libtess.windingRule={GLU_TESS_WINDING_ODD:100130,GLU_TESS_WINDING_NONZERO:100131,GLU_TESS_WINDING_POSITIVE:100132,GLU_TESS_WINDING_NEGATIVE:100133,GLU_TESS_WINDING_ABS_GEQ_TWO:100134},libtess.primitiveType={GL_LINE_LOOP:2,GL_TRIANGLES:4,GL_TRIANGLE_STRIP:5,GL_TRIANGLE_FAN:6},libtess.errorType={GLU_TESS_MISSING_BEGIN_POLYGON:100151,GLU_TESS_MISSING_END_POLYGON:100153,GLU_TESS_MISSING_BEGIN_CONTOUR:100152,GLU_TESS_MISSING_END_CONTOUR:100154,GLU_TESS_COORD_TOO_LARGE:100155,GLU_TESS_NEED_COMBINE_CALLBACK:100156},libtess.gluEnum={GLU_TESS_BEGIN:100100,GLU_TESS_VERTEX:100101,GLU_TESS_END:100102,GLU_TESS_ERROR:100103,GLU_TESS_EDGE_FLAG:100104,GLU_TESS_COMBINE:100105,GLU_TESS_BEGIN_DATA:100106,GLU_TESS_VERTEX_DATA:100107,GLU_TESS_END_DATA:100108,GLU_TESS_ERROR_DATA:100109,GLU_TESS_EDGE_FLAG_DATA:100110,GLU_TESS_COMBINE_DATA:100111,GLU_TESS_MESH:100112,GLU_TESS_TOLERANCE:100142,GLU_TESS_WINDING_RULE:100140,GLU_TESS_BOUNDARY_ONLY:100141,GLU_INVALID_ENUM:100900,GLU_INVALID_VALUE:100901},libtess.PQHandle,libtess.geom={},libtess.geom.vertEq=function(e,t){return e.s===t.s&&e.t===t.t},libtess.geom.vertLeq=function(e,t){return e.s<t.s||e.s===t.s&&e.t<=t.t},libtess.geom.edgeEval=function(e,t,n){var r=t.s-e.s,i=n.s-t.s;return r+i>0?r<i?t.t-e.t+(e.t-n.t)*(r/(r+i)):t.t-n.t+(n.t-e.t)*(i/(r+i)):0},libtess.geom.edgeSign=function(e,t,n){var r=t.s-e.s,i=n.s-t.s;return r+i>0?(t.t-n.t)*r+(t.t-e.t)*i:0},libtess.geom.transLeq=function(e,t){return e.t<t.t||e.t===t.t&&e.s<=t.s},libtess.geom.transEval=function(e,t,n){var r=t.t-e.t,i=n.t-t.t;return r+i>0?r<i?t.s-e.s+(e.s-n.s)*(r/(r+i)):t.s-n.s+(n.s-e.s)*(i/(r+i)):0},libtess.geom.transSign=function(e,t,n){var r=t.t-e.t,i=n.t-t.t;return r+i>0?(t.s-n.s)*r+(t.s-e.s)*i:0},libtess.geom.edgeGoesLeft=function(e){return libtess.geom.vertLeq(e.dst(),e.org)},libtess.geom.edgeGoesRight=function(e){return libtess.geom.vertLeq(e.org,e.dst())},libtess.geom.vertL1dist=function(e,t){return Math.abs(e.s-t.s)+Math.abs(e.t-t.t)},libtess.geom.vertCCW=function(e,t,n){return e.s*(t.t-n.t)+t.s*(n.t-e.t)+n.s*(e.t-t.t)>=0},libtess.geom.interpolate_=function(e,t,n,r){return e=e<0?0:e,n=n<0?0:n,e<=n?0===n?(t+r)/2:t+e/(e+n)*(r-t):r+n/(e+n)*(t-r)},libtess.geom.edgeIntersect=function(e,t,n,r,i){var s,o,a;libtess.geom.vertLeq(e,t)||(a=e,e=t,t=a),libtess.geom.vertLeq(n,r)||(a=n,n=r,r=a),libtess.geom.vertLeq(e,n)||(a=e,e=n,n=a,a=t,t=r,r=a),libtess.geom.vertLeq(n,t)?libtess.geom.vertLeq(t,r)?(s=libtess.geom.edgeEval(e,n,t),o=libtess.geom.edgeEval(n,t,r),s+o<0&&(s=-s,o=-o),i.s=libtess.geom.interpolate_(s,n.s,o,t.s)):(s=libtess.geom.edgeSign(e,n,t),o=-libtess.geom.edgeSign(e,r,t),s+o<0&&(s=-s,o=-o),i.s=libtess.geom.interpolate_(s,n.s,o,r.s)):i.s=(n.s+t.s)/2,libtess.geom.transLeq(e,t)||(a=e,e=t,t=a),libtess.geom.transLeq(n,r)||(a=n,n=r,r=a),libtess.geom.transLeq(e,n)||(a=e,e=n,n=a,a=t,t=r,r=a),libtess.geom.transLeq(n,t)?libtess.geom.transLeq(t,r)?(s=libtess.geom.transEval(e,n,t),o=libtess.geom.transEval(n,t,r),s+o<0&&(s=-s,o=-o),i.t=libtess.geom.interpolate_(s,n.t,o,t.t)):(s=libtess.geom.transSign(e,n,t),o=-libtess.geom.transSign(e,r,t),s+o<0&&(s=-s,o=-o),i.t=libtess.geom.interpolate_(s,n.t,o,r.t)):i.t=(n.t+t.t)/2},libtess.mesh={},libtess.mesh.makeEdge=function(e){var t=libtess.mesh.makeEdgePair_(e.eHead);return libtess.mesh.makeVertex_(t,e.vHead),libtess.mesh.makeVertex_(t.sym,e.vHead),libtess.mesh.makeFace_(t,e.fHead),t},libtess.mesh.meshSplice=function(e,t){var n=!1,r=!1;e!==t&&(t.org!==e.org&&(r=!0,libtess.mesh.killVertex_(t.org,e.org)),t.lFace!==e.lFace&&(n=!0,libtess.mesh.killFace_(t.lFace,e.lFace)),libtess.mesh.splice_(t,e),r||(libtess.mesh.makeVertex_(t,e.org),e.org.anEdge=e),n||(libtess.mesh.makeFace_(t,e.lFace),e.lFace.anEdge=e))},libtess.mesh.deleteEdge=function(e){var t=e.sym,n=!1;e.lFace!==e.rFace()&&(n=!0,libtess.mesh.killFace_(e.lFace,e.rFace())),e.oNext===e?libtess.mesh.killVertex_(e.org,null):(e.rFace().anEdge=e.oPrev(),e.org.anEdge=e.oNext,libtess.mesh.splice_(e,e.oPrev()),n||libtess.mesh.makeFace_(e,e.lFace)),t.oNext===t?(libtess.mesh.killVertex_(t.org,null),libtess.mesh.killFace_(t.lFace,null)):(e.lFace.anEdge=t.oPrev(),t.org.anEdge=t.oNext,libtess.mesh.splice_(t,t.oPrev())),libtess.mesh.killEdge_(e)},libtess.mesh.addEdgeVertex=function(e){var t=libtess.mesh.makeEdgePair_(e),n=t.sym;return libtess.mesh.splice_(t,e.lNext),t.org=e.dst(),libtess.mesh.makeVertex_(n,t.org),t.lFace=n.lFace=e.lFace,t},libtess.mesh.splitEdge=function(e){var t=libtess.mesh.addEdgeVertex(e),n=t.sym;return libtess.mesh.splice_(e.sym,e.sym.oPrev()),libtess.mesh.splice_(e.sym,n),e.sym.org=n.org,n.dst().anEdge=n.sym,n.sym.lFace=e.rFace(),n.winding=e.winding,n.sym.winding=e.sym.winding,n},libtess.mesh.connect=function(e,t){var n=!1,r=libtess.mesh.makeEdgePair_(e),i=r.sym;return t.lFace!==e.lFace&&(n=!0,libtess.mesh.killFace_(t.lFace,e.lFace)),libtess.mesh.splice_(r,e.lNext),libtess.mesh.splice_(i,t),r.org=e.dst(),i.org=t.org,r.lFace=i.lFace=e.lFace,e.lFace.anEdge=i,n||libtess.mesh.makeFace_(r,e.lFace),r},libtess.mesh.zapFace=function(e){var t,n=e.anEdge,r=n.lNext;do{if(t=r,r=t.lNext,t.lFace=null,null===t.rFace()){t.oNext===t?libtess.mesh.killVertex_(t.org,null):(t.org.anEdge=t.oNext,libtess.mesh.splice_(t,t.oPrev()));var i=t.sym;i.oNext===i?libtess.mesh.killVertex_(i.org,null):(i.org.anEdge=i.oNext,libtess.mesh.splice_(i,i.oPrev())),libtess.mesh.killEdge_(t)}}while(t!==n);var s=e.prev,o=e.next;o.prev=s,s.next=o},libtess.mesh.meshUnion=function(e,t){var n=e.fHead,r=e.vHead,i=e.eHead,s=t.fHead,o=t.vHead,a=t.eHead;return s.next!==s&&(n.prev.next=s.next,s.next.prev=n.prev,s.prev.next=n,n.prev=s.prev),o.next!==o&&(r.prev.next=o.next,o.next.prev=r.prev,o.prev.next=r,r.prev=o.prev),a.next!==a&&(i.sym.next.sym.next=a.next,a.next.sym.next=i.sym.next,a.sym.next.sym.next=i,i.sym.next=a.sym.next),e},libtess.mesh.deleteMesh=function(e){},libtess.mesh.makeEdgePair_=function(e){var t=new libtess.GluHalfEdge,n=new libtess.GluHalfEdge,r=e.sym.next;return n.next=r,r.sym.next=t,t.next=e,e.sym.next=n,t.sym=n,t.oNext=t,t.lNext=n,n.sym=t,n.oNext=n,n.lNext=t,t},libtess.mesh.splice_=function(e,t){var n=e.oNext,r=t.oNext;n.sym.lNext=t,r.sym.lNext=e,e.oNext=r,t.oNext=n},libtess.mesh.makeVertex_=function(e,t){var n=t.prev,r=new libtess.GluVertex(t,n);n.next=r,t.prev=r,r.anEdge=e;var i=e;do{i.org=r,i=i.oNext}while(i!==e)},libtess.mesh.makeFace_=function(e,t){var n=t.prev,r=new libtess.GluFace(t,n);n.next=r,t.prev=r,r.anEdge=e,r.inside=t.inside;var i=e;do{i.lFace=r,i=i.lNext}while(i!==e)},libtess.mesh.killEdge_=function(e){var t=e.next,n=e.sym.next;t.sym.next=n,n.sym.next=t},libtess.mesh.killVertex_=function(e,t){var n=e.anEdge,r=n;do{r.org=t,r=r.oNext}while(r!==n);var i=e.prev,s=e.next;s.prev=i,i.next=s},libtess.mesh.killFace_=function(e,t){var n=e.anEdge,r=n;do{r.lFace=t,r=r.lNext}while(r!==n);var i=e.prev,s=e.next;s.prev=i,i.next=s},libtess.normal={},libtess.normal.S_UNIT_X_=1,libtess.normal.S_UNIT_Y_=0,libtess.normal.projectPolygon=function(e,t,n,r){var i=!1,s=[t,n,r];0===t&&0===n&&0===r&&(libtess.normal.computeNormal_(e,s),i=!0);var o,a=libtess.normal.longAxis_(s),l=e.mesh.vHead;if(libtess.TRUE_PROJECT){libtess.normal.normalize_(s);var h=[0,0,0],u=[0,0,0];h[a]=0,h[(a+1)%3]=libtess.normal.S_UNIT_X_,h[(a+2)%3]=libtess.normal.S_UNIT_Y_;var c=libtess.normal.dot_(h,s);for(h[0]-=c*s[0],h[1]-=c*s[1],h[2]-=c*s[2],libtess.normal.normalize_(h),u[0]=s[1]*h[2]-s[2]*h[1],u[1]=s[2]*h[0]-s[0]*h[2],u[2]=s[0]*h[1]-s[1]*h[0],libtess.normal.normalize_(u),o=l.next;o!==l;o=o.next)o.s=libtess.normal.dot_(o.coords,h),o.t=libtess.normal.dot_(o.coords,u)}else{var d=(a+1)%3,f=(a+2)%3,p=s[a]>0?1:-1;for(o=l.next;o!==l;o=o.next)o.s=o.coords[d],o.t=p*o.coords[f]}i&&libtess.normal.checkOrientation_(e)},libtess.normal.dot_=function(e,t){return e[0]*t[0]+e[1]*t[1]+e[2]*t[2]},libtess.normal.normalize_=function(e){var t=e[0]*e[0]+e[1]*e[1]+e[2]*e[2];t=Math.sqrt(t),e[0]/=t,e[1]/=t,e[2]/=t},libtess.normal.longAxis_=function(e){var t=0;return Math.abs(e[1])>Math.abs(e[0])&&(t=1),Math.abs(e[2])>Math.abs(e[t])&&(t=2),t},libtess.normal.computeNormal_=function(e,t){var n,r=[-2*libtess.GLU_TESS_MAX_COORD,-2*libtess.GLU_TESS_MAX_COORD,-2*libtess.GLU_TESS_MAX_COORD],i=[2*libtess.GLU_TESS_MAX_COORD,2*libtess.GLU_TESS_MAX_COORD,2*libtess.GLU_TESS_MAX_COORD],s=[],o=[],a=e.mesh.vHead;for(n=a.next;n!==a;n=n.next)for(var l=0;l<3;++l){var h=n.coords[l];h<i[l]&&(i[l]=h,o[l]=n),h>r[l]&&(r[l]=h,s[l]=n)}var u=0;if(r[1]-i[1]>r[0]-i[0]&&(u=1),r[2]-i[2]>r[u]-i[u]&&(u=2),i[u]>=r[u])return t[0]=0,t[1]=0,void(t[2]=1);var c=0,d=o[u],f=s[u],p=[0,0,0],m=[d.coords[0]-f.coords[0],d.coords[1]-f.coords[1],d.coords[2]-f.coords[2]],g=[0,0,0];for(n=a.next;n!==a;n=n.next){g[0]=n.coords[0]-f.coords[0],g[1]=n.coords[1]-f.coords[1],g[2]=n.coords[2]-f.coords[2],p[0]=m[1]*g[2]-m[2]*g[1],p[1]=m[2]*g[0]-m[0]*g[2],p[2]=m[0]*g[1]-m[1]*g[0];var b=p[0]*p[0]+p[1]*p[1]+p[2]*p[2];b>c&&(c=b,t[0]=p[0],t[1]=p[1],t[2]=p[2])}c<=0&&(t[0]=t[1]=t[2]=0,t[libtess.normal.longAxis_(m)]=1)},libtess.normal.checkOrientation_=function(e){for(var t=0,n=e.mesh.fHead,r=n.next;r!==n;r=r.next){var i=r.anEdge;if(!(i.winding<=0))do{t+=(i.org.s-i.dst().s)*(i.org.t+i.dst().t),i=i.lNext}while(i!==r.anEdge)}if(t<0)for(var s=e.mesh.vHead,o=s.next;o!==s;o=o.next)o.t=-o.t},libtess.render={},libtess.render.renderMesh=function(e,t,n){for(var r=!1,i=-1,s=t.fHead.prev;s!==t.fHead;s=s.prev)if(s.inside){r||(e.callBeginCallback(libtess.primitiveType.GL_TRIANGLES),r=!0);var o=s.anEdge;do{if(n){var a=o.rFace().inside?0:1;i!==a&&(i=a,e.callEdgeFlagCallback(!!i))}e.callVertexCallback(o.org.data),o=o.lNext}while(o!==s.anEdge)}r&&e.callEndCallback()},libtess.render.renderBoundary=function(e,t){for(var n=t.fHead.next;n!==t.fHead;n=n.next)if(n.inside){e.callBeginCallback(libtess.primitiveType.GL_LINE_LOOP);var r=n.anEdge;do{e.callVertexCallback(r.org.data),r=r.lNext}while(r!==n.anEdge);e.callEndCallback()}},libtess.sweep={},libtess.sweep.SENTINEL_COORD_=4*libtess.GLU_TESS_MAX_COORD,libtess.sweep.TOLERANCE_NONZERO_=!1,libtess.sweep.computeInterior=function(e){e.fatalError=!1,libtess.sweep.removeDegenerateEdges_(e),libtess.sweep.initPriorityQ_(e),libtess.sweep.initEdgeDict_(e);for(var t;null!==(t=e.pq.extractMin());){for(;;){var n=e.pq.minimum();if(null===n||!libtess.geom.vertEq(n,t))break;n=e.pq.extractMin(),libtess.sweep.spliceMergeVertices_(e,t.anEdge,n.anEdge)}libtess.sweep.sweepEvent_(e,t)}var r=e.dict.getMin().getKey();e.event=r.eUp.org,libtess.sweep.doneEdgeDict_(e),libtess.sweep.donePriorityQ_(e),libtess.sweep.removeDegenerateFaces_(e.mesh),e.mesh.checkMesh()},libtess.sweep.addWinding_=function(e,t){e.winding+=t.winding,e.sym.winding+=t.sym.winding},libtess.sweep.edgeLeq_=function(e,t,n){var r=e.event,i=t.eUp,s=n.eUp;return i.dst()===r?s.dst()===r?libtess.geom.vertLeq(i.org,s.org)?libtess.geom.edgeSign(s.dst(),i.org,s.org)<=0:libtess.geom.edgeSign(i.dst(),s.org,i.org)>=0:libtess.geom.edgeSign(s.dst(),r,s.org)<=0:s.dst()===r?libtess.geom.edgeSign(i.dst(),r,i.org)>=0:libtess.geom.edgeEval(i.dst(),r,i.org)>=libtess.geom.edgeEval(s.dst(),r,s.org)},libtess.sweep.deleteRegion_=function(e,t){t.fixUpperEdge,t.eUp.activeRegion=null,e.dict.deleteNode(t.nodeUp),t.nodeUp=null},libtess.sweep.fixUpperEdge_=function(e,t){libtess.mesh.deleteEdge(e.eUp),e.fixUpperEdge=!1,e.eUp=t,t.activeRegion=e},libtess.sweep.topLeftRegion_=function(e){var t=e.eUp.org;do{e=e.regionAbove()}while(e.eUp.org===t);if(e.fixUpperEdge){var n=libtess.mesh.connect(e.regionBelow().eUp.sym,e.eUp.lNext);libtess.sweep.fixUpperEdge_(e,n),e=e.regionAbove()}return e},libtess.sweep.topRightRegion_=function(e){var t=e.eUp.dst();do{e=e.regionAbove()}while(e.eUp.dst()===t);return e},libtess.sweep.addRegionBelow_=function(e,t,n){var r=new libtess.ActiveRegion;return r.eUp=n,r.nodeUp=e.dict.insertBefore(t.nodeUp,r),n.activeRegion=r,r},libtess.sweep.isWindingInside_=function(e,t){switch(e.windingRule){case libtess.windingRule.GLU_TESS_WINDING_ODD:return 0!=(1&t);case libtess.windingRule.GLU_TESS_WINDING_NONZERO:return 0!==t;case libtess.windingRule.GLU_TESS_WINDING_POSITIVE:return t>0;case libtess.windingRule.GLU_TESS_WINDING_NEGATIVE:return t<0;case libtess.windingRule.GLU_TESS_WINDING_ABS_GEQ_TWO:return t>=2||t<=-2}return!1},libtess.sweep.computeWinding_=function(e,t){t.windingNumber=t.regionAbove().windingNumber+t.eUp.winding,t.inside=libtess.sweep.isWindingInside_(e,t.windingNumber)},libtess.sweep.finishRegion_=function(e,t){var n=t.eUp,r=n.lFace;r.inside=t.inside,r.anEdge=n,libtess.sweep.deleteRegion_(e,t)},libtess.sweep.finishLeftRegions_=function(e,t,n){for(var r=t,i=t.eUp;r!==n;){r.fixUpperEdge=!1;var s=r.regionBelow(),o=s.eUp;if(o.org!==i.org){if(!s.fixUpperEdge){libtess.sweep.finishRegion_(e,r);break}o=libtess.mesh.connect(i.lPrev(),o.sym),libtess.sweep.fixUpperEdge_(s,o)}i.oNext!==o&&(libtess.mesh.meshSplice(o.oPrev(),o),libtess.mesh.meshSplice(i,o)),libtess.sweep.finishRegion_(e,r),i=s.eUp,r=s}return i},libtess.sweep.addRightEdges_=function(e,t,n,r,i,s){var o=!0,a=n;do{libtess.sweep.addRegionBelow_(e,t,a.sym),a=a.oNext}while(a!==r);null===i&&(i=t.regionBelow().eUp.rPrev());for(var l,h=t,u=i;l=h.regionBelow(),a=l.eUp.sym,a.org===u.org;)a.oNext!==u&&(libtess.mesh.meshSplice(a.oPrev(),a),libtess.mesh.meshSplice(u.oPrev(),a)),l.windingNumber=h.windingNumber-a.winding,l.inside=libtess.sweep.isWindingInside_(e,l.windingNumber),h.dirty=!0,!o&&libtess.sweep.checkForRightSplice_(e,h)&&(libtess.sweep.addWinding_(a,u),libtess.sweep.deleteRegion_(e,h),libtess.mesh.deleteEdge(u)),o=!1,h=l,u=a;h.dirty=!0,s&&libtess.sweep.walkDirtyRegions_(e,h)},libtess.sweep.callCombine_=function(e,t,n,r,i){var s=[t.coords[0],t.coords[1],t.coords[2]];t.data=null,t.data=e.callCombineCallback(s,n,r),null===t.data&&(i?e.fatalError||(e.callErrorCallback(libtess.errorType.GLU_TESS_NEED_COMBINE_CALLBACK),e.fatalError=!0):t.data=n[0])},libtess.sweep.spliceMergeVertices_=function(e,t,n){var r=[null,null,null,null],i=[.5,.5,0,0];r[0]=t.org.data,r[1]=n.org.data,libtess.sweep.callCombine_(e,t.org,r,i,!1),libtess.mesh.meshSplice(t,n)},libtess.sweep.vertexWeights_=function(e,t,n,r,i){var s=libtess.geom.vertL1dist(t,e),o=libtess.geom.vertL1dist(n,e),a=i,l=i+1;r[a]=.5*o/(s+o),r[l]=.5*s/(s+o),e.coords[0]+=r[a]*t.coords[0]+r[l]*n.coords[0],e.coords[1]+=r[a]*t.coords[1]+r[l]*n.coords[1],e.coords[2]+=r[a]*t.coords[2]+r[l]*n.coords[2]},libtess.sweep.getIntersectData_=function(e,t,n,r,i,s){var o=[0,0,0,0],a=[n.data,r.data,i.data,s.data];t.coords[0]=t.coords[1]=t.coords[2]=0,libtess.sweep.vertexWeights_(t,n,r,o,0),libtess.sweep.vertexWeights_(t,i,s,o,2),libtess.sweep.callCombine_(e,t,a,o,!0)},libtess.sweep.checkForRightSplice_=function(e,t){var n=t.regionBelow(),r=t.eUp,i=n.eUp;if(libtess.geom.vertLeq(r.org,i.org)){if(libtess.geom.edgeSign(i.dst(),r.org,i.org)>0)return!1;libtess.geom.vertEq(r.org,i.org)?r.org!==i.org&&(e.pq.remove(r.org.pqHandle),libtess.sweep.spliceMergeVertices_(e,i.oPrev(),r)):(libtess.mesh.splitEdge(i.sym),libtess.mesh.meshSplice(r,i.oPrev()),t.dirty=n.dirty=!0)}else{if(libtess.geom.edgeSign(r.dst(),i.org,r.org)<0)return!1;t.regionAbove().dirty=t.dirty=!0,libtess.mesh.splitEdge(r.sym),libtess.mesh.meshSplice(i.oPrev(),r)}return!0},libtess.sweep.checkForLeftSplice_=function(e,t){var n,r=t.regionBelow(),i=t.eUp,s=r.eUp;if(libtess.geom.vertLeq(i.dst(),s.dst())){if(libtess.geom.edgeSign(i.dst(),s.dst(),i.org)<0)return!1;t.regionAbove().dirty=t.dirty=!0,n=libtess.mesh.splitEdge(i),libtess.mesh.meshSplice(s.sym,n),n.lFace.inside=t.inside}else{if(libtess.geom.edgeSign(s.dst(),i.dst(),s.org)>0)return!1;t.dirty=r.dirty=!0,n=libtess.mesh.splitEdge(s),libtess.mesh.meshSplice(i.lNext,s.sym),n.rFace().inside=t.inside}return!0},libtess.sweep.checkForIntersect_=function(e,t){var n=t.regionBelow(),r=t.eUp,i=n.eUp,s=r.org,o=i.org,a=r.dst(),l=i.dst(),h=new libtess.GluVertex;if(s===o)return!1;if(Math.min(s.t,a.t)>Math.max(o.t,l.t))return!1;if(libtess.geom.vertLeq(s,o)){if(libtess.geom.edgeSign(l,s,o)>0)return!1}else if(libtess.geom.edgeSign(a,o,s)<0)return!1;libtess.geom.edgeIntersect(a,s,l,o,h),libtess.geom.vertLeq(h,e.event)&&(h.s=e.event.s,h.t=e.event.t);var u=libtess.geom.vertLeq(s,o)?s:o;if(libtess.geom.vertLeq(u,h)&&(h.s=u.s,h.t=u.t),libtess.geom.vertEq(h,s)||libtess.geom.vertEq(h,o))return libtess.sweep.checkForRightSplice_(e,t),!1;if(!libtess.geom.vertEq(a,e.event)&&libtess.geom.edgeSign(a,e.event,h)>=0||!libtess.geom.vertEq(l,e.event)&&libtess.geom.edgeSign(l,e.event,h)<=0){if(l===e.event)return libtess.mesh.splitEdge(r.sym),libtess.mesh.meshSplice(i.sym,r),t=libtess.sweep.topLeftRegion_(t),r=t.regionBelow().eUp,libtess.sweep.finishLeftRegions_(e,t.regionBelow(),n),libtess.sweep.addRightEdges_(e,t,r.oPrev(),r,r,!0),!0;if(a===e.event){libtess.mesh.splitEdge(i.sym),libtess.mesh.meshSplice(r.lNext,i.oPrev()),n=t,t=libtess.sweep.topRightRegion_(t);var c=t.regionBelow().eUp.rPrev();return n.eUp=i.oPrev(),i=libtess.sweep.finishLeftRegions_(e,n,null),libtess.sweep.addRightEdges_(e,t,i.oNext,r.rPrev(),c,!0),!0}return libtess.geom.edgeSign(a,e.event,h)>=0&&(t.regionAbove().dirty=t.dirty=!0,libtess.mesh.splitEdge(r.sym),r.org.s=e.event.s,r.org.t=e.event.t),libtess.geom.edgeSign(l,e.event,h)<=0&&(t.dirty=n.dirty=!0,libtess.mesh.splitEdge(i.sym),i.org.s=e.event.s,i.org.t=e.event.t),!1}return libtess.mesh.splitEdge(r.sym),libtess.mesh.splitEdge(i.sym),libtess.mesh.meshSplice(i.oPrev(),r),r.org.s=h.s,r.org.t=h.t,r.org.pqHandle=e.pq.insert(r.org),libtess.sweep.getIntersectData_(e,r.org,s,a,o,l),t.regionAbove().dirty=t.dirty=n.dirty=!0,!1},libtess.sweep.walkDirtyRegions_=function(e,t){for(var n=t.regionBelow();;){for(;n.dirty;)t=n,n=n.regionBelow();if(!t.dirty&&(n=t,null===(t=t.regionAbove())||!t.dirty))return;t.dirty=!1;var r=t.eUp,i=n.eUp;if(r.dst()!==i.dst()&&libtess.sweep.checkForLeftSplice_(e,t)&&(n.fixUpperEdge?(libtess.sweep.deleteRegion_(e,n),libtess.mesh.deleteEdge(i),n=t.regionBelow(),i=n.eUp):t.fixUpperEdge&&(libtess.sweep.deleteRegion_(e,t),libtess.mesh.deleteEdge(r),t=n.regionAbove(),r=t.eUp)),r.org!==i.org)if(r.dst()===i.dst()||t.fixUpperEdge||n.fixUpperEdge||r.dst()!==e.event&&i.dst()!==e.event)libtess.sweep.checkForRightSplice_(e,t);else if(libtess.sweep.checkForIntersect_(e,t))return;r.org===i.org&&r.dst()===i.dst()&&(libtess.sweep.addWinding_(i,r),libtess.sweep.deleteRegion_(e,t),libtess.mesh.deleteEdge(r),t=n.regionAbove())}},libtess.sweep.connectRightVertex_=function(e,t,n){var r=n.oNext,i=t.regionBelow(),s=t.eUp,o=i.eUp,a=!1;if(s.dst()!==o.dst()&&libtess.sweep.checkForIntersect_(e,t),libtess.geom.vertEq(s.org,e.event)&&(libtess.mesh.meshSplice(r.oPrev(),s),t=libtess.sweep.topLeftRegion_(t),r=t.regionBelow().eUp,libtess.sweep.finishLeftRegions_(e,t.regionBelow(),i),a=!0),libtess.geom.vertEq(o.org,e.event)&&(libtess.mesh.meshSplice(n,o.oPrev()),n=libtess.sweep.finishLeftRegions_(e,i,null),a=!0),a)return void libtess.sweep.addRightEdges_(e,t,n.oNext,r,r,!0);var l;l=libtess.geom.vertLeq(o.org,s.org)?o.oPrev():s,l=libtess.mesh.connect(n.lPrev(),l),libtess.sweep.addRightEdges_(e,t,l,l.oNext,l.oNext,!1),l.sym.activeRegion.fixUpperEdge=!0,libtess.sweep.walkDirtyRegions_(e,t)},libtess.sweep.connectLeftDegenerate_=function(e,t,n){var r=t.eUp;if(libtess.geom.vertEq(r.org,n))return void(libtess.sweep.TOLERANCE_NONZERO_&&libtess.sweep.spliceMergeVertices_(e,r,n.anEdge));if(!libtess.geom.vertEq(r.dst(),n))return libtess.mesh.splitEdge(r.sym),t.fixUpperEdge&&(libtess.mesh.deleteEdge(r.oNext),t.fixUpperEdge=!1),libtess.mesh.meshSplice(n.anEdge,r),void libtess.sweep.sweepEvent_(e,n);if(libtess.sweep.TOLERANCE_NONZERO_){t=libtess.sweep.topRightRegion_(t);var i=t.regionBelow(),s=i.eUp.sym,o=s.oNext,a=o;i.fixUpperEdge&&(libtess.sweep.deleteRegion_(e,i),libtess.mesh.deleteEdge(s),s=o.oPrev()),libtess.mesh.meshSplice(n.anEdge,s),libtess.geom.edgeGoesLeft(o)||(o=null),libtess.sweep.addRightEdges_(e,t,s.oNext,a,o,!0)}},libtess.sweep.connectLeftVertex_=function(e,t){var n=new libtess.ActiveRegion;n.eUp=t.anEdge.sym;var r=e.dict.search(n).getKey(),i=r.regionBelow(),s=r.eUp,o=i.eUp;if(0===libtess.geom.edgeSign(s.dst(),t,s.org))return void libtess.sweep.connectLeftDegenerate_(e,r,t);var a,l=libtess.geom.vertLeq(o.dst(),s.dst())?r:i;if(r.inside||l.fixUpperEdge){if(l===r)a=libtess.mesh.connect(t.anEdge.sym,s.lNext);else{a=libtess.mesh.connect(o.dNext(),t.anEdge).sym}l.fixUpperEdge?libtess.sweep.fixUpperEdge_(l,a):libtess.sweep.computeWinding_(e,libtess.sweep.addRegionBelow_(e,r,a)),libtess.sweep.sweepEvent_(e,t)}else libtess.sweep.addRightEdges_(e,r,t.anEdge,t.anEdge,null,!0)},libtess.sweep.sweepEvent_=function(e,t){e.event=t;for(var n=t.anEdge;null===n.activeRegion;)if((n=n.oNext)===t.anEdge)return void libtess.sweep.connectLeftVertex_(e,t);var r=libtess.sweep.topLeftRegion_(n.activeRegion),i=r.regionBelow(),s=i.eUp,o=libtess.sweep.finishLeftRegions_(e,i,null);o.oNext===s?libtess.sweep.connectRightVertex_(e,r,o):libtess.sweep.addRightEdges_(e,r,o.oNext,s,s,!0)},libtess.sweep.addSentinel_=function(e,t){var n=new libtess.ActiveRegion,r=libtess.mesh.makeEdge(e.mesh);r.org.s=libtess.sweep.SENTINEL_COORD_,r.org.t=t,r.dst().s=-libtess.sweep.SENTINEL_COORD_,r.dst().t=t,e.event=r.dst(),n.eUp=r,n.windingNumber=0,n.inside=!1,n.fixUpperEdge=!1,n.sentinel=!0,n.dirty=!1,n.nodeUp=e.dict.insert(n)},libtess.sweep.initEdgeDict_=function(e){e.dict=new libtess.Dict(e,libtess.sweep.edgeLeq_),libtess.sweep.addSentinel_(e,-libtess.sweep.SENTINEL_COORD_),libtess.sweep.addSentinel_(e,libtess.sweep.SENTINEL_COORD_)},libtess.sweep.doneEdgeDict_=function(e){for(var t;null!==(t=e.dict.getMin().getKey());)t.sentinel,libtess.sweep.deleteRegion_(e,t);e.dict=null},libtess.sweep.removeDegenerateEdges_=function(e){for(var t,n=e.mesh.eHead,r=n.next;r!==n;r=t){t=r.next;var i=r.lNext;libtess.geom.vertEq(r.org,r.dst())&&r.lNext.lNext!==r&&(libtess.sweep.spliceMergeVertices_(e,i,r),libtess.mesh.deleteEdge(r),r=i,i=r.lNext),i.lNext===r&&(i!==r&&(i!==t&&i!==t.sym||(t=t.next),libtess.mesh.deleteEdge(i)),r!==t&&r!==t.sym||(t=t.next),libtess.mesh.deleteEdge(r))}},libtess.sweep.initPriorityQ_=function(e){var t=new libtess.PriorityQ;e.pq=t;var n,r=e.mesh.vHead;for(n=r.next;n!==r;n=n.next)n.pqHandle=t.insert(n);t.init()},libtess.sweep.donePriorityQ_=function(e){e.pq.deleteQ(),e.pq=null},libtess.sweep.removeDegenerateFaces_=function(e){for(var t,n=e.fHead.next;n!==e.fHead;n=t){t=n.next;var r=n.anEdge;r.lNext.lNext===r&&(libtess.sweep.addWinding_(r.oNext,r),libtess.mesh.deleteEdge(r))}},libtess.tessmono={},libtess.tessmono.tessellateMonoRegion_=function(e){for(var t=e.anEdge;libtess.geom.vertLeq(t.dst(),t.org);t=t.lPrev());for(;libtess.geom.vertLeq(t.org,t.dst());t=t.lNext);for(var n,r=t.lPrev();t.lNext!==r;)if(libtess.geom.vertLeq(t.dst(),r.org)){for(;r.lNext!==t&&(libtess.geom.edgeGoesLeft(r.lNext)||libtess.geom.edgeSign(r.org,r.dst(),r.lNext.dst())<=0);)n=libtess.mesh.connect(r.lNext,r),r=n.sym;r=r.lPrev()}else{for(;r.lNext!==t&&(libtess.geom.edgeGoesRight(t.lPrev())||libtess.geom.edgeSign(t.dst(),t.org,t.lPrev().org)>=0);)n=libtess.mesh.connect(t,t.lPrev()),t=n.sym;t=t.lNext}for(;r.lNext.lNext!==t;)n=libtess.mesh.connect(r.lNext,r),r=n.sym},libtess.tessmono.tessellateInterior=function(e){for(var t,n=e.fHead.next;n!==e.fHead;n=t)t=n.next,n.inside&&libtess.tessmono.tessellateMonoRegion_(n)},libtess.tessmono.discardExterior=function(e){for(var t,n=e.fHead.next;n!==e.fHead;n=t)t=n.next,n.inside||libtess.mesh.zapFace(n)},libtess.tessmono.setWindingNumber=function(e,t,n){for(var r,i=e.eHead.next;i!==e.eHead;i=r)r=i.next,i.rFace().inside!==i.lFace.inside?i.winding=i.lFace.inside?t:-t:n?libtess.mesh.deleteEdge(i):i.winding=0},libtess.Dict=function(e,t){this.head_=new libtess.DictNode,this.frame_=e,this.leq_=t},libtess.Dict.prototype.deleteDict_=function(){},libtess.Dict.prototype.insertBefore=function(e,t){do{e=e.prev}while(null!==e.key&&!this.leq_(this.frame_,e.key,t));var n=new libtess.DictNode(t,e.next,e);return e.next.prev=n,e.next=n,n},libtess.Dict.prototype.insert=function(e){return this.insertBefore(this.head_,e)},libtess.Dict.prototype.deleteNode=function(e){e.next.prev=e.prev,e.prev.next=e.next},libtess.Dict.prototype.search=function(e){var t=this.head_;do{t=t.next}while(null!==t.key&&!this.leq_(this.frame_,e,t.key));return t},libtess.Dict.prototype.getMin=function(){return this.head_.next},libtess.Dict.prototype.getMax=function(){return this.head_.prev},libtess.DictNode=function(e,t,n){this.key=e||null,this.next=t||this,this.prev=n||this},libtess.DictNode.prototype.getKey=function(){return this.key},libtess.DictNode.prototype.getSuccessor=function(){return this.next},libtess.DictNode.prototype.getPredecessor=function(){return this.prev},libtess.GluTesselator=function(){this.state_=libtess.GluTesselator.tessState_.T_DORMANT,this.lastEdge_=null,this.mesh=null,this.errorCallback_=null,this.normal_=[0,0,0],this.windingRule=libtess.windingRule.GLU_TESS_WINDING_ODD,this.fatalError=!1,this.dict=null,this.pq=null,this.event=null,this.combineCallback_=null,this.boundaryOnly_=!1,this.beginCallback_=null,this.edgeFlagCallback_=null,this.vertexCallback_=null,this.endCallback_=null,this.meshCallback_=null,this.polygonData_=null},libtess.GluTesselator.tessState_={T_DORMANT:0,T_IN_POLYGON:1,T_IN_CONTOUR:2},libtess.GluTesselator.prototype.gluDeleteTess=function(){this.requireState_(libtess.GluTesselator.tessState_.T_DORMANT)},libtess.GluTesselator.prototype.gluTessProperty=function(e,t){switch(e){case libtess.gluEnum.GLU_TESS_TOLERANCE:return;case libtess.gluEnum.GLU_TESS_WINDING_RULE:var n=t;switch(n){case libtess.windingRule.GLU_TESS_WINDING_ODD:case libtess.windingRule.GLU_TESS_WINDING_NONZERO:case libtess.windingRule.GLU_TESS_WINDING_POSITIVE:case libtess.windingRule.GLU_TESS_WINDING_NEGATIVE:case libtess.windingRule.GLU_TESS_WINDING_ABS_GEQ_TWO:return void(this.windingRule=n)}break;case libtess.gluEnum.GLU_TESS_BOUNDARY_ONLY:return void(this.boundaryOnly_=!!t);default:return void this.callErrorCallback(libtess.gluEnum.GLU_INVALID_ENUM)}this.callErrorCallback(libtess.gluEnum.GLU_INVALID_VALUE)},libtess.GluTesselator.prototype.gluGetTessProperty=function(e){switch(e){case libtess.gluEnum.GLU_TESS_TOLERANCE:return 0;case libtess.gluEnum.GLU_TESS_WINDING_RULE:return this.windingRule;case libtess.gluEnum.GLU_TESS_BOUNDARY_ONLY:return this.boundaryOnly_;default:this.callErrorCallback(libtess.gluEnum.GLU_INVALID_ENUM)}return!1},libtess.GluTesselator.prototype.gluTessNormal=function(e,t,n){this.normal_[0]=e,this.normal_[1]=t,this.normal_[2]=n},libtess.GluTesselator.prototype.gluTessCallback=function(e,t){var n=t||null;switch(e){case libtess.gluEnum.GLU_TESS_BEGIN:case libtess.gluEnum.GLU_TESS_BEGIN_DATA:return void(this.beginCallback_=n);case libtess.gluEnum.GLU_TESS_EDGE_FLAG:case libtess.gluEnum.GLU_TESS_EDGE_FLAG_DATA:return void(this.edgeFlagCallback_=n);case libtess.gluEnum.GLU_TESS_VERTEX:case libtess.gluEnum.GLU_TESS_VERTEX_DATA:return void(this.vertexCallback_=n);case libtess.gluEnum.GLU_TESS_END:case libtess.gluEnum.GLU_TESS_END_DATA:return void(this.endCallback_=n);case libtess.gluEnum.GLU_TESS_ERROR:case libtess.gluEnum.GLU_TESS_ERROR_DATA:return void(this.errorCallback_=n);case libtess.gluEnum.GLU_TESS_COMBINE:case libtess.gluEnum.GLU_TESS_COMBINE_DATA:return void(this.combineCallback_=n);case libtess.gluEnum.GLU_TESS_MESH:return void(this.meshCallback_=n);default:return void this.callErrorCallback(libtess.gluEnum.GLU_INVALID_ENUM)}},libtess.GluTesselator.prototype.gluTessVertex=function(e,t){var n=!1,r=[0,0,0];this.requireState_(libtess.GluTesselator.tessState_.T_IN_CONTOUR);for(var i=0;i<3;++i){var s=e[i];s<-libtess.GLU_TESS_MAX_COORD&&(s=-libtess.GLU_TESS_MAX_COORD,n=!0),s>libtess.GLU_TESS_MAX_COORD&&(s=libtess.GLU_TESS_MAX_COORD,n=!0),r[i]=s}n&&this.callErrorCallback(libtess.errorType.GLU_TESS_COORD_TOO_LARGE),this.addVertex_(r,t)},libtess.GluTesselator.prototype.gluTessBeginPolygon=function(e){this.requireState_(libtess.GluTesselator.tessState_.T_DORMANT),this.state_=libtess.GluTesselator.tessState_.T_IN_POLYGON,this.mesh=new libtess.GluMesh,this.polygonData_=e},libtess.GluTesselator.prototype.gluTessBeginContour=function(){this.requireState_(libtess.GluTesselator.tessState_.T_IN_POLYGON),this.state_=libtess.GluTesselator.tessState_.T_IN_CONTOUR,this.lastEdge_=null},
libtess.GluTesselator.prototype.gluTessEndContour=function(){this.requireState_(libtess.GluTesselator.tessState_.T_IN_CONTOUR),this.state_=libtess.GluTesselator.tessState_.T_IN_POLYGON},libtess.GluTesselator.prototype.gluTessEndPolygon=function(){if(this.requireState_(libtess.GluTesselator.tessState_.T_IN_POLYGON),this.state_=libtess.GluTesselator.tessState_.T_DORMANT,libtess.normal.projectPolygon(this,this.normal_[0],this.normal_[1],this.normal_[2]),libtess.sweep.computeInterior(this),!this.fatalError){var e=this.mesh;if(this.boundaryOnly_?libtess.tessmono.setWindingNumber(e,1,!0):libtess.tessmono.tessellateInterior(e),this.mesh.checkMesh(),this.beginCallback_||this.endCallback_||this.vertexCallback_||this.edgeFlagCallback_)if(this.boundaryOnly_)libtess.render.renderBoundary(this,this.mesh);else{var t=!!this.edgeFlagCallback_;libtess.render.renderMesh(this,this.mesh,t)}if(this.meshCallback_)return libtess.tessmono.discardExterior(this.mesh),this.meshCallback_(this.mesh),this.mesh=null,void(this.polygonData_=null)}libtess.mesh.deleteMesh(this.mesh),this.polygonData_=null,this.mesh=null},libtess.GluTesselator.prototype.requireState_=function(e){this.state_!==e&&this.gotoState_(e)},libtess.GluTesselator.prototype.gotoState_=function(e){for(;this.state_!==e;)if(this.state_<e)switch(this.state_){case libtess.GluTesselator.tessState_.T_DORMANT:this.callErrorCallback(libtess.errorType.GLU_TESS_MISSING_BEGIN_POLYGON),this.gluTessBeginPolygon(null);break;case libtess.GluTesselator.tessState_.T_IN_POLYGON:this.callErrorCallback(libtess.errorType.GLU_TESS_MISSING_BEGIN_CONTOUR),this.gluTessBeginContour()}else switch(this.state_){case libtess.GluTesselator.tessState_.T_IN_CONTOUR:this.callErrorCallback(libtess.errorType.GLU_TESS_MISSING_END_CONTOUR),this.gluTessEndContour();break;case libtess.GluTesselator.tessState_.T_IN_POLYGON:this.callErrorCallback(libtess.errorType.GLU_TESS_MISSING_END_POLYGON),this.gluTessEndPolygon()}},libtess.GluTesselator.prototype.addVertex_=function(e,t){var n=this.lastEdge_;null===n?(n=libtess.mesh.makeEdge(this.mesh),libtess.mesh.meshSplice(n,n.sym)):(libtess.mesh.splitEdge(n),n=n.lNext),n.org.data=t,n.org.coords[0]=e[0],n.org.coords[1]=e[1],n.org.coords[2]=e[2],n.winding=1,n.sym.winding=-1,this.lastEdge_=n},libtess.GluTesselator.prototype.callBeginCallback=function(e){this.beginCallback_&&this.beginCallback_(e,this.polygonData_)},libtess.GluTesselator.prototype.callVertexCallback=function(e){this.vertexCallback_&&this.vertexCallback_(e,this.polygonData_)},libtess.GluTesselator.prototype.callEdgeFlagCallback=function(e){this.edgeFlagCallback_&&this.edgeFlagCallback_(e,this.polygonData_)},libtess.GluTesselator.prototype.callEndCallback=function(){this.endCallback_&&this.endCallback_(this.polygonData_)},libtess.GluTesselator.prototype.callCombineCallback=function(e,t,n){return this.combineCallback_?this.combineCallback_(e,t,n,this.polygonData_)||null:null},libtess.GluTesselator.prototype.callErrorCallback=function(e){this.errorCallback_&&this.errorCallback_(e,this.polygonData_)},libtess.GluFace=function(e,t){this.next=e||this,this.prev=t||this,this.anEdge=null,this.data=null,this.inside=!1},libtess.GluHalfEdge=function(e){this.next=e||this,this.sym=null,this.oNext=null,this.lNext=null,this.org=null,this.lFace=null,this.activeRegion=null,this.winding=0},libtess.GluHalfEdge.prototype.rFace=function(){return this.sym.lFace},libtess.GluHalfEdge.prototype.dst=function(){return this.sym.org},libtess.GluHalfEdge.prototype.oPrev=function(){return this.sym.lNext},libtess.GluHalfEdge.prototype.lPrev=function(){return this.oNext.sym},libtess.GluHalfEdge.prototype.dPrev=function(){return this.lNext.sym},libtess.GluHalfEdge.prototype.rPrev=function(){return this.sym.oNext},libtess.GluHalfEdge.prototype.dNext=function(){return this.rPrev().sym},libtess.GluHalfEdge.prototype.rNext=function(){return this.oPrev().sym},libtess.GluMesh=function(){this.vHead=new libtess.GluVertex,this.fHead=new libtess.GluFace,this.eHead=new libtess.GluHalfEdge,this.eHeadSym=new libtess.GluHalfEdge,this.eHead.sym=this.eHeadSym,this.eHeadSym.sym=this.eHead},libtess.GluMesh.prototype.checkMesh=function(){if(libtess.DEBUG){var e,t,n=this.fHead,r=this.vHead,i=this.eHead,s=n;for(s=n;(t=s.next)!==n;s=t){e=t.anEdge;do{e=e.lNext}while(e!==t.anEdge)}var o,a=r;for(a=r;(o=a.next)!==r;a=o){e=o.anEdge;do{e=e.oNext}while(e!==o.anEdge)}var l=i;for(l=i;(e=l.next)!==i;l=e);}},libtess.GluVertex=function(e,t){this.next=e||this,this.prev=t||this,this.anEdge=null,this.data=null,this.coords=[0,0,0],this.s=0,this.t=0,this.pqHandle=0},libtess.PriorityQ=function(){this.verts_=[],this.order_=null,this.size_=0,this.initialized_=!1,this.heap_=new libtess.PriorityQHeap},libtess.PriorityQ.prototype.deleteQ=function(){this.heap_=null,this.order_=null,this.verts_=null},libtess.PriorityQ.prototype.init=function(){this.order_=[];for(var e=0;e<this.size_;e++)this.order_[e]=e;var t=function(e){return function(t,n){return libtess.geom.vertLeq(e[t],e[n])?1:-1}}(this.verts_);if(this.order_.sort(t),this.initialized_=!0,this.heap_.init(),libtess.DEBUG){var n=0+this.size_-1;for(e=0;e<n;++e);}},libtess.PriorityQ.prototype.insert=function(e){if(this.initialized_)return this.heap_.insert(e);var t=this.size_++;return this.verts_[t]=e,-(t+1)},libtess.PriorityQ.prototype.extractMin=function(){if(0===this.size_)return this.heap_.extractMin();var e=this.verts_[this.order_[this.size_-1]];if(!this.heap_.isEmpty()){var t=this.heap_.minimum();if(libtess.geom.vertLeq(t,e))return this.heap_.extractMin()}do{--this.size_}while(this.size_>0&&null===this.verts_[this.order_[this.size_-1]]);return e},libtess.PriorityQ.prototype.minimum=function(){if(0===this.size_)return this.heap_.minimum();var e=this.verts_[this.order_[this.size_-1]];if(!this.heap_.isEmpty()){var t=this.heap_.minimum();if(libtess.geom.vertLeq(t,e))return t}return e},libtess.PriorityQ.prototype.remove=function(e){if(e>=0)return void this.heap_.remove(e);for(e=-(e+1),this.verts_[e]=null;this.size_>0&&null===this.verts_[this.order_[this.size_-1]];)--this.size_},libtess.PriorityQHeap=function(){this.heap_=libtess.PriorityQHeap.reallocNumeric_([0],libtess.PriorityQHeap.INIT_SIZE_+1),this.verts_=[null,null],this.handles_=[0,0],this.size_=0,this.max_=libtess.PriorityQHeap.INIT_SIZE_,this.freeList_=0,this.initialized_=!1,this.heap_[1]=1},libtess.PriorityQHeap.INIT_SIZE_=32,libtess.PriorityQHeap.reallocNumeric_=function(e,t){for(var n=new Array(t),r=0;r<e.length;r++)n[r]=e[r];for(;r<t;r++)n[r]=0;return n},libtess.PriorityQHeap.prototype.init=function(){for(var e=this.size_;e>=1;--e)this.floatDown_(e);this.initialized_=!0},libtess.PriorityQHeap.prototype.insert=function(e){var t=++this.size_;2*t>this.max_&&(this.max_*=2,this.handles_=libtess.PriorityQHeap.reallocNumeric_(this.handles_,this.max_+1));var n;return 0===this.freeList_?n=t:(n=this.freeList_,this.freeList_=this.handles_[this.freeList_]),this.verts_[n]=e,this.handles_[n]=t,this.heap_[t]=n,this.initialized_&&this.floatUp_(t),n},libtess.PriorityQHeap.prototype.isEmpty=function(){return 0===this.size_},libtess.PriorityQHeap.prototype.minimum=function(){return this.verts_[this.heap_[1]]},libtess.PriorityQHeap.prototype.extractMin=function(){var e=this.heap_,t=this.verts_,n=this.handles_,r=e[1],i=t[r];return this.size_>0&&(e[1]=e[this.size_],n[e[1]]=1,t[r]=null,n[r]=this.freeList_,this.freeList_=r,--this.size_>0&&this.floatDown_(1)),i},libtess.PriorityQHeap.prototype.remove=function(e){var t=this.heap_,n=this.verts_,r=this.handles_,i=r[e];if(t[i]=t[this.size_],r[t[i]]=i,i<=--this.size_)if(i<=1)this.floatDown_(i);else{var s=n[t[i]],o=n[t[i>>1]];libtess.geom.vertLeq(o,s)?this.floatDown_(i):this.floatUp_(i)}n[e]=null,r[e]=this.freeList_,this.freeList_=e},libtess.PriorityQHeap.prototype.floatDown_=function(e){for(var t=this.heap_,n=this.verts_,r=this.handles_,i=e,s=t[i];;){var o=i<<1;o<this.size_&&libtess.geom.vertLeq(n[t[o+1]],n[t[o]])&&(o+=1);var a=t[o];if(o>this.size_||libtess.geom.vertLeq(n[s],n[a]))return t[i]=s,void(r[s]=i);t[i]=a,r[a]=i,i=o}},libtess.PriorityQHeap.prototype.floatUp_=function(e){for(var t=this.heap_,n=this.verts_,r=this.handles_,i=e,s=t[i];;){var o=i>>1,a=t[o];if(0===o||libtess.geom.vertLeq(n[a],n[s]))return t[i]=s,void(r[s]=i);t[i]=a,r[a]=i,i=o}},libtess.ActiveRegion=function(){this.eUp=null,this.nodeUp=null,this.windingNumber=0,this.inside=!1,this.sentinel=!1,this.dirty=!1,this.fixUpperEdge=!1},libtess.ActiveRegion.prototype.regionBelow=function(){return this.nodeUp.getPredecessor().getKey()},libtess.ActiveRegion.prototype.regionAbove=function(){return this.nodeUp.getSuccessor().getKey()},"undefined"!=typeof module&&(module.exports=libtess),define("util/libtess",function(){}),define("util/measure/AreaMeasurer",["../../geom/Angle","../../error/ArgumentError","../../geom/Location","../Logger","./MeasurerUtils","../../geom/Sector","../../geom/Vec3","../libtess"],function(e,t,n,r,i,s,o,a){"use strict";var l=function(e){if(!e)throw new t(r.logMessage(r.LEVEL_SEVERE,"AreaMeasurer","constructor","missingWorldWindow"));this.wwd=e,this.DEFAULT_AREA_SAMPLING_STEPS=32,this._areaTerrainSamplingSteps=this.DEFAULT_AREA_SAMPLING_STEPS,this._maxSegmentLength=1e5,this.subdividedPositions=null,this.vecZ=new o(0,0,1),this.scratchLocation=new n(0,0)};return Object.defineProperties(l.prototype,{areaTerrainSamplingSteps:{get:function(){return this._areaTerrainSamplingSteps},set:function(e){this._areaTerrainSamplingSteps=e}},maxSegmentLength:{get:function(){return this._maxSegmentLength},set:function(e){this._maxSegmentLength=e}}}),l.prototype.getArea=function(e,t,n){var r=this.wwd.globe;return t?this.computeSurfaceAreaSampling(r,e,n):this.computeProjectedAreaGeometry(r,e,n)},l.prototype.computeSurfaceAreaSampling=function(t,n,r){var a=new s(0,0,0,0);a.setToBoundingSector(n),this.subdividedPositions=i.subdividePositions(t,n,!0,r,this._maxSegmentLength);for(var l=Math.max(this.DEFAULT_AREA_SAMPLING_STEPS,this._areaTerrainSamplingSteps),h=a.deltaLatitude()*e.DEGREES_TO_RADIANS,u=a.deltaLongitude()*e.DEGREES_TO_RADIANS,c=Math.max(h/l,u/l),d=Math.round(h/c),f=Math.round(u/c*Math.cos(a.centroidLatitude()*e.DEGREES_TO_RADIANS)),p=h/d,m=u/f,g=0,b=0;b<d;b++)for(var y=a.minLatitude*e.DEGREES_TO_RADIANS+p*b,_=t.radiusAt((y+p/2)*e.RADIANS_TO_DEGREES,a.centroidLongitude()),E=m*_*Math.cos(y+p/2),v=p*_,w=E*v,S=0;S<f;S++){var T=a.minLongitude*e.DEGREES_TO_RADIANS+m*S,L=y*e.RADIANS_TO_DEGREES,x=(y+p)*e.RADIANS_TO_DEGREES,R=T*e.RADIANS_TO_DEGREES,A=(T+m)*e.RADIANS_TO_DEGREES,C=new s(L,x,R,A),M=i.isLocationInside(C.centroid(this.scratchLocation),this.subdividedPositions);if(M){var k=t.elevationAtLocation(L,R),I=t.elevationAtLocation(L,A),O=t.elevationAtLocation(x,R),P=new o(E,0,I-k),N=new o(0,v,O-k);P.normalize(),N.normalize();var D=P.cross(N).normalize(),F=Math.tan(i.angleBetweenVectors(this.vecZ,D)),B=Math.sqrt(1+F*F);g+=w*B}}return g},l.prototype.computeProjectedAreaGeometry=function(t,n,r){this.subdividedPositions=i.subdividePositions(t,n,!1,r,this._maxSegmentLength);var s=this.subdividedPositions.length,o=this.subdividedPositions[0],a=this.subdividedPositions[s-1];o.equals(a)&&s--;for(var l=[],h=0,u=0;u<s;u++){var c=this.subdividedPositions[u];l[h++]=c.longitude*e.DEGREES_TO_RADIANS,l[h++]=c.latitude*e.DEGREES_TO_RADIANS,l[h++]=0}var d=this.tessellatePolygon(s,l),f=0,p=d.length/9;for(u=0;u<p;u++){h=9*u;var m=[d[h+0],d[h+1],d[h+2],d[h+3],d[h+4],d[h+5],d[h+6],d[h+7],d[h+8]];f+=this.computeTriangleProjectedArea(t,m)}return f},l.prototype.computeTriangleProjectedArea=function(t,n){var r=n[0],i=n[1],s=n[3],o=n[4],a=n[6],l=n[7],h=Math.abs(r*(o-l)+s*(l-i)+a*(i-o));h/=2;var u=(r+s+a)/3,c=(i+o+l)/3,d=t.radiusAt(c*e.RADIANS_TO_DEGREES,u*e.RADIANS_TO_DEGREES);return h*=Math.cos(c)*d*d},l.prototype.tessellatePolygon=function(e,t){var n,i=new libtess.GluTesselator,s=[];i.gluTessCallback(libtess.gluEnum.GLU_TESS_BEGIN,function(e){e!==libtess.primitiveType.GL_TRIANGLES&&r.logMessage(r.LEVEL_WARNING,"AreaMeasurer","tessellatePolygon","Tessellation error, primitive is not TRIANGLES.")}),i.gluTessCallback(libtess.gluEnum.GLU_TESS_VERTEX_DATA,function(e,t){t.push(e[0]),t.push(e[1]),t.push(e[2])}),i.gluTessCallback(libtess.gluEnum.GLU_TESS_EDGE_FLAG,function(){}),i.gluTessCallback(libtess.gluEnum.GLU_TESS_ERROR,function(e){r.logMessage(r.LEVEL_WARNING,"AreaMeasurer","tessellatePolygon","Tessellation error "+e+".")}),i.gluTessBeginPolygon(s),i.gluTessBeginContour();for(var o=0;o<e;o++)n=t.slice(3*o,3*o+3),i.gluTessVertex(n,n);return i.gluTessEndContour(),i.gluTessEndPolygon(),s},l}),define("util/AbsentResourceList",[],function(){"use strict";var e=function(e,t){this.maxTrys=e,this.minCheckInterval=t,this.tryAgainInterval=6e4,this.possiblyAbsent={}};return e.prototype.isResourceAbsent=function(e){var t=this.possiblyAbsent[e];if(!t)return!1;if(t.permanent)return!0;var n=Date.now()-t.timeOfLastMark;return n>this.tryAgainInterval?(delete this.possiblyAbsent[e],!1):n<this.minCheckInterval||t.numTrys>this.maxTrys},e.prototype.markResourceAbsent=function(e){var t=this.possiblyAbsent[e];t||(t={timeOfLastMark:Date.now(),numTrys:0},this.possiblyAbsent[e]=t),t.numTrys=t.numTrys+1,t.timeOfLastMark=Date.now()},e.prototype.markResourceAbsentPermanently=function(e){var t=this.possiblyAbsent[e];t||(t={timeOfLastMark:Date.now(),numTrys:0},this.possiblyAbsent[e]=t),t.numTrys=t.numTrys+1,t.timeOfLastMark=Date.now(),t.permanent=!0},e.prototype.unmarkResourceAbsent=function(e){this.possiblyAbsent[e]&&delete this.possiblyAbsent[e]},e}),define("globe/ElevationCoverage",["../error/ArgumentError","../util/Logger","../geom/Sector"],function(e,t,n){"use strict";var r=function(r){if(!r)throw new e(t.logMessage(t.LEVEL_SEVERE,"ElevationCoverage","constructor","missingResolution"));this.timestamp=Date.now(),this.displayName="Coverage",this._enabled=!0,this.resolution=r,this.coverageSector=n.FULL_SPHERE};return Object.defineProperties(r.prototype,{enabled:{get:function(){return this._enabled},set:function(e){this._enabled=e,this.timestamp=Date.now()}}}),r.prototype.minAndMaxElevationsForSector=function(n,r){if(!n)throw new e(t.logMessage(t.LEVEL_SEVERE,"ElevationCoverage","minAndMaxElevationsForSector","missingSector"));if(!r)throw new e(t.logMessage(t.LEVEL_SEVERE,"ElevationCoverage","minAndMaxElevationsForSector","missingResult"));return r[0]>0&&(r[0]=0),r[1]<0&&(r[1]=0),!0},r.prototype.elevationAtLocation=function(e,t){return 0},r.prototype.elevationsForGrid=function(n,r,i,s){if(!n)throw new e(t.logMessage(t.LEVEL_SEVERE,"ElevationCoverage","elevationsForGrid","missingSector"));if(r<=0||i<=0)throw new e(t.logMessage(t.LEVEL_SEVERE,"ElevationCoverage","elevationsForGrid","numLat or numLon is less than 1"));if(!s||s.length<r*i)throw new e(t.logMessage(t.LEVEL_SEVERE,"ElevationCoverage","elevationsForGrid","missingArray"));for(var o=0,a=s.length;o<a;o++)s[o]=0;return!0},r}),define("globe/ElevationImage",["../error/ArgumentError","../util/Logger","../util/WWMath"],function(e,t,n){"use strict";var r=function(n,r,i){if(!n)throw new e(t.logMessage(t.LEVEL_SEVERE,"ElevationImage","constructor","missingSector"));this.sector=n,this.imageWidth=r,this.imageHeight=i,this.size=this.imageWidth*this.imageHeight,this.hasData=!0,this.hasMissingData=!1};return r.NO_DATA=0,r.isNoData=function(e,t,n,i){var s=r.NO_DATA;return e===s&&t===s&&n===s&&i===s},r.prototype.pixel=function(e,t){return e<0||e>=this.imageWidth?0:t<0||t>=this.imageHeight?0:(t=this.imageHeight-t-1,this.imageData[e+t*this.imageWidth])},r.prototype.elevationAtLocation=function(e,t){var i=this.sector.maxLatitude,s=this.sector.minLongitude,o=this.sector.deltaLatitude(),a=this.sector.deltaLongitude(),l=(this.imageWidth-1)*(t-s)/a,h=(this.imageHeight-1)*(i-e)/o,u=Math.floor(n.clamp(l,0,this.imageWidth-1)),c=Math.floor(n.clamp(u+1,0,this.imageWidth-1)),d=Math.floor(n.clamp(h,0,this.imageHeight-1)),f=Math.floor(n.clamp(d+1,0,this.imageHeight-1)),p=this.imageData,m=p[u+d*this.imageWidth],g=p[c+d*this.imageWidth],b=p[u+f*this.imageWidth],y=p[c+f*this.imageWidth],_=l-u,E=h-d;return r.isNoData(m,g,b,y)?NaN:(1-_)*(1-E)*m+_*(1-E)*g+(1-_)*E*b+_*E*y},r.prototype.elevationsForGrid=function(i,s,o,a){if(!i)throw new e(t.logMessage(t.LEVEL_SEVERE,"ElevationImage","elevationsForGrid","missingSector"));if(s<1||o<1)throw new e(t.logMessage(t.LEVEL_SEVERE,"ElevationImage","elevationsForGrid","The specified number of sample points is less than 1."));if(!a)throw new e(t.logMessage(t.LEVEL_SEVERE,"ElevationImage","elevationsForGrid","missingResult"));var l,h,u,c,d=this.sector.minLatitude,f=this.sector.maxLatitude,p=this.sector.minLongitude,m=this.sector.maxLongitude,g=f-d,b=m-p,y=i.minLatitude,_=i.maxLatitude,E=i.minLongitude,v=i.maxLongitude,w=(_-y)/(s>1?s-1:1),S=(v-E)/(o>1?o-1:1),T=0,L=this.imageData;for(c=0,l=y;c<s;c+=1,l+=w)if(c===s-1&&(l=_),l>=d&&l<=f){var x=(this.imageHeight-1)*(f-l)/g,R=Math.floor(n.clamp(x,0,this.imageHeight-1)),A=Math.floor(n.clamp(R+1,0,this.imageHeight-1)),C=x-R;for(u=0,h=E;u<o;u+=1,h+=S){if(u===o-1&&(h=v),h>=p&&h<=m&&isNaN(a[T])){var M=(this.imageWidth-1)*(h-p)/b,k=Math.floor(n.clamp(M,0,this.imageWidth-1)),I=Math.floor(n.clamp(k+1,0,this.imageWidth-1)),O=M-k,P=L[k+R*this.imageWidth],N=L[I+R*this.imageWidth],D=L[k+A*this.imageWidth],F=L[I+A*this.imageWidth];r.isNoData(P,N,D,F)?a[T]=NaN:a[T]=(1-O)*(1-C)*P+O*(1-C)*N+(1-O)*C*D+O*C*F}T++}}else T+=o},r.prototype.minAndMaxElevationsForSector=function(e){if(!this.hasData)return null;var t=[];if(e)if(e.contains(this.sector))t[0]>this.minElevation&&(t[0]=this.minElevation),t[1]<this.maxElevation&&(t[1]=this.maxElevation);else{var r=this.sector.maxLatitude,i=this.sector.minLongitude,s=this.sector.deltaLatitude(),o=this.sector.deltaLongitude(),a=e.minLatitude,l=e.maxLatitude,h=e.minLongitude,u=e.maxLongitude,c=Math.floor((this.imageHeight-1)*(r-l)/s),d=Math.ceil((this.imageHeight-1)*(r-a)/s),f=Math.floor((this.imageWidth-1)*(h-i)/o),p=Math.ceil((this.imageWidth-1)*(u-i)/o);c=n.clamp(c,0,this.imageHeight-1),d=n.clamp(d,0,this.imageHeight-1),f=n.clamp(f,0,this.imageWidth-1),p=n.clamp(p,0,this.imageWidth-1);for(var m=this.imageData,g=Number.MAX_VALUE,b=-g,y=c;y<=d;y++)for(var _=f;_<=p;_++){var E=m[Math.floor(_+y*this.imageWidth)];g>E&&(g=E),b<E&&(b=E)}t[0]>g&&(t[0]=g),t[1]<b&&(t[1]=b)}else t[0]=this.minElevation,t[1]=this.maxElevation;return t},r.prototype.findMinAndMaxElevation=function(){if(this.hasData=!1,this.hasMissingData=!1,this.imageData&&this.imageData.length>0){this.minElevation=Number.MAX_VALUE,this.maxElevation=-Number.MAX_VALUE;for(var e=this.imageData,t=this.imageWidth*this.imageHeight,n=0;n<t;n++){var i=e[n];i!==r.NO_DATA?(this.hasData=!0,this.minElevation>i&&(this.minElevation=i),this.maxElevation<i&&(this.maxElevation=i)):this.hasMissingData=!0}}this.hasData||(this.minElevation=0,this.maxElevation=0)},r}),define("formats/geotiff/GeoTiffConstants",[],function(){"use strict";return{Tag:{MODEL_PIXEL_SCALE:33550,MODEL_TRANSFORMATION:34264,MODEL_TIEPOINT:33922,GEO_KEY_DIRECTORY:34735,GEO_DOUBLE_PARAMS:34736,GEO_ASCII_PARAMS:34737,GDAL_NODATA:42113,GDAL_METADATA:42112},Key:{GTModelTypeGeoKey:1024,GTRasterTypeGeoKey:1025,GTCitationGeoKey:1026,GeographicTypeGeoKey:2048,GeogCitationGeoKey:2049,GeogGeodeticDatumGeoKey:2050,GeogPrimeMeridianGeoKey:2051,GeogLinearUnitsGeoKey:2052,GeogLinearUnitSizeGeoKey:2053,GeogAngularUnitsGeoKey:2054,GeogAngularUnitSizeGeoKey:2055,GeogEllipsoidGeoKey:2056,GeogSemiMajorAxisGeoKey:2057,GeogSemiMinorAxisGeoKey:2058,GeogInvFlatteningGeoKey:2059,GeogAzimuthUnitsGeoKey:2060,GeogPrimeMeridianLongGeoKey:2061,GeogTOWGS84GeoKey:2062,ProjectedCSTypeGeoKey:3072,PCSCitationGeoKey:3073,ProjectionGeoKey:3074,ProjCoordTransGeoKey:3075,ProjLinearUnitsGeoKey:3076,ProjLinearUnitSizeGeoKey:3077,ProjStdParallel1GeoKey:3078,ProjStdParallel2GeoKey:3079,ProjNatOriginLongGeoKey:3080,ProjNatOriginLatGeoKey:3081,ProjFalseEastingGeoKey:3082,ProjFalseNorthingGeoKey:3083,ProjFalseOriginLongGeoKey:3084,ProjFalseOriginLatGeoKey:3085,ProjFalseOriginEastingGeoKey:3086,ProjFalseOriginNorthingGeoKey:3087,ProjCenterLongGeoKey:3088,ProjCenterLatGeoKey:3089,ProjCenterEastingGeoKey:3090,ProjCenterNorthingGeoKey:3091,ProjScaleAtNatOriginGeoKey:3092,ProjScaleAtCenterGeoKey:3093,ProjAzimuthAngleGeoKey:3094,ProjStraightVertPoleLongGeoKey:3095,VerticalCSTypeGeoKey:4096,VerticalCitationGeoKey:4097,VerticalDatumGeoKey:4098,VerticalUnitsGeoKey:4099}}}),define("formats/geotiff/GeoTiffKeyEntry",["../../error/AbstractError","../../error/ArgumentError","./GeoTiffConstants","../../util/Logger"],function(e,t,n,r){"use strict";var i=function(e,n,i,s){if(!e)throw new t(r.logMessage(r.LEVEL_SEVERE,"GeoTiffKeyEntry","constructor","missingKeyId"));if(null===n||void 0===n)throw new t(r.logMessage(r.LEVEL_SEVERE,"GeoTiffKeyEntry","constructor","missingTiffTagLocation"));if(!i)throw new t(r.logMessage(r.LEVEL_SEVERE,"GeoTiffKeyEntry","constructor","missingCount"));if(null===s||void 0===s)throw new t(r.logMessage(r.LEVEL_SEVERE,"GeoTiffKeyEntry","constructor","missingValueOffset"));this._keyId=e,this._tiffTagLocation=n,this._count=i,this._valueOffset=s};return Object.defineProperties(i.prototype,{keyId:{get:function(){return this._keyId}},tiffTagLocation:{get:function(){return this._tiffTagLocation}},count:{get:function(){return this._count}},valueOffset:{get:function(){return this._valueOffset}}}),i.prototype.getGeoKeyValue=function(e,t){var r;if(0===this.tiffTagLocation)r=this.valueOffset;else if(this.tiffTagLocation===n.Tag.GEO_ASCII_PARAMS){var i="";if(t){for(var s=this.valueOffset;s<this.count-1;s++)i+=t[s];"|"!=t[this.count-1]&&(i+=t[this.count-1]),r=i}}else this.tiffTagLocation===n.Tag.GEO_DOUBLE_PARAMS&&e&&(r=e[this.valueOffset]);return r},i}),define("formats/geotiff/GeoTiffMetadata",[],function(){"use strict";var e=function(){this._bitsPerSample=null,this._colorMap=null,this._compression=null,this._extraSamples=null,this._imageDescription=null,this._imageLength=null,this._imageWidth=null,this._maxSampleValue=null,this._minSampleValue=null,this._orientation=0,this._photometricInterpretation=null,this._planarConfiguration=null,this._resolutionUnit=null,this._rowsPerStrip=null,this._samplesPerPixel=null,this._sampleFormat=null,this._software=null,this._stripByteCounts=null,this._stripOffsets=null,this._tileByteCounts=null,this._tileOffsets=null,this._tileLength=null,this._tileWidth=null,this._xResolution=null,this._yResolution=null,this._geoAsciiParams=null,this._geoDoubleParams=null,this._geoKeyDirectory=null,this._modelPixelScale=null,this._modelTiepoint=null,this._modelTransformation=null,this._noData=null,this._metaData=null,this._bbox=null,this._gtModelTypeGeoKey=null,this._gtRasterTypeGeoKey=null,this._gtCitationGeoKey=null,this._geographicTypeGeoKey=null,this._geogCitationGeoKey=null,this._geogAngularUnitsGeoKey=null,this._geogAngularUnitSizeGeoKey=null,this._geogSemiMajorAxisGeoKey=null,this._geogInvFlatteningGeoKey=null,this._projectedCSType=null,this._projLinearUnits=null};return Object.defineProperties(e.prototype,{bitsPerSample:{get:function(){return this._bitsPerSample},set:function(e){this._bitsPerSample=e}},colorMap:{get:function(){return this._colorMap},set:function(e){this._colorMap=e}},compression:{get:function(){return this._compression},set:function(e){this._compression=e}},extraSamples:{get:function(){return this._extraSamples},set:function(e){this._extraSamples=e}},imageDescription:{get:function(){return this._imageDescription},set:function(e){this._imageDescription=e}},imageLength:{get:function(){return this._imageLength},set:function(e){this._imageLength=e}},imageWidth:{get:function(){return this._imageWidth},set:function(e){this._imageWidth=e}},maxSampleValue:{get:function(){return this._maxSampleValue},set:function(e){this._maxSampleValue=e}},minSampleValue:{get:function(){return this._minSampleValue},set:function(e){this._minSampleValue=e}},orientation:{get:function(){return this._orientation},set:function(e){this._orientation=e}},photometricInterpretation:{get:function(){return this._photometricInterpretation},set:function(e){this._photometricInterpretation=e}},planarConfiguration:{get:function(){return this._planarConfiguration},set:function(e){this._planarConfiguration=e}},resolutionUnit:{get:function(){return this._resolutionUnit},set:function(e){this._resolutionUnit=e}},rowsPerStrip:{get:function(){return this._rowsPerStrip},set:function(e){this._rowsPerStrip=e}},samplesPerPixel:{get:function(){return this._samplesPerPixel},set:function(e){this._samplesPerPixel=e}},sampleFormat:{get:function(){return this._sampleFormat},set:function(e){this._sampleFormat=e}},software:{get:function(){return this._software},set:function(e){this._software=e}},stripByteCounts:{get:function(){return this._stripByteCounts},set:function(e){this._stripByteCounts=e}},stripOffsets:{get:function(){return this._stripOffsets},set:function(e){this._stripOffsets=e}},tileByteCounts:{get:function(){return this._tileByteCounts},set:function(e){this._tileByteCounts=e}},tileOffsets:{get:function(){return this._tileOffsets},set:function(e){this._tileOffsets=e}},tileLength:{get:function(){return this._tileLength},set:function(e){this._tileLength=e}},tileWidth:{get:function(){return this._tileWidth},set:function(e){this._tileWidth=e}},geoAsciiParams:{get:function(){return this._geoAsciiParams},set:function(e){this._geoAsciiParams=e}},geoDoubleParams:{get:function(){return this._geoDoubleParams},set:function(e){this._geoDoubleParams=e}},geoKeyDirectory:{get:function(){return this._geoKeyDirectory},set:function(e){this._geoKeyDirectory=e}},modelPixelScale:{get:function(){return this._modelPixelScale},set:function(e){this._modelPixelScale=e}},modelTiepoint:{get:function(){return this._modelTiepoint},set:function(e){this._modelTiepoint=e}},modelTransformation:{get:function(){return this._modelTransformation},set:function(e){this._modelTransformation=e}},noData:{get:function(){return this._noData},set:function(e){this._noData=e}},metaData:{get:function(){return this._metaData},set:function(e){this._metaData=e}},bbox:{get:function(){return this._bbox},set:function(e){this._bbox=e}},gtModelTypeGeoKey:{get:function(){return this._gtModelTypeGeoKey},set:function(e){this._gtModelTypeGeoKey=e}},gtRasterTypeGeoKey:{get:function(){return this._gtRasterTypeGeoKey},set:function(e){this._gtRasterTypeGeoKey=e}},gtCitationGeoKey:{get:function(){return this._gtCitationGeoKey},set:function(e){this._gtCitationGeoKey=e}},geographicTypeGeoKey:{get:function(){return this._geographicTypeGeoKey},set:function(e){this._geographicTypeGeoKey=e}},geogCitationGeoKey:{get:function(){return this._geogCitationGeoKey},set:function(e){this._geogCitationGeoKey=e}},geogAngularUnitsGeoKey:{get:function(){return this._geogAngularUnitsGeoKey},set:function(e){this._geogAngularUnitsGeoKey=e}},geogAngularUnitSizeGeoKey:{get:function(){return this._geogAngularUnitSizeGeoKey},set:function(e){this._geogAngularUnitSizeGeoKey=e}},geogSemiMajorAxisGeoKey:{get:function(){return this._geogSemiMajorAxisGeoKey},set:function(e){this._geogSemiMajorAxisGeoKey=e}},geogInvFlatteningGeoKey:{get:function(){return this._geogInvFlatteningGeoKey},set:function(e){this._geogInvFlatteningGeoKey=e}},projectedCSType:{get:function(){return this._projectedCSType},set:function(e){this._projectedCSType=e}},projLinearUnits:{get:function(){return this._projLinearUnits},set:function(e){this._projLinearUnits=e}},xResolution:{get:function(){return this._xResolution},set:function(e){this._xResolution=e}},yResolution:{get:function(){return this._yResolution},set:function(e){this._yResolution=e}}}),e}),define("formats/geotiff/TiffConstants",[],function(){"use strict";return{Tag:{NEW_SUBFILE_TYPE:254,SUBFILE_TYPE:255,IMAGE_WIDTH:256,IMAGE_LENGTH:257,BITS_PER_SAMPLE:258,COMPRESSION:259,PHOTOMETRIC_INTERPRETATION:262,THRESHHOLDING:263,CELL_WIDTH:264,CELL_LENGTH:265,FILL_ORDER:266,DOCUMENT_NAME:269,IMAGE_DESCRIPTION:270,MAKE:271,MODEL:272,STRIP_OFFSETS:273,ORIENTATION:274,SAMPLES_PER_PIXEL:277,ROWS_PER_STRIP:278,STRIP_BYTE_COUNTS:279,MIN_SAMPLE_VALUE:280,MAX_SAMPLE_VALUE:281,X_RESOLUTION:282,Y_RESOLUTION:283,PLANAR_CONFIGURATION:284,PAGE_NAME:285,X_POSITION:286,Y_POSITION:287,FREE_OFFSETS:288,FREE_BYTE_COUNTS:289,GRAY_RESPONSE_UNIT:290,GRAY_RESPONSE_CURVE:291,T4_OPTIONS:292,T6_PTIONS:293,RESOLUTION_UNIT:296,PAGE_NUMBER:297,TRANSFER_FUNCTION:301,SOFTWARE:305,DATE_TIME:306,ARTIST:315,HOST_COMPUTER:316,PREDICTOR:317,WHITE_POINT:318,PRIMARY_CHROMATICITIES:319,COLOR_MAP:320,HALFTONE_HINTS:321,TILE_WIDTH:322,TILE_LENGTH:323,TILE_OFFSETS:324,TILE_BYTE_COUNTS:325,INK_SET:332,INK_NAMES:333,NUMBER_OF_INKS:334,DOT_RANGE:336,TARGET_PRINTER:337,EXTRA_SAMPLES:338,SAMPLE_FORMAT:339,S_MIN_SAMPLE_VALUE:340,S_MAX_SAMPLE_VALUE:341,TRANSFER_RANGE:342,JPEG_PROC:512,JPEG_INTERCHANGE_FORMAT:513,JPEG_INTERCHANGE_FORMAT_LENGTH:514,JPEG_RESTART_INTERVAL:515,JPEG_LOSSLESS_PREDICTORS:517,JPEG_POINT_TRANSFORMS:518,JPEG_Q_TABLES:519,JPEG_DC_TABLES:520,JPEG_AC_TABLES:521,Y_Cb_Cr_COEFFICIENTS:529,Y_Cb_Cr_SUB_SAMPLING:530,Y_Cb_Cr_POSITIONING:531,REFERENCE_BLACK_WHITE:532,COPYRIGHT:33432},Compression:{UNCOMPRESSED:1,CCITT_1D:2,GROUP_3_FAX:3,GROUP_4_FAX:4,LZW:5,JPEG:6,PACK_BITS:32773},Orientation:{Row0_IS_TOP__Col0_IS_LHS:1,Row0_IS_TOP__Col0_IS_RHS:2,Row0_IS_BOTTOM__Col0_IS_RHS:3,Row0_IS_BOTTOM__Col0_IS_LHS:4,Row0_IS_LHS__Col0_IS_TOP:5,Row0_IS_RHS__Col0_IS_TOP:6,Row0_IS_RHS__Col0_IS_BOTTOM:7,Row0_IS_LHS__Col0_IS_BOTTOM:8},PhotometricInterpretation:{WHITE_IS_ZERO:0,BLACK_IS_ZERO:1,RGB:2,RGB_PALETTE:3,TRANSPARENCY_MASK:4,CMYK:5,Y_Cb_Cr:6,CIE_LAB:7},PlanarConfiguration:{CHUNKY:1,PLANAR:2},ResolutionUnit:{NONE:1,INCH:2,CENTIMETER:3},SampleFormat:{UNSIGNED:1,SIGNED:2,IEEE_FLOAT:3,UNDEFINED:4,DEFAULT:1},Type:{BYTE:1,ASCII:2,SHORT:3,LONG:4,RATIONAL:5,SBYTE:6,UNDEFINED:7,SSHORT:8,SLONG:9,SRATIONAL:10,FLOAT:11,DOUBLE:12}}}),define("formats/geotiff/GeoTiffUtil",["../../error/ArgumentError","../../util/Logger","./TiffConstants"],function(e,t,n){"use strict";return{getBytes:function(n,r,i,s,o){if(i<=0)throw new e(t.logMessage(t.LEVEL_SEVERE,"GeoTiffReader","getBytes","noBytesRequested"));if(i<=1)return o?n.getInt8(r,s):n.getUint8(r,s);if(i<=2)return o?n.getInt16(r,s):n.getUint16(r,s);if(i<=3)return o?n.getInt32(r,s)>>>8:n.getUint32(r,s)>>>8;if(i<=4)return o?n.getInt32(r,s):n.getUint32(r,s);if(i<=8)return n.getFloat64(r,s);throw new e(t.logMessage(t.LEVEL_SEVERE,"GeoTiffReader","getBytes","tooManyBytesRequested"))},getSampleBytes:function(e,r,i,s,o){var a;switch(s){case n.SampleFormat.UNSIGNED:a=this.getBytes(e,r,i,o,!1);break;case n.SampleFormat.SIGNED:a=this.getBytes(e,r,i,o,!0);break;case n.SampleFormat.IEEE_FLOAT:3==i?a=e.getFloat32(r,o)>>>8:4==i?a=e.getFloat32(r,o):8==i?a=e.getFloat64(r,o):t.log(t.LEVEL_WARNING,"Do not attempt to parse the data  not handled: "+i);break;case n.SampleFormat.UNDEFINED:default:a=this.getBytes(e,r,i,o,!1)}return a},getRGBAFillValue:function(e,t,n,r){return void 0===r&&(r=1),"rgba("+e+", "+t+", "+n+", "+r+")"},clampColorSample:function(e,t){var n=Math.pow(2,8-t);return Math.floor(e*n+(n-1))}}}),define("util/proj4-src",[],function(){"use strict";function e(e,t){if(e[t])return e[t];for(var n,r=Object.keys(e),i=t.toLowerCase().replace(tn,""),s=-1;++s<r.length;)if(n=r[s],n.toLowerCase().replace(tn,"")===i)return e[n]}function t(e){if("string"!=typeof e)throw new Error("not a string");this.text=e.trim(),this.level=0,this.place=0,this.root=null,this.stack=[],this.currentObject=null,this.state=rn}function n(e){return new t(e).output()}function r(e,t,n){Array.isArray(t)&&(n.unshift(t),t=null);var r=t?{}:e,s=n.reduce(function(e,t){return i(t,e),e},r);t&&(e[t]=s)}function i(e,t){if(!Array.isArray(e))return void(t[e]=!0);var n=e.shift();if("PARAMETER"===n&&(n=e.shift()),1===e.length)return Array.isArray(e[0])?(t[n]={},void i(e[0],t[n])):void(t[n]=e[0]);if(!e.length)return void(t[n]=!0);if("TOWGS84"===n)return void(t[n]=e);Array.isArray(n)||(t[n]={});var s;switch(n){case"UNIT":case"PRIMEM":case"VERT_DATUM":return t[n]={name:e[0].toLowerCase(),convert:e[1]},void(3===e.length&&i(e[2],t[n]));case"SPHEROID":case"ELLIPSOID":return t[n]={name:e[0],a:e[1],
rf:e[2]},void(4===e.length&&i(e[3],t[n]));case"PROJECTEDCRS":case"PROJCRS":case"GEOGCS":case"GEOCCS":case"PROJCS":case"LOCAL_CS":case"GEODCRS":case"GEODETICCRS":case"GEODETICDATUM":case"EDATUM":case"ENGINEERINGDATUM":case"VERT_CS":case"VERTCRS":case"VERTICALCRS":case"COMPD_CS":case"COMPOUNDCRS":case"ENGINEERINGCRS":case"ENGCRS":case"FITTED_CS":case"LOCAL_DATUM":case"DATUM":return e[0]=["name",e[0]],void r(t,n,e);default:for(s=-1;++s<e.length;)if(!Array.isArray(e[s]))return i(e,t[n]);return r(t,n,e)}}function s(e,t){var n=t[0],r=t[1];!(n in e)&&r in e&&(e[n]=e[r],3===t.length&&(e[n]=t[2](e[n])))}function o(e){return e*un}function a(e){function t(t){return t*(e.to_meter||1)}"GEOGCS"===e.type?e.projName="longlat":"LOCAL_CS"===e.type?(e.projName="identity",e.local=!0):"object"==typeof e.PROJECTION?e.projName=Object.keys(e.PROJECTION)[0]:e.projName=e.PROJECTION,e.UNIT&&(e.units=e.UNIT.name.toLowerCase(),"metre"===e.units&&(e.units="meter"),e.UNIT.convert&&("GEOGCS"===e.type?e.DATUM&&e.DATUM.SPHEROID&&(e.to_meter=e.UNIT.convert*e.DATUM.SPHEROID.a):e.to_meter=e.UNIT.convert));var n=e.GEOGCS;"GEOGCS"===e.type&&(n=e),n&&(n.DATUM?e.datumCode=n.DATUM.name.toLowerCase():e.datumCode=n.name.toLowerCase(),"d_"===e.datumCode.slice(0,2)&&(e.datumCode=e.datumCode.slice(2)),"new_zealand_geodetic_datum_1949"!==e.datumCode&&"new_zealand_1949"!==e.datumCode||(e.datumCode="nzgd49"),"wgs_1984"===e.datumCode&&("Mercator_Auxiliary_Sphere"===e.PROJECTION&&(e.sphere=!0),e.datumCode="wgs84"),"_ferro"===e.datumCode.slice(-6)&&(e.datumCode=e.datumCode.slice(0,-6)),"_jakarta"===e.datumCode.slice(-8)&&(e.datumCode=e.datumCode.slice(0,-8)),~e.datumCode.indexOf("belge")&&(e.datumCode="rnb72"),n.DATUM&&n.DATUM.SPHEROID&&(e.ellps=n.DATUM.SPHEROID.name.replace("_19","").replace(/[Cc]larke\_18/,"clrk"),"international"===e.ellps.toLowerCase().slice(0,13)&&(e.ellps="intl"),e.a=n.DATUM.SPHEROID.a,e.rf=parseFloat(n.DATUM.SPHEROID.rf,10)),n.DATUM&&n.DATUM.TOWGS84&&(e.datum_params=n.DATUM.TOWGS84),~e.datumCode.indexOf("osgb_1936")&&(e.datumCode="osgb36"),~e.datumCode.indexOf("osni_1952")&&(e.datumCode="osni52"),(~e.datumCode.indexOf("tm65")||~e.datumCode.indexOf("geodetic_datum_of_1965"))&&(e.datumCode="ire65"),"ch1903+"===e.datumCode&&(e.datumCode="ch1903"),~e.datumCode.indexOf("israel")&&(e.datumCode="isr93")),e.b&&!isFinite(e.b)&&(e.b=e.a),[["standard_parallel_1","Standard_Parallel_1"],["standard_parallel_2","Standard_Parallel_2"],["false_easting","False_Easting"],["false_northing","False_Northing"],["central_meridian","Central_Meridian"],["latitude_of_origin","Latitude_Of_Origin"],["latitude_of_origin","Central_Parallel"],["scale_factor","Scale_Factor"],["k0","scale_factor"],["latitude_of_center","Latitude_Of_Center"],["latitude_of_center","Latitude_of_center"],["lat0","latitude_of_center",o],["longitude_of_center","Longitude_Of_Center"],["longitude_of_center","Longitude_of_center"],["longc","longitude_of_center",o],["x0","false_easting",t],["y0","false_northing",t],["long0","central_meridian",o],["lat0","latitude_of_origin",o],["lat0","standard_parallel_1",o],["lat1","standard_parallel_1",o],["lat2","standard_parallel_2",o],["azimuth","Azimuth"],["alpha","azimuth",o],["srsCode","name"]].forEach(function(t){return s(e,t)}),e.long0||!e.longc||"Albers_Conic_Equal_Area"!==e.projName&&"Lambert_Azimuthal_Equal_Area"!==e.projName||(e.long0=e.longc),e.lat_ts||!e.lat1||"Stereographic_South_Pole"!==e.projName&&"Polar Stereographic (variant B)"!==e.projName||(e.lat0=o(e.lat1>0?90:-90),e.lat_ts=e.lat1)}function l(e){var t=this;if(2===arguments.length){var n=arguments[1];"string"==typeof n?"+"===n.charAt(0)?l[e]=nn(arguments[1]):l[e]=cn(arguments[1]):l[e]=n}else if(1===arguments.length){if(Array.isArray(e))return e.map(function(e){Array.isArray(e)?l.apply(t,e):l(e)});if("string"==typeof e){if(e in l)return l[e]}else"EPSG"in e?l["EPSG:"+e.EPSG]=e:"ESRI"in e?l["ESRI:"+e.ESRI]=e:"IAU2000"in e?l["IAU2000:"+e.IAU2000]=e:console.log(e);return}}function h(e){return"string"==typeof e}function u(e){return e in l}function c(e){return dn.some(function(t){return e.indexOf(t)>-1})}function d(t){var n=e(t,"authority");if(n){var r=e(n,"epsg");return r&&fn.indexOf(r)>-1}}function f(t){var n=e(t,"extension");if(n)return e(n,"proj4")}function p(e){return"+"===e[0]}function m(e){if(!h(e))return e;if(u(e))return l[e];if(c(e)){var t=cn(e);if(d(t))return l["EPSG:3857"];var n=f(t);return n?nn(n):t}return p(e)?nn(e):void 0}function g(){var e=this.b/this.a;this.es=1-e*e,"x0"in this||(this.x0=0),"y0"in this||(this.y0=0),this.e=Math.sqrt(this.es),this.lat_ts?this.sphere?this.k0=Math.cos(this.lat_ts):this.k0=mn(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts)):this.k0||(this.k?this.k0=this.k:this.k0=1)}function b(e){var t=e.x,n=e.y;if(n*Zt>90&&n*Zt<-90&&t*Zt>180&&t*Zt<-180)return null;var r,i;if(Math.abs(Math.abs(n)-Ut)<=qt)return null;if(this.sphere)r=this.x0+this.a*this.k0*bn(t-this.long0),i=this.y0+this.a*this.k0*Math.log(Math.tan(Xt+.5*n));else{var s=Math.sin(n),o=yn(this.e,n,s);r=this.x0+this.a*this.k0*bn(t-this.long0),i=this.y0-this.a*this.k0*Math.log(o)}return e.x=r,e.y=i,e}function y(e){var t,n,r=e.x-this.x0,i=e.y-this.y0;if(this.sphere)n=Ut-2*Math.atan(Math.exp(-i/(this.a*this.k0)));else{var s=Math.exp(-i/(this.a*this.k0));if(-9999===(n=_n(this.e,s)))return null}return t=bn(this.long0+r/(this.a*this.k0)),e.x=t,e.y=n,e}function _(){}function E(e){return e}function v(e,t){var n=xn.length;return e.names?(xn[n]=e,e.names.forEach(function(e){Ln[e.toLowerCase()]=n}),this):(console.log(t),!0)}function w(e){if(!e)return!1;var t=e.toLowerCase();return void 0!==Ln[t]&&xn[Ln[t]]?xn[Ln[t]]:void 0}function S(){Tn.forEach(v)}function T(e,t,n,r){var i=e*e,s=t*t,o=(i-s)/i,a=0;return r?(e*=1-o*(zt+o*(Kt+o*Ht)),i=e*e,o=0):a=Math.sqrt(o),{es:o,e:a,ep2:(i-s)/s}}function L(t,n,r,i,s){if(!t){var o=e(An,i);o||(o=Cn),t=o.a,n=o.b,r=o.rf}return r&&!n&&(n=(1-1/r)*t),(0===r||Math.abs(t-n)<qt)&&(s=!0,n=t),{a:t,b:n,rf:r,sphere:s}}function x(e,t,n,r,i,s){var o={};return o.datum_type=void 0===e||"none"===e?Gt:Vt,t&&(o.datum_params=t.map(parseFloat),0===o.datum_params[0]&&0===o.datum_params[1]&&0===o.datum_params[2]||(o.datum_type=Bt),o.datum_params.length>3&&(0===o.datum_params[3]&&0===o.datum_params[4]&&0===o.datum_params[5]&&0===o.datum_params[6]||(o.datum_type=Wt,o.datum_params[3]*=jt,o.datum_params[4]*=jt,o.datum_params[5]*=jt,o.datum_params[6]=o.datum_params[6]/1e6+1))),o.a=n,o.b=r,o.es=i,o.ep2=s,o}function R(t,n){if(!(this instanceof R))return new R(t);n=n||function(e){if(e)throw e};var r=m(t);if("object"!=typeof r)return void n(t);var i=R.projections.get(r.projName);if(!i)return void n(t);if(r.datumCode&&"none"!==r.datumCode){var s=e(Mn,r.datumCode);s&&(r.datum_params=s.towgs84?s.towgs84.split(","):null,r.ellps=s.ellipse,r.datumName=s.datumName?s.datumName:r.datumCode)}r.k0=r.k0||1,r.axis=r.axis||"enu",r.ellps=r.ellps||"wgs84";var o=L(r.a,r.b,r.rf,r.ellps,r.sphere),a=T(o.a,o.b,o.rf,r.R_A),l=r.datum||x(r.datumCode,r.datum_params,o.a,o.b,a.es,a.ep2);pn(this,r),pn(this,i),this.a=o.a,this.b=o.b,this.rf=o.rf,this.sphere=o.sphere,this.es=a.es,this.e=a.e,this.ep2=a.ep2,this.datum=l,this.init(),n(null,this)}function A(e,t){return e.datum_type===t.datum_type&&(!(e.a!==t.a||Math.abs(e.es-t.es)>5e-11)&&(e.datum_type===Bt?e.datum_params[0]===t.datum_params[0]&&e.datum_params[1]===t.datum_params[1]&&e.datum_params[2]===t.datum_params[2]:e.datum_type!==Wt||e.datum_params[0]===t.datum_params[0]&&e.datum_params[1]===t.datum_params[1]&&e.datum_params[2]===t.datum_params[2]&&e.datum_params[3]===t.datum_params[3]&&e.datum_params[4]===t.datum_params[4]&&e.datum_params[5]===t.datum_params[5]&&e.datum_params[6]===t.datum_params[6]))}function C(e,t,n){var r,i,s,o,a=e.x,l=e.y,h=e.z?e.z:0;if(l<-Ut&&l>-1.001*Ut)l=-Ut;else if(l>Ut&&l<1.001*Ut)l=Ut;else{if(l<-Ut)return{x:-1/0,y:-1/0,z:e.z};if(l>Ut)return{x:1/0,y:1/0,z:e.z}}return a>Math.PI&&(a-=2*Math.PI),i=Math.sin(l),o=Math.cos(l),s=i*i,r=n/Math.sqrt(1-t*s),{x:(r+h)*o*Math.cos(a),y:(r+h)*o*Math.sin(a),z:(r*(1-t)+h)*i}}function M(e,t,n,r){var i,s,o,a,l,h,u,c,d,f,p,m,g,b,y,_,E=e.x,v=e.y,w=e.z?e.z:0;if(i=Math.sqrt(E*E+v*v),s=Math.sqrt(E*E+v*v+w*w),i/n<1e-12){if(b=0,s/n<1e-12)return y=Ut,_=-r,{x:e.x,y:e.y,z:e.z}}else b=Math.atan2(v,E);o=w/s,a=i/s,l=1/Math.sqrt(1-t*(2-t)*a*a),c=a*(1-t)*l,d=o*l,g=0;do{g++,u=n/Math.sqrt(1-t*d*d),_=i*c+w*d-u*(1-t*d*d),h=t*u/(u+_),l=1/Math.sqrt(1-h*(2-h)*a*a),f=a*(1-h)*l,p=o*l,m=p*c-f*d,c=f,d=p}while(m*m>1e-24&&g<30);return y=Math.atan(p/Math.abs(f)),{x:b,y:y,z:_}}function k(e,t,n){if(t===Bt)return{x:e.x+n[0],y:e.y+n[1],z:e.z+n[2]};if(t===Wt){var r=n[0],i=n[1],s=n[2],o=n[3],a=n[4],l=n[5],h=n[6];return{x:h*(e.x-l*e.y+a*e.z)+r,y:h*(l*e.x+e.y-o*e.z)+i,z:h*(-a*e.x+o*e.y+e.z)+s}}}function I(e,t,n){if(t===Bt)return{x:e.x-n[0],y:e.y-n[1],z:e.z-n[2]};if(t===Wt){var r=n[0],i=n[1],s=n[2],o=n[3],a=n[4],l=n[5],h=n[6],u=(e.x-r)/h,c=(e.y-i)/h,d=(e.z-s)/h;return{x:u+l*c-a*d,y:-l*u+c+o*d,z:a*u-o*c+d}}}function O(e){return e===Bt||e===Wt}function P(e){if("function"==typeof Number.isFinite){if(Number.isFinite(e))return;throw new TypeError("coordinates must be finite numbers")}if("number"!=typeof e||e!==e||!isFinite(e))throw new TypeError("coordinates must be finite numbers")}function N(e,t){return(e.datum.datum_type===Bt||e.datum.datum_type===Wt)&&"WGS84"!==t.datumCode||(t.datum.datum_type===Bt||t.datum.datum_type===Wt)&&"WGS84"!==e.datumCode}function D(e,t,n){var r;return Array.isArray(n)&&(n=On(n)),Pn(n),e.datum&&t.datum&&N(e,t)&&(r=new R("WGS84"),n=D(e,r,n),e=r),"enu"!==e.axis&&(n=In(e,!1,n)),"longlat"===e.projName?n={x:n.x*Yt,y:n.y*Yt,z:n.z||0}:(e.to_meter&&(n={x:n.x*e.to_meter,y:n.y*e.to_meter,z:n.z||0}),n=e.inverse(n)),e.from_greenwich&&(n.x+=e.from_greenwich),n=kn(e.datum,t.datum,n),t.from_greenwich&&(n={x:n.x-t.from_greenwich,y:n.y,z:n.z||0}),"longlat"===t.projName?n={x:n.x*Zt,y:n.y*Zt,z:n.z||0}:(n=t.forward(n),t.to_meter&&(n={x:n.x/t.to_meter,y:n.y/t.to_meter,z:n.z||0})),"enu"!==t.axis?In(t,!0,n):n}function F(e,t,n){var r,i,s;return Array.isArray(n)?(r=D(e,t,n)||{x:NaN,y:NaN},n.length>2?void 0!==e.name&&"geocent"===e.name||void 0!==t.name&&"geocent"===t.name?"number"==typeof r.z?[r.x,r.y,r.z].concat(n.splice(3)):[r.x,r.y,n[2]].concat(n.splice(3)):[r.x,r.y].concat(n.splice(2)):[r.x,r.y]):(i=D(e,t,n),s=Object.keys(n),2===s.length?i:(s.forEach(function(r){if(void 0!==e.name&&"geocent"===e.name||void 0!==t.name&&"geocent"===t.name){if("x"===r||"y"===r||"z"===r)return}else if("x"===r||"y"===r)return;i[r]=n[r]}),i))}function B(e){return e instanceof R?e:e.oProj?e.oProj:R(e)}function W(e,t,n){e=B(e);var r,i=!1;return void 0===t?(t=e,e=Nn,i=!0):(void 0!==t.x||Array.isArray(t))&&(n=t,t=e,e=Nn,i=!0),t=B(t),n?F(e,t,n):(r={forward:function(n){return F(e,t,n)},inverse:function(n){return F(t,e,n)}},i&&(r.oProj=t),r)}function V(e,t){return t=t||5,Y(K({lat:e[1],lon:e[0]}),t)}function G(e){var t=H(Q(e.toUpperCase()));return t.lat&&t.lon?[t.lon,t.lat,t.lon,t.lat]:[t.left,t.bottom,t.right,t.top]}function j(e){var t=H(Q(e.toUpperCase()));return t.lat&&t.lon?[t.lon,t.lat]:[(t.left+t.right)/2,(t.top+t.bottom)/2]}function U(e){return e*(Math.PI/180)}function z(e){return e/Math.PI*180}function K(e){var t,n,r,i,s,o,a,l,h,u=e.lat,c=e.lon,d=6378137,f=U(u),p=U(c);h=Math.floor((c+180)/6)+1,180===c&&(h=60),u>=56&&u<64&&c>=3&&c<12&&(h=32),u>=72&&u<84&&(c>=0&&c<9?h=31:c>=9&&c<21?h=33:c>=21&&c<33?h=35:c>=33&&c<42&&(h=37)),t=6*(h-1)-180+3,l=U(t),n=.006739496752268451,r=d/Math.sqrt(1-.00669438*Math.sin(f)*Math.sin(f)),i=Math.tan(f)*Math.tan(f),s=n*Math.cos(f)*Math.cos(f),o=Math.cos(f)*(p-l),a=d*(.9983242984503243*f-.002514607064228144*Math.sin(2*f)+2639046602129982e-21*Math.sin(4*f)-3.418046101696858e-9*Math.sin(6*f));var m=.9996*r*(o+(1-i+s)*o*o*o/6+(5-18*i+i*i+72*s-58*n)*o*o*o*o*o/120)+5e5,g=.9996*(a+r*Math.tan(f)*(o*o/2+(5-i+9*s+4*s*s)*o*o*o*o/24+(61-58*i+i*i+600*s-330*n)*o*o*o*o*o*o/720));return u<0&&(g+=1e7),{northing:Math.round(g),easting:Math.round(m),zoneNumber:h,zoneLetter:q(u)}}function H(e){var t=e.northing,n=e.easting,r=e.zoneLetter,i=e.zoneNumber;if(i<0||i>60)return null;var s,o,a,l,h,u,c,d,f,p,m=6378137,g=(1-Math.sqrt(.99330562))/(1+Math.sqrt(.99330562)),b=n-5e5,y=t;r<"N"&&(y-=1e7),d=6*(i-1)-180+3,s=.006739496752268451,c=y/.9996,f=c/6367449.145945056,p=f+(3*g/2-27*g*g*g/32)*Math.sin(2*f)+(21*g*g/16-55*g*g*g*g/32)*Math.sin(4*f)+151*g*g*g/96*Math.sin(6*f),o=m/Math.sqrt(1-.00669438*Math.sin(p)*Math.sin(p)),a=Math.tan(p)*Math.tan(p),l=s*Math.cos(p)*Math.cos(p),h=.99330562*m/Math.pow(1-.00669438*Math.sin(p)*Math.sin(p),1.5),u=b/(.9996*o);var _=p-o*Math.tan(p)/h*(u*u/2-(5+3*a+10*l-4*l*l-9*s)*u*u*u*u/24+(61+90*a+298*l+45*a*a-252*s-3*l*l)*u*u*u*u*u*u/720);_=z(_);var E=(u-(1+2*a+l)*u*u*u/6+(5-2*l+28*a-3*l*l+8*s+24*a*a)*u*u*u*u*u/120)/Math.cos(p);E=d+z(E);var v;if(e.accuracy){var w=H({northing:e.northing+e.accuracy,easting:e.easting+e.accuracy,zoneLetter:e.zoneLetter,zoneNumber:e.zoneNumber});v={top:w.lat,right:w.lon,bottom:_,left:E}}else v={lat:_,lon:E};return v}function q(e){var t="Z";return 84>=e&&e>=72?t="X":72>e&&e>=64?t="W":64>e&&e>=56?t="V":56>e&&e>=48?t="U":48>e&&e>=40?t="T":40>e&&e>=32?t="S":32>e&&e>=24?t="R":24>e&&e>=16?t="Q":16>e&&e>=8?t="P":8>e&&e>=0?t="N":0>e&&e>=-8?t="M":-8>e&&e>=-16?t="L":-16>e&&e>=-24?t="K":-24>e&&e>=-32?t="J":-32>e&&e>=-40?t="H":-40>e&&e>=-48?t="G":-48>e&&e>=-56?t="F":-56>e&&e>=-64?t="E":-64>e&&e>=-72?t="D":-72>e&&e>=-80&&(t="C"),t}function Y(e,t){var n="00000"+e.easting,r="00000"+e.northing;return e.zoneNumber+e.zoneLetter+Z(e.easting,e.northing,e.zoneNumber)+n.substr(n.length-5,t)+r.substr(r.length-5,t)}function Z(e,t,n){var r=X(n);return J(Math.floor(e/1e5),Math.floor(t/1e5)%20,r)}function X(e){var t=e%Dn;return 0===t&&(t=Dn),t}function J(e,t,n){var r=n-1,i=Fn.charCodeAt(r),s=Bn.charCodeAt(r),o=i+e-1,a=s+t,l=!1;return o>Un&&(o=o-Un+Wn-1,l=!0),(o===Vn||i<Vn&&o>Vn||(o>Vn||i<Vn)&&l)&&o++,(o===Gn||i<Gn&&o>Gn||(o>Gn||i<Gn)&&l)&&++o===Vn&&o++,o>Un&&(o=o-Un+Wn-1),a>jn?(a=a-jn+Wn-1,l=!0):l=!1,(a===Vn||s<Vn&&a>Vn||(a>Vn||s<Vn)&&l)&&a++,(a===Gn||s<Gn&&a>Gn||(a>Gn||s<Gn)&&l)&&++a===Vn&&a++,a>jn&&(a=a-jn+Wn-1),String.fromCharCode(o)+String.fromCharCode(a)}function Q(e){if(e&&0===e.length)throw"MGRSPoint coverting from nothing";for(var t,n=e.length,r=null,i="",s=0;!/[A-Z]/.test(t=e.charAt(s));){if(s>=2)throw"MGRSPoint bad conversion from: "+e;i+=t,s++}var o=parseInt(i,10);if(0===s||s+3>n)throw"MGRSPoint bad conversion from: "+e;var a=e.charAt(s++);if(a<="A"||"B"===a||"Y"===a||a>="Z"||"I"===a||"O"===a)throw"MGRSPoint zone letter "+a+" not handled: "+e;r=e.substring(s,s+=2);for(var l=X(o),h=$(r.charAt(0),l),u=ee(r.charAt(1),l);u<te(a);)u+=2e6;var c=n-s;if(c%2!=0)throw"MGRSPoint has to have an even number \nof digits after the zone letter and two 100km letters - front \nhalf for easting meters, second half for \nnorthing meters"+e;var d,f,p,m,g,b=c/2,y=0,_=0;return b>0&&(d=1e5/Math.pow(10,b),f=e.substring(s,s+b),y=parseFloat(f)*d,p=e.substring(s+b),_=parseFloat(p)*d),m=y+h,g=_+u,{easting:m,northing:g,zoneLetter:a,zoneNumber:o,accuracy:d}}function $(e,t){for(var n=Fn.charCodeAt(t-1),r=1e5,i=!1;n!==e.charCodeAt(0);){if(n++,n===Vn&&n++,n===Gn&&n++,n>Un){if(i)throw"Bad character: "+e;n=Wn,i=!0}r+=1e5}return r}function ee(e,t){if(e>"V")throw"MGRSPoint given invalid Northing "+e;for(var n=Bn.charCodeAt(t-1),r=0,i=!1;n!==e.charCodeAt(0);){if(n++,n===Vn&&n++,n===Gn&&n++,n>jn){if(i)throw"Bad character: "+e;n=Wn,i=!0}r+=1e5}return r}function te(e){var t;switch(e){case"C":t=11e5;break;case"D":t=2e6;break;case"E":t=28e5;break;case"F":t=37e5;break;case"G":t=46e5;break;case"H":t=55e5;break;case"J":t=64e5;break;case"K":t=73e5;break;case"L":t=82e5;break;case"M":t=91e5;break;case"N":t=0;break;case"P":t=8e5;break;case"Q":t=17e5;break;case"R":t=26e5;break;case"S":t=35e5;break;case"T":t=44e5;break;case"U":t=53e5;break;case"V":t=62e5;break;case"W":t=7e6;break;case"X":t=79e5;break;default:t=-1}if(t>=0)return t;throw"Invalid zone letter: "+e}function ne(e,t,n){if(!(this instanceof ne))return new ne(e,t,n);if(Array.isArray(e))this.x=e[0],this.y=e[1],this.z=e[2]||0;else if("object"==typeof e)this.x=e.x,this.y=e.y,this.z=e.z||0;else if("string"==typeof e&&void 0===t){var r=e.split(",");this.x=parseFloat(r[0],10),this.y=parseFloat(r[1],10),this.z=parseFloat(r[2],10)||0}else this.x=e,this.y=t,this.z=n||0;console.warn("proj4.Point will be removed in version 3, use proj4.toPoint")}function re(){this.x0=void 0!==this.x0?this.x0:0,this.y0=void 0!==this.y0?this.y0:0,this.long0=void 0!==this.long0?this.long0:0,this.lat0=void 0!==this.lat0?this.lat0:0,this.es&&(this.en=Hn(this.es),this.ml0=qn(this.lat0,Math.sin(this.lat0),Math.cos(this.lat0),this.en))}function ie(e){var t,n,r,i=e.x,s=e.y,o=bn(i-this.long0),a=Math.sin(s),l=Math.cos(s);if(this.es){var h=l*o,u=Math.pow(h,2),c=this.ep2*Math.pow(l,2),d=Math.pow(c,2),f=Math.abs(l)>qt?Math.tan(s):0,p=Math.pow(f,2),m=Math.pow(p,2);t=1-this.es*Math.pow(a,2),h/=Math.sqrt(t);var g=qn(s,a,l,this.en);n=this.a*(this.k0*h*(1+u/6*(1-p+c+u/20*(5-18*p+m+14*c-58*p*c+u/42*(61+179*m-m*p-479*p)))))+this.x0,r=this.a*(this.k0*(g-this.ml0+a*o*h/2*(1+u/12*(5-p+9*c+4*d+u/30*(61+m-58*p+270*c-330*p*c+u/56*(1385+543*m-m*p-3111*p))))))+this.y0}else{var b=l*Math.sin(o);if(Math.abs(Math.abs(b)-1)<qt)return 93;if(n=.5*this.a*this.k0*Math.log((1+b)/(1-b))+this.x0,r=l*Math.cos(o)/Math.sqrt(1-Math.pow(b,2)),(b=Math.abs(r))>=1){if(b-1>qt)return 93;r=0}else r=Math.acos(r);s<0&&(r=-r),r=this.a*this.k0*(r-this.lat0)+this.y0}return e.x=n,e.y=r,e}function se(e){var t,n,r,i,s=(e.x-this.x0)*(1/this.a),o=(e.y-this.y0)*(1/this.a);if(this.es)if(t=this.ml0+o/this.k0,n=Yn(t,this.es,this.en),Math.abs(n)<Ut){var a=Math.sin(n),l=Math.cos(n),h=Math.abs(l)>qt?Math.tan(n):0,u=this.ep2*Math.pow(l,2),c=Math.pow(u,2),d=Math.pow(h,2),f=Math.pow(d,2);t=1-this.es*Math.pow(a,2);var p=s*Math.sqrt(t)/this.k0,m=Math.pow(p,2);t*=h,r=n-t*m/(1-this.es)*.5*(1-m/12*(5+3*d-9*u*d+u-4*c-m/30*(61+90*d-252*u*d+45*f+46*u-m/56*(1385+3633*d+4095*f+1574*f*d)))),i=bn(this.long0+p*(1-m/6*(1+2*d+u-m/20*(5+28*d+24*f+8*u*d+6*u-m/42*(61+662*d+1320*f+720*f*d))))/l)}else r=Ut*gn(o),i=0;else{var g=Math.exp(s/this.k0),b=.5*(g-1/g),y=this.lat0+o/this.k0,_=Math.cos(y);t=Math.sqrt((1-Math.pow(_,2))/(1+Math.pow(b,2))),r=Math.asin(t),o<0&&(r=-r),i=0===b&&0===_?0:bn(Math.atan2(b,_)+this.long0)}return e.x=i,e.y=r,e}function oe(){if(void 0===this.es||this.es<=0)throw new Error("incorrect elliptical usage");this.x0=void 0!==this.x0?this.x0:0,this.y0=void 0!==this.y0?this.y0:0,this.long0=void 0!==this.long0?this.long0:0,this.lat0=void 0!==this.lat0?this.lat0:0,this.cgb=[],this.cbg=[],this.utg=[],this.gtu=[];var e=this.es/(1+Math.sqrt(1-this.es)),t=e/(2-e),n=t;this.cgb[0]=t*(2+t*(-2/3+t*(t*(116/45+t*(26/45+t*(-2854/675)))-2))),this.cbg[0]=t*(t*(2/3+t*(4/3+t*(-82/45+t*(32/45+t*(4642/4725)))))-2),n*=t,this.cgb[1]=n*(7/3+t*(t*(-227/45+t*(2704/315+t*(2323/945)))-1.6)),this.cbg[1]=n*(5/3+t*(-16/15+t*(-13/9+t*(904/315+t*(-1522/945))))),n*=t,this.cgb[2]=n*(56/15+t*(-136/35+t*(-1262/105+t*(73814/2835)))),this.cbg[2]=n*(-26/15+t*(34/21+t*(1.6+t*(-12686/2835)))),n*=t,this.cgb[3]=n*(4279/630+t*(-332/35+t*(-399572/14175))),this.cbg[3]=n*(1237/630+t*(t*(-24832/14175)-2.4)),n*=t,this.cgb[4]=n*(4174/315+t*(-144838/6237)),this.cbg[4]=n*(-734/315+t*(109598/31185)),n*=t,this.cgb[5]=n*(601676/22275),this.cbg[5]=n*(444337/155925),n=Math.pow(t,2),this.Qn=this.k0/(1+t)*(1+n*(.25+n*(1/64+n/256))),this.utg[0]=t*(t*(2/3+t*(-37/96+t*(1/360+t*(81/512+t*(-96199/604800)))))-.5),this.gtu[0]=t*(.5+t*(-2/3+t*(5/16+t*(41/180+t*(-127/288+t*(7891/37800)))))),this.utg[1]=n*(-1/48+t*(-1/15+t*(437/1440+t*(-46/105+t*(1118711/3870720))))),this.gtu[1]=n*(13/48+t*(t*(557/1440+t*(281/630+t*(-1983433/1935360)))-.6)),n*=t,this.utg[2]=n*(-17/480+t*(37/840+t*(209/4480+t*(-5569/90720)))),this.gtu[2]=n*(61/240+t*(-103/140+t*(15061/26880+t*(167603/181440)))),n*=t,this.utg[3]=n*(-4397/161280+t*(11/504+t*(830251/7257600))),this.gtu[3]=n*(49561/161280+t*(-179/168+t*(6601661/7257600))),n*=t,this.utg[4]=n*(-4583/161280+t*(108847/3991680)),this.gtu[4]=n*(34729/80640+t*(-3418889/1995840)),n*=t,this.utg[5]=-.03233083094085698*n,this.gtu[5]=.6650675310896665*n;var r=tr(this.cbg,this.lat0);this.Zb=-this.Qn*(r+nr(this.gtu,2*r))}function ae(e){var t=bn(e.x-this.long0),n=e.y;n=tr(this.cbg,n);var r=Math.sin(n),i=Math.cos(n),s=Math.sin(t),o=Math.cos(t);n=Math.atan2(r,o*i),t=Math.atan2(s*i,Qn(r,i*o)),t=er(Math.tan(t));var a=ir(this.gtu,2*n,2*t);n+=a[0],t+=a[1];var l,h;return Math.abs(t)<=2.623395162778?(l=this.a*(this.Qn*t)+this.x0,h=this.a*(this.Qn*n+this.Zb)+this.y0):(l=1/0,h=1/0),e.x=l,e.y=h,e}function le(e){var t=(e.x-this.x0)*(1/this.a),n=(e.y-this.y0)*(1/this.a);n=(n-this.Zb)/this.Qn,t/=this.Qn;var r,i;if(Math.abs(t)<=2.623395162778){var s=ir(this.utg,2*n,2*t);n+=s[0],t+=s[1],t=Math.atan(Jn(t));var o=Math.sin(n),a=Math.cos(n),l=Math.sin(t),h=Math.cos(t);n=Math.atan2(o*h,Qn(l,h*a)),t=Math.atan2(l,h*a),r=bn(t+this.long0),i=tr(this.cgb,n)}else r=1/0,i=1/0;return e.x=r,e.y=i,e}function he(){var e=ar(this.zone,this.long0);if(void 0===e)throw new Error("unknown utm zone");this.lat0=0,this.long0=(6*Math.abs(e)-183)*Yt,this.x0=5e5,this.y0=this.utmSouth?1e7:0,this.k0=.9996,or.init.apply(this),this.forward=or.forward,this.inverse=or.inverse}function ue(){var e=Math.sin(this.lat0),t=Math.cos(this.lat0);t*=t,this.rc=Math.sqrt(1-this.es)/(1-this.es*e*e),this.C=Math.sqrt(1+this.es*t*t/(1-this.es)),this.phic0=Math.asin(e/this.C),this.ratexp=.5*this.C*this.e,this.K=Math.tan(.5*this.phic0+Xt)/(Math.pow(Math.tan(.5*this.lat0+Xt),this.C)*ur(this.e*e,this.ratexp))}function ce(e){var t=e.x,n=e.y;return e.y=2*Math.atan(this.K*Math.pow(Math.tan(.5*n+Xt),this.C)*ur(this.e*Math.sin(n),this.ratexp))-Ut,e.x=this.C*t,e}function de(e){for(var t=e.x/this.C,n=e.y,r=Math.pow(Math.tan(.5*n+Xt)/this.K,1/this.C),i=cr;i>0&&(n=2*Math.atan(r*ur(this.e*Math.sin(e.y),-.5*this.e))-Ut,!(Math.abs(n-e.y)<1e-14));--i)e.y=n;return i?(e.x=t,e.y=n,e):null}function fe(){fr.init.apply(this),this.rc&&(this.sinc0=Math.sin(this.phic0),this.cosc0=Math.cos(this.phic0),this.R2=2*this.rc,this.title||(this.title="Oblique Stereographic Alternative"))}function pe(e){var t,n,r,i;return e.x=bn(e.x-this.long0),fr.forward.apply(this,[e]),t=Math.sin(e.y),n=Math.cos(e.y),r=Math.cos(e.x),i=this.k0*this.R2/(1+this.sinc0*t+this.cosc0*n*r),e.x=i*n*Math.sin(e.x),e.y=i*(this.cosc0*t-this.sinc0*n*r),e.x=this.a*e.x+this.x0,e.y=this.a*e.y+this.y0,e}function me(e){var t,n,r,i,s;if(e.x=(e.x-this.x0)/this.a,e.y=(e.y-this.y0)/this.a,e.x/=this.k0,e.y/=this.k0,s=Math.sqrt(e.x*e.x+e.y*e.y)){var o=2*Math.atan2(s,this.R2);t=Math.sin(o),n=Math.cos(o),i=Math.asin(n*this.sinc0+e.y*t*this.cosc0/s),r=Math.atan2(e.x*t,s*this.cosc0*n-e.y*this.sinc0*t)}else i=this.phic0,r=0;return e.x=r,e.y=i,fr.inverse.apply(this,[e]),e.x=bn(e.x+this.long0),e}function ge(e,t,n){return t*=n,Math.tan(.5*(Ut+e))*Math.pow((1-t)/(1+t),.5*n)}function be(){this.coslat0=Math.cos(this.lat0),this.sinlat0=Math.sin(this.lat0),this.sphere?1===this.k0&&!isNaN(this.lat_ts)&&Math.abs(this.coslat0)<=qt&&(this.k0=.5*(1+gn(this.lat0)*Math.sin(this.lat_ts))):(Math.abs(this.coslat0)<=qt&&(this.lat0>0?this.con=1:this.con=-1),this.cons=Math.sqrt(Math.pow(1+this.e,1+this.e)*Math.pow(1-this.e,1-this.e)),1===this.k0&&!isNaN(this.lat_ts)&&Math.abs(this.coslat0)<=qt&&(this.k0=.5*this.cons*mn(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts))/yn(this.e,this.con*this.lat_ts,this.con*Math.sin(this.lat_ts))),this.ms1=mn(this.e,this.sinlat0,this.coslat0),this.X0=2*Math.atan(this.ssfn_(this.lat0,this.sinlat0,this.e))-Ut,this.cosX0=Math.cos(this.X0),this.sinX0=Math.sin(this.X0))}function ye(e){var t,n,r,i,s,o,a=e.x,l=e.y,h=Math.sin(l),u=Math.cos(l),c=bn(a-this.long0);return Math.abs(Math.abs(a-this.long0)-Math.PI)<=qt&&Math.abs(l+this.lat0)<=qt?(e.x=NaN,e.y=NaN,e):this.sphere?(t=2*this.k0/(1+this.sinlat0*h+this.coslat0*u*Math.cos(c)),e.x=this.a*t*u*Math.sin(c)+this.x0,e.y=this.a*t*(this.coslat0*h-this.sinlat0*u*Math.cos(c))+this.y0,e):(n=2*Math.atan(this.ssfn_(l,h,this.e))-Ut,i=Math.cos(n),r=Math.sin(n),Math.abs(this.coslat0)<=qt?(s=yn(this.e,l*this.con,this.con*h),o=2*this.a*this.k0*s/this.cons,e.x=this.x0+o*Math.sin(a-this.long0),e.y=this.y0-this.con*o*Math.cos(a-this.long0),e):(Math.abs(this.sinlat0)<qt?(t=2*this.a*this.k0/(1+i*Math.cos(c)),e.y=t*r):(t=2*this.a*this.k0*this.ms1/(this.cosX0*(1+this.sinX0*r+this.cosX0*i*Math.cos(c))),e.y=t*(this.cosX0*r-this.sinX0*i*Math.cos(c))+this.y0),e.x=t*i*Math.sin(c)+this.x0,e))}function _e(e){e.x-=this.x0,e.y-=this.y0;var t,n,r,i,s,o=Math.sqrt(e.x*e.x+e.y*e.y);if(this.sphere){var a=2*Math.atan(o/(2*this.a*this.k0));return t=this.long0,(n=this.lat0,o<=qt)?(e.x=t,e.y=n,e):(n=Math.asin(Math.cos(a)*this.sinlat0+e.y*Math.sin(a)*this.coslat0/o),t=bn(Math.abs(this.coslat0)<qt?this.lat0>0?this.long0+Math.atan2(e.x,-1*e.y):this.long0+Math.atan2(e.x,e.y):this.long0+Math.atan2(e.x*Math.sin(a),o*this.coslat0*Math.cos(a)-e.y*this.sinlat0*Math.sin(a))),e.x=t,e.y=n,e)}if(Math.abs(this.coslat0)<=qt){if(o<=qt)return n=this.lat0,t=this.long0,e.x=t,e.y=n,e;e.x*=this.con,e.y*=this.con,r=o*this.cons/(2*this.a*this.k0),n=this.con*_n(this.e,r),t=this.con*bn(this.con*this.long0+Math.atan2(e.x,-1*e.y))}else i=2*Math.atan(o*this.cosX0/(2*this.a*this.k0*this.ms1)),t=this.long0,o<=qt?s=this.X0:(s=Math.asin(Math.cos(i)*this.sinX0+e.y*Math.sin(i)*this.cosX0/o),t=bn(this.long0+Math.atan2(e.x*Math.sin(i),o*this.cosX0*Math.cos(i)-e.y*this.sinX0*Math.sin(i)))),n=-1*_n(this.e,Math.tan(.5*(Ut+s)));return e.x=t,e.y=n,e}function Ee(){var e=this.lat0;this.lambda0=this.long0;var t=Math.sin(e),n=this.a,r=this.rf,i=1/r,s=2*i-Math.pow(i,2),o=this.e=Math.sqrt(s);this.R=this.k0*n*Math.sqrt(1-s)/(1-s*Math.pow(t,2)),this.alpha=Math.sqrt(1+s/(1-s)*Math.pow(Math.cos(e),4)),this.b0=Math.asin(t/this.alpha);var a=Math.log(Math.tan(Math.PI/4+this.b0/2)),l=Math.log(Math.tan(Math.PI/4+e/2)),h=Math.log((1+o*t)/(1-o*t));this.K=a-this.alpha*l+this.alpha*o/2*h}function ve(e){var t=Math.log(Math.tan(Math.PI/4-e.y/2)),n=this.e/2*Math.log((1+this.e*Math.sin(e.y))/(1-this.e*Math.sin(e.y))),r=-this.alpha*(t+n)+this.K,i=2*(Math.atan(Math.exp(r))-Math.PI/4),s=this.alpha*(e.x-this.lambda0),o=Math.atan(Math.sin(s)/(Math.sin(this.b0)*Math.tan(i)+Math.cos(this.b0)*Math.cos(s))),a=Math.asin(Math.cos(this.b0)*Math.sin(i)-Math.sin(this.b0)*Math.cos(i)*Math.cos(s));return e.y=this.R/2*Math.log((1+Math.sin(a))/(1-Math.sin(a)))+this.y0,e.x=this.R*o+this.x0,e}function we(e){for(var t=e.x-this.x0,n=e.y-this.y0,r=t/this.R,i=2*(Math.atan(Math.exp(n/this.R))-Math.PI/4),s=Math.asin(Math.cos(this.b0)*Math.sin(i)+Math.sin(this.b0)*Math.cos(i)*Math.cos(r)),o=Math.atan(Math.sin(r)/(Math.cos(this.b0)*Math.cos(r)-Math.sin(this.b0)*Math.tan(i))),a=this.lambda0+o/this.alpha,l=0,h=s,u=-1e3,c=0;Math.abs(h-u)>1e-7;){if(++c>20)return;l=1/this.alpha*(Math.log(Math.tan(Math.PI/4+s/2))-this.K)+this.e*Math.log(Math.tan(Math.PI/4+Math.asin(this.e*Math.sin(h))/2)),u=h,h=2*Math.atan(Math.exp(l))-Math.PI/2}return e.x=a,e.y=h,e}function Se(){this.no_off=this.no_off||!1,this.no_rot=this.no_rot||!1,isNaN(this.k0)&&(this.k0=1);var e=Math.sin(this.lat0),t=Math.cos(this.lat0),n=this.e*e;this.bl=Math.sqrt(1+this.es/(1-this.es)*Math.pow(t,4)),this.al=this.a*this.bl*this.k0*Math.sqrt(1-this.es)/(1-n*n);var r=yn(this.e,this.lat0,e),i=this.bl/t*Math.sqrt((1-this.es)/(1-n*n));i*i<1&&(i=1);var s,o;if(isNaN(this.longc)){var a=yn(this.e,this.lat1,Math.sin(this.lat1)),l=yn(this.e,this.lat2,Math.sin(this.lat2));this.lat0>=0?this.el=(i+Math.sqrt(i*i-1))*Math.pow(r,this.bl):this.el=(i-Math.sqrt(i*i-1))*Math.pow(r,this.bl);var h=Math.pow(a,this.bl),u=Math.pow(l,this.bl);s=this.el/h,o=.5*(s-1/s);var c=(this.el*this.el-u*h)/(this.el*this.el+u*h),d=(u-h)/(u+h),f=bn(this.long1-this.long2);this.long0=.5*(this.long1+this.long2)-Math.atan(c*Math.tan(.5*this.bl*f)/d)/this.bl,this.long0=bn(this.long0);var p=bn(this.long1-this.long0);this.gamma0=Math.atan(Math.sin(this.bl*p)/o),this.alpha=Math.asin(i*Math.sin(this.gamma0))}else s=this.lat0>=0?i+Math.sqrt(i*i-1):i-Math.sqrt(i*i-1),this.el=s*Math.pow(r,this.bl),o=.5*(s-1/s),this.gamma0=Math.asin(Math.sin(this.alpha)/i),this.long0=this.longc-Math.asin(o*Math.tan(this.gamma0))/this.bl;this.no_off?this.uc=0:this.lat0>=0?this.uc=this.al/this.bl*Math.atan2(Math.sqrt(i*i-1),Math.cos(this.alpha)):this.uc=-1*this.al/this.bl*Math.atan2(Math.sqrt(i*i-1),Math.cos(this.alpha))}function Te(e){var t,n,r,i=e.x,s=e.y,o=bn(i-this.long0);if(Math.abs(Math.abs(s)-Ut)<=qt)r=s>0?-1:1,n=this.al/this.bl*Math.log(Math.tan(Xt+r*this.gamma0*.5)),t=-1*r*Ut*this.al/this.bl;else{var a=yn(this.e,s,Math.sin(s)),l=this.el/Math.pow(a,this.bl),h=.5*(l-1/l),u=.5*(l+1/l),c=Math.sin(this.bl*o),d=(h*Math.sin(this.gamma0)-c*Math.cos(this.gamma0))/u;n=Math.abs(Math.abs(d)-1)<=qt?Number.POSITIVE_INFINITY:.5*this.al*Math.log((1-d)/(1+d))/this.bl,t=Math.abs(Math.cos(this.bl*o))<=qt?this.al*this.bl*o:this.al*Math.atan2(h*Math.cos(this.gamma0)+c*Math.sin(this.gamma0),Math.cos(this.bl*o))/this.bl}return this.no_rot?(e.x=this.x0+t,e.y=this.y0+n):(t-=this.uc,e.x=this.x0+n*Math.cos(this.alpha)+t*Math.sin(this.alpha),e.y=this.y0+t*Math.cos(this.alpha)-n*Math.sin(this.alpha)),e}function Le(e){var t,n;this.no_rot?(n=e.y-this.y0,t=e.x-this.x0):(n=(e.x-this.x0)*Math.cos(this.alpha)-(e.y-this.y0)*Math.sin(this.alpha),t=(e.y-this.y0)*Math.cos(this.alpha)+(e.x-this.x0)*Math.sin(this.alpha),t+=this.uc);var r=Math.exp(-1*this.bl*n/this.al),i=.5*(r-1/r),s=.5*(r+1/r),o=Math.sin(this.bl*t/this.al),a=(o*Math.cos(this.gamma0)+i*Math.sin(this.gamma0))/s,l=Math.pow(this.el/Math.sqrt((1+a)/(1-a)),1/this.bl);return Math.abs(a-1)<qt?(e.x=this.long0,e.y=Ut):Math.abs(a+1)<qt?(e.x=this.long0,e.y=-1*Ut):(e.y=_n(this.e,l),e.x=bn(this.long0-Math.atan2(i*Math.cos(this.gamma0)-o*Math.sin(this.gamma0),Math.cos(this.bl*t/this.al))/this.bl)),e}function xe(){if(this.lat2||(this.lat2=this.lat1),this.k0||(this.k0=1),this.x0=this.x0||0,this.y0=this.y0||0,!(Math.abs(this.lat1+this.lat2)<qt)){var e=this.b/this.a;this.e=Math.sqrt(1-e*e);var t=Math.sin(this.lat1),n=Math.cos(this.lat1),r=mn(this.e,t,n),i=yn(this.e,this.lat1,t),s=Math.sin(this.lat2),o=Math.cos(this.lat2),a=mn(this.e,s,o),l=yn(this.e,this.lat2,s),h=yn(this.e,this.lat0,Math.sin(this.lat0));Math.abs(this.lat1-this.lat2)>qt?this.ns=Math.log(r/a)/Math.log(i/l):this.ns=t,isNaN(this.ns)&&(this.ns=t),this.f0=r/(this.ns*Math.pow(i,this.ns)),this.rh=this.a*this.f0*Math.pow(h,this.ns),this.title||(this.title="Lambert Conformal Conic")}}function Re(e){var t=e.x,n=e.y;Math.abs(2*Math.abs(n)-Math.PI)<=qt&&(n=gn(n)*(Ut-2*qt));var r,i,s=Math.abs(Math.abs(n)-Ut);if(s>qt)r=yn(this.e,n,Math.sin(n)),i=this.a*this.f0*Math.pow(r,this.ns);else{if((s=n*this.ns)<=0)return null;i=0}var o=this.ns*bn(t-this.long0);return e.x=this.k0*(i*Math.sin(o))+this.x0,e.y=this.k0*(this.rh-i*Math.cos(o))+this.y0,e}function Ae(e){var t,n,r,i,s,o=(e.x-this.x0)/this.k0,a=this.rh-(e.y-this.y0)/this.k0;this.ns>0?(t=Math.sqrt(o*o+a*a),n=1):(t=-Math.sqrt(o*o+a*a),n=-1);var l=0;if(0!==t&&(l=Math.atan2(n*o,n*a)),0!==t||this.ns>0){if(n=1/this.ns,r=Math.pow(t/(this.a*this.f0),n),-9999===(i=_n(this.e,r)))return null}else i=-Ut;return s=bn(l/this.ns+this.long0),e.x=s,e.y=i,e}function Ce(){this.a=6377397.155,this.es=.006674372230614,this.e=Math.sqrt(this.es),this.lat0||(this.lat0=.863937979737193),this.long0||(this.long0=.4334234309119251),this.k0||(this.k0=.9999),this.s45=.785398163397448,this.s90=2*this.s45,this.fi0=this.lat0,this.e2=this.es,this.e=Math.sqrt(this.e2),this.alfa=Math.sqrt(1+this.e2*Math.pow(Math.cos(this.fi0),4)/(1-this.e2)),this.uq=1.04216856380474,this.u0=Math.asin(Math.sin(this.fi0)/this.alfa),this.g=Math.pow((1+this.e*Math.sin(this.fi0))/(1-this.e*Math.sin(this.fi0)),this.alfa*this.e/2),this.k=Math.tan(this.u0/2+this.s45)/Math.pow(Math.tan(this.fi0/2+this.s45),this.alfa)*this.g,this.k1=this.k0,this.n0=this.a*Math.sqrt(1-this.e2)/(1-this.e2*Math.pow(Math.sin(this.fi0),2)),this.s0=1.37008346281555,this.n=Math.sin(this.s0),this.ro0=this.k1*this.n0/Math.tan(this.s0),this.ad=this.s90-this.uq}function Me(e){var t,n,r,i,s,o,a,l=e.x,h=e.y,u=bn(l-this.long0)
;return t=Math.pow((1+this.e*Math.sin(h))/(1-this.e*Math.sin(h)),this.alfa*this.e/2),n=2*(Math.atan(this.k*Math.pow(Math.tan(h/2+this.s45),this.alfa)/t)-this.s45),r=-u*this.alfa,i=Math.asin(Math.cos(this.ad)*Math.sin(n)+Math.sin(this.ad)*Math.cos(n)*Math.cos(r)),s=Math.asin(Math.cos(n)*Math.sin(r)/Math.cos(i)),o=this.n*s,a=this.ro0*Math.pow(Math.tan(this.s0/2+this.s45),this.n)/Math.pow(Math.tan(i/2+this.s45),this.n),e.y=a*Math.cos(o)/1,e.x=a*Math.sin(o)/1,this.czech||(e.y*=-1,e.x*=-1),e}function ke(e){var t,n,r,i,s,o,a,l,h=e.x;e.x=e.y,e.y=h,this.czech||(e.y*=-1,e.x*=-1),o=Math.sqrt(e.x*e.x+e.y*e.y),s=Math.atan2(e.y,e.x),i=s/Math.sin(this.s0),r=2*(Math.atan(Math.pow(this.ro0/o,1/this.n)*Math.tan(this.s0/2+this.s45))-this.s45),t=Math.asin(Math.cos(this.ad)*Math.sin(r)-Math.sin(this.ad)*Math.cos(r)*Math.cos(i)),n=Math.asin(Math.cos(r)*Math.sin(i)/Math.cos(t)),e.x=this.long0-n/this.alfa,a=t,l=0;var u=0;do{e.y=2*(Math.atan(Math.pow(this.k,-1/this.alfa)*Math.pow(Math.tan(t/2+this.s45),1/this.alfa)*Math.pow((1+this.e*Math.sin(a))/(1-this.e*Math.sin(a)),this.e/2))-this.s45),Math.abs(a-e.y)<1e-10&&(l=1),a=e.y,u+=1}while(0===l&&u<15);return u>=15?null:e}function Ie(){this.sphere||(this.e0=Rr(this.es),this.e1=Ar(this.es),this.e2=Cr(this.es),this.e3=Mr(this.es),this.ml0=this.a*xr(this.e0,this.e1,this.e2,this.e3,this.lat0))}function Oe(e){var t,n,r=e.x,i=e.y;if(r=bn(r-this.long0),this.sphere)t=this.a*Math.asin(Math.cos(i)*Math.sin(r)),n=this.a*(Math.atan2(Math.tan(i),Math.cos(r))-this.lat0);else{var s=Math.sin(i),o=Math.cos(i),a=kr(this.a,this.e,s),l=Math.tan(i)*Math.tan(i),h=r*Math.cos(i),u=h*h,c=this.es*o*o/(1-this.es),d=this.a*xr(this.e0,this.e1,this.e2,this.e3,i);t=a*h*(1-u*l*(1/6-(8-l+8*c)*u/120)),n=d-this.ml0+a*s/o*u*(.5+(5-l+6*c)*u/24)}return e.x=t+this.x0,e.y=n+this.y0,e}function Pe(e){e.x-=this.x0,e.y-=this.y0;var t,n,r=e.x/this.a,i=e.y/this.a;if(this.sphere){var s=i+this.lat0;t=Math.asin(Math.sin(s)*Math.cos(r)),n=Math.atan2(Math.tan(r),Math.cos(s))}else{var o=this.ml0/this.a+i,a=Or(o,this.e0,this.e1,this.e2,this.e3);if(Math.abs(Math.abs(a)-Ut)<=qt)return e.x=this.long0,e.y=Ut,i<0&&(e.y*=-1),e;var l=kr(this.a,this.e,Math.sin(a)),h=l*l*l/this.a/this.a*(1-this.es),u=Math.pow(Math.tan(a),2),c=r*this.a/l,d=c*c;t=a-l*Math.tan(a)/h*c*c*(.5-(1+3*u)*c*c/24),n=c*(1-d*(u/3+(1+3*u)*u*d/15))/Math.cos(a)}return e.x=bn(n+this.long0),e.y=Ir(t),e}function Ne(){var e=Math.abs(this.lat0);if(Math.abs(e-Ut)<qt?this.mode=this.lat0<0?this.S_POLE:this.N_POLE:Math.abs(e)<qt?this.mode=this.EQUIT:this.mode=this.OBLIQ,this.es>0){var t;switch(this.qp=Dr(this.e,1),this.mmf=.5/(1-this.es),this.apa=Be(this.es),this.mode){case this.N_POLE:case this.S_POLE:this.dd=1;break;case this.EQUIT:this.rq=Math.sqrt(.5*this.qp),this.dd=1/this.rq,this.xmf=1,this.ymf=.5*this.qp;break;case this.OBLIQ:this.rq=Math.sqrt(.5*this.qp),t=Math.sin(this.lat0),this.sinb1=Dr(this.e,t)/this.qp,this.cosb1=Math.sqrt(1-this.sinb1*this.sinb1),this.dd=Math.cos(this.lat0)/(Math.sqrt(1-this.es*t*t)*this.rq*this.cosb1),this.ymf=(this.xmf=this.rq)/this.dd,this.xmf*=this.dd}}else this.mode===this.OBLIQ&&(this.sinph0=Math.sin(this.lat0),this.cosph0=Math.cos(this.lat0))}function De(e){var t,n,r,i,s,o,a,l,h,u,c=e.x,d=e.y;if(c=bn(c-this.long0),this.sphere){if(s=Math.sin(d),u=Math.cos(d),r=Math.cos(c),this.mode===this.OBLIQ||this.mode===this.EQUIT){if((n=this.mode===this.EQUIT?1+u*r:1+this.sinph0*s+this.cosph0*u*r)<=qt)return null;n=Math.sqrt(2/n),t=n*u*Math.sin(c),n*=this.mode===this.EQUIT?s:this.cosph0*s-this.sinph0*u*r}else if(this.mode===this.N_POLE||this.mode===this.S_POLE){if(this.mode===this.N_POLE&&(r=-r),Math.abs(d+this.phi0)<qt)return null;n=Xt-.5*d,n=2*(this.mode===this.S_POLE?Math.cos(n):Math.sin(n)),t=n*Math.sin(c),n*=r}}else{switch(a=0,l=0,h=0,r=Math.cos(c),i=Math.sin(c),s=Math.sin(d),o=Dr(this.e,s),this.mode!==this.OBLIQ&&this.mode!==this.EQUIT||(a=o/this.qp,l=Math.sqrt(1-a*a)),this.mode){case this.OBLIQ:h=1+this.sinb1*a+this.cosb1*l*r;break;case this.EQUIT:h=1+l*r;break;case this.N_POLE:h=Ut+d,o=this.qp-o;break;case this.S_POLE:h=d-Ut,o=this.qp+o}if(Math.abs(h)<qt)return null;switch(this.mode){case this.OBLIQ:case this.EQUIT:h=Math.sqrt(2/h),n=this.mode===this.OBLIQ?this.ymf*h*(this.cosb1*a-this.sinb1*l*r):(h=Math.sqrt(2/(1+l*r)))*a*this.ymf,t=this.xmf*h*l*i;break;case this.N_POLE:case this.S_POLE:o>=0?(t=(h=Math.sqrt(o))*i,n=r*(this.mode===this.S_POLE?h:-h)):t=n=0}}return e.x=this.a*t+this.x0,e.y=this.a*n+this.y0,e}function Fe(e){e.x-=this.x0,e.y-=this.y0;var t,n,r,i,s,o,a,l=e.x/this.a,h=e.y/this.a;if(this.sphere){var u,c=0,d=0;if(u=Math.sqrt(l*l+h*h),(n=.5*u)>1)return null;switch(n=2*Math.asin(n),this.mode!==this.OBLIQ&&this.mode!==this.EQUIT||(d=Math.sin(n),c=Math.cos(n)),this.mode){case this.EQUIT:n=Math.abs(u)<=qt?0:Math.asin(h*d/u),l*=d,h=c*u;break;case this.OBLIQ:n=Math.abs(u)<=qt?this.phi0:Math.asin(c*this.sinph0+h*d*this.cosph0/u),l*=d*this.cosph0,h=(c-Math.sin(n)*this.sinph0)*u;break;case this.N_POLE:h=-h,n=Ut-n;break;case this.S_POLE:n-=Ut}t=0!==h||this.mode!==this.EQUIT&&this.mode!==this.OBLIQ?Math.atan2(l,h):0}else{if(a=0,this.mode===this.OBLIQ||this.mode===this.EQUIT){if(l/=this.dd,h*=this.dd,(o=Math.sqrt(l*l+h*h))<qt)return e.x=0,e.y=this.phi0,e;i=2*Math.asin(.5*o/this.rq),r=Math.cos(i),l*=i=Math.sin(i),this.mode===this.OBLIQ?(a=r*this.sinb1+h*i*this.cosb1/o,s=this.qp*a,h=o*this.cosb1*r-h*this.sinb1*i):(a=h*i/o,s=this.qp*a,h=o*r)}else if(this.mode===this.N_POLE||this.mode===this.S_POLE){if(this.mode===this.N_POLE&&(h=-h),!(s=l*l+h*h))return e.x=0,e.y=this.phi0,e;a=1-s/this.qp,this.mode===this.S_POLE&&(a=-a)}t=Math.atan2(l,h),n=We(Math.asin(a),this.apa)}return e.x=bn(this.long0+t),e.y=n,e}function Be(e){var t,n=[];return n[0]=e*Fr,t=e*e,n[0]+=t*Br,n[1]=t*Vr,t*=e,n[0]+=t*Wr,n[1]+=t*Gr,n[2]=t*jr,n}function We(e,t){var n=e+e;return e+t[0]*Math.sin(n)+t[1]*Math.sin(n+n)+t[2]*Math.sin(n+n+n)}function Ve(){Math.abs(this.lat1+this.lat2)<qt||(this.temp=this.b/this.a,this.es=1-Math.pow(this.temp,2),this.e3=Math.sqrt(this.es),this.sin_po=Math.sin(this.lat1),this.cos_po=Math.cos(this.lat1),this.t1=this.sin_po,this.con=this.sin_po,this.ms1=mn(this.e3,this.sin_po,this.cos_po),this.qs1=Dr(this.e3,this.sin_po,this.cos_po),this.sin_po=Math.sin(this.lat2),this.cos_po=Math.cos(this.lat2),this.t2=this.sin_po,this.ms2=mn(this.e3,this.sin_po,this.cos_po),this.qs2=Dr(this.e3,this.sin_po,this.cos_po),this.sin_po=Math.sin(this.lat0),this.cos_po=Math.cos(this.lat0),this.t3=this.sin_po,this.qs0=Dr(this.e3,this.sin_po,this.cos_po),Math.abs(this.lat1-this.lat2)>qt?this.ns0=(this.ms1*this.ms1-this.ms2*this.ms2)/(this.qs2-this.qs1):this.ns0=this.con,this.c=this.ms1*this.ms1+this.ns0*this.qs1,this.rh=this.a*Math.sqrt(this.c-this.ns0*this.qs0)/this.ns0)}function Ge(e){var t=e.x,n=e.y;this.sin_phi=Math.sin(n),this.cos_phi=Math.cos(n);var r=Dr(this.e3,this.sin_phi,this.cos_phi),i=this.a*Math.sqrt(this.c-this.ns0*r)/this.ns0,s=this.ns0*bn(t-this.long0),o=i*Math.sin(s)+this.x0,a=this.rh-i*Math.cos(s)+this.y0;return e.x=o,e.y=a,e}function je(e){var t,n,r,i,s,o;return e.x-=this.x0,e.y=this.rh-e.y+this.y0,this.ns0>=0?(t=Math.sqrt(e.x*e.x+e.y*e.y),r=1):(t=-Math.sqrt(e.x*e.x+e.y*e.y),r=-1),i=0,0!==t&&(i=Math.atan2(r*e.x,r*e.y)),r=t*this.ns0/this.a,this.sphere?o=Math.asin((this.c-r*r)/(2*this.ns0)):(n=(this.c-r*r)/this.ns0,o=this.phi1z(this.e3,n)),s=bn(i/this.ns0+this.long0),e.x=s,e.y=o,e}function Ue(e,t){var n,r,i,s,o,a=Kr(.5*t);if(e<qt)return a;for(var l=e*e,h=1;h<=25;h++)if(n=Math.sin(a),r=Math.cos(a),i=e*n,s=1-i*i,o=.5*s*s/r*(t/(1-l)-n/s+.5/e*Math.log((1-i)/(1+i))),a+=o,Math.abs(o)<=1e-7)return a;return null}function ze(){this.sin_p14=Math.sin(this.lat0),this.cos_p14=Math.cos(this.lat0),this.infinity_dist=1e3*this.a,this.rc=1}function Ke(e){var t,n,r,i,s,o,a,l,h=e.x,u=e.y;return r=bn(h-this.long0),t=Math.sin(u),n=Math.cos(u),i=Math.cos(r),o=this.sin_p14*t+this.cos_p14*n*i,s=1,o>0||Math.abs(o)<=qt?(a=this.x0+this.a*s*n*Math.sin(r)/o,l=this.y0+this.a*s*(this.cos_p14*t-this.sin_p14*n*i)/o):(a=this.x0+this.infinity_dist*n*Math.sin(r),l=this.y0+this.infinity_dist*(this.cos_p14*t-this.sin_p14*n*i)),e.x=a,e.y=l,e}function He(e){var t,n,r,i,s,o;return e.x=(e.x-this.x0)/this.a,e.y=(e.y-this.y0)/this.a,e.x/=this.k0,e.y/=this.k0,(t=Math.sqrt(e.x*e.x+e.y*e.y))?(i=Math.atan2(t,this.rc),n=Math.sin(i),r=Math.cos(i),o=Kr(r*this.sin_p14+e.y*n*this.cos_p14/t),s=Math.atan2(e.x*n,t*this.cos_p14*r-e.y*this.sin_p14*n),s=bn(this.long0+s)):(o=this.phic0,s=0),e.x=s,e.y=o,e}function qe(){this.sphere||(this.k0=mn(this.e,Math.sin(this.lat_ts),Math.cos(this.lat_ts)))}function Ye(e){var t,n,r=e.x,i=e.y,s=bn(r-this.long0);if(this.sphere)t=this.x0+this.a*s*Math.cos(this.lat_ts),n=this.y0+this.a*Math.sin(i)/Math.cos(this.lat_ts);else{var o=Dr(this.e,Math.sin(i));t=this.x0+this.a*this.k0*s,n=this.y0+this.a*o*.5/this.k0}return e.x=t,e.y=n,e}function Ze(e){e.x-=this.x0,e.y-=this.y0;var t,n;return this.sphere?(t=bn(this.long0+e.x/this.a/Math.cos(this.lat_ts)),n=Math.asin(e.y/this.a*Math.cos(this.lat_ts))):(n=Xr(this.e,2*e.y*this.k0/this.a),t=bn(this.long0+e.x/(this.a*this.k0))),e.x=t,e.y=n,e}function Xe(){this.x0=this.x0||0,this.y0=this.y0||0,this.lat0=this.lat0||0,this.long0=this.long0||0,this.lat_ts=this.lat_ts||0,this.title=this.title||"Equidistant Cylindrical (Plate Carre)",this.rc=Math.cos(this.lat_ts)}function Je(e){var t=e.x,n=e.y,r=bn(t-this.long0),i=Ir(n-this.lat0);return e.x=this.x0+this.a*r*this.rc,e.y=this.y0+this.a*i,e}function Qe(e){var t=e.x,n=e.y;return e.x=bn(this.long0+(t-this.x0)/(this.a*this.rc)),e.y=Ir(this.lat0+(n-this.y0)/this.a),e}function $e(){this.temp=this.b/this.a,this.es=1-Math.pow(this.temp,2),this.e=Math.sqrt(this.es),this.e0=Rr(this.es),this.e1=Ar(this.es),this.e2=Cr(this.es),this.e3=Mr(this.es),this.ml0=this.a*xr(this.e0,this.e1,this.e2,this.e3,this.lat0)}function et(e){var t,n,r,i=e.x,s=e.y,o=bn(i-this.long0);if(r=o*Math.sin(s),this.sphere)Math.abs(s)<=qt?(t=this.a*o,n=-1*this.a*this.lat0):(t=this.a*Math.sin(r)/Math.tan(s),n=this.a*(Ir(s-this.lat0)+(1-Math.cos(r))/Math.tan(s)));else if(Math.abs(s)<=qt)t=this.a*o,n=-1*this.ml0;else{var a=kr(this.a,this.e,Math.sin(s))/Math.tan(s);t=a*Math.sin(r),n=this.a*xr(this.e0,this.e1,this.e2,this.e3,s)-this.ml0+a*(1-Math.cos(r))}return e.x=t+this.x0,e.y=n+this.y0,e}function tt(e){var t,n,r,i,s,o,a,l,h;if(r=e.x-this.x0,i=e.y-this.y0,this.sphere)if(Math.abs(i+this.a*this.lat0)<=qt)t=bn(r/this.a+this.long0),n=0;else{o=this.lat0+i/this.a,a=r*r/this.a/this.a+o*o,l=o;var u;for(s=ti;s;--s)if(u=Math.tan(l),h=-1*(o*(l*u+1)-l-.5*(l*l+a)*u)/((l-o)/u-1),l+=h,Math.abs(h)<=qt){n=l;break}t=bn(this.long0+Math.asin(r*Math.tan(l)/this.a)/Math.sin(n))}else if(Math.abs(i+this.ml0)<=qt)n=0,t=bn(this.long0+r/this.a);else{o=(this.ml0+i)/this.a,a=r*r/this.a/this.a+o*o,l=o;var c,d,f,p,m;for(s=ti;s;--s)if(m=this.e*Math.sin(l),c=Math.sqrt(1-m*m)*Math.tan(l),d=this.a*xr(this.e0,this.e1,this.e2,this.e3,l),f=this.e0-2*this.e1*Math.cos(2*l)+4*this.e2*Math.cos(4*l)-6*this.e3*Math.cos(6*l),p=d/this.a,h=(o*(c*p+1)-p-.5*c*(p*p+a))/(this.es*Math.sin(2*l)*(p*p+a-2*o*p)/(4*c)+(o-p)*(c*f-2/Math.sin(2*l))-f),l-=h,Math.abs(h)<=qt){n=l;break}c=Math.sqrt(1-this.es*Math.pow(Math.sin(n),2))*Math.tan(n),t=bn(this.long0+Math.asin(r*c/this.a)/Math.sin(n))}return e.x=t,e.y=n,e}function nt(){this.A=[],this.A[1]=.6399175073,this.A[2]=-.1358797613,this.A[3]=.063294409,this.A[4]=-.02526853,this.A[5]=.0117879,this.A[6]=-.0055161,this.A[7]=.0026906,this.A[8]=-.001333,this.A[9]=67e-5,this.A[10]=-34e-5,this.B_re=[],this.B_im=[],this.B_re[1]=.7557853228,this.B_im[1]=0,this.B_re[2]=.249204646,this.B_im[2]=.003371507,this.B_re[3]=-.001541739,this.B_im[3]=.04105856,this.B_re[4]=-.10162907,this.B_im[4]=.01727609,this.B_re[5]=-.26623489,this.B_im[5]=-.36249218,this.B_re[6]=-.6870983,this.B_im[6]=-1.1651967,this.C_re=[],this.C_im=[],this.C_re[1]=1.3231270439,this.C_im[1]=0,this.C_re[2]=-.577245789,this.C_im[2]=-.007809598,this.C_re[3]=.508307513,this.C_im[3]=-.112208952,this.C_re[4]=-.15094762,this.C_im[4]=.18200602,this.C_re[5]=1.01418179,this.C_im[5]=1.64497696,this.C_re[6]=1.9660549,this.C_im[6]=2.5127645,this.D=[],this.D[1]=1.5627014243,this.D[2]=.5185406398,this.D[3]=-.03333098,this.D[4]=-.1052906,this.D[5]=-.0368594,this.D[6]=.007317,this.D[7]=.0122,this.D[8]=.00394,this.D[9]=-.0013}function rt(e){var t,n=e.x,r=e.y,i=r-this.lat0,s=n-this.long0,o=i/jt*1e-5,a=s,l=1,h=0;for(t=1;t<=10;t++)l*=o,h+=this.A[t]*l;var u,c,d=h,f=a,p=1,m=0,g=0,b=0;for(t=1;t<=6;t++)u=p*d-m*f,c=m*d+p*f,p=u,m=c,g=g+this.B_re[t]*p-this.B_im[t]*m,b=b+this.B_im[t]*p+this.B_re[t]*m;return e.x=b*this.a+this.x0,e.y=g*this.a+this.y0,e}function it(e){var t,n,r,i=e.x,s=e.y,o=i-this.x0,a=s-this.y0,l=a/this.a,h=o/this.a,u=1,c=0,d=0,f=0;for(t=1;t<=6;t++)n=u*l-c*h,r=c*l+u*h,u=n,c=r,d=d+this.C_re[t]*u-this.C_im[t]*c,f=f+this.C_im[t]*u+this.C_re[t]*c;for(var p=0;p<this.iterations;p++){var m,g,b=d,y=f,_=l,E=h;for(t=2;t<=6;t++)m=b*d-y*f,g=y*d+b*f,b=m,y=g,_+=(t-1)*(this.B_re[t]*b-this.B_im[t]*y),E+=(t-1)*(this.B_im[t]*b+this.B_re[t]*y);b=1,y=0;var v=this.B_re[1],w=this.B_im[1];for(t=2;t<=6;t++)m=b*d-y*f,g=y*d+b*f,b=m,y=g,v+=t*(this.B_re[t]*b-this.B_im[t]*y),w+=t*(this.B_im[t]*b+this.B_re[t]*y);var S=v*v+w*w;d=(_*v+E*w)/S,f=(E*v-_*w)/S}var T=d,L=f,x=1,R=0;for(t=1;t<=9;t++)x*=T,R+=this.D[t]*x;var A=this.lat0+R*jt*1e5,C=this.long0+L;return e.x=C,e.y=A,e}function st(){}function ot(e){var t=e.x,n=e.y,r=bn(t-this.long0),i=this.x0+this.a*r,s=this.y0+this.a*Math.log(Math.tan(Math.PI/4+n/2.5))*1.25;return e.x=i,e.y=s,e}function at(e){e.x-=this.x0,e.y-=this.y0;var t=bn(this.long0+e.x/this.a),n=2.5*(Math.atan(Math.exp(.8*e.y/this.a))-Math.PI/4);return e.x=t,e.y=n,e}function lt(){this.sphere?(this.n=1,this.m=0,this.es=0,this.C_y=Math.sqrt((this.m+1)/this.n),this.C_x=this.C_y/(this.m+1)):this.en=Hn(this.es)}function ht(e){var t,n,r=e.x,i=e.y;if(r=bn(r-this.long0),this.sphere){if(this.m)for(var s=this.n*Math.sin(i),o=li;o;--o){var a=(this.m*i+Math.sin(i)-s)/(this.m+Math.cos(i));if(i-=a,Math.abs(a)<qt)break}else i=1!==this.n?Math.asin(this.n*Math.sin(i)):i;t=this.a*this.C_x*r*(this.m+Math.cos(i)),n=this.a*this.C_y*i}else{var l=Math.sin(i),h=Math.cos(i);n=this.a*qn(i,l,h,this.en),t=this.a*r*h/Math.sqrt(1-this.es*l*l)}return e.x=t,e.y=n,e}function ut(e){var t,n,r,i;return e.x-=this.x0,r=e.x/this.a,e.y-=this.y0,t=e.y/this.a,this.sphere?(t/=this.C_y,r/=this.C_x*(this.m+Math.cos(t)),this.m?t=Kr((this.m*t+Math.sin(t))/this.n):1!==this.n&&(t=Kr(Math.sin(t)/this.n)),r=bn(r+this.long0),t=Ir(t)):(t=Yn(e.y/this.a,this.es,this.en),i=Math.abs(t),i<Ut?(i=Math.sin(t),n=this.long0+e.x*Math.sqrt(1-this.es*i*i)/(this.a*Math.cos(t)),r=bn(n)):i-qt<Ut&&(r=this.long0)),e.x=r,e.y=t,e}function ct(){}function dt(e){for(var t=e.x,n=e.y,r=bn(t-this.long0),i=n,s=Math.PI*Math.sin(n);;){var o=-(i+Math.sin(i)-s)/(1+Math.cos(i));if(i+=o,Math.abs(o)<qt)break}i/=2,Math.PI/2-Math.abs(n)<qt&&(r=0);var a=.900316316158*this.a*r*Math.cos(i)+this.x0,l=1.4142135623731*this.a*Math.sin(i)+this.y0;return e.x=a,e.y=l,e}function ft(e){var t,n;e.x-=this.x0,e.y-=this.y0,n=e.y/(1.4142135623731*this.a),Math.abs(n)>.999999999999&&(n=.999999999999),t=Math.asin(n);var r=bn(this.long0+e.x/(.900316316158*this.a*Math.cos(t)));r<-Math.PI&&(r=-Math.PI),r>Math.PI&&(r=Math.PI),n=(2*t+Math.sin(2*t))/Math.PI,Math.abs(n)>1&&(n=1);var i=Math.asin(n);return e.x=r,e.y=i,e}function pt(){Math.abs(this.lat1+this.lat2)<qt||(this.lat2=this.lat2||this.lat1,this.temp=this.b/this.a,this.es=1-Math.pow(this.temp,2),this.e=Math.sqrt(this.es),this.e0=Rr(this.es),this.e1=Ar(this.es),this.e2=Cr(this.es),this.e3=Mr(this.es),this.sinphi=Math.sin(this.lat1),this.cosphi=Math.cos(this.lat1),this.ms1=mn(this.e,this.sinphi,this.cosphi),this.ml1=xr(this.e0,this.e1,this.e2,this.e3,this.lat1),Math.abs(this.lat1-this.lat2)<qt?this.ns=this.sinphi:(this.sinphi=Math.sin(this.lat2),this.cosphi=Math.cos(this.lat2),this.ms2=mn(this.e,this.sinphi,this.cosphi),this.ml2=xr(this.e0,this.e1,this.e2,this.e3,this.lat2),this.ns=(this.ms1-this.ms2)/(this.ml2-this.ml1)),this.g=this.ml1+this.ms1/this.ns,this.ml0=xr(this.e0,this.e1,this.e2,this.e3,this.lat0),this.rh=this.a*(this.g-this.ml0))}function mt(e){var t,n=e.x,r=e.y;if(this.sphere)t=this.a*(this.g-r);else{var i=xr(this.e0,this.e1,this.e2,this.e3,r);t=this.a*(this.g-i)}var s=this.ns*bn(n-this.long0),o=this.x0+t*Math.sin(s),a=this.y0+this.rh-t*Math.cos(s);return e.x=o,e.y=a,e}function gt(e){e.x-=this.x0,e.y=this.rh-e.y+this.y0;var t,n,r,i;this.ns>=0?(n=Math.sqrt(e.x*e.x+e.y*e.y),t=1):(n=-Math.sqrt(e.x*e.x+e.y*e.y),t=-1);var s=0;if(0!==n&&(s=Math.atan2(t*e.x,t*e.y)),this.sphere)return i=bn(this.long0+s/this.ns),r=Ir(this.g-n/this.a),e.x=i,e.y=r,e;var o=this.g-n/this.a;return r=Or(o,this.e0,this.e1,this.e2,this.e3),i=bn(this.long0+s/this.ns),e.x=i,e.y=r,e}function bt(){this.R=this.a}function yt(e){var t,n,r=e.x,i=e.y,s=bn(r-this.long0);Math.abs(i)<=qt&&(t=this.x0+this.R*s,n=this.y0);var o=Kr(2*Math.abs(i/Math.PI));(Math.abs(s)<=qt||Math.abs(Math.abs(i)-Ut)<=qt)&&(t=this.x0,n=i>=0?this.y0+Math.PI*this.R*Math.tan(.5*o):this.y0+Math.PI*this.R*-Math.tan(.5*o));var a=.5*Math.abs(Math.PI/s-s/Math.PI),l=a*a,h=Math.sin(o),u=Math.cos(o),c=u/(h+u-1),d=c*c,f=c*(2/h-1),p=f*f,m=Math.PI*this.R*(a*(c-p)+Math.sqrt(l*(c-p)*(c-p)-(p+l)*(d-p)))/(p+l);s<0&&(m=-m),t=this.x0+m;var g=l+c;return m=Math.PI*this.R*(f*g-a*Math.sqrt((p+l)*(l+1)-g*g))/(p+l),n=i>=0?this.y0+m:this.y0-m,e.x=t,e.y=n,e}function _t(e){var t,n,r,i,s,o,a,l,h,u,c,d,f;return e.x-=this.x0,e.y-=this.y0,c=Math.PI*this.R,r=e.x/c,i=e.y/c,s=r*r+i*i,o=-Math.abs(i)*(1+s),a=o-2*i*i+r*r,l=-2*o+1+2*i*i+s*s,f=i*i/l+(2*a*a*a/l/l/l-9*o*a/l/l)/27,h=(o-a*a/3/l)/l,u=2*Math.sqrt(-h/3),c=3*f/h/u,Math.abs(c)>1&&(c=c>=0?1:-1),d=Math.acos(c)/3,n=e.y>=0?(-u*Math.cos(d+Math.PI/3)-a/3/l)*Math.PI:-(-u*Math.cos(d+Math.PI/3)-a/3/l)*Math.PI,t=Math.abs(r)<qt?this.long0:bn(this.long0+Math.PI*(s-1+Math.sqrt(1+2*(r*r-i*i)+s*s))/2/r),e.x=t,e.y=n,e}function Et(){this.sin_p12=Math.sin(this.lat0),this.cos_p12=Math.cos(this.lat0)}function vt(e){var t,n,r,i,s,o,a,l,h,u,c,d,f,p,m,g,b,y,_,E,v,w,S,T=e.x,L=e.y,x=Math.sin(e.y),R=Math.cos(e.y),A=bn(T-this.long0);return this.sphere?Math.abs(this.sin_p12-1)<=qt?(e.x=this.x0+this.a*(Ut-L)*Math.sin(A),e.y=this.y0-this.a*(Ut-L)*Math.cos(A),e):Math.abs(this.sin_p12+1)<=qt?(e.x=this.x0+this.a*(Ut+L)*Math.sin(A),e.y=this.y0+this.a*(Ut+L)*Math.cos(A),e):(y=this.sin_p12*x+this.cos_p12*R*Math.cos(A),g=Math.acos(y),b=g/Math.sin(g),e.x=this.x0+this.a*b*R*Math.sin(A),e.y=this.y0+this.a*b*(this.cos_p12*x-this.sin_p12*R*Math.cos(A)),e):(t=Rr(this.es),n=Ar(this.es),r=Cr(this.es),i=Mr(this.es),Math.abs(this.sin_p12-1)<=qt?(s=this.a*xr(t,n,r,i,Ut),o=this.a*xr(t,n,r,i,L),e.x=this.x0+(s-o)*Math.sin(A),e.y=this.y0-(s-o)*Math.cos(A),e):Math.abs(this.sin_p12+1)<=qt?(s=this.a*xr(t,n,r,i,Ut),o=this.a*xr(t,n,r,i,L),e.x=this.x0+(s+o)*Math.sin(A),e.y=this.y0+(s+o)*Math.cos(A),e):(a=x/R,l=kr(this.a,this.e,this.sin_p12),h=kr(this.a,this.e,x),u=Math.atan((1-this.es)*a+this.es*l*this.sin_p12/(h*R)),c=Math.atan2(Math.sin(A),this.cos_p12*Math.tan(u)-this.sin_p12*Math.cos(A)),_=0===c?Math.asin(this.cos_p12*Math.sin(u)-this.sin_p12*Math.cos(u)):Math.abs(Math.abs(c)-Math.PI)<=qt?-Math.asin(this.cos_p12*Math.sin(u)-this.sin_p12*Math.cos(u)):Math.asin(Math.sin(A)*Math.cos(u)/Math.sin(c)),d=this.e*this.sin_p12/Math.sqrt(1-this.es),f=this.e*this.cos_p12*Math.cos(c)/Math.sqrt(1-this.es),p=d*f,m=f*f,E=_*_,v=E*_,w=v*_,S=w*_,g=l*_*(1-E*m*(1-m)/6+v/8*p*(1-2*m)+w/120*(m*(4-7*m)-3*d*d*(1-7*m))-S/48*p),e.x=this.x0+g*Math.sin(c),e.y=this.y0+g*Math.cos(c),e))}function wt(e){e.x-=this.x0,e.y-=this.y0;var t,n,r,i,s,o,a,l,h,u,c,d,f,p,m,g,b,y,_,E,v,w,S;if(this.sphere){if((t=Math.sqrt(e.x*e.x+e.y*e.y))>2*Ut*this.a)return;return n=t/this.a,r=Math.sin(n),i=Math.cos(n),s=this.long0,Math.abs(t)<=qt?o=this.lat0:(o=Kr(i*this.sin_p12+e.y*r*this.cos_p12/t),a=Math.abs(this.lat0)-Ut,s=bn(Math.abs(a)<=qt?this.lat0>=0?this.long0+Math.atan2(e.x,-e.y):this.long0-Math.atan2(-e.x,e.y):this.long0+Math.atan2(e.x*r,t*this.cos_p12*i-e.y*this.sin_p12*r))),e.x=s,e.y=o,e}return l=Rr(this.es),h=Ar(this.es),u=Cr(this.es),c=Mr(this.es),Math.abs(this.sin_p12-1)<=qt?(d=this.a*xr(l,h,u,c,Ut),t=Math.sqrt(e.x*e.x+e.y*e.y),f=d-t,o=Or(f/this.a,l,h,u,c),s=bn(this.long0+Math.atan2(e.x,-1*e.y)),e.x=s,e.y=o,e):Math.abs(this.sin_p12+1)<=qt?(d=this.a*xr(l,h,u,c,Ut),t=Math.sqrt(e.x*e.x+e.y*e.y),f=t-d,o=Or(f/this.a,l,h,u,c),s=bn(this.long0+Math.atan2(e.x,e.y)),e.x=s,e.y=o,e):(t=Math.sqrt(e.x*e.x+e.y*e.y),g=Math.atan2(e.x,e.y),p=kr(this.a,this.e,this.sin_p12),b=Math.cos(g),y=this.e*this.cos_p12*b,_=-y*y/(1-this.es),E=3*this.es*(1-_)*this.sin_p12*this.cos_p12*b/(1-this.es),v=t/p,w=v-_*(1+_)*Math.pow(v,3)/6-E*(1+3*_)*Math.pow(v,4)/24,S=1-_*w*w/2-v*w*w*w/6,m=Math.asin(this.sin_p12*Math.cos(w)+this.cos_p12*Math.sin(w)*b),s=bn(this.long0+Math.asin(Math.sin(g)*Math.sin(w)/Math.cos(m))),o=Math.atan((1-this.es*S*this.sin_p12/Math.sin(m))*Math.tan(m)/(1-this.es)),e.x=s,e.y=o,e)}function St(){this.sin_p14=Math.sin(this.lat0),this.cos_p14=Math.cos(this.lat0)}function Tt(e){var t,n,r,i,s,o,a,l,h=e.x,u=e.y;return r=bn(h-this.long0),t=Math.sin(u),n=Math.cos(u),i=Math.cos(r),o=this.sin_p14*t+this.cos_p14*n*i,s=1,(o>0||Math.abs(o)<=qt)&&(a=this.a*s*n*Math.sin(r),l=this.y0+this.a*s*(this.cos_p14*t-this.sin_p14*n*i)),e.x=a,e.y=l,e}function Lt(e){var t,n,r,i,s,o,a;return e.x-=this.x0,e.y-=this.y0,t=Math.sqrt(e.x*e.x+e.y*e.y),n=Kr(t/this.a),r=Math.sin(n),i=Math.cos(n),o=this.long0,Math.abs(t)<=qt?(a=this.lat0,e.x=o,e.y=a,e):(a=Kr(i*this.sin_p14+e.y*r*this.cos_p14/t),s=Math.abs(this.lat0)-Ut,Math.abs(s)<=qt?(o=bn(this.lat0>=0?this.long0+Math.atan2(e.x,-e.y):this.long0-Math.atan2(-e.x,e.y)),e.x=o,e.y=a,e):(o=bn(this.long0+Math.atan2(e.x*r,t*this.cos_p14*i-e.y*this.sin_p14*r)),e.x=o,e.y=a,e))}function xt(){this.x0=this.x0||0,this.y0=this.y0||0,this.lat0=this.lat0||0,this.long0=this.long0||0,this.lat_ts=this.lat_ts||0,this.title=this.title||"Quadrilateralized Spherical Cube",this.lat0>=Ut-Xt/2?this.face=vi.TOP:this.lat0<=-(Ut-Xt/2)?this.face=vi.BOTTOM:Math.abs(this.long0)<=Xt?this.face=vi.FRONT:Math.abs(this.long0)<=Ut+Xt?this.face=this.long0>0?vi.RIGHT:vi.LEFT:this.face=vi.BACK,0!==this.es&&(this.one_minus_f=1-(this.a-this.b)/this.a,this.one_minus_f_squared=this.one_minus_f*this.one_minus_f)}function Rt(e){var t,n,r,i,s,o,a={x:0,y:0},l={value:0};if(e.x-=this.long0,t=0!==this.es?Math.atan(this.one_minus_f_squared*Math.tan(e.y)):e.y,n=e.x,this.face===vi.TOP)i=Ut-t,n>=Xt&&n<=Ut+Xt?(l.value=wi.AREA_0,r=n-Ut):n>Ut+Xt||n<=-(Ut+Xt)?(l.value=wi.AREA_1,r=n>0?n-Qt:n+Qt):n>-(Ut+Xt)&&n<=-Xt?(l.value=wi.AREA_2,r=n+Ut):(l.value=wi.AREA_3,r=n);else if(this.face===vi.BOTTOM)i=Ut+t,n>=Xt&&n<=Ut+Xt?(l.value=wi.AREA_0,r=-n+Ut):n<Xt&&n>=-Xt?(l.value=wi.AREA_1,r=-n):n<-Xt&&n>=-(Ut+Xt)?(l.value=wi.AREA_2,r=-n-Ut):(l.value=wi.AREA_3,r=n>0?-n+Qt:-n-Qt);else{var h,u,c,d,f,p,m;this.face===vi.RIGHT?n=Mt(n,+Ut):this.face===vi.BACK?n=Mt(n,+Qt):this.face===vi.LEFT&&(n=Mt(n,-Ut)),d=Math.sin(t),f=Math.cos(t),p=Math.sin(n),m=Math.cos(n),h=f*m,u=f*p,c=d,this.face===vi.FRONT?(i=Math.acos(h),r=Ct(i,c,u,l)):this.face===vi.RIGHT?(i=Math.acos(u),r=Ct(i,c,-h,l)):this.face===vi.BACK?(i=Math.acos(-h),r=Ct(i,c,-u,l)):this.face===vi.LEFT?(i=Math.acos(-u),r=Ct(i,c,h,l)):(i=r=0,l.value=wi.AREA_0)}return o=Math.atan(12/Qt*(r+Math.acos(Math.sin(r)*Math.cos(Xt))-Ut)),s=Math.sqrt((1-Math.cos(i))/(Math.cos(o)*Math.cos(o))/(1-Math.cos(Math.atan(1/Math.cos(r))))),l.value===wi.AREA_1?o+=Ut:l.value===wi.AREA_2?o+=Qt:l.value===wi.AREA_3&&(o+=1.5*Qt),a.x=s*Math.cos(o),a.y=s*Math.sin(o),a.x=a.x*this.a+this.x0,a.y=a.y*this.a+this.y0,e.x=a.x,e.y=a.y,e}function At(e){var t,n,r,i,s,o,a,l,h,u={lam:0,phi:0},c={value:0};if(e.x=(e.x-this.x0)/this.a,e.y=(e.y-this.y0)/this.a,n=Math.atan(Math.sqrt(e.x*e.x+e.y*e.y)),t=Math.atan2(e.y,e.x),e.x>=0&&e.x>=Math.abs(e.y)?c.value=wi.AREA_0:e.y>=0&&e.y>=Math.abs(e.x)?(c.value=wi.AREA_1,t-=Ut):e.x<0&&-e.x>=Math.abs(e.y)?(c.value=wi.AREA_2,t=t<0?t+Qt:t-Qt):(c.value=wi.AREA_3,t+=Ut),h=Qt/12*Math.tan(t),s=Math.sin(h)/(Math.cos(h)-1/Math.sqrt(2)),o=Math.atan(s),r=Math.cos(t),i=Math.tan(n),a=1-r*r*i*i*(1-Math.cos(Math.atan(1/Math.cos(o)))),a<-1?a=-1:a>1&&(a=1),this.face===vi.TOP)l=Math.acos(a),u.phi=Ut-l,c.value===wi.AREA_0?u.lam=o+Ut:c.value===wi.AREA_1?u.lam=o<0?o+Qt:o-Qt:c.value===wi.AREA_2?u.lam=o-Ut:u.lam=o;else if(this.face===vi.BOTTOM)l=Math.acos(a),u.phi=l-Ut,c.value===wi.AREA_0?u.lam=-o+Ut:c.value===wi.AREA_1?u.lam=-o:c.value===wi.AREA_2?u.lam=-o-Ut:u.lam=o<0?-o-Qt:-o+Qt;else{var d,f,p;d=a,h=d*d,p=h>=1?0:Math.sqrt(1-h)*Math.sin(o),h+=p*p,f=h>=1?0:Math.sqrt(1-h),c.value===wi.AREA_1?(h=f,f=-p,p=h):c.value===wi.AREA_2?(f=-f,p=-p):c.value===wi.AREA_3&&(h=f,f=p,p=-h),this.face===vi.RIGHT?(h=d,d=-f,f=h):this.face===vi.BACK?(d=-d,f=-f):this.face===vi.LEFT&&(h=d,d=f,f=-h),u.phi=Math.acos(-p)-Ut,u.lam=Math.atan2(f,d),this.face===vi.RIGHT?u.lam=Mt(u.lam,-Ut):this.face===vi.BACK?u.lam=Mt(u.lam,-Qt):this.face===vi.LEFT&&(u.lam=Mt(u.lam,+Ut))}if(0!==this.es){var m,g,b;m=u.phi<0?1:0,g=Math.tan(u.phi),b=this.b/Math.sqrt(g*g+this.one_minus_f_squared),u.phi=Math.atan(Math.sqrt(this.a*this.a-b*b)/(this.one_minus_f*b)),m&&(u.phi=-u.phi)}return u.lam+=this.long0,e.x=u.lam,e.y=u.phi,e}function Ct(e,t,n,r){var i;return e<qt?(r.value=wi.AREA_0,i=0):(i=Math.atan2(t,n),Math.abs(i)<=Xt?r.value=wi.AREA_0:i>Xt&&i<=Ut+Xt?(r.value=wi.AREA_1,i-=Ut):i>Ut+Xt||i<=-(Ut+Xt)?(r.value=wi.AREA_2,i=i>=0?i-Qt:i+Qt):(r.value=wi.AREA_3,i+=Ut)),i}function Mt(e,t){var n=e+t;return n<-Qt?n+=Jt:n>+Qt&&(n-=Jt),n}function kt(e,t,n,r){for(var i=t;r;--r){var s=e(i);if(i-=s,Math.abs(s)<n)break}return i}function It(){this.x0=this.x0||0,this.y0=this.y0||0,this.long0=this.long0||0,this.es=0,this.title=this.title||"Robinson"}function Ot(e){var t=bn(e.x-this.long0),n=Math.abs(e.y),r=Math.floor(n*Ci);r<0?r=0:r>=ki&&(r=ki-1),n=Zt*(n-Mi*r);var i={x:Ii(Li[r],n)*t,y:Ii(xi[r],n)};return e.y<0&&(i.y=-i.y),i.x=i.x*this.a*Ri+this.x0,i.y=i.y*this.a*Ai+this.y0,i}function Pt(e){var t={x:(e.x-this.x0)/(this.a*Ri),y:Math.abs(e.y-this.y0)/(this.a*Ai)};if(t.y>=1)t.x/=Li[ki][0],t.y=e.y<0?-Ut:Ut;else{var n=Math.floor(t.y*ki);for(n<0?n=0:n>=ki&&(n=ki-1);;)if(xi[n][0]>t.y)--n;else{if(!(xi[n+1][0]<=t.y))break;++n}var r=xi[n],i=5*(t.y-r[0])/(xi[n+1][0]-r[0]);i=kt(function(e){return(Ii(r,e)-t.y)/Oi(r,e)},i,qt,100),t.x/=Ii(Li[n],i),t.y=(5*n+i)*Yt,e.y<0&&(t.y=-t.y)}return t.x=bn(t.x+this.long0),t}function Nt(){this.name="geocent"}function Dt(e){return C(e,this.es,this.a)}function Ft(e){return M(e,this.es,this.a,this.b)}var Bt=1,Wt=2,Vt=4,Gt=5,jt=484813681109536e-20,Ut=Math.PI/2,zt=.16666666666666666,Kt=.04722222222222222,Ht=.022156084656084655,qt=1e-10,Yt=.017453292519943295,Zt=57.29577951308232,Xt=Math.PI/4,Jt=2*Math.PI,Qt=3.14159265359,$t={};$t.greenwich=0,$t.lisbon=-9.131906111111,$t.paris=2.337229166667,$t.bogota=-74.080916666667,$t.madrid=-3.687938888889,$t.rome=12.452333333333,$t.bern=7.439583333333,$t.jakarta=106.807719444444,$t.ferro=-17.666666666667,$t.brussels=4.367975,$t.stockholm=18.058277777778,$t.athens=23.7163375,$t.oslo=10.722916666667;var en={ft:{to_meter:.3048},"us-ft":{to_meter:1200/3937}},tn=/[\s_\-\/\(\)]/g,nn=function(t){var n,r,i,s={},o=t.split("+").map(function(e){return e.trim()}).filter(function(e){return e}).reduce(function(e,t){var n=t.split("=");return n.push(!0),e[n[0].toLowerCase()]=n[1],e},{}),a={proj:"projName",datum:"datumCode",rf:function(e){s.rf=parseFloat(e)},lat_0:function(e){s.lat0=e*Yt},lat_1:function(e){s.lat1=e*Yt},lat_2:function(e){s.lat2=e*Yt},lat_ts:function(e){s.lat_ts=e*Yt},lon_0:function(e){s.long0=e*Yt},lon_1:function(e){s.long1=e*Yt},lon_2:function(e){s.long2=e*Yt},alpha:function(e){s.alpha=parseFloat(e)*Yt},lonc:function(e){s.longc=e*Yt},x_0:function(e){s.x0=parseFloat(e)},y_0:function(e){s.y0=parseFloat(e)},k_0:function(e){s.k0=parseFloat(e)},k:function(e){s.k0=parseFloat(e)},a:function(e){s.a=parseFloat(e)},b:function(e){s.b=parseFloat(e)},r_a:function(){s.R_A=!0},zone:function(e){s.zone=parseInt(e,10)},south:function(){s.utmSouth=!0},towgs84:function(e){s.datum_params=e.split(",").map(function(e){return parseFloat(e)})},to_meter:function(e){s.to_meter=parseFloat(e)},units:function(t){s.units=t;var n=e(en,t);n&&(s.to_meter=n.to_meter)},from_greenwich:function(e){s.from_greenwich=e*Yt},pm:function(t){var n=e($t,t);s.from_greenwich=(n||parseFloat(t))*Yt},nadgrids:function(e){"@null"===e?s.datumCode="none":s.nadgrids=e},axis:function(e){var t="ewnsud";3===e.length&&-1!==t.indexOf(e.substr(0,1))&&-1!==t.indexOf(e.substr(1,1))&&-1!==t.indexOf(e.substr(2,1))&&(s.axis=e)}};for(n in o)r=o[n],n in a?(i=a[n],"function"==typeof i?i(r):s[i]=r):s[n]=r;return"string"==typeof s.datumCode&&"WGS84"!==s.datumCode&&(s.datumCode=s.datumCode.toLowerCase()),s},rn=1,sn=/\s/,on=/[A-Za-z]/,an=/[A-Za-z84]/,ln=/[,\]]/,hn=/[\d\.E\-\+]/;t.prototype.readCharicter=function(){var e=this.text[this.place++];if(4!==this.state)for(;sn.test(e);){if(this.place>=this.text.length)return;e=this.text[this.place++]}switch(this.state){case rn:return this.neutral(e);case 2:return this.keyword(e);case 4:return this.quoted(e);case 5:return this.afterquote(e);case 3:return this.number(e);case-1:return}},t.prototype.afterquote=function(e){if('"'===e)return this.word+='"',void(this.state=4);if(ln.test(e))return this.word=this.word.trim(),void this.afterItem(e);throw new Error("havn't handled \""+e+'" in afterquote yet, index '+this.place)},t.prototype.afterItem=function(e){return","===e?(null!==this.word&&this.currentObject.push(this.word),this.word=null,void(this.state=rn)):"]"===e?(this.level--,null!==this.word&&(this.currentObject.push(this.word),this.word=null),this.state=rn,this.currentObject=this.stack.pop(),void(this.currentObject||(this.state=-1))):void 0},t.prototype.number=function(e){if(hn.test(e))return void(this.word+=e);if(ln.test(e))return this.word=parseFloat(this.word),void this.afterItem(e);throw new Error("havn't handled \""+e+'" in number yet, index '+this.place)},t.prototype.quoted=function(e){if('"'===e)return void(this.state=5);this.word+=e},t.prototype.keyword=function(e){if(an.test(e))return void(this.word+=e);if("["===e){var t=[];return t.push(this.word),this.level++,null===this.root?this.root=t:this.currentObject.push(t),this.stack.push(this.currentObject),this.currentObject=t,void(this.state=rn)}if(ln.test(e))return void this.afterItem(e);throw new Error("havn't handled \""+e+'" in keyword yet, index '+this.place)},t.prototype.neutral=function(e){if(on.test(e))return this.word=e,void(this.state=2);if('"'===e)return this.word="",void(this.state=4);if(hn.test(e))return this.word=e,void(this.state=3);if(ln.test(e))return void this.afterItem(e);throw new Error("havn't handled \""+e+'" in neutral yet, index '+this.place)},t.prototype.output=function(){for(;this.place<this.text.length;)this.readCharicter();if(-1===this.state)return this.root;throw new Error('unable to parse string "'+this.text+'". State is '+this.state)};var un=.017453292519943295,cn=function(e){var t=n(e),r=t.shift(),s=t.shift();t.unshift(["name",s]),t.unshift(["type",r]);var o={};return i(t,o),a(o),o};!function(e){e("EPSG:4326","+title=WGS 84 (long/lat) +proj=longlat +ellps=WGS84 +datum=WGS84 +units=degrees"),e("EPSG:4269","+title=NAD83 (long/lat) +proj=longlat +a=6378137.0 +b=6356752.31414036 +ellps=GRS80 +datum=NAD83 +units=degrees"),e("EPSG:3857","+title=WGS 84 / Pseudo-Mercator +proj=merc +a=6378137 +b=6378137 +lat_ts=0.0 +lon_0=0.0 +x_0=0.0 +y_0=0 +k=1.0 +units=m +nadgrids=@null +no_defs"),e.WGS84=e["EPSG:4326"],e["EPSG:3785"]=e["EPSG:3857"],e.GOOGLE=e["EPSG:3857"],e["EPSG:900913"]=e["EPSG:3857"],e["EPSG:102113"]=e["EPSG:3857"]}(l);var dn=["PROJECTEDCRS","PROJCRS","GEOGCS","GEOCCS","PROJCS","LOCAL_CS","GEODCRS","GEODETICCRS","GEODETICDATUM","ENGCRS","ENGINEERINGCRS"],fn=["3857","900913","3785","102113"],pn=function(e,t){e=e||{};var n,r;if(!t)return e;for(r in t)void 0!==(n=t[r])&&(e[r]=n);return e},mn=function(e,t,n){var r=e*t;return n/Math.sqrt(1-r*r)},gn=function(e){return e<0?-1:1},bn=function(e){return Math.abs(e)<=Qt?e:e-gn(e)*Jt},yn=function(e,t,n){var r=e*n,i=.5*e;return r=Math.pow((1-r)/(1+r),i),Math.tan(.5*(Ut-t))/r},_n=function(e,t){
for(var n,r,i=.5*e,s=Ut-2*Math.atan(t),o=0;o<=15;o++)if(n=e*Math.sin(s),r=Ut-2*Math.atan(t*Math.pow((1-n)/(1+n),i))-s,s+=r,Math.abs(r)<=1e-10)return s;return-9999},En=["Mercator","Popular Visualisation Pseudo Mercator","Mercator_1SP","Mercator_Auxiliary_Sphere","merc"],vn={init:g,forward:b,inverse:y,names:En},wn=["longlat","identity"],Sn={init:_,forward:E,inverse:E,names:wn},Tn=[vn,Sn],Ln={},xn=[],Rn={start:S,add:v,get:w},An={};An.MERIT={a:6378137,rf:298.257,ellipseName:"MERIT 1983"},An.SGS85={a:6378136,rf:298.257,ellipseName:"Soviet Geodetic System 85"},An.GRS80={a:6378137,rf:298.257222101,ellipseName:"GRS 1980(IUGG, 1980)"},An.IAU76={a:6378140,rf:298.257,ellipseName:"IAU 1976"},An.airy={a:6377563.396,b:6356256.91,ellipseName:"Airy 1830"},An.APL4={a:6378137,rf:298.25,ellipseName:"Appl. Physics. 1965"},An.NWL9D={a:6378145,rf:298.25,ellipseName:"Naval Weapons Lab., 1965"},An.mod_airy={a:6377340.189,b:6356034.446,ellipseName:"Modified Airy"},An.andrae={a:6377104.43,rf:300,ellipseName:"Andrae 1876 (Den., Iclnd.)"},An.aust_SA={a:6378160,rf:298.25,ellipseName:"Australian Natl & S. Amer. 1969"},An.GRS67={a:6378160,rf:298.247167427,ellipseName:"GRS 67(IUGG 1967)"},An.bessel={a:6377397.155,rf:299.1528128,ellipseName:"Bessel 1841"},An.bess_nam={a:6377483.865,rf:299.1528128,ellipseName:"Bessel 1841 (Namibia)"},An.clrk66={a:6378206.4,b:6356583.8,ellipseName:"Clarke 1866"},An.clrk80={a:6378249.145,rf:293.4663,ellipseName:"Clarke 1880 mod."},An.clrk58={a:6378293.645208759,rf:294.2606763692654,ellipseName:"Clarke 1858"},An.CPM={a:6375738.7,rf:334.29,ellipseName:"Comm. des Poids et Mesures 1799"},An.delmbr={a:6376428,rf:311.5,ellipseName:"Delambre 1810 (Belgium)"},An.engelis={a:6378136.05,rf:298.2566,ellipseName:"Engelis 1985"},An.evrst30={a:6377276.345,rf:300.8017,ellipseName:"Everest 1830"},An.evrst48={a:6377304.063,rf:300.8017,ellipseName:"Everest 1948"},An.evrst56={a:6377301.243,rf:300.8017,ellipseName:"Everest 1956"},An.evrst69={a:6377295.664,rf:300.8017,ellipseName:"Everest 1969"},An.evrstSS={a:6377298.556,rf:300.8017,ellipseName:"Everest (Sabah & Sarawak)"},An.fschr60={a:6378166,rf:298.3,ellipseName:"Fischer (Mercury Datum) 1960"},An.fschr60m={a:6378155,rf:298.3,ellipseName:"Fischer 1960"},An.fschr68={a:6378150,rf:298.3,ellipseName:"Fischer 1968"},An.helmert={a:6378200,rf:298.3,ellipseName:"Helmert 1906"},An.hough={a:6378270,rf:297,ellipseName:"Hough"},An.intl={a:6378388,rf:297,ellipseName:"International 1909 (Hayford)"},An.kaula={a:6378163,rf:298.24,ellipseName:"Kaula 1961"},An.lerch={a:6378139,rf:298.257,ellipseName:"Lerch 1979"},An.mprts={a:6397300,rf:191,ellipseName:"Maupertius 1738"},An.new_intl={a:6378157.5,b:6356772.2,ellipseName:"New International 1967"},An.plessis={a:6376523,rf:6355863,ellipseName:"Plessis 1817 (France)"},An.krass={a:6378245,rf:298.3,ellipseName:"Krassovsky, 1942"},An.SEasia={a:6378155,b:6356773.3205,ellipseName:"Southeast Asia"},An.walbeck={a:6376896,b:6355834.8467,ellipseName:"Walbeck"},An.WGS60={a:6378165,rf:298.3,ellipseName:"WGS 60"},An.WGS66={a:6378145,rf:298.25,ellipseName:"WGS 66"},An.WGS7={a:6378135,rf:298.26,ellipseName:"WGS 72"};var Cn=An.WGS84={a:6378137,rf:298.257223563,ellipseName:"WGS 84"};An.sphere={a:6370997,b:6370997,ellipseName:"Normal Sphere (r=6370997)"};var Mn={};Mn.wgs84={towgs84:"0,0,0",ellipse:"WGS84",datumName:"WGS84"},Mn.ch1903={towgs84:"674.374,15.056,405.346",ellipse:"bessel",datumName:"swiss"},Mn.ggrs87={towgs84:"-199.87,74.79,246.62",ellipse:"GRS80",datumName:"Greek_Geodetic_Reference_System_1987"},Mn.nad83={towgs84:"0,0,0",ellipse:"GRS80",datumName:"North_American_Datum_1983"},Mn.nad27={nadgrids:"@conus,@alaska,@ntv2_0.gsb,@ntv1_can.dat",ellipse:"clrk66",datumName:"North_American_Datum_1927"},Mn.potsdam={towgs84:"606.0,23.0,413.0",ellipse:"bessel",datumName:"Potsdam Rauenberg 1950 DHDN"},Mn.carthage={towgs84:"-263.0,6.0,431.0",ellipse:"clark80",datumName:"Carthage 1934 Tunisia"},Mn.hermannskogel={towgs84:"653.0,-212.0,449.0",ellipse:"bessel",datumName:"Hermannskogel"},Mn.osni52={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"airy",datumName:"Irish National"},Mn.ire65={towgs84:"482.530,-130.596,564.557,-1.042,-0.214,-0.631,8.15",ellipse:"mod_airy",datumName:"Ireland 1965"},Mn.rassadiran={towgs84:"-133.63,-157.5,-158.62",ellipse:"intl",datumName:"Rassadiran"},Mn.nzgd49={towgs84:"59.47,-5.04,187.44,0.47,-0.1,1.024,-4.5993",ellipse:"intl",datumName:"New Zealand Geodetic Datum 1949"},Mn.osgb36={towgs84:"446.448,-125.157,542.060,0.1502,0.2470,0.8421,-20.4894",ellipse:"airy",datumName:"Airy 1830"},Mn.s_jtsk={towgs84:"589,76,480",ellipse:"bessel",datumName:"S-JTSK (Ferro)"},Mn.beduaram={towgs84:"-106,-87,188",ellipse:"clrk80",datumName:"Beduaram"},Mn.gunung_segara={towgs84:"-403,684,41",ellipse:"bessel",datumName:"Gunung Segara Jakarta"},Mn.rnb72={towgs84:"106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1",ellipse:"intl",datumName:"Reseau National Belge 1972"},R.projections=Rn,R.projections.start();var kn=function(e,t,n){return A(e,t)?n:e.datum_type===Gt||t.datum_type===Gt?n:e.es!==t.es||e.a!==t.a||O(e.datum_type)||O(t.datum_type)?(n=C(n,e.es,e.a),O(e.datum_type)&&(n=k(n,e.datum_type,e.datum_params)),O(t.datum_type)&&(n=I(n,t.datum_type,t.datum_params)),M(n,t.es,t.a,t.b)):n},In=function(e,t,n){var r,i,s,o=n.x,a=n.y,l=n.z||0,h={};for(s=0;s<3;s++)if(!t||2!==s||void 0!==n.z)switch(0===s?(r=o,i="x"):1===s?(r=a,i="y"):(r=l,i="z"),e.axis[s]){case"e":h[i]=r;break;case"w":h[i]=-r;break;case"n":h[i]=r;break;case"s":h[i]=-r;break;case"u":void 0!==n[i]&&(h.z=r);break;case"d":void 0!==n[i]&&(h.z=-r);break;default:return null}return h},On=function(e){var t={x:e[0],y:e[1]};return e.length>2&&(t.z=e[2]),e.length>3&&(t.m=e[3]),t},Pn=function(e){P(e.x),P(e.y)},Nn=R("WGS84"),Dn=6,Fn="AJSAJS",Bn="AFAFAF",Wn=65,Vn=73,Gn=79,jn=86,Un=90,zn={forward:V,inverse:G,toPoint:j};ne.fromMGRS=function(e){return new ne(j(e))},ne.prototype.toMGRS=function(e){return V([this.x,this.y],e)};var Kn=.01068115234375,Hn=function(e){var t=[];t[0]=1-e*(.25+e*(.046875+e*(.01953125+e*Kn))),t[1]=e*(.75-e*(.046875+e*(.01953125+e*Kn)));var n=e*e;return t[2]=n*(.46875-e*(.013020833333333334+.007120768229166667*e)),n*=e,t[3]=n*(.3645833333333333-.005696614583333333*e),t[4]=n*e*.3076171875,t},qn=function(e,t,n,r){return n*=t,t*=t,r[0]*e-n*(r[1]+t*(r[2]+t*(r[3]+t*r[4])))},Yn=function(e,t,n){for(var r=1/(1-t),i=e,s=20;s;--s){var o=Math.sin(i),a=1-t*o*o;if(a=(qn(i,o,Math.cos(i),n)-e)*(a*Math.sqrt(a))*r,i-=a,Math.abs(a)<qt)return i}return i},Zn=["Transverse_Mercator","Transverse Mercator","tmerc"],Xn={init:re,forward:ie,inverse:se,names:Zn},Jn=function(e){var t=Math.exp(e);return t=(t-1/t)/2},Qn=function(e,t){e=Math.abs(e),t=Math.abs(t);var n=Math.max(e,t),r=Math.min(e,t)/(n||1);return n*Math.sqrt(1+Math.pow(r,2))},$n=function(e){var t=1+e,n=t-1;return 0===n?e:e*Math.log(t)/n},er=function(e){var t=Math.abs(e);return t=$n(t*(1+t/(Qn(1,t)+1))),e<0?-t:t},tr=function(e,t){for(var n,r=2*Math.cos(2*t),i=e.length-1,s=e[i],o=0;--i>=0;)n=r*s-o+e[i],o=s,s=n;return t+n*Math.sin(2*t)},nr=function(e,t){for(var n,r=2*Math.cos(t),i=e.length-1,s=e[i],o=0;--i>=0;)n=r*s-o+e[i],o=s,s=n;return Math.sin(t)*n},rr=function(e){var t=Math.exp(e);return t=(t+1/t)/2},ir=function(e,t,n){for(var r,i,s=Math.sin(t),o=Math.cos(t),a=Jn(n),l=rr(n),h=2*o*l,u=-2*s*a,c=e.length-1,d=e[c],f=0,p=0,m=0;--c>=0;)r=p,i=f,p=d,f=m,d=h*p-r-u*f+e[c],m=u*p-i+h*f;return h=s*l,u=o*a,[h*d-u*m,h*m+u*d]},sr=["Extended_Transverse_Mercator","Extended Transverse Mercator","etmerc"],or={init:oe,forward:ae,inverse:le,names:sr},ar=function(e,t){if(void 0===e){if((e=Math.floor(30*(bn(t)+Math.PI)/Math.PI)+1)<0)return 0;if(e>60)return 60}return e},lr=["Universal Transverse Mercator System","utm"],hr={init:he,names:lr,dependsOn:"etmerc"},ur=function(e,t){return Math.pow((1-e)/(1+e),t)},cr=20,dr=["gauss"],fr={init:ue,forward:ce,inverse:de,names:dr},pr=["Stereographic_North_Pole","Oblique_Stereographic","Polar_Stereographic","sterea","Oblique Stereographic Alternative","Double_Stereographic"],mr={init:fe,forward:pe,inverse:me,names:pr},gr=["stere","Stereographic_South_Pole","Polar Stereographic (variant B)"],br={init:be,forward:ye,inverse:_e,names:gr,ssfn_:ge},yr=["somerc"],_r={init:Ee,forward:ve,inverse:we,names:yr},Er=["Hotine_Oblique_Mercator","Hotine Oblique Mercator","Hotine_Oblique_Mercator_Azimuth_Natural_Origin","Hotine_Oblique_Mercator_Azimuth_Center","omerc"],vr={init:Se,forward:Te,inverse:Le,names:Er},wr=["Lambert Tangential Conformal Conic Projection","Lambert_Conformal_Conic","Lambert_Conformal_Conic_2SP","lcc"],Sr={init:xe,forward:Re,inverse:Ae,names:wr},Tr=["Krovak","krovak"],Lr={init:Ce,forward:Me,inverse:ke,names:Tr},xr=function(e,t,n,r,i){return e*i-t*Math.sin(2*i)+n*Math.sin(4*i)-r*Math.sin(6*i)},Rr=function(e){return 1-.25*e*(1+e/16*(3+1.25*e))},Ar=function(e){return.375*e*(1+.25*e*(1+.46875*e))},Cr=function(e){return.05859375*e*e*(1+.75*e)},Mr=function(e){return e*e*e*(35/3072)},kr=function(e,t,n){var r=t*n;return e/Math.sqrt(1-r*r)},Ir=function(e){return Math.abs(e)<Ut?e:e-gn(e)*Math.PI},Or=function(e,t,n,r,i){var s,o;s=e/t;for(var a=0;a<15;a++)if(o=(e-(t*s-n*Math.sin(2*s)+r*Math.sin(4*s)-i*Math.sin(6*s)))/(t-2*n*Math.cos(2*s)+4*r*Math.cos(4*s)-6*i*Math.cos(6*s)),s+=o,Math.abs(o)<=1e-10)return s;return NaN},Pr=["Cassini","Cassini_Soldner","cass"],Nr={init:Ie,forward:Oe,inverse:Pe,names:Pr},Dr=function(e,t){var n;return e>1e-7?(n=e*t,(1-e*e)*(t/(1-n*n)-.5/e*Math.log((1-n)/(1+n)))):2*t},Fr=.3333333333333333,Br=.17222222222222222,Wr=.10257936507936508,Vr=.06388888888888888,Gr=.0664021164021164,jr=.016415012942191543,Ur=["Lambert Azimuthal Equal Area","Lambert_Azimuthal_Equal_Area","laea"],zr={init:Ne,forward:De,inverse:Fe,names:Ur,S_POLE:1,N_POLE:2,EQUIT:3,OBLIQ:4},Kr=function(e){return Math.abs(e)>1&&(e=e>1?1:-1),Math.asin(e)},Hr=["Albers_Conic_Equal_Area","Albers","aea"],qr={init:Ve,forward:Ge,inverse:je,names:Hr,phi1z:Ue},Yr=["gnom"],Zr={init:ze,forward:Ke,inverse:He,names:Yr},Xr=function(e,t){var n=1-(1-e*e)/(2*e)*Math.log((1-e)/(1+e));if(Math.abs(Math.abs(t)-n)<1e-6)return t<0?-1*Ut:Ut;for(var r,i,s,o,a=Math.asin(.5*t),l=0;l<30;l++)if(i=Math.sin(a),s=Math.cos(a),o=e*i,r=Math.pow(1-o*o,2)/(2*s)*(t/(1-e*e)-i/(1-o*o)+.5/e*Math.log((1-o)/(1+o))),a+=r,Math.abs(r)<=1e-10)return a;return NaN},Jr=["cea"],Qr={init:qe,forward:Ye,inverse:Ze,names:Jr},$r=["Equirectangular","Equidistant_Cylindrical","eqc"],ei={init:Xe,forward:Je,inverse:Qe,names:$r},ti=20,ni=["Polyconic","poly"],ri={init:$e,forward:et,inverse:tt,names:ni},ii=["New_Zealand_Map_Grid","nzmg"],si={init:nt,forward:rt,inverse:it,names:ii},oi=["Miller_Cylindrical","mill"],ai={init:st,forward:ot,inverse:at,names:oi},li=20,hi=["Sinusoidal","sinu"],ui={init:lt,forward:ht,inverse:ut,names:hi},ci=["Mollweide","moll"],di={init:ct,forward:dt,inverse:ft,names:ci},fi=["Equidistant_Conic","eqdc"],pi={init:pt,forward:mt,inverse:gt,names:fi},mi=["Van_der_Grinten_I","VanDerGrinten","vandg"],gi={init:bt,forward:yt,inverse:_t,names:mi},bi=["Azimuthal_Equidistant","aeqd"],yi={init:Et,forward:vt,inverse:wt,names:bi},_i=["ortho"],Ei={init:St,forward:Tt,inverse:Lt,names:_i},vi={FRONT:1,RIGHT:2,BACK:3,LEFT:4,TOP:5,BOTTOM:6},wi={AREA_0:1,AREA_1:2,AREA_2:3,AREA_3:4},Si=["Quadrilateralized Spherical Cube","Quadrilateralized_Spherical_Cube","qsc"],Ti={init:xt,forward:Rt,inverse:At,names:Si},Li=[[1,2.2199e-17,-715515e-10,31103e-10],[.9986,-482243e-9,-24897e-9,-13309e-10],[.9954,-83103e-8,-448605e-10,-9.86701e-7],[.99,-.00135364,-59661e-9,36777e-10],[.9822,-.00167442,-449547e-11,-572411e-11],[.973,-.00214868,-903571e-10,1.8736e-8],[.96,-.00305085,-900761e-10,164917e-11],[.9427,-.00382792,-653386e-10,-26154e-10],[.9216,-.00467746,-10457e-8,481243e-11],[.8962,-.00536223,-323831e-10,-543432e-11],[.8679,-.00609363,-113898e-9,332484e-11],[.835,-.00698325,-640253e-10,9.34959e-7],[.7986,-.00755338,-500009e-10,9.35324e-7],[.7597,-.00798324,-35971e-9,-227626e-11],[.7186,-.00851367,-701149e-10,-86303e-10],[.6732,-.00986209,-199569e-9,191974e-10],[.6213,-.010418,883923e-10,624051e-11],[.5722,-.00906601,182e-6,624051e-11],[.5322,-.00677797,275608e-9,624051e-11]],xi=[[-5.20417e-18,.0124,1.21431e-18,-8.45284e-11],[.062,.0124,-1.26793e-9,4.22642e-10],[.124,.0124,5.07171e-9,-1.60604e-9],[.186,.0123999,-1.90189e-8,6.00152e-9],[.248,.0124002,7.10039e-8,-2.24e-8],[.31,.0123992,-2.64997e-7,8.35986e-8],[.372,.0124029,9.88983e-7,-3.11994e-7],[.434,.0123893,-369093e-11,-4.35621e-7],[.4958,.0123198,-102252e-10,-3.45523e-7],[.5571,.0121916,-154081e-10,-5.82288e-7],[.6176,.0119938,-241424e-10,-5.25327e-7],[.6769,.011713,-320223e-10,-5.16405e-7],[.7346,.0113541,-397684e-10,-6.09052e-7],[.7903,.0109107,-489042e-10,-104739e-11],[.8435,.0103431,-64615e-9,-1.40374e-9],[.8936,.00969686,-64636e-9,-8547e-9],[.9394,.00840947,-192841e-9,-42106e-10],[.9761,.00616527,-256e-6,-42106e-10],[1,.00328947,-319159e-9,-42106e-10]],Ri=.8487,Ai=1.3523,Ci=Zt/5,Mi=1/Ci,ki=18,Ii=function(e,t){return e[0]+t*(e[1]+t*(e[2]+t*e[3]))},Oi=function(e,t){return e[1]+t*(2*e[2]+3*t*e[3])},Pi=["Robinson","robin"],Ni={init:It,forward:Ot,inverse:Pt,names:Pi},Di=["Geocentric","geocentric","geocent","Geocent"],Fi={init:Nt,forward:Dt,inverse:Ft,names:Di};return W.defaultDatum="WGS84",W.Proj=R,W.WGS84=new W.Proj("WGS84"),W.Point=ne,W.toPoint=On,W.defs=l,W.transform=D,W.mgrs=zn,W.version="2.6.0",function(e){e.Proj.projections.add(Xn),e.Proj.projections.add(or),e.Proj.projections.add(hr),e.Proj.projections.add(mr),e.Proj.projections.add(br),e.Proj.projections.add(_r),e.Proj.projections.add(vr),e.Proj.projections.add(Sr),e.Proj.projections.add(Lr),e.Proj.projections.add(Nr),e.Proj.projections.add(zr),e.Proj.projections.add(qr),e.Proj.projections.add(Zr),e.Proj.projections.add(Qr),e.Proj.projections.add(ei),e.Proj.projections.add(ri),e.Proj.projections.add(si),e.Proj.projections.add(ai),e.Proj.projections.add(ui),e.Proj.projections.add(di),e.Proj.projections.add(pi),e.Proj.projections.add(gi),e.Proj.projections.add(yi),e.Proj.projections.add(Ei),e.Proj.projections.add(Ti),e.Proj.projections.add(Ni),e.Proj.projections.add(Fi)}(W),W}),define("formats/geotiff/TiffIFDEntry",["../../error/AbstractError","../../error/ArgumentError","./GeoTiffUtil","../../util/Logger","./TiffConstants"],function(e,t,n,r,i){"use strict";var s=function(e,n,i,s,o,a){if(!e)throw new t(r.logMessage(r.LEVEL_SEVERE,"TiffIFDEntry","constructor","missingTag"));if(!n)throw new t(r.logMessage(r.LEVEL_SEVERE,"TiffIFDEntry","constructor","missingType"));if(!i)throw new t(r.logMessage(r.LEVEL_SEVERE,"TiffIFDEntry","constructor","missingCount"));if(null===s||void 0===s)throw new t(r.logMessage(r.LEVEL_SEVERE,"TiffIFDEntry","constructor","missingValueOffset"));if(!o)throw new t(r.logMessage(r.LEVEL_SEVERE,"TiffIFDEntry","constructor","missingGeoTiffData"));if(null===a||void 0===a)throw new t(r.logMessage(r.LEVEL_SEVERE,"TiffIFDEntry","constructor","missingIsLittleEndian"));this._tag=e,this._type=n,this._count=i,this._valueOffset=s,this._geoTiffData=o,this._isLittleEndian=a};return Object.defineProperties(s.prototype,{tag:{get:function(){return this._tag}},type:{get:function(){return this._type}},count:{get:function(){return this._count}},valueOffset:{get:function(){return this._valueOffset}},geoTiffData:{get:function(){return this._geoTiffData}},isLittleEndian:{get:function(){return this._isLittleEndian}}}),s.prototype.getIFDTypeLength=function(){switch(this.type){case i.Type.BYTE:case i.Type.ASCII:case i.Type.SBYTE:case i.Type.UNDEFINED:return 1;case i.Type.SHORT:case i.Type.SSHORT:return 2;case i.Type.LONG:case i.Type.SLONG:case i.Type.FLOAT:return 4;case i.Type.RATIONAL:case i.Type.SRATIONAL:case i.Type.DOUBLE:return 8;default:return-1}},s.prototype.getIFDEntryValue=function(){var t=[],s=null,o=this.getIFDTypeLength();if(o*this.count<=4)s=!1===this.isLittleEndian?this.valueOffset>>>8*(4-o):this.valueOffset,t.push(s);else for(var a=0;a<this.count;a++){var l=o*a;if(o>=8)if(this.type===i.Type.RATIONAL||this.type===i.Type.SRATIONAL)t.push(n.getBytes(this.geoTiffData,this.valueOffset+l,4,this.isLittleEndian)),t.push(n.getBytes(this.geoTiffData,this.valueOffset+l+4,4,this.isLittleEndian));else{if(this.type!==i.Type.DOUBLE)throw new e(r.logMessage(r.LEVEL_SEVERE,"TiffIFDEntry","parse","invalidTypeOfIFD"));t.push(n.getBytes(this.geoTiffData,this.valueOffset+l,8,this.isLittleEndian))}else t.push(n.getBytes(this.geoTiffData,this.valueOffset+l,o,this.isLittleEndian))}return this.type===i.Type.ASCII?(t.forEach(function(e,t,n){0===e?n.splice(t,1):n[t]=String.fromCharCode(e)}),t.join("")):t},s}),define("util/WWUtil",["../error/ArgumentError","../geom/Line","../util/Logger","../geom/Rectangle","../geom/Vec3"],function(e,t,n,r,i){"use strict";var s={latLonRegex:/^(\-?\d+(\.\d+)?),\s*(\-?\d+(\.\d+)?)$/,suffixForMimeType:function(e){return"image/png"===e?"png":"image/jpeg"===e?"jpg":"application/bil16"===e?"bil":"application/bil32"===e?"bil":null},currentUrlSansFilePart:function(){for(var e=window.location.protocol,t=window.location.host,n=window.location.pathname,r=n.split("/"),i="",s=0,o=r.length;s<o-1;s++)r[s].length>0&&(i=i+"/"+r[s]);return e+"//"+t+i},worldwindlibLocation:function(){for(var e=document.getElementsByTagName("script"),t=0;t<e.length;t++){var n=e[t].src.indexOf("/worldwind.");if(n>=0)return e[t].src.substring(0,n)+"/"}return null},urlPath:function(e){if(!e)return"";for(var t=e.split("/"),n="",r=0,i=t.length;r<i;r++){var s=t[r];s&&0!==s.length&&-1==s.indexOf(":")&&"."!==s&&".."!==s&&"null"!==s&&"undefined"!==s&&(0!==n.length&&(n+="/"),n+=s)}return n},fillArray:function(e,t){if(e)for(var n=0,r=e.length;n<r;n++)e[n]=t},multiplyArray:function(e,t){if(e)for(var n=0,r=e.length;n<r;n++)e[n]*=t},jsonpCounter:0,jsonp:function(e,t,n){var r="gov_nasa_worldwind_jsonp_"+s.jsonpCounter++;window[r]=function(e){delete window[r],n(e)};var i=e+(-1===e.indexOf("?")?"?":"&");i+=t+"="+r;var o=document.createElement("script");o.async=!0,o.src=i;var a=document.getElementsByTagName("head")[0],l=function(){o.onload=void 0,o.onerror=void 0,a.removeChild(o)};o.onload=l,o.onerror=l,a.appendChild(o)},arrayEquals:function(e,t){return e.length==t.length&&e.every(function(e,n){return e===t[n]||e.equals&&e.equals(t[n])})},transformToBoolean:function(e){return 0!=e&&"0"!=e&&"false"!=e&&Boolean(e)},clone:function(e){var t,n={},r=Object.keys(e);for(t=0;t<r.length;t++)n[r[t]]=e[r[t]];return n},guid:function(){function e(){return Math.floor(65536*(1+Math.random())).toString(16).substring(1)}return e()+e()+"-"+e()+"-"+e()+"-"+e()+"-"+e()+e()+e()},date:function(e){return new Date(e)},startsWith:function(e,t,n){return n=n||0,e.substr(n,t.length)===t},endsWith:function(e,t,n){("number"!=typeof n||!isFinite(n)||Math.floor(n)!==n||n>e.length)&&(n=e.length),n-=t.length;var r=e.lastIndexOf(t,n);return-1!==r&&r===n}};return s}),define("formats/geotiff/GeoTiffReader",["../../error/AbstractError","../../error/ArgumentError","./GeoTiffConstants","./GeoTiffKeyEntry","./GeoTiffMetadata","./GeoTiffUtil","../../geom/Location","../../geom/Sector","../../util/Logger","../../util/proj4-src","./TiffConstants","./TiffIFDEntry","../../util/WWUtil"],function(e,t,n,r,i,s,o,a,l,h,u,c,d){"use strict";var f=function(e){if(!e)throw new t(l.logMessage(l.LEVEL_SEVERE,"GeoTiffReader","constructor","missingArrayBuffer"));this._isLittleEndian=!1,this._imageFileDirectories=[],this._geoTiffData=new DataView(e),this._metadata=new i,this.parse()};return Object.defineProperties(f.prototype,{isLittleEndian:{get:function(){return this._isLittleEndian}},imageFileDirectories:{get:function(){return this._imageFileDirectories}},geoTiffData:{get:function(){return this._geoTiffData}},metadata:{get:function(){return this._metadata}}}),f.retrieveFromUrl=function(e,n){if(!e)throw new t(l.logMessage(l.LEVEL_SEVERE,"GeoTiffReader","retrieveFromUrl","missingUrl"));if(!n)throw new t(l.logMessage(l.LEVEL_SEVERE,"GeoTiffReader","retrieveFromUrl","The specified callback is null or undefined."));var r=new XMLHttpRequest;r.open("GET",e,!0),r.responseType="arraybuffer",r.onreadystatechange=function(){if(4===r.readyState)if(200===r.status){var t=r.response;t&&n(new f(t),r)}else l.log(l.LEVEL_WARNING,"GeoTiff retrieval failed ("+r.statusText+"): "+e),n(null,r)}.bind(this),r.onerror=function(){l.log(l.LEVEL_WARNING,"GeoTiff retrieval failed: "+e),n(null,r)},r.ontimeout=function(){l.log(l.LEVEL_WARNING,"GeoTiff retrieval timed out: "+e),n(null,r)},r.send(null)},f.prototype.parse=function(){if(!this._imageFileDirectories.length){if(this.initEndiannessFromFile(),!this.isTiffFileType())throw new e(l.logMessage(l.LEVEL_SEVERE,"GeoTiffReader","parse","invalidTiffFileType"));var t=s.getBytes(this.geoTiffData,4,4,this.isLittleEndian);this.parseImageFileDirectory(t),this.getMetadataFromImageFileDirectory(),this.parseGeoKeys(),this.setBBox()}},f.prototype.initEndiannessFromFile=function(){var t=s.getBytes(this.geoTiffData,0,2,this.isLittleEndian);if(18761===t)this._isLittleEndian=!0;else{if(19789!==t)throw new e(l.logMessage(l.LEVEL_SEVERE,"GeoTiffReader","initEndiannessFromFile","invalidByteOrderValue"));this._isLittleEndian=!1}},f.prototype.getImage=function(){return this.createImage()},f.prototype.getImageData=function(){return this.createTypedElevationArray()},f.prototype.isTiffFileType=function(){return 42===s.getBytes(this.geoTiffData,2,2,this.isLittleEndian)},f.prototype.isGeoTiff=function(){return!!this.getIFDByTag(n.Tag.GEO_KEY_DIRECTORY)},f.prototype.createImage=function(){var e=this.metadata.bitsPerSample,t=this.metadata.samplesPerPixel,n=this.metadata.photometricInterpretation,r=this.metadata.imageLength,i=this.metadata.imageWidth;if(this.metadata.colorMap)var s=this.metadata.colorMap,o=Math.pow(2,e[0]);var a=document.createElement("canvas");a.width=i,a.height=r;var l=a.getContext("2d");if(this.metadata.stripOffsets){var h=this.parseStrips(!1);if(this.metadata.rowsPerStrip)var u=this.metadata.rowsPerStrip;else var u=r;for(var c=h.length,d=0,f=r%u,p=0===f?u:f,m=0;m<c;m++){m+1===c&&p;for(var g=h[m].length,b=d*m,y=0,_=0;_<g;y++)for(var E=0;E<i;E++,_++){var v=h[m][_];l.fillStyle=this.getFillStyle(v,n,e,t,s,o),l.fillRect(E,b+y,1,1)}d=u}}else if(this.metadata.tileOffsets)for(var w=this.parseTiles(!1),S=this.metadata.tileWidth,T=this.metadata.tileLength,L=Math.ceil(i/S),y=0;y<r;y++)for(var E=0;E<i;E++){var x=Math.floor(E/S),R=Math.floor(y/T),A=R*L+x,C=E%S,M=y%T,k=M*S+C,v=w[A][k];l.fillStyle=this.getFillStyle(v,n,e,t,s,o),l.fillRect(E,y,1,1)}return this._geoTiffData=null,a},f.prototype.getFillStyle=function(e,t,n,r,i,o){var a=0,h=0,c=0,d=1;switch(this.metadata.noData&&e[0]==this.metadata.noData&&(d=0),t){case u.PhotometricInterpretation.WHITE_IS_ZERO:var f=Math.pow(2,n)-1;e[0]=f-e[0];case u.PhotometricInterpretation.BLACK_IS_ZERO:a=h=c=s.clampColorSample(e[0],n[0]);break;case u.PhotometricInterpretation.RGB:if(a=s.clampColorSample(e[0],n[0]),h=s.clampColorSample(e[1],n[1]),c=s.clampColorSample(e[2],n[2]),4===r&&2===this.metadata.extraSamples[0]){var p=Math.pow(2,n[3]);d=e[3]/p}break;case u.PhotometricInterpretation.RGB_PALETTE:if(i){var m=e[0];a=s.clampColorSample(i[m],16),h=s.clampColorSample(i[o+m],16),c=s.clampColorSample(i[2*o+m],16)}break;case u.PhotometricInterpretation.TRANSPARENCY_MASK:l.log(l.LEVEL_WARNING,"Photometric interpretation not yet implemented: TRANSPARENCY_MASK");break;case u.PhotometricInterpretation.CMYK:l.log(l.LEVEL_WARNING,"Photometric interpretation not yet implemented: CMYK");break;case u.PhotometricInterpretation.Y_Cb_Cr:l.log(l.LEVEL_WARNING,"Photometric interpretation not yet implemented: Y_Cb_Cr");break;case u.PhotometricInterpretation.CIE_LAB:l.log(l.LEVEL_WARNING,"Photometric interpretation not yet implemented: CIE_LAB");break;default:l.log("Unknown photometric interpretation: "+t)}return s.getRGBAFillValue(a,h,c,d)},f.prototype.createTypedElevationArray=function(){var e,t=[],n=this.metadata.bitsPerSample[0];if(this.metadata.stripOffsets)for(var r=this.parseStrips(!0),i=0;i<r.length;i++)t=t.concat(r[i]);else if(this.metadata.tileOffsets)for(var s=this.parseTiles(!0),o=this.metadata.imageWidth,a=this.metadata.imageLength,l=this.metadata.tileWidth,h=this.metadata.tileLength,c=Math.ceil(o/l),d=0;d<a;d++)for(var f=0;f<o;f++){var p=Math.floor(f/l),m=Math.floor(d/h),g=m*c+p,b=f%l,y=d%h,_=y*l+b,E=s[g][_];t.push(E)}if(this.metadata.sampleFormat)var v=this.metadata.sampleFormat[0];else var v=u.SampleFormat.UNSIGNED;switch(n){case 8:e=v===u.SampleFormat.SIGNED?new Int8Array(t):new Uint8Array(t);break;case 16:e=v===u.SampleFormat.SIGNED?new Int16Array(t):new Uint16Array(t);break;case 32:e=v===u.SampleFormat.SIGNED?new Int32Array(t):v===u.SampleFormat.IEEE_FLOAT?new Float32Array(t):new Uint32Array(t);break;case 64:e=new Float64Array(t)}return e},f.prototype.parseStrips=function(e){var t=this.metadata.samplesPerPixel,n=this.metadata.bitsPerSample,r=this.metadata.stripOffsets,i=this.metadata.stripByteCounts,s=this.metadata.compression;if(this.metadata.sampleFormat)var o=this.metadata.sampleFormat;else var o=u.SampleFormat.UNSIGNED;for(var a=t*n[0],l=a/8,h=[],c=0;c<r.length;c++){var d=r[c],f=i[c];h[c]=this.parseBlock(e,s,l,f,d,n,o)}return h},f.prototype.parseBlock=function(e,t,n,r,i,o,a){var h=[];switch(t){case u.Compression.UNCOMPRESSED:for(var c=0,d=n;c<r;c+=d){for(var f=0,p=[];f<o.length;f++){var m=o[f]/8,g=f*m;p.push(s.getSampleBytes(this.geoTiffData,i+c+g,m,a[f],this.isLittleEndian))}e?h.push(p[0]):h.push(p)}break;case u.Compression.CCITT_1D:l.log(l.LEVEL_WARNING,"Compression type not yet implemented: CCITT_1D");break;case u.Compression.GROUP_3_FAX:l.log(l.LEVEL_WARNING,"Compression type not yet implemented: GROUP_3_FAX");break;case u.Compression.GROUP_4_FAX:l.log(l.LEVEL_WARNING,"Compression type not yet implemented: GROUP_4_FAX");break;case u.Compression.LZW:l.log(l.LEVEL_WARNING,"Compression type not yet implemented: LZW");break;case u.Compression.JPEG:l.log(l.LEVEL_WARNING,"Compression type not yet implemented: JPEG");break;case u.Compression.PACK_BITS:if(this.metadata.tileOffsets)var b=this.metadata.tileWidth,y=this.metadata.tileWidth,_=new ArrayBuffer(b*y*n);else var E=this.metadata.rowsPerStrip,v=this.metadata.imageWidth,_=new ArrayBuffer(E*v*n);for(var w=new DataView(_),S=!0,p=[],T=0,L=0,x=0,c=0;c<r;c+=1)if(S){T=1,L=1,S=!1;var R=this.geoTiffData.getInt8(i+c,this.isLittleEndian);R>=0&&R<=127?T=R+1:R>=-127&&R<=-1?L=1-R:S=!0}else{for(var A=s.getBytes(this.geoTiffData,i+c,1,this.isLittleEndian),C=0;C<L;C++)w.setInt8(x,A),x++;T--,0===T&&(S=!0)}for(var c=0,d=n;c<_.byteLength;c+=d){for(var f=0,p=[];f<o.length;f++){var m=o[f]/8,g=f*m;p.push(s.getSampleBytes(w,c+g,m,a[f],this.isLittleEndian))}e?h.push(p[0]):h.push(p)}}return h},f.prototype.parseTiles=function(e){var t=this.metadata.samplesPerPixel,n=this.metadata.bitsPerSample,r=this.metadata.compression;if(this.metadata.sampleFormat)var i=this.metadata.sampleFormat;else{var i=new Array(t);d.fillArray(i,u.SampleFormat.UNSIGNED)}for(var s=t*n[0],o=s/8,a=this.metadata.tileWidth,l=this.metadata.tileLength,h=this.metadata.tileOffsets,c=this.metadata.tileByteCounts,f=this.metadata.imageLength,p=this.metadata.imageWidth,m=Math.ceil(p/a),g=Math.ceil(f/l),b=[],y=0;y<g;y++)for(var _=0;_<m;_++){var E=m*y+_,v=h[E],w=c[E];b[E]=this.parseBlock(e,r,o,w,v,n,i)}return b},f.prototype.geoTiffImageToPCS=function(e,n){if(null===e||void 0===e)throw new t(l.logMessage(l.LEVEL_SEVERE,"GeoTiffReader","geoTiffImageToPCS","missingXValue"));if(null===n||void 0===n)throw new t(l.logMessage(l.LEVEL_SEVERE,"GeoTiffReader","geoTiffImageToPCS","missingYValue"));var r=[e,n],i=this.metadata.modelTiepoint,s=this.metadata.modelPixelScale,a=this.metadata.modelTransformation,u=i?i.length:0,c=s?s.length:0,d=a?a.length:0;if(u>6&&0===c);else if(16===d){var f=e,p=n;e=f*a[0]+p*a[1]+a[3],n=f*a[4]+p*a[5]+a[7],r=[e,n]}else c<3||u<6?r=[e,n]:(e=(e-i[0])*s[0]+i[3],n=(n-i[1])*(-1*s[1])+i[4],r=[e,n]);return h.defs([["EPSG:26771","+proj=tmerc +lat_0=36.66666666666666 +lon_0=-88.33333333333333 +k=0.9999749999999999 +x_0=152400.3048006096 +y_0=0 +ellps=clrk66 +datum=NAD27 +to_meter=0.3048006096012192 +no_defs "],["EPSG:32633","+proj=utm +zone=33 +datum=WGS84 +units=m +no_defs"]]),this.metadata.projectedCSType&&(r=h("EPSG:"+this.metadata.projectedCSType,"EPSG:4326",r)),new o(r[1],r[0])},f.prototype.setBBox=function(){var e=this.geoTiffImageToPCS(0,0),t=this.geoTiffImageToPCS(this.metadata.imageWidth,0),n=this.geoTiffImageToPCS(0,this.metadata.imageLength);this.geoTiffImageToPCS(this.metadata.imageWidth,this.metadata.imageLength);this.metadata.bbox=new a(n.latitude,e.latitude,e.longitude,t.longitude)},f.prototype.getMetadataFromImageFileDirectory=function(){for(var e=0;e<this.imageFileDirectories[0].length;e++)switch(this.imageFileDirectories[0][e].tag){case u.Tag.BITS_PER_SAMPLE:this.metadata.bitsPerSample=this.imageFileDirectories[0][e].getIFDEntryValue();break;case u.Tag.COLOR_MAP:this.metadata.colorMap=this.imageFileDirectories[0][e].getIFDEntryValue();break;case u.Tag.COMPRESSION:this.metadata.compression=this.imageFileDirectories[0][e].getIFDEntryValue()[0];break;case u.Tag.EXTRA_SAMPLES:this.metadata.extraSamples=this.imageFileDirectories[0][e].getIFDEntryValue();break;case u.Tag.IMAGE_DESCRIPTION:this.metadata.imageDescription=this.imageFileDirectories[0][e].getIFDEntryValue()[0];break;case u.Tag.IMAGE_LENGTH:this.metadata.imageLength=this.imageFileDirectories[0][e].getIFDEntryValue()[0];break;case u.Tag.IMAGE_WIDTH:this.metadata.imageWidth=this.imageFileDirectories[0][e].getIFDEntryValue()[0];break;case u.Tag.MAX_SAMPLE_VALUE:this.metadata.maxSampleValue=this.imageFileDirectories[0][e].getIFDEntryValue()[0];break;case u.Tag.MIN_SAMPLE_VALUE:this.metadata.minSampleValue=this.imageFileDirectories[0][e].getIFDEntryValue()[0];break;case u.Tag.ORIENTATION:this.metadata.orientation=this.imageFileDirectories[0][e].getIFDEntryValue()[0];break;case u.Tag.PHOTOMETRIC_INTERPRETATION:this.metadata.photometricInterpretation=this.imageFileDirectories[0][e].getIFDEntryValue()[0];break;case u.Tag.PLANAR_CONFIGURATION:this.metadata.planarConfiguration=this.imageFileDirectories[0][e].getIFDEntryValue()[0];break;case u.Tag.ROWS_PER_STRIP:this.metadata.rowsPerStrip=this.imageFileDirectories[0][e].getIFDEntryValue()[0];break;case u.Tag.RESOLUTION_UNIT:this.metadata.resolutionUnit=this.imageFileDirectories[0][e].getIFDEntryValue()[0];break;case u.Tag.SAMPLES_PER_PIXEL:this.metadata.samplesPerPixel=this.imageFileDirectories[0][e].getIFDEntryValue()[0];break;case u.Tag.SAMPLE_FORMAT:this.metadata.sampleFormat=this.imageFileDirectories[0][e].getIFDEntryValue();break;case u.Tag.SOFTWARE:this.metadata.software=this.imageFileDirectories[0][e].getIFDEntryValue();break;case u.Tag.STRIP_BYTE_COUNTS:this.metadata.stripByteCounts=this.imageFileDirectories[0][e].getIFDEntryValue();break;case u.Tag.STRIP_OFFSETS:this.metadata.stripOffsets=this.imageFileDirectories[0][e].getIFDEntryValue();break;case u.Tag.TILE_BYTE_COUNTS:this.metadata.tileByteCounts=this.imageFileDirectories[0][e].getIFDEntryValue();break;case u.Tag.TILE_OFFSETS:this.metadata.tileOffsets=this.imageFileDirectories[0][e].getIFDEntryValue();break;case u.Tag.TILE_LENGTH:this.metadata.tileLength=this.imageFileDirectories[0][e].getIFDEntryValue();break;case u.Tag.TILE_WIDTH:this.metadata.tileWidth=this.imageFileDirectories[0][e].getIFDEntryValue();break;case u.Tag.X_RESOLUTION:this.metadata.xResolution=this.imageFileDirectories[0][e].getIFDEntryValue();break;case u.Tag.Y_RESOLUTION:this.metadata.tileWidth=this.imageFileDirectories[0][e].getIFDEntryValue();break;case n.Tag.GEO_ASCII_PARAMS:this.metadata.geoAsciiParams=this.imageFileDirectories[0][e].getIFDEntryValue();break;case n.Tag.GEO_DOUBLE_PARAMS:this.metadata.geoDubleParams=this.imageFileDirectories[0][e].getIFDEntryValue();break;case n.Tag.GEO_KEY_DIRECTORY:this.metadata.geoKeyDirectory=this.imageFileDirectories[0][e].getIFDEntryValue();break;case n.Tag.MODEL_PIXEL_SCALE:this.metadata.modelPixelScale=this.imageFileDirectories[0][e].getIFDEntryValue();break;case n.Tag.MODEL_TIEPOINT:this.metadata.modelTiepoint=this.imageFileDirectories[0][e].getIFDEntryValue();break
;case n.Tag.GDAL_METADATA:this.metadata.metaData=this.imageFileDirectories[0][e].getIFDEntryValue();break;case n.Tag.GDAL_NODATA:this.metadata.noData=this.imageFileDirectories[0][e].getIFDEntryValue();break;default:l.log(l.LEVEL_WARNING,"Ignored GeoTiff tag: "+this.imageFileDirectories[0][e].tag)}},f.prototype.parseGeoKeys=function(){if(!this.isGeoTiff())throw new e(l.logMessage(l.LEVEL_SEVERE,"GeoTiffReader","parse","invalidGeoTiffFile"));var t=this.metadata.geoKeyDirectory;if(!t)throw new e(l.logMessage(l.LEVEL_SEVERE,"GeoTiffReader","parseGeoKeys","missingGeoKeyDirectoryTag"));for(var i=(t[0],t[1],t[2],t[3]),s=0;s<i;s++){var o=t[4+4*s],a=t[5+4*s],h=t[6+4*s],u=t[7+4*s];switch(o){case n.Key.GTModelTypeGeoKey:this.metadata.gtModelTypeGeoKey=new r(o,a,h,u).getGeoKeyValue(this.metadata.geoDoubleParams,this.metadata.geoAsciiParams);break;case n.Key.GTRasterTypeGeoKey:this.metadata.gtRasterTypeGeoKey=new r(o,a,h,u).getGeoKeyValue(this.metadata.geoDoubleParams,this.metadata.geoAsciiParams);break;case n.Key.GTCitationGeoKey:this.metadata.gtCitationGeoKey=new r(o,a,h,u).getGeoKeyValue(this.metadata.geoDoubleParams,this.metadata.geoAsciiParams);break;case n.Key.GeographicTypeGeoKey:this.metadata.geographicTypeGeoKey=new r(o,a,h,u).getGeoKeyValue(this.metadata.geoDoubleParams,this.metadata.geoAsciiParams);break;case n.Key.GeogCitationGeoKey:this.metadata.geogCitationGeoKey=new r(o,a,h,u).getGeoKeyValue(this.metadata.geoDoubleParams,this.metadata.geoAsciiParams);break;case n.Key.GeogAngularUnitsGeoKey:this.metadata.geogAngularUnitsGeoKey=new r(o,a,h,u).getGeoKeyValue(this.metadata.geoDoubleParams,this.metadata.geoAsciiParams);break;case n.Key.GeogAngularUnitSizeGeoKey:this.metadata.geogAngularUnitSizeGeoKey=new r(o,a,h,u).getGeoKeyValue(this.metadata.geoDoubleParams,this.metadata.geoAsciiParams);break;case n.Key.GeogSemiMajorAxisGeoKey:this.metadata.geogSemiMajorAxisGeoKey=new r(o,a,h,u).getGeoKeyValue(this.metadata.geoDoubleParams,this.metadata.geoAsciiParams);break;case n.Key.GeogInvFlatteningGeoKey:this.metadata.geogInvFlatteningGeoKey=new r(o,a,h,u).getGeoKeyValue(this.metadata.geoDoubleParams,this.metadata.geoAsciiParams);break;case n.Key.ProjectedCSTypeGeoKey:this.metadata.projectedCSType=new r(o,a,h,u).getGeoKeyValue(this.metadata.geoDoubleParams,this.metadata.geoAsciiParams);break;case n.Key.ProjLinearUnitsGeoKey:this.metadata.projLinearUnits=new r(o,a,h,u).getGeoKeyValue(this.metadata.geoDoubleParams,this.metadata.geoAsciiParams);break;default:l.log(l.LEVEL_WARNING,"Ignored GeoTiff key: "+o)}}},f.prototype.parseImageFileDirectory=function(e){if(!e)throw new t(l.logMessage(l.LEVEL_SEVERE,"GeoTiffReader","parseImageFileDirectory","missingOffset"));for(var n=s.getBytes(this.geoTiffData,e,2,this.isLittleEndian),r=[],i=e+2,o=0;o<n;i+=12,o++){var a=s.getBytes(this.geoTiffData,i,2,this.isLittleEndian),h=s.getBytes(this.geoTiffData,i+2,2,this.isLittleEndian),u=s.getBytes(this.geoTiffData,i+4,4,this.isLittleEndian),d=s.getBytes(this.geoTiffData,i+8,4,this.isLittleEndian);r.push(new c(a,h,u,d,this.geoTiffData,this.isLittleEndian))}this._imageFileDirectories.push(r);var f=s.getBytes(this.geoTiffData,i,4,this.isLittleEndian);0!==f&&this.parseImageFileDirectory(f)},f.prototype.getIFDByTag=function(e){if(!e)throw new t(l.logMessage(l.LEVEL_SEVERE,"GeoTiffReader","getIFDByTag","missingTag"));for(var n=0;n<this.imageFileDirectories[0].length;n++)if(this.imageFileDirectories[0][n].tag===e)return this.imageFileDirectories[0][n];return null},f}),define("util/Level",["../geom/Angle","../error/ArgumentError","../geom/Location","../util/Logger"],function(e,t,n,r){"use strict";var i=function(n,i,s){if(!i)throw new t(r.logMessage(r.LEVEL_SEVERE,"Level","constructor","The specified tile delta is null or undefined"));if(!s)throw new t(r.logMessage(r.LEVEL_SEVERE,"Level","constructor","The specified parent level set is null or undefined"));this.levelNumber=n,this.tileDelta=i,this.parent=s,this.texelSize=i.latitude*e.DEGREES_TO_RADIANS/s.tileHeight,this.tileWidth=s.tileWidth,this.tileHeight=s.tileHeight,this.sector=s.sector};return i.prototype.isFirstLevel=function(){return this.parent.firstLevel()==this},i.prototype.isLastLevel=function(){return this.parent.lastLevel()==this},i.prototype.previousLevel=function(){return this.parent.level(this.levelNumber-1)},i.prototype.nextLevel=function(){return this.parent.level(this.levelNumber+1)},i.prototype.compare=function(e){if(!e)throw new t(r.logMessage(r.LEVEL_SEVERE,"Level","compare","The specified level is null or undefined"));return this.levelNumber<e.levelNumber?-1:this.levelNumber>e.levelNumber?1:0},i}),define("util/LevelSet",["../error/ArgumentError","../util/Level","../geom/Location","../util/Logger"],function(e,t,n,r){"use strict";var i=function(i,s,o,a,l){if(!i)throw new e(r.logMessage(r.LEVEL_SEVERE,"LevelSet","constructor","missingSector"));if(!s)throw new e(r.logMessage(r.LEVEL_SEVERE,"LevelSet","constructor","The specified level zero delta is null or undefined"));if(s.latitude<=0||s.longitude<=0)throw new e(r.logMessage(r.LEVEL_SEVERE,"LevelSet","constructor","The specified level zero delta is less than or equal to zero."));if(o<1)throw new e(r.logMessage(r.LEVEL_SEVERE,"LevelSet","constructor","The specified number of levels is less than one."));if(a<1||l<1)throw new e(r.logMessage(r.LEVEL_SEVERE,"LevelSet","constructor","The specified tile width or tile height is less than one."));this.sector=i,this.levelZeroDelta=s,this.numLevels=o,this.tileWidth=a,this.tileHeight=l,this.levels=[];for(var h=0;h<o;h+=1){var u=Math.pow(2,h),c=s.latitude/u,d=s.longitude/u,f=new n(c,d),p=new t(h,f,this);this.levels[h]=p}};return i.numLevelsForResolution=function(t,n){if(!t||!n)throw new e(r.logMessage(r.LEVEL_SEVERE,"LevelSet","numLevelsForResolution","missingResolution"));var i=Math.log(t/n)/Math.log(2);return i<0&&(i=0),i+1},i.prototype.level=function(e){return e<0||e>=this.levels.length?null:this.levels[e]},i.prototype.levelForTexelSize=function(e){var t=this.lastLevel();if(t.texelSize>=e)return t;for(var n=0,r=this.levels.length;n<r;n+=1){var i=this.levels[n];if(i.texelSize<=e)return i}return t},i.prototype.firstLevel=function(){return this.levels[0]},i.prototype.lastLevel=function(){return this.levels[this.levels.length-1]},i}),define("cache/MemoryCache",["../error/ArgumentError","../util/Logger"],function(e,t){"use strict";var n=function(n,r){if(!n||n<1)throw new e(t.logMessage(t.LEVEL_SEVERE,"MemoryCache","constructor","The specified capacity is undefined, zero or negative"));if(!r||r>=n||r<0)throw new e(t.logMessage(t.LEVEL_SEVERE,"MemoryCache","constructor","The specified low-water value is undefined, greater than or equal to the capacity, or less than 1"));this._capacity=n,this._lowWater=r,this.usedCapacity=0,this.freeCapacity=n,this.entries={},this.listeners=[]};return Object.defineProperties(n.prototype,{capacity:{get:function(){return this._capacity},set:function(n){if(!n||n<1)throw new e(t.logMessage(t.LEVEL_SEVERE,"MemoryCache","capacity","Specified cache capacity is undefined, 0 or negative."));var r=this._capacity;this._capacity=n,this._capacity<=this.lowWater&&(this._lowWater=.85*this._capacity),this._capacity<r&&this.makeSpace(0)}},lowWater:{get:function(){return this._lowWater},set:function(n){if(!n||n>=this._capacity||n<0)throw new e(t.logMessage(t.LEVEL_SEVERE,"MemoryCache","lowWater","Specified cache low-water value is undefined, negative or not less than the current capacity."));this._lowWater=n}}}),n.prototype.entryForKey=function(e){if(!e)return null;var t=this.entries[e];return t?(t.lastUsed=Date.now(),t.entry):null},n.prototype.putEntry=function(n,r,i){if(!n)throw new e(t.logMessage(t.LEVEL_SEVERE,"MemoryCache","putEntry","missingKey."));if(!r)throw new e(t.logMessage(t.LEVEL_SEVERE,"MemoryCache","putEntry","missingEntry."));if(i<1)throw new e(t.logMessage(t.LEVEL_SEVERE,"MemoryCache","putEntry","The specified entry size is less than 1."));var s,o=this.entries[n];o&&this.removeEntry(n),this.usedCapacity+i>this._capacity&&this.makeSpace(i),this.usedCapacity+=i,this.freeCapacity=this._capacity-this.usedCapacity,s={key:n,entry:r,size:i,lastUsed:Date.now(),agingFactor:1},this.entries[n]=s},n.prototype.clear=function(e){if(e)for(var t in this.entries)this.entries.hasOwnProperty(t)&&this.removeCacheEntry(t);this.entries={},this.freeCapacity=this._capacity,this.usedCapacity=0},n.prototype.removeEntry=function(e){if(e){var t=this.entries[e];t&&this.removeCacheEntry(t)}},n.prototype.setEntryAgingFactor=function(e,t){if(e){var n=this.entries[e];n&&(n.agingFactor=t)}},n.prototype.removeCacheEntry=function(e){delete this.entries[e.key],this.usedCapacity-=e.size,this.freeCapacity=this._capacity-this.usedCapacity;for(var t=0,n=this.listeners.length;t<n;t++)try{this.listeners[t].entryRemoved(e.key,e.entry)}catch(n){this.listeners[t].removalError(n,e.key,e.entry)}},n.prototype.containsKey=function(e){return e&&this.entries[e]},n.prototype.addCacheListener=function(n){if(!n)throw new e(t.logMessage(t.LEVEL_SEVERE,"MemoryCache","addCacheListener","missingListener"));if("function"!=typeof n.entryRemoved||"function"!=typeof n.removalError)throw new e(t.logMessage(t.LEVEL_SEVERE,"MemoryCache","addCacheListener","The specified listener does not implement the required functions."));this.listeners.push(n)},n.prototype.removeCacheListener=function(n){if(!n)throw new e(t.logMessage(t.LEVEL_SEVERE,"MemoryCache","removeCacheListener","missingListener"));var r=this.listeners.indexOf(n);r>-1&&this.listeners.splice(r,1)},n.prototype.makeSpace=function(e){var t=[],n=Date.now();for(var r in this.entries)this.entries.hasOwnProperty(r)&&t.push(this.entries[r]);t.sort(function(e,t){var r=(n-e.lastUsed)*e.agingFactor;return(n-t.lastUsed)*t.agingFactor-r});for(var i=0,s=t.length;i<s&&(this.usedCapacity>this._lowWater||this.freeCapacity<e);i++)this.removeCacheEntry(t[i])},n}),define("shaders/BasicProgram",["../error/ArgumentError","../util/Color","../shaders/GpuProgram","../util/Logger"],function(e,t,n,r){"use strict";var i=function(e){n.call(this,e,"attribute vec4 vertexPoint;\nuniform mat4 mvpMatrix;\nvoid main() {gl_Position = mvpMatrix * vertexPoint;}","precision mediump float;\nuniform vec4 color;\nvoid main() {gl_FragColor = color;}"),this.vertexPointLocation=this.attributeLocation(e,"vertexPoint"),this.mvpMatrixLocation=this.uniformLocation(e,"mvpMatrix"),this.colorLocation=this.uniformLocation(e,"color")};return i.key="WorldWindGpuBasicProgram",i.prototype=Object.create(n.prototype),i.prototype.loadModelviewProjection=function(t,n){if(!n)throw new e(r.logMessage(r.LEVEL_SEVERE,"BasicProgram","loadModelviewProjection","missingMatrix"));this.loadUniformMatrix(t,n,this.mvpMatrixLocation)},i.prototype.loadColor=function(t,n){if(!n)throw new e(r.logMessage(r.LEVEL_SEVERE,"BasicProgram","loadColor","missingColor"));this.loadUniformColor(t,n,this.colorLocation)},i.prototype.loadColorComponents=function(e,t,n,r,i){this.loadUniformColorComponents(e,t,n,r,i,this.colorLocation)},i}),define("geom/Frustum",["../error/ArgumentError","../geom/Matrix","../geom/Plane","../util/Logger"],function(e,t,n,r){"use strict";var i=function(t,n,i,s,o,a){if(!(t&&n&&i&&s&&o&&a))throw new e(r.logMessage(r.LEVEL_SEVERE,"Frustum","constructor","missingPlane"));this._left=t,this._right=n,this._bottom=i,this._top=s,this._near=o,this._far=a,this._planes=[this._left,this._right,this._top,this._bottom,this._near,this._far]};return Object.defineProperties(i.prototype,{left:{get:function(){return this._left}},right:{get:function(){return this._right}},bottom:{get:function(){return this._bottom}},top:{get:function(){return this._top}},near:{get:function(){return this._near}},far:{get:function(){return this._far}}}),i.prototype.transformByMatrix=function(t){if(!t)throw new e(r.logMessage(r.LEVEL_SEVERE,"Frustum","transformByMatrix","missingMatrix"));return this._left.transformByMatrix(t),this._right.transformByMatrix(t),this._bottom.transformByMatrix(t),this._top.transformByMatrix(t),this._near.transformByMatrix(t),this._far.transformByMatrix(t),this},i.prototype.normalize=function(){return this._left.normalize(),this._right.normalize(),this._bottom.normalize(),this._top.normalize(),this._near.normalize(),this._far.normalize(),this},i.unitFrustum=function(){return new i(new n(1,0,0,1),new n(-1,0,0,1),new n(0,1,1,1),new n(0,-1,0,1),new n(0,0,-1,1),new n(0,0,1,1))},i.fromProjectionMatrix=function(t){if(!t)throw new e(r.logMessage(r.LEVEL_SEVERE,"Frustum","fromProjectionMatrix","missingMatrix"));var s,o,a,l,h,u,c,d,f,p,m;return s=t[12]+t[0],o=t[13]+t[1],a=t[14]+t[2],l=t[15]+t[3],h=Math.sqrt(s*s+o*o+a*a),u=new n(s/h,o/h,a/h,l/h),s=t[12]-t[0],o=t[13]-t[1],a=t[14]-t[2],l=t[15]-t[3],h=Math.sqrt(s*s+o*o+a*a),c=new n(s/h,o/h,a/h,l/h),s=t[12]+t[4],o=t[13]+t[5],a=t[14]+t[6],l=t[15]+t[7],h=Math.sqrt(s*s+o*o+a*a),f=new n(s/h,o/h,a/h,l/h),s=t[12]-t[4],o=t[13]-t[5],a=t[14]-t[6],l=t[15]-t[7],h=Math.sqrt(s*s+o*o+a*a),d=new n(s/h,o/h,a/h,l/h),s=t[12]+t[8],o=t[13]+t[9],a=t[14]+t[10],l=t[15]+t[11],h=Math.sqrt(s*s+o*o+a*a),p=new n(s/h,o/h,a/h,l/h),s=t[12]-t[8],o=t[13]-t[9],a=t[14]-t[10],l=t[15]-t[11],h=Math.sqrt(s*s+o*o+a*a),m=new n(s/h,o/h,a/h,l/h),new i(u,c,f,d,p,m)},i.prototype.containsPoint=function(t){if(!t)throw new e(r.logMessage(r.LEVEL_SEVERE,"Frustum","containsPoint","missingPoint"));return!(this._far.dot(t)<=0)&&(!(this._left.dot(t)<=0)&&(!(this._right.dot(t)<=0)&&(!(this._top.dot(t)<=0)&&(!(this._bottom.dot(t)<=0)&&!(this._near.dot(t)<=0)))))},i.prototype.intersectsSegment=function(t,n){if(!t||!n)throw new e(r.logMessage(r.LEVEL_SEVERE,"Frustum","containsPoint","missingPoint"));if(this.containsPoint(t)||this.containsPoint(n))return!0;if(t.equals(n))return!1;for(var i=0,s=this._planes.length;i<s;i++){if(this._planes[i].onSameSide(t,n)<0)return!1;if(null!=this._planes[i].clip(t,n))return!0}return!1},i}),define("error/NotYetImplementedError",["../error/AbstractError"],function(e){"use strict";var t=function(t){e.call(this,"NotYetImplementedError",t);var n;try{throw new Error}catch(e){n=e.stack}this.stack=n};return t.prototype=Object.create(e.prototype),t}),define("geom/BoundingBox",["../error/ArgumentError","../shaders/BasicProgram","../geom/Frustum","../util/Logger","../geom/Matrix","../error/NotYetImplementedError","../geom/Plane","../geom/Sector","../geom/Vec3","../util/WWMath","../util/WWUtil"],function(e,t,n,r,i,s,o,a,l,h,u){"use strict";var c=function(){this.center=new l(0,0,0),this.bottomCenter=new l(-.5,0,0),this.topCenter=new l(.5,0,0),this.r=new l(1,0,0),this.s=new l(0,1,0),this.t=new l(0,0,1),this.radius=Math.sqrt(3),this.tmp1=new l(0,0,0),this.tmp2=new l(0,0,0),this.tmp3=new l(0,0,0),this.scratchElevations=new Float64Array(9),this.scratchPoints=new Float64Array(3*this.scratchElevations.length)};return c.scratchMatrix=i.fromIdentity(),c.prototype.getCorners=function(){var e=new l(this.s[0],this.s[1],this.s[2]),t=new l(this.t[0],this.t[1],this.t[2]),n=new l(this.s[0],this.s[1],this.s[2]),r=new l(this.s[0],this.s[1],this.s[2]);e.add(this.t).multiply(-.5),t.subtract(this.s).multiply(.5),n.add(this.t).multiply(.5),r.subtract(this.t).multiply(.5);for(var i=[],s=0;s<4;s++)i.push(new l(this.bottomCenter[0],this.bottomCenter[1],this.bottomCenter[2]));for(s=0;s<4;s++)i.push(new l(this.topCenter[0],this.topCenter[1],this.topCenter[2]));return i[0].add(e),i[1].add(t),i[2].add(n),i[3].add(r),i[4].add(e),i[5].add(t),i[6].add(n),i[7].add(r),i},c.prototype.setToPoints=function(t){if(!t||t.length<3)throw new e(r.logMessage(r.LEVEL_SEVERE,"BoundingBox","setToPoints","missingArray"));var n,s,o,a,h,u,c,d,f,p,m,g,b,y,_,E=+Number.MAX_VALUE,v=-Number.MAX_VALUE,w=+Number.MAX_VALUE,S=-Number.MAX_VALUE,T=+Number.MAX_VALUE,L=-Number.MAX_VALUE,x=this.r,R=this.s,A=this.t,C=new l(0,0,0);i.principalAxesFromPoints(t,x,R,A);for(var M=0,k=t.length/3;M<k;M++)C[0]=t[3*M],C[1]=t[3*M+1],C[2]=t[3*M+2],n=C.dot(x),E>n&&(E=n),v<n&&(v=n),s=C.dot(R),w>s&&(w=s),S<s&&(S=s),o=C.dot(A),T>o&&(T=o),L<o&&(L=o);return v===E&&(v=E+1),S===w&&(S=w+1),L===T&&(L=T+1),a=v-E,h=S-w,u=L-T,c=v+E,d=S+w,f=L+T,p=.5*x[0]*a,m=.5*x[1]*a,g=.5*x[2]*a,b=.5*(x[0]*c+R[0]*d+A[0]*f),y=.5*(x[1]*c+R[1]*d+A[1]*f),_=.5*(x[2]*c+R[2]*d+A[2]*f),this.center[0]=b,this.center[1]=y,this.center[2]=_,this.topCenter[0]=b+p,this.topCenter[1]=y+m,this.topCenter[2]=_+g,this.bottomCenter[0]=b-p,this.bottomCenter[1]=y-m,this.bottomCenter[2]=_-g,x.multiply(a),R.multiply(h),A.multiply(u),this.radius=.5*Math.sqrt(a*a+h*h+u*u),this},c.prototype.setToVec3Points=function(t){if(!t||0===t.length)throw new e(r.logMessage(r.LEVEL_SEVERE,"BoundingBox","setToVec3Points","missingArray"));for(var n=new Float32Array(3*t.length),i=0;i<t.length;i++)for(var s=t[i],o=0;o<3;o++)n[3*i+o]=s[o];return this.setToPoints(n)},c.prototype.setToSector=function(t,n,i,s){if(!t)throw new e(r.logMessage(r.LEVEL_SEVERE,"BoundingBox","setToSector","missingSector"));if(!n)throw new e(r.logMessage(r.LEVEL_SEVERE,"BoundingBox","setToSector","missingGlobe"));var o=this.scratchElevations,a=this.scratchPoints;u.fillArray(o,s),o[0]=o[2]=o[6]=o[8]=i,n.computePointsForGrid(t,3,3,o,l.ZERO,a);this.tmp1.set(a[12],a[13],a[14]),h.localCoordinateAxesAtPoint(this.tmp1,n,this.r,this.s,this.t);for(var c=[Number.POSITIVE_INFINITY,Number.NEGATIVE_INFINITY],d=[Number.POSITIVE_INFINITY,Number.NEGATIVE_INFINITY],f=[Number.POSITIVE_INFINITY,Number.NEGATIVE_INFINITY],p=0,m=a.length;p<m;p+=3)this.tmp1.set(a[p],a[p+1],a[p+2]),this.adjustExtremes(this.r,c,this.s,d,this.t,f,this.tmp1);t.deltaLongitude()>180&&(n.computePointFromPosition(t.centroidLatitude(),t.centroidLongitude()+90,s,this.tmp1),n.computePointFromPosition(t.centroidLatitude(),t.centroidLongitude()-90,s,this.tmp2),this.adjustExtremes(this.r,c,this.s,d,this.t,f,this.tmp1),this.adjustExtremes(this.r,c,this.s,d,this.t,f,this.tmp2)),c[1]-c[0]<d[1]-d[0]&&this.swapAxes(this.r,c,this.s,d),d[1]-d[0]<f[1]-f[0]&&this.swapAxes(this.s,d,this.t,f),c[1]-c[0]<d[1]-d[0]&&this.swapAxes(this.r,c,this.s,d);var g=c[1]-c[0],b=d[1]-d[0],y=f[1]-f[0],_=c[1]+c[0],E=d[1]+d[0],v=f[1]+f[0],w=.5*(this.r[0]*_+this.s[0]*E+this.t[0]*v),S=.5*(this.r[1]*_+this.s[1]*E+this.t[1]*v),T=.5*(this.r[2]*_+this.s[2]*E+this.t[2]*v),L=.5*this.r[0]*g,x=.5*this.r[1]*g,R=.5*this.r[2]*g;return this.center.set(w,S,T),this.topCenter.set(w+L,S+x,T+R),this.bottomCenter.set(w-L,S-x,T-R),this.r.multiply(g),this.s.multiply(b),this.t.multiply(y),this.radius=.5*Math.sqrt(g*g+b*b+y*y),this},c.prototype.translate=function(t){if(!t)throw new e(r.logMessage(r.LEVEL_SEVERE,"BoundingBox","translate","missingVector"));return this.bottomCenter.add(t),this.topCenter.add(t),this.center.add(t),this},c.prototype.distanceTo=function(t){if(!t)throw new e(r.logMessage(r.LEVEL_SEVERE,"BoundingBox","distanceTo","missingPoint"));var n=this.center.distanceTo(t)-this.radius;return n>=0?n:-n},c.prototype.effectiveRadius=function(t){if(!t)throw new e(r.logMessage(r.LEVEL_SEVERE,"BoundingBox","effectiveRadius","missingPlane"));var n=t.normal;return.5*(h.fabs(this.r.dot(n))+h.fabs(this.s.dot(n))+h.fabs(this.t.dot(n)))},c.prototype.intersectsFrustum=function(t){if(!t)throw new e(r.logMessage(r.LEVEL_SEVERE,"BoundingBox","intersectsFrustum","missingFrustum"));return this.tmp1.copy(this.bottomCenter),this.tmp2.copy(this.topCenter),!(this.intersectionPoint(t.near)<0)&&(!(this.intersectionPoint(t.far)<0)&&(!(this.intersectionPoint(t.left)<0)&&(!(this.intersectionPoint(t.right)<0)&&(!(this.intersectionPoint(t.top)<0)&&!(this.intersectionPoint(t.bottom)<0)))))},c.prototype.intersectionPoint=function(e){var t=e.normal,n=.5*(Math.abs(this.s.dot(t))+Math.abs(this.t.dot(t)));return this.intersectsAt(e,n,this.tmp1,this.tmp2)},c.prototype.intersectsAt=function(e,t,n,r){var i=e.dot(n),s=i<=-t,o=e.dot(r),a=o<=-t;if(s&&a)return-1;if(s==a)return 0;this.tmp3.copy(n),this.tmp3.subtract(r);var l=(t+i)/e.normal.dot(this.tmp3);return this.tmp3.copy(r),this.tmp3.subtract(n),this.tmp3.multiply(l),this.tmp3.add(n),s?n.copy(this.tmp3):r.copy(this.tmp3),l},c.prototype.adjustExtremes=function(e,t,n,r,i,s,o){var a=o.dot(e);t[0]>a&&(t[0]=a),t[1]<a&&(t[1]=a);var l=o.dot(n);r[0]>l&&(r[0]=l),r[1]<l&&(r[1]=l);var h=o.dot(i);s[0]>h&&(s[0]=h),s[1]<h&&(s[1]=h)},c.prototype.swapAxes=function(e,t,n,r){e.swap(n);var i=t[0];t[0]=r[0],r[0]=i,i=t[1],t[1]=r[1],r[1]=i},c.prototype.render=function(e){var n=e.currentGlContext,r=c.scratchMatrix,i=e.findAndBindProgram(t);try{r.copy(e.modelviewProjection),r.multiply(this.r[0],this.s[0],this.t[0],this.center[0],this.r[1],this.s[1],this.t[1],this.center[1],this.r[2],this.s[2],this.t[2],this.center[2],0,0,0,1),r.multiplyByTranslation(-.5,-.5,-.5),i.loadModelviewProjection(n,r),n.disable(n.CULL_FACE),n.bindBuffer(n.ARRAY_BUFFER,e.unitCubeBuffer()),n.bindBuffer(n.ELEMENT_ARRAY_BUFFER,e.unitCubeElements()),n.enableVertexAttribArray(i.vertexPointLocation),n.vertexAttribPointer(i.vertexPointLocation,3,n.FLOAT,!1,0,0),i.loadColorComponents(n,0,1,0,.6),n.drawElements(n.LINES,24,n.UNSIGNED_SHORT,72),i.loadColorComponents(n,1,1,1,.3),n.drawElements(n.TRIANGLES,36,n.UNSIGNED_SHORT,0)}finally{n.enable(n.CULL_FACE),n.bindBuffer(n.ARRAY_BUFFER,null),n.bindBuffer(n.ELEMENT_ARRAY_BUFFER,null)}},c}),define("util/Tile",["../error/ArgumentError","../geom/BoundingBox","../util/Logger","../geom/Sector","../geom/Vec3","../util/WWUtil"],function(e,t,n,r,i,s){"use strict";var o=function(t,r,i,s){if(!t)throw new e(n.logMessage(n.LEVEL_SEVERE,"Tile","constructor","missingSector"));if(!r)throw new e(n.logMessage(n.LEVEL_SEVERE,"Tile","constructor","The specified level is null or undefined."));if(i<0||s<0)throw new e(n.logMessage(n.LEVEL_SEVERE,"Tile","constructor","The specified row or column is less than zero."));this.sector=t,this.level=r,this.row=i,this.column=s,this.tileWidth=r.tileWidth,this.tileHeight=r.tileHeight,this.texelSize=r.texelSize,this.tileKey=o.computeTileKey(r.levelNumber,i,s),this.extent=null,this.referencePoint=null,this.opacity=1,this.minCellSize=.1,this.updateTimestamp=null,this.updateVerticalExaggeration=null,this.updateGlobeStateKey=null};return o.prototype.isEqual=function(e){return!!e&&(!!e.tileKey&&this.tileKey==e.tileKey)},o.prototype.size=function(){return 828},o.prototype.subdivide=function(t,i){if(!t)throw new e(n.logMessage(n.LEVEL_SEVERE,"Tile","subdivide","The specified level is null or undefined."));if(!i)throw new e(n.logMessage(n.LEVEL_SEVERE,"Tile","subdivide","The specified tile factory is null or undefined."));var s,o,a,l=this.sector.minLatitude,h=this.sector.maxLatitude,u=this.sector.centroidLatitude(),c=this.sector.minLongitude,d=this.sector.maxLongitude,f=this.sector.centroidLongitude(),p=[];return s=2*this.row,o=2*this.column,a=new r(l,u,c,f),p.push(i.createTile(a,t,s,o)),s=2*this.row,o=2*this.column+1,a=new r(l,u,f,d),p.push(i.createTile(a,t,s,o)),s=2*this.row+1,o=2*this.column,a=new r(u,h,c,f),p.push(i.createTile(a,t,s,o)),s=2*this.row+1,o=2*this.column+1,a=new r(u,h,f,d),p.push(i.createTile(a,t,s,o)),p},o.prototype.subdivideToCache=function(t,r,i){if(!t)throw new e(n.logMessage(n.LEVEL_SEVERE,"Tile","subdivideToCache","The specified level is null or undefined."));if(!r)throw new e(n.logMessage(n.LEVEL_SEVERE,"Tile","subdivideToCache","The specified tile factory is null or undefined."));var s=i?i.entryForKey(this.tileKey):null;return s||(s=this.subdivide(t,r))&&i&&i.putEntry(this.tileKey,s,4*s[0].size()),s},o.prototype.mustSubdivide=function(e,t){var n=e.globe.equatorialRadius*this.texelSize,r=this.sector.distanceTo(e,e.eyePoint),i=e.pixelSizeAtDistance(r);return n>Math.max(t*i,this.minCellSize)},o.prototype.update=function(e){var t=e.globe.elevationTimestamp(),n=e.verticalExaggeration,r=e.globeStateKey;this.updateTimestamp==t&&this.updateVerticalExaggeration==n&&this.updateGlobeStateKey==r||(this.doUpdate(e),e.frameStatistics.incrementTileUpdateCount(1),this.updateTimestamp=t,this.updateVerticalExaggeration=n,this.updateGlobeStateKey=r)},o.prototype.doUpdate=function(e){var n=e.globe,r=e.verticalExaggeration,s=n.minAndMaxElevationsForSector(this.sector),o=s[0]*r,a=s[1]*r;o===a&&(o=a+10),this.extent||(this.extent=new t),this.extent.setToSector(this.sector,n,o,a),this.referencePoint||(this.referencePoint=new i(0,0,0)),n.computePointFromPosition(this.sector.centroidLatitude(),this.sector.centroidLongitude(),0,this.referencePoint)},o.computeTileKey=function(e,t,n){return e+"."+t+"."+n},o.computeRow=function(e,t){var n=Math.floor((t+90)/e);return 90==t&&(n-=1),n},o.computeColumn=function(e,t){var n=Math.floor((t+180)/e);return 180==t&&(n-=1),n},o.computeLastRow=function(e,t){var n=Math.ceil((t+90)/e-1);return t+90<e&&(n=0),n},o.computeLastColumn=function(e,t){var n=Math.ceil((t+180)/e-1);return t+180<e&&(n=0),n},o.computeSector=function(t,i,s){if(!t)throw new e(n.logMessage(n.LEVEL_SEVERE,"Tile","computeSector","missingLevel"));if(i<0||s<0)throw new e(n.logMessage(n.LEVEL_SEVERE,"Tile","computeSector","The specified row or column is less than zero."));var o=t.tileDelta.latitude,a=t.tileDelta.longitude,l=i*o-90,h=s*a-180;return new r(l,l+o,h,h+a)},o.createTilesForLevel=function(t,i,s){if(!t)throw new e(n.logMessage(n.LEVEL_SEVERE,"Tile","createTilesForLevel","missingLevel"));if(!i)throw new e(n.logMessage(n.LEVEL_SEVERE,"Tile","createTilesForLevel","The specified tile factory is null or undefined"));if(!s)throw new e(n.logMessage(n.LEVEL_SEVERE,"Tile","createTilesForLevel","missingResult"));for(var a,l,h,u=t.tileDelta.latitude,c=t.tileDelta.longitude,d=t.sector,f=o.computeRow(u,d.minLatitude),p=o.computeRow(u,d.maxLatitude),m=o.computeColumn(c,d.minLongitude),g=o.computeColumn(c,d.maxLongitude),b=f*u-90,y=m*c-180,_=b,E=f;E<=p;E+=1){l=_+u,a=y;for(var v=m;v<=g;v+=1){h=a+c;var w=new r(_,l,a,h),S=i.createTile(w,t,E,v);s.push(S),a=h}_=l}},o}),define("globe/TiledElevationCoverage",["../util/AbsentResourceList","../geom/Angle","../error/ArgumentError","../globe/ElevationCoverage","../globe/ElevationImage","../formats/geotiff/GeoTiffReader","../util/LevelSet","../geom/Location","../util/Logger","../cache/MemoryCache","../geom/Sector","../util/Tile","../util/WWMath"],function(e,t,n,r,i,s,o,a,l,h,u,c,d){"use strict";var f=function(t){if(!t)throw new n(l.logMessage(l.LEVEL_SEVERE,"TiledElevationCoverage","constructor","missingConfig"));if(!t.coverageSector)throw new n(l.logMessage(l.LEVEL_SEVERE,"TiledElevationCoverage","constructor","missingSector"));if(!t.resolution)throw new n(l.logMessage(l.LEVEL_SEVERE,"TiledElevationCoverage","constructor","missingResolution"));if(!t.retrievalImageFormat)throw new n(l.logMessage(l.LEVEL_SEVERE,"TiledElevationCoverage","constructor","missingImageFormat"));r.call(this,t.resolution);var i=o.numLevelsForResolution(45/256,t.resolution),s=Math.ceil(i);this.coverageSector=t.coverageSector,this.retrievalImageFormat=t.retrievalImageFormat,this.minElevation=t.minElevation||0,this.maxElevation=t.maxElevation||0,this.pixelIsPoint=!1,this.levels=new o(this.coverageSector,new a(45,45),s,256,256),this.currentTiles=[],this.currentSector=new u(0,0,0,0),this.tileCache=new h(1e6,8e5),this.imageCache=new h(1e7,8e6),this.retrievalQueueSize=WorldWind.configuration.coverageRetrievalQueueSize,this.currentRetrievals=[],this.absentResourceList=new e(3,5e3),this.urlBuilder=t.urlBuilder||null};return f.prototype=Object.create(r.prototype),f.prototype.minAndMaxElevationsForSector=function(e,r){if(!e)throw new n(l.logMessage(l.LEVEL_SEVERE,"TiledElevationCoverage","minAndMaxElevationsForSector","missingSector"));if(!r)throw new n(l.logMessage(l.LEVEL_SEVERE,"TiledElevationCoverage","minAndMaxElevationsForSector","missingResult"));var i=this.levels.levelForTexelSize(e.deltaLatitude()*t.DEGREES_TO_RADIANS/64);if(this.assembleTiles(i,e,!1),0===this.currentTiles.length)return!1;for(var s=!0,o=0,a=this.currentTiles.length;o<a;o++){var h=this.imageCache.entryForKey(this.currentTiles[o].tileKey);if(h&&h.hasData){var u=h.minElevation;r[0]>u&&(r[0]=u);var c=h.maxElevation;r[1]<c&&(r[1]=c)}h&&h.hasData&&!h.hasMissingData||(s=!1)}return s},f.prototype.elevationAtLocation=function(e,t){return this.coverageSector.containsLocation(e,t)?this.pointElevationForLocation(e,t):null},f.prototype.elevationsForGrid=function(e,r,i,s){if(!e)throw new n(l.logMessage(l.LEVEL_SEVERE,"TiledElevationCoverage","elevationsForGrid","missingSector"));if(!r||!i||r<1||i<1)throw new n(l.logMessage(l.LEVEL_SEVERE,"TiledElevationCoverage","elevationsForGrid","The specified number of latitudinal or longitudinal positions is less than one."));var o=e.deltaLatitude()/(r-1)*t.DEGREES_TO_RADIANS,a=this.levels.levelForTexelSize(o);return this.pixelIsPoint?this.pointElevationsForGrid(e,r,i,a,s):this.areaElevationsForGrid(e,r,i,a,s)},f.prototype.pointElevationForLocation=function(e,t){for(var n,r=this.levels.lastLevel(),i=r.tileDelta.latitude,s=r.tileDelta.longitude,o=c.computeRow(i,e),a=c.computeColumn(s,t),l=null,h=r.levelNumber;h>=0;h--){if(n=c.computeTileKey(h,o,a),l=this.imageCache.entryForKey(n)){var u=l.elevationAtLocation(e,t);return isNaN(u)?null:u}o=Math.floor(o/2),a=Math.floor(a/2)}return null},f.prototype.pointElevationsForGrid=function(e,t,n,r,i){if(this.assembleTiles(r,e,!0),0===this.currentTiles.length)return!1;this.currentTiles.sort(function(e,t){return e.level.levelNumber-t.level.levelNumber});for(var s=0,o=this.currentTiles.length;s<o;s++){var a=this.imageCache.entryForKey(this.currentTiles[s].tileKey);a&&a.elevationsForGrid(e,t,n,i)}return!i.includes(NaN)},f.prototype.areaElevationsForGrid=function(e,t,n,r,i){var s,o,a,l,h,u,c=e.minLatitude,d=e.maxLatitude,f=e.minLongitude,p=e.maxLongitude,m=e.deltaLatitude()/(t>1?t-1:1),g=e.deltaLongitude()/(n>1?n-1:1),b=0;for(h=0,s=c;h<t;h+=1,s+=m)for(h===t-1&&(s=d),u=0,o=f;u<n;u+=1,o+=g)u===n-1&&(o=p),isNaN(i[b])&&this.coverageSector.containsLocation(s,o)&&(a=(o+180)/360,l=(s+90)/180,this.areaElevationForCoord(a,l,r.levelNumber,i,b)),b++;return!i.includes(NaN)},f.prototype.areaElevationForCoord=function(e,t,n,r,s){for(var o,a,l,h,u,c,f,p,m,g,b,y,_,E,v,w,S=new Float64Array(4),T=n;T>=0;T--)if(o=this.levels.level(T),a=Math.round(360*o.tileWidth/o.tileDelta.longitude),l=Math.round(180*o.tileHeight/o.tileDelta.latitude),h=1/(2*l),u=1-h,c=0,f=l-1,p=a*d.fract(e),m=l*d.clamp(t,h,u),g=d.mod(Math.floor(p-.5),a),b=d.mod(g+1,a),y=d.clamp(Math.floor(m-.5),c,f),_=d.clamp(y+1,c,f),E=d.fract(p-.5),v=d.fract(m-.5),w=T==n||0==T,this.lookupPixels(g,b,y,_,o,w,S))return!i.isNoData(S[0],S[1],S[2],S[3])&&(r[s]=(1-E)*(1-v)*S[0]+E*(1-v)*S[1]+(1-E)*v*S[2]+E*v*S[3],!0);return!1},f.prototype.lookupPixels=function(e,t,n,r,i,s,o){var a,l,h,u,c=i.levelNumber,d=i.tileWidth,f=i.tileHeight,p=Math.floor(n/f),m=Math.floor(r/f),g=Math.floor(e/d),b=Math.floor(t/d);return p==m&&p==this.cachedRow&&g==b&&g==this.cachedCol?a=l=h=u=this.cachedImage:p==m&&g==b?(a=this.lookupImage(c,p,g,s),l=h=u=a,this.cachedRow=p,this.cachedCol=g,this.cachedImage=a):(a=this.lookupImage(c,p,g,s),l=this.lookupImage(c,p,b,s),h=this.lookupImage(c,m,g,s),u=this.lookupImage(c,m,b,s)),!!(a&&l&&h&&u)&&(o[0]=a.pixel(e%d,n%f),o[1]=l.pixel(t%d,n%f),o[2]=h.pixel(e%d,r%f),o[3]=u.pixel(t%d,r%f),!0)},f.prototype.lookupImage=function(e,t,n,r){var i=c.computeTileKey(e,t,n),s=this.imageCache.entryForKey(i);if(null==s&&r){var o=this.tileForLevel(e,t,n);this.retrieveTileImage(o)}return s},f.prototype.assembleTiles=function(e,t,n){if(this.currentTiles=[],this.currentSector.copy(t),this.currentSector.intersection(this.coverageSector),!this.currentSector.isEmpty())for(var r=e.tileDelta.latitude,i=e.tileDelta.longitude,s=c.computeRow(r,this.currentSector.minLatitude),o=c.computeLastRow(r,this.currentSector.maxLatitude),a=c.computeColumn(i,this.currentSector.minLongitude),l=c.computeLastColumn(i,this.currentSector.maxLongitude),h=s;h<=o;h++)for(var u=a;u<=l;u++)this.addTileOrAncestor(e,h,u,n)},f.prototype.addTileOrAncestor=function(e,t,n,r){var i=this.tileForLevel(e.levelNumber,t,n);this.isTileImageInMemory(i)?this.addToCurrentTiles(i):(r&&this.retrieveTileImage(i),e.isFirstLevel()?this.currentTiles.push(i):this.addAncestor(e,t,n,r))},f.prototype.addAncestor=function(e,t,n,r){
for(var i=null,s=Math.floor(t/2),o=Math.floor(n/2),a=e.levelNumber-1;a>=0;a--){if(i=this.tileForLevel(a,s,o),this.isTileImageInMemory(i))return void this.addToCurrentTiles(i);s=Math.floor(s/2),o=Math.floor(o/2)}this.addToCurrentTiles(i),r&&this.retrieveTileImage(i)},f.prototype.addToCurrentTiles=function(e){this.currentTiles.push(e)},f.prototype.tileForLevel=function(e,t,n){var r=c.computeTileKey(e,t,n),i=this.tileCache.entryForKey(r);if(i)return i;var s=this.levels.level(e),o=c.computeSector(s,t,n);return i=new c(o,s,t,n),this.tileCache.putEntry(r,i,i.size()),i},f.prototype.isTileImageInMemory=function(e){return this.imageCache.containsKey(e.tileKey)},f.prototype.resourceUrlForTile=function(e){return this.urlBuilder.urlForTile(e,this.retrievalImageFormat)},f.prototype.retrieveTileImage=function(e){if(this.currentRetrievals.length<this.retrievalQueueSize&&this.currentRetrievals.indexOf(e.tileKey)<0&&!this.absentResourceList.isResourceAbsent(e.tileKey)){var t=this.resourceUrlForTile(e,this.retrievalImageFormat),n=new XMLHttpRequest,r=this;if(!t)return;n.open("GET",t,!0),n.responseType="arraybuffer",n.onreadystatechange=function(){if(4===n.readyState){r.removeFromCurrentRetrievals(e.tileKey);var i=n.getResponseHeader("content-type");if(200===n.status)if(i===r.retrievalImageFormat||"text/plain"===i||"application/octet-stream"===i){l.log(l.LEVEL_INFO,"Elevations retrieval succeeded: "+t),r.loadElevationImage(e,n),r.absentResourceList.unmarkResourceAbsent(e.tileKey);var s=document.createEvent("Event");s.initEvent(WorldWind.REDRAW_EVENT_TYPE,!0,!0),window.dispatchEvent(s)}else"text/xml"===i?(r.absentResourceList.markResourceAbsent(e.tileKey),l.log(l.LEVEL_WARNING,"Elevations retrieval failed ("+n.statusText+"): "+t+".\n "+String.fromCharCode.apply(null,new Uint8Array(n.response)))):(r.absentResourceList.markResourceAbsent(e.tileKey),l.log(l.LEVEL_WARNING,"Elevations retrieval failed: "+t+". Unexpected content type "+i));else r.absentResourceList.markResourceAbsent(e.tileKey),l.log(l.LEVEL_WARNING,"Elevations retrieval failed ("+n.statusText+"): "+t)}},n.onerror=function(){r.removeFromCurrentRetrievals(e.tileKey),r.absentResourceList.markResourceAbsent(e.tileKey),l.log(l.LEVEL_WARNING,"Elevations retrieval failed: "+t)},n.ontimeout=function(){r.removeFromCurrentRetrievals(e.tileKey),r.absentResourceList.markResourceAbsent(e.tileKey),l.log(l.LEVEL_WARNING,"Elevations retrieval timed out: "+t)},n.send(null),this.currentRetrievals.push(e.tileKey)}},f.prototype.removeFromCurrentRetrievals=function(e){var t=this.currentRetrievals.indexOf(e);t>-1&&this.currentRetrievals.splice(t,1)},f.prototype.loadElevationImage=function(e,t){var n,r=new i(e.sector,e.tileWidth,e.tileHeight);"application/bil16"===this.retrievalImageFormat?(r.imageData=new Int16Array(t.response),r.size=2*r.imageData.length):"application/bil32"===this.retrievalImageFormat?(r.imageData=new Float32Array(t.response),r.size=4*r.imageData.length):"image/tiff"===this.retrievalImageFormat&&(n=new s(t.response),r.imageData=n.getImageData(),r.size=r.imageData.length*n.metadata.bitsPerSample[0]/8),r.imageData&&(r.findMinAndMaxElevation(),this.imageCache.putEntry(e.tileKey,r,r.size),this.timestamp=Date.now())},f}),define("util/WmsUrlBuilder",["../error/ArgumentError","../util/Logger"],function(e,t){"use strict";var n=function(n,r,i,s,o){if(!n||0===n.length)throw new e(t.logMessage(t.LEVEL_SEVERE,"WmsUrlBuilder","constructor","The WMS service address is missing."));if(!r||0===r.length)throw new e(t.logMessage(t.LEVEL_SEVERE,"WmsUrlBuilder","constructor","The WMS layer names are not specified."));this.serviceAddress=n,this.layerNames=r,this.styleNames=i||"",this.transparent=!0,this.wmsVersion=s&&s.length>0?s:"1.3.0",this.isWms130OrGreater=this.wmsVersion>="1.3.0",this.crs="EPSG:4326",this.timeString=o};return n.prototype.urlForTile=function(r,i){if(!r)throw new e(t.logMessage(t.LEVEL_SEVERE,"WmsUrlBuilder","urlForTile","missingTile"));if(!i)throw new e(t.logMessage(t.LEVEL_SEVERE,"WmsUrlBuilder","urlForTile","The image format is null or undefined."));var s=r.sector,o=n.fixGetMapString(this.serviceAddress);return o.search(/service=wms/i)<0&&(o+="service=WMS"),o+="&request=GetMap",o=o+"&version="+this.wmsVersion,o=o+"&transparent="+(this.transparent?"TRUE":"FALSE"),o=o+"&layers="+this.layerNames,o=o+"&styles="+this.styleNames,o=o+"&format="+i,o=o+"&width="+r.tileWidth,o=o+"&height="+r.tileHeight,this.timeString&&(o=o+"&time="+this.timeString),this.isWms130OrGreater?(o=o+"&crs="+this.crs,o+="&bbox=","CRS:84"===this.crs?(o=o+s.minLongitude+","+s.minLatitude+",",o=o+s.maxLongitude+","+s.maxLatitude):(o=o+s.minLatitude+","+s.minLongitude+",",o=o+s.maxLatitude+","+s.maxLongitude)):(o=o+"&srs="+this.crs,o+="&bbox=",o=o+s.minLongitude+","+s.minLatitude+",",o=o+s.maxLongitude+","+s.maxLatitude),o=o.replace(" ","%20")},n.fixGetMapString=function(n){if(!n)throw new e(t.logMessage(t.LEVEL_SEVERE,"WmsUrlBuilder","fixGetMapString","The specified service address is null or undefined."));var r=n.indexOf("?");return r<0?n+="?":r!==n.length-1&&(r=n.search(/&$/))<0&&(n+="&"),n},n}),define("globe/AsterV2ElevationCoverage",["../geom/Location","../geom/Sector","../globe/TiledElevationCoverage","../util/WmsUrlBuilder"],function(e,t,n,r){"use strict";var i=function(){n.call(this,{coverageSector:new t(-83.0001,83.0001,-180,180),resolution:.000277777777778,retrievalImageFormat:"application/bil16",minElevation:-11e3,maxElevation:8850,urlBuilder:new r("https://worldwind26.arc.nasa.gov/elev","aster_v2","","1.3.0")}),this.displayName="ASTER V2 Earth Elevation Coverage"};return i.prototype=Object.create(n.prototype),i}),define("shaders/AtmosphereProgram",["../error/ArgumentError","../shaders/GpuProgram","../util/Logger"],function(e,t,n){"use strict";var r=function(e,n,r,i){t.call(this,e,n,r,i),this.FRAGMODE_SKY=1,this.FRAGMODE_GROUND_PRIMARY=2,this.FRAGMODE_GROUND_SECONDARY=3,this.FRAGMODE_GROUND_PRIMARY_TEX_BLEND=4,this.altitude=16e4,this.rayleighScaleDepth=.25,this.fragModeLocation=this.uniformLocation(e,"fragMode"),this.mvpMatrixLocation=this.uniformLocation(e,"mvpMatrix"),this.texCoordMatrixLocation=this.uniformLocation(e,"texCoordMatrix"),this.vertexOriginLocation=this.uniformLocation(e,"vertexOrigin"),this.eyePointLocation=this.uniformLocation(e,"eyePoint"),this.eyeMagnitudeLocation=this.uniformLocation(e,"eyeMagnitude"),this.eyeMagnitude2Location=this.uniformLocation(e,"eyeMagnitude2"),this.lightDirectionLocation=this.uniformLocation(e,"lightDirection"),this.atmosphereRadiusLocation=this.uniformLocation(e,"atmosphereRadius"),this.atmosphereRadius2Location=this.uniformLocation(e,"atmosphereRadius2"),this.globeRadiusLocation=this.uniformLocation(e,"globeRadius"),this.scaleLocation=this.uniformLocation(e,"scale"),this.opacityLocation=this.uniformLocation(e,"opacity"),this.scaleDepthLocation=this.uniformLocation(e,"scaleDepth"),this.scaleOverScaleDepthLocation=this.uniformLocation(e,"scaleOverScaleDepth"),this.scratchArray9=new Float32Array(9)};return r.key="WorldWindGpuAtmosphereProgram",r.prototype=Object.create(t.prototype),r.prototype.getAltitude=function(){return this.altitude},r.prototype.loadFragMode=function(t,r){if(!r)throw new e(n.logMessage(n.LEVEL_SEVERE,"AtmosphereProgram","loadFragMode","missingFragMode"));t.uniform1i(this.fragModeLocation,r)},r.prototype.loadModelviewProjection=function(t,r){if(!r)throw new e(n.logMessage(n.LEVEL_SEVERE,"AtmosphereProgram","loadModelviewProjection","missingMatrix"));this.loadUniformMatrix(t,r,this.mvpMatrixLocation)},r.prototype.loadVertexOrigin=function(t,r){if(!r)throw new e(n.logMessage(n.LEVEL_SEVERE,"AtmosphereProgram","loadVertexOrigin","missingVector"));t.uniform3f(this.vertexOriginLocation,r[0],r[1],r[2])},r.prototype.loadLightDirection=function(t,r){if(!r)throw new e(n.logMessage(n.LEVEL_SEVERE,"AtmosphereProgram","loadLightDirection","missingVector"));t.uniform3f(this.lightDirectionLocation,r[0],r[1],r[2])},r.prototype.loadEyePoint=function(t,r){if(!r)throw new e(n.logMessage(n.LEVEL_SEVERE,"AtmosphereProgram","loadEyePoint","missingVector"));t.uniform3f(this.eyePointLocation,r[0],r[1],r[2]),t.uniform1f(this.eyeMagnitudeLocation,r.magnitude()),t.uniform1f(this.eyeMagnitude2Location,r.magnitudeSquared())},r.prototype.loadGlobeRadius=function(t,r){if(!r)throw new e(n.logMessage(n.LEVEL_SEVERE,"AtmosphereProgram","loadGlobeRadius","missingGlobeRadius"));var i=r,s=i+this.altitude;t.uniform1f(this.globeRadiusLocation,i),t.uniform1f(this.atmosphereRadiusLocation,s),t.uniform1f(this.atmosphereRadius2Location,s*s)},r.prototype.setScale=function(e){e.uniform1f(this.scaleLocation,1/this.getAltitude()),e.uniform1f(this.scaleDepthLocation,this.rayleighScaleDepth),e.uniform1f(this.scaleOverScaleDepthLocation,1/this.getAltitude()/this.rayleighScaleDepth)},r.prototype.loadTexMatrix=function(t,r){if(!r)throw new e(n.logMessage(n.LEVEL_SEVERE,"AtmosphereProgram","loadTexMatrix","missingMatrix"));r.columnMajorComponents(this.scratchArray9),t.uniformMatrix3fv(this.texCoordMatrixLocation,!1,this.scratchArray9)},r.prototype.loadOpacity=function(t,r){if(void 0===r)throw new e(n.logMessage(n.LEVEL_SEVERE,"AtmosphereProgram","loadOpacity","missingOpacity"));t.uniform1f(this.opacityLocation,r)},r}),define("shaders/GroundProgram",["../shaders/AtmosphereProgram"],function(e){"use strict";var t=function(t){e.call(this,t,"precision mediump int;\nconst int FRAGMODE_GROUND_PRIMARY_TEX_BLEND = 4;\nconst int SAMPLE_COUNT = 2;\nconst float SAMPLES = 2.0;\nconst float PI = 3.141592653589;\nconst float Kr = 0.0025;\nconst float Kr4PI = Kr * 4.0 * PI;\nconst float Km = 0.0015;\nconst float Km4PI = Km * 4.0 * PI;\nconst float ESun = 15.0;\nconst float KmESun = Km * ESun;\nconst float KrESun = Kr * ESun;\nconst vec3 invWavelength = vec3(5.60204474633241, 9.473284437923038, 19.643802610477206);\nconst float rayleighScaleDepth = 0.25;\nuniform int fragMode;\nuniform mat4 mvpMatrix;\nuniform mat3 texCoordMatrix;\nuniform vec3 vertexOrigin;\nuniform vec3 eyePoint;\nuniform float eyeMagnitude;\nuniform float eyeMagnitude2;\nuniform vec3 lightDirection;\nuniform float atmosphereRadius;\nuniform float atmosphereRadius2;\nuniform float globeRadius;\nuniform float scale;\nuniform float scaleDepth;\nuniform float scaleOverScaleDepth;\nuniform float opacity;\nattribute vec4 vertexPoint;\nattribute vec2 vertexTexCoord;\nvarying vec3 primaryColor;\nvarying vec3 secondaryColor;\nvarying vec2 texCoord;\nfloat scaleFunc(float cos) {\n    float x = 1.0 - cos;\n    return scaleDepth * exp(-0.00287 + x*(0.459 + x*(3.83 + x*(-6.80 + x*5.25))));\n}\nvoid sampleGround() {\n    vec3 point = vertexPoint.xyz + vertexOrigin;\n    vec3 ray = point - eyePoint;\n    float far = length(ray);\n    ray /= far;\n    vec3 start;\n    if (eyeMagnitude < atmosphereRadius) {\n        start = eyePoint;\n    } else {\n        float B = 2.0 * dot(eyePoint, ray);\n        float C = eyeMagnitude2 - atmosphereRadius2;\n        float det = max(0.0, B*B - 4.0 * C);\n        float near = 0.5 * (-B - sqrt(det));\n        start = eyePoint + ray * near;\n        far -= near;\n}\n    float depth = exp((globeRadius - atmosphereRadius) / scaleDepth);\n    float eyeAngle = dot(-ray, point) / length(point);\n    float lightAngle = dot(lightDirection, point) / length(point);\n    float eyeScale = scaleFunc(eyeAngle);\n    float lightScale = scaleFunc(lightAngle);\n    float eyeOffset = depth*eyeScale;\n    float temp = (lightScale + eyeScale);\n    float sampleLength = far / SAMPLES;\n    float scaledLength = sampleLength * scale;\n    vec3 sampleRay = ray * sampleLength;\n    vec3 samplePoint = start + sampleRay * 0.5;\n    vec3 frontColor = vec3(0.0, 0.0, 0.0);\n    vec3 attenuate = vec3(0.0, 0.0, 0.0);\n    for(int i=0; i<SAMPLE_COUNT; i++)\n    {\n        float height = length(samplePoint);\n        float depth = exp(scaleOverScaleDepth * (globeRadius - height));\n        float scatter = depth*temp - eyeOffset;\n        attenuate = exp(-scatter * (invWavelength * Kr4PI + Km4PI));\n        frontColor += attenuate * (depth * scaledLength);\n        samplePoint += sampleRay;\n    }\n    primaryColor = frontColor * (invWavelength * KrESun + KmESun);\n    secondaryColor = mix(vec3(1.0, 1.0, 1.0), attenuate, opacity);\n}\nvoid main()\n {\n    sampleGround();\n    gl_Position = mvpMatrix * vertexPoint;\n    if (fragMode == FRAGMODE_GROUND_PRIMARY_TEX_BLEND) {\n        texCoord = (texCoordMatrix * vec3(vertexTexCoord, 1.0)).st;\n    }\n}","precision mediump float;\nprecision mediump int;\nconst int FRAGMODE_GROUND_PRIMARY = 2;\nconst int FRAGMODE_GROUND_SECONDARY = 3;\nconst int FRAGMODE_GROUND_PRIMARY_TEX_BLEND = 4;\nuniform int fragMode;\nuniform sampler2D texSampler;\nvarying vec3 primaryColor;\nvarying vec3 secondaryColor;\nvarying vec2 texCoord;\nvoid main (void)\n{\n    if (fragMode == FRAGMODE_GROUND_PRIMARY) {\n        gl_FragColor = vec4(primaryColor, 1.0);\n    } else if (fragMode == FRAGMODE_GROUND_SECONDARY) {\n        gl_FragColor = vec4(secondaryColor, 1.0);\n    } else if (fragMode == FRAGMODE_GROUND_PRIMARY_TEX_BLEND) {\n        vec4 texColor = texture2D(texSampler, texCoord);\n        gl_FragColor = vec4(primaryColor + texColor.rgb * (1.0 - secondaryColor), 1.0);\n    }\n}",["vertexPoint","vertexTexCoord"])};return t.key="WorldWindGroundProgram",t.prototype=Object.create(e.prototype),t}),define("layer/Layer",[],function(){"use strict";var e=function(e){this.displayName=e||"Layer",this.enabled=!0,this.pickEnabled=!0,this.opacity=1,this.minActiveAltitude=-Number.MAX_VALUE,this.maxActiveAltitude=Number.MAX_VALUE,this.inCurrentFrame=!1,this.time=null};return e.prototype.refresh=function(){},e.prototype.render=function(e){this.inCurrentFrame=!1,this.enabled&&(e.pickingMode&&!this.pickEnabled||this.withinActiveAltitudes(e)&&this.isLayerInView(e)&&this.doRender(e))},e.prototype.doRender=function(e){},e.prototype.withinActiveAltitudes=function(e){var t=e.eyePosition;return!!t&&(t.altitude>=this.minActiveAltitude&&t.altitude<=this.maxActiveAltitude)},e.prototype.isLayerInView=function(e){return!0},e}),define("geom/Matrix3",["../error/ArgumentError","../util/Logger"],function(e,t){"use strict";var n=function(e,t,n,r,i,s,o,a,l){this[0]=e,this[1]=t,this[2]=n,this[3]=r,this[4]=i,this[5]=s,this[6]=o,this[7]=a,this[8]=l};return n.prototype=new Float64Array(9),n.fromIdentity=function(){return new n(1,0,0,0,1,0,0,0,1)},n.prototype.setToUnitYFlip=function(){return this[0]=1,this[1]=0,this[2]=0,this[3]=0,this[4]=-1,this[5]=1,this[6]=0,this[7]=0,this[8]=1,this},n.prototype.multiplyMatrix=function(n){if(!n)throw new e(t.logMessage(t.LEVEL_SEVERE,"Matrix3","multiplyMatrix","missingMatrix"));var r,i,s,o=this,a=n;return r=o[0],i=o[1],s=o[2],o[0]=r*a[0]+i*a[3]+s*a[6],o[1]=r*a[1]+i*a[4]+s*a[7],o[2]=r*a[2]+i*a[5]+s*a[8],r=o[3],i=o[4],s=o[5],o[3]=r*a[0]+i*a[3]+s*a[6],o[4]=r*a[1]+i*a[4]+s*a[7],o[5]=r*a[2]+i*a[5]+s*a[8],r=o[6],i=o[7],s=o[8],o[6]=r*a[0]+i*a[3]+s*a[6],o[7]=r*a[1]+i*a[4]+s*a[7],o[8]=r*a[2]+i*a[5]+s*a[8],this},n.prototype.multiplyByTileTransform=function(e,t){var n=e.deltaLatitude(),r=e.deltaLongitude(),i=t.deltaLatitude(),s=t.deltaLongitude(),o=r/s,a=n/i,l=(e.minLongitude-t.minLongitude)/s,h=(e.minLatitude-t.minLatitude)/i,u=this;return u[2]+=u[0]*l+u[1]*h,u[5]+=u[3]*l+u[4]*h,u[8]+=u[6]*l+u[6]*h,u[0]*=o,u[1]*=a,u[3]*=o,u[4]*=a,u[6]*=o,u[7]*=a,this},n.prototype.columnMajorComponents=function(n){if(!n)throw new e(t.logMessage(t.LEVEL_SEVERE,"Matrix3","columnMajorComponents","missingResult"));return n[0]=this[0],n[1]=this[3],n[2]=this[6],n[3]=this[1],n[4]=this[4],n[5]=this[7],n[6]=this[2],n[7]=this[5],n[8]=this[8],n},n}),define("shaders/SkyProgram",["../shaders/AtmosphereProgram"],function(e){"use strict";var t=function(t){e.call(this,t,"precision mediump int;\nconst int SAMPLE_COUNT = 2;\nconst float SAMPLES = 2.0;\nconst float PI = 3.141592653589;\nconst float Kr = 0.0025;\nconst float Kr4PI = Kr * 4.0 * PI;\nconst float Km = 0.0015;\nconst float Km4PI = Km * 4.0 * PI;\nconst float ESun = 15.0;\nconst float KmESun = Km * ESun;\nconst float KrESun = Kr * ESun;\nconst vec3 invWavelength = vec3(5.60204474633241, 9.473284437923038, 19.643802610477206);\nconst float rayleighScaleDepth = 0.25;\nuniform mat4 mvpMatrix;\nuniform vec3 vertexOrigin;\nuniform vec3 eyePoint;\nuniform float eyeMagnitude;\nuniform float eyeMagnitude2;\nuniform mediump vec3 lightDirection;\nuniform float atmosphereRadius;\nuniform float atmosphereRadius2;\nuniform float globeRadius;\nuniform float scale;\nuniform float scaleDepth;\nuniform float scaleOverScaleDepth;\nattribute vec4 vertexPoint;\nvarying vec3 primaryColor;\nvarying vec3 secondaryColor;\nvarying vec3 direction;\nfloat scaleFunc(float cos)\n{\n    float x = 1.0 - cos;\n    return scaleDepth * exp(-0.00287 + x*(0.459 + x*(3.83 + x*(-6.80 + x*5.25))));\n}\nvoid sampleSky() {\n    vec3 point = vertexPoint.xyz + vertexOrigin;\n    vec3 ray = point - eyePoint;\n    float far = length(ray);\n    ray /= far;\n    vec3 start;\n    float startOffset;\n    if (eyeMagnitude < atmosphereRadius) {\n        start = eyePoint;\n        float height = length(start);\n        float depth = exp(scaleOverScaleDepth * (globeRadius - eyeMagnitude));\n        float startAngle = dot(ray, start) / height;\n        startOffset = depth*scaleFunc(startAngle);\n    } else {\n        float B = 2.0 * dot(eyePoint, ray);\n        float C = eyeMagnitude2 - atmosphereRadius2;\n        float det = max(0.0, B*B - 4.0 * C);\n        float near = 0.5 * (-B - sqrt(det));\n        start = eyePoint + ray * near;\n        far -= near;\n        float startAngle = dot(ray, start) / atmosphereRadius;\n        float startDepth = exp(-1.0 / scaleDepth);\n        startOffset = startDepth*scaleFunc(startAngle);\n    }\n    float sampleLength = far / SAMPLES;\n    float scaledLength = sampleLength * scale;\n    vec3 sampleRay = ray * sampleLength;\n    vec3 samplePoint = start + sampleRay * 0.5;\n    vec3 frontColor = vec3(0.0, 0.0, 0.0);\n    for(int i=0; i<SAMPLE_COUNT; i++)\n    {\n       float height = length(samplePoint);\n       float depth = exp(scaleOverScaleDepth * (globeRadius - height));\n       float lightAngle = dot(lightDirection, samplePoint) / height;\n       float cameraAngle = dot(ray, samplePoint) / height;\n       float scatter = (startOffset + depth*(scaleFunc(lightAngle) - scaleFunc(cameraAngle)));\n       vec3 attenuate = exp(-scatter * (invWavelength * Kr4PI + Km4PI));\n       frontColor += attenuate * (depth * scaledLength);\n       samplePoint += sampleRay;\n    }\n    primaryColor = frontColor * (invWavelength * KrESun);\n    secondaryColor = frontColor * KmESun;\n    direction = eyePoint - point;\n}\nvoid main()\n{\n    sampleSky();\n    gl_Position = mvpMatrix * vertexPoint;\n}","#ifdef GL_FRAGMENT_PRECISION_HIGH\nprecision highp float;\n#else\nprecision mediump float;\n#endif\nconst float g = -0.95;\nconst float g2 = g * g;\nuniform mediump vec3 lightDirection;\nvarying vec3 primaryColor;\nvarying vec3 secondaryColor;\nvarying vec3 direction;\nvoid main (void)\n{\n    float cos = dot(lightDirection, direction) / length(direction);\n    float rayleighPhase = 0.75 * (1.0 + cos * cos);\n    float miePhase = 1.5 * ((1.0 - g2) / (2.0 + g2)) * (1.0 + cos*cos) /         pow(1.0 + g2 - 2.0*g*cos, 1.5);\n    const float exposure = 2.0;\n    vec3 color = primaryColor * rayleighPhase + secondaryColor * miePhase;\n    color = vec3(1.0) - exp(-exposure * color);\n    gl_FragColor = vec4(color, color.b);\n}",["vertexPoint"])};return t.key="WorldWindSkyProgram",t.prototype=Object.create(e.prototype),t}),define("util/SunPosition",["../geom/Angle","../error/ArgumentError","./Logger","./WWMath"],function(e,t,n,r){"use strict";return{getAsGeographicLocation:function(e){if(e instanceof Date==!1)throw new t(n.logMessage(n.LEVEL_SEVERE,"SunPosition","getAsGeographicLocation","missingDate"));var r=this.getAsCelestialLocation(e);return this.celestialToGeographic(r,e)},getAsCelestialLocation:function(i){if(i instanceof Date==!1)throw new t(n.logMessage(n.LEVEL_SEVERE,"SunPosition","getAsCelestialLocation","missingDate"));var s=this.computeJulianDate(i),o=s-2451545,a=r.normalizeAngle360(280.46+.9856474*o),l=r.normalizeAngle360(357.528+.9856003*o)*e.DEGREES_TO_RADIANS,h=a+1.915*Math.sin(l)+.02*Math.sin(2*l),u=h*e.DEGREES_TO_RADIANS,c=(23.439-4e-7*o)*e.DEGREES_TO_RADIANS,d=Math.asin(Math.sin(c)*Math.sin(u))*e.RADIANS_TO_DEGREES,f=Math.atan(Math.cos(c)*Math.tan(u))*e.RADIANS_TO_DEGREES;return h>=90&&h<270&&(f+=180),f=r.normalizeAngle360(f),{declination:d,rightAscension:f}},celestialToGeographic:function(i,s){if(!i)throw new t(n.logMessage(n.LEVEL_SEVERE,"SunPosition","celestialToGeographic","missingCelestialLocation"));if(s instanceof Date==!1)throw new t(n.logMessage(n.LEVEL_SEVERE,"SunPosition","celestialToGeographic","missingDate"));var o=this.computeJulianDate(s),a=o-2451545,l=r.normalizeAngle360(280.46061837+360.98564736629*a),h=r.normalizeAngle360(l-i.rightAscension),u=e.normalizedDegreesLongitude(-h);return{latitude:i.declination,longitude:u}},computeJulianDate:function(e){if(e instanceof Date==!1)throw new t(n.logMessage(n.LEVEL_SEVERE,"SunPosition","computeJulianDate","missingDate"));var r=e.getUTCFullYear(),i=e.getUTCMonth()+1,s=e.getUTCDate(),o=e.getUTCHours(),a=e.getUTCMinutes(),l=e.getUTCSeconds(),h=(o+a/60+l/3600)/24;i<=2&&(r-=1,i+=12);var u=Math.floor(r/100),c=2-u+Math.floor(u/4);return Math.floor(365.25*(r+4716))+Math.floor(30.6001*(i+1))+s+c-1524.5+h}}}),define("layer/AtmosphereLayer",["../error/ArgumentError","../shaders/GroundProgram","../layer/Layer","../util/Logger","../geom/Matrix","../geom/Matrix3","../geom/Sector","../shaders/SkyProgram","../util/SunPosition","../geom/Vec3","../util/WWUtil"],function(e,t,n,r,i,s,o,a,l,h,u){"use strict";var c=function(e){n.call(this,"Atmosphere"),this.pickEnabled=!1,this._nightImageSource=e||WorldWind.configuration.baseUrl+"images/dnb_land_ocean_ice_2012.png",this._activeLightDirection=new h(0,0,0),this._fullSphereSector=o.FULL_SPHERE,this._skyData={},this._skyWidth=128,this._skyHeight=128,this._numIndices=0,this._texMatrix=s.fromIdentity(),this._activeTexture=null};return c.prototype=Object.create(n.prototype),Object.defineProperties(c.prototype,{nightImageSource:{get:function(){return this._nightImageSource},set:function(e){this._nightImageSource=e}}}),c.prototype.doRender=function(e){e.globe.is2D()||(this.determineLightDirection(e),this.drawSky(e),this.drawGround(e))},c.prototype.applySkyVertices=function(e){var t,n,r=e.currentGlContext,i=e.currentProgram,s=this._skyData;s.verticesVboCacheKey||(s.verticesVboCacheKey=e.gpuResourceCache.generateCacheKey()),n=e.gpuResourceCache.resourceForKey(s.verticesVboCacheKey),n?(r.bindBuffer(r.ARRAY_BUFFER,n),r.vertexAttribPointer(0,3,r.FLOAT,!1,0,0)):(t=this.assembleVertexPoints(e,this._skyHeight,this._skyWidth,i.getAltitude()),n=r.createBuffer(),r.bindBuffer(r.ARRAY_BUFFER,n),r.bufferData(r.ARRAY_BUFFER,t,r.STATIC_DRAW),r.vertexAttribPointer(0,3,r.FLOAT,!1,0,0),e.gpuResourceCache.putResource(s.verticesVboCacheKey,n,4*t.length),e.frameStatistics.incrementVboLoadCount(1))},c.prototype.applySkyIndices=function(e){var t,n,r=e.currentGlContext,i=this._skyData;i.indicesVboCacheKey||(i.indicesVboCacheKey=e.gpuResourceCache.generateCacheKey()),n=e.gpuResourceCache.resourceForKey(i.indicesVboCacheKey),n?r.bindBuffer(r.ELEMENT_ARRAY_BUFFER,n):(t=this.assembleTriStripIndices(this._skyWidth,this._skyHeight),n=r.createBuffer(),r.bindBuffer(r.ELEMENT_ARRAY_BUFFER,n),r.bufferData(r.ELEMENT_ARRAY_BUFFER,t,r.STATIC_DRAW),e.frameStatistics.incrementVboLoadCount(1),e.gpuResourceCache.putResource(i.indicesVboCacheKey,n,2*t.length))},c.prototype.drawSky=function(e){var t=e.currentGlContext,n=e.findAndBindProgram(a);n.loadGlobeRadius(t,e.globe.equatorialRadius),n.loadEyePoint(t,e.eyePoint),n.loadVertexOrigin(t,h.ZERO),n.loadModelviewProjection(t,e.modelviewProjection),n.loadLightDirection(t,this._activeLightDirection),n.setScale(t),this.applySkyVertices(e),this.applySkyIndices(e),t.depthMask(!1),t.frontFace(t.CW),t.enableVertexAttribArray(0),t.drawElements(t.TRIANGLE_STRIP,this._numIndices,t.UNSIGNED_SHORT,0),t.depthMask(!0),t.frontFace(t.CCW),t.disableVertexAttribArray(0)},c.prototype.drawGround=function(e){var n,r=e.currentGlContext,i=e.findAndBindProgram(t),s=e.terrain;i.loadGlobeRadius(r,e.globe.equatorialRadius),i.loadEyePoint(r,e.eyePoint),i.loadLightDirection(r,this._activeLightDirection),i.loadOpacity(r,this.opacity),i.setScale(r),this.nightImageSource&&null!==this.time&&(this._activeTexture=e.gpuResourceCache.resourceForKey(this.nightImageSource),this._activeTexture||(this._activeTexture=e.gpuResourceCache.retrieveTexture(r,this.nightImageSource)),n=this._activeTexture&&this._activeTexture.bind(e)),s.beginRendering(e);for(var o=0,a=s.surfaceGeometry.length;o<a;o++){var l=s.surfaceGeometry[o],h=l.referencePoint;i.loadVertexOrigin(r,h),n&&(this._texMatrix.setToUnitYFlip(),this._texMatrix.multiplyByTileTransform(l.sector,this._fullSphereSector),i.loadTexMatrix(r,this._texMatrix)),s.beginRenderingTile(e,l),i.loadFragMode(r,i.FRAGMODE_GROUND_SECONDARY),r.blendFunc(r.DST_COLOR,r.ZERO),s.renderTile(e,l);var u=n?i.FRAGMODE_GROUND_PRIMARY_TEX_BLEND:i.FRAGMODE_GROUND_PRIMARY;i.loadFragMode(r,u),r.blendFunc(r.ONE,r.ONE),s.renderTile(e,l),s.endRenderingTile(e,l)}s.endRendering(e),r.blendFunc(r.ONE,r.ONE_MINUS_SRC_ALPHA),this._activeTexture=null},c.prototype.assembleVertexPoints=function(e,t,n,r){var i=t*n,s=new Array(i);u.fillArray(s,r);var o=new Float32Array(3*i);return e.globe.computePointsForGrid(this._fullSphereSector,t,n,s,h.ZERO,o)},c.prototype.assembleTriStripIndices=function(e,t){for(var n=[],r=0,i=0;i<e-1;i++){for(var s=0;s<t;s++)r=s+i*t,n.push(r+t),n.push(r);i<e-2&&(n.push(r),n.push((i+2)*t))}return this._numIndices=n.length,new Uint16Array(n)},c.prototype.determineLightDirection=function(e){if(null!==this.time){var t=l.getAsGeographicLocation(this.time);e.globe.computePointFromLocation(t.latitude,t.longitude,this._activeLightDirection)}else this._activeLightDirection.copy(e.eyePoint);this._activeLightDirection.normalize()},c}),define("util/BasicTimeSequence",["../error/ArgumentError","../util/Logger"],function(e,t){"use strict";var n=function(n){if(!n&&n.length<2)throw new e(t.logMessage(t.LEVEL_SEVERE,"BasicTimeSequence","constructor","missingDates"));this.dates=n,this.currentIndex=0,this.currentTime=n[0]};return Object.defineProperties(n.prototype,{scaleForCurrentTime:{get:function(){return this.currentTime?this.currentIndex/this.dates.length:1}}}),n.prototype.next=function(){return this.currentIndex>=this.dates.length-1?null:(this.currentIndex++,this.currentTime=this.dates[this.currentIndex],this.currentTime)},n.prototype.previous=function(){return this.currentIndex<=0?null:(this.currentIndex--,this.currentTime=this.dates[this.currentIndex],this.currentTime)},n.prototype.reset=function(){this.currentIndex=-1,this.currentTime=null},n.prototype.getTimeForScale=function(e){return this.currentIndex=e<=0?0:e>=1?this.dates.length-1:Math.floor(this.dates.length*e),this.currentTime=this.dates[this.currentIndex],this.currentTime},n}),define("geom/Camera",["../error/ArgumentError","../util/Logger","../geom/Position"],function(e,t,n){"use strict";var r=function(){this.position=new n(30,-110,1e7),this.heading=0,this.tilt=0,this.roll=0,this._fieldOfView=45};return Object.defineProperties(r.prototype,{fieldOfView:{get:function(){return this._fieldOfView},set:function(n){if(n<=0||n>=180)throw new e(t.logMessage(t.LEVEL_SEVERE,"Camera","setFieldOfView","Invalid field of view"));this._fieldOfView=n}}}),r.prototype.equals=function(e){return!!e&&(this.position.equals(e.position)&&this.heading===e.heading&&this.tilt===e.tilt&&this.roll===e.roll)},r.prototype.clone=function(){var e=new r;return e.copy(this),e},r.prototype.copy=function(n){if(!n)throw new e(t.logMessage(t.LEVEL_SEVERE,"Camera","copy","missingObject"));return this.position.copy(n.position),this.heading=n.heading,this.tilt=n.tilt,this.roll=n.roll,this},r.prototype.toString=function(){return this.position.toString()+","+this.heading+"°,"+this.tilt+"°,"+this.roll+"°"},r}),define("gesture/Touch",[],function(){"use strict";var e=function(e,t,n){this.identifier=e,this._clientX=t,this._clientY=n,this._clientStartX=t,this._clientStartY=n};return Object.defineProperties(e.prototype,{clientX:{get:function(){return this._clientX},set:function(e){this._clientX=e}},clientY:{get:function(){return this._clientY},set:function(e){this._clientY=e}},translationX:{get:function(){return this._clientX-this._clientStartX},set:function(e){this._clientStartX=this._clientX-e}},translationY:{get:function(){return this._clientY-this._clientStartY},set:function(e){this._clientStartY=this._clientY-e}}}),e}),define("gesture/GestureRecognizer",["../error/ArgumentError","../util/Logger","../gesture/Touch"],function(e,t,n){"use strict";var r=function(n,i){if(!n)throw new e(t.logMessage(t.LEVEL_SEVERE,"GestureRecognizer","constructor","missingTarget"));this.target=n,this.enabled=!0,this._state=WorldWind.POSSIBLE,this._nextState=null,this._clientX=0,this._clientY=0,this._clientStartX=0,this._clientStartY=0,this._translationX=0,this._translationY=0,this._translationWeight=.4,this._mouseButtonMask=0,this._touches=[],this._touchCentroidShiftX=0,this._touchCentroidShiftY=0,this._gestureCallbacks=[],this._canRecognizeWith=[],this._requiresFailureOf=[],this._requiredToFailBy=[],i&&this._gestureCallbacks.push(i),this.listenerList=[],r.allRecognizers.push(this)};return r.allRecognizers=[],Object.defineProperties(r.prototype,{state:{get:function(){return this._state},set:function(e){this.transitionToState(e)}},clientX:{get:function(){return this._clientX},set:function(e){this._clientX=e}},clientY:{get:function(){return this._clientY},set:function(e){this._clientY=e}},translationX:{get:function(){return this._translationX},set:function(e){this._translationX=e,this._clientStartX=this._clientX,this._touchCentroidShiftX=0}},translationY:{get:function(){return this._translationY},set:function(e){this._translationY=e,this._clientStartY=this._clientY,this._touchCentroidShiftY=0}},mouseButtonMask:{get:function(){return this._mouseButtonMask}},touchCount:{get:function(){return this._touches.length}},gestureCallbacks:{get:function(){return this._gestureCallbacks}}}),r.prototype.touch=function(n){if(n<0||n>=this._touches.length)throw new e(t.logMessage(t.LEVEL_SEVERE,"GestureRecognizer","touch","indexOutOfRange"));return this._touches[n]},r.prototype.recognizeSimultaneouslyWith=function(n){if(!n)throw new e(t.logMessage(t.LEVEL_SEVERE,"GestureRecognizer","recognizeSimultaneouslyWith","The specified gesture recognizer is null or undefined."));-1==this._canRecognizeWith.indexOf(n)&&(this._canRecognizeWith.push(n),n._canRecognizeWith.push(this))},r.prototype.canRecognizeSimultaneouslyWith=function(e){return-1!=this._canRecognizeWith.indexOf(e)},r.prototype.requireRecognizerToFail=function(n){if(!n)throw new e(t.logMessage(t.LEVEL_SEVERE,"GestureRecognizer","requireRecognizerToFail","The specified gesture recognizer is null or undefined"));-1==this._requiresFailureOf.indexOf(n)&&(this._requiresFailureOf.push(n),n._requiredToFailBy.push(this))},r.prototype.requiresRecognizerToFail=function(e){return-1!=this._requiresFailureOf.indexOf(e)},r.prototype.requiredToFailByRecognizer=function(e){return-1!=this._requiredToFailBy.indexOf(e)},r.prototype.reset=function(){this._state=WorldWind.POSSIBLE,this._nextState=null,this._clientX=0,this._clientY=0,this._clientStartX=0,this._clientStartY=0,this._translationX=0,this._translationY=0,this._mouseButtonMask=0,this._touches=[],this._touchCentroidShiftX=0,this._touchCentroidShiftY=0},r.prototype.prepareToRecognize=function(){},r.prototype.mouseDown=function(e){},r.prototype.mouseMove=function(e){},r.prototype.mouseUp=function(e){},r.prototype.touchStart=function(e){},r.prototype.touchMove=function(e){},r.prototype.touchCancel=function(e){},r.prototype.touchEnd=function(e){},
r.prototype.transitionToState=function(e){this._nextState=null,e===WorldWind.FAILED?(this._state=e,this.updateRecognizersWaitingForFailure(),this.resetIfEventsEnded()):e===WorldWind.RECOGNIZED?(this.tryToRecognize(e),this._state===e&&(this.prepareToRecognize(),this.notifyListeners(),this.callGestureCallbacks(),this.resetIfEventsEnded())):e===WorldWind.BEGAN?(this.tryToRecognize(e),this._state===e&&(this.prepareToRecognize(),this.notifyListeners(),this.callGestureCallbacks())):e===WorldWind.CHANGED?(this._state=e,this.notifyListeners(),this.callGestureCallbacks()):e===WorldWind.CANCELLED?(this._state=e,this.notifyListeners(),this.callGestureCallbacks(),this.resetIfEventsEnded()):e===WorldWind.ENDED&&(this._state=e,this.notifyListeners(),this.callGestureCallbacks(),this.resetIfEventsEnded())},r.prototype.updateRecognizersWaitingForFailure=function(){for(var e=0,t=this._requiredToFailBy.length;e<t;e++){var n=this._requiredToFailBy[e];null!=n._nextState&&n.transitionToState(n._nextState)}},r.prototype.tryToRecognize=function(e){if(r.allRecognizers.some(this.canBePreventedByRecognizer,this))return void this.transitionToState(WorldWind.FAILED);if(r.allRecognizers.some(this.isWaitingForRecognizerToFail,this))return void(this._nextState=e);for(var t=r.allRecognizers.filter(this.canPreventRecognizer,this),n=0,i=t.length;n<i;n++)t[n].transitionToState(WorldWind.FAILED);this._state=e},r.prototype.canPreventRecognizer=function(e){return this!=e&&this.target==e.target&&e.state==WorldWind.POSSIBLE&&(this.requiredToFailByRecognizer(e)||!this.canRecognizeSimultaneouslyWith(e))},r.prototype.canBePreventedByRecognizer=function(e){return this!=e&&this.target==e.target&&e.state==WorldWind.RECOGNIZED&&(this.requiresRecognizerToFail(e)||!this.canRecognizeSimultaneouslyWith(e))},r.prototype.isWaitingForRecognizerToFail=function(e){return this!=e&&this.target==e.target&&e.state==WorldWind.POSSIBLE&&this.requiresRecognizerToFail(e)},r.prototype.addListener=function(n){if(!n)throw new e(t.logMessage(t.LEVEL_SEVERE,"GestureRecognizer","addListener","missingListener"));this.listenerList.push(n)},r.prototype.removeListener=function(n){if(!n)throw new e(t.logMessage(t.LEVEL_SEVERE,"GestureRecognizer","removeListener","missingListener"));var r=this.listenerList.indexOf(n);-1!==r&&this.listenerList.splice(r,1)},r.prototype.notifyListeners=function(){for(var e=0;e<this.listenerList.length;e++)this.listenerList[e].gestureStateChanged(this)},r.prototype.callGestureCallbacks=function(){for(var e=0,t=this._gestureCallbacks.length;e<t;e++)this._gestureCallbacks[e](this)},r.prototype.onGestureEvent=function(e){if(this.enabled&&(!e.defaultPrevented||this.state!==WorldWind.POSSIBLE)){var n,r;try{if("mousedown"===e.type)this.handleMouseDown(e);else if("mousemove"===e.type)this.handleMouseMove(e);else if("mouseup"===e.type)this.handleMouseUp(e);else if("touchstart"===e.type)for(n=0,r=e.changedTouches.length;n<r;n++)this.handleTouchStart(e.changedTouches.item(n));else if("touchmove"===e.type)for(n=0,r=e.changedTouches.length;n<r;n++)this.handleTouchMove(e.changedTouches.item(n));else if("touchcancel"===e.type)for(n=0,r=e.changedTouches.length;n<r;n++)this.handleTouchCancel(e.changedTouches.item(n));else if("touchend"===e.type)for(n=0,r=e.changedTouches.length;n<r;n++)this.handleTouchEnd(e.changedTouches.item(n));else"pointerdown"===e.type&&"mouse"===e.pointerType?this.handleMouseDown(e):"pointermove"===e.type&&"mouse"===e.pointerType?this.handleMouseMove(e):"pointercancel"===e.type&&"mouse"===e.pointerType||("pointerup"===e.type&&"mouse"===e.pointerType?this.handleMouseUp(e):"pointerdown"===e.type&&"touch"===e.pointerType?this.handleTouchStart(e):"pointermove"===e.type&&"touch"===e.pointerType?this.handleTouchMove(e):"pointercancel"===e.type&&"touch"===e.pointerType?this.handleTouchCancel(e):"pointerup"===e.type&&"touch"===e.pointerType?this.handleTouchEnd(e):t.logMessage(t.LEVEL_INFO,"GestureRecognizer","handleEvent","Unrecognized event type: "+e.type))}catch(e){t.logMessage(t.LEVEL_SEVERE,"GestureRecognizer","handleEvent","Error handling event.\n"+e.toString())}}},r.prototype.handleMouseDown=function(e){if(!("mousedown"==e.type&&this._touches.length>0)){var t=1<<e.button;t&0!=this._mouseButtonMask||(0==this._mouseButtonMask&&(this._clientX=e.clientX,this._clientY=e.clientY,this._clientStartX=e.clientX,this._clientStartY=e.clientY,this._translationX=0,this._translationY=0),this._mouseButtonMask|=t,this.mouseDown(e))}},r.prototype.handleMouseMove=function(e){if(0!=this._mouseButtonMask&&(this._clientX!=e.clientX||this._clientY!=e._clientY)){var t=e.clientX-this._clientStartX,n=e.clientY-this._clientStartY,r=this._translationWeight;this._clientX=e.clientX,this._clientY=e.clientY,this._translationX=this._translationX*(1-r)+t*r,this._translationY=this._translationY*(1-r)+n*r,this.mouseMove(e)}},r.prototype.handleMouseUp=function(e){var t=1<<e.button;t&0==this._mouseButtonMask||(this._mouseButtonMask&=~t,this.mouseUp(e),0==this._mouseButtonMask&&this.resetIfEventsEnded())},r.prototype.handleTouchStart=function(e){var t=new n(e.identifier||e.pointerId,e.clientX,e.clientY);this._touches.push(t),1==this._touches.length?(this._clientX=e.clientX,this._clientY=e.clientY,this._clientStartX=e.clientX,this._clientStartY=e.clientY,this._translationX=0,this._translationY=0,this._touchCentroidShiftX=0,this._touchCentroidShiftY=0):this.touchesAddedOrRemoved(),this.touchStart(t)},r.prototype.handleTouchMove=function(e){var t=this.indexOfTouchWithId(e.identifier||e.pointerId);if(-1!=t){var n=this._touches[t];if(n.clientX!=e.clientX||n.clientY!=e.clientY){n.clientX=e.clientX,n.clientY=e.clientY;var r=this.touchCentroid(),i=r.clientX-this._clientStartX+this._touchCentroidShiftX,s=r.clientY-this._clientStartY+this._touchCentroidShiftY,o=this._translationWeight;this._clientX=r.clientX,this._clientY=r.clientY,this._translationX=this._translationX*(1-o)+i*o,this._translationY=this._translationY*(1-o)+s*o,this.touchMove(n)}}},r.prototype.handleTouchCancel=function(e){var t=this.indexOfTouchWithId(e.identifier||e.pointerId);if(-1!=t){var n=this._touches[t];this._touches.splice(t,1),this.touchesAddedOrRemoved(),this.touchCancel(n),this.resetIfEventsEnded()}},r.prototype.handleTouchEnd=function(e){var t=this.indexOfTouchWithId(e.identifier||e.pointerId);if(-1!=t){var n=this._touches[t];this._touches.splice(t,1),this.touchesAddedOrRemoved(),this.touchEnd(n),this.resetIfEventsEnded()}},r.prototype.resetIfEventsEnded=function(){this._state!=WorldWind.POSSIBLE&&0==this._mouseButtonMask&&0==this._touches.length&&this.reset()},r.prototype.touchesAddedOrRemoved=function(){this._touchCentroidShiftX+=this._clientX,this._touchCentroidShiftY+=this._clientY;var e=this.touchCentroid();this._clientX=e.clientX,this._clientY=e.clientY,this._touchCentroidShiftX-=this._clientX,this._touchCentroidShiftY-=this._clientY},r.prototype.touchCentroid=function(){for(var e=0,t=0,n=0,r=this._touches.length;n<r;n++){var i=this._touches[n];e+=i.clientX/r,t+=i.clientY/r}return{clientX:e,clientY:t}},r.prototype.indexOfTouchWithId=function(e){for(var t=0,n=this._touches.length;t<n;t++)if(this._touches[t].identifier==e)return t;return-1},r}),define("gesture/ClickRecognizer",["../gesture/GestureRecognizer"],function(e){"use strict";var t=function(t,n){e.call(this,t,n),this.numberOfClicks=1,this.button=0,this.maxMouseMovement=5,this.maxClickDuration=500,this.maxClickInterval=400,this.clicks=[],this.timeout=null};return t.prototype=Object.create(e.prototype),t.prototype.reset=function(){e.prototype.reset.call(this),this.clicks=[],this.cancelFailAfterDelay()},t.prototype.mouseDown=function(e){if(this.state==WorldWind.POSSIBLE)if(this.button!=e.button)this.state=WorldWind.FAILED;else{var t={clientX:this.clientX,clientY:this.clientY};this.clicks.push(t),this.failAfterDelay(this.maxClickDuration)}},t.prototype.mouseMove=function(e){if(this.state==WorldWind.POSSIBLE){var t=this.translationX,n=this.translationY;Math.sqrt(t*t+n*n)>this.maxMouseMovement&&(this.state=WorldWind.FAILED)}},t.prototype.mouseUp=function(e){if(this.state==WorldWind.POSSIBLE&&0==this.mouseButtonMask){this.clicks.length==this.numberOfClicks?(this.clientX=this.clicks[0].clientX,this.clientY=this.clicks[0].clientY,this.state=WorldWind.RECOGNIZED):this.failAfterDelay(this.maxClickInterval)}},t.prototype.touchStart=function(e){this.state==WorldWind.POSSIBLE&&(this.state=WorldWind.FAILED)},t.prototype.failAfterDelay=function(e){var t=this;t.timeout&&window.clearTimeout(t.timeout),t.timeout=window.setTimeout(function(){t.timeout=null,t.state==WorldWind.POSSIBLE&&(t.state=WorldWind.FAILED)},e)},t.prototype.cancelFailAfterDelay=function(){var e=this;e.timeout&&(window.clearTimeout(e.timeout),e.timeout=null)},t}),define("gesture/DragRecognizer",["../gesture/GestureRecognizer"],function(e){"use strict";var t=function(t,n){e.call(this,t,n),this.button=0,this.interpretDistance=5};return t.prototype=Object.create(e.prototype),t.prototype.mouseMove=function(e){this.state==WorldWind.POSSIBLE?this.shouldInterpret()&&(this.shouldRecognize()?(this.translationX=0,this.translationY=0,this.state=WorldWind.BEGAN):this.state=WorldWind.FAILED):this.state!=WorldWind.BEGAN&&this.state!=WorldWind.CHANGED||(this.state=WorldWind.CHANGED)},t.prototype.mouseUp=function(e){0==this.mouseButtonMask&&(this.state==WorldWind.POSSIBLE?this.state=WorldWind.FAILED:this.state!=WorldWind.BEGAN&&this.state!=WorldWind.CHANGED||(this.state=WorldWind.ENDED))},t.prototype.touchStart=function(e){this.state==WorldWind.POSSIBLE&&(this.state=WorldWind.FAILED)},t.prototype.shouldInterpret=function(){var e=this.translationX,t=this.translationY;return Math.sqrt(e*e+t*t)>this.interpretDistance},t.prototype.shouldRecognize=function(){return 1<<this.button==this.mouseButtonMask},t}),define("geom/LookAt",["../error/ArgumentError","../util/Logger","../geom/Position"],function(e,t,n){"use strict";var r=function(){this.position=new n(30,-110,0),this.heading=0,this.tilt=0,this.roll=0,this.range=1e7};return r.prototype.equals=function(e){return!!e&&(this.position.equals(e.position)&&this.heading===e.heading&&this.tilt===e.tilt&&this.roll===e.roll&&this.range===e.range)},r.prototype.clone=function(){var e=new r;return e.copy(this),e},r.prototype.copy=function(n){if(!n)throw new e(t.logMessage(t.LEVEL_SEVERE,"LookAt","copy","missingObject"));return this.position.copy(n.position),this.heading=n.heading,this.tilt=n.tilt,this.roll=n.roll,this.range=n.range,this},r.prototype.toString=function(){return this.position.toString()+","+this.heading+"°,"+this.tilt+"°,"+this.roll+"°"},r}),define("gesture/PanRecognizer",["../gesture/GestureRecognizer"],function(e){"use strict";var t=function(t,n){e.call(this,t,n),this.minNumberOfTouches=1,this.maxNumberOfTouches=Number.MAX_VALUE,this.interpretDistance=20};return t.prototype=Object.create(e.prototype),t.prototype.mouseDown=function(e){this.state==WorldWind.POSSIBLE&&(this.state=WorldWind.FAILED)},t.prototype.touchMove=function(e){this.state==WorldWind.POSSIBLE?this.shouldInterpret()&&(this.shouldRecognize()?this.state=WorldWind.BEGAN:this.state=WorldWind.FAILED):this.state!=WorldWind.BEGAN&&this.state!=WorldWind.CHANGED||(this.state=WorldWind.CHANGED)},t.prototype.touchEnd=function(e){0==this.touchCount&&(this.state==WorldWind.POSSIBLE?this.state=WorldWind.FAILED:this.state!=WorldWind.BEGAN&&this.state!=WorldWind.CHANGED||(this.state=WorldWind.ENDED))},t.prototype.touchCancel=function(e){0==this.touchCount&&(this.state==WorldWind.POSSIBLE?this.state=WorldWind.FAILED:this.state!=WorldWind.BEGAN&&this.state!=WorldWind.CHANGED||(this.state=WorldWind.CANCELLED))},t.prototype.prepareToRecognize=function(){this.translationX=0,this.translationY=0},t.prototype.shouldInterpret=function(){var e=this.translationX,t=this.translationY;return Math.sqrt(e*e+t*t)>this.interpretDistance},t.prototype.shouldRecognize=function(){var e=this.touchCount;return 0!=e&&e>=this.minNumberOfTouches&&e<=this.maxNumberOfTouches},t}),define("gesture/PinchRecognizer",["../gesture/GestureRecognizer"],function(e){"use strict";var t=function(t,n){e.call(this,t,n),this._scale=1,this._offsetScale=1,this.referenceDistance=0,this.interpretThreshold=20,this.weight=.4,this.pinchTouches=[]};return t.prototype=Object.create(e.prototype),Object.defineProperties(t.prototype,{scale:{get:function(){return this._scale*this._offsetScale}}}),t.prototype.reset=function(){e.prototype.reset.call(this),this._scale=1,this._offsetScale=1,this.referenceDistance=0,this.pinchTouches=[]},t.prototype.mouseDown=function(e){this.state==WorldWind.POSSIBLE&&(this.state=WorldWind.FAILED)},t.prototype.touchStart=function(e){this.pinchTouches.length<2&&2==this.pinchTouches.push(e)&&(this.referenceDistance=this.currentPinchDistance(),this._offsetScale*=this._scale,this._scale=1)},t.prototype.touchMove=function(e){if(2==this.pinchTouches.length)if(this.state==WorldWind.POSSIBLE)this.shouldRecognize()&&(this.state=WorldWind.BEGAN);else if(this.state==WorldWind.BEGAN||this.state==WorldWind.CHANGED){var t=this.currentPinchDistance(),n=Math.abs(t/this.referenceDistance),r=this.weight;this._scale=this._scale*(1-r)+n*r,this.state=WorldWind.CHANGED}},t.prototype.touchEnd=function(e){var t=this.pinchTouches.indexOf(e);-1!=t&&this.pinchTouches.splice(t,1),0==this.touchCount&&(this.state==WorldWind.POSSIBLE?this.state=WorldWind.FAILED:this.state!=WorldWind.BEGAN&&this.state!=WorldWind.CHANGED||(this.state=WorldWind.ENDED))},t.prototype.touchCancel=function(e){var t=this.pinchTouches.indexOf(e);-1!=t&&this.pinchTouches.splice(t,1),0==this.touchCount&&(this.state==WorldWind.POSSIBLE?this.state=WorldWind.FAILED:this.state!=WorldWind.BEGAN&&this.state!=WorldWind.CHANGED||(this.state=WorldWind.CANCELLED))},t.prototype.prepareToRecognize=function(){this.referenceDistance=this.currentPinchDistance(),this._scale=1},t.prototype.shouldRecognize=function(){var e=this.currentPinchDistance();return Math.abs(e-this.referenceDistance)>this.interpretThreshold},t.prototype.currentPinchDistance=function(){var e=this.pinchTouches[0],t=this.pinchTouches[1],n=e.clientX-t.clientX,r=e.clientY-t.clientY;return Math.sqrt(n*n+r*r)},t}),define("gesture/RotationRecognizer",["../geom/Angle","../gesture/GestureRecognizer"],function(e,t){"use strict";var n=function(e,n){t.call(this,e,n),this._rotation=0,this._offsetRotation=0,this.referenceAngle=0,this.interpretThreshold=20,this.weight=.4,this.rotationTouches=[]};return n.prototype=Object.create(t.prototype),Object.defineProperties(n.prototype,{rotation:{get:function(){return this._rotation+this._offsetRotation}}}),n.prototype.reset=function(){t.prototype.reset.call(this),this._rotation=0,this._offsetRotation=0,this.referenceAngle=0,this.rotationTouches=[]},n.prototype.mouseDown=function(e){this.state==WorldWind.POSSIBLE&&(this.state=WorldWind.FAILED)},n.prototype.touchStart=function(e){this.rotationTouches.length<2&&2==this.rotationTouches.push(e)&&(this.referenceAngle=this.currentTouchAngle(),this._offsetRotation+=this._rotation,this._rotation=0)},n.prototype.touchMove=function(t){if(2==this.rotationTouches.length)if(this.state==WorldWind.POSSIBLE)this.shouldRecognize()&&(this.state=WorldWind.BEGAN);else if(this.state==WorldWind.BEGAN||this.state==WorldWind.CHANGED){var n=this.currentTouchAngle(),r=e.normalizedDegrees(n-this.referenceAngle),i=this.weight;this._rotation=this._rotation*(1-i)+r*i,this.state=WorldWind.CHANGED}},n.prototype.touchEnd=function(e){var t=this.rotationTouches.indexOf(e);-1!=t&&this.rotationTouches.splice(t,1),0==this.touchCount&&(this.state==WorldWind.POSSIBLE?this.state=WorldWind.FAILED:this.state!=WorldWind.BEGAN&&this.state!=WorldWind.CHANGED||(this.state=WorldWind.ENDED))},n.prototype.touchCancel=function(e){var t=this.rotationTouches.indexOf(e);-1!=t&&(this.rotationTouches.splice(t,1),0==this.touchCount&&(this.state==WorldWind.POSSIBLE?this.state=WorldWind.FAILED:this.state!=WorldWind.BEGAN&&this.state!=WorldWind.CHANGED||(this.state=WorldWind.CANCELLED)))},n.prototype.prepareToRecognize=function(){this.referenceAngle=this.currentTouchAngle(),this._rotation=0},n.prototype.shouldRecognize=function(){var t=this.currentTouchAngle(),n=e.normalizedDegrees(t-this.referenceAngle);return Math.abs(n)>this.interpretThreshold},n.prototype.currentTouchAngle=function(){var t=this.rotationTouches[0],n=this.rotationTouches[1],r=t.clientX-n.clientX,i=t.clientY-n.clientY;return Math.atan2(i,r)*e.RADIANS_TO_DEGREES},n}),define("gesture/TapRecognizer",["../gesture/GestureRecognizer"],function(e){"use strict";var t=function(t,n){e.call(this,t,n),this.numberOfTaps=1,this.numberOfTouches=1,this.maxTouchMovement=20,this.maxTapDuration=500,this.maxTapInterval=400,this.taps=[],this.timeout=null};return t.prototype=Object.create(e.prototype),t.prototype.reset=function(){e.prototype.reset.call(this),this.taps=[],this.cancelFailAfterDelay()},t.prototype.mouseDown=function(e){this.state==WorldWind.POSSIBLE&&(this.state=WorldWind.FAILED)},t.prototype.touchStart=function(e){if(this.state==WorldWind.POSSIBLE){var t;this.touchCount>this.numberOfTouches?this.state=WorldWind.FAILED:1==this.touchCount?(t={touchCount:this.touchCount,clientX:this.clientX,clientY:this.clientY},this.taps.push(t),this.failAfterDelay(this.maxTapDuration)):(t=this.taps[this.taps.length-1],t.touchCount=this.touchCount,t.clientX=this.clientX,t.clientY=this.clientY)}},t.prototype.touchMove=function(e){if(this.state==WorldWind.POSSIBLE){var t=this.translationX,n=this.translationY;Math.sqrt(t*t+n*n)>this.maxTouchMovement&&(this.state=WorldWind.FAILED)}},t.prototype.touchEnd=function(e){if(this.state==WorldWind.POSSIBLE&&0==this.touchCount){var t=this.taps.length;this.taps[t-1].touchCount!=this.numberOfTouches?this.state=WorldWind.FAILED:t==this.numberOfTaps?(this.clientX=this.taps[0].clientX,this.clientY=this.taps[0].clientY,this.state=WorldWind.RECOGNIZED):this.failAfterDelay(this.maxTapInterval)}},t.prototype.touchCancel=function(e){this.state==WorldWind.POSSIBLE&&(this.state=WorldWind.FAILED)},t.prototype.failAfterDelay=function(e){var t=this;t.timeout&&window.clearTimeout(t.timeout),t.timeout=window.setTimeout(function(){t.timeout=null,t.state==WorldWind.POSSIBLE&&(t.state=WorldWind.FAILED)},e)},t.prototype.cancelFailAfterDelay=function(){var e=this;e.timeout&&(window.clearTimeout(e.timeout),e.timeout=null)},t}),define("gesture/TiltRecognizer",["../gesture/PanRecognizer"],function(e){"use strict";var t=function(t,n){e.call(this,t,n),this.maxTouchDistance=250,this.maxTouchDivergence=50};return t.LEFT=1,t.RIGHT=2,t.UP=4,t.DOWN=8,t.prototype=Object.create(e.prototype),t.prototype.shouldInterpret=function(){for(var e=0,t=this.touchCount;e<t;e++){var n=this.touch(e),r=n.translationX,i=n.translationY;if(Math.sqrt(r*r+i*i)>this.interpretDistance)return!0}return!1},t.prototype.shouldRecognize=function(){if(this.touchCount<2)return!1;var e=this.touch(0),n=this.touch(1),r=e.clientX-n.clientX,i=e.clientY-n.clientY;if(Math.sqrt(r*r+i*i)>this.maxTouchDistance)return!1;var s=e.translationX-n.translationX,o=e.translationY-n.translationY;if(Math.sqrt(s*s+o*o)>this.maxTouchDivergence)return!1;var a=t.UP|t.DOWN;return 0!=(this.touchDirection(e)&a&this.touchDirection(n)&a)},t.prototype.touchDirection=function(e){var n=e.translationX,r=e.translationY,i=0;return Math.abs(n)>Math.abs(r)?(i|=n<0?t.LEFT:0,i|=n>0?t.RIGHT:0):(i|=r<0?t.UP:0,i|=r>0?t.DOWN:0),i},t}),define("WorldWindowController",["./error/ArgumentError","./util/Logger","./error/UnsupportedOperationError"],function(e,t,n){"use strict";var r=function(n){if(!n)throw new e(t.logMessage(t.LEVEL_SEVERE,"WorldWindowController","constructor","missingWorldWindow"));this.wwd=n,this.allGestureListeners=[]};return r.prototype.onGestureEvent=function(e){for(var t=!1,n=0;n<this.allGestureListeners.length&&!t;n++)t|=this.allGestureListeners[n].onGestureEvent(e);return t},r.prototype.gestureStateChanged=function(e){throw new n(t.logMessage(t.LEVEL_SEVERE,"WorldWindowController","gestureStateChanged","abstractInvocation"))},r.prototype.addGestureListener=function(n){if(!n)throw new e(t.logMessage(t.LEVEL_SEVERE,"WorldWindowController","addGestureListener","missingListener"));this.allGestureListeners.push(n)},r.prototype.removeGestureListener=function(n){if(!n)throw new e(t.logMessage(t.LEVEL_SEVERE,"WorldWindowController","removeGestureListener","missingListener"));var r=this.allGestureListeners.indexOf(n);-1!==r&&this.allGestureListeners.splice(r,1)},r}),define("BasicWorldWindowController",["./geom/Angle","./error/ArgumentError","./geom/Camera","./gesture/ClickRecognizer","./gesture/DragRecognizer","./gesture/GestureRecognizer","./util/Logger","./geom/LookAt","./geom/Matrix","./gesture/PanRecognizer","./gesture/PinchRecognizer","./geom/Position","./gesture/RotationRecognizer","./gesture/TapRecognizer","./gesture/TiltRecognizer","./geom/Vec2","./geom/Vec3","./WorldWindowController","./util/WWMath"],function(e,t,n,r,i,s,o,a,l,h,u,c,d,f,p,m,g,b,y){"use strict";var _=function(e){b.call(this,e),this.primaryDragRecognizer=new i(this.wwd,null),this.primaryDragRecognizer.addListener(this),this.secondaryDragRecognizer=new i(this.wwd,null),this.secondaryDragRecognizer.addListener(this),this.secondaryDragRecognizer.button=2,this.panRecognizer=new h(this.wwd,null),this.panRecognizer.addListener(this),this.pinchRecognizer=new u(this.wwd,null),this.pinchRecognizer.addListener(this),this.rotationRecognizer=new d(this.wwd,null),this.rotationRecognizer.addListener(this),this.tiltRecognizer=new p(this.wwd,null),this.tiltRecognizer.addListener(this),this.panRecognizer.recognizeSimultaneouslyWith(this.pinchRecognizer),this.panRecognizer.recognizeSimultaneouslyWith(this.rotationRecognizer),this.pinchRecognizer.recognizeSimultaneouslyWith(this.rotationRecognizer),this.panRecognizer.requireRecognizerToFail(this.tiltRecognizer),this.pinchRecognizer.requireRecognizerToFail(this.tiltRecognizer),this.rotationRecognizer.requireRecognizerToFail(this.tiltRecognizer),this.beginPoint=new m(0,0),this.lastPoint=new m(0,0),this.lastRotation=0,this.lastWheelEvent=0,this.activeGestures=0,this.beginLookAt=new a,this.lookAt=new a};return _.prototype=Object.create(b.prototype),_.prototype.onGestureEvent=function(e){var t=b.prototype.onGestureEvent.call(this,e);if(!t)if("wheel"===e.type)t=!0,this.handleWheelEvent(e);else for(var n=0,r=s.allRecognizers.length;n<r;n++){var i=s.allRecognizers[n];i.target===this.wwd&&(t|=i.onGestureEvent(e))}return t},_.prototype.gestureStateChanged=function(e){e===this.primaryDragRecognizer||e===this.panRecognizer?this.handlePanOrDrag(e):e===this.secondaryDragRecognizer?this.handleSecondaryDrag(e):e===this.pinchRecognizer?this.handlePinch(e):e===this.rotationRecognizer?this.handleRotation(e):e===this.tiltRecognizer&&this.handleTilt(e)},_.prototype.handlePanOrDrag=function(e){this.wwd.globe.is2D()?this.handlePanOrDrag2D(e):this.handlePanOrDrag3D(e)},_.prototype.handlePanOrDrag3D=function(t){var n=t.state,r=t.translationX,i=t.translationY;if(n===WorldWind.BEGAN)this.gestureDidBegin(),this.lastPoint.set(0,0);else if(n===WorldWind.CHANGED){var s=this.lookAt,o=this.wwd.canvas,a=this.wwd.globe,l=y.max(a.equatorialRadius,a.polarRadius),h=y.max(1,s.range),u=y.perspectivePixelSize(o.clientWidth,o.clientHeight,h),c=(i-this.lastPoint[1])*u,d=-(r-this.lastPoint[0])*u,f=c/l*e.RADIANS_TO_DEGREES,p=d/l*e.RADIANS_TO_DEGREES,m=Math.sin(s.heading*e.DEGREES_TO_RADIANS),g=Math.cos(s.heading*e.DEGREES_TO_RADIANS);s.position.latitude+=f*g-p*m,s.position.longitude+=f*m+p*g,this.lastPoint.set(r,i),this.applyChanges()}else n!==WorldWind.ENDED&&n!==WorldWind.CANCELLED||this.gestureDidEnd()},_.prototype.handlePanOrDrag2D=function(e){var t=e.state,n=e.clientX,r=e.clientY,i=e.translationX,s=e.translationY;if(t===WorldWind.BEGAN)this.gestureDidBegin(),this.beginPoint.set(n,r),this.lastPoint.set(n,r);else if(t===WorldWind.CHANGED){var o=this.lastPoint[0],a=this.lastPoint[1],h=this.beginPoint[0]+i,u=this.beginPoint[1]+s;this.lastPoint.set(h,u);var c=this.lookAt,d=this.wwd.globe,f=this.wwd.rayThroughScreenPoint(this.wwd.canvasCoordinates(o,a)),p=new g(0,0,0),m=new g(0,0,0),b=new g(0,0,0);if(!d.intersectsLine(f,p))return;if(f=this.wwd.rayThroughScreenPoint(this.wwd.canvasCoordinates(h,u)),!d.intersectsLine(f,m))return;var y=l.fromIdentity();if(this.wwd.lookAtToViewingTransform(c,y),y.multiplyByTranslation(m[0]-p[0],m[1]-p[1],m[2]-p[2]),y.extractEyePoint(f.origin),y.extractForwardVector(f.direction),!d.intersectsLine(f,b))return;var _=y.extractViewingParameters(b,c.roll,d,{});c.position.copy(_.origin),c.range=_.range,c.heading=_.heading,c.tilt=_.tilt,c.roll=_.roll,this.applyChanges()}else t!==WorldWind.ENDED&&t!==WorldWind.CANCELLED||this.gestureDidEnd()},_.prototype.handleSecondaryDrag=function(e){var t=e.state,n=e.translationX,r=e.translationY;if(t===WorldWind.BEGAN)this.gestureDidBegin();else if(t===WorldWind.CHANGED){var i=this.lookAt,s=180*n/this.wwd.canvas.clientWidth,o=90*r/this.wwd.canvas.clientHeight;i.heading=this.beginLookAt.heading+s,i.tilt=this.beginLookAt.tilt+o,this.applyChanges()}else t!==WorldWind.ENDED&&t!==WorldWind.CANCELLED||this.gestureDidEnd()},_.prototype.handlePinch=function(e){var t=e.state,n=e.scale;if(t===WorldWind.BEGAN)this.gestureDidBegin();else if(t===WorldWind.CHANGED){if(0!==n){var r=this.lookAt;r.range=this.beginLookAt.range/n,this.applyChanges()}}else t!==WorldWind.ENDED&&t!==WorldWind.CANCELLED||this.gestureDidEnd()},_.prototype.handleRotation=function(e){var t=e.state,n=e.rotation;if(t===WorldWind.BEGAN)this.gestureDidBegin(),this.lastRotation=0;else if(t===WorldWind.CHANGED){var r=this.lookAt;r.heading-=n-this.lastRotation,this.lastRotation=n,this.applyChanges()}else t!==WorldWind.ENDED&&t!==WorldWind.CANCELLED||this.gestureDidEnd()},_.prototype.handleTilt=function(e){var t=e.state,n=e.translationY;if(t===WorldWind.BEGAN)this.gestureDidBegin();else if(t===WorldWind.CHANGED){var r=-90*n/this.wwd.canvas.clientHeight,i=this.lookAt;i.tilt=this.beginLookAt.tilt+r,this.applyChanges()}else t!==WorldWind.ENDED&&t!==WorldWind.CANCELLED||this.gestureDidEnd()},_.prototype.handleWheelEvent=function(e){var t=this.lookAt,n=e.timeStamp;n-this.lastWheelEvent>500&&(this.wwd.cameraAsLookAt(t),this.lastWheelEvent=n);var r;e.deltaMode===WheelEvent.DOM_DELTA_PIXEL?r=e.deltaY:e.deltaMode===WheelEvent.DOM_DELTA_LINE?r=40*e.deltaY:e.deltaMode===WheelEvent.DOM_DELTA_PAGE&&(r=400*e.deltaY);var i=1+r/1e3;t.range*=i,this.applyChanges()},_.prototype.applyChanges=function(){var t=this.lookAt;if(t.position.latitude=y.clamp(t.position.latitude,-90,90),t.position.longitude=e.normalizedDegreesLongitude(t.position.longitude),t.range=y.clamp(t.range,1,Number.MAX_VALUE),t.heading=e.normalizedDegrees(t.heading),t.tilt=y.clamp(t.tilt,0,90),t.roll=e.normalizedDegrees(t.roll),this.wwd.globe.is2D()){var n=2*Math.PI*this.wwd.globe.equatorialRadius;t.range=y.clamp(t.range,1,n),t.tilt=0}this.wwd.cameraFromLookAt(t),this.wwd.redraw()},_.prototype.gestureDidBegin=function(){0==this.activeGestures++&&(this.wwd.cameraAsLookAt(this.beginLookAt),this.lookAt.copy(this.beginLookAt))},_.prototype.gestureDidEnd=function(){this.activeGestures>0&&this.activeGestures--},_}),define("util/ImageSource",["../error/ArgumentError","../util/Color","../util/Logger"],function(e,t,n){"use strict";var r=function(t){if(!t)throw new e(n.logMessage(n.LEVEL_SEVERE,"ImageSource","constructor","missingImage"));this.image=t,this.key="ImageSource "+ ++r.keyPool};return r.keyPool=0,r}),define("shapes/ScreenImage",["../error/ArgumentError","../shaders/BasicTextureProgram","../util/Color","../util/ImageSource","../util/Logger","../geom/Matrix","../util/Offset","../pick/PickedObject","../render/Renderable","../geom/Vec3","../util/WWMath"],function(e,t,n,r,i,s,o,a,l,h,u){"use strict";var c=function(t,r){if(!t)throw new e(i.logMessage(i.LEVEL_SEVERE,"ScreenImage","constructor","missingOffset"));if(!r)throw new e(i.logMessage(i.LEVEL_SEVERE,"ScreenImage","constructor","missingImage"));l.call(this),this.screenOffset=t,this._imageSource=r,this.imageColor=n.WHITE,this.imageOffset=new o(WorldWind.OFFSET_FRACTION,.5,WorldWind.OFFSET_FRACTION,.5),this.imageScale=1,this.imageRotation=0,this.imageTilt=0,this.enabled=!0,this.opacity=1,this.pickDelegate=null,this.activeTexture=null,this.imageTransform=s.fromIdentity(),this.texCoordMatrix=s.fromIdentity(),this.imageBounds=null,this.layer=null};return c.matrix=s.fromIdentity(),c.prototype=Object.create(l.prototype),Object.defineProperties(c.prototype,{imageSource:{get:function(){return this._imageSource},set:function(t){if(!t)throw new e(i.logMessage(i.LEVEL_SEVERE,"ScreenImage","imageSource","missingImage"));this._imageSource=t,this.imageSourceWasUpdated=!0}}}),c.prototype.render=function(e){if(this.enabled&&e.accumulateOrderedRenderables){var t=null;this.lastFrameTime!==e.timestamp&&(t=this.makeOrderedRenderable(e)),t&&t.isVisible(e)&&(t.layer=e.currentLayer,this.lastFrameTime=e.timestamp,e.addOrderedRenderable(t))}},c.prototype.renderOrdered=function(e){if(this.drawOrderedScreenImage(e),e.pickingMode){var t=new a(this.pickColor.clone(),this.pickDelegate?this.pickDelegate:this,null,this.layer,!1);e.resolvePick(t)}},c.prototype.makeOrderedRenderable=function(e){var t,n,r,i,s,o,a;return this.activeTexture=this.getActiveTexture(e),this.activeTexture&&!this.imageSourceWasUpdated||(this.activeTexture=e.gpuResourceCache.retrieveTexture(e.currentGlContext,this._imageSource),this.activeTexture)?(this.eyeDistance=0,t=this.activeTexture.imageWidth,n=this.activeTexture.imageHeight,r=this.imageScale,o=this.imageOffset.offsetForSize(t,n),i=e.viewport.width,s=e.viewport.height,a=this.screenOffset.offsetForSize(i,s),this.imageTransform.setTranslation(a[0]-o[0]*r,a[1]-o[1]*r,0),this.imageTransform.setScale(t*r,n*r,1),this.imageBounds=u.boundingRectForUnitQuad(this.imageTransform),this):null},c.prototype.getActiveTexture=function(e){return e.gpuResourceCache.resourceForKey(this._imageSource)},c.prototype.isVisible=function(e){return e.pickingMode?e.pickRectangle&&this.imageBounds.intersects(e.pickRectangle):this.imageBounds.intersects(e.viewport)},c.prototype.drawOrderedScreenImage=function(e){this.beginDrawing(e);try{this.doDrawOrderedScreenImage(e)}finally{this.endDrawing(e)}},c.prototype.beginDrawing=function(e){var n,r=e.currentGlContext;e.findAndBindProgram(t),n=e.currentProgram,r.bindBuffer(r.ARRAY_BUFFER,e.unitQuadBuffer()),r.vertexAttribPointer(n.vertexTexCoordLocation,2,r.FLOAT,!1,0,0),r.enableVertexAttribArray(n.vertexPointLocation),r.enableVertexAttribArray(n.vertexTexCoordLocation),n.loadTextureUnit(r,r.TEXTURE0),n.loadModulateColor(r,e.pickingMode),r.disable(r.DEPTH_TEST)},c.prototype.endDrawing=function(e){var t=e.currentGlContext,n=e.currentProgram;t.disableVertexAttribArray(n.vertexPointLocation),t.disableVertexAttribArray(n.vertexTexCoordLocation),t.bindBuffer(t.ARRAY_BUFFER,null),t.bindTexture(t.TEXTURE_2D,null),t.enable(t.DEPTH_TEST)},c.prototype.doDrawOrderedScreenImage=function(e){var t=e.currentGlContext,n=e.currentProgram;t.bindBuffer(t.ARRAY_BUFFER,e.unitQuadBuffer3()),t.vertexAttribPointer(n.vertexPointLocation,3,t.FLOAT,!1,0,0),c.matrix.copy(e.screenProjection),c.matrix.multiplyMatrix(this.imageTransform),c.matrix.multiplyByTranslation(.5,.5,.5),c.matrix.multiplyByRotation(1,0,0,this.imageTilt),c.matrix.multiplyByRotation(0,0,1,this.imageRotation),c.matrix.multiplyByTranslation(-.5,-.5,0),n.loadModelviewProjection(t,c.matrix),n.loadTextureEnabled(t,!0),e.pickingMode?(this.pickColor=e.uniquePickColor(),n.loadColor(t,this.pickColor),n.loadOpacity(t,1)):(n.loadColor(t,this.imageColor),n.loadOpacity(t,this.opacity*this.layer.opacity)),this.texCoordMatrix.setToIdentity(),this.texCoordMatrix.multiplyByTextureTransform(this.activeTexture),n.loadTextureMatrix(t,this.texCoordMatrix),this.activeTexture.bind(e)&&t.drawArrays(t.TRIANGLE_STRIP,0,4)},c}),define("render/TextureTile",["../error/ArgumentError","../util/Logger","../util/Tile"],function(e,t,n){"use strict";var r=function(e,t,r,i){n.call(this,e,t,r,i),this.gpuCacheKey=null}
;return r.prototype=Object.create(n.prototype),r.prototype.size=function(){return n.prototype.size.call(this)},r.prototype.bind=function(e){var t=e.gpuResourceCache.resourceForKey(this.gpuCacheKey);return!!t&&t.bind(e)},r.prototype.applyInternalTransform=function(e,t){},r}),define("render/ImageTile",["../error/ArgumentError","../util/Logger","../render/TextureTile","../util/Tile"],function(e,t,n,r){"use strict";var i=function(r,i,s,o,a){if(!a||a.length<1)throw new e(t.logMessage(t.LEVEL_SEVERE,"ImageTile","constructor","The specified image path is null, undefined or zero length."));n.call(this,r,i,s,o),this.imagePath=a,this.fallbackTile=null,this.gpuCacheKey=a};return i.prototype=Object.create(n.prototype),i.prototype.size=function(){return this.__proto__.__proto__.size.call(this)+this.imagePath.length+8},i.prototype.bind=function(e){return!!this.__proto__.__proto__.bind.call(this,e)||!!this.fallbackTile&&this.fallbackTile.bind(e)},i.prototype.applyInternalTransform=function(e,t){this.fallbackTile&&!e.gpuResourceCache.resourceForKey(this.imagePath)&&this.applyFallbackTransform(t)},i.prototype.applyFallbackTransform=function(e){if(!(this.level.levelNumber-this.fallbackTile.level.levelNumber<=0)){var t=this.fallbackTile.sector.deltaLatitude(),n=this.fallbackTile.sector.deltaLongitude(),r=this.sector.deltaLongitude()/n,i=this.sector.deltaLatitude()/t,s=(this.sector.minLongitude-this.fallbackTile.sector.minLongitude)/n,o=(this.sector.minLatitude-this.fallbackTile.sector.minLatitude)/t;e.multiply(r,0,0,s,0,i,0,o,0,0,1,0,0,0,0,1)}},i}),define("layer/TiledImageLayer",["../util/AbsentResourceList","../error/ArgumentError","../render/ImageTile","../layer/Layer","../util/LevelSet","../util/Logger","../geom/Matrix","../cache/MemoryCache","../render/Texture","../util/Tile","../util/WWUtil"],function(e,t,n,r,i,s,o,a,l,h,u){"use strict";var c=function(n,l,h,u,c,d,f,p){if(!l)throw new t(s.logMessage(s.LEVEL_SEVERE,"TiledImageLayer","constructor","missingSector"));if(!h)throw new t(s.logMessage(s.LEVEL_SEVERE,"TiledImageLayer","constructor","The specified level-zero delta is null or undefined."));if(!c)throw new t(s.logMessage(s.LEVEL_SEVERE,"TiledImageLayer","constructor","The specified image format is null or undefined."));if(!d)throw new t(s.logMessage(s.LEVEL_SEVERE,"TiledImageLayer","constructor","The specified cache path is null or undefined."));if(!u||u<1)throw new t(s.logMessage(s.LEVEL_SEVERE,"TiledImageLayer","constructor","The specified number of levels is less than one."));if(!f||!p||f<1||p<1)throw new t(s.logMessage(s.LEVEL_SEVERE,"TiledImageLayer","constructor","The specified tile width or height is less than one."));r.call(this,n||"Tiled Image Layer"),this.retrievalImageFormat=c,this.cachePath=d,this.retrievalQueueSize=WorldWind.configuration.layerRetrievalQueueSize,this.levels=new i(l,h,u,f,p),this.detailControl=1.75,this.crossOrigin="anonymous",this.expiration=null,this.currentTiles=[],this.currentTilesInvalid=!0,this.tileCache=new a(5e5,4e5),this.currentRetrievals=[],this.absentResourceList=new e(3,5e4),this.pickEnabled=!1,this.lasTtMVP=o.fromIdentity()};return c.prototype=Object.create(r.prototype),c.prototype.refresh=function(){this.expiration=new Date,this.currentTilesInvalid=!0},c.prototype.prePopulate=function(e){if(!e)throw new t(s.logMessage(s.LEVEL_SEVERE,"TiledImageLayer","prePopulate","missingWorldWindow"));var n=e.drawContext;this.topLevelTiles&&0!==this.topLevelTiles.length||this.createTopLevelTiles(n);for(var r=0;r<this.topLevelTiles.length;r++){var i=this.topLevelTiles[r];this.isTileTextureInMemory(n,i)||this.retrieveTileImage(n,i,!0)}},c.prototype.prePopulateCurrentTiles=function(e){if(!e)throw new t(s.logMessage(s.LEVEL_SEVERE,"TiledImageLayer","prePopulate","missingWorldWindow"));var n=e.drawContext;this.assembleTiles(n);for(var r=0,i=this.currentTiles.length;r<i;r++){var o=this.currentTiles[r];this.isTileTextureInMemory(n,o)||this.retrieveTileImage(n,o,!0)}},c.prototype.isPrePopulated=function(e){if(!e)throw new t(s.logMessage(s.LEVEL_SEVERE,"TiledImageLayer","isPrePopulated","missingWorldWindow"));for(var n=0;n<this.topLevelTiles.length;n++)if(!this.isTileTextureInMemory(e.drawContext,this.topLevelTiles[n]))return!1;return!0},c.prototype.createTile=function(e,t,r,i){var s=this.cachePath+"-layer/"+t.levelNumber+"/"+r+"/"+r+"_"+i+"."+u.suffixForMimeType(this.retrievalImageFormat);return new n(e,t,r,i,s)},c.prototype.doRender=function(e){if(e.terrain){if(this.currentTilesInvalid||!e.modelviewProjection.equals(this.lasTtMVP)||e.globeStateKey!==this.lastGlobeStateKey)if(this.currentTilesInvalid=!1,e.surfaceOpacity>=1&&this.opacity>=1){this.previousTiles={};for(var t=0;t<this.currentTiles.length;t++)this.previousTiles[this.currentTiles[t].imagePath]=this.currentTiles[t];this.assembleTiles(e),this.fadeOutgoingTiles(e)}else this.assembleTiles(e);this.lasTtMVP.copy(e.modelviewProjection),this.lastGlobeStateKey=e.globeStateKey,this.currentTiles.length>0&&(e.surfaceTileRenderer.renderTiles(e,this.currentTiles,this.opacity,e.surfaceOpacity>=1),e.frameStatistics.incrementImageTileCount(this.currentTiles.length),this.inCurrentFrame=!0)}},c.prototype.fadeOutgoingTiles=function(e){for(var t=(e.timestamp-e.previousRedrawTimestamp)/e.fadeTime,n={},r=0;r<this.currentTiles.length;r++){var i=this.currentTiles[r];n[i.imagePath]=i}for(var s in this.previousTiles)this.previousTiles.hasOwnProperty(s)&&(i=this.previousTiles[s],i.opacity>0&&!n[i.imagePath]&&(i.opacity=Math.max(0,i.opacity-t),i.opacity>0&&(this.currentTiles.push(i),this.currentTilesInvalid=!0,e.redrawRequested=!0)))},c.prototype.isLayerInView=function(e){return e.terrain&&e.terrain.sector&&e.terrain.sector.intersects(this.levels.sector)},c.prototype.createTopLevelTiles=function(e){this.topLevelTiles=[],h.createTilesForLevel(this.levels.firstLevel(),this,this.topLevelTiles)},c.prototype.assembleTiles=function(e){this.currentTiles=[],this.topLevelTiles&&0!==this.topLevelTiles.length||this.createTopLevelTiles(e);for(var t=0,n=this.topLevelTiles.length;t<n;t++){var r=this.topLevelTiles[t];r.update(e),this.currentAncestorTile=null,this.isTileVisible(e,r)&&this.addTileOrDescendants(e,r)}},c.prototype.addTileOrDescendants=function(e,t){if(this.tileMeetsRenderingCriteria(e,t))return void this.addTile(e,t);var n=null;try{(this.isTileTextureInMemory(e,t)||0===t.level.levelNumber)&&(n=this.currentAncestorTile,this.currentAncestorTile=t);for(var r=this.levels.level(t.level.levelNumber+1),i=t.subdivideToCache(r,this,this.tileCache),s=0,o=i.length;s<o;s++){var a=i[s];a.update(e),this.levels.sector.intersects(a.sector)&&this.isTileVisible(e,a)&&this.addTileOrDescendants(e,a)}}finally{n&&(this.currentAncestorTile=n)}},c.prototype.addTile=function(e,t){t.fallbackTile=null;var n=e.gpuResourceCache.resourceForKey(t.imagePath);if(n)return t.opacity=1,this.currentTiles.push(t),void(this.expiration&&this.isTextureExpired(n)&&this.retrieveTileImage(e,t));this.retrieveTileImage(e,t),this.currentAncestorTile&&this.isTileTextureInMemory(e,this.currentAncestorTile)&&(t.fallbackTile=this.currentAncestorTile,t.fallbackTile.opacity=1,this.currentTiles.push(t))},c.prototype.isTileVisible=function(e,t){return!(e.globe.projectionLimits&&!t.sector.overlaps(e.globe.projectionLimits))&&t.extent.intersectsFrustum(e.frustumInModelCoordinates)},c.prototype.tileMeetsRenderingCriteria=function(e,t){var n=this.detailControl;return(t.sector.minLatitude>=75||t.sector.maxLatitude<=-75)&&(n*=1.2),t.level.isLastLevel()||!t.mustSubdivide(e,n)},c.prototype.isTileTextureInMemory=function(e,t){return e.gpuResourceCache.containsResource(t.imagePath)},c.prototype.isTextureExpired=function(e){return this.expiration&&e.creationTime.getTime()<=this.expiration.getTime()},c.prototype.retrieveTileImage=function(e,t,n){if(this.currentRetrievals.indexOf(t.imagePath)<0){if(this.currentRetrievals.length>this.retrievalQueueSize)return;if(this.absentResourceList.isResourceAbsent(t.imagePath))return;var r=this.resourceUrlForTile(t,this.retrievalImageFormat),i=new Image,o=t.imagePath,a=e.gpuResourceCache,l=e.currentGlContext.canvas,h=this;if(!r)return void(this.currentTilesInvalid=!0);i.onload=function(){s.log(s.LEVEL_INFO,"Image retrieval succeeded: "+r);var u=h.createTexture(e,t,i);if(h.removeFromCurrentRetrievals(o),u&&(a.putResource(o,u,u.size),h.currentTilesInvalid=!0,h.absentResourceList.unmarkResourceAbsent(o),!n)){var c=document.createEvent("Event");c.initEvent(WorldWind.REDRAW_EVENT_TYPE,!0,!0),l.dispatchEvent(c)}},i.onerror=function(){h.removeFromCurrentRetrievals(o),h.absentResourceList.markResourceAbsent(o),s.log(s.LEVEL_WARNING,"Image retrieval failed: "+r)},this.currentRetrievals.push(o),i.crossOrigin=this.crossOrigin,i.src=r}},c.prototype.createTexture=function(e,t,n){return new l(e.currentGlContext,n)},c.prototype.removeFromCurrentRetrievals=function(e){var t=this.currentRetrievals.indexOf(e);t>-1&&this.currentRetrievals.splice(t,1)},c.prototype.resourceUrlForTile=function(e,t){return this.urlBuilder?this.urlBuilder.urlForTile(e,t):null},c}),define("layer/MercatorTiledImageLayer",["../util/Color","../geom/Sector","../geom/Location","../layer/TiledImageLayer","../geom/Vec2","../util/WWMath"],function(e,t,n,r,i,s){"use strict";var o=function(e,s,o,a,l,h){function u(e){var t=e*Math.PI,n=Math.exp(t),r=(n-1/n)/2;return 180*Math.atan(r)/Math.PI}var c=new t(u(-1),u(1),-180,180);r.call(this,e,c,function(e){var t=360/(1<<e);return new n(t/2,t)}(h),s-h,o,a,l,l),this.detectBlankImages=!1,this.imageSize=l,this.firstLevelOffset=h,this.testPixels=[new i(20,20),new i(235,20),new i(20,235),new i(235,235)],this.destCanvas=document.createElement("canvas"),this.destContext=this.destCanvas.getContext("2d")};return o.prototype=Object.create(r.prototype),o.prototype.createTile=function(e,n,i,o){var a,l,h,u,c,d,f=this.mapSizeForLevel(n.levelNumber),p=s.clamp(o*this.imageSize,0,f),m=s.clamp(i*this.imageSize,0,f),g=s.clamp(p+this.imageSize,0,f),b=s.clamp(m+this.imageSize,0,f);return a=p/f-.5,l=.5-b/f,h=90-360*Math.atan(Math.exp(2*-l*Math.PI))/Math.PI,u=360*a,a=g/f-.5,l=.5-m/f,c=90-360*Math.atan(Math.exp(2*-l*Math.PI))/Math.PI,d=360*a,e=new t(h,c,u,d),r.prototype.createTile.call(this,e,n,i,o)},o.prototype.createTexture=function(e,t,n){var i,o,a,l,h,u,c,d,f=e.canvas2D,p=e.ctx2D,m=this.destCanvas,g=this.destContext,b=g.createImageData(n.width,n.height),y=t.sector,_=s.gudermannianInverse(y.minLatitude),E=s.gudermannianInverse(y.maxLatitude);if(f.width=n.width,f.height=n.height,m.width=n.width,m.height=n.height,p.drawImage(n,0,0,n.width,n.height),i=p.getImageData(0,0,n.width,n.height),this.detectBlankImages&&this.isBlankImage(n,i))return this.absentResourceList.markResourceAbsentPermanently(t.imagePath),null;for(var v=0;v<1;v++)for(var w=0;w<n.height;w++){c=1-w/(n.height-1),o=c*y.deltaLatitude()+y.minLatitude,a=s.gudermannianInverse(o),d=1-(a-_)/(E-_),d=s.clamp(d,0,1),l=Math.floor(d*(n.height-1));for(var S=0;S<n.width;S++)h=4*(S+l*n.width),u=4*(S+w*n.width),b.data[u]=i.data[h],b.data[u+1]=i.data[h+1],b.data[u+2]=i.data[h+2],b.data[u+3]=i.data[h+3]}return g.putImageData(b,0,0),r.prototype.createTexture.call(this,e,t,m)},o.prototype.isBlankImage=function(e,t){for(var n,r,i=null,s=0,o=this.testPixels.length;s<o;s++)if(n=this.testPixels[s],r=4*(n[0]+n[1]*e.width),i){if(t.data[r]!=i[0]||t.data[r+1]!=i[1]||t.data[r+2]!=i[2])return!1}else i=[t.data[r],t.data[r+1],t.data[r+2]];return!0},o.prototype.mapSizeForLevel=function(e){return this.imageSize<<e+this.firstLevelOffset},o.prototype.resourceUrlForTile=function(e,t){return this.urlBuilder?this.urlBuilder.urlForTile(e,t):this.getImageSourceUrl(e.column,e.row,e.level.levelNumber+this.firstLevelOffset)},o.prototype.getImageSourceUrl=function(e,t,n){return null},o}),define("layer/BingTiledImageLayer",["../util/Color","../shapes/ScreenImage","../layer/MercatorTiledImageLayer"],function(e,t,n){"use strict";var r=function(e){n.call(this,e,23,"image/jpeg",e,256,1),this.pickEnabled=!0,this.detectBlankImages=!0,this.detailControl=1.25};return r.logoImage=null,r.logoLastFrameTime=0,r.prototype=Object.create(n.prototype),r.prototype.doRender=function(e){n.prototype.doRender.call(this,e),this.inCurrentFrame&&this.renderLogo(e)},r.prototype.renderLogo=function(n){r.logoImage||(r.logoImage=new t(WorldWind.configuration.bingLogoPlacement,WorldWind.configuration.baseUrl+"images/powered-by-bing.png"),r.logoImage.imageColor=new e(1,1,1,.5)),r.logoLastFrameTime!==n.timestamp&&(r.logoImage.screenOffset=WorldWind.configuration.bingLogoPlacement,r.logoImage.imageOffset=WorldWind.configuration.bingLogoAlignment,r.logoImage.render(n),r.logoLastFrameTime=n.timestamp)},r}),define("util/BingImageryUrlBuilder",["../error/ArgumentError","../util/Logger","../util/WWUtil"],function(e,t,n){"use strict";var r=function(e,t){var n="AkttWCS8p6qzxvx5RH3qUcCPgwG9nRJ7IwlpFGb14B0rBorB5DvmXr2Y_eCUNIxH";this.bingMapsKey=t,this.bingMapsKey||(this.bingMapsKey=WorldWind.BingMapsKey),this.bingMapsKey||(this.bingMapsKey=n),this.bingMapsKey===n&&r.showBingMapsKeyWarning(),this.imagerySet=e};return r.showBingMapsKeyWarning=function(){r.keyMessagePrinted||(r.keyMessagePrinted=!0,t.log(t.LEVEL_WARNING,"WARNING: You are using a limited use, non-production Bing Maps key.\nIf you are developing an app or a web page this violates the Bing Terms of Use.\nPlease visit https://www.microsoft.com/en-us/maps/create-a-bing-maps-key to obtain your own key for your application.\nSpecify that key to WorldWind by setting the WorldWind.BingMapsKey property to your key prior to creating any Bing Maps layers.\n"))},r.prototype.requestMetadata=function(){if(!this.metadataRetrievalInProcess){this.metadataRetrievalInProcess=!0;var e="https://dev.virtualearth.net/REST/V1/Imagery/Metadata/"+this.imagerySet+"/0,0?zl=1&uriScheme=https&key="+this.bingMapsKey,t=this;n.jsonp(e,"jsonp",function(e){t.imageUrl=e.resourceSets[0].resources[0].imageUrl;var n=document.createEvent("Event");n.initEvent(WorldWind.REDRAW_EVENT_TYPE,!0,!0),window.dispatchEvent(n),t.metadataRetrievalInProcess=!1})}},r.prototype.urlForTile=function(n,r){if(!n)throw new e(t.logMessage(t.LEVEL_SEVERE,"BingImageryUrlBuilder","urlForTile","missingTile"));if(!this.imageUrl)return this.requestMetadata(),null;var i,s=this.quadKeyFromLevelRowColumn(n.level.levelNumber,n.row,n.column);return"Aerial"===this.imagerySet?i=this.imageUrl.replace(/a3/,"a"+s):"AerialWithLabels"===this.imagerySet?i=this.imageUrl.replace(/h3/,"h"+s):"Road"===this.imagerySet&&(i=this.imageUrl.replace(/r3/,"r"+s)),i},r.prototype.quadKeyFromLevelRowColumn=function(e,t,n){for(var r,i,s="",o=e+1;o>0;o--)r=0,i=1<<o-1,0!=(n&i)&&(r+=1),0!=(t&i)&&(r+=2),s+=r.toString();return s},r}),define("layer/BingAerialLayer",["../geom/Location","../geom/Sector","../layer/BingTiledImageLayer","../util/BingImageryUrlBuilder"],function(e,t,n,r){"use strict";var i=function(e){n.call(this,"Bing Aerial"),this.urlBuilder=new r("Aerial",e)};return i.prototype=Object.create(n.prototype),i}),define("layer/BingAerialWithLabelsLayer",["../geom/Location","../geom/Sector","../layer/BingTiledImageLayer","../util/BingImageryUrlBuilder"],function(e,t,n,r){"use strict";var i=function(e){n.call(this,"Bing Aerial with Labels"),this.urlBuilder=new r("AerialWithLabels",e)};return i.prototype=Object.create(n.prototype),i}),define("layer/BingRoadsLayer",["../geom/Location","../geom/Sector","../layer/BingTiledImageLayer","../util/BingImageryUrlBuilder"],function(e,t,n,r){"use strict";var i=function(e){n.call(this,"Bing Roads"),this.urlBuilder=new r("Road",e),this.detectBlankImages=!1};return i.prototype=Object.create(n.prototype),i}),define("layer/BingWMSLayer",["../geom/Location","../geom/Sector","../layer/TiledImageLayer","../util/WmsUrlBuilder"],function(e,t,n,r){"use strict";var i=function(){n.call(this,t.FULL_SPHERE,new e(45,45),16,"image/png","BingWMS",256,256),this.displayName="Bing WMS",this.pickEnabled=!1,this.maxActiveAltitude=1e4,this.urlBuilder=new r("https://worldwind27.arc.nasa.gov/wms/virtualearth","ve","","1.3.0")};return i.prototype=Object.create(n.prototype),i}),define("layer/BMNGLandsatLayer",["../geom/Location","../geom/Sector","../layer/TiledImageLayer","../util/WmsUrlBuilder"],function(e,t,n,r){"use strict";var i=function(){n.call(this,"Blue Marble & Landsat",t.FULL_SPHERE,new e(45,45),12,"image/jpeg","BMNGLandsat256",256,256),this.urlBuilder=new r("https://worldwind25.arc.nasa.gov/wms","BlueMarble-200405,esat","","1.3.0")};return i.prototype=Object.create(n.prototype),i}),define("layer/BMNGLayer",["../geom/Location","../geom/Sector","../layer/TiledImageLayer","../util/WmsUrlBuilder"],function(e,t,n,r){"use strict";var i=function(i){n.call(this,"Blue Marble",t.FULL_SPHERE,new e(45,45),7,"image/jpeg",i||"BMNG256",256,256),this.urlBuilder=new r("https://worldwind25.arc.nasa.gov/wms",i||"BlueMarble-200405","","1.3.0")};return i.prototype=Object.create(n.prototype),i}),define("layer/RenderableLayer",["../error/ArgumentError","../layer/Layer","../util/Logger"],function(e,t,n){"use strict";var r=function(e){t.call(this,e),this.renderables=[]};return r.prototype=Object.create(t.prototype),r.prototype.addRenderable=function(t){if(!t)throw new e(n.logMessage(n.LEVEL_SEVERE,"RenderableLayer","addRenderable","missingRenderable"));this.renderables.push(t)},r.prototype.addRenderables=function(t){if(!t)throw new e(n.logMessage(n.LEVEL_SEVERE,"RenderableLayer","addRenderables","The renderables array is null or undefined."));for(var r=0,i=t.length;r<i;r++)this.addRenderable(t[r])},r.prototype.removeRenderable=function(e){var t=this.renderables.indexOf(e);t>=0&&this.renderables.splice(t,1)},r.prototype.removeAllRenderables=function(){this.renderables=[]},r.prototype.doRender=function(e){for(var t=e.orderedRenderables.length,r=0,i=this.renderables.length;r<i;r++)try{this.renderables[r].render(e)}catch(e){n.logMessage(n.LEVEL_SEVERE,"RenderableLayer","doRender","Error while rendering shape "+this.renderables[r].displayName+".\n"+e.toString())}e.orderedRenderables.length>t&&(this.inCurrentFrame=!0)},r}),define("render/SurfaceTile",["../error/ArgumentError","../util/Logger","../geom/Matrix","../geom/Sector","../error/UnsupportedOperationError"],function(e,t,n,r,i){"use strict";var s=function(n){if(!n)throw new e(t.logMessage(t.LEVEL_SEVERE,"SurfaceTile","constructor","missingSector"));this.sector=n};return s.prototype.bind=function(e){throw new i(t.logMessage(t.LEVEL_SEVERE,"SurfaceTile","bind","abstractInvocation"))},s.prototype.applyInternalTransform=function(e,n){throw new i(t.logMessage(t.LEVEL_SEVERE,"SurfaceTile","applyInternalTransform","abstractInvocation"))},s}),define("shapes/SurfaceImage",["../error/ArgumentError","../util/Logger","../pick/PickedObject","../render/SurfaceTile"],function(e,t,n,r){"use strict";var i=function(n,i){if(!n)throw new e(t.logMessage(t.LEVEL_SEVERE,"SurfaceImage","constructor","missingSector"));if(!i)throw new e(t.logMessage(t.LEVEL_SEVERE,"SurfaceImage","constructor","missingImage"));r.call(this,n),this.enabled=!0,this._imageSource=i,this.resamplingMode=WorldWind.FILTER_LINEAR,this.opacity=1,this.displayName="Surface Image",this.imageSourceWasUpdated=!0};return i.prototype=Object.create(r.prototype),Object.defineProperties(i.prototype,{imageSource:{get:function(){return this._imageSource},set:function(n){if(!n)throw new e(t.logMessage(t.LEVEL_SEVERE,"SurfaceImage","imageSource","missingImage"));this._imageSource=n,this.imageSourceWasUpdated=!0}}}),i.prototype.bind=function(e){var t=e.gpuResourceCache.resourceForKey(this._imageSource);return t&&!this.imageSourceWasUpdated?this.bindTexture(e,t):(t=e.gpuResourceCache.retrieveTexture(e.currentGlContext,this._imageSource),this.imageSourceWasUpdated=!1,t?this.bindTexture(e,t):void 0)},i.prototype.bindTexture=function(e,t){var n=e.currentGlContext;return t.setTexParameter(n.TEXTURE_MAG_FILTER,this.resamplingMode===WorldWind.FILTER_NEAREST?n.NEAREST:n.LINEAR),t.bind(e)},i.prototype.applyInternalTransform=function(e,t){},i.prototype.render=function(e){if(this.enabled&&e.terrain&&this.sector.overlaps(e.terrain.sector)){if(e.pickingMode&&(this.pickColor=e.uniquePickColor()),e.surfaceTileRenderer.renderTiles(e,[this],this.opacity*e.currentLayer.opacity),e.pickingMode){var t=new n(this.pickColor.clone(),this.pickDelegate?this.pickDelegate:this,null,this.layer,!1);e.resolvePick(t)}e.currentLayer.inCurrentFrame=!0}},i}),define("layer/BMNGOneImageLayer",["../layer/RenderableLayer","../geom/Sector","../shapes/SurfaceImage","../util/WWUtil"],function(e,t,n,r){"use strict";var i=function(){e.call(this,"Blue Marble Image");var r=new n(t.FULL_SPHERE,WorldWind.configuration.baseUrl+"images/BMNG_world.topo.bathy.200405.3.2048x1024.jpg");this.addRenderable(r),this.pickEnabled=!1,this.minActiveAltitude=3e6};return i.prototype=Object.create(e.prototype),i}),define("util/PeriodicTimeSequence",["../error/ArgumentError","../util/Logger"],function(e,t){"use strict";var n=function(r){if(!r)throw new e(t.logMessage(t.LEVEL_SEVERE,"PeriodicTimeSequence","constructor","missingString"));var i=r.split("/");if(3!==i.length)throw new e(t.logMessage(t.LEVEL_SEVERE,"PeriodicTimeSequence","constructor","The interval string "+r+" does not contain 3 elements."));this.sequenceString=r,this.startTime=new Date(i[0]),this.endTime=new Date(i[1]),this.intervalMilliseconds=this.endTime.getTime()-this.startTime.getTime(),this._currentTime=this.startTime,this.infiniteInterval=this.startTime.getTime()==this.endTime.getTime(),this.period=n.parsePeriodString(i[2],!1)};return Object.defineProperties(n.prototype,{currentTime:{get:function(){return this._currentTime},set:function(e){this._currentTime=e}},scaleForCurrentTime:{get:function(){return this.currentTime?(this.currentTime.getTime()-this.startTime.getTime())/this.intervalMilliseconds:1}}}),n.prototype.next=function(){return this.currentTime?this.currentTime.getTime()>=this.endTime.getTime()&&!this.infiniteInterval?this.currentTime=null:this.currentTime=n.incrementTime(this.currentTime,this.period):this.currentTime=this.startTime,this.currentTime},n.prototype.previous=function(){return this.currentTime?this.currentTime.getTime()===this.startTime.getTime()?this.currentTime=null:this.currentTime=this.getTimeForScale(.9999*this.scaleForCurrentTime):this.currentTime=this.endTime,this.currentTime},n.prototype.reset=function(){this.currentTime=null},n.prototype.getTimeForScale=function(e){if(e<=0)return this.startTime;if(e>=1)return this.endTime;var t=new Date(this.startTime.getTime()),r=t,i=0;for(i=0;i<e;i=(t.getTime()-this.startTime.getTime())/this.intervalMilliseconds)r=t,t=n.incrementTime(t,this.period);return r},n.incrementTime=function(e,t){var r=new Date(e.getTime());return 0!=t[0]&&r.setUTCFullYear(r.getUTCFullYear()+t[0]),0!=t[1]&&n.addMonths(r,t[1]),0!=t[2]&&r.setUTCDate(r.getUTCDate()+7*t[2]),0!=t[3]&&r.setUTCDate(r.getUTCDate()+t[3]),0!=t[4]&&r.setUTCHours(r.getUTCHours()+t[4]),0!=t[5]&&r.setUTCMinutes(r.getUTCMinutes()+t[5]),0!=t[6]&&r.setUTCSeconds(r.getUTCSeconds()+t[6]),r},n.isLeapYear=function(e){return e%4==0&&e%100!=0||e%400==0},n.getDaysInMonth=function(e,t){return[31,n.isLeapYear(e)?29:28,31,30,31,30,31,31,30,31,30,31][t]},n.addMonths=function(e,t){var r=e.getUTCDate();return e.setUTCDate(1),e.setUTCMonth(e.getUTCMonth()+t),e.setUTCDate(Math.min(r,n.getDaysInMonth(e.getUTCFullYear(),e.getUTCMonth()))),e},n.parsePeriodString=function(n,r){var i,s=r||!1,o=[2,3,4,5,7,8,9],a=[0,0,0,0,0,0,0],l=[0,12,4,7,24,60,60];if(!(n=n.toUpperCase().trim()))return a;if("string"!=typeof n)throw new e(t.logMessage(t.LEVEL_SEVERE,"PeriodicTimeSequence","parsePeriodString","Invalid ISO8601 period string '"+n+"'"));if(!(i=/^P((\d+Y)?(\d+M)?(\d+W)?(\d+D)?)?(T(\d+H)?(\d+M)?(\d+S)?)?$/.exec(n)))throw new e(t.logMessage(t.LEVEL_SEVERE,"PeriodicTimeSequence","parsePeriodString","String '"+n+"' is not a valid ISO8601 period."));for(var h=0;h<o.length;h++){var u=o[h];a[h]=i[u]?+i[u].replace(/[A-Za-z]+/g,""):0}if(s)for(h=a.length-1;h>0;h--)a[h]>=l[h]&&(a[h-1]=a[h-1]+Math.floor(a[h]/l[h]),a[h]=a[h]%l[h]);return a},n}),define("util/LevelRowColumnUrlBuilder",["../error/ArgumentError","../util/Logger","../util/WWUtil"],function(e,t,n){"use strict";var r=function(e,t){this.serverAddress=e,e&&0!==e.length||(this.serverAddress=n.currentUrlSansFilePart()),this.pathToData=t};return r.prototype.urlForTile=function(r,i){if(!r)throw new e(t.logMessage(t.LEVEL_SEVERE,"WmsUrlBuilder","urlForTile","missingTile"));if(!i)throw new e(t.logMessage(t.LEVEL_SEVERE,"WmsUrlBuilder","urlForTile","The image format is null or undefined."));var s=this.serverAddress;return this.pathToData&&(s=s+"/"+this.pathToData),s=s+"/"+r.level.levelNumber.toString(),s=s+"/"+r.row.toString(),s=s+"/"+r.row.toString()+"_"+r.column.toString(),s=s+"."+n.suffixForMimeType(i),s=s.replace(" ","%20")},r}),define("layer/RestTiledImageLayer",["../error/ArgumentError","../geom/Location","../util/Logger","../geom/Sector","../layer/TiledImageLayer","../util/LevelRowColumnUrlBuilder","../util/WWUtil"],function(e,t,n,r,i,s,o){"use strict";var a=function(e,n,a,l){var h=o.urlPath(e+"/"+n);i.call(this,a,l&&l.sector||r.FULL_SPHERE,l&&l.levelZeroTileDelta||new t(45,45),l&&l.numLevels||5,l&&l.imageFormat||"image/jpeg",h,l&&l.tileWidth||256,l&&l.tileHeight||256),this.urlBuilder=new s(e,n)};return a.prototype=Object.create(i.prototype),a}),define("layer/BMNGRestLayer",["../error/ArgumentError","../layer/Layer","../util/Logger","../util/PeriodicTimeSequence","../layer/RestTiledImageLayer"],function(e,t,n,r,i){"use strict";var s=function(e,n,i,o){t.call(this,i||"Blue Marble time series"),this.time=o||new Date("2004-01"),this.timeSequence=new r("2004-01-01/2004-12-01/P1M"),this.serverAddress=e,this.pathToData=n,this.layers={},this.layerNames=[{month:"BlueMarble-200401",time:s.availableTimes[0]},{month:"BlueMarble-200402",time:s.availableTimes[1]},{month:"BlueMarble-200403",time:s.availableTimes[2]},{month:"BlueMarble-200404",time:s.availableTimes[3]},{month:"BlueMarble-200405",time:s.availableTimes[4]},{month:"BlueMarble-200406",time:s.availableTimes[5]},{month:"BlueMarble-200407",time:s.availableTimes[6]},{month:"BlueMarble-200408",time:s.availableTimes[7]},{month:"BlueMarble-200409",time:s.availableTimes[8]},{month:"BlueMarble-200410",time:s.availableTimes[9]},{month:"BlueMarble-200411",time:s.availableTimes[10]},{month:"BlueMarble-200412",time:s.availableTimes[11]}],this.pickEnabled=!1};return s.prototype=Object.create(t.prototype),s.availableTimes=[new Date("2004-01"),new Date("2004-02"),new Date("2004-03"),new Date("2004-04"),new Date("2004-05"),new Date("2004-06"),new Date("2004-07"),new Date("2004-08"),new Date("2004-09"),new Date("2004-10"),new Date("2004-11"),new Date("2004-12")],s.prototype.prePopulate=function(t){if(!t)throw new e(n.logMessage(n.LEVEL_SEVERE,"BMNGRestLayer","prePopulate","missingWorldWindow"));for(var r=0;r<this.layerNames.length;r++){var i=this.layerNames[r].month;this.layers[i]||this.createSubLayer(i),this.layers[i].prePopulate(t)}},s.prototype.isPrePopulated=function(e){for(var t=0;t<this.layerNames.length;t++){var n=this.layers[this.layerNames[t].month];if(!n||!n.isPrePopulated(e))return!1}return!0},s.prototype.doRender=function(e){var t=this.nearestLayer(this.time);t.opacity=this.opacity,this.detailControl&&(t.detailControl=this.detailControl),t.doRender(e),this.inCurrentFrame=t.inCurrentFrame},s.prototype.nearestLayer=function(e){var t=this.nearestLayerName(e);return this.layers[t]||this.createSubLayer(t),this.layers[t]},s.prototype.createSubLayer=function(e){var t="";t=this.pathToData?this.pathToData+"/"+e:e,this.layers[e]=new i(this.serverAddress,t,this.displayName)},s.prototype.nearestLayerName=function(e){var t=e.getTime();if(t<=this.layerNames[0].time.getTime())return this.layerNames[0].month;if(t>=this.layerNames[11].time.getTime())return this.layerNames[11].month;for(var n=0;n<this.layerNames.length-1;n++){var r=this.layerNames[n].time.getTime(),i=this.layerNames[n+1].time.getTime();if(t>=r&&t<=i){return t-r<i-t?this.layerNames[n].month:this.layerNames[n+1].month}}},s}),define("formats/collada/ColladaAsset",[],function(){"use strict";var e=function(e){this.xmlAsset=e.getElementsByTagName("asset")[0],this.asset={daeVersion:e.querySelector("COLLADA").getAttribute("version")}};return e.prototype.parse=function(){if(!this.xmlAsset)return null;for(var e=0;e<this.xmlAsset.childNodes.length;e++){var t=this.xmlAsset.childNodes.item(e);if(1===t.nodeType)switch(t.nodeName){case"contributor":var n=t.querySelector("authoring_tool");n&&(this.asset.authoring_tool=n.textContext);break;case"unit":this.asset.unit=t.getAttribute("meter");break;default:this.asset[t.localName]=t.textContent}}return this.xmlAsset=null,this.asset},e}),define("formats/collada/ColladaUtils",["../../util/Logger"],function(e){"use strict";return{getRawValues:function(e){if(!e)return null;var t=e.textContent;return t=t.replace(/\n/gi," "),t=t.replace(/\s+/gi," "),t=t.trim(),0===t.length?null:t.split(" ")},bufferDataFloat32:function(e){var t=this.getRawValues(e);if(!t)return null;for(var n=t.length,r=new Float32Array(n),i=0;i<n;i++)r[i]=parseFloat(t[i]);return r},bufferDataUInt32:function(e){var t=this.getRawValues(e);if(!t)return null;for(var n=t.length,r=new Uint32Array(n),i=0;i<n;i++)r[i]=parseInt(t[i]);return r},getFirstChildElement:function(e,t){for(var n=e.childNodes,r=0;r<n.length;++r){var i=n.item(r);if(1===i.nodeType&&(i.nodeName&&!t||t&&t===i.nodeName))return i}return null},getFilename:function(e){var t=e.lastIndexOf("\\");return-1!==t&&(e=e.substr(t+1)),t=e.lastIndexOf("/"),-1!==t&&(e=e.substr(t+1)),e},replaceSpace:function(e){return e?e.replace(/ /g,"_"):""},querySelectorById:function(e,t){for(var n=0;n<e.length;n++){var r=e.item(n).getAttribute("id");if(r&&r.toString()===t)return e.item(n)}return null},getTextureType:function(e){for(var t=!0,n=0,r=e.length;n<r;n++)if(e[n]<0||e[n]>1){t=!1;break}return t},fetchFile:function(t,n){var r=new XMLHttpRequest;r.onload=function(){this.status>=200&&this.status<400?n(this.response):(e.log(e.LEVEL_SEVERE,"sever error: "+this.status),n(null))},r.onerror=function(t){e.log(e.LEVEL_SEVERE,"connection error: "+t),n(null)},r.open("get",t,!0),r.send()}}}),define("formats/collada/ColladaImage",["./ColladaUtils"],function(e){"use strict";var t=function(e,t){this.filename="",this.map=e,this.name=t,this.path=""};return t.prototype.parse=function(t){for(var n=0;n<t.childNodes.length;n++){var r=t.childNodes[n];if(1===r.nodeType)switch(r.nodeName){case"init_from":this.filename=e.getFilename(r.textContent),this.path=r.textContent}}return this},t}),define("formats/collada/ColladaMaterial",["./ColladaUtils"],function(e){"use strict";var t=function(e){this.id=e,this.newParams=[]};return t.prototype.parse=function(e){for(var t=0;t<e.childNodes.length;t++){var n=e.childNodes[t];if(1===n.nodeType)switch(n.nodeName){case"profile_COMMON":this.parseProfileCommon(n)}}return this},t.prototype.parseProfileCommon=function(e){for(var t=0;t<e.childNodes.length;t++){var n=e.childNodes[t];if(1===n.nodeType)switch(n.nodeName){case"newparam":this.parseNewparam(n);break;case"image":break;case"technique":this.parseTechnique(n)}}},t.prototype.parseNewparam=function(e){for(var t=e.getAttribute("sid"),n=0;n<e.childNodes.length;n++){var r=e.childNodes[n];if(1===r.nodeType)switch(r.nodeName){case"surface":var i=r.querySelector("init_from");i&&this.newParams.push({sid:t,type:"surface",initFrom:i.textContent});break;case"sampler2D":var s=r.querySelector("source");this.newParams.push({sid:t,type:"sampler2D",source:s.textContent})}}},t.prototype.parseTechnique=function(e){for(var t=0;t<e.childNodes.length;t++){var n=e.childNodes[t];if(1===n.nodeType)switch(n.nodeName){case"constant":case"lambert":case"blinn":case"phong":this.techniqueType=n.nodeName,this.parseTechniqueType(n)}}},t.prototype.parseTechniqueType=function(t){for(var n=0;n<t.childNodes.length;n++){var r=t.childNodes[n];if(1===r.nodeType&&r.nodeName){var i=r.nodeName,s=e.getFirstChildElement(r);if(s)switch(s.nodeName){case"color":this[i]=e.bufferDataFloat32(s).subarray(0,4)
;break;case"float":this[i]=e.bufferDataFloat32(s)[0];break;case"texture":var o=s.getAttribute("texture"),a=this.newParams.map(function(e){return e.sid}).indexOf(o),l=this.newParams[a].source;a=this.newParams.map(function(e){return e.sid}).indexOf(l);var h=this.newParams[a].initFrom;this.textures||(this.textures={}),this.textures[i]={mapId:h}}}}},t}),define("formats/collada/ColladaMesh",["./ColladaUtils"],function(e){"use strict";var t=function(e){this.filename=e||"",this.name=e||"",this.buffers=[]};return t.prototype.parse=function(t){for(var n={},r={},i={id:"",inputs:[]},s=0;s<t.childNodes.length;s++){var o=t.childNodes[s];if(1===o.nodeType)switch(o.nodeName){case"source":if(!o.querySelector)continue;var a=o.querySelector("float_array");if(!a)continue;var l=e.bufferDataFloat32(a),h=o.querySelector("accessor"),u=parseInt(h.getAttribute("stride"));n[o.getAttribute("id")]={stride:u,data:l};break;case"vertices":this.parseVertices(o,i);break;case"triangles":r=this.parsePolygons(o,n,i,3),this.buffers.push(r);break;case"polygons":r=this.parsePolygons(o,n,i,4),this.buffers.push(r);break;case"polylist":r=this.parsePolygons(o,n,i,null),this.buffers.push(r)}}return this},t.prototype.parseVertices=function(e,t){t.id=e.getAttribute("id");for(var n=e.querySelectorAll("input"),r=0;r<n.length;r++){var i=n[r],s=i.getAttribute("source").substr(1),o=i.getAttribute("semantic").toUpperCase();t.inputs.push({semantic:o,source:s})}},t.prototype.parsePolygons=function(e,t,n,r){var i=[];if(null==r){i=e.querySelector("vcount").textContent.trim().split(" ")}var s=parseInt(e.getAttribute("count")),o=e.getAttribute("material"),a=this.parseInputs(e,t,n),l=a.inputs,h=a.maxOffset,u=e.querySelector("p"),c=[];u&&(c=u.textContent.trim().split(" "));for(var d=l.length,f=0,p={},m=[],g=0,b=!1,y=!1,_=0;_<s;_++){if(i.length)var E=parseInt(i[_]);else E=r;for(var v=-1,w=-1,S=-1,T=0;T<E;T++){var L=c.slice(g,g+h).join(" ");if(S=w,p.hasOwnProperty(L))w=p[L],b=!0;else{for(var x=0;x<d;x++){var R=l[x],A=R[4],C=parseInt(c[g+A]),M=R[1],k=R[3];C*=R[2];for(var I=0;I<R[2];I++)M.push(k[C+I])}w=f,f+=1,p[L]=w}E>3&&(0===T&&(v=w),T>2*h&&((v>65535||S>65535)&&(y=!0),m.push(v),m.push(S))),w>65535&&(y=!0),m.push(w),g+=h}}var O={vertices:new Float32Array(l[0][1]),indexedRendering:b,material:o};return O.indexedRendering&&(O.indices=y?new Uint32Array(m):new Uint16Array(m)),this.transformMeshInfo(O,l),O},t.prototype.parseInputs=function(e,t,n){for(var r=[],i=0,s=e.querySelectorAll("input"),o=0;o<s.length;o++){var a=s.item(o);if(a.getAttribute){var l=a.getAttribute("semantic").toUpperCase(),h=a.getAttribute("source").substr(1),u=parseInt(a.getAttribute("offset"));i=i<u+1?u+1:i;var c=0;if(a.getAttribute("set")&&(c=parseInt(a.getAttribute("set"))),n.id===h)for(var d=n.inputs,f=0;f<d.length;f++){var p=t[d[f].source];p&&r.push([d[f].semantic,[],p.stride,p.data,u,c])}else p=t[h],r.push([l,[],p.stride,p.data,u,c])}}return{inputs:r,maxOffset:i}},t.prototype.transformMeshInfo=function(t,n){for(var r={normal:"normals",texcoord:"uvs"},i=1;i<n.length;i++){var s=n[i][0].toLowerCase(),o=n[i][1];o.length&&(r[s]&&(s=r[s]),t[s]&&(s+=n[i][5]),t[s]=new Float32Array(o),"uvs"===s&&(t.isClamp=e.getTextureType(o)))}return t},t}),define("formats/collada/ColladaNode",["./ColladaUtils","../../geom/Matrix","../../geom/Vec3"],function(e,t,n){"use strict";var r=function(e){this.children=[],this.materials=[],this.mesh="",e?(this.id=e.id,this.name=e.name,this.sid=e.sid,this.localMatrix=e.localMatrix.clone(),this.worldMatrix=e.worldMatrix.clone()):(this.id="",this.name="",this.sid="",this.localMatrix=t.fromIdentity(),this.worldMatrix=t.fromIdentity())};return r.prototype.parse=function(e,n,i){var s=[this],o=this;this.id=e.getAttribute("id"),this.sid=e.getAttribute("sid"),this.name=e.getAttribute("name"),this.children=[],this.materials=[],this.mesh="",this.localMatrix=t.fromIdentity(),this.worldMatrix=t.fromIdentity(),this.setNodeTransforms(e,i);for(var a=0;a<e.childNodes.length;a++){var l=e.childNodes[a];if(1===l.nodeType)switch(l.nodeName){case"node":var h=(new r).parse(l,n,this.worldMatrix);if(h)for(var u=0,c=h.length;u<c;u++)this.children.push(h[u]);break;case"instance_geometry":""!==o.mesh&&(o=new r(o),s.push(o)),o.mesh=l.getAttribute("url").substr(1);for(var d=l.querySelectorAll("instance_material"),u=0;u<d.length;u++){var f=d.item(u);o.materials.push({id:f.getAttribute("target").substr(1),symbol:f.getAttribute("symbol")})}break;case"instance_node":var p=l.getAttribute("url").substr(1),m=this.getLibraryNode(n,p);if(m){var h=(new r).parse(m,n,this.worldMatrix);if(h)for(var u=0,c=h.length;u<c;u++)this.children.push(h[u])}}}return s},r.prototype.setNodeTransforms=function(r,i){var s=t.fromIdentity(),o=t.fromIdentity(),a=t.fromIdentity(),l=t.fromIdentity();i||(i=t.fromIdentity());for(var h=[],u=0;u<r.childNodes.length;u++){var c=r.childNodes[u];if(1===c.nodeType)switch(c.nodeName){case"matrix":var d=e.bufferDataFloat32(c);s.copy(d),h.push(s);break;case"rotate":d=e.bufferDataFloat32(c),o.multiplyByRotation(d[0],d[1],d[2],d[3]),h.push(o);break;case"translate":d=e.bufferDataFloat32(c),a.multiplyByTranslation(d[0],d[1],d[2]),h.push(a);break;case"scale":d=e.bufferDataFloat32(c),l.multiplyByScale(d[0],d[1],d[2]),h.push(l)}}for(u=0;u<h.length;u++)this.localMatrix.multiplyMatrix(h[u]);this.worldMatrix.setToMultiply(i,this.localMatrix),this.normalMatrix=t.fromIdentity();var f=new n(0,0,0);this.worldMatrix.extractRotationAngles(f),this.normalMatrix.multiplyByRotation(-1,0,0,f[0]),this.normalMatrix.multiplyByRotation(0,-1,0,f[1]),this.normalMatrix.multiplyByRotation(0,0,-1,f[2])},r.prototype.getLibraryNode=function(e,t){for(var n=0;n<e.length;n++){var r=e[n].attributes.getNamedItem("id");if(r&&r.value===t)return e[n]}return null},r}),define("globe/ElevationModel",["../error/ArgumentError","../geom/Angle","../geom/Location","../util/Logger"],function(e,t,n,r){"use strict";var i=function(){this.id=0,this.stateKey="",this.coverages=[],this.scratchLocation=new n(0,0),this.computeStateKey()};return Object.defineProperties(i.prototype,{timestamp:{get:function(){var e,t,n=0;for(e=0,t=this.coverages.length;e<t;e++){var r=this.coverages[e];n<r.timestamp&&(n=r.timestamp)}return n}},minElevation:{get:function(){for(var e=Number.MAX_VALUE,t=0,n=this.coverages.length;t<n;t++){var r=this.coverages[t];r.enabled&&r.minElevation<e&&(e=r.minElevation)}return e!==Number.MAX_VALUE?e:0}},maxElevation:{get:function(){for(var e=-Number.MAX_VALUE,t=0,n=this.coverages.length;t<n;t++){var r=this.coverages[t];r.enabled&&r.maxElevation>e&&(e=r.maxElevation)}return e!==-Number.MAX_VALUE?e:0}}}),i.idPool=0,i.prototype.computeStateKey=function(){this.id=++i.idPool,this.stateKey="elevationModel "+this.id.toString()+" "},i.prototype.coverageComparator=function(e,t){var n=e.resolution,r=t.resolution;return n>r?-1:n===r?0:1},i.prototype.performCoverageListChangedActions=function(){this.coverages.length>1&&this.coverages.sort(this.coverageComparator),this.computeStateKey()},i.prototype.addCoverage=function(t){if(!t)throw new e(r.logMessage(r.LEVEL_SEVERE,"ElevationModel","addCoverage","missingCoverage"));return!this.containsCoverage(t)&&(this.coverages.push(t),this.performCoverageListChangedActions(),!0)},i.prototype.removeAllCoverages=function(){this.coverages.length>0&&(this.coverages=[],this.performCoverageListChangedActions())},i.prototype.removeCoverage=function(t){if(!t)throw new e(r.logMessage(r.LEVEL_SEVERE,"ElevationModel","removeCoverage","missingCoverage"));var n=this.coverages.indexOf(t);n>=0&&(this.coverages.splice(n,1),this.performCoverageListChangedActions())},i.prototype.containsCoverage=function(t){if(!t)throw new e(r.logMessage(r.LEVEL_SEVERE,"ElevationModel","containsCoverage","missingCoverage"));return this.coverages.indexOf(t)>=0},i.prototype.minAndMaxElevationsForSector=function(t){if(!t)throw new e(r.logMessage(r.LEVEL_SEVERE,"ElevationModel","minAndMaxElevationsForSector","missingSector"));for(var n=[Number.MAX_VALUE,-Number.MAX_VALUE],i=this.coverages.length-1;i>=0;i--){var s=this.coverages[i];if(s.enabled&&s.coverageSector.intersects(t)&&s.minAndMaxElevationsForSector(t,n))break}return n[0]!==Number.MAX_VALUE?n:[0,0]},i.prototype.elevationAtLocation=function(e,t){var n,r=this.coverages.length;for(n=r-1;n>=0;n--){var i=this.coverages[n];if(i.enabled&&i.coverageSector.containsLocation(e,t)){var s=i.elevationAtLocation(e,t);if(null!==s)return s}}return 0},i.prototype.preferredCoverageIndex=function(e,t,n){var r,i=this.coverages.length,s=Number.MAX_VALUE,o=-1;for(r=0;r<i;r++){var a=this.coverages[r];if(a.enabled&&(null!==e&&a.coverageSector.intersects(e)||null!==t&&a.coverageSector.containsLocation(t.latitude,t.longitude))){var l=Math.abs(a.resolution-n);if(l>s)return o;s=l,o=r}}return o},i.prototype.bestCoverageAtLocation=function(t,n,i){if(!i||i<0)throw new e(r.logMessage(r.LEVEL_SEVERE,"ElevationModel","bestCoverageAtLocation","invalidResolution"));this.scratchLocation.set(t,n);var s=this.preferredCoverageIndex(null,this.scratchLocation,i);return s>=0?this.coverages[s]:null},i.prototype.elevationsForGrid=function(t,n,i,s,o){if(!t)throw new e(r.logMessage(r.LEVEL_SEVERE,"ElevationModel","elevationsForGrid","missingSector"));if(!n||!i||n<1||i<1)throw new e(r.logMessage(r.LEVEL_SEVERE,"ElevationModel","elevationsForGrid","The specified number of latitudinal or longitudinal positions is less than one."));if(!s)throw new e(r.logMessage(r.LEVEL_SEVERE,"ElevationModel","elevationsForGrid","missingTargetResolution"));if(!o)throw new e(r.logMessage(r.LEVEL_SEVERE,"ElevationModel","elevationsForGrid","missingResult"));o.fill(NaN);var a=Number.MAX_VALUE,l=!1,h=this.preferredCoverageIndex(t,null,s);if(h>=0)for(var u=h;!l&&u>=0;u--){var c=this.coverages[u];c.enabled&&c.coverageSector.intersects(t)&&(l=c.elevationsForGrid(t,n,i,o))&&(a=c.resolution)}if(!l){var d=o.length;for(u=0;u<d;u++)isNaN(o[u])&&(o[u]=0)}return a},i}),define("projections/GeographicProjection",["../error/ArgumentError","../util/Logger","../geom/Sector","../error/UnsupportedOperationError"],function(e,t,n,r){"use strict";var i=function(e,t,n){this.displayName=e||"Geographic Projection",this.continuous=t,this.projectionLimits=n,this.is2D=!0};return i.prototype.geographicToCartesian=function(e,n,i,s,o,a){throw new r(t.logMessage(t.LEVEL_SEVERE,"GeographicProjection","geographicToCartesian","abstractInvocation"))},i.prototype.geographicToCartesianGrid=function(e,n,i,s,o,a,l,h){throw new r(t.logMessage(t.LEVEL_SEVERE,"GeographicProjection","geographicToCartesianGrid","abstractInvocation"))},i.prototype.cartesianToGeographic=function(e,n,i,s,o,a){throw new r(t.logMessage(t.LEVEL_SEVERE,"GeographicProjection","cartesianToGeographic","abstractInvocation"))},i.prototype.northTangentAtLocation=function(n,r,i,s){if(!s)throw new e(t.logMessage(t.LEVEL_SEVERE,"ProjectionEquirectangular","northTangentAtLocation","missingResult"));return s[0]=0,s[1]=1,s[2]=0,s},i.prototype.northTangentAtPoint=function(n,r,i,s,o,a){if(!a)throw new e(t.logMessage(t.LEVEL_SEVERE,"ProjectionEquirectangular","northTangentAtPoint","missingResult"));return a[0]=0,a[1]=1,a[2]=0,a},i.prototype.surfaceNormalAtLocation=function(n,r,i,s){if(!s)throw new e(t.logMessage(t.LEVEL_SEVERE,"GeographicProjection","surfaceNormalAtLocation","missingResult"));return s[0]=0,s[1]=0,s[2]=1,s},i.prototype.surfaceNormalAtPoint=function(n,r,i,s,o){if(!o)throw new e(t.logMessage(t.LEVEL_SEVERE,"GeographicProjection","surfaceNormalAtPoint","missingResult"));return o[0]=0,o[1]=0,o[2]=1,o},i}),define("projections/ProjectionWgs84",["../geom/Angle","../error/ArgumentError","../projections/GeographicProjection","../util/Logger","../geom/Position","../geom/Vec3","../util/WWMath"],function(e,t,n,r,i,s,o){"use strict";var a=function(){n.call(this,"WGS84",!1,null),this.is2D=!1,this.scratchPosition=new i(0,0,0)};return a.prototype=Object.create(n.prototype),Object.defineProperties(a.prototype,{stateKey:{get:function(){return"projection wgs84 "}}}),a.prototype.geographicToCartesian=function(n,i,s,o,a,l){if(!n)throw new t(r.logMessage(r.LEVEL_SEVERE,"ProjectionWgs84","geographicToCartesian","missingGlobe"));var h=Math.cos(i*e.DEGREES_TO_RADIANS),u=Math.sin(i*e.DEGREES_TO_RADIANS),c=Math.cos(s*e.DEGREES_TO_RADIANS),d=Math.sin(s*e.DEGREES_TO_RADIANS),f=n.equatorialRadius/Math.sqrt(1-n.eccentricitySquared*u*u);return l[0]=(f+o)*h*d,l[1]=(f*(1-n.eccentricitySquared)+o)*u,l[2]=(f+o)*h*c,l},a.prototype.geographicToCartesianGrid=function(n,i,o,a,l,h,u,c){if(!n)throw new t(r.logMessage(r.LEVEL_SEVERE,"ProjectionWgs84","geographicToCartesianGrid","missingGlobe"));var d,f,p,m,g,b,y,_,E=i.minLatitude*e.DEGREES_TO_RADIANS,v=i.maxLatitude*e.DEGREES_TO_RADIANS,w=i.minLongitude*e.DEGREES_TO_RADIANS,S=i.maxLongitude*e.DEGREES_TO_RADIANS,T=(v-E)/(o>1?o-1:1),L=(S-w)/(a>1?a-1:1),x=h||new s(0,0,0),R=0,A=0,C=new Float64Array(a),M=new Float64Array(a);for(f=0,m=w;f<a;f++,m+=L)f===a-1&&(m=S),C[f]=Math.cos(m),M[f]=Math.sin(m);for(d=0,p=E;d<o;d++,p+=T)for(d===o-1&&(p=v),y=Math.cos(p),_=Math.sin(p),g=n.equatorialRadius/Math.sqrt(1-n.eccentricitySquared*_*_),f=0;f<a;f++)b=l[R++],c[A++]=(g+b)*y*M[f]-x[0],c[A++]=(g*(1-n.eccentricitySquared)+b)*_-x[1],c[A++]=(g+b)*y*C[f]-x[2];return c},a.prototype.cartesianToGeographic=function(n,i,s,a,l,h){if(!n)throw new t(r.logMessage(r.LEVEL_SEVERE,"ProjectionWgs84","cartesianToGeographic","missingGlobe"));var u,c,d,f,p,m,g,b,y,_,E,v,w,S,T,L=a,x=i,R=s,A=L*L+x*x,C=Math.sqrt(A),M=n.equatorialRadius,k=1/(M*M),I=n.eccentricitySquared,O=I*I,P=A*k,N=R*R*(1-I)*k,D=(P+N-O)/6,F=8*D*D*D+O*P*N;return F>0||0!=N?(F>0?(f=Math.sqrt(F),p=Math.sqrt(O*P*N),F>10*I?(m=o.cbrt((f+p)*(f+p)),d=D+.5*m+2*D*D/m):d=D+.5*o.cbrt((f+p)*(f+p))+.5*o.cbrt((f-p)*(f-p))):(f=Math.sqrt(-F),p=Math.sqrt(-8*D*D*D),m=Math.sqrt(O*P*N),g=2*Math.atan2(m,f+p)/3,d=-4*D*Math.sin(g)*Math.cos(Math.PI/6+g)),b=Math.sqrt(d*d+O*N),y=I*(d+b-N)/(2*b),_=(d+b)/(Math.sqrt(y*y+d+b)+y),E=_*C/(_+I),v=Math.sqrt(E*E+R*R),u=(_+I-1)*v/_,c=2*Math.atan2(R,v+E)):(f=Math.sqrt(1-I),p=Math.sqrt(I-P),w=Math.sqrt(I),u=-M*f*p/w,c=p/(w*p+f*Math.sqrt(P))),T=Math.sqrt(2),S=(T-1)*x<C+L?2*Math.atan2(x,C+L):C+x<(T+1)*L?.5*-Math.PI+2*Math.atan2(L,C-x):.5*Math.PI-2*Math.atan2(L,C+x),h.latitude=e.RADIANS_TO_DEGREES*c,h.longitude=e.RADIANS_TO_DEGREES*S,h.altitude=u,h},a.prototype.northTangentAtLocation=function(t,n,r,i){var s=Math.cos(n*e.DEGREES_TO_RADIANS),o=Math.cos(r*e.DEGREES_TO_RADIANS),a=Math.sin(n*e.DEGREES_TO_RADIANS),l=Math.sin(r*e.DEGREES_TO_RADIANS);return i[0]=-a*l,i[1]=s,i[2]=-a*o,i.normalize()},a.prototype.northTangentAtPoint=function(e,t,n,r,i,o){return this.cartesianToGeographic(e,t,n,r,s.ZERO,this.scratchPosition),this.northTangentAtLocation(e,this.scratchPosition.latitude,this.scratchPosition.longitude,o)},a.prototype.surfaceNormalAtLocation=function(t,n,r,i){var s=Math.cos(n*e.DEGREES_TO_RADIANS),o=Math.cos(r*e.DEGREES_TO_RADIANS),a=Math.sin(n*e.DEGREES_TO_RADIANS),l=Math.sin(r*e.DEGREES_TO_RADIANS);return i[0]=s*l,i[1]=a,i[2]=s*o,i.normalize()},a.prototype.surfaceNormalAtPoint=function(e,n,i,s,o){if(!e)throw new t(r.logMessage(r.LEVEL_SEVERE,"ProjectionWgs84","surfaceNormalAtPoint","missingGlobe"));var a=e.equatorialRadius*e.equatorialRadius,l=e.polarRadius*e.polarRadius;return o[0]=n/a,o[1]=i/l,o[2]=s/a,o.normalize()},a}),define("globe/Terrain",["../error/ArgumentError","../util/Logger","../geom/Vec3"],function(e,t,n){"use strict";var r=function(e,t,n,r){this.globe=e,this.verticalExaggeration=r,this.sector=n.sector,this.tessellator=t,this.surfaceGeometry=n.tileArray,this.stateKey=e.stateKey+" ve "+r.toString()};return r.scratchPoint=new n(0,0,0),r.prototype.surfacePoint=function(n,i,s,o){if(!o)throw new e(t.logMessage(t.LEVEL_SEVERE,"Terrain","surfacePoint","missingResult"));for(var a=0,l=this.surfaceGeometry.length;a<l;a++)if(this.surfaceGeometry[a].sector.containsLocation(n,i)){if(this.surfaceGeometry[a].surfacePoint(n,i,o),s){var h=this.globe.surfaceNormalAtPoint(o[0],o[1],o[2],r.scratchPoint);o[0]+=h[0]*s,o[1]+=h[1]*s,o[2]+=h[2]*s}return o}var u=s+this.globe.elevationAtLocation(n,i)*this.verticalExaggeration;return this.globe.computePointFromPosition(n,i,u,o),o},r.prototype.surfacePointForMode=function(n,r,i,s,o){if(!o)throw new e(t.logMessage(t.LEVEL_SEVERE,"Terrain","surfacePointForMode","missingResult"));if(s||(s=WorldWind.ABSOLUTE),s===WorldWind.CLAMP_TO_GROUND)return this.surfacePoint(n,r,0,o);if(s===WorldWind.RELATIVE_TO_GROUND)return this.surfacePoint(n,r,i,o);var a=i*this.verticalExaggeration;return this.globe.computePointFromPosition(n,r,a,o),o},r.prototype.beginRendering=function(e){this.globe&&this.globe.tessellator&&this.globe.tessellator.beginRendering(e)},r.prototype.endRendering=function(e){this.globe&&this.globe.tessellator&&this.globe.tessellator.endRendering(e)},r.prototype.beginRenderingTile=function(n,r){if(!r)throw new e(t.logMessage(t.LEVEL_SEVERE,"Terrain","beginRenderingTile","missingTile"));this.globe&&this.globe.tessellator&&this.globe.tessellator.beginRenderingTile(n,r)},r.prototype.endRenderingTile=function(e,t){},r.prototype.renderTile=function(n,r){if(!r)throw new e(t.logMessage(t.LEVEL_SEVERE,"Terrain","renderTile","missingTile"));this.globe&&this.globe.tessellator&&this.globe.tessellator.renderTile(n,r)},r.prototype.pick=function(e){this.globe&&this.globe.tessellator&&this.globe.tessellator.pick(e,this.surfaceGeometry,this)},r}),define("globe/TerrainTile",["../error/ArgumentError","../util/Logger","../geom/Matrix","../util/Tile"],function(e,t,n,r){"use strict";var i=function(e,t,i,s){r.call(this,e,t,i,s),this.transformationMatrix=n.fromIdentity(),this.points=null,this.pointsStateKey=null,this.pointsVboStateKey=null,this.neighborMap={},this.neighborMap[WorldWind.NORTH]=null,this.neighborMap[WorldWind.SOUTH]=null,this.neighborMap[WorldWind.EAST]=null,this.neighborMap[WorldWind.WEST]=null,this._stateKey=null,this._elevationTimestamp=null,this.scratchArray=[]};return i.prototype=Object.create(r.prototype),Object.defineProperties(i.prototype,{stateKey:{get:function(){return this._stateKey||(this._stateKey=this.computeStateKey()),this._stateKey}}}),i.prototype.neighborLevel=function(e){return this.neighborMap[e]},i.prototype.setNeighborLevel=function(e,t){this.neighborMap[e]=t,this._stateKey=null},i.prototype.surfacePoint=function(n,r,i){if(!i)throw new e(t.logMessage(t.LEVEL_SEVERE,"TerrainTile","surfacePoint","missingResult"));var s,o,a,l,h,u,c,d,f,p,m=this.sector,g=m.minLatitude,b=m.maxLatitude,y=m.minLongitude,_=m.maxLongitude,E=this.tileWidth,v=this.tileHeight;s=(r-y)/(_-y)*E,o=(n-g)/(b-g)*v,a=s<E?Math.floor(s):E-1,l=o<v?Math.floor(o):v-1,h=E+1,u=this.points,c=this.scratchArray,d=3*(a+l*h);for(var w=0;w<6;w++)c[w]=u[d+w];d=3*(a+(l+1)*h);for(var S=6;S<12;S++)c[S]=u[d+(S-6)];return f=s<E?s-Math.floor(s):1,p=o<v?o-Math.floor(o):1,f>p?(i[0]=c[0]+f*(c[3]-c[0])+p*(c[6]-c[0]),i[1]=c[1]+f*(c[4]-c[1])+p*(c[7]-c[1]),i[2]=c[2]+f*(c[5]-c[2])+p*(c[8]-c[2])):(i[0]=c[9]+(1-f)*(c[6]-c[9])+(1-p)*(c[3]-c[9]),i[1]=c[10]+(1-f)*(c[7]-c[10])+(1-p)*(c[4]-c[10]),i[2]=c[11]+(1-f)*(c[8]-c[11])+(1-p)*(c[5]-c[11])),i[0]+=this.referencePoint[0],i[1]+=this.referencePoint[1],i[2]+=this.referencePoint[2],i},i.prototype.update=function(e){r.prototype.update.call(this,e);var t=e.globe.elevationTimestamp();this._elevationTimestamp!=t&&(this._elevationTimestamp=t,this._stateKey=null)},i.prototype.computeStateKey=function(){var e=[];return e.push(this._elevationTimestamp),e.push(this.neighborMap[WorldWind.NORTH]?this.neighborMap[WorldWind.NORTH].compare(this.level):0),e.push(this.neighborMap[WorldWind.SOUTH]?this.neighborMap[WorldWind.SOUTH].compare(this.level):0),e.push(this.neighborMap[WorldWind.EAST]?this.neighborMap[WorldWind.EAST].compare(this.level):0),e.push(this.neighborMap[WorldWind.WEST]?this.neighborMap[WorldWind.WEST].compare(this.level):0),e.join(".")},i}),define("globe/TerrainTileList",["../error/ArgumentError","../util/Logger","../geom/Sector"],function(e,t,n){"use strict";var r=function(n){if(!n)throw new e(t.logMessage(t.LEVEL_SEVERE,"TerrainTileList","TerrainTileList","missingTessellator"));this.tessellator=n,this.sector=null,this.tileArray=[]};return Object.defineProperties(r.prototype,{length:{get:function(){return this.tileArray.length}}}),r.prototype.addTile=function(r){if(!r)throw new e(t.logMessage(t.LEVEL_SEVERE,"TerrainTileList","addTile","missingTile"));-1==this.tileArray.indexOf(r)&&(this.tileArray.push(r),this.sector?this.sector.union(r.sector):(this.sector=new n(0,0,0,0),this.sector.copy(r.sector)))},r.prototype.removeAllTiles=function(){this.tileArray=[],this.sector=null},r}),define("globe/Tessellator",["../geom/Angle","../error/ArgumentError","../shaders/BasicProgram","../globe/Globe","../shaders/GpuProgram","../util/Level","../util/LevelSet","../geom/Location","../util/Logger","../geom/Matrix","../cache/MemoryCache","../error/NotYetImplementedError","../pick/PickedObject","../geom/Position","../geom/Rectangle","../geom/Sector","../globe/Terrain","../globe/TerrainTile","../globe/TerrainTileList","../util/Tile","../util/WWMath","../util/WWUtil"],function(e,t,n,r,i,s,o,a,l,h,u,c,d,f,p,m,g,b,y,_,E,v){"use strict";var w=function(){this.numRowsTilesInTopLevel=4,this.numColumnsTilesInTopLevel=8,this.maximumSubdivisionDepth=15,this.tileWidth=32,this.tileHeight=32,this.detailControl=40,this.levels=new o(m.FULL_SPHERE,new a(180/this.numRowsTilesInTopLevel,360/this.numColumnsTilesInTopLevel),this.maximumSubdivisionDepth,this.tileWidth,this.tileHeight),this.topLevelTiles={},this.currentTiles=new y(this),this.tileCache=new u(5e6,4e6),this.elevationTimestamp=void 0,this.lastModelViewProjection=h.fromIdentity(),this.vertexPointLocation=-1,this.vertexTexCoordLocation=-1,this.texCoords=null,this.texCoordVboCacheKey="global_tex_coords",this.indices=null,this.indicesVboCacheKey="global_indices",this.baseIndices=null,this.baseIndicesOffset=null,this.numBaseIndices=null,this.indicesNorth=null,this.indicesNorthOffset=null,this.numIndicesNorth=null,this.indicesSouth=null,this.indicesSouthOffset=null,this.numIndicesSouth=null,this.indicesWest=null,this.indicesWestOffset=null,this.numIndicesWest=null,this.indicesEast=null,this.indicesEastOffset=null,this.numIndicesEast=null,this.indicesLoresNorth=null,this.indicesLoresNorthOffset=null,this.numIndicesLoresNorth=null,this.indicesLoresSouth=null,this.indicesLoresSouthOffset=null,this.numIndicesLoresSouth=null,this.indicesLoresWest=null,this.indicesLoresWestOffset=null,this.numIndicesLoresWest=null,this.indicesLoresEast=null,this.indicesLoresEastOffset=null,this.numIndicesLoresEast=null,this.outlineIndicesOffset=null,this.numOutlineIndices=null,this.wireframeIndicesOffset=null,this.numWireframeIndices=null,this.scratchMatrix=h.fromIdentity(),this.scratchElevations=null,this.scratchPrevElevations=null,this.corners={},this.tiles=[]};return w.prototype.tessellate=function(e){if(!e)throw new t(l.logMessage(l.LEVEL_SEVERE,"Tessellator","tessellate","missingDC"));var n=e.globe.elevationTimestamp();if(this.lastGlobeStateKey===e.globeStateKey&&this.lastVerticalExaggeration===e.verticalExaggeration&&this.elevationTimestamp===n&&e.modelviewProjection.equals(this.lastModelViewProjection))return this.lastTerrain;this.lastModelViewProjection.copy(e.modelviewProjection),this.lastGlobeStateKey=e.globeStateKey,this.elevationTimestamp=n,this.lastVerticalExaggeration=e.verticalExaggeration,this.currentTiles.removeAllTiles(),this.topLevelTiles[e.globeStateKey]&&0!=this.topLevelTiles[e.globeStateKey].length||this.createTopLevelTiles(e),this.corners={},this.tiles=[];for(var r=0,i=this.topLevelTiles[e.globeStateKey].length;r<i;r+=1){var s=this.topLevelTiles[e.globeStateKey][r];s.update(e),this.isTileVisible(e,s)&&this.addTileOrDescendants(e,s)}return this.refineNeighbors(e),this.finishTessellating(e),this.lastTerrain=0===this.currentTiles.length?null:new g(e.globe,this,this.currentTiles,e.verticalExaggeration),this.lastTerrain},w.prototype.createTile=function(e,n,r,i){if(!e)throw new t(l.logMessage(l.LEVEL_SEVERE,"Tile","constructor","missingSector"));if(!n)throw new t(l.logMessage(l.LEVEL_SEVERE,"Tile","constructor","The specified level is null or undefined."));if(r<0||i<0)throw new t(l.logMessage(l.LEVEL_SEVERE,"Tile","constructor","The specified row or column is less than zero."));return new b(e,n,r,i)},w.prototype.beginRendering=function(e){var t=e.currentProgram;if(!t)return void l.logMessage(l.LEVEL_INFO,"Tessellator","beginRendering","Current Program is empty");this.buildSharedGeometry(),this.cacheSharedGeometryVBOs(e);var n=e.currentGlContext,r=e.gpuResourceCache;if(this.vertexPointLocation=t.attributeLocation(n,"vertexPoint"),this.vertexTexCoordLocation=t.attributeLocation(n,"vertexTexCoord"),n.enableVertexAttribArray(this.vertexPointLocation),this.vertexTexCoordLocation>=0){var i=r.resourceForKey(this.texCoordVboCacheKey);n.bindBuffer(n.ARRAY_BUFFER,i),n.vertexAttribPointer(this.vertexTexCoordLocation,2,n.FLOAT,!1,0,0),n.enableVertexAttribArray(this.vertexTexCoordLocation)}var s=r.resourceForKey(this.indicesVboCacheKey);n.bindBuffer(n.ELEMENT_ARRAY_BUFFER,s)},w.prototype.endRendering=function(e){var t=e.currentGlContext;t.bindBuffer(t.ARRAY_BUFFER,null),t.bindBuffer(t.ELEMENT_ARRAY_BUFFER,null),this.vertexPointLocation>=0&&t.disableVertexAttribArray(this.vertexPointLocation),this.vertexTexCoordLocation>=0&&t.disableVertexAttribArray(this.vertexTexCoordLocation)},w.prototype.beginRenderingTile=function(e,n){if(!n)throw new t(l.logMessage(l.LEVEL_SEVERE,"Tessellator","beginRenderingTile","missingTile"));var r=e.currentGlContext,i=e.gpuResourceCache;this.scratchMatrix.setToMultiply(e.modelviewProjection,n.transformationMatrix),e.currentProgram.loadModelviewProjection(r,this.scratchMatrix);var s=e.globeStateKey+n.tileKey,o=i.resourceForKey(s);o?n.pointsVboStateKey!=n.pointsStateKey?(r.bindBuffer(r.ARRAY_BUFFER,o),r.bufferSubData(r.ARRAY_BUFFER,0,n.points),n.pointsVboStateKey=n.pointsStateKey):e.currentGlContext.bindBuffer(r.ARRAY_BUFFER,o):(o=r.createBuffer(),r.bindBuffer(r.ARRAY_BUFFER,o),r.bufferData(r.ARRAY_BUFFER,n.points,r.STATIC_DRAW),e.frameStatistics.incrementVboLoadCount(1),i.putResource(s,o,4*n.points.length),n.pointsVboStateKey=n.pointsStateKey),r.vertexAttribPointer(this.vertexPointLocation,3,r.FLOAT,!1,0,0)},w.prototype.endRenderingTile=function(e,t){},w.prototype.renderTile=function(e,n){if(!n)throw new t(l.logMessage(l.LEVEL_SEVERE,"Tessellator","renderTile","missingTile"));var r=e.currentGlContext,i=r.TRIANGLE_STRIP;r.drawElements(i,this.numBaseIndices,r.UNSIGNED_SHORT,2*this.baseIndicesOffset);var s,o=n.level;s=n.neighborLevel(WorldWind.NORTH),s&&s.compare(o)<0?r.drawElements(i,this.numIndicesLoresNorth,r.UNSIGNED_SHORT,2*this.indicesLoresNorthOffset):r.drawElements(i,this.numIndicesNorth,r.UNSIGNED_SHORT,2*this.indicesNorthOffset),s=n.neighborLevel(WorldWind.SOUTH),s&&s.compare(o)<0?r.drawElements(i,this.numIndicesLoresSouth,r.UNSIGNED_SHORT,2*this.indicesLoresSouthOffset):r.drawElements(i,this.numIndicesSouth,r.UNSIGNED_SHORT,2*this.indicesSouthOffset),s=n.neighborLevel(WorldWind.WEST),s&&s.compare(o)<0?r.drawElements(i,this.numIndicesLoresWest,r.UNSIGNED_SHORT,2*this.indicesLoresWestOffset):r.drawElements(i,this.numIndicesWest,r.UNSIGNED_SHORT,2*this.indicesWestOffset),s=n.neighborLevel(WorldWind.EAST),s&&s.compare(o)<0?r.drawElements(i,this.numIndicesLoresEast,r.UNSIGNED_SHORT,2*this.indicesLoresEastOffset):r.drawElements(i,this.numIndicesEast,r.UNSIGNED_SHORT,2*this.indicesEastOffset)},w.prototype.renderWireframeTile=function(e,n){if(!n)throw new t(l.logMessage(l.LEVEL_SEVERE,"Tessellator","renderWireframeTile","missingTile"));var r=e.currentGlContext;this.vertexTexCoordLocation>=0&&r.disableVertexAttribArray(this.vertexTexCoordLocation),r.drawElements(r.LINES,this.numWireframeIndices,r.UNSIGNED_SHORT,2*this.wireframeIndicesOffset)},w.prototype.renderTileOutline=function(e,n){if(!n)throw new t(l.logMessage(l.LEVEL_SEVERE,"Tessellator","renderTileOutline","missingTile"));var r=e.currentGlContext;this.vertexTexCoordLocation>=0&&r.disableVertexAttribArray(this.vertexTexCoordLocation),r.drawElements(r.LINE_LOOP,this.numOutlineIndices,r.UNSIGNED_SHORT,2*this.outlineIndicesOffset)},w.prototype.pick=function(e,n,r){if(!e)throw new t(l.logMessage(l.LEVEL_SEVERE,"Tessellator","pick","missingDc"));if(!n)throw new t(l.logMessage(l.LEVEL_SEVERE,"Tessellator","pick","missingList"));for(var i=null,s=r||this,o=new f(0,0,0),a=[],h=0,u=n.length;h<u;h++){var c=n[h];c.extent.intersectsFrustum(e.pickFrustum)&&a.push(c)}if(e.pickTerrainOnly||(i=e.uniquePickColor(),this.drawPickTiles(e,a,i)),!e.regionPicking){var p=e.pickRay.clone(),m=this.computeNearestIntersection(p,a);m&&(e.globe.computePositionFromPoint(m[0],m[1],m[2],o),o.altitude=e.globe.elevationAtLocation(o.latitude,o.longitude),e.addPickedObject(new d(i,s,o,null,!0)))}},w.prototype.drawPickTiles=function(e,t,r){var i=e.currentGlContext;try{e.findAndBindProgram(n),e.currentProgram.loadColor(i,r),this.beginRendering(e);for(var s=0,o=t.length;s<o;s++){var a=t[s];this.beginRenderingTile(e,a),this.renderTile(e,a),this.endRenderingTile(e,a)}}finally{this.endRendering(e)}},w.prototype.computeNearestIntersection=function(e,t){for(var n=[],r=0,i=t.length;r<i;r++)this.computeIntersections(e,t[r],n);if(0==n.length)return null;var s,o=Number.POSITIVE_INFINITY;for(r=0,i=n.length;r<i;r++){var a=e.origin.distanceToSquared(n[r]);o>a&&(o=a,s=r)}return n[s]},w.prototype.computeIntersections=function(e,t,n){var r,i,s=t.level,o=t.points,a=n.length;e.origin.subtract(t.referencePoint),this.buildSharedGeometry(t),i=this.baseIndices,E.computeTriStripIntersections(e,o,i,n),r=t.neighborLevel(WorldWind.SOUTH),i=r&&r.compare(s)<0?this.indicesLoresSouth:this.indicesSouth,E.computeTriStripIntersections(e,o,i,n),r=t.neighborLevel(WorldWind.WEST),i=r&&r.compare(s)<0?this.indicesLoresWest:this.indicesWest,E.computeTriStripIntersections(e,o,i,n),r=t.neighborLevel(WorldWind.EAST),i=r&&r.compare(s)<0?this.indicesLoresEast:this.indicesEast,E.computeTriStripIntersections(e,o,i,n),r=t.neighborLevel(WorldWind.NORTH),i=r&&r.compare(s)<0?this.indicesLoresNorth:this.indicesNorth,E.computeTriStripIntersections(e,o,i,n),e.origin.add(t.referencePoint);for(var l=a,h=n.length;l<h;l++)n[l].add(t.referencePoint)},w.prototype.createTopLevelTiles=function(e){this.topLevelTiles[e.globeStateKey]=[],_.createTilesForLevel(this.levels.firstLevel(),this,this.topLevelTiles[e.globeStateKey])},w.prototype.addTileOrDescendants=function(e,t){if(this.tileMeetsRenderCriteria(e,t))return void this.addTile(e,t);this.addTileDescendants(e,t)},w.prototype.addTileDescendants=function(e,t){for(var n=t.level.nextLevel(),r=t.subdivideToCache(n,this,this.tileCache),i=0;i<r.length;i+=1){var s=r[i];s.update(e),this.levels.sector.intersects(s.sector)&&this.isTileVisible(e,s)&&this.addTileOrDescendants(e,s)}},w.prototype.addTile=function(e,t){var n=this.tiles.length;this.tiles.push(t);var r,i=t.sector,s=[i.maxLatitude,i.maxLongitude].toString(),o=[i.minLatitude,i.maxLongitude].toString(),a=[i.maxLatitude,i.minLongitude].toString(),l=[i.minLatitude,i.minLongitude].toString();r=this.corners[l],r?r.sw=n:this.corners[l]={sw:n},r=this.corners[a],r?r.nw=n:this.corners[a]={nw:n},r=this.corners[o],r?r.se=n:this.corners[o]={se:n},r=this.corners[s],r?r.ne=n:this.corners[s]={ne:n}},w.prototype.refineNeighbors=function(e){for(var t={},n=0,r=this.tiles.length;n<r;n+=1){var i,s,n,r,o=this.tiles[n],a=o.level.levelNumber,l=o.sector,h=[l.maxLatitude,l.maxLongitude].toString(),u=[l.minLatitude,l.maxLongitude].toString(),c=[l.maxLatitude,l.minLongitude].toString(),d=[l.minLatitude,l.minLongitude].toString();i=this.corners[h],i.hasOwnProperty("se")&&(s=i.se,this.tiles[s].level.levelNumber<a-1&&(t[s]||(t[s]=!0))),i.hasOwnProperty("nw")&&(s=i.nw,this.tiles[s].level.levelNumber<a-1&&(t[s]||(t[s]=!0))),i=this.corners[u],i.hasOwnProperty("ne")&&(s=i.ne,this.tiles[s].level.levelNumber<a-1&&(t[s]||(t[s]=!0))),i.hasOwnProperty("sw")&&(s=i.sw,this.tiles[s].level.levelNumber<a-1&&(t[s]||(t[s]=!0))),i=this.corners[c],i.hasOwnProperty("ne")&&(s=i.ne,
this.tiles[s].level.levelNumber<a-1&&(t[s]||(t[s]=!0))),i.hasOwnProperty("sw")&&(s=i.sw,this.tiles[s].level.levelNumber<a-1&&(t[s]||(t[s]=!0))),i=this.corners[d],i.hasOwnProperty("se")&&(s=i.se,this.tiles[s].level.levelNumber<a-1&&(t[s]||(t[s]=!0))),i.hasOwnProperty("nw")&&(s=i.nw,this.tiles[s].level.levelNumber<a-1&&(t[s]||(t[s]=!0)))}var f=[],p=[];for(n=0,r=this.tiles.length;n<r;n+=1)o=this.tiles[n],t[n]?f.push(o):p.push(o);if(f.length>0){for(this.tiles=[],this.corners={},n=0,r=p.length;n<r;n+=1)o=p[n],this.addTile(e,o);for(n=0,r=f.length;n<r;n+=1){var o=f[n];this.addTileDescendants(e,o)}this.refineNeighbors(e)}},w.prototype.finishTessellating=function(e){for(var t=0,n=this.tiles.length;t<n;t+=1){var r=this.tiles[t];this.setNeighbors(r),this.regenerateTileGeometryIfNeeded(e,r),this.currentTiles.addTile(r)}},w.prototype.setNeighbors=function(e){var t=e.sector,n=[t.maxLatitude,t.maxLongitude].toString(),r=[t.minLatitude,t.maxLongitude].toString(),i=[t.maxLatitude,t.minLongitude].toString(),s=[t.minLatitude,t.minLongitude].toString(),o=this.corners[n],a=this.corners[r],l=this.corners[i],h=this.corners[s],u=-1,c=-1,d=-1,f=-1;o.hasOwnProperty("se")?u=o.se:l.hasOwnProperty("sw")&&(u=l.sw),a.hasOwnProperty("ne")?c=a.ne:h.hasOwnProperty("nw")&&(c=h.nw),o.hasOwnProperty("nw")?d=o.nw:a.hasOwnProperty("sw")&&(d=a.sw),l.hasOwnProperty("ne")?f=l.ne:h.hasOwnProperty("se")&&(f=h.se),e.setNeighborLevel(WorldWind.NORTH,u>=0?this.tiles[u].level:null),e.setNeighborLevel(WorldWind.SOUTH,c>=0?this.tiles[c].level:null),e.setNeighborLevel(WorldWind.EAST,d>=0?this.tiles[d].level:null),e.setNeighborLevel(WorldWind.WEST,f>=0?this.tiles[f].level:null)},w.prototype.isTileVisible=function(e,t){return!(e.globe.projectionLimits&&!t.sector.overlaps(e.globe.projectionLimits))&&t.extent.intersectsFrustum(e.frustumInModelCoordinates)},w.prototype.tileMeetsRenderCriteria=function(e,t){var n=this.detailControl;return(t.sector.minLatitude>=75||t.sector.maxLatitude<=-75)&&(n*=2),t.level.isLastLevel()||!t.mustSubdivide(e,n)},w.prototype.regenerateTileGeometryIfNeeded=function(e,t){var n=e.globeStateKey+t.stateKey+e.verticalExaggeration;t.points&&t.pointsStateKey==n||(this.regenerateTileGeometry(e,t),t.pointsStateKey=n)},w.prototype.coverageTargetResolution=function(t){return t/8*e.RADIANS_TO_DEGREES},w.prototype.regenerateTileGeometry=function(e,t){var n=t.tileHeight+1,r=t.tileWidth+1,i=t.referencePoint,s=this.scratchElevations;s||(s=new Float64Array(n*r),this.scratchElevations=s),t.points||(t.points=new Float32Array(n*r*3)),v.fillArray(s,0),e.globe.elevationsForGrid(t.sector,n,r,this.coverageTargetResolution(t.texelSize),s),this.mustAlignNeighborElevations(e,t)&&this.alignNeighborElevations(e,t,s),v.multiplyArray(s,e.verticalExaggeration),e.globe.computePointsForGrid(t.sector,n,r,s,i,t.points),t.transformationMatrix.setTranslation(i[0],i[1],i[2])},w.prototype.mustAlignNeighborElevations=function(e,t){var n=t.level,r=t.neighborLevel(WorldWind.NORTH),i=t.neighborLevel(WorldWind.SOUTH),s=t.neighborLevel(WorldWind.EAST),o=t.neighborLevel(WorldWind.WEST);return r&&r.compare(n)<0||i&&i.compare(n)<0||s&&s.compare(n)<0||o&&o.compare(n)<0},w.prototype.alignNeighborElevations=function(e,t,n){var r,i,s,o,a=t.tileHeight+1,l=t.tileWidth+1,h=t.level,u=Math.floor(a/2)+1,c=Math.floor(l/2)+1,d=h.previousLevel(),f=this.scratchPrevElevations;if(f||(f=new Float64Array(u*c),this.scratchPrevElevations=f),v.fillArray(f,0),e.globe.elevationsForGrid(t.sector,u,c,this.coverageTargetResolution(d.texelSize),f),(r=t.neighborLevel(WorldWind.NORTH))&&r.compare(h)<0)for(s=(a-1)*l,o=(u-1)*c,i=0;i<c;i++,s+=2,o+=1)n[s]=f[o],i<c-1&&(n[s+1]=.5*(f[o]+f[o+1]));if((r=t.neighborLevel(WorldWind.SOUTH))&&r.compare(h)<0)for(s=0,o=0,i=0;i<c;i++,s+=2,o+=1)n[s]=f[o],i<c-1&&(n[s+1]=.5*(f[o]+f[o+1]));if((r=t.neighborLevel(WorldWind.EAST))&&r.compare(h)<0)for(s=l-1,o=c-1,i=0;i<u;i++,s+=2*l,o+=c)n[s]=f[o],i<u-1&&(n[s+l]=.5*(f[o]+f[o+c]));if((r=t.neighborLevel(WorldWind.WEST))&&r.compare(h)<0)for(s=0,o=0,i=0;i<u;i++,s+=2*l,o+=c)n[s]=f[o],i<u-1&&(n[s+l]=.5*(f[o]+f[o+c]))},w.prototype.buildSharedGeometry=function(){var e=this.levels.tileWidth,t=this.levels.tileHeight;this.texCoords||this.buildTexCoords(e,t),this.indices||this.buildIndices(e,t)},w.prototype.buildTexCoords=function(e,t){for(var n=e+1,r=t+1,i=1/e,s=1/t,o=new Float32Array(n*r*2),a=0,l=0,h=0;l<r;l++,h+=s){l==r-1&&(h=1);for(var u=0,c=0;u<n;u++,c+=i)u==n-1&&(c=1),o[a++]=c,o[a++]=h}this.texCoords=o},w.prototype.buildIndices=function(e,t){for(var n,r=t+1,i=e+1,s=2*(r-3)*(i-2)+2*(r-3),o=[],a=0,l=1;l<i-2;l+=1){for(var h=1;h<r-1;h+=1)n=l+h*i,o[a++]=n,o[a++]=n+1;o[a++]=n+1,n=l+1+1*i,o[a++]=n}for(this.baseIndicesOffset=o.length-s,this.baseIndices=new Uint16Array(o.slice(this.baseIndicesOffset)),this.numBaseIndices=s,s=2*i-2,h=r-1,l=i-1,n=l+h*i,o[a++]=n,l=i-2;l>0;l-=1)n=l+h*i,o[a++]=n,o[a++]=n-i;for(l=0,n=l+h*i,o[a++]=n,this.indicesNorthOffset=o.length-s,this.indicesNorth=new Uint16Array(o.slice(this.indicesNorthOffset)),this.numIndicesNorth=s,s=2*i-2,h=0,l=0,n=l+h*i,o[a++]=n,l=1;l<i-1;l+=1)n=l+h*i,o[a++]=n,o[a++]=n+i;for(l=i-1,n=l+h*i,o[a++]=n,this.indicesSouthOffset=o.length-s,this.indicesSouth=new Uint16Array(o.slice(this.indicesSouthOffset)),this.numIndicesSouth=s,s=2*r-2,l=0,h=r-1,n=l+h*i,o[a++]=n,h=r-2;h>0;h-=1)n=l+h*i,o[a++]=n,o[a++]=n+1;for(h=0,n=l+h*i,o[a++]=n,this.indicesWestOffset=o.length-s,this.indicesWest=new Uint16Array(o.slice(this.indicesWestOffset)),this.numIndicesWest=s,s=2*r-2,l=i-1,h=0,n=l+h*i,o[a++]=n,h=1;h<r-1;h+=1)n=l+h*i,o[a++]=n,o[a++]=n-1;for(h=r-1,n=l+h*i,o[a++]=n,this.indicesEastOffset=o.length-s,this.indicesEast=new Uint16Array(o.slice(this.indicesEastOffset)),this.numIndicesEast=s,s=2*i-2,h=r-1,l=i-1,n=l+h*i,o[a++]=n,l=i-2;l>0;l-=1)n=(l+1&-2)+h*i,o[a++]=n,n=l+(h-1)*i,o[a++]=n;for(l=0,n=l+h*i,o[a++]=n,this.indicesLoresNorthOffset=o.length-s,this.indicesLoresNorth=new Uint16Array(o.slice(this.indicesLoresNorthOffset)),this.numIndicesLoresNorth=s,s=2*i-2,h=0,l=0,n=l+h*i,o[a++]=n,l=1;l<i-1;l+=1)n=(-2&l)+h*i,o[a++]=n,n=l+(h+1)*i,o[a++]=n;for(l=i-1,n=l+h*i,o[a++]=n,this.indicesLoresSouthOffset=o.length-s,this.indicesLoresSouth=new Uint16Array(o.slice(this.indicesLoresSouthOffset)),this.numIndicesLoresSouth=s,s=2*r-2,l=0,h=r-1,n=l+h*i,o[a++]=n,h=r-2;h>0;h-=1)n=l+(h+1&-2)*i,o[a++]=n,n=l+1+h*i,o[a++]=n;for(h=0,n=l+h*i,o[a++]=n,this.indicesLoresWestOffset=o.length-s,this.indicesLoresWest=new Uint16Array(o.slice(this.indicesLoresWestOffset)),this.numIndicesLoresWest=s,s=2*r-2,l=i-1,h=0,n=l+h*i,o[a++]=n,h=1;h<r-1;h+=1)n=l+(-2&h)*i,o[a++]=n,n=l-1+h*i,o[a++]=n;h=r-1,n=l+h*i,o[a++]=n,this.indicesLoresEastOffset=o.length-s,this.indicesLoresEast=new Uint16Array(o.slice(this.indicesLoresEastOffset)),this.numIndicesLoresEast=s;var u=this.buildWireframeIndices(e,t),c=this.buildOutlineIndices(e,t);o=o.concat(u),this.wireframeIndicesOffset=o.length-this.numWireframeIndices,o=o.concat(c),this.outlineIndicesOffset=o.length-this.numOutlineIndices,this.indices=new Uint16Array(o)},w.prototype.buildWireframeIndices=function(e,t){var n,r,i,s=t+1,o=e+1,a=2*e*s+2*t*o,l=[],h=o,u=0;for(r=0;r<s;r+=1)for(n=0;n<e;n+=1)i=n+r*h,l[u]=i,l[u+1]=i+1,u+=2;for(n=0;n<o;n+=1)for(r=0;r<t;r+=1)i=n+r*h,l[u]=i,l[u+1]=i+h,u+=2;return this.numWireframeIndices=a,l},w.prototype.buildOutlineIndices=function(e,t){var n,r,i,s=t+1,o=e+1,a=2*(s-2)+2*o+1,l=[],h=0;for(r=0,n=0;n<o;n+=1)i=n+r*o,l[h]=i,h+=1;for(n=o-1,r=1;r<s;r+=1)i=n+r*o,l[h]=i,h+=1;for(r=s-1,n=o-1;n>=0;n-=1)i=n+r*o,l[h]=i,h+=1;for(n=0,r=s-1;r>=0;r-=1)i=n+r*o,l[h]=i,h+=1;return this.numOutlineIndices=a,l},w.prototype.cacheSharedGeometryVBOs=function(e){var t=e.currentGlContext,n=e.gpuResourceCache,r=n.resourceForKey(this.texCoordVboCacheKey);r||(r=t.createBuffer(),t.bindBuffer(t.ARRAY_BUFFER,r),t.bufferData(t.ARRAY_BUFFER,this.texCoords,t.STATIC_DRAW),e.frameStatistics.incrementVboLoadCount(1),n.putResource(this.texCoordVboCacheKey,r,4*this.texCoords.length/2));var i=n.resourceForKey(this.indicesVboCacheKey);i||(i=t.createBuffer(),t.bindBuffer(t.ELEMENT_ARRAY_BUFFER,i),t.bufferData(t.ELEMENT_ARRAY_BUFFER,this.indices,t.STATIC_DRAW),e.frameStatistics.incrementVboLoadCount(1),n.putResource(this.indicesVboCacheKey,i,2*this.indices.length))},w}),define("globe/Globe",["../geom/Angle","../error/ArgumentError","../geom/BoundingBox","../globe/ElevationModel","../geom/Line","../geom/Location","../util/Logger","../geom/Position","../projections/ProjectionWgs84","../geom/Sector","../globe/Tessellator","../geom/Vec3","../util/WWMath"],function(e,t,n,r,i,s,o,a,l,h,u,c,d){"use strict";var f=function(e,n){if(!e)throw new t(o.logMessage(o.LEVEL_SEVERE,"Globe","constructor","Elevation model is null or undefined."));this.elevationModel=e,this.equatorialRadius=WorldWind.WGS84_SEMI_MAJOR_AXIS;var r=1/WorldWind.WGS84_INVERSE_FLATTENING;this.polarRadius=this.equatorialRadius*(1-r),this.eccentricitySquared=2*r-r*r,this.tessellator=new u,this._projection=n||new l,this._offset=0,this.offsetVector=new c(0,0,0),this.id=++f.idPool,this._stateKey="globe "+this.id.toString()+" "};return f.idPool=0,Object.defineProperties(f.prototype,{stateKey:{get:function(){return this._stateKey+this.elevationModel.stateKey+"offset "+this.offset.toString()+" "+this.projection.stateKey}},continuous:{get:function(){return this.projection.continuous}},projection:{get:function(){return this._projection},set:function(e){if(!e)throw new t(o.logMessage(o.LEVEL_SEVERE,"Globe","projection","missingProjection"));this.projection!=e&&(this.tessellator=new u),this._projection=e}},projectionLimits:{get:function(){return this._projection.projectionLimits}},offset:{get:function(){return this._offset},set:function(e){this._offset=e,this.offsetVector[0]=2*e*Math.PI*this.equatorialRadius}}}),f.prototype.is2D=function(){return this.projection.is2D},f.prototype.computePointFromPosition=function(e,n,r,i){if(!i)throw new t(o.logMessage(o.LEVEL_SEVERE,"Globe","computePointFromPosition","missingResult"));return this.projection.geographicToCartesian(this,e,n,r,this.offsetVector,i)},f.prototype.computePointFromLocation=function(e,n,r){if(!r)throw new t(o.logMessage(o.LEVEL_SEVERE,"Globe","computePointFromLocation","missingResult"));return this.computePointFromPosition(e,n,0,r)},f.prototype.computePointsForGrid=function(e,n,r,i,s,a){if(!e)throw new t(o.logMessage(o.LEVEL_SEVERE,"Globe","computePointsFromPositions","missingSector"));if(n<1||r<1)throw new t(o.logMessage(o.LEVEL_SEVERE,"Globe","computePointsFromPositions","Number of latitude or longitude locations is less than one."));var l=n*r;if(!i||i.length<l)throw new t(o.logMessage(o.LEVEL_SEVERE,"Globe","computePointsFromPositions","Elevations array is null, undefined or insufficient length."));if(!a||a.length<l)throw new t(o.logMessage(o.LEVEL_SEVERE,"Globe","computePointsFromPositions","Result array is null, undefined or insufficient length."));return this.projection.geographicToCartesianGrid(this,e,n,r,i,s,this.offsetVector,a)},f.prototype.computePositionFromPoint=function(e,n,r,i){if(!i)throw new t(o.logMessage(o.LEVEL_SEVERE,"Globe","computePositionFromPoint","missingResult"));return this.projection.cartesianToGeographic(this,e,n,r,this.offsetVector,i),this.continuous&&(i.longitude<-180?i.longitude+=360:i.longitude>180&&(i.longitude-=360)),i},f.prototype.radiusAt=function(t,n){var r=Math.sin(t*e.DEGREES_TO_RADIANS);return this.equatorialRadius/Math.sqrt(1-this.eccentricitySquared*r*r)*Math.sqrt(1+(this.eccentricitySquared*this.eccentricitySquared-2*this.eccentricitySquared)*r*r)},f.prototype.surfaceNormalAtLocation=function(n,r,i){if(!i)throw new t(o.logMessage(o.LEVEL_SEVERE,"Globe","surfaceNormalAtLocation","missingResult"));if(this.projection.surfaceNormalAtLocation)return this.projection.surfaceNormalAtLocation(this,n,r,i);if(this.is2D())return i[0]=0,i[1]=0,i[2]=1,i;var s=Math.cos(n*e.DEGREES_TO_RADIANS),a=Math.cos(r*e.DEGREES_TO_RADIANS),l=Math.sin(n*e.DEGREES_TO_RADIANS),h=Math.sin(r*e.DEGREES_TO_RADIANS);return i[0]=s*h,i[1]=l,i[2]=s*a,i.normalize()},f.prototype.surfaceNormalAtPoint=function(e,n,r,i){if(!i)throw new t(o.logMessage(o.LEVEL_SEVERE,"Globe","surfaceNormalAtPoint","missingResult"));if(this.projection.surfaceNormalAtPoint)return this.projection.surfaceNormalAtPoint(this,e,n,r,i);if(this.is2D())return i[0]=0,i[1]=0,i[2]=1,i;var s=this.equatorialRadius*this.equatorialRadius,a=this.polarRadius*this.polarRadius;return i[0]=e/s,i[1]=n/a,i[2]=r/s,i.normalize()},f.prototype.northTangentAtLocation=function(e,n,r){if(!r)throw new t(o.logMessage(o.LEVEL_SEVERE,"Globe","northTangentAtLocation","missingResult"));return this.projection.northTangentAtLocation(this,e,n,r)},f.prototype.northTangentAtPoint=function(e,n,r,i){if(!i)throw new t(o.logMessage(o.LEVEL_SEVERE,"Globe","northTangentAtPoint","missingResult"));return this.projection.northTangentAtPoint(this,e,n,r,this.offsetVector,i)},f.prototype.intersectsFrustum=function(e){if(!e)throw new t(o.logMessage(o.LEVEL_SEVERE,"Globe","intersectsFrustum","missingFrustum"));if(this.is2D()){var r=new n;return r.setToSector(h.FULL_SPHERE,this,this.elevationModel.minElevation,this.elevationModel.maxElevation),r.intersectsFrustum(e)}return!(e.far.distance<=this.equatorialRadius)&&(!(e.left.distance<=this.equatorialRadius)&&(!(e.right.distance<=this.equatorialRadius)&&(!(e.top.distance<=this.equatorialRadius)&&(!(e.bottom.distance<=this.equatorialRadius)&&!(e.near.distance<=this.equatorialRadius)))))},f.prototype.intersectsLine=function(e,n){if(!e)throw new t(o.logMessage(o.LEVEL_SEVERE,"Globe","intersectWithRay","missingLine"));if(!n)throw new t(o.logMessage(o.LEVEL_SEVERE,"Globe","intersectsLine","missingResult"));var r,i=e.direction[0],s=e.direction[1],a=e.direction[2],l=e.origin[0],h=e.origin[1],u=e.origin[2];if(this.is2D())return(0!=a||0==u)&&(!((r=-u/a)<0)&&(n[0]=l+i*r,n[1]=h+s*r,n[2]=u+a*r,!0));var c,d,f,p,m=this.equatorialRadius,g=m*m,b=m/this.polarRadius,y=b*b;return c=i*i+y*s*s+a*a,d=2*(l*i+y*h*s+u*a),f=l*l+y*h*h+u*u-g,!((p=d*d-4*c*f)<0)&&((r=(-d-Math.sqrt(p))/(2*c))>0?(n[0]=l+i*r,n[1]=h+s*r,n[2]=u+a*r,!0):(r=(-d+Math.sqrt(p))/(2*c))>0&&(n[0]=l+i*r,n[1]=h+s*r,n[2]=u+a*r,!0))},f.prototype.elevationTimestamp=function(){return this.elevationModel.timestamp},f.prototype.minElevation=function(){return this.elevationModel.minElevation},f.prototype.maxElevation=function(){return this.elevationModel.maxElevation},f.prototype.minAndMaxElevationsForSector=function(e){if(!e)throw new t(o.logMessage(o.LEVEL_SEVERE,"Globe","minAndMaxElevationsForSector","missingSector"));return this.elevationModel.minAndMaxElevationsForSector(e)},f.prototype.elevationAtLocation=function(e,t){return this.elevationModel.elevationAtLocation(e,t)},f.prototype.elevationsForGrid=function(e,n,r,i,s){if(!e)throw new t(o.logMessage(o.LEVEL_SEVERE,"Globe","elevationsForSector","missingSector"));if(n<=0||r<=0)throw new t(o.logMessage(o.LEVEL_SEVERE,"Globe","elevationsForSector","numLat or numLon is less than 1"));if(!s||s.length<n*r)throw new t(o.logMessage(o.LEVEL_SEVERE,"Globe","elevationsForSector","missingArray"));return this.elevationModel.elevationsForGrid(e,n,r,i,s)},f.prototype.horizonDistance=function(e){return e>0?Math.sqrt(e*(2*this.equatorialRadius+e)):0},f}),define("formats/collada/ColladaScene",["../../error/ArgumentError","../../shaders/BasicTextureProgram","../../util/Color","../../globe/Globe","../../geom/Line","../../util/Logger","../../geom/Matrix","../../geom/Position","../../pick/PickedObject","../../render/Renderable","../../geom/Vec3","../../util/WWMath"],function(e,t,n,r,i,s,o,a,l,h,u,c){"use strict";var d=function(t,r){if(!t)throw new e(s.logMessage(s.LEVEL_SEVERE,"ColladaScene","constructor","missingPosition"));h.call(this),this.resetCurrentData(),this._position=t,this._nodes=[],this._meshes={},this._materials={},this._images={},this._upAxis="",this._dirPath="",this._xRotation=0,this._yRotation=0,this._zRotation=0,this._xTranslation=0,this._yTranslation=0,this._zTranslation=0,this._scale=1,this._altitudeMode=WorldWind.ABSOLUTE,this._localTransforms=!0,this._useTexturePaths=!0,this._nodesToHide=[],this._hideNodes=!1,this._placePoint=new u(0,0,0),this._transformationMatrix=o.fromIdentity(),this._mvpMatrix=o.fromIdentity(),this._normalTransformMatrix=o.fromIdentity(),this._normalMatrix=o.fromIdentity(),this._texCoordMatrix=o.fromIdentity().setToUnitYFlip(),this._entities=[],this._activeTexture=null,this._tmpVector=new u(0,0,0),this._tmpColor=new n(1,1,1,1),this._vboCacheKey="",this._iboCacheKey="",this._doubleSided=!1,this._computedNormals=!1,this.setSceneData(r)};return d.prototype=Object.create(h.prototype),d.prototype.constructor=d,Object.defineProperties(d.prototype,{position:{get:function(){return this._position},set:function(e){this._currentData.expired=!0,this._position=e}},nodes:{get:function(){return this._nodes},set:function(e){this._nodes=e}},meshes:{get:function(){return this._meshes},set:function(e){this._currentData.expired=!0,this._meshes=e}},materials:{get:function(){return this._materials},set:function(e){this._materials=e}},images:{get:function(){return this._images},set:function(e){this._images=e}},upAxis:{get:function(){return this._upAxis},set:function(e){this._upAxis=e}},dirPath:{get:function(){return this._dirPath},set:function(e){this._dirPath=e}},xRotation:{get:function(){return this._xRotation},set:function(e){this._currentData.expired=!0,this._xRotation=e}},yRotation:{get:function(){return this._yRotation},set:function(e){this._currentData.expired=!0,this._yRotation=e}},zRotation:{get:function(){return this._zRotation},set:function(e){this._currentData.expired=!0,this._zRotation=e}},xTranslation:{get:function(){return this._xTranslation},set:function(e){this._currentData.expired=!0,this._xTranslation=e}},yTranslation:{get:function(){return this._yTranslation},set:function(e){this._currentData.expired=!0,this._yTranslation=e}},zTranslation:{get:function(){return this._zTranslation},set:function(e){this._currentData.expired=!0,this._zTranslation=e}},scale:{get:function(){return this._scale},set:function(e){this._currentData.expired=!0,this._scale=e}},placePoint:{get:function(){return this._placePoint},set:function(e){this._currentData.expired=!0,this._placePoint=e}},altitudeMode:{get:function(){return this._altitudeMode},set:function(e){this._altitudeMode=e}},transformationMatrix:{get:function(){return this._transformationMatrix},set:function(e){this._transformationMatrix=e}},normalMatrix:{get:function(){return this._normalMatrix},set:function(e){this._normalMatrix=e}},localTransforms:{get:function(){return this._localTransforms},set:function(e){this._localTransforms=e}},useTexturePaths:{get:function(){return this._useTexturePaths},set:function(e){this._useTexturePaths=e}},nodesToHide:{get:function(){return this._nodesToHide},set:function(e){this._nodesToHide=e}},hideNodes:{get:function(){return this._hideNodes},set:function(e){this._hideNodes=e}},doubleSided:{get:function(){return this._doubleSided},set:function(e){this._doubleSided=e}},computedNormals:{get:function(){return this._computedNormals},set:function(e){this._currentData.expired=!0,this._computedNormals=e}}}),d.prototype.resetCurrentData=function(){this._currentData={expired:!0,transformedPoints:[]}},d.prototype.setSceneData=function(e){e&&(this._nodes=e.root.children,this._meshes=e.meshes,this._materials=e.materials,this._images=e.images,this._upAxis=e.metadata.up_axis,this._dirPath=e.dirPath,this.flattenModel())},d.prototype.flattenModel=function(){for(var e=0,t=this._nodes.length;e<t;e++)this.flattenNode(this._nodes[e]);this._entities.sort(function(e,t){var n=null===e.imageKey?"":""+e,r=null===t.imageKey?"":""+t;return n>r?1:n===r?0:-1})},d.prototype.flattenNode=function(e){if(e.mesh)for(var t=e.mesh,n=this._meshes[t].buffers,r=0,i=n.length;r<i;r++){for(var s=n[r].material,o=0;o<e.materials.length;o++)if(s===e.materials[o].symbol){var a=e.materials[o].id;break}var l=this._materials[a],h=null,u=l&&l.textures&&n[r].uvs&&n[r].uvs.length>0;u&&(l.textures.diffuse?h=l.textures.diffuse.mapId:l.textures.reflective&&(h=l.textures.reflective.mapId)),this._entities.push({mesh:n[r],material:l,node:e,imageKey:h})}for(var c=0;c<e.children.length;c++)this.flattenNode(e.children[c])},d.prototype.render=function(e){var t,n=e.frustumInModelCoordinates;this.enabled&&(this.lastFrameTime!==e.timestamp&&(t=this.makeOrderedRenderable(e)),t&&n.containsPoint(this._placePoint)&&(t.layer=e.currentLayer,this.lastFrameTime=e.timestamp,e.addOrderedRenderable(t)))},d.prototype.makeOrderedRenderable=function(e){return e.surfacePointForMode(this._position.latitude,this._position.longitude,this._position.altitude,this._altitudeMode,this._placePoint),this.eyeDistance=e.eyePoint.distanceTo(this._placePoint),this},d.prototype.computeTransformedPoints=function(e){var t=e.vertices,n=[];if(e.indexedRendering)for(var r=e.indices,i=0,s=r.length;i<s;i+=3)for(var o=0;o<3;o++){var a=3*r[i+o],l=new u(t[a],t[a+1],t[a+2]);l.multiplyByMatrix(this._transformationMatrix),n.push(l)}else for(var i=0,s=t.length;i<s;i+=3){var l=new u(t[i],t[i+1],t[i+2]);l.multiplyByMatrix(this._transformationMatrix),n.push(l)}return n},d.prototype.computePointIntersections=function(t,n,r){if(!t)throw new e(s.logMessage(s.LEVEL_SEVERE,"ColladaScene","computePointIntersections","missingGlobe"));if(!n)throw new e(s.logMessage(s.LEVEL_SEVERE,"ColladaScene","computePointIntersections","missingRay"));if(!r)throw new e(s.logMessage(s.LEVEL_SEVERE,"ColladaScene","computePointIntersections","missingResults"));var i=n.origin,o=this._currentData.transformedPoints.length<=this._entities.length;o&&(this._currentData.transformedPoints=[]);for(var l=[],h=0,u=this._entities.length;h<u;h++){var d=this._entities[h].mesh;o&&this._currentData.transformedPoints.push(this.computeTransformedPoints(d));var f=[];if(c.computeTriangleListIntersection(n,this._currentData.transformedPoints[h],f))for(var p=0,m=f.length;p<m;p++){var g=new a(0,0,0);t.computePositionFromPoint(f[p][0],f[p][1],f[p][2],g);for(var b=f[p].distanceTo(i),y=!1,_=0,E=l.length;_<E&&!y;_++)b<l[_]&&(r.splice(_,0,g),l.splice(_,0,b),y=!0);y||(r.push(g),l.push(b))}}return r.length>0},d.prototype.renderOrdered=function(e){if(this.drawOrderedScene(e),e.pickingMode){var t=new l(this.pickColor.clone(),this,this._position,this.layer,!1);e.resolvePick(t)}},d.prototype.drawOrderedScene=function(e){try{this.beginDrawing(e)}finally{this.endDrawing(e)}},d.prototype.beginDrawing=function(e){this._currentData.expired&&this.resetCurrentData();var n=e.currentGlContext,r=e.gpuResourceCache,i=r.resourceForKey(this._vboCacheKey),s=r.resourceForKey(this._iboCacheKey);i||(this.setupBuffers(e),i=r.resourceForKey(this._vboCacheKey),s=r.resourceForKey(this._iboCacheKey)),n.bindBuffer(n.ARRAY_BUFFER,i),s&&n.bindBuffer(n.ELEMENT_ARRAY_BUFFER,s),e.findAndBindProgram(t),n.enableVertexAttribArray(0),this._doubleSided&&n.disable(n.CULL_FACE),e.pickingMode&&(this.pickColor=e.uniquePickColor()),this.computeTransformationMatrix(e.globe);for(var o=0,a=this._entities.length;o<a;o++){this.mustRenderNode(this._entities[o].node.id)&&this.draw(e,this._entities[o])}},d.prototype.rewriteBufferNormals=function(e){if(e._normalsComputed=!0,e.indexedRendering){var t=e.vertices,n=e.indices,r=e.uvs,i=e.uvs&&e.uvs.length>0,s=3*n.length,o=new Float32Array(s),a=new Float32Array(s),l=null;i&&(l=new Float32Array(2*n.length));for(var h=0,d=n.length;h<d;h+=3){for(var f=[],p=0;p<3;p++){var m=3*n[h+p],g=new u(t[m],t[m+1],t[m+2]);f.push(g);var b=3*(h+p);if(o[b]=t[m],o[b+1]=t[m+1],o[b+2]=t[m+2],i){var y=2*n[h+p],_=2*(h+p);l[_]=r[y],l[_+1]=r[y+1]}}for(var E=c.computeTriangleNormal(f[0],f[1],f[2]),p=0;p<3;p++){var b=3*(h+p);a[b]=E[0],a[b+1]=E[1],a[b+2]=E[2]}}e.indexedRendering=!1,e.vertices=o,e.normals=a,e.indices=null,i&&(e.uvs=l)}return e},d.prototype.setupBuffers=function(e){for(var t=e.currentGlContext,n=Float32Array.BYTES_PER_ELEMENT||4,r=Uint16Array.BYTES_PER_ELEMENT||2,i=Uint32Array.BYTES_PER_ELEMENT||4,o=!1,a=0,l=0,h=0,u=this._entities.length;h<u;h++){this._computedNormals&&!this._entities[h].mesh._normalsComputed&&(this._entities[h].mesh=this.rewriteBufferNormals(this._entities[h].mesh));var c=this._entities[h].mesh;c.indexedRendering&&(a+=c.indices.length,c.indices instanceof Uint32Array&&(o=!0)),l+=c.vertices.length,this._entities[h].imageKey&&(l+=c.uvs.length),c.normals&&c.normals.length&&(l+=c.normals.length)}var d=t.createBuffer();t.bindBuffer(t.ARRAY_BUFFER,d),t.bufferData(t.ARRAY_BUFFER,l*n,t.STATIC_DRAW);var f=0;for(h=0,u=this._entities.length;h<u;h++){var p=this._entities[h].mesh.vertices;this._entities[h].vertexOffset=f,t.bufferSubData(t.ARRAY_BUFFER,f*n,p),f+=p.length}for(h=0,u=this._entities.length;h<u;h++)this._entities[h].imageKey&&(p=this._entities[h].mesh.uvs,this._entities[h].uvOffset=f,t.bufferSubData(t.ARRAY_BUFFER,f*n,p),f+=p.length);for(h=0,u=this._entities.length;h<u;h++)(p=p=this._entities[h].mesh.normals)&&p.length&&(this._entities[h].normalOffset=f,t.bufferSubData(t.ARRAY_BUFFER,f*n,p),f+=p.length);var m,g=r,b=a*g;if(o&&(m=e.getExtension("OES_element_index_uint"),m?(g=i,b=a*g):s.log(s.LEVEL_SEVERE,'The 3D model is too big and might not render properly. \nYour browser does not support the "OES_element_index_uint" extension, required to render large models.')),a){var y=t.createBuffer();for(t.bindBuffer(t.ELEMENT_ARRAY_BUFFER,y),t.bufferData(t.ELEMENT_ARRAY_BUFFER,b,t.STATIC_DRAW),f=0,h=0,u=this._entities.length;h<u;h++)c=this._entities[h].mesh,c.indexedRendering&&(p=c.indices,p instanceof Uint32Array&&!m&&(p=new Uint16Array(p)),this._entities[h].indexOffset=f,this._entities[h].indexSize=g,t.bufferSubData(t.ELEMENT_ARRAY_BUFFER,f*g,p),f+=p.length)}this._vboCacheKey=e.gpuResourceCache.generateCacheKey(),e.gpuResourceCache.putResource(this._vboCacheKey,d,l*n),a&&(this._iboCacheKey=e.gpuResourceCache.generateCacheKey(),e.gpuResourceCache.putResource(this._iboCacheKey,y,b))},d.prototype.draw=function(e,t){var n,r=e.currentGlContext,i=e.currentProgram,s=e.gpuResourceCache,o=t.mesh,a=t.material,l=t.node.worldMatrix,h=t.node.normalMatrix;n=!this._doubleSided&&(o.normals&&o.normals.length);var u=t.imageKey;if(this.applyColor(e,a),u){var c=this._useTexturePaths?this._images[u].path:this._images[u].filename,d=this._dirPath+c;if(this._activeTexture=s.resourceForKey(d),!this._activeTexture){var f=o.isClamp?r.CLAMP_TO_EDGE:r.REPEAT;this._activeTexture=s.retrieveTexture(r,d,f)}this._activeTexture&&this._activeTexture.bind(e)?(i.loadTextureEnabled(r,!0),r.vertexAttribPointer(2,2,r.FLOAT,!1,8,4*t.uvOffset),r.enableVertexAttribArray(2),i.loadModulateColor(r,e.pickingMode)):(i.loadTextureEnabled(r,!1),r.disableVertexAttribArray(2))}else i.loadTextureEnabled(r,!1),r.disableVertexAttribArray(2);if(n&&!e.pickingMode?(i.loadApplyLighting(r,1),r.vertexAttribPointer(1,3,r.FLOAT,!1,12,4*t.normalOffset),r.enableVertexAttribArray(1)):(i.loadApplyLighting(r,0),r.disableVertexAttribArray(1)),this.applyMatrix(e,n,d,l,h),r.vertexAttribPointer(0,3,r.FLOAT,!1,12,4*t.vertexOffset),o.indexedRendering){var p=t.indexOffset*t.indexSize;o.indices instanceof Uint32Array&&e.getExtension("OES_element_index_uint")?r.drawElements(r.TRIANGLES,o.indices.length,r.UNSIGNED_INT,p):r.drawElements(r.TRIANGLES,o.indices.length,r.UNSIGNED_SHORT,p)}else r.drawArrays(r.TRIANGLES,0,Math.floor(o.vertices.length/3))},d.prototype.applyColor=function(e,t){var n=e.currentGlContext,r=e.currentProgram;if(t)if("constant"===t.techniqueType)var i=t.reflective;else i=t.diffuse;var s,o=1,a=1,l=1,h=1;i&&(o=i[0],a=i[1],l=i[2],h=null!=i[3]?i[3]:1),this._tmpColor.set(o,a,l,h),s=h*this.layer.opacity,n.depthMask(s>=1||e.pickingMode),r.loadColor(n,e.pickingMode?this.pickColor:this._tmpColor),r.loadOpacity(n,e.pickingMode?s>0?1:0:s)},d.prototype.applyMatrix=function(e,t,n,r,i){this._mvpMatrix.copy(e.modelviewProjection),this._mvpMatrix.multiplyMatrix(this._transformationMatrix),r&&this._localTransforms&&this._mvpMatrix.multiplyMatrix(r),t&&!e.pickingMode&&(this._normalMatrix.copy(e.modelviewNormalTransform),this._normalMatrix.multiplyMatrix(this._normalTransformMatrix),i&&this._localTransforms&&this._normalMatrix.multiplyMatrix(i),e.currentProgram.loadModelviewInverse(e.currentGlContext,this._normalMatrix)),n&&this._activeTexture&&(e.currentProgram.loadTextureMatrix(e.currentGlContext,this._texCoordMatrix),this._activeTexture=null),e.currentProgram.loadModelviewProjection(e.currentGlContext,this._mvpMatrix)},d.prototype.endDrawing=function(e){var t=e.currentGlContext,n=e.currentProgram;this._doubleSided&&t.enable(t.CULL_FACE),t.disableVertexAttribArray(1),t.disableVertexAttribArray(2),n.loadApplyLighting(t,0),n.loadTextureEnabled(t,!1),this._currentData.expired=!1},d.prototype.computeTransformationMatrix=function(e){this._currentData.expired&&(this._transformationMatrix.setToIdentity(),this._transformationMatrix.multiplyByLocalCoordinateTransform(this._placePoint,e),this._transformationMatrix.multiplyByRotation(1,0,0,this._xRotation),this._transformationMatrix.multiplyByRotation(0,1,0,this._yRotation),this._transformationMatrix.multiplyByRotation(0,0,1,this._zRotation),this._transformationMatrix.multiplyByScale(this._scale,this._scale,this._scale),this._transformationMatrix.multiplyByTranslation(this._xTranslation,this._yTranslation,this._zTranslation),this.computeNormalMatrix())},d.prototype.computeNormalMatrix=function(){this._currentData.expired&&(this._transformationMatrix.extractRotationAngles(this._tmpVector),this._normalTransformMatrix.setToIdentity(),this._normalTransformMatrix.multiplyByRotation(-1,0,0,this._tmpVector[0]),this._normalTransformMatrix.multiplyByRotation(0,-1,0,this._tmpVector[1]),this._normalTransformMatrix.multiplyByRotation(0,0,-1,this._tmpVector[2]))},d.prototype.mustRenderNode=function(e){var t=!0;if(this._hideNodes){t=-1===this._nodesToHide.indexOf(e)}return t},d}),define("formats/collada/ColladaLoader",["../../error/ArgumentError","./ColladaAsset","./ColladaImage","./ColladaMaterial","./ColladaMesh","./ColladaNode","./ColladaScene","./ColladaUtils","../../util/Logger"],function(e,t,n,r,i,s,o,a,l){"use strict";var h=function(t,n){if(!t)throw new e(l.logMessage(l.LEVEL_SEVERE,"ColladaLoader","constructor","missingPosition"));this.position=t,this.dirPath="/",this.init(n)};return h.prototype.init=function(e){e&&(this.dirPath=e.dirPath||"/"),this.scene={type:"SceneTree",dirPath:this.dirPath,images:{},metadata:{},materials:{},meshes:{},root:{children:[]}},this.xmlDoc=null},h.prototype.load=function(e,t){-1===e.indexOf("://")&&(e=this.dirPath+e),a.fetchFile(e,function(e){if(e)try{n=this.parse(e)}catch(e){n=null,l.log(l.LEVEL_SEVERE,"error parsing collada file: "+e)}else var n=null;t(n)}.bind(this))},h.prototype.parse=function(e){this.init();var n=new DOMParser;this.xmlDoc=n.parseFromString(e,"text/xml");var r=this.xmlDoc.querySelectorAll("library_nodes node"),i=this.xmlDoc.querySelectorAll("library_effects effect");return this.scene.metadata=new t(this.xmlDoc).parse(),this.parseLib("visual_scene",r),this.parseLib("library_geometries"),this.parseLib("library_materials",i),this.parseLib("library_images"),this.xmlDoc=null,new o(this.position,this.scene)},h.prototype.parseLib=function(e,t){var o=this.xmlDoc.getElementsByTagName(e),l=[];o&&o.length&&(l=o[0].childNodes);for(var h=0;h<l.length;h++){var u=l[h];if(1===u.nodeType)switch(u.nodeName){case"node":var c=(new s).parse(u,t);if(c)for(var d=0,f=c.length;d<f;d++)this.scene.root.children.push(c[d]);break;case"geometry":var p=u.getAttribute("id"),m=u.querySelector("mesh"),g=new i(p).parse(m);g&&(this.scene.meshes[p]=g);break;case"material":var b=u.getAttribute("id"),y=u.querySelector("instance_effect"),_=y.getAttribute("url").substr(1),E=a.querySelectorById(t,_),v=new r(b).parse(E);v&&(this.scene.materials[b]=v);break;case"image":var w=u.getAttribute("id"),S=u.getAttribute("name"),T=new n(w,S).parse(u);T&&(this.scene.images[w]=T)}}},h}),define("shapes/Compass",["../error/ArgumentError","../util/Logger","../util/Offset","../shapes/ScreenImage"],function(e,t,n,r){"use strict";var i=function(e,t){
var i=e||new n(WorldWind.OFFSET_FRACTION,1,WorldWind.OFFSET_FRACTION,1),s=t||WorldWind.configuration.baseUrl+"images/notched-compass.png";r.call(this,i,s),e||(this.imageOffset=new n(WorldWind.OFFSET_FRACTION,1.1,WorldWind.OFFSET_FRACTION,1.1)),this.size=.15};return i.prototype=Object.create(r.prototype),i.prototype.render=function(e){this.imageRotation=e.camera.heading,this.imageTilt=e.camera.tilt;var t=this.getActiveTexture(e);t&&(this.imageScale=this.size*e.currentGlContext.drawingBufferWidth/t.imageWidth),r.prototype.render.call(this,e)},i}),define("layer/CompassLayer",["../shapes/Compass","../layer/RenderableLayer"],function(e,t){"use strict";var n=function(){t.call(this,"Compass"),this._compass=new e(null,null),this.addRenderable(this._compass)};return n.prototype=Object.create(t.prototype),Object.defineProperties(n.prototype,{compass:{get:function(){return this._compass},set:function(t){t&&t instanceof e&&(this.removeAllRenderables(),this.addRenderable(t),this._compass=t)}}}),n}),define("shapes/Text",["../error/ArgumentError","../shaders/BasicTextureProgram","../util/Color","../util/Font","../util/Logger","../geom/Matrix","../pick/PickedObject","../render/Renderable","../shapes/TextAttributes","../error/UnsupportedOperationError","../geom/Vec2","../geom/Vec3","../util/WWMath"],function(e,t,n,r,i,s,o,a,l,h,u,c,d){"use strict";var f=function(t){if(!t)throw new e(i.logMessage(i.LEVEL_SEVERE,"Text","constructor","missingText"));a.call(this),this.attributes=new l(null),this.highlightAttributes=null,this.highlighted=!1,this.enabled=!0,this.text=t,this.altitudeMode=WorldWind.ABSOLUTE,this.pickDelegate=null,this.alwaysOnTop=!1,this.targetVisibility=1,this.currentVisibility=1,this.declutterGroup=0,this.markerImageSource=WorldWind.configuration.baseUrl+"images/white-dot.png",this.markerImageScale=.1,this.activeAttributes=null,this.activeTexture=null,this.imageTransform=s.fromIdentity(),this.imageBounds=null,this.layer=null,this.depthOffset=-.003,this.screenPoint=new c(0,0,0)};return f.matrix=s.fromIdentity(),f.glPickPoint=new c(0,0,0),f.prototype=Object.create(a.prototype),f.prototype.copy=function(e){return this.text=e.text,this.attributes=e.attributes,this.highlightAttributes=e.highlightAttributes,this.highlighted=e.highlighted,this.enabled=e.enabled,this.altitudeMode=e.altitudeMode,this.pickDelegate=e.pickDelegate,this.alwaysOnTop=e.alwaysOnTop,this.depthOffset=e.depthOffset,this.declutterGroup=e.declutterGroup,this.targetVisibility=e.targetVisibility,this.currentVisibility=e.currentVisibility,this},Object.defineProperties(f.prototype,{screenBounds:{get:function(){return this.imageBounds}}}),f.prototype.render=function(e){if(this.enabled&&this.text&&0!==this.text.length&&e.accumulateOrderedRenderables){var t;if(this.lastFrameTime!==e.timestamp)t=this.makeOrderedRenderable(e);else{t=this.clone().makeOrderedRenderable(e)}t&&t.isVisible(e)&&(t.layer=e.currentLayer,this.lastFrameTime=e.timestamp,e.addOrderedRenderable(t))}},f.prototype.renderOrdered=function(e){if((0!==this.currentVisibility||0!==this.targetVisibility||this.markerImageSource)&&(this.drawOrderedText(e),e.pickingMode)){var t=new o(this.pickColor.clone(),this.pickDelegate?this.pickDelegate:this,this.position,this.layer,!1);e.resolvePick(t)}},f.prototype.makeOrderedRenderable=function(e){var t,n,r,i;return this.determineActiveAttributes(e),this.activeAttributes&&this.computeScreenPointAndEyeDistance(e)?(this.activeTexture=e.createTextTexture(this.text,this.activeAttributes),t=this.activeTexture.imageWidth,n=this.activeTexture.imageHeight,r=this.activeAttributes.scale,i=this.activeAttributes.offset.offsetForSize(t,n),this.imageTransform.setTranslation(this.screenPoint[0]-i[0]*r,this.screenPoint[1]-i[1]*r,this.screenPoint[2]),this.imageTransform.setScale(t*r,n*r,1),this.imageBounds=d.boundingRectForUnitQuad(this.imageTransform),this):null},f.prototype.computeScreenPointAndEyeDistance=function(e){throw new h(i.logMessage(i.LEVEL_SEVERE,"Renderable","render","abstractInvocation"))},f.prototype.determineActiveAttributes=function(e){this.highlighted&&this.highlightAttributes?this.activeAttributes=this.highlightAttributes:this.activeAttributes=this.attributes},f.prototype.isVisible=function(e){return e.pickingMode?e.pickRectangle&&this.imageBounds.intersects(e.pickRectangle):this.imageBounds.intersects(e.viewport)},f.prototype.drawOrderedText=function(e){this.beginDrawing(e);try{this.doDrawOrderedText(e),e.pickingMode}finally{this.endDrawing(e)}},f.prototype.drawBatchOrderedText=function(e){for(var t;(t=e.peekOrderedRenderable())&&t instanceof f;){e.popOrderedRenderable();try{t.doDrawOrderedText(e)}catch(e){i.logMessage(i.LEVEL_WARNING,"Text","drawBatchOrderedText","Error occurred while rendering text using batching: "+e.message)}}},f.prototype.beginDrawing=function(e){var n,r=e.currentGlContext;e.findAndBindProgram(t),n=e.currentProgram,r.bindBuffer(r.ARRAY_BUFFER,e.unitQuadBuffer3()),r.vertexAttribPointer(n.vertexPointLocation,3,r.FLOAT,!1,0,0),r.bindBuffer(r.ARRAY_BUFFER,e.unitQuadBuffer()),r.vertexAttribPointer(n.vertexTexCoordLocation,2,r.FLOAT,!1,0,0),r.enableVertexAttribArray(n.vertexPointLocation),r.enableVertexAttribArray(n.vertexTexCoordLocation),n.loadTextureUnit(r,r.TEXTURE0),n.loadModulateColor(r,!1),r.depthMask(!1)},f.prototype.endDrawing=function(e){var t=e.currentGlContext,n=e.currentProgram;t.disableVertexAttribArray(n.vertexPointLocation),t.disableVertexAttribArray(n.vertexTexCoordLocation),t.bindBuffer(t.ARRAY_BUFFER,null),t.bindTexture(t.TEXTURE_2D,null),t.depthMask(!0)},f.prototype.doDrawOrderedText=function(e){var t=e.currentGlContext,r=e.currentProgram;if(!e.pickingMode&&this.currentVisibility!==this.targetVisibility){var i=(e.timestamp-e.previousRedrawTimestamp)/e.fadeTime;this.currentVisibility<this.targetVisibility?this.currentVisibility=Math.min(1,this.currentVisibility+i):this.currentVisibility=Math.max(0,this.currentVisibility-i),e.redrawRequested=!0}this.activeAttributes.depthTest||t.disable(t.DEPTH_TEST),e.pickingMode?(this.pickColor=e.uniquePickColor(),r.loadColor(t,this.pickColor),r.loadOpacity(t,1),r.loadTextureEnabled(t,!1)):(r.loadColor(t,n.WHITE),r.loadOpacity(t,this.layer.opacity*this.currentVisibility)),this.currentVisibility>0&&this.drawLabel(e),this.currentVisibility<1&&this.markerImageSource&&this.drawMarker(e),this.activeAttributes.depthTest||t.enable(t.DEPTH_TEST)},f.prototype.drawLabel=function(e){var t,n=e.currentGlContext,r=e.currentProgram;!e.pickingMode&&this.activeTexture&&(f.matrix.setToIdentity(),f.matrix.multiplyByTextureTransform(this.activeTexture),t=this.activeTexture.bind(e),r.loadTextureEnabled(n,t),r.loadTextureMatrix(n,f.matrix)),f.matrix.copy(e.screenProjection),f.matrix.multiplyMatrix(this.imageTransform),r.loadModelviewProjection(n,f.matrix),n.drawArrays(n.TRIANGLE_STRIP,0,4)},f.prototype.drawMarker=function(e){var t,n=e.currentGlContext,r=e.currentProgram,i=e.gpuResourceCache.resourceForKey(this.markerImageSource);if(!i)return void e.gpuResourceCache.retrieveTexture(e.currentGlContext,this.markerImageSource);e.pickingMode||(f.matrix.setToIdentity(),f.matrix.multiplyByTextureTransform(i),t=i.bind(e),r.loadTextureEnabled(n,t),r.loadTextureMatrix(n,f.matrix),r.loadOpacity(n,this.layer.opacity*(1-this.currentVisibility)));var s=this.markerImageScale;f.matrix.copy(e.screenProjection),f.matrix.multiplyByTranslation(this.screenPoint[0]-s*i.imageWidth/2,this.screenPoint[1]-s*i.imageWidth/2,this.screenPoint[2]),f.matrix.multiplyByScale(i.imageWidth*s,i.imageHeight*s,1),r.loadModelviewProjection(n,f.matrix),n.drawArrays(n.TRIANGLE_STRIP,0,4)},f}),define("shapes/ScreenText",["../error/ArgumentError","../util/Logger","../util/Offset","../shapes/Text"],function(e,t,n,r){"use strict";var i=function(n,i){if(!n)throw new e(t.logMessage(t.LEVEL_SEVERE,"Text","constructor","missingOffset"));r.call(this,i),this.screenOffset=n,this.altitudeMode=null};return i.prototype=Object.create(r.prototype),i.prototype.render=function(e){this.lastFrameTime!==e.timestamp&&r.prototype.render.call(this,e)},i.prototype.computeScreenPointAndEyeDistance=function(e){var t=e.currentGlContext,n=this.screenOffset.offsetForSize(t.drawingBufferWidth,t.drawingBufferHeight);return this.screenPoint[0]=n[0],this.screenPoint[1]=n[1],this.screenPoint[2]=0,this.eyeDistance=0,!0},i}),define("layer/CoordinatesDisplayLayer",["../error/ArgumentError","../util/Color","../util/Font","../layer/Layer","../util/Logger","../util/Offset","../geom/Position","../shapes/ScreenImage","../shapes/ScreenText","../shapes/TextAttributes","../geom/Vec2"],function(e,t,n,r,i,s,o,a,l,h,u){"use strict";var c=function(n){function o(e){f.handleUIEvent(e)}function u(e,t){f.handleRedraw(t)}if(!n)throw new e(i.logMessage(i.LEVEL_SEVERE,"CoordinatesDisplayLayer","constructor","missingWorldWindow"));r.call(this,"Coordinates"),this.wwd=n,this.pickEnabled=!1,this.eventType=null,this.clientX=null,this.clientY=null,this.terrainPosition=null,this.latText=new l(new s(WorldWind.OFFSET_PIXELS,0,WorldWind.OFFSET_PIXELS,0)," "),this.latText.attributes=new h(null),this.latText.attributes.color=t.YELLOW,this.lonText=new l(new s(WorldWind.OFFSET_PIXELS,0,WorldWind.OFFSET_PIXELS,0)," "),this.lonText.attributes=new h(null),this.lonText.attributes.color=t.YELLOW,this.elevText=new l(new s(WorldWind.OFFSET_PIXELS,0,WorldWind.OFFSET_PIXELS,0)," "),this.elevText.attributes=new h(null),this.elevText.attributes.color=t.YELLOW,this.eyeText=new l(new s(WorldWind.OFFSET_PIXELS,0,WorldWind.OFFSET_PIXELS,0)," "),this.eyeText.attributes=new h(null),this.eyeText.attributes.color=t.YELLOW;var c=new s(WorldWind.OFFSET_FRACTION,.5,WorldWind.OFFSET_FRACTION,.5),d=WorldWind.configuration.baseUrl+"images/crosshair.png";this.crosshairImage=new a(c,d);var f=this;window.PointerEvent?(n.addEventListener("pointerdown",o),n.addEventListener("pointermove",o),n.addEventListener("pointerleave",o)):(n.addEventListener("mousedown",o),n.addEventListener("mousemove",o),n.addEventListener("mouseleave",o),n.addEventListener("touchstart",o),n.addEventListener("touchmove",o)),this.wwd.redrawCallbacks.push(u)};return c.prototype=Object.create(r.prototype),c.prototype.doRender=function(e){var t,n,r,i,o,a=this.terrainPosition,l=e.eyePosition,h=e.currentGlContext.canvas.clientWidth;h>650?(t=h/2-50,n=11,r=WorldWind.OFFSET_PIXELS,i=0):h>400?(t=60,n=5,r=WorldWind.OFFSET_INSET_PIXELS,i=1):(t=60,n=5,r=WorldWind.OFFSET_INSET_PIXELS,i=1,o=!0),this.latText.text=a?this.formatLatitude(a.latitude):null,this.latText.screenOffset=new s(WorldWind.OFFSET_PIXELS,t,r,n),this.latText.attributes.offset=new s(WorldWind.OFFSET_FRACTION,1,WorldWind.OFFSET_FRACTION,i),this.latText.render(e),t+=70,this.lonText.text=a?this.formatLongitude(a.longitude):null,this.lonText.screenOffset=new s(WorldWind.OFFSET_PIXELS,t,r,n),this.lonText.attributes.offset=new s(WorldWind.OFFSET_FRACTION,1,WorldWind.OFFSET_FRACTION,i),this.lonText.render(e),e.globe.is2D()||(t+=70,this.elevText.text=a?this.formatAltitude(a.altitude,"m"):null,this.elevText.screenOffset=new s(WorldWind.OFFSET_PIXELS,t,r,n),this.elevText.attributes.offset=new s(WorldWind.OFFSET_FRACTION,1,WorldWind.OFFSET_FRACTION,i),this.elevText.render(e)),o||(t+=40,this.eyeText.text="Eye  "+this.formatAltitude(l.altitude,l.altitude<1e3?"m":"km"),this.eyeText.screenOffset=new s(WorldWind.OFFSET_PIXELS,t,r,n),this.eyeText.attributes.offset=new s(WorldWind.OFFSET_FRACTION,0,WorldWind.OFFSET_FRACTION,i),this.eyeText.render(e)),"touch"===this.eventType&&this.crosshairImage.render(e),this.inCurrentFrame=!0},c.prototype.handleUIEvent=function(e){-1!==e.type.indexOf("pointer")?this.eventType=e.pointerType:-1!==e.type.indexOf("mouse")?this.eventType="mouse":-1!==e.type.indexOf("touch")&&(this.eventType="touch"),-1!==e.type.indexOf("leave")?(this.clientX=null,this.clientY=null):(this.clientX=e.clientX,this.clientY=e.clientY),this.wwd.redraw()},c.prototype.handleRedraw=function(e){if(e===WorldWind.BEFORE_REDRAW){var t,n;("mouse"===this.eventType||"pen"===this.eventType)&&this.clientX&&this.clientY?(t=this.wwd.canvasCoordinates(this.clientX,this.clientY),t[0]>=0&&t[0]<this.wwd.canvas.width&&t[1]>=0&&t[1]<this.wwd.canvas.height&&(n=this.wwd.pickTerrain(t).terrainObject())):"touch"===this.eventType&&(t=new u(this.wwd.canvas.width/2,this.wwd.canvas.height/2),n=this.wwd.pickTerrain(t).terrainObject()),this.terrainPosition=n?n.position:null}},c.prototype.formatLatitude=function(e){var t=e<0?"°S":"°N";return Math.abs(e).toFixed(2)+t},c.prototype.formatLongitude=function(e){var t=e<0?"°W":"°E";return Math.abs(e).toFixed(2)+t},c.prototype.formatAltitude=function(e,t){return"km"===t&&(e/=1e3),e.toFixed(0).replace(/\B(?=(\d{3})+(?!\d))/g,",")+" "+t},c}),define("util/Date",[],function(){"use strict";var e=function(e){this._date=e?new Date(e):new Date};return e.prototype=Object.create(Date.prototype),e.prototype.isAfter=function(e){return-1==this.compare(e)},e.prototype.isBefore=function(e){return 1==this.compare(e)},e.prototype.valueOf=function(){return this._date.valueOf()},e.prototype.getTime=function(){return this._date.getTime()},e.prototype.compare=function(e){var t=this._date.valueOf(),n=e.valueOf();return t>n?-1:t<n?1:0},e}),define("layer/DigitalGlobeTiledImageLayer",["../error/ArgumentError","../util/Color","../util/Logger","../layer/MercatorTiledImageLayer"],function(e,t,n,r){"use strict";var i=function(t,i,s){if(!i)throw new e(n.logMessage(n.LEVEL_SEVERE,"DigitalGlobeTiledImageLayer","constructor","The map ID is null or undefined."));if(!s)throw new e(n.logMessage(n.LEVEL_SEVERE,"DigitalGlobeTiledImageLayer","constructor","The access token is null or undefined."));r.call(this,t||"Digital Globe",19,"image/jpeg",t,256,1),this.mapId=i,this.accessToken=s,this.pickEnabled=!0,this.destCanvas=document.createElement("canvas"),this.destContext=this.destCanvas.getContext("2d"),this.requestMetadata();var o=this;this.urlBuilder={urlForTile:function(e,t){return o.metadataRetrievalInProcess?null:o.urlTemplate.replace("{z}",e.level.levelNumber+1).replace("{x}",e.column).replace("{y}",e.row)}}};return i.prototype=Object.create(r.prototype),i.prototype.requestMetadata=function(){if(!this.metadataRetrievalInProcess){this.metadataRetrievalInProcess=!0;var e="https://api.mapbox.com/v4/"+this.mapId+".json?secure&access_token="+this.accessToken,t=new XMLHttpRequest,n=this;t.onreadystatechange=function(){if(4===t.readyState&&200===t.status){var e=JSON.parse(t.responseText);n.urlTemplate=e.tiles[0];var r=document.createEvent("Event");r.initEvent(WorldWind.REDRAW_EVENT_TYPE,!0,!0),window.dispatchEvent(r),n.metadataRetrievalInProcess=!1}},t.open("GET",e,!0),t.send()}},i.prototype.doRender=function(e){r.prototype.doRender.call(this,e),this.inCurrentFrame&&e.screenCreditController.addCredit("© Digital Globe",t.DARK_GRAY)},i}),define("util/FrameStatistics",[],function(){"use strict";var e=function(){this.frameCount=0,this.frameTimeCumulative=0,this.frameTimeBase=0,this.frameTimeExtremes=[Number.POSITIVE_INFINITY,Number.NEGATIVE_INFINITY],this.frameTime=0,this.tessellationTime=0,this.layerRenderingTime=0,this.orderedRenderingTime=0,this.terrainTileCount=0,this.imageTileCount=0,this.renderedTileCount=0,this.tileUpdateCount=0,this.textureLoadCount=0,this.vboLoadCount=0,this.frameTimeAverage=0,this.frameRateAverage=0,this.frameTimeMin=0,this.frameTimeMax=0};return e.prototype.beginFrame=function(){this.frameTime=Date.now(),this.tessellationTime=0,this.layerRenderingTime=0,this.orderedRenderingTime=0,this.terrainTileCount=0,this.imageTileCount=0,this.renderedTileCount=0,this.tileUpdateCount=0,this.textureLoadCount=0,this.vboLoadCount=0,++this.frameCount},e.prototype.endFrame=function(){var e=Date.now();this.frameTime=e-this.frameTime,this.frameTimeCumulative+=this.frameTime,this.frameTimeExtremes[0]=Math.min(this.frameTimeExtremes[0],this.frameTime),this.frameTimeExtremes[1]=Math.max(this.frameTimeExtremes[1],this.frameTime),e-this.frameTimeBase>2e3&&(this.frameTimeAverage=this.frameTimeCumulative/this.frameCount,this.frameRateAverage=1e3*this.frameCount/(e-this.frameTimeBase),this.frameTimeMin=this.frameTimeExtremes[0],this.frameTimeMax=this.frameTimeExtremes[1],this.frameCount=0,this.frameTimeCumulative=0,this.frameTimeBase=e,this.frameTimeExtremes=[Number.POSITIVE_INFINITY,Number.NEGATIVE_INFINITY])},e.prototype.incrementRenderedTileCount=function(e){this.renderedTileCount+=e},e.prototype.setTerrainTileCount=function(e){this.terrainTileCount=e},e.prototype.incrementImageTileCount=function(e){this.imageTileCount=e},e.prototype.incrementTileUpdateCount=function(e){this.tileUpdateCount+=e},e.prototype.incrementTextureLoadCount=function(e){this.textureLoadCount+=e},e.prototype.incrementVboLoadCount=function(e){this.vboLoadCount+=e},e}),define("render/FramebufferTexture",["../error/ArgumentError","../util/Logger","../util/WWMath"],function(e,t){"use strict";var n=function(n,r,i,s){if(!n)throw new e(t.logMessage(t.LEVEL_SEVERE,"FramebufferTexture","constructor","missingGlContext"));if(r<0||i<0)throw new e(t.logMessage(t.LEVEL_SEVERE,"FramebufferTexture","constructor","The framebuffer width or height is less than zero."));this.width=r,this.height=i,this.depth=s,this.size=r*i*4+(s?r*i*2:0),this.framebufferId=n.createFramebuffer(),n.bindFramebuffer(n.FRAMEBUFFER,this.framebufferId),this.texture=n.createTexture(),n.bindTexture(n.TEXTURE_2D,this.texture),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MIN_FILTER,n.LINEAR),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MAG_FILTER,n.LINEAR),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_S,n.CLAMP_TO_EDGE),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_T,n.CLAMP_TO_EDGE),n.texImage2D(n.TEXTURE_2D,0,n.RGBA,r,i,0,n.RGBA,n.UNSIGNED_BYTE,null),n.framebufferTexture2D(n.FRAMEBUFFER,n.COLOR_ATTACHMENT0,n.TEXTURE_2D,this.texture,0),this.depthBuffer=null,s&&(this.depthBuffer=n.createRenderbuffer(),n.bindRenderbuffer(n.RENDERBUFFER,this.depthBuffer),n.renderbufferStorage(n.RENDERBUFFER,n.DEPTH_COMPONENT16,r,i),n.framebufferRenderbuffer(n.FRAMEBUFFER,n.DEPTH_ATTACHMENT,n.RENDERBUFFER,this.depthBuffer));var o=n.checkFramebufferStatus(n.FRAMEBUFFER);o!=n.FRAMEBUFFER_COMPLETE&&(t.logMessage(t.LEVEL_WARNING,"FramebufferTexture","constructor","Error creating framebuffer: "+o),this.framebufferId=null,this.texture=null,this.depthBuffer=null),n.bindFramebuffer(n.FRAMEBUFFER,null),n.bindRenderbuffer(n.RENDERBUFFER,null),n.bindTexture(n.TEXTURE_2D,null)};return n.prototype.bind=function(e){return this.texture&&e.currentGlContext.bindTexture(gl.TEXTURE_2D,this.texture),!!this.texture},n}),define("render/FramebufferTile",["../error/ArgumentError","../render/FramebufferTexture","../util/Logger","../geom/Matrix","../geom/Rectangle","../render/TextureTile"],function(e,t,n,r,i,s){"use strict";var o=function(t,i,o,a,l){if(!l||l.length<1)throw new e(n.logMessage(n.LEVEL_SEVERE,"FramebufferTile","constructor","The specified cache name is null, undefined or zero length."));s.call(this,t,i,o,a),this.gpuCacheKey=l,this.textureTransform=r.fromIdentity().setToUnitYFlip(),this.mustClear=!0};return o.prototype=Object.create(s.prototype),o.prototype.clearFramebuffer=function(e){this.mustClear=!0},o.prototype.bindFramebuffer=function(e){var t=e.gpuResourceCache.resourceForKey(this.gpuCacheKey);return t||(t=this.createFramebuffer(e)),e.bindFramebuffer(t),this.mustClear&&(this.doClearFramebuffer(e),this.mustClear=!1),!0},o.prototype.createFramebuffer=function(e){var n=new t(e.currentGlContext,this.tileWidth,this.tileHeight,!1);return e.gpuResourceCache.putResource(this.gpuCacheKey,n,n.size),n},o.prototype.doClearFramebuffer=function(e){var t=e.currentGlContext;t.clearColor(0,0,0,0),t.clear(t.COLOR_BUFFER_BIT)},o.prototype.applyInternalTransform=function(e,t){t.multiplyMatrix(this.textureTransform)},o}),define("render/FramebufferTileController",["../error/ArgumentError","../render/FramebufferTile","../util/LevelSet","../geom/Location","../util/Logger","../cache/MemoryCache","../geom/Sector","../util/Tile"],function(e,t,n,r,i,s,o,a){"use strict";var l=function(){this.tileWidth=256,this.tileHeight=256,this.detailControl=1.75,this.levels=new n(o.FULL_SPHERE,new r(45,45),16,this.tileWidth,this.tileHeight),this.topLevelTiles=[],this.currentTiles=[],this.currentTimestamp=null,this.currentGlobeStateKey=null,this.tileCache=new s(5e5,4e5),this.key="FramebufferTileController "+ ++l.keyPool};return l.keyPool=0,l.prototype.selectTiles=function(t,n){if(!n)throw new e(i.logMessage(i.LEVEL_SEVERE,"FramebufferTileController","selectTiles","missingSector"));this.assembleTiles(t);for(var r=[],s=0,o=this.currentTiles.length;s<o;s++){var a=this.currentTiles[s];a.sector.overlaps(n)&&(a.selected=!0,r.push(a))}return r},l.prototype.render=function(e){if(0!=this.currentTiles.length){for(var t=[],n=0,r=this.currentTiles.length;n<r;n++){var i=this.currentTiles[n];i.selected&&t.push(i)}e.surfaceTileRenderer.renderTiles(e,t,1);var s=e.currentGlContext,o=e.currentFramebuffer;try{for(s.clearColor(0,0,0,0),n=0,r=t.length;n<r;n++)i=t[n],i.selected=!1,i.bindFramebuffer(e),s.clear(s.COLOR_BUFFER_BIT)}finally{e.bindFramebuffer(o)}}},l.prototype.assembleTiles=function(e){var t=e.timestamp,n=e.globeStateKey;this.currentTimestamp==t&&this.currentGlobeStateKey==n||(this.doAssembleTiles(e),this.currentTimestamp=t,this.currentGlobeStateKey=n)},l.prototype.doAssembleTiles=function(e){if(this.currentTiles=[],e.terrain){0==this.topLevelTiles.length&&this.createTopLevelTiles();for(var t=0,n=this.topLevelTiles.length;t<n;t++){var r=this.topLevelTiles[t];r.update(e),this.isTileVisible(e,r)&&this.addTileOrDescendants(e,r)}}},l.prototype.createTile=function(e,n,r,i){var s=this.key+" "+n.levelNumber+"."+r+"."+i;return new t(e,n,r,i,s)},l.prototype.createTopLevelTiles=function(){a.createTilesForLevel(this.levels.firstLevel(),this,this.topLevelTiles)},l.prototype.addTileOrDescendants=function(e,t){if(this.tileMeetsRenderingCriteria(e,t))return void this.addTile(t);for(var n=t.subdivideToCache(t.level.nextLevel(),this,this.tileCache),r=0,i=n.length;r<i;r++){var s=n[r];s.update(e),this.isTileVisible(e,s)&&this.addTileOrDescendants(e,s)}},l.prototype.addTile=function(e){this.currentTiles.push(e)},l.prototype.isTileVisible=function(e,t){return!(e.globe.projectionLimits&&!t.sector.overlaps(e.globe.projectionLimits))&&(e.pickingMode?t.extent.intersectsFrustum(e.pickFrustum):t.extent.intersectsFrustum(e.frustumInModelCoordinates))},l.prototype.tileMeetsRenderingCriteria=function(e,t){var n=this.detailControl;return(t.sector.minLatitude>=75||t.sector.maxLatitude<=-75)&&(n*=1.2),t.level.isLastLevel()||!t.mustSubdivide(e,n)},l}),define("cache/GpuResourceCache",["../util/AbsentResourceList","../error/ArgumentError","../util/ImageSource","../util/Logger","../cache/MemoryCache","../render/Texture"],function(e,t,n,r,i,s){"use strict";var o=function(n,s){if(!n||n<1)throw new t(r.logMessage(r.LEVEL_SEVERE,"GpuResourceCache","constructor","Specified cache capacity is undefined, 0 or negative."));if(!s||s<0||s>=n)throw new t(r.logMessage(r.LEVEL_SEVERE,"GpuResourceCache","constructor","Specified cache low-water value is undefined, negative or not less than the capacity."));this.entries=new i(n,s),this.cacheKeyPool=0,this.currentRetrievals={},this.absentResourceList=new e(3,6e4)};return Object.defineProperties(o.prototype,{capacity:{get:function(){return this.entries.capacity}},lowWater:{get:function(){return this.entries.lowWater}},usedCapacity:{get:function(){return this.entries.usedCapacity}},freeCapacity:{get:function(){return this.entries.freeCapacity}}}),o.prototype.generateCacheKey=function(){return"GpuResourceCache "+ ++this.cacheKeyPool},o.prototype.putResource=function(e,i,s){if(!e)throw new t(r.logMessage(r.LEVEL_SEVERE,"GpuResourceCache","putResource","missingKey."));if(!i)throw new t(r.logMessage(r.LEVEL_SEVERE,"GpuResourceCache","putResource","missingResource."));if(!s||s<1)throw new t(r.logMessage(r.LEVEL_SEVERE,"GpuResourceCache","putResource","The specified resource size is undefined or less than 1."));var o={resource:i};this.entries.putEntry(e instanceof n?e.key:e,o,s)},o.prototype.resourceForKey=function(e){var t=e instanceof n?this.entries.entryForKey(e.key):this.entries.entryForKey(e),r=t?t.resource:null;return null!==r&&"function"==typeof r.clearTexParameters&&r.clearTexParameters(),r},o.prototype.setResourceAgingFactor=function(e,t){this.entries.setEntryAgingFactor(e,t)},o.prototype.containsResource=function(e){return this.entries.containsKey(e instanceof n?e.key:e)},o.prototype.removeResource=function(e){this.entries.removeEntry(e instanceof n?e.key:e)},o.prototype.clear=function(){this.entries.clear(!1)},o.prototype.retrieveTexture=function(e,t,i,o,a){if(!t)return null;if(t instanceof n){var l=new s(e,t.image,i);return this.putResource(t.key,l,l.size),l}if(this.currentRetrievals[t]||this.absentResourceList.isResourceAbsent(t))return null;var h=this,u=new Image;return u.onload=function(){r.log(r.LEVEL_INFO,"Image retrieval succeeded: "+t);var n="number"==typeof o&&o>0,l="number"==typeof a&&a>0;if(u.width||u.height){var c=n?u.width/o:0,d=l?u.height/a:0,f=d>c?d:c;f>0&&(u.width=u.width/f,u.height=u.height/f)}else n&&l&&(u.width=o,u.height=a);var p=new s(e,u,i);h.putResource(t,p,p.size),delete h.currentRetrievals[t],h.absentResourceList.unmarkResourceAbsent(t);var m=document.createEvent("Event");m.initEvent(WorldWind.REDRAW_EVENT_TYPE,!0,!0),window.dispatchEvent(m)},u.onerror=function(){delete h.currentRetrievals[t],h.absentResourceList.markResourceAbsent(t),r.log(r.LEVEL_WARNING,"Image retrieval failed: "+t)},this.currentRetrievals[t]=t,u.crossOrigin="anonymous",u.src=t,null},o}),define("pick/PickedObjectList",[],function(){"use strict";var e=function(){this.objects=[]};return e.prototype.hasNonTerrainObjects=function(){return this.objects.length>1||1===this.objects.length&&null==this.terrainObject()},e.prototype.terrainObject=function(){for(var e=0,t=this.objects.length;e<t;e++)if(this.objects[e].isTerrain)return this.objects[e];return null},e.prototype.add=function(e){if(e)if(e.isTerrain){for(var t=this.objects.length,n=0,r=this.objects.length;n<r;n++)if(this.objects[n].isTerrain){t=n;break}this.objects[t]=e}else this.objects.push(e)},e.prototype.clear=function(){this.objects=[]},e.prototype.topPickedObject=function(){var e=this.objects.length;if(e>1)for(var t=0;t<e;t++)if(this.objects[t].isOnTop)return this.objects[t];return e>0?this.objects[0]:null},e}),define("render/ScreenCreditController",["../error/ArgumentError","../util/Color","../util/Font","../layer/Layer","../util/Logger","../util/Offset","../shapes/ScreenText"],function(e,t,n,r,i,s,o){"use strict";var a=function(){r.call(this,"ScreenCreditController"),this.creditPlacement=new s(WorldWind.OFFSET_PIXELS,11,WorldWind.OFFSET_PIXELS,2),this.creditMargin=11,this.opacity=.5,this.credits=[]};return a.prototype=Object.create(r.prototype),a.prototype.clear=function(){this.credits=[]},a.prototype.addCredit=function(t,r,a){if(!t)throw new e(i.logMessage(i.LEVEL_SEVERE,"ScreenCreditController","addCredit","missingText"));if(!r)throw new e(i.logMessage(i.LEVEL_SEVERE,"ScreenCreditController","addCredit","missingColor"));for(var l=0,h=this.credits.length;l<h;l++)if(this.credits[l].text===t)return;var u=new o(new s(WorldWind.OFFSET_PIXELS,0,WorldWind.OFFSET_PIXELS,0),t);u.attributes.font=new n(10),u.attributes.color=r,u.attributes.enableOutline=!1,u.attributes.offset=new s(WorldWind.OFFSET_FRACTION,0,WorldWind.OFFSET_FRACTION,0),a&&(u.userProperties.url=a),this.credits.push(u)},a.prototype.doRender=function(e){for(var t=this.creditPlacement.offsetForSize(e.viewport.width,e.viewport.height),n=0,r=this.credits.length;n<r;n++)this.credits[n].screenOffset.x=t[0],this.credits[n].screenOffset.y=t[1],this.credits[n].render(e),e.textRenderer.typeFace=this.credits[n].attributes.font,e.textRenderer.outlineWidth=this.credits[n].attributes.outlineWidth,e.textRenderer.enableOutline=this.credits[n].attributes.enableOutline,t[0]+=e.textRenderer.textSize(this.credits[n].text)[0],t[0]+=this.creditMargin},a}),define("util/HashMap",[],function(){"use strict";var e=function(){this._entries=Object.create(null)};return e.prototype.get=function(e){return this._entries[e]},e.prototype.set=function(e,t){this._entries[e]=t},e.prototype.remove=function(e){delete this._entries[e]},e.prototype.contains=function(e){return e in this._entries},e.reIndex=function(t,n,r){var i=new e;for(var s in t._entries){var o=parseInt(s);o>=n&&(o+=r);var a=t.get(s);a.index=o,i.set(o,a)}return i},e}),define("util/PolygonSplitter",["./HashMap","../geom/Location","../geom/Position","./WWMath"],function(e,t,n,r){"use strict";return{addedIndex:-1,poleIndexOffset:-1,splitContours:function(e,t){for(var n=!1,r=0,i=e.length;r<i;r++){var s=this.splitContour(e[r]);s.polygons.length>1&&(n=!0),t.push(s)}return n},splitContour:function(n){var r=new e,i=[],s=[],o=[],a=[],l=-1,h=this.findIntersectionAndPole(n,i,s,r);return 0===s.length?(o.push(i),a.push(r),this.formatContourOutput(o,h,l,a)):(s.length>2&&s.sort(function(e,t){return t.latitude-e.latitude}),h!==t.poles.NONE&&(i=this.handleOnePole(i,s,r,h),r=this.reindexIntersections(s,r,this.poleIndexOffset)),0===s.length?(o.push(i),a.push(r),l=0,this.formatContourOutput(o,h,l,a)):(this.linkIntersections(s,r),l=this.makePolygons(i,s,r,o,a),this.formatContourOutput(o,h,l,a)))},findIntersectionAndPole:function(e,n,i,s){var o=!1,a=90,l=-90;this.addedIndex=-1;for(var h=0,u=e.length;h<u;h++){var c=e[h],d=e[(h+1)%u];a=Math.min(a,c.latitude),l=Math.max(l,c.latitude);if(t.locationsCrossDateLine([c,d])){o=!o;var f=t.meridianIntersection(c,d,180);null===f&&(f=(c.latitude+d.latitude)/2);var p=180*r.signum(c.longitude)||180,m=this.createPoint(f,p,c.altitude),g=this.createPoint(f,-p,d.altitude);this.safeAdd(n,c,h,u);var b=n.length;s.set(b,this.makeIntersectionEntry(b)),s.set(b+1,this.makeIntersectionEntry(b+1)),i.push({indexEnd:b,indexStart:b+1,latitude:f}),n.push(m),n.push(g),this.safeAdd(n,d,h+1,u)}else this.safeAdd(n,c,h,u),this.safeAdd(n,d,h+1,u)}var y=t.poles.NONE;return o&&(y=this.determinePole(a,l)),y},determinePole:function(e,n){return e>0?t.poles.NORTH:n<0?t.poles.SOUTH:Math.abs(n)>=Math.abs(e)?t.poles.NORTH:t.poles.SOUTH},handleOnePole:function(e,n,r,i){var s;if(i===t.poles.NORTH)var o=n.shift(),a=90;else i===t.poles.SOUTH&&(o=n.pop(),a=-90);var l=r.get(o.indexEnd),h=r.get(o.indexStart);l.forPole=!0,h.forPole=!0,this.poleIndexOffset=o.indexStart,s=e.slice(0,o.indexEnd+1);var u=this.createPoint(a,e[l.index].longitude,e[l.index].altitude),c=this.createPoint(a,e[h.index].longitude,e[h.index].altitude);return s.push(u,c),s=s.concat(e.slice(this.poleIndexOffset))},linkIntersections:function(e,t){for(var n=0;n<e.length-1;n+=2){var r=e[n],i=e[n+1],s=t.get(r.indexEnd),o=t.get(r.indexStart),a=t.get(i.indexEnd),l=t.get(i.indexStart);s.linkTo=i.indexStart,o.linkTo=i.indexEnd,a.linkTo=r.indexStart,l.linkTo=r.indexEnd}},reindexIntersections:function(t,n,r){n=e.reIndex(n,r,2);for(var i=0,s=t.length;i<s;i++)t[i].indexEnd>=r&&(t[i].indexEnd+=2),t[i].indexStart>=r&&(t[i].indexStart+=2);return n},makePolygons:function(t,n,r,i,s){for(var o=-1,a=0;a<n.length-1;a+=2){var l=n[a],h=n[a+1],u=l.indexStart,c=h.indexEnd,d=[],f=new e,p=this.makePolygon(u,c,t,r,d,f);d.length&&(i.push(d),s.push(f),p&&(o=i.length-1)),u=h.indexStart,c=l.indexEnd,d=[],f=new e,p=this.makePolygon(u,c,t,r,d,f),d.length&&(i.push(d),s.push(f),p&&(o=i.length-1))}return o},makePolygon:function(e,t,n,r,i,s){var o=!1,a=n.length,l=!1;t<e&&(t+=a);for(var h=e;h<=t;h++){var u=h%a,c=n[u],d=r.get(u);if(d){if(d.visited)break;if(i.push(c),s.set(i.length-1,d),d.forPole)l=!0;else{if(o&&(h=d.linkTo-1)+1===e)break;o=!o,d.visited=!0}}else i.push(c)}return l},safeAdd:function(e,t,n,r){this.addedIndex<n&&this.addedIndex<r-1&&(e.push(t),this.addedIndex=n)},createPoint:function(e,r,i){return null==i?new t(e,r):new n(e,r,i)},formatContourOutput:function(e,t,n,r){return{polygons:e,pole:t,poleIndex:n,iMap:r}},makeIntersectionEntry:function(e){return null==e&&(e=-1),{visited:!1,forPole:!1,index:e,linkTo:-1}}}}),
define("shapes/ShapeAttributes",["../util/Color","../util/ImageSource"],function(e,t){"use strict";var n=function(t){this._drawInterior=!t||t._drawInterior,this._drawOutline=!t||t._drawOutline,this._enableLighting=!!t&&t._enableLighting,this._interiorColor=t?t._interiorColor.clone():e.WHITE.clone(),this._outlineColor=t?t._outlineColor.clone():e.RED.clone(),this._outlineWidth=t?t._outlineWidth:1,this._outlineStippleFactor=t?t._outlineStippleFactor:0,this._outlineStipplePattern=t?t._outlineStipplePattern:61680,this._imageSource=t?t._imageSource:null,this._depthTest=!t||t._depthTest,this._drawVerticals=!!t&&t._drawVerticals,this._applyLighting=!!t&&t._applyLighting,this.stateKeyInvalid=!0};return n.prototype.computeStateKey=function(){return"di "+this._drawInterior+" do "+this._drawOutline+" el "+this._enableLighting+" ic "+this._interiorColor.toHexString(!0)+" oc "+this._outlineColor.toHexString(!0)+" ow "+this._outlineWidth+" osf "+this._outlineStippleFactor+" osp "+this._outlineStipplePattern+" is "+(this._imageSource?this.imageSource instanceof t?this.imageSource.key:this.imageSource:"null")+" dt "+this._depthTest+" dv "+this._drawVerticals+" li "+this._applyLighting},Object.defineProperties(n.prototype,{stateKey:{get:function(){return this.stateKeyInvalid&&(this._stateKey=this.computeStateKey(),this.stateKeyInvalid=!1),this._stateKey}},drawInterior:{get:function(){return this._drawInterior},set:function(e){this._drawInterior=e,this.stateKeyInvalid=!0}},drawOutline:{get:function(){return this._drawOutline},set:function(e){this._drawOutline=e,this.stateKeyInvalid=!0}},enableLighting:{get:function(){return this._enableLighting},set:function(e){this._enableLighting=e,this.stateKeyInvalid=!0}},interiorColor:{get:function(){return this._interiorColor},set:function(e){this._interiorColor=e,this.stateKeyInvalid=!0}},outlineColor:{get:function(){return this._outlineColor},set:function(e){this._outlineColor=e,this.stateKeyInvalid=!0}},outlineWidth:{get:function(){return this._outlineWidth},set:function(e){this._outlineWidth=e,this.stateKeyInvalid=!0}},outlineStipplePattern:{get:function(){return this._outlineStipplePattern},set:function(e){this._outlineStipplePattern=e,this.stateKeyInvalid=!0}},outlineStippleFactor:{get:function(){return this._outlineStippleFactor},set:function(e){this._outlineStippleFactor=e,this.stateKeyInvalid=!0}},imageSource:{get:function(){return this._imageSource},set:function(e){this._imageSource=e,this.stateKeyInvalid=!0}},depthTest:{get:function(){return this._depthTest},set:function(e){this._depthTest=e,this.stateKeyInvalid=!0}},drawVerticals:{get:function(){return this._drawVerticals},set:function(e){this._drawVerticals=e,this.stateKeyInvalid=!0}},applyLighting:{get:function(){return this._applyLighting},set:function(e){this._applyLighting=e,this.stateKeyInvalid=!0}}}),n}),define("shapes/SurfaceShape",["../error/AbstractError","../geom/Angle","../error/ArgumentError","../geom/BoundingBox","../util/Color","../geom/Location","../util/Logger","../cache/MemoryCache","../error/NotYetImplementedError","../pick/PickedObject","../util/PolygonSplitter","../render/Renderable","../geom/Sector","../shapes/ShapeAttributes","../error/UnsupportedOperationError","../geom/Vec3"],function(e,t,n,r,i,s,o,a,l,h,u,c,d,f,p,m){"use strict";var g=function(e){c.call(this),this._displayName="Surface Shape",this._attributes=e||new f(null),this._highlightAttributes=null,this._highlighted=!1,this._enabled=!0,this._pathType=WorldWind.GREAT_CIRCLE,this._maximumNumEdgeIntervals=g.DEFAULT_NUM_EDGE_INTERVALS,this._polarThrottle=g.DEFAULT_POLAR_THROTTLE,this._boundingSector=null,this.pickDelegate=null,this._boundingSectors=[],this._locations=null,this._boundaries=null,this._interiorGeometry=null,this._outlineGeometry=null,this._isInteriorInhibited=!1,this.stateKeyInvalid=!0,this._attributesStateKey=null,this.boundariesArePrepared=!1,this.layer=null,this.pickColor=null,this.contours=[],this.containsPole=!1,this.crossesAntiMeridian=!1,this.expirationInterval=2e3,this.shapeDataCache=new a(3,2),this.currentData=null};return g.prototype=Object.create(c.prototype),Object.defineProperties(g.prototype,{stateKey:{get:function(){if(this._attributesStateKey){var e=null;this._highlighted?this._highlightAttributes&&(e=this._highlightAttributes.stateKey):this._attributes&&(e=this._attributes.stateKey),e!=this._attributesStateKey&&(this._attributesStateKey=e,this.stateKeyInvalid=!0)}else this._highlighted?this._highlightAttributes&&(this._attributesStateKey=this._highlightAttributes.stateKey):this._attributes&&(this._attributesStateKey=this._attributes.stateKey),this._attributesStateKey&&(this.stateKeyInvalid=!0);return this.stateKeyInvalid&&(this._stateKey=this.computeStateKey()),this._stateKey}},displayName:{get:function(){return this._displayName},set:function(e){this.stateKeyInvalid=!0,this._displayName=e}},attributes:{get:function(){return this._attributes},set:function(e){this.stateKeyInvalid=!0,this._attributes=e,this._attributesStateKey=e.stateKey}},highlightAttributes:{get:function(){return this._highlightAttributes},set:function(e){this.stateKeyInvalid=!0,this._highlightAttributes=e}},highlighted:{get:function(){return this._highlighted},set:function(e){this.stateKeyInvalid=!0,this._highlighted=e}},enabled:{get:function(){return this._enabled},set:function(e){this.stateKeyInvalid=!0,this._enabled=e}},pathType:{get:function(){return this._pathType},set:function(e){this.stateKeyInvalid=!0,this.resetBoundaries(),this._pathType=e}},maximumNumEdgeIntervals:{get:function(){return this._maximumNumEdgeIntervals},set:function(e){this.stateKeyInvalid=!0,this.resetBoundaries(),this._maximumNumEdgeIntervals=e}},polarThrottle:{get:function(){return this._polarThrottle},set:function(e){this.stateKeyInvalid=!0,this.resetBoundaries(),this._polarThrottle=e}},boundingSector:{get:function(){return this._boundingSector}}}),g.staticStateKey=function(e){return e.stateKeyInvalid=!1,e.highlighted&&e._highlightAttributes?e._attributesStateKey=e._highlightAttributes.stateKey:e._attributes?e._attributesStateKey=e._attributes.stateKey:e._attributesStateKey=null,"dn "+e.displayName+" at "+(e._attributesStateKey?e._attributesStateKey:"null")+" hi "+e.highlighted+" en "+e.enabled+" pt "+e.pathType+" ne "+e.maximumNumEdgeIntervals+" po "+e.polarThrottle+" se ["+e.boundingSector.minLatitude+","+e.boundingSector.maxLatitude+","+e.boundingSector.minLongitude+","+e.boundingSector.maxLongitude+"]"},g.prototype.computeStateKey=function(){return g.staticStateKey(this)},g.prototype.area=function(e,t){throw new l(o.logMessage(o.LEVEL_SEVERE,"SurfaceShape","area","notYetImplemented"))},g.prototype.computeBoundaries=function(t){throw new e(o.logMessage(o.LEVEL_SEVERE,"SurfaceShape","computeBoundaries","abstractInvocation"))},g.prototype.intersectsFrustum=function(e){return!this.currentData||!this.currentData.extent||(e.pickingMode?this.currentData.extent.intersectsFrustum(e.pickFrustum):this.currentData.extent.intersectsFrustum(e.frustumInModelCoordinates))},g.prototype.isShapeDataCurrent=function(e,t){return t.verticalExaggeration===e.verticalExaggeration&&t.expiryTime>Date.now()},g.prototype.createShapeDataObject=function(){return{}},g.prototype.resetExpiration=function(e){e.expiryTime=Date.now()+this.expirationInterval+1e3*Math.random()},g.prototype.establishCurrentData=function(e){this.currentData=this.shapeDataCache.entryForKey(e.globeStateKey),this.currentData||(this.currentData=this.createShapeDataObject(),this.resetExpiration(this.currentData),this.shapeDataCache.putEntry(e.globeStateKey,this.currentData,1)),this.currentData.isExpired=!this.isShapeDataCurrent(e,this.currentData)},g.prototype.render=function(e){this.enabled&&(this.layer=e.currentLayer,this.prepareBoundaries(e),this.establishCurrentData(e),!this.currentData.isExpired&&this.currentData.extent||(this.computeExtent(e),this.currentData.verticalExaggeration=e.verticalExaggeration,this.resetExpiration(this.currentData)),this.currentData&&this.currentData.extent&&!this.intersectsFrustum(e)||e.surfaceShapeTileBuilder.insertSurfaceShape(this))},g.prototype.interpolateLocations=function(e){var t,n,r,i=e[0],s=i,o=!0,a=!0,l=0,h=!0;for(this._locations=[i],n=1,r=e.length;n<r;n+=1)t=s,a=o,s=e[n],o=s.latitude==i.latitude&&s.longitude==i.longitude,h=!0,(o||a)&&(l+=1)>2&&(h=!1),h&&this.interpolateEdge(t,s,this._locations),this._locations.push(s),t=s;this._isInteriorInhibited||t.latitude==i.latitude&&t.longitude==i.longitude||(this.interpolateEdge(t,i,this._locations),this._locations.push(i))},g.prototype.interpolateEdge=function(e,t,n){var r,i,o=s.greatCircleDistance(e,t),a=Math.round(this._maximumNumEdgeIntervals*o/Math.PI);if(a>0){r=1/a,i=e;for(var l=this.throttledStep(r,i);l<1;l+=this.throttledStep(r,i))i=new s(0,0),s.interpolateAlongPath(this._pathType,l,e,t,i),180===e.longitude&&180===t.longitude?i.longitude=180:-180===e.longitude&&-180===t.longitude&&(i.longitude=-180),n.push(i)}},g.prototype.throttledStep=function(e,n){var r=Math.cos(n.latitude*t.DEGREES_TO_RADIANS);r*=r;var i=this._polarThrottle/(1+this._polarThrottle);return e*(1-i+i*r)},g.prototype.prepareBoundaries=function(e){if(!this.boundariesArePrepared){this.computeBoundaries(e);var t=this.formatBoundaries();this.normalizeAngles(t),t=this.interpolateBoundaries(t);var n=[],r=u.splitContours(t,n);this.contours=n,this.crossesAntiMeridian=r,this.prepareGeometry(e,n),this.prepareSectors(),this.boundariesArePrepared=!0}},g.prototype.formatBoundaries=function(){var e=[];return this._boundaries.length?(null!=this._boundaries[0].latitude?e.push(this._boundaries):e=this._boundaries,e):e},g.prototype.resetBoundaries=function(){this.boundariesArePrepared=!1,this.shapeDataCache.clear(!1)},g.prototype.normalizeAngles=function(e){for(var n=0,r=e.length;n<r;n++)for(var i=e[n],s=0,o=i.length;s<o;s++){var a=i[s];(a.longitude<-180||a.longitude>180)&&(a.longitude=t.normalizedDegreesLongitude(a.longitude)),(a.latitude<-90||a.latitude>90)&&(a.latitude=t.normalizedDegreesLatitude(a.latitude))}},g.prototype.interpolateBoundaries=function(e){for(var t=[],n=0,r=e.length;n<r;n++){var i=e[n];this.interpolateLocations(i),t.push(this._locations.slice()),this._locations.length=0}return t},g.prototype.computeSectors=function(e){return this._boundingSectors&&this._boundingSectors.length>0?this._boundingSectors:(this.prepareBoundaries(e),this._boundingSectors)},g.prototype.computeExtent=function(e){if(!this._boundingSectors||0===this._boundingSectors.length)return null;if(!this.currentData)return null;this.currentData.extent||(this.currentData.extent=new r);var t;if(1===this._boundingSectors.length)t=this._boundingSectors[0].computeBoundingPoints(e.globe,e.verticalExaggeration),this.currentData.extent.setToVec3Points(t);else{for(var n=[],i=0;i<this._boundingSectors.length;i++){t=this._boundingSectors[i].computeBoundingPoints(e.globe,e.verticalExaggeration);var s=new r;s.setToVec3Points(t);for(var o=s.getCorners(),a=0;a<o.length;a++)n.push(o[a])}this.currentData.extent.setToVec3Points(n)}return this.currentData.extent},g.prototype.computeShiftedLocations=function(e,t,n,r){var i=[],o=new m(0,0,0),a=new WorldWind.Position(0,0,0),l=e.computePointFromLocation(t.latitude,t.longitude,new m(0,0,0)),h=e.computePointFromLocation(n.latitude,n.longitude,new m(0,0,0));if(e.is2D())for(var u=h.subtract(l),c=0,d=r.length;c<d;c++)e.computePointFromLocation(r[c].latitude,r[c].longitude,o),o.add(u),e.computePositionFromPoint(o[0],o[1],o[2],a),i.push(new s(a.latitude,a.longitude));else{for(var f=n.latitude-t.latitude,p=n.longitude-t.longitude,g=-90,b=90,c=0,d=r.length;c<d;c++){var y=r[c].latitude+f,_=r[c].longitude+p;y>90?(y=180-y,_+=180):y<-90&&(y=-180-y,_+=180),_<-180?_+=360:_>180&&(_-=360),y>g&&(g=y),y<b&&(b=y),i.push(new s(y,_))}if(g>90)for(var u=g-90,c=0,d=i.length;c<d;c++)i[c].latitude-=u}return i},g.prototype.prepareSectors=function(){this.determineSectors(),this.crossesAntiMeridian?this.sectorsOverAntiMeridian():this.sectorsNotOverAntiMeridian()},g.prototype.determineSectors=function(){for(var e=0,t=this.contours.length;e<t;e++){var n=this.contours[e],r=n.polygons;n.sectors=[];for(var i=0,o=r.length;i<o;i++){var a=r[i],l=new d(0,0,0,0);if(l.setToBoundingSector(a),this._pathType===WorldWind.GREAT_CIRCLE){var h=s.greatCircleArcExtremeLocations(a),u=Math.min(l.minLatitude,h[0].latitude),c=Math.max(l.maxLatitude,h[1].latitude);l.minLatitude=u,l.maxLatitude=c}n.sectors.push(l)}}},g.prototype.sectorsOverAntiMeridian=function(){for(var e=new d(90,-90,180,-180),t=new d(90,-90,180,-180),n=0,r=this.contours.length;n<r;n++)for(var i=this.contours[n].sectors,s=0,o=i.length;s<o;s++){var a=i[s];a.minLongitude<0&&a.maxLongitude>0?(t.union(a),e.union(a)):a.minLongitude<0?t.union(a):e.union(a)}var l=Math.min(e.minLatitude,t.minLatitude),h=Math.max(e.maxLatitude,e.maxLatitude);this._boundingSector=new d(l,h,-180,180),this._boundingSectors=[e,t]},g.prototype.sectorsNotOverAntiMeridian=function(){this._boundingSector=new d(90,-90,180,-180);for(var e=0,t=this.contours.length;e<t;e++)for(var n=this.contours[e].sectors,r=0,i=n.length;r<i;r++)this._boundingSector.union(n[r]);this._boundingSectors=[this._boundingSector]},g.prototype.prepareGeometry=function(e,t){for(var n=[],r=[],i=0,o=t.length;i<o;i++)for(var a=t[i],l=a.poleIndex,h=0,u=a.polygons.length;h<u;h++){var c=a.polygons[h],d=a.iMap[h];n.push(c),a.pole!==s.poles.NONE&&u>1?h===l?this.outlineForPole(c,d,r):this.outlineForSplit(c,d,r):a.pole!==s.poles.NONE&&1===u?this.outlineForPole(c,d,r):a.pole===s.poles.NONE&&u>1?this.outlineForSplit(c,d,r):a.pole===s.poles.NONE&&1===u&&r.push(c)}this._interiorGeometry=n,this._outlineGeometry=r},g.prototype.outlineForPole=function(e,t,n){this.containsPole=!0;for(var r=[],i=0,s=0,o=e.length;s<o;s++){var a=e[s],l=t.get(s);l&&l.forPole&&++i%2==1&&(r.push(a),n.push(r),r=[]),i%2==0&&r.push(a)}r.length&&n.push(r)},g.prototype.outlineForSplit=function(e,t,n){for(var r=[],i=0,s=0,o=e.length;s<o;s++){var a=e[s],l=t.get(s);l&&!l.forPole&&++i%2==0&&(r.push(a),n.push(r),r=[]),i%2==1&&r.push(a)}},g.prototype.resetPickColor=function(){this.pickColor=null},g.prototype.renderToTexture=function(e,t,n,r,s,o){var a=this._highlighted?this._highlightAttributes||this._attributes:this._attributes;if(a){var l=!this._isInteriorInhibited&&a.drawInterior,u=a.drawOutline&&a.outlineWidth>0;if(l||u){if(e.pickingMode)this.pickColor||(this.pickColor=e.uniquePickColor()),t.fillStyle=this.pickColor.toCssColorString(),t.strokeStyle=t.fillStyle,t.lineWidth=a.outlineWidth;else{var c=a.interiorColor,d=a.outlineColor;t.fillStyle=new i(c.red,c.green,c.blue,c.alpha*this.layer.opacity).toCssColorString(),t.strokeStyle=new i(d.red,d.green,d.blue,d.alpha*this.layer.opacity).toCssColorString(),t.lineWidth=a.outlineWidth}if(this.crossesAntiMeridian||this.containsPole?(l&&(this.draw(this._interiorGeometry,t,n,r,s,o),t.fill()),u&&(this.draw(this._outlineGeometry,t,n,r,s,o),t.stroke())):(this.draw(this._interiorGeometry,t,n,r,s,o),l&&t.fill(),u&&t.stroke()),e.pickingMode){var f=new h(this.pickColor.clone(),this.pickDelegate?this.pickDelegate:this,null,this.layer,!1);e.resolvePick(f)}}}},g.prototype.draw=function(e,t,n,r,i,s){t.beginPath();for(var o=0,a=e.length;o<a;o++){var l=e[o],h=l[0],u=h.longitude*n+i,c=h.latitude*r+s;t.moveTo(u,c);for(var d=1,f=l.length;d<f;d++)h=l[d],u=h.longitude*n+i,c=h.latitude*r+s,t.lineTo(u,c)}},g.DEFAULT_NUM_EDGE_INTERVALS=128,g.DEFAULT_POLAR_THROTTLE=10,g}),define("shapes/SurfaceShapeTile",["../geom/Angle","../error/ArgumentError","../util/Level","../util/Logger","../geom/Sector","../render/Texture","../render/TextureTile"],function(e,t,n,r,i,s,o){"use strict";var a=function(e,t,n,r){o.call(this,e,t,n,r),this.surfaceShapes=[],this.surfaceShapeStateKeys=[],this.asRenderedSurfaceShapeStateKeys=[],this.sector=e,this.cacheKey=null,this.pickSequence=0,this.createCtx2D()};return a.prototype=Object.create(o.prototype),a.prototype.clearShapes=function(){this.surfaceShapes=[],this.surfaceShapeStateKeys=[]},a.prototype.hasShapes=function(){return this.surfaceShapes.length>0},a.prototype.getShapes=function(){return this.surfaceShapes},a.prototype.setShapes=function(e){this.surfaceShapes=e},a.prototype.getSector=function(){return this.sector},a.prototype.addSurfaceShape=function(e){this.surfaceShapes.push(e),this.surfaceShapeStateKeys.push(e.stateKey+" lo "+e.layer.opacity)},a.prototype.needsUpdate=function(e){var t,n;if(this.surfaceShapes.length!=this.asRenderedSurfaceShapeStateKeys.length)return!0;for(t=0,n=this.surfaceShapes.length;t<n;t+=1)if(this.surfaceShapeStateKeys[t]!==this.asRenderedSurfaceShapeStateKeys[t])return!0;return!this.hasTexture(e)},a.prototype.hasTexture=function(e){return!e.pickingMode&&(this.gpuCacheKey||(this.gpuCacheKey=this.getCacheKey()),e.gpuResourceCache.containsResource(this.gpuCacheKey))},a.prototype.updateTexture=function(e){var t=e.currentGlContext,n=a.canvas,r=a.ctx2D;n.width=this.tileWidth,n.height=this.tileHeight;var i=this.tileWidth/this.sector.deltaLongitude(),o=-this.tileHeight/this.sector.deltaLatitude(),l=-this.sector.minLongitude*i,h=-this.sector.maxLatitude*o;this.asRenderedSurfaceShapeStateKeys=[];for(var u=0,c=this.surfaceShapes.length;u<c;u+=1){var d=this.surfaceShapes[u];this.asRenderedSurfaceShapeStateKeys.push(this.surfaceShapeStateKeys[u]),d.renderToTexture(e,r,i,o,l,h)}if(e.pickingMode){for(var f=r.getImageData(0,0,n.width,n.height),p=3,m=n.width*n.height*4;p<m;p+=4)f.data[p]<255&&(f.data[p-3]=0,f.data[p-2]=0,f.data[p-1]=0,f.data[p]=0);r.putImageData(f,0,0)}this.gpuCacheKey=this.getCacheKey();var g=e.gpuResourceCache,b=new s(t,n);return g.putResource(this.gpuCacheKey,b,b.size),g.setResourceAgingFactor(this.gpuCacheKey,10),b},a.prototype.getCacheKey=function(){return this.cacheKey||(this.cacheKey="SurfaceShapeTile:"+this.tileKey+","+this.pickSequence.toString()),this.cacheKey},a.prototype.createCtx2D=function(){a.ctx2D||(a.canvas=document.createElement("canvas"),a.ctx2D=a.canvas.getContext("2d"))},a.canvas=null,a.ctx2D=null,a}),define("shapes/SurfaceShapeTileBuilder",["../error/ArgumentError","../render/DrawContext","../globe/Globe","../shaders/GpuProgram","../util/Level","../util/LevelSet","../geom/Location","../util/Logger","../geom/Matrix","../cache/MemoryCache","../error/NotYetImplementedError","../pick/PickedObject","../geom/Rectangle","../geom/Sector","../shapes/SurfaceShape","../shapes/SurfaceShapeTile","../globe/Terrain","../globe/TerrainTile","../globe/TerrainTileList","../render/TextureTile","../util/Tile"],function(e,t,n,r,i,s,o,a,l,h,u,c,d,f,p,m,g,b,y,_,E){"use strict";var v=function(){this.numRowsTilesInTopLevel=4,this.numColumnsTilesInTopLevel=8,this.maximumSubdivisionDepth=15,this.tileWidth=256,this.tileHeight=256,this.levels=new s(f.FULL_SPHERE,new o(180/this.numRowsTilesInTopLevel,360/this.numColumnsTilesInTopLevel),this.maximumSubdivisionDepth,this.tileWidth,this.tileHeight),this.surfaceShapes=[],this.surfaceShapeTiles=[],this.topLevelTiles=[],this.sector=new f(-90,90,-180,180),this.detailControl=1.25,this.tileCache=new h(5e5,4e5)};return v.prototype.clear=function(){this.surfaceShapeTiles.splice(0,this.surfaceShapeTiles.length),this.surfaceShapes.splice(0,this.surfaceShapes.length)},v.prototype.insertSurfaceShape=function(e){this.surfaceShapes.push(e)},v.prototype.doRender=function(e){if(e.pickingMode){for(var t=0,n=this.surfaceShapes.length;t<n;t+=1)this.surfaceShapes[t].resetPickColor();v.pickSequence+=1;var r=this.surfaceShapeTiles,i=this.topLevelTiles;this.surfaceShapeTiles=[],this.topLevelTiles=[],this.buildTiles(e),e.deepPicking?this.doDeepPickingRender(e):e.surfaceTileRenderer.renderTiles(e,this.surfaceShapeTiles,1),this.surfaceShapeTiles=r,this.topLevelTiles=i}else this.buildTiles(e),e.surfaceTileRenderer.renderTiles(e,this.surfaceShapeTiles,1)},v.prototype.doDeepPickingRender=function(e){var t,n,r,i,s,o,a,l,h,u=[];for(s=0,o=e.objectsAtPickPoint.objects.length;s<o;s+=1)a=e.objectsAtPickPoint.objects[s],a.userObject instanceof p&&(l=a.userObject,u.indexOf(l)<0&&(u.push(l),e.objectsAtPickPoint.objects.splice(s,1),s-=1,o-=1));if(!(u.length<=0)){var d=[];for(r=0,i=u.length;r<i;r+=1){for(l=u[r],t=0,n=this.surfaceShapeTiles.length;t<n;t+=1)h=this.surfaceShapeTiles[t],h.setShapes([l]),h.updateTexture(e);e.surfaceTileRenderer.renderTiles(e,this.surfaceShapeTiles,1);var f=e.readPickColor(e.pickPoint);f&&l.pickColor.equals(f)&&(a=new c(l.pickColor.clone(),l.pickDelegate?l.pickDelegate:l,null,l.layer,!1),d.push(a))}for(s=0,o=e.objectsAtPickPoint.objects.length;s<o;s+=1)a=e.objectsAtPickPoint.objects[s],a.userObject instanceof p&&(e.objectsAtPickPoint.objects.splice(s,1),s-=1,o-=1);for(s=0,o=d.length;s<o;s+=1)a=d[s],e.objectsAtPickPoint.objects.push(a)}},v.prototype.buildTiles=function(t){if(!t)throw new e(a.logMessage(a.LEVEL_SEVERE,"SurfaceShapeTileBuilder","buildTiles","missingDc"));if(this.surfaceShapes&&!(this.surfaceShapes.length<1)){this.assembleTiles(t),this.surfaceShapes.splice(0,this.surfaceShapes.length);for(var n=0,r=this.surfaceShapeTiles.length;n<r;n+=1){this.surfaceShapeTiles[n].clearShapes()}}},v.prototype.assembleTiles=function(e){var t,n,r,i,s,o,a;this.topLevelTiles.length<1&&this.createTopLevelTiles();var l={};for(n=0,r=this.surfaceShapes.length;n<r;n+=1){var h=this.surfaceShapes[n],u=h.computeSectors(e);if(u)for(o=0,a=u.length;o<a;o+=1){var c=u[o];for(i=0,s=this.topLevelTiles.length;i<s;i+=1)if(t=this.topLevelTiles[i],t.sector.intersects(c)){var d=t.tileKey;l[d]=t,t.addSurfaceShape(h)}}}for(var f in l)l.hasOwnProperty(f)&&(t=l[f],this.addTileOrDescendants(e,this.levels,null,t))},v.prototype.addTileOrDescendants=function(e,t,n,r){if(!this.intersectsFrustum(e,r))return void r.clearShapes();if(null!=n&&this.addIntersectingShapes(e,n,r),r.hasShapes()){if(this.meetsRenderCriteria(e,t,r))return void this.addTile(e,r);for(var i=t.level(r.level.levelNumber+1),s=e.pickingMode?r.subdivide(i,this):r.subdivideToCache(i,this,this.tileCache),o=0,a=s.length;o<a;o+=1){var l=s[o];this.addTileOrDescendants(e,t,r,l)}r.clearShapes()}},v.prototype.addIntersectingShapes=function(e,t,n){for(var r=t.getShapes(),i=0,s=r.length;i<s;i+=1){var o=r[i],a=o.computeSectors(e);if(a)for(var l=0,h=a.length;l<h;l+=1){var u=a[l];if(n.getSector().intersects(u)){n.addSurfaceShape(o);break}}}},v.prototype.addTile=function(e,t){e.pickingMode&&(t.pickSequence=v.pickSequence),t.needsUpdate(e)&&t.updateTexture(e),this.surfaceShapeTiles.push(t)},v.prototype.createTile=function(e,t,n,r){return new m(e,t,n,r)},v.prototype.createTopLevelTiles=function(){E.createTilesForLevel(this.levels.firstLevel(),this,this.topLevelTiles)},v.prototype.intersectsFrustum=function(e,t){return!(e.globe.projectionLimits&&!t.sector.overlaps(e.globe.projectionLimits))&&(t.update(e),t.extent.intersectsFrustum(e.pickingMode?e.pickFrustum:e.frustumInModelCoordinates))},v.prototype.meetsRenderCriteria=function(e,t,n){return n.level.levelNumber==t.lastLevel().levelNumber||!n.mustSubdivide(e,this.detailControl)},v.pickSequence=0,v}),define("shaders/SurfaceTileRendererProgram",["../error/ArgumentError","../util/Color","../shaders/GpuProgram","../util/Logger"],function(e,t,n,r){"use strict";var i=function(e){n.call(this,e,"attribute vec4 vertexPoint;\nattribute vec4 vertexTexCoord;\nuniform mat4 mvpMatrix;\nuniform mat4 texSamplerMatrix;\nuniform mat4 texMaskMatrix;\nvarying vec2 texSamplerCoord;\nvarying vec2 texMaskCoord;\nvoid main() {\ngl_Position = mvpMatrix * vertexPoint;\ntexSamplerCoord = (texSamplerMatrix * vertexTexCoord).st;\ntexMaskCoord = (texMaskMatrix * vertexTexCoord).st;\n}","precision mediump float;\nuniform sampler2D texSampler;\nuniform float opacity;\nuniform vec4 color;\nuniform bool modulateColor;\nvarying vec2 texSamplerCoord;\nvarying vec2 texMaskCoord;\nbool isInsideTextureImage(const vec2 coord) {\n    return coord.x >= 0.0 && coord.x <= 1.0 && coord.y >= 0.0 && coord.y <= 1.0;\n}\nvoid main(void) {\nfloat mask = float(isInsideTextureImage(texMaskCoord));if (modulateColor) {\n    gl_FragColor = color * mask * floor(texture2D(texSampler, texSamplerCoord).a + 0.5);\n} else {\n    gl_FragColor = texture2D(texSampler, texSamplerCoord) * mask * opacity;\n}\n}"),this.vertexPointLocation=this.attributeLocation(e,"vertexPoint"),this.vertexTexCoordLocation=this.attributeLocation(e,"vertexTexCoord"),this.mvpMatrixLocation=this.uniformLocation(e,"mvpMatrix"),this.colorLocation=this.uniformLocation(e,"color"),this.modulateColorLocation=this.uniformLocation(e,"modulateColor"),this.texSamplerMatrixLocation=this.uniformLocation(e,"texSamplerMatrix"),this.texMaskMatrixLocation=this.uniformLocation(e,"texMaskMatrix"),this.texSamplerLocation=this.uniformLocation(e,"texSampler"),this.opacityLocation=this.uniformLocation(e,"opacity"),this.vertexPointLocation=-1};return i.key="WorldWindGpuSurfaceTileRenderingProgram",i.prototype=Object.create(n.prototype),i.prototype.loadModelviewProjection=function(t,n){if(!n)throw new e(r.logMessage(r.LEVEL_SEVERE,"SurfaceTileRendererProgram","loadModelviewProjection","missingMatrix"));this.loadUniformMatrix(t,n,this.mvpMatrixLocation)},i.prototype.loadTexSamplerMatrix=function(t,n){if(!n)throw new e(r.logMessage(r.LEVEL_SEVERE,"SurfaceTileRendererProgram","loadTexSamplerMatrix","missingMatrix"));this.loadUniformMatrix(t,n,this.texSamplerMatrixLocation)},i.prototype.loadTexMaskMatrix=function(t,n){if(!n)throw new e(r.logMessage(r.LEVEL_SEVERE,"SurfaceTileRendererProgram","loadTexMaskMatrix","missingMatrix"));this.loadUniformMatrix(t,n,this.texMaskMatrixLocation)},i.prototype.loadTexSampler=function(e,t){e.uniform1i(this.texSamplerLocation,t-WebGLRenderingContext.TEXTURE0)},i.prototype.loadOpacity=function(e,t){e.uniform1f(this.opacityLocation,t)},i.prototype.loadColor=function(t,n){if(!n)throw new e(r.logMessage(r.LEVEL_SEVERE,"SurfaceTileRendererProgram","loadColor","missingColor"));this.loadUniformColor(t,n,this.colorLocation)},i.prototype.loadModulateColor=function(e,t){e.uniform1i(this.modulateColorLocation,t?1:0)},i}),define("render/SurfaceTileRenderer",["../error/ArgumentError","../util/Logger","../geom/Matrix","../shapes/SurfaceShapeTile","../shaders/SurfaceTileRendererProgram"],function(e,t,n,r,i){"use strict";var s=function(){this.texMaskMatrix=n.fromIdentity(),this.texSamplerMatrix=n.fromIdentity(),this.isSurfaceShapeTileRendering=!1};return s.prototype.renderTiles=function(n,i,s,o){if(!i)throw new e(t.logMessage(t.LEVEL_SEVERE,"SurfaceTileRenderer","renderTiles","Specified surface tiles array is null or undefined."));if(!(i.length<1)){var a,l,h,u,c=n.terrain,d=n.currentGlContext,f=0,p=1;if(c){this.isSurfaceShapeTileRendering=i[0]instanceof r,s*=n.surfaceOpacity,a=this.beginRendering(n,s),c.beginRendering(n);try{for(var m=0,g=c.surfaceGeometry.length;m<g;m++){l=c.surfaceGeometry[m],h=l.sector,c.beginRenderingTile(n,l);try{for(var b=0,y=i.length;b<y;b++)u=i[b],u.sector.overlaps(h)&&u.bind(n)&&(n.pickingMode?u.pickColor&&a.loadColor(d,u.pickColor):o&&u.opacity!=p&&(a.loadOpacity(d,s*u.opacity),p=u.opacity),this.applyTileState(n,l,u),c.renderTile(n,l),++f)}catch(e){console.log(e)}finally{c.endRenderingTile(n,l)}}}catch(e){console.log(e)}finally{c.endRendering(n),this.endRendering(n),n.frameStatistics.incrementRenderedTileCount(f)}}}},s.prototype.beginRendering=function(e,t){var n=e.currentGlContext,r=e.findAndBindProgram(i);return r.loadTexSampler(n,n.TEXTURE0),e.pickingMode&&!this.isSurfaceShapeTileRendering?r.loadModulateColor(n,!0):(r.loadModulateColor(n,!1),r.loadOpacity(n,t)),r},s.prototype.endRendering=function(e){var t=e.currentGlContext;t.bindTexture(t.TEXTURE_2D,null)},s.prototype.applyTileState=function(e,t,n){var r=e.currentGlContext,i=e.currentProgram,s=t.sector,o=s.deltaLatitude(),a=s.deltaLongitude(),l=n.sector,h=l.deltaLatitude(),u=l.deltaLongitude(),c=h>0?h:1,d=u>0?u:1,f=a/d,p=o/c,m=-(l.minLongitude-s.minLongitude)/d,g=-(l.minLatitude-s.minLatitude)/c;this.texMaskMatrix.set(f,0,0,m,0,p,0,g,0,0,1,0,0,0,0,1),this.texSamplerMatrix.setToUnitYFlip(),n.applyInternalTransform(e,this.texSamplerMatrix),this.texSamplerMatrix.multiplyMatrix(this.texMaskMatrix),i.loadTexSamplerMatrix(r,this.texSamplerMatrix),i.loadTexMaskMatrix(r,this.texMaskMatrix)},s}),define("render/TextRenderer",["../error/ArgumentError","../shaders/BasicTextureProgram","../util/Color","../util/Font","../util/Logger","../geom/Matrix","../render/Texture","../geom/Vec2"],function(e,t,n,r,i,s,o,a){"use strict";var l=function(t){if(!t)throw new e(i.logMessage(i.LEVEL_SEVERE,"TextRenderer","constructor","missingDc"));this.canvas2D=document.createElement("canvas"),this.ctx2D=this.canvas2D.getContext("2d"),this.dc=t,this.enableOutline=!0,this.lineSpacing=.15,this.outlineColor=new n(0,0,0,.5),this.outlineWidth=4,this.textColor=new n(1,1,1,1),this.typeFace=new r(14)};return l.prototype.textSize=function(e){if(0===e.length)return new a(0,0);this.ctx2D.font=this.typeFace.fontString;for(var t=e.split("\n"),n=t.length*(this.typeFace.size*(1+this.lineSpacing)),r=0,i=0;i<t.length;i++)r=Math.max(r,this.ctx2D.measureText(t[i]).width);return this.enableOutline&&(r+=this.outlineWidth,n+=this.outlineWidth),new a(r,n)},l.prototype.renderText=function(e){if(e&&e.length>0){var t=this.drawText(e);return new o(this.dc.currentGlContext,t)}return null},l.prototype.drawText=function(e){var t=this.ctx2D,n=this.canvas2D,r=this.textSize(e),i=e.split("\n"),s=this.enableOutline?this.outlineWidth/2:0,o=this.dc.pixelScale;n.width=Math.ceil(r[0])*o,n.height=Math.ceil(r[1])*o,t.scale(o,o),t.font=this.typeFace.fontString,t.textBaseline="bottom",t.textAlign=this.typeFace.horizontalAlignment,t.fillStyle=this.textColor.toCssColorString(),t.strokeStyle=this.outlineColor.toCssColorString(),t.lineWidth=this.outlineWidth,t.lineCap="round",t.lineJoin="round","left"===this.typeFace.horizontalAlignment?t.translate(s,0):"right"===this.typeFace.horizontalAlignment?t.translate(r[0]-s,0):t.translate(r[0]/2,0);for(var a=0;a<i.length;a++)t.translate(0,this.typeFace.size*(1+this.lineSpacing)+s),this.enableOutline&&t.strokeText(i[a],0,0),t.fillText(i[a],0,0);return n},l.prototype.getMaxLineHeight=function(){return this.textSize("_É")[1]},l.prototype.wrap=function(t,n,r){if(!t)throw new e(i.logMessage(i.WARNING,"TextRenderer","wrap","missing text"));var s,o=t.split("\n"),a="";for(s=0;s<o.length;s++)o[s]=this.wrapLine(o[s],n);var l=0,h=!1,u=this.getMaxLineHeight();for(s=0;s<o.length&&!h;s++){for(var c=o[s].split("\n"),d=0;d<c.length&&!h;d++)r<=0||l+u<=r?(a+=c[d],l+=u+this.lineSpacing,d<c.length-1&&(a+="\n")):h=!0;s<o.length-1&&!h&&(a+="\n")}return h&&(a.length>0&&(a=a.substring(0,a.length-1)),a+="..."),a},l.prototype.wrapLine=function(e,t){var n="",r=e.trim();if(this.textSize(r)[0]>t){for(var i="",s=0,o=r.indexOf(" ",s+1);s<r.length;){-1===o&&(o=r.length);var a=r.substring(s,o),l=i+a;this.textSize(l)[0]<=t?i+=a:0!==i.length?(n+=i,n+="\n",i="",i+=a.trim()):i+=a.trim(),(s=o)<r.length-1&&(o=r.indexOf(" ",s+1))}n+=i}else n+=r;return n},l}),define("render/DrawContext",["../error/ArgumentError","../util/Color","../util/FrameStatistics","../render/FramebufferTexture","../render/FramebufferTileController","../geom/Frustum","../globe/Globe","../shaders/GpuProgram","../cache/GpuResourceCache","../layer/Layer","../geom/Line","../util/Logger","../geom/Matrix","../pick/PickedObjectList","../geom/Plane","../geom/Position","../geom/Rectangle","../render/ScreenCreditController","../geom/Sector","../shapes/SurfaceShape","../shapes/SurfaceShapeTileBuilder","../render/SurfaceTileRenderer","../render/TextRenderer","../geom/Vec2","../geom/Vec3","../util/WWMath"],function(e,t,n,r,i,s,o,a,l,h,u,c,d,f,p,m,g,b,y,_,E,v,w,S,T,L){"use strict";var x=function(n){if(!n)throw new e(c.logMessage(c.LEVEL_SEVERE,"Texture","constructor","missingGlContext"));this.currentGlContext=n,this.canvas2D=document.createElement("canvas"),this.ctx2D=this.canvas2D.getContext("2d"),this.clearColor=t.TRANSPARENT,this.gpuResourceCache=new l(WorldWind.configuration.gpuCacheSize,.8*WorldWind.configuration.gpuCacheSize),this.surfaceTileRenderer=new v,this.surfaceShapeTileBuilder=new E,
this.surfaceShapeTileController=new i,this.screenCreditController=new b,this.textRenderer=new w(this),this.currentFramebuffer=null,this.currentProgram=null,this.surfaceRenderables=[],this.orderedRenderingMode=!1,this.orderedRenderables=[],this.orderedRenderablesCounter=0,this.timestamp=Date.now(),this.previousRedrawTimestamp=this.timestamp,this.redrawRequested=!1,this.globe=null,this.globeStateKey=null,this.layers=null,this.currentLayer=null,this.eyePosition=new m(0,0,0),this.eyePoint=new T(0,0,0),this.screenProjection=d.fromIdentity(),this.terrain=null,this.verticalExaggeration=1,this.fadeTime=500,this.surfaceOpacity=1,this.frameStatistics=null,this.pickingMode=!1,this.pickTerrainOnly=!1,this.deepPicking=!1,this.regionPicking=!1,this.pickPoint=null,this.pickRay=null,this.pickRectangle=null,this.pickFramebuffer=null,this.pickFrustum=null,this.pickColor=new t(0,0,0,1),this.objectsAtPickPoint=new f,this.pixelScale=1,this.navigator=null,this.camera=null,this.modelview=d.fromIdentity(),this.projection=d.fromIdentity(),this.modelviewProjection=d.fromIdentity(),this.frustumInModelCoordinates=null,this.modelviewNormalTransform=d.fromIdentity(),this.viewport=new g(0,0,0,0),this.pixelSizeFactor=0,this.glExtensionsCache={}};return x.unitCubeKey="DrawContextUnitCubeKey",x.unitCubeElementsKey="DrawContextUnitCubeElementsKey",x.unitQuadKey="DrawContextUnitQuadKey",x.unitQuadKey3="DrawContextUnitQuadKey3",x.prototype.reset=function(){this.screenCreditController.clear(),this.surfaceRenderables=[],this.orderedRenderingMode=!1,this.orderedRenderables=[],this.screenRenderables=[],this.orderedRenderablesCounter=0;var e=this.timestamp;this.timestamp=Date.now(),this.timestamp===e&&++this.timestamp,this.redrawRequested=!1,this.globe=null,this.globeStateKey=null,this.layers=null,this.currentLayer=null,this.terrain=null,this.verticalExaggeration=1,this.frameStatistics=null,this.accumulateOrderedRenderables=!0,this.pixelSizeFactor=0,this.pickingMode=!1,this.pickTerrainOnly=!1,this.deepPicking=!1,this.regionPicking=!1,this.pickPoint=null,this.pickRay=null,this.pickRectangle=null,this.pickFrustum=null,this.pickColor=new t(0,0,0,1),this.objectsAtPickPoint.clear(),this.eyePoint.set(0,0,0),this.modelview.setToIdentity(),this.projection.setToIdentity(),this.modelviewProjection.setToIdentity(),this.frustumInModelCoordinates=null,this.modelviewNormalTransform.setToIdentity()},x.prototype.update=function(){var e=this.currentGlContext,t=this.eyePoint;this.globeStateKey=this.globe.stateKey,this.globe.computePositionFromPoint(t[0],t[1],t[2],this.eyePosition),this.screenProjection.setToScreenProjection(e.drawingBufferWidth,e.drawingBufferHeight)},x.prototype.contextLost=function(){this.gpuResourceCache.clear(),this.pickFramebuffer=null,this.currentFramebuffer=null,this.currentProgram=null,this.glExtensionsCache={}},x.prototype.contextRestored=function(){this.gpuResourceCache.clear(),this.glExtensionsCache={}},x.prototype.bindFramebuffer=function(e){this.currentFramebuffer!=e&&(this.currentGlContext.bindFramebuffer(this.currentGlContext.FRAMEBUFFER,e?e.framebufferId:null),this.currentFramebuffer=e)},x.prototype.bindProgram=function(e){this.currentProgram!=e&&(this.currentGlContext.useProgram(e?e.programId:null),this.currentProgram=e)},x.prototype.findAndBindProgram=function(t){if(!t)throw new e(c.logMessage(c.LEVEL_SEVERE,"DrawContext","findAndBindProgram","The specified program constructor is null or undefined."));var n=this.gpuResourceCache.resourceForKey(t.key);if(n)this.bindProgram(n);else try{n=new t(this.currentGlContext),this.bindProgram(n),this.gpuResourceCache.putResource(t.key,n,n.size)}catch(e){c.log(c.LEVEL_SEVERE,"Error attempting to create GPU program.")}return n},x.prototype.addSurfaceRenderable=function(e){e&&this.surfaceRenderables.push(e)},x.prototype.peekSurfaceRenderable=function(){return this.surfaceRenderables.length>0?this.surfaceRenderables[this.surfaceRenderables.length-1]:null},x.prototype.popSurfaceRenderable=function(){return this.surfaceRenderables.length>0?this.surfaceRenderables.pop():null},x.prototype.reverseSurfaceRenderables=function(){this.surfaceRenderables.reverse()},x.prototype.addOrderedRenderable=function(e,t){if(e){var n={orderedRenderable:e,insertionOrder:this.orderedRenderablesCounter++,eyeDistance:t||e.eyeDistance,globeStateKey:this.globeStateKey};this.globe.continuous&&(n.globeOffset=this.globe.offset),0===n.eyeDistance?this.screenRenderables.push(n):this.orderedRenderables.push(n)}},x.prototype.addOrderedRenderableToBack=function(e){if(e){var t={orderedRenderable:e,insertionOrder:this.orderedRenderablesCounter++,eyeDistance:Number.MAX_VALUE,globeStateKey:this.globeStateKey};this.globe.continuous&&(t.globeOffset=this.globe.offset),this.orderedRenderables.push(t)}},x.prototype.peekOrderedRenderable=function(){return this.orderedRenderables.length>0?this.orderedRenderables[this.orderedRenderables.length-1].orderedRenderable:null},x.prototype.popOrderedRenderable=function(){if(this.orderedRenderables.length>0){var e=this.orderedRenderables.pop();return this.globeStateKey=e.globeStateKey,this.globe.continuous&&(this.globe.offset=e.globeOffset),e.orderedRenderable}return null},x.prototype.nextScreenRenderable=function(){if(this.screenRenderables.length>0){var e=this.screenRenderables.shift();return this.globeStateKey=e.globeStateKey,this.globe.continuous&&(this.globe.offset=e.globeOffset),e.orderedRenderable}return null},x.prototype.sortOrderedRenderables=function(){this.orderedRenderables.sort(function(e,t){var n=e.eyeDistance,r=t.eyeDistance;if(n<r)return-1;if(n>r)return 1;var i=e.insertionOrder,s=t.insertionOrder;return i>s?-1:i<s?1:0})},x.prototype.readPickColor=function(e){var n=this.convertPointToViewport(e,new S(0,0)),r=new Uint8Array(4);return this.currentGlContext.readPixels(n[0],n[1],1,1,this.currentGlContext.RGBA,this.currentGlContext.UNSIGNED_BYTE,r),this.clearColor.equalsBytes(r)?null:t.colorFromByteArray(r)},x.prototype.readPickColors=function(e){var n,r=this.currentGlContext,i=new Uint8Array(e.width*e.height*4),s={},o=new t(0,0,0,0),a=r.getParameter(r.PACK_ALIGNMENT);r.pixelStorei(r.PACK_ALIGNMENT,1),this.currentGlContext.readPixels(e.x,e.y,e.width,e.height,r.RGBA,r.UNSIGNED_BYTE,i),r.pixelStorei(r.PACK_ALIGNMENT,a);for(var l=0,h=e.width*e.height;l<h;l++){var u=4*l;n=t.colorFromBytes(i[u],i[u+1],i[u+2],i[u+3]),n.equals(this.clearColor)||n.equals(o)||(s[n.toByteString()]=n)}return s},x.prototype.resolvePick=function(e){if(e.userObject instanceof _||!this.deepPicking||this.regionPicking)this.addPickedObject(e);else{var t=this.readPickColor(this.pickPoint);if(!t)return null;e.color.equals(t)&&this.addPickedObject(e)}},x.prototype.addPickedObject=function(e){e&&this.objectsAtPickPoint.add(e)},x.prototype.uniquePickColor=function(){var e=this.pickColor.nextColor().clone();return e.equals(this.clearColor)?e.nextColor():e},x.prototype.makePickFramebuffer=function(){var e=this.currentGlContext,t=e.drawingBufferWidth,n=e.drawingBufferHeight;return this.pickFramebuffer&&this.pickFramebuffer.width==t&&this.pickFramebuffer.height==n||(this.pickFramebuffer=new r(e,t,n,!0)),this.pickFramebuffer},x.prototype.makePickFrustum=function(){if(!this.pickPoint&&!this.pickRectangle)return!1;var e,t,n,r,i,o,a,l,h,u,c,f,m,b,y,_,E,v,w,x,R,A,C=new T(0,0,0),M=new T(0,0,0),k=this.pickRectangle,I=this.viewport;k||(A=this.convertPointToViewport(this.pickPoint,new S(0,0)),k=new g(A[0]-2,A[1]-2,4,4));var O=k.x,P=k.x+k.width,N=k.y,D=k.y+k.height;if(P<0||D<0||O>I.x+I.width||N>I.y+I.height)return!1;k.x=L.clamp(O,I.x,I.x+I.width),k.y=L.clamp(N,I.y,I.y+I.height),k.width=L.clamp(P,I.x,I.x+I.width)-k.x,k.height=L.clamp(D,I.y,I.y+I.height)-k.y,this.pickRectangle=k;var F=d.fromIdentity();return F.invertMatrix(this.modelviewProjection),M[0]=k.x,M[1]=k.y,M[2]=0,F.unProject(M,I,e=new T(0,0,0)),M[0]=k.x,M[1]=k.y,M[2]=1,F.unProject(M,I,t=new T(0,0,0)),M[0]=k.x+k.width,M[1]=k.y,M[2]=0,F.unProject(M,I,n=new T(0,0,0)),M[0]=k.x+k.width,M[1]=k.y,M[2]=1,F.unProject(M,I,r=new T(0,0,0)),M[0]=k.x,M[1]=k.y+k.height,M[2]=0,F.unProject(M,I,i=new T(0,0,0)),M[0]=k.x,M[1]=k.y+k.height,M[2]=1,F.unProject(M,I,o=new T(0,0,0)),M[0]=k.x+k.width,M[1]=k.y+k.height,M[2]=0,F.unProject(M,I,a=new T(0,0,0)),M[0]=k.x+k.width,M[1]=k.y+k.height,M[2]=1,F.unProject(M,I,l=new T(0,0,0)),R=new T(o[0]-e[0],o[1]-e[1],o[2]-e[2]),C.set(i[0]-t[0],i[1]-t[1],i[2]-t[2]),h=R.cross(C),y=new p(h[0],h[1],h[2],-h.dot(e)),y.normalize(),R=new T(a[0]-r[0],a[1]-r[1],a[2]-r[2]),C.set(l[0]-n[0],l[1]-n[1],l[2]-n[2]),u=R.cross(C),_=new p(u[0],u[1],u[2],-u.dot(n)),_.normalize(),R=new T(o[0]-a[0],o[1]-a[1],o[2]-a[2]),C.set(l[0]-i[0],l[1]-i[1],l[2]-i[2]),c=R.cross(C),E=new p(c[0],c[1],c[2],-c.dot(i)),E.normalize(),R=new T(r[0]-e[0],r[1]-e[1],r[2]-e[2]),C.set(t[0]-n[0],t[1]-n[1],t[2]-n[2]),f=R.cross(C),v=new p(f[0],f[1],f[2],-f.dot(n)),v.normalize(),R=new T(i[0]-n[0],i[1]-n[1],i[2]-n[2]),C.set(a[0]-e[0],a[1]-e[1],a[2]-e[2]),m=R.cross(C),w=new p(m[0],m[1],m[2],-m.dot(e)),w.normalize(),R=new T(l[0]-t[0],l[1]-t[1],l[2]-t[2]),C.set(o[0]-r[0],o[1]-r[1],o[2]-r[2]),b=R.cross(C),x=new p(b[0],b[1],b[2],-b.dot(t)),x.normalize(),this.pickFrustum=new s(y,_,v,E,w,x),!0},x.prototype.isSmall=function(e,t){if(!e)return!1;var n=this.eyePoint.distanceTo(e.center),r=this.pixelSizeAtDistance(n);return 2*e.radius<t*r},x.prototype.unitCubeBuffer=function(){var e=this.gpuResourceCache.resourceForKey(x.unitCubeKey);if(!e){var t=this.currentGlContext,n=new Float32Array(24),r=0;n[r++]=0,n[r++]=1,n[r++]=0,n[r++]=0,n[r++]=0,n[r++]=0,n[r++]=1,n[r++]=1,n[r++]=0,n[r++]=1,n[r++]=0,n[r++]=0,n[r++]=0,n[r++]=1,n[r++]=1,n[r++]=0,n[r++]=0,n[r++]=1,n[r++]=1,n[r++]=1,n[r++]=1,n[r++]=1,n[r++]=0,n[r]=1,e=t.createBuffer(),t.bindBuffer(t.ARRAY_BUFFER,e),t.bufferData(t.ARRAY_BUFFER,n,t.STATIC_DRAW),t.bindBuffer(t.ARRAY_BUFFER,null),this.frameStatistics.incrementVboLoadCount(1),this.gpuResourceCache.putResource(x.unitCubeKey,e,4*n.length)}return e},x.prototype.unitCubeElements=function(){var e=this.gpuResourceCache.resourceForKey(x.unitCubeElementsKey);if(!e){var t=this.currentGlContext,n=new Int16Array(60),r=0;n[r++]=1,n[r++]=0,n[r++]=3,n[r++]=3,n[r++]=0,n[r++]=2,n[r++]=4,n[r++]=5,n[r++]=6,n[r++]=6,n[r++]=5,n[r++]=7,n[r++]=5,n[r++]=1,n[r++]=7,n[r++]=7,n[r++]=1,n[r++]=3,n[r++]=6,n[r++]=2,n[r++]=4,n[r++]=4,n[r++]=2,n[r++]=0,n[r++]=4,n[r++]=0,n[r++]=5,n[r++]=5,n[r++]=0,n[r++]=1,n[r++]=7,n[r++]=3,n[r++]=6,n[r++]=6,n[r++]=3,n[r++]=2,n[r++]=0,n[r++]=1,n[r++]=1,n[r++]=3,n[r++]=3,n[r++]=2,n[r++]=2,n[r++]=0,n[r++]=4,n[r++]=5,n[r++]=5,n[r++]=7,n[r++]=7,n[r++]=6,n[r++]=6,n[r++]=4,n[r++]=0,n[r++]=4,n[r++]=5,n[r++]=1,n[r++]=2,n[r++]=6,n[r++]=7,n[r]=3,e=t.createBuffer(),t.bindBuffer(t.ELEMENT_ARRAY_BUFFER,e),t.bufferData(t.ELEMENT_ARRAY_BUFFER,n,t.STATIC_DRAW),t.bindBuffer(t.ELEMENT_ARRAY_BUFFER,null),this.frameStatistics.incrementVboLoadCount(1),this.gpuResourceCache.putResource(x.unitCubeElementsKey,e,2*n.length)}return e},x.prototype.unitQuadBuffer=function(){var e=this.gpuResourceCache.resourceForKey(x.unitQuadKey);if(!e){var t=this.currentGlContext,n=new Float32Array(8);n[0]=0,n[1]=1,n[2]=0,n[3]=0,n[4]=1,n[5]=1,n[6]=1,n[7]=0,e=t.createBuffer(),t.bindBuffer(t.ARRAY_BUFFER,e),t.bufferData(t.ARRAY_BUFFER,n,t.STATIC_DRAW),t.bindBuffer(t.ARRAY_BUFFER,null),this.frameStatistics.incrementVboLoadCount(1),this.gpuResourceCache.putResource(x.unitQuadKey,e,4*n.length)}return e},x.prototype.unitQuadBuffer3=function(){var e=this.gpuResourceCache.resourceForKey(x.unitQuadKey3);if(!e){var t=this.currentGlContext,n=new Float32Array(12);n[0]=0,n[1]=1,n[2]=0,n[3]=0,n[4]=0,n[5]=0,n[6]=1,n[7]=1,n[8]=0,n[9]=1,n[10]=0,n[11]=0,e=t.createBuffer(),t.bindBuffer(t.ARRAY_BUFFER,e),t.bufferData(t.ARRAY_BUFFER,n,t.STATIC_DRAW),t.bindBuffer(t.ARRAY_BUFFER,null),this.frameStatistics.incrementVboLoadCount(1),this.gpuResourceCache.putResource(x.unitQuadKey3,e,4*n.length)}return e},x.prototype.surfacePointForMode=function(t,n,r,i,s){if(!s)throw new e(c.logMessage(c.LEVEL_SEVERE,"DrawContext","surfacePointForMode","missingResult"));if(this.terrain)this.terrain.surfacePointForMode(t,n,r,i,s);else{var o=r+this.globe.elevationAtLocation(t,n)*this.verticalExaggeration;this.globe.computePointFromPosition(t,n,o,s)}return s},x.prototype.project=function(t,n){if(!t)throw new e(c.logMessage(c.LEVEL_SEVERE,"DrawContext","project","missingPoint"));if(!n)throw new e(c.logMessage(c.LEVEL_SEVERE,"DrawContext","project","missingResult"));var r=t[0],i=t[1],s=t[2],o=this.modelviewProjection,a=o[0]*r+o[1]*i+o[2]*s+o[3],l=o[4]*r+o[5]*i+o[6]*s+o[7],h=o[8]*r+o[9]*i+o[10]*s+o[11],u=o[12]*r+o[13]*i+o[14]*s+o[15];return 0!==u&&(a/=u,l/=u,!((h/=u)<-1||h>1)&&(a=.5*a+.5,l=.5*l+.5,h=.5*h+.5,a=a*this.viewport.width+this.viewport.x,l=l*this.viewport.height+this.viewport.y,n[0]=a,n[1]=l,n[2]=h,!0))},x.prototype.projectWithDepth=function(t,n,r){if(!t)throw new e(c.logMessage(c.LEVEL_SEVERE,"DrawContext","projectWithDepth","missingPoint"));if(!r)throw new e(c.logMessage(c.LEVEL_SEVERE,"DrawContext","projectWithDepth","missingResult"));var i=t[0],s=t[1],o=t[2],a=this.modelview,l=a[0]*i+a[1]*s+a[2]*o+a[3],h=a[4]*i+a[5]*s+a[6]*o+a[7],u=a[8]*i+a[9]*s+a[10]*o+a[11],d=a[12]*i+a[13]*s+a[14]*o+a[15],f=this.projection,p=f[0]*l+f[1]*h+f[2]*u+f[3]*d,m=f[4]*l+f[5]*h+f[6]*u+f[7]*d,g=f[8]*l+f[9]*h+f[10]*u+f[11]*d,b=f[12]*l+f[13]*h+f[14]*u+f[15]*d;return 0!==b&&(p/=b,m/=b,!((g/=b)<-1||g>1)&&(g=f[8]*l+f[9]*h+f[10]*u*(1+n)+f[11]*d,g/=b,g=L.clamp(g,-1,1),p=.5*p+.5,m=.5*m+.5,g=.5*g+.5,p=p*this.viewport.width+this.viewport.x,m=m*this.viewport.height+this.viewport.y,r[0]=p,r[1]=m,r[2]=g,!0))},x.prototype.convertPointToViewport=function(t,n){if(!t)throw new e(c.logMessage(c.LEVEL_SEVERE,"DrawContext","convertPointToViewport","missingPoint"));if(!n)throw new e(c.logMessage(c.LEVEL_SEVERE,"DrawContext","convertPointToViewport","missingResult"));return n[0]=t[0],n[1]=this.viewport.height-t[1],n},x.prototype.pixelSizeAtDistance=function(e){if(0===this.pixelSizeFactor){var t=this.camera.fieldOfView,n=Math.tan(.5*t/180*Math.PI);this.pixelSizeFactor=2*n/this.viewport.height}return e*this.pixelSizeFactor},x.prototype.createTextTexture=function(e,t){if(!e||!t)return null;var n=this.computeTextTextureStateKey(e,t),r=this.gpuResourceCache.resourceForKey(n);return r||(this.textRenderer.textColor=t.color,this.textRenderer.typeFace=t.font,this.textRenderer.enableOutline=t.enableOutline,this.textRenderer.outlineColor=t.outlineColor,this.textRenderer.outlineWidth=t.outlineWidth,r=this.textRenderer.renderText(e),this.gpuResourceCache.putResource(n,r,r.size),this.gpuResourceCache.setResourceAgingFactor(n,100)),r},x.prototype.computeTextTextureStateKey=function(e,t){return e&&t?e+"c "+t.color.toHexString(!0)+" f "+t.font.toString()+" eo "+t.enableOutline+" ow "+t.outlineWidth+" oc "+t.outlineColor.toHexString(!0):null},x.prototype.getExtension=function(t){if(!t)throw new e(c.logMessage(c.LEVEL_SEVERE,"DrawContext","getExtension","missingExtensionName"));return t in this.glExtensionsCache||(this.glExtensionsCache[t]=this.currentGlContext.getExtension(t)||null),this.glExtensionsCache[t]},x}),define("globe/GebcoElevationCoverage",["../geom/Location","../geom/Sector","../globe/TiledElevationCoverage","../util/WmsUrlBuilder"],function(e,t,n,r){"use strict";var i=function(){n.call(this,{coverageSector:t.FULL_SPHERE,resolution:.008333333333333,retrievalImageFormat:"application/bil16",minElevation:-11e3,maxElevation:8850,urlBuilder:new r("https://worldwind26.arc.nasa.gov/elev","GEBCO","","1.3.0")}),this.displayName="GEBCO Earth Elevation Coverage"};return i.prototype=Object.create(n.prototype),i}),define("globe/UsgsNedElevationCoverage",["../geom/Location","../geom/Sector","../globe/TiledElevationCoverage","../util/WmsUrlBuilder"],function(e,t,n,r){"use strict";var i=function(){n.call(this,{coverageSector:new t(24.396308,49.384358,-124.848974,-66.885444),resolution:92592592593e-15,retrievalImageFormat:"application/bil16",minElevation:-11e3,maxElevation:8850,urlBuilder:new r("https://worldwind26.arc.nasa.gov/elev","USGS-NED","","1.3.0")}),this.displayName="USGS NED Earth Elevation Coverage"};return i.prototype=Object.create(n.prototype),i}),define("globe/UsgsNedHiElevationCoverage",["../geom/Location","../geom/Sector","../globe/TiledElevationCoverage","../util/WmsUrlBuilder"],function(e,t,n,r){"use strict";var i=function(){n.call(this,{coverageSector:new t(18.86546,28.517269,-178.443593,-154.755792),resolution:92592592593e-15,retrievalImageFormat:"application/bil16",minElevation:-11e3,maxElevation:8850,urlBuilder:new r("https://worldwind26.arc.nasa.gov/elev","USGS-NED","","1.3.0")}),this.displayName="USGS NED Hawaii Elevation Coverage"};return i.prototype=Object.create(n.prototype),i}),define("globe/EarthElevationModel",["../globe/AsterV2ElevationCoverage","../globe/ElevationModel","../globe/GebcoElevationCoverage","../globe/UsgsNedElevationCoverage","../globe/UsgsNedHiElevationCoverage"],function(e,t,n,r,i){"use strict";var s=function(){t.call(this),this.addCoverage(new n),this.addCoverage(new e),this.addCoverage(new r),this.addCoverage(new i)};return s.prototype=Object.create(t.prototype),s}),define("globe/EarthRestElevationCoverage",["../util/LevelSet","../geom/Location","../geom/Sector","../util/LevelRowColumnUrlBuilder","../globe/TiledElevationCoverage"],function(e,t,n,r,i){"use strict";var s=function(s,o,a){i.call(this,{coverageSector:n.FULL_SPHERE,resolution:.00732421875,retrievalImageFormat:"application/bil16",minElevation:-11e3,maxElevation:8850,urlBuilder:new r(s,o)}),this.displayName=a||"Earth Elevations",this.levels=new e(n.FULL_SPHERE,new t(60,60),5,512,512)};return s.prototype=Object.create(i.prototype),s}),define("layer/FrameStatisticsLayer",["../error/ArgumentError","../util/Color","../util/Font","../layer/Layer","../util/Logger","../util/Offset","../shapes/ScreenText","../shapes/TextAttributes"],function(e,t,n,r,i,s,o,a){"use strict";var l=function(l){function h(e,t){c.handleRedraw(e,t)}if(!l)throw new e(i.logMessage(i.LEVEL_SEVERE,"FrameStatisticsLayer","constructor","missingWorldWindow"));r.call(this,"Frame Statistics"),this.pickEnabled=!1;var u=new a(null);u.color=t.GREEN,u.font=new n(12),u.offset=new s(WorldWind.OFFSET_FRACTION,0,WorldWind.OFFSET_FRACTION,1),this.frameTime=new o(new s(WorldWind.OFFSET_PIXELS,5,WorldWind.OFFSET_INSET_PIXELS,5)," "),this.frameTime.attributes=u,this.frameRate=new o(new s(WorldWind.OFFSET_PIXELS,5,WorldWind.OFFSET_INSET_PIXELS,25)," "),this.frameRate.attributes=u;var c=this;l.redrawCallbacks.push(h)};return l.prototype=Object.create(r.prototype),l.prototype.doRender=function(e){this.frameRate.render(e),this.frameTime.render(e),this.inCurrentFrame=!0},l.prototype.handleRedraw=function(e,t){if(t===WorldWind.BEFORE_REDRAW){var n=e.frameStatistics;this.frameTime.text="Frame time  "+n.frameTimeAverage.toFixed(0)+" ms  ("+n.frameTimeMin.toFixed(0)+" - "+n.frameTimeMax.toFixed(0)+")",this.frameRate.text="Frame rate  "+n.frameRateAverage.toFixed(0)+" fps"}},l}),define("shapes/AbstractShape",["../error/ArgumentError","../util/Logger","../geom/Matrix","../cache/MemoryCache","../render/Renderable","../shapes/ShapeAttributes","../error/UnsupportedOperationError","../geom/Vec3"],function(e,t,n,r,i,s,o,a){"use strict";var l=function(e){i.call(this),this._attributes=e||new s(null),this._highlightAttributes=null,this.highlighted=!1,this._altitudeMode=WorldWind.ABSOLUTE,this.referencePosition=null,this.shapeDataCache=new r(3,2),this.currentData=null,this.activeAttributes=null,this.expirationInterval=2e3,this.useSurfaceShapeFor2D=!1,this.scratchMatrix=n.fromIdentity()};return l.prototype=Object.create(i.prototype),Object.defineProperties(l.prototype,{attributes:{get:function(){return this._attributes},set:function(e){this._attributes=e,this.surfaceShape&&(this.surfaceShape.attributes=this._attributes)}},highlightAttributes:{get:function(){return this._highlightAttributes},set:function(e){this._highlightAttributes=e,this.surfaceShape&&(this.surfaceShape.highlightAttributes=this._highlightAttributes)}},altitudeMode:{get:function(){return this._altitudeMode},set:function(n){if(!n)throw new e(t.logMessage(t.LEVEL_SEVERE,"AbstractShape","altitudeMode","missingAltitudeMode"));this._altitudeMode=n,this.reset()}}}),l.prototype.reset=function(){this.shapeDataCache.clear(!1),this.surfaceShape=null},l.prototype.updateSurfaceShape=function(){this.surfaceShape.displayName=this.displayName,this.surfaceShape.highlighted=this.highlighted,this.surfaceShape.enabled=this.enabled,this.surfaceShape.pathType=this.pathType,this.surfaceShape.pickDelegate=this.pickDelegate?this.pickDelegate:this},l.prototype.createSurfaceShape=function(){return null},l.prototype.render=function(e){if(this.enabled&&e.accumulateOrderedRenderables){if(e.globe.is2D()&&this.useSurfaceShapeFor2D&&(this.surfaceShape||(this.surfaceShape=this.createSurfaceShape(),this.surfaceShape&&(this.surfaceShape.attributes=this._attributes,this.surfaceShape.highlightAttributes=this._highlightAttributes)),this.surfaceShape))return this.updateSurfaceShape(),void this.surfaceShape.render(e);if((e.terrain||this.altitudeMode==WorldWind.ABSOLUTE)&&(this.establishCurrentData(e),(!e.globe.projectionLimits||this.isWithinProjectionLimits(e))&&(!this.currentData.extent||this.intersectsFrustum(e))&&(this.determineActiveAttributes(e),this.activeAttributes))){var t=this.makeOrderedRenderable(e);if(t){if(!this.intersectsFrustum(e))return;if(e.isSmall(this.currentData.extent,1))return;t.layer=e.currentLayer,e.addOrderedRenderable(t,this.currentData.eyeDistance)}}}},l.prototype.renderOrdered=function(e){this.currentData=this.shapeDataCache.entryForKey(e.globeStateKey),this.beginDrawing(e);try{this.doRenderOrdered(e)}finally{this.endDrawing(e)}},l.prototype.makeOrderedRenderable=function(e){var t=this.doMakeOrderedRenderable(e);return this.currentData.verticalExaggeration=e.verticalExaggeration,t},l.prototype.doMakeOrderedRenderable=function(e){throw new o(t.logMessage(t.LEVEL_SEVERE,"AbstractShape","makeOrderedRenderable","abstractInvocation"))},l.prototype.doRenderOrdered=function(e){throw new o(t.logMessage(t.LEVEL_SEVERE,"AbstractShape","doRenderOrdered","abstractInvocation"))},l.prototype.beginDrawing=function(e){},l.prototype.endDrawing=function(e){},l.prototype.intersectsFrustum=function(e){return!this.currentData||!this.currentData.extent||(e.pickingMode?this.currentData.extent.intersectsFrustum(e.pickFrustum):this.currentData.extent.intersectsFrustum(e.frustumInModelCoordinates))},l.prototype.establishCurrentData=function(e){this.currentData=this.shapeDataCache.entryForKey(e.globeStateKey),this.currentData||(this.currentData=this.createShapeDataObject(),this.resetExpiration(this.currentData),this.shapeDataCache.putEntry(e.globeStateKey,this.currentData,1)),this.currentData.isExpired=!this.isShapeDataCurrent(e,this.currentData)},l.prototype.createShapeDataObject=function(){return{transformationMatrix:n.fromIdentity(),referencePoint:new a(0,0,0)}},l.prototype.resetExpiration=function(e){e.expiryTime=Date.now()+this.expirationInterval+1e3*Math.random()},l.prototype.isShapeDataCurrent=function(e,t){return t.verticalExaggeration===e.verticalExaggeration&&t.expiryTime>Date.now()},l.prototype.determineActiveAttributes=function(e){this.highlighted&&this._highlightAttributes?this.activeAttributes=this.highlightAttributes:this.activeAttributes=this._attributes},l.prototype.isWithinProjectionLimits=function(e){return!0},l.prototype.applyMvpMatrix=function(e){this.scratchMatrix.copy(e.modelviewProjection),this.scratchMatrix.multiplyMatrix(this.currentData.transformationMatrix),e.currentProgram.loadModelviewProjection(e.currentGlContext,this.scratchMatrix)},l.prototype.applyMvpMatrixForOutline=function(e){this.scratchMatrix.copy(e.projection),this.scratchMatrix.offsetProjectionDepth(-.001),this.scratchMatrix.multiplyMatrix(e.modelview),this.scratchMatrix.multiplyMatrix(this.currentData.transformationMatrix),e.currentProgram.loadModelviewProjection(e.currentGlContext,this.scratchMatrix)},l}),define("shapes/AbstractMesh",["../shapes/AbstractShape","../error/ArgumentError","../shaders/BasicTextureProgram","../geom/BoundingBox","../util/Color","../util/ImageSource","../geom/Line","../geom/Location","../util/Logger","../geom/Matrix","../pick/PickedObject","../geom/Position","../shapes/ShapeAttributes","../geom/Vec2","../geom/Vec3","../util/WWMath"],function(e,t,n,r,i,s,o,a,l,h,u,c,d,f,p,m){"use strict";var g=function(t){e.call(this,t),this.pickTransparentImagePixels=!0,this._altitudeScale=1};return g.prototype=Object.create(e.prototype),Object.defineProperties(g.prototype,{altitudeScale:{get:function(){return this._altitudeScale},set:function(e){this._altitudeScale=e,this.reset()}}}),g.prototype.mustGenerateGeometry=function(e){return!this.currentData.meshPoints||(this.currentData.drawInterior!==this.activeAttributes.drawInterior||(!(!this.activeAttributes.applyLighting||this.currentData.normals)||this.altitudeMode!==WorldWind.ABSOLUTE&&this.currentData.isExpired))},g.prototype.doMakeOrderedRenderable=function(e){if(!this.activeAttributes.drawInterior&&!this.activeAttributes.drawOutline)return null;if(!this.mustGenerateGeometry(e))return this;var t=this.currentData,n=t.referencePoint;return e.surfacePointForMode(this.referencePosition.latitude,this.referencePosition.longitude,this.referencePosition.altitude*this._altitudeScale,this._altitudeMode,n),t.transformationMatrix.setToTranslation(n[0],n[1],n[2]),t.meshPoints=this.computeMeshPoints(e,t),t.refreshVertexBuffer=!0,this.activeAttributes.imageSource&&!this.texCoords&&(this.texCoords=this.computeTexCoords(),this.texCoords&&(t.refreshTexCoordBuffer=!0)),this.meshIndices||(this.meshIndices=this.computeMeshIndices(),t.refreshMeshIndices=!0),this.meshOutlineIndices||(this.meshOutlineIndices=this.computeOutlineIndices(),this.meshOutlineIndices&&(t.refreshOutlineIndices=!0)),this.activeAttributes.applyLighting&&this.computeNormals(t),t.drawInterior=this.activeAttributes.drawInterior,this.resetExpiration(t),t.extent||(t.extent=new r),t.extent.setToPoints(t.meshPoints),t.extent.translate(t.referencePoint),this},g.prototype.computeMeshPoints=function(e,t){throw new UnsupportedOperationError(l.logMessage(l.LEVEL_SEVERE,"AbstractMesh","computeMeshPoints","abstractInvocation"))},g.prototype.computeTexCoords=function(){return null},g.prototype.computeMeshIndices=function(e){throw new UnsupportedOperationError(l.logMessage(l.LEVEL_SEVERE,"AbstractMesh","computeMeshIndices","abstractInvocation"))},g.prototype.computeOutlineIndices=function(e){},g.prototype.computeNormals=function(e){for(var t,n=new Float32Array(e.meshPoints.length),r=this.meshIndices,i=e.meshPoints,s=[],o=[new p(0,0,0),new p(0,0,0),new p(0,0,0)],a=0;a<r.length;a+=3){for(var l=0;l<3;l++)t=r[a+l],o[l].set(i[3*t],i[3*t+1],i[3*t+2]);var h=p.computeTriangleNormal(o[0],o[1],o[2]);for(l=0;l<3;l++)t=r[a+l],s[t]||(s[t]=[]),s[t].push(h)}for(h=new p(0,0,0),a=0;a<s.length;a++)s[a]?(p.average(s[a],h),h.normalize(),n[3*a]=h[0],n[3*a+1]=h[1],n[3*a+2]=h[2]):(n[3*a]=0,n[3*a+1]=0,n[3*a+2]=0);e.normals=n,e.refreshNormalsBuffer=!0},g.prototype.doRenderOrdered=function(e){var t,n,r,i=e.currentGlContext,s=e.currentProgram,o=this.currentData,a=this.texCoords&&!!this.activeAttributes.imageSource;if(e.pickingMode&&(r=e.uniquePickColor()),o.pointsVboCacheKey||(o.pointsVboCacheKey=e.gpuResourceCache.generateCacheKey()),t=e.gpuResourceCache.resourceForKey(o.pointsVboCacheKey),t||(t=i.createBuffer(),e.gpuResourceCache.putResource(o.pointsVboCacheKey,t,4*o.meshPoints.length),o.refreshVertexBuffer=!0),i.bindBuffer(i.ARRAY_BUFFER,t),o.refreshVertexBuffer&&(i.bufferData(i.ARRAY_BUFFER,o.meshPoints,i.STATIC_DRAW),e.frameStatistics.incrementVboLoadCount(1),o.refreshVertexBuffer=!1),i.vertexAttribPointer(s.vertexPointLocation,3,i.FLOAT,!1,0,0),s.loadTextureEnabled(i,!1),this.activeAttributes.drawInterior){var l=!e.pickingMode&&o.normals&&this.activeAttributes.applyLighting;this.applyMvpMatrix(e),o.meshIndicesVboCacheKey||(o.meshIndicesVboCacheKey=e.gpuResourceCache.generateCacheKey()),t=e.gpuResourceCache.resourceForKey(o.meshIndicesVboCacheKey),t||(t=i.createBuffer(),e.gpuResourceCache.putResource(o.meshIndicesVboCacheKey,t,2*this.meshIndices.length),o.refreshMeshIndices=!0),i.bindBuffer(i.ELEMENT_ARRAY_BUFFER,t),o.refreshMeshIndices&&(i.bufferData(i.ELEMENT_ARRAY_BUFFER,this.meshIndices,i.STATIC_DRAW),e.frameStatistics.incrementVboLoadCount(1),o.refreshMeshIndices=!1),n=this.activeAttributes.interiorColor,i.depthMask(n.alpha*this.layer.opacity>=1||e.pickingMode),s.loadColor(i,e.pickingMode?r:n),s.loadOpacity(i,e.pickingMode?1:this.layer.opacity),!a||e.pickingMode&&this.pickTransparentImagePixels||(this.activeTexture=e.gpuResourceCache.resourceForKey(this.activeAttributes.imageSource),this.activeTexture||(this.activeTexture=e.gpuResourceCache.retrieveTexture(e.currentGlContext,this.activeAttributes.imageSource)),this.activeTexture&&this.activeTexture.bind(e)&&(o.texCoordsVboCacheKey||(o.texCoordsVboCacheKey=e.gpuResourceCache.generateCacheKey()),t=e.gpuResourceCache.resourceForKey(o.texCoordsVboCacheKey),t||(t=i.createBuffer(),e.gpuResourceCache.putResource(o.texCoordsVboCacheKey,t,4*this.texCoords.length),o.refreshTexCoordBuffer=!0),i.bindBuffer(i.ARRAY_BUFFER,t),o.refreshTexCoordBuffer&&(i.bufferData(i.ARRAY_BUFFER,this.texCoords,i.STATIC_DRAW),e.frameStatistics.incrementVboLoadCount(1),o.refreshTexCoordBuffer=!1),i.enableVertexAttribArray(s.vertexTexCoordLocation),i.vertexAttribPointer(s.vertexTexCoordLocation,2,i.FLOAT,!1,0,0),this.scratchMatrix.setToIdentity(),this.scratchMatrix.multiplyByTextureTransform(this.activeTexture),s.loadTextureEnabled(i,!0),s.loadTextureUnit(i,i.TEXTURE0),s.loadTextureMatrix(i,this.scratchMatrix),s.loadModulateColor(i,e.pickingMode))),l&&(s.loadApplyLighting(i,!0),o.normalsVboCacheKey||(o.normalsVboCacheKey=e.gpuResourceCache.generateCacheKey()),t=e.gpuResourceCache.resourceForKey(o.normalsVboCacheKey),t||(t=i.createBuffer(),e.gpuResourceCache.putResource(o.normalsVboCacheKey,t,4*o.normals.length),o.refreshNormalsBuffer=!0),i.bindBuffer(i.ARRAY_BUFFER,t),o.refreshNormalsBuffer&&(i.bufferData(i.ARRAY_BUFFER,o.normals,i.STATIC_DRAW),e.frameStatistics.incrementVboLoadCount(1),o.refreshNormalsBuffer=!1),i.enableVertexAttribArray(s.normalVectorLocation),i.vertexAttribPointer(s.normalVectorLocation,3,i.FLOAT,!1,0,0)),i.drawElements(i.TRIANGLES,this.meshIndices.length,i.UNSIGNED_SHORT,0),a&&i.disableVertexAttribArray(s.vertexTexCoordLocation),l&&(s.loadApplyLighting(i,!1),i.disableVertexAttribArray(s.normalVectorLocation))}if(this.activeAttributes.drawOutline&&this.meshOutlineIndices&&(s.loadTextureEnabled(i,!1),i.disableVertexAttribArray(s.vertexTexCoordLocation),this.applyMvpMatrixForOutline(e),n=this.activeAttributes.outlineColor,i.depthMask(n.alpha*this.layer.opacity>=1||e.pickingMode),s.loadColor(i,e.pickingMode?r:n),s.loadOpacity(i,e.pickingMode?1:this.layer.opacity),i.lineWidth(this.activeAttributes.outlineWidth),o.outlineIndicesVboCacheKey||(o.outlineIndicesVboCacheKey=e.gpuResourceCache.generateCacheKey()),t=e.gpuResourceCache.resourceForKey(o.outlineIndicesVboCacheKey),t||(t=i.createBuffer(),e.gpuResourceCache.putResource(o.outlineIndicesVboCacheKey,t,2*this.meshOutlineIndices.length),o.refreshOutlineIndices=!0),i.bindBuffer(i.ELEMENT_ARRAY_BUFFER,t),o.refreshOutlineIndices&&(i.bufferData(i.ELEMENT_ARRAY_BUFFER,this.meshOutlineIndices,i.STATIC_DRAW),e.frameStatistics.incrementVboLoadCount(1),o.refreshOutlineIndices=!1),i.drawElements(i.LINE_STRIP,this.meshOutlineIndices.length,i.UNSIGNED_SHORT,0)),e.pickingMode){var h=this.computePickPosition(e),c=new u(r,this.pickDelegate?this.pickDelegate:this,h,this.layer,!1);e.resolvePick(c)}},g.prototype.computePickPosition=function(e){var t=this.currentData,n=e.pickRay,r=new p(n.origin[0],n.origin[1],n.origin[2]).subtract(t.referencePoint),i=new o(r,n.direction),s=[];if(m.computeIndexedTrianglesIntersection(i,t.meshPoints,this.meshIndices,s)){var a=s[0];if(s.length>1)for(var l=a.distanceToSquared(e.eyePoint),h=1;h<s.length;h++){
var u=s[h].distanceToSquared(e.eyePoint);u<l&&(l=u,a=s[h])}var d=new c(0,0,0);return e.globe.computePositionFromPoint(a[0]+t.referencePoint[0],a[1]+t.referencePoint[1],a[2]+t.referencePoint[2],d),d.altitude/=this._altitudeScale,d}return null},g.prototype.beginDrawing=function(e){var t=e.currentGlContext;if(this.activeAttributes.drawInterior){t.disable(t.CULL_FACE),e.findAndBindProgram(n);!e.pickMode&&this.currentData.normals&&this.activeAttributes.applyLighting&&e.currentProgram.loadModelviewInverse(t,e.modelviewNormalTransform)}t.enableVertexAttribArray(e.currentProgram.vertexPointLocation)},g.prototype.endDrawing=function(e){var t=e.currentGlContext;t.disableVertexAttribArray(e.currentProgram.vertexPointLocation),t.depthMask(!0),t.lineWidth(1),t.enable(t.CULL_FACE)},g}),define("shapes/SurfacePolygon",["../error/ArgumentError","../util/Logger","../shapes/ShapeAttributes","../shapes/SurfaceShape"],function(e,t,n,r){"use strict";var i=function(n,s){if(!Array.isArray(n))throw new e(t.logMessage(t.LEVEL_SEVERE,"SurfacePolygon","constructor","The specified boundary is not an array."));r.call(this,s),this._boundaries=n,this._stateId=i.stateId++};return i.prototype=Object.create(r.prototype),Object.defineProperties(i.prototype,{boundaries:{get:function(){return this._boundaries},set:function(n){if(!Array.isArray(n))throw new e(t.logMessage(t.LEVEL_SEVERE,"SurfacePolygon","set boundaries","The specified value is not an array."));this.resetBoundaries(),this._boundaries=n,this._stateId=i.stateId++,this.stateKeyInvalid=!0}}}),i.stateId=Number.MIN_SAFE_INTEGER,i.staticStateKey=function(e){return r.staticStateKey(e)+" pg "+e._stateId},i.prototype.computeStateKey=function(){return i.staticStateKey(this)},i.prototype.computeBoundaries=function(e){},i.prototype.getReferencePosition=function(){return this.boundaries.length>0&&this.boundaries[0].length>2?this.boundaries[0][0]:this.boundaries.length>2?this.boundaries[0]:null},i.prototype.moveTo=function(e,t){if(this.boundaries.length>0&&this.boundaries[0].length>2){for(var n=[],r=0,i=this._boundaries.length;r<i;r++){var s=this.computeShiftedLocations(e,this.getReferencePosition(),t,this._boundaries[r]);n.push(s)}this.boundaries=n}else this.boundaries.length>2&&(this.boundaries=this.computeShiftedLocations(e,this.getReferencePosition(),t,this._boundaries))},i}),define("shapes/GeographicMesh",["../shapes/AbstractMesh","../error/ArgumentError","../shaders/BasicTextureProgram","../geom/BoundingBox","../util/Color","../util/ImageSource","../geom/Location","../util/Logger","../geom/Matrix","../pick/PickedObject","../geom/Position","../shapes/ShapeAttributes","../shapes/SurfacePolygon","../geom/Vec2","../geom/Vec3"],function(e,t,n,r,i,s,o,a,l,h,u,c,d,f,p){"use strict";var m=function(n,r){if(!n)throw new t(a.logMessage(a.LEVEL_SEVERE,"GeographicMesh","constructor","missingPositions"));if(n.length<2||n[0].length<2)throw new t(a.logMessage(a.LEVEL_SEVERE,"GeographicMesh","constructor","Number of positions is insufficient."));if(n.length*n[0].length>65536)throw new t(a.logMessage(a.LEVEL_SEVERE,"GeographicMesh","constructor","Too many positions. Must be fewer than 65536. Try using multiple meshes."));for(var i=n[0].length,s=1;s<n.length;s++)if(n[s].length!==i)throw new t(a.logMessage(a.LEVEL_SEVERE,"GeographicMesh","constructor","Array lengths are inconsistent."));var o=n.length,l=n[0].length;e.call(this,r),this.pickTransparentImagePixels=!0,this._positions=n,this._altitudeScale=1,this.numRows=o,this.numColumns=l,this._textureCoordinates=null,this.referencePosition=this.determineReferencePosition(this._positions)};return m.prototype=Object.create(e.prototype),Object.defineProperties(m.prototype,{positions:{get:function(){return this._positions},set:function(e){if(!e)throw new t(a.logMessage(a.LEVEL_SEVERE,"GeographicMesh","positions","missingPositions"));if(e.length<2||e[0].length<2)throw new t(a.logMessage(a.LEVEL_SEVERE,"GeographicMesh","positions","Number of positions is insufficient."));for(var n=e[0].length,r=1;r<e.length;r++)if(e[r].length!==n)throw new t(a.logMessage(a.LEVEL_SEVERE,"GeographicMesh","positions","Array lengths are inconsistent."));this.numRows=e.length,this.numColumns=e[0].length,this._positions=e,this.referencePosition=this.determineReferencePosition(this._positions),this.reset(),this.meshIndices=null,this.outlineIndices=null}},textureCoordinates:{get:function(){return this._textureCoordinates},set:function(e){if(e&&e.length!=this.numRows)throw new t(a.logMessage(a.LEVEL_SEVERE,"GeographicMesh","textureCoordinates","Number of texture coordinate rows is inconsistent with the currently specified positions."));for(var n=0;n<this.numRows;n++)if(e[n].length!==this.numColumns)throw new t(a.logMessage(a.LEVEL_SEVERE,"GeographicMesh","textureCoordinates","Texture coordinate row lengths are inconsistent with the currently specified positions."));this._textureCoordinates=e,this.reset(),this.texCoords=null}}}),m.makeGridIndices=function(e,t){for(var n=[],r=0,i=0;i<e-1;i++)for(var s=0;s<t-1;s++){var o=i*t+s;n[r++]=o,n[r++]=o+1,n[r++]=o+t,n[r++]=o+1,n[r++]=o+1+t,n[r++]=o+t}return n},m.prototype.determineReferencePosition=function(e){return e[0][0]},m.prototype.createSurfaceShape=function(){for(var e=[],t=0;t<this.numColumns;t++)e.push(this._positions[0][t]);for(var n=1;n<this.numRows;n++)e.push(this._positions[n][this.numColumns-1]);for(t=this.numColumns-2;t>=0;t--)e.push(this._positions[this.numRows-1][t]);for(n=this.numRows-2;n>0;n--)e.push(this._positions[n][0]);return new d(e,null)},m.prototype.computeMeshPoints=function(e,t){for(var n,r,i=Number.MAX_VALUE,s=e.eyePoint,o=new Float32Array(this.numRows*this.numColumns*3),a=new p(0,0,0),l=0,h=0;h<this._positions.length;h++)for(var u=0,c=this._positions[h].length;u<c;u++)n=this._positions[h][u],e.surfacePointForMode(n.latitude,n.longitude,n.altitude*this._altitudeScale,this.altitudeMode,a),r=a.distanceToSquared(s),r<i&&(i=r),a.subtract(this.currentData.referencePoint),o[l++]=a[0],o[l++]=a[1],o[l++]=a[2];return t.eyeDistance=Math.sqrt(i),o},m.prototype.computeTexCoords=function(){return this._textureCoordinates?this.computeExplicitTexCoords():this.computeImplicitTexCoords()},m.prototype.computeExplicitTexCoords=function(){for(var e=new Float32Array(2*this.numRows*this.numColumns),t=0,n=0;n<this._textureCoordinates.length;n++)for(var r=0,i=this._textureCoordinates[n].length;r<i;r++){var s=this._textureCoordinates[n][r];e[t++]=s[0],e[t++]=s[1]}return e},m.prototype.computeImplicitTexCoords=function(){for(var e=new Float32Array(2*this.numRows*this.numColumns),t=1/(this.numRows-1),n=1/(this.numColumns-1),r=0,i=0;i<this._positions.length;i++)for(var s=i===this.numRows-1?1:i*t,o=0,a=this._positions[i].length;o<a;o++)e[r++]=o===this.numColumns-1?1:o*n,e[r++]=s;return e},m.prototype.computeMeshIndices=function(){for(var e=new Uint16Array((this.numRows-1)*(this.numColumns-1)*6),t=0,n=0;n<this.numRows-1;n++)for(var r=0;r<this.numColumns-1;r++){var i=n*this.numColumns+r;e[t++]=i,e[t++]=i+1,e[t++]=i+this.numColumns,e[t++]=i+1,e[t++]=i+1+this.numColumns,e[t++]=i+this.numColumns}return e},m.prototype.computeOutlineIndices=function(){for(var e=new Uint16Array(2*this.numRows+2*this.numColumns),t=0,n=0;n<this.numColumns;n++)e[t++]=n;for(var r=1;r<this.numRows;r++)e[t++]=(r+1)*this.numColumns-1;for(n=this.numRows*this.numColumns-2;n>=(this.numRows-1)*this.numColumns;n--)e[t++]=n;for(r=this.numRows-2;r>=0;r--)e[t++]=r*this.numColumns;return e},m}),define("shapes/GeographicText",["../error/ArgumentError","../util/Logger","../shapes/Text","../geom/Vec3"],function(e,t,n,r){"use strict";var i=function(r,i){if(!r)throw new e(t.logMessage(t.LEVEL_SEVERE,"Text","constructor","missingPosition"));n.call(this,i),this.position=r,this.declutterGroup=1};return i.placePoint=new r(0,0,0),i.prototype=Object.create(n.prototype),i.prototype.clone=function(){var e=new i(this.position,this.text);return e.copy(this),e.pickDelegate=this.pickDelegate?this.pickDelegate:this,e},i.prototype.render=function(e){e.globe.projectionLimits&&!e.globe.projectionLimits.containsLocation(this.position.latitude,this.position.longitude)||n.prototype.render.call(this,e)},i.prototype.computeScreenPointAndEyeDistance=function(e){return e.surfacePointForMode(this.position.latitude,this.position.longitude,this.position.altitude,this.altitudeMode,i.placePoint),!!e.frustumInModelCoordinates.containsPoint(i.placePoint)&&(this.eyeDistance=this.alwaysOnTop?0:e.eyePoint.distanceTo(i.placePoint),!!e.projectWithDepth(i.placePoint,this.depthOffset,this.screenPoint))},i}),define("formats/geojson/GeoJSONConstants",[],function(){"use strict";var e=function(){};return e.FIELD_TYPE="type",e.FIELD_CRS="crs",e.FIELD_NAME="name",e.FIELD_BBOX="bbox",e.FIELD_COORDINATES="coordinates",e.FIELD_GEOMETRIES="geometries",e.FIELD_GEOMETRY="geometry",e.FIELD_PROPERTIES="properties",e.FIELD_FEATURES="features",e.FIELD_ID="id",e.TYPE_POINT="Point",e.TYPE_MULTI_POINT="MultiPoint",e.TYPE_LINE_STRING="LineString",e.TYPE_MULTI_LINE_STRING="MultiLineString",e.TYPE_POLYGON="Polygon",e.TYPE_MULTI_POLYGON="MultiPolygon",e.TYPE_GEOMETRY_COLLECTION="GeometryCollection",e.TYPE_FEATURE="Feature",e.TYPE_FEATURE_COLLECTION="FeatureCollection",e.FIELD_CRS_NAME="name",e.FIELD_CRS_LINK="link",e.WGS84_CRS="urn:ogc:def:crs:OGC:1.3:CRS84",e.EPSG4326_CRS="EPSG:4326",e}),define("formats/geojson/GeoJSONExporter",["../../error/ArgumentError","./GeoJSONConstants","../../util/Logger"],function(e,t,n){"use strict";return{exportRenderable:function(t){if(!t)throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONExporter","exportRenderable","missingRenderable"));return t instanceof WorldWind.Placemark?this.exportPlacemark(t):t instanceof WorldWind.SurfacePolyline?this.exportSurfacePolyline(t):t instanceof WorldWind.SurfacePolygon?this.exportSurfacePolygon(t):t instanceof WorldWind.SurfaceEllipse?this.exportSurfaceEllipse(t):t instanceof WorldWind.SurfaceCircle?this.exportSurfaceCircle(t):t instanceof WorldWind.SurfaceRectangle?this.exportSurfaceRectangle(t):t instanceof WorldWind.SurfaceSector?this.exportSurfaceSector(t):t instanceof WorldWind.Path?this.exportPath(t):t instanceof WorldWind.Polygon?this.exportPolygon(t):(n.log(n.LEVEL_WARNING,"Export renderable not implemented: "+t),null)},exportRenderables:function(r){if(!r)throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONExporter","exportRenderables","missingRenderables"));if(0!=r.length){if(r.length>1){var i="{";i=i+'"'+t.FIELD_TYPE+'":"'+t.TYPE_GEOMETRY_COLLECTION+'"',i=i+',"'+t.FIELD_GEOMETRIES+'":[';for(var s=0;s<r.length;s++){var o=this.exportRenderable(r[s]);o&&(i+=o,i+=",")}return","===i.slice(-1)&&(i=i.substring(0,i.length-1)),i+="]",i+="}"}return this.exportRenderable(r[0])}},exportLayer:function(t){if(!t)throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONExporter","exportLayer","missingLayer"));return this.exportRenderables(t.renderables)},exportPlacemark:function(r){if(!(r instanceof WorldWind.Placemark))throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONExporter","exportPlacemark","invalidTypeOfRenderable"));var i="{";return i=i+'"'+t.FIELD_TYPE+'":"'+t.TYPE_POINT+'",',i=i+'"'+t.FIELD_COORDINATES+'":',i=i+"["+r.position.longitude+","+r.position.latitude+"]",i+="}"},exportSurfacePolyline:function(r){if(!(r instanceof WorldWind.SurfacePolyline))throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONExporter","exportSurfacePolyline","invalidTypeOfRenderable"));var i="{";i=i+'"'+t.FIELD_TYPE+'":"'+t.TYPE_LINE_STRING+'",',i=i+'"'+t.FIELD_COORDINATES+'":[';for(var s=0;s<r.boundaries.length;s++)i=i+"["+r.boundaries[s].longitude+","+r.boundaries[s].latitude+"]",s!==r.boundaries.length-1&&(i+=",");return i+="]",i+="}"},exportSurfacePolygon:function(r){if(!(r instanceof WorldWind.SurfacePolygon))throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONExporter","exportSurfacePolygon","invalidTypeOfRenderable"));var i="{";if(i=i+'"'+t.FIELD_TYPE+'":"'+t.TYPE_POLYGON+'",',i=i+'"'+t.FIELD_COORDINATES+'":[',r.boundaries.length>0&&r.boundaries[0].length>2)for(var s=0;s<r.boundaries.length;s++){i+="[";for(var o=0;o<r.boundaries[s].length;o++)i=i+"["+r.boundaries[s][o].longitude+","+r.boundaries[s][o].latitude+"]",i+=",",o===r.boundaries[s].length-1&&(i=i+"["+r.boundaries[s][0].longitude+","+r.boundaries[s][0].latitude+"]");i+="]",s!==r.boundaries.length-1&&(i+=",")}else{i+="[";for(var s=0;s<r.boundaries.length;s++)i=i+"["+r.boundaries[s].longitude+","+r.boundaries[s].latitude+"]",i+=",",s===r.boundaries.length-1&&(i=i+"["+r.boundaries[0].longitude+","+r.boundaries[0].latitude+"]");i+="]"}return i+="]",i+="}"},exportSurfaceEllipse:function(r){if(!(r instanceof WorldWind.SurfaceEllipse))throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONExporter","exportSurfaceEllipse","invalidTypeOfRenderable"));var i="{";i=i+'"'+t.FIELD_TYPE+'":"'+t.TYPE_POLYGON+'",',i=i+'"'+t.FIELD_COORDINATES+'":[',i+="[";for(var s=0;s<r._boundaries.length;s++)i=i+"["+r._boundaries[s].longitude+","+r._boundaries[s].latitude+"]",i+=",",s===r._boundaries.length-1&&(i=i+"["+r._boundaries[0].longitude+","+r._boundaries[0].latitude+"]");return i+="]",i+="]",i+="}"},exportSurfaceCircle:function(r){if(!(r instanceof WorldWind.SurfaceCircle))throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONExporter","exportSurfaceCircle","invalidTypeOfRenderable"));var i="{";i=i+'"'+t.FIELD_TYPE+'":"'+t.TYPE_POLYGON+'",',i=i+'"'+t.FIELD_COORDINATES+'":[',i+="[";for(var s=r._boundaries.length-1;s>=0;s--)i=i+"["+r._boundaries[s].longitude+","+r._boundaries[s].latitude+"]",i+=",",0===s&&(i=i+"["+r._boundaries[r._boundaries.length-1].longitude+","+r._boundaries[r._boundaries.length-1].latitude+"]");return i+="]",i+="]",i+="}"},exportSurfaceRectangle:function(r){if(!(r instanceof WorldWind.SurfaceRectangle))throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONExporter","exportSurfaceRectangle","invalidTypeOfRenderable"));var i="{";i=i+'"'+t.FIELD_TYPE+'":"'+t.TYPE_POLYGON+'",',i=i+'"'+t.FIELD_COORDINATES+'":[',i+="[";for(var s=0;s<r._boundaries.length;s++)i=i+"["+r._boundaries[s].longitude+","+r._boundaries[s].latitude+"]",i+=",",s===r._boundaries.length-1&&(i=i+"["+r._boundaries[0].longitude+","+r._boundaries[0].latitude+"]");return i+="]",i+="]",i+="}"},exportSurfaceSector:function(r){if(!(r instanceof WorldWind.SurfaceSector))throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONExporter","exportSurfaceSector","invalidTypeOfRenderable"));var i="{";i=i+'"'+t.FIELD_TYPE+'":"'+t.TYPE_POLYGON+'",',i=i+'"'+t.FIELD_COORDINATES+'":[',i+="[",r._boundaries.reverse();for(var s=0;s<r._boundaries.length;s++)i=i+"["+r._boundaries[s].longitude+","+r._boundaries[s].latitude+"]",i+=",",s===r._boundaries.length-1&&(i=i+"["+r._boundaries[0].longitude+","+r._boundaries[0].latitude+"]");return i+="]",i+="]",i+="}"},exportPath:function(r){if(!(r instanceof WorldWind.Path))throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONExporter","exportPath","invalidTypeOfRenderable"));var i="{";i=i+'"'+t.FIELD_TYPE+'":"'+t.TYPE_LINE_STRING+'",',i=i+'"'+t.FIELD_COORDINATES+'":[';for(var s=0;s<r.positions.length;s++)i=i+"["+r.positions[s].longitude+","+r.positions[s].latitude+","+r.positions[s].altitude+"]",s!==r.positions.length-1&&(i+=",");return i+="]",i+="}"},exportPolygon:function(r){if(!(r instanceof WorldWind.Polygon))throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONExporter","exportPolygon","invalidTypeOfRenderable"));var i="{";if(i=i+'"'+t.FIELD_TYPE+'":"'+t.TYPE_POLYGON+'",',i=i+'"'+t.FIELD_COORDINATES+'":[',r.boundaries.length>0&&r.boundaries[0].length>2)for(var s=0;s<r.boundaries.length;s++){i+="[";for(var o=0;o<r.boundaries[s].length;o++)i=i+"["+r.boundaries[s][o].longitude+","+r.boundaries[s][o].latitude+","+r.boundaries[s][o].altitude+"]",i+=",",o===r.boundaries[s].length-1&&(i=i+"["+r.boundaries[s][0].longitude+","+r.boundaries[s][0].latitude+","+r.boundaries[s][0].altitude+"]");i+="]",s!==r.boundaries.length-1&&(i+=",")}else{i+="[";for(var s=0;s<r.boundaries.length;s++)i=i+"["+r.boundaries[s].longitude+","+r.boundaries[s].latitude+","+r.boundaries[s].altitude+"]",i+=",",s===r.boundaries.length-1&&(i=i+"["+r.boundaries[0].longitude+","+r.boundaries[0].latitude+","+r.boundaries[0].altitude+"]");i+="]"}return i+="]",i+="}"}}}),define("formats/geojson/GeoJSONGeometry",["../../error/ArgumentError","./GeoJSONConstants","../../util/Logger"],function(e,t,n){"use strict";var r=function(t,r,i){if(!t)throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONGeometry","constructor","missingCoordinates"));if(!r)throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONGeometry","constructor","missingType"));this._coordinates=t,this._type=r,this._bbox=i||null};return Object.defineProperties(r.prototype,{coordinates:{get:function(){return this._coordinates}},type:{get:function(){return this._type}},bbox:{get:function(){return this._bbox}}}),r.prototype.isPointType=function(){return this.type===t.TYPE_POINT},r.prototype.isMultiPointType=function(){return this.type===t.TYPE_MULTI_POINT},r.prototype.isLineStringType=function(){return this.type===t.TYPE_LINE_STRING},r.prototype.isMultiLineStringType=function(){return this.type===t.TYPE_MULTI_LINE_STRING},r.prototype.isPolygonType=function(){return this.type===t.TYPE_POLYGON},r.prototype.isMultiPolygonType=function(){return this.type===t.TYPE_MULTI_POLYGON},r}),define("formats/geojson/GeoJSONGeometryCollection",["../../error/ArgumentError","./GeoJSONConstants","../../util/Logger"],function(e,t,n){"use strict";var r=function(t,r){if(!t)throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONGeometryCollection","constructor","missingGeometries"));if("[object Array]"!==Object.prototype.toString.call(t))throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONGeometryCollection","constructor","invalidGeometries"));this._geometries=t,this._bbox=r};return Object.defineProperties(r.prototype,{geometries:{get:function(){return this._geometries}},bbox:{get:function(){return this._bbox}}}),r}),define("formats/geojson/GeoJSONGeometryLineString",["../../error/ArgumentError","./GeoJSONGeometry","../../util/Logger"],function(e,t,n){"use strict";var r=function(r,i,s){if(!r)throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONGeometryLineString","constructor","missingCoordinates"));if(r.length<2||r[0].length<2)throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONGeometryLineString","constructor","invalidNumberOfCoordinates"));if("[object Array]"!==Object.prototype.toString.call(r[0])||"[object Number]"!==Object.prototype.toString.call(r[0][0]))throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONGeometryLineString","constructor","invalidCoordinatesType"));if(!i)throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONGeometryLineString","constructor","missingType"));t.call(this,r,i,s)};return r.prototype=Object.create(t.prototype),r}),define("formats/geojson/GeoJSONGeometryMultiLineString",["../../error/ArgumentError","./GeoJSONGeometry","../../util/Logger"],function(e,t,n){"use strict";var r=function(r,i,s){if(!r)throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONGeometryMultiLineString","constructor","missingCoordinates"));if(r[0].length<2||r[0][0].length<2)throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONGeometryMultiLineString","constructor","invalidNumberOfCoordinates"));if("[object Array]"!==Object.prototype.toString.call(r[0])||"[object Array]"!==Object.prototype.toString.call(r[0][0])||"[object Number]"!==Object.prototype.toString.call(r[0][0][0]))throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONGeometryMultiLineString","constructor","invalidCoordinatesType"));if(!i)throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONGeometryLineString","constructor","missingType"));t.call(this,r,i,s)};return r.prototype=Object.create(t.prototype),r}),define("formats/geojson/GeoJSONGeometryMultiPoint",["../../error/ArgumentError","./GeoJSONGeometry","../../util/Logger"],function(e,t,n){"use strict";var r=function(r,i,s){if(!r)throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONGeometryMultiPoint","constructor","missingCoordinates"));if(r[0].length<2)throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONGeometryMultiPoint","constructor","invalidNumberOfCoordinates"));if("[object Array]"!==Object.prototype.toString.call(r[0])||"[object Number]"!==Object.prototype.toString.call(r[0][0]))throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONGeometryMultiPoint","constructor","invalidCoordinatesType"));if(!i)throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONGeometryPoint","constructor","missingType"));t.call(this,r,i,s)};return r.prototype=Object.create(t.prototype),r}),define("formats/geojson/GeoJSONGeometryMultiPolygon",["../../error/ArgumentError","./GeoJSONGeometry","../../util/Logger"],function(e,t,n){"use strict";var r=function(r,i,s){if(!r)throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONGeometryMultiPolygon","constructor","missingCoordinates"));if("[object Array]"!==Object.prototype.toString.call(r[0])||"[object Array]"!==Object.prototype.toString.call(r[0][0])||"[object Array]"!==Object.prototype.toString.call(r[0][0][0])||"[object Number]"!==Object.prototype.toString.call(r[0][0][0][0]))throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONGeometryPolygon","constructor","invalidCoordinatesType"));if(!i)throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONGeometryPolygon","constructor","missingType"));t.call(this,r,i,s)};return r.prototype=Object.create(t.prototype),r}),define("formats/geojson/GeoJSONGeometryPoint",["../../error/ArgumentError","./GeoJSONGeometry","../../util/Logger"],function(e,t,n){"use strict";var r=function(r,i,s){if(!r)throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONGeometryPoint","constructor","missingCoordinates"));if(r.length<2)throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONGeometryPoint","constructor","invalidNumberOfCoordinates"));if("[object Array]"!==Object.prototype.toString.call(r)||"[object Number]"!==Object.prototype.toString.call(r[0]))throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONGeometryPoint","constructor","invalidCoordinatesType"));if(!i)throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONGeometryPoint","constructor","missingType"));t.call(this,r,i,s)};return r.prototype=Object.create(t.prototype),r}),define("formats/geojson/GeoJSONGeometryPolygon",["../../error/ArgumentError","./GeoJSONGeometry","../../util/Logger"],function(e,t,n){"use strict";var r=function(r,i,s){if(!r)throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONGeometryPolygon","constructor","missingCoordinates"));if(r[0].length<2||r[0][0].length<2)throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONGeometryPolygon","constructor","invalidNumberOfCoordinates"));if("[object Array]"!==Object.prototype.toString.call(r[0])||"[object Array]"!==Object.prototype.toString.call(r[0][0])||"[object Number]"!==Object.prototype.toString.call(r[0][0][0]))throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONGeometryPolygon","constructor","invalidCoordinatesType"));for(var o=0;o<r.length;o++)if(r[o][0][0]!==r[o][r[o].length-1][0]||r[o][0][1]!==r[o][r[o].length-1][1])throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONGeometryPolygon","constructor","invalidLinearRing"));if(!i)throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONGeometryPolygon","constructor","missingType"));t.call(this,r,i,s)};return r.prototype=Object.create(t.prototype),r}),define("formats/geojson/GeoJSONCRS",["../../error/ArgumentError","./GeoJSONConstants","../../util/Logger","../../util/proj4-src"],function(e,t,n,r){"use strict";var i=function(t,r){if(!t)throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONCRS","constructor","missingType"));if(!r)throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONCRS","constructor","missingProperties"));this._type=t,this._properties=r,this._projectionString=null};return Object.defineProperties(i.prototype,{type:{get:function(){return this._type}},properties:{get:function(){return this._properties}},projectionString:{get:function(){return this._projectionString}}}),i.prototype.isDefault=function(){return!(!this.isNamed()||this._projectionString!==t.EPSG4326_CRS&&this._projectionString!==t.WGS84_CRS)},i.prototype.isNamed=function(){return this._type===t.FIELD_CRS_NAME},i.prototype.isLinked=function(){return this._type===t.FIELD_CRS_LINK},i.prototype.isCRSSupported=function(){try{r(this._projectionString,t.EPSG4326_CRS)}catch(e){return n.log(n.LEVEL_WARNING,"Unknown GeoJSON coordinate reference system ("+e+"): "+this._properties.name),!1}return!0},i.prototype.getLinkedCRSString=function(e,t){var r=new XMLHttpRequest;r.open("GET",e,!0),r.responseType="text",r.onreadystatechange=function(){4===r.readyState&&(200===r.status?(this._projectionString=r.response,t()):n.log(n.LEVEL_WARNING,"GeoJSON Linked CRS retrieval failed ("+r.statusText+"): "+e))}.bind(this),r.onerror=function(){n.log(n.LEVEL_WARNING,"GeoJSON Linked CRS retrieval failed: "+e)},r.ontimeout=function(){n.log(n.LEVEL_WARNING,"GeoJSON Linked CRS retrieval timed out: "+e)},r.send(null)},i.prototype.setCRSString=function(e){this.isNamed()?(this._projectionString=this._properties.name,e()):this.isLinked()&&this.getLinkedCRSString(this._properties.href,e)},i}),define("formats/geojson/GeoJSONFeature",["../../error/ArgumentError","./GeoJSONConstants","../../util/Logger"],function(e,t,n){"use strict";var r=function(r,i,s,o){if(!r)throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONFeature","constructor","missingGeometry"));if(!r[t.FIELD_TYPE])throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONFeature","constructor","missingFeatureGeometryType"));if(!i)throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONFeature","constructor","missingProperties"));this._geometry=r,this._properties=i,this._id=s,this._bbox=o};return Object.defineProperties(r.prototype,{geometry:{get:function(){return this._geometry}},properties:{get:function(){return this._properties}},id:{get:function(){return this._id}},bbox:{get:function(){return this._bbox}}}),r}),define("formats/geojson/GeoJSONFeatureCollection",["../../error/ArgumentError","./GeoJSONConstants","../../util/Logger"],function(e,t,n){"use strict";var r=function(t,r){if(!t)throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONFeatureCollection","constructor","missingFeatures"));if("[object Array]"!==Object.prototype.toString.call(t))throw new e(n.logMessage(n.LEVEL_SEVERE,"GeoJSONFeatureCollection","constructor","invalidFeatures"));this._features=t,this._bbox=r};return Object.defineProperties(r.prototype,{features:{get:function(){return this._features}},bbox:{get:function(){return this._bbox}}}),r}),define("shapes/SurfacePolyline",["../error/ArgumentError","../util/Logger","../shapes/ShapeAttributes","../shapes/SurfaceShape"],function(e,t,n,r){"use strict";var i=function(n,s){if(!n)throw new e(t.logMessage(t.LEVEL_SEVERE,"SurfacePolyline","constructor","The specified locations array is null or undefined."));r.call(this,s),this._boundaries=n,this._stateId=i.stateId++,this._isInteriorInhibited=!0};return i.prototype=Object.create(r.prototype),Object.defineProperties(i.prototype,{boundaries:{get:function(){return this._boundaries},set:function(n){if(!Array.isArray(n))throw new e(t.logMessage(t.LEVEL_SEVERE,"SurfacePolyline","set boundaries","The specified value is not an array."));this.resetBoundaries(),this._boundaries=n,this._stateId=i.stateId++,this.stateKeyInvalid=!0}}}),i.stateId=Number.MIN_SAFE_INTEGER,i.staticStateKey=function(e){return r.staticStateKey(e)+" pl "+e._stateId},i.prototype.computeStateKey=function(){return i.staticStateKey(this)},i.prototype.computeBoundaries=function(e){},i.prototype.getReferencePosition=function(){return this.boundaries.length>1?this.boundaries[0]:null},i.prototype.moveTo=function(e,t){this.boundaries=this.computeShiftedLocations(e,this.getReferencePosition(),t,this._boundaries)},i}),define("shapes/Path",["../shapes/AbstractShape","../error/ArgumentError","../shaders/BasicTextureProgram","../geom/BoundingBox","../util/Color","../geom/Location","../util/Logger","../geom/Matrix","../pick/PickedObject","../geom/Position","../shapes/ShapeAttributes","../shapes/SurfacePolyline","../geom/Vec2","../geom/Vec3"],function(e,t,n,r,i,s,o,a,l,h,u,c,d,f){"use strict";var p=function(n,r){if(!n)throw new t(o.logMessage(o.LEVEL_SEVERE,"Path","constructor","missingPositions"));e.call(this,r),this._positions=n,this._pathType=WorldWind.GREAT_CIRCLE,this._terrainConformance=10,this._numSubSegments=10,this.referencePosition=this.determineReferencePosition(this._positions),this.scratchPoint=new f(0,0,0)};return p.prototype=Object.create(e.prototype),Object.defineProperties(p.prototype,{positions:{get:function(){return this._positions},set:function(e){if(!e)throw new t(o.logMessage(o.LEVEL_SEVERE,"Path","constructor","missingPositions"));this._positions=e,this.referencePosition=this.determineReferencePosition(this._positions),this.reset()}},followTerrain:{get:function(){return this._followTerrain},set:function(e){this._followTerrain=e,this.reset()}},terrainConformance:{get:function(){return this._terrainConformance},set:function(e){this._terrainConformance=e,this.reset()}},numSubSegments:{get:function(){return this._numSubSegments},set:function(e){this._numSubSegments=e>=0?e:0,this.reset()}},pathType:{get:function(){return this._pathType},set:function(e){this._pathType=e,this.reset()}},extrude:{get:function(){return this._extrude},set:function(e){this._extrude=e,this.reset()}}}),p.prototype.determineReferencePosition=function(e){return e.length>0?e[0]:null},p.prototype.mustGenerateGeometry=function(e){return!this.currentData.tessellatedPoints||(this.currentData.drawInterior!==this.activeAttributes.drawInterior||this.currentData.drawVerticals!==this.activeAttributes.drawVerticals||(!this.followTerrain&&this.currentData.numSubSegments!==this.numSubSegments||(!(!this.followTerrain||this.currentData.terrainConformance===this.terrainConformance)||this.altitudeMode!==WorldWind.ABSOLUTE&&this.currentData.isExpired)))},p.prototype.createSurfaceShape=function(){return new c(this.positions,null)},p.prototype.doMakeOrderedRenderable=function(e){if(!this.referencePosition)return null;if(!this.mustGenerateGeometry(e))return this;var t=this.currentData.referencePoint;e.surfacePointForMode(this.referencePosition.latitude,this.referencePosition.longitude,this.referencePosition.altitude,this._altitudeMode,t),this.currentData.transformationMatrix.setToTranslation(t[0],t[1],t[2]);var n=this.makeTessellatedPositions(e);if(n.length<2)return null;var i=this.computeRenderedPath(e,n);return this.currentData.tessellatedPoints=i,this.currentData.drawInterior=this.activeAttributes.drawInterior,this.currentData.drawVerticals=this.activeAttributes.drawVerticals,this.currentData.numSubSegments=this.numSubSegments,this.currentData.terrainConformance=this.terrainConformance,this.resetExpiration(this.currentData),this.currentData.fillVbo=!0,this.currentData.extent||(this.currentData.extent=new r),this.currentData.extent.setToPoints(i),this.currentData.extent.translate(this.currentData.referencePoint),this},p.prototype.makeTessellatedPositions=function(e){var t,n,r,i=[],s=e.eyePoint,o=this.mustDrawVerticals(e),a=new f(0,0,0),l=new f(0,0,0),h=this._positions[0];o&&(this.currentData.verticalIndices=new Int16Array(2*this.positions.length),this.currentData.verticalIndices[0]=0,this.currentData.verticalIndices[1]=1),i.push(h),e.surfacePointForMode(h.latitude,h.longitude,h.altitude,this._altitudeMode,a);for(var u=1,c=this._positions.length;u<c;u++)if(t=this._positions[u],e.surfacePointForMode(t.latitude,t.longitude,t.altitude,this._altitudeMode,l),n=s.distanceTo(a),r=e.pixelSizeAtDistance(n),a.distanceTo(l)<8*r&&this.altitudeMode!==WorldWind.ABSOLUTE?i.push(t):this.makeSegment(e,h,t,a,l,i),h=t,a.copy(l),o){var d=2*(i.length-1);this.currentData.verticalIndices[2*u]=d,this.currentData.verticalIndices[2*u+1]=d+1}return i},p.prototype.makeSegment=function(e,t,n,r,i,o){var a,l,u,c,d,f,p=e.eyePoint,m=new s(0,0),g=0;if(this._pathType===WorldWind.LINEAR&&!this._followTerrain)return void(r.equals(i)||o.push(n));if(u=this._pathType===WorldWind.LINEAR?s.linearDistance(t,n):this._pathType===WorldWind.RHUMB_LINE?s.rhumbDistance(t,n):s.greatCircleDistance(t,n),this._altitudeMode!==WorldWind.CLAMP_TO_GROUND&&(g=.5*(t.altitude+n.altitude)),!((a=u*(e.globe.equatorialRadius+g*e.verticalExaggeration))<=0)){
for(l=this._pathType===WorldWind.LINEAR?s.linearAzimuth(t,n):this._pathType===WorldWind.RHUMB_LINE?s.rhumbAzimuth(t,n):s.greatCircleAzimuth(t,n),this.scratchPoint.copy(r),c=0,d=0;c<1&&(this._followTerrain?d+=this._terrainConformance*e.pixelSizeAtDistance(this.scratchPoint.distanceTo(p)):d+=a/this._numSubSegments,!(a<d||a-d<1e-9));)c=d/a,f=c*u,this._pathType===WorldWind.LINEAR?s.linearLocation(t,l,f,m):this._pathType===WorldWind.RHUMB_LINE?s.rhumbLocation(t,l,f,m):s.greatCircleLocation(t,l,f,m),m.altitude=(1-c)*t.altitude+c*n.altitude,o.push(new h(m.latitude,m.longitude,m.altitude)),this._followTerrain&&e.surfacePointForMode(m.latitude,m.longitude,m.altitude,WorldWind.CLAMP_TO_GROUND,this.scratchPoint);o.push(n)}},p.prototype.computeRenderedPath=function(e,t){var n,r,i,s,o=this.mustDrawInterior(e)||this.mustDrawVerticals(e),a=Number.MAX_VALUE,l=e.eyePoint,h=(o?2:1)*t.length,u=new Float32Array(3*h),c=o?6:3,d=new f(0,0,0);n=this._followTerrain&&this.altitudeMode!==WorldWind.CLAMP_TO_GROUND?WorldWind.RELATIVE_TO_GROUND:this.altitudeMode;for(var p=0,m=t.length;p<m;p++)r=t[p],e.surfacePointForMode(r.latitude,r.longitude,r.altitude,n,d),s=d.distanceToSquared(l),s<a&&(a=s),d.subtract(this.currentData.referencePoint),i=c*p,u[i]=d[0],u[i+1]=d[1],u[i+2]=d[2],o&&(e.surfacePointForMode(r.latitude,r.longitude,0,WorldWind.CLAMP_TO_GROUND,d),s=d.distanceToSquared(l),s<a&&(a=s),d.subtract(this.currentData.referencePoint),u[i+3]=d[0],u[i+4]=d[1],u[i+5]=d[2]);return this.currentData.pointBufferHasExtrusionPoints=o,this.currentData.eyeDistance=Math.sqrt(a),u},p.prototype.mustDrawInterior=function(e){return this.activeAttributes.drawInterior&&this._extrude&&this._altitudeMode!==WorldWind.CLAMP_TO_GROUND},p.prototype.mustDrawVerticals=function(e){return this.activeAttributes.drawOutline&&this.activeAttributes.drawVerticals&&this.altitudeMode!==WorldWind.CLAMP_TO_GROUND},p.prototype.doRenderOrdered=function(e){var t,n,r,i,s,o=e.currentGlContext,a=e.currentProgram,h=this.currentData,u=h.tessellatedPoints.length/3;if(this.applyMvpMatrix(e),h.vboCacheKey||(h.vboCacheKey=e.gpuResourceCache.generateCacheKey()),t=e.gpuResourceCache.resourceForKey(h.vboCacheKey),t||(t=o.createBuffer(),e.gpuResourceCache.putResource(this.currentData.vboCacheKey,t,4*h.tessellatedPoints.length),h.fillVbo=!0),o.bindBuffer(o.ARRAY_BUFFER,t),h.fillVbo&&(o.bufferData(o.ARRAY_BUFFER,h.tessellatedPoints,o.STATIC_DRAW),e.frameStatistics.incrementVboLoadCount(1)),a.loadTextureEnabled(o,!1),e.pickingMode&&(r=e.uniquePickColor()),this.mustDrawInterior(e)&&(n=this.activeAttributes.interiorColor,o.depthMask(n.alpha*this.layer.opacity>=1||e.pickingMode),a.loadColor(o,e.pickingMode?r:n),a.loadOpacity(o,e.pickingMode?1:this.layer.opacity),o.vertexAttribPointer(a.vertexPointLocation,3,o.FLOAT,!1,0,0),o.drawArrays(o.TRIANGLE_STRIP,0,u)),this.activeAttributes.drawOutline&&((this.mustDrawVerticals(e)&&this.mustDrawInterior(e)||this.altitudeMode===WorldWind.CLAMP_TO_GROUND)&&this.applyMvpMatrixForOutline(e),n=this.activeAttributes.outlineColor,o.depthMask(n.alpha*this.layer.opacity>=1||e.pickingMode),a.loadColor(o,e.pickingMode?r:n),a.loadOpacity(o,e.pickingMode?1:this.layer.opacity),o.lineWidth(this.activeAttributes.outlineWidth),this.currentData.pointBufferHasExtrusionPoints?(i=24,s=u/2):(i=12,s=u),o.vertexAttribPointer(a.vertexPointLocation,3,o.FLOAT,!1,i,0),o.drawArrays(o.LINE_STRIP,0,s),this.mustDrawVerticals(e)&&(h.verticalIndicesVboCacheKey||(h.verticalIndicesVboCacheKey=e.gpuResourceCache.generateCacheKey()),t=e.gpuResourceCache.resourceForKey(h.verticalIndicesVboCacheKey),t||(t=o.createBuffer(),e.gpuResourceCache.putResource(h.verticalIndicesVboCacheKey,t,4*h.verticalIndices.length),h.fillVbo=!0),o.bindBuffer(o.ELEMENT_ARRAY_BUFFER,t),h.fillVbo&&(o.bufferData(o.ELEMENT_ARRAY_BUFFER,h.verticalIndices,o.STATIC_DRAW),e.frameStatistics.incrementVboLoadCount(1)),o.vertexAttribPointer(a.vertexPointLocation,3,o.FLOAT,!1,0,0),o.drawElements(o.LINES,h.verticalIndices.length,o.UNSIGNED_SHORT,0))),h.fillVbo=!1,e.pickingMode){var c=new l(r,this.pickDelegate?this.pickDelegate:this,null,this.layer,!1);e.resolvePick(c)}},p.prototype.beginDrawing=function(e){var t=e.currentGlContext;this.mustDrawInterior(e)&&t.disable(t.CULL_FACE),e.findAndBindProgram(n),t.enableVertexAttribArray(e.currentProgram.vertexPointLocation)},p.prototype.endDrawing=function(e){var t=e.currentGlContext;t.disableVertexAttribArray(e.currentProgram.vertexPointLocation),t.depthMask(!0),t.lineWidth(1),t.enable(t.CULL_FACE)},p}),define("shapes/PlacemarkAttributes",["../util/Color","../util/Font","../util/Offset","../shapes/ShapeAttributes","../shapes/TextAttributes"],function(e,t,n,r,i){"use strict";var s=function(t){this._imageColor=t?t._imageColor.clone():e.WHITE.clone(),this._imageOffset=t?t._imageOffset:new n(WorldWind.OFFSET_FRACTION,.5,WorldWind.OFFSET_FRACTION,.5),this._imageInitialWidth=t?t._imageInitialWidth:null,this._imageInitialHeight=t?t._imageInitialHeight:null,this._imageScale=t?t._imageScale:1,this._imageSource=t?t._imageSource:null,this._depthTest=!t||t._depthTest,this._labelAttributes=new i(t?t._labelAttributes:null),this._drawLeaderLine=!!t&&t._drawLeaderLine,this._leaderLineAttributes=new r(t?t._leaderLineAttributes:null),this.stateKeyInvalid=!0};return s.prototype.computeStateKey=function(){return"ic "+this._imageColor.toHexString(!0)+" io "+this._imageOffset.toString()+" iiw "+this._imageInitialWidth+" iih "+this._imageInitialHeight+" is "+this._imageScale+" ip "+this._imageSource+" dt "+this._depthTest+" la "+this._labelAttributes.stateKey+" dll "+this._drawLeaderLine+" lla "+this._leaderLineAttributes.stateKey},Object.defineProperties(s.prototype,{stateKey:{get:function(){return this.stateKeyInvalid&&(this._stateKey=this.computeStateKey(),this.stateKeyInvalid=!1),this._stateKey}},imageColor:{get:function(){return this._imageColor},set:function(e){this._imageColor=e,this.stateKeyInvalid=!0}},imageOffset:{get:function(){return this._imageOffset},set:function(e){this._imageOffset=e,this.stateKeyInvalid=!0}},imageInitialWidth:{get:function(){return this._imageInitialWidth},set:function(e){this._imageInitialWidth=e,this.stateKeyInvalid=!0}},imageInitialHeight:{get:function(){return this._imageInitialHeight},set:function(e){this._imageInitialHeight=e,this.stateKeyInvalid=!0}},imageScale:{get:function(){return this._imageScale},set:function(e){this._imageScale=e,this.stateKeyInvalid=!0}},imageSource:{get:function(){return this._imageSource},set:function(e){this._imageSource=e,this.stateKeyInvalid=!0}},depthTest:{get:function(){return this._depthTest},set:function(e){this._depthTest=e,this.stateKeyInvalid=!0}},labelAttributes:{get:function(){return this._labelAttributes},set:function(e){this._labelAttributes=e,this.stateKeyInvalid=!0}},drawLeaderLine:{get:function(){return this._drawLeaderLine},set:function(e){this._drawLeaderLine=e,this.stateKeyInvalid=!0}},leaderLineAttributes:{get:function(){return this._leaderLineAttributes},set:function(e){this._leaderLineAttributes=e,this.stateKeyInvalid=!0}}}),s}),define("shapes/Placemark",["../error/ArgumentError","../shaders/BasicTextureProgram","../util/Color","../util/Font","../util/Logger","../geom/Matrix","../pick/PickedObject","../shapes/PlacemarkAttributes","../render/Renderable","../geom/Vec2","../geom/Vec3","../util/WWMath"],function(e,t,n,r,i,s,o,a,l,h,u,c){"use strict";var d=function(t,n,r){if(!t)throw new e(i.logMessage(i.LEVEL_SEVERE,"Placemark","constructor","missingPosition"));l.call(this),this.attributes=r||new a(null),this.highlightAttributes=null,this.highlighted=!1,this.position=t,this.eyeDistanceScaling=n,this.eyeDistanceScalingThreshold=1e6,this.eyeDistanceScalingLabelThreshold=1.5*this.eyeDistanceScalingThreshold,this.label=null,this.altitudeMode=WorldWind.ABSOLUTE,this.alwaysOnTop=!1,this.enableLeaderLinePicking=!1,this.updateImage=!0,this.declutterGroup=2,this.targetVisibility=1,this.currentVisibility=1,this.imageRotation=0,this.imageTilt=0,this.imageRotationReference=WorldWind.RELATIVE_TO_SCREEN,this.imageTiltReference=WorldWind.RELATIVE_TO_SCREEN,this.activeAttributes=null,this.activeTexture=null,this.labelTexture=null,this.placePoint=new u(0,0,0),this.groundPoint=new u(0,0,0),this.imageTransform=s.fromIdentity(),this.labelTransform=s.fromIdentity(),this.texCoordMatrix=s.fromIdentity(),this.imageBounds=null,this.layer=null};return d.defaultDepthOffset=-.03,d.screenPoint=new u(0,0,0),d.matrix=s.fromIdentity(),d.scratchPoint=new u(0,0,0),d.prototype=Object.create(l.prototype),Object.defineProperties(d.prototype,{screenBounds:{get:function(){return this.labelBounds}}}),d.prototype.copy=function(e){return this.position=e.position,this.attributes=e.attributes,this.highlightAttributes=e.highlightAttributes,this.highlighted=e.highlighted,this.enabled=e.enabled,this.label=e.label,this.altitudeMode=e.altitudeMode,this.pickDelegate=e.pickDelegate,this.alwaysOnTop=e.alwaysOnTop,this.depthOffset=e.depthOffset,this.targetVisibility=e.targetVisibility,this.currentVisibility=e.currentVisibility,this.imageRotation=e.imageRotation,this.imageTilt=e.imageTilt,this.imageRotationReference=e.imageRotationReference,this.imageTiltReference=e.imageTiltReference,this},d.prototype.clone=function(){var e=new d(this.position);return e.copy(this),e.pickDelegate=this.pickDelegate?this.pickDelegate:this,e},d.prototype.render=function(e){if(this.enabled&&e.accumulateOrderedRenderables&&(!e.globe.projectionLimits||e.globe.projectionLimits.containsLocation(this.position.latitude,this.position.longitude))){var t;if(this.lastFrameTime!==e.timestamp)t=this.makeOrderedRenderable(e);else{t=this.clone().makeOrderedRenderable(e)}t&&t.isVisible(e)&&(t.layer=e.currentLayer,this.lastFrameTime=e.timestamp,e.addOrderedRenderable(t))}},d.prototype.renderOrdered=function(e){if(this.drawOrderedPlacemark(e),e.pickingMode){var t=new o(this.pickColor.clone(),this.pickDelegate?this.pickDelegate:this,this.position,this.layer,!1);e.pickPoint&&this.mustDrawLabel()&&this.labelBounds.containsPoint(e.convertPointToViewport(e.pickPoint,d.scratchPoint))&&(t.labelPicked=!0),e.resolvePick(t)}},d.prototype.makeOrderedRenderable=function(e){if(e.surfacePointForMode(this.position.latitude,this.position.longitude,this.position.altitude,this.altitudeMode,this.placePoint),this.eyeDistance=this.alwaysOnTop?0:e.eyePoint.distanceTo(this.placePoint),this.selectLevelOfDetail(e,this,this.eyeDistance),this.determineActiveAttributes(e),!this.activeAttributes)return null;this.mustDrawLeaderLine(e)&&e.surfacePointForMode(this.position.latitude,this.position.longitude,0,this.altitudeMode,this.groundPoint);var t=0,n=Math.abs(e.camera.tilt);if(this.eyeDistance<e.horizonDistance&&n<=90&&(t=(1-n/90)*d.defaultDepthOffset),!e.projectWithDepth(this.placePoint,t,d.screenPoint))return null;var r=this.eyeDistanceScaling?Math.max(0,Math.min(1,this.eyeDistanceScalingThreshold/this.eyeDistance)):1;this.imageTransform.setToIdentity();var i,s,o,a,l;if(this.activeTexture){var h=this.activeTexture.originalImageWidth,u=this.activeTexture.originalImageHeight,f=this.activeAttributes.imageScale*r;i=this.activeAttributes.imageOffset.offsetForSize(h,u),s=i[0]*f,o=i[1]*f,a=h*f,l=u*f}else{var p=this.activeAttributes.imageScale*r;i=this.activeAttributes.imageOffset.offsetForSize(f,f),s=i[0],o=i[1],a=l=p}if(this.imageTransform.multiplyByTranslation(d.screenPoint[0],d.screenPoint[1],d.screenPoint[2]),this.imageTransform.multiplyByScale(1,1,1/(1<<24)),this.imageTilt){var m=this.imageTiltReference===WorldWind.RELATIVE_TO_GLOBE?e.camera.tilt+this.imageTilt:this.imageTilt;this.imageTransform.multiplyByRotation(-1,0,0,m)}if(this.imageRotation){var g=this.imageRotationReference===WorldWind.RELATIVE_TO_GLOBE?e.camera.heading-this.imageRotation:-this.imageRotation;this.imageTransform.multiplyByRotation(0,0,1,g)}return this.imageTransform.multiplyByTranslation(-s,-o,0),this.imageTransform.multiplyByScale(a,l,1),this.imageBounds=c.boundingRectForUnitQuad(this.imageTransform),this.mustDrawLabel()&&(this.labelTexture=e.createTextTexture(this.label,this.activeAttributes.labelAttributes),h=this.labelTexture.imageWidth,u=this.labelTexture.imageHeight,f=this.activeAttributes.labelAttributes.scale*r,i=this.activeAttributes.labelAttributes.offset.offsetForSize(h,u),this.labelTransform.setTranslation(d.screenPoint[0]-i[0]*f,d.screenPoint[1]-i[1]*f,d.screenPoint[2]),this.labelTransform.setScale(h*f,u*f,1),this.labelBounds=c.boundingRectForUnitQuad(this.labelTransform)),this},d.prototype.selectLevelOfDetail=function(e,t,n){},d.prototype.determineActiveAttributes=function(e){this.highlighted&&this.highlightAttributes?this.activeAttributes=this.highlightAttributes:this.activeAttributes=this.attributes,this.activeAttributes&&this.activeAttributes.imageSource&&(this.activeTexture=e.gpuResourceCache.resourceForKey(this.activeAttributes.imageSource),this.activeTexture&&!this.updateImage||(this.activeTexture=e.gpuResourceCache.retrieveTexture(e.currentGlContext,this.activeAttributes.imageSource,null,this.activeAttributes.imageInitialWidth,this.activeAttributes.imageInitialHeight),this.updateImage=!1))},d.prototype.isVisible=function(e){return e.pickingMode?e.pickRectangle&&(this.imageBounds.intersects(e.pickRectangle)||this.mustDrawLabel()&&this.labelBounds.intersects(e.pickRectangle)||this.mustDrawLeaderLine(e)&&e.pickFrustum.intersectsSegment(this.groundPoint,this.placePoint)):this.imageBounds.intersects(e.viewport)||this.mustDrawLabel()&&this.labelBounds.intersects(e.viewport)||this.mustDrawLeaderLine(e)&&e.frustumInModelCoordinates.intersectsSegment(this.groundPoint,this.placePoint)},d.prototype.drawOrderedPlacemark=function(e){this.beginDrawing(e);try{this.doDrawOrderedPlacemark(e),e.pickingMode||this.drawBatchOrderedPlacemarks(e)}finally{this.endDrawing(e)}},d.prototype.drawBatchOrderedPlacemarks=function(e){for(var t;(t=e.peekOrderedRenderable())&&t.doDrawOrderedPlacemark;){e.popOrderedRenderable();try{t.doDrawOrderedPlacemark(e)}catch(e){i.logMessage(i.LEVEL_WARNING,"Placemark","drawBatchOrderedPlacemarks","Error occurred while rendering placemark using batching: "+e.message)}}},d.prototype.beginDrawing=function(e){var n,r=e.currentGlContext;e.findAndBindProgram(t),n=e.currentProgram,r.bindBuffer(r.ARRAY_BUFFER,e.unitQuadBuffer()),r.vertexAttribPointer(n.vertexTexCoordLocation,2,r.FLOAT,!1,0,0),r.enableVertexAttribArray(n.vertexPointLocation),r.enableVertexAttribArray(n.vertexTexCoordLocation),n.loadTextureUnit(r,r.TEXTURE0),n.loadModulateColor(r,e.pickingMode)},d.prototype.endDrawing=function(e){var t=e.currentGlContext,n=e.currentProgram;t.disableVertexAttribArray(n.vertexPointLocation),t.disableVertexAttribArray(n.vertexTexCoordLocation),t.bindBuffer(t.ARRAY_BUFFER,null),t.bindTexture(t.TEXTURE_2D,null)},d.prototype.doDrawOrderedPlacemark=function(e){var t,r=e.currentGlContext,i=e.currentProgram,s=!0;if(e.pickingMode&&(this.pickColor=e.uniquePickColor()),this.eyeDistanceScaling&&this.eyeDistance>this.eyeDistanceScalingLabelThreshold&&(this.targetVisibility=0),!e.pickingMode&&this.mustDrawLabel()&&this.currentVisibility!=this.targetVisibility){var o=(e.timestamp-e.previousRedrawTimestamp)/e.fadeTime;this.currentVisibility<this.targetVisibility?this.currentVisibility=Math.min(1,this.currentVisibility+o):this.currentVisibility=Math.max(0,this.currentVisibility-o),e.redrawRequested=!0}if(i.loadOpacity(r,e.pickingMode?1:this.layer.opacity),this.mustDrawLeaderLine(e)){this.leaderLinePoints||(this.leaderLinePoints=new Float32Array(6)),this.leaderLinePoints[0]=this.groundPoint[0],this.leaderLinePoints[1]=this.groundPoint[1],this.leaderLinePoints[2]=this.groundPoint[2],this.leaderLinePoints[3]=this.placePoint[0],this.leaderLinePoints[4]=this.placePoint[1],this.leaderLinePoints[5]=this.placePoint[2],this.leaderLineCacheKey||(this.leaderLineCacheKey=e.gpuResourceCache.generateCacheKey());var a=e.gpuResourceCache.resourceForKey(this.leaderLineCacheKey);a||(a=r.createBuffer(),e.gpuResourceCache.putResource(this.leaderLineCacheKey,a,4*this.leaderLinePoints.length)),i.loadTextureEnabled(r,!1),i.loadColor(r,e.pickingMode?this.pickColor:this.activeAttributes.leaderLineAttributes.outlineColor),d.matrix.copy(e.modelviewProjection),i.loadModelviewProjection(r,d.matrix),this.activeAttributes.leaderLineAttributes.depthTest||r.disable(r.DEPTH_TEST),r.lineWidth(this.activeAttributes.leaderLineAttributes.outlineWidth),r.bindBuffer(r.ARRAY_BUFFER,a),r.bufferData(r.ARRAY_BUFFER,this.leaderLinePoints,r.STATIC_DRAW),e.frameStatistics.incrementVboLoadCount(1),r.vertexAttribPointer(i.vertexPointLocation,3,r.FLOAT,!1,0,0),r.drawArrays(r.LINES,0,2)}this.activeAttributes.depthTest||(s=!1,r.disable(r.DEPTH_TEST)),r.bindBuffer(r.ARRAY_BUFFER,e.unitQuadBuffer3()),r.vertexAttribPointer(i.vertexPointLocation,3,r.FLOAT,!1,0,0),d.matrix.copy(e.screenProjection),d.matrix.multiplyMatrix(this.imageTransform),i.loadModelviewProjection(r,d.matrix),i.loadTextureEnabled(r,!0),e.pickingMode?i.loadColor(r,this.pickColor):i.loadColor(r,this.activeAttributes.imageColor),this.texCoordMatrix.setToIdentity(),this.activeTexture&&this.texCoordMatrix.multiplyByTextureTransform(this.activeTexture),i.loadTextureMatrix(r,this.texCoordMatrix),this.activeTexture?(t=this.activeTexture.bind(e),i.loadTextureEnabled(r,t)):i.loadTextureEnabled(r,!1),r.drawArrays(r.TRIANGLE_STRIP,0,4),this.mustDrawLabel()&&this.currentVisibility>0&&(i.loadOpacity(r,e.pickingMode?1:this.layer.opacity*this.currentVisibility),d.matrix.copy(e.screenProjection),d.matrix.multiplyMatrix(this.labelTransform),i.loadModelviewProjection(r,d.matrix),!e.pickingMode&&this.labelTexture?(this.texCoordMatrix.setToIdentity(),this.texCoordMatrix.multiplyByTextureTransform(this.labelTexture),i.loadTextureMatrix(r,this.texCoordMatrix),i.loadColor(r,n.WHITE),t=this.labelTexture.bind(e),i.loadTextureEnabled(r,t)):(i.loadTextureEnabled(r,!1),i.loadColor(r,this.pickColor)),this.activeAttributes.labelAttributes.depthTest?s||(s=!0,r.enable(r.DEPTH_TEST)):(s=!1,r.disable(r.DEPTH_TEST)),r.drawArrays(r.TRIANGLE_STRIP,0,4)),s||r.enable(r.DEPTH_TEST)},d.prototype.mustDrawLabel=function(){return this.label&&this.label.length>0&&this.activeAttributes.labelAttributes},d.prototype.mustDrawLeaderLine=function(e){return this.activeAttributes.drawLeaderLine&&this.activeAttributes.leaderLineAttributes&&(!e.pickingMode||this.enableLeaderLinePicking)},d.prototype.getReferencePosition=function(){return this.position},d.prototype.moveTo=function(e,t){this.position=t},d}),define("shapes/Polygon",["../shapes/AbstractShape","../error/ArgumentError","../shaders/BasicTextureProgram","../geom/BoundingBox","../util/Color","../util/ImageSource","../geom/Location","../util/Logger","../geom/Matrix","../pick/PickedObject","../geom/Position","../shapes/ShapeAttributes","../shapes/SurfacePolygon","../geom/Vec2","../geom/Vec3","../util/libtess"],function(e,t,n,r,i,s,o,a,l,h,u,c,d,f,p,m){"use strict";var g=function(n,r){if(!n)throw new t(a.logMessage(a.LEVEL_SEVERE,"Polygon","constructor","missingBoundaries"));e.call(this,r),n.length>0&&n[0].latitude&&(n=[n],this._boundariesSpecifiedSimply=!0),this._boundaries=n,this._textureCoordinates=null,this.referencePosition=this.determineReferencePosition(this._boundaries),this._extrude=!1,this.scratchPoint=new p(0,0,0)};return g.prototype=Object.create(e.prototype),Object.defineProperties(g.prototype,{boundaries:{get:function(){return this._boundariesSpecifiedSimply?this._boundaries[0]:this._boundaries},set:function(e){if(!e)throw new t(a.logMessage(a.LEVEL_SEVERE,"Polygon","boundaries","missingBoundaries"));e.length>0&&e[0].latitude&&(e=[e],this._boundariesSpecifiedSimply=!0),this._boundaries=e,this.referencePosition=this.determineReferencePosition(this._boundaries),this.reset()}},textureCoordinates:{get:function(){return this._textureCoordinates},set:function(e){this._textureCoordinates=e,this.reset()}},extrude:{get:function(){return this._extrude},set:function(e){this._extrude=e,this.reset()}}}),g.prototype.determineReferencePosition=function(e){return e.length>0&&e[0].length>2?e[0][0]:null},g.prototype.mustGenerateGeometry=function(e){return!this.currentData.boundaryPoints||(this.currentData.drawInterior!==this.activeAttributes.drawInterior||this.altitudeMode!==WorldWind.ABSOLUTE&&this.currentData.isExpired)},g.prototype.hasCapTexture=function(){return this.textureCoordinates&&this.capImageSource()},g.prototype.capImageSource=function(){return this.activeAttributes.imageSource?"string"==typeof this.activeAttributes.imageSource||this.activeAttributes.imageSource instanceof s?this.activeAttributes.imageSource:Array.isArray(this.activeAttributes.imageSource)&&this.activeAttributes.imageSource[0]&&("string"==typeof this.activeAttributes.imageSource[0]||this.activeAttributes.imageSource instanceof s)?this.activeAttributes.imageSource[0]:null:null},g.prototype.hasSideTextures=function(){return this.activeAttributes.imageSource&&Array.isArray(this.activeAttributes.imageSource)&&this.activeAttributes.imageSource.length>1},g.prototype.sideImageSource=function(e){if(0===e||2===this.activeAttributes.imageSource.length)return this.activeAttributes.imageSource[1];var t=this.activeAttributes.imageSource.length-1;return e=Math.min(e+1,t),this.activeAttributes.imageSource[e]},g.prototype.createSurfaceShape=function(){return new d(this.boundaries,null)},g.prototype.doMakeOrderedRenderable=function(e){if(!this.referencePosition)return null;if(!this.activeAttributes.drawInterior&&!this.activeAttributes.drawOutline)return null;if(!this.mustGenerateGeometry(e))return this;var t=this.currentData,n=t.referencePoint;e.surfacePointForMode(this.referencePosition.latitude,this.referencePosition.longitude,this.referencePosition.altitude,this._altitudeMode,n),t.transformationMatrix.setToTranslation(n[0],n[1],n[2]);for(var i=[],s=0;s<this._boundaries.length;s++)i[s]=this._boundaries[s].slice(0),i[s].push(this._boundaries[s][0]);var o=this.computeBoundaryPoints(e,i);if(this.activeAttributes.drawInterior){var a=this.tessellatePolygon(e,o);if(a){t.capTriangles=new Float32Array(a.length);for(var l=0,h=a.length;l<h;l++)t.capTriangles[l]=a[l]}}if(t.boundaryPoints=o,t.drawInterior=this.activeAttributes.drawInterior,this.resetExpiration(t),t.refreshBuffers=!0,t.extent||(t.extent=new r),1===o.length)t.extent.setToPoints(o[0]);else{var u=[];for(s=0;s<o.length;s++)for(var c=0;c<o[s].length;c++)u.push(o[s][c]);t.extent.setToPoints(u)}return t.extent.translate(t.referencePoint),this},g.prototype.computeBoundaryPoints=function(e,t){for(var n,r,i,s,o=Number.MAX_VALUE,a=e.eyePoint,l=[],h=this._extrude?6:3,u=new p(0,0,0),c=0;c<t.length;c++){n=(this._extrude?2:1)*t[c].length,l[c]=new Float32Array(3*n);for(var d=0,f=t[c].length;d<f;d++)r=t[c][d],e.surfacePointForMode(r.latitude,r.longitude,r.altitude,this.altitudeMode,u),s=u.distanceToSquared(a),s<o&&(o=s),u.subtract(this.currentData.referencePoint),i=h*d,l[c][i]=u[0],l[c][i+1]=u[1],l[c][i+2]=u[2],this._extrude&&(e.surfacePointForMode(r.latitude,r.longitude,0,WorldWind.CLAMP_TO_GROUND,u),s=u.distanceToSquared(a),s<o&&(o=s),u.subtract(this.currentData.referencePoint),l[c][i+3]=u[0],l[c][i+4]=u[1],l[c][i+5]=u[2])}return this.currentData.eyeDistance=0,l},g.prototype.tessellatePolygon=function(e,t){var n,r,i=[],s=0,o=this._extrude?6:3,l=this.hasCapTexture();this.polygonTessellator||(this.polygonTessellator=new libtess.GluTesselator,this.polygonTessellator.gluTessCallback(libtess.gluEnum.GLU_TESS_VERTEX_DATA,function(e,t){t[t.length]=e[0],t[t.length]=e[1],t[t.length]=e[2],l&&(t[t.length]=e[3],t[t.length]=e[4])}),this.polygonTessellator.gluTessCallback(libtess.gluEnum.GLU_TESS_COMBINE,function(e,t,n){var r=[e[0],e[1],e[2]];if(l)for(var i=3;i<=4;i++){for(var s=0,o=0;o<4;o++)n[o]>0&&(s+=n[o]*t[o][i]);r[i]=s}return r}),this.polygonTessellator.gluTessCallback(libtess.gluEnum.GLU_TESS_ERROR,function(e){s=e,a.logMessage(a.LEVEL_WARNING,"Polygon","tessellatePolygon","Tessellation error "+e+".")})),r=p.computeBufferNormal(t[0],o),r||(r=new p(0,0,0),e.globe.surfaceNormalAtLocation(this.referencePosition.latitude,this.referencePosition.longitude,r)),this.polygonTessellator.gluTessNormal(r[0],r[1],r[2]),this.currentData.capNormal=r,this.polygonTessellator.gluTessBeginPolygon(i);for(var h=0;h<t.length;h++){var u=0;this.polygonTessellator.gluTessBeginContour();for(var c=t[h],d=0;d<c.length;d+=o)n=[c[d],c[d+1],c[d+2]],l&&(u<this.textureCoordinates[h].length?(n[3]=this.textureCoordinates[h][u][0],n[4]=this.textureCoordinates[h][u][1]):(n[3]=this.textureCoordinates[h][0][0],n[4]=this.textureCoordinates[h][1][1]),++u),this.polygonTessellator.gluTessVertex(n,n);this.polygonTessellator.gluTessEndContour()}return this.polygonTessellator.gluTessEndPolygon(),0===s?i:null},g.prototype.mustDrawVerticals=function(e){return this._extrude&&this.activeAttributes.drawOutline&&this.activeAttributes.drawVerticals&&this.altitudeMode!==WorldWind.CLAMP_TO_GROUND},g.prototype.doRenderOrdered=function(e){var t,n=this.currentData;if(e.pickingMode&&(t=e.uniquePickColor()),this.activeAttributes.drawInterior&&n.capTriangles&&n.capTriangles.length>0&&this.drawCap(e,t),this._extrude&&this.activeAttributes.drawInterior&&this.drawSides(e,t),this.activeAttributes.drawOutline&&this.drawOutline(e,t),n.refreshBuffers=!1,e.pickingMode){var r=new h(t,this.pickDelegate?this.pickDelegate:this,null,this.layer,!1);e.resolvePick(r)}},g.prototype.drawCap=function(e,t){var n,r,i,s,o=e.currentGlContext,a=e.currentProgram,l=this.currentData,h=l.refreshBuffers,u=!!this.hasCapTexture(),c=this.activeAttributes.applyLighting,d=l.capTriangles.length/(u?5:3);a.loadTextureEnabled(o,!1),this.applyMvpMatrix(e),l.capVboCacheKey||(l.capVboCacheKey=e.gpuResourceCache.generateCacheKey()),n=e.gpuResourceCache.resourceForKey(l.capVboCacheKey),n||(n=o.createBuffer(),e.gpuResourceCache.putResource(l.capVboCacheKey,n,4*l.capTriangles.length),h=!0),o.bindBuffer(o.ARRAY_BUFFER,n),h&&(s=c?this.makeCapBufferWithNormals():l.capTriangles,o.bufferData(o.ARRAY_BUFFER,s,o.STATIC_DRAW),e.frameStatistics.incrementVboLoadCount(1)),r=this.activeAttributes.interiorColor,o.depthMask(r.alpha*this.layer.opacity>=1||e.pickingMode),a.loadColor(o,e.pickingMode?t:r),a.loadOpacity(o,e.pickingMode?1:this.layer.opacity),i=12+(u?8:0)+(c?12:0),u&&!e.pickingMode&&(this.activeTexture=e.gpuResourceCache.resourceForKey(this.capImageSource()),this.activeTexture||(this.activeTexture=e.gpuResourceCache.retrieveTexture(e.currentGlContext,this.capImageSource())),this.activeTexture&&this.activeTexture.bind(e)&&(o.enableVertexAttribArray(a.vertexTexCoordLocation),o.vertexAttribPointer(a.vertexTexCoordLocation,2,o.FLOAT,!1,i,12),this.scratchMatrix.setToIdentity(),this.scratchMatrix.multiplyByTextureTransform(this.activeTexture),a.loadTextureEnabled(o,!0),a.loadTextureUnit(o,o.TEXTURE0),a.loadTextureMatrix(o,this.scratchMatrix),a.loadModulateColor(o,e.pickingMode))),c&&!e.pickingMode&&(a.loadApplyLighting(o,!0),o.enableVertexAttribArray(a.normalVectorLocation),o.vertexAttribPointer(a.normalVectorLocation,3,o.FLOAT,!1,i,i-12)),o.vertexAttribPointer(a.vertexPointLocation,3,o.FLOAT,!1,i,0),o.drawArrays(o.TRIANGLES,0,d)},g.prototype.makeCapBufferWithNormals=function(){for(var e=this.currentData,t=e.capNormal,n=this.hasCapTexture()?5:3,r=n+3,i=e.capTriangles.length/n,s=e.capTriangles,o=new Float32Array(i*r),a=0,l=0;l<i;l++){for(var h=0;h<n;h++)o[a++]=s[l*n+h];o[a++]=t[0],o[a++]=t[1],o[a++]=t[2]}return o},g.prototype.drawSides=function(e,t){var n,r,i,s,o,a=e.currentGlContext,l=e.currentProgram,h=this.currentData,u=h.refreshBuffers,c=this.hasSideTextures(),d=this.activeAttributes.applyLighting,f=3+(c?2:0)+(d?3:0),p=4*f;o=0;for(var m=0;m<h.boundaryPoints.length;m++)o+=h.boundaryPoints[m].length/6-1;if(h.sidesVboCacheKey||(h.sidesVboCacheKey=e.gpuResourceCache.generateCacheKey()),n=e.gpuResourceCache.resourceForKey(h.sidesVboCacheKey),!n||u?(s=this.makeSidesBuffer(o),h.numSideVertices=s.length/f,n||(n=a.createBuffer()),e.gpuResourceCache.putResource(h.sidesVboCacheKey,n,4*s.length),a.bindBuffer(a.ARRAY_BUFFER,n),a.bufferData(a.ARRAY_BUFFER,s,a.STATIC_DRAW),e.frameStatistics.incrementVboLoadCount(1)):a.bindBuffer(a.ARRAY_BUFFER,n),r=this.activeAttributes.interiorColor,a.depthMask(r.alpha*this.layer.opacity>=1||e.pickingMode),l.loadColor(a,e.pickingMode?t:r),l.loadOpacity(a,e.pickingMode?1:this.layer.opacity),c&&!e.pickingMode){d?(l.loadApplyLighting(a,!0),a.enableVertexAttribArray(l.normalVectorLocation)):l.loadApplyLighting(a,!1);for(var g=0;g<o;g++){var b=this.sideImageSource(g),y=e.gpuResourceCache.resourceForKey(b),_=6*g*p;b&&!y&&(y=e.gpuResourceCache.retrieveTexture(e.currentGlContext,b)),i=y&&y.bind(e),i?(a.enableVertexAttribArray(l.vertexTexCoordLocation),a.vertexAttribPointer(l.vertexTexCoordLocation,2,a.FLOAT,!1,p,_+12),this.scratchMatrix.setToIdentity(),this.scratchMatrix.multiplyByTextureTransform(y),l.loadTextureEnabled(a,!0),l.loadTextureUnit(a,a.TEXTURE0),l.loadTextureMatrix(a,this.scratchMatrix)):(l.loadTextureEnabled(a,!1),a.disableVertexAttribArray(l.vertexTexCoordLocation)),d&&a.vertexAttribPointer(l.normalVectorLocation,3,a.FLOAT,!1,p,_+20),a.vertexAttribPointer(l.vertexPointLocation,3,a.FLOAT,!1,p,_),a.drawArrays(a.TRIANGLES,0,6)}}else l.loadTextureEnabled(a,!1),d&&!e.pickingMode?(l.loadApplyLighting(a,!0),a.enableVertexAttribArray(l.normalVectorLocation),a.vertexAttribPointer(l.normalVectorLocation,3,a.FLOAT,!1,p,p-12)):l.loadApplyLighting(a,!1),a.vertexAttribPointer(l.vertexPointLocation,3,a.FLOAT,!1,p,0),a.drawArrays(a.TRIANGLES,0,h.numSideVertices)},g.prototype.makeSidesBuffer=function(e){var t,n,r,i,s,o,a,l,h,u,c,d=this.currentData,m=this.hasSideTextures(),g=this.activeAttributes.applyLighting,b=3+(m?2:0)+(g?3:0);r=2*e*3*b,t=new Float32Array(r),n=0,i=new p(0,0,0),s=new p(0,0,0),o=new p(0,0,0),a=new p(0,0,0),m?(l=new f(0,1),h=new f(0,0),u=new f(1,1),c=new f(1,0)):l=h=u=c=null;for(var y=0;y<d.boundaryPoints.length;y++)for(var _,E=d.boundaryPoints[y],v=0;v<E.length-6;v+=6)i[0]=E[v],i[1]=E[v+1],i[2]=E[v+2],s[0]=E[v+3],s[1]=E[v+4],s[2]=E[v+5],o[0]=E[v+6],o[1]=E[v+7],o[2]=E[v+8],a[0]=E[v+9],a[1]=E[v+10],a[2]=E[v+11],_=g?p.computeTriangleNormal(i,s,o):null,this.addVertexToBuffer(i,l,_,t,n),n+=b,this.addVertexToBuffer(s,h,_,t,n),n+=b,this.addVertexToBuffer(o,u,_,t,n),n+=b,this.addVertexToBuffer(s,h,_,t,n),n+=b,this.addVertexToBuffer(a,c,_,t,n),n+=b,this.addVertexToBuffer(o,u,_,t,n),n+=b;return t},g.prototype.addVertexToBuffer=function(e,t,n,r,i){r[i++]=e[0],r[i++]=e[1],r[i++]=e[2],t&&(r[i++]=t[0],r[i++]=t[1]),n&&(r[i++]=n[0],r[i++]=n[1],r[i]=n[2])},g.prototype.drawOutline=function(e,t){var n,r,i,s,o,a=e.currentGlContext,l=e.currentProgram,h=this.currentData,u=h.refreshBuffers;l.loadTextureEnabled(a,!1),l.loadApplyLighting(a,!1),this.hasCapTexture()&&a.disableVertexAttribArray(l.vertexTexCoordLocation),this.activeAttributes.applyLighting&&a.disableVertexAttribArray(l.normalVectorLocation),h.boundaryVboCacheKeys||(this.currentData.boundaryVboCacheKeys=[]),this.applyMvpMatrixForOutline(e),l.loadTextureEnabled(a,!1),a.disableVertexAttribArray(l.vertexTexCoordLocation);for(var c=0;c<h.boundaryPoints.length;c++)n=h.boundaryPoints[c].length/3,h.boundaryVboCacheKeys[c]||(h.boundaryVboCacheKeys[c]=e.gpuResourceCache.generateCacheKey()),r=e.gpuResourceCache.resourceForKey(h.boundaryVboCacheKeys[c]),r||(r=a.createBuffer(),e.gpuResourceCache.putResource(h.boundaryVboCacheKeys[c],r,12*n),u=!0),a.bindBuffer(a.ARRAY_BUFFER,r),u&&(a.bufferData(a.ARRAY_BUFFER,h.boundaryPoints[c],a.STATIC_DRAW),e.frameStatistics.incrementVboLoadCount(1)),i=this.activeAttributes.outlineColor,a.depthMask(i.alpha*this.layer.opacity>=1||e.pickingMode),l.loadColor(a,e.pickingMode?t:i),l.loadOpacity(a,e.pickingMode?1:this.layer.opacity),a.lineWidth(this.activeAttributes.outlineWidth),this._extrude?(s=24,o=n/2):(s=12,o=n),a.vertexAttribPointer(l.vertexPointLocation,3,a.FLOAT,!1,s,0),a.drawArrays(a.LINE_STRIP,0,o),this.mustDrawVerticals(e)&&(a.vertexAttribPointer(l.vertexPointLocation,3,a.FLOAT,!1,0,0),a.drawArrays(a.LINES,0,n-2))},g.prototype.beginDrawing=function(e){
var t=e.currentGlContext;this.activeAttributes.drawInterior&&t.disable(t.CULL_FACE),e.findAndBindProgram(n),t.enableVertexAttribArray(e.currentProgram.vertexPointLocation),!e.pickMode&&this.activeAttributes.applyLighting&&e.currentProgram.loadModelviewInverse(t,e.modelviewNormalTransform)},g.prototype.endDrawing=function(e){var t=e.currentGlContext;t.disableVertexAttribArray(e.currentProgram.vertexPointLocation),t.disableVertexAttribArray(e.currentProgram.normalVectorLocation),t.depthMask(!0),t.lineWidth(1),t.enable(t.CULL_FACE)},g}),define("formats/geojson/GeoJSONParser",["../../error/ArgumentError","../../util/Color","./GeoJSONConstants","./GeoJSONCRS","./GeoJSONFeature","./GeoJSONFeatureCollection","./GeoJSONGeometry","./GeoJSONGeometryCollection","./GeoJSONGeometryLineString","./GeoJSONGeometryMultiLineString","./GeoJSONGeometryMultiPoint","./GeoJSONGeometryMultiPolygon","./GeoJSONGeometryPoint","./GeoJSONGeometryPolygon","../../geom/Location","../../util/Logger","../../shapes/Path","../../shapes/Placemark","../../shapes/PlacemarkAttributes","../../shapes/Polygon","../../geom/Position","../../util/proj4-src","../../layer/RenderableLayer","../../shapes/ShapeAttributes","../../shapes/SurfacePolygon","../../shapes/SurfacePolyline"],function(e,t,n,r,i,s,o,a,l,h,u,c,d,f,p,m,g,b,y,_,E,v,w,S,T,L){"use strict";var x=function(t){if(!t)throw new e(m.logMessage(m.LEVEL_SEVERE,"GeoJSON","constructor","missingDataSource"));this._dataSource=t,this._geoJSONObject=null,this._geoJSONType=null,this._crs=null,this._layer=null,this._parserCompletionCallback=null,this._shapeConfigurationCallback=this.defaultShapeConfigurationCallback,this.defaultPlacemarkAttributes=new y(null),this.defaultShapeAttributes=new S(null),this.setProj4jsAliases()};return Object.defineProperties(x.prototype,{dataSource:{get:function(){return this._dataSource}},geoJSONObject:{get:function(){return this._geoJSONObject}},geoJSONType:{get:function(){return this._geoJSONType}},crs:{get:function(){return this._crs}},layer:{get:function(){return this._layer}},parserCompletionCallback:{get:function(){return this._parserCompletionCallback}},shapeConfigurationCallback:{get:function(){return this._shapeConfigurationCallback}}}),x.prototype.load=function(e,t,n){e&&(this._parserCompletionCallback=e),t&&(this._shapeConfigurationCallback=t),this._layer=n||new w;var r=typeof this.dataSource;if("string"===r){var i=x.tryParseJSONString(this.dataSource);null!==i?this.handle(i):this.requestUrl(this.dataSource)}else"object"===r?this.handle(this.dataSource):m.logMessage(m.LEVEL_SEVERE,"GeoJSON","load","Unsupported data source type: "+r)},x.prototype.defaultShapeConfigurationCallback=function(e,t){var n={},r=t.name||t.Name||t.NAME;return r&&(n.name=r),e.isPointType()||e.isMultiPointType()?n.attributes=this.defaultPlacemarkAttributes:e.isLineStringType()||e.isMultiLineStringType()?n.attributes=this.defaultShapeAttributes:(e.isPolygonType()||e.isMultiPolygonType())&&(n.attributes=this.defaultShapeAttributes),n},x.prototype.requestUrl=function(e){var t=new XMLHttpRequest;t.open("GET",e,!0),t.responseType="text",t.onreadystatechange=function(){4===t.readyState&&(200===t.status?this.handle(x.tryParseJSONString(t.response)):m.log(m.LEVEL_WARNING,"GeoJSON retrieval failed ("+t.statusText+"): "+e))}.bind(this),t.onerror=function(){m.log(m.LEVEL_WARNING,"GeoJSON retrieval failed: "+e)},t.ontimeout=function(){m.log(m.LEVEL_WARNING,"GeoJSON retrieval timed out: "+e)},t.send(null)},x.prototype.handle=function(t){if(t||m.logMessage(m.LEVEL_SEVERE,"GeoJSON","handle","Invalid GeoJSON object"),this._geoJSONObject=t,"[object Array]"===Object.prototype.toString.call(this.geoJSONObject))throw new e(m.logMessage(m.LEVEL_SEVERE,"GeoJSON","handle","invalidGeoJSONObjectLength"));if(!this.geoJSONObject.hasOwnProperty(n.FIELD_TYPE))throw new e(m.logMessage(m.LEVEL_SEVERE,"GeoJSON","handle","missingGeoJSONType"));this.setGeoJSONType(),this.setGeoJSONCRS(),this._parserCompletionCallback&&"function"==typeof this._parserCompletionCallback&&this._parserCompletionCallback(this.layer)},x.prototype.setGeoJSONCRS=function(){if(this.geoJSONObject[n.FIELD_CRS]){this._crs=new r(this.geoJSONObject[n.FIELD_CRS][n.FIELD_TYPE],this.geoJSONObject[n.FIELD_CRS][n.FIELD_PROPERTIES]);var e=function(){this.addRenderablesForGeoJSON(this.layer)}.bind(this);this.crs.setCRSString(e)}else this.addRenderablesForGeoJSON(this.layer)},x.prototype.addRenderablesForGeoJSON=function(t){if(!t)throw new e(m.logMessage(m.LEVEL_SEVERE,"GeoJSON","addRenderablesForGeoJSON","missingLayer"));switch(this.geoJSONType){case n.TYPE_FEATURE:var r=new i(this.geoJSONObject[n.FIELD_GEOMETRY],this.geoJSONObject[n.FIELD_PROPERTIES],this.geoJSONObject[n.FIELD_ID],this.geoJSONObject[n.FIELD_BBOX]);this.addRenderablesForFeature(t,r);break;case n.TYPE_FEATURE_COLLECTION:var o=new s(this.geoJSONObject[n.FIELD_FEATURES],this.geoJSONObject[n.FIELD_BBOX]);this.addRenderablesForFeatureCollection(t,o);break;case n.TYPE_GEOMETRY_COLLECTION:var l=new a(this.geoJSONObject[n.FIELD_GEOMETRIES],this.geoJSONObject[n.FIELD_BBOX]);this.addRenderablesForGeometryCollection(t,l,null);break;default:this.addRenderablesForGeometry(t,this.geoJSONObject,null)}},x.prototype.addRenderablesForGeometry=function(t,r,i){if(!t)throw new e(m.logMessage(m.LEVEL_SEVERE,"GeoJSON","addRenderablesForGeometry","missingLayer"));if(!r)throw new e(m.logMessage(m.LEVEL_SEVERE,"GeoJSON","addRenderablesForGeometry","missingGeometry"));switch(r[n.FIELD_TYPE]){case n.TYPE_POINT:var s=new d(r[n.FIELD_COORDINATES],r[n.FIELD_TYPE],r[n.FIELD_BBOX]);this.addRenderablesForPoint(t,s,i||null);break;case n.TYPE_MULTI_POINT:var o=new u(r[n.FIELD_COORDINATES],r[n.FIELD_TYPE],r[n.FIELD_BBOX]);this.addRenderablesForMultiPoint(t,o,i||null);break;case n.TYPE_LINE_STRING:var a=new l(r[n.FIELD_COORDINATES],r[n.FIELD_TYPE],r[n.FIELD_BBOX]);this.addRenderablesForLineString(t,a,i||null);break;case n.TYPE_MULTI_LINE_STRING:var p=new h(r[n.FIELD_COORDINATES],r[n.FIELD_TYPE],r[n.FIELD_BBOX]);this.addRenderablesForMultiLineString(t,p,i||null);break;case n.TYPE_POLYGON:var g=new f(r[n.FIELD_COORDINATES],r[n.FIELD_TYPE],r[n.FIELD_BBOX]);this.addRenderablesForPolygon(t,g,i||null);break;case n.TYPE_MULTI_POLYGON:var b=new c(r[n.FIELD_COORDINATES],r[n.FIELD_TYPE],r[n.FIELD_BBOX]);this.addRenderablesForMultiPolygon(t,b,i||null)}},x.prototype.addRenderablesForPoint=function(t,n,r){if(!t)throw new e(m.logMessage(m.LEVEL_SEVERE,"GeoJSON","addRenderablesForPoint","missingLayer"));if(!n)throw new e(m.logMessage(m.LEVEL_SEVERE,"GeoJSON","addRenderablesForPoint","missingGeometry"));var i=this.shapeConfigurationCallback(n,r);if(!this.crs||this.crs.isCRSSupported()){var s=n.coordinates[0],o=n.coordinates[1],a=n.coordinates[2]?n.coordinates[2]:0,l=this.getReprojectedIfRequired(o,s,this.crs),h=new E(l[1],l[0],a),u=new b(h,!1,i&&i.attributes?i.attributes:null);i&&i.altitudeMode?u.altitudeMode=i.altitudeMode:u.altitudeMode=WorldWind.ABSOLUTE,i&&i.name&&(u.label=i.name),i&&i.eyeDistanceScaling&&(u.eyeDistanceScaling=i.eyeDistanceScaling),i&&i.eyeDistanceScalingThreshold&&(u.eyeDistanceScalingThreshold=i.eyeDistanceScalingThreshold),i&&i.imageRotation&&(u.imageRotation=i.imageRotation),i&&i.imageRotationReference&&(u.imageRotationReference=i.imageRotationReference),i&&i.highlightAttributes&&(u.highlightAttributes=i.highlightAttributes),i&&i.pickDelegate&&(u.pickDelegate=i.pickDelegate),i&&i.userProperties&&(u.userProperties=i.userProperties),t.addRenderable(u)}},x.prototype.addRenderablesForMultiPoint=function(t,n,r){if(!t)throw new e(m.logMessage(m.LEVEL_SEVERE,"GeoJSON","addRenderablesForMultiPoint","missingLayer"));if(!n)throw new e(m.logMessage(m.LEVEL_SEVERE,"GeoJSON","addRenderablesForMultiPoint","missingGeometry"));var i=this.shapeConfigurationCallback(n,r);if(!this.crs||this.crs.isCRSSupported())for(var s=0,o=n.coordinates.length;s<o;s+=1){var a=n.coordinates[s][0],l=n.coordinates[s][1],h=n.coordinates[s][2]?n.coordinates[s][2]:0,u=this.getReprojectedIfRequired(l,a,this.crs),c=new E(u[1],u[0],h),d=new b(c,!1,i&&i.attributes?i.attributes:null);i&&i.altitudeMode?d.altitudeMode=i.altitudeMode:d.altitudeMode=WorldWind.ABSOLUTE,i&&i.name&&(d.label=i.name),i&&i.eyeDistanceScaling&&(d.eyeDistanceScaling=i.eyeDistanceScaling),i&&i.eyeDistanceScalingThreshold&&(d.eyeDistanceScalingThreshold=i.eyeDistanceScalingThreshold),i&&i.imageRotation&&(d.imageRotation=i.imageRotation),i&&i.imageRotationReference&&(d.imageRotationReference=i.imageRotationReference),i&&i.highlightAttributes&&(d.highlightAttributes=i.highlightAttributes),i&&i.pickDelegate&&(d.pickDelegate=i.pickDelegate),i&&i.userProperties&&(d.userProperties=i.userProperties),t.addRenderable(d)}},x.prototype.addRenderablesForLineString=function(t,n,r){if(!t)throw new e(m.logMessage(m.LEVEL_SEVERE,"GeoJSON","addRenderablesForLineString","missingLayer"));if(!n)throw new e(m.logMessage(m.LEVEL_SEVERE,"GeoJSON","addRenderablesForLineString","missingGeometry"));var i=this.shapeConfigurationCallback(n,r);if(!this.crs||this.crs.isCRSSupported()){for(var s=[],o=0,a=n.coordinates;o<a.length;o++){var l=a[o][0],h=a[o][1],u=a[o][2]?a[o][2]:0,c=this.getReprojectedIfRequired(h,l,this.crs),d=new E(c[1],c[0],u);s.push(d)}var f;i&&i.altitudeMode===WorldWind.CLAMP_TO_GROUND?f=new L(s,i&&i.attributes?i.attributes:null):(f=new g(s,i&&i.attributes?i.attributes:null),i&&i.altitudeMode?f.altitudeMode=i.altitudeMode:f.altitudeMode=WorldWind.ABSOLUTE),i&&i.highlightAttributes&&(f.highlightAttributes=i.highlightAttributes),i&&i.pickDelegate&&(f.pickDelegate=i.pickDelegate),i&&i.userProperties&&(f.userProperties=i.userProperties),t.addRenderable(f)}},x.prototype.addRenderablesForMultiLineString=function(t,n,r){if(!t)throw new e(m.logMessage(m.LEVEL_SEVERE,"GeoJSON","addRenderablesForMultiLineString","missingLayer"));if(!n)throw new e(m.logMessage(m.LEVEL_SEVERE,"GeoJSON","addRenderablesForMultiLineString","missingGeometry"));var i=this.shapeConfigurationCallback(n,r);if(!this.crs||this.crs.isCRSSupported())for(var s=0,o=n.coordinates;s<o.length;s++){for(var a=[],l=0,h=o[s];l<h.length;l++){var u=h[l][0],c=h[l][1],d=this.getReprojectedIfRequired(c,u,this.crs),f=new p(d[1],d[0]);a.push(f)}var g;g=new L(a,i&&i.attributes?i.attributes:null),i.highlightAttributes&&(g.highlightAttributes=i.highlightAttributes),i&&i.pickDelegate&&(g.pickDelegate=i.pickDelegate),i&&i.userProperties&&(g.userProperties=i.userProperties),t.addRenderable(g)}},x.prototype.addRenderablesForPolygon=function(t,n,r){if(!t)throw new e(m.logMessage(m.LEVEL_SEVERE,"GeoJSON","addRenderablesForPolygon","missingLayer"));if(!n)throw new e(m.logMessage(m.LEVEL_SEVERE,"GeoJSON","addRenderablesForPolygon","missingGeometry"));var i=this.shapeConfigurationCallback(n,r);if(!this.crs||this.crs.isCRSSupported()){for(var s=[],o=0,a=n.coordinates;o<a.length;o++){for(var l=[],h=0,u=a[o];h<u.length;h++){var c=u[h][0],d=u[h][1],f=u[h][2]?u[h][2]:0,p=this.getReprojectedIfRequired(d,c,this.crs),g=new E(p[1],p[0],f);l.push(g)}s.push(l)}var b;i&&i.altitudeMode===WorldWind.CLAMP_TO_GROUND?b=new T(s,i&&i.attributes?i.attributes:null):(b=new _(s,i&&i.attributes?i.attributes:null),i&&i.altitudeMode?b.altitudeMode=i.altitudeMode:b.altitudeMode=WorldWind.ABSOLUTE),i&&i.highlightAttributes&&(b.highlightAttributes=i.highlightAttributes),i&&i.pickDelegate&&(b.pickDelegate=i.pickDelegate),i&&i.userProperties&&(b.userProperties=i.userProperties),t.addRenderable(b)}},x.prototype.addRenderablesForMultiPolygon=function(t,n,r){if(!t)throw new e(m.logMessage(m.LEVEL_SEVERE,"GeoJSON","addRenderablesForMultiPolygon","missingLayer"));if(!n)throw new e(m.logMessage(m.LEVEL_SEVERE,"GeoJSON","addRenderablesForMultiPolygon","missingGeometry"));var i=this.shapeConfigurationCallback(n,r);if(!this.crs||this.crs.isCRSSupported())for(var s=0,o=n.coordinates;s<o.length;s++){for(var a=[],l=0;l<o[s].length;l++){for(var h=[],u=0,c=o[s][l];u<c.length;u++){var d=c[u][0],f=c[u][1],g=this.getReprojectedIfRequired(f,d,this.crs),b=new p(g[1],g[0]);h.push(b)}a.push(h)}var y;y=new T(a,i&&i.attributes?i.attributes:null),i.highlightAttributes&&(y.highlightAttributes=i.highlightAttributes),i&&i.pickDelegate&&(y.pickDelegate=i.pickDelegate),i&&i.userProperties&&(y.userProperties=i.userProperties),t.addRenderable(y)}},x.prototype.addRenderablesForGeometryCollection=function(t,r,i){if(!t)throw new e(m.logMessage(m.LEVEL_SEVERE,"GeoJSON","addRenderablesForGeometryCollection","missingLayer"));if(!r)throw new e(m.logMessage(m.LEVEL_SEVERE,"GeoJSON","addRenderablesForGeometryCollection","missingGeometryCollection"));for(var s=0,o=r.geometries;s<o.length;s++)o[s].hasOwnProperty(n.FIELD_TYPE)&&this.addRenderablesForGeometry(t,o[s],i)},x.prototype.addRenderablesForFeature=function(t,r){if(!t)throw new e(m.logMessage(m.LEVEL_SEVERE,"GeoJSON","addRenderablesForFeature","missingLayer"));if(!r)throw new e(m.logMessage(m.LEVEL_SEVERE,"GeoJSON","addRenderablesForFeature","missingFeature"));if(r.geometry.type===n.TYPE_GEOMETRY_COLLECTION){var i=new a(r.geometry.geometries,r.bbox);this.addRenderablesForGeometryCollection(t,i,r.properties)}else this.addRenderablesForGeometry(t,r.geometry,r.properties)},x.prototype.addRenderablesForFeatureCollection=function(t,r){if(!t)throw new e(m.logMessage(m.LEVEL_SEVERE,"GeoJSON","addRenderablesForFeatureCollection","missingLayer"));if(!r)throw new e(m.logMessage(m.LEVEL_SEVERE,"GeoJSON","addRenderablesForFeatureCollection","missingFeatureCollection"));if(r.features.length>0)for(var s=0;s<r.features.length;s++){var o=new i(r.features[s][n.FIELD_GEOMETRY],r.features[s][n.FIELD_PROPERTIES],r.features[s][n.FIELD_ID],r.features[s][n.FIELD_BBOX]);this.addRenderablesForFeature(t,o)}},x.prototype.setGeoJSONType=function(){switch(this.geoJSONObject[n.FIELD_TYPE]){case n.TYPE_POINT:this._geoJSONType=n.TYPE_POINT;break;case n.TYPE_MULTI_POINT:this._geoJSONType=n.TYPE_MULTI_POINT;break;case n.TYPE_LINE_STRING:this._geoJSONType=n.TYPE_LINE_STRING;break;case n.TYPE_MULTI_LINE_STRING:this._geoJSONType=n.TYPE_MULTI_LINE_STRING;break;case n.TYPE_POLYGON:this._geoJSONType=n.TYPE_POLYGON;break;case n.TYPE_MULTI_POLYGON:this._geoJSONType=n.TYPE_MULTI_POLYGON;break;case n.TYPE_GEOMETRY_COLLECTION:this._geoJSONType=n.TYPE_GEOMETRY_COLLECTION;break;case n.TYPE_FEATURE:this._geoJSONType=n.TYPE_FEATURE;break;case n.TYPE_FEATURE_COLLECTION:this._geoJSONType=n.TYPE_FEATURE_COLLECTION;break;default:throw new e(m.logMessage(m.LEVEL_SEVERE,"GeoJSON","setGeoJSONType","invalidGeoJSONType"))}},x.prototype.getReprojectedIfRequired=function(t,r,i){if(!t&&0!==t)throw new e(m.logMessage(m.LEVEL_SEVERE,"GeoJSON","getReprojectedIfRequired","missingLatitude"));if(!r&&0!==r)throw new e(m.logMessage(m.LEVEL_SEVERE,"GeoJSON","getReprojectedIfRequired","missingLongitude"));return!i||i.isDefault()?[r,t]:v(i.projectionString,n.EPSG4326_CRS,[r,t])},x.prototype.setProj4jsAliases=function(){v.defs([["urn:ogc:def:crs:EPSG::4326",v.defs("EPSG:4326")],["urn:ogc:def:crs:OGC:1.3:CRS84",v.defs("EPSG:4326")],["urn:ogc:def:crs:EPSG::3857",v.defs("EPSG:3857")]])},x.tryParseJSONString=function(e){try{return JSON.parse(e)}catch(e){return null}},x}),define("projections/ProjectionEquirectangular",["../geom/Angle","../error/ArgumentError","../projections/GeographicProjection","../util/Logger","../geom/Vec3"],function(e,t,n,r,i){"use strict";var s=function(){n.call(this,"Equirectangular",!0,null)};return s.prototype=Object.create(n.prototype),Object.defineProperties(s.prototype,{stateKey:{get:function(){return"projection equirectangular "}}}),s.prototype.geographicToCartesian=function(n,i,s,o,a,l){if(!n)throw new t(r.logMessage(r.LEVEL_SEVERE,"ProjectionEquirectangular","geographicToCartesian","missingGlobe"));if(!l)throw new t(r.logMessage(r.LEVEL_SEVERE,"ProjectionEquirectangular","geographicToCartesian","missingResult"));return l[0]=n.equatorialRadius*s*e.DEGREES_TO_RADIANS+(a?a[0]:0),l[1]=n.equatorialRadius*i*e.DEGREES_TO_RADIANS,l[2]=o,l},s.prototype.geographicToCartesianGrid=function(n,s,o,a,l,h,u,c){if(!n)throw new t(r.logMessage(r.LEVEL_SEVERE,"ProjectionEquirectangular","geographicToCartesianGrid","missingGlobe"));if(!s)throw new t(r.logMessage(r.LEVEL_SEVERE,"ProjectionEquirectangular","geographicToCartesianGrid","missingSector"));if(!l||l.length<o*a)throw new t(r.logMessage(r.LEVEL_SEVERE,"ProjectionEquirectangular","geographicToCartesianGrid","The specified elevations array is null, undefined or insufficient length"));if(!c)throw new t(r.logMessage(r.LEVEL_SEVERE,"ProjectionEquirectangular","geographicToCartesianGrid","missingResult"));var d,f,p,m,g,b=n.equatorialRadius,y=s.minLatitude*e.DEGREES_TO_RADIANS,_=s.maxLatitude*e.DEGREES_TO_RADIANS,E=s.minLongitude*e.DEGREES_TO_RADIANS,v=s.maxLongitude*e.DEGREES_TO_RADIANS,w=(_-y)/(o>1?o-1:1),S=(v-E)/(a>1?a-1:1),T=h||new i(0,0,0),L=u?u[0]:0,x=0,R=0;for(d=0,p=y;d<o;d++,p+=w)for(d===o-1&&(p=_),g=b*p-T[1],f=0,m=E;f<a;f++,m+=S)f===a-1&&(m=v),c[R++]=b*m-T[0]+L,c[R++]=g,c[R++]=l[x++]-T[2];return c},s.prototype.cartesianToGeographic=function(n,i,s,o,a,l){if(!n)throw new t(r.logMessage(r.LEVEL_SEVERE,"ProjectionEquirectangular","cartesianToGeographic","missingGlobe"));if(!l)throw new t(r.logMessage(r.LEVEL_SEVERE,"ProjectionEquirectangular","cartesianToGeographic","missingResult"));return l.latitude=s/n.equatorialRadius*e.RADIANS_TO_DEGREES,l.longitude=(i-(a?a[0]:0))/n.equatorialRadius*e.RADIANS_TO_DEGREES,l.altitude=o,l},s}),define("globe/Globe2D",["../globe/ElevationModel","../globe/Globe","../projections/ProjectionEquirectangular"],function(e,t,n){"use strict";var r=function(){t.call(this,new e,new n)};return r.prototype=Object.create(t.prototype),r}),define("util/GoToAnimator",["../geom/Location","../util/Logger","../geom/LookAt","../geom/Position","../geom/Vec3"],function(e,t,n,r,i){"use strict";var s=function(e){if(!e)throw new ArgumentError(t.logMessage(t.LEVEL_SEVERE,"GoToAnimator","constructor","missingWorldWindow"));this.wwd=e,this.animationFrequency=20,this.travelTime=3e3,this.cancelled=!1,this.lookAt=new n};return s.prototype.cancel=function(){this.cancelled=!0},s.prototype.goTo=function(n,s){if(!n)throw new ArgumentError(t.logMessage(t.LEVEL_SEVERE,"GoToAnimator","goTo","missingPosition"));this.completionCallback=s,this.cancelled=!1,this.wwd.cameraAsLookAt(this.lookAt),this.targetPosition=new r(n.latitude,n.longitude,n.altitude||this.lookAt.range),this.startPosition=new r(this.lookAt.position.latitude,this.lookAt.position.longitude,this.lookAt.range),this.startTime=Date.now();var o,a=this.travelTime,l=e.greatCircleDistance(this.startPosition,this.targetPosition),h=this.wwd.globe.computePointFromLocation(this.startPosition.latitude,this.startPosition.longitude,new i(0,0,0)),u=this.wwd.globe.computePointFromLocation(this.targetPosition.latitude,this.targetPosition.longitude,new i(0,0,0));this.maxAltitude=h.distanceTo(u);var c=this.wwd.pixelSizeAtDistance(this.startPosition.altitude)*this.wwd.canvas.clientWidth/this.wwd.globe.equatorialRadius;l<=2*c&&(this.maxAltitude=this.startPosition.altitude),this.maxAltitudeReachedTime=this.maxAltitude<=this.lookAt.range?Date.now():null,this.maxAltitude>this.startPosition.altitude?(o=Math.max(0,this.maxAltitude-this.startPosition.altitude),o+=Math.abs(this.targetPosition.altitude-this.maxAltitude)):o=Math.abs(this.targetPosition.altitude-this.startPosition.altitude);var d=Math.max(l,o/this.wwd.globe.equatorialRadius);if(0!==d){d<2*c&&(a=Math.min(d/c*this.travelTime,this.travelTime)),a=Math.max(1,a),this.panVelocity=l/a,this.rangeVelocity=o/a;var f=this,p=function(){if(f.cancelled)return void(f.completionCallback&&f.completionCallback(f));f.update()?setTimeout(p,f.animationFrequency):f.completionCallback&&f.completionCallback(f)};setTimeout(p,this.animationFrequency)}},s.prototype.update=function(){var e=new r(this.lookAt.position.latitude,this.lookAt.position.longitude,this.lookAt.range),t=this.updateRange(e);return t=this.updateLocation(e)||t,this.wwd.redraw(),t},s.prototype.updateRange=function(e){var t,n,r=!1;return this.maxAltitudeReachedTime?(n=Date.now()-this.maxAltitudeReachedTime,this.maxAltitude>this.targetPosition.altitude?(t=this.maxAltitude-this.rangeVelocity*n,t=Math.max(t,this.targetPosition.altitude)):(t=this.maxAltitude+this.rangeVelocity*n,t=Math.min(t,this.targetPosition.altitude)),this.lookAt.range=t,r=Math.abs(this.lookAt.range-this.targetPosition.altitude)>1):(n=Date.now()-this.startTime,t=Math.min(this.startPosition.altitude+this.rangeVelocity*n,this.maxAltitude),Math.abs(this.lookAt.range-t)<1&&(this.maxAltitudeReachedTime=Date.now()),this.lookAt.range=t,r=!0),this.wwd.cameraFromLookAt(this.lookAt),r},s.prototype.updateLocation=function(t){var n=Date.now()-this.startTime,r=e.greatCircleDistance(this.startPosition,t),i=e.greatCircleDistance(t,this.targetPosition),s=e.greatCircleAzimuth(t,this.targetPosition),o=this.panVelocity*n,a=Math.min(o-r,i),l=e.greatCircleLocation(t,s,a,new e(0,0)),h=!1;return this.lookAt.position.latitude=l.latitude,this.lookAt.position.longitude=l.longitude,this.wwd.cameraFromLookAt(this.lookAt),a<1/this.wwd.globe.equatorialRadius&&(h=!0),!h},s}),define("layer/heatmap/HeatMapTile",[],function(){var e=function(e,t){this._data=e,this._sector=t.sector,this._canvas=this.createCanvas(t.width,t.height),this._width=t.width,this._height=t.height,this._intensityGradient=t.intensityGradient,this._radius=t.radius,this._incrementPerIntensity=t.incrementPerIntensity};return e.prototype.url=function(){return this.draw().toDataURL()},e.prototype.canvas=function(){return this.draw()},e.prototype.draw=function(){var e=[];for(var t in this._intensityGradient)this._intensityGradient.hasOwnProperty(t)&&e.push({shape:this.shape(t),min:t});for(var n,r=this._canvas.getContext("2d"),i=null,s=0;s<this._data.length;s++){var o=this._data[s];n=o.measure*this._incrementPerIntensity,r.globalAlpha=n,e.forEach(function(e){n>e.min&&(i=e.shape)}),r.drawImage(i,this.longitudeInSector(o,this._sector,this._width)-i.width/2,this._height-this.latitudeInSector(o,this._sector,this._height)-i.height/2)}return this._canvas},e.prototype.createCanvas=function(e,t){var n=document.createElement("canvas");return n.width=e,n.height=t,n},e.prototype.shape=function(e){var t=this.createCanvas(2*this._radius,2*this._radius),n=t.getContext("2d"),r=n.createRadialGradient(this._radius,this._radius,0,this._radius,this._radius,this._radius);return r.addColorStop(0,"rgba(0,0,0,"+e+")"),r.addColorStop(1,"rgba(0,0,0,0)"),n.beginPath(),n.arc(this._radius,this._radius,this._radius,0,2*Math.PI,!0),n.fillStyle=r,n.fill(),n.closePath(),t},e.prototype.latitudeInSector=function(e,t,n){var r=t.maxLatitude-t.minLatitude,i=e.latitude-t.minLatitude;return Math.ceil(i/r*n)},e.prototype.longitudeInSector=function(e,t,n){var r=t.maxLongitude-t.minLongitude,i=e.longitude-t.minLongitude;return Math.ceil(i/r*n)},e}),define("layer/heatmap/HeatMapColoredTile",["./HeatMapTile"],function(e){var t=function(t,n){e.call(this,t,n),this._extendedWidth=n.extendedWidth,this._extendedHeight=n.extendedHeight,this._gradient=this.gradient(n.intensityGradient)};return t.prototype=Object.create(e.prototype),t.prototype.draw=function(){var t=e.prototype.draw.call(this),n=t.getContext("2d"),r=0,i=0,s=this._width,o=this._height;this._extendedHeight&&(r=this._extendedHeight,o=this._height-2*this._extendedHeight),this._extendedWidth&&(i=this._extendedWidth,s=this._width-2*this._extendedWidth);var a=n.getImageData(r,i,s,o);return this.colorize(a.data,this._gradient),n.putImageData(a,r,i),t},t.prototype.gradient=function(e){var t=this.createCanvas(1,256),n=t.getContext("2d"),r=n.createLinearGradient(0,0,0,256);for(var i in e)r.addColorStop(+i,e[i]);return n.fillStyle=r,n.fillRect(0,0,1,256),n.getImageData(0,0,1,256).data},t.prototype.colorize=function(e,t){for(var n,r=0,i=e.length;r<i;r+=4)(n=4*e[r+3])&&(e[r]=t[n],e[r+1]=t[n+1],e[r+2]=t[n+2],e[r+3]=255)},t}),define("layer/heatmap/HeatMapIntervalType",[],function(){"use strict";return{CONTINUOUS:0,QUANTILES:1}}),define("geom/MeasuredLocation",["./Angle","./Location"],function(e,t){"use strict";var n=function(e,n,r){t.call(this,e,n),this.measure=r};return n.prototype=Object.create(t.prototype),n.fromRadians=function(t,r,i){return new n(t*e.RADIANS_TO_DEGREES,r*e.RADIANS_TO_DEGREES,i)},n.prototype.copy=function(e){return t.prototype.copy.call(this,e),this.measure=e.measure,this},n.prototype.set=function(e,n,r){return t.prototype.set.call(this,e,n),this.measure=r,this},n.prototype.equals=function(e){return t.prototype.equals.call(this,e)&&this.measure===e.measure},n}),define("layer/heatmap/HeatMapLayer",["../../error/ArgumentError","./HeatMapColoredTile","./HeatMapIntervalType","./HeatMapTile","../../util/ImageSource","../../geom/Location","../../util/Logger","../../geom/MeasuredLocation","../TiledImageLayer","../../geom/Sector","../../util/WWUtil"],function(e,t,n,r,i,s,o,a,l,h,u){"use strict";var c=function(e,t,r){this.tileWidth=256,this.tileHeight=256,l.call(this,e,new h(-90,90,-180,180),new s(45,45),r||18,"image/png","HeatMap"+u.guid(),this.tileWidth,this.tileHeight);for(var i={},o=-90;o<=90;o++){i[o]={};for(var a=-180;a<=180;a++)i[o][a]=[]}var c,d,f=Number.MIN_VALUE;t.forEach(function(e){c=Math.floor(e.latitude),d=Math.floor(e.longitude),i[c][d].push(e),e.measure>f&&(f=e.measure)}),this._data=i,this._measuredLocations=t,this._intervalType=n.CONTINUOUS,this._scale=["blue","cyan","lime","yellow","red"],this._radius=12.5,this._incrementPerIntensity=1/f,this.setGradient(t)};return c.prototype=Object.create(l.prototype),Object.defineProperties(c.prototype,{intervalType:{get:function(){return this._intervalType},set:function(e){this._intervalType=e,this.setGradient()}},scale:{get:function(){return this._scale},set:function(e){this._scale=e,this.setGradient()}},gradient:{get:function(){return this._gradient}},radius:{get:function(){return this._radius},set:function(e){this._radius=e}}}),c.prototype.filterGeographically=function(e,t){var n=Math.floor(t.minLatitude),r=Math.floor(t.maxLatitude),i=Math.floor(t.minLongitude),s=Math.floor(t.maxLongitude),o=0,a=0;n<=-90&&(n=-90),r>=90&&(r=90),i<=-180&&(o=Math.abs(i- -180),i=-180),s>=180&&(a=Math.abs(s-180),s=180);var l=[];if(this.gatherGeographical(e,l,t,n,r,i,s),0!==o){var u=new h(n,r,180-o,180);this.gatherGeographical(e,l,u,n,r,180-o,180,-360)}if(0!==a){var c=new h(n,r,-180,-180+a);this.gatherGeographical(e,l,c,n,r,-180,-180+a,360)}return l},c.prototype.gatherGeographical=function(e,t,n,r,i,s,o,l){var h,u;for(h=r;h<=i;h++)for(u=s;u<=o;u++)e[h][u].forEach(function(e){n.containsLocation(e.latitude,e.longitude)&&(l?t.push(new a(e.latitude,l+e.longitude,e.measure)):t.push(e))})},c.prototype.setGradient=function(){var e=this.intervalType,t=this.scale,r={};if(e===n.CONTINUOUS)t.forEach(function(e,n){r[n/t.length]=e});else if(e===n.QUANTILES){var i=this._measuredLocations;i.sort(function(e,t){return e.measure<t.measure?-1:e.measure>t.measure?1:0});var s=i[i.length-1].measure;i.length>=t.length?t.forEach(function(e,n){0===n?r[0]=e:r[i[Math.floor(n/t.length*i.length)].measure/s]=e}):t.forEach(function(e,n){r[n/t.length]=e})}this._gradient=r},c.prototype.retrieveTileImage=function(e,t,n){if(this.currentRetrievals.indexOf(t.imagePath)<0){if(this.absentResourceList.isResourceAbsent(t.imagePath))return;var r=t.imagePath,i=e.gpuResourceCache,s=this,o=this.radius,a=this.calculateExtendedSector(t.sector,o/this.tileWidth*2,o/this.tileHeight*2),l=Math.ceil(a.extensionFactorWidth*this.tileWidth),h=Math.ceil(a.extensionFactorHeight*this.tileHeight),u=this.filterGeographically(this._data,a.sector),c=this.createHeatMapTile(u,{sector:a.sector,width:this.tileWidth+2*l,height:this.tileHeight+2*h,radius:o,intensityGradient:this.gradient,incrementPerIntensity:this._incrementPerIntensity,extendedWidth:l,extendedHeight:h}).canvas(),d=document.createElement("canvas");d.height=this.tileHeight,d.width=this.tileWidth,d.getContext("2d").putImageData(c.getContext("2d").getImageData(l,h,this.tileWidth,this.tileHeight),0,0);var f=s.createTexture(e,t,d);if(s.removeFromCurrentRetrievals(r),f&&(i.putResource(r,f,f.size),s.currentTilesInvalid=!0,s.absentResourceList.unmarkResourceAbsent(r),!n)){var p=document.createEvent("Event");p.initEvent(WorldWind.REDRAW_EVENT_TYPE,!0,!0),window.dispatchEvent(p)}}},c.prototype.calculateExtendedSector=function(e,t,n){var r=(e.maxLatitude-e.minLatitude)*n,i=(e.maxLongitude-e.minLongitude)*t;return{sector:new h(e.minLatitude-r,e.maxLatitude+r,e.minLongitude-i,e.maxLongitude+i),extensionFactorHeight:n,extensionFactorWidth:t}},c.prototype.createHeatMapTile=function(e,n){return new t(e,n)},c}),define("util/HighlightController",["../error/ArgumentError","../util/Logger"],function(e,t){"use strict";return function(n){if(!n)throw new e(t.logMessage(t.LEVEL_SEVERE,"HighlightController","constructor","missingWorldWindow"));this.worldWindow=n;var r=[],i=function(e){for(var t=e.clientX,i=e.clientY,s=r.length>0,o=0;o<r.length;o++)r[o].highlighted=!1;r=[];var a=n.pick(n.canvasCoordinates(t,i));if(a.objects.length>0&&(s=!0),a.objects.length>0)for(var l=0;l<a.objects.length;l++)a.objects[l].isTerrain||(a.objects[l].userObject.highlighted=!0,r.push(a.objects[l].userObject));s&&n.redraw()};this.worldWindow.addEventListener("mousemove",i);new WorldWind.TapRecognizer(this.worldWindow,i)}}),define("formats/kml/util/KmlAttribute",[],function(){"use strict";var e=function(e,t){this.node=e,this.name=t};return e.prototype.value=function(){return this.node.attributes&&this.node.attributes.getNamedItem(this.name)&&this.node.attributes.getNamedItem(this.name).value||null},e.prototype.exists=function(){return null!=this.value()},e.prototype.save=function(e){this.node.setAttribute(this.name,e)},e}),define("formats/kml/KmlElements",[],function(){"use strict";return{keys:{},addKey:function(e,t){this.keys[e]=t},getKey:function(e){return this.keys[e]}}}),define("formats/kml/util/KmlNodeTransformers",["./KmlAttribute","../KmlElements","../../../geom/Position","../../../util/WWUtil"],function(e,t,n,r){function i(e){var t;return null!=e&&e.childNodes[0]?t=e.childNodes[0].nodeValue:null!=e&&(t=""),t}var s=function(){};return s.string=function(e){return String(i(e))},s.number=function(e){return Number(i(e))},s.boolean=function(e){return r.transformToBoolean(i(e))},s.date=function(e){return r.date(i(e))},s.kmlObject=function(e,n,r){var i=e.nodeName,s=t.getKey(i);return s?new s({objectNode:e,parent:n,controls:r}):null},s.linearRing=function(e,n,r){var i=t.getKey("LinearRing");if(!i)return null;var s=null;return Array.prototype.forEach.call(e.childNodes,function(e){e.nodeName.toUpperCase()=="LinearRing".toUpperCase()&&(s=e)}),new i({objectNode:s,parent:n,controls:r})},s.positions=function(e){var t=[];return i(e).trim().replace(/\s+/g," ").split(" ").forEach(function(e){e=e.split(","),t.push(new n(Number(e[1]),Number(e[0]),Number(e[2]||0)))}),t},s.attribute=function(t){return function(n){return new e(n,t).value()}},s}),define("formats/kml/util/KmlElementsFactory",["./KmlNodeTransformers"],function(e){"use strict";var t=function(e){this.options=e||{},this.options.controls=this.options.controls||[]};t.prototype.specific=function(e,t){var n=e.node,r=null,i=this;return[].forEach.call(n.childNodes,function(n){n.nodeName==t.name&&(r=t.transformer(n,e,i.options.controls))}),r},t.prototype.any=function(t,n){var r=t.node,i=null,s=this;return[].forEach.call(r.childNodes,function(r){-1!=n.name.indexOf(r.nodeName)&&(i=e.kmlObject(r,t,s.options.controls))}),i},t.prototype.all=function(t){var n=t.node,r=[],i=this;return[].forEach.call(n.childNodes,function(n){var s=e.kmlObject(n,t,i.options.controls);s&&r.push(s)}),r};var n=new t;return t.applicationWide=function(){return n},t}),define("formats/kml/util/KmlTreeKeyValueCache",["../../../util/WWUtil"],function(e){"use strict";var t=function(){this.map={}};t.prototype.add=function(e,t,n){this.map[e]||(this.map[e]={}),this.map[e][t]=n},t.prototype.value=function(t,n){if(!this.map[t])return null;if(-1==n.indexOf("#")){var r=this.level(t);for(var i in r)if(r.hasOwnProperty(i)&&e.startsWith(i,n))return r[i]}
return this.map[t][n]||null},t.prototype.level=function(e){return this.map[e]},t.prototype.remove=function(e,t){delete this.map[e][t]};var n=new t;return t.applicationLevelCache=function(){return n},t}),define("formats/kml/util/KmlElementsFactoryCached",["./KmlAttribute","./KmlElementsFactory","./KmlTreeKeyValueCache","../../../util/WWUtil"],function(e,t,n,r){"use strict";var i=function(e){this.internalFactory=new t(e),this.cache=n.applicationLevelCache()};i.prototype.all=function(e){var t=e.node,n=this.cache.level(this.cacheKey(e.node,"All"));if(n){var r=[];for(var i in n)n.hasOwnProperty(i)&&r.push(n[i]);return r}var s=this.internalFactory.all(e);if(s&&s.length){var o=this;s.forEach(function(e){o.cache.add(o.cacheKey(t,"All"),o.cacheKey(e.node),e)})}return s},i.prototype.specific=function(e,t){var n=e.node,r=t.name;t.attribute&&(r=t.attribute+r);var i=this.cache.value(this.cacheKey(n),r);if(i)return i;var s=this.internalFactory.specific(e,t);return s&&s.node?this.cache.add(this.cacheKey(n),this.cacheKey(s.node),s):s&&this.cache.add(this.cacheKey(n),r,s),s},i.prototype.any=function(e,t){var n,r=e.node,i=this,s=null;if(t.name.forEach(function(e){(n=i.cache.value(i.cacheKey(r),e))&&(s=n)}),s)return s;var o=this.internalFactory.any(e,t);return o&&this.cache.add(i.cacheKey(r),i.cacheKey(o.node),o),o},i.prototype.cacheKey=function(t,n){var i=new e(t,"id");i.exists()||i.save(r.guid());var s=t.nodeName+"#"+i.value();return n&&(s=n+s),s};var s=new i;return i.applicationWide=function(){return s},i}),define("util/es6-promise",[],function(){"use strict";function e(e){var t=typeof e;return null!==e&&("object"===t||"function"===t)}function t(e){return"function"==typeof e}function n(e){F=e}function r(e){B=e}function i(){return void 0!==D?function(){D(o)}:s()}function s(){var e=setTimeout;return function(){return e(o,1)}}function o(){for(var e=0;e<N;e+=2){(0,z[e])(z[e+1]),z[e]=void 0,z[e+1]=void 0}N=0}function a(e,t){var n=this,r=new this.constructor(h);void 0===r[H]&&L(r);var i=n._state;if(i){var s=arguments[i-1];B(function(){return w(i,r,s,n._result)})}else E(n,r,e,t);return r}function l(e){var t=this;if(e&&"object"==typeof e&&e.constructor===t)return e;var n=new t(h);return g(n,e),n}function h(){}function u(){return new TypeError("You cannot resolve a promise with itself")}function c(){return new TypeError("A promises callback cannot return that same promise.")}function d(e,t,n,r){try{e.call(t,n,r)}catch(e){return e}}function f(e,t,n){B(function(e){var r=!1,i=d(n,t,function(n){r||(r=!0,t!==n?g(e,n):y(e,n))},function(t){r||(r=!0,_(e,t))},"Settle: "+(e._label||" unknown promise"));!r&&i&&(r=!0,_(e,i))},e)}function p(e,t){t._state===Y?y(e,t._result):t._state===Z?_(e,t._result):E(t,void 0,function(t){return g(e,t)},function(t){return _(e,t)})}function m(e,n,r){n.constructor===e.constructor&&r===a&&n.constructor.resolve===l?p(e,n):void 0===r?y(e,n):t(r)?f(e,n,r):y(e,n)}function g(t,n){if(t===n)_(t,u());else if(e(n)){var r=void 0;try{r=n.then}catch(e){return void _(t,e)}m(t,n,r)}else y(t,n)}function b(e){e._onerror&&e._onerror(e._result),v(e)}function y(e,t){e._state===q&&(e._result=t,e._state=Y,0!==e._subscribers.length&&B(v,e))}function _(e,t){e._state===q&&(e._state=Z,e._result=t,B(b,e))}function E(e,t,n,r){var i=e._subscribers,s=i.length;e._onerror=null,i[s]=t,i[s+Y]=n,i[s+Z]=r,0===s&&e._state&&B(v,e)}function v(e){var t=e._subscribers,n=e._state;if(0!==t.length){for(var r=void 0,i=void 0,s=e._result,o=0;o<t.length;o+=3)r=t[o],i=t[o+n],r?w(n,r,i,s):i(s);e._subscribers.length=0}}function w(e,n,r,i){var s=t(r),o=void 0,a=void 0,l=!0;if(s){try{o=r(i)}catch(e){l=!1,a=e}if(n===o)return void _(n,c())}else o=i;n._state!==q||(s&&l?g(n,o):!1===l?_(n,a):e===Y?y(n,o):e===Z&&_(n,o))}function S(e,t){try{t(function(t){g(e,t)},function(t){_(e,t)})}catch(t){_(e,t)}}function T(){return X++}function L(e){e[H]=X++,e._state=void 0,e._result=void 0,e._subscribers=[]}function x(){return new Error("Array Methods must be provided an Array")}function R(e){return new J(this,e).promise}function A(e){var t=this;return new t(P(e)?function(n,r){for(var i=e.length,s=0;s<i;s++)t.resolve(e[s]).then(n,r)}:function(e,t){return t(new TypeError("You must pass an array to race."))})}function C(e){var t=this,n=new t(h);return _(n,e),n}function M(){throw new TypeError("You must pass a resolver function as the first argument to the promise constructor")}function k(){throw new TypeError("Failed to construct 'Promise': Please use the 'new' operator, this object constructor cannot be called as a function.")}function I(){var e=void 0;if("undefined"!=typeof global)e=global;else if("undefined"!=typeof self)e=self;else try{e=Function("return this")()}catch(e){throw new Error("polyfill failed because global object is unavailable in this environment")}var t=e.Promise;if(t){var n=null;try{n=Object.prototype.toString.call(t.resolve())}catch(e){}if("[object Promise]"===n&&!t.cast)return}e.Promise=Q}var O=void 0;O=Array.isArray?Array.isArray:function(e){return"[object Array]"===Object.prototype.toString.call(e)};var P=O,N=0,D=void 0,F=void 0,B=function(e,t){z[N]=e,z[N+1]=t,2===(N+=2)&&(F?F(o):K())},W="undefined"!=typeof window?window:void 0,V=W||{},G=V.MutationObserver||V.WebKitMutationObserver,j="undefined"==typeof self&&"undefined"!=typeof process&&"[object process]"==={}.toString.call(process),U="undefined"!=typeof Uint8ClampedArray&&"undefined"!=typeof importScripts&&"undefined"!=typeof MessageChannel,z=new Array(1e3),K=void 0;K=j?function(){return function(){return process.nextTick(o)}}():G?function(){var e=0,t=new G(o),n=document.createTextNode("");return t.observe(n,{characterData:!0}),function(){n.data=e=++e%2}}():U?function(){var e=new MessageChannel;return e.port1.onmessage=o,function(){return e.port2.postMessage(0)}}():void 0===W&&"function"==typeof require?function(){try{var e=Function("return this")().require("vertx");return D=e.runOnLoop||e.runOnContext,i()}catch(e){return s()}}():s();var H=Math.random().toString(36).substring(2),q=void 0,Y=1,Z=2,X=0,J=function(){function e(e,t){this._instanceConstructor=e,this.promise=new e(h),this.promise[H]||L(this.promise),P(t)?(this.length=t.length,this._remaining=t.length,this._result=new Array(this.length),0===this.length?y(this.promise,this._result):(this.length=this.length||0,this._enumerate(t),0===this._remaining&&y(this.promise,this._result))):_(this.promise,x())}return e.prototype._enumerate=function(e){for(var t=0;this._state===q&&t<e.length;t++)this._eachEntry(e[t],t)},e.prototype._eachEntry=function(e,t){var n=this._instanceConstructor,r=n.resolve;if(r===l){var i=void 0,s=void 0,o=!1;try{i=e.then}catch(e){o=!0,s=e}if(i===a&&e._state!==q)this._settledAt(e._state,t,e._result);else if("function"!=typeof i)this._remaining--,this._result[t]=e;else if(n===Q){var u=new n(h);o?_(u,s):m(u,e,i),this._willSettleAt(u,t)}else this._willSettleAt(new n(function(t){return t(e)}),t)}else this._willSettleAt(r(e),t)},e.prototype._settledAt=function(e,t,n){var r=this.promise;r._state===q&&(this._remaining--,e===Z?_(r,n):this._result[t]=n),0===this._remaining&&y(r,this._result)},e.prototype._willSettleAt=function(e,t){var n=this;E(e,void 0,function(e){return n._settledAt(Y,t,e)},function(e){return n._settledAt(Z,t,e)})},e}(),Q=function(){function e(t){this[H]=T(),this._result=this._state=void 0,this._subscribers=[],h!==t&&("function"!=typeof t&&M(),this instanceof e?S(this,t):k())}return e.prototype.catch=function(e){return this.then(null,e)},e.prototype.finally=function(e){var n=this,r=n.constructor;return t(e)?n.then(function(t){return r.resolve(e()).then(function(){return t})},function(t){return r.resolve(e()).then(function(){throw t})}):n.then(e,e)},e}();return Q.prototype.then=a,Q.all=R,Q.race=A,Q.resolve=l,Q.reject=C,Q._setScheduler=n,Q._setAsap=r,Q._asap=B,Q.polyfill=I,Q.Promise=Q,Q}),define("util/Promise",["./es6-promise"],function(e){"use strict";return window.Promise?window.Promise:e.Promise}),define("formats/kml/KmlObject",["../../error/ArgumentError","./util/KmlAttribute","./KmlElements","./util/KmlElementsFactoryCached","../../util/Logger","../../util/Promise","../../render/Renderable"],function(e,t,n,r,i,s,o){"use strict";var a=function(t){if(o.call(this),t=t||{},!t.objectNode)throw new e(i.logMessage(i.LEVEL_SEVERE,"KmlObject","constructor","Passed node isn't defined."));this._node=t.objectNode,this._cache={},this._controls=t.controls||[],this._factory=new r({controls:this._controls}),this.hook(this._controls,t)};return a.prototype=Object.create(o.prototype),Object.defineProperties(a.prototype,{id:{get:function(){return new t(this.node,"id").value()}},node:{get:function(){return this._node}}}),a.prototype.hook=function(e,t){var n=this;e.forEach(function(e){e.hook(n,t)})},a.prototype.render=function(e){},a.prototype.getTagNames=function(){return[]},a}),define("formats/kml/KmlTimePrimitive",["./KmlObject"],function(e){"use strict";var t=function(t){e.call(this,t)};return t.prototype=Object.create(e.prototype),t.prototype.timeRange=function(){var e,t;return this.kmlBegin&&(t=e=this.kmlBegin.valueOf()),this.kmlEnd&&(t=this.kmlEnd.valueOf(),e||(e=t)),this.kmlWhen&&(t=e=this.kmlWhen.valueOf()),{from:e,to:t}},t.prototype.getTagNames=function(){return["TimeSpan","TimeStamp"]},t}),define("formats/kml/KmlAbstractView",["./KmlObject","./KmlElements","./KmlTimePrimitive"],function(e,t,n){"use strict";var r=function(t){e.call(this,t)};return r.prototype=Object.create(e.prototype),Object.defineProperties(r.prototype,{kmlTimePrimitive:{get:function(){return this._factory.any(this,{name:n.prototype.getTagNames()})}}}),r.prototype.getTagNames=function(){return["Camera","LookAt"]},r}),define("formats/kml/styles/KmlSubStyle",["./../KmlObject"],function(e){"use strict";var t=function(t){e.call(this,t)};return t.prototype=Object.create(e.prototype),t.prototype.getTagNames=function(){return["LineStyle","PolyStyle","IconStyle","LabelStyle","BalloonStyle","ListStyle"]},t}),define("formats/kml/styles/KmlBalloonStyle",["../KmlElements","./KmlSubStyle","../util/KmlNodeTransformers"],function(e,t,n){"use strict";var r=function(e){t.call(this,e)};return r.prototype=Object.create(t.prototype),Object.defineProperties(r.prototype,{kmlBgColor:{get:function(){return this._factory.specific(this,{name:"bgColor",transformer:n.string})}},kmlTextColor:{get:function(){return this._factory.specific(this,{name:"textColor",transformer:n.string})}},kmlText:{get:function(){return this._factory.specific(this,{name:"text",transformer:n.string})}},kmlDisplayMode:{get:function(){return this._factory.specific(this,{name:"displayMode",transformer:n.string})}}}),r.update=function(){},r.prototype.getTagNames=function(){return["BalloonStyle"]},e.addKey(r.prototype.getTagNames()[0],r),r}),define("formats/kml/KmlCamera",["./KmlElements","./KmlAbstractView","./util/KmlNodeTransformers"],function(e,t,n){"use strict";var r=function(e){t.call(this,e)};return r.prototype=Object.create(t.prototype),Object.defineProperties(r.prototype,{kmlLongitude:{get:function(){return this._factory.specific(this,{name:"longitude",transformer:n.string})}},kmlLatitude:{get:function(){return this._factory.specific(this,{name:"latitude",transformer:n.string})}},kmlAltitude:{get:function(){return this._factory.specific(this,{name:"altitude",transformer:n.string})}},kmlHeading:{get:function(){return this._factory.specific(this,{name:"heading",transformer:n.string})}},kmlTilt:{get:function(){return this._factory.specific(this,{name:"tilt",transformer:n.string})}},kmlRoll:{get:function(){return this._factory.specific(this,{name:"roll",transformer:n.string})}},kmlAltitudeMode:{get:function(){return this._factory.specific(this,{name:"altitudeMode",transformer:n.string})}}}),r.prototype.getTagNames=function(){return["Camera"]},e.addKey(r.prototype.getTagNames()[0],r),r}),define("formats/kml/util/KmlChange",["../KmlElements","../KmlObject"],function(e,t){var n=function(e){t.call(this,e)};return n.prototype=Object.create(t.prototype),Object.defineProperties(n.prototype,{shapes:{get:function(){return this._factory.all(this)}}}),n.prototype.getTagNames=function(){return["Change"]},e.addKey(n.prototype.getTagNames()[0],n),n}),define("formats/kml/styles/KmlColorStyle",["./KmlSubStyle","../util/KmlNodeTransformers"],function(e,t){"use strict";var n=function(t){e.call(this,t)};return n.prototype=Object.create(e.prototype),Object.defineProperties(n.prototype,{kmlColor:{get:function(){return this._factory.specific(this,{name:"color",transformer:t.string})}},kmlColorMode:{get:function(){return this._factory.specific(this,{name:"colorMode",transformer:t.string})}}}),n.prototype.getTagNames=function(){return["LineStyle","PolyStyle","IconStyle","LabelStyle"]},n}),define("formats/kml/KmlFileCache",[],function(){"use strict";var e=function(){this._rootFile=null,this._map={}};return e.prototype.retrieve=function(e){if(0!=e.indexOf("kmz;")&&0!=e.indexOf("href;")&&(0==e.indexOf("#")||null==e||0!=e.indexOf("http")))return this._rootFile;var t=e;return-1!=e.indexOf("#")&&(t=e.substr(0,e.indexOf("#")-1)),this._map[t]?this._map[t]:null},e.prototype.add=function(e,t,n){n?this._rootFile=t:this._map[e]=t},e}),define("formats/kml/styles/KmlStyleSelector",["./../KmlObject"],function(e){"use strict";var t=function(t){e.call(this,t)};return t.prototype=Object.create(e.prototype),t.prototype.getTagNames=function(){return["Style","StyleMap"]},t}),define("formats/kml/styles/KmlPolyStyle",["../../../util/Color","./KmlColorStyle","./../KmlElements","../util/KmlNodeTransformers"],function(e,t,n,r){"use strict";var i=function(e){t.call(this,e)};return i.prototype=Object.create(t.prototype),Object.defineProperties(i.prototype,{kmlFill:{get:function(){return this._factory.specific(this,{name:"fill",transformer:r.boolean})}},kmlOutline:{get:function(){return this._factory.specific(this,{name:"outline",transformer:r.boolean})}}}),i.update=function(t,n){t=t||{};var r=n||{};return r._drawInterior=t.kmlFill||!0,r._drawOutline=t.kmlOutline||!1,r._outlineColor=n._outlineColor||e.WHITE,r._interiorColor=t.kmlColor&&e.colorFromKmlHex(t.kmlColor)||e.WHITE,r._colorMode=t.kmlColorMode||"normal",r},i.prototype.getTagNames=function(){return["PolyStyle"]},n.addKey(i.prototype.getTagNames()[0],i),i}),define("formats/kml/util/KmlHrefResolver",["../../../util/Promise","../../../util/WWUtil"],function(e,t){var n=function(e,t){this._url=e,this._fileCache=t};return n.prototype.url=function(){if(t.startsWith(this._url,"http://")||t.startsWith(this._url,"https://"))return this._url;var e=this._fileCache.retrieve("kmz;"+this._url);return e||((e=this._fileCache.retrieve("href;"+this._url))||this._url)},n}),define("formats/kml/KmlLink",["./util/KmlHrefResolver","./KmlElements","./KmlObject","./util/KmlNodeTransformers"],function(e,t,n,r){"use strict";var i=function(e){n.call(this,e),this.onChangeListeners=[]};return i.prototype=Object.create(n.prototype),Object.defineProperties(i.prototype,{kmlRefreshMode:{get:function(){return this._factory.specific(this,{name:"refreshMode",transformer:r.string})}},kmlRefreshInterval:{get:function(){return this._factory.specific(this,{name:"refreshInterval",transformer:r.number})}},kmlViewRefreshMode:{get:function(){return this._factory.specific(this,{name:"viewRefreshMode",transformer:r.string})}},kmlViewRefreshTime:{get:function(){return this._factory.specific(this,{name:"viewRefreshTime",transformer:r.number})}},kmlViewBoundScale:{get:function(){return this._factory.specific(this,{name:"viewBoundScale",transformer:r.number})}},kmlViewFormat:{get:function(){return this._factory.specific(this,{name:"viewFormat",transformer:r.string})}},kmlHttpQuery:{get:function(){return this._factory.specific(this,{name:"httpQuery",transformer:r.string})}}}),i.prototype.kmlHref=function(t){return new e(this._factory.specific(this,{name:"href",transformer:r.string}),t).url()},i.prototype.getTagNames=function(){return["Link"]},t.addKey(i.prototype.getTagNames()[0],i),i}),define("formats/kml/KmlIcon",["./KmlLink","./KmlElements","./util/KmlNodeTransformers"],function(e,t,n){"use strict";var r=function(t){e.call(this,t)};return r.prototype=Object.create(e.prototype),Object.defineProperties(r.prototype,{kmlX:{get:function(){return this._factory.specific(this,{name:"gx:x",transformer:n.number})}},kmlY:{get:function(){return this._factory.specific(this,{name:"gx:y",transformer:n.number})}},kmlW:{get:function(){return this._factory.specific(this,{name:"gx:w",transformer:n.number})}},kmlH:{get:function(){return this._factory.specific(this,{name:"gx:h",transformer:n.number})}}}),r.prototype.getTagNames=function(){return["Icon"]},t.addKey(r.prototype.getTagNames()[0],r),r}),define("formats/kml/styles/KmlIconStyle",["../../../util/Color","./KmlColorStyle","./../KmlElements","../KmlIcon","../util/KmlNodeTransformers"],function(e,t,n,r,i){"use strict";var s=function(e){t.call(this,e)};return s.prototype=Object.create(t.prototype),Object.defineProperties(s.prototype,{kmlScale:{get:function(){return this._factory.specific(this,{name:"scale",transformer:i.number})}},kmlHeading:{get:function(){return this._factory.specific(this,{name:"heading",transformer:i.number})}},kmlIcon:{get:function(){return this._factory.any(this,{name:r.prototype.getTagNames()})}},kmlHotSpotX:{get:function(){return this._factory.specific(this,{name:"hotSpot",transformer:i.attribute("x")})}},kmlHotSpotY:{get:function(){return this._factory.specific(this,{name:"hotSpot",transformer:i.attribute("y")})}},kmlHotSpotXUnits:{get:function(){return this._factory.specific(this,{name:"hotSpot",transformer:i.attribute("xunits")})}},kmlHotSpotYUnits:{get:function(){return this._factory.specific(this,{name:"hotSpot",transformer:i.attribute("yunits")})}}}),s.update=function(t,n,r){t=t||{};var i=n||{};return i._imageInitialWidth=32,i._imageInitialHeight=32,i._imageScale=t.kmlScale||1,i._imageSource=t.kmlIcon&&t.kmlIcon.kmlHref(r)||null,i._imageColor=t.kmlColor&&e.colorFromKmlHex(t.kmlColor)||e.WHITE,i._imageColorMode=t.kmlColorMode||"normal",i},s.prototype.getTagNames=function(){return["IconStyle"]},n.addKey(s.prototype.getTagNames()[0],s),s}),define("formats/kml/styles/KmlLabelStyle",["./KmlColorStyle","../KmlElements","../util/KmlNodeTransformers"],function(e,t,n){"use strict";var r=function(t){e.call(this,t)};return r.prototype=Object.create(e.prototype),Object.defineProperties(r.prototype,{kmlScale:{get:function(){return this._factory.specific(this,{name:"scale",transformer:n.number})}}}),r.update=function(){},r.prototype.getTagNames=function(){return["LabelStyle"]},t.addKey(r.prototype.getTagNames()[0],r),r}),define("formats/kml/styles/KmlLineStyle",["../../../util/Color","./KmlColorStyle","./../KmlElements","../util/KmlNodeTransformers"],function(e,t,n,r){"use strict";var i=function(e){t.call(this,e)};return i.prototype=Object.create(t.prototype),Object.defineProperties(i.prototype,{kmlWidth:{get:function(){return this._factory.specific(this,{name:"width",transformer:r.number})}},kmlOuterColor:{get:function(){return this._factory.specific(this,{name:"gx:outerColor",transformer:r.string})}},kmlOuterWidth:{get:function(){return this._factory.specific(this,{name:"gx:outerWidth",transformer:r.number})}},kmlPhysicalWidth:{get:function(){return this._factory.specific(this,{name:"gx:physicalWidth",transformer:r.number})}},kmlLabelVisibility:{get:function(){return this._factory.specific(this,{name:"gx:labelVisibility",transformer:r.boolean})}}}),i.update=function(t,n){var r=n||{};return t=t||{},r._outlineColor=t.kmlColor&&e.colorFromKmlHex(t.kmlColor)||e.WHITE,r._outlineWidth=t.kmlWidth||10,r},i.prototype.getTagNames=function(){return["LineStyle"]},n.addKey(i.prototype.getTagNames()[0],i),i}),define("formats/kml/util/KmlItemIcon",["./KmlHrefResolver","./../KmlElements","../KmlObject","./KmlNodeTransformers"],function(e,t,n,r){"use strict";var i=function(e){n.call(this,e)};return i.prototype=Object.create(n.prototype),Object.defineProperties(i.prototype,{kmlState:{get:function(){return this._factory.specific(this,{name:"state",transformer:r.string})}}}),i.prototype.kmlHref=function(t){return new e(this._factory.specific(this,{name:"href",transformer:r.string}),t).url()},i.prototype.getTagNames=function(){return["ItemIcon"]},t.addKey(i.prototype.getTagNames()[0],i),i}),define("formats/kml/styles/KmlListStyle",["../util/KmlItemIcon","../KmlElements","./KmlSubStyle","../util/KmlNodeTransformers"],function(e,t,n,r){"use strict";var i=function(e){n.call(this,e)};return i.prototype=Object.create(n.prototype),Object.defineProperties(i.prototype,{kmlBgColor:{get:function(){return this._factory.specific(this,{name:"bgColor",transformer:r.string})}},kmlListItemType:{get:function(){return this._factory.specific(this,{name:"listItemType",transformer:r.string})}},kmlItemIcon:{get:function(){return this._factory.any(this,{name:e.prototype.getTagNames()})}}}),i.update=function(){},i.prototype.getTagNames=function(){return["ListStyle"]},t.addKey(i.prototype.getTagNames()[0],i),i}),define("formats/kml/styles/KmlStyle",["../../../util/Color","../../../util/Font","./KmlStyleSelector","./../KmlElements","./KmlPolyStyle","./KmlIconStyle","./KmlLabelStyle","./KmlLineStyle","./KmlListStyle","./KmlBalloonStyle","../../../util/Offset","../../../util/Promise","../../../shapes/ShapeAttributes","../../../shapes/TextAttributes"],function(e,t,n,r,i,s,o,a,l,h,u,c,d,f){"use strict";var p=function(e){n.call(this,e)};return p.prototype=Object.create(n.prototype),Object.defineProperties(p.prototype,{kmlIconStyle:{get:function(){return this._factory.any(this,{name:s.prototype.getTagNames()})}},kmlLabelStyle:{get:function(){return this._factory.any(this,{name:o.prototype.getTagNames()})}},kmlLineStyle:{get:function(){return this._factory.any(this,{name:a.prototype.getTagNames()})}},kmlPolyStyle:{get:function(){return this._factory.any(this,{name:i.prototype.getTagNames()})}},kmlBalloonStyle:{get:function(){return this._factory.any(this,{name:h.prototype.getTagNames()})}},kmlListStyle:{get:function(){return this._factory.any(this,{name:l.prototype.getTagNames()})}}}),p.prototype.generate=function(e,t){e=e||{};var n=this||{};return n.kmlIconStyle&&s.update(n.kmlIconStyle,e,t),n.kmlListStyle&&l.update(n.kmlListStyle,e),n.kmlBalloonStyle&&h.update(n.kmlBalloonStyle,e),n.kmlLabelStyle&&o.update(n.kmlLabelStyle,e),n.kmlPolyStyle&&i.update(n.kmlPolyStyle,e),n.kmlLineStyle&&a.update(n.kmlLineStyle,e),e},p.prototype.getStyle=function(){var e=this;return new c(function(t){window.setTimeout(function(){t(e)},0)})},p.prototype.getTagNames=function(){return["Style"]},r.addKey(p.prototype.getTagNames()[0],p),p.placemarkAttributes=function(t){return t=t||{},t._imageColor=t._imageColor||new e(1,1,1,1),t._imageOffset=t._imageOffset||new u(WorldWind.OFFSET_FRACTION,.5,WorldWind.OFFSET_FRACTION,.5),t._imageScale=t._imageScale||1,t._imageSource=t._imageSource||null,t._depthTest=t._depthTest||!0,t._labelAttributes=t._labelAttributes||new f(p.textAttributes()),t._drawLeaderLine=t._drawLeaderLine||!1,t._leaderLineAttributes=t._leaderLineAttributes||new d(p.shapeAttributes()),t},p.textAttributes=function(n){return n=n||{},n._color=n._color||new e(1,1,1,1),n._font=n._font||new t(14),n._offset=n._offset||new u(WorldWind.OFFSET_FRACTION,.5,WorldWind.OFFSET_FRACTION,0),n._scale=n._scale||1,n._depthTest=n._depthTest||!1,n._outlineColor=n._outlineColor||e.RED,n},p.shapeAttributes=function(t){return t=t||{},t._drawInterior=t._drawInterior||!0,t._drawOutline=t._drawOutline||!0,t._enableLighting=t._enableLighting||!1,t._interiorColor=t._interiorColor||e.WHITE,t._outlineColor=t._outlineColor||e.RED,t._outlineWidth=t._outlineWidth||1,t._outlineStippleFactor=t._outlineStippleFactor||0,t._outlineStipplePattern=t._outlineStipplePattern||61680,t._imageSource=t._imageSource||null,t._depthTest=t._depthTest||!0,t._drawVerticals=t._drawVerticals||!1,t._applyLighting=t._applyLighting||!1,t},p.default=function(){return new p({objectNode:document.createElement("Style")})},p}),define("formats/kml/util/KmlPair",["./../KmlElements","../KmlObject","../styles/KmlStyleSelector","./KmlNodeTransformers"],function(e,t,n,r){"use strict";var i=function(e){t.call(this,e)};return i.prototype=Object.create(t.prototype),Object.defineProperties(i.prototype,{kmlKey:{get:function(){return this._factory.specific(this,{name:"key",transformer:r.string})}},kmlStyleUrl:{get:function(){return this._factory.specific(this,{name:"styleUrl",transformer:r.string})}},kmlStyleSelector:{get:function(){return this._factory.any(this,{name:n.prototype.getTagNames()})}}}),i.prototype.getTagNames=function(){return["Pair"]},i.prototype.getStyle=function(e){return e.handleRemoteStyle(this.kmlStyleUrl,this.kmlStyleSelector)},e.addKey(i.prototype.getTagNames()[0],i),i}),define("formats/kml/styles/KmlStyleMap",["../KmlElements","./KmlSubStyle","../util/KmlPair","../../../util/Promise"],function(e,t,n,r){"use strict";var i=function(e){t.call(this,e)};return i.prototype=Object.create(t.prototype),Object.defineProperties(i.prototype,{kmlPairs:{get:function(){return this._factory.all(this)}},isMap:{get:function(){return!0}}}),i.prototype.resolve=function(e){var t={},n=this.kmlPairs.map(function(n){var r=n.kmlKey;return n.getStyle(e).then(function(e){t[r]=e.normal})});return r.all(n).then(function(){return t.normal||(t.normal=null),t.highlight||(t.highlight=null),t})},i.prototype.getTagNames=function(){return["StyleMap"]},e.addKey(i.prototype.getTagNames()[0],i),i}),define("formats/kml/KmlTimeSpan",["./KmlElements","./KmlTimePrimitive","./util/KmlNodeTransformers"],function(e,t,n){"use strict";var r=function(e){e.isTimeSpan=!0,t.call(this,e)};return r.prototype=Object.create(t.prototype),Object.defineProperties(r.prototype,{kmlBegin:{get:function(){return this._factory.specific(this,{name:"begin",transformer:n.date})}},kmlEnd:{get:function(){return this._factory.specific(this,{name:"end",transformer:n.date})}}}),r.prototype.getTagNames=function(){return["TimeSpan"]},e.addKey(r.prototype.getTagNames()[0],r),r}),define("formats/kml/KmlTimeStamp",["./KmlElements","./KmlTimePrimitive","./util/KmlNodeTransformers"],function(e,t,n){"use strict";var r=function(e){e.isTimeStamp=!0,t.call(this,e)};return r.prototype=Object.create(t.prototype),Object.defineProperties(r.prototype,{kmlWhen:{get:function(){return this._factory.specific(this,{name:"when",transformer:n.date})}}}),r.prototype.getTagNames=function(){return["TimeStamp"]},e.addKey(r.prototype.getTagNames()[0],r),r}),define("util/jszip",[],function(){return function(e){function t(r){if(n[r])return n[r].exports;var i=n[r]={i:r,l:!1,exports:{}};return e[r].call(i.exports,i,i.exports,t),i.l=!0,i.exports}var n={};return t.m=e,t.c=n,t.d=function(e,n,r){t.o(e,n)||Object.defineProperty(e,n,{enumerable:!0,get:r})},t.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},t.t=function(e,n){if(1&n&&(e=t(e)),8&n)return e;if(4&n&&"object"==typeof e&&e&&e.__esModule)return e;var r=Object.create(null);if(t.r(r),Object.defineProperty(r,"default",{enumerable:!0,value:e}),2&n&&"string"!=typeof e)for(var i in e)t.d(r,i,function(t){return e[t]}.bind(null,i));return r},t.n=function(e){var n=e&&e.__esModule?function(){return e.default}:function(){return e};return t.d(n,"a",n),n},t.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},t.p="",t(t.s="./lib/index.js")}({"./lib/base64.js":function(module,exports,__webpack_require__){"use strict";eval('\r\nvar utils = __webpack_require__(/*! ./utils */ "./lib/utils.js");\r\nvar support = __webpack_require__(/*! ./support */ "./lib/support.js");\r\n// private property\r\nvar _keyStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";\r\n\r\n\r\n// public method for encoding\r\nexports.encode = function(input) {\r\n    var output = [];\r\n    var chr1, chr2, chr3, enc1, enc2, enc3, enc4;\r\n    var i = 0, len = input.length, remainingBytes = len;\r\n\r\n    var isArray = utils.getTypeOf(input) !== "string";\r\n    while (i < input.length) {\r\n        remainingBytes = len - i;\r\n\r\n        if (!isArray) {\r\n            chr1 = input.charCodeAt(i++);\r\n            chr2 = i < len ? input.charCodeAt(i++) : 0;\r\n            chr3 = i < len ? input.charCodeAt(i++) : 0;\r\n        } else {\r\n            chr1 = input[i++];\r\n            chr2 = i < len ? input[i++] : 0;\r\n            chr3 = i < len ? input[i++] : 0;\r\n        }\r\n\r\n        enc1 = chr1 >> 2;\r\n        enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);\r\n        enc3 = remainingBytes > 1 ? (((chr2 & 15) << 2) | (chr3 >> 6)) : 64;\r\n        enc4 = remainingBytes > 2 ? (chr3 & 63) : 64;\r\n\r\n        output.push(_keyStr.charAt(enc1) + _keyStr.charAt(enc2) + _keyStr.charAt(enc3) + _keyStr.charAt(enc4));\r\n\r\n    }\r\n\r\n    return output.join("");\r\n};\r\n\r\n// public method for decoding\r\nexports.decode = function(input) {\r\n    var chr1, chr2, chr3;\r\n    var enc1, enc2, enc3, enc4;\r\n    var i = 0, resultIndex = 0;\r\n\r\n    var dataUrlPrefix = "data:";\r\n\r\n    if (input.substr(0, dataUrlPrefix.length) === dataUrlPrefix) {\r\n        // This is a common error: people give a data url\r\n        // (data:image/png;base64,iVBOR...) with a {base64: true} and\r\n        // wonders why things don\'t work.\r\n        // We can detect that the string input looks like a data url but we\r\n        // *can\'t* be sure it is one: removing everything up to the comma would\r\n        // be too dangerous.\r\n        throw new Error("Invalid base64 input, it looks like a data url.");\r\n    }\r\n\r\n    input = input.replace(/[^A-Za-z0-9\\+\\/\\=]/g, "");\r\n\r\n    var totalLength = input.length * 3 / 4;\r\n    if(input.charAt(input.length - 1) === _keyStr.charAt(64)) {\r\n        totalLength--;\r\n    }\r\n    if(input.charAt(input.length - 2) === _keyStr.charAt(64)) {\r\n        totalLength--;\r\n    }\r\n    if (totalLength % 1 !== 0) {\r\n        // totalLength is not an integer, the length does not match a valid\r\n        // base64 content. That can happen if:\r\n        // - the input is not a base64 content\r\n        // - the input is *almost* a base64 content, with a extra chars at the\r\n        //   beginning or at the end\r\n        // - the input uses a base64 variant (base64url for example)\r\n        throw new Error("Invalid base64 input, bad content length.");\r\n    }\r\n    var output;\r\n    if (support.uint8array) {\r\n        output = new Uint8Array(totalLength|0);\r\n    } else {\r\n        output = new Array(totalLength|0);\r\n    }\r\n\r\n    while (i < input.length) {\r\n\r\n        enc1 = _keyStr.indexOf(input.charAt(i++));\r\n        enc2 = _keyStr.indexOf(input.charAt(i++));\r\n        enc3 = _keyStr.indexOf(input.charAt(i++));\r\n        enc4 = _keyStr.indexOf(input.charAt(i++));\r\n\r\n        chr1 = (enc1 << 2) | (enc2 >> 4);\r\n        chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);\r\n        chr3 = ((enc3 & 3) << 6) | enc4;\r\n\r\n        output[resultIndex++] = chr1;\r\n\r\n        if (enc3 !== 64) {\r\n            output[resultIndex++] = chr2;\r\n        }\r\n        if (enc4 !== 64) {\r\n            output[resultIndex++] = chr3;\r\n        }\r\n\r\n    }\r\n\r\n    return output;\r\n};\r\n\n\n//# sourceURL=webpack:///./lib/base64.js?')},"./lib/compressedObject.js":function(module,exports,__webpack_require__){"use strict"
;eval('\r\n\r\nvar external = __webpack_require__(/*! ./external */ "./lib/external.js");\r\nvar DataWorker = __webpack_require__(/*! ./stream/DataWorker */ "./lib/stream/DataWorker.js");\r\nvar DataLengthProbe = __webpack_require__(/*! ./stream/DataLengthProbe */ "./lib/stream/DataLengthProbe.js");\r\nvar Crc32Probe = __webpack_require__(/*! ./stream/Crc32Probe */ "./lib/stream/Crc32Probe.js");\r\nvar DataLengthProbe = __webpack_require__(/*! ./stream/DataLengthProbe */ "./lib/stream/DataLengthProbe.js");\r\n\r\n/**\r\n * Represent a compressed object, with everything needed to decompress it.\r\n * @constructor\r\n * @param {number} compressedSize the size of the data compressed.\r\n * @param {number} uncompressedSize the size of the data after decompression.\r\n * @param {number} crc32 the crc32 of the decompressed file.\r\n * @param {object} compression the type of compression, see lib/compressions.js.\r\n * @param {String|ArrayBuffer|Uint8Array|Buffer} data the compressed data.\r\n */\r\nfunction CompressedObject(compressedSize, uncompressedSize, crc32, compression, data) {\r\n    this.compressedSize = compressedSize;\r\n    this.uncompressedSize = uncompressedSize;\r\n    this.crc32 = crc32;\r\n    this.compression = compression;\r\n    this.compressedContent = data;\r\n}\r\n\r\nCompressedObject.prototype = {\r\n    /**\r\n     * Create a worker to get the uncompressed content.\r\n     * @return {GenericWorker} the worker.\r\n     */\r\n    getContentWorker : function () {\r\n        var worker = new DataWorker(external.Promise.resolve(this.compressedContent))\r\n        .pipe(this.compression.uncompressWorker())\r\n        .pipe(new DataLengthProbe("data_length"));\r\n\r\n        var that = this;\r\n        worker.on("end", function () {\r\n            if(this.streamInfo[\'data_length\'] !== that.uncompressedSize) {\r\n                throw new Error("Bug : uncompressed data size mismatch");\r\n            }\r\n        });\r\n        return worker;\r\n    },\r\n    /**\r\n     * Create a worker to get the compressed content.\r\n     * @return {GenericWorker} the worker.\r\n     */\r\n    getCompressedWorker : function () {\r\n        return new DataWorker(external.Promise.resolve(this.compressedContent))\r\n        .withStreamInfo("compressedSize", this.compressedSize)\r\n        .withStreamInfo("uncompressedSize", this.uncompressedSize)\r\n        .withStreamInfo("crc32", this.crc32)\r\n        .withStreamInfo("compression", this.compression)\r\n        ;\r\n    }\r\n};\r\n\r\n/**\r\n * Chain the given worker with other workers to compress the content with the\r\n * given compresion.\r\n * @param {GenericWorker} uncompressedWorker the worker to pipe.\r\n * @param {Object} compression the compression object.\r\n * @param {Object} compressionOptions the options to use when compressing.\r\n * @return {GenericWorker} the new worker compressing the content.\r\n */\r\nCompressedObject.createWorkerFrom = function (uncompressedWorker, compression, compressionOptions) {\r\n    return uncompressedWorker\r\n    .pipe(new Crc32Probe())\r\n    .pipe(new DataLengthProbe("uncompressedSize"))\r\n    .pipe(compression.compressWorker(compressionOptions))\r\n    .pipe(new DataLengthProbe("compressedSize"))\r\n    .withStreamInfo("compression", compression);\r\n};\r\n\r\nmodule.exports = CompressedObject;\r\n\n\n//# sourceURL=webpack:///./lib/compressedObject.js?')},"./lib/compressions.js":function(module,exports,__webpack_require__){"use strict";eval('\r\n\r\nvar GenericWorker = __webpack_require__(/*! ./stream/GenericWorker */ "./lib/stream/GenericWorker.js");\r\n\r\nexports.STORE = {\r\n    magic: "\\x00\\x00",\r\n    compressWorker : function (compressionOptions) {\r\n        return new GenericWorker("STORE compression");\r\n    },\r\n    uncompressWorker : function () {\r\n        return new GenericWorker("STORE decompression");\r\n    }\r\n};\r\nexports.DEFLATE = __webpack_require__(/*! ./flate */ "./lib/flate.js");\r\n\n\n//# sourceURL=webpack:///./lib/compressions.js?')},"./lib/crc32.js":function(module,exports,__webpack_require__){"use strict";eval('\r\n\r\nvar utils = __webpack_require__(/*! ./utils */ "./lib/utils.js");\r\n\r\n/**\r\n * The following functions come from pako, from pako/lib/zlib/crc32.js\r\n * released under the MIT license, see pako https://github.com/nodeca/pako/\r\n */\r\n\r\n// Use ordinary array, since untyped makes no boost here\r\nfunction makeTable() {\r\n    var c, table = [];\r\n\r\n    for(var n =0; n < 256; n++){\r\n        c = n;\r\n        for(var k =0; k < 8; k++){\r\n            c = ((c&1) ? (0xEDB88320 ^ (c >>> 1)) : (c >>> 1));\r\n        }\r\n        table[n] = c;\r\n    }\r\n\r\n    return table;\r\n}\r\n\r\n// Create table on load. Just 255 signed longs. Not a problem.\r\nvar crcTable = makeTable();\r\n\r\n\r\nfunction crc32(crc, buf, len, pos) {\r\n    var t = crcTable, end = pos + len;\r\n\r\n    crc = crc ^ (-1);\r\n\r\n    for (var i = pos; i < end; i++ ) {\r\n        crc = (crc >>> 8) ^ t[(crc ^ buf[i]) & 0xFF];\r\n    }\r\n\r\n    return (crc ^ (-1)); // >>> 0;\r\n}\r\n\r\n// That\'s all for the pako functions.\r\n\r\n/**\r\n * Compute the crc32 of a string.\r\n * This is almost the same as the function crc32, but for strings. Using the\r\n * same function for the two use cases leads to horrible performances.\r\n * @param {Number} crc the starting value of the crc.\r\n * @param {String} str the string to use.\r\n * @param {Number} len the length of the string.\r\n * @param {Number} pos the starting position for the crc32 computation.\r\n * @return {Number} the computed crc32.\r\n */\r\nfunction crc32str(crc, str, len, pos) {\r\n    var t = crcTable, end = pos + len;\r\n\r\n    crc = crc ^ (-1);\r\n\r\n    for (var i = pos; i < end; i++ ) {\r\n        crc = (crc >>> 8) ^ t[(crc ^ str.charCodeAt(i)) & 0xFF];\r\n    }\r\n\r\n    return (crc ^ (-1)); // >>> 0;\r\n}\r\n\r\nmodule.exports = function crc32wrapper(input, crc) {\r\n    if (typeof input === "undefined" || !input.length) {\r\n        return 0;\r\n    }\r\n\r\n    var isArray = utils.getTypeOf(input) !== "string";\r\n\r\n    if(isArray) {\r\n        return crc32(crc|0, input, input.length, 0);\r\n    } else {\r\n        return crc32str(crc|0, input, input.length, 0);\r\n    }\r\n};\r\n\n\n//# sourceURL=webpack:///./lib/crc32.js?')},"./lib/defaults.js":function(module,exports,__webpack_require__){"use strict";eval("\r\nexports.base64 = false;\r\nexports.binary = false;\r\nexports.dir = false;\r\nexports.createFolders = true;\r\nexports.date = null;\r\nexports.compression = null;\r\nexports.compressionOptions = null;\r\nexports.comment = null;\r\nexports.unixPermissions = null;\r\nexports.dosPermissions = null;\r\n\n\n//# sourceURL=webpack:///./lib/defaults.js?")},"./lib/external.js":function(module,exports,__webpack_require__){"use strict";eval('/* global Promise */\r\n\r\n\r\n// load the global object first:\r\n// - it should be better integrated in the system (unhandledRejection in node)\r\n// - the environment may have a custom Promise implementation (see zone.js)\r\nvar ES6Promise = null;\r\nif (typeof Promise !== "undefined") {\r\n    ES6Promise = Promise;\r\n} else {\r\n    ES6Promise = __webpack_require__(/*! lie */ "./node_modules/lie/lib/browser.js");\r\n}\r\n\r\n/**\r\n * Let the user use/change some implementations.\r\n */\r\nmodule.exports = {\r\n    Promise: ES6Promise\r\n};\r\n\n\n//# sourceURL=webpack:///./lib/external.js?')},"./lib/flate.js":function(module,exports,__webpack_require__){"use strict";eval('\r\nvar USE_TYPEDARRAY = (typeof Uint8Array !== \'undefined\') && (typeof Uint16Array !== \'undefined\') && (typeof Uint32Array !== \'undefined\');\r\n\r\nvar pako = __webpack_require__(/*! pako */ "./node_modules/pako/index.js");\r\nvar utils = __webpack_require__(/*! ./utils */ "./lib/utils.js");\r\nvar GenericWorker = __webpack_require__(/*! ./stream/GenericWorker */ "./lib/stream/GenericWorker.js");\r\n\r\nvar ARRAY_TYPE = USE_TYPEDARRAY ? "uint8array" : "array";\r\n\r\nexports.magic = "\\x08\\x00";\r\n\r\n/**\r\n * Create a worker that uses pako to inflate/deflate.\r\n * @constructor\r\n * @param {String} action the name of the pako function to call : either "Deflate" or "Inflate".\r\n * @param {Object} options the options to use when (de)compressing.\r\n */\r\nfunction FlateWorker(action, options) {\r\n    GenericWorker.call(this, "FlateWorker/" + action);\r\n\r\n    this._pako = null;\r\n    this._pakoAction = action;\r\n    this._pakoOptions = options;\r\n    // the `meta` object from the last chunk received\r\n    // this allow this worker to pass around metadata\r\n    this.meta = {};\r\n}\r\n\r\nutils.inherits(FlateWorker, GenericWorker);\r\n\r\n/**\r\n * @see GenericWorker.processChunk\r\n */\r\nFlateWorker.prototype.processChunk = function (chunk) {\r\n    this.meta = chunk.meta;\r\n    if (this._pako === null) {\r\n        this._createPako();\r\n    }\r\n    this._pako.push(utils.transformTo(ARRAY_TYPE, chunk.data), false);\r\n};\r\n\r\n/**\r\n * @see GenericWorker.flush\r\n */\r\nFlateWorker.prototype.flush = function () {\r\n    GenericWorker.prototype.flush.call(this);\r\n    if (this._pako === null) {\r\n        this._createPako();\r\n    }\r\n    this._pako.push([], true);\r\n};\r\n/**\r\n * @see GenericWorker.cleanUp\r\n */\r\nFlateWorker.prototype.cleanUp = function () {\r\n    GenericWorker.prototype.cleanUp.call(this);\r\n    this._pako = null;\r\n};\r\n\r\n/**\r\n * Create the _pako object.\r\n * TODO: lazy-loading this object isn\'t the best solution but it\'s the\r\n * quickest. The best solution is to lazy-load the worker list. See also the\r\n * issue #446.\r\n */\r\nFlateWorker.prototype._createPako = function () {\r\n    this._pako = new pako[this._pakoAction]({\r\n        raw: true,\r\n        level: this._pakoOptions.level || -1 // default compression\r\n    });\r\n    var self = this;\r\n    this._pako.onData = function(data) {\r\n        self.push({\r\n            data : data,\r\n            meta : self.meta\r\n        });\r\n    };\r\n};\r\n\r\nexports.compressWorker = function (compressionOptions) {\r\n    return new FlateWorker("Deflate", compressionOptions);\r\n};\r\nexports.uncompressWorker = function () {\r\n    return new FlateWorker("Inflate", {});\r\n};\r\n\n\n//# sourceURL=webpack:///./lib/flate.js?')},"./lib/generate/ZipFileWorker.js":function(module,exports,__webpack_require__){"use strict";eval('\r\n\r\nvar utils = __webpack_require__(/*! ../utils */ "./lib/utils.js");\r\nvar GenericWorker = __webpack_require__(/*! ../stream/GenericWorker */ "./lib/stream/GenericWorker.js");\r\nvar utf8 = __webpack_require__(/*! ../utf8 */ "./lib/utf8.js");\r\nvar crc32 = __webpack_require__(/*! ../crc32 */ "./lib/crc32.js");\r\nvar signature = __webpack_require__(/*! ../signature */ "./lib/signature.js");\r\n\r\n/**\r\n * Transform an integer into a string in hexadecimal.\r\n * @private\r\n * @param {number} dec the number to convert.\r\n * @param {number} bytes the number of bytes to generate.\r\n * @returns {string} the result.\r\n */\r\nvar decToHex = function(dec, bytes) {\r\n    var hex = "", i;\r\n    for (i = 0; i < bytes; i++) {\r\n        hex += String.fromCharCode(dec & 0xff);\r\n        dec = dec >>> 8;\r\n    }\r\n    return hex;\r\n};\r\n\r\n/**\r\n * Generate the UNIX part of the external file attributes.\r\n * @param {Object} unixPermissions the unix permissions or null.\r\n * @param {Boolean} isDir true if the entry is a directory, false otherwise.\r\n * @return {Number} a 32 bit integer.\r\n *\r\n * adapted from http://unix.stackexchange.com/questions/14705/the-zip-formats-external-file-attribute :\r\n *\r\n * TTTTsstrwxrwxrwx0000000000ADVSHR\r\n * ^^^^____________________________ file type, see zipinfo.c (UNX_*)\r\n *     ^^^_________________________ setuid, setgid, sticky\r\n *        ^^^^^^^^^________________ permissions\r\n *                 ^^^^^^^^^^______ not used ?\r\n *                           ^^^^^^ DOS attribute bits : Archive, Directory, Volume label, System file, Hidden, Read only\r\n */\r\nvar generateUnixExternalFileAttr = function (unixPermissions, isDir) {\r\n\r\n    var result = unixPermissions;\r\n    if (!unixPermissions) {\r\n        // I can\'t use octal values in strict mode, hence the hexa.\r\n        //  040775 => 0x41fd\r\n        // 0100664 => 0x81b4\r\n        result = isDir ? 0x41fd : 0x81b4;\r\n    }\r\n    return (result & 0xFFFF) << 16;\r\n};\r\n\r\n/**\r\n * Generate the DOS part of the external file attributes.\r\n * @param {Object} dosPermissions the dos permissions or null.\r\n * @param {Boolean} isDir true if the entry is a directory, false otherwise.\r\n * @return {Number} a 32 bit integer.\r\n *\r\n * Bit 0     Read-Only\r\n * Bit 1     Hidden\r\n * Bit 2     System\r\n * Bit 3     Volume Label\r\n * Bit 4     Directory\r\n * Bit 5     Archive\r\n */\r\nvar generateDosExternalFileAttr = function (dosPermissions, isDir) {\r\n\r\n    // the dir flag is already set for compatibility\r\n    return (dosPermissions || 0)  & 0x3F;\r\n};\r\n\r\n/**\r\n * Generate the various parts used in the construction of the final zip file.\r\n * @param {Object} streamInfo the hash with informations about the compressed file.\r\n * @param {Boolean} streamedContent is the content streamed ?\r\n * @param {Boolean} streamingEnded is the stream finished ?\r\n * @param {number} offset the current offset from the start of the zip file.\r\n * @param {String} platform let\'s pretend we are this platform (change platform dependents fields)\r\n * @param {Function} encodeFileName the function to encode the file name / comment.\r\n * @return {Object} the zip parts.\r\n */\r\nvar generateZipParts = function(streamInfo, streamedContent, streamingEnded, offset, platform, encodeFileName) {\r\n    var file = streamInfo[\'file\'],\r\n    compression = streamInfo[\'compression\'],\r\n    useCustomEncoding = encodeFileName !== utf8.utf8encode,\r\n    encodedFileName = utils.transformTo("string", encodeFileName(file.name)),\r\n    utfEncodedFileName = utils.transformTo("string", utf8.utf8encode(file.name)),\r\n    comment = file.comment,\r\n    encodedComment = utils.transformTo("string", encodeFileName(comment)),\r\n    utfEncodedComment = utils.transformTo("string", utf8.utf8encode(comment)),\r\n    useUTF8ForFileName = utfEncodedFileName.length !== file.name.length,\r\n    useUTF8ForComment = utfEncodedComment.length !== comment.length,\r\n    dosTime,\r\n    dosDate,\r\n    extraFields = "",\r\n    unicodePathExtraField = "",\r\n    unicodeCommentExtraField = "",\r\n    dir = file.dir,\r\n    date = file.date;\r\n\r\n\r\n    var dataInfo = {\r\n        crc32 : 0,\r\n        compressedSize : 0,\r\n        uncompressedSize : 0\r\n    };\r\n\r\n    // if the content is streamed, the sizes/crc32 are only available AFTER\r\n    // the end of the stream.\r\n    if (!streamedContent || streamingEnded) {\r\n        dataInfo.crc32 = streamInfo[\'crc32\'];\r\n        dataInfo.compressedSize = streamInfo[\'compressedSize\'];\r\n        dataInfo.uncompressedSize = streamInfo[\'uncompressedSize\'];\r\n    }\r\n\r\n    var bitflag = 0;\r\n    if (streamedContent) {\r\n        // Bit 3: the sizes/crc32 are set to zero in the local header.\r\n        // The correct values are put in the data descriptor immediately\r\n        // following the compressed data.\r\n        bitflag |= 0x0008;\r\n    }\r\n    if (!useCustomEncoding && (useUTF8ForFileName || useUTF8ForComment)) {\r\n        // Bit 11: Language encoding flag (EFS).\r\n        bitflag |= 0x0800;\r\n    }\r\n\r\n\r\n    var extFileAttr = 0;\r\n    var versionMadeBy = 0;\r\n    if (dir) {\r\n        // dos or unix, we set the dos dir flag\r\n        extFileAttr |= 0x00010;\r\n    }\r\n    if(platform === "UNIX") {\r\n        versionMadeBy = 0x031E; // UNIX, version 3.0\r\n        extFileAttr |= generateUnixExternalFileAttr(file.unixPermissions, dir);\r\n    } else { // DOS or other, fallback to DOS\r\n        versionMadeBy = 0x0014; // DOS, version 2.0\r\n        extFileAttr |= generateDosExternalFileAttr(file.dosPermissions, dir);\r\n    }\r\n\r\n    // date\r\n    // @see http://www.delorie.com/djgpp/doc/rbinter/it/52/13.html\r\n    // @see http://www.delorie.com/djgpp/doc/rbinter/it/65/16.html\r\n    // @see http://www.delorie.com/djgpp/doc/rbinter/it/66/16.html\r\n\r\n    dosTime = date.getUTCHours();\r\n    dosTime = dosTime << 6;\r\n    dosTime = dosTime | date.getUTCMinutes();\r\n    dosTime = dosTime << 5;\r\n    dosTime = dosTime | date.getUTCSeconds() / 2;\r\n\r\n    dosDate = date.getUTCFullYear() - 1980;\r\n    dosDate = dosDate << 4;\r\n    dosDate = dosDate | (date.getUTCMonth() + 1);\r\n    dosDate = dosDate << 5;\r\n    dosDate = dosDate | date.getUTCDate();\r\n\r\n    if (useUTF8ForFileName) {\r\n        // set the unicode path extra field. unzip needs at least one extra\r\n        // field to correctly handle unicode path, so using the path is as good\r\n        // as any other information. This could improve the situation with\r\n        // other archive managers too.\r\n        // This field is usually used without the utf8 flag, with a non\r\n        // unicode path in the header (winrar, winzip). This helps (a bit)\r\n        // with the messy Windows\' default compressed folders feature but\r\n        // breaks on p7zip which doesn\'t seek the unicode path extra field.\r\n        // So for now, UTF-8 everywhere !\r\n        unicodePathExtraField =\r\n            // Version\r\n            decToHex(1, 1) +\r\n            // NameCRC32\r\n            decToHex(crc32(encodedFileName), 4) +\r\n            // UnicodeName\r\n            utfEncodedFileName;\r\n\r\n        extraFields +=\r\n            // Info-ZIP Unicode Path Extra Field\r\n            "\\x75\\x70" +\r\n            // size\r\n            decToHex(unicodePathExtraField.length, 2) +\r\n            // content\r\n            unicodePathExtraField;\r\n    }\r\n\r\n    if(useUTF8ForComment) {\r\n\r\n        unicodeCommentExtraField =\r\n            // Version\r\n            decToHex(1, 1) +\r\n            // CommentCRC32\r\n            decToHex(crc32(encodedComment), 4) +\r\n            // UnicodeName\r\n            utfEncodedComment;\r\n\r\n        extraFields +=\r\n            // Info-ZIP Unicode Path Extra Field\r\n            "\\x75\\x63" +\r\n            // size\r\n            decToHex(unicodeCommentExtraField.length, 2) +\r\n            // content\r\n            unicodeCommentExtraField;\r\n    }\r\n\r\n    var header = "";\r\n\r\n    // version needed to extract\r\n    header += "\\x0A\\x00";\r\n    // general purpose bit flag\r\n    header += decToHex(bitflag, 2);\r\n    // compression method\r\n    header += compression.magic;\r\n    // last mod file time\r\n    header += decToHex(dosTime, 2);\r\n    // last mod file date\r\n    header += decToHex(dosDate, 2);\r\n    // crc-32\r\n    header += decToHex(dataInfo.crc32, 4);\r\n    // compressed size\r\n    header += decToHex(dataInfo.compressedSize, 4);\r\n    // uncompressed size\r\n    header += decToHex(dataInfo.uncompressedSize, 4);\r\n    // file name length\r\n    header += decToHex(encodedFileName.length, 2);\r\n    // extra field length\r\n    header += decToHex(extraFields.length, 2);\r\n\r\n\r\n    var fileRecord = signature.LOCAL_FILE_HEADER + header + encodedFileName + extraFields;\r\n\r\n    var dirRecord = signature.CENTRAL_FILE_HEADER +\r\n        // version made by (00: DOS)\r\n        decToHex(versionMadeBy, 2) +\r\n        // file header (common to file and central directory)\r\n        header +\r\n        // file comment length\r\n        decToHex(encodedComment.length, 2) +\r\n        // disk number start\r\n        "\\x00\\x00" +\r\n        // internal file attributes TODO\r\n        "\\x00\\x00" +\r\n        // external file attributes\r\n        decToHex(extFileAttr, 4) +\r\n        // relative offset of local header\r\n        decToHex(offset, 4) +\r\n        // file name\r\n        encodedFileName +\r\n        // extra field\r\n        extraFields +\r\n        // file comment\r\n        encodedComment;\r\n\r\n    return {\r\n        fileRecord: fileRecord,\r\n        dirRecord: dirRecord\r\n    };\r\n};\r\n\r\n/**\r\n * Generate the EOCD record.\r\n * @param {Number} entriesCount the number of entries in the zip file.\r\n * @param {Number} centralDirLength the length (in bytes) of the central dir.\r\n * @param {Number} localDirLength the length (in bytes) of the local dir.\r\n * @param {String} comment the zip file comment as a binary string.\r\n * @param {Function} encodeFileName the function to encode the comment.\r\n * @return {String} the EOCD record.\r\n */\r\nvar generateCentralDirectoryEnd = function (entriesCount, centralDirLength, localDirLength, comment, encodeFileName) {\r\n    var dirEnd = "";\r\n    var encodedComment = utils.transformTo("string", encodeFileName(comment));\r\n\r\n    // end of central dir signature\r\n    dirEnd = signature.CENTRAL_DIRECTORY_END +\r\n        // number of this disk\r\n        "\\x00\\x00" +\r\n        // number of the disk with the start of the central directory\r\n        "\\x00\\x00" +\r\n        // total number of entries in the central directory on this disk\r\n        decToHex(entriesCount, 2) +\r\n        // total number of entries in the central directory\r\n        decToHex(entriesCount, 2) +\r\n        // size of the central directory   4 bytes\r\n        decToHex(centralDirLength, 4) +\r\n        // offset of start of central directory with respect to the starting disk number\r\n        decToHex(localDirLength, 4) +\r\n        // .ZIP file comment length\r\n        decToHex(encodedComment.length, 2) +\r\n        // .ZIP file comment\r\n        encodedComment;\r\n\r\n    return dirEnd;\r\n};\r\n\r\n/**\r\n * Generate data descriptors for a file entry.\r\n * @param {Object} streamInfo the hash generated by a worker, containing informations\r\n * on the file entry.\r\n * @return {String} the data descriptors.\r\n */\r\nvar generateDataDescriptors = function (streamInfo) {\r\n    var descriptor = "";\r\n    descriptor = signature.DATA_DESCRIPTOR +\r\n        // crc-32                          4 bytes\r\n        decToHex(streamInfo[\'crc32\'], 4) +\r\n        // compressed size                 4 bytes\r\n        decToHex(streamInfo[\'compressedSize\'], 4) +\r\n        // uncompressed size               4 bytes\r\n        decToHex(streamInfo[\'uncompressedSize\'], 4);\r\n\r\n    return descriptor;\r\n};\r\n\r\n\r\n/**\r\n * A worker to concatenate other workers to create a zip file.\r\n * @param {Boolean} streamFiles `true` to stream the content of the files,\r\n * `false` to accumulate it.\r\n * @param {String} comment the comment to use.\r\n * @param {String} platform the platform to use, "UNIX" or "DOS".\r\n * @param {Function} encodeFileName the function to encode file names and comments.\r\n */\r\nfunction ZipFileWorker(streamFiles, comment, platform, encodeFileName) {\r\n    GenericWorker.call(this, "ZipFileWorker");\r\n    // The number of bytes written so far. This doesn\'t count accumulated chunks.\r\n    this.bytesWritten = 0;\r\n    // The comment of the zip file\r\n    this.zipComment = comment;\r\n    // The platform "generating" the zip file.\r\n    this.zipPlatform = platform;\r\n    // the function to encode file names and comments.\r\n    this.encodeFileName = encodeFileName;\r\n    // Should we stream the content of the files ?\r\n    this.streamFiles = streamFiles;\r\n    // If `streamFiles` is false, we will need to accumulate the content of the\r\n    // files to calculate sizes / crc32 (and write them *before* the content).\r\n    // This boolean indicates if we are accumulating chunks (it will change a lot\r\n    // during the lifetime of this worker).\r\n    this.accumulate = false;\r\n    // The buffer receiving chunks when accumulating content.\r\n    this.contentBuffer = [];\r\n    // The list of generated directory records.\r\n    this.dirRecords = [];\r\n    // The offset (in bytes) from the beginning of the zip file for the current source.\r\n    this.currentSourceOffset = 0;\r\n    // The total number of entries in this zip file.\r\n    this.entriesCount = 0;\r\n    // the name of the file currently being added, null when handling the end of the zip file.\r\n    // Used for the emited metadata.\r\n    this.currentFile = null;\r\n\r\n\r\n\r\n    this._sources = [];\r\n}\r\nutils.inherits(ZipFileWorker, GenericWorker);\r\n\r\n/**\r\n * @see GenericWorker.push\r\n */\r\nZipFileWorker.prototype.push = function (chunk) {\r\n\r\n    var currentFilePercent = chunk.meta.percent || 0;\r\n    var entriesCount = this.entriesCount;\r\n    var remainingFiles = this._sources.length;\r\n\r\n    if(this.accumulate) {\r\n        this.contentBuffer.push(chunk);\r\n    } else {\r\n        this.bytesWritten += chunk.data.length;\r\n\r\n        GenericWorker.prototype.push.call(this, {\r\n            data : chunk.data,\r\n            meta : {\r\n                currentFile : this.currentFile,\r\n                percent : entriesCount ? (currentFilePercent + 100 * (entriesCount - remainingFiles - 1)) / entriesCount : 100\r\n            }\r\n        });\r\n    }\r\n};\r\n\r\n/**\r\n * The worker started a new source (an other worker).\r\n * @param {Object} streamInfo the streamInfo object from the new source.\r\n */\r\nZipFileWorker.prototype.openedSource = function (streamInfo) {\r\n    this.currentSourceOffset = this.bytesWritten;\r\n    this.currentFile = streamInfo[\'file\'].name;\r\n\r\n    var streamedContent = this.streamFiles && !streamInfo[\'file\'].dir;\r\n\r\n    // don\'t stream folders (because they don\'t have any content)\r\n    if(streamedContent) {\r\n        var record = generateZipParts(streamInfo, streamedContent, false, this.currentSourceOffset, this.zipPlatform, this.encodeFileName);\r\n        this.push({\r\n            data : record.fileRecord,\r\n            meta : {percent:0}\r\n        });\r\n    } else {\r\n        // we need to wait for the whole file before pushing anything\r\n        this.accumulate = true;\r\n    }\r\n};\r\n\r\n/**\r\n * The worker finished a source (an other worker).\r\n * @param {Object} streamInfo the streamInfo object from the finished source.\r\n */\r\nZipFileWorker.prototype.closedSource = function (streamInfo) {\r\n    this.accumulate = false;\r\n    var streamedContent = this.streamFiles && !streamInfo[\'file\'].dir;\r\n    var record = generateZipParts(streamInfo, streamedContent, true, this.currentSourceOffset, this.zipPlatform, this.encodeFileName);\r\n\r\n    this.dirRecords.push(record.dirRecord);\r\n    if(streamedContent) {\r\n        // after the streamed file, we put data descriptors\r\n        this.push({\r\n            data : generateDataDescriptors(streamInfo),\r\n            meta : {percent:100}\r\n        });\r\n    } else {\r\n        // the content wasn\'t streamed, we need to push everything now\r\n        // first the file record, then the content\r\n        this.push({\r\n            data : record.fileRecord,\r\n            meta : {percent:0}\r\n        });\r\n        while(this.contentBuffer.length) {\r\n            this.push(this.contentBuffer.shift());\r\n        }\r\n    }\r\n    this.currentFile = null;\r\n};\r\n\r\n/**\r\n * @see GenericWorker.flush\r\n */\r\nZipFileWorker.prototype.flush = function () {\r\n\r\n    var localDirLength = this.bytesWritten;\r\n    for(var i = 0; i < this.dirRecords.length; i++) {\r\n        this.push({\r\n            data : this.dirRecords[i],\r\n            meta : {percent:100}\r\n        });\r\n    }\r\n    var centralDirLength = this.bytesWritten - localDirLength;\r\n\r\n    var dirEnd = generateCentralDirectoryEnd(this.dirRecords.length, centralDirLength, localDirLength, this.zipComment, this.encodeFileName);\r\n\r\n    this.push({\r\n        data : dirEnd,\r\n        meta : {percent:100}\r\n    });\r\n};\r\n\r\n/**\r\n * Prepare the next source to be read.\r\n */\r\nZipFileWorker.prototype.prepareNextSource = function () {\r\n    this.previous = this._sources.shift();\r\n    this.openedSource(this.previous.streamInfo);\r\n    if (this.isPaused) {\r\n        this.previous.pause();\r\n    } else {\r\n        this.previous.resume();\r\n    }\r\n};\r\n\r\n/**\r\n * @see GenericWorker.registerPrevious\r\n */\r\nZipFileWorker.prototype.registerPrevious = function (previous) {\r\n    this._sources.push(previous);\r\n    var self = this;\r\n\r\n    previous.on(\'data\', function (chunk) {\r\n        self.processChunk(chunk);\r\n    });\r\n    previous.on(\'end\', function () {\r\n        self.closedSource(self.previous.streamInfo);\r\n        if(self._sources.length) {\r\n            self.prepareNextSource();\r\n        } else {\r\n            self.end();\r\n        }\r\n    });\r\n    previous.on(\'error\', function (e) {\r\n        self.error(e);\r\n    });\r\n    return this;\r\n};\r\n\r\n/**\r\n * @see GenericWorker.resume\r\n */\r\nZipFileWorker.prototype.resume = function () {\r\n    if(!GenericWorker.prototype.resume.call(this)) {\r\n        return false;\r\n    }\r\n\r\n    if (!this.previous && this._sources.length) {\r\n        this.prepareNextSource();\r\n        return true;\r\n    }\r\n    if (!this.previous && !this._sources.length && !this.generatedError) {\r\n        this.end();\r\n        return true;\r\n    }\r\n};\r\n\r\n/**\r\n * @see GenericWorker.error\r\n */\r\nZipFileWorker.prototype.error = function (e) {\r\n    var sources = this._sources;\r\n    if(!GenericWorker.prototype.error.call(this, e)) {\r\n        return false;\r\n    }\r\n    for(var i = 0; i < sources.length; i++) {\r\n        try {\r\n            sources[i].error(e);\r\n        } catch(e) {\r\n            // the `error` exploded, nothing to do\r\n        }\r\n    }\r\n    return true;\r\n};\r\n\r\n/**\r\n * @see GenericWorker.lock\r\n */\r\nZipFileWorker.prototype.lock = function () {\r\n    GenericWorker.prototype.lock.call(this);\r\n    var sources = this._sources;\r\n    for(var i = 0; i < sources.length; i++) {\r\n        sources[i].lock();\r\n    }\r\n};\r\n\r\nmodule.exports = ZipFileWorker;\r\n\n\n//# sourceURL=webpack:///./lib/generate/ZipFileWorker.js?')},"./lib/generate/index.js":function(module,exports,__webpack_require__){"use strict"
;eval('\r\n\r\nvar compressions = __webpack_require__(/*! ../compressions */ "./lib/compressions.js");\r\nvar ZipFileWorker = __webpack_require__(/*! ./ZipFileWorker */ "./lib/generate/ZipFileWorker.js");\r\n\r\n/**\r\n * Find the compression to use.\r\n * @param {String} fileCompression the compression defined at the file level, if any.\r\n * @param {String} zipCompression the compression defined at the load() level.\r\n * @return {Object} the compression object to use.\r\n */\r\nvar getCompression = function (fileCompression, zipCompression) {\r\n\r\n    var compressionName = fileCompression || zipCompression;\r\n    var compression = compressions[compressionName];\r\n    if (!compression) {\r\n        throw new Error(compressionName + " is not a valid compression method !");\r\n    }\r\n    return compression;\r\n};\r\n\r\n/**\r\n * Create a worker to generate a zip file.\r\n * @param {JSZip} zip the JSZip instance at the right root level.\r\n * @param {Object} options to generate the zip file.\r\n * @param {String} comment the comment to use.\r\n */\r\nexports.generateWorker = function (zip, options, comment) {\r\n\r\n    var zipFileWorker = new ZipFileWorker(options.streamFiles, comment, options.platform, options.encodeFileName);\r\n    var entriesCount = 0;\r\n    try {\r\n\r\n        zip.forEach(function (relativePath, file) {\r\n            entriesCount++;\r\n            var compression = getCompression(file.options.compression, options.compression);\r\n            var compressionOptions = file.options.compressionOptions || options.compressionOptions || {};\r\n            var dir = file.dir, date = file.date;\r\n\r\n            file._compressWorker(compression, compressionOptions)\r\n            .withStreamInfo("file", {\r\n                name : relativePath,\r\n                dir : dir,\r\n                date : date,\r\n                comment : file.comment || "",\r\n                unixPermissions : file.unixPermissions,\r\n                dosPermissions : file.dosPermissions\r\n            })\r\n            .pipe(zipFileWorker);\r\n        });\r\n        zipFileWorker.entriesCount = entriesCount;\r\n    } catch (e) {\r\n        zipFileWorker.error(e);\r\n    }\r\n\r\n    return zipFileWorker;\r\n};\r\n\n\n//# sourceURL=webpack:///./lib/generate/index.js?')},"./lib/index.js":function(module,exports,__webpack_require__){"use strict";eval('\r\n\r\n/**\r\n * Representation a of zip file in js\r\n * @constructor\r\n */\r\nfunction JSZip() {\r\n    // if this constructor is used without `new`, it adds `new` before itself:\r\n    if(!(this instanceof JSZip)) {\r\n        return new JSZip();\r\n    }\r\n\r\n    if(arguments.length) {\r\n        throw new Error("The constructor with parameters has been removed in JSZip 3.0, please check the upgrade guide.");\r\n    }\r\n\r\n    // object containing the files :\r\n    // {\r\n    //   "folder/" : {...},\r\n    //   "folder/data.txt" : {...}\r\n    // }\r\n    this.files = {};\r\n\r\n    this.comment = null;\r\n\r\n    // Where we are in the hierarchy\r\n    this.root = "";\r\n    this.clone = function() {\r\n        var newObj = new JSZip();\r\n        for (var i in this) {\r\n            if (typeof this[i] !== "function") {\r\n                newObj[i] = this[i];\r\n            }\r\n        }\r\n        return newObj;\r\n    };\r\n}\r\nJSZip.prototype = __webpack_require__(/*! ./object */ "./lib/object.js");\r\nJSZip.prototype.loadAsync = __webpack_require__(/*! ./load */ "./lib/load.js");\r\nJSZip.support = __webpack_require__(/*! ./support */ "./lib/support.js");\r\nJSZip.defaults = __webpack_require__(/*! ./defaults */ "./lib/defaults.js");\r\n\r\n// TODO find a better way to handle this version,\r\n// a require(\'package.json\').version doesn\'t work with webpack, see #327\r\nJSZip.version = "3.2.0";\r\n\r\nJSZip.loadAsync = function (content, options) {\r\n    return new JSZip().loadAsync(content, options);\r\n};\r\n\r\nJSZip.external = __webpack_require__(/*! ./external */ "./lib/external.js");\r\nmodule.exports = JSZip;\r\n\n\n//# sourceURL=webpack:///./lib/index.js?')},"./lib/load.js":function(module,exports,__webpack_require__){"use strict";eval('\r\nvar utils = __webpack_require__(/*! ./utils */ "./lib/utils.js");\r\nvar external = __webpack_require__(/*! ./external */ "./lib/external.js");\r\nvar utf8 = __webpack_require__(/*! ./utf8 */ "./lib/utf8.js");\r\nvar utils = __webpack_require__(/*! ./utils */ "./lib/utils.js");\r\nvar ZipEntries = __webpack_require__(/*! ./zipEntries */ "./lib/zipEntries.js");\r\nvar Crc32Probe = __webpack_require__(/*! ./stream/Crc32Probe */ "./lib/stream/Crc32Probe.js");\r\nvar nodejsUtils = __webpack_require__(/*! ./nodejsUtils */ "./lib/nodejsUtils.js");\r\n\r\n/**\r\n * Check the CRC32 of an entry.\r\n * @param {ZipEntry} zipEntry the zip entry to check.\r\n * @return {Promise} the result.\r\n */\r\nfunction checkEntryCRC32(zipEntry) {\r\n    return new external.Promise(function (resolve, reject) {\r\n        var worker = zipEntry.decompressed.getContentWorker().pipe(new Crc32Probe());\r\n        worker.on("error", function (e) {\r\n            reject(e);\r\n        })\r\n        .on("end", function () {\r\n            if (worker.streamInfo.crc32 !== zipEntry.decompressed.crc32) {\r\n                reject(new Error("Corrupted zip : CRC32 mismatch"));\r\n            } else {\r\n                resolve();\r\n            }\r\n        })\r\n        .resume();\r\n    });\r\n}\r\n\r\nmodule.exports = function(data, options) {\r\n    var zip = this;\r\n    options = utils.extend(options || {}, {\r\n        base64: false,\r\n        checkCRC32: false,\r\n        optimizedBinaryString: false,\r\n        createFolders: false,\r\n        decodeFileName: utf8.utf8decode\r\n    });\r\n\r\n    if (nodejsUtils.isNode && nodejsUtils.isStream(data)) {\r\n        return external.Promise.reject(new Error("JSZip can\'t accept a stream when loading a zip file."));\r\n    }\r\n\r\n    return utils.prepareContent("the loaded zip file", data, true, options.optimizedBinaryString, options.base64)\r\n    .then(function(data) {\r\n        var zipEntries = new ZipEntries(options);\r\n        zipEntries.load(data);\r\n        return zipEntries;\r\n    }).then(function checkCRC32(zipEntries) {\r\n        var promises = [external.Promise.resolve(zipEntries)];\r\n        var files = zipEntries.files;\r\n        if (options.checkCRC32) {\r\n            for (var i = 0; i < files.length; i++) {\r\n                promises.push(checkEntryCRC32(files[i]));\r\n            }\r\n        }\r\n        return external.Promise.all(promises);\r\n    }).then(function addFiles(results) {\r\n        var zipEntries = results.shift();\r\n        var files = zipEntries.files;\r\n        for (var i = 0; i < files.length; i++) {\r\n            var input = files[i];\r\n            zip.file(input.fileNameStr, input.decompressed, {\r\n                binary: true,\r\n                optimizedBinaryString: true,\r\n                date: input.date,\r\n                dir: input.dir,\r\n                comment : input.fileCommentStr.length ? input.fileCommentStr : null,\r\n                unixPermissions : input.unixPermissions,\r\n                dosPermissions : input.dosPermissions,\r\n                createFolders: options.createFolders\r\n            });\r\n        }\r\n        if (zipEntries.zipComment.length) {\r\n            zip.comment = zipEntries.zipComment;\r\n        }\r\n\r\n        return zip;\r\n    });\r\n};\r\n\n\n//# sourceURL=webpack:///./lib/load.js?')},"./lib/nodejs/NodejsStreamInputAdapter.js":function(module,exports,__webpack_require__){"use strict";eval('\r\n\r\nvar utils = __webpack_require__(/*! ../utils */ "./lib/utils.js");\r\nvar GenericWorker = __webpack_require__(/*! ../stream/GenericWorker */ "./lib/stream/GenericWorker.js");\r\n\r\n/**\r\n * A worker that use a nodejs stream as source.\r\n * @constructor\r\n * @param {String} filename the name of the file entry for this stream.\r\n * @param {Readable} stream the nodejs stream.\r\n */\r\nfunction NodejsStreamInputAdapter(filename, stream) {\r\n    GenericWorker.call(this, "Nodejs stream input adapter for " + filename);\r\n    this._upstreamEnded = false;\r\n    this._bindStream(stream);\r\n}\r\n\r\nutils.inherits(NodejsStreamInputAdapter, GenericWorker);\r\n\r\n/**\r\n * Prepare the stream and bind the callbacks on it.\r\n * Do this ASAP on node 0.10 ! A lazy binding doesn\'t always work.\r\n * @param {Stream} stream the nodejs stream to use.\r\n */\r\nNodejsStreamInputAdapter.prototype._bindStream = function (stream) {\r\n    var self = this;\r\n    this._stream = stream;\r\n    stream.pause();\r\n    stream\r\n    .on("data", function (chunk) {\r\n        self.push({\r\n            data: chunk,\r\n            meta : {\r\n                percent : 0\r\n            }\r\n        });\r\n    })\r\n    .on("error", function (e) {\r\n        if(self.isPaused) {\r\n            this.generatedError = e;\r\n        } else {\r\n            self.error(e);\r\n        }\r\n    })\r\n    .on("end", function () {\r\n        if(self.isPaused) {\r\n            self._upstreamEnded = true;\r\n        } else {\r\n            self.end();\r\n        }\r\n    });\r\n};\r\nNodejsStreamInputAdapter.prototype.pause = function () {\r\n    if(!GenericWorker.prototype.pause.call(this)) {\r\n        return false;\r\n    }\r\n    this._stream.pause();\r\n    return true;\r\n};\r\nNodejsStreamInputAdapter.prototype.resume = function () {\r\n    if(!GenericWorker.prototype.resume.call(this)) {\r\n        return false;\r\n    }\r\n\r\n    if(this._upstreamEnded) {\r\n        this.end();\r\n    } else {\r\n        this._stream.resume();\r\n    }\r\n\r\n    return true;\r\n};\r\n\r\nmodule.exports = NodejsStreamInputAdapter;\r\n\n\n//# sourceURL=webpack:///./lib/nodejs/NodejsStreamInputAdapter.js?')},"./lib/nodejs/NodejsStreamOutputAdapter.js":function(module,exports,__webpack_require__){"use strict";eval('\r\n\r\nvar Readable = __webpack_require__(/*! readable-stream */ "./lib/readable-stream-browser.js").Readable;\r\n\r\nvar utils = __webpack_require__(/*! ../utils */ "./lib/utils.js");\r\nutils.inherits(NodejsStreamOutputAdapter, Readable);\r\n\r\n/**\r\n* A nodejs stream using a worker as source.\r\n* @see the SourceWrapper in http://nodejs.org/api/stream.html\r\n* @constructor\r\n* @param {StreamHelper} helper the helper wrapping the worker\r\n* @param {Object} options the nodejs stream options\r\n* @param {Function} updateCb the update callback.\r\n*/\r\nfunction NodejsStreamOutputAdapter(helper, options, updateCb) {\r\n    Readable.call(this, options);\r\n    this._helper = helper;\r\n\r\n    var self = this;\r\n    helper.on("data", function (data, meta) {\r\n        if (!self.push(data)) {\r\n            self._helper.pause();\r\n        }\r\n        if(updateCb) {\r\n            updateCb(meta);\r\n        }\r\n    })\r\n    .on("error", function(e) {\r\n        self.emit(\'error\', e);\r\n    })\r\n    .on("end", function () {\r\n        self.push(null);\r\n    });\r\n}\r\n\r\n\r\nNodejsStreamOutputAdapter.prototype._read = function() {\r\n    this._helper.resume();\r\n};\r\n\r\nmodule.exports = NodejsStreamOutputAdapter;\r\n\n\n//# sourceURL=webpack:///./lib/nodejs/NodejsStreamOutputAdapter.js?')},"./lib/nodejsUtils.js":function(module,exports,__webpack_require__){"use strict";eval('/* WEBPACK VAR INJECTION */(function(Buffer) {\r\n\r\nmodule.exports = {\r\n    /**\r\n     * True if this is running in Nodejs, will be undefined in a browser.\r\n     * In a browser, browserify won\'t include this file and the whole module\r\n     * will be resolved an empty object.\r\n     */\r\n    isNode : typeof Buffer !== "undefined",\r\n    /**\r\n     * Create a new nodejs Buffer from an existing content.\r\n     * @param {Object} data the data to pass to the constructor.\r\n     * @param {String} encoding the encoding to use.\r\n     * @return {Buffer} a new Buffer.\r\n     */\r\n    newBufferFrom: function(data, encoding) {\r\n        if (Buffer.from && Buffer.from !== Uint8Array.from) {\r\n            return Buffer.from(data, encoding);\r\n        } else {\r\n            if (typeof data === "number") {\r\n                // Safeguard for old Node.js versions. On newer versions,\r\n                // Buffer.from(number) / Buffer(number, encoding) already throw.\r\n                throw new Error("The \\"data\\" argument must not be a number");\r\n            }\r\n            return new Buffer(data, encoding);\r\n        }\r\n    },\r\n    /**\r\n     * Create a new nodejs Buffer with the specified size.\r\n     * @param {Integer} size the size of the buffer.\r\n     * @return {Buffer} a new Buffer.\r\n     */\r\n    allocBuffer: function (size) {\r\n        if (Buffer.alloc) {\r\n            return Buffer.alloc(size);\r\n        } else {\r\n            var buf = new Buffer(size);\r\n            buf.fill(0);\r\n            return buf;\r\n        }\r\n    },\r\n    /**\r\n     * Find out if an object is a Buffer.\r\n     * @param {Object} b the object to test.\r\n     * @return {Boolean} true if the object is a Buffer, false otherwise.\r\n     */\r\n    isBuffer : function(b){\r\n        return Buffer.isBuffer(b);\r\n    },\r\n\r\n    isStream : function (obj) {\r\n        return obj &&\r\n            typeof obj.on === "function" &&\r\n            typeof obj.pause === "function" &&\r\n            typeof obj.resume === "function";\r\n    }\r\n};\r\n\n/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! ./../node_modules/buffer/index.js */ "./node_modules/buffer/index.js").Buffer))\n\n//# sourceURL=webpack:///./lib/nodejsUtils.js?')},"./lib/object.js":function(module,exports,__webpack_require__){"use strict";eval('\r\nvar utf8 = __webpack_require__(/*! ./utf8 */ "./lib/utf8.js");\r\nvar utils = __webpack_require__(/*! ./utils */ "./lib/utils.js");\r\nvar GenericWorker = __webpack_require__(/*! ./stream/GenericWorker */ "./lib/stream/GenericWorker.js");\r\nvar StreamHelper = __webpack_require__(/*! ./stream/StreamHelper */ "./lib/stream/StreamHelper.js");\r\nvar defaults = __webpack_require__(/*! ./defaults */ "./lib/defaults.js");\r\nvar CompressedObject = __webpack_require__(/*! ./compressedObject */ "./lib/compressedObject.js");\r\nvar ZipObject = __webpack_require__(/*! ./zipObject */ "./lib/zipObject.js");\r\nvar generate = __webpack_require__(/*! ./generate */ "./lib/generate/index.js");\r\nvar nodejsUtils = __webpack_require__(/*! ./nodejsUtils */ "./lib/nodejsUtils.js");\r\nvar NodejsStreamInputAdapter = __webpack_require__(/*! ./nodejs/NodejsStreamInputAdapter */ "./lib/nodejs/NodejsStreamInputAdapter.js");\r\n\r\n\r\n/**\r\n * Add a file in the current folder.\r\n * @private\r\n * @param {string} name the name of the file\r\n * @param {String|ArrayBuffer|Uint8Array|Buffer} data the data of the file\r\n * @param {Object} originalOptions the options of the file\r\n * @return {Object} the new file.\r\n */\r\nvar fileAdd = function(name, data, originalOptions) {\r\n    // be sure sub folders exist\r\n    var dataType = utils.getTypeOf(data),\r\n        parent;\r\n\r\n\r\n    /*\r\n     * Correct options.\r\n     */\r\n\r\n    var o = utils.extend(originalOptions || {}, defaults);\r\n    o.date = o.date || new Date();\r\n    if (o.compression !== null) {\r\n        o.compression = o.compression.toUpperCase();\r\n    }\r\n\r\n    if (typeof o.unixPermissions === "string") {\r\n        o.unixPermissions = parseInt(o.unixPermissions, 8);\r\n    }\r\n\r\n    // UNX_IFDIR  0040000 see zipinfo.c\r\n    if (o.unixPermissions && (o.unixPermissions & 0x4000)) {\r\n        o.dir = true;\r\n    }\r\n    // Bit 4    Directory\r\n    if (o.dosPermissions && (o.dosPermissions & 0x0010)) {\r\n        o.dir = true;\r\n    }\r\n\r\n    if (o.dir) {\r\n        name = forceTrailingSlash(name);\r\n    }\r\n    if (o.createFolders && (parent = parentFolder(name))) {\r\n        folderAdd.call(this, parent, true);\r\n    }\r\n\r\n    var isUnicodeString = dataType === "string" && o.binary === false && o.base64 === false;\r\n    if (!originalOptions || typeof originalOptions.binary === "undefined") {\r\n        o.binary = !isUnicodeString;\r\n    }\r\n\r\n\r\n    var isCompressedEmpty = (data instanceof CompressedObject) && data.uncompressedSize === 0;\r\n\r\n    if (isCompressedEmpty || o.dir || !data || data.length === 0) {\r\n        o.base64 = false;\r\n        o.binary = true;\r\n        data = "";\r\n        o.compression = "STORE";\r\n        dataType = "string";\r\n    }\r\n\r\n    /*\r\n     * Convert content to fit.\r\n     */\r\n\r\n    var zipObjectContent = null;\r\n    if (data instanceof CompressedObject || data instanceof GenericWorker) {\r\n        zipObjectContent = data;\r\n    } else if (nodejsUtils.isNode && nodejsUtils.isStream(data)) {\r\n        zipObjectContent = new NodejsStreamInputAdapter(name, data);\r\n    } else {\r\n        zipObjectContent = utils.prepareContent(name, data, o.binary, o.optimizedBinaryString, o.base64);\r\n    }\r\n\r\n    var object = new ZipObject(name, zipObjectContent, o);\r\n    this.files[name] = object;\r\n    /*\r\n    TODO: we can\'t throw an exception because we have async promises\r\n    (we can have a promise of a Date() for example) but returning a\r\n    promise is useless because file(name, data) returns the JSZip\r\n    object for chaining. Should we break that to allow the user\r\n    to catch the error ?\r\n\r\n    return external.Promise.resolve(zipObjectContent)\r\n    .then(function () {\r\n        return object;\r\n    });\r\n    */\r\n};\r\n\r\n/**\r\n * Find the parent folder of the path.\r\n * @private\r\n * @param {string} path the path to use\r\n * @return {string} the parent folder, or ""\r\n */\r\nvar parentFolder = function (path) {\r\n    if (path.slice(-1) === \'/\') {\r\n        path = path.substring(0, path.length - 1);\r\n    }\r\n    var lastSlash = path.lastIndexOf(\'/\');\r\n    return (lastSlash > 0) ? path.substring(0, lastSlash) : "";\r\n};\r\n\r\n/**\r\n * Returns the path with a slash at the end.\r\n * @private\r\n * @param {String} path the path to check.\r\n * @return {String} the path with a trailing slash.\r\n */\r\nvar forceTrailingSlash = function(path) {\r\n    // Check the name ends with a /\r\n    if (path.slice(-1) !== "/") {\r\n        path += "/"; // IE doesn\'t like substr(-1)\r\n    }\r\n    return path;\r\n};\r\n\r\n/**\r\n * Add a (sub) folder in the current folder.\r\n * @private\r\n * @param {string} name the folder\'s name\r\n * @param {boolean=} [createFolders] If true, automatically create sub\r\n *  folders. Defaults to false.\r\n * @return {Object} the new folder.\r\n */\r\nvar folderAdd = function(name, createFolders) {\r\n    createFolders = (typeof createFolders !== \'undefined\') ? createFolders : defaults.createFolders;\r\n\r\n    name = forceTrailingSlash(name);\r\n\r\n    // Does this folder already exist?\r\n    if (!this.files[name]) {\r\n        fileAdd.call(this, name, null, {\r\n            dir: true,\r\n            createFolders: createFolders\r\n        });\r\n    }\r\n    return this.files[name];\r\n};\r\n\r\n/**\r\n* Cross-window, cross-Node-context regular expression detection\r\n* @param  {Object}  object Anything\r\n* @return {Boolean}        true if the object is a regular expression,\r\n* false otherwise\r\n*/\r\nfunction isRegExp(object) {\r\n    return Object.prototype.toString.call(object) === "[object RegExp]";\r\n}\r\n\r\n// return the actual prototype of JSZip\r\nvar out = {\r\n    /**\r\n     * @see loadAsync\r\n     */\r\n    load: function() {\r\n        throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.");\r\n    },\r\n\r\n\r\n    /**\r\n     * Call a callback function for each entry at this folder level.\r\n     * @param {Function} cb the callback function:\r\n     * function (relativePath, file) {...}\r\n     * It takes 2 arguments : the relative path and the file.\r\n     */\r\n    forEach: function(cb) {\r\n        var filename, relativePath, file;\r\n        for (filename in this.files) {\r\n            if (!this.files.hasOwnProperty(filename)) {\r\n                continue;\r\n            }\r\n            file = this.files[filename];\r\n            relativePath = filename.slice(this.root.length, filename.length);\r\n            if (relativePath && filename.slice(0, this.root.length) === this.root) { // the file is in the current root\r\n                cb(relativePath, file); // TODO reverse the parameters ? need to be clean AND consistent with the filter search fn...\r\n            }\r\n        }\r\n    },\r\n\r\n    /**\r\n     * Filter nested files/folders with the specified function.\r\n     * @param {Function} search the predicate to use :\r\n     * function (relativePath, file) {...}\r\n     * It takes 2 arguments : the relative path and the file.\r\n     * @return {Array} An array of matching elements.\r\n     */\r\n    filter: function(search) {\r\n        var result = [];\r\n        this.forEach(function (relativePath, entry) {\r\n            if (search(relativePath, entry)) { // the file matches the function\r\n                result.push(entry);\r\n            }\r\n\r\n        });\r\n        return result;\r\n    },\r\n\r\n    /**\r\n     * Add a file to the zip file, or search a file.\r\n     * @param   {string|RegExp} name The name of the file to add (if data is defined),\r\n     * the name of the file to find (if no data) or a regex to match files.\r\n     * @param   {String|ArrayBuffer|Uint8Array|Buffer} data  The file data, either raw or base64 encoded\r\n     * @param   {Object} o     File options\r\n     * @return  {JSZip|Object|Array} this JSZip object (when adding a file),\r\n     * a file (when searching by string) or an array of files (when searching by regex).\r\n     */\r\n    file: function(name, data, o) {\r\n        if (arguments.length === 1) {\r\n            if (isRegExp(name)) {\r\n                var regexp = name;\r\n                return this.filter(function(relativePath, file) {\r\n                    return !file.dir && regexp.test(relativePath);\r\n                });\r\n            }\r\n            else { // text\r\n                var obj = this.files[this.root + name];\r\n                if (obj && !obj.dir) {\r\n                    return obj;\r\n                } else {\r\n                    return null;\r\n                }\r\n            }\r\n        }\r\n        else { // more than one argument : we have data !\r\n            name = this.root + name;\r\n            fileAdd.call(this, name, data, o);\r\n        }\r\n        return this;\r\n    },\r\n\r\n    /**\r\n     * Add a directory to the zip file, or search.\r\n     * @param   {String|RegExp} arg The name of the directory to add, or a regex to search folders.\r\n     * @return  {JSZip} an object with the new directory as the root, or an array containing matching folders.\r\n     */\r\n    folder: function(arg) {\r\n        if (!arg) {\r\n            return this;\r\n        }\r\n\r\n        if (isRegExp(arg)) {\r\n            return this.filter(function(relativePath, file) {\r\n                return file.dir && arg.test(relativePath);\r\n            });\r\n        }\r\n\r\n        // else, name is a new folder\r\n        var name = this.root + arg;\r\n        var newFolder = folderAdd.call(this, name);\r\n\r\n        // Allow chaining by returning a new object with this folder as the root\r\n        var ret = this.clone();\r\n        ret.root = newFolder.name;\r\n        return ret;\r\n    },\r\n\r\n    /**\r\n     * Delete a file, or a directory and all sub-files, from the zip\r\n     * @param {string} name the name of the file to delete\r\n     * @return {JSZip} this JSZip object\r\n     */\r\n    remove: function(name) {\r\n        name = this.root + name;\r\n        var file = this.files[name];\r\n        if (!file) {\r\n            // Look for any folders\r\n            if (name.slice(-1) !== "/") {\r\n                name += "/";\r\n            }\r\n            file = this.files[name];\r\n        }\r\n\r\n        if (file && !file.dir) {\r\n            // file\r\n            delete this.files[name];\r\n        } else {\r\n            // maybe a folder, delete recursively\r\n            var kids = this.filter(function(relativePath, file) {\r\n                return file.name.slice(0, name.length) === name;\r\n            });\r\n            for (var i = 0; i < kids.length; i++) {\r\n                delete this.files[kids[i].name];\r\n            }\r\n        }\r\n\r\n        return this;\r\n    },\r\n\r\n    /**\r\n     * Generate the complete zip file\r\n     * @param {Object} options the options to generate the zip file :\r\n     * - compression, "STORE" by default.\r\n     * - type, "base64" by default. Values are : string, base64, uint8array, arraybuffer, blob.\r\n     * @return {String|Uint8Array|ArrayBuffer|Buffer|Blob} the zip file\r\n     */\r\n    generate: function(options) {\r\n        throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.");\r\n    },\r\n\r\n    /**\r\n     * Generate the complete zip file as an internal stream.\r\n     * @param {Object} options the options to generate the zip file :\r\n     * - compression, "STORE" by default.\r\n     * - type, "base64" by default. Values are : string, base64, uint8array, arraybuffer, blob.\r\n     * @return {StreamHelper} the streamed zip file.\r\n     */\r\n    generateInternalStream: function(options) {\r\n      var worker, opts = {};\r\n      try {\r\n          opts = utils.extend(options || {}, {\r\n              streamFiles: false,\r\n              compression: "STORE",\r\n              compressionOptions : null,\r\n              type: "",\r\n              platform: "DOS",\r\n              comment: null,\r\n              mimeType: \'application/zip\',\r\n              encodeFileName: utf8.utf8encode\r\n          });\r\n\r\n          opts.type = opts.type.toLowerCase();\r\n          opts.compression = opts.compression.toUpperCase();\r\n\r\n          // "binarystring" is prefered but the internals use "string".\r\n          if(opts.type === "binarystring") {\r\n            opts.type = "string";\r\n          }\r\n\r\n          if (!opts.type) {\r\n            throw new Error("No output type specified.");\r\n          }\r\n\r\n          utils.checkSupport(opts.type);\r\n\r\n          // accept nodejs `process.platform`\r\n          if(\r\n              opts.platform === \'darwin\' ||\r\n              opts.platform === \'freebsd\' ||\r\n              opts.platform === \'linux\' ||\r\n              opts.platform === \'sunos\'\r\n          ) {\r\n              opts.platform = "UNIX";\r\n          }\r\n          if (opts.platform === \'win32\') {\r\n              opts.platform = "DOS";\r\n          }\r\n\r\n          var comment = opts.comment || this.comment || "";\r\n          worker = generate.generateWorker(this, opts, comment);\r\n      } catch (e) {\r\n        worker = new GenericWorker("error");\r\n        worker.error(e);\r\n      }\r\n      return new StreamHelper(worker, opts.type || "string", opts.mimeType);\r\n    },\r\n    /**\r\n     * Generate the complete zip file asynchronously.\r\n     * @see generateInternalStream\r\n     */\r\n    generateAsync: function(options, onUpdate) {\r\n        return this.generateInternalStream(options).accumulate(onUpdate);\r\n    },\r\n    /**\r\n     * Generate the complete zip file asynchronously.\r\n     * @see generateInternalStream\r\n     */\r\n    generateNodeStream: function(options, onUpdate) {\r\n        options = options || {};\r\n        if (!options.type) {\r\n            options.type = "nodebuffer";\r\n        }\r\n        return this.generateInternalStream(options).toNodejsStream(onUpdate);\r\n    }\r\n};\r\nmodule.exports = out;\r\n\n\n//# sourceURL=webpack:///./lib/object.js?')},"./lib/readable-stream-browser.js":function(module,exports,__webpack_require__){eval('/*\r\n * This file is used by module bundlers (browserify/webpack/etc) when\r\n * including a stream implementation. We use "readable-stream" to get a\r\n * consistent behavior between nodejs versions but bundlers often have a shim\r\n * for "stream". Using this shim greatly improve the compatibility and greatly\r\n * reduce the final size of the bundle (only one stream implementation, not\r\n * two).\r\n */\r\nmodule.exports = __webpack_require__(/*! stream */ "./node_modules/stream-browserify/index.js");\r\n\n\n//# sourceURL=webpack:///./lib/readable-stream-browser.js?')},"./lib/reader/ArrayReader.js":function(module,exports,__webpack_require__){"use strict";eval('\r\nvar DataReader = __webpack_require__(/*! ./DataReader */ "./lib/reader/DataReader.js");\r\nvar utils = __webpack_require__(/*! ../utils */ "./lib/utils.js");\r\n\r\nfunction ArrayReader(data) {\r\n    DataReader.call(this, data);\r\n\tfor(var i = 0; i < this.data.length; i++) {\r\n\t\tdata[i] = data[i] & 0xFF;\r\n\t}\r\n}\r\nutils.inherits(ArrayReader, DataReader);\r\n/**\r\n * @see DataReader.byteAt\r\n */\r\nArrayReader.prototype.byteAt = function(i) {\r\n    return this.data[this.zero + i];\r\n};\r\n/**\r\n * @see DataReader.lastIndexOfSignature\r\n */\r\nArrayReader.prototype.lastIndexOfSignature = function(sig) {\r\n    var sig0 = sig.charCodeAt(0),\r\n        sig1 = sig.charCodeAt(1),\r\n        sig2 = sig.charCodeAt(2),\r\n        sig3 = sig.charCodeAt(3);\r\n    for (var i = this.length - 4; i >= 0; --i) {\r\n        if (this.data[i] === sig0 && this.data[i + 1] === sig1 && this.data[i + 2] === sig2 && this.data[i + 3] === sig3) {\r\n            return i - this.zero;\r\n        }\r\n    }\r\n\r\n    return -1;\r\n};\r\n/**\r\n * @see DataReader.readAndCheckSignature\r\n */\r\nArrayReader.prototype.readAndCheckSignature = function (sig) {\r\n    var sig0 = sig.charCodeAt(0),\r\n        sig1 = sig.charCodeAt(1),\r\n        sig2 = sig.charCodeAt(2),\r\n        sig3 = sig.charCodeAt(3),\r\n        data = this.readData(4);\r\n    return sig0 === data[0] && sig1 === data[1] && sig2 === data[2] && sig3 === data[3];\r\n};\r\n/**\r\n * @see DataReader.readData\r\n */\r\nArrayReader.prototype.readData = function(size) {\r\n    this.checkOffset(size);\r\n    if(size === 0) {\r\n        return [];\r\n    }\r\n    var result = this.data.slice(this.zero + this.index, this.zero + this.index + size);\r\n    this.index += size;\r\n    return result;\r\n};\r\nmodule.exports = ArrayReader;\r\n\n\n//# sourceURL=webpack:///./lib/reader/ArrayReader.js?')},"./lib/reader/DataReader.js":function(module,exports,__webpack_require__){"use strict"
;eval('\r\nvar utils = __webpack_require__(/*! ../utils */ "./lib/utils.js");\r\n\r\nfunction DataReader(data) {\r\n    this.data = data; // type : see implementation\r\n    this.length = data.length;\r\n    this.index = 0;\r\n    this.zero = 0;\r\n}\r\nDataReader.prototype = {\r\n    /**\r\n     * Check that the offset will not go too far.\r\n     * @param {string} offset the additional offset to check.\r\n     * @throws {Error} an Error if the offset is out of bounds.\r\n     */\r\n    checkOffset: function(offset) {\r\n        this.checkIndex(this.index + offset);\r\n    },\r\n    /**\r\n     * Check that the specified index will not be too far.\r\n     * @param {string} newIndex the index to check.\r\n     * @throws {Error} an Error if the index is out of bounds.\r\n     */\r\n    checkIndex: function(newIndex) {\r\n        if (this.length < this.zero + newIndex || newIndex < 0) {\r\n            throw new Error("End of data reached (data length = " + this.length + ", asked index = " + (newIndex) + "). Corrupted zip ?");\r\n        }\r\n    },\r\n    /**\r\n     * Change the index.\r\n     * @param {number} newIndex The new index.\r\n     * @throws {Error} if the new index is out of the data.\r\n     */\r\n    setIndex: function(newIndex) {\r\n        this.checkIndex(newIndex);\r\n        this.index = newIndex;\r\n    },\r\n    /**\r\n     * Skip the next n bytes.\r\n     * @param {number} n the number of bytes to skip.\r\n     * @throws {Error} if the new index is out of the data.\r\n     */\r\n    skip: function(n) {\r\n        this.setIndex(this.index + n);\r\n    },\r\n    /**\r\n     * Get the byte at the specified index.\r\n     * @param {number} i the index to use.\r\n     * @return {number} a byte.\r\n     */\r\n    byteAt: function(i) {\r\n        // see implementations\r\n    },\r\n    /**\r\n     * Get the next number with a given byte size.\r\n     * @param {number} size the number of bytes to read.\r\n     * @return {number} the corresponding number.\r\n     */\r\n    readInt: function(size) {\r\n        var result = 0,\r\n            i;\r\n        this.checkOffset(size);\r\n        for (i = this.index + size - 1; i >= this.index; i--) {\r\n            result = (result << 8) + this.byteAt(i);\r\n        }\r\n        this.index += size;\r\n        return result;\r\n    },\r\n    /**\r\n     * Get the next string with a given byte size.\r\n     * @param {number} size the number of bytes to read.\r\n     * @return {string} the corresponding string.\r\n     */\r\n    readString: function(size) {\r\n        return utils.transformTo("string", this.readData(size));\r\n    },\r\n    /**\r\n     * Get raw data without conversion, <size> bytes.\r\n     * @param {number} size the number of bytes to read.\r\n     * @return {Object} the raw data, implementation specific.\r\n     */\r\n    readData: function(size) {\r\n        // see implementations\r\n    },\r\n    /**\r\n     * Find the last occurence of a zip signature (4 bytes).\r\n     * @param {string} sig the signature to find.\r\n     * @return {number} the index of the last occurence, -1 if not found.\r\n     */\r\n    lastIndexOfSignature: function(sig) {\r\n        // see implementations\r\n    },\r\n    /**\r\n     * Read the signature (4 bytes) at the current position and compare it with sig.\r\n     * @param {string} sig the expected signature\r\n     * @return {boolean} true if the signature matches, false otherwise.\r\n     */\r\n    readAndCheckSignature: function(sig) {\r\n        // see implementations\r\n    },\r\n    /**\r\n     * Get the next date.\r\n     * @return {Date} the date.\r\n     */\r\n    readDate: function() {\r\n        var dostime = this.readInt(4);\r\n        return new Date(Date.UTC(\r\n        ((dostime >> 25) & 0x7f) + 1980, // year\r\n        ((dostime >> 21) & 0x0f) - 1, // month\r\n        (dostime >> 16) & 0x1f, // day\r\n        (dostime >> 11) & 0x1f, // hour\r\n        (dostime >> 5) & 0x3f, // minute\r\n        (dostime & 0x1f) << 1)); // second\r\n    }\r\n};\r\nmodule.exports = DataReader;\r\n\n\n//# sourceURL=webpack:///./lib/reader/DataReader.js?')},"./lib/reader/NodeBufferReader.js":function(module,exports,__webpack_require__){"use strict";eval('\r\nvar Uint8ArrayReader = __webpack_require__(/*! ./Uint8ArrayReader */ "./lib/reader/Uint8ArrayReader.js");\r\nvar utils = __webpack_require__(/*! ../utils */ "./lib/utils.js");\r\n\r\nfunction NodeBufferReader(data) {\r\n    Uint8ArrayReader.call(this, data);\r\n}\r\nutils.inherits(NodeBufferReader, Uint8ArrayReader);\r\n\r\n/**\r\n * @see DataReader.readData\r\n */\r\nNodeBufferReader.prototype.readData = function(size) {\r\n    this.checkOffset(size);\r\n    var result = this.data.slice(this.zero + this.index, this.zero + this.index + size);\r\n    this.index += size;\r\n    return result;\r\n};\r\nmodule.exports = NodeBufferReader;\r\n\n\n//# sourceURL=webpack:///./lib/reader/NodeBufferReader.js?')},"./lib/reader/StringReader.js":function(module,exports,__webpack_require__){"use strict";eval('\r\nvar DataReader = __webpack_require__(/*! ./DataReader */ "./lib/reader/DataReader.js");\r\nvar utils = __webpack_require__(/*! ../utils */ "./lib/utils.js");\r\n\r\nfunction StringReader(data) {\r\n    DataReader.call(this, data);\r\n}\r\nutils.inherits(StringReader, DataReader);\r\n/**\r\n * @see DataReader.byteAt\r\n */\r\nStringReader.prototype.byteAt = function(i) {\r\n    return this.data.charCodeAt(this.zero + i);\r\n};\r\n/**\r\n * @see DataReader.lastIndexOfSignature\r\n */\r\nStringReader.prototype.lastIndexOfSignature = function(sig) {\r\n    return this.data.lastIndexOf(sig) - this.zero;\r\n};\r\n/**\r\n * @see DataReader.readAndCheckSignature\r\n */\r\nStringReader.prototype.readAndCheckSignature = function (sig) {\r\n    var data = this.readData(4);\r\n    return sig === data;\r\n};\r\n/**\r\n * @see DataReader.readData\r\n */\r\nStringReader.prototype.readData = function(size) {\r\n    this.checkOffset(size);\r\n    // this will work because the constructor applied the "& 0xff" mask.\r\n    var result = this.data.slice(this.zero + this.index, this.zero + this.index + size);\r\n    this.index += size;\r\n    return result;\r\n};\r\nmodule.exports = StringReader;\r\n\n\n//# sourceURL=webpack:///./lib/reader/StringReader.js?')},"./lib/reader/Uint8ArrayReader.js":function(module,exports,__webpack_require__){"use strict";eval('\r\nvar ArrayReader = __webpack_require__(/*! ./ArrayReader */ "./lib/reader/ArrayReader.js");\r\nvar utils = __webpack_require__(/*! ../utils */ "./lib/utils.js");\r\n\r\nfunction Uint8ArrayReader(data) {\r\n    ArrayReader.call(this, data);\r\n}\r\nutils.inherits(Uint8ArrayReader, ArrayReader);\r\n/**\r\n * @see DataReader.readData\r\n */\r\nUint8ArrayReader.prototype.readData = function(size) {\r\n    this.checkOffset(size);\r\n    if(size === 0) {\r\n        // in IE10, when using subarray(idx, idx), we get the array [0x00] instead of [].\r\n        return new Uint8Array(0);\r\n    }\r\n    var result = this.data.subarray(this.zero + this.index, this.zero + this.index + size);\r\n    this.index += size;\r\n    return result;\r\n};\r\nmodule.exports = Uint8ArrayReader;\r\n\n\n//# sourceURL=webpack:///./lib/reader/Uint8ArrayReader.js?')},"./lib/reader/readerFor.js":function(module,exports,__webpack_require__){"use strict";eval('\r\n\r\nvar utils = __webpack_require__(/*! ../utils */ "./lib/utils.js");\r\nvar support = __webpack_require__(/*! ../support */ "./lib/support.js");\r\nvar ArrayReader = __webpack_require__(/*! ./ArrayReader */ "./lib/reader/ArrayReader.js");\r\nvar StringReader = __webpack_require__(/*! ./StringReader */ "./lib/reader/StringReader.js");\r\nvar NodeBufferReader = __webpack_require__(/*! ./NodeBufferReader */ "./lib/reader/NodeBufferReader.js");\r\nvar Uint8ArrayReader = __webpack_require__(/*! ./Uint8ArrayReader */ "./lib/reader/Uint8ArrayReader.js");\r\n\r\n/**\r\n * Create a reader adapted to the data.\r\n * @param {String|ArrayBuffer|Uint8Array|Buffer} data the data to read.\r\n * @return {DataReader} the data reader.\r\n */\r\nmodule.exports = function (data) {\r\n    var type = utils.getTypeOf(data);\r\n    utils.checkSupport(type);\r\n    if (type === "string" && !support.uint8array) {\r\n        return new StringReader(data);\r\n    }\r\n    if (type === "nodebuffer") {\r\n        return new NodeBufferReader(data);\r\n    }\r\n    if (support.uint8array) {\r\n        return new Uint8ArrayReader(utils.transformTo("uint8array", data));\r\n    }\r\n    return new ArrayReader(utils.transformTo("array", data));\r\n};\r\n\n\n//# sourceURL=webpack:///./lib/reader/readerFor.js?')},"./lib/signature.js":function(module,exports,__webpack_require__){"use strict";eval('\r\nexports.LOCAL_FILE_HEADER = "PK\\x03\\x04";\r\nexports.CENTRAL_FILE_HEADER = "PK\\x01\\x02";\r\nexports.CENTRAL_DIRECTORY_END = "PK\\x05\\x06";\r\nexports.ZIP64_CENTRAL_DIRECTORY_LOCATOR = "PK\\x06\\x07";\r\nexports.ZIP64_CENTRAL_DIRECTORY_END = "PK\\x06\\x06";\r\nexports.DATA_DESCRIPTOR = "PK\\x07\\x08";\r\n\n\n//# sourceURL=webpack:///./lib/signature.js?')},"./lib/stream/ConvertWorker.js":function(module,exports,__webpack_require__){"use strict";eval('\r\n\r\nvar GenericWorker = __webpack_require__(/*! ./GenericWorker */ "./lib/stream/GenericWorker.js");\r\nvar utils = __webpack_require__(/*! ../utils */ "./lib/utils.js");\r\n\r\n/**\r\n * A worker which convert chunks to a specified type.\r\n * @constructor\r\n * @param {String} destType the destination type.\r\n */\r\nfunction ConvertWorker(destType) {\r\n    GenericWorker.call(this, "ConvertWorker to " + destType);\r\n    this.destType = destType;\r\n}\r\nutils.inherits(ConvertWorker, GenericWorker);\r\n\r\n/**\r\n * @see GenericWorker.processChunk\r\n */\r\nConvertWorker.prototype.processChunk = function (chunk) {\r\n    this.push({\r\n        data : utils.transformTo(this.destType, chunk.data),\r\n        meta : chunk.meta\r\n    });\r\n};\r\nmodule.exports = ConvertWorker;\r\n\n\n//# sourceURL=webpack:///./lib/stream/ConvertWorker.js?')},"./lib/stream/Crc32Probe.js":function(module,exports,__webpack_require__){"use strict";eval('\r\n\r\nvar GenericWorker = __webpack_require__(/*! ./GenericWorker */ "./lib/stream/GenericWorker.js");\r\nvar crc32 = __webpack_require__(/*! ../crc32 */ "./lib/crc32.js");\r\nvar utils = __webpack_require__(/*! ../utils */ "./lib/utils.js");\r\n\r\n/**\r\n * A worker which calculate the crc32 of the data flowing through.\r\n * @constructor\r\n */\r\nfunction Crc32Probe() {\r\n    GenericWorker.call(this, "Crc32Probe");\r\n    this.withStreamInfo("crc32", 0);\r\n}\r\nutils.inherits(Crc32Probe, GenericWorker);\r\n\r\n/**\r\n * @see GenericWorker.processChunk\r\n */\r\nCrc32Probe.prototype.processChunk = function (chunk) {\r\n    this.streamInfo.crc32 = crc32(chunk.data, this.streamInfo.crc32 || 0);\r\n    this.push(chunk);\r\n};\r\nmodule.exports = Crc32Probe;\r\n\n\n//# sourceURL=webpack:///./lib/stream/Crc32Probe.js?')},"./lib/stream/DataLengthProbe.js":function(module,exports,__webpack_require__){"use strict";eval('\r\n\r\nvar utils = __webpack_require__(/*! ../utils */ "./lib/utils.js");\r\nvar GenericWorker = __webpack_require__(/*! ./GenericWorker */ "./lib/stream/GenericWorker.js");\r\n\r\n/**\r\n * A worker which calculate the total length of the data flowing through.\r\n * @constructor\r\n * @param {String} propName the name used to expose the length\r\n */\r\nfunction DataLengthProbe(propName) {\r\n    GenericWorker.call(this, "DataLengthProbe for " + propName);\r\n    this.propName = propName;\r\n    this.withStreamInfo(propName, 0);\r\n}\r\nutils.inherits(DataLengthProbe, GenericWorker);\r\n\r\n/**\r\n * @see GenericWorker.processChunk\r\n */\r\nDataLengthProbe.prototype.processChunk = function (chunk) {\r\n    if(chunk) {\r\n        var length = this.streamInfo[this.propName] || 0;\r\n        this.streamInfo[this.propName] = length + chunk.data.length;\r\n    }\r\n    GenericWorker.prototype.processChunk.call(this, chunk);\r\n};\r\nmodule.exports = DataLengthProbe;\r\n\r\n\n\n//# sourceURL=webpack:///./lib/stream/DataLengthProbe.js?')},"./lib/stream/DataWorker.js":function(module,exports,__webpack_require__){"use strict";eval('\r\n\r\nvar utils = __webpack_require__(/*! ../utils */ "./lib/utils.js");\r\nvar GenericWorker = __webpack_require__(/*! ./GenericWorker */ "./lib/stream/GenericWorker.js");\r\n\r\n// the size of the generated chunks\r\n// TODO expose this as a public variable\r\nvar DEFAULT_BLOCK_SIZE = 16 * 1024;\r\n\r\n/**\r\n * A worker that reads a content and emits chunks.\r\n * @constructor\r\n * @param {Promise} dataP the promise of the data to split\r\n */\r\nfunction DataWorker(dataP) {\r\n    GenericWorker.call(this, "DataWorker");\r\n    var self = this;\r\n    this.dataIsReady = false;\r\n    this.index = 0;\r\n    this.max = 0;\r\n    this.data = null;\r\n    this.type = "";\r\n\r\n    this._tickScheduled = false;\r\n\r\n    dataP.then(function (data) {\r\n        self.dataIsReady = true;\r\n        self.data = data;\r\n        self.max = data && data.length || 0;\r\n        self.type = utils.getTypeOf(data);\r\n        if(!self.isPaused) {\r\n            self._tickAndRepeat();\r\n        }\r\n    }, function (e) {\r\n        self.error(e);\r\n    });\r\n}\r\n\r\nutils.inherits(DataWorker, GenericWorker);\r\n\r\n/**\r\n * @see GenericWorker.cleanUp\r\n */\r\nDataWorker.prototype.cleanUp = function () {\r\n    GenericWorker.prototype.cleanUp.call(this);\r\n    this.data = null;\r\n};\r\n\r\n/**\r\n * @see GenericWorker.resume\r\n */\r\nDataWorker.prototype.resume = function () {\r\n    if(!GenericWorker.prototype.resume.call(this)) {\r\n        return false;\r\n    }\r\n\r\n    if (!this._tickScheduled && this.dataIsReady) {\r\n        this._tickScheduled = true;\r\n        utils.delay(this._tickAndRepeat, [], this);\r\n    }\r\n    return true;\r\n};\r\n\r\n/**\r\n * Trigger a tick a schedule an other call to this function.\r\n */\r\nDataWorker.prototype._tickAndRepeat = function() {\r\n    this._tickScheduled = false;\r\n    if(this.isPaused || this.isFinished) {\r\n        return;\r\n    }\r\n    this._tick();\r\n    if(!this.isFinished) {\r\n        utils.delay(this._tickAndRepeat, [], this);\r\n        this._tickScheduled = true;\r\n    }\r\n};\r\n\r\n/**\r\n * Read and push a chunk.\r\n */\r\nDataWorker.prototype._tick = function() {\r\n\r\n    if(this.isPaused || this.isFinished) {\r\n        return false;\r\n    }\r\n\r\n    var size = DEFAULT_BLOCK_SIZE;\r\n    var data = null, nextIndex = Math.min(this.max, this.index + size);\r\n    if (this.index >= this.max) {\r\n        // EOF\r\n        return this.end();\r\n    } else {\r\n        switch(this.type) {\r\n            case "string":\r\n                data = this.data.substring(this.index, nextIndex);\r\n            break;\r\n            case "uint8array":\r\n                data = this.data.subarray(this.index, nextIndex);\r\n            break;\r\n            case "array":\r\n            case "nodebuffer":\r\n                data = this.data.slice(this.index, nextIndex);\r\n            break;\r\n        }\r\n        this.index = nextIndex;\r\n        return this.push({\r\n            data : data,\r\n            meta : {\r\n                percent : this.max ? this.index / this.max * 100 : 0\r\n            }\r\n        });\r\n    }\r\n};\r\n\r\nmodule.exports = DataWorker;\r\n\n\n//# sourceURL=webpack:///./lib/stream/DataWorker.js?')},"./lib/stream/GenericWorker.js":function(module,exports,__webpack_require__){"use strict";eval('\r\n\r\n/**\r\n * A worker that does nothing but passing chunks to the next one. This is like\r\n * a nodejs stream but with some differences. On the good side :\r\n * - it works on IE 6-9 without any issue / polyfill\r\n * - it weights less than the full dependencies bundled with browserify\r\n * - it forwards errors (no need to declare an error handler EVERYWHERE)\r\n *\r\n * A chunk is an object with 2 attributes : `meta` and `data`. The former is an\r\n * object containing anything (`percent` for example), see each worker for more\r\n * details. The latter is the real data (String, Uint8Array, etc).\r\n *\r\n * @constructor\r\n * @param {String} name the name of the stream (mainly used for debugging purposes)\r\n */\r\nfunction GenericWorker(name) {\r\n    // the name of the worker\r\n    this.name = name || "default";\r\n    // an object containing metadata about the workers chain\r\n    this.streamInfo = {};\r\n    // an error which happened when the worker was paused\r\n    this.generatedError = null;\r\n    // an object containing metadata to be merged by this worker into the general metadata\r\n    this.extraStreamInfo = {};\r\n    // true if the stream is paused (and should not do anything), false otherwise\r\n    this.isPaused = true;\r\n    // true if the stream is finished (and should not do anything), false otherwise\r\n    this.isFinished = false;\r\n    // true if the stream is locked to prevent further structure updates (pipe), false otherwise\r\n    this.isLocked = false;\r\n    // the event listeners\r\n    this._listeners = {\r\n        \'data\':[],\r\n        \'end\':[],\r\n        \'error\':[]\r\n    };\r\n    // the previous worker, if any\r\n    this.previous = null;\r\n}\r\n\r\nGenericWorker.prototype = {\r\n    /**\r\n     * Push a chunk to the next workers.\r\n     * @param {Object} chunk the chunk to push\r\n     */\r\n    push : function (chunk) {\r\n        this.emit("data", chunk);\r\n    },\r\n    /**\r\n     * End the stream.\r\n     * @return {Boolean} true if this call ended the worker, false otherwise.\r\n     */\r\n    end : function () {\r\n        if (this.isFinished) {\r\n            return false;\r\n        }\r\n\r\n        this.flush();\r\n        try {\r\n            this.emit("end");\r\n            this.cleanUp();\r\n            this.isFinished = true;\r\n        } catch (e) {\r\n            this.emit("error", e);\r\n        }\r\n        return true;\r\n    },\r\n    /**\r\n     * End the stream with an error.\r\n     * @param {Error} e the error which caused the premature end.\r\n     * @return {Boolean} true if this call ended the worker with an error, false otherwise.\r\n     */\r\n    error : function (e) {\r\n        if (this.isFinished) {\r\n            return false;\r\n        }\r\n\r\n        if(this.isPaused) {\r\n            this.generatedError = e;\r\n        } else {\r\n            this.isFinished = true;\r\n\r\n            this.emit("error", e);\r\n\r\n            // in the workers chain exploded in the middle of the chain,\r\n            // the error event will go downward but we also need to notify\r\n            // workers upward that there has been an error.\r\n            if(this.previous) {\r\n                this.previous.error(e);\r\n            }\r\n\r\n            this.cleanUp();\r\n        }\r\n        return true;\r\n    },\r\n    /**\r\n     * Add a callback on an event.\r\n     * @param {String} name the name of the event (data, end, error)\r\n     * @param {Function} listener the function to call when the event is triggered\r\n     * @return {GenericWorker} the current object for chainability\r\n     */\r\n    on : function (name, listener) {\r\n        this._listeners[name].push(listener);\r\n        return this;\r\n    },\r\n    /**\r\n     * Clean any references when a worker is ending.\r\n     */\r\n    cleanUp : function () {\r\n        this.streamInfo = this.generatedError = this.extraStreamInfo = null;\r\n        this._listeners = [];\r\n    },\r\n    /**\r\n     * Trigger an event. This will call registered callback with the provided arg.\r\n     * @param {String} name the name of the event (data, end, error)\r\n     * @param {Object} arg the argument to call the callback with.\r\n     */\r\n    emit : function (name, arg) {\r\n        if (this._listeners[name]) {\r\n            for(var i = 0; i < this._listeners[name].length; i++) {\r\n                this._listeners[name][i].call(this, arg);\r\n            }\r\n        }\r\n    },\r\n    /**\r\n     * Chain a worker with an other.\r\n     * @param {Worker} next the worker receiving events from the current one.\r\n     * @return {worker} the next worker for chainability\r\n     */\r\n    pipe : function (next) {\r\n        return next.registerPrevious(this);\r\n    },\r\n    /**\r\n     * Same as `pipe` in the other direction.\r\n     * Using an API with `pipe(next)` is very easy.\r\n     * Implementing the API with the point of view of the next one registering\r\n     * a source is easier, see the ZipFileWorker.\r\n     * @param {Worker} previous the previous worker, sending events to this one\r\n     * @return {Worker} the current worker for chainability\r\n     */\r\n    registerPrevious : function (previous) {\r\n        if (this.isLocked) {\r\n            throw new Error("The stream \'" + this + "\' has already been used.");\r\n        }\r\n\r\n        // sharing the streamInfo...\r\n        this.streamInfo = previous.streamInfo;\r\n        // ... and adding our own bits\r\n        this.mergeStreamInfo();\r\n        this.previous =  previous;\r\n        var self = this;\r\n        previous.on(\'data\', function (chunk) {\r\n            self.processChunk(chunk);\r\n        });\r\n        previous.on(\'end\', function () {\r\n            self.end();\r\n        });\r\n        previous.on(\'error\', function (e) {\r\n            self.error(e);\r\n        });\r\n        return this;\r\n    },\r\n    /**\r\n     * Pause the stream so it doesn\'t send events anymore.\r\n     * @return {Boolean} true if this call paused the worker, false otherwise.\r\n     */\r\n    pause : function () {\r\n        if(this.isPaused || this.isFinished) {\r\n            return false;\r\n        }\r\n        this.isPaused = true;\r\n\r\n        if(this.previous) {\r\n            this.previous.pause();\r\n        }\r\n        return true;\r\n    },\r\n    /**\r\n     * Resume a paused stream.\r\n     * @return {Boolean} true if this call resumed the worker, false otherwise.\r\n     */\r\n    resume : function () {\r\n        if(!this.isPaused || this.isFinished) {\r\n            return false;\r\n        }\r\n        this.isPaused = false;\r\n\r\n        // if true, the worker tried to resume but failed\r\n        var withError = false;\r\n        if(this.generatedError) {\r\n            this.error(this.generatedError);\r\n            withError = true;\r\n        }\r\n        if(this.previous) {\r\n            this.previous.resume();\r\n        }\r\n\r\n        return !withError;\r\n    },\r\n    /**\r\n     * Flush any remaining bytes as the stream is ending.\r\n     */\r\n    flush : function () {},\r\n    /**\r\n     * Process a chunk. This is usually the method overridden.\r\n     * @param {Object} chunk the chunk to process.\r\n     */\r\n    processChunk : function(chunk) {\r\n        this.push(chunk);\r\n    },\r\n    /**\r\n     * Add a key/value to be added in the workers chain streamInfo once activated.\r\n     * @param {String} key the key to use\r\n     * @param {Object} value the associated value\r\n     * @return {Worker} the current worker for chainability\r\n     */\r\n    withStreamInfo : function (key, value) {\r\n        this.extraStreamInfo[key] = value;\r\n        this.mergeStreamInfo();\r\n        return this;\r\n    },\r\n    /**\r\n     * Merge this worker\'s streamInfo into the chain\'s streamInfo.\r\n     */\r\n    mergeStreamInfo : function () {\r\n        for(var key in this.extraStreamInfo) {\r\n            if (!this.extraStreamInfo.hasOwnProperty(key)) {\r\n                continue;\r\n            }\r\n            this.streamInfo[key] = this.extraStreamInfo[key];\r\n        }\r\n    },\r\n\r\n    /**\r\n     * Lock the stream to prevent further updates on the workers chain.\r\n     * After calling this method, all calls to pipe will fail.\r\n     */\r\n    lock: function () {\r\n        if (this.isLocked) {\r\n            throw new Error("The stream \'" + this + "\' has already been used.");\r\n        }\r\n        this.isLocked = true;\r\n        if (this.previous) {\r\n            this.previous.lock();\r\n        }\r\n    },\r\n\r\n    /**\r\n     *\r\n     * Pretty print the workers chain.\r\n     */\r\n    toString : function () {\r\n        var me = "Worker " + this.name;\r\n        if (this.previous) {\r\n            return this.previous + " -> " + me;\r\n        } else {\r\n            return me;\r\n        }\r\n    }\r\n};\r\n\r\nmodule.exports = GenericWorker;\r\n\n\n//# sourceURL=webpack:///./lib/stream/GenericWorker.js?')},"./lib/stream/StreamHelper.js":function(module,exports,__webpack_require__){"use strict"
;eval('/* WEBPACK VAR INJECTION */(function(Buffer) {\r\n\r\nvar utils = __webpack_require__(/*! ../utils */ "./lib/utils.js");\r\nvar ConvertWorker = __webpack_require__(/*! ./ConvertWorker */ "./lib/stream/ConvertWorker.js");\r\nvar GenericWorker = __webpack_require__(/*! ./GenericWorker */ "./lib/stream/GenericWorker.js");\r\nvar base64 = __webpack_require__(/*! ../base64 */ "./lib/base64.js");\r\nvar support = __webpack_require__(/*! ../support */ "./lib/support.js");\r\nvar external = __webpack_require__(/*! ../external */ "./lib/external.js");\r\n\r\nvar NodejsStreamOutputAdapter = null;\r\nif (support.nodestream) {\r\n    try {\r\n        NodejsStreamOutputAdapter = __webpack_require__(/*! ../nodejs/NodejsStreamOutputAdapter */ "./lib/nodejs/NodejsStreamOutputAdapter.js");\r\n    } catch(e) {}\r\n}\r\n\r\n/**\r\n * Apply the final transformation of the data. If the user wants a Blob for\r\n * example, it\'s easier to work with an U8intArray and finally do the\r\n * ArrayBuffer/Blob conversion.\r\n * @param {String} type the name of the final type\r\n * @param {String|Uint8Array|Buffer} content the content to transform\r\n * @param {String} mimeType the mime type of the content, if applicable.\r\n * @return {String|Uint8Array|ArrayBuffer|Buffer|Blob} the content in the right format.\r\n */\r\nfunction transformZipOutput(type, content, mimeType) {\r\n    switch(type) {\r\n        case "blob" :\r\n            return utils.newBlob(utils.transformTo("arraybuffer", content), mimeType);\r\n        case "base64" :\r\n            return base64.encode(content);\r\n        default :\r\n            return utils.transformTo(type, content);\r\n    }\r\n}\r\n\r\n/**\r\n * Concatenate an array of data of the given type.\r\n * @param {String} type the type of the data in the given array.\r\n * @param {Array} dataArray the array containing the data chunks to concatenate\r\n * @return {String|Uint8Array|Buffer} the concatenated data\r\n * @throws Error if the asked type is unsupported\r\n */\r\nfunction concat (type, dataArray) {\r\n    var i, index = 0, res = null, totalLength = 0;\r\n    for(i = 0; i < dataArray.length; i++) {\r\n        totalLength += dataArray[i].length;\r\n    }\r\n    switch(type) {\r\n        case "string":\r\n            return dataArray.join("");\r\n          case "array":\r\n            return Array.prototype.concat.apply([], dataArray);\r\n        case "uint8array":\r\n            res = new Uint8Array(totalLength);\r\n            for(i = 0; i < dataArray.length; i++) {\r\n                res.set(dataArray[i], index);\r\n                index += dataArray[i].length;\r\n            }\r\n            return res;\r\n        case "nodebuffer":\r\n            return Buffer.concat(dataArray);\r\n        default:\r\n            throw new Error("concat : unsupported type \'"  + type + "\'");\r\n    }\r\n}\r\n\r\n/**\r\n * Listen a StreamHelper, accumulate its content and concatenate it into a\r\n * complete block.\r\n * @param {StreamHelper} helper the helper to use.\r\n * @param {Function} updateCallback a callback called on each update. Called\r\n * with one arg :\r\n * - the metadata linked to the update received.\r\n * @return Promise the promise for the accumulation.\r\n */\r\nfunction accumulate(helper, updateCallback) {\r\n    return new external.Promise(function (resolve, reject){\r\n        var dataArray = [];\r\n        var chunkType = helper._internalType,\r\n            resultType = helper._outputType,\r\n            mimeType = helper._mimeType;\r\n        helper\r\n        .on(\'data\', function (data, meta) {\r\n            dataArray.push(data);\r\n            if(updateCallback) {\r\n                updateCallback(meta);\r\n            }\r\n        })\r\n        .on(\'error\', function(err) {\r\n            dataArray = [];\r\n            reject(err);\r\n        })\r\n        .on(\'end\', function (){\r\n            try {\r\n                var result = transformZipOutput(resultType, concat(chunkType, dataArray), mimeType);\r\n                resolve(result);\r\n            } catch (e) {\r\n                reject(e);\r\n            }\r\n            dataArray = [];\r\n        })\r\n        .resume();\r\n    });\r\n}\r\n\r\n/**\r\n * An helper to easily use workers outside of JSZip.\r\n * @constructor\r\n * @param {Worker} worker the worker to wrap\r\n * @param {String} outputType the type of data expected by the use\r\n * @param {String} mimeType the mime type of the content, if applicable.\r\n */\r\nfunction StreamHelper(worker, outputType, mimeType) {\r\n    var internalType = outputType;\r\n    switch(outputType) {\r\n        case "blob":\r\n        case "arraybuffer":\r\n            internalType = "uint8array";\r\n        break;\r\n        case "base64":\r\n            internalType = "string";\r\n        break;\r\n    }\r\n\r\n    try {\r\n        // the type used internally\r\n        this._internalType = internalType;\r\n        // the type used to output results\r\n        this._outputType = outputType;\r\n        // the mime type\r\n        this._mimeType = mimeType;\r\n        utils.checkSupport(internalType);\r\n        this._worker = worker.pipe(new ConvertWorker(internalType));\r\n        // the last workers can be rewired without issues but we need to\r\n        // prevent any updates on previous workers.\r\n        worker.lock();\r\n    } catch(e) {\r\n        this._worker = new GenericWorker("error");\r\n        this._worker.error(e);\r\n    }\r\n}\r\n\r\nStreamHelper.prototype = {\r\n    /**\r\n     * Listen a StreamHelper, accumulate its content and concatenate it into a\r\n     * complete block.\r\n     * @param {Function} updateCb the update callback.\r\n     * @return Promise the promise for the accumulation.\r\n     */\r\n    accumulate : function (updateCb) {\r\n        return accumulate(this, updateCb);\r\n    },\r\n    /**\r\n     * Add a listener on an event triggered on a stream.\r\n     * @param {String} evt the name of the event\r\n     * @param {Function} fn the listener\r\n     * @return {StreamHelper} the current helper.\r\n     */\r\n    on : function (evt, fn) {\r\n        var self = this;\r\n\r\n        if(evt === "data") {\r\n            this._worker.on(evt, function (chunk) {\r\n                fn.call(self, chunk.data, chunk.meta);\r\n            });\r\n        } else {\r\n            this._worker.on(evt, function () {\r\n                utils.delay(fn, arguments, self);\r\n            });\r\n        }\r\n        return this;\r\n    },\r\n    /**\r\n     * Resume the flow of chunks.\r\n     * @return {StreamHelper} the current helper.\r\n     */\r\n    resume : function () {\r\n        utils.delay(this._worker.resume, [], this._worker);\r\n        return this;\r\n    },\r\n    /**\r\n     * Pause the flow of chunks.\r\n     * @return {StreamHelper} the current helper.\r\n     */\r\n    pause : function () {\r\n        this._worker.pause();\r\n        return this;\r\n    },\r\n    /**\r\n     * Return a nodejs stream for this helper.\r\n     * @param {Function} updateCb the update callback.\r\n     * @return {NodejsStreamOutputAdapter} the nodejs stream.\r\n     */\r\n    toNodejsStream : function (updateCb) {\r\n        utils.checkSupport("nodestream");\r\n        if (this._outputType !== "nodebuffer") {\r\n            // an object stream containing blob/arraybuffer/uint8array/string\r\n            // is strange and I don\'t know if it would be useful.\r\n            // I you find this comment and have a good usecase, please open a\r\n            // bug report !\r\n            throw new Error(this._outputType + " is not supported by this method");\r\n        }\r\n\r\n        return new NodejsStreamOutputAdapter(this, {\r\n            objectMode : this._outputType !== "nodebuffer"\r\n        }, updateCb);\r\n    }\r\n};\r\n\r\n\r\nmodule.exports = StreamHelper;\r\n\n/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! ./../../node_modules/buffer/index.js */ "./node_modules/buffer/index.js").Buffer))\n\n//# sourceURL=webpack:///./lib/stream/StreamHelper.js?')},"./lib/support.js":function(module,exports,__webpack_require__){"use strict";eval('/* WEBPACK VAR INJECTION */(function(Buffer) {\r\n\r\nexports.base64 = true;\r\nexports.array = true;\r\nexports.string = true;\r\nexports.arraybuffer = typeof ArrayBuffer !== "undefined" && typeof Uint8Array !== "undefined";\r\nexports.nodebuffer = typeof Buffer !== "undefined";\r\n// contains true if JSZip can read/generate Uint8Array, false otherwise.\r\nexports.uint8array = typeof Uint8Array !== "undefined";\r\n\r\nif (typeof ArrayBuffer === "undefined") {\r\n    exports.blob = false;\r\n}\r\nelse {\r\n    var buffer = new ArrayBuffer(0);\r\n    try {\r\n        exports.blob = new Blob([buffer], {\r\n            type: "application/zip"\r\n        }).size === 0;\r\n    }\r\n    catch (e) {\r\n        try {\r\n            var Builder = self.BlobBuilder || self.WebKitBlobBuilder || self.MozBlobBuilder || self.MSBlobBuilder;\r\n            var builder = new Builder();\r\n            builder.append(buffer);\r\n            exports.blob = builder.getBlob(\'application/zip\').size === 0;\r\n        }\r\n        catch (e) {\r\n            exports.blob = false;\r\n        }\r\n    }\r\n}\r\n\r\ntry {\r\n    exports.nodestream = !!__webpack_require__(/*! readable-stream */ "./lib/readable-stream-browser.js").Readable;\r\n} catch(e) {\r\n    exports.nodestream = false;\r\n}\r\n\n/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! ./../node_modules/buffer/index.js */ "./node_modules/buffer/index.js").Buffer))\n\n//# sourceURL=webpack:///./lib/support.js?')},"./lib/utf8.js":function(module,exports,__webpack_require__){"use strict";eval('\r\n\r\nvar utils = __webpack_require__(/*! ./utils */ "./lib/utils.js");\r\nvar support = __webpack_require__(/*! ./support */ "./lib/support.js");\r\nvar nodejsUtils = __webpack_require__(/*! ./nodejsUtils */ "./lib/nodejsUtils.js");\r\nvar GenericWorker = __webpack_require__(/*! ./stream/GenericWorker */ "./lib/stream/GenericWorker.js");\r\n\r\n/**\r\n * The following functions come from pako, from pako/lib/utils/strings\r\n * released under the MIT license, see pako https://github.com/nodeca/pako/\r\n */\r\n\r\n// Table with utf8 lengths (calculated by first byte of sequence)\r\n// Note, that 5 & 6-byte values and some 4-byte values can not be represented in JS,\r\n// because max possible codepoint is 0x10ffff\r\nvar _utf8len = new Array(256);\r\nfor (var i=0; i<256; i++) {\r\n  _utf8len[i] = (i >= 252 ? 6 : i >= 248 ? 5 : i >= 240 ? 4 : i >= 224 ? 3 : i >= 192 ? 2 : 1);\r\n}\r\n_utf8len[254]=_utf8len[254]=1; // Invalid sequence start\r\n\r\n// convert string to array (typed, when possible)\r\nvar string2buf = function (str) {\r\n    var buf, c, c2, m_pos, i, str_len = str.length, buf_len = 0;\r\n\r\n    // count binary size\r\n    for (m_pos = 0; m_pos < str_len; m_pos++) {\r\n        c = str.charCodeAt(m_pos);\r\n        if ((c & 0xfc00) === 0xd800 && (m_pos+1 < str_len)) {\r\n            c2 = str.charCodeAt(m_pos+1);\r\n            if ((c2 & 0xfc00) === 0xdc00) {\r\n                c = 0x10000 + ((c - 0xd800) << 10) + (c2 - 0xdc00);\r\n                m_pos++;\r\n            }\r\n        }\r\n        buf_len += c < 0x80 ? 1 : c < 0x800 ? 2 : c < 0x10000 ? 3 : 4;\r\n    }\r\n\r\n    // allocate buffer\r\n    if (support.uint8array) {\r\n        buf = new Uint8Array(buf_len);\r\n    } else {\r\n        buf = new Array(buf_len);\r\n    }\r\n\r\n    // convert\r\n    for (i=0, m_pos = 0; i < buf_len; m_pos++) {\r\n        c = str.charCodeAt(m_pos);\r\n        if ((c & 0xfc00) === 0xd800 && (m_pos+1 < str_len)) {\r\n            c2 = str.charCodeAt(m_pos+1);\r\n            if ((c2 & 0xfc00) === 0xdc00) {\r\n                c = 0x10000 + ((c - 0xd800) << 10) + (c2 - 0xdc00);\r\n                m_pos++;\r\n            }\r\n        }\r\n        if (c < 0x80) {\r\n            /* one byte */\r\n            buf[i++] = c;\r\n        } else if (c < 0x800) {\r\n            /* two bytes */\r\n            buf[i++] = 0xC0 | (c >>> 6);\r\n            buf[i++] = 0x80 | (c & 0x3f);\r\n        } else if (c < 0x10000) {\r\n            /* three bytes */\r\n            buf[i++] = 0xE0 | (c >>> 12);\r\n            buf[i++] = 0x80 | (c >>> 6 & 0x3f);\r\n            buf[i++] = 0x80 | (c & 0x3f);\r\n        } else {\r\n            /* four bytes */\r\n            buf[i++] = 0xf0 | (c >>> 18);\r\n            buf[i++] = 0x80 | (c >>> 12 & 0x3f);\r\n            buf[i++] = 0x80 | (c >>> 6 & 0x3f);\r\n            buf[i++] = 0x80 | (c & 0x3f);\r\n        }\r\n    }\r\n\r\n    return buf;\r\n};\r\n\r\n// Calculate max possible position in utf8 buffer,\r\n// that will not break sequence. If that\'s not possible\r\n// - (very small limits) return max size as is.\r\n//\r\n// buf[] - utf8 bytes array\r\n// max   - length limit (mandatory);\r\nvar utf8border = function(buf, max) {\r\n    var pos;\r\n\r\n    max = max || buf.length;\r\n    if (max > buf.length) { max = buf.length; }\r\n\r\n    // go back from last position, until start of sequence found\r\n    pos = max-1;\r\n    while (pos >= 0 && (buf[pos] & 0xC0) === 0x80) { pos--; }\r\n\r\n    // Fuckup - very small and broken sequence,\r\n    // return max, because we should return something anyway.\r\n    if (pos < 0) { return max; }\r\n\r\n    // If we came to start of buffer - that means vuffer is too small,\r\n    // return max too.\r\n    if (pos === 0) { return max; }\r\n\r\n    return (pos + _utf8len[buf[pos]] > max) ? pos : max;\r\n};\r\n\r\n// convert array to string\r\nvar buf2string = function (buf) {\r\n    var str, i, out, c, c_len;\r\n    var len = buf.length;\r\n\r\n    // Reserve max possible length (2 words per char)\r\n    // NB: by unknown reasons, Array is significantly faster for\r\n    //     String.fromCharCode.apply than Uint16Array.\r\n    var utf16buf = new Array(len*2);\r\n\r\n    for (out=0, i=0; i<len;) {\r\n        c = buf[i++];\r\n        // quick process ascii\r\n        if (c < 0x80) { utf16buf[out++] = c; continue; }\r\n\r\n        c_len = _utf8len[c];\r\n        // skip 5 & 6 byte codes\r\n        if (c_len > 4) { utf16buf[out++] = 0xfffd; i += c_len-1; continue; }\r\n\r\n        // apply mask on first byte\r\n        c &= c_len === 2 ? 0x1f : c_len === 3 ? 0x0f : 0x07;\r\n        // join the rest\r\n        while (c_len > 1 && i < len) {\r\n            c = (c << 6) | (buf[i++] & 0x3f);\r\n            c_len--;\r\n        }\r\n\r\n        // terminated by end of string?\r\n        if (c_len > 1) { utf16buf[out++] = 0xfffd; continue; }\r\n\r\n        if (c < 0x10000) {\r\n            utf16buf[out++] = c;\r\n        } else {\r\n            c -= 0x10000;\r\n            utf16buf[out++] = 0xd800 | ((c >> 10) & 0x3ff);\r\n            utf16buf[out++] = 0xdc00 | (c & 0x3ff);\r\n        }\r\n    }\r\n\r\n    // shrinkBuf(utf16buf, out)\r\n    if (utf16buf.length !== out) {\r\n        if(utf16buf.subarray) {\r\n            utf16buf = utf16buf.subarray(0, out);\r\n        } else {\r\n            utf16buf.length = out;\r\n        }\r\n    }\r\n\r\n    // return String.fromCharCode.apply(null, utf16buf);\r\n    return utils.applyFromCharCode(utf16buf);\r\n};\r\n\r\n\r\n// That\'s all for the pako functions.\r\n\r\n\r\n/**\r\n * Transform a javascript string into an array (typed if possible) of bytes,\r\n * UTF-8 encoded.\r\n * @param {String} str the string to encode\r\n * @return {Array|Uint8Array|Buffer} the UTF-8 encoded string.\r\n */\r\nexports.utf8encode = function utf8encode(str) {\r\n    if (support.nodebuffer) {\r\n        return nodejsUtils.newBufferFrom(str, "utf-8");\r\n    }\r\n\r\n    return string2buf(str);\r\n};\r\n\r\n\r\n/**\r\n * Transform a bytes array (or a representation) representing an UTF-8 encoded\r\n * string into a javascript string.\r\n * @param {Array|Uint8Array|Buffer} buf the data de decode\r\n * @return {String} the decoded string.\r\n */\r\nexports.utf8decode = function utf8decode(buf) {\r\n    if (support.nodebuffer) {\r\n        return utils.transformTo("nodebuffer", buf).toString("utf-8");\r\n    }\r\n\r\n    buf = utils.transformTo(support.uint8array ? "uint8array" : "array", buf);\r\n\r\n    return buf2string(buf);\r\n};\r\n\r\n/**\r\n * A worker to decode utf8 encoded binary chunks into string chunks.\r\n * @constructor\r\n */\r\nfunction Utf8DecodeWorker() {\r\n    GenericWorker.call(this, "utf-8 decode");\r\n    // the last bytes if a chunk didn\'t end with a complete codepoint.\r\n    this.leftOver = null;\r\n}\r\nutils.inherits(Utf8DecodeWorker, GenericWorker);\r\n\r\n/**\r\n * @see GenericWorker.processChunk\r\n */\r\nUtf8DecodeWorker.prototype.processChunk = function (chunk) {\r\n\r\n    var data = utils.transformTo(support.uint8array ? "uint8array" : "array", chunk.data);\r\n\r\n    // 1st step, re-use what\'s left of the previous chunk\r\n    if (this.leftOver && this.leftOver.length) {\r\n        if(support.uint8array) {\r\n            var previousData = data;\r\n            data = new Uint8Array(previousData.length + this.leftOver.length);\r\n            data.set(this.leftOver, 0);\r\n            data.set(previousData, this.leftOver.length);\r\n        } else {\r\n            data = this.leftOver.concat(data);\r\n        }\r\n        this.leftOver = null;\r\n    }\r\n\r\n    var nextBoundary = utf8border(data);\r\n    var usableData = data;\r\n    if (nextBoundary !== data.length) {\r\n        if (support.uint8array) {\r\n            usableData = data.subarray(0, nextBoundary);\r\n            this.leftOver = data.subarray(nextBoundary, data.length);\r\n        } else {\r\n            usableData = data.slice(0, nextBoundary);\r\n            this.leftOver = data.slice(nextBoundary, data.length);\r\n        }\r\n    }\r\n\r\n    this.push({\r\n        data : exports.utf8decode(usableData),\r\n        meta : chunk.meta\r\n    });\r\n};\r\n\r\n/**\r\n * @see GenericWorker.flush\r\n */\r\nUtf8DecodeWorker.prototype.flush = function () {\r\n    if(this.leftOver && this.leftOver.length) {\r\n        this.push({\r\n            data : exports.utf8decode(this.leftOver),\r\n            meta : {}\r\n        });\r\n        this.leftOver = null;\r\n    }\r\n};\r\nexports.Utf8DecodeWorker = Utf8DecodeWorker;\r\n\r\n/**\r\n * A worker to endcode string chunks into utf8 encoded binary chunks.\r\n * @constructor\r\n */\r\nfunction Utf8EncodeWorker() {\r\n    GenericWorker.call(this, "utf-8 encode");\r\n}\r\nutils.inherits(Utf8EncodeWorker, GenericWorker);\r\n\r\n/**\r\n * @see GenericWorker.processChunk\r\n */\r\nUtf8EncodeWorker.prototype.processChunk = function (chunk) {\r\n    this.push({\r\n        data : exports.utf8encode(chunk.data),\r\n        meta : chunk.meta\r\n    });\r\n};\r\nexports.Utf8EncodeWorker = Utf8EncodeWorker;\r\n\n\n//# sourceURL=webpack:///./lib/utf8.js?')},"./lib/utils.js":function(module,exports,__webpack_require__){"use strict"
;eval('\r\n\r\nvar support = __webpack_require__(/*! ./support */ "./lib/support.js");\r\nvar base64 = __webpack_require__(/*! ./base64 */ "./lib/base64.js");\r\nvar nodejsUtils = __webpack_require__(/*! ./nodejsUtils */ "./lib/nodejsUtils.js");\r\nvar setImmediate = __webpack_require__(/*! set-immediate-shim */ "./node_modules/set-immediate-shim/index.js");\r\nvar external = __webpack_require__(/*! ./external */ "./lib/external.js");\r\n\r\n\r\n/**\r\n * Convert a string that pass as a "binary string": it should represent a byte\r\n * array but may have > 255 char codes. Be sure to take only the first byte\r\n * and returns the byte array.\r\n * @param {String} str the string to transform.\r\n * @return {Array|Uint8Array} the string in a binary format.\r\n */\r\nfunction string2binary(str) {\r\n    var result = null;\r\n    if (support.uint8array) {\r\n      result = new Uint8Array(str.length);\r\n    } else {\r\n      result = new Array(str.length);\r\n    }\r\n    return stringToArrayLike(str, result);\r\n}\r\n\r\n/**\r\n * Create a new blob with the given content and the given type.\r\n * @param {String|ArrayBuffer} part the content to put in the blob. DO NOT use\r\n * an Uint8Array because the stock browser of android 4 won\'t accept it (it\r\n * will be silently converted to a string, "[object Uint8Array]").\r\n *\r\n * Use only ONE part to build the blob to avoid a memory leak in IE11 / Edge:\r\n * when a large amount of Array is used to create the Blob, the amount of\r\n * memory consumed is nearly 100 times the original data amount.\r\n *\r\n * @param {String} type the mime type of the blob.\r\n * @return {Blob} the created blob.\r\n */\r\nexports.newBlob = function(part, type) {\r\n    exports.checkSupport("blob");\r\n\r\n    try {\r\n        // Blob constructor\r\n        return new Blob([part], {\r\n            type: type\r\n        });\r\n    }\r\n    catch (e) {\r\n\r\n        try {\r\n            // deprecated, browser only, old way\r\n            var Builder = self.BlobBuilder || self.WebKitBlobBuilder || self.MozBlobBuilder || self.MSBlobBuilder;\r\n            var builder = new Builder();\r\n            builder.append(part);\r\n            return builder.getBlob(type);\r\n        }\r\n        catch (e) {\r\n\r\n            // well, fuck ?!\r\n            throw new Error("Bug : can\'t construct the Blob.");\r\n        }\r\n    }\r\n\r\n\r\n};\r\n/**\r\n * The identity function.\r\n * @param {Object} input the input.\r\n * @return {Object} the same input.\r\n */\r\nfunction identity(input) {\r\n    return input;\r\n}\r\n\r\n/**\r\n * Fill in an array with a string.\r\n * @param {String} str the string to use.\r\n * @param {Array|ArrayBuffer|Uint8Array|Buffer} array the array to fill in (will be mutated).\r\n * @return {Array|ArrayBuffer|Uint8Array|Buffer} the updated array.\r\n */\r\nfunction stringToArrayLike(str, array) {\r\n    for (var i = 0; i < str.length; ++i) {\r\n        array[i] = str.charCodeAt(i) & 0xFF;\r\n    }\r\n    return array;\r\n}\r\n\r\n/**\r\n * An helper for the function arrayLikeToString.\r\n * This contains static informations and functions that\r\n * can be optimized by the browser JIT compiler.\r\n */\r\nvar arrayToStringHelper = {\r\n    /**\r\n     * Transform an array of int into a string, chunk by chunk.\r\n     * See the performances notes on arrayLikeToString.\r\n     * @param {Array|ArrayBuffer|Uint8Array|Buffer} array the array to transform.\r\n     * @param {String} type the type of the array.\r\n     * @param {Integer} chunk the chunk size.\r\n     * @return {String} the resulting string.\r\n     * @throws Error if the chunk is too big for the stack.\r\n     */\r\n    stringifyByChunk: function(array, type, chunk) {\r\n        var result = [], k = 0, len = array.length;\r\n        // shortcut\r\n        if (len <= chunk) {\r\n            return String.fromCharCode.apply(null, array);\r\n        }\r\n        while (k < len) {\r\n            if (type === "array" || type === "nodebuffer") {\r\n                result.push(String.fromCharCode.apply(null, array.slice(k, Math.min(k + chunk, len))));\r\n            }\r\n            else {\r\n                result.push(String.fromCharCode.apply(null, array.subarray(k, Math.min(k + chunk, len))));\r\n            }\r\n            k += chunk;\r\n        }\r\n        return result.join("");\r\n    },\r\n    /**\r\n     * Call String.fromCharCode on every item in the array.\r\n     * This is the naive implementation, which generate A LOT of intermediate string.\r\n     * This should be used when everything else fail.\r\n     * @param {Array|ArrayBuffer|Uint8Array|Buffer} array the array to transform.\r\n     * @return {String} the result.\r\n     */\r\n    stringifyByChar: function(array){\r\n        var resultStr = "";\r\n        for(var i = 0; i < array.length; i++) {\r\n            resultStr += String.fromCharCode(array[i]);\r\n        }\r\n        return resultStr;\r\n    },\r\n    applyCanBeUsed : {\r\n        /**\r\n         * true if the browser accepts to use String.fromCharCode on Uint8Array\r\n         */\r\n        uint8array : (function () {\r\n            try {\r\n                return support.uint8array && String.fromCharCode.apply(null, new Uint8Array(1)).length === 1;\r\n            } catch (e) {\r\n                return false;\r\n            }\r\n        })(),\r\n        /**\r\n         * true if the browser accepts to use String.fromCharCode on nodejs Buffer.\r\n         */\r\n        nodebuffer : (function () {\r\n            try {\r\n                return support.nodebuffer && String.fromCharCode.apply(null, nodejsUtils.allocBuffer(1)).length === 1;\r\n            } catch (e) {\r\n                return false;\r\n            }\r\n        })()\r\n    }\r\n};\r\n\r\n/**\r\n * Transform an array-like object to a string.\r\n * @param {Array|ArrayBuffer|Uint8Array|Buffer} array the array to transform.\r\n * @return {String} the result.\r\n */\r\nfunction arrayLikeToString(array) {\r\n    // Performances notes :\r\n    // --------------------\r\n    // String.fromCharCode.apply(null, array) is the fastest, see\r\n    // see http://jsperf.com/converting-a-uint8array-to-a-string/2\r\n    // but the stack is limited (and we can get huge arrays !).\r\n    //\r\n    // result += String.fromCharCode(array[i]); generate too many strings !\r\n    //\r\n    // This code is inspired by http://jsperf.com/arraybuffer-to-string-apply-performance/2\r\n    // TODO : we now have workers that split the work. Do we still need that ?\r\n    var chunk = 65536,\r\n        type = exports.getTypeOf(array),\r\n        canUseApply = true;\r\n    if (type === "uint8array") {\r\n        canUseApply = arrayToStringHelper.applyCanBeUsed.uint8array;\r\n    } else if (type === "nodebuffer") {\r\n        canUseApply = arrayToStringHelper.applyCanBeUsed.nodebuffer;\r\n    }\r\n\r\n    if (canUseApply) {\r\n        while (chunk > 1) {\r\n            try {\r\n                return arrayToStringHelper.stringifyByChunk(array, type, chunk);\r\n            } catch (e) {\r\n                chunk = Math.floor(chunk / 2);\r\n            }\r\n        }\r\n    }\r\n\r\n    // no apply or chunk error : slow and painful algorithm\r\n    // default browser on android 4.*\r\n    return arrayToStringHelper.stringifyByChar(array);\r\n}\r\n\r\nexports.applyFromCharCode = arrayLikeToString;\r\n\r\n\r\n/**\r\n * Copy the data from an array-like to an other array-like.\r\n * @param {Array|ArrayBuffer|Uint8Array|Buffer} arrayFrom the origin array.\r\n * @param {Array|ArrayBuffer|Uint8Array|Buffer} arrayTo the destination array which will be mutated.\r\n * @return {Array|ArrayBuffer|Uint8Array|Buffer} the updated destination array.\r\n */\r\nfunction arrayLikeToArrayLike(arrayFrom, arrayTo) {\r\n    for (var i = 0; i < arrayFrom.length; i++) {\r\n        arrayTo[i] = arrayFrom[i];\r\n    }\r\n    return arrayTo;\r\n}\r\n\r\n// a matrix containing functions to transform everything into everything.\r\nvar transform = {};\r\n\r\n// string to ?\r\ntransform["string"] = {\r\n    "string": identity,\r\n    "array": function(input) {\r\n        return stringToArrayLike(input, new Array(input.length));\r\n    },\r\n    "arraybuffer": function(input) {\r\n        return transform["string"]["uint8array"](input).buffer;\r\n    },\r\n    "uint8array": function(input) {\r\n        return stringToArrayLike(input, new Uint8Array(input.length));\r\n    },\r\n    "nodebuffer": function(input) {\r\n        return stringToArrayLike(input, nodejsUtils.allocBuffer(input.length));\r\n    }\r\n};\r\n\r\n// array to ?\r\ntransform["array"] = {\r\n    "string": arrayLikeToString,\r\n    "array": identity,\r\n    "arraybuffer": function(input) {\r\n        return (new Uint8Array(input)).buffer;\r\n    },\r\n    "uint8array": function(input) {\r\n        return new Uint8Array(input);\r\n    },\r\n    "nodebuffer": function(input) {\r\n        return nodejsUtils.newBufferFrom(input);\r\n    }\r\n};\r\n\r\n// arraybuffer to ?\r\ntransform["arraybuffer"] = {\r\n    "string": function(input) {\r\n        return arrayLikeToString(new Uint8Array(input));\r\n    },\r\n    "array": function(input) {\r\n        return arrayLikeToArrayLike(new Uint8Array(input), new Array(input.byteLength));\r\n    },\r\n    "arraybuffer": identity,\r\n    "uint8array": function(input) {\r\n        return new Uint8Array(input);\r\n    },\r\n    "nodebuffer": function(input) {\r\n        return nodejsUtils.newBufferFrom(new Uint8Array(input));\r\n    }\r\n};\r\n\r\n// uint8array to ?\r\ntransform["uint8array"] = {\r\n    "string": arrayLikeToString,\r\n    "array": function(input) {\r\n        return arrayLikeToArrayLike(input, new Array(input.length));\r\n    },\r\n    "arraybuffer": function(input) {\r\n        return input.buffer;\r\n    },\r\n    "uint8array": identity,\r\n    "nodebuffer": function(input) {\r\n        return nodejsUtils.newBufferFrom(input);\r\n    }\r\n};\r\n\r\n// nodebuffer to ?\r\ntransform["nodebuffer"] = {\r\n    "string": arrayLikeToString,\r\n    "array": function(input) {\r\n        return arrayLikeToArrayLike(input, new Array(input.length));\r\n    },\r\n    "arraybuffer": function(input) {\r\n        return transform["nodebuffer"]["uint8array"](input).buffer;\r\n    },\r\n    "uint8array": function(input) {\r\n        return arrayLikeToArrayLike(input, new Uint8Array(input.length));\r\n    },\r\n    "nodebuffer": identity\r\n};\r\n\r\n/**\r\n * Transform an input into any type.\r\n * The supported output type are : string, array, uint8array, arraybuffer, nodebuffer.\r\n * If no output type is specified, the unmodified input will be returned.\r\n * @param {String} outputType the output type.\r\n * @param {String|Array|ArrayBuffer|Uint8Array|Buffer} input the input to convert.\r\n * @throws {Error} an Error if the browser doesn\'t support the requested output type.\r\n */\r\nexports.transformTo = function(outputType, input) {\r\n    if (!input) {\r\n        // undefined, null, etc\r\n        // an empty string won\'t harm.\r\n        input = "";\r\n    }\r\n    if (!outputType) {\r\n        return input;\r\n    }\r\n    exports.checkSupport(outputType);\r\n    var inputType = exports.getTypeOf(input);\r\n    var result = transform[inputType][outputType](input);\r\n    return result;\r\n};\r\n\r\n/**\r\n * Return the type of the input.\r\n * The type will be in a format valid for JSZip.utils.transformTo : string, array, uint8array, arraybuffer.\r\n * @param {Object} input the input to identify.\r\n * @return {String} the (lowercase) type of the input.\r\n */\r\nexports.getTypeOf = function(input) {\r\n    if (typeof input === "string") {\r\n        return "string";\r\n    }\r\n    if (Object.prototype.toString.call(input) === "[object Array]") {\r\n        return "array";\r\n    }\r\n    if (support.nodebuffer && nodejsUtils.isBuffer(input)) {\r\n        return "nodebuffer";\r\n    }\r\n    if (support.uint8array && input instanceof Uint8Array) {\r\n        return "uint8array";\r\n    }\r\n    if (support.arraybuffer && input instanceof ArrayBuffer) {\r\n        return "arraybuffer";\r\n    }\r\n};\r\n\r\n/**\r\n * Throw an exception if the type is not supported.\r\n * @param {String} type the type to check.\r\n * @throws {Error} an Error if the browser doesn\'t support the requested type.\r\n */\r\nexports.checkSupport = function(type) {\r\n    var supported = support[type.toLowerCase()];\r\n    if (!supported) {\r\n        throw new Error(type + " is not supported by this platform");\r\n    }\r\n};\r\n\r\nexports.MAX_VALUE_16BITS = 65535;\r\nexports.MAX_VALUE_32BITS = -1; // well, "\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF\\xFF" is parsed as -1\r\n\r\n/**\r\n * Prettify a string read as binary.\r\n * @param {string} str the string to prettify.\r\n * @return {string} a pretty string.\r\n */\r\nexports.pretty = function(str) {\r\n    var res = \'\',\r\n        code, i;\r\n    for (i = 0; i < (str || "").length; i++) {\r\n        code = str.charCodeAt(i);\r\n        res += \'\\\\x\' + (code < 16 ? "0" : "") + code.toString(16).toUpperCase();\r\n    }\r\n    return res;\r\n};\r\n\r\n/**\r\n * Defer the call of a function.\r\n * @param {Function} callback the function to call asynchronously.\r\n * @param {Array} args the arguments to give to the callback.\r\n */\r\nexports.delay = function(callback, args, self) {\r\n    setImmediate(function () {\r\n        callback.apply(self || null, args || []);\r\n    });\r\n};\r\n\r\n/**\r\n * Extends a prototype with an other, without calling a constructor with\r\n * side effects. Inspired by nodejs\' `utils.inherits`\r\n * @param {Function} ctor the constructor to augment\r\n * @param {Function} superCtor the parent constructor to use\r\n */\r\nexports.inherits = function (ctor, superCtor) {\r\n    var Obj = function() {};\r\n    Obj.prototype = superCtor.prototype;\r\n    ctor.prototype = new Obj();\r\n};\r\n\r\n/**\r\n * Merge the objects passed as parameters into a new one.\r\n * @private\r\n * @param {...Object} var_args All objects to merge.\r\n * @return {Object} a new object with the data of the others.\r\n */\r\nexports.extend = function() {\r\n    var result = {}, i, attr;\r\n    for (i = 0; i < arguments.length; i++) { // arguments is not enumerable in some browsers\r\n        for (attr in arguments[i]) {\r\n            if (arguments[i].hasOwnProperty(attr) && typeof result[attr] === "undefined") {\r\n                result[attr] = arguments[i][attr];\r\n            }\r\n        }\r\n    }\r\n    return result;\r\n};\r\n\r\n/**\r\n * Transform arbitrary content into a Promise.\r\n * @param {String} name a name for the content being processed.\r\n * @param {Object} inputData the content to process.\r\n * @param {Boolean} isBinary true if the content is not an unicode string\r\n * @param {Boolean} isOptimizedBinaryString true if the string content only has one byte per character.\r\n * @param {Boolean} isBase64 true if the string content is encoded with base64.\r\n * @return {Promise} a promise in a format usable by JSZip.\r\n */\r\nexports.prepareContent = function(name, inputData, isBinary, isOptimizedBinaryString, isBase64) {\r\n\r\n    // if inputData is already a promise, this flatten it.\r\n    var promise = external.Promise.resolve(inputData).then(function(data) {\r\n        \r\n        \r\n        var isBlob = support.blob && (data instanceof Blob || [\'[object File]\', \'[object Blob]\'].indexOf(Object.prototype.toString.call(data)) !== -1);\r\n\r\n        if (isBlob && typeof FileReader !== "undefined") {\r\n            return new external.Promise(function (resolve, reject) {\r\n                var reader = new FileReader();\r\n\r\n                reader.onload = function(e) {\r\n                    resolve(e.target.result);\r\n                };\r\n                reader.onerror = function(e) {\r\n                    reject(e.target.error);\r\n                };\r\n                reader.readAsArrayBuffer(data);\r\n            });\r\n        } else {\r\n            return data;\r\n        }\r\n    });\r\n\r\n    return promise.then(function(data) {\r\n        var dataType = exports.getTypeOf(data);\r\n\r\n        if (!dataType) {\r\n            return external.Promise.reject(\r\n                new Error("Can\'t read the data of \'" + name + "\'. Is it " +\r\n                          "in a supported JavaScript type (String, Blob, ArrayBuffer, etc) ?")\r\n            );\r\n        }\r\n        // special case : it\'s way easier to work with Uint8Array than with ArrayBuffer\r\n        if (dataType === "arraybuffer") {\r\n            data = exports.transformTo("uint8array", data);\r\n        } else if (dataType === "string") {\r\n            if (isBase64) {\r\n                data = base64.decode(data);\r\n            }\r\n            else if (isBinary) {\r\n                // optimizedBinaryString === true means that the file has already been filtered with a 0xFF mask\r\n                if (isOptimizedBinaryString !== true) {\r\n                    // this is a string, not in a base64 format.\r\n                    // Be sure that this is a correct "binary string"\r\n                    data = string2binary(data);\r\n                }\r\n            }\r\n        }\r\n        return data;\r\n    });\r\n};\r\n\n\n//# sourceURL=webpack:///./lib/utils.js?')},"./lib/zipEntries.js":function(module,exports,__webpack_require__){"use strict";eval('\r\nvar readerFor = __webpack_require__(/*! ./reader/readerFor */ "./lib/reader/readerFor.js");\r\nvar utils = __webpack_require__(/*! ./utils */ "./lib/utils.js");\r\nvar sig = __webpack_require__(/*! ./signature */ "./lib/signature.js");\r\nvar ZipEntry = __webpack_require__(/*! ./zipEntry */ "./lib/zipEntry.js");\r\nvar utf8 = __webpack_require__(/*! ./utf8 */ "./lib/utf8.js");\r\nvar support = __webpack_require__(/*! ./support */ "./lib/support.js");\r\n//  class ZipEntries {{{\r\n/**\r\n * All the entries in the zip file.\r\n * @constructor\r\n * @param {Object} loadOptions Options for loading the stream.\r\n */\r\nfunction ZipEntries(loadOptions) {\r\n    this.files = [];\r\n    this.loadOptions = loadOptions;\r\n}\r\nZipEntries.prototype = {\r\n    /**\r\n     * Check that the reader is on the specified signature.\r\n     * @param {string} expectedSignature the expected signature.\r\n     * @throws {Error} if it is an other signature.\r\n     */\r\n    checkSignature: function(expectedSignature) {\r\n        if (!this.reader.readAndCheckSignature(expectedSignature)) {\r\n            this.reader.index -= 4;\r\n            var signature = this.reader.readString(4);\r\n            throw new Error("Corrupted zip or bug: unexpected signature " + "(" + utils.pretty(signature) + ", expected " + utils.pretty(expectedSignature) + ")");\r\n        }\r\n    },\r\n    /**\r\n     * Check if the given signature is at the given index.\r\n     * @param {number} askedIndex the index to check.\r\n     * @param {string} expectedSignature the signature to expect.\r\n     * @return {boolean} true if the signature is here, false otherwise.\r\n     */\r\n    isSignature: function(askedIndex, expectedSignature) {\r\n        var currentIndex = this.reader.index;\r\n        this.reader.setIndex(askedIndex);\r\n        var signature = this.reader.readString(4);\r\n        var result = signature === expectedSignature;\r\n        this.reader.setIndex(currentIndex);\r\n        return result;\r\n    },\r\n    /**\r\n     * Read the end of the central directory.\r\n     */\r\n    readBlockEndOfCentral: function() {\r\n        this.diskNumber = this.reader.readInt(2);\r\n        this.diskWithCentralDirStart = this.reader.readInt(2);\r\n        this.centralDirRecordsOnThisDisk = this.reader.readInt(2);\r\n        this.centralDirRecords = this.reader.readInt(2);\r\n        this.centralDirSize = this.reader.readInt(4);\r\n        this.centralDirOffset = this.reader.readInt(4);\r\n\r\n        this.zipCommentLength = this.reader.readInt(2);\r\n        // warning : the encoding depends of the system locale\r\n        // On a linux machine with LANG=en_US.utf8, this field is utf8 encoded.\r\n        // On a windows machine, this field is encoded with the localized windows code page.\r\n        var zipComment = this.reader.readData(this.zipCommentLength);\r\n        var decodeParamType = support.uint8array ? "uint8array" : "array";\r\n        // To get consistent behavior with the generation part, we will assume that\r\n        // this is utf8 encoded unless specified otherwise.\r\n        var decodeContent = utils.transformTo(decodeParamType, zipComment);\r\n        this.zipComment = this.loadOptions.decodeFileName(decodeContent);\r\n    },\r\n    /**\r\n     * Read the end of the Zip 64 central directory.\r\n     * Not merged with the method readEndOfCentral :\r\n     * The end of central can coexist with its Zip64 brother,\r\n     * I don\'t want to read the wrong number of bytes !\r\n     */\r\n    readBlockZip64EndOfCentral: function() {\r\n        this.zip64EndOfCentralSize = this.reader.readInt(8);\r\n        this.reader.skip(4);\r\n        // this.versionMadeBy = this.reader.readString(2);\r\n        // this.versionNeeded = this.reader.readInt(2);\r\n        this.diskNumber = this.reader.readInt(4);\r\n        this.diskWithCentralDirStart = this.reader.readInt(4);\r\n        this.centralDirRecordsOnThisDisk = this.reader.readInt(8);\r\n        this.centralDirRecords = this.reader.readInt(8);\r\n        this.centralDirSize = this.reader.readInt(8);\r\n        this.centralDirOffset = this.reader.readInt(8);\r\n\r\n        this.zip64ExtensibleData = {};\r\n        var extraDataSize = this.zip64EndOfCentralSize - 44,\r\n            index = 0,\r\n            extraFieldId,\r\n            extraFieldLength,\r\n            extraFieldValue;\r\n        while (index < extraDataSize) {\r\n            extraFieldId = this.reader.readInt(2);\r\n            extraFieldLength = this.reader.readInt(4);\r\n            extraFieldValue = this.reader.readData(extraFieldLength);\r\n            this.zip64ExtensibleData[extraFieldId] = {\r\n                id: extraFieldId,\r\n                length: extraFieldLength,\r\n                value: extraFieldValue\r\n            };\r\n        }\r\n    },\r\n    /**\r\n     * Read the end of the Zip 64 central directory locator.\r\n     */\r\n    readBlockZip64EndOfCentralLocator: function() {\r\n        this.diskWithZip64CentralDirStart = this.reader.readInt(4);\r\n        this.relativeOffsetEndOfZip64CentralDir = this.reader.readInt(8);\r\n        this.disksCount = this.reader.readInt(4);\r\n        if (this.disksCount > 1) {\r\n            throw new Error("Multi-volumes zip are not supported");\r\n        }\r\n    },\r\n    /**\r\n     * Read the local files, based on the offset read in the central part.\r\n     */\r\n    readLocalFiles: function() {\r\n        var i, file;\r\n        for (i = 0; i < this.files.length; i++) {\r\n            file = this.files[i];\r\n            this.reader.setIndex(file.localHeaderOffset);\r\n            this.checkSignature(sig.LOCAL_FILE_HEADER);\r\n            file.readLocalPart(this.reader);\r\n            file.handleUTF8();\r\n            file.processAttributes();\r\n        }\r\n    },\r\n    /**\r\n     * Read the central directory.\r\n     */\r\n    readCentralDir: function() {\r\n        var file;\r\n\r\n        this.reader.setIndex(this.centralDirOffset);\r\n        while (this.reader.readAndCheckSignature(sig.CENTRAL_FILE_HEADER)) {\r\n            file = new ZipEntry({\r\n                zip64: this.zip64\r\n            }, this.loadOptions);\r\n            file.readCentralPart(this.reader);\r\n            this.files.push(file);\r\n        }\r\n\r\n        if (this.centralDirRecords !== this.files.length) {\r\n            if (this.centralDirRecords !== 0 && this.files.length === 0) {\r\n                // We expected some records but couldn\'t find ANY.\r\n                // This is really suspicious, as if something went wrong.\r\n                throw new Error("Corrupted zip or bug: expected " + this.centralDirRecords + " records in central dir, got " + this.files.length);\r\n            } else {\r\n                // We found some records but not all.\r\n                // Something is wrong but we got something for the user: no error here.\r\n                // console.warn("expected", this.centralDirRecords, "records in central dir, got", this.files.length);\r\n            }\r\n        }\r\n    },\r\n    /**\r\n     * Read the end of central directory.\r\n     */\r\n    readEndOfCentral: function() {\r\n        var offset = this.reader.lastIndexOfSignature(sig.CENTRAL_DIRECTORY_END);\r\n        if (offset < 0) {\r\n            // Check if the content is a truncated zip or complete garbage.\r\n            // A "LOCAL_FILE_HEADER" is not required at the beginning (auto\r\n            // extractible zip for example) but it can give a good hint.\r\n            // If an ajax request was used without responseType, we will also\r\n            // get unreadable data.\r\n            var isGarbage = !this.isSignature(0, sig.LOCAL_FILE_HEADER);\r\n\r\n            if (isGarbage) {\r\n                throw new Error("Can\'t find end of central directory : is this a zip file ? " +\r\n                                "If it is, see https://stuk.github.io/jszip/documentation/howto/read_zip.html");\r\n            } else {\r\n                throw new Error("Corrupted zip: can\'t find end of central directory");\r\n            }\r\n\r\n        }\r\n        this.reader.setIndex(offset);\r\n        var endOfCentralDirOffset = offset;\r\n        this.checkSignature(sig.CENTRAL_DIRECTORY_END);\r\n        this.readBlockEndOfCentral();\r\n\r\n\r\n        /* extract from the zip spec :\r\n            4)  If one of the fields in the end of central directory\r\n                record is too small to hold required data, the field\r\n                should be set to -1 (0xFFFF or 0xFFFFFFFF) and the\r\n                ZIP64 format record should be created.\r\n            5)  The end of central directory record and the\r\n                Zip64 end of central directory locator record must\r\n                reside on the same disk when splitting or spanning\r\n                an archive.\r\n         */\r\n        if (this.diskNumber === utils.MAX_VALUE_16BITS || this.diskWithCentralDirStart === utils.MAX_VALUE_16BITS || this.centralDirRecordsOnThisDisk === utils.MAX_VALUE_16BITS || this.centralDirRecords === utils.MAX_VALUE_16BITS || this.centralDirSize === utils.MAX_VALUE_32BITS || this.centralDirOffset === utils.MAX_VALUE_32BITS) {\r\n            this.zip64 = true;\r\n\r\n            /*\r\n            Warning : the zip64 extension is supported, but ONLY if the 64bits integer read from\r\n            the zip file can fit into a 32bits integer. This cannot be solved : JavaScript represents\r\n            all numbers as 64-bit double precision IEEE 754 floating point numbers.\r\n            So, we have 53bits for integers and bitwise operations treat everything as 32bits.\r\n            see https://developer.mozilla.org/en-US/docs/JavaScript/Reference/Operators/Bitwise_Operators\r\n            and http://www.ecma-international.org/publications/files/ECMA-ST/ECMA-262.pdf section 8.5\r\n            */\r\n\r\n            // should look for a zip64 EOCD locator\r\n            offset = this.reader.lastIndexOfSignature(sig.ZIP64_CENTRAL_DIRECTORY_LOCATOR);\r\n            if (offset < 0) {\r\n                throw new Error("Corrupted zip: can\'t find the ZIP64 end of central directory locator");\r\n            }\r\n            this.reader.setIndex(offset);\r\n            this.checkSignature(sig.ZIP64_CENTRAL_DIRECTORY_LOCATOR);\r\n            this.readBlockZip64EndOfCentralLocator();\r\n\r\n            // now the zip64 EOCD record\r\n            if (!this.isSignature(this.relativeOffsetEndOfZip64CentralDir, sig.ZIP64_CENTRAL_DIRECTORY_END)) {\r\n                // console.warn("ZIP64 end of central directory not where expected.");\r\n                this.relativeOffsetEndOfZip64CentralDir = this.reader.lastIndexOfSignature(sig.ZIP64_CENTRAL_DIRECTORY_END);\r\n                if (this.relativeOffsetEndOfZip64CentralDir < 0) {\r\n                    throw new Error("Corrupted zip: can\'t find the ZIP64 end of central directory");\r\n                }\r\n            }\r\n            this.reader.setIndex(this.relativeOffsetEndOfZip64CentralDir);\r\n            this.checkSignature(sig.ZIP64_CENTRAL_DIRECTORY_END);\r\n            this.readBlockZip64EndOfCentral();\r\n        }\r\n\r\n        var expectedEndOfCentralDirOffset = this.centralDirOffset + this.centralDirSize;\r\n        if (this.zip64) {\r\n            expectedEndOfCentralDirOffset += 20; // end of central dir 64 locator\r\n            expectedEndOfCentralDirOffset += 12 /* should not include the leading 12 bytes */ + this.zip64EndOfCentralSize;\r\n        }\r\n\r\n        var extraBytes = endOfCentralDirOffset - expectedEndOfCentralDirOffset;\r\n\r\n        if (extraBytes > 0) {\r\n            // console.warn(extraBytes, "extra bytes at beginning or within zipfile");\r\n            if (this.isSignature(endOfCentralDirOffset, sig.CENTRAL_FILE_HEADER)) {\r\n                // The offsets seem wrong, but we have something at the specified offset.\r\n                // So… we keep it.\r\n            } else {\r\n                // the offset is wrong, update the "zero" of the reader\r\n                // this happens if data has been prepended (crx files for example)\r\n                this.reader.zero = extraBytes;\r\n            }\r\n        } else if (extraBytes < 0) {\r\n            throw new Error("Corrupted zip: missing " + Math.abs(extraBytes) + " bytes.");\r\n        }\r\n    },\r\n    prepareReader: function(data) {\r\n        this.reader = readerFor(data);\r\n    },\r\n    /**\r\n     * Read a zip file and create ZipEntries.\r\n     * @param {String|ArrayBuffer|Uint8Array|Buffer} data the binary string representing a zip file.\r\n     */\r\n    load: function(data) {\r\n        this.prepareReader(data);\r\n        this.readEndOfCentral();\r\n        this.readCentralDir();\r\n        this.readLocalFiles();\r\n    }\r\n};\r\n// }}} end of ZipEntries\r\nmodule.exports = ZipEntries;\r\n\n\n//# sourceURL=webpack:///./lib/zipEntries.js?')},"./lib/zipEntry.js":function(module,exports,__webpack_require__){"use strict"
;eval('\r\nvar readerFor = __webpack_require__(/*! ./reader/readerFor */ "./lib/reader/readerFor.js");\r\nvar utils = __webpack_require__(/*! ./utils */ "./lib/utils.js");\r\nvar CompressedObject = __webpack_require__(/*! ./compressedObject */ "./lib/compressedObject.js");\r\nvar crc32fn = __webpack_require__(/*! ./crc32 */ "./lib/crc32.js");\r\nvar utf8 = __webpack_require__(/*! ./utf8 */ "./lib/utf8.js");\r\nvar compressions = __webpack_require__(/*! ./compressions */ "./lib/compressions.js");\r\nvar support = __webpack_require__(/*! ./support */ "./lib/support.js");\r\n\r\nvar MADE_BY_DOS = 0x00;\r\nvar MADE_BY_UNIX = 0x03;\r\n\r\n/**\r\n * Find a compression registered in JSZip.\r\n * @param {string} compressionMethod the method magic to find.\r\n * @return {Object|null} the JSZip compression object, null if none found.\r\n */\r\nvar findCompression = function(compressionMethod) {\r\n    for (var method in compressions) {\r\n        if (!compressions.hasOwnProperty(method)) {\r\n            continue;\r\n        }\r\n        if (compressions[method].magic === compressionMethod) {\r\n            return compressions[method];\r\n        }\r\n    }\r\n    return null;\r\n};\r\n\r\n// class ZipEntry {{{\r\n/**\r\n * An entry in the zip file.\r\n * @constructor\r\n * @param {Object} options Options of the current file.\r\n * @param {Object} loadOptions Options for loading the stream.\r\n */\r\nfunction ZipEntry(options, loadOptions) {\r\n    this.options = options;\r\n    this.loadOptions = loadOptions;\r\n}\r\nZipEntry.prototype = {\r\n    /**\r\n     * say if the file is encrypted.\r\n     * @return {boolean} true if the file is encrypted, false otherwise.\r\n     */\r\n    isEncrypted: function() {\r\n        // bit 1 is set\r\n        return (this.bitFlag & 0x0001) === 0x0001;\r\n    },\r\n    /**\r\n     * say if the file has utf-8 filename/comment.\r\n     * @return {boolean} true if the filename/comment is in utf-8, false otherwise.\r\n     */\r\n    useUTF8: function() {\r\n        // bit 11 is set\r\n        return (this.bitFlag & 0x0800) === 0x0800;\r\n    },\r\n    /**\r\n     * Read the local part of a zip file and add the info in this object.\r\n     * @param {DataReader} reader the reader to use.\r\n     */\r\n    readLocalPart: function(reader) {\r\n        var compression, localExtraFieldsLength;\r\n\r\n        // we already know everything from the central dir !\r\n        // If the central dir data are false, we are doomed.\r\n        // On the bright side, the local part is scary  : zip64, data descriptors, both, etc.\r\n        // The less data we get here, the more reliable this should be.\r\n        // Let\'s skip the whole header and dash to the data !\r\n        reader.skip(22);\r\n        // in some zip created on windows, the filename stored in the central dir contains \\ instead of /.\r\n        // Strangely, the filename here is OK.\r\n        // I would love to treat these zip files as corrupted (see http://www.info-zip.org/FAQ.html#backslashes\r\n        // or APPNOTE#4.4.17.1, "All slashes MUST be forward slashes \'/\'") but there are a lot of bad zip generators...\r\n        // Search "unzip mismatching "local" filename continuing with "central" filename version" on\r\n        // the internet.\r\n        //\r\n        // I think I see the logic here : the central directory is used to display\r\n        // content and the local directory is used to extract the files. Mixing / and \\\r\n        // may be used to display \\ to windows users and use / when extracting the files.\r\n        // Unfortunately, this lead also to some issues : http://seclists.org/fulldisclosure/2009/Sep/394\r\n        this.fileNameLength = reader.readInt(2);\r\n        localExtraFieldsLength = reader.readInt(2); // can\'t be sure this will be the same as the central dir\r\n        // the fileName is stored as binary data, the handleUTF8 method will take care of the encoding.\r\n        this.fileName = reader.readData(this.fileNameLength);\r\n        reader.skip(localExtraFieldsLength);\r\n\r\n        if (this.compressedSize === -1 || this.uncompressedSize === -1) {\r\n            throw new Error("Bug or corrupted zip : didn\'t get enough informations from the central directory " + "(compressedSize === -1 || uncompressedSize === -1)");\r\n        }\r\n\r\n        compression = findCompression(this.compressionMethod);\r\n        if (compression === null) { // no compression found\r\n            throw new Error("Corrupted zip : compression " + utils.pretty(this.compressionMethod) + " unknown (inner file : " + utils.transformTo("string", this.fileName) + ")");\r\n        }\r\n        this.decompressed = new CompressedObject(this.compressedSize, this.uncompressedSize, this.crc32, compression, reader.readData(this.compressedSize));\r\n    },\r\n\r\n    /**\r\n     * Read the central part of a zip file and add the info in this object.\r\n     * @param {DataReader} reader the reader to use.\r\n     */\r\n    readCentralPart: function(reader) {\r\n        this.versionMadeBy = reader.readInt(2);\r\n        reader.skip(2);\r\n        // this.versionNeeded = reader.readInt(2);\r\n        this.bitFlag = reader.readInt(2);\r\n        this.compressionMethod = reader.readString(2);\r\n        this.date = reader.readDate();\r\n        this.crc32 = reader.readInt(4);\r\n        this.compressedSize = reader.readInt(4);\r\n        this.uncompressedSize = reader.readInt(4);\r\n        var fileNameLength = reader.readInt(2);\r\n        this.extraFieldsLength = reader.readInt(2);\r\n        this.fileCommentLength = reader.readInt(2);\r\n        this.diskNumberStart = reader.readInt(2);\r\n        this.internalFileAttributes = reader.readInt(2);\r\n        this.externalFileAttributes = reader.readInt(4);\r\n        this.localHeaderOffset = reader.readInt(4);\r\n\r\n        if (this.isEncrypted()) {\r\n            throw new Error("Encrypted zip are not supported");\r\n        }\r\n\r\n        // will be read in the local part, see the comments there\r\n        reader.skip(fileNameLength);\r\n        this.readExtraFields(reader);\r\n        this.parseZIP64ExtraField(reader);\r\n        this.fileComment = reader.readData(this.fileCommentLength);\r\n    },\r\n\r\n    /**\r\n     * Parse the external file attributes and get the unix/dos permissions.\r\n     */\r\n    processAttributes: function () {\r\n        this.unixPermissions = null;\r\n        this.dosPermissions = null;\r\n        var madeBy = this.versionMadeBy >> 8;\r\n\r\n        // Check if we have the DOS directory flag set.\r\n        // We look for it in the DOS and UNIX permissions\r\n        // but some unknown platform could set it as a compatibility flag.\r\n        this.dir = this.externalFileAttributes & 0x0010 ? true : false;\r\n\r\n        if(madeBy === MADE_BY_DOS) {\r\n            // first 6 bits (0 to 5)\r\n            this.dosPermissions = this.externalFileAttributes & 0x3F;\r\n        }\r\n\r\n        if(madeBy === MADE_BY_UNIX) {\r\n            this.unixPermissions = (this.externalFileAttributes >> 16) & 0xFFFF;\r\n            // the octal permissions are in (this.unixPermissions & 0x01FF).toString(8);\r\n        }\r\n\r\n        // fail safe : if the name ends with a / it probably means a folder\r\n        if (!this.dir && this.fileNameStr.slice(-1) === \'/\') {\r\n            this.dir = true;\r\n        }\r\n    },\r\n\r\n    /**\r\n     * Parse the ZIP64 extra field and merge the info in the current ZipEntry.\r\n     * @param {DataReader} reader the reader to use.\r\n     */\r\n    parseZIP64ExtraField: function(reader) {\r\n\r\n        if (!this.extraFields[0x0001]) {\r\n            return;\r\n        }\r\n\r\n        // should be something, preparing the extra reader\r\n        var extraReader = readerFor(this.extraFields[0x0001].value);\r\n\r\n        // I really hope that these 64bits integer can fit in 32 bits integer, because js\r\n        // won\'t let us have more.\r\n        if (this.uncompressedSize === utils.MAX_VALUE_32BITS) {\r\n            this.uncompressedSize = extraReader.readInt(8);\r\n        }\r\n        if (this.compressedSize === utils.MAX_VALUE_32BITS) {\r\n            this.compressedSize = extraReader.readInt(8);\r\n        }\r\n        if (this.localHeaderOffset === utils.MAX_VALUE_32BITS) {\r\n            this.localHeaderOffset = extraReader.readInt(8);\r\n        }\r\n        if (this.diskNumberStart === utils.MAX_VALUE_32BITS) {\r\n            this.diskNumberStart = extraReader.readInt(4);\r\n        }\r\n    },\r\n    /**\r\n     * Read the central part of a zip file and add the info in this object.\r\n     * @param {DataReader} reader the reader to use.\r\n     */\r\n    readExtraFields: function(reader) {\r\n        var end = reader.index + this.extraFieldsLength,\r\n            extraFieldId,\r\n            extraFieldLength,\r\n            extraFieldValue;\r\n\r\n        if (!this.extraFields) {\r\n            this.extraFields = {};\r\n        }\r\n\r\n        while (reader.index < end) {\r\n            extraFieldId = reader.readInt(2);\r\n            extraFieldLength = reader.readInt(2);\r\n            extraFieldValue = reader.readData(extraFieldLength);\r\n\r\n            this.extraFields[extraFieldId] = {\r\n                id: extraFieldId,\r\n                length: extraFieldLength,\r\n                value: extraFieldValue\r\n            };\r\n        }\r\n    },\r\n    /**\r\n     * Apply an UTF8 transformation if needed.\r\n     */\r\n    handleUTF8: function() {\r\n        var decodeParamType = support.uint8array ? "uint8array" : "array";\r\n        if (this.useUTF8()) {\r\n            this.fileNameStr = utf8.utf8decode(this.fileName);\r\n            this.fileCommentStr = utf8.utf8decode(this.fileComment);\r\n        } else {\r\n            var upath = this.findExtraFieldUnicodePath();\r\n            if (upath !== null) {\r\n                this.fileNameStr = upath;\r\n            } else {\r\n                // ASCII text or unsupported code page\r\n                var fileNameByteArray =  utils.transformTo(decodeParamType, this.fileName);\r\n                this.fileNameStr = this.loadOptions.decodeFileName(fileNameByteArray);\r\n            }\r\n\r\n            var ucomment = this.findExtraFieldUnicodeComment();\r\n            if (ucomment !== null) {\r\n                this.fileCommentStr = ucomment;\r\n            } else {\r\n                // ASCII text or unsupported code page\r\n                var commentByteArray =  utils.transformTo(decodeParamType, this.fileComment);\r\n                this.fileCommentStr = this.loadOptions.decodeFileName(commentByteArray);\r\n            }\r\n        }\r\n    },\r\n\r\n    /**\r\n     * Find the unicode path declared in the extra field, if any.\r\n     * @return {String} the unicode path, null otherwise.\r\n     */\r\n    findExtraFieldUnicodePath: function() {\r\n        var upathField = this.extraFields[0x7075];\r\n        if (upathField) {\r\n            var extraReader = readerFor(upathField.value);\r\n\r\n            // wrong version\r\n            if (extraReader.readInt(1) !== 1) {\r\n                return null;\r\n            }\r\n\r\n            // the crc of the filename changed, this field is out of date.\r\n            if (crc32fn(this.fileName) !== extraReader.readInt(4)) {\r\n                return null;\r\n            }\r\n\r\n            return utf8.utf8decode(extraReader.readData(upathField.length - 5));\r\n        }\r\n        return null;\r\n    },\r\n\r\n    /**\r\n     * Find the unicode comment declared in the extra field, if any.\r\n     * @return {String} the unicode comment, null otherwise.\r\n     */\r\n    findExtraFieldUnicodeComment: function() {\r\n        var ucommentField = this.extraFields[0x6375];\r\n        if (ucommentField) {\r\n            var extraReader = readerFor(ucommentField.value);\r\n\r\n            // wrong version\r\n            if (extraReader.readInt(1) !== 1) {\r\n                return null;\r\n            }\r\n\r\n            // the crc of the comment changed, this field is out of date.\r\n            if (crc32fn(this.fileComment) !== extraReader.readInt(4)) {\r\n                return null;\r\n            }\r\n\r\n            return utf8.utf8decode(extraReader.readData(ucommentField.length - 5));\r\n        }\r\n        return null;\r\n    }\r\n};\r\nmodule.exports = ZipEntry;\r\n\n\n//# sourceURL=webpack:///./lib/zipEntry.js?')},"./lib/zipObject.js":function(module,exports,__webpack_require__){"use strict";eval('\r\n\r\nvar StreamHelper = __webpack_require__(/*! ./stream/StreamHelper */ "./lib/stream/StreamHelper.js");\r\nvar DataWorker = __webpack_require__(/*! ./stream/DataWorker */ "./lib/stream/DataWorker.js");\r\nvar utf8 = __webpack_require__(/*! ./utf8 */ "./lib/utf8.js");\r\nvar CompressedObject = __webpack_require__(/*! ./compressedObject */ "./lib/compressedObject.js");\r\nvar GenericWorker = __webpack_require__(/*! ./stream/GenericWorker */ "./lib/stream/GenericWorker.js");\r\n\r\n/**\r\n * A simple object representing a file in the zip file.\r\n * @constructor\r\n * @param {string} name the name of the file\r\n * @param {String|ArrayBuffer|Uint8Array|Buffer} data the data\r\n * @param {Object} options the options of the file\r\n */\r\nvar ZipObject = function(name, data, options) {\r\n    this.name = name;\r\n    this.dir = options.dir;\r\n    this.date = options.date;\r\n    this.comment = options.comment;\r\n    this.unixPermissions = options.unixPermissions;\r\n    this.dosPermissions = options.dosPermissions;\r\n\r\n    this._data = data;\r\n    this._dataBinary = options.binary;\r\n    // keep only the compression\r\n    this.options = {\r\n        compression : options.compression,\r\n        compressionOptions : options.compressionOptions\r\n    };\r\n};\r\n\r\nZipObject.prototype = {\r\n    /**\r\n     * Create an internal stream for the content of this object.\r\n     * @param {String} type the type of each chunk.\r\n     * @return StreamHelper the stream.\r\n     */\r\n    internalStream: function (type) {\r\n        var result = null, outputType = "string";\r\n        try {\r\n            if (!type) {\r\n                throw new Error("No output type specified.");\r\n            }\r\n            outputType = type.toLowerCase();\r\n            var askUnicodeString = outputType === "string" || outputType === "text";\r\n            if (outputType === "binarystring" || outputType === "text") {\r\n                outputType = "string";\r\n            }\r\n            result = this._decompressWorker();\r\n\r\n            var isUnicodeString = !this._dataBinary;\r\n\r\n            if (isUnicodeString && !askUnicodeString) {\r\n                result = result.pipe(new utf8.Utf8EncodeWorker());\r\n            }\r\n            if (!isUnicodeString && askUnicodeString) {\r\n                result = result.pipe(new utf8.Utf8DecodeWorker());\r\n            }\r\n        } catch (e) {\r\n            result = new GenericWorker("error");\r\n            result.error(e);\r\n        }\r\n\r\n        return new StreamHelper(result, outputType, "");\r\n    },\r\n\r\n    /**\r\n     * Prepare the content in the asked type.\r\n     * @param {String} type the type of the result.\r\n     * @param {Function} onUpdate a function to call on each internal update.\r\n     * @return Promise the promise of the result.\r\n     */\r\n    async: function (type, onUpdate) {\r\n        return this.internalStream(type).accumulate(onUpdate);\r\n    },\r\n\r\n    /**\r\n     * Prepare the content as a nodejs stream.\r\n     * @param {String} type the type of each chunk.\r\n     * @param {Function} onUpdate a function to call on each internal update.\r\n     * @return Stream the stream.\r\n     */\r\n    nodeStream: function (type, onUpdate) {\r\n        return this.internalStream(type || "nodebuffer").toNodejsStream(onUpdate);\r\n    },\r\n\r\n    /**\r\n     * Return a worker for the compressed content.\r\n     * @private\r\n     * @param {Object} compression the compression object to use.\r\n     * @param {Object} compressionOptions the options to use when compressing.\r\n     * @return Worker the worker.\r\n     */\r\n    _compressWorker: function (compression, compressionOptions) {\r\n        if (\r\n            this._data instanceof CompressedObject &&\r\n            this._data.compression.magic === compression.magic\r\n        ) {\r\n            return this._data.getCompressedWorker();\r\n        } else {\r\n            var result = this._decompressWorker();\r\n            if(!this._dataBinary) {\r\n                result = result.pipe(new utf8.Utf8EncodeWorker());\r\n            }\r\n            return CompressedObject.createWorkerFrom(result, compression, compressionOptions);\r\n        }\r\n    },\r\n    /**\r\n     * Return a worker for the decompressed content.\r\n     * @private\r\n     * @return Worker the worker.\r\n     */\r\n    _decompressWorker : function () {\r\n        if (this._data instanceof CompressedObject) {\r\n            return this._data.getContentWorker();\r\n        } else if (this._data instanceof GenericWorker) {\r\n            return this._data;\r\n        } else {\r\n            return new DataWorker(this._data);\r\n        }\r\n    }\r\n};\r\n\r\nvar removedMethods = ["asText", "asBinary", "asNodeBuffer", "asUint8Array", "asArrayBuffer"];\r\nvar removedFn = function () {\r\n    throw new Error("This method has been removed in JSZip 3.0, please check the upgrade guide.");\r\n};\r\n\r\nfor(var i = 0; i < removedMethods.length; i++) {\r\n    ZipObject.prototype[removedMethods[i]] = removedFn;\r\n}\r\nmodule.exports = ZipObject;\r\n\n\n//# sourceURL=webpack:///./lib/zipObject.js?')},"./node_modules/base64-js/index.js":function(module,exports,__webpack_require__){"use strict";eval("\n\nexports.byteLength = byteLength\nexports.toByteArray = toByteArray\nexports.fromByteArray = fromByteArray\n\nvar lookup = []\nvar revLookup = []\nvar Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array\n\nvar code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'\nfor (var i = 0, len = code.length; i < len; ++i) {\n  lookup[i] = code[i]\n  revLookup[code.charCodeAt(i)] = i\n}\n\nrevLookup['-'.charCodeAt(0)] = 62\nrevLookup['_'.charCodeAt(0)] = 63\n\nfunction placeHoldersCount (b64) {\n  var len = b64.length\n  if (len % 4 > 0) {\n    throw new Error('Invalid string. Length must be a multiple of 4')\n  }\n\n  // the number of equal signs (place holders)\n  // if there are two placeholders, than the two characters before it\n  // represent one byte\n  // if there is only one, then the three characters before it represent 2 bytes\n  // this is just a cheap hack to not do indexOf twice\n  return b64[len - 2] === '=' ? 2 : b64[len - 1] === '=' ? 1 : 0\n}\n\nfunction byteLength (b64) {\n  // base64 is 4/3 + up to two characters of the original data\n  return (b64.length * 3 / 4) - placeHoldersCount(b64)\n}\n\nfunction toByteArray (b64) {\n  var i, l, tmp, placeHolders, arr\n  var len = b64.length\n  placeHolders = placeHoldersCount(b64)\n\n  arr = new Arr((len * 3 / 4) - placeHolders)\n\n  // if there are placeholders, only get up to the last complete 4 chars\n  l = placeHolders > 0 ? len - 4 : len\n\n  var L = 0\n\n  for (i = 0; i < l; i += 4) {\n    tmp = (revLookup[b64.charCodeAt(i)] << 18) | (revLookup[b64.charCodeAt(i + 1)] << 12) | (revLookup[b64.charCodeAt(i + 2)] << 6) | revLookup[b64.charCodeAt(i + 3)]\n    arr[L++] = (tmp >> 16) & 0xFF\n    arr[L++] = (tmp >> 8) & 0xFF\n    arr[L++] = tmp & 0xFF\n  }\n\n  if (placeHolders === 2) {\n    tmp = (revLookup[b64.charCodeAt(i)] << 2) | (revLookup[b64.charCodeAt(i + 1)] >> 4)\n    arr[L++] = tmp & 0xFF\n  } else if (placeHolders === 1) {\n    tmp = (revLookup[b64.charCodeAt(i)] << 10) | (revLookup[b64.charCodeAt(i + 1)] << 4) | (revLookup[b64.charCodeAt(i + 2)] >> 2)\n    arr[L++] = (tmp >> 8) & 0xFF\n    arr[L++] = tmp & 0xFF\n  }\n\n  return arr\n}\n\nfunction tripletToBase64 (num) {\n  return lookup[num >> 18 & 0x3F] + lookup[num >> 12 & 0x3F] + lookup[num >> 6 & 0x3F] + lookup[num & 0x3F]\n}\n\nfunction encodeChunk (uint8, start, end) {\n  var tmp\n  var output = []\n  for (var i = start; i < end; i += 3) {\n    tmp = (uint8[i] << 16) + (uint8[i + 1] << 8) + (uint8[i + 2])\n    output.push(tripletToBase64(tmp))\n  }\n  return output.join('')\n}\n\nfunction fromByteArray (uint8) {\n  var tmp\n  var len = uint8.length\n  var extraBytes = len % 3 // if we have 1 byte left, pad 2 bytes\n  var output = ''\n  var parts = []\n  var maxChunkLength = 16383 // must be multiple of 3\n\n  // go through the array every three bytes, we'll deal with trailing stuff later\n  for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {\n    parts.push(encodeChunk(uint8, i, (i + maxChunkLength) > len2 ? len2 : (i + maxChunkLength)))\n  }\n\n  // pad the end with zeros, but make sure to not forget the extra bytes\n  if (extraBytes === 1) {\n    tmp = uint8[len - 1]\n    output += lookup[tmp >> 2]\n    output += lookup[(tmp << 4) & 0x3F]\n    output += '=='\n  } else if (extraBytes === 2) {\n    tmp = (uint8[len - 2] << 8) + (uint8[len - 1])\n    output += lookup[tmp >> 10]\n    output += lookup[(tmp >> 4) & 0x3F]\n    output += lookup[(tmp << 2) & 0x3F]\n    output += '='\n  }\n\n  parts.push(output)\n\n  return parts.join('')\n}\n\n\n//# sourceURL=webpack:///./node_modules/base64-js/index.js?")},"./node_modules/buffer/index.js":function(module,exports,__webpack_require__){"use strict"
;eval("/* WEBPACK VAR INJECTION */(function(global) {/*!\n * The buffer module from node.js, for the browser.\n *\n * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>\n * @license  MIT\n */\n/* eslint-disable no-proto */\n\n\n\nvar base64 = __webpack_require__(/*! base64-js */ \"./node_modules/base64-js/index.js\")\nvar ieee754 = __webpack_require__(/*! ieee754 */ \"./node_modules/ieee754/index.js\")\nvar isArray = __webpack_require__(/*! isarray */ \"./node_modules/isarray/index.js\")\n\nexports.Buffer = Buffer\nexports.SlowBuffer = SlowBuffer\nexports.INSPECT_MAX_BYTES = 50\n\n/**\n * If `Buffer.TYPED_ARRAY_SUPPORT`:\n *   === true    Use Uint8Array implementation (fastest)\n *   === false   Use Object implementation (most compatible, even IE6)\n *\n * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,\n * Opera 11.6+, iOS 4.2+.\n *\n * Due to various browser bugs, sometimes the Object implementation will be used even\n * when the browser supports typed arrays.\n *\n * Note:\n *\n *   - Firefox 4-29 lacks support for adding new properties to `Uint8Array` instances,\n *     See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438.\n *\n *   - Chrome 9-10 is missing the `TypedArray.prototype.subarray` function.\n *\n *   - IE10 has a broken `TypedArray.prototype.subarray` function which returns arrays of\n *     incorrect length in some situations.\n\n * We detect these buggy browsers and set `Buffer.TYPED_ARRAY_SUPPORT` to `false` so they\n * get the Object implementation, which is slower but behaves correctly.\n */\nBuffer.TYPED_ARRAY_SUPPORT = global.TYPED_ARRAY_SUPPORT !== undefined\n  ? global.TYPED_ARRAY_SUPPORT\n  : typedArraySupport()\n\n/*\n * Export kMaxLength after typed array support is determined.\n */\nexports.kMaxLength = kMaxLength()\n\nfunction typedArraySupport () {\n  try {\n    var arr = new Uint8Array(1)\n    arr.__proto__ = {__proto__: Uint8Array.prototype, foo: function () { return 42 }}\n    return arr.foo() === 42 && // typed array instances can be augmented\n        typeof arr.subarray === 'function' && // chrome 9-10 lack `subarray`\n        arr.subarray(1, 1).byteLength === 0 // ie10 has broken `subarray`\n  } catch (e) {\n    return false\n  }\n}\n\nfunction kMaxLength () {\n  return Buffer.TYPED_ARRAY_SUPPORT\n    ? 0x7fffffff\n    : 0x3fffffff\n}\n\nfunction createBuffer (that, length) {\n  if (kMaxLength() < length) {\n    throw new RangeError('Invalid typed array length')\n  }\n  if (Buffer.TYPED_ARRAY_SUPPORT) {\n    // Return an augmented `Uint8Array` instance, for best performance\n    that = new Uint8Array(length)\n    that.__proto__ = Buffer.prototype\n  } else {\n    // Fallback: Return an object instance of the Buffer class\n    if (that === null) {\n      that = new Buffer(length)\n    }\n    that.length = length\n  }\n\n  return that\n}\n\n/**\n * The Buffer constructor returns instances of `Uint8Array` that have their\n * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of\n * `Uint8Array`, so the returned instances will have all the node `Buffer` methods\n * and the `Uint8Array` methods. Square bracket notation works as expected -- it\n * returns a single octet.\n *\n * The `Uint8Array` prototype remains unmodified.\n */\n\nfunction Buffer (arg, encodingOrOffset, length) {\n  if (!Buffer.TYPED_ARRAY_SUPPORT && !(this instanceof Buffer)) {\n    return new Buffer(arg, encodingOrOffset, length)\n  }\n\n  // Common case.\n  if (typeof arg === 'number') {\n    if (typeof encodingOrOffset === 'string') {\n      throw new Error(\n        'If encoding is specified then the first argument must be a string'\n      )\n    }\n    return allocUnsafe(this, arg)\n  }\n  return from(this, arg, encodingOrOffset, length)\n}\n\nBuffer.poolSize = 8192 // not used by this implementation\n\n// TODO: Legacy, not needed anymore. Remove in next major version.\nBuffer._augment = function (arr) {\n  arr.__proto__ = Buffer.prototype\n  return arr\n}\n\nfunction from (that, value, encodingOrOffset, length) {\n  if (typeof value === 'number') {\n    throw new TypeError('\"value\" argument must not be a number')\n  }\n\n  if (typeof ArrayBuffer !== 'undefined' && value instanceof ArrayBuffer) {\n    return fromArrayBuffer(that, value, encodingOrOffset, length)\n  }\n\n  if (typeof value === 'string') {\n    return fromString(that, value, encodingOrOffset)\n  }\n\n  return fromObject(that, value)\n}\n\n/**\n * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError\n * if value is a number.\n * Buffer.from(str[, encoding])\n * Buffer.from(array)\n * Buffer.from(buffer)\n * Buffer.from(arrayBuffer[, byteOffset[, length]])\n **/\nBuffer.from = function (value, encodingOrOffset, length) {\n  return from(null, value, encodingOrOffset, length)\n}\n\nif (Buffer.TYPED_ARRAY_SUPPORT) {\n  Buffer.prototype.__proto__ = Uint8Array.prototype\n  Buffer.__proto__ = Uint8Array\n  if (typeof Symbol !== 'undefined' && Symbol.species &&\n      Buffer[Symbol.species] === Buffer) {\n    // Fix subarray() in ES2016. See: https://github.com/feross/buffer/pull/97\n    Object.defineProperty(Buffer, Symbol.species, {\n      value: null,\n      configurable: true\n    })\n  }\n}\n\nfunction assertSize (size) {\n  if (typeof size !== 'number') {\n    throw new TypeError('\"size\" argument must be a number')\n  } else if (size < 0) {\n    throw new RangeError('\"size\" argument must not be negative')\n  }\n}\n\nfunction alloc (that, size, fill, encoding) {\n  assertSize(size)\n  if (size <= 0) {\n    return createBuffer(that, size)\n  }\n  if (fill !== undefined) {\n    // Only pay attention to encoding if it's a string. This\n    // prevents accidentally sending in a number that would\n    // be interpretted as a start offset.\n    return typeof encoding === 'string'\n      ? createBuffer(that, size).fill(fill, encoding)\n      : createBuffer(that, size).fill(fill)\n  }\n  return createBuffer(that, size)\n}\n\n/**\n * Creates a new filled Buffer instance.\n * alloc(size[, fill[, encoding]])\n **/\nBuffer.alloc = function (size, fill, encoding) {\n  return alloc(null, size, fill, encoding)\n}\n\nfunction allocUnsafe (that, size) {\n  assertSize(size)\n  that = createBuffer(that, size < 0 ? 0 : checked(size) | 0)\n  if (!Buffer.TYPED_ARRAY_SUPPORT) {\n    for (var i = 0; i < size; ++i) {\n      that[i] = 0\n    }\n  }\n  return that\n}\n\n/**\n * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.\n * */\nBuffer.allocUnsafe = function (size) {\n  return allocUnsafe(null, size)\n}\n/**\n * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.\n */\nBuffer.allocUnsafeSlow = function (size) {\n  return allocUnsafe(null, size)\n}\n\nfunction fromString (that, string, encoding) {\n  if (typeof encoding !== 'string' || encoding === '') {\n    encoding = 'utf8'\n  }\n\n  if (!Buffer.isEncoding(encoding)) {\n    throw new TypeError('\"encoding\" must be a valid string encoding')\n  }\n\n  var length = byteLength(string, encoding) | 0\n  that = createBuffer(that, length)\n\n  var actual = that.write(string, encoding)\n\n  if (actual !== length) {\n    // Writing a hex string, for example, that contains invalid characters will\n    // cause everything after the first invalid character to be ignored. (e.g.\n    // 'abxxcd' will be treated as 'ab')\n    that = that.slice(0, actual)\n  }\n\n  return that\n}\n\nfunction fromArrayLike (that, array) {\n  var length = array.length < 0 ? 0 : checked(array.length) | 0\n  that = createBuffer(that, length)\n  for (var i = 0; i < length; i += 1) {\n    that[i] = array[i] & 255\n  }\n  return that\n}\n\nfunction fromArrayBuffer (that, array, byteOffset, length) {\n  array.byteLength // this throws if `array` is not a valid ArrayBuffer\n\n  if (byteOffset < 0 || array.byteLength < byteOffset) {\n    throw new RangeError('\\'offset\\' is out of bounds')\n  }\n\n  if (array.byteLength < byteOffset + (length || 0)) {\n    throw new RangeError('\\'length\\' is out of bounds')\n  }\n\n  if (byteOffset === undefined && length === undefined) {\n    array = new Uint8Array(array)\n  } else if (length === undefined) {\n    array = new Uint8Array(array, byteOffset)\n  } else {\n    array = new Uint8Array(array, byteOffset, length)\n  }\n\n  if (Buffer.TYPED_ARRAY_SUPPORT) {\n    // Return an augmented `Uint8Array` instance, for best performance\n    that = array\n    that.__proto__ = Buffer.prototype\n  } else {\n    // Fallback: Return an object instance of the Buffer class\n    that = fromArrayLike(that, array)\n  }\n  return that\n}\n\nfunction fromObject (that, obj) {\n  if (Buffer.isBuffer(obj)) {\n    var len = checked(obj.length) | 0\n    that = createBuffer(that, len)\n\n    if (that.length === 0) {\n      return that\n    }\n\n    obj.copy(that, 0, 0, len)\n    return that\n  }\n\n  if (obj) {\n    if ((typeof ArrayBuffer !== 'undefined' &&\n        obj.buffer instanceof ArrayBuffer) || 'length' in obj) {\n      if (typeof obj.length !== 'number' || isnan(obj.length)) {\n        return createBuffer(that, 0)\n      }\n      return fromArrayLike(that, obj)\n    }\n\n    if (obj.type === 'Buffer' && isArray(obj.data)) {\n      return fromArrayLike(that, obj.data)\n    }\n  }\n\n  throw new TypeError('First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.')\n}\n\nfunction checked (length) {\n  // Note: cannot use `length < kMaxLength()` here because that fails when\n  // length is NaN (which is otherwise coerced to zero.)\n  if (length >= kMaxLength()) {\n    throw new RangeError('Attempt to allocate Buffer larger than maximum ' +\n                         'size: 0x' + kMaxLength().toString(16) + ' bytes')\n  }\n  return length | 0\n}\n\nfunction SlowBuffer (length) {\n  if (+length != length) { // eslint-disable-line eqeqeq\n    length = 0\n  }\n  return Buffer.alloc(+length)\n}\n\nBuffer.isBuffer = function isBuffer (b) {\n  return !!(b != null && b._isBuffer)\n}\n\nBuffer.compare = function compare (a, b) {\n  if (!Buffer.isBuffer(a) || !Buffer.isBuffer(b)) {\n    throw new TypeError('Arguments must be Buffers')\n  }\n\n  if (a === b) return 0\n\n  var x = a.length\n  var y = b.length\n\n  for (var i = 0, len = Math.min(x, y); i < len; ++i) {\n    if (a[i] !== b[i]) {\n      x = a[i]\n      y = b[i]\n      break\n    }\n  }\n\n  if (x < y) return -1\n  if (y < x) return 1\n  return 0\n}\n\nBuffer.isEncoding = function isEncoding (encoding) {\n  switch (String(encoding).toLowerCase()) {\n    case 'hex':\n    case 'utf8':\n    case 'utf-8':\n    case 'ascii':\n    case 'latin1':\n    case 'binary':\n    case 'base64':\n    case 'ucs2':\n    case 'ucs-2':\n    case 'utf16le':\n    case 'utf-16le':\n      return true\n    default:\n      return false\n  }\n}\n\nBuffer.concat = function concat (list, length) {\n  if (!isArray(list)) {\n    throw new TypeError('\"list\" argument must be an Array of Buffers')\n  }\n\n  if (list.length === 0) {\n    return Buffer.alloc(0)\n  }\n\n  var i\n  if (length === undefined) {\n    length = 0\n    for (i = 0; i < list.length; ++i) {\n      length += list[i].length\n    }\n  }\n\n  var buffer = Buffer.allocUnsafe(length)\n  var pos = 0\n  for (i = 0; i < list.length; ++i) {\n    var buf = list[i]\n    if (!Buffer.isBuffer(buf)) {\n      throw new TypeError('\"list\" argument must be an Array of Buffers')\n    }\n    buf.copy(buffer, pos)\n    pos += buf.length\n  }\n  return buffer\n}\n\nfunction byteLength (string, encoding) {\n  if (Buffer.isBuffer(string)) {\n    return string.length\n  }\n  if (typeof ArrayBuffer !== 'undefined' && typeof ArrayBuffer.isView === 'function' &&\n      (ArrayBuffer.isView(string) || string instanceof ArrayBuffer)) {\n    return string.byteLength\n  }\n  if (typeof string !== 'string') {\n    string = '' + string\n  }\n\n  var len = string.length\n  if (len === 0) return 0\n\n  // Use a for loop to avoid recursion\n  var loweredCase = false\n  for (;;) {\n    switch (encoding) {\n      case 'ascii':\n      case 'latin1':\n      case 'binary':\n        return len\n      case 'utf8':\n      case 'utf-8':\n      case undefined:\n        return utf8ToBytes(string).length\n      case 'ucs2':\n      case 'ucs-2':\n      case 'utf16le':\n      case 'utf-16le':\n        return len * 2\n      case 'hex':\n        return len >>> 1\n      case 'base64':\n        return base64ToBytes(string).length\n      default:\n        if (loweredCase) return utf8ToBytes(string).length // assume utf8\n        encoding = ('' + encoding).toLowerCase()\n        loweredCase = true\n    }\n  }\n}\nBuffer.byteLength = byteLength\n\nfunction slowToString (encoding, start, end) {\n  var loweredCase = false\n\n  // No need to verify that \"this.length <= MAX_UINT32\" since it's a read-only\n  // property of a typed array.\n\n  // This behaves neither like String nor Uint8Array in that we set start/end\n  // to their upper/lower bounds if the value passed is out of range.\n  // undefined is handled specially as per ECMA-262 6th Edition,\n  // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.\n  if (start === undefined || start < 0) {\n    start = 0\n  }\n  // Return early if start > this.length. Done here to prevent potential uint32\n  // coercion fail below.\n  if (start > this.length) {\n    return ''\n  }\n\n  if (end === undefined || end > this.length) {\n    end = this.length\n  }\n\n  if (end <= 0) {\n    return ''\n  }\n\n  // Force coersion to uint32. This will also coerce falsey/NaN values to 0.\n  end >>>= 0\n  start >>>= 0\n\n  if (end <= start) {\n    return ''\n  }\n\n  if (!encoding) encoding = 'utf8'\n\n  while (true) {\n    switch (encoding) {\n      case 'hex':\n        return hexSlice(this, start, end)\n\n      case 'utf8':\n      case 'utf-8':\n        return utf8Slice(this, start, end)\n\n      case 'ascii':\n        return asciiSlice(this, start, end)\n\n      case 'latin1':\n      case 'binary':\n        return latin1Slice(this, start, end)\n\n      case 'base64':\n        return base64Slice(this, start, end)\n\n      case 'ucs2':\n      case 'ucs-2':\n      case 'utf16le':\n      case 'utf-16le':\n        return utf16leSlice(this, start, end)\n\n      default:\n        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)\n        encoding = (encoding + '').toLowerCase()\n        loweredCase = true\n    }\n  }\n}\n\n// The property is used by `Buffer.isBuffer` and `is-buffer` (in Safari 5-7) to detect\n// Buffer instances.\nBuffer.prototype._isBuffer = true\n\nfunction swap (b, n, m) {\n  var i = b[n]\n  b[n] = b[m]\n  b[m] = i\n}\n\nBuffer.prototype.swap16 = function swap16 () {\n  var len = this.length\n  if (len % 2 !== 0) {\n    throw new RangeError('Buffer size must be a multiple of 16-bits')\n  }\n  for (var i = 0; i < len; i += 2) {\n    swap(this, i, i + 1)\n  }\n  return this\n}\n\nBuffer.prototype.swap32 = function swap32 () {\n  var len = this.length\n  if (len % 4 !== 0) {\n    throw new RangeError('Buffer size must be a multiple of 32-bits')\n  }\n  for (var i = 0; i < len; i += 4) {\n    swap(this, i, i + 3)\n    swap(this, i + 1, i + 2)\n  }\n  return this\n}\n\nBuffer.prototype.swap64 = function swap64 () {\n  var len = this.length\n  if (len % 8 !== 0) {\n    throw new RangeError('Buffer size must be a multiple of 64-bits')\n  }\n  for (var i = 0; i < len; i += 8) {\n    swap(this, i, i + 7)\n    swap(this, i + 1, i + 6)\n    swap(this, i + 2, i + 5)\n    swap(this, i + 3, i + 4)\n  }\n  return this\n}\n\nBuffer.prototype.toString = function toString () {\n  var length = this.length | 0\n  if (length === 0) return ''\n  if (arguments.length === 0) return utf8Slice(this, 0, length)\n  return slowToString.apply(this, arguments)\n}\n\nBuffer.prototype.equals = function equals (b) {\n  if (!Buffer.isBuffer(b)) throw new TypeError('Argument must be a Buffer')\n  if (this === b) return true\n  return Buffer.compare(this, b) === 0\n}\n\nBuffer.prototype.inspect = function inspect () {\n  var str = ''\n  var max = exports.INSPECT_MAX_BYTES\n  if (this.length > 0) {\n    str = this.toString('hex', 0, max).match(/.{2}/g).join(' ')\n    if (this.length > max) str += ' ... '\n  }\n  return '<Buffer ' + str + '>'\n}\n\nBuffer.prototype.compare = function compare (target, start, end, thisStart, thisEnd) {\n  if (!Buffer.isBuffer(target)) {\n    throw new TypeError('Argument must be a Buffer')\n  }\n\n  if (start === undefined) {\n    start = 0\n  }\n  if (end === undefined) {\n    end = target ? target.length : 0\n  }\n  if (thisStart === undefined) {\n    thisStart = 0\n  }\n  if (thisEnd === undefined) {\n    thisEnd = this.length\n  }\n\n  if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {\n    throw new RangeError('out of range index')\n  }\n\n  if (thisStart >= thisEnd && start >= end) {\n    return 0\n  }\n  if (thisStart >= thisEnd) {\n    return -1\n  }\n  if (start >= end) {\n    return 1\n  }\n\n  start >>>= 0\n  end >>>= 0\n  thisStart >>>= 0\n  thisEnd >>>= 0\n\n  if (this === target) return 0\n\n  var x = thisEnd - thisStart\n  var y = end - start\n  var len = Math.min(x, y)\n\n  var thisCopy = this.slice(thisStart, thisEnd)\n  var targetCopy = target.slice(start, end)\n\n  for (var i = 0; i < len; ++i) {\n    if (thisCopy[i] !== targetCopy[i]) {\n      x = thisCopy[i]\n      y = targetCopy[i]\n      break\n    }\n  }\n\n  if (x < y) return -1\n  if (y < x) return 1\n  return 0\n}\n\n// Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,\n// OR the last index of `val` in `buffer` at offset <= `byteOffset`.\n//\n// Arguments:\n// - buffer - a Buffer to search\n// - val - a string, Buffer, or number\n// - byteOffset - an index into `buffer`; will be clamped to an int32\n// - encoding - an optional encoding, relevant is val is a string\n// - dir - true for indexOf, false for lastIndexOf\nfunction bidirectionalIndexOf (buffer, val, byteOffset, encoding, dir) {\n  // Empty buffer means no match\n  if (buffer.length === 0) return -1\n\n  // Normalize byteOffset\n  if (typeof byteOffset === 'string') {\n    encoding = byteOffset\n    byteOffset = 0\n  } else if (byteOffset > 0x7fffffff) {\n    byteOffset = 0x7fffffff\n  } else if (byteOffset < -0x80000000) {\n    byteOffset = -0x80000000\n  }\n  byteOffset = +byteOffset  // Coerce to Number.\n  if (isNaN(byteOffset)) {\n    // byteOffset: it it's undefined, null, NaN, \"foo\", etc, search whole buffer\n    byteOffset = dir ? 0 : (buffer.length - 1)\n  }\n\n  // Normalize byteOffset: negative offsets start from the end of the buffer\n  if (byteOffset < 0) byteOffset = buffer.length + byteOffset\n  if (byteOffset >= buffer.length) {\n    if (dir) return -1\n    else byteOffset = buffer.length - 1\n  } else if (byteOffset < 0) {\n    if (dir) byteOffset = 0\n    else return -1\n  }\n\n  // Normalize val\n  if (typeof val === 'string') {\n    val = Buffer.from(val, encoding)\n  }\n\n  // Finally, search either indexOf (if dir is true) or lastIndexOf\n  if (Buffer.isBuffer(val)) {\n    // Special case: looking for empty string/buffer always fails\n    if (val.length === 0) {\n      return -1\n    }\n    return arrayIndexOf(buffer, val, byteOffset, encoding, dir)\n  } else if (typeof val === 'number') {\n    val = val & 0xFF // Search for a byte value [0-255]\n    if (Buffer.TYPED_ARRAY_SUPPORT &&\n        typeof Uint8Array.prototype.indexOf === 'function') {\n      if (dir) {\n        return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset)\n      } else {\n        return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset)\n      }\n    }\n    return arrayIndexOf(buffer, [ val ], byteOffset, encoding, dir)\n  }\n\n  throw new TypeError('val must be string, number or Buffer')\n}\n\nfunction arrayIndexOf (arr, val, byteOffset, encoding, dir) {\n  var indexSize = 1\n  var arrLength = arr.length\n  var valLength = val.length\n\n  if (encoding !== undefined) {\n    encoding = String(encoding).toLowerCase()\n    if (encoding === 'ucs2' || encoding === 'ucs-2' ||\n        encoding === 'utf16le' || encoding === 'utf-16le') {\n      if (arr.length < 2 || val.length < 2) {\n        return -1\n      }\n      indexSize = 2\n      arrLength /= 2\n      valLength /= 2\n      byteOffset /= 2\n    }\n  }\n\n  function read (buf, i) {\n    if (indexSize === 1) {\n      return buf[i]\n    } else {\n      return buf.readUInt16BE(i * indexSize)\n    }\n  }\n\n  var i\n  if (dir) {\n    var foundIndex = -1\n    for (i = byteOffset; i < arrLength; i++) {\n      if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {\n        if (foundIndex === -1) foundIndex = i\n        if (i - foundIndex + 1 === valLength) return foundIndex * indexSize\n      } else {\n        if (foundIndex !== -1) i -= i - foundIndex\n        foundIndex = -1\n      }\n    }\n  } else {\n    if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength\n    for (i = byteOffset; i >= 0; i--) {\n      var found = true\n      for (var j = 0; j < valLength; j++) {\n        if (read(arr, i + j) !== read(val, j)) {\n          found = false\n          break\n        }\n      }\n      if (found) return i\n    }\n  }\n\n  return -1\n}\n\nBuffer.prototype.includes = function includes (val, byteOffset, encoding) {\n  return this.indexOf(val, byteOffset, encoding) !== -1\n}\n\nBuffer.prototype.indexOf = function indexOf (val, byteOffset, encoding) {\n  return bidirectionalIndexOf(this, val, byteOffset, encoding, true)\n}\n\nBuffer.prototype.lastIndexOf = function lastIndexOf (val, byteOffset, encoding) {\n  return bidirectionalIndexOf(this, val, byteOffset, encoding, false)\n}\n\nfunction hexWrite (buf, string, offset, length) {\n  offset = Number(offset) || 0\n  var remaining = buf.length - offset\n  if (!length) {\n    length = remaining\n  } else {\n    length = Number(length)\n    if (length > remaining) {\n      length = remaining\n    }\n  }\n\n  // must be an even number of digits\n  var strLen = string.length\n  if (strLen % 2 !== 0) throw new TypeError('Invalid hex string')\n\n  if (length > strLen / 2) {\n    length = strLen / 2\n  }\n  for (var i = 0; i < length; ++i) {\n    var parsed = parseInt(string.substr(i * 2, 2), 16)\n    if (isNaN(parsed)) return i\n    buf[offset + i] = parsed\n  }\n  return i\n}\n\nfunction utf8Write (buf, string, offset, length) {\n  return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length)\n}\n\nfunction asciiWrite (buf, string, offset, length) {\n  return blitBuffer(asciiToBytes(string), buf, offset, length)\n}\n\nfunction latin1Write (buf, string, offset, length) {\n  return asciiWrite(buf, string, offset, length)\n}\n\nfunction base64Write (buf, string, offset, length) {\n  return blitBuffer(base64ToBytes(string), buf, offset, length)\n}\n\nfunction ucs2Write (buf, string, offset, length) {\n  return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length)\n}\n\nBuffer.prototype.write = function write (string, offset, length, encoding) {\n  // Buffer#write(string)\n  if (offset === undefined) {\n    encoding = 'utf8'\n    length = this.length\n    offset = 0\n  // Buffer#write(string, encoding)\n  } else if (length === undefined && typeof offset === 'string') {\n    encoding = offset\n    length = this.length\n    offset = 0\n  // Buffer#write(string, offset[, length][, encoding])\n  } else if (isFinite(offset)) {\n    offset = offset | 0\n    if (isFinite(length)) {\n      length = length | 0\n      if (encoding === undefined) encoding = 'utf8'\n    } else {\n      encoding = length\n      length = undefined\n    }\n  // legacy write(string, encoding, offset, length) - remove in v0.13\n  } else {\n    throw new Error(\n      'Buffer.write(string, encoding, offset[, length]) is no longer supported'\n    )\n  }\n\n  var remaining = this.length - offset\n  if (length === undefined || length > remaining) length = remaining\n\n  if ((string.length > 0 && (length < 0 || offset < 0)) || offset > this.length) {\n    throw new RangeError('Attempt to write outside buffer bounds')\n  }\n\n  if (!encoding) encoding = 'utf8'\n\n  var loweredCase = false\n  for (;;) {\n    switch (encoding) {\n      case 'hex':\n        return hexWrite(this, string, offset, length)\n\n      case 'utf8':\n      case 'utf-8':\n        return utf8Write(this, string, offset, length)\n\n      case 'ascii':\n        return asciiWrite(this, string, offset, length)\n\n      case 'latin1':\n      case 'binary':\n        return latin1Write(this, string, offset, length)\n\n      case 'base64':\n        // Warning: maxLength not taken into account in base64Write\n        return base64Write(this, string, offset, length)\n\n      case 'ucs2':\n      case 'ucs-2':\n      case 'utf16le':\n      case 'utf-16le':\n        return ucs2Write(this, string, offset, length)\n\n      default:\n        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)\n        encoding = ('' + encoding).toLowerCase()\n        loweredCase = true\n    }\n  }\n}\n\nBuffer.prototype.toJSON = function toJSON () {\n  return {\n    type: 'Buffer',\n    data: Array.prototype.slice.call(this._arr || this, 0)\n  }\n}\n\nfunction base64Slice (buf, start, end) {\n  if (start === 0 && end === buf.length) {\n    return base64.fromByteArray(buf)\n  } else {\n    return base64.fromByteArray(buf.slice(start, end))\n  }\n}\n\nfunction utf8Slice (buf, start, end) {\n  end = Math.min(buf.length, end)\n  var res = []\n\n  var i = start\n  while (i < end) {\n    var firstByte = buf[i]\n    var codePoint = null\n    var bytesPerSequence = (firstByte > 0xEF) ? 4\n      : (firstByte > 0xDF) ? 3\n      : (firstByte > 0xBF) ? 2\n      : 1\n\n    if (i + bytesPerSequence <= end) {\n      var secondByte, thirdByte, fourthByte, tempCodePoint\n\n      switch (bytesPerSequence) {\n        case 1:\n          if (firstByte < 0x80) {\n            codePoint = firstByte\n          }\n          break\n        case 2:\n          secondByte = buf[i + 1]\n          if ((secondByte & 0xC0) === 0x80) {\n            tempCodePoint = (firstByte & 0x1F) << 0x6 | (secondByte & 0x3F)\n            if (tempCodePoint > 0x7F) {\n              codePoint = tempCodePoint\n            }\n          }\n          break\n        case 3:\n          secondByte = buf[i + 1]\n          thirdByte = buf[i + 2]\n          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {\n            tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | (thirdByte & 0x3F)\n            if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {\n              codePoint = tempCodePoint\n            }\n          }\n          break\n        case 4:\n          secondByte = buf[i + 1]\n          thirdByte = buf[i + 2]\n          fourthByte = buf[i + 3]\n          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {\n            tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | (fourthByte & 0x3F)\n            if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {\n              codePoint = tempCodePoint\n            }\n          }\n      }\n    }\n\n    if (codePoint === null) {\n      // we did not generate a valid codePoint so insert a\n      // replacement char (U+FFFD) and advance only 1 byte\n      codePoint = 0xFFFD\n      bytesPerSequence = 1\n    } else if (codePoint > 0xFFFF) {\n      // encode to utf16 (surrogate pair dance)\n      codePoint -= 0x10000\n      res.push(codePoint >>> 10 & 0x3FF | 0xD800)\n      codePoint = 0xDC00 | codePoint & 0x3FF\n    }\n\n    res.push(codePoint)\n    i += bytesPerSequence\n  }\n\n  return decodeCodePointsArray(res)\n}\n\n// Based on http://stackoverflow.com/a/22747272/680742, the browser with\n// the lowest limit is Chrome, with 0x10000 args.\n// We go 1 magnitude less, for safety\nvar MAX_ARGUMENTS_LENGTH = 0x1000\n\nfunction decodeCodePointsArray (codePoints) {\n  var len = codePoints.length\n  if (len <= MAX_ARGUMENTS_LENGTH) {\n    return String.fromCharCode.apply(String, codePoints) // avoid extra slice()\n  }\n\n  // Decode in chunks to avoid \"call stack size exceeded\".\n  var res = ''\n  var i = 0\n  while (i < len) {\n    res += String.fromCharCode.apply(\n      String,\n      codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH)\n    )\n  }\n  return res\n}\n\nfunction asciiSlice (buf, start, end) {\n  var ret = ''\n  end = Math.min(buf.length, end)\n\n  for (var i = start; i < end; ++i) {\n    ret += String.fromCharCode(buf[i] & 0x7F)\n  }\n  return ret\n}\n\nfunction latin1Slice (buf, start, end) {\n  var ret = ''\n  end = Math.min(buf.length, end)\n\n  for (var i = start; i < end; ++i) {\n    ret += String.fromCharCode(buf[i])\n  }\n  return ret\n}\n\nfunction hexSlice (buf, start, end) {\n  var len = buf.length\n\n  if (!start || start < 0) start = 0\n  if (!end || end < 0 || end > len) end = len\n\n  var out = ''\n  for (var i = start; i < end; ++i) {\n    out += toHex(buf[i])\n  }\n  return out\n}\n\nfunction utf16leSlice (buf, start, end) {\n  var bytes = buf.slice(start, end)\n  var res = ''\n  for (var i = 0; i < bytes.length; i += 2) {\n    res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256)\n  }\n  return res\n}\n\nBuffer.prototype.slice = function slice (start, end) {\n  var len = this.length\n  start = ~~start\n  end = end === undefined ? len : ~~end\n\n  if (start < 0) {\n    start += len\n    if (start < 0) start = 0\n  } else if (start > len) {\n    start = len\n  }\n\n  if (end < 0) {\n    end += len\n    if (end < 0) end = 0\n  } else if (end > len) {\n    end = len\n  }\n\n  if (end < start) end = start\n\n  var newBuf\n  if (Buffer.TYPED_ARRAY_SUPPORT) {\n    newBuf = this.subarray(start, end)\n    newBuf.__proto__ = Buffer.prototype\n  } else {\n    var sliceLen = end - start\n    newBuf = new Buffer(sliceLen, undefined)\n    for (var i = 0; i < sliceLen; ++i) {\n      newBuf[i] = this[i + start]\n    }\n  }\n\n  return newBuf\n}\n\n/*\n * Need to make sure that buffer isn't trying to write out of bounds.\n */\nfunction checkOffset (offset, ext, length) {\n  if ((offset % 1) !== 0 || offset < 0) throw new RangeError('offset is not uint')\n  if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length')\n}\n\nBuffer.prototype.readUIntLE = function readUIntLE (offset, byteLength, noAssert) {\n  offset = offset | 0\n  byteLength = byteLength | 0\n  if (!noAssert) checkOffset(offset, byteLength, this.length)\n\n  var val = this[offset]\n  var mul = 1\n  var i = 0\n  while (++i < byteLength && (mul *= 0x100)) {\n    val += this[offset + i] * mul\n  }\n\n  return val\n}\n\nBuffer.prototype.readUIntBE = function readUIntBE (offset, byteLength, noAssert) {\n  offset = offset | 0\n  byteLength = byteLength | 0\n  if (!noAssert) {\n    checkOffset(offset, byteLength, this.length)\n  }\n\n  var val = this[offset + --byteLength]\n  var mul = 1\n  while (byteLength > 0 && (mul *= 0x100)) {\n    val += this[offset + --byteLength] * mul\n  }\n\n  return val\n}\n\nBuffer.prototype.readUInt8 = function readUInt8 (offset, noAssert) {\n  if (!noAssert) checkOffset(offset, 1, this.length)\n  return this[offset]\n}\n\nBuffer.prototype.readUInt16LE = function readUInt16LE (offset, noAssert) {\n  if (!noAssert) checkOffset(offset, 2, this.length)\n  return this[offset] | (this[offset + 1] << 8)\n}\n\nBuffer.prototype.readUInt16BE = function readUInt16BE (offset, noAssert) {\n  if (!noAssert) checkOffset(offset, 2, this.length)\n  return (this[offset] << 8) | this[offset + 1]\n}\n\nBuffer.prototype.readUInt32LE = function readUInt32LE (offset, noAssert) {\n  if (!noAssert) checkOffset(offset, 4, this.length)\n\n  return ((this[offset]) |\n      (this[offset + 1] << 8) |\n      (this[offset + 2] << 16)) +\n      (this[offset + 3] * 0x1000000)\n}\n\nBuffer.prototype.readUInt32BE = function readUInt32BE (offset, noAssert) {\n  if (!noAssert) checkOffset(offset, 4, this.length)\n\n  return (this[offset] * 0x1000000) +\n    ((this[offset + 1] << 16) |\n    (this[offset + 2] << 8) |\n    this[offset + 3])\n}\n\nBuffer.prototype.readIntLE = function readIntLE (offset, byteLength, noAssert) {\n  offset = offset | 0\n  byteLength = byteLength | 0\n  if (!noAssert) checkOffset(offset, byteLength, this.length)\n\n  var val = this[offset]\n  var mul = 1\n  var i = 0\n  while (++i < byteLength && (mul *= 0x100)) {\n    val += this[offset + i] * mul\n  }\n  mul *= 0x80\n\n  if (val >= mul) val -= Math.pow(2, 8 * byteLength)\n\n  return val\n}\n\nBuffer.prototype.readIntBE = function readIntBE (offset, byteLength, noAssert) {\n  offset = offset | 0\n  byteLength = byteLength | 0\n  if (!noAssert) checkOffset(offset, byteLength, this.length)\n\n  var i = byteLength\n  var mul = 1\n  var val = this[offset + --i]\n  while (i > 0 && (mul *= 0x100)) {\n    val += this[offset + --i] * mul\n  }\n  mul *= 0x80\n\n  if (val >= mul) val -= Math.pow(2, 8 * byteLength)\n\n  return val\n}\n\nBuffer.prototype.readInt8 = function readInt8 (offset, noAssert) {\n  if (!noAssert) checkOffset(offset, 1, this.length)\n  if (!(this[offset] & 0x80)) return (this[offset])\n  return ((0xff - this[offset] + 1) * -1)\n}\n\nBuffer.prototype.readInt16LE = function readInt16LE (offset, noAssert) {\n  if (!noAssert) checkOffset(offset, 2, this.length)\n  var val = this[offset] | (this[offset + 1] << 8)\n  return (val & 0x8000) ? val | 0xFFFF0000 : val\n}\n\nBuffer.prototype.readInt16BE = function readInt16BE (offset, noAssert) {\n  if (!noAssert) checkOffset(offset, 2, this.length)\n  var val = this[offset + 1] | (this[offset] << 8)\n  return (val & 0x8000) ? val | 0xFFFF0000 : val\n}\n\nBuffer.prototype.readInt32LE = function readInt32LE (offset, noAssert) {\n  if (!noAssert) checkOffset(offset, 4, this.length)\n\n  return (this[offset]) |\n    (this[offset + 1] << 8) |\n    (this[offset + 2] << 16) |\n    (this[offset + 3] << 24)\n}\n\nBuffer.prototype.readInt32BE = function readInt32BE (offset, noAssert) {\n  if (!noAssert) checkOffset(offset, 4, this.length)\n\n  return (this[offset] << 24) |\n    (this[offset + 1] << 16) |\n    (this[offset + 2] << 8) |\n    (this[offset + 3])\n}\n\nBuffer.prototype.readFloatLE = function readFloatLE (offset, noAssert) {\n  if (!noAssert) checkOffset(offset, 4, this.length)\n  return ieee754.read(this, offset, true, 23, 4)\n}\n\nBuffer.prototype.readFloatBE = function readFloatBE (offset, noAssert) {\n  if (!noAssert) checkOffset(offset, 4, this.length)\n  return ieee754.read(this, offset, false, 23, 4)\n}\n\nBuffer.prototype.readDoubleLE = function readDoubleLE (offset, noAssert) {\n  if (!noAssert) checkOffset(offset, 8, this.length)\n  return ieee754.read(this, offset, true, 52, 8)\n}\n\nBuffer.prototype.readDoubleBE = function readDoubleBE (offset, noAssert) {\n  if (!noAssert) checkOffset(offset, 8, this.length)\n  return ieee754.read(this, offset, false, 52, 8)\n}\n\nfunction checkInt (buf, value, offset, ext, max, min) {\n  if (!Buffer.isBuffer(buf)) throw new TypeError('\"buffer\" argument must be a Buffer instance')\n  if (value > max || value < min) throw new RangeError('\"value\" argument is out of bounds')\n  if (offset + ext > buf.length) throw new RangeError('Index out of range')\n}\n\nBuffer.prototype.writeUIntLE = function writeUIntLE (value, offset, byteLength, noAssert) {\n  value = +value\n  offset = offset | 0\n  byteLength = byteLength | 0\n  if (!noAssert) {\n    var maxBytes = Math.pow(2, 8 * byteLength) - 1\n    checkInt(this, value, offset, byteLength, maxBytes, 0)\n  }\n\n  var mul = 1\n  var i = 0\n  this[offset] = value & 0xFF\n  while (++i < byteLength && (mul *= 0x100)) {\n    this[offset + i] = (value / mul) & 0xFF\n  }\n\n  return offset + byteLength\n}\n\nBuffer.prototype.writeUIntBE = function writeUIntBE (value, offset, byteLength, noAssert) {\n  value = +value\n  offset = offset | 0\n  byteLength = byteLength | 0\n  if (!noAssert) {\n    var maxBytes = Math.pow(2, 8 * byteLength) - 1\n    checkInt(this, value, offset, byteLength, maxBytes, 0)\n  }\n\n  var i = byteLength - 1\n  var mul = 1\n  this[offset + i] = value & 0xFF\n  while (--i >= 0 && (mul *= 0x100)) {\n    this[offset + i] = (value / mul) & 0xFF\n  }\n\n  return offset + byteLength\n}\n\nBuffer.prototype.writeUInt8 = function writeUInt8 (value, offset, noAssert) {\n  value = +value\n  offset = offset | 0\n  if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0)\n  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value)\n  this[offset] = (value & 0xff)\n  return offset + 1\n}\n\nfunction objectWriteUInt16 (buf, value, offset, littleEndian) {\n  if (value < 0) value = 0xffff + value + 1\n  for (var i = 0, j = Math.min(buf.length - offset, 2); i < j; ++i) {\n    buf[offset + i] = (value & (0xff << (8 * (littleEndian ? i : 1 - i)))) >>>\n      (littleEndian ? i : 1 - i) * 8\n  }\n}\n\nBuffer.prototype.writeUInt16LE = function writeUInt16LE (value, offset, noAssert) {\n  value = +value\n  offset = offset | 0\n  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)\n  if (Buffer.TYPED_ARRAY_SUPPORT) {\n    this[offset] = (value & 0xff)\n    this[offset + 1] = (value >>> 8)\n  } else {\n    objectWriteUInt16(this, value, offset, true)\n  }\n  return offset + 2\n}\n\nBuffer.prototype.writeUInt16BE = function writeUInt16BE (value, offset, noAssert) {\n  value = +value\n  offset = offset | 0\n  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)\n  if (Buffer.TYPED_ARRAY_SUPPORT) {\n    this[offset] = (value >>> 8)\n    this[offset + 1] = (value & 0xff)\n  } else {\n    objectWriteUInt16(this, value, offset, false)\n  }\n  return offset + 2\n}\n\nfunction objectWriteUInt32 (buf, value, offset, littleEndian) {\n  if (value < 0) value = 0xffffffff + value + 1\n  for (var i = 0, j = Math.min(buf.length - offset, 4); i < j; ++i) {\n    buf[offset + i] = (value >>> (littleEndian ? i : 3 - i) * 8) & 0xff\n  }\n}\n\nBuffer.prototype.writeUInt32LE = function writeUInt32LE (value, offset, noAssert) {\n  value = +value\n  offset = offset | 0\n  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)\n  if (Buffer.TYPED_ARRAY_SUPPORT) {\n    this[offset + 3] = (value >>> 24)\n    this[offset + 2] = (value >>> 16)\n    this[offset + 1] = (value >>> 8)\n    this[offset] = (value & 0xff)\n  } else {\n    objectWriteUInt32(this, value, offset, true)\n  }\n  return offset + 4\n}\n\nBuffer.prototype.writeUInt32BE = function writeUInt32BE (value, offset, noAssert) {\n  value = +value\n  offset = offset | 0\n  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)\n  if (Buffer.TYPED_ARRAY_SUPPORT) {\n    this[offset] = (value >>> 24)\n    this[offset + 1] = (value >>> 16)\n    this[offset + 2] = (value >>> 8)\n    this[offset + 3] = (value & 0xff)\n  } else {\n    objectWriteUInt32(this, value, offset, false)\n  }\n  return offset + 4\n}\n\nBuffer.prototype.writeIntLE = function writeIntLE (value, offset, byteLength, noAssert) {\n  value = +value\n  offset = offset | 0\n  if (!noAssert) {\n    var limit = Math.pow(2, 8 * byteLength - 1)\n\n    checkInt(this, value, offset, byteLength, limit - 1, -limit)\n  }\n\n  var i = 0\n  var mul = 1\n  var sub = 0\n  this[offset] = value & 0xFF\n  while (++i < byteLength && (mul *= 0x100)) {\n    if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {\n      sub = 1\n    }\n    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF\n  }\n\n  return offset + byteLength\n}\n\nBuffer.prototype.writeIntBE = function writeIntBE (value, offset, byteLength, noAssert) {\n  value = +value\n  offset = offset | 0\n  if (!noAssert) {\n    var limit = Math.pow(2, 8 * byteLength - 1)\n\n    checkInt(this, value, offset, byteLength, limit - 1, -limit)\n  }\n\n  var i = byteLength - 1\n  var mul = 1\n  var sub = 0\n  this[offset + i] = value & 0xFF\n  while (--i >= 0 && (mul *= 0x100)) {\n    if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {\n      sub = 1\n    }\n    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF\n  }\n\n  return offset + byteLength\n}\n\nBuffer.prototype.writeInt8 = function writeInt8 (value, offset, noAssert) {\n  value = +value\n  offset = offset | 0\n  if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -0x80)\n  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value)\n  if (value < 0) value = 0xff + value + 1\n  this[offset] = (value & 0xff)\n  return offset + 1\n}\n\nBuffer.prototype.writeInt16LE = function writeInt16LE (value, offset, noAssert) {\n  value = +value\n  offset = offset | 0\n  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)\n  if (Buffer.TYPED_ARRAY_SUPPORT) {\n    this[offset] = (value & 0xff)\n    this[offset + 1] = (value >>> 8)\n  } else {\n    objectWriteUInt16(this, value, offset, true)\n  }\n  return offset + 2\n}\n\nBuffer.prototype.writeInt16BE = function writeInt16BE (value, offset, noAssert) {\n  value = +value\n  offset = offset | 0\n  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)\n  if (Buffer.TYPED_ARRAY_SUPPORT) {\n    this[offset] = (value >>> 8)\n    this[offset + 1] = (value & 0xff)\n  } else {\n    objectWriteUInt16(this, value, offset, false)\n  }\n  return offset + 2\n}\n\nBuffer.prototype.writeInt32LE = function writeInt32LE (value, offset, noAssert) {\n  value = +value\n  offset = offset | 0\n  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)\n  if (Buffer.TYPED_ARRAY_SUPPORT) {\n    this[offset] = (value & 0xff)\n    this[offset + 1] = (value >>> 8)\n    this[offset + 2] = (value >>> 16)\n    this[offset + 3] = (value >>> 24)\n  } else {\n    objectWriteUInt32(this, value, offset, true)\n  }\n  return offset + 4\n}\n\nBuffer.prototype.writeInt32BE = function writeInt32BE (value, offset, noAssert) {\n  value = +value\n  offset = offset | 0\n  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)\n  if (value < 0) value = 0xffffffff + value + 1\n  if (Buffer.TYPED_ARRAY_SUPPORT) {\n    this[offset] = (value >>> 24)\n    this[offset + 1] = (value >>> 16)\n    this[offset + 2] = (value >>> 8)\n    this[offset + 3] = (value & 0xff)\n  } else {\n    objectWriteUInt32(this, value, offset, false)\n  }\n  return offset + 4\n}\n\nfunction checkIEEE754 (buf, value, offset, ext, max, min) {\n  if (offset + ext > buf.length) throw new RangeError('Index out of range')\n  if (offset < 0) throw new RangeError('Index out of range')\n}\n\nfunction writeFloat (buf, value, offset, littleEndian, noAssert) {\n  if (!noAssert) {\n    checkIEEE754(buf, value, offset, 4, 3.4028234663852886e+38, -3.4028234663852886e+38)\n  }\n  ieee754.write(buf, value, offset, littleEndian, 23, 4)\n  return offset + 4\n}\n\nBuffer.prototype.writeFloatLE = function writeFloatLE (value, offset, noAssert) {\n  return writeFloat(this, value, offset, true, noAssert)\n}\n\nBuffer.prototype.writeFloatBE = function writeFloatBE (value, offset, noAssert) {\n  return writeFloat(this, value, offset, false, noAssert)\n}\n\nfunction writeDouble (buf, value, offset, littleEndian, noAssert) {\n  if (!noAssert) {\n    checkIEEE754(buf, value, offset, 8, 1.7976931348623157E+308, -1.7976931348623157E+308)\n  }\n  ieee754.write(buf, value, offset, littleEndian, 52, 8)\n  return offset + 8\n}\n\nBuffer.prototype.writeDoubleLE = function writeDoubleLE (value, offset, noAssert) {\n  return writeDouble(this, value, offset, true, noAssert)\n}\n\nBuffer.prototype.writeDoubleBE = function writeDoubleBE (value, offset, noAssert) {\n  return writeDouble(this, value, offset, false, noAssert)\n}\n\n// copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)\nBuffer.prototype.copy = function copy (target, targetStart, start, end) {\n  if (!start) start = 0\n  if (!end && end !== 0) end = this.length\n  if (targetStart >= target.length) targetStart = target.length\n  if (!targetStart) targetStart = 0\n  if (end > 0 && end < start) end = start\n\n  // Copy 0 bytes; we're done\n  if (end === start) return 0\n  if (target.length === 0 || this.length === 0) return 0\n\n  // Fatal error conditions\n  if (targetStart < 0) {\n    throw new RangeError('targetStart out of bounds')\n  }\n  if (start < 0 || start >= this.length) throw new RangeError('sourceStart out of bounds')\n  if (end < 0) throw new RangeError('sourceEnd out of bounds')\n\n  // Are we oob?\n  if (end > this.length) end = this.length\n  if (target.length - targetStart < end - start) {\n    end = target.length - targetStart + start\n  }\n\n  var len = end - start\n  var i\n\n  if (this === target && start < targetStart && targetStart < end) {\n    // descending copy from end\n    for (i = len - 1; i >= 0; --i) {\n      target[i + targetStart] = this[i + start]\n    }\n  } else if (len < 1000 || !Buffer.TYPED_ARRAY_SUPPORT) {\n    // ascending copy from start\n    for (i = 0; i < len; ++i) {\n      target[i + targetStart] = this[i + start]\n    }\n  } else {\n    Uint8Array.prototype.set.call(\n      target,\n      this.subarray(start, start + len),\n      targetStart\n    )\n  }\n\n  return len\n}\n\n// Usage:\n//    buffer.fill(number[, offset[, end]])\n//    buffer.fill(buffer[, offset[, end]])\n//    buffer.fill(string[, offset[, end]][, encoding])\nBuffer.prototype.fill = function fill (val, start, end, encoding) {\n  // Handle string cases:\n  if (typeof val === 'string') {\n    if (typeof start === 'string') {\n      encoding = start\n      start = 0\n      end = this.length\n    } else if (typeof end === 'string') {\n      encoding = end\n      end = this.length\n    }\n    if (val.length === 1) {\n      var code = val.charCodeAt(0)\n      if (code < 256) {\n        val = code\n      }\n    }\n    if (encoding !== undefined && typeof encoding !== 'string') {\n      throw new TypeError('encoding must be a string')\n    }\n    if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {\n      throw new TypeError('Unknown encoding: ' + encoding)\n    }\n  } else if (typeof val === 'number') {\n    val = val & 255\n  }\n\n  // Invalid ranges are not set to a default, so can range check early.\n  if (start < 0 || this.length < start || this.length < end) {\n    throw new RangeError('Out of range index')\n  }\n\n  if (end <= start) {\n    return this\n  }\n\n  start = start >>> 0\n  end = end === undefined ? this.length : end >>> 0\n\n  if (!val) val = 0\n\n  var i\n  if (typeof val === 'number') {\n    for (i = start; i < end; ++i) {\n      this[i] = val\n    }\n  } else {\n    var bytes = Buffer.isBuffer(val)\n      ? val\n      : utf8ToBytes(new Buffer(val, encoding).toString())\n    var len = bytes.length\n    for (i = 0; i < end - start; ++i) {\n      this[i + start] = bytes[i % len]\n    }\n  }\n\n  return this\n}\n\n// HELPER FUNCTIONS\n// ================\n\nvar INVALID_BASE64_RE = /[^+\\/0-9A-Za-z-_]/g\n\nfunction base64clean (str) {\n  // Node strips out invalid characters like \\n and \\t from the string, base64-js does not\n  str = stringtrim(str).replace(INVALID_BASE64_RE, '')\n  // Node converts strings with length < 2 to ''\n  if (str.length < 2) return ''\n  // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not\n  while (str.length % 4 !== 0) {\n    str = str + '='\n  }\n  return str\n}\n\nfunction stringtrim (str) {\n  if (str.trim) return str.trim()\n  return str.replace(/^\\s+|\\s+$/g, '')\n}\n\nfunction toHex (n) {\n  if (n < 16) return '0' + n.toString(16)\n  return n.toString(16)\n}\n\nfunction utf8ToBytes (string, units) {\n  units = units || Infinity\n  var codePoint\n  var length = string.length\n  var leadSurrogate = null\n  var bytes = []\n\n  for (var i = 0; i < length; ++i) {\n    codePoint = string.charCodeAt(i)\n\n    // is surrogate component\n    if (codePoint > 0xD7FF && codePoint < 0xE000) {\n      // last char was a lead\n      if (!leadSurrogate) {\n        // no lead yet\n        if (codePoint > 0xDBFF) {\n          // unexpected trail\n          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)\n          continue\n        } else if (i + 1 === length) {\n          // unpaired lead\n          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)\n          continue\n        }\n\n        // valid lead\n        leadSurrogate = codePoint\n\n        continue\n      }\n\n      // 2 leads in a row\n      if (codePoint < 0xDC00) {\n        if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)\n        leadSurrogate = codePoint\n        continue\n      }\n\n      // valid surrogate pair\n      codePoint = (leadSurrogate - 0xD800 << 10 | codePoint - 0xDC00) + 0x10000\n    } else if (leadSurrogate) {\n      // valid bmp char, but last char was a lead\n      if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)\n    }\n\n    leadSurrogate = null\n\n    // encode utf8\n    if (codePoint < 0x80) {\n      if ((units -= 1) < 0) break\n      bytes.push(codePoint)\n    } else if (codePoint < 0x800) {\n      if ((units -= 2) < 0) break\n      bytes.push(\n        codePoint >> 0x6 | 0xC0,\n        codePoint & 0x3F | 0x80\n      )\n    } else if (codePoint < 0x10000) {\n      if ((units -= 3) < 0) break\n      bytes.push(\n        codePoint >> 0xC | 0xE0,\n        codePoint >> 0x6 & 0x3F | 0x80,\n        codePoint & 0x3F | 0x80\n      )\n    } else if (codePoint < 0x110000) {\n      if ((units -= 4) < 0) break\n      bytes.push(\n        codePoint >> 0x12 | 0xF0,\n        codePoint >> 0xC & 0x3F | 0x80,\n        codePoint >> 0x6 & 0x3F | 0x80,\n        codePoint & 0x3F | 0x80\n      )\n    } else {\n      throw new Error('Invalid code point')\n    }\n  }\n\n  return bytes\n}\n\nfunction asciiToBytes (str) {\n  var byteArray = []\n  for (var i = 0; i < str.length; ++i) {\n    // Node's code seems to be doing this and not & 0x7F..\n    byteArray.push(str.charCodeAt(i) & 0xFF)\n  }\n  return byteArray\n}\n\nfunction utf16leToBytes (str, units) {\n  var c, hi, lo\n  var byteArray = []\n  for (var i = 0; i < str.length; ++i) {\n    if ((units -= 2) < 0) break\n\n    c = str.charCodeAt(i)\n    hi = c >> 8\n    lo = c % 256\n    byteArray.push(lo)\n    byteArray.push(hi)\n  }\n\n  return byteArray\n}\n\nfunction base64ToBytes (str) {\n  return base64.toByteArray(base64clean(str))\n}\n\nfunction blitBuffer (src, dst, offset, length) {\n  for (var i = 0; i < length; ++i) {\n    if ((i + offset >= dst.length) || (i >= src.length)) break\n    dst[i + offset] = src[i]\n  }\n  return i\n}\n\nfunction isnan (val) {\n  return val !== val // eslint-disable-line no-self-compare\n}\n\n/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! ./../webpack/buildin/global.js */ \"./node_modules/webpack/buildin/global.js\")))\n\n//# sourceURL=webpack:///./node_modules/buffer/index.js?")
},"./node_modules/core-util-is/lib/util.js":function(module,exports,__webpack_require__){eval("/* WEBPACK VAR INJECTION */(function(Buffer) {// Copyright Joyent, Inc. and other Node contributors.\n//\n// Permission is hereby granted, free of charge, to any person obtaining a\n// copy of this software and associated documentation files (the\n// \"Software\"), to deal in the Software without restriction, including\n// without limitation the rights to use, copy, modify, merge, publish,\n// distribute, sublicense, and/or sell copies of the Software, and to permit\n// persons to whom the Software is furnished to do so, subject to the\n// following conditions:\n//\n// The above copyright notice and this permission notice shall be included\n// in all copies or substantial portions of the Software.\n//\n// THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS\n// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF\n// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN\n// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,\n// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR\n// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE\n// USE OR OTHER DEALINGS IN THE SOFTWARE.\n\n// NOTE: These type checking functions intentionally don't use `instanceof`\n// because it is fragile and can be easily faked with `Object.create()`.\n\nfunction isArray(arg) {\n  if (Array.isArray) {\n    return Array.isArray(arg);\n  }\n  return objectToString(arg) === '[object Array]';\n}\nexports.isArray = isArray;\n\nfunction isBoolean(arg) {\n  return typeof arg === 'boolean';\n}\nexports.isBoolean = isBoolean;\n\nfunction isNull(arg) {\n  return arg === null;\n}\nexports.isNull = isNull;\n\nfunction isNullOrUndefined(arg) {\n  return arg == null;\n}\nexports.isNullOrUndefined = isNullOrUndefined;\n\nfunction isNumber(arg) {\n  return typeof arg === 'number';\n}\nexports.isNumber = isNumber;\n\nfunction isString(arg) {\n  return typeof arg === 'string';\n}\nexports.isString = isString;\n\nfunction isSymbol(arg) {\n  return typeof arg === 'symbol';\n}\nexports.isSymbol = isSymbol;\n\nfunction isUndefined(arg) {\n  return arg === void 0;\n}\nexports.isUndefined = isUndefined;\n\nfunction isRegExp(re) {\n  return objectToString(re) === '[object RegExp]';\n}\nexports.isRegExp = isRegExp;\n\nfunction isObject(arg) {\n  return typeof arg === 'object' && arg !== null;\n}\nexports.isObject = isObject;\n\nfunction isDate(d) {\n  return objectToString(d) === '[object Date]';\n}\nexports.isDate = isDate;\n\nfunction isError(e) {\n  return (objectToString(e) === '[object Error]' || e instanceof Error);\n}\nexports.isError = isError;\n\nfunction isFunction(arg) {\n  return typeof arg === 'function';\n}\nexports.isFunction = isFunction;\n\nfunction isPrimitive(arg) {\n  return arg === null ||\n         typeof arg === 'boolean' ||\n         typeof arg === 'number' ||\n         typeof arg === 'string' ||\n         typeof arg === 'symbol' ||  // ES6 symbol\n         typeof arg === 'undefined';\n}\nexports.isPrimitive = isPrimitive;\n\nexports.isBuffer = Buffer.isBuffer;\n\nfunction objectToString(o) {\n  return Object.prototype.toString.call(o);\n}\n\n/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! ./../../buffer/index.js */ \"./node_modules/buffer/index.js\").Buffer))\n\n//# sourceURL=webpack:///./node_modules/core-util-is/lib/util.js?")},"./node_modules/ieee754/index.js":function(module,exports){eval("exports.read = function (buffer, offset, isLE, mLen, nBytes) {\n  var e, m\n  var eLen = nBytes * 8 - mLen - 1\n  var eMax = (1 << eLen) - 1\n  var eBias = eMax >> 1\n  var nBits = -7\n  var i = isLE ? (nBytes - 1) : 0\n  var d = isLE ? -1 : 1\n  var s = buffer[offset + i]\n\n  i += d\n\n  e = s & ((1 << (-nBits)) - 1)\n  s >>= (-nBits)\n  nBits += eLen\n  for (; nBits > 0; e = e * 256 + buffer[offset + i], i += d, nBits -= 8) {}\n\n  m = e & ((1 << (-nBits)) - 1)\n  e >>= (-nBits)\n  nBits += mLen\n  for (; nBits > 0; m = m * 256 + buffer[offset + i], i += d, nBits -= 8) {}\n\n  if (e === 0) {\n    e = 1 - eBias\n  } else if (e === eMax) {\n    return m ? NaN : ((s ? -1 : 1) * Infinity)\n  } else {\n    m = m + Math.pow(2, mLen)\n    e = e - eBias\n  }\n  return (s ? -1 : 1) * m * Math.pow(2, e - mLen)\n}\n\nexports.write = function (buffer, value, offset, isLE, mLen, nBytes) {\n  var e, m, c\n  var eLen = nBytes * 8 - mLen - 1\n  var eMax = (1 << eLen) - 1\n  var eBias = eMax >> 1\n  var rt = (mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0)\n  var i = isLE ? 0 : (nBytes - 1)\n  var d = isLE ? 1 : -1\n  var s = value < 0 || (value === 0 && 1 / value < 0) ? 1 : 0\n\n  value = Math.abs(value)\n\n  if (isNaN(value) || value === Infinity) {\n    m = isNaN(value) ? 1 : 0\n    e = eMax\n  } else {\n    e = Math.floor(Math.log(value) / Math.LN2)\n    if (value * (c = Math.pow(2, -e)) < 1) {\n      e--\n      c *= 2\n    }\n    if (e + eBias >= 1) {\n      value += rt / c\n    } else {\n      value += rt * Math.pow(2, 1 - eBias)\n    }\n    if (value * c >= 2) {\n      e++\n      c /= 2\n    }\n\n    if (e + eBias >= eMax) {\n      m = 0\n      e = eMax\n    } else if (e + eBias >= 1) {\n      m = (value * c - 1) * Math.pow(2, mLen)\n      e = e + eBias\n    } else {\n      m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen)\n      e = 0\n    }\n  }\n\n  for (; mLen >= 8; buffer[offset + i] = m & 0xff, i += d, m /= 256, mLen -= 8) {}\n\n  e = (e << mLen) | m\n  eLen += mLen\n  for (; eLen > 0; buffer[offset + i] = e & 0xff, i += d, e /= 256, eLen -= 8) {}\n\n  buffer[offset + i - d] |= s * 128\n}\n\n\n//# sourceURL=webpack:///./node_modules/ieee754/index.js?")},"./node_modules/immediate/lib/browser.js":function(module,exports,__webpack_require__){"use strict";eval("/* WEBPACK VAR INJECTION */(function(global) {\nvar Mutation = global.MutationObserver || global.WebKitMutationObserver;\n\nvar scheduleDrain;\n\n{\n  if (Mutation) {\n    var called = 0;\n    var observer = new Mutation(nextTick);\n    var element = global.document.createTextNode('');\n    observer.observe(element, {\n      characterData: true\n    });\n    scheduleDrain = function () {\n      element.data = (called = ++called % 2);\n    };\n  } else if (!global.setImmediate && typeof global.MessageChannel !== 'undefined') {\n    var channel = new global.MessageChannel();\n    channel.port1.onmessage = nextTick;\n    scheduleDrain = function () {\n      channel.port2.postMessage(0);\n    };\n  } else if ('document' in global && 'onreadystatechange' in global.document.createElement('script')) {\n    scheduleDrain = function () {\n\n      // Create a <script> element; its readystatechange event will be fired asynchronously once it is inserted\n      // into the document. Do so, thus queuing up the task. Remember to clean up once it's been called.\n      var scriptEl = global.document.createElement('script');\n      scriptEl.onreadystatechange = function () {\n        nextTick();\n\n        scriptEl.onreadystatechange = null;\n        scriptEl.parentNode.removeChild(scriptEl);\n        scriptEl = null;\n      };\n      global.document.documentElement.appendChild(scriptEl);\n    };\n  } else {\n    scheduleDrain = function () {\n      setTimeout(nextTick, 0);\n    };\n  }\n}\n\nvar draining;\nvar queue = [];\n//named nextTick for less confusing stack traces\nfunction nextTick() {\n  draining = true;\n  var i, oldQueue;\n  var len = queue.length;\n  while (len) {\n    oldQueue = queue;\n    queue = [];\n    i = -1;\n    while (++i < len) {\n      oldQueue[i]();\n    }\n    len = queue.length;\n  }\n  draining = false;\n}\n\nmodule.exports = immediate;\nfunction immediate(task) {\n  if (queue.push(task) === 1 && !draining) {\n    scheduleDrain();\n  }\n}\n\n/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! ./../../webpack/buildin/global.js */ \"./node_modules/webpack/buildin/global.js\")))\n\n//# sourceURL=webpack:///./node_modules/immediate/lib/browser.js?")},"./node_modules/inherits/inherits_browser.js":function(module,exports){eval("if (typeof Object.create === 'function') {\n  // implementation from standard node.js 'util' module\n  module.exports = function inherits(ctor, superCtor) {\n    ctor.super_ = superCtor\n    ctor.prototype = Object.create(superCtor.prototype, {\n      constructor: {\n        value: ctor,\n        enumerable: false,\n        writable: true,\n        configurable: true\n      }\n    });\n  };\n} else {\n  // old school shim for old browsers\n  module.exports = function inherits(ctor, superCtor) {\n    ctor.super_ = superCtor\n    var TempCtor = function () {}\n    TempCtor.prototype = superCtor.prototype\n    ctor.prototype = new TempCtor()\n    ctor.prototype.constructor = ctor\n  }\n}\n\n\n//# sourceURL=webpack:///./node_modules/inherits/inherits_browser.js?")},"./node_modules/isarray/index.js":function(module,exports){eval("var toString = {}.toString;\n\nmodule.exports = Array.isArray || function (arr) {\n  return toString.call(arr) == '[object Array]';\n};\n\n\n//# sourceURL=webpack:///./node_modules/isarray/index.js?")},"./node_modules/lie/lib/browser.js":function(module,exports,__webpack_require__){"use strict";eval("\nvar immediate = __webpack_require__(/*! immediate */ \"./node_modules/immediate/lib/browser.js\");\n\n/* istanbul ignore next */\nfunction INTERNAL() {}\n\nvar handlers = {};\n\nvar REJECTED = ['REJECTED'];\nvar FULFILLED = ['FULFILLED'];\nvar PENDING = ['PENDING'];\n\nmodule.exports = Promise;\n\nfunction Promise(resolver) {\n  if (typeof resolver !== 'function') {\n    throw new TypeError('resolver must be a function');\n  }\n  this.state = PENDING;\n  this.queue = [];\n  this.outcome = void 0;\n  if (resolver !== INTERNAL) {\n    safelyResolveThenable(this, resolver);\n  }\n}\n\nPromise.prototype[\"finally\"] = function (callback) {\n  if (typeof callback !== 'function') {\n    return this;\n  }\n  var p = this.constructor;\n  return this.then(resolve, reject);\n\n  function resolve(value) {\n    function yes () {\n      return value;\n    }\n    return p.resolve(callback()).then(yes);\n  }\n  function reject(reason) {\n    function no () {\n      throw reason;\n    }\n    return p.resolve(callback()).then(no);\n  }\n};\nPromise.prototype[\"catch\"] = function (onRejected) {\n  return this.then(null, onRejected);\n};\nPromise.prototype.then = function (onFulfilled, onRejected) {\n  if (typeof onFulfilled !== 'function' && this.state === FULFILLED ||\n    typeof onRejected !== 'function' && this.state === REJECTED) {\n    return this;\n  }\n  var promise = new this.constructor(INTERNAL);\n  if (this.state !== PENDING) {\n    var resolver = this.state === FULFILLED ? onFulfilled : onRejected;\n    unwrap(promise, resolver, this.outcome);\n  } else {\n    this.queue.push(new QueueItem(promise, onFulfilled, onRejected));\n  }\n\n  return promise;\n};\nfunction QueueItem(promise, onFulfilled, onRejected) {\n  this.promise = promise;\n  if (typeof onFulfilled === 'function') {\n    this.onFulfilled = onFulfilled;\n    this.callFulfilled = this.otherCallFulfilled;\n  }\n  if (typeof onRejected === 'function') {\n    this.onRejected = onRejected;\n    this.callRejected = this.otherCallRejected;\n  }\n}\nQueueItem.prototype.callFulfilled = function (value) {\n  handlers.resolve(this.promise, value);\n};\nQueueItem.prototype.otherCallFulfilled = function (value) {\n  unwrap(this.promise, this.onFulfilled, value);\n};\nQueueItem.prototype.callRejected = function (value) {\n  handlers.reject(this.promise, value);\n};\nQueueItem.prototype.otherCallRejected = function (value) {\n  unwrap(this.promise, this.onRejected, value);\n};\n\nfunction unwrap(promise, func, value) {\n  immediate(function () {\n    var returnValue;\n    try {\n      returnValue = func(value);\n    } catch (e) {\n      return handlers.reject(promise, e);\n    }\n    if (returnValue === promise) {\n      handlers.reject(promise, new TypeError('Cannot resolve promise with itself'));\n    } else {\n      handlers.resolve(promise, returnValue);\n    }\n  });\n}\n\nhandlers.resolve = function (self, value) {\n  var result = tryCatch(getThen, value);\n  if (result.status === 'error') {\n    return handlers.reject(self, result.value);\n  }\n  var thenable = result.value;\n\n  if (thenable) {\n    safelyResolveThenable(self, thenable);\n  } else {\n    self.state = FULFILLED;\n    self.outcome = value;\n    var i = -1;\n    var len = self.queue.length;\n    while (++i < len) {\n      self.queue[i].callFulfilled(value);\n    }\n  }\n  return self;\n};\nhandlers.reject = function (self, error) {\n  self.state = REJECTED;\n  self.outcome = error;\n  var i = -1;\n  var len = self.queue.length;\n  while (++i < len) {\n    self.queue[i].callRejected(error);\n  }\n  return self;\n};\n\nfunction getThen(obj) {\n  // Make sure we only access the accessor once as required by the spec\n  var then = obj && obj.then;\n  if (obj && (typeof obj === 'object' || typeof obj === 'function') && typeof then === 'function') {\n    return function appyThen() {\n      then.apply(obj, arguments);\n    };\n  }\n}\n\nfunction safelyResolveThenable(self, thenable) {\n  // Either fulfill, reject or reject with error\n  var called = false;\n  function onError(value) {\n    if (called) {\n      return;\n    }\n    called = true;\n    handlers.reject(self, value);\n  }\n\n  function onSuccess(value) {\n    if (called) {\n      return;\n    }\n    called = true;\n    handlers.resolve(self, value);\n  }\n\n  function tryToUnwrap() {\n    thenable(onSuccess, onError);\n  }\n\n  var result = tryCatch(tryToUnwrap);\n  if (result.status === 'error') {\n    onError(result.value);\n  }\n}\n\nfunction tryCatch(func, value) {\n  var out = {};\n  try {\n    out.value = func(value);\n    out.status = 'success';\n  } catch (e) {\n    out.status = 'error';\n    out.value = e;\n  }\n  return out;\n}\n\nPromise.resolve = resolve;\nfunction resolve(value) {\n  if (value instanceof this) {\n    return value;\n  }\n  return handlers.resolve(new this(INTERNAL), value);\n}\n\nPromise.reject = reject;\nfunction reject(reason) {\n  var promise = new this(INTERNAL);\n  return handlers.reject(promise, reason);\n}\n\nPromise.all = all;\nfunction all(iterable) {\n  var self = this;\n  if (Object.prototype.toString.call(iterable) !== '[object Array]') {\n    return this.reject(new TypeError('must be an array'));\n  }\n\n  var len = iterable.length;\n  var called = false;\n  if (!len) {\n    return this.resolve([]);\n  }\n\n  var values = new Array(len);\n  var resolved = 0;\n  var i = -1;\n  var promise = new this(INTERNAL);\n\n  while (++i < len) {\n    allResolver(iterable[i], i);\n  }\n  return promise;\n  function allResolver(value, i) {\n    self.resolve(value).then(resolveFromAll, function (error) {\n      if (!called) {\n        called = true;\n        handlers.reject(promise, error);\n      }\n    });\n    function resolveFromAll(outValue) {\n      values[i] = outValue;\n      if (++resolved === len && !called) {\n        called = true;\n        handlers.resolve(promise, values);\n      }\n    }\n  }\n}\n\nPromise.race = race;\nfunction race(iterable) {\n  var self = this;\n  if (Object.prototype.toString.call(iterable) !== '[object Array]') {\n    return this.reject(new TypeError('must be an array'));\n  }\n\n  var len = iterable.length;\n  var called = false;\n  if (!len) {\n    return this.resolve([]);\n  }\n\n  var i = -1;\n  var promise = new this(INTERNAL);\n\n  while (++i < len) {\n    resolver(iterable[i]);\n  }\n  return promise;\n  function resolver(value) {\n    self.resolve(value).then(function (response) {\n      if (!called) {\n        called = true;\n        handlers.resolve(promise, response);\n      }\n    }, function (error) {\n      if (!called) {\n        called = true;\n        handlers.reject(promise, error);\n      }\n    });\n  }\n}\n\n\n//# sourceURL=webpack:///./node_modules/lie/lib/browser.js?")},"./node_modules/node-libs-browser/node_modules/events/events.js":function(module,exports,__webpack_require__){"use strict";eval("// Copyright Joyent, Inc. and other Node contributors.\n//\n// Permission is hereby granted, free of charge, to any person obtaining a\n// copy of this software and associated documentation files (the\n// \"Software\"), to deal in the Software without restriction, including\n// without limitation the rights to use, copy, modify, merge, publish,\n// distribute, sublicense, and/or sell copies of the Software, and to permit\n// persons to whom the Software is furnished to do so, subject to the\n// following conditions:\n//\n// The above copyright notice and this permission notice shall be included\n// in all copies or substantial portions of the Software.\n//\n// THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS\n// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF\n// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN\n// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,\n// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR\n// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE\n// USE OR OTHER DEALINGS IN THE SOFTWARE.\n\n\n\nvar R = typeof Reflect === 'object' ? Reflect : null\nvar ReflectApply = R && typeof R.apply === 'function'\n  ? R.apply\n  : function ReflectApply(target, receiver, args) {\n    return Function.prototype.apply.call(target, receiver, args);\n  }\n\nvar ReflectOwnKeys\nif (R && typeof R.ownKeys === 'function') {\n  ReflectOwnKeys = R.ownKeys\n} else if (Object.getOwnPropertySymbols) {\n  ReflectOwnKeys = function ReflectOwnKeys(target) {\n    return Object.getOwnPropertyNames(target)\n      .concat(Object.getOwnPropertySymbols(target));\n  };\n} else {\n  ReflectOwnKeys = function ReflectOwnKeys(target) {\n    return Object.getOwnPropertyNames(target);\n  };\n}\n\nfunction ProcessEmitWarning(warning) {\n  if (console && console.warn) console.warn(warning);\n}\n\nvar NumberIsNaN = Number.isNaN || function NumberIsNaN(value) {\n  return value !== value;\n}\n\nfunction EventEmitter() {\n  EventEmitter.init.call(this);\n}\nmodule.exports = EventEmitter;\n\n// Backwards-compat with node 0.10.x\nEventEmitter.EventEmitter = EventEmitter;\n\nEventEmitter.prototype._events = undefined;\nEventEmitter.prototype._eventsCount = 0;\nEventEmitter.prototype._maxListeners = undefined;\n\n// By default EventEmitters will print a warning if more than 10 listeners are\n// added to it. This is a useful default which helps finding memory leaks.\nvar defaultMaxListeners = 10;\n\nfunction checkListener(listener) {\n  if (typeof listener !== 'function') {\n    throw new TypeError('The \"listener\" argument must be of type Function. Received type ' + typeof listener);\n  }\n}\n\nObject.defineProperty(EventEmitter, 'defaultMaxListeners', {\n  enumerable: true,\n  get: function() {\n    return defaultMaxListeners;\n  },\n  set: function(arg) {\n    if (typeof arg !== 'number' || arg < 0 || NumberIsNaN(arg)) {\n      throw new RangeError('The value of \"defaultMaxListeners\" is out of range. It must be a non-negative number. Received ' + arg + '.');\n    }\n    defaultMaxListeners = arg;\n  }\n});\n\nEventEmitter.init = function() {\n\n  if (this._events === undefined ||\n      this._events === Object.getPrototypeOf(this)._events) {\n    this._events = Object.create(null);\n    this._eventsCount = 0;\n  }\n\n  this._maxListeners = this._maxListeners || undefined;\n};\n\n// Obviously not all Emitters should be limited to 10. This function allows\n// that to be increased. Set to zero for unlimited.\nEventEmitter.prototype.setMaxListeners = function setMaxListeners(n) {\n  if (typeof n !== 'number' || n < 0 || NumberIsNaN(n)) {\n    throw new RangeError('The value of \"n\" is out of range. It must be a non-negative number. Received ' + n + '.');\n  }\n  this._maxListeners = n;\n  return this;\n};\n\nfunction _getMaxListeners(that) {\n  if (that._maxListeners === undefined)\n    return EventEmitter.defaultMaxListeners;\n  return that._maxListeners;\n}\n\nEventEmitter.prototype.getMaxListeners = function getMaxListeners() {\n  return _getMaxListeners(this);\n};\n\nEventEmitter.prototype.emit = function emit(type) {\n  var args = [];\n  for (var i = 1; i < arguments.length; i++) args.push(arguments[i]);\n  var doError = (type === 'error');\n\n  var events = this._events;\n  if (events !== undefined)\n    doError = (doError && events.error === undefined);\n  else if (!doError)\n    return false;\n\n  // If there is no 'error' event listener then throw.\n  if (doError) {\n    var er;\n    if (args.length > 0)\n      er = args[0];\n    if (er instanceof Error) {\n      // Note: The comments on the `throw` lines are intentional, they show\n      // up in Node's output if this results in an unhandled exception.\n      throw er; // Unhandled 'error' event\n    }\n    // At least give some kind of context to the user\n    var err = new Error('Unhandled error.' + (er ? ' (' + er.message + ')' : ''));\n    err.context = er;\n    throw err; // Unhandled 'error' event\n  }\n\n  var handler = events[type];\n\n  if (handler === undefined)\n    return false;\n\n  if (typeof handler === 'function') {\n    ReflectApply(handler, this, args);\n  } else {\n    var len = handler.length;\n    var listeners = arrayClone(handler, len);\n    for (var i = 0; i < len; ++i)\n      ReflectApply(listeners[i], this, args);\n  }\n\n  return true;\n};\n\nfunction _addListener(target, type, listener, prepend) {\n  var m;\n  var events;\n  var existing;\n\n  checkListener(listener);\n\n  events = target._events;\n  if (events === undefined) {\n    events = target._events = Object.create(null);\n    target._eventsCount = 0;\n  } else {\n    // To avoid recursion in the case that type === \"newListener\"! Before\n    // adding it to the listeners, first emit \"newListener\".\n    if (events.newListener !== undefined) {\n      target.emit('newListener', type,\n                  listener.listener ? listener.listener : listener);\n\n      // Re-assign `events` because a newListener handler could have caused the\n      // this._events to be assigned to a new object\n      events = target._events;\n    }\n    existing = events[type];\n  }\n\n  if (existing === undefined) {\n    // Optimize the case of one listener. Don't need the extra array object.\n    existing = events[type] = listener;\n    ++target._eventsCount;\n  } else {\n    if (typeof existing === 'function') {\n      // Adding the second element, need to change to array.\n      existing = events[type] =\n        prepend ? [listener, existing] : [existing, listener];\n      // If we've already got an array, just append.\n    } else if (prepend) {\n      existing.unshift(listener);\n    } else {\n      existing.push(listener);\n    }\n\n    // Check for listener leak\n    m = _getMaxListeners(target);\n    if (m > 0 && existing.length > m && !existing.warned) {\n      existing.warned = true;\n      // No error code for this since it is a Warning\n      // eslint-disable-next-line no-restricted-syntax\n      var w = new Error('Possible EventEmitter memory leak detected. ' +\n                          existing.length + ' ' + String(type) + ' listeners ' +\n                          'added. Use emitter.setMaxListeners() to ' +\n                          'increase limit');\n      w.name = 'MaxListenersExceededWarning';\n      w.emitter = target;\n      w.type = type;\n      w.count = existing.length;\n      ProcessEmitWarning(w);\n    }\n  }\n\n  return target;\n}\n\nEventEmitter.prototype.addListener = function addListener(type, listener) {\n  return _addListener(this, type, listener, false);\n};\n\nEventEmitter.prototype.on = EventEmitter.prototype.addListener;\n\nEventEmitter.prototype.prependListener =\n    function prependListener(type, listener) {\n      return _addListener(this, type, listener, true);\n    };\n\nfunction onceWrapper() {\n  if (!this.fired) {\n    this.target.removeListener(this.type, this.wrapFn);\n    this.fired = true;\n    if (arguments.length === 0)\n      return this.listener.call(this.target);\n    return this.listener.apply(this.target, arguments);\n  }\n}\n\nfunction _onceWrap(target, type, listener) {\n  var state = { fired: false, wrapFn: undefined, target: target, type: type, listener: listener };\n  var wrapped = onceWrapper.bind(state);\n  wrapped.listener = listener;\n  state.wrapFn = wrapped;\n  return wrapped;\n}\n\nEventEmitter.prototype.once = function once(type, listener) {\n  checkListener(listener);\n  this.on(type, _onceWrap(this, type, listener));\n  return this;\n};\n\nEventEmitter.prototype.prependOnceListener =\n    function prependOnceListener(type, listener) {\n      checkListener(listener);\n      this.prependListener(type, _onceWrap(this, type, listener));\n      return this;\n    };\n\n// Emits a 'removeListener' event if and only if the listener was removed.\nEventEmitter.prototype.removeListener =\n    function removeListener(type, listener) {\n      var list, events, position, i, originalListener;\n\n      checkListener(listener);\n\n      events = this._events;\n      if (events === undefined)\n        return this;\n\n      list = events[type];\n      if (list === undefined)\n        return this;\n\n      if (list === listener || list.listener === listener) {\n        if (--this._eventsCount === 0)\n          this._events = Object.create(null);\n        else {\n          delete events[type];\n          if (events.removeListener)\n            this.emit('removeListener', type, list.listener || listener);\n        }\n      } else if (typeof list !== 'function') {\n        position = -1;\n\n        for (i = list.length - 1; i >= 0; i--) {\n          if (list[i] === listener || list[i].listener === listener) {\n            originalListener = list[i].listener;\n            position = i;\n            break;\n          }\n        }\n\n        if (position < 0)\n          return this;\n\n        if (position === 0)\n          list.shift();\n        else {\n          spliceOne(list, position);\n        }\n\n        if (list.length === 1)\n          events[type] = list[0];\n\n        if (events.removeListener !== undefined)\n          this.emit('removeListener', type, originalListener || listener);\n      }\n\n      return this;\n    };\n\nEventEmitter.prototype.off = EventEmitter.prototype.removeListener;\n\nEventEmitter.prototype.removeAllListeners =\n    function removeAllListeners(type) {\n      var listeners, events, i;\n\n      events = this._events;\n      if (events === undefined)\n        return this;\n\n      // not listening for removeListener, no need to emit\n      if (events.removeListener === undefined) {\n        if (arguments.length === 0) {\n          this._events = Object.create(null);\n          this._eventsCount = 0;\n        } else if (events[type] !== undefined) {\n          if (--this._eventsCount === 0)\n            this._events = Object.create(null);\n          else\n            delete events[type];\n        }\n        return this;\n      }\n\n      // emit removeListener for all listeners on all events\n      if (arguments.length === 0) {\n        var keys = Object.keys(events);\n        var key;\n        for (i = 0; i < keys.length; ++i) {\n          key = keys[i];\n          if (key === 'removeListener') continue;\n          this.removeAllListeners(key);\n        }\n        this.removeAllListeners('removeListener');\n        this._events = Object.create(null);\n        this._eventsCount = 0;\n        return this;\n      }\n\n      listeners = events[type];\n\n      if (typeof listeners === 'function') {\n        this.removeListener(type, listeners);\n      } else if (listeners !== undefined) {\n        // LIFO order\n        for (i = listeners.length - 1; i >= 0; i--) {\n          this.removeListener(type, listeners[i]);\n        }\n      }\n\n      return this;\n    };\n\nfunction _listeners(target, type, unwrap) {\n  var events = target._events;\n\n  if (events === undefined)\n    return [];\n\n  var evlistener = events[type];\n  if (evlistener === undefined)\n    return [];\n\n  if (typeof evlistener === 'function')\n    return unwrap ? [evlistener.listener || evlistener] : [evlistener];\n\n  return unwrap ?\n    unwrapListeners(evlistener) : arrayClone(evlistener, evlistener.length);\n}\n\nEventEmitter.prototype.listeners = function listeners(type) {\n  return _listeners(this, type, true);\n};\n\nEventEmitter.prototype.rawListeners = function rawListeners(type) {\n  return _listeners(this, type, false);\n};\n\nEventEmitter.listenerCount = function(emitter, type) {\n  if (typeof emitter.listenerCount === 'function') {\n    return emitter.listenerCount(type);\n  } else {\n    return listenerCount.call(emitter, type);\n  }\n};\n\nEventEmitter.prototype.listenerCount = listenerCount;\nfunction listenerCount(type) {\n  var events = this._events;\n\n  if (events !== undefined) {\n    var evlistener = events[type];\n\n    if (typeof evlistener === 'function') {\n      return 1;\n    } else if (evlistener !== undefined) {\n      return evlistener.length;\n    }\n  }\n\n  return 0;\n}\n\nEventEmitter.prototype.eventNames = function eventNames() {\n  return this._eventsCount > 0 ? ReflectOwnKeys(this._events) : [];\n};\n\nfunction arrayClone(arr, n) {\n  var copy = new Array(n);\n  for (var i = 0; i < n; ++i)\n    copy[i] = arr[i];\n  return copy;\n}\n\nfunction spliceOne(list, index) {\n  for (; index + 1 < list.length; index++)\n    list[index] = list[index + 1];\n  list.pop();\n}\n\nfunction unwrapListeners(arr) {\n  var ret = new Array(arr.length);\n  for (var i = 0; i < ret.length; ++i) {\n    ret[i] = arr[i].listener || arr[i];\n  }\n  return ret;\n}\n\n\n//# sourceURL=webpack:///./node_modules/node-libs-browser/node_modules/events/events.js?")},"./node_modules/node-libs-browser/node_modules/safe-buffer/index.js":function(module,exports,__webpack_require__){eval("/* eslint-disable node/no-deprecated-api */\nvar buffer = __webpack_require__(/*! buffer */ \"./node_modules/buffer/index.js\")\nvar Buffer = buffer.Buffer\n\n// alternative to using Object.keys for old browsers\nfunction copyProps (src, dst) {\n  for (var key in src) {\n    dst[key] = src[key]\n  }\n}\nif (Buffer.from && Buffer.alloc && Buffer.allocUnsafe && Buffer.allocUnsafeSlow) {\n  module.exports = buffer\n} else {\n  // Copy properties from require('buffer')\n  copyProps(buffer, exports)\n  exports.Buffer = SafeBuffer\n}\n\nfunction SafeBuffer (arg, encodingOrOffset, length) {\n  return Buffer(arg, encodingOrOffset, length)\n}\n\nSafeBuffer.prototype = Object.create(Buffer.prototype)\n\n// Copy static methods from Buffer\ncopyProps(Buffer, SafeBuffer)\n\nSafeBuffer.from = function (arg, encodingOrOffset, length) {\n  if (typeof arg === 'number') {\n    throw new TypeError('Argument must not be a number')\n  }\n  return Buffer(arg, encodingOrOffset, length)\n}\n\nSafeBuffer.alloc = function (size, fill, encoding) {\n  if (typeof size !== 'number') {\n    throw new TypeError('Argument must be a number')\n  }\n  var buf = Buffer(size)\n  if (fill !== undefined) {\n    if (typeof encoding === 'string') {\n      buf.fill(fill, encoding)\n    } else {\n      buf.fill(fill)\n    }\n  } else {\n    buf.fill(0)\n  }\n  return buf\n}\n\nSafeBuffer.allocUnsafe = function (size) {\n  if (typeof size !== 'number') {\n    throw new TypeError('Argument must be a number')\n  }\n  return Buffer(size)\n}\n\nSafeBuffer.allocUnsafeSlow = function (size) {\n  if (typeof size !== 'number') {\n    throw new TypeError('Argument must be a number')\n  }\n  return buffer.SlowBuffer(size)\n}\n\n\n//# sourceURL=webpack:///./node_modules/node-libs-browser/node_modules/safe-buffer/index.js?")},
"./node_modules/node-libs-browser/node_modules/string_decoder/lib/string_decoder.js":function(module,exports,__webpack_require__){"use strict";eval("// Copyright Joyent, Inc. and other Node contributors.\n//\n// Permission is hereby granted, free of charge, to any person obtaining a\n// copy of this software and associated documentation files (the\n// \"Software\"), to deal in the Software without restriction, including\n// without limitation the rights to use, copy, modify, merge, publish,\n// distribute, sublicense, and/or sell copies of the Software, and to permit\n// persons to whom the Software is furnished to do so, subject to the\n// following conditions:\n//\n// The above copyright notice and this permission notice shall be included\n// in all copies or substantial portions of the Software.\n//\n// THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS\n// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF\n// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN\n// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,\n// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR\n// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE\n// USE OR OTHER DEALINGS IN THE SOFTWARE.\n\n\n\n/*<replacement>*/\n\nvar Buffer = __webpack_require__(/*! safe-buffer */ \"./node_modules/node-libs-browser/node_modules/safe-buffer/index.js\").Buffer;\n/*</replacement>*/\n\nvar isEncoding = Buffer.isEncoding || function (encoding) {\n  encoding = '' + encoding;\n  switch (encoding && encoding.toLowerCase()) {\n    case 'hex':case 'utf8':case 'utf-8':case 'ascii':case 'binary':case 'base64':case 'ucs2':case 'ucs-2':case 'utf16le':case 'utf-16le':case 'raw':\n      return true;\n    default:\n      return false;\n  }\n};\n\nfunction _normalizeEncoding(enc) {\n  if (!enc) return 'utf8';\n  var retried;\n  while (true) {\n    switch (enc) {\n      case 'utf8':\n      case 'utf-8':\n        return 'utf8';\n      case 'ucs2':\n      case 'ucs-2':\n      case 'utf16le':\n      case 'utf-16le':\n        return 'utf16le';\n      case 'latin1':\n      case 'binary':\n        return 'latin1';\n      case 'base64':\n      case 'ascii':\n      case 'hex':\n        return enc;\n      default:\n        if (retried) return; // undefined\n        enc = ('' + enc).toLowerCase();\n        retried = true;\n    }\n  }\n};\n\n// Do not cache `Buffer.isEncoding` when checking encoding names as some\n// modules monkey-patch it to support additional encodings\nfunction normalizeEncoding(enc) {\n  var nenc = _normalizeEncoding(enc);\n  if (typeof nenc !== 'string' && (Buffer.isEncoding === isEncoding || !isEncoding(enc))) throw new Error('Unknown encoding: ' + enc);\n  return nenc || enc;\n}\n\n// StringDecoder provides an interface for efficiently splitting a series of\n// buffers into a series of JS strings without breaking apart multi-byte\n// characters.\nexports.StringDecoder = StringDecoder;\nfunction StringDecoder(encoding) {\n  this.encoding = normalizeEncoding(encoding);\n  var nb;\n  switch (this.encoding) {\n    case 'utf16le':\n      this.text = utf16Text;\n      this.end = utf16End;\n      nb = 4;\n      break;\n    case 'utf8':\n      this.fillLast = utf8FillLast;\n      nb = 4;\n      break;\n    case 'base64':\n      this.text = base64Text;\n      this.end = base64End;\n      nb = 3;\n      break;\n    default:\n      this.write = simpleWrite;\n      this.end = simpleEnd;\n      return;\n  }\n  this.lastNeed = 0;\n  this.lastTotal = 0;\n  this.lastChar = Buffer.allocUnsafe(nb);\n}\n\nStringDecoder.prototype.write = function (buf) {\n  if (buf.length === 0) return '';\n  var r;\n  var i;\n  if (this.lastNeed) {\n    r = this.fillLast(buf);\n    if (r === undefined) return '';\n    i = this.lastNeed;\n    this.lastNeed = 0;\n  } else {\n    i = 0;\n  }\n  if (i < buf.length) return r ? r + this.text(buf, i) : this.text(buf, i);\n  return r || '';\n};\n\nStringDecoder.prototype.end = utf8End;\n\n// Returns only complete characters in a Buffer\nStringDecoder.prototype.text = utf8Text;\n\n// Attempts to complete a partial non-UTF-8 character using bytes from a Buffer\nStringDecoder.prototype.fillLast = function (buf) {\n  if (this.lastNeed <= buf.length) {\n    buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, this.lastNeed);\n    return this.lastChar.toString(this.encoding, 0, this.lastTotal);\n  }\n  buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, buf.length);\n  this.lastNeed -= buf.length;\n};\n\n// Checks the type of a UTF-8 byte, whether it's ASCII, a leading byte, or a\n// continuation byte. If an invalid byte is detected, -2 is returned.\nfunction utf8CheckByte(byte) {\n  if (byte <= 0x7F) return 0;else if (byte >> 5 === 0x06) return 2;else if (byte >> 4 === 0x0E) return 3;else if (byte >> 3 === 0x1E) return 4;\n  return byte >> 6 === 0x02 ? -1 : -2;\n}\n\n// Checks at most 3 bytes at the end of a Buffer in order to detect an\n// incomplete multi-byte UTF-8 character. The total number of bytes (2, 3, or 4)\n// needed to complete the UTF-8 character (if applicable) are returned.\nfunction utf8CheckIncomplete(self, buf, i) {\n  var j = buf.length - 1;\n  if (j < i) return 0;\n  var nb = utf8CheckByte(buf[j]);\n  if (nb >= 0) {\n    if (nb > 0) self.lastNeed = nb - 1;\n    return nb;\n  }\n  if (--j < i || nb === -2) return 0;\n  nb = utf8CheckByte(buf[j]);\n  if (nb >= 0) {\n    if (nb > 0) self.lastNeed = nb - 2;\n    return nb;\n  }\n  if (--j < i || nb === -2) return 0;\n  nb = utf8CheckByte(buf[j]);\n  if (nb >= 0) {\n    if (nb > 0) {\n      if (nb === 2) nb = 0;else self.lastNeed = nb - 3;\n    }\n    return nb;\n  }\n  return 0;\n}\n\n// Validates as many continuation bytes for a multi-byte UTF-8 character as\n// needed or are available. If we see a non-continuation byte where we expect\n// one, we \"replace\" the validated continuation bytes we've seen so far with\n// a single UTF-8 replacement character ('\\ufffd'), to match v8's UTF-8 decoding\n// behavior. The continuation byte check is included three times in the case\n// where all of the continuation bytes for a character exist in the same buffer.\n// It is also done this way as a slight performance increase instead of using a\n// loop.\nfunction utf8CheckExtraBytes(self, buf, p) {\n  if ((buf[0] & 0xC0) !== 0x80) {\n    self.lastNeed = 0;\n    return '\\ufffd';\n  }\n  if (self.lastNeed > 1 && buf.length > 1) {\n    if ((buf[1] & 0xC0) !== 0x80) {\n      self.lastNeed = 1;\n      return '\\ufffd';\n    }\n    if (self.lastNeed > 2 && buf.length > 2) {\n      if ((buf[2] & 0xC0) !== 0x80) {\n        self.lastNeed = 2;\n        return '\\ufffd';\n      }\n    }\n  }\n}\n\n// Attempts to complete a multi-byte UTF-8 character using bytes from a Buffer.\nfunction utf8FillLast(buf) {\n  var p = this.lastTotal - this.lastNeed;\n  var r = utf8CheckExtraBytes(this, buf, p);\n  if (r !== undefined) return r;\n  if (this.lastNeed <= buf.length) {\n    buf.copy(this.lastChar, p, 0, this.lastNeed);\n    return this.lastChar.toString(this.encoding, 0, this.lastTotal);\n  }\n  buf.copy(this.lastChar, p, 0, buf.length);\n  this.lastNeed -= buf.length;\n}\n\n// Returns all complete UTF-8 characters in a Buffer. If the Buffer ended on a\n// partial character, the character's bytes are buffered until the required\n// number of bytes are available.\nfunction utf8Text(buf, i) {\n  var total = utf8CheckIncomplete(this, buf, i);\n  if (!this.lastNeed) return buf.toString('utf8', i);\n  this.lastTotal = total;\n  var end = buf.length - (total - this.lastNeed);\n  buf.copy(this.lastChar, 0, end);\n  return buf.toString('utf8', i, end);\n}\n\n// For UTF-8, a replacement character is added when ending on a partial\n// character.\nfunction utf8End(buf) {\n  var r = buf && buf.length ? this.write(buf) : '';\n  if (this.lastNeed) return r + '\\ufffd';\n  return r;\n}\n\n// UTF-16LE typically needs two bytes per character, but even if we have an even\n// number of bytes available, we need to check if we end on a leading/high\n// surrogate. In that case, we need to wait for the next two bytes in order to\n// decode the last character properly.\nfunction utf16Text(buf, i) {\n  if ((buf.length - i) % 2 === 0) {\n    var r = buf.toString('utf16le', i);\n    if (r) {\n      var c = r.charCodeAt(r.length - 1);\n      if (c >= 0xD800 && c <= 0xDBFF) {\n        this.lastNeed = 2;\n        this.lastTotal = 4;\n        this.lastChar[0] = buf[buf.length - 2];\n        this.lastChar[1] = buf[buf.length - 1];\n        return r.slice(0, -1);\n      }\n    }\n    return r;\n  }\n  this.lastNeed = 1;\n  this.lastTotal = 2;\n  this.lastChar[0] = buf[buf.length - 1];\n  return buf.toString('utf16le', i, buf.length - 1);\n}\n\n// For UTF-16LE we do not explicitly append special replacement characters if we\n// end on a partial character, we simply let v8 handle that.\nfunction utf16End(buf) {\n  var r = buf && buf.length ? this.write(buf) : '';\n  if (this.lastNeed) {\n    var end = this.lastTotal - this.lastNeed;\n    return r + this.lastChar.toString('utf16le', 0, end);\n  }\n  return r;\n}\n\nfunction base64Text(buf, i) {\n  var n = (buf.length - i) % 3;\n  if (n === 0) return buf.toString('base64', i);\n  this.lastNeed = 3 - n;\n  this.lastTotal = 3;\n  if (n === 1) {\n    this.lastChar[0] = buf[buf.length - 1];\n  } else {\n    this.lastChar[0] = buf[buf.length - 2];\n    this.lastChar[1] = buf[buf.length - 1];\n  }\n  return buf.toString('base64', i, buf.length - n);\n}\n\nfunction base64End(buf) {\n  var r = buf && buf.length ? this.write(buf) : '';\n  if (this.lastNeed) return r + this.lastChar.toString('base64', 0, 3 - this.lastNeed);\n  return r;\n}\n\n// Pass bytes on through for single-byte encodings (e.g. ascii, latin1, hex)\nfunction simpleWrite(buf) {\n  return buf.toString(this.encoding);\n}\n\nfunction simpleEnd(buf) {\n  return buf && buf.length ? this.write(buf) : '';\n}\n\n//# sourceURL=webpack:///./node_modules/node-libs-browser/node_modules/string_decoder/lib/string_decoder.js?")},"./node_modules/node-libs-browser/node_modules/timers-browserify/main.js":function(module,exports,__webpack_require__){eval('/* WEBPACK VAR INJECTION */(function(global) {var scope = (typeof global !== "undefined" && global) ||\n            (typeof self !== "undefined" && self) ||\n            window;\nvar apply = Function.prototype.apply;\n\n// DOM APIs, for completeness\n\nexports.setTimeout = function() {\n  return new Timeout(apply.call(setTimeout, scope, arguments), clearTimeout);\n};\nexports.setInterval = function() {\n  return new Timeout(apply.call(setInterval, scope, arguments), clearInterval);\n};\nexports.clearTimeout =\nexports.clearInterval = function(timeout) {\n  if (timeout) {\n    timeout.close();\n  }\n};\n\nfunction Timeout(id, clearFn) {\n  this._id = id;\n  this._clearFn = clearFn;\n}\nTimeout.prototype.unref = Timeout.prototype.ref = function() {};\nTimeout.prototype.close = function() {\n  this._clearFn.call(scope, this._id);\n};\n\n// Does not start the time, just sets up the members needed.\nexports.enroll = function(item, msecs) {\n  clearTimeout(item._idleTimeoutId);\n  item._idleTimeout = msecs;\n};\n\nexports.unenroll = function(item) {\n  clearTimeout(item._idleTimeoutId);\n  item._idleTimeout = -1;\n};\n\nexports._unrefActive = exports.active = function(item) {\n  clearTimeout(item._idleTimeoutId);\n\n  var msecs = item._idleTimeout;\n  if (msecs >= 0) {\n    item._idleTimeoutId = setTimeout(function onTimeout() {\n      if (item._onTimeout)\n        item._onTimeout();\n    }, msecs);\n  }\n};\n\n// setimmediate attaches itself to the global object\n__webpack_require__(/*! setimmediate */ "./node_modules/setimmediate/setImmediate.js");\n// On some exotic environments, it\'s not clear which object `setimmediate` was\n// able to install onto.  Search each possibility in the same order as the\n// `setimmediate` library.\nexports.setImmediate = (typeof self !== "undefined" && self.setImmediate) ||\n                       (typeof global !== "undefined" && global.setImmediate) ||\n                       (this && this.setImmediate);\nexports.clearImmediate = (typeof self !== "undefined" && self.clearImmediate) ||\n                         (typeof global !== "undefined" && global.clearImmediate) ||\n                         (this && this.clearImmediate);\n\n/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(/*! ./../../../webpack/buildin/global.js */ "./node_modules/webpack/buildin/global.js")))\n\n//# sourceURL=webpack:///./node_modules/node-libs-browser/node_modules/timers-browserify/main.js?')},"./node_modules/pako/index.js":function(module,exports,__webpack_require__){"use strict";eval('// Top level file is just a mixin of submodules & constants\n\n\nvar assign    = __webpack_require__(/*! ./lib/utils/common */ "./node_modules/pako/lib/utils/common.js").assign;\n\nvar deflate   = __webpack_require__(/*! ./lib/deflate */ "./node_modules/pako/lib/deflate.js");\nvar inflate   = __webpack_require__(/*! ./lib/inflate */ "./node_modules/pako/lib/inflate.js");\nvar constants = __webpack_require__(/*! ./lib/zlib/constants */ "./node_modules/pako/lib/zlib/constants.js");\n\nvar pako = {};\n\nassign(pako, deflate, inflate, constants);\n\nmodule.exports = pako;\n\n\n//# sourceURL=webpack:///./node_modules/pako/index.js?')},"./node_modules/pako/lib/deflate.js":function(module,exports,__webpack_require__){"use strict";eval("\n\n\nvar zlib_deflate = __webpack_require__(/*! ./zlib/deflate */ \"./node_modules/pako/lib/zlib/deflate.js\");\nvar utils        = __webpack_require__(/*! ./utils/common */ \"./node_modules/pako/lib/utils/common.js\");\nvar strings      = __webpack_require__(/*! ./utils/strings */ \"./node_modules/pako/lib/utils/strings.js\");\nvar msg          = __webpack_require__(/*! ./zlib/messages */ \"./node_modules/pako/lib/zlib/messages.js\");\nvar ZStream      = __webpack_require__(/*! ./zlib/zstream */ \"./node_modules/pako/lib/zlib/zstream.js\");\n\nvar toString = Object.prototype.toString;\n\n/* Public constants ==========================================================*/\n/* ===========================================================================*/\n\nvar Z_NO_FLUSH      = 0;\nvar Z_FINISH        = 4;\n\nvar Z_OK            = 0;\nvar Z_STREAM_END    = 1;\nvar Z_SYNC_FLUSH    = 2;\n\nvar Z_DEFAULT_COMPRESSION = -1;\n\nvar Z_DEFAULT_STRATEGY    = 0;\n\nvar Z_DEFLATED  = 8;\n\n/* ===========================================================================*/\n\n\n/**\n * class Deflate\n *\n * Generic JS-style wrapper for zlib calls. If you don't need\n * streaming behaviour - use more simple functions: [[deflate]],\n * [[deflateRaw]] and [[gzip]].\n **/\n\n/* internal\n * Deflate.chunks -> Array\n *\n * Chunks of output data, if [[Deflate#onData]] not overriden.\n **/\n\n/**\n * Deflate.result -> Uint8Array|Array\n *\n * Compressed result, generated by default [[Deflate#onData]]\n * and [[Deflate#onEnd]] handlers. Filled after you push last chunk\n * (call [[Deflate#push]] with `Z_FINISH` / `true` param)  or if you\n * push a chunk with explicit flush (call [[Deflate#push]] with\n * `Z_SYNC_FLUSH` param).\n **/\n\n/**\n * Deflate.err -> Number\n *\n * Error code after deflate finished. 0 (Z_OK) on success.\n * You will not need it in real life, because deflate errors\n * are possible only on wrong options or bad `onData` / `onEnd`\n * custom handlers.\n **/\n\n/**\n * Deflate.msg -> String\n *\n * Error message, if [[Deflate.err]] != 0\n **/\n\n\n/**\n * new Deflate(options)\n * - options (Object): zlib deflate options.\n *\n * Creates new deflator instance with specified params. Throws exception\n * on bad params. Supported options:\n *\n * - `level`\n * - `windowBits`\n * - `memLevel`\n * - `strategy`\n * - `dictionary`\n *\n * [http://zlib.net/manual.html#Advanced](http://zlib.net/manual.html#Advanced)\n * for more information on these.\n *\n * Additional options, for internal needs:\n *\n * - `chunkSize` - size of generated data chunks (16K by default)\n * - `raw` (Boolean) - do raw deflate\n * - `gzip` (Boolean) - create gzip wrapper\n * - `to` (String) - if equal to 'string', then result will be \"binary string\"\n *    (each char code [0..255])\n * - `header` (Object) - custom header for gzip\n *   - `text` (Boolean) - true if compressed data believed to be text\n *   - `time` (Number) - modification time, unix timestamp\n *   - `os` (Number) - operation system code\n *   - `extra` (Array) - array of bytes with extra data (max 65536)\n *   - `name` (String) - file name (binary string)\n *   - `comment` (String) - comment (binary string)\n *   - `hcrc` (Boolean) - true if header crc should be added\n *\n * ##### Example:\n *\n * ```javascript\n * var pako = require('pako')\n *   , chunk1 = Uint8Array([1,2,3,4,5,6,7,8,9])\n *   , chunk2 = Uint8Array([10,11,12,13,14,15,16,17,18,19]);\n *\n * var deflate = new pako.Deflate({ level: 3});\n *\n * deflate.push(chunk1, false);\n * deflate.push(chunk2, true);  // true -> last chunk\n *\n * if (deflate.err) { throw new Error(deflate.err); }\n *\n * console.log(deflate.result);\n * ```\n **/\nfunction Deflate(options) {\n  if (!(this instanceof Deflate)) return new Deflate(options);\n\n  this.options = utils.assign({\n    level: Z_DEFAULT_COMPRESSION,\n    method: Z_DEFLATED,\n    chunkSize: 16384,\n    windowBits: 15,\n    memLevel: 8,\n    strategy: Z_DEFAULT_STRATEGY,\n    to: ''\n  }, options || {});\n\n  var opt = this.options;\n\n  if (opt.raw && (opt.windowBits > 0)) {\n    opt.windowBits = -opt.windowBits;\n  }\n\n  else if (opt.gzip && (opt.windowBits > 0) && (opt.windowBits < 16)) {\n    opt.windowBits += 16;\n  }\n\n  this.err    = 0;      // error code, if happens (0 = Z_OK)\n  this.msg    = '';     // error message\n  this.ended  = false;  // used to avoid multiple onEnd() calls\n  this.chunks = [];     // chunks of compressed data\n\n  this.strm = new ZStream();\n  this.strm.avail_out = 0;\n\n  var status = zlib_deflate.deflateInit2(\n    this.strm,\n    opt.level,\n    opt.method,\n    opt.windowBits,\n    opt.memLevel,\n    opt.strategy\n  );\n\n  if (status !== Z_OK) {\n    throw new Error(msg[status]);\n  }\n\n  if (opt.header) {\n    zlib_deflate.deflateSetHeader(this.strm, opt.header);\n  }\n\n  if (opt.dictionary) {\n    var dict;\n    // Convert data if needed\n    if (typeof opt.dictionary === 'string') {\n      // If we need to compress text, change encoding to utf8.\n      dict = strings.string2buf(opt.dictionary);\n    } else if (toString.call(opt.dictionary) === '[object ArrayBuffer]') {\n      dict = new Uint8Array(opt.dictionary);\n    } else {\n      dict = opt.dictionary;\n    }\n\n    status = zlib_deflate.deflateSetDictionary(this.strm, dict);\n\n    if (status !== Z_OK) {\n      throw new Error(msg[status]);\n    }\n\n    this._dict_set = true;\n  }\n}\n\n/**\n * Deflate#push(data[, mode]) -> Boolean\n * - data (Uint8Array|Array|ArrayBuffer|String): input data. Strings will be\n *   converted to utf8 byte sequence.\n * - mode (Number|Boolean): 0..6 for corresponding Z_NO_FLUSH..Z_TREE modes.\n *   See constants. Skipped or `false` means Z_NO_FLUSH, `true` meansh Z_FINISH.\n *\n * Sends input data to deflate pipe, generating [[Deflate#onData]] calls with\n * new compressed chunks. Returns `true` on success. The last data block must have\n * mode Z_FINISH (or `true`). That will flush internal pending buffers and call\n * [[Deflate#onEnd]]. For interim explicit flushes (without ending the stream) you\n * can use mode Z_SYNC_FLUSH, keeping the compression context.\n *\n * On fail call [[Deflate#onEnd]] with error code and return false.\n *\n * We strongly recommend to use `Uint8Array` on input for best speed (output\n * array format is detected automatically). Also, don't skip last param and always\n * use the same type in your code (boolean or number). That will improve JS speed.\n *\n * For regular `Array`-s make sure all elements are [0..255].\n *\n * ##### Example\n *\n * ```javascript\n * push(chunk, false); // push one of data chunks\n * ...\n * push(chunk, true);  // push last chunk\n * ```\n **/\nDeflate.prototype.push = function (data, mode) {\n  var strm = this.strm;\n  var chunkSize = this.options.chunkSize;\n  var status, _mode;\n\n  if (this.ended) { return false; }\n\n  _mode = (mode === ~~mode) ? mode : ((mode === true) ? Z_FINISH : Z_NO_FLUSH);\n\n  // Convert data if needed\n  if (typeof data === 'string') {\n    // If we need to compress text, change encoding to utf8.\n    strm.input = strings.string2buf(data);\n  } else if (toString.call(data) === '[object ArrayBuffer]') {\n    strm.input = new Uint8Array(data);\n  } else {\n    strm.input = data;\n  }\n\n  strm.next_in = 0;\n  strm.avail_in = strm.input.length;\n\n  do {\n    if (strm.avail_out === 0) {\n      strm.output = new utils.Buf8(chunkSize);\n      strm.next_out = 0;\n      strm.avail_out = chunkSize;\n    }\n    status = zlib_deflate.deflate(strm, _mode);    /* no bad return value */\n\n    if (status !== Z_STREAM_END && status !== Z_OK) {\n      this.onEnd(status);\n      this.ended = true;\n      return false;\n    }\n    if (strm.avail_out === 0 || (strm.avail_in === 0 && (_mode === Z_FINISH || _mode === Z_SYNC_FLUSH))) {\n      if (this.options.to === 'string') {\n        this.onData(strings.buf2binstring(utils.shrinkBuf(strm.output, strm.next_out)));\n      } else {\n        this.onData(utils.shrinkBuf(strm.output, strm.next_out));\n      }\n    }\n  } while ((strm.avail_in > 0 || strm.avail_out === 0) && status !== Z_STREAM_END);\n\n  // Finalize on the last chunk.\n  if (_mode === Z_FINISH) {\n    status = zlib_deflate.deflateEnd(this.strm);\n    this.onEnd(status);\n    this.ended = true;\n    return status === Z_OK;\n  }\n\n  // callback interim results if Z_SYNC_FLUSH.\n  if (_mode === Z_SYNC_FLUSH) {\n    this.onEnd(Z_OK);\n    strm.avail_out = 0;\n    return true;\n  }\n\n  return true;\n};\n\n\n/**\n * Deflate#onData(chunk) -> Void\n * - chunk (Uint8Array|Array|String): ouput data. Type of array depends\n *   on js engine support. When string output requested, each chunk\n *   will be string.\n *\n * By default, stores data blocks in `chunks[]` property and glue\n * those in `onEnd`. Override this handler, if you need another behaviour.\n **/\nDeflate.prototype.onData = function (chunk) {\n  this.chunks.push(chunk);\n};\n\n\n/**\n * Deflate#onEnd(status) -> Void\n * - status (Number): deflate status. 0 (Z_OK) on success,\n *   other if not.\n *\n * Called once after you tell deflate that the input stream is\n * complete (Z_FINISH) or should be flushed (Z_SYNC_FLUSH)\n * or if an error happened. By default - join collected chunks,\n * free memory and fill `results` / `err` properties.\n **/\nDeflate.prototype.onEnd = function (status) {\n  // On success - join\n  if (status === Z_OK) {\n    if (this.options.to === 'string') {\n      this.result = this.chunks.join('');\n    } else {\n      this.result = utils.flattenChunks(this.chunks);\n    }\n  }\n  this.chunks = [];\n  this.err = status;\n  this.msg = this.strm.msg;\n};\n\n\n/**\n * deflate(data[, options]) -> Uint8Array|Array|String\n * - data (Uint8Array|Array|String): input data to compress.\n * - options (Object): zlib deflate options.\n *\n * Compress `data` with deflate algorithm and `options`.\n *\n * Supported options are:\n *\n * - level\n * - windowBits\n * - memLevel\n * - strategy\n * - dictionary\n *\n * [http://zlib.net/manual.html#Advanced](http://zlib.net/manual.html#Advanced)\n * for more information on these.\n *\n * Sugar (options):\n *\n * - `raw` (Boolean) - say that we work with raw stream, if you don't wish to specify\n *   negative windowBits implicitly.\n * - `to` (String) - if equal to 'string', then result will be \"binary string\"\n *    (each char code [0..255])\n *\n * ##### Example:\n *\n * ```javascript\n * var pako = require('pako')\n *   , data = Uint8Array([1,2,3,4,5,6,7,8,9]);\n *\n * console.log(pako.deflate(data));\n * ```\n **/\nfunction deflate(input, options) {\n  var deflator = new Deflate(options);\n\n  deflator.push(input, true);\n\n  // That will never happens, if you don't cheat with options :)\n  if (deflator.err) { throw deflator.msg || msg[deflator.err]; }\n\n  return deflator.result;\n}\n\n\n/**\n * deflateRaw(data[, options]) -> Uint8Array|Array|String\n * - data (Uint8Array|Array|String): input data to compress.\n * - options (Object): zlib deflate options.\n *\n * The same as [[deflate]], but creates raw data, without wrapper\n * (header and adler32 crc).\n **/\nfunction deflateRaw(input, options) {\n  options = options || {};\n  options.raw = true;\n  return deflate(input, options);\n}\n\n\n/**\n * gzip(data[, options]) -> Uint8Array|Array|String\n * - data (Uint8Array|Array|String): input data to compress.\n * - options (Object): zlib deflate options.\n *\n * The same as [[deflate]], but create gzip wrapper instead of\n * deflate one.\n **/\nfunction gzip(input, options) {\n  options = options || {};\n  options.gzip = true;\n  return deflate(input, options);\n}\n\n\nexports.Deflate = Deflate;\nexports.deflate = deflate;\nexports.deflateRaw = deflateRaw;\nexports.gzip = gzip;\n\n\n//# sourceURL=webpack:///./node_modules/pako/lib/deflate.js?")},"./node_modules/pako/lib/inflate.js":function(module,exports,__webpack_require__){"use strict"
;eval("\n\n\nvar zlib_inflate = __webpack_require__(/*! ./zlib/inflate */ \"./node_modules/pako/lib/zlib/inflate.js\");\nvar utils        = __webpack_require__(/*! ./utils/common */ \"./node_modules/pako/lib/utils/common.js\");\nvar strings      = __webpack_require__(/*! ./utils/strings */ \"./node_modules/pako/lib/utils/strings.js\");\nvar c            = __webpack_require__(/*! ./zlib/constants */ \"./node_modules/pako/lib/zlib/constants.js\");\nvar msg          = __webpack_require__(/*! ./zlib/messages */ \"./node_modules/pako/lib/zlib/messages.js\");\nvar ZStream      = __webpack_require__(/*! ./zlib/zstream */ \"./node_modules/pako/lib/zlib/zstream.js\");\nvar GZheader     = __webpack_require__(/*! ./zlib/gzheader */ \"./node_modules/pako/lib/zlib/gzheader.js\");\n\nvar toString = Object.prototype.toString;\n\n/**\n * class Inflate\n *\n * Generic JS-style wrapper for zlib calls. If you don't need\n * streaming behaviour - use more simple functions: [[inflate]]\n * and [[inflateRaw]].\n **/\n\n/* internal\n * inflate.chunks -> Array\n *\n * Chunks of output data, if [[Inflate#onData]] not overriden.\n **/\n\n/**\n * Inflate.result -> Uint8Array|Array|String\n *\n * Uncompressed result, generated by default [[Inflate#onData]]\n * and [[Inflate#onEnd]] handlers. Filled after you push last chunk\n * (call [[Inflate#push]] with `Z_FINISH` / `true` param) or if you\n * push a chunk with explicit flush (call [[Inflate#push]] with\n * `Z_SYNC_FLUSH` param).\n **/\n\n/**\n * Inflate.err -> Number\n *\n * Error code after inflate finished. 0 (Z_OK) on success.\n * Should be checked if broken data possible.\n **/\n\n/**\n * Inflate.msg -> String\n *\n * Error message, if [[Inflate.err]] != 0\n **/\n\n\n/**\n * new Inflate(options)\n * - options (Object): zlib inflate options.\n *\n * Creates new inflator instance with specified params. Throws exception\n * on bad params. Supported options:\n *\n * - `windowBits`\n * - `dictionary`\n *\n * [http://zlib.net/manual.html#Advanced](http://zlib.net/manual.html#Advanced)\n * for more information on these.\n *\n * Additional options, for internal needs:\n *\n * - `chunkSize` - size of generated data chunks (16K by default)\n * - `raw` (Boolean) - do raw inflate\n * - `to` (String) - if equal to 'string', then result will be converted\n *   from utf8 to utf16 (javascript) string. When string output requested,\n *   chunk length can differ from `chunkSize`, depending on content.\n *\n * By default, when no options set, autodetect deflate/gzip data format via\n * wrapper header.\n *\n * ##### Example:\n *\n * ```javascript\n * var pako = require('pako')\n *   , chunk1 = Uint8Array([1,2,3,4,5,6,7,8,9])\n *   , chunk2 = Uint8Array([10,11,12,13,14,15,16,17,18,19]);\n *\n * var inflate = new pako.Inflate({ level: 3});\n *\n * inflate.push(chunk1, false);\n * inflate.push(chunk2, true);  // true -> last chunk\n *\n * if (inflate.err) { throw new Error(inflate.err); }\n *\n * console.log(inflate.result);\n * ```\n **/\nfunction Inflate(options) {\n  if (!(this instanceof Inflate)) return new Inflate(options);\n\n  this.options = utils.assign({\n    chunkSize: 16384,\n    windowBits: 0,\n    to: ''\n  }, options || {});\n\n  var opt = this.options;\n\n  // Force window size for `raw` data, if not set directly,\n  // because we have no header for autodetect.\n  if (opt.raw && (opt.windowBits >= 0) && (opt.windowBits < 16)) {\n    opt.windowBits = -opt.windowBits;\n    if (opt.windowBits === 0) { opt.windowBits = -15; }\n  }\n\n  // If `windowBits` not defined (and mode not raw) - set autodetect flag for gzip/deflate\n  if ((opt.windowBits >= 0) && (opt.windowBits < 16) &&\n      !(options && options.windowBits)) {\n    opt.windowBits += 32;\n  }\n\n  // Gzip header has no info about windows size, we can do autodetect only\n  // for deflate. So, if window size not set, force it to max when gzip possible\n  if ((opt.windowBits > 15) && (opt.windowBits < 48)) {\n    // bit 3 (16) -> gzipped data\n    // bit 4 (32) -> autodetect gzip/deflate\n    if ((opt.windowBits & 15) === 0) {\n      opt.windowBits |= 15;\n    }\n  }\n\n  this.err    = 0;      // error code, if happens (0 = Z_OK)\n  this.msg    = '';     // error message\n  this.ended  = false;  // used to avoid multiple onEnd() calls\n  this.chunks = [];     // chunks of compressed data\n\n  this.strm   = new ZStream();\n  this.strm.avail_out = 0;\n\n  var status  = zlib_inflate.inflateInit2(\n    this.strm,\n    opt.windowBits\n  );\n\n  if (status !== c.Z_OK) {\n    throw new Error(msg[status]);\n  }\n\n  this.header = new GZheader();\n\n  zlib_inflate.inflateGetHeader(this.strm, this.header);\n}\n\n/**\n * Inflate#push(data[, mode]) -> Boolean\n * - data (Uint8Array|Array|ArrayBuffer|String): input data\n * - mode (Number|Boolean): 0..6 for corresponding Z_NO_FLUSH..Z_TREE modes.\n *   See constants. Skipped or `false` means Z_NO_FLUSH, `true` meansh Z_FINISH.\n *\n * Sends input data to inflate pipe, generating [[Inflate#onData]] calls with\n * new output chunks. Returns `true` on success. The last data block must have\n * mode Z_FINISH (or `true`). That will flush internal pending buffers and call\n * [[Inflate#onEnd]]. For interim explicit flushes (without ending the stream) you\n * can use mode Z_SYNC_FLUSH, keeping the decompression context.\n *\n * On fail call [[Inflate#onEnd]] with error code and return false.\n *\n * We strongly recommend to use `Uint8Array` on input for best speed (output\n * format is detected automatically). Also, don't skip last param and always\n * use the same type in your code (boolean or number). That will improve JS speed.\n *\n * For regular `Array`-s make sure all elements are [0..255].\n *\n * ##### Example\n *\n * ```javascript\n * push(chunk, false); // push one of data chunks\n * ...\n * push(chunk, true);  // push last chunk\n * ```\n **/\nInflate.prototype.push = function (data, mode) {\n  var strm = this.strm;\n  var chunkSize = this.options.chunkSize;\n  var dictionary = this.options.dictionary;\n  var status, _mode;\n  var next_out_utf8, tail, utf8str;\n  var dict;\n\n  // Flag to properly process Z_BUF_ERROR on testing inflate call\n  // when we check that all output data was flushed.\n  var allowBufError = false;\n\n  if (this.ended) { return false; }\n  _mode = (mode === ~~mode) ? mode : ((mode === true) ? c.Z_FINISH : c.Z_NO_FLUSH);\n\n  // Convert data if needed\n  if (typeof data === 'string') {\n    // Only binary strings can be decompressed on practice\n    strm.input = strings.binstring2buf(data);\n  } else if (toString.call(data) === '[object ArrayBuffer]') {\n    strm.input = new Uint8Array(data);\n  } else {\n    strm.input = data;\n  }\n\n  strm.next_in = 0;\n  strm.avail_in = strm.input.length;\n\n  do {\n    if (strm.avail_out === 0) {\n      strm.output = new utils.Buf8(chunkSize);\n      strm.next_out = 0;\n      strm.avail_out = chunkSize;\n    }\n\n    status = zlib_inflate.inflate(strm, c.Z_NO_FLUSH);    /* no bad return value */\n\n    if (status === c.Z_NEED_DICT && dictionary) {\n      // Convert data if needed\n      if (typeof dictionary === 'string') {\n        dict = strings.string2buf(dictionary);\n      } else if (toString.call(dictionary) === '[object ArrayBuffer]') {\n        dict = new Uint8Array(dictionary);\n      } else {\n        dict = dictionary;\n      }\n\n      status = zlib_inflate.inflateSetDictionary(this.strm, dict);\n\n    }\n\n    if (status === c.Z_BUF_ERROR && allowBufError === true) {\n      status = c.Z_OK;\n      allowBufError = false;\n    }\n\n    if (status !== c.Z_STREAM_END && status !== c.Z_OK) {\n      this.onEnd(status);\n      this.ended = true;\n      return false;\n    }\n\n    if (strm.next_out) {\n      if (strm.avail_out === 0 || status === c.Z_STREAM_END || (strm.avail_in === 0 && (_mode === c.Z_FINISH || _mode === c.Z_SYNC_FLUSH))) {\n\n        if (this.options.to === 'string') {\n\n          next_out_utf8 = strings.utf8border(strm.output, strm.next_out);\n\n          tail = strm.next_out - next_out_utf8;\n          utf8str = strings.buf2string(strm.output, next_out_utf8);\n\n          // move tail\n          strm.next_out = tail;\n          strm.avail_out = chunkSize - tail;\n          if (tail) { utils.arraySet(strm.output, strm.output, next_out_utf8, tail, 0); }\n\n          this.onData(utf8str);\n\n        } else {\n          this.onData(utils.shrinkBuf(strm.output, strm.next_out));\n        }\n      }\n    }\n\n    // When no more input data, we should check that internal inflate buffers\n    // are flushed. The only way to do it when avail_out = 0 - run one more\n    // inflate pass. But if output data not exists, inflate return Z_BUF_ERROR.\n    // Here we set flag to process this error properly.\n    //\n    // NOTE. Deflate does not return error in this case and does not needs such\n    // logic.\n    if (strm.avail_in === 0 && strm.avail_out === 0) {\n      allowBufError = true;\n    }\n\n  } while ((strm.avail_in > 0 || strm.avail_out === 0) && status !== c.Z_STREAM_END);\n\n  if (status === c.Z_STREAM_END) {\n    _mode = c.Z_FINISH;\n  }\n\n  // Finalize on the last chunk.\n  if (_mode === c.Z_FINISH) {\n    status = zlib_inflate.inflateEnd(this.strm);\n    this.onEnd(status);\n    this.ended = true;\n    return status === c.Z_OK;\n  }\n\n  // callback interim results if Z_SYNC_FLUSH.\n  if (_mode === c.Z_SYNC_FLUSH) {\n    this.onEnd(c.Z_OK);\n    strm.avail_out = 0;\n    return true;\n  }\n\n  return true;\n};\n\n\n/**\n * Inflate#onData(chunk) -> Void\n * - chunk (Uint8Array|Array|String): ouput data. Type of array depends\n *   on js engine support. When string output requested, each chunk\n *   will be string.\n *\n * By default, stores data blocks in `chunks[]` property and glue\n * those in `onEnd`. Override this handler, if you need another behaviour.\n **/\nInflate.prototype.onData = function (chunk) {\n  this.chunks.push(chunk);\n};\n\n\n/**\n * Inflate#onEnd(status) -> Void\n * - status (Number): inflate status. 0 (Z_OK) on success,\n *   other if not.\n *\n * Called either after you tell inflate that the input stream is\n * complete (Z_FINISH) or should be flushed (Z_SYNC_FLUSH)\n * or if an error happened. By default - join collected chunks,\n * free memory and fill `results` / `err` properties.\n **/\nInflate.prototype.onEnd = function (status) {\n  // On success - join\n  if (status === c.Z_OK) {\n    if (this.options.to === 'string') {\n      // Glue & convert here, until we teach pako to send\n      // utf8 alligned strings to onData\n      this.result = this.chunks.join('');\n    } else {\n      this.result = utils.flattenChunks(this.chunks);\n    }\n  }\n  this.chunks = [];\n  this.err = status;\n  this.msg = this.strm.msg;\n};\n\n\n/**\n * inflate(data[, options]) -> Uint8Array|Array|String\n * - data (Uint8Array|Array|String): input data to decompress.\n * - options (Object): zlib inflate options.\n *\n * Decompress `data` with inflate/ungzip and `options`. Autodetect\n * format via wrapper header by default. That's why we don't provide\n * separate `ungzip` method.\n *\n * Supported options are:\n *\n * - windowBits\n *\n * [http://zlib.net/manual.html#Advanced](http://zlib.net/manual.html#Advanced)\n * for more information.\n *\n * Sugar (options):\n *\n * - `raw` (Boolean) - say that we work with raw stream, if you don't wish to specify\n *   negative windowBits implicitly.\n * - `to` (String) - if equal to 'string', then result will be converted\n *   from utf8 to utf16 (javascript) string. When string output requested,\n *   chunk length can differ from `chunkSize`, depending on content.\n *\n *\n * ##### Example:\n *\n * ```javascript\n * var pako = require('pako')\n *   , input = pako.deflate([1,2,3,4,5,6,7,8,9])\n *   , output;\n *\n * try {\n *   output = pako.inflate(input);\n * } catch (err)\n *   console.log(err);\n * }\n * ```\n **/\nfunction inflate(input, options) {\n  var inflator = new Inflate(options);\n\n  inflator.push(input, true);\n\n  // That will never happens, if you don't cheat with options :)\n  if (inflator.err) { throw inflator.msg || msg[inflator.err]; }\n\n  return inflator.result;\n}\n\n\n/**\n * inflateRaw(data[, options]) -> Uint8Array|Array|String\n * - data (Uint8Array|Array|String): input data to decompress.\n * - options (Object): zlib inflate options.\n *\n * The same as [[inflate]], but creates raw data, without wrapper\n * (header and adler32 crc).\n **/\nfunction inflateRaw(input, options) {\n  options = options || {};\n  options.raw = true;\n  return inflate(input, options);\n}\n\n\n/**\n * ungzip(data[, options]) -> Uint8Array|Array|String\n * - data (Uint8Array|Array|String): input data to decompress.\n * - options (Object): zlib inflate options.\n *\n * Just shortcut to [[inflate]], because it autodetects format\n * by header.content. Done for convenience.\n **/\n\n\nexports.Inflate = Inflate;\nexports.inflate = inflate;\nexports.inflateRaw = inflateRaw;\nexports.ungzip  = inflate;\n\n\n//# sourceURL=webpack:///./node_modules/pako/lib/inflate.js?")},"./node_modules/pako/lib/utils/common.js":function(module,exports,__webpack_require__){"use strict";eval("\n\n\nvar TYPED_OK =  (typeof Uint8Array !== 'undefined') &&\n                (typeof Uint16Array !== 'undefined') &&\n                (typeof Int32Array !== 'undefined');\n\n\nexports.assign = function (obj /*from1, from2, from3, ...*/) {\n  var sources = Array.prototype.slice.call(arguments, 1);\n  while (sources.length) {\n    var source = sources.shift();\n    if (!source) { continue; }\n\n    if (typeof source !== 'object') {\n      throw new TypeError(source + 'must be non-object');\n    }\n\n    for (var p in source) {\n      if (source.hasOwnProperty(p)) {\n        obj[p] = source[p];\n      }\n    }\n  }\n\n  return obj;\n};\n\n\n// reduce buffer size, avoiding mem copy\nexports.shrinkBuf = function (buf, size) {\n  if (buf.length === size) { return buf; }\n  if (buf.subarray) { return buf.subarray(0, size); }\n  buf.length = size;\n  return buf;\n};\n\n\nvar fnTyped = {\n  arraySet: function (dest, src, src_offs, len, dest_offs) {\n    if (src.subarray && dest.subarray) {\n      dest.set(src.subarray(src_offs, src_offs + len), dest_offs);\n      return;\n    }\n    // Fallback to ordinary array\n    for (var i = 0; i < len; i++) {\n      dest[dest_offs + i] = src[src_offs + i];\n    }\n  },\n  // Join array of chunks to single array.\n  flattenChunks: function (chunks) {\n    var i, l, len, pos, chunk, result;\n\n    // calculate data length\n    len = 0;\n    for (i = 0, l = chunks.length; i < l; i++) {\n      len += chunks[i].length;\n    }\n\n    // join chunks\n    result = new Uint8Array(len);\n    pos = 0;\n    for (i = 0, l = chunks.length; i < l; i++) {\n      chunk = chunks[i];\n      result.set(chunk, pos);\n      pos += chunk.length;\n    }\n\n    return result;\n  }\n};\n\nvar fnUntyped = {\n  arraySet: function (dest, src, src_offs, len, dest_offs) {\n    for (var i = 0; i < len; i++) {\n      dest[dest_offs + i] = src[src_offs + i];\n    }\n  },\n  // Join array of chunks to single array.\n  flattenChunks: function (chunks) {\n    return [].concat.apply([], chunks);\n  }\n};\n\n\n// Enable/Disable typed arrays use, for testing\n//\nexports.setTyped = function (on) {\n  if (on) {\n    exports.Buf8  = Uint8Array;\n    exports.Buf16 = Uint16Array;\n    exports.Buf32 = Int32Array;\n    exports.assign(exports, fnTyped);\n  } else {\n    exports.Buf8  = Array;\n    exports.Buf16 = Array;\n    exports.Buf32 = Array;\n    exports.assign(exports, fnUntyped);\n  }\n};\n\nexports.setTyped(TYPED_OK);\n\n\n//# sourceURL=webpack:///./node_modules/pako/lib/utils/common.js?")},"./node_modules/pako/lib/utils/strings.js":function(module,exports,__webpack_require__){"use strict";eval("// String encode/decode helpers\n\n\n\nvar utils = __webpack_require__(/*! ./common */ \"./node_modules/pako/lib/utils/common.js\");\n\n\n// Quick check if we can use fast array to bin string conversion\n//\n// - apply(Array) can fail on Android 2.2\n// - apply(Uint8Array) can fail on iOS 5.1 Safary\n//\nvar STR_APPLY_OK = true;\nvar STR_APPLY_UIA_OK = true;\n\ntry { String.fromCharCode.apply(null, [ 0 ]); } catch (__) { STR_APPLY_OK = false; }\ntry { String.fromCharCode.apply(null, new Uint8Array(1)); } catch (__) { STR_APPLY_UIA_OK = false; }\n\n\n// Table with utf8 lengths (calculated by first byte of sequence)\n// Note, that 5 & 6-byte values and some 4-byte values can not be represented in JS,\n// because max possible codepoint is 0x10ffff\nvar _utf8len = new utils.Buf8(256);\nfor (var q = 0; q < 256; q++) {\n  _utf8len[q] = (q >= 252 ? 6 : q >= 248 ? 5 : q >= 240 ? 4 : q >= 224 ? 3 : q >= 192 ? 2 : 1);\n}\n_utf8len[254] = _utf8len[254] = 1; // Invalid sequence start\n\n\n// convert string to array (typed, when possible)\nexports.string2buf = function (str) {\n  var buf, c, c2, m_pos, i, str_len = str.length, buf_len = 0;\n\n  // count binary size\n  for (m_pos = 0; m_pos < str_len; m_pos++) {\n    c = str.charCodeAt(m_pos);\n    if ((c & 0xfc00) === 0xd800 && (m_pos + 1 < str_len)) {\n      c2 = str.charCodeAt(m_pos + 1);\n      if ((c2 & 0xfc00) === 0xdc00) {\n        c = 0x10000 + ((c - 0xd800) << 10) + (c2 - 0xdc00);\n        m_pos++;\n      }\n    }\n    buf_len += c < 0x80 ? 1 : c < 0x800 ? 2 : c < 0x10000 ? 3 : 4;\n  }\n\n  // allocate buffer\n  buf = new utils.Buf8(buf_len);\n\n  // convert\n  for (i = 0, m_pos = 0; i < buf_len; m_pos++) {\n    c = str.charCodeAt(m_pos);\n    if ((c & 0xfc00) === 0xd800 && (m_pos + 1 < str_len)) {\n      c2 = str.charCodeAt(m_pos + 1);\n      if ((c2 & 0xfc00) === 0xdc00) {\n        c = 0x10000 + ((c - 0xd800) << 10) + (c2 - 0xdc00);\n        m_pos++;\n      }\n    }\n    if (c < 0x80) {\n      /* one byte */\n      buf[i++] = c;\n    } else if (c < 0x800) {\n      /* two bytes */\n      buf[i++] = 0xC0 | (c >>> 6);\n      buf[i++] = 0x80 | (c & 0x3f);\n    } else if (c < 0x10000) {\n      /* three bytes */\n      buf[i++] = 0xE0 | (c >>> 12);\n      buf[i++] = 0x80 | (c >>> 6 & 0x3f);\n      buf[i++] = 0x80 | (c & 0x3f);\n    } else {\n      /* four bytes */\n      buf[i++] = 0xf0 | (c >>> 18);\n      buf[i++] = 0x80 | (c >>> 12 & 0x3f);\n      buf[i++] = 0x80 | (c >>> 6 & 0x3f);\n      buf[i++] = 0x80 | (c & 0x3f);\n    }\n  }\n\n  return buf;\n};\n\n// Helper (used in 2 places)\nfunction buf2binstring(buf, len) {\n  // use fallback for big arrays to avoid stack overflow\n  if (len < 65537) {\n    if ((buf.subarray && STR_APPLY_UIA_OK) || (!buf.subarray && STR_APPLY_OK)) {\n      return String.fromCharCode.apply(null, utils.shrinkBuf(buf, len));\n    }\n  }\n\n  var result = '';\n  for (var i = 0; i < len; i++) {\n    result += String.fromCharCode(buf[i]);\n  }\n  return result;\n}\n\n\n// Convert byte array to binary string\nexports.buf2binstring = function (buf) {\n  return buf2binstring(buf, buf.length);\n};\n\n\n// Convert binary string (typed, when possible)\nexports.binstring2buf = function (str) {\n  var buf = new utils.Buf8(str.length);\n  for (var i = 0, len = buf.length; i < len; i++) {\n    buf[i] = str.charCodeAt(i);\n  }\n  return buf;\n};\n\n\n// convert array to string\nexports.buf2string = function (buf, max) {\n  var i, out, c, c_len;\n  var len = max || buf.length;\n\n  // Reserve max possible length (2 words per char)\n  // NB: by unknown reasons, Array is significantly faster for\n  //     String.fromCharCode.apply than Uint16Array.\n  var utf16buf = new Array(len * 2);\n\n  for (out = 0, i = 0; i < len;) {\n    c = buf[i++];\n    // quick process ascii\n    if (c < 0x80) { utf16buf[out++] = c; continue; }\n\n    c_len = _utf8len[c];\n    // skip 5 & 6 byte codes\n    if (c_len > 4) { utf16buf[out++] = 0xfffd; i += c_len - 1; continue; }\n\n    // apply mask on first byte\n    c &= c_len === 2 ? 0x1f : c_len === 3 ? 0x0f : 0x07;\n    // join the rest\n    while (c_len > 1 && i < len) {\n      c = (c << 6) | (buf[i++] & 0x3f);\n      c_len--;\n    }\n\n    // terminated by end of string?\n    if (c_len > 1) { utf16buf[out++] = 0xfffd; continue; }\n\n    if (c < 0x10000) {\n      utf16buf[out++] = c;\n    } else {\n      c -= 0x10000;\n      utf16buf[out++] = 0xd800 | ((c >> 10) & 0x3ff);\n      utf16buf[out++] = 0xdc00 | (c & 0x3ff);\n    }\n  }\n\n  return buf2binstring(utf16buf, out);\n};\n\n\n// Calculate max possible position in utf8 buffer,\n// that will not break sequence. If that's not possible\n// - (very small limits) return max size as is.\n//\n// buf[] - utf8 bytes array\n// max   - length limit (mandatory);\nexports.utf8border = function (buf, max) {\n  var pos;\n\n  max = max || buf.length;\n  if (max > buf.length) { max = buf.length; }\n\n  // go back from last position, until start of sequence found\n  pos = max - 1;\n  while (pos >= 0 && (buf[pos] & 0xC0) === 0x80) { pos--; }\n\n  // Fuckup - very small and broken sequence,\n  // return max, because we should return something anyway.\n  if (pos < 0) { return max; }\n\n  // If we came to start of buffer - that means vuffer is too small,\n  // return max too.\n  if (pos === 0) { return max; }\n\n  return (pos + _utf8len[buf[pos]] > max) ? pos : max;\n};\n\n\n//# sourceURL=webpack:///./node_modules/pako/lib/utils/strings.js?")},"./node_modules/pako/lib/zlib/adler32.js":function(module,exports,__webpack_require__){"use strict";eval("\n\n// Note: adler32 takes 12% for level 0 and 2% for level 6.\n// It doesn't worth to make additional optimizationa as in original.\n// Small size is preferable.\n\n// (C) 1995-2013 Jean-loup Gailly and Mark Adler\n// (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin\n//\n// This software is provided 'as-is', without any express or implied\n// warranty. In no event will the authors be held liable for any damages\n// arising from the use of this software.\n//\n// Permission is granted to anyone to use this software for any purpose,\n// including commercial applications, and to alter it and redistribute it\n// freely, subject to the following restrictions:\n//\n// 1. The origin of this software must not be misrepresented; you must not\n//   claim that you wrote the original software. If you use this software\n//   in a product, an acknowledgment in the product documentation would be\n//   appreciated but is not required.\n// 2. Altered source versions must be plainly marked as such, and must not be\n//   misrepresented as being the original software.\n// 3. This notice may not be removed or altered from any source distribution.\n\nfunction adler32(adler, buf, len, pos) {\n  var s1 = (adler & 0xffff) |0,\n      s2 = ((adler >>> 16) & 0xffff) |0,\n      n = 0;\n\n  while (len !== 0) {\n    // Set limit ~ twice less than 5552, to keep\n    // s2 in 31-bits, because we force signed ints.\n    // in other case %= will fail.\n    n = len > 2000 ? 2000 : len;\n    len -= n;\n\n    do {\n      s1 = (s1 + buf[pos++]) |0;\n      s2 = (s2 + s1) |0;\n    } while (--n);\n\n    s1 %= 65521;\n    s2 %= 65521;\n  }\n\n  return (s1 | (s2 << 16)) |0;\n}\n\n\nmodule.exports = adler32;\n\n\n//# sourceURL=webpack:///./node_modules/pako/lib/zlib/adler32.js?")},"./node_modules/pako/lib/zlib/constants.js":function(module,exports,__webpack_require__){"use strict";eval("\n\n// (C) 1995-2013 Jean-loup Gailly and Mark Adler\n// (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin\n//\n// This software is provided 'as-is', without any express or implied\n// warranty. In no event will the authors be held liable for any damages\n// arising from the use of this software.\n//\n// Permission is granted to anyone to use this software for any purpose,\n// including commercial applications, and to alter it and redistribute it\n// freely, subject to the following restrictions:\n//\n// 1. The origin of this software must not be misrepresented; you must not\n//   claim that you wrote the original software. If you use this software\n//   in a product, an acknowledgment in the product documentation would be\n//   appreciated but is not required.\n// 2. Altered source versions must be plainly marked as such, and must not be\n//   misrepresented as being the original software.\n// 3. This notice may not be removed or altered from any source distribution.\n\nmodule.exports = {\n\n  /* Allowed flush values; see deflate() and inflate() below for details */\n  Z_NO_FLUSH:         0,\n  Z_PARTIAL_FLUSH:    1,\n  Z_SYNC_FLUSH:       2,\n  Z_FULL_FLUSH:       3,\n  Z_FINISH:           4,\n  Z_BLOCK:            5,\n  Z_TREES:            6,\n\n  /* Return codes for the compression/decompression functions. Negative values\n  * are errors, positive values are used for special but normal events.\n  */\n  Z_OK:               0,\n  Z_STREAM_END:       1,\n  Z_NEED_DICT:        2,\n  Z_ERRNO:           -1,\n  Z_STREAM_ERROR:    -2,\n  Z_DATA_ERROR:      -3,\n  //Z_MEM_ERROR:     -4,\n  Z_BUF_ERROR:       -5,\n  //Z_VERSION_ERROR: -6,\n\n  /* compression levels */\n  Z_NO_COMPRESSION:         0,\n  Z_BEST_SPEED:             1,\n  Z_BEST_COMPRESSION:       9,\n  Z_DEFAULT_COMPRESSION:   -1,\n\n\n  Z_FILTERED:               1,\n  Z_HUFFMAN_ONLY:           2,\n  Z_RLE:                    3,\n  Z_FIXED:                  4,\n  Z_DEFAULT_STRATEGY:       0,\n\n  /* Possible values of the data_type field (though see inflate()) */\n  Z_BINARY:                 0,\n  Z_TEXT:                   1,\n  //Z_ASCII:                1, // = Z_TEXT (deprecated)\n  Z_UNKNOWN:                2,\n\n  /* The deflate compression method */\n  Z_DEFLATED:               8\n  //Z_NULL:                 null // Use -1 or null inline, depending on var type\n};\n\n\n//# sourceURL=webpack:///./node_modules/pako/lib/zlib/constants.js?")},"./node_modules/pako/lib/zlib/crc32.js":function(module,exports,__webpack_require__){"use strict";eval("\n\n// Note: we can't get significant speed boost here.\n// So write code to minimize size - no pregenerated tables\n// and array tools dependencies.\n\n// (C) 1995-2013 Jean-loup Gailly and Mark Adler\n// (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin\n//\n// This software is provided 'as-is', without any express or implied\n// warranty. In no event will the authors be held liable for any damages\n// arising from the use of this software.\n//\n// Permission is granted to anyone to use this software for any purpose,\n// including commercial applications, and to alter it and redistribute it\n// freely, subject to the following restrictions:\n//\n// 1. The origin of this software must not be misrepresented; you must not\n//   claim that you wrote the original software. If you use this software\n//   in a product, an acknowledgment in the product documentation would be\n//   appreciated but is not required.\n// 2. Altered source versions must be plainly marked as such, and must not be\n//   misrepresented as being the original software.\n// 3. This notice may not be removed or altered from any source distribution.\n\n// Use ordinary array, since untyped makes no boost here\nfunction makeTable() {\n  var c, table = [];\n\n  for (var n = 0; n < 256; n++) {\n    c = n;\n    for (var k = 0; k < 8; k++) {\n      c = ((c & 1) ? (0xEDB88320 ^ (c >>> 1)) : (c >>> 1));\n    }\n    table[n] = c;\n  }\n\n  return table;\n}\n\n// Create table on load. Just 255 signed longs. Not a problem.\nvar crcTable = makeTable();\n\n\nfunction crc32(crc, buf, len, pos) {\n  var t = crcTable,\n      end = pos + len;\n\n  crc ^= -1;\n\n  for (var i = pos; i < end; i++) {\n    crc = (crc >>> 8) ^ t[(crc ^ buf[i]) & 0xFF];\n  }\n\n  return (crc ^ (-1)); // >>> 0;\n}\n\n\nmodule.exports = crc32;\n\n\n//# sourceURL=webpack:///./node_modules/pako/lib/zlib/crc32.js?")},"./node_modules/pako/lib/zlib/deflate.js":function(module,exports,__webpack_require__){"use strict"
;eval('\n\n// (C) 1995-2013 Jean-loup Gailly and Mark Adler\n// (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin\n//\n// This software is provided \'as-is\', without any express or implied\n// warranty. In no event will the authors be held liable for any damages\n// arising from the use of this software.\n//\n// Permission is granted to anyone to use this software for any purpose,\n// including commercial applications, and to alter it and redistribute it\n// freely, subject to the following restrictions:\n//\n// 1. The origin of this software must not be misrepresented; you must not\n//   claim that you wrote the original software. If you use this software\n//   in a product, an acknowledgment in the product documentation would be\n//   appreciated but is not required.\n// 2. Altered source versions must be plainly marked as such, and must not be\n//   misrepresented as being the original software.\n// 3. This notice may not be removed or altered from any source distribution.\n\nvar utils   = __webpack_require__(/*! ../utils/common */ "./node_modules/pako/lib/utils/common.js");\nvar trees   = __webpack_require__(/*! ./trees */ "./node_modules/pako/lib/zlib/trees.js");\nvar adler32 = __webpack_require__(/*! ./adler32 */ "./node_modules/pako/lib/zlib/adler32.js");\nvar crc32   = __webpack_require__(/*! ./crc32 */ "./node_modules/pako/lib/zlib/crc32.js");\nvar msg     = __webpack_require__(/*! ./messages */ "./node_modules/pako/lib/zlib/messages.js");\n\n/* Public constants ==========================================================*/\n/* ===========================================================================*/\n\n\n/* Allowed flush values; see deflate() and inflate() below for details */\nvar Z_NO_FLUSH      = 0;\nvar Z_PARTIAL_FLUSH = 1;\n//var Z_SYNC_FLUSH    = 2;\nvar Z_FULL_FLUSH    = 3;\nvar Z_FINISH        = 4;\nvar Z_BLOCK         = 5;\n//var Z_TREES         = 6;\n\n\n/* Return codes for the compression/decompression functions. Negative values\n * are errors, positive values are used for special but normal events.\n */\nvar Z_OK            = 0;\nvar Z_STREAM_END    = 1;\n//var Z_NEED_DICT     = 2;\n//var Z_ERRNO         = -1;\nvar Z_STREAM_ERROR  = -2;\nvar Z_DATA_ERROR    = -3;\n//var Z_MEM_ERROR     = -4;\nvar Z_BUF_ERROR     = -5;\n//var Z_VERSION_ERROR = -6;\n\n\n/* compression levels */\n//var Z_NO_COMPRESSION      = 0;\n//var Z_BEST_SPEED          = 1;\n//var Z_BEST_COMPRESSION    = 9;\nvar Z_DEFAULT_COMPRESSION = -1;\n\n\nvar Z_FILTERED            = 1;\nvar Z_HUFFMAN_ONLY        = 2;\nvar Z_RLE                 = 3;\nvar Z_FIXED               = 4;\nvar Z_DEFAULT_STRATEGY    = 0;\n\n/* Possible values of the data_type field (though see inflate()) */\n//var Z_BINARY              = 0;\n//var Z_TEXT                = 1;\n//var Z_ASCII               = 1; // = Z_TEXT\nvar Z_UNKNOWN             = 2;\n\n\n/* The deflate compression method */\nvar Z_DEFLATED  = 8;\n\n/*============================================================================*/\n\n\nvar MAX_MEM_LEVEL = 9;\n/* Maximum value for memLevel in deflateInit2 */\nvar MAX_WBITS = 15;\n/* 32K LZ77 window */\nvar DEF_MEM_LEVEL = 8;\n\n\nvar LENGTH_CODES  = 29;\n/* number of length codes, not counting the special END_BLOCK code */\nvar LITERALS      = 256;\n/* number of literal bytes 0..255 */\nvar L_CODES       = LITERALS + 1 + LENGTH_CODES;\n/* number of Literal or Length codes, including the END_BLOCK code */\nvar D_CODES       = 30;\n/* number of distance codes */\nvar BL_CODES      = 19;\n/* number of codes used to transfer the bit lengths */\nvar HEAP_SIZE     = 2 * L_CODES + 1;\n/* maximum heap size */\nvar MAX_BITS  = 15;\n/* All codes must not exceed MAX_BITS bits */\n\nvar MIN_MATCH = 3;\nvar MAX_MATCH = 258;\nvar MIN_LOOKAHEAD = (MAX_MATCH + MIN_MATCH + 1);\n\nvar PRESET_DICT = 0x20;\n\nvar INIT_STATE = 42;\nvar EXTRA_STATE = 69;\nvar NAME_STATE = 73;\nvar COMMENT_STATE = 91;\nvar HCRC_STATE = 103;\nvar BUSY_STATE = 113;\nvar FINISH_STATE = 666;\n\nvar BS_NEED_MORE      = 1; /* block not completed, need more input or more output */\nvar BS_BLOCK_DONE     = 2; /* block flush performed */\nvar BS_FINISH_STARTED = 3; /* finish started, need only more output at next deflate */\nvar BS_FINISH_DONE    = 4; /* finish done, accept no more input or output */\n\nvar OS_CODE = 0x03; // Unix :) . Don\'t detect, use this default.\n\nfunction err(strm, errorCode) {\n  strm.msg = msg[errorCode];\n  return errorCode;\n}\n\nfunction rank(f) {\n  return ((f) << 1) - ((f) > 4 ? 9 : 0);\n}\n\nfunction zero(buf) { var len = buf.length; while (--len >= 0) { buf[len] = 0; } }\n\n\n/* =========================================================================\n * Flush as much pending output as possible. All deflate() output goes\n * through this function so some applications may wish to modify it\n * to avoid allocating a large strm->output buffer and copying into it.\n * (See also read_buf()).\n */\nfunction flush_pending(strm) {\n  var s = strm.state;\n\n  //_tr_flush_bits(s);\n  var len = s.pending;\n  if (len > strm.avail_out) {\n    len = strm.avail_out;\n  }\n  if (len === 0) { return; }\n\n  utils.arraySet(strm.output, s.pending_buf, s.pending_out, len, strm.next_out);\n  strm.next_out += len;\n  s.pending_out += len;\n  strm.total_out += len;\n  strm.avail_out -= len;\n  s.pending -= len;\n  if (s.pending === 0) {\n    s.pending_out = 0;\n  }\n}\n\n\nfunction flush_block_only(s, last) {\n  trees._tr_flush_block(s, (s.block_start >= 0 ? s.block_start : -1), s.strstart - s.block_start, last);\n  s.block_start = s.strstart;\n  flush_pending(s.strm);\n}\n\n\nfunction put_byte(s, b) {\n  s.pending_buf[s.pending++] = b;\n}\n\n\n/* =========================================================================\n * Put a short in the pending buffer. The 16-bit value is put in MSB order.\n * IN assertion: the stream state is correct and there is enough room in\n * pending_buf.\n */\nfunction putShortMSB(s, b) {\n//  put_byte(s, (Byte)(b >> 8));\n//  put_byte(s, (Byte)(b & 0xff));\n  s.pending_buf[s.pending++] = (b >>> 8) & 0xff;\n  s.pending_buf[s.pending++] = b & 0xff;\n}\n\n\n/* ===========================================================================\n * Read a new buffer from the current input stream, update the adler32\n * and total number of bytes read.  All deflate() input goes through\n * this function so some applications may wish to modify it to avoid\n * allocating a large strm->input buffer and copying from it.\n * (See also flush_pending()).\n */\nfunction read_buf(strm, buf, start, size) {\n  var len = strm.avail_in;\n\n  if (len > size) { len = size; }\n  if (len === 0) { return 0; }\n\n  strm.avail_in -= len;\n\n  // zmemcpy(buf, strm->next_in, len);\n  utils.arraySet(buf, strm.input, strm.next_in, len, start);\n  if (strm.state.wrap === 1) {\n    strm.adler = adler32(strm.adler, buf, len, start);\n  }\n\n  else if (strm.state.wrap === 2) {\n    strm.adler = crc32(strm.adler, buf, len, start);\n  }\n\n  strm.next_in += len;\n  strm.total_in += len;\n\n  return len;\n}\n\n\n/* ===========================================================================\n * Set match_start to the longest match starting at the given string and\n * return its length. Matches shorter or equal to prev_length are discarded,\n * in which case the result is equal to prev_length and match_start is\n * garbage.\n * IN assertions: cur_match is the head of the hash chain for the current\n *   string (strstart) and its distance is <= MAX_DIST, and prev_length >= 1\n * OUT assertion: the match length is not greater than s->lookahead.\n */\nfunction longest_match(s, cur_match) {\n  var chain_length = s.max_chain_length;      /* max hash chain length */\n  var scan = s.strstart; /* current string */\n  var match;                       /* matched string */\n  var len;                           /* length of current match */\n  var best_len = s.prev_length;              /* best match length so far */\n  var nice_match = s.nice_match;             /* stop if match long enough */\n  var limit = (s.strstart > (s.w_size - MIN_LOOKAHEAD)) ?\n      s.strstart - (s.w_size - MIN_LOOKAHEAD) : 0/*NIL*/;\n\n  var _win = s.window; // shortcut\n\n  var wmask = s.w_mask;\n  var prev  = s.prev;\n\n  /* Stop when cur_match becomes <= limit. To simplify the code,\n   * we prevent matches with the string of window index 0.\n   */\n\n  var strend = s.strstart + MAX_MATCH;\n  var scan_end1  = _win[scan + best_len - 1];\n  var scan_end   = _win[scan + best_len];\n\n  /* The code is optimized for HASH_BITS >= 8 and MAX_MATCH-2 multiple of 16.\n   * It is easy to get rid of this optimization if necessary.\n   */\n  // Assert(s->hash_bits >= 8 && MAX_MATCH == 258, "Code too clever");\n\n  /* Do not waste too much time if we already have a good match: */\n  if (s.prev_length >= s.good_match) {\n    chain_length >>= 2;\n  }\n  /* Do not look for matches beyond the end of the input. This is necessary\n   * to make deflate deterministic.\n   */\n  if (nice_match > s.lookahead) { nice_match = s.lookahead; }\n\n  // Assert((ulg)s->strstart <= s->window_size-MIN_LOOKAHEAD, "need lookahead");\n\n  do {\n    // Assert(cur_match < s->strstart, "no future");\n    match = cur_match;\n\n    /* Skip to next match if the match length cannot increase\n     * or if the match length is less than 2.  Note that the checks below\n     * for insufficient lookahead only occur occasionally for performance\n     * reasons.  Therefore uninitialized memory will be accessed, and\n     * conditional jumps will be made that depend on those values.\n     * However the length of the match is limited to the lookahead, so\n     * the output of deflate is not affected by the uninitialized values.\n     */\n\n    if (_win[match + best_len]     !== scan_end  ||\n        _win[match + best_len - 1] !== scan_end1 ||\n        _win[match]                !== _win[scan] ||\n        _win[++match]              !== _win[scan + 1]) {\n      continue;\n    }\n\n    /* The check at best_len-1 can be removed because it will be made\n     * again later. (This heuristic is not always a win.)\n     * It is not necessary to compare scan[2] and match[2] since they\n     * are always equal when the other bytes match, given that\n     * the hash keys are equal and that HASH_BITS >= 8.\n     */\n    scan += 2;\n    match++;\n    // Assert(*scan == *match, "match[2]?");\n\n    /* We check for insufficient lookahead only every 8th comparison;\n     * the 256th check will be made at strstart+258.\n     */\n    do {\n      /*jshint noempty:false*/\n    } while (_win[++scan] === _win[++match] && _win[++scan] === _win[++match] &&\n             _win[++scan] === _win[++match] && _win[++scan] === _win[++match] &&\n             _win[++scan] === _win[++match] && _win[++scan] === _win[++match] &&\n             _win[++scan] === _win[++match] && _win[++scan] === _win[++match] &&\n             scan < strend);\n\n    // Assert(scan <= s->window+(unsigned)(s->window_size-1), "wild scan");\n\n    len = MAX_MATCH - (strend - scan);\n    scan = strend - MAX_MATCH;\n\n    if (len > best_len) {\n      s.match_start = cur_match;\n      best_len = len;\n      if (len >= nice_match) {\n        break;\n      }\n      scan_end1  = _win[scan + best_len - 1];\n      scan_end   = _win[scan + best_len];\n    }\n  } while ((cur_match = prev[cur_match & wmask]) > limit && --chain_length !== 0);\n\n  if (best_len <= s.lookahead) {\n    return best_len;\n  }\n  return s.lookahead;\n}\n\n\n/* ===========================================================================\n * Fill the window when the lookahead becomes insufficient.\n * Updates strstart and lookahead.\n *\n * IN assertion: lookahead < MIN_LOOKAHEAD\n * OUT assertions: strstart <= window_size-MIN_LOOKAHEAD\n *    At least one byte has been read, or avail_in == 0; reads are\n *    performed for at least two bytes (required for the zip translate_eol\n *    option -- not supported here).\n */\nfunction fill_window(s) {\n  var _w_size = s.w_size;\n  var p, n, m, more, str;\n\n  //Assert(s->lookahead < MIN_LOOKAHEAD, "already enough lookahead");\n\n  do {\n    more = s.window_size - s.lookahead - s.strstart;\n\n    // JS ints have 32 bit, block below not needed\n    /* Deal with !@#$% 64K limit: */\n    //if (sizeof(int) <= 2) {\n    //    if (more == 0 && s->strstart == 0 && s->lookahead == 0) {\n    //        more = wsize;\n    //\n    //  } else if (more == (unsigned)(-1)) {\n    //        /* Very unlikely, but possible on 16 bit machine if\n    //         * strstart == 0 && lookahead == 1 (input done a byte at time)\n    //         */\n    //        more--;\n    //    }\n    //}\n\n\n    /* If the window is almost full and there is insufficient lookahead,\n     * move the upper half to the lower one to make room in the upper half.\n     */\n    if (s.strstart >= _w_size + (_w_size - MIN_LOOKAHEAD)) {\n\n      utils.arraySet(s.window, s.window, _w_size, _w_size, 0);\n      s.match_start -= _w_size;\n      s.strstart -= _w_size;\n      /* we now have strstart >= MAX_DIST */\n      s.block_start -= _w_size;\n\n      /* Slide the hash table (could be avoided with 32 bit values\n       at the expense of memory usage). We slide even when level == 0\n       to keep the hash table consistent if we switch back to level > 0\n       later. (Using level 0 permanently is not an optimal usage of\n       zlib, so we don\'t care about this pathological case.)\n       */\n\n      n = s.hash_size;\n      p = n;\n      do {\n        m = s.head[--p];\n        s.head[p] = (m >= _w_size ? m - _w_size : 0);\n      } while (--n);\n\n      n = _w_size;\n      p = n;\n      do {\n        m = s.prev[--p];\n        s.prev[p] = (m >= _w_size ? m - _w_size : 0);\n        /* If n is not on any hash chain, prev[n] is garbage but\n         * its value will never be used.\n         */\n      } while (--n);\n\n      more += _w_size;\n    }\n    if (s.strm.avail_in === 0) {\n      break;\n    }\n\n    /* If there was no sliding:\n     *    strstart <= WSIZE+MAX_DIST-1 && lookahead <= MIN_LOOKAHEAD - 1 &&\n     *    more == window_size - lookahead - strstart\n     * => more >= window_size - (MIN_LOOKAHEAD-1 + WSIZE + MAX_DIST-1)\n     * => more >= window_size - 2*WSIZE + 2\n     * In the BIG_MEM or MMAP case (not yet supported),\n     *   window_size == input_size + MIN_LOOKAHEAD  &&\n     *   strstart + s->lookahead <= input_size => more >= MIN_LOOKAHEAD.\n     * Otherwise, window_size == 2*WSIZE so more >= 2.\n     * If there was sliding, more >= WSIZE. So in all cases, more >= 2.\n     */\n    //Assert(more >= 2, "more < 2");\n    n = read_buf(s.strm, s.window, s.strstart + s.lookahead, more);\n    s.lookahead += n;\n\n    /* Initialize the hash value now that we have some input: */\n    if (s.lookahead + s.insert >= MIN_MATCH) {\n      str = s.strstart - s.insert;\n      s.ins_h = s.window[str];\n\n      /* UPDATE_HASH(s, s->ins_h, s->window[str + 1]); */\n      s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[str + 1]) & s.hash_mask;\n//#if MIN_MATCH != 3\n//        Call update_hash() MIN_MATCH-3 more times\n//#endif\n      while (s.insert) {\n        /* UPDATE_HASH(s, s->ins_h, s->window[str + MIN_MATCH-1]); */\n        s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[str + MIN_MATCH - 1]) & s.hash_mask;\n\n        s.prev[str & s.w_mask] = s.head[s.ins_h];\n        s.head[s.ins_h] = str;\n        str++;\n        s.insert--;\n        if (s.lookahead + s.insert < MIN_MATCH) {\n          break;\n        }\n      }\n    }\n    /* If the whole input has less than MIN_MATCH bytes, ins_h is garbage,\n     * but this is not important since only literal bytes will be emitted.\n     */\n\n  } while (s.lookahead < MIN_LOOKAHEAD && s.strm.avail_in !== 0);\n\n  /* If the WIN_INIT bytes after the end of the current data have never been\n   * written, then zero those bytes in order to avoid memory check reports of\n   * the use of uninitialized (or uninitialised as Julian writes) bytes by\n   * the longest match routines.  Update the high water mark for the next\n   * time through here.  WIN_INIT is set to MAX_MATCH since the longest match\n   * routines allow scanning to strstart + MAX_MATCH, ignoring lookahead.\n   */\n//  if (s.high_water < s.window_size) {\n//    var curr = s.strstart + s.lookahead;\n//    var init = 0;\n//\n//    if (s.high_water < curr) {\n//      /* Previous high water mark below current data -- zero WIN_INIT\n//       * bytes or up to end of window, whichever is less.\n//       */\n//      init = s.window_size - curr;\n//      if (init > WIN_INIT)\n//        init = WIN_INIT;\n//      zmemzero(s->window + curr, (unsigned)init);\n//      s->high_water = curr + init;\n//    }\n//    else if (s->high_water < (ulg)curr + WIN_INIT) {\n//      /* High water mark at or above current data, but below current data\n//       * plus WIN_INIT -- zero out to current data plus WIN_INIT, or up\n//       * to end of window, whichever is less.\n//       */\n//      init = (ulg)curr + WIN_INIT - s->high_water;\n//      if (init > s->window_size - s->high_water)\n//        init =