"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const config_js_1 = require("./config.js");
const core_js_1 = require("./core.js");
const resolver_js_1 = require("./resolver.js");
/**
 * Creates a new wretch instance with a base url and base
 * [fetch options](https://developer.mozilla.org/en-US/docs/Web/API/WindowOrWorkerGlobalScope/fetch).
 *
 * ```ts
 * import wretch from "wretch"
 *
 * // Reusable instance
 * const w = wretch("https://domain.com", { mode: "cors" })
 * ```
 *
 * @param _url The base url
 * @param _options The base fetch options
 * @returns A fresh wretch instance
 */
function factory(_url = "", _options = {}) {
    return { ...core_js_1.core, _url, _options };
}
factory["default"] = factory;
factory.options = config_js_1.setOptions;
factory.errorType = config_js_1.setErrorType;
factory.polyfills = config_js_1.setPolyfills;
factory.WretchError = resolver_js_1.WretchError;
exports.default = factory;
//# sourceMappingURL=index.js.map