"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mix = exports.isLikelyJsonMime = exports.extractContentType = void 0;
const constants_js_1 = require("./constants.js");
function extractContentType(headers = {}) {
    var _a;
    const normalizedHeaders = headers instanceof Array ? Object.fromEntries(headers) : headers;
    return (_a = Object.entries(normalizedHeaders).find(([k]) => k.toLowerCase() === constants_js_1.CONTENT_TYPE_HEADER.toLowerCase())) === null || _a === void 0 ? void 0 : _a[1];
}
exports.extractContentType = extractContentType;
function isLikelyJsonMime(value) {
    return /^application\/.*json.*/.test(value);
}
exports.isLikelyJsonMime = isLikelyJsonMime;
const mix = function (one, two, mergeArrays = false) {
    return Object.entries(two).reduce((acc, [key, newValue]) => {
        const value = one[key];
        if (Array.isArray(value) && Array.isArray(newValue)) {
            acc[key] = mergeArrays ? [...value, ...newValue] : newValue;
        }
        else if (typeof value === "object" && typeof newValue === "object") {
            acc[key] = (0, exports.mix)(value, newValue, mergeArrays);
        }
        else {
            acc[key] = newValue;
        }
        return acc;
    }, { ...one });
};
exports.mix = mix;
//# sourceMappingURL=utils.js.map