/*!
 * Wunderbaum - util
 * Copyright (c) 2021-2023, Martin Wendt. Released under the MIT license.
 * v0.3.3, Wed, 07 Jun 2023 06:41:26 GMT (https://github.com/mar10/wunderbaum)
 */
const MOUSE_BUTTONS={0:"",1:"left",2:"middle",3:"right",4:"back",5:"forward"},MAX_INT=9007199254740991,userInfo=_getUserInfo(),isMac=userInfo.isMac,REX_HTML=/[&<>"'/]/g,REX_TOOLTIP=/[<>"'/]/g,ENTITY_MAP={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;","/":"&#x2F;"};let Deferred$1=class{constructor(){this.thens=[],this.catches=[],this.status=""}resolve(e){if(this.status)throw new Error("already settled");this.status="resolved",this.resolvedValue=e,this.thens.forEach((t=>t(e))),this.thens=[]}reject(e){if(this.status)throw new Error("already settled");this.status="rejected",this.rejectedError=e,this.catches.forEach((t=>t(e))),this.catches=[]}then(e){"resolved"===status?e(this.resolvedValue):this.thens.unshift(e)}catch(e){"rejected"===this.status?e(this.rejectedError):this.catches.unshift(e)}promise(){return{then:this.then,catch:this.catch}}};function assert(e,t){if(!e)throw t=t||"Assertion failed.",new Error(t)}function _getUserInfo(){const e=navigator;return{isMac:/Mac/.test(e.platform)}}function documentReady(e){"loading"===document.readyState?document.addEventListener("DOMContentLoaded",e):e()}function documentReadyPromise(){return new Promise((e=>{documentReady(e)}))}function each(e,t){if(null==e)return e;let i=e.length,s=0;if("number"==typeof i)for(;s<i&&!1!==t.call(e[s],s,e[s]);s++);else for(let i in e)if(!1===t.call(e[s],i,e[i]))break;return e}function error(e){throw new Error(e)}function escapeHtml(e){return(""+e).replace(REX_HTML,(function(e){return ENTITY_MAP[e]}))}function escapeRegex(e){return(""+e).replace(/([.?*+^$[\]\\(){}|-])/g,"\\$1")}function escapeTooltip(e){return(""+e).replace(REX_TOOLTIP,(function(e){return ENTITY_MAP[e]}))}function extractHtmlText(e){return e.indexOf(">")>=0&&error("Not implemented"),e}function getValueFromElem(e,t=!1){const i=e.tagName;let s=null;if("SPAN"===i&&e.classList.contains("wb-col")){const i=e,n=i.querySelector("input,select");if(n)return getValueFromElem(n,t);i.innerText=""+s}else if("INPUT"===i){const i=e;switch(i.type){case"button":case"reset":case"submit":case"image":break;case"checkbox":s=i.indeterminate?null:i.checked;break;case"date":case"datetime":case"datetime-local":case"month":case"time":case"week":s=t?i.valueAsDate:i.value;break;case"number":case"range":s=i.valueAsNumber;break;case"radio":const e=i.name,n=i.parentElement.querySelector(`input[name="${e}"]:checked`);s=n?n.value:void 0;break;default:s=i.value}}else if("SELECT"===i){s=e.value}return s}function setValueToElem(e,t){const i=e.tagName;if("SPAN"===i&&e.classList.contains("wb-col")){const i=e,s=i.querySelector("input,select");if(s)return setValueToElem(s,t);i.innerText=""+t}else if("INPUT"===i){const i=e,s=i.type;switch(s){case"checkbox":i.indeterminate=null===t,i.checked=!!t;break;case"date":case"month":case"time":case"week":case"datetime":case"datetime-local":i.valueAsDate=new Date(t);break;case"number":case"range":null==t?i.value=t:i.valueAsNumber=t;break;case"radio":error(`Not yet implemented: ${s}`);break;case"button":case"reset":case"submit":case"image":break;default:i.value=null!=t?t:""}}else if("SELECT"===i){const i=e;null==t?i.selectedIndex=-1:i.value=t}}function setElemDisplay(e,t){const i=elemFromSelector(e).style;t?"none"===i.display&&(i.display=""):""===i.display&&(i.display="none")}function elemFromHtml(e){const t=document.createElement("template");return t.innerHTML=e.trim(),t.content.firstElementChild}const _IGNORE_KEYS=new Set(["Alt","Control","Meta","Shift"]);function elemFromSelector(e){return e?"string"==typeof e?document.querySelector(e):e:null}function eventTargetFromSelector(e){return e?"string"==typeof e?document.querySelector(e):e:null}function eventToString(e){let t=e.key,i=e.type,s=[];return e.altKey&&s.push("Alt"),e.ctrlKey&&s.push("Control"),e.metaKey&&s.push("Meta"),e.shiftKey&&s.push("Shift"),"click"===i||"dblclick"===i?s.push(MOUSE_BUTTONS[e.button]+i):"wheel"===i?s.push(i):_IGNORE_KEYS.has(t)||s.push(t),s.join("+")}function extend(...e){for(let t=1;t<e.length;t++){let i=e[t];if(null!=i)for(let t in i)Object.prototype.hasOwnProperty.call(i,t)&&(e[0][t]=i[t])}return e[0]}function isArray(e){return Array.isArray(e)}function isEmptyObject(e){return 0===Object.keys(e).length&&e.constructor===Object}function isFunction(e){return"function"==typeof e}function isPlainObject(e){return"[object Object]"===Object.prototype.toString.call(e)}function noop(...e){}function onEvent(e,t,i,s){let n,r;e=eventTargetFromSelector(e),s?(n=i,r=s):(n="",r=i),t.split(" ").forEach((t=>{e.addEventListener(t,(function(e){if(!n)return r(e);if(e.target){let t=e.target;if(t.matches(n))return r(e);if(t=t.closest(n),t)return r(e)}}))}))}function overrideMethod(e,t,i,s){let n,r,o=s||e,l=e[t],a=(...e)=>l.apply(o,e),d=e=>l.apply(o,e);e[t]=(...e)=>{try{return n=o._super,r=o._superApply,o._super=a,o._superApply=d,i.apply(o,e)}finally{o._super=n,o._superApply=r}}}function setTimeoutPromise(e,t){return new Promise(((i,s)=>{setTimeout((()=>{try{i(e.apply(this))}catch(e){s(e)}}),t)}))}async function sleep(e){return new Promise((t=>setTimeout(t,e)))}function toggleCheckbox(e,t,i){const s=elemFromSelector(e);if(assert("checkbox"===s.type),null!=i||(i=s.classList.contains("wb-tristate")||s.indeterminate),void 0===t){switch(s.indeterminate?null:s.checked){case!0:t=!1;break;case!1:t=!i||null;break;case null:t=!0}}s.indeterminate=null==t,s.checked=!!t}function getOption(e,t,i=void 0){let s;e&&t.indexOf(".")>=0&&([s,t]=t.split("."),e=e[s]);let n=e?e[t]:null;return null!=n?n:i}function toSet(e){if(e instanceof Set)return e;if("string"==typeof e){let t=new Set;for(const i of e.split(" "))t.add(i.trim());return t}if(Array.isArray(e))return new Set(e);throw new Error("Cannot convert to Set<string>: "+e)}function type(e){return Object.prototype.toString.call(e).replace(/^\[object (.+)\]$/,"$1").toLowerCase()}function adaptiveThrottle(e,t){let i=0,s=null;const n=Object.assign({minDelay:16,defaultDelay:200,maxDelay:5e3,delayFactor:2},t),r=Math.max(16,+n.minDelay),o=+n.maxDelay,l=(...t)=>{if(i)s=t,i+=1;else{i=1;const a=t;s=null;const d=Date.now();try{e.apply(this,a)}catch(e){console.error(e)}const c=Date.now()-d,h=Math.min(Math.max(r,c*n.delayFactor),o),u=Math.max(r,h-c);setTimeout((()=>{i=0,null!=s&&l.apply(this,s)}),u)}};return l}var ChangeType,RenderFlag,NodeStatusType,NodeRegion,NavModeEnum,util=Object.freeze({__proto__:null,Deferred:Deferred$1,MAX_INT:MAX_INT,MOUSE_BUTTONS:MOUSE_BUTTONS,adaptiveThrottle:adaptiveThrottle,assert:assert,documentReady:documentReady,documentReadyPromise:documentReadyPromise,each:each,elemFromHtml:elemFromHtml,elemFromSelector:elemFromSelector,error:error,escapeHtml:escapeHtml,escapeRegex:escapeRegex,escapeTooltip:escapeTooltip,eventTargetFromSelector:eventTargetFromSelector,eventToString:eventToString,extend:extend,extractHtmlText:extractHtmlText,getOption:getOption,getValueFromElem:getValueFromElem,isArray:isArray,isEmptyObject:isEmptyObject,isFunction:isFunction,isMac:isMac,isPlainObject:isPlainObject,noop:noop,onEvent:onEvent,overrideMethod:overrideMethod,setElemDisplay:setElemDisplay,setTimeoutPromise:setTimeoutPromise,setValueToElem:setValueToElem,sleep:sleep,toSet:toSet,toggleCheckbox:toggleCheckbox,type:type});
/*!
 * Wunderbaum - types
 * Copyright (c) 2021-2023, Martin Wendt. Released under the MIT license.
 * v0.3.3, Wed, 07 Jun 2023 06:41:26 GMT (https://github.com/mar10/wunderbaum)
 */!function(e){e.any="any",e.data="data",e.colStructure="colStructure",e.resize="resize",e.row="row",e.structure="structure",e.status="status",e.scroll="scroll"}(ChangeType||(ChangeType={})),function(e){e.clearMarkup="clearMarkup",e.header="header",e.redraw="redraw",e.scroll="scroll"}(RenderFlag||(RenderFlag={})),function(e){e.ok="ok",e.loading="loading",e.error="error",e.noData="noData"}(NodeStatusType||(NodeStatusType={})),function(e){e.unknown="",e.checkbox="checkbox",e.column="column",e.expander="expander",e.icon="icon",e.prefix="prefix",e.title="title"}(NodeRegion||(NodeRegion={})),function(e){e.startRow="startRow",e.cell="cell",e.startCell="startCell",e.row="row"}(NavModeEnum||(NavModeEnum={}));
/*!
 * Wunderbaum - wb_extension_base
 * Copyright (c) 2021-2023, Martin Wendt. Released under the MIT license.
 * v0.3.3, Wed, 07 Jun 2023 06:41:26 GMT (https://github.com/mar10/wunderbaum)
 */
class WunderbaumExtension{constructor(e,t,i){this.enabled=!0,this.tree=e,this.id=t,this.treeOpts=e.options;const s=e.options;void 0===this.treeOpts[t]?s[t]=this.extensionOpts=extend({},i):(this.extensionOpts=extend({},i,s[t]),s[t]=this.extensionOpts),this.enabled=this.getPluginOption("enabled",!0)}init(){this.tree.element.classList.add("wb-ext-"+this.id)}getPluginOption(e,t){var i;return null!==(i=this.extensionOpts[e])&&void 0!==i?i:t}setPluginOption(e,t){this.extensionOpts[e]=t}setEnabled(e=!0){return this.setPluginOption("enabled",!!e)}onKeyEvent(e){}onRender(e){}}
/*!
 * debounce & throttle, taken from https://github.com/lodash/lodash v4.17.21
 * MIT License: https://raw.githubusercontent.com/lodash/lodash/4.17.21-npm/LICENSE
 * Modified for TypeScript type annotations.
 */const freeGlobal="object"==typeof global&&null!==global&&global.Object===Object&&global,freeGlobalThis="object"==typeof globalThis&&null!==globalThis&&globalThis.Object==Object&&globalThis,freeSelf="object"==typeof self&&null!==self&&self.Object===Object&&self,root=freeGlobalThis||freeGlobal||freeSelf||Function("return this")();function isObject(e){const t=typeof e;return null!=e&&("object"===t||"function"===t)}function debounce(e,t=0,i={}){let s,n,r,o,l,a,d=0,c=!1,h=!1,u=!0;const p=!t&&0!==t&&"function"==typeof root.requestAnimationFrame;if("function"!=typeof e)throw new TypeError("Expected a function");function f(t){const i=s,r=n;return s=n=void 0,d=t,o=e.apply(r,i),o}function g(e,t){return p?(root.cancelAnimationFrame(l),root.requestAnimationFrame(e)):setTimeout(e,t)}function m(e){const i=e-a;return void 0===a||i>=t||i<0||h&&e-d>=r}function v(){const e=Date.now();if(m(e))return y(e);l=g(v,function(e){const i=e-d,s=t-(e-a);return h?Math.min(s,r-i):s}(e))}function y(e){return l=void 0,u&&s?f(e):(s=n=void 0,o)}function b(...e){const i=Date.now(),r=m(i);if(s=e,n=this,a=i,r){if(void 0===l)return function(e){return d=e,l=g(v,t),c?f(e):o}(a);if(h)return l=g(v,t),f(a)}return void 0===l&&(l=g(v,t)),o}return t=+t||0,isObject(i)&&(c=!!i.leading,h="maxWait"in i,r=h?Math.max(+i.maxWait||0,t):r,u="trailing"in i?!!i.trailing:u),b.cancel=function(){void 0!==l&&function(e){if(p)return root.cancelAnimationFrame(e);clearTimeout(e)}(l),d=0,s=a=n=l=void 0},b.flush=function(){return void 0===l?o:y(Date.now())},b.pending=function(){return void 0!==l},b}
/*!
 * Wunderbaum - ext-filter
 * Copyright (c) 2021-2023, Martin Wendt. Released under the MIT license.
 * v0.3.3, Wed, 07 Jun 2023 06:41:26 GMT (https://github.com/mar10/wunderbaum)
 */const START_MARKER="￷",END_MARKER="￸",RE_START_MARKER=new RegExp(escapeRegex("￷"),"g"),RE_END_MARTKER=new RegExp(escapeRegex("￸"),"g");class FilterExtension extends WunderbaumExtension{constructor(e){super(e,"filter",{connectInput:null,autoApply:!0,autoExpand:!1,counter:!0,fuzzy:!1,hideExpandedCounter:!0,hideExpanders:!1,highlight:!0,leavesOnly:!1,mode:"dim",noData:!0}),this.lastFilterArgs=null}init(){super.init();const e=this.getPluginOption("connectInput");e&&(this.queryInput=elemFromSelector(e),onEvent(this.queryInput,"input",debounce((e=>{this.filterNodes(this.queryInput.value.trim(),{})}),700)))}setPluginOption(e,t){if(super.setPluginOption(e,t),"mode"===e)this.tree.filterMode="hide"===t?"hide":"dim",this.tree.updateFilter()}_applyFilterNoUpdate(e,t,i){return this.tree.runWithoutUpdate((()=>this._applyFilterImpl(e,t,i)))}_applyFilterImpl(e,t,i){let s,n,r=Date.now(),o=0,l=this.tree,a=l.options,d=a.autoCollapse,c=extend({},a.filter,i),h="hide"===c.mode,u=!!c.leavesOnly&&!t;if("string"==typeof e){if(""===e)return l.logInfo("Passing an empty string as a filter is handled as clearFilter()."),void this.clearFilter();s=c.fuzzy?e.split("").map(escapeRegex).reduce((function(e,t){return e+"([^"+t+"]*)"+t}),""):escapeRegex(e);let t=new RegExp(s,"i"),i=new RegExp(escapeRegex(e),"gi");e=e=>{if(!e.title)return!1;let s=e.title,r=s.match(t);return r&&c.highlight&&(n=c.fuzzy?_markFuzzyMatchedChars(s,r,!0):s.replace(i,(function(e){return"￷"+e+"￸"})),e.titleWithHighlight=escapeHtml(n).replace(RE_START_MARKER,"<mark>").replace(RE_END_MARTKER,"</mark>")),!!r}}return l.filterMode=c.mode,this.lastFilterArgs=arguments,l.element.classList.toggle("wb-ext-filter-hide",!!h),l.element.classList.toggle("wb-ext-filter-dim",!h),l.element.classList.toggle("wb-ext-filter-hide-expanders",!!c.hideExpanders),l.root.subMatchCount=0,l.visit((e=>{delete e.match,delete e.titleWithHighlight,e.subMatchCount=0})),l.setStatus(NodeStatusType.ok),a.autoCollapse=!1,l.visit((i=>{if(u&&null!=i.children)return;let s=e(i);if("skip"===s)return i.visit((function(e){e.match=!1}),!0),"skip";let n=!1;(t||"branch"===s)&&i.parent.match&&(s=!0,n=!0),s&&(o++,i.match=!0,i.visitParents((e=>{e!==i&&(e.subMatchCount+=1),!c.autoExpand||n||e.expanded||(e.setExpanded(!0,{noAnimation:!0,noEvents:!0,scrollIntoView:!1}),e._filterAutoExpanded=!0)}),!0))})),a.autoCollapse=d,0===o&&c.noData&&h&&l.root.setStatus(NodeStatusType.noData),l.logInfo(`Filter '${s}' found ${o} nodes in ${Date.now()-r} ms.`),o}filterNodes(e,t){return this._applyFilterNoUpdate(e,!1,t)}filterBranches(e,t){return this._applyFilterNoUpdate(e,!0,t)}updateFilter(){let e=this.tree;e.filterMode&&this.lastFilterArgs&&e.options.filter.autoApply?this._applyFilterNoUpdate.apply(this,this.lastFilterArgs):e.logWarn("updateFilter(): no filter active.")}clearFilter(){let e=this.tree;e.enableUpdate(!1),e.setStatus(NodeStatusType.ok),delete e.root.match,delete e.root.subMatchCount,e.visit((e=>{if(e.match&&e._rowElem){let t=e._rowElem.querySelector("span.wb-title");t.textContent=e.title,e._callEvent("enhanceTitle",{titleElem:t})}delete e.match,delete e.subMatchCount,delete e.titleWithHighlight,e.subMatchBadge&&(e.subMatchBadge.remove(),delete e.subMatchBadge),e._filterAutoExpanded&&e.expanded&&e.setExpanded(!1,{noAnimation:!0,noEvents:!0,scrollIntoView:!1}),delete e._filterAutoExpanded})),e.filterMode=null,this.lastFilterArgs=null,e.element.classList.remove("wb-ext-filter-dim","wb-ext-filter-hide"),e.enableUpdate(!0)}}function _markFuzzyMatchedChars(e,t,i=!0){let s=[];for(let e=1;e<t.length;e++){let i=t[e].length+(1===e?0:1)+(s[s.length-1]||0);s.push(i)}let n=e.split("");return i?s.forEach((function(e){n[e]="￷"+n[e]+"￸"})):s.forEach((function(e){n[e]="<mark>"+n[e]+"</mark>"})),n.join("")}
/*!
 * Wunderbaum - ext-keynav
 * Copyright (c) 2021-2023, Martin Wendt. Released under the MIT license.
 * v0.3.3, Wed, 07 Jun 2023 06:41:26 GMT (https://github.com/mar10/wunderbaum)
 */const QUICKSEARCH_DELAY=500;class KeynavExtension extends WunderbaumExtension{constructor(e){super(e,"keynav",{})}_getEmbeddedInputElem(e){var t;let i=null;if(e&&null!=e.type)i=e;else{const e=null===(t=this.tree.getActiveColElem())||void 0===t?void 0:t.querySelector("input,select");e&&(i=e)}return i}_isCurInputFocused(){var e;return!!(null===(e=this.tree.getActiveColElem())||void 0===e?void 0:e.querySelector("input:focus,select:focus"))}onKeyEvent(e){const t=e.event,i=this.tree,s=e.options,n=!t.ctrlKey||s.autoActivate,r=this._getEmbeddedInputElem(t.target),o=r&&this._isCurInputFocused(),l=s.navigationModeOption;let a,d=eventToString(t),c=e.node,h=!0;if(!i.isEnabled())return!1;if(!1===i._callEvent("keydown",e))return!1;if(!1===i._callMethod("edit._preprocessKeyEvent",e))return!1;if(!c){const e=i.getFocusNode()||i.getActiveNode(),t=i.getFirstChild();if(!e&&t&&"ArrowDown"===d)return t.logInfo("Keydown: activate first node."),void t.setActive();a=e||t,a&&(a.setFocus(),c=i.getFocusNode(),c.logInfo("Keydown: force focus on active node."))}const u=c.isColspan();if(i.isRowNav()){if(o){switch(d){case"Enter":r.blur(),i.setFocus();break;case"Escape":c.render(),i.setFocus()}return}if(s.quicksearch&&1===d.length&&/^\w$/.test(d)&&!r){const e=Date.now();e-i.lastQuicksearchTime>500&&(i.lastQuicksearchTerm=""),i.lastQuicksearchTime=e,i.lastQuicksearchTerm+=d;let s=i.findNextNode(i.lastQuicksearchTerm,i.getActiveNode());return s&&s.setActive(!0,{event:t}),void t.preventDefault()}switch(d){case"Enter":c.isActive()&&(c.isExpanded()?d="Subtract":c.isExpandable(!0)&&(d="Add"));break;case"ArrowLeft":c.expanded&&(d="Subtract");break;case"ArrowRight":if(!c.expanded&&c.isExpandable(!0))d="Add";else if(l===NavModeEnum.startCell||l===NavModeEnum.startRow)return t.preventDefault(),i.setCellNav(),!1}switch(d){case"+":case"Add":c.setExpanded(!0);break;case"-":case"Subtract":c.setExpanded(!1);break;case" ":c.getOption("checkbox")?c.setSelected(!c.isSelected()):c.setActive(!0,{event:t});break;case"Enter":c.setActive(!0,{event:t});break;case"ArrowDown":case"ArrowLeft":case"ArrowRight":case"ArrowUp":case"Backspace":case"End":case"Home":case"Control+End":case"Control+Home":case"Meta+ArrowDown":case"Meta+ArrowUp":case"PageDown":case"PageUp":c.navigate(d,{activate:n,event:t});break;default:h=!1}}else{const e=this._getEmbeddedInputElem(null),s=e?e.type||e.tagName:"",r=e&&this._isCurInputFocused(),o=e&&"checkbox"!==s;if(r){if("Escape"===d)return c.render(),c.logDebug("Reset focused input"),i.setFocus(),void i.setColumn(i.activeColIdx);if("Enter"!==d)return void c.logDebug(`Ignored ${d} inside focused input`)}else if(e&&1===d.length&&o)return e.focus(),e.value="",c.logDebug(`Focus imput: ${d}`),!1;switch("Tab"===d?(d="ArrowRight",h=!0):"Shift+Tab"===d&&(d=i.activeColIdx>0?"ArrowLeft":"",h=!0),d){case"+":case"Add":c.setExpanded(!0);break;case"-":case"Subtract":c.setExpanded(!1);break;case" ":0===i.activeColIdx&&c.getOption("checkbox")?(c.setSelected(!c.isSelected()),h=!0):e&&"checkbox"===s&&(e.click(),h=!0);break;case"F2":e&&!r&&o&&(e.focus(),h=!0);break;case"Enter":i.setFocus(),(0===i.activeColIdx||u)&&c.isExpandable()?(c.setExpanded(!c.isExpanded()),h=!0):e&&!r&&o&&(e.focus(),h=!0);break;case"Escape":i.setFocus(),c.log("keynav: focus tree..."),i.isCellNav()&&l!==NavModeEnum.cell&&(c.log("keynav: setCellNav(false)"),i.setCellNav(!1),i.setFocus(),h=!0);break;case"ArrowLeft":i.setFocus(),u&&c.isExpanded()?c.setExpanded(!1):!u&&i.activeColIdx>0?i.setColumn(i.activeColIdx-1):l!==NavModeEnum.cell&&i.setCellNav(!1),h=!0;break;case"ArrowRight":i.setFocus(),u&&!c.isExpanded()?c.setExpanded():!u&&i.activeColIdx<i.columns.length-1&&i.setColumn(i.activeColIdx+1),h=!0;break;case"Home":i.setFocus(),!u&&i.activeColIdx>0&&i.setColumn(0),h=!0;break;case"End":i.setFocus(),!u&&i.activeColIdx<i.columns.length-1&&i.setColumn(i.columns.length-1),h=!0;break;case"ArrowDown":case"ArrowUp":case"Backspace":case"Control+End":case"Control+Home":case"Meta+ArrowDown":case"Meta+ArrowUp":case"PageDown":case"PageUp":c.navigate(d,{activate:n,event:t}),h=!0;break;default:h=!1}}h&&t.preventDefault()}}
/*!
 * Wunderbaum - ext-logger
 * Copyright (c) 2021-2023, Martin Wendt. Released under the MIT license.
 * v0.3.3, Wed, 07 Jun 2023 06:41:26 GMT (https://github.com/mar10/wunderbaum)
 */class LoggerExtension extends WunderbaumExtension{constructor(e){super(e,"logger",{}),this.ignoreEvents=new Set(["enhanceTitle","render","discard"]),this.prefix=e+".ext-logger"}init(){const e=this.tree;if(e.getOption("debugLevel")>=4){const t=this.ignoreEvents,i=this.prefix;overrideMethod(e,"callEvent",(function(s,n){if(t.has(s))return e._superApply(arguments);const r=Date.now(),o=e._superApply(arguments);return console.debug(`${i}: callEvent('${s}') took ${Date.now()-r} ms.`,arguments[1]),o}))}}onKeyEvent(e){console.debug(`${this.prefix}: onKeyEvent()`,e)}}
/*!
 * Wunderbaum - common
 * Copyright (c) 2021-2023, Martin Wendt. Released under the MIT license.
 * v0.3.3, Wed, 07 Jun 2023 06:41:26 GMT (https://github.com/mar10/wunderbaum)
 */const DEFAULT_DEBUGLEVEL=4,ROW_HEIGHT=22,ICON_WIDTH=20,TITLE_SPAN_PAD_Y=7,RENDER_MAX_PREFETCH=5,TEST_IMG=new RegExp(/\.|\//),iconMap={error:"bi bi-exclamation-triangle",loading:"bi bi-chevron-right wb-busy",noData:"bi bi-question-circle",expanderExpanded:"bi bi-chevron-down",expanderCollapsed:"bi bi-chevron-right",expanderLazy:"bi bi-chevron-right wb-helper-lazy-expander",checkChecked:"bi bi-check-square",checkUnchecked:"bi bi-square",checkUnknown:"bi dash-square-dotted",radioChecked:"bi bi-circle-fill",radioUnchecked:"bi bi-circle",radioUnknown:"bi bi-circle-dotted",folder:"bi bi-folder2",folderOpen:"bi bi-folder2-open",folderLazy:"bi bi-folder-symlink",doc:"bi bi-file-earmark"},RESERVED_TREE_SOURCE_KEYS=new Set(["_format","_keyMap","_positional","_typeList","_version","children","columns","types"]),KEY_TO_ACTION_DICT={" ":"toggleSelect","+":"expand",Add:"expand",ArrowDown:"down",ArrowLeft:"left",ArrowRight:"right",ArrowUp:"up",Backspace:"parent","/":"collapseAll",Divide:"collapseAll",End:"lastCol",Home:"firstCol","Control+End":"last","Control+Home":"first","Meta+ArrowDown":"last","Meta+ArrowUp":"first","*":"expandAll",Multiply:"expandAll",PageDown:"pageDown",PageUp:"pageUp","-":"collapse",Subtract:"collapse"};function makeNodeTitleMatcher(e){return e instanceof RegExp?function(t){return e.test(t.title)}:(assert("string"==typeof e),function(t){return t.title===e})}function makeNodeTitleStartMatcher(e){e=escapeRegex(e);const t=new RegExp("^"+e,"i");return function(e){return t.test(e.title)}}function nodeTitleSorter(e,t){const i=e.title.toLowerCase(),s=t.title.toLowerCase();return i===s?0:i>s?1:-1}function unflattenSource(e){var t,i,s;const{_format:n,_keyMap:r,_positional:o,children:l}=e;if("flat"!==n)throw new Error(`Expected source._format: "flat", but got ${n}`);if(o&&o.includes("children"))throw new Error(`source._positional must not include "children": ${o}`);let a={};if(r)for(const[e,t]of Object.entries(r))a[t]=e;const d=o.map((e=>a[e])),c=[],h={},u={},p=null!==(t=a.key)&&void 0!==t?t:"key",f=null!==(i=a.children)&&void 0!==i?i:"children";for(const[e,t]of l.entries()){const[i,n,r={}]=t;t[1]=null,null!=t[2]&&(t[2]=null),n.forEach(((e,t)=>{r[d[t]]=e})),u[e]=r;const o=r[p];null!=o&&(h[o]=r);let l=null;if(null===i);else if("number"==typeof i){if(l=u[i],void 0===l)throw new Error(`unflattenSource: Could not find parent node by index: ${i}.`)}else if(l=h[i],void 0===l)throw new Error(`unflattenSource: Could not find parent node by key: ${i}`);l?(null!==(s=l[f])&&void 0!==s||(l[f]=[]),l[f].push(r)):c.push(r)}delete e.children,e.children=c}function inflateSourceData(e){const{_format:t,_keyMap:i,_typeList:s}=e;"flat"===t&&unflattenSource(e),delete e._format,delete e._version,delete e._keyMap,delete e._typeList,delete e._positional,function e(t){for(let n of t){i&&Object.getOwnPropertyNames(n).forEach((e=>{var t;const s=null!==(t=i[e])&&void 0!==t?t:e;s!==e&&(n[s]=n[e],delete n[e])}));const t=n.type;if(s&&null!=t&&"number"==typeof t){const e=s[t];if(null==e)throw new Error(`Expected typeList[${t}] entry in [${s}]`);n.type=e}n.children&&e(n.children)}}(e.children)}
/*!
 * Wunderbaum - ext-dnd
 * Copyright (c) 2021-2023, Martin Wendt. Released under the MIT license.
 * v0.3.3, Wed, 07 Jun 2023 06:41:26 GMT (https://github.com/mar10/wunderbaum)
 */const nodeMimeType="application/x-wunderbaum-node";class DndExtension extends WunderbaumExtension{constructor(e){super(e,"dnd",{autoExpandMS:1500,multiSource:!1,effectAllowed:"all",dropEffectDefault:"move",preventForeignNodes:!1,preventLazyParents:!0,preventNonNodes:!1,preventRecursion:!0,preventSameParent:!1,preventVoidMoves:!0,scroll:!0,scrollSensitivity:20,scrollSpeed:5,sourceCopyHook:null,dragStart:null,dragDrag:null,dragEnd:null,dragEnter:null,dragOver:null,dragExpand:null,dragDrop:null,dragLeave:null}),this.srcNode=null,this.lastTargetNode=null,this.lastEnterStamp=0,this.lastAllowedDropRegions=null,this.lastDropEffect=null,this.lastDropRegion=!1}init(){super.init();const e=this.tree,t=e.options.dnd;t.dragStart&&onEvent(e.element,"dragstart drag dragend",this.onDragEvent.bind(this)),t.dragEnter&&onEvent(e.element,"dragenter dragover dragleave drop",this.onDropEvent.bind(this))}_leaveNode(){const e=this.lastTargetNode;this.lastEnterStamp=0,e&&(e.setClass("wb-drop-target wb-drop-over wb-drop-after wb-drop-before",!1),this.lastTargetNode=null)}unifyDragover(e){if(!1===e)return!1;if(e instanceof Set)return e.size>0&&e;if(!0===e)return new Set(["over","before","after"]);if("string"==typeof e||isArray(e))return(e=toSet(e)).size>0&&e;throw new Error("Unsupported drop region definition: "+e)}_calcDropRegion(e,t){const i=e.offsetY;return!!t&&(3===t.size?i<5.5?"before":i>16.5?"after":"over":1===t.size&&t.has("over")?"over":i>11?"after":"before")}autoScroll(e){let t=this.tree,i=t.options.dnd,s=t.listContainerElement,n=i.scrollSensitivity,r=i.scrollSpeed,o=0;const l=s.offsetTop;if(l+s.offsetHeight-e.pageY<n){s.scrollHeight-s.clientHeight-l>0&&(s.scrollTop=o=l+r)}else l>0&&e.pageY-l<n&&(s.scrollTop=o=l-r);return o}onDragEvent(e){const t=this.treeOpts.dnd,i=Wunderbaum.getNode(e);if(i){if("drag"!==e.type&&this.tree.logDebug("onDragEvent."+e.type+", srcNode: "+i,e),"dragstart"===e.type){if(e.dataTransfer.effectAllowed=t.effectAllowed,i.isEditing())return i.logDebug("Prevented dragging node in edit mode."),e.preventDefault(),!1;if(!i._callEvent("dnd.dragStart",{event:e}))return e.preventDefault(),!1;let s=i.toDict(!0,(e=>{e._org_key=e.key,delete e.key}));s.treeId=i.tree.id;const n=JSON.stringify(s);e.dataTransfer.setData(nodeMimeType,n),e.dataTransfer.setData("text/plain",i.title),this.srcNode=i,setTimeout((()=>{i.setClass("wb-drag-source")}),0)}else"drag"===e.type||"dragend"===e.type&&(i.setClass("wb-drag-source",!1),this.srcNode=null,this.lastTargetNode&&this._leaveNode());return!0}}onDropEvent(e){const t=this.srcNode,i=t?t.tree:null,s=Wunderbaum.getNode(e),n=this.treeOpts.dnd,r=e.dataTransfer;if(s){if(["dragenter","dragover","dragleave"].includes(e.type)||this.tree.logDebug("onDropEvent."+e.type+" targetNode: "+s+", ea: "+(null==r?void 0:r.effectAllowed)+", de: "+(null==r?void 0:r.dropEffect),", cy: "+e.offsetY,", r: "+this._calcDropRegion(e,this.lastAllowedDropRegions),e),"dragenter"===e.type){if(this.lastAllowedDropRegions=null,this.lastTargetNode&&this.lastTargetNode!==s&&this._leaveNode(),this.lastTargetNode=s,this.lastEnterStamp=Date.now(),s.isStatusNode()||n.preventForeignNodes&&s.tree!==i||n.preventLazyParents&&!s.isLoaded()||n.preventNonNodes&&!t||n.preventRecursion&&t&&t.isAncestorOf(s)||n.preventSameParent&&t&&s.parent===t.parent||n.preventVoidMoves&&s===t)return r.dropEffect="none",!0;let o=s._callEvent("dnd.dragEnter",{event:e});return o=this.unifyDragover(o),o?(this.lastAllowedDropRegions=o,this.lastDropEffect=r.dropEffect,s.setClass("wb-drop-target"),e.preventDefault(),!1):(r.dropEffect="none",!0)}if("dragover"===e.type){this.autoScroll(e);const t=this._calcDropRegion(e,this.lastAllowedDropRegions);if(this.lastDropRegion=t,n.autoExpandMS>0&&s.isExpandable(!0)&&!s._isLoading&&Date.now()-this.lastEnterStamp>n.autoExpandMS&&!1!==s._callEvent("dnd.dragExpand",{event:e})&&s.setExpanded(),!t)return;return s.setClass("wb-drop-over","over"===t),s.setClass("wb-drop-before","before"===t),s.setClass("wb-drop-after","after"===t),e.preventDefault(),!1}if("dragleave"===e.type);else if("drop"===e.type){e.stopPropagation(),this._leaveNode();const t=this.lastDropRegion;s._callEvent("dnd.drop",{event:e,region:t,defaultDropMode:"over"===t?"appendChild":t,sourceNode:this.srcNode})}}else this._leaveNode()}}
/*!
 * Wunderbaum - drag_observer
 * Copyright (c) 2021-2023, Martin Wendt. Released under the MIT license.
 * v0.3.3, Wed, 07 Jun 2023 06:41:26 GMT (https://github.com/mar10/wunderbaum)
 */class DragObserver{constructor(e){if(this.start={x:0,y:0,altKey:!1,ctrlKey:!1,metaKey:!1,shiftKey:!1},this.dragElem=null,this.dragging=!1,this.events=["mousedown","mouseup","mousemove","keydown"],!e.root)throw new Error("Missing `root` option.");this.opts=Object.assign({thresh:5},e),this.root=e.root,this._handler=this.handleEvent.bind(this),this.events.forEach((e=>{this.root.addEventListener(e,this._handler)}))}disconnect(){this.events.forEach((e=>{this.root.removeEventListener(e,this._handler)}))}getDragElem(){return this.dragElem}isDragging(){return this.dragging}stopDrag(e){this.dragging&&this.opts.dragstop&&e&&(e.type="dragstop",this.opts.dragstop(e)),this.dragElem=null,this.dragging=!1}handleEvent(e){const t=e.type,i=this.opts,s={type:e.type,event:e,dragElem:this.dragElem,dx:e.pageX-this.start.x,dy:e.pageY-this.start.y,apply:void 0};switch(t){case"keydown":this.stopDrag(s);break;case"mousedown":if(this.dragElem){this.stopDrag(s);break}if(i.selector){let t=e.target;if(t.matches(i.selector))this.dragElem=t;else{if(t=t.closest(i.selector),!t)break;this.dragElem=t}}this.start.x=e.pageX,this.start.y=e.pageY,this.start.altKey=e.altKey,this.start.ctrlKey=e.ctrlKey,this.start.metaKey=e.metaKey,this.start.shiftKey=e.shiftKey;break;case"mousemove":if(!this.dragElem)break;if(!this.dragging){if(i.thresh){if(s.dx*s.dx+s.dy*s.dy<i.thresh*i.thresh)break}if(s.type="dragstart",!1===i.dragstart(s)){this.stopDrag(s);break}this.dragging=!0}this.dragging&&this.opts.drag&&(s.type="drag",this.opts.drag(s));break;case"mouseup":if(!this.dragging){this.stopDrag(s);break}0===e.button?s.apply=!0:s.apply=!1,this.stopDrag(s)}}}
/*!
 * Wunderbaum - ext-grid
 * Copyright (c) 2021-2023, Martin Wendt. Released under the MIT license.
 * v0.3.3, Wed, 07 Jun 2023 06:41:26 GMT (https://github.com/mar10/wunderbaum)
 */class GridExtension extends WunderbaumExtension{constructor(e){super(e,"grid",{}),this.observer=new DragObserver({root:window.document,selector:"span.wb-col-resizer",thresh:4,dragstart:e=>this.tree.element.contains(e.dragElem),drag:e=>this.handleDrag(e),dragstop:e=>this.handleDrag(e)})}init(){super.init()}handleDrag(e){const t=Wunderbaum.getEventInfo(e.event);this.tree.log(`${e.type}(${e.dx})`,e,t)}}
/*!
 * Wunderbaum - deferred
 * Copyright (c) 2021-2023, Martin Wendt. Released under the MIT license.
 * v0.3.3, Wed, 07 Jun 2023 06:41:26 GMT (https://github.com/mar10/wunderbaum)
 */class Deferred{constructor(){this._promise=new Promise(((e,t)=>{this._resolve=e,this._reject=t}))}resolve(e){this._resolve(e)}reject(e){this._reject(e)}promise(){return this._promise}then(e){return this._promise.then(e)}catch(e){return this._promise.catch(e)}finally(e){return this._promise.finally(e)}}
/*!
 * Wunderbaum - wunderbaum_node
 * Copyright (c) 2021-2023, Martin Wendt. Released under the MIT license.
 * v0.3.3, Wed, 07 Jun 2023 06:41:26 GMT (https://github.com/mar10/wunderbaum)
 */const NODE_PROPS=new Set(["classes","expanded","icon","key","lazy","refKey","selected","title","tooltip","type"]),NODE_ATTRS=new Set(["checkbox","expanded","classes","folder","icon","iconTooltip","key","lazy","partsel","radiogroup","refKey","selected","statusNodeType","title","tooltip","type","unselectable","unselectableIgnore","unselectableStatus"]);class WunderbaumNode{constructor(e,t,i){var s,n;this.refKey=void 0,this.children=null,this.lazy=!1,this.expanded=!1,this.selected=!1,this.classes=null,this.data={},this._isLoading=!1,this._requestId=0,this._errorInfo=null,this._partsel=!1,this._partload=!1,this.subMatchCount=0,this._rowIdx=0,this._rowElem=void 0,assert(!t||t.tree===e),assert(!i.children),this.tree=e,this.parent=t,this.key=""+(null!==(s=i.key)&&void 0!==s?s:++WunderbaumNode.sequence),this.title=""+(null!==(n=i.title)&&void 0!==n?n:"<"+this.key+">"),null!=i.refKey&&(this.refKey=""+i.refKey),null!=i.statusNodeType&&(this.statusNodeType=""+i.statusNodeType),null!=i.type&&(this.type=""+i.type),null!=i.checkbox&&(this.checkbox=!!i.checkbox),null!=i.colspan&&(this.colspan=!!i.colspan),this.expanded=!0===i.expanded,null!=i.icon&&(this.icon=i.icon),this.lazy=!0===i.lazy,this.selected=!0===i.selected,i.classes&&this.setClass(i.classes);for(const[e,t]of Object.entries(i))NODE_PROPS.has(e)||(this.data[e]=t);t&&!this.statusNodeType&&e._registerNode(this)}toString(){return`WunderbaumNode@${this.key}<'${this.title}'>`}*[Symbol.iterator](){const e=this.children;if(e)for(let t=0,i=e.length;t<i;t++){const i=e[t];yield i,i.children&&(yield*i)}}_callEvent(e,t){return this.tree._callEvent(e,extend({node:this,typeInfo:this.type?this.tree.types[this.type]:{}},t))}addChildren(e,t){const i=this.tree;let{before:s=null,applyMinExpanLevel:n=!0,_level:r}=null!=t?t:{};null!=r||(r=this.getLevel());const o=[];try{i.enableUpdate(!1),isPlainObject(e)&&(e=[e]);const t=n&&r<i.options.minExpandLevel;for(let s of e){const e=s.children;delete s.children;const n=new WunderbaumNode(i,this,s);t&&!n.isUnloaded()&&(n.expanded=!0),o.push(n),e&&n.addChildren(e,{_level:r+1})}if(this.children)if(null==s||0===this.children.length)this.children=this.children.concat(o);else{s=this.findDirectChild(s);let e=this.children.indexOf(s);assert(e>=0,`options.before must be a direct child of ${this}`),this.children.splice(e,0,...o)}else this.children=o;i.setModified(ChangeType.structure)}finally{i.enableUpdate(!0)}return o[0]}addNode(e,t="appendChild"){switch("over"===t&&(t="appendChild"),t){case"after":return this.parent.addChildren(e,{before:this.getNextSibling()});case"before":return this.parent.addChildren(e,{before:this});case"prependChild":return this.addChildren(e,{before:0});case"appendChild":return this.addChildren(e)}assert(!1,"Invalid mode: "+t)}applyCommand(e,t){return this.tree.applyCommand(e,this,t)}setClass(e,t=!0){const i=toSet(e);if(t)null===this.classes&&(this.classes=new Set),i.forEach((e=>{var i;this.classes.add(e),null===(i=this._rowElem)||void 0===i||i.classList.toggle(e,t)}));else{if(null===this.classes)return;i.forEach((e=>{var i;this.classes.delete(e),null===(i=this._rowElem)||void 0===i||i.classList.toggle(e,t)})),0===this.classes.size&&(this.classes=null)}}async expandAll(e=!0,t){const i=this.tree,s=this.tree.options.minExpandLevel;let{depth:n=99,loadLazy:r,force:o}=null!=t?t:{};const l={scrollIntoView:!1,force:o,loadLazy:r};const a=i.logTime(`${this}.expandAll(${e})`);try{i.enableUpdate(!1),await async function t(i,n){var a;if(0===n)return;const d=null==n?null:n-1,c=[];return null===(a=i.children)||void 0===a||a.forEach((i=>{if(e)if(!i.expanded&&(i.children||r&&i.lazy)){const e=i.setExpanded(!0,l);c.push(e),e.then((async()=>{await t(i,d)}))}else c.push(t(i,d));else(!s||o||i.getLevel()>s)&&i.setExpanded(!1,l),t(i,d)})),new Promise((e=>{Promise.all(c).then((()=>{e(!0)}))}))}(this,n)}finally{i.enableUpdate(!0),i.logTimeEnd(a)}}findAll(e){const t="function"==typeof e?e:makeNodeTitleMatcher(e),i=[];return this.visit((e=>{t(e)&&i.push(e)})),i}findDirectChild(e){let t=this.children;if(!t)return null;if("string"==typeof e){for(let i=0,s=t.length;i<s;i++)if(t[i].key===e)return t[i]}else{if("number"==typeof e)return t[e];if(e.parent===this)return e}return null}findFirst(e){const t="function"==typeof e?e:makeNodeTitleMatcher(e);let i=null;return this.visit((e=>{if(t(e))return i=e,!1})),i}findRelatedNode(e,t=!1){return this.tree.findRelatedNode(this,e,t)}*format_iter(e,t){function i(e){const t=e.parent.children;return e===t[t.length-1]}null!=t||(t=["    "," |  "," ╰─ "," ├─ "]),null!=e||(e=e=>""+e);const s=s=>{const n=[e(s)];n.unshift(t[i(s)?2:3]);let r=s.parent;for(;r&&r!==this;)n.unshift(t[i(r)?0:1]),r=r.parent;return n.join("")};yield e(this);for(let e of this)yield s(e)}format(e,t){const i=[];for(let s of this.format_iter(e,t))i.push(s);return i.join("\n")}getColElem(e){var t;"string"==typeof e&&(e=this.tree.columns.findIndex((t=>t.id===e)));const i=null===(t=this._rowElem)||void 0===t?void 0:t.querySelectorAll("span.wb-col");return i?i[e]:null}getFirstChild(){return this.children?this.children[0]:null}getLastChild(){return this.children?this.children[this.children.length-1]:null}getLevel(){let e=0,t=this.parent;for(;t;)e++,t=t.parent;return e}getNextSibling(){let e=this.parent.children,t=e.indexOf(this);return e[t+1]||null}getParent(){return this.parent}getParentList(e=!1,t=!1){let i=[],s=t?this:this.parent;for(;s;)(e||s.parent)&&i.unshift(s),s=s.parent;return i}getPath(e=!0,t="title",i="/"){let s,n=[],r="function"==typeof t;return this.visitParents((e=>{e.parent&&(s=r?t(e):e[t],n.unshift(s))}),e),n.join(i)}getPrevSibling(){let e=this.parent.children,t=e.indexOf(this);return e[t-1]||null}hasChildren(){if(this.lazy){if(null==this.children)return;if(0===this.children.length)return!1;if(1===this.children.length&&this.children[0].isStatusNode())return;return!0}return!(!this.children||!this.children.length)}hasClass(e){return!!this.classes&&this.classes.has(e)}isActive(){return this.tree.activeNode===this}isAncestorOf(e){return e&&e.isDescendantOf(this)}isChildOf(e){return e&&this.parent===e}isColspan(){return!!this.getOption("colspan")}isDescendantOf(e){if(!e||e.tree!==this.tree)return!1;for(var t=this.parent;t;){if(t===e)return!0;t===t.parent&&error(`Recursive parent link: ${t}`),t=t.parent}return!1}isExpandable(e=!1){return!(e&&this.expanded||!1===this.children)&&(null==this.children?this.lazy:0!==this.children.length||!!this.tree.options.emptyChildListExpandable)}isEditing(){return this.tree._callMethod("edit.isEditingTitle",this)}isExpanded(){return!!this.expanded}isFirstSibling(){var e=this.parent;return!e||e.children[0]===this}isLastSibling(){var e=this.parent;return!e||e.children[e.children.length-1]===this}isLazy(){return!!this.lazy}isLoaded(){return!this.lazy||void 0!==this.hasChildren()}isLoading(){return this._isLoading}isPagingNode(){return"paging"===this.statusNodeType}isParentOf(e){return e&&e.parent===this}isPartload(){return!!this._partload}isPartsel(){return!this.selected&&!!this._partsel}isRendered(){return!!this._rowElem}isRootNode(){return this.tree.root===this}isSelected(){return!!this.selected}isStatusNode(){return!!this.statusNodeType}isTopLevel(){return this.tree.root===this.parent}isUnloaded(){return void 0===this.hasChildren()}isVisible(){let e,t,i,s="hide"===this.tree.filterMode,n=this.getParentList(!1,!1);if(s&&!this.match&&!this.subMatchCount)return!1;for(e=0,t=n.length;e<t;e++)if(i=n[e],!i.expanded)return!1;return!0}_loadSourceObject(e,t){var i;const s=this.tree;null!=t||(t=this.getLevel());const n=this._callEvent("receive",{response:e});null!=n&&(e=n),isArray(e)&&(e={children:e}),assert(isPlainObject(e));const r=null!==(i=e.format)&&void 0!==i?i:"nested";assert("nested"===r||"flat"===r),inflateSourceData(e),assert(e.children,"If `source` is an object, it must have a `children` property"),e.types&&(s.logInfo("Redefine types",e.columns),s.setTypes(e.types,!1),delete e.types),e.columns&&(s.logInfo("Redefine columns",e.columns),s.columns=e.columns,delete e.columns,s.setModified(ChangeType.colStructure)),this.addChildren(e.children);for(const[t,i]of Object.entries(e))RESERVED_TREE_SOURCE_KEYS.has(t)||(s.data[t]=i,s.logDebug(`Add source.${t} to tree.data.${t}`));this._callEvent("load")}async _fetchWithOptions(e){var t,i;let s,n,r,o,l,a={};"string"==typeof e?(s=e,a.method="GET"):isPlainObject(e)?(({url:s,params:n,body:r,options:o,...l}=e),assert("string"==typeof s,"expected source.url as string"),isPlainObject(o)&&(a=o),isPlainObject(r)&&(assert(!a.body,"options.body should be passed as source.body"),a.body=JSON.stringify(a.body),null!==(t=a.method)&&void 0!==t||(a.method="POST")),isPlainObject(n)&&(s+="?"+new URLSearchParams(n),null!==(i=a.method)&&void 0!==i||(a.method="GET"))):(s="",error(`Unsupported source format: ${e}`)),this.setStatus(NodeStatusType.loading);const d=await fetch(s,a);return d.ok||error(`GET ${s} returned ${d.status}, ${d}`),await d.json()}async load(e){const t=this.tree,i=Date.now(),s=this.parent,n=Date.now();let r=0,o=0,l=0;this._requestId&&this.logWarn(`Recursive load request #${i} while #${this._requestId} is pending.`),this._requestId=i;try{if("string"==typeof e?e:e.url){const t=await this._fetchWithOptions(e);if(o=Date.now()-n,this._requestId&&this._requestId>i)return void this.logWarn(`Ignored load response #${i} because #${this._requestId} is pending.`);if(this.logDebug(`Received response for load request #${i}`),null===this.parent&&null!==s)return void this.logWarn("Lazy parent node was removed while loading: discarding response.");this.setStatus(NodeStatusType.ok);const r=Date.now();this._loadSourceObject(t),l=Date.now()-r}else this._loadSourceObject(e),l=Date.now()-n}catch(t){throw this.logError("Error during load()",e,t),this._callEvent("error",{error:t}),this.setStatus(NodeStatusType.error,{message:""+t}),t}finally{this._requestId=0,r=Date.now()-n,t.options.debugLevel>=3&&t.logInfo(`Load source took ${r/1e3} seconds (transfer: ${o/1e3}s, processing: ${l/1e3}s)`)}}async loadLazy(e=!1){const t=this.expanded;if(assert(this.lazy,"load() requires a lazy node"),e||this.isUnloaded()){this.isLoaded()&&this.resetLazy(),this.setStatus(NodeStatusType.loading);try{const e=await this._callEvent("lazyLoad");if(!1===e)return void this.setStatus(NodeStatusType.ok);assert(isArray(e)||e&&e.url,"The lazyLoad event must return a node list, `{url: ...}`, or false."),await this.load(e),t?(this.expanded=!0,this.tree.setModified(ChangeType.structure)):this.setModified()}catch(e){this.logError("Error during loadLazy()",e),this._callEvent("error",{error:e}),this.setStatus(NodeStatusType.error,{message:""+e})}}}log(...e){this.logDebug.apply(this,e)}logDebug(...e){this.tree.options.debugLevel>=4&&(Array.prototype.unshift.call(e,this.toString()),console.log.apply(console,e))}logError(...e){this.tree.options.debugLevel>=1&&(Array.prototype.unshift.call(e,this.toString()),console.error.apply(console,e))}logInfo(...e){this.tree.options.debugLevel>=3&&(Array.prototype.unshift.call(e,this.toString()),console.info.apply(console,e))}logWarn(...e){this.tree.options.debugLevel>=2&&(Array.prototype.unshift.call(e,this.toString()),console.warn.apply(console,e))}async makeVisible(e){let t,i=new Deferred,s=[],n=this.getParentList(!1,!1),r=n.length,o=getOption(e,"noAnimation",!1),l=getOption(e,"scrollIntoView",!0);for(t=r-1;t>=0;t--){const e={noAnimation:o};s.push(n[t].setExpanded(!0,e))}return Promise.all(s).then((()=>{l&&this.tree?(this.tree.updatePendingModifications(),this.scrollIntoView().then((()=>{i.resolve()}))):i.resolve()})),i.promise()}moveTo(e,t="appendChild",i){"over"===t&&(t="appendChild"),"prependChild"===t&&(e.children&&e.children.length?(t="before",e=e.children[0]):t="appendChild");let s,n=this.tree,r=this.parent,o="appendChild"===t?e:e.parent;if(this!==e){if(this.parent?o.isDescendantOf(this)&&error("Cannot move a node to its own descendant"):error("Cannot move system root"),o!==r&&r.triggerModifyChild("remove",this),1===this.parent.children.length){if(this.parent===o)return;this.parent.children=this.parent.lazy?[]:null,this.parent.expanded=!1}else s=this.parent.children.indexOf(this),assert(s>=0,"invalid source parent"),this.parent.children.splice(s,1);if(this.parent=o,o.hasChildren())switch(t){case"appendChild":o.children.push(this);break;case"before":s=o.children.indexOf(e),assert(s>=0,"invalid target parent"),o.children.splice(s,0,this);break;case"after":s=o.children.indexOf(e),assert(s>=0,"invalid target parent"),o.children.splice(s+1,0,this);break;default:error(`Invalid mode '${t}'.`)}else o.children=[this];i&&e.visit(i,!0),o===r?o.triggerModifyChild("move",this):o.triggerModifyChild("add",this),n!==e.tree&&(this.logWarn("Cross-tree moveTo is experimental!"),this.visit((function(t){t.tree=e.tree}),!0)),setTimeout((()=>{n.setModified(ChangeType.any)}),0)}}async navigate(e,t){e=KEY_TO_ACTION_DICT[e]||e;const i=this.findRelatedNode(e);if(!i)return this.logWarn(`Could not find related node '${e}'.`),Promise.resolve(this);try{i.makeVisible({scrollIntoView:!1})}catch(e){}return i.setFocus(),!1===(null==t?void 0:t.activate)?Promise.resolve(this):i.setActive(!0,{event:null==t?void 0:t.event})}remove(){const e=this.tree,t=this.parent.children.indexOf(this);this.triggerModify("remove"),this.parent.children.splice(t,1),this.visit((t=>{t.removeMarkup(),e._unregisterNode(t)}),!0),e.setModified(ChangeType.structure)}removeChildren(){const e=this.tree;this.children&&(e.activeNode&&e.activeNode.isDescendantOf(this)&&e.activeNode.setActive(!1),e.focusNode&&e.focusNode.isDescendantOf(this)&&(e.focusNode=null),this.triggerModifyChild("remove",null),this.visit((t=>{e._unregisterNode(t)})),this.lazy?this.children=[]:this.children=null,this.isRootNode()||(this.expanded=!1),this.tree.setModified(ChangeType.structure))}removeMarkup(){this._rowElem&&(delete this._rowElem._wb_node,this._rowElem.remove(),this._rowElem=void 0)}_getRenderInfo(){const e={},t={},i=this.isColspan(),s=this._rowElem?this._rowElem.querySelectorAll("span.wb-col"):null;let n=0;for(let r of this.tree.columns)e[r.id]={id:r.id,idx:n,elem:s?s[n]:null,info:r},i||"*"===r.id||(t[r.id]=e[r.id]),n++;return{allColInfosById:e,renderColInfosById:t}}_createIcon(e,t,i){let s,n=this.getOption("icon");return this._errorInfo?n=iconMap.error:this._isLoading&&i&&(n=iconMap.loading),!1===n?null:("string"==typeof n||(n=this.statusNodeType?iconMap[this.statusNodeType]:this.expanded?iconMap.folderOpen:this.children?iconMap.folder:this.lazy?iconMap.folderLazy:iconMap.doc),n?n.indexOf("<")>=0?s=elemFromHtml(n):TEST_IMG.test(n)?s=elemFromHtml(`<img src="${n}" class="wb-icon">`):(s=document.createElement("i"),s.className="wb-icon "+n):(s=document.createElement("i"),s.className="wb-icon"),t?e.replaceChild(s,t):e.appendChild(s),s)}_render_markup(e){const t=this.tree,i=t.options,s=!1!==this.getOption("checkbox"),n=t.columns,r=this.getLevel();let o,l,a,d,c=this._rowElem,h=null,u=null;const p=t.isRowNav()?null:t.activeColIdx,f=!c;assert(f),assert(!f||e&&e.after,"opts.after expected, unless updating"),assert(!this.isRootNode()),c=document.createElement("div"),c.classList.add("wb-row"),c.style.top=22*this._rowIdx+"px",this._rowElem=c,c._wb_node=this,l=document.createElement("span"),l.classList.add("wb-node","wb-col"),c.appendChild(l);let g=0;s&&(h=document.createElement("i"),h.classList.add("wb-checkbox"),l.appendChild(h),g+=20);for(let e=r-1;e>0;e--)o=document.createElement("i"),o.classList.add("wb-indent"),l.appendChild(o),g+=20;(!i.minExpandLevel||r>i.minExpandLevel)&&(u=document.createElement("i"),u.classList.add("wb-expander"),l.appendChild(u),g+=20),d=this._createIcon(l,null,!u),d&&(g+=20),a=document.createElement("span"),a.classList.add("wb-title"),l.appendChild(a),this._callEvent("enhanceTitle",{titleSpan:a}),l._ofsTitlePx=g,t.options.dnd.dragStart&&(l.draggable=!0);if(!this.isColspan()&&n.length>1){let e=0;for(let t of n){let i;e++,"*"===t.id?i=l:(i=document.createElement("span"),i.classList.add("wb-col"),c.appendChild(i)),e===p&&i.classList.add("wb-active"),t.classes&&i.classList.add(...t.classes.split(" ")),i.style.left=t._ofsPx+"px",i.style.width=t._widthPx+"px",f&&t.html&&"string"==typeof t.html&&(i.innerHTML=t.html)}}switch(e?e.after:"last"){case"first":t.nodeListElement.prepend(c);break;case"last":t.nodeListElement.appendChild(c);break;default:e.after.after(c)}e.isNew=!0,this._render_data(e)}_render_data(e){assert(this._rowElem);const t=this.tree,i=t.options,s=this._rowElem,n=!!e.isNew,r=!!e.preventScroll,o=t.columns,l=this.isColspan(),a=s.querySelector("span.wb-node"),d=a.querySelector("span.wb-title"),c=t.element.scrollTop;if(this.titleWithHighlight?d.innerHTML=this.titleWithHighlight:d.textContent=this.title,r&&(t.element.scrollTop=c),!i.skeleton)if(l){let e=t.element.clientWidth;d.style.width=e-a._ofsTitlePx-7+"px"}else d.style.width=o[0]._widthPx-a._ofsTitlePx-7+"px";if(e.isDataChange=!0,this._render_status(e),this.statusNodeType)this._callEvent("renderStatusNode",{isNew:n,nodeElem:a,isColspan:l});else if(this.parent){const e=this._getRenderInfo();this._callEvent("render",{isNew:n,nodeElem:a,isColspan:l,allColInfosById:e.allColInfosById,renderColInfosById:e.renderColInfosById})}}_render_status(e){const t=this.tree,i=t.options,s=this.type?t.types[this.type]:null,n=this._rowElem,r=n.querySelector("span.wb-node"),o=r.querySelector("i.wb-expander"),l=r.querySelector("i.wb-checkbox");let a=["wb-row"];if(this.expanded&&a.push("wb-expanded"),this.lazy&&a.push("wb-lazy"),this.selected&&a.push("wb-selected"),this===t.activeNode&&a.push("wb-active"),this===t.focusNode&&a.push("wb-focus"),this._errorInfo&&a.push("wb-error"),this._isLoading&&a.push("wb-loading"),this.isColspan()&&a.push("wb-colspan"),this.statusNodeType&&a.push("wb-status-"+this.statusNodeType),this.match&&a.push("wb-match"),this.subMatchCount&&a.push("wb-submatch"),i.skeleton&&a.push("wb-skeleton"),n.className=a.join(" "),this.classes&&n.classList.add(...this.classes),s&&s.classes&&n.classList.add(...s.classes),o&&(this._isLoading?o.className="wb-expander "+iconMap.loading:this.isExpandable(!1)?this.expanded?o.className="wb-expander "+iconMap.expanderExpanded:o.className="wb-expander "+iconMap.expanderCollapsed:this.lazy&&null==this.children?o.className="wb-expander "+iconMap.expanderLazy:o.classList.add("wb-indent")),l&&(this.selected?l.className="wb-checkbox "+iconMap.checkChecked:l.className="wb-checkbox "+iconMap.checkUnchecked),!e.isNew){let e=0;for(let i of n.children)i.classList.toggle("wb-active",e++===t.activeColIdx);const i=r.querySelector("i.wb-icon");i&&this._createIcon(r,i,!o)}if(!1!==e.resizeCols&&!this.isColspan()){const e=n.querySelectorAll("span.wb-col");let t=0,i=0;for(let s of this.tree.columns){const n=e[t];n.style.left=`${i}px`,n.style.width=`${s._widthPx}px`,t++,i+=s._widthPx}}}render(e){const t=Object.assign({change:ChangeType.data},e);switch(this._rowElem||(t.change=ChangeType.row),t.change){case"status":this._render_status(t);break;case"data":this._render_data(t);break;case"row":this._render_markup(t);break;default:error(`Invalid change type '${t.change}'.`)}}resetLazy(){this.removeChildren(),this.expanded=!1,this.lazy=!0,this.children=null,this.tree.setModified(ChangeType.structure)}toDict(e=!1,t){const i={};if(NODE_ATTRS.forEach((e=>{const t=this[e];t instanceof Set?t.size&&(i[e]=Array.prototype.join.call(t.keys()," ")):(t||!1===t||0===t)&&(i[e]=t)})),isEmptyObject(this.data)||(i.data=extend({},this.data),isEmptyObject(i.data)&&delete i.data),t){const s=t(i,this);if(!1===s)return!1;"skip"===s&&(e=!1)}if(e&&isArray(this.children)){i.children=[];for(let e=0,s=this.children.length;e<s;e++){const s=this.children[e];if(!s.isStatusNode()){const e=s.toDict(!0,t);!1!==e&&i.children.push(e)}}}return i}getOption(e,t){let i=this.tree,s=i.options;e.indexOf(".")>=0&&([s,e]=e.split("."));let n=s[e];if("function"==typeof n){let e=n.call(i,{type:"resolve",tree:i,node:this});if(void 0!==e)return e}if(void 0!==this[e])return this[e];let r=this.type?i.types[this.type]:void 0,o=r?r[e]:void 0;return void 0!==o?o:null!=n?n:t}async scrollIntoView(e){const t=Object.assign({node:this},e);return this.tree.scrollTo(t)}async setActive(e=!0,t){const i=this.tree,s=i.activeNode,n=null==t?void 0:t.retrigger,r=null==t?void 0:t.focusTree,o=!1!==(null==t?void 0:t.focusNode),l=null==t?void 0:t.noEvents,a=null==t?void 0:t.event;if(!l)if(e){if(s!==this||n){if(!1===(null==s?void 0:s._callEvent("deactivate",{nextNode:this,event:a}))||!1===this._callEvent("beforeActivate",{prevNode:s,event:a}))return;i.activeNode=null,null==s||s.setModified(ChangeType.status)}}else(s===this||n)&&this._callEvent("deactivate",{nextNode:null,event:a});return s!==this&&(e&&(i.activeNode=this,(o||r)&&(i.focusNode=this),r&&i.setFocus()),null==s||s.setModified(ChangeType.status),this.setModified(ChangeType.status)),t&&null!=t.colIdx&&t.colIdx!==i.activeColIdx&&i.isCellNav()&&i.setColumn(t.colIdx),e&&!l&&this._callEvent("activate",{prevNode:s,event:a}),this.makeVisible()}async setExpanded(e=!0,t){const{force:i,scrollIntoView:s,immediate:n}=null!=t?t:{};if(!e&&this.isExpanded()&&this.getLevel()<=this.tree.getOption("minExpandLevel")&&!i)return void this.logDebug("Ignored collapse request below expandLevel.");if(!e==!this.expanded)return;e&&this.lazy&&null==this.children&&await this.loadLazy(),this.expanded=e;const r={immediate:n};if(this.tree.setModified(ChangeType.structure,r),e&&!1!==s){const e=this.getLastChild();e&&(this.tree.updatePendingModifications(),e.scrollIntoView({topNode:this}))}}setFocus(e=!0){assert(!!e,"blur is not yet implemented");const t=this.tree.focusNode;this.tree.focusNode=this,null==t||t.setModified(),this.setModified()}setIcon(e){this.icon=e,this.setModified()}setKey(e,t){throw new Error("Not yet implemented")}setModified(e=ChangeType.data){assert(e===ChangeType.status||e===ChangeType.data),this.tree.setModified(e,this)}setSelected(e=!0,t){!!e!==this.selected&&this._callEvent("select",{flag:e}),this.selected=!!e,this.setModified()}setStatus(e,t){const i=this.tree,s=null==t?void 0:t.message,n=null==t?void 0:t.details;let r=null;const o=e=>{let t=this.children,s=t?t[0]:null;return assert(e.statusNodeType),assert(!s||!s.isStatusNode()),r=this.addNode(e,"prependChild"),r.match=!0,i.setModified(ChangeType.structure),r};switch((()=>{let e=this.children;e&&e.length&&e[0].isStatusNode()&&e[0].remove()})(),e){case"ok":this._isLoading=!1,this._errorInfo=null;break;case"loading":this._isLoading=!0,this._errorInfo=null,this.parent?this.setModified(ChangeType.status):o({statusNodeType:e,title:i.options.strings.loading+(s?" ("+s+")":""),checkbox:!1,colspan:!0,tooltip:n});break;case"error":o({statusNodeType:e,title:i.options.strings.loadError+(s?" ("+s+")":""),checkbox:!1,colspan:!0,tooltip:n}),this._isLoading=!1,this._errorInfo={message:s,details:n};break;case"noData":o({statusNodeType:e,title:s||i.options.strings.noData,checkbox:!1,colspan:!0,tooltip:n}),this._isLoading=!1,this._errorInfo=null;break;default:error("invalid node status "+e)}return i.setModified(ChangeType.structure),r}setTitle(e){this.title=e,this.setModified()}_sortChildren(e,t){const i=this.children;if(i&&(i.sort(e),t))for(let s=0,n=i.length;s<n;s++)i[s].children&&i[s]._sortChildren(e,t)}sortChildren(e=nodeTitleSorter,t=!1){this._sortChildren(e||nodeTitleSorter,t),this.tree.setModified(ChangeType.structure)}triggerModifyChild(e,t,i){this.logDebug(`modifyChild(${e})`,i,t),this.tree.options.modifyChild&&(t&&t.parent!==this&&error("child "+t+" is not a child of "+this),this._callEvent("modifyChild",extend({operation:e,child:t},i)))}triggerModify(e,t){this.parent.triggerModifyChild(e,this,t)}visit(e,t=!1){let i,s,n=!0,r=this.children;if(!0===t&&(n=e(this),!1===n||"skip"===n))return n;if(r)for(i=0,s=r.length;i<s&&(n=r[i].visit(e,!0),!1!==n);i++);return n}visitParents(e,t=!1){if(t&&!1===e(this))return!1;let i=this.parent;for(;i;){if(!1===e(i))return!1;i=i.parent}return!0}visitSiblings(e,t=!1){let i,s,n,r=this.parent.children;for(i=0,s=r.length;i<s;i++)if(n=r[i],(t||n!==this)&&!1===e(n))return!1;return!0}isMatched(){return!(this.tree.filterMode&&!this.match)}}WunderbaumNode.sequence=0;
/*!
 * Wunderbaum - ext-edit
 * Copyright (c) 2021-2023, Martin Wendt. Released under the MIT license.
 * v0.3.3, Wed, 07 Jun 2023 06:41:26 GMT (https://github.com/mar10/wunderbaum)
 */
class EditExtension extends WunderbaumExtension{constructor(e){super(e,"edit",{debounce:100,minlength:1,maxlength:null,trigger:[],trim:!0,select:!0,slowClickDelay:1e3,validity:!0,beforeEdit:null,edit:null,apply:null}),this.curEditNode=null,this.relatedNode=null,this.debouncedOnChange=debounce(this._onChange.bind(this),this.getPluginOption("debounce"))}_applyChange(e,t,i,s){let n;t.log(`_applyChange(${e})`,s),i.classList.add("wb-busy"),i.classList.remove("wb-error");try{n=t._callEvent(e,s)}catch(s){t.logError(`Error in ${e} event handler`,s),i.classList.add("wb-error"),i.classList.remove("wb-busy")}return n instanceof Promise||(n=Promise.resolve(n)),n.catch((s=>{t.logError(`Error in ${e} event promise`,s),i.classList.add("wb-error")})).finally((()=>{i.classList.remove("wb-busy")})),n}_onChange(e){const t=Wunderbaum.getEventInfo(e),i=t.node,s=t.colElem;i&&0!==t.colIdx?this._applyChange("change",i,s,{info:t,event:e,inputElem:e.target,inputValue:Wunderbaum.util.getValueFromElem(e.target)}):this.tree.log("Ignored change event for removed element or node title")}init(){super.init(),onEvent(this.tree.element,"change",".contenteditable,input,textarea,select",(e=>{this.debouncedOnChange(e)}))}_preprocessKeyEvent(e){const t=e.event,i=eventToString(t),s=this.tree,n=this.getPluginOption("trigger");if(this.isEditingTitle()){switch(i){case"Enter":return this._stopEditTitle(!0,{event:t}),!1;case"Escape":return this._stopEditTitle(!1,{event:t}),!1}return!1}if(s.isRowNav()||0===s.activeColIdx){switch(i){case"Enter":if(n.indexOf("macEnter")>=0&&isMac)return this.startEditTitle(),!1;break;case"F2":if(n.indexOf("F2")>=0)return this.startEditTitle(),!1}return!0}return!0}isEditingTitle(e){return e?this.curEditNode===e:!!this.curEditNode}startEditTitle(e){e=null!=e?e:this.tree.getActiveNode();const t=this.getPluginOption("validity"),i=this.getPluginOption("select");if(!e)return;this.tree.logDebug(`startEditTitle(node=${e})`);let s=e._callEvent("edit.beforeEdit");if(!1===s)return void e.logInfo("beforeEdit canceled operation.");if(!0===s||!s){s=`<input type=text class="wb-input-edit" tabindex=-1 value="${escapeHtml(e.title)}" required autocorrect=off>`}const n=e.getColElem(0).querySelector(".wb-title");n.innerHTML=s;const r=n.firstElementChild;t&&r.addEventListener("keydown",(e=>{r.setCustomValidity(""),r.reportValidity()})),r.focus(),i&&r.select(),this.curEditNode=e,e._callEvent("edit.edit",{inputElem:r})}stopEditTitle(e){return this._stopEditTitle(e,{})}_stopEditTitle(e,t){null!=t||(t={});const i=document.activeElement;let s=i?getValueFromElem(i):null;const n=this.curEditNode,r=!!t.forceClose,o=this.getPluginOption("validity");if(s&&this.getPluginOption("trim")&&(s=s.trim()),n)if(n.logDebug(`stopEditTitle(${e})`,t,i,s),e&&null!==s&&s!==n.title){const e=i.validationMessage;if(e)throw new Error(`Input validation failed for "${s}": ${e}.`);const t=n.getColElem(0);this._applyChange("edit.apply",n,t,{oldValue:n.title,newValue:s,inputElem:i}).then((e=>{const t=i.validationMessage;if(o&&t&&!1!==e)throw new Error(`Edit apply validation failed for "${s}": ${t}.`);(r||!1!==e)&&(null==n||n.setTitle(s),this.curEditNode.render({preventScroll:!0}),this.curEditNode=null,this.relatedNode=null,this.tree.setFocus())})).catch((e=>{n.logError(e)}))}else this.curEditNode.render({preventScroll:!0}),this.curEditNode=null,this.relatedNode=null,this.tree.setFocus();else this.tree.logDebug("stopEditTitle: not in edit mode.")}createNode(e="after",t,i){const s=this.tree;if(assert(t=null!=t?t:s.getActiveNode(),"No node was passed, or no node is currently active."),e=e||"prependChild",null==i?i={title:""}:"string"==typeof i?i={title:i}:assert(isPlainObject(i)),("prependChild"===e||"appendChild"===e)&&(null==t?void 0:t.isExpandable(!0)))return void t.setExpanded().then((()=>{this.createNode(e,t,i)}));const n=t.addNode(i,e);n.setClass("wb-edit-new"),this.relatedNode=t,n.match=!0,n.makeVisible({noAnimation:!0}).then((()=>{this.startEditTitle(n)}))}}
/*!
 * wunderbaum.ts
 *
 * A treegrid control.
 *
 * Copyright (c) 2021-2023, Martin Wendt (https://wwWendt.de).
 * https://github.com/mar10/wunderbaum
 *
 * Released under the MIT license.
 * @version v0.3.3
 * @date Wed, 07 Jun 2023 06:41:26 GMT
 */class WbSystemRoot extends WunderbaumNode{constructor(e){super(e,null,{key:"__root__",title:e.id})}toString(){return`WbSystemRoot@${this.key}<'${this.tree.id}'>`}}class Wunderbaum{constructor(e){this.enabled=!0,this.data={},this.extensionList=[],this.extensions={},this.keyMap=new Map,this.refKeyMap=new Map,this.treeRowCount=0,this._disableUpdateCount=0,this._disableUpdateIgnoreCount=0,this.activeNode=null,this.focusNode=null,this.types={},this.columns=[],this._columnsById={},this.pendingChangeTypes=new Set,this._util=util,this.filterMode=null,this.activeColIdx=0,this._cellNavMode=!1,this.lastQuicksearchTime=0,this.lastQuicksearchTerm="",this.lastClickTime=0,this.log=this.logDebug;let t=this.options=extend({id:null,source:null,element:null,debugLevel:4,header:null,rowHeightPx:22,columns:null,types:null,enabled:!0,fixedCol:!1,showSpinner:!1,checkbox:!1,minExpandLevel:0,emptyChildListExpandable:!1,updateThrottleWait:200,skeleton:!1,connectTopBreadcrumb:null,navigationModeOption:null,quicksearch:!0,change:noop,enhanceTitle:noop,error:noop,receive:noop,strings:{loadError:"Error",loading:"Loading...",noData:"No data"}},e);const i=new Deferred;this.ready=i.promise();let s=!1;if(this.ready.then((()=>{s=!0;try{this._callEvent("init")}catch(e){console.error("Exception inside `init(e)` event:",e)}})).catch((e=>{if(s)throw e;this._callEvent("init",{error:e})})),this.id=t.id||"wb_"+ ++Wunderbaum.sequence,this.root=new WbSystemRoot(this),this._registerExtension(new KeynavExtension(this)),this._registerExtension(new EditExtension(this)),this._registerExtension(new FilterExtension(this)),this._registerExtension(new DndExtension(this)),this._registerExtension(new GridExtension(this)),this._registerExtension(new LoggerExtension(this)),this._updateViewportThrottled=adaptiveThrottle(this._updateViewportImmediately.bind(this),{}),this.columns=t.columns,delete t.columns,!this.columns||!this.columns.length){const e="string"==typeof t.header?t.header:this.id;this.columns=[{id:"*",title:e,width:"*"}]}t.types&&this.setTypes(t.types,!0),delete t.types,this.element=elemFromSelector(t.element),assert(!!this.element,`Invalid 'element' option: ${t.element}`),this.element.classList.add("wunderbaum"),this.element.getAttribute("tabindex")||(this.element.tabIndex=0),this.element._wb_tree=this,this.headerElement=this.element.querySelector("div.wb-header");const n=null==t.header?this.columns.length>1:!!t.header;if(this.headerElement){assert(!this.columns,"`opts.columns` must not be set if markup already contains a header"),this.columns=[];const e=this.headerElement.querySelector("div.wb-row");for(const t of e.querySelectorAll("div"))this.columns.push({id:t.dataset.id||`col_${this.columns.length}`,title:""+t.textContent,width:"*"})}else{const e="<span class='wb-col'></span>".repeat(this.columns.length);if(this.element.innerHTML=`\n        <div class='wb-header'>\n          <div class='wb-row'>\n            ${e}\n          </div>\n        </div>`,!n){this.element.querySelector("div.wb-header").style.display="none"}}this.element.innerHTML+='\n      <div class="wb-list-container">\n        <div class="wb-node-list"></div>\n      </div>',this.listContainerElement=this.element.querySelector("div.wb-list-container"),this.nodeListElement=this.listContainerElement.querySelector("div.wb-node-list"),this.headerElement=this.element.querySelector("div.wb-header"),this.element.classList.toggle("wb-grid",this.columns.length>1),this._initExtensions(),["enabled","fixedCol"].forEach((e=>{null!=t[e]&&this.setOption(e,t[e])})),t.source?(t.showSpinner&&(this.nodeListElement.innerHTML="<progress class='spinner'>loading...</progress>"),this.load(t.source).then((()=>{null==t.navigationModeOption?this.isGrid()?this.setNavigationOption(NavModeEnum.cell):this.setNavigationOption(NavModeEnum.row):this.setNavigationOption(t.navigationModeOption),i.resolve()})).catch((e=>{i.reject(e)})).finally((()=>{var e;null===(e=this.element.querySelector("progress.spinner"))||void 0===e||e.remove(),this.element.classList.remove("wb-initializing")}))):i.resolve(),this.setModified(ChangeType.any),this.element.addEventListener("scroll",(e=>{this.setModified(ChangeType.scroll)})),this.resizeObserver=new ResizeObserver((e=>{this.setModified(ChangeType.resize)})),this.resizeObserver.observe(this.element),onEvent(this.nodeListElement,"click","div.wb-row",(e=>{const t=Wunderbaum.getEventInfo(e),i=t.node;if(!1===this._callEvent("click",{event:e,node:i,info:t}))return this.lastClickTime=Date.now(),!1;if(i){const s=this.getOption("edit.trigger"),n=this.getOption("edit.slowClickDelay");s.indexOf("clickActive")>=0&&"title"===t.region&&i.isActive()&&(!n||Date.now()-this.lastClickTime<n)&&this._callMethod("edit.startEditTitle",i),t.colIdx>=0?i.setActive(!0,{colIdx:t.colIdx,event:e}):i.setActive(!0,{event:e}),t.region===NodeRegion.expander?i.setExpanded(!i.isExpanded()):t.region===NodeRegion.checkbox&&i.setSelected(!i.isSelected())}this.lastClickTime=Date.now()})),onEvent(this.nodeListElement,"dblclick","div.wb-row",(e=>{const t=Wunderbaum.getEventInfo(e),i=t.node;if(!1===this._callEvent("dblclick",{event:e,node:i,info:t}))return!1;i&&0===t.colIdx&&i.isExpandable()&&(this._callMethod("edit._stopEditTitle"),i.setExpanded(!i.isExpanded()))})),onEvent(this.element,"keydown",(e=>{const t=Wunderbaum.getEventInfo(e),i=eventToString(e),s=t.node||this.getFocusNode();this._callHook("onKeyEvent",{event:e,node:s,info:t,eventName:i})})),onEvent(this.element,"focusin focusout",(e=>{const i="focusin"===e.type,s=Wunderbaum.getNode(e);this._callEvent("focus",{flag:i,event:e}),i&&this.isRowNav()&&!this.isEditing()&&(t.navigationModeOption===NavModeEnum.row?null==s||s.setActive():this.setCellNav()),i||this._callMethod("edit._stopEditTitle",!0,{event:e,forceClose:!0})}))}static getTree(e){if(e instanceof Wunderbaum)return e;if(e instanceof WunderbaumNode)return e.tree;if(void 0===e&&(e=0),"number"==typeof e)e=document.querySelectorAll(".wunderbaum")[e];else if("string"==typeof e){for(let t of document.querySelectorAll(".wunderbaum")){const i=t._wb_tree;if(i&&i.id===e)return i}if(!(e=document.querySelector(e)))return null}else e.target&&(e=e.target);return assert(e instanceof Element),e.matches(".wunderbaum")||(e=e.closest(".wunderbaum")),e&&e._wb_tree?e._wb_tree:null}static getNode(e){if(!e)return null;if(e instanceof WunderbaumNode)return e;for(void 0!==e.target&&(e=e.target);e;){if(e._wb_node)return e._wb_node;e=e.parentElement}return null}*[Symbol.iterator](){yield*this.root}_registerExtension(e){this.extensionList.push(e),this.extensions[e.id]=e}_initExtensions(){for(let e of this.extensionList)e.init()}_registerNode(e){const t=e.key;assert(null!=t&&!this.keyMap.has(t),`Missing or duplicate key: '${t}'.`),this.keyMap.set(t,e);let i=e.refKey;if(i){let t=this.refKeyMap.get(i);t?t.add(e):this.refKeyMap.set(i,new Set)}}_unregisterNode(e){const t=e.refKey;if(t){const i=this.refKeyMap.get(t);i&&i.delete(e)&&!i.size&&this.refKeyMap.delete(t)}e.tree=null,e.parent=null,e.removeMarkup()}_callHook(e,t={}){let i,s=extend({},{tree:this,options:this.options,result:void 0},t);for(let t of this.extensionList){if(i=t[e].call(t,s),!1===i)break;void 0!==s.result&&(i=s.result)}return i}_callMethod(e,...t){const[i,s]=e.split("."),n=s?this.extensions[i]:this,r=n[s];if(r)return r.apply(n,t);this.logError(`Calling undefined method '${e}()'.`)}_callEvent(e,t){const[i,s]=e.split("."),n=this.options,r=s?n[i][s]:n[i];if(r)return r.call(this,extend({type:e,tree:this,util:this._util},t))}_getNodeByRowIdx(e){let t=null;return this.visitRows((i=>{if(i._rowIdx===e)return t=i,!1})),t}getTopmostVpNode(e=!0){const t=this.element.scrollTop;let i;return i=e?Math.ceil((t-1)/22):Math.floor(t/22),this._getNodeByRowIdx(i)}getLowestVpNode(e=!0){const t=this.element,i=this.headerElement.clientHeight,s=t.scrollTop,n=t.clientHeight-i;let r;return r=e?Math.floor((s+n)/22)-1:Math.ceil((s+n)/22)-1,r=Math.min(r,this.count(!0)-1),this._getNodeByRowIdx(r)}_getPrevNodeInView(e,t=1){return this.visitRows((i=>{if(e=i,t--<=0)return!1}),{reverse:!0,start:e||this.getActiveNode()}),e}_getNextNodeInView(e,t=1){return this.visitRows((i=>{if(e=i,t--<=0)return!1}),{reverse:!1,start:e||this.getActiveNode()}),e}addChildren(e,t){return this.root.addChildren(e,t)}applyCommand(e,t,i){let s,n;switch(t instanceof WunderbaumNode?s=t:(s=this.getActiveNode(),assert(void 0===i),i=t),e){case"moveUp":n=s.getPrevSibling(),n&&(s.moveTo(n,"before"),s.setActive());break;case"moveDown":n=s.getNextSibling(),n&&(s.moveTo(n,"after"),s.setActive());break;case"indent":n=s.getPrevSibling(),n&&(s.moveTo(n,"appendChild"),n.setExpanded(),s.setActive());break;case"outdent":s.isTopLevel()||(s.moveTo(s.getParent(),"after"),s.setActive());break;case"remove":n=s.getPrevSibling()||s.getParent(),s.remove(),n&&n.setActive();break;case"addChild":this._callMethod("edit.createNode","prependChild");break;case"addSibling":this._callMethod("edit.createNode","after");break;case"rename":this._callMethod("edit.startEditTitle");break;case"down":case"first":case"last":case"left":case"pageDown":case"pageUp":case"parent":case"right":case"up":return s.navigate(e);default:error(`Unhandled command: '${e}'`)}}clear(){this.root.removeChildren(),this.root.children=null,this.keyMap.clear(),this.refKeyMap.clear(),this.treeRowCount=0,this.activeNode=null,this.focusNode=null,this.setModified(ChangeType.structure)}destroy(){this.logInfo("destroy()..."),this.clear(),this.resizeObserver.disconnect(),this.element.innerHTML="",this.element.outerHTML=this.element.outerHTML}getOption(e,t){let i,s=this.options;e.indexOf(".")>=0&&([i,e]=e.split("."),s=s[i]);let n=s[e];return"function"==typeof n&&(n=n({type:"resolve",tree:this})),null!=n?n:t}setOption(e,t){if(e.indexOf(".")>=0){const i=e.split(".");this.extensions[i[0]].setPluginOption(i[1],t)}else switch(this.options[e]=t,e){case"checkbox":this.setModified(ChangeType.any);break;case"enabled":this.setEnabled(!!t);break;case"fixedCol":this.element.classList.toggle("wb-fixed-col",!!t)}}hasFocus(){return this.element.contains(document.activeElement)}hasHeader(){const e=this.options.header;return this.isGrid()?!1!==e:!!e}runWithoutUpdate(e,t=null){try{this.enableUpdate(!1);const t=e();return assert(!(t instanceof Promise)),t}finally{this.enableUpdate(!0)}}async expandAll(e=!0,t){await this.root.expandAll(e,t)}selectAll(e=!0){try{this.enableUpdate(!1),this.visit((t=>{t.setSelected(e)}))}finally{this.enableUpdate(!0)}}count(e=!1){return e?this.treeRowCount:this.keyMap.size}_check(){let e=0;this.visit((t=>{e++})),this.keyMap.size!==e&&this.logWarn(`_check failed: ${this.keyMap.size} !== ${e}`)}findAll(e){return this.root.findAll(e)}findFirst(e){return this.root.findFirst(e)}findKey(e){return this.keyMap.get(e)||null}findNextNode(e,t){let i=null,s=this.getFirstChild(),n="string"==typeof e?makeNodeTitleStartMatcher(e):e;function r(e){if(n(e)&&(i=e),i||e===t)return!1}return t=t||s,this.visitRows(r,{start:t,includeSelf:!1}),i||t===s||this.visitRows(r,{start:s,includeSelf:!0}),i}findRelatedNode(e,t,i=!1){let s=null;const n=Math.floor(this.listContainerElement.clientHeight/22);switch(t){case"parent":case"left":e.parent&&e.parent.parent&&(s=e.parent);break;case"first":this.visit((function(e){if(e.isVisible())return s=e,!1}));break;case"last":this.visit((function(e){e.isVisible()&&(s=e)}));break;case"right":e.children&&e.children.length&&(s=e.children[0]);break;case"up":s=this._getPrevNodeInView(e);break;case"down":s=this._getNextNodeInView(e);break;case"pageDown":const i=this.getLowestVpNode();s=e._rowIdx<i._rowIdx?i:this._getNextNodeInView(e,n);break;case"pageUp":if(0===e._rowIdx)s=e;else{const t=this.getTopmostVpNode();s=e._rowIdx>t._rowIdx?t:this._getPrevNodeInView(e,n)}break;default:this.logWarn("Unknown relation '"+t+"'.")}return s}*format_iter(e,t){return this.root.format_iter(e,t)}format(e,t){return this.root.format(e,t)}getActiveColElem(){return this.activeNode&&this.activeColIdx>=0?this.activeNode.getColElem(this.activeColIdx):null}getActiveNode(){return this.activeNode}getFirstChild(){return this.root.getFirstChild()}getFocusNode(){return this.focusNode}static getEventInfo(e){let t=e.target,i=t.classList,s=t.closest("span.wb-col"),n=Wunderbaum.getNode(t),r=n?n.tree:Wunderbaum.getTree(e),o={tree:r,node:n,region:NodeRegion.unknown,colDef:void 0,colIdx:-1,colId:void 0,colElem:s};if(i.contains("wb-title"))o.region=NodeRegion.title;else if(i.contains("wb-expander"))o.region=n.isExpandable()?NodeRegion.expander:NodeRegion.prefix;else if(i.contains("wb-checkbox"))o.region=NodeRegion.checkbox;else if(i.contains("wb-icon"))o.region=NodeRegion.icon;else if(i.contains("wb-node"))o.region=NodeRegion.title;else if(s){o.region=NodeRegion.column;const e=Array.prototype.indexOf.call(s.parentNode.children,s);o.colIdx=e}else{if(!i.contains("wb-row"))return"mousemove"===e.type||e instanceof KeyboardEvent||console.warn("getEventInfo(): not found",e,o),o;o.region=NodeRegion.title}return-1===o.colIdx&&(o.colIdx=0),o.colDef=null==r?void 0:r.columns[o.colIdx],null!=o.colDef&&(o.colId=o.colDef.id),o}toString(){return`Wunderbaum<'${this.id}'>`}isEditing(){return this._callMethod("edit.isEditingTitle")}isLoading(){var e=!1;return this.root.visit((t=>{if(t._isLoading||t._requestId)return e=!0,!1}),!0),e}logDebug(...e){this.options.debugLevel>=4&&(Array.prototype.unshift.call(e,this.toString()),console.log.apply(console,e))}logError(...e){this.options.debugLevel>=1&&(Array.prototype.unshift.call(e,this.toString()),console.error.apply(console,e))}logInfo(...e){this.options.debugLevel>=3&&(Array.prototype.unshift.call(e,this.toString()),console.info.apply(console,e))}logTime(e){return this.options.debugLevel>=4&&console.time(this+": "+e),e}logTimeEnd(e){this.options.debugLevel>=4&&console.timeEnd(this+": "+e)}logWarn(...e){this.options.debugLevel>=2&&(Array.prototype.unshift.call(e,this.toString()),console.warn.apply(console,e))}scrollTo(e){let t,i;e instanceof WunderbaumNode?t=e:(i=e,t=i.node),assert(t&&null!=t._rowIdx);const s=this.element,n=this.headerElement.clientHeight,r=s.scrollTop,o=s.clientHeight,l=22*t._rowIdx+n,a=n,d=l-r,c=d+22,h=null==i?void 0:i.topNode;let u=null;d>=a?c<=o||(u=l+22-o+2):u=l-a-2,null!=u&&(this.log(`scrollTo(${l}): ${r} => ${u}`),s.scrollTop=u,h&&this.scrollTo(h))}scrollToHorz(){const e=this.columns[0]._widthPx,t=this.element.clientWidth,i=this.element.scrollLeft,s=this.getActiveColElem(),n=Number.parseInt(null==s?void 0:s.style.left,10),r=n+Number.parseInt(null==s?void 0:s.style.width,10);let o=i;n-i<e?o=n-e:r-i>t&&(o=r-t),o=Math.max(0,o),this.log(`scrollToHorz(${this.activeColIdx}): ${n}..${r}, fixedOfs=${e}, vpWidth=${t}, curLeft=${i} -> ${o}`),this.element.scrollLeft=o}setColumn(e){var t;if(assert(this.isCellNav()),assert(0<=e&&e<this.columns.length),this.activeColIdx=e,this.hasHeader())for(let t of this.headerElement.children){let i=0;for(let s of t.children)s.classList.toggle("wb-active",i++===e)}null===(t=this.activeNode)||void 0===t||t.setModified(ChangeType.status);for(let t of this.nodeListElement.children){let i=0;for(let s of t.children)s.classList.toggle("wb-active",i++===e)}this.scrollToHorz()}setActiveNode(e,t=!0,i){var s;null===(s=this.findKey(e))||void 0===s||s.setActive(t,i)}setFocus(e=!0){e?this.element.focus():this.element.blur()}setModified(e,t,i){if(this._disableUpdateCount)return void this._disableUpdateIgnoreCount++;t instanceof WunderbaumNode||(i=t,t=null);const s=!!getOption(i,"immediate"),n=RenderFlag,r=this.pendingChangeTypes;switch(e){case ChangeType.any:case ChangeType.colStructure:r.add(n.header),r.add(n.clearMarkup),r.add(n.redraw),r.add(n.scroll);break;case ChangeType.resize:r.add(n.header),r.add(n.redraw);break;case ChangeType.structure:r.add(n.redraw);break;case ChangeType.scroll:r.add(n.scroll);break;case ChangeType.row:case ChangeType.data:case ChangeType.status:assert(t,`Option '${e}' requires a node.`),t._rowElem&&t.render({change:e});break;default:error(`Invalid change type '${e}'.`)}if(e===ChangeType.colStructure){const e=this.isGrid();this.element.classList.toggle("wb-grid",e),!e&&this.isCellNav()&&this.setCellNav(!1)}r.size>0&&(s?this._updateViewportImmediately():this._updateViewportThrottled())}setEnabled(e=!0){const t=this.enabled;return this.enabled=!!e,this.element.classList.toggle("wb-disabled",!e),t}isEnabled(){return this.enabled}isGrid(){return this.columns&&this.columns.length>1}isCellNav(){return!!this._cellNavMode}isRowNav(){return!this._cellNavMode}setCellNav(e=!0){var t;const i=this._cellNavMode;this._cellNavMode=!!e,e&&!i&&this.setColumn(0),this.element.classList.toggle("wb-cell-mode",e),null===(t=this.activeNode)||void 0===t||t.setModified(ChangeType.status)}setNavigationOption(e,t=!1){if(this.isGrid()||e===NavModeEnum.row)switch(this.options.navigationModeOption=e,e){case NavModeEnum.cell:this.setCellNav(!0);break;case NavModeEnum.row:this.setCellNav(!1);break;case NavModeEnum.startCell:t&&this.setCellNav(!0);break;case NavModeEnum.startRow:t&&this.setCellNav(!1);break;default:error(`Invalid mode '${e}'.`)}else this.logWarn("Plain trees only support row navigation mode.")}setStatus(e,t){return this.root.setStatus(e,t)}setTypes(e,t=!0){assert(isPlainObject(e)),t?this.types=e:extend(this.types,e);for(let e of Object.values(this.types))e.classes&&(e.classes=toSet(e.classes))}sortChildren(e=nodeTitleSorter,t=!1){this.root.sortChildren(e,t)}_updateColumnWidths(){const e=this.element.clientWidth,t=this.columns,i=t[0];let s=0,n=0,r=0,o=!1;if("*"!==i.id)throw new Error(`First column must have  id '*': got '${i.id}'.`);this._columnsById={};for(let e of t){this._columnsById[e.id]=e;let t=e.width;if("*"===e.id&&e!==i)throw new Error(`Column id '*' must be defined only once: '${e.title}'.`);if(t&&"*"!==t)if("number"==typeof t)e._weight=t,n+=t;else if("string"==typeof t&&t.endsWith("px")){e._weight=0;let i=parseFloat(t.slice(0,-2));e._widthPx!=i&&(o=!0,e._widthPx=i),r+=i}else error(`Invalid column width: ${t} (expected string ending with 'px' or number, e.g. "<num>px" or <int>).`);else e._weight=1,n+=1}const l=Math.max(0,e-r);let a=0;for(let e of t){let t;if(e._weight){const i=e.minWidth;t="number"==typeof i?i:"string"==typeof i&&i.endsWith("px")?parseFloat(i.slice(0,-2)):4;const s=Math.max(t,l*e._weight/n);e._widthPx!=s&&(o=!0,e._widthPx=s)}e._ofsPx=a,a+=e._widthPx}t[t.length-1]._widthPx-=2,s=a-2;const d=`${s}px`;return this.headerElement.style.width=d,this.listContainerElement.style.width=d,o}_renderHeaderMarkup(){assert(this.headerElement);const e=this.hasHeader();if(setElemDisplay(this.headerElement,e),!e)return;const t=this.columns.length,i=this.headerElement.querySelector(".wb-row");assert(i),i.innerHTML="<span class='wb-col'></span>".repeat(t);for(let e=0;e<t;e++){const s=this.columns[e],n=i.children[e];n.style.left=s._ofsPx+"px",n.style.width=s._widthPx+"px";const r=escapeHtml(s.title||s.id);let o="";s.tooltip&&(o=escapeTooltip(s.tooltip),o=` title="${o}"`);let l="";e<t-1&&(l='<span class="wb-col-resizer"></span>'),n.innerHTML=`<span class="wb-col-title"${o}>${r}</span>${l}`,this.isCellNav()&&n.classList.toggle("wb-active",e===this.activeColIdx)}}updatePendingModifications(){this.pendingChangeTypes.size>0&&this._updateViewportImmediately()}_updateViewportImmediately(){var e;if(this._disableUpdateCount)return this.log(`_updateViewportImmediately() IGNORED (disable level: ${this._disableUpdateCount})`),void this._disableUpdateIgnoreCount++;const t=RenderFlag,i=new Set(this.pendingChangeTypes);this.pendingChangeTypes.clear();if(i.has(t.scroll)&&1===i.size)this._updateRows({newNodesOnly:!0});else{this.log("_updateViewportImmediately():",i);let e=this.listContainerElement.clientHeight;const s=this.headerElement.clientHeight,n=this.element.clientHeight-s-1;Math.abs(e-n)>1&&(this.listContainerElement.style.height=n+"px",e=n),i.has(t.clearMarkup)&&this.visit((e=>{e.removeMarkup()})),i.has(t.header)&&(this._updateColumnWidths(),this._renderHeaderMarkup()),this._updateRows()}if(this.options.connectTopBreadcrumb){let t=null===(e=this.getTopmostVpNode(!0))||void 0===e?void 0:e.getPath(!1,"title"," > ");t=t?t+" >":"",this.options.connectTopBreadcrumb.textContent=t}this._callEvent("update")}_updateRows(e){const t=!!(e=Object.assign({newNodesOnly:!1},e)).newNodesOnly,i=this.element.clientHeight,s=this.element.scrollTop;let n=Math.max(0,s/22-5);n=Math.floor(n),n%2&&n--;let r=Math.max(0,(s+i)/22+5);r=Math.ceil(r);const o=new Set;this.nodeListElement.childNodes.forEach((e=>{const t=e;o.add(t._wb_node)}));let l=0,a=0,d=!1,c="first";this.visitRows((function(e){const i=e._rowElem;e._rowIdx!==l&&(e._rowIdx=l,d=!0),l<n||l>r?i&&(c=i):i&&t?(o.delete(e),i.style.top=22*l+"px",c=i):(o.delete(e),i&&(i.style.top=22*l+"px"),e.render({top:a,after:c}),c=e._rowElem),l++,a+=22})),this.treeRowCount=l;for(const e of o)e._callEvent("discard"),e.removeMarkup();return this.nodeListElement.style.height=`${a}px`,d}visit(e){return this.root.visit(e,!1)}visitRows(e,t){if(!this.root.hasChildren())return!1;if(t&&t.reverse)return delete t.reverse,this._visitRowsUp(e,t);let i,s,n,r,o,l,a=0,d=!1===(t=t||{}).includeSelf,c=!!t.includeHidden,h=!c&&"hide"===this.filterMode,u=t.start||this.root.children[0];for(n=u.parent;n;){for(o=n.children,s=o.indexOf(u)+a,assert(s>=0,`Could not find ${u} in parent's children: ${n}`),i=s;i<o.length;i++){if(u=o[i],u===l)return!1;if(!h||u.statusNodeType||u.match||u.subMatchCount){if(!d&&!1===e(u))return!1;if(d=!1,u.children&&u.children.length&&(c||u.expanded)&&(r=u.visit((function(t){return t!==l&&(!h||t.match||t.subMatchCount?!1!==e(t)&&(c||!t.children||t.expanded?void 0:"skip"):"skip")}),!1),!1===r))return!1}}u=n,n=n.parent,a=1,!n&&t.wrap&&(this.logDebug("visitRows(): wrap around"),assert(t.start,"`wrap` option requires `start`"),l=t.start,t.wrap=!1,n=this.root,a=0)}return!0}_visitRowsUp(e,t){let i,s,n,r=!!t.includeHidden,o=t.start||this.root.children[0];if(!1!==t.includeSelf&&!1===e(o))return!1;for(;;){if(n=o.parent,i=n.children,i[0]===o){if(o=n,!o.parent)break;i=n.children}else for(s=i.indexOf(o),o=i[s-1];(r||o.expanded)&&o.children&&o.children.length;)i=o.children,n=o,o=i[i.length-1];if((r||o.isVisible())&&!1===e(o))return!1}return!0}load(e){return this.clear(),this.root.load(e)}enableUpdate(e){e?(assert(this._disableUpdateCount>0,"enableUpdate(true) was called too often"),this._disableUpdateCount--,0===this._disableUpdateCount&&(this.logDebug(`enableUpdate(): active again. Re-painting to catch up with ${this._disableUpdateIgnoreCount} ignored update requests...`),this._disableUpdateIgnoreCount=0,this.setModified(ChangeType.any,{immediate:!0}))):this._disableUpdateCount++}filterNodes(e,t){return this.extensions.filter.filterNodes(e,t)}filterBranches(e,t){return this.extensions.filter.filterBranches(e,t)}clearFilter(){return this.extensions.filter.clearFilter()}isFilterActive(){return!!this.filterMode}updateFilter(){return this.extensions.filter.updateFilter()}}Wunderbaum.sequence=0,Wunderbaum.version="v0.3.3",Wunderbaum.util=util;export{Wunderbaum};
//# sourceMappingURL=wunderbaum.esm.min.js.map