/*!
 * Wunderbaum - util
 * Copyright (c) 2021-2023, Martin Wendt. Released under the MIT license.
 * v0.7.0, Sat, 09 Dec 2023 13:47:27 GMT (https://github.com/mar10/wunderbaum)
 */
const MOUSE_BUTTONS={0:"",1:"left",2:"middle",3:"right",4:"back",5:"forward"},MAX_INT=9007199254740991,userInfo=_getUserInfo(),isMac=userInfo.isMac,REX_HTML=/[&<>"'/]/g,REX_TOOLTIP=/[<>"'/]/g,ENTITY_MAP={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;","/":"&#x2F;"};let Deferred$1=class{constructor(){this.thens=[],this.catches=[],this.status=""}resolve(e){if(this.status)throw new Error("already settled");this.status="resolved",this.resolvedValue=e,this.thens.forEach((t=>t(e))),this.thens=[]}reject(e){if(this.status)throw new Error("already settled");this.status="rejected",this.rejectedError=e,this.catches.forEach((t=>t(e))),this.catches=[]}then(e){"resolved"===status?e(this.resolvedValue):this.thens.unshift(e)}catch(e){"rejected"===this.status?e(this.rejectedError):this.catches.unshift(e)}promise(){return{then:this.then,catch:this.catch}}};function assert(e,t){if(!e)throw t=t||"Assertion failed.",new Error(t)}function _getUserInfo(){const e=navigator;return{isMac:/Mac/.test(e.platform)}}function documentReady(e){"loading"===document.readyState?document.addEventListener("DOMContentLoaded",e):e()}function documentReadyPromise(){return new Promise((e=>{documentReady(e)}))}function each(e,t){if(null==e)return e;const s=e.length;let i=0;if("number"==typeof s)for(;i<s&&!1!==t.call(e[i],i,e[i]);i++);else for(const s in e)if(!1===t.call(e[i],s,e[s]))break;return e}function error(e){throw new Error(e)}function escapeHtml(e){return(""+e).replace(REX_HTML,(function(e){return ENTITY_MAP[e]}))}function escapeRegex(e){return(""+e).replace(/([.?*+^$[\]\\(){}|-])/g,"\\$1")}function escapeTooltip(e){return(""+e).replace(REX_TOOLTIP,(function(e){return ENTITY_MAP[e]}))}function extractHtmlText(e){return e.indexOf(">")>=0&&error("Not implemented"),e}function getValueFromElem(e,t=!1){const s=e.tagName;let i=null;if("SPAN"===s&&e.classList.contains("wb-col")){const s=e,n=s.querySelector("input,select");if(n)return getValueFromElem(n,t);s.innerText=""+i}else if("INPUT"===s){const s=e;switch(s.type){case"button":case"reset":case"submit":case"image":break;case"checkbox":i=s.indeterminate?null:s.checked;break;case"date":case"datetime":case"datetime-local":case"month":case"time":case"week":i=t?s.valueAsDate:s.value;break;case"number":case"range":i=s.valueAsNumber;break;case"radio":{const e=s.name,t=s.parentElement.querySelector(`input[name="${e}"]:checked`);i=t?t.value:void 0}break;default:i=s.value}}else if("SELECT"===s){i=e.value}return i}function setValueToElem(e,t){const s=e.tagName;if("SPAN"===s&&e.classList.contains("wb-col")){const s=e,i=s.querySelector("input,select");if(i)return setValueToElem(i,t);s.innerText=""+t}else if("INPUT"===s){const s=e,i=s.type;switch(i){case"checkbox":s.indeterminate=null===t,s.checked=!!t;break;case"date":case"month":case"time":case"week":case"datetime":case"datetime-local":s.valueAsDate=new Date(t);break;case"number":case"range":null==t?s.value=t:s.valueAsNumber=t;break;case"radio":error(`Not yet implemented: ${i}`);break;case"button":case"reset":case"submit":case"image":break;default:s.value=null!=t?t:""}}else if("SELECT"===s){const s=e;null==t?s.selectedIndex=-1:s.value=t}}function setElemDisplay(e,t){const s=elemFromSelector(e).style;t?"none"===s.display&&(s.display=""):""===s.display&&(s.display="none")}function elemFromHtml(e){const t=document.createElement("template");return t.innerHTML=e.trim(),t.content.firstElementChild}const _IGNORE_KEYS=new Set(["Alt","Control","Meta","Shift"]);function elemFromSelector(e){return e?"string"==typeof e?document.querySelector(e):e:null}function eventTargetFromSelector(e){return e?"string"==typeof e?document.querySelector(e):e:null}function eventToString(e){const t=e.key,s=e.type,i=[];return e.altKey&&i.push("Alt"),e.ctrlKey&&i.push("Control"),e.metaKey&&i.push("Meta"),e.shiftKey&&i.push("Shift"),"click"===s||"dblclick"===s?i.push(MOUSE_BUTTONS[e.button]+s):"wheel"===s?i.push(s):_IGNORE_KEYS.has(t)||i.push(t),i.join("+")}function extend(...e){for(let t=1;t<e.length;t++){const s=e[t];if(null!=s)for(const t in s)Object.prototype.hasOwnProperty.call(s,t)&&(e[0][t]=s[t])}return e[0]}function isArray(e){return Array.isArray(e)}function isEmptyObject(e){return 0===Object.keys(e).length&&e.constructor===Object}function isFunction(e){return"function"==typeof e}function isPlainObject(e){return"[object Object]"===Object.prototype.toString.call(e)}function noop(...e){}function onEvent(e,t,s,i){let n,r;e=eventTargetFromSelector(e),i?(n=s,r=i):(n="",r=s),t.split(" ").forEach((t=>{e.addEventListener(t,(function(e){if(!n)return r(e);if(e.target){let t=e.target;if(t.matches(n))return r(e);if(t=t.closest(n),t)return r(e)}}))}))}function overrideMethod(e,t,s,i){let n,r;const o=i||e,l=e[t],a=(...e)=>l.apply(o,e),d=e=>l.apply(o,e);e[t]=(...e)=>{try{return n=o._super,r=o._superApply,o._super=a,o._superApply=d,s.apply(o,e)}finally{o._super=n,o._superApply=r}}}function setTimeoutPromise(e,t){return new Promise(((s,i)=>{setTimeout((()=>{try{s(e.apply(this))}catch(e){i(e)}}),t)}))}async function sleep(e){return new Promise((t=>setTimeout(t,e)))}function toggleCheckbox(e,t,s){const i=elemFromSelector(e);if(assert("checkbox"===i.type,`Expected a checkbox: ${i.type}`),null!=s||(s=i.classList.contains("wb-tristate")||i.indeterminate),void 0===t){switch(i.indeterminate?null:i.checked){case!0:t=!1;break;case!1:t=!s||null;break;case null:t=!0}}i.indeterminate=null==t,i.checked=!!t}function getOption(e,t,s=void 0){let i;e&&t.indexOf(".")>=0&&([i,t]=t.split("."),e=e[i]);const n=e?e[t]:null;return null!=n?n:s}function toSet(e){if(e instanceof Set)return e;if("string"==typeof e){const t=new Set;for(const s of e.split(" "))t.add(s.trim());return t}if(Array.isArray(e))return new Set(e);throw new Error("Cannot convert to Set<string>: "+e)}function type(e){return Object.prototype.toString.call(e).replace(/^\[object (.+)\]$/,"$1").toLowerCase()}function adaptiveThrottle(e,t){let s=0,i=null;const n=Object.assign({minDelay:16,defaultDelay:200,maxDelay:5e3,delayFactor:2},t),r=Math.max(16,+n.minDelay),o=+n.maxDelay,l=(...t)=>{if(s)i=t,s+=1;else{s=1;const a=t;i=null;const d=Date.now();try{e.apply(this,a)}catch(e){console.error(e)}const c=Date.now()-d,h=Math.min(Math.max(r,c*n.delayFactor),o),u=Math.max(r,h-c);setTimeout((()=>{s=0,null!=i&&l.apply(this,i)}),u)}};return l}var ChangeType,RenderFlag,NodeStatusType,NodeRegion,NavModeEnum,util=Object.freeze({__proto__:null,Deferred:Deferred$1,MAX_INT:MAX_INT,MOUSE_BUTTONS:MOUSE_BUTTONS,adaptiveThrottle:adaptiveThrottle,assert:assert,documentReady:documentReady,documentReadyPromise:documentReadyPromise,each:each,elemFromHtml:elemFromHtml,elemFromSelector:elemFromSelector,error:error,escapeHtml:escapeHtml,escapeRegex:escapeRegex,escapeTooltip:escapeTooltip,eventTargetFromSelector:eventTargetFromSelector,eventToString:eventToString,extend:extend,extractHtmlText:extractHtmlText,getOption:getOption,getValueFromElem:getValueFromElem,isArray:isArray,isEmptyObject:isEmptyObject,isFunction:isFunction,isMac:isMac,isPlainObject:isPlainObject,noop:noop,onEvent:onEvent,overrideMethod:overrideMethod,setElemDisplay:setElemDisplay,setTimeoutPromise:setTimeoutPromise,setValueToElem:setValueToElem,sleep:sleep,toSet:toSet,toggleCheckbox:toggleCheckbox,type:type});
/*!
 * Wunderbaum - types
 * Copyright (c) 2021-2023, Martin Wendt. Released under the MIT license.
 * v0.7.0, Sat, 09 Dec 2023 13:47:27 GMT (https://github.com/mar10/wunderbaum)
 */!function(e){e.any="any",e.data="data",e.colStructure="colStructure",e.resize="resize",e.row="row",e.structure="structure",e.status="status",e.scroll="scroll"}(ChangeType||(ChangeType={})),function(e){e.clearMarkup="clearMarkup",e.header="header",e.redraw="redraw",e.scroll="scroll"}(RenderFlag||(RenderFlag={})),function(e){e.ok="ok",e.loading="loading",e.error="error",e.noData="noData",e.paging="paging"}(NodeStatusType||(NodeStatusType={})),function(e){e.unknown="",e.checkbox="checkbox",e.column="column",e.expander="expander",e.icon="icon",e.prefix="prefix",e.title="title"}(NodeRegion||(NodeRegion={})),function(e){e.startRow="startRow",e.cell="cell",e.startCell="startCell",e.row="row"}(NavModeEnum||(NavModeEnum={}));
/*!
 * Wunderbaum - wb_extension_base
 * Copyright (c) 2021-2023, Martin Wendt. Released under the MIT license.
 * v0.7.0, Sat, 09 Dec 2023 13:47:27 GMT (https://github.com/mar10/wunderbaum)
 */
class WunderbaumExtension{constructor(e,t,s){this.enabled=!0,this.tree=e,this.id=t,this.treeOpts=e.options;const i=e.options;void 0===this.treeOpts[t]?i[t]=this.extensionOpts=extend({},s):(this.extensionOpts=extend({},s,i[t]),i[t]=this.extensionOpts),this.enabled=this.getPluginOption("enabled",!0)}init(){this.tree.element.classList.add("wb-ext-"+this.id)}getPluginOption(e,t){var s;return null!==(s=this.extensionOpts[e])&&void 0!==s?s:t}setPluginOption(e,t){this.extensionOpts[e]=t}setEnabled(e=!0){return this.setPluginOption("enabled",!!e)}onKeyEvent(e){}onRender(e){}}
/*!
 * debounce & throttle, taken from https://github.com/lodash/lodash v4.17.21
 * MIT License: https://raw.githubusercontent.com/lodash/lodash/4.17.21-npm/LICENSE
 * Modified for TypeScript type annotations.
 */const freeGlobal="object"==typeof global&&null!==global&&global.Object===Object&&global,freeGlobalThis="object"==typeof globalThis&&null!==globalThis&&globalThis.Object==Object&&globalThis,freeSelf="object"==typeof self&&null!==self&&self.Object===Object&&self,root=freeGlobalThis||freeGlobal||freeSelf||Function("return this")();function isObject(e){const t=typeof e;return null!=e&&("object"===t||"function"===t)}function debounce(e,t=0,s={}){let i,n,r,o,l,a,d=0,c=!1,h=!1,u=!0;const p=!t&&0!==t&&"function"==typeof root.requestAnimationFrame;if("function"!=typeof e)throw new TypeError("Expected a function");function f(t){const s=i,r=n;return i=n=void 0,d=t,o=e.apply(r,s),o}function g(e,t){return p?(root.cancelAnimationFrame(l),root.requestAnimationFrame(e)):setTimeout(e,t)}function m(e){const s=e-a;return void 0===a||s>=t||s<0||h&&e-d>=r}function v(){const e=Date.now();if(m(e))return b(e);l=g(v,function(e){const s=e-d,i=t-(e-a);return h?Math.min(i,r-s):i}(e))}function b(e){return l=void 0,u&&i?f(e):(i=n=void 0,o)}function y(...e){const s=Date.now(),r=m(s);if(i=e,n=this,a=s,r){if(void 0===l)return function(e){return d=e,l=g(v,t),c?f(e):o}(a);if(h)return l=g(v,t),f(a)}return void 0===l&&(l=g(v,t)),o}return t=+t||0,isObject(s)&&(c=!!s.leading,h="maxWait"in s,r=h?Math.max(+s.maxWait||0,t):r,u="trailing"in s?!!s.trailing:u),y.cancel=function(){void 0!==l&&function(e){if(p)return root.cancelAnimationFrame(e);clearTimeout(e)}(l),d=0,i=a=n=l=void 0},y.flush=function(){return void 0===l?o:b(Date.now())},y.pending=function(){return void 0!==l},y}function throttle(e,t=0,s={}){let i=!0,n=!0;if("function"!=typeof e)throw new TypeError("Expected a function");return isObject(s)&&(i="leading"in s?!!s.leading:i,n="trailing"in s?!!s.trailing:n),debounce(e,t,{leading:i,trailing:n,maxWait:t})}
/*!
 * Wunderbaum - ext-filter
 * Copyright (c) 2021-2023, Martin Wendt. Released under the MIT license.
 * v0.7.0, Sat, 09 Dec 2023 13:47:27 GMT (https://github.com/mar10/wunderbaum)
 */const START_MARKER="￷",END_MARKER="￸",RE_START_MARKER=new RegExp(escapeRegex("￷"),"g"),RE_END_MARTKER=new RegExp(escapeRegex("￸"),"g");class FilterExtension extends WunderbaumExtension{constructor(e){super(e,"filter",{connectInput:null,autoApply:!0,autoExpand:!1,counter:!0,fuzzy:!1,hideExpandedCounter:!0,hideExpanders:!1,highlight:!0,leavesOnly:!1,mode:"dim",noData:!0}),this.lastFilterArgs=null}init(){super.init();const e=this.getPluginOption("connectInput");e&&(this.queryInput=elemFromSelector(e),onEvent(this.queryInput,"input",debounce((e=>{this.filterNodes(this.queryInput.value.trim(),{})}),700)))}setPluginOption(e,t){if(super.setPluginOption(e,t),"mode"===e)this.tree.filterMode="hide"===t?"hide":"dim",this.tree.updateFilter()}_applyFilterNoUpdate(e,t,s){return this.tree.runWithDeferredUpdate((()=>this._applyFilterImpl(e,t,s)))}_applyFilterImpl(e,t,s){let i,n,r=0;const o=Date.now(),l=this.tree,a=l.options,d=a.autoCollapse,c=extend({},a.filter,s),h="hide"===c.mode,u=!!c.leavesOnly&&!t;if("string"==typeof e){if(""===e)return l.logInfo("Passing an empty string as a filter is handled as clearFilter()."),void this.clearFilter();i=c.fuzzy?e.split("").map(escapeRegex).reduce((function(e,t){return e+"([^"+t+"]*)"+t}),""):escapeRegex(e);const t=new RegExp(i,"i"),s=new RegExp(escapeRegex(e),"gi");e=e=>{if(!e.title)return!1;const i=e.title,r=i.match(t);return r&&c.highlight&&(n=c.fuzzy?_markFuzzyMatchedChars(i,r,!0):i.replace(s,(function(e){return"￷"+e+"￸"})),e.titleWithHighlight=escapeHtml(n).replace(RE_START_MARKER,"<mark>").replace(RE_END_MARTKER,"</mark>")),!!r}}return l.filterMode=c.mode,this.lastFilterArgs=arguments,l.element.classList.toggle("wb-ext-filter-hide",!!h),l.element.classList.toggle("wb-ext-filter-dim",!h),l.element.classList.toggle("wb-ext-filter-hide-expanders",!!c.hideExpanders),l.root.subMatchCount=0,l.visit((e=>{delete e.match,delete e.titleWithHighlight,e.subMatchCount=0})),l.setStatus(NodeStatusType.ok),a.autoCollapse=!1,l.visit((s=>{if(u&&null!=s.children)return;let i=e(s);if("skip"===i)return s.visit((function(e){e.match=!1}),!0),"skip";let n=!1;(t||"branch"===i)&&s.parent.match&&(i=!0,n=!0),i&&(r++,s.match=!0,s.visitParents((e=>{e!==s&&(e.subMatchCount+=1),!c.autoExpand||n||e.expanded||(e.setExpanded(!0,{noAnimation:!0,noEvents:!0}),e._filterAutoExpanded=!0)}),!0))})),a.autoCollapse=d,0===r&&c.noData&&h&&l.root.setStatus(NodeStatusType.noData),l.logInfo(`Filter '${i}' found ${r} nodes in ${Date.now()-o} ms.`),r}filterNodes(e,t){return this._applyFilterNoUpdate(e,!1,t)}filterBranches(e,t){return this._applyFilterNoUpdate(e,!0,t)}updateFilter(){var e;const t=this.tree;t.filterMode&&this.lastFilterArgs&&(null===(e=t.options.filter)||void 0===e?void 0:e.autoApply)?this._applyFilterNoUpdate.apply(this,this.lastFilterArgs):t.logWarn("updateFilter(): no filter active.")}clearFilter(){const e=this.tree;e.enableUpdate(!1),e.setStatus(NodeStatusType.ok),delete e.root.match,delete e.root.subMatchCount,e.visit((e=>{delete e.match,delete e.subMatchCount,delete e.titleWithHighlight,e._filterAutoExpanded&&e.expanded&&e.setExpanded(!1,{noAnimation:!0,noEvents:!0}),delete e._filterAutoExpanded})),e.filterMode=null,this.lastFilterArgs=null,e.element.classList.remove("wb-ext-filter-dim","wb-ext-filter-hide"),e.enableUpdate(!0)}}function _markFuzzyMatchedChars(e,t,s=!0){const i=[];for(let e=1;e<t.length;e++){const s=t[e].length+(1===e?0:1)+(i[i.length-1]||0);i.push(s)}const n=e.split("");return s?i.forEach((function(e){n[e]="￷"+n[e]+"￸"})):i.forEach((function(e){n[e]="<mark>"+n[e]+"</mark>"})),n.join("")}
/*!
 * Wunderbaum - ext-keynav
 * Copyright (c) 2021-2023, Martin Wendt. Released under the MIT license.
 * v0.7.0, Sat, 09 Dec 2023 13:47:27 GMT (https://github.com/mar10/wunderbaum)
 */const QUICKSEARCH_DELAY=500;class KeynavExtension extends WunderbaumExtension{constructor(e){super(e,"keynav",{})}_getEmbeddedInputElem(e){var t;let s=null;if(e&&null!=e.type)s=e;else{const e=null===(t=this.tree.getActiveColElem())||void 0===t?void 0:t.querySelector("input,select");e&&(s=e)}return s}_isCurInputFocused(){var e;return!!(null===(e=this.tree.getActiveColElem())||void 0===e?void 0:e.querySelector("input:focus,select:focus"))}onKeyEvent(e){const t=e.event,s=this.tree,i=e.options,n=!t.ctrlKey||i.autoActivate,r=this._getEmbeddedInputElem(t.target),o=r&&this._isCurInputFocused(),l=i.navigationModeOption;let a,d=eventToString(t),c=e.node,h=!0;if(!s.isEnabled())return!1;if(!1===s._callEvent("keydown",e))return!1;if(!1===s._callMethod("edit._preprocessKeyEvent",e))return!1;if(!c){const e=s.getFocusNode()||s.getActiveNode(),t=s.getFirstChild();if(!e&&t&&"ArrowDown"===d)return t.logInfo("Keydown: activate first node."),void t.setActive();a=e||t,a&&(a.setFocus(),c=s.getFocusNode(),c.logInfo("Keydown: force focus on active node."))}const u=c.isColspan();if(s.isRowNav()){if(o){switch(d){case"Enter":r.blur(),s.setFocus();break;case"Escape":c._render(),s.setFocus()}return}if(i.quicksearch&&1===d.length&&/^\w$/.test(d)&&!r){const e=Date.now();e-s.lastQuicksearchTime>500&&(s.lastQuicksearchTerm=""),s.lastQuicksearchTime=e,s.lastQuicksearchTerm+=d;const i=s.findNextNode(s.lastQuicksearchTerm,s.getActiveNode());return i&&i.setActive(!0,{event:t}),void t.preventDefault()}switch(d){case"Enter":c.isActive()&&(c.isExpanded()?d="Subtract":c.isExpandable(!0)&&(d="Add"));break;case"ArrowLeft":c.expanded&&(d="Subtract");break;case"ArrowRight":if(!c.expanded&&c.isExpandable(!0))d="Add";else if(l===NavModeEnum.startCell||l===NavModeEnum.startRow)return t.preventDefault(),s.setCellNav(),!1}switch(d){case"+":case"Add":c.setExpanded(!0);break;case"-":case"Subtract":c.setExpanded(!1);break;case" ":c.getOption("checkbox")?c.toggleSelected():c.setActive(!0,{event:t});break;case"Enter":c.setActive(!0,{event:t});break;case"ArrowDown":case"ArrowLeft":case"ArrowRight":case"ArrowUp":case"Backspace":case"End":case"Home":case"Control+End":case"Control+Home":case"Meta+ArrowDown":case"Meta+ArrowUp":case"PageDown":case"PageUp":c.navigate(d,{activate:n,event:t});break;default:h=!1}}else{const e=this._getEmbeddedInputElem(null),i=e?e.type||e.tagName:"",r=e&&this._isCurInputFocused(),o=e&&"checkbox"!==i;if(r){if("Escape"===d)return c._render(),c.logDebug("Reset focused input"),s.setFocus(),void s.setColumn(s.activeColIdx);if("Enter"!==d)return void c.logDebug(`Ignored ${d} inside focused input`)}else if(e&&1===d.length&&o)return e.focus(),e.value="",c.logDebug(`Focus imput: ${d}`),!1;switch("Tab"===d?(d="ArrowRight",h=!0):"Shift+Tab"===d&&(d=s.activeColIdx>0?"ArrowLeft":"",h=!0),d){case"+":case"Add":c.setExpanded(!0);break;case"-":case"Subtract":c.setExpanded(!1);break;case" ":0===s.activeColIdx&&c.getOption("checkbox")?(c.toggleSelected(),h=!0):e&&"checkbox"===i&&(e.click(),h=!0);break;case"F2":e&&!r&&o&&(e.focus(),h=!0);break;case"Enter":s.setFocus(),(0===s.activeColIdx||u)&&c.isExpandable()?(c.setExpanded(!c.isExpanded()),h=!0):e&&!r&&o&&(e.focus(),h=!0);break;case"Escape":s.setFocus(),c.log("keynav: focus tree..."),s.isCellNav()&&l!==NavModeEnum.cell&&(c.log("keynav: setCellNav(false)"),s.setCellNav(!1),s.setFocus(),h=!0);break;case"ArrowLeft":s.setFocus(),u&&c.isExpanded()?c.setExpanded(!1):!u&&s.activeColIdx>0?s.setColumn(s.activeColIdx-1):l!==NavModeEnum.cell&&s.setCellNav(!1),h=!0;break;case"ArrowRight":s.setFocus(),u&&!c.isExpanded()?c.setExpanded():!u&&s.activeColIdx<s.columns.length-1&&s.setColumn(s.activeColIdx+1),h=!0;break;case"Home":s.setFocus(),!u&&s.activeColIdx>0&&s.setColumn(0),h=!0;break;case"End":s.setFocus(),!u&&s.activeColIdx<s.columns.length-1&&s.setColumn(s.columns.length-1),h=!0;break;case"ArrowDown":case"ArrowUp":case"Backspace":case"Control+End":case"Control+Home":case"Meta+ArrowDown":case"Meta+ArrowUp":case"PageDown":case"PageUp":c.navigate(d,{activate:n,event:t}),h=!0;break;default:h=!1}}h&&t.preventDefault()}}
/*!
 * Wunderbaum - ext-logger
 * Copyright (c) 2021-2023, Martin Wendt. Released under the MIT license.
 * v0.7.0, Sat, 09 Dec 2023 13:47:27 GMT (https://github.com/mar10/wunderbaum)
 */class LoggerExtension extends WunderbaumExtension{constructor(e){super(e,"logger",{}),this.ignoreEvents=new Set(["iconBadge","render","discard"]),this.prefix=e+".ext-logger"}init(){const e=this.tree;if(e.getOption("debugLevel")>=4){const t=this.ignoreEvents,s=this.prefix;overrideMethod(e,"callEvent",(function(i,n){if(t.has(i))return e._superApply(arguments);const r=Date.now(),o=e._superApply(arguments);return e.logDebug(`${s}: callEvent('${i}') took ${Date.now()-r} ms.`,arguments[1]),o}))}}onKeyEvent(e){this.tree.logDebug(`${this.prefix}: onKeyEvent()`,e)}}
/*!
 * Wunderbaum - common
 * Copyright (c) 2021-2023, Martin Wendt. Released under the MIT license.
 * v0.7.0, Sat, 09 Dec 2023 13:47:27 GMT (https://github.com/mar10/wunderbaum)
 */const DEFAULT_DEBUGLEVEL=3,ROW_HEIGHT=22,ICON_WIDTH=20,TITLE_SPAN_PAD_Y=7,RENDER_MAX_PREFETCH=5,TEST_IMG=new RegExp(/\.|\//),iconMaps={bootstrap:{error:"bi bi-exclamation-triangle",loading:"bi bi-chevron-right wb-busy",noData:"bi bi-question-circle",expanderExpanded:"bi bi-chevron-down",expanderCollapsed:"bi bi-chevron-right",expanderLazy:"bi bi-chevron-right wb-helper-lazy-expander",checkChecked:"bi bi-check-square",checkUnchecked:"bi bi-square",checkUnknown:"bi bi-dash-square-dotted",radioChecked:"bi bi-circle-fill",radioUnchecked:"bi bi-circle",radioUnknown:"bi bi-record-circle",folder:"bi bi-folder2",folderOpen:"bi bi-folder2-open",folderLazy:"bi bi-folder-symlink",doc:"bi bi-file-earmark"},fontawesome6:{error:"fa-solid fa-triangle-exclamation",loading:"fa-solid fa-chevron-right fa-beat",noData:"fa-solid fa-circle-question",expanderExpanded:"fa-solid fa-chevron-down",expanderCollapsed:"fa-solid fa-chevron-right",expanderLazy:"fa-solid fa-chevron-right wb-helper-lazy-expander",checkChecked:"fa-regular fa-square-check",checkUnchecked:"fa-regular fa-square",checkUnknown:"fa-regular fa-square-minus",radioChecked:"fa-solid fa-circle",radioUnchecked:"fa-regular fa-circle",radioUnknown:"fa-regular fa-circle-question",folder:"fa-solid fa-folder-closed",folderOpen:"fa-regular fa-folder-open",folderLazy:"fa-solid fa-folder-plus",doc:"fa-regular fa-file"}},RESERVED_TREE_SOURCE_KEYS=new Set(["_format","_keyMap","_positional","_typeList","_valueMap","_version","children","columns","types"]),KEY_TO_ACTION_DICT={" ":"toggleSelect","+":"expand",Add:"expand",ArrowDown:"down",ArrowLeft:"left",ArrowRight:"right",ArrowUp:"up",Backspace:"parent","/":"collapseAll",Divide:"collapseAll",End:"lastCol",Home:"firstCol","Control+End":"last","Control+Home":"first","Meta+ArrowDown":"last","Meta+ArrowUp":"first","*":"expandAll",Multiply:"expandAll",PageDown:"pageDown",PageUp:"pageUp","-":"collapse",Subtract:"collapse"};function makeNodeTitleMatcher(e){return e instanceof RegExp?function(t){return e.test(t.title)}:(assert("string"==typeof e,`Expected a string or RegExp: ${e}`),function(t){return t.title===e})}function makeNodeTitleStartMatcher(e){e=escapeRegex(e);const t=new RegExp("^"+e,"i");return function(e){return t.test(e.title)}}function nodeTitleSorter(e,t){const s=e.title.toLowerCase(),i=t.title.toLowerCase();return s===i?0:s>i?1:-1}function unflattenSource(e){var t,s,i;const{_format:n,_keyMap:r={},_positional:o=[],children:l}=e;if("flat"!==n)throw new Error(`Expected source._format: "flat", but got ${n}`);if(o&&o.includes("children"))throw new Error(`source._positional must not include "children": ${o}`);let a=r;if(r.t){const e="source._keyMap maps from long to short since v0.7.0. Flip key/value!";console.warn(e),a={};for(const[e,t]of Object.entries(r))a[t]=e}const d=o.map((e=>a[e])),c=[],h={},u={},p=null!==(t=a.key)&&void 0!==t?t:"key",f=null!==(s=a.children)&&void 0!==s?s:"children";for(const[e,t]of l.entries()){const[s,n,r={}]=t;t[1]=null,null!=t[2]&&(t[2]=null),n.forEach(((e,t)=>{r[d[t]]=e})),u[e]=r;const o=r[p];null!=o&&(h[o]=r);let l=null;if(null===s);else if("number"==typeof s){if(l=u[s],void 0===l)throw new Error(`unflattenSource: Could not find parent node by index: ${s}.`)}else if(l=h[s],void 0===l)throw new Error(`unflattenSource: Could not find parent node by key: ${s}`);l?(null!==(i=l[f])&&void 0!==i||(l[f]=[]),l[f].push(r)):c.push(r)}e.children=c}function decompressSourceData(e){let{_format:t,_version:s=1,_keyMap:i,_valueMap:n}=e;assert(1===s,`Expected file version 1 instead of ${s}`);let r=i,o={};if(r)for(const[e,t]of Object.entries(r))o[t]=e;if(r&&r.t){const e="source._keyMap maps from long to short since v0.7.0. Flip key/value!";console.warn(e),[r,o]=[o,r]}if(null!=e._typeList){const t='source._typeList is deprecated since v0.7.0: use source._valueMap: {"type": [...]} instead.';if(null!=n)throw new Error(t);console.warn(t),n={type:e._typeList},delete e._typeList}"flat"===t&&unflattenSource(e),delete e._format,delete e._version,delete e._keyMap,delete e._valueMap,delete e._positional,(i||n)&&function e(t){for(const s of t)Object.getOwnPropertyNames(s).forEach((e=>{const t=s[e];let r=e;if(i&&null!=o[e]&&(r=o[e],r!==e&&(s[r]=t,delete s[e])),n&&"number"==typeof t&&null!=n[r]){const e=n[r][t];if(null==e)throw new Error(`Expected valueMap[${r}][${t}] entry in [${n[r]}]`);s[r]=e}})),s.children&&e(s.children)}(e.children)}
/*!
 * Wunderbaum - ext-dnd
 * Copyright (c) 2021-2023, Martin Wendt. Released under the MIT license.
 * v0.7.0, Sat, 09 Dec 2023 13:47:27 GMT (https://github.com/mar10/wunderbaum)
 */const nodeMimeType="application/x-wunderbaum-node";class DndExtension extends WunderbaumExtension{constructor(e){super(e,"dnd",{autoExpandMS:1500,multiSource:!1,effectAllowed:"all",dropEffectDefault:"move",guessDropEffect:!0,preventForeignNodes:!1,preventLazyParents:!0,preventNonNodes:!1,preventRecursion:!0,preventSameParent:!1,preventVoidMoves:!0,serializeClipboardData:!0,scroll:!0,scrollSensitivity:20,scrollSpeed:5,sourceCopyHook:null,dragStart:null,drag:null,dragEnd:null,dragEnter:null,dragOver:null,dragExpand:null,drop:null,dragLeave:null}),this.srcNode=null,this.lastTargetNode=null,this.lastEnterStamp=0,this.lastAllowedDropRegions=null,this.lastDropEffect=null,this.lastDropRegion=!1,this.currentScrollDir=0,this.applyScrollDirThrottled=throttle(this._applyScrollDir,50)}init(){super.init();const e=this.tree,t=e.options.dnd;t.dragStart&&onEvent(e.element,"dragstart drag dragend",this.onDragEvent.bind(this)),t.dragEnter&&onEvent(e.element,"dragenter dragover dragleave drop",this.onDropEvent.bind(this))}_leaveNode(){const e=this.lastTargetNode;this.lastEnterStamp=0,e&&(e.setClass("wb-drop-target wb-drop-over wb-drop-after wb-drop-before",!1),this.lastTargetNode=null)}unifyDragover(e){if(!1===e)return!1;if(e instanceof Set)return e.size>0&&e;if(!0===e)return new Set(["over","before","after"]);if("string"==typeof e||isArray(e))return(e=toSet(e)).size>0&&e;throw new Error("Unsupported drop region definition: "+e)}_calcDropRegion(e,t){const s=e.offsetY;return!!t&&(3===t.size?s<5.5?"before":s>16.5?"after":"over":1===t.size&&t.has("over")?"over":s>11?"after":"before")}_guessDropEffect(e){var t;const s=this.treeOpts.dnd,i=null!==(t=s.effectAllowed)&&void 0!==t?t:"all",n=["all","copy","copyLink","copyMove"].includes(i),r=["all","link","copyLink","linkMove"].includes(i),o=["all","move","copyMove","linkMove"].includes(i);let l=s.dropEffectDefault;return s.guessDropEffect&&(isMac?(e.altKey&&n&&(l="copy"),e.metaKey&&o&&(l="move"),e.altKey&&e.metaKey&&r&&(l="link")):(e.ctrlKey&&n&&(l="copy"),e.shiftKey&&o&&(l="move"),e.altKey&&r&&(l="link"))),l}_isVoidDrop(e,t,s){return!(!this.treeOpts.dnd.preventVoidMoves||!t)&&("before"===s&&e===t.getNextSibling()||"after"===s&&e===t.getPrevSibling()||(t===e||t.parent===e))}_applyScrollDir(){if(this.isDragging()&&this.currentScrollDir){const e=this.tree.options.dnd,t=this.tree.element,s=t.scrollTop;this.currentScrollDir<0?t.scrollTop=Math.max(0,s-e.scrollSpeed):this.currentScrollDir>0&&(t.scrollTop=s+e.scrollSpeed)}}_autoScroll(e){const t=this.tree,s=t.options.dnd.scrollSensitivity,i=t.element,n=t.headerElement.clientHeight,r=i.offsetHeight,o=i.scrollTop;return this.currentScrollDir=0,o>0&&e>0&&e<=s+n?this.currentScrollDir=-1:o<i.scrollHeight-r&&e>=r-s&&(this.currentScrollDir=1),this.currentScrollDir&&this.applyScrollDirThrottled(),i.scrollTop-o}isDragging(){return!!this.srcNode}onDragEvent(e){var t;const s=this.treeOpts.dnd,i=Wunderbaum.getNode(e);if(i){if(["dragstart","dragend"].includes(e.type)&&this.tree.logDebug(`onDragEvent.${e.type} srcNode: ${i}`,e),"dragstart"===e.type){if(e.dataTransfer.effectAllowed=s.effectAllowed,i.isEditing())return i.logDebug("Prevented dragging node in edit mode."),e.preventDefault(),!1;if(!i._callEvent("dnd.dragStart",{event:e}))return e.preventDefault(),!1;const n=i.toDict(!0,(e=>{e._orgKey=e.key,delete e.key}));n._treeId=i.tree.id,s.serializeClipboardData&&("function"==typeof s.serializeClipboardData?e.dataTransfer.setData(nodeMimeType,s.serializeClipboardData(n,i)):e.dataTransfer.setData(nodeMimeType,JSON.stringify(n))),(null===(t=e.dataTransfer)||void 0===t?void 0:t.types.includes("text/plain"))||e.dataTransfer.setData("text/plain",i.title),this.srcNode=i,setTimeout((()=>{i.setClass("wb-drag-source")}),0)}else"drag"===e.type?s.drag&&i._callEvent("dnd.drag",{event:e}):"dragend"===e.type&&(i.setClass("wb-drag-source",!1),this.srcNode=null,this.lastTargetNode&&this._leaveNode(),i._callEvent("dnd.dragEnd",{event:e}));return!0}this.tree.logWarn(`onDragEvent.${e.type} no node`)}onDropEvent(e){var t;const s=this.srcNode,i=s?s.tree:null,n=Wunderbaum.getNode(e),r=this.treeOpts.dnd,o=e.dataTransfer,l=this._calcDropRegion(e,this.lastAllowedDropRegions);if(n){if(["drop"].includes(e.type)&&this.tree.logDebug(`onDropEvent.${e.type} targetNode: ${n}, ea: ${null==o?void 0:o.effectAllowed}, de: ${null==o?void 0:o.dropEffect}, cy: ${e.offsetY}, r: ${l}, srcNode: ${s}`,e),"dragenter"===e.type){if(this.lastAllowedDropRegions=null,this.lastTargetNode&&this.lastTargetNode!==n&&this._leaveNode(),this.lastTargetNode=n,this.lastEnterStamp=Date.now(),n.isStatusNode()||r.preventForeignNodes&&n.tree!==i||r.preventLazyParents&&!n.isLoaded()||r.preventNonNodes&&!s||r.preventRecursion&&(null==s?void 0:s.isAncestorOf(n))||r.preventSameParent&&s&&n.parent===s.parent||r.preventVoidMoves&&n===s)return o.dropEffect="none",this.tree.log("Prevented drop operation"),!0;o.dropEffect=this._guessDropEffect(e)||"none";let t=n._callEvent("dnd.dragEnter",{event:e});return t=this.unifyDragover(t),t?(this.lastAllowedDropRegions=t,this.lastDropEffect=o.dropEffect,n.setClass("wb-drop-target"),e.preventDefault(),!1):(o.dropEffect="none",!0)}if("dragover"===e.type){const t=e.clientY-this.tree.element.offsetTop;this._autoScroll(t),o.dropEffect=this._guessDropEffect(e)||"none",n._callEvent("dnd.dragOver",{event:e});const i=this._calcDropRegion(e,this.lastAllowedDropRegions);if(this.lastDropRegion=i,this.lastDropEffect=o.dropEffect,r.autoExpandMS>0&&n.isExpandable(!0)&&!n._isLoading&&Date.now()-this.lastEnterStamp>r.autoExpandMS&&!1!==n._callEvent("dnd.dragExpand",{event:e})&&n.setExpanded(),!i||this._isVoidDrop(n,s,i))return;return n.setClass("wb-drop-over","over"===i),n.setClass("wb-drop-before","before"===i),n.setClass("wb-drop-after","after"===i),e.preventDefault(),!1}if("dragleave"===e.type)n._callEvent("dnd.dragLeave",{event:e});else if("drop"===e.type){e.stopPropagation(),e.preventDefault(),this._leaveNode();const s=this.lastDropRegion;let i=null===(t=e.dataTransfer)||void 0===t?void 0:t.getData(nodeMimeType);i=i?JSON.parse(i):null;const r=this.srcNode,o=this.lastDropEffect;setTimeout((()=>{n._callEvent("dnd.drop",{event:e,region:s,suggestedDropMode:"over"===s?"appendChild":s,suggestedDropEffect:o,sourceNode:r,sourceNodeData:i})}),10)}return!1}this._leaveNode()}}
/*!
 * Wunderbaum - drag_observer
 * Copyright (c) 2021-2023, Martin Wendt. Released under the MIT license.
 * v0.7.0, Sat, 09 Dec 2023 13:47:27 GMT (https://github.com/mar10/wunderbaum)
 */class DragObserver{constructor(e){if(this.start={x:0,y:0,altKey:!1,ctrlKey:!1,metaKey:!1,shiftKey:!1},this.dragElem=null,this.dragging=!1,this.events=["mousedown","mouseup","mousemove","keydown"],!e.root)throw new Error("Missing `root` option.");this.opts=Object.assign({thresh:5},e),this.root=e.root,this._handler=this.handleEvent.bind(this),this.events.forEach((e=>{this.root.addEventListener(e,this._handler)}))}disconnect(){this.events.forEach((e=>{this.root.removeEventListener(e,this._handler)}))}getDragElem(){return this.dragElem}isDragging(){return this.dragging}stopDrag(e){this.dragging&&this.opts.dragstop&&e&&(e.type="dragstop",this.opts.dragstop(e)),this.dragElem=null,this.dragging=!1}handleEvent(e){const t=e.type,s=this.opts,i={type:e.type,event:e,dragElem:this.dragElem,dx:e.pageX-this.start.x,dy:e.pageY-this.start.y,apply:void 0};switch(t){case"keydown":this.stopDrag(i);break;case"mousedown":if(this.dragElem){this.stopDrag(i);break}if(s.selector){let t=e.target;if(t.matches(s.selector))this.dragElem=t;else{if(t=t.closest(s.selector),!t)break;this.dragElem=t}}this.start.x=e.pageX,this.start.y=e.pageY,this.start.altKey=e.altKey,this.start.ctrlKey=e.ctrlKey,this.start.metaKey=e.metaKey,this.start.shiftKey=e.shiftKey;break;case"mousemove":if(!this.dragElem)break;if(!this.dragging){if(s.thresh){if(i.dx*i.dx+i.dy*i.dy<s.thresh*s.thresh)break}if(i.type="dragstart",!1===s.dragstart(i)){this.stopDrag(i);break}this.dragging=!0}this.dragging&&this.opts.drag&&(i.type="drag",this.opts.drag(i));break;case"mouseup":if(!this.dragging){this.stopDrag(i);break}0===e.button?i.apply=!0:i.apply=!1,this.stopDrag(i)}}}
/*!
 * Wunderbaum - ext-grid
 * Copyright (c) 2021-2023, Martin Wendt. Released under the MIT license.
 * v0.7.0, Sat, 09 Dec 2023 13:47:27 GMT (https://github.com/mar10/wunderbaum)
 */class GridExtension extends WunderbaumExtension{constructor(e){super(e,"grid",{}),this.observer=new DragObserver({root:window.document,selector:"span.wb-col-resizer",thresh:4,dragstart:e=>this.tree.element.contains(e.dragElem),drag:e=>this.handleDrag(e),dragstop:e=>this.handleDrag(e)})}init(){super.init()}handleDrag(e){const t=Wunderbaum.getEventInfo(e.event);this.tree.log(`${e.type}(${e.dx})`,e,t)}}
/*!
 * Wunderbaum - deferred
 * Copyright (c) 2021-2023, Martin Wendt. Released under the MIT license.
 * v0.7.0, Sat, 09 Dec 2023 13:47:27 GMT (https://github.com/mar10/wunderbaum)
 */class Deferred{constructor(){this._promise=new Promise(((e,t)=>{this._resolve=e,this._reject=t}))}resolve(e){this._resolve(e)}reject(e){this._reject(e)}promise(){return this._promise}then(e){return this._promise.then(e)}catch(e){return this._promise.catch(e)}finally(e){return this._promise.finally(e)}}
/*!
 * Wunderbaum - wunderbaum_node
 * Copyright (c) 2021-2023, Martin Wendt. Released under the MIT license.
 * v0.7.0, Sat, 09 Dec 2023 13:47:27 GMT (https://github.com/mar10/wunderbaum)
 */const NODE_PROPS=new Set(["checkbox","classes","expanded","icon","iconTooltip","key","lazy","_partsel","radiogroup","refKey","selected","statusNodeType","title","tooltip","type","unselectable"]),NODE_DICT_PROPS=new Set(NODE_PROPS);NODE_DICT_PROPS.delete("_partsel"),NODE_DICT_PROPS.delete("unselectable");class WunderbaumNode{constructor(e,t,s){var i,n;this.refKey=void 0,this.children=null,this.classes=null,this.data={},this._isLoading=!1,this._requestId=0,this._errorInfo=null,this._partsel=!1,this._partload=!1,this.subMatchCount=0,this._rowIdx=0,this._rowElem=void 0,assert(!t||t.tree===e,`Invalid parent: ${t}`),assert(!s.children,"'children' not allowed here"),this.tree=e,this.parent=t,this.key=""+(null!==(i=s.key)&&void 0!==i?i:++WunderbaumNode.sequence),this.title=""+(null!==(n=s.title)&&void 0!==n?n:"<"+this.key+">"),null!=s.refKey&&(this.refKey=""+s.refKey),null!=s.type&&(this.type=""+s.type),this.expanded=!0===s.expanded,null!=s.icon&&(this.icon=s.icon),this.lazy=!0===s.lazy,null!=s.statusNodeType&&(this.statusNodeType=""+s.statusNodeType),null!=s.colspan&&(this.colspan=!!s.colspan),null!=s.checkbox&&(this.checkbox=!!s.checkbox),null!=s.radiogroup&&(this.radiogroup=!!s.radiogroup),this.selected=!0===s.selected,!0===s.unselectable&&(this.unselectable=!0),s.classes&&this.setClass(s.classes);for(const[e,t]of Object.entries(s))NODE_PROPS.has(e)||(this.data[e]=t);t&&!this.statusNodeType&&e._registerNode(this)}toString(){return`WunderbaumNode@${this.key}<'${this.title}'>`}*[Symbol.iterator](){const e=this.children;if(e)for(let t=0,s=e.length;t<s;t++){const s=e[t];yield s,s.children&&(yield*s)}}_callEvent(e,t){return this.tree._callEvent(e,extend({node:this,typeInfo:this.type?this.tree.types[this.type]:{}},t))}addChildren(e,t){const s=this.tree;let{before:i=null,applyMinExpanLevel:n=!0,_level:r}=null!=t?t:{};null!=r||(r=this.getLevel());const o=[];try{s.enableUpdate(!1),isPlainObject(e)&&(e=[e]);const t=n&&r<s.options.minExpandLevel;for(const i of e){const e=i.children;delete i.children;const n=new WunderbaumNode(s,this,i);t&&!n.isUnloaded()&&(n.expanded=!0),o.push(n),e&&n.addChildren(e,{_level:r+1})}if(this.children)if(null==i||0===this.children.length)this.children=this.children.concat(o);else{i=this.findDirectChild(i);const e=this.children.indexOf(i);assert(e>=0,`options.before must be a direct child of ${this}`),this.children.splice(e,0,...o)}else this.children=o;s.update(ChangeType.structure)}finally{s.enableUpdate(!0)}return o[0]}addNode(e,t="appendChild"){switch("over"===t&&(t="appendChild"),t){case"after":return this.parent.addChildren(e,{before:this.getNextSibling()});case"before":return this.parent.addChildren(e,{before:this});case"prependChild":return this.addChildren(e,{before:0});case"appendChild":return this.addChildren(e)}assert(!1,`Invalid mode: ${t}`)}applyCommand(e,t){return this.tree.applyCommand(e,this,t)}collapseSiblings(e){for(const t of this.parent.children)t!==this&&t.expanded&&t.setExpanded(!1,e)}setClass(e,t=!0){const s=toSet(e);if(t)null===this.classes&&(this.classes=new Set),s.forEach((e=>{var s;this.classes.add(e),null===(s=this._rowElem)||void 0===s||s.classList.toggle(e,t)}));else{if(null===this.classes)return;s.forEach((e=>{var s;this.classes.delete(e),null===(s=this._rowElem)||void 0===s||s.classList.toggle(e,t)})),0===this.classes.size&&(this.classes=null)}}async expandAll(e=!0,t){const s=this.tree,i=this.tree.options.minExpandLevel,{depth:n=99,loadLazy:r,force:o,keepActiveNodeVisible:l=!0}=null!=t?t:{},a={scrollIntoView:!1,force:o,loadLazy:r};const d=s.logTime(`${this}.expandAll(${e})`);try{s.enableUpdate(!1),await async function t(s,n){var l;if(0===n)return;const d=null==n?null:n-1,c=[];return null===(l=s.children)||void 0===l||l.forEach((s=>{if(e)if(!s.expanded&&(s.children||r&&s.lazy)){const e=s.setExpanded(!0,a);c.push(e),e.then((async()=>{await t(s,d)}))}else c.push(t(s,d));else(!i||o||s.getLevel()>i)&&s.setExpanded(!1,a),t(s,d)})),new Promise((e=>{Promise.all(c).then((()=>{e(!0)}))}))}(this,n)}finally{s.enableUpdate(!0),s.logTimeEnd(d)}s.activeNode&&l&&s.activeNode.scrollIntoView()}findAll(e){const t="function"==typeof e?e:makeNodeTitleMatcher(e),s=[];return this.visit((e=>{t(e)&&s.push(e)})),s}findDirectChild(e){const t=this.children;if(!t)return null;if("string"==typeof e){for(let s=0,i=t.length;s<i;s++)if(t[s].key===e)return t[s]}else{if("number"==typeof e)return t[e];if(e.parent===this)return e}return null}findFirst(e){const t="function"==typeof e?e:makeNodeTitleMatcher(e);let s=null;return this.visit((e=>{if(t(e))return s=e,!1})),s}findRelatedNode(e,t=!1){return this.tree.findRelatedNode(this,e,t)}*format_iter(e,t){function s(e){const t=e.parent.children;return e===t[t.length-1]}null!=t||(t=["    "," |  "," ╰─ "," ├─ "]),null!=e||(e=e=>""+e);const i=i=>{const n=[e(i)];n.unshift(t[s(i)?2:3]);let r=i.parent;for(;r&&r!==this;)n.unshift(t[s(r)?0:1]),r=r.parent;return n.join("")};yield e(this);for(const e of this)yield i(e)}format(e,t){const s=[];for(const i of this.format_iter(e,t))s.push(i);return s.join("\n")}getColElem(e){var t;"string"==typeof e&&(e=this.tree.columns.findIndex((t=>t.id===e)));const s=null===(t=this._rowElem)||void 0===t?void 0:t.querySelectorAll("span.wb-col");return s?s[e]:null}getFirstChild(){return this.children?this.children[0]:null}getLastChild(){return this.children?this.children[this.children.length-1]:null}getLevel(){let e=0,t=this.parent;for(;t;)e++,t=t.parent;return e}getNextSibling(){const e=this.parent.children,t=e.indexOf(this);return e[t+1]||null}getParent(){return this.parent}getParentList(e=!1,t=!1){const s=[];let i=t?this:this.parent;for(;i;)(e||i.parent)&&s.unshift(i),i=i.parent;return s}getPath(e=!0,t="title",s="/"){let i;const n=[],r="function"==typeof t;return this.visitParents((e=>{e.parent&&(i=r?t(e):e[t],n.unshift(i))}),e),n.join(s)}getPrevSibling(){const e=this.parent.children,t=e.indexOf(this);return e[t-1]||null}hasChildren(){if(this.lazy){if(null==this.children)return;if(0===this.children.length)return!1;if(1===this.children.length&&this.children[0].isStatusNode())return;return!0}return!(!this.children||!this.children.length)}hasClass(e){return!!this.classes&&this.classes.has(e)}isActive(){return this.tree.activeNode===this}isAncestorOf(e){return e&&e.isDescendantOf(this)}isChildOf(e){return e&&this.parent===e}isColspan(){return!!this.getOption("colspan")}isDescendantOf(e){if(!e||e.tree!==this.tree)return!1;let t=this.parent;for(;t;){if(t===e)return!0;t===t.parent&&error(`Recursive parent link: ${t}`),t=t.parent}return!1}isExpandable(e=!1){return!(e&&this.expanded||!1===this.children)&&(null==this.children?!!this.lazy:0!==this.children.length||!!this.tree.options.emptyChildListExpandable)}isEditing(){return this.tree._callMethod("edit.isEditingTitle",this)}isExpanded(){return!!this.expanded}isFirstSibling(){const e=this.parent;return!e||e.children[0]===this}isLastSibling(){const e=this.parent;return!e||e.children[e.children.length-1]===this}isLazy(){return!!this.lazy}isLoaded(){return!this.lazy||void 0!==this.hasChildren()}isLoading(){return this._isLoading}isPagingNode(){return"paging"===this.statusNodeType}isParentOf(e){return e&&e.parent===this}isPartload(){return!!this._partload}isPartsel(){return!this.selected&&!!this._partsel}isRadio(){return!!this.parent.radiogroup||"radio"===this.getOption("checkbox")}isRendered(){return!!this._rowElem}isRootNode(){return this.tree.root===this}isSelected(){return!!this.selected||!!this._partsel&&void 0}isStatusNode(){return!!this.statusNodeType}isTopLevel(){return this.tree.root===this.parent}isUnloaded(){return void 0===this.hasChildren()}isVisible(){const e="hide"===this.tree.filterMode,t=this.getParentList(!1,!1);if(e&&!this.match&&!this.subMatchCount)return!1;for(let e=0,s=t.length;e<s;e++){if(!t[e].expanded)return!1}return!0}_loadSourceObject(e,t){var s;const i=this.tree;null!=t||(t=this.getLevel());const n=this._callEvent("receive",{response:e});null!=n&&(e=n),isArray(e)&&(e={children:e}),assert(isPlainObject(e),`Expected an array or plain object: ${e}`);const r=null!==(s=e.format)&&void 0!==s?s:"nested";assert("nested"===r||"flat"===r,`Expected source.format = 'nested' or 'flat': ${r}`),decompressSourceData(e),assert(e.children,"If `source` is an object, it must have a `children` property"),e.types&&(i.logInfo("Redefine types",e.columns),i.setTypes(e.types,!1),delete e.types),e.columns&&(i.logInfo("Redefine columns",e.columns),i.columns=e.columns,delete e.columns,i.update(ChangeType.colStructure)),this.addChildren(e.children);for(const[t,s]of Object.entries(e))RESERVED_TREE_SOURCE_KEYS.has(t)||(i.data[t]=s);"hier"===i.options.selectMode&&this.fixSelection3FromEndNodes(),this._callEvent("load")}async _fetchWithOptions(e){var t,s;let i,n,r,o,l,a={};"string"==typeof e?(i=e,a.method="GET"):isPlainObject(e)?(({url:i,params:n,body:r,options:o,...l}=e),assert(!l||0===Object.keys(l).length,`Unexpected source properties: ${Object.keys(l)}. Use 'options' instead.`),assert("string"==typeof i,"expected source.url as string"),isPlainObject(o)&&(a=o),isPlainObject(r)&&(assert(!a.body,"options.body should be passed as source.body"),a.body=JSON.stringify(a.body),null!==(t=a.method)&&void 0!==t||(a.method="POST")),isPlainObject(n)&&(i+="?"+new URLSearchParams(n),null!==(s=a.method)&&void 0!==s||(a.method="GET"))):(i="",error(`Unsupported source format: ${e}`)),this.setStatus(NodeStatusType.loading);const d=await fetch(i,a);return d.ok||error(`GET ${i} returned ${d.status}, ${d}`),await d.json()}async load(e){const t=this.tree,s=Date.now(),i=this.parent,n=Date.now();let r=0,o=0,l=0;this._requestId&&this.logWarn(`Recursive load request #${s} while #${this._requestId} is pending.`),this._requestId=s;try{if("string"==typeof e?e:e.url){const t=await this._fetchWithOptions(e);if(o=Date.now()-n,this._requestId&&this._requestId>s)return void this.logWarn(`Ignored load response #${s} because #${this._requestId} is pending.`);if(this.logDebug(`Received response for load request #${s}`),null===this.parent&&null!==i)return void this.logWarn("Lazy parent node was removed while loading: discarding response.");this.setStatus(NodeStatusType.ok);const r=Date.now();this._loadSourceObject(t),l=Date.now()-r}else{if("function"==typeof e.then){const s=t.logTime(`Resolve thenable ${e}`);e=await Promise.resolve(e),t.logTimeEnd(s)}this._loadSourceObject(e),l=Date.now()-n}}catch(t){throw this.logError("Error during load()",e,t),this._callEvent("error",{error:t}),this.setStatus(NodeStatusType.error,{message:""+t}),t}finally{this._requestId=0,r=Date.now()-n,t.options.debugLevel>=3&&t.logInfo(`Load source took ${r/1e3} seconds (transfer: ${o/1e3}s, processing: ${l/1e3}s)`)}}async loadLazy(e=!1){const t=this.expanded;if(assert(this.lazy,"load() requires a lazy node"),e||this.isUnloaded()){this.isLoaded()&&this.resetLazy(),this.setStatus(NodeStatusType.loading);try{const e=await this._callEvent("lazyLoad");if(!1===e)return void this.setStatus(NodeStatusType.ok);assert(isArray(e)||e&&e.url,"The lazyLoad event must return a node list, `{url: ...}`, or false."),await this.load(e),this.setStatus(NodeStatusType.ok),t?(this.expanded=!0,this.tree.update(ChangeType.structure)):this.update()}catch(e){this.logError("Error during loadLazy()",e),this._callEvent("error",{error:e}),this.setStatus(NodeStatusType.error,{message:""+e})}}}log(...e){this.logDebug(...e)}logDebug(...e){this.tree.options.debugLevel>=4&&console.log(this.toString(),...e)}logError(...e){this.tree.options.debugLevel>=1&&console.error(this.toString(),...e)}logInfo(...e){this.tree.options.debugLevel>=3&&console.info(this.toString(),...e)}logWarn(...e){this.tree.options.debugLevel>=2&&console.warn(this.toString(),...e)}async makeVisible(e){let t;const s=new Deferred,i=[],n=this.getParentList(!1,!1),r=n.length,o=getOption(e,"noAnimation",!1),l=getOption(e,"scrollIntoView",!0);for(t=r-1;t>=0;t--){const e={noAnimation:o};i.push(n[t].setExpanded(!0,e))}return Promise.all(i).then((()=>{l&&this.tree?(this.tree.updatePendingModifications(),this.scrollIntoView().then((()=>{s.resolve()}))):s.resolve()})),s.promise()}moveTo(e,t="appendChild",s){let i;"over"===t&&(t="appendChild"),"prependChild"===t&&(e.children&&e.children.length?(t="before",e=e.children[0]):t="appendChild");const n=this.tree,r=this.parent,o="appendChild"===t?e:e.parent;if(this!==e){if(this.parent?o.isDescendantOf(this)&&error("Cannot move a node to its own descendant"):error("Cannot move system root"),o!==r&&r.triggerModifyChild("remove",this),1===this.parent.children.length){if(this.parent===o)return;this.parent.children=this.parent.lazy?[]:null,this.parent.expanded=!1}else i=this.parent.children.indexOf(this),assert(i>=0,"invalid source parent"),this.parent.children.splice(i,1);if(this.parent=o,o.hasChildren())switch(t){case"appendChild":o.children.push(this);break;case"before":i=o.children.indexOf(e),assert(i>=0,"invalid target parent"),o.children.splice(i,0,this);break;case"after":i=o.children.indexOf(e),assert(i>=0,"invalid target parent"),o.children.splice(i+1,0,this);break;default:error(`Invalid mode '${t}'.`)}else o.children=[this];s&&e.visit(s,!0),o===r?o.triggerModifyChild("move",this):o.triggerModifyChild("add",this),n!==e.tree&&(this.logWarn("Cross-tree moveTo is experimental!"),this.visit((t=>{t.tree=e.tree}),!0)),setTimeout((()=>{n.update(ChangeType.any)}),0)}}async navigate(e,t){e=KEY_TO_ACTION_DICT[e]||e;const s=this.findRelatedNode(e);if(!s)return this.logWarn(`Could not find related node '${e}'.`),Promise.resolve(this);try{s.makeVisible({scrollIntoView:!1})}catch(e){}return s.setFocus(),!1===(null==t?void 0:t.activate)?Promise.resolve(this):s.setActive(!0,{event:null==t?void 0:t.event})}remove(){const e=this.tree,t=this.parent.children.indexOf(this);this.triggerModify("remove"),this.parent.children.splice(t,1),this.visit((t=>{t.removeMarkup(),e._unregisterNode(t)}),!0),e.update(ChangeType.structure)}removeChildren(){const e=this.tree;this.children&&(e.activeNode&&e.activeNode.isDescendantOf(this)&&e.activeNode.setActive(!1),e.focusNode&&e.focusNode.isDescendantOf(this)&&(e.focusNode=null),this.triggerModifyChild("remove",null),this.visit((t=>{e._unregisterNode(t)})),this.lazy?this.children=[]:this.children=null,this.isRootNode()||(this.expanded=!1),this.tree.update(ChangeType.structure))}removeMarkup(){this._rowElem&&(delete this._rowElem._wb_node,this._rowElem.remove(),this._rowElem=void 0)}_getRenderInfo(){const e={},t={},s=this.isColspan(),i=this._rowElem?this._rowElem.querySelectorAll("span.wb-col"):null;let n=0;for(const r of this.tree.columns)e[r.id]={id:r.id,idx:n,elem:i?i[n]:null,info:r},s||"*"===r.id||(t[r.id]=e[r.id]),n++;return{allColInfosById:e,renderColInfosById:t}}_createIcon(e,t,s,i){let n,r=this.getOption("icon");if(this._errorInfo?r=e.error:this._isLoading&&i&&(r=e.loading),!1===r)return null;"string"==typeof r||(r=this.statusNodeType?e[this.statusNodeType]:this.expanded?e.folderOpen:this.children?e.folder:this.lazy?e.folderLazy:e.doc),r?r.indexOf("<")>=0?n=elemFromHtml(r):TEST_IMG.test(r)?n=elemFromHtml(`<i class="wb-icon" style="background-image: url('${r}');">`):(n=document.createElement("i"),n.className="wb-icon "+r):(n=document.createElement("i"),n.className="wb-icon"),s?t.replaceChild(n,s):t.appendChild(n);const o=this._callEvent("iconBadge",{iconSpan:n});let l=null;if(null!=o&&!1!==o){let e="",t="";isPlainObject(o)?(l=""+o.badge,e=o.badgeClass?" "+o.badgeClass:"",t=o.badgeTooltip?` title="${o.badgeTooltip}"`:""):l="number"==typeof o?""+o:o,"string"==typeof l&&(l=elemFromHtml(`<span class="wb-badge${e}"${t}>${escapeHtml(l)}</span>`)),l&&n.append(l)}return n}_render_markup(e){const t=this.tree,s=t.options,i=this.getOption("checkbox"),n=t.columns,r=this.getLevel(),o=t.isRowNav()?null:t.activeColIdx;let l,a=this._rowElem,d=null,c=null;const h=!a;assert(h,"Expected unrendered node"),assert(!h||e&&e.after,"opts.after expected, unless updating"),assert(!this.isRootNode(),"Root node not allowed"),a=document.createElement("div"),a.classList.add("wb-row"),a.style.top=22*this._rowIdx+"px",this._rowElem=a,a._wb_node=this;const u=document.createElement("span");u.classList.add("wb-node","wb-col"),a.appendChild(u);let p=0;i&&(d=document.createElement("i"),d.classList.add("wb-checkbox"),("radio"===i||this.parent.radiogroup)&&d.classList.add("wb-radio"),u.appendChild(d),p+=20);for(let e=r-1;e>0;e--)l=document.createElement("i"),l.classList.add("wb-indent"),u.appendChild(l),p+=20;(!s.minExpandLevel||r>s.minExpandLevel)&&(c=document.createElement("i"),c.classList.add("wb-expander"),u.appendChild(c),p+=20);this._createIcon(t.iconMap,u,null,!c)&&(p+=20);const f=document.createElement("span");f.classList.add("wb-title"),u.appendChild(f),u._ofsTitlePx=p,t.options.dnd.dragStart&&(u.draggable=!0);if(!this.isColspan()&&n.length>1){let e=0;for(const t of n){let s;e++,"*"===t.id?s=u:(s=document.createElement("span"),s.classList.add("wb-col"),a.appendChild(s)),e===o&&s.classList.add("wb-active"),t.classes&&s.classList.add(...t.classes.split(" ")),s.style.left=t._ofsPx+"px",s.style.width=t._widthPx+"px",h&&t.html&&"string"==typeof t.html&&(s.innerHTML=t.html)}}switch(e?e.after:"last"){case"first":t.nodeListElement.prepend(a);break;case"last":t.nodeListElement.appendChild(a);break;default:e.after.after(a)}e.isNew=!0,this._render_data(e)}_render_data(e){assert(this._rowElem,"No _rowElem");const t=this.tree,s=t.options,i=this._rowElem,n=!!e.isNew,r=!!e.preventScroll,o=t.columns,l=this.isColspan(),a=i.querySelector("span.wb-node"),d=a.querySelector("span.wb-title"),c=t.element.scrollTop;if(this.titleWithHighlight?d.innerHTML=this.titleWithHighlight:d.textContent=this.title,r&&(t.element.scrollTop=c),!s.skeleton)if(l){const e=t.element.clientWidth;d.style.width=e-a._ofsTitlePx-7+"px"}else d.style.width=o[0]._widthPx-a._ofsTitlePx-7+"px";if(e.isDataChange=!0,this._render_status(e),this.statusNodeType)this._callEvent("renderStatusNode",{isNew:n,nodeElem:a,isColspan:l});else if(this.parent){const e=this._getRenderInfo();this._callEvent("render",{isNew:n,nodeElem:a,isColspan:l,allColInfosById:e.allColInfosById,renderColInfosById:e.renderColInfosById})}}_render_status(e){const t=this.tree,s=t.iconMap,i=t.options,n=this.type?t.types[this.type]:null,r=this._rowElem,o=r.querySelector("span.wb-node"),l=o.querySelector("i.wb-expander"),a=o.querySelector("i.wb-checkbox"),d=["wb-row"];if(this.expanded&&d.push("wb-expanded"),this.lazy&&d.push("wb-lazy"),this.selected&&d.push("wb-selected"),this._partsel&&d.push("wb-partsel"),this===t.activeNode&&d.push("wb-active"),this===t.focusNode&&d.push("wb-focus"),this._errorInfo&&d.push("wb-error"),this._isLoading&&d.push("wb-loading"),this.isColspan()&&d.push("wb-colspan"),this.statusNodeType&&d.push("wb-status-"+this.statusNodeType),this.match&&d.push("wb-match"),this.subMatchCount&&d.push("wb-submatch"),i.skeleton&&d.push("wb-skeleton"),r.className=d.join(" "),this.classes&&r.classList.add(...this.classes),n&&n.classes&&r.classList.add(...n.classes),l){let e=null;this._isLoading?e=s.loading:this.isExpandable(!1)?e=this.expanded?s.expanderExpanded:s.expanderCollapsed:this.lazy&&null==this.children&&(e=s.expanderLazy),null==e?l.classList.add("wb-indent"):TEST_IMG.test(e)?l.style.backgroundImage=`url('${e}')`:l.className="wb-expander "+e}if(a){let e="wb-checkbox ";this.isRadio()?(e+="wb-radio ",this.selected?e+=s.radioChecked:e+=s.radioUnchecked):this.selected?e+=s.checkChecked:this._partsel?e+=s.checkUnknown:e+=s.checkUnchecked,a.className=e}if(!e.isNew){let e=0;for(const s of r.children)s.classList.toggle("wb-active",e++===t.activeColIdx);const s=o.querySelector("i.wb-icon");s&&this._createIcon(t.iconMap,o,s,!l)}if(!1!==e.resizeCols&&!this.isColspan()){const e=r.querySelectorAll("span.wb-col");let t=0,s=0;for(const i of this.tree.columns){const n=e[t];n.style.left=`${s}px`,n.style.width=`${i._widthPx}px`,t++,s+=i._widthPx}}}_render(e){const t=Object.assign({change:ChangeType.data},e);switch(this._rowElem||(t.change=ChangeType.row),t.change){case"status":this._render_status(t);break;case"data":this._render_data(t);break;case"row":this._render_markup(t);break;default:error(`Invalid change type '${t.change}'.`)}}resetLazy(){this.removeChildren(),this.expanded=!1,this.lazy=!0,this.children=null,this.tree.update(ChangeType.structure)}toDict(e=!1,t){const s={};if(NODE_DICT_PROPS.forEach((e=>{const t=this[e];t instanceof Set?t.size&&(s[e]=Array.prototype.join.call(t.keys()," ")):(t||!1===t||0===t)&&(s[e]=t)})),isEmptyObject(this.data)||(s.data=extend({},this.data),isEmptyObject(s.data)&&delete s.data),t){const i=t(s,this);if(!1===i)return!1;"skip"===i&&(e=!1)}if(e&&isArray(this.children)){s.children=[];for(let e=0,i=this.children.length;e<i;e++){const i=this.children[e];if(!i.isStatusNode()){const e=i.toDict(!0,t);!1!==e&&s.children.push(e)}}}return s}getOption(e,t){const s=this.tree;let i=s.options;e.indexOf(".")>=0&&([i,e]=e.split("."));const n=i[e];if("function"==typeof n){const e=n.call(s,{type:"resolve",tree:s,node:this});if(void 0!==e)return e}if(void 0!==this[e])return this[e];const r=this.type?s.types[this.type]:void 0,o=r?r[e]:void 0;return void 0!==o?o:null!=n?n:t}async scrollIntoView(e){const t=Object.assign({node:this},e);return this.tree.scrollTo(t)}async setActive(e=!0,t){const s=this.tree,i=s.activeNode,n=null==t?void 0:t.retrigger,r=null==t?void 0:t.focusTree,o=!1!==(null==t?void 0:t.focusNode),l=null==t?void 0:t.noEvents,a=null==t?void 0:t.event;if(!l)if(e){if(i!==this||n){if(!1===(null==i?void 0:i._callEvent("deactivate",{nextNode:this,event:a}))||!1===this._callEvent("beforeActivate",{prevNode:i,event:a}))return;s.activeNode=null,null==i||i.update(ChangeType.status)}}else(i===this||n)&&this._callEvent("deactivate",{nextNode:null,event:a});return i!==this&&(e&&(s.activeNode=this,(o||r)&&(s.focusNode=this),r&&s.setFocus()),null==i||i.update(ChangeType.status),this.update(ChangeType.status)),t&&null!=t.colIdx&&t.colIdx!==s.activeColIdx&&s.isCellNav()&&s.setColumn(t.colIdx),e&&!l&&this._callEvent("activate",{prevNode:i,event:a}),this.makeVisible()}async setExpanded(e=!0,t){const{force:s,scrollIntoView:i,immediate:n}=null!=t?t:{};if(!e&&this.isExpanded()&&this.getLevel()<=this.tree.getOption("minExpandLevel")&&!s)return void this.logDebug("Ignored collapse request below expandLevel.");if(!e==!this.expanded)return;e&&this.getOption("autoCollapse")&&this.collapseSiblings(t),e&&this.lazy&&null==this.children&&await this.loadLazy(),this.expanded=e;const r={immediate:n};if(this.tree.update(ChangeType.structure,r),e&&i){const e=this.getLastChild();e&&(this.tree.updatePendingModifications(),e.scrollIntoView({topNode:this}))}}setFocus(e=!0){assert(!!e,"blur is not yet implemented");const t=this.tree.focusNode;this.tree.focusNode=this,null==t||t.update(),this.update()}setIcon(e){this.icon=e,this.update()}setKey(e,t){throw new Error("Not yet implemented")}update(e=ChangeType.data){assert(e===ChangeType.status||e===ChangeType.data,`Invalid change type ${e}`),this.tree.update(e,this)}getSelectedNodes(e=!1){const t=[];return this.visit((s=>{if(s.selected&&(t.push(s),!0===e))return"skip"})),t}toggleSelected(e){let t=this.isSelected();return t=void 0!==t||this.isRadio()?!t:this._anySelectable(),this.setSelected(t,e)}_anySelectable(){let e=!1;return this.visit((t=>{if(!1===t.selected&&!t.unselectable&&!t.hasChildren()&&!t.parent.radiogroup)return e=!0,!1})),e}_changeSelectStatusProps(e){let t=!1;switch(e){case!1:t=this.selected||this._partsel,this.selected=!1,this._partsel=!1;break;case!0:t=!this.selected||!this._partsel,this.selected=!0,this._partsel=!0;break;case void 0:t=this.selected||!this._partsel,this.selected=!1,this._partsel=!0;break;default:error(`Invalid state: ${e}`)}return t&&this.update(),t}fixSelection3AfterClick(e){const t=!!(null==e?void 0:e.force),s=this.isSelected();this.visit((e=>{if(e.radiogroup)return"skip";!t&&e.getOption("unselectable")||e._changeSelectStatusProps(s)})),this.fixSelection3FromEndNodes()}fixSelection3FromEndNodes(e){const t=!!(null==e?void 0:e.force);assert("hier"===this.tree.options.selectMode,"expected selectMode 'hier'");const s=e=>{let i;const n=e.children;if(n&&n.length){let e=!0,t=!1;for(let i=0,r=n.length;i<r;i++){const r=n[i],o=s(r);!1!==o&&(t=!0),!0!==o&&(e=!1)}i=!!e||!!t&&void 0}else i=!!e.selected;return e._partsel&&!e.selected&&e.lazy&&null==e.children&&(i=void 0),!t&&e.getOption("unselectable")||e._changeSelectStatusProps(i),i};s(this),this.visitParents((e=>{let t;const s=e.children;let i=!0,n=!1;for(let e=0,r=s.length;e<r;e++){const r=s[e];t=!!r.selected,(t||r._partsel)&&(n=!0),t||(i=!1)}t=!!i||!!n&&void 0,e._changeSelectStatusProps(t)}))}setSelected(e=!0,t){const s=this.tree,i=!(null==t?void 0:t.noEvents),n=this.isSelected(),r=this.parent&&this.parent.radiogroup,o=s.options.selectMode,l=(null==t?void 0:t.force)||!this.getOption("unselectable");return e=!!e,l?(null==t?void 0:t.propagateDown)&&"multi"===o?(s.runWithDeferredUpdate((()=>{this.visit((t=>{t.setSelected(e)}))})),n):(e===n||i&&!1===this._callEvent("beforeSelect",{flag:e})||(s.runWithDeferredUpdate((()=>{if(r){if(!e&&!(null==t?void 0:t.force))return n;for(const e of this.parent.children)e.selected=e===this}else this.selected=e,"hier"===o?this.fixSelection3AfterClick():"single"===o&&s.visit((e=>{e.selected=!1}))})),i&&this._callEvent("select",{flag:e})),n):n}setStatus(e,t){const s=this.tree,i=null==t?void 0:t.message,n=null==t?void 0:t.details;let r=null;const o=e=>{const t=this.children,i=t?t[0]:null;return assert(e.statusNodeType,"Not a status node"),assert(!i||!i.isStatusNode(),"Child must not be a status node"),r=this.addNode(e,"prependChild"),r.match=!0,s.update(ChangeType.structure),r};switch((()=>{const e=this.children;e&&e.length&&e[0].isStatusNode()&&e[0].remove()})(),e){case"ok":this._isLoading=!1,this._errorInfo=null;break;case"loading":this._isLoading=!0,this._errorInfo=null,this.parent?this.update(ChangeType.status):o({statusNodeType:e,title:s.options.strings.loading+(i?" ("+i+")":""),checkbox:!1,colspan:!0,tooltip:n});break;case"error":o({statusNodeType:e,title:s.options.strings.loadError+(i?" ("+i+")":""),checkbox:!1,colspan:!0,tooltip:n}),this._isLoading=!1,this._errorInfo={message:i,details:n};break;case"noData":o({statusNodeType:e,title:i||s.options.strings.noData,checkbox:!1,colspan:!0,tooltip:n}),this._isLoading=!1,this._errorInfo=null;break;default:error("invalid node status "+e)}return s.update(ChangeType.structure),r}setTitle(e){this.title=e,this.update()}_sortChildren(e,t){const s=this.children;if(s&&(s.sort(e),t))for(let i=0,n=s.length;i<n;i++)s[i].children&&s[i]._sortChildren(e,t)}sortChildren(e=nodeTitleSorter,t=!1){this._sortChildren(e||nodeTitleSorter,t),this.tree.update(ChangeType.structure)}triggerModifyChild(e,t,s){this.logDebug(`modifyChild(${e})`,s,t),this.tree.options.modifyChild&&(t&&t.parent!==this&&error("child "+t+" is not a child of "+this),this._callEvent("modifyChild",extend({operation:e,child:t},s)))}triggerModify(e,t){this.parent.triggerModifyChild(e,this,t)}visit(e,t=!1){let s=!0;const i=this.children;if(!0===t&&(s=e(this),!1===s||"skip"===s))return s;if(i)for(let t=0,n=i.length;t<n&&(s=i[t].visit(e,!0),!1!==s);t++);return s}visitParents(e,t=!1){if(t&&!1===e(this))return!1;let s=this.parent;for(;s;){if(!1===e(s))return!1;s=s.parent}return!0}visitSiblings(e,t=!1){const s=this.parent.children;for(let i=0,n=s.length;i<n;i++){const n=s[i];if((t||n!==this)&&!1===e(n))return!1}return!0}isMatched(){return!(this.tree.filterMode&&!this.match)}}WunderbaumNode.sequence=0;
/*!
 * Wunderbaum - ext-edit
 * Copyright (c) 2021-2023, Martin Wendt. Released under the MIT license.
 * v0.7.0, Sat, 09 Dec 2023 13:47:27 GMT (https://github.com/mar10/wunderbaum)
 */
class EditExtension extends WunderbaumExtension{constructor(e){super(e,"edit",{debounce:100,minlength:1,maxlength:null,trigger:[],trim:!0,select:!0,slowClickDelay:1e3,validity:!0,beforeEdit:null,edit:null,apply:null}),this.curEditNode=null,this.relatedNode=null,this.debouncedOnChange=debounce(this._onChange.bind(this),this.getPluginOption("debounce"))}_applyChange(e,t,s,i){let n;t.log(`_applyChange(${e})`,i),s.classList.add("wb-busy"),s.classList.remove("wb-error");try{n=t._callEvent(e,i)}catch(i){t.logError(`Error in ${e} event handler`,i),s.classList.add("wb-error"),s.classList.remove("wb-busy")}return n instanceof Promise||(n=Promise.resolve(n)),n.catch((i=>{t.logError(`Error in ${e} event promise`,i),s.classList.add("wb-error")})).finally((()=>{s.classList.remove("wb-busy")})),n}_onChange(e){const t=Wunderbaum.getEventInfo(e),s=t.node,i=t.colElem;s&&0!==t.colIdx?this._applyChange("change",s,i,{info:t,event:e,inputElem:e.target,inputValue:Wunderbaum.util.getValueFromElem(e.target)}):this.tree.log("Ignored change event for removed element or node title")}init(){super.init(),onEvent(this.tree.element,"change",".contenteditable,input,textarea,select",(e=>this._onChange(e)))}_preprocessKeyEvent(e){const t=e.event,s=eventToString(t),i=this.tree,n=this.getPluginOption("trigger");if(this.isEditingTitle()){switch(s){case"Enter":return this._stopEditTitle(!0,{event:t}),!1;case"Escape":return this._stopEditTitle(!1,{event:t}),!1}return!1}if(i.isRowNav()||0===i.activeColIdx){switch(s){case"Enter":if(n.indexOf("macEnter")>=0&&isMac)return this.startEditTitle(),!1;break;case"F2":if(n.indexOf("F2")>=0)return this.startEditTitle(),!1}return!0}return!0}isEditingTitle(e){return e?this.curEditNode===e:!!this.curEditNode}startEditTitle(e){e=null!=e?e:this.tree.getActiveNode();const t=this.getPluginOption("validity"),s=this.getPluginOption("select");if(!e)return;this.tree.logDebug(`startEditTitle(node=${e})`);let i=e._callEvent("edit.beforeEdit");if(!1===i)return void e.logInfo("beforeEdit canceled operation.");if(!0===i||!i){i=`<input type=text class="wb-input-edit" tabindex=-1 value="${escapeHtml(e.title)}" required autocorrect=off>`}const n=e.getColElem(0).querySelector(".wb-title");n.innerHTML=i;const r=n.firstElementChild;t&&r.addEventListener("keydown",(e=>{r.setCustomValidity(""),r.reportValidity()})),r.focus(),s&&r.select(),this.curEditNode=e,e._callEvent("edit.edit",{inputElem:r})}stopEditTitle(e){return this._stopEditTitle(e,{})}_stopEditTitle(e,t){null!=t||(t={});const s=document.activeElement;let i=s?getValueFromElem(s):null;const n=this.curEditNode,r=!!t.forceClose,o=this.getPluginOption("validity");if(i&&this.getPluginOption("trim")&&(i=i.trim()),n)if(n.logDebug(`stopEditTitle(${e})`,t,s,i),e&&null!==i&&i!==n.title){const e=s.validationMessage;if(e)throw new Error(`Input validation failed for "${i}": ${e}.`);const t=n.getColElem(0);this._applyChange("edit.apply",n,t,{oldValue:n.title,newValue:i,inputElem:s}).then((e=>{const t=s.validationMessage;if(o&&t&&!1!==e)throw new Error(`Edit apply validation failed for "${i}": ${t}.`);(r||!1!==e)&&(null==n||n.setTitle(i),this.curEditNode._render({preventScroll:!0}),this.curEditNode=null,this.relatedNode=null,this.tree.setFocus())})).catch((e=>{n.logError(e)}))}else this.curEditNode._render({preventScroll:!0}),this.curEditNode=null,this.relatedNode=null,this.tree.setFocus();else this.tree.logDebug("stopEditTitle: not in edit mode.")}createNode(e="after",t,s){const i=this.tree;if(assert(t=null!=t?t:i.getActiveNode(),"No node was passed, or no node is currently active."),e=e||"prependChild",null==s?s={title:""}:"string"==typeof s?s={title:s}:assert(isPlainObject(s),`Expected a plain object: ${s}`),("prependChild"===e||"appendChild"===e)&&(null==t?void 0:t.isExpandable(!0)))return void t.setExpanded().then((()=>{this.createNode(e,t,s)}));const n=t.addNode(s,e);n.setClass("wb-edit-new"),this.relatedNode=t,n.match=!0,n.makeVisible({noAnimation:!0}).then((()=>{this.startEditTitle(n)}))}}
/*!
 * wunderbaum.ts
 *
 * A treegrid control.
 *
 * Copyright (c) 2021-2023, Martin Wendt (https://wwWendt.de).
 * https://github.com/mar10/wunderbaum
 *
 * Released under the MIT license.
 * @version v0.7.0
 * @date Sat, 09 Dec 2023 13:47:27 GMT
 */class WbSystemRoot extends WunderbaumNode{constructor(e){super(e,null,{key:"__root__",title:e.id})}toString(){return`WbSystemRoot@${this.key}<'${this.tree.id}'>`}}class Wunderbaum{constructor(e){this.enabled=!0,this.data={},this.extensionList=[],this.extensions={},this.keyMap=new Map,this.refKeyMap=new Map,this.treeRowCount=0,this._disableUpdateCount=0,this._disableUpdateIgnoreCount=0,this.activeNode=null,this.focusNode=null,this.types={},this.columns=[],this._columnsById={},this.pendingChangeTypes=new Set,this._util=util,this.filterMode=null,this.activeColIdx=0,this._cellNavMode=!1,this.lastQuicksearchTime=0,this.lastQuicksearchTerm="",this.lastClickTime=0,this.log=this.logDebug;const t=this.options=extend({id:null,source:null,element:null,debugLevel:3,header:null,rowHeightPx:22,iconMap:"bootstrap",columns:null,types:null,enabled:!0,fixedCol:!1,showSpinner:!1,checkbox:!1,minExpandLevel:0,emptyChildListExpandable:!1,skeleton:!1,connectTopBreadcrumb:null,selectMode:"multi",navigationModeOption:null,quicksearch:!0,iconBadge:null,change:null,error:null,receive:null,strings:{loadError:"Error",loading:"Loading...",noData:"No data"}},e),s=new Deferred;this.ready=s.promise();let i=!1;if(this.ready.then((()=>{i=!0;try{this._callEvent("init")}catch(e){this.logError("Exception inside `init(e)` event:",e)}})).catch((e=>{if(i)throw e;this._callEvent("init",{error:e})})),this.id=t.id||"wb_"+ ++Wunderbaum.sequence,this.root=new WbSystemRoot(this),this._registerExtension(new KeynavExtension(this)),this._registerExtension(new EditExtension(this)),this._registerExtension(new FilterExtension(this)),this._registerExtension(new DndExtension(this)),this._registerExtension(new GridExtension(this)),this._registerExtension(new LoggerExtension(this)),this._updateViewportThrottled=adaptiveThrottle(this._updateViewportImmediately.bind(this),{}),this.columns=t.columns,delete t.columns,!this.columns||!this.columns.length){const e="string"==typeof t.header?t.header:this.id;this.columns=[{id:"*",title:e,width:"*"}]}t.types&&this.setTypes(t.types,!0),delete t.types,this.element=elemFromSelector(t.element),assert(!!this.element,`Invalid 'element' option: ${t.element}`),this.element.classList.add("wunderbaum"),this.element.getAttribute("tabindex")||(this.element.tabIndex=0),this.element._wb_tree=this,this.headerElement=this.element.querySelector("div.wb-header");const n=null==t.header?this.columns.length>1:!!t.header;if(this.headerElement){assert(!this.columns,"`opts.columns` must not be set if markup already contains a header"),this.columns=[];const e=this.headerElement.querySelector("div.wb-row");for(const t of e.querySelectorAll("div"))this.columns.push({id:t.dataset.id||`col_${this.columns.length}`,title:""+t.textContent,width:"*"})}else{const e="<span class='wb-col'></span>".repeat(this.columns.length);if(this.element.innerHTML=`\n        <div class='wb-header'>\n          <div class='wb-row'>\n            ${e}\n          </div>\n        </div>`,!n){this.element.querySelector("div.wb-header").style.display="none"}}this.element.innerHTML+='\n      <div class="wb-list-container">\n        <div class="wb-node-list"></div>\n      </div>',this.listContainerElement=this.element.querySelector("div.wb-list-container"),this.nodeListElement=this.listContainerElement.querySelector("div.wb-node-list"),this.headerElement=this.element.querySelector("div.wb-header"),this.element.classList.toggle("wb-grid",this.columns.length>1),this._initExtensions(),["enabled","fixedCol"].forEach((e=>{null!=t[e]&&this.setOption(e,t[e])})),t.source?(t.showSpinner&&(this.nodeListElement.innerHTML="<progress class='spinner'>loading...</progress>"),this.load(t.source).then((()=>{null==t.navigationModeOption?this.isGrid()?this.setNavigationOption(NavModeEnum.cell):this.setNavigationOption(NavModeEnum.row):this.setNavigationOption(t.navigationModeOption),s.resolve()})).catch((e=>{s.reject(e)})).finally((()=>{var e;null===(e=this.element.querySelector("progress.spinner"))||void 0===e||e.remove(),this.element.classList.remove("wb-initializing")}))):s.resolve(),this.update(ChangeType.any),this.element.addEventListener("scroll",(e=>{this.update(ChangeType.scroll)})),this.resizeObserver=new ResizeObserver((e=>{this.update(ChangeType.resize)})),this.resizeObserver.observe(this.element),onEvent(this.nodeListElement,"click","div.wb-row",(t=>{const s=Wunderbaum.getEventInfo(t),i=s.node,n=t;if(!1===this._callEvent("click",{event:t,node:i,info:s}))return this.lastClickTime=Date.now(),!1;if(i){if(n.ctrlKey)return void i.toggleSelected();const r=this.getOption("edit.trigger"),o=this.getOption("edit.slowClickDelay");r.indexOf("clickActive")>=0&&"title"===s.region&&i.isActive()&&(!o||Date.now()-this.lastClickTime<o)&&this._callMethod("edit.startEditTitle",i),s.colIdx>=0?i.setActive(!0,{colIdx:s.colIdx,event:t}):i.setActive(!0,{event:t}),s.region===NodeRegion.expander?i.setExpanded(!i.isExpanded(),{scrollIntoView:!1!==e.scrollIntoViewOnExpandClick}):s.region===NodeRegion.checkbox&&i.toggleSelected()}this.lastClickTime=Date.now()})),onEvent(this.nodeListElement,"dblclick","div.wb-row",(e=>{const t=Wunderbaum.getEventInfo(e),s=t.node;if(!1===this._callEvent("dblclick",{event:e,node:s,info:t}))return!1;s&&0===t.colIdx&&s.isExpandable()&&(this._callMethod("edit._stopEditTitle"),s.setExpanded(!s.isExpanded()))})),onEvent(this.element,"keydown",(e=>{const t=Wunderbaum.getEventInfo(e),s=eventToString(e),i=t.node||this.getFocusNode();this._callHook("onKeyEvent",{event:e,node:i,info:t,eventName:s})})),onEvent(this.element,"focusin focusout",(e=>{const s="focusin"===e.type,i=Wunderbaum.getNode(e);this._callEvent("focus",{flag:s,event:e}),s&&this.isRowNav()&&!this.isEditing()&&(t.navigationModeOption===NavModeEnum.row?null==i||i.setActive():this.setCellNav()),s||this._callMethod("edit._stopEditTitle",!0,{event:e,forceClose:!0})}))}static getTree(e){if(e instanceof Wunderbaum)return e;if(e instanceof WunderbaumNode)return e.tree;if(void 0===e&&(e=0),"number"==typeof e)e=document.querySelectorAll(".wunderbaum")[e];else if("string"==typeof e){for(const t of document.querySelectorAll(".wunderbaum")){const s=t._wb_tree;if(s&&s.id===e)return s}if(!(e=document.querySelector(e)))return null}else e.target&&(e=e.target);return assert(e instanceof Element,`Invalid el type: ${e}`),e.matches(".wunderbaum")||(e=e.closest(".wunderbaum")),e&&e._wb_tree?e._wb_tree:null}get iconMap(){const e=this.options.iconMap;return"string"==typeof e?iconMaps[e]:e}static getNode(e){if(!e)return null;if(e instanceof WunderbaumNode)return e;for(void 0!==e.target&&(e=e.target);e;){if(e._wb_node)return e._wb_node;e=e.parentElement}return null}*[Symbol.iterator](){yield*this.root}_registerExtension(e){this.extensionList.push(e),this.extensions[e.id]=e}_initExtensions(){for(const e of this.extensionList)e.init()}_registerNode(e){const t=e.key;assert(null!=t&&!this.keyMap.has(t),`Missing or duplicate key: '${t}'.`),this.keyMap.set(t,e);const s=e.refKey;if(s){const t=this.refKeyMap.get(s);t?t.add(e):this.refKeyMap.set(s,new Set)}}_unregisterNode(e){const t=e.refKey;if(t){const s=this.refKeyMap.get(t);s&&s.delete(e)&&!s.size&&this.refKeyMap.delete(t)}e.tree=null,e.parent=null,e.removeMarkup()}_callHook(e,t={}){let s;const i=extend({},{tree:this,options:this.options,result:void 0},t);for(const t of this.extensionList){if(s=t[e].call(t,i),!1===s)break;void 0!==i.result&&(s=i.result)}return s}_callMethod(e,...t){const[s,i]=e.split("."),n=i?this.extensions[s]:this,r=n[i];if(r)return r.apply(n,t);this.logError(`Calling undefined method '${e}()'.`)}_callEvent(e,t){const[s,i]=e.split("."),n=this.options,r=i?n[s][i]:n[s];if(r)return r.call(this,extend({type:e,tree:this,util:this._util},t))}_getNodeByRowIdx(e){let t=null;return this.visitRows((s=>{if(s._rowIdx===e)return t=s,!1})),t}getTopmostVpNode(e=!0){const t=this.element.scrollTop;let s;return s=e?Math.ceil((t-1)/22):Math.floor(t/22),this._getNodeByRowIdx(s)}getLowestVpNode(e=!0){const t=this.element,s=this.headerElement.clientHeight,i=t.scrollTop,n=t.clientHeight-s;let r;return r=e?Math.floor((i+n)/22)-1:Math.ceil((i+n)/22)-1,r=Math.min(r,this.count(!0)-1),this._getNodeByRowIdx(r)}_getPrevNodeInView(e,t=1){return this.visitRows((s=>{if(e=s,t--<=0)return!1}),{reverse:!0,start:e||this.getActiveNode()}),e}_getNextNodeInView(e,t=1){return this.visitRows((s=>{if(e=s,t--<=0)return!1}),{reverse:!1,start:e||this.getActiveNode()}),e}addChildren(e,t){return this.root.addChildren(e,t)}applyCommand(e,t,s){let i,n;switch(t instanceof WunderbaumNode?i=t:(i=this.getActiveNode(),assert(void 0===s,`Unexpected options: ${s}`),s=t),e){case"moveUp":n=i.getPrevSibling(),n&&(i.moveTo(n,"before"),i.setActive());break;case"moveDown":n=i.getNextSibling(),n&&(i.moveTo(n,"after"),i.setActive());break;case"indent":n=i.getPrevSibling(),n&&(i.moveTo(n,"appendChild"),n.setExpanded(),i.setActive());break;case"outdent":i.isTopLevel()||(i.moveTo(i.getParent(),"after"),i.setActive());break;case"remove":n=i.getPrevSibling()||i.getParent(),i.remove(),n&&n.setActive();break;case"addChild":this._callMethod("edit.createNode","prependChild");break;case"addSibling":this._callMethod("edit.createNode","after");break;case"rename":this._callMethod("edit.startEditTitle");break;case"down":case"first":case"last":case"left":case"pageDown":case"pageUp":case"parent":case"right":case"up":return i.navigate(e);default:error(`Unhandled command: '${e}'`)}}clear(){this.root.removeChildren(),this.root.children=null,this.keyMap.clear(),this.refKeyMap.clear(),this.treeRowCount=0,this.activeNode=null,this.focusNode=null,this.update(ChangeType.structure)}destroy(){this.logInfo("destroy()..."),this.clear(),this.resizeObserver.disconnect(),this.element.innerHTML="",this.element.outerHTML=this.element.outerHTML}getOption(e,t){let s,i=this.options;e.indexOf(".")>=0&&([s,e]=e.split("."),i=i[s]);let n=i[e];return"function"==typeof n&&(n=n({type:"resolve",tree:this})),null!=n?n:t}setOption(e,t){if(e.indexOf(".")>=0){const s=e.split(".");this.extensions[s[0]].setPluginOption(s[1],t)}else switch(this.options[e]=t,e){case"checkbox":this.update(ChangeType.any);break;case"enabled":this.setEnabled(!!t);break;case"fixedCol":this.element.classList.toggle("wb-fixed-col",!!t)}}hasFocus(){return this.element.contains(document.activeElement)}hasHeader(){const e=this.options.header;return this.isGrid()?!1!==e:!!e}runWithDeferredUpdate(e,t=null){try{this.enableUpdate(!1);const t=e();return assert(!(t instanceof Promise),`Promise return not allowed: ${t}`),t}finally{this.enableUpdate(!0)}}async expandAll(e=!0,t){await this.root.expandAll(e,t)}selectAll(e=!0){return this.root.setSelected(e,{propagateDown:!0})}toggleSelect(){this.selectAll(this.root._anySelectable())}getSelectedNodes(e=!1){return this.root.getSelectedNodes(e)}_selectRange(e){this.logDebug("_selectRange",e),error("Not yet implemented.")}count(e=!1){return e?this.treeRowCount:this.keyMap.size}_check(){let e=0;this.visit((t=>{e++})),this.keyMap.size!==e&&this.logWarn(`_check failed: ${this.keyMap.size} !== ${e}`)}findAll(e){return this.root.findAll(e)}findFirst(e){return this.root.findFirst(e)}findKey(e){return this.keyMap.get(e)||null}findNextNode(e,t){let s=null;const i=this.getFirstChild(),n="string"==typeof e?makeNodeTitleStartMatcher(e):e;function r(e){if(n(e)&&(s=e),s||e===t)return!1}return t=t||i,this.visitRows(r,{start:t,includeSelf:!1}),s||t===i||this.visitRows(r,{start:i,includeSelf:!0}),s}findRelatedNode(e,t,s=!1){let i=null;const n=Math.floor(this.listContainerElement.clientHeight/22);switch(t){case"parent":case"left":e.parent&&e.parent.parent&&(i=e.parent);break;case"first":this.visit((e=>{if(e.isVisible())return i=e,!1}));break;case"last":this.visit((e=>{e.isVisible()&&(i=e)}));break;case"right":e.children&&e.children.length&&(i=e.children[0]);break;case"up":i=this._getPrevNodeInView(e);break;case"down":i=this._getNextNodeInView(e);break;case"pageDown":{const t=this.getLowestVpNode();i=e._rowIdx<t._rowIdx?t:this._getNextNodeInView(e,n)}break;case"pageUp":if(0===e._rowIdx)i=e;else{const t=this.getTopmostVpNode();i=e._rowIdx>t._rowIdx?t:this._getPrevNodeInView(e,n)}break;default:this.logWarn("Unknown relation '"+t+"'.")}return i}*format_iter(e,t){yield*this.root.format_iter(e,t)}format(e,t){return this.root.format(e,t)}getActiveColElem(){return this.activeNode&&this.activeColIdx>=0?this.activeNode.getColElem(this.activeColIdx):null}getActiveNode(){return this.activeNode}getFirstChild(){return this.root.getFirstChild()}getFocusNode(){return this.focusNode}static getEventInfo(e){const t=e.target,s=t.classList,i=t.closest("span.wb-col"),n=Wunderbaum.getNode(t),r=n?n.tree:Wunderbaum.getTree(e),o={event:e,canonicalName:eventToString(e),tree:r,node:n,region:NodeRegion.unknown,colDef:void 0,colIdx:-1,colId:void 0,colElem:i};if(s.contains("wb-title"))o.region=NodeRegion.title;else if(s.contains("wb-expander"))o.region=n.isExpandable()?NodeRegion.expander:NodeRegion.prefix;else if(s.contains("wb-checkbox"))o.region=NodeRegion.checkbox;else if(s.contains("wb-icon"))o.region=NodeRegion.icon;else if(s.contains("wb-node"))o.region=NodeRegion.title;else if(i){o.region=NodeRegion.column;const e=Array.prototype.indexOf.call(i.parentNode.children,i);o.colIdx=e}else{if(!s.contains("wb-row"))return"mousemove"===e.type||e instanceof KeyboardEvent||null==r||r.logWarn("getEventInfo(): not found",e,o),o;o.region=NodeRegion.title}return-1===o.colIdx&&(o.colIdx=0),o.colDef=null==r?void 0:r.columns[o.colIdx],null!=o.colDef&&(o.colId=o.colDef.id),o}toString(){return`Wunderbaum<'${this.id}'>`}isEditing(){return this._callMethod("edit.isEditingTitle")}isLoading(){let e=!1;return this.root.visit((t=>{if(t._isLoading||t._requestId)return e=!0,!1}),!0),e}logDebug(...e){this.options.debugLevel>=4&&console.log(this.toString(),...e)}logError(...e){this.options.debugLevel>=1&&console.error(this.toString(),...e)}logInfo(...e){this.options.debugLevel>=3&&console.info(this.toString(),...e)}logTime(e){return this.options.debugLevel>=4&&console.time(this+": "+e),e}logTimeEnd(e){this.options.debugLevel>=4&&console.timeEnd(this+": "+e)}logWarn(...e){this.options.debugLevel>=2&&console.warn(this.toString(),...e)}scrollTo(e){let t,s;e instanceof WunderbaumNode?t=e:(s=e,t=s.node),assert(t&&null!=t._rowIdx,`Invalid node: ${t}`);const i=this.element,n=this.headerElement.clientHeight,r=i.scrollTop,o=i.clientHeight,l=22*t._rowIdx+n,a=n,d=l-r,c=d+22,h=null==s?void 0:s.topNode;let u=null;d>=a?c<=o||(u=l+22-o+2):u=l-a-2,null!=u&&(this.log(`scrollTo(${l}): ${r} => ${u}`),i.scrollTop=u,h&&this.scrollTo(h))}scrollToHorz(){const e=this.columns[0]._widthPx,t=this.element.clientWidth,s=this.element.scrollLeft,i=this.getActiveColElem(),n=Number.parseInt(null==i?void 0:i.style.left,10),r=n+Number.parseInt(null==i?void 0:i.style.width,10);let o=s;n-s<e?o=n-e:r-s>t&&(o=r-t),o=Math.max(0,o),this.log(`scrollToHorz(${this.activeColIdx}): ${n}..${r}, fixedOfs=${e}, vpWidth=${t}, curLeft=${s} -> ${o}`),this.element.scrollLeft=o}setColumn(e){var t;if(assert(this.isCellNav(),"Exected cellNav mode"),assert(0<=e&&e<this.columns.length,`Invalid colIdx: ${e}`),this.activeColIdx=e,this.hasHeader())for(const t of this.headerElement.children){let s=0;for(const i of t.children)i.classList.toggle("wb-active",s++===e)}null===(t=this.activeNode)||void 0===t||t.update(ChangeType.status);for(const t of this.nodeListElement.children){let s=0;for(const i of t.children)i.classList.toggle("wb-active",s++===e)}this.scrollToHorz()}setActiveNode(e,t=!0,s){var i;null===(i=this.findKey(e))||void 0===i||i.setActive(t,s)}setFocus(e=!0){e?this.element.focus():this.element.blur()}update(e,t,s){if(this._disableUpdateCount)return void this._disableUpdateIgnoreCount++;t instanceof WunderbaumNode||(s=t,t=null);const i=!!getOption(s,"immediate"),n=RenderFlag,r=this.pendingChangeTypes;switch(e){case ChangeType.any:case ChangeType.colStructure:r.add(n.header),r.add(n.clearMarkup),r.add(n.redraw),r.add(n.scroll);break;case ChangeType.resize:r.add(n.header),r.add(n.redraw);break;case ChangeType.structure:r.add(n.redraw);break;case ChangeType.scroll:r.add(n.scroll);break;case ChangeType.row:case ChangeType.data:case ChangeType.status:assert(t,`Option '${e}' requires a node.`),t._rowElem&&t._render({change:e});break;default:error(`Invalid change type '${e}'.`)}if(e===ChangeType.colStructure){const e=this.isGrid();this.element.classList.toggle("wb-grid",e),!e&&this.isCellNav()&&this.setCellNav(!1)}r.size>0&&(i?this._updateViewportImmediately():this._updateViewportThrottled())}setEnabled(e=!0){const t=this.enabled;return this.enabled=!!e,this.element.classList.toggle("wb-disabled",!e),t}isEnabled(){return this.enabled}isGrid(){return this.columns&&this.columns.length>1}isCellNav(){return!!this._cellNavMode}isRowNav(){return!this._cellNavMode}setCellNav(e=!0){var t;const s=this._cellNavMode;this._cellNavMode=!!e,e&&!s&&this.setColumn(0),this.element.classList.toggle("wb-cell-mode",e),null===(t=this.activeNode)||void 0===t||t.update(ChangeType.status)}setNavigationOption(e,t=!1){if(this.isGrid()||e===NavModeEnum.row)switch(this.options.navigationModeOption=e,e){case NavModeEnum.cell:this.setCellNav(!0);break;case NavModeEnum.row:this.setCellNav(!1);break;case NavModeEnum.startCell:t&&this.setCellNav(!0);break;case NavModeEnum.startRow:t&&this.setCellNav(!1);break;default:error(`Invalid mode '${e}'.`)}else this.logWarn("Plain trees only support row navigation mode.")}setStatus(e,t){return this.root.setStatus(e,t)}setTypes(e,t=!0){assert(isPlainObject(e),`Expected plain objext: ${e}`),t?this.types=e:extend(this.types,e);for(const e of Object.values(this.types))e.classes&&(e.classes=toSet(e.classes))}sortChildren(e=nodeTitleSorter,t=!1){this.root.sortChildren(e,t)}toDictArray(e){var t;return null!==(t=this.root.toDict(!0,e).children)&&void 0!==t?t:[]}_updateColumnWidths(){const e=this.element.clientWidth,t=this.columns,s=t[0];let i=0,n=0,r=0,o=!1;if("*"!==s.id)throw new Error(`First column must have  id '*': got '${s.id}'.`);this._columnsById={};for(const e of t){this._columnsById[e.id]=e;const t=e.width;if("*"===e.id&&e!==s)throw new Error(`Column id '*' must be defined only once: '${e.title}'.`);if(t&&"*"!==t)if("number"==typeof t)e._weight=t,n+=t;else if("string"==typeof t&&t.endsWith("px")){e._weight=0;const s=parseFloat(t.slice(0,-2));e._widthPx!=s&&(o=!0,e._widthPx=s),r+=s}else error(`Invalid column width: ${t} (expected string ending with 'px' or number, e.g. "<num>px" or <int>).`);else e._weight=1,n+=1}const l=Math.max(0,e-r);let a=0;for(const e of t){let t;if(e._weight){const s=e.minWidth;t="number"==typeof s?s:"string"==typeof s&&s.endsWith("px")?parseFloat(s.slice(0,-2)):4;const i=Math.max(t,l*e._weight/n);e._widthPx!=i&&(o=!0,e._widthPx=i)}e._ofsPx=a,a+=e._widthPx}t[t.length-1]._widthPx-=1,i=a-1;const d=`${i}px`;return this.headerElement.style.width=d,this.listContainerElement.style.width=d,o}_renderHeaderMarkup(){assert(this.headerElement,"Expected a headerElement");const e=this.hasHeader();if(setElemDisplay(this.headerElement,e),!e)return;const t=this.columns.length,s=this.headerElement.querySelector(".wb-row");assert(s,"Expected a row in header element"),s.innerHTML="<span class='wb-col'></span>".repeat(t);for(let e=0;e<t;e++){const i=this.columns[e],n=s.children[e];n.style.left=i._ofsPx+"px",n.style.width=i._widthPx+"px","string"==typeof i.headerClasses?i.headerClasses&&n.classList.add(...i.headerClasses.split(" ")):i.classes&&n.classList.add(...i.classes.split(" "));const r=escapeHtml(i.title||i.id);let o="";i.tooltip&&(o=escapeTooltip(i.tooltip),o=` title="${o}"`);let l="";e<t-1&&(l='<span class="wb-col-resizer"></span>'),n.innerHTML=`<span class="wb-col-title"${o}>${r}</span>${l}`,this.isCellNav()&&n.classList.toggle("wb-active",e===this.activeColIdx)}}updatePendingModifications(){this.pendingChangeTypes.size>0&&this._updateViewportImmediately()}_updateViewportImmediately(){var e;if(this._disableUpdateCount)return this.log(`_updateViewportImmediately() IGNORED (disable level: ${this._disableUpdateCount})`),void this._disableUpdateIgnoreCount++;const t=RenderFlag,s=new Set(this.pendingChangeTypes);this.pendingChangeTypes.clear();if(s.has(t.scroll)&&1===s.size)this._updateRows({newNodesOnly:!0});else{if(this.log("_updateViewportImmediately():",s),!1!==this.options.adjustHeight){let e=this.listContainerElement.clientHeight;const t=this.headerElement.clientHeight,s=this.element.clientHeight-t-1;Math.abs(e-s)>1&&(this.listContainerElement.style.height=s+"px",e=s)}s.has(t.clearMarkup)&&this.visit((e=>{e.removeMarkup()})),s.has(t.header)&&(this._updateColumnWidths(),this._renderHeaderMarkup()),this._updateRows()}if(this.options.connectTopBreadcrumb){let t=null===(e=this.getTopmostVpNode(!0))||void 0===e?void 0:e.getPath(!1,"title"," > ");t=t?t+" >":"",this.options.connectTopBreadcrumb.textContent=t}this._callEvent("update")}_updateRows(e){const t=!!(e=Object.assign({newNodesOnly:!1},e)).newNodesOnly,s=this.element.clientHeight,i=this.element.scrollTop;let n=Math.max(0,i/22-5);n=Math.floor(n),n%2&&n--;let r=Math.max(0,(i+s)/22+5);r=Math.ceil(r);const o=new Set;this.nodeListElement.childNodes.forEach((e=>{const t=e;o.add(t._wb_node)}));let l=0,a=0,d=!1,c="first";this.visitRows((function(e){const s=e._rowElem;e._rowIdx!==l&&(e._rowIdx=l,d=!0),l<n||l>r?s&&(c=s):s&&t?(o.delete(e),s.style.top=22*l+"px",c=s):(o.delete(e),s&&(s.style.top=22*l+"px"),e._render({top:a,after:c}),c=e._rowElem),l++,a+=22})),this.treeRowCount=l;for(const e of o)e._callEvent("discard"),e.removeMarkup();return this.nodeListElement.style.height=`${a}px`,d}visit(e){return this.root.visit(e,!1)}visitRows(e,t){if(!this.root.hasChildren())return!1;if(t&&t.reverse)return delete t.reverse,this._visitRowsUp(e,t);let s,i,n,r,o,l,a=0,d=!1===(t=t||{}).includeSelf,c=t.start||this.root.children[0];const h=!!t.includeHidden,u=!h&&"hide"===this.filterMode;for(n=c.parent;n;){for(o=n.children,i=o.indexOf(c)+a,assert(i>=0,`Could not find ${c} in parent's children: ${n}`),s=i;s<o.length;s++){if(c=o[s],c===l)return!1;if(!u||c.statusNodeType||c.match||c.subMatchCount){if(!d&&!1===e(c))return!1;if(d=!1,c.children&&c.children.length&&(h||c.expanded)&&(r=c.visit((t=>t!==l&&(!u||t.match||t.subMatchCount?!1!==e(t)&&(h||!t.children||t.expanded?void 0:"skip"):"skip")),!1),!1===r))return!1}}c=n,n=n.parent,a=1,!n&&t.wrap&&(this.logDebug("visitRows(): wrap around"),assert(t.start,"`wrap` option requires `start`"),l=t.start,t.wrap=!1,n=this.root,a=0)}return!0}_visitRowsUp(e,t){let s,i,n,r=t.start||this.root.children[0];const o=!!t.includeHidden;if(!1!==t.includeSelf&&!1===e(r))return!1;for(;;){if(n=r.parent,s=n.children,s[0]===r){if(r=n,!r.parent)break;s=n.children}else for(i=s.indexOf(r),r=s[i-1];(o||r.expanded)&&r.children&&r.children.length;)s=r.children,n=r,r=s[s.length-1];if((o||r.isVisible())&&!1===e(r))return!1}return!0}load(e){return this.clear(),this.root.load(e)}enableUpdate(e){e?(assert(this._disableUpdateCount>0,"enableUpdate(true) was called too often"),this._disableUpdateCount--,0===this._disableUpdateCount&&(this.logDebug(`enableUpdate(): active again. Re-painting to catch up with ${this._disableUpdateIgnoreCount} ignored update requests...`),this._disableUpdateIgnoreCount=0,this.update(ChangeType.any,{immediate:!0}))):this._disableUpdateCount++}filterNodes(e,t){return this.extensions.filter.filterNodes(e,t)}filterBranches(e,t){return this.extensions.filter.filterBranches(e,t)}clearFilter(){return this.extensions.filter.clearFilter()}isFilterActive(){return!!this.filterMode}updateFilter(){return this.extensions.filter.updateFilter()}}Wunderbaum.sequence=0,Wunderbaum.version="v0.7.0",Wunderbaum.util=util;export{Wunderbaum};
//# sourceMappingURL=wunderbaum.esm.min.js.map