module.exports = function(grunt) {

  "use strict";
  
  // List required source files that will be built into wysihtml.js
  var base = [
    "../src/wysihtml5.js",
    "../src/polyfills.js",
    "../node_modules/rangy/lib/rangy-core.js",
    "../node_modules/rangy/lib/rangy-textrange.js",
    "../node_modules/rangy/lib/rangy-selectionsaverestore.js",
    "../lib/base/*.js",
    "../src/browser.js",
    "../src/lang/*.js",
    "../src/dom/*.js",
    "../src/quirks/*.js",
    "../src/selection/*.js",
    "../src/commands.js",
    "../src/commands/*.js",
    "../src/undo_manager.js",
    "../src/views/view.js",
    "../src/views/*.js",
    "../src/editor.js"
  ];

  // Project configuration.
  grunt.initConfig({
    pkg: grunt.file.readJSON('package.json'),
    concat: {
      options: {
        separator: ';',
        process: function(src, filepath) {
          return src.replace(/@VERSION/g, grunt.config.get('pkg.version'));
        }
      },
      dist: {
        src: base,
        dest: 'dist/<%= pkg.name %>.js'
      }
    },
    uglify: {
      options: {
        banner: '/*! <%= pkg.name %> - v<%= pkg.version %> (<%= grunt.template.today("yyyy-mm-dd") %>) */\n',
        sourceMap: true
      },
      build: {
        files: {
          'dist/<%= pkg.name %>.min.js': 'dist/<%= pkg.name %>.js'
        }
      }
    },
    exec: {
      tocms: {
        cmd: function(file) {
          return 'cp dist/wysihtml.js ../../../cms/app/assets/javascripts/wysihtml.js';
        }
      }
    },
    watch: {
      scripts: {
        files: base,
        tasks: ['concat', 'exec:tocms']
      }
    }
  });

  grunt.loadNpmTasks('grunt-contrib-concat');
  grunt.loadNpmTasks('grunt-contrib-uglify');
  grunt.loadNpmTasks('grunt-contrib-watch');
  grunt.loadNpmTasks('grunt-exec');

  grunt.registerTask('default', ['concat', 'exec:tocms']);
};
