(function(wysihtml){
  wysihtml.commands.indentList = {
    exec: function(composer, command, value) {
      var listEls = composer.selection.getSelectionParentsByTag('LI');
      if (listEls) {
        return this.tryToPushLiLevel(listEls, composer.selection);
      }
      return false;
    },

    state: function(composer, command) {
        return false;
    },

    tryToPushLiLevel: function(liNodes, selection) {
      var listTag, list, prevLi, liNode, prevLiList,
          found = false;

      selection.executeAndRestoreRangy(function() {

        for (var i = liNodes.length; i--;) {
          liNode = liNodes[i];
          listTag = (liNode.parentNode.nodeName === 'OL') ? 'OL' : 'UL';
          list = liNode.ownerDocument.createElement(listTag);
          prevLi = wysihtml.dom.domNode(liNode).prev({nodeTypes: [wysihtml.ELEMENT_NODE]});
          prevLiList = (prevLi) ? prevLi.querySelector('ul, ol') : null;

          if (prevLi) {
            if (prevLiList) {
              prevLiList.appendChild(liNode);
            } else {
              list.appendChild(liNode);
              prevLi.appendChild(list);
            }
            found = true;
          }
        }

      });
      return found;
    }
  };
}(wysihtml));
