!function(){const e=X3D.define,t=X3D.require;e("standard/Math/Geometry/Spheroid3",[],function(){"use strict";function e(e,t){switch(arguments.length){case 0:this.semiMajorAxis=0,this.semiMinorAxis=0;break;case 2:this.semiMajorAxis=e,this.semiMinorAxis=t;break;case 3:const i=arguments[1];this.semiMajorAxis=e,this.semiMinorAxis=e*(1-1/i)}}return e.prototype={constructor:e,getSemiMajorAxis:function(){return this.semiMajorAxis},getSemiMinorAxis:function(){return this.semiMinorAxis},toString:function(){return this.semiMajorAxis+" "+this.semiMinorAxis}},e}),e("standard/Geospatial/ReferenceEllipsoids",["standard/Math/Geometry/Spheroid3"],function(e){"use strict";return{AA:new e(6377563.396,299.3249646,!0),AM:new e(6377340.189,299.3249646,!0),AN:new e(6378160,298.25,!0),BN:new e(6377483.865,299.1528128,!0),BR:new e(6377397.155,299.1528128,!0),CC:new e(6378206.4,294.9786982,!0),CD:new e(6378249.145,293.465,!0),EA:new e(6377276.345,300.8017,!0),EB:new e(6377298.556,300.8017,!0),EC:new e(6377301.243,300.8017,!0),ED:new e(6377295.664,300.8017,!0),EE:new e(6377304.063,300.8017,!0),EF:new e(6377309.613,300.8017,!0),FA:new e(6378155,298.3,!0),HE:new e(6378200,298.3,!0),HO:new e(6378270,297,!0),ID:new e(6378160,298.247,!0),IN:new e(6378388,297,!0),KA:new e(6378245,298.3,!0),RF:new e(6378137,298.257222101,!0),SA:new e(6378160,298.25,!0),WD:new e(6378135,298.26,!0),WE:new e(6378137,298.257223563,!0),SUN:new e(696342e3,1/9e-6,!0),MERCURY:new e(2439700,2439700),VENUS:new e(6051800,6051800),MOON:new e(1738140,1735970),MARS:new e(3395428,3377678),JUPITER:new e(71492e3,66854e3),SATURN:new e(60268e3,54364e3),URANUS:new e(2555e3,24973e3),NEPTUNE:new e(24764e3,24341e3),PLUTO:new e(1153e3,1153e3)}}),e("standard/Geospatial/Geodetic",["standard/Math/Numbers/Vector3","standard/Math/Algorithm"],function(e,t){"use strict";function i(e,t,i){this.longitudeFirst=!t,this.degrees=!i,this.a=e.getSemiMajorAxis(),this.c=e.getSemiMinorAxis(),this.c2a2=Math.pow(e.getSemiMinorAxis()/this.a,2),this.ecc2=1-this.c2a2}return i.prototype={constructor:i,convert:function(e,t){const i=e.z;if(this.longitudeFirst)var n=e.y,o=e.x;else var n=e.x,o=e.y;return this.degrees&&(n*=Math.PI/180,o*=Math.PI/180),this.convertRadians(n,o,i,t)},convertRadians:function(e,t,i,n){const o=Math.sin(e),s=Math.pow(o,2),r=Math.cos(e),a=this.a/Math.sqrt(1-this.ecc2*s),l=(a+i)*r;return n.set(l*Math.cos(t),l*Math.sin(t),(a*this.c2a2+i)*o)},apply:function(e,t){if(this.applyRadians(e,t),this.degrees&&(t.x*=180/Math.PI,t.y*=180/Math.PI),this.longitudeFirst){const e=t.x;t.x=t.y,t.y=e}return t},applyRadians:function(e,t){const i=e.x,n=e.y,o=e.z,s=Math.sqrt(i*i+n*n);if(0==s)return t.set(Math.PI,0,o-this.c);let r=0,a=Math.atan2(n,i),l=0,h=this.a,c=h,d=this.ecc2;for(let e=0;e<30;++e){const e=l,t=r;r=Math.atan(o/s/(1-d*c/(c+l)));const i=Math.sin(r);if(c=h/Math.sqrt(1-d*i*i),l=s/Math.cos(r)-c,Math.abs(l-e)<.001&&Math.abs(r-t)<1e-10)break}return t.set(r,a,l)},normal:function(e,t){const i=this.applyRadians(e,t),n=i.x,o=i.y,s=Math.cos(n),r=Math.cos(o)*s,a=Math.sin(o)*s,l=Math.sin(n);return t.set(r,a,l)}},i}),e("standard/Geospatial/UniversalTransverseMercator",["standard/Geospatial/Geodetic","standard/Math/Numbers/Vector3","standard/Math/Algorithm"],function(e,t,i){"use strict";function n(t,n,s,r){const a=t.getSemiMajorAxis(),l=1-Math.pow(t.getSemiMinorAxis()/a,2),h=l/(1-l),c=(1-Math.sqrt(1-l))/(1+Math.sqrt(1-l));this.southernHemisphere=!s,this.eastingFirst=!r,this.a=a,this.ecc2=l,this.EE=h,this.E8=8*h,this.E9=9*h,this.E252=252*h,this.e1=c,this.A=o*(a*(1-l/4-3*l*l/64-5*l*l*l/256)),this.B=3*c/2-7*c*c*c/32,this.C=21*c*c/16-55*c*c*c*c/32,this.D=151*c*c*c/96,this.E=a*(1-l),this.W=1-l/4-3*l*l/64-5*l*l*l/256,this.X=3*l/8+3*l*l/32+45*l*l*l/1024,this.Y=15*l*l/256+45*l*l*l/1024,this.Z=35*l*l*l/3072,this.longitude0=i.radians(6*n-183),this.geodeticConverter=new e(t,!0,!0)}const o=.9996;return n.prototype={constructor:n,convert:function(e,t){if(this.eastingFirst)var i=e.y,n=e.x;else var i=e.x,n=e.y;let s=this.southernHemisphere;i<0&&(s=!this.southernHemisphere,i=-i),s&&(i-=1e7),n-=5e5;const r=i/this.A,a=r+this.B*Math.sin(2*r)+this.C*Math.sin(4*r)+this.D*Math.sin(6*r),l=Math.pow(Math.sin(a),2),h=Math.cos(a),c=Math.tan(a),d=this.a/Math.sqrt(1-this.ecc2*l),u=Math.pow(c,2),p=Math.pow(c,8),_=this.EE*u,g=_*_,w=this.E/Math.pow(1-this.ecc2*l,1.5),f=n/(d*o),m=(5+3*u+10*_-4*g-this.E9)*Math.pow(f,4)/24,O=(61+90*u+298*_+45*p-this.E252-3*g)*Math.pow(f,6)/720,y=(5-2*_+28*u-3*g+this.E8+24*p)*Math.pow(f,5)/120,x=a-d*c/w*(f*f/2-m+O),S=this.longitude0+(f-(1+2*u+_)*Math.pow(f,3)/6+y)/h;return this.geodeticConverter.convertRadians(x,S,e.z,t)},apply:function(e,t){const i=this.geodeticConverter.applyRadians(e,t),n=i.x,s=i.y,r=Math.tan(n),a=Math.cos(n),l=this.EE,h=this.a/Math.sqrt(1-this.ecc2*Math.pow(Math.sin(n),2)),c=r*r,d=c*c*c,u=l*a*a,p=a*(s-this.longitude0),_=this.a*(this.W*n-this.X*Math.sin(2*n)+this.Y*Math.sin(4*n)-this.Z*Math.sin(6*n)),g=o*h*(p+(1-c+u)*Math.pow(p,3)/6+(5-18*d+72*u-58*l)*Math.pow(p,5)/120)+5e5;let w=o*(_+h*r*(p*p/2+(5-c+9*u+4*u*u)*Math.pow(p,4)/24+(61-58*d+600*u-330*l)*Math.pow(p,6)/720));return n<0?(w+=1e7,this.southernHemisphere||(w=-w)):this.southernHemisphere&&(w=-w),this.eastingFirst?t.set(g,w,i.z):t.set(w,g,i.z)}},n}),e("x_ite/Browser/Geospatial/Geocentric",["standard/Math/Numbers/Vector3","standard/Math/Algorithm"],function(e,t){"use strict";function i(){}return i.prototype={constructor:i,convert:function(e,t){return t.assign(e)},apply:function(e,t){return t.assign(e)},slerp:function(e,i,n){var o=e.abs(),s=i.abs();return e.normalize(),i.normalize(),t.simpleSlerp(e,i,n).multiply(t.lerp(o,s,n))}},i}),e("x_ite/Browser/Geospatial/Geospatial",["standard/Geospatial/ReferenceEllipsoids","standard/Geospatial/Geodetic","standard/Geospatial/UniversalTransverseMercator","x_ite/Browser/Geospatial/Geocentric"],function(e,t,i,n){"use strict";var o=0,s=o++,r=o++,a=o++,l={GD:s,GDC:s,UTM:r,GC:a,GCC:a,GS:a};return{GD:s,UTM:r,GC:a,getReferenceFrame:function(o,l){switch(this.getCoordinateSystem(o)){case s:return new t(this.getEllipsoid(o),this.getLatitudeFirst(o),l);case r:return new i(this.getEllipsoid(o),this.getZone(o),this.getNorthernHemisphere(o),this.getNorthingFirst(o));case a:return new n}return new t(e.WE,!0,l)},getElevationFrame:function(e,i){return new t(this.getEllipsoid(e),!0,i)},getCoordinateSystem:function(e){for(var t=0,i=e.length;t<i;++t){var n=l[e[t]];if(void 0!==n)return n}return s},getEllipsoid:function(t){for(var i=0,n=t.length;i<n;++i){var o=e[t[i]];if(void 0!==o)return o}return e.WE},getEllipsoidString:function(t){for(var i=0,n=t.length;i<n;++i){if(void 0!==e[t[i]])return t[i]}return"WE"},isStandardOrder:function(e){switch(this.getCoordinateSystem(e)){case s:return this.getLatitudeFirst(e);case r:return this.getNorthingFirst(e);case a:return!0}return this.getLatitudeFirst(e)},getLatitudeFirst:function(e){for(var t=0,i=e.length;t<i;++t)if("longitude_first"===e[t])return!1;return!0},getNorthingFirst:function(e){for(var t=0,i=e.length;t<i;++t)if("easting_first"===e[t])return!1;return!0},getZone:function(e){for(var t=0,i=e.length;t<i;++t){var n=e[t].match(/^Z(\d+)$/);if(n)return parseInt(n[1])}return 1},getNorthernHemisphere:function(e){for(var t=0,i=e.length;t<i;++t)if("S"===e[t])return!1;return!0}}}),e("x_ite/Components/Geospatial/X3DGeospatialObject",["x_ite/Bits/X3DConstants","x_ite/Browser/Geospatial/Geospatial","x_ite/Bits/X3DCast","standard/Math/Numbers/Vector3","standard/Math/Numbers/Matrix4"],function(e,t,i,n,o){"use strict";function s(t){this.addType(e.X3DGeospatialObject),this.radians=!1,this.origin=new n(0,0,0),this.originMatrix=new o,this.invOriginMatrix=new o}function r(e,t){return this.invOriginMatrix.multVecMatrix(this.referenceFrame.convert(e,t))}function a(e,t){return this.referenceFrame.apply(this.originMatrix.multVecMatrix(d.assign(e)),t)}function l(e,t){return this.invOriginMatrix.multDirMatrix(this.elevationFrame.normal(this.originMatrix.multVecMatrix(d.assign(e)),t))}function h(e,t){return c.call(this,e,t).multRight(this.invOriginMatrix)}function c(e,t){return this.referenceFrame.convert(e,p),this.elevationFrame.normal(p,g),_.set(0,0,1).cross(g),_.equals(n.Zero)&&_.set(1,0,0),w.assign(_).cross(g),_.normalize(),w.normalize(),t.set(_.x,_.y,_.z,0,g.x,g.y,g.z,0,w.x,w.y,w.z,0,p.x,p.y,p.z,1)}var d=new n(0,0,0),u=new n(0,0,0),p=new n(0,0,0),_=new n(0,0,0),g=new n(0,0,0),w=new n(0,0,0);return s.prototype={constructor:s,initialize:function(){this.geoSystem_.addInterest("set_geoSystem__",this),this.geoOrigin_.addInterest("set_geoOrigin__",this),this.set_geoSystem__(),this.set_geoOrigin__()},set_geoSystem__:function(){this.coordinateSystem=t.getCoordinateSystem(this.geoSystem_),this.referenceFrame=t.getReferenceFrame(this.geoSystem_,this.radians),this.elevationFrame=t.getElevationFrame(this.geoSystem_,this.radians),this.standardOrder=t.isStandardOrder(this.geoSystem_)},set_geoOrigin__:function(){this.geoOriginNode&&(this.geoOriginNode.removeInterest("set_origin__",this),this.geoOriginNode.removeInterest("set_rotateYUp__",this),this.geoOriginNode.removeInterest("addNodeEvent",this)),this.geoOriginNode=i(e.GeoOrigin,this.geoOrigin_),this.geoOriginNode&&(this.geoOriginNode.addInterest("set_origin__",this),this.geoOriginNode.addInterest("set_rotateYUp__",this),this.geoOriginNode.addInterest("addNodeEvent",this)),this.set_origin__(),this.set_rotateYUp__()},set_origin__:function(){this.geoOriginNode?this.geoOriginNode.getOrigin(this.origin):this.origin.set(0,0,0),this.set_originMatrix__()},set_originMatrix__:function(){try{if(this.geoOriginNode){var e=this.origin;this.elevationFrame.normal(e,g),_.set(0,0,1).cross(g),_.equals(n.Zero)&&_.set(1,0,0),w.assign(_).cross(g),_.normalize(),w.normalize(),this.originMatrix.set(_.x,_.y,_.z,0,g.x,g.y,g.z,0,w.x,w.y,w.z,0,e.x,e.y,e.z,1),this.invOriginMatrix.assign(this.originMatrix).inverse()}}catch(e){}},set_rotateYUp__:function(){this.geoOriginNode&&this.geoOriginNode.rotateYUp_.getValue()?(this.getCoord=r,this.getGeoCoord=a,this.getGeoUpVector=l,this.getLocationMatrix=h):(delete this.getCoord,delete this.getGeoCoord,delete this.getGeoUpVector,delete this.getLocationMatrix)},getReferenceFrame:function(){return this.referenceFrame},getStandardOrder:function(){return this.standardOrder},getCoord:function(e,t){return this.referenceFrame.convert(e,t).subtract(this.origin)},getGeoCoord:function(e,t){return this.referenceFrame.apply(d.assign(e).add(this.origin),t)},getGeoElevation:function(e){return this.getGeoCoord(e,u).z},getGeoUpVector:function(e,t){return this.elevationFrame.normal(d.assign(e).add(this.origin),t)},getLocationMatrix:function(e,t){var i=this.origin,n=c.call(this,e,t);return n[12]-=i.x,n[13]-=i.y,n[14]-=i.z,n}},s}),e("x_ite/Components/Geospatial/GeoCoordinate",["x_ite/Fields","x_ite/Basic/X3DFieldDefinition","x_ite/Basic/FieldDefinitionArray","x_ite/Components/Rendering/X3DCoordinateNode","x_ite/Components/Geospatial/X3DGeospatialObject","x_ite/Bits/X3DConstants","standard/Math/Geometry/Triangle3","standard/Math/Numbers/Vector3"],function(e,t,i,n,o,s,r,a){"use strict";function l(e){n.call(this,e),o.call(this,e),this.addType(s.GeoCoordinate)}return l.prototype=Object.assign(Object.create(n.prototype),o.prototype,{constructor:l,fieldDefinitions:new i([new t(s.inputOutput,"metadata",new e.SFNode),new t(s.initializeOnly,"geoOrigin",new e.SFNode),new t(s.initializeOnly,"geoSystem",new e.MFString("GD","WE")),new t(s.inputOutput,"point",new e.MFVec3d)]),getTypeName:function(){return"GeoCoordinate"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"coord"},initialize:function(){n.prototype.initialize.call(this),o.prototype.initialize.call(this),this.point_.addInterest("set_point__",this),this.set_point__()},set_point__:function(){this.point=this.point_.getValue(),this.length=this.point_.length},isEmpty:function(){return 0===this.length},getSize:function(){return this.length},set1Point:function(){var e=new a(0,0,0);return function(t,i){this.point_[t]=this.getGeoCoord(i,e)}}(),get1Point:function(){var e=new a(0,0,0);return function(t,i){if(t<this.length){const n=this.point;return t*=3,this.getCoord(e.set(n[t],n[t+1],n[t+2]),i)}return i.set(0,0,0)}}(),addPoint:function(){var e=new a(0,0,0),t=new a(0,0,0);return function(i,n){if(i<this.length){const o=this.point;i*=3,this.getCoord(e.set(o[i],o[i+1],o[i+2]),t),n.push(t[0],t[1],t[2],1)}else n.push(0,0,0,1)}}(),addPoints:function(){var e=new a(0,0,0),t=new a(0,0,0);return function(i,n){const o=this.point;for(var s=0,r=3*this.length;s<r;s+=3)this.getCoord(e.set(o[s],o[s+1],o[s+2]),t),i.push(t[0],t[1],t[2],1);for(var s=r,r=3*n;s<r;s+=3)i.push(0,0,0,1)}}(),getNormal:function(){var e=new a(0,0,0),t=new a(0,0,0),i=new a(0,0,0);return function(n,o,s){var l=this.length;return n<l&&o<l&&s<l?r.normal(this.get1Point(n,e),this.get1Point(o,t),this.get1Point(s,i),new a(0,0,0)):new a(0,0,0)}}(),getQuadNormal:function(){var e=new a(0,0,0),t=new a(0,0,0),i=new a(0,0,0),n=new a(0,0,0);return function(o,s,l,h){var c=this.length;return o<c&&s<c&&l<c&&h<c?r.quadNormal(this.get1Point(o,e),this.get1Point(s,t),this.get1Point(l,i),this.get1Point(h,n),new a(0,0,0)):new a(0,0,0)}}()}),l}),e("x_ite/Components/Geospatial/GeoElevationGrid",["x_ite/Fields","x_ite/Basic/X3DFieldDefinition","x_ite/Basic/FieldDefinitionArray","x_ite/Components/Rendering/X3DGeometryNode","x_ite/Components/Geospatial/X3DGeospatialObject","x_ite/Bits/X3DConstants","x_ite/Bits/X3DCast","standard/Math/Geometry/Triangle3","standard/Math/Numbers/Vector2","standard/Math/Numbers/Vector3"],function(e,t,i,n,o,s,r,a,l,h){"use strict";function c(e){n.call(this,e),o.call(this,e),this.addType(s.GeoElevationGrid),this.creaseAngle_.setUnit("angle"),this.height_.setUnit("length"),this.colorNode=null,this.texCoordNode=null,this.normalNode=null}return c.prototype=Object.assign(Object.create(n.prototype),o.prototype,{constructor:c,fieldDefinitions:new i([new t(s.inputOutput,"metadata",new e.SFNode),new t(s.initializeOnly,"geoOrigin",new e.SFNode),new t(s.initializeOnly,"geoSystem",new e.MFString("GD","WE")),new t(s.initializeOnly,"geoGridOrigin",new e.SFVec3d),new t(s.initializeOnly,"xDimension",new e.SFInt32),new t(s.initializeOnly,"zDimension",new e.SFInt32),new t(s.initializeOnly,"xSpacing",new e.SFDouble(1)),new t(s.initializeOnly,"zSpacing",new e.SFDouble(1)),new t(s.inputOutput,"yScale",new e.SFFloat(1)),new t(s.initializeOnly,"solid",new e.SFBool(!0)),new t(s.initializeOnly,"ccw",new e.SFBool(!0)),new t(s.initializeOnly,"creaseAngle",new e.SFDouble),new t(s.initializeOnly,"colorPerVertex",new e.SFBool(!0)),new t(s.initializeOnly,"normalPerVertex",new e.SFBool(!0)),new t(s.inputOutput,"color",new e.SFNode),new t(s.inputOutput,"texCoord",new e.SFNode),new t(s.inputOutput,"normal",new e.SFNode),new t(s.inputOutput,"height",new e.MFDouble(0,0))]),getTypeName:function(){return"GeoElevationGrid"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"geometry"},initialize:function(){n.prototype.initialize.call(this),o.prototype.initialize.call(this),this.color_.addInterest("set_color__",this),this.texCoord_.addInterest("set_texCoord__",this),this.normal_.addInterest("set_normal__",this),this.set_color__(),this.set_texCoord__(),this.set_normal__()},set_color__:function(){this.colorNode&&(this.colorNode.removeInterest("requestRebuild",this),this.colorNode.transparent_.removeInterest("set_transparent__",this)),this.colorNode=r(s.X3DColorNode,this.color_),this.colorNode?(this.colorNode.addInterest("requestRebuild",this),this.colorNode.transparent_.addInterest("set_transparent__",this),this.set_transparent__()):this.setTransparent(!1)},set_transparent__:function(){this.setTransparent(this.colorNode.getTransparent())},set_texCoord__:function(){this.texCoordNode&&this.texCoordNode.removeInterest("requestRebuild",this),this.texCoordNode=r(s.X3DTextureCoordinateNode,this.texCoord_),this.texCoordNode&&this.texCoordNode.addInterest("requestRebuild",this),this.setTextureCoordinate(this.texCoordNode)},set_normal__:function(){this.normalNode&&this.normalNode.removeInterest("requestRebuild",this),this.normalNode=r(s.X3DNormalNode,this.normal_),this.normalNode&&this.normalNode.addInterest("requestRebuild",this)},getColor:function(){return this.colorNode},getTexCoord:function(){return this.texCoordNode},getNormal:function(){return this.normalNode},getHeight:function(e){return e<this.height_.length?this.height_[e]*this.yScale_.getValue():0},createTexCoords:function(){for(var e=[],t=this.xDimension_.getValue(),i=this.zDimension_.getValue(),n=t-1,o=i-1,s=0;s<i;++s)for(var r=0;r<t;++r)e.push(new l(r/n,s/o));return e},createNormals:function(e,t,i){for(var n=!this.ccw_.getValue(),o=[],s=[],r=0;r<e.length;++r)o[r]=[];for(var l=0;l<t.length;l+=3){var c=t[l],d=t[l+1],u=t[l+2];o[c].push(s.length),o[d].push(s.length+1),o[u].push(s.length+2);var p=a.normal(e[c],e[d],e[u],new h(0,0,0));n&&p.negate(),s.push(p),s.push(p),s.push(p)}return this.refineNormals(o,s,this.creaseAngle_.getValue())},createCoordIndex:function(){for(var e=[],t=this.xDimension_.getValue(),i=this.zDimension_.getValue(),n=t-1,o=i-1,s=0;s<o;++s)for(var r=0;r<n;++r){var a=s*t+r,l=(s+1)*t+r,h=(s+1)*t+(r+1),c=s*t+(r+1);e.push(a),e.push(h),e.push(l),e.push(a),e.push(c),e.push(h)}return e},createPoints:function(){var e=[],t=this.xDimension_.getValue(),i=this.zDimension_.getValue(),n=this.xSpacing_.getValue(),o=this.zSpacing_.getValue();if(this.getStandardOrder())for(var s=0;s<i;++s)for(var r=0;r<t;++r){var a=new h(o*s,n*r,this.getHeight(r+s*t));a.add(this.geoGridOrigin_.getValue()),e.push(this.getCoord(a,a))}else for(var s=0;s<i;++s)for(var r=0;r<t;++r){var a=new h(n*r,o*s,this.getHeight(r+s*t));a.add(this.geoGridOrigin_.getValue()),e.push(this.getCoord(a,a))}return e},build:function(){if(!(this.xDimension_.getValue()<2||this.zDimension_.getValue()<2)){var e=this.colorPerVertex_.getValue(),t=this.normalPerVertex_.getValue(),i=this.createCoordIndex(),n=this.getColor(),o=this.getTexCoord(),s=this.getNormal(),r=this.createPoints(),a=this.getColors(),l=this.getMultiTexCoords(),h=this.getNormals(),c=this.getVertices(),d=0;if(o)o.init(l);else{var u=this.createTexCoords(),p=this.getTexCoords();l.push(p)}for(var _=0;_<i.length;++d)for(var g=0;g<6;++g,++_){var w=i[_],f=r[w];if(n&&(e?n.addColor(w,a):n.addColor(d,a)),o)o.addTexCoord(w,l);else{var m=u[w];p.push(m.x,m.y,0,1)}s&&(t?s.addVector(w,h):s.addVector(d,h)),c.push(f.x,f.y,f.z,1)}if(!s)for(var O=this.createNormals(r,i),y=0;y<O.length;++y){var x=O[y];h.push(x.x,x.y,x.z)}this.setSolid(this.solid_.getValue()),this.setCCW(this.ccw_.getValue())}}}),c}),e("x_ite/Components/Geospatial/GeoLOD",["x_ite/Fields","x_ite/Basic/X3DFieldDefinition","x_ite/Basic/FieldDefinitionArray","x_ite/Components/Core/X3DChildNode","x_ite/Components/Grouping/X3DBoundedObject","x_ite/Components/Geospatial/X3DGeospatialObject","x_ite/Bits/X3DConstants","x_ite/Bits/TraverseType","x_ite/Components/Grouping/Group","x_ite/Components/Networking/Inline","standard/Math/Numbers/Vector3","standard/Math/Numbers/Matrix4","standard/Math/Geometry/Box3"],function(e,t,i,n,o,s,r,a,l,h,c,d,u){"use strict";function p(e){n.call(this,e),o.call(this,e),s.call(this,e),this.addType(r.GeoLOD),this.range_.setUnit("length"),this.unload=!1,this.rootGroup=new l(this.getBrowser().getPrivateScene()),this.rootInline=new h(e),this.child1Inline=new h(e),this.child2Inline=new h(e),this.child3Inline=new h(e),this.child4Inline=new h(e),this.childrenLoaded=!1,this.childBBox=new u,this.keepCurrentLevel=!1,this.modelViewMatrix=new d}var _=new c(0,0,0);return p.prototype=Object.assign(Object.create(n.prototype),o.prototype,s.prototype,{constructor:p,fieldDefinitions:new i([new t(r.inputOutput,"metadata",new e.SFNode),new t(r.initializeOnly,"geoOrigin",new e.SFNode),new t(r.initializeOnly,"geoSystem",new e.MFString("GD","WE")),new t(r.initializeOnly,"rootUrl",new e.MFString),new t(r.initializeOnly,"child1Url",new e.MFString),new t(r.initializeOnly,"child2Url",new e.MFString),new t(r.initializeOnly,"child3Url",new e.MFString),new t(r.initializeOnly,"child4Url",new e.MFString),new t(r.initializeOnly,"center",new e.SFVec3d),new t(r.initializeOnly,"range",new e.SFFloat(10)),new t(r.outputOnly,"level_changed",new e.SFInt32(-1)),new t(r.inputOutput,"visible",new e.SFBool(!0)),new t(r.inputOutput,"bboxDisplay",new e.SFBool),new t(r.initializeOnly,"bboxSize",new e.SFVec3f(-1,-1,-1)),new t(r.initializeOnly,"bboxCenter",new e.SFVec3f),new t(r.initializeOnly,"rootNode",new e.MFNode),new t(r.outputOnly,"children",new e.MFNode)]),getTypeName:function(){return"GeoLOD"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"children"},initialize:function(){n.prototype.initialize.call(this),o.prototype.initialize.call(this),s.prototype.initialize.call(this),this.rootNode_.addFieldInterest(this.rootGroup.children_),this.rootGroup.children_=this.rootNode_,this.rootGroup.setPrivate(!0),this.rootGroup.setup(),this.rootInline.loadState_.addInterest("set_rootLoadState__",this),this.child1Inline.loadState_.addInterest("set_childLoadState__",this),this.child2Inline.loadState_.addInterest("set_childLoadState__",this),this.child3Inline.loadState_.addInterest("set_childLoadState__",this),this.child4Inline.loadState_.addInterest("set_childLoadState__",this),this.rootUrl_.addFieldInterest(this.rootInline.url_),this.child1Url_.addFieldInterest(this.child1Inline.url_),this.child2Url_.addFieldInterest(this.child2Inline.url_),this.child3Url_.addFieldInterest(this.child3Inline.url_),this.child4Url_.addFieldInterest(this.child4Inline.url_),this.rootInline.load_=!0,this.child1Inline.load_=!1,this.child2Inline.load_=!1,this.child3Inline.load_=!1,this.child4Inline.load_=!1,this.rootInline.url_=this.rootUrl_,this.child1Inline.url_=this.child1Url_,this.child2Inline.url_=this.child2Url_,this.child3Inline.url_=this.child3Url_,this.child4Inline.url_=this.child4Url_,this.rootInline.setup(),this.child1Inline.setup(),this.child2Inline.setup(),this.child3Inline.setup(),this.child4Inline.setup()},getBBox:function(e,t){if(this.bboxSize_.getValue().equals(this.getDefaultBBoxSize())){switch(this.childrenLoaded?this.level_changed_.getValue():0){case 0:return this.rootNode_.length?this.rootGroup.getBBox(e,t):this.rootInline.getBBox(e,t);case 1:{const i=this.childBBox;return e.set(),e.add(this.child1Inline.getBBox(i,t)),e.add(this.child2Inline.getBBox(i,t)),e.add(this.child3Inline.getBBox(i,t)),e.add(this.child4Inline.getBBox(i,t)),e}}return e.set()}return e.set(this.bboxSize_.getValue(),this.bboxCenter_.getValue())},set_rootLoadState__:function(){0===this.level_changed_.getValue()&&(this.rootNode_.length||this.rootInline.checkLoadState()===r.COMPLETE_STATE&&(this.children_=this.rootInline.getInternalScene().getRootNodes(),this.childrenLoaded=!1))},set_childLoadState__:function(){if(1===this.level_changed_.getValue()){var e=0;if(this.child1Inline.checkLoadState()!==r.COMPLETE_STATE&&this.child1Inline.checkLoadState()!==r.FAILED_STATE||++e,this.child2Inline.checkLoadState()!==r.COMPLETE_STATE&&this.child2Inline.checkLoadState()!==r.FAILED_STATE||++e,this.child3Inline.checkLoadState()!==r.COMPLETE_STATE&&this.child3Inline.checkLoadState()!==r.FAILED_STATE||++e,this.child4Inline.checkLoadState()!==r.COMPLETE_STATE&&this.child4Inline.checkLoadState()!==r.FAILED_STATE||++e,4===e){this.childrenLoaded=!0;var t=this.children_;t.length=0;for(var i=this.child1Inline.getInternalScene().getRootNodes(),n=0,o=i.length;n<o;++n)t.push(i[n]);for(var i=this.child2Inline.getInternalScene().getRootNodes(),n=0,o=i.length;n<o;++n)t.push(i[n]);for(var i=this.child3Inline.getInternalScene().getRootNodes(),n=0,o=i.length;n<o;++n)t.push(i[n]);for(var i=this.child4Inline.getInternalScene().getRootNodes(),n=0,o=i.length;n<o;++n)t.push(i[n])}}},set_childCameraObject__:function(){this.setCameraObject(this.child1Inline.getCameraObject()||this.child2Inline.getCameraObject()||this.child3Inline.getCameraObject()||this.child4Inline.getCameraObject())},set_childPickableObject__:function(){this.setPickableObject(this.child1Inline.getPickableObject()||this.child2Inline.getPickableObject()||this.child3Inline.getPickableObject()||this.child4Inline.getPickableObject())},getLevel:function(e){return this.getDistance(e)<this.range_.getValue()?1:0},getDistance:function(e){return e.translate(this.getCoord(this.center_.getValue(),_)),e.origin.abs()},traverse:function(e,t){switch(e){case a.PICKING:var i=t.getBrowser(),n=i.getPickingHierarchy();return n.push(this),this.traverseChildren(e,t),void n.pop();case a.DISPLAY:var o=this.getLevel(this.modelViewMatrix.assign(t.getModelViewMatrix().get()));if(o!==this.level_changed_.getValue())switch(this.level_changed_=o,o){case 0:this.child1Inline.isCameraObject_.removeInterest("set_childCameraObject__",this),this.child2Inline.isCameraObject_.removeInterest("set_childCameraObject__",this),this.child3Inline.isCameraObject_.removeInterest("set_childCameraObject__",this),this.child4Inline.isCameraObject_.removeInterest("set_childCameraObject__",this),this.child1Inline.isPickableObject_.removeInterest("set_childPickableObject__",this),this.child2Inline.isPickableObject_.removeInterest("set_childPickableObject__",this),this.child3Inline.isPickableObject_.removeInterest("set_childPickableObject__",this),this.child4Inline.isPickableObject_.removeInterest("set_childPickableObject__",this),this.rootNode_.length?(this.rootGroup.isCameraObject_.addFieldInterest(this.isCameraObject_),this.rootGroup.isPickableObject_.addFieldInterest(this.isPickableObject_),this.setCameraObject(this.rootGroup.getCameraObject()),this.setPickableObject(this.rootGroup.getPickableObject()),this.children_=this.rootNode_,this.childrenLoaded=!1):this.rootInline.checkLoadState()==r.COMPLETE_STATE&&(this.rootInline.isCameraObject_.addFieldInterest(this.isCameraObject_),this.rootInline.isPickableObject_.addFieldInterest(this.isPickableObject_),this.setCameraObject(this.rootInline.getCameraObject()),this.setPickableObject(this.rootInline.getPickableObject()),this.children_=this.rootInline.getInternalScene().getRootNodes(),this.childrenLoaded=!1),this.unload&&(this.child1Inline.load_=!1,this.child2Inline.load_=!1,this.child3Inline.load_=!1,this.child4Inline.load_=!1);break;case 1:this.rootNode_.length?(this.rootGroup.isCameraObject_.removeFieldInterest(this.isCameraObject_),this.rootGroup.isPickableObject_.removeFieldInterest(this.isPickableObject_)):(this.rootInline.isCameraObject_.removeFieldInterest(this.isCameraObject_),this.rootInline.isPickableObject_.removeFieldInterest(this.isPickableObject_)),this.child1Inline.isCameraObject_.addInterest("set_childCameraObject__",this),this.child2Inline.isCameraObject_.addInterest("set_childCameraObject__",this),this.child3Inline.isCameraObject_.addInterest("set_childCameraObject__",this),this.child4Inline.isCameraObject_.addInterest("set_childCameraObject__",this),this.child1Inline.isPickableObject_.addInterest("set_childPickableObject__",this),this.child2Inline.isPickableObject_.addInterest("set_childPickableObject__",this),this.child3Inline.isPickableObject_.addInterest("set_childPickableObject__",this),this.child4Inline.isPickableObject_.addInterest("set_childPickableObject__",this),this.set_childCameraObject__(),this.set_childPickableObject__(),this.child1Inline.load_.getValue()?this.set_childLoadState__():(this.child1Inline.load_=!0,this.child2Inline.load_=!0,this.child3Inline.load_=!0,this.child4Inline.load_=!0)}return void this.traverseChildren(e,t);default:return void this.traverseChildren(e,t)}},traverseChildren:function(e,t){switch(this.childrenLoaded?this.level_changed_.getValue():0){case 0:this.rootNode_.length?this.rootGroup.traverse(e,t):this.rootInline.traverse(e,t);break;case 1:this.child1Inline.traverse(e,t),this.child2Inline.traverse(e,t),this.child3Inline.traverse(e,t),this.child4Inline.traverse(e,t)}}}),p}),e("x_ite/Components/Geospatial/GeoLocation",["x_ite/Fields","x_ite/Basic/X3DFieldDefinition","x_ite/Basic/FieldDefinitionArray","x_ite/Components/Grouping/X3DTransformMatrix3DNode","x_ite/Components/Geospatial/X3DGeospatialObject","x_ite/Bits/X3DConstants","standard/Math/Numbers/Matrix4"],function(e,t,i,n,o,s,r){"use strict";function a(e){n.call(this,e),o.call(this,e),this.addType(s.GeoLocation)}var l=new r;return a.prototype=Object.assign(Object.create(n.prototype),o.prototype,{constructor:a,fieldDefinitions:new i([new t(s.inputOutput,"metadata",new e.SFNode),new t(s.initializeOnly,"geoSystem",new e.MFString("GD","WE")),new t(s.inputOutput,"geoCoords",new e.SFVec3d),new t(s.initializeOnly,"geoOrigin",new e.SFNode),new t(s.inputOutput,"visible",new e.SFBool(!0)),new t(s.inputOutput,"bboxDisplay",new e.SFBool),new t(s.initializeOnly,"bboxSize",new e.SFVec3f(-1,-1,-1)),new t(s.initializeOnly,"bboxCenter",new e.SFVec3f),new t(s.inputOnly,"addChildren",new e.MFNode),new t(s.inputOnly,"removeChildren",new e.MFNode),new t(s.inputOutput,"children",new e.MFNode)]),getTypeName:function(){return"GeoLocation"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"children"},initialize:function(){n.prototype.initialize.call(this),o.prototype.initialize.call(this),this.addInterest("eventsProcessed",this),this.eventsProcessed()},eventsProcessed:function(){this.setMatrix(this.getLocationMatrix(this.geoCoords_.getValue(),l))}}),a}),e("x_ite/Components/Geospatial/GeoMetadata",["x_ite/Fields","x_ite/Basic/X3DFieldDefinition","x_ite/Basic/FieldDefinitionArray","x_ite/Components/Core/X3DInfoNode","x_ite/Bits/X3DConstants"],function(e,t,i,n,o){"use strict";function s(e){n.call(this,e),this.addType(o.GeoMetadata)}return s.prototype=Object.assign(Object.create(n.prototype),{constructor:s,fieldDefinitions:new i([new t(o.inputOutput,"metadata",new e.SFNode),new t(o.inputOutput,"url",new e.MFString),new t(o.inputOutput,"summary",new e.MFString),new t(o.inputOutput,"data",new e.MFNode)]),getTypeName:function(){return"GeoMetadata"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"children"}}),s}),e("x_ite/Components/Geospatial/GeoOrigin",["x_ite/Fields","x_ite/Basic/X3DFieldDefinition","x_ite/Basic/FieldDefinitionArray","x_ite/Components/Core/X3DNode","x_ite/Bits/X3DConstants","x_ite/Browser/Geospatial/Geospatial"],function(e,t,i,n,o,s){"use strict";function r(e){n.call(this,e),this.addType(o.GeoOrigin),this.radians=!1}return r.prototype=Object.assign(Object.create(n.prototype),{constructor:r,fieldDefinitions:new i([new t(o.inputOutput,"metadata",new e.SFNode),new t(o.initializeOnly,"geoSystem",new e.MFString("GD","WE")),new t(o.inputOutput,"geoCoords",new e.SFVec3d),new t(o.initializeOnly,"rotateYUp",new e.SFBool)]),getTypeName:function(){return"GeoOrigin"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"geoOrigin"},initialize:function(){n.prototype.initialize.call(this),this.geoSystem_.addInterest("set_geoSystem__",this),this.set_geoSystem__()},set_geoSystem__:function(){this.referenceFrame=s.getReferenceFrame(this.geoSystem_,this.radians)},getOrigin:function(e){return this.referenceFrame.convert(this.geoCoords_.getValue(),e)}}),r}),e("x_ite/Components/Geospatial/GeoPositionInterpolator",["x_ite/Fields","x_ite/Basic/X3DFieldDefinition","x_ite/Basic/FieldDefinitionArray","x_ite/Components/Interpolation/X3DInterpolatorNode","x_ite/Components/Geospatial/X3DGeospatialObject","x_ite/Browser/Geospatial/Geocentric","x_ite/Bits/X3DConstants","standard/Math/Numbers/Vector3"],function(e,t,i,n,o,s,r,a){"use strict";function l(e){n.call(this,e),o.call(this,e),this.addType(r.GeoPositionInterpolator),this.value_changed_.setUnit("length"),this.geocentric=new s}return l.prototype=Object.assign(Object.create(n.prototype),o.prototype,{constructor:l,
fieldDefinitions:new i([new t(r.inputOutput,"metadata",new e.SFNode),new t(r.initializeOnly,"geoOrigin",new e.SFNode),new t(r.initializeOnly,"geoSystem",new e.MFString("GD","WE")),new t(r.inputOnly,"set_fraction",new e.SFFloat),new t(r.inputOutput,"key",new e.MFFloat),new t(r.inputOutput,"keyValue",new e.MFVec3d),new t(r.outputOnly,"value_changed",new e.SFVec3d),new t(r.outputOnly,"geovalue_changed",new e.SFVec3d)]),keyValue0:new a(0,0,0),keyValue1:new a(0,0,0),geovalue:new a(0,0,0),value:new a(0,0,0),getTypeName:function(){return"GeoPositionInterpolator"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"children"},setup:function(){o.prototype.initialize.call(this),n.prototype.setup.call(this)},initialize:function(){n.prototype.initialize.call(this),this.keyValue_.addInterest("set_keyValue__",this)},set_keyValue__:function(){var t=this.key_,i=this.keyValue_;i.length<t.length&&i.resize(t.length,i.length?i[i.length-1]:new e.SFVec3f)},interpolate:function(e,t,i){try{this.getCoord(this.keyValue_[e].getValue(),this.keyValue0),this.getCoord(this.keyValue_[t].getValue(),this.keyValue1);var n=this.geocentric.slerp(this.keyValue0,this.keyValue1,i);this.geovalue_changed_=this.getGeoCoord(n,this.geovalue),this.value_changed_=n}catch(e){}}}),l}),e("x_ite/Components/Geospatial/GeoProximitySensor",["x_ite/Fields","x_ite/Basic/X3DFieldDefinition","x_ite/Basic/FieldDefinitionArray","x_ite/Components/EnvironmentalSensor/X3DEnvironmentalSensorNode","x_ite/Components/Geospatial/X3DGeospatialObject","x_ite/Components/EnvironmentalSensor/ProximitySensor","x_ite/Bits/X3DConstants","standard/Math/Numbers/Vector3"],function(e,t,i,n,o,s,r,a){"use strict";function l(e){n.call(this,e),o.call(this,e),this.addType(r.GeoProximitySensor),this.position_changed_.setUnit("length"),this.centerOfRotation_changed_.setUnit("length"),this.proximitySensor=new s(e),this.setCameraObject(this.proximitySensor.getCameraObject()),this.setPickableObject(this.proximitySensor.getPickableObject())}var h=new a(0,0,0);return l.prototype=Object.assign(Object.create(n.prototype),o.prototype,{constructor:l,fieldDefinitions:new i([new t(r.inputOutput,"metadata",new e.SFNode),new t(r.initializeOnly,"geoOrigin",new e.SFNode),new t(r.initializeOnly,"geoSystem",new e.MFString("GD","WE")),new t(r.inputOutput,"enabled",new e.SFBool(!0)),new t(r.inputOutput,"size",new e.SFVec3f),new t(r.inputOutput,"center",new e.SFVec3f),new t(r.outputOnly,"isActive",new e.SFBool),new t(r.outputOnly,"enterTime",new e.SFTime),new t(r.outputOnly,"exitTime",new e.SFTime),new t(r.outputOnly,"geoCoord_changed",new e.SFVec3d),new t(r.outputOnly,"position_changed",new e.SFVec3f),new t(r.outputOnly,"orientation_changed",new e.SFRotation),new t(r.outputOnly,"centerOfRotation_changed",new e.SFVec3f)]),getTypeName:function(){return"GeoProximitySensor"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"children"},initialize:function(){n.prototype.initialize.call(this),o.prototype.initialize.call(this),this.enabled_.addFieldInterest(this.proximitySensor.enabled_),this.size_.addFieldInterest(this.proximitySensor.size_),this.center_.addFieldInterest(this.proximitySensor.center_),this.proximitySensor.isCameraObject_.addFieldInterest(this.isCameraObject_),this.proximitySensor.isPickableObject_.addFieldInterest(this.isPickableObject_),this.proximitySensor.isActive_.addFieldInterest(this.isActive_),this.proximitySensor.enterTime_.addFieldInterest(this.enterTime_),this.proximitySensor.exitTime_.addFieldInterest(this.exitTime_),this.proximitySensor.position_changed_.addFieldInterest(this.position_changed_),this.proximitySensor.orientation_changed_.addFieldInterest(this.orientation_changed_),this.proximitySensor.centerOfRotation_changed_.addFieldInterest(this.centerOfRotation_changed_),this.proximitySensor.position_changed_.addInterest("set_position__",this),this.proximitySensor.enabled_=this.enabled_,this.proximitySensor.size_=this.size_,this.proximitySensor.center_=this.center_,this.proximitySensor.setup()},set_position__:function(e){this.geoCoord_changed_=this.getGeoCoord(this.proximitySensor.position_changed_.getValue(),h)},traverse:function(e,t){this.proximitySensor.traverse(e,t)}}),l}),e("x_ite/Components/Geospatial/GeoTouchSensor",["x_ite/Fields","x_ite/Basic/X3DFieldDefinition","x_ite/Basic/FieldDefinitionArray","x_ite/Components/PointingDeviceSensor/X3DTouchSensorNode","x_ite/Components/Geospatial/X3DGeospatialObject","x_ite/Bits/X3DConstants","standard/Math/Numbers/Vector3","standard/Math/Numbers/Matrix4"],function(e,t,i,n,o,s,r,a){"use strict";function l(e){n.call(this,e),o.call(this,e),this.addType(s.GeoTouchSensor),this.hitPoint_changed_.setUnit("length")}var h=new a,c=new r(0,0,0);return l.prototype=Object.assign(Object.create(n.prototype),o.prototype,{constructor:l,fieldDefinitions:new i([new t(s.inputOutput,"metadata",new e.SFNode),new t(s.initializeOnly,"geoOrigin",new e.SFNode),new t(s.initializeOnly,"geoSystem",new e.MFString("GD","WE")),new t(s.inputOutput,"enabled",new e.SFBool(!0)),new t(s.inputOutput,"description",new e.SFString),new t(s.outputOnly,"hitTexCoord_changed",new e.SFVec2f),new t(s.outputOnly,"hitNormal_changed",new e.SFVec3f),new t(s.outputOnly,"hitPoint_changed",new e.SFVec3f),new t(s.outputOnly,"hitGeoCoord_changed",new e.SFVec3d),new t(s.outputOnly,"isOver",new e.SFBool),new t(s.outputOnly,"isActive",new e.SFBool),new t(s.outputOnly,"touchTime",new e.SFTime)]),getTypeName:function(){return"GeoTouchSensor"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"children"},initialize:function(){n.prototype.initialize.call(this),o.prototype.initialize.call(this)},set_over__:function(e,t,i,o,s){try{if(n.prototype.set_over__.call(this,e,t,i,o,s),this.isOver_.getValue()){var r=t.intersection;h.assign(i).inverse(),this.hitTexCoord_changed_=r.texCoord,this.hitNormal_changed_=i.multMatrixDir(r.normal.copy()).normalize(),this.hitPoint_changed_=h.multVecMatrix(r.point.copy()),this.hitGeoCoord_changed_=this.getGeoCoord(this.hitPoint_changed_.getValue(),c)}}catch(e){console.log(e)}}}),l}),e("x_ite/Components/Geospatial/GeoTransform",["x_ite/Fields","x_ite/Basic/X3DFieldDefinition","x_ite/Basic/FieldDefinitionArray","x_ite/Components/Grouping/X3DTransformMatrix3DNode","x_ite/Components/Geospatial/X3DGeospatialObject","x_ite/Bits/X3DConstants","standard/Math/Numbers/Matrix4"],function(e,t,i,n,o,s,r){"use strict";function a(e){n.call(this,e),o.call(this,e),this.addType(s.GeoTransform),this.translation_.setUnit("length")}var l=new r,h=new r;return a.prototype=Object.assign(Object.create(n.prototype),o.prototype,{constructor:a,fieldDefinitions:new i([new t(s.inputOutput,"metadata",new e.SFNode),new t(s.inputOutput,"translation",new e.SFVec3f),new t(s.inputOutput,"rotation",new e.SFRotation),new t(s.inputOutput,"scale",new e.SFVec3f(1,1,1)),new t(s.inputOutput,"scaleOrientation",new e.SFRotation),new t(s.initializeOnly,"geoOrigin",new e.SFNode),new t(s.initializeOnly,"geoSystem",new e.MFString("GD","WE")),new t(s.inputOutput,"geoCenter",new e.SFVec3d),new t(s.inputOutput,"visible",new e.SFBool(!0)),new t(s.inputOutput,"bboxDisplay",new e.SFBool),new t(s.initializeOnly,"bboxSize",new e.SFVec3f(-1,-1,-1)),new t(s.initializeOnly,"bboxCenter",new e.SFVec3f),new t(s.inputOnly,"addChildren",new e.MFNode),new t(s.inputOnly,"removeChildren",new e.MFNode),new t(s.inputOutput,"children",new e.MFNode)]),getTypeName:function(){return"GeoTransform"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"children"},initialize:function(){n.prototype.initialize.call(this),o.prototype.initialize.call(this),this.addInterest("eventsProcessed",this),this.eventsProcessed()},eventsProcessed:function(){try{this.setHidden(0===this.scale_.x||0===this.scale_.y||0===this.scale_.z),this.getLocationMatrix(this.geoCenter_.getValue(),h),l.set(this.translation_.getValue(),this.rotation_.getValue(),this.scale_.getValue(),this.scaleOrientation_.getValue()),this.setMatrix(l.multRight(h).multLeft(h.inverse()))}catch(e){this.setHidden(!0)}}}),a}),e("x_ite/Components/Geospatial/GeoViewpoint",["x_ite/Fields","x_ite/Basic/X3DFieldDefinition","x_ite/Basic/FieldDefinitionArray","x_ite/Components/Navigation/X3DViewpointNode","x_ite/Components/Geospatial/X3DGeospatialObject","x_ite/Components/Interpolation/ScalarInterpolator","x_ite/Components/Navigation/NavigationInfo","x_ite/Bits/X3DConstants","standard/Math/Geometry/Camera","standard/Math/Numbers/Vector2","standard/Math/Numbers/Vector3","standard/Math/Numbers/Rotation4","standard/Math/Numbers/Matrix4","standard/Math/Algorithm"],function(e,t,i,n,o,s,r,a,l,h,c,d,u,p){"use strict";function _(e,t){n.prototype.traverse.call(this,e,t),this.navigationInfoNode.traverse(e,t)}function g(e){switch(n.call(this,e),o.call(this,e),this.addType(a.GeoViewpoint),this.centerOfRotation_.setUnit("length"),this.fieldOfView_.setUnit("angle"),this.navigationInfoNode=new r(e),this.fieldOfViewInterpolator=new s(this.getBrowser().getPrivateScene()),this.projectionMatrix=new u,this.elevation=0,e.specificationVersion){case"2.0":case"3.0":case"3.1":case"3.2":this.traverse=_}}return g.prototype=Object.assign(Object.create(n.prototype),o.prototype,{constructor:g,fieldDefinitions:new i([new t(a.inputOutput,"metadata",new e.SFNode),new t(a.initializeOnly,"geoOrigin",new e.SFNode),new t(a.initializeOnly,"geoSystem",new e.MFString("GD","WE")),new t(a.inputOnly,"set_bind",new e.SFBool),new t(a.inputOutput,"description",new e.SFString),new t(a.inputOutput,"position",new e.SFVec3d(0,0,1e5)),new t(a.inputOutput,"orientation",new e.SFRotation),new t(a.inputOutput,"centerOfRotation",new e.SFVec3d),new t(a.inputOutput,"fieldOfView",new e.SFFloat(.7854)),new t(a.inputOutput,"jump",new e.SFBool(!0)),new t(a.inputOutput,"retainUserOffsets",new e.SFBool),new t(a.inputOutput,"navType",new e.MFString("EXAMINE","ANY")),new t(a.inputOutput,"headlight",new e.SFBool(!0)),new t(a.initializeOnly,"speedFactor",new e.SFFloat(1)),new t(a.outputOnly,"isBound",new e.SFBool),new t(a.outputOnly,"bindTime",new e.SFTime)]),getTypeName:function(){return"GeoViewpoint"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"children"},initialize:function(){n.prototype.initialize.call(this),o.prototype.initialize.call(this),this.position_.addInterest("set_position__",this),this.positionOffset_.addInterest("set_position__",this),this.navType_.addFieldInterest(this.navigationInfoNode.type_),this.headlight_.addFieldInterest(this.navigationInfoNode.headlight_),this.navigationInfoNode.setup(),this.set_position__(),this.fieldOfViewInterpolator.key_=[0,1],this.fieldOfViewInterpolator.setup(),this.getEaseInEaseOut().modifiedFraction_changed_.addFieldInterest(this.fieldOfViewInterpolator.set_fraction_),this.fieldOfViewInterpolator.value_changed_.addFieldInterest(this.fieldOfViewScale_)},setInterpolators:function(t,i){if(t.getType().indexOf(a.Viewpoint)>=0){const n=t.getFieldOfView()/i.getFieldOfView();this.fieldOfViewInterpolator.keyValue_=new e.MFFloat(n,i.fieldOfViewScale_.getValue()),this.fieldOfViewScale_=n}else this.fieldOfViewInterpolator.keyValue_=new e.MFFloat(i.fieldOfViewScale_.getValue(),i.fieldOfViewScale_.getValue()),this.fieldOfViewScale_=i.fieldOfViewScale_.getValue()},setPosition:function(){var e=new c(0,0,0);return function(t){this.position_.setValue(this.getGeoCoord(t,e))}}(),getPosition:function(){var e=new c(0,0,0);return function(){return this.getCoord(this.position_.getValue(),e)}}(),set_position__:function(){var e=new c(0,0,0);return function(){this.getCoord(this.position_.getValue(),e),this.elevation=this.getGeoElevation(e.add(this.positionOffset_.getValue()))}}(),setOrientation:function(){var e=new u,t=new d(0,0,1,0);return function(i){var n=this.getLocationMatrix(this.position_.getValue(),e).submatrix;t.setMatrix(n),this.orientation_.setValue(t.inverse().multLeft(i))}}(),getOrientation:function(){var e=new u,t=new d(0,0,1,0);return function(){var i=this.getLocationMatrix(this.position_.getValue(),e).submatrix;return t.setMatrix(i),t.multLeft(this.orientation_.getValue())}}(),getCenterOfRotation:function(){var e=new c(0,0,0);return function(){return this.getCoord(this.centerOfRotation_.getValue(),e)}}(),getFieldOfView:function(){var e=this.fieldOfView_*this.fieldOfViewScale_;return e>0&&e<Math.PI?e:Math.PI/4},getMaxFarValue:function(){return this.getBrowser().getRenderingProperty("LogarithmicDepthBuffer")?1e10:1e9},getUpVector:function(){var e=new c(0,0,0),t=new c(0,0,0);return function(){return this.getCoord(this.position_.getValue(),e),this.getGeoUpVector.call(this,e.add(this.positionOffset_.getValue()),t)}}(),getSpeedFactor:function(){return(Math.max(this.elevation,0)+10)/10*this.speedFactor_.getValue()},getScreenScale:function(){var e=new c(0,0,0);return function(t,i){var n=i[2],o=i[3],s=Math.abs(t.z)*Math.tan(this.getFieldOfView()/2)*2;return s/=n>o?o:n,e.set(s,s,s)}}(),getViewportSize:function(){var e=new h(0,0);return function(t,i){var n=t[2],o=t[3],s=i*Math.tan(this.getFieldOfView()/2)*2,r=n/o;return r>1?e.set(s*r,s):e.set(s,s/r)}}(),getLookAtDistance:function(e){return e.size.abs()/2/Math.tan(this.getFieldOfView()/2)},getProjectionMatrixWithLimits:function(e,t,i,n){if(n||this.getBrowser().getRenderingProperty("LogarithmicDepthBuffer"))return l.perspective(this.getFieldOfView(),e,t,i[2],i[3],this.projectionMatrix);var o=Math.max(p.lerp(Math.min(e,1e4),1e4,this.elevation/1e7),1),s=Math.max(p.lerp(1e6,Math.max(t,1e6),this.elevation/1e7),1e6);return l.perspective(this.getFieldOfView(),o,s,i[2],i[3],this.projectionMatrix)}}),g}),e(t.getComponentUrl("geospatial"),["x_ite/Components","x_ite/Components/Geospatial/GeoCoordinate","x_ite/Components/Geospatial/GeoElevationGrid","x_ite/Components/Geospatial/GeoLOD","x_ite/Components/Geospatial/GeoLocation","x_ite/Components/Geospatial/GeoMetadata","x_ite/Components/Geospatial/GeoOrigin","x_ite/Components/Geospatial/GeoPositionInterpolator","x_ite/Components/Geospatial/GeoProximitySensor","x_ite/Components/Geospatial/GeoTouchSensor","x_ite/Components/Geospatial/GeoTransform","x_ite/Components/Geospatial/GeoViewpoint","x_ite/Components/Geospatial/X3DGeospatialObject"],function(e,t,i,n,o,s,r,a,l,h,c,d,u){"use strict";e.addComponent({name:"Geospatial",types:{GeoCoordinate:t,GeoElevationGrid:i,GeoLOD:n,GeoLocation:o,GeoMetadata:s,GeoOrigin:r,GeoPositionInterpolator:a,GeoProximitySensor:l,GeoTouchSensor:h,GeoTransform:c,GeoViewpoint:d},abstractTypes:{X3DGeospatialObject:u}})})}();
