(function ()
{
// Undefine global variables.
var module = { }, exports, process;

const
	define  = X3D .define,
	require = X3D .require;
/* -*- Mode: JavaScript; coding: utf-8; tab-width: 3; indent-tabs-mode: tab; c-basic-offset: 3 -*-
 *******************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright create3000, Scheffelstraße 31a, Leipzig, Germany 2011.
 *
 * All rights reserved. Holger Seelig <holger.seelig@yahoo.de>.
 *
 * The copyright notice above does not evidence any actual of intended
 * publication of such source code, and is an unpublished work by create3000.
 * This material contains CONFIDENTIAL INFORMATION that is the property of
 * create3000.
 *
 * No permission is granted to copy, distribute, or create derivative works from
 * the contents of this software, in whole or in part, without the prior written
 * permission of create3000.
 *
 * NON-MILITARY USE ONLY
 *
 * All create3000 software are effectively free software with a non-military use
 * restriction. It is free. Well commented source is provided. You may reuse the
 * source in any way you please with the exception anything that uses it must be
 * marked to indicate is contains 'non-military use only' components.
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2015, 2016 Holger Seelig <holger.seelig@yahoo.de>.
 *
 * This file is part of the X_ITE Project.
 *
 * X_ITE is free software: you can redistribute it and/or modify it under the
 * terms of the GNU General Public License version 3 only, as published by the
 * Free Software Foundation.
 *
 * X_ITE is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License version 3 for more
 * details (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version 3
 * along with X_ITE.  If not, see <http://www.gnu.org/licenses/gpl.html> for a
 * copy of the GPLv3 License.
 *
 * For Silvio, Joy and Adi.
 *
 ******************************************************************************/


define ('x_ite/Components/Texturing3D/X3DTexture3DNode',[
	"x_ite/Components/Texturing/X3DSingleTextureNode",
	"x_ite/Bits/X3DConstants",
],
function (X3DSingleTextureNode,
          X3DConstants)
{
"use strict";

	var defaultData = new Uint8Array ([ 255, 255, 255, 255 ]);

	function X3DTexture3DNode (executionContext)
	{
		X3DSingleTextureNode .call (this, executionContext);

		this .addType (X3DConstants .X3DTexture3DNode);

		const gl = this .getBrowser () .getContext ();

		this .target = gl .TEXTURE_3D;
		this .width  = 0;
		this .height = 0;
		this .depth  = 0;
		this .data   = null;
	}

	X3DTexture3DNode .prototype = Object .assign (Object .create (X3DSingleTextureNode .prototype),
	{
		constructor: X3DTexture3DNode,
		initialize: function ()
		{
			X3DSingleTextureNode .prototype .initialize .call (this);

			this .repeatS_ .addInterest ("updateTextureProperties", this);
			this .repeatT_ .addInterest ("updateTextureProperties", this);
			this .repeatR_ .addInterest ("updateTextureProperties", this);

			const gl = this .getBrowser () .getContext ();

			if (gl .getVersion () < 2)
				return;

			gl .bindTexture (gl .TEXTURE_3D, this .getTexture ());
			gl .texImage3D  (gl .TEXTURE_3D, 0, gl .RGBA, 1, 1, 1, 0, gl .RGBA, gl .UNSIGNED_BYTE, defaultData);
		},
		getTarget: function ()
		{
			return this .target;
		},
		getWidth: function ()
		{
			return this .width;
		},
		getHeight: function ()
		{
			return this .height;
		},
		getDepth: function ()
		{
			return this .depth;
		},
		getFlipY: function ()
		{
			return false;
		},
		getData: function ()
		{
			return this .data;
		},
		clearTexture: function ()
		{
			var gl = this .getBrowser () .getContext ();

			this .setTexture (1, 1, 1, false, gl .RGBA, defaultData);

			this .data = null;
		},
		setTexture: function (width, height, depth, transparent, format, data)
		{
			try
			{
				this .width  = width;
				this .height = height;
				this .depth  = depth;
				this .data   = data;

				var gl = this .getBrowser () .getContext ();

				if (gl .getVersion () < 2)
					return;

				gl .pixelStorei (gl .UNPACK_FLIP_Y_WEBGL, false);
				gl .pixelStorei (gl .UNPACK_ALIGNMENT, 1);
				gl .bindTexture (gl .TEXTURE_3D, this .getTexture ());
				gl .texImage3D  (gl .TEXTURE_3D, 0, format, width, height, depth, 0, format, gl .UNSIGNED_BYTE, data);

				this .setTransparent (transparent);
				this .updateTextureProperties ();
				this .addNodeEvent ();
			}
			catch (error)
			{ }
		},
		updateTextureProperties: function ()
		{
			X3DSingleTextureNode .prototype .updateTextureProperties .call (this,
			                                                                this .target,
			                                                                this .textureProperties_ .getValue (),
			                                                                this .texturePropertiesNode,
			                                                                this .width,
			                                                                this .height,
			                                                                this .repeatS_ .getValue (),
			                                                                this .repeatT_ .getValue (),
			                                                                this .repeatR_ .getValue ());
		},
		setShaderUniformsToChannel: function (gl, shaderObject, renderObject, i)
		{
			if (gl .getVersion () >= 2)
			{
				gl .activeTexture (gl .TEXTURE0 + shaderObject .getBrowser () .getTexture3DUnits () [i]);
				gl .bindTexture (gl .TEXTURE_3D, this .getTexture ());
			}

			gl .uniform1i (shaderObject .x3d_TextureType [i], 3);
		},
	});

	return X3DTexture3DNode;
});

/* -*- Mode: JavaScript; coding: utf-8; tab-width: 3; indent-tabs-mode: tab; c-basic-offset: 3 -*-
 *******************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright create3000, Scheffelstraße 31a, Leipzig, Germany 2011.
 *
 * All rights reserved. Holger Seelig <holger.seelig@yahoo.de>.
 *
 * The copyright notice above does not evidence any actual of intended
 * publication of such source code, and is an unpublished work by create3000.
 * This material contains CONFIDENTIAL INFORMATION that is the property of
 * create3000.
 *
 * No permission is granted to copy, distribute, or create derivative works from
 * the contents of this software, in whole or in part, without the prior written
 * permission of create3000.
 *
 * NON-MILITARY USE ONLY
 *
 * All create3000 software are effectively free software with a non-military use
 * restriction. It is free. Well commented source is provided. You may reuse the
 * source in any way you please with the exception anything that uses it must be
 * marked to indicate is contains 'non-military use only' components.
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2015, 2016 Holger Seelig <holger.seelig@yahoo.de>.
 *
 * This file is part of the X_ITE Project.
 *
 * X_ITE is free software: you can redistribute it and/or modify it under the
 * terms of the GNU General Public License version 3 only, as published by the
 * Free Software Foundation.
 *
 * X_ITE is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License version 3 for more
 * details (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version 3
 * along with X_ITE.  If not, see <http://www.gnu.org/licenses/gpl.html> for a
 * copy of the GPLv3 License.
 *
 * For Silvio, Joy and Adi.
 *
 ******************************************************************************/


define ('x_ite/Components/Texturing3D/ComposedTexture3D',[
	"x_ite/Fields",
	"x_ite/Basic/X3DFieldDefinition",
	"x_ite/Basic/FieldDefinitionArray",
	"x_ite/Components/Texturing3D/X3DTexture3DNode",
	"x_ite/Bits/X3DConstants",
	"x_ite/Bits/X3DCast",
],
function (Fields,
          X3DFieldDefinition,
          FieldDefinitionArray,
          X3DTexture3DNode,
          X3DConstants,
          X3DCast)
{
"use strict";

	function ComposedTexture3D (executionContext)
	{
		X3DTexture3DNode .call (this, executionContext);

		this .addType (X3DConstants .ComposedTexture3D);

		this .addChildObjects ("loadState", new Fields .SFInt32 (X3DConstants .NOT_STARTED_STATE));

		this .textureNodes = [ ];
	}

	ComposedTexture3D .prototype = Object .assign (Object .create (X3DTexture3DNode .prototype),
	{
		constructor: ComposedTexture3D,
		fieldDefinitions: new FieldDefinitionArray ([
			new X3DFieldDefinition (X3DConstants .inputOutput,    "metadata",          new Fields .SFNode ()),
			new X3DFieldDefinition (X3DConstants .inputOutput,    "description",       new Fields .SFString ()),
			new X3DFieldDefinition (X3DConstants .initializeOnly, "repeatS",           new Fields .SFBool ()),
			new X3DFieldDefinition (X3DConstants .initializeOnly, "repeatT",           new Fields .SFBool ()),
			new X3DFieldDefinition (X3DConstants .initializeOnly, "repeatR",           new Fields .SFBool ()),
			new X3DFieldDefinition (X3DConstants .initializeOnly, "textureProperties", new Fields .SFNode ()),
			new X3DFieldDefinition (X3DConstants .inputOutput,    "texture",           new Fields .MFNode ()),
		]),
		getTypeName: function ()
		{
			return "ComposedTexture3D";
		},
		getComponentName: function ()
		{
			return "Texturing3D";
		},
		getContainerField: function ()
		{
			return "texture";
		},
		initialize: function ()
		{
			X3DTexture3DNode .prototype .initialize .call (this);

			this .texture_ .addInterest ("set_texture__", this);

			this .set_texture__ ();
		},
		checkLoadState: function ()
		{
			return this .loadState_ .getValue ();
		},
		set_texture__: function ()
		{
			var textureNodes = this .textureNodes;

			for (var i = 0, length = textureNodes .length; i < length; ++ i)
				textureNodes [i] .removeInterest ("update", this);

			textureNodes .length = 0;

			for (var i = 0, length = this .texture_ .length; i < length; ++ i)
			{
				var textureNode = X3DCast (X3DConstants .X3DTexture2DNode, this .texture_ [i]);

				if (textureNode)
					textureNodes .push (textureNode);
			}

			for (var i = 0, length = textureNodes .length; i < length; ++ i)
				textureNodes [i] .addInterest ("update", this);

			this .update ();
		},
		update: function ()
		{
			var
				textureNodes = this .textureNodes,
				complete     = 0;

			for (var i = 0, length = textureNodes .length; i < length; ++ i)
				complete += textureNodes [i] .checkLoadState () === X3DConstants .COMPLETE_STATE;

			if (textureNodes .length === 0 || complete !== textureNodes .length)
			{
				this .clearTexture ();

				this .loadState_ = X3DConstants .FAILED_STATE;
			}
			else
			{
				var
					gl           = this .getBrowser () .getContext (),
					textureNode0 = textureNodes [0],
					width        = textureNode0 .getWidth (),
					height       = textureNode0 .getHeight (),
					depth        = textureNodes .length,
					transparent  = 0,
					size         = width * height * 4,
					data         = new Uint8Array (size * depth);

				for (var i = 0, d = 0; i < depth; ++ i)
				{
					var
						textureNode = this .textureNodes [i],
						tData       = textureNode .getData ();

					transparent += textureNode .getTransparent ();

					for (var t = 0; t < size; ++ t, ++ d)
					{
						data [d] = tData [t];
					}
				}

				this .setTexture (width, height, depth, !! transparent, gl .RGBA, data);
				this .loadState_ = X3DConstants .COMPLETE_STATE;
			}
		},
	});

	return ComposedTexture3D;
});

/* -*- Mode: JavaScript; coding: utf-8; tab-width: 3; indent-tabs-mode: tab; c-basic-offset: 3 -*-
 *******************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright create3000, Scheffelstraße 31a, Leipzig, Germany 2011.
 *
 * All rights reserved. Holger Seelig <holger.seelig@yahoo.de>.
 *
 * The copyright notice above does not evidence any actual of intended
 * publication of such source code, and is an unpublished work by create3000.
 * This material contains CONFIDENTIAL INFORMATION that is the property of
 * create3000.
 *
 * No permission is granted to copy, distribute, or create derivative works from
 * the contents of this software, in whole or in part, without the prior written
 * permission of create3000.
 *
 * NON-MILITARY USE ONLY
 *
 * All create3000 software are effectively free software with a non-military use
 * restriction. It is free. Well commented source is provided. You may reuse the
 * source in any way you please with the exception anything that uses it must be
 * marked to indicate is contains 'non-military use only' components.
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2015, 2016 Holger Seelig <holger.seelig@yahoo.de>.
 *
 * This file is part of the X_ITE Project.
 *
 * X_ITE is free software: you can redistribute it and/or modify it under the
 * terms of the GNU General Public License version 3 only, as published by the
 * Free Software Foundation.
 *
 * X_ITE is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License version 3 for more
 * details (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version 3
 * along with X_ITE.  If not, see <http://www.gnu.org/licenses/gpl.html> for a
 * copy of the GPLv3 License.
 *
 * For Silvio, Joy and Adi.
 *
 ******************************************************************************/


define ('x_ite/Browser/Texturing3D/NRRDParser',[
	"pako_inflate",
],
function (pako)
{
"use strict";

	// Grammar

	var Grammar =
	{
		NRRD: new RegExp ("^NRRD(\\d+)\\n", 'gy'),
		field: new RegExp ("([\\w\\s]+):\\s*(.+?)\\n", 'gy'),
		comment: new RegExp ("#[^\\n]*\\n", 'gy'),
		newLine: new RegExp ("\n", 'gy'),
		data: new RegExp ("([^]*)$", 'gy'),
	};

	function parse (parser)
	{
		this .lastIndex = parser .lastIndex;

		parser .result = this .exec (parser .input);

		if (parser .result)
		{
			parser .lastIndex = this .lastIndex;
			return true;
		}

		return false;
	}

	for (var key in Grammar)
		Grammar [key] .parse = parse;

	// Parser

	function NRRDParser ()
	{
		this .fieldFunction = new Map ([
			["type",      this .getType],
			["encoding",  this .getEncoding],
			["dimension", this .getDimension],
			["sizes",     this .getSizes],
			["endian",    this .getEndian],
		]);
	}

	NRRDParser .prototype =
	{
		parse: function (input)
		{
			this .setInput (input);

			if (this .getNRRD ())
			{
				this .getFields ();
				this .getData ();
			}

			return this .nrrd;
		},
		setInput: function (value)
		{
			this .input     = value;
			this .lastIndex = 0;
			this .nrrd      = { };
			this .endian    = "little";
		},
		getNRRD: function ()
		{
			if (Grammar .NRRD .parse (this))
			{
				this .nrrd .nrrd    = true;
				this .nrrd .version = parseInt (this .result [1]);
				this .endian        = this .getEndianess ();
				return true;
			}

			this .nrrd .nrrd = false;
			return false;
		},
		getFields: function ()
		{
			while (Grammar .comment .parse (this))
				;

			while (Grammar .field .parse (this))
			{
				var
					key   = this .result [1] .toLowerCase (),
					value = this .result [2] .trim () .toLowerCase (),
					fun   = this .fieldFunction .get (key);

				if (fun)
					fun .call (this, value);

				while (Grammar .comment .parse (this))
					;
			}
		},
		getType: (function ()
		{
			var types = new Map ([
				["signed char",        ["signed char", 1]],
				["int8",               ["signed char", 1]],
				["int8_t",             ["signed char", 1]],
				["uchar",              ["unsigned char", 1]],
				["unsigned char",      ["unsigned char", 1]],
				["uint8",              ["unsigned char", 1]],
				["uint8_t",            ["unsigned char", 1]],
				["short",              ["signed short", 2]],
				["short int",          ["signed short", 2]],
				["signed short",       ["signed short", 2]],
				["signed short int",   ["signed short", 2]],
				["int16",              ["signed short", 2]],
				["int16_t",            ["signed short", 2]],
				["ushort",             ["unsigned short", 2]],
				["unsigned short",     ["unsigned short", 2]],
				["unsigned short int", ["unsigned short", 2]],
				["uint16",             ["unsigned short", 2]],
				["uint16_t",           ["unsigned short", 2]],
				["int",                ["signed int", 4]],
				["signed int",         ["signed int", 4]],
				["int32",              ["signed int", 4]],
				["int32_t",            ["signed int", 4]],
				["uint",               ["unsigned int", 4]],
				["unsigned int",       ["unsigned int", 4]],
				["uint32",             ["unsigned int", 4]],
				["uint32_t",           ["unsigned int", 4]],
				["float",              ["float", 4]],
				["double",             ["double", 8]],
			]);

			return function (value)
			{
				var type = types .get (value);

				if (type === undefined)
					throw new Error ("Unsupported NRRD type '" + value + "'.");

				this .byteType = type [0];
				this .bytes    = type [1];
			};
		})(),
		getEncoding: (function ()
		{
			var encodings = new Map ([
				["ascii", "ascii"],
				["txt",   "ascii"],
				["text",  "ascii"],
				["raw",   "raw"],
				["hex",   "hex"],
				["gz",    "gzip"],
				["gzip",  "gzip"],
			]);

			return function (value)
			{
				var encoding = encodings .get (value);

				if (encoding === undefined)
					throw new Error ("Unsupported NRRD encoding '" + value + "'.");

				this .encoding = encoding;
			};
		})(),
		getDimension: function (value)
		{
			var
				result    = value .match (/(\d+)/),
				dimension = 0;

			if (result)
			{
				dimension = parseInt (result [1]);

				switch (dimension)
				{
					case 1:
					case 2:
					case 3:
					case 4:
						this .dimension = dimension;
						return;
				}
			}

			throw new Error ("Unsupported NRRD dimension '" + dimension + "', must be 1, 2, 3, or 4.");
		},
		getSizes: function (value)
		{
			var
				num    = new RegExp ("\\s*(\\d+)", 'gy'),
				result = null,
				sizes  = [ ];

			while (result = num .exec (value))
			{
				sizes .push (parseInt (result [1]));
			}

			switch (sizes .length)
			{
				case 1:
				{
					this .nrrd .components = 1;
					this .nrrd .width      = sizes [0];
					this .nrrd .height     = 1;
					this .nrrd .depth      = 1;
					return;
				}
				case 2:
				{
					this .nrrd .components = 1;
					this .nrrd .width      = sizes [0];
					this .nrrd .height     = sizes [1];
					this .nrrd .depth      = 1;
					return;
				}
				case 3:
				{
					this .nrrd .components = 1;
					this .nrrd .width      = sizes [0];
					this .nrrd .height     = sizes [1];
					this .nrrd .depth      = sizes [2];
					return;
				}
				case 4:
				{
					this .nrrd .components = sizes [0];
					this .nrrd .width      = sizes [1];
					this .nrrd .height     = sizes [2];
					this .nrrd .depth      = sizes [3];
					return;
				}
				default:
					throw new Error ("Unsupported NRRD sizes.");
			}
		},
		getEndian: function (value)
		{
			if (value === 'little' || value === 'big')
			{
				this .endian = value;
				return;
			}

			throw new Error ("Unsupported NRRD endian, must be 'little' or 'big'.");
		},
		getData: function ()
		{
			switch (this .encoding)
			{
				case "ascii":
				{
					this .ascii ();
					break;
				}
				case "raw":
				{
					this .rawString (this .input);
					break;
				}
				case "hex":
				{
					this .hex ();
					break;
				}
				case "gzip":
				{
					this .gzip ();
					break;
				}
			}
		},
		ascii: function ()
		{
			var
				dataLength = this .nrrd .components * this .nrrd .width * this .nrrd .height * this .nrrd .depth,
				data       = new Uint8Array (dataLength);

			this .nrrd .data = data;

			if (! Grammar .data .parse (this))
				return;

			var numbers = this .result [1] .trim () .split (/\s+/);

			switch (this .byteType)
			{
				case "signed char":
				case "unsigned char":
				{
					numbers .forEach (function (value, i)
					{
						data [i] = parseInt (value);
					});

					return;
				}
				case "signed short":
				case "unsigned short":
				{
					numbers .forEach (function (value, i)
					{
						data [i] = parseInt (value) / 256;
					});

					return;
				}
				case "signed int":
				case "unsigned int":
				{
					numbers .forEach (function (value, i)
					{
						data [i] = parseInt (value) / 16777216;
					});

					return;
				}
				case "float":
				{
					numbers .forEach (function (value, i)
					{
						data [i] = parseFloat (value) / 256;
					});

					return;
				}
				case "double":
				{
					numbers .forEach (function (value, i)
					{
						data [i] = parseFloat (value) / 16777216;
					});

					return;
				}
			}
		},
		rawString: function (input)
		{
			var
				dataLength = this .nrrd .components * this .nrrd .width * this .nrrd .height * this .nrrd .depth,
				length     = dataLength * this .bytes,
				data       = new Uint8Array (dataLength);

			this .nrrd .data = data;

			switch (this .byteType)
			{
				case "signed char":
				case "unsigned char":
				{
					for (var i = input .length - length, d = 0; i < input .length; ++ i, ++ d)
						data [d] = input .charCodeAt (i);

					return;
				}
				case "signed short":
				case "unsigned short":
				{
					if (this .getEndianess () === this .endian)
						var e0 = 0, e1 = 1;
					else
						var e0 = 1, e1 = 0;

					for (var i = input .length - length, d = 0; i < input .length; i += 2, ++ d)
						data [d] = this .short2byte (input .charCodeAt (i + e0),
						                             input .charCodeAt (i + e1));

					return;
				}
				case "signed int":
				case "unsigned int":
				{
					if (this .getEndianess () === this .endian)
						var e0 = 0, e1 = 1, e2 = 2, e3 = 3;
					else
						var e0 = 3, e1 = 2, e2 = 1, e3 = 0;

					for (var i = input .length - length, d = 0; i < input .length; i += 4, ++ d)
						data [d] = this .int2byte (input .charCodeAt (i + e0),
						                           input .charCodeAt (i + e1),
						                           input .charCodeAt (i + e2),
						                           input .charCodeAt (i + e3));

					return;
				}
				case "float":
				{
					if (this .getEndianess () === this .endian)
						var e0 = 0, e1 = 1, e2 = 2, e3 = 3;
					else
						var e0 = 3, e1 = 2, e2 = 1, e3 = 0;

					for (var i = input .length - length, d = 0; i < input .length; i += 4, ++ d)
						data [d] = this .float2byte (input .charCodeAt (i + e0),
						                             input .charCodeAt (i + e1),
						                             input .charCodeAt (i + e2),
						                             input .charCodeAt (i + e3));

					return;
				}
				case "double":
				{
					if (this .getEndianess () === this .endian)
						var e0 = 0, e1 = 1, e2 = 2, e3 = 3, e4 = 4, e5 = 5, e6 = 6, e7 = 7;
					else
						var e0 = 7, e1 = 6, e2 = 5, e3 = 4, e4 = 3, e5 = 2, e6 = 1, e7 = 0;

					for (var i = input .length - length, d = 0; i < input .length; i += 8, ++ d)
						data [d] = this .double2byte (input .charCodeAt (i + e0),
																input .charCodeAt (i + e1),
																input .charCodeAt (i + e2),
																input .charCodeAt (i + e3),
																input .charCodeAt (i + e4),
																input .charCodeAt (i + e5),
																input .charCodeAt (i + e6),
																input .charCodeAt (i + e7));

					return;
				}
			}
		},
		rawArray: function (input)
		{
			var
				dataLength = this .nrrd .components * this .nrrd .width * this .nrrd .height * this .nrrd .depth,
				length     = dataLength * this .bytes,
				data       = new Uint8Array (dataLength);

			this .nrrd .data = data;

			switch (this .byteType)
			{
				case "signed char":
				case "unsigned char":
				{
					for (var i = input .length - length, d = 0; i < input .length; ++ i, ++ d)
						data [d] = input [i];

					return;
				}
				case "signed short":
				case "unsigned short":
				{
					if (this .getEndianess () === this .endian)
						var e0 = 0, e1 = 1;
					else
						var e0 = 1, e1 = 0;

						for (var i = input .length - length, d = 0; i < input .length; i += 2, ++ d)
							data [d] = this .short2byte (input [i + e0],
							                             input [i + e1]);

					return;
				}
				case "signed int":
				case "unsigned int":
				{
					if (this .getEndianess () === this .endian)
						var e0 = 0, e1 = 1, e2 = 2, e3 = 3;
					else
						var e0 = 3, e1 = 2, e2 = 1, e3 = 0;

					for (var i = input .length - length, d = 0; i < input .length; i += 4, ++ d)
						data [d] = this .int2byte (input [i + e0],
						                           input [i + e1],
						                           input [i + e2],
						                           input [i + e3]);

					return;
				}
				case "float":
				{
					if (this .getEndianess () === this .endian)
						var e0 = 0, e1 = 1, e2 = 2, e3 = 3;
					else
						var e0 = 3, e1 = 2, e2 = 1, e3 = 0;

					for (var i = input .length - length, d = 0; i < input .length; i += 4, ++ d)
						data [d] = this .float2byte (input [i + e0],
						                             input [i + e1],
						                             input [i + e2],
						                             input [i + e3]);

					return;
				}
				case "double":
				{
					if (this .getEndianess () === this .endian)
						var e0 = 0, e1 = 1, e2 = 2, e3 = 3, e4 = 4, e5 = 5, e6 = 6, e7 = 7;
					else
						var e0 = 7, e1 = 6, e2 = 5, e3 = 4, e4 = 3, e5 = 2, e6 = 1, e7 = 0;

					for (var i = input .length - length, d = 0; i < input .length; i += 8, ++ d)
						data [d] = this .double2byte (input [i + e0],
																input [i + e1],
																input [i + e2],
																input [i + e3],
																input [i + e4],
																input [i + e5],
																input [i + e6],
																input [i + e7]);

					return;
				}
			}
		},
		hex: function ()
		{
			if (Grammar .data .parse (this))
			{
				var match = this .result [1] .match (/([0-9a-fA-F]{2})/g);

				if (match)
				{
					var raw = match .map (function (value)
					{
						return parseInt (value, 16);
					});

					this .rawArray (raw);
					return;
				}
			}

			throw new Error ("Invalid NRRD data.");
		},
		gzip: function ()
		{
			try
			{
				if (! Grammar .newLine .parse (this))
					throw new Error ("Invalid NRRD data.");

				Grammar .data .parse (this);

				var raw = pako .ungzip (this .result [1], { to: "raw" });

				this .rawArray (raw);
			}
			catch (error)
			{
				throw new Error ("Invalid NRRD data.");
			}
		},
		getEndianess: function ()
		{
			var
				buffer = new ArrayBuffer (4),
				int    = new Uint32Array (buffer),
				bytes  = new Uint8Array (buffer);

			int [0] = 0x01020304;

			if (bytes [0] == 1 && bytes [1] == 2 && bytes [2] == 3 && bytes [3] == 4)
				return 'big';

			if (bytes [0] == 4 && bytes [1] == 3 && bytes [2] == 2 && bytes [3] == 1)
				return 'little';

			throw new Error ("NRRD: unkown system endianess,");
		},
		short2byte: (function ()
		{
			var
				bytes  = new Uint8Array (2),
				number = new Uint16Array (bytes .buffer);

			return function (b0, b1)
			{
				bytes [0] = b0;
				bytes [1] = b1;

				return number [0] / 256;
			};
		})(),
		int2byte: (function ()
		{
			var
				bytes  = new Uint8Array (4),
				number = new Uint32Array (bytes .buffer);

			return function (b0, b1, b2, b3)
			{
				bytes [0] = b0;
				bytes [1] = b1;
				bytes [2] = b2;
				bytes [3] = b3;

				return number [0] / 16777216;
			};
		})(),
		float2byte: (function ()
		{
			var
				bytes  = new Uint8Array (4),
				number = new Float32Array (bytes .buffer);

			return function (b0, b1, b2, b3)
			{
				bytes [0] = b0;
				bytes [1] = b1;
				bytes [2] = b2;
				bytes [3] = b3;

				return number [0] / 256;
			};
		})(),
		double2byte: (function ()
		{
			var
				bytes  = new Uint8Array (8),
				number = new Float64Array (bytes .buffer);

			return function (b0, b1, b2, b3, b4, b5, b6, b7)
			{
				bytes [0] = b0;
				bytes [1] = b1;
				bytes [2] = b2;
				bytes [3] = b3;
				bytes [4] = b4;
				bytes [5] = b5;
				bytes [6] = b6;
				bytes [7] = b7;

				return number [0] / 16777216;
			};
		})(),
	};

	return NRRDParser;
});

// Dummy file instead of zlib needed by dicom-parser.
;
define('zlib', ['zlib/dummy'], function (main) { return main; });

define("zlib/dummy", function(){});

/*! dicom-parser - 1.8.5 - 2021-10-06 | (c) 2017 Chris Hafey | https://github.com/cornerstonejs/dicomParser */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("zlib"));
	else if(typeof define === 'function' && define.amd)
		define("dicom-parser", ["zlib"], factory);
	else if(typeof exports === 'object')
		exports["dicom-parser"] = factory(require("zlib"));
	else
		root["dicomParser"] = factory(root["zlib"]);
})(this, function(__WEBPACK_EXTERNAL_MODULE_zlib__) {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	function hotDisposeChunk(chunkId) {
/******/ 		delete installedChunks[chunkId];
/******/ 	}
/******/ 	var parentHotUpdateCallback = this["webpackHotUpdate"];
/******/ 	this["webpackHotUpdate"] = // eslint-disable-next-line no-unused-vars
/******/ 	function webpackHotUpdateCallback(chunkId, moreModules) {
/******/ 		hotAddUpdateChunk(chunkId, moreModules);
/******/ 		if (parentHotUpdateCallback) parentHotUpdateCallback(chunkId, moreModules);
/******/ 	} ;
/******/
/******/ 	// eslint-disable-next-line no-unused-vars
/******/ 	function hotDownloadUpdateChunk(chunkId) {
/******/ 		var script = document.createElement("script");
/******/ 		script.charset = "utf-8";
/******/ 		script.src = __webpack_require__.p + "" + chunkId + "." + hotCurrentHash + ".hot-update.js";
/******/ 		if (null) script.crossOrigin = null;
/******/ 		document.head.appendChild(script);
/******/ 	}
/******/
/******/ 	// eslint-disable-next-line no-unused-vars
/******/ 	function hotDownloadManifest(requestTimeout) {
/******/ 		requestTimeout = requestTimeout || 10000;
/******/ 		return new Promise(function(resolve, reject) {
/******/ 			if (typeof XMLHttpRequest === "undefined") {
/******/ 				return reject(new Error("No browser support"));
/******/ 			}
/******/ 			try {
/******/ 				var request = new XMLHttpRequest();
/******/ 				var requestPath = __webpack_require__.p + "" + hotCurrentHash + ".hot-update.json";
/******/ 				request.open("GET", requestPath, true);
/******/ 				request.timeout = requestTimeout;
/******/ 				request.send(null);
/******/ 			} catch (err) {
/******/ 				return reject(err);
/******/ 			}
/******/ 			request.onreadystatechange = function() {
/******/ 				if (request.readyState !== 4) return;
/******/ 				if (request.status === 0) {
/******/ 					// timeout
/******/ 					reject(
/******/ 						new Error("Manifest request to " + requestPath + " timed out.")
/******/ 					);
/******/ 				} else if (request.status === 404) {
/******/ 					// no update available
/******/ 					resolve();
/******/ 				} else if (request.status !== 200 && request.status !== 304) {
/******/ 					// other failure
/******/ 					reject(new Error("Manifest request to " + requestPath + " failed."));
/******/ 				} else {
/******/ 					// success
/******/ 					try {
/******/ 						var update = JSON.parse(request.responseText);
/******/ 					} catch (e) {
/******/ 						reject(e);
/******/ 						return;
/******/ 					}
/******/ 					resolve(update);
/******/ 				}
/******/ 			};
/******/ 		});
/******/ 	}
/******/
/******/ 	var hotApplyOnUpdate = true;
/******/ 	// eslint-disable-next-line no-unused-vars
/******/ 	var hotCurrentHash = "10548f5b41ce6f922e03";
/******/ 	var hotRequestTimeout = 10000;
/******/ 	var hotCurrentModuleData = {};
/******/ 	var hotCurrentChildModule;
/******/ 	// eslint-disable-next-line no-unused-vars
/******/ 	var hotCurrentParents = [];
/******/ 	// eslint-disable-next-line no-unused-vars
/******/ 	var hotCurrentParentsTemp = [];
/******/
/******/ 	// eslint-disable-next-line no-unused-vars
/******/ 	function hotCreateRequire(moduleId) {
/******/ 		var me = installedModules[moduleId];
/******/ 		if (!me) return __webpack_require__;
/******/ 		var fn = function(request) {
/******/ 			if (me.hot.active) {
/******/ 				if (installedModules[request]) {
/******/ 					if (installedModules[request].parents.indexOf(moduleId) === -1) {
/******/ 						installedModules[request].parents.push(moduleId);
/******/ 					}
/******/ 				} else {
/******/ 					hotCurrentParents = [moduleId];
/******/ 					hotCurrentChildModule = request;
/******/ 				}
/******/ 				if (me.children.indexOf(request) === -1) {
/******/ 					me.children.push(request);
/******/ 				}
/******/ 			} else {
/******/ 				console.warn(
/******/ 					"[HMR] unexpected require(" +
/******/ 						request +
/******/ 						") from disposed module " +
/******/ 						moduleId
/******/ 				);
/******/ 				hotCurrentParents = [];
/******/ 			}
/******/ 			return __webpack_require__(request);
/******/ 		};
/******/ 		var ObjectFactory = function ObjectFactory(name) {
/******/ 			return {
/******/ 				configurable: true,
/******/ 				enumerable: true,
/******/ 				get: function() {
/******/ 					return __webpack_require__[name];
/******/ 				},
/******/ 				set: function(value) {
/******/ 					__webpack_require__[name] = value;
/******/ 				}
/******/ 			};
/******/ 		};
/******/ 		for (var name in __webpack_require__) {
/******/ 			if (
/******/ 				Object.prototype.hasOwnProperty.call(__webpack_require__, name) &&
/******/ 				name !== "e" &&
/******/ 				name !== "t"
/******/ 			) {
/******/ 				Object.defineProperty(fn, name, ObjectFactory(name));
/******/ 			}
/******/ 		}
/******/ 		fn.e = function(chunkId) {
/******/ 			if (hotStatus === "ready") hotSetStatus("prepare");
/******/ 			hotChunksLoading++;
/******/ 			return __webpack_require__.e(chunkId).then(finishChunkLoading, function(err) {
/******/ 				finishChunkLoading();
/******/ 				throw err;
/******/ 			});
/******/
/******/ 			function finishChunkLoading() {
/******/ 				hotChunksLoading--;
/******/ 				if (hotStatus === "prepare") {
/******/ 					if (!hotWaitingFilesMap[chunkId]) {
/******/ 						hotEnsureUpdateChunk(chunkId);
/******/ 					}
/******/ 					if (hotChunksLoading === 0 && hotWaitingFiles === 0) {
/******/ 						hotUpdateDownloaded();
/******/ 					}
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 		fn.t = function(value, mode) {
/******/ 			if (mode & 1) value = fn(value);
/******/ 			return __webpack_require__.t(value, mode & ~1);
/******/ 		};
/******/ 		return fn;
/******/ 	}
/******/
/******/ 	// eslint-disable-next-line no-unused-vars
/******/ 	function hotCreateModule(moduleId) {
/******/ 		var hot = {
/******/ 			// private stuff
/******/ 			_acceptedDependencies: {},
/******/ 			_declinedDependencies: {},
/******/ 			_selfAccepted: false,
/******/ 			_selfDeclined: false,
/******/ 			_selfInvalidated: false,
/******/ 			_disposeHandlers: [],
/******/ 			_main: hotCurrentChildModule !== moduleId,
/******/
/******/ 			// Module API
/******/ 			active: true,
/******/ 			accept: function(dep, callback) {
/******/ 				if (dep === undefined) hot._selfAccepted = true;
/******/ 				else if (typeof dep === "function") hot._selfAccepted = dep;
/******/ 				else if (typeof dep === "object")
/******/ 					for (var i = 0; i < dep.length; i++)
/******/ 						hot._acceptedDependencies[dep[i]] = callback || function() {};
/******/ 				else hot._acceptedDependencies[dep] = callback || function() {};
/******/ 			},
/******/ 			decline: function(dep) {
/******/ 				if (dep === undefined) hot._selfDeclined = true;
/******/ 				else if (typeof dep === "object")
/******/ 					for (var i = 0; i < dep.length; i++)
/******/ 						hot._declinedDependencies[dep[i]] = true;
/******/ 				else hot._declinedDependencies[dep] = true;
/******/ 			},
/******/ 			dispose: function(callback) {
/******/ 				hot._disposeHandlers.push(callback);
/******/ 			},
/******/ 			addDisposeHandler: function(callback) {
/******/ 				hot._disposeHandlers.push(callback);
/******/ 			},
/******/ 			removeDisposeHandler: function(callback) {
/******/ 				var idx = hot._disposeHandlers.indexOf(callback);
/******/ 				if (idx >= 0) hot._disposeHandlers.splice(idx, 1);
/******/ 			},
/******/ 			invalidate: function() {
/******/ 				this._selfInvalidated = true;
/******/ 				switch (hotStatus) {
/******/ 					case "idle":
/******/ 						hotUpdate = {};
/******/ 						hotUpdate[moduleId] = modules[moduleId];
/******/ 						hotSetStatus("ready");
/******/ 						break;
/******/ 					case "ready":
/******/ 						hotApplyInvalidatedModule(moduleId);
/******/ 						break;
/******/ 					case "prepare":
/******/ 					case "check":
/******/ 					case "dispose":
/******/ 					case "apply":
/******/ 						(hotQueuedInvalidatedModules =
/******/ 							hotQueuedInvalidatedModules || []).push(moduleId);
/******/ 						break;
/******/ 					default:
/******/ 						// ignore requests in error states
/******/ 						break;
/******/ 				}
/******/ 			},
/******/
/******/ 			// Management API
/******/ 			check: hotCheck,
/******/ 			apply: hotApply,
/******/ 			status: function(l) {
/******/ 				if (!l) return hotStatus;
/******/ 				hotStatusHandlers.push(l);
/******/ 			},
/******/ 			addStatusHandler: function(l) {
/******/ 				hotStatusHandlers.push(l);
/******/ 			},
/******/ 			removeStatusHandler: function(l) {
/******/ 				var idx = hotStatusHandlers.indexOf(l);
/******/ 				if (idx >= 0) hotStatusHandlers.splice(idx, 1);
/******/ 			},
/******/
/******/ 			//inherit from previous dispose call
/******/ 			data: hotCurrentModuleData[moduleId]
/******/ 		};
/******/ 		hotCurrentChildModule = undefined;
/******/ 		return hot;
/******/ 	}
/******/
/******/ 	var hotStatusHandlers = [];
/******/ 	var hotStatus = "idle";
/******/
/******/ 	function hotSetStatus(newStatus) {
/******/ 		hotStatus = newStatus;
/******/ 		for (var i = 0; i < hotStatusHandlers.length; i++)
/******/ 			hotStatusHandlers[i].call(null, newStatus);
/******/ 	}
/******/
/******/ 	// while downloading
/******/ 	var hotWaitingFiles = 0;
/******/ 	var hotChunksLoading = 0;
/******/ 	var hotWaitingFilesMap = {};
/******/ 	var hotRequestedFilesMap = {};
/******/ 	var hotAvailableFilesMap = {};
/******/ 	var hotDeferred;
/******/
/******/ 	// The update info
/******/ 	var hotUpdate, hotUpdateNewHash, hotQueuedInvalidatedModules;
/******/
/******/ 	function toModuleId(id) {
/******/ 		var isNumber = +id + "" === id;
/******/ 		return isNumber ? +id : id;
/******/ 	}
/******/
/******/ 	function hotCheck(apply) {
/******/ 		if (hotStatus !== "idle") {
/******/ 			throw new Error("check() is only allowed in idle status");
/******/ 		}
/******/ 		hotApplyOnUpdate = apply;
/******/ 		hotSetStatus("check");
/******/ 		return hotDownloadManifest(hotRequestTimeout).then(function(update) {
/******/ 			if (!update) {
/******/ 				hotSetStatus(hotApplyInvalidatedModules() ? "ready" : "idle");
/******/ 				return null;
/******/ 			}
/******/ 			hotRequestedFilesMap = {};
/******/ 			hotWaitingFilesMap = {};
/******/ 			hotAvailableFilesMap = update.c;
/******/ 			hotUpdateNewHash = update.h;
/******/
/******/ 			hotSetStatus("prepare");
/******/ 			var promise = new Promise(function(resolve, reject) {
/******/ 				hotDeferred = {
/******/ 					resolve: resolve,
/******/ 					reject: reject
/******/ 				};
/******/ 			});
/******/ 			hotUpdate = {};
/******/ 			var chunkId = "dicomParser";
/******/ 			// eslint-disable-next-line no-lone-blocks
/******/ 			{
/******/ 				hotEnsureUpdateChunk(chunkId);
/******/ 			}
/******/ 			if (
/******/ 				hotStatus === "prepare" &&
/******/ 				hotChunksLoading === 0 &&
/******/ 				hotWaitingFiles === 0
/******/ 			) {
/******/ 				hotUpdateDownloaded();
/******/ 			}
/******/ 			return promise;
/******/ 		});
/******/ 	}
/******/
/******/ 	// eslint-disable-next-line no-unused-vars
/******/ 	function hotAddUpdateChunk(chunkId, moreModules) {
/******/ 		if (!hotAvailableFilesMap[chunkId] || !hotRequestedFilesMap[chunkId])
/******/ 			return;
/******/ 		hotRequestedFilesMap[chunkId] = false;
/******/ 		for (var moduleId in moreModules) {
/******/ 			if (Object.prototype.hasOwnProperty.call(moreModules, moduleId)) {
/******/ 				hotUpdate[moduleId] = moreModules[moduleId];
/******/ 			}
/******/ 		}
/******/ 		if (--hotWaitingFiles === 0 && hotChunksLoading === 0) {
/******/ 			hotUpdateDownloaded();
/******/ 		}
/******/ 	}
/******/
/******/ 	function hotEnsureUpdateChunk(chunkId) {
/******/ 		if (!hotAvailableFilesMap[chunkId]) {
/******/ 			hotWaitingFilesMap[chunkId] = true;
/******/ 		} else {
/******/ 			hotRequestedFilesMap[chunkId] = true;
/******/ 			hotWaitingFiles++;
/******/ 			hotDownloadUpdateChunk(chunkId);
/******/ 		}
/******/ 	}
/******/
/******/ 	function hotUpdateDownloaded() {
/******/ 		hotSetStatus("ready");
/******/ 		var deferred = hotDeferred;
/******/ 		hotDeferred = null;
/******/ 		if (!deferred) return;
/******/ 		if (hotApplyOnUpdate) {
/******/ 			// Wrap deferred object in Promise to mark it as a well-handled Promise to
/******/ 			// avoid triggering uncaught exception warning in Chrome.
/******/ 			// See https://bugs.chromium.org/p/chromium/issues/detail?id=465666
/******/ 			Promise.resolve()
/******/ 				.then(function() {
/******/ 					return hotApply(hotApplyOnUpdate);
/******/ 				})
/******/ 				.then(
/******/ 					function(result) {
/******/ 						deferred.resolve(result);
/******/ 					},
/******/ 					function(err) {
/******/ 						deferred.reject(err);
/******/ 					}
/******/ 				);
/******/ 		} else {
/******/ 			var outdatedModules = [];
/******/ 			for (var id in hotUpdate) {
/******/ 				if (Object.prototype.hasOwnProperty.call(hotUpdate, id)) {
/******/ 					outdatedModules.push(toModuleId(id));
/******/ 				}
/******/ 			}
/******/ 			deferred.resolve(outdatedModules);
/******/ 		}
/******/ 	}
/******/
/******/ 	function hotApply(options) {
/******/ 		if (hotStatus !== "ready")
/******/ 			throw new Error("apply() is only allowed in ready status");
/******/ 		options = options || {};
/******/ 		return hotApplyInternal(options);
/******/ 	}
/******/
/******/ 	function hotApplyInternal(options) {
/******/ 		hotApplyInvalidatedModules();
/******/
/******/ 		var cb;
/******/ 		var i;
/******/ 		var j;
/******/ 		var module;
/******/ 		var moduleId;
/******/
/******/ 		function getAffectedStuff(updateModuleId) {
/******/ 			var outdatedModules = [updateModuleId];
/******/ 			var outdatedDependencies = {};
/******/
/******/ 			var queue = outdatedModules.map(function(id) {
/******/ 				return {
/******/ 					chain: [id],
/******/ 					id: id
/******/ 				};
/******/ 			});
/******/ 			while (queue.length > 0) {
/******/ 				var queueItem = queue.pop();
/******/ 				var moduleId = queueItem.id;
/******/ 				var chain = queueItem.chain;
/******/ 				module = installedModules[moduleId];
/******/ 				if (
/******/ 					!module ||
/******/ 					(module.hot._selfAccepted && !module.hot._selfInvalidated)
/******/ 				)
/******/ 					continue;
/******/ 				if (module.hot._selfDeclined) {
/******/ 					return {
/******/ 						type: "self-declined",
/******/ 						chain: chain,
/******/ 						moduleId: moduleId
/******/ 					};
/******/ 				}
/******/ 				if (module.hot._main) {
/******/ 					return {
/******/ 						type: "unaccepted",
/******/ 						chain: chain,
/******/ 						moduleId: moduleId
/******/ 					};
/******/ 				}
/******/ 				for (var i = 0; i < module.parents.length; i++) {
/******/ 					var parentId = module.parents[i];
/******/ 					var parent = installedModules[parentId];
/******/ 					if (!parent) continue;
/******/ 					if (parent.hot._declinedDependencies[moduleId]) {
/******/ 						return {
/******/ 							type: "declined",
/******/ 							chain: chain.concat([parentId]),
/******/ 							moduleId: moduleId,
/******/ 							parentId: parentId
/******/ 						};
/******/ 					}
/******/ 					if (outdatedModules.indexOf(parentId) !== -1) continue;
/******/ 					if (parent.hot._acceptedDependencies[moduleId]) {
/******/ 						if (!outdatedDependencies[parentId])
/******/ 							outdatedDependencies[parentId] = [];
/******/ 						addAllToSet(outdatedDependencies[parentId], [moduleId]);
/******/ 						continue;
/******/ 					}
/******/ 					delete outdatedDependencies[parentId];
/******/ 					outdatedModules.push(parentId);
/******/ 					queue.push({
/******/ 						chain: chain.concat([parentId]),
/******/ 						id: parentId
/******/ 					});
/******/ 				}
/******/ 			}
/******/
/******/ 			return {
/******/ 				type: "accepted",
/******/ 				moduleId: updateModuleId,
/******/ 				outdatedModules: outdatedModules,
/******/ 				outdatedDependencies: outdatedDependencies
/******/ 			};
/******/ 		}
/******/
/******/ 		function addAllToSet(a, b) {
/******/ 			for (var i = 0; i < b.length; i++) {
/******/ 				var item = b[i];
/******/ 				if (a.indexOf(item) === -1) a.push(item);
/******/ 			}
/******/ 		}
/******/
/******/ 		// at begin all updates modules are outdated
/******/ 		// the "outdated" status can propagate to parents if they don't accept the children
/******/ 		var outdatedDependencies = {};
/******/ 		var outdatedModules = [];
/******/ 		var appliedUpdate = {};
/******/
/******/ 		var warnUnexpectedRequire = function warnUnexpectedRequire() {
/******/ 			console.warn(
/******/ 				"[HMR] unexpected require(" + result.moduleId + ") to disposed module"
/******/ 			);
/******/ 		};
/******/
/******/ 		for (var id in hotUpdate) {
/******/ 			if (Object.prototype.hasOwnProperty.call(hotUpdate, id)) {
/******/ 				moduleId = toModuleId(id);
/******/ 				/** @type {TODO} */
/******/ 				var result;
/******/ 				if (hotUpdate[id]) {
/******/ 					result = getAffectedStuff(moduleId);
/******/ 				} else {
/******/ 					result = {
/******/ 						type: "disposed",
/******/ 						moduleId: id
/******/ 					};
/******/ 				}
/******/ 				/** @type {Error|false} */
/******/ 				var abortError = false;
/******/ 				var doApply = false;
/******/ 				var doDispose = false;
/******/ 				var chainInfo = "";
/******/ 				if (result.chain) {
/******/ 					chainInfo = "\nUpdate propagation: " + result.chain.join(" -> ");
/******/ 				}
/******/ 				switch (result.type) {
/******/ 					case "self-declined":
/******/ 						if (options.onDeclined) options.onDeclined(result);
/******/ 						if (!options.ignoreDeclined)
/******/ 							abortError = new Error(
/******/ 								"Aborted because of self decline: " +
/******/ 									result.moduleId +
/******/ 									chainInfo
/******/ 							);
/******/ 						break;
/******/ 					case "declined":
/******/ 						if (options.onDeclined) options.onDeclined(result);
/******/ 						if (!options.ignoreDeclined)
/******/ 							abortError = new Error(
/******/ 								"Aborted because of declined dependency: " +
/******/ 									result.moduleId +
/******/ 									" in " +
/******/ 									result.parentId +
/******/ 									chainInfo
/******/ 							);
/******/ 						break;
/******/ 					case "unaccepted":
/******/ 						if (options.onUnaccepted) options.onUnaccepted(result);
/******/ 						if (!options.ignoreUnaccepted)
/******/ 							abortError = new Error(
/******/ 								"Aborted because " + moduleId + " is not accepted" + chainInfo
/******/ 							);
/******/ 						break;
/******/ 					case "accepted":
/******/ 						if (options.onAccepted) options.onAccepted(result);
/******/ 						doApply = true;
/******/ 						break;
/******/ 					case "disposed":
/******/ 						if (options.onDisposed) options.onDisposed(result);
/******/ 						doDispose = true;
/******/ 						break;
/******/ 					default:
/******/ 						throw new Error("Unexception type " + result.type);
/******/ 				}
/******/ 				if (abortError) {
/******/ 					hotSetStatus("abort");
/******/ 					return Promise.reject(abortError);
/******/ 				}
/******/ 				if (doApply) {
/******/ 					appliedUpdate[moduleId] = hotUpdate[moduleId];
/******/ 					addAllToSet(outdatedModules, result.outdatedModules);
/******/ 					for (moduleId in result.outdatedDependencies) {
/******/ 						if (
/******/ 							Object.prototype.hasOwnProperty.call(
/******/ 								result.outdatedDependencies,
/******/ 								moduleId
/******/ 							)
/******/ 						) {
/******/ 							if (!outdatedDependencies[moduleId])
/******/ 								outdatedDependencies[moduleId] = [];
/******/ 							addAllToSet(
/******/ 								outdatedDependencies[moduleId],
/******/ 								result.outdatedDependencies[moduleId]
/******/ 							);
/******/ 						}
/******/ 					}
/******/ 				}
/******/ 				if (doDispose) {
/******/ 					addAllToSet(outdatedModules, [result.moduleId]);
/******/ 					appliedUpdate[moduleId] = warnUnexpectedRequire;
/******/ 				}
/******/ 			}
/******/ 		}
/******/
/******/ 		// Store self accepted outdated modules to require them later by the module system
/******/ 		var outdatedSelfAcceptedModules = [];
/******/ 		for (i = 0; i < outdatedModules.length; i++) {
/******/ 			moduleId = outdatedModules[i];
/******/ 			if (
/******/ 				installedModules[moduleId] &&
/******/ 				installedModules[moduleId].hot._selfAccepted &&
/******/ 				// removed self-accepted modules should not be required
/******/ 				appliedUpdate[moduleId] !== warnUnexpectedRequire &&
/******/ 				// when called invalidate self-accepting is not possible
/******/ 				!installedModules[moduleId].hot._selfInvalidated
/******/ 			) {
/******/ 				outdatedSelfAcceptedModules.push({
/******/ 					module: moduleId,
/******/ 					parents: installedModules[moduleId].parents.slice(),
/******/ 					errorHandler: installedModules[moduleId].hot._selfAccepted
/******/ 				});
/******/ 			}
/******/ 		}
/******/
/******/ 		// Now in "dispose" phase
/******/ 		hotSetStatus("dispose");
/******/ 		Object.keys(hotAvailableFilesMap).forEach(function(chunkId) {
/******/ 			if (hotAvailableFilesMap[chunkId] === false) {
/******/ 				hotDisposeChunk(chunkId);
/******/ 			}
/******/ 		});
/******/
/******/ 		var idx;
/******/ 		var queue = outdatedModules.slice();
/******/ 		while (queue.length > 0) {
/******/ 			moduleId = queue.pop();
/******/ 			module = installedModules[moduleId];
/******/ 			if (!module) continue;
/******/
/******/ 			var data = {};
/******/
/******/ 			// Call dispose handlers
/******/ 			var disposeHandlers = module.hot._disposeHandlers;
/******/ 			for (j = 0; j < disposeHandlers.length; j++) {
/******/ 				cb = disposeHandlers[j];
/******/ 				cb(data);
/******/ 			}
/******/ 			hotCurrentModuleData[moduleId] = data;
/******/
/******/ 			// disable module (this disables requires from this module)
/******/ 			module.hot.active = false;
/******/
/******/ 			// remove module from cache
/******/ 			delete installedModules[moduleId];
/******/
/******/ 			// when disposing there is no need to call dispose handler
/******/ 			delete outdatedDependencies[moduleId];
/******/
/******/ 			// remove "parents" references from all children
/******/ 			for (j = 0; j < module.children.length; j++) {
/******/ 				var child = installedModules[module.children[j]];
/******/ 				if (!child) continue;
/******/ 				idx = child.parents.indexOf(moduleId);
/******/ 				if (idx >= 0) {
/******/ 					child.parents.splice(idx, 1);
/******/ 				}
/******/ 			}
/******/ 		}
/******/
/******/ 		// remove outdated dependency from module children
/******/ 		var dependency;
/******/ 		var moduleOutdatedDependencies;
/******/ 		for (moduleId in outdatedDependencies) {
/******/ 			if (
/******/ 				Object.prototype.hasOwnProperty.call(outdatedDependencies, moduleId)
/******/ 			) {
/******/ 				module = installedModules[moduleId];
/******/ 				if (module) {
/******/ 					moduleOutdatedDependencies = outdatedDependencies[moduleId];
/******/ 					for (j = 0; j < moduleOutdatedDependencies.length; j++) {
/******/ 						dependency = moduleOutdatedDependencies[j];
/******/ 						idx = module.children.indexOf(dependency);
/******/ 						if (idx >= 0) module.children.splice(idx, 1);
/******/ 					}
/******/ 				}
/******/ 			}
/******/ 		}
/******/
/******/ 		// Now in "apply" phase
/******/ 		hotSetStatus("apply");
/******/
/******/ 		if (hotUpdateNewHash !== undefined) {
/******/ 			hotCurrentHash = hotUpdateNewHash;
/******/ 			hotUpdateNewHash = undefined;
/******/ 		}
/******/ 		hotUpdate = undefined;
/******/
/******/ 		// insert new code
/******/ 		for (moduleId in appliedUpdate) {
/******/ 			if (Object.prototype.hasOwnProperty.call(appliedUpdate, moduleId)) {
/******/ 				modules[moduleId] = appliedUpdate[moduleId];
/******/ 			}
/******/ 		}
/******/
/******/ 		// call accept handlers
/******/ 		var error = null;
/******/ 		for (moduleId in outdatedDependencies) {
/******/ 			if (
/******/ 				Object.prototype.hasOwnProperty.call(outdatedDependencies, moduleId)
/******/ 			) {
/******/ 				module = installedModules[moduleId];
/******/ 				if (module) {
/******/ 					moduleOutdatedDependencies = outdatedDependencies[moduleId];
/******/ 					var callbacks = [];
/******/ 					for (i = 0; i < moduleOutdatedDependencies.length; i++) {
/******/ 						dependency = moduleOutdatedDependencies[i];
/******/ 						cb = module.hot._acceptedDependencies[dependency];
/******/ 						if (cb) {
/******/ 							if (callbacks.indexOf(cb) !== -1) continue;
/******/ 							callbacks.push(cb);
/******/ 						}
/******/ 					}
/******/ 					for (i = 0; i < callbacks.length; i++) {
/******/ 						cb = callbacks[i];
/******/ 						try {
/******/ 							cb(moduleOutdatedDependencies);
/******/ 						} catch (err) {
/******/ 							if (options.onErrored) {
/******/ 								options.onErrored({
/******/ 									type: "accept-errored",
/******/ 									moduleId: moduleId,
/******/ 									dependencyId: moduleOutdatedDependencies[i],
/******/ 									error: err
/******/ 								});
/******/ 							}
/******/ 							if (!options.ignoreErrored) {
/******/ 								if (!error) error = err;
/******/ 							}
/******/ 						}
/******/ 					}
/******/ 				}
/******/ 			}
/******/ 		}
/******/
/******/ 		// Load self accepted modules
/******/ 		for (i = 0; i < outdatedSelfAcceptedModules.length; i++) {
/******/ 			var item = outdatedSelfAcceptedModules[i];
/******/ 			moduleId = item.module;
/******/ 			hotCurrentParents = item.parents;
/******/ 			hotCurrentChildModule = moduleId;
/******/ 			try {
/******/ 				__webpack_require__(moduleId);
/******/ 			} catch (err) {
/******/ 				if (typeof item.errorHandler === "function") {
/******/ 					try {
/******/ 						item.errorHandler(err);
/******/ 					} catch (err2) {
/******/ 						if (options.onErrored) {
/******/ 							options.onErrored({
/******/ 								type: "self-accept-error-handler-errored",
/******/ 								moduleId: moduleId,
/******/ 								error: err2,
/******/ 								originalError: err
/******/ 							});
/******/ 						}
/******/ 						if (!options.ignoreErrored) {
/******/ 							if (!error) error = err2;
/******/ 						}
/******/ 						if (!error) error = err;
/******/ 					}
/******/ 				} else {
/******/ 					if (options.onErrored) {
/******/ 						options.onErrored({
/******/ 							type: "self-accept-errored",
/******/ 							moduleId: moduleId,
/******/ 							error: err
/******/ 						});
/******/ 					}
/******/ 					if (!options.ignoreErrored) {
/******/ 						if (!error) error = err;
/******/ 					}
/******/ 				}
/******/ 			}
/******/ 		}
/******/
/******/ 		// handle errors in accept handlers and self accepted module load
/******/ 		if (error) {
/******/ 			hotSetStatus("fail");
/******/ 			return Promise.reject(error);
/******/ 		}
/******/
/******/ 		if (hotQueuedInvalidatedModules) {
/******/ 			return hotApplyInternal(options).then(function(list) {
/******/ 				outdatedModules.forEach(function(moduleId) {
/******/ 					if (list.indexOf(moduleId) < 0) list.push(moduleId);
/******/ 				});
/******/ 				return list;
/******/ 			});
/******/ 		}
/******/
/******/ 		hotSetStatus("idle");
/******/ 		return new Promise(function(resolve) {
/******/ 			resolve(outdatedModules);
/******/ 		});
/******/ 	}
/******/
/******/ 	function hotApplyInvalidatedModules() {
/******/ 		if (hotQueuedInvalidatedModules) {
/******/ 			if (!hotUpdate) hotUpdate = {};
/******/ 			hotQueuedInvalidatedModules.forEach(hotApplyInvalidatedModule);
/******/ 			hotQueuedInvalidatedModules = undefined;
/******/ 			return true;
/******/ 		}
/******/ 	}
/******/
/******/ 	function hotApplyInvalidatedModule(moduleId) {
/******/ 		if (!Object.prototype.hasOwnProperty.call(hotUpdate, moduleId))
/******/ 			hotUpdate[moduleId] = modules[moduleId];
/******/ 	}
/******/
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {},
/******/ 			hot: hotCreateModule(moduleId),
/******/ 			parents: (hotCurrentParentsTemp = hotCurrentParents, hotCurrentParents = [], hotCurrentParentsTemp),
/******/ 			children: []
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, hotCreateRequire(moduleId));
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// __webpack_hash__
/******/ 	__webpack_require__.h = function() { return hotCurrentHash; };
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return hotCreateRequire("./index.js")(__webpack_require__.s = "./index.js");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./alloc.js":
/*!******************!*\
  !*** ./alloc.js ***!
  \******************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return alloc; });
/**
 * Creates a new byteArray of the same type (Uint8Array or Buffer) of the specified length.
 * @param byteArray the underlying byteArray (either Uint8Array or Buffer)
 * @param length number of bytes of the Byte Array
 * @returns {object} Uint8Array or Buffer depending on the type of byteArray
 */
function alloc(byteArray, length) {
  if (typeof Buffer !== 'undefined' && byteArray instanceof Buffer) {
    return Buffer.alloc(length);
  } else if (byteArray instanceof Uint8Array) {
    return new Uint8Array(length);
  }

  throw 'dicomParser.alloc: unknown type for byteArray';
}

/***/ }),

/***/ "./bigEndianByteArrayParser.js":
/*!*************************************!*\
  !*** ./bigEndianByteArrayParser.js ***!
  \*************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/**
 * Internal helper functions for parsing different types from a big-endian byte array
 */
/* harmony default export */ __webpack_exports__["default"] = ({
  /**
     *
     * Parses an unsigned int 16 from a big-endian byte array
     *
     * @param byteArray the byte array to read from
     * @param position the position in the byte array to read from
     * @returns {*} the parsed unsigned int 16
     * @throws error if buffer overread would occur
     * @access private
     */
  readUint16: function readUint16(byteArray, position) {
    if (position < 0) {
      throw 'bigEndianByteArrayParser.readUint16: position cannot be less than 0';
    }

    if (position + 2 > byteArray.length) {
      throw 'bigEndianByteArrayParser.readUint16: attempt to read past end of buffer';
    }

    return (byteArray[position] << 8) + byteArray[position + 1];
  },

  /**
     *
     * Parses a signed int 16 from a big-endian byte array
     *
     * @param byteArray the byte array to read from
     * @param position the position in the byte array to read from
     * @returns {*} the parsed signed int 16
     * @throws error if buffer overread would occur
     * @access private
     */
  readInt16: function readInt16(byteArray, position) {
    if (position < 0) {
      throw 'bigEndianByteArrayParser.readInt16: position cannot be less than 0';
    }

    if (position + 2 > byteArray.length) {
      throw 'bigEndianByteArrayParser.readInt16: attempt to read past end of buffer';
    }

    var int16 = (byteArray[position] << 8) + byteArray[position + 1]; // fix sign

    if (int16 & 0x8000) {
      int16 = int16 - 0xFFFF - 1;
    }

    return int16;
  },

  /**
     * Parses an unsigned int 32 from a big-endian byte array
     *
     * @param byteArray the byte array to read from
     * @param position the position in the byte array to read from
     * @returns {*} the parsed unsigned int 32
     * @throws error if buffer overread would occur
     * @access private
     */
  readUint32: function readUint32(byteArray, position) {
    if (position < 0) {
      throw 'bigEndianByteArrayParser.readUint32: position cannot be less than 0';
    }

    if (position + 4 > byteArray.length) {
      throw 'bigEndianByteArrayParser.readUint32: attempt to read past end of buffer';
    }

    var uint32 = 256 * (256 * (256 * byteArray[position] + byteArray[position + 1]) + byteArray[position + 2]) + byteArray[position + 3];
    return uint32;
  },

  /**
     * Parses a signed int 32 from a big-endian byte array
     *
     * @param byteArray the byte array to read from
     * @param position the position in the byte array to read from
     * @returns {*} the parsed signed int 32
     * @throws error if buffer overread would occur
     * @access private
     */
  readInt32: function readInt32(byteArray, position) {
    if (position < 0) {
      throw 'bigEndianByteArrayParser.readInt32: position cannot be less than 0';
    }

    if (position + 4 > byteArray.length) {
      throw 'bigEndianByteArrayParser.readInt32: attempt to read past end of buffer';
    }

    var int32 = (byteArray[position] << 24) + (byteArray[position + 1] << 16) + (byteArray[position + 2] << 8) + byteArray[position + 3];
    return int32;
  },

  /**
     * Parses 32-bit float from a big-endian byte array
     *
     * @param byteArray the byte array to read from
     * @param position the position in the byte array to read from
     * @returns {*} the parsed 32-bit float
     * @throws error if buffer overread would occur
     * @access private
     */
  readFloat: function readFloat(byteArray, position) {
    if (position < 0) {
      throw 'bigEndianByteArrayParser.readFloat: position cannot be less than 0';
    }

    if (position + 4 > byteArray.length) {
      throw 'bigEndianByteArrayParser.readFloat: attempt to read past end of buffer';
    } // I am sure there is a better way than this but this should be safe


    var byteArrayForParsingFloat = new Uint8Array(4);
    byteArrayForParsingFloat[3] = byteArray[position];
    byteArrayForParsingFloat[2] = byteArray[position + 1];
    byteArrayForParsingFloat[1] = byteArray[position + 2];
    byteArrayForParsingFloat[0] = byteArray[position + 3];
    var floatArray = new Float32Array(byteArrayForParsingFloat.buffer);
    return floatArray[0];
  },

  /**
     * Parses 64-bit float from a big-endian byte array
     *
     * @param byteArray the byte array to read from
     * @param position the position in the byte array to read from
     * @returns {*} the parsed 64-bit float
     * @throws error if buffer overread would occur
     * @access private
     */
  readDouble: function readDouble(byteArray, position) {
    if (position < 0) {
      throw 'bigEndianByteArrayParser.readDouble: position cannot be less than 0';
    }

    if (position + 8 > byteArray.length) {
      throw 'bigEndianByteArrayParser.readDouble: attempt to read past end of buffer';
    } // I am sure there is a better way than this but this should be safe


    var byteArrayForParsingFloat = new Uint8Array(8);
    byteArrayForParsingFloat[7] = byteArray[position];
    byteArrayForParsingFloat[6] = byteArray[position + 1];
    byteArrayForParsingFloat[5] = byteArray[position + 2];
    byteArrayForParsingFloat[4] = byteArray[position + 3];
    byteArrayForParsingFloat[3] = byteArray[position + 4];
    byteArrayForParsingFloat[2] = byteArray[position + 5];
    byteArrayForParsingFloat[1] = byteArray[position + 6];
    byteArrayForParsingFloat[0] = byteArray[position + 7];
    var floatArray = new Float64Array(byteArrayForParsingFloat.buffer);
    return floatArray[0];
  }
});

/***/ }),

/***/ "./byteArrayParser.js":
/*!****************************!*\
  !*** ./byteArrayParser.js ***!
  \****************************/
/*! exports provided: readFixedString */
/***/ (function(module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "readFixedString", function() { return readFixedString; });
/**
 * Internal helper functions common to parsing byte arrays of any type
 */

/**
 * Reads a string of 8-bit characters from an array of bytes and advances
 * the position by length bytes.  A null terminator will end the string
 * but will not effect advancement of the position.  Trailing and leading
 * spaces are preserved (not trimmed)
 * @param byteArray the byteArray to read from
 * @param position the position in the byte array to read from
 * @param length the maximum number of bytes to parse
 * @returns {string} the parsed string
 * @throws error if buffer overread would occur
 * @access private
 */
function readFixedString(byteArray, position, length) {
  if (length < 0) {
    throw 'dicomParser.readFixedString - length cannot be less than 0';
  }

  if (position + length > byteArray.length) {
    throw 'dicomParser.readFixedString: attempt to read past end of buffer';
  }

  var result = '';

  var _byte;

  for (var i = 0; i < length; i++) {
    _byte = byteArray[position + i];

    if (_byte === 0) {
      position += length;
      return result;
    }

    result += String.fromCharCode(_byte);
  }

  return result;
}

/***/ }),

/***/ "./byteStream.js":
/*!***********************!*\
  !*** ./byteStream.js ***!
  \***********************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return ByteStream; });
/* harmony import */ var _sharedCopy_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./sharedCopy.js */ "./sharedCopy.js");
/* harmony import */ var _byteArrayParser_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./byteArrayParser.js */ "./byteArrayParser.js");
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }



/**
 *
 * Internal helper class to assist with parsing. Supports reading from a byte
 * stream contained in a Uint8Array.  Example usage:
 *
 *  var byteArray = new Uint8Array(32);
 *  var byteStream = new dicomParser.ByteStream(dicomParser.littleEndianByteArrayParser, byteArray);
 *
 * */

/**
 * Constructor for ByteStream objects.
 * @param byteArrayParser a parser for parsing the byte array
 * @param byteArray a Uint8Array containing the byte stream
 * @param position (optional) the position to start reading from.  0 if not specified
 * @constructor
 * @throws will throw an error if the byteArrayParser parameter is not present
 * @throws will throw an error if the byteArray parameter is not present or invalid
 * @throws will throw an error if the position parameter is not inside the byte array
 */

var ByteStream = /*#__PURE__*/function () {
  function ByteStream(byteArrayParser, byteArray, position) {
    _classCallCheck(this, ByteStream);

    if (byteArrayParser === undefined) {
      throw 'dicomParser.ByteStream: missing required parameter \'byteArrayParser\'';
    }

    if (byteArray === undefined) {
      throw 'dicomParser.ByteStream: missing required parameter \'byteArray\'';
    }

    if (byteArray instanceof Uint8Array === false && (typeof Buffer === 'undefined' || byteArray instanceof Buffer === false)) {
      throw 'dicomParser.ByteStream: parameter byteArray is not of type Uint8Array or Buffer';
    }

    if (position < 0) {
      throw 'dicomParser.ByteStream: parameter \'position\' cannot be less than 0';
    }

    if (position >= byteArray.length) {
      throw 'dicomParser.ByteStream: parameter \'position\' cannot be greater than or equal to \'byteArray\' length';
    }

    this.byteArrayParser = byteArrayParser;
    this.byteArray = byteArray;
    this.position = position ? position : 0;
    this.warnings = []; // array of string warnings encountered while parsing
  }
  /**
     * Safely seeks through the byte stream.  Will throw an exception if an attempt
     * is made to seek outside of the byte array.
     * @param offset the number of bytes to add to the position
     * @throws error if seek would cause position to be outside of the byteArray
     */


  _createClass(ByteStream, [{
    key: "seek",
    value: function seek(offset) {
      if (this.position + offset < 0) {
        throw 'dicomParser.ByteStream.prototype.seek: cannot seek to position < 0';
      }

      this.position += offset;
    }
    /**
       * Returns a new ByteStream object from the current position and of the requested number of bytes
       * @param numBytes the length of the byte array for the ByteStream to contain
       * @returns {dicomParser.ByteStream}
       * @throws error if buffer overread would occur
       */

  }, {
    key: "readByteStream",
    value: function readByteStream(numBytes) {
      if (this.position + numBytes > this.byteArray.length) {
        throw 'dicomParser.ByteStream.prototype.readByteStream: readByteStream - buffer overread';
      }

      var byteArrayView = Object(_sharedCopy_js__WEBPACK_IMPORTED_MODULE_0__["default"])(this.byteArray, this.position, numBytes);
      this.position += numBytes;
      return new ByteStream(this.byteArrayParser, byteArrayView);
    }
    /**
       *
       * Parses an unsigned int 16 from a byte array and advances
       * the position by 2 bytes
       *
       * @returns {*} the parsed unsigned int 16
       * @throws error if buffer overread would occur
       */

  }, {
    key: "readUint16",
    value: function readUint16() {
      var result = this.byteArrayParser.readUint16(this.byteArray, this.position);
      this.position += 2;
      return result;
    }
    /**
       * Parses an unsigned int 32 from a byte array and advances
       * the position by 2 bytes
       *
       * @returns {*} the parse unsigned int 32
       * @throws error if buffer overread would occur
       */

  }, {
    key: "readUint32",
    value: function readUint32() {
      var result = this.byteArrayParser.readUint32(this.byteArray, this.position);
      this.position += 4;
      return result;
    }
    /**
       * Reads a string of 8-bit characters from an array of bytes and advances
       * the position by length bytes.  A null terminator will end the string
       * but will not effect advancement of the position.
       * @param length the maximum number of bytes to parse
       * @returns {string} the parsed string
       * @throws error if buffer overread would occur
       */

  }, {
    key: "readFixedString",
    value: function readFixedString(length) {
      var result = Object(_byteArrayParser_js__WEBPACK_IMPORTED_MODULE_1__["readFixedString"])(this.byteArray, this.position, length);

      this.position += length;
      return result;
    }
  }]);

  return ByteStream;
}();



/***/ }),

/***/ "./dataSet.js":
/*!********************!*\
  !*** ./dataSet.js ***!
  \********************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return DataSet; });
/* harmony import */ var _byteArrayParser_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./byteArrayParser.js */ "./byteArrayParser.js");
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }


/**
 *
 * The DataSet class encapsulates a collection of DICOM Elements and provides various functions
 * to access the data in those elements
 *
 * Rules for handling padded spaces:
 * DS = Strip leading and trailing spaces
 * DT = Strip trailing spaces
 * IS = Strip leading and trailing spaces
 * PN = Strip trailing spaces
 * TM = Strip trailing spaces
 * AE = Strip leading and trailing spaces
 * CS = Strip leading and trailing spaces
 * SH = Strip leading and trailing spaces
 * LO = Strip leading and trailing spaces
 * LT = Strip trailing spaces
 * ST = Strip trailing spaces
 * UT = Strip trailing spaces
 *
 */

function getByteArrayParser(element, defaultParser) {
  return element.parser !== undefined ? element.parser : defaultParser;
}
/**
 * Constructs a new DataSet given byteArray and collection of elements
 * @param byteArrayParser
 * @param byteArray
 * @param elements
 * @constructor
 */


var DataSet = /*#__PURE__*/function () {
  function DataSet(byteArrayParser, byteArray, elements) {
    _classCallCheck(this, DataSet);

    this.byteArrayParser = byteArrayParser;
    this.byteArray = byteArray;
    this.elements = elements;
  }
  /**
     * Finds the element for tag and returns an unsigned int 16 if it exists and has data
     * @param tag The DICOM tag in the format xGGGGEEEE
     * @param index the index of the value in a multivalued element.  Default is index 0 if not supplied
     * @returns {*} unsigned int 16 or undefined if the attribute is not present or has data of length 0
     */


  _createClass(DataSet, [{
    key: "uint16",
    value: function uint16(tag, index) {
      var element = this.elements[tag];
      index = index !== undefined ? index : 0;

      if (element && element.length !== 0) {
        return getByteArrayParser(element, this.byteArrayParser).readUint16(this.byteArray, element.dataOffset + index * 2);
      }

      return undefined;
    }
    /**
       * Finds the element for tag and returns an signed int 16 if it exists and has data
       * @param tag The DICOM tag in the format xGGGGEEEE
       * @param index the index of the value in a multivalued element.  Default is index 0 if not supplied
       * @returns {*} signed int 16 or undefined if the attribute is not present or has data of length 0
       */

  }, {
    key: "int16",
    value: function int16(tag, index) {
      var element = this.elements[tag];
      index = index !== undefined ? index : 0;

      if (element && element.length !== 0) {
        return getByteArrayParser(element, this.byteArrayParser).readInt16(this.byteArray, element.dataOffset + index * 2);
      }

      return undefined;
    }
    /**
       * Finds the element for tag and returns an unsigned int 32 if it exists and has data
       * @param tag The DICOM tag in the format xGGGGEEEE
       * @param index the index of the value in a multivalued element.  Default is index 0 if not supplied
       * @returns {*} unsigned int 32 or undefined if the attribute is not present or has data of length 0
       */

  }, {
    key: "uint32",
    value: function uint32(tag, index) {
      var element = this.elements[tag];
      index = index !== undefined ? index : 0;

      if (element && element.length !== 0) {
        return getByteArrayParser(element, this.byteArrayParser).readUint32(this.byteArray, element.dataOffset + index * 4);
      }

      return undefined;
    }
    /**
       * Finds the element for tag and returns an signed int 32 if it exists and has data
       * @param tag The DICOM tag in the format xGGGGEEEE
       * @param index the index of the value in a multivalued element.  Default is index 0 if not supplied
       * @returns {*} signed int 32 or undefined if the attribute is not present or has data of length 0
       */

  }, {
    key: "int32",
    value: function int32(tag, index) {
      var element = this.elements[tag];
      index = index !== undefined ? index : 0;

      if (element && element.length !== 0) {
        return getByteArrayParser(element, this.byteArrayParser).readInt32(this.byteArray, element.dataOffset + index * 4);
      }

      return undefined;
    }
    /**
       * Finds the element for tag and returns a 32 bit floating point number (VR=FL) if it exists and has data
       * @param tag The DICOM tag in the format xGGGGEEEE
       * @param index the index of the value in a multivalued element.  Default is index 0 if not supplied
       * @returns {*} float or undefined if the attribute is not present or has data of length 0
       */

  }, {
    key: "float",
    value: function float(tag, index) {
      var element = this.elements[tag];
      index = index !== undefined ? index : 0;

      if (element && element.length !== 0) {
        return getByteArrayParser(element, this.byteArrayParser).readFloat(this.byteArray, element.dataOffset + index * 4);
      }

      return undefined;
    }
    /**
       * Finds the element for tag and returns a 64 bit floating point number (VR=FD) if it exists and has data
       * @param tag The DICOM tag in the format xGGGGEEEE
       * @param index the index of the value in a multivalued element.  Default is index 0 if not supplied
       * @returns {*} float or undefined if the attribute is not present or doesn't has data of length 0
       */

  }, {
    key: "double",
    value: function double(tag, index) {
      var element = this.elements[tag];
      index = index !== undefined ? index : 0;

      if (element && element.length !== 0) {
        return getByteArrayParser(element, this.byteArrayParser).readDouble(this.byteArray, element.dataOffset + index * 8);
      }

      return undefined;
    }
    /**
       * Returns the number of string values for the element
       * @param tag The DICOM tag in the format xGGGGEEEE
       * @returns {*} the number of string values or undefined if the attribute is not present or has zero length data
       */

  }, {
    key: "numStringValues",
    value: function numStringValues(tag) {
      var element = this.elements[tag];

      if (element && element.length > 0) {
        var fixedString = Object(_byteArrayParser_js__WEBPACK_IMPORTED_MODULE_0__["readFixedString"])(this.byteArray, element.dataOffset, element.length);
        var numMatching = fixedString.match(/\\/g);

        if (numMatching === null) {
          return 1;
        }

        return numMatching.length + 1;
      }

      return undefined;
    }
    /**
       * Returns a string for the element.  If index is provided, the element is assumed to be
       * multi-valued and will return the component specified by index.  Undefined is returned
       * if there is no component with the specified index, the element does not exist or is zero length.
       *
       * Use this function for VR types of AE, CS, SH and LO
       *
       * @param tag The DICOM tag in the format xGGGGEEEE
       * @param index the index of the desired value in a multi valued string or undefined for the entire string
       * @returns {*}
       */

  }, {
    key: "string",
    value: function string(tag, index) {
      var element = this.elements[tag];

      if (element && element.length > 0) {
        var fixedString = Object(_byteArrayParser_js__WEBPACK_IMPORTED_MODULE_0__["readFixedString"])(this.byteArray, element.dataOffset, element.length);

        if (index >= 0) {
          var values = fixedString.split('\\'); // trim trailing spaces

          return values[index].trim();
        } // trim trailing spaces


        return fixedString.trim();
      }

      return undefined;
    }
    /**
       * Returns a string with the leading spaces preserved and trailing spaces removed.
       *
       * Use this function to access data for VRs of type UT, ST and LT
       *
       * @param tag
       * @param index
       * @returns {*}
       */

  }, {
    key: "text",
    value: function text(tag, index) {
      var element = this.elements[tag];

      if (element && element.length > 0) {
        var fixedString = Object(_byteArrayParser_js__WEBPACK_IMPORTED_MODULE_0__["readFixedString"])(this.byteArray, element.dataOffset, element.length);

        if (index >= 0) {
          var values = fixedString.split('\\');
          return values[index].replace(/ +$/, '');
        }

        return fixedString.replace(/ +$/, '');
      }

      return undefined;
    }
    /**
       * Parses a string to a float for the specified index in a multi-valued element.  If index is not specified,
       * the first value in a multi-valued VR will be parsed if present.
       * @param tag The DICOM tag in the format xGGGGEEEE
       * @param index the index of the desired value in a multi valued string or undefined for the first value
       * @returns {*} a floating point number or undefined if not present or data not long enough
       */

  }, {
    key: "floatString",
    value: function floatString(tag, index) {
      var element = this.elements[tag];

      if (element && element.length > 0) {
        index = index !== undefined ? index : 0;
        var value = this.string(tag, index);

        if (value !== undefined) {
          return parseFloat(value);
        }
      }

      return undefined;
    }
    /**
       * Parses a string to an integer for the specified index in a multi-valued element.  If index is not specified,
       * the first value in a multi-valued VR will be parsed if present.
       * @param tag The DICOM tag in the format xGGGGEEEE
       * @param index the index of the desired value in a multi valued string or undefined for the first value
       * @returns {*} an integer or undefined if not present or data not long enough
       */

  }, {
    key: "intString",
    value: function intString(tag, index) {
      var element = this.elements[tag];

      if (element && element.length > 0) {
        index = index !== undefined ? index : 0;
        var value = this.string(tag, index);

        if (value !== undefined) {
          return parseInt(value);
        }
      }

      return undefined;
    }
    /**
       * Parses an element tag according to the 'AT' VR definition (VR=AT).
       * @param {String} A DICOM tag with in the format xGGGGEEEE.
       * @returns {String} A string representation of a data element tag or undefined if the field is not present or data is not long enough.
       */

  }, {
    key: "attributeTag",
    value: function attributeTag(tag) {
      var element = this.elements[tag];

      if (element && element.length === 4) {
        var parser = getByteArrayParser(element, this.byteArrayParser).readUint16;
        var bytes = this.byteArray;
        var offset = element.dataOffset;
        return "x".concat("00000000".concat((parser(bytes, offset) * 256 * 256 + parser(bytes, offset + 2)).toString(16)).substr(-8));
      }

      return undefined;
    }
  }]);

  return DataSet;
}();



/***/ }),

/***/ "./findAndSetUNElementLength.js":
/*!**************************************!*\
  !*** ./findAndSetUNElementLength.js ***!
  \**************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return findAndSetUNElementLength; });
/**
 * Internal helper functions for parsing DICOM elements
 */

/**
 * reads from the byte stream until it finds the magic number for the Sequence Delimitation
 * Item item and then sets the length of the element
 * @param byteStream
 * @param element
 */
function findAndSetUNElementLength(byteStream, element) {
  if (byteStream === undefined) {
    throw 'dicomParser.findAndSetUNElementLength: missing required parameter \'byteStream\'';
  } // group, element, length


  var itemDelimitationItemLength = 8;
  var maxPosition = byteStream.byteArray.length - itemDelimitationItemLength;

  while (byteStream.position <= maxPosition) {
    var groupNumber = byteStream.readUint16();

    if (groupNumber === 0xfffe) {
      var elementNumber = byteStream.readUint16();

      if (elementNumber === 0xe0dd) {
        // NOTE: It would be better to also check for the length to be 0 as part of the check above
        // but we will just log a warning for now
        var itemDelimiterLength = byteStream.readUint32();

        if (itemDelimiterLength !== 0) {
          byteStream.warnings("encountered non zero length following item delimiter at position ".concat(byteStream.position - 4, " while reading element of undefined length with tag ").concat(element.tag));
        }

        element.length = byteStream.position - element.dataOffset;
        return;
      }
    }
  } // No item delimitation item - silently set the length to the end
  // of the buffer and set the position past the end of the buffer


  element.length = byteStream.byteArray.length - element.dataOffset;
  byteStream.seek(byteStream.byteArray.length - byteStream.position);
}

/***/ }),

/***/ "./findEndOfEncapsulatedPixelData.js":
/*!*******************************************!*\
  !*** ./findEndOfEncapsulatedPixelData.js ***!
  \*******************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return findEndOfEncapsulatedElement; });
/* harmony import */ var _readTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./readTag.js */ "./readTag.js");

/**
 * Internal helper functions for parsing DICOM elements
 */

/**
 * Reads an encapsulated pixel data element and adds an array of fragments to the element
 * containing the offset and length of each fragment and any offsets from the basic offset
 * table
 * @param byteStream
 * @param element
 */

function findEndOfEncapsulatedElement(byteStream, element, warnings) {
  if (byteStream === undefined) {
    throw 'dicomParser.findEndOfEncapsulatedElement: missing required parameter \'byteStream\'';
  }

  if (element === undefined) {
    throw 'dicomParser.findEndOfEncapsulatedElement: missing required parameter \'element\'';
  }

  element.encapsulatedPixelData = true;
  element.basicOffsetTable = [];
  element.fragments = [];
  var basicOffsetTableItemTag = Object(_readTag_js__WEBPACK_IMPORTED_MODULE_0__["default"])(byteStream);

  if (basicOffsetTableItemTag !== 'xfffee000') {
    throw 'dicomParser.findEndOfEncapsulatedElement: basic offset table not found';
  }

  var basicOffsetTableItemlength = byteStream.readUint32();
  var numFragments = basicOffsetTableItemlength / 4;

  for (var i = 0; i < numFragments; i++) {
    var offset = byteStream.readUint32();
    element.basicOffsetTable.push(offset);
  }

  var baseOffset = byteStream.position;

  while (byteStream.position < byteStream.byteArray.length) {
    var tag = Object(_readTag_js__WEBPACK_IMPORTED_MODULE_0__["default"])(byteStream);
    var length = byteStream.readUint32();

    if (tag === 'xfffee0dd') {
      byteStream.seek(length);
      element.length = byteStream.position - element.dataOffset;
      return;
    } else if (tag === 'xfffee000') {
      element.fragments.push({
        offset: byteStream.position - baseOffset - 8,
        position: byteStream.position,
        length: length
      });
    } else {
      if (warnings) {
        warnings.push("unexpected tag ".concat(tag, " while searching for end of pixel data element with undefined length"));
      }

      if (length > byteStream.byteArray.length - byteStream.position) {
        // fix length
        length = byteStream.byteArray.length - byteStream.position;
      }

      element.fragments.push({
        offset: byteStream.position - baseOffset - 8,
        position: byteStream.position,
        length: length
      });
      byteStream.seek(length);
      element.length = byteStream.position - element.dataOffset;
      return;
    }

    byteStream.seek(length);
  }

  if (warnings) {
    warnings.push("pixel data element ".concat(element.tag, " missing sequence delimiter tag xfffee0dd"));
  }
}

/***/ }),

/***/ "./findItemDelimitationItem.js":
/*!*************************************!*\
  !*** ./findItemDelimitationItem.js ***!
  \*************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return findItemDelimitationItemAndSetElementLength; });
/**
 * Internal helper functions for parsing DICOM elements
 */

/**
 * reads from the byte stream until it finds the magic numbers for the item delimitation item
 * and then sets the length of the element
 * @param byteStream
 * @param element
 */
function findItemDelimitationItemAndSetElementLength(byteStream, element) {
  if (byteStream === undefined) {
    throw 'dicomParser.readDicomElementImplicit: missing required parameter \'byteStream\'';
  }

  var itemDelimitationItemLength = 8; // group, element, length

  var maxPosition = byteStream.byteArray.length - itemDelimitationItemLength;

  while (byteStream.position <= maxPosition) {
    var groupNumber = byteStream.readUint16();

    if (groupNumber === 0xfffe) {
      var elementNumber = byteStream.readUint16();

      if (elementNumber === 0xe00d) {
        // NOTE: It would be better to also check for the length to be 0 as part of the check above
        // but we will just log a warning for now
        var itemDelimiterLength = byteStream.readUint32(); // the length

        if (itemDelimiterLength !== 0) {
          byteStream.warnings("encountered non zero length following item delimiter at position ".concat(byteStream.position - 4, " while reading element of undefined length with tag ").concat(element.tag));
        }

        element.length = byteStream.position - element.dataOffset;
        return;
      }
    }
  } // No item delimitation item - silently set the length to the end of the buffer and set the position past the end of the buffer


  element.length = byteStream.byteArray.length - element.dataOffset;
  byteStream.seek(byteStream.byteArray.length - byteStream.position);
}

/***/ }),

/***/ "./index.js":
/*!******************!*\
  !*** ./index.js ***!
  \******************/
/*! exports provided: isStringVr, isPrivateTag, parsePN, parseTM, parseDA, explicitElementToString, explicitDataSetToJS, createJPEGBasicOffsetTable, parseDicomDataSetExplicit, parseDicomDataSetImplicit, readFixedString, alloc, version, bigEndianByteArrayParser, ByteStream, sharedCopy, DataSet, findAndSetUNElementLength, findEndOfEncapsulatedElement, findItemDelimitationItemAndSetElementLength, littleEndianByteArrayParser, parseDicom, readDicomElementExplicit, readDicomElementImplicit, readEncapsulatedImageFrame, readEncapsulatedPixelData, readEncapsulatedPixelDataFromFragments, readPart10Header, readSequenceItemsExplicit, readSequenceItemsImplicit, readSequenceItem, readTag, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _util_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./util/index.js */ "./util/index.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isStringVr", function() { return _util_index_js__WEBPACK_IMPORTED_MODULE_0__["isStringVr"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isPrivateTag", function() { return _util_index_js__WEBPACK_IMPORTED_MODULE_0__["isPrivateTag"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "parsePN", function() { return _util_index_js__WEBPACK_IMPORTED_MODULE_0__["parsePN"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "parseTM", function() { return _util_index_js__WEBPACK_IMPORTED_MODULE_0__["parseTM"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "parseDA", function() { return _util_index_js__WEBPACK_IMPORTED_MODULE_0__["parseDA"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "explicitElementToString", function() { return _util_index_js__WEBPACK_IMPORTED_MODULE_0__["explicitElementToString"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "explicitDataSetToJS", function() { return _util_index_js__WEBPACK_IMPORTED_MODULE_0__["explicitDataSetToJS"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "createJPEGBasicOffsetTable", function() { return _util_index_js__WEBPACK_IMPORTED_MODULE_0__["createJPEGBasicOffsetTable"]; });

/* harmony import */ var _parseDicomDataSet_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./parseDicomDataSet.js */ "./parseDicomDataSet.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "parseDicomDataSetExplicit", function() { return _parseDicomDataSet_js__WEBPACK_IMPORTED_MODULE_1__["parseDicomDataSetExplicit"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "parseDicomDataSetImplicit", function() { return _parseDicomDataSet_js__WEBPACK_IMPORTED_MODULE_1__["parseDicomDataSetImplicit"]; });

/* harmony import */ var _byteArrayParser_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./byteArrayParser.js */ "./byteArrayParser.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "readFixedString", function() { return _byteArrayParser_js__WEBPACK_IMPORTED_MODULE_2__["readFixedString"]; });

/* harmony import */ var _alloc_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./alloc.js */ "./alloc.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "alloc", function() { return _alloc_js__WEBPACK_IMPORTED_MODULE_3__["default"]; });

/* harmony import */ var _version_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./version.js */ "./version.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "version", function() { return _version_js__WEBPACK_IMPORTED_MODULE_4__["default"]; });

/* harmony import */ var _bigEndianByteArrayParser_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./bigEndianByteArrayParser.js */ "./bigEndianByteArrayParser.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "bigEndianByteArrayParser", function() { return _bigEndianByteArrayParser_js__WEBPACK_IMPORTED_MODULE_5__["default"]; });

/* harmony import */ var _byteStream_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./byteStream.js */ "./byteStream.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ByteStream", function() { return _byteStream_js__WEBPACK_IMPORTED_MODULE_6__["default"]; });

/* harmony import */ var _sharedCopy_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./sharedCopy.js */ "./sharedCopy.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "sharedCopy", function() { return _sharedCopy_js__WEBPACK_IMPORTED_MODULE_7__["default"]; });

/* harmony import */ var _dataSet_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./dataSet.js */ "./dataSet.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DataSet", function() { return _dataSet_js__WEBPACK_IMPORTED_MODULE_8__["default"]; });

/* harmony import */ var _findAndSetUNElementLength_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./findAndSetUNElementLength.js */ "./findAndSetUNElementLength.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "findAndSetUNElementLength", function() { return _findAndSetUNElementLength_js__WEBPACK_IMPORTED_MODULE_9__["default"]; });

/* harmony import */ var _findEndOfEncapsulatedPixelData_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./findEndOfEncapsulatedPixelData.js */ "./findEndOfEncapsulatedPixelData.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "findEndOfEncapsulatedElement", function() { return _findEndOfEncapsulatedPixelData_js__WEBPACK_IMPORTED_MODULE_10__["default"]; });

/* harmony import */ var _findItemDelimitationItem_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./findItemDelimitationItem.js */ "./findItemDelimitationItem.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "findItemDelimitationItemAndSetElementLength", function() { return _findItemDelimitationItem_js__WEBPACK_IMPORTED_MODULE_11__["default"]; });

/* harmony import */ var _littleEndianByteArrayParser_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./littleEndianByteArrayParser.js */ "./littleEndianByteArrayParser.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "littleEndianByteArrayParser", function() { return _littleEndianByteArrayParser_js__WEBPACK_IMPORTED_MODULE_12__["default"]; });

/* harmony import */ var _parseDicom_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./parseDicom.js */ "./parseDicom.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "parseDicom", function() { return _parseDicom_js__WEBPACK_IMPORTED_MODULE_13__["default"]; });

/* harmony import */ var _readDicomElementExplicit_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./readDicomElementExplicit.js */ "./readDicomElementExplicit.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "readDicomElementExplicit", function() { return _readDicomElementExplicit_js__WEBPACK_IMPORTED_MODULE_14__["default"]; });

/* harmony import */ var _readDicomElementImplicit_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./readDicomElementImplicit.js */ "./readDicomElementImplicit.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "readDicomElementImplicit", function() { return _readDicomElementImplicit_js__WEBPACK_IMPORTED_MODULE_15__["default"]; });

/* harmony import */ var _readEncapsulatedImageFrame_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./readEncapsulatedImageFrame.js */ "./readEncapsulatedImageFrame.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "readEncapsulatedImageFrame", function() { return _readEncapsulatedImageFrame_js__WEBPACK_IMPORTED_MODULE_16__["default"]; });

/* harmony import */ var _readEncapsulatedPixelData_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./readEncapsulatedPixelData.js */ "./readEncapsulatedPixelData.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "readEncapsulatedPixelData", function() { return _readEncapsulatedPixelData_js__WEBPACK_IMPORTED_MODULE_17__["default"]; });

/* harmony import */ var _readEncapsulatedPixelDataFromFragments_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./readEncapsulatedPixelDataFromFragments.js */ "./readEncapsulatedPixelDataFromFragments.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "readEncapsulatedPixelDataFromFragments", function() { return _readEncapsulatedPixelDataFromFragments_js__WEBPACK_IMPORTED_MODULE_18__["default"]; });

/* harmony import */ var _readPart10Header_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./readPart10Header.js */ "./readPart10Header.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "readPart10Header", function() { return _readPart10Header_js__WEBPACK_IMPORTED_MODULE_19__["default"]; });

/* harmony import */ var _readSequenceElementExplicit_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./readSequenceElementExplicit.js */ "./readSequenceElementExplicit.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "readSequenceItemsExplicit", function() { return _readSequenceElementExplicit_js__WEBPACK_IMPORTED_MODULE_20__["default"]; });

/* harmony import */ var _readSequenceElementImplicit_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./readSequenceElementImplicit.js */ "./readSequenceElementImplicit.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "readSequenceItemsImplicit", function() { return _readSequenceElementImplicit_js__WEBPACK_IMPORTED_MODULE_21__["default"]; });

/* harmony import */ var _readSequenceItem_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./readSequenceItem.js */ "./readSequenceItem.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "readSequenceItem", function() { return _readSequenceItem_js__WEBPACK_IMPORTED_MODULE_22__["default"]; });

/* harmony import */ var _readTag_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./readTag.js */ "./readTag.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "readTag", function() { return _readTag_js__WEBPACK_IMPORTED_MODULE_23__["default"]; });

























var dicomParser = {
  isStringVr: _util_index_js__WEBPACK_IMPORTED_MODULE_0__["isStringVr"],
  isPrivateTag: _util_index_js__WEBPACK_IMPORTED_MODULE_0__["isPrivateTag"],
  parsePN: _util_index_js__WEBPACK_IMPORTED_MODULE_0__["parsePN"],
  parseTM: _util_index_js__WEBPACK_IMPORTED_MODULE_0__["parseTM"],
  parseDA: _util_index_js__WEBPACK_IMPORTED_MODULE_0__["parseDA"],
  explicitElementToString: _util_index_js__WEBPACK_IMPORTED_MODULE_0__["explicitElementToString"],
  explicitDataSetToJS: _util_index_js__WEBPACK_IMPORTED_MODULE_0__["explicitDataSetToJS"],
  createJPEGBasicOffsetTable: _util_index_js__WEBPACK_IMPORTED_MODULE_0__["createJPEGBasicOffsetTable"],
  parseDicomDataSetExplicit: _parseDicomDataSet_js__WEBPACK_IMPORTED_MODULE_1__["parseDicomDataSetExplicit"],
  parseDicomDataSetImplicit: _parseDicomDataSet_js__WEBPACK_IMPORTED_MODULE_1__["parseDicomDataSetImplicit"],
  readFixedString: _byteArrayParser_js__WEBPACK_IMPORTED_MODULE_2__["readFixedString"],
  alloc: _alloc_js__WEBPACK_IMPORTED_MODULE_3__["default"],
  version: _version_js__WEBPACK_IMPORTED_MODULE_4__["default"],
  bigEndianByteArrayParser: _bigEndianByteArrayParser_js__WEBPACK_IMPORTED_MODULE_5__["default"],
  ByteStream: _byteStream_js__WEBPACK_IMPORTED_MODULE_6__["default"],
  sharedCopy: _sharedCopy_js__WEBPACK_IMPORTED_MODULE_7__["default"],
  DataSet: _dataSet_js__WEBPACK_IMPORTED_MODULE_8__["default"],
  findAndSetUNElementLength: _findAndSetUNElementLength_js__WEBPACK_IMPORTED_MODULE_9__["default"],
  findEndOfEncapsulatedElement: _findEndOfEncapsulatedPixelData_js__WEBPACK_IMPORTED_MODULE_10__["default"],
  findItemDelimitationItemAndSetElementLength: _findItemDelimitationItem_js__WEBPACK_IMPORTED_MODULE_11__["default"],
  littleEndianByteArrayParser: _littleEndianByteArrayParser_js__WEBPACK_IMPORTED_MODULE_12__["default"],
  parseDicom: _parseDicom_js__WEBPACK_IMPORTED_MODULE_13__["default"],
  readDicomElementExplicit: _readDicomElementExplicit_js__WEBPACK_IMPORTED_MODULE_14__["default"],
  readDicomElementImplicit: _readDicomElementImplicit_js__WEBPACK_IMPORTED_MODULE_15__["default"],
  readEncapsulatedImageFrame: _readEncapsulatedImageFrame_js__WEBPACK_IMPORTED_MODULE_16__["default"],
  readEncapsulatedPixelData: _readEncapsulatedPixelData_js__WEBPACK_IMPORTED_MODULE_17__["default"],
  readEncapsulatedPixelDataFromFragments: _readEncapsulatedPixelDataFromFragments_js__WEBPACK_IMPORTED_MODULE_18__["default"],
  readPart10Header: _readPart10Header_js__WEBPACK_IMPORTED_MODULE_19__["default"],
  readSequenceItemsExplicit: _readSequenceElementExplicit_js__WEBPACK_IMPORTED_MODULE_20__["default"],
  readSequenceItemsImplicit: _readSequenceElementImplicit_js__WEBPACK_IMPORTED_MODULE_21__["default"],
  readSequenceItem: _readSequenceItem_js__WEBPACK_IMPORTED_MODULE_22__["default"],
  readTag: _readTag_js__WEBPACK_IMPORTED_MODULE_23__["default"]
};

/* harmony default export */ __webpack_exports__["default"] = (dicomParser);

/***/ }),

/***/ "./littleEndianByteArrayParser.js":
/*!****************************************!*\
  !*** ./littleEndianByteArrayParser.js ***!
  \****************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/**
 * Internal helper functions for parsing different types from a little-endian byte array
 */
/* harmony default export */ __webpack_exports__["default"] = ({
  /**
   *
   * Parses an unsigned int 16 from a little-endian byte array
   *
   * @param byteArray the byte array to read from
   * @param position the position in the byte array to read from
   * @returns {*} the parsed unsigned int 16
   * @throws error if buffer overread would occur
   * @access private
   */
  readUint16: function readUint16(byteArray, position) {
    if (position < 0) {
      throw 'littleEndianByteArrayParser.readUint16: position cannot be less than 0';
    }

    if (position + 2 > byteArray.length) {
      throw 'littleEndianByteArrayParser.readUint16: attempt to read past end of buffer';
    }

    return byteArray[position] + byteArray[position + 1] * 256;
  },

  /**
   *
   * Parses a signed int 16 from a little-endian byte array
   *
   * @param byteArray the byte array to read from
   * @param position the position in the byte array to read from
   * @returns {*} the parsed signed int 16
   * @throws error if buffer overread would occur
   * @access private
   */
  readInt16: function readInt16(byteArray, position) {
    if (position < 0) {
      throw 'littleEndianByteArrayParser.readInt16: position cannot be less than 0';
    }

    if (position + 2 > byteArray.length) {
      throw 'littleEndianByteArrayParser.readInt16: attempt to read past end of buffer';
    }

    var int16 = byteArray[position] + (byteArray[position + 1] << 8); // fix sign

    if (int16 & 0x8000) {
      int16 = int16 - 0xFFFF - 1;
    }

    return int16;
  },

  /**
   * Parses an unsigned int 32 from a little-endian byte array
   *
   * @param byteArray the byte array to read from
   * @param position the position in the byte array to read from
   * @returns {*} the parsed unsigned int 32
   * @throws error if buffer overread would occur
   * @access private
   */
  readUint32: function readUint32(byteArray, position) {
    if (position < 0) {
      throw 'littleEndianByteArrayParser.readUint32: position cannot be less than 0';
    }

    if (position + 4 > byteArray.length) {
      throw 'littleEndianByteArrayParser.readUint32: attempt to read past end of buffer';
    }

    return byteArray[position] + byteArray[position + 1] * 256 + byteArray[position + 2] * 256 * 256 + byteArray[position + 3] * 256 * 256 * 256;
  },

  /**
  * Parses a signed int 32 from a little-endian byte array
  *
  * @param byteArray the byte array to read from
  * @param position the position in the byte array to read from
   * @returns {*} the parsed unsigned int 32
   * @throws error if buffer overread would occur
   * @access private
   */
  readInt32: function readInt32(byteArray, position) {
    if (position < 0) {
      throw 'littleEndianByteArrayParser.readInt32: position cannot be less than 0';
    }

    if (position + 4 > byteArray.length) {
      throw 'littleEndianByteArrayParser.readInt32: attempt to read past end of buffer';
    }

    return byteArray[position] + (byteArray[position + 1] << 8) + (byteArray[position + 2] << 16) + (byteArray[position + 3] << 24);
  },

  /**
   * Parses 32-bit float from a little-endian byte array
   *
   * @param byteArray the byte array to read from
   * @param position the position in the byte array to read from
   * @returns {*} the parsed 32-bit float
   * @throws error if buffer overread would occur
   * @access private
   */
  readFloat: function readFloat(byteArray, position) {
    if (position < 0) {
      throw 'littleEndianByteArrayParser.readFloat: position cannot be less than 0';
    }

    if (position + 4 > byteArray.length) {
      throw 'littleEndianByteArrayParser.readFloat: attempt to read past end of buffer';
    } // I am sure there is a better way than this but this should be safe


    var byteArrayForParsingFloat = new Uint8Array(4);
    byteArrayForParsingFloat[0] = byteArray[position];
    byteArrayForParsingFloat[1] = byteArray[position + 1];
    byteArrayForParsingFloat[2] = byteArray[position + 2];
    byteArrayForParsingFloat[3] = byteArray[position + 3];
    var floatArray = new Float32Array(byteArrayForParsingFloat.buffer);
    return floatArray[0];
  },

  /**
   * Parses 64-bit float from a little-endian byte array
   *
   * @param byteArray the byte array to read from
   * @param position the position in the byte array to read from
   * @returns {*} the parsed 64-bit float
   * @throws error if buffer overread would occur
   * @access private
   */
  readDouble: function readDouble(byteArray, position) {
    if (position < 0) {
      throw 'littleEndianByteArrayParser.readDouble: position cannot be less than 0';
    }

    if (position + 8 > byteArray.length) {
      throw 'littleEndianByteArrayParser.readDouble: attempt to read past end of buffer';
    } // I am sure there is a better way than this but this should be safe


    var byteArrayForParsingFloat = new Uint8Array(8);
    byteArrayForParsingFloat[0] = byteArray[position];
    byteArrayForParsingFloat[1] = byteArray[position + 1];
    byteArrayForParsingFloat[2] = byteArray[position + 2];
    byteArrayForParsingFloat[3] = byteArray[position + 3];
    byteArrayForParsingFloat[4] = byteArray[position + 4];
    byteArrayForParsingFloat[5] = byteArray[position + 5];
    byteArrayForParsingFloat[6] = byteArray[position + 6];
    byteArrayForParsingFloat[7] = byteArray[position + 7];
    var floatArray = new Float64Array(byteArrayForParsingFloat.buffer);
    return floatArray[0];
  }
});

/***/ }),

/***/ "./parseDicom.js":
/*!***********************!*\
  !*** ./parseDicom.js ***!
  \***********************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return parseDicom; });
/* harmony import */ var _alloc_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./alloc.js */ "./alloc.js");
/* harmony import */ var _bigEndianByteArrayParser_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./bigEndianByteArrayParser.js */ "./bigEndianByteArrayParser.js");
/* harmony import */ var _byteStream_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./byteStream.js */ "./byteStream.js");
/* harmony import */ var _dataSet_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./dataSet.js */ "./dataSet.js");
/* harmony import */ var _littleEndianByteArrayParser_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./littleEndianByteArrayParser.js */ "./littleEndianByteArrayParser.js");
/* harmony import */ var _readPart10Header_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./readPart10Header.js */ "./readPart10Header.js");
/* harmony import */ var _sharedCopy_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./sharedCopy.js */ "./sharedCopy.js");
/* harmony import */ var _byteArrayParser_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./byteArrayParser.js */ "./byteArrayParser.js");
/* harmony import */ var _parseDicomDataSet_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./parseDicomDataSet.js */ "./parseDicomDataSet.js");









/**
 * Parses a DICOM P10 byte array and returns a DataSet object with the parsed elements.
 * If the options argument is supplied and it contains the untilTag property, parsing
 * will stop once that tag is encoutered.  This can be used to parse partial byte streams.
 *
 * @param byteArray the byte array
 * @param options object to control parsing behavior (optional)
 * @returns {DataSet}
 * @throws error if an error occurs while parsing.  The exception object will contain a
 *         property dataSet with the elements successfully parsed before the error.
 */

function parseDicom(byteArray, options) {
  if (byteArray === undefined) {
    throw 'dicomParser.parseDicom: missing required parameter \'byteArray\'';
  }

  function readTransferSyntax(metaHeaderDataSet) {
    if (metaHeaderDataSet.elements.x00020010 === undefined) {
      throw 'dicomParser.parseDicom: missing required meta header attribute 0002,0010';
    }

    var transferSyntaxElement = metaHeaderDataSet.elements.x00020010;
    return _byteArrayParser_js__WEBPACK_IMPORTED_MODULE_7__["readFixedString"](byteArray, transferSyntaxElement.dataOffset, transferSyntaxElement.length);
  }

  function isExplicit(transferSyntax) {
    // implicit little endian
    if (transferSyntax === '1.2.840.10008.1.2') {
      return false;
    } // all other transfer syntaxes should be explicit


    return true;
  }

  function getDataSetByteStream(transferSyntax, position) {
    // Detect whether we are inside a browser or Node.js
    var isNode = Object.prototype.toString.call(typeof process !== 'undefined' ? process : 0) === '[object process]';

    if (transferSyntax === '1.2.840.10008.1.2.1.99') {
      // if an infalter callback is registered, use it
      if (options && options.inflater) {
        var fullByteArrayCallback = options.inflater(byteArray, position);
        return new _byteStream_js__WEBPACK_IMPORTED_MODULE_2__["default"](_littleEndianByteArrayParser_js__WEBPACK_IMPORTED_MODULE_4__["default"], fullByteArrayCallback, 0);
      } // if running on node, use the zlib library to inflate
      // http://stackoverflow.com/questions/4224606/how-to-check-whether-a-script-is-running-under-node-js
      else if (isNode === true) {
        // inflate it
        var zlib = __webpack_require__(/*! zlib */ "zlib");

        var deflatedBuffer = Object(_sharedCopy_js__WEBPACK_IMPORTED_MODULE_6__["default"])(byteArray, position, byteArray.length - position);
        var inflatedBuffer = zlib.inflateRawSync(deflatedBuffer); // create a single byte array with the full header bytes and the inflated bytes

        var fullByteArrayBuffer = Object(_alloc_js__WEBPACK_IMPORTED_MODULE_0__["default"])(byteArray, inflatedBuffer.length + position);
        byteArray.copy(fullByteArrayBuffer, 0, 0, position);
        inflatedBuffer.copy(fullByteArrayBuffer, position);
        return new _byteStream_js__WEBPACK_IMPORTED_MODULE_2__["default"](_littleEndianByteArrayParser_js__WEBPACK_IMPORTED_MODULE_4__["default"], fullByteArrayBuffer, 0);
      } // if pako is defined - use it.  This is the web browser path
      // https://github.com/nodeca/pako
      else if (typeof pako !== 'undefined') {
        // inflate it
        var deflated = byteArray.slice(position);
        var inflated = pako.inflateRaw(deflated); // create a single byte array with the full header bytes and the inflated bytes

        var fullByteArray = Object(_alloc_js__WEBPACK_IMPORTED_MODULE_0__["default"])(byteArray, inflated.length + position);
        fullByteArray.set(byteArray.slice(0, position), 0);
        fullByteArray.set(inflated, position);
        return new _byteStream_js__WEBPACK_IMPORTED_MODULE_2__["default"](_littleEndianByteArrayParser_js__WEBPACK_IMPORTED_MODULE_4__["default"], fullByteArray, 0);
      } // throw exception since no inflater is available


      throw 'dicomParser.parseDicom: no inflater available to handle deflate transfer syntax';
    } // explicit big endian


    if (transferSyntax === '1.2.840.10008.1.2.2') {
      return new _byteStream_js__WEBPACK_IMPORTED_MODULE_2__["default"](_bigEndianByteArrayParser_js__WEBPACK_IMPORTED_MODULE_1__["default"], byteArray, position);
    } // all other transfer syntaxes are little endian; only the pixel encoding differs
    // make a new stream so the metaheader warnings don't come along for the ride


    return new _byteStream_js__WEBPACK_IMPORTED_MODULE_2__["default"](_littleEndianByteArrayParser_js__WEBPACK_IMPORTED_MODULE_4__["default"], byteArray, position);
  }

  function mergeDataSets(metaHeaderDataSet, instanceDataSet) {
    for (var propertyName in metaHeaderDataSet.elements) {
      if (metaHeaderDataSet.elements.hasOwnProperty(propertyName)) {
        instanceDataSet.elements[propertyName] = metaHeaderDataSet.elements[propertyName];
      }
    }

    if (metaHeaderDataSet.warnings !== undefined) {
      instanceDataSet.warnings = metaHeaderDataSet.warnings.concat(instanceDataSet.warnings);
    }

    return instanceDataSet;
  }

  function readDataSet(metaHeaderDataSet) {
    var transferSyntax = readTransferSyntax(metaHeaderDataSet);
    var explicit = isExplicit(transferSyntax);
    var dataSetByteStream = getDataSetByteStream(transferSyntax, metaHeaderDataSet.position);
    var elements = {};
    var dataSet = new _dataSet_js__WEBPACK_IMPORTED_MODULE_3__["default"](dataSetByteStream.byteArrayParser, dataSetByteStream.byteArray, elements);
    dataSet.warnings = dataSetByteStream.warnings;

    try {
      if (explicit) {
        _parseDicomDataSet_js__WEBPACK_IMPORTED_MODULE_8__["parseDicomDataSetExplicit"](dataSet, dataSetByteStream, dataSetByteStream.byteArray.length, options);
      } else {
        _parseDicomDataSet_js__WEBPACK_IMPORTED_MODULE_8__["parseDicomDataSetImplicit"](dataSet, dataSetByteStream, dataSetByteStream.byteArray.length, options);
      }
    } catch (e) {
      var ex = {
        exception: e,
        dataSet: dataSet
      };
      throw ex;
    }

    return dataSet;
  } // main function here


  function parseTheByteStream() {
    var metaHeaderDataSet = Object(_readPart10Header_js__WEBPACK_IMPORTED_MODULE_5__["default"])(byteArray, options);
    var dataSet = readDataSet(metaHeaderDataSet);
    return mergeDataSets(metaHeaderDataSet, dataSet);
  } // This is where we actually start parsing


  return parseTheByteStream();
}

/***/ }),

/***/ "./parseDicomDataSet.js":
/*!******************************!*\
  !*** ./parseDicomDataSet.js ***!
  \******************************/
/*! exports provided: parseDicomDataSetExplicit, parseDicomDataSetImplicit */
/***/ (function(module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "parseDicomDataSetExplicit", function() { return parseDicomDataSetExplicit; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "parseDicomDataSetImplicit", function() { return parseDicomDataSetImplicit; });
/* harmony import */ var _readDicomElementExplicit_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./readDicomElementExplicit.js */ "./readDicomElementExplicit.js");
/* harmony import */ var _readDicomElementImplicit_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./readDicomElementImplicit.js */ "./readDicomElementImplicit.js");


/**
 * Internal helper functions for parsing implicit and explicit DICOM data sets
 */

/**
 * reads an explicit data set
 * @param byteStream the byte stream to read from
 * @param maxPosition the maximum position to read up to (optional - only needed when reading sequence items)
 */

function parseDicomDataSetExplicit(dataSet, byteStream, maxPosition) {
  var options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
  maxPosition = maxPosition === undefined ? byteStream.byteArray.length : maxPosition;

  if (byteStream === undefined) {
    throw 'dicomParser.parseDicomDataSetExplicit: missing required parameter \'byteStream\'';
  }

  if (maxPosition < byteStream.position || maxPosition > byteStream.byteArray.length) {
    throw 'dicomParser.parseDicomDataSetExplicit: invalid value for parameter \'maxP osition\'';
  }

  var elements = dataSet.elements;

  while (byteStream.position < maxPosition) {
    var element = Object(_readDicomElementExplicit_js__WEBPACK_IMPORTED_MODULE_0__["default"])(byteStream, dataSet.warnings, options.untilTag);
    elements[element.tag] = element;

    if (element.tag === options.untilTag) {
      return;
    }
  }

  if (byteStream.position > maxPosition) {
    throw 'dicomParser:parseDicomDataSetExplicit: buffer overrun';
  }
}
/**
 * reads an implicit data set
 * @param byteStream the byte stream to read from
 * @param maxPosition the maximum position to read up to (optional - only needed when reading sequence items)
 */

function parseDicomDataSetImplicit(dataSet, byteStream, maxPosition) {
  var options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
  maxPosition = maxPosition === undefined ? dataSet.byteArray.length : maxPosition;

  if (byteStream === undefined) {
    throw 'dicomParser.parseDicomDataSetImplicit: missing required parameter \'byteStream\'';
  }

  if (maxPosition < byteStream.position || maxPosition > byteStream.byteArray.length) {
    throw 'dicomParser.parseDicomDataSetImplicit: invalid value for parameter \'maxPosition\'';
  }

  var elements = dataSet.elements;

  while (byteStream.position < maxPosition) {
    var element = Object(_readDicomElementImplicit_js__WEBPACK_IMPORTED_MODULE_1__["default"])(byteStream, options.untilTag, options.vrCallback);
    elements[element.tag] = element;

    if (element.tag === options.untilTag) {
      return;
    }
  }
}

/***/ }),

/***/ "./readDicomElementExplicit.js":
/*!*************************************!*\
  !*** ./readDicomElementExplicit.js ***!
  \*************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return readDicomElementExplicit; });
/* harmony import */ var _findEndOfEncapsulatedPixelData_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./findEndOfEncapsulatedPixelData.js */ "./findEndOfEncapsulatedPixelData.js");
/* harmony import */ var _findAndSetUNElementLength_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./findAndSetUNElementLength.js */ "./findAndSetUNElementLength.js");
/* harmony import */ var _readSequenceElementImplicit_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./readSequenceElementImplicit.js */ "./readSequenceElementImplicit.js");
/* harmony import */ var _readTag_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./readTag.js */ "./readTag.js");
/* harmony import */ var _findItemDelimitationItem_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./findItemDelimitationItem.js */ "./findItemDelimitationItem.js");
/* harmony import */ var _readSequenceElementExplicit_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./readSequenceElementExplicit.js */ "./readSequenceElementExplicit.js");






/**
 * Internal helper functions for for parsing DICOM elements
 */

var getDataLengthSizeInBytesForVR = function getDataLengthSizeInBytesForVR(vr) {
  if (vr === 'OB' || vr === 'OD' || vr === 'OL' || vr === 'OW' || vr === 'SQ' || vr === 'OF' || vr === 'UC' || vr === 'UR' || vr === 'UT' || vr === 'UN') {
    return 4;
  }

  return 2;
};

function readDicomElementExplicit(byteStream, warnings, untilTag) {
  if (byteStream === undefined) {
    throw 'dicomParser.readDicomElementExplicit: missing required parameter \'byteStream\'';
  }

  var element = {
    tag: Object(_readTag_js__WEBPACK_IMPORTED_MODULE_3__["default"])(byteStream),
    vr: byteStream.readFixedString(2) // length set below based on VR
    // dataOffset set below based on VR and size of length

  };
  var dataLengthSizeBytes = getDataLengthSizeInBytesForVR(element.vr);

  if (dataLengthSizeBytes === 2) {
    element.length = byteStream.readUint16();
    element.dataOffset = byteStream.position;
  } else {
    byteStream.seek(2);
    element.length = byteStream.readUint32();
    element.dataOffset = byteStream.position;
  }

  if (element.length === 4294967295) {
    element.hadUndefinedLength = true;
  }

  if (element.tag === untilTag) {
    return element;
  } // if VR is SQ, parse the sequence items


  if (element.vr === 'SQ') {
    Object(_readSequenceElementExplicit_js__WEBPACK_IMPORTED_MODULE_5__["default"])(byteStream, element, warnings);
    return element;
  }

  if (element.length === 4294967295) {
    if (element.tag === 'x7fe00010') {
      Object(_findEndOfEncapsulatedPixelData_js__WEBPACK_IMPORTED_MODULE_0__["default"])(byteStream, element, warnings);
      return element;
    } else if (element.vr === 'UN') {
      Object(_readSequenceElementImplicit_js__WEBPACK_IMPORTED_MODULE_2__["default"])(byteStream, element);
      return element;
    }

    Object(_findItemDelimitationItem_js__WEBPACK_IMPORTED_MODULE_4__["default"])(byteStream, element);
    return element;
  }

  byteStream.seek(element.length);
  return element;
}

/***/ }),

/***/ "./readDicomElementImplicit.js":
/*!*************************************!*\
  !*** ./readDicomElementImplicit.js ***!
  \*************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return readDicomElementImplicit; });
/* harmony import */ var _findItemDelimitationItem_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./findItemDelimitationItem.js */ "./findItemDelimitationItem.js");
/* harmony import */ var _readSequenceElementImplicit_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./readSequenceElementImplicit.js */ "./readSequenceElementImplicit.js");
/* harmony import */ var _readTag_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./readTag.js */ "./readTag.js");
/* harmony import */ var _util_util_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./util/util.js */ "./util/util.js");




/**
 * Internal helper functions for for parsing DICOM elements
 */

var isSequence = function isSequence(element, byteStream, vrCallback) {
  // if a data dictionary callback was provided, use that to verify that the element is a sequence.
  if (typeof vrCallback !== 'undefined') {
    return vrCallback(element.tag) === 'SQ';
  }

  if (byteStream.position + 4 <= byteStream.byteArray.length) {
    var nextTag = Object(_readTag_js__WEBPACK_IMPORTED_MODULE_2__["default"])(byteStream);
    byteStream.seek(-4); // Item start tag (fffe,e000) or sequence delimiter (i.e. end of sequence) tag (0fffe,e0dd)
    // These are the tags that could potentially be found directly after a sequence start tag (the delimiter
    // is found in the case of an empty sequence). This is not 100% safe because a non-sequence item
    // could have data that has these bytes, but this is how to do it without a data dictionary.

    return nextTag === 'xfffee000' || nextTag === 'xfffee0dd';
  }

  byteStream.warnings.push('eof encountered before finding sequence item tag or sequence delimiter tag in peeking to determine VR');
  return false;
};

function readDicomElementImplicit(byteStream, untilTag, vrCallback) {
  if (byteStream === undefined) {
    throw 'dicomParser.readDicomElementImplicit: missing required parameter \'byteStream\'';
  }

  var element = {
    tag: Object(_readTag_js__WEBPACK_IMPORTED_MODULE_2__["default"])(byteStream),
    length: byteStream.readUint32(),
    dataOffset: byteStream.position
  };

  if (element.length === 4294967295) {
    element.hadUndefinedLength = true;
  }

  if (element.tag === untilTag) {
    return element;
  }

  if (isSequence(element, byteStream, vrCallback) && !Object(_util_util_js__WEBPACK_IMPORTED_MODULE_3__["isPrivateTag"])(element.tag)) {
    // parse the sequence
    Object(_readSequenceElementImplicit_js__WEBPACK_IMPORTED_MODULE_1__["default"])(byteStream, element);
    return element;
  } // if element is not a sequence and has undefined length, we have to
  // scan the data for a magic number to figure out when it ends.


  if (element.hadUndefinedLength) {
    Object(_findItemDelimitationItem_js__WEBPACK_IMPORTED_MODULE_0__["default"])(byteStream, element);
    return element;
  } // non sequence element with known length, skip over the data part


  byteStream.seek(element.length);
  return element;
}

/***/ }),

/***/ "./readEncapsulatedImageFrame.js":
/*!***************************************!*\
  !*** ./readEncapsulatedImageFrame.js ***!
  \***************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return readEncapsulatedImageFrame; });
/* harmony import */ var _readEncapsulatedPixelDataFromFragments_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./readEncapsulatedPixelDataFromFragments.js */ "./readEncapsulatedPixelDataFromFragments.js");

/**
 * Functionality for extracting encapsulated pixel data
 */

var findFragmentIndexWithOffset = function findFragmentIndexWithOffset(fragments, offset) {
  for (var i = 0; i < fragments.length; i++) {
    if (fragments[i].offset === offset) {
      return i;
    }
  }
};

var calculateNumberOfFragmentsForFrame = function calculateNumberOfFragmentsForFrame(frameIndex, basicOffsetTable, fragments, startFragmentIndex) {
  // special case for last frame
  if (frameIndex === basicOffsetTable.length - 1) {
    return fragments.length - startFragmentIndex;
  } // iterate through each fragment looking for the one matching the offset for the next frame


  var nextFrameOffset = basicOffsetTable[frameIndex + 1];

  for (var i = startFragmentIndex + 1; i < fragments.length; i++) {
    if (fragments[i].offset === nextFrameOffset) {
      return i - startFragmentIndex;
    }
  }

  throw 'dicomParser.calculateNumberOfFragmentsForFrame: could not find fragment with offset matching basic offset table';
};
/**
 * Returns the pixel data for the specified frame in an encapsulated pixel data element that has a non
 * empty basic offset table.  Note that this function will fail if the basic offset table is empty - in that
 * case you need to determine which fragments map to which frames and read them using
 * readEncapsulatedPixelDataFromFragments().  Also see the function createJEPGBasicOffsetTable() to see
 * how a basic offset table can be created for JPEG images
 *
 * @param dataSet - the dataSet containing the encapsulated pixel data
 * @param pixelDataElement - the pixel data element (x7fe00010) to extract the frame from
 * @param frameIndex - the zero based frame index
 * @param [basicOffsetTable] - optional array of starting offsets for frames
 * @param [fragments] - optional array of objects describing each fragment (offset, position, length)
 * @returns {object} with the encapsulated pixel data
 */


function readEncapsulatedImageFrame(dataSet, pixelDataElement, frameIndex, basicOffsetTable, fragments) {
  // default parameters
  basicOffsetTable = basicOffsetTable || pixelDataElement.basicOffsetTable;
  fragments = fragments || pixelDataElement.fragments; // Validate parameters

  if (dataSet === undefined) {
    throw 'dicomParser.readEncapsulatedImageFrame: missing required parameter \'dataSet\'';
  }

  if (pixelDataElement === undefined) {
    throw 'dicomParser.readEncapsulatedImageFrame: missing required parameter \'pixelDataElement\'';
  }

  if (frameIndex === undefined) {
    throw 'dicomParser.readEncapsulatedImageFrame: missing required parameter \'frameIndex\'';
  }

  if (basicOffsetTable === undefined) {
    throw 'dicomParser.readEncapsulatedImageFrame: parameter \'pixelDataElement\' does not have basicOffsetTable';
  }

  if (pixelDataElement.tag !== 'x7fe00010') {
    throw 'dicomParser.readEncapsulatedImageFrame: parameter \'pixelDataElement\' refers to non pixel data tag (expected tag = x7fe00010)';
  }

  if (pixelDataElement.encapsulatedPixelData !== true) {
    throw 'dicomParser.readEncapsulatedImageFrame: parameter \'pixelDataElement\' refers to pixel data element that does not have encapsulated pixel data';
  }

  if (pixelDataElement.hadUndefinedLength !== true) {
    throw 'dicomParser.readEncapsulatedImageFrame: parameter \'pixelDataElement\' refers to pixel data element that does not have undefined length';
  }

  if (pixelDataElement.fragments === undefined) {
    throw 'dicomParser.readEncapsulatedImageFrame: parameter \'pixelDataElement\' refers to pixel data element that does not have fragments';
  }

  if (basicOffsetTable.length === 0) {
    throw 'dicomParser.readEncapsulatedImageFrame: basicOffsetTable has zero entries';
  }

  if (frameIndex < 0) {
    throw 'dicomParser.readEncapsulatedImageFrame: parameter \'frameIndex\' must be >= 0';
  }

  if (frameIndex >= basicOffsetTable.length) {
    throw 'dicomParser.readEncapsulatedImageFrame: parameter \'frameIndex\' must be < basicOffsetTable.length';
  } // find starting fragment based on the offset for the frame in the basic offset table


  var offset = basicOffsetTable[frameIndex];
  var startFragmentIndex = findFragmentIndexWithOffset(fragments, offset);

  if (startFragmentIndex === undefined) {
    throw 'dicomParser.readEncapsulatedImageFrame: unable to find fragment that matches basic offset table entry';
  } // calculate the number of fragments for this frame


  var numFragments = calculateNumberOfFragmentsForFrame(frameIndex, basicOffsetTable, fragments, startFragmentIndex); // now extract the frame from the fragments

  return Object(_readEncapsulatedPixelDataFromFragments_js__WEBPACK_IMPORTED_MODULE_0__["default"])(dataSet, pixelDataElement, startFragmentIndex, numFragments, fragments);
}

/***/ }),

/***/ "./readEncapsulatedPixelData.js":
/*!**************************************!*\
  !*** ./readEncapsulatedPixelData.js ***!
  \**************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return readEncapsulatedPixelData; });
/* harmony import */ var _readEncapsulatedImageFrame_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./readEncapsulatedImageFrame.js */ "./readEncapsulatedImageFrame.js");
/* harmony import */ var _readEncapsulatedPixelDataFromFragments_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./readEncapsulatedPixelDataFromFragments.js */ "./readEncapsulatedPixelDataFromFragments.js");


/**
 * Functionality for extracting encapsulated pixel data
 */

var deprecatedNoticeLogged = false;
/**
 * Returns the pixel data for the specified frame in an encapsulated pixel data element.  If no basic offset
 * table is present, it assumes that all fragments are for one frame.  Note that this assumption/logic is not
 * valid for multi-frame instances so this function has been deprecated and will eventually be removed.  Code
 * should be updated to use readEncapsulatedPixelDataFromFragments() or readEncapsulatedImageFrame()
 *
 * @deprecated since version 1.6 - use readEncapsulatedPixelDataFromFragments() or readEncapsulatedImageFrame()
 * @param dataSet - the dataSet containing the encapsulated pixel data
 * @param pixelDataElement - the pixel data element (x7fe00010) to extract the frame from
 * @param frame - the zero based frame index
 * @returns {object} with the encapsulated pixel data
 */

function readEncapsulatedPixelData(dataSet, pixelDataElement, frame) {
  if (!deprecatedNoticeLogged) {
    deprecatedNoticeLogged = true;

    if (console && console.log) {
      console.log('WARNING: dicomParser.readEncapsulatedPixelData() has been deprecated');
    }
  }

  if (dataSet === undefined) {
    throw 'dicomParser.readEncapsulatedPixelData: missing required parameter \'dataSet\'';
  }

  if (pixelDataElement === undefined) {
    throw 'dicomParser.readEncapsulatedPixelData: missing required parameter \'element\'';
  }

  if (frame === undefined) {
    throw 'dicomParser.readEncapsulatedPixelData: missing required parameter \'frame\'';
  }

  if (pixelDataElement.tag !== 'x7fe00010') {
    throw 'dicomParser.readEncapsulatedPixelData: parameter \'element\' refers to non pixel data tag (expected tag = x7fe00010)';
  }

  if (pixelDataElement.encapsulatedPixelData !== true) {
    throw 'dicomParser.readEncapsulatedPixelData: parameter \'element\' refers to pixel data element that does not have encapsulated pixel data';
  }

  if (pixelDataElement.hadUndefinedLength !== true) {
    throw 'dicomParser.readEncapsulatedPixelData: parameter \'element\' refers to pixel data element that does not have encapsulated pixel data';
  }

  if (pixelDataElement.basicOffsetTable === undefined) {
    throw 'dicomParser.readEncapsulatedPixelData: parameter \'element\' refers to pixel data element that does not have encapsulated pixel data';
  }

  if (pixelDataElement.fragments === undefined) {
    throw 'dicomParser.readEncapsulatedPixelData: parameter \'element\' refers to pixel data element that does not have encapsulated pixel data';
  }

  if (frame < 0) {
    throw 'dicomParser.readEncapsulatedPixelData: parameter \'frame\' must be >= 0';
  } // If the basic offset table is not empty, we can extract the frame


  if (pixelDataElement.basicOffsetTable.length !== 0) {
    return Object(_readEncapsulatedImageFrame_js__WEBPACK_IMPORTED_MODULE_0__["default"])(dataSet, pixelDataElement, frame);
  } // No basic offset table, assume all fragments are for one frame - NOTE that this is NOT a valid
  // assumption but is the original behavior so we are keeping it for now


  return Object(_readEncapsulatedPixelDataFromFragments_js__WEBPACK_IMPORTED_MODULE_1__["default"])(dataSet, pixelDataElement, 0, pixelDataElement.fragments.length);
}

/***/ }),

/***/ "./readEncapsulatedPixelDataFromFragments.js":
/*!***************************************************!*\
  !*** ./readEncapsulatedPixelDataFromFragments.js ***!
  \***************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return readEncapsulatedPixelDataFromFragments; });
/* harmony import */ var _alloc_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./alloc.js */ "./alloc.js");
/* harmony import */ var _byteStream_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./byteStream.js */ "./byteStream.js");
/* harmony import */ var _readSequenceItem_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./readSequenceItem.js */ "./readSequenceItem.js");
/* harmony import */ var _sharedCopy_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./sharedCopy.js */ "./sharedCopy.js");




/**
 * Functionality for extracting encapsulated pixel data
 */

var calculateBufferSize = function calculateBufferSize(fragments, startFragment, numFragments) {
  var bufferSize = 0;

  for (var i = startFragment; i < startFragment + numFragments; i++) {
    bufferSize += fragments[i].length;
  }

  return bufferSize;
};
/**
 * Returns the encapsulated pixel data from the specified fragments.  Use this function when you know
 * the fragments you want to extract data from.  See
 *
 * @param dataSet - the dataSet containing the encapsulated pixel data
 * @param pixelDataElement - the pixel data element (x7fe00010) to extract the fragment data from
 * @param startFragmentIndex - zero based index of the first fragment to extract from
 * @param [numFragments] - the number of fragments to extract from, default is 1
 * @param [fragments] - optional array of objects describing each fragment (offset, position, length)
 * @returns {object} byte array with the encapsulated pixel data
 */


function readEncapsulatedPixelDataFromFragments(dataSet, pixelDataElement, startFragmentIndex, numFragments, fragments) {
  // default values
  numFragments = numFragments || 1;
  fragments = fragments || pixelDataElement.fragments; // check parameters

  if (dataSet === undefined) {
    throw 'dicomParser.readEncapsulatedPixelDataFromFragments: missing required parameter \'dataSet\'';
  }

  if (pixelDataElement === undefined) {
    throw 'dicomParser.readEncapsulatedPixelDataFromFragments: missing required parameter \'pixelDataElement\'';
  }

  if (startFragmentIndex === undefined) {
    throw 'dicomParser.readEncapsulatedPixelDataFromFragments: missing required parameter \'startFragmentIndex\'';
  }

  if (numFragments === undefined) {
    throw 'dicomParser.readEncapsulatedPixelDataFromFragments: missing required parameter \'numFragments\'';
  }

  if (pixelDataElement.tag !== 'x7fe00010') {
    throw 'dicomParser.readEncapsulatedPixelDataFromFragments: parameter \'pixelDataElement\' refers to non pixel data tag (expected tag = x7fe00010';
  }

  if (pixelDataElement.encapsulatedPixelData !== true) {
    throw 'dicomParser.readEncapsulatedPixelDataFromFragments: parameter \'pixelDataElement\' refers to pixel data element that does not have encapsulated pixel data';
  }

  if (pixelDataElement.hadUndefinedLength !== true) {
    throw 'dicomParser.readEncapsulatedPixelDataFromFragments: parameter \'pixelDataElement\' refers to pixel data element that does not have encapsulated pixel data';
  }

  if (pixelDataElement.basicOffsetTable === undefined) {
    throw 'dicomParser.readEncapsulatedPixelDataFromFragments: parameter \'pixelDataElement\' refers to pixel data element that does not have encapsulated pixel data';
  }

  if (pixelDataElement.fragments === undefined) {
    throw 'dicomParser.readEncapsulatedPixelDataFromFragments: parameter \'pixelDataElement\' refers to pixel data element that does not have encapsulated pixel data';
  }

  if (pixelDataElement.fragments.length <= 0) {
    throw 'dicomParser.readEncapsulatedPixelDataFromFragments: parameter \'pixelDataElement\' refers to pixel data element that does not have encapsulated pixel data';
  }

  if (startFragmentIndex < 0) {
    throw 'dicomParser.readEncapsulatedPixelDataFromFragments: parameter \'startFragmentIndex\' must be >= 0';
  }

  if (startFragmentIndex >= pixelDataElement.fragments.length) {
    throw 'dicomParser.readEncapsulatedPixelDataFromFragments: parameter \'startFragmentIndex\' must be < number of fragments';
  }

  if (numFragments < 1) {
    throw 'dicomParser.readEncapsulatedPixelDataFromFragments: parameter \'numFragments\' must be > 0';
  }

  if (startFragmentIndex + numFragments > pixelDataElement.fragments.length) {
    throw 'dicomParser.readEncapsulatedPixelDataFromFragments: parameter \'startFragment\' + \'numFragments\' < number of fragments';
  } // create byte stream on the data for this pixel data element


  var byteStream = new _byteStream_js__WEBPACK_IMPORTED_MODULE_1__["default"](dataSet.byteArrayParser, dataSet.byteArray, pixelDataElement.dataOffset); // seek past the basic offset table (no need to parse it again since we already have)

  var basicOffsetTable = Object(_readSequenceItem_js__WEBPACK_IMPORTED_MODULE_2__["default"])(byteStream);

  if (basicOffsetTable.tag !== 'xfffee000') {
    throw 'dicomParser.readEncapsulatedPixelData: missing basic offset table xfffee000';
  }

  byteStream.seek(basicOffsetTable.length);
  var fragmentZeroPosition = byteStream.position; // tag + length

  var fragmentHeaderSize = 8; // if there is only one fragment, return a view on this array to avoid copying

  if (numFragments === 1) {
    return Object(_sharedCopy_js__WEBPACK_IMPORTED_MODULE_3__["default"])(byteStream.byteArray, fragmentZeroPosition + fragments[startFragmentIndex].offset + fragmentHeaderSize, fragments[startFragmentIndex].length);
  } // more than one fragment, combine all of the fragments into one buffer


  var bufferSize = calculateBufferSize(fragments, startFragmentIndex, numFragments);
  var pixelData = Object(_alloc_js__WEBPACK_IMPORTED_MODULE_0__["default"])(byteStream.byteArray, bufferSize);
  var pixelDataIndex = 0;

  for (var i = startFragmentIndex; i < startFragmentIndex + numFragments; i++) {
    var fragmentOffset = fragmentZeroPosition + fragments[i].offset + fragmentHeaderSize;

    for (var j = 0; j < fragments[i].length; j++) {
      pixelData[pixelDataIndex++] = byteStream.byteArray[fragmentOffset++];
    }
  }

  return pixelData;
}

/***/ }),

/***/ "./readPart10Header.js":
/*!*****************************!*\
  !*** ./readPart10Header.js ***!
  \*****************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return readPart10Header; });
/* harmony import */ var _byteStream_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./byteStream.js */ "./byteStream.js");
/* harmony import */ var _dataSet_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./dataSet.js */ "./dataSet.js");
/* harmony import */ var _littleEndianByteArrayParser_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./littleEndianByteArrayParser.js */ "./littleEndianByteArrayParser.js");
/* harmony import */ var _readDicomElementExplicit_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./readDicomElementExplicit.js */ "./readDicomElementExplicit.js");




/**
 * Parses a DICOM P10 byte array and returns a DataSet object with the parsed elements.  If the options
 * argument is supplied and it contains the untilTag property, parsing will stop once that
 * tag is encoutered.  This can be used to parse partial byte streams.
 *
 * @param byteArray the byte array
 * @param options object to control parsing behavior (optional)
 * @returns {DataSet}
 * @throws error if an error occurs while parsing.  The exception object will contain a property dataSet with the
 *         elements successfully parsed before the error.
 */

function readPart10Header(byteArray, options) {
  if (byteArray === undefined) {
    throw 'dicomParser.readPart10Header: missing required parameter \'byteArray\'';
  }

  var littleEndianByteStream = new _byteStream_js__WEBPACK_IMPORTED_MODULE_0__["default"](_littleEndianByteArrayParser_js__WEBPACK_IMPORTED_MODULE_2__["default"], byteArray);

  function readPrefix() {
    littleEndianByteStream.seek(128);
    var prefix = littleEndianByteStream.readFixedString(4);

    if (prefix !== 'DICM') {
      throw 'dicomParser.readPart10Header: DICM prefix not found at location 132 - this is not a valid DICOM P10 file.';
    }
  } // main function here


  function readTheHeader() {
    // Per the DICOM standard, the header is always encoded in Explicit VR Little Endian (see PS3.10, section 7.1)
    // so use littleEndianByteStream throughout this method regardless of the transfer syntax
    readPrefix();
    var warnings = [];
    var elements = {};

    while (littleEndianByteStream.position < littleEndianByteStream.byteArray.length) {
      var position = littleEndianByteStream.position;
      var element = Object(_readDicomElementExplicit_js__WEBPACK_IMPORTED_MODULE_3__["default"])(littleEndianByteStream, warnings);

      if (element.tag > 'x0002ffff') {
        littleEndianByteStream.position = position;
        break;
      } // Cache the littleEndianByteArrayParser for meta header elements, since the rest of the data set may be big endian
      // and this parser will be needed later if the meta header values are to be read.


      element.parser = _littleEndianByteArrayParser_js__WEBPACK_IMPORTED_MODULE_2__["default"];
      elements[element.tag] = element;
    }

    var metaHeaderDataSet = new _dataSet_js__WEBPACK_IMPORTED_MODULE_1__["default"](littleEndianByteStream.byteArrayParser, littleEndianByteStream.byteArray, elements);
    metaHeaderDataSet.warnings = littleEndianByteStream.warnings;
    metaHeaderDataSet.position = littleEndianByteStream.position;
    return metaHeaderDataSet;
  } // This is where we actually start parsing


  return readTheHeader();
}

/***/ }),

/***/ "./readSequenceElementExplicit.js":
/*!****************************************!*\
  !*** ./readSequenceElementExplicit.js ***!
  \****************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return readSequenceItemsExplicit; });
/* harmony import */ var _dataSet_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./dataSet.js */ "./dataSet.js");
/* harmony import */ var _readDicomElementExplicit_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./readDicomElementExplicit.js */ "./readDicomElementExplicit.js");
/* harmony import */ var _readSequenceItem_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./readSequenceItem.js */ "./readSequenceItem.js");
/* harmony import */ var _readTag_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./readTag.js */ "./readTag.js");
/* harmony import */ var _parseDicomDataSet_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./parseDicomDataSet.js */ "./parseDicomDataSet.js");





/**
 * Internal helper functions for parsing DICOM elements
 */

function readDicomDataSetExplicitUndefinedLength(byteStream, warnings) {
  var elements = {};

  while (byteStream.position < byteStream.byteArray.length) {
    var element = Object(_readDicomElementExplicit_js__WEBPACK_IMPORTED_MODULE_1__["default"])(byteStream, warnings);
    elements[element.tag] = element; // we hit an item delimiter tag, return the current offset to mark
    // the end of this sequence item

    if (element.tag === 'xfffee00d') {
      return new _dataSet_js__WEBPACK_IMPORTED_MODULE_0__["default"](byteStream.byteArrayParser, byteStream.byteArray, elements);
    }
  } // eof encountered - log a warning and return what we have for the element


  warnings.push('eof encountered before finding item delimiter tag while reading sequence item of undefined length');
  return new _dataSet_js__WEBPACK_IMPORTED_MODULE_0__["default"](byteStream.byteArrayParser, byteStream.byteArray, elements);
}

function readSequenceItemExplicit(byteStream, warnings) {
  var item = Object(_readSequenceItem_js__WEBPACK_IMPORTED_MODULE_2__["default"])(byteStream);

  if (item.length === 4294967295) {
    item.hadUndefinedLength = true;
    item.dataSet = readDicomDataSetExplicitUndefinedLength(byteStream, warnings);
    item.length = byteStream.position - item.dataOffset;
  } else {
    item.dataSet = new _dataSet_js__WEBPACK_IMPORTED_MODULE_0__["default"](byteStream.byteArrayParser, byteStream.byteArray, {});
    _parseDicomDataSet_js__WEBPACK_IMPORTED_MODULE_4__["parseDicomDataSetExplicit"](item.dataSet, byteStream, byteStream.position + item.length);
  }

  return item;
}

function readSQElementUndefinedLengthExplicit(byteStream, element, warnings) {
  while (byteStream.position + 4 <= byteStream.byteArray.length) {
    // end reading this sequence if the next tag is the sequence delimitation item
    var nextTag = Object(_readTag_js__WEBPACK_IMPORTED_MODULE_3__["default"])(byteStream);
    byteStream.seek(-4);

    if (nextTag === 'xfffee0dd') {
      // set the correct length
      element.length = byteStream.position - element.dataOffset;
      byteStream.seek(8);
      return element;
    }

    var item = readSequenceItemExplicit(byteStream, warnings);
    element.items.push(item);
  }

  warnings.push('eof encountered before finding sequence delimitation tag while reading sequence of undefined length');
  element.length = byteStream.position - element.dataOffset;
}

function readSQElementKnownLengthExplicit(byteStream, element, warnings) {
  var maxPosition = element.dataOffset + element.length;

  while (byteStream.position < maxPosition) {
    var item = readSequenceItemExplicit(byteStream, warnings);
    element.items.push(item);
  }
}

function readSequenceItemsExplicit(byteStream, element, warnings) {
  if (byteStream === undefined) {
    throw 'dicomParser.readSequenceItemsExplicit: missing required parameter \'byteStream\'';
  }

  if (element === undefined) {
    throw 'dicomParser.readSequenceItemsExplicit: missing required parameter \'element\'';
  }

  element.items = [];

  if (element.length === 4294967295) {
    readSQElementUndefinedLengthExplicit(byteStream, element, warnings);
  } else {
    readSQElementKnownLengthExplicit(byteStream, element, warnings);
  }
}

/***/ }),

/***/ "./readSequenceElementImplicit.js":
/*!****************************************!*\
  !*** ./readSequenceElementImplicit.js ***!
  \****************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return readSequenceItemsImplicit; });
/* harmony import */ var _dataSet_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./dataSet.js */ "./dataSet.js");
/* harmony import */ var _readDicomElementImplicit_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./readDicomElementImplicit.js */ "./readDicomElementImplicit.js");
/* harmony import */ var _readSequenceItem_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./readSequenceItem.js */ "./readSequenceItem.js");
/* harmony import */ var _readTag_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./readTag.js */ "./readTag.js");
/* harmony import */ var _parseDicomDataSet_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./parseDicomDataSet.js */ "./parseDicomDataSet.js");





/**
 * Internal helper functions for parsing DICOM elements
 */

function readDicomDataSetImplicitUndefinedLength(byteStream, vrCallback) {
  var elements = {};

  while (byteStream.position < byteStream.byteArray.length) {
    var element = Object(_readDicomElementImplicit_js__WEBPACK_IMPORTED_MODULE_1__["default"])(byteStream, undefined, vrCallback);
    elements[element.tag] = element; // we hit an item delimiter tag, return the current offset to mark
    // the end of this sequence item

    if (element.tag === 'xfffee00d') {
      return new _dataSet_js__WEBPACK_IMPORTED_MODULE_0__["default"](byteStream.byteArrayParser, byteStream.byteArray, elements);
    }
  } // eof encountered - log a warning and return what we have for the element


  byteStream.warnings.push('eof encountered before finding sequence item delimiter in sequence item of undefined length');
  return new _dataSet_js__WEBPACK_IMPORTED_MODULE_0__["default"](byteStream.byteArrayParser, byteStream.byteArray, elements);
}

function readSequenceItemImplicit(byteStream, vrCallback) {
  var item = Object(_readSequenceItem_js__WEBPACK_IMPORTED_MODULE_2__["default"])(byteStream);

  if (item.length === 4294967295) {
    item.hadUndefinedLength = true;
    item.dataSet = readDicomDataSetImplicitUndefinedLength(byteStream, vrCallback);
    item.length = byteStream.position - item.dataOffset;
  } else {
    item.dataSet = new _dataSet_js__WEBPACK_IMPORTED_MODULE_0__["default"](byteStream.byteArrayParser, byteStream.byteArray, {});
    _parseDicomDataSet_js__WEBPACK_IMPORTED_MODULE_4__["parseDicomDataSetImplicit"](item.dataSet, byteStream, byteStream.position + item.length, {
      vrCallback: vrCallback
    });
  }

  return item;
}

function readSQElementUndefinedLengthImplicit(byteStream, element, vrCallback) {
  while (byteStream.position + 4 <= byteStream.byteArray.length) {
    // end reading this sequence if the next tag is the sequence delimitation item
    var nextTag = Object(_readTag_js__WEBPACK_IMPORTED_MODULE_3__["default"])(byteStream);
    byteStream.seek(-4);

    if (nextTag === 'xfffee0dd') {
      // set the correct length
      element.length = byteStream.position - element.dataOffset;
      byteStream.seek(8);
      return element;
    }

    var item = readSequenceItemImplicit(byteStream, vrCallback);
    element.items.push(item);
  }

  byteStream.warnings.push('eof encountered before finding sequence delimiter in sequence of undefined length');
  element.length = byteStream.byteArray.length - element.dataOffset;
}

function readSQElementKnownLengthImplicit(byteStream, element, vrCallback) {
  var maxPosition = element.dataOffset + element.length;

  while (byteStream.position < maxPosition) {
    var item = readSequenceItemImplicit(byteStream, vrCallback);
    element.items.push(item);
  }
}
/**
 * Reads sequence items for an element in an implicit little endian byte stream
 * @param byteStream the implicit little endian byte stream
 * @param element the element to read the sequence items for
 * @param vrCallback an optional method that returns a VR string given a tag
 */


function readSequenceItemsImplicit(byteStream, element, vrCallback) {
  if (byteStream === undefined) {
    throw 'dicomParser.readSequenceItemsImplicit: missing required parameter \'byteStream\'';
  }

  if (element === undefined) {
    throw 'dicomParser.readSequenceItemsImplicit: missing required parameter \'element\'';
  }

  element.items = [];

  if (element.length === 4294967295) {
    readSQElementUndefinedLengthImplicit(byteStream, element, vrCallback);
  } else {
    readSQElementKnownLengthImplicit(byteStream, element, vrCallback);
  }
}

/***/ }),

/***/ "./readSequenceItem.js":
/*!*****************************!*\
  !*** ./readSequenceItem.js ***!
  \*****************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return readSequenceItem; });
/* harmony import */ var _readTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./readTag.js */ "./readTag.js");

/**
 * Internal helper functions for parsing DICOM elements
 */

/**
 * Reads the tag and length of a sequence item and returns them as an object with the following properties
 *  tag : string for the tag of this element in the format xggggeeee
 *  length: the number of bytes in this item or 4294967295 if undefined
 *  dataOffset: the offset into the byteStream of the data for this item
 * @param byteStream the byte
 * @returns {{tag: string, length: integer, dataOffset: integer}}
 */

function readSequenceItem(byteStream) {
  if (byteStream === undefined) {
    throw 'dicomParser.readSequenceItem: missing required parameter \'byteStream\'';
  }

  var element = {
    tag: Object(_readTag_js__WEBPACK_IMPORTED_MODULE_0__["default"])(byteStream),
    length: byteStream.readUint32(),
    dataOffset: byteStream.position
  };

  if (element.tag !== 'xfffee000') {
    throw "dicomParser.readSequenceItem: item tag (FFFE,E000) not found at offset ".concat(byteStream.position);
  }

  return element;
}

/***/ }),

/***/ "./readTag.js":
/*!********************!*\
  !*** ./readTag.js ***!
  \********************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return readTag; });
/**
 * Internal helper functions for parsing DICOM elements
 */

/**
 * Reads a tag (group number and element number) from a byteStream
 * @param byteStream the byte stream to read from
 * @returns {string} the tag in format xggggeeee where gggg is the lowercase hex value of the group number
 * and eeee is the lower case hex value of the element number
 */
function readTag(byteStream) {
  if (byteStream === undefined) {
    throw 'dicomParser.readTag: missing required parameter \'byteStream\'';
  }

  var groupNumber = byteStream.readUint16() * 256 * 256;
  var elementNumber = byteStream.readUint16();
  var tag = "x".concat("00000000".concat((groupNumber + elementNumber).toString(16)).substr(-8));
  return tag;
}

/***/ }),

/***/ "./sharedCopy.js":
/*!***********************!*\
  !*** ./sharedCopy.js ***!
  \***********************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return sharedCopy; });
/**
 *
 * Internal helper function to create a shared copy of a byteArray
 *
 */

/**
 * Creates a view of the underlying byteArray.  The view is of the same type as the byteArray (e.g.
 * Uint8Array or Buffer) and shares the same underlying memory (changing one changes the other)
 * @param byteArray the underlying byteArray (either Uint8Array or Buffer)
 * @param byteOffset offset into the underlying byteArray to create the view of
 * @param length number of bytes in the view
 * @returns {object} Uint8Array or Buffer depending on the type of byteArray
 */
function sharedCopy(byteArray, byteOffset, length) {
  if (typeof Buffer !== 'undefined' && byteArray instanceof Buffer) {
    return byteArray.slice(byteOffset, byteOffset + length);
  } else if (byteArray instanceof Uint8Array) {
    return new Uint8Array(byteArray.buffer, byteArray.byteOffset + byteOffset, length);
  }

  throw 'dicomParser.from: unknown type for byteArray';
}

/***/ }),

/***/ "./util/createJPEGBasicOffsetTable.js":
/*!********************************************!*\
  !*** ./util/createJPEGBasicOffsetTable.js ***!
  \********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return createJPEGBasicOffsetTable; });
// Each JPEG image has an end of image marker 0xFFD9
function isEndOfImageMarker(dataSet, position) {
  return dataSet.byteArray[position] === 0xFF && dataSet.byteArray[position + 1] === 0xD9;
}

function isFragmentEndOfImage(dataSet, pixelDataElement, fragmentIndex) {
  var fragment = pixelDataElement.fragments[fragmentIndex]; // Need to check the last two bytes and the last three bytes for marker since odd length
  // fragments are zero padded

  if (isEndOfImageMarker(dataSet, fragment.position + fragment.length - 2) || isEndOfImageMarker(dataSet, fragment.position + fragment.length - 3)) {
    return true;
  }

  return false;
}

function findLastImageFrameFragmentIndex(dataSet, pixelDataElement, startFragment) {
  for (var fragmentIndex = startFragment; fragmentIndex < pixelDataElement.fragments.length; fragmentIndex++) {
    if (isFragmentEndOfImage(dataSet, pixelDataElement, fragmentIndex)) {
      return fragmentIndex;
    }
  }
}
/**
 * Creates a basic offset table by scanning fragments for JPEG start of image and end Of Image markers
 * @param {object} dataSet - the parsed dicom dataset
 * @param {object} pixelDataElement - the pixel data element
 * @param [fragments] - optional array of objects describing each fragment (offset, position, length)
 * @returns {Array} basic offset table (array of offsets to beginning of each frame)
 */


function createJPEGBasicOffsetTable(dataSet, pixelDataElement, fragments) {
  // Validate parameters
  if (dataSet === undefined) {
    throw 'dicomParser.createJPEGBasicOffsetTable: missing required parameter dataSet';
  }

  if (pixelDataElement === undefined) {
    throw 'dicomParser.createJPEGBasicOffsetTable: missing required parameter pixelDataElement';
  }

  if (pixelDataElement.tag !== 'x7fe00010') {
    throw 'dicomParser.createJPEGBasicOffsetTable: parameter \'pixelDataElement\' refers to non pixel data tag (expected tag = x7fe00010\'';
  }

  if (pixelDataElement.encapsulatedPixelData !== true) {
    throw 'dicomParser.createJPEGBasicOffsetTable: parameter \'pixelDataElement\' refers to pixel data element that does not have encapsulated pixel data';
  }

  if (pixelDataElement.hadUndefinedLength !== true) {
    throw 'dicomParser.createJPEGBasicOffsetTable: parameter \'pixelDataElement\' refers to pixel data element that does not have encapsulated pixel data';
  }

  if (pixelDataElement.basicOffsetTable === undefined) {
    throw 'dicomParser.createJPEGBasicOffsetTable: parameter \'pixelDataElement\' refers to pixel data element that does not have encapsulated pixel data';
  }

  if (pixelDataElement.fragments === undefined) {
    throw 'dicomParser.createJPEGBasicOffsetTable: parameter \'pixelDataElement\' refers to pixel data element that does not have encapsulated pixel data';
  }

  if (pixelDataElement.fragments.length <= 0) {
    throw 'dicomParser.createJPEGBasicOffsetTable: parameter \'pixelDataElement\' refers to pixel data element that does not have encapsulated pixel data';
  }

  if (fragments && fragments.length <= 0) {
    throw 'dicomParser.createJPEGBasicOffsetTable: parameter \'fragments\' must not be zero length';
  } // Default values


  fragments = fragments || pixelDataElement.fragments;
  var basicOffsetTable = [];
  var startFragmentIndex = 0;

  while (true) {
    // Add the offset for the start fragment
    basicOffsetTable.push(pixelDataElement.fragments[startFragmentIndex].offset);
    var endFragmentIndex = findLastImageFrameFragmentIndex(dataSet, pixelDataElement, startFragmentIndex);

    if (endFragmentIndex === undefined || endFragmentIndex === pixelDataElement.fragments.length - 1) {
      return basicOffsetTable;
    }

    startFragmentIndex = endFragmentIndex + 1;
  }
}

/***/ }),

/***/ "./util/dataSetToJS.js":
/*!*****************************!*\
  !*** ./util/dataSetToJS.js ***!
  \*****************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return explicitDataSetToJS; });
/* harmony import */ var _elementToString_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./elementToString.js */ "./util/elementToString.js");
/* harmony import */ var _util_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./util.js */ "./util/util.js");


/**
 * converts an explicit dataSet to a javascript object
 * @param dataSet
 * @param options
 */

function explicitDataSetToJS(dataSet, options) {
  if (dataSet === undefined) {
    throw 'dicomParser.explicitDataSetToJS: missing required parameter dataSet';
  }

  options = options || {
    omitPrivateAttibutes: true,
    // true if private elements should be omitted
    maxElementLength: 128 // maximum element length to try and convert to string format

  };
  var result = {};

  for (var tag in dataSet.elements) {
    var element = dataSet.elements[tag]; // skip this element if it a private element and our options specify that we should

    if (options.omitPrivateAttibutes === true && _util_js__WEBPACK_IMPORTED_MODULE_1__["isPrivateTag"](tag)) {
      continue;
    }

    if (element.items) {
      // handle sequences
      var sequenceItems = [];

      for (var i = 0; i < element.items.length; i++) {
        sequenceItems.push(explicitDataSetToJS(element.items[i].dataSet, options));
      }

      result[tag] = sequenceItems;
    } else {
      var asString;
      asString = undefined;

      if (element.length < options.maxElementLength) {
        asString = Object(_elementToString_js__WEBPACK_IMPORTED_MODULE_0__["default"])(dataSet, element);
      }

      if (asString !== undefined) {
        result[tag] = asString;
      } else {
        result[tag] = {
          dataOffset: element.dataOffset,
          length: element.length
        };
      }
    }
  }

  return result;
}

/***/ }),

/***/ "./util/elementToString.js":
/*!*********************************!*\
  !*** ./util/elementToString.js ***!
  \*********************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return explicitElementToString; });
/* harmony import */ var _util_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./util.js */ "./util/util.js");

/**
 * Converts an explicit VR element to a string or undefined if it is not possible to convert.
 * Throws an error if an implicit element is supplied
 * @param dataSet
 * @param element
 * @returns {*}
 */

function explicitElementToString(dataSet, element) {
  if (dataSet === undefined || element === undefined) {
    throw 'dicomParser.explicitElementToString: missing required parameters';
  }

  if (element.vr === undefined) {
    throw 'dicomParser.explicitElementToString: cannot convert implicit element to string';
  }

  var vr = element.vr;
  var tag = element.tag;
  var textResult;

  function multiElementToString(numItems, func) {
    var result = '';

    for (var i = 0; i < numItems; i++) {
      if (i !== 0) {
        result += '/';
      }

      result += func.call(dataSet, tag, i).toString();
    }

    return result;
  }

  if (_util_js__WEBPACK_IMPORTED_MODULE_0__["isStringVr"](vr) === true) {
    textResult = dataSet.string(tag);
  } else if (vr === 'AT') {
    var num = dataSet.uint32(tag);

    if (num === undefined) {
      return undefined;
    }

    if (num < 0) {
      num = 0xFFFFFFFF + num + 1;
    }

    return "x".concat(num.toString(16).toUpperCase());
  } else if (vr === 'US') {
    textResult = multiElementToString(element.length / 2, dataSet.uint16);
  } else if (vr === 'SS') {
    textResult = multiElementToString(element.length / 2, dataSet.int16);
  } else if (vr === 'UL') {
    textResult = multiElementToString(element.length / 4, dataSet.uint32);
  } else if (vr === 'SL') {
    textResult = multiElementToString(element.length / 4, dataSet.int32);
  } else if (vr === 'FD') {
    textResult = multiElementToString(element.length / 8, dataSet["double"]);
  } else if (vr === 'FL') {
    textResult = multiElementToString(element.length / 4, dataSet["float"]);
  }

  return textResult;
}

/***/ }),

/***/ "./util/index.js":
/*!***********************!*\
  !*** ./util/index.js ***!
  \***********************/
/*! exports provided: isStringVr, isPrivateTag, parsePN, parseTM, parseDA, explicitElementToString, explicitDataSetToJS, createJPEGBasicOffsetTable */
/***/ (function(module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _util_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./util.js */ "./util/util.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isStringVr", function() { return _util_js__WEBPACK_IMPORTED_MODULE_0__["isStringVr"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "isPrivateTag", function() { return _util_js__WEBPACK_IMPORTED_MODULE_0__["isPrivateTag"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "parsePN", function() { return _util_js__WEBPACK_IMPORTED_MODULE_0__["parsePN"]; });

/* harmony import */ var _parseTM_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./parseTM.js */ "./util/parseTM.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "parseTM", function() { return _parseTM_js__WEBPACK_IMPORTED_MODULE_1__["default"]; });

/* harmony import */ var _parseDA_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./parseDA.js */ "./util/parseDA.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "parseDA", function() { return _parseDA_js__WEBPACK_IMPORTED_MODULE_2__["default"]; });

/* harmony import */ var _elementToString_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./elementToString.js */ "./util/elementToString.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "explicitElementToString", function() { return _elementToString_js__WEBPACK_IMPORTED_MODULE_3__["default"]; });

/* harmony import */ var _dataSetToJS_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./dataSetToJS.js */ "./util/dataSetToJS.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "explicitDataSetToJS", function() { return _dataSetToJS_js__WEBPACK_IMPORTED_MODULE_4__["default"]; });

/* harmony import */ var _createJPEGBasicOffsetTable_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./createJPEGBasicOffsetTable.js */ "./util/createJPEGBasicOffsetTable.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "createJPEGBasicOffsetTable", function() { return _createJPEGBasicOffsetTable_js__WEBPACK_IMPORTED_MODULE_5__["default"]; });









/***/ }),

/***/ "./util/parseDA.js":
/*!*************************!*\
  !*** ./util/parseDA.js ***!
  \*************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return parseDA; });
// algorithm based on http://stackoverflow.com/questions/1433030/validate-number-of-days-in-a-given-month
function daysInMonth(m, y) {
  // m is 0 indexed: 0-11
  switch (m) {
    case 2:
      return y % 4 == 0 && y % 100 || y % 400 == 0 ? 29 : 28;

    case 9:
    case 4:
    case 6:
    case 11:
      return 30;

    default:
      return 31;
  }
}

function isValidDate(d, m, y) {
  // make year is a number
  if (isNaN(y)) {
    return false;
  }

  return m > 0 && m <= 12 && d > 0 && d <= daysInMonth(m, y);
}
/**
 * Parses a DA formatted string into a Javascript object
 * @param {string} date a string in the DA VR format
 * @param {boolean} [validate] - true if an exception should be thrown if the date is invalid
 * @returns {*} Javascript object with properties year, month and day or undefined if not present or not 8 bytes long
 */


function parseDA(date, validate) {
  if (date && date.length === 8) {
    var yyyy = parseInt(date.substring(0, 4), 10);
    var mm = parseInt(date.substring(4, 6), 10);
    var dd = parseInt(date.substring(6, 8), 10);

    if (validate) {
      if (isValidDate(dd, mm, yyyy) !== true) {
        throw "invalid DA '".concat(date, "'");
      }
    }

    return {
      year: yyyy,
      month: mm,
      day: dd
    };
  }

  if (validate) {
    throw "invalid DA '".concat(date, "'");
  }

  return undefined;
}

/***/ }),

/***/ "./util/parseTM.js":
/*!*************************!*\
  !*** ./util/parseTM.js ***!
  \*************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return parseTM; });
/**
 * Parses a TM formatted string into a javascript object with properties for hours, minutes, seconds and fractionalSeconds
 * @param {string} time - a string in the TM VR format
 * @param {boolean} [validate] - true if an exception should be thrown if the date is invalid
 * @returns {*} javascript object with properties for hours, minutes, seconds and fractionalSeconds or undefined if no element or data.  Missing fields are set to undefined
 */
function parseTM(time, validate) {
  if (time.length >= 2) {
    // must at least have HH
    // 0123456789
    // HHMMSS.FFFFFF
    var hh = parseInt(time.substring(0, 2), 10);
    var mm = time.length >= 4 ? parseInt(time.substring(2, 4), 10) : undefined;
    var ss = time.length >= 6 ? parseInt(time.substring(4, 6), 10) : undefined;
    var fractionalStr = time.length >= 8 ? time.substring(7, 13) : undefined;
    var ffffff = fractionalStr ? parseInt(fractionalStr, 10) * Math.pow(10, 6 - fractionalStr.length) : undefined;

    if (validate) {
      if (isNaN(hh) || mm !== undefined && isNaN(mm) || ss !== undefined && isNaN(ss) || ffffff !== undefined && isNaN(ffffff) || hh < 0 || hh > 23 || mm && (mm < 0 || mm > 59) || ss && (ss < 0 || ss > 59) || ffffff && (ffffff < 0 || ffffff > 999999)) {
        throw "invalid TM '".concat(time, "'");
      }
    }

    return {
      hours: hh,
      minutes: mm,
      seconds: ss,
      fractionalSeconds: ffffff
    };
  }

  if (validate) {
    throw "invalid TM '".concat(time, "'");
  }

  return undefined;
}

/***/ }),

/***/ "./util/util.js":
/*!**********************!*\
  !*** ./util/util.js ***!
  \**********************/
/*! exports provided: isStringVr, isPrivateTag, parsePN */
/***/ (function(module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isStringVr", function() { return isStringVr; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isPrivateTag", function() { return isPrivateTag; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "parsePN", function() { return parsePN; });
var stringVrs = {
  AE: true,
  AS: true,
  AT: false,
  CS: true,
  DA: true,
  DS: true,
  DT: true,
  FL: false,
  FD: false,
  IS: true,
  LO: true,
  LT: true,
  OB: false,
  OD: false,
  OF: false,
  OW: false,
  PN: true,
  SH: true,
  SL: false,
  SQ: false,
  SS: false,
  ST: true,
  TM: true,
  UI: true,
  UL: false,
  UN: undefined,
  // dunno
  UR: true,
  US: false,
  UT: true
};
/**
 * Tests to see if vr is a string or not.
 * @param vr
 * @returns true if string, false it not string, undefined if unknown vr or UN type
 */

var isStringVr = function isStringVr(vr) {
  return stringVrs[vr];
};
/**
 * Tests to see if a given tag in the format xggggeeee is a private tag or not
 * @param tag
 * @returns {boolean}
 */


var isPrivateTag = function isPrivateTag(tag) {
  var lastGroupDigit = parseInt(tag[4], 10);
  var groupIsOdd = lastGroupDigit % 2 === 1;
  return groupIsOdd;
};
/**
 * Parses a PN formatted string into a javascript object with properties for givenName, familyName, middleName, prefix and suffix
 * @param personName a string in the PN VR format
 * @param index
 * @returns {*} javascript object with properties for givenName, familyName, middleName, prefix and suffix or undefined if no element or data
 */


var parsePN = function parsePN(personName) {
  if (personName === undefined) {
    return undefined;
  }

  var stringValues = personName.split('^');
  return {
    familyName: stringValues[0],
    givenName: stringValues[1],
    middleName: stringValues[2],
    prefix: stringValues[3],
    suffix: stringValues[4]
  };
};



/***/ }),

/***/ "./version.js":
/*!********************!*\
  !*** ./version.js ***!
  \********************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {


__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ('1.8.5');

/***/ }),

/***/ "zlib":
/*!***********************!*\
  !*** external "zlib" ***!
  \***********************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_zlib__;

/***/ })

/******/ });
});
//# sourceMappingURL=dicomParser.js.map;
define("dicom-parser/dist/dicomParser", function(){});

// jshint ignore: start

/* -*- Mode: Java; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- /
 /* vim: set shiftwidth=2 tabstop=2 autoindent cindent expandtab: */
/*
 Copyright 2011 notmasteryet

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

// - The JPEG specification can be found in the ITU CCITT Recommendation T.81
//   (www.w3.org/Graphics/JPEG/itu-t81.pdf)
// - The JFIF specification can be found in the JPEG File Interchange Format
//   (www.w3.org/Graphics/JPEG/jfif3.pdf)
// - The Adobe Application-Specific JPEG markers in the Supporting the DCT Filters
//   in PostScript Level 2, Technical Note #5116
//   (partners.adobe.com/public/developer/en/ps/sdk/5116.DCT_Filter.pdf)

var ColorSpace = {Unkown: 0, Grayscale: 1, AdobeRGB: 2, RGB: 3, CYMK: 4};
var JpegImage = (function jpegImage() {
  "use strict";
  var dctZigZag = new Int32Array([
    0,
    1, 8,
    16, 9, 2,
    3, 10, 17, 24,
    32, 25, 18, 11, 4,
    5, 12, 19, 26, 33, 40,
    48, 41, 34, 27, 20, 13, 6,
    7, 14, 21, 28, 35, 42, 49, 56,
    57, 50, 43, 36, 29, 22, 15,
    23, 30, 37, 44, 51, 58,
    59, 52, 45, 38, 31,
    39, 46, 53, 60,
    61, 54, 47,
    55, 62,
    63
  ]);

  var dctCos1 = 4017;   // cos(pi/16)
  var dctSin1 = 799;   // sin(pi/16)
  var dctCos3 = 3406;   // cos(3*pi/16)
  var dctSin3 = 2276;   // sin(3*pi/16)
  var dctCos6 = 1567;   // cos(6*pi/16)
  var dctSin6 = 3784;   // sin(6*pi/16)
  var dctSqrt2 = 5793;   // sqrt(2)
  var dctSqrt1d2 = 2896;  // sqrt(2) / 2

  function constructor() {
  }

  function buildHuffmanTable(codeLengths, values) {
    var k = 0, code = [], i, j, length = 16;
    while (length > 0 && !codeLengths[length - 1])
      length--;
    code.push({children: [], index: 0});
    var p = code[0], q;
    for (i = 0; i < length; i++) {
      for (j = 0; j < codeLengths[i]; j++) {
        p = code.pop();
        p.children[p.index] = values[k];
        while (p.index > 0) {
          p = code.pop();
        }
        p.index++;
        code.push(p);
        while (code.length <= i) {
          code.push(q = {children: [], index: 0});
          p.children[p.index] = q.children;
          p = q;
        }
        k++;
      }
      if (i + 1 < length) {
        // p here points to last code
        code.push(q = {children: [], index: 0});
        p.children[p.index] = q.children;
        p = q;
      }
    }
    return code[0].children;
  }

  function getBlockBufferOffset(component, row, col) {
    return 64 * ((component.blocksPerLine + 1) * row + col);
  }

  function decodeScan(data, offset,
                      frame, components, resetInterval,
                      spectralStart, spectralEnd,
                      successivePrev, successive) {
    var precision = frame.precision;
    var samplesPerLine = frame.samplesPerLine;
    var scanLines = frame.scanLines;
    var mcusPerLine = frame.mcusPerLine;
    var progressive = frame.progressive;
    var maxH = frame.maxH, maxV = frame.maxV;

    var startOffset = offset, bitsData = 0, bitsCount = 0;

    function readBit() {
      if (bitsCount > 0) {
        bitsCount--;
        return (bitsData >> bitsCount) & 1;
      }
      bitsData = data[offset++];
      if (bitsData == 0xFF) {
        var nextByte = data[offset++];
        if (nextByte) {
          throw "unexpected marker: " + ((bitsData << 8) | nextByte).toString(16);
        }
        // unstuff 0
      }
      bitsCount = 7;
      return bitsData >>> 7;
    }

    function decodeHuffman(tree) {
      var node = tree;
      var bit;
      while ((bit = readBit()) !== null) {
        node = node[bit];
        if (typeof node === 'number')
          return node;
        if (typeof node !== 'object')
          throw "invalid huffman sequence";
      }
      return null;
    }

    function receive(length) {
      var n = 0;
      while (length > 0) {
        var bit = readBit();
        if (bit === null)
          return;
        n = (n << 1) | bit;
        length--;
      }
      return n;
    }

    function receiveAndExtend(length) {
      var n = receive(length);
      if (n >= 1 << (length - 1))
        return n;
      return n + (-1 << length) + 1;
    }

    function decodeBaseline(component, offset) {
      var t = decodeHuffman(component.huffmanTableDC);
      var diff = t === 0 ? 0 : receiveAndExtend(t);
      component.blockData[offset] = (component.pred += diff);
      var k = 1;
      while (k < 64) {
        var rs = decodeHuffman(component.huffmanTableAC);
        var s = rs & 15, r = rs >> 4;
        if (s === 0) {
          if (r < 15)
            break;
          k += 16;
          continue;
        }
        k += r;
        var z = dctZigZag[k];
        component.blockData[offset + z] = receiveAndExtend(s);
        k++;
      }
    }

    function decodeDCFirst(component, offset) {
      var t = decodeHuffman(component.huffmanTableDC);
      var diff = t === 0 ? 0 : (receiveAndExtend(t) << successive);
      component.blockData[offset] = (component.pred += diff);
    }

    function decodeDCSuccessive(component, offset) {
      component.blockData[offset] |= readBit() << successive;
    }

    var eobrun = 0;
    function decodeACFirst(component, offset) {
      if (eobrun > 0) {
        eobrun--;
        return;
      }
      var k = spectralStart, e = spectralEnd;
      while (k <= e) {
        var rs = decodeHuffman(component.huffmanTableAC);
        var s = rs & 15, r = rs >> 4;
        if (s === 0) {
          if (r < 15) {
            eobrun = receive(r) + (1 << r) - 1;
            break;
          }
          k += 16;
          continue;
        }
        k += r;
        var z = dctZigZag[k];
        component.blockData[offset + z] = receiveAndExtend(s) * (1 << successive);
        k++;
      }
    }

    var successiveACState = 0, successiveACNextValue;
    function decodeACSuccessive(component, offset) {
      var k = spectralStart, e = spectralEnd, r = 0;
      while (k <= e) {
        var z = dctZigZag[k];
        switch (successiveACState) {
          case 0: // initial state
            var rs = decodeHuffman(component.huffmanTableAC);
            var s = rs & 15;
            r = rs >> 4;
            if (s === 0) {
              if (r < 15) {
                eobrun = receive(r) + (1 << r);
                successiveACState = 4;
              } else {
                r = 16;
                successiveACState = 1;
              }
            } else {
              if (s !== 1)
                throw "invalid ACn encoding";
              successiveACNextValue = receiveAndExtend(s);
              successiveACState = r ? 2 : 3;
            }
            continue;
          case 1: // skipping r zero items
          case 2:
            if (component.blockData[offset + z]) {
              component.blockData[offset + z] += (readBit() << successive);
            } else {
              r--;
              if (r === 0)
                successiveACState = successiveACState == 2 ? 3 : 0;
            }
            break;
          case 3: // set value for a zero item
            if (component.blockData[offset + z]) {
              component.blockData[offset + z] += (readBit() << successive);
            } else {
              component.blockData[offset + z] = successiveACNextValue << successive;
              successiveACState = 0;
            }
            break;
          case 4: // eob
            if (component.blockData[offset + z]) {
              component.blockData[offset + z] += (readBit() << successive);
            }
            break;
        }
        k++;
      }
      if (successiveACState === 4) {
        eobrun--;
        if (eobrun === 0)
          successiveACState = 0;
      }
    }

    function decodeMcu(component, decode, mcu, row, col) {
      var mcuRow = (mcu / mcusPerLine) | 0;
      var mcuCol = mcu % mcusPerLine;
      var blockRow = mcuRow * component.v + row;
      var blockCol = mcuCol * component.h + col;
      var offset = getBlockBufferOffset(component, blockRow, blockCol);
      decode(component, offset);
    }

    function decodeBlock(component, decode, mcu) {
      var blockRow = (mcu / component.blocksPerLine) | 0;
      var blockCol = mcu % component.blocksPerLine;
      var offset = getBlockBufferOffset(component, blockRow, blockCol);
      decode(component, offset);
    }

    var componentsLength = components.length;
    var component, i, j, k, n;
    var decodeFn;
    if (progressive) {
      if (spectralStart === 0)
        decodeFn = successivePrev === 0 ? decodeDCFirst : decodeDCSuccessive;
      else
        decodeFn = successivePrev === 0 ? decodeACFirst : decodeACSuccessive;
    } else {
      decodeFn = decodeBaseline;
    }

    var mcu = 0, marker;
    var mcuExpected;
    if (componentsLength == 1) {
      mcuExpected = components[0].blocksPerLine * components[0].blocksPerColumn;
    } else {
      mcuExpected = mcusPerLine * frame.mcusPerColumn;
    }
    if (!resetInterval) {
      resetInterval = mcuExpected;
    }

    var h, v;
    while (mcu < mcuExpected) {
      // reset interval stuff
      for (i = 0; i < componentsLength; i++) {
        components[i].pred = 0;
      }
      eobrun = 0;

      if (componentsLength == 1) {
        component = components[0];
        for (n = 0; n < resetInterval; n++) {
          decodeBlock(component, decodeFn, mcu);
          mcu++;
        }
      } else {
        for (n = 0; n < resetInterval; n++) {
          for (i = 0; i < componentsLength; i++) {
            component = components[i];
            h = component.h;
            v = component.v;
            for (j = 0; j < v; j++) {
              for (k = 0; k < h; k++) {
                decodeMcu(component, decodeFn, mcu, j, k);
              }
            }
          }
          mcu++;
        }
      }

      // find marker
      bitsCount = 0;
      marker = (data[offset] << 8) | data[offset + 1];
      if (marker <= 0xFF00) {
        throw "marker was not found";
      }

      if (marker >= 0xFFD0 && marker <= 0xFFD7) { // RSTx
        offset += 2;
      } else {
        break;
      }
    }

    return offset - startOffset;
  }

  // A port of poppler's IDCT method which in turn is taken from:
  //   Christoph Loeffler, Adriaan Ligtenberg, George S. Moschytz,
  //   "Practical Fast 1-D DCT Algorithms with 11 Multiplications",
  //   IEEE Intl. Conf. on Acoustics, Speech & Signal Processing, 1989,
  //   988-991.
  function quantizeAndInverse(component, blockBufferOffset, p) {
    var qt = component.quantizationTable;
    var v0, v1, v2, v3, v4, v5, v6, v7, t;
    var i;

    // dequant
    for (i = 0; i < 64; i++) {
      p[i] = component.blockData[blockBufferOffset + i] * qt[i];
    }

    // inverse DCT on rows
    for (i = 0; i < 8; ++i) {
      var row = 8 * i;

      // check for all-zero AC coefficients
      if (p[1 + row] === 0 && p[2 + row] === 0 && p[3 + row] === 0 &&
        p[4 + row] === 0 && p[5 + row] === 0 && p[6 + row] === 0 &&
        p[7 + row] === 0) {
        t = (dctSqrt2 * p[0 + row] + 512) >> 10;
        p[0 + row] = t;
        p[1 + row] = t;
        p[2 + row] = t;
        p[3 + row] = t;
        p[4 + row] = t;
        p[5 + row] = t;
        p[6 + row] = t;
        p[7 + row] = t;
        continue;
      }

      // stage 4
      v0 = (dctSqrt2 * p[0 + row] + 128) >> 8;
      v1 = (dctSqrt2 * p[4 + row] + 128) >> 8;
      v2 = p[2 + row];
      v3 = p[6 + row];
      v4 = (dctSqrt1d2 * (p[1 + row] - p[7 + row]) + 128) >> 8;
      v7 = (dctSqrt1d2 * (p[1 + row] + p[7 + row]) + 128) >> 8;
      v5 = p[3 + row] << 4;
      v6 = p[5 + row] << 4;

      // stage 3
      t = (v0 - v1 + 1) >> 1;
      v0 = (v0 + v1 + 1) >> 1;
      v1 = t;
      t = (v2 * dctSin6 + v3 * dctCos6 + 128) >> 8;
      v2 = (v2 * dctCos6 - v3 * dctSin6 + 128) >> 8;
      v3 = t;
      t = (v4 - v6 + 1) >> 1;
      v4 = (v4 + v6 + 1) >> 1;
      v6 = t;
      t = (v7 + v5 + 1) >> 1;
      v5 = (v7 - v5 + 1) >> 1;
      v7 = t;

      // stage 2
      t = (v0 - v3 + 1) >> 1;
      v0 = (v0 + v3 + 1) >> 1;
      v3 = t;
      t = (v1 - v2 + 1) >> 1;
      v1 = (v1 + v2 + 1) >> 1;
      v2 = t;
      t = (v4 * dctSin3 + v7 * dctCos3 + 2048) >> 12;
      v4 = (v4 * dctCos3 - v7 * dctSin3 + 2048) >> 12;
      v7 = t;
      t = (v5 * dctSin1 + v6 * dctCos1 + 2048) >> 12;
      v5 = (v5 * dctCos1 - v6 * dctSin1 + 2048) >> 12;
      v6 = t;

      // stage 1
      p[0 + row] = v0 + v7;
      p[7 + row] = v0 - v7;
      p[1 + row] = v1 + v6;
      p[6 + row] = v1 - v6;
      p[2 + row] = v2 + v5;
      p[5 + row] = v2 - v5;
      p[3 + row] = v3 + v4;
      p[4 + row] = v3 - v4;
    }

    // inverse DCT on columns
    for (i = 0; i < 8; ++i) {
      var col = i;

      // check for all-zero AC coefficients
      if (p[1 * 8 + col] === 0 && p[2 * 8 + col] === 0 && p[3 * 8 + col] === 0 &&
        p[4 * 8 + col] === 0 && p[5 * 8 + col] === 0 && p[6 * 8 + col] === 0 &&
        p[7 * 8 + col] === 0) {
        t = (dctSqrt2 * p[i + 0] + 8192) >> 14;
        p[0 * 8 + col] = t;
        p[1 * 8 + col] = t;
        p[2 * 8 + col] = t;
        p[3 * 8 + col] = t;
        p[4 * 8 + col] = t;
        p[5 * 8 + col] = t;
        p[6 * 8 + col] = t;
        p[7 * 8 + col] = t;
        continue;
      }

      // stage 4
      v0 = (dctSqrt2 * p[0 * 8 + col] + 2048) >> 12;
      v1 = (dctSqrt2 * p[4 * 8 + col] + 2048) >> 12;
      v2 = p[2 * 8 + col];
      v3 = p[6 * 8 + col];
      v4 = (dctSqrt1d2 * (p[1 * 8 + col] - p[7 * 8 + col]) + 2048) >> 12;
      v7 = (dctSqrt1d2 * (p[1 * 8 + col] + p[7 * 8 + col]) + 2048) >> 12;
      v5 = p[3 * 8 + col];
      v6 = p[5 * 8 + col];

      // stage 3
      t = (v0 - v1 + 1) >> 1;
      v0 = (v0 + v1 + 1) >> 1;
      v1 = t;
      t = (v2 * dctSin6 + v3 * dctCos6 + 2048) >> 12;
      v2 = (v2 * dctCos6 - v3 * dctSin6 + 2048) >> 12;
      v3 = t;
      t = (v4 - v6 + 1) >> 1;
      v4 = (v4 + v6 + 1) >> 1;
      v6 = t;
      t = (v7 + v5 + 1) >> 1;
      v5 = (v7 - v5 + 1) >> 1;
      v7 = t;

      // stage 2
      t = (v0 - v3 + 1) >> 1;
      v0 = (v0 + v3 + 1) >> 1;
      v3 = t;
      t = (v1 - v2 + 1) >> 1;
      v1 = (v1 + v2 + 1) >> 1;
      v2 = t;
      t = (v4 * dctSin3 + v7 * dctCos3 + 2048) >> 12;
      v4 = (v4 * dctCos3 - v7 * dctSin3 + 2048) >> 12;
      v7 = t;
      t = (v5 * dctSin1 + v6 * dctCos1 + 2048) >> 12;
      v5 = (v5 * dctCos1 - v6 * dctSin1 + 2048) >> 12;
      v6 = t;

      // stage 1
      p[0 * 8 + col] = v0 + v7;
      p[7 * 8 + col] = v0 - v7;
      p[1 * 8 + col] = v1 + v6;
      p[6 * 8 + col] = v1 - v6;
      p[2 * 8 + col] = v2 + v5;
      p[5 * 8 + col] = v2 - v5;
      p[3 * 8 + col] = v3 + v4;
      p[4 * 8 + col] = v3 - v4;
    }

    // convert to 8-bit integers
    for (i = 0; i < 64; ++i) {
      var index = blockBufferOffset + i;
      var q = p[i];
      q = (q <= -2056 / component.bitConversion) ? 0 :
        (q >= 2024 / component.bitConversion) ? 255 / component.bitConversion :
        (q + 2056 / component.bitConversion) >> 4;
      component.blockData[index] = q;
    }
  }

  function buildComponentData(frame, component) {
    var lines = [];
    var blocksPerLine = component.blocksPerLine;
    var blocksPerColumn = component.blocksPerColumn;
    var samplesPerLine = blocksPerLine << 3;
    var computationBuffer = new Int32Array(64);

    var i, j, ll = 0;
    for (var blockRow = 0; blockRow < blocksPerColumn; blockRow++) {
      for (var blockCol = 0; blockCol < blocksPerLine; blockCol++) {
        var offset = getBlockBufferOffset(component, blockRow, blockCol);
        quantizeAndInverse(component, offset, computationBuffer);
      }
    }
    return component.blockData;
  }

  function clampToUint8(a) {
    return a <= 0 ? 0 : a >= 255 ? 255 : a | 0;
  }

  constructor.prototype = {
    load: function load(path) {
      var handleData = (function (data) {
        this.parse(data);
        if (this.onload)
          this.onload();
      }).bind(this);

      if (path.indexOf("data:") > -1) {
        var offset = path.indexOf("base64,") + 7;
        var data = atob(path.substring(offset));
        var arr = new Uint8Array(data.length);
        for (var i = data.length - 1; i >= 0; i--) {
          arr[i] = data.charCodeAt(i);
        }
        handleData(data);
      } else {
        var xhr = new XMLHttpRequest();
        xhr.open("GET", path, true);
        xhr.responseType = "arraybuffer";
        xhr.onload = (function () {
          // TODO catch parse error
          var data = new Uint8Array(xhr.response);
          handleData(data);
        }).bind(this);
        xhr.send(null);
      }
    },
    parse: function parse(data) {

      function readUint16() {
        var value = (data[offset] << 8) | data[offset + 1];
        offset += 2;
        return value;
      }

      function readDataBlock() {
        var length = readUint16();
        var array = data.subarray(offset, offset + length - 2);
        offset += array.length;
        return array;
      }

      function prepareComponents(frame) {
        var mcusPerLine = Math.ceil(frame.samplesPerLine / 8 / frame.maxH);
        var mcusPerColumn = Math.ceil(frame.scanLines / 8 / frame.maxV);
        for (var i = 0; i < frame.components.length; i++) {
          component = frame.components[i];
          var blocksPerLine = Math.ceil(Math.ceil(frame.samplesPerLine / 8) * component.h / frame.maxH);
          var blocksPerColumn = Math.ceil(Math.ceil(frame.scanLines / 8) * component.v / frame.maxV);
          var blocksPerLineForMcu = mcusPerLine * component.h;
          var blocksPerColumnForMcu = mcusPerColumn * component.v;

          var blocksBufferSize = 64 * blocksPerColumnForMcu * (blocksPerLineForMcu + 1);
          component.blockData = new Int16Array(blocksBufferSize);
          component.blocksPerLine = blocksPerLine;
          component.blocksPerColumn = blocksPerColumn;
        }
        frame.mcusPerLine = mcusPerLine;
        frame.mcusPerColumn = mcusPerColumn;
      }

      var offset = 0, length = data.length;
      var jfif = null;
      var adobe = null;
      var pixels = null;
      var frame, resetInterval;
      var quantizationTables = [];
      var huffmanTablesAC = [], huffmanTablesDC = [];
      var fileMarker = readUint16();
      if (fileMarker != 0xFFD8) { // SOI (Start of Image)
        throw "SOI not found";
      }

      fileMarker = readUint16();
      while (fileMarker != 0xFFD9) { // EOI (End of image)
        var i, j, l;
        switch (fileMarker) {
          case 0xFFE0: // APP0 (Application Specific)
          case 0xFFE1: // APP1
          case 0xFFE2: // APP2
          case 0xFFE3: // APP3
          case 0xFFE4: // APP4
          case 0xFFE5: // APP5
          case 0xFFE6: // APP6
          case 0xFFE7: // APP7
          case 0xFFE8: // APP8
          case 0xFFE9: // APP9
          case 0xFFEA: // APP10
          case 0xFFEB: // APP11
          case 0xFFEC: // APP12
          case 0xFFED: // APP13
          case 0xFFEE: // APP14
          case 0xFFEF: // APP15
          case 0xFFFE: // COM (Comment)
            var appData = readDataBlock();

            if (fileMarker === 0xFFE0) {
              if (appData[0] === 0x4A && appData[1] === 0x46 && appData[2] === 0x49 &&
                appData[3] === 0x46 && appData[4] === 0) { // 'JFIF\x00'
                jfif = {
                  version: {major: appData[5], minor: appData[6]},
                  densityUnits: appData[7],
                  xDensity: (appData[8] << 8) | appData[9],
                  yDensity: (appData[10] << 8) | appData[11],
                  thumbWidth: appData[12],
                  thumbHeight: appData[13],
                  thumbData: appData.subarray(14, 14 + 3 * appData[12] * appData[13])
                };
              }
            }
            // TODO APP1 - Exif
            if (fileMarker === 0xFFEE) {
              if (appData[0] === 0x41 && appData[1] === 0x64 && appData[2] === 0x6F &&
                appData[3] === 0x62 && appData[4] === 0x65 && appData[5] === 0) { // 'Adobe\x00'
                adobe = {
                  version: appData[6],
                  flags0: (appData[7] << 8) | appData[8],
                  flags1: (appData[9] << 8) | appData[10],
                  transformCode: appData[11]
                };
              }
            }
            break;

          case 0xFFDB: // DQT (Define Quantization Tables)
            var quantizationTablesLength = readUint16();
            var quantizationTablesEnd = quantizationTablesLength + offset - 2;
            while (offset < quantizationTablesEnd) {
              var quantizationTableSpec = data[offset++];
              var tableData = new Int32Array(64);
              if ((quantizationTableSpec >> 4) === 0) { // 8 bit values
                for (j = 0; j < 64; j++) {
                  var z = dctZigZag[j];
                  tableData[z] = data[offset++];
                }
              } else if ((quantizationTableSpec >> 4) === 1) { //16 bit
                for (j = 0; j < 64; j++) {
                  var zz = dctZigZag[j];
                  tableData[zz] = readUint16();
                }
              } else
                throw "DQT: invalid table spec";
              quantizationTables[quantizationTableSpec & 15] = tableData;
            }
            break;

          case 0xFFC0: // SOF0 (Start of Frame, Baseline DCT)
          case 0xFFC1: // SOF1 (Start of Frame, Extended DCT)
          case 0xFFC2: // SOF2 (Start of Frame, Progressive DCT)
            if (frame) {
              throw "Only single frame JPEGs supported";
            }
            readUint16(); // skip data length
            frame = {};
            frame.extended = (fileMarker === 0xFFC1);
            frame.progressive = (fileMarker === 0xFFC2);
            frame.precision = data[offset++];
            frame.scanLines = readUint16();
            frame.samplesPerLine = readUint16();
            frame.components = [];
            frame.componentIds = {};
            var componentsCount = data[offset++], componentId;
            var maxH = 0, maxV = 0;
            for (i = 0; i < componentsCount; i++) {
              componentId = data[offset];
              var h = data[offset + 1] >> 4;
              var v = data[offset + 1] & 15;
              if (maxH < h)
                maxH = h;
              if (maxV < v)
                maxV = v;
              var qId = data[offset + 2];
              l = frame.components.push({
                h: h,
                v: v,
                quantizationTable: quantizationTables[qId],
                quantizationTableId: qId,
                bitConversion: 255 / ((1 << frame.precision) - 1)
              });
              frame.componentIds[componentId] = l - 1;
              offset += 3;
            }
            frame.maxH = maxH;
            frame.maxV = maxV;
            prepareComponents(frame);
            break;

          case 0xFFC4: // DHT (Define Huffman Tables)
            var huffmanLength = readUint16();
            for (i = 2; i < huffmanLength; ) {
              var huffmanTableSpec = data[offset++];
              var codeLengths = new Uint8Array(16);
              var codeLengthSum = 0;
              for (j = 0; j < 16; j++, offset++)
                codeLengthSum += (codeLengths[j] = data[offset]);
              var huffmanValues = new Uint8Array(codeLengthSum);
              for (j = 0; j < codeLengthSum; j++, offset++)
                huffmanValues[j] = data[offset];
              i += 17 + codeLengthSum;

              ((huffmanTableSpec >> 4) === 0 ?
                huffmanTablesDC : huffmanTablesAC)[huffmanTableSpec & 15] =
                buildHuffmanTable(codeLengths, huffmanValues);
            }
            break;

          case 0xFFDD: // DRI (Define Restart Interval)
            readUint16(); // skip data length
            resetInterval = readUint16();
            break;

          case 0xFFDA: // SOS (Start of Scan)
            var scanLength = readUint16();
            var selectorsCount = data[offset++];
            var components = [], component;
            for (i = 0; i < selectorsCount; i++) {
              var componentIndex = frame.componentIds[data[offset++]];
              component = frame.components[componentIndex];
              var tableSpec = data[offset++];
              component.huffmanTableDC = huffmanTablesDC[tableSpec >> 4];
              component.huffmanTableAC = huffmanTablesAC[tableSpec & 15];
              components.push(component);
            }
            var spectralStart = data[offset++];
            var spectralEnd = data[offset++];
            var successiveApproximation = data[offset++];
            var processed = decodeScan(data, offset,
              frame, components, resetInterval,
              spectralStart, spectralEnd,
              successiveApproximation >> 4, successiveApproximation & 15);
            offset += processed;
            break;
          case 0xFFFF: // Fill bytes
            if (data[offset] !== 0xFF) { // Avoid skipping a valid marker.
              offset--;
            }
            break;
          default:
            if (data[offset - 3] == 0xFF &&
              data[offset - 2] >= 0xC0 && data[offset - 2] <= 0xFE) {
              // could be incorrect encoding -- last 0xFF byte of the previous
              // block was eaten by the encoder
              offset -= 3;
              break;
            }
            throw "unknown JPEG marker " + fileMarker.toString(16);
        }
        fileMarker = readUint16();
      }

      this.width = frame.samplesPerLine;
      this.height = frame.scanLines;
      this.jfif = jfif;
      this.adobe = adobe;
      this.components = [];
      switch (frame.components.length)
      {
        case 1:
          this.colorspace = ColorSpace.Grayscale;
          break;
        case 3:
          if (this.adobe)
            this.colorspace = ColorSpace.AdobeRGB;
          else
            this.colorspace = ColorSpace.RGB;
          break;
        case 4:
          this.colorspace = ColorSpace.CYMK;
          break;
        default:
          this.colorspace = ColorSpace.Unknown;
      }
      for (var i = 0; i < frame.components.length; i++) {
        var component = frame.components[i];
        if (!component.quantizationTable && component.quantizationTableId !== null)
          component.quantizationTable = quantizationTables[component.quantizationTableId];
        this.components.push({
          output: buildComponentData(frame, component),
          scaleX: component.h / frame.maxH,
          scaleY: component.v / frame.maxV,
          blocksPerLine: component.blocksPerLine,
          blocksPerColumn: component.blocksPerColumn,
          bitConversion: component.bitConversion
        });
      }
    },
    getData16: function getData16(width, height) {
      if (this.components.length !== 1)
        throw 'Unsupported color mode';
      var scaleX = this.width / width, scaleY = this.height / height;

      var component, componentScaleX, componentScaleY;
      var x, y, i;
      var offset = 0;
      var numComponents = this.components.length;
      var dataLength = width * height * numComponents;
      var data = new Uint16Array(dataLength);
      var componentLine;

      // lineData is reused for all components. Assume first component is
      // the biggest
      var lineData = new Uint16Array((this.components[0].blocksPerLine << 3) *
      this.components[0].blocksPerColumn * 8);

      // First construct image data ...
      for (i = 0; i < numComponents; i++) {
        component = this.components[i];
        var blocksPerLine = component.blocksPerLine;
        var blocksPerColumn = component.blocksPerColumn;
        var samplesPerLine = blocksPerLine << 3;

        var j, k, ll = 0;
        var lineOffset = 0;
        for (var blockRow = 0; blockRow < blocksPerColumn; blockRow++) {
          var scanLine = blockRow << 3;
          for (var blockCol = 0; blockCol < blocksPerLine; blockCol++) {
            var bufferOffset = getBlockBufferOffset(component, blockRow, blockCol);
            var offset = 0, sample = blockCol << 3;
            for (j = 0; j < 8; j++) {
              var lineOffset = (scanLine + j) * samplesPerLine;
              for (k = 0; k < 8; k++) {
                lineData[lineOffset + sample + k] =
                  component.output[bufferOffset + offset++];
              }
            }
          }
        }

        componentScaleX = component.scaleX * scaleX;
        componentScaleY = component.scaleY * scaleY;
        offset = i;

        var cx, cy;
        var index;
        for (y = 0; y < height; y++) {
          for (x = 0; x < width; x++) {
            cy = 0 | (y * componentScaleY);
            cx = 0 | (x * componentScaleX);
            index = cy * samplesPerLine + cx;
            data[offset] = lineData[index];
            offset += numComponents;
          }
        }
      }
      return data;
    },
    getData: function getData(width, height) {
      var scaleX = this.width / width, scaleY = this.height / height;

      var component, componentScaleX, componentScaleY;
      var x, y, i;
      var offset = 0;
      var Y, Cb, Cr, K, C, M, Ye, R, G, B;
      var colorTransform;
      var numComponents = this.components.length;
      var dataLength = width * height * numComponents;
      var data = new Uint8Array(dataLength);
      var componentLine;

      // lineData is reused for all components. Assume first component is
      // the biggest
      var lineData = new Uint8Array((this.components[0].blocksPerLine << 3) *
      this.components[0].blocksPerColumn * 8);

      // First construct image data ...
      for (i = 0; i < numComponents; i++) {
        component = this.components[i];
        var blocksPerLine = component.blocksPerLine;
        var blocksPerColumn = component.blocksPerColumn;
        var samplesPerLine = blocksPerLine << 3;

        var j, k, ll = 0;
        var lineOffset = 0;
        for (var blockRow = 0; blockRow < blocksPerColumn; blockRow++) {
          var scanLine = blockRow << 3;
          for (var blockCol = 0; blockCol < blocksPerLine; blockCol++) {
            var bufferOffset = getBlockBufferOffset(component, blockRow, blockCol);
            var offset = 0, sample = blockCol << 3;
            for (j = 0; j < 8; j++) {
              var lineOffset = (scanLine + j) * samplesPerLine;
              for (k = 0; k < 8; k++) {
                lineData[lineOffset + sample + k] =
                  component.output[bufferOffset + offset++] * component.bitConversion;
              }
            }
          }
        }

        componentScaleX = component.scaleX * scaleX;
        componentScaleY = component.scaleY * scaleY;
        offset = i;

        var cx, cy;
        var index;
        for (y = 0; y < height; y++) {
          for (x = 0; x < width; x++) {
            cy = 0 | (y * componentScaleY);
            cx = 0 | (x * componentScaleX);
            index = cy * samplesPerLine + cx;
            data[offset] = lineData[index];
            offset += numComponents;
          }
        }
      }

      // ... then transform colors, if necessary
      switch (numComponents) {
        case 1:
        case 2:
          break;
        // no color conversion for one or two compoenents

        case 3:
          // The default transform for three components is true
          colorTransform = true;
          // The adobe transform marker overrides any previous setting
          if (this.adobe && this.adobe.transformCode)
            colorTransform = true;
          else if (typeof this.colorTransform !== 'undefined')
            colorTransform = !!this.colorTransform;

          if (colorTransform) {
            for (i = 0; i < dataLength; i += numComponents) {
              Y = data[i    ];
              Cb = data[i + 1];
              Cr = data[i + 2];

              R = clampToUint8(Y - 179.456 + 1.402 * Cr);
              G = clampToUint8(Y + 135.459 - 0.344 * Cb - 0.714 * Cr);
              B = clampToUint8(Y - 226.816 + 1.772 * Cb);

              data[i    ] = R;
              data[i + 1] = G;
              data[i + 2] = B;
            }
          }
          break;
        case 4:
          if (!this.adobe)
            throw 'Unsupported color mode (4 components)';
          // The default transform for four components is false
          colorTransform = false;
          // The adobe transform marker overrides any previous setting
          if (this.adobe && this.adobe.transformCode)
            colorTransform = true;
          else if (typeof this.colorTransform !== 'undefined')
            colorTransform = !!this.colorTransform;

          if (colorTransform) {
            for (i = 0; i < dataLength; i += numComponents) {
              Y = data[i];
              Cb = data[i + 1];
              Cr = data[i + 2];

              C = clampToUint8(434.456 - Y - 1.402 * Cr);
              M = clampToUint8(119.541 - Y + 0.344 * Cb + 0.714 * Cr);
              Y = clampToUint8(481.816 - Y - 1.772 * Cb);

              data[i    ] = C;
              data[i + 1] = M;
              data[i + 2] = Y;
              // K is unchanged
            }
          }
          break;
        default:
          throw 'Unsupported color mode';
      }
      return data;
    }
  };

  return constructor;
})();

define("lib/jpeg/jpeg", function(){});

(function(f){if(typeof exports==="object"&&typeof module!=="undefined"){module.exports=f()}else if(typeof define==="function"&&define.amd){define('jpegLossless/release/current/lossless',[],f)}else{var g;if(typeof window!=="undefined"){g=window}else if(typeof global!=="undefined"){g=global}else if(typeof self!=="undefined"){g=self}else{g=this}g.jpeg = f()}})(function(){var define,module,exports;return (function(){function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s}return e})()({1:[function(require,module,exports){
/*
 * Copyright (C) 2015 Michael Martinez
 * Changes: Added support for selection values 2-7, fixed minor bugs &
 * warnings, split into multiple class files, and general clean up.
 *
 * 08-25-2015: Helmut Dersch agreed to a license change from LGPL to MIT.
 */

/*
 * Copyright (C) Helmut Dersch
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/*jslint browser: true, node: true */
/*global require, module */



/*** Imports ***/
var jpeg = jpeg || {};
jpeg.lossless = jpeg.lossless || {};


/*** Constructor ***/
jpeg.lossless.ComponentSpec = jpeg.lossless.ComponentSpec || function () {
    this.hSamp = 0; // Horizontal sampling factor
    this.quantTableSel = 0; // Quantization table destination selector
    this.vSamp = 0; // Vertical
};


/*** Exports ***/

var moduleType = typeof module;
if ((moduleType !== 'undefined') && module.exports) {
    module.exports = jpeg.lossless.ComponentSpec;
}

},{}],2:[function(require,module,exports){
/*
 * Copyright (C) 2015 Michael Martinez
 * Changes: Added support for selection values 2-7, fixed minor bugs &
 * warnings, split into multiple class files, and general clean up.
 *
 * 08-25-2015: Helmut Dersch agreed to a license change from LGPL to MIT.
 */

/*
 * Copyright (C) Helmut Dersch
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/*jslint browser: true, node: true */
/*global require, module */



/*** Imports ***/
var jpeg = jpeg || {};
jpeg.lossless = jpeg.lossless || {};


/*** Constructor ***/
jpeg.lossless.DataStream = jpeg.lossless.DataStream || function (data, offset, length) {
    if (offset === undefined && length === undefined) { // Old api
        this.buffer = new Uint8Array(data);
    } else {
        this.buffer = new Uint8Array(data, offset, length);
    }
    this.index = 0;
};



jpeg.lossless.DataStream.prototype.get16 = function () {
    // var value = this.buffer.getUint16(this.index, false);
    var value = (this.buffer[this.index] << 8) + this.buffer[this.index + 1]; // DataView is big-endian by default
    this.index += 2;
    return value;
};



jpeg.lossless.DataStream.prototype.get8 = function () {
    // var value = this.buffer.getUint8(this.index);
    var value = this.buffer[this.index];
    this.index += 1;
    return value;
};


/*** Exports ***/

var moduleType = typeof module;
if ((moduleType !== 'undefined') && module.exports) {
    module.exports = jpeg.lossless.DataStream;
}

},{}],3:[function(require,module,exports){
/*
 * Copyright (C) 2015 Michael Martinez
 * Changes: Added support for selection values 2-7, fixed minor bugs &
 * warnings, split into multiple class files, and general clean up.
 *
 * 08-25-2015: Helmut Dersch agreed to a license change from LGPL to MIT.
 */

/*
 * Copyright (C) Helmut Dersch
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/*jslint browser: true, node: true */
/*global require, module */



/*** Imports ***/
var jpeg = jpeg || {};
jpeg.lossless = jpeg.lossless || {};
jpeg.lossless.DataStream = jpeg.lossless.DataStream || ((typeof require !== 'undefined') ? require('./data-stream.js') : null);
jpeg.lossless.HuffmanTable = jpeg.lossless.HuffmanTable || ((typeof require !== 'undefined') ? require('./huffman-table.js') : null);
jpeg.lossless.QuantizationTable = jpeg.lossless.QuantizationTable || ((typeof require !== 'undefined') ? require('./quantization-table.js') : null);
jpeg.lossless.ScanHeader = jpeg.lossless.ScanHeader || ((typeof require !== 'undefined') ? require('./scan-header.js') : null);
jpeg.lossless.FrameHeader = jpeg.lossless.FrameHeader || ((typeof require !== 'undefined') ? require('./frame-header.js') : null);
jpeg.lossless.Utils = jpeg.lossless.Utils || ((typeof require !== 'undefined') ? require('./utils.js') : null);


/*** Constructor ***/

/**
 * The Decoder constructor.
 * @property {number} xDim - size of x dimension
 * @property {number} yDim - size of y dimension
 * @property {number} numComp - number of components
 * @property {number} numBytes - number of bytes per component
 * @type {Function}
 */
jpeg.lossless.Decoder = jpeg.lossless.Decoder || function (buffer, numBytes) {
    this.buffer = buffer;
    this.frame = new jpeg.lossless.FrameHeader();
    this.huffTable = new jpeg.lossless.HuffmanTable();
    this.quantTable = new jpeg.lossless.QuantizationTable();
    this.scan = new jpeg.lossless.ScanHeader();
    this.DU = jpeg.lossless.Utils.createArray(10, 4, 64); // at most 10 data units in a MCU, at most 4 data units in one component
    this.HuffTab = jpeg.lossless.Utils.createArray(4, 2, 50 * 256);
    this.IDCT_Source = [];
    this.nBlock = []; // number of blocks in the i-th Comp in a scan
    this.acTab = jpeg.lossless.Utils.createArray(10, 1); // ac HuffTab for the i-th Comp in a scan
    this.dcTab = jpeg.lossless.Utils.createArray(10, 1); // dc HuffTab for the i-th Comp in a scan
    this.qTab = jpeg.lossless.Utils.createArray(10, 1); // quantization table for the i-th Comp in a scan
    this.marker = 0;
    this.markerIndex = 0;
    this.numComp = 0;
    this.restartInterval = 0;
    this.selection = 0;
    this.xDim = 0;
    this.yDim = 0;
    this.xLoc = 0;
    this.yLoc = 0;
    this.numBytes = 0;
    this.outputData = null;
    this.restarting = false;
    this.mask = 0;

    if (typeof numBytes !== "undefined") {
        this.numBytes = numBytes;
    }
};


/*** Static Pseudo-constants ***/

jpeg.lossless.Decoder.IDCT_P = [0, 5, 40, 16, 45, 2, 7, 42, 21, 56, 8, 61, 18, 47, 1, 4, 41, 23, 58, 13, 32, 24, 37, 10, 63, 17, 44, 3, 6, 43, 20,
    57, 15, 34, 29, 48, 53, 26, 39, 9, 60, 19, 46, 22, 59, 12, 33, 31, 50, 55, 25, 36, 11, 62, 14, 35, 28, 49, 52, 27, 38, 30, 51, 54];
jpeg.lossless.Decoder.TABLE = [0, 1, 5, 6, 14, 15, 27, 28, 2, 4, 7, 13, 16, 26, 29, 42, 3, 8, 12, 17, 25, 30, 41, 43, 9, 11, 18, 24, 31, 40, 44, 53,
    10, 19, 23, 32, 39, 45, 52, 54, 20, 22, 33, 38, 46, 51, 55, 60, 21, 34, 37, 47, 50, 56, 59, 61, 35, 36, 48, 49, 57, 58, 62, 63];
jpeg.lossless.Decoder.MAX_HUFFMAN_SUBTREE = 50;
jpeg.lossless.Decoder.MSB = 0x80000000;
jpeg.lossless.Decoder.RESTART_MARKER_BEGIN = 0xFFD0;
jpeg.lossless.Decoder.RESTART_MARKER_END = 0xFFD7;

/*** Prototype Methods ***/

/**
 * Returns decompressed data.
 * @param {ArrayBuffer} buffer
 * @param {number} [offset]
 * @param {number} [length]
 * @returns {ArrayBufer}
 */
jpeg.lossless.Decoder.prototype.decompress = function (buffer, offset, length) {
    return this.decode(buffer, offset, length).buffer;
};



jpeg.lossless.Decoder.prototype.decode = function (buffer, offset, length, numBytes) {
    /*jslint bitwise: true */

    var current, scanNum = 0, pred = [], i, compN, temp = [], index = [], mcuNum;

    if (typeof buffer !== "undefined") {
        this.buffer = buffer;
    }

    if (typeof numBytes !== "undefined") {
        this.numBytes = numBytes;
    }

    this.stream = new jpeg.lossless.DataStream(this.buffer, offset, length);
    this.buffer = null;

    this.xLoc = 0;
    this.yLoc = 0;
    current = this.stream.get16();

    if (current !== 0xFFD8) { // SOI
        throw new Error("Not a JPEG file");
    }

    current = this.stream.get16();

    while ((((current >> 4) !== 0x0FFC) || (current === 0xFFC4))) { // SOF 0~15
        switch (current) {
            case 0xFFC4: // DHT
                this.huffTable.read(this.stream, this.HuffTab);
                break;
            case 0xFFCC: // DAC
                throw new Error("Program doesn't support arithmetic coding. (format throw new IOException)");
            case 0xFFDB:
                this.quantTable.read(this.stream, jpeg.lossless.Decoder.TABLE);
                break;
            case 0xFFDD:
                this.restartInterval = this.readNumber();
                break;
            case 0xFFE0:
            case 0xFFE1:
            case 0xFFE2:
            case 0xFFE3:
            case 0xFFE4:
            case 0xFFE5:
            case 0xFFE6:
            case 0xFFE7:
            case 0xFFE8:
            case 0xFFE9:
            case 0xFFEA:
            case 0xFFEB:
            case 0xFFEC:
            case 0xFFED:
            case 0xFFEE:
            case 0xFFEF:
                this.readApp();
                break;
            case 0xFFFE:
                this.readComment();
                break;
            default:
                if ((current >> 8) !== 0xFF) {
                    throw new Error("ERROR: format throw new IOException! (decode)");
                }
        }

        current = this.stream.get16();
    }

    if ((current < 0xFFC0) || (current > 0xFFC7)) {
        throw new Error("ERROR: could not handle arithmetic code!");
    }

    this.frame.read(this.stream);
    current = this.stream.get16();

    do {
        while (current !== 0x0FFDA) { // SOS
            switch (current) {
                case 0xFFC4: // DHT
                    this.huffTable.read(this.stream, this.HuffTab);
                    break;
                case 0xFFCC: // DAC
                    throw new Error("Program doesn't support arithmetic coding. (format throw new IOException)");
                case 0xFFDB:
                    this.quantTable.read(this.stream, jpeg.lossless.Decoder.TABLE);
                    break;
                case 0xFFDD:
                    this.restartInterval = this.readNumber();
                    break;
                case 0xFFE0:
                case 0xFFE1:
                case 0xFFE2:
                case 0xFFE3:
                case 0xFFE4:
                case 0xFFE5:
                case 0xFFE6:
                case 0xFFE7:
                case 0xFFE8:
                case 0xFFE9:
                case 0xFFEA:
                case 0xFFEB:
                case 0xFFEC:
                case 0xFFED:
                case 0xFFEE:
                case 0xFFEF:
                    this.readApp();
                    break;
                case 0xFFFE:
                    this.readComment();
                    break;
                default:
                    if ((current >> 8) !== 0xFF) {
                        throw new Error("ERROR: format throw new IOException! (Parser.decode)");
                    }
            }

            current = this.stream.get16();
        }

        this.precision = this.frame.precision;
        this.components = this.frame.components;

        if (!this.numBytes) {
            this.numBytes = parseInt(Math.ceil(this.precision / 8));
        }

        if (this.numBytes == 1) {
            this.mask = 0xFF;
        } else {
            this.mask = 0xFFFF;
        }

        this.scan.read(this.stream);
        this.numComp = this.scan.numComp;
        this.selection = this.scan.selection;

        if (this.numBytes === 1) {
            if (this.numComp === 3) {
                this.getter = this.getValueRGB;
                this.setter = this.setValueRGB;
                this.output = this.outputRGB;
            } else {
                this.getter = this.getValue8;
                this.setter = this.setValue8;
                this.output = this.outputSingle;
            }
        } else {
            this.getter = this.getValue16;
            this.setter = this.setValue16;
            this.output = this.outputSingle;
        }

        switch (this.selection) {
            case 2:
                this.selector = this.select2;
                break;
            case 3:
                this.selector = this.select3;
                break;
            case 4:
                this.selector = this.select4;
                break;
            case 5:
                this.selector = this.select5;
                break;
            case 6:
                this.selector = this.select6;
                break;
            case 7:
                this.selector = this.select7;
                break;
            default:
                this.selector = this.select1;
                break;
        }

        this.scanComps = this.scan.components;
        this.quantTables = this.quantTable.quantTables;

        for (i = 0; i < this.numComp; i+=1) {
            compN = this.scanComps[i].scanCompSel;
            this.qTab[i] = this.quantTables[this.components[compN].quantTableSel];
            this.nBlock[i] = this.components[compN].vSamp * this.components[compN].hSamp;
            this.dcTab[i] = this.HuffTab[this.scanComps[i].dcTabSel][0];
            this.acTab[i] = this.HuffTab[this.scanComps[i].acTabSel][1];
        }

        this.xDim = this.frame.dimX;
        this.yDim = this.frame.dimY;
        if (this.numBytes == 1) {
            this.outputData = new Uint8Array(new ArrayBuffer(this.xDim * this.yDim * this.numBytes * this.numComp));
        } else {
            this.outputData = new Uint16Array(new ArrayBuffer(this.xDim * this.yDim * this.numBytes * this.numComp));
        }

        scanNum+=1;

        while (true) { // Decode one scan
            temp[0] = 0;
            index[0] = 0;

            for (i = 0; i < 10; i+=1) {
                pred[i] = (1 << (this.precision - 1));
            }

            if (this.restartInterval === 0) {
                current = this.decodeUnit(pred, temp, index);

                while ((current === 0) && ((this.xLoc < this.xDim) && (this.yLoc < this.yDim))) {
                    this.output(pred);
                    current = this.decodeUnit(pred, temp, index);
                }

                break; //current=MARKER
            }

            for (mcuNum = 0; mcuNum < this.restartInterval; mcuNum+=1) {
                this.restarting = (mcuNum == 0);
                current = this.decodeUnit(pred, temp, index);
                this.output(pred);

                if (current !== 0) {
                    break;
                }
            }

            if (current === 0) {
                if (this.markerIndex !== 0) {
                    current = (0xFF00 | this.marker);
                    this.markerIndex = 0;
                } else {
                    current = this.stream.get16();
                }
            }

            if (!((current >= jpeg.lossless.Decoder.RESTART_MARKER_BEGIN) &&
                (current <= jpeg.lossless.Decoder.RESTART_MARKER_END))) {
                break; //current=MARKER
            }
        }

        if ((current === 0xFFDC) && (scanNum === 1)) { //DNL
            this.readNumber();
            current = this.stream.get16();
        }
    } while ((current !== 0xFFD9) && ((this.xLoc < this.xDim) && (this.yLoc < this.yDim)) && (scanNum === 0));

    return this.outputData;
};



jpeg.lossless.Decoder.prototype.decodeUnit = function (prev, temp, index) {
    if (this.numComp == 1) {
        return this.decodeSingle(prev, temp, index);
    } else if (this.numComp == 3) {
        return this.decodeRGB(prev, temp, index);
    } else {
        return -1;
    }
};



jpeg.lossless.Decoder.prototype.select1 = function (compOffset) {
    return this.getPreviousX(compOffset);
};



jpeg.lossless.Decoder.prototype.select2 = function (compOffset) {
    return this.getPreviousY(compOffset);
};



jpeg.lossless.Decoder.prototype.select3 = function (compOffset) {
    return this.getPreviousXY(compOffset);
};



jpeg.lossless.Decoder.prototype.select4 = function (compOffset) {
    return (this.getPreviousX(compOffset) + this.getPreviousY(compOffset)) - this.getPreviousXY(compOffset);
};



jpeg.lossless.Decoder.prototype.select5 = function (compOffset) {
    return this.getPreviousX(compOffset) + ((this.getPreviousY(compOffset) - this.getPreviousXY(compOffset)) >> 1);
};



jpeg.lossless.Decoder.prototype.select6 = function (compOffset) {
    return this.getPreviousY(compOffset) + ((this.getPreviousX(compOffset) - this.getPreviousXY(compOffset)) >> 1);
};



jpeg.lossless.Decoder.prototype.select7 = function (compOffset) {
    return ((this.getPreviousX(compOffset) + this.getPreviousY(compOffset)) / 2);
};



jpeg.lossless.Decoder.prototype.decodeRGB = function (prev, temp, index) {
    /*jslint bitwise: true */

    var value, actab, dctab, qtab, ctrC, i, k, j;

    prev[0] = this.selector(0);
    prev[1] = this.selector(1);
    prev[2] = this.selector(2);

    for (ctrC = 0; ctrC < this.numComp; ctrC+=1) {
        qtab = this.qTab[ctrC];
        actab = this.acTab[ctrC];
        dctab = this.dcTab[ctrC];
        for (i = 0; i < this.nBlock[ctrC]; i+=1) {
            for (k = 0; k < this.IDCT_Source.length; k+=1) {
                this.IDCT_Source[k] = 0;
            }

            value = this.getHuffmanValue(dctab, temp, index);

            if (value >= 0xFF00) {
                return value;
            }

            prev[ctrC] = this.IDCT_Source[0] = prev[ctrC] + this.getn(index, value, temp, index);
            this.IDCT_Source[0] *= qtab[0];

            for (j = 1; j < 64; j+=1) {
                value = this.getHuffmanValue(actab, temp, index);

                if (value >= 0xFF00) {
                    return value;
                }

                j += (value >> 4);

                if ((value & 0x0F) === 0) {
                    if ((value >> 4) === 0) {
                        break;
                    }
                } else {
                    this.IDCT_Source[jpeg.lossless.Decoder.IDCT_P[j]] = this.getn(index, value & 0x0F, temp, index) * qtab[j];
                }
            }
        }
    }

    return 0;
};



jpeg.lossless.Decoder.prototype.decodeSingle = function (prev, temp, index) {
    /*jslint bitwise: true */

    var value, i, n, nRestart;

    if (this.restarting) {
        this.restarting = false;
        prev[0] = (1 << (this.frame.precision - 1));
    } else {
        prev[0] = this.selector();
    }

    for (i = 0; i < this.nBlock[0]; i+=1) {
        value = this.getHuffmanValue(this.dcTab[0], temp, index);
        if (value >= 0xFF00) {
            return value;
        }

        n = this.getn(prev, value, temp, index);
        nRestart = (n >> 8);

        if ((nRestart >= jpeg.lossless.Decoder.RESTART_MARKER_BEGIN) && (nRestart <= jpeg.lossless.Decoder.RESTART_MARKER_END)) {
            return nRestart;
        }

        prev[0] += n;
    }

    return 0;
};



//	Huffman table for fast search: (HuffTab) 8-bit Look up table 2-layer search architecture, 1st-layer represent 256 node (8 bits) if codeword-length > 8
//	bits, then the entry of 1st-layer = (# of 2nd-layer table) | MSB and it is stored in the 2nd-layer Size of tables in each layer are 256.
//	HuffTab[*][*][0-256] is always the only 1st-layer table.
//
//	An entry can be: (1) (# of 2nd-layer table) | MSB , for code length > 8 in 1st-layer (2) (Code length) << 8 | HuffVal
//
//	HuffmanValue(table   HuffTab[x][y] (ex) HuffmanValue(HuffTab[1][0],...)
//	                ):
//	    return: Huffman Value of table
//	            0xFF?? if it receives a MARKER
//	    Parameter:  table   HuffTab[x][y] (ex) HuffmanValue(HuffTab[1][0],...)
//	                temp    temp storage for remainded bits
//	                index   index to bit of temp
//	                in      FILE pointer
//	    Effect:
//	        temp  store new remainded bits
//	        index change to new index
//	        in    change to new position
//	    NOTE:
//	      Initial by   temp=0; index=0;
//	    NOTE: (explain temp and index)
//	      temp: is always in the form at calling time or returning time
//	       |  byte 4  |  byte 3  |  byte 2  |  byte 1  |
//	       |     0    |     0    | 00000000 | 00000??? |  if not a MARKER
//	                                               ^index=3 (from 0 to 15)
//	                                               321
//	    NOTE (marker and marker_index):
//	      If get a MARKER from 'in', marker=the low-byte of the MARKER
//	        and marker_index=9
//	      If marker_index=9 then index is always > 8, or HuffmanValue()
//	        will not be called
jpeg.lossless.Decoder.prototype.getHuffmanValue = function (table, temp, index) {
    /*jslint bitwise: true */

    var code, input, mask;
    mask = 0xFFFF;

    if (index[0] < 8) {
        temp[0] <<= 8;
        input = this.stream.get8();
        if (input === 0xFF) {
            this.marker = this.stream.get8();
            if (this.marker !== 0) {
                this.markerIndex = 9;
            }
        }
        temp[0] |= input;
    } else {
        index[0] -= 8;
    }

    code = table[temp[0] >> index[0]];

    if ((code & jpeg.lossless.Decoder.MSB) !== 0) {
        if (this.markerIndex !== 0) {
            this.markerIndex = 0;
            return 0xFF00 | this.marker;
        }

        temp[0] &= (mask >> (16 - index[0]));
        temp[0] <<= 8;
        input = this.stream.get8();

        if (input === 0xFF) {
            this.marker = this.stream.get8();
            if (this.marker !== 0) {
                this.markerIndex = 9;
            }
        }

        temp[0] |= input;
        code = table[((code & 0xFF) * 256) + (temp[0] >> index[0])];
        index[0] += 8;
    }

    index[0] += 8 - (code >> 8);

    if (index[0] < 0) {
        throw new Error("index=" + index[0] + " temp=" + temp[0] + " code=" + code + " in HuffmanValue()");
    }

    if (index[0] < this.markerIndex) {
        this.markerIndex = 0;
        return 0xFF00 | this.marker;
    }

    temp[0] &= (mask >> (16 - index[0]));
    return code & 0xFF;
};



jpeg.lossless.Decoder.prototype.getn = function (PRED, n, temp, index) {
    /*jslint bitwise: true */

    var result, one, n_one, mask, input;
    one = 1;
    n_one = -1;
    mask = 0xFFFF;

    if (n === 0) {
        return 0;
    }

    if (n === 16) {
        if (PRED[0] >= 0) {
            return -32768;
        } else {
            return 32768;
        }
    }

    index[0] -= n;

    if (index[0] >= 0) {
        if ((index[0] < this.markerIndex) && !this.isLastPixel()) { // this was corrupting the last pixel in some cases
            this.markerIndex = 0;
            return (0xFF00 | this.marker) << 8;
        }

        result = temp[0] >> index[0];
        temp[0] &= (mask >> (16 - index[0]));
    } else {
        temp[0] <<= 8;
        input = this.stream.get8();

        if (input === 0xFF) {
            this.marker = this.stream.get8();
            if (this.marker !== 0) {
                this.markerIndex = 9;
            }
        }

        temp[0] |= input;
        index[0] += 8;

        if (index[0] < 0) {
            if (this.markerIndex !== 0) {
                this.markerIndex = 0;
                return (0xFF00 | this.marker) << 8;
            }

            temp[0] <<= 8;
            input = this.stream.get8();

            if (input === 0xFF) {
                this.marker = this.stream.get8();
                if (this.marker !== 0) {
                    this.markerIndex = 9;
                }
            }

            temp[0] |= input;
            index[0] += 8;
        }

        if (index[0] < 0) {
            throw new Error("index=" + index[0] + " in getn()");
        }

        if (index[0] < this.markerIndex) {
            this.markerIndex = 0;
            return (0xFF00 | this.marker) << 8;
        }

        result = temp[0] >> index[0];
        temp[0] &= (mask >> (16 - index[0]));
    }

    if (result < (one << (n - 1))) {
        result += (n_one << n) + 1;
    }

    return result;
};



jpeg.lossless.Decoder.prototype.getPreviousX = function (compOffset) {
    /*jslint bitwise: true */

    if (this.xLoc > 0) {
        return this.getter((((this.yLoc * this.xDim) + this.xLoc) - 1), compOffset);
    } else if (this.yLoc > 0) {
        return this.getPreviousY(compOffset);
    } else {
        return (1 << (this.frame.precision - 1));
    }
};



jpeg.lossless.Decoder.prototype.getPreviousXY = function (compOffset) {
    /*jslint bitwise: true */

    if ((this.xLoc > 0) && (this.yLoc > 0)) {
        return this.getter(((((this.yLoc - 1) * this.xDim) + this.xLoc) - 1), compOffset);
    } else {
        return this.getPreviousY(compOffset);
    }
};



jpeg.lossless.Decoder.prototype.getPreviousY = function (compOffset) {
    /*jslint bitwise: true */

    if (this.yLoc > 0) {
        return this.getter((((this.yLoc - 1) * this.xDim) + this.xLoc), compOffset);
    } else {
        return this.getPreviousX(compOffset);
    }
};



jpeg.lossless.Decoder.prototype.isLastPixel = function () {
    return (this.xLoc === (this.xDim - 1)) && (this.yLoc === (this.yDim - 1));
};



jpeg.lossless.Decoder.prototype.outputSingle = function (PRED) {
    if ((this.xLoc < this.xDim) && (this.yLoc < this.yDim)) {
        this.setter((((this.yLoc * this.xDim) + this.xLoc)), this.mask & PRED[0]);

        this.xLoc+=1;

        if (this.xLoc >= this.xDim) {
            this.yLoc+=1;
            this.xLoc = 0;
        }
    }
};



jpeg.lossless.Decoder.prototype.outputRGB = function (PRED) {
    var offset = ((this.yLoc * this.xDim) + this.xLoc);

    if ((this.xLoc < this.xDim) && (this.yLoc < this.yDim)) {
        this.setter(offset, PRED[0], 0);
        this.setter(offset, PRED[1], 1);
        this.setter(offset, PRED[2], 2);

        this.xLoc+=1;

        if (this.xLoc >= this.xDim) {
            this.yLoc+=1;
            this.xLoc = 0;
        }
    }
};

jpeg.lossless.Decoder.prototype.setValue8 = function (index, val) {
    this.outputData[index] = val; 
};

jpeg.lossless.Decoder.prototype.getValue8 = function (index) {
    return this.outputData[index]; // mask should not be necessary because outputData is either Int8Array or Int16Array
};

var littleEndian = (function() {
    var buffer = new ArrayBuffer(2);
    new DataView(buffer).setInt16(0, 256, true /* littleEndian */);
    // Int16Array uses the platform's endianness.
    return new Int16Array(buffer)[0] === 256;
})();

if (littleEndian) {
    // just reading from an array is fine then. Int16Array will use platform endianness.
    jpeg.lossless.Decoder.prototype.setValue16 = jpeg.lossless.Decoder.prototype.setValue8; 
    jpeg.lossless.Decoder.prototype.getValue16 = jpeg.lossless.Decoder.prototype.getValue8;
} 
else {
    // If platform is big-endian, we will need to convert to little-endian 
    jpeg.lossless.Decoder.prototype.setValue16 = function (index, val) {
        this.outputData[index] = ((val & 0xFF) << 8) | ((val >> 8) & 0xFF); 
    };

    jpeg.lossless.Decoder.prototype.getValue16 = function (index) {
        var val = this.outputData[index];
        return ((val & 0xFF) << 8) | ((val >> 8) & 0xFF);
    };
}

jpeg.lossless.Decoder.prototype.setValueRGB = function (index, val, compOffset) {
    // this.outputData.setUint8(index * 3 + compOffset, val);
    this.outputData[index * 3 + compOffset] = val;
};

jpeg.lossless.Decoder.prototype.getValueRGB = function (index, compOffset) {
    // return this.outputData.getUint8(index * 3 + compOffset);
    return this.outputData[index * 3 + compOffset];
};



jpeg.lossless.Decoder.prototype.readApp = function() {
    var count = 0, length = this.stream.get16();
    count += 2;

    while (count < length) {
        this.stream.get8();
        count+=1;
    }

    return length;
};



jpeg.lossless.Decoder.prototype.readComment = function () {
    var sb = "", count = 0, length;

    length = this.stream.get16();
    count += 2;

    while (count < length) {
        sb += this.stream.get8();
        count+=1;
    }

    return sb;
};



jpeg.lossless.Decoder.prototype.readNumber = function() {
    var Ld = this.stream.get16();

    if (Ld !== 4) {
        throw new Error("ERROR: Define number format throw new IOException [Ld!=4]");
    }

    return this.stream.get16();
};



/*** Exports ***/

var moduleType = typeof module;
if ((moduleType !== 'undefined') && module.exports) {
    module.exports = jpeg.lossless.Decoder;
}

},{"./data-stream.js":2,"./frame-header.js":4,"./huffman-table.js":5,"./quantization-table.js":7,"./scan-header.js":9,"./utils.js":10}],4:[function(require,module,exports){
/*
 * Copyright (C) 2015 Michael Martinez
 * Changes: Added support for selection values 2-7, fixed minor bugs &
 * warnings, split into multiple class files, and general clean up.
 *
 * 08-25-2015: Helmut Dersch agreed to a license change from LGPL to MIT.
 */

/*
 * Copyright (C) Helmut Dersch
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/*jslint browser: true, node: true */
/*global require, module */



/*** Imports ***/
var jpeg = jpeg || {};
jpeg.lossless = jpeg.lossless || {};
jpeg.lossless.ComponentSpec = jpeg.lossless.ComponentSpec || ((typeof require !== 'undefined') ? require('./component-spec.js') : null);
jpeg.lossless.DataStream = jpeg.lossless.DataStream || ((typeof require !== 'undefined') ? require('./data-stream.js') : null);


/*** Constructor ***/
jpeg.lossless.FrameHeader = jpeg.lossless.FrameHeader || function () {
    this.components = []; // Components
    this.dimX = 0; // Number of samples per line
    this.dimY = 0; // Number of lines
    this.numComp = 0; // Number of component in the frame
    this.precision = 0; // Sample Precision (from the original image)
};



/*** Prototype Methods ***/

jpeg.lossless.FrameHeader.prototype.read = function (data) {
    /*jslint bitwise: true */

    var count = 0, length, i, c, temp;

    length = data.get16();
    count += 2;

    this.precision = data.get8();
    count+=1;

    this.dimY = data.get16();
    count += 2;

    this.dimX = data.get16();
    count += 2;

    this.numComp = data.get8();
    count+=1;
    for (i = 1; i <= this.numComp; i+=1) {
        if (count > length) {
            throw new Error("ERROR: frame format error");
        }

        c = data.get8();
        count+=1;

        if (count >= length) {
            throw new Error("ERROR: frame format error [c>=Lf]");
        }

        temp = data.get8();
        count+=1;

        if (!this.components[c]) {
            this.components[c] = new jpeg.lossless.ComponentSpec();
        }

        this.components[c].hSamp = temp >> 4;
        this.components[c].vSamp = temp & 0x0F;
        this.components[c].quantTableSel = data.get8();
        count+=1;
    }

    if (count !== length) {
        throw new Error("ERROR: frame format error [Lf!=count]");
    }

    return 1;
};


/*** Exports ***/

var moduleType = typeof module;
if ((moduleType !== 'undefined') && module.exports) {
    module.exports = jpeg.lossless.FrameHeader;
}

},{"./component-spec.js":1,"./data-stream.js":2}],5:[function(require,module,exports){
/*
 * Copyright (C) 2015 Michael Martinez
 * Changes: Added support for selection values 2-7, fixed minor bugs &
 * warnings, split into multiple class files, and general clean up.
 *
 * 08-25-2015: Helmut Dersch agreed to a license change from LGPL to MIT.
 */

/*
 * Copyright (C) Helmut Dersch
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/*jslint browser: true, node: true */
/*global require, module */



/*** Imports ***/
var jpeg = jpeg || {};
jpeg.lossless = jpeg.lossless || {};
jpeg.lossless.DataStream = jpeg.lossless.DataStream || ((typeof require !== 'undefined') ? require('./data-stream.js') : null);
jpeg.lossless.Utils = jpeg.lossless.Utils || ((typeof require !== 'undefined') ? require('./utils.js') : null);


/*** Constructor ***/
jpeg.lossless.HuffmanTable = jpeg.lossless.HuffmanTable || function () {
    this.l = jpeg.lossless.Utils.createArray(4, 2, 16);
    this.th = [];
    this.v = jpeg.lossless.Utils.createArray(4, 2, 16, 200);
    this.tc = jpeg.lossless.Utils.createArray(4, 2);

    this.tc[0][0] = 0;
    this.tc[1][0] = 0;
    this.tc[2][0] = 0;
    this.tc[3][0] = 0;
    this.tc[0][1] = 0;
    this.tc[1][1] = 0;
    this.tc[2][1] = 0;
    this.tc[3][1] = 0;
    this.th[0] = 0;
    this.th[1] = 0;
    this.th[2] = 0;
    this.th[3] = 0;
};



/*** Static Pseudo-constants ***/

jpeg.lossless.HuffmanTable.MSB = 0x80000000;


/*** Prototype Methods ***/

jpeg.lossless.HuffmanTable.prototype.read = function(data, HuffTab) {
    /*jslint bitwise: true */

    var count = 0, length, temp, t, c, i, j;

    length = data.get16();
    count += 2;

    while (count < length) {
        temp = data.get8();
        count+=1;
        t = temp & 0x0F;
        if (t > 3) {
            throw new Error("ERROR: Huffman table ID > 3");
        }

        c = temp >> 4;
        if (c > 2) {
            throw new Error("ERROR: Huffman table [Table class > 2 ]");
        }

        this.th[t] = 1;
        this.tc[t][c] = 1;

        for (i = 0; i < 16; i+=1) {
            this.l[t][c][i] = data.get8();
            count+=1;
        }

        for (i = 0; i < 16; i+=1) {
            for (j = 0; j < this.l[t][c][i]; j+=1) {
                if (count > length) {
                    throw new Error("ERROR: Huffman table format error [count>Lh]");
                }

                this.v[t][c][i][j] = data.get8();
                count+=1;
            }
        }
    }

    if (count !== length) {
        throw new Error("ERROR: Huffman table format error [count!=Lf]");
    }

    for (i = 0; i < 4; i+=1) {
        for (j = 0; j < 2; j+=1) {
            if (this.tc[i][j] !== 0) {
                this.buildHuffTable(HuffTab[i][j], this.l[i][j], this.v[i][j]);
            }
        }
    }

    return 1;
};



//	Build_HuffTab()
//	Parameter:  t       table ID
//	            c       table class ( 0 for DC, 1 for AC )
//	            L[i]    # of codewords which length is i
//	            V[i][j] Huffman Value (length=i)
//	Effect:
//	    build up HuffTab[t][c] using L and V.
jpeg.lossless.HuffmanTable.prototype.buildHuffTable = function(tab, L, V) {
    /*jslint bitwise: true */

    var currentTable, temp, k, i, j, n;
    temp = 256;
    k = 0;

    for (i = 0; i < 8; i+=1) { // i+1 is Code length
        for (j = 0; j < L[i]; j+=1) {
            for (n = 0; n < (temp >> (i + 1)); n+=1) {
                tab[k] = V[i][j] | ((i + 1) << 8);
                k+=1;
            }
        }
    }

    for (i = 1; k < 256; i+=1, k+=1) {
        tab[k] = i | jpeg.lossless.HuffmanTable.MSB;
    }

    currentTable = 1;
    k = 0;

    for (i = 8; i < 16; i+=1) { // i+1 is Code length
        for (j = 0; j < L[i]; j+=1) {
            for (n = 0; n < (temp >> (i - 7)); n+=1) {
                tab[(currentTable * 256) + k] = V[i][j] | ((i + 1) << 8);
                k+=1;
            }

            if (k >= 256) {
                if (k > 256) {
                    throw new Error("ERROR: Huffman table error(1)!");
                }

                k = 0;
                currentTable+=1;
            }
        }
    }
};


/*** Exports ***/

var moduleType = typeof module;
if ((moduleType !== 'undefined') && module.exports) {
    module.exports = jpeg.lossless.HuffmanTable;
}

},{"./data-stream.js":2,"./utils.js":10}],6:[function(require,module,exports){
/*jslint browser: true, node: true */
/*global require, module */



/*** Imports ****/

/**
 * jpeg
  * @type {*|{}}
 */
var jpeg = jpeg || {};

/**
 * jpeg.lossless
 * @type {*|{}}
 */
jpeg.lossless = jpeg.lossless || {};


jpeg.lossless.ComponentSpec = jpeg.lossless.ComponentSpec || ((typeof require !== 'undefined') ? require('./component-spec.js') : null);
jpeg.lossless.DataStream = jpeg.lossless.DataStream || ((typeof require !== 'undefined') ? require('./data-stream.js') : null);
jpeg.lossless.Decoder = jpeg.lossless.Decoder || ((typeof require !== 'undefined') ? require('./decoder.js') : null);
jpeg.lossless.FrameHeader = jpeg.lossless.FrameHeader || ((typeof require !== 'undefined') ? require('./frame-header.js') : null);
jpeg.lossless.HuffmanTable = jpeg.lossless.HuffmanTable || ((typeof require !== 'undefined') ? require('./huffman-table.js') : null);
jpeg.lossless.QuantizationTable = jpeg.lossless.QuantizationTable || ((typeof require !== 'undefined') ? require('./quantization-table.js') : null);
jpeg.lossless.ScanComponent = jpeg.lossless.ScanComponent || ((typeof require !== 'undefined') ? require('./scan-component.js') : null);
jpeg.lossless.ScanHeader = jpeg.lossless.ScanHeader || ((typeof require !== 'undefined') ? require('./scan-header.js') : null);
jpeg.lossless.Utils = jpeg.lossless.Utils || ((typeof require !== 'undefined') ? require('./utils.js') : null);


/*** Exports ***/
var moduleType = typeof module;
if ((moduleType !== 'undefined') && module.exports) {
    module.exports = jpeg;
}

},{"./component-spec.js":1,"./data-stream.js":2,"./decoder.js":3,"./frame-header.js":4,"./huffman-table.js":5,"./quantization-table.js":7,"./scan-component.js":8,"./scan-header.js":9,"./utils.js":10}],7:[function(require,module,exports){
/*
 * Copyright (C) 2015 Michael Martinez
 * Changes: Added support for selection values 2-7, fixed minor bugs &
 * warnings, split into multiple class files, and general clean up.
 *
 * 08-25-2015: Helmut Dersch agreed to a license change from LGPL to MIT.
 */

/*
 * Copyright (C) Helmut Dersch
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/*jslint browser: true, node: true */
/*global require, module */



/*** Imports ***/
var jpeg = jpeg || {};
jpeg.lossless = jpeg.lossless || {};
jpeg.lossless.DataStream = jpeg.lossless.DataStream || ((typeof require !== 'undefined') ? require('./data-stream.js') : null);
jpeg.lossless.Utils = jpeg.lossless.Utils || ((typeof require !== 'undefined') ? require('./utils.js') : null);


/*** Constructor ***/
jpeg.lossless.QuantizationTable = jpeg.lossless.QuantizationTable || function () {
    this.precision = []; // Quantization precision 8 or 16
    this.tq = []; // 1: this table is presented
    this.quantTables = jpeg.lossless.Utils.createArray(4, 64); // Tables

    this.tq[0] = 0;
    this.tq[1] = 0;
    this.tq[2] = 0;
    this.tq[3] = 0;
};



/*** Static Methods ***/

jpeg.lossless.QuantizationTable.enhanceQuantizationTable = function(qtab, table) {
    /*jslint bitwise: true */

    var i;

    for (i = 0; i < 8; i+=1) {
        qtab[table[(0 * 8) + i]] *= 90;
        qtab[table[(4 * 8) + i]] *= 90;
        qtab[table[(2 * 8) + i]] *= 118;
        qtab[table[(6 * 8) + i]] *= 49;
        qtab[table[(5 * 8) + i]] *= 71;
        qtab[table[(1 * 8) + i]] *= 126;
        qtab[table[(7 * 8) + i]] *= 25;
        qtab[table[(3 * 8) + i]] *= 106;
    }

    for (i = 0; i < 8; i+=1) {
        qtab[table[0 + (8 * i)]] *= 90;
        qtab[table[4 + (8 * i)]] *= 90;
        qtab[table[2 + (8 * i)]] *= 118;
        qtab[table[6 + (8 * i)]] *= 49;
        qtab[table[5 + (8 * i)]] *= 71;
        qtab[table[1 + (8 * i)]] *= 126;
        qtab[table[7 + (8 * i)]] *= 25;
        qtab[table[3 + (8 * i)]] *= 106;
    }

    for (i = 0; i < 64; i+=1) {
        qtab[i] >>= 6;
    }
};


/*** Prototype Methods ***/

jpeg.lossless.QuantizationTable.prototype.read = function (data, table) {
    /*jslint bitwise: true */

    var count = 0, length, temp, t, i;

    length = data.get16();
    count += 2;

    while (count < length) {
        temp = data.get8();
        count+=1;
        t = temp & 0x0F;

        if (t > 3) {
            throw new Error("ERROR: Quantization table ID > 3");
        }

        this.precision[t] = temp >> 4;

        if (this.precision[t] === 0) {
            this.precision[t] = 8;
        } else if (this.precision[t] === 1) {
            this.precision[t] = 16;
        } else {
            throw new Error("ERROR: Quantization table precision error");
        }

        this.tq[t] = 1;

        if (this.precision[t] === 8) {
            for (i = 0; i < 64; i+=1) {
                if (count > length) {
                    throw new Error("ERROR: Quantization table format error");
                }

                this.quantTables[t][i] = data.get8();
                count+=1;
            }

            jpeg.lossless.QuantizationTable.enhanceQuantizationTable(this.quantTables[t], table);
        } else {
            for (i = 0; i < 64; i+=1) {
                if (count > length) {
                    throw new Error("ERROR: Quantization table format error");
                }

                this.quantTables[t][i] = data.get16();
                count += 2;
            }

            jpeg.lossless.QuantizationTable.enhanceQuantizationTable(this.quantTables[t], table);
        }
    }

    if (count !== length) {
        throw new Error("ERROR: Quantization table error [count!=Lq]");
    }

    return 1;
};



/*** Exports ***/

var moduleType = typeof module;
if ((moduleType !== 'undefined') && module.exports) {
    module.exports = jpeg.lossless.QuantizationTable;
}

},{"./data-stream.js":2,"./utils.js":10}],8:[function(require,module,exports){
/*
 * Copyright (C) 2015 Michael Martinez
 * Changes: Added support for selection values 2-7, fixed minor bugs &
 * warnings, split into multiple class files, and general clean up.
 *
 * 08-25-2015: Helmut Dersch agreed to a license change from LGPL to MIT.
 */

/*
 * Copyright (C) Helmut Dersch
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/*jslint browser: true, node: true */
/*global require, module */



/*** Imports ***/
var jpeg = jpeg || {};
jpeg.lossless = jpeg.lossless || {};


/*** Constructor ***/
jpeg.lossless.ScanComponent = jpeg.lossless.ScanComponent || function () {
    this.acTabSel = 0; // AC table selector
    this.dcTabSel = 0; // DC table selector
    this.scanCompSel = 0; // Scan component selector
};



/*** Exports ***/

var moduleType = typeof module;
if ((moduleType !== 'undefined') && module.exports) {
    module.exports = jpeg.lossless.ScanComponent;
}

},{}],9:[function(require,module,exports){
/*
 * Copyright (C) 2015 Michael Martinez
 * Changes: Added support for selection values 2-7, fixed minor bugs &
 * warnings, split into multiple class files, and general clean up.
 *
 * 08-25-2015: Helmut Dersch agreed to a license change from LGPL to MIT.
 */

/*
 * Copyright (C) Helmut Dersch
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/*jslint browser: true, node: true */
/*global require, module */



/*** Imports ***/
var jpeg = jpeg || {};
jpeg.lossless = jpeg.lossless || {};
jpeg.lossless.DataStream = jpeg.lossless.DataStream || ((typeof require !== 'undefined') ? require('./data-stream.js') : null);
jpeg.lossless.ScanComponent = jpeg.lossless.ScanComponent || ((typeof require !== 'undefined') ? require('./scan-component.js') : null);


/*** Constructor ***/
jpeg.lossless.ScanHeader = jpeg.lossless.ScanHeader || function () {
    this.ah = 0;
    this.al = 0;
    this.numComp = 0; // Number of components in the scan
    this.selection = 0; // Start of spectral or predictor selection
    this.spectralEnd = 0; // End of spectral selection
    this.components = [];
};


/*** Prototype Methods ***/

jpeg.lossless.ScanHeader.prototype.read = function(data) {
    /*jslint bitwise: true */

    var count = 0, length, i, temp;

    length = data.get16();
    count += 2;

    this.numComp = data.get8();
    count+=1;

    for (i = 0; i < this.numComp; i+=1) {
        this.components[i] = new jpeg.lossless.ScanComponent();

        if (count > length) {
            throw new Error("ERROR: scan header format error");
        }

        this.components[i].scanCompSel = data.get8();
        count+=1;

        temp = data.get8();
        count+=1;

        this.components[i].dcTabSel = (temp >> 4);
        this.components[i].acTabSel = (temp & 0x0F);
    }

    this.selection = data.get8();
    count+=1;

    this.spectralEnd = data.get8();
    count+=1;

    temp = data.get8();
    this.ah = (temp >> 4);
    this.al = (temp & 0x0F);
    count+=1;

    if (count !== length) {
        throw new Error("ERROR: scan header format error [count!=Ns]");
    }

    return 1;
};



/*** Exports ***/

var moduleType = typeof module;
if ((moduleType !== 'undefined') && module.exports) {
    module.exports = jpeg.lossless.ScanHeader;
}

},{"./data-stream.js":2,"./scan-component.js":8}],10:[function(require,module,exports){
/*
 * Copyright (C) 2015 Michael Martinez
 * Changes: Added support for selection values 2-7, fixed minor bugs &
 * warnings, split into multiple class files, and general clean up.
 *
 * 08-25-2015: Helmut Dersch agreed to a license change from LGPL to MIT.
 */

/*
 * Copyright (C) Helmut Dersch
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:

 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/*jslint browser: true, node: true */
/*global require, module */



/*** Imports ***/
var jpeg = jpeg || {};
jpeg.lossless = jpeg.lossless || {};


/*** Constructor ***/
jpeg.lossless.Utils = jpeg.lossless.Utils || {};


/*** Static methods ***/

// http://stackoverflow.com/questions/966225/how-can-i-create-a-two-dimensional-array-in-javascript
jpeg.lossless.Utils.createArray = function (length) {
    var arr = new Array(length || 0),
        i = length;

    if (arguments.length > 1) {
        var args = Array.prototype.slice.call(arguments, 1);
        while(i--) arr[length-1 - i] = jpeg.lossless.Utils.createArray.apply(this, args);
    }

    return arr;
};


// http://stackoverflow.com/questions/18638900/javascript-crc32
jpeg.lossless.Utils.makeCRCTable = function(){
    var c;
    var crcTable = [];
    for(var n =0; n < 256; n++){
        c = n;
        for(var k =0; k < 8; k++){
            c = ((c&1) ? (0xEDB88320 ^ (c >>> 1)) : (c >>> 1));
        }
        crcTable[n] = c;
    }
    return crcTable;
};

jpeg.lossless.Utils.crc32 = function(dataView) {
    var uint8view = new Uint8Array(dataView.buffer);
    var crcTable = jpeg.lossless.Utils.crcTable || (jpeg.lossless.Utils.crcTable = jpeg.lossless.Utils.makeCRCTable());
    var crc = 0 ^ (-1);

    for (var i = 0; i < uint8view.length; i++ ) {
        crc = (crc >>> 8) ^ crcTable[(crc ^ uint8view[i]) & 0xFF];
    }

    return (crc ^ (-1)) >>> 0;
};


/*** Exports ***/

var moduleType = typeof module;
if ((moduleType !== 'undefined') && module.exports) {
    module.exports = jpeg.lossless.Utils;
}

},{}]},{},[6])(6)
});

define('jpegLossless', ['jpegLossless/release/current/lossless'], function (main) { return main; });

var CharLS = function(Module) {
  Module = Module || {};

var Module;if(!Module)Module=(typeof CharLS!=="undefined"?CharLS:null)||{};var moduleOverrides={};for(var key in Module){if(Module.hasOwnProperty(key)){moduleOverrides[key]=Module[key]}}var ENVIRONMENT_IS_WEB=typeof window==="object";var ENVIRONMENT_IS_WORKER=typeof importScripts==="function";var ENVIRONMENT_IS_NODE=typeof process==="object"&&typeof require==="function"&&!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_WORKER;var ENVIRONMENT_IS_SHELL=!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_NODE&&!ENVIRONMENT_IS_WORKER;if(ENVIRONMENT_IS_NODE){if(!Module["print"])Module["print"]=function print(x){process["stdout"].write(x+"\n")};if(!Module["printErr"])Module["printErr"]=function printErr(x){process["stderr"].write(x+"\n")};var nodeFS=require("fs");var nodePath=require("path");Module["read"]=function read(filename,binary){filename=nodePath["normalize"](filename);var ret=nodeFS["readFileSync"](filename);if(!ret&&filename!=nodePath["resolve"](filename)){filename=path.join(__dirname,"..","src",filename);ret=nodeFS["readFileSync"](filename)}if(ret&&!binary)ret=ret.toString();return ret};Module["readBinary"]=function readBinary(filename){var ret=Module["read"](filename,true);if(!ret.buffer){ret=new Uint8Array(ret)}assert(ret.buffer);return ret};Module["load"]=function load(f){globalEval(read(f))};if(!Module["thisProgram"]){if(process["argv"].length>1){Module["thisProgram"]=process["argv"][1].replace(/\\/g,"/")}else{Module["thisProgram"]="unknown-program"}}Module["arguments"]=process["argv"].slice(2);if(typeof module!=="undefined"){module["exports"]=Module}process["on"]("uncaughtException",(function(ex){if(!(ex instanceof ExitStatus)){throw ex}}));Module["inspect"]=(function(){return"[Emscripten Module object]"})}else if(ENVIRONMENT_IS_SHELL){if(!Module["print"])Module["print"]=print;if(typeof printErr!="undefined")Module["printErr"]=printErr;if(typeof read!="undefined"){Module["read"]=read}else{Module["read"]=function read(){throw"no read() available (jsc?)"}}Module["readBinary"]=function readBinary(f){if(typeof readbuffer==="function"){return new Uint8Array(readbuffer(f))}var data=read(f,"binary");assert(typeof data==="object");return data};if(typeof scriptArgs!="undefined"){Module["arguments"]=scriptArgs}else if(typeof arguments!="undefined"){Module["arguments"]=arguments}}else if(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER){Module["read"]=function read(url){var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.send(null);return xhr.responseText};if(typeof arguments!="undefined"){Module["arguments"]=arguments}if(typeof console!=="undefined"){if(!Module["print"])Module["print"]=function print(x){console.log(x)};if(!Module["printErr"])Module["printErr"]=function printErr(x){console.log(x)}}else{var TRY_USE_DUMP=false;if(!Module["print"])Module["print"]=TRY_USE_DUMP&&typeof dump!=="undefined"?(function(x){dump(x)}):(function(x){})}if(ENVIRONMENT_IS_WORKER){Module["load"]=importScripts}if(typeof Module["setWindowTitle"]==="undefined"){Module["setWindowTitle"]=(function(title){document.title=title})}}else{throw"Unknown runtime environment. Where are we?"}function globalEval(x){eval.call(null,x)}if(!Module["load"]&&Module["read"]){Module["load"]=function load(f){globalEval(Module["read"](f))}}if(!Module["print"]){Module["print"]=(function(){})}if(!Module["printErr"]){Module["printErr"]=Module["print"]}if(!Module["arguments"]){Module["arguments"]=[]}if(!Module["thisProgram"]){Module["thisProgram"]="./this.program"}Module.print=Module["print"];Module.printErr=Module["printErr"];Module["preRun"]=[];Module["postRun"]=[];for(var key in moduleOverrides){if(moduleOverrides.hasOwnProperty(key)){Module[key]=moduleOverrides[key]}}var Runtime={setTempRet0:(function(value){tempRet0=value}),getTempRet0:(function(){return tempRet0}),stackSave:(function(){return STACKTOP}),stackRestore:(function(stackTop){STACKTOP=stackTop}),getNativeTypeSize:(function(type){switch(type){case"i1":case"i8":return 1;case"i16":return 2;case"i32":return 4;case"i64":return 8;case"float":return 4;case"double":return 8;default:{if(type[type.length-1]==="*"){return Runtime.QUANTUM_SIZE}else if(type[0]==="i"){var bits=parseInt(type.substr(1));assert(bits%8===0);return bits/8}else{return 0}}}}),getNativeFieldSize:(function(type){return Math.max(Runtime.getNativeTypeSize(type),Runtime.QUANTUM_SIZE)}),STACK_ALIGN:16,prepVararg:(function(ptr,type){if(type==="double"||type==="i64"){if(ptr&7){assert((ptr&7)===4);ptr+=4}}else{assert((ptr&3)===0)}return ptr}),getAlignSize:(function(type,size,vararg){if(!vararg&&(type=="i64"||type=="double"))return 8;if(!type)return Math.min(size,8);return Math.min(size||(type?Runtime.getNativeFieldSize(type):0),Runtime.QUANTUM_SIZE)}),dynCall:(function(sig,ptr,args){if(args&&args.length){if(!args.splice)args=Array.prototype.slice.call(args);args.splice(0,0,ptr);return Module["dynCall_"+sig].apply(null,args)}else{return Module["dynCall_"+sig].call(null,ptr)}}),functionPointers:[],addFunction:(function(func){for(var i=0;i<Runtime.functionPointers.length;i++){if(!Runtime.functionPointers[i]){Runtime.functionPointers[i]=func;return 2*(1+i)}}throw"Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS."}),removeFunction:(function(index){Runtime.functionPointers[(index-2)/2]=null}),warnOnce:(function(text){if(!Runtime.warnOnce.shown)Runtime.warnOnce.shown={};if(!Runtime.warnOnce.shown[text]){Runtime.warnOnce.shown[text]=1;Module.printErr(text)}}),funcWrappers:{},getFuncWrapper:(function(func,sig){assert(sig);if(!Runtime.funcWrappers[sig]){Runtime.funcWrappers[sig]={}}var sigCache=Runtime.funcWrappers[sig];if(!sigCache[func]){sigCache[func]=function dynCall_wrapper(){return Runtime.dynCall(sig,func,arguments)}}return sigCache[func]}),getCompilerSetting:(function(name){throw"You must build with -s RETAIN_COMPILER_SETTINGS=1 for Runtime.getCompilerSetting or emscripten_get_compiler_setting to work"}),stackAlloc:(function(size){var ret=STACKTOP;STACKTOP=STACKTOP+size|0;STACKTOP=STACKTOP+15&-16;return ret}),staticAlloc:(function(size){var ret=STATICTOP;STATICTOP=STATICTOP+size|0;STATICTOP=STATICTOP+15&-16;return ret}),dynamicAlloc:(function(size){var ret=DYNAMICTOP;DYNAMICTOP=DYNAMICTOP+size|0;DYNAMICTOP=DYNAMICTOP+15&-16;if(DYNAMICTOP>=TOTAL_MEMORY){var success=enlargeMemory();if(!success){DYNAMICTOP=ret;return 0}}return ret}),alignMemory:(function(size,quantum){var ret=size=Math.ceil(size/(quantum?quantum:16))*(quantum?quantum:16);return ret}),makeBigInt:(function(low,high,unsigned){var ret=unsigned?+(low>>>0)+ +(high>>>0)*+4294967296:+(low>>>0)+ +(high|0)*+4294967296;return ret}),GLOBAL_BASE:8,QUANTUM_SIZE:4,__dummy__:0};Module["Runtime"]=Runtime;var __THREW__=0;var ABORT=false;var EXITSTATUS=0;var undef=0;var tempValue,tempInt,tempBigInt,tempInt2,tempBigInt2,tempPair,tempBigIntI,tempBigIntR,tempBigIntS,tempBigIntP,tempBigIntD,tempDouble,tempFloat;var tempI64,tempI64b;var tempRet0,tempRet1,tempRet2,tempRet3,tempRet4,tempRet5,tempRet6,tempRet7,tempRet8,tempRet9;function assert(condition,text){if(!condition){abort("Assertion failed: "+text)}}var globalScope=this;function getCFunc(ident){var func=Module["_"+ident];if(!func){try{func=eval("_"+ident)}catch(e){}}assert(func,"Cannot call unknown function "+ident+" (perhaps LLVM optimizations or closure removed it?)");return func}var cwrap,ccall;((function(){var JSfuncs={"stackSave":(function(){Runtime.stackSave()}),"stackRestore":(function(){Runtime.stackRestore()}),"arrayToC":(function(arr){var ret=Runtime.stackAlloc(arr.length);writeArrayToMemory(arr,ret);return ret}),"stringToC":(function(str){var ret=0;if(str!==null&&str!==undefined&&str!==0){ret=Runtime.stackAlloc((str.length<<2)+1);writeStringToMemory(str,ret)}return ret})};var toC={"string":JSfuncs["stringToC"],"array":JSfuncs["arrayToC"]};ccall=function ccallFunc(ident,returnType,argTypes,args,opts){var func=getCFunc(ident);var cArgs=[];var stack=0;if(args){for(var i=0;i<args.length;i++){var converter=toC[argTypes[i]];if(converter){if(stack===0)stack=Runtime.stackSave();cArgs[i]=converter(args[i])}else{cArgs[i]=args[i]}}}var ret=func.apply(null,cArgs);if(returnType==="string")ret=Pointer_stringify(ret);if(stack!==0){if(opts&&opts.async){EmterpreterAsync.asyncFinalizers.push((function(){Runtime.stackRestore(stack)}));return}Runtime.stackRestore(stack)}return ret};var sourceRegex=/^function\s*\(([^)]*)\)\s*{\s*([^*]*?)[\s;]*(?:return\s*(.*?)[;\s]*)?}$/;function parseJSFunc(jsfunc){var parsed=jsfunc.toString().match(sourceRegex).slice(1);return{arguments:parsed[0],body:parsed[1],returnValue:parsed[2]}}var JSsource={};for(var fun in JSfuncs){if(JSfuncs.hasOwnProperty(fun)){JSsource[fun]=parseJSFunc(JSfuncs[fun])}}cwrap=function cwrap(ident,returnType,argTypes){argTypes=argTypes||[];var cfunc=getCFunc(ident);var numericArgs=argTypes.every((function(type){return type==="number"}));var numericRet=returnType!=="string";if(numericRet&&numericArgs){return cfunc}var argNames=argTypes.map((function(x,i){return"$"+i}));var funcstr="(function("+argNames.join(",")+") {";var nargs=argTypes.length;if(!numericArgs){funcstr+="var stack = "+JSsource["stackSave"].body+";";for(var i=0;i<nargs;i++){var arg=argNames[i],type=argTypes[i];if(type==="number")continue;var convertCode=JSsource[type+"ToC"];funcstr+="var "+convertCode.arguments+" = "+arg+";";funcstr+=convertCode.body+";";funcstr+=arg+"="+convertCode.returnValue+";"}}var cfuncname=parseJSFunc((function(){return cfunc})).returnValue;funcstr+="var ret = "+cfuncname+"("+argNames.join(",")+");";if(!numericRet){var strgfy=parseJSFunc((function(){return Pointer_stringify})).returnValue;funcstr+="ret = "+strgfy+"(ret);"}if(!numericArgs){funcstr+=JSsource["stackRestore"].body.replace("()","(stack)")+";"}funcstr+="return ret})";return eval(funcstr)}}))();Module["ccall"]=ccall;Module["cwrap"]=cwrap;function setValue(ptr,value,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":HEAP8[ptr>>0]=value;break;case"i8":HEAP8[ptr>>0]=value;break;case"i16":HEAP16[ptr>>1]=value;break;case"i32":HEAP32[ptr>>2]=value;break;case"i64":tempI64=[value>>>0,(tempDouble=value,+Math_abs(tempDouble)>=+1?tempDouble>+0?(Math_min(+Math_floor(tempDouble/+4294967296),+4294967295)|0)>>>0:~~+Math_ceil((tempDouble- +(~~tempDouble>>>0))/+4294967296)>>>0:0)],HEAP32[ptr>>2]=tempI64[0],HEAP32[ptr+4>>2]=tempI64[1];break;case"float":HEAPF32[ptr>>2]=value;break;case"double":HEAPF64[ptr>>3]=value;break;default:abort("invalid type for setValue: "+type)}}Module["setValue"]=setValue;function getValue(ptr,type,noSafe){type=type||"i8";if(type.charAt(type.length-1)==="*")type="i32";switch(type){case"i1":return HEAP8[ptr>>0];case"i8":return HEAP8[ptr>>0];case"i16":return HEAP16[ptr>>1];case"i32":return HEAP32[ptr>>2];case"i64":return HEAP32[ptr>>2];case"float":return HEAPF32[ptr>>2];case"double":return HEAPF64[ptr>>3];default:abort("invalid type for setValue: "+type)}return null}Module["getValue"]=getValue;var ALLOC_NORMAL=0;var ALLOC_STACK=1;var ALLOC_STATIC=2;var ALLOC_DYNAMIC=3;var ALLOC_NONE=4;Module["ALLOC_NORMAL"]=ALLOC_NORMAL;Module["ALLOC_STACK"]=ALLOC_STACK;Module["ALLOC_STATIC"]=ALLOC_STATIC;Module["ALLOC_DYNAMIC"]=ALLOC_DYNAMIC;Module["ALLOC_NONE"]=ALLOC_NONE;function allocate(slab,types,allocator,ptr){var zeroinit,size;if(typeof slab==="number"){zeroinit=true;size=slab}else{zeroinit=false;size=slab.length}var singleType=typeof types==="string"?types:null;var ret;if(allocator==ALLOC_NONE){ret=ptr}else{ret=[_malloc,Runtime.stackAlloc,Runtime.staticAlloc,Runtime.dynamicAlloc][allocator===undefined?ALLOC_STATIC:allocator](Math.max(size,singleType?1:types.length))}if(zeroinit){var ptr=ret,stop;assert((ret&3)==0);stop=ret+(size&~3);for(;ptr<stop;ptr+=4){HEAP32[ptr>>2]=0}stop=ret+size;while(ptr<stop){HEAP8[ptr++>>0]=0}return ret}if(singleType==="i8"){if(slab.subarray||slab.slice){HEAPU8.set(slab,ret)}else{HEAPU8.set(new Uint8Array(slab),ret)}return ret}var i=0,type,typeSize,previousType;while(i<size){var curr=slab[i];if(typeof curr==="function"){curr=Runtime.getFunctionIndex(curr)}type=singleType||types[i];if(type===0){i++;continue}if(type=="i64")type="i32";setValue(ret+i,curr,type);if(previousType!==type){typeSize=Runtime.getNativeTypeSize(type);previousType=type}i+=typeSize}return ret}Module["allocate"]=allocate;function getMemory(size){if(!staticSealed)return Runtime.staticAlloc(size);if(typeof _sbrk!=="undefined"&&!_sbrk.called||!runtimeInitialized)return Runtime.dynamicAlloc(size);return _malloc(size)}Module["getMemory"]=getMemory;function Pointer_stringify(ptr,length){if(length===0||!ptr)return"";var hasUtf=0;var t;var i=0;while(1){t=HEAPU8[ptr+i>>0];hasUtf|=t;if(t==0&&!length)break;i++;if(length&&i==length)break}if(!length)length=i;var ret="";if(hasUtf<128){var MAX_CHUNK=1024;var curr;while(length>0){curr=String.fromCharCode.apply(String,HEAPU8.subarray(ptr,ptr+Math.min(length,MAX_CHUNK)));ret=ret?ret+curr:curr;ptr+=MAX_CHUNK;length-=MAX_CHUNK}return ret}return Module["UTF8ToString"](ptr)}Module["Pointer_stringify"]=Pointer_stringify;function AsciiToString(ptr){var str="";while(1){var ch=HEAP8[ptr++>>0];if(!ch)return str;str+=String.fromCharCode(ch)}}Module["AsciiToString"]=AsciiToString;function stringToAscii(str,outPtr){return writeAsciiToMemory(str,outPtr,false)}Module["stringToAscii"]=stringToAscii;function UTF8ArrayToString(u8Array,idx){var u0,u1,u2,u3,u4,u5;var str="";while(1){u0=u8Array[idx++];if(!u0)return str;if(!(u0&128)){str+=String.fromCharCode(u0);continue}u1=u8Array[idx++]&63;if((u0&224)==192){str+=String.fromCharCode((u0&31)<<6|u1);continue}u2=u8Array[idx++]&63;if((u0&240)==224){u0=(u0&15)<<12|u1<<6|u2}else{u3=u8Array[idx++]&63;if((u0&248)==240){u0=(u0&7)<<18|u1<<12|u2<<6|u3}else{u4=u8Array[idx++]&63;if((u0&252)==248){u0=(u0&3)<<24|u1<<18|u2<<12|u3<<6|u4}else{u5=u8Array[idx++]&63;u0=(u0&1)<<30|u1<<24|u2<<18|u3<<12|u4<<6|u5}}}if(u0<65536){str+=String.fromCharCode(u0)}else{var ch=u0-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}}}Module["UTF8ArrayToString"]=UTF8ArrayToString;function UTF8ToString(ptr){return UTF8ArrayToString(HEAPU8,ptr)}Module["UTF8ToString"]=UTF8ToString;function stringToUTF8Array(str,outU8Array,outIdx,maxBytesToWrite){if(!(maxBytesToWrite>0))return 0;var startIdx=outIdx;var endIdx=outIdx+maxBytesToWrite-1;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){if(outIdx>=endIdx)break;outU8Array[outIdx++]=u}else if(u<=2047){if(outIdx+1>=endIdx)break;outU8Array[outIdx++]=192|u>>6;outU8Array[outIdx++]=128|u&63}else if(u<=65535){if(outIdx+2>=endIdx)break;outU8Array[outIdx++]=224|u>>12;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=2097151){if(outIdx+3>=endIdx)break;outU8Array[outIdx++]=240|u>>18;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else if(u<=67108863){if(outIdx+4>=endIdx)break;outU8Array[outIdx++]=248|u>>24;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}else{if(outIdx+5>=endIdx)break;outU8Array[outIdx++]=252|u>>30;outU8Array[outIdx++]=128|u>>24&63;outU8Array[outIdx++]=128|u>>18&63;outU8Array[outIdx++]=128|u>>12&63;outU8Array[outIdx++]=128|u>>6&63;outU8Array[outIdx++]=128|u&63}}outU8Array[outIdx]=0;return outIdx-startIdx}Module["stringToUTF8Array"]=stringToUTF8Array;function stringToUTF8(str,outPtr,maxBytesToWrite){return stringToUTF8Array(str,HEAPU8,outPtr,maxBytesToWrite)}Module["stringToUTF8"]=stringToUTF8;function lengthBytesUTF8(str){var len=0;for(var i=0;i<str.length;++i){var u=str.charCodeAt(i);if(u>=55296&&u<=57343)u=65536+((u&1023)<<10)|str.charCodeAt(++i)&1023;if(u<=127){++len}else if(u<=2047){len+=2}else if(u<=65535){len+=3}else if(u<=2097151){len+=4}else if(u<=67108863){len+=5}else{len+=6}}return len}Module["lengthBytesUTF8"]=lengthBytesUTF8;function UTF16ToString(ptr){var i=0;var str="";while(1){var codeUnit=HEAP16[ptr+i*2>>1];if(codeUnit==0)return str;++i;str+=String.fromCharCode(codeUnit)}}Module["UTF16ToString"]=UTF16ToString;function stringToUTF16(str,outPtr,maxBytesToWrite){if(maxBytesToWrite===undefined){maxBytesToWrite=2147483647}if(maxBytesToWrite<2)return 0;maxBytesToWrite-=2;var startPtr=outPtr;var numCharsToWrite=maxBytesToWrite<str.length*2?maxBytesToWrite/2:str.length;for(var i=0;i<numCharsToWrite;++i){var codeUnit=str.charCodeAt(i);HEAP16[outPtr>>1]=codeUnit;outPtr+=2}HEAP16[outPtr>>1]=0;return outPtr-startPtr}Module["stringToUTF16"]=stringToUTF16;function lengthBytesUTF16(str){return str.length*2}Module["lengthBytesUTF16"]=lengthBytesUTF16;function UTF32ToString(ptr){var i=0;var str="";while(1){var utf32=HEAP32[ptr+i*4>>2];if(utf32==0)return str;++i;if(utf32>=65536){var ch=utf32-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}else{str+=String.fromCharCode(utf32)}}}Module["UTF32ToString"]=UTF32ToString;function stringToUTF32(str,outPtr,maxBytesToWrite){if(maxBytesToWrite===undefined){maxBytesToWrite=2147483647}if(maxBytesToWrite<4)return 0;var startPtr=outPtr;var endPtr=startPtr+maxBytesToWrite-4;for(var i=0;i<str.length;++i){var codeUnit=str.charCodeAt(i);if(codeUnit>=55296&&codeUnit<=57343){var trailSurrogate=str.charCodeAt(++i);codeUnit=65536+((codeUnit&1023)<<10)|trailSurrogate&1023}HEAP32[outPtr>>2]=codeUnit;outPtr+=4;if(outPtr+4>endPtr)break}HEAP32[outPtr>>2]=0;return outPtr-startPtr}Module["stringToUTF32"]=stringToUTF32;function lengthBytesUTF32(str){var len=0;for(var i=0;i<str.length;++i){var codeUnit=str.charCodeAt(i);if(codeUnit>=55296&&codeUnit<=57343)++i;len+=4}return len}Module["lengthBytesUTF32"]=lengthBytesUTF32;function demangle(func){var hasLibcxxabi=!!Module["___cxa_demangle"];if(hasLibcxxabi){try{var buf=_malloc(func.length);writeStringToMemory(func.substr(1),buf);var status=_malloc(4);var ret=Module["___cxa_demangle"](buf,0,0,status);if(getValue(status,"i32")===0&&ret){return Pointer_stringify(ret)}}catch(e){}finally{if(buf)_free(buf);if(status)_free(status);if(ret)_free(ret)}}var i=3;var basicTypes={"v":"void","b":"bool","c":"char","s":"short","i":"int","l":"long","f":"float","d":"double","w":"wchar_t","a":"signed char","h":"unsigned char","t":"unsigned short","j":"unsigned int","m":"unsigned long","x":"long long","y":"unsigned long long","z":"..."};var subs=[];var first=true;function dump(x){if(x)Module.print(x);Module.print(func);var pre="";for(var a=0;a<i;a++)pre+=" ";Module.print(pre+"^")}function parseNested(){i++;if(func[i]==="K")i++;var parts=[];while(func[i]!=="E"){if(func[i]==="S"){i++;var next=func.indexOf("_",i);var num=func.substring(i,next)||0;parts.push(subs[num]||"?");i=next+1;continue}if(func[i]==="C"){parts.push(parts[parts.length-1]);i+=2;continue}var size=parseInt(func.substr(i));var pre=size.toString().length;if(!size||!pre){i--;break}var curr=func.substr(i+pre,size);parts.push(curr);subs.push(curr);i+=pre+size}i++;return parts}function parse(rawList,limit,allowVoid){limit=limit||Infinity;var ret="",list=[];function flushList(){return"("+list.join(", ")+")"}var name;if(func[i]==="N"){name=parseNested().join("::");limit--;if(limit===0)return rawList?[name]:name}else{if(func[i]==="K"||first&&func[i]==="L")i++;var size=parseInt(func.substr(i));if(size){var pre=size.toString().length;name=func.substr(i+pre,size);i+=pre+size}}first=false;if(func[i]==="I"){i++;var iList=parse(true);var iRet=parse(true,1,true);ret+=iRet[0]+" "+name+"<"+iList.join(", ")+">"}else{ret=name}paramLoop:while(i<func.length&&limit-->0){var c=func[i++];if(c in basicTypes){list.push(basicTypes[c])}else{switch(c){case"P":list.push(parse(true,1,true)[0]+"*");break;case"R":list.push(parse(true,1,true)[0]+"&");break;case"L":{i++;var end=func.indexOf("E",i);var size=end-i;list.push(func.substr(i,size));i+=size+2;break};case"A":{var size=parseInt(func.substr(i));i+=size.toString().length;if(func[i]!=="_")throw"?";i++;list.push(parse(true,1,true)[0]+" ["+size+"]");break};case"E":break paramLoop;default:ret+="?"+c;break paramLoop}}}if(!allowVoid&&list.length===1&&list[0]==="void")list=[];if(rawList){if(ret){list.push(ret+"?")}return list}else{return ret+flushList()}}var parsed=func;try{if(func=="Object._main"||func=="_main"){return"main()"}if(typeof func==="number")func=Pointer_stringify(func);if(func[0]!=="_")return func;if(func[1]!=="_")return func;if(func[2]!=="Z")return func;switch(func[3]){case"n":return"operator new()";case"d":return"operator delete()"}parsed=parse()}catch(e){parsed+="?"}if(parsed.indexOf("?")>=0&&!hasLibcxxabi){Runtime.warnOnce("warning: a problem occurred in builtin C++ name demangling; build with  -s DEMANGLE_SUPPORT=1  to link in libcxxabi demangling")}return parsed}function demangleAll(text){return text.replace(/__Z[\w\d_]+/g,(function(x){var y=demangle(x);return x===y?x:x+" ["+y+"]"}))}function jsStackTrace(){var err=new Error;if(!err.stack){try{throw new Error(0)}catch(e){err=e}if(!err.stack){return"(no stack trace available)"}}return err.stack.toString()}function stackTrace(){return demangleAll(jsStackTrace())}Module["stackTrace"]=stackTrace;var PAGE_SIZE=4096;function alignMemoryPage(x){if(x%4096>0){x+=4096-x%4096}return x}var HEAP;var HEAP8,HEAPU8,HEAP16,HEAPU16,HEAP32,HEAPU32,HEAPF32,HEAPF64;var STATIC_BASE=0,STATICTOP=0,staticSealed=false;var STACK_BASE=0,STACKTOP=0,STACK_MAX=0;var DYNAMIC_BASE=0,DYNAMICTOP=0;function abortOnCannotGrowMemory(){abort("Cannot enlarge memory arrays. Either (1) compile with  -s TOTAL_MEMORY=X  with X higher than the current value "+TOTAL_MEMORY+", (2) compile with  -s ALLOW_MEMORY_GROWTH=1  which adjusts the size at runtime but prevents some optimizations, (3) set Module.TOTAL_MEMORY to a higher value before the program runs, or if you want malloc to return NULL (0) instead of this abort, compile with  -s ABORTING_MALLOC=0 ")}function enlargeMemory(){abortOnCannotGrowMemory()}var TOTAL_STACK=Module["TOTAL_STACK"]||5242880;var TOTAL_MEMORY=Module["TOTAL_MEMORY"]||4e8;var totalMemory=64*1024;while(totalMemory<TOTAL_MEMORY||totalMemory<2*TOTAL_STACK){if(totalMemory<16*1024*1024){totalMemory*=2}else{totalMemory+=16*1024*1024}}if(totalMemory!==TOTAL_MEMORY){TOTAL_MEMORY=totalMemory}assert(typeof Int32Array!=="undefined"&&typeof Float64Array!=="undefined"&&!!(new Int32Array(1))["subarray"]&&!!(new Int32Array(1))["set"],"JS engine does not provide full typed array support");var buffer;buffer=new ArrayBuffer(TOTAL_MEMORY);HEAP8=new Int8Array(buffer);HEAP16=new Int16Array(buffer);HEAP32=new Int32Array(buffer);HEAPU8=new Uint8Array(buffer);HEAPU16=new Uint16Array(buffer);HEAPU32=new Uint32Array(buffer);HEAPF32=new Float32Array(buffer);HEAPF64=new Float64Array(buffer);HEAP32[0]=255;assert(HEAPU8[0]===255&&HEAPU8[3]===0,"Typed arrays 2 must be run on a little-endian system");Module["HEAP"]=HEAP;Module["buffer"]=buffer;Module["HEAP8"]=HEAP8;Module["HEAP16"]=HEAP16;Module["HEAP32"]=HEAP32;Module["HEAPU8"]=HEAPU8;Module["HEAPU16"]=HEAPU16;Module["HEAPU32"]=HEAPU32;Module["HEAPF32"]=HEAPF32;Module["HEAPF64"]=HEAPF64;function callRuntimeCallbacks(callbacks){while(callbacks.length>0){var callback=callbacks.shift();if(typeof callback=="function"){callback();continue}var func=callback.func;if(typeof func==="number"){if(callback.arg===undefined){Runtime.dynCall("v",func)}else{Runtime.dynCall("vi",func,[callback.arg])}}else{func(callback.arg===undefined?null:callback.arg)}}}var __ATPRERUN__=[];var __ATINIT__=[];var __ATMAIN__=[];var __ATEXIT__=[];var __ATPOSTRUN__=[];var runtimeInitialized=false;var runtimeExited=false;function preRun(){if(Module["preRun"]){if(typeof Module["preRun"]=="function")Module["preRun"]=[Module["preRun"]];while(Module["preRun"].length){addOnPreRun(Module["preRun"].shift())}}callRuntimeCallbacks(__ATPRERUN__)}function ensureInitRuntime(){if(runtimeInitialized)return;runtimeInitialized=true;callRuntimeCallbacks(__ATINIT__)}function preMain(){callRuntimeCallbacks(__ATMAIN__)}function exitRuntime(){callRuntimeCallbacks(__ATEXIT__);runtimeExited=true}function postRun(){if(Module["postRun"]){if(typeof Module["postRun"]=="function")Module["postRun"]=[Module["postRun"]];while(Module["postRun"].length){addOnPostRun(Module["postRun"].shift())}}callRuntimeCallbacks(__ATPOSTRUN__)}function addOnPreRun(cb){__ATPRERUN__.unshift(cb)}Module["addOnPreRun"]=addOnPreRun;function addOnInit(cb){__ATINIT__.unshift(cb)}Module["addOnInit"]=addOnInit;function addOnPreMain(cb){__ATMAIN__.unshift(cb)}Module["addOnPreMain"]=addOnPreMain;function addOnExit(cb){__ATEXIT__.unshift(cb)}Module["addOnExit"]=addOnExit;function addOnPostRun(cb){__ATPOSTRUN__.unshift(cb)}Module["addOnPostRun"]=addOnPostRun;function intArrayFromString(stringy,dontAddNull,length){var len=length>0?length:lengthBytesUTF8(stringy)+1;var u8array=new Array(len);var numBytesWritten=stringToUTF8Array(stringy,u8array,0,u8array.length);if(dontAddNull)u8array.length=numBytesWritten;return u8array}Module["intArrayFromString"]=intArrayFromString;function intArrayToString(array){var ret=[];for(var i=0;i<array.length;i++){var chr=array[i];if(chr>255){chr&=255}ret.push(String.fromCharCode(chr))}return ret.join("")}Module["intArrayToString"]=intArrayToString;function writeStringToMemory(string,buffer,dontAddNull){var array=intArrayFromString(string,dontAddNull);var i=0;while(i<array.length){var chr=array[i];HEAP8[buffer+i>>0]=chr;i=i+1}}Module["writeStringToMemory"]=writeStringToMemory;function writeArrayToMemory(array,buffer){for(var i=0;i<array.length;i++){HEAP8[buffer++>>0]=array[i]}}Module["writeArrayToMemory"]=writeArrayToMemory;function writeAsciiToMemory(str,buffer,dontAddNull){for(var i=0;i<str.length;++i){HEAP8[buffer++>>0]=str.charCodeAt(i)}if(!dontAddNull)HEAP8[buffer>>0]=0}Module["writeAsciiToMemory"]=writeAsciiToMemory;function unSign(value,bits,ignore){if(value>=0){return value}return bits<=32?2*Math.abs(1<<bits-1)+value:Math.pow(2,bits)+value}function reSign(value,bits,ignore){if(value<=0){return value}var half=bits<=32?Math.abs(1<<bits-1):Math.pow(2,bits-1);if(value>=half&&(bits<=32||value>half)){value=-2*half+value}return value}if(!Math["imul"]||Math["imul"](4294967295,5)!==-5)Math["imul"]=function imul(a,b){var ah=a>>>16;var al=a&65535;var bh=b>>>16;var bl=b&65535;return al*bl+(ah*bl+al*bh<<16)|0};Math.imul=Math["imul"];if(!Math["clz32"])Math["clz32"]=(function(x){x=x>>>0;for(var i=0;i<32;i++){if(x&1<<31-i)return i}return 32});Math.clz32=Math["clz32"];var Math_abs=Math.abs;var Math_cos=Math.cos;var Math_sin=Math.sin;var Math_tan=Math.tan;var Math_acos=Math.acos;var Math_asin=Math.asin;var Math_atan=Math.atan;var Math_atan2=Math.atan2;var Math_exp=Math.exp;var Math_log=Math.log;var Math_sqrt=Math.sqrt;var Math_ceil=Math.ceil;var Math_floor=Math.floor;var Math_pow=Math.pow;var Math_imul=Math.imul;var Math_fround=Math.fround;var Math_min=Math.min;var Math_clz32=Math.clz32;var runDependencies=0;var runDependencyWatcher=null;var dependenciesFulfilled=null;function getUniqueRunDependency(id){return id}function addRunDependency(id){runDependencies++;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}}Module["addRunDependency"]=addRunDependency;function removeRunDependency(id){runDependencies--;if(Module["monitorRunDependencies"]){Module["monitorRunDependencies"](runDependencies)}if(runDependencies==0){if(runDependencyWatcher!==null){clearInterval(runDependencyWatcher);runDependencyWatcher=null}if(dependenciesFulfilled){var callback=dependenciesFulfilled;dependenciesFulfilled=null;callback()}}}Module["removeRunDependency"]=removeRunDependency;Module["preloadedImages"]={};Module["preloadedAudios"]={};var memoryInitializer=null;var ASM_CONSTS=[];STATIC_BASE=8;STATICTOP=STATIC_BASE+59744;__ATINIT__.push({func:(function(){__GLOBAL__I_000101()})},{func:(function(){__GLOBAL__sub_I_jpegls_cpp()})},{func:(function(){__GLOBAL__sub_I_iostream_cpp()})});allocate([0,0,0,0,0,0,0,0,84,144,0,0,31,194,0,0,216,0,0,0,0,0,0,0,84,144,0,0,237,191,0,0,48,0,0,0,0,0,0,0,44,144,0,0,41,192,0,0,84,144,0,0,55,192,0,0,48,0,0,0,0,0,0,0,84,144,0,0,115,192,0,0,48,0,0,0,0,0,0,0,84,144,0,0,175,192,0,0,152,3,0,0,0,0,0,0,84,144,0,0,241,192,0,0,216,3,0,0,0,0,0,0,84,144,0,0,55,193,0,0,48,0,0,0,0,0,0,0,84,144,0,0,95,193,0,0,48,0,0,0,0,0,0,0,84,144,0,0,135,193,0,0,48,0,0,0,0,0,0,0,84,144,0,0,175,193,0,0,48,0,0,0,0,0,0,0,84,144,0,0,216,193,0,0,48,0,0,0,0,0,0,0,84,144,0,0,241,193,0,0,48,0,0,0,0,0,0,0,44,144,0,0,13,194,0,0,84,144,0,0,80,194,0,0,216,0,0,0,0,0,0,0,84,144,0,0,44,195,0,0,216,0,0,0,0,0,0,0,84,144,0,0,139,194,0,0,48,0,0,0,0,0,0,0,84,144,0,0,179,194,0,0,48,0,0,0,0,0,0,0,84,144,0,0,219,194,0,0,48,0,0,0,0,0,0,0,84,144,0,0,3,195,0,0,48,0,0,0,0,0,0,0,84,144,0,0,103,195,0,0,216,0,0,0,0,0,0,0,84,144,0,0,157,195,0,0,216,0,0,0,0,0,0,0,84,144,0,0,211,195,0,0,216,0,0,0,0,0,0,0,84,144,0,0,8,196,0,0,216,0,0,0,0,0,0,0,84,144,0,0,71,196,0,0,216,0,0,0,0,0,0,0,84,144,0,0,138,196,0,0,160,1,0,0,0,0,0,0,44,144,0,0,120,196,0,0,84,144,0,0,187,196,0,0,160,1,0,0,0,0,0,0,84,144,0,0,246,196,0,0,160,1,0,0,0,0,0,0,84,144,0,0,49,197,0,0,160,1,0,0,0,0,0,0,84,144,0,0,103,197,0,0,160,1,0,0,0,0,0,0,84,144,0,0,157,197,0,0,160,1,0,0,0,0,0,0,84,144,0,0,210,197,0,0,160,1,0,0,0,0,0,0,84,144,0,0,17,198,0,0,160,1,0,0,0,0,0,0,84,144,0,0,86,198,0,0,72,3,0,0,0,0,0,0,84,144,0,0,162,198,0,0,56,2,0,0,0,0,0,0,44,144,0,0,182,198,0,0,84,144,0,0,196,198,0,0,56,2,0,0,0,0,0,0,84,144,0,0,112,199,0,0,96,2,0,0,0,0,0,0,44,144,0,0,125,199,0,0,84,144,0,0,138,199,0,0,96,2,0,0,0,0,0,0,44,144,0,0,156,199,0,0,84,144,0,0,169,199,0,0,96,2,0,0,0,0,0,0,84,144,0,0,181,199,0,0,120,2,0,0,0,0,0,0,84,144,0,0,214,199,0,0,144,2,0,0,0,0,0,0,84,144,0,0,28,200,0,0,144,2,0,0,0,0,0,0,84,144,0,0,248,199,0,0,176,2,0,0,0,0,0,0,84,144,0,0,62,200,0,0,160,2,0,0,0,0,0,0,84,144,0,0,99,200,0,0,160,2,0,0,0,0,0,0,84,144,0,0,182,221,0,0,160,3,0,0,0,0,0,0,84,144,0,0,245,221,0,0,160,3,0,0,0,0,0,0,84,144,0,0,13,222,0,0,152,3,0,0,0,0,0,0,84,144,0,0,38,222,0,0,152,3,0,0,0,0,0,0,44,144,0,0,62,222,0,0,84,144,0,0,87,222,0,0,104,2,0,0,0,0,0,0,44,144,0,0,110,222,0,0,84,144,0,0,135,222,0,0,72,3,0,0,0,0,0,0,84,144,0,0,161,222,0,0,56,3,0,0,0,0,0,0,44,144,0,0,187,222,0,0,84,144,0,0,205,222,0,0,112,3,0,0,0,0,0,0,84,144,0,0,247,222,0,0,112,3,0,0,0,0,0,0,44,144,0,0,33,223,0,0,44,144,0,0,82,223,0,0,124,144,0,0,131,223,0,0,0,0,0,0,1,0,0,0,120,3,0,0,3,244,255,255,124,144,0,0,178,223,0,0,0,0,0,0,1,0,0,0,136,3,0,0,3,244,255,255,124,144,0,0,225,223,0,0,0,0,0,0,1,0,0,0,120,3,0,0,3,244,255,255,124,144,0,0,16,224,0,0,0,0,0,0,1,0,0,0,136,3,0,0,3,244,255,255,84,144,0,0,63,224,0,0,80,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,84,144,0,0,187,224,0,0,48,3,0,0,0,0,0,0,124,144,0,0,209,224,0,0,0,0,0,0,2,0,0,0,32,4,0,0,2,0,0,0,64,10,0,0,2,0,0,0,124,144,0,0,227,224,0,0,0,0,0,0,2,0,0,0,32,4,0,0,2,0,0,0,72,10,0,0,2,0,0,0,124,144,0,0,5,225,0,0,0,0,0,0,2,0,0,0,32,4,0,0,2,0,0,0,72,10,0,0,2,0,0,0,124,144,0,0,40,225,0,0,0,0,0,0,2,0,0,0,32,4,0,0,2,0,0,0,72,10,0,0,2,0,0,0,84,144,0,0,75,225,0,0,144,4,0,0,0,0,0,0,84,144,0,0,109,225,0,0,144,4,0,0,0,0,0,0,124,144,0,0,144,225,0,0,0,0,0,0,2,0,0,0,32,4,0,0,2,0,0,0,72,10,0,0,2,0,0,0,84,144,0,0,178,225,0,0,32,4,0,0,0,0,0,0,84,144,0,0,200,225,0,0,32,4,0,0,0,0,0,0,84,144,0,0,220,225,0,0,32,4,0,0,0,0,0,0,124,144,0,0,240,225,0,0,0,0,0,0,2,0,0,0,32,4,0,0,2,0,0,0,64,10,0,0,2,0,0,0,84,144,0,0,2,226,0,0,32,4,0,0,0,0,0,0,84,144,0,0,23,226,0,0,32,4,0,0,0,0,0,0,124,144,0,0,44,226,0,0,0,0,0,0,2,0,0,0,32,4,0,0,2,0,0,0,80,10,0,0,0,0,0,0,124,144,0,0,112,226,0,0,0,0,0,0,2,0,0,0,32,4,0,0,2,0,0,0,104,10,0,0,0,0,0,0,124,144,0,0,180,226,0,0,0,0,0,0,2,0,0,0,32,4,0,0,2,0,0,0,128,10,0,0,0,0,0,0,124,144,0,0,248,226,0,0,0,0,0,0,2,0,0,0,32,4,0,0,2,0,0,0,152,10,0,0,0,0,0,0,124,144,0,0,60,227,0,0,0,0,0,0,3,0,0,0,32,4,0,0,2,0,0,0,176,10,0,0,2,0,0,0,184,10,0,0,0,8,0,0,124,144,0,0,129,227,0,0,0,0,0,0,3,0,0,0,32,4,0,0,2,0,0,0,176,10,0,0,2,0,0,0,192,10,0,0,0,8,0,0,124,144,0,0,198,227,0,0,0,0,0,0,2,0,0,0,32,4,0,0,2,0,0,0,200,10,0,0,0,8,0,0,124,144,0,0,11,228,0,0,0,0,0,0,2,0,0,0,32,4,0,0,2,0,0,0,200,10,0,0,0,8,0,0,124,144,0,0,80,228,0,0,0,0,0,0,2,0,0,0,32,4,0,0,2,0,0,0,208,10,0,0,2,0,0,0,124,144,0,0,108,228,0,0,0,0,0,0,2,0,0,0,32,4,0,0,2,0,0,0,208,10,0,0,2,0,0,0,124,144,0,0,136,228,0,0,0,0,0,0,2,0,0,0,32,4,0,0,2,0,0,0,208,10,0,0,2,0,0,0,124,144,0,0,164,228,0,0,0,0,0,0,2,0,0,0,32,4,0,0,2,0,0,0,208,10,0,0,2,0,0,0,124,144,0,0,192,228,0,0,0,0,0,0,2,0,0,0,32,4,0,0,2,0,0,0,216,10,0,0,0,0,0,0,124,144,0,0,6,229,0,0,0,0,0,0,2,0,0,0,32,4,0,0,2,0,0,0,224,10,0,0,0,0,0,0,124,144,0,0,76,229,0,0,0,0,0,0,2,0,0,0,32,4,0,0,2,0,0,0,232,10,0,0,0,0,0,0,124,144,0,0,146,229,0,0,0,0,0,0,2,0,0,0,32,4,0,0,2,0,0,0,240,10,0,0,0,0,0,0,124,144,0,0,216,229,0,0,0,0,0,0,2,0,0,0,32,4,0,0,2,0,0,0,248,10,0,0,2,0,0,0,124,144,0,0,237,229,0,0,0,0,0,0,2,0,0,0,32,4,0,0,2,0,0,0,248,10,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,144,0,0,73,233,0,0,44,144,0,0,50,233,0,0,124,144,0,0,28,233,0,0,0,0,0,0,1,0,0,0,8,11,0,0,0,0,0,0,124,144,0,0,237,232,0,0,0,0,0,0,1,0,0,0,8,11,0,0,0,0,0,0,124,144,0,0,215,232,0,0,0,0,0,0,1,0,0,0,0,11,0,0,0,0,0,0,124,144,0,0,168,232,0,0,0,0,0,0,1,0,0,0,0,11,0,0,0,0,0,0,44,144,0,0,149,232,0,0,44,144,0,0,115,232,0,0,44,144,0,0,81,232,0,0,44,144,0,0,60,232,0,0,44,144,0,0,39,232,0,0,44,144,0,0,14,232,0,0,44,144,0,0,245,231,0,0,44,144,0,0,220,231,0,0,44,144,0,0,195,231,0,0,44,144,0,0,171,231,0,0,44,144,0,0,190,232,0,0,44,144,0,0,3,233],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE);allocate([156,143,0,0,0,0,0,0,8,2,0,0,1,0,0,0,2,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,248,1,0,0,3,0,0,0,4,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,232,1,0,0,5,0,0,0,6,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,0,0,0,0,216,1,0,0,7,0,0,0,8,0,0,0,4,0,0,0,4,0,0,0,4,0,0,0,0,0,0,0,200,1,0,0,9,0,0,0,10,0,0,0,5,0,0,0,5,0,0,0,5,0,0,0,0,0,0,0,184,1,0,0,11,0,0,0,12,0,0,0,6,0,0,0,6,0,0,0,6,0,0,0,0,0,0,0,168,1,0,0,13,0,0,0,14,0,0,0,7,0,0,0,7,0,0,0,7,0,0,0,0,0,0,0,144,1,0,0,15,0,0,0,16,0,0,0,8,0,0,0,8,0,0,0,8,0,0,0,0,0,0,0,128,1,0,0,17,0,0,0,18,0,0,0,9,0,0,0,1,0,0,0,9,0,0,0,0,0,0,0,112,1,0,0,19,0,0,0,20,0,0,0,10,0,0,0,2,0,0,0,10,0,0,0,0,0,0,0,96,1,0,0,21,0,0,0,22,0,0,0,11,0,0,0,3,0,0,0,11,0,0,0,0,0,0,0,80,1,0,0,23,0,0,0,24,0,0,0,12,0,0,0,4,0,0,0,12,0,0,0,0,0,0,0,64,1,0,0,25,0,0,0,26,0,0,0,13,0,0,0,5,0,0,0,13,0,0,0,0,0,0,0,240,0,0,0,27,0,0,0,28,0,0,0,14,0,0,0,6,0,0,0,14,0,0,0,0,0,0,0,224,0,0,0,29,0,0,0,30,0,0,0,15,0,0,0,7,0,0,0,15,0,0,0,0,0,0,0,16,0,0,0,31,0,0,0,32,0,0,0,16,0,0,0,8,0,0,0,16,0,0,0,0,0,0,0,200,0,0,0,33,0,0,0,34,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,184,0,0,0,33,0,0,0,35,0,0,0,3,0,0,0,4,0,0,0,56,0,0,0,0,0,0,0,216,3,0,0,36,0,0,0,37,0,0,0,200,255,255,255,200,255,255,255,216,3,0,0,38,0,0,0,39,0,0,0,56,0,0,0,0,0,0,0,104,0,0,0,40,0,0,0,41,0,0,0,200,255,255,255,200,255,255,255,104,0,0,0,42,0,0,0,43,0,0,0,0,0,0,0,88,0,0,0,44,0,0,0,45,0,0,0,17,0,0,0,1,0,0,0,1,0,0,0,5,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,17,0,0,0,3,0,0,0,18,0,0,0,104,141,0,0,64,141,0,0,84,141,0,0,124,141,0,0,0,0,0,0,32,0,0,0,46,0,0,0,47,0,0,0,6,0,0,0,7,0,0,0,0,0,0,0,56,0,0,0,48,0,0,0,49,0,0,0,8,0,0,0,9,0,0,0,0,0,0,0,72,0,0,0,50,0,0,0,51,0,0,0,10,0,0,0,11,0,0,0,0,0,0,0,120,0,0,0,52,0,0,0,53,0,0,0,12,0,0,0,13,0,0,0,0,0,0,0,136,0,0,0,54,0,0,0,55,0,0,0,14,0,0,0,15,0,0,0,0,0,0,0,152,0,0,0,56,0,0,0,57,0,0,0,16,0,0,0,17,0,0,0,0,0,0,0,168,0,0,0,58,0,0,0,59,0,0,0,18,0,0,0,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,2,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,3,0,0,0,4,0,0,0,4,0,0,0,5,0,0,0,5,0,0,0,6,0,0,0,6,0,0,0,7,0,0,0,7,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,12,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,0,0,0,0,216,0,0,0,60,0,0,0,61,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,62,0,0,0,63,0,0,0,20,0,0,0,21,0,0,0,0,0,0,0,16,1,0,0,64,0,0,0,65,0,0,0,22,0,0,0,23,0,0,0,0,0,0,0,32,1,0,0,66,0,0,0,67,0,0,0,24,0,0,0,25,0,0,0,0,0,0,0,48,1,0,0,68,0,0,0,69,0,0,0,26,0,0,0,27,0,0,0,0,0,0,0,160,1,0,0,70,0,0,0,71,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,24,2,0,0,72,0,0,0,73,0,0,0,5,0,0,0,1,0,0,0,4,0,0,0,5,0,0,0,2,0,0,0,0,0,0,0,40,2,0,0,74,0,0,0,75,0,0,0,18,0,0,0,0,0,0,0,64,2,0,0,76,0,0,0,77,0,0,0,19,0,0,0,2,0,0,0,0,0,0,0,80,2,0,0,78,0,0,0,79,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,104,2,0,0,80,0,0,0,81,0,0,0,7,0,0,0,0,0,0,0,128,2,0,0,82,0,0,0,83,0,0,0,8,0,0,0,0,0,0,0,160,2,0,0,84,0,0,0,85,0,0,0,86,0,0,0,87,0,0,0,6,0,0,0,2,0,0,0,9,0,0,0,28,0,0,0,0,0,0,0,208,2,0,0,84,0,0,0,88,0,0,0,86,0,0,0,87,0,0,0,6,0,0,0,3,0,0,0,10,0,0,0,29,0,0,0,0,0,0,0,224,2,0,0,84,0,0,0,89,0,0,0,86,0,0,0,87,0,0,0,6,0,0,0,4,0,0,0,11,0,0,0,30,0,0,0,0,0,0,0,0,0,0,0,1,203,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,192,3,0,0,192,4,0,0,192,5,0,0,192,6,0,0,192,7,0,0,192,8,0,0,192,9,0,0,192,10,0,0,192,11,0,0,192,12,0,0,192,13,0,0,192,14,0,0,192,15,0,0,192,16,0,0,192,17,0,0,192,18,0,0,192,19,0,0,192,20,0,0,192,21,0,0,192,22,0,0,192,23,0,0,192,24,0,0,192,25,0,0,192,26,0,0,192,27,0,0,192,28,0,0,192,29,0,0,192,30,0,0,192,31,0,0,192,0,0,0,179,1,0,0,195,2,0,0,195,3,0,0,195,4,0,0,195,5,0,0,195,6,0,0,195,7,0,0,195,8,0,0,195,9,0,0,195,10,0,0,195,11,0,0,195,12,0,0,195,13,0,0,211,14,0,0,195,15,0,0,195,0,0,12,187,1,0,12,195,2,0,12,195,3,0,12,195,4,0,12,211,88,146,0,0,200,146,0,0,56,147,0,0,56,147,0,0,120,187,0,0,168,155,0,0,168,149,0,0,0,0,0,0,10,0,0,0,100,0,0,0,232,3,0,0,16,39,0,0,160,134,1,0,64,66,15,0,128,150,152,0,0,225,245,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,0,0,0,9,0,0,0,159,219,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,0,0,0,9,0,0,0,151,215,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,9,0,0,0,143,211,0,0,0,4,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,255,255,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,12,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,25,0,0,0,26,0,0,0,27,0,0,0,28,0,0,0,29,0,0,0,30,0,0,0,31,0,0,0,32,0,0,0,33,0,0,0,34,0,0,0,35,0,0,0,36,0,0,0,37,0,0,0,38,0,0,0,39,0,0,0,40,0,0,0,41,0,0,0,42,0,0,0,43,0,0,0,44,0,0,0,45,0,0,0,46,0,0,0,47,0,0,0,48,0,0,0,49,0,0,0,50,0,0,0,51,0,0,0,52,0,0,0,53,0,0,0,54,0,0,0,55,0,0,0,56,0,0,0,57,0,0,0,58,0,0,0,59,0,0,0,60,0,0,0,61,0,0,0,62,0,0,0,63,0,0,0,64,0,0,0,65,0,0,0,66,0,0,0,67,0,0,0,68,0,0,0,69,0,0,0,70,0,0,0,71,0,0,0,72,0,0,0,73,0,0,0,74,0,0,0,75,0,0,0,76,0,0,0,77,0,0,0,78,0,0,0,79,0,0,0,80,0,0,0,81,0,0,0,82,0,0,0,83,0,0,0,84,0,0,0,85,0,0,0,86,0,0,0,87,0,0,0,88,0,0,0,89,0,0,0,90,0,0,0,91,0,0,0,92,0,0,0,93,0,0,0,94,0,0,0,95,0,0,0,96,0,0,0,65,0,0,0,66,0,0,0,67,0,0,0,68,0,0,0,69,0,0,0,70,0,0,0,71,0,0,0,72,0,0,0,73,0,0,0,74,0,0,0,75,0,0,0,76,0,0,0,77,0,0,0,78,0,0,0,79,0,0,0,80,0,0,0,81,0,0,0,82,0,0,0,83,0,0,0,84,0,0,0,85,0,0,0,86,0,0,0,87,0,0,0,88,0,0,0,89,0,0,0,90,0,0,0,123,0,0,0,124,0,0,0,125,0,0,0,126,0,0,0,127],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+35640);allocate([1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,12,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,23,0,0,0,24,0,0,0,25,0,0,0,26,0,0,0,27,0,0,0,28,0,0,0,29,0,0,0,30,0,0,0,31,0,0,0,32,0,0,0,33,0,0,0,34,0,0,0,35,0,0,0,36,0,0,0,37,0,0,0,38,0,0,0,39,0,0,0,40,0,0,0,41,0,0,0,42,0,0,0,43,0,0,0,44,0,0,0,45,0,0,0,46,0,0,0,47,0,0,0,48,0,0,0,49,0,0,0,50,0,0,0,51,0,0,0,52,0,0,0,53,0,0,0,54,0,0,0,55,0,0,0,56,0,0,0,57,0,0,0,58,0,0,0,59,0,0,0,60,0,0,0,61,0,0,0,62,0,0,0,63,0,0,0,64,0,0,0,97,0,0,0,98,0,0,0,99,0,0,0,100,0,0,0,101,0,0,0,102,0,0,0,103,0,0,0,104,0,0,0,105,0,0,0,106,0,0,0,107,0,0,0,108,0,0,0,109,0,0,0,110,0,0,0,111,0,0,0,112,0,0,0,113,0,0,0,114,0,0,0,115,0,0,0,116,0,0,0,117,0,0,0,118,0,0,0,119,0,0,0,120,0,0,0,121,0,0,0,122,0,0,0,91,0,0,0,92,0,0,0,93,0,0,0,94,0,0,0,95,0,0,0,96,0,0,0,97,0,0,0,98,0,0,0,99,0,0,0,100,0,0,0,101,0,0,0,102,0,0,0,103,0,0,0,104,0,0,0,105,0,0,0,106,0,0,0,107,0,0,0,108,0,0,0,109,0,0,0,110,0,0,0,111,0,0,0,112,0,0,0,113,0,0,0,114,0,0,0,115,0,0,0,116,0,0,0,117,0,0,0,118,0,0,0,119,0,0,0,120,0,0,0,121,0,0,0,122,0,0,0,123,0,0,0,124,0,0,0,125,0,0,0,126,0,0,0,127],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+39844);allocate([240,2,0,0,90,0,0,0,91,0,0,0,20,0,0,0,12,0,0,0,5,0,0,0,31,0,0,0,10,0,0,0,11,0,0,0,13,0,0,0,12,0,0,0,13,0,0,0,19,0,0,0,14,0,0,0,20,0,0,0,0,0,0,0,0,3,0,0,90,0,0,0,92,0,0,0,21,0,0,0,12,0,0,0,5,0,0,0,31,0,0,0,14,0,0,0,11,0,0,0,13,0,0,0,15,0,0,0,16,0,0,0,21,0,0,0,15,0,0,0,22,0,0,0,0,0,0,0,16,3,0,0,93,0,0,0,94,0,0,0,22,0,0,0,1,0,0,0,6,0,0,0,32,0,0,0,17,0,0,0,2,0,0,0,2,0,0,0,18,0,0,0,4,0,0,0,23,0,0,0,16,0,0,0,24,0,0,0,0,0,0,0,32,3,0,0,93,0,0,0,95,0,0,0,23,0,0,0,1,0,0,0,6,0,0,0,32,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,19,0,0,0,20,0,0,0,25,0,0,0,3,0,0,0,26,0,0,0,0,0,0,0,56,3,0,0,96,0,0,0,97,0,0,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,3,0,0,93,0,0,0,98,0,0,0,17,0,0,0,1,0,0,0,6,0,0,0,32,0,0,0,1,0,0,0,2,0,0,0,2,0,0,0,18,0,0,0,4,0,0,0,23,0,0,0,3,0,0,0,26,0,0,0,0,0,0,0,160,3,0,0,90,0,0,0,99,0,0,0,24,0,0,0,12,0,0,0,5,0,0,0,31,0,0,0,14,0,0,0,11,0,0,0,13,0,0,0,12,0,0,0,13,0,0,0,19,0,0,0,15,0,0,0,22,0,0,0,8,0,0,0,0,0,0,0,168,3,0,0,100,0,0,0,101,0,0,0,248,255,255,255,248,255,255,255,168,3,0,0,102,0,0,0,103,0,0,0,8,0,0,0,0,0,0,0,192,3,0,0,104,0,0,0,105,0,0,0,248,255,255,255,248,255,255,255,192,3,0,0,106,0,0,0,107,0,0,0,4,0,0,0,0,0,0,0,216,3,0,0,36,0,0,0,37,0,0,0,252,255,255,255,252,255,255,255,216,3,0,0,38,0,0,0,39,0,0,0,4,0,0,0,0,0,0,0,240,3,0,0,108,0,0,0,109,0,0,0,252,255,255,255,252,255,255,255,240,3,0,0,110,0,0,0,111,0,0,0,0,0,0,0,96,3,0,0,112,0,0,0,113,0,0,0,7,0,0,0,0,0,0,0,112,3,0,0,114,0,0,0,115,0,0,0,0,0,0,0,8,4,0,0,72,0,0,0,116,0,0,0,21,0,0,0,1,0,0,0,4,0,0,0,5,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,117,0,0,0,118,0,0,0,119,0,0,0,1,0,0,0,33,0,0,0,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,5,0,0,120,0,0,0,121,0,0,0,119,0,0,0,2,0,0,0,34,0,0,0,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,5,0,0,122,0,0,0,123,0,0,0,119,0,0,0,1,0,0,0,2,0,0,0,3,0,0,0,4,0,0,0,5,0,0,0,6,0,0,0,7,0,0,0,8,0,0,0,9,0,0,0,10,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,5,0,0,124,0,0,0,125,0,0,0,119,0,0,0,12,0,0,0,13,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,18,0,0,0,19,0,0,0,20,0,0,0,21,0,0,0,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,5,0,0,126,0,0,0,127,0,0,0,119,0,0,0,3,0,0,0,4,0,0,0,23,0,0,0,5,0,0,0,24,0,0,0,1,0,0,0,2,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,5,0,0,128,0,0,0,129,0,0,0,119,0,0,0,7,0,0,0,8,0,0,0,25,0,0,0,9,0,0,0,26,0,0,0,3,0,0,0,4,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,5,0,0,130,0,0,0,131,0,0,0,119,0,0,0,22,0,0,0,27,0,0,0,28,0,0,0,29,0,0,0,30,0,0,0,31,0,0,0,1,0,0,0,248,255,255,255,224,5,0,0,23,0,0,0,24,0,0,0,25,0,0,0,26,0,0,0,27,0,0,0,28,0,0,0,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,6,0,0,132,0,0,0,133,0,0,0,119,0,0,0,30,0,0,0,32,0,0,0,33,0,0,0,34,0,0,0,35,0,0,0,36,0,0,0,2,0,0,0,248,255,255,255,8,6,0,0,31,0,0,0,32,0,0,0,33,0,0,0,34,0,0,0,35,0,0,0,36,0,0,0,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,6,0,0,134,0,0,0,135,0,0,0,119,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,6,0,0,136,0,0,0,137,0,0,0,119,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,6,0,0,138,0,0,0,139,0,0,0,119,0,0,0,38,0,0,0,39,0,0,0,25,0,0,0,26,0,0,0,27,0,0,0,28,0,0,0,40,0,0,0,29,0,0,0,30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,6,0,0,140,0,0,0,141,0,0,0,119,0,0,0,41,0,0,0,42,0,0,0,31,0,0,0,32,0,0,0,33,0,0,0,34,0,0,0,43,0,0,0,35,0,0,0,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,6,0,0,142,0,0,0,143,0,0,0,119,0,0,0,44,0,0,0,45,0,0,0,37,0,0,0,38,0,0,0,39,0,0,0,40,0,0,0,46,0,0,0,41,0,0,0,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,6,0,0,144,0,0,0,145,0,0,0,119,0,0,0,47,0,0,0,48,0,0,0,43,0,0,0,44,0,0,0,45,0,0,0,46,0,0,0,49,0,0,0,47,0,0,0,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,6,0,0,146,0,0,0,147,0,0,0,119,0,0,0,3,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,7,0,0,148,0,0,0,149,0,0,0,119,0,0,0,5,0,0,0,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,7,0,0,150,0,0,0,151,0,0,0,119,0,0,0,1,0,0,0,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,7,0,0,152,0,0,0,153,0,0,0,119,0,0,0,2,0,0,0,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,7,0,0,154,0,0,0,155,0,0,0,119,0,0,0,19,0,0,0,7,0,0,0,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,7,0,0,156,0,0,0,157,0,0,0,119,0,0,0,20,0,0,0,8,0,0,0,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,4,0,0,158,0,0,0,159,0,0,0,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,5,0,0,160,0,0,0,161,0,0,0,119,0,0,0,27,0,0,0,21,0,0,0,28,0,0,0,22,0,0,0,29,0,0,0,9,0,0,0,23,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,4,0,0,162,0,0,0,163,0,0,0,119,0,0,0,3,0,0,0,4,0,0,0,12,0,0,0,50,0,0,0,51,0,0,0,13,0,0,0,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,5,0,0,164,0,0,0,165,0,0,0,119,0,0,0,53,0,0,0,54,0,0,0,51,0,0,0,52,0,0,0,53,0,0,0,0,0,0,0,80,5,0,0,166,0,0,0,167,0,0,0,119,0,0,0,55,0,0,0,56,0,0,0,54,0,0,0,55,0,0,0,56,0,0,0,0,0,0,0,32,4,0,0,168,0,0,0,169,0,0,0,119,0,0,0,0,0,0,0,48,4,0,0,168,0,0,0,170,0,0,0,119,0,0,0,24,0,0,0,10,0,0,0,11,0,0,0,12,0,0,0,30,0,0,0,25,0,0,0,31,0,0,0,26,0,0,0,32,0,0,0,13,0,0,0,27,0,0,0,14,0,0,0,0,0,0,0,80,4,0,0,168,0,0,0,171,0,0,0,119,0,0,0,5,0,0,0,6,0,0,0,15,0,0,0,57,0,0,0,58,0,0,0,16,0,0,0,59,0,0,0,0,0,0,0,112,4,0,0,168,0,0,0,172,0,0,0,119,0,0,0,7,0,0,0,8,0,0,0,17,0,0,0,60,0,0,0,61,0,0,0,18,0,0,0,62,0,0,0,0,0,0,0,144,4,0,0,168,0,0,0,173,0,0,0,119,0,0,0,9,0,0,0,10,0,0,0,19,0,0,0,63,0,0,0,64,0,0,0,20,0,0,0,65,0,0,0,0,0,0,0,176,4,0,0,168,0,0,0,174,0,0,0,119,0,0,0,9,0,0,0,10,0,0,0,19,0,0,0,63,0,0,0,64,0,0,0,20,0,0,0,65,0,0,0,0,0,0,0,192,4,0,0,168,0,0,0,175,0,0,0,119,0,0,0,9,0,0,0,10,0,0,0,19,0,0,0,63,0,0,0,64,0,0,0,20,0,0,0,65,0,0,0,0,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,37,0,0,0,109,0,0,0,47,0,0,0,37,0,0,0,100,0,0,0,47,0,0,0,37,0,0,0,121,0,0,0,37,0,0,0,89,0,0,0,45,0,0,0,37,0,0,0,109,0,0,0,45,0,0,0,37,0,0,0,100,0,0,0,37,0,0,0,73,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,32,0,0,0,37,0,0,0,112,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,116,0,0,0,114,0,0,0,117,0,0,0,101,0,0,0,0,0,0,0,102,0,0,0,97,0,0,0,108,0,0,0,115,0,0,0,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83,0,0,0,117,0,0,0,110,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,77,0,0,0,111,0,0,0,110,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,84,0,0,0,117,0,0,0,101,0,0,0,115,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,87,0,0,0,101,0,0,0,100,0,0,0,110,0,0,0,101,0,0,0,115,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,84,0,0,0,104,0,0,0,117,0,0,0,114,0,0,0,115,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,70,0,0,0,114,0,0,0,105,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,83,0,0,0,97,0,0,0,116,0,0,0,117,0,0,0,114,0,0,0,100,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,83,0,0,0,117,0,0,0,110,0,0,0,0,0,0,0,77,0,0,0,111,0,0,0,110,0,0,0,0,0,0,0,84,0,0,0,117,0,0,0,101,0,0,0,0,0,0,0,87,0,0,0,101,0,0,0,100,0,0,0,0,0,0,0,84,0,0,0,104,0,0,0,117,0,0,0,0,0,0,0,70,0,0,0,114,0,0,0,105,0,0,0,0,0,0,0,83,0,0,0,97,0,0,0,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,0,0,0,97,0,0,0,110,0,0,0,117,0,0,0,97,0,0,0,114,0,0,0,121,0,0,0,0,0,0,0,70,0,0,0,101,0,0,0,98,0,0,0,114,0,0,0,117,0,0,0,97,0,0,0,114,0,0,0,121,0,0,0,0,0,0,0,77,0,0,0,97,0,0,0,114,0,0,0,99,0,0,0,104,0,0,0,0,0,0,0,65,0,0,0,112,0,0,0,114,0,0,0,105,0,0,0,108,0,0,0,0,0,0,0,77,0,0,0,97,0,0,0,121,0,0,0,0,0,0,0,74,0,0,0,117,0,0,0,110,0,0,0,101,0,0,0,0,0,0,0,74,0,0,0,117,0,0,0,108,0,0,0,121,0,0,0,0,0,0,0,65,0,0,0,117,0,0,0,103,0,0,0,117,0,0,0,115,0,0,0,116,0,0,0,0,0,0,0,83,0,0,0,101,0,0,0,112,0,0,0,116,0,0,0,101,0,0,0,109,0,0,0,98,0,0,0,101,0,0,0,114,0,0,0,0,0,0,0,79,0,0,0,99,0,0,0,116,0,0,0,111,0,0,0,98,0,0,0,101,0,0,0,114,0,0,0,0,0,0,0,78,0,0,0,111,0,0,0,118,0,0,0,101,0,0,0,109,0,0,0,98,0,0,0,101,0,0,0,114,0,0,0,0,0,0,0,68,0,0,0,101,0,0,0,99,0,0,0,101,0,0,0,109,0,0,0,98,0,0,0,101,0,0,0,114,0,0,0,0,0,0,0,74,0,0,0,97,0,0,0,110,0,0,0,0,0,0,0,70,0,0,0,101,0,0,0,98,0,0,0,0,0,0,0,77,0,0,0,97,0,0,0,114,0,0,0,0,0,0,0,65,0,0,0,112,0,0,0,114,0,0,0,0,0,0,0,74,0,0,0,117,0,0,0,110,0,0,0,0,0,0,0,74,0,0,0,117,0,0,0,108,0,0,0,0,0,0,0,65,0,0,0,117,0,0,0,103,0,0,0,0,0,0,0,83,0,0,0,101,0,0,0,112,0,0,0,0,0,0,0,79,0,0,0,99,0,0,0,116,0,0,0,0,0,0,0,78,0,0,0,111,0,0,0,118,0,0,0,0,0,0,0,68,0,0,0,101,0,0,0,99,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,65,0,0,0,77,0,0,0,0,0,0,0,80,0,0,0,77,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,0,0,0,109,0,0,0,47,0,0,0,37,0,0,0,100,0,0,0,47,0,0,0,37,0,0,0,121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,0,0,0,97,0,0,0,32,0,0,0,37,0,0,0,98,0,0,0,32,0,0,0,37,0,0,0,100,0,0,0,32,0,0,0,37,0,0,0,72,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,32,0,0,0,37,0,0,0,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,0,0,0,73,0,0,0,58,0,0,0,37,0,0,0,77,0,0,0,58,0,0,0,37,0,0,0,83,0,0,0,32,0,0,0,37,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,3,32,2,32,2,32,2,32,2,32,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,1,96,4,192,4,192,4,192,4,192,4,192,4,192,4,192,4,192,4,192,4,192,4,192,4,192,4,192,4,192,4,192,8,216,8,216,8,216,8,216,8,216,8,216,8,216,8,216,8,216,8,216,4,192,4,192,4,192,4,192,4,192,4,192,4,192,8,213,8,213,8,213,8,213,8,213,8,213,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,8,197,4,192,4,192,4,192,4,192,4,192,4,192,8,214,8,214,8,214,8,214,8,214,8,214,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,8,198,4,192,4,192,4,192,4,192,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,97,119,83,116,114,101,97,109,32,111,114,32,114,97,119,68,97,116,97,32,110,101,101,100,115,32,116,111,32,114,101,102,101,114,101,110,99,101,32,116,111,32,115,111,109,101,116,104,105,110,103,0,119,105,100,116,104,32,110,101,101,100,115,32,116,111,32,98,101,32,105,110,32,116,104,101,32,114,97,110,103,101,32,91,49,44,32,54,53,53,51,53,93,0,104,101,105,103,104,116,32,110,101,101,100,115,32,116,111,32,98,101,32,105,110,32,116,104,101,32,114,97,110,103,101,32,91,49,44,32,54,53,53,51,53,93,0,98,105,116,115,112,101,114,115,97,109,112,108,101,32,110,101,101,100,115,32,116,111,32,98,101,32,105,110,32,116,104,101,32,114,97,110,103,101,32,91,50,44,32,49,54,93,0,105,110,116,101,114,108,101,97,118,101,77,111,100,101,32,110,101,101,100,115,32,116,111,32,98,101,32,115,101,116,32,116,111,32,97,32,118,97,108,117,101,32,111,102,32,123,78,111,110,101,44,32,83,97,109,112,108,101,44,32,76,105,110,101,125,0,99,111,109,112,111,110,101,110,116,115,32,110,101,101,100,115,32,116,111,32,98,101,32,105,110,32,116,104,101,32,114,97,110,103,101,32,91,49,44,32,50,53,53,93,0,117,110,99,111,109,112,114,101,115,115,101,100,32,115,105,122,101,32,100,111,101,115,32,110,111,116,32,109,97,116,99,104,32,119,105,116,104,32,116,104,101,32,111,116,104,101,114,32,112,97,114,97,109,101,116,101,114,115,0,105,110,116,101,114,108,101,97,118,101,77,111,100,101,32,99,97,110,110,111,116,32,98,101,32,115,101,116,32,116,111,32,83,97,109,112,108,101,32,105,110,32,99,111,109,98,105,110,97,116,105,111,110,32,119,105,116,104,32,99,111,109,112,111,110,101,110,116,115,32,61,32,52,0,105,110,116,101,114,108,101,97,118,101,77,111,100,101,32,99,97,110,32,111,110,108,121,32,98,101,32,115,101,116,32,116,111,32,78,111,110,101,32,105,110,32,99,111,109,98,105,110,97,116,105,111,110,32,119,105,116,104,32,99,111,109,112,111,110,101,110,116,115,32,61,32,49,0,67,111,108,111,114,32,116,114,97,110,115,102,111,114,109,97,116,105,111,110,32,0,78,111,32,109,111,114,101,32,98,121,116,101,115,32,97,118,97,105,108,97,98,108,101,32,105,110,32,105,110,112,117,116,32,98,117,102,102,101,114,44,32,115,116,105,108,108,32,110,101,101,100,101,100,105,110,103,32,0,65,110,32,111,100,100,32,110,117,109,98,101,114,32,111,102,32,98,121,116,101,115,32,40,0,41,32,99,97,110,110,111,116,32,98,101,32,115,119,97,112,112,101,100,46,0,49,56,80,114,111,99,101,115,115,84,114,97,110,115,102,111,114,109,101,100,73,49,54,84,114,97,110,115,102,111,114,109,83,104,105,102,116,101,100,73,49,50,84,114,97,110,115,102,111,114,109,72,112,51,73,116,69,69,69,0,49,49,80,114,111,99,101,115,115,76,105,110,101,0,49,56,80,114,111,99,101,115,115,84,114,97,110,115,102,111,114,109,101,100,73,49,54,84,114,97,110,115,102,111,114,109,83,104,105,102,116,101,100,73,49,50,84,114,97,110,115,102,111,114,109,72,112,50,73,116,69,69,69,0,49,56,80,114,111,99,101,115,115,84,114,97,110,115,102,111,114,109,101,100,73,49,54,84,114,97,110,115,102,111,114,109,83,104,105,102,116,101,100,73,49,50,84,114,97,110,115,102,111,114,109,72,112,49,73,116,69,69,69,0,78,83,116,51,95,95,49,49,53,98,97,115,105,99,95,115,116,114,105,110,103,98,117,102,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,0,78,83,116,51,95,95,49,49,57,98,97,115,105,99,95,111,115,116,114,105,110,103,115,116,114,101,97,109,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,78,83,95,57,97,108,108,111,99,97,116,111,114,73,99,69,69,69,69,0,49,56,80,114,111,99,101,115,115,84,114,97,110,115,102,111,114,109,101,100,73,49,50,84,114,97,110,115,102,111,114,109,72,112,51,73,116,69,69,0,49,56,80,114,111,99,101,115,115,84,114,97,110,115,102,111,114,109,101,100,73,49,50,84,114,97,110,115,102,111,114,109,72,112,50,73,116,69,69,0,49,56,80,114,111,99,101,115,115,84,114,97,110,115,102,111,114,109,101,100,73,49,50,84,114,97,110,115,102,111,114,109,72,112,49,73,116,69,69,0,49,56,80,114,111,99,101,115,115,84,114,97,110,115,102,111,114,109,101,100,73,49,51,84,114,97,110,115,102,111,114,109,78,111,110,101,73,116,69,69,0,50,50,80,111,115,116,80,114,111,99,101,115,83,105,110,103,108,101,83,116,114,101,97,109,0,50,53,80,111,115,116,80,114,111,99,101,115,83,105,110,103,108,101,67,111,109,112,111,110,101,110,116,0,49,53,69,110,99,111,100,101,114,83,116,114,97,116,101,103,121,0,56,74,108,115,67,111,100,101,99,73,49,52,68,101,102,97,117,108,116,84,114,97,105,116,115,84,73,116,116,69,49,53,69,110,99,111,100,101,114,83,116,114,97,116,101,103,121,69,0,56,74,108,115,67,111,100,101,99,73,49,52,68,101,102,97,117,108,116,84,114,97,105,116,115,84,73,116,55,84,114,105,112,108,101,116,73,116,69,69,49,53,69,110,99,111,100,101,114,83,116,114,97,116,101,103,121,69,0,49,56,80,114,111,99,101,115,115,84,114,97,110,115,102,111,114,109,101,100,73,49,50,84,114,97,110,115,102,111,114,109,72,112,51,73,104,69,69,0,49,56,80,114,111,99,101,115,115,84,114,97,110,115,102,111,114,109,101,100,73,49,50,84,114,97,110,115,102,111,114,109,72,112,50,73,104,69,69,0,49,56,80,114,111,99,101,115,115,84,114,97,110,115,102,111,114,109,101,100,73,49,50,84,114,97,110,115,102,111,114,109,72,112,49,73,104,69,69,0,49,56,80,114,111,99,101,115,115,84,114,97,110,115,102,111,114,109,101,100,73,49,51,84,114,97,110,115,102,111,114,109,78,111,110,101,73,104,69,69,0,56,74,108,115,67,111,100,101,99,73,49,52,68,101,102,97,117,108,116,84,114,97,105,116,115,84,73,104,55,84,114,105,112,108,101,116,73,104,69,69,49,53,69,110,99,111,100,101,114,83,116,114,97,116,101,103,121,69,0,56,74,108,115,67,111,100,101,99,73,49,53,76,111,115,115,108,101,115,115,84,114,97,105,116,115,84,73,116,76,105,49,54,69,69,49,53,69,110,99,111,100,101,114,83,116,114,97,116,101,103,121,69,0,56,74,108,115,67,111,100,101,99,73,49,53,76,111,115,115,108,101,115,115,84,114,97,105,116,115,84,73,116,76,105,49,50,69,69,49,53,69,110,99,111,100,101,114,83,116,114,97,116,101,103,121,69,0,56,74,108,115,67,111,100,101,99,73,49,53,76,111,115,115,108,101,115,115,84,114,97,105,116,115,84,73,104,76,105,56,69,69,49,53,69,110,99,111,100,101,114,83,116,114,97,116,101,103,121,69,0,56,74,108,115,67,111,100,101,99,73,49,53,76,111,115,115,108,101,115,115,84,114,97,105,116,115,84,73,55,84,114,105,112,108,101,116,73,104,69,76,105,56,69,69,49,53,69,110,99,111,100,101,114,83,116,114,97,116,101,103,121,69,0,56,74,108,115,67,111,100,101,99,73,49,52,68,101,102,97,117,108,116,84,114,97,105,116,115,84,73,104,104,69,49,53,69,110,99,111,100,101,114,83,116,114,97,116,101,103,121,69,0,49,53,68,101,99,111,100,101,114,83,116,114,97,116,101,103,121,0,56,74,108,115,67,111,100,101,99,73,49,52,68,101,102,97,117,108,116,84,114,97,105,116,115,84,73,116,116,69,49,53,68,101,99,111,100,101,114,83,116,114,97,116,101,103,121,69,0,56,74,108,115,67,111,100,101,99,73,49,52,68,101,102,97,117,108,116,84,114,97,105,116,115,84,73,116,55,84,114,105,112,108,101,116,73,116,69,69,49,53,68,101,99,111,100,101,114,83,116,114,97,116,101,103,121,69,0,56,74,108,115,67,111,100,101,99,73,49,52,68,101,102,97,117,108,116,84,114,97,105,116,115,84,73,104,55,84,114,105,112,108,101,116,73,104,69,69,49,53,68,101,99,111,100,101,114,83,116,114,97,116,101,103,121,69,0,56,74,108,115,67,111,100,101,99,73,49,53,76,111,115,115,108,101,115,115,84,114,97,105,116,115,84,73,116,76,105,49,54,69,69,49,53,68,101,99,111,100,101,114,83,116,114,97,116,101,103,121,69,0,56,74,108,115,67,111,100,101,99,73,49,53,76,111,115,115,108,101,115,115,84,114,97,105,116,115,84,73,116,76,105,49,50,69,69,49,53,68,101,99,111,100,101,114,83,116,114,97,116,101,103,121,69,0,56,74,108,115,67,111,100,101,99,73,49,53,76,111,115,115,108,101,115,115,84,114,97,105,116,115,84,73,104,76,105,56,69,69,49,53,68,101,99,111,100,101,114,83,116,114,97,116,101,103,121,69,0,56,74,108,115,67,111,100,101,99,73,49,53,76,111,115,115,108,101,115,115,84,114,97,105,116,115,84,73,55,84,114,105,112,108,101,116,73,104,69,76,105,56,69,69,49,53,68,101,99,111,100,101,114,83,116,114,97,116,101,103,121,69,0,56,74,108,115,67,111,100,101,99,73,49,52,68,101,102,97,117,108,116,84,114,97,105,116,115,84,73,104,104,69,49,53,68,101,99,111,100,101,114,83,116,114,97,116,101,103,121,69,0,67,104,97,114,76,83,32,101,114,114,111,114,0,99,104,97,114,108,115,0,49,53,99,104,97,114,108,115,95,99,97,116,101,103,111,114,121,0,112,97,114,97,109,115,46,88,116,104,117,109,98,110,97,105,108,32,105,115,32,62,32,48,32,98,117,116,32,112,97,114,97,109,115,46,116,104,117,109,98,110,97,105,108,32,61,61,32,110,117,108,108,95,112,116,114,0,49,55,74,112,101,103,77,97,114,107,101,114,83,101,103,109,101,110,116,0,49,49,74,112,101,103,83,101,103,109,101,110,116,0,50,48,74,112,101,103,73,109,97,103,101,68,97,116,97,83,101,103,109,101,110,116,0,69,120,112,101,99,116,101,100,32,74,80,69,71,32,77,97,114,107,101,114,32,115,116,97,114,116,32,98,121,116,101,32,48,120,70,70,32,98,117,116,32,116,104,101,32,98,121,116,101,32,118,97,108,117,101,32,119,97,115,32,48,120,0,74,80,69,71,32,101,110,99,111,100,105,110,103,32,119,105,116,104,32,109,97,114,107,101,114,32,0,32,105,115,32,110,111,116,32,115,117,112,112,111,114,116,101,100,46,0,85,110,107,110,111,119,110,32,74,80,69,71,32,109,97,114,107,101,114,32,0,32,101,110,99,111,117,110,116,101,114,101,100,46,0,109,114,102,120,0,83,116,57,98,97,100,95,97,108,108,111,99,0,83,116,57,101,120,99,101,112,116,105,111,110,0,83,116,49,51,114,117,110,116,105,109,101,95,101,114,114,111,114,0,83,116,57,116,121,112,101,95,105,110,102,111,0,83,116,56,98,97,100,95,99,97,115,116,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,54,95,95,115,104,105,109,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,57,95,95,112,111,105,110,116,101,114,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,112,98,97,115,101,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,48,95,95,115,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,49,95,95,118,109,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,33,34,98,97,115,105,99,95,115,116,114,105,110,103,32,108,101,110,103,116,104,95,101,114,114,111,114,34,0,47,85,115,101,114,115,47,99,104,97,102,101,121,47,101,109,115,100,107,95,112,111,114,116,97,98,108,101,47,101,109,115,99,114,105,112,116,101,110,47,49,46,51,53,46,48,47,115,121,115,116,101,109,47,105,110,99,108,117,100,101,47,108,105,98,99,120,120,47,115,116,114,105,110,103,0,95,95,116,104,114,111,119,95,108,101,110,103,116,104,95,101,114,114,111,114,0,33,34,118,101,99,116,111,114,32,108,101,110,103,116,104,95,101,114,114,111,114,34,0,47,85,115,101,114,115,47,99,104,97,102,101,121,47,101,109,115,100,107,95,112,111,114,116,97,98,108,101,47,101,109,115,99,114,105,112,116,101,110,47,49,46,51,53,46,48,47,115,121,115,116,101,109,47,105,110,99,108,117,100,101,47,108,105,98,99,120,120,47,118,101,99,116,111,114,0,112,116,104,114,101,97,100,95,111,110,99,101,32,102,97,105,108,117,114,101,32,105,110,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,95,102,97,115,116,40,41,0,115,116,100,58,58,98,97,100,95,97,108,108,111,99,0,116,101,114,109,105,110,97,116,101,95,104,97,110,100,108,101,114,32,117,110,101,120,112,101,99,116,101,100,108,121,32,114,101,116,117,114,110,101,100,0,116,101,114,109,105,110,97,116,101,95,104,97,110,100,108,101,114,32,117,110,101,120,112,101,99,116,101,100,108,121,32,116,104,114,101,119,32,97,110,32,101,120,99,101,112,116,105,111,110,0,115,116,100,58,58,98,97,100,95,99,97,115,116,0,99,97,110,110,111,116,32,99,114,101,97,116,101,32,112,116,104,114,101,97,100,32,107,101,121,32,102,111,114,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,40,41,0,99,97,110,110,111,116,32,122,101,114,111,32,111,117,116,32,116,104,114,101,97,100,32,118,97,108,117,101,32,102,111,114,32,95,95,99,120,97,95,103,101,116,95,103,108,111,98,97,108,115,40,41,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,101,120,99,101,112,116,105,111,110,32,111,102,32,116,121,112,101,32,37,115,58,32,37,115,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,101,120,99,101,112,116,105,111,110,32,111,102,32,116,121,112,101,32,37,115,0,116,101,114,109,105,110,97,116,105,110,103,32,119,105,116,104,32,37,115,32,102,111,114,101,105,103,110,32,101,120,99,101,112,116,105,111,110,0,116,101,114,109,105,110,97,116,105,110,103,0,117,110,99,97,117,103,104,116,0,84,33,34,25,13,1,2,3,17,75,28,12,16,4,11,29,18,30,39,104,110,111,112,113,98,32,5,6,15,19,20,21,26,8,22,7,40,36,23,24,9,10,14,27,31,37,35,131,130,125,38,42,43,60,61,62,63,67,71,74,77,88,89,90,91,92,93,94,95,96,97,99,100,101,102,103,105,106,107,108,114,115,116,121,122,123,124,0,73,108,108,101,103,97,108,32,98,121,116,101,32,115,101,113,117,101,110,99,101,0,68,111,109,97,105,110,32,101,114,114,111,114,0,82,101,115,117,108,116,32,110,111,116,32,114,101,112,114,101,115,101,110,116,97,98,108,101,0,78,111,116,32,97,32,116,116,121,0,80,101,114,109,105,115,115,105,111,110,32,100,101,110,105,101,100,0,79,112,101,114,97,116,105,111,110,32,110,111,116,32,112,101,114,109,105,116,116,101,100,0,78,111,32,115,117,99,104,32,102,105,108,101,32,111,114,32,100,105,114,101,99,116,111,114,121,0,78,111,32,115,117,99,104,32,112,114,111,99,101,115,115,0,70,105,108,101,32,101,120,105,115,116,115,0,86,97,108,117,101,32,116,111,111,32,108,97,114,103,101,32,102,111,114,32,100,97,116,97,32,116,121,112,101,0,78,111,32,115,112,97,99,101,32,108,101,102,116,32,111,110,32,100,101,118,105,99,101,0,79,117,116,32,111,102,32,109,101,109,111,114,121,0,82,101,115,111,117,114,99,101,32,98,117,115,121,0,73,110,116,101,114,114,117,112,116,101,100,32,115,121,115,116,101,109,32,99,97,108,108,0,82,101,115,111,117,114,99,101,32,116,101,109,112,111,114,97,114,105,108,121,32,117,110,97,118,97,105,108,97,98,108,101,0,73,110,118,97,108,105,100,32,115,101,101,107,0,67,114,111,115,115,45,100,101,118,105,99,101,32,108,105,110,107,0,82,101,97,100,45,111,110,108,121,32,102,105,108,101,32,115,121,115,116,101,109,0,68,105,114,101,99,116,111,114,121,32,110,111,116,32,101,109,112,116,121,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,112,101,101,114,0,79,112,101,114,97,116,105,111,110,32,116,105,109,101,100,32,111,117,116,0,67,111,110,110,101,99,116,105,111,110,32,114,101,102,117,115,101,100,0,72,111,115,116,32,105,115,32,100,111,119,110,0,72,111,115,116,32,105,115,32,117,110,114,101,97,99,104,97,98,108,101,0,65,100,100,114,101,115,115,32,105,110,32,117,115,101,0,66,114,111,107,101,110,32,112,105,112,101,0,73,47,79,32,101,114,114,111,114,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,32,111,114,32,97,100,100,114,101,115,115,0,66,108,111,99,107,32,100,101,118,105,99,101,32,114,101,113,117,105,114,101,100,0,78,111,32,115,117,99,104,32,100,101,118,105,99,101,0,78,111,116],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+42396);allocate([32,97,32,100,105,114,101,99,116,111,114,121,0,73,115,32,97,32,100,105,114,101,99,116,111,114,121,0,84,101,120,116,32,102,105,108,101,32,98,117,115,121,0,69,120,101,99,32,102,111,114,109,97,116,32,101,114,114,111,114,0,73,110,118,97,108,105,100,32,97,114,103,117,109,101,110,116,0,65,114,103,117,109,101,110,116,32,108,105,115,116,32,116,111,111,32,108,111,110,103,0,83,121,109,98,111,108,105,99,32,108,105,110,107,32,108,111,111,112,0,70,105,108,101,110,97,109,101,32,116,111,111,32,108,111,110,103,0,84,111,111,32,109,97,110,121,32,111,112,101,110,32,102,105,108,101,115,32,105,110,32,115,121,115,116,101,109,0,78,111,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,115,32,97,118,97,105,108,97,98,108,101,0,66,97,100,32,102,105,108,101,32,100,101,115,99,114,105,112,116,111,114,0,78,111,32,99,104,105,108,100,32,112,114,111,99,101,115,115,0,66,97,100,32,97,100,100,114,101,115,115,0,70,105,108,101,32,116,111,111,32,108,97,114,103,101,0,84,111,111,32,109,97,110,121,32,108,105,110,107,115,0,78,111,32,108,111,99,107,115,32,97,118,97,105,108,97,98,108,101,0,82,101,115,111,117,114,99,101,32,100,101,97,100,108,111,99,107,32,119,111,117,108,100,32,111,99,99,117,114,0,83,116,97,116,101,32,110,111,116,32,114,101,99,111,118,101,114,97,98,108,101,0,80,114,101,118,105,111,117,115,32,111,119,110,101,114,32,100,105,101,100,0,79,112,101,114,97,116,105,111,110,32,99,97,110,99,101,108,101,100,0,70,117,110,99,116,105,111,110,32,110,111,116,32,105,109,112,108,101,109,101,110,116,101,100,0,78,111,32,109,101,115,115,97,103,101,32,111,102,32,100,101,115,105,114,101,100,32,116,121,112,101,0,73,100,101,110,116,105,102,105,101,114,32,114,101,109,111,118,101,100,0,68,101,118,105,99,101,32,110,111,116,32,97,32,115,116,114,101,97,109,0,78,111,32,100,97,116,97,32,97,118,97,105,108,97,98,108,101,0,68,101,118,105,99,101,32,116,105,109,101,111,117,116,0,79,117,116,32,111,102,32,115,116,114,101,97,109,115,32,114,101,115,111,117,114,99,101,115,0,76,105,110,107,32,104,97,115,32,98,101,101,110,32,115,101,118,101,114,101,100,0,80,114,111,116,111,99,111,108,32,101,114,114,111,114,0,66,97,100,32,109,101,115,115,97,103,101,0,70,105,108,101,32,100,101,115,99,114,105,112,116,111,114,32,105,110,32,98,97,100,32,115,116,97,116,101,0,78,111,116,32,97,32,115,111,99,107,101,116,0,68,101,115,116,105,110,97,116,105,111,110,32,97,100,100,114,101,115,115,32,114,101,113,117,105,114,101,100,0,77,101,115,115,97,103,101,32,116,111,111,32,108,97,114,103,101,0,80,114,111,116,111,99,111,108,32,119,114,111,110,103,32,116,121,112,101,32,102,111,114,32,115,111,99,107,101,116,0,80,114,111,116,111,99,111,108,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,80,114,111,116,111,99,111,108,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,83,111,99,107,101,116,32,116,121,112,101,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,78,111,116,32,115,117,112,112,111,114,116,101,100,0,80,114,111,116,111,99,111,108,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,65,100,100,114,101,115,115,32,102,97,109,105,108,121,32,110,111,116,32,115,117,112,112,111,114,116,101,100,32,98,121,32,112,114,111,116,111,99,111,108,0,65,100,100,114,101,115,115,32,110,111,116,32,97,118,97,105,108,97,98,108,101,0,78,101,116,119,111,114,107,32,105,115,32,100,111,119,110,0,78,101,116,119,111,114,107,32,117,110,114,101,97,99,104,97,98,108,101,0,67,111,110,110,101,99,116,105,111,110,32,114,101,115,101,116,32,98,121,32,110,101,116,119,111,114,107,0,67,111,110,110,101,99,116,105,111,110,32,97,98,111,114,116,101,100,0,78,111,32,98,117,102,102,101,114,32,115,112,97,99,101,32,97,118,97,105,108,97,98,108,101,0,83,111,99,107,101,116,32,105,115,32,99,111,110,110,101,99,116,101,100,0,83,111,99,107,101,116,32,110,111,116,32,99,111,110,110,101,99,116,101,100,0,67,97,110,110,111,116,32,115,101,110,100,32,97,102,116,101,114,32,115,111,99,107,101,116,32,115,104,117,116,100,111,119,110,0,79,112,101,114,97,116,105,111,110,32,97,108,114,101,97,100,121,32,105,110,32,112,114,111,103,114,101,115,115,0,79,112,101,114,97,116,105,111,110,32,105,110,32,112,114,111,103,114,101,115,115,0,83,116,97,108,101,32,102,105,108,101,32,104,97,110,100,108,101,0,82,101,109,111,116,101,32,73,47,79,32,101,114,114,111,114,0,81,117,111,116,97,32,101,120,99,101,101,100,101,100,0,78,111,32,109,101,100,105,117,109,32,102,111,117,110,100,0,87,114,111,110,103,32,109,101,100,105,117,109,32,116,121,112,101,0,78,111,32,101,114,114,111,114,32,105,110,102,111,114,109,97,116,105,111,110,0,0,105,110,102,105,110,105,116,121,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,1,2,3,4,5,6,7,8,9,255,255,255,255,255,255,255,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,255,255,255,255,255,255,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,1,2,4,7,3,6,5,0,80,79,83,73,88],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+52636);allocate([17,0,10,0,17,17,17,0,0,0,0,5,0,0,0,0,0,0,9,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,15,10,17,17,17,3,10,7,0,1,19,9,11,11,0,0,9,6,11,0,0,11,0,6,17,0,0,0,17,17,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,17,0,10,10,17,17,17,0,10,0,0,2,0,9,11,0,0,0,9,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,0,0,0,0,0,0,0,0,0,0,0,13,0,0,0,4,13,0,0,0,0,9,14,0,0,0,0,0,14,0,0,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,15,0,0,0,0,15,0,0,0,0,9,16,0,0,0,0,0,16,0,0,16,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,0,0,0,18,18,18,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,0,0,0,0,0,0,0,0,0,0,10,0,0,0,0,10,0,0,0,0,9,11,0,0,0,0,0,11,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,0,12,0,0,0,0,9,12,0,0,0,0,0,12,0,0,12,0,0,48,49,50,51,52,53,54,55,56,57,65,66,67,68,69,70,45,43,32,32,32,48,88,48,120,0,40,110,117,108,108,41,0,45,48,88,43,48,88,32,48,88,45,48,120,43,48,120,32,48,120,0,105,110,102,0,73,78,70,0,110,97,110,0,78,65,78,0,46,0,0,78,83,116,51,95,95,49,49,49,95,95,115,116,100,111,117,116,98,117,102,73,119,69,69,0,117,110,115,117,112,112,111,114,116,101,100,32,108,111,99,97,108,101,32,102,111,114,32,115,116,97,110,100,97,114,100,32,105,110,112,117,116,0,78,83,116,51,95,95,49,49,48,95,95,115,116,100,105,110,98,117,102,73,119,69,69,0,78,83,116,51,95,95,49,49,49,95,95,115,116,100,111,117,116,98,117,102,73,99,69,69,0,78,83,116,51,95,95,49,49,48,95,95,115,116,100,105,110,98,117,102,73,99,69,69,0,78,83,116,51,95,95,49,49,52,95,95,115,104,97,114,101,100,95,99,111,117,110,116,69,0,78,83,116,51,95,95,49,49,50,115,121,115,116,101,109,95,101,114,114,111,114,69,0,78,83,116,51,95,95,49,49,52,101,114,114,111,114,95,99,97,116,101,103,111,114,121,69,0,78,83,116,51,95,95,49,49,50,95,95,100,111,95,109,101,115,115,97,103,101,69,0,58,32,0,78,83,116,51,95,95,49,56,105,111,115,95,98,97,115,101,55,102,97,105,108,117,114,101,69,0,78,83,116,51,95,95,49,56,105,111,115,95,98,97,115,101,69,0,78,83,116,51,95,95,49,57,98,97,115,105,99,95,105,111,115,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,0,78,83,116,51,95,95,49,57,98,97,115,105,99,95,105,111,115,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,0,78,83,116,51,95,95,49,49,53,98,97,115,105,99,95,115,116,114,101,97,109,98,117,102,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,0,78,83,116,51,95,95,49,49,53,98,97,115,105,99,95,115,116,114,101,97,109,98,117,102,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,0,78,83,116,51,95,95,49,49,51,98,97,115,105,99,95,105,115,116,114,101,97,109,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,0,78,83,116,51,95,95,49,49,51,98,97,115,105,99,95,105,115,116,114,101,97,109,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,0,78,83,116,51,95,95,49,49,51,98,97,115,105,99,95,111,115,116,114,101,97,109,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,0,78,83,116,51,95,95,49,49,51,98,97,115,105,99,95,111,115,116,114,101,97,109,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,0,78,83,116,51,95,95,49,49,57,95,95,105,111,115,116,114,101,97,109,95,99,97,116,101,103,111,114,121,69,0,105,111,115,95,98,97,115,101,58,58,99,108,101,97,114,0,105,111,115,116,114,101,97,109,0,117,110,115,112,101,99,105,102,105,101,100,32,105,111,115,116,114,101,97,109,95,99,97,116,101,103,111,114,121,32,101,114,114,111,114,0,48,49,50,51,52,53,54,55,56,57,97,98,99,100,101,102,65,66,67,68,69,70,120,88,43,45,112,80,105,73,110,78,0,78,83,116,51,95,95,49,54,108,111,99,97,108,101,53,102,97,99,101,116,69,0,78,83,116,51,95,95,49,53,99,116,121,112,101,73,119,69,69,0,78,83,116,51,95,95,49,55,99,111,100,101,99,118,116,73,99,99,49,49,95,95,109,98,115,116,97,116,101,95,116,69,69,0,78,83,116,51,95,95,49,55,99,111,100,101,99,118,116,73,68,115,99,49,49,95,95,109,98,115,116,97,116,101,95,116,69,69,0,78,83,116,51,95,95,49,55,99,111,100,101,99,118,116,73,68,105,99,49,49,95,95,109,98,115,116,97,116,101,95,116,69,69,0,78,83,116,51,95,95,49,49,54,95,95,110,97,114,114,111,119,95,116,111,95,117,116,102,56,73,76,106,51,50,69,69,69,0,78,83,116,51,95,95,49,49,55,95,95,119,105,100,101,110,95,102,114,111,109,95,117,116,102,56,73,76,106,51,50,69,69,69,0,78,83,116,51,95,95,49,55,99,111,100,101,99,118,116,73,119,99,49,49,95,95,109,98,115,116,97,116,101,95,116,69,69,0,78,83,116,51,95,95,49,54,108,111,99,97,108,101,53,95,95,105,109,112,69,0,78,83,116,51,95,95,49,55,99,111,108,108,97,116,101,73,99,69,69,0,78,83,116,51,95,95,49,55,99,111,108,108,97,116,101,73,119,69,69,0,78,83,116,51,95,95,49,53,99,116,121,112,101,73,99,69,69,0,78,83,116,51,95,95,49,56,110,117,109,112,117,110,99,116,73,99,69,69,0,78,83,116,51,95,95,49,56,110,117,109,112,117,110,99,116,73,119,69,69,0,78,83,116,51,95,95,49,55,110,117,109,95,103,101,116,73,99,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,78,83,116,51,95,95,49,55,110,117,109,95,103,101,116,73,119,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,78,83,116,51,95,95,49,55,110,117,109,95,112,117,116,73,99,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,78,83,116,51,95,95,49,55,110,117,109,95,112,117,116,73,119,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,78,83,116,51,95,95,49,56,116,105,109,101,95,103,101,116,73,99,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,78,83,116,51,95,95,49,56,116,105,109,101,95,103,101,116,73,119,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,78,83,116,51,95,95,49,56,116,105,109,101,95,112,117,116,73,99,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,78,83,116,51,95,95,49,56,116,105,109,101,95,112,117,116,73,119,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,112,117,110,99,116,73,99,76,98,48,69,69,69,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,112,117,110,99,116,73,99,76,98,49,69,69,69,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,112,117,110,99,116,73,119,76,98,48,69,69,69,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,112,117,110,99,116,73,119,76,98,49,69,69,69,0,78,83,116,51,95,95,49,57,109,111,110,101,121,95,103,101,116,73,99,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,78,83,116,51,95,95,49,57,109,111,110,101,121,95,103,101,116,73,119,78,83,95,49,57,105,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,78,83,116,51,95,95,49,57,109,111,110,101,121,95,112,117,116,73,99,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,99,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,99,69,69,69,69,69,69,0,78,83,116,51,95,95,49,57,109,111,110,101,121,95,112,117,116,73,119,78,83,95,49,57,111,115,116,114,101,97,109,98,117,102,95,105,116,101,114,97,116,111,114,73,119,78,83,95,49,49,99,104,97,114,95,116,114,97,105,116,115,73,119,69,69,69,69,69,69,0,78,83,116,51,95,95,49,56,109,101,115,115,97,103,101,115,73,99,69,69,0,78,83,116,51,95,95,49,56,109,101,115,115,97,103,101,115,73,119,69,69,0,37,112,0,67,0,37,0,0,0,0,0,108,0,108,108,0,0,76,0,37,112,0,0,0,0,37,72,58,37,77,58,37,83,37,109,47,37,100,47,37,121,37,89,45,37,109,45,37,100,37,73,58,37,77,58,37,83,32,37,112,37,72,58,37,77,37,72,58,37,77,58,37,83,108,111,99,97,108,101,32,110,111,116,32,115,117,112,112,111,114,116,101,100,0,48,49,50,51,52,53,54,55,56,57,0,37,76,102,0,109,111,110,101,121,95,103,101,116,32,101,114,114,111,114,0,48,49,50,51,52,53,54,55,56,57,0,37,46,48,76,102,0,116,114,117,101,0,102,97,108,115,101,0,83,117,110,100,97,121,0,77,111,110,100,97,121,0,84,117,101,115,100,97,121,0,87,101,100,110,101,115,100,97,121,0,84,104,117,114,115,100,97,121,0,70,114,105,100,97,121,0,83,97,116,117,114,100,97,121,0,83,117,110,0,77,111,110,0,84,117,101,0,87,101,100,0,84,104,117,0,70,114,105,0,83,97,116,0,74,97,110,117,97,114,121,0,70,101,98,114,117,97,114,121,0,77,97,114,99,104,0,65,112,114,105,108,0,77,97,121,0,74,117,110,101,0,74,117,108,121,0,65,117,103,117,115,116,0,83,101,112,116,101,109,98,101,114,0,79,99,116,111,98,101,114,0,78,111,118,101,109,98,101,114,0,68,101,99,101,109,98,101,114,0,74,97,110,0,70,101,98,0,77,97,114,0,65,112,114,0,74,117,110,0,74,117,108,0,65,117,103,0,83,101,112,0,79,99,116,0,78,111,118,0,68,101,99,0,65,77,0,80,77,0,37,109,47,37,100,47,37,121,0,37,72,58,37,77,58,37,83,0,37,97,32,37,98,32,37,100,32,37,72,58,37,77,58,37,83,32,37,89,0,37,73,58,37,77,58,37,83,32,37,112,0,78,83,116,51,95,95,49,49,51,109,101,115,115,97,103,101,115,95,98,97,115,101,69,0,78,83,116,51,95,95,49,49,49,95,95,109,111,110,101,121,95,112,117,116,73,119,69,69,0,78,83,116,51,95,95,49,49,49,95,95,109,111,110,101,121,95,112,117,116,73,99,69,69,0,78,83,116,51,95,95,49,49,49,95,95,109,111,110,101,121,95,103,101,116,73,119,69,69,0,78,83,116,51,95,95,49,49,49,95,95,109,111,110,101,121,95,103,101,116,73,99,69,69,0,78,83,116,51,95,95,49,49,48,109,111,110,101,121,95,98,97,115,101,69,0,78,83,116,51,95,95,49,49,48,95,95,116,105,109,101,95,112,117,116,69,0,78,83,116,51,95,95,49,50,48,95,95,116,105,109,101,95,103,101,116,95,99,95,115,116,111,114,97,103,101,73,119,69,69,0,78,83,116,51,95,95,49,50,48,95,95,116,105,109,101,95,103,101,116,95,99,95,115,116,111,114,97,103,101,73,99,69,69,0,78,83,116,51,95,95,49,57,116,105,109,101,95,98,97,115,101,69,0,78,83,116,51,95,95,49,57,95,95,110,117,109,95,112,117,116,73,119,69,69,0,78,83,116,51,95,95,49,49,52,95,95,110,117,109,95,112,117,116,95,98,97,115,101,69,0,78,83,116,51,95,95,49,57,95,95,110,117,109,95,112,117,116,73,99,69,69,0,78,83,116,51,95,95,49,57,95,95,110,117,109,95,103,101,116,73,119,69,69,0,78,83,116,51,95,95,49,49,52,95,95,110,117,109,95,103,101,116,95,98,97,115,101,69,0,78,83,116,51,95,95,49,57,95,95,110,117,109,95,103,101,116,73,99,69,69,0,78,83,116,51,95,95,49,49,50,99,111,100,101,99,118,116,95,98,97,115,101,69,0,78,83,116,51,95,95,49,49,48,99,116,121,112,101,95,98,97,115,101,69,0],"i8",ALLOC_NONE,Runtime.GLOBAL_BASE+56215);var tempDoublePtr=Runtime.alignMemory(allocate(12,"i8",ALLOC_STATIC),8);assert(tempDoublePtr%8==0);function copyTempFloat(ptr){HEAP8[tempDoublePtr]=HEAP8[ptr];HEAP8[tempDoublePtr+1]=HEAP8[ptr+1];HEAP8[tempDoublePtr+2]=HEAP8[ptr+2];HEAP8[tempDoublePtr+3]=HEAP8[ptr+3]}function copyTempDouble(ptr){HEAP8[tempDoublePtr]=HEAP8[ptr];HEAP8[tempDoublePtr+1]=HEAP8[ptr+1];HEAP8[tempDoublePtr+2]=HEAP8[ptr+2];HEAP8[tempDoublePtr+3]=HEAP8[ptr+3];HEAP8[tempDoublePtr+4]=HEAP8[ptr+4];HEAP8[tempDoublePtr+5]=HEAP8[ptr+5];HEAP8[tempDoublePtr+6]=HEAP8[ptr+6];HEAP8[tempDoublePtr+7]=HEAP8[ptr+7]}function _atexit(func,arg){__ATEXIT__.unshift({func:func,arg:arg})}function ___cxa_atexit(){return _atexit.apply(null,arguments)}Module["_i64Subtract"]=_i64Subtract;function ___assert_fail(condition,filename,line,func){ABORT=true;throw"Assertion failed: "+Pointer_stringify(condition)+", at: "+[filename?Pointer_stringify(filename):"unknown filename",line,func?Pointer_stringify(func):"unknown function"]+" at "+stackTrace()}function __ZSt18uncaught_exceptionv(){return!!__ZSt18uncaught_exceptionv.uncaught_exception}var EXCEPTIONS={last:0,caught:[],infos:{},deAdjust:(function(adjusted){if(!adjusted||EXCEPTIONS.infos[adjusted])return adjusted;for(var ptr in EXCEPTIONS.infos){var info=EXCEPTIONS.infos[ptr];if(info.adjusted===adjusted){return ptr}}return adjusted}),addRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount++}),decRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];assert(info.refcount>0);info.refcount--;if(info.refcount===0){if(info.destructor){Runtime.dynCall("vi",info.destructor,[ptr])}delete EXCEPTIONS.infos[ptr];___cxa_free_exception(ptr)}}),clearRef:(function(ptr){if(!ptr)return;var info=EXCEPTIONS.infos[ptr];info.refcount=0})};function ___resumeException(ptr){if(!EXCEPTIONS.last){EXCEPTIONS.last=ptr}EXCEPTIONS.clearRef(EXCEPTIONS.deAdjust(ptr));throw ptr}function ___cxa_find_matching_catch(){var thrown=EXCEPTIONS.last;if(!thrown){return(asm["setTempRet0"](0),0)|0}var info=EXCEPTIONS.infos[thrown];var throwntype=info.type;if(!throwntype){return(asm["setTempRet0"](0),thrown)|0}var typeArray=Array.prototype.slice.call(arguments);var pointer=Module["___cxa_is_pointer_type"](throwntype);if(!___cxa_find_matching_catch.buffer)___cxa_find_matching_catch.buffer=_malloc(4);HEAP32[___cxa_find_matching_catch.buffer>>2]=thrown;thrown=___cxa_find_matching_catch.buffer;for(var i=0;i<typeArray.length;i++){if(typeArray[i]&&Module["___cxa_can_catch"](typeArray[i],throwntype,thrown)){thrown=HEAP32[thrown>>2];info.adjusted=thrown;return(asm["setTempRet0"](typeArray[i]),thrown)|0}}thrown=HEAP32[thrown>>2];return(asm["setTempRet0"](throwntype),thrown)|0}function ___cxa_throw(ptr,type,destructor){EXCEPTIONS.infos[ptr]={ptr:ptr,adjusted:ptr,type:type,destructor:destructor,refcount:0};EXCEPTIONS.last=ptr;if(!("uncaught_exception"in __ZSt18uncaught_exceptionv)){__ZSt18uncaught_exceptionv.uncaught_exception=1}else{__ZSt18uncaught_exceptionv.uncaught_exception++}throw ptr}Module["_memset"]=_memset;var _BDtoILow=true;var _emscripten_resume=true;function ___gxx_personality_v0(){}var _emscripten_landingpad=true;function __isLeapYear(year){return year%4===0&&(year%100!==0||year%400===0)}function __arraySum(array,index){var sum=0;for(var i=0;i<=index;sum+=array[i++]);return sum}var __MONTH_DAYS_LEAP=[31,29,31,30,31,30,31,31,30,31,30,31];var __MONTH_DAYS_REGULAR=[31,28,31,30,31,30,31,31,30,31,30,31];function __addDays(date,days){var newDate=new Date(date.getTime());while(days>0){var leap=__isLeapYear(newDate.getFullYear());var currentMonth=newDate.getMonth();var daysInCurrentMonth=(leap?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR)[currentMonth];if(days>daysInCurrentMonth-newDate.getDate()){days-=daysInCurrentMonth-newDate.getDate()+1;newDate.setDate(1);if(currentMonth<11){newDate.setMonth(currentMonth+1)}else{newDate.setMonth(0);newDate.setFullYear(newDate.getFullYear()+1)}}else{newDate.setDate(newDate.getDate()+days);return newDate}}return newDate}function _strftime(s,maxsize,format,tm){var tm_zone=HEAP32[tm+40>>2];var date={tm_sec:HEAP32[tm>>2],tm_min:HEAP32[tm+4>>2],tm_hour:HEAP32[tm+8>>2],tm_mday:HEAP32[tm+12>>2],tm_mon:HEAP32[tm+16>>2],tm_year:HEAP32[tm+20>>2],tm_wday:HEAP32[tm+24>>2],tm_yday:HEAP32[tm+28>>2],tm_isdst:HEAP32[tm+32>>2],tm_gmtoff:HEAP32[tm+36>>2],tm_zone:tm_zone?Pointer_stringify(tm_zone):""};var pattern=Pointer_stringify(format);var EXPANSION_RULES_1={"%c":"%a %b %d %H:%M:%S %Y","%D":"%m/%d/%y","%F":"%Y-%m-%d","%h":"%b","%r":"%I:%M:%S %p","%R":"%H:%M","%T":"%H:%M:%S","%x":"%m/%d/%y","%X":"%H:%M:%S"};for(var rule in EXPANSION_RULES_1){pattern=pattern.replace(new RegExp(rule,"g"),EXPANSION_RULES_1[rule])}var WEEKDAYS=["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"];var MONTHS=["January","February","March","April","May","June","July","August","September","October","November","December"];function leadingSomething(value,digits,character){var str=typeof value==="number"?value.toString():value||"";while(str.length<digits){str=character[0]+str}return str}function leadingNulls(value,digits){return leadingSomething(value,digits,"0")}function compareByDay(date1,date2){function sgn(value){return value<0?-1:value>0?1:0}var compare;if((compare=sgn(date1.getFullYear()-date2.getFullYear()))===0){if((compare=sgn(date1.getMonth()-date2.getMonth()))===0){compare=sgn(date1.getDate()-date2.getDate())}}return compare}function getFirstWeekStartDate(janFourth){switch(janFourth.getDay()){case 0:return new Date(janFourth.getFullYear()-1,11,29);case 1:return janFourth;case 2:return new Date(janFourth.getFullYear(),0,3);case 3:return new Date(janFourth.getFullYear(),0,2);case 4:return new Date(janFourth.getFullYear(),0,1);case 5:return new Date(janFourth.getFullYear()-1,11,31);case 6:return new Date(janFourth.getFullYear()-1,11,30)}}function getWeekBasedYear(date){var thisDate=__addDays(new Date(date.tm_year+1900,0,1),date.tm_yday);var janFourthThisYear=new Date(thisDate.getFullYear(),0,4);var janFourthNextYear=new Date(thisDate.getFullYear()+1,0,4);var firstWeekStartThisYear=getFirstWeekStartDate(janFourthThisYear);var firstWeekStartNextYear=getFirstWeekStartDate(janFourthNextYear);if(compareByDay(firstWeekStartThisYear,thisDate)<=0){if(compareByDay(firstWeekStartNextYear,thisDate)<=0){return thisDate.getFullYear()+1}else{return thisDate.getFullYear()}}else{return thisDate.getFullYear()-1}}var EXPANSION_RULES_2={"%a":(function(date){return WEEKDAYS[date.tm_wday].substring(0,3)}),"%A":(function(date){return WEEKDAYS[date.tm_wday]}),"%b":(function(date){return MONTHS[date.tm_mon].substring(0,3)}),"%B":(function(date){return MONTHS[date.tm_mon]}),"%C":(function(date){var year=date.tm_year+1900;return leadingNulls(year/100|0,2)}),"%d":(function(date){return leadingNulls(date.tm_mday,2)}),"%e":(function(date){return leadingSomething(date.tm_mday,2," ")}),"%g":(function(date){return getWeekBasedYear(date).toString().substring(2)}),"%G":(function(date){return getWeekBasedYear(date)}),"%H":(function(date){return leadingNulls(date.tm_hour,2)}),"%I":(function(date){return leadingNulls(date.tm_hour<13?date.tm_hour:date.tm_hour-12,2)}),"%j":(function(date){return leadingNulls(date.tm_mday+__arraySum(__isLeapYear(date.tm_year+1900)?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR,date.tm_mon-1),3)}),"%m":(function(date){return leadingNulls(date.tm_mon+1,2)}),"%M":(function(date){return leadingNulls(date.tm_min,2)}),"%n":(function(){return"\n"}),"%p":(function(date){if(date.tm_hour>0&&date.tm_hour<13){return"AM"}else{return"PM"}}),"%S":(function(date){return leadingNulls(date.tm_sec,2)}),"%t":(function(){return"\t"}),"%u":(function(date){var day=new Date(date.tm_year+1900,date.tm_mon+1,date.tm_mday,0,0,0,0);return day.getDay()||7}),"%U":(function(date){var janFirst=new Date(date.tm_year+1900,0,1);var firstSunday=janFirst.getDay()===0?janFirst:__addDays(janFirst,7-janFirst.getDay());var endDate=new Date(date.tm_year+1900,date.tm_mon,date.tm_mday);if(compareByDay(firstSunday,endDate)<0){var februaryFirstUntilEndMonth=__arraySum(__isLeapYear(endDate.getFullYear())?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR,endDate.getMonth()-1)-31;var firstSundayUntilEndJanuary=31-firstSunday.getDate();var days=firstSundayUntilEndJanuary+februaryFirstUntilEndMonth+endDate.getDate();return leadingNulls(Math.ceil(days/7),2)}return compareByDay(firstSunday,janFirst)===0?"01":"00"}),"%V":(function(date){var janFourthThisYear=new Date(date.tm_year+1900,0,4);var janFourthNextYear=new Date(date.tm_year+1901,0,4);var firstWeekStartThisYear=getFirstWeekStartDate(janFourthThisYear);var firstWeekStartNextYear=getFirstWeekStartDate(janFourthNextYear);var endDate=__addDays(new Date(date.tm_year+1900,0,1),date.tm_yday);if(compareByDay(endDate,firstWeekStartThisYear)<0){return"53"}if(compareByDay(firstWeekStartNextYear,endDate)<=0){return"01"}var daysDifference;if(firstWeekStartThisYear.getFullYear()<date.tm_year+1900){daysDifference=date.tm_yday+32-firstWeekStartThisYear.getDate()}else{daysDifference=date.tm_yday+1-firstWeekStartThisYear.getDate()}return leadingNulls(Math.ceil(daysDifference/7),2)}),"%w":(function(date){var day=new Date(date.tm_year+1900,date.tm_mon+1,date.tm_mday,0,0,0,0);return day.getDay()}),"%W":(function(date){var janFirst=new Date(date.tm_year,0,1);var firstMonday=janFirst.getDay()===1?janFirst:__addDays(janFirst,janFirst.getDay()===0?1:7-janFirst.getDay()+1);var endDate=new Date(date.tm_year+1900,date.tm_mon,date.tm_mday);if(compareByDay(firstMonday,endDate)<0){var februaryFirstUntilEndMonth=__arraySum(__isLeapYear(endDate.getFullYear())?__MONTH_DAYS_LEAP:__MONTH_DAYS_REGULAR,endDate.getMonth()-1)-31;var firstMondayUntilEndJanuary=31-firstMonday.getDate();var days=firstMondayUntilEndJanuary+februaryFirstUntilEndMonth+endDate.getDate();return leadingNulls(Math.ceil(days/7),2)}return compareByDay(firstMonday,janFirst)===0?"01":"00"}),"%y":(function(date){return(date.tm_year+1900).toString().substring(2)}),"%Y":(function(date){return date.tm_year+1900}),"%z":(function(date){var off=date.tm_gmtoff;var ahead=off>=0;off=Math.abs(off)/60;off=off/60*100+off%60;return(ahead?"+":"-")+String("0000"+off).slice(-4)}),"%Z":(function(date){return date.tm_zone}),"%%":(function(){return"%"})};for(var rule in EXPANSION_RULES_2){if(pattern.indexOf(rule)>=0){pattern=pattern.replace(new RegExp(rule,"g"),EXPANSION_RULES_2[rule](date))}}var bytes=intArrayFromString(pattern,false);if(bytes.length>maxsize){return 0}writeArrayToMemory(bytes,s);return bytes.length-1}function _strftime_l(s,maxsize,format,tm){return _strftime(s,maxsize,format,tm)}function _abort(){Module["abort"]()}function _free(){}Module["_free"]=_free;function ___cxa_free_exception(ptr){try{return _free(ptr)}catch(e){}}function ___cxa_end_catch(){if(___cxa_end_catch.rethrown){___cxa_end_catch.rethrown=false;return}asm["setThrew"](0);var ptr=EXCEPTIONS.caught.pop();if(ptr){EXCEPTIONS.decRef(EXCEPTIONS.deAdjust(ptr));EXCEPTIONS.last=0}}function _pthread_once(ptr,func){if(!_pthread_once.seen)_pthread_once.seen={};if(ptr in _pthread_once.seen)return;Runtime.dynCall("v",func);_pthread_once.seen[ptr]=1}function ___lock(){}function ___unlock(){}var PTHREAD_SPECIFIC={};function _pthread_getspecific(key){return PTHREAD_SPECIFIC[key]||0}function ___setErrNo(value){if(Module["___errno_location"])HEAP32[Module["___errno_location"]()>>2]=value;return value}var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:42,EIDRM:43,ECHRNG:44,EL2NSYNC:45,EL3HLT:46,EL3RST:47,ELNRNG:48,EUNATCH:49,ENOCSI:50,EL2HLT:51,EDEADLK:35,ENOLCK:37,EBADE:52,EBADR:53,EXFULL:54,ENOANO:55,EBADRQC:56,EBADSLT:57,EDEADLOCK:35,EBFONT:59,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:72,EDOTDOT:73,EBADMSG:74,ENOTUNIQ:76,EBADFD:77,EREMCHG:78,ELIBACC:79,ELIBBAD:80,ELIBSCN:81,ELIBMAX:82,ELIBEXEC:83,ENOSYS:38,ENOTEMPTY:39,ENAMETOOLONG:36,ELOOP:40,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:97,EPROTOTYPE:91,ENOTSOCK:88,ENOPROTOOPT:92,ESHUTDOWN:108,ECONNREFUSED:111,EADDRINUSE:98,ECONNABORTED:103,ENETUNREACH:101,ENETDOWN:100,ETIMEDOUT:110,EHOSTDOWN:112,EHOSTUNREACH:113,EINPROGRESS:115,EALREADY:114,EDESTADDRREQ:89,EMSGSIZE:90,EPROTONOSUPPORT:93,ESOCKTNOSUPPORT:94,EADDRNOTAVAIL:99,ENETRESET:102,EISCONN:106,ENOTCONN:107,ETOOMANYREFS:109,EUSERS:87,EDQUOT:122,ESTALE:116,ENOTSUP:95,ENOMEDIUM:123,EILSEQ:84,EOVERFLOW:75,ECANCELED:125,ENOTRECOVERABLE:131,EOWNERDEAD:130,ESTRPIPE:86};function _sysconf(name){switch(name){case 30:return PAGE_SIZE;case 85:return totalMemory/PAGE_SIZE;case 132:case 133:case 12:case 137:case 138:case 15:case 235:case 16:case 17:case 18:case 19:case 20:case 149:case 13:case 10:case 236:case 153:case 9:case 21:case 22:case 159:case 154:case 14:case 77:case 78:case 139:case 80:case 81:case 82:case 68:case 67:case 164:case 11:case 29:case 47:case 48:case 95:case 52:case 51:case 46:return 200809;case 79:return 0;case 27:case 246:case 127:case 128:case 23:case 24:case 160:case 161:case 181:case 182:case 242:case 183:case 184:case 243:case 244:case 245:case 165:case 178:case 179:case 49:case 50:case 168:case 169:case 175:case 170:case 171:case 172:case 97:case 76:case 32:case 173:case 35:return-1;case 176:case 177:case 7:case 155:case 8:case 157:case 125:case 126:case 92:case 93:case 129:case 130:case 131:case 94:case 91:return 1;case 74:case 60:case 69:case 70:case 4:return 1024;case 31:case 42:case 72:return 32;case 87:case 26:case 33:return 2147483647;case 34:case 1:return 47839;case 38:case 36:return 99;case 43:case 37:return 2048;case 0:return 2097152;case 3:return 65536;case 28:return 32768;case 44:return 32767;case 75:return 16384;case 39:return 1e3;case 89:return 700;case 71:return 256;case 40:return 255;case 2:return 100;case 180:return 64;case 25:return 20;case 5:return 16;case 6:return 6;case 73:return 4;case 84:{if(typeof navigator==="object")return navigator["hardwareConcurrency"]||1;return 1}}___setErrNo(ERRNO_CODES.EINVAL);return-1}var _fabs=Math_abs;var PTHREAD_SPECIFIC_NEXT_KEY=1;function _pthread_key_create(key,destructor){if(key==0){return ERRNO_CODES.EINVAL}HEAP32[key>>2]=PTHREAD_SPECIFIC_NEXT_KEY;PTHREAD_SPECIFIC[PTHREAD_SPECIFIC_NEXT_KEY]=0;PTHREAD_SPECIFIC_NEXT_KEY++;return 0}var PATH=undefined;function _emscripten_set_main_loop_timing(mode,value){Browser.mainLoop.timingMode=mode;Browser.mainLoop.timingValue=value;if(!Browser.mainLoop.func){return 1}if(mode==0){Browser.mainLoop.scheduler=function Browser_mainLoop_scheduler_setTimeout(){setTimeout(Browser.mainLoop.runner,value)};Browser.mainLoop.method="timeout"}else if(mode==1){Browser.mainLoop.scheduler=function Browser_mainLoop_scheduler_rAF(){Browser.requestAnimationFrame(Browser.mainLoop.runner)};Browser.mainLoop.method="rAF"}else if(mode==2){if(!window["setImmediate"]){var setImmediates=[];var emscriptenMainLoopMessageId="__emcc";function Browser_setImmediate_messageHandler(event){if(event.source===window&&event.data===emscriptenMainLoopMessageId){event.stopPropagation();setImmediates.shift()()}}window.addEventListener("message",Browser_setImmediate_messageHandler,true);window["setImmediate"]=function Browser_emulated_setImmediate(func){setImmediates.push(func);window.postMessage(emscriptenMainLoopMessageId,"*")}}Browser.mainLoop.scheduler=function Browser_mainLoop_scheduler_setImmediate(){window["setImmediate"](Browser.mainLoop.runner)};Browser.mainLoop.method="immediate"}return 0}function _emscripten_set_main_loop(func,fps,simulateInfiniteLoop,arg,noSetTiming){Module["noExitRuntime"]=true;assert(!Browser.mainLoop.func,"emscripten_set_main_loop: there can only be one main loop function at once: call emscripten_cancel_main_loop to cancel the previous one before setting a new one with different parameters.");Browser.mainLoop.func=func;Browser.mainLoop.arg=arg;var thisMainLoopId=Browser.mainLoop.currentlyRunningMainloop;Browser.mainLoop.runner=function Browser_mainLoop_runner(){if(ABORT)return;if(Browser.mainLoop.queue.length>0){var start=Date.now();var blocker=Browser.mainLoop.queue.shift();blocker.func(blocker.arg);if(Browser.mainLoop.remainingBlockers){var remaining=Browser.mainLoop.remainingBlockers;var next=remaining%1==0?remaining-1:Math.floor(remaining);if(blocker.counted){Browser.mainLoop.remainingBlockers=next}else{next=next+.5;Browser.mainLoop.remainingBlockers=(8*remaining+next)/9}}console.log('main loop blocker "'+blocker.name+'" took '+(Date.now()-start)+" ms");Browser.mainLoop.updateStatus();setTimeout(Browser.mainLoop.runner,0);return}if(thisMainLoopId<Browser.mainLoop.currentlyRunningMainloop)return;Browser.mainLoop.currentFrameNumber=Browser.mainLoop.currentFrameNumber+1|0;if(Browser.mainLoop.timingMode==1&&Browser.mainLoop.timingValue>1&&Browser.mainLoop.currentFrameNumber%Browser.mainLoop.timingValue!=0){Browser.mainLoop.scheduler();return}if(Browser.mainLoop.method==="timeout"&&Module.ctx){Module.printErr("Looks like you are rendering without using requestAnimationFrame for the main loop. You should use 0 for the frame rate in emscripten_set_main_loop in order to use requestAnimationFrame, as that can greatly improve your frame rates!");Browser.mainLoop.method=""}Browser.mainLoop.runIter((function(){if(typeof arg!=="undefined"){Runtime.dynCall("vi",func,[arg])}else{Runtime.dynCall("v",func)}}));if(thisMainLoopId<Browser.mainLoop.currentlyRunningMainloop)return;if(typeof SDL==="object"&&SDL.audio&&SDL.audio.queueNewAudioData)SDL.audio.queueNewAudioData();Browser.mainLoop.scheduler()};if(!noSetTiming){if(fps&&fps>0)_emscripten_set_main_loop_timing(0,1e3/fps);else _emscripten_set_main_loop_timing(1,1);Browser.mainLoop.scheduler()}if(simulateInfiniteLoop){throw"SimulateInfiniteLoop"}}var Browser={mainLoop:{scheduler:null,method:"",currentlyRunningMainloop:0,func:null,arg:0,timingMode:0,timingValue:0,currentFrameNumber:0,queue:[],pause:(function(){Browser.mainLoop.scheduler=null;Browser.mainLoop.currentlyRunningMainloop++}),resume:(function(){Browser.mainLoop.currentlyRunningMainloop++;var timingMode=Browser.mainLoop.timingMode;var timingValue=Browser.mainLoop.timingValue;var func=Browser.mainLoop.func;Browser.mainLoop.func=null;_emscripten_set_main_loop(func,0,false,Browser.mainLoop.arg,true);_emscripten_set_main_loop_timing(timingMode,timingValue);Browser.mainLoop.scheduler()}),updateStatus:(function(){if(Module["setStatus"]){var message=Module["statusMessage"]||"Please wait...";var remaining=Browser.mainLoop.remainingBlockers;var expected=Browser.mainLoop.expectedBlockers;if(remaining){if(remaining<expected){Module["setStatus"](message+" ("+(expected-remaining)+"/"+expected+")")}else{Module["setStatus"](message)}}else{Module["setStatus"]("")}}}),runIter:(function(func){if(ABORT)return;if(Module["preMainLoop"]){var preRet=Module["preMainLoop"]();if(preRet===false){return}}try{func()}catch(e){if(e instanceof ExitStatus){return}else{if(e&&typeof e==="object"&&e.stack)Module.printErr("exception thrown: "+[e,e.stack]);throw e}}if(Module["postMainLoop"])Module["postMainLoop"]()})},isFullScreen:false,pointerLock:false,moduleContextCreatedCallbacks:[],workers:[],init:(function(){if(!Module["preloadPlugins"])Module["preloadPlugins"]=[];if(Browser.initted)return;Browser.initted=true;try{new Blob;Browser.hasBlobConstructor=true}catch(e){Browser.hasBlobConstructor=false;console.log("warning: no blob constructor, cannot create blobs with mimetypes")}Browser.BlobBuilder=typeof MozBlobBuilder!="undefined"?MozBlobBuilder:typeof WebKitBlobBuilder!="undefined"?WebKitBlobBuilder:!Browser.hasBlobConstructor?console.log("warning: no BlobBuilder"):null;Browser.URLObject=typeof window!="undefined"?window.URL?window.URL:window.webkitURL:undefined;if(!Module.noImageDecoding&&typeof Browser.URLObject==="undefined"){console.log("warning: Browser does not support creating object URLs. Built-in browser image decoding will not be available.");Module.noImageDecoding=true}var imagePlugin={};imagePlugin["canHandle"]=function imagePlugin_canHandle(name){return!Module.noImageDecoding&&/\.(jpg|jpeg|png|bmp)$/i.test(name)};imagePlugin["handle"]=function imagePlugin_handle(byteArray,name,onload,onerror){var b=null;if(Browser.hasBlobConstructor){try{b=new Blob([byteArray],{type:Browser.getMimetype(name)});if(b.size!==byteArray.length){b=new Blob([(new Uint8Array(byteArray)).buffer],{type:Browser.getMimetype(name)})}}catch(e){Runtime.warnOnce("Blob constructor present but fails: "+e+"; falling back to blob builder")}}if(!b){var bb=new Browser.BlobBuilder;bb.append((new Uint8Array(byteArray)).buffer);b=bb.getBlob()}var url=Browser.URLObject.createObjectURL(b);var img=new Image;img.onload=function img_onload(){assert(img.complete,"Image "+name+" could not be decoded");var canvas=document.createElement("canvas");canvas.width=img.width;canvas.height=img.height;var ctx=canvas.getContext("2d");ctx.drawImage(img,0,0);Module["preloadedImages"][name]=canvas;Browser.URLObject.revokeObjectURL(url);if(onload)onload(byteArray)};img.onerror=function img_onerror(event){console.log("Image "+url+" could not be decoded");if(onerror)onerror()};img.src=url};Module["preloadPlugins"].push(imagePlugin);var audioPlugin={};audioPlugin["canHandle"]=function audioPlugin_canHandle(name){return!Module.noAudioDecoding&&name.substr(-4)in{".ogg":1,".wav":1,".mp3":1}};audioPlugin["handle"]=function audioPlugin_handle(byteArray,name,onload,onerror){var done=false;function finish(audio){if(done)return;done=true;Module["preloadedAudios"][name]=audio;if(onload)onload(byteArray)}function fail(){if(done)return;done=true;Module["preloadedAudios"][name]=new Audio;if(onerror)onerror()}if(Browser.hasBlobConstructor){try{var b=new Blob([byteArray],{type:Browser.getMimetype(name)})}catch(e){return fail()}var url=Browser.URLObject.createObjectURL(b);var audio=new Audio;audio.addEventListener("canplaythrough",(function(){finish(audio)}),false);audio.onerror=function audio_onerror(event){if(done)return;console.log("warning: browser could not fully decode audio "+name+", trying slower base64 approach");function encode64(data){var BASE="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";var PAD="=";var ret="";var leftchar=0;var leftbits=0;for(var i=0;i<data.length;i++){leftchar=leftchar<<8|data[i];leftbits+=8;while(leftbits>=6){var curr=leftchar>>leftbits-6&63;leftbits-=6;ret+=BASE[curr]}}if(leftbits==2){ret+=BASE[(leftchar&3)<<4];ret+=PAD+PAD}else if(leftbits==4){ret+=BASE[(leftchar&15)<<2];ret+=PAD}return ret}audio.src="data:audio/x-"+name.substr(-3)+";base64,"+encode64(byteArray);finish(audio)};audio.src=url;Browser.safeSetTimeout((function(){finish(audio)}),1e4)}else{return fail()}};Module["preloadPlugins"].push(audioPlugin);var canvas=Module["canvas"];function pointerLockChange(){Browser.pointerLock=document["pointerLockElement"]===canvas||document["mozPointerLockElement"]===canvas||document["webkitPointerLockElement"]===canvas||document["msPointerLockElement"]===canvas}if(canvas){canvas.requestPointerLock=canvas["requestPointerLock"]||canvas["mozRequestPointerLock"]||canvas["webkitRequestPointerLock"]||canvas["msRequestPointerLock"]||(function(){});canvas.exitPointerLock=document["exitPointerLock"]||document["mozExitPointerLock"]||document["webkitExitPointerLock"]||document["msExitPointerLock"]||(function(){});canvas.exitPointerLock=canvas.exitPointerLock.bind(document);document.addEventListener("pointerlockchange",pointerLockChange,false);document.addEventListener("mozpointerlockchange",pointerLockChange,false);document.addEventListener("webkitpointerlockchange",pointerLockChange,false);document.addEventListener("mspointerlockchange",pointerLockChange,false);if(Module["elementPointerLock"]){canvas.addEventListener("click",(function(ev){if(!Browser.pointerLock&&canvas.requestPointerLock){canvas.requestPointerLock();ev.preventDefault()}}),false)}}}),createContext:(function(canvas,useWebGL,setInModule,webGLContextAttributes){if(useWebGL&&Module.ctx&&canvas==Module.canvas)return Module.ctx;var ctx;var contextHandle;if(useWebGL){var contextAttributes={antialias:false,alpha:false};if(webGLContextAttributes){for(var attribute in webGLContextAttributes){contextAttributes[attribute]=webGLContextAttributes[attribute]}}contextHandle=GL.createContext(canvas,contextAttributes);if(contextHandle){ctx=GL.getContext(contextHandle).GLctx}canvas.style.backgroundColor="black"}else{ctx=canvas.getContext("2d")}if(!ctx)return null;if(setInModule){if(!useWebGL)assert(typeof GLctx==="undefined","cannot set in module if GLctx is used, but we are a non-GL context that would replace it");Module.ctx=ctx;if(useWebGL)GL.makeContextCurrent(contextHandle);Module.useWebGL=useWebGL;Browser.moduleContextCreatedCallbacks.forEach((function(callback){callback()}));Browser.init()}return ctx}),destroyContext:(function(canvas,useWebGL,setInModule){}),fullScreenHandlersInstalled:false,lockPointer:undefined,resizeCanvas:undefined,requestFullScreen:(function(lockPointer,resizeCanvas,vrDevice){Browser.lockPointer=lockPointer;Browser.resizeCanvas=resizeCanvas;Browser.vrDevice=vrDevice;if(typeof Browser.lockPointer==="undefined")Browser.lockPointer=true;if(typeof Browser.resizeCanvas==="undefined")Browser.resizeCanvas=false;if(typeof Browser.vrDevice==="undefined")Browser.vrDevice=null;var canvas=Module["canvas"];function fullScreenChange(){Browser.isFullScreen=false;var canvasContainer=canvas.parentNode;if((document["webkitFullScreenElement"]||document["webkitFullscreenElement"]||document["mozFullScreenElement"]||document["mozFullscreenElement"]||document["fullScreenElement"]||document["fullscreenElement"]||document["msFullScreenElement"]||document["msFullscreenElement"]||document["webkitCurrentFullScreenElement"])===canvasContainer){canvas.cancelFullScreen=document["cancelFullScreen"]||document["mozCancelFullScreen"]||document["webkitCancelFullScreen"]||document["msExitFullscreen"]||document["exitFullscreen"]||(function(){});canvas.cancelFullScreen=canvas.cancelFullScreen.bind(document);if(Browser.lockPointer)canvas.requestPointerLock();Browser.isFullScreen=true;if(Browser.resizeCanvas)Browser.setFullScreenCanvasSize()}else{canvasContainer.parentNode.insertBefore(canvas,canvasContainer);canvasContainer.parentNode.removeChild(canvasContainer);if(Browser.resizeCanvas)Browser.setWindowedCanvasSize()}if(Module["onFullScreen"])Module["onFullScreen"](Browser.isFullScreen);Browser.updateCanvasDimensions(canvas)}if(!Browser.fullScreenHandlersInstalled){Browser.fullScreenHandlersInstalled=true;document.addEventListener("fullscreenchange",fullScreenChange,false);document.addEventListener("mozfullscreenchange",fullScreenChange,false);document.addEventListener("webkitfullscreenchange",fullScreenChange,false);document.addEventListener("MSFullscreenChange",fullScreenChange,false)}var canvasContainer=document.createElement("div");canvas.parentNode.insertBefore(canvasContainer,canvas);canvasContainer.appendChild(canvas);canvasContainer.requestFullScreen=canvasContainer["requestFullScreen"]||canvasContainer["mozRequestFullScreen"]||canvasContainer["msRequestFullscreen"]||(canvasContainer["webkitRequestFullScreen"]?(function(){canvasContainer["webkitRequestFullScreen"](Element["ALLOW_KEYBOARD_INPUT"])}):null);if(vrDevice){canvasContainer.requestFullScreen({vrDisplay:vrDevice})}else{canvasContainer.requestFullScreen()}}),nextRAF:0,fakeRequestAnimationFrame:(function(func){var now=Date.now();if(Browser.nextRAF===0){Browser.nextRAF=now+1e3/60}else{while(now+2>=Browser.nextRAF){Browser.nextRAF+=1e3/60}}var delay=Math.max(Browser.nextRAF-now,0);setTimeout(func,delay)}),requestAnimationFrame:function requestAnimationFrame(func){if(typeof window==="undefined"){Browser.fakeRequestAnimationFrame(func)}else{if(!window.requestAnimationFrame){window.requestAnimationFrame=window["requestAnimationFrame"]||window["mozRequestAnimationFrame"]||window["webkitRequestAnimationFrame"]||window["msRequestAnimationFrame"]||window["oRequestAnimationFrame"]||Browser.fakeRequestAnimationFrame}window.requestAnimationFrame(func)}},safeCallback:(function(func){return(function(){if(!ABORT)return func.apply(null,arguments)})}),allowAsyncCallbacks:true,queuedAsyncCallbacks:[],pauseAsyncCallbacks:(function(){Browser.allowAsyncCallbacks=false}),resumeAsyncCallbacks:(function(){Browser.allowAsyncCallbacks=true;if(Browser.queuedAsyncCallbacks.length>0){var callbacks=Browser.queuedAsyncCallbacks;Browser.queuedAsyncCallbacks=[];callbacks.forEach((function(func){func()}))}}),safeRequestAnimationFrame:(function(func){return Browser.requestAnimationFrame((function(){if(ABORT)return;if(Browser.allowAsyncCallbacks){func()}else{Browser.queuedAsyncCallbacks.push(func)}}))}),safeSetTimeout:(function(func,timeout){Module["noExitRuntime"]=true;return setTimeout((function(){if(ABORT)return;if(Browser.allowAsyncCallbacks){func()}else{Browser.queuedAsyncCallbacks.push(func)}}),timeout)}),safeSetInterval:(function(func,timeout){Module["noExitRuntime"]=true;return setInterval((function(){if(ABORT)return;if(Browser.allowAsyncCallbacks){func()}}),timeout)}),getMimetype:(function(name){return{"jpg":"image/jpeg","jpeg":"image/jpeg","png":"image/png","bmp":"image/bmp","ogg":"audio/ogg","wav":"audio/wav","mp3":"audio/mpeg"}[name.substr(name.lastIndexOf(".")+1)]}),getUserMedia:(function(func){if(!window.getUserMedia){window.getUserMedia=navigator["getUserMedia"]||navigator["mozGetUserMedia"]}window.getUserMedia(func)}),getMovementX:(function(event){return event["movementX"]||event["mozMovementX"]||event["webkitMovementX"]||0}),getMovementY:(function(event){return event["movementY"]||event["mozMovementY"]||event["webkitMovementY"]||0}),getMouseWheelDelta:(function(event){var delta=0;switch(event.type){case"DOMMouseScroll":delta=event.detail;break;case"mousewheel":delta=event.wheelDelta;break;case"wheel":delta=event["deltaY"];break;default:throw"unrecognized mouse wheel event: "+event.type}return delta}),mouseX:0,mouseY:0,mouseMovementX:0,mouseMovementY:0,touches:{},lastTouches:{},calculateMouseEvent:(function(event){if(Browser.pointerLock){if(event.type!="mousemove"&&"mozMovementX"in event){Browser.mouseMovementX=Browser.mouseMovementY=0}else{Browser.mouseMovementX=Browser.getMovementX(event);Browser.mouseMovementY=Browser.getMovementY(event)}if(typeof SDL!="undefined"){Browser.mouseX=SDL.mouseX+Browser.mouseMovementX;Browser.mouseY=SDL.mouseY+Browser.mouseMovementY}else{Browser.mouseX+=Browser.mouseMovementX;Browser.mouseY+=Browser.mouseMovementY}}else{var rect=Module["canvas"].getBoundingClientRect();var cw=Module["canvas"].width;var ch=Module["canvas"].height;var scrollX=typeof window.scrollX!=="undefined"?window.scrollX:window.pageXOffset;var scrollY=typeof window.scrollY!=="undefined"?window.scrollY:window.pageYOffset;if(event.type==="touchstart"||event.type==="touchend"||event.type==="touchmove"){var touch=event.touch;if(touch===undefined){return}var adjustedX=touch.pageX-(scrollX+rect.left);var adjustedY=touch.pageY-(scrollY+rect.top);adjustedX=adjustedX*(cw/rect.width);adjustedY=adjustedY*(ch/rect.height);var coords={x:adjustedX,y:adjustedY};if(event.type==="touchstart"){Browser.lastTouches[touch.identifier]=coords;Browser.touches[touch.identifier]=coords}else if(event.type==="touchend"||event.type==="touchmove"){var last=Browser.touches[touch.identifier];if(!last)last=coords;Browser.lastTouches[touch.identifier]=last;Browser.touches[touch.identifier]=coords}return}var x=event.pageX-(scrollX+rect.left);var y=event.pageY-(scrollY+rect.top);x=x*(cw/rect.width);y=y*(ch/rect.height);Browser.mouseMovementX=x-Browser.mouseX;Browser.mouseMovementY=y-Browser.mouseY;Browser.mouseX=x;Browser.mouseY=y}}),xhrLoad:(function(url,onload,onerror){var xhr=new XMLHttpRequest;xhr.open("GET",url,true);xhr.responseType="arraybuffer";xhr.onload=function xhr_onload(){if(xhr.status==200||xhr.status==0&&xhr.response){onload(xhr.response)}else{onerror()}};xhr.onerror=onerror;xhr.send(null)}),asyncLoad:(function(url,onload,onerror,noRunDep){Browser.xhrLoad(url,(function(arrayBuffer){assert(arrayBuffer,'Loading data file "'+url+'" failed (no arrayBuffer).');onload(new Uint8Array(arrayBuffer));if(!noRunDep)removeRunDependency("al "+url)}),(function(event){if(onerror){onerror()}else{throw'Loading data file "'+url+'" failed.'}}));if(!noRunDep)addRunDependency("al "+url)}),resizeListeners:[],updateResizeListeners:(function(){var canvas=Module["canvas"];Browser.resizeListeners.forEach((function(listener){listener(canvas.width,canvas.height)}))}),setCanvasSize:(function(width,height,noUpdates){var canvas=Module["canvas"];Browser.updateCanvasDimensions(canvas,width,height);if(!noUpdates)Browser.updateResizeListeners()}),windowedWidth:0,windowedHeight:0,setFullScreenCanvasSize:(function(){if(typeof SDL!="undefined"){var flags=HEAPU32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2];flags=flags|8388608;HEAP32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2]=flags}Browser.updateResizeListeners()}),setWindowedCanvasSize:(function(){if(typeof SDL!="undefined"){var flags=HEAPU32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2];flags=flags&~8388608;HEAP32[SDL.screen+Runtime.QUANTUM_SIZE*0>>2]=flags}Browser.updateResizeListeners()}),updateCanvasDimensions:(function(canvas,wNative,hNative){if(wNative&&hNative){canvas.widthNative=wNative;canvas.heightNative=hNative}else{wNative=canvas.widthNative;hNative=canvas.heightNative}var w=wNative;var h=hNative;if(Module["forcedAspectRatio"]&&Module["forcedAspectRatio"]>0){if(w/h<Module["forcedAspectRatio"]){w=Math.round(h*Module["forcedAspectRatio"])}else{h=Math.round(w/Module["forcedAspectRatio"])}}if((document["webkitFullScreenElement"]||document["webkitFullscreenElement"]||document["mozFullScreenElement"]||document["mozFullscreenElement"]||document["fullScreenElement"]||document["fullscreenElement"]||document["msFullScreenElement"]||document["msFullscreenElement"]||document["webkitCurrentFullScreenElement"])===canvas.parentNode&&typeof screen!="undefined"){var factor=Math.min(screen.width/w,screen.height/h);w=Math.round(w*factor);h=Math.round(h*factor)}if(Browser.resizeCanvas){if(canvas.width!=w)canvas.width=w;if(canvas.height!=h)canvas.height=h;if(typeof canvas.style!="undefined"){canvas.style.removeProperty("width");canvas.style.removeProperty("height")}}else{if(canvas.width!=wNative)canvas.width=wNative;if(canvas.height!=hNative)canvas.height=hNative;if(typeof canvas.style!="undefined"){if(w!=wNative||h!=hNative){canvas.style.setProperty("width",w+"px","important");canvas.style.setProperty("height",h+"px","important")}else{canvas.style.removeProperty("width");canvas.style.removeProperty("height")}}}}),wgetRequests:{},nextWgetRequestHandle:0,getNextWgetRequestHandle:(function(){var handle=Browser.nextWgetRequestHandle;Browser.nextWgetRequestHandle++;return handle})};function _pthread_setspecific(key,value){if(!(key in PTHREAD_SPECIFIC)){return ERRNO_CODES.EINVAL}PTHREAD_SPECIFIC[key]=value;return 0}function _malloc(bytes){var ptr=Runtime.dynamicAlloc(bytes+8);return ptr+8&4294967288}Module["_malloc"]=_malloc;function ___cxa_allocate_exception(size){return _malloc(size)}var SYSCALLS={varargs:0,get:(function(varargs){SYSCALLS.varargs+=4;var ret=HEAP32[SYSCALLS.varargs-4>>2];return ret}),getStr:(function(){var ret=Pointer_stringify(SYSCALLS.get());return ret}),get64:(function(){var low=SYSCALLS.get(),high=SYSCALLS.get();if(low>=0)assert(high===0);else assert(high===-1);return low}),getZero:(function(){assert(SYSCALLS.get()===0)})};function ___syscall54(which,varargs){SYSCALLS.varargs=varargs;try{return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}Module["_i64Add"]=_i64Add;Module["_bitshift64Lshr"]=_bitshift64Lshr;function ___cxa_pure_virtual(){ABORT=true;throw"Pure virtual function called!"}var _BDtoIHigh=true;function _pthread_cleanup_push(routine,arg){__ATEXIT__.push((function(){Runtime.dynCall("vi",routine,[arg])}));_pthread_cleanup_push.level=__ATEXIT__.length}function _pthread_cond_broadcast(){return 0}function ___cxa_guard_acquire(variable){if(!HEAP8[variable>>0]){HEAP8[variable>>0]=1;return 1}return 0}function _pthread_cleanup_pop(){assert(_pthread_cleanup_push.level==__ATEXIT__.length,"cannot pop if something else added meanwhile!");__ATEXIT__.pop();_pthread_cleanup_push.level=__ATEXIT__.length}function ___cxa_guard_release(){}function ___cxa_begin_catch(ptr){__ZSt18uncaught_exceptionv.uncaught_exception--;EXCEPTIONS.caught.push(ptr);EXCEPTIONS.addRef(EXCEPTIONS.deAdjust(ptr));return ptr}function _llvm_eh_typeid_for(type){return type}function _emscripten_memcpy_big(dest,src,num){HEAPU8.set(HEAPU8.subarray(src,src+num),dest);return dest}Module["_memcpy"]=_memcpy;function ___syscall6(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD();FS.close(stream);return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function _pthread_mutex_lock(){}var _emscripten_postinvoke=true;function _sbrk(bytes){var self=_sbrk;if(!self.called){DYNAMICTOP=alignMemoryPage(DYNAMICTOP);self.called=true;assert(Runtime.dynamicAlloc);self.alloc=Runtime.dynamicAlloc;Runtime.dynamicAlloc=(function(){abort("cannot dynamically allocate, sbrk now has control")})}var ret=DYNAMICTOP;if(bytes!=0){var success=self.alloc(bytes);if(!success)return-1>>>0}return ret}Module["_bitshift64Shl"]=_bitshift64Shl;function ___cxa_guard_abort(){}Module["_memmove"]=_memmove;var _emscripten_preinvoke=true;var _BItoD=true;function _pthread_cond_wait(){return 0}function ___cxa_rethrow(){___cxa_end_catch.rethrown=true;var ptr=EXCEPTIONS.caught.pop();EXCEPTIONS.last=ptr;throw ptr}function _pthread_mutex_unlock(){}function _time(ptr){var ret=Date.now()/1e3|0;if(ptr){HEAP32[ptr>>2]=ret}return ret}function _pthread_self(){return 0}function ___syscall140(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),offset_high=SYSCALLS.get(),offset_low=SYSCALLS.get(),result=SYSCALLS.get(),whence=SYSCALLS.get();var offset=offset_low;assert(offset_high===0);FS.llseek(stream,offset,whence);HEAP32[result>>2]=stream.position;if(stream.getdents&&offset===0&&whence===0)stream.getdents=null;return 0}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall146(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.get(),iov=SYSCALLS.get(),iovcnt=SYSCALLS.get();var ret=0;if(!___syscall146.buffer)___syscall146.buffer=[];var buffer=___syscall146.buffer;for(var i=0;i<iovcnt;i++){var ptr=HEAP32[iov+i*8>>2];var len=HEAP32[iov+(i*8+4)>>2];for(var j=0;j<len;j++){var curr=HEAPU8[ptr+j];if(curr===0||curr===10){Module["print"](UTF8ArrayToString(buffer,0));buffer.length=0}else{buffer.push(curr)}}ret+=len}return ret}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}function ___syscall145(which,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(),iov=SYSCALLS.get(),iovcnt=SYSCALLS.get();return SYSCALLS.doReadv(stream,iov,iovcnt)}catch(e){if(typeof FS==="undefined"||!(e instanceof FS.ErrnoError))abort(e);return-e.errno}}var ___dso_handle=allocate(1,"i32*",ALLOC_STATIC);Module["requestFullScreen"]=function Module_requestFullScreen(lockPointer,resizeCanvas,vrDevice){Browser.requestFullScreen(lockPointer,resizeCanvas,vrDevice)};Module["requestAnimationFrame"]=function Module_requestAnimationFrame(func){Browser.requestAnimationFrame(func)};Module["setCanvasSize"]=function Module_setCanvasSize(width,height,noUpdates){Browser.setCanvasSize(width,height,noUpdates)};Module["pauseMainLoop"]=function Module_pauseMainLoop(){Browser.mainLoop.pause()};Module["resumeMainLoop"]=function Module_resumeMainLoop(){Browser.mainLoop.resume()};Module["getUserMedia"]=function Module_getUserMedia(){Browser.getUserMedia()};Module["createContext"]=function Module_createContext(canvas,useWebGL,setInModule,webGLContextAttributes){return Browser.createContext(canvas,useWebGL,setInModule,webGLContextAttributes)};STACK_BASE=STACKTOP=Runtime.alignMemory(STATICTOP);staticSealed=true;STACK_MAX=STACK_BASE+TOTAL_STACK;DYNAMIC_BASE=DYNAMICTOP=Runtime.alignMemory(STACK_MAX);assert(DYNAMIC_BASE<TOTAL_MEMORY,"TOTAL_MEMORY not big enough for stack");var cttz_i8=allocate([8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0],"i8",ALLOC_DYNAMIC);function invoke_iiiiiiii(index,a1,a2,a3,a4,a5,a6,a7){try{return Module["dynCall_iiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiii(index,a1,a2,a3,a4,a5){try{Module["dynCall_viiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiid(index,a1,a2,a3,a4,a5,a6){try{return Module["dynCall_iiiiiid"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vi(index,a1){try{Module["dynCall_vi"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_vii(index,a1,a2){try{Module["dynCall_vii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiii(index,a1,a2,a3,a4,a5,a6){try{return Module["dynCall_iiiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_ii(index,a1){try{return Module["dynCall_ii"](index,a1)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11){try{return Module["dynCall_iiiiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiii(index,a1,a2,a3){try{return Module["dynCall_iiii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiiiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15){try{Module["dynCall_viiiiiiiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiii(index,a1,a2,a3,a4,a5,a6){try{Module["dynCall_viiiiii"](index,a1,a2,a3,a4,a5,a6)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiii(index,a1,a2,a3,a4,a5,a6,a7){try{Module["dynCall_viiiiiii"](index,a1,a2,a3,a4,a5,a6,a7)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10){try{Module["dynCall_viiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iii(index,a1,a2){try{return Module["dynCall_iii"](index,a1,a2)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiii(index,a1,a2,a3,a4,a5){try{return Module["dynCall_iiiiii"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_diii(index,a1,a2,a3){try{return Module["dynCall_diii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_i(index){try{return Module["dynCall_i"](index)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiii(index,a1,a2,a3,a4){try{return Module["dynCall_iiiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viii(index,a1,a2,a3){try{Module["dynCall_viii"](index,a1,a2,a3)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_v(index){try{Module["dynCall_v"](index)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8){try{return Module["dynCall_iiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_iiiiid(index,a1,a2,a3,a4,a5){try{return Module["dynCall_iiiiid"](index,a1,a2,a3,a4,a5)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}function invoke_viiii(index,a1,a2,a3,a4){try{Module["dynCall_viiii"](index,a1,a2,a3,a4)}catch(e){if(typeof e!=="number"&&e!=="longjmp")throw e;asm["setThrew"](1,0)}}Module.asmGlobalArg={"Math":Math,"Int8Array":Int8Array,"Int16Array":Int16Array,"Int32Array":Int32Array,"Uint8Array":Uint8Array,"Uint16Array":Uint16Array,"Uint32Array":Uint32Array,"Float32Array":Float32Array,"Float64Array":Float64Array,"NaN":NaN,"Infinity":Infinity};Module.asmLibraryArg={"abort":abort,"assert":assert,"invoke_iiiiiiii":invoke_iiiiiiii,"invoke_viiiii":invoke_viiiii,"invoke_iiiiiid":invoke_iiiiiid,"invoke_vi":invoke_vi,"invoke_vii":invoke_vii,"invoke_iiiiiii":invoke_iiiiiii,"invoke_ii":invoke_ii,"invoke_iiiiiiiiiiii":invoke_iiiiiiiiiiii,"invoke_iiii":invoke_iiii,"invoke_viiiiiiiiiiiiiii":invoke_viiiiiiiiiiiiiii,"invoke_viiiiii":invoke_viiiiii,"invoke_viiiiiii":invoke_viiiiiii,"invoke_viiiiiiiiii":invoke_viiiiiiiiii,"invoke_iii":invoke_iii,"invoke_iiiiii":invoke_iiiiii,"invoke_diii":invoke_diii,"invoke_i":invoke_i,"invoke_iiiii":invoke_iiiii,"invoke_viii":invoke_viii,"invoke_v":invoke_v,"invoke_iiiiiiiii":invoke_iiiiiiiii,"invoke_iiiiid":invoke_iiiiid,"invoke_viiii":invoke_viiii,"_fabs":_fabs,"_strftime":_strftime,"_pthread_cond_wait":_pthread_cond_wait,"___lock":___lock,"_pthread_key_create":_pthread_key_create,"_abort":_abort,"___cxa_guard_acquire":___cxa_guard_acquire,"___setErrNo":___setErrNo,"___gxx_personality_v0":___gxx_personality_v0,"___assert_fail":___assert_fail,"___cxa_free_exception":___cxa_free_exception,"___cxa_allocate_exception":___cxa_allocate_exception,"___cxa_find_matching_catch":___cxa_find_matching_catch,"__isLeapYear":__isLeapYear,"___cxa_guard_release":___cxa_guard_release,"__addDays":__addDays,"_strftime_l":_strftime_l,"_emscripten_set_main_loop_timing":_emscripten_set_main_loop_timing,"_llvm_eh_typeid_for":_llvm_eh_typeid_for,"_sbrk":_sbrk,"___cxa_begin_catch":___cxa_begin_catch,"_emscripten_memcpy_big":_emscripten_memcpy_big,"___cxa_end_catch":___cxa_end_catch,"___resumeException":___resumeException,"__ZSt18uncaught_exceptionv":__ZSt18uncaught_exceptionv,"_sysconf":_sysconf,"_pthread_getspecific":_pthread_getspecific,"__arraySum":__arraySum,"_pthread_self":_pthread_self,"_pthread_mutex_unlock":_pthread_mutex_unlock,"_pthread_once":_pthread_once,"___syscall54":___syscall54,"___unlock":___unlock,"_pthread_cleanup_pop":_pthread_cleanup_pop,"_pthread_cond_broadcast":_pthread_cond_broadcast,"_emscripten_set_main_loop":_emscripten_set_main_loop,"_pthread_setspecific":_pthread_setspecific,"___cxa_atexit":___cxa_atexit,"___cxa_throw":___cxa_throw,"___cxa_rethrow":___cxa_rethrow,"___syscall6":___syscall6,"_pthread_cleanup_push":_pthread_cleanup_push,"___cxa_pure_virtual":___cxa_pure_virtual,"_time":_time,"_pthread_mutex_lock":_pthread_mutex_lock,"___cxa_guard_abort":___cxa_guard_abort,"_atexit":_atexit,"___syscall140":___syscall140,"___syscall145":___syscall145,"___syscall146":___syscall146,"STACKTOP":STACKTOP,"STACK_MAX":STACK_MAX,"tempDoublePtr":tempDoublePtr,"ABORT":ABORT,"cttz_i8":cttz_i8,"___dso_handle":___dso_handle};// EMSCRIPTEN_START_ASM
var asm=(function(global,env,buffer) {
"use asm";var a=new global.Int8Array(buffer);var b=new global.Int16Array(buffer);var c=new global.Int32Array(buffer);var d=new global.Uint8Array(buffer);var e=new global.Uint16Array(buffer);var f=new global.Uint32Array(buffer);var g=new global.Float32Array(buffer);var h=new global.Float64Array(buffer);var i=env.STACKTOP|0;var j=env.STACK_MAX|0;var k=env.tempDoublePtr|0;var l=env.ABORT|0;var m=env.cttz_i8|0;var n=env.___dso_handle|0;var o=0;var p=0;var q=0;var r=0;var s=global.NaN,t=global.Infinity;var u=0,v=0,w=0,x=0,y=0.0,z=0,A=0,B=0,C=0.0;var D=0;var E=0;var F=0;var G=0;var H=0;var I=0;var J=0;var K=0;var L=0;var M=0;var N=global.Math.floor;var O=global.Math.abs;var P=global.Math.sqrt;var Q=global.Math.pow;var R=global.Math.cos;var S=global.Math.sin;var T=global.Math.tan;var U=global.Math.acos;var V=global.Math.asin;var W=global.Math.atan;var X=global.Math.atan2;var Y=global.Math.exp;var Z=global.Math.log;var _=global.Math.ceil;var $=global.Math.imul;var aa=global.Math.min;var ba=global.Math.clz32;var ca=env.abort;var da=env.assert;var ea=env.invoke_iiiiiiii;var fa=env.invoke_viiiii;var ga=env.invoke_iiiiiid;var ha=env.invoke_vi;var ia=env.invoke_vii;var ja=env.invoke_iiiiiii;var ka=env.invoke_ii;var la=env.invoke_iiiiiiiiiiii;var ma=env.invoke_iiii;var na=env.invoke_viiiiiiiiiiiiiii;var oa=env.invoke_viiiiii;var pa=env.invoke_viiiiiii;var qa=env.invoke_viiiiiiiiii;var ra=env.invoke_iii;var sa=env.invoke_iiiiii;var ta=env.invoke_diii;var ua=env.invoke_i;var va=env.invoke_iiiii;var wa=env.invoke_viii;var xa=env.invoke_v;var ya=env.invoke_iiiiiiiii;var za=env.invoke_iiiiid;var Aa=env.invoke_viiii;var Ba=env._fabs;var Ca=env._strftime;var Da=env._pthread_cond_wait;var Ea=env.___lock;var Fa=env._pthread_key_create;var Ga=env._abort;var Ha=env.___cxa_guard_acquire;var Ia=env.___setErrNo;var Ja=env.___gxx_personality_v0;var Ka=env.___assert_fail;var La=env.___cxa_free_exception;var Ma=env.___cxa_allocate_exception;var Na=env.___cxa_find_matching_catch;var Oa=env.__isLeapYear;var Pa=env.___cxa_guard_release;var Qa=env.__addDays;var Ra=env._strftime_l;var Sa=env._emscripten_set_main_loop_timing;var Ta=env._llvm_eh_typeid_for;var Ua=env._sbrk;var Va=env.___cxa_begin_catch;var Wa=env._emscripten_memcpy_big;var Xa=env.___cxa_end_catch;var Ya=env.___resumeException;var Za=env.__ZSt18uncaught_exceptionv;var _a=env._sysconf;var $a=env._pthread_getspecific;var ab=env.__arraySum;var bb=env._pthread_self;var cb=env._pthread_mutex_unlock;var db=env._pthread_once;var eb=env.___syscall54;var fb=env.___unlock;var gb=env._pthread_cleanup_pop;var hb=env._pthread_cond_broadcast;var ib=env._emscripten_set_main_loop;var jb=env._pthread_setspecific;var kb=env.___cxa_atexit;var lb=env.___cxa_throw;var mb=env.___cxa_rethrow;var nb=env.___syscall6;var ob=env._pthread_cleanup_push;var pb=env.___cxa_pure_virtual;var qb=env._time;var rb=env._pthread_mutex_lock;var sb=env.___cxa_guard_abort;var tb=env._atexit;var ub=env.___syscall140;var vb=env.___syscall145;var wb=env.___syscall146;var xb=0.0;
// EMSCRIPTEN_START_FUNCS
function Vb(a){a=a|0;var b=0;b=i;i=i+a|0;i=i+15&-16;return b|0}function Wb(){return i|0}function Xb(a){a=a|0;i=a}function Yb(a,b){a=a|0;b=b|0;i=a;j=b}function Zb(a,b){a=a|0;b=b|0;if(!o){o=a;p=b}}function _b(b){b=b|0;a[k>>0]=a[b>>0];a[k+1>>0]=a[b+1>>0];a[k+2>>0]=a[b+2>>0];a[k+3>>0]=a[b+3>>0]}function $b(b){b=b|0;a[k>>0]=a[b>>0];a[k+1>>0]=a[b+1>>0];a[k+2>>0]=a[b+2>>0];a[k+3>>0]=a[b+3>>0];a[k+4>>0]=a[b+4>>0];a[k+5>>0]=a[b+5>>0];a[k+6>>0]=a[b+6>>0];a[k+7>>0]=a[b+7>>0]}function ac(a){a=a|0;D=a}function bc(){return D|0}function cc(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;w=i;i=i+128|0;p=w+44|0;s=w+8|0;l=w+4|0;n=w;q=e+4|0;r=e+8|0;o=0;Aa(35,c[e>>2]|0,c[q>>2]|0,c[r>>2]|0,f|0);m=o;o=0;if(!(m&1)){j=p;h=j+84|0;do{c[j>>2]=c[f>>2];j=j+4|0;f=f+4|0}while((j|0)<(h|0));f=p+12|0;if((c[f>>2]|0)==0?(k=$(((c[p+8>>2]|0)+7|0)/8|0,c[p>>2]|0)|0,c[f>>2]=k,(c[p+24>>2]|0)!=0):0)c[f>>2]=$(c[p+16>>2]|0,k)|0;o=0;ha(176,s|0);m=o;o=0;if(!(m&1)){f=p+56|0;do if(c[f>>2]|0){o=0;f=ka(66,f|0)|0;m=o;o=0;if(!(m&1)){c[l>>2]=f;h=s+28|0;j=c[h>>2]|0;if(j>>>0<(c[s+32>>2]|0)>>>0){c[j>>2]=f;c[h>>2]=j+4;c[l>>2]=0;t=19;break}o=0;ia(57,s+24|0,l|0);m=o;o=0;if(m&1){h=Na(824,0)|0;f=D;j=c[l>>2]|0;c[l>>2]=0;if(!j)break;Bb[c[(c[j>>2]|0)+4>>2]&255](j);break}else{f=c[l>>2]|0;c[l>>2]=0;if(!f){t=19;break}Bb[c[(c[f>>2]|0)+4>>2]&255](f);t=19;break}}else t=15}else t=19;while(0);a:do if((t|0)==19){j=p+4|0;k=p+8|0;l=p+16|0;o=0;f=va(14,c[p>>2]|0,c[j>>2]|0,c[k>>2]|0,c[l>>2]|0)|0;m=o;o=0;if(!(m&1)){c[n>>2]=f;m=s+28|0;h=c[m>>2]|0;do if(h>>>0>=(c[s+32>>2]|0)>>>0){o=0;ia(57,s+24|0,n|0);h=o;o=0;if(h&1){h=Na(824,0)|0;f=D;j=c[n>>2]|0;c[n>>2]=0;if(!j)break a;Bb[c[(c[j>>2]|0)+4>>2]&255](j);break a}else{f=c[n>>2]|0;c[n>>2]=0;if(!f)break;Bb[c[(c[f>>2]|0)+4>>2]&255](f);break}}else{c[h>>2]=f;c[m>>2]=h+4;c[n>>2]=0}while(0);f=c[p+28>>2]|0;if((f|0)!=0?(o=0,ia(58,s|0,f|0),t=o,o=0,t&1):0){t=15;break}b:do if(!(c[p+24>>2]|0)){f=$(c[j>>2]|0,c[p>>2]|0)|0;f=$(f,((c[k>>2]|0)+7|0)/8|0)|0;if((c[l>>2]|0)>0){j=0;while(1){o=0;wa(4,s|0,e|0,p|0);t=o;o=0;if(t&1)break;h=c[q>>2]|0;if(h){c[q>>2]=h+f;c[r>>2]=(c[r>>2]|0)-f}j=j+1|0;if((j|0)>=(c[l>>2]|0))break b}h=Na(824,0)|0;f=D;t=16;break a}}else{o=0;wa(4,s|0,e|0,p|0);t=o;o=0;if(t&1){t=15;break a}}while(0);o=0;ra(33,s|0,b|0)|0;t=o;o=0;if(!(t&1)){c[d>>2]=c[s+16>>2];if(g)a[g>>0]=0;j=s+24|0;f=c[j>>2]|0;if(f){h=c[m>>2]|0;if((h|0)!=(f|0)){do{g=h+-4|0;c[m>>2]=g;h=c[g>>2]|0;c[g>>2]=0;if(h)Bb[c[(c[h>>2]|0)+4>>2]&255](h);h=c[m>>2]|0}while((h|0)!=(f|0));f=c[j>>2]|0}cj(f)}g=0;i=w;return g|0}else t=15}else t=15}while(0);if((t|0)==15){h=Na(824,0)|0;f=D;t=16}m=s+24|0;j=c[m>>2]|0;if(j){l=s+28|0;k=c[l>>2]|0;if((k|0)!=(j|0)){do{s=k+-4|0;c[l>>2]=s;k=c[s>>2]|0;c[s>>2]=0;if(k)Bb[c[(c[k>>2]|0)+4>>2]&255](k);k=c[l>>2]|0}while((k|0)!=(j|0));j=c[m>>2]|0}cj(j)}}else t=5}else t=5;if((t|0)==5){h=Na(824,0)|0;f=D}s=(f|0)==(Ta(824)|0);k=Va(h|0)|0;f=(g|0)==0;if(!s){if(!f)a[g>>0]=0;Xa();g=14;i=w;return g|0}j=k+12|0;do if(!f){f=c[j>>2]|0;o=0;h=ua(1)|0;s=o;o=0;if(!(s&1))if((f|0)==(h|0)){ml(g,Eb[c[(c[k>>2]|0)+8>>2]&127](k)|0)|0;t=60;break}else{a[g>>0]=0;t=60;break}}else t=60;while(0);if((t|0)==60?(u=c[j>>2]|0,o=0,v=ua(1)|0,g=o,o=0,!(g&1)):0){g=(u|0)==(v|0)?c[k+8>>2]|0:13;Xa();i=w;return g|0}f=Na()|0;o=0;xa(3);w=o;o=0;if(w&1){w=Na(0)|0;ec(w)}else Ya(f|0);return 0}function dc(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0;l=i;i=i+112|0;g=l+96|0;k=l+84|0;m=l+72|0;n=l+60|0;p=l+48|0;q=l+36|0;r=l+24|0;s=l+12|0;t=l;j=(b|0)==0;if((a|0)==0&j){f=Ma(16)|0;o=0;wa(5,g|0,48504,52);t=o;o=0;if(!(t&1)){o=0;b=ua(1)|0;t=o;o=0;if(!(t&1)?(o=0,Aa(36,f|0,1,b|0,g|0),t=o,o=0,!(t&1)):0){o=0;wa(6,f|0,824,96);o=0;a=0}else a=1;b=Na()|0;Im(g);if(!a){t=b;Ya(t|0)}}else b=Na()|0;La(f|0);t=b;Ya(t|0)}h=c[e>>2]|0;if((h+-1|0)>>>0>65534){f=Ma(16)|0;o=0;wa(5,k|0,48557,41);t=o;o=0;if(!(t&1)){o=0;b=ua(1)|0;t=o;o=0;if(!(t&1)?(o=0,Aa(36,f|0,1,b|0,k|0),t=o,o=0,!(t&1)):0){o=0;wa(6,f|0,824,96);o=0;a=0}else a=1;b=Na()|0;Im(k);if(!a){t=b;Ya(t|0)}}else b=Na()|0;La(f|0);t=b;Ya(t|0)}g=c[e+4>>2]|0;if((g+-1|0)>>>0>65534){f=Ma(16)|0;o=0;wa(5,m|0,48599,42);t=o;o=0;if(!(t&1)){o=0;b=ua(1)|0;t=o;o=0;if(!(t&1)?(o=0,Aa(36,f|0,1,b|0,m|0),t=o,o=0,!(t&1)):0){o=0;wa(6,f|0,824,96);o=0;a=0}else a=1;b=Na()|0;Im(m);if(!a){t=b;Ya(t|0)}}else b=Na()|0;La(f|0);t=b;Ya(t|0)}f=c[e+8>>2]|0;if((f+-2|0)>>>0>14){f=Ma(16)|0;o=0;wa(5,n|0,48642,46);t=o;o=0;if(!(t&1)){o=0;b=ua(1)|0;t=o;o=0;if(!(t&1)?(o=0,Aa(36,f|0,1,b|0,n|0),t=o,o=0,!(t&1)):0){o=0;wa(6,f|0,824,96);o=0;a=0}else a=1;b=Na()|0;Im(n);if(!a){t=b;Ya(t|0)}}else b=Na()|0;La(f|0);t=b;Ya(t|0)}a=c[e+24>>2]|0;if(a>>>0>=3){f=Ma(16)|0;o=0;wa(5,p|0,48689,65);t=o;o=0;if(!(t&1)){o=0;b=ua(1)|0;t=o;o=0;if(!(t&1)?(o=0,Aa(36,f|0,1,b|0,p|0),t=o,o=0,!(t&1)):0){o=0;wa(6,f|0,824,96);o=0;a=0}else a=1;b=Na()|0;Im(p);if(!a){t=b;Ya(t|0)}}else b=Na()|0;La(f|0);t=b;Ya(t|0)}b=c[e+16>>2]|0;if((b+-1|0)>>>0>254){f=Ma(16)|0;o=0;wa(5,q|0,48755,44);t=o;o=0;if(!(t&1)){o=0;b=ua(1)|0;t=o;o=0;if(!(t&1)?(o=0,Aa(36,f|0,1,b|0,q|0),t=o,o=0,!(t&1)):0){o=0;wa(6,f|0,824,96);o=0;a=0}else a=1;b=Na()|0;Im(q);if(!a){t=b;Ya(t|0)}}else b=Na()|0;La(f|0);t=b;Ya(t|0)}if(!j?(q=$(g,h)|0,($($(q,(f|0)>8?2:1)|0,b)|0)>>>0>d>>>0):0){f=Ma(16)|0;o=0;wa(5,r|0,48800,58);t=o;o=0;if(!(t&1)){o=0;b=ua(1)|0;t=o;o=0;if(!(t&1)?(o=0,Aa(36,f|0,1,b|0,r|0),t=o,o=0,!(t&1)):0){o=0;wa(6,f|0,824,96);o=0;a=0}else a=1;b=Na()|0;Im(r);if(!a){t=b;Ya(t|0)}}else b=Na()|0;La(f|0);t=b;Ya(t|0)}switch(b|0){case 4:{if((a|0)!=2){i=l;return}f=Ma(16)|0;o=0;wa(5,s|0,48859,73);t=o;o=0;if(!(t&1)){o=0;b=ua(1)|0;t=o;o=0;if(!(t&1)?(o=0,Aa(36,f|0,1,b|0,s|0),t=o,o=0,!(t&1)):0){o=0;wa(6,f|0,824,96);o=0;a=0}else a=1;b=Na()|0;Im(s);if(!a){t=b;Ya(t|0)}}else b=Na()|0;La(f|0);t=b;Ya(t|0)}case 3:{i=l;return}default:{if(!a){i=l;return}f=Ma(16)|0;o=0;wa(5,t|0,48933,73);s=o;o=0;if(!(s&1)){o=0;b=ua(1)|0;s=o;o=0;if(!(s&1)?(o=0,Aa(36,f|0,1,b|0,t|0),s=o,o=0,!(s&1)):0){o=0;wa(6,f|0,824,96);o=0;a=0}else a=1;b=Na()|0;Im(t);if(!a){t=b;Ya(t|0)}}else b=Na()|0;La(f|0);t=b;Ya(t|0)}}}function ec(a){a=a|0;Va(a|0)|0;jj()}function fc(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0;n=i;i=i+128|0;h=n+116|0;j=n;o=0;c[h>>2]=c[d>>2];c[h+4>>2]=c[d+4>>2];c[h+8>>2]=c[d+8>>2];ia(59,j|0,h|0);g=o;o=0;if(!(g&1)){if(e){g=j+16|0;d=g+84|0;do{c[g>>2]=c[e>>2];g=g+4|0;e=e+4|0}while((g|0)<(d|0))}o=0;c[h>>2]=c[b>>2];c[h+4>>2]=c[b+4>>2];c[h+8>>2]=c[b+8>>2];ia(60,j|0,h|0);j=o;o=0;if(!(j&1)){if(f)a[f>>0]=0;m=0;i=n;return m|0}}b=Na(824,0)|0;j=D;j=(j|0)==(Ta(824)|0);b=Va(b|0)|0;d=(f|0)==0;if(!j){if(!d)a[f>>0]=0;Xa();m=14;i=n;return m|0}g=b+12|0;do if(!d){d=c[g>>2]|0;o=0;e=ua(1)|0;j=o;o=0;if(!(j&1))if((d|0)==(e|0)){ml(f,Eb[c[(c[b>>2]|0)+8>>2]&127](b)|0)|0;m=10;break}else{a[f>>0]=0;m=10;break}}else m=10;while(0);if((m|0)==10?(k=c[g>>2]|0,o=0,l=ua(1)|0,m=o,o=0,!(m&1)):0){m=(k|0)==(l|0)?c[b+8>>2]|0:13;Xa();i=n;return m|0}d=Na()|0;o=0;xa(3);n=o;o=0;if(n&1){n=Na(0)|0;ec(n)}else Ya(d|0);return 0}function gc(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;l=i;i=i+128|0;g=l+116|0;f=l;o=0;c[g>>2]=c[b>>2];c[g+4>>2]=c[b+4>>2];c[g+8>>2]=c[b+8>>2];ia(59,f|0,g|0);g=o;o=0;if((!(g&1)?(o=0,ha(177,f|0),g=o,o=0,!(g&1)):0)?(o=0,ia(61,f|0,1),g=o,o=0,!(g&1)):0){b=f+16|0;f=d+84|0;do{c[d>>2]=c[b>>2];d=d+4|0;b=b+4|0}while((d|0)<(f|0));if(e)a[e>>0]=0;e=0;i=l;return e|0}g=Na(824,0)|0;d=D;d=(d|0)==(Ta(824)|0);g=Va(g|0)|0;b=(e|0)==0;if(!d){if(!b)a[e>>0]=0;Xa();e=14;i=l;return e|0}d=g+12|0;do if(!b){b=c[d>>2]|0;o=0;f=ua(1)|0;m=o;o=0;if(!(m&1))if((b|0)==(f|0)){ml(e,Eb[c[(c[g>>2]|0)+8>>2]&127](g)|0)|0;k=13;break}else{a[e>>0]=0;k=13;break}}else k=13;while(0);if((k|0)==13?(h=c[d>>2]|0,o=0,j=ua(1)|0,m=o,o=0,!(m&1)):0){m=(h|0)==(j|0)?c[g+8>>2]|0:13;Xa();i=l;return m|0}b=Na()|0;o=0;xa(3);m=o;o=0;if(m&1){m=Na(0)|0;ec(m)}else Ya(b|0);return 0}function hc(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0;n=i;i=i+48|0;k=n+36|0;j=n+24|0;l=n+12|0;m=n;if(!((a|0)!=0&(d|0)!=0&(e|0)!=0&(g|0)!=0)){f=1;i=n;return f|0}c[l>>2]=0;c[l+4>>2]=a;c[l+8>>2]=b;c[m>>2]=0;c[m+4>>2]=e;c[m+8>>2]=f;c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[k>>2]=c[m>>2];c[k+4>>2]=c[m+4>>2];c[k+8>>2]=c[m+8>>2];f=cc(j,d,k,g,h)|0;i=n;return f|0}function ic(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0;f=i;i=i+32|0;g=f+12|0;h=f;j=h;c[j>>2]=0;c[j+4>>2]=0;c[h+4>>2]=a;c[h+8>>2]=b;c[g>>2]=c[h>>2];c[g+4>>2]=c[h+4>>2];c[g+8>>2]=c[h+8>>2];d=gc(g,d,e)|0;i=f;return d|0}function jc(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+48|0;j=h+36|0;k=h+24|0;m=h+12|0;l=h;c[m>>2]=0;c[m+4>>2]=a;c[m+8>>2]=b;c[l>>2]=0;c[l+4>>2]=d;c[l+8>>2]=e;c[k>>2]=c[m>>2];c[k+4>>2]=c[m+4>>2];c[k+8>>2]=c[m+8>>2];c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];e=fc(k,j,f,g)|0;i=h;return e|0}function kc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;k=a+4|0;d=c[a>>2]|0;f=((c[k>>2]|0)-d>>2)+1|0;if(f>>>0>1073741823){$i(a);d=c[a>>2]|0}l=a+8|0;e=(c[l>>2]|0)-d|0;if(e>>2>>>0<536870911){e=e>>1;e=e>>>0<f>>>0?f:e;d=(c[k>>2]|0)-d>>2;if(!e){g=0;h=0}else i=6}else{e=1073741823;d=(c[k>>2]|0)-d>>2;i=6}if((i|0)==6){g=e;h=bj(e<<2)|0}f=h+(d<<2)|0;e=f;j=h+(g<<2)|0;i=c[b>>2]|0;c[b>>2]=0;c[f>>2]=i;i=h+(d+1<<2)|0;h=c[a>>2]|0;d=c[k>>2]|0;if((d|0)==(h|0)){f=a;g=k}else{do{d=d+-4|0;b=c[d>>2]|0;c[d>>2]=0;c[f+-4>>2]=b;f=e+-4|0;e=f}while((d|0)!=(h|0));d=e;f=a;g=k;e=d;h=c[a>>2]|0;d=c[k>>2]|0}c[f>>2]=e;c[g>>2]=i;c[l>>2]=j;f=h;if((d|0)!=(f|0))do{d=d+-4|0;e=c[d>>2]|0;c[d>>2]=0;if(e)Bb[c[(c[e>>2]|0)+4>>2]&255](e)}while((d|0)!=(f|0));if(!h)return;cj(h);return}function lc(){if(a[8]|0)return 35648;if(!(Ha(8)|0))return 35648;kb(72,35648,n|0)|0;Pa(8);return 35648}function mc(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;n=i;i=i+32|0;l=n;Ei(l,(1<<d)+-1|0,0);h=c[l>>2]|0;m=h+1|0;e=m<<1;c[b>>2]=0;j=b+4|0;c[j>>2]=0;c[b+8>>2]=0;a:do if(m){if(!((h|0)<-1?(o=0,ha(178,b|0),k=o,o=0,k&1):0))f=4;if((f|0)==4?(o=0,g=ka(67,e|0)|0,k=o,o=0,!(k&1)):0){c[j>>2]=g;c[b>>2]=g;c[b+8>>2]=g+e;d=g;while(1){a[d>>0]=0;d=(c[j>>2]|0)+1|0;c[j>>2]=d;e=e+-1|0;if(!e)break a}}e=Na()|0;d=c[b>>2]|0;if(!d)Ya(e|0);if((c[j>>2]|0)!=(d|0))c[j>>2]=d;cj(d);Ya(e|0)}while(0);d=~h;if((h|0)<(d|0)){i=n;return}j=l+12|0;k=l+8|0;h=l+4|0;g=d;do{d=c[j>>2]|0;if((g|0)>(0-d|0)){e=c[k>>2]|0;if((g|0)>(0-e|0)){f=c[h>>2]|0;if((g|0)>(0-f|0))if((g|0)>=0)if((g|0)>0)if((f|0)<=(g|0))if((e|0)>(g|0))d=2;else d=(d|0)>(g|0)?3:4;else d=1;else d=0;else d=-1;else d=-2}else d=-3}else d=-4;a[(c[b>>2]|0)+(g+m)>>0]=d;g=g+1|0}while((g|0)<(m|0));i=n;return}function nc(d,e,f){d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0;q=c[f+16>>2]|0;switch(q|0){case 64:case 0:{o=0;d=ra(34,d|0,e|0)|0;e=o;o=0;if(e&1)r=16;else g=d;break}default:{h=(1<<c[e+8>>2])+-1|0;p=c[e+20>>2]|0;n=p<<1;n=((n+h|0)/(n|1|0)|0)+1|0;d=0;while(1)if((1<<d|0)<(n|0))d=d+1|0;else break;g=0;while(1)if((1<<g|0)<(h|0))g=g+1|0;else{j=g;break}h=c[f>>2]|0;o=0;g=ka(67,4624)|0;m=o;o=0;if(m&1)r=16;else{i=((j|0)<8?8:j)+j<<1;k=g+4|0;l=e;m=k+84|0;do{c[k>>2]=c[l>>2];k=k+4|0;l=l+4|0}while((k|0)<(m|0));k=g+88|0;m=k+40|0;do{c[k>>2]=0;k=k+4|0}while((k|0)<(m|0));c[g>>2]=35660;c[g+128>>2]=h;c[g+132>>2]=n;c[g+136>>2]=p;c[g+140>>2]=d;c[g+144>>2]=j;c[g+148>>2]=i;c[g+152>>2]=q;d=g+156|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[g+172>>2]=c[e>>2];c[g+176>>2]=0;c[g+180>>2]=0;c[g+184>>2]=0;d=g+4568|0;h=g+188|0;do{c[h>>2]=0;c[h+4>>2]=0;b[h+8>>1]=0;b[h+10>>1]=1;h=h+12|0}while((h|0)!=(d|0));c[d>>2]=0;c[d+4>>2]=0;b[d+8>>1]=0;a[d+10>>0]=0;e=g+4580|0;c[e>>2]=0;c[e+4>>2]=0;b[e+8>>1]=0;a[e+10>>0]=0;e=g+4592|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;c[e+24>>2]=0;a[e+28>>0]=0;if(!(c[g+28>>2]|0))c[g+20>>2]=1}}}if((r|0)==16){r=Na()|0;Ya(r|0)}if(!g)return g|0;o=0;ia(c[(c[g>>2]|0)+12>>2]|0,g|0,f|0);r=o;o=0;if(!(r&1))return g|0;d=Na()|0;if(!g){r=d;Ya(r|0)}Bb[c[(c[g>>2]|0)+4>>2]&255](g);r=d;Ya(r|0);return 0}function oc(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;f=(c[e+24>>2]|0)==2;if(f?(c[e+16>>2]|0)!=3:0){e=0;return e|0}n=c[e+20>>2]|0;d=c[e+8>>2]|0;a:do if(!n){if(f){if((d|0)!=8)break;g=bj(4600)|0;j=g+4|0;k=e;l=j+84|0;do{c[j>>2]=c[k>>2];j=j+4|0;k=k+4|0}while((j|0)<(l|0));j=g+88|0;l=j+40|0;do{c[j>>2]=0;j=j+4|0}while((j|0)<(l|0));c[g>>2]=35688;d=g+132|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[g+148>>2]=c[e>>2];c[g+152>>2]=0;c[g+156>>2]=0;c[g+160>>2]=0;d=g+4544|0;f=g+164|0;do{c[f>>2]=0;c[f+4>>2]=0;b[f+8>>1]=0;b[f+10>>1]=1;f=f+12|0}while((f|0)!=(d|0));c[d>>2]=0;c[d+4>>2]=0;b[d+8>>1]=0;a[d+10>>0]=0;e=g+4556|0;c[e>>2]=0;c[e+4>>2]=0;b[e+8>>1]=0;a[e+10>>0]=0;e=g+4568|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;c[e+24>>2]=0;a[e+28>>0]=0;if(!(c[g+28>>2]|0))c[g+20>>2]=1;e=g;return e|0}switch(d|0){case 8:{g=bj(4600)|0;j=g+4|0;k=e;l=j+84|0;do{c[j>>2]=c[k>>2];j=j+4|0;k=k+4|0}while((j|0)<(l|0));j=g+88|0;l=j+40|0;do{c[j>>2]=0;j=j+4|0}while((j|0)<(l|0));c[g>>2]=35716;d=g+132|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[g+148>>2]=c[e>>2];c[g+152>>2]=0;c[g+156>>2]=0;c[g+160>>2]=0;d=g+4544|0;f=g+164|0;do{c[f>>2]=0;c[f+4>>2]=0;b[f+8>>1]=0;b[f+10>>1]=1;f=f+12|0}while((f|0)!=(d|0));c[d>>2]=0;c[d+4>>2]=0;b[d+8>>1]=0;a[d+10>>0]=0;e=g+4556|0;c[e>>2]=0;c[e+4>>2]=0;b[e+8>>1]=0;a[e+10>>0]=0;e=g+4568|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;c[e+24>>2]=0;a[e+28>>0]=0;if(!(c[g+28>>2]|0))c[g+20>>2]=1;e=g;return e|0}case 12:{g=bj(4600)|0;j=g+4|0;k=e;l=j+84|0;do{c[j>>2]=c[k>>2];j=j+4|0;k=k+4|0}while((j|0)<(l|0));j=g+88|0;l=j+40|0;do{c[j>>2]=0;j=j+4|0}while((j|0)<(l|0));c[g>>2]=35744;d=g+132|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[g+148>>2]=c[e>>2];c[g+152>>2]=0;c[g+156>>2]=0;c[g+160>>2]=0;d=g+4544|0;f=g+164|0;do{c[f>>2]=0;c[f+4>>2]=0;b[f+8>>1]=0;b[f+10>>1]=1;f=f+12|0}while((f|0)!=(d|0));c[d>>2]=0;c[d+4>>2]=0;b[d+8>>1]=0;a[d+10>>0]=0;e=g+4556|0;c[e>>2]=0;c[e+4>>2]=0;b[e+8>>1]=0;a[e+10>>0]=0;e=g+4568|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;c[e+24>>2]=0;a[e+28>>0]=0;if(!(c[g+28>>2]|0))c[g+20>>2]=1;e=g;return e|0}case 16:{g=bj(4600)|0;j=g+4|0;k=e;l=j+84|0;do{c[j>>2]=c[k>>2];j=j+4|0;k=k+4|0}while((j|0)<(l|0));j=g+88|0;l=j+40|0;do{c[j>>2]=0;j=j+4|0}while((j|0)<(l|0));c[g>>2]=35772;d=g+132|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[g+148>>2]=c[e>>2];c[g+152>>2]=0;c[g+156>>2]=0;c[g+160>>2]=0;d=g+4544|0;f=g+164|0;do{c[f>>2]=0;c[f+4>>2]=0;b[f+8>>1]=0;b[f+10>>1]=1;f=f+12|0}while((f|0)!=(d|0));c[d>>2]=0;c[d+4>>2]=0;b[d+8>>1]=0;a[d+10>>0]=0;e=g+4556|0;c[e>>2]=0;c[e+4>>2]=0;b[e+8>>1]=0;a[e+10>>0]=0;e=g+4568|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;c[e+24>>2]=0;a[e+28>>0]=0;if(!(c[g+28>>2]|0))c[g+20>>2]=1;e=g;return e|0}default:break a}}while(0);m=(1<<d)+-1|0;if((d|0)<9){i=n<<1;i=((i+m|0)/(i|1|0)|0)+1|0;if(f){d=0;while(1)if((1<<d|0)<(i|0))d=d+1|0;else break;f=0;while(1)if((1<<f|0)<(m|0))f=f+1|0;else break;g=((f|0)<8?8:f)+f<<1;h=bj(4624)|0;j=h+4|0;k=e;l=j+84|0;do{c[j>>2]=c[k>>2];j=j+4|0;k=k+4|0}while((j|0)<(l|0));j=h+88|0;l=j+40|0;do{c[j>>2]=0;j=j+4|0}while((j|0)<(l|0));c[h>>2]=35800;c[h+128>>2]=m;c[h+132>>2]=i;c[h+136>>2]=n;c[h+140>>2]=d;c[h+144>>2]=f;c[h+148>>2]=g;c[h+152>>2]=64;d=h+156|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[h+172>>2]=c[e>>2];c[h+176>>2]=0;c[h+180>>2]=0;c[h+184>>2]=0;d=h+4568|0;f=h+188|0;do{c[f>>2]=0;c[f+4>>2]=0;b[f+8>>1]=0;b[f+10>>1]=1;f=f+12|0}while((f|0)!=(d|0));c[d>>2]=0;c[d+4>>2]=0;b[d+8>>1]=0;a[d+10>>0]=0;e=h+4580|0;c[e>>2]=0;c[e+4>>2]=0;b[e+8>>1]=0;a[e+10>>0]=0;e=h+4592|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;c[e+24>>2]=0;a[e+28>>0]=0;if(!(c[h+28>>2]|0))c[h+20>>2]=1;e=h;return e|0}else{d=0;while(1)if((1<<d|0)<(i|0))d=d+1|0;else break;f=0;while(1)if((1<<f|0)<(m|0))f=f+1|0;else break;g=((f|0)<8?8:f)+f<<1;h=bj(4624)|0;j=h+4|0;k=e;l=j+84|0;do{c[j>>2]=c[k>>2];j=j+4|0;k=k+4|0}while((j|0)<(l|0));j=h+88|0;l=j+40|0;do{c[j>>2]=0;j=j+4|0}while((j|0)<(l|0));c[h>>2]=35660;c[h+128>>2]=m;c[h+132>>2]=i;c[h+136>>2]=n;c[h+140>>2]=d;c[h+144>>2]=f;c[h+148>>2]=g;c[h+152>>2]=64;d=h+156|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[h+172>>2]=c[e>>2];c[h+176>>2]=0;c[h+180>>2]=0;c[h+184>>2]=0;d=h+4568|0;f=h+188|0;do{c[f>>2]=0;c[f+4>>2]=0;b[f+8>>1]=0;b[f+10>>1]=1;f=f+12|0}while((f|0)!=(d|0));c[d>>2]=0;c[d+4>>2]=0;b[d+8>>1]=0;a[d+10>>0]=0;e=h+4580|0;c[e>>2]=0;c[e+4>>2]=0;b[e+8>>1]=0;a[e+10>>0]=0;e=h+4592|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;c[e+24>>2]=0;a[e+28>>0]=0;if(!(c[h+28>>2]|0))c[h+20>>2]=1;e=h;return e|0}}if((d|0)>=17){e=0;return e|0}i=n<<1;i=((i+m|0)/(i|1|0)|0)+1|0;if(f){d=0;while(1)if((1<<d|0)<(i|0))d=d+1|0;else break;f=0;while(1)if((1<<f|0)<(m|0))f=f+1|0;else break;g=((f|0)<8?8:f)+f<<1;h=bj(4624)|0;j=h+4|0;k=e;l=j+84|0;do{c[j>>2]=c[k>>2];j=j+4|0;k=k+4|0}while((j|0)<(l|0));j=h+88|0;l=j+40|0;do{c[j>>2]=0;j=j+4|0}while((j|0)<(l|0));c[h>>2]=35828;c[h+128>>2]=m;c[h+132>>2]=i;c[h+136>>2]=n;c[h+140>>2]=d;c[h+144>>2]=f;c[h+148>>2]=g;c[h+152>>2]=64;d=h+156|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[h+172>>2]=c[e>>2];c[h+176>>2]=0;c[h+180>>2]=0;c[h+184>>2]=0;d=h+4568|0;f=h+188|0;do{c[f>>2]=0;c[f+4>>2]=0;b[f+8>>1]=0;b[f+10>>1]=1;f=f+12|0}while((f|0)!=(d|0));c[d>>2]=0;c[d+4>>2]=0;b[d+8>>1]=0;a[d+10>>0]=0;e=h+4580|0;c[e>>2]=0;c[e+4>>2]=0;b[e+8>>1]=0;a[e+10>>0]=0;e=h+4592|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;c[e+24>>2]=0;a[e+28>>0]=0;if(!(c[h+28>>2]|0))c[h+20>>2]=1;e=h;return e|0}else{d=0;while(1)if((1<<d|0)<(i|0))d=d+1|0;else break;f=0;while(1)if((1<<f|0)<(m|0))f=f+1|0;else break;g=((f|0)<8?8:f)+f<<1;h=bj(4624)|0;j=h+4|0;k=e;l=j+84|0;do{c[j>>2]=c[k>>2];j=j+4|0;k=k+4|0}while((j|0)<(l|0));j=h+88|0;l=j+40|0;do{c[j>>2]=0;j=j+4|0}while((j|0)<(l|0));c[h>>2]=35856;c[h+128>>2]=m;c[h+132>>2]=i;c[h+136>>2]=n;c[h+140>>2]=d;c[h+144>>2]=f;c[h+148>>2]=g;c[h+152>>2]=64;d=h+156|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[h+172>>2]=c[e>>2];c[h+176>>2]=0;c[h+180>>2]=0;c[h+184>>2]=0;d=h+4568|0;f=h+188|0;do{c[f>>2]=0;c[f+4>>2]=0;b[f+8>>1]=0;b[f+10>>1]=1;f=f+12|0}while((f|0)!=(d|0));c[d>>2]=0;c[d+4>>2]=0;b[d+8>>1]=0;a[d+10>>0]=0;e=h+4580|0;c[e>>2]=0;c[e+4>>2]=0;b[e+8>>1]=0;a[e+10>>0]=0;e=h+4592|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;c[e+24>>2]=0;a[e+28>>0]=0;if(!(c[h+28>>2]|0))c[h+20>>2]=1;e=h;return e|0}return 0}function pc(d,e,f){d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0;q=c[f+16>>2]|0;switch(q|0){case 64:case 0:{o=0;d=ra(35,d|0,e|0)|0;e=o;o=0;if(e&1)r=16;else g=d;break}default:{h=(1<<c[e+8>>2])+-1|0;p=c[e+20>>2]|0;n=p<<1;n=((n+h|0)/(n|1|0)|0)+1|0;d=0;while(1)if((1<<d|0)<(n|0))d=d+1|0;else break;g=0;while(1)if((1<<g|0)<(h|0))g=g+1|0;else{j=g;break}h=c[f>>2]|0;o=0;g=ka(67,4632)|0;m=o;o=0;if(m&1)r=16;else{i=((j|0)<8?8:j)+j<<1;c[g+4>>2]=0;k=g+8|0;l=e;m=k+84|0;do{c[k>>2]=c[l>>2];k=k+4|0;l=l+4|0}while((k|0)<(m|0));c[g+92>>2]=0;c[g+96>>2]=0;c[g+100>>2]=32;c[g+104>>2]=0;c[g+108>>2]=0;a[g+112>>0]=0;m=g+116|0;c[m>>2]=0;c[m+4>>2]=0;c[m+8>>2]=0;c[m+12>>2]=0;c[m+16>>2]=0;c[g>>2]=35884;c[g+136>>2]=h;c[g+140>>2]=n;c[g+144>>2]=p;c[g+148>>2]=d;c[g+152>>2]=j;c[g+156>>2]=i;c[g+160>>2]=q;d=g+164|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[g+180>>2]=c[e>>2];c[g+184>>2]=0;c[g+188>>2]=0;c[g+192>>2]=0;d=g+4576|0;h=g+196|0;do{c[h>>2]=0;c[h+4>>2]=0;b[h+8>>1]=0;b[h+10>>1]=1;h=h+12|0}while((h|0)!=(d|0));c[d>>2]=0;c[d+4>>2]=0;b[d+8>>1]=0;a[d+10>>0]=0;e=g+4588|0;c[e>>2]=0;c[e+4>>2]=0;b[e+8>>1]=0;a[e+10>>0]=0;e=g+4600|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;c[e+24>>2]=0;a[e+28>>0]=0;if(!(c[g+32>>2]|0))c[g+24>>2]=1}}}if((r|0)==16){r=Na()|0;Ya(r|0)}if(!g)return g|0;o=0;ia(c[(c[g>>2]|0)+8>>2]|0,g|0,f|0);r=o;o=0;if(!(r&1))return g|0;d=Na()|0;if(!g){r=d;Ya(r|0)}Bb[c[(c[g>>2]|0)+4>>2]&255](g);r=d;Ya(r|0);return 0}function qc(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;f=(c[e+24>>2]|0)==2;if(f?(c[e+16>>2]|0)!=3:0){e=0;return e|0}n=c[e+20>>2]|0;d=c[e+8>>2]|0;a:do if(!n){if(f){if((d|0)!=8)break;g=bj(4608)|0;c[g+4>>2]=0;j=g+8|0;k=e;l=j+84|0;do{c[j>>2]=c[k>>2];j=j+4|0;k=k+4|0}while((j|0)<(l|0));c[g+92>>2]=0;c[g+96>>2]=0;c[g+100>>2]=32;c[g+104>>2]=0;c[g+108>>2]=0;a[g+112>>0]=0;d=g+116|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[g>>2]=35912;d=g+140|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[g+156>>2]=c[e>>2];c[g+160>>2]=0;c[g+164>>2]=0;c[g+168>>2]=0;d=g+4552|0;f=g+172|0;do{c[f>>2]=0;c[f+4>>2]=0;b[f+8>>1]=0;b[f+10>>1]=1;f=f+12|0}while((f|0)!=(d|0));c[d>>2]=0;c[d+4>>2]=0;b[d+8>>1]=0;a[d+10>>0]=0;e=g+4564|0;c[e>>2]=0;c[e+4>>2]=0;b[e+8>>1]=0;a[e+10>>0]=0;e=g+4576|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;c[e+24>>2]=0;a[e+28>>0]=0;if(!(c[g+32>>2]|0))c[g+24>>2]=1;e=g;return e|0}switch(d|0){case 8:{g=bj(4608)|0;c[g+4>>2]=0;j=g+8|0;k=e;l=j+84|0;do{c[j>>2]=c[k>>2];j=j+4|0;k=k+4|0}while((j|0)<(l|0));c[g+92>>2]=0;c[g+96>>2]=0;c[g+100>>2]=32;c[g+104>>2]=0;c[g+108>>2]=0;a[g+112>>0]=0;d=g+116|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[g>>2]=35940;d=g+140|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[g+156>>2]=c[e>>2];c[g+160>>2]=0;c[g+164>>2]=0;c[g+168>>2]=0;d=g+4552|0;f=g+172|0;do{c[f>>2]=0;c[f+4>>2]=0;b[f+8>>1]=0;b[f+10>>1]=1;f=f+12|0}while((f|0)!=(d|0));c[d>>2]=0;c[d+4>>2]=0;b[d+8>>1]=0;a[d+10>>0]=0;e=g+4564|0;c[e>>2]=0;c[e+4>>2]=0;b[e+8>>1]=0;a[e+10>>0]=0;e=g+4576|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;c[e+24>>2]=0;a[e+28>>0]=0;if(!(c[g+32>>2]|0))c[g+24>>2]=1;e=g;return e|0}case 12:{g=bj(4608)|0;c[g+4>>2]=0;j=g+8|0;k=e;l=j+84|0;do{c[j>>2]=c[k>>2];j=j+4|0;k=k+4|0}while((j|0)<(l|0));c[g+92>>2]=0;c[g+96>>2]=0;c[g+100>>2]=32;c[g+104>>2]=0;c[g+108>>2]=0;a[g+112>>0]=0;d=g+116|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[g>>2]=35968;d=g+140|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[g+156>>2]=c[e>>2];c[g+160>>2]=0;c[g+164>>2]=0;c[g+168>>2]=0;d=g+4552|0;f=g+172|0;do{c[f>>2]=0;c[f+4>>2]=0;b[f+8>>1]=0;b[f+10>>1]=1;f=f+12|0}while((f|0)!=(d|0));c[d>>2]=0;c[d+4>>2]=0;b[d+8>>1]=0;a[d+10>>0]=0;e=g+4564|0;c[e>>2]=0;c[e+4>>2]=0;b[e+8>>1]=0;a[e+10>>0]=0;e=g+4576|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;c[e+24>>2]=0;a[e+28>>0]=0;if(!(c[g+32>>2]|0))c[g+24>>2]=1;e=g;return e|0}case 16:{g=bj(4608)|0;c[g+4>>2]=0;j=g+8|0;k=e;l=j+84|0;do{c[j>>2]=c[k>>2];j=j+4|0;k=k+4|0}while((j|0)<(l|0));c[g+92>>2]=0;c[g+96>>2]=0;c[g+100>>2]=32;c[g+104>>2]=0;c[g+108>>2]=0;a[g+112>>0]=0;d=g+116|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[g>>2]=35996;d=g+140|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[g+156>>2]=c[e>>2];c[g+160>>2]=0;c[g+164>>2]=0;c[g+168>>2]=0;d=g+4552|0;f=g+172|0;do{c[f>>2]=0;c[f+4>>2]=0;b[f+8>>1]=0;b[f+10>>1]=1;f=f+12|0}while((f|0)!=(d|0));c[d>>2]=0;c[d+4>>2]=0;b[d+8>>1]=0;a[d+10>>0]=0;e=g+4564|0;c[e>>2]=0;c[e+4>>2]=0;b[e+8>>1]=0;a[e+10>>0]=0;e=g+4576|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;c[e+24>>2]=0;a[e+28>>0]=0;if(!(c[g+32>>2]|0))c[g+24>>2]=1;e=g;return e|0}default:break a}}while(0);m=(1<<d)+-1|0;if((d|0)<9){i=n<<1;i=((i+m|0)/(i|1|0)|0)+1|0;if(f){d=0;while(1)if((1<<d|0)<(i|0))d=d+1|0;else break;f=0;while(1)if((1<<f|0)<(m|0))f=f+1|0;else break;g=((f|0)<8?8:f)+f<<1;h=bj(4632)|0;c[h+4>>2]=0;j=h+8|0;k=e;l=j+84|0;do{c[j>>2]=c[k>>2];j=j+4|0;k=k+4|0}while((j|0)<(l|0));c[h+92>>2]=0;c[h+96>>2]=0;c[h+100>>2]=32;c[h+104>>2]=0;c[h+108>>2]=0;a[h+112>>0]=0;l=h+116|0;c[l>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;c[l+12>>2]=0;c[l+16>>2]=0;c[h>>2]=36024;c[h+136>>2]=m;c[h+140>>2]=i;c[h+144>>2]=n;c[h+148>>2]=d;c[h+152>>2]=f;c[h+156>>2]=g;c[h+160>>2]=64;d=h+164|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[h+180>>2]=c[e>>2];c[h+184>>2]=0;c[h+188>>2]=0;c[h+192>>2]=0;d=h+4576|0;f=h+196|0;do{c[f>>2]=0;c[f+4>>2]=0;b[f+8>>1]=0;b[f+10>>1]=1;f=f+12|0}while((f|0)!=(d|0));c[d>>2]=0;c[d+4>>2]=0;b[d+8>>1]=0;a[d+10>>0]=0;e=h+4588|0;c[e>>2]=0;c[e+4>>2]=0;b[e+8>>1]=0;a[e+10>>0]=0;e=h+4600|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;c[e+24>>2]=0;a[e+28>>0]=0;if(!(c[h+32>>2]|0))c[h+24>>2]=1;e=h;return e|0}else{d=0;while(1)if((1<<d|0)<(i|0))d=d+1|0;else break;f=0;while(1)if((1<<f|0)<(m|0))f=f+1|0;else break;g=((f|0)<8?8:f)+f<<1;h=bj(4632)|0;c[h+4>>2]=0;j=h+8|0;k=e;l=j+84|0;do{c[j>>2]=c[k>>2];j=j+4|0;k=k+4|0}while((j|0)<(l|0));c[h+92>>2]=0;c[h+96>>2]=0;c[h+100>>2]=32;c[h+104>>2]=0;c[h+108>>2]=0;a[h+112>>0]=0;l=h+116|0;c[l>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;c[l+12>>2]=0;c[l+16>>2]=0;c[h>>2]=35884;c[h+136>>2]=m;c[h+140>>2]=i;c[h+144>>2]=n;c[h+148>>2]=d;c[h+152>>2]=f;c[h+156>>2]=g;c[h+160>>2]=64;d=h+164|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[h+180>>2]=c[e>>2];c[h+184>>2]=0;c[h+188>>2]=0;c[h+192>>2]=0;d=h+4576|0;f=h+196|0;do{c[f>>2]=0;c[f+4>>2]=0;b[f+8>>1]=0;b[f+10>>1]=1;f=f+12|0}while((f|0)!=(d|0));c[d>>2]=0;c[d+4>>2]=0;b[d+8>>1]=0;a[d+10>>0]=0;e=h+4588|0;c[e>>2]=0;c[e+4>>2]=0;b[e+8>>1]=0;a[e+10>>0]=0;e=h+4600|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;c[e+24>>2]=0;a[e+28>>0]=0;if(!(c[h+32>>2]|0))c[h+24>>2]=1;e=h;return e|0}}if((d|0)>=17){e=0;return e|0}i=n<<1;i=((i+m|0)/(i|1|0)|0)+1|0;if(f){d=0;while(1)if((1<<d|0)<(i|0))d=d+1|0;else break;f=0;while(1)if((1<<f|0)<(m|0))f=f+1|0;else break;g=((f|0)<8?8:f)+f<<1;h=bj(4632)|0;c[h+4>>2]=0;j=h+8|0;k=e;l=j+84|0;do{c[j>>2]=c[k>>2];j=j+4|0;k=k+4|0}while((j|0)<(l|0));c[h+92>>2]=0;c[h+96>>2]=0;c[h+100>>2]=32;c[h+104>>2]=0;c[h+108>>2]=0;a[h+112>>0]=0;l=h+116|0;c[l>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;c[l+12>>2]=0;c[l+16>>2]=0;c[h>>2]=36052;c[h+136>>2]=m;c[h+140>>2]=i;c[h+144>>2]=n;c[h+148>>2]=d;c[h+152>>2]=f;c[h+156>>2]=g;c[h+160>>2]=64;d=h+164|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[h+180>>2]=c[e>>2];c[h+184>>2]=0;c[h+188>>2]=0;c[h+192>>2]=0;d=h+4576|0;f=h+196|0;do{c[f>>2]=0;c[f+4>>2]=0;b[f+8>>1]=0;b[f+10>>1]=1;f=f+12|0}while((f|0)!=(d|0));c[d>>2]=0;c[d+4>>2]=0;b[d+8>>1]=0;a[d+10>>0]=0;e=h+4588|0;c[e>>2]=0;c[e+4>>2]=0;b[e+8>>1]=0;a[e+10>>0]=0;e=h+4600|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;c[e+24>>2]=0;a[e+28>>0]=0;if(!(c[h+32>>2]|0))c[h+24>>2]=1;e=h;return e|0}else{d=0;while(1)if((1<<d|0)<(i|0))d=d+1|0;else break;f=0;while(1)if((1<<f|0)<(m|0))f=f+1|0;else break;g=((f|0)<8?8:f)+f<<1;h=bj(4632)|0;c[h+4>>2]=0;j=h+8|0;k=e;l=j+84|0;do{c[j>>2]=c[k>>2];j=j+4|0;k=k+4|0}while((j|0)<(l|0));c[h+92>>2]=0;c[h+96>>2]=0;c[h+100>>2]=32;c[h+104>>2]=0;c[h+108>>2]=0;a[h+112>>0]=0;l=h+116|0;c[l>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;c[l+12>>2]=0;c[l+16>>2]=0;c[h>>2]=36080;c[h+136>>2]=m;c[h+140>>2]=i;c[h+144>>2]=n;c[h+148>>2]=d;c[h+152>>2]=f;c[h+156>>2]=g;c[h+160>>2]=64;d=h+164|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[h+180>>2]=c[e>>2];c[h+184>>2]=0;c[h+188>>2]=0;c[h+192>>2]=0;d=h+4576|0;f=h+196|0;do{c[f>>2]=0;c[f+4>>2]=0;b[f+8>>1]=0;b[f+10>>1]=1;f=f+12|0}while((f|0)!=(d|0));c[d>>2]=0;c[d+4>>2]=0;b[d+8>>1]=0;a[d+10>>0]=0;e=h+4588|0;c[e>>2]=0;c[e+4>>2]=0;b[e+8>>1]=0;a[e+10>>0]=0;e=h+4600|0;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;c[e+12>>2]=0;c[e+16>>2]=0;c[e+20>>2]=0;c[e+24>>2]=0;a[e+28>>0]=0;if(!(c[h+32>>2]|0))c[h+24>>2]=1;e=h;return e|0}return 0}function rc(){var a=0,b=0,d=0,e=0,f=0,g=0,h=0;a=2832;do{c[a>>2]=0;c[a+4>>2]=0;a=a+8|0}while((a|0)!=4880);iw(2832,0,2048)|0;a=0;do{h=2832+(a+128<<3)|0;c[h>>2]=0;c[h+4>>2]=1;a=a+1|0}while((a|0)!=128);a=3088;c[a>>2]=1;c[a+4>>2]=3;a=3096;c[a>>2]=1;c[a+4>>2]=3;a=3104;c[a>>2]=1;c[a+4>>2]=3;a=3112;c[a>>2]=1;c[a+4>>2]=3;a=3120;c[a>>2]=1;c[a+4>>2]=3;a=3128;c[a>>2]=1;c[a+4>>2]=3;a=3136;c[a>>2]=1;c[a+4>>2]=3;a=3144;c[a>>2]=1;c[a+4>>2]=3;a=3152;c[a>>2]=1;c[a+4>>2]=3;a=3160;c[a>>2]=1;c[a+4>>2]=3;a=3168;c[a>>2]=1;c[a+4>>2]=3;a=3176;c[a>>2]=1;c[a+4>>2]=3;a=3184;c[a>>2]=1;c[a+4>>2]=3;a=3192;c[a>>2]=1;c[a+4>>2]=3;a=3200;c[a>>2]=1;c[a+4>>2]=3;a=3208;c[a>>2]=1;c[a+4>>2]=3;a=3216;c[a>>2]=1;c[a+4>>2]=3;a=3224;c[a>>2]=1;c[a+4>>2]=3;a=3232;c[a>>2]=1;c[a+4>>2]=3;a=3240;c[a>>2]=1;c[a+4>>2]=3;a=3248;c[a>>2]=1;c[a+4>>2]=3;a=3256;c[a>>2]=1;c[a+4>>2]=3;a=3264;c[a>>2]=1;c[a+4>>2]=3;a=3272;c[a>>2]=1;c[a+4>>2]=3;a=3280;c[a>>2]=1;c[a+4>>2]=3;a=3288;c[a>>2]=1;c[a+4>>2]=3;a=3296;c[a>>2]=1;c[a+4>>2]=3;a=3304;c[a>>2]=1;c[a+4>>2]=3;a=3312;c[a>>2]=1;c[a+4>>2]=3;a=3320;c[a>>2]=1;c[a+4>>2]=3;a=3328;c[a>>2]=1;c[a+4>>2]=3;a=3336;c[a>>2]=1;c[a+4>>2]=3;a=2896;c[a>>2]=2;c[a+4>>2]=5;a=2904;c[a>>2]=2;c[a+4>>2]=5;a=2912;c[a>>2]=2;c[a+4>>2]=5;a=2920;c[a>>2]=2;c[a+4>>2]=5;a=2928;c[a>>2]=2;c[a+4>>2]=5;a=2936;c[a>>2]=2;c[a+4>>2]=5;a=2944;c[a>>2]=2;c[a+4>>2]=5;a=2952;c[a>>2]=2;c[a+4>>2]=5;a=2848;c[a>>2]=3;c[a+4>>2]=7;a=2856;c[a>>2]=3;c[a+4>>2]=7;a=0;do{h=2832+(a+64<<3)|0;c[h>>2]=-1;c[h+4>>2]=2;a=a+1|0}while((a|0)!=64);a=2960;c[a>>2]=-2;c[a+4>>2]=4;a=2968;c[a>>2]=-2;c[a+4>>2]=4;a=2976;c[a>>2]=-2;c[a+4>>2]=4;a=2984;c[a>>2]=-2;c[a+4>>2]=4;a=2992;c[a>>2]=-2;c[a+4>>2]=4;a=3e3;c[a>>2]=-2;c[a+4>>2]=4;a=3008;c[a>>2]=-2;c[a+4>>2]=4;a=3016;c[a>>2]=-2;c[a+4>>2]=4;a=3024;c[a>>2]=-2;c[a+4>>2]=4;a=3032;c[a>>2]=-2;c[a+4>>2]=4;a=3040;c[a>>2]=-2;c[a+4>>2]=4;a=3048;c[a>>2]=-2;c[a+4>>2]=4;a=3056;c[a>>2]=-2;c[a+4>>2]=4;a=3064;c[a>>2]=-2;c[a+4>>2]=4;a=3072;c[a>>2]=-2;c[a+4>>2]=4;a=3080;c[a>>2]=-2;c[a+4>>2]=4;a=2864;c[a>>2]=-3;c[a+4>>2]=6;a=2872;c[a>>2]=-3;c[a+4>>2]=6;a=2880;c[a>>2]=-3;c[a+4>>2]=6;a=2888;c[a>>2]=-3;c[a+4>>2]=6;a=2840;c[a>>2]=-4;c[a+4>>2]=8;a=4880;do{c[a>>2]=0;c[a+4>>2]=0;a=a+8|0}while((a|0)!=6928);iw(4880,0,2048)|0;d=2;a=0;f=0;g=0;while(1){d=d<<16>>16;b=8-d|0;e=1<<b;if((b|0)!=31){a=(a&1|2)<<b;b=0;do{h=4880+(b+a<<3)|0;c[h>>2]=f;c[h+4>>2]=d;b=b+1|0}while((b|0)<(e|0))}b=(g<<16)+65536|0;a=b>>31^b>>15;g=g+1|0;if((g|0)==7){b=2;f=1;g=-1;h=-1;break}else{d=(a>>1)+2|0;f=b>>16}}while(1){d=b<<16>>16;a=8-d|0;e=1<<a;if((a|0)!=31){a=(f&1|2)<<a;b=0;do{f=4880+(b+a<<3)|0;c[f>>2]=g;c[f+4>>2]=d;b=b+1|0}while((b|0)<(e|0))}a=(h<<16)+-65536|0;f=a>>31^a>>15;b=(f>>1)+2|0;if((b|0)>8){a=6928;break}else{g=a>>16;h=h+-1|0}}do{c[a>>2]=0;c[a+4>>2]=0;a=a+8|0}while((a|0)!=8976);iw(6928,0,2048)|0;f=3;a=0;e=0;g=0;while(1){b=8-f|0;d=1<<b;if((b|0)!=31){a=(a&3|4)<<b;b=0;do{h=6928+(b+a<<3)|0;c[h>>2]=e;c[h+4>>2]=f;b=b+1|0}while((b|0)<(d|0))}b=(g<<16)+65536|0;a=b>>31^b>>15;g=g+1|0;if((g|0)==12){f=3;b=1;e=-1;g=-1;break}else{f=(a>>2)+3|0;e=b>>16}}while(1){a=8-f|0;d=1<<a;if((a|0)!=31){a=(b&3|4)<<a;b=0;do{h=6928+(b+a<<3)|0;c[h>>2]=e;c[h+4>>2]=f;b=b+1|0}while((b|0)<(d|0))}a=(g<<16)+-65536|0;b=a>>31^a>>15;f=(b>>2)+3|0;if((f|0)>8){a=8976;break}else{e=a>>16;g=g+-1|0}}do{c[a>>2]=0;c[a+4>>2]=0;a=a+8|0}while((a|0)!=11024);iw(8976,0,2048)|0;f=4;a=0;e=0;g=0;while(1){b=8-f|0;d=1<<b;if((b|0)!=31){a=(a&7|8)<<b;b=0;do{h=8976+(b+a<<3)|0;c[h>>2]=e;c[h+4>>2]=f;b=b+1|0}while((b|0)<(d|0))}b=(g<<16)+65536|0;a=b>>31^b>>15;g=g+1|0;if((g|0)==20){f=4;b=1;e=-1;g=-1;break}else{f=(a>>3)+4|0;e=b>>16}}while(1){a=8-f|0;d=1<<a;if((a|0)!=31){a=(b&7|8)<<a;b=0;do{h=8976+(b+a<<3)|0;c[h>>2]=e;c[h+4>>2]=f;b=b+1|0}while((b|0)<(d|0))}a=(g<<16)+-65536|0;b=a>>31^a>>15;f=(b>>3)+4|0;if((f|0)>8){a=11024;break}else{e=a>>16;g=g+-1|0}}do{c[a>>2]=0;c[a+4>>2]=0;a=a+8|0}while((a|0)!=13072);iw(11024,0,2048)|0;f=5;a=0;e=0;g=0;while(1){b=8-f|0;d=1<<b;if((b|0)!=31){a=(a&15|16)<<b;b=0;do{h=11024+(b+a<<3)|0;c[h>>2]=e;c[h+4>>2]=f;b=b+1|0}while((b|0)<(d|0))}b=(g<<16)+65536|0;a=b>>31^b>>15;g=g+1|0;if((g|0)==32){f=5;b=1;e=-1;g=-1;break}else{f=(a>>4)+5|0;e=b>>16}}while(1){a=8-f|0;d=1<<a;if((a|0)!=31){a=(b&15|16)<<a;b=0;do{h=11024+(b+a<<3)|0;c[h>>2]=e;c[h+4>>2]=f;b=b+1|0}while((b|0)<(d|0))}a=(g<<16)+-65536|0;b=a>>31^a>>15;f=(b>>4)+5|0;if((f|0)>8){a=13072;break}else{e=a>>16;g=g+-1|0}}do{c[a>>2]=0;c[a+4>>2]=0;a=a+8|0}while((a|0)!=15120);iw(13072,0,2048)|0;f=6;a=0;e=0;g=0;while(1){b=8-f|0;d=1<<b;if((b|0)!=31){a=(a&31|32)<<b;b=0;do{h=13072+(b+a<<3)|0;c[h>>2]=e;c[h+4>>2]=f;b=b+1|0}while((b|0)<(d|0))}b=(g<<16)+65536|0;a=b>>31^b>>15;g=g+1|0;if((g|0)==48){f=6;b=1;e=-1;g=-1;break}else{f=(a>>5)+6|0;e=b>>16}}while(1){a=8-f|0;d=1<<a;if((a|0)!=31){a=(b&31|32)<<a;b=0;do{h=13072+(b+a<<3)|0;c[h>>2]=e;c[h+4>>2]=f;b=b+1|0}while((b|0)<(d|0))}a=(g<<16)+-65536|0;b=a>>31^a>>15;f=(b>>5)+6|0;if((f|0)>8){a=15120;break}else{e=a>>16;g=g+-1|0}}do{c[a>>2]=0;c[a+4>>2]=0;a=a+8|0}while((a|0)!=17168);iw(15120,0,2048)|0;f=7;a=0;e=0;g=0;while(1){b=8-f|0;d=1<<b;if((b|0)!=31){a=(a&63|64)<<b;b=0;do{h=15120+(b+a<<3)|0;c[h>>2]=e;c[h+4>>2]=f;b=b+1|0}while((b|0)<(d|0))}b=(g<<16)+65536|0;a=b>>31^b>>15;g=g+1|0;if((g|0)==64){f=7;b=1;e=-1;g=-1;break}else{f=(a>>6)+7|0;e=b>>16}}while(1){a=8-f|0;d=1<<a;if((a|0)!=31){a=(b&63|64)<<a;b=0;do{h=15120+(b+a<<3)|0;c[h>>2]=e;c[h+4>>2]=f;b=b+1|0}while((b|0)<(d|0))}a=(g<<16)+-65536|0;b=a>>31^a>>15;f=(b>>6)+7|0;if((f|0)>8){a=17168;break}else{e=a>>16;g=g+-1|0}}do{c[a>>2]=0;c[a+4>>2]=0;a=a+8|0}while((a|0)!=19216);iw(17168,0,2048)|0;f=8;a=0;e=0;g=0;while(1){b=8-f|0;d=1<<b;if((b|0)!=31){a=(a&127|128)<<b;b=0;do{h=17168+(b+a<<3)|0;c[h>>2]=e;c[h+4>>2]=f;b=b+1|0}while((b|0)<(d|0))}b=(g<<16)+65536|0;a=b>>31^b>>15;g=g+1|0;if((g|0)==64){g=8;e=1;f=-1;h=-1;break}else{f=(a>>7)+8|0;e=b>>16}}while(1){a=8-g|0;d=1<<a;if((a|0)!=31){a=(e&127|128)<<a;b=0;do{e=17168+(b+a<<3)|0;c[e>>2]=f;c[e+4>>2]=g;b=b+1|0}while((b|0)<(d|0))}b=(h<<16)+-65536|0;e=b>>31^b>>15;a=e>>7;if((a|0)>0){a=19216;break}else{g=a+8|0;f=b>>16;h=h+-1|0}}do{c[a>>2]=0;c[a+4>>2]=0;a=a+8|0}while((a|0)!=21264);iw(19216,0,2048)|0;a=21264;do{c[a>>2]=0;c[a+4>>2]=0;a=a+8|0}while((a|0)!=23312);iw(21264,0,2048)|0;a=23312;do{c[a>>2]=0;c[a+4>>2]=0;a=a+8|0}while((a|0)!=25360);iw(23312,0,2048)|0;a=25360;do{c[a>>2]=0;c[a+4>>2]=0;a=a+8|0}while((a|0)!=27408);iw(25360,0,2048)|0;a=27408;do{c[a>>2]=0;c[a+4>>2]=0;a=a+8|0}while((a|0)!=29456);iw(27408,0,2048)|0;a=29456;do{c[a>>2]=0;c[a+4>>2]=0;a=a+8|0}while((a|0)!=31504);iw(29456,0,2048)|0;a=31504;do{c[a>>2]=0;c[a+4>>2]=0;a=a+8|0}while((a|0)!=33552);iw(31504,0,2048)|0;a=33552;do{c[a>>2]=0;c[a+4>>2]=0;a=a+8|0}while((a|0)!=35600);iw(33552,0,2048)|0;mc(35600,8);kb(179,35600,n|0)|0;mc(35612,10);kb(179,35612,n|0)|0;mc(35624,12);kb(179,35624,n|0)|0;mc(35636,16);kb(179,35636,n|0)|0;return}function sc(a){a=a|0;var b=0;b=c[a>>2]|0;if(!b)return;a=a+4|0;if((c[a>>2]|0)!=(b|0))c[a>>2]=b;cj(b);return}function tc(a){a=a|0;var b=0,d=0;c[a>>2]=36080;b=c[a+4616>>2]|0;if(b){d=a+4620|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}c[a>>2]=36612;b=c[a+120>>2]|0;if(b){d=a+124|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}d=a+92|0;b=c[d>>2]|0;c[d>>2]=0;if(b)Bb[c[(c[b>>2]|0)+4>>2]&255](b);a=a+4|0;b=c[a>>2]|0;c[a>>2]=0;if(!b)return;Bb[c[(c[b>>2]|0)+4>>2]&255](b);return}function uc(a){a=a|0;var b=0,d=0;c[a>>2]=36080;b=c[a+4616>>2]|0;if(b){d=a+4620|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}c[a>>2]=36612;b=c[a+120>>2]|0;if(b){d=a+124|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}d=a+92|0;b=c[d>>2]|0;c[d>>2]=0;if(b)Bb[c[(c[b>>2]|0)+4>>2]&255](b);d=a+4|0;b=c[d>>2]|0;c[d>>2]=0;if(!b){cj(a);return}Bb[c[(c[b>>2]|0)+4>>2]&255](b);cj(a);return}function vc(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;k=i;i=i+32|0;m=k;Ei(m,c[d+136>>2]|0,c[d+144>>2]|0);l=c[e+4>>2]|0;j=c[e+8>>2]|0;j=(j|0)==0?c[m+8>>2]|0:j;h=c[e+12>>2]|0;h=(h|0)==0?c[m+12>>2]|0:h;f=c[e+16>>2]|0;g=c[m+16>>2]|0;c[d+184>>2]=(l|0)==0?c[m+4>>2]|0:l;c[d+188>>2]=j;c[d+192>>2]=h;he(d);h=d+140|0;e=(c[h>>2]|0)+32|0;e=(e|0)<128?2:(e|0)/64|0;j=0;do{c[d+196+(j*12|0)>>2]=e;c[d+196+(j*12|0)+4>>2]=0;b[d+196+(j*12|0)+8>>1]=0;b[d+196+(j*12|0)+10>>1]=1;j=j+1|0}while((j|0)!=365);l=(c[h>>2]|0)+32|0;l=(l|0)<128?2:(l|0)/64|0;m=((f|0)==0?g:f)&255;c[d+4576>>2]=l;c[d+4580>>2]=0;a[d+4584>>0]=m;a[d+4585>>0]=1;a[d+4586>>0]=0;c[d+4588>>2]=l;c[d+4592>>2]=1;a[d+4596>>0]=m;a[d+4597>>0]=1;a[d+4598>>0]=0;c[d+4600>>2]=0;i=k;return}function wc(d,e,f,g){d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0;o=i;i=i+16|0;m=o;l=d+92|0;k=c[e>>2]|0;c[e>>2]=0;e=c[l>>2]|0;c[l>>2]=k;if(e)Bb[c[(c[e>>2]|0)+4>>2]&255](e);c[m>>2]=0;c[m+4>>2]=g;l=f+8|0;c[m+8>>2]=c[l>>2];if(g){e=bj(4624)|0;g=d+8|0;h=e+4|0;j=g;k=h+84|0;do{c[h>>2]=c[j>>2];h=h+4|0;j=j+4|0}while((h|0)<(k|0));h=e+88|0;k=h+40|0;do{c[h>>2]=0;h=h+4|0}while((h|0)<(k|0));c[e>>2]=35856;c[e+128>>2]=c[d+136>>2];c[e+132>>2]=c[d+140>>2];c[e+136>>2]=c[d+144>>2];c[e+140>>2]=c[d+148>>2];c[e+144>>2]=c[d+152>>2];c[e+148>>2]=c[d+156>>2];c[e+152>>2]=c[d+160>>2];h=e+156|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[e+172>>2]=c[g>>2];c[e+176>>2]=0;c[e+180>>2]=0;c[e+184>>2]=0;h=e+4568|0;g=e+188|0;do{c[g>>2]=0;c[g+4>>2]=0;b[g+8>>1]=0;b[g+10>>1]=1;g=g+12|0}while((g|0)!=(h|0));j=d+4|0;c[h>>2]=0;c[h+4>>2]=0;b[h+8>>1]=0;a[h+10>>0]=0;k=e+4580|0;c[k>>2]=0;c[k+4>>2]=0;b[k+8>>1]=0;a[k+10>>0]=0;k=e+4592|0;c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;c[k+20>>2]=0;c[k+24>>2]=0;a[k+28>>0]=0;if(!(c[e+28>>2]|0))c[e+20>>2]=1;g=c[j>>2]|0;c[j>>2]=e;if(g){Bb[c[(c[g>>2]|0)+4>>2]&255](g);e=c[j>>2]|0}Wd(e,m)}m=d+100|0;c[m>>2]=32;c[d+96>>2]=0;e=c[f>>2]|0;if(!e){c[d+108>>2]=c[f+4>>2];c[d+104>>2]=c[l>>2];Yd(d);n=d+116|0;n=c[n>>2]|0;d=c[m>>2]|0;d=d+-32|0;d=(d|0)/8|0;d=n-d|0;i=o;return d|0}c[d+132>>2]=e;h=d+120|0;l=d+124|0;g=c[l>>2]|0;e=c[h>>2]|0;j=e;k=g-j|0;if(k>>>0>=4e3){if(k>>>0>4e3?(n=e+4e3|0,(g|0)!=(n|0)):0){c[l>>2]=n;g=n}}else{Xd(h,4e3-k|0);e=c[h>>2]|0;j=e;g=c[l>>2]|0}c[d+108>>2]=j;c[d+104>>2]=g-e;Yd(d);n=d+116|0;n=c[n>>2]|0;d=c[m>>2]|0;d=d+-32|0;d=(d|0)/8|0;d=n-d|0;i=o;return d|0}function xc(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;w=i;i=i+352|0;x=w+328|0;y=w+192|0;e=w+343|0;f=w+342|0;g=w+341|0;h=w+340|0;r=w+176|0;k=w+168|0;l=w+160|0;m=w+152|0;v=w;t=w+136|0;if((c[b+32>>2]|0)!=0?(c[b+24>>2]|0)!=1:0){s=b+8|0;u=b+36|0;j=c[u>>2]|0;if(!j){b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[e>>0]|0;Aa(37,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}b=c[b+16>>2]|0;if((b|0)==16)switch(j|0){case 1:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[f>>0]|0;Aa(38,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 2:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[g>>0]|0;Aa(39,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 3:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[h>>0]|0;Aa(40,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}default:{j=y+56|0;g=y+4|0;c[y>>2]=36160;c[j>>2]=36180;o=0;ia(62,y+56|0,g|0);w=o;o=0;if(w&1){z=Na()|0;fn(j);Ya(z|0)}c[y+128>>2]=0;c[y+132>>2]=-1;c[y>>2]=36200;c[y+56>>2]=36220;o=0;ha(180,g|0);w=o;o=0;do if(w&1)b=Na()|0;else{c[g>>2]=36236;h=y+36|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[y+52>>2]=16;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;o=0;ia(63,g|0,x|0);w=o;o=0;if(w&1){b=Na()|0;Im(x);Im(h);nn(g);break}Im(x);o=0;b=ma(28,y|0,49007,21)|0;x=o;o=0;do if((!(x&1)?(o=0,p=ra(36,b|0,c[u>>2]|0)|0,x=o,o=0,!(x&1)):0)?(o=0,ma(28,p|0,50997,18)|0,x=o,o=0,!(x&1)):0){f=Ma(16)|0;o=0;ia(64,r|0,g|0);x=o;o=0;if(!(x&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,f|0,9,35648,r|0);x=o;o=0;if(x&1)e=1;else{o=0;wa(6,f|0,824,96);o=0;e=0}b=Na()|0;Im(r);if(!e)break}else b=Na()|0;La(f|0)}else z=34;while(0);if((z|0)==34)b=Na()|0;c[y>>2]=36200;c[j>>2]=36220;c[g>>2]=36236;Im(h);nn(g);fn(j);z=b;Ya(z|0)}while(0);z=b;fn(j);Ya(z|0)}}if((b|0)<=8){b=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,b|0,8,35648);z=o;o=0;if(!(z&1))lb(b|0,824,96);z=Na()|0;La(b|0);Ya(z|0)}e=16-b|0;switch(j|0){case 1:{b=bj(60)|0;c[k>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[k>>2];c[x+4>>2]=c[k+4>>2];Aa(41,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 2:{b=bj(60)|0;c[l>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[l>>2];c[x+4>>2]=c[l+4>>2];Aa(42,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 3:{b=bj(60)|0;c[m>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[m>>2];c[x+4>>2]=c[m+4>>2];Aa(43,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}default:{j=v+56|0;g=v+4|0;c[v>>2]=36160;c[j>>2]=36180;o=0;ia(62,v+56|0,g|0);y=o;o=0;if(y&1){z=Na()|0;fn(j);Ya(z|0)}c[v+128>>2]=0;c[v+132>>2]=-1;c[v>>2]=36200;c[v+56>>2]=36220;o=0;ha(180,g|0);y=o;o=0;do if(y&1)b=Na()|0;else{c[g>>2]=36236;h=v+36|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[v+52>>2]=16;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;o=0;ia(63,g|0,x|0);y=o;o=0;if(y&1){b=Na()|0;Im(x);Im(h);nn(g);break}Im(x);o=0;b=ma(28,v|0,49007,21)|0;y=o;o=0;do if((!(y&1)?(o=0,q=ra(36,b|0,c[u>>2]|0)|0,y=o,o=0,!(y&1)):0)?(o=0,ma(28,q|0,50997,18)|0,y=o,o=0,!(y&1)):0){f=Ma(16)|0;o=0;ia(64,t|0,g|0);y=o;o=0;if(!(y&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,f|0,9,35648,t|0);y=o;o=0;if(y&1)e=1;else{o=0;wa(6,f|0,824,96);o=0;e=0}b=Na()|0;Im(t);if(!e)break}else b=Na()|0;La(f|0)}else z=64;while(0);if((z|0)==64)b=Na()|0;c[v>>2]=36200;c[j>>2]=36220;c[g>>2]=36236;Im(h);nn(g);fn(j);z=b;Ya(z|0)}while(0);z=b;fn(j);Ya(z|0)}}}e=c[d+4>>2]|0;f=bj(16)|0;b=c[b+20>>2]|0;if(!e){z=c[d>>2]|0;c[f>>2]=36132;c[f+4>>2]=z;c[f+8>>2]=2;c[f+12>>2]=b;z=f;i=w;return z|0}else{c[f>>2]=36108;c[f+4>>2]=e;c[f+8>>2]=2;c[f+12>>2]=b;z=f;i=w;return z|0}return 0}function yc(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,p=0;c[b>>2]=36460;c[b+4>>2]=e;n=b+8|0;h=c[e>>2]|0;l=e+16|0;f=c[l>>2]|0;i=$(f,h)|0;c[n>>2]=0;p=b+12|0;c[p>>2]=0;c[b+16>>2]=0;do if(i){if(!((i|0)<0?(o=0,ha(178,n|0),h=o,o=0,h&1):0))m=4;if((m|0)==4?(j=i<<1,o=0,k=ka(67,j|0)|0,h=o,o=0,!(h&1)):0){c[n>>2]=k;h=k+(i<<1)|0;c[b+16>>2]=h;iw(k|0,0,j|0)|0;c[p>>2]=h;h=c[e>>2]|0;f=c[l>>2]|0;break}i=Na()|0;g=c[n>>2]|0;f=g;if(g){h=c[p>>2]|0;if((h|0)!=(g|0))c[p>>2]=h+(~((h+-2-f|0)>>>1)<<1);cj(g)}p=i;Ya(p|0)}while(0);i=b+20|0;f=$(h<<1,f)|0;c[i>>2]=0;j=b+24|0;c[j>>2]=0;c[b+28>>2]=0;if(!f){p=b+36|0;c[p>>2]=c[d>>2];c[p+4>>2]=c[d+4>>2];c[p+8>>2]=c[d+8>>2];return}if(!((f|0)<0?(o=0,ha(178,i|0),e=o,o=0,e&1):0))m=13;if((m|0)==13?(o=0,g=ka(67,f|0)|0,m=o,o=0,!(m&1)):0){c[j>>2]=g;c[i>>2]=g;c[b+28>>2]=g+f;do{a[g>>0]=0;g=(c[j>>2]|0)+1|0;c[j>>2]=g;f=f+-1|0}while((f|0)!=0);p=b+36|0;c[p>>2]=c[d>>2];c[p+4>>2]=c[d+4>>2];c[p+8>>2]=c[d+8>>2];return}h=Na()|0;g=c[i>>2]|0;if(g){if((c[j>>2]|0)!=(g|0))c[j>>2]=g;cj(g)}g=c[n>>2]|0;if(!g){p=h;Ya(p|0)}f=c[p>>2]|0;if((f|0)!=(g|0))c[p>>2]=f+(~((f+-2-g|0)>>>1)<<1);cj(g);p=h;Ya(p|0)}function zc(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,p=0;c[b>>2]=36436;c[b+4>>2]=e;n=b+8|0;h=c[e>>2]|0;l=e+16|0;f=c[l>>2]|0;i=$(f,h)|0;c[n>>2]=0;p=b+12|0;c[p>>2]=0;c[b+16>>2]=0;do if(i){if(!((i|0)<0?(o=0,ha(178,n|0),h=o,o=0,h&1):0))m=4;if((m|0)==4?(j=i<<1,o=0,k=ka(67,j|0)|0,h=o,o=0,!(h&1)):0){c[n>>2]=k;h=k+(i<<1)|0;c[b+16>>2]=h;iw(k|0,0,j|0)|0;c[p>>2]=h;h=c[e>>2]|0;f=c[l>>2]|0;break}i=Na()|0;g=c[n>>2]|0;f=g;if(g){h=c[p>>2]|0;if((h|0)!=(g|0))c[p>>2]=h+(~((h+-2-f|0)>>>1)<<1);cj(g)}p=i;Ya(p|0)}while(0);i=b+20|0;f=$(h<<1,f)|0;c[i>>2]=0;j=b+24|0;c[j>>2]=0;c[b+28>>2]=0;if(!f){p=b+36|0;c[p>>2]=c[d>>2];c[p+4>>2]=c[d+4>>2];c[p+8>>2]=c[d+8>>2];return}if(!((f|0)<0?(o=0,ha(178,i|0),e=o,o=0,e&1):0))m=13;if((m|0)==13?(o=0,g=ka(67,f|0)|0,m=o,o=0,!(m&1)):0){c[j>>2]=g;c[i>>2]=g;c[b+28>>2]=g+f;do{a[g>>0]=0;g=(c[j>>2]|0)+1|0;c[j>>2]=g;f=f+-1|0}while((f|0)!=0);p=b+36|0;c[p>>2]=c[d>>2];c[p+4>>2]=c[d+4>>2];c[p+8>>2]=c[d+8>>2];return}h=Na()|0;g=c[i>>2]|0;if(g){if((c[j>>2]|0)!=(g|0))c[j>>2]=g;cj(g)}g=c[n>>2]|0;if(!g){p=h;Ya(p|0)}f=c[p>>2]|0;if((f|0)!=(g|0))c[p>>2]=f+(~((f+-2-g|0)>>>1)<<1);cj(g);p=h;Ya(p|0)}function Ac(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,p=0;c[b>>2]=36412;c[b+4>>2]=e;n=b+8|0;h=c[e>>2]|0;l=e+16|0;f=c[l>>2]|0;i=$(f,h)|0;c[n>>2]=0;p=b+12|0;c[p>>2]=0;c[b+16>>2]=0;do if(i){if(!((i|0)<0?(o=0,ha(178,n|0),h=o,o=0,h&1):0))m=4;if((m|0)==4?(j=i<<1,o=0,k=ka(67,j|0)|0,h=o,o=0,!(h&1)):0){c[n>>2]=k;h=k+(i<<1)|0;c[b+16>>2]=h;iw(k|0,0,j|0)|0;c[p>>2]=h;h=c[e>>2]|0;f=c[l>>2]|0;break}i=Na()|0;g=c[n>>2]|0;f=g;if(g){h=c[p>>2]|0;if((h|0)!=(g|0))c[p>>2]=h+(~((h+-2-f|0)>>>1)<<1);cj(g)}p=i;Ya(p|0)}while(0);i=b+20|0;f=$(h<<1,f)|0;c[i>>2]=0;j=b+24|0;c[j>>2]=0;c[b+28>>2]=0;if(!f){p=b+36|0;c[p>>2]=c[d>>2];c[p+4>>2]=c[d+4>>2];c[p+8>>2]=c[d+8>>2];return}if(!((f|0)<0?(o=0,ha(178,i|0),e=o,o=0,e&1):0))m=13;if((m|0)==13?(o=0,g=ka(67,f|0)|0,m=o,o=0,!(m&1)):0){c[j>>2]=g;c[i>>2]=g;c[b+28>>2]=g+f;do{a[g>>0]=0;g=(c[j>>2]|0)+1|0;c[j>>2]=g;f=f+-1|0}while((f|0)!=0);p=b+36|0;c[p>>2]=c[d>>2];c[p+4>>2]=c[d+4>>2];c[p+8>>2]=c[d+8>>2];return}h=Na()|0;g=c[i>>2]|0;if(g){if((c[j>>2]|0)!=(g|0))c[j>>2]=g;cj(g)}g=c[n>>2]|0;if(!g){p=h;Ya(p|0)}f=c[p>>2]|0;if((f|0)!=(g|0))c[p>>2]=f+(~((f+-2-g|0)>>>1)<<1);cj(g);p=h;Ya(p|0)}function Bc(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,p=0;c[b>>2]=36388;c[b+4>>2]=e;n=b+8|0;h=c[e>>2]|0;l=e+16|0;f=c[l>>2]|0;i=$(f,h)|0;c[n>>2]=0;p=b+12|0;c[p>>2]=0;c[b+16>>2]=0;do if(i){if(!((i|0)<0?(o=0,ha(178,n|0),h=o,o=0,h&1):0))m=4;if((m|0)==4?(j=i<<1,o=0,k=ka(67,j|0)|0,h=o,o=0,!(h&1)):0){c[n>>2]=k;h=k+(i<<1)|0;c[b+16>>2]=h;iw(k|0,0,j|0)|0;c[p>>2]=h;h=c[e>>2]|0;f=c[l>>2]|0;break}i=Na()|0;g=c[n>>2]|0;f=g;if(g){h=c[p>>2]|0;if((h|0)!=(g|0))c[p>>2]=h+(~((h+-2-f|0)>>>1)<<1);cj(g)}p=i;Ya(p|0)}while(0);i=b+20|0;f=$(h<<1,f)|0;c[i>>2]=0;j=b+24|0;c[j>>2]=0;c[b+28>>2]=0;if(!f){p=b+36|0;c[p>>2]=c[d>>2];c[p+4>>2]=c[d+4>>2];c[p+8>>2]=c[d+8>>2];return}if(!((f|0)<0?(o=0,ha(178,i|0),e=o,o=0,e&1):0))m=13;if((m|0)==13?(o=0,g=ka(67,f|0)|0,m=o,o=0,!(m&1)):0){c[j>>2]=g;c[i>>2]=g;c[b+28>>2]=g+f;do{a[g>>0]=0;g=(c[j>>2]|0)+1|0;c[j>>2]=g;f=f+-1|0}while((f|0)!=0);p=b+36|0;c[p>>2]=c[d>>2];c[p+4>>2]=c[d+4>>2];c[p+8>>2]=c[d+8>>2];return}h=Na()|0;g=c[i>>2]|0;if(g){if((c[j>>2]|0)!=(g|0))c[j>>2]=g;cj(g)}g=c[n>>2]|0;if(!g){p=h;Ya(p|0)}f=c[p>>2]|0;if((f|0)!=(g|0))c[p>>2]=f+(~((f+-2-g|0)>>>1)<<1);cj(g);p=h;Ya(p|0)}function Cc(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;i=b+32|0;Jm(i,d)|0;h=b+44|0;c[h>>2]=0;j=b+48|0;g=c[j>>2]|0;if(g&8){d=a[i>>0]|0;if(!(d&1)){d=((d&255)>>>1)+(i+1)|0;c[h>>2]=d;e=i+1|0;f=i+1|0}else{d=(c[b+40>>2]|0)+(c[b+36>>2]|0)|0;c[h>>2]=d;f=c[b+40>>2]|0;e=f}c[b+8>>2]=e;c[b+12>>2]=f;c[b+16>>2]=d}if(!(g&16))return;d=a[i>>0]|0;if(!(d&1)){g=(d&255)>>>1;c[h>>2]=i+1+g;d=10;h=g}else{g=c[b+36>>2]|0;c[h>>2]=(c[b+40>>2]|0)+g;d=(c[i>>2]&-2)+-1|0;h=g}Mm(i,d,0);d=a[i>>0]|0;if(!(d&1)){g=i+1|0;f=(d&255)>>>1;e=i+1|0}else{e=c[b+40>>2]|0;g=e;f=c[b+36>>2]|0}d=b+24|0;c[d>>2]=e;c[b+20>>2]=e;c[b+28>>2]=g+f;if(!(c[j>>2]&3))return;c[d>>2]=e+h;return}function Dc(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0;q=i;i=i+32|0;j=q+16|0;p=q+8|0;k=q;o=0;ia(65,p|0,b|0);m=o;o=0;a:do if(m&1){e=Na(0)|0;f=b;g=b}else{do if(a[p>>0]|0){f=c[(c[b>>2]|0)+-12>>2]|0;c[k>>2]=c[b+(f+24)>>2];l=b+f|0;m=c[b+(f+4)>>2]|0;g=d+e|0;f=b+(f+76)|0;e=c[f>>2]|0;do if((e|0)==-1){o=0;e=ka(68,l|0)|0;r=o;o=0;if(r&1)n=13;else{c[j>>2]=e;o=0;e=ra(37,j|0,44220)|0;r=o;o=0;if(!(r&1)?(o=0,h=ra(c[(c[e>>2]|0)+28>>2]|0,e|0,32)|0,r=o,o=0,!(r&1)):0){Gs(j);e=h<<24>>24;c[f>>2]=e;n=9;break}e=Na(0)|0;Gs(j)}}else n=9;while(0);if((n|0)==9){o=0;c[j>>2]=c[k>>2];e=ja(39,j|0,d|0,((m&176|0)==32?g:d)|0,g|0,l|0,e&255|0)|0;r=o;o=0;if(!(r&1)){if(e)break;r=c[(c[b>>2]|0)+-12>>2]|0;o=0;ia(66,b+r|0,c[b+(r+16)>>2]|5|0);r=o;o=0;if(!(r&1))break;else n=13}else n=13}if((n|0)==13)e=Na(0)|0;ho(p);f=b;g=b;break a}while(0);ho(p);i=q;return b|0}while(0);Va(e|0)|0;o=0;ha(181,f+(c[(c[g>>2]|0)+-12>>2]|0)|0);r=o;o=0;if(!(r&1)){Xa();i=q;return b|0}e=Na()|0;o=0;xa(3);r=o;o=0;if(r&1){r=Na(0)|0;ec(r)}else Ya(e|0);return 0}function Ec(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=c[d+48>>2]|0;if(e&16){e=d+44|0;f=c[e>>2]|0;g=c[d+24>>2]|0;if(f>>>0<g>>>0)c[e>>2]=g;else g=f;f=c[d+20>>2]|0;h=g-f|0;if(h>>>0>4294967279)_i(b);if(h>>>0<11){a[b>>0]=h<<1;e=b+1|0}else{d=h+16&-16;e=bj(d)|0;c[b+8>>2]=e;c[b>>2]=d|1;c[b+4>>2]=h}if((f|0)!=(g|0)){d=e;while(1){a[d>>0]=a[f>>0]|0;f=f+1|0;if((f|0)==(g|0))break;else d=d+1|0}e=e+h|0}a[e>>0]=0;return}if(!(e&8)){c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;return}f=c[d+8>>2]|0;d=c[d+16>>2]|0;h=d-f|0;if(h>>>0>4294967279)_i(b);if(h>>>0<11){a[b>>0]=h<<1;e=b+1|0}else{g=h+16&-16;e=bj(g)|0;c[b+8>>2]=e;c[b>>2]=g|1;c[b+4>>2]=h}if((f|0)!=(d|0)){g=e;while(1){a[g>>0]=a[f>>0]|0;f=f+1|0;if((f|0)==(d|0))break;else g=g+1|0}e=e+h|0}a[e>>0]=0;return}function Fc(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0;c[b>>2]=36364;c[b+4>>2]=e;p=b+8|0;i=c[e>>2]|0;m=e+16|0;h=c[m>>2]|0;l=$(h,i)|0;c[p>>2]=0;q=b+12|0;c[q>>2]=0;c[b+16>>2]=0;do if(l){if(!((l|0)<0?(o=0,ha(178,p|0),i=o,o=0,i&1):0))n=4;if((n|0)==4?(j=l<<1,o=0,k=ka(67,j|0)|0,i=o,o=0,!(i&1)):0){c[p>>2]=k;i=k+(l<<1)|0;c[b+16>>2]=i;iw(k|0,0,j|0)|0;c[q>>2]=i;i=c[e>>2]|0;h=c[m>>2]|0;break}j=Na()|0;g=c[p>>2]|0;h=g;if(g){i=c[q>>2]|0;if((i|0)!=(g|0))c[q>>2]=i+(~((i+-2-h|0)>>>1)<<1);cj(g)}q=j;Ya(q|0)}while(0);j=b+20|0;h=$(i<<1,h)|0;c[j>>2]=0;k=b+24|0;c[k>>2]=0;c[b+28>>2]=0;if(!h){q=b+32|0;p=f;p=c[p>>2]|0;f=f+4|0;f=c[f>>2]|0;n=q;c[n>>2]=p;q=q+4|0;c[q>>2]=f;q=b+40|0;c[q>>2]=p;q=b+48|0;c[q>>2]=c[d>>2];c[q+4>>2]=c[d+4>>2];c[q+8>>2]=c[d+8>>2];return}if(!((h|0)<0?(o=0,ha(178,j|0),m=o,o=0,m&1):0))n=13;if((n|0)==13?(o=0,g=ka(67,h|0)|0,n=o,o=0,!(n&1)):0){c[k>>2]=g;c[j>>2]=g;c[b+28>>2]=g+h;do{a[g>>0]=0;g=(c[k>>2]|0)+1|0;c[k>>2]=g;h=h+-1|0}while((h|0)!=0);q=b+32|0;p=f;p=c[p>>2]|0;f=f+4|0;f=c[f>>2]|0;n=q;c[n>>2]=p;q=q+4|0;c[q>>2]=f;q=b+40|0;c[q>>2]=p;q=b+48|0;c[q>>2]=c[d>>2];c[q+4>>2]=c[d+4>>2];c[q+8>>2]=c[d+8>>2];return}i=Na()|0;g=c[j>>2]|0;if(g){if((c[k>>2]|0)!=(g|0))c[k>>2]=g;cj(g)}g=c[p>>2]|0;if(!g){q=i;Ya(q|0)}h=c[q>>2]|0;if((h|0)!=(g|0))c[q>>2]=h+(~((h+-2-g|0)>>>1)<<1);cj(g);q=i;Ya(q|0)}function Gc(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0;c[b>>2]=36340;c[b+4>>2]=e;p=b+8|0;i=c[e>>2]|0;m=e+16|0;h=c[m>>2]|0;l=$(h,i)|0;c[p>>2]=0;q=b+12|0;c[q>>2]=0;c[b+16>>2]=0;do if(l){if(!((l|0)<0?(o=0,ha(178,p|0),i=o,o=0,i&1):0))n=4;if((n|0)==4?(j=l<<1,o=0,k=ka(67,j|0)|0,i=o,o=0,!(i&1)):0){c[p>>2]=k;i=k+(l<<1)|0;c[b+16>>2]=i;iw(k|0,0,j|0)|0;c[q>>2]=i;i=c[e>>2]|0;h=c[m>>2]|0;break}j=Na()|0;g=c[p>>2]|0;h=g;if(g){i=c[q>>2]|0;if((i|0)!=(g|0))c[q>>2]=i+(~((i+-2-h|0)>>>1)<<1);cj(g)}q=j;Ya(q|0)}while(0);j=b+20|0;h=$(i<<1,h)|0;c[j>>2]=0;k=b+24|0;c[k>>2]=0;c[b+28>>2]=0;if(!h){q=b+32|0;p=f;p=c[p>>2]|0;f=f+4|0;f=c[f>>2]|0;n=q;c[n>>2]=p;q=q+4|0;c[q>>2]=f;q=b+40|0;c[q>>2]=p;q=b+48|0;c[q>>2]=c[d>>2];c[q+4>>2]=c[d+4>>2];c[q+8>>2]=c[d+8>>2];return}if(!((h|0)<0?(o=0,ha(178,j|0),m=o,o=0,m&1):0))n=13;if((n|0)==13?(o=0,g=ka(67,h|0)|0,n=o,o=0,!(n&1)):0){c[k>>2]=g;c[j>>2]=g;c[b+28>>2]=g+h;do{a[g>>0]=0;g=(c[k>>2]|0)+1|0;c[k>>2]=g;h=h+-1|0}while((h|0)!=0);q=b+32|0;p=f;p=c[p>>2]|0;f=f+4|0;f=c[f>>2]|0;n=q;c[n>>2]=p;q=q+4|0;c[q>>2]=f;q=b+40|0;c[q>>2]=p;q=b+48|0;c[q>>2]=c[d>>2];c[q+4>>2]=c[d+4>>2];c[q+8>>2]=c[d+8>>2];return}i=Na()|0;g=c[j>>2]|0;if(g){if((c[k>>2]|0)!=(g|0))c[k>>2]=g;cj(g)}g=c[p>>2]|0;if(!g){q=i;Ya(q|0)}h=c[q>>2]|0;if((h|0)!=(g|0))c[q>>2]=h+(~((h+-2-g|0)>>>1)<<1);cj(g);q=i;Ya(q|0)}function Hc(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0;c[b>>2]=36316;c[b+4>>2]=e;p=b+8|0;i=c[e>>2]|0;m=e+16|0;h=c[m>>2]|0;l=$(h,i)|0;c[p>>2]=0;q=b+12|0;c[q>>2]=0;c[b+16>>2]=0;do if(l){if(!((l|0)<0?(o=0,ha(178,p|0),i=o,o=0,i&1):0))n=4;if((n|0)==4?(j=l<<1,o=0,k=ka(67,j|0)|0,i=o,o=0,!(i&1)):0){c[p>>2]=k;i=k+(l<<1)|0;c[b+16>>2]=i;iw(k|0,0,j|0)|0;c[q>>2]=i;i=c[e>>2]|0;h=c[m>>2]|0;break}j=Na()|0;g=c[p>>2]|0;h=g;if(g){i=c[q>>2]|0;if((i|0)!=(g|0))c[q>>2]=i+(~((i+-2-h|0)>>>1)<<1);cj(g)}q=j;Ya(q|0)}while(0);j=b+20|0;h=$(i<<1,h)|0;c[j>>2]=0;k=b+24|0;c[k>>2]=0;c[b+28>>2]=0;if(!h){q=b+32|0;p=f;p=c[p>>2]|0;f=f+4|0;f=c[f>>2]|0;n=q;c[n>>2]=p;q=q+4|0;c[q>>2]=f;q=b+40|0;c[q>>2]=p;q=b+48|0;c[q>>2]=c[d>>2];c[q+4>>2]=c[d+4>>2];c[q+8>>2]=c[d+8>>2];return}if(!((h|0)<0?(o=0,ha(178,j|0),m=o,o=0,m&1):0))n=13;if((n|0)==13?(o=0,g=ka(67,h|0)|0,n=o,o=0,!(n&1)):0){c[k>>2]=g;c[j>>2]=g;c[b+28>>2]=g+h;do{a[g>>0]=0;g=(c[k>>2]|0)+1|0;c[k>>2]=g;h=h+-1|0}while((h|0)!=0);q=b+32|0;p=f;p=c[p>>2]|0;f=f+4|0;f=c[f>>2]|0;n=q;c[n>>2]=p;q=q+4|0;c[q>>2]=f;q=b+40|0;c[q>>2]=p;q=b+48|0;c[q>>2]=c[d>>2];c[q+4>>2]=c[d+4>>2];c[q+8>>2]=c[d+8>>2];return}i=Na()|0;g=c[j>>2]|0;if(g){if((c[k>>2]|0)!=(g|0))c[k>>2]=g;cj(g)}g=c[p>>2]|0;if(!g){q=i;Ya(q|0)}h=c[q>>2]|0;if((h|0)!=(g|0))c[q>>2]=h+(~((h+-2-g|0)>>>1)<<1);cj(g);q=i;Ya(q|0)}function Ic(a){a=a|0;var b=0,d=0,e=0;c[a>>2]=36316;b=c[a+20>>2]|0;if(b){d=a+24|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}e=c[a+8>>2]|0;if(!e)return;b=a+12|0;d=c[b>>2]|0;if((d|0)!=(e|0))c[b>>2]=d+(~((d+-2-e|0)>>>1)<<1);cj(e);return}function Jc(a){a=a|0;var b=0,d=0,e=0;c[a>>2]=36316;b=c[a+20>>2]|0;if(b){d=a+24|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}e=c[a+8>>2]|0;if(!e){cj(a);return}b=a+12|0;d=c[b>>2]|0;if((d|0)!=(e|0))c[b>>2]=d+(~((d+-2-e|0)>>>1)<<1);cj(e);cj(a);return}function Kc(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;g=b+48|0;if(!(c[g>>2]|0)){j=b+52|0;Pc(b,d,c[j>>2]|0,e,f);c[j>>2]=(c[j>>2]|0)+(c[(c[b+4>>2]|0)+12>>2]|0);return}k=b+4|0;h=e<<1;i=$(h,c[(c[k>>2]|0)+16>>2]|0)|0;j=b+20|0;Pc(b,d,c[j>>2]|0,e,f);d=c[k>>2]|0;if((c[d+28>>2]|0)==536870912)Oc(c[j>>2]|0,$(h,c[d+16>>2]|0)|0);k=c[g>>2]|0;if((Gb[c[(c[k>>2]|0)+48>>2]&63](k,c[j>>2]|0,i)|0)==(i|0))return;d=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,d|0,3,35648);k=o;o=0;if(k&1){k=Na()|0;La(d|0);Ya(k|0)}else lb(d|0,824,96)}function Lc(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=c[a+48>>2]|0;if(!f){f=a+52|0;Mc(a,c[f>>2]|0,b,d,e);c[f>>2]=(c[f>>2]|0)+(c[(c[a+4>>2]|0)+12>>2]|0);return}else{Nc(a,f,b,d,e);return}}function Mc(d,f,g,h,i){d=d|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0;m=d+4|0;j=c[m>>2]|0;do if(!(a[j+32>>0]|0))n=f;else{k=d+8|0;lw(c[k>>2]|0,f|0,h*6|0)|0;j=c[m>>2]|0;l=c[j+16>>2]|0;if((h|0)<=0){n=c[k>>2]|0;break}f=c[k>>2]|0;j=f;k=0;while(1){n=j+4|0;o=b[j>>1]|0;b[j>>1]=b[n>>1]|0;b[n>>1]=o;k=k+1|0;if((k|0)==(h|0))break;else j=j+(l<<1)|0}n=f;j=c[m>>2]|0}while(0);switch(c[j+16>>2]|0){case 3:if((c[j+24>>2]|0)==2){if((h|0)<=0)return;j=d+32|0;f=0;do{o=c[j>>2]|0;m=e[n+(f*6|0)+2>>1]<<o;i=32768-m|0;d=i+(e[n+(f*6|0)+4>>1]<<o)&65535;i=i+(e[n+(f*6|0)>>1]<<o)&65535;b[g+(f*6|0)>>1]=(m+49152+((d+i|0)>>>2)&65535)>>>o;b[g+(f*6|0)+2>>1]=d>>>o;b[g+(f*6|0)+4>>1]=i>>>o;f=f+1|0}while((f|0)!=(h|0));return}else{k=(i|0)<(h|0)?i:h;if((k|0)<=0)return;l=i<<1;j=c[d+32>>2]|0;f=0;do{h=e[n+(f*6|0)+2>>1]<<j;o=32768-h|0;d=o+(e[n+(f*6|0)+4>>1]<<j)&65535;o=o+(e[n+(f*6|0)>>1]<<j)&65535;b[g+(f<<1)>>1]=(h+49152+((d+o|0)>>>2)&65535)>>>j;b[g+(f+i<<1)>>1]=d>>>j;b[g+(f+l<<1)>>1]=o>>>j;f=f+1|0}while((f|0)!=(k|0));return}case 4:{if((c[j+24>>2]|0)!=1)return;k=(i|0)<(h|0)?i:h;if((k|0)<=0)return;l=i<<1;m=i*3|0;j=c[d+32>>2]|0;f=0;do{o=b[n+(f<<3)+6>>1]|0;p=e[n+(f<<3)+2>>1]<<j;d=32768-p|0;h=d+(e[n+(f<<3)+4>>1]<<j)&65535;d=d+(e[n+(f<<3)>>1]<<j)&65535;b[g+(f<<1)>>1]=(p+49152+((h+d|0)>>>2)&65535)>>>j;b[g+(f+i<<1)>>1]=h>>>j;b[g+(f+l<<1)>>1]=d>>>j;b[g+(f+m<<1)>>1]=o;f=f+1|0}while((f|0)!=(k|0));return}default:return}}function Nc(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0,t=0;q=i;i=i+176|0;r=q+152|0;t=q+16|0;s=q;l=b+4|0;h=c[l>>2]|0;p=f<<1;j=$(p,c[h+16>>2]|0)|0;do if(j){k=b+20|0;while(1){h=Gb[c[(c[d>>2]|0)+32>>2]&63](d,c[k>>2]|0,j)|0;if(!h)break;if((j|0)==(h|0)){m=26;break}else j=j-h|0}if((m|0)==26){h=c[l>>2]|0;break}m=t+56|0;l=t+4|0;c[t>>2]=36160;c[m>>2]=36180;o=0;ia(62,t+56|0,l|0);q=o;o=0;if(q&1){t=Na()|0;fn(m);Ya(t|0)}c[t+128>>2]=0;c[t+132>>2]=-1;c[t>>2]=36200;c[t+56>>2]=36220;o=0;ha(180,l|0);q=o;o=0;do if(q&1)h=Na()|0;else{c[l>>2]=36236;d=t+36|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[t+52>>2]=16;c[r>>2]=0;c[r+4>>2]=0;c[r+8>>2]=0;o=0;ia(63,l|0,r|0);q=o;o=0;if(q&1){h=Na()|0;Im(r);Im(d);nn(l);break}Im(r);o=0;h=ma(28,t|0,49029,57)|0;r=o;o=0;if(!(r&1)?(o=0,ra(36,h|0,0)|0,r=o,o=0,!(r&1)):0){k=Ma(16)|0;o=0;ia(64,s|0,l|0);r=o;o=0;if(!(r&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,k|0,3,35648,s|0);r=o;o=0;if(r&1)j=1;else{o=0;wa(6,k|0,824,96);o=0;j=0}h=Na()|0;Im(s);if(!j){s=h;c[t>>2]=36200;c[m>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(m);Ya(s|0)}}else h=Na()|0;La(k|0);s=h;c[t>>2]=36200;c[m>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(m);Ya(s|0)}s=Na()|0;c[t>>2]=36200;c[m>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(m);Ya(s|0)}while(0);t=h;fn(m);Ya(t|0)}while(0);j=b+20|0;if((c[h+28>>2]|0)!=536870912){t=c[j>>2]|0;Mc(b,t,e,f,g);i=q;return}Oc(c[j>>2]|0,$(p,c[h+16>>2]|0)|0);t=c[j>>2]|0;Mc(b,t,e,f,g);i=q;return}function Oc(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;g=i;i=i+176|0;e=g+152|0;l=g+16|0;j=g;if(!(d&1)){e=(d|0)/4|0;if((d|0)>3){f=0;do{l=b+(f<<2)|0;k=c[l>>2]|0;c[l>>2]=k>>>8&16711935|k<<8&-16711936;f=f+1|0}while((f|0)<(e|0))}if(!(d&3)){i=g;return}j=b+(d+-2)|0;l=b+(d+-1)|0;k=a[j>>0]|0;a[j>>0]=a[l>>0]|0;a[l>>0]=k;i=g;return}k=l+56|0;h=l+4|0;c[l>>2]=36160;c[k>>2]=36180;o=0;ia(62,l+56|0,h|0);g=o;o=0;if(g&1){l=Na()|0;fn(k);Ya(l|0)}c[l+128>>2]=0;c[l+132>>2]=-1;c[l>>2]=36200;c[l+56>>2]=36220;o=0;ha(180,h|0);g=o;o=0;do if(g&1)e=Na()|0;else{c[h>>2]=36236;g=l+36|0;c[g>>2]=0;c[g+4>>2]=0;c[g+8>>2]=0;c[g+12>>2]=0;c[l+52>>2]=16;c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;o=0;ia(63,h|0,e|0);b=o;o=0;if(b&1){l=Na()|0;Im(e);Im(g);nn(h);e=l;break}Im(e);o=0;e=ma(28,l|0,49087,24)|0;b=o;o=0;if((!(b&1)?(o=0,f=ra(36,e|0,d|0)|0,d=o,o=0,!(d&1)):0)?(o=0,ma(28,f|0,49112,20)|0,d=o,o=0,!(d&1)):0){b=Ma(16)|0;o=0;ia(64,j|0,h|0);d=o;o=0;if(!(d&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,b|0,1,35648,j|0);d=o;o=0;if(d&1)f=1;else{o=0;wa(6,b|0,824,96);o=0;f=0}e=Na()|0;Im(j);if(!f){j=e;c[l>>2]=36200;c[k>>2]=36220;c[h>>2]=36236;Im(g);nn(h);fn(k);Ya(j|0)}}else e=Na()|0;La(b|0);j=e;c[l>>2]=36200;c[k>>2]=36220;c[h>>2]=36236;Im(g);nn(h);fn(k);Ya(j|0)}j=Na()|0;c[l>>2]=36200;c[k>>2]=36220;c[h>>2]=36236;Im(g);nn(h);fn(k);Ya(j|0)}while(0);l=e;fn(k);Ya(l|0)}function Pc(d,f,g,h,i){d=d|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;n=d+4|0;j=c[n>>2]|0;a:do switch(c[j+16>>2]|0){case 3:{if((c[j+24>>2]|0)==2){if((h|0)<=0)break a;j=d+40|0;d=0;do{i=c[j>>2]|0;l=e[f+(d*6|0)+2>>1]<<i;k=e[f+(d*6|0)+4>>1]<<i;m=(e[f+(d*6|0)>>1]<<i)-(k+l>>2)+16384|0;b[g+(d*6|0)>>1]=(k+32768+m&65535)>>>i;b[g+(d*6|0)+2>>1]=(m&65535)>>>i;b[g+(d*6|0)+4>>1]=(l+32768+m&65535)>>>i;d=d+1|0}while((d|0)!=(h|0))}else{k=(h|0)<(i|0)?h:i;if((k|0)<=0)break a;l=i<<1;j=d+40|0;d=0;do{m=c[j>>2]|0;p=e[f+(d+i<<1)>>1]<<m;q=e[f+(d+l<<1)>>1]<<m;o=(e[f+(d<<1)>>1]<<m)-(q+p>>2)+16384|0;b[g+(d*6|0)>>1]=(q+32768+o&65535)>>>m;b[g+(d*6|0)+2>>1]=(o&65535)>>>m;b[g+(d*6|0)+4>>1]=(p+32768+o&65535)>>>m;d=d+1|0}while((d|0)!=(k|0))}break}case 4:{if((c[j+24>>2]|0)==1?(m=(h|0)<(i|0)?h:i,(m|0)>0):0){l=i<<1;j=d+40|0;d=i*3|0;k=0;do{q=c[j>>2]|0;p=e[f+(k+i<<1)>>1]<<q;s=e[f+(k+l<<1)>>1]<<q;o=(e[f+(k<<1)>>1]<<q)-(s+p>>2)+16384|0;r=b[f+(k+d<<1)>>1]|0;t=mw((o&65535)>>>q&65535|0,0,16)|0;p=(p+32768+o&65535)>>>q|D;r=mw(r&65535|0,0,48)|0;r=t|(s+32768+o&65535)>>>q&65535|r;p=p&65535|D;q=g+(k<<3)|0;o=q;b[o>>1]=r;b[o+2>>1]=r>>>16;q=q+4|0;b[q>>1]=p;b[q+2>>1]=p>>>16;k=k+1|0}while((k|0)!=(m|0))}break}default:{}}while(0);j=c[n>>2]|0;if(!(a[j+32>>0]|0))return;k=c[j+16>>2]|0;if((h|0)<=0)return;j=g;d=0;while(1){t=j+4|0;s=b[j>>1]|0;b[j>>1]=b[t>>1]|0;b[t>>1]=s;d=d+1|0;if((d|0)==(h|0))break;else j=j+(k<<1)|0}return}function Qc(a){a=a|0;var b=0,d=0,e=0;c[a>>2]=36340;b=c[a+20>>2]|0;if(b){d=a+24|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}e=c[a+8>>2]|0;if(!e)return;b=a+12|0;d=c[b>>2]|0;if((d|0)!=(e|0))c[b>>2]=d+(~((d+-2-e|0)>>>1)<<1);cj(e);return}function Rc(a){a=a|0;var b=0,d=0,e=0;c[a>>2]=36340;b=c[a+20>>2]|0;if(b){d=a+24|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}e=c[a+8>>2]|0;if(!e){cj(a);return}b=a+12|0;d=c[b>>2]|0;if((d|0)!=(e|0))c[b>>2]=d+(~((d+-2-e|0)>>>1)<<1);cj(e);cj(a);return}function Sc(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;g=b+48|0;if(!(c[g>>2]|0)){j=b+52|0;Wc(b,d,c[j>>2]|0,e,f);c[j>>2]=(c[j>>2]|0)+(c[(c[b+4>>2]|0)+12>>2]|0);return}k=b+4|0;h=e<<1;i=$(h,c[(c[k>>2]|0)+16>>2]|0)|0;j=b+20|0;Wc(b,d,c[j>>2]|0,e,f);d=c[k>>2]|0;if((c[d+28>>2]|0)==536870912)Oc(c[j>>2]|0,$(h,c[d+16>>2]|0)|0);k=c[g>>2]|0;if((Gb[c[(c[k>>2]|0)+48>>2]&63](k,c[j>>2]|0,i)|0)==(i|0))return;d=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,d|0,3,35648);k=o;o=0;if(k&1){k=Na()|0;La(d|0);Ya(k|0)}else lb(d|0,824,96)}function Tc(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=c[a+48>>2]|0;if(!f){f=a+52|0;Uc(a,c[f>>2]|0,b,d,e);c[f>>2]=(c[f>>2]|0)+(c[(c[a+4>>2]|0)+12>>2]|0);return}else{Vc(a,f,b,d,e);return}}function Uc(d,f,g,h,i){d=d|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0;m=d+4|0;j=c[m>>2]|0;do if(!(a[j+32>>0]|0))n=f;else{k=d+8|0;lw(c[k>>2]|0,f|0,h*6|0)|0;j=c[m>>2]|0;l=c[j+16>>2]|0;if((h|0)<=0){n=c[k>>2]|0;break}f=c[k>>2]|0;j=f;k=0;while(1){n=j+4|0;o=b[j>>1]|0;b[j>>1]=b[n>>1]|0;b[n>>1]=o;k=k+1|0;if((k|0)==(h|0))break;else j=j+(l<<1)|0}n=f;j=c[m>>2]|0}while(0);switch(c[j+16>>2]|0){case 3:if((c[j+24>>2]|0)==2){if((h|0)<=0)return;j=d+32|0;f=0;do{i=c[j>>2]|0;m=e[n+(f*6|0)>>1]<<i;d=e[n+(f*6|0)+2>>1]<<i;o=((e[n+(f*6|0)+4>>1]<<i)+32768-((d+m|0)>>>1)&65535)>>>i&65535;b[g+(f*6|0)>>1]=(m+32768-d&65535)>>>i;b[g+(f*6|0)+2>>1]=(d&65535)>>>i;b[g+(f*6|0)+4>>1]=o;f=f+1|0}while((f|0)!=(h|0));return}else{k=(i|0)<(h|0)?i:h;if((k|0)<=0)return;l=i<<1;j=c[d+32>>2]|0;f=0;do{h=e[n+(f*6|0)>>1]<<j;d=e[n+(f*6|0)+2>>1]<<j;o=((e[n+(f*6|0)+4>>1]<<j)+32768-((d+h|0)>>>1)&65535)>>>j&65535;b[g+(f<<1)>>1]=(h+32768-d&65535)>>>j;b[g+(f+i<<1)>>1]=(d&65535)>>>j;b[g+(f+l<<1)>>1]=o;f=f+1|0}while((f|0)!=(k|0));return}case 4:{if((c[j+24>>2]|0)!=1)return;k=(i|0)<(h|0)?i:h;if((k|0)<=0)return;l=i<<1;m=i*3|0;j=c[d+32>>2]|0;f=0;do{o=b[n+(f<<3)+6>>1]|0;p=e[n+(f<<3)>>1]<<j;h=e[n+(f<<3)+2>>1]<<j;d=((e[n+(f<<3)+4>>1]<<j)+32768-((h+p|0)>>>1)&65535)>>>j&65535;b[g+(f<<1)>>1]=(p+32768-h&65535)>>>j;b[g+(f+i<<1)>>1]=(h&65535)>>>j;b[g+(f+l<<1)>>1]=d;b[g+(f+m<<1)>>1]=o;f=f+1|0}while((f|0)!=(k|0));return}default:return}}function Vc(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0,t=0;q=i;i=i+176|0;r=q+152|0;t=q+16|0;s=q;l=b+4|0;h=c[l>>2]|0;p=f<<1;j=$(p,c[h+16>>2]|0)|0;do if(j){k=b+20|0;while(1){h=Gb[c[(c[d>>2]|0)+32>>2]&63](d,c[k>>2]|0,j)|0;if(!h)break;if((j|0)==(h|0)){m=26;break}else j=j-h|0}if((m|0)==26){h=c[l>>2]|0;break}m=t+56|0;l=t+4|0;c[t>>2]=36160;c[m>>2]=36180;o=0;ia(62,t+56|0,l|0);q=o;o=0;if(q&1){t=Na()|0;fn(m);Ya(t|0)}c[t+128>>2]=0;c[t+132>>2]=-1;c[t>>2]=36200;c[t+56>>2]=36220;o=0;ha(180,l|0);q=o;o=0;do if(q&1)h=Na()|0;else{c[l>>2]=36236;d=t+36|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[t+52>>2]=16;c[r>>2]=0;c[r+4>>2]=0;c[r+8>>2]=0;o=0;ia(63,l|0,r|0);q=o;o=0;if(q&1){h=Na()|0;Im(r);Im(d);nn(l);break}Im(r);o=0;h=ma(28,t|0,49029,57)|0;r=o;o=0;if(!(r&1)?(o=0,ra(36,h|0,0)|0,r=o,o=0,!(r&1)):0){k=Ma(16)|0;o=0;ia(64,s|0,l|0);r=o;o=0;if(!(r&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,k|0,3,35648,s|0);r=o;o=0;if(r&1)j=1;else{o=0;wa(6,k|0,824,96);o=0;j=0}h=Na()|0;Im(s);if(!j){s=h;c[t>>2]=36200;c[m>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(m);Ya(s|0)}}else h=Na()|0;La(k|0);s=h;c[t>>2]=36200;c[m>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(m);Ya(s|0)}s=Na()|0;c[t>>2]=36200;c[m>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(m);Ya(s|0)}while(0);t=h;fn(m);Ya(t|0)}while(0);j=b+20|0;if((c[h+28>>2]|0)!=536870912){t=c[j>>2]|0;Uc(b,t,e,f,g);i=q;return}Oc(c[j>>2]|0,$(p,c[h+16>>2]|0)|0);t=c[j>>2]|0;Uc(b,t,e,f,g);i=q;return}function Wc(d,f,g,h,i){d=d|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;n=d+4|0;j=c[n>>2]|0;a:do switch(c[j+16>>2]|0){case 3:{if((c[j+24>>2]|0)==2){if((h|0)<=0)break a;j=d+40|0;d=0;do{m=c[j>>2]|0;l=e[f+(d*6|0)+2>>1]<<m;k=(e[f+(d*6|0)>>1]<<m)+32768+l&65535;l=l&65535;i=((e[f+(d*6|0)+4>>1]<<m)+32768+((k+l|0)>>>1)&65535)>>>m&65535;b[g+(d*6|0)>>1]=k>>>m;b[g+(d*6|0)+2>>1]=l>>>m;b[g+(d*6|0)+4>>1]=i;d=d+1|0}while((d|0)!=(h|0))}else{k=(h|0)<(i|0)?h:i;if((k|0)<=0)break a;l=i<<1;j=d+40|0;d=0;do{o=c[j>>2]|0;p=e[f+(d+i<<1)>>1]<<o;q=(e[f+(d<<1)>>1]<<o)+32768+p&65535;p=p&65535;m=((e[f+(d+l<<1)>>1]<<o)+32768+((q+p|0)>>>1)&65535)>>>o&65535;b[g+(d*6|0)>>1]=q>>>o;b[g+(d*6|0)+2>>1]=p>>>o;b[g+(d*6|0)+4>>1]=m;d=d+1|0}while((d|0)!=(k|0))}break}case 4:{if((c[j+24>>2]|0)==1?(m=(h|0)<(i|0)?h:i,(m|0)>0):0){l=i<<1;j=d+40|0;d=i*3|0;k=0;do{o=c[j>>2]|0;q=e[f+(k+i<<1)>>1]<<o;s=(e[f+(k<<1)>>1]<<o)+32768+q&65535;q=q&65535;p=((e[f+(k+l<<1)>>1]<<o)+32768+((s+q|0)>>>1)&65535)>>>o;r=b[f+(k+d<<1)>>1]|0;q=mw(q>>>o&65535|0,0,16)|0;p=D|p;r=mw(r&65535|0,0,48)|0;r=s>>>o&65535|q|r;p=p&65535|D;q=g+(k<<3)|0;o=q;b[o>>1]=r;b[o+2>>1]=r>>>16;q=q+4|0;b[q>>1]=p;b[q+2>>1]=p>>>16;k=k+1|0}while((k|0)!=(m|0))}break}default:{}}while(0);j=c[n>>2]|0;if(!(a[j+32>>0]|0))return;k=c[j+16>>2]|0;if((h|0)<=0)return;j=g;d=0;while(1){s=j+4|0;r=b[j>>1]|0;b[j>>1]=b[s>>1]|0;b[s>>1]=r;d=d+1|0;if((d|0)==(h|0))break;else j=j+(k<<1)|0}return}function Xc(a){a=a|0;var b=0,d=0,e=0;c[a>>2]=36364;b=c[a+20>>2]|0;if(b){d=a+24|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}e=c[a+8>>2]|0;if(!e)return;b=a+12|0;d=c[b>>2]|0;if((d|0)!=(e|0))c[b>>2]=d+(~((d+-2-e|0)>>>1)<<1);cj(e);return}function Yc(a){a=a|0;var b=0,d=0,e=0;c[a>>2]=36364;b=c[a+20>>2]|0;if(b){d=a+24|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}e=c[a+8>>2]|0;if(!e){cj(a);return}b=a+12|0;d=c[b>>2]|0;if((d|0)!=(e|0))c[b>>2]=d+(~((d+-2-e|0)>>>1)<<1);cj(e);cj(a);return}function Zc(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;g=b+48|0;if(!(c[g>>2]|0)){j=b+52|0;bd(b,d,c[j>>2]|0,e,f);c[j>>2]=(c[j>>2]|0)+(c[(c[b+4>>2]|0)+12>>2]|0);return}k=b+4|0;h=e<<1;i=$(h,c[(c[k>>2]|0)+16>>2]|0)|0;j=b+20|0;bd(b,d,c[j>>2]|0,e,f);d=c[k>>2]|0;if((c[d+28>>2]|0)==536870912)Oc(c[j>>2]|0,$(h,c[d+16>>2]|0)|0);k=c[g>>2]|0;if((Gb[c[(c[k>>2]|0)+48>>2]&63](k,c[j>>2]|0,i)|0)==(i|0))return;d=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,d|0,3,35648);k=o;o=0;if(k&1){k=Na()|0;La(d|0);Ya(k|0)}else lb(d|0,824,96)}function _c(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=c[a+48>>2]|0;if(!f){f=a+52|0;$c(a,c[f>>2]|0,b,d,e);c[f>>2]=(c[f>>2]|0)+(c[(c[a+4>>2]|0)+12>>2]|0);return}else{ad(a,f,b,d,e);return}}function $c(d,f,g,h,i){d=d|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0;m=d+4|0;j=c[m>>2]|0;do if(!(a[j+32>>0]|0))n=f;else{k=d+8|0;lw(c[k>>2]|0,f|0,h*6|0)|0;j=c[m>>2]|0;l=c[j+16>>2]|0;if((h|0)<=0){n=c[k>>2]|0;break}f=c[k>>2]|0;j=f;k=0;while(1){n=j+4|0;o=b[j>>1]|0;b[j>>1]=b[n>>1]|0;b[n>>1]=o;k=k+1|0;if((k|0)==(h|0))break;else j=j+(l<<1)|0}n=f;j=c[m>>2]|0}while(0);switch(c[j+16>>2]|0){case 3:if((c[j+24>>2]|0)==2){if((h|0)<=0)return;j=d+32|0;f=0;do{i=c[j>>2]|0;d=e[n+(f*6|0)+2>>1]<<i;o=(32768-d+(e[n+(f*6|0)+4>>1]<<i)&65535)>>>i&65535;b[g+(f*6|0)>>1]=((e[n+(f*6|0)>>1]<<i)+32768-d&65535)>>>i;b[g+(f*6|0)+2>>1]=(d&65535)>>>i;b[g+(f*6|0)+4>>1]=o;f=f+1|0}while((f|0)!=(h|0));return}else{k=(i|0)<(h|0)?i:h;if((k|0)<=0)return;l=i<<1;j=c[d+32>>2]|0;f=0;do{d=e[n+(f*6|0)+2>>1]<<j;o=(32768-d+(e[n+(f*6|0)+4>>1]<<j)&65535)>>>j&65535;b[g+(f<<1)>>1]=((e[n+(f*6|0)>>1]<<j)+32768-d&65535)>>>j;b[g+(f+i<<1)>>1]=(d&65535)>>>j;b[g+(f+l<<1)>>1]=o;f=f+1|0}while((f|0)!=(k|0));return}case 4:{if((c[j+24>>2]|0)!=1)return;l=(i|0)<(h|0)?i:h;if((l|0)<=0)return;m=i<<1;k=i*3|0;j=c[d+32>>2]|0;f=0;do{o=b[n+(f<<3)+6>>1]|0;h=e[n+(f<<3)+2>>1]<<j;d=(32768-h+(e[n+(f<<3)+4>>1]<<j)&65535)>>>j&65535;b[g+(f<<1)>>1]=((e[n+(f<<3)>>1]<<j)+32768-h&65535)>>>j;b[g+(f+i<<1)>>1]=(h&65535)>>>j;b[g+(f+m<<1)>>1]=d;b[g+(f+k<<1)>>1]=o;f=f+1|0}while((f|0)!=(l|0));return}default:return}}function ad(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0,t=0;q=i;i=i+176|0;r=q+152|0;t=q+16|0;s=q;l=b+4|0;h=c[l>>2]|0;p=f<<1;j=$(p,c[h+16>>2]|0)|0;do if(j){k=b+20|0;while(1){h=Gb[c[(c[d>>2]|0)+32>>2]&63](d,c[k>>2]|0,j)|0;if(!h)break;if((j|0)==(h|0)){m=26;break}else j=j-h|0}if((m|0)==26){h=c[l>>2]|0;break}m=t+56|0;l=t+4|0;c[t>>2]=36160;c[m>>2]=36180;o=0;ia(62,t+56|0,l|0);q=o;o=0;if(q&1){t=Na()|0;fn(m);Ya(t|0)}c[t+128>>2]=0;c[t+132>>2]=-1;c[t>>2]=36200;c[t+56>>2]=36220;o=0;ha(180,l|0);q=o;o=0;do if(q&1)h=Na()|0;else{c[l>>2]=36236;d=t+36|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[t+52>>2]=16;c[r>>2]=0;c[r+4>>2]=0;c[r+8>>2]=0;o=0;ia(63,l|0,r|0);q=o;o=0;if(q&1){h=Na()|0;Im(r);Im(d);nn(l);break}Im(r);o=0;h=ma(28,t|0,49029,57)|0;r=o;o=0;if(!(r&1)?(o=0,ra(36,h|0,0)|0,r=o,o=0,!(r&1)):0){k=Ma(16)|0;o=0;ia(64,s|0,l|0);r=o;o=0;if(!(r&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,k|0,3,35648,s|0);r=o;o=0;if(r&1)j=1;else{o=0;wa(6,k|0,824,96);o=0;j=0}h=Na()|0;Im(s);if(!j){s=h;c[t>>2]=36200;c[m>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(m);Ya(s|0)}}else h=Na()|0;La(k|0);s=h;c[t>>2]=36200;c[m>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(m);Ya(s|0)}s=Na()|0;c[t>>2]=36200;c[m>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(m);Ya(s|0)}while(0);t=h;fn(m);Ya(t|0)}while(0);j=b+20|0;if((c[h+28>>2]|0)!=536870912){t=c[j>>2]|0;$c(b,t,e,f,g);i=q;return}Oc(c[j>>2]|0,$(p,c[h+16>>2]|0)|0);t=c[j>>2]|0;$c(b,t,e,f,g);i=q;return}function bd(d,f,g,h,i){d=d|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;n=d+4|0;j=c[n>>2]|0;a:do switch(c[j+16>>2]|0){case 3:{if((c[j+24>>2]|0)==2){if((h|0)<=0)break a;j=d+40|0;d=0;do{m=c[j>>2]|0;l=e[f+(d*6|0)+2>>1]<<m;i=(l+32768+(e[f+(d*6|0)+4>>1]<<m)&65535)>>>m&65535;b[g+(d*6|0)>>1]=((e[f+(d*6|0)>>1]<<m)+32768+l&65535)>>>m;b[g+(d*6|0)+2>>1]=(l&65535)>>>m;b[g+(d*6|0)+4>>1]=i;d=d+1|0}while((d|0)!=(h|0))}else{k=(h|0)<(i|0)?h:i;if((k|0)<=0)break a;l=i<<1;j=d+40|0;d=0;do{o=c[j>>2]|0;p=e[f+(d+i<<1)>>1]<<o;m=(p+32768+(e[f+(d+l<<1)>>1]<<o)&65535)>>>o&65535;b[g+(d*6|0)>>1]=((e[f+(d<<1)>>1]<<o)+32768+p&65535)>>>o;b[g+(d*6|0)+2>>1]=(p&65535)>>>o;b[g+(d*6|0)+4>>1]=m;d=d+1|0}while((d|0)!=(k|0))}break}case 4:{if((c[j+24>>2]|0)==1?(m=(h|0)<(i|0)?h:i,(m|0)>0):0){l=i<<1;j=d+40|0;d=i*3|0;k=0;do{q=c[j>>2]|0;s=e[f+(k+i<<1)>>1]<<q;p=((e[f+(k<<1)>>1]<<q)+32768+s&65535)>>>q;o=(s+32768+(e[f+(k+l<<1)>>1]<<q)&65535)>>>q;r=b[f+(k+d<<1)>>1]|0;q=mw((s&65535)>>>q&65535|0,0,16)|0;o=o|D;r=mw(r&65535|0,0,48)|0;r=q|p&65535|r;o=o&65535|D;p=g+(k<<3)|0;q=p;b[q>>1]=r;b[q+2>>1]=r>>>16;p=p+4|0;b[p>>1]=o;b[p+2>>1]=o>>>16;k=k+1|0}while((k|0)!=(m|0))}break}default:{}}while(0);j=c[n>>2]|0;if(!(a[j+32>>0]|0))return;k=c[j+16>>2]|0;if((h|0)<=0)return;j=g;d=0;while(1){s=j+4|0;r=b[j>>1]|0;b[j>>1]=b[s>>1]|0;b[s>>1]=r;d=d+1|0;if((d|0)==(h|0))break;else j=j+(k<<1)|0}return}function cd(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,p=0,q=0;p=i;i=i+16|0;m=p;n=c[b>>2]|0;if(!n){b=0;i=p;return b|0}q=d;k=f-q|0;l=g+12|0;j=c[l>>2]|0;k=(j|0)>(k|0)?j-k|0:0;j=e;g=j-q|0;if((g|0)>0?(Gb[c[(c[n>>2]|0)+48>>2]&63](n,d,g)|0)!=(g|0):0){c[b>>2]=0;q=0;i=p;return q|0}do if((k|0)>0){Hm(m,k,h);o=0;g=ma(c[(c[n>>2]|0)+48>>2]|0,n|0,((a[m>>0]&1)==0?m+1|0:c[m+8>>2]|0)|0,k|0)|0;q=o;o=0;if(q&1){q=Na()|0;Im(m);Ya(q|0)}if((g|0)==(k|0)){Im(m);break}c[b>>2]=0;Im(m);q=0;i=p;return q|0}while(0);f=f-j|0;if((f|0)>0?(Gb[c[(c[n>>2]|0)+48>>2]&63](n,e,f)|0)!=(f|0):0){c[b>>2]=0;q=0;i=p;return q|0}c[l>>2]=0;q=n;i=p;return q|0}function dd(a){a=a|0;c[a>>2]=36236;Im(a+32|0);nn(a);return}function ed(a){a=a|0;c[a>>2]=36236;Im(a+32|0);nn(a);cj(a);return}function fd(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0;i=d+44|0;j=c[i>>2]|0;l=d+24|0;m=c[l>>2]|0;if(j>>>0<m>>>0){c[i>>2]=m;j=m}k=j;i=h&24;if(!i){d=b;c[d>>2]=0;c[d+4>>2]=0;d=b+8|0;c[d>>2]=-1;c[d+4>>2]=-1;return}if((g|0)==1&(i|0)==24){d=b;c[d>>2]=0;c[d+4>>2]=0;d=b+8|0;c[d>>2]=-1;c[d+4>>2]=-1;return}a:do switch(g|0){case 0:{i=0;g=0;break}case 1:if(!(h&8)){g=m-(c[d+20>>2]|0)|0;i=g;g=((g|0)<0)<<31>>31;break a}else{g=(c[d+12>>2]|0)-(c[d+8>>2]|0)|0;i=g;g=((g|0)<0)<<31>>31;break a}case 2:{i=d+32|0;if(!(a[i>>0]&1))i=i+1|0;else i=c[d+40>>2]|0;g=j-i|0;i=g;g=((g|0)<0)<<31>>31;break}default:{d=b;c[d>>2]=0;c[d+4>>2]=0;d=b+8|0;c[d>>2]=-1;c[d+4>>2]=-1;return}}while(0);g=jw(i|0,g|0,e|0,f|0)|0;e=D;if((e|0)>=0){i=d+32|0;if(!(a[i>>0]&1))i=i+1|0;else i=c[d+40>>2]|0;f=j-i|0;j=((f|0)<0)<<31>>31;if(!((j|0)<(e|0)|(j|0)==(e|0)&f>>>0<g>>>0)){i=h&8;if(!((g|0)==0&(e|0)==0)){if((i|0)!=0?(c[d+12>>2]|0)==0:0){d=b;c[d>>2]=0;c[d+4>>2]=0;d=b+8|0;c[d>>2]=-1;c[d+4>>2]=-1;return}if((h&16|0)!=0&(m|0)==0){d=b;c[d>>2]=0;c[d+4>>2]=0;d=b+8|0;c[d>>2]=-1;c[d+4>>2]=-1;return}}if(i){c[d+12>>2]=(c[d+8>>2]|0)+g;c[d+16>>2]=k}if(h&16)c[l>>2]=(c[d+20>>2]|0)+g;d=b;c[d>>2]=0;c[d+4>>2]=0;d=b+8|0;c[d>>2]=g;c[d+4>>2]=e;return}}d=b;c[d>>2]=0;c[d+4>>2]=0;d=b+8|0;c[d>>2]=-1;c[d+4>>2]=-1;return}function gd(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;d=d+8|0;Ib[c[(c[b>>2]|0)+16>>2]&15](a,b,c[d>>2]|0,c[d+4>>2]|0,0,e);return}function hd(a){a=a|0;var b=0,e=0,f=0,g=0;b=a+44|0;e=c[b>>2]|0;f=c[a+24>>2]|0;if(e>>>0<f>>>0){c[b>>2]=f;e=f}if(!(c[a+48>>2]&8)){a=-1;return a|0}g=a+16|0;b=c[g>>2]|0;f=a+12|0;if(b>>>0<e>>>0){f=c[f>>2]|0;c[g>>2]=e;b=e}else f=c[f>>2]|0;if(f>>>0>=b>>>0){a=-1;return a|0}a=d[f>>0]|0;return a|0}function id(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0;f=b+44|0;e=c[f>>2]|0;g=c[b+24>>2]|0;if(e>>>0<g>>>0){c[f>>2]=g;e=g}j=b+8|0;f=c[j>>2]|0;k=b+12|0;h=c[k>>2]|0;i=f;if(f>>>0>=h>>>0){b=-1;return b|0}if((d|0)==-1){c[j>>2]=f;c[k>>2]=h+-1;c[b+16>>2]=e;b=0;return b|0}if(!(c[b+48>>2]&16)){g=d&255;f=h+-1|0;if(g<<24>>24!=(a[f>>0]|0)){b=-1;return b|0}}else{g=d&255;f=h+-1|0}c[j>>2]=i;c[k>>2]=f;c[b+16>>2]=e;a[f>>0]=g;b=d;return b|0}function jd(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0;t=i;i=i+16|0;n=t;if((d|0)==-1){b=0;i=t;return b|0}p=b+12|0;q=b+8|0;r=(c[p>>2]|0)-(c[q>>2]|0)|0;s=b+24|0;e=c[s>>2]|0;m=b+28|0;f=c[m>>2]|0;do if((e|0)==(f|0)){k=b+48|0;if(!(c[k>>2]&16)){b=-1;i=t;return b|0}l=b+20|0;j=c[l>>2]|0;g=e-j|0;h=b+44|0;j=(c[h>>2]|0)-j|0;f=b+32|0;o=0;ia(67,f|0,0);e=o;o=0;if(!(e&1)){if(!(a[f>>0]&1))e=10;else e=(c[f>>2]&-2)+-1|0;o=0;wa(8,f|0,e|0,0);e=o;o=0;if(!(e&1)){e=a[f>>0]|0;if(!(e&1)){f=f+1|0;e=(e&255)>>>1}else{f=c[b+40>>2]|0;e=c[b+36>>2]|0}u=f+e|0;c[l>>2]=f;c[m>>2]=u;l=f+g|0;c[s>>2]=l;e=f+j|0;c[h>>2]=e;f=u;break}}u=Na(0)|0;Va(u|0)|0;Xa();u=-1;i=t;return u|0}else{u=b+44|0;k=b+48|0;h=u;l=e;e=c[u>>2]|0}while(0);j=l+1|0;c[n>>2]=j;g=c[(j>>>0<e>>>0?h:n)>>2]|0;c[h>>2]=g;if(c[k>>2]&8){e=b+32|0;if(!(a[e>>0]&1))e=e+1|0;else e=c[b+40>>2]|0;c[q>>2]=e;c[p>>2]=e+r;c[b+16>>2]=g}if((l|0)==(f|0)){u=Lb[c[(c[b>>2]|0)+52>>2]&63](b,d&255)|0;i=t;return u|0}else{c[s>>2]=j;a[l>>0]=d;u=d&255;i=t;return u|0}return 0}function kd(a){a=a|0;var b=0,d=0;c[a>>2]=36200;b=a+56|0;c[b>>2]=36220;d=a+4|0;c[d>>2]=36236;Im(a+36|0);nn(d);fn(b);return}function ld(a){a=a|0;var b=0,d=0;c[a>>2]=36200;b=a+56|0;c[b>>2]=36220;d=a+4|0;c[d>>2]=36236;Im(a+36|0);nn(d);fn(b);cj(a);return}function md(a){a=a|0;var b=0,d=0,e=0,f=0;f=c[(c[a>>2]|0)+-12>>2]|0;b=a+f|0;c[b>>2]=36200;d=a+(f+56)|0;c[d>>2]=36220;e=a+(f+4)|0;c[e>>2]=36236;Im(a+(f+36)|0);nn(e);fn(d);cj(b);return}function nd(a){a=a|0;var b=0,d=0,e=0;c[a>>2]=36388;b=c[a+20>>2]|0;if(b){d=a+24|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}e=c[a+8>>2]|0;if(!e)return;b=a+12|0;d=c[b>>2]|0;if((d|0)!=(e|0))c[b>>2]=d+(~((d+-2-e|0)>>>1)<<1);cj(e);return}function od(a){a=a|0;var b=0,d=0,e=0;c[a>>2]=36388;b=c[a+20>>2]|0;if(b){d=a+24|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}e=c[a+8>>2]|0;if(!e){cj(a);return}b=a+12|0;d=c[b>>2]|0;if((d|0)!=(e|0))c[b>>2]=d+(~((d+-2-e|0)>>>1)<<1);cj(e);cj(a);return}function pd(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;g=b+36|0;if(!(c[g>>2]|0)){j=b+40|0;td(b,d,c[j>>2]|0,e,f);c[j>>2]=(c[j>>2]|0)+(c[(c[b+4>>2]|0)+12>>2]|0);return}k=b+4|0;h=e<<1;i=$(h,c[(c[k>>2]|0)+16>>2]|0)|0;j=b+20|0;td(b,d,c[j>>2]|0,e,f);d=c[k>>2]|0;if((c[d+28>>2]|0)==536870912)Oc(c[j>>2]|0,$(h,c[d+16>>2]|0)|0);k=c[g>>2]|0;if((Gb[c[(c[k>>2]|0)+48>>2]&63](k,c[j>>2]|0,i)|0)==(i|0))return;d=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,d|0,3,35648);k=o;o=0;if(k&1){k=Na()|0;La(d|0);Ya(k|0)}else lb(d|0,824,96)}function qd(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=c[a+36>>2]|0;if(!f){f=a+40|0;rd(a,c[f>>2]|0,b,d,e);c[f>>2]=(c[f>>2]|0)+(c[(c[a+4>>2]|0)+12>>2]|0);return}else{sd(a,f,b,d,e);return}}function rd(d,f,g,h,i){d=d|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0;l=d+4|0;j=c[l>>2]|0;do if(!(a[j+32>>0]|0))m=f;else{d=d+8|0;lw(c[d>>2]|0,f|0,h*6|0)|0;j=c[l>>2]|0;k=c[j+16>>2]|0;if((h|0)<=0){m=c[d>>2]|0;break}d=c[d>>2]|0;j=d;f=0;while(1){m=j+4|0;n=b[j>>1]|0;b[j>>1]=b[m>>1]|0;b[m>>1]=n;f=f+1|0;if((f|0)==(h|0))break;else j=j+(k<<1)|0}m=d;j=c[l>>2]|0}while(0);switch(c[j+16>>2]|0){case 3:{if((c[j+24>>2]|0)==2){if((h|0)>0)j=0;else return;do{l=e[m+(j*6|0)+2>>1]|0;i=32768-l+(e[m+(j*6|0)+4>>1]|0)|0;n=(e[m+(j*6|0)>>1]|0)-l+32768|0;b[g+(j*6|0)>>1]=l+49152+(((i&65535)+(n&65535)|0)>>>2);b[g+(j*6|0)+2>>1]=i;b[g+(j*6|0)+4>>1]=n;j=j+1|0}while((j|0)!=(h|0));return}j=(i|0)<(h|0)?i:h;if((j|0)<=0)return;d=i<<1;f=0;do{l=e[m+(f*6|0)+2>>1]|0;h=32768-l+(e[m+(f*6|0)+4>>1]|0)|0;n=(e[m+(f*6|0)>>1]|0)-l+32768|0;b[g+(f<<1)>>1]=l+49152+(((h&65535)+(n&65535)|0)>>>2);b[g+(f+i<<1)>>1]=h;b[g+(f+d<<1)>>1]=n;f=f+1|0}while((f|0)!=(j|0));return}case 4:{if((c[j+24>>2]|0)!=1)return;j=(i|0)<(h|0)?i:h;if((j|0)<=0)return;d=i<<1;f=i*3|0;k=0;do{n=b[m+(k<<3)+6>>1]|0;o=e[m+(k<<3)+2>>1]|0;l=32768-o+(e[m+(k<<3)+4>>1]|0)|0;h=(e[m+(k<<3)>>1]|0)-o+32768|0;b[g+(k<<1)>>1]=o+49152+(((l&65535)+(h&65535)|0)>>>2);b[g+(k+i<<1)>>1]=l;b[g+(k+d<<1)>>1]=h;b[g+(k+f<<1)>>1]=n;k=k+1|0}while((k|0)!=(j|0));return}default:return}}function sd(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0,t=0;q=i;i=i+176|0;r=q+152|0;t=q+16|0;s=q;l=b+4|0;h=c[l>>2]|0;p=f<<1;j=$(p,c[h+16>>2]|0)|0;do if(j){k=b+20|0;while(1){h=Gb[c[(c[d>>2]|0)+32>>2]&63](d,c[k>>2]|0,j)|0;if(!h)break;if((j|0)==(h|0)){m=26;break}else j=j-h|0}if((m|0)==26){h=c[l>>2]|0;break}m=t+56|0;l=t+4|0;c[t>>2]=36160;c[m>>2]=36180;o=0;ia(62,t+56|0,l|0);q=o;o=0;if(q&1){t=Na()|0;fn(m);Ya(t|0)}c[t+128>>2]=0;c[t+132>>2]=-1;c[t>>2]=36200;c[t+56>>2]=36220;o=0;ha(180,l|0);q=o;o=0;do if(q&1)h=Na()|0;else{c[l>>2]=36236;d=t+36|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[t+52>>2]=16;c[r>>2]=0;c[r+4>>2]=0;c[r+8>>2]=0;o=0;ia(63,l|0,r|0);q=o;o=0;if(q&1){h=Na()|0;Im(r);Im(d);nn(l);break}Im(r);o=0;h=ma(28,t|0,49029,57)|0;r=o;o=0;if(!(r&1)?(o=0,ra(36,h|0,0)|0,r=o,o=0,!(r&1)):0){k=Ma(16)|0;o=0;ia(64,s|0,l|0);r=o;o=0;if(!(r&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,k|0,3,35648,s|0);r=o;o=0;if(r&1)j=1;else{o=0;wa(6,k|0,824,96);o=0;j=0}h=Na()|0;Im(s);if(!j){s=h;c[t>>2]=36200;c[m>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(m);Ya(s|0)}}else h=Na()|0;La(k|0);s=h;c[t>>2]=36200;c[m>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(m);Ya(s|0)}s=Na()|0;c[t>>2]=36200;c[m>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(m);Ya(s|0)}while(0);t=h;fn(m);Ya(t|0)}while(0);j=b+20|0;if((c[h+28>>2]|0)!=536870912){t=c[j>>2]|0;rd(b,t,e,f,g);i=q;return}Oc(c[j>>2]|0,$(p,c[h+16>>2]|0)|0);t=c[j>>2]|0;rd(b,t,e,f,g);i=q;return}function td(d,f,g,h,i){d=d|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;m=d+4|0;d=c[m>>2]|0;a:do switch(c[d+16>>2]|0){case 3:{if((c[d+24>>2]|0)==2){if((h|0)>0)d=0;else break a;while(1){l=e[f+(d*6|0)+2>>1]|0;k=e[f+(d*6|0)+4>>1]|0;i=(e[f+(d*6|0)>>1]|0)-((k+l|0)>>>2)+16384|0;b[g+(d*6|0)>>1]=k+32768+i;b[g+(d*6|0)+2>>1]=i;b[g+(d*6|0)+4>>1]=l+32768+i;d=d+1|0;if((d|0)==(h|0))break a}}d=(h|0)<(i|0)?h:i;if((d|0)>0){j=i<<1;k=0;do{n=e[f+(k+i<<1)>>1]|0;o=e[f+(k+j<<1)>>1]|0;l=(e[f+(k<<1)>>1]|0)-((o+n|0)>>>2)+16384|0;b[g+(k*6|0)>>1]=o+32768+l;b[g+(k*6|0)+2>>1]=l;b[g+(k*6|0)+4>>1]=n+32768+l;k=k+1|0}while((k|0)!=(d|0))}break}case 4:{if((c[d+24>>2]|0)==1?(l=(h|0)<(i|0)?h:i,(l|0)>0):0){d=i<<1;j=i*3|0;k=0;do{n=e[f+(k+i<<1)>>1]|0;p=e[f+(k+d<<1)>>1]|0;o=(e[f+(k<<1)>>1]|0)-((p+n|0)>>>2)+16384|0;q=b[f+(k+j<<1)>>1]|0;r=mw(o&65535|0,0,16)|0;n=n+32768+o|D;q=mw(q&65535|0,0,48)|0;q=r|p+32768+o&65535|q;n=n&65535|D;o=g+(k<<3)|0;p=o;b[p>>1]=q;b[p+2>>1]=q>>>16;o=o+4|0;b[o>>1]=n;b[o+2>>1]=n>>>16;k=k+1|0}while((k|0)!=(l|0))}break}default:{}}while(0);d=c[m>>2]|0;if(!(a[d+32>>0]|0))return;k=c[d+16>>2]|0;if((h|0)<=0)return;d=g;j=0;while(1){r=d+4|0;q=b[d>>1]|0;b[d>>1]=b[r>>1]|0;b[r>>1]=q;j=j+1|0;if((j|0)==(h|0))break;else d=d+(k<<1)|0}return}function ud(a){a=a|0;var b=0,d=0,e=0;c[a>>2]=36412;b=c[a+20>>2]|0;if(b){d=a+24|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}e=c[a+8>>2]|0;if(!e)return;b=a+12|0;d=c[b>>2]|0;if((d|0)!=(e|0))c[b>>2]=d+(~((d+-2-e|0)>>>1)<<1);cj(e);return}function vd(a){a=a|0;var b=0,d=0,e=0;c[a>>2]=36412;b=c[a+20>>2]|0;if(b){d=a+24|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}e=c[a+8>>2]|0;if(!e){cj(a);return}b=a+12|0;d=c[b>>2]|0;if((d|0)!=(e|0))c[b>>2]=d+(~((d+-2-e|0)>>>1)<<1);cj(e);cj(a);return}function wd(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;g=b+36|0;if(!(c[g>>2]|0)){j=b+40|0;Ad(b,d,c[j>>2]|0,e,f);c[j>>2]=(c[j>>2]|0)+(c[(c[b+4>>2]|0)+12>>2]|0);return}k=b+4|0;h=e<<1;i=$(h,c[(c[k>>2]|0)+16>>2]|0)|0;j=b+20|0;Ad(b,d,c[j>>2]|0,e,f);d=c[k>>2]|0;if((c[d+28>>2]|0)==536870912)Oc(c[j>>2]|0,$(h,c[d+16>>2]|0)|0);k=c[g>>2]|0;if((Gb[c[(c[k>>2]|0)+48>>2]&63](k,c[j>>2]|0,i)|0)==(i|0))return;d=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,d|0,3,35648);k=o;o=0;if(k&1){k=Na()|0;La(d|0);Ya(k|0)}else lb(d|0,824,96)}function xd(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=c[a+36>>2]|0;if(!f){f=a+40|0;yd(a,c[f>>2]|0,b,d,e);c[f>>2]=(c[f>>2]|0)+(c[(c[a+4>>2]|0)+12>>2]|0);return}else{zd(a,f,b,d,e);return}}function yd(d,f,g,h,i){d=d|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0;l=d+4|0;j=c[l>>2]|0;do if(!(a[j+32>>0]|0))m=f;else{d=d+8|0;lw(c[d>>2]|0,f|0,h*6|0)|0;j=c[l>>2]|0;k=c[j+16>>2]|0;if((h|0)<=0){m=c[d>>2]|0;break}d=c[d>>2]|0;j=d;f=0;while(1){m=j+4|0;n=b[j>>1]|0;b[j>>1]=b[m>>1]|0;b[m>>1]=n;f=f+1|0;if((f|0)==(h|0))break;else j=j+(k<<1)|0}m=d;j=c[l>>2]|0}while(0);switch(c[j+16>>2]|0){case 3:{if((c[j+24>>2]|0)==2){if((h|0)>0)j=0;else return;do{k=e[m+(j*6|0)>>1]|0;i=b[m+(j*6|0)+2>>1]|0;l=i&65535;n=(e[m+(j*6|0)+4>>1]|0)+32768-((l+k|0)>>>1)&65535;b[g+(j*6|0)>>1]=k+32768-l;b[g+(j*6|0)+2>>1]=i;b[g+(j*6|0)+4>>1]=n;j=j+1|0}while((j|0)!=(h|0));return}j=(i|0)<(h|0)?i:h;if((j|0)<=0)return;d=i<<1;f=0;do{h=b[m+(f*6|0)+2>>1]|0;k=e[m+(f*6|0)>>1]|0;l=h&65535;n=(e[m+(f*6|0)+4>>1]|0)+32768-((l+k|0)>>>1)&65535;b[g+(f<<1)>>1]=k+32768-l;b[g+(f+i<<1)>>1]=h;b[g+(f+d<<1)>>1]=n;f=f+1|0}while((f|0)!=(j|0));return}case 4:{if((c[j+24>>2]|0)!=1)return;j=(i|0)<(h|0)?i:h;if((j|0)<=0)return;d=i<<1;f=i*3|0;k=0;do{l=b[m+(k<<3)+2>>1]|0;n=b[m+(k<<3)+6>>1]|0;p=e[m+(k<<3)>>1]|0;o=l&65535;h=(e[m+(k<<3)+4>>1]|0)+32768-((o+p|0)>>>1)&65535;b[g+(k<<1)>>1]=p+32768-o;b[g+(k+i<<1)>>1]=l;b[g+(k+d<<1)>>1]=h;b[g+(k+f<<1)>>1]=n;k=k+1|0}while((k|0)!=(j|0));return}default:return}}function zd(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0,t=0;q=i;i=i+176|0;r=q+152|0;t=q+16|0;s=q;l=b+4|0;h=c[l>>2]|0;p=f<<1;j=$(p,c[h+16>>2]|0)|0;do if(j){k=b+20|0;while(1){h=Gb[c[(c[d>>2]|0)+32>>2]&63](d,c[k>>2]|0,j)|0;if(!h)break;if((j|0)==(h|0)){m=26;break}else j=j-h|0}if((m|0)==26){h=c[l>>2]|0;break}m=t+56|0;l=t+4|0;c[t>>2]=36160;c[m>>2]=36180;o=0;ia(62,t+56|0,l|0);q=o;o=0;if(q&1){t=Na()|0;fn(m);Ya(t|0)}c[t+128>>2]=0;c[t+132>>2]=-1;c[t>>2]=36200;c[t+56>>2]=36220;o=0;ha(180,l|0);q=o;o=0;do if(q&1)h=Na()|0;else{c[l>>2]=36236;d=t+36|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[t+52>>2]=16;c[r>>2]=0;c[r+4>>2]=0;c[r+8>>2]=0;o=0;ia(63,l|0,r|0);q=o;o=0;if(q&1){h=Na()|0;Im(r);Im(d);nn(l);break}Im(r);o=0;h=ma(28,t|0,49029,57)|0;r=o;o=0;if(!(r&1)?(o=0,ra(36,h|0,0)|0,r=o,o=0,!(r&1)):0){k=Ma(16)|0;o=0;ia(64,s|0,l|0);r=o;o=0;if(!(r&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,k|0,3,35648,s|0);r=o;o=0;if(r&1)j=1;else{o=0;wa(6,k|0,824,96);o=0;j=0}h=Na()|0;Im(s);if(!j){s=h;c[t>>2]=36200;c[m>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(m);Ya(s|0)}}else h=Na()|0;La(k|0);s=h;c[t>>2]=36200;c[m>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(m);Ya(s|0)}s=Na()|0;c[t>>2]=36200;c[m>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(m);Ya(s|0)}while(0);t=h;fn(m);Ya(t|0)}while(0);j=b+20|0;if((c[h+28>>2]|0)!=536870912){t=c[j>>2]|0;yd(b,t,e,f,g);i=q;return}Oc(c[j>>2]|0,$(p,c[h+16>>2]|0)|0);t=c[j>>2]|0;yd(b,t,e,f,g);i=q;return}function Ad(d,f,g,h,i){d=d|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;m=d+4|0;d=c[m>>2]|0;a:do switch(c[d+16>>2]|0){case 3:{if((c[d+24>>2]|0)==2){if((h|0)>0)d=0;else break a;while(1){l=b[f+(d*6|0)+2>>1]|0;i=l&65535;k=(e[f+(d*6|0)>>1]|0)+32768+i|0;i=(e[f+(d*6|0)+4>>1]|0)+32768+(((k&65535)+i|0)>>>1)&65535;b[g+(d*6|0)>>1]=k;b[g+(d*6|0)+2>>1]=l;b[g+(d*6|0)+4>>1]=i;d=d+1|0;if((d|0)==(h|0))break a}}d=(h|0)<(i|0)?h:i;if((d|0)>0){j=i<<1;k=0;do{n=b[f+(k+i<<1)>>1]|0;l=n&65535;o=(e[f+(k<<1)>>1]|0)+32768+l|0;l=(e[f+(k+j<<1)>>1]|0)+32768+(((o&65535)+l|0)>>>1)&65535;b[g+(k*6|0)>>1]=o;b[g+(k*6|0)+2>>1]=n;b[g+(k*6|0)+4>>1]=l;k=k+1|0}while((k|0)!=(d|0))}break}case 4:{if((c[d+24>>2]|0)==1?(l=(h|0)<(i|0)?h:i,(l|0)>0):0){d=i<<1;j=i*3|0;k=0;do{o=b[f+(k+i<<1)>>1]|0;n=o&65535;p=(e[f+(k<<1)>>1]|0)+32768+n&65535;n=(e[f+(k+d<<1)>>1]|0)+32768+((p+n|0)>>>1)|0;q=b[f+(k+j<<1)>>1]|0;o=mw(o&65535|0,0,16)|0;n=D|n;q=mw(q&65535|0,0,48)|0;q=p|o|q;n=n&65535|D;o=g+(k<<3)|0;p=o;b[p>>1]=q;b[p+2>>1]=q>>>16;o=o+4|0;b[o>>1]=n;b[o+2>>1]=n>>>16;k=k+1|0}while((k|0)!=(l|0))}break}default:{}}while(0);d=c[m>>2]|0;if(!(a[d+32>>0]|0))return;k=c[d+16>>2]|0;if((h|0)<=0)return;d=g;j=0;while(1){q=d+4|0;p=b[d>>1]|0;b[d>>1]=b[q>>1]|0;b[q>>1]=p;j=j+1|0;if((j|0)==(h|0))break;else d=d+(k<<1)|0}return}function Bd(a){a=a|0;var b=0,d=0,e=0;c[a>>2]=36436;b=c[a+20>>2]|0;if(b){d=a+24|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}e=c[a+8>>2]|0;if(!e)return;b=a+12|0;d=c[b>>2]|0;if((d|0)!=(e|0))c[b>>2]=d+(~((d+-2-e|0)>>>1)<<1);cj(e);return}function Cd(a){a=a|0;var b=0,d=0,e=0;c[a>>2]=36436;b=c[a+20>>2]|0;if(b){d=a+24|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}e=c[a+8>>2]|0;if(!e){cj(a);return}b=a+12|0;d=c[b>>2]|0;if((d|0)!=(e|0))c[b>>2]=d+(~((d+-2-e|0)>>>1)<<1);cj(e);cj(a);return}function Dd(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;g=b+36|0;if(!(c[g>>2]|0)){j=b+40|0;Hd(b,d,c[j>>2]|0,e,f);c[j>>2]=(c[j>>2]|0)+(c[(c[b+4>>2]|0)+12>>2]|0);return}k=b+4|0;h=e<<1;i=$(h,c[(c[k>>2]|0)+16>>2]|0)|0;j=b+20|0;Hd(b,d,c[j>>2]|0,e,f);d=c[k>>2]|0;if((c[d+28>>2]|0)==536870912)Oc(c[j>>2]|0,$(h,c[d+16>>2]|0)|0);k=c[g>>2]|0;if((Gb[c[(c[k>>2]|0)+48>>2]&63](k,c[j>>2]|0,i)|0)==(i|0))return;d=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,d|0,3,35648);k=o;o=0;if(k&1){k=Na()|0;La(d|0);Ya(k|0)}else lb(d|0,824,96)}function Ed(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=c[a+36>>2]|0;if(!f){f=a+40|0;Fd(a,c[f>>2]|0,b,d,e);c[f>>2]=(c[f>>2]|0)+(c[(c[a+4>>2]|0)+12>>2]|0);return}else{Gd(a,f,b,d,e);return}}function Fd(d,f,g,h,i){d=d|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0;l=d+4|0;j=c[l>>2]|0;do if(!(a[j+32>>0]|0))m=f;else{d=d+8|0;lw(c[d>>2]|0,f|0,h*6|0)|0;j=c[l>>2]|0;k=c[j+16>>2]|0;if((h|0)<=0){m=c[d>>2]|0;break}d=c[d>>2]|0;j=d;f=0;while(1){m=j+4|0;n=b[j>>1]|0;b[j>>1]=b[m>>1]|0;b[m>>1]=n;f=f+1|0;if((f|0)==(h|0))break;else j=j+(k<<1)|0}m=d;j=c[l>>2]|0}while(0);switch(c[j+16>>2]|0){case 3:{if((c[j+24>>2]|0)==2){if((h|0)>0)j=0;else return;do{i=b[m+(j*6|0)+2>>1]|0;l=i&65535;n=32768-l+(e[m+(j*6|0)+4>>1]|0)&65535;b[g+(j*6|0)>>1]=(e[m+(j*6|0)>>1]|0)+32768-l;b[g+(j*6|0)+2>>1]=i;b[g+(j*6|0)+4>>1]=n;j=j+1|0}while((j|0)!=(h|0));return}j=(i|0)<(h|0)?i:h;if((j|0)<=0)return;d=i<<1;f=0;do{h=b[m+(f*6|0)+2>>1]|0;l=h&65535;n=32768-l+(e[m+(f*6|0)+4>>1]|0)&65535;b[g+(f<<1)>>1]=(e[m+(f*6|0)>>1]|0)+32768-l;b[g+(f+i<<1)>>1]=h;b[g+(f+d<<1)>>1]=n;f=f+1|0}while((f|0)!=(j|0));return}case 4:{if((c[j+24>>2]|0)!=1)return;j=(i|0)<(h|0)?i:h;if((j|0)<=0)return;d=i<<1;f=i*3|0;k=0;do{l=b[m+(k<<3)+2>>1]|0;n=b[m+(k<<3)+6>>1]|0;o=l&65535;h=32768-o+(e[m+(k<<3)+4>>1]|0)&65535;b[g+(k<<1)>>1]=(e[m+(k<<3)>>1]|0)+32768-o;b[g+(k+i<<1)>>1]=l;b[g+(k+d<<1)>>1]=h;b[g+(k+f<<1)>>1]=n;k=k+1|0}while((k|0)!=(j|0));return}default:return}}function Gd(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0,t=0;q=i;i=i+176|0;r=q+152|0;t=q+16|0;s=q;l=b+4|0;h=c[l>>2]|0;p=f<<1;j=$(p,c[h+16>>2]|0)|0;do if(j){k=b+20|0;while(1){h=Gb[c[(c[d>>2]|0)+32>>2]&63](d,c[k>>2]|0,j)|0;if(!h)break;if((j|0)==(h|0)){m=26;break}else j=j-h|0}if((m|0)==26){h=c[l>>2]|0;break}m=t+56|0;l=t+4|0;c[t>>2]=36160;c[m>>2]=36180;o=0;ia(62,t+56|0,l|0);q=o;o=0;if(q&1){t=Na()|0;fn(m);Ya(t|0)}c[t+128>>2]=0;c[t+132>>2]=-1;c[t>>2]=36200;c[t+56>>2]=36220;o=0;ha(180,l|0);q=o;o=0;do if(q&1)h=Na()|0;else{c[l>>2]=36236;d=t+36|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[t+52>>2]=16;c[r>>2]=0;c[r+4>>2]=0;c[r+8>>2]=0;o=0;ia(63,l|0,r|0);q=o;o=0;if(q&1){h=Na()|0;Im(r);Im(d);nn(l);break}Im(r);o=0;h=ma(28,t|0,49029,57)|0;r=o;o=0;if(!(r&1)?(o=0,ra(36,h|0,0)|0,r=o,o=0,!(r&1)):0){k=Ma(16)|0;o=0;ia(64,s|0,l|0);r=o;o=0;if(!(r&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,k|0,3,35648,s|0);r=o;o=0;if(r&1)j=1;else{o=0;wa(6,k|0,824,96);o=0;j=0}h=Na()|0;Im(s);if(!j){s=h;c[t>>2]=36200;c[m>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(m);Ya(s|0)}}else h=Na()|0;La(k|0);s=h;c[t>>2]=36200;c[m>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(m);Ya(s|0)}s=Na()|0;c[t>>2]=36200;c[m>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(m);Ya(s|0)}while(0);t=h;fn(m);Ya(t|0)}while(0);j=b+20|0;if((c[h+28>>2]|0)!=536870912){t=c[j>>2]|0;Fd(b,t,e,f,g);i=q;return}Oc(c[j>>2]|0,$(p,c[h+16>>2]|0)|0);t=c[j>>2]|0;Fd(b,t,e,f,g);i=q;return}function Hd(d,f,g,h,i){d=d|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;m=d+4|0;d=c[m>>2]|0;a:do switch(c[d+16>>2]|0){case 3:{if((c[d+24>>2]|0)==2){if((h|0)>0)d=0;else break a;while(1){l=b[f+(d*6|0)+2>>1]|0;k=l&65535;i=k+32768+(e[f+(d*6|0)+4>>1]|0)&65535;b[g+(d*6|0)>>1]=(e[f+(d*6|0)>>1]|0)+32768+k;b[g+(d*6|0)+2>>1]=l;b[g+(d*6|0)+4>>1]=i;d=d+1|0;if((d|0)==(h|0))break a}}d=(h|0)<(i|0)?h:i;if((d|0)>0){j=i<<1;k=0;do{n=b[f+(k+i<<1)>>1]|0;o=n&65535;l=o+32768+(e[f+(k+j<<1)>>1]|0)&65535;b[g+(k*6|0)>>1]=(e[f+(k<<1)>>1]|0)+32768+o;b[g+(k*6|0)+2>>1]=n;b[g+(k*6|0)+4>>1]=l;k=k+1|0}while((k|0)!=(d|0))}break}case 4:{if((c[d+24>>2]|0)==1?(l=(h|0)<(i|0)?h:i,(l|0)>0):0){d=i<<1;j=i*3|0;k=0;do{o=b[f+(k+i<<1)>>1]|0;n=o&65535;p=(e[f+(k<<1)>>1]|0)+32768+n|0;n=n+32768+(e[f+(k+d<<1)>>1]|0)|0;q=b[f+(k+j<<1)>>1]|0;o=mw(o&65535|0,0,16)|0;n=D|n;q=mw(q&65535|0,0,48)|0;q=p&65535|o|q;n=n&65535|D;o=g+(k<<3)|0;p=o;b[p>>1]=q;b[p+2>>1]=q>>>16;o=o+4|0;b[o>>1]=n;b[o+2>>1]=n>>>16;k=k+1|0}while((k|0)!=(l|0))}break}default:{}}while(0);d=c[m>>2]|0;if(!(a[d+32>>0]|0))return;k=c[d+16>>2]|0;if((h|0)<=0)return;d=g;j=0;while(1){q=d+4|0;p=b[d>>1]|0;b[d>>1]=b[q>>1]|0;b[q>>1]=p;j=j+1|0;if((j|0)==(h|0))break;else d=d+(k<<1)|0}return}function Id(a){a=a|0;var b=0,d=0,e=0;c[a>>2]=36460;b=c[a+20>>2]|0;if(b){d=a+24|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}e=c[a+8>>2]|0;if(!e)return;b=a+12|0;d=c[b>>2]|0;if((d|0)!=(e|0))c[b>>2]=d+(~((d+-2-e|0)>>>1)<<1);cj(e);return}function Jd(a){a=a|0;var b=0,d=0,e=0;c[a>>2]=36460;b=c[a+20>>2]|0;if(b){d=a+24|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}e=c[a+8>>2]|0;if(!e){cj(a);return}b=a+12|0;d=c[b>>2]|0;if((d|0)!=(e|0))c[b>>2]=d+(~((d+-2-e|0)>>>1)<<1);cj(e);cj(a);return}function Kd(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;g=b+36|0;if(!(c[g>>2]|0)){j=b+40|0;Od(b,d,c[j>>2]|0,e,f);c[j>>2]=(c[j>>2]|0)+(c[(c[b+4>>2]|0)+12>>2]|0);return}k=b+4|0;h=e<<1;i=$(h,c[(c[k>>2]|0)+16>>2]|0)|0;j=b+20|0;Od(b,d,c[j>>2]|0,e,f);d=c[k>>2]|0;if((c[d+28>>2]|0)==536870912)Oc(c[j>>2]|0,$(h,c[d+16>>2]|0)|0);k=c[g>>2]|0;if((Gb[c[(c[k>>2]|0)+48>>2]&63](k,c[j>>2]|0,i)|0)==(i|0))return;d=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,d|0,3,35648);k=o;o=0;if(k&1){k=Na()|0;La(d|0);Ya(k|0)}else lb(d|0,824,96)}function Ld(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=c[a+36>>2]|0;if(!f){f=a+40|0;Md(a,c[f>>2]|0,b,d,e);c[f>>2]=(c[f>>2]|0)+(c[(c[a+4>>2]|0)+12>>2]|0);return}else{Nd(a,f,b,d,e);return}}function Md(d,e,f,g,h){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0;k=d+4|0;i=c[k>>2]|0;do if(!(a[i+32>>0]|0))l=e;else{d=d+8|0;lw(c[d>>2]|0,e|0,g*6|0)|0;i=c[k>>2]|0;j=c[i+16>>2]|0;if((g|0)<=0){l=c[d>>2]|0;break}d=c[d>>2]|0;i=d;e=0;while(1){l=i+4|0;m=b[i>>1]|0;b[i>>1]=b[l>>1]|0;b[l>>1]=m;e=e+1|0;if((e|0)==(g|0))break;else i=i+(j<<1)|0}l=d;i=c[k>>2]|0}while(0);switch(c[i+16>>2]|0){case 3:{if((c[i+24>>2]|0)==2){if((g|0)>0)i=0;else return;do{h=b[l+(i*6|0)+2>>1]|0;m=b[l+(i*6|0)+4>>1]|0;b[f+(i*6|0)>>1]=b[l+(i*6|0)>>1]|0;b[f+(i*6|0)+2>>1]=h;b[f+(i*6|0)+4>>1]=m;i=i+1|0}while((i|0)!=(g|0));return}i=(h|0)<(g|0)?h:g;if((i|0)<=0)return;d=h<<1;e=0;do{g=b[l+(e*6|0)+2>>1]|0;m=b[l+(e*6|0)+4>>1]|0;b[f+(e<<1)>>1]=b[l+(e*6|0)>>1]|0;b[f+(e+h<<1)>>1]=g;b[f+(e+d<<1)>>1]=m;e=e+1|0}while((e|0)!=(i|0));return}case 4:{if((c[i+24>>2]|0)!=1)return;i=(h|0)<(g|0)?h:g;if((i|0)<=0)return;d=h<<1;e=h*3|0;j=0;do{k=b[l+(j<<3)+2>>1]|0;g=b[l+(j<<3)+4>>1]|0;m=b[l+(j<<3)+6>>1]|0;b[f+(j<<1)>>1]=b[l+(j<<3)>>1]|0;b[f+(j+h<<1)>>1]=k;b[f+(j+d<<1)>>1]=g;b[f+(j+e<<1)>>1]=m;j=j+1|0}while((j|0)!=(i|0));return}default:return}}function Nd(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0,t=0;q=i;i=i+176|0;r=q+152|0;t=q+16|0;s=q;l=b+4|0;h=c[l>>2]|0;p=f<<1;j=$(p,c[h+16>>2]|0)|0;do if(j){k=b+20|0;while(1){h=Gb[c[(c[d>>2]|0)+32>>2]&63](d,c[k>>2]|0,j)|0;if(!h)break;if((j|0)==(h|0)){m=26;break}else j=j-h|0}if((m|0)==26){h=c[l>>2]|0;break}m=t+56|0;l=t+4|0;c[t>>2]=36160;c[m>>2]=36180;o=0;ia(62,t+56|0,l|0);q=o;o=0;if(q&1){t=Na()|0;fn(m);Ya(t|0)}c[t+128>>2]=0;c[t+132>>2]=-1;c[t>>2]=36200;c[t+56>>2]=36220;o=0;ha(180,l|0);q=o;o=0;do if(q&1)h=Na()|0;else{c[l>>2]=36236;d=t+36|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[t+52>>2]=16;c[r>>2]=0;c[r+4>>2]=0;c[r+8>>2]=0;o=0;ia(63,l|0,r|0);q=o;o=0;if(q&1){h=Na()|0;Im(r);Im(d);nn(l);break}Im(r);o=0;h=ma(28,t|0,49029,57)|0;r=o;o=0;if(!(r&1)?(o=0,ra(36,h|0,0)|0,r=o,o=0,!(r&1)):0){k=Ma(16)|0;o=0;ia(64,s|0,l|0);r=o;o=0;if(!(r&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,k|0,3,35648,s|0);r=o;o=0;if(r&1)j=1;else{o=0;wa(6,k|0,824,96);o=0;j=0}h=Na()|0;Im(s);if(!j){s=h;c[t>>2]=36200;c[m>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(m);Ya(s|0)}}else h=Na()|0;La(k|0);s=h;c[t>>2]=36200;c[m>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(m);Ya(s|0)}s=Na()|0;c[t>>2]=36200;c[m>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(m);Ya(s|0)}while(0);t=h;fn(m);Ya(t|0)}while(0);j=b+20|0;if((c[h+28>>2]|0)!=536870912){t=c[j>>2]|0;Md(b,t,e,f,g);i=q;return}Oc(c[j>>2]|0,$(p,c[h+16>>2]|0)|0);t=c[j>>2]|0;Md(b,t,e,f,g);i=q;return}function Od(d,f,g,h,i){d=d|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;m=d+4|0;d=c[m>>2]|0;a:do switch(c[d+16>>2]|0){case 3:{if((c[d+24>>2]|0)==2){if((h|0)>0)d=0;else break a;while(1){l=b[f+(d*6|0)+2>>1]|0;i=b[f+(d*6|0)+4>>1]|0;b[g+(d*6|0)>>1]=b[f+(d*6|0)>>1]|0;b[g+(d*6|0)+2>>1]=l;b[g+(d*6|0)+4>>1]=i;d=d+1|0;if((d|0)==(h|0))break a}}d=(h|0)<(i|0)?h:i;if((d|0)>0){j=i<<1;k=0;do{n=b[f+(k+i<<1)>>1]|0;l=b[f+(k+j<<1)>>1]|0;b[g+(k*6|0)>>1]=b[f+(k<<1)>>1]|0;b[g+(k*6|0)+2>>1]=n;b[g+(k*6|0)+4>>1]=l;k=k+1|0}while((k|0)!=(d|0))}break}case 4:{if((c[d+24>>2]|0)==1?(l=(h|0)<(i|0)?h:i,(l|0)>0):0){d=i<<1;j=i*3|0;k=0;do{n=b[f+(k<<1)>>1]|0;q=b[f+(k+j<<1)>>1]|0;o=e[f+(k+d<<1)>>1]|0;p=mw(e[f+(k+i<<1)>>1]|0,0,16)|0;o=D|o;q=mw(q&65535|0,0,48)|0;q=p|n&65535|q;o=o&65535|D;n=g+(k<<3)|0;p=n;b[p>>1]=q;b[p+2>>1]=q>>>16;n=n+4|0;b[n>>1]=o;b[n+2>>1]=o>>>16;k=k+1|0}while((k|0)!=(l|0))}break}default:{}}while(0);d=c[m>>2]|0;if(!(a[d+32>>0]|0))return;k=c[d+16>>2]|0;if((h|0)<=0)return;d=g;j=0;while(1){q=d+4|0;p=b[d>>1]|0;b[d>>1]=b[q>>1]|0;b[q>>1]=p;j=j+1|0;if((j|0)==(h|0))break;else d=d+(k<<1)|0}return}function Pd(a){a=a|0;return}function Qd(a){a=a|0;cj(a);return}function Rd(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;e=$(c[b+8>>2]|0,e)|0;b=c[b+4>>2]|0;if((Gb[c[(c[b>>2]|0)+48>>2]&63](b,d,e)|0)==(e|0))return;f=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,f|0,3,35648);b=o;o=0;if(b&1){b=Na()|0;La(f|0);Ya(b|0)}else lb(f|0,824,96)}function Sd(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,p=0;p=i;i=i+16|0;m=p;l=b+8|0;g=c[l>>2]|0;f=$(g,e)|0;do if(f){j=b+4|0;h=f;while(1){g=c[j>>2]|0;g=Gb[c[(c[g>>2]|0)+32>>2]&63](g,d,h)|0;if(!g)break;f=h-g|0;if((h|0)==(g|0)){k=11;break}else h=f}if((k|0)==11){g=c[l>>2]|0;h=f;break}f=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,f|0,3,35648);b=o;o=0;if(b&1){b=Na()|0;La(f|0);Ya(b|0)}else lb(f|0,824,96)}else h=0;while(0);if((g|0)==2){Oc(d,e<<1);g=c[l>>2]|0}f=c[b+12>>2]|0;if((f|0)<=($(g,e)|0)){i=p;return}b=c[b+4>>2]|0;Ib[c[(c[b>>2]|0)+16>>2]&15](m,b,f-h|0,0,1,24);i=p;return}function Td(a){a=a|0;cj(a);return}function Ud(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;e=a+4|0;lw(c[e>>2]|0,b|0,$(c[a+8>>2]|0,d)|0)|0;c[e>>2]=(c[e>>2]|0)+(c[a+12>>2]|0);return}function Vd(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;e=a+4|0;lw(b|0,c[e>>2]|0,$(c[a+8>>2]|0,d)|0)|0;c[e>>2]=(c[e>>2]|0)+(c[a+12>>2]|0);return}function Wd(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;c[b+112>>2]=0;c[b+108>>2]=0;l=c[d>>2]|0;g=l;do if(l){i=b+92|0;l=b+96|0;j=c[l>>2]|0;k=c[i>>2]|0;e=k;f=j-e|0;if(f>>>0>=4e4)if(f>>>0>4e4?(h=k+4e4|0,(j|0)!=(h|0)):0){c[l>>2]=h;h=e}else h=e;else{Xd(i,4e4-f|0);h=c[i>>2]|0;g=c[d>>2]|0}e=b+116|0;c[e>>2]=h;j=b+124|0;c[j>>2]=h;k=b+104|0;c[k>>2]=g;f=g;if(g){if((c[f+12>>2]|0)==(c[f+16>>2]|0)){d=(Eb[c[(c[g>>2]|0)+36>>2]&127](f)|0)==-1;f=c[j>>2]|0;if(d)break;g=c[e>>2]|0}else{f=h;g=h}i=f-g|0;if(i>>>0<=64){h=b+92|0;if((f|0)==(g|0))f=g;else{f=g;g=0;do{a[(c[h>>2]|0)+g>>0]=a[f+g>>0]|0;g=g+1|0;f=c[e>>2]|0}while(g>>>0<i>>>0);g=c[j>>2]|0}h=c[h>>2]|0;d=h;m=d-f|0;c[e>>2]=h;f=g+m|0;c[j>>2]=f;h=b+120|0;c[h>>2]=(c[h>>2]|0)+m;k=c[k>>2]|0;f=Gb[c[(c[k>>2]|0)+32>>2]&63](k,f,(c[l>>2]|0)-(d+i)|0)|0;f=(c[j>>2]|0)+f|0;c[j>>2]=f}}else f=h}else{c[b+104>>2]=0;f=c[d+4>>2]|0;e=b+116|0;c[e>>2]=f;f=f+(c[d+8>>2]|0)|0;c[b+124>>2]=f}while(0);e=c[e>>2]|0;if(e>>>0>=f>>>0){l=e;m=b+120|0;c[m>>2]=l;ge(b);return}while(1){if((a[e>>0]|0)==-1){f=20;break}e=e+1|0;if(e>>>0>=f>>>0){f=20;break}}if((f|0)==20){m=b+120|0;c[m>>2]=e;ge(b);return}}function Xd(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;k=b+8|0;g=c[k>>2]|0;l=b+4|0;e=c[l>>2]|0;f=e;if((g-f|0)>>>0>=d>>>0){do{a[e>>0]=0;e=(c[l>>2]|0)+1|0;c[l>>2]=e;d=d+-1|0}while((d|0)!=0);return}e=c[b>>2]|0;h=f-e+d|0;if((h|0)<0){$i(b);g=c[k>>2]|0;e=c[b>>2]|0}f=g-e|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<h>>>0?h:f;e=(c[l>>2]|0)-e|0;if(!f){g=0;i=0;h=e}else j=8}else{f=2147483647;e=(c[l>>2]|0)-e|0;j=8}if((j|0)==8){g=f;i=bj(f)|0;h=e}e=i+h|0;g=i+g|0;f=e;do{a[f>>0]=0;f=e+1|0;e=f;d=d+-1|0}while((d|0)!=0);d=c[b>>2]|0;f=(c[l>>2]|0)-d|0;j=i+(h-f)|0;lw(j|0,d|0,f|0)|0;c[b>>2]=j;c[l>>2]=e;c[k>>2]=g;if(!d)return;cj(d);return}function Yd(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;v=i;i=i+32|0;x=v+12|0;u=v;r=a+180|0;s=(c[r>>2]|0)+4|0;if((c[a+32>>2]|0)==1)t=c[a+24>>2]|0;else t=1;d=$(t<<1,s)|0;c[x>>2]=0;y=x+4|0;c[y>>2]=0;c[x+8>>2]=0;do if(d){if(!((d|0)<0?(o=0,ha(178,x|0),w=o,o=0,w&1):0))j=6;if((j|0)==6?(e=d<<1,o=0,f=ka(67,e|0)|0,w=o,o=0,!(w&1)):0){c[x>>2]=f;w=f+(d<<1)|0;c[x+8>>2]=w;iw(f|0,0,e|0)|0;c[y>>2]=w;break}f=Na()|0;d=c[x>>2]|0;if(!d)Ya(f|0);e=c[y>>2]|0;if((e|0)!=(d|0))c[y>>2]=e+(~((e+-2-d|0)>>>1)<<1);cj(d);Ya(f|0)}while(0);c[u>>2]=0;w=u+4|0;c[w>>2]=0;c[u+8>>2]=0;do if(!t)j=18;else{if(!(t>>>0>1073741823?(o=0,ha(178,u|0),q=o,o=0,q&1):0))j=16;if((j|0)==16?(g=t<<2,o=0,h=ka(67,g|0)|0,q=o,o=0,!(q&1)):0){c[u>>2]=h;j=h+(t<<2)|0;c[u+8>>2]=j;iw(h|0,0,g|0)|0;c[w>>2]=j;j=18;break}f=Na()|0;d=c[u>>2]|0;e=d;if(d){g=c[w>>2]|0;if((g|0)!=(d|0))c[w>>2]=g+(~((g+-4-e|0)>>>2)<<2);cj(d)}}while(0);if((j|0)==18){h=a+12|0;a:do if((c[h>>2]|0)>0){j=a+4604|0;k=($(t,s)|0)+1|0;l=a+4608|0;m=a+92|0;n=(t|0)>0;p=a+4600|0;q=0;b:while(1){e=c[x>>2]|0;d=e+2|0;c[j>>2]=d;e=e+(k<<1)|0;c[l>>2]=e;if(!(q&1))d=e;else{c[j>>2]=e;c[l>>2]=d}g=c[m>>2]|0;o=0;Aa(c[(c[g>>2]|0)+12>>2]|0,g|0,d|0,c[r>>2]|0,s|0);g=o;o=0;if(g&1){j=28;break}if(n){d=c[j>>2]|0;e=c[l>>2]|0;f=c[u>>2]|0;g=0;do{c[p>>2]=c[f+(g<<2)>>2];f=c[r>>2]|0;b[d+(f<<1)>>1]=b[d+(f+-1<<1)>>1]|0;b[e+-2>>1]=b[d>>1]|0;o=0;ia(68,a|0,0);f=o;o=0;if(f&1){j=27;break b}f=c[u>>2]|0;c[f+(g<<2)>>2]=c[p>>2];d=(c[j>>2]|0)+(s<<1)|0;c[j>>2]=d;e=(c[l>>2]|0)+(s<<1)|0;c[l>>2]=e;g=g+1|0}while((g|0)<(t|0))}q=q+1|0;if((q|0)>=(c[h>>2]|0)){j=40;break a}}if((j|0)==27){f=Na()|0;break}else if((j|0)==28){f=Na()|0;break}}else j=40;while(0);do if((j|0)==40){o=0;ha(182,a|0);a=o;o=0;if(a&1){f=Na()|0;break}d=c[u>>2]|0;e=d;if(d){f=c[w>>2]|0;if((f|0)!=(d|0))c[w>>2]=f+(~((f+-4-e|0)>>>2)<<2);cj(d)}d=c[x>>2]|0;if(!d){i=v;return}e=c[y>>2]|0;if((e|0)!=(d|0))c[y>>2]=e+(~((e+-2-d|0)>>>1)<<1);cj(d);i=v;return}while(0);d=c[u>>2]|0;e=d;if(d){g=c[w>>2]|0;if((g|0)!=(d|0))c[w>>2]=g+(~((g+-4-e|0)>>>2)<<2);cj(d)}}d=c[x>>2]|0;if(!d)Ya(f|0);e=c[y>>2]|0;if((e|0)!=(d|0))c[y>>2]=e+(~((e+-2-d|0)>>>1)<<1);cj(d);Ya(f|0)}function Zd(d,f){d=d|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;p=d+4604|0;f=c[p>>2]|0;s=d+180|0;if((c[s>>2]|0)<=0)return;q=d+4608|0;r=d+4612|0;i=f;j=e[f+-2>>1]|0;f=e[f>>1]|0;o=0;while(1){n=c[q>>2]|0;m=e[n+(o+-1<<1)>>1]|0;h=o+1|0;g=e[i+(h<<1)>>1]|0;l=c[r>>2]|0;k=f-j|0;i=j-m|0;l=((((a[l+(g-f)>>0]|0)*9|0)+(a[l+k>>0]|0)|0)*9|0)+(a[l+i>>0]|0)|0;if(!l){h=(ce(d,o,0)|0)+o|0;g=c[p>>2]|0;f=e[g+(h+-1<<1)>>1]|0;g=e[g+(h<<1)>>1]|0}else{j=f-m>>31;if((j^i|0)<0)i=f;else i=m+((j^k|0)<0?0:k)|0;n=be(d,l,e[n+(o<<1)>>1]|0,i,0)|0;b[(c[q>>2]|0)+(o<<1)>>1]=n}if((h|0)>=(c[s>>2]|0))break;i=c[p>>2]|0;j=f;f=g;o=h}return}function _d(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;g=b+104|0;if((c[g>>2]|0)>>>0<4)$d(b);h=b+100|0;i=b+112|0;j=b+96|0;k=b+108|0;l=b+116|0;d=c[h>>2]|0;f=0;do{e=a[i>>0]|0;if((d|0)>31)break;d=c[j>>2]|0;if(!(e<<24>>24)){a[c[k>>2]>>0]=d>>>24;c[j>>2]=c[j>>2]<<8;d=(c[h>>2]|0)+8|0}else{a[c[k>>2]>>0]=d>>>25;c[j>>2]=c[j>>2]<<7;d=(c[h>>2]|0)+7|0}c[h>>2]=d;m=c[k>>2]|0;e=(a[m>>0]|0)==-1&1;a[i>>0]=e;c[k>>2]=m+1;c[g>>2]=(c[g>>2]|0)+-1;c[l>>2]=(c[l>>2]|0)+1;f=f+1|0}while((f|0)<4);if(!(e<<24>>24))ae(b,0,(d|0)%8|0);else ae(b,0,(d+-1|0)%8|0);if((c[g>>2]|0)>>>0<4)$d(b);d=c[h>>2]|0;e=0;do{if((d|0)>31)break;d=c[j>>2]|0;if(!(a[i>>0]|0)){a[c[k>>2]>>0]=d>>>24;c[j>>2]=c[j>>2]<<8;d=(c[h>>2]|0)+8|0}else{a[c[k>>2]>>0]=d>>>25;c[j>>2]=c[j>>2]<<7;d=(c[h>>2]|0)+7|0}c[h>>2]=d;m=c[k>>2]|0;a[i>>0]=(a[m>>0]|0)==-1&1;c[k>>2]=m+1;c[g>>2]=(c[g>>2]|0)+-1;c[l>>2]=(c[l>>2]|0)+1;e=e+1|0}while((e|0)<4);if(!(c[b+132>>2]|0))return;$d(b);return}function $d(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;d=c[b+132>>2]|0;if(!d){d=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,d|0,4,35648);b=o;o=0;if(!(b&1))lb(d|0,824,96);b=Na()|0;La(d|0);Ya(b|0)}e=b+108|0;f=b+120|0;h=c[f>>2]|0;g=(c[e>>2]|0)-h|0;if((Gb[c[(c[d>>2]|0)+48>>2]&63](d,h,g)|0)==(g|0)){h=c[f>>2]|0;c[e>>2]=h;c[b+104>>2]=(c[b+124>>2]|0)-h;return}d=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,d|0,4,35648);h=o;o=0;if(!(h&1))lb(d|0,824,96);h=Na()|0;La(d|0);Ya(h|0)}function ae(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;l=b+100|0;e=(c[l>>2]|0)-e|0;c[l>>2]=e;if((e|0)>-1){m=b+96|0;c[m>>2]=c[m>>2]|d<<e;return}m=b+96|0;c[m>>2]=c[m>>2]|d>>0-e;k=b+104|0;if((c[k>>2]|0)>>>0<4){$d(b);e=c[l>>2]|0}h=b+112|0;i=b+108|0;j=b+116|0;f=0;while(1){if((e|0)>31)break;e=c[m>>2]|0;if(!(a[h>>0]|0)){a[c[i>>2]>>0]=e>>>24;c[m>>2]=c[m>>2]<<8;e=(c[l>>2]|0)+8|0}else{a[c[i>>2]>>0]=e>>>25;c[m>>2]=c[m>>2]<<7;e=(c[l>>2]|0)+7|0}c[l>>2]=e;n=c[i>>2]|0;a[h>>0]=(a[n>>0]|0)==-1&1;c[i>>2]=n+1;c[k>>2]=(c[k>>2]|0)+-1;c[j>>2]=(c[j>>2]|0)+1;f=f+1|0;if((f|0)>=4){g=11;break}}a:do if((g|0)==11)if((e|0)<0){c[m>>2]=c[m>>2]|d>>0-e;if((c[k>>2]|0)>>>0<4){$d(b);e=c[l>>2]|0;f=0}else f=0;do{if((e|0)>31)break a;e=c[m>>2]|0;if(!(a[h>>0]|0)){a[c[i>>2]>>0]=e>>>24;c[m>>2]=c[m>>2]<<8;e=(c[l>>2]|0)+8|0}else{a[c[i>>2]>>0]=e>>>25;c[m>>2]=c[m>>2]<<7;e=(c[l>>2]|0)+7|0}c[l>>2]=e;n=c[i>>2]|0;a[h>>0]=(a[n>>0]|0)==-1&1;c[i>>2]=n+1;c[k>>2]=(c[k>>2]|0)+-1;c[j>>2]=(c[j>>2]|0)+1;f=f+1|0}while((f|0)<4)}while(0);c[m>>2]=c[m>>2]|d<<e;return}function be(a,d,e,f,g){a=a|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=d>>31;h=(r^d)-r|0;p=a+196+(h*12|0)+10|0;i=b[p>>1]|0;o=a+196+(h*12|0)|0;g=c[o>>2]|0;if((i|0)<(g|0))if((i<<1|0)<(g|0))if((i<<2|0)<(g|0))if((i<<3|0)<(g|0))if((i<<4|0)<(g|0)){d=5;while(1)if((i<<d|0)<(g|0))d=d+1|0;else break}else d=4;else d=3;else d=2;else d=1;else d=0;m=a+196+(h*12|0)+8|0;g=(b[m>>1]^r)-r+f|0;q=a+136|0;f=c[q>>2]|0;if((g&f|0)==(g|0))l=g;else l=f&~(g>>31);g=(e-l^r)-r|0;k=a+144|0;f=c[k>>2]|0;if((g|0)>0)g=(g+f|0)/(f<<1|1|0)|0;else g=(g-f|0)/(f<<1|1|0)|0;n=a+140|0;j=c[n>>2]|0;e=((g|0)<0?j:0)+g|0;j=e-((e|0)<((j+1|0)/2|0|0)?0:j)|0;h=a+196+(h*12|0)+4|0;if(!(f|d))g=(c[h>>2]<<1)+-1+i>>31;else g=0;f=g^j;fe(a,d,f>>30^f<<1,c[a+156>>2]|0);f=c[a+160>>2]|0;d=(c[o>>2]|0)+((j|0)>-1?j:0-j|0)|0;g=(c[h>>2]|0)+($(c[k>>2]<<1|1,j)|0)|0;e=b[p>>1]|0;if((e|0)==(f|0)){d=d>>1;g=g>>1;e=f>>1}c[o>>2]=d;f=e+1|0;b[p>>1]=f;d=f+g|0;if((d|0)>=1){if((g|0)>0){g=g-f|0;p=b[m>>1]|0;b[m>>1]=(p<<16>>16<127&1)+(p&65535);g=(g|0)>0?0:g}}else{g=b[m>>1]|0;b[m>>1]=(g&65535)-(g<<16>>16>-128&1);g=(d|0)>(~e|0)?d:0-e|0}c[h>>2]=g;f=c[k>>2]|0;e=f<<1|1;d=($(e,(j^r)-r|0)|0)+l|0;if((d|0)>=(0-f|0)){g=c[q>>2]|0;if((g+f|0)<(d|0))d=d-($(c[n>>2]|0,e)|0)|0}else{d=($(c[n>>2]|0,e)|0)+d|0;g=c[q>>2]|0}if((d&g|0)==(d|0)){r=d;r=r&65535;return r|0}r=g&~(d>>31);r=r&65535;return r|0}function ce(a,d,f){a=a|0;d=d|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;l=(c[a+180>>2]|0)-d|0;m=c[a+4608>>2]|0;n=c[a+4604>>2]|0;h=b[m+(d+-1<<1)>>1]|0;k=h&65535;f=c[a+144>>2]|0;i=0;while(1){g=m+(i+d<<1)|0;j=(e[g>>1]|0)-k|0;if((((j|0)>-1?j:0-j|0)|0)>(f|0))break;b[g>>1]=h;i=i+1|0;if((i|0)==(l|0)){i=l;break}}h=(i|0)==(l|0);j=a+4600|0;g=c[36476+(c[j>>2]<<2)>>2]|0;if((1<<g|0)>(i|0))f=i;else{f=i;do{ae(a,1,1);g=c[j>>2]|0;f=f-(1<<c[36476+(g<<2)>>2])|0;g=(g|0)>30?31:g+1|0;c[j>>2]=g;g=c[36476+(g<<2)>>2]|0}while((f|0)>=(1<<g|0))}if(!h){ae(a,f,g+1|0);l=i+d|0;d=m+(l<<1)|0;b[d>>1]=de(a,e[d>>1]|0,k,e[n+(l<<1)>>1]|0)|0;a=c[j>>2]|0;c[j>>2]=(a|0)<1?0:a+-1|0;a=i+1|0;return a|0}if(!f){a=l;return a|0}ae(a,1,1);a=l;return a|0}function de(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;i=d-e|0;j=a+136|0;h=a+144|0;f=c[h>>2]|0;if((((i|0)>-1?i:0-i|0)|0)>(f|0)){g=e-d>>31|1;b=$(g,b-e|0)|0;if((b|0)>0)b=(f+b|0)/(f<<1|1|0)|0;else b=(b-f|0)/(f<<1|1|0)|0;i=a+140|0;f=c[i>>2]|0;d=((b|0)<0?f:0)+b|0;f=d-((d|0)<((f+1|0)/2|0|0)?0:f)|0;ee(a,a+4576|0,f);f=$(f,g)|0;g=c[h>>2]|0;h=g<<1|1;f=($(f,h)|0)+e|0;if((f|0)>=(0-g|0)){b=c[j>>2]|0;if((b+g|0)<(f|0))f=f-($(c[i>>2]|0,h)|0)|0}else{f=($(c[i>>2]|0,h)|0)+f|0;b=c[j>>2]|0}if((f&b|0)==(f|0)){j=f;j=j&65535;return j|0}j=b&~(f>>31);j=j&65535;return j|0}else{b=b-d|0;if((b|0)>0)b=(f+b|0)/(f<<1|1|0)|0;else b=(b-f|0)/(f<<1|1|0)|0;i=a+140|0;f=c[i>>2]|0;g=((b|0)<0?f:0)+b|0;f=g-((g|0)<((f+1|0)/2|0|0)?0:f)|0;ee(a,a+4588|0,f);g=c[h>>2]|0;h=g<<1|1;f=($(h,f)|0)+d|0;if((f|0)>=(0-g|0)){b=c[j>>2]|0;if((b+g|0)<(f|0))f=f-($(c[i>>2]|0,h)|0)|0}else{f=($(c[i>>2]|0,h)|0)+f|0;b=c[j>>2]|0}if((f&b|0)==(f|0)){j=f;j=j&65535;return j|0}j=b&~(f>>31);j=j&65535;return j|0}return 0}function ee(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=e+9|0;j=d[n>>0]|0;m=e+4|0;l=c[m>>2]|0;h=($(j>>>1,l)|0)+(c[e>>2]|0)|0;if((j|0)<(h|0)){i=j;g=0;do{i=i<<1;g=g+1|0}while((i|0)<(h|0));h=g}else h=0;if((f|0)>0&(h|0)==0?d[e+10>>0]<<1>>>0<j>>>0:0)g=1;else k=5;do if((k|0)==5){g=(f|0)<0;if(g?d[e+10>>0]<<1>>>0>=j>>>0:0){g=1;break}g=g&(h|0)!=0}while(0);g=(((f|0)>-1?f:0-f|0)<<1)-l+(g<<31>>31)|0;fe(b,h,g,(c[b+156>>2]|0)+-1-(c[36476+(c[b+4600>>2]<<2)>>2]|0)|0);if((f|0)<0){b=e+10|0;a[b>>0]=(d[b>>0]|0)+1}g=(g+1-(c[m>>2]|0)>>1)+(c[e>>2]|0)|0;c[e>>2]=g;h=a[n>>0]|0;if(h<<24>>24!=(a[e+8>>0]|0)){e=h;e=e&255;e=e+1|0;e=e&255;a[n>>0]=e;return}c[e>>2]=g>>1;b=(h&255)>>>1;a[n>>0]=b;e=e+10|0;a[e>>0]=(d[e>>0]|0)>>>1;e=b;e=e&255;e=e+1|0;e=e&255;a[n>>0]=e;return}function fe(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=d>>b;g=a+148|0;h=e-(c[g>>2]|0)|0;if((f|0)<(h+-1|0)){if((f|0)>30){e=(f|0)/2|0;ae(a,0,e);f=f-e|0}ae(a,1,f+1|0);ae(a,(1<<b)+-1&d,b);return}if((h|0)>31){ae(a,0,31);ae(a,1,e+-31-(c[g>>2]|0)|0)}else ae(a,1,h);b=c[g>>2]|0;ae(a,(1<<b)+-1&d+-1,b);return}function ge(b){b=b|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,p=0;k=b+116|0;e=c[k>>2]|0;l=b+120|0;if(e>>>0<((c[l>>2]|0)+-3|0)>>>0){l=b+112|0;j=c[l>>2]|0;b=b+108|0;c[b>>2]=(d[e+1>>0]<<16|d[e>>0]<<24|d[e+2>>0]<<8|d[e+3>>0])>>>j|c[b>>2];b=32-j>>3;c[k>>2]=e+b;c[l>>2]=(b<<3)+j;return}j=b+104|0;f=c[j>>2]|0;do if(f){if((c[f+12>>2]|0)==(c[f+16>>2]|0)){if((Eb[c[(c[f>>2]|0)+36>>2]&127](f)|0)==-1)break;e=c[k>>2]|0}h=b+124|0;f=c[h>>2]|0;i=f-e|0;if(i>>>0<=64){g=b+92|0;if((f|0)==(e|0))f=e;else{f=0;do{a[(c[g>>2]|0)+f>>0]=a[e+f>>0]|0;f=f+1|0;e=c[k>>2]|0}while(f>>>0<i>>>0);f=e;e=c[h>>2]|0}p=c[g>>2]|0;g=p;m=g-f|0;c[k>>2]=p;f=e+m|0;c[h>>2]=f;c[l>>2]=(c[l>>2]|0)+m;j=c[j>>2]|0;j=Gb[c[(c[j>>2]|0)+32>>2]&63](j,f,(c[b+96>>2]|0)-(g+i)|0)|0;c[h>>2]=(c[h>>2]|0)+j}}while(0);j=b+112|0;i=b+108|0;b=c[b+124>>2]|0;h=b+-1|0;e=c[k>>2]|0;while(1){if(e>>>0>=b>>>0){f=14;break}g=a[e>>0]|0;f=g&255;g=g<<24>>24==-1;if(g){if((e|0)==(h|0)){f=25;break}e=e+1|0;if((a[e>>0]|0)<0){f=25;break}}else e=e+1|0;p=c[j>>2]|0;c[i>>2]=f<<24-p|c[i>>2];c[k>>2]=e;p=p+(g?7:8)|0;c[j>>2]=p;if((p|0)>=24){f=33;break}}if((f|0)==14){if((c[j>>2]|0)>=1)return;e=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,e|0,5,35648);p=o;o=0;if(!(p&1))lb(e|0,824,96);p=Na()|0;La(e|0);Ya(p|0)}else if((f|0)==25){if((c[j>>2]|0)>=1)return;e=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,e|0,5,35648);p=o;o=0;if(!(p&1))lb(e|0,824,96);p=Na()|0;La(e|0);Ya(p|0)}else if((f|0)==33){a:do if(e>>>0<b>>>0)do{if((a[e>>0]|0)==-1)break a;e=e+1|0}while(e>>>0<b>>>0);while(0);c[l>>2]=e;return}}function he(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=i;i=i+32|0;f=p;o=b+144|0;a:do if(!(c[o>>2]|0)){e=c[b+136>>2]|0;d=b+152|0;if((((e|0)==((1<<c[d>>2])+-1|0)?(Ei(f,e,0),(c[f+4>>2]|0)==(c[b+184>>2]|0)):0)?(c[f+8>>2]|0)==(c[b+188>>2]|0):0)?(c[f+12>>2]|0)==(c[b+192>>2]|0):0)switch(c[d>>2]|0){case 8:{o=c[8900]|0;c[b+4612>>2]=o+(((c[8901]|0)-o|0)>>>1);i=p;return}case 10:{o=c[8903]|0;c[b+4612>>2]=o+(((c[8904]|0)-o|0)>>>1);i=p;return}case 12:{o=c[8906]|0;c[b+4612>>2]=o+(((c[8907]|0)-o|0)>>>1);i=p;return}case 16:{o=c[8909]|0;c[b+4612>>2]=o+(((c[8910]|0)-o|0)>>>1);i=p;return}default:break a}}else d=b+152|0;while(0);n=1<<c[d>>2];e=b+4616|0;f=n<<1;g=b+4620|0;h=c[g>>2]|0;d=c[e>>2]|0;j=h-d|0;if(f>>>0<=j>>>0){if(f>>>0<j>>>0?(k=d+f|0,(h|0)!=(k|0)):0)c[g>>2]=k}else{ie(e,f-j|0);d=c[e>>2]|0}m=b+4612|0;c[m>>2]=d+n;d=0-n|0;if((n|0)<=(d|0)){i=p;return}k=b+192|0;l=b+188|0;j=b+184|0;h=d;do{d=c[k>>2]|0;if((h|0)>(0-d|0)){e=c[l>>2]|0;if((h|0)>(0-e|0)){f=c[j>>2]|0;if((h|0)>(0-f|0)){g=c[o>>2]|0;if((h|0)>=(0-g|0))if((g|0)<(h|0))if((f|0)<=(h|0))if((e|0)>(h|0))d=2;else d=(d|0)>(h|0)?3:4;else d=1;else d=0;else d=-1}else d=-2}else d=-3}else d=-4;a[(c[m>>2]|0)+h>>0]=d;h=h+1|0}while((h|0)!=(n|0));i=p;return}function ie(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;k=b+8|0;g=c[k>>2]|0;l=b+4|0;e=c[l>>2]|0;f=e;if((g-f|0)>>>0>=d>>>0){do{a[e>>0]=0;e=(c[l>>2]|0)+1|0;c[l>>2]=e;d=d+-1|0}while((d|0)!=0);return}e=c[b>>2]|0;h=f-e+d|0;if((h|0)<0){$i(b);g=c[k>>2]|0;e=c[b>>2]|0}f=g-e|0;if(f>>>0<1073741823){f=f<<1;f=f>>>0<h>>>0?h:f;e=(c[l>>2]|0)-e|0;if(!f){g=0;i=0;h=e}else j=8}else{f=2147483647;e=(c[l>>2]|0)-e|0;j=8}if((j|0)==8){g=f;i=bj(f)|0;h=e}e=i+h|0;g=i+g|0;f=e;do{a[f>>0]=0;f=e+1|0;e=f;d=d+-1|0}while((d|0)!=0);d=c[b>>2]|0;f=(c[l>>2]|0)-d|0;j=i+(h-f)|0;lw(j|0,d|0,f|0)|0;c[b>>2]=j;c[l>>2]=e;c[k>>2]=g;if(!d)return;cj(d);return}function je(a){a=a|0;var b=0,d=0;c[a>>2]=36612;b=c[a+120>>2]|0;if(b){d=a+124|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}d=a+92|0;b=c[d>>2]|0;c[d>>2]=0;if(b)Bb[c[(c[b>>2]|0)+4>>2]&255](b);a=a+4|0;b=c[a>>2]|0;c[a>>2]=0;if(!b)return;Bb[c[(c[b>>2]|0)+4>>2]&255](b);return}function ke(a){a=a|0;var b=0,d=0;c[a>>2]=36612;b=c[a+120>>2]|0;if(b){d=a+124|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}d=a+92|0;b=c[d>>2]|0;c[d>>2]=0;if(b)Bb[c[(c[b>>2]|0)+4>>2]&255](b);d=a+4|0;b=c[d>>2]|0;c[d>>2]=0;if(!b){cj(a);return}Bb[c[(c[b>>2]|0)+4>>2]&255](b);cj(a);return}function le(a){a=a|0;var b=0,d=0;c[a>>2]=36052;b=c[a+4616>>2]|0;if(b){d=a+4620|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}c[a>>2]=36612;b=c[a+120>>2]|0;if(b){d=a+124|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}d=a+92|0;b=c[d>>2]|0;c[d>>2]=0;if(b)Bb[c[(c[b>>2]|0)+4>>2]&255](b);a=a+4|0;b=c[a>>2]|0;c[a>>2]=0;if(!b)return;Bb[c[(c[b>>2]|0)+4>>2]&255](b);return}function me(a){a=a|0;var b=0,d=0;c[a>>2]=36052;b=c[a+4616>>2]|0;if(b){d=a+4620|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}c[a>>2]=36612;b=c[a+120>>2]|0;if(b){d=a+124|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}d=a+92|0;b=c[d>>2]|0;c[d>>2]=0;if(b)Bb[c[(c[b>>2]|0)+4>>2]&255](b);d=a+4|0;b=c[d>>2]|0;c[d>>2]=0;if(!b){cj(a);return}Bb[c[(c[b>>2]|0)+4>>2]&255](b);cj(a);return}function ne(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;k=i;i=i+32|0;m=k;Ei(m,c[d+136>>2]|0,c[d+144>>2]|0);l=c[e+4>>2]|0;j=c[e+8>>2]|0;j=(j|0)==0?c[m+8>>2]|0:j;h=c[e+12>>2]|0;h=(h|0)==0?c[m+12>>2]|0:h;f=c[e+16>>2]|0;g=c[m+16>>2]|0;c[d+184>>2]=(l|0)==0?c[m+4>>2]|0:l;c[d+188>>2]=j;c[d+192>>2]=h;xe(d);h=d+140|0;e=(c[h>>2]|0)+32|0;e=(e|0)<128?2:(e|0)/64|0;j=0;do{c[d+196+(j*12|0)>>2]=e;c[d+196+(j*12|0)+4>>2]=0;b[d+196+(j*12|0)+8>>1]=0;b[d+196+(j*12|0)+10>>1]=1;j=j+1|0}while((j|0)!=365);l=(c[h>>2]|0)+32|0;l=(l|0)<128?2:(l|0)/64|0;m=((f|0)==0?g:f)&255;c[d+4576>>2]=l;c[d+4580>>2]=0;a[d+4584>>0]=m;a[d+4585>>0]=1;a[d+4586>>0]=0;c[d+4588>>2]=l;c[d+4592>>2]=1;a[d+4596>>0]=m;a[d+4597>>0]=1;a[d+4598>>0]=0;c[d+4600>>2]=0;i=k;return}function oe(d,e,f,g){d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0;o=i;i=i+16|0;m=o;l=d+92|0;k=c[e>>2]|0;c[e>>2]=0;e=c[l>>2]|0;c[l>>2]=k;if(e)Bb[c[(c[e>>2]|0)+4>>2]&255](e);c[m>>2]=0;c[m+4>>2]=g;l=f+8|0;c[m+8>>2]=c[l>>2];if(g){e=bj(4624)|0;g=d+8|0;h=e+4|0;j=g;k=h+84|0;do{c[h>>2]=c[j>>2];h=h+4|0;j=j+4|0}while((h|0)<(k|0));h=e+88|0;k=h+40|0;do{c[h>>2]=0;h=h+4|0}while((h|0)<(k|0));c[e>>2]=35828;c[e+128>>2]=c[d+136>>2];c[e+132>>2]=c[d+140>>2];c[e+136>>2]=c[d+144>>2];c[e+140>>2]=c[d+148>>2];c[e+144>>2]=c[d+152>>2];c[e+148>>2]=c[d+156>>2];c[e+152>>2]=c[d+160>>2];h=e+156|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[e+172>>2]=c[g>>2];c[e+176>>2]=0;c[e+180>>2]=0;c[e+184>>2]=0;h=e+4568|0;g=e+188|0;do{c[g>>2]=0;c[g+4>>2]=0;b[g+8>>1]=0;b[g+10>>1]=1;g=g+12|0}while((g|0)!=(h|0));j=d+4|0;c[h>>2]=0;c[h+4>>2]=0;b[h+8>>1]=0;a[h+10>>0]=0;k=e+4580|0;c[k>>2]=0;c[k+4>>2]=0;b[k+8>>1]=0;a[k+10>>0]=0;k=e+4592|0;c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;c[k+20>>2]=0;c[k+24>>2]=0;a[k+28>>0]=0;if(!(c[e+28>>2]|0))c[e+20>>2]=1;g=c[j>>2]|0;c[j>>2]=e;if(g){Bb[c[(c[g>>2]|0)+4>>2]&255](g);e=c[j>>2]|0}Wd(e,m)}m=d+100|0;c[m>>2]=32;c[d+96>>2]=0;e=c[f>>2]|0;if(!e){c[d+108>>2]=c[f+4>>2];c[d+104>>2]=c[l>>2];qe(d);n=d+116|0;n=c[n>>2]|0;d=c[m>>2]|0;d=d+-32|0;d=(d|0)/8|0;d=n-d|0;i=o;return d|0}c[d+132>>2]=e;h=d+120|0;l=d+124|0;g=c[l>>2]|0;e=c[h>>2]|0;j=e;k=g-j|0;if(k>>>0>=4e3){if(k>>>0>4e3?(n=e+4e3|0,(g|0)!=(n|0)):0){c[l>>2]=n;g=n}}else{Xd(h,4e3-k|0);e=c[h>>2]|0;j=e;g=c[l>>2]|0}c[d+108>>2]=j;c[d+104>>2]=g-e;qe(d);n=d+116|0;n=c[n>>2]|0;d=c[m>>2]|0;d=d+-32|0;d=(d|0)/8|0;d=n-d|0;i=o;return d|0}
function pe(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;w=i;i=i+352|0;x=w+328|0;y=w+192|0;e=w+343|0;f=w+342|0;g=w+341|0;h=w+340|0;r=w+176|0;k=w+168|0;l=w+160|0;m=w+152|0;v=w;t=w+136|0;if((c[b+32>>2]|0)!=0?(c[b+24>>2]|0)!=1:0){s=b+8|0;u=b+36|0;j=c[u>>2]|0;if(!j){b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[e>>0]|0;Aa(37,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}b=c[b+16>>2]|0;if((b|0)==16)switch(j|0){case 1:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[f>>0]|0;Aa(38,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 2:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[g>>0]|0;Aa(39,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 3:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[h>>0]|0;Aa(40,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}default:{j=y+56|0;g=y+4|0;c[y>>2]=36160;c[j>>2]=36180;o=0;ia(62,y+56|0,g|0);w=o;o=0;if(w&1){z=Na()|0;fn(j);Ya(z|0)}c[y+128>>2]=0;c[y+132>>2]=-1;c[y>>2]=36200;c[y+56>>2]=36220;o=0;ha(180,g|0);w=o;o=0;do if(w&1)b=Na()|0;else{c[g>>2]=36236;h=y+36|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[y+52>>2]=16;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;o=0;ia(63,g|0,x|0);w=o;o=0;if(w&1){b=Na()|0;Im(x);Im(h);nn(g);break}Im(x);o=0;b=ma(28,y|0,49007,21)|0;x=o;o=0;do if((!(x&1)?(o=0,p=ra(36,b|0,c[u>>2]|0)|0,x=o,o=0,!(x&1)):0)?(o=0,ma(28,p|0,50997,18)|0,x=o,o=0,!(x&1)):0){f=Ma(16)|0;o=0;ia(64,r|0,g|0);x=o;o=0;if(!(x&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,f|0,9,35648,r|0);x=o;o=0;if(x&1)e=1;else{o=0;wa(6,f|0,824,96);o=0;e=0}b=Na()|0;Im(r);if(!e)break}else b=Na()|0;La(f|0)}else z=34;while(0);if((z|0)==34)b=Na()|0;c[y>>2]=36200;c[j>>2]=36220;c[g>>2]=36236;Im(h);nn(g);fn(j);z=b;Ya(z|0)}while(0);z=b;fn(j);Ya(z|0)}}if((b|0)<=8){b=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,b|0,8,35648);z=o;o=0;if(!(z&1))lb(b|0,824,96);z=Na()|0;La(b|0);Ya(z|0)}e=16-b|0;switch(j|0){case 1:{b=bj(60)|0;c[k>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[k>>2];c[x+4>>2]=c[k+4>>2];Aa(41,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 2:{b=bj(60)|0;c[l>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[l>>2];c[x+4>>2]=c[l+4>>2];Aa(42,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 3:{b=bj(60)|0;c[m>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[m>>2];c[x+4>>2]=c[m+4>>2];Aa(43,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}default:{j=v+56|0;g=v+4|0;c[v>>2]=36160;c[j>>2]=36180;o=0;ia(62,v+56|0,g|0);y=o;o=0;if(y&1){z=Na()|0;fn(j);Ya(z|0)}c[v+128>>2]=0;c[v+132>>2]=-1;c[v>>2]=36200;c[v+56>>2]=36220;o=0;ha(180,g|0);y=o;o=0;do if(y&1)b=Na()|0;else{c[g>>2]=36236;h=v+36|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[v+52>>2]=16;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;o=0;ia(63,g|0,x|0);y=o;o=0;if(y&1){b=Na()|0;Im(x);Im(h);nn(g);break}Im(x);o=0;b=ma(28,v|0,49007,21)|0;y=o;o=0;do if((!(y&1)?(o=0,q=ra(36,b|0,c[u>>2]|0)|0,y=o,o=0,!(y&1)):0)?(o=0,ma(28,q|0,50997,18)|0,y=o,o=0,!(y&1)):0){f=Ma(16)|0;o=0;ia(64,t|0,g|0);y=o;o=0;if(!(y&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,f|0,9,35648,t|0);y=o;o=0;if(y&1)e=1;else{o=0;wa(6,f|0,824,96);o=0;e=0}b=Na()|0;Im(t);if(!e)break}else b=Na()|0;La(f|0)}else z=64;while(0);if((z|0)==64)b=Na()|0;c[v>>2]=36200;c[j>>2]=36220;c[g>>2]=36236;Im(h);nn(g);fn(j);z=b;Ya(z|0)}while(0);z=b;fn(j);Ya(z|0)}}}e=c[d+4>>2]|0;f=bj(16)|0;b=c[b+20>>2]|0;if(!e){z=c[d>>2]|0;c[f>>2]=36132;c[f+4>>2]=z;c[f+8>>2]=6;c[f+12>>2]=b;z=f;i=w;return z|0}else{c[f>>2]=36108;c[f+4>>2]=e;c[f+8>>2]=6;c[f+12>>2]=b;z=f;i=w;return z|0}return 0}function qe(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;u=i;i=i+32|0;w=u+12|0;t=u;q=a+180|0;r=(c[q>>2]|0)+4|0;if((c[a+32>>2]|0)==1)s=c[a+24>>2]|0;else s=1;d=$(s<<1,r)|0;c[w>>2]=0;x=w+4|0;c[x>>2]=0;c[w+8>>2]=0;do if(d){if(!(d>>>0>715827882?(o=0,ha(178,w|0),v=o,o=0,v&1):0))j=6;if((j|0)==6?(o=0,e=ka(67,d*6|0)|0,v=o,o=0,!(v&1)):0){c[x>>2]=e;c[w>>2]=e;f=e+(d*6|0)|0;c[w+8>>2]=f;while(1){b[e>>1]=0;b[e+2>>1]=0;b[e+4>>1]=0;d=d+-1|0;if(!d)break;else e=e+6|0}c[x>>2]=f;break}f=Na()|0;d=c[w>>2]|0;if(!d)Ya(f|0);e=c[x>>2]|0;if((e|0)!=(d|0))c[x>>2]=e+(~(((e+-6-d|0)>>>0)/6|0)*6|0);cj(d);Ya(f|0)}while(0);c[t>>2]=0;v=t+4|0;c[v>>2]=0;c[t+8>>2]=0;do if(!s)j=20;else{if(!(s>>>0>1073741823?(o=0,ha(178,t|0),p=o,o=0,p&1):0))j=18;if((j|0)==18?(g=s<<2,o=0,h=ka(67,g|0)|0,p=o,o=0,!(p&1)):0){c[t>>2]=h;j=h+(s<<2)|0;c[t+8>>2]=j;iw(h|0,0,g|0)|0;c[v>>2]=j;j=20;break}f=Na()|0;d=c[t>>2]|0;e=d;if(d){g=c[v>>2]|0;if((g|0)!=(d|0))c[v>>2]=g+(~((g+-4-e|0)>>>2)<<2);cj(d)}}while(0);if((j|0)==20){g=a+12|0;a:do if((c[g>>2]|0)>0){h=a+4604|0;j=($(s,r)|0)+1|0;k=a+4608|0;l=a+92|0;m=(s|0)>0;n=a+4600|0;p=0;b:while(1){e=c[w>>2]|0;d=e+6|0;c[h>>2]=d;e=e+(j*6|0)|0;c[k>>2]=e;if(!(p&1))d=e;else{c[h>>2]=e;c[k>>2]=d}f=c[l>>2]|0;o=0;Aa(c[(c[f>>2]|0)+12>>2]|0,f|0,d|0,c[q>>2]|0,r|0);f=o;o=0;if(f&1){j=30;break}if(m){d=c[t>>2]|0;e=c[h>>2]|0;f=0;do{c[n>>2]=c[d+(f<<2)>>2];y=c[q>>2]|0;d=e+(y*6|0)|0;e=e+((y+-1|0)*6|0)|0;b[d>>1]=b[e>>1]|0;b[d+2>>1]=b[e+2>>1]|0;b[d+4>>1]=b[e+4>>1]|0;e=(c[k>>2]|0)+-6|0;d=c[h>>2]|0;b[e>>1]=b[d>>1]|0;b[e+2>>1]=b[d+2>>1]|0;b[e+4>>1]=b[d+4>>1]|0;o=0;ia(69,a|0,0);e=o;o=0;if(e&1){j=29;break b}d=c[t>>2]|0;c[d+(f<<2)>>2]=c[n>>2];e=(c[h>>2]|0)+(r*6|0)|0;c[h>>2]=e;c[k>>2]=(c[k>>2]|0)+(r*6|0);f=f+1|0}while((f|0)<(s|0))}p=p+1|0;if((p|0)>=(c[g>>2]|0)){j=42;break a}}if((j|0)==29){f=Na()|0;break}else if((j|0)==30){f=Na()|0;break}}else j=42;while(0);do if((j|0)==42){o=0;ha(182,a|0);y=o;o=0;if(y&1){f=Na()|0;break}d=c[t>>2]|0;e=d;if(d){f=c[v>>2]|0;if((f|0)!=(d|0))c[v>>2]=f+(~((f+-4-e|0)>>>2)<<2);cj(d)}d=c[w>>2]|0;if(!d){i=u;return}e=c[x>>2]|0;if((e|0)!=(d|0))c[x>>2]=e+(~(((e+-6-d|0)>>>0)/6|0)*6|0);cj(d);i=u;return}while(0);d=c[t>>2]|0;e=d;if(d){g=c[v>>2]|0;if((g|0)!=(d|0))c[v>>2]=g+(~((g+-4-e|0)>>>2)<<2);cj(d)}}d=c[w>>2]|0;if(!d)Ya(f|0);e=c[x>>2]|0;if((e|0)!=(d|0))c[x>>2]=e+(~(((e+-6-d|0)>>>0)/6|0)*6|0);cj(d);Ya(f|0)}function re(d,f){d=d|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;B=d+180|0;if((c[B>>2]|0)<=0)return;C=d+4608|0;D=d+4604|0;E=d+4612|0;A=0;while(1){x=A+-1|0;j=c[C>>2]|0;k=c[D>>2]|0;f=A+1|0;i=e[k+(A*6|0)>>1]|0;z=c[E>>2]|0;l=e[k+(x*6|0)>>1]|0;m=i-l|0;n=e[j+(x*6|0)>>1]|0;o=l-n|0;p=((((a[z+((e[k+(f*6|0)>>1]|0)-i)>>0]|0)*9|0)+(a[z+m>>0]|0)|0)*9|0)+(a[z+o>>0]|0)|0;h=e[k+(A*6|0)+2>>1]|0;q=e[k+(x*6|0)+2>>1]|0;r=h-q|0;s=e[j+(x*6|0)+2>>1]|0;t=q-s|0;u=((((a[z+((e[k+(f*6|0)+2>>1]|0)-h)>>0]|0)*9|0)+(a[z+r>>0]|0)|0)*9|0)+(a[z+t>>0]|0)|0;g=e[k+(A*6|0)+4>>1]|0;v=e[k+(x*6|0)+4>>1]|0;w=g-v|0;x=e[j+(x*6|0)+4>>1]|0;y=v-x|0;z=((((a[z+((e[k+(f*6|0)+4>>1]|0)-g)>>0]|0)*9|0)+(a[z+w>>0]|0)|0)*9|0)+(a[z+y>>0]|0)|0;if(!(u|p|z))f=(se(d,A,0)|0)+A|0;else{k=e[j+(A*6|0)>>1]|0;j=i-n>>31;if((j^o|0)>=0)if((j^m|0)<0)i=n;else i=n-l+i|0;k=te(d,p,k,i,0)|0;j=e[(c[C>>2]|0)+(A*6|0)+2>>1]|0;i=h-s>>31;if((i^t|0)>=0)if((i^r|0)<0)h=s;else h=s-q+h|0;i=te(d,u,j,h,0)|0;j=e[(c[C>>2]|0)+(A*6|0)+4>>1]|0;h=g-x>>31;if((h^y|0)>=0)if((h^w|0)<0)g=x;else g=x-v+g|0;y=te(d,z,j,g,0)|0;z=c[C>>2]|0;b[z+(A*6|0)>>1]=k;b[z+(A*6|0)+2>>1]=i;b[z+(A*6|0)+4>>1]=y}if((f|0)<(c[B>>2]|0))A=f;else break}return}function se(a,d,f){a=a|0;d=d|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;B=i;i=i+48|0;r=B+30|0;q=B+24|0;p=B+18|0;s=B+12|0;x=B+6|0;y=B;z=(c[a+180>>2]|0)-d|0;A=c[a+4608>>2]|0;t=c[a+4604>>2]|0;w=d+-1|0;u=b[A+(w*6|0)>>1]|0;v=b[A+(w*6|0)+2>>1]|0;w=b[A+(w*6|0)+4>>1]|0;f=u&65535;g=a+144|0;h=v&65535;j=w&65535;o=0;while(1){m=o+d|0;k=A+(m*6|0)|0;l=A+(m*6|0)+2|0;m=A+(m*6|0)+4|0;C=(e[k>>1]|0)-f|0;n=c[g>>2]|0;if((((C|0)>-1?C:0-C|0)|0)>(n|0))break;C=(e[l>>1]|0)-h|0;if((((C|0)>-1?C:0-C|0)|0)>(n|0))break;C=(e[m>>1]|0)-j|0;if((((C|0)>-1?C:0-C|0)|0)>(n|0))break;b[k>>1]=u;b[l>>1]=v;b[m>>1]=w;o=o+1|0;if((o|0)==(z|0)){o=z;break}}h=(o|0)==(z|0);j=a+4600|0;g=c[36476+(c[j>>2]<<2)>>2]|0;if((1<<g|0)>(o|0))f=o;else{f=o;do{ae(a,1,1);g=c[j>>2]|0;f=f-(1<<c[36476+(g<<2)>>2])|0;g=(g|0)>30?31:g+1|0;c[j>>2]=g;g=c[36476+(g<<2)>>2]|0}while((f|0)>=(1<<g|0))}if(!h){ae(a,f,g+1|0);d=o+d|0;C=A+(d*6|0)|0;b[x>>1]=b[C>>1]|0;b[x+2>>1]=b[C+2>>1]|0;b[x+4>>1]=b[C+4>>1]|0;b[y>>1]=u;b[y+2>>1]=v;b[y+4>>1]=w;d=t+(d*6|0)|0;b[p>>1]=b[x>>1]|0;b[p+2>>1]=b[x+2>>1]|0;b[p+4>>1]=b[x+4>>1]|0;b[q>>1]=b[y>>1]|0;b[q+2>>1]=b[y+2>>1]|0;b[q+4>>1]=b[y+4>>1]|0;b[r>>1]=b[d>>1]|0;b[r+2>>1]=b[d+2>>1]|0;b[r+4>>1]=b[d+4>>1]|0;ve(s,a,p,q,r);b[C>>1]=b[s>>1]|0;b[C+2>>1]=b[s+2>>1]|0;b[C+4>>1]=b[s+4>>1]|0;C=c[j>>2]|0;c[j>>2]=(C|0)<1?0:C+-1|0;C=o+1|0;i=B;return C|0}if(!f){C=z;i=B;return C|0}ae(a,1,1);C=z;i=B;return C|0}function te(a,d,e,f,g){a=a|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=d>>31;h=(r^d)-r|0;p=a+196+(h*12|0)+10|0;i=b[p>>1]|0;o=a+196+(h*12|0)|0;g=c[o>>2]|0;if((i|0)<(g|0))if((i<<1|0)<(g|0))if((i<<2|0)<(g|0))if((i<<3|0)<(g|0))if((i<<4|0)<(g|0)){d=5;while(1)if((i<<d|0)<(g|0))d=d+1|0;else break}else d=4;else d=3;else d=2;else d=1;else d=0;m=a+196+(h*12|0)+8|0;g=(b[m>>1]^r)-r+f|0;q=a+136|0;f=c[q>>2]|0;if((g&f|0)==(g|0))l=g;else l=f&~(g>>31);g=(e-l^r)-r|0;k=a+144|0;f=c[k>>2]|0;if((g|0)>0)g=(g+f|0)/(f<<1|1|0)|0;else g=(g-f|0)/(f<<1|1|0)|0;n=a+140|0;j=c[n>>2]|0;e=((g|0)<0?j:0)+g|0;j=e-((e|0)<((j+1|0)/2|0|0)?0:j)|0;h=a+196+(h*12|0)+4|0;if(!(f|d))g=(c[h>>2]<<1)+-1+i>>31;else g=0;f=g^j;ue(a,d,f>>30^f<<1,c[a+156>>2]|0);f=c[a+160>>2]|0;d=(c[o>>2]|0)+((j|0)>-1?j:0-j|0)|0;g=(c[h>>2]|0)+($(c[k>>2]<<1|1,j)|0)|0;e=b[p>>1]|0;if((e|0)==(f|0)){d=d>>1;g=g>>1;e=f>>1}c[o>>2]=d;f=e+1|0;b[p>>1]=f;d=f+g|0;if((d|0)>=1){if((g|0)>0){g=g-f|0;p=b[m>>1]|0;b[m>>1]=(p<<16>>16<127&1)+(p&65535);g=(g|0)>0?0:g}}else{g=b[m>>1]|0;b[m>>1]=(g&65535)-(g<<16>>16>-128&1);g=(d|0)>(~e|0)?d:0-e|0}c[h>>2]=g;f=c[k>>2]|0;e=f<<1|1;d=($(e,(j^r)-r|0)|0)+l|0;if((d|0)>=(0-f|0)){g=c[q>>2]|0;if((g+f|0)<(d|0))d=d-($(c[n>>2]|0,e)|0)|0}else{d=($(c[n>>2]|0,e)|0)+d|0;g=c[q>>2]|0}if((d&g|0)==(d|0)){r=d;r=r&65535;return r|0}r=g&~(d>>31);r=r&65535;return r|0}function ue(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=d>>b;g=a+148|0;h=e-(c[g>>2]|0)|0;if((f|0)<(h+-1|0)){if((f|0)>30){e=(f|0)/2|0;ae(a,0,e);f=f-e|0}ae(a,1,f+1|0);ae(a,(1<<b)+-1&d,b);return}if((h|0)>31){ae(a,0,31);ae(a,1,e+-31-(c[g>>2]|0)|0)}else ae(a,1,h);b=c[g>>2]|0;ae(a,(1<<b)+-1&d+-1,b);return}function ve(a,d,f,g,h){a=a|0;d=d|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;r=d+136|0;o=e[h>>1]|0;p=o-(e[g>>1]|0)>>31|1;i=$(p,(e[f>>1]|0)-o|0)|0;m=d+144|0;j=c[m>>2]|0;if((i|0)>0)i=(i+j|0)/(j<<1|1|0)|0;else i=(i-j|0)/(j<<1|1|0)|0;w=d+140|0;l=c[w>>2]|0;k=((i|0)<0?l:0)+i|0;l=k-((k|0)<((l+1|0)/2|0|0)?0:l)|0;k=d+4576|0;we(d,k,l);t=e[h+2>>1]|0;u=t-(e[g+2>>1]|0)>>31|1;i=$(u,(e[f+2>>1]|0)-t|0)|0;j=c[m>>2]|0;if((i|0)>0)i=(i+j|0)/(j<<1|1|0)|0;else i=(i-j|0)/(j<<1|1|0)|0;q=c[w>>2]|0;v=((i|0)<0?q:0)+i|0;q=v-((v|0)<((q+1|0)/2|0|0)?0:q)|0;we(d,k,q);v=e[h+4>>1]|0;s=v-(e[g+4>>1]|0)>>31|1;i=$(s,(e[f+4>>1]|0)-v|0)|0;j=c[m>>2]|0;if((i|0)>0)i=(i+j|0)/(j<<1|1|0)|0;else i=(i-j|0)/(j<<1|1|0)|0;n=c[w>>2]|0;i=((i|0)<0?n:0)+i|0;n=i-((i|0)<((n+1|0)/2|0|0)?0:n)|0;we(d,k,n);k=c[m>>2]|0;m=k<<1|1;i=($($(m,l)|0,p)|0)+o|0;f=0-k|0;if((i|0)>=(f|0)){j=c[r>>2]|0;if((j+k|0)<(i|0)){i=i-($(c[w>>2]|0,m)|0)|0;g=j}else g=j}else{i=($(c[w>>2]|0,m)|0)+i|0;g=c[r>>2]|0}if((i&g|0)!=(i|0))i=g&~(i>>31);h=i&65535;i=($($(m,q)|0,u)|0)+t|0;if((i|0)>=(f|0)){if((g+k|0)<(i|0))i=i-($(c[w>>2]|0,m)|0)|0}else i=($(c[w>>2]|0,m)|0)+i|0;if((i&g|0)!=(i|0))i=g&~(i>>31);j=i&65535;i=($($(m,n)|0,s)|0)+v|0;if((i|0)>=(f|0)){if((g+k|0)<(i|0))i=i-($(c[w>>2]|0,m)|0)|0}else i=($(c[w>>2]|0,m)|0)+i|0;if((i&g|0)==(i|0)){w=i;w=w&65535;b[a>>1]=h;v=a+2|0;b[v>>1]=j;a=a+4|0;b[a>>1]=w;return}w=g&~(i>>31);w=w&65535;b[a>>1]=h;v=a+2|0;b[v>>1]=j;a=a+4|0;b[a>>1]=w;return}function we(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=e+9|0;j=d[n>>0]|0;m=e+4|0;l=c[m>>2]|0;h=($(j>>>1,l)|0)+(c[e>>2]|0)|0;if((j|0)<(h|0)){i=j;g=0;do{i=i<<1;g=g+1|0}while((i|0)<(h|0));h=g}else h=0;if((f|0)>0&(h|0)==0?d[e+10>>0]<<1>>>0<j>>>0:0)g=1;else k=5;do if((k|0)==5){g=(f|0)<0;if(g?d[e+10>>0]<<1>>>0>=j>>>0:0){g=1;break}g=g&(h|0)!=0}while(0);g=(((f|0)>-1?f:0-f|0)<<1)-l+(g<<31>>31)|0;ue(b,h,g,(c[b+156>>2]|0)+-1-(c[36476+(c[b+4600>>2]<<2)>>2]|0)|0);if((f|0)<0){b=e+10|0;a[b>>0]=(d[b>>0]|0)+1}g=(g+1-(c[m>>2]|0)>>1)+(c[e>>2]|0)|0;c[e>>2]=g;h=a[n>>0]|0;if(h<<24>>24!=(a[e+8>>0]|0)){e=h;e=e&255;e=e+1|0;e=e&255;a[n>>0]=e;return}c[e>>2]=g>>1;b=(h&255)>>>1;a[n>>0]=b;e=e+10|0;a[e>>0]=(d[e>>0]|0)>>>1;e=b;e=e&255;e=e+1|0;e=e&255;a[n>>0]=e;return}function xe(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=i;i=i+32|0;f=p;o=b+144|0;a:do if(!(c[o>>2]|0)){e=c[b+136>>2]|0;d=b+152|0;if((((e|0)==((1<<c[d>>2])+-1|0)?(Ei(f,e,0),(c[f+4>>2]|0)==(c[b+184>>2]|0)):0)?(c[f+8>>2]|0)==(c[b+188>>2]|0):0)?(c[f+12>>2]|0)==(c[b+192>>2]|0):0)switch(c[d>>2]|0){case 8:{o=c[8900]|0;c[b+4612>>2]=o+(((c[8901]|0)-o|0)>>>1);i=p;return}case 10:{o=c[8903]|0;c[b+4612>>2]=o+(((c[8904]|0)-o|0)>>>1);i=p;return}case 12:{o=c[8906]|0;c[b+4612>>2]=o+(((c[8907]|0)-o|0)>>>1);i=p;return}case 16:{o=c[8909]|0;c[b+4612>>2]=o+(((c[8910]|0)-o|0)>>>1);i=p;return}default:break a}}else d=b+152|0;while(0);n=1<<c[d>>2];e=b+4616|0;f=n<<1;g=b+4620|0;h=c[g>>2]|0;d=c[e>>2]|0;j=h-d|0;if(f>>>0<=j>>>0){if(f>>>0<j>>>0?(k=d+f|0,(h|0)!=(k|0)):0)c[g>>2]=k}else{ie(e,f-j|0);d=c[e>>2]|0}m=b+4612|0;c[m>>2]=d+n;d=0-n|0;if((n|0)<=(d|0)){i=p;return}k=b+192|0;l=b+188|0;j=b+184|0;h=d;do{d=c[k>>2]|0;if((h|0)>(0-d|0)){e=c[l>>2]|0;if((h|0)>(0-e|0)){f=c[j>>2]|0;if((h|0)>(0-f|0)){g=c[o>>2]|0;if((h|0)>=(0-g|0))if((g|0)<(h|0))if((f|0)<=(h|0))if((e|0)>(h|0))d=2;else d=(d|0)>(h|0)?3:4;else d=1;else d=0;else d=-1}else d=-2}else d=-3}else d=-4;a[(c[m>>2]|0)+h>>0]=d;h=h+1|0}while((h|0)!=(n|0));i=p;return}function ye(a){a=a|0;var b=0,d=0;c[a>>2]=36024;b=c[a+4616>>2]|0;if(b){d=a+4620|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}c[a>>2]=36612;b=c[a+120>>2]|0;if(b){d=a+124|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}d=a+92|0;b=c[d>>2]|0;c[d>>2]=0;if(b)Bb[c[(c[b>>2]|0)+4>>2]&255](b);a=a+4|0;b=c[a>>2]|0;c[a>>2]=0;if(!b)return;Bb[c[(c[b>>2]|0)+4>>2]&255](b);return}function ze(a){a=a|0;var b=0,d=0;c[a>>2]=36024;b=c[a+4616>>2]|0;if(b){d=a+4620|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}c[a>>2]=36612;b=c[a+120>>2]|0;if(b){d=a+124|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}d=a+92|0;b=c[d>>2]|0;c[d>>2]=0;if(b)Bb[c[(c[b>>2]|0)+4>>2]&255](b);d=a+4|0;b=c[d>>2]|0;c[d>>2]=0;if(!b){cj(a);return}Bb[c[(c[b>>2]|0)+4>>2]&255](b);cj(a);return}function Ae(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;k=i;i=i+32|0;m=k;Ei(m,c[d+136>>2]|0,c[d+144>>2]|0);l=c[e+4>>2]|0;j=c[e+8>>2]|0;j=(j|0)==0?c[m+8>>2]|0:j;h=c[e+12>>2]|0;h=(h|0)==0?c[m+12>>2]|0:h;f=c[e+16>>2]|0;g=c[m+16>>2]|0;c[d+184>>2]=(l|0)==0?c[m+4>>2]|0:l;c[d+188>>2]=j;c[d+192>>2]=h;pf(d);h=d+140|0;e=(c[h>>2]|0)+32|0;e=(e|0)<128?2:(e|0)/64|0;j=0;do{c[d+196+(j*12|0)>>2]=e;c[d+196+(j*12|0)+4>>2]=0;b[d+196+(j*12|0)+8>>1]=0;b[d+196+(j*12|0)+10>>1]=1;j=j+1|0}while((j|0)!=365);l=(c[h>>2]|0)+32|0;l=(l|0)<128?2:(l|0)/64|0;m=((f|0)==0?g:f)&255;c[d+4576>>2]=l;c[d+4580>>2]=0;a[d+4584>>0]=m;a[d+4585>>0]=1;a[d+4586>>0]=0;c[d+4588>>2]=l;c[d+4592>>2]=1;a[d+4596>>0]=m;a[d+4597>>0]=1;a[d+4598>>0]=0;c[d+4600>>2]=0;i=k;return}function Be(d,e,f,g){d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0;o=i;i=i+16|0;m=o;l=d+92|0;k=c[e>>2]|0;c[e>>2]=0;e=c[l>>2]|0;c[l>>2]=k;if(e)Bb[c[(c[e>>2]|0)+4>>2]&255](e);c[m>>2]=0;c[m+4>>2]=g;l=f+8|0;c[m+8>>2]=c[l>>2];if(g){e=bj(4624)|0;g=d+8|0;h=e+4|0;j=g;k=h+84|0;do{c[h>>2]=c[j>>2];h=h+4|0;j=j+4|0}while((h|0)<(k|0));h=e+88|0;k=h+40|0;do{c[h>>2]=0;h=h+4|0}while((h|0)<(k|0));c[e>>2]=35800;c[e+128>>2]=c[d+136>>2];c[e+132>>2]=c[d+140>>2];c[e+136>>2]=c[d+144>>2];c[e+140>>2]=c[d+148>>2];c[e+144>>2]=c[d+152>>2];c[e+148>>2]=c[d+156>>2];c[e+152>>2]=c[d+160>>2];h=e+156|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[e+172>>2]=c[g>>2];c[e+176>>2]=0;c[e+180>>2]=0;c[e+184>>2]=0;h=e+4568|0;g=e+188|0;do{c[g>>2]=0;c[g+4>>2]=0;b[g+8>>1]=0;b[g+10>>1]=1;g=g+12|0}while((g|0)!=(h|0));j=d+4|0;c[h>>2]=0;c[h+4>>2]=0;b[h+8>>1]=0;a[h+10>>0]=0;k=e+4580|0;c[k>>2]=0;c[k+4>>2]=0;b[k+8>>1]=0;a[k+10>>0]=0;k=e+4592|0;c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;c[k+20>>2]=0;c[k+24>>2]=0;a[k+28>>0]=0;if(!(c[e+28>>2]|0))c[e+20>>2]=1;g=c[j>>2]|0;c[j>>2]=e;if(g){Bb[c[(c[g>>2]|0)+4>>2]&255](g);e=c[j>>2]|0}Wd(e,m)}m=d+100|0;c[m>>2]=32;c[d+96>>2]=0;e=c[f>>2]|0;if(!e){c[d+108>>2]=c[f+4>>2];c[d+104>>2]=c[l>>2];hf(d);n=d+116|0;n=c[n>>2]|0;d=c[m>>2]|0;d=d+-32|0;d=(d|0)/8|0;d=n-d|0;i=o;return d|0}c[d+132>>2]=e;h=d+120|0;l=d+124|0;g=c[l>>2]|0;e=c[h>>2]|0;j=e;k=g-j|0;if(k>>>0>=4e3){if(k>>>0>4e3?(n=e+4e3|0,(g|0)!=(n|0)):0){c[l>>2]=n;g=n}}else{Xd(h,4e3-k|0);e=c[h>>2]|0;j=e;g=c[l>>2]|0}c[d+108>>2]=j;c[d+104>>2]=g-e;hf(d);n=d+116|0;n=c[n>>2]|0;d=c[m>>2]|0;d=d+-32|0;d=(d|0)/8|0;d=n-d|0;i=o;return d|0}function Ce(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;w=i;i=i+352|0;x=w+328|0;y=w+192|0;e=w+343|0;f=w+342|0;g=w+341|0;h=w+340|0;r=w+176|0;k=w+168|0;l=w+160|0;m=w+152|0;v=w;t=w+136|0;if((c[b+32>>2]|0)!=0?(c[b+24>>2]|0)!=1:0){s=b+8|0;u=b+36|0;j=c[u>>2]|0;if(!j){b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[e>>0]|0;Aa(44,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}b=c[b+16>>2]|0;if((b|0)==8)switch(j|0){case 1:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[f>>0]|0;Aa(45,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 2:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[g>>0]|0;Aa(46,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 3:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[h>>0]|0;Aa(47,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}default:{j=y+56|0;g=y+4|0;c[y>>2]=36160;c[j>>2]=36180;o=0;ia(62,y+56|0,g|0);w=o;o=0;if(w&1){z=Na()|0;fn(j);Ya(z|0)}c[y+128>>2]=0;c[y+132>>2]=-1;c[y>>2]=36200;c[y+56>>2]=36220;o=0;ha(180,g|0);w=o;o=0;do if(w&1)b=Na()|0;else{c[g>>2]=36236;h=y+36|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[y+52>>2]=16;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;o=0;ia(63,g|0,x|0);w=o;o=0;if(w&1){b=Na()|0;Im(x);Im(h);nn(g);break}Im(x);o=0;b=ma(28,y|0,49007,21)|0;x=o;o=0;do if((!(x&1)?(o=0,p=ra(36,b|0,c[u>>2]|0)|0,x=o,o=0,!(x&1)):0)?(o=0,ma(28,p|0,50997,18)|0,x=o,o=0,!(x&1)):0){f=Ma(16)|0;o=0;ia(64,r|0,g|0);x=o;o=0;if(!(x&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,f|0,9,35648,r|0);x=o;o=0;if(x&1)e=1;else{o=0;wa(6,f|0,824,96);o=0;e=0}b=Na()|0;Im(r);if(!e)break}else b=Na()|0;La(f|0)}else z=34;while(0);if((z|0)==34)b=Na()|0;c[y>>2]=36200;c[j>>2]=36220;c[g>>2]=36236;Im(h);nn(g);fn(j);z=b;Ya(z|0)}while(0);z=b;fn(j);Ya(z|0)}}if((b|0)<=8){b=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,b|0,8,35648);z=o;o=0;if(!(z&1))lb(b|0,824,96);z=Na()|0;La(b|0);Ya(z|0)}e=16-b|0;switch(j|0){case 1:{b=bj(60)|0;c[k>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[k>>2];c[x+4>>2]=c[k+4>>2];Aa(41,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 2:{b=bj(60)|0;c[l>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[l>>2];c[x+4>>2]=c[l+4>>2];Aa(42,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 3:{b=bj(60)|0;c[m>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[m>>2];c[x+4>>2]=c[m+4>>2];Aa(43,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}default:{j=v+56|0;g=v+4|0;c[v>>2]=36160;c[j>>2]=36180;o=0;ia(62,v+56|0,g|0);y=o;o=0;if(y&1){z=Na()|0;fn(j);Ya(z|0)}c[v+128>>2]=0;c[v+132>>2]=-1;c[v>>2]=36200;c[v+56>>2]=36220;o=0;ha(180,g|0);y=o;o=0;do if(y&1)b=Na()|0;else{c[g>>2]=36236;h=v+36|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[v+52>>2]=16;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;o=0;ia(63,g|0,x|0);y=o;o=0;if(y&1){b=Na()|0;Im(x);Im(h);nn(g);break}Im(x);o=0;b=ma(28,v|0,49007,21)|0;y=o;o=0;do if((!(y&1)?(o=0,q=ra(36,b|0,c[u>>2]|0)|0,y=o,o=0,!(y&1)):0)?(o=0,ma(28,q|0,50997,18)|0,y=o,o=0,!(y&1)):0){f=Ma(16)|0;o=0;ia(64,t|0,g|0);y=o;o=0;if(!(y&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,f|0,9,35648,t|0);y=o;o=0;if(y&1)e=1;else{o=0;wa(6,f|0,824,96);o=0;e=0}b=Na()|0;Im(t);if(!e)break}else b=Na()|0;La(f|0)}else z=64;while(0);if((z|0)==64)b=Na()|0;c[v>>2]=36200;c[j>>2]=36220;c[g>>2]=36236;Im(h);nn(g);fn(j);z=b;Ya(z|0)}while(0);z=b;fn(j);Ya(z|0)}}}e=c[d+4>>2]|0;f=bj(16)|0;b=c[b+20>>2]|0;if(!e){z=c[d>>2]|0;c[f>>2]=36132;c[f+4>>2]=z;c[f+8>>2]=3;c[f+12>>2]=b;z=f;i=w;return z|0}else{c[f>>2]=36108;c[f+4>>2]=e;c[f+8>>2]=3;c[f+12>>2]=b;z=f;i=w;return z|0}return 0}function De(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;c[b>>2]=36712;c[b+4>>2]=e;m=b+8|0;f=c[e>>2]|0;k=e+16|0;i=c[k>>2]|0;h=$(i,f)|0;c[m>>2]=0;n=b+12|0;c[n>>2]=0;c[b+16>>2]=0;do if(!h)h=i;else{if(!((h|0)<0?(o=0,ha(178,m|0),i=o,o=0,i&1):0))l=4;if((l|0)==4?(o=0,j=ka(67,h|0)|0,i=o,o=0,!(i&1)):0){c[n>>2]=j;c[m>>2]=j;c[b+16>>2]=j+h;f=j;do{a[f>>0]=0;f=(c[n>>2]|0)+1|0;c[n>>2]=f;h=h+-1|0}while((h|0)!=0);h=c[k>>2]|0;f=c[e>>2]|0;break}f=Na()|0;g=c[m>>2]|0;if(g){if((c[n>>2]|0)!=(g|0))c[n>>2]=g;cj(g)}n=f;Ya(n|0)}while(0);i=b+20|0;f=$(h,f)|0;c[i>>2]=0;h=b+24|0;c[h>>2]=0;c[b+28>>2]=0;if(!f){n=b+36|0;c[n>>2]=c[d>>2];c[n+4>>2]=c[d+4>>2];c[n+8>>2]=c[d+8>>2];return}if(!((f|0)<0?(o=0,ha(178,i|0),e=o,o=0,e&1):0))l=15;if((l|0)==15?(o=0,g=ka(67,f|0)|0,l=o,o=0,!(l&1)):0){c[h>>2]=g;c[i>>2]=g;c[b+28>>2]=g+f;do{a[g>>0]=0;g=(c[h>>2]|0)+1|0;c[h>>2]=g;f=f+-1|0}while((f|0)!=0);n=b+36|0;c[n>>2]=c[d>>2];c[n+4>>2]=c[d+4>>2];c[n+8>>2]=c[d+8>>2];return}f=Na()|0;g=c[i>>2]|0;if(g){if((c[h>>2]|0)!=(g|0))c[h>>2]=g;cj(g)}g=c[m>>2]|0;if(!g){n=f;Ya(n|0)}if((c[n>>2]|0)!=(g|0))c[n>>2]=g;cj(g);n=f;Ya(n|0)}function Ee(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;c[b>>2]=36688;c[b+4>>2]=e;m=b+8|0;f=c[e>>2]|0;k=e+16|0;i=c[k>>2]|0;h=$(i,f)|0;c[m>>2]=0;n=b+12|0;c[n>>2]=0;c[b+16>>2]=0;do if(!h)h=i;else{if(!((h|0)<0?(o=0,ha(178,m|0),i=o,o=0,i&1):0))l=4;if((l|0)==4?(o=0,j=ka(67,h|0)|0,i=o,o=0,!(i&1)):0){c[n>>2]=j;c[m>>2]=j;c[b+16>>2]=j+h;f=j;do{a[f>>0]=0;f=(c[n>>2]|0)+1|0;c[n>>2]=f;h=h+-1|0}while((h|0)!=0);h=c[k>>2]|0;f=c[e>>2]|0;break}f=Na()|0;g=c[m>>2]|0;if(g){if((c[n>>2]|0)!=(g|0))c[n>>2]=g;cj(g)}n=f;Ya(n|0)}while(0);i=b+20|0;f=$(h,f)|0;c[i>>2]=0;h=b+24|0;c[h>>2]=0;c[b+28>>2]=0;if(!f){n=b+36|0;c[n>>2]=c[d>>2];c[n+4>>2]=c[d+4>>2];c[n+8>>2]=c[d+8>>2];return}if(!((f|0)<0?(o=0,ha(178,i|0),e=o,o=0,e&1):0))l=15;if((l|0)==15?(o=0,g=ka(67,f|0)|0,l=o,o=0,!(l&1)):0){c[h>>2]=g;c[i>>2]=g;c[b+28>>2]=g+f;do{a[g>>0]=0;g=(c[h>>2]|0)+1|0;c[h>>2]=g;f=f+-1|0}while((f|0)!=0);n=b+36|0;c[n>>2]=c[d>>2];c[n+4>>2]=c[d+4>>2];c[n+8>>2]=c[d+8>>2];return}f=Na()|0;g=c[i>>2]|0;if(g){if((c[h>>2]|0)!=(g|0))c[h>>2]=g;cj(g)}g=c[m>>2]|0;if(!g){n=f;Ya(n|0)}if((c[n>>2]|0)!=(g|0))c[n>>2]=g;cj(g);n=f;Ya(n|0)}function Fe(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;c[b>>2]=36664;c[b+4>>2]=e;m=b+8|0;f=c[e>>2]|0;k=e+16|0;i=c[k>>2]|0;h=$(i,f)|0;c[m>>2]=0;n=b+12|0;c[n>>2]=0;c[b+16>>2]=0;do if(!h)h=i;else{if(!((h|0)<0?(o=0,ha(178,m|0),i=o,o=0,i&1):0))l=4;if((l|0)==4?(o=0,j=ka(67,h|0)|0,i=o,o=0,!(i&1)):0){c[n>>2]=j;c[m>>2]=j;c[b+16>>2]=j+h;f=j;do{a[f>>0]=0;f=(c[n>>2]|0)+1|0;c[n>>2]=f;h=h+-1|0}while((h|0)!=0);h=c[k>>2]|0;f=c[e>>2]|0;break}f=Na()|0;g=c[m>>2]|0;if(g){if((c[n>>2]|0)!=(g|0))c[n>>2]=g;cj(g)}n=f;Ya(n|0)}while(0);i=b+20|0;f=$(h,f)|0;c[i>>2]=0;h=b+24|0;c[h>>2]=0;c[b+28>>2]=0;if(!f){n=b+36|0;c[n>>2]=c[d>>2];c[n+4>>2]=c[d+4>>2];c[n+8>>2]=c[d+8>>2];return}if(!((f|0)<0?(o=0,ha(178,i|0),e=o,o=0,e&1):0))l=15;if((l|0)==15?(o=0,g=ka(67,f|0)|0,l=o,o=0,!(l&1)):0){c[h>>2]=g;c[i>>2]=g;c[b+28>>2]=g+f;do{a[g>>0]=0;g=(c[h>>2]|0)+1|0;c[h>>2]=g;f=f+-1|0}while((f|0)!=0);n=b+36|0;c[n>>2]=c[d>>2];c[n+4>>2]=c[d+4>>2];c[n+8>>2]=c[d+8>>2];return}f=Na()|0;g=c[i>>2]|0;if(g){if((c[h>>2]|0)!=(g|0))c[h>>2]=g;cj(g)}g=c[m>>2]|0;if(!g){n=f;Ya(n|0)}if((c[n>>2]|0)!=(g|0))c[n>>2]=g;cj(g);n=f;Ya(n|0)}function Ge(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;c[b>>2]=36640;c[b+4>>2]=e;m=b+8|0;f=c[e>>2]|0;k=e+16|0;i=c[k>>2]|0;h=$(i,f)|0;c[m>>2]=0;n=b+12|0;c[n>>2]=0;c[b+16>>2]=0;do if(!h)h=i;else{if(!((h|0)<0?(o=0,ha(178,m|0),i=o,o=0,i&1):0))l=4;if((l|0)==4?(o=0,j=ka(67,h|0)|0,i=o,o=0,!(i&1)):0){c[n>>2]=j;c[m>>2]=j;c[b+16>>2]=j+h;f=j;do{a[f>>0]=0;f=(c[n>>2]|0)+1|0;c[n>>2]=f;h=h+-1|0}while((h|0)!=0);h=c[k>>2]|0;f=c[e>>2]|0;break}f=Na()|0;g=c[m>>2]|0;if(g){if((c[n>>2]|0)!=(g|0))c[n>>2]=g;cj(g)}n=f;Ya(n|0)}while(0);i=b+20|0;f=$(h,f)|0;c[i>>2]=0;h=b+24|0;c[h>>2]=0;c[b+28>>2]=0;if(!f){n=b+36|0;c[n>>2]=c[d>>2];c[n+4>>2]=c[d+4>>2];c[n+8>>2]=c[d+8>>2];return}if(!((f|0)<0?(o=0,ha(178,i|0),e=o,o=0,e&1):0))l=15;if((l|0)==15?(o=0,g=ka(67,f|0)|0,l=o,o=0,!(l&1)):0){c[h>>2]=g;c[i>>2]=g;c[b+28>>2]=g+f;do{a[g>>0]=0;g=(c[h>>2]|0)+1|0;c[h>>2]=g;f=f+-1|0}while((f|0)!=0);n=b+36|0;c[n>>2]=c[d>>2];c[n+4>>2]=c[d+4>>2];c[n+8>>2]=c[d+8>>2];return}f=Na()|0;g=c[i>>2]|0;if(g){if((c[h>>2]|0)!=(g|0))c[h>>2]=g;cj(g)}g=c[m>>2]|0;if(!g){n=f;Ya(n|0)}if((c[n>>2]|0)!=(g|0))c[n>>2]=g;cj(g);n=f;Ya(n|0)}function He(a){a=a|0;var b=0,d=0;c[a>>2]=36640;b=c[a+20>>2]|0;if(b){d=a+24|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}d=c[a+8>>2]|0;if(!d)return;b=a+12|0;if((c[b>>2]|0)!=(d|0))c[b>>2]=d;cj(d);return}function Ie(a){a=a|0;var b=0,d=0;c[a>>2]=36640;b=c[a+20>>2]|0;if(b){d=a+24|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}b=c[a+8>>2]|0;if(!b){cj(a);return}d=a+12|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b);cj(a);return}function Je(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0;g=b+36|0;if(!(c[g>>2]|0)){g=b+40|0;Ne(b,d,c[g>>2]|0,e,f);c[g>>2]=(c[g>>2]|0)+(c[(c[b+4>>2]|0)+12>>2]|0);return}h=$(c[(c[b+4>>2]|0)+16>>2]|0,e)|0;i=b+20|0;Ne(b,d,c[i>>2]|0,e,f);b=c[g>>2]|0;if((Gb[c[(c[b>>2]|0)+48>>2]&63](b,c[i>>2]|0,h)|0)==(h|0))return;g=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,g|0,3,35648);i=o;o=0;if(i&1){i=Na()|0;La(g|0);Ya(i|0)}else lb(g|0,824,96)}function Ke(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=c[a+36>>2]|0;if(!f){f=a+40|0;Le(a,c[f>>2]|0,b,d,e);c[f>>2]=(c[f>>2]|0)+(c[(c[a+4>>2]|0)+12>>2]|0);return}else{Me(a,f,b,d,e);return}}function Le(b,e,f,g,h){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0;k=b+4|0;i=c[k>>2]|0;if(!(a[i+32>>0]|0))k=e;else{j=b+8|0;lw(c[j>>2]|0,e|0,g*3|0)|0;i=c[k>>2]|0;e=c[i+16>>2]|0;if((g|0)>0){i=c[j>>2]|0;b=0;while(1){l=i+2|0;m=a[i>>0]|0;a[i>>0]=a[l>>0]|0;a[l>>0]=m;b=b+1|0;if((b|0)==(g|0))break;else i=i+e|0}i=c[k>>2]|0}k=c[j>>2]|0}switch(c[i+16>>2]|0){case 3:{if((c[i+24>>2]|0)==2){if((g|0)>0)i=0;else return;do{j=d[k+(i*3|0)+1>>0]|0;h=128-j+(d[k+(i*3|0)+2>>0]|0)|0;l=(d[k+(i*3|0)>>0]|0)-j+128|0;m=f+(i*3|0)|0;a[m>>0]=j+192+(((h&255)+(l&255)|0)>>>2);a[m+1>>0]=h;a[m+2>>0]=l;i=i+1|0}while((i|0)!=(g|0));return}i=(h|0)<(g|0)?h:g;if((i|0)<=0)return;b=h<<1;e=0;do{g=d[k+(e*3|0)+1>>0]|0;l=128-g+(d[k+(e*3|0)+2>>0]|0)|0;m=(d[k+(e*3|0)>>0]|0)-g+128|0;a[f+e>>0]=g+192+(((l&255)+(m&255)|0)>>>2);a[f+(e+h)>>0]=l;a[f+(e+b)>>0]=m;e=e+1|0}while((e|0)!=(i|0));return}case 4:{if((c[i+24>>2]|0)!=1)return;i=(h|0)<(g|0)?h:g;if((i|0)<=0)return;b=h<<1;e=h*3|0;j=0;do{m=a[k+(j<<2)+3>>0]|0;n=d[k+(j<<2)+1>>0]|0;g=128-n+(d[k+(j<<2)+2>>0]|0)|0;l=(d[k+(j<<2)>>0]|0)-n+128|0;a[f+j>>0]=n+192+(((g&255)+(l&255)|0)>>>2);a[f+(j+h)>>0]=g;a[f+(j+b)>>0]=l;a[f+(j+e)>>0]=m;j=j+1|0}while((j|0)!=(i|0));return}default:return}}function Me(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0;p=i;i=i+176|0;q=p+152|0;s=p+16|0;r=p;j=$(c[(c[b+4>>2]|0)+16>>2]|0,f)|0;l=b+20|0;h=c[l>>2]|0;if(!j){s=h;Le(b,s,e,f,g);i=p;return}while(1){k=Gb[c[(c[d>>2]|0)+32>>2]&63](d,h,j)|0;if(!k)break;h=c[l>>2]|0;if((j|0)==(k|0)){m=26;break}else j=j-k|0}if((m|0)==26){Le(b,h,e,f,g);i=p;return}e=s+56|0;l=s+4|0;c[s>>2]=36160;c[e>>2]=36180;o=0;ia(62,s+56|0,l|0);p=o;o=0;if(p&1){s=Na()|0;fn(e);Ya(s|0)}c[s+128>>2]=0;c[s+132>>2]=-1;c[s>>2]=36200;c[s+56>>2]=36220;o=0;ha(180,l|0);p=o;o=0;do if(p&1)h=Na()|0;else{c[l>>2]=36236;d=s+36|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[s+52>>2]=16;c[q>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;o=0;ia(63,l|0,q|0);p=o;o=0;if(p&1){h=Na()|0;Im(q);Im(d);nn(l);break}Im(q);o=0;h=ma(28,s|0,49029,57)|0;q=o;o=0;if(!(q&1)?(o=0,ra(36,h|0,0)|0,q=o,o=0,!(q&1)):0){k=Ma(16)|0;o=0;ia(64,r|0,l|0);q=o;o=0;if(!(q&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,k|0,3,35648,r|0);q=o;o=0;if(q&1)j=1;else{o=0;wa(6,k|0,824,96);o=0;j=0}h=Na()|0;Im(r);if(!j){r=h;c[s>>2]=36200;c[e>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(e);Ya(r|0)}}else h=Na()|0;La(k|0);r=h;c[s>>2]=36200;c[e>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(e);Ya(r|0)}r=Na()|0;c[s>>2]=36200;c[e>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(e);Ya(r|0)}while(0);s=h;fn(e);Ya(s|0)}function Ne(b,e,f,g,h){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;l=b+4|0;b=c[l>>2]|0;a:do switch(c[b+16>>2]|0){case 3:{if((c[b+24>>2]|0)==2){if((g|0)>0)b=0;else break a;while(1){j=d[e+(b*3|0)+1>>0]|0;i=d[e+(b*3|0)+2>>0]|0;k=(d[e+(b*3|0)>>0]|0)-((i+j|0)>>>2)+64|0;h=f+(b*3|0)|0;a[h>>0]=i+128+k;a[h+1>>0]=k;a[h+2>>0]=j+128+k;b=b+1|0;if((b|0)==(g|0))break a}}b=(g|0)<(h|0)?g:h;if((b|0)>0){i=h<<1;j=0;do{n=d[e+(j+h)>>0]|0;o=d[e+(j+i)>>0]|0;m=(d[e+j>>0]|0)-((o+n|0)>>>2)+64|0;k=f+(j*3|0)|0;a[k>>0]=o+128+m;a[k+1>>0]=m;a[k+2>>0]=n+128+m;j=j+1|0}while((j|0)!=(b|0))}break}case 4:{if((c[b+24>>2]|0)==1?(k=(g|0)<(h|0)?g:h,(k|0)>0):0){b=h<<1;i=h*3|0;j=0;do{m=d[e+(j+h)>>0]|0;p=d[e+(j+b)>>0]|0;n=(d[e+j>>0]|0)-((p+m|0)>>>2)+64|0;o=f+(j<<2)|0;n=n<<8&65280|d[e+(j+i)>>0]<<24|p+128+n&255|m+128+n<<16&16711680;a[o>>0]=n;a[o+1>>0]=n>>8;a[o+2>>0]=n>>16;a[o+3>>0]=n>>24;j=j+1|0}while((j|0)!=(k|0))}break}default:{}}while(0);b=c[l>>2]|0;if(!(a[b+32>>0]|0))return;j=c[b+16>>2]|0;if((g|0)>0){b=f;i=0}else return;while(1){p=b+2|0;o=a[b>>0]|0;a[b>>0]=a[p>>0]|0;a[p>>0]=o;i=i+1|0;if((i|0)==(g|0))break;else b=b+j|0}return}function Oe(a){a=a|0;var b=0,d=0;c[a>>2]=36664;b=c[a+20>>2]|0;if(b){d=a+24|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}d=c[a+8>>2]|0;if(!d)return;b=a+12|0;if((c[b>>2]|0)!=(d|0))c[b>>2]=d;cj(d);return}function Pe(a){a=a|0;var b=0,d=0;c[a>>2]=36664;b=c[a+20>>2]|0;if(b){d=a+24|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}b=c[a+8>>2]|0;if(!b){cj(a);return}d=a+12|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b);cj(a);return}function Qe(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0;g=b+36|0;if(!(c[g>>2]|0)){g=b+40|0;Ue(b,d,c[g>>2]|0,e,f);c[g>>2]=(c[g>>2]|0)+(c[(c[b+4>>2]|0)+12>>2]|0);return}h=$(c[(c[b+4>>2]|0)+16>>2]|0,e)|0;i=b+20|0;Ue(b,d,c[i>>2]|0,e,f);b=c[g>>2]|0;if((Gb[c[(c[b>>2]|0)+48>>2]&63](b,c[i>>2]|0,h)|0)==(h|0))return;g=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,g|0,3,35648);i=o;o=0;if(i&1){i=Na()|0;La(g|0);Ya(i|0)}else lb(g|0,824,96)}function Re(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=c[a+36>>2]|0;if(!f){f=a+40|0;Se(a,c[f>>2]|0,b,d,e);c[f>>2]=(c[f>>2]|0)+(c[(c[a+4>>2]|0)+12>>2]|0);return}else{Te(a,f,b,d,e);return}}function Se(b,e,f,g,h){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0;k=b+4|0;i=c[k>>2]|0;if(!(a[i+32>>0]|0))k=e;else{j=b+8|0;lw(c[j>>2]|0,e|0,g*3|0)|0;i=c[k>>2]|0;e=c[i+16>>2]|0;if((g|0)>0){i=c[j>>2]|0;b=0;while(1){l=i+2|0;m=a[i>>0]|0;a[i>>0]=a[l>>0]|0;a[l>>0]=m;b=b+1|0;if((b|0)==(g|0))break;else i=i+e|0}i=c[k>>2]|0}k=c[j>>2]|0}switch(c[i+16>>2]|0){case 3:{if((c[i+24>>2]|0)==2){if((g|0)>0)i=0;else return;do{e=d[k+(i*3|0)>>0]|0;h=a[k+(i*3|0)+1>>0]|0;j=h&255;l=(d[k+(i*3|0)+2>>0]|0)+128-((j+e|0)>>>1)&255;m=f+(i*3|0)|0;a[m>>0]=e+128-j;a[m+1>>0]=h;a[m+2>>0]=l;i=i+1|0}while((i|0)!=(g|0));return}i=(h|0)<(g|0)?h:g;if((i|0)<=0)return;b=h<<1;e=0;do{l=a[k+(e*3|0)+1>>0]|0;j=d[k+(e*3|0)>>0]|0;g=l&255;m=(d[k+(e*3|0)+2>>0]|0)+128-((g+j|0)>>>1)&255;a[f+e>>0]=j+128-g;a[f+(e+h)>>0]=l;a[f+(e+b)>>0]=m;e=e+1|0}while((e|0)!=(i|0));return}case 4:{if((c[i+24>>2]|0)!=1)return;i=(h|0)<(g|0)?h:g;if((i|0)<=0)return;b=h<<1;e=h*3|0;j=0;do{g=a[k+(j<<2)+1>>0]|0;m=a[k+(j<<2)+3>>0]|0;o=d[k+(j<<2)>>0]|0;n=g&255;l=(d[k+(j<<2)+2>>0]|0)+128-((n+o|0)>>>1)&255;a[f+j>>0]=o+128-n;a[f+(j+h)>>0]=g;a[f+(j+b)>>0]=l;a[f+(j+e)>>0]=m;j=j+1|0}while((j|0)!=(i|0));return}default:return}}function Te(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0;p=i;i=i+176|0;q=p+152|0;s=p+16|0;r=p;j=$(c[(c[b+4>>2]|0)+16>>2]|0,f)|0;l=b+20|0;h=c[l>>2]|0;if(!j){s=h;Se(b,s,e,f,g);i=p;return}while(1){k=Gb[c[(c[d>>2]|0)+32>>2]&63](d,h,j)|0;if(!k)break;h=c[l>>2]|0;if((j|0)==(k|0)){m=26;break}else j=j-k|0}if((m|0)==26){Se(b,h,e,f,g);i=p;return}e=s+56|0;l=s+4|0;c[s>>2]=36160;c[e>>2]=36180;o=0;ia(62,s+56|0,l|0);p=o;o=0;if(p&1){s=Na()|0;fn(e);Ya(s|0)}c[s+128>>2]=0;c[s+132>>2]=-1;c[s>>2]=36200;c[s+56>>2]=36220;o=0;ha(180,l|0);p=o;o=0;do if(p&1)h=Na()|0;else{c[l>>2]=36236;d=s+36|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[s+52>>2]=16;c[q>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;o=0;ia(63,l|0,q|0);p=o;o=0;if(p&1){h=Na()|0;Im(q);Im(d);nn(l);break}Im(q);o=0;h=ma(28,s|0,49029,57)|0;q=o;o=0;if(!(q&1)?(o=0,ra(36,h|0,0)|0,q=o,o=0,!(q&1)):0){k=Ma(16)|0;o=0;ia(64,r|0,l|0);q=o;o=0;if(!(q&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,k|0,3,35648,r|0);q=o;o=0;if(q&1)j=1;else{o=0;wa(6,k|0,824,96);o=0;j=0}h=Na()|0;Im(r);if(!j){r=h;c[s>>2]=36200;c[e>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(e);Ya(r|0)}}else h=Na()|0;La(k|0);r=h;c[s>>2]=36200;c[e>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(e);Ya(r|0)}r=Na()|0;c[s>>2]=36200;c[e>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(e);Ya(r|0)}while(0);s=h;fn(e);Ya(s|0)}function Ue(b,e,f,g,h){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0;l=b+4|0;b=c[l>>2]|0;a:do switch(c[b+16>>2]|0){case 3:{if((c[b+24>>2]|0)==2){if((g|0)>0)b=0;else break a;while(1){j=a[e+(b*3|0)+1>>0]|0;k=j&255;i=(d[e+(b*3|0)>>0]|0)+128+k|0;k=(d[e+(b*3|0)+2>>0]|0)+128+(((i&255)+k|0)>>>1)&255;h=f+(b*3|0)|0;a[h>>0]=i;a[h+1>>0]=j;a[h+2>>0]=k;b=b+1|0;if((b|0)==(g|0))break a}}b=(g|0)<(h|0)?g:h;if((b|0)>0){i=h<<1;j=0;do{n=a[e+(j+h)>>0]|0;m=n&255;o=(d[e+j>>0]|0)+128+m|0;m=(d[e+(j+i)>>0]|0)+128+(((o&255)+m|0)>>>1)&255;k=f+(j*3|0)|0;a[k>>0]=o;a[k+1>>0]=n;a[k+2>>0]=m;j=j+1|0}while((j|0)!=(b|0))}break}case 4:{if((c[b+24>>2]|0)==1?(k=(g|0)<(h|0)?g:h,(k|0)>0):0){b=h<<1;i=h*3|0;j=0;do{n=d[e+(j+h)>>0]|0;m=(d[e+j>>0]|0)+128+n&255;o=f+(j<<2)|0;n=m|n<<8|d[e+(j+i)>>0]<<24|(d[e+(j+b)>>0]|0)+128+((m+n|0)>>>1)<<16&16711680;a[o>>0]=n;a[o+1>>0]=n>>8;a[o+2>>0]=n>>16;a[o+3>>0]=n>>24;j=j+1|0}while((j|0)!=(k|0))}break}default:{}}while(0);b=c[l>>2]|0;if(!(a[b+32>>0]|0))return;j=c[b+16>>2]|0;if((g|0)>0){b=f;i=0}else return;while(1){o=b+2|0;n=a[b>>0]|0;a[b>>0]=a[o>>0]|0;a[o>>0]=n;i=i+1|0;if((i|0)==(g|0))break;else b=b+j|0}return}function Ve(a){a=a|0;var b=0,d=0;c[a>>2]=36688;b=c[a+20>>2]|0;if(b){d=a+24|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}d=c[a+8>>2]|0;if(!d)return;b=a+12|0;if((c[b>>2]|0)!=(d|0))c[b>>2]=d;cj(d);return}function We(a){a=a|0;var b=0,d=0;c[a>>2]=36688;b=c[a+20>>2]|0;if(b){d=a+24|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}b=c[a+8>>2]|0;if(!b){cj(a);return}d=a+12|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b);cj(a);return}function Xe(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0;g=b+36|0;if(!(c[g>>2]|0)){g=b+40|0;$e(b,d,c[g>>2]|0,e,f);c[g>>2]=(c[g>>2]|0)+(c[(c[b+4>>2]|0)+12>>2]|0);return}h=$(c[(c[b+4>>2]|0)+16>>2]|0,e)|0;i=b+20|0;$e(b,d,c[i>>2]|0,e,f);b=c[g>>2]|0;if((Gb[c[(c[b>>2]|0)+48>>2]&63](b,c[i>>2]|0,h)|0)==(h|0))return;g=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,g|0,3,35648);i=o;o=0;if(i&1){i=Na()|0;La(g|0);Ya(i|0)}else lb(g|0,824,96)}function Ye(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=c[a+36>>2]|0;if(!f){f=a+40|0;Ze(a,c[f>>2]|0,b,d,e);c[f>>2]=(c[f>>2]|0)+(c[(c[a+4>>2]|0)+12>>2]|0);return}else{_e(a,f,b,d,e);return}}function Ze(b,e,f,g,h){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0;k=b+4|0;i=c[k>>2]|0;if(!(a[i+32>>0]|0))k=e;else{j=b+8|0;lw(c[j>>2]|0,e|0,g*3|0)|0;i=c[k>>2]|0;e=c[i+16>>2]|0;if((g|0)>0){i=c[j>>2]|0;b=0;while(1){l=i+2|0;m=a[i>>0]|0;a[i>>0]=a[l>>0]|0;a[l>>0]=m;b=b+1|0;if((b|0)==(g|0))break;else i=i+e|0}i=c[k>>2]|0}k=c[j>>2]|0}switch(c[i+16>>2]|0){case 3:{if((c[i+24>>2]|0)==2){if((g|0)>0)i=0;else return;do{h=a[k+(i*3|0)+1>>0]|0;j=h&255;l=128-j+(d[k+(i*3|0)+2>>0]|0)&255;m=f+(i*3|0)|0;a[m>>0]=(d[k+(i*3|0)>>0]|0)+128-j;a[m+1>>0]=h;a[m+2>>0]=l;i=i+1|0}while((i|0)!=(g|0));return}i=(h|0)<(g|0)?h:g;if((i|0)<=0)return;b=h<<1;e=0;do{l=a[k+(e*3|0)+1>>0]|0;g=l&255;m=128-g+(d[k+(e*3|0)+2>>0]|0)&255;a[f+e>>0]=(d[k+(e*3|0)>>0]|0)+128-g;a[f+(e+h)>>0]=l;a[f+(e+b)>>0]=m;e=e+1|0}while((e|0)!=(i|0));return}case 4:{if((c[i+24>>2]|0)!=1)return;i=(h|0)<(g|0)?h:g;if((i|0)<=0)return;b=h<<1;e=h*3|0;j=0;do{g=a[k+(j<<2)+1>>0]|0;m=a[k+(j<<2)+3>>0]|0;n=g&255;l=128-n+(d[k+(j<<2)+2>>0]|0)&255;a[f+j>>0]=(d[k+(j<<2)>>0]|0)+128-n;a[f+(j+h)>>0]=g;a[f+(j+b)>>0]=l;a[f+(j+e)>>0]=m;j=j+1|0}while((j|0)!=(i|0));return}default:return}}function _e(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0;p=i;i=i+176|0;q=p+152|0;s=p+16|0;r=p;j=$(c[(c[b+4>>2]|0)+16>>2]|0,f)|0;l=b+20|0;h=c[l>>2]|0;if(!j){s=h;Ze(b,s,e,f,g);i=p;return}while(1){k=Gb[c[(c[d>>2]|0)+32>>2]&63](d,h,j)|0;if(!k)break;h=c[l>>2]|0;if((j|0)==(k|0)){m=26;break}else j=j-k|0}if((m|0)==26){Ze(b,h,e,f,g);i=p;return}e=s+56|0;l=s+4|0;c[s>>2]=36160;c[e>>2]=36180;o=0;ia(62,s+56|0,l|0);p=o;o=0;if(p&1){s=Na()|0;fn(e);Ya(s|0)}c[s+128>>2]=0;c[s+132>>2]=-1;c[s>>2]=36200;c[s+56>>2]=36220;o=0;ha(180,l|0);p=o;o=0;do if(p&1)h=Na()|0;else{c[l>>2]=36236;d=s+36|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[s+52>>2]=16;c[q>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;o=0;ia(63,l|0,q|0);p=o;o=0;if(p&1){h=Na()|0;Im(q);Im(d);nn(l);break}Im(q);o=0;h=ma(28,s|0,49029,57)|0;q=o;o=0;if(!(q&1)?(o=0,ra(36,h|0,0)|0,q=o,o=0,!(q&1)):0){k=Ma(16)|0;o=0;ia(64,r|0,l|0);q=o;o=0;if(!(q&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,k|0,3,35648,r|0);q=o;o=0;if(q&1)j=1;else{o=0;wa(6,k|0,824,96);o=0;j=0}h=Na()|0;Im(r);if(!j){r=h;c[s>>2]=36200;c[e>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(e);Ya(r|0)}}else h=Na()|0;La(k|0);r=h;c[s>>2]=36200;c[e>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(e);Ya(r|0)}r=Na()|0;c[s>>2]=36200;c[e>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(e);Ya(r|0)}while(0);s=h;fn(e);Ya(s|0)}function $e(b,e,f,g,h){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0;l=b+4|0;b=c[l>>2]|0;a:do switch(c[b+16>>2]|0){case 3:{if((c[b+24>>2]|0)==2){if((g|0)>0)b=0;else break a;while(1){j=a[e+(b*3|0)+1>>0]|0;i=j&255;k=i+128+(d[e+(b*3|0)+2>>0]|0)&255;h=f+(b*3|0)|0;a[h>>0]=(d[e+(b*3|0)>>0]|0)+128+i;a[h+1>>0]=j;a[h+2>>0]=k;b=b+1|0;if((b|0)==(g|0))break a}}b=(g|0)<(h|0)?g:h;if((b|0)>0){i=h<<1;j=0;do{n=a[e+(j+h)>>0]|0;o=n&255;m=o+128+(d[e+(j+i)>>0]|0)&255;k=f+(j*3|0)|0;a[k>>0]=(d[e+j>>0]|0)+128+o;a[k+1>>0]=n;a[k+2>>0]=m;j=j+1|0}while((j|0)!=(b|0))}break}case 4:{if((c[b+24>>2]|0)==1?(k=(g|0)<(h|0)?g:h,(k|0)>0):0){b=h<<1;i=h*3|0;j=0;do{n=d[e+(j+h)>>0]|0;o=f+(j<<2)|0;n=(d[e+j>>0]|0)+128+n&255|n<<8|d[e+(j+i)>>0]<<24|n+128+(d[e+(j+b)>>0]|0)<<16&16711680;a[o>>0]=n;a[o+1>>0]=n>>8;a[o+2>>0]=n>>16;a[o+3>>0]=n>>24;j=j+1|0}while((j|0)!=(k|0))}break}default:{}}while(0);b=c[l>>2]|0;if(!(a[b+32>>0]|0))return;j=c[b+16>>2]|0;if((g|0)>0){b=f;i=0}else return;while(1){o=b+2|0;n=a[b>>0]|0;a[b>>0]=a[o>>0]|0;a[o>>0]=n;i=i+1|0;if((i|0)==(g|0))break;else b=b+j|0}return}function af(a){a=a|0;var b=0,d=0;c[a>>2]=36712;b=c[a+20>>2]|0;if(b){d=a+24|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}d=c[a+8>>2]|0;if(!d)return;b=a+12|0;if((c[b>>2]|0)!=(d|0))c[b>>2]=d;cj(d);return}function bf(a){a=a|0;var b=0,d=0;c[a>>2]=36712;b=c[a+20>>2]|0;if(b){d=a+24|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}b=c[a+8>>2]|0;if(!b){cj(a);return}d=a+12|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b);cj(a);return}function cf(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0;g=b+36|0;if(!(c[g>>2]|0)){g=b+40|0;gf(b,d,c[g>>2]|0,e,f);c[g>>2]=(c[g>>2]|0)+(c[(c[b+4>>2]|0)+12>>2]|0);return}h=$(c[(c[b+4>>2]|0)+16>>2]|0,e)|0;i=b+20|0;gf(b,d,c[i>>2]|0,e,f);b=c[g>>2]|0;if((Gb[c[(c[b>>2]|0)+48>>2]&63](b,c[i>>2]|0,h)|0)==(h|0))return;g=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,g|0,3,35648);i=o;o=0;if(i&1){i=Na()|0;La(g|0);Ya(i|0)}else lb(g|0,824,96)}function df(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=c[a+36>>2]|0;if(!f){f=a+40|0;ef(a,c[f>>2]|0,b,d,e);c[f>>2]=(c[f>>2]|0)+(c[(c[a+4>>2]|0)+12>>2]|0);return}else{ff(a,f,b,d,e);return}}function ef(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0;j=b+4|0;h=c[j>>2]|0;if(!(a[h+32>>0]|0))j=d;else{i=b+8|0;lw(c[i>>2]|0,d|0,f*3|0)|0;h=c[j>>2]|0;d=c[h+16>>2]|0;if((f|0)>0){h=c[i>>2]|0;b=0;while(1){k=h+2|0;l=a[h>>0]|0;a[h>>0]=a[k>>0]|0;a[k>>0]=l;b=b+1|0;if((b|0)==(f|0))break;else h=h+d|0}h=c[j>>2]|0}j=c[i>>2]|0}switch(c[h+16>>2]|0){case 3:{if((c[h+24>>2]|0)==2){if((f|0)>0)h=0;else return;do{g=a[j+(h*3|0)+1>>0]|0;k=a[j+(h*3|0)+2>>0]|0;l=e+(h*3|0)|0;a[l>>0]=a[j+(h*3|0)>>0]|0;a[l+1>>0]=g;a[l+2>>0]=k;h=h+1|0}while((h|0)!=(f|0));return}h=(g|0)<(f|0)?g:f;if((h|0)<=0)return;b=g<<1;d=0;do{k=a[j+(d*3|0)+1>>0]|0;l=a[j+(d*3|0)+2>>0]|0;a[e+d>>0]=a[j+(d*3|0)>>0]|0;a[e+(d+g)>>0]=k;a[e+(d+b)>>0]=l;d=d+1|0}while((d|0)!=(h|0));return}case 4:{if((c[h+24>>2]|0)!=1)return;h=(g|0)<(f|0)?g:f;if((h|0)<=0)return;b=g<<1;d=g*3|0;i=0;do{f=a[j+(i<<2)+1>>0]|0;k=a[j+(i<<2)+2>>0]|0;l=a[j+(i<<2)+3>>0]|0;a[e+i>>0]=a[j+(i<<2)>>0]|0;a[e+(i+g)>>0]=f;a[e+(i+b)>>0]=k;a[e+(i+d)>>0]=l;i=i+1|0}while((i|0)!=(h|0));return}default:return}}function ff(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0;p=i;i=i+176|0;q=p+152|0;s=p+16|0;r=p;j=$(c[(c[b+4>>2]|0)+16>>2]|0,f)|0;l=b+20|0;h=c[l>>2]|0;if(!j){s=h;ef(b,s,e,f,g);i=p;return}while(1){k=Gb[c[(c[d>>2]|0)+32>>2]&63](d,h,j)|0;if(!k)break;h=c[l>>2]|0;if((j|0)==(k|0)){m=26;break}else j=j-k|0}if((m|0)==26){ef(b,h,e,f,g);i=p;return}e=s+56|0;l=s+4|0;c[s>>2]=36160;c[e>>2]=36180;o=0;ia(62,s+56|0,l|0);p=o;o=0;if(p&1){s=Na()|0;fn(e);Ya(s|0)}c[s+128>>2]=0;c[s+132>>2]=-1;c[s>>2]=36200;c[s+56>>2]=36220;o=0;ha(180,l|0);p=o;o=0;do if(p&1)h=Na()|0;else{c[l>>2]=36236;d=s+36|0;c[d>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[s+52>>2]=16;c[q>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;o=0;ia(63,l|0,q|0);p=o;o=0;if(p&1){h=Na()|0;Im(q);Im(d);nn(l);break}Im(q);o=0;h=ma(28,s|0,49029,57)|0;q=o;o=0;if(!(q&1)?(o=0,ra(36,h|0,0)|0,q=o,o=0,!(q&1)):0){k=Ma(16)|0;o=0;ia(64,r|0,l|0);q=o;o=0;if(!(q&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,k|0,3,35648,r|0);q=o;o=0;if(q&1)j=1;else{o=0;wa(6,k|0,824,96);o=0;j=0}h=Na()|0;Im(r);if(!j){r=h;c[s>>2]=36200;c[e>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(e);Ya(r|0)}}else h=Na()|0;La(k|0);r=h;c[s>>2]=36200;c[e>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(e);Ya(r|0)}r=Na()|0;c[s>>2]=36200;c[e>>2]=36220;c[l>>2]=36236;Im(d);nn(l);fn(e);Ya(r|0)}while(0);s=h;fn(e);Ya(s|0)}function gf(b,e,f,g,h){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0;l=b+4|0;b=c[l>>2]|0;a:do switch(c[b+16>>2]|0){case 3:{if((c[b+24>>2]|0)==2){if((g|0)>0)b=0;else break a;while(1){j=a[e+(b*3|0)+1>>0]|0;k=a[e+(b*3|0)+2>>0]|0;h=f+(b*3|0)|0;a[h>>0]=a[e+(b*3|0)>>0]|0;a[h+1>>0]=j;a[h+2>>0]=k;b=b+1|0;if((b|0)==(g|0))break a}}b=(g|0)<(h|0)?g:h;if((b|0)>0){i=h<<1;j=0;do{n=a[e+(j+h)>>0]|0;m=a[e+(j+i)>>0]|0;k=f+(j*3|0)|0;a[k>>0]=a[e+j>>0]|0;a[k+1>>0]=n;a[k+2>>0]=m;j=j+1|0}while((j|0)!=(b|0))}break}case 4:{if((c[b+24>>2]|0)==1?(k=(g|0)<(h|0)?g:h,(k|0)>0):0){b=h<<1;i=h*3|0;j=0;do{n=f+(j<<2)|0;m=d[e+(j+h)>>0]<<8|d[e+j>>0]|d[e+(j+b)>>0]<<16|d[e+(j+i)>>0]<<24;a[n>>0]=m;a[n+1>>0]=m>>8;a[n+2>>0]=m>>16;a[n+3>>0]=m>>24;j=j+1|0}while((j|0)!=(k|0))}break}default:{}}while(0);b=c[l>>2]|0;if(!(a[b+32>>0]|0))return;j=c[b+16>>2]|0;if((g|0)>0){b=f;i=0}else return;while(1){n=b+2|0;m=a[b>>0]|0;a[b>>0]=a[n>>0]|0;a[n>>0]=m;i=i+1|0;if((i|0)==(g|0))break;else b=b+j|0}return}function hf(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;u=i;i=i+32|0;w=u+12|0;t=u;q=b+180|0;r=(c[q>>2]|0)+4|0;if((c[b+32>>2]|0)==1)s=c[b+24>>2]|0;else s=1;d=$(s<<1,r)|0;c[w>>2]=0;x=w+4|0;c[x>>2]=0;c[w+8>>2]=0;a:do if(d){if(!(d>>>0>1431655765?(o=0,ha(178,w|0),v=o,o=0,v&1):0))h=6;if((h|0)==6?(o=0,e=ka(67,d*3|0)|0,v=o,o=0,!(v&1)):0){c[x>>2]=e;c[w>>2]=e;c[w+8>>2]=e+(d*3|0);while(1){a[e>>0]=0;a[e+1>>0]=0;a[e+2>>0]=0;e=(c[x>>2]|0)+3|0;c[x>>2]=e;d=d+-1|0;if(!d)break a}}f=Na()|0;d=c[w>>2]|0;if(!d)Ya(f|0);e=c[x>>2]|0;if((e|0)!=(d|0))c[x>>2]=e+(~(((e+-3-d|0)>>>0)/3|0)*3|0);cj(d);Ya(f|0)}while(0);c[t>>2]=0;v=t+4|0;c[v>>2]=0;c[t+8>>2]=0;do if(!s)h=19;else{if(!(s>>>0>1073741823?(o=0,ha(178,t|0),p=o,o=0,p&1):0))h=17;if((h|0)==17?(f=s<<2,o=0,g=ka(67,f|0)|0,p=o,o=0,!(p&1)):0){c[t>>2]=g;h=g+(s<<2)|0;c[t+8>>2]=h;iw(g|0,0,f|0)|0;c[v>>2]=h;h=19;break}f=Na()|0;d=c[t>>2]|0;e=d;if(d){g=c[v>>2]|0;if((g|0)!=(d|0))c[v>>2]=g+(~((g+-4-e|0)>>>2)<<2);cj(d)}}while(0);if((h|0)==19){g=b+12|0;b:do if((c[g>>2]|0)>0){h=b+4604|0;j=($(s,r)|0)+1|0;k=b+4608|0;l=b+92|0;m=(s|0)>0;n=b+4600|0;p=0;c:while(1){f=c[w>>2]|0;d=f+3|0;c[h>>2]=d;e=f+(j*3|0)|0;c[k>>2]=e;if(!(p&1))d=j;else{c[h>>2]=e;c[k>>2]=d;d=1}e=c[l>>2]|0;o=0;Aa(c[(c[e>>2]|0)+12>>2]|0,e|0,f+(d*3|0)|0,c[q>>2]|0,r|0);f=o;o=0;if(f&1){h=29;break}if(m){d=c[t>>2]|0;e=c[h>>2]|0;f=0;do{c[n>>2]=c[d+(f<<2)>>2];y=c[q>>2]|0;d=e+(y*3|0)|0;e=e+((y+-1|0)*3|0)|0;a[d>>0]=a[e>>0]|0;a[d+1>>0]=a[e+1>>0]|0;a[d+2>>0]=a[e+2>>0]|0;d=c[h>>2]|0;e=(c[k>>2]|0)+-3|0;a[e>>0]=a[d>>0]|0;a[e+1>>0]=a[d+1>>0]|0;a[e+2>>0]=a[d+2>>0]|0;o=0;ia(70,b|0,0);e=o;o=0;if(e&1){h=28;break c}d=c[t>>2]|0;c[d+(f<<2)>>2]=c[n>>2];e=(c[h>>2]|0)+(r*3|0)|0;c[h>>2]=e;c[k>>2]=(c[k>>2]|0)+(r*3|0);f=f+1|0}while((f|0)<(s|0))}p=p+1|0;if((p|0)>=(c[g>>2]|0)){h=41;break b}}if((h|0)==28){f=Na()|0;break}else if((h|0)==29){f=Na()|0;break}}else h=41;while(0);do if((h|0)==41){o=0;ha(182,b|0);y=o;o=0;if(y&1){f=Na()|0;break}d=c[t>>2]|0;e=d;if(d){f=c[v>>2]|0;if((f|0)!=(d|0))c[v>>2]=f+(~((f+-4-e|0)>>>2)<<2);cj(d)}d=c[w>>2]|0;if(!d){i=u;return}e=c[x>>2]|0;if((e|0)!=(d|0))c[x>>2]=e+(~(((e+-3-d|0)>>>0)/3|0)*3|0);cj(d);i=u;return}while(0);d=c[t>>2]|0;e=d;if(d){g=c[v>>2]|0;if((g|0)!=(d|0))c[v>>2]=g+(~((g+-4-e|0)>>>2)<<2);cj(d)}}d=c[w>>2]|0;if(!d)Ya(f|0);e=c[x>>2]|0;if((e|0)!=(d|0))c[x>>2]=e+(~(((e+-3-d|0)>>>0)/3|0)*3|0);cj(d);Ya(f|0)}function jf(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;A=b+180|0;if((c[A>>2]|0)<=0)return;B=b+4608|0;C=b+4604|0;D=b+4612|0;z=0;while(1){w=z+-1|0;i=c[B>>2]|0;j=c[C>>2]|0;e=z+1|0;h=d[j+(z*3|0)>>0]|0;y=c[D>>2]|0;k=d[j+(w*3|0)>>0]|0;l=h-k|0;m=d[i+(w*3|0)>>0]|0;n=k-m|0;o=((((a[y+((d[j+(e*3|0)>>0]|0)-h)>>0]|0)*9|0)+(a[y+l>>0]|0)|0)*9|0)+(a[y+n>>0]|0)|0;g=d[j+(z*3|0)+1>>0]|0;p=d[j+(w*3|0)+1>>0]|0;q=g-p|0;r=d[i+(w*3|0)+1>>0]|0;s=p-r|0;t=((((a[y+((d[j+(e*3|0)+1>>0]|0)-g)>>0]|0)*9|0)+(a[y+q>>0]|0)|0)*9|0)+(a[y+s>>0]|0)|0;f=d[j+(z*3|0)+2>>0]|0;u=d[j+(w*3|0)+2>>0]|0;v=f-u|0;w=d[i+(w*3|0)+2>>0]|0;x=u-w|0;y=((((a[y+((d[j+(e*3|0)+2>>0]|0)-f)>>0]|0)*9|0)+(a[y+v>>0]|0)|0)*9|0)+(a[y+x>>0]|0)|0;if(!(t|o|y))e=(kf(b,z,0)|0)+z|0;else{j=d[i+(z*3|0)>>0]|0;i=h-m>>31;if((i^n|0)>=0)if((i^l|0)<0)h=m;else h=m-k+h|0;j=lf(b,o,j,h,0)|0;i=d[(c[B>>2]|0)+(z*3|0)+1>>0]|0;h=g-r>>31;if((h^s|0)>=0)if((h^q|0)<0)g=r;else g=r-p+g|0;h=lf(b,t,i,g,0)|0;i=d[(c[B>>2]|0)+(z*3|0)+2>>0]|0;g=f-w>>31;if((g^x|0)>=0)if((g^v|0)<0)f=w;else f=w-u+f|0;y=lf(b,y,i,f,0)|0;z=(c[B>>2]|0)+(z*3|0)|0;a[z>>0]=j;a[z+1>>0]=h;a[z+2>>0]=y}if((e|0)<(c[A>>2]|0))z=e;else break}return}function kf(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;B=i;i=i+32|0;A=B+15|0;q=B+12|0;p=B+9|0;r=B+6|0;w=B+3|0;x=B;y=(c[b+180>>2]|0)-e|0;z=c[b+4608>>2]|0;s=c[b+4604>>2]|0;v=z+((e+-1|0)*3|0)|0;t=a[v>>0]|0;u=a[v+1>>0]|0;v=a[v+2>>0]|0;f=t&255;g=b+144|0;h=u&255;j=v&255;o=0;while(1){k=z+((o+e|0)*3|0)|0;l=k+1|0;m=k+2|0;C=(d[k>>0]|0)-f|0;n=c[g>>2]|0;if((((C|0)>-1?C:0-C|0)|0)>(n|0))break;C=(d[l>>0]|0)-h|0;if((((C|0)>-1?C:0-C|0)|0)>(n|0))break;C=(d[m>>0]|0)-j|0;if((((C|0)>-1?C:0-C|0)|0)>(n|0))break;a[k>>0]=t;a[l>>0]=u;a[m>>0]=v;o=o+1|0;if((o|0)==(y|0)){o=y;break}}h=(o|0)==(y|0);j=b+4600|0;g=c[36476+(c[j>>2]<<2)>>2]|0;if((1<<g|0)>(o|0))f=o;else{f=o;do{ae(b,1,1);g=c[j>>2]|0;f=f-(1<<c[36476+(g<<2)>>2])|0;g=(g|0)>30?31:g+1|0;c[j>>2]=g;g=c[36476+(g<<2)>>2]|0}while((f|0)>=(1<<g|0))}if(!h){ae(b,f,g+1|0);e=o+e|0;C=z+(e*3|0)|0;a[w>>0]=a[C>>0]|0;a[w+1>>0]=a[C+1>>0]|0;a[w+2>>0]=a[C+2>>0]|0;a[x>>0]=t;a[x+1>>0]=u;a[x+2>>0]=v;e=s+(e*3|0)|0;a[p>>0]=a[w>>0]|0;a[p+1>>0]=a[w+1>>0]|0;a[p+2>>0]=a[w+2>>0]|0;a[q>>0]=a[x>>0]|0;a[q+1>>0]=a[x+1>>0]|0;a[q+2>>0]=a[x+2>>0]|0;a[A>>0]=a[e>>0]|0;a[A+1>>0]=a[e+1>>0]|0;a[A+2>>0]=a[e+2>>0]|0;nf(r,b,p,q,A);a[C>>0]=a[r>>0]|0;a[C+1>>0]=a[r+1>>0]|0;a[C+2>>0]=a[r+2>>0]|0;C=c[j>>2]|0;c[j>>2]=(C|0)<1?0:C+-1|0;C=o+1|0;i=B;return C|0}if(!f){C=y;i=B;return C|0}ae(b,1,1);C=y;i=B;return C|0}function lf(a,d,e,f,g){a=a|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=d>>31;h=(r^d)-r|0;p=a+196+(h*12|0)+10|0;i=b[p>>1]|0;o=a+196+(h*12|0)|0;g=c[o>>2]|0;if((i|0)<(g|0))if((i<<1|0)<(g|0))if((i<<2|0)<(g|0))if((i<<3|0)<(g|0))if((i<<4|0)<(g|0)){d=5;while(1)if((i<<d|0)<(g|0))d=d+1|0;else break}else d=4;else d=3;else d=2;else d=1;else d=0;m=a+196+(h*12|0)+8|0;g=(b[m>>1]^r)-r+f|0;q=a+136|0;f=c[q>>2]|0;if((g&f|0)==(g|0))l=g;else l=f&~(g>>31);g=(e-l^r)-r|0;k=a+144|0;f=c[k>>2]|0;if((g|0)>0)g=(g+f|0)/(f<<1|1|0)|0;else g=(g-f|0)/(f<<1|1|0)|0;n=a+140|0;j=c[n>>2]|0;e=((g|0)<0?j:0)+g|0;j=e-((e|0)<((j+1|0)/2|0|0)?0:j)|0;h=a+196+(h*12|0)+4|0;if(!(f|d))g=(c[h>>2]<<1)+-1+i>>31;else g=0;f=g^j;mf(a,d,f>>30^f<<1,c[a+156>>2]|0);f=c[a+160>>2]|0;d=(c[o>>2]|0)+((j|0)>-1?j:0-j|0)|0;g=(c[h>>2]|0)+($(c[k>>2]<<1|1,j)|0)|0;e=b[p>>1]|0;if((e|0)==(f|0)){d=d>>1;g=g>>1;e=f>>1}c[o>>2]=d;f=e+1|0;b[p>>1]=f;d=f+g|0;if((d|0)>=1){if((g|0)>0){g=g-f|0;p=b[m>>1]|0;b[m>>1]=(p<<16>>16<127&1)+(p&65535);g=(g|0)>0?0:g}}else{g=b[m>>1]|0;b[m>>1]=(g&65535)-(g<<16>>16>-128&1);g=(d|0)>(~e|0)?d:0-e|0}c[h>>2]=g;f=c[k>>2]|0;e=f<<1|1;d=($(e,(j^r)-r|0)|0)+l|0;if((d|0)>=(0-f|0)){g=c[q>>2]|0;if((g+f|0)<(d|0))d=d-($(c[n>>2]|0,e)|0)|0}else{d=($(c[n>>2]|0,e)|0)+d|0;g=c[q>>2]|0}if((d&g|0)==(d|0)){r=d;r=r&255;return r|0}r=g&~(d>>31);r=r&255;return r|0}function mf(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=d>>b;g=a+148|0;h=e-(c[g>>2]|0)|0;if((f|0)<(h+-1|0)){if((f|0)>30){e=(f|0)/2|0;ae(a,0,e);f=f-e|0}ae(a,1,f+1|0);ae(a,(1<<b)+-1&d,b);return}if((h|0)>31){ae(a,0,31);ae(a,1,e+-31-(c[g>>2]|0)|0)}else ae(a,1,h);b=c[g>>2]|0;ae(a,(1<<b)+-1&d+-1,b);return}function nf(b,e,f,g,h){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;r=e+136|0;o=d[h>>0]|0;p=o-(d[g>>0]|0)>>31|1;i=$(p,(d[f>>0]|0)-o|0)|0;m=e+144|0;j=c[m>>2]|0;if((i|0)>0)i=(i+j|0)/(j<<1|1|0)|0;else i=(i-j|0)/(j<<1|1|0)|0;w=e+140|0;l=c[w>>2]|0;k=((i|0)<0?l:0)+i|0;l=k-((k|0)<((l+1|0)/2|0|0)?0:l)|0;k=e+4576|0;of(e,k,l);t=d[h+1>>0]|0;u=t-(d[g+1>>0]|0)>>31|1;i=$(u,(d[f+1>>0]|0)-t|0)|0;j=c[m>>2]|0;if((i|0)>0)i=(i+j|0)/(j<<1|1|0)|0;else i=(i-j|0)/(j<<1|1|0)|0;q=c[w>>2]|0;v=((i|0)<0?q:0)+i|0;q=v-((v|0)<((q+1|0)/2|0|0)?0:q)|0;of(e,k,q);v=d[h+2>>0]|0;s=v-(d[g+2>>0]|0)>>31|1;i=$(s,(d[f+2>>0]|0)-v|0)|0;j=c[m>>2]|0;if((i|0)>0)i=(i+j|0)/(j<<1|1|0)|0;else i=(i-j|0)/(j<<1|1|0)|0;n=c[w>>2]|0;i=((i|0)<0?n:0)+i|0;n=i-((i|0)<((n+1|0)/2|0|0)?0:n)|0;of(e,k,n);k=c[m>>2]|0;m=k<<1|1;i=($($(m,l)|0,p)|0)+o|0;f=0-k|0;if((i|0)>=(f|0)){j=c[r>>2]|0;if((j+k|0)<(i|0)){i=i-($(c[w>>2]|0,m)|0)|0;g=j}else g=j}else{i=($(c[w>>2]|0,m)|0)+i|0;g=c[r>>2]|0}if((i&g|0)!=(i|0))i=g&~(i>>31);h=i&255;i=($($(m,q)|0,u)|0)+t|0;if((i|0)>=(f|0)){if((g+k|0)<(i|0))i=i-($(c[w>>2]|0,m)|0)|0}else i=($(c[w>>2]|0,m)|0)+i|0;if((i&g|0)!=(i|0))i=g&~(i>>31);j=i&255;i=($($(m,n)|0,s)|0)+v|0;if((i|0)>=(f|0)){if((g+k|0)<(i|0))i=i-($(c[w>>2]|0,m)|0)|0}else i=($(c[w>>2]|0,m)|0)+i|0;if((i&g|0)==(i|0)){w=i;w=w&255;a[b>>0]=h;v=b+1|0;a[v>>0]=j;b=b+2|0;a[b>>0]=w;return}w=g&~(i>>31);w=w&255;a[b>>0]=h;v=b+1|0;a[v>>0]=j;b=b+2|0;a[b>>0]=w;return}function of(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=e+9|0;j=d[n>>0]|0;m=e+4|0;l=c[m>>2]|0;h=($(j>>>1,l)|0)+(c[e>>2]|0)|0;if((j|0)<(h|0)){i=j;g=0;do{i=i<<1;g=g+1|0}while((i|0)<(h|0));h=g}else h=0;if((f|0)>0&(h|0)==0?d[e+10>>0]<<1>>>0<j>>>0:0)g=1;else k=5;do if((k|0)==5){g=(f|0)<0;if(g?d[e+10>>0]<<1>>>0>=j>>>0:0){g=1;break}g=g&(h|0)!=0}while(0);g=(((f|0)>-1?f:0-f|0)<<1)-l+(g<<31>>31)|0;mf(b,h,g,(c[b+156>>2]|0)+-1-(c[36476+(c[b+4600>>2]<<2)>>2]|0)|0);if((f|0)<0){b=e+10|0;a[b>>0]=(d[b>>0]|0)+1}g=(g+1-(c[m>>2]|0)>>1)+(c[e>>2]|0)|0;c[e>>2]=g;h=a[n>>0]|0;if(h<<24>>24!=(a[e+8>>0]|0)){e=h;e=e&255;e=e+1|0;e=e&255;a[n>>0]=e;return}c[e>>2]=g>>1;b=(h&255)>>>1;a[n>>0]=b;e=e+10|0;a[e>>0]=(d[e>>0]|0)>>>1;e=b;e=e&255;e=e+1|0;e=e&255;a[n>>0]=e;return}function pf(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=i;i=i+32|0;f=p;o=b+144|0;a:do if(!(c[o>>2]|0)){e=c[b+136>>2]|0;d=b+152|0;if((((e|0)==((1<<c[d>>2])+-1|0)?(Ei(f,e,0),(c[f+4>>2]|0)==(c[b+184>>2]|0)):0)?(c[f+8>>2]|0)==(c[b+188>>2]|0):0)?(c[f+12>>2]|0)==(c[b+192>>2]|0):0)switch(c[d>>2]|0){case 8:{o=c[8900]|0;c[b+4612>>2]=o+(((c[8901]|0)-o|0)>>>1);i=p;return}case 10:{o=c[8903]|0;c[b+4612>>2]=o+(((c[8904]|0)-o|0)>>>1);i=p;return}case 12:{o=c[8906]|0;c[b+4612>>2]=o+(((c[8907]|0)-o|0)>>>1);i=p;return}case 16:{o=c[8909]|0;c[b+4612>>2]=o+(((c[8910]|0)-o|0)>>>1);i=p;return}default:break a}}else d=b+152|0;while(0);n=1<<c[d>>2];e=b+4616|0;f=n<<1;g=b+4620|0;h=c[g>>2]|0;d=c[e>>2]|0;j=h-d|0;if(f>>>0<=j>>>0){if(f>>>0<j>>>0?(k=d+f|0,(h|0)!=(k|0)):0)c[g>>2]=k}else{ie(e,f-j|0);d=c[e>>2]|0}m=b+4612|0;c[m>>2]=d+n;d=0-n|0;if((n|0)<=(d|0)){i=p;return}k=b+192|0;l=b+188|0;j=b+184|0;h=d;do{d=c[k>>2]|0;if((h|0)>(0-d|0)){e=c[l>>2]|0;if((h|0)>(0-e|0)){f=c[j>>2]|0;if((h|0)>(0-f|0)){g=c[o>>2]|0;if((h|0)>=(0-g|0))if((g|0)<(h|0))if((f|0)<=(h|0))if((e|0)>(h|0))d=2;else d=(d|0)>(h|0)?3:4;else d=1;else d=0;else d=-1}else d=-2}else d=-3}else d=-4;a[(c[m>>2]|0)+h>>0]=d;h=h+1|0}while((h|0)!=(n|0));i=p;return}function qf(a){a=a|0;var b=0,d=0;c[a>>2]=35996;b=c[a+4592>>2]|0;if(b){d=a+4596|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}c[a>>2]=36612;b=c[a+120>>2]|0;if(b){d=a+124|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}d=a+92|0;b=c[d>>2]|0;c[d>>2]=0;if(b)Bb[c[(c[b>>2]|0)+4>>2]&255](b);a=a+4|0;b=c[a>>2]|0;c[a>>2]=0;if(!b)return;Bb[c[(c[b>>2]|0)+4>>2]&255](b);return}function rf(a){a=a|0;var b=0,d=0;c[a>>2]=35996;b=c[a+4592>>2]|0;if(b){d=a+4596|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}c[a>>2]=36612;b=c[a+120>>2]|0;if(b){d=a+124|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}d=a+92|0;b=c[d>>2]|0;c[d>>2]=0;if(b)Bb[c[(c[b>>2]|0)+4>>2]&255](b);d=a+4|0;b=c[d>>2]|0;c[d>>2]=0;if(!b){cj(a);return}Bb[c[(c[b>>2]|0)+4>>2]&255](b);cj(a);return}function sf(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;h=i;i=i+32|0;l=h;Ei(l,65535,0);k=c[e+4>>2]|0;j=c[e+8>>2]|0;j=(j|0)==0?c[l+8>>2]|0:j;g=c[e+12>>2]|0;g=(g|0)==0?c[l+12>>2]|0:g;e=c[e+16>>2]|0;f=c[l+16>>2]|0;c[d+160>>2]=(k|0)==0?c[l+4>>2]|0:k;c[d+164>>2]=j;c[d+168>>2]=g;Bf(d);g=0;do{c[d+172+(g*12|0)>>2]=1024;c[d+172+(g*12|0)+4>>2]=0;b[d+172+(g*12|0)+8>>1]=0;b[d+172+(g*12|0)+10>>1]=1;g=g+1|0}while((g|0)!=365);l=((e|0)==0?f:e)&255;c[d+4552>>2]=1024;c[d+4556>>2]=0;a[d+4560>>0]=l;a[d+4561>>0]=1;a[d+4562>>0]=0;c[d+4564>>2]=1024;c[d+4568>>2]=1;a[d+4572>>0]=l;a[d+4573>>0]=1;a[d+4574>>0]=0;c[d+4576>>2]=0;i=h;return}function tf(d,e,f,g){d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0;o=i;i=i+16|0;m=o;l=d+92|0;k=c[e>>2]|0;c[e>>2]=0;e=c[l>>2]|0;c[l>>2]=k;if(e)Bb[c[(c[e>>2]|0)+4>>2]&255](e);c[m>>2]=0;c[m+4>>2]=g;l=f+8|0;c[m+8>>2]=c[l>>2];if(g){e=bj(4600)|0;g=d+8|0;h=e+4|0;j=g;k=h+84|0;do{c[h>>2]=c[j>>2];h=h+4|0;j=j+4|0}while((h|0)<(k|0));h=e+88|0;k=h+40|0;do{c[h>>2]=0;h=h+4|0}while((h|0)<(k|0));c[e>>2]=35772;h=e+132|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[e+148>>2]=c[g>>2];c[e+152>>2]=0;c[e+156>>2]=0;c[e+160>>2]=0;h=e+4544|0;g=e+164|0;do{c[g>>2]=0;c[g+4>>2]=0;b[g+8>>1]=0;b[g+10>>1]=1;g=g+12|0}while((g|0)!=(h|0));j=d+4|0;c[h>>2]=0;c[h+4>>2]=0;b[h+8>>1]=0;a[h+10>>0]=0;k=e+4556|0;c[k>>2]=0;c[k+4>>2]=0;b[k+8>>1]=0;a[k+10>>0]=0;k=e+4568|0;c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;c[k+20>>2]=0;c[k+24>>2]=0;a[k+28>>0]=0;if(!(c[e+28>>2]|0))c[e+20>>2]=1;g=c[j>>2]|0;c[j>>2]=e;if(g){Bb[c[(c[g>>2]|0)+4>>2]&255](g);e=c[j>>2]|0}Wd(e,m)}m=d+100|0;c[m>>2]=32;c[d+96>>2]=0;e=c[f>>2]|0;if(!e){c[d+108>>2]=c[f+4>>2];c[d+104>>2]=c[l>>2];vf(d);n=d+116|0;n=c[n>>2]|0;d=c[m>>2]|0;d=d+-32|0;d=(d|0)/8|0;d=n-d|0;i=o;return d|0}c[d+132>>2]=e;h=d+120|0;l=d+124|0;g=c[l>>2]|0;e=c[h>>2]|0;j=e;k=g-j|0;if(k>>>0>=4e3){if(k>>>0>4e3?(n=e+4e3|0,(g|0)!=(n|0)):0){c[l>>2]=n;g=n}}else{Xd(h,4e3-k|0);e=c[h>>2]|0;j=e;g=c[l>>2]|0}c[d+108>>2]=j;c[d+104>>2]=g-e;vf(d);n=d+116|0;n=c[n>>2]|0;d=c[m>>2]|0;d=d+-32|0;d=(d|0)/8|0;d=n-d|0;i=o;return d|0}function uf(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;w=i;i=i+352|0;x=w+328|0;y=w+192|0;e=w+343|0;f=w+342|0;g=w+341|0;h=w+340|0;r=w+176|0;k=w+168|0;l=w+160|0;m=w+152|0;v=w;t=w+136|0;if((c[b+32>>2]|0)!=0?(c[b+24>>2]|0)!=1:0){s=b+8|0;u=b+36|0;j=c[u>>2]|0;if(!j){b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[e>>0]|0;Aa(37,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}b=c[b+16>>2]|0;if((b|0)==16)switch(j|0){case 1:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[f>>0]|0;Aa(38,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 2:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[g>>0]|0;Aa(39,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 3:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[h>>0]|0;Aa(40,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}default:{j=y+56|0;g=y+4|0;c[y>>2]=36160;c[j>>2]=36180;o=0;ia(62,y+56|0,g|0);w=o;o=0;if(w&1){z=Na()|0;fn(j);Ya(z|0)}c[y+128>>2]=0;c[y+132>>2]=-1;c[y>>2]=36200;c[y+56>>2]=36220;o=0;ha(180,g|0);w=o;o=0;do if(w&1)b=Na()|0;else{c[g>>2]=36236;h=y+36|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[y+52>>2]=16;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;o=0;ia(63,g|0,x|0);w=o;o=0;if(w&1){b=Na()|0;Im(x);Im(h);nn(g);break}Im(x);o=0;b=ma(28,y|0,49007,21)|0;x=o;o=0;do if((!(x&1)?(o=0,p=ra(36,b|0,c[u>>2]|0)|0,x=o,o=0,!(x&1)):0)?(o=0,ma(28,p|0,50997,18)|0,x=o,o=0,!(x&1)):0){f=Ma(16)|0;o=0;ia(64,r|0,g|0);x=o;o=0;if(!(x&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,f|0,9,35648,r|0);x=o;o=0;if(x&1)e=1;else{o=0;wa(6,f|0,824,96);o=0;e=0}b=Na()|0;Im(r);if(!e)break}else b=Na()|0;La(f|0)}else z=34;while(0);if((z|0)==34)b=Na()|0;c[y>>2]=36200;c[j>>2]=36220;c[g>>2]=36236;Im(h);nn(g);fn(j);z=b;Ya(z|0)}while(0);z=b;fn(j);Ya(z|0)}}if((b|0)<=8){b=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,b|0,8,35648);z=o;o=0;if(!(z&1))lb(b|0,824,96);z=Na()|0;La(b|0);Ya(z|0)}e=16-b|0;switch(j|0){case 1:{b=bj(60)|0;c[k>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[k>>2];c[x+4>>2]=c[k+4>>2];Aa(41,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 2:{b=bj(60)|0;c[l>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[l>>2];c[x+4>>2]=c[l+4>>2];Aa(42,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 3:{b=bj(60)|0;c[m>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[m>>2];c[x+4>>2]=c[m+4>>2];Aa(43,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}default:{j=v+56|0;g=v+4|0;c[v>>2]=36160;c[j>>2]=36180;o=0;ia(62,v+56|0,g|0);y=o;o=0;if(y&1){z=Na()|0;fn(j);Ya(z|0)}c[v+128>>2]=0;c[v+132>>2]=-1;c[v>>2]=36200;c[v+56>>2]=36220;o=0;ha(180,g|0);y=o;o=0;do if(y&1)b=Na()|0;else{c[g>>2]=36236;h=v+36|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[v+52>>2]=16;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;o=0;ia(63,g|0,x|0);y=o;o=0;if(y&1){b=Na()|0;Im(x);Im(h);nn(g);break}Im(x);o=0;b=ma(28,v|0,49007,21)|0;y=o;o=0;do if((!(y&1)?(o=0,q=ra(36,b|0,c[u>>2]|0)|0,y=o,o=0,!(y&1)):0)?(o=0,ma(28,q|0,50997,18)|0,y=o,o=0,!(y&1)):0){f=Ma(16)|0;o=0;ia(64,t|0,g|0);y=o;o=0;if(!(y&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,f|0,9,35648,t|0);y=o;o=0;if(y&1)e=1;else{o=0;wa(6,f|0,824,96);o=0;e=0}b=Na()|0;Im(t);if(!e)break}else b=Na()|0;La(f|0)}else z=64;while(0);if((z|0)==64)b=Na()|0;c[v>>2]=36200;c[j>>2]=36220;c[g>>2]=36236;Im(h);nn(g);fn(j);z=b;Ya(z|0)}while(0);z=b;fn(j);Ya(z|0)}}}e=c[d+4>>2]|0;f=bj(16)|0;b=c[b+20>>2]|0;if(!e){z=c[d>>2]|0;c[f>>2]=36132;c[f+4>>2]=z;c[f+8>>2]=2;c[f+12>>2]=b;z=f;i=w;return z|0}else{c[f>>2]=36108;c[f+4>>2]=e;c[f+8>>2]=2;c[f+12>>2]=b;z=f;i=w;return z|0}return 0}function vf(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;v=i;i=i+32|0;x=v+12|0;u=v;r=a+156|0;s=(c[r>>2]|0)+4|0;if((c[a+32>>2]|0)==1)t=c[a+24>>2]|0;else t=1;d=$(t<<1,s)|0;c[x>>2]=0;y=x+4|0;c[y>>2]=0;c[x+8>>2]=0;do if(d){if(!((d|0)<0?(o=0,ha(178,x|0),w=o,o=0,w&1):0))j=6;if((j|0)==6?(e=d<<1,o=0,f=ka(67,e|0)|0,w=o,o=0,!(w&1)):0){c[x>>2]=f;w=f+(d<<1)|0;c[x+8>>2]=w;iw(f|0,0,e|0)|0;c[y>>2]=w;break}f=Na()|0;d=c[x>>2]|0;if(!d)Ya(f|0);e=c[y>>2]|0;if((e|0)!=(d|0))c[y>>2]=e+(~((e+-2-d|0)>>>1)<<1);cj(d);Ya(f|0)}while(0);c[u>>2]=0;w=u+4|0;c[w>>2]=0;c[u+8>>2]=0;do if(!t)j=18;else{if(!(t>>>0>1073741823?(o=0,ha(178,u|0),q=o,o=0,q&1):0))j=16;if((j|0)==16?(g=t<<2,o=0,h=ka(67,g|0)|0,q=o,o=0,!(q&1)):0){c[u>>2]=h;j=h+(t<<2)|0;c[u+8>>2]=j;iw(h|0,0,g|0)|0;c[w>>2]=j;j=18;break}f=Na()|0;d=c[u>>2]|0;e=d;if(d){g=c[w>>2]|0;if((g|0)!=(d|0))c[w>>2]=g+(~((g+-4-e|0)>>>2)<<2);cj(d)}}while(0);if((j|0)==18){h=a+12|0;a:do if((c[h>>2]|0)>0){j=a+4580|0;k=($(t,s)|0)+1|0;l=a+4584|0;m=a+92|0;n=(t|0)>0;p=a+4576|0;q=0;b:while(1){e=c[x>>2]|0;d=e+2|0;c[j>>2]=d;e=e+(k<<1)|0;c[l>>2]=e;if(!(q&1))d=e;else{c[j>>2]=e;c[l>>2]=d}g=c[m>>2]|0;o=0;Aa(c[(c[g>>2]|0)+12>>2]|0,g|0,d|0,c[r>>2]|0,s|0);g=o;o=0;if(g&1){j=28;break}if(n){d=c[j>>2]|0;e=c[l>>2]|0;f=c[u>>2]|0;g=0;do{c[p>>2]=c[f+(g<<2)>>2];f=c[r>>2]|0;b[d+(f<<1)>>1]=b[d+(f+-1<<1)>>1]|0;b[e+-2>>1]=b[d>>1]|0;o=0;ia(71,a|0,0);f=o;o=0;if(f&1){j=27;break b}f=c[u>>2]|0;c[f+(g<<2)>>2]=c[p>>2];d=(c[j>>2]|0)+(s<<1)|0;c[j>>2]=d;e=(c[l>>2]|0)+(s<<1)|0;c[l>>2]=e;g=g+1|0}while((g|0)<(t|0))}q=q+1|0;if((q|0)>=(c[h>>2]|0)){j=40;break a}}if((j|0)==27){f=Na()|0;break}else if((j|0)==28){f=Na()|0;break}}else j=40;while(0);do if((j|0)==40){o=0;ha(182,a|0);a=o;o=0;if(a&1){f=Na()|0;break}d=c[u>>2]|0;e=d;if(d){f=c[w>>2]|0;if((f|0)!=(d|0))c[w>>2]=f+(~((f+-4-e|0)>>>2)<<2);cj(d)}d=c[x>>2]|0;if(!d){i=v;return}e=c[y>>2]|0;if((e|0)!=(d|0))c[y>>2]=e+(~((e+-2-d|0)>>>1)<<1);cj(d);i=v;return}while(0);d=c[u>>2]|0;e=d;if(d){g=c[w>>2]|0;if((g|0)!=(d|0))c[w>>2]=g+(~((g+-4-e|0)>>>2)<<2);cj(d)}}d=c[x>>2]|0;if(!d)Ya(f|0);e=c[y>>2]|0;if((e|0)!=(d|0))c[y>>2]=e+(~((e+-2-d|0)>>>1)<<1);cj(d);Ya(f|0)}function wf(d,f){d=d|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;p=d+4580|0;f=c[p>>2]|0;s=d+156|0;if((c[s>>2]|0)<=0)return;q=d+4584|0;r=d+4588|0;i=f;j=e[f+-2>>1]|0;f=e[f>>1]|0;o=0;while(1){n=c[q>>2]|0;m=e[n+(o+-1<<1)>>1]|0;h=o+1|0;g=e[i+(h<<1)>>1]|0;l=c[r>>2]|0;k=f-j|0;i=j-m|0;l=((((a[l+(g-f)>>0]|0)*9|0)+(a[l+k>>0]|0)|0)*9|0)+(a[l+i>>0]|0)|0;if(!l){h=(yf(d,o,0)|0)+o|0;g=c[p>>2]|0;f=e[g+(h+-1<<1)>>1]|0;g=e[g+(h<<1)>>1]|0}else{j=f-m>>31;if((j^i|0)<0)i=f;else i=m+((j^k|0)<0?0:k)|0;n=xf(d,l,e[n+(o<<1)>>1]|0,i,0)|0;b[(c[q>>2]|0)+(o<<1)>>1]=n}if((h|0)>=(c[s>>2]|0))break;i=c[p>>2]|0;j=f;f=g;o=h}return}function xf(a,d,e,f,g){a=a|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=d>>31;k=(q^d)-q|0;p=a+172+(k*12|0)+10|0;i=b[p>>1]|0;o=a+172+(k*12|0)|0;g=c[o>>2]|0;if((i|0)<(g|0))if((i<<1|0)<(g|0))if((i<<2|0)<(g|0))if((i<<3|0)<(g|0))if((i<<4|0)<(g|0)){h=5;while(1)if((i<<h|0)<(g|0))h=h+1|0;else break}else h=4;else h=3;else h=2;else h=1;else h=0;n=a+172+(k*12|0)+8|0;g=(b[n>>1]^q)-q+f|0;if((g&65535|0)==(g|0))m=g;else m=g>>31&65535^65535;j=(e-m^q)-q<<16;l=j>>16;if(!h)g=(c[a+172+(k*12|0)+4>>2]<<1)+-1+i>>31;else g=0;f=g^l;f=f>>30^f<<1;g=f>>h;if((g|0)<47){if((g|0)>30){i=(g|0)/2|0;ae(a,0,i);g=g-i|0}ae(a,1,g+1|0);ae(a,f&(1<<h)+-1,h)}else{ae(a,0,31);ae(a,1,17);ae(a,f+65535&65535,16)}f=a+172+(k*12|0)+4|0;i=b[p>>1]|0;g=i<<16>>16==64;h=g&1;e=(c[f>>2]|0)+l>>h;i=g?32:i<<16>>16;c[o>>2]=(c[o>>2]|0)+((j|0)>-65536?l:0-l|0)>>h;h=i+1|0;b[p>>1]=h;g=h+e|0;if((g|0)<1){p=b[n>>1]|0;b[n>>1]=(p&65535)-(p<<16>>16>-128&1);p=(g|0)>(~i|0)?g:0-i|0;c[f>>2]=p;q=l^q;d=d>>>31;d=m+d|0;d=d+q|0;d=d&65535;return d|0}if((e|0)<=0){p=e;c[f>>2]=p;q=l^q;d=d>>>31;d=m+d|0;d=d+q|0;d=d&65535;return d|0}p=e-h|0;o=b[n>>1]|0;b[n>>1]=(o<<16>>16<127&1)+(o&65535);p=(p|0)>0?0:p;c[f>>2]=p;q=l^q;d=d>>>31;d=m+d|0;d=d+q|0;d=d&65535;return d|0}function yf(a,d,f){a=a|0;d=d|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;j=(c[a+156>>2]|0)-d|0;k=c[a+4584>>2]|0;m=c[a+4580>>2]|0;h=b[k+(d+-1<<1)>>1]|0;g=0;while(1){f=k+(g+d<<1)|0;if((b[f>>1]|0)!=h<<16>>16){n=g;break}b[f>>1]=h;g=g+1|0;if((g|0)==(j|0)){n=j;break}}i=h&65535;h=(n|0)==(j|0);l=a+4576|0;g=c[36476+(c[l>>2]<<2)>>2]|0;if((1<<g|0)>(n|0))f=n;else{f=n;do{ae(a,1,1);g=c[l>>2]|0;f=f-(1<<c[36476+(g<<2)>>2])|0;g=(g|0)>30?31:g+1|0;c[l>>2]=g;g=c[36476+(g<<2)>>2]|0}while((f|0)>=(1<<g|0))}if(h){if(!f){a=j;return a|0}ae(a,1,1);a=j;return a|0}ae(a,f,g+1|0);f=n+d|0;h=k+(f<<1)|0;g=e[h>>1]|0;f=e[m+(f<<1)>>1]|0;m=i-f|0;if((((m|0)>-1?m:0-m|0)|0)<1){f=g-i<<16>>16;zf(a,a+4564|0,f);f=f+i|0}else{m=f-i>>31|1;d=($(g-f<<16,m)|0)>>16;zf(a,a+4552|0,d);f=($(d,m)|0)+f|0}b[h>>1]=f;a=c[l>>2]|0;c[l>>2]=(a|0)<1?0:a+-1|0;a=n+1|0;return a|0}function zf(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=e+9|0;j=d[n>>0]|0;m=e+4|0;l=c[m>>2]|0;h=($(j>>>1,l)|0)+(c[e>>2]|0)|0;if((j|0)<(h|0)){i=j;g=0;do{i=i<<1;g=g+1|0}while((i|0)<(h|0));h=g}else h=0;if((f|0)>0&(h|0)==0?d[e+10>>0]<<1>>>0<j>>>0:0)g=1;else k=5;do if((k|0)==5){g=(f|0)<0;if(g?d[e+10>>0]<<1>>>0>=j>>>0:0){g=1;break}g=g&(h|0)!=0}while(0);g=(((f|0)>-1?f:0-f|0)<<1)-l+(g<<31>>31)|0;Af(b,h,g,63-(c[36476+(c[b+4576>>2]<<2)>>2]|0)|0);if((f|0)<0){b=e+10|0;a[b>>0]=(d[b>>0]|0)+1}g=(g+1-(c[m>>2]|0)>>1)+(c[e>>2]|0)|0;c[e>>2]=g;h=a[n>>0]|0;if(h<<24>>24!=(a[e+8>>0]|0)){e=h;e=e&255;e=e+1|0;e=e&255;a[n>>0]=e;return}c[e>>2]=g>>1;b=(h&255)>>>1;a[n>>0]=b;e=e+10|0;a[e>>0]=(d[e>>0]|0)>>>1;e=b;e=e&255;e=e+1|0;e=e&255;a[n>>0]=e;return}function Af(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0;e=c>>b;f=d+-16|0;if((e|0)<(d+-17|0)){if((e|0)>30){d=(e|0)/2|0;ae(a,0,d);e=e-d|0}ae(a,1,e+1|0);ae(a,(1<<b)+-1&c,b);return}if((f|0)>31){ae(a,0,31);ae(a,1,d+-47|0)}else ae(a,1,f);ae(a,c+65535&65535,16);return}function Bf(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;m=i;i=i+32|0;k=m;Ei(k,65535,0);l=b+160|0;if(((c[k+4>>2]|0)==(c[l>>2]|0)?(c[k+8>>2]|0)==(c[b+164>>2]|0):0)?(c[k+12>>2]|0)==(c[b+168>>2]|0):0){l=c[8909]|0;c[b+4588>>2]=l+(((c[8910]|0)-l|0)>>>1);i=m;return}e=b+4592|0;f=b+4596|0;g=c[f>>2]|0;d=c[e>>2]|0;h=g-d|0;if(h>>>0>=131072){if(h>>>0>131072?(j=d+131072|0,(g|0)!=(j|0)):0)c[f>>2]=j}else{ie(e,131072-h|0);d=c[e>>2]|0}k=b+4588|0;c[k>>2]=d+65536;j=b+168|0;g=b+164|0;h=-65536;while(1){d=c[j>>2]|0;if((h|0)>(0-d|0)){e=c[g>>2]|0;if((h|0)>(0-e|0)){f=c[l>>2]|0;if((h|0)>(0-f|0))if((h|0)>=0){if((h|0)<1){a[(c[k>>2]|0)+h>>0]=0;h=1;continue}if((f|0)<=(h|0))if((e|0)>(h|0))d=2;else d=(d|0)>(h|0)?3:4;else d=1}else d=-1;else d=-2}else d=-3}else d=-4;a[(c[k>>2]|0)+h>>0]=d;h=h+1|0;if((h|0)==65536)break}i=m;return}function Cf(a){a=a|0;var b=0,d=0;c[a>>2]=35968;b=c[a+4592>>2]|0;if(b){d=a+4596|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}c[a>>2]=36612;b=c[a+120>>2]|0;if(b){d=a+124|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}d=a+92|0;b=c[d>>2]|0;c[d>>2]=0;if(b)Bb[c[(c[b>>2]|0)+4>>2]&255](b);a=a+4|0;b=c[a>>2]|0;c[a>>2]=0;if(!b)return;Bb[c[(c[b>>2]|0)+4>>2]&255](b);return}function Df(a){a=a|0;var b=0,d=0;c[a>>2]=35968;b=c[a+4592>>2]|0;if(b){d=a+4596|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}c[a>>2]=36612;b=c[a+120>>2]|0;if(b){d=a+124|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}d=a+92|0;b=c[d>>2]|0;c[d>>2]=0;if(b)Bb[c[(c[b>>2]|0)+4>>2]&255](b);d=a+4|0;b=c[d>>2]|0;c[d>>2]=0;if(!b){cj(a);return}Bb[c[(c[b>>2]|0)+4>>2]&255](b);cj(a);return}function Ef(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;h=i;i=i+32|0;l=h;Ei(l,4095,0);k=c[e+4>>2]|0;j=c[e+8>>2]|0;j=(j|0)==0?c[l+8>>2]|0:j;g=c[e+12>>2]|0;g=(g|0)==0?c[l+12>>2]|0:g;e=c[e+16>>2]|0;f=c[l+16>>2]|0;c[d+160>>2]=(k|0)==0?c[l+4>>2]|0:k;c[d+164>>2]=j;c[d+168>>2]=g;Nf(d);g=0;do{c[d+172+(g*12|0)>>2]=64;c[d+172+(g*12|0)+4>>2]=0;b[d+172+(g*12|0)+8>>1]=0;b[d+172+(g*12|0)+10>>1]=1;g=g+1|0}while((g|0)!=365);l=((e|0)==0?f:e)&255;c[d+4552>>2]=64;c[d+4556>>2]=0;a[d+4560>>0]=l;a[d+4561>>0]=1;a[d+4562>>0]=0;c[d+4564>>2]=64;c[d+4568>>2]=1;a[d+4572>>0]=l;a[d+4573>>0]=1;a[d+4574>>0]=0;c[d+4576>>2]=0;i=h;return}function Ff(d,e,f,g){d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0;o=i;i=i+16|0;m=o;l=d+92|0;k=c[e>>2]|0;c[e>>2]=0;e=c[l>>2]|0;c[l>>2]=k;if(e)Bb[c[(c[e>>2]|0)+4>>2]&255](e);c[m>>2]=0;c[m+4>>2]=g;l=f+8|0;c[m+8>>2]=c[l>>2];if(g){e=bj(4600)|0;g=d+8|0;h=e+4|0;j=g;k=h+84|0;do{c[h>>2]=c[j>>2];h=h+4|0;j=j+4|0}while((h|0)<(k|0));h=e+88|0;k=h+40|0;do{c[h>>2]=0;h=h+4|0}while((h|0)<(k|0));c[e>>2]=35744;h=e+132|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[e+148>>2]=c[g>>2];c[e+152>>2]=0;c[e+156>>2]=0;c[e+160>>2]=0;h=e+4544|0;g=e+164|0;do{c[g>>2]=0;c[g+4>>2]=0;b[g+8>>1]=0;b[g+10>>1]=1;g=g+12|0}while((g|0)!=(h|0));j=d+4|0;c[h>>2]=0;c[h+4>>2]=0;b[h+8>>1]=0;a[h+10>>0]=0;k=e+4556|0;c[k>>2]=0;c[k+4>>2]=0;b[k+8>>1]=0;a[k+10>>0]=0;k=e+4568|0;c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;c[k+20>>2]=0;c[k+24>>2]=0;a[k+28>>0]=0;if(!(c[e+28>>2]|0))c[e+20>>2]=1;g=c[j>>2]|0;c[j>>2]=e;if(g){Bb[c[(c[g>>2]|0)+4>>2]&255](g);e=c[j>>2]|0}Wd(e,m)}m=d+100|0;c[m>>2]=32;c[d+96>>2]=0;e=c[f>>2]|0;if(!e){c[d+108>>2]=c[f+4>>2];c[d+104>>2]=c[l>>2];Hf(d);n=d+116|0;n=c[n>>2]|0;d=c[m>>2]|0;d=d+-32|0;d=(d|0)/8|0;d=n-d|0;i=o;return d|0}c[d+132>>2]=e;h=d+120|0;l=d+124|0;g=c[l>>2]|0;e=c[h>>2]|0;j=e;k=g-j|0;if(k>>>0>=4e3){if(k>>>0>4e3?(n=e+4e3|0,(g|0)!=(n|0)):0){c[l>>2]=n;g=n}}else{Xd(h,4e3-k|0);e=c[h>>2]|0;j=e;g=c[l>>2]|0}c[d+108>>2]=j;c[d+104>>2]=g-e;Hf(d);n=d+116|0;n=c[n>>2]|0;d=c[m>>2]|0;d=d+-32|0;d=(d|0)/8|0;d=n-d|0;i=o;return d|0}function Gf(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;w=i;i=i+352|0;x=w+328|0;y=w+192|0;e=w+343|0;f=w+342|0;g=w+341|0;h=w+340|0;r=w+176|0;k=w+168|0;l=w+160|0;m=w+152|0;v=w;t=w+136|0;if((c[b+32>>2]|0)!=0?(c[b+24>>2]|0)!=1:0){s=b+8|0;u=b+36|0;j=c[u>>2]|0;if(!j){b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[e>>0]|0;Aa(37,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}b=c[b+16>>2]|0;if((b|0)==16)switch(j|0){case 1:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[f>>0]|0;Aa(38,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 2:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[g>>0]|0;Aa(39,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 3:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[h>>0]|0;Aa(40,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}default:{j=y+56|0;g=y+4|0;c[y>>2]=36160;c[j>>2]=36180;o=0;ia(62,y+56|0,g|0);w=o;o=0;if(w&1){z=Na()|0;fn(j);Ya(z|0)}c[y+128>>2]=0;c[y+132>>2]=-1;c[y>>2]=36200;c[y+56>>2]=36220;o=0;ha(180,g|0);w=o;o=0;do if(w&1)b=Na()|0;else{c[g>>2]=36236;h=y+36|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[y+52>>2]=16;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;o=0;ia(63,g|0,x|0);w=o;o=0;if(w&1){b=Na()|0;Im(x);Im(h);nn(g);break}Im(x);o=0;b=ma(28,y|0,49007,21)|0;x=o;o=0;do if((!(x&1)?(o=0,p=ra(36,b|0,c[u>>2]|0)|0,x=o,o=0,!(x&1)):0)?(o=0,ma(28,p|0,50997,18)|0,x=o,o=0,!(x&1)):0){f=Ma(16)|0;o=0;ia(64,r|0,g|0);x=o;o=0;if(!(x&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,f|0,9,35648,r|0);x=o;o=0;if(x&1)e=1;else{o=0;wa(6,f|0,824,96);o=0;e=0}b=Na()|0;Im(r);if(!e)break}else b=Na()|0;La(f|0)}else z=34;while(0);if((z|0)==34)b=Na()|0;c[y>>2]=36200;c[j>>2]=36220;c[g>>2]=36236;Im(h);nn(g);fn(j);z=b;Ya(z|0)}while(0);z=b;fn(j);Ya(z|0)}}if((b|0)<=8){b=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,b|0,8,35648);z=o;o=0;if(!(z&1))lb(b|0,824,96);z=Na()|0;La(b|0);Ya(z|0)}e=16-b|0;switch(j|0){case 1:{b=bj(60)|0;c[k>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[k>>2];c[x+4>>2]=c[k+4>>2];Aa(41,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 2:{b=bj(60)|0;c[l>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[l>>2];c[x+4>>2]=c[l+4>>2];Aa(42,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 3:{b=bj(60)|0;c[m>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[m>>2];c[x+4>>2]=c[m+4>>2];Aa(43,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}default:{j=v+56|0;g=v+4|0;c[v>>2]=36160;c[j>>2]=36180;o=0;ia(62,v+56|0,g|0);y=o;o=0;if(y&1){z=Na()|0;fn(j);Ya(z|0)}c[v+128>>2]=0;c[v+132>>2]=-1;c[v>>2]=36200;c[v+56>>2]=36220;o=0;ha(180,g|0);y=o;o=0;do if(y&1)b=Na()|0;else{c[g>>2]=36236;h=v+36|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[v+52>>2]=16;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;o=0;ia(63,g|0,x|0);y=o;o=0;if(y&1){b=Na()|0;Im(x);Im(h);nn(g);break}Im(x);o=0;b=ma(28,v|0,49007,21)|0;y=o;o=0;do if((!(y&1)?(o=0,q=ra(36,b|0,c[u>>2]|0)|0,y=o,o=0,!(y&1)):0)?(o=0,ma(28,q|0,50997,18)|0,y=o,o=0,!(y&1)):0){f=Ma(16)|0;o=0;ia(64,t|0,g|0);y=o;o=0;if(!(y&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,f|0,9,35648,t|0);y=o;o=0;if(y&1)e=1;else{o=0;wa(6,f|0,824,96);o=0;e=0}b=Na()|0;Im(t);if(!e)break}else b=Na()|0;La(f|0)}else z=64;while(0);if((z|0)==64)b=Na()|0;c[v>>2]=36200;c[j>>2]=36220;c[g>>2]=36236;Im(h);nn(g);fn(j);z=b;Ya(z|0)}while(0);z=b;fn(j);Ya(z|0)}}}e=c[d+4>>2]|0;f=bj(16)|0;b=c[b+20>>2]|0;if(!e){z=c[d>>2]|0;c[f>>2]=36132;c[f+4>>2]=z;c[f+8>>2]=2;c[f+12>>2]=b;z=f;i=w;return z|0}else{c[f>>2]=36108;c[f+4>>2]=e;c[f+8>>2]=2;c[f+12>>2]=b;z=f;i=w;return z|0}return 0}function Hf(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;v=i;i=i+32|0;x=v+12|0;u=v;r=a+156|0;s=(c[r>>2]|0)+4|0;if((c[a+32>>2]|0)==1)t=c[a+24>>2]|0;else t=1;d=$(t<<1,s)|0;c[x>>2]=0;y=x+4|0;c[y>>2]=0;c[x+8>>2]=0;do if(d){if(!((d|0)<0?(o=0,ha(178,x|0),w=o,o=0,w&1):0))j=6;if((j|0)==6?(e=d<<1,o=0,f=ka(67,e|0)|0,w=o,o=0,!(w&1)):0){c[x>>2]=f;w=f+(d<<1)|0;c[x+8>>2]=w;iw(f|0,0,e|0)|0;c[y>>2]=w;break}f=Na()|0;d=c[x>>2]|0;if(!d)Ya(f|0);e=c[y>>2]|0;if((e|0)!=(d|0))c[y>>2]=e+(~((e+-2-d|0)>>>1)<<1);cj(d);Ya(f|0)}while(0);c[u>>2]=0;w=u+4|0;c[w>>2]=0;c[u+8>>2]=0;do if(!t)j=18;else{if(!(t>>>0>1073741823?(o=0,ha(178,u|0),q=o,o=0,q&1):0))j=16;if((j|0)==16?(g=t<<2,o=0,h=ka(67,g|0)|0,q=o,o=0,!(q&1)):0){c[u>>2]=h;j=h+(t<<2)|0;c[u+8>>2]=j;iw(h|0,0,g|0)|0;c[w>>2]=j;j=18;break}f=Na()|0;d=c[u>>2]|0;e=d;if(d){g=c[w>>2]|0;if((g|0)!=(d|0))c[w>>2]=g+(~((g+-4-e|0)>>>2)<<2);cj(d)}}while(0);if((j|0)==18){h=a+12|0;a:do if((c[h>>2]|0)>0){j=a+4580|0;k=($(t,s)|0)+1|0;l=a+4584|0;m=a+92|0;n=(t|0)>0;p=a+4576|0;q=0;b:while(1){e=c[x>>2]|0;d=e+2|0;c[j>>2]=d;e=e+(k<<1)|0;c[l>>2]=e;if(!(q&1))d=e;else{c[j>>2]=e;c[l>>2]=d}g=c[m>>2]|0;o=0;Aa(c[(c[g>>2]|0)+12>>2]|0,g|0,d|0,c[r>>2]|0,s|0);g=o;o=0;if(g&1){j=28;break}if(n){d=c[j>>2]|0;e=c[l>>2]|0;f=c[u>>2]|0;g=0;do{c[p>>2]=c[f+(g<<2)>>2];f=c[r>>2]|0;b[d+(f<<1)>>1]=b[d+(f+-1<<1)>>1]|0;b[e+-2>>1]=b[d>>1]|0;o=0;ia(72,a|0,0);f=o;o=0;if(f&1){j=27;break b}f=c[u>>2]|0;c[f+(g<<2)>>2]=c[p>>2];d=(c[j>>2]|0)+(s<<1)|0;c[j>>2]=d;e=(c[l>>2]|0)+(s<<1)|0;c[l>>2]=e;g=g+1|0}while((g|0)<(t|0))}q=q+1|0;if((q|0)>=(c[h>>2]|0)){j=40;break a}}if((j|0)==27){f=Na()|0;break}else if((j|0)==28){f=Na()|0;break}}else j=40;while(0);do if((j|0)==40){o=0;ha(182,a|0);a=o;o=0;if(a&1){f=Na()|0;break}d=c[u>>2]|0;e=d;if(d){f=c[w>>2]|0;if((f|0)!=(d|0))c[w>>2]=f+(~((f+-4-e|0)>>>2)<<2);cj(d)}d=c[x>>2]|0;if(!d){i=v;return}e=c[y>>2]|0;if((e|0)!=(d|0))c[y>>2]=e+(~((e+-2-d|0)>>>1)<<1);cj(d);i=v;return}while(0);d=c[u>>2]|0;e=d;if(d){g=c[w>>2]|0;if((g|0)!=(d|0))c[w>>2]=g+(~((g+-4-e|0)>>>2)<<2);cj(d)}}d=c[x>>2]|0;if(!d)Ya(f|0);e=c[y>>2]|0;if((e|0)!=(d|0))c[y>>2]=e+(~((e+-2-d|0)>>>1)<<1);cj(d);Ya(f|0)}function If(d,f){d=d|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;p=d+4580|0;f=c[p>>2]|0;s=d+156|0;if((c[s>>2]|0)<=0)return;q=d+4584|0;r=d+4588|0;i=f;j=e[f+-2>>1]|0;f=e[f>>1]|0;o=0;while(1){n=c[q>>2]|0;m=e[n+(o+-1<<1)>>1]|0;h=o+1|0;g=e[i+(h<<1)>>1]|0;l=c[r>>2]|0;k=f-j|0;i=j-m|0;l=((((a[l+(g-f)>>0]|0)*9|0)+(a[l+k>>0]|0)|0)*9|0)+(a[l+i>>0]|0)|0;if(!l){h=(Kf(d,o,0)|0)+o|0;g=c[p>>2]|0;f=e[g+(h+-1<<1)>>1]|0;g=e[g+(h<<1)>>1]|0}else{j=f-m>>31;if((j^i|0)<0)i=f;else i=m+((j^k|0)<0?0:k)|0;n=Jf(d,l,e[n+(o<<1)>>1]|0,i,0)|0;b[(c[q>>2]|0)+(o<<1)>>1]=n}if((h|0)>=(c[s>>2]|0))break;i=c[p>>2]|0;j=f;f=g;o=h}return}function Jf(a,d,e,f,g){a=a|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=d>>31;k=(q^d)-q|0;p=a+172+(k*12|0)+10|0;i=b[p>>1]|0;o=a+172+(k*12|0)|0;g=c[o>>2]|0;if((i|0)<(g|0))if((i<<1|0)<(g|0))if((i<<2|0)<(g|0))if((i<<3|0)<(g|0))if((i<<4|0)<(g|0)){h=5;while(1)if((i<<h|0)<(g|0))h=h+1|0;else break}else h=4;else h=3;else h=2;else h=1;else h=0;n=a+172+(k*12|0)+8|0;g=(b[n>>1]^q)-q+f|0;if((g&4095|0)==(g|0))m=g;else m=g>>31&4095^4095;j=(e-m^q)-q<<20;l=j>>20;if(!h)g=(c[a+172+(k*12|0)+4>>2]<<1)+-1+i>>31;else g=0;f=g^l;f=f>>30^f<<1;g=f>>h;if((g|0)<35){if((g|0)>30){i=(g|0)/2|0;ae(a,0,i);g=g-i|0}ae(a,1,g+1|0);ae(a,f&(1<<h)+-1,h)}else{ae(a,0,31);ae(a,1,5);ae(a,f+4095&4095,12)}f=a+172+(k*12|0)+4|0;i=b[p>>1]|0;g=i<<16>>16==64;h=g&1;e=(c[f>>2]|0)+l>>h;i=g?32:i<<16>>16;c[o>>2]=(c[o>>2]|0)+((j|0)>-1048576?l:0-l|0)>>h;h=i+1|0;b[p>>1]=h;g=h+e|0;if((g|0)<1){p=b[n>>1]|0;b[n>>1]=(p&65535)-(p<<16>>16>-128&1);p=(g|0)>(~i|0)?g:0-i|0;c[f>>2]=p;q=l^q;d=d>>>31;d=m+d|0;d=d+q|0;d=d&4095;d=d&65535;return d|0}if((e|0)<=0){p=e;c[f>>2]=p;q=l^q;d=d>>>31;d=m+d|0;d=d+q|0;d=d&4095;d=d&65535;return d|0}p=e-h|0;o=b[n>>1]|0;b[n>>1]=(o<<16>>16<127&1)+(o&65535);p=(p|0)>0?0:p;c[f>>2]=p;q=l^q;d=d>>>31;d=m+d|0;d=d+q|0;d=d&4095;d=d&65535;return d|0}function Kf(a,d,f){a=a|0;d=d|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;j=(c[a+156>>2]|0)-d|0;k=c[a+4584>>2]|0;m=c[a+4580>>2]|0;h=b[k+(d+-1<<1)>>1]|0;g=0;while(1){f=k+(g+d<<1)|0;if((b[f>>1]|0)!=h<<16>>16){n=g;break}b[f>>1]=h;g=g+1|0;if((g|0)==(j|0)){n=j;break}}i=h&65535;h=(n|0)==(j|0);l=a+4576|0;g=c[36476+(c[l>>2]<<2)>>2]|0;if((1<<g|0)>(n|0))f=n;else{f=n;do{ae(a,1,1);g=c[l>>2]|0;f=f-(1<<c[36476+(g<<2)>>2])|0;g=(g|0)>30?31:g+1|0;c[l>>2]=g;g=c[36476+(g<<2)>>2]|0}while((f|0)>=(1<<g|0))}if(h){if(!f){a=j;return a|0}ae(a,1,1);a=j;return a|0}ae(a,f,g+1|0);f=n+d|0;h=k+(f<<1)|0;g=e[h>>1]|0;f=e[m+(f<<1)>>1]|0;m=i-f|0;if((((m|0)>-1?m:0-m|0)|0)<1){f=g-i<<20>>20;Lf(a,a+4564|0,f);f=f+i|0}else{m=f-i>>31|1;d=($(g-f<<20,m)|0)>>20;Lf(a,a+4552|0,d);f=($(d,m)|0)+f|0}b[h>>1]=f&4095;a=c[l>>2]|0;c[l>>2]=(a|0)<1?0:a+-1|0;a=n+1|0;return a|0}function Lf(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=e+9|0;j=d[n>>0]|0;m=e+4|0;l=c[m>>2]|0;h=($(j>>>1,l)|0)+(c[e>>2]|0)|0;if((j|0)<(h|0)){i=j;g=0;do{i=i<<1;g=g+1|0}while((i|0)<(h|0));h=g}else h=0;if((f|0)>0&(h|0)==0?d[e+10>>0]<<1>>>0<j>>>0:0)g=1;else k=5;do if((k|0)==5){g=(f|0)<0;if(g?d[e+10>>0]<<1>>>0>=j>>>0:0){g=1;break}g=g&(h|0)!=0}while(0);g=(((f|0)>-1?f:0-f|0)<<1)-l+(g<<31>>31)|0;Mf(b,h,g,47-(c[36476+(c[b+4576>>2]<<2)>>2]|0)|0);if((f|0)<0){b=e+10|0;a[b>>0]=(d[b>>0]|0)+1}g=(g+1-(c[m>>2]|0)>>1)+(c[e>>2]|0)|0;c[e>>2]=g;h=a[n>>0]|0;if(h<<24>>24!=(a[e+8>>0]|0)){e=h;e=e&255;e=e+1|0;e=e&255;a[n>>0]=e;return}c[e>>2]=g>>1;b=(h&255)>>>1;a[n>>0]=b;e=e+10|0;a[e>>0]=(d[e>>0]|0)>>>1;e=b;e=e&255;e=e+1|0;e=e&255;a[n>>0]=e;return}function Mf(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0;e=c>>b;f=d+-12|0;if((e|0)<(d+-13|0)){if((e|0)>30){d=(e|0)/2|0;ae(a,0,d);e=e-d|0}ae(a,1,e+1|0);ae(a,(1<<b)+-1&c,b);return}if((f|0)>31){ae(a,0,31);ae(a,1,d+-43|0)}else ae(a,1,f);ae(a,c+4095&4095,12);return}function Nf(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;m=i;i=i+32|0;k=m;Ei(k,4095,0);l=b+160|0;if(((c[k+4>>2]|0)==(c[l>>2]|0)?(c[k+8>>2]|0)==(c[b+164>>2]|0):0)?(c[k+12>>2]|0)==(c[b+168>>2]|0):0){l=c[8906]|0;c[b+4588>>2]=l+(((c[8907]|0)-l|0)>>>1);i=m;return}e=b+4592|0;f=b+4596|0;g=c[f>>2]|0;d=c[e>>2]|0;h=g-d|0;if(h>>>0>=8192){if(h>>>0>8192?(j=d+8192|0,(g|0)!=(j|0)):0)c[f>>2]=j}else{ie(e,8192-h|0);d=c[e>>2]|0}k=b+4588|0;c[k>>2]=d+4096;j=b+168|0;g=b+164|0;h=-4096;while(1){d=c[j>>2]|0;if((h|0)>(0-d|0)){e=c[g>>2]|0;if((h|0)>(0-e|0)){f=c[l>>2]|0;if((h|0)>(0-f|0))if((h|0)>=0){if((h|0)<1){a[(c[k>>2]|0)+h>>0]=0;h=1;continue}if((f|0)<=(h|0))if((e|0)>(h|0))d=2;else d=(d|0)>(h|0)?3:4;else d=1}else d=-1;else d=-2}else d=-3}else d=-4;a[(c[k>>2]|0)+h>>0]=d;h=h+1|0;if((h|0)==4096)break}i=m;return}function Of(a){a=a|0;var b=0,d=0;c[a>>2]=35940;b=c[a+4592>>2]|0;if(b){d=a+4596|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}c[a>>2]=36612;b=c[a+120>>2]|0;if(b){d=a+124|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}d=a+92|0;b=c[d>>2]|0;c[d>>2]=0;if(b)Bb[c[(c[b>>2]|0)+4>>2]&255](b);a=a+4|0;b=c[a>>2]|0;c[a>>2]=0;if(!b)return;Bb[c[(c[b>>2]|0)+4>>2]&255](b);return}function Pf(a){a=a|0;var b=0,d=0;c[a>>2]=35940;b=c[a+4592>>2]|0;if(b){d=a+4596|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}c[a>>2]=36612;b=c[a+120>>2]|0;if(b){d=a+124|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}d=a+92|0;b=c[d>>2]|0;c[d>>2]=0;if(b)Bb[c[(c[b>>2]|0)+4>>2]&255](b);d=a+4|0;b=c[d>>2]|0;c[d>>2]=0;if(!b){cj(a);return}Bb[c[(c[b>>2]|0)+4>>2]&255](b);cj(a);return}function Qf(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;h=i;i=i+32|0;l=h;Ei(l,255,0);k=c[e+4>>2]|0;j=c[e+8>>2]|0;j=(j|0)==0?c[l+8>>2]|0:j;g=c[e+12>>2]|0;g=(g|0)==0?c[l+12>>2]|0:g;e=c[e+16>>2]|0;f=c[l+16>>2]|0;c[d+160>>2]=(k|0)==0?c[l+4>>2]|0:k;c[d+164>>2]=j;c[d+168>>2]=g;Zf(d);g=0;do{c[d+172+(g*12|0)>>2]=4;c[d+172+(g*12|0)+4>>2]=0;b[d+172+(g*12|0)+8>>1]=0;b[d+172+(g*12|0)+10>>1]=1;g=g+1|0}while((g|0)!=365);l=((e|0)==0?f:e)&255;c[d+4552>>2]=4;c[d+4556>>2]=0;a[d+4560>>0]=l;a[d+4561>>0]=1;a[d+4562>>0]=0;c[d+4564>>2]=4;c[d+4568>>2]=1;a[d+4572>>0]=l;a[d+4573>>0]=1;a[d+4574>>0]=0;c[d+4576>>2]=0;i=h;return}function Rf(d,e,f,g){d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0;o=i;i=i+16|0;m=o;l=d+92|0;k=c[e>>2]|0;c[e>>2]=0;e=c[l>>2]|0;c[l>>2]=k;if(e)Bb[c[(c[e>>2]|0)+4>>2]&255](e);c[m>>2]=0;c[m+4>>2]=g;l=f+8|0;c[m+8>>2]=c[l>>2];if(g){e=bj(4600)|0;g=d+8|0;h=e+4|0;j=g;k=h+84|0;do{c[h>>2]=c[j>>2];h=h+4|0;j=j+4|0}while((h|0)<(k|0));h=e+88|0;k=h+40|0;do{c[h>>2]=0;h=h+4|0}while((h|0)<(k|0));c[e>>2]=35716;h=e+132|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[e+148>>2]=c[g>>2];c[e+152>>2]=0;c[e+156>>2]=0;c[e+160>>2]=0;h=e+4544|0;g=e+164|0;do{c[g>>2]=0;c[g+4>>2]=0;b[g+8>>1]=0;b[g+10>>1]=1;g=g+12|0}while((g|0)!=(h|0));j=d+4|0;c[h>>2]=0;c[h+4>>2]=0;b[h+8>>1]=0;a[h+10>>0]=0;k=e+4556|0;c[k>>2]=0;c[k+4>>2]=0;b[k+8>>1]=0;a[k+10>>0]=0;k=e+4568|0;c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;c[k+20>>2]=0;c[k+24>>2]=0;a[k+28>>0]=0;if(!(c[e+28>>2]|0))c[e+20>>2]=1;g=c[j>>2]|0;c[j>>2]=e;if(g){Bb[c[(c[g>>2]|0)+4>>2]&255](g);e=c[j>>2]|0}Wd(e,m)}m=d+100|0;c[m>>2]=32;c[d+96>>2]=0;e=c[f>>2]|0;if(!e){c[d+108>>2]=c[f+4>>2];c[d+104>>2]=c[l>>2];Tf(d);n=d+116|0;n=c[n>>2]|0;d=c[m>>2]|0;d=d+-32|0;d=(d|0)/8|0;d=n-d|0;i=o;return d|0}c[d+132>>2]=e;h=d+120|0;l=d+124|0;g=c[l>>2]|0;e=c[h>>2]|0;j=e;k=g-j|0;if(k>>>0>=4e3){if(k>>>0>4e3?(n=e+4e3|0,(g|0)!=(n|0)):0){c[l>>2]=n;g=n}}else{Xd(h,4e3-k|0);e=c[h>>2]|0;j=e;g=c[l>>2]|0}c[d+108>>2]=j;c[d+104>>2]=g-e;Tf(d);n=d+116|0;n=c[n>>2]|0;d=c[m>>2]|0;d=d+-32|0;d=(d|0)/8|0;d=n-d|0;i=o;return d|0}function Sf(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;w=i;i=i+352|0;x=w+328|0;y=w+192|0;e=w+343|0;f=w+342|0;g=w+341|0;h=w+340|0;r=w+176|0;k=w+168|0;l=w+160|0;m=w+152|0;v=w;t=w+136|0;if((c[b+32>>2]|0)!=0?(c[b+24>>2]|0)!=1:0){s=b+8|0;u=b+36|0;j=c[u>>2]|0;if(!j){b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[e>>0]|0;Aa(44,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}b=c[b+16>>2]|0;if((b|0)==8)switch(j|0){case 1:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[f>>0]|0;Aa(45,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 2:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[g>>0]|0;Aa(46,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 3:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[h>>0]|0;Aa(47,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}default:{j=y+56|0;g=y+4|0;c[y>>2]=36160;c[j>>2]=36180;o=0;ia(62,y+56|0,g|0);w=o;o=0;if(w&1){z=Na()|0;fn(j);Ya(z|0)}c[y+128>>2]=0;c[y+132>>2]=-1;c[y>>2]=36200;c[y+56>>2]=36220;o=0;ha(180,g|0);w=o;o=0;do if(w&1)b=Na()|0;else{c[g>>2]=36236;h=y+36|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[y+52>>2]=16;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;o=0;ia(63,g|0,x|0);w=o;o=0;if(w&1){b=Na()|0;Im(x);Im(h);nn(g);break}Im(x);o=0;b=ma(28,y|0,49007,21)|0;x=o;o=0;do if((!(x&1)?(o=0,p=ra(36,b|0,c[u>>2]|0)|0,x=o,o=0,!(x&1)):0)?(o=0,ma(28,p|0,50997,18)|0,x=o,o=0,!(x&1)):0){f=Ma(16)|0;o=0;ia(64,r|0,g|0);x=o;o=0;if(!(x&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,f|0,9,35648,r|0);x=o;o=0;if(x&1)e=1;else{o=0;wa(6,f|0,824,96);o=0;e=0}b=Na()|0;Im(r);if(!e)break}else b=Na()|0;La(f|0)}else z=34;while(0);if((z|0)==34)b=Na()|0;c[y>>2]=36200;c[j>>2]=36220;c[g>>2]=36236;Im(h);nn(g);fn(j);z=b;Ya(z|0)}while(0);z=b;fn(j);Ya(z|0)}}if((b|0)<=8){b=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,b|0,8,35648);z=o;o=0;if(!(z&1))lb(b|0,824,96);z=Na()|0;La(b|0);Ya(z|0)}e=16-b|0;switch(j|0){case 1:{b=bj(60)|0;c[k>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[k>>2];c[x+4>>2]=c[k+4>>2];Aa(41,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 2:{b=bj(60)|0;c[l>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[l>>2];c[x+4>>2]=c[l+4>>2];Aa(42,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 3:{b=bj(60)|0;c[m>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[m>>2];c[x+4>>2]=c[m+4>>2];Aa(43,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}default:{j=v+56|0;g=v+4|0;c[v>>2]=36160;c[j>>2]=36180;o=0;ia(62,v+56|0,g|0);y=o;o=0;if(y&1){z=Na()|0;fn(j);Ya(z|0)}c[v+128>>2]=0;c[v+132>>2]=-1;c[v>>2]=36200;c[v+56>>2]=36220;o=0;ha(180,g|0);y=o;o=0;do if(y&1)b=Na()|0;else{c[g>>2]=36236;h=v+36|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[v+52>>2]=16;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;o=0;ia(63,g|0,x|0);y=o;o=0;if(y&1){b=Na()|0;Im(x);Im(h);nn(g);break}Im(x);o=0;b=ma(28,v|0,49007,21)|0;y=o;o=0;do if((!(y&1)?(o=0,q=ra(36,b|0,c[u>>2]|0)|0,y=o,o=0,!(y&1)):0)?(o=0,ma(28,q|0,50997,18)|0,y=o,o=0,!(y&1)):0){f=Ma(16)|0;o=0;ia(64,t|0,g|0);y=o;o=0;if(!(y&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,f|0,9,35648,t|0);y=o;o=0;if(y&1)e=1;else{o=0;wa(6,f|0,824,96);o=0;e=0}b=Na()|0;Im(t);if(!e)break}else b=Na()|0;La(f|0)}else z=64;while(0);if((z|0)==64)b=Na()|0;c[v>>2]=36200;c[j>>2]=36220;c[g>>2]=36236;Im(h);nn(g);fn(j);z=b;Ya(z|0)}while(0);z=b;fn(j);Ya(z|0)}}}e=c[d+4>>2]|0;f=bj(16)|0;b=c[b+20>>2]|0;if(!e){z=c[d>>2]|0;c[f>>2]=36132;c[f+4>>2]=z;c[f+8>>2]=1;c[f+12>>2]=b;z=f;i=w;return z|0}else{c[f>>2]=36108;c[f+4>>2]=e;c[f+8>>2]=1;c[f+12>>2]=b;z=f;i=w;return z|0}return 0}function Tf(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;u=i;i=i+32|0;w=u+12|0;t=u;q=b+156|0;r=(c[q>>2]|0)+4|0;if((c[b+32>>2]|0)==1)s=c[b+24>>2]|0;else s=1;d=$(s<<1,r)|0;c[w>>2]=0;x=w+4|0;c[x>>2]=0;c[w+8>>2]=0;a:do if(d){if(!((d|0)<0?(o=0,ha(178,w|0),v=o,o=0,v&1):0))h=6;if((h|0)==6?(o=0,e=ka(67,d|0)|0,v=o,o=0,!(v&1)):0){c[x>>2]=e;c[w>>2]=e;c[w+8>>2]=e+d;while(1){a[e>>0]=0;e=(c[x>>2]|0)+1|0;c[x>>2]=e;d=d+-1|0;if(!d)break a}}e=Na()|0;d=c[w>>2]|0;if(!d)Ya(e|0);if((c[x>>2]|0)!=(d|0))c[x>>2]=d;cj(d);Ya(e|0)}while(0);c[t>>2]=0;v=t+4|0;c[v>>2]=0;c[t+8>>2]=0;do if(!s)h=19;else{if(!(s>>>0>1073741823?(o=0,ha(178,t|0),p=o,o=0,p&1):0))h=17;if((h|0)==17?(f=s<<2,o=0,g=ka(67,f|0)|0,p=o,o=0,!(p&1)):0){c[t>>2]=g;h=g+(s<<2)|0;c[t+8>>2]=h;iw(g|0,0,f|0)|0;c[v>>2]=h;h=19;break}e=Na()|0;d=c[t>>2]|0;f=d;if(d){g=c[v>>2]|0;if((g|0)!=(d|0))c[v>>2]=g+(~((g+-4-f|0)>>>2)<<2);cj(d)}}while(0);if((h|0)==19){g=b+12|0;b:do if((c[g>>2]|0)>0){h=b+4580|0;j=($(s,r)|0)+1|0;k=b+4584|0;l=b+92|0;m=(s|0)>0;n=b+4576|0;p=0;c:while(1){e=c[w>>2]|0;d=e+1|0;c[h>>2]=d;e=e+j|0;c[k>>2]=e;if(!(p&1))d=e;else{c[h>>2]=e;c[k>>2]=d}f=c[l>>2]|0;o=0;Aa(c[(c[f>>2]|0)+12>>2]|0,f|0,d|0,c[q>>2]|0,r|0);f=o;o=0;if(f&1){h=29;break}if(m){d=c[h>>2]|0;e=c[t>>2]|0;f=0;do{c[n>>2]=c[e+(f<<2)>>2];e=c[q>>2]|0;a[d+e>>0]=a[d+(e+-1)>>0]|0;a[(c[k>>2]|0)+-1>>0]=a[c[h>>2]>>0]|0;o=0;ia(73,b|0,0);e=o;o=0;if(e&1){h=28;break c}e=c[t>>2]|0;c[e+(f<<2)>>2]=c[n>>2];d=(c[h>>2]|0)+r|0;c[h>>2]=d;c[k>>2]=(c[k>>2]|0)+r;f=f+1|0}while((f|0)<(s|0))}p=p+1|0;if((p|0)>=(c[g>>2]|0)){h=41;break b}}if((h|0)==28){e=Na()|0;break}else if((h|0)==29){e=Na()|0;break}}else h=41;while(0);do if((h|0)==41){o=0;ha(182,b|0);b=o;o=0;if(b&1){e=Na()|0;break}d=c[t>>2]|0;e=d;if(d){f=c[v>>2]|0;if((f|0)!=(d|0))c[v>>2]=f+(~((f+-4-e|0)>>>2)<<2);cj(d)}d=c[w>>2]|0;if(!d){i=u;return}if((c[x>>2]|0)!=(d|0))c[x>>2]=d;cj(d);i=u;return}while(0);d=c[t>>2]|0;f=d;if(d){g=c[v>>2]|0;if((g|0)!=(d|0))c[v>>2]=g+(~((g+-4-f|0)>>>2)<<2);cj(d)}}d=c[w>>2]|0;if(!d)Ya(e|0);if((c[x>>2]|0)!=(d|0))c[x>>2]=d;cj(d);Ya(e|0)}function Uf(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;o=b+4580|0;e=c[o>>2]|0;r=b+156|0;if((c[r>>2]|0)<=0)return;p=b+4584|0;q=b+4588|0;h=e;i=d[e+-1>>0]|0;e=d[e>>0]|0;n=0;while(1){m=c[p>>2]|0;l=d[m+(n+-1)>>0]|0;g=n+1|0;f=d[h+g>>0]|0;k=c[q>>2]|0;j=e-i|0;h=i-l|0;k=((((a[k+(f-e)>>0]|0)*9|0)+(a[k+j>>0]|0)|0)*9|0)+(a[k+h>>0]|0)|0;if(!k){g=(Wf(b,n,0)|0)+n|0;f=c[o>>2]|0;e=d[f+(g+-1)>>0]|0;f=d[f+g>>0]|0}else{i=e-l>>31;if((i^h|0)<0)h=e;else h=l+((i^j|0)<0?0:j)|0;m=Vf(b,k,d[m+n>>0]|0,h,0)|0;a[(c[p>>2]|0)+n>>0]=m}if((g|0)>=(c[r>>2]|0))break;h=c[o>>2]|0;i=e;e=f;n=g}return}function Vf(a,d,e,f,g){a=a|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=d>>31;k=(q^d)-q|0;p=a+172+(k*12|0)+10|0;i=b[p>>1]|0;o=a+172+(k*12|0)|0;g=c[o>>2]|0;if((i|0)<(g|0))if((i<<1|0)<(g|0))if((i<<2|0)<(g|0))if((i<<3|0)<(g|0))if((i<<4|0)<(g|0)){h=5;while(1)if((i<<h|0)<(g|0))h=h+1|0;else break}else h=4;else h=3;else h=2;else h=1;else h=0;n=a+172+(k*12|0)+8|0;g=(b[n>>1]^q)-q+f|0;if((g&255|0)==(g|0))m=g;else m=g>>31&255^255;j=(e-m^q)-q<<24;l=j>>24;if(!h)g=(c[a+172+(k*12|0)+4>>2]<<1)+-1+i>>31;else g=0;g=g^l;g=g>>30^g<<1;f=g>>h;if((f|0)<23){ae(a,1,f+1|0);ae(a,g&(1<<h)+-1,h)}else{ae(a,1,24);ae(a,g+255&255,8)}f=a+172+(k*12|0)+4|0;i=b[p>>1]|0;g=i<<16>>16==64;h=g&1;e=(c[f>>2]|0)+l>>h;i=g?32:i<<16>>16;c[o>>2]=(c[o>>2]|0)+((j|0)>-16777216?l:0-l|0)>>h;h=i+1|0;b[p>>1]=h;g=h+e|0;if((g|0)<1){p=b[n>>1]|0;b[n>>1]=(p&65535)-(p<<16>>16>-128&1);p=(g|0)>(~i|0)?g:0-i|0;c[f>>2]=p;q=l^q;d=d>>>31;d=m+d|0;d=d+q|0;d=d&255;return d|0}if((e|0)<=0){p=e;c[f>>2]=p;q=l^q;d=d>>>31;d=m+d|0;d=d+q|0;d=d&255;return d|0}p=e-h|0;o=b[n>>1]|0;b[n>>1]=(o<<16>>16<127&1)+(o&65535);p=(p|0)>0?0:p;c[f>>2]=p;q=l^q;d=d>>>31;d=m+d|0;d=d+q|0;d=d&255;return d|0}function Wf(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;j=(c[b+156>>2]|0)-e|0;k=c[b+4584>>2]|0;m=c[b+4580>>2]|0;h=a[k+(e+-1)>>0]|0;g=0;while(1){f=k+(g+e)|0;if((a[f>>0]|0)!=h<<24>>24){n=g;break}a[f>>0]=h;g=g+1|0;if((g|0)==(j|0)){n=j;break}}i=h&255;h=(n|0)==(j|0);l=b+4576|0;g=c[36476+(c[l>>2]<<2)>>2]|0;if((1<<g|0)>(n|0))f=n;else{f=n;do{ae(b,1,1);g=c[l>>2]|0;f=f-(1<<c[36476+(g<<2)>>2])|0;g=(g|0)>30?31:g+1|0;c[l>>2]=g;g=c[36476+(g<<2)>>2]|0}while((f|0)>=(1<<g|0))}if(h){if(!f){b=j;return b|0}ae(b,1,1);b=j;return b|0}ae(b,f,g+1|0);f=n+e|0;h=k+f|0;g=d[h>>0]|0;f=d[m+f>>0]|0;m=i-f|0;if((((m|0)>-1?m:0-m|0)|0)<1){f=g-i<<24>>24;Xf(b,b+4564|0,f);f=f+i|0}else{m=f-i>>31|1;e=($(g-f<<24,m)|0)>>24;Xf(b,b+4552|0,e);f=($(e,m)|0)+f|0}a[h>>0]=f;b=c[l>>2]|0;c[l>>2]=(b|0)<1?0:b+-1|0;b=n+1|0;return b|0}function Xf(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=e+9|0;j=d[n>>0]|0;m=e+4|0;l=c[m>>2]|0;h=($(j>>>1,l)|0)+(c[e>>2]|0)|0;if((j|0)<(h|0)){i=j;g=0;do{i=i<<1;g=g+1|0}while((i|0)<(h|0));h=g}else h=0;if((f|0)>0&(h|0)==0?d[e+10>>0]<<1>>>0<j>>>0:0)g=1;else k=5;do if((k|0)==5){g=(f|0)<0;if(g?d[e+10>>0]<<1>>>0>=j>>>0:0){g=1;break}g=g&(h|0)!=0}while(0);g=(((f|0)>-1?f:0-f|0)<<1)-l+(g<<31>>31)|0;Yf(b,h,g,31-(c[36476+(c[b+4576>>2]<<2)>>2]|0)|0);if((f|0)<0){b=e+10|0;a[b>>0]=(d[b>>0]|0)+1}g=(g+1-(c[m>>2]|0)>>1)+(c[e>>2]|0)|0;c[e>>2]=g;h=a[n>>0]|0;if(h<<24>>24!=(a[e+8>>0]|0)){e=h;e=e&255;e=e+1|0;e=e&255;a[n>>0]=e;return}c[e>>2]=g>>1;b=(h&255)>>>1;a[n>>0]=b;e=e+10|0;a[e>>0]=(d[e>>0]|0)>>>1;e=b;e=e&255;e=e+1|0;e=e&255;a[n>>0]=e;return}function Yf(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0;e=c>>b;f=d+-8|0;if((e|0)<(d+-9|0)){if((e|0)>30){d=(e|0)/2|0;ae(a,0,d);e=e-d|0}ae(a,1,e+1|0);ae(a,(1<<b)+-1&c,b);return}if((f|0)>31){ae(a,0,31);ae(a,1,d+-39|0)}else ae(a,1,f);ae(a,c+255&255,8);return}function Zf(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;m=i;i=i+32|0;k=m;Ei(k,255,0);l=b+160|0;if(((c[k+4>>2]|0)==(c[l>>2]|0)?(c[k+8>>2]|0)==(c[b+164>>2]|0):0)?(c[k+12>>2]|0)==(c[b+168>>2]|0):0){l=c[8900]|0;c[b+4588>>2]=l+(((c[8901]|0)-l|0)>>>1);i=m;return}e=b+4592|0;f=b+4596|0;g=c[f>>2]|0;d=c[e>>2]|0;h=g-d|0;if(h>>>0>=512){if(h>>>0>512?(j=d+512|0,(g|0)!=(j|0)):0)c[f>>2]=j}else{ie(e,512-h|0);d=c[e>>2]|0}k=b+4588|0;c[k>>2]=d+256;j=b+168|0;g=b+164|0;h=-256;while(1){d=c[j>>2]|0;if((h|0)>(0-d|0)){e=c[g>>2]|0;if((h|0)>(0-e|0)){f=c[l>>2]|0;if((h|0)>(0-f|0))if((h|0)>=0){if((h|0)<1){a[(c[k>>2]|0)+h>>0]=0;h=1;continue}if((f|0)<=(h|0))if((e|0)>(h|0))d=2;else d=(d|0)>(h|0)?3:4;else d=1}else d=-1;else d=-2}else d=-3}else d=-4;a[(c[k>>2]|0)+h>>0]=d;h=h+1|0;if((h|0)==256)break}i=m;return}function _f(a){a=a|0;var b=0,d=0;c[a>>2]=35912;b=c[a+4592>>2]|0;if(b){d=a+4596|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}c[a>>2]=36612;b=c[a+120>>2]|0;if(b){d=a+124|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}d=a+92|0;b=c[d>>2]|0;c[d>>2]=0;if(b)Bb[c[(c[b>>2]|0)+4>>2]&255](b);a=a+4|0;b=c[a>>2]|0;c[a>>2]=0;if(!b)return;Bb[c[(c[b>>2]|0)+4>>2]&255](b);return}function $f(a){a=a|0;var b=0,d=0;c[a>>2]=35912;b=c[a+4592>>2]|0;if(b){d=a+4596|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}c[a>>2]=36612;b=c[a+120>>2]|0;if(b){d=a+124|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}d=a+92|0;b=c[d>>2]|0;c[d>>2]=0;if(b)Bb[c[(c[b>>2]|0)+4>>2]&255](b);d=a+4|0;b=c[d>>2]|0;c[d>>2]=0;if(!b){cj(a);return}Bb[c[(c[b>>2]|0)+4>>2]&255](b);cj(a);return}function ag(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;h=i;i=i+32|0;l=h;Ei(l,255,0);k=c[e+4>>2]|0;j=c[e+8>>2]|0;j=(j|0)==0?c[l+8>>2]|0:j;g=c[e+12>>2]|0;g=(g|0)==0?c[l+12>>2]|0:g;e=c[e+16>>2]|0;f=c[l+16>>2]|0;c[d+160>>2]=(k|0)==0?c[l+4>>2]|0:k;c[d+164>>2]=j;c[d+168>>2]=g;jg(d);g=0;do{c[d+172+(g*12|0)>>2]=4;c[d+172+(g*12|0)+4>>2]=0;b[d+172+(g*12|0)+8>>1]=0;b[d+172+(g*12|0)+10>>1]=1;g=g+1|0}while((g|0)!=365);l=((e|0)==0?f:e)&255;c[d+4552>>2]=4;c[d+4556>>2]=0;a[d+4560>>0]=l;a[d+4561>>0]=1;a[d+4562>>0]=0;c[d+4564>>2]=4;c[d+4568>>2]=1;a[d+4572>>0]=l;a[d+4573>>0]=1;a[d+4574>>0]=0;c[d+4576>>2]=0;i=h;return}function bg(d,e,f,g){d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0;o=i;i=i+16|0;m=o;l=d+92|0;k=c[e>>2]|0;c[e>>2]=0;e=c[l>>2]|0;c[l>>2]=k;if(e)Bb[c[(c[e>>2]|0)+4>>2]&255](e);c[m>>2]=0;c[m+4>>2]=g;l=f+8|0;c[m+8>>2]=c[l>>2];if(g){e=bj(4600)|0;g=d+8|0;h=e+4|0;j=g;k=h+84|0;do{c[h>>2]=c[j>>2];h=h+4|0;j=j+4|0}while((h|0)<(k|0));h=e+88|0;k=h+40|0;do{c[h>>2]=0;h=h+4|0}while((h|0)<(k|0));c[e>>2]=35688;h=e+132|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[e+148>>2]=c[g>>2];c[e+152>>2]=0;c[e+156>>2]=0;c[e+160>>2]=0;h=e+4544|0;g=e+164|0;do{c[g>>2]=0;c[g+4>>2]=0;b[g+8>>1]=0;b[g+10>>1]=1;g=g+12|0}while((g|0)!=(h|0));j=d+4|0;c[h>>2]=0;c[h+4>>2]=0;b[h+8>>1]=0;a[h+10>>0]=0;k=e+4556|0;c[k>>2]=0;c[k+4>>2]=0;b[k+8>>1]=0;a[k+10>>0]=0;k=e+4568|0;c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;c[k+20>>2]=0;c[k+24>>2]=0;a[k+28>>0]=0;if(!(c[e+28>>2]|0))c[e+20>>2]=1;g=c[j>>2]|0;c[j>>2]=e;if(g){Bb[c[(c[g>>2]|0)+4>>2]&255](g);e=c[j>>2]|0}Wd(e,m)}m=d+100|0;c[m>>2]=32;c[d+96>>2]=0;e=c[f>>2]|0;if(!e){c[d+108>>2]=c[f+4>>2];c[d+104>>2]=c[l>>2];dg(d);n=d+116|0;n=c[n>>2]|0;d=c[m>>2]|0;d=d+-32|0;d=(d|0)/8|0;d=n-d|0;i=o;return d|0}c[d+132>>2]=e;h=d+120|0;l=d+124|0;g=c[l>>2]|0;e=c[h>>2]|0;j=e;k=g-j|0;if(k>>>0>=4e3){if(k>>>0>4e3?(n=e+4e3|0,(g|0)!=(n|0)):0){c[l>>2]=n;g=n}}else{Xd(h,4e3-k|0);e=c[h>>2]|0;j=e;g=c[l>>2]|0}c[d+108>>2]=j;c[d+104>>2]=g-e;dg(d);n=d+116|0;n=c[n>>2]|0;d=c[m>>2]|0;d=d+-32|0;d=(d|0)/8|0;d=n-d|0;i=o;return d|0}function cg(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;w=i;i=i+352|0;x=w+328|0;y=w+192|0;e=w+343|0;f=w+342|0;g=w+341|0;h=w+340|0;r=w+176|0;k=w+168|0;l=w+160|0;m=w+152|0;v=w;t=w+136|0;if((c[b+32>>2]|0)!=0?(c[b+24>>2]|0)!=1:0){s=b+8|0;u=b+36|0;j=c[u>>2]|0;if(!j){b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[e>>0]|0;Aa(44,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}b=c[b+16>>2]|0;if((b|0)==8)switch(j|0){case 1:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[f>>0]|0;Aa(45,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 2:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[g>>0]|0;Aa(46,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 3:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[h>>0]|0;Aa(47,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}default:{j=y+56|0;g=y+4|0;c[y>>2]=36160;c[j>>2]=36180;o=0;ia(62,y+56|0,g|0);w=o;o=0;if(w&1){z=Na()|0;fn(j);Ya(z|0)}c[y+128>>2]=0;c[y+132>>2]=-1;c[y>>2]=36200;c[y+56>>2]=36220;o=0;ha(180,g|0);w=o;o=0;do if(w&1)b=Na()|0;else{c[g>>2]=36236;h=y+36|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[y+52>>2]=16;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;o=0;ia(63,g|0,x|0);w=o;o=0;if(w&1){b=Na()|0;Im(x);Im(h);nn(g);break}Im(x);o=0;b=ma(28,y|0,49007,21)|0;x=o;o=0;do if((!(x&1)?(o=0,p=ra(36,b|0,c[u>>2]|0)|0,x=o,o=0,!(x&1)):0)?(o=0,ma(28,p|0,50997,18)|0,x=o,o=0,!(x&1)):0){f=Ma(16)|0;o=0;ia(64,r|0,g|0);x=o;o=0;if(!(x&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,f|0,9,35648,r|0);x=o;o=0;if(x&1)e=1;else{o=0;wa(6,f|0,824,96);o=0;e=0}b=Na()|0;Im(r);if(!e)break}else b=Na()|0;La(f|0)}else z=34;while(0);if((z|0)==34)b=Na()|0;c[y>>2]=36200;c[j>>2]=36220;c[g>>2]=36236;Im(h);nn(g);fn(j);z=b;Ya(z|0)}while(0);z=b;fn(j);Ya(z|0)}}if((b|0)<=8){b=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,b|0,8,35648);z=o;o=0;if(!(z&1))lb(b|0,824,96);z=Na()|0;La(b|0);Ya(z|0)}e=16-b|0;switch(j|0){case 1:{b=bj(60)|0;c[k>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[k>>2];c[x+4>>2]=c[k+4>>2];Aa(41,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 2:{b=bj(60)|0;c[l>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[l>>2];c[x+4>>2]=c[l+4>>2];Aa(42,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 3:{b=bj(60)|0;c[m>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[m>>2];c[x+4>>2]=c[m+4>>2];Aa(43,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}default:{j=v+56|0;g=v+4|0;c[v>>2]=36160;c[j>>2]=36180;o=0;ia(62,v+56|0,g|0);y=o;o=0;if(y&1){z=Na()|0;fn(j);Ya(z|0)}c[v+128>>2]=0;c[v+132>>2]=-1;c[v>>2]=36200;c[v+56>>2]=36220;o=0;ha(180,g|0);y=o;o=0;do if(y&1)b=Na()|0;else{c[g>>2]=36236;h=v+36|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[v+52>>2]=16;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;o=0;ia(63,g|0,x|0);y=o;o=0;if(y&1){b=Na()|0;Im(x);Im(h);nn(g);break}Im(x);o=0;b=ma(28,v|0,49007,21)|0;y=o;o=0;do if((!(y&1)?(o=0,q=ra(36,b|0,c[u>>2]|0)|0,y=o,o=0,!(y&1)):0)?(o=0,ma(28,q|0,50997,18)|0,y=o,o=0,!(y&1)):0){f=Ma(16)|0;o=0;ia(64,t|0,g|0);y=o;o=0;if(!(y&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,f|0,9,35648,t|0);y=o;o=0;if(y&1)e=1;else{o=0;wa(6,f|0,824,96);o=0;e=0}b=Na()|0;Im(t);if(!e)break}else b=Na()|0;La(f|0)}else z=64;while(0);if((z|0)==64)b=Na()|0;c[v>>2]=36200;c[j>>2]=36220;c[g>>2]=36236;Im(h);nn(g);fn(j);z=b;Ya(z|0)}while(0);z=b;fn(j);Ya(z|0)}}}e=c[d+4>>2]|0;f=bj(16)|0;b=c[b+20>>2]|0;if(!e){z=c[d>>2]|0;c[f>>2]=36132;c[f+4>>2]=z;c[f+8>>2]=3;c[f+12>>2]=b;z=f;i=w;return z|0}else{c[f>>2]=36108;c[f+4>>2]=e;c[f+8>>2]=3;c[f+12>>2]=b;z=f;i=w;return z|0}return 0}function dg(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;u=i;i=i+32|0;w=u+12|0;t=u;q=b+156|0;r=(c[q>>2]|0)+4|0;if((c[b+32>>2]|0)==1)s=c[b+24>>2]|0;else s=1;d=$(s<<1,r)|0;c[w>>2]=0;x=w+4|0;c[x>>2]=0;c[w+8>>2]=0;a:do if(d){if(!(d>>>0>1431655765?(o=0,ha(178,w|0),v=o,o=0,v&1):0))h=6;if((h|0)==6?(o=0,e=ka(67,d*3|0)|0,v=o,o=0,!(v&1)):0){c[x>>2]=e;c[w>>2]=e;c[w+8>>2]=e+(d*3|0);while(1){a[e>>0]=0;a[e+1>>0]=0;a[e+2>>0]=0;e=(c[x>>2]|0)+3|0;c[x>>2]=e;d=d+-1|0;if(!d)break a}}f=Na()|0;d=c[w>>2]|0;if(!d)Ya(f|0);e=c[x>>2]|0;if((e|0)!=(d|0))c[x>>2]=e+(~(((e+-3-d|0)>>>0)/3|0)*3|0);cj(d);Ya(f|0)}while(0);c[t>>2]=0;v=t+4|0;c[v>>2]=0;c[t+8>>2]=0;do if(!s)h=19;else{if(!(s>>>0>1073741823?(o=0,ha(178,t|0),p=o,o=0,p&1):0))h=17;if((h|0)==17?(f=s<<2,o=0,g=ka(67,f|0)|0,p=o,o=0,!(p&1)):0){c[t>>2]=g;h=g+(s<<2)|0;c[t+8>>2]=h;iw(g|0,0,f|0)|0;c[v>>2]=h;h=19;break}f=Na()|0;d=c[t>>2]|0;e=d;if(d){g=c[v>>2]|0;if((g|0)!=(d|0))c[v>>2]=g+(~((g+-4-e|0)>>>2)<<2);cj(d)}}while(0);if((h|0)==19){g=b+12|0;b:do if((c[g>>2]|0)>0){h=b+4580|0;j=($(s,r)|0)+1|0;k=b+4584|0;l=b+92|0;m=(s|0)>0;n=b+4576|0;p=0;c:while(1){f=c[w>>2]|0;d=f+3|0;c[h>>2]=d;e=f+(j*3|0)|0;c[k>>2]=e;if(!(p&1))d=j;else{c[h>>2]=e;c[k>>2]=d;d=1}e=c[l>>2]|0;o=0;Aa(c[(c[e>>2]|0)+12>>2]|0,e|0,f+(d*3|0)|0,c[q>>2]|0,r|0);f=o;o=0;if(f&1){h=29;break}if(m){d=c[t>>2]|0;e=c[h>>2]|0;f=0;do{c[n>>2]=c[d+(f<<2)>>2];y=c[q>>2]|0;d=e+(y*3|0)|0;e=e+((y+-1|0)*3|0)|0;a[d>>0]=a[e>>0]|0;a[d+1>>0]=a[e+1>>0]|0;a[d+2>>0]=a[e+2>>0]|0;d=c[h>>2]|0;e=(c[k>>2]|0)+-3|0;a[e>>0]=a[d>>0]|0;a[e+1>>0]=a[d+1>>0]|0;a[e+2>>0]=a[d+2>>0]|0;o=0;ia(74,b|0,0);e=o;o=0;if(e&1){h=28;break c}d=c[t>>2]|0;c[d+(f<<2)>>2]=c[n>>2];e=(c[h>>2]|0)+(r*3|0)|0;c[h>>2]=e;c[k>>2]=(c[k>>2]|0)+(r*3|0);f=f+1|0}while((f|0)<(s|0))}p=p+1|0;if((p|0)>=(c[g>>2]|0)){h=41;break b}}if((h|0)==28){f=Na()|0;break}else if((h|0)==29){f=Na()|0;break}}else h=41;while(0);do if((h|0)==41){o=0;ha(182,b|0);y=o;o=0;if(y&1){f=Na()|0;break}d=c[t>>2]|0;e=d;if(d){f=c[v>>2]|0;if((f|0)!=(d|0))c[v>>2]=f+(~((f+-4-e|0)>>>2)<<2);cj(d)}d=c[w>>2]|0;if(!d){i=u;return}e=c[x>>2]|0;if((e|0)!=(d|0))c[x>>2]=e+(~(((e+-3-d|0)>>>0)/3|0)*3|0);cj(d);i=u;return}while(0);d=c[t>>2]|0;e=d;if(d){g=c[v>>2]|0;if((g|0)!=(d|0))c[v>>2]=g+(~((g+-4-e|0)>>>2)<<2);cj(d)}}d=c[w>>2]|0;if(!d)Ya(f|0);e=c[x>>2]|0;if((e|0)!=(d|0))c[x>>2]=e+(~(((e+-3-d|0)>>>0)/3|0)*3|0);cj(d);Ya(f|0)}function eg(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;A=b+156|0;if((c[A>>2]|0)<=0)return;B=b+4584|0;C=b+4580|0;D=b+4588|0;z=0;while(1){w=z+-1|0;i=c[B>>2]|0;j=c[C>>2]|0;e=z+1|0;h=d[j+(z*3|0)>>0]|0;y=c[D>>2]|0;k=d[j+(w*3|0)>>0]|0;l=h-k|0;m=d[i+(w*3|0)>>0]|0;n=k-m|0;o=((((a[y+((d[j+(e*3|0)>>0]|0)-h)>>0]|0)*9|0)+(a[y+l>>0]|0)|0)*9|0)+(a[y+n>>0]|0)|0;g=d[j+(z*3|0)+1>>0]|0;p=d[j+(w*3|0)+1>>0]|0;q=g-p|0;r=d[i+(w*3|0)+1>>0]|0;s=p-r|0;t=((((a[y+((d[j+(e*3|0)+1>>0]|0)-g)>>0]|0)*9|0)+(a[y+q>>0]|0)|0)*9|0)+(a[y+s>>0]|0)|0;f=d[j+(z*3|0)+2>>0]|0;u=d[j+(w*3|0)+2>>0]|0;v=f-u|0;w=d[i+(w*3|0)+2>>0]|0;x=u-w|0;y=((((a[y+((d[j+(e*3|0)+2>>0]|0)-f)>>0]|0)*9|0)+(a[y+v>>0]|0)|0)*9|0)+(a[y+x>>0]|0)|0;if(!(t|o|y))e=(fg(b,z,0)|0)+z|0;else{j=d[i+(z*3|0)>>0]|0;i=h-m>>31;if((i^n|0)>=0)if((i^l|0)<0)h=m;else h=m-k+h|0;j=gg(b,o,j,h,0)|0;i=d[(c[B>>2]|0)+(z*3|0)+1>>0]|0;h=g-r>>31;if((h^s|0)>=0)if((h^q|0)<0)g=r;else g=r-p+g|0;h=gg(b,t,i,g,0)|0;i=d[(c[B>>2]|0)+(z*3|0)+2>>0]|0;g=f-w>>31;if((g^x|0)>=0)if((g^v|0)<0)f=w;else f=w-u+f|0;y=gg(b,y,i,f,0)|0;z=(c[B>>2]|0)+(z*3|0)|0;a[z>>0]=j;a[z+1>>0]=h;a[z+2>>0]=y}if((e|0)<(c[A>>2]|0))z=e;else break}return}function fg(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;m=(c[b+156>>2]|0)-e|0;n=c[b+4584>>2]|0;o=c[b+4580>>2]|0;l=n+((e+-1|0)*3|0)|0;p=a[l>>0]|0;k=a[l+1>>0]|0;l=a[l+2>>0]|0;i=0;while(1){f=n+((i+e|0)*3|0)|0;g=f+1|0;h=f+2|0;if(!(((a[f>>0]|0)==p<<24>>24?(a[g>>0]|0)==k<<24>>24:0)&(a[h>>0]|0)==l<<24>>24))break;a[f>>0]=p;a[g>>0]=k;a[h>>0]=l;i=i+1|0;if((i|0)==(m|0)){i=m;break}}h=(i|0)==(m|0);j=b+4576|0;g=c[36476+(c[j>>2]<<2)>>2]|0;if((1<<g|0)>(i|0))f=i;else{f=i;do{ae(b,1,1);g=c[j>>2]|0;f=f-(1<<c[36476+(g<<2)>>2])|0;g=(g|0)>30?31:g+1|0;c[j>>2]=g;g=c[36476+(g<<2)>>2]|0}while((f|0)>=(1<<g|0))}if(!h){ae(b,f,g+1|0);q=i+e|0;m=n+(q*3|0)|0;n=m+1|0;r=a[n>>0]|0;e=m+2|0;f=a[e>>0]|0;o=o+(q*3|0)|0;q=a[o+1>>0]|0;t=a[o+2>>0]|0;o=d[o>>0]|0;h=o-(p&255)>>31|1;g=($((d[m>>0]|0)-o<<24,h)|0)>>24;s=b+4552|0;hg(b,s,g);p=q&255;q=p-(k&255)>>31|1;r=($((r&255)-p<<24,q)|0)>>24;hg(b,s,r);k=t&255;l=k-(l&255)>>31|1;f=($((f&255)-k<<24,l)|0)>>24;hg(b,s,f);p=($(r,q)|0)+p&255;b=($(f,l)|0)+k&255;a[m>>0]=($(g,h)|0)+o;a[n>>0]=p;a[e>>0]=b;b=c[j>>2]|0;c[j>>2]=(b|0)<1?0:b+-1|0;b=i+1|0;return b|0}if(!f){t=m;return t|0}ae(b,1,1);t=m;return t|0}function gg(a,d,e,f,g){a=a|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;q=d>>31;k=(q^d)-q|0;p=a+172+(k*12|0)+10|0;i=b[p>>1]|0;o=a+172+(k*12|0)|0;g=c[o>>2]|0;if((i|0)<(g|0))if((i<<1|0)<(g|0))if((i<<2|0)<(g|0))if((i<<3|0)<(g|0))if((i<<4|0)<(g|0)){h=5;while(1)if((i<<h|0)<(g|0))h=h+1|0;else break}else h=4;else h=3;else h=2;else h=1;else h=0;n=a+172+(k*12|0)+8|0;g=(b[n>>1]^q)-q+f|0;if((g&255|0)==(g|0))m=g;else m=g>>31&255^255;j=(e-m^q)-q<<24;l=j>>24;if(!h)g=(c[a+172+(k*12|0)+4>>2]<<1)+-1+i>>31;else g=0;g=g^l;g=g>>30^g<<1;f=g>>h;if((f|0)<23){ae(a,1,f+1|0);ae(a,g&(1<<h)+-1,h)}else{ae(a,1,24);ae(a,g+255&255,8)}f=a+172+(k*12|0)+4|0;i=b[p>>1]|0;g=i<<16>>16==64;h=g&1;e=(c[f>>2]|0)+l>>h;i=g?32:i<<16>>16;c[o>>2]=(c[o>>2]|0)+((j|0)>-16777216?l:0-l|0)>>h;h=i+1|0;b[p>>1]=h;g=h+e|0;if((g|0)<1){p=b[n>>1]|0;b[n>>1]=(p&65535)-(p<<16>>16>-128&1);p=(g|0)>(~i|0)?g:0-i|0;c[f>>2]=p;q=l^q;d=d>>>31;d=m+d|0;d=d+q|0;d=d&255;return d|0}if((e|0)<=0){p=e;c[f>>2]=p;q=l^q;d=d>>>31;d=m+d|0;d=d+q|0;d=d&255;return d|0}p=e-h|0;o=b[n>>1]|0;b[n>>1]=(o<<16>>16<127&1)+(o&65535);p=(p|0)>0?0:p;c[f>>2]=p;q=l^q;d=d>>>31;d=m+d|0;d=d+q|0;d=d&255;return d|0}function hg(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=e+9|0;j=d[n>>0]|0;m=e+4|0;l=c[m>>2]|0;h=($(j>>>1,l)|0)+(c[e>>2]|0)|0;if((j|0)<(h|0)){i=j;g=0;do{i=i<<1;g=g+1|0}while((i|0)<(h|0));h=g}else h=0;if((f|0)>0&(h|0)==0?d[e+10>>0]<<1>>>0<j>>>0:0)g=1;else k=5;do if((k|0)==5){g=(f|0)<0;if(g?d[e+10>>0]<<1>>>0>=j>>>0:0){g=1;break}g=g&(h|0)!=0}while(0);g=(((f|0)>-1?f:0-f|0)<<1)-l+(g<<31>>31)|0;ig(b,h,g,31-(c[36476+(c[b+4576>>2]<<2)>>2]|0)|0);if((f|0)<0){b=e+10|0;a[b>>0]=(d[b>>0]|0)+1}g=(g+1-(c[m>>2]|0)>>1)+(c[e>>2]|0)|0;c[e>>2]=g;h=a[n>>0]|0;if(h<<24>>24!=(a[e+8>>0]|0)){e=h;e=e&255;e=e+1|0;e=e&255;a[n>>0]=e;return}c[e>>2]=g>>1;b=(h&255)>>>1;a[n>>0]=b;e=e+10|0;a[e>>0]=(d[e>>0]|0)>>>1;e=b;e=e&255;e=e+1|0;e=e&255;a[n>>0]=e;return}function ig(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0;e=c>>b;f=d+-8|0;if((e|0)<(d+-9|0)){if((e|0)>30){d=(e|0)/2|0;ae(a,0,d);e=e-d|0}ae(a,1,e+1|0);ae(a,(1<<b)+-1&c,b);return}if((f|0)>31){ae(a,0,31);ae(a,1,d+-39|0)}else ae(a,1,f);ae(a,c+255&255,8);return}function jg(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;m=i;i=i+32|0;k=m;Ei(k,255,0);l=b+160|0;if(((c[k+4>>2]|0)==(c[l>>2]|0)?(c[k+8>>2]|0)==(c[b+164>>2]|0):0)?(c[k+12>>2]|0)==(c[b+168>>2]|0):0){l=c[8900]|0;c[b+4588>>2]=l+(((c[8901]|0)-l|0)>>>1);i=m;return}e=b+4592|0;f=b+4596|0;g=c[f>>2]|0;d=c[e>>2]|0;h=g-d|0;if(h>>>0>=512){if(h>>>0>512?(j=d+512|0,(g|0)!=(j|0)):0)c[f>>2]=j}else{ie(e,512-h|0);d=c[e>>2]|0}k=b+4588|0;c[k>>2]=d+256;j=b+168|0;g=b+164|0;h=-256;while(1){d=c[j>>2]|0;if((h|0)>(0-d|0)){e=c[g>>2]|0;if((h|0)>(0-e|0)){f=c[l>>2]|0;if((h|0)>(0-f|0))if((h|0)>=0){if((h|0)<1){a[(c[k>>2]|0)+h>>0]=0;h=1;continue}if((f|0)<=(h|0))if((e|0)>(h|0))d=2;else d=(d|0)>(h|0)?3:4;else d=1}else d=-1;else d=-2}else d=-3}else d=-4;a[(c[k>>2]|0)+h>>0]=d;h=h+1|0;if((h|0)==256)break}i=m;return}function kg(a){a=a|0;var b=0,d=0;c[a>>2]=35884;b=c[a+4616>>2]|0;if(b){d=a+4620|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}c[a>>2]=36612;b=c[a+120>>2]|0;if(b){d=a+124|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}d=a+92|0;b=c[d>>2]|0;c[d>>2]=0;if(b)Bb[c[(c[b>>2]|0)+4>>2]&255](b);a=a+4|0;b=c[a>>2]|0;c[a>>2]=0;if(!b)return;Bb[c[(c[b>>2]|0)+4>>2]&255](b);return}function lg(a){a=a|0;var b=0,d=0;c[a>>2]=35884;b=c[a+4616>>2]|0;if(b){d=a+4620|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}c[a>>2]=36612;b=c[a+120>>2]|0;if(b){d=a+124|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}d=a+92|0;b=c[d>>2]|0;c[d>>2]=0;if(b)Bb[c[(c[b>>2]|0)+4>>2]&255](b);d=a+4|0;b=c[d>>2]|0;c[d>>2]=0;if(!b){cj(a);return}Bb[c[(c[b>>2]|0)+4>>2]&255](b);cj(a);return}function mg(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;k=i;i=i+32|0;m=k;Ei(m,c[d+136>>2]|0,c[d+144>>2]|0);l=c[e+4>>2]|0;j=c[e+8>>2]|0;j=(j|0)==0?c[m+8>>2]|0:j;h=c[e+12>>2]|0;h=(h|0)==0?c[m+12>>2]|0:h;f=c[e+16>>2]|0;g=c[m+16>>2]|0;c[d+184>>2]=(l|0)==0?c[m+4>>2]|0:l;c[d+188>>2]=j;c[d+192>>2]=h;wg(d);h=d+140|0;e=(c[h>>2]|0)+32|0;e=(e|0)<128?2:(e|0)/64|0;j=0;do{c[d+196+(j*12|0)>>2]=e;c[d+196+(j*12|0)+4>>2]=0;b[d+196+(j*12|0)+8>>1]=0;b[d+196+(j*12|0)+10>>1]=1;j=j+1|0}while((j|0)!=365);l=(c[h>>2]|0)+32|0;l=(l|0)<128?2:(l|0)/64|0;m=((f|0)==0?g:f)&255;c[d+4576>>2]=l;c[d+4580>>2]=0;a[d+4584>>0]=m;a[d+4585>>0]=1;a[d+4586>>0]=0;c[d+4588>>2]=l;c[d+4592>>2]=1;a[d+4596>>0]=m;a[d+4597>>0]=1;a[d+4598>>0]=0;c[d+4600>>2]=0;i=k;return}function ng(d,e,f,g){d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0;o=i;i=i+16|0;m=o;l=d+92|0;k=c[e>>2]|0;c[e>>2]=0;e=c[l>>2]|0;c[l>>2]=k;if(e)Bb[c[(c[e>>2]|0)+4>>2]&255](e);c[m>>2]=0;c[m+4>>2]=g;l=f+8|0;c[m+8>>2]=c[l>>2];if(g){e=bj(4624)|0;g=d+8|0;h=e+4|0;j=g;k=h+84|0;do{c[h>>2]=c[j>>2];h=h+4|0;j=j+4|0}while((h|0)<(k|0));h=e+88|0;k=h+40|0;do{c[h>>2]=0;h=h+4|0}while((h|0)<(k|0));c[e>>2]=35660;c[e+128>>2]=c[d+136>>2];c[e+132>>2]=c[d+140>>2];c[e+136>>2]=c[d+144>>2];c[e+140>>2]=c[d+148>>2];c[e+144>>2]=c[d+152>>2];c[e+148>>2]=c[d+156>>2];c[e+152>>2]=c[d+160>>2];h=e+156|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[e+172>>2]=c[g>>2];c[e+176>>2]=0;c[e+180>>2]=0;c[e+184>>2]=0;h=e+4568|0;g=e+188|0;do{c[g>>2]=0;c[g+4>>2]=0;b[g+8>>1]=0;b[g+10>>1]=1;g=g+12|0}while((g|0)!=(h|0));j=d+4|0;c[h>>2]=0;c[h+4>>2]=0;b[h+8>>1]=0;a[h+10>>0]=0;k=e+4580|0;c[k>>2]=0;c[k+4>>2]=0;b[k+8>>1]=0;a[k+10>>0]=0;k=e+4592|0;c[k>>2]=0;c[k+4>>2]=0;c[k+8>>2]=0;c[k+12>>2]=0;c[k+16>>2]=0;c[k+20>>2]=0;c[k+24>>2]=0;a[k+28>>0]=0;if(!(c[e+28>>2]|0))c[e+20>>2]=1;g=c[j>>2]|0;c[j>>2]=e;if(g){Bb[c[(c[g>>2]|0)+4>>2]&255](g);e=c[j>>2]|0}Wd(e,m)}m=d+100|0;c[m>>2]=32;c[d+96>>2]=0;e=c[f>>2]|0;if(!e){c[d+108>>2]=c[f+4>>2];c[d+104>>2]=c[l>>2];pg(d);n=d+116|0;n=c[n>>2]|0;d=c[m>>2]|0;d=d+-32|0;d=(d|0)/8|0;d=n-d|0;i=o;return d|0}c[d+132>>2]=e;h=d+120|0;l=d+124|0;g=c[l>>2]|0;e=c[h>>2]|0;j=e;k=g-j|0;if(k>>>0>=4e3){if(k>>>0>4e3?(n=e+4e3|0,(g|0)!=(n|0)):0){c[l>>2]=n;g=n}}else{Xd(h,4e3-k|0);e=c[h>>2]|0;j=e;g=c[l>>2]|0}c[d+108>>2]=j;c[d+104>>2]=g-e;pg(d);n=d+116|0;n=c[n>>2]|0;d=c[m>>2]|0;d=d+-32|0;d=(d|0)/8|0;d=n-d|0;i=o;return d|0}
function og(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;w=i;i=i+352|0;x=w+328|0;y=w+192|0;e=w+343|0;f=w+342|0;g=w+341|0;h=w+340|0;r=w+176|0;k=w+168|0;l=w+160|0;m=w+152|0;v=w;t=w+136|0;if((c[b+32>>2]|0)!=0?(c[b+24>>2]|0)!=1:0){s=b+8|0;u=b+36|0;j=c[u>>2]|0;if(!j){b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[e>>0]|0;Aa(44,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}b=c[b+16>>2]|0;if((b|0)==8)switch(j|0){case 1:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[f>>0]|0;Aa(45,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 2:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[g>>0]|0;Aa(46,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 3:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[h>>0]|0;Aa(47,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}default:{j=y+56|0;g=y+4|0;c[y>>2]=36160;c[j>>2]=36180;o=0;ia(62,y+56|0,g|0);w=o;o=0;if(w&1){z=Na()|0;fn(j);Ya(z|0)}c[y+128>>2]=0;c[y+132>>2]=-1;c[y>>2]=36200;c[y+56>>2]=36220;o=0;ha(180,g|0);w=o;o=0;do if(w&1)b=Na()|0;else{c[g>>2]=36236;h=y+36|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[y+52>>2]=16;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;o=0;ia(63,g|0,x|0);w=o;o=0;if(w&1){b=Na()|0;Im(x);Im(h);nn(g);break}Im(x);o=0;b=ma(28,y|0,49007,21)|0;x=o;o=0;do if((!(x&1)?(o=0,p=ra(36,b|0,c[u>>2]|0)|0,x=o,o=0,!(x&1)):0)?(o=0,ma(28,p|0,50997,18)|0,x=o,o=0,!(x&1)):0){f=Ma(16)|0;o=0;ia(64,r|0,g|0);x=o;o=0;if(!(x&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,f|0,9,35648,r|0);x=o;o=0;if(x&1)e=1;else{o=0;wa(6,f|0,824,96);o=0;e=0}b=Na()|0;Im(r);if(!e)break}else b=Na()|0;La(f|0)}else z=34;while(0);if((z|0)==34)b=Na()|0;c[y>>2]=36200;c[j>>2]=36220;c[g>>2]=36236;Im(h);nn(g);fn(j);z=b;Ya(z|0)}while(0);z=b;fn(j);Ya(z|0)}}if((b|0)<=8){b=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,b|0,8,35648);z=o;o=0;if(!(z&1))lb(b|0,824,96);z=Na()|0;La(b|0);Ya(z|0)}e=16-b|0;switch(j|0){case 1:{b=bj(60)|0;c[k>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[k>>2];c[x+4>>2]=c[k+4>>2];Aa(41,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 2:{b=bj(60)|0;c[l>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[l>>2];c[x+4>>2]=c[l+4>>2];Aa(42,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 3:{b=bj(60)|0;c[m>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[m>>2];c[x+4>>2]=c[m+4>>2];Aa(43,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}default:{j=v+56|0;g=v+4|0;c[v>>2]=36160;c[j>>2]=36180;o=0;ia(62,v+56|0,g|0);y=o;o=0;if(y&1){z=Na()|0;fn(j);Ya(z|0)}c[v+128>>2]=0;c[v+132>>2]=-1;c[v>>2]=36200;c[v+56>>2]=36220;o=0;ha(180,g|0);y=o;o=0;do if(y&1)b=Na()|0;else{c[g>>2]=36236;h=v+36|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[v+52>>2]=16;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;o=0;ia(63,g|0,x|0);y=o;o=0;if(y&1){b=Na()|0;Im(x);Im(h);nn(g);break}Im(x);o=0;b=ma(28,v|0,49007,21)|0;y=o;o=0;do if((!(y&1)?(o=0,q=ra(36,b|0,c[u>>2]|0)|0,y=o,o=0,!(y&1)):0)?(o=0,ma(28,q|0,50997,18)|0,y=o,o=0,!(y&1)):0){f=Ma(16)|0;o=0;ia(64,t|0,g|0);y=o;o=0;if(!(y&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,f|0,9,35648,t|0);y=o;o=0;if(y&1)e=1;else{o=0;wa(6,f|0,824,96);o=0;e=0}b=Na()|0;Im(t);if(!e)break}else b=Na()|0;La(f|0)}else z=64;while(0);if((z|0)==64)b=Na()|0;c[v>>2]=36200;c[j>>2]=36220;c[g>>2]=36236;Im(h);nn(g);fn(j);z=b;Ya(z|0)}while(0);z=b;fn(j);Ya(z|0)}}}e=c[d+4>>2]|0;f=bj(16)|0;b=c[b+20>>2]|0;if(!e){z=c[d>>2]|0;c[f>>2]=36132;c[f+4>>2]=z;c[f+8>>2]=1;c[f+12>>2]=b;z=f;i=w;return z|0}else{c[f>>2]=36108;c[f+4>>2]=e;c[f+8>>2]=1;c[f+12>>2]=b;z=f;i=w;return z|0}return 0}function pg(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;u=i;i=i+32|0;w=u+12|0;t=u;r=b+180|0;s=(c[r>>2]|0)+4|0;if((c[b+32>>2]|0)==1)p=c[b+24>>2]|0;else p=1;d=$(p<<1,s)|0;c[w>>2]=0;x=w+4|0;c[x>>2]=0;c[w+8>>2]=0;a:do if(d){if(!((d|0)<0?(o=0,ha(178,w|0),v=o,o=0,v&1):0))q=6;if((q|0)==6?(o=0,e=ka(67,d|0)|0,v=o,o=0,!(v&1)):0){c[x>>2]=e;c[w>>2]=e;c[w+8>>2]=e+d;while(1){a[e>>0]=0;e=(c[x>>2]|0)+1|0;c[x>>2]=e;d=d+-1|0;if(!d)break a}}e=Na()|0;d=c[w>>2]|0;if(!d)Ya(e|0);if((c[x>>2]|0)!=(d|0))c[x>>2]=d;cj(d);Ya(e|0)}while(0);c[t>>2]=0;v=t+4|0;c[v>>2]=0;c[t+8>>2]=0;do if(!p)q=19;else{if(!(p>>>0>1073741823?(o=0,ha(178,t|0),n=o,o=0,n&1):0))q=17;if((q|0)==17?(f=p<<2,o=0,g=ka(67,f|0)|0,n=o,o=0,!(n&1)):0){c[t>>2]=g;q=g+(p<<2)|0;c[t+8>>2]=q;iw(g|0,0,f|0)|0;c[v>>2]=q;q=19;break}e=Na()|0;d=c[t>>2]|0;f=d;if(d){g=c[v>>2]|0;if((g|0)!=(d|0))c[v>>2]=g+(~((g+-4-f|0)>>>2)<<2);cj(d)}}while(0);if((q|0)==19){j=b+12|0;b:do if((c[j>>2]|0)>0){k=b+4604|0;l=($(p,s)|0)+1|0;m=b+4608|0;n=b+92|0;h=b+4600|0;if((p|0)>0)g=0;else{f=0;while(1){e=c[w>>2]|0;d=e+1|0;c[k>>2]=d;e=e+l|0;c[m>>2]=e;if(!(f&1))d=e;else{c[k>>2]=e;c[m>>2]=d}p=c[n>>2]|0;o=0;Aa(c[(c[p>>2]|0)+12>>2]|0,p|0,d|0,c[r>>2]|0,s|0);p=o;o=0;if(p&1)break;f=f+1|0;if((f|0)>=(c[j>>2]|0)){q=45;break b}}e=Na()|0;break}c:while(1){e=c[w>>2]|0;d=e+1|0;c[k>>2]=d;e=e+l|0;c[m>>2]=e;if(!(g&1))d=e;else{c[k>>2]=e;c[m>>2]=d}q=c[n>>2]|0;o=0;Aa(c[(c[q>>2]|0)+12>>2]|0,q|0,d|0,c[r>>2]|0,s|0);q=o;o=0;if(q&1){q=28;break}d=c[t>>2]|0;e=c[k>>2]|0;f=0;do{c[h>>2]=c[d+(f<<2)>>2];q=c[r>>2]|0;a[e+q>>0]=a[e+(q+-1)>>0]|0;a[(c[m>>2]|0)+-1>>0]=a[c[k>>2]>>0]|0;o=0;ia(75,b|0,0);q=o;o=0;if(q&1){q=36;break c}d=c[t>>2]|0;c[d+(f<<2)>>2]=c[h>>2];e=(c[k>>2]|0)+s|0;c[k>>2]=e;c[m>>2]=(c[m>>2]|0)+s;f=f+1|0}while((f|0)<(p|0));g=g+1|0;if((g|0)>=(c[j>>2]|0)){q=45;break b}}if((q|0)==28){e=Na()|0;break}else if((q|0)==36){e=Na()|0;break}}else q=45;while(0);do if((q|0)==45){o=0;ha(182,b|0);b=o;o=0;if(b&1){e=Na()|0;break}d=c[t>>2]|0;e=d;if(d){f=c[v>>2]|0;if((f|0)!=(d|0))c[v>>2]=f+(~((f+-4-e|0)>>>2)<<2);cj(d)}d=c[w>>2]|0;if(!d){i=u;return}if((c[x>>2]|0)!=(d|0))c[x>>2]=d;cj(d);i=u;return}while(0);d=c[t>>2]|0;f=d;if(d){g=c[v>>2]|0;if((g|0)!=(d|0))c[v>>2]=g+(~((g+-4-f|0)>>>2)<<2);cj(d)}}d=c[w>>2]|0;if(!d)Ya(e|0);if((c[x>>2]|0)!=(d|0))c[x>>2]=d;cj(d);Ya(e|0)}function qg(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;o=b+4604|0;e=c[o>>2]|0;r=b+180|0;if((c[r>>2]|0)<=0)return;p=b+4608|0;q=b+4612|0;h=e;i=d[e+-1>>0]|0;e=d[e>>0]|0;n=0;while(1){m=c[p>>2]|0;l=d[m+(n+-1)>>0]|0;g=n+1|0;f=d[h+g>>0]|0;k=c[q>>2]|0;j=e-i|0;h=i-l|0;k=((((a[k+(f-e)>>0]|0)*9|0)+(a[k+j>>0]|0)|0)*9|0)+(a[k+h>>0]|0)|0;if(!k){g=(sg(b,n,0)|0)+n|0;f=c[o>>2]|0;e=d[f+(g+-1)>>0]|0;f=d[f+g>>0]|0}else{i=e-l>>31;if((i^h|0)<0)h=e;else h=l+((i^j|0)<0?0:j)|0;m=rg(b,k,d[m+n>>0]|0,h,0)|0;a[(c[p>>2]|0)+n>>0]=m}if((g|0)>=(c[r>>2]|0))break;h=c[o>>2]|0;i=e;e=f;n=g}return}function rg(a,d,e,f,g){a=a|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;r=d>>31;h=(r^d)-r|0;p=a+196+(h*12|0)+10|0;i=b[p>>1]|0;o=a+196+(h*12|0)|0;g=c[o>>2]|0;if((i|0)<(g|0))if((i<<1|0)<(g|0))if((i<<2|0)<(g|0))if((i<<3|0)<(g|0))if((i<<4|0)<(g|0)){d=5;while(1)if((i<<d|0)<(g|0))d=d+1|0;else break}else d=4;else d=3;else d=2;else d=1;else d=0;m=a+196+(h*12|0)+8|0;g=(b[m>>1]^r)-r+f|0;q=a+136|0;f=c[q>>2]|0;if((g&f|0)==(g|0))l=g;else l=f&~(g>>31);g=(e-l^r)-r|0;k=a+144|0;f=c[k>>2]|0;if((g|0)>0)g=(g+f|0)/(f<<1|1|0)|0;else g=(g-f|0)/(f<<1|1|0)|0;n=a+140|0;j=c[n>>2]|0;e=((g|0)<0?j:0)+g|0;j=e-((e|0)<((j+1|0)/2|0|0)?0:j)|0;h=a+196+(h*12|0)+4|0;if(!(f|d))g=(c[h>>2]<<1)+-1+i>>31;else g=0;f=g^j;vg(a,d,f>>30^f<<1,c[a+156>>2]|0);f=c[a+160>>2]|0;d=(c[o>>2]|0)+((j|0)>-1?j:0-j|0)|0;g=(c[h>>2]|0)+($(c[k>>2]<<1|1,j)|0)|0;e=b[p>>1]|0;if((e|0)==(f|0)){d=d>>1;g=g>>1;e=f>>1}c[o>>2]=d;f=e+1|0;b[p>>1]=f;d=f+g|0;if((d|0)>=1){if((g|0)>0){g=g-f|0;p=b[m>>1]|0;b[m>>1]=(p<<16>>16<127&1)+(p&65535);g=(g|0)>0?0:g}}else{g=b[m>>1]|0;b[m>>1]=(g&65535)-(g<<16>>16>-128&1);g=(d|0)>(~e|0)?d:0-e|0}c[h>>2]=g;f=c[k>>2]|0;e=f<<1|1;d=($(e,(j^r)-r|0)|0)+l|0;if((d|0)>=(0-f|0)){g=c[q>>2]|0;if((g+f|0)<(d|0))d=d-($(c[n>>2]|0,e)|0)|0}else{d=($(c[n>>2]|0,e)|0)+d|0;g=c[q>>2]|0}if((d&g|0)==(d|0)){r=d;r=r&255;return r|0}r=g&~(d>>31);r=r&255;return r|0}function sg(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;l=(c[b+180>>2]|0)-e|0;m=c[b+4608>>2]|0;n=c[b+4604>>2]|0;h=a[m+(e+-1)>>0]|0;k=h&255;f=b+144|0;i=0;while(1){g=m+(i+e)|0;j=(d[g>>0]|0)-k|0;if((((j|0)>-1?j:0-j|0)|0)>(c[f>>2]|0))break;a[g>>0]=h;i=i+1|0;if((i|0)==(l|0)){i=l;break}}h=(i|0)==(l|0);j=b+4600|0;g=c[36476+(c[j>>2]<<2)>>2]|0;if((1<<g|0)>(i|0))f=i;else{f=i;do{ae(b,1,1);g=c[j>>2]|0;f=f-(1<<c[36476+(g<<2)>>2])|0;g=(g|0)>30?31:g+1|0;c[j>>2]=g;g=c[36476+(g<<2)>>2]|0}while((f|0)>=(1<<g|0))}if(!h){ae(b,f,g+1|0);l=i+e|0;e=m+l|0;a[e>>0]=tg(b,d[e>>0]|0,k,d[n+l>>0]|0)|0;b=c[j>>2]|0;c[j>>2]=(b|0)<1?0:b+-1|0;b=i+1|0;return b|0}if(!f){b=l;return b|0}ae(b,1,1);b=l;return b|0}function tg(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;i=d-e|0;j=a+136|0;h=a+144|0;f=c[h>>2]|0;if((((i|0)>-1?i:0-i|0)|0)>(f|0)){g=e-d>>31|1;b=$(g,b-e|0)|0;if((b|0)>0)b=(f+b|0)/(f<<1|1|0)|0;else b=(b-f|0)/(f<<1|1|0)|0;i=a+140|0;f=c[i>>2]|0;d=((b|0)<0?f:0)+b|0;f=d-((d|0)<((f+1|0)/2|0|0)?0:f)|0;ug(a,a+4576|0,f);f=$(f,g)|0;g=c[h>>2]|0;h=g<<1|1;f=($(f,h)|0)+e|0;if((f|0)>=(0-g|0)){b=c[j>>2]|0;if((b+g|0)<(f|0))f=f-($(c[i>>2]|0,h)|0)|0}else{f=($(c[i>>2]|0,h)|0)+f|0;b=c[j>>2]|0}if((f&b|0)==(f|0)){j=f;j=j&255;return j|0}j=b&~(f>>31);j=j&255;return j|0}else{b=b-d|0;if((b|0)>0)b=(f+b|0)/(f<<1|1|0)|0;else b=(b-f|0)/(f<<1|1|0)|0;i=a+140|0;f=c[i>>2]|0;g=((b|0)<0?f:0)+b|0;f=g-((g|0)<((f+1|0)/2|0|0)?0:f)|0;ug(a,a+4588|0,f);g=c[h>>2]|0;h=g<<1|1;f=($(h,f)|0)+d|0;if((f|0)>=(0-g|0)){b=c[j>>2]|0;if((b+g|0)<(f|0))f=f-($(c[i>>2]|0,h)|0)|0}else{f=($(c[i>>2]|0,h)|0)+f|0;b=c[j>>2]|0}if((f&b|0)==(f|0)){j=f;j=j&255;return j|0}j=b&~(f>>31);j=j&255;return j|0}return 0}function ug(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;n=e+9|0;j=d[n>>0]|0;m=e+4|0;l=c[m>>2]|0;h=($(j>>>1,l)|0)+(c[e>>2]|0)|0;if((j|0)<(h|0)){i=j;g=0;do{i=i<<1;g=g+1|0}while((i|0)<(h|0));h=g}else h=0;if((f|0)>0&(h|0)==0?d[e+10>>0]<<1>>>0<j>>>0:0)g=1;else k=5;do if((k|0)==5){g=(f|0)<0;if(g?d[e+10>>0]<<1>>>0>=j>>>0:0){g=1;break}g=g&(h|0)!=0}while(0);g=(((f|0)>-1?f:0-f|0)<<1)-l+(g<<31>>31)|0;vg(b,h,g,(c[b+156>>2]|0)+-1-(c[36476+(c[b+4600>>2]<<2)>>2]|0)|0);if((f|0)<0){b=e+10|0;a[b>>0]=(d[b>>0]|0)+1}g=(g+1-(c[m>>2]|0)>>1)+(c[e>>2]|0)|0;c[e>>2]=g;h=a[n>>0]|0;if(h<<24>>24!=(a[e+8>>0]|0)){e=h;e=e&255;e=e+1|0;e=e&255;a[n>>0]=e;return}c[e>>2]=g>>1;b=(h&255)>>>1;a[n>>0]=b;e=e+10|0;a[e>>0]=(d[e>>0]|0)>>>1;e=b;e=e&255;e=e+1|0;e=e&255;a[n>>0]=e;return}function vg(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=d>>b;g=a+148|0;h=e-(c[g>>2]|0)|0;if((f|0)<(h+-1|0)){if((f|0)>30){e=(f|0)/2|0;ae(a,0,e);f=f-e|0}ae(a,1,f+1|0);ae(a,(1<<b)+-1&d,b);return}if((h|0)>31){ae(a,0,31);ae(a,1,e+-31-(c[g>>2]|0)|0)}else ae(a,1,h);b=c[g>>2]|0;ae(a,(1<<b)+-1&d+-1,b);return}function wg(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=i;i=i+32|0;f=p;o=b+144|0;a:do if(!(c[o>>2]|0)){e=c[b+136>>2]|0;d=b+152|0;if((((e|0)==((1<<c[d>>2])+-1|0)?(Ei(f,e,0),(c[f+4>>2]|0)==(c[b+184>>2]|0)):0)?(c[f+8>>2]|0)==(c[b+188>>2]|0):0)?(c[f+12>>2]|0)==(c[b+192>>2]|0):0)switch(c[d>>2]|0){case 8:{o=c[8900]|0;c[b+4612>>2]=o+(((c[8901]|0)-o|0)>>>1);i=p;return}case 10:{o=c[8903]|0;c[b+4612>>2]=o+(((c[8904]|0)-o|0)>>>1);i=p;return}case 12:{o=c[8906]|0;c[b+4612>>2]=o+(((c[8907]|0)-o|0)>>>1);i=p;return}case 16:{o=c[8909]|0;c[b+4612>>2]=o+(((c[8910]|0)-o|0)>>>1);i=p;return}default:break a}}else d=b+152|0;while(0);n=1<<c[d>>2];e=b+4616|0;f=n<<1;g=b+4620|0;h=c[g>>2]|0;d=c[e>>2]|0;j=h-d|0;if(f>>>0<=j>>>0){if(f>>>0<j>>>0?(k=d+f|0,(h|0)!=(k|0)):0)c[g>>2]=k}else{ie(e,f-j|0);d=c[e>>2]|0}m=b+4612|0;c[m>>2]=d+n;d=0-n|0;if((n|0)<=(d|0)){i=p;return}k=b+192|0;l=b+188|0;j=b+184|0;h=d;do{d=c[k>>2]|0;if((h|0)>(0-d|0)){e=c[l>>2]|0;if((h|0)>(0-e|0)){f=c[j>>2]|0;if((h|0)>(0-f|0)){g=c[o>>2]|0;if((h|0)>=(0-g|0))if((g|0)<(h|0))if((f|0)<=(h|0))if((e|0)>(h|0))d=2;else d=(d|0)>(h|0)?3:4;else d=1;else d=0;else d=-1}else d=-2}else d=-3}else d=-4;a[(c[m>>2]|0)+h>>0]=d;h=h+1|0}while((h|0)!=(n|0));i=p;return}function xg(a){a=a|0;var b=0,d=0;c[a>>2]=35856;b=c[a+4608>>2]|0;if(b){d=a+4612|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}c[a>>2]=36736;b=c[a+92>>2]|0;if(b){d=a+96|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}a=a+88|0;b=c[a>>2]|0;c[a>>2]=0;if(!b)return;Bb[c[(c[b>>2]|0)+4>>2]&255](b);return}function yg(a){a=a|0;var b=0,d=0;c[a>>2]=35856;b=c[a+4608>>2]|0;if(b){d=a+4612|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}c[a>>2]=36736;b=c[a+92>>2]|0;if(b){d=a+96|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}d=a+88|0;b=c[d>>2]|0;c[d>>2]=0;if(!b){cj(a);return}Bb[c[(c[b>>2]|0)+4>>2]&255](b);cj(a);return}function zg(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;w=i;i=i+352|0;x=w+328|0;y=w+192|0;e=w+343|0;f=w+342|0;g=w+341|0;h=w+340|0;r=w+176|0;k=w+168|0;l=w+160|0;m=w+152|0;v=w;t=w+136|0;if((c[b+28>>2]|0)!=0?(c[b+20>>2]|0)!=1:0){s=b+4|0;u=b+32|0;j=c[u>>2]|0;if(!j){b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[e>>0]|0;Aa(37,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}b=c[b+12>>2]|0;if((b|0)==16)switch(j|0){case 1:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[f>>0]|0;Aa(38,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 2:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[g>>0]|0;Aa(39,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 3:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[h>>0]|0;Aa(40,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}default:{j=y+56|0;g=y+4|0;c[y>>2]=36160;c[j>>2]=36180;o=0;ia(62,y+56|0,g|0);w=o;o=0;if(w&1){z=Na()|0;fn(j);Ya(z|0)}c[y+128>>2]=0;c[y+132>>2]=-1;c[y>>2]=36200;c[y+56>>2]=36220;o=0;ha(180,g|0);w=o;o=0;do if(w&1)b=Na()|0;else{c[g>>2]=36236;h=y+36|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[y+52>>2]=16;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;o=0;ia(63,g|0,x|0);w=o;o=0;if(w&1){b=Na()|0;Im(x);Im(h);nn(g);break}Im(x);o=0;b=ma(28,y|0,49007,21)|0;x=o;o=0;do if((!(x&1)?(o=0,p=ra(36,b|0,c[u>>2]|0)|0,x=o,o=0,!(x&1)):0)?(o=0,ma(28,p|0,50997,18)|0,x=o,o=0,!(x&1)):0){f=Ma(16)|0;o=0;ia(64,r|0,g|0);x=o;o=0;if(!(x&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,f|0,9,35648,r|0);x=o;o=0;if(x&1)e=1;else{o=0;wa(6,f|0,824,96);o=0;e=0}b=Na()|0;Im(r);if(!e)break}else b=Na()|0;La(f|0)}else z=34;while(0);if((z|0)==34)b=Na()|0;c[y>>2]=36200;c[j>>2]=36220;c[g>>2]=36236;Im(h);nn(g);fn(j);z=b;Ya(z|0)}while(0);z=b;fn(j);Ya(z|0)}}if((b|0)<=8){b=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,b|0,8,35648);z=o;o=0;if(!(z&1))lb(b|0,824,96);z=Na()|0;La(b|0);Ya(z|0)}e=16-b|0;switch(j|0){case 1:{b=bj(60)|0;c[k>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[k>>2];c[x+4>>2]=c[k+4>>2];Aa(41,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 2:{b=bj(60)|0;c[l>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[l>>2];c[x+4>>2]=c[l+4>>2];Aa(42,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 3:{b=bj(60)|0;c[m>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[m>>2];c[x+4>>2]=c[m+4>>2];Aa(43,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}default:{j=v+56|0;g=v+4|0;c[v>>2]=36160;c[j>>2]=36180;o=0;ia(62,v+56|0,g|0);y=o;o=0;if(y&1){z=Na()|0;fn(j);Ya(z|0)}c[v+128>>2]=0;c[v+132>>2]=-1;c[v>>2]=36200;c[v+56>>2]=36220;o=0;ha(180,g|0);y=o;o=0;do if(y&1)b=Na()|0;else{c[g>>2]=36236;h=v+36|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[v+52>>2]=16;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;o=0;ia(63,g|0,x|0);y=o;o=0;if(y&1){b=Na()|0;Im(x);Im(h);nn(g);break}Im(x);o=0;b=ma(28,v|0,49007,21)|0;y=o;o=0;do if((!(y&1)?(o=0,q=ra(36,b|0,c[u>>2]|0)|0,y=o,o=0,!(y&1)):0)?(o=0,ma(28,q|0,50997,18)|0,y=o,o=0,!(y&1)):0){f=Ma(16)|0;o=0;ia(64,t|0,g|0);y=o;o=0;if(!(y&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,f|0,9,35648,t|0);y=o;o=0;if(y&1)e=1;else{o=0;wa(6,f|0,824,96);o=0;e=0}b=Na()|0;Im(t);if(!e)break}else b=Na()|0;La(f|0)}else z=64;while(0);if((z|0)==64)b=Na()|0;c[v>>2]=36200;c[j>>2]=36220;c[g>>2]=36236;Im(h);nn(g);fn(j);z=b;Ya(z|0)}while(0);z=b;fn(j);Ya(z|0)}}}e=c[d+4>>2]|0;f=bj(16)|0;b=c[b+16>>2]|0;if(!e){z=c[d>>2]|0;c[f>>2]=36132;c[f+4>>2]=z;c[f+8>>2]=2;c[f+12>>2]=b;z=f;i=w;return z|0}else{c[f>>2]=36108;c[f+4>>2]=e;c[f+8>>2]=2;c[f+12>>2]=b;z=f;i=w;return z|0}return 0}function Ag(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;k=i;i=i+32|0;m=k;Ei(m,c[d+128>>2]|0,c[d+136>>2]|0);l=c[e+4>>2]|0;j=c[e+8>>2]|0;j=(j|0)==0?c[m+8>>2]|0:j;h=c[e+12>>2]|0;h=(h|0)==0?c[m+12>>2]|0:h;f=c[e+16>>2]|0;g=c[m+16>>2]|0;c[d+176>>2]=(l|0)==0?c[m+4>>2]|0:l;c[d+180>>2]=j;c[d+184>>2]=h;Lg(d);h=d+132|0;e=(c[h>>2]|0)+32|0;e=(e|0)<128?2:(e|0)/64|0;j=0;do{c[d+188+(j*12|0)>>2]=e;c[d+188+(j*12|0)+4>>2]=0;b[d+188+(j*12|0)+8>>1]=0;b[d+188+(j*12|0)+10>>1]=1;j=j+1|0}while((j|0)!=365);l=(c[h>>2]|0)+32|0;l=(l|0)<128?2:(l|0)/64|0;m=((f|0)==0?g:f)&255;c[d+4568>>2]=l;c[d+4572>>2]=0;a[d+4576>>0]=m;a[d+4577>>0]=1;a[d+4578>>0]=0;c[d+4580>>2]=l;c[d+4584>>2]=1;a[d+4588>>0]=m;a[d+4589>>0]=1;a[d+4590>>0]=0;c[d+4592>>2]=0;i=k;return}function Bg(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0;i=b+88|0;h=c[d>>2]|0;c[d>>2]=0;d=c[i>>2]|0;c[i>>2]=h;if(d)Bb[c[(c[d>>2]|0)+4>>2]&255](d);i=f+4|0;h=c[i>>2]|0;a[b+4620>>0]=g&1;d=b+156|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];Wd(b,f);Cg(b);d=c[b+116>>2]|0;b=c[b+112>>2]|0;while(1){g=d+-1|0;e=(a[g>>0]|0)==-1?7:8;if((b|0)<(e|0))break;else{d=g;b=b-e|0}}d=d-h|0;g=c[i>>2]|0;if(!g)return;c[i>>2]=g+d;f=f+8|0;c[f>>2]=(c[f>>2]|0)-d;return}function Cg(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;A=i;i=i+32|0;C=A+12|0;z=A;w=a+172|0;x=(c[w>>2]|0)+4|0;if((c[a+28>>2]|0)==1)y=c[a+20>>2]|0;else y=1;d=$(y<<1,x)|0;c[C>>2]=0;D=C+4|0;c[D>>2]=0;c[C+8>>2]=0;do if(d){if(!((d|0)<0?(o=0,ha(178,C|0),B=o,o=0,B&1):0))j=6;if((j|0)==6?(e=d<<1,o=0,f=ka(67,e|0)|0,B=o,o=0,!(B&1)):0){c[C>>2]=f;B=f+(d<<1)|0;c[C+8>>2]=B;iw(f|0,0,e|0)|0;c[D>>2]=B;break}f=Na()|0;d=c[C>>2]|0;if(!d)Ya(f|0);e=c[D>>2]|0;if((e|0)!=(d|0))c[D>>2]=e+(~((e+-2-d|0)>>>1)<<1);cj(d);Ya(f|0)}while(0);c[z>>2]=0;B=z+4|0;c[B>>2]=0;c[z+8>>2]=0;do if(!y)j=18;else{if(!(y>>>0>1073741823?(o=0,ha(178,z|0),v=o,o=0,v&1):0))j=16;if((j|0)==16?(g=y<<2,o=0,h=ka(67,g|0)|0,v=o,o=0,!(v&1)):0){c[z>>2]=h;j=h+(y<<2)|0;c[z+8>>2]=j;iw(h|0,0,g|0)|0;c[B>>2]=j;j=18;break}f=Na()|0;d=c[z>>2]|0;e=d;if(d){g=c[B>>2]|0;if((g|0)!=(d|0))c[B>>2]=g+(~((g+-4-e|0)>>>2)<<2);cj(d)}}while(0);if((j|0)==18){h=a+8|0;a:do if((c[h>>2]|0)>0){j=a+4596|0;k=$(y,x)|0;l=k+1|0;m=a+4600|0;n=(y|0)>0;p=a+160|0;q=a+168|0;r=a+164|0;s=a+156|0;t=a+88|0;u=a+4592|0;v=0;b:while(1){f=c[C>>2]|0;e=f+2|0;c[j>>2]=e;f=f+(l<<1)|0;c[m>>2]=f;if(!(v&1))d=f;else{c[j>>2]=f;c[m>>2]=e;d=e;e=f}if(n){g=c[z>>2]|0;f=0;do{c[u>>2]=c[g+(f<<2)>>2];g=c[w>>2]|0;b[e+(g<<1)>>1]=b[e+(g+-1<<1)>>1]|0;b[d+-2>>1]=b[e>>1]|0;o=0;ia(76,a|0,0);g=o;o=0;if(g&1){j=29;break b}g=c[z>>2]|0;c[g+(f<<2)>>2]=c[u>>2];e=(c[j>>2]|0)+(x<<1)|0;c[j>>2]=e;d=(c[m>>2]|0)+(x<<1)|0;c[m>>2]=d;f=f+1|0}while((f|0)<(y|0))}g=c[p>>2]|0;if(((g|0)<=(v|0)?(v|0)<((c[q>>2]|0)+g|0):0)?(g=c[t>>2]|0,o=0,Aa(c[(c[g>>2]|0)+8>>2]|0,g|0,d+((c[s>>2]|0)-k<<1)|0,c[r>>2]|0,x|0),g=o,o=0,g&1):0){j=30;break}v=v+1|0;if((v|0)>=(c[h>>2]|0)){j=42;break a}}if((j|0)==29){f=Na()|0;break}else if((j|0)==30){f=Na()|0;break}}else j=42;while(0);do if((j|0)==42){o=0;ha(183,a|0);a=o;o=0;if(a&1){f=Na()|0;break}d=c[z>>2]|0;e=d;if(d){f=c[B>>2]|0;if((f|0)!=(d|0))c[B>>2]=f+(~((f+-4-e|0)>>>2)<<2);cj(d)}d=c[C>>2]|0;if(!d){i=A;return}e=c[D>>2]|0;if((e|0)!=(d|0))c[D>>2]=e+(~((e+-2-d|0)>>>1)<<1);cj(d);i=A;return}while(0);d=c[z>>2]|0;e=d;if(d){g=c[B>>2]|0;if((g|0)!=(d|0))c[B>>2]=g+(~((g+-4-e|0)>>>2)<<2);cj(d)}}d=c[C>>2]|0;if(!d)Ya(f|0);e=c[D>>2]|0;if((e|0)!=(d|0))c[D>>2]=e+(~((e+-2-d|0)>>>1)<<1);cj(d);Ya(f|0)}function Dg(d,f){d=d|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;q=d+4596|0;g=c[q>>2]|0;u=d+172|0;f=c[u>>2]|0;if((f|0)<=0)return;r=d+4600|0;s=d+4604|0;t=d+4592|0;l=g;j=e[g+-2>>1]|0;g=e[g>>1]|0;p=0;while(1){n=c[r>>2]|0;k=b[n+(p+-1<<1)>>1]|0;o=k&65535;i=p+1|0;h=e[l+(i<<1)>>1]|0;m=c[s>>2]|0;l=g-j|0;j=j-o|0;m=((((a[m+(h-g)>>0]|0)*9|0)+(a[m+l>>0]|0)|0)*9|0)+(a[m+j>>0]|0)|0;n=n+(p<<1)|0;if(!m){f=Gg(d,k,n,f-p|0)|0;g=f+p|0;if((g|0)!=(c[u>>2]|0)){o=Hg(d,o,e[(c[q>>2]|0)+(g<<1)>>1]|0)|0;b[(c[r>>2]|0)+(g<<1)>>1]=o;o=c[t>>2]|0;c[t>>2]=(o|0)<1?0:o+-1|0;f=f+1|0}i=f+p|0;h=c[q>>2]|0;g=e[h+(i+-1<<1)>>1]|0;h=e[h+(i<<1)>>1]|0}else{f=g-o>>31;if((f^j|0)<0)f=g;else f=o+((f^l|0)<0?0:l)|0;o=Fg(d,m,e[n>>1]|0,f,0)|0;b[(c[r>>2]|0)+(p<<1)>>1]=o}f=c[u>>2]|0;if((f|0)<=(i|0))break;l=c[q>>2]|0;j=g;g=h;p=i}return}function Eg(b){b=b|0;var d=0,e=0,f=0,g=0;f=b+116|0;e=c[f>>2]|0;if((a[e>>0]|0)!=-1){g=b+112|0;d=c[g>>2]|0;if((d|0)<1){ge(b);d=c[g>>2]|0;e=c[f>>2]|0}b=b+108|0;f=c[b>>2]|0;c[g>>2]=d+-1;d=f<<1;c[b>>2]=d;if((a[e>>0]|0)!=-1){d=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,d|0,6,35648);b=o;o=0;if(!(b&1))lb(d|0,824,96);b=Na()|0;La(d|0);Ya(b|0)}}else d=c[b+108>>2]|0;if(!d)return;d=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,d|0,6,35648);b=o;o=0;if(!(b&1))lb(d|0,824,96);b=Na()|0;La(d|0);Ya(b|0)}function Fg(d,e,f,g,h){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0,t=0;t=e>>31;l=(t^e)-t|0;r=d+188+(l*12|0)+10|0;f=b[r>>1]|0;q=d+188+(l*12|0)|0;h=c[q>>2]|0;if((f|0)<(h|0))if((f<<1|0)<(h|0))if((f<<2|0)<(h|0))if((f<<3|0)<(h|0))if((f<<4|0)<(h|0)){e=5;while(1)if((f<<e|0)<(h|0))e=e+1|0;else break}else e=4;else e=3;else e=2;else e=1;else e=0;p=d+188+(l*12|0)+8|0;f=(b[p>>1]^t)-t+g|0;s=d+128|0;h=c[s>>2]|0;if((f&h|0)==(f|0))m=f;else m=h&~(f>>31);f=d+112|0;if((c[f>>2]|0)<8)ge(d);h=d+108|0;g=c[h>>2]|0;i=g>>>24;j=c[2832+(e<<11)+(i<<3)+4>>2]|0;if(!j){k=c[d+148>>2]|0;h=c[d+140>>2]|0;f=Jg(d)|0;if((f|0)<(k+-1-h|0)){if(e)f=(Kg(d,e)|0)+(f<<e)|0}else f=(Kg(d,h)|0)+1|0;f=f<<31>>31^f>>1;if((((f|0)>-1?f:0-f|0)|0)>65535){f=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,f|0,5,35648);d=o;o=0;if(d&1){d=Na()|0;La(f|0);Ya(d|0)}else lb(f|0,824,96)}}else{c[f>>2]=(c[f>>2]|0)-j;c[h>>2]=g<<j;f=c[2832+(e<<11)+(i<<3)>>2]|0}k=d+136|0;g=c[k>>2]|0;if(!e){if(!g)h=(c[d+188+(l*12|0)+4>>2]<<1)+-1+(b[r>>1]|0)>>31;else h=0;j=h^f}else j=f;e=c[d+152>>2]|0;h=(c[q>>2]|0)+((j|0)>-1?j:0-j|0)|0;i=d+188+(l*12|0)+4|0;f=(c[i>>2]|0)+($(g<<1|1,j)|0)|0;g=b[r>>1]|0;if((g|0)==(e|0)){h=h>>1;f=f>>1;g=e>>1}c[q>>2]=h;e=g+1|0;b[r>>1]=e;h=e+f|0;if((h|0)>=1){if((f|0)>0){f=f-e|0;r=b[p>>1]|0;b[p>>1]=(r<<16>>16<127&1)+(r&65535);f=(f|0)>0?0:f}}else{f=b[p>>1]|0;b[p>>1]=(f&65535)-(f<<16>>16>-128&1);f=(h|0)>(~g|0)?h:0-g|0}c[i>>2]=f;e=c[k>>2]|0;g=e<<1|1;h=($(g,(j^t)-t|0)|0)+m|0;if((h|0)>=(0-e|0)){f=c[s>>2]|0;if((f+e|0)<(h|0))h=h-($(c[d+132>>2]|0,g)|0)|0}else{h=($(c[d+132>>2]|0,g)|0)+h|0;f=c[s>>2]|0}if((h&f|0)==(h|0)){d=h;d=d&65535;return d|0}d=f&~(h>>31);d=d&65535;return d|0}function Gg(d,e,f,g){d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0;k=d+112|0;l=d+108|0;m=d+4592|0;h=c[k>>2]|0;i=0;while(1){if((h|0)<1){ge(d);h=c[k>>2]|0}j=c[l>>2]|0;h=h+-1|0;c[k>>2]=h;c[l>>2]=j<<1;if((j|0)>=0){p=8;break}j=c[m>>2]|0;q=1<<c[36476+(j<<2)>>2];r=g-i|0;r=(q|0)<(r|0)?q:r;i=r+i|0;if((r|0)==(q|0))c[m>>2]=(j|0)>30?31:j+1|0;if((i|0)==(g|0)){h=g;break}}if((p|0)==8)if((i|0)!=(g|0)){h=c[m>>2]|0;if((h+-4|0)>>>0<28)h=Kg(d,c[36476+(h<<2)>>2]|0)|0;else h=0;h=h+i|0;if((h|0)>(g|0)){h=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,h|0,5,35648);r=o;o=0;if(r&1){r=Na()|0;La(h|0);Ya(r|0)}else lb(h|0,824,96)}}else h=g;if((h|0)>0)i=0;else return h|0;do{b[f+(i<<1)>>1]=e;i=i+1|0}while((i|0)!=(h|0));return h|0}function Hg(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;g=b-d|0;h=a+128|0;e=a+136|0;if((((g|0)>-1?g:0-g|0)|0)>(c[e>>2]|0)){b=$(Ig(a,a+4568|0)|0,d-b>>31|1)|0;f=c[e>>2]|0;g=f<<1|1;b=($(b,g)|0)+d|0;if((b|0)>=(0-f|0)){e=c[h>>2]|0;if((e+f|0)<(b|0))b=b-($(c[a+132>>2]|0,g)|0)|0}else{b=($(c[a+132>>2]|0,g)|0)+b|0;e=c[h>>2]|0}if((b&e|0)==(b|0)){a=b;a=a&65535;return a|0}a=e&~(b>>31);a=a&65535;return a|0}else{d=Ig(a,a+4580|0)|0;g=c[e>>2]|0;f=g<<1|1;b=($(f,d)|0)+b|0;if((b|0)>=(0-g|0)){e=c[h>>2]|0;if((e+g|0)<(b|0))b=b-($(c[a+132>>2]|0,f)|0)|0}else{b=($(c[a+132>>2]|0,f)|0)+b|0;e=c[h>>2]|0}if((b&e|0)==(b|0)){a=b;a=a&65535;return a|0}a=e&~(b>>31);a=a&65535;return a|0}return 0}function Ig(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;m=e+9|0;f=d[m>>0]|0;i=e+4|0;h=($(f>>>1,c[i>>2]|0)|0)+(c[e>>2]|0)|0;if((f|0)<(h|0)){g=0;do{f=f<<1;g=g+1|0}while((f|0)<(h|0))}else g=0;j=c[b+148>>2]|0;k=c[36476+(c[b+4592>>2]<<2)>>2]|0;f=c[b+140>>2]|0;h=Jg(b)|0;do if((h|0)<(j+-2-k-f|0))if(!g){g=c[i>>2]|0;b=g+h|0;f=b&1;b=(f+b|0)/2|0;l=8;break}else{k=(Kg(b,g)|0)+(h<<g)|0;g=c[i>>2]|0;h=k+g|0;j=h&1;f=j;i=1;h=(j+h|0)/2|0;break}else{h=(Kg(b,f)|0)+1|0;j=c[i>>2]|0;b=h+j|0;f=b&1;b=(f+b|0)/2|0;if(!g){g=j;l=8}else{k=h;i=1;h=b;g=j}}while(0);if((l|0)==8){k=h;i=d[e+10>>0]<<1>>>0>=(d[m>>0]|0)>>>0;h=b}h=(f|0)!=0^i?h:0-h|0;if((h|0)<0){l=e+10|0;a[l>>0]=(d[l>>0]|0)+1}f=(k+1-g>>1)+(c[e>>2]|0)|0;c[e>>2]=f;g=a[m>>0]|0;if(g<<24>>24!=(a[e+8>>0]|0)){e=g;e=e&255;e=e+1|0;e=e&255;a[m>>0]=e;return h|0}c[e>>2]=f>>1;l=(g&255)>>>1;a[m>>0]=l;e=e+10|0;a[e>>0]=(d[e>>0]|0)>>>1;e=l;e=e&255;e=e+1|0;e=e&255;a[m>>0]=e;return h|0}function Jg(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;g=a+112|0;if((c[g>>2]|0)<16)ge(a);h=a+108|0;d=c[h>>2]|0;if((d|0)>=0)if(!(d&1073741824))if(!(d&536870912))if(!(d&268435456))if(!(d&134217728))if(!(d&67108864))if(!(d&33554432))if(!(d&16777216))if(!(d&8388608))if(!(d&4194304))if(!(d&2097152))if(!(d&1048576))if(!(d&524288))if(!(d&262144))if(!(d&131072)){f=d>>>12&16;b=f+-1|0;if(!f){b=(c[g>>2]|0)+-15|0;c[g>>2]=b;e=d<<15;c[h>>2]=e;d=b;b=15;while(1){if((d|0)<1){ge(a);f=c[h>>2]|0;d=c[g>>2]|0}else f=e;d=d+-1|0;c[g>>2]=d;e=f<<1;c[h>>2]=e;if((f|0)<0)break;else b=b+1|0}return b|0}}else b=14;else b=13;else b=12;else b=11;else b=10;else b=9;else b=8;else b=7;else b=6;else b=5;else b=4;else b=3;else b=2;else b=1;else b=0;a=b+1|0;c[g>>2]=(c[g>>2]|0)-a;c[h>>2]=d<<a;h=b;return h|0}function Kg(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;f=b+112|0;e=c[f>>2]|0;if((e|0)<(d|0)){ge(b);e=c[f>>2]|0;if((e|0)<(d|0)){e=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,e|0,5,35648);b=o;o=0;if(b&1){b=Na()|0;La(e|0);Ya(b|0)}else lb(e|0,824,96)}}g=b+108|0;b=c[g>>2]|0;c[f>>2]=e-d;c[g>>2]=b<<d;return b>>>(32-d|0)|0}function Lg(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=i;i=i+32|0;f=p;o=b+136|0;a:do if(!(c[o>>2]|0)){e=c[b+128>>2]|0;d=b+144|0;if((((e|0)==((1<<c[d>>2])+-1|0)?(Ei(f,e,0),(c[f+4>>2]|0)==(c[b+176>>2]|0)):0)?(c[f+8>>2]|0)==(c[b+180>>2]|0):0)?(c[f+12>>2]|0)==(c[b+184>>2]|0):0)switch(c[d>>2]|0){case 8:{o=c[8900]|0;c[b+4604>>2]=o+(((c[8901]|0)-o|0)>>>1);i=p;return}case 10:{o=c[8903]|0;c[b+4604>>2]=o+(((c[8904]|0)-o|0)>>>1);i=p;return}case 12:{o=c[8906]|0;c[b+4604>>2]=o+(((c[8907]|0)-o|0)>>>1);i=p;return}case 16:{o=c[8909]|0;c[b+4604>>2]=o+(((c[8910]|0)-o|0)>>>1);i=p;return}default:break a}}else d=b+144|0;while(0);n=1<<c[d>>2];e=b+4608|0;f=n<<1;g=b+4612|0;h=c[g>>2]|0;d=c[e>>2]|0;j=h-d|0;if(f>>>0<=j>>>0){if(f>>>0<j>>>0?(k=d+f|0,(h|0)!=(k|0)):0)c[g>>2]=k}else{ie(e,f-j|0);d=c[e>>2]|0}m=b+4604|0;c[m>>2]=d+n;d=0-n|0;if((n|0)<=(d|0)){i=p;return}k=b+184|0;l=b+180|0;j=b+176|0;h=d;do{d=c[k>>2]|0;if((h|0)>(0-d|0)){e=c[l>>2]|0;if((h|0)>(0-e|0)){f=c[j>>2]|0;if((h|0)>(0-f|0)){g=c[o>>2]|0;if((h|0)>=(0-g|0))if((g|0)<(h|0))if((f|0)<=(h|0))if((e|0)>(h|0))d=2;else d=(d|0)>(h|0)?3:4;else d=1;else d=0;else d=-1}else d=-2}else d=-3}else d=-4;a[(c[m>>2]|0)+h>>0]=d;h=h+1|0}while((h|0)!=(n|0));i=p;return}function Mg(a){a=a|0;var b=0,d=0;c[a>>2]=36736;b=c[a+92>>2]|0;if(b){d=a+96|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}a=a+88|0;b=c[a>>2]|0;c[a>>2]=0;if(!b)return;Bb[c[(c[b>>2]|0)+4>>2]&255](b);return}function Ng(a){a=a|0;var b=0,d=0;c[a>>2]=36736;b=c[a+92>>2]|0;if(b){d=a+96|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}d=a+88|0;b=c[d>>2]|0;c[d>>2]=0;if(!b){cj(a);return}Bb[c[(c[b>>2]|0)+4>>2]&255](b);cj(a);return}function Og(a){a=a|0;var b=0,d=0;c[a>>2]=35828;b=c[a+4608>>2]|0;if(b){d=a+4612|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}c[a>>2]=36736;b=c[a+92>>2]|0;if(b){d=a+96|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}a=a+88|0;b=c[a>>2]|0;c[a>>2]=0;if(!b)return;Bb[c[(c[b>>2]|0)+4>>2]&255](b);return}function Pg(a){a=a|0;var b=0,d=0;c[a>>2]=35828;b=c[a+4608>>2]|0;if(b){d=a+4612|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}c[a>>2]=36736;b=c[a+92>>2]|0;if(b){d=a+96|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}d=a+88|0;b=c[d>>2]|0;c[d>>2]=0;if(!b){cj(a);return}Bb[c[(c[b>>2]|0)+4>>2]&255](b);cj(a);return}function Qg(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;w=i;i=i+352|0;x=w+328|0;y=w+192|0;e=w+343|0;f=w+342|0;g=w+341|0;h=w+340|0;r=w+176|0;k=w+168|0;l=w+160|0;m=w+152|0;v=w;t=w+136|0;if((c[b+28>>2]|0)!=0?(c[b+20>>2]|0)!=1:0){s=b+4|0;u=b+32|0;j=c[u>>2]|0;if(!j){b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[e>>0]|0;Aa(37,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}b=c[b+12>>2]|0;if((b|0)==16)switch(j|0){case 1:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[f>>0]|0;Aa(38,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 2:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[g>>0]|0;Aa(39,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 3:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[h>>0]|0;Aa(40,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}default:{j=y+56|0;g=y+4|0;c[y>>2]=36160;c[j>>2]=36180;o=0;ia(62,y+56|0,g|0);w=o;o=0;if(w&1){z=Na()|0;fn(j);Ya(z|0)}c[y+128>>2]=0;c[y+132>>2]=-1;c[y>>2]=36200;c[y+56>>2]=36220;o=0;ha(180,g|0);w=o;o=0;do if(w&1)b=Na()|0;else{c[g>>2]=36236;h=y+36|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[y+52>>2]=16;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;o=0;ia(63,g|0,x|0);w=o;o=0;if(w&1){b=Na()|0;Im(x);Im(h);nn(g);break}Im(x);o=0;b=ma(28,y|0,49007,21)|0;x=o;o=0;do if((!(x&1)?(o=0,p=ra(36,b|0,c[u>>2]|0)|0,x=o,o=0,!(x&1)):0)?(o=0,ma(28,p|0,50997,18)|0,x=o,o=0,!(x&1)):0){f=Ma(16)|0;o=0;ia(64,r|0,g|0);x=o;o=0;if(!(x&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,f|0,9,35648,r|0);x=o;o=0;if(x&1)e=1;else{o=0;wa(6,f|0,824,96);o=0;e=0}b=Na()|0;Im(r);if(!e)break}else b=Na()|0;La(f|0)}else z=34;while(0);if((z|0)==34)b=Na()|0;c[y>>2]=36200;c[j>>2]=36220;c[g>>2]=36236;Im(h);nn(g);fn(j);z=b;Ya(z|0)}while(0);z=b;fn(j);Ya(z|0)}}if((b|0)<=8){b=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,b|0,8,35648);z=o;o=0;if(!(z&1))lb(b|0,824,96);z=Na()|0;La(b|0);Ya(z|0)}e=16-b|0;switch(j|0){case 1:{b=bj(60)|0;c[k>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[k>>2];c[x+4>>2]=c[k+4>>2];Aa(41,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 2:{b=bj(60)|0;c[l>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[l>>2];c[x+4>>2]=c[l+4>>2];Aa(42,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 3:{b=bj(60)|0;c[m>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[m>>2];c[x+4>>2]=c[m+4>>2];Aa(43,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}default:{j=v+56|0;g=v+4|0;c[v>>2]=36160;c[j>>2]=36180;o=0;ia(62,v+56|0,g|0);y=o;o=0;if(y&1){z=Na()|0;fn(j);Ya(z|0)}c[v+128>>2]=0;c[v+132>>2]=-1;c[v>>2]=36200;c[v+56>>2]=36220;o=0;ha(180,g|0);y=o;o=0;do if(y&1)b=Na()|0;else{c[g>>2]=36236;h=v+36|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[v+52>>2]=16;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;o=0;ia(63,g|0,x|0);y=o;o=0;if(y&1){b=Na()|0;Im(x);Im(h);nn(g);break}Im(x);o=0;b=ma(28,v|0,49007,21)|0;y=o;o=0;do if((!(y&1)?(o=0,q=ra(36,b|0,c[u>>2]|0)|0,y=o,o=0,!(y&1)):0)?(o=0,ma(28,q|0,50997,18)|0,y=o,o=0,!(y&1)):0){f=Ma(16)|0;o=0;ia(64,t|0,g|0);y=o;o=0;if(!(y&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,f|0,9,35648,t|0);y=o;o=0;if(y&1)e=1;else{o=0;wa(6,f|0,824,96);o=0;e=0}b=Na()|0;Im(t);if(!e)break}else b=Na()|0;La(f|0)}else z=64;while(0);if((z|0)==64)b=Na()|0;c[v>>2]=36200;c[j>>2]=36220;c[g>>2]=36236;Im(h);nn(g);fn(j);z=b;Ya(z|0)}while(0);z=b;fn(j);Ya(z|0)}}}e=c[d+4>>2]|0;f=bj(16)|0;b=c[b+16>>2]|0;if(!e){z=c[d>>2]|0;c[f>>2]=36132;c[f+4>>2]=z;c[f+8>>2]=6;c[f+12>>2]=b;z=f;i=w;return z|0}else{c[f>>2]=36108;c[f+4>>2]=e;c[f+8>>2]=6;c[f+12>>2]=b;z=f;i=w;return z|0}return 0}function Rg(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;k=i;i=i+32|0;m=k;Ei(m,c[d+128>>2]|0,c[d+136>>2]|0);l=c[e+4>>2]|0;j=c[e+8>>2]|0;j=(j|0)==0?c[m+8>>2]|0:j;h=c[e+12>>2]|0;h=(h|0)==0?c[m+12>>2]|0:h;f=c[e+16>>2]|0;g=c[m+16>>2]|0;c[d+176>>2]=(l|0)==0?c[m+4>>2]|0:l;c[d+180>>2]=j;c[d+184>>2]=h;Zg(d);h=d+132|0;e=(c[h>>2]|0)+32|0;e=(e|0)<128?2:(e|0)/64|0;j=0;do{c[d+188+(j*12|0)>>2]=e;c[d+188+(j*12|0)+4>>2]=0;b[d+188+(j*12|0)+8>>1]=0;b[d+188+(j*12|0)+10>>1]=1;j=j+1|0}while((j|0)!=365);l=(c[h>>2]|0)+32|0;l=(l|0)<128?2:(l|0)/64|0;m=((f|0)==0?g:f)&255;c[d+4568>>2]=l;c[d+4572>>2]=0;a[d+4576>>0]=m;a[d+4577>>0]=1;a[d+4578>>0]=0;c[d+4580>>2]=l;c[d+4584>>2]=1;a[d+4588>>0]=m;a[d+4589>>0]=1;a[d+4590>>0]=0;c[d+4592>>2]=0;i=k;return}function Sg(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0;i=b+88|0;h=c[d>>2]|0;c[d>>2]=0;d=c[i>>2]|0;c[i>>2]=h;if(d)Bb[c[(c[d>>2]|0)+4>>2]&255](d);i=f+4|0;h=c[i>>2]|0;a[b+4620>>0]=g&1;d=b+156|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];Wd(b,f);Tg(b);d=c[b+116>>2]|0;b=c[b+112>>2]|0;while(1){g=d+-1|0;e=(a[g>>0]|0)==-1?7:8;if((b|0)<(e|0))break;else{d=g;b=b-e|0}}d=d-h|0;g=c[i>>2]|0;if(!g)return;c[i>>2]=g+d;f=f+8|0;c[f>>2]=(c[f>>2]|0)-d;return}function Tg(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;A=i;i=i+32|0;C=A+12|0;z=A;w=a+172|0;x=(c[w>>2]|0)+4|0;if((c[a+28>>2]|0)==1)y=c[a+20>>2]|0;else y=1;d=$(y<<1,x)|0;c[C>>2]=0;D=C+4|0;c[D>>2]=0;c[C+8>>2]=0;do if(d){if(!(d>>>0>715827882?(o=0,ha(178,C|0),B=o,o=0,B&1):0))j=6;if((j|0)==6?(o=0,e=ka(67,d*6|0)|0,B=o,o=0,!(B&1)):0){c[D>>2]=e;c[C>>2]=e;f=e+(d*6|0)|0;c[C+8>>2]=f;while(1){b[e>>1]=0;b[e+2>>1]=0;b[e+4>>1]=0;d=d+-1|0;if(!d)break;else e=e+6|0}c[D>>2]=f;break}f=Na()|0;d=c[C>>2]|0;if(!d)Ya(f|0);e=c[D>>2]|0;if((e|0)!=(d|0))c[D>>2]=e+(~(((e+-6-d|0)>>>0)/6|0)*6|0);cj(d);Ya(f|0)}while(0);c[z>>2]=0;B=z+4|0;c[B>>2]=0;c[z+8>>2]=0;do if(!y)j=20;else{if(!(y>>>0>1073741823?(o=0,ha(178,z|0),v=o,o=0,v&1):0))j=18;if((j|0)==18?(g=y<<2,o=0,h=ka(67,g|0)|0,v=o,o=0,!(v&1)):0){c[z>>2]=h;j=h+(y<<2)|0;c[z+8>>2]=j;iw(h|0,0,g|0)|0;c[B>>2]=j;j=20;break}f=Na()|0;d=c[z>>2]|0;e=d;if(d){g=c[B>>2]|0;if((g|0)!=(d|0))c[B>>2]=g+(~((g+-4-e|0)>>>2)<<2);cj(d)}}while(0);if((j|0)==20){h=a+8|0;a:do if((c[h>>2]|0)>0){j=a+4596|0;k=$(y,x)|0;l=k+1|0;m=a+4600|0;n=(y|0)>0;p=a+160|0;q=a+168|0;r=a+164|0;s=a+156|0;t=a+88|0;u=a+4592|0;v=0;b:while(1){f=c[C>>2]|0;e=f+6|0;c[j>>2]=e;f=f+(l*6|0)|0;c[m>>2]=f;if(!(v&1))d=f;else{c[j>>2]=f;c[m>>2]=e;d=e;e=f}if(n){g=c[z>>2]|0;f=0;do{c[u>>2]=c[g+(f<<2)>>2];d=c[w>>2]|0;g=e+(d*6|0)|0;e=e+((d+-1|0)*6|0)|0;b[g>>1]=b[e>>1]|0;b[g+2>>1]=b[e+2>>1]|0;b[g+4>>1]=b[e+4>>1]|0;g=(c[m>>2]|0)+-6|0;e=c[j>>2]|0;b[g>>1]=b[e>>1]|0;b[g+2>>1]=b[e+2>>1]|0;b[g+4>>1]=b[e+4>>1]|0;o=0;ia(77,a|0,0);g=o;o=0;if(g&1){j=31;break b}g=c[z>>2]|0;c[g+(f<<2)>>2]=c[u>>2];e=(c[j>>2]|0)+(x*6|0)|0;c[j>>2]=e;d=(c[m>>2]|0)+(x*6|0)|0;c[m>>2]=d;f=f+1|0}while((f|0)<(y|0))}g=c[p>>2]|0;if(((g|0)<=(v|0)?(v|0)<((c[q>>2]|0)+g|0):0)?(g=c[t>>2]|0,o=0,Aa(c[(c[g>>2]|0)+8>>2]|0,g|0,d+(((c[s>>2]|0)-k|0)*6|0)|0,c[r>>2]|0,x|0),g=o,o=0,g&1):0){j=32;break}v=v+1|0;if((v|0)>=(c[h>>2]|0)){j=44;break a}}if((j|0)==31){f=Na()|0;break}else if((j|0)==32){f=Na()|0;break}}else j=44;while(0);do if((j|0)==44){o=0;ha(183,a|0);a=o;o=0;if(a&1){f=Na()|0;break}d=c[z>>2]|0;e=d;if(d){f=c[B>>2]|0;if((f|0)!=(d|0))c[B>>2]=f+(~((f+-4-e|0)>>>2)<<2);cj(d)}d=c[C>>2]|0;if(!d){i=A;return}e=c[D>>2]|0;if((e|0)!=(d|0))c[D>>2]=e+(~(((e+-6-d|0)>>>0)/6|0)*6|0);cj(d);i=A;return}while(0);d=c[z>>2]|0;e=d;if(d){g=c[B>>2]|0;if((g|0)!=(d|0))c[B>>2]=g+(~((g+-4-e|0)>>>2)<<2);cj(d)}}d=c[C>>2]|0;if(!d)Ya(f|0);e=c[D>>2]|0;if((e|0)!=(d|0))c[D>>2]=e+(~(((e+-6-d|0)>>>0)/6|0)*6|0);cj(d);Ya(f|0)}function Ug(d,f){d=d|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0;N=i;i=i+32|0;D=N+24|0;M=N+18|0;L=N+12|0;E=N+6|0;F=N;G=d+172|0;f=c[G>>2]|0;if((f|0)<=0){i=N;return}H=d+4600|0;I=d+4596|0;J=d+4604|0;K=d+4592|0;C=0;while(1){h=C+-1|0;j=c[H>>2]|0;O=c[I>>2]|0;g=C+1|0;k=e[O+(C*6|0)>>1]|0;B=c[J>>2]|0;l=e[O+(h*6|0)>>1]|0;m=k-l|0;n=e[j+(h*6|0)>>1]|0;o=l-n|0;p=((((a[B+((e[O+(g*6|0)>>1]|0)-k)>>0]|0)*9|0)+(a[B+m>>0]|0)|0)*9|0)+(a[B+o>>0]|0)|0;q=e[O+(C*6|0)+2>>1]|0;r=e[O+(h*6|0)+2>>1]|0;s=q-r|0;t=e[j+(h*6|0)+2>>1]|0;u=r-t|0;v=((((a[B+((e[O+(g*6|0)+2>>1]|0)-q)>>0]|0)*9|0)+(a[B+s>>0]|0)|0)*9|0)+(a[B+u>>0]|0)|0;w=e[O+(C*6|0)+4>>1]|0;x=e[O+(h*6|0)+4>>1]|0;y=w-x|0;z=e[j+(h*6|0)+4>>1]|0;A=x-z|0;B=((((a[B+((e[O+(g*6|0)+4>>1]|0)-w)>>0]|0)*9|0)+(a[B+y>>0]|0)|0)*9|0)+(a[B+A>>0]|0)|0;if(!(v|p|B)){g=j+(h*6|0)|0;b[L>>1]=b[g>>1]|0;b[L+2>>1]=b[g+2>>1]|0;b[L+4>>1]=b[g+4>>1]|0;b[D>>1]=b[g>>1]|0;b[D+2>>1]=b[g+2>>1]|0;b[D+4>>1]=b[g+4>>1]|0;f=Vg(d,D,j+(C*6|0)|0,f-C|0)|0;g=f+C|0;if((g|0)!=(c[G>>2]|0)){O=(c[I>>2]|0)+(g*6|0)|0;b[F>>1]=b[O>>1]|0;b[F+2>>1]=b[O+2>>1]|0;b[F+4>>1]=b[O+4>>1]|0;O=(c[H>>2]|0)+(g*6|0)|0;b[M>>1]=b[L>>1]|0;b[M+2>>1]=b[L+2>>1]|0;b[M+4>>1]=b[L+4>>1]|0;b[D>>1]=b[F>>1]|0;b[D+2>>1]=b[F+2>>1]|0;b[D+4>>1]=b[F+4>>1]|0;Wg(E,d,M,D);b[O>>1]=b[E>>1]|0;b[O+2>>1]=b[E+2>>1]|0;b[O+4>>1]=b[E+4>>1]|0;O=c[K>>2]|0;c[K>>2]=(O|0)<1?0:O+-1|0;f=f+1|0}g=f+C|0}else{h=e[j+(C*6|0)>>1]|0;f=k-n>>31;if((f^o|0)>=0)if((f^m|0)<0)f=n;else f=n-l+k|0;else f=k;k=Xg(d,p,h,f,0)|0;h=e[(c[H>>2]|0)+(C*6|0)+2>>1]|0;f=q-t>>31;if((f^u|0)>=0)if((f^s|0)<0)f=t;else f=t-r+q|0;else f=q;h=Xg(d,v,h,f,0)|0;j=e[(c[H>>2]|0)+(C*6|0)+4>>1]|0;f=w-z>>31;if((f^A|0)>=0)if((f^y|0)<0)f=z;else f=z-x+w|0;else f=w;B=Xg(d,B,j,f,0)|0;O=c[H>>2]|0;b[O+(C*6|0)>>1]=k;b[O+(C*6|0)+2>>1]=h;b[O+(C*6|0)+4>>1]=B}f=c[G>>2]|0;if((g|0)>=(f|0))break;else C=g}i=N;return}function Vg(d,e,f,g){d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0;k=d+112|0;l=d+108|0;m=d+4592|0;h=c[k>>2]|0;i=0;while(1){if((h|0)<1){ge(d);h=c[k>>2]|0}j=c[l>>2]|0;h=h+-1|0;c[k>>2]=h;c[l>>2]=j<<1;if((j|0)>=0){p=8;break}j=c[m>>2]|0;q=1<<c[36476+(j<<2)>>2];r=g-i|0;r=(q|0)<(r|0)?q:r;i=r+i|0;if((r|0)==(q|0))c[m>>2]=(j|0)>30?31:j+1|0;if((i|0)==(g|0)){h=g;break}}if((p|0)==8)if((i|0)!=(g|0)){h=c[m>>2]|0;if((h+-4|0)>>>0<28)h=Kg(d,c[36476+(h<<2)>>2]|0)|0;else h=0;h=h+i|0;if((h|0)>(g|0)){h=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,h|0,5,35648);r=o;o=0;if(r&1){r=Na()|0;La(h|0);Ya(r|0)}else lb(h|0,824,96)}}else h=g;if((h|0)<=0)return h|0;i=0;do{r=f+(i*6|0)|0;b[r>>1]=b[e>>1]|0;b[r+2>>1]=b[e+2>>1]|0;b[r+4>>1]=b[e+4>>1]|0;i=i+1|0}while((i|0)!=(h|0));return h|0}function Wg(a,d,f,g){a=a|0;d=d|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;l=d+4568|0;o=Yg(d,l)|0;j=Yg(d,l)|0;l=Yg(d,l)|0;i=d+128|0;h=e[g>>1]|0;m=c[d+136>>2]|0;n=m<<1|1;h=($($(n,o)|0,h-(e[f>>1]|0)>>31|1)|0)+h|0;o=0-m|0;if((h|0)>=(o|0)){i=c[i>>2]|0;if((i+m|0)<(h|0))h=h-($(c[d+132>>2]|0,n)|0)|0}else{h=($(c[d+132>>2]|0,n)|0)+h|0;i=c[i>>2]|0}if((h&i|0)!=(h|0))h=i&~(h>>31);k=h&65535;h=e[g+2>>1]|0;h=($($(n,j)|0,h-(e[f+2>>1]|0)>>31|1)|0)+h|0;if((h|0)>=(o|0)){if((i+m|0)<(h|0))h=h-($(c[d+132>>2]|0,n)|0)|0}else h=($(c[d+132>>2]|0,n)|0)+h|0;if((h&i|0)!=(h|0))h=i&~(h>>31);j=h&65535;h=e[g+4>>1]|0;h=($($(n,l)|0,h-(e[f+4>>1]|0)>>31|1)|0)+h|0;if((h|0)>=(o|0)){if((i+m|0)<(h|0))h=h-($(c[d+132>>2]|0,n)|0)|0}else h=($(c[d+132>>2]|0,n)|0)+h|0;if((h&i|0)==(h|0)){d=h;d=d&65535;b[a>>1]=k;o=a+2|0;b[o>>1]=j;a=a+4|0;b[a>>1]=d;return}d=i&~(h>>31);d=d&65535;b[a>>1]=k;o=a+2|0;b[o>>1]=j;a=a+4|0;b[a>>1]=d;return}function Xg(d,e,f,g,h){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0,t=0;t=e>>31;l=(t^e)-t|0;r=d+188+(l*12|0)+10|0;f=b[r>>1]|0;q=d+188+(l*12|0)|0;h=c[q>>2]|0;if((f|0)<(h|0))if((f<<1|0)<(h|0))if((f<<2|0)<(h|0))if((f<<3|0)<(h|0))if((f<<4|0)<(h|0)){e=5;while(1)if((f<<e|0)<(h|0))e=e+1|0;else break}else e=4;else e=3;else e=2;else e=1;else e=0;p=d+188+(l*12|0)+8|0;f=(b[p>>1]^t)-t+g|0;s=d+128|0;h=c[s>>2]|0;if((f&h|0)==(f|0))m=f;else m=h&~(f>>31);f=d+112|0;if((c[f>>2]|0)<8)ge(d);h=d+108|0;g=c[h>>2]|0;i=g>>>24;j=c[2832+(e<<11)+(i<<3)+4>>2]|0;if(!j){k=c[d+148>>2]|0;h=c[d+140>>2]|0;f=Jg(d)|0;if((f|0)<(k+-1-h|0)){if(e)f=(Kg(d,e)|0)+(f<<e)|0}else f=(Kg(d,h)|0)+1|0;f=f<<31>>31^f>>1;if((((f|0)>-1?f:0-f|0)|0)>65535){f=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,f|0,5,35648);d=o;o=0;if(d&1){d=Na()|0;La(f|0);Ya(d|0)}else lb(f|0,824,96)}}else{c[f>>2]=(c[f>>2]|0)-j;c[h>>2]=g<<j;f=c[2832+(e<<11)+(i<<3)>>2]|0}k=d+136|0;g=c[k>>2]|0;if(!e){if(!g)h=(c[d+188+(l*12|0)+4>>2]<<1)+-1+(b[r>>1]|0)>>31;else h=0;j=h^f}else j=f;e=c[d+152>>2]|0;h=(c[q>>2]|0)+((j|0)>-1?j:0-j|0)|0;i=d+188+(l*12|0)+4|0;f=(c[i>>2]|0)+($(g<<1|1,j)|0)|0;g=b[r>>1]|0;if((g|0)==(e|0)){h=h>>1;f=f>>1;g=e>>1}c[q>>2]=h;e=g+1|0;b[r>>1]=e;h=e+f|0;if((h|0)>=1){if((f|0)>0){f=f-e|0;r=b[p>>1]|0;b[p>>1]=(r<<16>>16<127&1)+(r&65535);f=(f|0)>0?0:f}}else{f=b[p>>1]|0;b[p>>1]=(f&65535)-(f<<16>>16>-128&1);f=(h|0)>(~g|0)?h:0-g|0}c[i>>2]=f;e=c[k>>2]|0;g=e<<1|1;h=($(g,(j^t)-t|0)|0)+m|0;if((h|0)>=(0-e|0)){f=c[s>>2]|0;if((f+e|0)<(h|0))h=h-($(c[d+132>>2]|0,g)|0)|0}else{h=($(c[d+132>>2]|0,g)|0)+h|0;f=c[s>>2]|0}if((h&f|0)==(h|0)){d=h;d=d&65535;return d|0}d=f&~(h>>31);d=d&65535;return d|0}function Yg(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;m=e+9|0;f=d[m>>0]|0;i=e+4|0;h=($(f>>>1,c[i>>2]|0)|0)+(c[e>>2]|0)|0;if((f|0)<(h|0)){g=0;do{f=f<<1;g=g+1|0}while((f|0)<(h|0))}else g=0;j=c[b+148>>2]|0;k=c[36476+(c[b+4592>>2]<<2)>>2]|0;f=c[b+140>>2]|0;h=Jg(b)|0;do if((h|0)<(j+-2-k-f|0))if(!g){g=c[i>>2]|0;b=g+h|0;f=b&1;b=(f+b|0)/2|0;l=8;break}else{k=(Kg(b,g)|0)+(h<<g)|0;g=c[i>>2]|0;h=k+g|0;j=h&1;f=j;i=1;h=(j+h|0)/2|0;break}else{h=(Kg(b,f)|0)+1|0;j=c[i>>2]|0;b=h+j|0;f=b&1;b=(f+b|0)/2|0;if(!g){g=j;l=8}else{k=h;i=1;h=b;g=j}}while(0);if((l|0)==8){k=h;i=d[e+10>>0]<<1>>>0>=(d[m>>0]|0)>>>0;h=b}h=(f|0)!=0^i?h:0-h|0;if((h|0)<0){l=e+10|0;a[l>>0]=(d[l>>0]|0)+1}f=(k+1-g>>1)+(c[e>>2]|0)|0;c[e>>2]=f;g=a[m>>0]|0;if(g<<24>>24!=(a[e+8>>0]|0)){e=g;e=e&255;e=e+1|0;e=e&255;a[m>>0]=e;return h|0}c[e>>2]=f>>1;l=(g&255)>>>1;a[m>>0]=l;e=e+10|0;a[e>>0]=(d[e>>0]|0)>>>1;e=l;e=e&255;e=e+1|0;e=e&255;a[m>>0]=e;return h|0}function Zg(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=i;i=i+32|0;f=p;o=b+136|0;a:do if(!(c[o>>2]|0)){e=c[b+128>>2]|0;d=b+144|0;if((((e|0)==((1<<c[d>>2])+-1|0)?(Ei(f,e,0),(c[f+4>>2]|0)==(c[b+176>>2]|0)):0)?(c[f+8>>2]|0)==(c[b+180>>2]|0):0)?(c[f+12>>2]|0)==(c[b+184>>2]|0):0)switch(c[d>>2]|0){case 8:{o=c[8900]|0;c[b+4604>>2]=o+(((c[8901]|0)-o|0)>>>1);i=p;return}case 10:{o=c[8903]|0;c[b+4604>>2]=o+(((c[8904]|0)-o|0)>>>1);i=p;return}case 12:{o=c[8906]|0;c[b+4604>>2]=o+(((c[8907]|0)-o|0)>>>1);i=p;return}case 16:{o=c[8909]|0;c[b+4604>>2]=o+(((c[8910]|0)-o|0)>>>1);i=p;return}default:break a}}else d=b+144|0;while(0);n=1<<c[d>>2];e=b+4608|0;f=n<<1;g=b+4612|0;h=c[g>>2]|0;d=c[e>>2]|0;j=h-d|0;if(f>>>0<=j>>>0){if(f>>>0<j>>>0?(k=d+f|0,(h|0)!=(k|0)):0)c[g>>2]=k}else{ie(e,f-j|0);d=c[e>>2]|0}m=b+4604|0;c[m>>2]=d+n;d=0-n|0;if((n|0)<=(d|0)){i=p;return}k=b+184|0;l=b+180|0;j=b+176|0;h=d;do{d=c[k>>2]|0;if((h|0)>(0-d|0)){e=c[l>>2]|0;if((h|0)>(0-e|0)){f=c[j>>2]|0;if((h|0)>(0-f|0)){g=c[o>>2]|0;if((h|0)>=(0-g|0))if((g|0)<(h|0))if((f|0)<=(h|0))if((e|0)>(h|0))d=2;else d=(d|0)>(h|0)?3:4;else d=1;else d=0;else d=-1}else d=-2}else d=-3}else d=-4;a[(c[m>>2]|0)+h>>0]=d;h=h+1|0}while((h|0)!=(n|0));i=p;return}function _g(a){a=a|0;var b=0,d=0;c[a>>2]=35800;b=c[a+4608>>2]|0;if(b){d=a+4612|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}c[a>>2]=36736;b=c[a+92>>2]|0;if(b){d=a+96|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}a=a+88|0;b=c[a>>2]|0;c[a>>2]=0;if(!b)return;Bb[c[(c[b>>2]|0)+4>>2]&255](b);return}function $g(a){a=a|0;var b=0,d=0;c[a>>2]=35800;b=c[a+4608>>2]|0;if(b){d=a+4612|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}c[a>>2]=36736;b=c[a+92>>2]|0;if(b){d=a+96|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}d=a+88|0;b=c[d>>2]|0;c[d>>2]=0;if(!b){cj(a);return}Bb[c[(c[b>>2]|0)+4>>2]&255](b);cj(a);return}function ah(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;w=i;i=i+352|0;x=w+328|0;y=w+192|0;e=w+343|0;f=w+342|0;g=w+341|0;h=w+340|0;r=w+176|0;k=w+168|0;l=w+160|0;m=w+152|0;v=w;t=w+136|0;if((c[b+28>>2]|0)!=0?(c[b+20>>2]|0)!=1:0){s=b+4|0;u=b+32|0;j=c[u>>2]|0;if(!j){b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[e>>0]|0;Aa(44,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}b=c[b+12>>2]|0;if((b|0)==8)switch(j|0){case 1:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[f>>0]|0;Aa(45,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 2:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[g>>0]|0;Aa(46,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 3:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[h>>0]|0;Aa(47,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}default:{j=y+56|0;g=y+4|0;c[y>>2]=36160;c[j>>2]=36180;o=0;ia(62,y+56|0,g|0);w=o;o=0;if(w&1){z=Na()|0;fn(j);Ya(z|0)}c[y+128>>2]=0;c[y+132>>2]=-1;c[y>>2]=36200;c[y+56>>2]=36220;o=0;ha(180,g|0);w=o;o=0;do if(w&1)b=Na()|0;else{c[g>>2]=36236;h=y+36|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[y+52>>2]=16;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;o=0;ia(63,g|0,x|0);w=o;o=0;if(w&1){b=Na()|0;Im(x);Im(h);nn(g);break}Im(x);o=0;b=ma(28,y|0,49007,21)|0;x=o;o=0;do if((!(x&1)?(o=0,p=ra(36,b|0,c[u>>2]|0)|0,x=o,o=0,!(x&1)):0)?(o=0,ma(28,p|0,50997,18)|0,x=o,o=0,!(x&1)):0){f=Ma(16)|0;o=0;ia(64,r|0,g|0);x=o;o=0;if(!(x&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,f|0,9,35648,r|0);x=o;o=0;if(x&1)e=1;else{o=0;wa(6,f|0,824,96);o=0;e=0}b=Na()|0;Im(r);if(!e)break}else b=Na()|0;La(f|0)}else z=34;while(0);if((z|0)==34)b=Na()|0;c[y>>2]=36200;c[j>>2]=36220;c[g>>2]=36236;Im(h);nn(g);fn(j);z=b;Ya(z|0)}while(0);z=b;fn(j);Ya(z|0)}}if((b|0)<=8){b=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,b|0,8,35648);z=o;o=0;if(!(z&1))lb(b|0,824,96);z=Na()|0;La(b|0);Ya(z|0)}e=16-b|0;switch(j|0){case 1:{b=bj(60)|0;c[k>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[k>>2];c[x+4>>2]=c[k+4>>2];Aa(41,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 2:{b=bj(60)|0;c[l>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[l>>2];c[x+4>>2]=c[l+4>>2];Aa(42,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 3:{b=bj(60)|0;c[m>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[m>>2];c[x+4>>2]=c[m+4>>2];Aa(43,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}default:{j=v+56|0;g=v+4|0;c[v>>2]=36160;c[j>>2]=36180;o=0;ia(62,v+56|0,g|0);y=o;o=0;if(y&1){z=Na()|0;fn(j);Ya(z|0)}c[v+128>>2]=0;c[v+132>>2]=-1;c[v>>2]=36200;c[v+56>>2]=36220;o=0;ha(180,g|0);y=o;o=0;do if(y&1)b=Na()|0;else{c[g>>2]=36236;h=v+36|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[v+52>>2]=16;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;o=0;ia(63,g|0,x|0);y=o;o=0;if(y&1){b=Na()|0;Im(x);Im(h);nn(g);break}Im(x);o=0;b=ma(28,v|0,49007,21)|0;y=o;o=0;do if((!(y&1)?(o=0,q=ra(36,b|0,c[u>>2]|0)|0,y=o,o=0,!(y&1)):0)?(o=0,ma(28,q|0,50997,18)|0,y=o,o=0,!(y&1)):0){f=Ma(16)|0;o=0;ia(64,t|0,g|0);y=o;o=0;if(!(y&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,f|0,9,35648,t|0);y=o;o=0;if(y&1)e=1;else{o=0;wa(6,f|0,824,96);o=0;e=0}b=Na()|0;Im(t);if(!e)break}else b=Na()|0;La(f|0)}else z=64;while(0);if((z|0)==64)b=Na()|0;c[v>>2]=36200;c[j>>2]=36220;c[g>>2]=36236;Im(h);nn(g);fn(j);z=b;Ya(z|0)}while(0);z=b;fn(j);Ya(z|0)}}}e=c[d+4>>2]|0;f=bj(16)|0;b=c[b+16>>2]|0;if(!e){z=c[d>>2]|0;c[f>>2]=36132;c[f+4>>2]=z;c[f+8>>2]=3;c[f+12>>2]=b;z=f;i=w;return z|0}else{c[f>>2]=36108;c[f+4>>2]=e;c[f+8>>2]=3;c[f+12>>2]=b;z=f;i=w;return z|0}return 0}function bh(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;k=i;i=i+32|0;m=k;Ei(m,c[d+128>>2]|0,c[d+136>>2]|0);l=c[e+4>>2]|0;j=c[e+8>>2]|0;j=(j|0)==0?c[m+8>>2]|0:j;h=c[e+12>>2]|0;h=(h|0)==0?c[m+12>>2]|0:h;f=c[e+16>>2]|0;g=c[m+16>>2]|0;c[d+176>>2]=(l|0)==0?c[m+4>>2]|0:l;c[d+180>>2]=j;c[d+184>>2]=h;jh(d);h=d+132|0;e=(c[h>>2]|0)+32|0;e=(e|0)<128?2:(e|0)/64|0;j=0;do{c[d+188+(j*12|0)>>2]=e;c[d+188+(j*12|0)+4>>2]=0;b[d+188+(j*12|0)+8>>1]=0;b[d+188+(j*12|0)+10>>1]=1;j=j+1|0}while((j|0)!=365);l=(c[h>>2]|0)+32|0;l=(l|0)<128?2:(l|0)/64|0;m=((f|0)==0?g:f)&255;c[d+4568>>2]=l;c[d+4572>>2]=0;a[d+4576>>0]=m;a[d+4577>>0]=1;a[d+4578>>0]=0;c[d+4580>>2]=l;c[d+4584>>2]=1;a[d+4588>>0]=m;a[d+4589>>0]=1;a[d+4590>>0]=0;c[d+4592>>2]=0;i=k;return}function ch(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0;i=b+88|0;h=c[d>>2]|0;c[d>>2]=0;d=c[i>>2]|0;c[i>>2]=h;if(d)Bb[c[(c[d>>2]|0)+4>>2]&255](d);i=f+4|0;h=c[i>>2]|0;a[b+4620>>0]=g&1;d=b+156|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];Wd(b,f);dh(b);d=c[b+116>>2]|0;b=c[b+112>>2]|0;while(1){g=d+-1|0;e=(a[g>>0]|0)==-1?7:8;if((b|0)<(e|0))break;else{d=g;b=b-e|0}}d=d-h|0;g=c[i>>2]|0;if(!g)return;c[i>>2]=g+d;f=f+8|0;c[f>>2]=(c[f>>2]|0)-d;return}function dh(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;A=i;i=i+32|0;C=A+12|0;z=A;w=b+172|0;x=(c[w>>2]|0)+4|0;if((c[b+28>>2]|0)==1)y=c[b+20>>2]|0;else y=1;d=$(y<<1,x)|0;c[C>>2]=0;D=C+4|0;c[D>>2]=0;c[C+8>>2]=0;a:do if(d){if(!(d>>>0>1431655765?(o=0,ha(178,C|0),B=o,o=0,B&1):0))h=6;if((h|0)==6?(o=0,e=ka(67,d*3|0)|0,B=o,o=0,!(B&1)):0){c[D>>2]=e;c[C>>2]=e;c[C+8>>2]=e+(d*3|0);while(1){a[e>>0]=0;a[e+1>>0]=0;a[e+2>>0]=0;e=(c[D>>2]|0)+3|0;c[D>>2]=e;d=d+-1|0;if(!d)break a}}f=Na()|0;d=c[C>>2]|0;if(!d)Ya(f|0);e=c[D>>2]|0;if((e|0)!=(d|0))c[D>>2]=e+(~(((e+-3-d|0)>>>0)/3|0)*3|0);cj(d);Ya(f|0)}while(0);c[z>>2]=0;B=z+4|0;c[B>>2]=0;c[z+8>>2]=0;do if(!y)h=19;else{if(!(y>>>0>1073741823?(o=0,ha(178,z|0),v=o,o=0,v&1):0))h=17;if((h|0)==17?(f=y<<2,o=0,g=ka(67,f|0)|0,v=o,o=0,!(v&1)):0){c[z>>2]=g;h=g+(y<<2)|0;c[z+8>>2]=h;iw(g|0,0,f|0)|0;c[B>>2]=h;h=19;break}f=Na()|0;d=c[z>>2]|0;e=d;if(d){g=c[B>>2]|0;if((g|0)!=(d|0))c[B>>2]=g+(~((g+-4-e|0)>>>2)<<2);cj(d)}}while(0);if((h|0)==19){h=b+8|0;b:do if((c[h>>2]|0)>0){j=b+4596|0;k=$(y,x)|0;l=k+1|0;m=b+4600|0;n=(y|0)>0;p=b+160|0;q=b+168|0;r=b+164|0;s=b+156|0;t=b+88|0;u=b+4592|0;v=0;c:while(1){f=c[C>>2]|0;e=f+3|0;c[j>>2]=e;f=f+(l*3|0)|0;c[m>>2]=f;if(!(v&1))d=f;else{c[j>>2]=f;c[m>>2]=e;d=e;e=f}if(n){g=c[z>>2]|0;f=0;do{c[u>>2]=c[g+(f<<2)>>2];d=c[w>>2]|0;g=e+(d*3|0)|0;e=e+((d+-1|0)*3|0)|0;a[g>>0]=a[e>>0]|0;a[g+1>>0]=a[e+1>>0]|0;a[g+2>>0]=a[e+2>>0]|0;e=c[j>>2]|0;g=(c[m>>2]|0)+-3|0;a[g>>0]=a[e>>0]|0;a[g+1>>0]=a[e+1>>0]|0;a[g+2>>0]=a[e+2>>0]|0;o=0;ia(78,b|0,0);g=o;o=0;if(g&1){h=30;break c}g=c[z>>2]|0;c[g+(f<<2)>>2]=c[u>>2];e=(c[j>>2]|0)+(x*3|0)|0;c[j>>2]=e;d=(c[m>>2]|0)+(x*3|0)|0;c[m>>2]=d;f=f+1|0}while((f|0)<(y|0))}g=c[p>>2]|0;if(((g|0)<=(v|0)?(v|0)<((c[q>>2]|0)+g|0):0)?(g=c[t>>2]|0,o=0,Aa(c[(c[g>>2]|0)+8>>2]|0,g|0,d+(((c[s>>2]|0)-k|0)*3|0)|0,c[r>>2]|0,x|0),g=o,o=0,g&1):0){h=31;break}v=v+1|0;if((v|0)>=(c[h>>2]|0)){h=43;break b}}if((h|0)==30){f=Na()|0;break}else if((h|0)==31){f=Na()|0;break}}else h=43;while(0);do if((h|0)==43){o=0;ha(183,b|0);b=o;o=0;if(b&1){f=Na()|0;break}d=c[z>>2]|0;e=d;if(d){f=c[B>>2]|0;if((f|0)!=(d|0))c[B>>2]=f+(~((f+-4-e|0)>>>2)<<2);cj(d)}d=c[C>>2]|0;if(!d){i=A;return}e=c[D>>2]|0;if((e|0)!=(d|0))c[D>>2]=e+(~(((e+-3-d|0)>>>0)/3|0)*3|0);cj(d);i=A;return}while(0);d=c[z>>2]|0;e=d;if(d){g=c[B>>2]|0;if((g|0)!=(d|0))c[B>>2]=g+(~((g+-4-e|0)>>>2)<<2);cj(d)}}d=c[C>>2]|0;if(!d)Ya(f|0);e=c[D>>2]|0;if((e|0)!=(d|0))c[D>>2]=e+(~(((e+-3-d|0)>>>0)/3|0)*3|0);cj(d);Ya(f|0)}function eh(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0;M=i;i=i+16|0;C=M+12|0;L=M+9|0;K=M+6|0;D=M+3|0;E=M;F=b+172|0;e=c[F>>2]|0;if((e|0)<=0){i=M;return}G=b+4600|0;H=b+4596|0;I=b+4604|0;J=b+4592|0;B=0;while(1){y=B+-1|0;g=c[G>>2]|0;h=g+(y*3|0)|0;N=c[H>>2]|0;f=B+1|0;j=d[N+(B*3|0)>>0]|0;A=c[I>>2]|0;k=d[N+(y*3|0)>>0]|0;l=j-k|0;m=d[h>>0]|0;n=k-m|0;o=((((a[A+((d[N+(f*3|0)>>0]|0)-j)>>0]|0)*9|0)+(a[A+l>>0]|0)|0)*9|0)+(a[A+n>>0]|0)|0;p=d[N+(B*3|0)+1>>0]|0;q=d[N+(y*3|0)+1>>0]|0;r=p-q|0;s=d[g+(y*3|0)+1>>0]|0;t=q-s|0;u=((((a[A+((d[N+(f*3|0)+1>>0]|0)-p)>>0]|0)*9|0)+(a[A+r>>0]|0)|0)*9|0)+(a[A+t>>0]|0)|0;v=d[N+(B*3|0)+2>>0]|0;w=d[N+(y*3|0)+2>>0]|0;x=v-w|0;y=d[g+(y*3|0)+2>>0]|0;z=w-y|0;A=((((a[A+((d[N+(f*3|0)+2>>0]|0)-v)>>0]|0)*9|0)+(a[A+x>>0]|0)|0)*9|0)+(a[A+z>>0]|0)|0;if(!(u|o|A)){a[K>>0]=a[h>>0]|0;a[K+1>>0]=a[h+1>>0]|0;a[K+2>>0]=a[h+2>>0]|0;a[C>>0]=a[h>>0]|0;a[C+1>>0]=a[h+1>>0]|0;a[C+2>>0]=a[h+2>>0]|0;e=fh(b,C,g+(B*3|0)|0,e-B|0)|0;f=e+B|0;if((f|0)!=(c[F>>2]|0)){N=(c[H>>2]|0)+(f*3|0)|0;a[E>>0]=a[N>>0]|0;a[E+1>>0]=a[N+1>>0]|0;a[E+2>>0]=a[N+2>>0]|0;N=c[G>>2]|0;a[L>>0]=a[K>>0]|0;a[L+1>>0]=a[K+1>>0]|0;a[L+2>>0]=a[K+2>>0]|0;a[C>>0]=a[E>>0]|0;a[C+1>>0]=a[E+1>>0]|0;a[C+2>>0]=a[E+2>>0]|0;gh(D,b,L,C);N=N+(f*3|0)|0;a[N>>0]=a[D>>0]|0;a[N+1>>0]=a[D+1>>0]|0;a[N+2>>0]=a[D+2>>0]|0;N=c[J>>2]|0;c[J>>2]=(N|0)<1?0:N+-1|0;e=e+1|0}f=e+B|0}else{g=d[g+(B*3|0)>>0]|0;e=j-m>>31;if((e^n|0)>=0)if((e^l|0)<0)e=m;else e=m-k+j|0;else e=j;j=hh(b,o,g,e,0)|0;g=d[(c[G>>2]|0)+(B*3|0)+1>>0]|0;e=p-s>>31;if((e^t|0)>=0)if((e^r|0)<0)e=s;else e=s-q+p|0;else e=p;g=hh(b,u,g,e,0)|0;h=d[(c[G>>2]|0)+(B*3|0)+2>>0]|0;e=v-y>>31;if((e^z|0)>=0)if((e^x|0)<0)e=y;else e=y-w+v|0;else e=v;A=hh(b,A,h,e,0)|0;N=(c[G>>2]|0)+(B*3|0)|0;a[N>>0]=j;a[N+1>>0]=g;a[N+2>>0]=A}e=c[F>>2]|0;if((f|0)>=(e|0))break;else B=f}i=M;return}function fh(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,p=0,q=0;j=b+112|0;k=b+108|0;l=b+4592|0;g=c[j>>2]|0;h=0;while(1){if((g|0)<1){ge(b);g=c[j>>2]|0}i=c[k>>2]|0;g=g+-1|0;c[j>>2]=g;c[k>>2]=i<<1;if((i|0)>=0){m=8;break}i=c[l>>2]|0;p=1<<c[36476+(i<<2)>>2];q=f-h|0;q=(p|0)<(q|0)?p:q;h=q+h|0;if((q|0)==(p|0))c[l>>2]=(i|0)>30?31:i+1|0;if((h|0)==(f|0)){g=f;break}}if((m|0)==8)if((h|0)!=(f|0)){g=c[l>>2]|0;if((g+-4|0)>>>0<28)g=Kg(b,c[36476+(g<<2)>>2]|0)|0;else g=0;g=g+h|0;if((g|0)>(f|0)){g=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,g|0,5,35648);q=o;o=0;if(q&1){q=Na()|0;La(g|0);Ya(q|0)}else lb(g|0,824,96)}}else g=f;if((g|0)<=0)return g|0;h=0;do{q=e+(h*3|0)|0;a[q>>0]=a[d>>0]|0;a[q+1>>0]=a[d+1>>0]|0;a[q+2>>0]=a[d+2>>0]|0;h=h+1|0}while((h|0)!=(g|0));return g|0}function gh(b,e,f,g){b=b|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;l=e+4568|0;o=ih(e,l)|0;j=ih(e,l)|0;l=ih(e,l)|0;i=e+128|0;h=d[g>>0]|0;m=c[e+136>>2]|0;n=m<<1|1;h=($($(n,o)|0,h-(d[f>>0]|0)>>31|1)|0)+h|0;o=0-m|0;if((h|0)>=(o|0)){i=c[i>>2]|0;if((i+m|0)<(h|0))h=h-($(c[e+132>>2]|0,n)|0)|0}else{h=($(c[e+132>>2]|0,n)|0)+h|0;i=c[i>>2]|0}if((h&i|0)!=(h|0))h=i&~(h>>31);k=h&255;h=d[g+1>>0]|0;h=($($(n,j)|0,h-(d[f+1>>0]|0)>>31|1)|0)+h|0;if((h|0)>=(o|0)){if((i+m|0)<(h|0))h=h-($(c[e+132>>2]|0,n)|0)|0}else h=($(c[e+132>>2]|0,n)|0)+h|0;if((h&i|0)!=(h|0))h=i&~(h>>31);j=h&255;h=d[g+2>>0]|0;h=($($(n,l)|0,h-(d[f+2>>0]|0)>>31|1)|0)+h|0;if((h|0)>=(o|0)){if((i+m|0)<(h|0))h=h-($(c[e+132>>2]|0,n)|0)|0}else h=($(c[e+132>>2]|0,n)|0)+h|0;if((h&i|0)==(h|0)){e=h;e=e&255;a[b>>0]=k;o=b+1|0;a[o>>0]=j;b=b+2|0;a[b>>0]=e;return}e=i&~(h>>31);e=e&255;a[b>>0]=k;o=b+1|0;a[o>>0]=j;b=b+2|0;a[b>>0]=e;return}function hh(d,e,f,g,h){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0,t=0;t=e>>31;l=(t^e)-t|0;r=d+188+(l*12|0)+10|0;f=b[r>>1]|0;q=d+188+(l*12|0)|0;h=c[q>>2]|0;if((f|0)<(h|0))if((f<<1|0)<(h|0))if((f<<2|0)<(h|0))if((f<<3|0)<(h|0))if((f<<4|0)<(h|0)){e=5;while(1)if((f<<e|0)<(h|0))e=e+1|0;else break}else e=4;else e=3;else e=2;else e=1;else e=0;p=d+188+(l*12|0)+8|0;f=(b[p>>1]^t)-t+g|0;s=d+128|0;h=c[s>>2]|0;if((f&h|0)==(f|0))m=f;else m=h&~(f>>31);f=d+112|0;if((c[f>>2]|0)<8)ge(d);h=d+108|0;g=c[h>>2]|0;i=g>>>24;j=c[2832+(e<<11)+(i<<3)+4>>2]|0;if(!j){k=c[d+148>>2]|0;h=c[d+140>>2]|0;f=Jg(d)|0;if((f|0)<(k+-1-h|0)){if(e)f=(Kg(d,e)|0)+(f<<e)|0}else f=(Kg(d,h)|0)+1|0;f=f<<31>>31^f>>1;if((((f|0)>-1?f:0-f|0)|0)>65535){f=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,f|0,5,35648);d=o;o=0;if(d&1){d=Na()|0;La(f|0);Ya(d|0)}else lb(f|0,824,96)}}else{c[f>>2]=(c[f>>2]|0)-j;c[h>>2]=g<<j;f=c[2832+(e<<11)+(i<<3)>>2]|0}k=d+136|0;g=c[k>>2]|0;if(!e){if(!g)h=(c[d+188+(l*12|0)+4>>2]<<1)+-1+(b[r>>1]|0)>>31;else h=0;j=h^f}else j=f;e=c[d+152>>2]|0;h=(c[q>>2]|0)+((j|0)>-1?j:0-j|0)|0;i=d+188+(l*12|0)+4|0;f=(c[i>>2]|0)+($(g<<1|1,j)|0)|0;g=b[r>>1]|0;if((g|0)==(e|0)){h=h>>1;f=f>>1;g=e>>1}c[q>>2]=h;e=g+1|0;b[r>>1]=e;h=e+f|0;if((h|0)>=1){if((f|0)>0){f=f-e|0;r=b[p>>1]|0;b[p>>1]=(r<<16>>16<127&1)+(r&65535);f=(f|0)>0?0:f}}else{f=b[p>>1]|0;b[p>>1]=(f&65535)-(f<<16>>16>-128&1);f=(h|0)>(~g|0)?h:0-g|0}c[i>>2]=f;e=c[k>>2]|0;g=e<<1|1;h=($(g,(j^t)-t|0)|0)+m|0;if((h|0)>=(0-e|0)){f=c[s>>2]|0;if((f+e|0)<(h|0))h=h-($(c[d+132>>2]|0,g)|0)|0}else{h=($(c[d+132>>2]|0,g)|0)+h|0;f=c[s>>2]|0}if((h&f|0)==(h|0)){d=h;d=d&255;return d|0}d=f&~(h>>31);d=d&255;return d|0}function ih(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;m=e+9|0;f=d[m>>0]|0;i=e+4|0;h=($(f>>>1,c[i>>2]|0)|0)+(c[e>>2]|0)|0;if((f|0)<(h|0)){g=0;do{f=f<<1;g=g+1|0}while((f|0)<(h|0))}else g=0;j=c[b+148>>2]|0;k=c[36476+(c[b+4592>>2]<<2)>>2]|0;f=c[b+140>>2]|0;h=Jg(b)|0;do if((h|0)<(j+-2-k-f|0))if(!g){g=c[i>>2]|0;b=g+h|0;f=b&1;b=(f+b|0)/2|0;l=8;break}else{k=(Kg(b,g)|0)+(h<<g)|0;g=c[i>>2]|0;h=k+g|0;j=h&1;f=j;i=1;h=(j+h|0)/2|0;break}else{h=(Kg(b,f)|0)+1|0;j=c[i>>2]|0;b=h+j|0;f=b&1;b=(f+b|0)/2|0;if(!g){g=j;l=8}else{k=h;i=1;h=b;g=j}}while(0);if((l|0)==8){k=h;i=d[e+10>>0]<<1>>>0>=(d[m>>0]|0)>>>0;h=b}h=(f|0)!=0^i?h:0-h|0;if((h|0)<0){l=e+10|0;a[l>>0]=(d[l>>0]|0)+1}f=(k+1-g>>1)+(c[e>>2]|0)|0;c[e>>2]=f;g=a[m>>0]|0;if(g<<24>>24!=(a[e+8>>0]|0)){e=g;e=e&255;e=e+1|0;e=e&255;a[m>>0]=e;return h|0}c[e>>2]=f>>1;l=(g&255)>>>1;a[m>>0]=l;e=e+10|0;a[e>>0]=(d[e>>0]|0)>>>1;e=l;e=e&255;e=e+1|0;e=e&255;a[m>>0]=e;return h|0}function jh(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;p=i;i=i+32|0;f=p;o=b+136|0;a:do if(!(c[o>>2]|0)){e=c[b+128>>2]|0;d=b+144|0;if((((e|0)==((1<<c[d>>2])+-1|0)?(Ei(f,e,0),(c[f+4>>2]|0)==(c[b+176>>2]|0)):0)?(c[f+8>>2]|0)==(c[b+180>>2]|0):0)?(c[f+12>>2]|0)==(c[b+184>>2]|0):0)switch(c[d>>2]|0){case 8:{o=c[8900]|0;c[b+4604>>2]=o+(((c[8901]|0)-o|0)>>>1);i=p;return}case 10:{o=c[8903]|0;c[b+4604>>2]=o+(((c[8904]|0)-o|0)>>>1);i=p;return}case 12:{o=c[8906]|0;c[b+4604>>2]=o+(((c[8907]|0)-o|0)>>>1);i=p;return}case 16:{o=c[8909]|0;c[b+4604>>2]=o+(((c[8910]|0)-o|0)>>>1);i=p;return}default:break a}}else d=b+144|0;while(0);n=1<<c[d>>2];e=b+4608|0;f=n<<1;g=b+4612|0;h=c[g>>2]|0;d=c[e>>2]|0;j=h-d|0;if(f>>>0<=j>>>0){if(f>>>0<j>>>0?(k=d+f|0,(h|0)!=(k|0)):0)c[g>>2]=k}else{ie(e,f-j|0);d=c[e>>2]|0}m=b+4604|0;c[m>>2]=d+n;d=0-n|0;if((n|0)<=(d|0)){i=p;return}k=b+184|0;l=b+180|0;j=b+176|0;h=d;do{d=c[k>>2]|0;if((h|0)>(0-d|0)){e=c[l>>2]|0;if((h|0)>(0-e|0)){f=c[j>>2]|0;if((h|0)>(0-f|0)){g=c[o>>2]|0;if((h|0)>=(0-g|0))if((g|0)<(h|0))if((f|0)<=(h|0))if((e|0)>(h|0))d=2;else d=(d|0)>(h|0)?3:4;else d=1;else d=0;else d=-1}else d=-2}else d=-3}else d=-4;a[(c[m>>2]|0)+h>>0]=d;h=h+1|0}while((h|0)!=(n|0));i=p;return}function kh(a){a=a|0;var b=0,d=0;c[a>>2]=35772;b=c[a+4584>>2]|0;if(b){d=a+4588|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}c[a>>2]=36736;b=c[a+92>>2]|0;if(b){d=a+96|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}a=a+88|0;b=c[a>>2]|0;c[a>>2]=0;if(!b)return;Bb[c[(c[b>>2]|0)+4>>2]&255](b);return}function lh(a){a=a|0;var b=0,d=0;c[a>>2]=35772;b=c[a+4584>>2]|0;if(b){d=a+4588|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}c[a>>2]=36736;b=c[a+92>>2]|0;if(b){d=a+96|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}d=a+88|0;b=c[d>>2]|0;c[d>>2]=0;if(!b){cj(a);return}Bb[c[(c[b>>2]|0)+4>>2]&255](b);cj(a);return}function mh(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;w=i;i=i+352|0;x=w+328|0;y=w+192|0;e=w+343|0;f=w+342|0;g=w+341|0;h=w+340|0;r=w+176|0;k=w+168|0;l=w+160|0;m=w+152|0;v=w;t=w+136|0;if((c[b+28>>2]|0)!=0?(c[b+20>>2]|0)!=1:0){s=b+4|0;u=b+32|0;j=c[u>>2]|0;if(!j){b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[e>>0]|0;Aa(37,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}b=c[b+12>>2]|0;if((b|0)==16)switch(j|0){case 1:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[f>>0]|0;Aa(38,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 2:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[g>>0]|0;Aa(39,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 3:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[h>>0]|0;Aa(40,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}default:{j=y+56|0;g=y+4|0;c[y>>2]=36160;c[j>>2]=36180;o=0;ia(62,y+56|0,g|0);w=o;o=0;if(w&1){z=Na()|0;fn(j);Ya(z|0)}c[y+128>>2]=0;c[y+132>>2]=-1;c[y>>2]=36200;c[y+56>>2]=36220;o=0;ha(180,g|0);w=o;o=0;do if(w&1)b=Na()|0;else{c[g>>2]=36236;h=y+36|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[y+52>>2]=16;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;o=0;ia(63,g|0,x|0);w=o;o=0;if(w&1){b=Na()|0;Im(x);Im(h);nn(g);break}Im(x);o=0;b=ma(28,y|0,49007,21)|0;x=o;o=0;do if((!(x&1)?(o=0,p=ra(36,b|0,c[u>>2]|0)|0,x=o,o=0,!(x&1)):0)?(o=0,ma(28,p|0,50997,18)|0,x=o,o=0,!(x&1)):0){f=Ma(16)|0;o=0;ia(64,r|0,g|0);x=o;o=0;if(!(x&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,f|0,9,35648,r|0);x=o;o=0;if(x&1)e=1;else{o=0;wa(6,f|0,824,96);o=0;e=0}b=Na()|0;Im(r);if(!e)break}else b=Na()|0;La(f|0)}else z=34;while(0);if((z|0)==34)b=Na()|0;c[y>>2]=36200;c[j>>2]=36220;c[g>>2]=36236;Im(h);nn(g);fn(j);z=b;Ya(z|0)}while(0);z=b;fn(j);Ya(z|0)}}if((b|0)<=8){b=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,b|0,8,35648);z=o;o=0;if(!(z&1))lb(b|0,824,96);z=Na()|0;La(b|0);Ya(z|0)}e=16-b|0;switch(j|0){case 1:{b=bj(60)|0;c[k>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[k>>2];c[x+4>>2]=c[k+4>>2];Aa(41,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 2:{b=bj(60)|0;c[l>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[l>>2];c[x+4>>2]=c[l+4>>2];Aa(42,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 3:{b=bj(60)|0;c[m>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[m>>2];c[x+4>>2]=c[m+4>>2];Aa(43,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}default:{j=v+56|0;g=v+4|0;c[v>>2]=36160;c[j>>2]=36180;o=0;ia(62,v+56|0,g|0);y=o;o=0;if(y&1){z=Na()|0;fn(j);Ya(z|0)}c[v+128>>2]=0;c[v+132>>2]=-1;c[v>>2]=36200;c[v+56>>2]=36220;o=0;ha(180,g|0);y=o;o=0;do if(y&1)b=Na()|0;else{c[g>>2]=36236;h=v+36|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[v+52>>2]=16;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;o=0;ia(63,g|0,x|0);y=o;o=0;if(y&1){b=Na()|0;Im(x);Im(h);nn(g);break}Im(x);o=0;b=ma(28,v|0,49007,21)|0;y=o;o=0;do if((!(y&1)?(o=0,q=ra(36,b|0,c[u>>2]|0)|0,y=o,o=0,!(y&1)):0)?(o=0,ma(28,q|0,50997,18)|0,y=o,o=0,!(y&1)):0){f=Ma(16)|0;o=0;ia(64,t|0,g|0);y=o;o=0;if(!(y&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,f|0,9,35648,t|0);y=o;o=0;if(y&1)e=1;else{o=0;wa(6,f|0,824,96);o=0;e=0}b=Na()|0;Im(t);if(!e)break}else b=Na()|0;La(f|0)}else z=64;while(0);if((z|0)==64)b=Na()|0;c[v>>2]=36200;c[j>>2]=36220;c[g>>2]=36236;Im(h);nn(g);fn(j);z=b;Ya(z|0)}while(0);z=b;fn(j);Ya(z|0)}}}e=c[d+4>>2]|0;f=bj(16)|0;b=c[b+16>>2]|0;if(!e){z=c[d>>2]|0;c[f>>2]=36132;c[f+4>>2]=z;c[f+8>>2]=2;c[f+12>>2]=b;z=f;i=w;return z|0}else{c[f>>2]=36108;c[f+4>>2]=e;c[f+8>>2]=2;c[f+12>>2]=b;z=f;i=w;return z|0}return 0}function nh(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;h=i;i=i+32|0;l=h;Ei(l,65535,0);k=c[e+4>>2]|0;j=c[e+8>>2]|0;j=(j|0)==0?c[l+8>>2]|0:j;g=c[e+12>>2]|0;g=(g|0)==0?c[l+12>>2]|0:g;e=c[e+16>>2]|0;f=c[l+16>>2]|0;c[d+152>>2]=(k|0)==0?c[l+4>>2]|0:k;c[d+156>>2]=j;c[d+160>>2]=g;vh(d);g=0;do{c[d+164+(g*12|0)>>2]=1024;c[d+164+(g*12|0)+4>>2]=0;b[d+164+(g*12|0)+8>>1]=0;b[d+164+(g*12|0)+10>>1]=1;g=g+1|0}while((g|0)!=365);l=((e|0)==0?f:e)&255;c[d+4544>>2]=1024;c[d+4548>>2]=0;a[d+4552>>0]=l;a[d+4553>>0]=1;a[d+4554>>0]=0;c[d+4556>>2]=1024;c[d+4560>>2]=1;a[d+4564>>0]=l;a[d+4565>>0]=1;a[d+4566>>0]=0;c[d+4568>>2]=0;i=h;return}function oh(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0;i=b+88|0;h=c[d>>2]|0;c[d>>2]=0;d=c[i>>2]|0;c[i>>2]=h;if(d)Bb[c[(c[d>>2]|0)+4>>2]&255](d);i=f+4|0;h=c[i>>2]|0;a[b+4596>>0]=g&1;d=b+132|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];Wd(b,f);ph(b);d=c[b+116>>2]|0;b=c[b+112>>2]|0;while(1){g=d+-1|0;e=(a[g>>0]|0)==-1?7:8;if((b|0)<(e|0))break;else{d=g;b=b-e|0}}d=d-h|0;g=c[i>>2]|0;if(!g)return;c[i>>2]=g+d;f=f+8|0;c[f>>2]=(c[f>>2]|0)-d;return}function ph(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;A=i;i=i+32|0;C=A+12|0;z=A;w=a+148|0;x=(c[w>>2]|0)+4|0;if((c[a+28>>2]|0)==1)y=c[a+20>>2]|0;else y=1;d=$(y<<1,x)|0;c[C>>2]=0;D=C+4|0;c[D>>2]=0;c[C+8>>2]=0;do if(d){if(!((d|0)<0?(o=0,ha(178,C|0),B=o,o=0,B&1):0))j=6;if((j|0)==6?(e=d<<1,o=0,f=ka(67,e|0)|0,B=o,o=0,!(B&1)):0){c[C>>2]=f;B=f+(d<<1)|0;c[C+8>>2]=B;iw(f|0,0,e|0)|0;c[D>>2]=B;break}f=Na()|0;d=c[C>>2]|0;if(!d)Ya(f|0);e=c[D>>2]|0;if((e|0)!=(d|0))c[D>>2]=e+(~((e+-2-d|0)>>>1)<<1);cj(d);Ya(f|0)}while(0);c[z>>2]=0;B=z+4|0;c[B>>2]=0;c[z+8>>2]=0;do if(!y)j=18;else{if(!(y>>>0>1073741823?(o=0,ha(178,z|0),v=o,o=0,v&1):0))j=16;if((j|0)==16?(g=y<<2,o=0,h=ka(67,g|0)|0,v=o,o=0,!(v&1)):0){c[z>>2]=h;j=h+(y<<2)|0;c[z+8>>2]=j;iw(h|0,0,g|0)|0;c[B>>2]=j;j=18;break}f=Na()|0;d=c[z>>2]|0;e=d;if(d){g=c[B>>2]|0;if((g|0)!=(d|0))c[B>>2]=g+(~((g+-4-e|0)>>>2)<<2);cj(d)}}while(0);if((j|0)==18){h=a+8|0;a:do if((c[h>>2]|0)>0){j=a+4572|0;k=$(y,x)|0;l=k+1|0;m=a+4576|0;n=(y|0)>0;p=a+136|0;q=a+144|0;r=a+140|0;s=a+132|0;t=a+88|0;u=a+4568|0;v=0;b:while(1){f=c[C>>2]|0;e=f+2|0;c[j>>2]=e;f=f+(l<<1)|0;c[m>>2]=f;if(!(v&1))d=f;else{c[j>>2]=f;c[m>>2]=e;d=e;e=f}if(n){g=c[z>>2]|0;f=0;do{c[u>>2]=c[g+(f<<2)>>2];g=c[w>>2]|0;b[e+(g<<1)>>1]=b[e+(g+-1<<1)>>1]|0;b[d+-2>>1]=b[e>>1]|0;o=0;ia(79,a|0,0);g=o;o=0;if(g&1){j=29;break b}g=c[z>>2]|0;c[g+(f<<2)>>2]=c[u>>2];e=(c[j>>2]|0)+(x<<1)|0;c[j>>2]=e;d=(c[m>>2]|0)+(x<<1)|0;c[m>>2]=d;f=f+1|0}while((f|0)<(y|0))}g=c[p>>2]|0;if(((g|0)<=(v|0)?(v|0)<((c[q>>2]|0)+g|0):0)?(g=c[t>>2]|0,o=0,Aa(c[(c[g>>2]|0)+8>>2]|0,g|0,d+((c[s>>2]|0)-k<<1)|0,c[r>>2]|0,x|0),g=o,o=0,g&1):0){j=30;break}v=v+1|0;if((v|0)>=(c[h>>2]|0)){j=42;break a}}if((j|0)==29){f=Na()|0;break}else if((j|0)==30){f=Na()|0;break}}else j=42;while(0);do if((j|0)==42){o=0;ha(183,a|0);a=o;o=0;if(a&1){f=Na()|0;break}d=c[z>>2]|0;e=d;if(d){f=c[B>>2]|0;if((f|0)!=(d|0))c[B>>2]=f+(~((f+-4-e|0)>>>2)<<2);cj(d)}d=c[C>>2]|0;if(!d){i=A;return}e=c[D>>2]|0;if((e|0)!=(d|0))c[D>>2]=e+(~((e+-2-d|0)>>>1)<<1);cj(d);i=A;return}while(0);d=c[z>>2]|0;e=d;if(d){g=c[B>>2]|0;if((g|0)!=(d|0))c[B>>2]=g+(~((g+-4-e|0)>>>2)<<2);cj(d)}}d=c[C>>2]|0;if(!d)Ya(f|0);e=c[D>>2]|0;if((e|0)!=(d|0))c[D>>2]=e+(~((e+-2-d|0)>>>1)<<1);cj(d);Ya(f|0)}function qh(d,f){d=d|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;p=d+4572|0;f=c[p>>2]|0;s=d+148|0;if((c[s>>2]|0)<=0)return;q=d+4576|0;r=d+4580|0;i=f;j=e[f+-2>>1]|0;f=e[f>>1]|0;o=0;while(1){n=c[q>>2]|0;m=e[n+(o+-1<<1)>>1]|0;h=o+1|0;g=e[i+(h<<1)>>1]|0;l=c[r>>2]|0;k=f-j|0;i=j-m|0;l=((((a[l+(g-f)>>0]|0)*9|0)+(a[l+k>>0]|0)|0)*9|0)+(a[l+i>>0]|0)|0;if(!l){h=(sh(d,o,0)|0)+o|0;g=c[p>>2]|0;f=e[g+(h+-1<<1)>>1]|0;g=e[g+(h<<1)>>1]|0}else{j=f-m>>31;if((j^i|0)<0)i=f;else i=m+((j^k|0)<0?0:k)|0;n=rh(d,l,e[n+(o<<1)>>1]|0,i,0)|0;b[(c[q>>2]|0)+(o<<1)>>1]=n}if((h|0)>=(c[s>>2]|0))break;i=c[p>>2]|0;j=f;f=g;o=h}return}function rh(d,e,f,g,h){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0;s=e>>31;m=(s^e)-s|0;r=d+164+(m*12|0)+10|0;f=b[r>>1]|0;q=d+164+(m*12|0)|0;h=c[q>>2]|0;if((f|0)<(h|0))if((f<<1|0)<(h|0))if((f<<2|0)<(h|0))if((f<<3|0)<(h|0))if((f<<4|0)<(h|0)){i=5;while(1)if((f<<i|0)<(h|0))i=i+1|0;else break}else i=4;else i=3;else i=2;else i=1;else i=0;p=d+164+(m*12|0)+8|0;f=(b[p>>1]^s)-s+g|0;if((f&65535|0)!=(f|0))f=f>>31&65535^65535;h=d+112|0;if((c[h>>2]|0)<8)ge(d);g=d+108|0;j=c[g>>2]|0;k=j>>>24;l=c[2832+(i<<11)+(k<<3)+4>>2]|0;if(!l){h=Jg(d)|0;if((h|0)<47){if(i)h=(Kg(d,i)|0)+(h<<i)|0}else h=(Kg(d,16)|0)+1|0;h=h<<31>>31^h>>1;if((((h|0)>-1?h:0-h|0)|0)>65535){f=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,f|0,5,35648);e=o;o=0;if(e&1){e=Na()|0;La(f|0);Ya(e|0)}else lb(f|0,824,96)}}else{c[h>>2]=(c[h>>2]|0)-l;c[g>>2]=j<<l;h=c[2832+(i<<11)+(k<<3)>>2]|0}l=d+164+(m*12|0)+4|0;g=c[l>>2]|0;if(!i){d=b[r>>1]|0;i=d;h=(g<<1)+-1+(d<<16>>16)>>31^h}else i=b[r>>1]|0;j=i<<16>>16==64;d=j&1;k=g+h>>d;j=j?32:i<<16>>16;c[q>>2]=((h|0)>-1?h:0-h|0)+(c[q>>2]|0)>>d;g=j+1|0;b[r>>1]=g;i=g+k|0;if((i|0)<1){r=b[p>>1]|0;b[p>>1]=(r&65535)-(r<<16>>16>-128&1);r=(i|0)>(~j|0)?i:0-j|0;c[l>>2]=r;s=h^s;e=e>>>31;e=f+e|0;e=e+s|0;e=e&65535;return e|0}if((k|0)<=0){r=k;c[l>>2]=r;s=h^s;e=e>>>31;e=f+e|0;e=e+s|0;e=e&65535;return e|0}r=k-g|0;q=b[p>>1]|0;b[p>>1]=(q<<16>>16<127&1)+(q&65535);r=(r|0)>0?0:r;c[l>>2]=r;s=h^s;e=e>>>31;e=f+e|0;e=e+s|0;e=e&65535;return e|0}function sh(a,d,f){a=a|0;d=d|0;f=f|0;var g=0,h=0,i=0,j=0;i=a+4576|0;h=c[i>>2]|0;f=b[h+(d+-1<<1)>>1]|0;j=a+148|0;h=th(a,f,h+(d<<1)|0,(c[j>>2]|0)-d|0)|0;g=h+d|0;if((g|0)==(c[j>>2]|0)){j=h;return j|0}f=f&65535;d=e[(c[a+4572>>2]|0)+(g<<1)>>1]|0;j=f-d|0;if((((j|0)>-1?j:0-j|0)|0)<1)f=(uh(a,a+4556|0)|0)+f|0;else f=($(uh(a,a+4544|0)|0,d-f>>31|1)|0)+d|0;b[(c[i>>2]|0)+(g<<1)>>1]=f;j=a+4568|0;a=c[j>>2]|0;c[j>>2]=(a|0)<1?0:a+-1|0;j=h+1|0;return j|0}function th(d,e,f,g){d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0;k=d+112|0;l=d+108|0;m=d+4568|0;h=c[k>>2]|0;i=0;while(1){if((h|0)<1){ge(d);h=c[k>>2]|0}j=c[l>>2]|0;h=h+-1|0;c[k>>2]=h;c[l>>2]=j<<1;if((j|0)>=0){p=8;break}j=c[m>>2]|0;q=1<<c[36476+(j<<2)>>2];r=g-i|0;r=(q|0)<(r|0)?q:r;i=r+i|0;if((r|0)==(q|0))c[m>>2]=(j|0)>30?31:j+1|0;if((i|0)==(g|0)){h=g;break}}if((p|0)==8)if((i|0)!=(g|0)){h=c[m>>2]|0;if((h+-4|0)>>>0<28)h=Kg(d,c[36476+(h<<2)>>2]|0)|0;else h=0;h=h+i|0;if((h|0)>(g|0)){h=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,h|0,5,35648);r=o;o=0;if(r&1){r=Na()|0;La(h|0);Ya(r|0)}else lb(h|0,824,96)}}else h=g;if((h|0)>0)i=0;else return h|0;do{b[f+(i<<1)>>1]=e;i=i+1|0}while((i|0)!=(h|0));return h|0}function uh(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0;k=e+9|0;f=d[k>>0]|0;i=e+4|0;h=($(f>>>1,c[i>>2]|0)|0)+(c[e>>2]|0)|0;if((f|0)<(h|0)){g=0;do{f=f<<1;g=g+1|0}while((f|0)<(h|0))}else g=0;h=c[36476+(c[b+4568>>2]<<2)>>2]|0;f=Jg(b)|0;do if((f|0)<(46-h|0))if(!g){b=c[i>>2]|0;h=b+f|0;g=h&1;h=(g+h|0)/2|0;j=8;break}else{f=(Kg(b,g)|0)+(f<<g)|0;b=c[i>>2]|0;h=f+b|0;l=h&1;g=l;i=1;h=(l+h|0)/2|0;break}else{f=(Kg(b,16)|0)+1|0;b=c[i>>2]|0;h=f+b|0;i=h&1;h=(i+h|0)/2|0;if(!g){g=i;j=8}else{g=i;i=1}}while(0);if((j|0)==8)i=d[e+10>>0]<<1>>>0>=(d[k>>0]|0)>>>0;h=(g|0)!=0^i?h:0-h|0;if((h|0)<0){l=e+10|0;a[l>>0]=(d[l>>0]|0)+1}f=(f+1-b>>1)+(c[e>>2]|0)|0;c[e>>2]=f;g=a[k>>0]|0;if(g<<24>>24!=(a[e+8>>0]|0)){l=g;l=l&255;l=l+1|0;l=l&255;a[k>>0]=l;return h|0}c[e>>2]=f>>1;l=(g&255)>>>1;a[k>>0]=l;e=e+10|0;a[e>>0]=(d[e>>0]|0)>>>1;l=l&255;l=l+1|0;l=l&255;a[k>>0]=l;return h|0}function vh(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;m=i;i=i+32|0;k=m;Ei(k,65535,0);l=b+152|0;if(((c[k+4>>2]|0)==(c[l>>2]|0)?(c[k+8>>2]|0)==(c[b+156>>2]|0):0)?(c[k+12>>2]|0)==(c[b+160>>2]|0):0){l=c[8909]|0;c[b+4580>>2]=l+(((c[8910]|0)-l|0)>>>1);i=m;return}e=b+4584|0;f=b+4588|0;g=c[f>>2]|0;d=c[e>>2]|0;h=g-d|0;if(h>>>0>=131072){if(h>>>0>131072?(j=d+131072|0,(g|0)!=(j|0)):0)c[f>>2]=j}else{ie(e,131072-h|0);d=c[e>>2]|0}k=b+4580|0;c[k>>2]=d+65536;j=b+160|0;g=b+156|0;h=-65536;while(1){d=c[j>>2]|0;if((h|0)>(0-d|0)){e=c[g>>2]|0;if((h|0)>(0-e|0)){f=c[l>>2]|0;if((h|0)>(0-f|0))if((h|0)>=0){if((h|0)<1){a[(c[k>>2]|0)+h>>0]=0;h=1;continue}if((f|0)<=(h|0))if((e|0)>(h|0))d=2;else d=(d|0)>(h|0)?3:4;else d=1}else d=-1;else d=-2}else d=-3}else d=-4;a[(c[k>>2]|0)+h>>0]=d;h=h+1|0;if((h|0)==65536)break}i=m;return}function wh(a){a=a|0;var b=0,d=0;c[a>>2]=35744;b=c[a+4584>>2]|0;if(b){d=a+4588|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}c[a>>2]=36736;b=c[a+92>>2]|0;if(b){d=a+96|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}a=a+88|0;b=c[a>>2]|0;c[a>>2]=0;if(!b)return;Bb[c[(c[b>>2]|0)+4>>2]&255](b);return}function xh(a){a=a|0;var b=0,d=0;c[a>>2]=35744;b=c[a+4584>>2]|0;if(b){d=a+4588|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}c[a>>2]=36736;b=c[a+92>>2]|0;if(b){d=a+96|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}d=a+88|0;b=c[d>>2]|0;c[d>>2]=0;if(!b){cj(a);return}Bb[c[(c[b>>2]|0)+4>>2]&255](b);cj(a);return}function yh(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;w=i;i=i+352|0;x=w+328|0;y=w+192|0;e=w+343|0;f=w+342|0;g=w+341|0;h=w+340|0;r=w+176|0;k=w+168|0;l=w+160|0;m=w+152|0;v=w;t=w+136|0;if((c[b+28>>2]|0)!=0?(c[b+20>>2]|0)!=1:0){s=b+4|0;u=b+32|0;j=c[u>>2]|0;if(!j){b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[e>>0]|0;Aa(37,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}b=c[b+12>>2]|0;if((b|0)==16)switch(j|0){case 1:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[f>>0]|0;Aa(38,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 2:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[g>>0]|0;Aa(39,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 3:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[h>>0]|0;Aa(40,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}default:{j=y+56|0;g=y+4|0;c[y>>2]=36160;c[j>>2]=36180;o=0;ia(62,y+56|0,g|0);w=o;o=0;if(w&1){z=Na()|0;fn(j);Ya(z|0)}c[y+128>>2]=0;c[y+132>>2]=-1;c[y>>2]=36200;c[y+56>>2]=36220;o=0;ha(180,g|0);w=o;o=0;do if(w&1)b=Na()|0;else{c[g>>2]=36236;h=y+36|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[y+52>>2]=16;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;o=0;ia(63,g|0,x|0);w=o;o=0;if(w&1){b=Na()|0;Im(x);Im(h);nn(g);break}Im(x);o=0;b=ma(28,y|0,49007,21)|0;x=o;o=0;do if((!(x&1)?(o=0,p=ra(36,b|0,c[u>>2]|0)|0,x=o,o=0,!(x&1)):0)?(o=0,ma(28,p|0,50997,18)|0,x=o,o=0,!(x&1)):0){f=Ma(16)|0;o=0;ia(64,r|0,g|0);x=o;o=0;if(!(x&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,f|0,9,35648,r|0);x=o;o=0;if(x&1)e=1;else{o=0;wa(6,f|0,824,96);o=0;e=0}b=Na()|0;Im(r);if(!e)break}else b=Na()|0;La(f|0)}else z=34;while(0);if((z|0)==34)b=Na()|0;c[y>>2]=36200;c[j>>2]=36220;c[g>>2]=36236;Im(h);nn(g);fn(j);z=b;Ya(z|0)}while(0);z=b;fn(j);Ya(z|0)}}if((b|0)<=8){b=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,b|0,8,35648);z=o;o=0;if(!(z&1))lb(b|0,824,96);z=Na()|0;La(b|0);Ya(z|0)}e=16-b|0;switch(j|0){case 1:{b=bj(60)|0;c[k>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[k>>2];c[x+4>>2]=c[k+4>>2];Aa(41,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 2:{b=bj(60)|0;c[l>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[l>>2];c[x+4>>2]=c[l+4>>2];Aa(42,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 3:{b=bj(60)|0;c[m>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[m>>2];c[x+4>>2]=c[m+4>>2];Aa(43,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}default:{j=v+56|0;g=v+4|0;c[v>>2]=36160;c[j>>2]=36180;o=0;ia(62,v+56|0,g|0);y=o;o=0;if(y&1){z=Na()|0;fn(j);Ya(z|0)}c[v+128>>2]=0;c[v+132>>2]=-1;c[v>>2]=36200;c[v+56>>2]=36220;o=0;ha(180,g|0);y=o;o=0;do if(y&1)b=Na()|0;else{c[g>>2]=36236;h=v+36|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[v+52>>2]=16;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;o=0;ia(63,g|0,x|0);y=o;o=0;if(y&1){b=Na()|0;Im(x);Im(h);nn(g);break}Im(x);o=0;b=ma(28,v|0,49007,21)|0;y=o;o=0;do if((!(y&1)?(o=0,q=ra(36,b|0,c[u>>2]|0)|0,y=o,o=0,!(y&1)):0)?(o=0,ma(28,q|0,50997,18)|0,y=o,o=0,!(y&1)):0){f=Ma(16)|0;o=0;ia(64,t|0,g|0);y=o;o=0;if(!(y&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,f|0,9,35648,t|0);y=o;o=0;if(y&1)e=1;else{o=0;wa(6,f|0,824,96);o=0;e=0}b=Na()|0;Im(t);if(!e)break}else b=Na()|0;La(f|0)}else z=64;while(0);if((z|0)==64)b=Na()|0;c[v>>2]=36200;c[j>>2]=36220;c[g>>2]=36236;Im(h);nn(g);fn(j);z=b;Ya(z|0)}while(0);z=b;fn(j);Ya(z|0)}}}e=c[d+4>>2]|0;f=bj(16)|0;b=c[b+16>>2]|0;if(!e){z=c[d>>2]|0;c[f>>2]=36132;c[f+4>>2]=z;c[f+8>>2]=2;c[f+12>>2]=b;z=f;i=w;return z|0}else{c[f>>2]=36108;c[f+4>>2]=e;c[f+8>>2]=2;c[f+12>>2]=b;z=f;i=w;return z|0}return 0}function zh(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;h=i;i=i+32|0;l=h;Ei(l,4095,0);k=c[e+4>>2]|0;j=c[e+8>>2]|0;j=(j|0)==0?c[l+8>>2]|0:j;g=c[e+12>>2]|0;g=(g|0)==0?c[l+12>>2]|0:g;e=c[e+16>>2]|0;f=c[l+16>>2]|0;c[d+152>>2]=(k|0)==0?c[l+4>>2]|0:k;c[d+156>>2]=j;c[d+160>>2]=g;Hh(d);g=0;do{c[d+164+(g*12|0)>>2]=64;c[d+164+(g*12|0)+4>>2]=0;b[d+164+(g*12|0)+8>>1]=0;b[d+164+(g*12|0)+10>>1]=1;g=g+1|0}while((g|0)!=365);l=((e|0)==0?f:e)&255;c[d+4544>>2]=64;c[d+4548>>2]=0;a[d+4552>>0]=l;a[d+4553>>0]=1;a[d+4554>>0]=0;c[d+4556>>2]=64;c[d+4560>>2]=1;a[d+4564>>0]=l;a[d+4565>>0]=1;a[d+4566>>0]=0;c[d+4568>>2]=0;i=h;return}function Ah(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0;i=b+88|0;h=c[d>>2]|0;c[d>>2]=0;d=c[i>>2]|0;c[i>>2]=h;if(d)Bb[c[(c[d>>2]|0)+4>>2]&255](d);i=f+4|0;h=c[i>>2]|0;a[b+4596>>0]=g&1;d=b+132|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];Wd(b,f);Bh(b);d=c[b+116>>2]|0;b=c[b+112>>2]|0;while(1){g=d+-1|0;e=(a[g>>0]|0)==-1?7:8;if((b|0)<(e|0))break;else{d=g;b=b-e|0}}d=d-h|0;g=c[i>>2]|0;if(!g)return;c[i>>2]=g+d;f=f+8|0;c[f>>2]=(c[f>>2]|0)-d;return}function Bh(a){a=a|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;A=i;i=i+32|0;C=A+12|0;z=A;w=a+148|0;x=(c[w>>2]|0)+4|0;if((c[a+28>>2]|0)==1)y=c[a+20>>2]|0;else y=1;d=$(y<<1,x)|0;c[C>>2]=0;D=C+4|0;c[D>>2]=0;c[C+8>>2]=0;do if(d){if(!((d|0)<0?(o=0,ha(178,C|0),B=o,o=0,B&1):0))j=6;if((j|0)==6?(e=d<<1,o=0,f=ka(67,e|0)|0,B=o,o=0,!(B&1)):0){c[C>>2]=f;B=f+(d<<1)|0;c[C+8>>2]=B;iw(f|0,0,e|0)|0;c[D>>2]=B;break}f=Na()|0;d=c[C>>2]|0;if(!d)Ya(f|0);e=c[D>>2]|0;if((e|0)!=(d|0))c[D>>2]=e+(~((e+-2-d|0)>>>1)<<1);cj(d);Ya(f|0)}while(0);c[z>>2]=0;B=z+4|0;c[B>>2]=0;c[z+8>>2]=0;do if(!y)j=18;else{if(!(y>>>0>1073741823?(o=0,ha(178,z|0),v=o,o=0,v&1):0))j=16;if((j|0)==16?(g=y<<2,o=0,h=ka(67,g|0)|0,v=o,o=0,!(v&1)):0){c[z>>2]=h;j=h+(y<<2)|0;c[z+8>>2]=j;iw(h|0,0,g|0)|0;c[B>>2]=j;j=18;break}f=Na()|0;d=c[z>>2]|0;e=d;if(d){g=c[B>>2]|0;if((g|0)!=(d|0))c[B>>2]=g+(~((g+-4-e|0)>>>2)<<2);cj(d)}}while(0);if((j|0)==18){h=a+8|0;a:do if((c[h>>2]|0)>0){j=a+4572|0;k=$(y,x)|0;l=k+1|0;m=a+4576|0;n=(y|0)>0;p=a+136|0;q=a+144|0;r=a+140|0;s=a+132|0;t=a+88|0;u=a+4568|0;v=0;b:while(1){f=c[C>>2]|0;e=f+2|0;c[j>>2]=e;f=f+(l<<1)|0;c[m>>2]=f;if(!(v&1))d=f;else{c[j>>2]=f;c[m>>2]=e;d=e;e=f}if(n){g=c[z>>2]|0;f=0;do{c[u>>2]=c[g+(f<<2)>>2];g=c[w>>2]|0;b[e+(g<<1)>>1]=b[e+(g+-1<<1)>>1]|0;b[d+-2>>1]=b[e>>1]|0;o=0;ia(80,a|0,0);g=o;o=0;if(g&1){j=29;break b}g=c[z>>2]|0;c[g+(f<<2)>>2]=c[u>>2];e=(c[j>>2]|0)+(x<<1)|0;c[j>>2]=e;d=(c[m>>2]|0)+(x<<1)|0;c[m>>2]=d;f=f+1|0}while((f|0)<(y|0))}g=c[p>>2]|0;if(((g|0)<=(v|0)?(v|0)<((c[q>>2]|0)+g|0):0)?(g=c[t>>2]|0,o=0,Aa(c[(c[g>>2]|0)+8>>2]|0,g|0,d+((c[s>>2]|0)-k<<1)|0,c[r>>2]|0,x|0),g=o,o=0,g&1):0){j=30;break}v=v+1|0;if((v|0)>=(c[h>>2]|0)){j=42;break a}}if((j|0)==29){f=Na()|0;break}else if((j|0)==30){f=Na()|0;break}}else j=42;while(0);do if((j|0)==42){o=0;ha(183,a|0);a=o;o=0;if(a&1){f=Na()|0;break}d=c[z>>2]|0;e=d;if(d){f=c[B>>2]|0;if((f|0)!=(d|0))c[B>>2]=f+(~((f+-4-e|0)>>>2)<<2);cj(d)}d=c[C>>2]|0;if(!d){i=A;return}e=c[D>>2]|0;if((e|0)!=(d|0))c[D>>2]=e+(~((e+-2-d|0)>>>1)<<1);cj(d);i=A;return}while(0);d=c[z>>2]|0;e=d;if(d){g=c[B>>2]|0;if((g|0)!=(d|0))c[B>>2]=g+(~((g+-4-e|0)>>>2)<<2);cj(d)}}d=c[C>>2]|0;if(!d)Ya(f|0);e=c[D>>2]|0;if((e|0)!=(d|0))c[D>>2]=e+(~((e+-2-d|0)>>>1)<<1);cj(d);Ya(f|0)}function Ch(d,f){d=d|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;p=d+4572|0;f=c[p>>2]|0;s=d+148|0;if((c[s>>2]|0)<=0)return;q=d+4576|0;r=d+4580|0;i=f;j=e[f+-2>>1]|0;f=e[f>>1]|0;o=0;while(1){n=c[q>>2]|0;m=e[n+(o+-1<<1)>>1]|0;h=o+1|0;g=e[i+(h<<1)>>1]|0;l=c[r>>2]|0;k=f-j|0;i=j-m|0;l=((((a[l+(g-f)>>0]|0)*9|0)+(a[l+k>>0]|0)|0)*9|0)+(a[l+i>>0]|0)|0;if(!l){h=(Eh(d,o,0)|0)+o|0;g=c[p>>2]|0;f=e[g+(h+-1<<1)>>1]|0;g=e[g+(h<<1)>>1]|0}else{j=f-m>>31;if((j^i|0)<0)i=f;else i=m+((j^k|0)<0?0:k)|0;n=Dh(d,l,e[n+(o<<1)>>1]|0,i,0)|0;b[(c[q>>2]|0)+(o<<1)>>1]=n}if((h|0)>=(c[s>>2]|0))break;i=c[p>>2]|0;j=f;f=g;o=h}return}function Dh(d,e,f,g,h){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0;s=e>>31;m=(s^e)-s|0;r=d+164+(m*12|0)+10|0;f=b[r>>1]|0;q=d+164+(m*12|0)|0;h=c[q>>2]|0;if((f|0)<(h|0))if((f<<1|0)<(h|0))if((f<<2|0)<(h|0))if((f<<3|0)<(h|0))if((f<<4|0)<(h|0)){i=5;while(1)if((f<<i|0)<(h|0))i=i+1|0;else break}else i=4;else i=3;else i=2;else i=1;else i=0;p=d+164+(m*12|0)+8|0;f=(b[p>>1]^s)-s+g|0;if((f&4095|0)!=(f|0))f=f>>31&4095^4095;h=d+112|0;if((c[h>>2]|0)<8)ge(d);g=d+108|0;j=c[g>>2]|0;k=j>>>24;l=c[2832+(i<<11)+(k<<3)+4>>2]|0;if(!l){h=Jg(d)|0;if((h|0)<35){if(i)h=(Kg(d,i)|0)+(h<<i)|0}else h=(Kg(d,12)|0)+1|0;h=h<<31>>31^h>>1;if((((h|0)>-1?h:0-h|0)|0)>65535){f=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,f|0,5,35648);e=o;o=0;if(e&1){e=Na()|0;La(f|0);Ya(e|0)}else lb(f|0,824,96)}}else{c[h>>2]=(c[h>>2]|0)-l;c[g>>2]=j<<l;h=c[2832+(i<<11)+(k<<3)>>2]|0}l=d+164+(m*12|0)+4|0;g=c[l>>2]|0;if(!i){d=b[r>>1]|0;i=d;h=(g<<1)+-1+(d<<16>>16)>>31^h}else i=b[r>>1]|0;j=i<<16>>16==64;d=j&1;k=g+h>>d;j=j?32:i<<16>>16;c[q>>2]=((h|0)>-1?h:0-h|0)+(c[q>>2]|0)>>d;g=j+1|0;b[r>>1]=g;i=g+k|0;if((i|0)<1){r=b[p>>1]|0;b[p>>1]=(r&65535)-(r<<16>>16>-128&1);r=(i|0)>(~j|0)?i:0-j|0;c[l>>2]=r;s=h^s;e=e>>>31;e=f+e|0;e=e+s|0;e=e&4095;e=e&65535;return e|0}if((k|0)<=0){r=k;c[l>>2]=r;s=h^s;e=e>>>31;e=f+e|0;e=e+s|0;e=e&4095;e=e&65535;return e|0}r=k-g|0;q=b[p>>1]|0;b[p>>1]=(q<<16>>16<127&1)+(q&65535);r=(r|0)>0?0:r;c[l>>2]=r;s=h^s;e=e>>>31;e=f+e|0;e=e+s|0;e=e&4095;e=e&65535;return e|0}function Eh(a,d,f){a=a|0;d=d|0;f=f|0;var g=0,h=0,i=0,j=0;i=a+4576|0;h=c[i>>2]|0;f=b[h+(d+-1<<1)>>1]|0;j=a+148|0;h=Fh(a,f,h+(d<<1)|0,(c[j>>2]|0)-d|0)|0;g=h+d|0;if((g|0)==(c[j>>2]|0)){j=h;return j|0}f=f&65535;d=e[(c[a+4572>>2]|0)+(g<<1)>>1]|0;j=f-d|0;if((((j|0)>-1?j:0-j|0)|0)<1)f=(Gh(a,a+4556|0)|0)+f|0;else f=($(Gh(a,a+4544|0)|0,d-f>>31|1)|0)+d|0;b[(c[i>>2]|0)+(g<<1)>>1]=f&4095;j=a+4568|0;a=c[j>>2]|0;c[j>>2]=(a|0)<1?0:a+-1|0;j=h+1|0;return j|0}function Fh(d,e,f,g){d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0;k=d+112|0;l=d+108|0;m=d+4568|0;h=c[k>>2]|0;i=0;while(1){if((h|0)<1){ge(d);h=c[k>>2]|0}j=c[l>>2]|0;h=h+-1|0;c[k>>2]=h;c[l>>2]=j<<1;if((j|0)>=0){p=8;break}j=c[m>>2]|0;q=1<<c[36476+(j<<2)>>2];r=g-i|0;r=(q|0)<(r|0)?q:r;i=r+i|0;if((r|0)==(q|0))c[m>>2]=(j|0)>30?31:j+1|0;if((i|0)==(g|0)){h=g;break}}if((p|0)==8)if((i|0)!=(g|0)){h=c[m>>2]|0;if((h+-4|0)>>>0<28)h=Kg(d,c[36476+(h<<2)>>2]|0)|0;else h=0;h=h+i|0;if((h|0)>(g|0)){h=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,h|0,5,35648);r=o;o=0;if(r&1){r=Na()|0;La(h|0);Ya(r|0)}else lb(h|0,824,96)}}else h=g;if((h|0)>0)i=0;else return h|0;do{b[f+(i<<1)>>1]=e;i=i+1|0}while((i|0)!=(h|0));return h|0}function Gh(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0;k=e+9|0;f=d[k>>0]|0;i=e+4|0;h=($(f>>>1,c[i>>2]|0)|0)+(c[e>>2]|0)|0;if((f|0)<(h|0)){g=0;do{f=f<<1;g=g+1|0}while((f|0)<(h|0))}else g=0;h=c[36476+(c[b+4568>>2]<<2)>>2]|0;f=Jg(b)|0;do if((f|0)<(34-h|0))if(!g){b=c[i>>2]|0;h=b+f|0;g=h&1;h=(g+h|0)/2|0;j=8;break}else{f=(Kg(b,g)|0)+(f<<g)|0;b=c[i>>2]|0;h=f+b|0;l=h&1;g=l;i=1;h=(l+h|0)/2|0;break}else{f=(Kg(b,12)|0)+1|0;b=c[i>>2]|0;h=f+b|0;i=h&1;h=(i+h|0)/2|0;if(!g){g=i;j=8}else{g=i;i=1}}while(0);if((j|0)==8)i=d[e+10>>0]<<1>>>0>=(d[k>>0]|0)>>>0;h=(g|0)!=0^i?h:0-h|0;if((h|0)<0){l=e+10|0;a[l>>0]=(d[l>>0]|0)+1}f=(f+1-b>>1)+(c[e>>2]|0)|0;c[e>>2]=f;g=a[k>>0]|0;if(g<<24>>24!=(a[e+8>>0]|0)){l=g;l=l&255;l=l+1|0;l=l&255;a[k>>0]=l;return h|0}c[e>>2]=f>>1;l=(g&255)>>>1;a[k>>0]=l;e=e+10|0;a[e>>0]=(d[e>>0]|0)>>>1;l=l&255;l=l+1|0;l=l&255;a[k>>0]=l;return h|0}function Hh(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;m=i;i=i+32|0;k=m;Ei(k,4095,0);l=b+152|0;if(((c[k+4>>2]|0)==(c[l>>2]|0)?(c[k+8>>2]|0)==(c[b+156>>2]|0):0)?(c[k+12>>2]|0)==(c[b+160>>2]|0):0){l=c[8906]|0;c[b+4580>>2]=l+(((c[8907]|0)-l|0)>>>1);i=m;return}e=b+4584|0;f=b+4588|0;g=c[f>>2]|0;d=c[e>>2]|0;h=g-d|0;if(h>>>0>=8192){if(h>>>0>8192?(j=d+8192|0,(g|0)!=(j|0)):0)c[f>>2]=j}else{ie(e,8192-h|0);d=c[e>>2]|0}k=b+4580|0;c[k>>2]=d+4096;j=b+160|0;g=b+156|0;h=-4096;while(1){d=c[j>>2]|0;if((h|0)>(0-d|0)){e=c[g>>2]|0;if((h|0)>(0-e|0)){f=c[l>>2]|0;if((h|0)>(0-f|0))if((h|0)>=0){if((h|0)<1){a[(c[k>>2]|0)+h>>0]=0;h=1;continue}if((f|0)<=(h|0))if((e|0)>(h|0))d=2;else d=(d|0)>(h|0)?3:4;else d=1}else d=-1;else d=-2}else d=-3}else d=-4;a[(c[k>>2]|0)+h>>0]=d;h=h+1|0;if((h|0)==4096)break}i=m;return}function Ih(a){a=a|0;var b=0,d=0;c[a>>2]=35716;b=c[a+4584>>2]|0;if(b){d=a+4588|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}c[a>>2]=36736;b=c[a+92>>2]|0;if(b){d=a+96|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}a=a+88|0;b=c[a>>2]|0;c[a>>2]=0;if(!b)return;Bb[c[(c[b>>2]|0)+4>>2]&255](b);return}function Jh(a){a=a|0;var b=0,d=0;c[a>>2]=35716;b=c[a+4584>>2]|0;if(b){d=a+4588|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}c[a>>2]=36736;b=c[a+92>>2]|0;if(b){d=a+96|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}d=a+88|0;b=c[d>>2]|0;c[d>>2]=0;if(!b){cj(a);return}Bb[c[(c[b>>2]|0)+4>>2]&255](b);cj(a);return}function Kh(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;w=i;i=i+352|0;x=w+328|0;y=w+192|0;e=w+343|0;f=w+342|0;g=w+341|0;h=w+340|0;r=w+176|0;k=w+168|0;l=w+160|0;m=w+152|0;v=w;t=w+136|0;if((c[b+28>>2]|0)!=0?(c[b+20>>2]|0)!=1:0){s=b+4|0;u=b+32|0;j=c[u>>2]|0;if(!j){b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[e>>0]|0;Aa(44,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}b=c[b+12>>2]|0;if((b|0)==8)switch(j|0){case 1:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[f>>0]|0;Aa(45,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 2:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[g>>0]|0;Aa(46,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 3:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[h>>0]|0;Aa(47,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}default:{j=y+56|0;g=y+4|0;c[y>>2]=36160;c[j>>2]=36180;o=0;ia(62,y+56|0,g|0);w=o;o=0;if(w&1){z=Na()|0;fn(j);Ya(z|0)}c[y+128>>2]=0;c[y+132>>2]=-1;c[y>>2]=36200;c[y+56>>2]=36220;o=0;ha(180,g|0);w=o;o=0;do if(w&1)b=Na()|0;else{c[g>>2]=36236;h=y+36|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[y+52>>2]=16;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;o=0;ia(63,g|0,x|0);w=o;o=0;if(w&1){b=Na()|0;Im(x);Im(h);nn(g);break}Im(x);o=0;b=ma(28,y|0,49007,21)|0;x=o;o=0;do if((!(x&1)?(o=0,p=ra(36,b|0,c[u>>2]|0)|0,x=o,o=0,!(x&1)):0)?(o=0,ma(28,p|0,50997,18)|0,x=o,o=0,!(x&1)):0){f=Ma(16)|0;o=0;ia(64,r|0,g|0);x=o;o=0;if(!(x&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,f|0,9,35648,r|0);x=o;o=0;if(x&1)e=1;else{o=0;wa(6,f|0,824,96);o=0;e=0}b=Na()|0;Im(r);if(!e)break}else b=Na()|0;La(f|0)}else z=34;while(0);if((z|0)==34)b=Na()|0;c[y>>2]=36200;c[j>>2]=36220;c[g>>2]=36236;Im(h);nn(g);fn(j);z=b;Ya(z|0)}while(0);z=b;fn(j);Ya(z|0)}}if((b|0)<=8){b=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,b|0,8,35648);z=o;o=0;if(!(z&1))lb(b|0,824,96);z=Na()|0;La(b|0);Ya(z|0)}e=16-b|0;switch(j|0){case 1:{b=bj(60)|0;c[k>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[k>>2];c[x+4>>2]=c[k+4>>2];Aa(41,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 2:{b=bj(60)|0;c[l>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[l>>2];c[x+4>>2]=c[l+4>>2];Aa(42,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 3:{b=bj(60)|0;c[m>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[m>>2];c[x+4>>2]=c[m+4>>2];Aa(43,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}default:{j=v+56|0;g=v+4|0;c[v>>2]=36160;c[j>>2]=36180;o=0;ia(62,v+56|0,g|0);y=o;o=0;if(y&1){z=Na()|0;fn(j);Ya(z|0)}c[v+128>>2]=0;c[v+132>>2]=-1;c[v>>2]=36200;c[v+56>>2]=36220;o=0;ha(180,g|0);y=o;o=0;do if(y&1)b=Na()|0;else{c[g>>2]=36236;h=v+36|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[v+52>>2]=16;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;o=0;ia(63,g|0,x|0);y=o;o=0;if(y&1){b=Na()|0;Im(x);Im(h);nn(g);break}Im(x);o=0;b=ma(28,v|0,49007,21)|0;y=o;o=0;do if((!(y&1)?(o=0,q=ra(36,b|0,c[u>>2]|0)|0,y=o,o=0,!(y&1)):0)?(o=0,ma(28,q|0,50997,18)|0,y=o,o=0,!(y&1)):0){f=Ma(16)|0;o=0;ia(64,t|0,g|0);y=o;o=0;if(!(y&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,f|0,9,35648,t|0);y=o;o=0;if(y&1)e=1;else{o=0;wa(6,f|0,824,96);o=0;e=0}b=Na()|0;Im(t);if(!e)break}else b=Na()|0;La(f|0)}else z=64;while(0);if((z|0)==64)b=Na()|0;c[v>>2]=36200;c[j>>2]=36220;c[g>>2]=36236;Im(h);nn(g);fn(j);z=b;Ya(z|0)}while(0);z=b;fn(j);Ya(z|0)}}}e=c[d+4>>2]|0;f=bj(16)|0;b=c[b+16>>2]|0;if(!e){z=c[d>>2]|0;c[f>>2]=36132;c[f+4>>2]=z;c[f+8>>2]=1;c[f+12>>2]=b;z=f;i=w;return z|0}else{c[f>>2]=36108;c[f+4>>2]=e;c[f+8>>2]=1;c[f+12>>2]=b;z=f;i=w;return z|0}return 0}function Lh(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;h=i;i=i+32|0;l=h;Ei(l,255,0);k=c[e+4>>2]|0;j=c[e+8>>2]|0;j=(j|0)==0?c[l+8>>2]|0:j;g=c[e+12>>2]|0;g=(g|0)==0?c[l+12>>2]|0:g;e=c[e+16>>2]|0;f=c[l+16>>2]|0;c[d+152>>2]=(k|0)==0?c[l+4>>2]|0:k;c[d+156>>2]=j;c[d+160>>2]=g;Th(d);g=0;do{c[d+164+(g*12|0)>>2]=4;c[d+164+(g*12|0)+4>>2]=0;b[d+164+(g*12|0)+8>>1]=0;b[d+164+(g*12|0)+10>>1]=1;g=g+1|0}while((g|0)!=365);l=((e|0)==0?f:e)&255;c[d+4544>>2]=4;c[d+4548>>2]=0;a[d+4552>>0]=l;a[d+4553>>0]=1;a[d+4554>>0]=0;c[d+4556>>2]=4;c[d+4560>>2]=1;a[d+4564>>0]=l;a[d+4565>>0]=1;a[d+4566>>0]=0;c[d+4568>>2]=0;i=h;return}function Mh(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0;i=b+88|0;h=c[d>>2]|0;c[d>>2]=0;d=c[i>>2]|0;c[i>>2]=h;if(d)Bb[c[(c[d>>2]|0)+4>>2]&255](d);i=f+4|0;h=c[i>>2]|0;a[b+4596>>0]=g&1;d=b+132|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];Wd(b,f);Nh(b);d=c[b+116>>2]|0;b=c[b+112>>2]|0;while(1){g=d+-1|0;e=(a[g>>0]|0)==-1?7:8;if((b|0)<(e|0))break;else{d=g;b=b-e|0}}d=d-h|0;g=c[i>>2]|0;if(!g)return;c[i>>2]=g+d;f=f+8|0;c[f>>2]=(c[f>>2]|0)-d;return}function Nh(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;A=i;i=i+32|0;C=A+12|0;z=A;w=b+148|0;x=(c[w>>2]|0)+4|0;if((c[b+28>>2]|0)==1)y=c[b+20>>2]|0;else y=1;d=$(y<<1,x)|0;c[C>>2]=0;D=C+4|0;c[D>>2]=0;c[C+8>>2]=0;a:do if(d){if(!((d|0)<0?(o=0,ha(178,C|0),B=o,o=0,B&1):0))h=6;if((h|0)==6?(o=0,e=ka(67,d|0)|0,B=o,o=0,!(B&1)):0){c[D>>2]=e;c[C>>2]=e;c[C+8>>2]=e+d;while(1){a[e>>0]=0;e=(c[D>>2]|0)+1|0;c[D>>2]=e;d=d+-1|0;if(!d)break a}}e=Na()|0;d=c[C>>2]|0;if(!d)Ya(e|0);if((c[D>>2]|0)!=(d|0))c[D>>2]=d;cj(d);Ya(e|0)}while(0);c[z>>2]=0;B=z+4|0;c[B>>2]=0;c[z+8>>2]=0;do if(!y)h=19;else{if(!(y>>>0>1073741823?(o=0,ha(178,z|0),v=o,o=0,v&1):0))h=17;if((h|0)==17?(f=y<<2,o=0,g=ka(67,f|0)|0,v=o,o=0,!(v&1)):0){c[z>>2]=g;h=g+(y<<2)|0;c[z+8>>2]=h;iw(g|0,0,f|0)|0;c[B>>2]=h;h=19;break}e=Na()|0;d=c[z>>2]|0;f=d;if(d){g=c[B>>2]|0;if((g|0)!=(d|0))c[B>>2]=g+(~((g+-4-f|0)>>>2)<<2);cj(d)}}while(0);if((h|0)==19){h=b+8|0;b:do if((c[h>>2]|0)>0){j=b+4572|0;k=$(y,x)|0;l=k+1|0;m=b+4576|0;n=(y|0)>0;p=b+136|0;q=b+144|0;r=b+140|0;s=b+132|0;t=b+88|0;u=b+4568|0;v=0;c:while(1){f=c[C>>2]|0;e=f+1|0;c[j>>2]=e;f=f+l|0;c[m>>2]=f;if(!(v&1))d=f;else{c[j>>2]=f;c[m>>2]=e;d=e;e=f}if(n){g=c[z>>2]|0;f=0;do{c[u>>2]=c[g+(f<<2)>>2];g=c[w>>2]|0;a[e+g>>0]=a[e+(g+-1)>>0]|0;a[(c[m>>2]|0)+-1>>0]=a[c[j>>2]>>0]|0;o=0;ia(81,b|0,0);g=o;o=0;if(g&1){h=30;break c}g=c[z>>2]|0;c[g+(f<<2)>>2]=c[u>>2];e=(c[j>>2]|0)+x|0;c[j>>2]=e;d=(c[m>>2]|0)+x|0;c[m>>2]=d;f=f+1|0}while((f|0)<(y|0))}g=c[p>>2]|0;if(((g|0)<=(v|0)?(v|0)<((c[q>>2]|0)+g|0):0)?(g=c[t>>2]|0,o=0,Aa(c[(c[g>>2]|0)+8>>2]|0,g|0,d+((c[s>>2]|0)-k)|0,c[r>>2]|0,x|0),g=o,o=0,g&1):0){h=31;break}v=v+1|0;if((v|0)>=(c[h>>2]|0)){h=43;break b}}if((h|0)==30){e=Na()|0;break}else if((h|0)==31){e=Na()|0;break}}else h=43;while(0);do if((h|0)==43){o=0;ha(183,b|0);b=o;o=0;if(b&1){e=Na()|0;break}d=c[z>>2]|0;e=d;if(d){f=c[B>>2]|0;if((f|0)!=(d|0))c[B>>2]=f+(~((f+-4-e|0)>>>2)<<2);cj(d)}d=c[C>>2]|0;if(!d){i=A;return}if((c[D>>2]|0)!=(d|0))c[D>>2]=d;cj(d);i=A;return}while(0);d=c[z>>2]|0;f=d;if(d){g=c[B>>2]|0;if((g|0)!=(d|0))c[B>>2]=g+(~((g+-4-f|0)>>>2)<<2);cj(d)}}d=c[C>>2]|0;if(!d)Ya(e|0);if((c[D>>2]|0)!=(d|0))c[D>>2]=d;cj(d);Ya(e|0)}function Oh(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;o=b+4572|0;e=c[o>>2]|0;r=b+148|0;if((c[r>>2]|0)<=0)return;p=b+4576|0;q=b+4580|0;h=e;i=d[e+-1>>0]|0;e=d[e>>0]|0;n=0;while(1){m=c[p>>2]|0;l=d[m+(n+-1)>>0]|0;g=n+1|0;f=d[h+g>>0]|0;k=c[q>>2]|0;j=e-i|0;h=i-l|0;k=((((a[k+(f-e)>>0]|0)*9|0)+(a[k+j>>0]|0)|0)*9|0)+(a[k+h>>0]|0)|0;if(!k){g=(Qh(b,n,0)|0)+n|0;f=c[o>>2]|0;e=d[f+(g+-1)>>0]|0;f=d[f+g>>0]|0}else{i=e-l>>31;if((i^h|0)<0)h=e;else h=l+((i^j|0)<0?0:j)|0;m=Ph(b,k,d[m+n>>0]|0,h,0)|0;a[(c[p>>2]|0)+n>>0]=m}if((g|0)>=(c[r>>2]|0))break;h=c[o>>2]|0;i=e;e=f;n=g}return}function Ph(d,e,f,g,h){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0;s=e>>31;m=(s^e)-s|0;r=d+164+(m*12|0)+10|0;f=b[r>>1]|0;q=d+164+(m*12|0)|0;h=c[q>>2]|0;if((f|0)<(h|0))if((f<<1|0)<(h|0))if((f<<2|0)<(h|0))if((f<<3|0)<(h|0))if((f<<4|0)<(h|0)){i=5;while(1)if((f<<i|0)<(h|0))i=i+1|0;else break}else i=4;else i=3;else i=2;else i=1;else i=0;p=d+164+(m*12|0)+8|0;f=(b[p>>1]^s)-s+g|0;if((f&255|0)!=(f|0))f=f>>31&255^255;h=d+112|0;if((c[h>>2]|0)<8)ge(d);g=d+108|0;j=c[g>>2]|0;k=j>>>24;l=c[2832+(i<<11)+(k<<3)+4>>2]|0;if(!l){h=Jg(d)|0;if((h|0)<23){if(i)h=(Kg(d,i)|0)+(h<<i)|0}else h=(Kg(d,8)|0)+1|0;h=h<<31>>31^h>>1;if((((h|0)>-1?h:0-h|0)|0)>65535){f=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,f|0,5,35648);e=o;o=0;if(e&1){e=Na()|0;La(f|0);Ya(e|0)}else lb(f|0,824,96)}}else{c[h>>2]=(c[h>>2]|0)-l;c[g>>2]=j<<l;h=c[2832+(i<<11)+(k<<3)>>2]|0}l=d+164+(m*12|0)+4|0;g=c[l>>2]|0;if(!i){d=b[r>>1]|0;i=d;h=(g<<1)+-1+(d<<16>>16)>>31^h}else i=b[r>>1]|0;j=i<<16>>16==64;d=j&1;k=g+h>>d;j=j?32:i<<16>>16;c[q>>2]=((h|0)>-1?h:0-h|0)+(c[q>>2]|0)>>d;g=j+1|0;b[r>>1]=g;i=g+k|0;if((i|0)<1){r=b[p>>1]|0;b[p>>1]=(r&65535)-(r<<16>>16>-128&1);r=(i|0)>(~j|0)?i:0-j|0;c[l>>2]=r;s=h^s;e=e>>>31;e=f+e|0;e=e+s|0;e=e&255;return e|0}if((k|0)<=0){r=k;c[l>>2]=r;s=h^s;e=e>>>31;e=f+e|0;e=e+s|0;e=e&255;return e|0}r=k-g|0;q=b[p>>1]|0;b[p>>1]=(q<<16>>16<127&1)+(q&65535);r=(r|0)>0?0:r;c[l>>2]=r;s=h^s;e=e>>>31;e=f+e|0;e=e+s|0;e=e&255;return e|0}function Qh(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0;i=b+4576|0;h=c[i>>2]|0;f=a[h+(e+-1)>>0]|0;j=b+148|0;h=Rh(b,f,h+e|0,(c[j>>2]|0)-e|0)|0;g=h+e|0;if((g|0)==(c[j>>2]|0)){j=h;return j|0}f=f&255;e=d[(c[b+4572>>2]|0)+g>>0]|0;j=f-e|0;if((((j|0)>-1?j:0-j|0)|0)<1)f=(Sh(b,b+4556|0)|0)+f|0;else f=($(Sh(b,b+4544|0)|0,e-f>>31|1)|0)+e|0;a[(c[i>>2]|0)+g>>0]=f;j=b+4568|0;b=c[j>>2]|0;c[j>>2]=(b|0)<1?0:b+-1|0;j=h+1|0;return j|0}function Rh(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,p=0,q=0;j=b+112|0;k=b+108|0;l=b+4568|0;g=c[j>>2]|0;h=0;while(1){if((g|0)<1){ge(b);g=c[j>>2]|0}i=c[k>>2]|0;g=g+-1|0;c[j>>2]=g;c[k>>2]=i<<1;if((i|0)>=0){m=8;break}i=c[l>>2]|0;p=1<<c[36476+(i<<2)>>2];q=f-h|0;q=(p|0)<(q|0)?p:q;h=q+h|0;if((q|0)==(p|0))c[l>>2]=(i|0)>30?31:i+1|0;if((h|0)==(f|0)){g=f;break}}if((m|0)==8)if((h|0)!=(f|0)){g=c[l>>2]|0;if((g+-4|0)>>>0<28)g=Kg(b,c[36476+(g<<2)>>2]|0)|0;else g=0;g=g+h|0;if((g|0)>(f|0)){g=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,g|0,5,35648);q=o;o=0;if(q&1){q=Na()|0;La(g|0);Ya(q|0)}else lb(g|0,824,96)}}else g=f;if((g|0)<=0)return g|0;iw(e|0,d|0,g|0)|0;return g|0}function Sh(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0;k=e+9|0;f=d[k>>0]|0;i=e+4|0;h=($(f>>>1,c[i>>2]|0)|0)+(c[e>>2]|0)|0;if((f|0)<(h|0)){g=0;do{f=f<<1;g=g+1|0}while((f|0)<(h|0))}else g=0;h=c[36476+(c[b+4568>>2]<<2)>>2]|0;f=Jg(b)|0;do if((f|0)<(22-h|0))if(!g){b=c[i>>2]|0;h=b+f|0;g=h&1;h=(g+h|0)/2|0;j=8;break}else{f=(Kg(b,g)|0)+(f<<g)|0;b=c[i>>2]|0;h=f+b|0;l=h&1;g=l;i=1;h=(l+h|0)/2|0;break}else{f=(Kg(b,8)|0)+1|0;b=c[i>>2]|0;h=f+b|0;i=h&1;h=(i+h|0)/2|0;if(!g){g=i;j=8}else{g=i;i=1}}while(0);if((j|0)==8)i=d[e+10>>0]<<1>>>0>=(d[k>>0]|0)>>>0;h=(g|0)!=0^i?h:0-h|0;if((h|0)<0){l=e+10|0;a[l>>0]=(d[l>>0]|0)+1}f=(f+1-b>>1)+(c[e>>2]|0)|0;c[e>>2]=f;g=a[k>>0]|0;if(g<<24>>24!=(a[e+8>>0]|0)){l=g;l=l&255;l=l+1|0;l=l&255;a[k>>0]=l;return h|0}c[e>>2]=f>>1;l=(g&255)>>>1;a[k>>0]=l;e=e+10|0;a[e>>0]=(d[e>>0]|0)>>>1;l=l&255;l=l+1|0;l=l&255;a[k>>0]=l;return h|0}function Th(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;m=i;i=i+32|0;k=m;Ei(k,255,0);l=b+152|0;if(((c[k+4>>2]|0)==(c[l>>2]|0)?(c[k+8>>2]|0)==(c[b+156>>2]|0):0)?(c[k+12>>2]|0)==(c[b+160>>2]|0):0){l=c[8900]|0;c[b+4580>>2]=l+(((c[8901]|0)-l|0)>>>1);i=m;return}e=b+4584|0;f=b+4588|0;g=c[f>>2]|0;d=c[e>>2]|0;h=g-d|0;if(h>>>0>=512){if(h>>>0>512?(j=d+512|0,(g|0)!=(j|0)):0)c[f>>2]=j}else{ie(e,512-h|0);d=c[e>>2]|0}k=b+4580|0;c[k>>2]=d+256;j=b+160|0;g=b+156|0;h=-256;while(1){d=c[j>>2]|0;if((h|0)>(0-d|0)){e=c[g>>2]|0;if((h|0)>(0-e|0)){f=c[l>>2]|0;if((h|0)>(0-f|0))if((h|0)>=0){if((h|0)<1){a[(c[k>>2]|0)+h>>0]=0;h=1;continue}if((f|0)<=(h|0))if((e|0)>(h|0))d=2;else d=(d|0)>(h|0)?3:4;else d=1}else d=-1;else d=-2}else d=-3}else d=-4;a[(c[k>>2]|0)+h>>0]=d;h=h+1|0;if((h|0)==256)break}i=m;return}function Uh(a){a=a|0;var b=0,d=0;c[a>>2]=35688;b=c[a+4584>>2]|0;if(b){d=a+4588|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}c[a>>2]=36736;b=c[a+92>>2]|0;if(b){d=a+96|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}a=a+88|0;b=c[a>>2]|0;c[a>>2]=0;if(!b)return;Bb[c[(c[b>>2]|0)+4>>2]&255](b);return}function Vh(a){a=a|0;var b=0,d=0;c[a>>2]=35688;b=c[a+4584>>2]|0;if(b){d=a+4588|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}c[a>>2]=36736;b=c[a+92>>2]|0;if(b){d=a+96|0;if((c[d>>2]|0)!=(b|0))c[d>>2]=b;cj(b)}d=a+88|0;b=c[d>>2]|0;c[d>>2]=0;if(!b){cj(a);return}Bb[c[(c[b>>2]|0)+4>>2]&255](b);cj(a);return}function Wh(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;w=i;i=i+352|0;x=w+328|0;y=w+192|0;e=w+343|0;f=w+342|0;g=w+341|0;h=w+340|0;r=w+176|0;k=w+168|0;l=w+160|0;m=w+152|0;v=w;t=w+136|0;if((c[b+28>>2]|0)!=0?(c[b+20>>2]|0)!=1:0){s=b+4|0;u=b+32|0;j=c[u>>2]|0;if(!j){b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[e>>0]|0;Aa(44,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}b=c[b+12>>2]|0;if((b|0)==8)switch(j|0){case 1:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[f>>0]|0;Aa(45,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 2:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[g>>0]|0;Aa(46,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 3:{b=bj(48)|0;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];a[x>>0]=a[h>>0]|0;Aa(47,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}default:{j=y+56|0;g=y+4|0;c[y>>2]=36160;c[j>>2]=36180;o=0;ia(62,y+56|0,g|0);w=o;o=0;if(w&1){z=Na()|0;fn(j);Ya(z|0)}c[y+128>>2]=0;c[y+132>>2]=-1;c[y>>2]=36200;c[y+56>>2]=36220;o=0;ha(180,g|0);w=o;o=0;do if(w&1)b=Na()|0;else{c[g>>2]=36236;h=y+36|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[y+52>>2]=16;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;o=0;ia(63,g|0,x|0);w=o;o=0;if(w&1){b=Na()|0;Im(x);Im(h);nn(g);break}Im(x);o=0;b=ma(28,y|0,49007,21)|0;x=o;o=0;do if((!(x&1)?(o=0,p=ra(36,b|0,c[u>>2]|0)|0,x=o,o=0,!(x&1)):0)?(o=0,ma(28,p|0,50997,18)|0,x=o,o=0,!(x&1)):0){f=Ma(16)|0;o=0;ia(64,r|0,g|0);x=o;o=0;if(!(x&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,f|0,9,35648,r|0);x=o;o=0;if(x&1)e=1;else{o=0;wa(6,f|0,824,96);o=0;e=0}b=Na()|0;Im(r);if(!e)break}else b=Na()|0;La(f|0)}else z=34;while(0);if((z|0)==34)b=Na()|0;c[y>>2]=36200;c[j>>2]=36220;c[g>>2]=36236;Im(h);nn(g);fn(j);z=b;Ya(z|0)}while(0);z=b;fn(j);Ya(z|0)}}if((b|0)<=8){b=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,b|0,8,35648);z=o;o=0;if(!(z&1))lb(b|0,824,96);z=Na()|0;La(b|0);Ya(z|0)}e=16-b|0;switch(j|0){case 1:{b=bj(60)|0;c[k>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[k>>2];c[x+4>>2]=c[k+4>>2];Aa(41,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 2:{b=bj(60)|0;c[l>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[l>>2];c[x+4>>2]=c[l+4>>2];Aa(42,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}case 3:{b=bj(60)|0;c[m>>2]=e;o=0;c[y>>2]=c[d>>2];c[y+4>>2]=c[d+4>>2];c[y+8>>2]=c[d+8>>2];c[x>>2]=c[m>>2];c[x+4>>2]=c[m+4>>2];Aa(43,b|0,y|0,s|0,x|0);z=o;o=0;if(!(z&1)){z=b;i=w;return z|0}z=Na()|0;cj(b);Ya(z|0)}default:{j=v+56|0;g=v+4|0;c[v>>2]=36160;c[j>>2]=36180;o=0;ia(62,v+56|0,g|0);y=o;o=0;if(y&1){z=Na()|0;fn(j);Ya(z|0)}c[v+128>>2]=0;c[v+132>>2]=-1;c[v>>2]=36200;c[v+56>>2]=36220;o=0;ha(180,g|0);y=o;o=0;do if(y&1)b=Na()|0;else{c[g>>2]=36236;h=v+36|0;c[h>>2]=0;c[h+4>>2]=0;c[h+8>>2]=0;c[h+12>>2]=0;c[v+52>>2]=16;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;o=0;ia(63,g|0,x|0);y=o;o=0;if(y&1){b=Na()|0;Im(x);Im(h);nn(g);break}Im(x);o=0;b=ma(28,v|0,49007,21)|0;y=o;o=0;do if((!(y&1)?(o=0,q=ra(36,b|0,c[u>>2]|0)|0,y=o,o=0,!(y&1)):0)?(o=0,ma(28,q|0,50997,18)|0,y=o,o=0,!(y&1)):0){f=Ma(16)|0;o=0;ia(64,t|0,g|0);y=o;o=0;if(!(y&1)){if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;Aa(36,f|0,9,35648,t|0);y=o;o=0;if(y&1)e=1;else{o=0;wa(6,f|0,824,96);o=0;e=0}b=Na()|0;Im(t);if(!e)break}else b=Na()|0;La(f|0)}else z=64;while(0);if((z|0)==64)b=Na()|0;c[v>>2]=36200;c[j>>2]=36220;c[g>>2]=36236;Im(h);nn(g);fn(j);z=b;Ya(z|0)}while(0);z=b;fn(j);Ya(z|0)}}}e=c[d+4>>2]|0;f=bj(16)|0;b=c[b+16>>2]|0;if(!e){z=c[d>>2]|0;c[f>>2]=36132;c[f+4>>2]=z;c[f+8>>2]=3;c[f+12>>2]=b;z=f;i=w;return z|0}else{c[f>>2]=36108;c[f+4>>2]=e;c[f+8>>2]=3;c[f+12>>2]=b;z=f;i=w;return z|0}return 0}function Xh(d,e){d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;h=i;i=i+32|0;l=h;Ei(l,255,0);k=c[e+4>>2]|0;j=c[e+8>>2]|0;j=(j|0)==0?c[l+8>>2]|0:j;g=c[e+12>>2]|0;g=(g|0)==0?c[l+12>>2]|0:g;e=c[e+16>>2]|0;f=c[l+16>>2]|0;c[d+152>>2]=(k|0)==0?c[l+4>>2]|0:k;c[d+156>>2]=j;c[d+160>>2]=g;di(d);g=0;do{c[d+164+(g*12|0)>>2]=4;c[d+164+(g*12|0)+4>>2]=0;b[d+164+(g*12|0)+8>>1]=0;b[d+164+(g*12|0)+10>>1]=1;g=g+1|0}while((g|0)!=365);l=((e|0)==0?f:e)&255;c[d+4544>>2]=4;c[d+4548>>2]=0;a[d+4552>>0]=l;a[d+4553>>0]=1;a[d+4554>>0]=0;c[d+4556>>2]=4;c[d+4560>>2]=1;a[d+4564>>0]=l;a[d+4565>>0]=1;a[d+4566>>0]=0;c[d+4568>>2]=0;i=h;return}function Yh(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0;i=b+88|0;h=c[d>>2]|0;c[d>>2]=0;d=c[i>>2]|0;c[i>>2]=h;if(d)Bb[c[(c[d>>2]|0)+4>>2]&255](d);i=f+4|0;h=c[i>>2]|0;a[b+4596>>0]=g&1;d=b+132|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];Wd(b,f);Zh(b);d=c[b+116>>2]|0;b=c[b+112>>2]|0;while(1){g=d+-1|0;e=(a[g>>0]|0)==-1?7:8;if((b|0)<(e|0))break;else{d=g;b=b-e|0}}d=d-h|0;g=c[i>>2]|0;if(!g)return;c[i>>2]=g+d;f=f+8|0;c[f>>2]=(c[f>>2]|0)-d;return}function Zh(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;A=i;i=i+32|0;C=A+12|0;z=A;w=b+148|0;x=(c[w>>2]|0)+4|0;if((c[b+28>>2]|0)==1)y=c[b+20>>2]|0;else y=1;d=$(y<<1,x)|0;c[C>>2]=0;D=C+4|0;c[D>>2]=0;c[C+8>>2]=0;a:do if(d){if(!(d>>>0>1431655765?(o=0,ha(178,C|0),B=o,o=0,B&1):0))h=6;if((h|0)==6?(o=0,e=ka(67,d*3|0)|0,B=o,o=0,!(B&1)):0){c[D>>2]=e;c[C>>2]=e;c[C+8>>2]=e+(d*3|0);while(1){a[e>>0]=0;a[e+1>>0]=0;a[e+2>>0]=0;e=(c[D>>2]|0)+3|0;c[D>>2]=e;d=d+-1|0;if(!d)break a}}f=Na()|0;d=c[C>>2]|0;if(!d)Ya(f|0);e=c[D>>2]|0;if((e|0)!=(d|0))c[D>>2]=e+(~(((e+-3-d|0)>>>0)/3|0)*3|0);cj(d);Ya(f|0)}while(0);c[z>>2]=0;B=z+4|0;c[B>>2]=0;c[z+8>>2]=0;do if(!y)h=19;else{if(!(y>>>0>1073741823?(o=0,ha(178,z|0),v=o,o=0,v&1):0))h=17;if((h|0)==17?(f=y<<2,o=0,g=ka(67,f|0)|0,v=o,o=0,!(v&1)):0){c[z>>2]=g;h=g+(y<<2)|0;c[z+8>>2]=h;iw(g|0,0,f|0)|0;c[B>>2]=h;h=19;break}f=Na()|0;d=c[z>>2]|0;e=d;if(d){g=c[B>>2]|0;if((g|0)!=(d|0))c[B>>2]=g+(~((g+-4-e|0)>>>2)<<2);cj(d)}}while(0);if((h|0)==19){h=b+8|0;b:do if((c[h>>2]|0)>0){j=b+4572|0;k=$(y,x)|0;l=k+1|0;m=b+4576|0;n=(y|0)>0;p=b+136|0;q=b+144|0;r=b+140|0;s=b+132|0;t=b+88|0;u=b+4568|0;v=0;c:while(1){f=c[C>>2]|0;e=f+3|0;c[j>>2]=e;f=f+(l*3|0)|0;c[m>>2]=f;if(!(v&1))d=f;else{c[j>>2]=f;c[m>>2]=e;d=e;e=f}if(n){g=c[z>>2]|0;f=0;do{c[u>>2]=c[g+(f<<2)>>2];d=c[w>>2]|0;g=e+(d*3|0)|0;e=e+((d+-1|0)*3|0)|0;a[g>>0]=a[e>>0]|0;a[g+1>>0]=a[e+1>>0]|0;a[g+2>>0]=a[e+2>>0]|0;e=c[j>>2]|0;g=(c[m>>2]|0)+-3|0;a[g>>0]=a[e>>0]|0;a[g+1>>0]=a[e+1>>0]|0;a[g+2>>0]=a[e+2>>0]|0;o=0;ia(82,b|0,0);g=o;o=0;if(g&1){h=30;break c}g=c[z>>2]|0;c[g+(f<<2)>>2]=c[u>>2];e=(c[j>>2]|0)+(x*3|0)|0;c[j>>2]=e;d=(c[m>>2]|0)+(x*3|0)|0;c[m>>2]=d;f=f+1|0}while((f|0)<(y|0))}g=c[p>>2]|0;if(((g|0)<=(v|0)?(v|0)<((c[q>>2]|0)+g|0):0)?(g=c[t>>2]|0,o=0,Aa(c[(c[g>>2]|0)+8>>2]|0,g|0,d+(((c[s>>2]|0)-k|0)*3|0)|0,c[r>>2]|0,x|0),g=o,o=0,g&1):0){h=31;break}v=v+1|0;if((v|0)>=(c[h>>2]|0)){h=43;break b}}if((h|0)==30){f=Na()|0;break}else if((h|0)==31){f=Na()|0;break}}else h=43;while(0);do if((h|0)==43){o=0;ha(183,b|0);b=o;o=0;if(b&1){f=Na()|0;break}d=c[z>>2]|0;e=d;if(d){f=c[B>>2]|0;if((f|0)!=(d|0))c[B>>2]=f+(~((f+-4-e|0)>>>2)<<2);cj(d)}d=c[C>>2]|0;if(!d){i=A;return}e=c[D>>2]|0;if((e|0)!=(d|0))c[D>>2]=e+(~(((e+-3-d|0)>>>0)/3|0)*3|0);cj(d);i=A;return}while(0);d=c[z>>2]|0;e=d;if(d){g=c[B>>2]|0;if((g|0)!=(d|0))c[B>>2]=g+(~((g+-4-e|0)>>>2)<<2);cj(d)}}d=c[C>>2]|0;if(!d)Ya(f|0);e=c[D>>2]|0;if((e|0)!=(d|0))c[D>>2]=e+(~(((e+-3-d|0)>>>0)/3|0)*3|0);cj(d);Ya(f|0)}function _h(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;A=b+148|0;if((c[A>>2]|0)<=0)return;B=b+4576|0;C=b+4572|0;D=b+4580|0;z=0;while(1){w=z+-1|0;i=c[B>>2]|0;j=c[C>>2]|0;e=z+1|0;h=d[j+(z*3|0)>>0]|0;y=c[D>>2]|0;k=d[j+(w*3|0)>>0]|0;l=h-k|0;m=d[i+(w*3|0)>>0]|0;n=k-m|0;o=((((a[y+((d[j+(e*3|0)>>0]|0)-h)>>0]|0)*9|0)+(a[y+l>>0]|0)|0)*9|0)+(a[y+n>>0]|0)|0;g=d[j+(z*3|0)+1>>0]|0;p=d[j+(w*3|0)+1>>0]|0;q=g-p|0;r=d[i+(w*3|0)+1>>0]|0;s=p-r|0;t=((((a[y+((d[j+(e*3|0)+1>>0]|0)-g)>>0]|0)*9|0)+(a[y+q>>0]|0)|0)*9|0)+(a[y+s>>0]|0)|0;f=d[j+(z*3|0)+2>>0]|0;u=d[j+(w*3|0)+2>>0]|0;v=f-u|0;w=d[i+(w*3|0)+2>>0]|0;x=u-w|0;y=((((a[y+((d[j+(e*3|0)+2>>0]|0)-f)>>0]|0)*9|0)+(a[y+v>>0]|0)|0)*9|0)+(a[y+x>>0]|0)|0;if(!(t|o|y))e=($h(b,z,0)|0)+z|0;else{j=d[i+(z*3|0)>>0]|0;i=h-m>>31;if((i^n|0)>=0)if((i^l|0)<0)h=m;else h=m-k+h|0;j=ai(b,o,j,h,0)|0;i=d[(c[B>>2]|0)+(z*3|0)+1>>0]|0;h=g-r>>31;if((h^s|0)>=0)if((h^q|0)<0)g=r;else g=r-p+g|0;h=ai(b,t,i,g,0)|0;i=d[(c[B>>2]|0)+(z*3|0)+2>>0]|0;g=f-w>>31;if((g^x|0)>=0)if((g^v|0)<0)f=w;else f=w-u+f|0;y=ai(b,y,i,f,0)|0;z=(c[B>>2]|0)+(z*3|0)|0;a[z>>0]=j;a[z+1>>0]=h;a[z+2>>0]=y}if((e|0)<(c[A>>2]|0))z=e;else break}return}function $h(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;l=i;i=i+16|0;n=l+3|0;o=l;h=b+4576|0;e=c[h>>2]|0;f=e+((d+-1|0)*3|0)|0;j=a[f>>0]|0;k=a[f+1>>0]|0;f=a[f+2>>0]|0;a[o>>0]=j;a[o+1>>0]=k;a[o+2>>0]=f;m=b+148|0;g=(c[m>>2]|0)-d|0;a[n>>0]=a[o>>0]|0;a[n+1>>0]=a[o+1>>0]|0;a[n+2>>0]=a[o+2>>0]|0;g=bi(b,n,e+(d*3|0)|0,g)|0;e=g+d|0;if((e|0)==(c[m>>2]|0)){o=g;i=l;return o|0}n=(c[b+4572>>2]|0)+(e*3|0)|0;d=a[n>>0]|0;m=a[n+1>>0]|0;n=a[n+2>>0]|0;o=c[h>>2]|0;p=b+4544|0;h=ci(b,p)|0;q=ci(b,p)|0;d=d&255;m=m&255;m=($(m-(k&255)>>31|1,q)|0)+m&255;n=n&255;n=($(n-(f&255)>>31|1,ci(b,p)|0)|0)+n&255;o=o+(e*3|0)|0;a[o>>0]=($(d-(j&255)>>31|1,h)|0)+d;a[o+1>>0]=m;a[o+2>>0]=n;o=b+4568|0;n=c[o>>2]|0;c[o>>2]=(n|0)<1?0:n+-1|0;o=g+1|0;i=l;return o|0}function ai(d,e,f,g,h){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,p=0,q=0,r=0,s=0;s=e>>31;m=(s^e)-s|0;r=d+164+(m*12|0)+10|0;f=b[r>>1]|0;q=d+164+(m*12|0)|0;h=c[q>>2]|0;if((f|0)<(h|0))if((f<<1|0)<(h|0))if((f<<2|0)<(h|0))if((f<<3|0)<(h|0))if((f<<4|0)<(h|0)){i=5;while(1)if((f<<i|0)<(h|0))i=i+1|0;else break}else i=4;else i=3;else i=2;else i=1;else i=0;p=d+164+(m*12|0)+8|0;f=(b[p>>1]^s)-s+g|0;if((f&255|0)!=(f|0))f=f>>31&255^255;h=d+112|0;if((c[h>>2]|0)<8)ge(d);g=d+108|0;j=c[g>>2]|0;k=j>>>24;l=c[2832+(i<<11)+(k<<3)+4>>2]|0;if(!l){h=Jg(d)|0;if((h|0)<23){if(i)h=(Kg(d,i)|0)+(h<<i)|0}else h=(Kg(d,8)|0)+1|0;h=h<<31>>31^h>>1;if((((h|0)>-1?h:0-h|0)|0)>65535){f=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,f|0,5,35648);e=o;o=0;if(e&1){e=Na()|0;La(f|0);Ya(e|0)}else lb(f|0,824,96)}}else{c[h>>2]=(c[h>>2]|0)-l;c[g>>2]=j<<l;h=c[2832+(i<<11)+(k<<3)>>2]|0}l=d+164+(m*12|0)+4|0;g=c[l>>2]|0;if(!i){d=b[r>>1]|0;i=d;h=(g<<1)+-1+(d<<16>>16)>>31^h}else i=b[r>>1]|0;j=i<<16>>16==64;d=j&1;k=g+h>>d;j=j?32:i<<16>>16;c[q>>2]=((h|0)>-1?h:0-h|0)+(c[q>>2]|0)>>d;g=j+1|0;b[r>>1]=g;i=g+k|0;if((i|0)<1){r=b[p>>1]|0;b[p>>1]=(r&65535)-(r<<16>>16>-128&1);r=(i|0)>(~j|0)?i:0-j|0;c[l>>2]=r;s=h^s;e=e>>>31;e=f+e|0;e=e+s|0;e=e&255;return e|0}if((k|0)<=0){r=k;c[l>>2]=r;s=h^s;e=e>>>31;e=f+e|0;e=e+s|0;e=e&255;return e|0}r=k-g|0;q=b[p>>1]|0;b[p>>1]=(q<<16>>16<127&1)+(q&65535);r=(r|0)>0?0:r;c[l>>2]=r;s=h^s;e=e>>>31;e=f+e|0;e=e+s|0;e=e&255;return e|0}function bi(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,p=0,q=0;j=b+112|0;k=b+108|0;l=b+4568|0;g=c[j>>2]|0;h=0;while(1){if((g|0)<1){ge(b);g=c[j>>2]|0}i=c[k>>2]|0;g=g+-1|0;c[j>>2]=g;c[k>>2]=i<<1;if((i|0)>=0){m=8;break}i=c[l>>2]|0;p=1<<c[36476+(i<<2)>>2];q=f-h|0;q=(p|0)<(q|0)?p:q;h=q+h|0;if((q|0)==(p|0))c[l>>2]=(i|0)>30?31:i+1|0;if((h|0)==(f|0)){g=f;break}}if((m|0)==8)if((h|0)!=(f|0)){g=c[l>>2]|0;if((g+-4|0)>>>0<28)g=Kg(b,c[36476+(g<<2)>>2]|0)|0;else g=0;g=g+h|0;if((g|0)>(f|0)){g=Ma(16)|0;if((a[8]|0)==0?(Ha(8)|0)!=0:0){kb(72,35648,n|0)|0;Pa(8)}o=0;wa(7,g|0,5,35648);q=o;o=0;if(q&1){q=Na()|0;La(g|0);Ya(q|0)}else lb(g|0,824,96)}}else g=f;if((g|0)<=0)return g|0;h=0;do{q=e+(h*3|0)|0;a[q>>0]=a[d>>0]|0;a[q+1>>0]=a[d+1>>0]|0;a[q+2>>0]=a[d+2>>0]|0;h=h+1|0}while((h|0)!=(g|0));return g|0}function ci(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0;k=e+9|0;f=d[k>>0]|0;i=e+4|0;h=($(f>>>1,c[i>>2]|0)|0)+(c[e>>2]|0)|0;if((f|0)<(h|0)){g=0;do{f=f<<1;g=g+1|0}while((f|0)<(h|0))}else g=0;h=c[36476+(c[b+4568>>2]<<2)>>2]|0;f=Jg(b)|0;do if((f|0)<(22-h|0))if(!g){b=c[i>>2]|0;h=b+f|0;g=h&1;h=(g+h|0)/2|0;j=8;break}else{f=(Kg(b,g)|0)+(f<<g)|0;b=c[i>>2]|0;h=f+b|0;l=h&1;g=l;i=1;h=(l+h|0)/2|0;break}else{f=(Kg(b,8)|0)+1|0;b=c[i>>2]|0;h=f+b|0;i=h&1;h=(i+h|0)/2|0;if(!g){g=i;j=8}else{g=i;i=1}}while(0);if((j|0)==8)i=d[e+10>>0]<<1>>>0>=(d[k>>0]|0)>>>0;h=(g|0)!=0^i?h:0-h|0;if((h|0)<0){l=e+10|0;a[l>>0]=(d[l>>0]|0)+1}f=(f+1-b>>1)+(c[e>>2]|0)|0;c[e>>2]=f;g=a[k>>0]|0;if(g<<24>>24!=(a[e+8>>0]|0)){l=g;l=l&255;l=l+1|0;l=l&255;a[k>>0]=l;return h|0}c[e>>2]=f>>1;l=(g&255)>>>1;a[k>>0]=l;e=e+10|0;a[e>>0]=(d[e>>0]|0)>>>1;l=l&255;l=l+1|0;l=l&255;a[k>>0]=l;return h|0}
function Lp(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0;n=i;i=i+128|0;h=n;q=n+116|0;r=n+104|0;k=n+20|0;m=n+16|0;l=n+12|0;p=n+8|0;j=n+4|0;a[q>>0]=a[58887]|0;a[q+1>>0]=a[58888]|0;a[q+2>>0]=a[58889]|0;a[q+3>>0]=a[58890]|0;a[q+4>>0]=a[58891]|0;a[q+5>>0]=a[58892]|0;up(q+1|0,58893,0,c[e+4>>2]|0);b=Xo()|0;c[h>>2]=g;g=r+(Su(r,12,b,q,h)|0)|0;q=vp(r,g,e)|0;b=jn(e)|0;c[p>>2]=b;o=0;pa(3,r|0,q|0,g|0,k|0,m|0,l|0,p|0);g=o;o=0;if(g&1){r=Na()|0;pm(b)|0;Ya(r|0)}else{pm(b)|0;c[j>>2]=c[d>>2];q=c[m>>2]|0;r=c[l>>2]|0;c[h>>2]=c[j>>2];r=Uu(h,k,q,r,e,f)|0;i=n;return r|0}return 0}function Mp(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0;n=i;i=i+240|0;h=n+8|0;a=n;q=n+204|0;k=n+32|0;m=n+28|0;l=n+24|0;p=n+20|0;j=n+16|0;r=a;c[r>>2]=37;c[r+4>>2]=0;up(a+1|0,58895,0,c[d+4>>2]|0);r=Xo()|0;s=h;c[s>>2]=f;c[s+4>>2]=g;g=q+(Su(q,23,r,a,h)|0)|0;f=vp(q,g,d)|0;a=jn(d)|0;c[p>>2]=a;o=0;pa(3,q|0,f|0,g|0,k|0,m|0,l|0,p|0);g=o;o=0;if(g&1){s=Na()|0;pm(a)|0;Ya(s|0)}else{pm(a)|0;c[j>>2]=c[b>>2];r=c[m>>2]|0;s=c[l>>2]|0;c[h>>2]=c[j>>2];s=Uu(h,k,r,s,d,e)|0;i=n;return s|0}return 0}function Np(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;var g=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;z=i;i=i+352|0;u=z+312|0;q=z+48|0;p=z+32|0;l=z+24|0;g=z+8|0;n=z;s=z+316|0;t=z+80|0;k=z+84|0;y=z+76|0;x=z+72|0;v=z+68|0;w=z+64|0;m=n;c[m>>2]=37;c[m+4>>2]=0;m=Bp(n+1|0,58898,c[d+4>>2]|0)|0;c[t>>2]=s;a=Xo()|0;if(m){c[g>>2]=c[d+8>>2];h[g+8>>3]=f;g=Su(s,30,a,n,g)|0}else{h[l>>3]=f;g=Su(s,30,a,n,l)|0}a:do if((g|0)>29){o=0;a=ua(3)|0;g=o;o=0;g=g&1;if(m){if(!g?(o=0,c[p>>2]=c[d+8>>2],h[p+8>>3]=f,j=va(17,t|0,a|0,n|0,p|0)|0,r=o,o=0,!(r&1)):0)A=12}else if(!g?(o=0,c[q>>2]=c[d+8>>2],h[q+8>>3]=f,r=va(17,t|0,a|0,n|0,q|0)|0,q=o,o=0,!(q&1)):0){j=r;A=12}do if((A|0)==12){a=c[t>>2]|0;if(!a){o=0;xa(6);r=o;o=0;if(r&1)break;g=c[t>>2]|0}else g=a;a=g;n=g;A=16;break a}while(0);a=Na()|0}else{a=c[t>>2]|0;n=0;j=g;A=16}while(0);if((A|0)==16){l=a+j|0;m=vp(a,l,d)|0;do if((a|0)==(s|0)){a=s;g=0;A=22}else{j=Fl(j<<3)|0;if(!j){o=0;xa(6);A=o;o=0;if(A&1){g=0;A=20;break}a=c[t>>2]|0}g=j;k=j;A=22}while(0);do if((A|0)==22){o=0;j=ka(68,d|0)|0;t=o;o=0;if(!(t&1)){c[v>>2]=j;o=0;pa(4,a|0,m|0,l|0,k|0,y|0,x|0,v|0);v=o;o=0;if(v&1){a=Na()|0;pm(j)|0;break}pm(j)|0;c[w>>2]=c[b>>2];A=c[y>>2]|0;a=c[x>>2]|0;o=0;c[u>>2]=c[w>>2];a=ja(40,u|0,k|0,A|0,a|0,d|0,e|0)|0;A=o;o=0;if(!(A&1)){c[b>>2]=a;if(g)Gl(g);if(n)Gl(n);i=z;return a|0}else A=20}else A=20}while(0);if((A|0)==20)a=Na()|0;if(g)Gl(g);if(n)Gl(n)}Ya(a|0);return 0}function Op(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;y=i;i=i+16|0;z=y;x=Is(j,44212)|0;v=Is(j,44368)|0;Cb[c[(c[v>>2]|0)+20>>2]&127](z,v);c[h>>2]=f;j=a[b>>0]|0;switch(j<<24>>24){case 43:case 45:{o=0;j=ra(c[(c[x>>2]|0)+44>>2]|0,x|0,j|0)|0;w=o;o=0;if(w&1)u=8;else{m=c[h>>2]|0;c[h>>2]=m+4;c[m>>2]=j;m=b+1|0;u=10}break}default:{m=b;u=10}}a:do if((u|0)==10){w=e;b:do if((w-m|0)>1?(a[m>>0]|0)==48:0){k=m+1|0;switch(a[k>>0]|0){case 88:case 120:break;default:{u=11;break b}}o=0;j=ra(c[(c[x>>2]|0)+44>>2]|0,x|0,48)|0;t=o;o=0;if(t&1){u=8;break a}t=c[h>>2]|0;c[h>>2]=t+4;c[t>>2]=j;m=m+2|0;o=0;j=ra(c[(c[x>>2]|0)+44>>2]|0,x|0,a[k>>0]|0)|0;t=o;o=0;if(t&1){u=8;break a}t=c[h>>2]|0;c[h>>2]=t+4;c[t>>2]=j;if(m>>>0<e>>>0){j=m;while(1){k=a[j>>0]|0;o=0;l=ua(3)|0;t=o;o=0;if(t&1)break;o=0;k=ra(39,k<<24>>24|0,l|0)|0;t=o;o=0;if(t&1)break;if(!k){t=m;break b}j=j+1|0;if(j>>>0>=e>>>0){t=m;break b}}j=Na()|0;break a}else{t=m;j=m}}else u=11;while(0);c:do if((u|0)==11)if(m>>>0<e>>>0){j=m;while(1){k=a[j>>0]|0;o=0;l=ua(3)|0;t=o;o=0;if(t&1)break;o=0;k=ra(40,k<<24>>24|0,l|0)|0;t=o;o=0;if(t&1)break;if(!k){t=m;break c}j=j+1|0;if(j>>>0>=e>>>0){t=m;break c}}j=Na()|0;break a}else{t=m;j=m}while(0);r=a[z>>0]|0;s=z+4|0;if(((r&1)==0?(r&255)>>>1:c[s>>2]|0)|0){if((t|0)!=(j|0)?(n=j+-1|0,t>>>0<n>>>0):0){l=t;k=n;do{r=a[l>>0]|0;a[l>>0]=a[k>>0]|0;a[k>>0]=r;l=l+1|0;k=k+-1|0}while(l>>>0<k>>>0)}o=0;n=ka(c[(c[v>>2]|0)+16>>2]|0,v|0)|0;r=o;o=0;if(r&1){u=8;break}p=z+8|0;q=z+1|0;d:do if(t>>>0<j>>>0){k=0;l=0;r=t;while(1){m=a[((a[z>>0]&1)==0?q:c[p>>2]|0)+l>>0]|0;if(m<<24>>24>0&(k|0)==(m<<24>>24|0)){k=c[h>>2]|0;c[h>>2]=k+4;c[k>>2]=n;k=a[z>>0]|0;m=0;l=(l>>>0<(((k&1)==0?(k&255)>>>1:c[s>>2]|0)+-1|0)>>>0&1)+l|0}else m=k;o=0;k=ra(c[(c[x>>2]|0)+44>>2]|0,x|0,a[r>>0]|0)|0;A=o;o=0;if(A&1)break;A=c[h>>2]|0;c[h>>2]=A+4;c[A>>2]=k;r=r+1|0;if(r>>>0>=j>>>0)break d;else k=m+1|0}j=Na()|0;break a}while(0);k=f+(t-b<<2)|0;m=c[h>>2]|0;if((k|0)!=(m|0)){l=m+-4|0;if(k>>>0<l>>>0){do{A=c[k>>2]|0;c[k>>2]=c[l>>2];c[l>>2]=A;k=k+4|0;l=l+-4|0}while(k>>>0<l>>>0);n=x;k=m}else{n=x;k=m}}else n=x}else{o=0;va(c[(c[x>>2]|0)+48>>2]|0,x|0,t|0,j|0,c[h>>2]|0)|0;A=o;o=0;if(A&1){u=8;break}k=(c[h>>2]|0)+(j-t<<2)|0;c[h>>2]=k;n=x}e:do if(j>>>0<e>>>0){while(1){k=a[j>>0]|0;if(k<<24>>24==46){l=j;break}o=0;l=ra(c[(c[n>>2]|0)+44>>2]|0,x|0,k|0)|0;A=o;o=0;if(A&1){u=4;break}A=c[h>>2]|0;k=A+4|0;c[h>>2]=k;c[A>>2]=l;j=j+1|0;if(j>>>0>=e>>>0)break e}if((u|0)==4){j=Na()|0;break a}o=0;j=ka(c[(c[v>>2]|0)+12>>2]|0,v|0)|0;A=o;o=0;if(A&1){u=8;break a}A=c[h>>2]|0;k=A+4|0;c[h>>2]=k;c[A>>2]=j;j=l+1|0}while(0);o=0;va(c[(c[x>>2]|0)+48>>2]|0,x|0,j|0,e|0,k|0)|0;A=o;o=0;if(A&1)u=8;else{A=(c[h>>2]|0)+(w-j<<2)|0;c[h>>2]=A;c[g>>2]=(d|0)==(e|0)?A:f+(d-b<<2)|0;Im(z);i=y;return}}while(0);if((u|0)==8)j=Na()|0;Im(z);Ya(j|0)}function Pp(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;var g=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;z=i;i=i+352|0;u=z+304|0;q=z+48|0;p=z+32|0;l=z+24|0;g=z+8|0;n=z;s=z+308|0;t=z+72|0;k=z+76|0;y=z+68|0;x=z+64|0;v=z+60|0;w=z+56|0;m=n;c[m>>2]=37;c[m+4>>2]=0;m=Bp(n+1|0,58899,c[d+4>>2]|0)|0;c[t>>2]=s;a=Xo()|0;if(m){c[g>>2]=c[d+8>>2];h[g+8>>3]=f;g=Su(s,30,a,n,g)|0}else{h[l>>3]=f;g=Su(s,30,a,n,l)|0}a:do if((g|0)>29){o=0;a=ua(3)|0;g=o;o=0;g=g&1;if(m){if(!g?(o=0,c[p>>2]=c[d+8>>2],h[p+8>>3]=f,j=va(17,t|0,a|0,n|0,p|0)|0,r=o,o=0,!(r&1)):0)A=12}else if(!g?(o=0,h[q>>3]=f,r=va(17,t|0,a|0,n|0,q|0)|0,q=o,o=0,!(q&1)):0){j=r;A=12}do if((A|0)==12){a=c[t>>2]|0;if(!a){o=0;xa(6);r=o;o=0;if(r&1)break;g=c[t>>2]|0}else g=a;a=g;n=g;A=16;break a}while(0);a=Na()|0}else{a=c[t>>2]|0;n=0;j=g;A=16}while(0);if((A|0)==16){l=a+j|0;m=vp(a,l,d)|0;do if((a|0)==(s|0)){a=s;g=0;A=22}else{j=Fl(j<<3)|0;if(!j){o=0;xa(6);A=o;o=0;if(A&1){g=0;A=20;break}a=c[t>>2]|0}g=j;k=j;A=22}while(0);do if((A|0)==22){o=0;j=ka(68,d|0)|0;t=o;o=0;if(!(t&1)){c[v>>2]=j;o=0;pa(4,a|0,m|0,l|0,k|0,y|0,x|0,v|0);v=o;o=0;if(v&1){a=Na()|0;pm(j)|0;break}pm(j)|0;c[w>>2]=c[b>>2];A=c[y>>2]|0;a=c[x>>2]|0;o=0;c[u>>2]=c[w>>2];a=ja(40,u|0,k|0,A|0,a|0,d|0,e|0)|0;A=o;o=0;if(!(A&1)){c[b>>2]=a;if(g)Gl(g);if(n)Gl(n);i=z;return a|0}else A=20}else A=20}while(0);if((A|0)==20)a=Na()|0;if(g)Gl(g);if(n)Gl(n)}Ya(a|0);return 0}function Qp(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0;q=i;i=i+192|0;l=q;b=q+180|0;n=q+160|0;p=q+12|0;k=q+8|0;m=q+4|0;a[b>>0]=a[58901]|0;a[b+1>>0]=a[58902]|0;a[b+2>>0]=a[58903]|0;a[b+3>>0]=a[58904]|0;a[b+4>>0]=a[58905]|0;a[b+5>>0]=a[58906]|0;h=Xo()|0;c[l>>2]=g;b=Su(n,20,h,b,l)|0;g=n+b|0;h=vp(n,g,e)|0;j=jn(e)|0;c[k>>2]=j;o=0;k=ra(37,k|0,44212)|0;r=o;o=0;if(r&1){r=Na()|0;pm(j)|0;Ya(r|0)}else{pm(j)|0;Pb[c[(c[k>>2]|0)+48>>2]&31](k,n,g,p)|0;r=p+(b<<2)|0;c[m>>2]=c[d>>2];c[l>>2]=c[m>>2];r=Uu(l,p,(h|0)==(g|0)?r:p+(h-n<<2)|0,r,e,f)|0;i=q;return r|0}return 0}function Rp(e,f,g,h,j,k,l,m){e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;C=i;i=i+32|0;w=C+16|0;v=C+12|0;z=C+8|0;x=C+4|0;y=C;n=jn(h)|0;c[z>>2]=n;o=0;z=ra(37,z|0,44220)|0;u=o;o=0;if(u&1){C=Na()|0;pm(n)|0;Ya(C|0)}pm(n)|0;c[j>>2]=0;u=z+8|0;n=c[f>>2]|0;a:do if((l|0)!=(m|0)){b:while(1){p=n;if(n){if((c[n+12>>2]|0)==(c[n+16>>2]|0)?(Eb[c[(c[n>>2]|0)+36>>2]&127](n)|0)==-1:0){c[f>>2]=0;n=0;p=0}}else n=0;s=(n|0)==0;r=c[g>>2]|0;q=r;do if(r){if((c[r+12>>2]|0)==(c[r+16>>2]|0)?(Eb[c[(c[r>>2]|0)+36>>2]&127](r)|0)==-1:0){c[g>>2]=0;q=0;B=12;break}if(!s){B=13;break b}}else B=12;while(0);if((B|0)==12){B=0;if(s){B=13;break}else r=0}c:do if((Gb[c[(c[z>>2]|0)+36>>2]&63](z,a[l>>0]|0,0)|0)<<24>>24==37){r=l+1|0;if((r|0)==(m|0)){B=17;break b}t=Gb[c[(c[z>>2]|0)+36>>2]&63](z,a[r>>0]|0,0)|0;switch(t<<24>>24){case 48:case 69:{s=l+2|0;if((s|0)==(m|0)){B=20;break b}l=r;r=Gb[c[(c[z>>2]|0)+36>>2]&63](z,a[s>>0]|0,0)|0;n=t;break}default:{r=t;n=0}}t=c[(c[e>>2]|0)+36>>2]|0;c[x>>2]=p;c[y>>2]=q;c[v>>2]=c[x>>2];c[w>>2]=c[y>>2];c[f>>2]=Sb[t&15](e,v,w,h,j,k,r,n)|0;l=l+2|0}else{p=a[l>>0]|0;if(p<<24>>24>-1?(A=c[u>>2]|0,(b[A+(p<<24>>24<<1)>>1]&8192)!=0):0){do{l=l+1|0;if((l|0)==(m|0)){l=m;break}p=a[l>>0]|0;if(p<<24>>24<=-1)break}while((b[A+(p<<24>>24<<1)>>1]&8192)!=0);p=r;while(1){if(n){if((c[n+12>>2]|0)==(c[n+16>>2]|0)?(Eb[c[(c[n>>2]|0)+36>>2]&127](n)|0)==-1:0){c[f>>2]=0;n=0}}else n=0;q=(n|0)==0;do if(r){if((c[r+12>>2]|0)!=(c[r+16>>2]|0))if(q){t=p;break}else break c;if((Eb[c[(c[r>>2]|0)+36>>2]&127](r)|0)!=-1)if(q^(p|0)==0){t=p;r=p;break}else break c;else{c[g>>2]=0;p=0;B=39;break}}else B=39;while(0);if((B|0)==39){B=0;if(q)break c;else{t=p;r=0}}q=n+12|0;p=c[q>>2]|0;s=n+16|0;if((p|0)==(c[s>>2]|0))p=Eb[c[(c[n>>2]|0)+36>>2]&127](n)|0;else p=d[p>>0]|0;if((p&255)<<24>>24<=-1)break c;if(!(b[(c[u>>2]|0)+(p<<24>>24<<1)>>1]&8192))break c;p=c[q>>2]|0;if((p|0)==(c[s>>2]|0)){Eb[c[(c[n>>2]|0)+40>>2]&127](n)|0;p=t;continue}else{c[q>>2]=p+1;p=t;continue}}}q=n+12|0;p=c[q>>2]|0;r=n+16|0;if((p|0)==(c[r>>2]|0))p=Eb[c[(c[n>>2]|0)+36>>2]&127](n)|0;else p=d[p>>0]|0;t=Lb[c[(c[z>>2]|0)+12>>2]&63](z,p&255)|0;if(t<<24>>24!=(Lb[c[(c[z>>2]|0)+12>>2]&63](z,a[l>>0]|0)|0)<<24>>24){B=57;break b}p=c[q>>2]|0;if((p|0)==(c[r>>2]|0))Eb[c[(c[n>>2]|0)+40>>2]&127](n)|0;else c[q>>2]=p+1;l=l+1|0}while(0);n=c[f>>2]|0;if(!((l|0)!=(m|0)&(c[j>>2]|0)==0))break a}if((B|0)==13){c[j>>2]=4;break}else if((B|0)==17){c[j>>2]=4;break}else if((B|0)==20){c[j>>2]=4;break}else if((B|0)==57){c[j>>2]=4;n=c[f>>2]|0;break}}while(0);if(n){if((c[n+12>>2]|0)==(c[n+16>>2]|0)?(Eb[c[(c[n>>2]|0)+36>>2]&127](n)|0)==-1:0){c[f>>2]=0;n=0}}else n=0;l=(n|0)==0;p=c[g>>2]|0;do if(p){if((c[p+12>>2]|0)==(c[p+16>>2]|0)?(Eb[c[(c[p>>2]|0)+36>>2]&127](p)|0)==-1:0){c[g>>2]=0;B=67;break}if(!l)B=68}else B=67;while(0);if((B|0)==67?l:0)B=68;if((B|0)==68)c[j>>2]=c[j>>2]|2;i=C;return n|0}function Sp(a){a=a|0;return}function Tp(a){a=a|0;cj(a);return}function Up(a){a=a|0;return 2}function Vp(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=Rp(a,k,j,e,f,g,58907,58915)|0;i=h;return a|0}function Wp(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0;j=i;i=i+16|0;k=j+12|0;l=j+8|0;n=j+4|0;m=j;o=b+8|0;o=Eb[c[(c[o>>2]|0)+20>>2]&127](o)|0;c[n>>2]=c[d>>2];c[m>>2]=c[e>>2];e=a[o>>0]|0;p=(e&1)==0;d=p?o+1|0:c[o+8>>2]|0;e=d+(p?(e&255)>>>1:c[o+4>>2]|0)|0;c[l>>2]=c[n>>2];c[k>>2]=c[m>>2];b=Rp(b,l,k,f,g,h,d,e)|0;i=j;return b|0}function Xp(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;l=i;i=i+16|0;j=l+8|0;h=l+4|0;k=l;e=jn(e)|0;c[h>>2]=e;o=0;h=ra(37,h|0,44220)|0;m=o;o=0;if(m&1){m=Na()|0;pm(e)|0;Ya(m|0)}else{pm(e)|0;c[k>>2]=c[d>>2];c[j>>2]=c[k>>2];Yp(a,g+24|0,b,j,f,h);i=l;return c[b>>2]|0}return 0}function Yp(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0;h=i;i=i+16|0;j=h+4|0;k=h;a=a+8|0;a=Eb[c[c[a>>2]>>2]&127](a)|0;c[k>>2]=c[e>>2];c[j>>2]=c[k>>2];d=(xu(d,j,a,a+168|0,g,f,0)|0)-a|0;if((d|0)<168)c[b>>2]=((d|0)/12|0|0)%7|0;i=h;return}function Zp(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;l=i;i=i+16|0;j=l+8|0;h=l+4|0;k=l;e=jn(e)|0;c[h>>2]=e;o=0;h=ra(37,h|0,44220)|0;m=o;o=0;if(m&1){m=Na()|0;pm(e)|0;Ya(m|0)}else{pm(e)|0;c[k>>2]=c[d>>2];c[j>>2]=c[k>>2];_p(a,g+16|0,b,j,f,h);i=l;return c[b>>2]|0}return 0}function _p(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0;h=i;i=i+16|0;j=h+4|0;k=h;a=a+8|0;a=Eb[c[(c[a>>2]|0)+4>>2]&127](a)|0;c[k>>2]=c[e>>2];c[j>>2]=c[k>>2];d=(xu(d,j,a,a+288|0,g,f,0)|0)-a|0;if((d|0)<288)c[b>>2]=((d|0)/12|0|0)%12|0;i=h;return}function $p(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;l=i;i=i+16|0;j=l+8|0;h=l+4|0;k=l;e=jn(e)|0;c[h>>2]=e;o=0;h=ra(37,h|0,44220)|0;m=o;o=0;if(m&1){m=Na()|0;pm(e)|0;Ya(m|0)}else{pm(e)|0;c[k>>2]=c[d>>2];c[j>>2]=c[k>>2];aq(a,g+20|0,b,j,f,h);i=l;return c[b>>2]|0}return 0}function aq(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=Vu(d,a,f,g,4)|0;if(!(c[f>>2]&4)){if((a|0)<69)a=a+2e3|0;else a=(a+-69|0)>>>0<31?a+1900|0:a;c[b>>2]=a+-1900}i=h;return}function bq(b,d,e,f,g,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0;U=i;i=i+144|0;l=U+132|0;k=U+116|0;N=U+128|0;x=U+124|0;I=U+120|0;O=U+112|0;P=U+108|0;Q=U+104|0;R=U+100|0;S=U+96|0;T=U+92|0;m=U+88|0;n=U+84|0;p=U+80|0;q=U+76|0;r=U+72|0;s=U+68|0;t=U+64|0;u=U+60|0;v=U+56|0;w=U+52|0;y=U+48|0;z=U+44|0;A=U+40|0;B=U+36|0;C=U+32|0;D=U+28|0;E=U+24|0;F=U+20|0;G=U+16|0;H=U+12|0;J=U+8|0;K=U+4|0;L=U;c[g>>2]=0;M=jn(f)|0;c[N>>2]=M;o=0;N=ra(37,N|0,44220)|0;W=o;o=0;if(W&1){W=Na()|0;pm(M)|0;Ya(W|0)}pm(M)|0;do switch(j<<24>>24|0){case 65:case 97:{c[x>>2]=c[e>>2];c[l>>2]=c[x>>2];Yp(b,h+24|0,d,l,g,N);V=28;break}case 104:case 66:case 98:{c[I>>2]=c[e>>2];c[l>>2]=c[I>>2];_p(b,h+16|0,d,l,g,N);V=28;break}case 99:{V=b+8|0;V=Eb[c[(c[V>>2]|0)+12>>2]&127](V)|0;c[O>>2]=c[d>>2];c[P>>2]=c[e>>2];j=a[V>>0]|0;e=(j&1)==0;W=e?V+1|0:c[V+8>>2]|0;V=W+(e?(j&255)>>>1:c[V+4>>2]|0)|0;c[k>>2]=c[O>>2];c[l>>2]=c[P>>2];c[d>>2]=Rp(b,k,l,f,g,h,W,V)|0;V=28;break}case 101:case 100:{c[Q>>2]=c[e>>2];c[l>>2]=c[Q>>2];cq(b,h+12|0,d,l,g,N);V=28;break}case 68:{c[R>>2]=c[d>>2];c[S>>2]=c[e>>2];c[k>>2]=c[R>>2];c[l>>2]=c[S>>2];c[d>>2]=Rp(b,k,l,f,g,h,58915,58923)|0;V=28;break}case 70:{c[T>>2]=c[d>>2];c[m>>2]=c[e>>2];c[k>>2]=c[T>>2];c[l>>2]=c[m>>2];c[d>>2]=Rp(b,k,l,f,g,h,58923,58931)|0;V=28;break}case 72:{c[n>>2]=c[e>>2];c[l>>2]=c[n>>2];dq(b,h+8|0,d,l,g,N);V=28;break}case 73:{c[p>>2]=c[e>>2];c[l>>2]=c[p>>2];eq(b,h+8|0,d,l,g,N);V=28;break}case 106:{c[q>>2]=c[e>>2];c[l>>2]=c[q>>2];fq(b,h+28|0,d,l,g,N);V=28;break}case 109:{c[r>>2]=c[e>>2];c[l>>2]=c[r>>2];gq(b,h+16|0,d,l,g,N);V=28;break}case 77:{c[s>>2]=c[e>>2];c[l>>2]=c[s>>2];hq(b,h+4|0,d,l,g,N);V=28;break}case 116:case 110:{c[t>>2]=c[e>>2];c[l>>2]=c[t>>2];iq(b,d,l,g,N);V=28;break}case 112:{c[u>>2]=c[e>>2];c[l>>2]=c[u>>2];jq(b,h+8|0,d,l,g,N);V=28;break}case 114:{c[v>>2]=c[d>>2];c[w>>2]=c[e>>2];c[k>>2]=c[v>>2];c[l>>2]=c[w>>2];c[d>>2]=Rp(b,k,l,f,g,h,58931,58942)|0;V=28;break}case 82:{c[y>>2]=c[d>>2];c[z>>2]=c[e>>2];c[k>>2]=c[y>>2];c[l>>2]=c[z>>2];c[d>>2]=Rp(b,k,l,f,g,h,58942,58947)|0;V=28;break}case 83:{c[A>>2]=c[e>>2];c[l>>2]=c[A>>2];kq(b,h,d,l,g,N);V=28;break}case 84:{c[B>>2]=c[d>>2];c[C>>2]=c[e>>2];c[k>>2]=c[B>>2];c[l>>2]=c[C>>2];c[d>>2]=Rp(b,k,l,f,g,h,58947,58955)|0;V=28;break}case 119:{c[D>>2]=c[e>>2];c[l>>2]=c[D>>2];lq(b,h+24|0,d,l,g,N);V=28;break}case 120:{W=c[(c[b>>2]|0)+20>>2]|0;c[E>>2]=c[d>>2];c[F>>2]=c[e>>2];c[k>>2]=c[E>>2];c[l>>2]=c[F>>2];k=Db[W&63](b,k,l,f,g,h)|0;break}case 88:{V=b+8|0;V=Eb[c[(c[V>>2]|0)+24>>2]&127](V)|0;c[G>>2]=c[d>>2];c[H>>2]=c[e>>2];j=a[V>>0]|0;e=(j&1)==0;W=e?V+1|0:c[V+8>>2]|0;V=W+(e?(j&255)>>>1:c[V+4>>2]|0)|0;c[k>>2]=c[G>>2];c[l>>2]=c[H>>2];c[d>>2]=Rp(b,k,l,f,g,h,W,V)|0;V=28;break}case 121:{c[J>>2]=c[e>>2];c[l>>2]=c[J>>2];aq(b,h+20|0,d,l,g,N);V=28;break}case 89:{c[K>>2]=c[e>>2];c[l>>2]=c[K>>2];mq(b,h+20|0,d,l,g,N);V=28;break}case 37:{c[L>>2]=c[e>>2];c[l>>2]=c[L>>2];nq(b,d,l,g,N);V=28;break}default:{c[g>>2]=c[g>>2]|4;V=28}}while(0);if((V|0)==28)k=c[d>>2]|0;i=U;return k|0}function cq(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=Vu(d,a,f,g,2)|0;d=c[f>>2]|0;if((a+-1|0)>>>0<31&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function dq(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=Vu(d,a,f,g,2)|0;d=c[f>>2]|0;if((a|0)<24&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function eq(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=Vu(d,a,f,g,2)|0;d=c[f>>2]|0;if((a+-1|0)>>>0<12&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function fq(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=Vu(d,a,f,g,3)|0;d=c[f>>2]|0;if((a|0)<366&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function gq(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=Vu(d,a,f,g,2)|0;d=c[f>>2]|0;if((a|0)<13&(d&4|0)==0)c[b>>2]=a+-1;else c[f>>2]=d|4;i=h;return}function hq(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=Vu(d,a,f,g,2)|0;d=c[f>>2]|0;if((a|0)<60&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function iq(a,e,f,g,h){a=a|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0;j=h+8|0;a:while(1){h=c[e>>2]|0;do if(h){if((c[h+12>>2]|0)==(c[h+16>>2]|0))if((Eb[c[(c[h>>2]|0)+36>>2]&127](h)|0)==-1){c[e>>2]=0;h=0;break}else{h=c[e>>2]|0;break}}else h=0;while(0);h=(h|0)==0;a=c[f>>2]|0;do if(a){if((c[a+12>>2]|0)!=(c[a+16>>2]|0))if(h)break;else break a;if((Eb[c[(c[a>>2]|0)+36>>2]&127](a)|0)!=-1)if(h)break;else break a;else{c[f>>2]=0;k=12;break}}else k=12;while(0);if((k|0)==12){k=0;if(h){a=0;break}else a=0}h=c[e>>2]|0;i=c[h+12>>2]|0;if((i|0)==(c[h+16>>2]|0))h=Eb[c[(c[h>>2]|0)+36>>2]&127](h)|0;else h=d[i>>0]|0;if((h&255)<<24>>24<=-1)break;if(!(b[(c[j>>2]|0)+(h<<24>>24<<1)>>1]&8192))break;h=c[e>>2]|0;a=h+12|0;i=c[a>>2]|0;if((i|0)==(c[h+16>>2]|0)){Eb[c[(c[h>>2]|0)+40>>2]&127](h)|0;continue}else{c[a>>2]=i+1;continue}}h=c[e>>2]|0;do if(h){if((c[h+12>>2]|0)==(c[h+16>>2]|0))if((Eb[c[(c[h>>2]|0)+36>>2]&127](h)|0)==-1){c[e>>2]=0;h=0;break}else{h=c[e>>2]|0;break}}else h=0;while(0);h=(h|0)==0;do if(a){if((c[a+12>>2]|0)==(c[a+16>>2]|0)?(Eb[c[(c[a>>2]|0)+36>>2]&127](a)|0)==-1:0){c[f>>2]=0;k=32;break}if(!h)k=33}else k=32;while(0);if((k|0)==32?h:0)k=33;if((k|0)==33)c[g>>2]=c[g>>2]|2;return}function jq(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0;n=i;i=i+16|0;k=n+4|0;l=n;m=b+8|0;m=Eb[c[(c[m>>2]|0)+8>>2]&127](m)|0;b=a[m>>0]|0;if(!(b&1))j=(b&255)>>>1;else j=c[m+4>>2]|0;b=a[m+12>>0]|0;if(!(b&1))b=(b&255)>>>1;else b=c[m+16>>2]|0;do if((j|0)!=(0-b|0)){c[l>>2]=c[f>>2];c[k>>2]=c[l>>2];b=xu(e,k,m,m+24|0,h,g,0)|0;j=c[d>>2]|0;if((b|0)==(m|0)&(j|0)==12){c[d>>2]=0;break}if((j|0)<12&(b-m|0)==12)c[d>>2]=j+12}else c[g>>2]=c[g>>2]|4;while(0);i=n;return}function kq(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=Vu(d,a,f,g,2)|0;d=c[f>>2]|0;if((a|0)<61&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function lq(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=Vu(d,a,f,g,1)|0;d=c[f>>2]|0;if((a|0)<7&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function mq(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=Vu(d,a,f,g,4)|0;if(!(c[f>>2]&4))c[b>>2]=a+-1900;i=h;return}function nq(a,b,e,f,g){a=a|0;b=b|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0;a=c[b>>2]|0;do if(a){if((c[a+12>>2]|0)==(c[a+16>>2]|0))if((Eb[c[(c[a>>2]|0)+36>>2]&127](a)|0)==-1){c[b>>2]=0;a=0;break}else{a=c[b>>2]|0;break}}else a=0;while(0);h=(a|0)==0;a=c[e>>2]|0;do if(a){if((c[a+12>>2]|0)==(c[a+16>>2]|0)?(Eb[c[(c[a>>2]|0)+36>>2]&127](a)|0)==-1:0){c[e>>2]=0;j=11;break}if(h){i=a;j=13}else j=12}else j=11;while(0);if((j|0)==11)if(h)j=12;else{i=0;j=13}a:do if((j|0)==12)c[f>>2]=c[f>>2]|6;else if((j|0)==13){a=c[b>>2]|0;h=c[a+12>>2]|0;if((h|0)==(c[a+16>>2]|0))a=Eb[c[(c[a>>2]|0)+36>>2]&127](a)|0;else a=d[h>>0]|0;if((Gb[c[(c[g>>2]|0)+36>>2]&63](g,a&255,0)|0)<<24>>24!=37){c[f>>2]=c[f>>2]|4;break}a=c[b>>2]|0;h=a+12|0;g=c[h>>2]|0;if((g|0)==(c[a+16>>2]|0)){Eb[c[(c[a>>2]|0)+40>>2]&127](a)|0;a=c[b>>2]|0;if(!a)a=0;else j=21}else{c[h>>2]=g+1;j=21}do if((j|0)==21)if((c[a+12>>2]|0)==(c[a+16>>2]|0))if((Eb[c[(c[a>>2]|0)+36>>2]&127](a)|0)==-1){c[b>>2]=0;a=0;break}else{a=c[b>>2]|0;break}while(0);a=(a|0)==0;do if(i){if((c[i+12>>2]|0)==(c[i+16>>2]|0)?(Eb[c[(c[i>>2]|0)+36>>2]&127](i)|0)==-1:0){c[e>>2]=0;j=30;break}if(a)break a}else j=30;while(0);if((j|0)==30?!a:0)break;c[f>>2]=c[f>>2]|2}while(0);return}function oq(a,b,d,e,f,g,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;x=i;i=i+32|0;s=x+16|0;r=x+12|0;v=x+8|0;t=x+4|0;u=x;k=jn(e)|0;c[v>>2]=k;o=0;v=ra(37,v|0,44212)|0;q=o;o=0;if(q&1){x=Na()|0;pm(k)|0;Ya(x|0)}pm(k)|0;c[f>>2]=0;k=c[b>>2]|0;a:do if((h|0)!=(j|0)){b:while(1){m=k;if(k){l=c[k+12>>2]|0;if((l|0)==(c[k+16>>2]|0))l=Eb[c[(c[k>>2]|0)+36>>2]&127](k)|0;else l=c[l>>2]|0;if((l|0)==-1){c[b>>2]=0;k=0;p=1;q=0}else{p=0;q=m}}else{k=0;p=1;q=m}n=c[d>>2]|0;l=n;do if(n){m=c[n+12>>2]|0;if((m|0)==(c[n+16>>2]|0))m=Eb[c[(c[n>>2]|0)+36>>2]&127](n)|0;else m=c[m>>2]|0;if((m|0)!=-1)if(p)break;else{w=17;break b}else{c[d>>2]=0;l=0;w=15;break}}else w=15;while(0);if((w|0)==15){w=0;if(p){w=17;break}else n=0}c:do if((Gb[c[(c[v>>2]|0)+52>>2]&63](v,c[h>>2]|0,0)|0)<<24>>24==37){m=h+4|0;if((m|0)==(j|0)){w=21;break b}p=Gb[c[(c[v>>2]|0)+52>>2]&63](v,c[m>>2]|0,0)|0;switch(p<<24>>24){case 48:case 69:{n=h+8|0;if((n|0)==(j|0)){w=24;break b}h=m;m=Gb[c[(c[v>>2]|0)+52>>2]&63](v,c[n>>2]|0,0)|0;k=p;break}default:{m=p;k=0}}p=c[(c[a>>2]|0)+36>>2]|0;c[t>>2]=q;c[u>>2]=l;c[r>>2]=c[t>>2];c[s>>2]=c[u>>2];c[b>>2]=Sb[p&15](a,r,s,e,f,g,m,k)|0;h=h+8|0}else{if(!(Gb[c[(c[v>>2]|0)+12>>2]&63](v,8192,c[h>>2]|0)|0)){m=k+12|0;l=c[m>>2]|0;n=k+16|0;if((l|0)==(c[n>>2]|0))l=Eb[c[(c[k>>2]|0)+36>>2]&127](k)|0;else l=c[l>>2]|0;q=Lb[c[(c[v>>2]|0)+28>>2]&63](v,l)|0;if((q|0)!=(Lb[c[(c[v>>2]|0)+28>>2]&63](v,c[h>>2]|0)|0)){w=61;break b}l=c[m>>2]|0;if((l|0)==(c[n>>2]|0))Eb[c[(c[k>>2]|0)+40>>2]&127](k)|0;else c[m>>2]=l+4;h=h+4|0;break}do{h=h+4|0;if((h|0)==(j|0)){h=j;break}}while(Gb[c[(c[v>>2]|0)+12>>2]&63](v,8192,c[h>>2]|0)|0);l=n;p=n;while(1){if(k){m=c[k+12>>2]|0;if((m|0)==(c[k+16>>2]|0))m=Eb[c[(c[k>>2]|0)+36>>2]&127](k)|0;else m=c[m>>2]|0;if((m|0)==-1){c[b>>2]=0;n=1;k=0}else n=0}else{n=1;k=0}do if(p){m=c[p+12>>2]|0;if((m|0)==(c[p+16>>2]|0))m=Eb[c[(c[p>>2]|0)+36>>2]&127](p)|0;else m=c[m>>2]|0;if((m|0)!=-1)if(n^(l|0)==0){q=l;p=l;break}else break c;else{c[d>>2]=0;l=0;w=44;break}}else w=44;while(0);if((w|0)==44){w=0;if(n)break c;else{q=l;p=0}}m=k+12|0;l=c[m>>2]|0;n=k+16|0;if((l|0)==(c[n>>2]|0))l=Eb[c[(c[k>>2]|0)+36>>2]&127](k)|0;else l=c[l>>2]|0;if(!(Gb[c[(c[v>>2]|0)+12>>2]&63](v,8192,l)|0))break c;l=c[m>>2]|0;if((l|0)==(c[n>>2]|0)){Eb[c[(c[k>>2]|0)+40>>2]&127](k)|0;l=q;continue}else{c[m>>2]=l+4;l=q;continue}}}while(0);k=c[b>>2]|0;if(!((h|0)!=(j|0)&(c[f>>2]|0)==0))break a}if((w|0)==17){c[f>>2]=4;break}else if((w|0)==21){c[f>>2]=4;break}else if((w|0)==24){c[f>>2]=4;break}else if((w|0)==61){c[f>>2]=4;k=c[b>>2]|0;break}}while(0);if(k){h=c[k+12>>2]|0;if((h|0)==(c[k+16>>2]|0))h=Eb[c[(c[k>>2]|0)+36>>2]&127](k)|0;else h=c[h>>2]|0;if((h|0)==-1){c[b>>2]=0;k=0;m=1}else m=0}else{k=0;m=1}h=c[d>>2]|0;do if(h){l=c[h+12>>2]|0;if((l|0)==(c[h+16>>2]|0))h=Eb[c[(c[h>>2]|0)+36>>2]&127](h)|0;else h=c[l>>2]|0;if((h|0)!=-1)if(m)break;else{w=76;break}else{c[d>>2]=0;w=74;break}}else w=74;while(0);if((w|0)==74?m:0)w=76;if((w|0)==76)c[f>>2]=c[f>>2]|2;i=x;return k|0}function pq(a){a=a|0;return}function qq(a){a=a|0;cj(a);return}function rq(a){a=a|0;return 2}function sq(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=oq(a,k,j,e,f,g,44788,44820)|0;i=h;return a|0}function tq(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;j=i;i=i+16|0;k=j+12|0;l=j+8|0;n=j+4|0;m=j;q=b+8|0;q=Eb[c[(c[q>>2]|0)+20>>2]&127](q)|0;c[n>>2]=c[d>>2];c[m>>2]=c[e>>2];o=a[q>>0]|0;p=(o&1)==0;e=q+4|0;d=p?e:c[q+8>>2]|0;e=d+((p?(o&255)>>>1:c[e>>2]|0)<<2)|0;c[l>>2]=c[n>>2];c[k>>2]=c[m>>2];b=oq(b,l,k,f,g,h,d,e)|0;i=j;return b|0}function uq(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;l=i;i=i+16|0;j=l+8|0;h=l+4|0;k=l;e=jn(e)|0;c[h>>2]=e;o=0;h=ra(37,h|0,44212)|0;m=o;o=0;if(m&1){m=Na()|0;pm(e)|0;Ya(m|0)}else{pm(e)|0;c[k>>2]=c[d>>2];c[j>>2]=c[k>>2];vq(a,g+24|0,b,j,f,h);i=l;return c[b>>2]|0}return 0}function vq(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0;h=i;i=i+16|0;j=h+4|0;k=h;a=a+8|0;a=Eb[c[c[a>>2]>>2]&127](a)|0;c[k>>2]=c[e>>2];c[j>>2]=c[k>>2];d=(Iu(d,j,a,a+168|0,g,f,0)|0)-a|0;if((d|0)<168)c[b>>2]=((d|0)/12|0|0)%7|0;i=h;return}function wq(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;l=i;i=i+16|0;j=l+8|0;h=l+4|0;k=l;e=jn(e)|0;c[h>>2]=e;o=0;h=ra(37,h|0,44212)|0;m=o;o=0;if(m&1){m=Na()|0;pm(e)|0;Ya(m|0)}else{pm(e)|0;c[k>>2]=c[d>>2];c[j>>2]=c[k>>2];xq(a,g+16|0,b,j,f,h);i=l;return c[b>>2]|0}return 0}function xq(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0;h=i;i=i+16|0;j=h+4|0;k=h;a=a+8|0;a=Eb[c[(c[a>>2]|0)+4>>2]&127](a)|0;c[k>>2]=c[e>>2];c[j>>2]=c[k>>2];d=(Iu(d,j,a,a+288|0,g,f,0)|0)-a|0;if((d|0)<288)c[b>>2]=((d|0)/12|0|0)%12|0;i=h;return}function yq(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;l=i;i=i+16|0;j=l+8|0;h=l+4|0;k=l;e=jn(e)|0;c[h>>2]=e;o=0;h=ra(37,h|0,44212)|0;m=o;o=0;if(m&1){m=Na()|0;pm(e)|0;Ya(m|0)}else{pm(e)|0;c[k>>2]=c[d>>2];c[j>>2]=c[k>>2];zq(a,g+20|0,b,j,f,h);i=l;return c[b>>2]|0}return 0}function zq(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=Wu(d,a,f,g,4)|0;if(!(c[f>>2]&4)){if((a|0)<69)a=a+2e3|0;else a=(a+-69|0)>>>0<31?a+1900|0:a;c[b>>2]=a+-1900}i=h;return}function Aq(b,d,e,f,g,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0;U=i;i=i+144|0;l=U+132|0;k=U+116|0;N=U+128|0;x=U+124|0;I=U+120|0;O=U+112|0;P=U+108|0;Q=U+104|0;R=U+100|0;S=U+96|0;T=U+92|0;m=U+88|0;n=U+84|0;p=U+80|0;q=U+76|0;r=U+72|0;s=U+68|0;t=U+64|0;u=U+60|0;v=U+56|0;w=U+52|0;y=U+48|0;z=U+44|0;A=U+40|0;B=U+36|0;C=U+32|0;D=U+28|0;E=U+24|0;F=U+20|0;G=U+16|0;H=U+12|0;J=U+8|0;K=U+4|0;L=U;c[g>>2]=0;M=jn(f)|0;c[N>>2]=M;o=0;N=ra(37,N|0,44212)|0;W=o;o=0;if(W&1){W=Na()|0;pm(M)|0;Ya(W|0)}pm(M)|0;do switch(j<<24>>24|0){case 65:case 97:{c[x>>2]=c[e>>2];c[l>>2]=c[x>>2];vq(b,h+24|0,d,l,g,N);V=28;break}case 104:case 66:case 98:{c[I>>2]=c[e>>2];c[l>>2]=c[I>>2];xq(b,h+16|0,d,l,g,N);V=28;break}case 99:{W=b+8|0;W=Eb[c[(c[W>>2]|0)+12>>2]&127](W)|0;c[O>>2]=c[d>>2];c[P>>2]=c[e>>2];j=a[W>>0]|0;e=(j&1)==0;V=W+4|0;W=e?V:c[W+8>>2]|0;V=W+((e?(j&255)>>>1:c[V>>2]|0)<<2)|0;c[k>>2]=c[O>>2];c[l>>2]=c[P>>2];c[d>>2]=oq(b,k,l,f,g,h,W,V)|0;V=28;break}case 101:case 100:{c[Q>>2]=c[e>>2];c[l>>2]=c[Q>>2];Bq(b,h+12|0,d,l,g,N);V=28;break}case 68:{c[R>>2]=c[d>>2];c[S>>2]=c[e>>2];c[k>>2]=c[R>>2];c[l>>2]=c[S>>2];c[d>>2]=oq(b,k,l,f,g,h,44820,44852)|0;V=28;break}case 70:{c[T>>2]=c[d>>2];c[m>>2]=c[e>>2];c[k>>2]=c[T>>2];c[l>>2]=c[m>>2];c[d>>2]=oq(b,k,l,f,g,h,44852,44884)|0;V=28;break}case 72:{c[n>>2]=c[e>>2];c[l>>2]=c[n>>2];Cq(b,h+8|0,d,l,g,N);V=28;break}case 73:{c[p>>2]=c[e>>2];c[l>>2]=c[p>>2];Dq(b,h+8|0,d,l,g,N);V=28;break}case 106:{c[q>>2]=c[e>>2];c[l>>2]=c[q>>2];Eq(b,h+28|0,d,l,g,N);V=28;break}case 109:{c[r>>2]=c[e>>2];c[l>>2]=c[r>>2];Fq(b,h+16|0,d,l,g,N);V=28;break}case 77:{c[s>>2]=c[e>>2];c[l>>2]=c[s>>2];Gq(b,h+4|0,d,l,g,N);V=28;break}case 116:case 110:{c[t>>2]=c[e>>2];c[l>>2]=c[t>>2];Hq(b,d,l,g,N);V=28;break}case 112:{c[u>>2]=c[e>>2];c[l>>2]=c[u>>2];Iq(b,h+8|0,d,l,g,N);V=28;break}case 114:{c[v>>2]=c[d>>2];c[w>>2]=c[e>>2];c[k>>2]=c[v>>2];c[l>>2]=c[w>>2];c[d>>2]=oq(b,k,l,f,g,h,44884,44928)|0;V=28;break}case 82:{c[y>>2]=c[d>>2];c[z>>2]=c[e>>2];c[k>>2]=c[y>>2];c[l>>2]=c[z>>2];c[d>>2]=oq(b,k,l,f,g,h,44928,44948)|0;V=28;break}case 83:{c[A>>2]=c[e>>2];c[l>>2]=c[A>>2];Jq(b,h,d,l,g,N);V=28;break}case 84:{c[B>>2]=c[d>>2];c[C>>2]=c[e>>2];c[k>>2]=c[B>>2];c[l>>2]=c[C>>2];c[d>>2]=oq(b,k,l,f,g,h,44948,44980)|0;V=28;break}case 119:{c[D>>2]=c[e>>2];c[l>>2]=c[D>>2];Kq(b,h+24|0,d,l,g,N);V=28;break}case 120:{W=c[(c[b>>2]|0)+20>>2]|0;c[E>>2]=c[d>>2];c[F>>2]=c[e>>2];c[k>>2]=c[E>>2];c[l>>2]=c[F>>2];k=Db[W&63](b,k,l,f,g,h)|0;break}case 88:{W=b+8|0;W=Eb[c[(c[W>>2]|0)+24>>2]&127](W)|0;c[G>>2]=c[d>>2];c[H>>2]=c[e>>2];j=a[W>>0]|0;e=(j&1)==0;V=W+4|0;W=e?V:c[W+8>>2]|0;V=W+((e?(j&255)>>>1:c[V>>2]|0)<<2)|0;c[k>>2]=c[G>>2];c[l>>2]=c[H>>2];c[d>>2]=oq(b,k,l,f,g,h,W,V)|0;V=28;break}case 121:{c[J>>2]=c[e>>2];c[l>>2]=c[J>>2];zq(b,h+20|0,d,l,g,N);V=28;break}case 89:{c[K>>2]=c[e>>2];c[l>>2]=c[K>>2];Lq(b,h+20|0,d,l,g,N);V=28;break}case 37:{c[L>>2]=c[e>>2];c[l>>2]=c[L>>2];Mq(b,d,l,g,N);V=28;break}default:{c[g>>2]=c[g>>2]|4;V=28}}while(0);if((V|0)==28)k=c[d>>2]|0;i=U;return k|0}function Bq(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=Wu(d,a,f,g,2)|0;d=c[f>>2]|0;if((a+-1|0)>>>0<31&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function Cq(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=Wu(d,a,f,g,2)|0;d=c[f>>2]|0;if((a|0)<24&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function Dq(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=Wu(d,a,f,g,2)|0;d=c[f>>2]|0;if((a+-1|0)>>>0<12&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function Eq(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=Wu(d,a,f,g,3)|0;d=c[f>>2]|0;if((a|0)<366&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function Fq(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=Wu(d,a,f,g,2)|0;d=c[f>>2]|0;if((a|0)<13&(d&4|0)==0)c[b>>2]=a+-1;else c[f>>2]=d|4;i=h;return}function Gq(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=Wu(d,a,f,g,2)|0;d=c[f>>2]|0;if((a|0)<60&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function Hq(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0;a:while(1){a=c[b>>2]|0;do if(a){g=c[a+12>>2]|0;if((g|0)==(c[a+16>>2]|0))a=Eb[c[(c[a>>2]|0)+36>>2]&127](a)|0;else a=c[g>>2]|0;if((a|0)==-1){c[b>>2]=0;h=1;break}else{h=(c[b>>2]|0)==0;break}}else h=1;while(0);g=c[d>>2]|0;do if(g){a=c[g+12>>2]|0;if((a|0)==(c[g+16>>2]|0))a=Eb[c[(c[g>>2]|0)+36>>2]&127](g)|0;else a=c[a>>2]|0;if((a|0)!=-1)if(h){h=g;break}else{h=g;break a}else{c[d>>2]=0;i=15;break}}else i=15;while(0);if((i|0)==15){i=0;if(h){h=0;break}else h=0}a=c[b>>2]|0;g=c[a+12>>2]|0;if((g|0)==(c[a+16>>2]|0))a=Eb[c[(c[a>>2]|0)+36>>2]&127](a)|0;else a=c[g>>2]|0;if(!(Gb[c[(c[f>>2]|0)+12>>2]&63](f,8192,a)|0))break;a=c[b>>2]|0;g=a+12|0;h=c[g>>2]|0;if((h|0)==(c[a+16>>2]|0)){Eb[c[(c[a>>2]|0)+40>>2]&127](a)|0;continue}else{c[g>>2]=h+4;continue}}a=c[b>>2]|0;do if(a){g=c[a+12>>2]|0;if((g|0)==(c[a+16>>2]|0))a=Eb[c[(c[a>>2]|0)+36>>2]&127](a)|0;else a=c[g>>2]|0;if((a|0)==-1){c[b>>2]=0;g=1;break}else{g=(c[b>>2]|0)==0;break}}else g=1;while(0);do if(h){a=c[h+12>>2]|0;if((a|0)==(c[h+16>>2]|0))a=Eb[c[(c[h>>2]|0)+36>>2]&127](h)|0;else a=c[a>>2]|0;if((a|0)!=-1)if(g)break;else{i=39;break}else{c[d>>2]=0;i=37;break}}else i=37;while(0);if((i|0)==37?g:0)i=39;if((i|0)==39)c[e>>2]=c[e>>2]|2;return}function Iq(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0;n=i;i=i+16|0;k=n+4|0;l=n;m=b+8|0;m=Eb[c[(c[m>>2]|0)+8>>2]&127](m)|0;b=a[m>>0]|0;if(!(b&1))j=(b&255)>>>1;else j=c[m+4>>2]|0;b=a[m+12>>0]|0;if(!(b&1))b=(b&255)>>>1;else b=c[m+16>>2]|0;do if((j|0)!=(0-b|0)){c[l>>2]=c[f>>2];c[k>>2]=c[l>>2];b=Iu(e,k,m,m+24|0,h,g,0)|0;j=c[d>>2]|0;if((b|0)==(m|0)&(j|0)==12){c[d>>2]=0;break}if((j|0)<12&(b-m|0)==12)c[d>>2]=j+12}else c[g>>2]=c[g>>2]|4;while(0);i=n;return}function Jq(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=Wu(d,a,f,g,2)|0;d=c[f>>2]|0;if((a|0)<61&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function Kq(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=Wu(d,a,f,g,1)|0;d=c[f>>2]|0;if((a|0)<7&(d&4|0)==0)c[b>>2]=a;else c[f>>2]=d|4;i=h;return}function Lq(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;h=i;i=i+16|0;a=h+4|0;j=h;c[j>>2]=c[e>>2];c[a>>2]=c[j>>2];a=Wu(d,a,f,g,4)|0;if(!(c[f>>2]&4))c[b>>2]=a+-1900;i=h;return}function Mq(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0;a=c[b>>2]|0;do if(a){g=c[a+12>>2]|0;if((g|0)==(c[a+16>>2]|0))a=Eb[c[(c[a>>2]|0)+36>>2]&127](a)|0;else a=c[g>>2]|0;if((a|0)==-1){c[b>>2]=0;h=1;break}else{h=(c[b>>2]|0)==0;break}}else h=1;while(0);g=c[d>>2]|0;do if(g){a=c[g+12>>2]|0;if((a|0)==(c[g+16>>2]|0))a=Eb[c[(c[g>>2]|0)+36>>2]&127](g)|0;else a=c[a>>2]|0;if((a|0)!=-1)if(h){i=g;j=17;break}else{j=16;break}else{c[d>>2]=0;j=14;break}}else j=14;while(0);if((j|0)==14)if(h)j=16;else{i=0;j=17}a:do if((j|0)==16)c[e>>2]=c[e>>2]|6;else if((j|0)==17){a=c[b>>2]|0;g=c[a+12>>2]|0;if((g|0)==(c[a+16>>2]|0))a=Eb[c[(c[a>>2]|0)+36>>2]&127](a)|0;else a=c[g>>2]|0;if((Gb[c[(c[f>>2]|0)+52>>2]&63](f,a,0)|0)<<24>>24!=37){c[e>>2]=c[e>>2]|4;break}a=c[b>>2]|0;g=a+12|0;h=c[g>>2]|0;if((h|0)==(c[a+16>>2]|0)){Eb[c[(c[a>>2]|0)+40>>2]&127](a)|0;a=c[b>>2]|0;if(!a)g=1;else j=25}else{c[g>>2]=h+4;j=25}do if((j|0)==25){g=c[a+12>>2]|0;if((g|0)==(c[a+16>>2]|0))a=Eb[c[(c[a>>2]|0)+36>>2]&127](a)|0;else a=c[g>>2]|0;if((a|0)==-1){c[b>>2]=0;g=1;break}else{g=(c[b>>2]|0)==0;break}}while(0);do if(i){a=c[i+12>>2]|0;if((a|0)==(c[i+16>>2]|0))a=Eb[c[(c[i>>2]|0)+36>>2]&127](i)|0;else a=c[a>>2]|0;if((a|0)!=-1)if(g)break a;else break;else{c[d>>2]=0;j=37;break}}else j=37;while(0);if((j|0)==37?!g:0)break;c[e>>2]=c[e>>2]|2}while(0);return}function Nq(a){a=a|0;Oq(a+8|0);return}function Oq(a){a=a|0;var b=0,d=0,e=0;b=c[a>>2]|0;o=0;d=ua(3)|0;e=o;o=0;do if(!(e&1)){if((b|0)!=(d|0)?(o=0,ha(188,c[a>>2]|0),e=o,o=0,e&1):0)break;return}while(0);e=Na(0)|0;ec(e)}function Pq(a){a=a|0;Oq(a+8|0);cj(a);return}function Qq(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0;l=i;i=i+112|0;k=l+4|0;e=l;c[e>>2]=k+100;Rq(b+8|0,k,e,g,h,j);g=c[e>>2]|0;e=c[d>>2]|0;if((k|0)!=(g|0))do{j=a[k>>0]|0;do if(e){f=e+24|0;h=c[f>>2]|0;if((h|0)==(c[e+28>>2]|0)){d=(Lb[c[(c[e>>2]|0)+52>>2]&63](e,j&255)|0)==-1;e=d?0:e;break}else{c[f>>2]=h+1;a[h>>0]=j;break}}else e=0;while(0);k=k+1|0}while((k|0)!=(g|0));i=l;return e|0}function Rq(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0;m=i;i=i+16|0;l=m;a[l>>0]=37;j=l+1|0;a[j>>0]=g;k=l+2|0;a[k>>0]=h;a[l+3>>0]=0;if(h<<24>>24){a[j>>0]=h;a[k>>0]=g}c[e>>2]=d+(Ra(d|0,(c[e>>2]|0)-d|0,l|0,f|0,c[b>>2]|0)|0);i=m;return}function Sq(a){a=a|0;Oq(a+8|0);return}function Tq(a){a=a|0;Oq(a+8|0);cj(a);return}function Uq(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0;j=i;i=i+416|0;e=j+8|0;d=j;c[d>>2]=e+400;Vq(a+8|0,e,d,f,g,h);a=c[d>>2]|0;d=c[b>>2]|0;if((e|0)!=(a|0)){f=e;do{e=c[f>>2]|0;if(!d)d=0;else{g=d+24|0;h=c[g>>2]|0;if((h|0)==(c[d+28>>2]|0))e=Lb[c[(c[d>>2]|0)+52>>2]&63](d,e)|0;else{c[g>>2]=h+4;c[h>>2]=e}d=(e|0)==-1?0:d}f=f+4|0}while((f|0)!=(a|0))}i=j;return d|0}function Vq(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+128|0;l=h+16|0;m=h+12|0;j=h;k=h+8|0;c[m>>2]=l+100;Rq(a,l,m,e,f,g);f=j;c[f>>2]=0;c[f+4>>2]=0;c[k>>2]=l;f=(c[d>>2]|0)-b>>2;g=qk(c[a>>2]|0)|0;o=0;f=va(18,b|0,k|0,f|0,j|0)|0;a=o;o=0;if(a&1){f=Na()|0;if((g|0)!=0?(o=0,ka(75,g|0)|0,m=o,o=0,m&1):0){m=Na(0)|0;ec(m)}Ya(f|0)}if((g|0)!=0?(o=0,ka(75,g|0)|0,m=o,o=0,m&1):0){m=Na(0)|0;ec(m)}if((f|0)==-1)Rr(58955);else{c[d>>2]=b+(f<<2);i=h;return}}function Wq(a){a=a|0;return}function Xq(a){a=a|0;cj(a);return}function Yq(a){a=a|0;return 127}function Zq(a){a=a|0;return 127}function _q(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;return}function $q(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;return}function ar(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;return}function br(a,b){a=a|0;b=b|0;Hm(a,1,45);return}function cr(a){a=a|0;return 0}function dr(b,c){b=b|0;c=c|0;a[b>>0]=2;a[b+1>>0]=3;a[b+2>>0]=0;a[b+3>>0]=4;return}function er(b,c){b=b|0;c=c|0;a[b>>0]=2;a[b+1>>0]=3;a[b+2>>0]=0;a[b+3>>0]=4;return}function fr(a){a=a|0;return}function gr(a){a=a|0;cj(a);return}function hr(a){a=a|0;return 127}function ir(a){a=a|0;return 127}function jr(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;return}function kr(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;return}function lr(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;return}function mr(a,b){a=a|0;b=b|0;Hm(a,1,45);return}function nr(a){a=a|0;return 0}function or(b,c){b=b|0;c=c|0;a[b>>0]=2;a[b+1>>0]=3;a[b+2>>0]=0;a[b+3>>0]=4;return}function pr(b,c){b=b|0;c=c|0;a[b>>0]=2;a[b+1>>0]=3;a[b+2>>0]=0;a[b+3>>0]=4;return}function qr(a){a=a|0;return}function rr(a){a=a|0;cj(a);return}function sr(a){a=a|0;return 2147483647}function tr(a){a=a|0;return 2147483647}function ur(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;return}function vr(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;return}function wr(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;return}function xr(a,b){a=a|0;b=b|0;Vm(a,1,45);return}function yr(a){a=a|0;return 0}function zr(b,c){b=b|0;c=c|0;a[b>>0]=2;a[b+1>>0]=3;a[b+2>>0]=0;a[b+3>>0]=4;return}function Ar(b,c){b=b|0;c=c|0;a[b>>0]=2;a[b+1>>0]=3;a[b+2>>0]=0;a[b+3>>0]=4;return}function Br(a){a=a|0;return}function Cr(a){a=a|0;cj(a);return}function Dr(a){a=a|0;return 2147483647}function Er(a){a=a|0;return 2147483647}function Fr(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;return}function Gr(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;return}function Hr(a,b){a=a|0;b=b|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;return}function Ir(a,b){a=a|0;b=b|0;Vm(a,1,45);return}function Jr(a){a=a|0;return 0}function Kr(b,c){b=b|0;c=c|0;a[b>>0]=2;a[b+1>>0]=3;a[b+2>>0]=0;a[b+3>>0]=4;return}function Lr(b,c){b=b|0;c=c|0;a[b>>0]=2;a[b+1>>0]=3;a[b+2>>0]=0;a[b+3>>0]=4;return}function Mr(a){a=a|0;return}function Nr(a){a=a|0;cj(a);return}function Or(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0;B=i;i=i+240|0;z=B+24|0;A=B;b=B+136|0;D=B+16|0;y=B+12|0;C=B+8|0;p=B+134|0;l=B+4|0;x=B+124|0;c[D>>2]=b;E=D+4|0;c[E>>2]=189;m=b+100|0;o=0;k=ka(68,g|0)|0;w=o;o=0;if(!(w&1)){c[C>>2]=k;o=0;b=ra(37,C|0,44220)|0;w=o;o=0;a:do if(!(w&1)?(a[p>>0]=0,c[l>>2]=c[e>>2],n=c[g+4>>2]|0,o=0,c[z>>2]=c[l>>2],n=la(1,d|0,z|0,f|0,C|0,n|0,h|0,p|0,b|0,D|0,y|0,m|0)|0,w=o,o=0,!(w&1)):0){b:do if(n){o=0;va(c[(c[b>>2]|0)+32>>2]|0,b|0,58976,58986,x|0)|0;w=o;o=0;if(w&1){G=10;break a}l=c[y>>2]|0;m=c[D>>2]|0;b=l-m|0;if((b|0)>98){b=Fl(b+2|0)|0;k=b;if(!b){o=0;xa(6);w=o;o=0;if(!(w&1)){b=0;G=13}}else G=13}else{k=0;b=z;G=13}do if((G|0)==13){if(a[p>>0]|0){a[b>>0]=45;b=b+1|0}v=x+10|0;w=x;if(m>>>0<l>>>0){n=x+1|0;f=n+1|0;g=f+1|0;p=g+1|0;q=p+1|0;r=q+1|0;s=r+1|0;t=s+1|0;u=t+1|0;do{l=a[m>>0]|0;do if((a[x>>0]|0)!=l<<24>>24)if((a[n>>0]|0)!=l<<24>>24)if((a[f>>0]|0)!=l<<24>>24)if((a[g>>0]|0)!=l<<24>>24)if((a[p>>0]|0)==l<<24>>24)l=p;else{if((a[q>>0]|0)==l<<24>>24){l=q;break}if((a[r>>0]|0)==l<<24>>24){l=r;break}if((a[s>>0]|0)==l<<24>>24){l=s;break}if((a[t>>0]|0)==l<<24>>24){l=t;break}l=(a[u>>0]|0)==l<<24>>24?u:v}else l=g;else l=f;else l=n;else l=x;while(0);a[b>>0]=a[58976+(l-w)>>0]|0;m=m+1|0;b=b+1|0}while(m>>>0<(c[y>>2]|0)>>>0)}a[b>>0]=0;c[A>>2]=j;if(($k(z,58987,A)|0)!=1?(o=0,ha(190,58991),j=o,o=0,j&1):0)break;if(k)Gl(k);break b}while(0);b=Na()|0;if(!k){l=b;k=D;break a}Gl(k);l=b;k=D;break a}while(0);b=c[d>>2]|0;do if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;b=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;j=o;o=0;if(j&1){G=10;break a}if((b|0)==-1){c[d>>2]=0;b=0;break}else{b=c[d>>2]|0;break}}}else b=0;while(0);k=(b|0)==0;b=c[e>>2]|0;do if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;b=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;j=o;o=0;if(j&1){G=10;break a}if((b|0)==-1){c[e>>2]=0;G=37;break}}if(!k)G=38}else G=37;while(0);if((G|0)==37?k:0)G=38;if((G|0)==38)c[h>>2]=c[h>>2]|2;k=c[d>>2]|0;pm(c[C>>2]|0)|0;b=c[D>>2]|0;c[D>>2]=0;if((b|0)!=0?(o=0,ha(c[E>>2]|0,b|0),G=o,o=0,G&1):0){G=Na(0)|0;ec(G)}i=B;return k|0}else G=10;while(0);if((G|0)==10){l=Na()|0;k=D}pm(c[C>>2]|0)|0;b=c[k>>2]|0;c[k>>2]=0;if(!b)F=l;else{k=c[E>>2]|0;G=45}}else{l=Na()|0;c[D>>2]=0;k=189;G=45}if((G|0)==45){o=0;ha(k|0,b|0);G=o;o=0;if(G&1){G=Na(0)|0;ec(G)}else F=l}Ya(F|0);return 0}function Pr(a){a=a|0;return}function Qr(e,f,g,h,j,k,l,m,n,p,q){e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;p=p|0;q=q|0;var r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0;ba=i;i=i+512|0;P=ba+88|0;u=ba+96|0;da=ba+80|0;T=ba+72|0;S=ba+68|0;U=ba+500|0;Q=ba+497|0;V=ba+496|0;Y=ba+56|0;aa=ba+44|0;_=ba+32|0;Z=ba+20|0;$=ba+8|0;R=ba+4|0;X=ba;c[P>>2]=q;c[da>>2]=u;ca=da+4|0;c[ca>>2]=189;c[T>>2]=u;c[S>>2]=u+400;c[Y>>2]=0;c[Y+4>>2]=0;c[Y+8>>2]=0;c[aa>>2]=0;c[aa+4>>2]=0;c[aa+8>>2]=0;c[_>>2]=0;c[_+4>>2]=0;c[_+8>>2]=0;c[Z>>2]=0;c[Z+4>>2]=0;c[Z+8>>2]=0;c[$>>2]=0;c[$+4>>2]=0;c[$+8>>2]=0;o=0;qa(1,g|0,h|0,U|0,Q|0,V|0,Y|0,aa|0,_|0,Z|0,R|0);O=o;o=0;a:do if(O&1)m=Na()|0;else{c[p>>2]=c[n>>2];I=m+8|0;J=_+4|0;K=Z+4|0;L=Z+8|0;M=Z+1|0;N=_+8|0;O=_+1|0;z=(j&512|0)!=0;A=aa+8|0;B=aa+1|0;C=aa+4|0;D=$+4|0;E=$+8|0;F=$+1|0;G=U+3|0;H=Y+4|0;y=0;t=0;b:while(1){q=c[e>>2]|0;do if(q){if((c[q+12>>2]|0)==(c[q+16>>2]|0)){o=0;q=ka(c[(c[q>>2]|0)+36>>2]|0,q|0)|0;x=o;o=0;if(x&1){W=24;break b}if((q|0)==-1){c[e>>2]=0;q=0;break}else{q=c[e>>2]|0;break}}}else q=0;while(0);q=(q|0)==0;m=c[f>>2]|0;do if(m){if((c[m+12>>2]|0)!=(c[m+16>>2]|0))if(q){x=m;break}else{W=235;break b}o=0;g=ka(c[(c[m>>2]|0)+36>>2]|0,m|0)|0;x=o;o=0;if(x&1){W=24;break b}if((g|0)!=-1)if(q){x=m;break}else{W=235;break b}else{c[f>>2]=0;W=15;break}}else W=15;while(0);if((W|0)==15){W=0;if(q){W=235;break}else x=0}c:do switch(a[U+y>>0]|0){case 1:{if((y|0)!=3){q=c[e>>2]|0;m=c[q+12>>2]|0;if((m|0)==(c[q+16>>2]|0)){o=0;q=ka(c[(c[q>>2]|0)+36>>2]|0,q|0)|0;W=o;o=0;if(W&1){W=24;break b}}else q=d[m>>0]|0;if((q&255)<<24>>24<=-1){W=40;break b}if(!(b[(c[I>>2]|0)+(q<<24>>24<<1)>>1]&8192)){W=40;break b}q=c[e>>2]|0;m=q+12|0;g=c[m>>2]|0;if((g|0)==(c[q+16>>2]|0)){o=0;q=ka(c[(c[q>>2]|0)+40>>2]|0,q|0)|0;W=o;o=0;if(W&1){W=24;break b}}else{c[m>>2]=g+1;q=d[g>>0]|0}o=0;ia(67,$|0,q&255|0);W=o;o=0;if(W&1){W=24;break b}else{q=x;h=x;W=42}}break}case 0:{if((y|0)!=3){q=x;h=x;W=42}break}case 3:{m=a[_>>0]|0;q=(m&1)==0?(m&255)>>>1:c[J>>2]|0;g=a[Z>>0]|0;h=(g&1)==0?(g&255)>>>1:c[K>>2]|0;if((q|0)!=(0-h|0)){if(!q){q=c[e>>2]|0;m=c[q+12>>2]|0;if((m|0)==(c[q+16>>2]|0)){o=0;q=ka(c[(c[q>>2]|0)+36>>2]|0,q|0)|0;x=o;o=0;if(x&1){W=24;break b}m=a[Z>>0]|0}else{q=d[m>>0]|0;m=g}if((q&255)<<24>>24!=(a[((m&1)==0?M:c[L>>2]|0)>>0]|0))break c;q=c[e>>2]|0;m=q+12|0;g=c[m>>2]|0;if((g|0)==(c[q+16>>2]|0)){o=0;ka(c[(c[q>>2]|0)+40>>2]|0,q|0)|0;x=o;o=0;if(x&1){W=24;break b}}else c[m>>2]=g+1;a[l>>0]=1;x=a[Z>>0]|0;t=((x&1)==0?(x&255)>>>1:c[K>>2]|0)>>>0>1?Z:t;break c}j=c[e>>2]|0;r=c[j+12>>2]|0;g=c[j+16>>2]|0;q=(r|0)==(g|0);if(!h){if(q){o=0;q=ka(c[(c[j>>2]|0)+36>>2]|0,j|0)|0;x=o;o=0;if(x&1){W=24;break b}m=a[_>>0]|0}else q=d[r>>0]|0;if((q&255)<<24>>24!=(a[((m&1)==0?O:c[N>>2]|0)>>0]|0)){a[l>>0]=1;break c}q=c[e>>2]|0;m=q+12|0;g=c[m>>2]|0;if((g|0)==(c[q+16>>2]|0)){o=0;ka(c[(c[q>>2]|0)+40>>2]|0,q|0)|0;x=o;o=0;if(x&1){W=24;break b}}else c[m>>2]=g+1;x=a[_>>0]|0;t=((x&1)==0?(x&255)>>>1:c[J>>2]|0)>>>0>1?_:t;break c}if(q){o=0;q=ka(c[(c[j>>2]|0)+36>>2]|0,j|0)|0;x=o;o=0;if(x&1){W=24;break b}g=c[e>>2]|0;m=a[_>>0]|0;j=g;r=c[g+12>>2]|0;g=c[g+16>>2]|0}else q=d[r>>0]|0;h=j+12|0;g=(r|0)==(g|0);if((q&255)<<24>>24==(a[((m&1)==0?O:c[N>>2]|0)>>0]|0)){if(g){o=0;ka(c[(c[j>>2]|0)+40>>2]|0,j|0)|0;x=o;o=0;if(x&1){W=24;break b}}else c[h>>2]=r+1;x=a[_>>0]|0;t=((x&1)==0?(x&255)>>>1:c[J>>2]|0)>>>0>1?_:t;break c}if(g){o=0;q=ka(c[(c[j>>2]|0)+36>>2]|0,j|0)|0;x=o;o=0;if(x&1){W=24;break b}}else q=d[r>>0]|0;if((q&255)<<24>>24!=(a[((a[Z>>0]&1)==0?M:c[L>>2]|0)>>0]|0)){W=104;break b}q=c[e>>2]|0;m=q+12|0;g=c[m>>2]|0;if((g|0)==(c[q+16>>2]|0)){o=0;ka(c[(c[q>>2]|0)+40>>2]|0,q|0)|0;x=o;o=0;if(x&1){W=24;break b}}else c[m>>2]=g+1;a[l>>0]=1;x=a[Z>>0]|0;t=((x&1)==0?(x&255)>>>1:c[K>>2]|0)>>>0>1?Z:t}break}case 2:{if(!(y>>>0<2|(t|0)!=0)?!(z|(y|0)==2&(a[G>>0]|0)!=0):0){t=0;break c}v=a[aa>>0]|0;q=(v&1)==0;w=c[A>>2]|0;g=q?B:w;s=g;d:do if((y|0)!=0?(d[U+(y+-1)>>0]|0)<2:0){r=q?(v&255)>>>1:c[C>>2]|0;h=g+r|0;j=c[I>>2]|0;e:do if(!r)m=s;else{r=g;m=s;do{q=a[r>>0]|0;if(q<<24>>24<=-1)break e;if(!(b[j+(q<<24>>24<<1)>>1]&8192))break e;r=r+1|0;m=r}while((r|0)!=(h|0))}while(0);h=m-s|0;j=a[$>>0]|0;q=(j&1)==0;j=q?(j&255)>>>1:c[D>>2]|0;if(j>>>0>=h>>>0){q=q?F:c[E>>2]|0;r=q+j|0;if((m|0)!=(s|0)){q=q+(j-h)|0;while(1){if((a[q>>0]|0)!=(a[g>>0]|0)){m=s;break d}q=q+1|0;if((q|0)==(r|0))break;else g=g+1|0}}}else m=s}else m=s;while(0);q=(v&1)==0;q=(q?B:w)+(q?(v&255)>>>1:c[C>>2]|0)|0;f:do if((m|0)!=(q|0)){j=x;h=x;q=m;while(1){m=c[e>>2]|0;do if(m){if((c[m+12>>2]|0)==(c[m+16>>2]|0)){o=0;m=ka(c[(c[m>>2]|0)+36>>2]|0,m|0)|0;x=o;o=0;if(x&1){W=21;break b}if((m|0)==-1){c[e>>2]=0;m=0;break}else{m=c[e>>2]|0;break}}}else m=0;while(0);g=(m|0)==0;do if(h){if((c[h+12>>2]|0)!=(c[h+16>>2]|0))if(g){m=j;r=h;break}else break f;o=0;m=ka(c[(c[h>>2]|0)+36>>2]|0,h|0)|0;x=o;o=0;if(x&1){W=21;break b}if((m|0)!=-1)if(g^(j|0)==0){m=j;r=j;break}else break f;else{c[f>>2]=0;m=0;W=131;break}}else{m=j;W=131}while(0);if((W|0)==131){W=0;if(g)break f;else r=0}g=c[e>>2]|0;h=c[g+12>>2]|0;if((h|0)==(c[g+16>>2]|0)){o=0;g=ka(c[(c[g>>2]|0)+36>>2]|0,g|0)|0;x=o;o=0;if(x&1){W=21;break b}}else g=d[h>>0]|0;if((g&255)<<24>>24!=(a[q>>0]|0))break f;g=c[e>>2]|0;h=g+12|0;j=c[h>>2]|0;if((j|0)==(c[g+16>>2]|0)){o=0;ka(c[(c[g>>2]|0)+40>>2]|0,g|0)|0;x=o;o=0;if(x&1){W=21;break b}}else c[h>>2]=j+1;q=q+1|0;g=a[aa>>0]|0;x=(g&1)==0;g=(x?B:c[A>>2]|0)+(x?(g&255)>>>1:c[C>>2]|0)|0;if((q|0)==(g|0)){q=g;break}else{j=m;h=r}}}while(0);if(z?(x=a[aa>>0]|0,w=(x&1)==0,(q|0)!=((w?B:c[A>>2]|0)+(w?(x&255)>>>1:c[C>>2]|0)|0)):0){W=143;break b}break}case 4:{s=a[V>>0]|0;m=x;j=x;q=0;g:while(1){g=c[e>>2]|0;do if(g){if((c[g+12>>2]|0)==(c[g+16>>2]|0)){o=0;g=ka(c[(c[g>>2]|0)+36>>2]|0,g|0)|0;x=o;o=0;if(x&1){W=23;break b}if((g|0)==-1){c[e>>2]=0;g=0;break}else{g=c[e>>2]|0;break}}}else g=0;while(0);h=(g|0)==0;do if(j){if((c[j+12>>2]|0)!=(c[j+16>>2]|0))if(h){r=m;break}else{h=m;break g}o=0;g=ka(c[(c[j>>2]|0)+36>>2]|0,j|0)|0;x=o;o=0;if(x&1){W=23;break b}if((g|0)!=-1)if(h^(m|0)==0){r=m;j=m;break}else{h=m;break g}else{c[f>>2]=0;m=0;W=156;break}}else W=156;while(0);if((W|0)==156){W=0;if(h){h=m;break}else{r=m;j=0}}m=c[e>>2]|0;g=c[m+12>>2]|0;if((g|0)==(c[m+16>>2]|0)){o=0;m=ka(c[(c[m>>2]|0)+36>>2]|0,m|0)|0;x=o;o=0;if(x&1){W=23;break b}}else m=d[g>>0]|0;g=m&255;if(g<<24>>24>-1?(b[(c[I>>2]|0)+(m<<24>>24<<1)>>1]&2048)!=0:0){m=c[p>>2]|0;if((m|0)==(c[P>>2]|0)){o=0;wa(12,n|0,p|0,P|0);x=o;o=0;if(x&1){W=23;break b}m=c[p>>2]|0}c[p>>2]=m+1;a[m>>0]=g;q=q+1|0}else{x=a[Y>>0]|0;if(!(g<<24>>24==s<<24>>24&((q|0)!=0?(((x&1)==0?(x&255)>>>1:c[H>>2]|0)|0)!=0:0))){h=r;break}if((u|0)==(c[S>>2]|0)){o=0;wa(13,da|0,T|0,S|0);x=o;o=0;if(x&1){W=23;break b}u=c[T>>2]|0}x=u+4|0;c[T>>2]=x;c[u>>2]=q;u=x;q=0}m=c[e>>2]|0;g=m+12|0;h=c[g>>2]|0;if((h|0)==(c[m+16>>2]|0)){o=0;ka(c[(c[m>>2]|0)+40>>2]|0,m|0)|0;x=o;o=0;if(x&1){W=23;break b}else{m=r;continue}}else{c[g>>2]=h+1;m=r;continue}}if((q|0)!=0?(c[da>>2]|0)!=(u|0):0){if((u|0)==(c[S>>2]|0)){o=0;wa(13,da|0,T|0,S|0);x=o;o=0;if(x&1){W=24;break b}u=c[T>>2]|0}x=u+4|0;c[T>>2]=x;c[u>>2]=q;u=x}r=c[R>>2]|0;if((r|0)>0){q=c[e>>2]|0;do if(q){if((c[q+12>>2]|0)==(c[q+16>>2]|0)){o=0;q=ka(c[(c[q>>2]|0)+36>>2]|0,q|0)|0;x=o;o=0;if(x&1){W=24;break b}if((q|0)==-1){c[e>>2]=0;q=0;break}else{q=c[e>>2]|0;break}}}else q=0;while(0);q=(q|0)==0;do if(h){if((c[h+12>>2]|0)==(c[h+16>>2]|0)){o=0;m=ka(c[(c[h>>2]|0)+36>>2]|0,h|0)|0;x=o;o=0;if(x&1){W=24;break b}if((m|0)==-1){c[f>>2]=0;W=193;break}}if(!q){W=198;break b}}else W=193;while(0);if((W|0)==193){W=0;if(q){W=198;break b}else h=0}q=c[e>>2]|0;m=c[q+12>>2]|0;if((m|0)==(c[q+16>>2]|0)){o=0;q=ka(c[(c[q>>2]|0)+36>>2]|0,q|0)|0;x=o;o=0;if(x&1){W=24;break b}}else q=d[m>>0]|0;if((q&255)<<24>>24!=(a[Q>>0]|0)){W=198;break b}q=c[e>>2]|0;m=q+12|0;g=c[m>>2]|0;if((g|0)==(c[q+16>>2]|0)){o=0;ka(c[(c[q>>2]|0)+40>>2]|0,q|0)|0;x=o;o=0;if(x&1){W=24;break b}}else c[m>>2]=g+1;if((r|0)>0){j=h;g=h;s=r;while(1){q=c[e>>2]|0;do if(q){if((c[q+12>>2]|0)==(c[q+16>>2]|0)){o=0;q=ka(c[(c[q>>2]|0)+36>>2]|0,q|0)|0;x=o;o=0;if(x&1){W=22;break b}if((q|0)==-1){c[e>>2]=0;q=0;break}else{q=c[e>>2]|0;break}}}else q=0;while(0);m=(q|0)==0;do if(g){if((c[g+12>>2]|0)!=(c[g+16>>2]|0))if(m){q=j;r=g;break}else{W=222;break b}o=0;q=ka(c[(c[g>>2]|0)+36>>2]|0,g|0)|0;x=o;o=0;if(x&1){W=22;break b}if((q|0)!=-1)if(m^(j|0)==0){q=j;r=j;break}else{W=222;break b}else{c[f>>2]=0;q=0;W=215;break}}else{q=j;W=215}while(0);if((W|0)==215){W=0;if(m){W=222;break b}else r=0}m=c[e>>2]|0;g=c[m+12>>2]|0;if((g|0)==(c[m+16>>2]|0)){o=0;m=ka(c[(c[m>>2]|0)+36>>2]|0,m|0)|0;x=o;o=0;if(x&1){W=22;break b}}else m=d[g>>0]|0;if((m&255)<<24>>24<=-1){W=222;break b}if(!(b[(c[I>>2]|0)+(m<<24>>24<<1)>>1]&2048)){W=222;break b}if((c[p>>2]|0)==(c[P>>2]|0)?(o=0,wa(12,n|0,p|0,P|0),x=o,o=0,x&1):0){W=22;break b}m=c[e>>2]|0;g=c[m+12>>2]|0;if((g|0)==(c[m+16>>2]|0)){o=0;m=ka(c[(c[m>>2]|0)+36>>2]|0,m|0)|0;x=o;o=0;if(x&1){W=22;break b}}else m=d[g>>0]|0;g=c[p>>2]|0;c[p>>2]=g+1;a[g>>0]=m;m=s;s=s+-1|0;c[R>>2]=s;g=c[e>>2]|0;h=g+12|0;j=c[h>>2]|0;if((j|0)==(c[g+16>>2]|0)){o=0;ka(c[(c[g>>2]|0)+40>>2]|0,g|0)|0;x=o;o=0;if(x&1){W=22;break b}}else c[h>>2]=j+1;if((m|0)<=1)break;else{j=q;g=r}}}}if((c[p>>2]|0)==(c[n>>2]|0)){W=233;break b}break}default:{}}while(0);h:do if((W|0)==42)while(1){W=0;m=c[e>>2]|0;do if(m){if((c[m+12>>2]|0)==(c[m+16>>2]|0)){o=0;m=ka(c[(c[m>>2]|0)+36>>2]|0,m|0)|0;x=o;o=0;if(x&1){W=20;break b}if((m|0)==-1){c[e>>2]=0;m=0;break}else{m=c[e>>2]|0;break}}}else m=0;while(0);g=(m|0)==0;do if(h){if((c[h+12>>2]|0)!=(c[h+16>>2]|0))if(g){j=q;break}else break h;o=0;m=ka(c[(c[h>>2]|0)+36>>2]|0,h|0)|0;x=o;o=0;if(x&1){W=20;break b}if((m|0)!=-1)if(g^(q|0)==0){j=q;h=q;break}else break h;else{c[f>>2]=0;q=0;W=54;break}}else W=54;while(0);if((W|0)==54){W=0;if(g)break h;else{j=q;h=0}}q=c[e>>2]|0;m=c[q+12>>2]|0;if((m|0)==(c[q+16>>2]|0)){o=0;q=ka(c[(c[q>>2]|0)+36>>2]|0,q|0)|0;x=o;o=0;if(x&1){W=20;break b}}else q=d[m>>0]|0;if((q&255)<<24>>24<=-1)break h;if(!(b[(c[I>>2]|0)+(q<<24>>24<<1)>>1]&8192))break h;q=c[e>>2]|0;m=q+12|0;g=c[m>>2]|0;if((g|0)==(c[q+16>>2]|0)){o=0;q=ka(c[(c[q>>2]|0)+40>>2]|0,q|0)|0;W=o;o=0;if(W&1){W=20;break b}}else{c[m>>2]=g+1;q=d[g>>0]|0}o=0;ia(67,$|0,q&255|0);W=o;o=0;if(W&1){W=20;break b}else{q=j;W=42}}while(0);y=y+1|0;if(y>>>0>=4){W=235;break}}i:switch(W|0){case 20:{m=Na()|0;break a}case 21:{m=Na()|0;break a}case 22:{m=Na()|0;break a}case 23:{m=Na()|0;break a}case 24:{m=Na()|0;break a}case 40:{c[k>>2]=c[k>>2]|4;m=0;break}case 104:{c[k>>2]=c[k>>2]|4;m=0;break}case 143:{c[k>>2]=c[k>>2]|4;m=0;break}case 198:{c[k>>2]=c[k>>2]|4;m=0;break}case 222:{c[k>>2]=c[k>>2]|4;m=0;break}case 233:{c[k>>2]=c[k>>2]|4;m=0;break}case 235:{j:do if(t){j=t+1|0;r=t+8|0;s=t+4|0;g=1;k:while(1){q=a[t>>0]|0;if(!(q&1))q=(q&255)>>>1;else q=c[s>>2]|0;if(g>>>0>=q>>>0)break j;q=c[e>>2]|0;do if(q){if((c[q+12>>2]|0)==(c[q+16>>2]|0)){o=0;q=ka(c[(c[q>>2]|0)+36>>2]|0,q|0)|0;p=o;o=0;if(p&1){W=19;break k}if((q|0)==-1){c[e>>2]=0;q=0;break}else{q=c[e>>2]|0;break}}}else q=0;while(0);m=(q|0)==0;q=c[f>>2]|0;do if(q){if((c[q+12>>2]|0)==(c[q+16>>2]|0)){o=0;q=ka(c[(c[q>>2]|0)+36>>2]|0,q|0)|0;p=o;o=0;if(p&1){W=19;break k}if((q|0)==-1){c[f>>2]=0;W=253;break}}if(!m){W=260;break k}}else W=253;while(0);if((W|0)==253?(W=0,m):0){W=260;break}q=c[e>>2]|0;m=c[q+12>>2]|0;if((m|0)==(c[q+16>>2]|0)){o=0;q=ka(c[(c[q>>2]|0)+36>>2]|0,q|0)|0;p=o;o=0;if(p&1){W=19;break}}else q=d[m>>0]|0;if(!(a[t>>0]&1))m=j;else m=c[r>>2]|0;if((q&255)<<24>>24!=(a[m+g>>0]|0)){W=260;break}q=g+1|0;m=c[e>>2]|0;g=m+12|0;h=c[g>>2]|0;if((h|0)==(c[m+16>>2]|0)){o=0;ka(c[(c[m>>2]|0)+40>>2]|0,m|0)|0;p=o;o=0;if(p&1){W=19;break}else{g=q;continue}}else{c[g>>2]=h+1;g=q;continue}}if((W|0)==19){m=Na()|0;break a}else if((W|0)==260){c[k>>2]=c[k>>2]|4;m=0;break i}}while(0);q=c[da>>2]|0;if((q|0)!=(u|0)?(c[X>>2]=0,Ur(Y,q,u,X),(c[X>>2]|0)!=0):0){c[k>>2]=c[k>>2]|4;m=0}else m=1;break}}Im($);Im(Z);Im(_);Im(aa);Im(Y);q=c[da>>2]|0;c[da>>2]=0;if((q|0)!=0?(o=0,ha(c[ca>>2]|0,q|0),da=o,o=0,da&1):0){da=Na(0)|0;ec(da)}i=ba;return m|0}while(0);Im($);Im(Z);Im(_);Im(aa);Im(Y);q=c[da>>2]|0;c[da>>2]=0;if((q|0)!=0?(o=0,ha(c[ca>>2]|0,q|0),da=o,o=0,da&1):0){da=Na(0)|0;ec(da)}Ya(m|0);return 0}function Rr(a){a=a|0;var b=0;b=Ma(8)|0;o=0;ia(90,b|0,a|0);a=o;o=0;if(a&1){a=Na()|0;La(b|0);Ya(a|0)}else lb(b|0,616,80)}function Sr(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;w=i;i=i+144|0;k=w+24|0;b=w+32|0;x=w+16|0;s=w+8|0;p=w+4|0;q=w+28|0;l=w;c[x>>2]=b;A=x+4|0;c[A>>2]=189;m=b+100|0;o=0;v=ka(68,g|0)|0;n=o;o=0;if(!(n&1)){c[p>>2]=v;o=0;n=ra(37,p|0,44220)|0;b=o;o=0;a:do if(!(b&1)?(a[q>>0]=0,t=c[e>>2]|0,c[l>>2]=t,r=c[g+4>>2]|0,u=t,o=0,c[k>>2]=c[l>>2],r=la(1,d|0,k|0,f|0,p|0,r|0,h|0,q|0,n|0,x|0,s|0,m|0)|0,g=o,o=0,!(g&1)):0){if(r){if(!(a[j>>0]&1)){a[j+1>>0]=0;a[j>>0]=0}else{a[c[j+8>>2]>>0]=0;c[j+4>>2]=0}if(a[q>>0]|0){o=0;b=ra(c[(c[n>>2]|0)+28>>2]|0,n|0,45)|0;g=o;o=0;if(g&1)break;o=0;ia(67,j|0,b|0);g=o;o=0;if(g&1)break}o=0;l=ra(c[(c[n>>2]|0)+28>>2]|0,n|0,48)|0;g=o;o=0;if(g&1)break;b=c[x>>2]|0;m=c[s>>2]|0;k=m+-1|0;b:do if(b>>>0<k>>>0)do{if((a[b>>0]|0)!=l<<24>>24)break b;b=b+1|0}while(b>>>0<k>>>0);while(0);o=0;ma(32,j|0,b|0,m|0)|0;j=o;o=0;if(j&1)break}b=c[d>>2]|0;do if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;b=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;j=o;o=0;if(j&1)break a;if((b|0)==-1){c[d>>2]=0;b=0;break}else{b=c[d>>2]|0;break}}}else b=0;while(0);k=(b|0)==0;do if(t){if((c[u+12>>2]|0)==(c[u+16>>2]|0)){o=0;b=ka(c[(c[t>>2]|0)+36>>2]|0,u|0)|0;u=o;o=0;if(u&1)break a;if((b|0)==-1){c[e>>2]=0;z=29;break}}if(!k)z=30}else z=29;while(0);if((z|0)==29?k:0)z=30;if((z|0)==30)c[h>>2]=c[h>>2]|2;k=c[d>>2]|0;pm(v)|0;b=c[x>>2]|0;c[x>>2]=0;if((b|0)!=0?(o=0,ha(c[A>>2]|0,b|0),A=o,o=0,A&1):0){A=Na(0)|0;ec(A)}i=w;return k|0}while(0);k=Na()|0;pm(v)|0;b=c[x>>2]|0;c[x>>2]=0;if(!b)y=k;else z=36}else{k=Na()|0;c[x>>2]=0;z=36}if((z|0)==36){o=0;ha(c[A>>2]|0,b|0);A=o;o=0;if(A&1){A=Na(0)|0;ec(A)}else y=k}Ya(y|0);return 0}function Tr(b,d,e,f,g,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;z=i;i=i+112|0;n=z+100|0;p=z+88|0;q=z+76|0;r=z+64|0;s=z+52|0;t=z+48|0;u=z+36|0;v=z+24|0;w=z+12|0;x=z;do if(b){b=Is(d,43828)|0;Cb[c[(c[b>>2]|0)+44>>2]&127](n,b);x=c[n>>2]|0;a[e>>0]=x;a[e+1>>0]=x>>8;a[e+2>>0]=x>>16;a[e+3>>0]=x>>24;Cb[c[(c[b>>2]|0)+32>>2]&127](p,b);if(!(a[l>>0]&1)){a[l+1>>0]=0;a[l>>0]=0}else{a[c[l+8>>2]>>0]=0;c[l+4>>2]=0}o=0;ia(91,l|0,0);e=o;o=0;if(e&1){e=Na(0)|0;ec(e)};c[l>>2]=c[p>>2];c[l+4>>2]=c[p+4>>2];c[l+8>>2]=c[p+8>>2];c[p>>2]=0;c[p+4>>2]=0;c[p+8>>2]=0;Im(p);Cb[c[(c[b>>2]|0)+28>>2]&127](q,b);if(!(a[k>>0]&1)){a[k+1>>0]=0;a[k>>0]=0}else{a[c[k+8>>2]>>0]=0;c[k+4>>2]=0}o=0;ia(91,k|0,0);e=o;o=0;if(e&1){e=Na(0)|0;ec(e)};c[k>>2]=c[q>>2];c[k+4>>2]=c[q+4>>2];c[k+8>>2]=c[q+8>>2];c[q>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;Im(q);a[f>>0]=Eb[c[(c[b>>2]|0)+12>>2]&127](b)|0;a[g>>0]=Eb[c[(c[b>>2]|0)+16>>2]&127](b)|0;Cb[c[(c[b>>2]|0)+20>>2]&127](r,b);if(!(a[h>>0]&1)){a[h+1>>0]=0;a[h>>0]=0}else{a[c[h+8>>2]>>0]=0;c[h+4>>2]=0}o=0;ia(91,h|0,0);g=o;o=0;if(g&1){g=Na(0)|0;ec(g)};c[h>>2]=c[r>>2];c[h+4>>2]=c[r+4>>2];c[h+8>>2]=c[r+8>>2];c[r>>2]=0;c[r+4>>2]=0;c[r+8>>2]=0;Im(r);Cb[c[(c[b>>2]|0)+24>>2]&127](s,b);if(!(a[j>>0]&1)){a[j+1>>0]=0;a[j>>0]=0}else{a[c[j+8>>2]>>0]=0;c[j+4>>2]=0}o=0;ia(91,j|0,0);g=o;o=0;if(g&1){g=Na(0)|0;ec(g)}else{c[j>>2]=c[s>>2];c[j+4>>2]=c[s+4>>2];c[j+8>>2]=c[s+8>>2];c[s>>2]=0;c[s+4>>2]=0;c[s+8>>2]=0;Im(s);y=Eb[c[(c[b>>2]|0)+36>>2]&127](b)|0;break}}else{b=Is(d,43764)|0;Cb[c[(c[b>>2]|0)+44>>2]&127](t,b);t=c[t>>2]|0;a[e>>0]=t;a[e+1>>0]=t>>8;a[e+2>>0]=t>>16;a[e+3>>0]=t>>24;Cb[c[(c[b>>2]|0)+32>>2]&127](u,b);if(!(a[l>>0]&1)){a[l+1>>0]=0;a[l>>0]=0}else{a[c[l+8>>2]>>0]=0;c[l+4>>2]=0}o=0;ia(91,l|0,0);e=o;o=0;if(e&1){e=Na(0)|0;ec(e)};c[l>>2]=c[u>>2];c[l+4>>2]=c[u+4>>2];c[l+8>>2]=c[u+8>>2];c[u>>2]=0;c[u+4>>2]=0;c[u+8>>2]=0;Im(u);Cb[c[(c[b>>2]|0)+28>>2]&127](v,b);if(!(a[k>>0]&1)){a[k+1>>0]=0;a[k>>0]=0}else{a[c[k+8>>2]>>0]=0;c[k+4>>2]=0}o=0;ia(91,k|0,0);e=o;o=0;if(e&1){e=Na(0)|0;ec(e)};c[k>>2]=c[v>>2];c[k+4>>2]=c[v+4>>2];c[k+8>>2]=c[v+8>>2];c[v>>2]=0;c[v+4>>2]=0;c[v+8>>2]=0;Im(v);a[f>>0]=Eb[c[(c[b>>2]|0)+12>>2]&127](b)|0;a[g>>0]=Eb[c[(c[b>>2]|0)+16>>2]&127](b)|0;Cb[c[(c[b>>2]|0)+20>>2]&127](w,b);if(!(a[h>>0]&1)){a[h+1>>0]=0;a[h>>0]=0}else{a[c[h+8>>2]>>0]=0;c[h+4>>2]=0}o=0;ia(91,h|0,0);g=o;o=0;if(g&1){g=Na(0)|0;ec(g)};c[h>>2]=c[w>>2];c[h+4>>2]=c[w+4>>2];c[h+8>>2]=c[w+8>>2];c[w>>2]=0;c[w+4>>2]=0;c[w+8>>2]=0;Im(w);Cb[c[(c[b>>2]|0)+24>>2]&127](x,b);if(!(a[j>>0]&1)){a[j+1>>0]=0;a[j>>0]=0}else{a[c[j+8>>2]>>0]=0;c[j+4>>2]=0}o=0;ia(91,j|0,0);g=o;o=0;if(g&1){g=Na(0)|0;ec(g)}else{c[j>>2]=c[x>>2];c[j+4>>2]=c[x+4>>2];c[j+8>>2]=c[x+8>>2];c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;Im(x);y=Eb[c[(c[b>>2]|0)+36>>2]&127](b)|0;break}}while(0);c[m>>2]=y;i=z;return}function Ur(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0;g=a[b>>0]|0;i=b+4|0;h=c[i>>2]|0;a:do if(((g&1)==0?(g&255)>>>1:h)|0){if((d|0)!=(e|0)){g=e+-4|0;if(g>>>0>d>>>0){h=d;do{j=c[h>>2]|0;c[h>>2]=c[g>>2];c[g>>2]=j;h=h+4|0;g=g+-4|0}while(h>>>0<g>>>0)}g=a[b>>0]|0;h=c[i>>2]|0}j=(g&1)==0;i=j?b+1|0:c[b+8>>2]|0;e=e+-4|0;b=i+(j?(g&255)>>>1:h)|0;h=a[i>>0]|0;g=h<<24>>24<1|h<<24>>24==127;b:do if(e>>>0>d>>>0){while(1){if(!g?(h<<24>>24|0)!=(c[d>>2]|0):0)break;i=(b-i|0)>1?i+1|0:i;d=d+4|0;h=a[i>>0]|0;g=h<<24>>24<1|h<<24>>24==127;if(d>>>0>=e>>>0)break b}c[f>>2]=4;break a}while(0);if(!g?((c[e>>2]|0)+-1|0)>>>0>=h<<24>>24>>>0:0)c[f>>2]=4}while(0);return}function Vr(a){a=a|0;return}function Wr(a){a=a|0;cj(a);return}function Xr(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0;B=i;i=i+576|0;x=B+424|0;A=B;b=B+24|0;D=B+16|0;y=B+12|0;C=B+8|0;p=B+464|0;l=B+4|0;z=B+468|0;c[D>>2]=b;F=D+4|0;c[F>>2]=189;m=b+400|0;o=0;k=ka(68,g|0)|0;w=o;o=0;if(!(w&1)){c[C>>2]=k;o=0;b=ra(37,C|0,44212)|0;w=o;o=0;a:do if(!(w&1)?(a[p>>0]=0,c[l>>2]=c[e>>2],n=c[g+4>>2]|0,o=0,c[x>>2]=c[l>>2],n=la(2,d|0,x|0,f|0,C|0,n|0,h|0,p|0,b|0,D|0,y|0,m|0)|0,w=o,o=0,!(w&1)):0){b:do if(n){o=0;va(c[(c[b>>2]|0)+48>>2]|0,b|0,59007,59017,x|0)|0;w=o;o=0;if(w&1){G=10;break a}l=c[y>>2]|0;m=c[D>>2]|0;b=l-m|0;if((b|0)>392){b=Fl((b>>2)+2|0)|0;k=b;if(!b){o=0;xa(6);w=o;o=0;if(!(w&1)){b=0;G=13}}else G=13}else{k=0;b=z;G=13}do if((G|0)==13){if(a[p>>0]|0){a[b>>0]=45;b=b+1|0}v=x+40|0;w=x;if(m>>>0<l>>>0){n=x+4|0;f=n+4|0;g=f+4|0;p=g+4|0;q=p+4|0;r=q+4|0;s=r+4|0;t=s+4|0;u=t+4|0;do{l=c[m>>2]|0;do if((c[x>>2]|0)!=(l|0))if((c[n>>2]|0)!=(l|0))if((c[f>>2]|0)!=(l|0))if((c[g>>2]|0)!=(l|0))if((c[p>>2]|0)==(l|0))l=p;else{if((c[q>>2]|0)==(l|0)){l=q;break}if((c[r>>2]|0)==(l|0)){l=r;break}if((c[s>>2]|0)==(l|0)){l=s;break}if((c[t>>2]|0)==(l|0)){l=t;break}l=(c[u>>2]|0)==(l|0)?u:v}else l=g;else l=f;else l=n;else l=x;while(0);a[b>>0]=a[59007+(l-w>>2)>>0]|0;m=m+4|0;b=b+1|0}while(m>>>0<(c[y>>2]|0)>>>0)}a[b>>0]=0;c[A>>2]=j;if(($k(z,58987,A)|0)!=1?(o=0,ha(190,58991),j=o,o=0,j&1):0)break;if(k)Gl(k);break b}while(0);b=Na()|0;if(!k){l=b;k=D;break a}Gl(k);l=b;k=D;break a}while(0);b=c[d>>2]|0;do if(b){k=c[b+12>>2]|0;if((k|0)==(c[b+16>>2]|0)){o=0;b=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;j=o;o=0;if(j&1){G=10;break a}}else b=c[k>>2]|0;if((b|0)==-1){c[d>>2]=0;l=1;break}else{l=(c[d>>2]|0)==0;break}}else l=1;while(0);b=c[e>>2]|0;do if(b){k=c[b+12>>2]|0;if((k|0)==(c[b+16>>2]|0)){o=0;b=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;j=o;o=0;if(j&1){G=10;break a}}else b=c[k>>2]|0;if((b|0)!=-1)if(l)break;else{G=40;break}else{c[e>>2]=0;G=38;break}}else G=38;while(0);if((G|0)==38?l:0)G=40;if((G|0)==40)c[h>>2]=c[h>>2]|2;k=c[d>>2]|0;pm(c[C>>2]|0)|0;b=c[D>>2]|0;c[D>>2]=0;if((b|0)!=0?(o=0,ha(c[F>>2]|0,b|0),G=o,o=0,G&1):0){G=Na(0)|0;ec(G)}i=B;return k|0}else G=10;while(0);if((G|0)==10){l=Na()|0;k=D}pm(c[C>>2]|0)|0;b=c[k>>2]|0;c[k>>2]=0;if(!b)E=l;else{k=c[F>>2]|0;G=47}}else{l=Na()|0;c[D>>2]=0;k=189;G=47}if((G|0)==47){o=0;ha(k|0,b|0);G=o;o=0;if(G&1){G=Na(0)|0;ec(G)}else E=l}Ya(E|0);return 0}function Yr(b,e,f,g,h,j,k,l,m,n,p){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;p=p|0;var q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0;Y=i;i=i+512|0;K=Y+96|0;q=Y+104|0;_=Y+88|0;O=Y+80|0;N=Y+76|0;P=Y+504|0;L=Y+72|0;Q=Y+68|0;T=Y+56|0;X=Y+44|0;V=Y+32|0;U=Y+20|0;W=Y+8|0;M=Y+4|0;S=Y;c[K>>2]=p;c[_>>2]=q;Z=_+4|0;c[Z>>2]=189;c[O>>2]=q;c[N>>2]=q+400;c[T>>2]=0;c[T+4>>2]=0;c[T+8>>2]=0;c[X>>2]=0;c[X+4>>2]=0;c[X+8>>2]=0;c[V>>2]=0;c[V+4>>2]=0;c[V+8>>2]=0;c[U>>2]=0;c[U+4>>2]=0;c[U+8>>2]=0;c[W>>2]=0;c[W+4>>2]=0;c[W+8>>2]=0;o=0;qa(2,f|0,g|0,P|0,L|0,Q|0,T|0,X|0,V|0,U|0,M|0);J=o;o=0;a:do if(J&1)f=Na()|0;else{c[n>>2]=c[m>>2];G=V+4|0;H=U+4|0;I=U+8|0;J=V+8|0;z=(h&512|0)!=0;A=X+8|0;B=X+4|0;C=W+4|0;D=W+8|0;E=P+3|0;F=T+4|0;y=0;s=0;b:while(1){p=c[b>>2]|0;do if(p){f=c[p+12>>2]|0;if((f|0)==(c[p+16>>2]|0)){o=0;p=ka(c[(c[p>>2]|0)+36>>2]|0,p|0)|0;x=o;o=0;if(x&1){R=26;break b}}else p=c[f>>2]|0;if((p|0)==-1){c[b>>2]=0;g=1;break}else{g=(c[b>>2]|0)==0;break}}else g=1;while(0);f=c[e>>2]|0;do if(f){p=c[f+12>>2]|0;if((p|0)==(c[f+16>>2]|0)){o=0;p=ka(c[(c[f>>2]|0)+36>>2]|0,f|0)|0;x=o;o=0;if(x&1){R=26;break b}}else p=c[p>>2]|0;if((p|0)!=-1)if(g){x=f;break}else{t=q;R=244;break b}else{c[e>>2]=0;R=16;break}}else R=16;while(0);if((R|0)==16){R=0;if(g){t=q;R=244;break}else x=0}c:do switch(a[P+y>>0]|0){case 1:{if((y|0)!=3){p=c[b>>2]|0;f=c[p+12>>2]|0;if((f|0)==(c[p+16>>2]|0)){o=0;p=ka(c[(c[p>>2]|0)+36>>2]|0,p|0)|0;R=o;o=0;if(R&1){R=26;break b}}else p=c[f>>2]|0;o=0;p=ma(c[(c[l>>2]|0)+12>>2]|0,l|0,8192,p|0)|0;R=o;o=0;if(R&1){R=26;break b}if(!p){R=42;break b}p=c[b>>2]|0;f=p+12|0;g=c[f>>2]|0;if((g|0)==(c[p+16>>2]|0)){o=0;p=ka(c[(c[p>>2]|0)+40>>2]|0,p|0)|0;R=o;o=0;if(R&1){R=26;break b}}else{c[f>>2]=g+4;p=c[g>>2]|0}o=0;ia(92,W|0,p|0);R=o;o=0;if(R&1){R=26;break b}else{p=x;h=x;R=44}}else p=q;break}case 0:{if((y|0)==3)p=q;else{p=x;h=x;R=44}break}case 3:{f=a[V>>0]|0;p=(f&1)==0?(f&255)>>>1:c[G>>2]|0;g=a[U>>0]|0;h=(g&1)==0?(g&255)>>>1:c[H>>2]|0;if((p|0)==(0-h|0))p=q;else{if(!p){p=c[b>>2]|0;f=c[p+12>>2]|0;if((f|0)==(c[p+16>>2]|0)){o=0;p=ka(c[(c[p>>2]|0)+36>>2]|0,p|0)|0;x=o;o=0;if(x&1){R=26;break b}f=a[U>>0]|0}else{p=c[f>>2]|0;f=g}if((p|0)!=(c[((f&1)==0?H:c[I>>2]|0)>>2]|0)){p=q;break c}p=c[b>>2]|0;f=p+12|0;g=c[f>>2]|0;if((g|0)==(c[p+16>>2]|0)){o=0;ka(c[(c[p>>2]|0)+40>>2]|0,p|0)|0;x=o;o=0;if(x&1){R=26;break b}}else c[f>>2]=g+4;a[k>>0]=1;x=a[U>>0]|0;p=q;s=((x&1)==0?(x&255)>>>1:c[H>>2]|0)>>>0>1?U:s;break c}r=c[b>>2]|0;t=c[r+12>>2]|0;g=c[r+16>>2]|0;p=(t|0)==(g|0);if(!h){if(p){o=0;p=ka(c[(c[r>>2]|0)+36>>2]|0,r|0)|0;x=o;o=0;if(x&1){R=26;break b}f=a[V>>0]|0}else p=c[t>>2]|0;if((p|0)!=(c[((f&1)==0?G:c[J>>2]|0)>>2]|0)){a[k>>0]=1;p=q;break c}p=c[b>>2]|0;f=p+12|0;g=c[f>>2]|0;if((g|0)==(c[p+16>>2]|0)){o=0;ka(c[(c[p>>2]|0)+40>>2]|0,p|0)|0;x=o;o=0;if(x&1){R=26;break b}}else c[f>>2]=g+4;x=a[V>>0]|0;p=q;s=((x&1)==0?(x&255)>>>1:c[G>>2]|0)>>>0>1?V:s;break c}if(p){o=0;p=ka(c[(c[r>>2]|0)+36>>2]|0,r|0)|0;x=o;o=0;if(x&1){R=26;break b}g=c[b>>2]|0;f=a[V>>0]|0;r=g;t=c[g+12>>2]|0;g=c[g+16>>2]|0}else p=c[t>>2]|0;h=r+12|0;g=(t|0)==(g|0);if((p|0)==(c[((f&1)==0?G:c[J>>2]|0)>>2]|0)){if(g){o=0;ka(c[(c[r>>2]|0)+40>>2]|0,r|0)|0;x=o;o=0;if(x&1){R=26;break b}}else c[h>>2]=t+4;x=a[V>>0]|0;p=q;s=((x&1)==0?(x&255)>>>1:c[G>>2]|0)>>>0>1?V:s;break c}if(g){o=0;p=ka(c[(c[r>>2]|0)+36>>2]|0,r|0)|0;x=o;o=0;if(x&1){R=26;break b}}else p=c[t>>2]|0;if((p|0)!=(c[((a[U>>0]&1)==0?H:c[I>>2]|0)>>2]|0)){R=107;break b}p=c[b>>2]|0;f=p+12|0;g=c[f>>2]|0;if((g|0)==(c[p+16>>2]|0)){o=0;ka(c[(c[p>>2]|0)+40>>2]|0,p|0)|0;x=o;o=0;if(x&1){R=26;break b}}else c[f>>2]=g+4;a[k>>0]=1;x=a[U>>0]|0;p=q;s=((x&1)==0?(x&255)>>>1:c[H>>2]|0)>>>0>1?U:s}break}case 2:{if(!(y>>>0<2|(s|0)!=0)?!(z|(y|0)==2&(a[E>>0]|0)!=0):0){p=q;s=0;break c}h=a[X>>0]|0;g=c[A>>2]|0;f=(h&1)==0?B:g;p=f;d:do if((y|0)!=0?(d[P+(y+-1)>>0]|0)<2:0){w=(h&1)==0;e:do if((f|0)!=((w?B:g)+((w?(h&255)>>>1:c[B>>2]|0)<<2)|0)){h=f;while(1){o=0;f=ma(c[(c[l>>2]|0)+12>>2]|0,l|0,8192,c[h>>2]|0)|0;w=o;o=0;if(w&1){R=23;break b}if(!f)break;h=h+4|0;p=h;f=a[X>>0]|0;g=c[A>>2]|0;w=(f&1)==0;if((h|0)==((w?B:g)+((w?(f&255)>>>1:c[B>>2]|0)<<2)|0)){h=f;break e}}h=a[X>>0]|0;g=c[A>>2]|0}while(0);t=(h&1)==0?B:g;f=t;u=p-f>>2;v=a[W>>0]|0;r=(v&1)==0;v=r?(v&255)>>>1:c[C>>2]|0;if(v>>>0>=u>>>0){r=r?C:c[D>>2]|0;w=r+(v<<2)|0;if(!u)f=p;else{r=r+(v-u<<2)|0;while(1){if((c[r>>2]|0)!=(c[t>>2]|0))break d;r=r+4|0;if((r|0)==(w|0)){f=p;break}else t=t+4|0}}}}else f=p;while(0);p=(h&1)==0;p=(p?B:g)+((p?(h&255)>>>1:c[B>>2]|0)<<2)|0;f:do if((f|0)!=(p|0)){r=x;h=x;p=f;while(1){f=c[b>>2]|0;do if(f){g=c[f+12>>2]|0;if((g|0)==(c[f+16>>2]|0)){o=0;f=ka(c[(c[f>>2]|0)+36>>2]|0,f|0)|0;x=o;o=0;if(x&1){R=22;break b}}else f=c[g>>2]|0;if((f|0)==-1){c[b>>2]=0;g=1;break}else{g=(c[b>>2]|0)==0;break}}else g=1;while(0);do if(h){f=c[h+12>>2]|0;if((f|0)==(c[h+16>>2]|0)){o=0;f=ka(c[(c[h>>2]|0)+36>>2]|0,h|0)|0;x=o;o=0;if(x&1){R=22;break b}}else f=c[f>>2]|0;if((f|0)!=-1)if(g^(r|0)==0){f=r;t=r;break}else break f;else{c[e>>2]=0;f=0;R=136;break}}else{f=r;R=136}while(0);if((R|0)==136){R=0;if(g)break f;else t=0}g=c[b>>2]|0;h=c[g+12>>2]|0;if((h|0)==(c[g+16>>2]|0)){o=0;g=ka(c[(c[g>>2]|0)+36>>2]|0,g|0)|0;x=o;o=0;if(x&1){R=22;break b}}else g=c[h>>2]|0;if((g|0)!=(c[p>>2]|0))break f;g=c[b>>2]|0;h=g+12|0;r=c[h>>2]|0;if((r|0)==(c[g+16>>2]|0)){o=0;ka(c[(c[g>>2]|0)+40>>2]|0,g|0)|0;x=o;o=0;if(x&1){R=22;break b}}else c[h>>2]=r+4;p=p+4|0;g=a[X>>0]|0;x=(g&1)==0;g=(x?B:c[A>>2]|0)+((x?(g&255)>>>1:c[B>>2]|0)<<2)|0;if((p|0)==(g|0)){p=g;break}else{r=f;h=t}}}while(0);if(z?(x=a[X>>0]|0,w=(x&1)==0,(p|0)!=((w?B:c[A>>2]|0)+((w?(x&255)>>>1:c[B>>2]|0)<<2)|0)):0){R=148;break b}else p=q;break}case 4:{v=c[Q>>2]|0;u=x;r=x;p=q;f=0;g:while(1){g=c[b>>2]|0;do if(g){h=c[g+12>>2]|0;if((h|0)==(c[g+16>>2]|0)){o=0;g=ka(c[(c[g>>2]|0)+36>>2]|0,g|0)|0;x=o;o=0;if(x&1){R=25;break b}}else g=c[h>>2]|0;if((g|0)==-1){c[b>>2]=0;h=1;break}else{h=(c[b>>2]|0)==0;break}}else h=1;while(0);do if(r){g=c[r+12>>2]|0;if((g|0)==(c[r+16>>2]|0)){o=0;g=ka(c[(c[r>>2]|0)+36>>2]|0,r|0)|0;x=o;o=0;if(x&1){R=25;break b}}else g=c[g>>2]|0;if((g|0)!=-1)if(h^(u|0)==0){g=u;t=u;break}else{q=u;break g}else{c[e>>2]=0;g=0;R=162;break}}else{g=u;R=162}while(0);if((R|0)==162){R=0;if(h){q=g;break}else t=0}h=c[b>>2]|0;q=c[h+12>>2]|0;if((q|0)==(c[h+16>>2]|0)){o=0;h=ka(c[(c[h>>2]|0)+36>>2]|0,h|0)|0;x=o;o=0;if(x&1){R=25;break b}}else h=c[q>>2]|0;o=0;q=ma(c[(c[l>>2]|0)+12>>2]|0,l|0,2048,h|0)|0;x=o;o=0;if(x&1){R=25;break b}if(q){q=c[n>>2]|0;if((q|0)==(c[K>>2]|0)){o=0;wa(14,m|0,n|0,K|0);x=o;o=0;if(x&1){R=25;break b}q=c[n>>2]|0}c[n>>2]=q+4;c[q>>2]=h;f=f+1|0}else{x=a[T>>0]|0;if(!((h|0)==(v|0)&((f|0)!=0?(((x&1)==0?(x&255)>>>1:c[F>>2]|0)|0)!=0:0))){q=g;break}if((p|0)==(c[N>>2]|0)){o=0;wa(13,_|0,O|0,N|0);x=o;o=0;if(x&1){R=25;break b}p=c[O>>2]|0}x=p+4|0;c[O>>2]=x;c[p>>2]=f;p=x;f=0}h=c[b>>2]|0;q=h+12|0;r=c[q>>2]|0;if((r|0)==(c[h+16>>2]|0)){o=0;ka(c[(c[h>>2]|0)+40>>2]|0,h|0)|0;x=o;o=0;if(x&1){R=25;break b}else{u=g;r=t;continue}}else{c[q>>2]=r+4;u=g;r=t;continue}}if((f|0)!=0?(c[_>>2]|0)!=(p|0):0){if((p|0)==(c[N>>2]|0)){o=0;wa(13,_|0,O|0,N|0);x=o;o=0;if(x&1){R=26;break b}p=c[O>>2]|0}x=p+4|0;c[O>>2]=x;c[p>>2]=f;p=x}t=c[M>>2]|0;if((t|0)>0){f=c[b>>2]|0;do if(f){g=c[f+12>>2]|0;if((g|0)==(c[f+16>>2]|0)){o=0;f=ka(c[(c[f>>2]|0)+36>>2]|0,f|0)|0;x=o;o=0;if(x&1){R=26;break b}}else f=c[g>>2]|0;if((f|0)==-1){c[b>>2]=0;g=1;break}else{g=(c[b>>2]|0)==0;break}}else g=1;while(0);do if(q){f=c[q+12>>2]|0;if((f|0)==(c[q+16>>2]|0)){o=0;f=ka(c[(c[q>>2]|0)+36>>2]|0,q|0)|0;x=o;o=0;if(x&1){R=26;break b}}else f=c[f>>2]|0;if((f|0)!=-1)if(g)break;else{R=206;break b}else{c[e>>2]=0;R=200;break}}else R=200;while(0);if((R|0)==200){R=0;if(g){R=206;break b}else q=0}f=c[b>>2]|0;g=c[f+12>>2]|0;if((g|0)==(c[f+16>>2]|0)){o=0;f=ka(c[(c[f>>2]|0)+36>>2]|0,f|0)|0;x=o;o=0;if(x&1){R=26;break b}}else f=c[g>>2]|0;if((f|0)!=(c[L>>2]|0)){R=206;break b}f=c[b>>2]|0;g=f+12|0;h=c[g>>2]|0;if((h|0)==(c[f+16>>2]|0)){o=0;ka(c[(c[f>>2]|0)+40>>2]|0,f|0)|0;x=o;o=0;if(x&1){R=26;break b}}else c[g>>2]=h+4;if((t|0)>0){r=q;h=q;u=t;while(1){f=c[b>>2]|0;do if(f){g=c[f+12>>2]|0;if((g|0)==(c[f+16>>2]|0)){o=0;f=ka(c[(c[f>>2]|0)+36>>2]|0,f|0)|0;x=o;o=0;if(x&1){R=24;break b}}else f=c[g>>2]|0;if((f|0)==-1){c[b>>2]=0;g=1;break}else{g=(c[b>>2]|0)==0;break}}else g=1;while(0);do if(h){f=c[h+12>>2]|0;if((f|0)==(c[h+16>>2]|0)){o=0;f=ka(c[(c[h>>2]|0)+36>>2]|0,h|0)|0;x=o;o=0;if(x&1){R=24;break b}}else f=c[f>>2]|0;if((f|0)!=-1)if(g^(r|0)==0){f=r;t=r;break}else{R=231;break b}else{c[e>>2]=0;f=0;R=224;break}}else{f=r;R=224}while(0);if((R|0)==224){R=0;if(g){R=231;break b}else t=0}g=c[b>>2]|0;h=c[g+12>>2]|0;if((h|0)==(c[g+16>>2]|0)){o=0;g=ka(c[(c[g>>2]|0)+36>>2]|0,g|0)|0;x=o;o=0;if(x&1){R=24;break b}}else g=c[h>>2]|0;o=0;g=ma(c[(c[l>>2]|0)+12>>2]|0,l|0,2048,g|0)|0;x=o;o=0;if(x&1){R=24;break b}if(!g){R=231;break b}if((c[n>>2]|0)==(c[K>>2]|0)?(o=0,wa(14,m|0,n|0,K|0),x=o,o=0,x&1):0){R=24;break b}g=c[b>>2]|0;h=c[g+12>>2]|0;if((h|0)==(c[g+16>>2]|0)){o=0;g=ka(c[(c[g>>2]|0)+36>>2]|0,g|0)|0;x=o;o=0;if(x&1){R=24;break b}}else g=c[h>>2]|0;h=c[n>>2]|0;c[n>>2]=h+4;c[h>>2]=g;g=u;u=u+-1|0;c[M>>2]=u;h=c[b>>2]|0;q=h+12|0;r=c[q>>2]|0;if((r|0)==(c[h+16>>2]|0)){o=0;ka(c[(c[h>>2]|0)+40>>2]|0,h|0)|0;x=o;o=0;if(x&1){R=24;break b}}else c[q>>2]=r+4;if((g|0)<=1)break;else{r=f;h=t}}}}if((c[n>>2]|0)==(c[m>>2]|0)){R=242;break b}break}default:p=q}while(0);h:do if((R|0)==44)while(1){R=0;f=c[b>>2]|0;do if(f){g=c[f+12>>2]|0;if((g|0)==(c[f+16>>2]|0)){o=0;f=ka(c[(c[f>>2]|0)+36>>2]|0,f|0)|0;x=o;o=0;if(x&1){R=21;break b}}else f=c[g>>2]|0;if((f|0)==-1){c[b>>2]=0;g=1;break}else{g=(c[b>>2]|0)==0;break}}else g=1;while(0);do if(h){f=c[h+12>>2]|0;if((f|0)==(c[h+16>>2]|0)){o=0;f=ka(c[(c[h>>2]|0)+36>>2]|0,h|0)|0;x=o;o=0;if(x&1){R=21;break b}}else f=c[f>>2]|0;if((f|0)!=-1)if(g^(p|0)==0){r=p;h=p;break}else{p=q;break h}else{c[e>>2]=0;p=0;R=57;break}}else R=57;while(0);if((R|0)==57){R=0;if(g){p=q;break h}else{r=p;h=0}}p=c[b>>2]|0;f=c[p+12>>2]|0;if((f|0)==(c[p+16>>2]|0)){o=0;p=ka(c[(c[p>>2]|0)+36>>2]|0,p|0)|0;x=o;o=0;if(x&1){R=21;break b}}else p=c[f>>2]|0;o=0;p=ma(c[(c[l>>2]|0)+12>>2]|0,l|0,8192,p|0)|0;x=o;o=0;if(x&1){R=21;break b}if(!p){p=q;break h}p=c[b>>2]|0;f=p+12|0;g=c[f>>2]|0;if((g|0)==(c[p+16>>2]|0)){o=0;p=ka(c[(c[p>>2]|0)+40>>2]|0,p|0)|0;R=o;o=0;if(R&1){R=21;break b}}else{c[f>>2]=g+4;p=c[g>>2]|0}o=0;ia(92,W|0,p|0);R=o;o=0;if(R&1){R=21;break b}else{p=r;R=44}}while(0);y=y+1|0;if(y>>>0>=4){t=p;R=244;break}else q=p}i:switch(R|0){case 21:{f=Na()|0;break a}case 22:{f=Na()|0;break a}case 23:{f=Na()|0;break a}case 24:{f=Na()|0;break a}case 25:{f=Na()|0;break a}case 26:{f=Na()|0;break a}case 42:{c[j>>2]=c[j>>2]|4;f=0;break}case 107:{c[j>>2]=c[j>>2]|4;f=0;break}case 148:{c[j>>2]=c[j>>2]|4;f=0;break}case 206:{c[j>>2]=c[j>>2]|4;f=0;break}case 231:{c[j>>2]=c[j>>2]|4;f=0;break}case 242:{c[j>>2]=c[j>>2]|4;f=0;break}case 244:{j:do if(s){q=s+4|0;r=s+8|0;h=1;k:while(1){p=a[s>>0]|0;if(!(p&1))p=(p&255)>>>1;else p=c[q>>2]|0;if(h>>>0>=p>>>0)break j;p=c[b>>2]|0;do if(p){f=c[p+12>>2]|0;if((f|0)==(c[p+16>>2]|0)){o=0;p=ka(c[(c[p>>2]|0)+36>>2]|0,p|0)|0;n=o;o=0;if(n&1){R=20;break k}}else p=c[f>>2]|0;if((p|0)==-1){c[b>>2]=0;g=1;break}else{g=(c[b>>2]|0)==0;break}}else g=1;while(0);p=c[e>>2]|0;do if(p){f=c[p+12>>2]|0;if((f|0)==(c[p+16>>2]|0)){o=0;p=ka(c[(c[p>>2]|0)+36>>2]|0,p|0)|0;n=o;o=0;if(n&1){R=20;break k}}else p=c[f>>2]|0;if((p|0)!=-1)if(g)break;else{R=271;break k}else{c[e>>2]=0;R=263;break}}else R=263;while(0);if((R|0)==263?(R=0,g):0){R=271;break}p=c[b>>2]|0;f=c[p+12>>2]|0;if((f|0)==(c[p+16>>2]|0)){o=0;p=ka(c[(c[p>>2]|0)+36>>2]|0,p|0)|0;n=o;o=0;if(n&1){R=20;break}}else p=c[f>>2]|0;if(!(a[s>>0]&1))f=q;else f=c[r>>2]|0;if((p|0)!=(c[f+(h<<2)>>2]|0)){R=271;break}p=h+1|0;f=c[b>>2]|0;g=f+12|0;h=c[g>>2]|0;if((h|0)==(c[f+16>>2]|0)){o=0;ka(c[(c[f>>2]|0)+40>>2]|0,f|0)|0;n=o;o=0;if(n&1){R=20;break}else{h=p;continue}}else{c[g>>2]=h+4;h=p;continue}}if((R|0)==20){f=Na()|0;break a}else if((R|0)==271){c[j>>2]=c[j>>2]|4;f=0;break i}}while(0);p=c[_>>2]|0;if((p|0)!=(t|0)?(c[S>>2]=0,Ur(T,p,t,S),(c[S>>2]|0)!=0):0){c[j>>2]=c[j>>2]|4;f=0}else f=1;break}}Wm(W);Wm(U);Wm(V);Wm(X);Im(T);p=c[_>>2]|0;c[_>>2]=0;if((p|0)!=0?(o=0,ha(c[Z>>2]|0,p|0),_=o,o=0,_&1):0){_=Na(0)|0;ec(_)}i=Y;return f|0}while(0);Wm(W);Wm(U);Wm(V);Wm(X);Im(T);p=c[_>>2]|0;c[_>>2]=0;if((p|0)!=0?(o=0,ha(c[Z>>2]|0,p|0),_=o,o=0,_&1):0){_=Na(0)|0;ec(_)}Ya(f|0);return 0}function Zr(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;w=i;i=i+432|0;k=w+424|0;b=w+24|0;y=w+16|0;s=w+8|0;p=w+4|0;q=w+428|0;l=w;c[y>>2]=b;A=y+4|0;c[A>>2]=189;m=b+400|0;o=0;v=ka(68,g|0)|0;n=o;o=0;if(!(n&1)){c[p>>2]=v;o=0;n=ra(37,p|0,44212)|0;b=o;o=0;a:do if(!(b&1)?(a[q>>0]=0,t=c[e>>2]|0,c[l>>2]=t,r=c[g+4>>2]|0,u=t,o=0,c[k>>2]=c[l>>2],r=la(2,d|0,k|0,f|0,p|0,r|0,h|0,q|0,n|0,y|0,s|0,m|0)|0,g=o,o=0,!(g&1)):0){if(r){if(!(a[j>>0]&1))a[j>>0]=0;else c[c[j+8>>2]>>2]=0;c[j+4>>2]=0;if(a[q>>0]|0){o=0;b=ra(c[(c[n>>2]|0)+44>>2]|0,n|0,45)|0;g=o;o=0;if(g&1)break;o=0;ia(92,j|0,b|0);g=o;o=0;if(g&1)break}o=0;l=ra(c[(c[n>>2]|0)+44>>2]|0,n|0,48)|0;g=o;o=0;if(g&1)break;b=c[y>>2]|0;m=c[s>>2]|0;k=m+-4|0;b:do if(b>>>0<k>>>0)do{if((c[b>>2]|0)!=(l|0))break b;b=b+4|0}while(b>>>0<k>>>0);while(0);o=0;ma(33,j|0,b|0,m|0)|0;j=o;o=0;if(j&1)break}b=c[d>>2]|0;do if(b){k=c[b+12>>2]|0;if((k|0)==(c[b+16>>2]|0)){o=0;b=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;j=o;o=0;if(j&1)break a}else b=c[k>>2]|0;if((b|0)==-1){c[d>>2]=0;k=1;break}else{k=(c[d>>2]|0)==0;break}}else k=1;while(0);do if(t){b=c[u+12>>2]|0;if((b|0)==(c[u+16>>2]|0)){o=0;b=ka(c[(c[t>>2]|0)+36>>2]|0,u|0)|0;u=o;o=0;if(u&1)break a}else b=c[b>>2]|0;if((b|0)!=-1)if(k)break;else{z=32;break}else{c[e>>2]=0;z=30;break}}else z=30;while(0);if((z|0)==30?k:0)z=32;if((z|0)==32)c[h>>2]=c[h>>2]|2;k=c[d>>2]|0;pm(v)|0;b=c[y>>2]|0;c[y>>2]=0;if((b|0)!=0?(o=0,ha(c[A>>2]|0,b|0),A=o,o=0,A&1):0){A=Na(0)|0;ec(A)}i=w;return k|0}while(0);k=Na()|0;pm(v)|0;b=c[y>>2]|0;c[y>>2]=0;if(!b)x=k;else z=38}else{k=Na()|0;c[y>>2]=0;z=38}if((z|0)==38){o=0;ha(c[A>>2]|0,b|0);A=o;o=0;if(A&1){A=Na(0)|0;ec(A)}else x=k}Ya(x|0);return 0}function _r(b,d,e,f,g,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;z=i;i=i+112|0;n=z+100|0;p=z+88|0;q=z+76|0;r=z+64|0;s=z+52|0;t=z+48|0;u=z+36|0;v=z+24|0;w=z+12|0;x=z;do if(b){b=Is(d,43956)|0;Cb[c[(c[b>>2]|0)+44>>2]&127](n,b);x=c[n>>2]|0;a[e>>0]=x;a[e+1>>0]=x>>8;a[e+2>>0]=x>>16;a[e+3>>0]=x>>24;Cb[c[(c[b>>2]|0)+32>>2]&127](p,b);if(!(a[l>>0]&1))a[l>>0]=0;else c[c[l+8>>2]>>2]=0;c[l+4>>2]=0;o=0;ia(93,l|0,0);e=o;o=0;if(e&1){e=Na(0)|0;ec(e)};c[l>>2]=c[p>>2];c[l+4>>2]=c[p+4>>2];c[l+8>>2]=c[p+8>>2];c[p>>2]=0;c[p+4>>2]=0;c[p+8>>2]=0;Wm(p);Cb[c[(c[b>>2]|0)+28>>2]&127](q,b);if(!(a[k>>0]&1))a[k>>0]=0;else c[c[k+8>>2]>>2]=0;c[k+4>>2]=0;o=0;ia(93,k|0,0);e=o;o=0;if(e&1){e=Na(0)|0;ec(e)};c[k>>2]=c[q>>2];c[k+4>>2]=c[q+4>>2];c[k+8>>2]=c[q+8>>2];c[q>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;Wm(q);c[f>>2]=Eb[c[(c[b>>2]|0)+12>>2]&127](b)|0;c[g>>2]=Eb[c[(c[b>>2]|0)+16>>2]&127](b)|0;Cb[c[(c[b>>2]|0)+20>>2]&127](r,b);if(!(a[h>>0]&1)){a[h+1>>0]=0;a[h>>0]=0}else{a[c[h+8>>2]>>0]=0;c[h+4>>2]=0}o=0;ia(91,h|0,0);g=o;o=0;if(g&1){g=Na(0)|0;ec(g)};c[h>>2]=c[r>>2];c[h+4>>2]=c[r+4>>2];c[h+8>>2]=c[r+8>>2];c[r>>2]=0;c[r+4>>2]=0;c[r+8>>2]=0;Im(r);Cb[c[(c[b>>2]|0)+24>>2]&127](s,b);if(!(a[j>>0]&1))a[j>>0]=0;else c[c[j+8>>2]>>2]=0;c[j+4>>2]=0;o=0;ia(93,j|0,0);g=o;o=0;if(g&1){g=Na(0)|0;ec(g)}else{c[j>>2]=c[s>>2];c[j+4>>2]=c[s+4>>2];c[j+8>>2]=c[s+8>>2];c[s>>2]=0;c[s+4>>2]=0;c[s+8>>2]=0;Wm(s);y=Eb[c[(c[b>>2]|0)+36>>2]&127](b)|0;break}}else{b=Is(d,43892)|0;Cb[c[(c[b>>2]|0)+44>>2]&127](t,b);t=c[t>>2]|0;a[e>>0]=t;a[e+1>>0]=t>>8;a[e+2>>0]=t>>16;a[e+3>>0]=t>>24;Cb[c[(c[b>>2]|0)+32>>2]&127](u,b);if(!(a[l>>0]&1))a[l>>0]=0;else c[c[l+8>>2]>>2]=0;c[l+4>>2]=0;o=0;ia(93,l|0,0);e=o;o=0;if(e&1){e=Na(0)|0;ec(e)};c[l>>2]=c[u>>2];c[l+4>>2]=c[u+4>>2];c[l+8>>2]=c[u+8>>2];c[u>>2]=0;c[u+4>>2]=0;c[u+8>>2]=0;Wm(u);Cb[c[(c[b>>2]|0)+28>>2]&127](v,b);if(!(a[k>>0]&1))a[k>>0]=0;else c[c[k+8>>2]>>2]=0;c[k+4>>2]=0;o=0;ia(93,k|0,0);e=o;o=0;if(e&1){e=Na(0)|0;ec(e)};c[k>>2]=c[v>>2];c[k+4>>2]=c[v+4>>2];c[k+8>>2]=c[v+8>>2];c[v>>2]=0;c[v+4>>2]=0;c[v+8>>2]=0;Wm(v);c[f>>2]=Eb[c[(c[b>>2]|0)+12>>2]&127](b)|0;c[g>>2]=Eb[c[(c[b>>2]|0)+16>>2]&127](b)|0;Cb[c[(c[b>>2]|0)+20>>2]&127](w,b);if(!(a[h>>0]&1)){a[h+1>>0]=0;a[h>>0]=0}else{a[c[h+8>>2]>>0]=0;c[h+4>>2]=0}o=0;ia(91,h|0,0);g=o;o=0;if(g&1){g=Na(0)|0;ec(g)};c[h>>2]=c[w>>2];c[h+4>>2]=c[w+4>>2];c[h+8>>2]=c[w+8>>2];c[w>>2]=0;c[w+4>>2]=0;c[w+8>>2]=0;Im(w);Cb[c[(c[b>>2]|0)+24>>2]&127](x,b);if(!(a[j>>0]&1))a[j>>0]=0;else c[c[j+8>>2]>>2]=0;c[j+4>>2]=0;o=0;ia(93,j|0,0);g=o;o=0;if(g&1){g=Na(0)|0;ec(g)}else{c[j>>2]=c[x>>2];c[j+4>>2]=c[x+4>>2];c[j+8>>2]=c[x+8>>2];c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;Wm(x);y=Eb[c[(c[b>>2]|0)+36>>2]&127](b)|0;break}}while(0);c[m>>2]=y;i=z;return}function $r(a){a=a|0;return}function as(a){a=a|0;cj(a);return}function bs(b,d,e,f,g,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;j=+j;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0;D=i;i=i+384|0;v=D+8|0;k=D;m=D+284|0;n=D+72|0;l=D+184|0;F=D+68|0;A=D+80|0;x=D+77|0;B=D+76|0;G=D+56|0;I=D+44|0;H=D+32|0;p=D+28|0;u=D+84|0;z=D+24|0;y=D+20|0;w=D+16|0;c[n>>2]=m;h[v>>3]=j;m=_k(m,100,59018,v)|0;do if(m>>>0>99){o=0;b=ua(3)|0;C=o;o=0;if(!(C&1)?(o=0,h[k>>3]=j,s=va(17,n|0,b|0,59018,k|0)|0,C=o,o=0,!(C&1)):0){b=c[n>>2]|0;if(!b){o=0;xa(6);C=o;o=0;if(C&1){b=0;k=0;C=7;break}b=c[n>>2]|0}l=Fl(s)|0;k=l;if(!l){o=0;xa(6);C=o;o=0;if(C&1)C=7;else{t=0;C=10}}else{t=l;C=10}}else{b=0;k=0;C=7}}else{k=0;b=0;t=l;s=m;C=10}while(0);if((C|0)==10){o=0;l=ka(68,f|0)|0;r=o;o=0;if(r&1)C=7;else{c[F>>2]=l;o=0;r=ra(37,F|0,44220)|0;q=o;o=0;if(!(q&1)?(q=c[n>>2]|0,o=0,va(c[(c[r>>2]|0)+32>>2]|0,r|0,q|0,q+s|0,t|0)|0,q=o,o=0,!(q&1)):0){if(!s)q=0;else q=(a[c[n>>2]>>0]|0)==45;c[G>>2]=0;c[G+4>>2]=0;c[G+8>>2]=0;c[I>>2]=0;c[I+4>>2]=0;c[I+8>>2]=0;c[H>>2]=0;c[H+4>>2]=0;c[H+8>>2]=0;o=0;qa(3,e|0,q|0,F|0,A|0,x|0,B|0,G|0,I|0,H|0,p|0);e=o;o=0;if(!(e&1)){p=c[p>>2]|0;if((s|0)>(p|0)){e=a[H>>0]|0;m=a[I>>0]|0;m=(s-p<<1|1)+p+((e&1)==0?(e&255)>>>1:c[H+4>>2]|0)+((m&1)==0?(m&255)>>>1:c[I+4>>2]|0)|0}else{e=a[H>>0]|0;m=a[I>>0]|0;m=p+2+((e&1)==0?(e&255)>>>1:c[H+4>>2]|0)+((m&1)==0?(m&255)>>>1:c[I+4>>2]|0)|0}if(m>>>0>100){m=Fl(m)|0;n=m;if(!m){o=0;xa(6);u=o;o=0;if(!(u&1)){m=0;C=26}}else C=26}else{n=0;m=u;C=26}if((C|0)==26){o=0;na(1,m|0,z|0,y|0,c[f+4>>2]|0,t|0,t+s|0,r|0,q|0,A|0,a[x>>0]|0,a[B>>0]|0,G|0,I|0,H|0,p|0);B=o;o=0;if(!(B&1)?(c[w>>2]=c[d>>2],d=c[z>>2]|0,E=c[y>>2]|0,o=0,c[v>>2]=c[w>>2],E=ja(39,v|0,m|0,d|0,E|0,f|0,g|0)|0,d=o,o=0,!(d&1)):0){if(n){Gl(n);l=c[F>>2]|0}Im(H);Im(I);Im(G);pm(l)|0;if(k)Gl(k);if(b)Gl(b);i=D;return E|0}}m=Na()|0;if(n){Gl(n);l=c[F>>2]|0}}else m=Na()|0;Im(H);Im(I);Im(G)}else m=Na()|0;pm(l)|0}}if((C|0)==7)m=Na()|0;if(k)Gl(k);if(b)Gl(b);Ya(m|0);return 0}function cs(b,d,e,f,g,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;D=i;i=i+112|0;q=D+108|0;r=D+96|0;u=D+92|0;v=D+80|0;w=D+68|0;x=D+56|0;y=D+52|0;z=D+40|0;A=D+36|0;B=D+24|0;s=D+12|0;t=D;do if(b){b=Is(e,43828)|0;e=c[b>>2]|0;do if(d){Cb[c[e+44>>2]&127](q,b);d=c[q>>2]|0;a[f>>0]=d;a[f+1>>0]=d>>8;a[f+2>>0]=d>>16;a[f+3>>0]=d>>24;Cb[c[(c[b>>2]|0)+32>>2]&127](r,b);if(!(a[l>>0]&1)){a[l+1>>0]=0;a[l>>0]=0}else{a[c[l+8>>2]>>0]=0;c[l+4>>2]=0}o=0;ia(91,l|0,0);f=o;o=0;if(f&1){l=Na(0)|0;ec(l)}else{c[l>>2]=c[r>>2];c[l+4>>2]=c[r+4>>2];c[l+8>>2]=c[r+8>>2];c[r>>2]=0;c[r+4>>2]=0;c[r+8>>2]=0;Im(r);p=b;break}}else{Cb[c[e+40>>2]&127](u,b);d=c[u>>2]|0;a[f>>0]=d;a[f+1>>0]=d>>8;a[f+2>>0]=d>>16;a[f+3>>0]=d>>24;Cb[c[(c[b>>2]|0)+28>>2]&127](v,b);if(!(a[l>>0]&1)){a[l+1>>0]=0;a[l>>0]=0}else{a[c[l+8>>2]>>0]=0;c[l+4>>2]=0}o=0;ia(91,l|0,0);f=o;o=0;if(f&1){l=Na(0)|0;ec(l)}else{c[l>>2]=c[v>>2];c[l+4>>2]=c[v+4>>2];c[l+8>>2]=c[v+8>>2];c[v>>2]=0;c[v+4>>2]=0;c[v+8>>2]=0;Im(v);p=b;break}}while(0);a[g>>0]=Eb[c[(c[b>>2]|0)+12>>2]&127](b)|0;a[h>>0]=Eb[c[(c[b>>2]|0)+16>>2]&127](b)|0;Cb[c[(c[p>>2]|0)+20>>2]&127](w,b);if(!(a[j>>0]&1)){a[j+1>>0]=0;a[j>>0]=0}else{a[c[j+8>>2]>>0]=0;c[j+4>>2]=0}o=0;ia(91,j|0,0);h=o;o=0;if(h&1){h=Na(0)|0;ec(h)};c[j>>2]=c[w>>2];c[j+4>>2]=c[w+4>>2];c[j+8>>2]=c[w+8>>2];c[w>>2]=0;c[w+4>>2]=0;c[w+8>>2]=0;Im(w);Cb[c[(c[p>>2]|0)+24>>2]&127](x,b);if(!(a[k>>0]&1)){a[k+1>>0]=0;a[k>>0]=0}else{a[c[k+8>>2]>>0]=0;c[k+4>>2]=0}o=0;ia(91,k|0,0);h=o;o=0;if(h&1){h=Na(0)|0;ec(h)}else{c[k>>2]=c[x>>2];c[k+4>>2]=c[x+4>>2];c[k+8>>2]=c[x+8>>2];c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;Im(x);C=Eb[c[(c[b>>2]|0)+36>>2]&127](b)|0;break}}else{b=Is(e,43764)|0;e=c[b>>2]|0;do if(d){Cb[c[e+44>>2]&127](y,b);d=c[y>>2]|0;a[f>>0]=d;a[f+1>>0]=d>>8;a[f+2>>0]=d>>16;a[f+3>>0]=d>>24;Cb[c[(c[b>>2]|0)+32>>2]&127](z,b);if(!(a[l>>0]&1)){a[l+1>>0]=0;a[l>>0]=0}else{a[c[l+8>>2]>>0]=0;c[l+4>>2]=0}o=0;ia(91,l|0,0);f=o;o=0;if(f&1){l=Na(0)|0;ec(l)}else{c[l>>2]=c[z>>2];c[l+4>>2]=c[z+4>>2];c[l+8>>2]=c[z+8>>2];c[z>>2]=0;c[z+4>>2]=0;c[z+8>>2]=0;Im(z);n=b;break}}else{Cb[c[e+40>>2]&127](A,b);d=c[A>>2]|0;a[f>>0]=d;a[f+1>>0]=d>>8;a[f+2>>0]=d>>16;a[f+3>>0]=d>>24;Cb[c[(c[b>>2]|0)+28>>2]&127](B,b);if(!(a[l>>0]&1)){a[l+1>>0]=0;a[l>>0]=0}else{a[c[l+8>>2]>>0]=0;c[l+4>>2]=0}o=0;ia(91,l|0,0);f=o;o=0;if(f&1){l=Na(0)|0;ec(l)}else{c[l>>2]=c[B>>2];c[l+4>>2]=c[B+4>>2];c[l+8>>2]=c[B+8>>2];c[B>>2]=0;c[B+4>>2]=0;c[B+8>>2]=0;Im(B);n=b;break}}while(0);a[g>>0]=Eb[c[(c[b>>2]|0)+12>>2]&127](b)|0;a[h>>0]=Eb[c[(c[b>>2]|0)+16>>2]&127](b)|0;Cb[c[(c[n>>2]|0)+20>>2]&127](s,b);if(!(a[j>>0]&1)){a[j+1>>0]=0;a[j>>0]=0}else{a[c[j+8>>2]>>0]=0;c[j+4>>2]=0}o=0;ia(91,j|0,0);h=o;o=0;if(h&1){h=Na(0)|0;ec(h)};c[j>>2]=c[s>>2];c[j+4>>2]=c[s+4>>2];c[j+8>>2]=c[s+8>>2];c[s>>2]=0;c[s+4>>2]=0;c[s+8>>2]=0;Im(s);Cb[c[(c[n>>2]|0)+24>>2]&127](t,b);if(!(a[k>>0]&1)){a[k+1>>0]=0;a[k>>0]=0}else{a[c[k+8>>2]>>0]=0;c[k+4>>2]=0}o=0;ia(91,k|0,0);h=o;o=0;if(h&1){h=Na(0)|0;ec(h)}else{c[k>>2]=c[t>>2];c[k+4>>2]=c[t+4>>2];c[k+8>>2]=c[t+8>>2];c[t>>2]=0;c[t+4>>2]=0;c[t+8>>2]=0;Im(t);C=Eb[c[(c[b>>2]|0)+36>>2]&127](b)|0;break}}while(0);c[m>>2]=C;i=D;return}function ds(d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;q=q|0;r=r|0;var s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0;c[f>>2]=d;N=q+4|0;O=q+8|0;P=q+1|0;H=p+4|0;I=(g&512|0)==0;J=p+8|0;K=p+1|0;L=j+8|0;M=(r|0)>0;A=o+4|0;B=o+8|0;C=o+1|0;D=r+1|0;F=-2-r-((r|0)<0?~r:-1)|0;G=(r|0)>0;z=0;do{switch(a[l+z>>0]|0){case 0:{c[e>>2]=c[f>>2];break}case 1:{c[e>>2]=c[f>>2];x=Lb[c[(c[j>>2]|0)+28>>2]&63](j,32)|0;y=c[f>>2]|0;c[f>>2]=y+1;a[y>>0]=x;break}case 3:{y=a[q>>0]|0;s=(y&1)==0;if((s?(y&255)>>>1:c[N>>2]|0)|0){x=a[(s?P:c[O>>2]|0)>>0]|0;y=c[f>>2]|0;c[f>>2]=y+1;a[y>>0]=x}break}case 2:{u=a[p>>0]|0;s=(u&1)==0;u=s?(u&255)>>>1:c[H>>2]|0;if(!(I|(u|0)==0)){t=s?K:c[J>>2]|0;v=t+u|0;s=c[f>>2]|0;if(u)do{a[s>>0]=a[t>>0]|0;t=t+1|0;s=s+1|0}while((t|0)!=(v|0));c[f>>2]=s}break}case 4:{s=c[f>>2]|0;h=k?h+1|0:h;w=h;v=c[L>>2]|0;a:do if(h>>>0<i>>>0){t=h;do{u=a[t>>0]|0;if(u<<24>>24<=-1)break a;if(!(b[v+(u<<24>>24<<1)>>1]&2048))break a;t=t+1|0}while(t>>>0<i>>>0)}else t=h;while(0);u=t;if(M){x=-2-u-~(u>>>0>w>>>0?w:u)|0;x=F>>>0>x>>>0?F:x;if(t>>>0>h>>>0&G){u=t;w=r;while(1){u=u+-1|0;y=a[u>>0]|0;v=c[f>>2]|0;c[f>>2]=v+1;a[v>>0]=y;v=(w|0)>1;if(!(u>>>0>h>>>0&v))break;else w=w+-1|0}}else v=G;y=D+x|0;u=t+(x+1)|0;if(v)w=Lb[c[(c[j>>2]|0)+28>>2]&63](j,48)|0;else w=0;t=c[f>>2]|0;c[f>>2]=t+1;if((y|0)>0){v=y;while(1){a[t>>0]=w;t=c[f>>2]|0;c[f>>2]=t+1;if((v|0)>1)v=v+-1|0;else break}}a[t>>0]=m}else u=t;if((u|0)!=(h|0)){y=a[o>>0]|0;t=(y&1)==0;if(!((t?(y&255)>>>1:c[A>>2]|0)|0))t=-1;else t=a[(t?C:c[B>>2]|0)>>0]|0;if((u|0)!=(h|0)){v=0;w=0;while(1){if((w|0)==(t|0)){y=c[f>>2]|0;c[f>>2]=y+1;a[y>>0]=n;v=v+1|0;y=a[o>>0]|0;t=(y&1)==0;if(v>>>0<(t?(y&255)>>>1:c[A>>2]|0)>>>0){t=a[(t?C:c[B>>2]|0)+v>>0]|0;t=t<<24>>24==127?-1:t<<24>>24;w=0}else{t=w;w=0}}u=u+-1|0;x=a[u>>0]|0;y=c[f>>2]|0;c[f>>2]=y+1;a[y>>0]=x;if((u|0)==(h|0))break;else w=w+1|0}}}else{x=Lb[c[(c[j>>2]|0)+28>>2]&63](j,48)|0;y=c[f>>2]|0;c[f>>2]=y+1;a[y>>0]=x}t=c[f>>2]|0;if((s|0)!=(t|0)?(E=t+-1|0,s>>>0<E>>>0):0){t=E;do{y=a[s>>0]|0;a[s>>0]=a[t>>0]|0;a[t>>0]=y;s=s+1|0;t=t+-1|0}while(s>>>0<t>>>0)}break}default:{}}z=z+1|0}while((z|0)!=4);t=a[q>>0]|0;h=(t&1)==0;t=h?(t&255)>>>1:c[N>>2]|0;if(t>>>0>1){s=h?P:c[O>>2]|0;u=s+t|0;h=c[f>>2]|0;if((t|0)!=1){s=s+1|0;do{a[h>>0]=a[s>>0]|0;h=h+1|0;s=s+1|0}while((s|0)!=(u|0))}c[f>>2]=h}switch(g&176|0){case 32:{c[e>>2]=c[f>>2];break}case 16:break;default:c[e>>2]=d}return}function es(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0;z=i;i=i+176|0;r=z+56|0;B=z+52|0;x=z+64|0;u=z+61|0;y=z+60|0;C=z+40|0;E=z+28|0;D=z+16|0;m=z+12|0;q=z+68|0;w=z+8|0;v=z+4|0;s=z;b=jn(f)|0;c[B>>2]=b;o=0;t=ra(37,B|0,44220)|0;p=o;o=0;do if(p&1)F=13;else{n=a[h>>0]|0;j=(n&1)==0;p=h+4|0;if(!((j?(n&255)>>>1:c[p>>2]|0)|0))n=0;else{j=a[(j?h+1|0:c[h+8>>2]|0)>>0]|0;o=0;k=ra(c[(c[t>>2]|0)+28>>2]|0,t|0,45)|0;n=o;o=0;if(n&1){F=13;break}n=j<<24>>24==k<<24>>24}c[C>>2]=0;c[C+4>>2]=0;c[C+8>>2]=0;c[E>>2]=0;c[E+4>>2]=0;c[E+8>>2]=0;c[D>>2]=0;c[D+4>>2]=0;c[D+8>>2]=0;o=0;qa(3,e|0,n|0,B|0,x|0,u|0,y|0,C|0,E|0,D|0,m|0);l=o;o=0;if(!(l&1)){l=a[h>>0]|0;e=c[p>>2]|0;j=(l&1)==0?(l&255)>>>1:e;m=c[m>>2]|0;if((j|0)>(m|0)){G=a[D>>0]|0;k=a[E>>0]|0;j=(j-m<<1|1)+m+((G&1)==0?(G&255)>>>1:c[D+4>>2]|0)+((k&1)==0?(k&255)>>>1:c[E+4>>2]|0)|0}else{G=a[D>>0]|0;j=a[E>>0]|0;j=m+2+((G&1)==0?(G&255)>>>1:c[D+4>>2]|0)+((j&1)==0?(j&255)>>>1:c[E+4>>2]|0)|0}if(j>>>0>100){j=Fl(j)|0;k=j;if(!j){o=0;xa(6);G=o;o=0;if(!(G&1)){l=a[h>>0]|0;e=c[p>>2]|0;j=0;F=17}}else F=17}else{k=0;j=q;F=17}if((F|0)==17){G=(l&1)==0;h=G?h+1|0:c[h+8>>2]|0;o=0;na(1,j|0,w|0,v|0,c[f+4>>2]|0,h|0,h+(G?(l&255)>>>1:e)|0,t|0,n|0,x|0,a[u>>0]|0,a[y>>0]|0,C|0,E|0,D|0,m|0);G=o;o=0;if(!(G&1)?(c[s>>2]=c[d>>2],G=c[w>>2]|0,A=c[v>>2]|0,o=0,c[r>>2]=c[s>>2],A=ja(39,r|0,j|0,G|0,A|0,f|0,g|0)|0,G=o,o=0,!(G&1)):0){if(k){Gl(k);b=c[B>>2]|0}Im(D);Im(E);Im(C);pm(b)|0;i=z;return A|0}}j=Na()|0;if(k){Gl(k);b=c[B>>2]|0}}else j=Na()|0;Im(D);Im(E);Im(C)}while(0);if((F|0)==13)j=Na()|0;pm(b)|0;Ya(j|0);return 0}function fs(a){a=a|0;return}function gs(a){a=a|0;cj(a);return}function hs(b,d,e,f,g,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;j=+j;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0;D=i;i=i+992|0;v=D+8|0;k=D;m=D+888|0;n=D+880|0;l=D+480|0;F=D+76|0;A=D+884|0;x=D+72|0;B=D+68|0;G=D+56|0;I=D+44|0;H=D+32|0;p=D+28|0;u=D+80|0;z=D+24|0;y=D+20|0;w=D+16|0;c[n>>2]=m;h[v>>3]=j;m=_k(m,100,59018,v)|0;do if(m>>>0>99){o=0;b=ua(3)|0;C=o;o=0;if(!(C&1)?(o=0,h[k>>3]=j,s=va(17,n|0,b|0,59018,k|0)|0,C=o,o=0,!(C&1)):0){b=c[n>>2]|0;if(!b){o=0;xa(6);C=o;o=0;if(C&1){b=0;k=0;C=7;break}b=c[n>>2]|0}l=Fl(s<<2)|0;k=l;if(!l){o=0;xa(6);C=o;o=0;if(C&1)C=7;else{t=0;C=10}}else{t=l;C=10}}else{b=0;k=0;C=7}}else{k=0;b=0;t=l;s=m;C=10}while(0);if((C|0)==10){o=0;l=ka(68,f|0)|0;r=o;o=0;if(r&1)C=7;else{c[F>>2]=l;o=0;r=ra(37,F|0,44212)|0;q=o;o=0;if(!(q&1)?(q=c[n>>2]|0,o=0,va(c[(c[r>>2]|0)+48>>2]|0,r|0,q|0,q+s|0,t|0)|0,q=o,o=0,!(q&1)):0){if(!s)q=0;else q=(a[c[n>>2]>>0]|0)==45;c[G>>2]=0;c[G+4>>2]=0;c[G+8>>2]=0;c[I>>2]=0;c[I+4>>2]=0;c[I+8>>2]=0;c[H>>2]=0;c[H+4>>2]=0;c[H+8>>2]=0;o=0;qa(4,e|0,q|0,F|0,A|0,x|0,B|0,G|0,I|0,H|0,p|0);e=o;o=0;if(!(e&1)){p=c[p>>2]|0;if((s|0)>(p|0)){e=a[H>>0]|0;m=a[I>>0]|0;m=(s-p<<1|1)+p+((e&1)==0?(e&255)>>>1:c[H+4>>2]|0)+((m&1)==0?(m&255)>>>1:c[I+4>>2]|0)|0}else{e=a[H>>0]|0;m=a[I>>0]|0;m=p+2+((e&1)==0?(e&255)>>>1:c[H+4>>2]|0)+((m&1)==0?(m&255)>>>1:c[I+4>>2]|0)|0}if(m>>>0>100){m=Fl(m<<2)|0;n=m;if(!m){o=0;xa(6);u=o;o=0;if(!(u&1)){m=0;C=26}}else C=26}else{n=0;m=u;C=26}if((C|0)==26){o=0;na(2,m|0,z|0,y|0,c[f+4>>2]|0,t|0,t+(s<<2)|0,r|0,q|0,A|0,c[x>>2]|0,c[B>>2]|0,G|0,I|0,H|0,p|0);B=o;o=0;if(!(B&1)?(c[w>>2]=c[d>>2],d=c[z>>2]|0,E=c[y>>2]|0,o=0,c[v>>2]=c[w>>2],E=ja(40,v|0,m|0,d|0,E|0,f|0,g|0)|0,d=o,o=0,!(d&1)):0){if(n){Gl(n);l=c[F>>2]|0}Wm(H);Wm(I);Im(G);pm(l)|0;if(k)Gl(k);if(b)Gl(b);i=D;return E|0}}m=Na()|0;if(n){Gl(n);l=c[F>>2]|0}}else m=Na()|0;Wm(H);Wm(I);Im(G)}else m=Na()|0;pm(l)|0}}if((C|0)==7)m=Na()|0;if(k)Gl(k);if(b)Gl(b);Ya(m|0);return 0}function is(b,d,e,f,g,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;B=i;i=i+112|0;n=B+108|0;p=B+96|0;s=B+92|0;t=B+80|0;u=B+68|0;v=B+56|0;w=B+52|0;x=B+40|0;y=B+36|0;z=B+24|0;q=B+12|0;r=B;do if(b){b=Is(e,43956)|0;e=c[b>>2]|0;do if(d){Cb[c[e+44>>2]&127](n,b);d=c[n>>2]|0;a[f>>0]=d;a[f+1>>0]=d>>8;a[f+2>>0]=d>>16;a[f+3>>0]=d>>24;Cb[c[(c[b>>2]|0)+32>>2]&127](p,b);if(!(a[l>>0]&1))a[l>>0]=0;else c[c[l+8>>2]>>2]=0;c[l+4>>2]=0;o=0;ia(93,l|0,0);f=o;o=0;if(f&1){l=Na(0)|0;ec(l)}else{c[l>>2]=c[p>>2];c[l+4>>2]=c[p+4>>2];c[l+8>>2]=c[p+8>>2];c[p>>2]=0;c[p+4>>2]=0;c[p+8>>2]=0;Wm(p);break}}else{Cb[c[e+40>>2]&127](s,b);d=c[s>>2]|0;a[f>>0]=d;a[f+1>>0]=d>>8;a[f+2>>0]=d>>16;a[f+3>>0]=d>>24;Cb[c[(c[b>>2]|0)+28>>2]&127](t,b);if(!(a[l>>0]&1))a[l>>0]=0;else c[c[l+8>>2]>>2]=0;c[l+4>>2]=0;o=0;ia(93,l|0,0);f=o;o=0;if(f&1){l=Na(0)|0;ec(l)}else{c[l>>2]=c[t>>2];c[l+4>>2]=c[t+4>>2];c[l+8>>2]=c[t+8>>2];c[t>>2]=0;c[t+4>>2]=0;c[t+8>>2]=0;Wm(t);break}}while(0);c[g>>2]=Eb[c[(c[b>>2]|0)+12>>2]&127](b)|0;c[h>>2]=Eb[c[(c[b>>2]|0)+16>>2]&127](b)|0;Cb[c[(c[b>>2]|0)+20>>2]&127](u,b);if(!(a[j>>0]&1)){a[j+1>>0]=0;a[j>>0]=0}else{a[c[j+8>>2]>>0]=0;c[j+4>>2]=0}o=0;ia(91,j|0,0);h=o;o=0;if(h&1){h=Na(0)|0;ec(h)};c[j>>2]=c[u>>2];c[j+4>>2]=c[u+4>>2];c[j+8>>2]=c[u+8>>2];c[u>>2]=0;c[u+4>>2]=0;c[u+8>>2]=0;Im(u);Cb[c[(c[b>>2]|0)+24>>2]&127](v,b);if(!(a[k>>0]&1))a[k>>0]=0;else c[c[k+8>>2]>>2]=0;c[k+4>>2]=0;o=0;ia(93,k|0,0);h=o;o=0;if(h&1){h=Na(0)|0;ec(h)}else{c[k>>2]=c[v>>2];c[k+4>>2]=c[v+4>>2];c[k+8>>2]=c[v+8>>2];c[v>>2]=0;c[v+4>>2]=0;c[v+8>>2]=0;Wm(v);A=Eb[c[(c[b>>2]|0)+36>>2]&127](b)|0;break}}else{b=Is(e,43892)|0;e=c[b>>2]|0;do if(d){Cb[c[e+44>>2]&127](w,b);d=c[w>>2]|0;a[f>>0]=d;a[f+1>>0]=d>>8;a[f+2>>0]=d>>16;a[f+3>>0]=d>>24;Cb[c[(c[b>>2]|0)+32>>2]&127](x,b);if(!(a[l>>0]&1))a[l>>0]=0;else c[c[l+8>>2]>>2]=0;c[l+4>>2]=0;o=0;ia(93,l|0,0);f=o;o=0;if(f&1){l=Na(0)|0;ec(l)}else{c[l>>2]=c[x>>2];c[l+4>>2]=c[x+4>>2];c[l+8>>2]=c[x+8>>2];c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;Wm(x);break}}else{Cb[c[e+40>>2]&127](y,b);d=c[y>>2]|0;a[f>>0]=d;a[f+1>>0]=d>>8;a[f+2>>0]=d>>16;a[f+3>>0]=d>>24;Cb[c[(c[b>>2]|0)+28>>2]&127](z,b);if(!(a[l>>0]&1))a[l>>0]=0;else c[c[l+8>>2]>>2]=0;c[l+4>>2]=0;o=0;ia(93,l|0,0);f=o;o=0;if(f&1){l=Na(0)|0;ec(l)}else{c[l>>2]=c[z>>2];c[l+4>>2]=c[z+4>>2];c[l+8>>2]=c[z+8>>2];c[z>>2]=0;c[z+4>>2]=0;c[z+8>>2]=0;Wm(z);break}}while(0);c[g>>2]=Eb[c[(c[b>>2]|0)+12>>2]&127](b)|0;c[h>>2]=Eb[c[(c[b>>2]|0)+16>>2]&127](b)|0;Cb[c[(c[b>>2]|0)+20>>2]&127](q,b);if(!(a[j>>0]&1)){a[j+1>>0]=0;a[j>>0]=0}else{a[c[j+8>>2]>>0]=0;c[j+4>>2]=0}o=0;ia(91,j|0,0);h=o;o=0;if(h&1){h=Na(0)|0;ec(h)};c[j>>2]=c[q>>2];c[j+4>>2]=c[q+4>>2];c[j+8>>2]=c[q+8>>2];c[q>>2]=0;c[q+4>>2]=0;c[q+8>>2]=0;Im(q);Cb[c[(c[b>>2]|0)+24>>2]&127](r,b);if(!(a[k>>0]&1))a[k>>0]=0;else c[c[k+8>>2]>>2]=0;c[k+4>>2]=0;o=0;ia(93,k|0,0);h=o;o=0;if(h&1){h=Na(0)|0;ec(h)}else{c[k>>2]=c[r>>2];c[k+4>>2]=c[r+4>>2];c[k+8>>2]=c[r+8>>2];c[r>>2]=0;c[r+4>>2]=0;c[r+8>>2]=0;Wm(r);A=Eb[c[(c[b>>2]|0)+36>>2]&127](b)|0;break}}while(0);c[m>>2]=A;i=B;return}function js(b,d,e,f,g,h,i,j,k,l,m,n,o,p,q){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;q=q|0;var r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0;c[e>>2]=b;J=p+4|0;K=p+8|0;C=o+4|0;D=(f&512|0)==0;E=o+8|0;F=(q|0)>0;G=n+4|0;H=n+8|0;I=n+1|0;A=(q|0)>0;z=0;do{switch(a[k+z>>0]|0){case 0:{c[d>>2]=c[e>>2];break}case 1:{c[d>>2]=c[e>>2];x=Lb[c[(c[i>>2]|0)+44>>2]&63](i,32)|0;y=c[e>>2]|0;c[e>>2]=y+4;c[y>>2]=x;break}case 3:{y=a[p>>0]|0;r=(y&1)==0;if((r?(y&255)>>>1:c[J>>2]|0)|0){x=c[(r?J:c[K>>2]|0)>>2]|0;y=c[e>>2]|0;c[e>>2]=y+4;c[y>>2]=x}break}case 2:{v=a[o>>0]|0;r=(v&1)==0;v=r?(v&255)>>>1:c[C>>2]|0;if(!(D|(v|0)==0)){r=r?C:c[E>>2]|0;t=r+(v<<2)|0;u=c[e>>2]|0;if(v){s=u;while(1){c[s>>2]=c[r>>2];r=r+4|0;if((r|0)==(t|0))break;else s=s+4|0}}c[e>>2]=u+(v<<2)}break}case 4:{r=c[e>>2]|0;g=j?g+4|0:g;a:do if(g>>>0<h>>>0){s=g;do{if(!(Gb[c[(c[i>>2]|0)+12>>2]&63](i,2048,c[s>>2]|0)|0))break a;s=s+4|0}while(s>>>0<h>>>0)}else s=g;while(0);if(F){if(s>>>0>g>>>0&A){v=c[e>>2]|0;u=q;while(1){s=s+-4|0;t=v+4|0;c[v>>2]=c[s>>2];w=u+-1|0;u=(u|0)>1;if(s>>>0>g>>>0&u){v=t;u=w}else{v=w;break}}c[e>>2]=t;t=v}else{u=A;t=q}if(u)w=Lb[c[(c[i>>2]|0)+44>>2]&63](i,48)|0;else w=0;x=c[e>>2]|0;u=t+((t|0)<0?~t:-1)|0;if((t|0)>0){v=x;while(1){c[v>>2]=w;if((t|0)>1){v=v+4|0;t=t+-1|0}else break}}c[e>>2]=x+(u+2<<2);c[x+(u+1<<2)>>2]=l}if((s|0)==(g|0)){x=Lb[c[(c[i>>2]|0)+44>>2]&63](i,48)|0;y=c[e>>2]|0;s=y+4|0;c[e>>2]=s;c[y>>2]=x}else{x=a[n>>0]|0;t=(x&1)==0;y=c[G>>2]|0;if(!((t?(x&255)>>>1:y)|0))t=-1;else t=a[(t?I:c[H>>2]|0)>>0]|0;if((s|0)!=(g|0)){w=0;x=0;while(1){u=c[e>>2]|0;if((x|0)==(t|0)){v=u+4|0;c[e>>2]=v;c[u>>2]=m;w=w+1|0;u=a[n>>0]|0;t=(u&1)==0;if(w>>>0<(t?(u&255)>>>1:y)>>>0){t=a[(t?I:c[H>>2]|0)+w>>0]|0;u=v;t=t<<24>>24==127?-1:t<<24>>24;v=0}else{u=v;t=x;v=0}}else v=x;s=s+-4|0;x=c[s>>2]|0;c[e>>2]=u+4;c[u>>2]=x;if((s|0)==(g|0))break;else x=v+1|0}}s=c[e>>2]|0}if((r|0)!=(s|0)?(B=s+-4|0,r>>>0<B>>>0):0){s=B;do{y=c[r>>2]|0;c[r>>2]=c[s>>2];c[s>>2]=y;r=r+4|0;s=s+-4|0}while(r>>>0<s>>>0)}break}default:{}}z=z+1|0}while((z|0)!=4);r=a[p>>0]|0;g=(r&1)==0;r=g?(r&255)>>>1:c[J>>2]|0;if(r>>>0>1){s=g?J:c[K>>2]|0;g=s+4|0;s=s+(r<<2)|0;t=c[e>>2]|0;u=s-g|0;if((r|0)!=1){r=t;while(1){c[r>>2]=c[g>>2];g=g+4|0;if((g|0)==(s|0))break;else r=r+4|0}}c[e>>2]=t+(u>>>2<<2)}switch(f&176|0){case 32:{c[d>>2]=c[e>>2];break}case 16:break;default:c[d>>2]=b}return}function ks(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0;z=i;i=i+480|0;q=z+468|0;B=z+464|0;x=z+472|0;u=z+56|0;y=z+52|0;C=z+40|0;E=z+28|0;D=z+16|0;m=z+12|0;p=z+64|0;w=z+8|0;v=z+4|0;r=z;b=jn(f)|0;c[B>>2]=b;o=0;s=ra(37,B|0,44212)|0;t=o;o=0;do if(t&1)F=13;else{n=a[h>>0]|0;j=(n&1)==0;t=h+4|0;if(!((j?(n&255)>>>1:c[t>>2]|0)|0))n=0;else{j=c[(j?t:c[h+8>>2]|0)>>2]|0;o=0;k=ra(c[(c[s>>2]|0)+44>>2]|0,s|0,45)|0;n=o;o=0;if(n&1){F=13;break}n=(j|0)==(k|0)}c[C>>2]=0;c[C+4>>2]=0;c[C+8>>2]=0;c[E>>2]=0;c[E+4>>2]=0;c[E+8>>2]=0;c[D>>2]=0;c[D+4>>2]=0;c[D+8>>2]=0;o=0;qa(4,e|0,n|0,B|0,x|0,u|0,y|0,C|0,E|0,D|0,m|0);l=o;o=0;if(!(l&1)){l=a[h>>0]|0;e=c[t>>2]|0;j=(l&1)==0?(l&255)>>>1:e;m=c[m>>2]|0;if((j|0)>(m|0)){G=a[D>>0]|0;k=a[E>>0]|0;j=(j-m<<1|1)+m+((G&1)==0?(G&255)>>>1:c[D+4>>2]|0)+((k&1)==0?(k&255)>>>1:c[E+4>>2]|0)|0}else{G=a[D>>0]|0;j=a[E>>0]|0;j=m+2+((G&1)==0?(G&255)>>>1:c[D+4>>2]|0)+((j&1)==0?(j&255)>>>1:c[E+4>>2]|0)|0}if(j>>>0>100){j=Fl(j<<2)|0;k=j;if(!j){o=0;xa(6);G=o;o=0;if(!(G&1)){l=a[h>>0]|0;e=c[t>>2]|0;j=0;F=17}}else F=17}else{k=0;j=p;F=17}if((F|0)==17){G=(l&1)==0;h=G?t:c[h+8>>2]|0;o=0;na(2,j|0,w|0,v|0,c[f+4>>2]|0,h|0,h+((G?(l&255)>>>1:e)<<2)|0,s|0,n|0,x|0,c[u>>2]|0,c[y>>2]|0,C|0,E|0,D|0,m|0);G=o;o=0;if(!(G&1)?(c[r>>2]=c[d>>2],G=c[w>>2]|0,A=c[v>>2]|0,o=0,c[q>>2]=c[r>>2],A=ja(40,q|0,j|0,G|0,A|0,f|0,g|0)|0,G=o,o=0,!(G&1)):0){if(k){Gl(k);b=c[B>>2]|0}Wm(D);Wm(E);Im(C);pm(b)|0;i=z;return A|0}}j=Na()|0;if(k){Gl(k);b=c[B>>2]|0}}else j=Na()|0;Wm(D);Wm(E);Im(C)}while(0);if((F|0)==13)j=Na()|0;pm(b)|0;Ya(j|0);return 0}function ls(a){a=a|0;return}function ms(a){a=a|0;cj(a);return}function ns(b,d,e){b=b|0;d=d|0;e=e|0;b=lk((a[d>>0]&1)==0?d+1|0:c[d+8>>2]|0,1)|0;return b>>>((b|0)!=(-1|0)&1)|0}function os(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0;k=i;i=i+16|0;l=k;c[l>>2]=0;c[l+4>>2]=0;c[l+8>>2]=0;j=a[h>>0]|0;m=(j&1)==0;d=m?h+1|0:c[h+8>>2]|0;j=m?(j&255)>>>1:c[h+4>>2]|0;h=d+j|0;a:do if((j|0)>0){while(1){o=0;ia(67,l|0,a[d>>0]|0);m=o;o=0;if(m&1)break;d=d+1|0;if(d>>>0>=h>>>0){j=4;break a}}d=Na()|0;j=7}else j=4;while(0);b:do if((j|0)==4){o=0;d=va(19,((e|0)==-1?-1:e<<1)|0,f|0,g|0,((a[l>>0]&1)==0?l+1|0:c[l+8>>2]|0)|0)|0;m=o;o=0;if(m&1){d=Na()|0;j=7;break}c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;m=nl(d)|0;h=d+m|0;c:do if((m|0)>0){while(1){o=0;ia(67,b|0,a[d>>0]|0);m=o;o=0;if(m&1)break;d=d+1|0;if(d>>>0>=h>>>0)break c}d=Na()|0;Im(b);break b}while(0);Im(l);i=k;return}while(0);Im(l);Ya(d|0)}function ps(a,b){a=a|0;b=b|0;return}function qs(a){a=a|0;return}function rs(a){a=a|0;cj(a);return}function ss(b,d,e){b=b|0;d=d|0;e=e|0;b=lk((a[d>>0]&1)==0?d+1|0:c[d+8>>2]|0,1)|0;return b>>>((b|0)!=(-1|0)&1)|0}function ts(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;w=i;i=i+224|0;p=w+184|0;n=w+192|0;m=w+180|0;q=w+176|0;u=w+168|0;t=w+40|0;s=w+32|0;v=w+28|0;x=w+16|0;l=w+8|0;r=w;c[x>>2]=0;c[x+4>>2]=0;c[x+8>>2]=0;c[l+4>>2]=0;c[l>>2]=44696;k=a[h>>0]|0;y=(k&1)==0;j=h+4|0;d=y?j:c[h+8>>2]|0;h=y?(k&255)>>>1:c[j>>2]|0;j=d+(h<<2)|0;k=n+32|0;a:do if((h|0)>0){b:while(1){c[q>>2]=d;o=0;h=ya(c[(c[l>>2]|0)+12>>2]|0,l|0,p|0,d|0,j|0,q|0,n|0,k|0,m|0)|0;y=o;o=0;if(y&1){h=12;break}if((h|0)==2?1:(c[q>>2]|0)==(d|0)){h=5;break}if(n>>>0<(c[m>>2]|0)>>>0){d=n;do{o=0;ia(67,x|0,a[d>>0]|0);y=o;o=0;if(y&1){h=11;break b}d=d+1|0}while(d>>>0<(c[m>>2]|0)>>>0)}d=c[q>>2]|0;if(!((h|0)!=2&d>>>0<j>>>0)){h=9;break a}}if((h|0)==5){o=0;ha(190,58955);o=0;d=Na()|0}else if((h|0)==11)d=Na()|0;else if((h|0)==12)d=Na()|0}else h=9;while(0);c:do if((h|0)==9){o=0;d=va(19,((e|0)==-1?-1:e<<1)|0,f|0,g|0,((a[x>>0]&1)==0?x+1|0:c[x+8>>2]|0)|0)|0;y=o;o=0;if(y&1){d=Na()|0;break}c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[r+4>>2]=0;c[r>>2]=44744;y=nl(d)|0;j=d+y|0;k=j;l=t+128|0;d:do if((y|0)>0){e:while(1){c[v>>2]=d;o=0;h=ya(c[(c[r>>2]|0)+16>>2]|0,r|0,u|0,d|0,((k-d|0)>32?d+32|0:j)|0,v|0,t|0,l|0,s|0)|0;y=o;o=0;if(y&1){h=24;break}if((h|0)==2?1:(c[v>>2]|0)==(d|0)){h=18;break}if(t>>>0<(c[s>>2]|0)>>>0){d=t;do{o=0;ia(92,b|0,c[d>>2]|0);y=o;o=0;if(y&1){h=23;break e}d=d+4|0}while(d>>>0<(c[s>>2]|0)>>>0)}d=c[v>>2]|0;if(!((h|0)!=2&d>>>0<j>>>0))break d}if((h|0)==18){o=0;ha(190,58955);o=0;d=Na()|0}else if((h|0)==23)d=Na()|0;else if((h|0)==24)d=Na()|0;Wm(b);break c}while(0);Im(x);i=w;return}while(0);Im(x);Ya(d|0)}function us(a,b){a=a|0;b=b|0;return}function vs(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;c[b+4>>2]=d+-1;c[b>>2]=44196;h=b+8|0;o=0;ia(94,h|0,28);g=o;o=0;if(g&1)d=Na()|0;else{g=b+144|0;o=0;wa(5,g|0,58885,1);f=o;o=0;if(f&1)d=Na()|0;else{e=c[h>>2]|0;f=b+12|0;d=c[f>>2]|0;if((d|0)!=(e|0)){do d=d+-4|0;while((d|0)!=(e|0));c[f>>2]=d}c[495]=0;c[494]=43124;o=0;ia(95,b|0,1976);f=o;o=0;do if(((((((((((((!(f&1)?(c[497]=0,c[496]=43164,o=0,ia(96,b|0,1984),f=o,o=0,!(f&1)):0)?(c[499]=0,c[498]=44236,c[500]=0,a[2004]=0,c[500]=Os()|0,o=0,ia(97,b|0,1992),f=o,o=0,!(f&1)):0)?(c[503]=0,c[502]=44484,o=0,ia(98,b|0,2008),f=o,o=0,!(f&1)):0)?(c[505]=0,c[504]=44552,o=0,ia(99,b|0,2016),f=o,o=0,!(f&1)):0)?(o=0,ia(100,2024,1),f=o,o=0,!(f&1)):0)?(o=0,ia(101,b|0,2024),f=o,o=0,!(f&1)):0)?(c[511]=0,c[510]=44600,o=0,ia(102,b|0,2040),f=o,o=0,!(f&1)):0)?(c[513]=0,c[512]=44648,o=0,ia(103,b|0,2048),f=o,o=0,!(f&1)):0)?(Tt(2056,1),o=0,ia(104,b|0,2056),f=o,o=0,!(f&1)):0)?(Ut(2080,1),o=0,ia(105,b|0,2080),f=o,o=0,!(f&1)):0)?(c[529]=0,c[528]=43204,o=0,ia(106,b|0,2112),f=o,o=0,!(f&1)):0)?(c[531]=0,c[530]=43276,o=0,ia(107,b|0,2120),f=o,o=0,!(f&1)):0)?(c[533]=0,c[532]=43348,o=0,ia(108,b|0,2128),f=o,o=0,!(f&1)):0){c[535]=0;c[534]=43408;o=0;ia(109,b|0,2136);f=o;o=0;if(f&1){i=42;break}c[537]=0;c[536]=43716;o=0;ia(110,b|0,2144);f=o;o=0;if(f&1){i=42;break}c[539]=0;c[538]=43780;o=0;ia(111,b|0,2152);f=o;o=0;if(f&1){i=42;break}c[541]=0;c[540]=43844;o=0;ia(112,b|0,2160);f=o;o=0;if(f&1){i=42;break}c[543]=0;c[542]=43908;o=0;ia(113,b|0,2168);f=o;o=0;if(f&1){i=42;break}c[545]=0;c[544]=43972;o=0;ia(114,b|0,2176);f=o;o=0;if(f&1){i=42;break}c[547]=0;c[546]=44008;o=0;ia(115,b|0,2184);f=o;o=0;if(f&1){i=42;break}c[549]=0;c[548]=44044;o=0;ia(116,b|0,2192);f=o;o=0;if(f&1){i=42;break}c[551]=0;c[550]=44080;o=0;ia(117,b|0,2200);f=o;o=0;if(f&1){i=42;break}c[553]=0;c[552]=43468;c[554]=43516;o=0;ia(118,b|0,2208);f=o;o=0;if(f&1){i=42;break}c[557]=0;c[556]=43560;c[558]=43608;o=0;ia(119,b|0,2224);f=o;o=0;if(f&1){i=42;break}c[561]=0;c[560]=44464;o=0;d=ua(3)|0;f=o;o=0;if(f&1){d=Na()|0;break}c[562]=d;c[560]=43652;o=0;ia(120,b|0,2240);f=o;o=0;if(f&1){i=42;break}c[565]=0;c[564]=44464;o=0;d=ua(3)|0;f=o;o=0;if(f&1){d=Na()|0;break}c[566]=d;c[564]=43684;o=0;ia(121,b|0,2256);i=o;o=0;if(i&1){i=42;break}c[569]=0;c[568]=44116;o=0;ia(122,b|0,2272);i=o;o=0;if(i&1){i=42;break}c[571]=0;c[570]=44156;o=0;ia(123,b|0,2280);i=o;o=0;if(i&1){i=42;break}return}else i=42;while(0);if((i|0)==42)d=Na()|0;Im(g)}Dv(h)}Ya(d|0)}function ws(){var b=0;do if((a[2288]|0)==0?(Ha(2288)|0)!=0:0){o=0;ua(4)|0;b=o;o=0;if(b&1){b=Na()|0;sb(2288);Ya(b|0)}else{c[11246]=44980;Pa(2288);break}}while(0);return c[11246]|0}function xs(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;om(b);f=a+8|0;e=c[f>>2]|0;do if((c[a+12>>2]|0)-e>>2>>>0<=d>>>0){o=0;ia(124,f|0,d+1|0);a=o;o=0;if(!(a&1)){e=c[f>>2]|0;break}e=Na()|0;if(b)pm(b)|0;Ya(e|0)}while(0);a=c[e+(d<<2)>>2]|0;if(a){pm(a)|0;e=c[f>>2]|0}c[e+(d<<2)>>2]=b;return}function ys(a){a=a|0;var b=0,d=0,e=0,f=0;c[a>>2]=44196;e=a+8|0;f=a+12|0;b=c[e>>2]|0;if((c[f>>2]|0)!=(b|0)){d=0;do{b=c[b+(d<<2)>>2]|0;if(b)pm(b)|0;d=d+1|0;b=c[e>>2]|0}while(d>>>0<(c[f>>2]|0)-b>>2>>>0)}Im(a+144|0);Dv(e);return}function zs(a){a=a|0;ys(a);cj(a);return}function As(a,b){a=a|0;b=b|0;if(Fv(a,b)|0)return c[(c[a+8>>2]|0)+(b<<2)>>2]|0;else{a=Ma(4)|0;qj(a);lb(a|0,640,82)}return 0}function Bs(){vs(2296,1);c[11245]=2296;return 44980}function Cs(){var a=0;a=c[(ws()|0)>>2]|0;c[11247]=a;om(a);return 44988}function Ds(){var b=0;do if((a[2456]|0)==0?(Ha(2456)|0)!=0:0){o=0;ua(5)|0;b=o;o=0;if(b&1){b=Na()|0;sb(2456);Ya(b|0)}else{c[11248]=44988;Pa(2456);break}}while(0);return c[11248]|0}function Es(a){a=a|0;var b=0,d=0;o=0;b=ua(6)|0;d=o;o=0;if(d&1){d=Na(0)|0;ec(d)}else{d=c[b>>2]|0;c[a>>2]=d;om(d);return}}function Fs(a,b){a=a|0;b=b|0;b=c[b>>2]|0;c[a>>2]=b;om(b);return}function Gs(a){a=a|0;pm(c[a>>2]|0)|0;return}function Hs(a){a=a|0;var b=0,d=0;d=i;i=i+16|0;b=d;if((c[a>>2]|0)!=-1){c[b>>2]=a;c[b+4>>2]=191;c[b+8>>2]=0;Em(a,b,192)}i=d;return (c[a+4>>2]|0)+-1|0}function Is(a,b){a=a|0;b=b|0;a=c[a>>2]|0;return As(a,Hs(b)|0)|0}function Js(a){a=a|0;cj(a);return}function Ks(a){a=a|0;if(a)Bb[c[(c[a>>2]|0)+4>>2]&255](a);return}function Ls(a){a=a|0;var b=0;b=c[11052]|0;c[11052]=b+1;c[a+4>>2]=b+1;return}function Ms(a){a=a|0;cj(a);return}function Ns(a,c,d){a=a|0;c=c|0;d=d|0;if(d>>>0<128)d=(b[(Os()|0)+(d<<1)>>1]&c)<<16>>16!=0;else d=0;return d|0}function Os(){var a=0,b=0;o=0;a=ua(7)|0;b=o;o=0;if(b&1){b=Na(0)|0;ec(b)}else return c[a>>2]|0;return 0}function Ps(a,d,f,g){a=a|0;d=d|0;f=f|0;g=g|0;var h=0,i=0;i=(f-d|0)>>>2;if((d|0)!=(f|0)){h=d;while(1){a=c[h>>2]|0;if(a>>>0<128)a=e[(Os()|0)+(a<<1)>>1]|0;else a=0;b[g>>1]=a;h=h+4|0;if((h|0)==(f|0))break;else g=g+2|0}}return d+(i<<2)|0}function Qs(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;a:do if((e|0)==(f|0))e=f;else while(1){a=c[e>>2]|0;if(a>>>0<128?(b[(Os()|0)+(a<<1)>>1]&d)<<16>>16!=0:0)break a;e=e+4|0;if((e|0)==(f|0)){e=f;break}}while(0);return e|0}function Rs(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;a:do if((e|0)==(f|0))e=f;else while(1){a=c[e>>2]|0;if(a>>>0>=128)break a;if(!((b[(Os()|0)+(a<<1)>>1]&d)<<16>>16))break a;e=e+4|0;if((e|0)==(f|0)){e=f;break}}while(0);return e|0}function Ss(a,b){a=a|0;b=b|0;if(b>>>0<128)b=c[(Ts()|0)+(b<<2)>>2]|0;return b|0}function Ts(){var a=0,b=0;o=0;a=ua(8)|0;b=o;o=0;if(b&1){b=Na(0)|0;ec(b)}else return c[a>>2]|0;return 0}function Us(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;f=(d-b|0)>>>2;if((b|0)!=(d|0)){e=b;do{a=c[e>>2]|0;if(a>>>0<128)a=c[(Ts()|0)+(a<<2)>>2]|0;c[e>>2]=a;e=e+4|0}while((e|0)!=(d|0))}return b+(f<<2)|0}function Vs(a,b){a=a|0;b=b|0;if(b>>>0<128)b=c[(Ws()|0)+(b<<2)>>2]|0;return b|0}function Ws(){var a=0,b=0;o=0;a=ua(9)|0;b=o;o=0;if(b&1){b=Na(0)|0;ec(b)}else return c[a>>2]|0;return 0}function Xs(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;f=(d-b|0)>>>2;if((b|0)!=(d|0)){e=b;do{a=c[e>>2]|0;if(a>>>0<128)a=c[(Ws()|0)+(a<<2)>>2]|0;c[e>>2]=a;e=e+4|0}while((e|0)!=(d|0))}return b+(f<<2)|0}function Ys(a,b){a=a|0;b=b|0;return b<<24>>24|0}function Zs(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;if((d|0)!=(e|0))while(1){c[f>>2]=a[d>>0];d=d+1|0;if((d|0)==(e|0))break;else f=f+4|0}return e|0}function _s(a,b,c){a=a|0;b=b|0;c=c|0;return (b>>>0<128?b&255:c)|0}function $s(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0;i=(e-d|0)>>>2;if((d|0)!=(e|0)){h=d;b=g;while(1){g=c[h>>2]|0;a[b>>0]=g>>>0<128?g&255:f;h=h+4|0;if((h|0)==(e|0))break;else b=b+1|0}}return d+(i<<2)|0}function at(b){b=b|0;var d=0;c[b>>2]=44236;d=c[b+8>>2]|0;if((d|0)!=0?(a[b+12>>0]|0)!=0:0)dj(d);return}function bt(a){a=a|0;at(a);cj(a);return}function ct(a,b){a=a|0;b=b|0;if(b<<24>>24>-1)b=c[(Ts()|0)+((b&255)<<2)>>2]&255;return b|0}function dt(b,d,e){b=b|0;d=d|0;e=e|0;if((d|0)!=(e|0)){b=d;do{d=a[b>>0]|0;if(d<<24>>24>-1)d=c[(Ts()|0)+(d<<24>>24<<2)>>2]&255;a[b>>0]=d;b=b+1|0}while((b|0)!=(e|0))}return e|0}function et(a,b){a=a|0;b=b|0;if(b<<24>>24>-1)b=c[(Ws()|0)+(b<<24>>24<<2)>>2]&255;return b|0}function ft(b,d,e){b=b|0;d=d|0;e=e|0;if((d|0)!=(e|0)){b=d;do{d=a[b>>0]|0;if(d<<24>>24>-1)d=c[(Ws()|0)+(d<<24>>24<<2)>>2]&255;a[b>>0]=d;b=b+1|0}while((b|0)!=(e|0))}return e|0}function gt(a,b){a=a|0;b=b|0;return b|0}function ht(b,c,d,e){b=b|0;c=c|0;d=d|0;e=e|0;if((c|0)!=(d|0))while(1){a[e>>0]=a[c>>0]|0;c=c+1|0;if((c|0)==(d|0))break;else e=e+1|0}return d|0}function it(a,b,c){a=a|0;b=b|0;c=c|0;return (b<<24>>24>-1?b:c)|0}function jt(b,c,d,e,f){b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;if((c|0)!=(d|0))while(1){b=a[c>>0]|0;a[f>>0]=b<<24>>24>-1?b:e;c=c+1|0;if((c|0)==(d|0))break;else f=f+1|0}return d|0}function kt(a){a=a|0;cj(a);return}function lt(a,b,d,e,f,g,h,i){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;c[f>>2]=d;c[i>>2]=g;return 3}function mt(a,b,d,e,f,g,h,i){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;c[f>>2]=d;c[i>>2]=g;return 3}function nt(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;c[f>>2]=d;return 3}function ot(a){a=a|0;return 1}function pt(a){a=a|0;return 1}function qt(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;a=d-c|0;return (a>>>0<e>>>0?a:e)|0}function rt(a){a=a|0;return 1}function st(a,b){a=a|0;b=b|0;var d=0;c[a+4>>2]=b+-1;c[a>>2]=44304;o=0;b=ua(3)|0;d=o;o=0;if(d&1){d=Na()|0;Ya(d|0)}else{c[a+8>>2]=b;return}}function tt(a){a=a|0;wu(a);cj(a);return}
function xl(e,f,g,j,l){e=e|0;f=f|0;g=g|0;j=j|0;l=l|0;var m=0,n=0,o=0,p=0,q=0.0,r=0,s=0,t=0,u=0,v=0.0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0;ha=i;i=i+624|0;ca=ha+24|0;ea=ha+16|0;da=ha+588|0;Y=ha+576|0;ba=ha;V=ha+536|0;ga=ha+8|0;fa=ha+528|0;M=(e|0)!=0;N=V+40|0;U=N;V=V+39|0;W=ga+4|0;X=Y+12|0;Y=Y+11|0;Z=da;_=X;aa=_-Z|0;O=-2-Z|0;P=_+2|0;Q=ca+288|0;R=da+9|0;S=R;T=da+8|0;m=0;w=f;n=0;f=0;a:while(1){do if((m|0)>-1)if((n|0)>(2147483647-m|0)){c[(ck()|0)>>2]=75;m=-1;break}else{m=n+m|0;break}while(0);n=a[w>>0]|0;if(!(n<<24>>24)){L=245;break}else o=w;b:while(1){switch(n<<24>>24){case 37:{n=o;L=9;break b}case 0:{n=o;break b}default:{}}K=o+1|0;n=a[K>>0]|0;o=K}c:do if((L|0)==9)while(1){L=0;if((a[n+1>>0]|0)!=37)break c;o=o+1|0;n=n+2|0;if((a[n>>0]|0)==37)L=9;else break}while(0);y=o-w|0;if(M?(c[e>>2]&32|0)==0:0)Xk(w,y,e)|0;if((o|0)!=(w|0)){w=n;n=y;continue}r=n+1|0;o=a[r>>0]|0;p=(o<<24>>24)+-48|0;if(p>>>0<10){K=(a[n+2>>0]|0)==36;r=K?n+3|0:r;o=a[r>>0]|0;u=K?p:-1;f=K?1:f}else u=-1;n=o<<24>>24;d:do if((n&-32|0)==32){p=0;while(1){if(!(1<<n+-32&75913)){s=p;n=r;break d}p=1<<(o<<24>>24)+-32|p;r=r+1|0;o=a[r>>0]|0;n=o<<24>>24;if((n&-32|0)!=32){s=p;n=r;break}}}else{s=0;n=r}while(0);do if(o<<24>>24==42){p=n+1|0;o=(a[p>>0]|0)+-48|0;if(o>>>0<10?(a[n+2>>0]|0)==36:0){c[l+(o<<2)>>2]=10;f=1;n=n+3|0;o=c[j+((a[p>>0]|0)+-48<<3)>>2]|0}else{if(f){m=-1;break a}if(!M){x=s;n=p;f=0;K=0;break}f=(c[g>>2]|0)+(4-1)&~(4-1);o=c[f>>2]|0;c[g>>2]=f+4;f=0;n=p}if((o|0)<0){x=s|8192;K=0-o|0}else{x=s;K=o}}else{p=(o<<24>>24)+-48|0;if(p>>>0<10){o=0;do{o=(o*10|0)+p|0;n=n+1|0;p=(a[n>>0]|0)+-48|0}while(p>>>0<10);if((o|0)<0){m=-1;break a}else{x=s;K=o}}else{x=s;K=0}}while(0);e:do if((a[n>>0]|0)==46){p=n+1|0;o=a[p>>0]|0;if(o<<24>>24!=42){r=(o<<24>>24)+-48|0;if(r>>>0<10){n=p;o=0}else{n=p;r=0;break}while(1){o=(o*10|0)+r|0;n=n+1|0;r=(a[n>>0]|0)+-48|0;if(r>>>0>=10){r=o;break e}}}p=n+2|0;o=(a[p>>0]|0)+-48|0;if(o>>>0<10?(a[n+3>>0]|0)==36:0){c[l+(o<<2)>>2]=10;n=n+4|0;r=c[j+((a[p>>0]|0)+-48<<3)>>2]|0;break}if(f){m=-1;break a}if(M){n=(c[g>>2]|0)+(4-1)&~(4-1);r=c[n>>2]|0;c[g>>2]=n+4;n=p}else{n=p;r=0}}else r=-1;while(0);t=0;while(1){o=(a[n>>0]|0)+-65|0;if(o>>>0>57){m=-1;break a}p=n+1|0;o=a[56223+(t*58|0)+o>>0]|0;s=o&255;if((s+-1|0)>>>0<8){n=p;t=s}else{J=p;break}}if(!(o<<24>>24)){m=-1;break}p=(u|0)>-1;do if(o<<24>>24==19)if(p){m=-1;break a}else L=52;else{if(p){c[l+(u<<2)>>2]=s;H=j+(u<<3)|0;I=c[H+4>>2]|0;L=ba;c[L>>2]=c[H>>2];c[L+4>>2]=I;L=52;break}if(!M){m=0;break a}Cl(ba,s,g)}while(0);if((L|0)==52?(L=0,!M):0){w=J;n=y;continue}u=a[n>>0]|0;u=(t|0)!=0&(u&15|0)==3?u&-33:u;p=x&-65537;I=(x&8192|0)==0?x:p;f:do switch(u|0){case 110:switch(t|0){case 0:{c[c[ba>>2]>>2]=m;w=J;n=y;continue a}case 1:{c[c[ba>>2]>>2]=m;w=J;n=y;continue a}case 2:{w=c[ba>>2]|0;c[w>>2]=m;c[w+4>>2]=((m|0)<0)<<31>>31;w=J;n=y;continue a}case 3:{b[c[ba>>2]>>1]=m;w=J;n=y;continue a}case 4:{a[c[ba>>2]>>0]=m;w=J;n=y;continue a}case 6:{c[c[ba>>2]>>2]=m;w=J;n=y;continue a}case 7:{w=c[ba>>2]|0;c[w>>2]=m;c[w+4>>2]=((m|0)<0)<<31>>31;w=J;n=y;continue a}default:{w=J;n=y;continue a}}case 112:{t=I|8;r=r>>>0>8?r:8;u=120;L=64;break}case 88:case 120:{t=I;L=64;break}case 111:{p=ba;o=c[p>>2]|0;p=c[p+4>>2]|0;if((o|0)==0&(p|0)==0)n=N;else{n=N;do{n=n+-1|0;a[n>>0]=o&7|48;o=kw(o|0,p|0,3)|0;p=D}while(!((o|0)==0&(p|0)==0))}if(!(I&8)){o=I;t=0;s=56703;L=77}else{t=U-n+1|0;o=I;r=(r|0)<(t|0)?t:r;t=0;s=56703;L=77}break}case 105:case 100:{o=ba;n=c[o>>2]|0;o=c[o+4>>2]|0;if((o|0)<0){n=hw(0,0,n|0,o|0)|0;o=D;p=ba;c[p>>2]=n;c[p+4>>2]=o;p=1;s=56703;L=76;break f}if(!(I&2048)){s=I&1;p=s;s=(s|0)==0?56703:56705;L=76}else{p=1;s=56704;L=76}break}case 117:{o=ba;n=c[o>>2]|0;o=c[o+4>>2]|0;p=0;s=56703;L=76;break}case 99:{a[V>>0]=c[ba>>2];w=V;o=1;t=0;u=56703;n=N;break}case 109:{n=dk(c[(ck()|0)>>2]|0)|0;L=82;break}case 115:{n=c[ba>>2]|0;n=(n|0)!=0?n:56713;L=82;break}case 67:{c[ga>>2]=c[ba>>2];c[W>>2]=0;c[ba>>2]=ga;r=-1;L=86;break}case 83:{if(!r){El(e,32,K,0,I);n=0;L=98}else L=86;break}case 65:case 71:case 70:case 69:case 97:case 103:case 102:case 101:{q=+h[ba>>3];c[ea>>2]=0;h[k>>3]=q;if((c[k+4>>2]|0)>=0)if(!(I&2048)){H=I&1;G=H;H=(H|0)==0?56721:56726}else{G=1;H=56723}else{q=-q;G=1;H=56720}h[k>>3]=q;F=c[k+4>>2]&2146435072;do if(F>>>0<2146435072|(F|0)==2146435072&0<0){v=+wk(q,ea)*2.0;o=v!=0.0;if(o)c[ea>>2]=(c[ea>>2]|0)+-1;C=u|32;if((C|0)==97){w=u&32;y=(w|0)==0?H:H+9|0;x=G|2;n=12-r|0;do if(!(r>>>0>11|(n|0)==0)){q=8.0;do{n=n+-1|0;q=q*16.0}while((n|0)!=0);if((a[y>>0]|0)==45){q=-(q+(-v-q));break}else{q=v+q-q;break}}else q=v;while(0);o=c[ea>>2]|0;n=(o|0)<0?0-o|0:o;n=Dl(n,((n|0)<0)<<31>>31,X)|0;if((n|0)==(X|0)){a[Y>>0]=48;n=Y}a[n+-1>>0]=(o>>31&2)+43;t=n+-2|0;a[t>>0]=u+15;s=(r|0)<1;p=(I&8|0)==0;o=da;while(1){H=~~q;n=o+1|0;a[o>>0]=d[56687+H>>0]|w;q=(q-+(H|0))*16.0;do if((n-Z|0)==1){if(p&(s&q==0.0))break;a[n>>0]=46;n=o+2|0}while(0);if(!(q!=0.0))break;else o=n}r=(r|0)!=0&(O+n|0)<(r|0)?P+r-t|0:aa-t+n|0;p=r+x|0;El(e,32,K,p,I);if(!(c[e>>2]&32))Xk(y,x,e)|0;El(e,48,K,p,I^65536);n=n-Z|0;if(!(c[e>>2]&32))Xk(da,n,e)|0;o=_-t|0;El(e,48,r-(n+o)|0,0,0);if(!(c[e>>2]&32))Xk(t,o,e)|0;El(e,32,K,p,I^8192);n=(p|0)<(K|0)?K:p;break}n=(r|0)<0?6:r;if(o){o=(c[ea>>2]|0)+-28|0;c[ea>>2]=o;q=v*268435456.0}else{q=v;o=c[ea>>2]|0}F=(o|0)<0?ca:Q;E=F;o=F;do{B=~~q>>>0;c[o>>2]=B;o=o+4|0;q=(q-+(B>>>0))*1.0e9}while(q!=0.0);p=o;o=c[ea>>2]|0;if((o|0)>0){s=F;while(1){t=(o|0)>29?29:o;r=p+-4|0;do if(r>>>0<s>>>0)r=s;else{o=0;do{B=mw(c[r>>2]|0,0,t|0)|0;B=jw(B|0,D|0,o|0,0)|0;o=D;A=vw(B|0,o|0,1e9,0)|0;c[r>>2]=A;o=uw(B|0,o|0,1e9,0)|0;r=r+-4|0}while(r>>>0>=s>>>0);if(!o){r=s;break}r=s+-4|0;c[r>>2]=o}while(0);while(1){if(p>>>0<=r>>>0)break;o=p+-4|0;if(!(c[o>>2]|0))p=o;else break}o=(c[ea>>2]|0)-t|0;c[ea>>2]=o;if((o|0)>0)s=r;else break}}else r=F;if((o|0)<0){y=((n+25|0)/9|0)+1|0;z=(C|0)==102;w=r;while(1){x=0-o|0;x=(x|0)>9?9:x;do if(w>>>0<p>>>0){o=(1<<x)+-1|0;s=1e9>>>x;r=0;t=w;do{B=c[t>>2]|0;c[t>>2]=(B>>>x)+r;r=$(B&o,s)|0;t=t+4|0}while(t>>>0<p>>>0);o=(c[w>>2]|0)==0?w+4|0:w;if(!r){r=o;break}c[p>>2]=r;r=o;p=p+4|0}else r=(c[w>>2]|0)==0?w+4|0:w;while(0);o=z?F:r;p=(p-o>>2|0)>(y|0)?o+(y<<2)|0:p;o=(c[ea>>2]|0)+x|0;c[ea>>2]=o;if((o|0)>=0){w=r;break}else w=r}}else w=r;do if(w>>>0<p>>>0){o=(E-w>>2)*9|0;s=c[w>>2]|0;if(s>>>0<10)break;else r=10;do{r=r*10|0;o=o+1|0}while(s>>>0>=r>>>0)}else o=0;while(0);A=(C|0)==103;B=(n|0)!=0;r=n-((C|0)!=102?o:0)+((B&A)<<31>>31)|0;if((r|0)<(((p-E>>2)*9|0)+-9|0)){t=r+9216|0;z=(t|0)/9|0;r=F+(z+-1023<<2)|0;t=((t|0)%9|0)+1|0;if((t|0)<9){s=10;do{s=s*10|0;t=t+1|0}while((t|0)!=9)}else s=10;x=c[r>>2]|0;y=(x>>>0)%(s>>>0)|0;if((y|0)==0?(F+(z+-1022<<2)|0)==(p|0):0)s=w;else L=163;do if((L|0)==163){L=0;v=(((x>>>0)/(s>>>0)|0)&1|0)==0?9007199254740992.0:9007199254740994.0;t=(s|0)/2|0;do if(y>>>0<t>>>0)q=.5;else{if((y|0)==(t|0)?(F+(z+-1022<<2)|0)==(p|0):0){q=1.0;break}q=1.5}while(0);do if(G){if((a[H>>0]|0)!=45)break;v=-v;q=-q}while(0);t=x-y|0;c[r>>2]=t;if(!(v+q!=v)){s=w;break}C=t+s|0;c[r>>2]=C;if(C>>>0>999999999){o=w;while(1){s=r+-4|0;c[r>>2]=0;if(s>>>0<o>>>0){o=o+-4|0;c[o>>2]=0}C=(c[s>>2]|0)+1|0;c[s>>2]=C;if(C>>>0>999999999)r=s;else{w=o;r=s;break}}}o=(E-w>>2)*9|0;t=c[w>>2]|0;if(t>>>0<10){s=w;break}else s=10;do{s=s*10|0;o=o+1|0}while(t>>>0>=s>>>0);s=w}while(0);C=r+4|0;w=s;p=p>>>0>C>>>0?C:p}y=0-o|0;while(1){if(p>>>0<=w>>>0){z=0;C=p;break}r=p+-4|0;if(!(c[r>>2]|0))p=r;else{z=1;C=p;break}}do if(A){n=(B&1^1)+n|0;if((n|0)>(o|0)&(o|0)>-5){u=u+-1|0;n=n+-1-o|0}else{u=u+-2|0;n=n+-1|0}p=I&8;if(p)break;do if(z){p=c[C+-4>>2]|0;if(!p){r=9;break}if(!((p>>>0)%10|0)){s=10;r=0}else{r=0;break}do{s=s*10|0;r=r+1|0}while(((p>>>0)%(s>>>0)|0|0)==0)}else r=9;while(0);p=((C-E>>2)*9|0)+-9|0;if((u|32|0)==102){p=p-r|0;p=(p|0)<0?0:p;n=(n|0)<(p|0)?n:p;p=0;break}else{p=p+o-r|0;p=(p|0)<0?0:p;n=(n|0)<(p|0)?n:p;p=0;break}}else p=I&8;while(0);x=n|p;s=(x|0)!=0&1;t=(u|32|0)==102;if(t){o=(o|0)>0?o:0;u=0}else{r=(o|0)<0?y:o;r=Dl(r,((r|0)<0)<<31>>31,X)|0;if((_-r|0)<2)do{r=r+-1|0;a[r>>0]=48}while((_-r|0)<2);a[r+-1>>0]=(o>>31&2)+43;E=r+-2|0;a[E>>0]=u;o=_-E|0;u=E}y=G+1+n+s+o|0;El(e,32,K,y,I);if(!(c[e>>2]&32))Xk(H,G,e)|0;El(e,48,K,y,I^65536);do if(t){r=w>>>0>F>>>0?F:w;o=r;do{p=Dl(c[o>>2]|0,0,R)|0;do if((o|0)==(r|0)){if((p|0)!=(R|0))break;a[T>>0]=48;p=T}else{if(p>>>0<=da>>>0)break;do{p=p+-1|0;a[p>>0]=48}while(p>>>0>da>>>0)}while(0);if(!(c[e>>2]&32))Xk(p,S-p|0,e)|0;o=o+4|0}while(o>>>0<=F>>>0);do if(x){if(c[e>>2]&32)break;Xk(56755,1,e)|0}while(0);if((n|0)>0&o>>>0<C>>>0){p=o;while(1){o=Dl(c[p>>2]|0,0,R)|0;if(o>>>0>da>>>0)do{o=o+-1|0;a[o>>0]=48}while(o>>>0>da>>>0);if(!(c[e>>2]&32))Xk(o,(n|0)>9?9:n,e)|0;p=p+4|0;o=n+-9|0;if(!((n|0)>9&p>>>0<C>>>0)){n=o;break}else n=o}}El(e,48,n+9|0,9,0)}else{t=z?C:w+4|0;if((n|0)>-1){s=(p|0)==0;r=w;do{o=Dl(c[r>>2]|0,0,R)|0;if((o|0)==(R|0)){a[T>>0]=48;o=T}do if((r|0)==(w|0)){p=o+1|0;if(!(c[e>>2]&32))Xk(o,1,e)|0;if(s&(n|0)<1){o=p;break}if(c[e>>2]&32){o=p;break}Xk(56755,1,e)|0;o=p}else{if(o>>>0<=da>>>0)break;do{o=o+-1|0;a[o>>0]=48}while(o>>>0>da>>>0)}while(0);p=S-o|0;if(!(c[e>>2]&32))Xk(o,(n|0)>(p|0)?p:n,e)|0;n=n-p|0;r=r+4|0}while(r>>>0<t>>>0&(n|0)>-1)}El(e,48,n+18|0,18,0);if(c[e>>2]&32)break;Xk(u,_-u|0,e)|0}while(0);El(e,32,K,y,I^8192);n=(y|0)<(K|0)?K:y}else{t=(u&32|0)!=0;s=q!=q|0.0!=0.0;o=s?0:G;r=o+3|0;El(e,32,K,r,p);n=c[e>>2]|0;if(!(n&32)){Xk(H,o,e)|0;n=c[e>>2]|0}if(!(n&32))Xk(s?(t?56747:56751):t?56739:56743,3,e)|0;El(e,32,K,r,I^8192);n=(r|0)<(K|0)?K:r}while(0);w=J;continue a}default:{p=I;o=r;t=0;u=56703;n=N}}while(0);g:do if((L|0)==64){p=ba;o=c[p>>2]|0;p=c[p+4>>2]|0;s=u&32;if(!((o|0)==0&(p|0)==0)){n=N;do{n=n+-1|0;a[n>>0]=d[56687+(o&15)>>0]|s;o=kw(o|0,p|0,4)|0;p=D}while(!((o|0)==0&(p|0)==0));L=ba;if((t&8|0)==0|(c[L>>2]|0)==0&(c[L+4>>2]|0)==0){o=t;t=0;s=56703;L=77}else{o=t;t=2;s=56703+(u>>4)|0;L=77}}else{n=N;o=t;t=0;s=56703;L=77}}else if((L|0)==76){n=Dl(n,o,N)|0;o=I;t=p;L=77}else if((L|0)==82){L=0;I=jl(n,0,r)|0;H=(I|0)==0;w=n;o=H?r:I-n|0;t=0;u=56703;n=H?n+r|0:I}else if((L|0)==86){L=0;o=0;n=0;s=c[ba>>2]|0;while(1){p=c[s>>2]|0;if(!p)break;n=Ik(fa,p)|0;if((n|0)<0|n>>>0>(r-o|0)>>>0)break;o=n+o|0;if(r>>>0>o>>>0)s=s+4|0;else break}if((n|0)<0){m=-1;break a}El(e,32,K,o,I);if(!o){n=0;L=98}else{p=0;r=c[ba>>2]|0;while(1){n=c[r>>2]|0;if(!n){n=o;L=98;break g}n=Ik(fa,n)|0;p=n+p|0;if((p|0)>(o|0)){n=o;L=98;break g}if(!(c[e>>2]&32))Xk(fa,n,e)|0;if(p>>>0>=o>>>0){n=o;L=98;break}else r=r+4|0}}}while(0);if((L|0)==98){L=0;El(e,32,K,n,I^8192);w=J;n=(K|0)>(n|0)?K:n;continue}if((L|0)==77){L=0;p=(r|0)>-1?o&-65537:o;o=ba;o=(c[o>>2]|0)!=0|(c[o+4>>2]|0)!=0;if((r|0)!=0|o){o=(o&1^1)+(U-n)|0;w=n;o=(r|0)>(o|0)?r:o;u=s;n=N}else{w=N;o=0;u=s;n=N}}s=n-w|0;o=(o|0)<(s|0)?s:o;r=t+o|0;n=(K|0)<(r|0)?r:K;El(e,32,n,r,p);if(!(c[e>>2]&32))Xk(u,t,e)|0;El(e,48,n,r,p^65536);El(e,48,o,s,0);if(!(c[e>>2]&32))Xk(w,s,e)|0;El(e,32,n,r,p^8192);w=J}h:do if((L|0)==245)if(!e)if(f){m=1;while(1){f=c[l+(m<<2)>>2]|0;if(!f)break;Cl(j+(m<<3)|0,f,g);m=m+1|0;if((m|0)>=10){m=1;break h}}if((m|0)<10)while(1){if(c[l+(m<<2)>>2]|0){m=-1;break h}m=m+1|0;if((m|0)>=10){m=1;break}}else m=1}else m=0;while(0);i=ha;return m|0}function yl(a,b,c){a=a|0;b=b|0;c=c|0;return Rk(a,b,c)|0}function zl(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0,g=0,h=0,j=0;j=i;i=i+112|0;h=j;f=h;g=f+112|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(g|0));f=h+4|0;c[f>>2]=a;g=h+8|0;c[g>>2]=-1;c[h+44>>2]=a;c[h+76>>2]=-1;gk(h,0);e=+ek(h,d,1);d=(c[f>>2]|0)-(c[g>>2]|0)+(c[h+108>>2]|0)|0;if(b)c[b>>2]=(d|0)!=0?a+d|0:a;i=j;return +e}function Al(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0;k=i;i=i+112|0;j=k;c[j>>2]=0;g=j+4|0;c[g>>2]=a;c[j+44>>2]=a;h=j+8|0;c[h>>2]=(a|0)<0?-1:a+2147483647|0;c[j+76>>2]=-1;gk(j,0);e=fk(j,d,1,e,f)|0;if(b)c[b>>2]=a+((c[g>>2]|0)+(c[j+108>>2]|0)-(c[h>>2]|0));i=k;return e|0}function Bl(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=a+20|0;f=c[e>>2]|0;a=(c[a+16>>2]|0)-f|0;a=a>>>0>d>>>0?d:a;lw(f|0,b|0,a|0)|0;c[e>>2]=(c[e>>2]|0)+a;return d|0}function Cl(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0.0;a:do if(b>>>0<=20)do switch(b|0){case 9:{e=(c[d>>2]|0)+(4-1)&~(4-1);b=c[e>>2]|0;c[d>>2]=e+4;c[a>>2]=b;break a}case 10:{e=(c[d>>2]|0)+(4-1)&~(4-1);b=c[e>>2]|0;c[d>>2]=e+4;e=a;c[e>>2]=b;c[e+4>>2]=((b|0)<0)<<31>>31;break a}case 11:{e=(c[d>>2]|0)+(4-1)&~(4-1);b=c[e>>2]|0;c[d>>2]=e+4;e=a;c[e>>2]=b;c[e+4>>2]=0;break a}case 12:{e=(c[d>>2]|0)+(8-1)&~(8-1);b=e;f=c[b>>2]|0;b=c[b+4>>2]|0;c[d>>2]=e+8;e=a;c[e>>2]=f;c[e+4>>2]=b;break a}case 13:{f=(c[d>>2]|0)+(4-1)&~(4-1);e=c[f>>2]|0;c[d>>2]=f+4;e=(e&65535)<<16>>16;f=a;c[f>>2]=e;c[f+4>>2]=((e|0)<0)<<31>>31;break a}case 14:{f=(c[d>>2]|0)+(4-1)&~(4-1);e=c[f>>2]|0;c[d>>2]=f+4;f=a;c[f>>2]=e&65535;c[f+4>>2]=0;break a}case 15:{f=(c[d>>2]|0)+(4-1)&~(4-1);e=c[f>>2]|0;c[d>>2]=f+4;e=(e&255)<<24>>24;f=a;c[f>>2]=e;c[f+4>>2]=((e|0)<0)<<31>>31;break a}case 16:{f=(c[d>>2]|0)+(4-1)&~(4-1);e=c[f>>2]|0;c[d>>2]=f+4;f=a;c[f>>2]=e&255;c[f+4>>2]=0;break a}case 17:{f=(c[d>>2]|0)+(8-1)&~(8-1);g=+h[f>>3];c[d>>2]=f+8;h[a>>3]=g;break a}case 18:{f=(c[d>>2]|0)+(8-1)&~(8-1);g=+h[f>>3];c[d>>2]=f+8;h[a>>3]=g;break a}default:break a}while(0);while(0);return}function Dl(b,c,d){b=b|0;c=c|0;d=d|0;var e=0;if(c>>>0>0|(c|0)==0&b>>>0>4294967295)while(1){e=vw(b|0,c|0,10,0)|0;d=d+-1|0;a[d>>0]=e|48;e=uw(b|0,c|0,10,0)|0;if(c>>>0>9|(c|0)==9&b>>>0>4294967295){b=e;c=D}else{b=e;break}}if(b)while(1){d=d+-1|0;a[d>>0]=(b>>>0)%10|0|48;if(b>>>0<10)break;else b=(b>>>0)/10|0}return d|0}function El(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0;j=i;i=i+256|0;h=j;do if((d|0)>(e|0)&(f&73728|0)==0){f=d-e|0;iw(h|0,b|0,(f>>>0>256?256:f)|0)|0;b=c[a>>2]|0;g=(b&32|0)==0;if(f>>>0>255){e=d-e|0;do{if(g){Xk(h,256,a)|0;b=c[a>>2]|0}f=f+-256|0;g=(b&32|0)==0}while(f>>>0>255);if(g)f=e&255;else break}else if(!g)break;Xk(h,f,a)|0}while(0);i=j;return}function Fl(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0;do if(a>>>0<245){o=a>>>0<11?16:a+11&-8;a=o>>>3;i=c[10218]|0;d=i>>>a;if(d&3){a=(d&1^1)+a|0;e=a<<1;d=40912+(e<<2)|0;e=40912+(e+2<<2)|0;f=c[e>>2]|0;g=f+8|0;h=c[g>>2]|0;do if((d|0)!=(h|0)){if(h>>>0<(c[10222]|0)>>>0)Ga();b=h+12|0;if((c[b>>2]|0)==(f|0)){c[b>>2]=d;c[e>>2]=h;break}else Ga()}else c[10218]=i&~(1<<a);while(0);M=a<<3;c[f+4>>2]=M|3;M=f+(M|4)|0;c[M>>2]=c[M>>2]|1;M=g;return M|0}h=c[10220]|0;if(o>>>0>h>>>0){if(d){e=2<<a;e=d<<a&(e|0-e);e=(e&0-e)+-1|0;j=e>>>12&16;e=e>>>j;f=e>>>5&8;e=e>>>f;g=e>>>2&4;e=e>>>g;d=e>>>1&2;e=e>>>d;a=e>>>1&1;a=(f|j|g|d|a)+(e>>>a)|0;e=a<<1;d=40912+(e<<2)|0;e=40912+(e+2<<2)|0;g=c[e>>2]|0;j=g+8|0;f=c[j>>2]|0;do if((d|0)!=(f|0)){if(f>>>0<(c[10222]|0)>>>0)Ga();b=f+12|0;if((c[b>>2]|0)==(g|0)){c[b>>2]=d;c[e>>2]=f;k=c[10220]|0;break}else Ga()}else{c[10218]=i&~(1<<a);k=h}while(0);M=a<<3;h=M-o|0;c[g+4>>2]=o|3;i=g+o|0;c[g+(o|4)>>2]=h|1;c[g+M>>2]=h;if(k){f=c[10223]|0;d=k>>>3;b=d<<1;e=40912+(b<<2)|0;a=c[10218]|0;d=1<<d;if(a&d){a=40912+(b+2<<2)|0;b=c[a>>2]|0;if(b>>>0<(c[10222]|0)>>>0)Ga();else{l=a;m=b}}else{c[10218]=a|d;l=40912+(b+2<<2)|0;m=e}c[l>>2]=f;c[m+12>>2]=f;c[f+8>>2]=m;c[f+12>>2]=e}c[10220]=h;c[10223]=i;M=j;return M|0}a=c[10219]|0;if(a){d=(a&0-a)+-1|0;L=d>>>12&16;d=d>>>L;K=d>>>5&8;d=d>>>K;M=d>>>2&4;d=d>>>M;a=d>>>1&2;d=d>>>a;e=d>>>1&1;e=c[41176+((K|L|M|a|e)+(d>>>e)<<2)>>2]|0;d=(c[e+4>>2]&-8)-o|0;a=e;while(1){b=c[a+16>>2]|0;if(!b){b=c[a+20>>2]|0;if(!b){j=d;break}}a=(c[b+4>>2]&-8)-o|0;M=a>>>0<d>>>0;d=M?a:d;a=b;e=M?b:e}g=c[10222]|0;if(e>>>0<g>>>0)Ga();i=e+o|0;if(e>>>0>=i>>>0)Ga();h=c[e+24>>2]|0;d=c[e+12>>2]|0;do if((d|0)==(e|0)){a=e+20|0;b=c[a>>2]|0;if(!b){a=e+16|0;b=c[a>>2]|0;if(!b){n=0;break}}while(1){d=b+20|0;f=c[d>>2]|0;if(f){b=f;a=d;continue}d=b+16|0;f=c[d>>2]|0;if(!f)break;else{b=f;a=d}}if(a>>>0<g>>>0)Ga();else{c[a>>2]=0;n=b;break}}else{f=c[e+8>>2]|0;if(f>>>0<g>>>0)Ga();b=f+12|0;if((c[b>>2]|0)!=(e|0))Ga();a=d+8|0;if((c[a>>2]|0)==(e|0)){c[b>>2]=d;c[a>>2]=f;n=d;break}else Ga()}while(0);do if(h){b=c[e+28>>2]|0;a=41176+(b<<2)|0;if((e|0)==(c[a>>2]|0)){c[a>>2]=n;if(!n){c[10219]=c[10219]&~(1<<b);break}}else{if(h>>>0<(c[10222]|0)>>>0)Ga();b=h+16|0;if((c[b>>2]|0)==(e|0))c[b>>2]=n;else c[h+20>>2]=n;if(!n)break}a=c[10222]|0;if(n>>>0<a>>>0)Ga();c[n+24>>2]=h;b=c[e+16>>2]|0;do if(b)if(b>>>0<a>>>0)Ga();else{c[n+16>>2]=b;c[b+24>>2]=n;break}while(0);b=c[e+20>>2]|0;if(b)if(b>>>0<(c[10222]|0)>>>0)Ga();else{c[n+20>>2]=b;c[b+24>>2]=n;break}}while(0);if(j>>>0<16){M=j+o|0;c[e+4>>2]=M|3;M=e+(M+4)|0;c[M>>2]=c[M>>2]|1}else{c[e+4>>2]=o|3;c[e+(o|4)>>2]=j|1;c[e+(j+o)>>2]=j;b=c[10220]|0;if(b){g=c[10223]|0;d=b>>>3;b=d<<1;f=40912+(b<<2)|0;a=c[10218]|0;d=1<<d;if(a&d){b=40912+(b+2<<2)|0;a=c[b>>2]|0;if(a>>>0<(c[10222]|0)>>>0)Ga();else{p=b;q=a}}else{c[10218]=a|d;p=40912+(b+2<<2)|0;q=f}c[p>>2]=g;c[q+12>>2]=g;c[g+8>>2]=q;c[g+12>>2]=f}c[10220]=j;c[10223]=i}M=e+8|0;return M|0}else q=o}else q=o}else if(a>>>0<=4294967231){a=a+11|0;m=a&-8;l=c[10219]|0;if(l){d=0-m|0;a=a>>>8;if(a)if(m>>>0>16777215)k=31;else{q=(a+1048320|0)>>>16&8;v=a<<q;p=(v+520192|0)>>>16&4;v=v<<p;k=(v+245760|0)>>>16&2;k=14-(p|q|k)+(v<<k>>>15)|0;k=m>>>(k+7|0)&1|k<<1}else k=0;a=c[41176+(k<<2)>>2]|0;a:do if(!a){f=0;a=0;v=86}else{h=d;f=0;i=m<<((k|0)==31?0:25-(k>>>1)|0);j=a;a=0;while(1){g=c[j+4>>2]&-8;d=g-m|0;if(d>>>0<h>>>0)if((g|0)==(m|0)){g=j;a=j;v=90;break a}else a=j;else d=h;v=c[j+20>>2]|0;j=c[j+16+(i>>>31<<2)>>2]|0;f=(v|0)==0|(v|0)==(j|0)?f:v;if(!j){v=86;break}else{h=d;i=i<<1}}}while(0);if((v|0)==86){if((f|0)==0&(a|0)==0){a=2<<k;a=l&(a|0-a);if(!a){q=m;break}a=(a&0-a)+-1|0;n=a>>>12&16;a=a>>>n;l=a>>>5&8;a=a>>>l;p=a>>>2&4;a=a>>>p;q=a>>>1&2;a=a>>>q;f=a>>>1&1;f=c[41176+((l|n|p|q|f)+(a>>>f)<<2)>>2]|0;a=0}if(!f){i=d;j=a}else{g=f;v=90}}if((v|0)==90)while(1){v=0;q=(c[g+4>>2]&-8)-m|0;f=q>>>0<d>>>0;d=f?q:d;a=f?g:a;f=c[g+16>>2]|0;if(f){g=f;v=90;continue}g=c[g+20>>2]|0;if(!g){i=d;j=a;break}else v=90}if((j|0)!=0?i>>>0<((c[10220]|0)-m|0)>>>0:0){f=c[10222]|0;if(j>>>0<f>>>0)Ga();h=j+m|0;if(j>>>0>=h>>>0)Ga();g=c[j+24>>2]|0;d=c[j+12>>2]|0;do if((d|0)==(j|0)){a=j+20|0;b=c[a>>2]|0;if(!b){a=j+16|0;b=c[a>>2]|0;if(!b){o=0;break}}while(1){d=b+20|0;e=c[d>>2]|0;if(e){b=e;a=d;continue}d=b+16|0;e=c[d>>2]|0;if(!e)break;else{b=e;a=d}}if(a>>>0<f>>>0)Ga();else{c[a>>2]=0;o=b;break}}else{e=c[j+8>>2]|0;if(e>>>0<f>>>0)Ga();b=e+12|0;if((c[b>>2]|0)!=(j|0))Ga();a=d+8|0;if((c[a>>2]|0)==(j|0)){c[b>>2]=d;c[a>>2]=e;o=d;break}else Ga()}while(0);do if(g){b=c[j+28>>2]|0;a=41176+(b<<2)|0;if((j|0)==(c[a>>2]|0)){c[a>>2]=o;if(!o){c[10219]=c[10219]&~(1<<b);break}}else{if(g>>>0<(c[10222]|0)>>>0)Ga();b=g+16|0;if((c[b>>2]|0)==(j|0))c[b>>2]=o;else c[g+20>>2]=o;if(!o)break}a=c[10222]|0;if(o>>>0<a>>>0)Ga();c[o+24>>2]=g;b=c[j+16>>2]|0;do if(b)if(b>>>0<a>>>0)Ga();else{c[o+16>>2]=b;c[b+24>>2]=o;break}while(0);b=c[j+20>>2]|0;if(b)if(b>>>0<(c[10222]|0)>>>0)Ga();else{c[o+20>>2]=b;c[b+24>>2]=o;break}}while(0);b:do if(i>>>0>=16){c[j+4>>2]=m|3;c[j+(m|4)>>2]=i|1;c[j+(i+m)>>2]=i;b=i>>>3;if(i>>>0<256){a=b<<1;e=40912+(a<<2)|0;d=c[10218]|0;b=1<<b;if(d&b){b=40912+(a+2<<2)|0;a=c[b>>2]|0;if(a>>>0<(c[10222]|0)>>>0)Ga();else{s=b;t=a}}else{c[10218]=d|b;s=40912+(a+2<<2)|0;t=e}c[s>>2]=h;c[t+12>>2]=h;c[j+(m+8)>>2]=t;c[j+(m+12)>>2]=e;break}b=i>>>8;if(b)if(i>>>0>16777215)e=31;else{L=(b+1048320|0)>>>16&8;M=b<<L;K=(M+520192|0)>>>16&4;M=M<<K;e=(M+245760|0)>>>16&2;e=14-(K|L|e)+(M<<e>>>15)|0;e=i>>>(e+7|0)&1|e<<1}else e=0;b=41176+(e<<2)|0;c[j+(m+28)>>2]=e;c[j+(m+20)>>2]=0;c[j+(m+16)>>2]=0;a=c[10219]|0;d=1<<e;if(!(a&d)){c[10219]=a|d;c[b>>2]=h;c[j+(m+24)>>2]=b;c[j+(m+12)>>2]=h;c[j+(m+8)>>2]=h;break}b=c[b>>2]|0;c:do if((c[b+4>>2]&-8|0)!=(i|0)){e=i<<((e|0)==31?0:25-(e>>>1)|0);while(1){a=b+16+(e>>>31<<2)|0;d=c[a>>2]|0;if(!d)break;if((c[d+4>>2]&-8|0)==(i|0)){y=d;break c}else{e=e<<1;b=d}}if(a>>>0<(c[10222]|0)>>>0)Ga();else{c[a>>2]=h;c[j+(m+24)>>2]=b;c[j+(m+12)>>2]=h;c[j+(m+8)>>2]=h;break b}}else y=b;while(0);b=y+8|0;a=c[b>>2]|0;M=c[10222]|0;if(a>>>0>=M>>>0&y>>>0>=M>>>0){c[a+12>>2]=h;c[b>>2]=h;c[j+(m+8)>>2]=a;c[j+(m+12)>>2]=y;c[j+(m+24)>>2]=0;break}else Ga()}else{M=i+m|0;c[j+4>>2]=M|3;M=j+(M+4)|0;c[M>>2]=c[M>>2]|1}while(0);M=j+8|0;return M|0}else q=m}else q=m}else q=-1;while(0);d=c[10220]|0;if(d>>>0>=q>>>0){b=d-q|0;a=c[10223]|0;if(b>>>0>15){c[10223]=a+q;c[10220]=b;c[a+(q+4)>>2]=b|1;c[a+d>>2]=b;c[a+4>>2]=q|3}else{c[10220]=0;c[10223]=0;c[a+4>>2]=d|3;M=a+(d+4)|0;c[M>>2]=c[M>>2]|1}M=a+8|0;return M|0}a=c[10221]|0;if(a>>>0>q>>>0){L=a-q|0;c[10221]=L;M=c[10224]|0;c[10224]=M+q;c[M+(q+4)>>2]=L|1;c[M+4>>2]=q|3;M=M+8|0;return M|0}do if(!(c[10336]|0)){a=_a(30)|0;if(!(a+-1&a)){c[10338]=a;c[10337]=a;c[10339]=-1;c[10340]=-1;c[10341]=0;c[10329]=0;c[10336]=(qb(0)|0)&-16^1431655768;break}else Ga()}while(0);j=q+48|0;i=c[10338]|0;k=q+47|0;h=i+k|0;i=0-i|0;l=h&i;if(l>>>0<=q>>>0){M=0;return M|0}a=c[10328]|0;if((a|0)!=0?(t=c[10326]|0,y=t+l|0,y>>>0<=t>>>0|y>>>0>a>>>0):0){M=0;return M|0}d:do if(!(c[10329]&4)){a=c[10224]|0;e:do if(a){f=41320;while(1){d=c[f>>2]|0;if(d>>>0<=a>>>0?(r=f+4|0,(d+(c[r>>2]|0)|0)>>>0>a>>>0):0){g=f;a=r;break}f=c[f+8>>2]|0;if(!f){v=174;break e}}d=h-(c[10221]|0)&i;if(d>>>0<2147483647){f=Ua(d|0)|0;y=(f|0)==((c[g>>2]|0)+(c[a>>2]|0)|0);a=y?d:0;if(y){if((f|0)!=(-1|0)){w=f;p=a;v=194;break d}}else v=184}else a=0}else v=174;while(0);do if((v|0)==174){g=Ua(0)|0;if((g|0)!=(-1|0)){a=g;d=c[10337]|0;f=d+-1|0;if(!(f&a))d=l;else d=l-a+(f+a&0-d)|0;a=c[10326]|0;f=a+d|0;if(d>>>0>q>>>0&d>>>0<2147483647){y=c[10328]|0;if((y|0)!=0?f>>>0<=a>>>0|f>>>0>y>>>0:0){a=0;break}f=Ua(d|0)|0;y=(f|0)==(g|0);a=y?d:0;if(y){w=g;p=a;v=194;break d}else v=184}else a=0}else a=0}while(0);f:do if((v|0)==184){g=0-d|0;do if(j>>>0>d>>>0&(d>>>0<2147483647&(f|0)!=(-1|0))?(u=c[10338]|0,u=k-d+u&0-u,u>>>0<2147483647):0)if((Ua(u|0)|0)==(-1|0)){Ua(g|0)|0;break f}else{d=u+d|0;break}while(0);if((f|0)!=(-1|0)){w=f;p=d;v=194;break d}}while(0);c[10329]=c[10329]|4;v=191}else{a=0;v=191}while(0);if((((v|0)==191?l>>>0<2147483647:0)?(w=Ua(l|0)|0,x=Ua(0)|0,w>>>0<x>>>0&((w|0)!=(-1|0)&(x|0)!=(-1|0))):0)?(z=x-w|0,A=z>>>0>(q+40|0)>>>0,A):0){p=A?z:a;v=194}if((v|0)==194){a=(c[10326]|0)+p|0;c[10326]=a;if(a>>>0>(c[10327]|0)>>>0)c[10327]=a;h=c[10224]|0;g:do if(h){g=41320;do{a=c[g>>2]|0;d=g+4|0;f=c[d>>2]|0;if((w|0)==(a+f|0)){B=a;C=d;D=f;E=g;v=204;break}g=c[g+8>>2]|0}while((g|0)!=0);if(((v|0)==204?(c[E+12>>2]&8|0)==0:0)?h>>>0<w>>>0&h>>>0>=B>>>0:0){c[C>>2]=D+p;M=(c[10221]|0)+p|0;L=h+8|0;L=(L&7|0)==0?0:0-L&7;K=M-L|0;c[10224]=h+L;c[10221]=K;c[h+(L+4)>>2]=K|1;c[h+(M+4)>>2]=40;c[10225]=c[10340];break}a=c[10222]|0;if(w>>>0<a>>>0){c[10222]=w;a=w}d=w+p|0;g=41320;while(1){if((c[g>>2]|0)==(d|0)){f=g;d=g;v=212;break}g=c[g+8>>2]|0;if(!g){d=41320;break}}if((v|0)==212)if(!(c[d+12>>2]&8)){c[f>>2]=w;n=d+4|0;c[n>>2]=(c[n>>2]|0)+p;n=w+8|0;n=(n&7|0)==0?0:0-n&7;k=w+(p+8)|0;k=(k&7|0)==0?0:0-k&7;b=w+(k+p)|0;m=n+q|0;o=w+m|0;l=b-(w+n)-q|0;c[w+(n+4)>>2]=q|3;h:do if((b|0)!=(h|0)){if((b|0)==(c[10223]|0)){M=(c[10220]|0)+l|0;c[10220]=M;c[10223]=o;c[w+(m+4)>>2]=M|1;c[w+(M+m)>>2]=M;break}i=p+4|0;d=c[w+(i+k)>>2]|0;if((d&3|0)==1){j=d&-8;g=d>>>3;i:do if(d>>>0>=256){h=c[w+((k|24)+p)>>2]|0;e=c[w+(p+12+k)>>2]|0;do if((e|0)==(b|0)){f=k|16;e=w+(i+f)|0;d=c[e>>2]|0;if(!d){e=w+(f+p)|0;d=c[e>>2]|0;if(!d){J=0;break}}while(1){f=d+20|0;g=c[f>>2]|0;if(g){d=g;e=f;continue}f=d+16|0;g=c[f>>2]|0;if(!g)break;else{d=g;e=f}}if(e>>>0<a>>>0)Ga();else{c[e>>2]=0;J=d;break}}else{f=c[w+((k|8)+p)>>2]|0;if(f>>>0<a>>>0)Ga();a=f+12|0;if((c[a>>2]|0)!=(b|0))Ga();d=e+8|0;if((c[d>>2]|0)==(b|0)){c[a>>2]=e;c[d>>2]=f;J=e;break}else Ga()}while(0);if(!h)break;a=c[w+(p+28+k)>>2]|0;d=41176+(a<<2)|0;do if((b|0)!=(c[d>>2]|0)){if(h>>>0<(c[10222]|0)>>>0)Ga();a=h+16|0;if((c[a>>2]|0)==(b|0))c[a>>2]=J;else c[h+20>>2]=J;if(!J)break i}else{c[d>>2]=J;if(J)break;c[10219]=c[10219]&~(1<<a);break i}while(0);d=c[10222]|0;if(J>>>0<d>>>0)Ga();c[J+24>>2]=h;b=k|16;a=c[w+(b+p)>>2]|0;do if(a)if(a>>>0<d>>>0)Ga();else{c[J+16>>2]=a;c[a+24>>2]=J;break}while(0);b=c[w+(i+b)>>2]|0;if(!b)break;if(b>>>0<(c[10222]|0)>>>0)Ga();else{c[J+20>>2]=b;c[b+24>>2]=J;break}}else{e=c[w+((k|8)+p)>>2]|0;f=c[w+(p+12+k)>>2]|0;d=40912+(g<<1<<2)|0;do if((e|0)!=(d|0)){if(e>>>0<a>>>0)Ga();if((c[e+12>>2]|0)==(b|0))break;Ga()}while(0);if((f|0)==(e|0)){c[10218]=c[10218]&~(1<<g);break}do if((f|0)==(d|0))F=f+8|0;else{if(f>>>0<a>>>0)Ga();a=f+8|0;if((c[a>>2]|0)==(b|0)){F=a;break}Ga()}while(0);c[e+12>>2]=f;c[F>>2]=e}while(0);b=w+((j|k)+p)|0;f=j+l|0}else f=l;b=b+4|0;c[b>>2]=c[b>>2]&-2;c[w+(m+4)>>2]=f|1;c[w+(f+m)>>2]=f;b=f>>>3;if(f>>>0<256){a=b<<1;e=40912+(a<<2)|0;d=c[10218]|0;b=1<<b;do if(!(d&b)){c[10218]=d|b;K=40912+(a+2<<2)|0;L=e}else{b=40912+(a+2<<2)|0;a=c[b>>2]|0;if(a>>>0>=(c[10222]|0)>>>0){K=b;L=a;break}Ga()}while(0);c[K>>2]=o;c[L+12>>2]=o;c[w+(m+8)>>2]=L;c[w+(m+12)>>2]=e;break}b=f>>>8;do if(!b)e=0;else{if(f>>>0>16777215){e=31;break}K=(b+1048320|0)>>>16&8;L=b<<K;J=(L+520192|0)>>>16&4;L=L<<J;e=(L+245760|0)>>>16&2;e=14-(J|K|e)+(L<<e>>>15)|0;e=f>>>(e+7|0)&1|e<<1}while(0);b=41176+(e<<2)|0;c[w+(m+28)>>2]=e;c[w+(m+20)>>2]=0;c[w+(m+16)>>2]=0;a=c[10219]|0;d=1<<e;if(!(a&d)){c[10219]=a|d;c[b>>2]=o;c[w+(m+24)>>2]=b;c[w+(m+12)>>2]=o;c[w+(m+8)>>2]=o;break}b=c[b>>2]|0;j:do if((c[b+4>>2]&-8|0)!=(f|0)){e=f<<((e|0)==31?0:25-(e>>>1)|0);while(1){a=b+16+(e>>>31<<2)|0;d=c[a>>2]|0;if(!d)break;if((c[d+4>>2]&-8|0)==(f|0)){M=d;break j}else{e=e<<1;b=d}}if(a>>>0<(c[10222]|0)>>>0)Ga();else{c[a>>2]=o;c[w+(m+24)>>2]=b;c[w+(m+12)>>2]=o;c[w+(m+8)>>2]=o;break h}}else M=b;while(0);b=M+8|0;a=c[b>>2]|0;L=c[10222]|0;if(a>>>0>=L>>>0&M>>>0>=L>>>0){c[a+12>>2]=o;c[b>>2]=o;c[w+(m+8)>>2]=a;c[w+(m+12)>>2]=M;c[w+(m+24)>>2]=0;break}else Ga()}else{M=(c[10221]|0)+l|0;c[10221]=M;c[10224]=o;c[w+(m+4)>>2]=M|1}while(0);M=w+(n|8)|0;return M|0}else d=41320;while(1){a=c[d>>2]|0;if(a>>>0<=h>>>0?(b=c[d+4>>2]|0,e=a+b|0,e>>>0>h>>>0):0)break;d=c[d+8>>2]|0}f=a+(b+-39)|0;a=a+(b+-47+((f&7|0)==0?0:0-f&7))|0;f=h+16|0;a=a>>>0<f>>>0?h:a;b=a+8|0;d=w+8|0;d=(d&7|0)==0?0:0-d&7;M=p+-40-d|0;c[10224]=w+d;c[10221]=M;c[w+(d+4)>>2]=M|1;c[w+(p+-36)>>2]=40;c[10225]=c[10340];d=a+4|0;c[d>>2]=27;c[b>>2]=c[10330];c[b+4>>2]=c[10331];c[b+8>>2]=c[10332];c[b+12>>2]=c[10333];c[10330]=w;c[10331]=p;c[10333]=0;c[10332]=b;b=a+28|0;c[b>>2]=7;if((a+32|0)>>>0<e>>>0)do{M=b;b=b+4|0;c[b>>2]=7}while((M+8|0)>>>0<e>>>0);if((a|0)!=(h|0)){g=a-h|0;c[d>>2]=c[d>>2]&-2;c[h+4>>2]=g|1;c[a>>2]=g;b=g>>>3;if(g>>>0<256){a=b<<1;e=40912+(a<<2)|0;d=c[10218]|0;b=1<<b;if(d&b){b=40912+(a+2<<2)|0;a=c[b>>2]|0;if(a>>>0<(c[10222]|0)>>>0)Ga();else{G=b;H=a}}else{c[10218]=d|b;G=40912+(a+2<<2)|0;H=e}c[G>>2]=h;c[H+12>>2]=h;c[h+8>>2]=H;c[h+12>>2]=e;break}b=g>>>8;if(b)if(g>>>0>16777215)e=31;else{L=(b+1048320|0)>>>16&8;M=b<<L;K=(M+520192|0)>>>16&4;M=M<<K;e=(M+245760|0)>>>16&2;e=14-(K|L|e)+(M<<e>>>15)|0;e=g>>>(e+7|0)&1|e<<1}else e=0;d=41176+(e<<2)|0;c[h+28>>2]=e;c[h+20>>2]=0;c[f>>2]=0;b=c[10219]|0;a=1<<e;if(!(b&a)){c[10219]=b|a;c[d>>2]=h;c[h+24>>2]=d;c[h+12>>2]=h;c[h+8>>2]=h;break}b=c[d>>2]|0;k:do if((c[b+4>>2]&-8|0)!=(g|0)){e=g<<((e|0)==31?0:25-(e>>>1)|0);while(1){a=b+16+(e>>>31<<2)|0;d=c[a>>2]|0;if(!d)break;if((c[d+4>>2]&-8|0)==(g|0)){I=d;break k}else{e=e<<1;b=d}}if(a>>>0<(c[10222]|0)>>>0)Ga();else{c[a>>2]=h;c[h+24>>2]=b;c[h+12>>2]=h;c[h+8>>2]=h;break g}}else I=b;while(0);b=I+8|0;a=c[b>>2]|0;M=c[10222]|0;if(a>>>0>=M>>>0&I>>>0>=M>>>0){c[a+12>>2]=h;c[b>>2]=h;c[h+8>>2]=a;c[h+12>>2]=I;c[h+24>>2]=0;break}else Ga()}}else{M=c[10222]|0;if((M|0)==0|w>>>0<M>>>0)c[10222]=w;c[10330]=w;c[10331]=p;c[10333]=0;c[10227]=c[10336];c[10226]=-1;b=0;do{M=b<<1;L=40912+(M<<2)|0;c[40912+(M+3<<2)>>2]=L;c[40912+(M+2<<2)>>2]=L;b=b+1|0}while((b|0)!=32);M=w+8|0;M=(M&7|0)==0?0:0-M&7;L=p+-40-M|0;c[10224]=w+M;c[10221]=L;c[w+(M+4)>>2]=L|1;c[w+(p+-36)>>2]=40;c[10225]=c[10340]}while(0);b=c[10221]|0;if(b>>>0>q>>>0){L=b-q|0;c[10221]=L;M=c[10224]|0;c[10224]=M+q;c[M+(q+4)>>2]=L|1;c[M+4>>2]=q|3;M=M+8|0;return M|0}}c[(ck()|0)>>2]=12;M=0;return M|0}function Gl(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;if(!a)return;b=a+-8|0;i=c[10222]|0;if(b>>>0<i>>>0)Ga();d=c[a+-4>>2]|0;e=d&3;if((e|0)==1)Ga();o=d&-8;q=a+(o+-8)|0;do if(!(d&1)){b=c[b>>2]|0;if(!e)return;j=-8-b|0;l=a+j|0;m=b+o|0;if(l>>>0<i>>>0)Ga();if((l|0)==(c[10223]|0)){b=a+(o+-4)|0;d=c[b>>2]|0;if((d&3|0)!=3){u=l;g=m;break}c[10220]=m;c[b>>2]=d&-2;c[a+(j+4)>>2]=m|1;c[q>>2]=m;return}f=b>>>3;if(b>>>0<256){e=c[a+(j+8)>>2]|0;d=c[a+(j+12)>>2]|0;b=40912+(f<<1<<2)|0;if((e|0)!=(b|0)){if(e>>>0<i>>>0)Ga();if((c[e+12>>2]|0)!=(l|0))Ga()}if((d|0)==(e|0)){c[10218]=c[10218]&~(1<<f);u=l;g=m;break}if((d|0)!=(b|0)){if(d>>>0<i>>>0)Ga();b=d+8|0;if((c[b>>2]|0)==(l|0))h=b;else Ga()}else h=d+8|0;c[e+12>>2]=d;c[h>>2]=e;u=l;g=m;break}h=c[a+(j+24)>>2]|0;e=c[a+(j+12)>>2]|0;do if((e|0)==(l|0)){d=a+(j+20)|0;b=c[d>>2]|0;if(!b){d=a+(j+16)|0;b=c[d>>2]|0;if(!b){k=0;break}}while(1){e=b+20|0;f=c[e>>2]|0;if(f){b=f;d=e;continue}e=b+16|0;f=c[e>>2]|0;if(!f)break;else{b=f;d=e}}if(d>>>0<i>>>0)Ga();else{c[d>>2]=0;k=b;break}}else{f=c[a+(j+8)>>2]|0;if(f>>>0<i>>>0)Ga();b=f+12|0;if((c[b>>2]|0)!=(l|0))Ga();d=e+8|0;if((c[d>>2]|0)==(l|0)){c[b>>2]=e;c[d>>2]=f;k=e;break}else Ga()}while(0);if(h){b=c[a+(j+28)>>2]|0;d=41176+(b<<2)|0;if((l|0)==(c[d>>2]|0)){c[d>>2]=k;if(!k){c[10219]=c[10219]&~(1<<b);u=l;g=m;break}}else{if(h>>>0<(c[10222]|0)>>>0)Ga();b=h+16|0;if((c[b>>2]|0)==(l|0))c[b>>2]=k;else c[h+20>>2]=k;if(!k){u=l;g=m;break}}d=c[10222]|0;if(k>>>0<d>>>0)Ga();c[k+24>>2]=h;b=c[a+(j+16)>>2]|0;do if(b)if(b>>>0<d>>>0)Ga();else{c[k+16>>2]=b;c[b+24>>2]=k;break}while(0);b=c[a+(j+20)>>2]|0;if(b)if(b>>>0<(c[10222]|0)>>>0)Ga();else{c[k+20>>2]=b;c[b+24>>2]=k;u=l;g=m;break}else{u=l;g=m}}else{u=l;g=m}}else{u=b;g=o}while(0);if(u>>>0>=q>>>0)Ga();b=a+(o+-4)|0;d=c[b>>2]|0;if(!(d&1))Ga();if(!(d&2)){if((q|0)==(c[10224]|0)){t=(c[10221]|0)+g|0;c[10221]=t;c[10224]=u;c[u+4>>2]=t|1;if((u|0)!=(c[10223]|0))return;c[10223]=0;c[10220]=0;return}if((q|0)==(c[10223]|0)){t=(c[10220]|0)+g|0;c[10220]=t;c[10223]=u;c[u+4>>2]=t|1;c[u+t>>2]=t;return}g=(d&-8)+g|0;f=d>>>3;do if(d>>>0>=256){h=c[a+(o+16)>>2]|0;b=c[a+(o|4)>>2]|0;do if((b|0)==(q|0)){d=a+(o+12)|0;b=c[d>>2]|0;if(!b){d=a+(o+8)|0;b=c[d>>2]|0;if(!b){p=0;break}}while(1){e=b+20|0;f=c[e>>2]|0;if(f){b=f;d=e;continue}e=b+16|0;f=c[e>>2]|0;if(!f)break;else{b=f;d=e}}if(d>>>0<(c[10222]|0)>>>0)Ga();else{c[d>>2]=0;p=b;break}}else{d=c[a+o>>2]|0;if(d>>>0<(c[10222]|0)>>>0)Ga();e=d+12|0;if((c[e>>2]|0)!=(q|0))Ga();f=b+8|0;if((c[f>>2]|0)==(q|0)){c[e>>2]=b;c[f>>2]=d;p=b;break}else Ga()}while(0);if(h){b=c[a+(o+20)>>2]|0;d=41176+(b<<2)|0;if((q|0)==(c[d>>2]|0)){c[d>>2]=p;if(!p){c[10219]=c[10219]&~(1<<b);break}}else{if(h>>>0<(c[10222]|0)>>>0)Ga();b=h+16|0;if((c[b>>2]|0)==(q|0))c[b>>2]=p;else c[h+20>>2]=p;if(!p)break}d=c[10222]|0;if(p>>>0<d>>>0)Ga();c[p+24>>2]=h;b=c[a+(o+8)>>2]|0;do if(b)if(b>>>0<d>>>0)Ga();else{c[p+16>>2]=b;c[b+24>>2]=p;break}while(0);b=c[a+(o+12)>>2]|0;if(b)if(b>>>0<(c[10222]|0)>>>0)Ga();else{c[p+20>>2]=b;c[b+24>>2]=p;break}}}else{e=c[a+o>>2]|0;d=c[a+(o|4)>>2]|0;b=40912+(f<<1<<2)|0;if((e|0)!=(b|0)){if(e>>>0<(c[10222]|0)>>>0)Ga();if((c[e+12>>2]|0)!=(q|0))Ga()}if((d|0)==(e|0)){c[10218]=c[10218]&~(1<<f);break}if((d|0)!=(b|0)){if(d>>>0<(c[10222]|0)>>>0)Ga();b=d+8|0;if((c[b>>2]|0)==(q|0))n=b;else Ga()}else n=d+8|0;c[e+12>>2]=d;c[n>>2]=e}while(0);c[u+4>>2]=g|1;c[u+g>>2]=g;if((u|0)==(c[10223]|0)){c[10220]=g;return}}else{c[b>>2]=d&-2;c[u+4>>2]=g|1;c[u+g>>2]=g}b=g>>>3;if(g>>>0<256){d=b<<1;f=40912+(d<<2)|0;e=c[10218]|0;b=1<<b;if(e&b){b=40912+(d+2<<2)|0;d=c[b>>2]|0;if(d>>>0<(c[10222]|0)>>>0)Ga();else{r=b;s=d}}else{c[10218]=e|b;r=40912+(d+2<<2)|0;s=f}c[r>>2]=u;c[s+12>>2]=u;c[u+8>>2]=s;c[u+12>>2]=f;return}b=g>>>8;if(b)if(g>>>0>16777215)f=31;else{r=(b+1048320|0)>>>16&8;s=b<<r;q=(s+520192|0)>>>16&4;s=s<<q;f=(s+245760|0)>>>16&2;f=14-(q|r|f)+(s<<f>>>15)|0;f=g>>>(f+7|0)&1|f<<1}else f=0;b=41176+(f<<2)|0;c[u+28>>2]=f;c[u+20>>2]=0;c[u+16>>2]=0;d=c[10219]|0;e=1<<f;a:do if(d&e){b=c[b>>2]|0;b:do if((c[b+4>>2]&-8|0)!=(g|0)){f=g<<((f|0)==31?0:25-(f>>>1)|0);while(1){d=b+16+(f>>>31<<2)|0;e=c[d>>2]|0;if(!e)break;if((c[e+4>>2]&-8|0)==(g|0)){t=e;break b}else{f=f<<1;b=e}}if(d>>>0<(c[10222]|0)>>>0)Ga();else{c[d>>2]=u;c[u+24>>2]=b;c[u+12>>2]=u;c[u+8>>2]=u;break a}}else t=b;while(0);b=t+8|0;d=c[b>>2]|0;s=c[10222]|0;if(d>>>0>=s>>>0&t>>>0>=s>>>0){c[d+12>>2]=u;c[b>>2]=u;c[u+8>>2]=d;c[u+12>>2]=t;c[u+24>>2]=0;break}else Ga()}else{c[10219]=d|e;c[b>>2]=u;c[u+24>>2]=b;c[u+12>>2]=u;c[u+8>>2]=u}while(0);u=(c[10226]|0)+-1|0;c[10226]=u;if(!u)b=41328;else return;while(1){b=c[b>>2]|0;if(!b)break;else b=b+8|0}c[10226]=-1;return}function Hl(a,b){a=a|0;b=b|0;var d=0;if(a){d=$(b,a)|0;if((b|a)>>>0>65535)d=((d>>>0)/(a>>>0)|0|0)==(b|0)?d:-1}else d=0;b=Fl(d)|0;if(!b)return b|0;if(!(c[b+-4>>2]&3))return b|0;iw(b|0,0,d|0)|0;return b|0}function Il(a,b){a=a|0;b=b|0;var d=0,e=0;if(!a){a=Fl(b)|0;return a|0}if(b>>>0>4294967231){c[(ck()|0)>>2]=12;a=0;return a|0}d=Jl(a+-8|0,b>>>0<11?16:b+11&-8)|0;if(d){a=d+8|0;return a|0}d=Fl(b)|0;if(!d){a=0;return a|0}e=c[a+-4>>2]|0;e=(e&-8)-((e&3|0)==0?8:4)|0;lw(d|0,a|0,(e>>>0<b>>>0?e:b)|0)|0;Gl(a);a=d;return a|0}function Jl(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;o=a+4|0;p=c[o>>2]|0;j=p&-8;l=a+j|0;i=c[10222]|0;d=p&3;if(!((d|0)!=1&a>>>0>=i>>>0&a>>>0<l>>>0))Ga();e=a+(j|4)|0;f=c[e>>2]|0;if(!(f&1))Ga();if(!d){if(b>>>0<256){a=0;return a|0}if(j>>>0>=(b+4|0)>>>0?(j-b|0)>>>0<=c[10338]<<1>>>0:0)return a|0;a=0;return a|0}if(j>>>0>=b>>>0){d=j-b|0;if(d>>>0<=15)return a|0;c[o>>2]=p&1|b|2;c[a+(b+4)>>2]=d|3;c[e>>2]=c[e>>2]|1;Kl(a+b|0,d);return a|0}if((l|0)==(c[10224]|0)){d=(c[10221]|0)+j|0;if(d>>>0<=b>>>0){a=0;return a|0}n=d-b|0;c[o>>2]=p&1|b|2;c[a+(b+4)>>2]=n|1;c[10224]=a+b;c[10221]=n;return a|0}if((l|0)==(c[10223]|0)){e=(c[10220]|0)+j|0;if(e>>>0<b>>>0){a=0;return a|0}d=e-b|0;if(d>>>0>15){c[o>>2]=p&1|b|2;c[a+(b+4)>>2]=d|1;c[a+e>>2]=d;e=a+(e+4)|0;c[e>>2]=c[e>>2]&-2;e=a+b|0}else{c[o>>2]=p&1|e|2;e=a+(e+4)|0;c[e>>2]=c[e>>2]|1;e=0;d=0}c[10220]=d;c[10223]=e;return a|0}if(f&2){a=0;return a|0}m=(f&-8)+j|0;if(m>>>0<b>>>0){a=0;return a|0}n=m-b|0;g=f>>>3;do if(f>>>0>=256){h=c[a+(j+24)>>2]|0;g=c[a+(j+12)>>2]|0;do if((g|0)==(l|0)){e=a+(j+20)|0;d=c[e>>2]|0;if(!d){e=a+(j+16)|0;d=c[e>>2]|0;if(!d){k=0;break}}while(1){f=d+20|0;g=c[f>>2]|0;if(g){d=g;e=f;continue}f=d+16|0;g=c[f>>2]|0;if(!g)break;else{d=g;e=f}}if(e>>>0<i>>>0)Ga();else{c[e>>2]=0;k=d;break}}else{f=c[a+(j+8)>>2]|0;if(f>>>0<i>>>0)Ga();d=f+12|0;if((c[d>>2]|0)!=(l|0))Ga();e=g+8|0;if((c[e>>2]|0)==(l|0)){c[d>>2]=g;c[e>>2]=f;k=g;break}else Ga()}while(0);if(h){d=c[a+(j+28)>>2]|0;e=41176+(d<<2)|0;if((l|0)==(c[e>>2]|0)){c[e>>2]=k;if(!k){c[10219]=c[10219]&~(1<<d);break}}else{if(h>>>0<(c[10222]|0)>>>0)Ga();d=h+16|0;if((c[d>>2]|0)==(l|0))c[d>>2]=k;else c[h+20>>2]=k;if(!k)break}e=c[10222]|0;if(k>>>0<e>>>0)Ga();c[k+24>>2]=h;d=c[a+(j+16)>>2]|0;do if(d)if(d>>>0<e>>>0)Ga();else{c[k+16>>2]=d;c[d+24>>2]=k;break}while(0);d=c[a+(j+20)>>2]|0;if(d)if(d>>>0<(c[10222]|0)>>>0)Ga();else{c[k+20>>2]=d;c[d+24>>2]=k;break}}}else{f=c[a+(j+8)>>2]|0;e=c[a+(j+12)>>2]|0;d=40912+(g<<1<<2)|0;if((f|0)!=(d|0)){if(f>>>0<i>>>0)Ga();if((c[f+12>>2]|0)!=(l|0))Ga()}if((e|0)==(f|0)){c[10218]=c[10218]&~(1<<g);break}if((e|0)!=(d|0)){if(e>>>0<i>>>0)Ga();d=e+8|0;if((c[d>>2]|0)==(l|0))h=d;else Ga()}else h=e+8|0;c[f+12>>2]=e;c[h>>2]=f}while(0);if(n>>>0<16){c[o>>2]=m|p&1|2;b=a+(m|4)|0;c[b>>2]=c[b>>2]|1;return a|0}else{c[o>>2]=p&1|b|2;c[a+(b+4)>>2]=n|3;p=a+(m|4)|0;c[p>>2]=c[p>>2]|1;Kl(a+b|0,n);return a|0}return 0}function Kl(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;q=a+b|0;d=c[a+4>>2]|0;do if(!(d&1)){k=c[a>>2]|0;if(!(d&3))return;n=a+(0-k)|0;m=k+b|0;j=c[10222]|0;if(n>>>0<j>>>0)Ga();if((n|0)==(c[10223]|0)){e=a+(b+4)|0;d=c[e>>2]|0;if((d&3|0)!=3){t=n;h=m;break}c[10220]=m;c[e>>2]=d&-2;c[a+(4-k)>>2]=m|1;c[q>>2]=m;return}g=k>>>3;if(k>>>0<256){f=c[a+(8-k)>>2]|0;e=c[a+(12-k)>>2]|0;d=40912+(g<<1<<2)|0;if((f|0)!=(d|0)){if(f>>>0<j>>>0)Ga();if((c[f+12>>2]|0)!=(n|0))Ga()}if((e|0)==(f|0)){c[10218]=c[10218]&~(1<<g);t=n;h=m;break}if((e|0)!=(d|0)){if(e>>>0<j>>>0)Ga();d=e+8|0;if((c[d>>2]|0)==(n|0))i=d;else Ga()}else i=e+8|0;c[f+12>>2]=e;c[i>>2]=f;t=n;h=m;break}i=c[a+(24-k)>>2]|0;f=c[a+(12-k)>>2]|0;do if((f|0)==(n|0)){f=16-k|0;e=a+(f+4)|0;d=c[e>>2]|0;if(!d){e=a+f|0;d=c[e>>2]|0;if(!d){l=0;break}}while(1){f=d+20|0;g=c[f>>2]|0;if(g){d=g;e=f;continue}f=d+16|0;g=c[f>>2]|0;if(!g)break;else{d=g;e=f}}if(e>>>0<j>>>0)Ga();else{c[e>>2]=0;l=d;break}}else{g=c[a+(8-k)>>2]|0;if(g>>>0<j>>>0)Ga();d=g+12|0;if((c[d>>2]|0)!=(n|0))Ga();e=f+8|0;if((c[e>>2]|0)==(n|0)){c[d>>2]=f;c[e>>2]=g;l=f;break}else Ga()}while(0);if(i){d=c[a+(28-k)>>2]|0;e=41176+(d<<2)|0;if((n|0)==(c[e>>2]|0)){c[e>>2]=l;if(!l){c[10219]=c[10219]&~(1<<d);t=n;h=m;break}}else{if(i>>>0<(c[10222]|0)>>>0)Ga();d=i+16|0;if((c[d>>2]|0)==(n|0))c[d>>2]=l;else c[i+20>>2]=l;if(!l){t=n;h=m;break}}f=c[10222]|0;if(l>>>0<f>>>0)Ga();c[l+24>>2]=i;d=16-k|0;e=c[a+d>>2]|0;do if(e)if(e>>>0<f>>>0)Ga();else{c[l+16>>2]=e;c[e+24>>2]=l;break}while(0);d=c[a+(d+4)>>2]|0;if(d)if(d>>>0<(c[10222]|0)>>>0)Ga();else{c[l+20>>2]=d;c[d+24>>2]=l;t=n;h=m;break}else{t=n;h=m}}else{t=n;h=m}}else{t=a;h=b}while(0);j=c[10222]|0;if(q>>>0<j>>>0)Ga();d=a+(b+4)|0;e=c[d>>2]|0;if(!(e&2)){if((q|0)==(c[10224]|0)){s=(c[10221]|0)+h|0;c[10221]=s;c[10224]=t;c[t+4>>2]=s|1;if((t|0)!=(c[10223]|0))return;c[10223]=0;c[10220]=0;return}if((q|0)==(c[10223]|0)){s=(c[10220]|0)+h|0;c[10220]=s;c[10223]=t;c[t+4>>2]=s|1;c[t+s>>2]=s;return}h=(e&-8)+h|0;g=e>>>3;do if(e>>>0>=256){i=c[a+(b+24)>>2]|0;f=c[a+(b+12)>>2]|0;do if((f|0)==(q|0)){e=a+(b+20)|0;d=c[e>>2]|0;if(!d){e=a+(b+16)|0;d=c[e>>2]|0;if(!d){p=0;break}}while(1){f=d+20|0;g=c[f>>2]|0;if(g){d=g;e=f;continue}f=d+16|0;g=c[f>>2]|0;if(!g)break;else{d=g;e=f}}if(e>>>0<j>>>0)Ga();else{c[e>>2]=0;p=d;break}}else{g=c[a+(b+8)>>2]|0;if(g>>>0<j>>>0)Ga();d=g+12|0;if((c[d>>2]|0)!=(q|0))Ga();e=f+8|0;if((c[e>>2]|0)==(q|0)){c[d>>2]=f;c[e>>2]=g;p=f;break}else Ga()}while(0);if(i){d=c[a+(b+28)>>2]|0;e=41176+(d<<2)|0;if((q|0)==(c[e>>2]|0)){c[e>>2]=p;if(!p){c[10219]=c[10219]&~(1<<d);break}}else{if(i>>>0<(c[10222]|0)>>>0)Ga();d=i+16|0;if((c[d>>2]|0)==(q|0))c[d>>2]=p;else c[i+20>>2]=p;if(!p)break}e=c[10222]|0;if(p>>>0<e>>>0)Ga();c[p+24>>2]=i;d=c[a+(b+16)>>2]|0;do if(d)if(d>>>0<e>>>0)Ga();else{c[p+16>>2]=d;c[d+24>>2]=p;break}while(0);d=c[a+(b+20)>>2]|0;if(d)if(d>>>0<(c[10222]|0)>>>0)Ga();else{c[p+20>>2]=d;c[d+24>>2]=p;break}}}else{f=c[a+(b+8)>>2]|0;e=c[a+(b+12)>>2]|0;d=40912+(g<<1<<2)|0;if((f|0)!=(d|0)){if(f>>>0<j>>>0)Ga();if((c[f+12>>2]|0)!=(q|0))Ga()}if((e|0)==(f|0)){c[10218]=c[10218]&~(1<<g);break}if((e|0)!=(d|0)){if(e>>>0<j>>>0)Ga();d=e+8|0;if((c[d>>2]|0)==(q|0))o=d;else Ga()}else o=e+8|0;c[f+12>>2]=e;c[o>>2]=f}while(0);c[t+4>>2]=h|1;c[t+h>>2]=h;if((t|0)==(c[10223]|0)){c[10220]=h;return}}else{c[d>>2]=e&-2;c[t+4>>2]=h|1;c[t+h>>2]=h}d=h>>>3;if(h>>>0<256){e=d<<1;g=40912+(e<<2)|0;f=c[10218]|0;d=1<<d;if(f&d){d=40912+(e+2<<2)|0;e=c[d>>2]|0;if(e>>>0<(c[10222]|0)>>>0)Ga();else{r=d;s=e}}else{c[10218]=f|d;r=40912+(e+2<<2)|0;s=g}c[r>>2]=t;c[s+12>>2]=t;c[t+8>>2]=s;c[t+12>>2]=g;return}d=h>>>8;if(d)if(h>>>0>16777215)g=31;else{r=(d+1048320|0)>>>16&8;s=d<<r;q=(s+520192|0)>>>16&4;s=s<<q;g=(s+245760|0)>>>16&2;g=14-(q|r|g)+(s<<g>>>15)|0;g=h>>>(g+7|0)&1|g<<1}else g=0;d=41176+(g<<2)|0;c[t+28>>2]=g;c[t+20>>2]=0;c[t+16>>2]=0;e=c[10219]|0;f=1<<g;if(!(e&f)){c[10219]=e|f;c[d>>2]=t;c[t+24>>2]=d;c[t+12>>2]=t;c[t+8>>2]=t;return}d=c[d>>2]|0;a:do if((c[d+4>>2]&-8|0)!=(h|0)){g=h<<((g|0)==31?0:25-(g>>>1)|0);while(1){e=d+16+(g>>>31<<2)|0;f=c[e>>2]|0;if(!f)break;if((c[f+4>>2]&-8|0)==(h|0)){d=f;break a}else{g=g<<1;d=f}}if(e>>>0<(c[10222]|0)>>>0)Ga();c[e>>2]=t;c[t+24>>2]=d;c[t+12>>2]=t;c[t+8>>2]=t;return}while(0);e=d+8|0;f=c[e>>2]|0;s=c[10222]|0;if(!(f>>>0>=s>>>0&d>>>0>=s>>>0))Ga();c[f+12>>2]=t;c[e>>2]=t;c[t+8>>2]=f;c[t+12>>2]=d;c[t+24>>2]=0;return}function Ll(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;e=c[9321]|0;Pl(42048,e,42104);c[10342]=42892;c[10344]=42912;c[10343]=0;a=c[10720]|0;o=0;ia(62,41368+a|0,42048);g=o;o=0;if(g&1){g=Na()|0;fn(41376);Ya(g|0)}c[41368+(a+72)>>2]=0;c[41368+(a+76)>>2]=-1;f=c[9322]|0;Ql(42152,f,42112);c[10364]=42972;c[10365]=42992;d=c[10740]|0;o=0;ia(62,41456+d|0,42152);g=o;o=0;if(g&1){g=Na()|0;fn(41460);Ya(g|0)}a=d+72|0;c[41456+a>>2]=0;b=d+76|0;c[41456+b>>2]=-1;g=c[9320]|0;Ql(42200,g,42120);c[10385]=42972;c[10386]=42992;o=0;ia(62,41540+d|0,42200);h=o;o=0;if(h&1){h=Na()|0;fn(41544);Ya(h|0)}c[41540+a>>2]=0;c[41540+b>>2]=-1;h=c[41540+((c[(c[10385]|0)+-12>>2]|0)+24)>>2]|0;c[10406]=42972;c[10407]=42992;o=0;ia(62,41624+d|0,h|0);h=o;o=0;if(h&1){h=Na()|0;fn(41628);Ya(h|0)}c[41624+a>>2]=0;c[41624+b>>2]=-1;c[41368+((c[(c[10342]|0)+-12>>2]|0)+72)>>2]=41456;a=41540+((c[(c[10385]|0)+-12>>2]|0)+4)|0;c[a>>2]=c[a>>2]|8192;c[41540+((c[(c[10385]|0)+-12>>2]|0)+72)>>2]=41456;Rl(42248,e,42128);c[10427]=42932;c[10429]=42952;c[10428]=0;a=c[10730]|0;o=0;ia(62,41708+a|0,42248);h=o;o=0;if(h&1){h=Na()|0;ln(41716);Ya(h|0)}c[41708+(a+72)>>2]=0;c[41708+(a+76)>>2]=-1;Sl(42304,f,42136);c[10449]=43012;c[10450]=43032;d=c[10750]|0;o=0;ia(62,41796+d|0,42304);h=o;o=0;if(h&1){h=Na()|0;ln(41800);Ya(h|0)}a=d+72|0;c[41796+a>>2]=0;b=d+76|0;c[41796+b>>2]=-1;Sl(42352,g,42144);c[10470]=43012;c[10471]=43032;o=0;ia(62,41880+d|0,42352);h=o;o=0;if(h&1){h=Na()|0;ln(41884);Ya(h|0)}c[41880+a>>2]=0;c[41880+b>>2]=-1;h=c[41880+((c[(c[10470]|0)+-12>>2]|0)+24)>>2]|0;c[10491]=43012;c[10492]=43032;o=0;ia(62,41964+d|0,h|0);h=o;o=0;if(h&1){h=Na()|0;ln(41968);Ya(h|0)}else{c[41964+a>>2]=0;c[41964+b>>2]=-1;c[41708+((c[(c[10427]|0)+-12>>2]|0)+72)>>2]=41796;h=41880+((c[(c[10470]|0)+-12>>2]|0)+4)|0;c[h>>2]=c[h>>2]|8192;c[41880+((c[(c[10470]|0)+-12>>2]|0)+72)>>2]=41796;return}}function Ml(a){a=a|0;o=0;ka(70,41456)|0;a=o;o=0;if(((!(a&1)?(o=0,ka(70,41624)|0,a=o,o=0,!(a&1)):0)?(o=0,ka(71,41796)|0,a=o,o=0,!(a&1)):0)?(o=0,ka(71,41964)|0,a=o,o=0,!(a&1)):0)return;a=Na(0)|0;ec(a)}function Nl(){Ll(0);kb(187,56757,n|0)|0;return}function Ol(){return}function Pl(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;g=i;i=i+16|0;h=g+4|0;f=g;pn(b);c[b>>2]=42600;c[b+32>>2]=d;c[b+40>>2]=e;c[b+48>>2]=-1;a[b+52>>0]=0;Fs(h,b+4|0);c[f>>2]=c[h>>2];o=0;ia(23,b|0,f|0);e=o;o=0;if(e&1){h=Na()|0;Gs(f);nn(b);Ya(h|0)}else{Gs(f);i=g;return}}function Ql(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;g=i;i=i+16|0;h=g+4|0;f=g;pn(b);c[b>>2]=42536;c[b+32>>2]=d;Fs(h,b+4|0);c[f>>2]=c[h>>2];o=0;d=ra(37,f|0,44280)|0;h=o;o=0;if(h&1){h=Na()|0;Gs(f);nn(b);Ya(h|0)}else{Gs(f);c[b+36>>2]=d;c[b+40>>2]=e;a[b+44>>0]=(Eb[c[(c[d>>2]|0)+28>>2]&127](d)|0)&1;i=g;return}}function Rl(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;g=i;i=i+16|0;h=g+4|0;f=g;En(b);c[b>>2]=42472;c[b+32>>2]=d;c[b+40>>2]=e;c[b+48>>2]=-1;a[b+52>>0]=0;Fs(h,b+4|0);c[f>>2]=c[h>>2];o=0;ia(21,b|0,f|0);e=o;o=0;if(e&1){h=Na()|0;Gs(f);Cn(b);Ya(h|0)}else{Gs(f);i=g;return}}function Sl(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;g=i;i=i+16|0;h=g+4|0;f=g;En(b);c[b>>2]=42408;c[b+32>>2]=d;Fs(h,b+4|0);c[f>>2]=c[h>>2];o=0;d=ra(37,f|0,44288)|0;h=o;o=0;if(h&1){h=Na()|0;Gs(f);Cn(b);Ya(h|0)}else{Gs(f);c[b+36>>2]=d;c[b+40>>2]=e;a[b+44>>0]=(Eb[c[(c[d>>2]|0)+28>>2]&127](d)|0)&1;i=g;return}}function Tl(a){a=a|0;Cn(a);cj(a);return}function Ul(b,d){b=b|0;d=d|0;Eb[c[(c[b>>2]|0)+24>>2]&127](b)|0;d=Is(d,44288)|0;c[b+36>>2]=d;a[b+44>>0]=(Eb[c[(c[d>>2]|0)+28>>2]&127](d)|0)&1;return}function Vl(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;l=i;i=i+16|0;j=l+8|0;h=l;d=a+36|0;e=a+40|0;f=j+8|0;g=j;b=a+32|0;a:while(1){a=c[d>>2]|0;a=Mb[c[(c[a>>2]|0)+20>>2]&31](a,c[e>>2]|0,j,f,h)|0;m=(c[h>>2]|0)-g|0;if((Yk(j,1,m,c[b>>2]|0)|0)!=(m|0)){a=-1;break}switch(a|0){case 1:break;case 2:{a=-1;break a}default:{k=4;break a}}}if((k|0)==4)a=((Vk(c[b>>2]|0)|0)!=0)<<31>>31;i=l;return a|0}function Wl(b,d,e){b=b|0;d=d|0;e=e|0;var f=0;a:do if(!(a[b+44>>0]|0))if((e|0)>0){f=d;d=0;while(1){if((Lb[c[(c[b>>2]|0)+52>>2]&63](b,c[f>>2]|0)|0)==-1)break a;d=d+1|0;if((d|0)<(e|0))f=f+4|0;else break}}else d=0;else d=Yk(d,4,e,c[b+32>>2]|0)|0;while(0);return d|0}function Xl(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;s=i;i=i+32|0;p=s+16|0;e=s+8|0;o=s+4|0;n=s;q=(d|0)==-1;a:do if(!q){c[e>>2]=d;if(a[b+44>>0]|0)if((Yk(e,4,1,c[b+32>>2]|0)|0)==1){r=11;break}else{e=-1;break}c[o>>2]=p;l=e+4|0;m=b+36|0;g=b+40|0;h=p+8|0;j=p;k=b+32|0;while(1){b=c[m>>2]|0;b=Sb[c[(c[b>>2]|0)+12>>2]&15](b,c[g>>2]|0,e,l,n,p,h,o)|0;if((c[n>>2]|0)==(e|0)){e=-1;break a}if((b|0)==3)break;f=(b|0)==1;if(b>>>0>=2){e=-1;break a}b=(c[o>>2]|0)-j|0;if((Yk(p,1,b,c[k>>2]|0)|0)!=(b|0)){e=-1;break a}if(f)e=f?c[n>>2]|0:e;else{r=11;break a}}if((Yk(e,1,1,c[k>>2]|0)|0)!=1)e=-1;else r=11}else r=11;while(0);if((r|0)==11)e=q?0:d;i=s;return e|0}function Yl(b,d){b=b|0;d=d|0;var e=0,f=0;f=Is(d,44288)|0;e=b+36|0;c[e>>2]=f;d=b+44|0;c[d>>2]=Eb[c[(c[f>>2]|0)+24>>2]&127](f)|0;e=c[e>>2]|0;a[b+53>>0]=(Eb[c[(c[e>>2]|0)+28>>2]&127](e)|0)&1;if((c[d>>2]|0)>8)Rr(56783);return}function Zl(a){a=a|0;Cn(a);cj(a);return}function _l(a){a=a|0;return bm(a,0)|0}function $l(a){a=a|0;return bm(a,1)|0}function am(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;m=i;i=i+32|0;l=m+16|0;k=m+8|0;f=m+4|0;g=m;h=b+52|0;e=(a[h>>0]|0)!=0;a:do if((d|0)==-1)if(e)d=-1;else{d=c[b+48>>2]|0;a[h>>0]=(d|0)!=-1&1}else{j=b+48|0;b:do if(e){c[f>>2]=c[j>>2];e=c[b+36>>2]|0;switch(Sb[c[(c[e>>2]|0)+12>>2]&15](e,c[b+40>>2]|0,f,f+4|0,g,l,l+8|0,k)|0){case 1:case 2:{d=-1;break a}case 3:{a[l>>0]=c[j>>2];c[k>>2]=l+1;break}default:{}}e=b+32|0;while(1){f=c[k>>2]|0;if(f>>>0<=l>>>0)break b;b=f+-1|0;c[k>>2]=b;if((al(a[b>>0]|0,c[e>>2]|0)|0)==-1){d=-1;break a}}}while(0);c[j>>2]=d;a[h>>0]=1}while(0);i=m;return d|0}function bm(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;r=i;i=i+32|0;q=r+16|0;p=r+8|0;m=r+4|0;n=r;g=b+52|0;a:do if(a[g>>0]|0){f=b+48|0;e=c[f>>2]|0;if(d){c[f>>2]=-1;a[g>>0]=0}}else{e=c[b+44>>2]|0;e=(e|0)>1?e:1;o=b+32|0;if((e|0)>0){g=0;do{f=Zk(c[o>>2]|0)|0;if((f|0)==-1){e=-1;break a}a[q+g>>0]=f;g=g+1|0}while((g|0)<(e|0))}b:do if(!(a[b+53>>0]|0)){j=b+40|0;k=b+36|0;l=p+4|0;c:while(1){s=c[j>>2]|0;g=s;f=c[g>>2]|0;g=c[g+4>>2]|0;t=c[k>>2]|0;h=q+e|0;switch(Sb[c[(c[t>>2]|0)+16>>2]&15](t,s,q,h,m,p,l,n)|0){case 2:{e=-1;break a}case 3:break c;case 1:break;default:break b}t=c[j>>2]|0;c[t>>2]=f;c[t+4>>2]=g;if((e|0)==8){e=-1;break a}f=Zk(c[o>>2]|0)|0;if((f|0)==-1){e=-1;break a}a[h>>0]=f;e=e+1|0}c[p>>2]=a[q>>0]}else c[p>>2]=a[q>>0];while(0);if(d){e=c[p>>2]|0;c[b+48>>2]=e;break}while(1){if((e|0)<=0)break;e=e+-1|0;if((al(a[q+e>>0]|0,c[o>>2]|0)|0)==-1){e=-1;break a}}e=c[p>>2]|0}while(0);i=r;return e|0}function cm(a){a=a|0;nn(a);cj(a);return}function dm(b,d){b=b|0;d=d|0;Eb[c[(c[b>>2]|0)+24>>2]&127](b)|0;d=Is(d,44280)|0;c[b+36>>2]=d;a[b+44>>0]=(Eb[c[(c[d>>2]|0)+28>>2]&127](d)|0)&1;return}function em(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;l=i;i=i+16|0;j=l+8|0;h=l;d=a+36|0;e=a+40|0;f=j+8|0;g=j;b=a+32|0;a:while(1){a=c[d>>2]|0;a=Mb[c[(c[a>>2]|0)+20>>2]&31](a,c[e>>2]|0,j,f,h)|0;m=(c[h>>2]|0)-g|0;if((Yk(j,1,m,c[b>>2]|0)|0)!=(m|0)){a=-1;break}switch(a|0){case 1:break;case 2:{a=-1;break a}default:{k=4;break a}}}if((k|0)==4)a=((Vk(c[b>>2]|0)|0)!=0)<<31>>31;i=l;return a|0}function fm(b,e,f){b=b|0;e=e|0;f=f|0;var g=0;a:do if(!(a[b+44>>0]|0))if((f|0)>0){g=e;e=0;while(1){if((Lb[c[(c[b>>2]|0)+52>>2]&63](b,d[g>>0]|0)|0)==-1)break a;e=e+1|0;if((e|0)<(f|0))g=g+1|0;else break}}else e=0;else e=Yk(e,1,f,c[b+32>>2]|0)|0;while(0);return e|0}function gm(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;s=i;i=i+32|0;p=s+16|0;e=s+8|0;o=s+4|0;n=s;q=(d|0)==-1;a:do if(!q){a[e>>0]=d;if(a[b+44>>0]|0)if((Yk(e,1,1,c[b+32>>2]|0)|0)==1){r=11;break}else{e=-1;break}c[o>>2]=p;m=e+1|0;g=b+36|0;h=b+40|0;j=p+8|0;k=p;l=b+32|0;while(1){b=c[g>>2]|0;b=Sb[c[(c[b>>2]|0)+12>>2]&15](b,c[h>>2]|0,e,m,n,p,j,o)|0;if((c[n>>2]|0)==(e|0)){e=-1;break a}if((b|0)==3)break;f=(b|0)==1;if(b>>>0>=2){e=-1;break a}b=(c[o>>2]|0)-k|0;if((Yk(p,1,b,c[l>>2]|0)|0)!=(b|0)){e=-1;break a}if(f)e=f?c[n>>2]|0:e;else{r=11;break a}}if((Yk(e,1,1,c[l>>2]|0)|0)!=1)e=-1;else r=11}else r=11;while(0);if((r|0)==11)e=q?0:d;i=s;return e|0}function hm(b,d){b=b|0;d=d|0;var e=0,f=0;f=Is(d,44280)|0;e=b+36|0;c[e>>2]=f;d=b+44|0;c[d>>2]=Eb[c[(c[f>>2]|0)+24>>2]&127](f)|0;e=c[e>>2]|0;a[b+53>>0]=(Eb[c[(c[e>>2]|0)+28>>2]&127](e)|0)&1;if((c[d>>2]|0)>8)Rr(56783);return}function im(a){a=a|0;nn(a);cj(a);return}function jm(a){a=a|0;return mm(a,0)|0}function km(a){a=a|0;return mm(a,1)|0}function lm(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;m=i;i=i+32|0;l=m+16|0;k=m+4|0;f=m+8|0;g=m;h=b+52|0;e=(a[h>>0]|0)!=0;a:do if((d|0)==-1)if(e)d=-1;else{d=c[b+48>>2]|0;a[h>>0]=(d|0)!=-1&1}else{j=b+48|0;b:do if(e){a[f>>0]=c[j>>2];e=c[b+36>>2]|0;switch(Sb[c[(c[e>>2]|0)+12>>2]&15](e,c[b+40>>2]|0,f,f+1|0,g,l,l+8|0,k)|0){case 1:case 2:{d=-1;break a}case 3:{a[l>>0]=c[j>>2];c[k>>2]=l+1;break}default:{}}e=b+32|0;while(1){f=c[k>>2]|0;if(f>>>0<=l>>>0)break b;b=f+-1|0;c[k>>2]=b;if((al(a[b>>0]|0,c[e>>2]|0)|0)==-1){d=-1;break a}}}while(0);c[j>>2]=d;a[h>>0]=1}while(0);i=m;return d|0}function mm(b,e){b=b|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;s=i;i=i+32|0;r=s+16|0;q=s+8|0;n=s+4|0;o=s;h=b+52|0;a:do if(a[h>>0]|0){g=b+48|0;f=c[g>>2]|0;if(e){c[g>>2]=-1;a[h>>0]=0}}else{f=c[b+44>>2]|0;f=(f|0)>1?f:1;p=b+32|0;if((f|0)>0){h=0;do{g=Zk(c[p>>2]|0)|0;if((g|0)==-1){f=-1;break a}a[r+h>>0]=g;h=h+1|0}while((h|0)<(f|0))}b:do if(!(a[b+53>>0]|0)){k=b+40|0;l=b+36|0;m=q+1|0;c:while(1){t=c[k>>2]|0;h=t;g=c[h>>2]|0;h=c[h+4>>2]|0;u=c[l>>2]|0;j=r+f|0;switch(Sb[c[(c[u>>2]|0)+16>>2]&15](u,t,r,j,n,q,m,o)|0){case 2:{f=-1;break a}case 3:break c;case 1:break;default:break b}u=c[k>>2]|0;c[u>>2]=g;c[u+4>>2]=h;if((f|0)==8){f=-1;break a}g=Zk(c[p>>2]|0)|0;if((g|0)==-1){f=-1;break a}a[j>>0]=g;f=f+1|0}a[q>>0]=a[r>>0]|0}else a[q>>0]=a[r>>0]|0;while(0);if(e){f=a[q>>0]|0;c[b+48>>2]=f&255}else{while(1){if((f|0)<=0)break;f=f+-1|0;if((al(d[r+f>>0]|0,c[p>>2]|0)|0)==-1){f=-1;break a}}f=a[q>>0]|0}f=f&255}while(0);i=s;return f|0}function nm(a){a=a|0;return}function om(a){a=a|0;a=a+4|0;c[a>>2]=(c[a>>2]|0)+1;return}function pm(a){a=a|0;var b=0,d=0;d=a+4|0;b=c[d>>2]|0;c[d>>2]=b+-1;if(!b){Bb[c[(c[a>>2]|0)+8>>2]&255](a);a=1}else a=0;return a|0}function qm(b,d){b=b|0;d=d|0;c[b>>2]=36868;o=0;ia(86,b+4|0,((a[d>>0]&1)==0?d+1|0:c[d+8>>2]|0)|0);b=o;o=0;if(b&1){b=Na()|0;Ya(b|0)}else return}function rm(a,b){a=a|0;b=b|0;c[a>>2]=36868;o=0;ia(86,a+4|0,b|0);a=o;o=0;if(a&1){a=Na()|0;Ya(a|0)}else return}function sm(a,b){a=a|0;b=b|0;var d=0,e=0;e=nl(b)|0;d=bj(e+13|0)|0;c[d>>2]=e;c[d+4>>2]=e;c[d+8>>2]=0;d=d+12|0;lw(d|0,b|0,e+1|0)|0;c[a>>2]=d;return}function tm(a,b,d){a=a|0;b=b|0;d=d|0;c[a>>2]=d;c[a+4>>2]=b;return}function um(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;f=i;i=i+16|0;e=f;Qb[c[(c[a>>2]|0)+12>>2]&15](e,a,b);if((c[e+4>>2]|0)==(c[d+4>>2]|0))e=(c[e>>2]|0)==(c[d>>2]|0);else e=0;i=f;return e|0}function vm(a,b,d){a=a|0;b=b|0;d=d|0;return ((c[b>>2]|0)==(d|0)?(c[b+4>>2]|0)==(a|0):0)|0}function wm(a,b,c){a=a|0;b=b|0;c=c|0;b=dk(c)|0;Gm(a,b,nl(b)|0);return}function xm(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0;j=i;i=i+16|0;h=j;f=c[d>>2]|0;do if(f){g=a[e>>0]|0;if(!(g&1))g=(g&255)>>>1;else g=c[e+4>>2]|0;if(g){Pm(e,56990)|0;f=c[d>>2]|0}d=c[d+4>>2]|0;Qb[c[(c[d>>2]|0)+24>>2]&15](h,d,f);d=a[h>>0]|0;g=(d&1)==0;o=0;ma(30,e|0,(g?h+1|0:c[h+8>>2]|0)|0,(g?(d&255)>>>1:c[h+4>>2]|0)|0)|0;d=o;o=0;if(d&1){j=Na()|0;Im(h);Ya(j|0)}else{Im(h);break}}while(0);c[b>>2]=c[e>>2];c[b+4>>2]=c[e+4>>2];c[b+8>>2]=c[e+8>>2];c[e>>2]=0;c[e+4>>2]=0;c[e+8>>2]=0;i=j;return}function ym(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;f=i;i=i+32|0;e=f+12|0;g=f;Gm(g,d,nl(d)|0);o=0;wa(10,e|0,b|0,g|0);d=o;o=0;do if(!(d&1)){o=0;ia(87,a|0,e|0);d=o;o=0;if(d&1){f=Na()|0;Im(e);e=f;break}else{Im(e);Im(g);c[a>>2]=42664;d=c[b+4>>2]|0;g=a+8|0;c[g>>2]=c[b>>2];c[g+4>>2]=d;i=f;return}}else e=Na()|0;while(0);Im(g);Ya(e|0)}function zm(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0;g=i;i=i+48|0;f=g+24|0;j=g+16|0;h=g;c[j>>2]=b;c[j+4>>2]=d;Fm(h,e);o=0;wa(10,f|0,j|0,h|0);e=o;o=0;do if(!(e&1)){o=0;ia(87,a|0,f|0);j=o;o=0;if(j&1){j=Na()|0;Im(f);f=j;break}else{Im(f);Im(h);c[a>>2]=42664;c[a+8>>2]=b;c[a+12>>2]=d;i=g;return}}else f=Na()|0;while(0);Im(h);Ya(f|0)}function Am(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;f=i;i=i+48|0;e=f+24|0;h=f+16|0;g=f;c[h>>2]=b;c[h+4>>2]=d;Gm(g,58898,0);o=0;wa(10,e|0,h|0,g|0);h=o;o=0;do if(!(h&1)){o=0;ia(87,a|0,e|0);h=o;o=0;if(h&1){h=Na()|0;Im(e);e=h;break}else{Im(e);Im(g);c[a>>2]=42664;c[a+8>>2]=b;c[a+12>>2]=d;i=f;return}}else e=Na()|0;while(0);Im(g);Ya(e|0)}function Bm(a){a=a|0;mj(a);return}function Cm(a){a=a|0;mj(a);cj(a);return}function Dm(a){a=a|0;return}function Em(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;rb(42676)|0;if((c[a>>2]|0)==1)do Da(42704,42676)|0;while((c[a>>2]|0)==1);do if(!(c[a>>2]|0)){c[a>>2]=1;o=0;ka(72,42676)|0;e=o;o=0;if((((!(e&1)?(o=0,ha(d|0,b|0),e=o,o=0,!(e&1)):0)?(o=0,ka(73,42676)|0,e=o,o=0,!(e&1)):0)?(c[a>>2]=-1,o=0,ka(72,42676)|0,e=o,o=0,!(e&1)):0)?(o=0,ka(74,42704)|0,e=o,o=0,!(e&1)):0)break;e=Na(0)|0;Va(e|0)|0;o=0;ka(73,42676)|0;e=o;o=0;if((!(e&1)?(c[a>>2]=0,o=0,ka(72,42676)|0,e=o,o=0,!(e&1)):0)?(o=0,ka(74,42704)|0,e=o,o=0,!(e&1)):0){o=0;xa(5);o=0}b=Na()|0;o=0;xa(3);e=o;o=0;if(e&1){e=Na(0)|0;ec(e)}else Ya(b|0)}else cb(42676)|0;while(0);return}function Fm(b,d){b=b|0;d=d|0;if(!(a[d>>0]&1)){c[b>>2]=c[d>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2]}else Gm(b,c[d+8>>2]|0,c[d+4>>2]|0);return}function Gm(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0;if(e>>>0>4294967279)_i(b);if(e>>>0<11){a[b>>0]=e<<1;b=b+1|0}else{g=e+16&-16;f=bj(g)|0;c[b+8>>2]=f;c[b>>2]=g|1;c[b+4>>2]=e;b=f}lw(b|0,d|0,e|0)|0;a[b+e>>0]=0;return}function Hm(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0;if(d>>>0>4294967279)_i(b);if(d>>>0<11){a[b>>0]=d<<1;b=b+1|0}else{g=d+16&-16;f=bj(g)|0;c[b+8>>2]=f;c[b>>2]=g|1;c[b+4>>2]=d;b=f}iw(b|0,e|0,d|0)|0;a[b+d>>0]=0;return}function Im(b){b=b|0;if(a[b>>0]&1)cj(c[b+8>>2]|0);return}function Jm(b,d){b=b|0;d=d|0;var e=0,f=0;if((b|0)!=(d|0)){e=a[d>>0]|0;f=(e&1)==0;Lm(b,f?d+1|0:c[d+8>>2]|0,f?(e&255)>>>1:c[d+4>>2]|0)|0}return b|0}function Km(a,b){a=a|0;b=b|0;return Lm(a,b,nl(b)|0)|0}function Lm(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=a[b>>0]|0;if(!(f&1))h=10;else{f=c[b>>2]|0;h=(f&-2)+-1|0;f=f&255}g=(f&1)==0;do if(h>>>0>=e>>>0){if(g)f=b+1|0;else f=c[b+8>>2]|0;nw(f|0,d|0,e|0)|0;a[f+e>>0]=0;if(!(a[b>>0]&1)){a[b>>0]=e<<1;break}else{c[b+4>>2]=e;break}}else{if(g)f=(f&255)>>>1;else f=c[b+4>>2]|0;Sm(b,h,e-h|0,f,0,f,e,d)}while(0);return b|0}function Mm(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0;f=a[b>>0]|0;g=(f&1)==0;if(g)f=(f&255)>>>1;else f=c[b+4>>2]|0;do if(f>>>0>=d>>>0)if(g){a[b+1+d>>0]=0;a[b>>0]=d<<1;break}else{a[(c[b+8>>2]|0)+d>>0]=0;c[b+4>>2]=d;break}else Nm(b,d-f|0,e)|0;while(0);return}function Nm(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;if(d){f=a[b>>0]|0;if(!(f&1))g=10;else{f=c[b>>2]|0;g=(f&-2)+-1|0;f=f&255}if(!(f&1))h=(f&255)>>>1;else h=c[b+4>>2]|0;if((g-h|0)>>>0<d>>>0){Tm(b,g,d-g+h|0,h,h,0,0);f=a[b>>0]|0}if(!(f&1))g=b+1|0;else g=c[b+8>>2]|0;iw(g+h|0,e|0,d|0)|0;f=h+d|0;if(!(a[b>>0]&1))a[b>>0]=f<<1;else c[b+4>>2]=f;a[g+f>>0]=0}return b|0}function Om(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;if(d>>>0>4294967279)_i(b);e=a[b>>0]|0;if(!(e&1))f=10;else{e=c[b>>2]|0;f=(e&-2)+-1|0;e=e&255}if(!(e&1))j=(e&255)>>>1;else j=c[b+4>>2]|0;d=j>>>0>d>>>0?j:d;if(d>>>0<11)i=10;else i=(d+16&-16)+-1|0;a:do if((i|0)!=(f|0)){do if((i|0)!=10){d=i+1|0;if(i>>>0<=f>>>0){o=0;d=ka(67,d|0)|0;h=o;o=0;if(h&1){b=Na(0)|0;Va(b|0)|0;Xa();break a}}else d=bj(d)|0;if(!(e&1)){f=1;g=b+1|0;h=0;break}else{f=1;g=c[b+8>>2]|0;h=1;break}}else{d=b+1|0;f=0;g=c[b+8>>2]|0;h=1}while(0);if(!(e&1))e=(e&255)>>>1;else e=c[b+4>>2]|0;lw(d|0,g|0,e+1|0)|0;if(h)cj(g);if(f){c[b>>2]=i+1|1;c[b+4>>2]=j;c[b+8>>2]=d;break}else{a[b>>0]=j<<1;break}}while(0);return}function Pm(a,b){a=a|0;b=b|0;return Rm(a,b,nl(b)|0)|0}function Qm(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=a[b>>0]|0;f=(e&1)!=0;if(f){g=(c[b>>2]&-2)+-1|0;h=c[b+4>>2]|0}else{g=10;h=(e&255)>>>1}if((h|0)==(g|0)){Tm(b,g,1,g,g,0,0);if(!(a[b>>0]&1))g=7;else g=8}else if(f)g=8;else g=7;if((g|0)==7){a[b>>0]=(h<<1)+2;e=b+1|0;f=h+1|0}else if((g|0)==8){e=c[b+8>>2]|0;f=h+1|0;c[b+4>>2]=f}a[e+h>>0]=d;a[e+f>>0]=0;return}function Rm(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=a[b>>0]|0;if(!(f&1))g=10;else{f=c[b>>2]|0;g=(f&-2)+-1|0;f=f&255}if(!(f&1))h=(f&255)>>>1;else h=c[b+4>>2]|0;if((g-h|0)>>>0>=e>>>0){if(e){if(!(f&1))g=b+1|0;else g=c[b+8>>2]|0;lw(g+h|0,d|0,e|0)|0;f=h+e|0;if(!(a[b>>0]&1))a[b>>0]=f<<1;else c[b+4>>2]=f;a[g+f>>0]=0}}else Sm(b,g,e-g+h|0,h,h,0,e,d);return b|0}function Sm(b,d,e,f,g,h,i,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0;if((-18-d|0)>>>0<e>>>0)_i(b);if(!(a[b>>0]&1))m=b+1|0;else m=c[b+8>>2]|0;if(d>>>0<2147483623){k=e+d|0;l=d<<1;k=k>>>0<l>>>0?l:k;k=k>>>0<11?11:k+16&-16}else k=-17;l=bj(k)|0;if(g)lw(l|0,m|0,g|0)|0;if(i)lw(l+g|0,j|0,i|0)|0;e=f-h|0;if((e|0)!=(g|0))lw(l+(i+g)|0,m+(h+g)|0,e-g|0)|0;if((d|0)!=10)cj(m);c[b+8>>2]=l;c[b>>2]=k|1;d=e+i|0;c[b+4>>2]=d;a[l+d>>0]=0;return}function Tm(b,d,e,f,g,h,i){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0;if((-17-d|0)>>>0<e>>>0)_i(b);if(!(a[b>>0]&1))l=b+1|0;else l=c[b+8>>2]|0;if(d>>>0<2147483623){j=e+d|0;k=d<<1;j=j>>>0<k>>>0?k:j;j=j>>>0<11?11:j+16&-16}else j=-17;k=bj(j)|0;if(g)lw(k|0,l|0,g|0)|0;e=f-h|0;if((e|0)!=(g|0))lw(k+(i+g)|0,l+(h+g)|0,e-g|0)|0;if((d|0)!=10)cj(l);c[b+8>>2]=k;c[b>>2]=j|1;return}function Um(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0;if(e>>>0>1073741807)_i(b);if(e>>>0<2){a[b>>0]=e<<1;b=b+4|0}else{g=e+4&-4;f=bj(g<<2)|0;c[b+8>>2]=f;c[b>>2]=g|1;c[b+4>>2]=e;b=f}ql(b,d,e)|0;c[b+(e<<2)>>2]=0;return}function Vm(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0;if(d>>>0>1073741807)_i(b);if(d>>>0<2){a[b>>0]=d<<1;b=b+4|0}else{g=d+4&-4;f=bj(g<<2)|0;c[b+8>>2]=f;c[b>>2]=g|1;c[b+4>>2]=d;b=f}sl(b,e,d)|0;c[b+(d<<2)>>2]=0;return}function Wm(b){b=b|0;if(a[b>>0]&1)cj(c[b+8>>2]|0);return}function Xm(a,b){a=a|0;b=b|0;return Ym(a,b,pl(b)|0)|0}function Ym(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=a[b>>0]|0;if(!(f&1))h=1;else{f=c[b>>2]|0;h=(f&-2)+-1|0;f=f&255}g=(f&1)==0;do if(h>>>0>=e>>>0){if(g)f=b+4|0;else f=c[b+8>>2]|0;rl(f,d,e)|0;c[f+(e<<2)>>2]=0;if(!(a[b>>0]&1)){a[b>>0]=e<<1;break}else{c[b+4>>2]=e;break}}else{if(g)f=(f&255)>>>1;else f=c[b+4>>2]|0;$m(b,h,e-h|0,f,0,f,e,d)}while(0);return b|0}function Zm(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;if(d>>>0>1073741807)_i(b);e=a[b>>0]|0;if(!(e&1))f=1;else{e=c[b>>2]|0;f=(e&-2)+-1|0;e=e&255}if(!(e&1))j=(e&255)>>>1;else j=c[b+4>>2]|0;d=j>>>0>d>>>0?j:d;if(d>>>0<2)i=1;else i=(d+4&-4)+-1|0;a:do if((i|0)!=(f|0)){do if((i|0)!=1){d=(i<<2)+4|0;if(i>>>0<=f>>>0){o=0;d=ka(67,d|0)|0;h=o;o=0;if(h&1){b=Na(0)|0;Va(b|0)|0;Xa();break a}}else d=bj(d)|0;if(!(e&1)){f=1;g=b+4|0;h=0;break}else{f=1;g=c[b+8>>2]|0;h=1;break}}else{d=b+4|0;f=0;g=c[b+8>>2]|0;h=1}while(0);if(!(e&1))e=(e&255)>>>1;else e=c[b+4>>2]|0;ql(d,g,e+1|0)|0;if(h)cj(g);if(f){c[b>>2]=i+1|1;c[b+4>>2]=j;c[b+8>>2]=d;break}else{a[b>>0]=j<<1;break}}while(0);return}function _m(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=a[b>>0]|0;f=(e&1)!=0;if(f){g=(c[b>>2]&-2)+-1|0;h=c[b+4>>2]|0}else{g=1;h=(e&255)>>>1}if((h|0)==(g|0)){an(b,g,1,g,g,0,0);if(!(a[b>>0]&1))g=7;else g=8}else if(f)g=8;else g=7;if((g|0)==7){a[b>>0]=(h<<1)+2;e=b+4|0;f=h+1|0}else if((g|0)==8){e=c[b+8>>2]|0;f=h+1|0;c[b+4>>2]=f}c[e+(h<<2)>>2]=d;c[e+(f<<2)>>2]=0;return}function $m(b,d,e,f,g,h,i,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;var k=0,l=0,m=0;if((1073741806-d|0)>>>0<e>>>0)_i(b);if(!(a[b>>0]&1))m=b+4|0;else m=c[b+8>>2]|0;if(d>>>0<536870887){k=e+d|0;l=d<<1;k=k>>>0<l>>>0?l:k;k=k>>>0<2?2:k+4&-4}else k=1073741807;l=bj(k<<2)|0;if(g)ql(l,m,g)|0;if(i)ql(l+(g<<2)|0,j,i)|0;e=f-h|0;if((e|0)!=(g|0))ql(l+(i+g<<2)|0,m+(h+g<<2)|0,e-g|0)|0;if((d|0)!=1)cj(m);c[b+8>>2]=l;c[b>>2]=k|1;d=e+i|0;c[b+4>>2]=d;c[l+(d<<2)>>2]=0;return}function an(b,d,e,f,g,h,i){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0,l=0;if((1073741807-d|0)>>>0<e>>>0)_i(b);if(!(a[b>>0]&1))l=b+4|0;else l=c[b+8>>2]|0;if(d>>>0<536870887){j=e+d|0;k=d<<1;j=j>>>0<k>>>0?k:j;j=j>>>0<2?2:j+4&-4}else j=1073741807;k=bj(j<<2)|0;if(g)ql(k,l,g)|0;e=f-h|0;if((e|0)!=(g|0))ql(k+(i+g<<2)|0,l+(h+g<<2)|0,e-g|0)|0;if((d|0)!=1)cj(l);c[b+8>>2]=k;c[b>>2]=j|1;return}function bn(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;g=d;f=e-g|0;if(f>>>0>4294967279)_i(b);if(f>>>0<11){a[b>>0]=f<<1;h=b+1|0}else{i=f+16&-16;h=bj(i)|0;c[b+8>>2]=h;c[b>>2]=i|1;c[b+4>>2]=f}b=e-g|0;if((d|0)!=(e|0)){f=h;while(1){a[f>>0]=a[d>>0]|0;d=d+1|0;if((d|0)==(e|0))break;else f=f+1|0}}a[h+b>>0]=0;return}function cn(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;h=d;f=e-h|0;g=f>>2;if(g>>>0>1073741807)_i(b);if(g>>>0<2){a[b>>0]=f>>>1;b=b+4|0}else{i=g+4&-4;f=bj(i<<2)|0;c[b+8>>2]=f;c[b>>2]=i|1;c[b+4>>2]=g;b=f}g=(e-h|0)>>>2;if((d|0)!=(e|0)){f=b;while(1){c[f>>2]=c[d>>2];d=d+4|0;if((d|0)==(e|0))break;else f=f+4|0}}c[b+(g<<2)>>2]=0;return}function dn(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+16|0;e=d;f=(c[a+24>>2]|0)==0;c[a+16>>2]=f&1|b;if(!((f&1|b)&c[a+20>>2])){i=d;return}b=Ma(16)|0;so()|0;c[e>>2]=1;c[e+4>>2]=43112;o=0;wa(11,b|0,57437,e|0);f=o;o=0;if(f&1){f=Na()|0;La(b|0);Ya(f|0)}else lb(b|0,864,112)}function en(a){a=a|0;var b=0;c[a>>2]=43068;o=0;ia(88,a|0,0);b=o;o=0;if(b&1){b=Na(0)|0;ec(b)}else{Gs(a+28|0);Gl(c[a+32>>2]|0);Gl(c[a+36>>2]|0);Gl(c[a+48>>2]|0);Gl(c[a+60>>2]|0);return}}function fn(a){a=a|0;en(a);return}function gn(a){a=a|0;en(a);cj(a);return}function hn(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=c[a+40>>2]|0;e=a+32|0;f=a+36|0;if(d)do{d=d+-1|0;Qb[c[(c[e>>2]|0)+(d<<2)>>2]&15](b,a,c[(c[f>>2]|0)+(d<<2)>>2]|0)}while((d|0)!=0);return}function jn(a){a=a|0;var b=0,d=0;d=i;i=i+16|0;b=d;Fs(b,a+28|0);i=d;return c[b>>2]|0}function kn(a,b){a=a|0;b=b|0;var d=0;c[a+24>>2]=b;c[a+16>>2]=(b|0)==0&1;c[a+20>>2]=0;c[a+4>>2]=4098;c[a+12>>2]=0;c[a+8>>2]=6;d=a+28|0;b=a+32|0;a=b+40|0;do{c[b>>2]=0;b=b+4|0}while((b|0)<(a|0));Es(d);return}function ln(a){a=a|0;en(a);return}function mn(a){a=a|0;en(a);cj(a);return}function nn(a){a=a|0;c[a>>2]=42760;Gs(a+4|0);return}function on(a){a=a|0;c[a>>2]=42760;Gs(a+4|0);cj(a);return}function pn(a){a=a|0;c[a>>2]=42760;Es(a+4|0);a=a+8|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;c[a+16>>2]=0;c[a+20>>2]=0;return}function qn(a,b){a=a|0;b=b|0;return}function rn(a,b,c){a=a|0;b=b|0;c=c|0;return a|0}function sn(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;b=a;c[b>>2]=0;c[b+4>>2]=0;b=a+8|0;c[b>>2]=-1;c[b+4>>2]=-1;return}function tn(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;b=a;c[b>>2]=0;c[b+4>>2]=0;b=a+8|0;c[b>>2]=-1;c[b+4>>2]=-1;return}function un(a){a=a|0;return 0}function vn(a){a=a|0;return 0}function wn(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;h=b+12|0;i=b+16|0;a:do if((e|0)>0){g=d;d=0;while(1){f=c[h>>2]|0;if(f>>>0<(c[i>>2]|0)>>>0){c[h>>2]=f+1;f=a[f>>0]|0}else{f=Eb[c[(c[b>>2]|0)+40>>2]&127](b)|0;if((f|0)==-1)break a;f=f&255}a[g>>0]=f;d=d+1|0;if((d|0)<(e|0))g=g+1|0;else break}}else d=0;while(0);return d|0}function xn(a){a=a|0;return -1}function yn(a){a=a|0;var b=0;if((Eb[c[(c[a>>2]|0)+36>>2]&127](a)|0)==-1)a=-1;else{b=a+12|0;a=c[b>>2]|0;c[b>>2]=a+1;a=d[a>>0]|0}return a|0}function zn(a,b){a=a|0;b=b|0;return -1}function An(b,e,f){b=b|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;i=b+24|0;j=b+28|0;a:do if((f|0)>0){h=e;e=0;while(1){g=c[i>>2]|0;if(g>>>0>=(c[j>>2]|0)>>>0){if((Lb[c[(c[b>>2]|0)+52>>2]&63](b,d[h>>0]|0)|0)==-1)break a}else{k=a[h>>0]|0;c[i>>2]=g+1;a[g>>0]=k}e=e+1|0;if((e|0)<(f|0))h=h+1|0;else break}}else e=0;while(0);return e|0}function Bn(a,b){a=a|0;b=b|0;return -1}function Cn(a){a=a|0;c[a>>2]=42824;Gs(a+4|0);return}function Dn(a){a=a|0;c[a>>2]=42824;Gs(a+4|0);cj(a);return}function En(a){a=a|0;c[a>>2]=42824;Es(a+4|0);a=a+8|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;c[a+16>>2]=0;c[a+20>>2]=0;return}function Fn(a,b){a=a|0;b=b|0;return}function Gn(a,b,c){a=a|0;b=b|0;c=c|0;return a|0}function Hn(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;b=a;c[b>>2]=0;c[b+4>>2]=0;b=a+8|0;c[b>>2]=-1;c[b+4>>2]=-1;return}function In(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;b=a;c[b>>2]=0;c[b+4>>2]=0;b=a+8|0;c[b>>2]=-1;c[b+4>>2]=-1;return}function Jn(a){a=a|0;return 0}function Kn(a){a=a|0;return 0}function Ln(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;g=a+12|0;h=a+16|0;a:do if((d|0)>0){f=b;b=0;while(1){e=c[g>>2]|0;if(e>>>0>=(c[h>>2]|0)>>>0){e=Eb[c[(c[a>>2]|0)+40>>2]&127](a)|0;if((e|0)==-1)break a}else{c[g>>2]=e+4;e=c[e>>2]|0}c[f>>2]=e;b=b+1|0;if((b|0)<(d|0))f=f+4|0;else break}}else b=0;while(0);return b|0}function Mn(a){a=a|0;return -1}function Nn(a){a=a|0;var b=0;if((Eb[c[(c[a>>2]|0)+36>>2]&127](a)|0)==-1)a=-1;else{b=a+12|0;a=c[b>>2]|0;c[b>>2]=a+4;a=c[a>>2]|0}return a|0}function On(a,b){a=a|0;b=b|0;return -1}function Pn(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;g=a+24|0;h=a+28|0;a:do if((d|0)>0){f=b;b=0;while(1){e=c[g>>2]|0;if(e>>>0>=(c[h>>2]|0)>>>0){if((Lb[c[(c[a>>2]|0)+52>>2]&63](a,c[f>>2]|0)|0)==-1)break a}else{i=c[f>>2]|0;c[g>>2]=e+4;c[e>>2]=i}b=b+1|0;if((b|0)<(d|0))f=f+4|0;else break}}else b=0;while(0);return b|0}function Qn(a,b){a=a|0;b=b|0;return -1}function Rn(a){a=a|0;en(a+8|0);return}function Sn(a){a=a|0;en(a+((c[(c[a>>2]|0)+-12>>2]|0)+8)|0);return}function Tn(a){a=a|0;en(a+8|0);cj(a);return}function Un(a){a=a|0;Tn(a+(c[(c[a>>2]|0)+-12>>2]|0)|0);return}function Vn(b){b=b|0;var d=0,e=0,f=0,g=0;f=i;i=i+16|0;e=f;a:do if(c[b+((c[(c[b>>2]|0)+-12>>2]|0)+24)>>2]|0){o=0;ia(65,e|0,b|0);d=o;o=0;b:do if(d&1)d=Na(0)|0;else{do if(a[e>>0]|0){d=c[b+((c[(c[b>>2]|0)+-12>>2]|0)+24)>>2]|0;o=0;d=ka(c[(c[d>>2]|0)+24>>2]|0,d|0)|0;g=o;o=0;if(!(g&1)){if((d|0)!=-1)break;g=c[(c[b>>2]|0)+-12>>2]|0;o=0;ia(66,b+g|0,c[b+(g+16)>>2]|1|0);g=o;o=0;if(!(g&1))break}d=Na(0)|0;ho(e);break b}while(0);ho(e);break a}while(0);Va(d|0)|0;o=0;ha(181,b+(c[(c[b>>2]|0)+-12>>2]|0)|0);g=o;o=0;if(!(g&1)){Xa();break}d=Na()|0;o=0;xa(3);g=o;o=0;if(g&1){g=Na(0)|0;ec(g)}else Ya(d|0)}while(0);i=f;return b|0}function Wn(a){a=a|0;var b=0;b=a+16|0;c[b>>2]=c[b>>2]|1;if(!(c[a+20>>2]&1))return;else mb()}function Xn(a){a=a|0;en(a+8|0);return}function Yn(a){a=a|0;en(a+((c[(c[a>>2]|0)+-12>>2]|0)+8)|0);return}function Zn(a){a=a|0;en(a+8|0);cj(a);return}function _n(a){a=a|0;Zn(a+(c[(c[a>>2]|0)+-12>>2]|0)|0);return}function $n(b){b=b|0;var d=0,e=0,f=0,g=0;f=i;i=i+16|0;e=f;a:do if(c[b+((c[(c[b>>2]|0)+-12>>2]|0)+24)>>2]|0){o=0;ia(89,e|0,b|0);d=o;o=0;b:do if(d&1)d=Na(0)|0;else{do if(a[e>>0]|0){d=c[b+((c[(c[b>>2]|0)+-12>>2]|0)+24)>>2]|0;o=0;d=ka(c[(c[d>>2]|0)+24>>2]|0,d|0)|0;g=o;o=0;if(!(g&1)){if((d|0)!=-1)break;g=c[(c[b>>2]|0)+-12>>2]|0;o=0;ia(66,b+g|0,c[b+(g+16)>>2]|1|0);g=o;o=0;if(!(g&1))break}d=Na(0)|0;po(e);break b}while(0);po(e);break a}while(0);Va(d|0)|0;o=0;ha(181,b+(c[(c[b>>2]|0)+-12>>2]|0)|0);g=o;o=0;if(!(g&1)){Xa();break}d=Na()|0;o=0;xa(3);g=o;o=0;if(g&1){g=Na(0)|0;ec(g)}else Ya(d|0)}while(0);i=f;return b|0}function ao(a,b){a=a|0;b=b|0;return}function bo(a){a=a|0;en(a+4|0);return}function co(a){a=a|0;en(a+((c[(c[a>>2]|0)+-12>>2]|0)+4)|0);return}function eo(a){a=a|0;en(a+4|0);cj(a);return}function fo(a){a=a|0;eo(a+(c[(c[a>>2]|0)+-12>>2]|0)|0);return}function go(b,d){b=b|0;d=d|0;var e=0;a[b>>0]=0;c[b+4>>2]=d;e=c[(c[d>>2]|0)+-12>>2]|0;if(!(c[d+(e+16)>>2]|0)){e=c[d+(e+72)>>2]|0;if(e)Vn(e)|0;a[b>>0]=1}return}function ho(a){a=a|0;var b=0,d=0;a=a+4|0;d=c[a>>2]|0;b=c[(c[d>>2]|0)+-12>>2]|0;do if((((c[d+(b+24)>>2]|0)!=0?(c[d+(b+16)>>2]|0)==0:0)?(c[d+(b+4)>>2]&8192|0)!=0:0)?!(Za()|0):0){b=c[a>>2]|0;b=c[b+((c[(c[b>>2]|0)+-12>>2]|0)+24)>>2]|0;o=0;b=ka(c[(c[b>>2]|0)+24>>2]|0,b|0)|0;d=o;o=0;if(!(d&1)){if((b|0)!=-1)break;b=c[a>>2]|0;d=c[(c[b>>2]|0)+-12>>2]|0;o=0;ia(66,b+d|0,c[b+(d+16)>>2]|1|0);d=o;o=0;if(!(d&1))break}d=Na(0)|0;Va(d|0)|0;o=0;xa(3);d=o;o=0;if(d&1){d=Na(0)|0;ec(d)}}while(0);return}function io(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0;q=i;i=i+32|0;k=q+20|0;l=q+16|0;n=q+8|0;e=q;o=0;ia(65,n|0,b|0);m=o;o=0;a:do if(m&1){e=Na(0)|0;f=b;g=b;p=19}else{do if(a[n>>0]|0){c[e>>2]=jn(b+(c[(c[b>>2]|0)+-12>>2]|0)|0)|0;o=0;m=ra(37,e|0,43392)|0;j=o;o=0;if(j&1){p=Na(0)|0;Gs(e);e=p}else{Gs(e);g=c[(c[b>>2]|0)+-12>>2]|0;j=c[b+(g+24)>>2]|0;f=b+g|0;g=b+(g+76)|0;e=c[g>>2]|0;do if((e|0)==-1){c[k>>2]=jn(f)|0;o=0;e=ra(37,k|0,44220)|0;r=o;o=0;if(!(r&1)?(o=0,h=ra(c[(c[e>>2]|0)+28>>2]|0,e|0,32)|0,r=o,o=0,!(r&1)):0){Gs(k);e=h<<24>>24;c[g>>2]=e;p=10;break}e=Na(0)|0;Gs(k)}else p=10;while(0);if((p|0)==10){r=c[(c[m>>2]|0)+16>>2]|0;c[l>>2]=j;o=0;c[k>>2]=c[l>>2];e=sa(r|0,m|0,k|0,f|0,e&255|0,d|0)|0;r=o;o=0;if(!(r&1)){if(e)break;r=c[(c[b>>2]|0)+-12>>2]|0;o=0;ia(66,b+r|0,c[b+(r+16)>>2]|5|0);r=o;o=0;if(!(r&1))break}e=Na(0)|0}}ho(n);f=b;g=b;p=19;break a}while(0);ho(n)}while(0);do if((p|0)==19){Va(e|0)|0;o=0;ha(181,f+(c[(c[g>>2]|0)+-12>>2]|0)|0);r=o;o=0;if(!(r&1)){Xa();break}e=Na()|0;o=0;xa(3);r=o;o=0;if(r&1){r=Na(0)|0;ec(r)}else Ya(e|0)}while(0);i=q;return b|0}function jo(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0;q=i;i=i+32|0;k=q+20|0;l=q+16|0;n=q+8|0;e=q;o=0;ia(65,n|0,b|0);m=o;o=0;a:do if(m&1){e=Na(0)|0;f=b;g=b;p=19}else{do if(a[n>>0]|0){c[e>>2]=jn(b+(c[(c[b>>2]|0)+-12>>2]|0)|0)|0;o=0;m=ra(37,e|0,43392)|0;j=o;o=0;if(j&1){p=Na(0)|0;Gs(e);e=p}else{Gs(e);g=c[(c[b>>2]|0)+-12>>2]|0;j=c[b+(g+24)>>2]|0;f=b+g|0;g=b+(g+76)|0;e=c[g>>2]|0;do if((e|0)==-1){c[k>>2]=jn(f)|0;o=0;e=ra(37,k|0,44220)|0;r=o;o=0;if(!(r&1)?(o=0,h=ra(c[(c[e>>2]|0)+28>>2]|0,e|0,32)|0,r=o,o=0,!(r&1)):0){Gs(k);e=h<<24>>24;c[g>>2]=e;p=10;break}e=Na(0)|0;Gs(k)}else p=10;while(0);if((p|0)==10){r=c[(c[m>>2]|0)+24>>2]|0;c[l>>2]=j;o=0;c[k>>2]=c[l>>2];e=sa(r|0,m|0,k|0,f|0,e&255|0,d|0)|0;r=o;o=0;if(!(r&1)){if(e)break;r=c[(c[b>>2]|0)+-12>>2]|0;o=0;ia(66,b+r|0,c[b+(r+16)>>2]|5|0);r=o;o=0;if(!(r&1))break}e=Na(0)|0}}ho(n);f=b;g=b;p=19;break a}while(0);ho(n)}while(0);do if((p|0)==19){Va(e|0)|0;o=0;ha(181,f+(c[(c[g>>2]|0)+-12>>2]|0)|0);r=o;o=0;if(!(r&1)){Xa();break}e=Na()|0;o=0;xa(3);r=o;o=0;if(r&1){r=Na(0)|0;ec(r)}else Ya(e|0)}while(0);i=q;return b|0}function ko(a){a=a|0;en(a+4|0);return}function lo(a){a=a|0;en(a+((c[(c[a>>2]|0)+-12>>2]|0)+4)|0);return}function mo(a){a=a|0;en(a+4|0);cj(a);return}function no(a){a=a|0;mo(a+(c[(c[a>>2]|0)+-12>>2]|0)|0);return}function oo(b,d){b=b|0;d=d|0;var e=0;a[b>>0]=0;c[b+4>>2]=d;e=c[(c[d>>2]|0)+-12>>2]|0;if(!(c[d+(e+16)>>2]|0)){e=c[d+(e+72)>>2]|0;if(e)$n(e)|0;a[b>>0]=1}return}function po(a){a=a|0;var b=0,d=0;a=a+4|0;d=c[a>>2]|0;b=c[(c[d>>2]|0)+-12>>2]|0;do if((((c[d+(b+24)>>2]|0)!=0?(c[d+(b+16)>>2]|0)==0:0)?(c[d+(b+4)>>2]&8192|0)!=0:0)?!(Za()|0):0){b=c[a>>2]|0;b=c[b+((c[(c[b>>2]|0)+-12>>2]|0)+24)>>2]|0;o=0;b=ka(c[(c[b>>2]|0)+24>>2]|0,b|0)|0;d=o;o=0;if(!(d&1)){if((b|0)!=-1)break;b=c[a>>2]|0;d=c[(c[b>>2]|0)+-12>>2]|0;o=0;ia(66,b+d|0,c[b+(d+16)>>2]|1|0);d=o;o=0;if(!(d&1))break}d=Na(0)|0;Va(d|0)|0;o=0;xa(3);d=o;o=0;if(d&1){d=Na(0)|0;ec(d)}}while(0);return}function qo(a){a=a|0;return 57453}function ro(a,b,c){a=a|0;b=b|0;c=c|0;if((c|0)!=1&(c|0)<257)wm(a,b,c);else Gm(a,57462,35);return}function so(){if((a[1048]|0)==0?(Ha(1048)|0)!=0:0){c[10778]=43084;kb(72,43112,n|0)|0;Pa(1048)}return 43112}function to(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;i=i+16|0;f=e+8|0;g=e;j=d;h=c[j+4>>2]|0;d=g;c[d>>2]=c[j>>2];c[d+4>>2]=h;c[f>>2]=c[g>>2];c[f+4>>2]=c[g+4>>2];ym(a,f,b);c[a>>2]=43048;i=e;return}function uo(a){a=a|0;Bm(a);return}function vo(a){a=a|0;Bm(a);cj(a);return}function wo(a){a=a|0;en(a);cj(a);return}function xo(a){a=a|0;cj(a);return}function yo(a){a=a|0;return}function zo(a){a=a|0;return}function Ao(a){a=a|0;cj(a);return}function Bo(b,c,d,e,f){b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;a:do if((e|0)==(f|0))h=6;else while(1){if((c|0)==(d|0)){c=-1;break a}b=a[c>>0]|0;g=a[e>>0]|0;if(b<<24>>24<g<<24>>24){c=-1;break a}if(g<<24>>24<b<<24>>24){c=1;break a}c=c+1|0;e=e+1|0;if((e|0)==(f|0)){h=6;break}}while(0);if((h|0)==6)c=(c|0)!=(d|0)&1;return c|0}function Co(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;bn(a,c,d);return}function Do(b,c,d){b=b|0;c=c|0;d=d|0;var e=0;if((c|0)==(d|0))b=0;else{b=0;do{b=(a[c>>0]|0)+(b<<4)|0;e=b&-268435456;b=(e>>>24|e)^b;c=c+1|0}while((c|0)!=(d|0))}return b|0}function Eo(a){a=a|0;return}function Fo(a){a=a|0;cj(a);return}function Go(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;a:do if((e|0)==(f|0))h=6;else while(1){if((b|0)==(d|0)){b=-1;break a}a=c[b>>2]|0;g=c[e>>2]|0;if((a|0)<(g|0)){b=-1;break a}if((g|0)<(a|0)){b=1;break a}b=b+4|0;e=e+4|0;if((e|0)==(f|0)){h=6;break}}while(0);if((h|0)==6)b=(b|0)!=(d|0)&1;return b|0}function Ho(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;cn(a,c,d);return}function Io(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;if((b|0)==(d|0))a=0;else{a=0;do{a=(c[b>>2]|0)+(a<<4)|0;e=a&-268435456;a=(e>>>24|e)^a;b=b+4|0}while((b|0)!=(d|0))}return a|0}function Jo(a){a=a|0;return}function Ko(a){a=a|0;cj(a);return}function Lo(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0;s=i;i=i+64|0;q=s+56|0;j=s+52|0;n=s+48|0;k=s+44|0;l=s+40|0;m=s+36|0;p=s+32|0;t=s+8|0;r=s;a:do if(!(c[f+4>>2]&1)){c[n>>2]=-1;t=c[(c[b>>2]|0)+16>>2]|0;c[k>>2]=c[d>>2];c[l>>2]=c[e>>2];c[j>>2]=c[k>>2];c[q>>2]=c[l>>2];j=Db[t&63](b,j,q,f,g,n)|0;c[d>>2]=j;switch(c[n>>2]|0){case 0:{a[h>>0]=0;break a}case 1:{a[h>>0]=1;break a}default:{a[h>>0]=1;c[g>>2]=4;break a}}}else{j=jn(f)|0;c[m>>2]=j;o=0;b=ra(37,m|0,44220)|0;n=o;o=0;do if(!(n&1)){pm(j)|0;j=jn(f)|0;c[p>>2]=j;o=0;l=ra(37,p|0,44360)|0;p=o;o=0;if(p&1){t=Na()|0;pm(j)|0;j=t;break}pm(j)|0;o=0;ia(c[(c[l>>2]|0)+24>>2]|0,t|0,l|0);p=o;o=0;if(!(p&1)){k=t+12|0;o=0;ia(c[(c[l>>2]|0)+28>>2]|0,k|0,l|0);p=o;o=0;if(!(p&1)){c[r>>2]=c[e>>2];o=0;c[q>>2]=c[r>>2];j=ea(7,d|0,q|0,t|0,t+24|0,b|0,g|0,1)|0;g=o;o=0;if(g&1){j=Na()|0;Im(t+12|0);Im(t);break}else{a[h>>0]=(j|0)==(t|0)&1;j=c[d>>2]|0;Im(t+12|0);Im(t);break a}}}else k=t;j=Na()|0;l=D;if((t|0)!=(k|0))do{k=k+-12|0;Im(k)}while((k|0)!=(t|0))}else{t=Na()|0;pm(j)|0;j=t}while(0);Ya(j|0)}while(0);i=s;return j|0}function Mo(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=yu(a,k,j,e,f,g)|0;i=h;return a|0}function No(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=zu(a,k,j,e,f,g)|0;i=h;return a|0}function Oo(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=Au(a,k,j,e,f,g)|0;i=h;return a|0}function Po(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=Bu(a,k,j,e,f,g)|0;i=h;return a|0}function Qo(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=Cu(a,k,j,e,f,g)|0;i=h;return a|0}function Ro(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=Du(a,k,j,e,f,g)|0;i=h;return a|0}function So(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=Eu(a,k,j,e,f,g)|0;i=h;return a|0}function To(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=Fu(a,k,j,e,f,g)|0;i=h;return a|0}function Uo(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=Gu(a,k,j,e,f,g)|0;i=h;return a|0}function Vo(b,e,f,g,h,j){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0;C=i;i=i+240|0;x=C;s=C+208|0;E=C+32|0;b=C+28|0;D=C+16|0;w=C+12|0;u=C+48|0;v=C+8|0;t=C+4|0;c[E>>2]=0;c[E+4>>2]=0;c[E+8>>2]=0;o=0;g=ka(68,g|0)|0;r=o;o=0;do if(r&1)b=Na()|0;else{c[b>>2]=g;o=0;b=ra(37,b|0,44220)|0;r=o;o=0;if(!(r&1)?(o=0,va(c[(c[b>>2]|0)+32>>2]|0,b|0,57498,57524,s|0)|0,r=o,o=0,!(r&1)):0){pm(g)|0;c[D>>2]=0;c[D+4>>2]=0;c[D+8>>2]=0;if(!(a[D>>0]&1))b=10;else b=(c[D>>2]&-2)+-1|0;o=0;wa(8,D|0,b|0,0);r=o;o=0;a:do if(!(r&1)){q=D+8|0;r=D+1|0;g=(a[D>>0]&1)==0?r:c[q>>2]|0;c[w>>2]=g;c[v>>2]=u;c[t>>2]=0;p=D+4|0;b=c[e>>2]|0;b:while(1){if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;k=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;n=o;o=0;if(n&1){F=29;break}if((k|0)==-1){c[e>>2]=0;b=0}}}else b=0;l=(b|0)==0;k=c[f>>2]|0;do if(k){if((c[k+12>>2]|0)!=(c[k+16>>2]|0))if(l)break;else break b;o=0;m=ka(c[(c[k>>2]|0)+36>>2]|0,k|0)|0;n=o;o=0;if(n&1){F=29;break b}if((m|0)!=-1)if(l)break;else break b;else{c[f>>2]=0;F=19;break}}else F=19;while(0);if((F|0)==19){F=0;if(l){k=0;break}else k=0}l=a[D>>0]|0;l=(l&1)==0?(l&255)>>>1:c[p>>2]|0;if((c[w>>2]|0)==(g+l|0)){o=0;wa(8,D|0,l<<1|0,0);n=o;o=0;if(n&1){F=29;break}if(!(a[D>>0]&1))g=10;else g=(c[D>>2]&-2)+-1|0;o=0;wa(8,D|0,g|0,0);n=o;o=0;if(n&1){F=29;break}g=(a[D>>0]&1)==0?r:c[q>>2]|0;c[w>>2]=g+l}m=b+12|0;l=c[m>>2]|0;n=b+16|0;if((l|0)==(c[n>>2]|0)){o=0;l=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;G=o;o=0;if(G&1){F=29;break}}else l=d[l>>0]|0;if(Wo(l&255,16,g,w,t,0,E,u,v,s)|0)break;k=c[m>>2]|0;if((k|0)==(c[n>>2]|0)){o=0;ka(c[(c[b>>2]|0)+40>>2]|0,b|0)|0;G=o;o=0;if(G&1){F=29;break}else continue}else{c[m>>2]=k+1;continue}}if((F|0)==29){b=Na()|0;break}o=0;wa(8,D|0,(c[w>>2]|0)-g|0,0);G=o;o=0;if((!(G&1)?(y=a[D>>0]|0,z=c[q>>2]|0,o=0,A=ua(3)|0,G=o,o=0,!(G&1)):0)?(o=0,c[x>>2]=j,B=va(16,((y&1)==0?r:z)|0,A|0,58882,x|0)|0,G=o,o=0,!(G&1)):0){if((B|0)!=1)c[h>>2]=4;if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;g=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;G=o;o=0;if(G&1){F=30;break}if((g|0)==-1){c[e>>2]=0;b=0}}}else b=0;g=(b|0)==0;do if(k){if((c[k+12>>2]|0)==(c[k+16>>2]|0)){o=0;b=ka(c[(c[k>>2]|0)+36>>2]|0,k|0)|0;G=o;o=0;if(G&1){F=30;break a}if((b|0)==-1){c[f>>2]=0;F=55;break}}if(!g)F=56}else F=55;while(0);if((F|0)==55?g:0)F=56;if((F|0)==56)c[h>>2]=c[h>>2]|2;G=c[e>>2]|0;Im(D);Im(E);i=C;return G|0}else F=30}else F=30;while(0);if((F|0)==30)b=Na()|0;Im(D);break}b=Na()|0;pm(g)|0}while(0);Im(E);Ya(b|0);return 0}function Wo(b,d,e,f,g,h,i,j,k,l){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0;o=c[f>>2]|0;p=(o|0)==(e|0);do if(p){m=(a[l+24>>0]|0)==b<<24>>24;if(!m?(a[l+25>>0]|0)!=b<<24>>24:0){n=5;break}c[f>>2]=e+1;a[e>>0]=m?43:45;c[g>>2]=0;m=0}else n=5;while(0);a:do if((n|0)==5){n=a[i>>0]|0;if(b<<24>>24==h<<24>>24?(((n&1)==0?(n&255)>>>1:c[i+4>>2]|0)|0)!=0:0){m=c[k>>2]|0;if((m-j|0)>=160){m=0;break}d=c[g>>2]|0;c[k>>2]=m+4;c[m>>2]=d;c[g>>2]=0;m=0;break}i=l+26|0;m=l;while(1){if((a[m>>0]|0)==b<<24>>24)break;m=m+1|0;if((m|0)==(i|0)){m=i;break}}m=m-l|0;if((m|0)>23)m=-1;else{switch(d|0){case 10:case 8:{if((m|0)>=(d|0)){m=-1;break a}break}case 16:{if((m|0)>=22){if(p){m=-1;break a}if((o-e|0)>=3){m=-1;break a}if((a[o+-1>>0]|0)!=48){m=-1;break a}c[g>>2]=0;m=a[57498+m>>0]|0;c[f>>2]=o+1;a[o>>0]=m;m=0;break a}break}default:{}}m=a[57498+m>>0]|0;c[f>>2]=o+1;a[o>>0]=m;c[g>>2]=(c[g>>2]|0)+1;m=0}}while(0);return m|0}function Xo(){var b=0,d=0;do if((a[1968]|0)==0?(Ha(1968)|0)!=0:0){o=0;b=ma(31,2147483647,58885,0)|0;d=o;o=0;if(d&1){d=Na()|0;sb(1968);Ya(d|0)}else{c[11196]=b;Pa(1968);break}}while(0);return c[11196]|0}function Yo(a){a=a|0;return}function Zo(a){a=a|0;cj(a);return}function _o(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0;s=i;i=i+64|0;q=s+56|0;j=s+52|0;n=s+48|0;k=s+44|0;l=s+40|0;m=s+36|0;p=s+32|0;t=s+8|0;r=s;a:do if(!(c[f+4>>2]&1)){c[n>>2]=-1;t=c[(c[b>>2]|0)+16>>2]|0;c[k>>2]=c[d>>2];c[l>>2]=c[e>>2];c[j>>2]=c[k>>2];c[q>>2]=c[l>>2];j=Db[t&63](b,j,q,f,g,n)|0;c[d>>2]=j;switch(c[n>>2]|0){case 0:{a[h>>0]=0;break a}case 1:{a[h>>0]=1;break a}default:{a[h>>0]=1;c[g>>2]=4;break a}}}else{j=jn(f)|0;c[m>>2]=j;o=0;b=ra(37,m|0,44212)|0;n=o;o=0;do if(!(n&1)){pm(j)|0;j=jn(f)|0;c[p>>2]=j;o=0;l=ra(37,p|0,44368)|0;p=o;o=0;if(p&1){t=Na()|0;pm(j)|0;j=t;break}pm(j)|0;o=0;ia(c[(c[l>>2]|0)+24>>2]|0,t|0,l|0);p=o;o=0;if(!(p&1)){k=t+12|0;o=0;ia(c[(c[l>>2]|0)+28>>2]|0,k|0,l|0);p=o;o=0;if(!(p&1)){c[r>>2]=c[e>>2];o=0;c[q>>2]=c[r>>2];j=ea(8,d|0,q|0,t|0,t+24|0,b|0,g|0,1)|0;g=o;o=0;if(g&1){j=Na()|0;Wm(t+12|0);Wm(t);break}else{a[h>>0]=(j|0)==(t|0)&1;j=c[d>>2]|0;Wm(t+12|0);Wm(t);break a}}}else k=t;j=Na()|0;l=D;if((t|0)!=(k|0))do{k=k+-12|0;Wm(k)}while((k|0)!=(t|0))}else{t=Na()|0;pm(j)|0;j=t}while(0);Ya(j|0)}while(0);i=s;return j|0}function $o(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=Ju(a,k,j,e,f,g)|0;i=h;return a|0}function ap(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=Ku(a,k,j,e,f,g)|0;i=h;return a|0}function bp(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=Lu(a,k,j,e,f,g)|0;i=h;return a|0}function cp(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=Mu(a,k,j,e,f,g)|0;i=h;return a|0}function dp(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=Nu(a,k,j,e,f,g)|0;i=h;return a|0}function ep(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=Ou(a,k,j,e,f,g)|0;i=h;return a|0}function fp(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=Pu(a,k,j,e,f,g)|0;i=h;return a|0}function gp(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=Qu(a,k,j,e,f,g)|0;i=h;return a|0}function hp(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+16|0;j=h+12|0;k=h+8|0;m=h+4|0;l=h;c[m>>2]=c[b>>2];c[l>>2]=c[d>>2];c[k>>2]=c[m>>2];c[j>>2]=c[l>>2];a=Ru(a,k,j,e,f,g)|0;i=h;return a|0}function ip(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0;B=i;i=i+320|0;w=B;r=B+208|0;D=B+32|0;b=B+28|0;C=B+16|0;v=B+12|0;t=B+48|0;u=B+8|0;s=B+4|0;c[D>>2]=0;c[D+4>>2]=0;c[D+8>>2]=0;o=0;f=ka(68,f|0)|0;q=o;o=0;do if(q&1)b=Na()|0;else{c[b>>2]=f;o=0;b=ra(37,b|0,44212)|0;q=o;o=0;if(!(q&1)?(o=0,va(c[(c[b>>2]|0)+48>>2]|0,b|0,57498,57524,r|0)|0,q=o,o=0,!(q&1)):0){pm(f)|0;c[C>>2]=0;c[C+4>>2]=0;c[C+8>>2]=0;if(!(a[C>>0]&1))b=10;else b=(c[C>>2]&-2)+-1|0;o=0;wa(8,C|0,b|0,0);q=o;o=0;a:do if(!(q&1)){p=C+8|0;q=C+1|0;b=(a[C>>0]&1)==0?q:c[p>>2]|0;c[v>>2]=b;c[u>>2]=t;c[s>>2]=0;n=C+4|0;j=c[d>>2]|0;b:while(1){if(j){f=c[j+12>>2]|0;if((f|0)==(c[j+16>>2]|0)){o=0;f=ka(c[(c[j>>2]|0)+36>>2]|0,j|0)|0;m=o;o=0;if(m&1){E=30;break}}else f=c[f>>2]|0;if((f|0)==-1){c[d>>2]=0;f=0;k=1}else{f=j;k=0}}else{f=0;k=1}l=c[e>>2]|0;do if(l){j=c[l+12>>2]|0;if((j|0)==(c[l+16>>2]|0)){o=0;j=ka(c[(c[l>>2]|0)+36>>2]|0,l|0)|0;m=o;o=0;if(m&1){E=30;break b}}else j=c[j>>2]|0;if((j|0)!=-1)if(k){j=l;break}else{j=l;break b}else{c[e>>2]=0;E=20;break}}else E=20;while(0);if((E|0)==20){E=0;if(k){j=0;break}else j=0}k=a[C>>0]|0;k=(k&1)==0?(k&255)>>>1:c[n>>2]|0;if((c[v>>2]|0)==(b+k|0)){o=0;wa(8,C|0,k<<1|0,0);m=o;o=0;if(m&1){E=30;break}if(!(a[C>>0]&1))b=10;else b=(c[C>>2]&-2)+-1|0;o=0;wa(8,C|0,b|0,0);m=o;o=0;if(m&1){E=30;break}b=(a[C>>0]&1)==0?q:c[p>>2]|0;c[v>>2]=b+k}l=f+12|0;k=c[l>>2]|0;m=f+16|0;if((k|0)==(c[m>>2]|0)){o=0;k=ka(c[(c[f>>2]|0)+36>>2]|0,f|0)|0;F=o;o=0;if(F&1){E=30;break}}else k=c[k>>2]|0;if(jp(k,16,b,v,s,0,D,t,u,r)|0)break;j=c[l>>2]|0;if((j|0)==(c[m>>2]|0)){o=0;ka(c[(c[f>>2]|0)+40>>2]|0,f|0)|0;F=o;o=0;if(F&1){E=30;break}else{j=f;continue}}else{c[l>>2]=j+4;j=f;continue}}if((E|0)==30){b=Na()|0;break}o=0;wa(8,C|0,(c[v>>2]|0)-b|0,0);F=o;o=0;if((!(F&1)?(x=a[C>>0]|0,y=c[p>>2]|0,o=0,z=ua(3)|0,F=o,o=0,!(F&1)):0)?(o=0,c[w>>2]=h,A=va(16,((x&1)==0?q:y)|0,z|0,58882,w|0)|0,F=o,o=0,!(F&1)):0){if((A|0)!=1)c[g>>2]=4;if(f){b=c[f+12>>2]|0;if((b|0)==(c[f+16>>2]|0)){o=0;b=ka(c[(c[f>>2]|0)+36>>2]|0,f|0)|0;F=o;o=0;if(F&1){E=31;break}}else b=c[b>>2]|0;if((b|0)==-1){c[d>>2]=0;f=1}else f=0}else f=1;do if(j){b=c[j+12>>2]|0;if((b|0)==(c[j+16>>2]|0)){o=0;b=ka(c[(c[j>>2]|0)+36>>2]|0,j|0)|0;F=o;o=0;if(F&1){E=31;break a}}else b=c[b>>2]|0;if((b|0)!=-1)if(f)break;else{E=59;break}else{c[e>>2]=0;E=57;break}}else E=57;while(0);if((E|0)==57?f:0)E=59;if((E|0)==59)c[g>>2]=c[g>>2]|2;F=c[d>>2]|0;Im(C);Im(D);i=B;return F|0}else E=31}else E=31;while(0);if((E|0)==31)b=Na()|0;Im(C);break}b=Na()|0;pm(f)|0}while(0);Im(D);Ya(b|0);return 0}function jp(b,d,e,f,g,h,i,j,k,l){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0;o=c[f>>2]|0;p=(o|0)==(e|0);do if(p){m=(c[l+96>>2]|0)==(b|0);if(!m?(c[l+100>>2]|0)!=(b|0):0){n=5;break}c[f>>2]=e+1;a[e>>0]=m?43:45;c[g>>2]=0;m=0}else n=5;while(0);a:do if((n|0)==5){n=a[i>>0]|0;if((b|0)==(h|0)?(((n&1)==0?(n&255)>>>1:c[i+4>>2]|0)|0)!=0:0){m=c[k>>2]|0;if((m-j|0)>=160){m=0;break}d=c[g>>2]|0;c[k>>2]=m+4;c[m>>2]=d;c[g>>2]=0;m=0;break}i=l+104|0;m=l;while(1){if((c[m>>2]|0)==(b|0))break;m=m+4|0;if((m|0)==(i|0)){m=i;break}}m=m-l|0;i=m>>2;if((m|0)>92)m=-1;else{switch(d|0){case 10:case 8:{if((i|0)>=(d|0)){m=-1;break a}break}case 16:{if((m|0)>=88){if(p){m=-1;break a}if((o-e|0)>=3){m=-1;break a}if((a[o+-1>>0]|0)!=48){m=-1;break a}c[g>>2]=0;m=a[57498+i>>0]|0;c[f>>2]=o+1;a[o>>0]=m;m=0;break a}break}default:{}}m=a[57498+i>>0]|0;c[f>>2]=o+1;a[o>>0]=m;c[g>>2]=(c[g>>2]|0)+1;m=0}}while(0);return m|0}function kp(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0;l=i;i=i+16|0;k=l;d=jn(d)|0;c[k>>2]=d;o=0;g=ra(37,k|0,44220)|0;m=o;o=0;if((((!(m&1)?(o=0,va(c[(c[g>>2]|0)+32>>2]|0,g|0,57498,57524,e|0)|0,m=o,o=0,!(m&1)):0)?(o=0,j=ra(37,k|0,44360)|0,m=o,o=0,!(m&1)):0)?(o=0,h=ka(c[(c[j>>2]|0)+16>>2]|0,j|0)|0,m=o,o=0,!(m&1)):0)?(a[f>>0]=h,o=0,ia(c[(c[j>>2]|0)+20>>2]|0,b|0,j|0),m=o,o=0,!(m&1)):0){pm(d)|0;i=l;return}m=Na()|0;pm(d)|0;Ya(m|0)}function lp(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,p=0;n=i;i=i+16|0;m=n;d=jn(d)|0;c[m>>2]=d;o=0;h=ra(37,m|0,44220)|0;p=o;o=0;if(((((!(p&1)?(o=0,va(c[(c[h>>2]|0)+32>>2]|0,h|0,57498,57530,e|0)|0,p=o,o=0,!(p&1)):0)?(o=0,l=ra(37,m|0,44360)|0,p=o,o=0,!(p&1)):0)?(o=0,j=ka(c[(c[l>>2]|0)+12>>2]|0,l|0)|0,p=o,o=0,!(p&1)):0)?(a[f>>0]=j,o=0,k=ka(c[(c[l>>2]|0)+16>>2]|0,l|0)|0,p=o,o=0,!(p&1)):0)?(a[g>>0]=k,o=0,ia(c[(c[l>>2]|0)+20>>2]|0,b|0,l|0),p=o,o=0,!(p&1)):0){pm(d)|0;i=n;return}p=Na()|0;pm(d)|0;Ya(p|0)}function mp(b,e,f,g,h,i,j,k,l,m,n,o){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;var p=0,q=0;a:do if(b<<24>>24==i<<24>>24)if(a[e>>0]|0){a[e>>0]=0;f=c[h>>2]|0;c[h>>2]=f+1;a[f>>0]=46;f=a[k>>0]|0;if((((f&1)==0?(f&255)>>>1:c[k+4>>2]|0)|0)!=0?(p=c[m>>2]|0,(p-l|0)<160):0){l=c[n>>2]|0;c[m>>2]=p+4;c[p>>2]=l;p=0}else p=0}else p=-1;else{if(b<<24>>24==j<<24>>24?(j=a[k>>0]|0,(((j&1)==0?(j&255)>>>1:c[k+4>>2]|0)|0)!=0):0){if(!(a[e>>0]|0)){p=-1;break}p=c[m>>2]|0;if((p-l|0)>=160){p=0;break}l=c[n>>2]|0;c[m>>2]=p+4;c[p>>2]=l;c[n>>2]=0;p=0;break}i=o+32|0;p=o;while(1){if((a[p>>0]|0)==b<<24>>24)break;p=p+1|0;if((p|0)==(i|0)){p=i;break}}i=p-o|0;if((i|0)>31)p=-1;else{j=a[57498+i>>0]|0;switch(i|0){case 24:case 25:{p=c[h>>2]|0;if((p|0)!=(g|0)?(d[p+-1>>0]&95|0)!=(d[f>>0]&127|0):0){p=-1;break a}c[h>>2]=p+1;a[p>>0]=j;p=0;break a}case 23:case 22:{a[f>>0]=80;p=c[h>>2]|0;c[h>>2]=p+1;a[p>>0]=j;p=0;break a}default:{p=j&95;if((((p|0)==(a[f>>0]|0)?(a[f>>0]=p|128,(a[e>>0]|0)!=0):0)?(a[e>>0]=0,f=a[k>>0]|0,(((f&1)==0?(f&255)>>>1:c[k+4>>2]|0)|0)!=0):0)?(q=c[m>>2]|0,(q-l|0)<160):0){l=c[n>>2]|0;c[m>>2]=q+4;c[q>>2]=l}m=c[h>>2]|0;c[h>>2]=m+1;a[m>>0]=j;if((i|0)>21){p=0;break a}c[n>>2]=(c[n>>2]|0)+1;p=0;break a}}}}while(0);return p|0}function np(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;k=i;i=i+16|0;j=k;b=jn(b)|0;c[j>>2]=b;o=0;f=ra(37,j|0,44212)|0;l=o;o=0;if((((!(l&1)?(o=0,va(c[(c[f>>2]|0)+48>>2]|0,f|0,57498,57524,d|0)|0,l=o,o=0,!(l&1)):0)?(o=0,h=ra(37,j|0,44368)|0,l=o,o=0,!(l&1)):0)?(o=0,g=ka(c[(c[h>>2]|0)+16>>2]|0,h|0)|0,l=o,o=0,!(l&1)):0)?(c[e>>2]=g,o=0,ia(c[(c[h>>2]|0)+20>>2]|0,a|0,h|0),l=o,o=0,!(l&1)):0){pm(b)|0;i=k;return}l=Na()|0;pm(b)|0;Ya(l|0)}function op(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0;m=i;i=i+16|0;l=m;b=jn(b)|0;c[l>>2]=b;o=0;g=ra(37,l|0,44212)|0;n=o;o=0;if(((((!(n&1)?(o=0,va(c[(c[g>>2]|0)+48>>2]|0,g|0,57498,57530,d|0)|0,n=o,o=0,!(n&1)):0)?(o=0,k=ra(37,l|0,44368)|0,n=o,o=0,!(n&1)):0)?(o=0,h=ka(c[(c[k>>2]|0)+12>>2]|0,k|0)|0,n=o,o=0,!(n&1)):0)?(c[e>>2]=h,o=0,j=ka(c[(c[k>>2]|0)+16>>2]|0,k|0)|0,n=o,o=0,!(n&1)):0)?(c[f>>2]=j,o=0,ia(c[(c[k>>2]|0)+20>>2]|0,a|0,k|0),n=o,o=0,!(n&1)):0){pm(b)|0;i=m;return}n=Na()|0;pm(b)|0;Ya(n|0)}function pp(b,e,f,g,h,i,j,k,l,m,n,o){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;var p=0,q=0;a:do if((b|0)==(i|0))if(a[e>>0]|0){a[e>>0]=0;f=c[h>>2]|0;c[h>>2]=f+1;a[f>>0]=46;f=a[k>>0]|0;if((((f&1)==0?(f&255)>>>1:c[k+4>>2]|0)|0)!=0?(p=c[m>>2]|0,(p-l|0)<160):0){l=c[n>>2]|0;c[m>>2]=p+4;c[p>>2]=l;p=0}else p=0}else p=-1;else{if((b|0)==(j|0)?(j=a[k>>0]|0,(((j&1)==0?(j&255)>>>1:c[k+4>>2]|0)|0)!=0):0){if(!(a[e>>0]|0)){p=-1;break}p=c[m>>2]|0;if((p-l|0)>=160){p=0;break}l=c[n>>2]|0;c[m>>2]=p+4;c[p>>2]=l;c[n>>2]=0;p=0;break}i=o+128|0;p=o;while(1){if((c[p>>2]|0)==(b|0))break;p=p+4|0;if((p|0)==(i|0)){p=i;break}}i=p-o|0;p=i>>2;if((i|0)<=124){j=a[57498+p>>0]|0;switch(p|0){case 24:case 25:{p=c[h>>2]|0;if((p|0)!=(g|0)?(d[p+-1>>0]&95|0)!=(d[f>>0]&127|0):0){p=-1;break a}c[h>>2]=p+1;a[p>>0]=j;p=0;break a}case 23:case 22:{a[f>>0]=80;break}default:{p=j&95;if((((p|0)==(a[f>>0]|0)?(a[f>>0]=p|128,(a[e>>0]|0)!=0):0)?(a[e>>0]=0,f=a[k>>0]|0,(((f&1)==0?(f&255)>>>1:c[k+4>>2]|0)|0)!=0):0)?(q=c[m>>2]|0,(q-l|0)<160):0){l=c[n>>2]|0;c[m>>2]=q+4;c[q>>2]=l}}}m=c[h>>2]|0;c[h>>2]=m+1;a[m>>0]=j;if((i|0)>84)p=0;else{c[n>>2]=(c[n>>2]|0)+1;p=0}}else p=-1}while(0);return p|0}function qp(a){a=a|0;return}function rp(a){a=a|0;cj(a);return}function sp(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0;n=i;i=i+32|0;h=n+20|0;j=n+16|0;k=n+12|0;m=n;a:do if(!(c[e+4>>2]&1)){m=c[(c[b>>2]|0)+24>>2]|0;c[j>>2]=c[d>>2];c[h>>2]=c[j>>2];h=Mb[m&31](b,h,e,f,g&1)|0}else{h=jn(e)|0;c[k>>2]=h;o=0;j=ra(37,k|0,44360)|0;l=o;o=0;b:do if(l&1){n=Na()|0;pm(h)|0;h=n}else{pm(h)|0;h=c[j>>2]|0;if(g)Cb[c[h+24>>2]&127](m,j);else Cb[c[h+28>>2]&127](m,j);b=a[m>>0]|0;l=(b&1)==0;h=m+1|0;g=m+8|0;k=l?h:m+1|0;h=l?h:c[m+8>>2]|0;l=m+4|0;e=(b&1)==0;c:do if((h|0)!=((e?k:c[g>>2]|0)+(e?(b&255)>>>1:c[l>>2]|0)|0)){d:while(1){j=a[h>>0]|0;f=c[d>>2]|0;do if(f){e=f+24|0;b=c[e>>2]|0;if((b|0)!=(c[f+28>>2]|0)){c[e>>2]=b+1;a[b>>0]=j;break}o=0;j=ra(c[(c[f>>2]|0)+52>>2]|0,f|0,j&255|0)|0;b=o;o=0;if(b&1)break d;if((j|0)==-1)c[d>>2]=0}while(0);h=h+1|0;b=a[m>>0]|0;e=(b&1)==0;if((h|0)==((e?k:c[g>>2]|0)+(e?(b&255)>>>1:c[l>>2]|0)|0))break c}h=Na()|0;Im(m);break b}while(0);h=c[d>>2]|0;Im(m);break a}while(0);Ya(h|0)}while(0);i=n;return h|0}function tp(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0;n=i;i=i+64|0;h=n;q=n+56|0;r=n+44|0;k=n+20|0;m=n+16|0;l=n+12|0;p=n+8|0;j=n+4|0;a[q>>0]=a[58887]|0;a[q+1>>0]=a[58888]|0;a[q+2>>0]=a[58889]|0;a[q+3>>0]=a[58890]|0;a[q+4>>0]=a[58891]|0;a[q+5>>0]=a[58892]|0;up(q+1|0,58893,1,c[e+4>>2]|0);b=Xo()|0;c[h>>2]=g;g=r+(Su(r,12,b,q,h)|0)|0;q=vp(r,g,e)|0;b=jn(e)|0;c[p>>2]=b;o=0;pa(1,r|0,q|0,g|0,k|0,m|0,l|0,p|0);g=o;o=0;if(g&1){r=Na()|0;pm(b)|0;Ya(r|0)}else{pm(b)|0;c[j>>2]=c[d>>2];q=c[m>>2]|0;r=c[l>>2]|0;c[h>>2]=c[j>>2];r=cd(h,k,q,r,e,f)|0;i=n;return r|0}return 0}function up(b,c,d,e){b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0;if(e&2048){a[b>>0]=43;b=b+1|0}if(e&512){a[b>>0]=35;b=b+1|0}f=a[c>>0]|0;if(f<<24>>24){g=c;while(1){g=g+1|0;c=b+1|0;a[b>>0]=f;f=a[g>>0]|0;if(!(f<<24>>24)){b=c;break}else b=c}}a:do switch(e&74|0){case 64:{a[b>>0]=111;break}case 8:if(!(e&16384)){a[b>>0]=120;break a}else{a[b>>0]=88;break a}default:if(d){a[b>>0]=100;break a}else{a[b>>0]=117;break a}}while(0);return}function vp(b,d,e){b=b|0;d=d|0;e=e|0;var f=0;a:do switch(c[e+4>>2]&176|0){case 16:{e=a[b>>0]|0;switch(e<<24>>24){case 43:case 45:{b=b+1|0;break a}default:{}}if((d-b|0)>1&e<<24>>24==48){switch(a[b+1>>0]|0){case 88:case 120:break;default:{f=7;break a}}b=b+2|0}else f=7;break}case 32:{b=d;break}default:f=7}while(0);return b|0}function wp(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;v=i;i=i+16|0;w=v;t=Is(j,44220)|0;m=Is(j,44360)|0;Cb[c[(c[m>>2]|0)+20>>2]&127](w,m);r=a[w>>0]|0;s=w+4|0;a:do if(!(((r&1)==0?(r&255)>>>1:c[s>>2]|0)|0)){o=0;va(c[(c[t>>2]|0)+32>>2]|0,t|0,b|0,e|0,f|0)|0;u=o;o=0;if(u&1)u=5;else{j=f+(e-b)|0;c[h>>2]=j;u=29}}else{c[h>>2]=f;j=a[b>>0]|0;switch(j<<24>>24){case 43:case 45:{o=0;j=ra(c[(c[t>>2]|0)+28>>2]|0,t|0,j|0)|0;r=o;o=0;if(r&1){u=5;break a}l=c[h>>2]|0;c[h>>2]=l+1;a[l>>0]=j;l=b+1|0;break}default:l=b}b:do if((e-l|0)>1?(a[l>>0]|0)==48:0){j=l+1|0;switch(a[j>>0]|0){case 88:case 120:break;default:break b}o=0;k=ra(c[(c[t>>2]|0)+28>>2]|0,t|0,48)|0;r=o;o=0;if(r&1){u=5;break a}r=c[h>>2]|0;c[h>>2]=r+1;a[r>>0]=k;o=0;j=ra(c[(c[t>>2]|0)+28>>2]|0,t|0,a[j>>0]|0)|0;r=o;o=0;if(r&1){u=5;break a}r=c[h>>2]|0;c[h>>2]=r+1;a[r>>0]=j;l=l+2|0}while(0);if((l|0)!=(e|0)?(n=e+-1|0,l>>>0<n>>>0):0){k=l;j=n;do{r=a[k>>0]|0;a[k>>0]=a[j>>0]|0;a[j>>0]=r;k=k+1|0;j=j+-1|0}while(k>>>0<j>>>0)}o=0;n=ka(c[(c[m>>2]|0)+16>>2]|0,m|0)|0;r=o;o=0;if(!(r&1)){p=w+8|0;q=w+1|0;c:do if(l>>>0<e>>>0){j=0;k=0;r=l;while(1){m=a[((a[w>>0]&1)==0?q:c[p>>2]|0)+k>>0]|0;if(m<<24>>24!=0&(j|0)==(m<<24>>24|0)){j=c[h>>2]|0;c[h>>2]=j+1;a[j>>0]=n;j=a[w>>0]|0;m=0;k=(k>>>0<(((j&1)==0?(j&255)>>>1:c[s>>2]|0)+-1|0)>>>0&1)+k|0}else m=j;o=0;j=ra(c[(c[t>>2]|0)+28>>2]|0,t|0,a[r>>0]|0)|0;x=o;o=0;if(x&1)break;x=c[h>>2]|0;c[h>>2]=x+1;a[x>>0]=j;r=r+1|0;if(r>>>0>=e>>>0)break c;else j=m+1|0}j=Na()|0;break a}while(0);k=b;j=f+(l-k)|0;b=c[h>>2]|0;if((j|0)==(b|0)){b=k;u=29}else{b=b+-1|0;if(j>>>0<b>>>0)do{x=a[j>>0]|0;a[j>>0]=a[b>>0]|0;a[b>>0]=x;j=j+1|0;b=b+-1|0}while(j>>>0<b>>>0);b=k;j=c[h>>2]|0;u=29}}else u=5}while(0);if((u|0)==5)j=Na()|0;else if((u|0)==29){c[g>>2]=(d|0)==(e|0)?j:f+(d-b)|0;Im(w);i=v;return}Im(w);Ya(j|0)}function xp(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0;n=i;i=i+96|0;h=n+8|0;a=n;q=n+74|0;k=n+32|0;m=n+28|0;l=n+24|0;p=n+20|0;j=n+16|0;r=a;c[r>>2]=37;c[r+4>>2]=0;up(a+1|0,58895,1,c[d+4>>2]|0);r=Xo()|0;s=h;c[s>>2]=f;c[s+4>>2]=g;g=q+(Su(q,22,r,a,h)|0)|0;f=vp(q,g,d)|0;a=jn(d)|0;c[p>>2]=a;o=0;pa(1,q|0,f|0,g|0,k|0,m|0,l|0,p|0);g=o;o=0;if(g&1){s=Na()|0;pm(a)|0;Ya(s|0)}else{pm(a)|0;c[j>>2]=c[b>>2];r=c[m>>2]|0;s=c[l>>2]|0;c[h>>2]=c[j>>2];s=cd(h,k,r,s,d,e)|0;i=n;return s|0}return 0}function yp(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0;n=i;i=i+64|0;h=n;q=n+56|0;r=n+44|0;k=n+20|0;m=n+16|0;l=n+12|0;p=n+8|0;j=n+4|0;a[q>>0]=a[58887]|0;a[q+1>>0]=a[58888]|0;a[q+2>>0]=a[58889]|0;a[q+3>>0]=a[58890]|0;a[q+4>>0]=a[58891]|0;a[q+5>>0]=a[58892]|0;up(q+1|0,58893,0,c[e+4>>2]|0);b=Xo()|0;c[h>>2]=g;g=r+(Su(r,12,b,q,h)|0)|0;q=vp(r,g,e)|0;b=jn(e)|0;c[p>>2]=b;o=0;pa(1,r|0,q|0,g|0,k|0,m|0,l|0,p|0);g=o;o=0;if(g&1){r=Na()|0;pm(b)|0;Ya(r|0)}else{pm(b)|0;c[j>>2]=c[d>>2];q=c[m>>2]|0;r=c[l>>2]|0;c[h>>2]=c[j>>2];r=cd(h,k,q,r,e,f)|0;i=n;return r|0}return 0}function zp(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0;n=i;i=i+112|0;h=n+8|0;a=n;q=n+75|0;k=n+32|0;m=n+28|0;l=n+24|0;p=n+20|0;j=n+16|0;r=a;c[r>>2]=37;c[r+4>>2]=0;up(a+1|0,58895,0,c[d+4>>2]|0);r=Xo()|0;s=h;c[s>>2]=f;c[s+4>>2]=g;g=q+(Su(q,23,r,a,h)|0)|0;f=vp(q,g,d)|0;a=jn(d)|0;c[p>>2]=a;o=0;pa(1,q|0,f|0,g|0,k|0,m|0,l|0,p|0);g=o;o=0;if(g&1){s=Na()|0;pm(a)|0;Ya(s|0)}else{pm(a)|0;c[j>>2]=c[b>>2];r=c[m>>2]|0;s=c[l>>2]|0;c[h>>2]=c[j>>2];s=cd(h,k,r,s,d,e)|0;i=n;return s|0}return 0}function Ap(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;var g=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;z=i;i=i+176|0;u=z+84|0;q=z+48|0;p=z+32|0;l=z+24|0;g=z+8|0;n=z;s=z+88|0;t=z+80|0;k=z+118|0;y=z+76|0;x=z+72|0;v=z+68|0;w=z+64|0;m=n;c[m>>2]=37;c[m+4>>2]=0;m=Bp(n+1|0,58898,c[d+4>>2]|0)|0;c[t>>2]=s;a=Xo()|0;if(m){c[g>>2]=c[d+8>>2];h[g+8>>3]=f;g=Su(s,30,a,n,g)|0}else{h[l>>3]=f;g=Su(s,30,a,n,l)|0}a:do if((g|0)>29){o=0;a=ua(3)|0;g=o;o=0;g=g&1;if(m){if(!g?(o=0,c[p>>2]=c[d+8>>2],h[p+8>>3]=f,j=va(17,t|0,a|0,n|0,p|0)|0,r=o,o=0,!(r&1)):0)A=12}else if(!g?(o=0,c[q>>2]=c[d+8>>2],h[q+8>>3]=f,r=va(17,t|0,a|0,n|0,q|0)|0,q=o,o=0,!(q&1)):0){j=r;A=12}do if((A|0)==12){a=c[t>>2]|0;if(!a){o=0;xa(6);r=o;o=0;if(r&1)break;g=c[t>>2]|0}else g=a;a=g;n=g;A=16;break a}while(0);a=Na()|0}else{a=c[t>>2]|0;n=0;j=g;A=16}while(0);if((A|0)==16){l=a+j|0;m=vp(a,l,d)|0;do if((a|0)==(s|0)){a=s;g=0;A=22}else{j=Fl(j<<1)|0;if(!j){o=0;xa(6);A=o;o=0;if(A&1){g=0;A=20;break}a=c[t>>2]|0}g=j;k=j;A=22}while(0);do if((A|0)==22){o=0;j=ka(68,d|0)|0;t=o;o=0;if(!(t&1)){c[v>>2]=j;o=0;pa(2,a|0,m|0,l|0,k|0,y|0,x|0,v|0);v=o;o=0;if(v&1){a=Na()|0;pm(j)|0;break}pm(j)|0;c[w>>2]=c[b>>2];A=c[y>>2]|0;a=c[x>>2]|0;o=0;c[u>>2]=c[w>>2];a=ja(39,u|0,k|0,A|0,a|0,d|0,e|0)|0;A=o;o=0;if(!(A&1)){c[b>>2]=a;if(g)Gl(g);if(n)Gl(n);i=z;return a|0}else A=20}else A=20}while(0);if((A|0)==20)a=Na()|0;if(g)Gl(g);if(n)Gl(n)}Ya(a|0);return 0}function Bp(b,c,d){b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;if(d&2048){a[b>>0]=43;b=b+1|0}if(d&1024){a[b>>0]=35;b=b+1|0}h=d&260;f=d>>>14;i=(h|0)==260;if(i)g=0;else{a[b>>0]=46;a[b+1>>0]=42;b=b+2|0;g=1}d=a[c>>0]|0;if(d<<24>>24){e=b;while(1){c=c+1|0;b=e+1|0;a[e>>0]=d;d=a[c>>0]|0;if(!(d<<24>>24))break;else e=b}}a:do switch(h|0){case 4:if(!(f&1)){a[b>>0]=102;break a}else{a[b>>0]=70;break a}case 256:if(!(f&1)){a[b>>0]=101;break a}else{a[b>>0]=69;break a}default:{d=(f&1|0)!=0;if(i)if(d){a[b>>0]=65;break a}else{a[b>>0]=97;break a}else if(d){a[b>>0]=71;break a}else{a[b>>0]=103;break a}}}while(0);return g|0}function Cp(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;z=i;i=i+16|0;A=z;y=Is(j,44220)|0;w=Is(j,44360)|0;Cb[c[(c[w>>2]|0)+20>>2]&127](A,w);c[h>>2]=f;j=a[b>>0]|0;switch(j<<24>>24){case 43:case 45:{o=0;j=ra(c[(c[y>>2]|0)+28>>2]|0,y|0,j|0)|0;x=o;o=0;if(x&1)v=8;else{n=c[h>>2]|0;c[h>>2]=n+1;a[n>>0]=j;n=b+1|0;v=10}break}default:{n=b;v=10}}a:do if((v|0)==10){x=e;b:do if((x-n|0)>1?(a[n>>0]|0)==48:0){l=n+1|0;switch(a[l>>0]|0){case 88:case 120:break;default:{v=11;break b}}o=0;j=ra(c[(c[y>>2]|0)+28>>2]|0,y|0,48)|0;u=o;o=0;if(u&1){v=8;break a}u=c[h>>2]|0;c[h>>2]=u+1;a[u>>0]=j;n=n+2|0;o=0;j=ra(c[(c[y>>2]|0)+28>>2]|0,y|0,a[l>>0]|0)|0;u=o;o=0;if(u&1){v=8;break a}u=c[h>>2]|0;c[h>>2]=u+1;a[u>>0]=j;if(n>>>0<e>>>0){j=n;while(1){l=a[j>>0]|0;o=0;m=ua(3)|0;u=o;o=0;if(u&1)break;o=0;l=ra(39,l<<24>>24|0,m|0)|0;u=o;o=0;if(u&1)break;if(!l){u=n;break b}j=j+1|0;if(j>>>0>=e>>>0){u=n;break b}}j=Na()|0;break a}else{u=n;j=n}}else v=11;while(0);c:do if((v|0)==11)if(n>>>0<e>>>0){j=n;while(1){l=a[j>>0]|0;o=0;m=ua(3)|0;u=o;o=0;if(u&1)break;o=0;l=ra(40,l<<24>>24|0,m|0)|0;u=o;o=0;if(u&1)break;if(!l){u=n;break c}j=j+1|0;if(j>>>0>=e>>>0){u=n;break c}}j=Na()|0;break a}else{u=n;j=n}while(0);s=a[A>>0]|0;t=A+4|0;if(((s&1)==0?(s&255)>>>1:c[t>>2]|0)|0){if((u|0)!=(j|0)?(p=j+-1|0,u>>>0<p>>>0):0){m=u;l=p;do{s=a[m>>0]|0;a[m>>0]=a[l>>0]|0;a[l>>0]=s;m=m+1|0;l=l+-1|0}while(m>>>0<l>>>0)}o=0;p=ka(c[(c[w>>2]|0)+16>>2]|0,w|0)|0;s=o;o=0;if(s&1){v=8;break}q=A+8|0;r=A+1|0;d:do if(u>>>0<j>>>0){l=0;m=0;s=u;while(1){n=a[((a[A>>0]&1)==0?r:c[q>>2]|0)+m>>0]|0;if(n<<24>>24>0&(l|0)==(n<<24>>24|0)){l=c[h>>2]|0;c[h>>2]=l+1;a[l>>0]=p;l=a[A>>0]|0;n=0;m=(m>>>0<(((l&1)==0?(l&255)>>>1:c[t>>2]|0)+-1|0)>>>0&1)+m|0}else n=l;o=0;l=ra(c[(c[y>>2]|0)+28>>2]|0,y|0,a[s>>0]|0)|0;B=o;o=0;if(B&1)break;B=c[h>>2]|0;c[h>>2]=B+1;a[B>>0]=l;s=s+1|0;if(s>>>0>=j>>>0)break d;else l=n+1|0}j=Na()|0;break a}while(0);l=f+(u-b)|0;m=c[h>>2]|0;if((l|0)!=(m|0)?(k=m+-1|0,l>>>0<k>>>0):0){do{B=a[l>>0]|0;a[l>>0]=a[k>>0]|0;a[k>>0]=B;l=l+1|0;k=k+-1|0}while(l>>>0<k>>>0);l=y}else l=y}else{o=0;va(c[(c[y>>2]|0)+32>>2]|0,y|0,u|0,j|0,c[h>>2]|0)|0;B=o;o=0;if(B&1){v=8;break}c[h>>2]=(c[h>>2]|0)+(j-u);l=y}e:do if(j>>>0<e>>>0){while(1){k=a[j>>0]|0;if(k<<24>>24==46)break;o=0;k=ra(c[(c[l>>2]|0)+28>>2]|0,y|0,k|0)|0;B=o;o=0;if(B&1){v=4;break}B=c[h>>2]|0;c[h>>2]=B+1;a[B>>0]=k;j=j+1|0;if(j>>>0>=e>>>0)break e}if((v|0)==4){j=Na()|0;break a}o=0;k=ka(c[(c[w>>2]|0)+12>>2]|0,w|0)|0;B=o;o=0;if(B&1){v=8;break a}B=c[h>>2]|0;c[h>>2]=B+1;a[B>>0]=k;j=j+1|0}while(0);o=0;va(c[(c[y>>2]|0)+32>>2]|0,y|0,j|0,e|0,c[h>>2]|0)|0;B=o;o=0;if(B&1)v=8;else{B=(c[h>>2]|0)+(x-j)|0;c[h>>2]=B;c[g>>2]=(d|0)==(e|0)?B:f+(d-b)|0;Im(A);i=z;return}}while(0);if((v|0)==8)j=Na()|0;Im(A);Ya(j|0)}function Dp(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;var g=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;z=i;i=i+176|0;u=z+76|0;q=z+48|0;p=z+32|0;l=z+24|0;g=z+8|0;n=z;s=z+80|0;t=z+72|0;k=z+110|0;y=z+68|0;x=z+64|0;v=z+60|0;w=z+56|0;m=n;c[m>>2]=37;c[m+4>>2]=0;m=Bp(n+1|0,58899,c[d+4>>2]|0)|0;c[t>>2]=s;a=Xo()|0;if(m){c[g>>2]=c[d+8>>2];h[g+8>>3]=f;g=Su(s,30,a,n,g)|0}else{h[l>>3]=f;g=Su(s,30,a,n,l)|0}a:do if((g|0)>29){o=0;a=ua(3)|0;g=o;o=0;g=g&1;if(m){if(!g?(o=0,c[p>>2]=c[d+8>>2],h[p+8>>3]=f,j=va(17,t|0,a|0,n|0,p|0)|0,r=o,o=0,!(r&1)):0)A=12}else if(!g?(o=0,h[q>>3]=f,r=va(17,t|0,a|0,n|0,q|0)|0,q=o,o=0,!(q&1)):0){j=r;A=12}do if((A|0)==12){a=c[t>>2]|0;if(!a){o=0;xa(6);r=o;o=0;if(r&1)break;g=c[t>>2]|0}else g=a;a=g;n=g;A=16;break a}while(0);a=Na()|0}else{a=c[t>>2]|0;n=0;j=g;A=16}while(0);if((A|0)==16){l=a+j|0;m=vp(a,l,d)|0;do if((a|0)==(s|0)){a=s;g=0;A=22}else{j=Fl(j<<1)|0;if(!j){o=0;xa(6);A=o;o=0;if(A&1){g=0;A=20;break}a=c[t>>2]|0}g=j;k=j;A=22}while(0);do if((A|0)==22){o=0;j=ka(68,d|0)|0;t=o;o=0;if(!(t&1)){c[v>>2]=j;o=0;pa(2,a|0,m|0,l|0,k|0,y|0,x|0,v|0);v=o;o=0;if(v&1){a=Na()|0;pm(j)|0;break}pm(j)|0;c[w>>2]=c[b>>2];A=c[y>>2]|0;a=c[x>>2]|0;o=0;c[u>>2]=c[w>>2];a=ja(39,u|0,k|0,A|0,a|0,d|0,e|0)|0;A=o;o=0;if(!(A&1)){c[b>>2]=a;if(g)Gl(g);if(n)Gl(n);i=z;return a|0}else A=20}else A=20}while(0);if((A|0)==20)a=Na()|0;if(g)Gl(g);if(n)Gl(n)}Ya(a|0);return 0}function Ep(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0;q=i;i=i+80|0;l=q;b=q+70|0;n=q+12|0;p=q+32|0;k=q+8|0;m=q+4|0;a[b>>0]=a[58901]|0;a[b+1>>0]=a[58902]|0;a[b+2>>0]=a[58903]|0;a[b+3>>0]=a[58904]|0;a[b+4>>0]=a[58905]|0;a[b+5>>0]=a[58906]|0;h=Xo()|0;c[l>>2]=g;b=Su(n,20,h,b,l)|0;g=n+b|0;h=vp(n,g,e)|0;j=jn(e)|0;c[k>>2]=j;o=0;k=ra(37,k|0,44220)|0;r=o;o=0;if(r&1){r=Na()|0;pm(j)|0;Ya(r|0)}else{pm(j)|0;Pb[c[(c[k>>2]|0)+32>>2]&31](k,n,g,p)|0;r=p+b|0;c[m>>2]=c[d>>2];c[l>>2]=c[m>>2];r=cd(l,p,(h|0)==(g|0)?r:p+(h-n)|0,r,e,f)|0;i=q;return r|0}return 0}function Fp(a){a=a|0;return}function Gp(a){a=a|0;cj(a);return}function Hp(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0;m=i;i=i+32|0;h=m+20|0;j=m+16|0;k=m+12|0;l=m;a:do if(!(c[e+4>>2]&1)){l=c[(c[b>>2]|0)+24>>2]|0;c[j>>2]=c[d>>2];c[h>>2]=c[j>>2];h=Mb[l&31](b,h,e,f,g&1)|0}else{h=jn(e)|0;c[k>>2]=h;o=0;j=ra(37,k|0,44368)|0;k=o;o=0;b:do if(k&1){m=Na()|0;pm(h)|0;h=m}else{pm(h)|0;h=c[j>>2]|0;if(g)Cb[c[h+24>>2]&127](l,j);else Cb[c[h+28>>2]&127](l,j);b=a[l>>0]|0;e=(b&1)==0;h=l+4|0;g=l+8|0;k=e?h:l+4|0;h=e?h:c[l+8>>2]|0;e=(b&1)==0;c:do if((h|0)!=((e?k:c[g>>2]|0)+((e?(b&255)>>>1:c[k>>2]|0)<<2)|0)){while(1){j=c[h>>2]|0;f=c[d>>2]|0;if(f){e=f+24|0;b=c[e>>2]|0;if((b|0)==(c[f+28>>2]|0)){o=0;j=ra(c[(c[f>>2]|0)+52>>2]|0,f|0,j|0)|0;b=o;o=0;if(b&1)break}else{c[e>>2]=b+4;c[b>>2]=j}if((j|0)==-1)c[d>>2]=0}h=h+4|0;b=a[l>>0]|0;e=(b&1)==0;if((h|0)==((e?k:c[g>>2]|0)+((e?(b&255)>>>1:c[k>>2]|0)<<2)|0))break c}h=Na()|0;Wm(l);break b}while(0);h=c[d>>2]|0;Wm(l);break a}while(0);Ya(h|0)}while(0);i=m;return h|0}function Ip(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0;n=i;i=i+128|0;h=n;q=n+116|0;r=n+104|0;k=n+20|0;m=n+16|0;l=n+12|0;p=n+8|0;j=n+4|0;a[q>>0]=a[58887]|0;a[q+1>>0]=a[58888]|0;a[q+2>>0]=a[58889]|0;a[q+3>>0]=a[58890]|0;a[q+4>>0]=a[58891]|0;a[q+5>>0]=a[58892]|0;up(q+1|0,58893,1,c[e+4>>2]|0);b=Xo()|0;c[h>>2]=g;g=r+(Su(r,12,b,q,h)|0)|0;q=vp(r,g,e)|0;b=jn(e)|0;c[p>>2]=b;o=0;pa(3,r|0,q|0,g|0,k|0,m|0,l|0,p|0);g=o;o=0;if(g&1){r=Na()|0;pm(b)|0;Ya(r|0)}else{pm(b)|0;c[j>>2]=c[d>>2];q=c[m>>2]|0;r=c[l>>2]|0;c[h>>2]=c[j>>2];r=Uu(h,k,q,r,e,f)|0;i=n;return r|0}return 0}function Jp(b,d,e,f,g,h,j){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;v=i;i=i+16|0;w=v;t=Is(j,44212)|0;m=Is(j,44368)|0;Cb[c[(c[m>>2]|0)+20>>2]&127](w,m);r=a[w>>0]|0;s=w+4|0;a:do if(!(((r&1)==0?(r&255)>>>1:c[s>>2]|0)|0)){o=0;va(c[(c[t>>2]|0)+48>>2]|0,t|0,b|0,e|0,f|0)|0;u=o;o=0;if(u&1)u=5;else{j=f+(e-b<<2)|0;c[h>>2]=j;u=28}}else{c[h>>2]=f;j=a[b>>0]|0;switch(j<<24>>24){case 43:case 45:{o=0;j=ra(c[(c[t>>2]|0)+44>>2]|0,t|0,j|0)|0;r=o;o=0;if(r&1){u=5;break a}l=c[h>>2]|0;c[h>>2]=l+4;c[l>>2]=j;l=b+1|0;break}default:l=b}b:do if((e-l|0)>1?(a[l>>0]|0)==48:0){j=l+1|0;switch(a[j>>0]|0){case 88:case 120:break;default:{r=l;break b}}o=0;k=ra(c[(c[t>>2]|0)+44>>2]|0,t|0,48)|0;r=o;o=0;if(r&1){u=5;break a}r=c[h>>2]|0;c[h>>2]=r+4;c[r>>2]=k;o=0;j=ra(c[(c[t>>2]|0)+44>>2]|0,t|0,a[j>>0]|0)|0;r=o;o=0;if(r&1){u=5;break a}r=c[h>>2]|0;c[h>>2]=r+4;c[r>>2]=j;r=l+2|0}else r=l;while(0);if((r|0)!=(e|0)?(n=e+-1|0,r>>>0<n>>>0):0){k=r;j=n;do{q=a[k>>0]|0;a[k>>0]=a[j>>0]|0;a[j>>0]=q;k=k+1|0;j=j+-1|0}while(k>>>0<j>>>0)}o=0;m=ka(c[(c[m>>2]|0)+16>>2]|0,m|0)|0;q=o;o=0;if(!(q&1)){n=w+8|0;p=w+1|0;c:do if(r>>>0<e>>>0){j=0;k=0;q=r;while(1){l=a[((a[w>>0]&1)==0?p:c[n>>2]|0)+k>>0]|0;if(l<<24>>24!=0&(j|0)==(l<<24>>24|0)){j=c[h>>2]|0;c[h>>2]=j+4;c[j>>2]=m;j=a[w>>0]|0;l=0;k=(k>>>0<(((j&1)==0?(j&255)>>>1:c[s>>2]|0)+-1|0)>>>0&1)+k|0}else l=j;o=0;j=ra(c[(c[t>>2]|0)+44>>2]|0,t|0,a[q>>0]|0)|0;x=o;o=0;if(x&1)break;x=c[h>>2]|0;c[h>>2]=x+4;c[x>>2]=j;q=q+1|0;if(q>>>0>=e>>>0)break c;else j=l+1|0}j=Na()|0;break a}while(0);l=b;j=f+(r-l<<2)|0;k=c[h>>2]|0;if((j|0)!=(k|0)){b=k+-4|0;if(j>>>0<b>>>0){do{x=c[j>>2]|0;c[j>>2]=c[b>>2];c[b>>2]=x;j=j+4|0;b=b+-4|0}while(j>>>0<b>>>0);b=l;j=k;u=28}else{b=l;j=k;u=28}}else{b=l;u=28}}else u=5}while(0);if((u|0)==5)j=Na()|0;else if((u|0)==28){c[g>>2]=(d|0)==(e|0)?j:f+(d-b<<2)|0;Im(w);i=v;return}Im(w);Ya(j|0)}function Kp(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0;n=i;i=i+224|0;h=n+8|0;a=n;q=n+196|0;k=n+32|0;m=n+28|0;l=n+24|0;p=n+20|0;j=n+16|0;r=a;c[r>>2]=37;c[r+4>>2]=0;up(a+1|0,58895,1,c[d+4>>2]|0);r=Xo()|0;s=h;c[s>>2]=f;c[s+4>>2]=g;g=q+(Su(q,22,r,a,h)|0)|0;f=vp(q,g,d)|0;a=jn(d)|0;c[p>>2]=a;o=0;pa(3,q|0,f|0,g|0,k|0,m|0,l|0,p|0);g=o;o=0;if(g&1){s=Na()|0;pm(a)|0;Ya(s|0)}else{pm(a)|0;c[j>>2]=c[b>>2];r=c[m>>2]|0;s=c[l>>2]|0;c[h>>2]=c[j>>2];s=Uu(h,k,r,s,d,e)|0;i=n;return s|0}return 0}
function ut(b,d,e,f,g,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;u=i;i=i+16|0;s=u;q=u+8|0;a:do if((e|0)==(f|0))l=f;else{l=e;while(1){if(!(c[l>>2]|0))break a;l=l+4|0;if((l|0)==(f|0)){l=f;break}}}while(0);c[k>>2]=h;c[g>>2]=e;n=j;r=b+8|0;b:do if(!((h|0)==(j|0)|(e|0)==(f|0))){b=h;m=l;c:while(1){w=d;h=c[w+4>>2]|0;l=s;c[l>>2]=c[w>>2];c[l+4>>2]=h;l=qk(c[r>>2]|0)|0;o=0;h=sa(21,b|0,g|0,m-e>>2|0,n-b|0,d|0)|0;w=o;o=0;if(w&1){v=9;break}if((l|0)!=0?(o=0,ka(75,l|0)|0,w=o,o=0,w&1):0){v=8;break}switch(h|0){case 0:{p=1;break b}case -1:{l=b;v=14;break c}default:{}}l=(c[k>>2]|0)+h|0;c[k>>2]=l;if((l|0)==(j|0)){v=27;break}if((m|0)==(f|0)){e=c[g>>2]|0;b=l;l=f}else{l=qk(c[r>>2]|0)|0;o=0;e=ma(34,q|0,0,d|0)|0;w=o;o=0;if(w&1){v=35;break}if((l|0)!=0?(o=0,ka(75,l|0)|0,w=o,o=0,w&1):0){v=34;break}if((e|0)==-1){p=2;break b}if(e>>>0>(n-(c[k>>2]|0)|0)>>>0){p=1;break b}if(e){l=q;while(1){m=a[l>>0]|0;w=c[k>>2]|0;c[k>>2]=w+1;a[w>>0]=m;e=e+-1|0;if(!e)break;else l=l+1|0}}e=(c[g>>2]|0)+4|0;c[g>>2]=e;d:do if((e|0)==(f|0))l=f;else{l=e;while(1){if(!(c[l>>2]|0))break d;l=l+4|0;if((l|0)==(f|0)){l=f;break}}}while(0);b=c[k>>2]|0}if((b|0)==(j|0)|(e|0)==(f|0)){v=47;break b}else m=l}if((v|0)==8){w=Na(0)|0;ec(w)}else if((v|0)==9){e=Na()|0;if((l|0)!=0?(o=0,ka(75,l|0)|0,w=o,o=0,w&1):0){w=Na(0)|0;ec(w)}Ya(e|0)}else if((v|0)==14){c[k>>2]=l;e:do if((e|0)!=(c[g>>2]|0)){while(1){w=c[e>>2]|0;b=qk(c[r>>2]|0)|0;o=0;l=ma(34,l|0,w|0,s|0)|0;w=o;o=0;if(w&1){t=b;break}if((b|0)!=0?(o=0,ka(75,b|0)|0,w=o,o=0,w&1):0){v=18;break}if((l|0)==-1)break e;l=(c[k>>2]|0)+l|0;c[k>>2]=l;e=e+4|0;if((e|0)==(c[g>>2]|0))break e}if((v|0)==18){w=Na(0)|0;ec(w)}e=Na()|0;if((t|0)!=0?(o=0,ka(75,t|0)|0,w=o,o=0,w&1):0){w=Na(0)|0;ec(w)}Ya(e|0)}while(0);c[g>>2]=e;p=2;break}else if((v|0)==27){e=c[g>>2]|0;v=47;break}else if((v|0)==34){w=Na(0)|0;ec(w)}else if((v|0)==35){e=Na()|0;if((l|0)!=0?(o=0,ka(75,l|0)|0,w=o,o=0,w&1):0){w=Na(0)|0;ec(w)}Ya(e|0)}}else v=47;while(0);if((v|0)==47)p=(e|0)!=(f|0)&1;i=u;return p|0}function vt(b,d,e,f,g,h,j,k){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;u=i;i=i+16|0;t=u;a:do if((e|0)==(f|0))l=f;else{l=e;while(1){if(!(a[l>>0]|0))break a;l=l+1|0;if((l|0)==(f|0)){l=f;break}}}while(0);c[k>>2]=h;c[g>>2]=e;p=j;r=b+8|0;b:do if(!((h|0)==(j|0)|(e|0)==(f|0))){b=h;n=l;c:while(1){m=d;l=c[m+4>>2]|0;h=t;c[h>>2]=c[m>>2];c[h+4>>2]=l;h=n;l=qk(c[r>>2]|0)|0;o=0;m=sa(22,b|0,g|0,h-e|0,p-b>>2|0,d|0)|0;w=o;o=0;if(w&1){v=9;break}if((l|0)!=0?(o=0,ka(75,l|0)|0,w=o,o=0,w&1):0){v=8;break}switch(m|0){case 0:{q=2;break b}case -1:{l=b;v=14;break c}default:{}}b=(c[k>>2]|0)+(m<<2)|0;c[k>>2]=b;if((b|0)==(j|0)){v=31;break}e=c[g>>2]|0;if((n|0)==(f|0))l=f;else{l=qk(c[r>>2]|0)|0;o=0;e=va(20,b|0,e|0,1,d|0)|0;w=o;o=0;if(w&1){v=38;break}if((l|0)!=0?(o=0,ka(75,l|0)|0,w=o,o=0,w&1):0){v=37;break}if(e){q=2;break b}c[k>>2]=(c[k>>2]|0)+4;e=(c[g>>2]|0)+1|0;c[g>>2]=e;d:do if((e|0)==(f|0))l=f;else{l=e;while(1){if(!(a[l>>0]|0))break d;l=l+1|0;if((l|0)==(f|0)){l=f;break}}}while(0);b=c[k>>2]|0}if((b|0)==(j|0)|(e|0)==(f|0)){v=47;break b}else n=l}if((v|0)==8){w=Na(0)|0;ec(w)}else if((v|0)==9){e=Na()|0;if((l|0)!=0?(o=0,ka(75,l|0)|0,w=o,o=0,w&1):0){w=Na(0)|0;ec(w)}Ya(e|0)}else if((v|0)==14){c[k>>2]=l;e:do if((e|0)!=(c[g>>2]|0)){b=l;f:while(1){l=qk(c[r>>2]|0)|0;o=0;b=va(20,b|0,e|0,h-e|0,t|0)|0;w=o;o=0;if(w&1){v=19;break}if((l|0)!=0?(o=0,ka(75,l|0)|0,w=o,o=0,w&1):0){v=18;break}switch(b|0){case -1:{v=25;break f}case -2:{v=26;break f}case 0:{e=e+1|0;break}default:e=e+b|0}b=(c[k>>2]|0)+4|0;c[k>>2]=b;if((e|0)==(c[g>>2]|0)){s=e;break e}}if((v|0)==18){w=Na(0)|0;ec(w)}else if((v|0)==19){e=Na()|0;if((l|0)!=0?(o=0,ka(75,l|0)|0,w=o,o=0,w&1):0){w=Na(0)|0;ec(w)}Ya(e|0)}else if((v|0)==25){c[g>>2]=e;q=2;break b}else if((v|0)==26){c[g>>2]=e;q=1;break b}}else s=e;while(0);c[g>>2]=s;q=(s|0)!=(f|0)&1;break}else if((v|0)==31){e=c[g>>2]|0;v=47;break}else if((v|0)==37){w=Na(0)|0;ec(w)}else if((v|0)==38){e=Na()|0;if((l|0)!=0?(o=0,ka(75,l|0)|0,w=o,o=0,w&1):0){w=Na(0)|0;ec(w)}Ya(e|0)}}else v=47;while(0);if((v|0)==47)q=(e|0)!=(f|0)&1;i=u;return q|0}function wt(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0;j=i;i=i+16|0;h=j;c[g>>2]=e;e=qk(c[b+8>>2]|0)|0;o=0;b=ma(34,h|0,0,d|0)|0;d=o;o=0;if(d&1){h=Na()|0;if((e|0)!=0?(o=0,ka(75,e|0)|0,j=o,o=0,j&1):0){j=Na(0)|0;ec(j)}Ya(h|0)}if((e|0)!=0?(o=0,ka(75,e|0)|0,d=o,o=0,d&1):0){d=Na(0)|0;ec(d)}switch(b|0){case 0:case -1:{h=2;break}default:{b=b+-1|0;if(b>>>0<=(f-(c[g>>2]|0)|0)>>>0)if(!b)h=0;else while(1){d=a[h>>0]|0;f=c[g>>2]|0;c[g>>2]=f+1;a[f>>0]=d;b=b+-1|0;if(!b){h=0;break}else h=h+1|0}else h=1}}i=j;return h|0}function xt(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;b=a+8|0;o=0;d=ka(75,c[b>>2]|0)|0;e=o;o=0;do if(e&1)f=16;else{o=0;e=ma(35,0,0,4)|0;a=o;o=0;if(a&1){a=Na(0)|0;if(!d)break;o=0;ka(75,d|0)|0;h=o;o=0;if(!(h&1))break;h=Na(0)|0;ec(h)}if((d|0)!=0?(o=0,ka(75,d|0)|0,h=o,o=0,h&1):0){h=Na(0)|0;ec(h)}if(!e){a=c[b>>2]|0;if(a){o=0;a=ka(75,a|0)|0;h=o;o=0;if(h&1){f=16;break}if((a|0)!=0?(o=0,ka(75,a|0)|0,h=o,o=0,h&1):0){h=Na(0)|0;ec(h)}else g=0}else g=1}else g=-1;return g|0}while(0);if((f|0)==16)a=Na(0)|0;ec(a);return 0}function yt(a){a=a|0;return 0}function zt(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;k=e;j=a+8|0;a:do if((d|0)==(e|0)|(f|0)==0)a=0;else{a=0;i=0;while(1){h=qk(c[j>>2]|0)|0;o=0;g=ma(36,d|0,k-d|0,b|0)|0;n=o;o=0;if(n&1){m=h;break}if((h|0)!=0?(o=0,ka(75,h|0)|0,n=o,o=0,n&1):0){l=5;break}switch(g|0){case -2:case -1:break a;case 0:{d=d+1|0;g=1;break}default:d=d+g|0}a=g+a|0;i=i+1|0;if((d|0)==(e|0)|i>>>0>=f>>>0)break a}if((l|0)==5){n=Na(0)|0;ec(n)}a=Na()|0;if((m|0)!=0?(o=0,ka(75,m|0)|0,n=o,o=0,n&1):0){n=Na(0)|0;ec(n)}Ya(a|0)}while(0);return a|0}function At(a){a=a|0;var b=0,d=0;a=c[a+8>>2]|0;if(a){o=0;a=ka(75,a|0)|0;d=o;o=0;if(d&1){d=Na(0)|0;ec(d)}if((a|0)!=0?(o=0,ka(75,a|0)|0,d=o,o=0,d&1):0){d=Na(0)|0;ec(d)}else b=4}else b=1;return b|0}function Bt(a){a=a|0;cj(a);return}function Ct(a,b,d,e,f,g,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0;a=i;i=i+16|0;k=a+4|0;b=a;c[k>>2]=d;c[b>>2]=g;h=Hv(d,e,k,g,h,b,1114111,0)|0;c[f>>2]=c[k>>2];c[j>>2]=c[b>>2];i=a;return h|0}function Dt(a,b,d,e,f,g,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0;a=i;i=i+16|0;k=a+4|0;b=a;c[k>>2]=d;c[b>>2]=g;h=Iv(d,e,k,g,h,b,1114111,0)|0;c[f>>2]=c[k>>2];c[j>>2]=c[b>>2];i=a;return h|0}function Et(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;c[f>>2]=d;return 3}function Ft(a){a=a|0;return 0}function Gt(a){a=a|0;return 0}function Ht(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return Jv(c,d,e,1114111,0)|0}function It(a){a=a|0;return 4}function Jt(a){a=a|0;cj(a);return}function Kt(a,b,d,e,f,g,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0;a=i;i=i+16|0;k=a+4|0;b=a;c[k>>2]=d;c[b>>2]=g;h=Kv(d,e,k,g,h,b,1114111,0)|0;c[f>>2]=c[k>>2];c[j>>2]=c[b>>2];i=a;return h|0}function Lt(a,b,d,e,f,g,h,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0;a=i;i=i+16|0;k=a+4|0;b=a;c[k>>2]=d;c[b>>2]=g;h=Lv(d,e,k,g,h,b,1114111,0)|0;c[f>>2]=c[k>>2];c[j>>2]=c[b>>2];i=a;return h|0}function Mt(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;c[f>>2]=d;return 3}function Nt(a){a=a|0;return 0}function Ot(a){a=a|0;return 0}function Pt(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return Mv(c,d,e,1114111,0)|0}function Qt(a){a=a|0;return 4}function Rt(a){a=a|0;cj(a);return}function St(a){a=a|0;cj(a);return}function Tt(b,d){b=b|0;d=d|0;c[b+4>>2]=d+-1;c[b>>2]=44384;a[b+8>>0]=46;a[b+9>>0]=44;b=b+12|0;c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;return}function Ut(a,b){a=a|0;b=b|0;c[a+4>>2]=b+-1;c[a>>2]=44424;c[a+8>>2]=46;c[a+12>>2]=44;a=a+16|0;c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;return}function Vt(a){a=a|0;c[a>>2]=44384;Im(a+12|0);return}function Wt(a){a=a|0;Vt(a);cj(a);return}function Xt(a){a=a|0;c[a>>2]=44424;Im(a+16|0);return}function Yt(a){a=a|0;Xt(a);cj(a);return}function Zt(b){b=b|0;return a[b+8>>0]|0}function _t(a){a=a|0;return c[a+8>>2]|0}function $t(b){b=b|0;return a[b+9>>0]|0}function au(a){a=a|0;return c[a+12>>2]|0}function bu(a,b){a=a|0;b=b|0;Fm(a,b+12|0);return}function cu(a,b){a=a|0;b=b|0;Fm(a,b+16|0);return}function du(a,b){a=a|0;b=b|0;Gm(a,59024,4);return}function eu(a,b){a=a|0;b=b|0;Um(a,44996,pl(44996)|0);return}function fu(a,b){a=a|0;b=b|0;Gm(a,59029,5);return}function gu(a,b){a=a|0;b=b|0;Um(a,45016,pl(45016)|0);return}function hu(a){a=a|0;switch(c[a+4>>2]&74|0){case 64:{a=8;break}case 8:{a=16;break}case 0:{a=0;break}default:a=10}return a|0}function iu(b){b=b|0;do if((a[2464]|0)==0?(Ha(2464)|0)!=0:0){if((a[2472]|0)==0?(Ha(2472)|0)!=0:0){b=45040;do{c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;b=b+12|0}while((b|0)!=45208);kb(193,0,n|0)|0;Pa(2472)}o=0;ra(41,45040,59035)|0;b=o;o=0;if(((((((((((((!(b&1)?(o=0,ra(41,45052,59042)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(41,45064,59049)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(41,45076,59057)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(41,45088,59067)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(41,45100,59076)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(41,45112,59083)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(41,45124,59092)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(41,45136,59096)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(41,45148,59100)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(41,45160,59104)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(41,45172,59108)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(41,45184,59112)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(41,45196,59116)|0,b=o,o=0,!(b&1)):0){c[11302]=45040;Pa(2464);break}b=Na()|0;sb(2464);Ya(b|0)}while(0);return c[11302]|0}function ju(b){b=b|0;do if((a[2480]|0)==0?(Ha(2480)|0)!=0:0){if((a[2488]|0)==0?(Ha(2488)|0)!=0:0){b=45212;do{c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;b=b+12|0}while((b|0)!=45380);kb(194,0,n|0)|0;Pa(2488)}o=0;ra(42,45212,45380)|0;b=o;o=0;if(((((((((((((!(b&1)?(o=0,ra(42,45224,45408)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(42,45236,45436)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(42,45248,45468)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(42,45260,45508)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(42,45272,45544)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(42,45284,45572)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(42,45296,45608)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(42,45308,45624)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(42,45320,45640)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(42,45332,45656)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(42,45344,45672)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(42,45356,45688)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(42,45368,45704)|0,b=o,o=0,!(b&1)):0){c[11430]=45212;Pa(2480);break}b=Na()|0;sb(2480);Ya(b|0)}while(0);return c[11430]|0}function ku(b){b=b|0;a:do if((a[2496]|0)==0?(Ha(2496)|0)!=0:0){if((a[2504]|0)==0?(Ha(2504)|0)!=0:0){b=45724;do{c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;b=b+12|0}while((b|0)!=46012);kb(195,0,n|0)|0;Pa(2504)}o=0;ra(41,45724,59120)|0;b=o;o=0;do if((((((((((((((!(b&1)?(o=0,ra(41,45736,59128)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(41,45748,59137)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(41,45760,59143)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(41,45772,59149)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(41,45784,59153)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(41,45796,59158)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(41,45808,59163)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(41,45820,59170)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(41,45832,59180)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(41,45844,59188)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(41,45856,59197)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(41,45868,59206)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(41,45880,59210)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(41,45892,59214)|0,b=o,o=0,!(b&1)):0){o=0;ra(41,45904,59218)|0;b=o;o=0;if(b&1)break;o=0;ra(41,45916,59149)|0;b=o;o=0;if(b&1)break;o=0;ra(41,45928,59222)|0;b=o;o=0;if(b&1)break;o=0;ra(41,45940,59226)|0;b=o;o=0;if(b&1)break;o=0;ra(41,45952,59230)|0;b=o;o=0;if(b&1)break;o=0;ra(41,45964,59234)|0;b=o;o=0;if(b&1)break;o=0;ra(41,45976,59238)|0;b=o;o=0;if(b&1)break;o=0;ra(41,45988,59242)|0;b=o;o=0;if(b&1)break;o=0;ra(41,46e3,59246)|0;b=o;o=0;if(b&1)break;c[11503]=45724;Pa(2496);break a}while(0);b=Na()|0;sb(2496);Ya(b|0)}while(0);return c[11503]|0}function lu(b){b=b|0;a:do if((a[2512]|0)==0?(Ha(2512)|0)!=0:0){if((a[2520]|0)==0?(Ha(2520)|0)!=0:0){b=46016;do{c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;b=b+12|0}while((b|0)!=46304);kb(196,0,n|0)|0;Pa(2520)}o=0;ra(42,46016,46304)|0;b=o;o=0;do if((((((((((((((!(b&1)?(o=0,ra(42,46028,46336)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(42,46040,46372)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(42,46052,46396)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(42,46064,46420)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(42,46076,46436)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(42,46088,46456)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(42,46100,46476)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(42,46112,46504)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(42,46124,46544)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(42,46136,46576)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(42,46148,46612)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(42,46160,46648)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(42,46172,46664)|0,b=o,o=0,!(b&1)):0)?(o=0,ra(42,46184,46680)|0,b=o,o=0,!(b&1)):0){o=0;ra(42,46196,46696)|0;b=o;o=0;if(b&1)break;o=0;ra(42,46208,46420)|0;b=o;o=0;if(b&1)break;o=0;ra(42,46220,46712)|0;b=o;o=0;if(b&1)break;o=0;ra(42,46232,46728)|0;b=o;o=0;if(b&1)break;o=0;ra(42,46244,46744)|0;b=o;o=0;if(b&1)break;o=0;ra(42,46256,46760)|0;b=o;o=0;if(b&1)break;o=0;ra(42,46268,46776)|0;b=o;o=0;if(b&1)break;o=0;ra(42,46280,46792)|0;b=o;o=0;if(b&1)break;o=0;ra(42,46292,46808)|0;b=o;o=0;if(b&1)break;c[11706]=46016;Pa(2512);break a}while(0);b=Na()|0;sb(2512);Ya(b|0)}while(0);return c[11706]|0}function mu(b){b=b|0;do if((a[2528]|0)==0?(Ha(2528)|0)!=0:0){if((a[2536]|0)==0?(Ha(2536)|0)!=0:0){b=46828;do{c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;b=b+12|0}while((b|0)!=47116);kb(197,0,n|0)|0;Pa(2536)}o=0;ra(41,46828,59250)|0;b=o;o=0;if(!(b&1)?(o=0,ra(41,46840,59253)|0,b=o,o=0,!(b&1)):0){c[11779]=46828;Pa(2528);break}b=Na()|0;sb(2528);Ya(b|0)}while(0);return c[11779]|0}function nu(b){b=b|0;do if((a[2544]|0)==0?(Ha(2544)|0)!=0:0){if((a[2552]|0)==0?(Ha(2552)|0)!=0:0){b=47120;do{c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;b=b+12|0}while((b|0)!=47408);kb(198,0,n|0)|0;Pa(2552)}o=0;ra(42,47120,47408)|0;b=o;o=0;if(!(b&1)?(o=0,ra(42,47132,47420)|0,b=o,o=0,!(b&1)):0){c[11858]=47120;Pa(2544);break}b=Na()|0;sb(2544);Ya(b|0)}while(0);return c[11858]|0}function ou(b){b=b|0;do if((a[2560]|0)==0?(Ha(2560)|0)!=0:0){o=0;wa(5,47436,59256,8);b=o;o=0;if(b&1){b=Na()|0;sb(2560);Ya(b|0)}else{kb(199,47436,n|0)|0;Pa(2560);break}}while(0);return 47436}function pu(b){b=b|0;var c=0;do if((a[2568]|0)==0?(Ha(2568)|0)!=0:0){o=0;b=ka(76,47448)|0;c=o;o=0;if(!(c&1)?(o=0,wa(15,47484,47448,b|0),c=o,o=0,!(c&1)):0){kb(200,47484,n|0)|0;Pa(2568);break}c=Na()|0;sb(2568);Ya(c|0)}while(0);return 47484}function qu(b){b=b|0;do if((a[2576]|0)==0?(Ha(2576)|0)!=0:0){o=0;wa(5,47496,59265,8);b=o;o=0;if(b&1){b=Na()|0;sb(2576);Ya(b|0)}else{kb(199,47496,n|0)|0;Pa(2576);break}}while(0);return 47496}function ru(b){b=b|0;var c=0;do if((a[2584]|0)==0?(Ha(2584)|0)!=0:0){o=0;b=ka(76,47508)|0;c=o;o=0;if(!(c&1)?(o=0,wa(15,47544,47508,b|0),c=o,o=0,!(c&1)):0){kb(200,47544,n|0)|0;Pa(2584);break}c=Na()|0;sb(2584);Ya(c|0)}while(0);return 47544}function su(b){b=b|0;do if((a[2592]|0)==0?(Ha(2592)|0)!=0:0){o=0;wa(5,47556,59274,20);b=o;o=0;if(b&1){b=Na()|0;sb(2592);Ya(b|0)}else{kb(199,47556,n|0)|0;Pa(2592);break}}while(0);return 47556}function tu(b){b=b|0;var c=0;do if((a[2600]|0)==0?(Ha(2600)|0)!=0:0){o=0;b=ka(76,47568)|0;c=o;o=0;if(!(c&1)?(o=0,wa(15,47652,47568,b|0),c=o,o=0,!(c&1)):0){kb(200,47652,n|0)|0;Pa(2600);break}c=Na()|0;sb(2600);Ya(c|0)}while(0);return 47652}function uu(b){b=b|0;do if((a[2608]|0)==0?(Ha(2608)|0)!=0:0){o=0;wa(5,47664,59295,11);b=o;o=0;if(b&1){b=Na()|0;sb(2608);Ya(b|0)}else{kb(199,47664,n|0)|0;Pa(2608);break}}while(0);return 47664}function vu(b){b=b|0;var c=0;do if((a[2616]|0)==0?(Ha(2616)|0)!=0:0){o=0;b=ka(76,47676)|0;c=o;o=0;if(!(c&1)?(o=0,wa(15,47724,47676,b|0),c=o,o=0,!(c&1)):0){kb(200,47724,n|0)|0;Pa(2616);break}c=Na()|0;sb(2616);Ya(c|0)}while(0);return 47724}function wu(a){a=a|0;var b=0,d=0,e=0;c[a>>2]=44304;a=a+8|0;b=c[a>>2]|0;o=0;d=ua(3)|0;e=o;o=0;do if(!(e&1)){if((b|0)!=(d|0)?(o=0,ha(188,c[a>>2]|0),e=o,o=0,e&1):0)break;return}while(0);e=Na(0)|0;ec(e)}function xu(b,e,f,g,h,j,k){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;z=i;i=i+112|0;m=z;p=(g-f|0)/12|0;do if(p>>>0>100){m=Fl(p)|0;if((m|0)==0?(o=0,xa(6),y=o,o=0,y&1):0){l=0;s=6;break}l=m;s=11}else{l=0;s=11}while(0);a:do if((s|0)==11){if((f|0)==(g|0))n=0;else{s=f;q=0;r=m;while(1){n=a[s>>0]|0;if(!(n&1))n=(n&255)>>>1;else n=c[s+4>>2]|0;if(!n){a[r>>0]=2;n=q+1|0;p=p+-1|0}else{a[r>>0]=1;n=q}s=s+12|0;if((s|0)==(g|0))break;else{q=n;r=r+1|0}}}x=(f|0)==(g|0);y=(f|0)==(g|0);w=0;t=n;b:while(1){n=c[b>>2]|0;do if(n){if((c[n+12>>2]|0)==(c[n+16>>2]|0)){o=0;n=ka(c[(c[n>>2]|0)+36>>2]|0,n|0)|0;v=o;o=0;if(v&1){s=5;break b}if((n|0)==-1){c[b>>2]=0;n=0;break}else{n=c[b>>2]|0;break}}}else n=0;while(0);s=(n|0)==0;q=c[e>>2]|0;if(q){if((c[q+12>>2]|0)==(c[q+16>>2]|0)){o=0;n=ka(c[(c[q>>2]|0)+36>>2]|0,q|0)|0;v=o;o=0;if(v&1){s=5;break}if((n|0)==-1){c[e>>2]=0;q=0}}}else q=0;r=(q|0)==0;n=c[b>>2]|0;if(!((p|0)!=0&(s^r))){s=64;break}q=c[n+12>>2]|0;if((q|0)==(c[n+16>>2]|0)){o=0;n=ka(c[(c[n>>2]|0)+36>>2]|0,n|0)|0;v=o;o=0;if(v&1){s=5;break}}else n=d[q>>0]|0;n=n&255;if(!k){o=0;n=ra(c[(c[h>>2]|0)+12>>2]|0,h|0,n|0)|0;v=o;o=0;if(v&1){s=5;break}}v=w+1|0;if(x){n=0;s=t}else{r=0;u=f;s=t;t=m;while(1){do if((a[t>>0]|0)==1){if(!(a[u>>0]&1))q=u+1|0;else q=c[u+8>>2]|0;q=a[q+w>>0]|0;if(!k){o=0;q=ra(c[(c[h>>2]|0)+12>>2]|0,h|0,q|0)|0;A=o;o=0;if(A&1){s=4;break b}}if(n<<24>>24!=q<<24>>24){a[t>>0]=0;q=r;p=p+-1|0;break}q=a[u>>0]|0;if(!(q&1))q=(q&255)>>>1;else q=c[u+4>>2]|0;if((q|0)==(v|0)){a[t>>0]=2;q=1;s=s+1|0;p=p+-1|0}else q=1}else q=r;while(0);u=u+12|0;if((u|0)==(g|0)){n=q;break}else{r=q;t=t+1|0}}}if(!n){w=v;t=s;continue}n=c[b>>2]|0;q=n+12|0;r=c[q>>2]|0;if((r|0)==(c[n+16>>2]|0)){o=0;ka(c[(c[n>>2]|0)+40>>2]|0,n|0)|0;A=o;o=0;if(A&1){s=5;break}}else c[q>>2]=r+1;if((s+p|0)>>>0<2|y){w=v;t=s;continue}else{n=f;r=s;s=m}while(1){if((a[s>>0]|0)==2){q=a[n>>0]|0;if(!(q&1))q=(q&255)>>>1;else q=c[n+4>>2]|0;if((q|0)!=(v|0)){a[s>>0]=0;r=r+-1|0}}n=n+12|0;if((n|0)==(g|0)){w=v;t=r;continue b}else s=s+1|0}}if((s|0)==4){f=Na()|0;break}else if((s|0)==5){f=Na()|0;break}else if((s|0)==64){do if(n){if((c[n+12>>2]|0)==(c[n+16>>2]|0)){o=0;n=ka(c[(c[n>>2]|0)+36>>2]|0,n|0)|0;A=o;o=0;if(A&1){s=6;break a}if((n|0)==-1){c[b>>2]=0;n=0;break}else{n=c[b>>2]|0;break}}}else n=0;while(0);p=(n|0)==0;do if(!r){if((c[q+12>>2]|0)==(c[q+16>>2]|0)){o=0;n=ka(c[(c[q>>2]|0)+36>>2]|0,q|0)|0;A=o;o=0;if(A&1){s=6;break a}if((n|0)==-1){c[e>>2]=0;s=76;break}}if(!p)s=77}else s=76;while(0);if((s|0)==76?p:0)s=77;if((s|0)==77)c[j>>2]=c[j>>2]|2;c:do if((f|0)==(g|0))s=81;else while(1){if((a[m>>0]|0)==2)break c;f=f+12|0;if((f|0)==(g|0)){s=81;break}else m=m+1|0}while(0);if((s|0)==81){c[j>>2]=c[j>>2]|4;f=g}if(l)Gl(l);i=z;return f|0}}while(0);if((s|0)==6)f=Na()|0;if(l)Gl(l);Ya(f|0);return 0}function yu(b,e,f,g,h,j){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;A=i;i=i+240|0;t=A+202|0;k=A+200|0;C=A+24|0;B=A+12|0;v=A+8|0;y=A+40|0;z=A+4|0;w=A;u=hu(g)|0;kp(C,g,t,k);c[B>>2]=0;c[B+4>>2]=0;c[B+8>>2]=0;if(!(a[B>>0]&1))b=10;else b=(c[B>>2]&-2)+-1|0;o=0;wa(8,B|0,b|0,0);s=o;o=0;a:do if(!(s&1)){q=B+8|0;r=B+1|0;g=(a[B>>0]&1)==0?r:c[q>>2]|0;c[v>>2]=g;c[z>>2]=y;c[w>>2]=0;s=B+4|0;p=a[k>>0]|0;b=c[e>>2]|0;b:while(1){if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;k=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;n=o;o=0;if(n&1){D=24;break}if((k|0)==-1){c[e>>2]=0;b=0}}}else b=0;l=(b|0)==0;k=c[f>>2]|0;do if(k){if((c[k+12>>2]|0)!=(c[k+16>>2]|0))if(l)break;else break b;o=0;m=ka(c[(c[k>>2]|0)+36>>2]|0,k|0)|0;n=o;o=0;if(n&1){D=24;break b}if((m|0)!=-1)if(l)break;else break b;else{c[f>>2]=0;D=16;break}}else D=16;while(0);if((D|0)==16){D=0;if(l){k=0;break}else k=0}l=a[B>>0]|0;l=(l&1)==0?(l&255)>>>1:c[s>>2]|0;if((c[v>>2]|0)==(g+l|0)){o=0;wa(8,B|0,l<<1|0,0);n=o;o=0;if(n&1){D=24;break}if(!(a[B>>0]&1))g=10;else g=(c[B>>2]&-2)+-1|0;o=0;wa(8,B|0,g|0,0);n=o;o=0;if(n&1){D=24;break}g=(a[B>>0]&1)==0?r:c[q>>2]|0;c[v>>2]=g+l}m=b+12|0;l=c[m>>2]|0;n=b+16|0;if((l|0)==(c[n>>2]|0)){o=0;l=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;E=o;o=0;if(E&1){D=24;break}}else l=d[l>>0]|0;if(Wo(l&255,u,g,v,w,p,C,y,z,t)|0)break;k=c[m>>2]|0;if((k|0)==(c[n>>2]|0)){o=0;ka(c[(c[b>>2]|0)+40>>2]|0,b|0)|0;E=o;o=0;if(E&1){D=24;break}else continue}else{c[m>>2]=k+1;continue}}if((D|0)==24){b=Na()|0;break}E=a[C>>0]|0;if((((E&1)==0?(E&255)>>>1:c[C+4>>2]|0)|0)!=0?(x=c[z>>2]|0,(x-y|0)<160):0){E=c[w>>2]|0;c[z>>2]=x+4;c[x>>2]=E}o=0;g=va(21,g|0,c[v>>2]|0,h|0,u|0)|0;E=o;o=0;if(!(E&1)){c[j>>2]=g;Ur(C,y,c[z>>2]|0,h);if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;g=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;E=o;o=0;if(E&1){D=25;break}if((g|0)==-1){c[e>>2]=0;b=0}}}else b=0;g=(b|0)==0;do if(k){if((c[k+12>>2]|0)==(c[k+16>>2]|0)){o=0;b=ka(c[(c[k>>2]|0)+36>>2]|0,k|0)|0;E=o;o=0;if(E&1){D=25;break a}if((b|0)==-1){c[f>>2]=0;D=49;break}}if(!g)D=50}else D=49;while(0);if((D|0)==49?g:0)D=50;if((D|0)==50)c[h>>2]=c[h>>2]|2;E=c[e>>2]|0;Im(B);Im(C);i=A;return E|0}else D=25}else D=25;while(0);if((D|0)==25)b=Na()|0;Im(B);Im(C);Ya(b|0);return 0}function zu(b,e,f,g,h,j){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,E=0,F=0;A=i;i=i+240|0;t=A+202|0;k=A+200|0;C=A+24|0;B=A+12|0;v=A+8|0;y=A+40|0;z=A+4|0;w=A;u=hu(g)|0;kp(C,g,t,k);c[B>>2]=0;c[B+4>>2]=0;c[B+8>>2]=0;if(!(a[B>>0]&1))b=10;else b=(c[B>>2]&-2)+-1|0;o=0;wa(8,B|0,b|0,0);s=o;o=0;a:do if(!(s&1)){q=B+8|0;r=B+1|0;g=(a[B>>0]&1)==0?r:c[q>>2]|0;c[v>>2]=g;c[z>>2]=y;c[w>>2]=0;s=B+4|0;p=a[k>>0]|0;b=c[e>>2]|0;b:while(1){if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;k=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;n=o;o=0;if(n&1){E=24;break}if((k|0)==-1){c[e>>2]=0;b=0}}}else b=0;k=(b|0)==0;l=c[f>>2]|0;do if(l){if((c[l+12>>2]|0)!=(c[l+16>>2]|0))if(k)break;else break b;o=0;m=ka(c[(c[l>>2]|0)+36>>2]|0,l|0)|0;n=o;o=0;if(n&1){E=24;break b}if((m|0)!=-1)if(k)break;else break b;else{c[f>>2]=0;E=16;break}}else E=16;while(0);if((E|0)==16){E=0;if(k){l=0;break}else l=0}k=a[B>>0]|0;k=(k&1)==0?(k&255)>>>1:c[s>>2]|0;if((c[v>>2]|0)==(g+k|0)){o=0;wa(8,B|0,k<<1|0,0);n=o;o=0;if(n&1){E=24;break}if(!(a[B>>0]&1))g=10;else g=(c[B>>2]&-2)+-1|0;o=0;wa(8,B|0,g|0,0);n=o;o=0;if(n&1){E=24;break}g=(a[B>>0]&1)==0?r:c[q>>2]|0;c[v>>2]=g+k}m=b+12|0;k=c[m>>2]|0;n=b+16|0;if((k|0)==(c[n>>2]|0)){o=0;k=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;F=o;o=0;if(F&1){E=24;break}}else k=d[k>>0]|0;if(Wo(k&255,u,g,v,w,p,C,y,z,t)|0)break;k=c[m>>2]|0;if((k|0)==(c[n>>2]|0)){o=0;ka(c[(c[b>>2]|0)+40>>2]|0,b|0)|0;F=o;o=0;if(F&1){E=24;break}else continue}else{c[m>>2]=k+1;continue}}if((E|0)==24){b=Na()|0;break}F=a[C>>0]|0;if((((F&1)==0?(F&255)>>>1:c[C+4>>2]|0)|0)!=0?(x=c[z>>2]|0,(x-y|0)<160):0){F=c[w>>2]|0;c[z>>2]=x+4;c[x>>2]=F}o=0;g=va(22,g|0,c[v>>2]|0,h|0,u|0)|0;k=D;F=o;o=0;if(!(F&1)){F=j;c[F>>2]=g;c[F+4>>2]=k;Ur(C,y,c[z>>2]|0,h);if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;g=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;F=o;o=0;if(F&1){E=25;break}if((g|0)==-1){c[e>>2]=0;b=0}}}else b=0;g=(b|0)==0;do if(l){if((c[l+12>>2]|0)==(c[l+16>>2]|0)){o=0;b=ka(c[(c[l>>2]|0)+36>>2]|0,l|0)|0;F=o;o=0;if(F&1){E=25;break a}if((b|0)==-1){c[f>>2]=0;E=49;break}}if(!g)E=50}else E=49;while(0);if((E|0)==49?g:0)E=50;if((E|0)==50)c[h>>2]=c[h>>2]|2;F=c[e>>2]|0;Im(B);Im(C);i=A;return F|0}else E=25}else E=25;while(0);if((E|0)==25)b=Na()|0;Im(B);Im(C);Ya(b|0);return 0}function Au(e,f,g,h,j,k){e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0;B=i;i=i+240|0;u=B+202|0;l=B+200|0;D=B+24|0;C=B+12|0;w=B+8|0;z=B+40|0;A=B+4|0;x=B;v=hu(h)|0;kp(D,h,u,l);c[C>>2]=0;c[C+4>>2]=0;c[C+8>>2]=0;if(!(a[C>>0]&1))e=10;else e=(c[C>>2]&-2)+-1|0;o=0;wa(8,C|0,e|0,0);t=o;o=0;a:do if(!(t&1)){r=C+8|0;s=C+1|0;h=(a[C>>0]&1)==0?s:c[r>>2]|0;c[w>>2]=h;c[A>>2]=z;c[x>>2]=0;t=C+4|0;q=a[l>>0]|0;e=c[f>>2]|0;b:while(1){if(e){if((c[e+12>>2]|0)==(c[e+16>>2]|0)){o=0;l=ka(c[(c[e>>2]|0)+36>>2]|0,e|0)|0;p=o;o=0;if(p&1){E=24;break}if((l|0)==-1){c[f>>2]=0;e=0}}}else e=0;m=(e|0)==0;l=c[g>>2]|0;do if(l){if((c[l+12>>2]|0)!=(c[l+16>>2]|0))if(m)break;else break b;o=0;n=ka(c[(c[l>>2]|0)+36>>2]|0,l|0)|0;p=o;o=0;if(p&1){E=24;break b}if((n|0)!=-1)if(m)break;else break b;else{c[g>>2]=0;E=16;break}}else E=16;while(0);if((E|0)==16){E=0;if(m){l=0;break}else l=0}m=a[C>>0]|0;m=(m&1)==0?(m&255)>>>1:c[t>>2]|0;if((c[w>>2]|0)==(h+m|0)){o=0;wa(8,C|0,m<<1|0,0);p=o;o=0;if(p&1){E=24;break}if(!(a[C>>0]&1))h=10;else h=(c[C>>2]&-2)+-1|0;o=0;wa(8,C|0,h|0,0);p=o;o=0;if(p&1){E=24;break}h=(a[C>>0]&1)==0?s:c[r>>2]|0;c[w>>2]=h+m}n=e+12|0;m=c[n>>2]|0;p=e+16|0;if((m|0)==(c[p>>2]|0)){o=0;m=ka(c[(c[e>>2]|0)+36>>2]|0,e|0)|0;F=o;o=0;if(F&1){E=24;break}}else m=d[m>>0]|0;if(Wo(m&255,v,h,w,x,q,D,z,A,u)|0)break;l=c[n>>2]|0;if((l|0)==(c[p>>2]|0)){o=0;ka(c[(c[e>>2]|0)+40>>2]|0,e|0)|0;F=o;o=0;if(F&1){E=24;break}else continue}else{c[n>>2]=l+1;continue}}if((E|0)==24){e=Na()|0;break}F=a[D>>0]|0;if((((F&1)==0?(F&255)>>>1:c[D+4>>2]|0)|0)!=0?(y=c[A>>2]|0,(y-z|0)<160):0){F=c[x>>2]|0;c[A>>2]=y+4;c[y>>2]=F}o=0;h=va(23,h|0,c[w>>2]|0,j|0,v|0)|0;F=o;o=0;if(!(F&1)){b[k>>1]=h;Ur(D,z,c[A>>2]|0,j);if(e){if((c[e+12>>2]|0)==(c[e+16>>2]|0)){o=0;h=ka(c[(c[e>>2]|0)+36>>2]|0,e|0)|0;F=o;o=0;if(F&1){E=25;break}if((h|0)==-1){c[f>>2]=0;e=0}}}else e=0;h=(e|0)==0;do if(l){if((c[l+12>>2]|0)==(c[l+16>>2]|0)){o=0;e=ka(c[(c[l>>2]|0)+36>>2]|0,l|0)|0;F=o;o=0;if(F&1){E=25;break a}if((e|0)==-1){c[g>>2]=0;E=49;break}}if(!h)E=50}else E=49;while(0);if((E|0)==49?h:0)E=50;if((E|0)==50)c[j>>2]=c[j>>2]|2;F=c[f>>2]|0;Im(C);Im(D);i=B;return F|0}else E=25}else E=25;while(0);if((E|0)==25)e=Na()|0;Im(C);Im(D);Ya(e|0);return 0}function Bu(b,e,f,g,h,j){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;A=i;i=i+240|0;t=A+202|0;k=A+200|0;C=A+24|0;B=A+12|0;v=A+8|0;y=A+40|0;z=A+4|0;w=A;u=hu(g)|0;kp(C,g,t,k);c[B>>2]=0;c[B+4>>2]=0;c[B+8>>2]=0;if(!(a[B>>0]&1))b=10;else b=(c[B>>2]&-2)+-1|0;o=0;wa(8,B|0,b|0,0);s=o;o=0;a:do if(!(s&1)){q=B+8|0;r=B+1|0;g=(a[B>>0]&1)==0?r:c[q>>2]|0;c[v>>2]=g;c[z>>2]=y;c[w>>2]=0;s=B+4|0;p=a[k>>0]|0;b=c[e>>2]|0;b:while(1){if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;k=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;n=o;o=0;if(n&1){D=24;break}if((k|0)==-1){c[e>>2]=0;b=0}}}else b=0;l=(b|0)==0;k=c[f>>2]|0;do if(k){if((c[k+12>>2]|0)!=(c[k+16>>2]|0))if(l)break;else break b;o=0;m=ka(c[(c[k>>2]|0)+36>>2]|0,k|0)|0;n=o;o=0;if(n&1){D=24;break b}if((m|0)!=-1)if(l)break;else break b;else{c[f>>2]=0;D=16;break}}else D=16;while(0);if((D|0)==16){D=0;if(l){k=0;break}else k=0}l=a[B>>0]|0;l=(l&1)==0?(l&255)>>>1:c[s>>2]|0;if((c[v>>2]|0)==(g+l|0)){o=0;wa(8,B|0,l<<1|0,0);n=o;o=0;if(n&1){D=24;break}if(!(a[B>>0]&1))g=10;else g=(c[B>>2]&-2)+-1|0;o=0;wa(8,B|0,g|0,0);n=o;o=0;if(n&1){D=24;break}g=(a[B>>0]&1)==0?r:c[q>>2]|0;c[v>>2]=g+l}m=b+12|0;l=c[m>>2]|0;n=b+16|0;if((l|0)==(c[n>>2]|0)){o=0;l=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;E=o;o=0;if(E&1){D=24;break}}else l=d[l>>0]|0;if(Wo(l&255,u,g,v,w,p,C,y,z,t)|0)break;k=c[m>>2]|0;if((k|0)==(c[n>>2]|0)){o=0;ka(c[(c[b>>2]|0)+40>>2]|0,b|0)|0;E=o;o=0;if(E&1){D=24;break}else continue}else{c[m>>2]=k+1;continue}}if((D|0)==24){b=Na()|0;break}E=a[C>>0]|0;if((((E&1)==0?(E&255)>>>1:c[C+4>>2]|0)|0)!=0?(x=c[z>>2]|0,(x-y|0)<160):0){E=c[w>>2]|0;c[z>>2]=x+4;c[x>>2]=E}o=0;g=va(24,g|0,c[v>>2]|0,h|0,u|0)|0;E=o;o=0;if(!(E&1)){c[j>>2]=g;Ur(C,y,c[z>>2]|0,h);if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;g=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;E=o;o=0;if(E&1){D=25;break}if((g|0)==-1){c[e>>2]=0;b=0}}}else b=0;g=(b|0)==0;do if(k){if((c[k+12>>2]|0)==(c[k+16>>2]|0)){o=0;b=ka(c[(c[k>>2]|0)+36>>2]|0,k|0)|0;E=o;o=0;if(E&1){D=25;break a}if((b|0)==-1){c[f>>2]=0;D=49;break}}if(!g)D=50}else D=49;while(0);if((D|0)==49?g:0)D=50;if((D|0)==50)c[h>>2]=c[h>>2]|2;E=c[e>>2]|0;Im(B);Im(C);i=A;return E|0}else D=25}else D=25;while(0);if((D|0)==25)b=Na()|0;Im(B);Im(C);Ya(b|0);return 0}function Cu(b,e,f,g,h,j){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;A=i;i=i+240|0;t=A+202|0;k=A+200|0;C=A+24|0;B=A+12|0;v=A+8|0;y=A+40|0;z=A+4|0;w=A;u=hu(g)|0;kp(C,g,t,k);c[B>>2]=0;c[B+4>>2]=0;c[B+8>>2]=0;if(!(a[B>>0]&1))b=10;else b=(c[B>>2]&-2)+-1|0;o=0;wa(8,B|0,b|0,0);s=o;o=0;a:do if(!(s&1)){q=B+8|0;r=B+1|0;g=(a[B>>0]&1)==0?r:c[q>>2]|0;c[v>>2]=g;c[z>>2]=y;c[w>>2]=0;s=B+4|0;p=a[k>>0]|0;b=c[e>>2]|0;b:while(1){if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;k=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;n=o;o=0;if(n&1){D=24;break}if((k|0)==-1){c[e>>2]=0;b=0}}}else b=0;l=(b|0)==0;k=c[f>>2]|0;do if(k){if((c[k+12>>2]|0)!=(c[k+16>>2]|0))if(l)break;else break b;o=0;m=ka(c[(c[k>>2]|0)+36>>2]|0,k|0)|0;n=o;o=0;if(n&1){D=24;break b}if((m|0)!=-1)if(l)break;else break b;else{c[f>>2]=0;D=16;break}}else D=16;while(0);if((D|0)==16){D=0;if(l){k=0;break}else k=0}l=a[B>>0]|0;l=(l&1)==0?(l&255)>>>1:c[s>>2]|0;if((c[v>>2]|0)==(g+l|0)){o=0;wa(8,B|0,l<<1|0,0);n=o;o=0;if(n&1){D=24;break}if(!(a[B>>0]&1))g=10;else g=(c[B>>2]&-2)+-1|0;o=0;wa(8,B|0,g|0,0);n=o;o=0;if(n&1){D=24;break}g=(a[B>>0]&1)==0?r:c[q>>2]|0;c[v>>2]=g+l}m=b+12|0;l=c[m>>2]|0;n=b+16|0;if((l|0)==(c[n>>2]|0)){o=0;l=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;E=o;o=0;if(E&1){D=24;break}}else l=d[l>>0]|0;if(Wo(l&255,u,g,v,w,p,C,y,z,t)|0)break;k=c[m>>2]|0;if((k|0)==(c[n>>2]|0)){o=0;ka(c[(c[b>>2]|0)+40>>2]|0,b|0)|0;E=o;o=0;if(E&1){D=24;break}else continue}else{c[m>>2]=k+1;continue}}if((D|0)==24){b=Na()|0;break}E=a[C>>0]|0;if((((E&1)==0?(E&255)>>>1:c[C+4>>2]|0)|0)!=0?(x=c[z>>2]|0,(x-y|0)<160):0){E=c[w>>2]|0;c[z>>2]=x+4;c[x>>2]=E}o=0;g=va(25,g|0,c[v>>2]|0,h|0,u|0)|0;E=o;o=0;if(!(E&1)){c[j>>2]=g;Ur(C,y,c[z>>2]|0,h);if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;g=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;E=o;o=0;if(E&1){D=25;break}if((g|0)==-1){c[e>>2]=0;b=0}}}else b=0;g=(b|0)==0;do if(k){if((c[k+12>>2]|0)==(c[k+16>>2]|0)){o=0;b=ka(c[(c[k>>2]|0)+36>>2]|0,k|0)|0;E=o;o=0;if(E&1){D=25;break a}if((b|0)==-1){c[f>>2]=0;D=49;break}}if(!g)D=50}else D=49;while(0);if((D|0)==49?g:0)D=50;if((D|0)==50)c[h>>2]=c[h>>2]|2;E=c[e>>2]|0;Im(B);Im(C);i=A;return E|0}else D=25}else D=25;while(0);if((D|0)==25)b=Na()|0;Im(B);Im(C);Ya(b|0);return 0}function Du(b,e,f,g,h,j){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,E=0,F=0;A=i;i=i+240|0;t=A+202|0;k=A+200|0;C=A+24|0;B=A+12|0;v=A+8|0;y=A+40|0;z=A+4|0;w=A;u=hu(g)|0;kp(C,g,t,k);c[B>>2]=0;c[B+4>>2]=0;c[B+8>>2]=0;if(!(a[B>>0]&1))b=10;else b=(c[B>>2]&-2)+-1|0;o=0;wa(8,B|0,b|0,0);s=o;o=0;a:do if(!(s&1)){q=B+8|0;r=B+1|0;g=(a[B>>0]&1)==0?r:c[q>>2]|0;c[v>>2]=g;c[z>>2]=y;c[w>>2]=0;s=B+4|0;p=a[k>>0]|0;b=c[e>>2]|0;b:while(1){if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;k=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;n=o;o=0;if(n&1){E=24;break}if((k|0)==-1){c[e>>2]=0;b=0}}}else b=0;k=(b|0)==0;l=c[f>>2]|0;do if(l){if((c[l+12>>2]|0)!=(c[l+16>>2]|0))if(k)break;else break b;o=0;m=ka(c[(c[l>>2]|0)+36>>2]|0,l|0)|0;n=o;o=0;if(n&1){E=24;break b}if((m|0)!=-1)if(k)break;else break b;else{c[f>>2]=0;E=16;break}}else E=16;while(0);if((E|0)==16){E=0;if(k){l=0;break}else l=0}k=a[B>>0]|0;k=(k&1)==0?(k&255)>>>1:c[s>>2]|0;if((c[v>>2]|0)==(g+k|0)){o=0;wa(8,B|0,k<<1|0,0);n=o;o=0;if(n&1){E=24;break}if(!(a[B>>0]&1))g=10;else g=(c[B>>2]&-2)+-1|0;o=0;wa(8,B|0,g|0,0);n=o;o=0;if(n&1){E=24;break}g=(a[B>>0]&1)==0?r:c[q>>2]|0;c[v>>2]=g+k}m=b+12|0;k=c[m>>2]|0;n=b+16|0;if((k|0)==(c[n>>2]|0)){o=0;k=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;F=o;o=0;if(F&1){E=24;break}}else k=d[k>>0]|0;if(Wo(k&255,u,g,v,w,p,C,y,z,t)|0)break;k=c[m>>2]|0;if((k|0)==(c[n>>2]|0)){o=0;ka(c[(c[b>>2]|0)+40>>2]|0,b|0)|0;F=o;o=0;if(F&1){E=24;break}else continue}else{c[m>>2]=k+1;continue}}if((E|0)==24){b=Na()|0;break}F=a[C>>0]|0;if((((F&1)==0?(F&255)>>>1:c[C+4>>2]|0)|0)!=0?(x=c[z>>2]|0,(x-y|0)<160):0){F=c[w>>2]|0;c[z>>2]=x+4;c[x>>2]=F}o=0;g=va(26,g|0,c[v>>2]|0,h|0,u|0)|0;k=D;F=o;o=0;if(!(F&1)){F=j;c[F>>2]=g;c[F+4>>2]=k;Ur(C,y,c[z>>2]|0,h);if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;g=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;F=o;o=0;if(F&1){E=25;break}if((g|0)==-1){c[e>>2]=0;b=0}}}else b=0;g=(b|0)==0;do if(l){if((c[l+12>>2]|0)==(c[l+16>>2]|0)){o=0;b=ka(c[(c[l>>2]|0)+36>>2]|0,l|0)|0;F=o;o=0;if(F&1){E=25;break a}if((b|0)==-1){c[f>>2]=0;E=49;break}}if(!g)E=50}else E=49;while(0);if((E|0)==49?g:0)E=50;if((E|0)==50)c[h>>2]=c[h>>2]|2;F=c[e>>2]|0;Im(B);Im(C);i=A;return F|0}else E=25}else E=25;while(0);if((E|0)==25)b=Na()|0;Im(B);Im(C);Ya(b|0);return 0}function Eu(b,e,f,h,j,k){b=b|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;var l=0.0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0;E=i;i=i+240|0;w=E+208|0;m=E+203|0;n=E+202|0;G=E+24|0;F=E+12|0;y=E+8|0;C=E+40|0;D=E+4|0;z=E;A=E+201|0;x=E+200|0;lp(G,h,w,m,n);c[F>>2]=0;c[F+4>>2]=0;c[F+8>>2]=0;if(!(a[F>>0]&1))b=10;else b=(c[F>>2]&-2)+-1|0;o=0;wa(8,F|0,b|0,0);v=o;o=0;a:do if(!(v&1)){t=F+8|0;u=F+1|0;h=(a[F>>0]&1)==0?u:c[t>>2]|0;c[y>>2]=h;c[D>>2]=C;c[z>>2]=0;a[A>>0]=1;a[x>>0]=69;v=F+4|0;s=a[m>>0]|0;r=a[n>>0]|0;b=c[e>>2]|0;b:while(1){if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;m=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;q=o;o=0;if(q&1){H=24;break}if((m|0)==-1){c[e>>2]=0;b=0}}}else b=0;n=(b|0)==0;m=c[f>>2]|0;do if(m){if((c[m+12>>2]|0)!=(c[m+16>>2]|0))if(n)break;else break b;o=0;p=ka(c[(c[m>>2]|0)+36>>2]|0,m|0)|0;q=o;o=0;if(q&1){H=24;break b}if((p|0)!=-1)if(n)break;else break b;else{c[f>>2]=0;H=16;break}}else H=16;while(0);if((H|0)==16){H=0;if(n){m=0;break}else m=0}n=a[F>>0]|0;n=(n&1)==0?(n&255)>>>1:c[v>>2]|0;if((c[y>>2]|0)==(h+n|0)){o=0;wa(8,F|0,n<<1|0,0);q=o;o=0;if(q&1){H=24;break}if(!(a[F>>0]&1))h=10;else h=(c[F>>2]&-2)+-1|0;o=0;wa(8,F|0,h|0,0);q=o;o=0;if(q&1){H=24;break}h=(a[F>>0]&1)==0?u:c[t>>2]|0;c[y>>2]=h+n}p=b+12|0;n=c[p>>2]|0;q=b+16|0;if((n|0)==(c[q>>2]|0)){o=0;n=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;I=o;o=0;if(I&1){H=24;break}}else n=d[n>>0]|0;if(mp(n&255,A,x,h,y,s,r,G,C,D,z,w)|0)break;m=c[p>>2]|0;if((m|0)==(c[q>>2]|0)){o=0;ka(c[(c[b>>2]|0)+40>>2]|0,b|0)|0;I=o;o=0;if(I&1){H=24;break}else continue}else{c[p>>2]=m+1;continue}}if((H|0)==24){b=Na()|0;break}I=a[G>>0]|0;if(!((a[A>>0]|0)==0?1:(((I&1)==0?(I&255)>>>1:c[G+4>>2]|0)|0)==0)?(B=c[D>>2]|0,(B-C|0)<160):0){I=c[z>>2]|0;c[D>>2]=B+4;c[B>>2]=I}o=0;l=+ta(1,h|0,c[y>>2]|0,j|0);I=o;o=0;if(!(I&1)){g[k>>2]=l;Ur(G,C,c[D>>2]|0,j);if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;h=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;I=o;o=0;if(I&1){H=25;break}if((h|0)==-1){c[e>>2]=0;b=0}}}else b=0;h=(b|0)==0;do if(m){if((c[m+12>>2]|0)==(c[m+16>>2]|0)){o=0;b=ka(c[(c[m>>2]|0)+36>>2]|0,m|0)|0;I=o;o=0;if(I&1){H=25;break a}if((b|0)==-1){c[f>>2]=0;H=49;break}}if(!h)H=50}else H=49;while(0);if((H|0)==49?h:0)H=50;if((H|0)==50)c[j>>2]=c[j>>2]|2;I=c[e>>2]|0;Im(F);Im(G);i=E;return I|0}else H=25}else H=25;while(0);if((H|0)==25)b=Na()|0;Im(F);Im(G);Ya(b|0);return 0}function Fu(b,e,f,g,j,k){b=b|0;e=e|0;f=f|0;g=g|0;j=j|0;k=k|0;var l=0.0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0;E=i;i=i+240|0;w=E+208|0;m=E+203|0;n=E+202|0;G=E+24|0;F=E+12|0;y=E+8|0;C=E+40|0;D=E+4|0;z=E;A=E+201|0;x=E+200|0;lp(G,g,w,m,n);c[F>>2]=0;c[F+4>>2]=0;c[F+8>>2]=0;if(!(a[F>>0]&1))b=10;else b=(c[F>>2]&-2)+-1|0;o=0;wa(8,F|0,b|0,0);v=o;o=0;a:do if(!(v&1)){t=F+8|0;u=F+1|0;g=(a[F>>0]&1)==0?u:c[t>>2]|0;c[y>>2]=g;c[D>>2]=C;c[z>>2]=0;a[A>>0]=1;a[x>>0]=69;v=F+4|0;s=a[m>>0]|0;r=a[n>>0]|0;b=c[e>>2]|0;b:while(1){if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;m=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;q=o;o=0;if(q&1){H=24;break}if((m|0)==-1){c[e>>2]=0;b=0}}}else b=0;n=(b|0)==0;m=c[f>>2]|0;do if(m){if((c[m+12>>2]|0)!=(c[m+16>>2]|0))if(n)break;else break b;o=0;p=ka(c[(c[m>>2]|0)+36>>2]|0,m|0)|0;q=o;o=0;if(q&1){H=24;break b}if((p|0)!=-1)if(n)break;else break b;else{c[f>>2]=0;H=16;break}}else H=16;while(0);if((H|0)==16){H=0;if(n){m=0;break}else m=0}n=a[F>>0]|0;n=(n&1)==0?(n&255)>>>1:c[v>>2]|0;if((c[y>>2]|0)==(g+n|0)){o=0;wa(8,F|0,n<<1|0,0);q=o;o=0;if(q&1){H=24;break}if(!(a[F>>0]&1))g=10;else g=(c[F>>2]&-2)+-1|0;o=0;wa(8,F|0,g|0,0);q=o;o=0;if(q&1){H=24;break}g=(a[F>>0]&1)==0?u:c[t>>2]|0;c[y>>2]=g+n}p=b+12|0;n=c[p>>2]|0;q=b+16|0;if((n|0)==(c[q>>2]|0)){o=0;n=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;I=o;o=0;if(I&1){H=24;break}}else n=d[n>>0]|0;if(mp(n&255,A,x,g,y,s,r,G,C,D,z,w)|0)break;m=c[p>>2]|0;if((m|0)==(c[q>>2]|0)){o=0;ka(c[(c[b>>2]|0)+40>>2]|0,b|0)|0;I=o;o=0;if(I&1){H=24;break}else continue}else{c[p>>2]=m+1;continue}}if((H|0)==24){b=Na()|0;break}I=a[G>>0]|0;if(!((a[A>>0]|0)==0?1:(((I&1)==0?(I&255)>>>1:c[G+4>>2]|0)|0)==0)?(B=c[D>>2]|0,(B-C|0)<160):0){I=c[z>>2]|0;c[D>>2]=B+4;c[B>>2]=I}o=0;l=+ta(2,g|0,c[y>>2]|0,j|0);I=o;o=0;if(!(I&1)){h[k>>3]=l;Ur(G,C,c[D>>2]|0,j);if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;g=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;I=o;o=0;if(I&1){H=25;break}if((g|0)==-1){c[e>>2]=0;b=0}}}else b=0;g=(b|0)==0;do if(m){if((c[m+12>>2]|0)==(c[m+16>>2]|0)){o=0;b=ka(c[(c[m>>2]|0)+36>>2]|0,m|0)|0;I=o;o=0;if(I&1){H=25;break a}if((b|0)==-1){c[f>>2]=0;H=49;break}}if(!g)H=50}else H=49;while(0);if((H|0)==49?g:0)H=50;if((H|0)==50)c[j>>2]=c[j>>2]|2;I=c[e>>2]|0;Im(F);Im(G);i=E;return I|0}else H=25}else H=25;while(0);if((H|0)==25)b=Na()|0;Im(F);Im(G);Ya(b|0);return 0}function Gu(b,e,f,g,j,k){b=b|0;e=e|0;f=f|0;g=g|0;j=j|0;k=k|0;var l=0.0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0;E=i;i=i+240|0;w=E+208|0;m=E+203|0;n=E+202|0;G=E+24|0;F=E+12|0;y=E+8|0;C=E+40|0;D=E+4|0;z=E;A=E+201|0;x=E+200|0;lp(G,g,w,m,n);c[F>>2]=0;c[F+4>>2]=0;c[F+8>>2]=0;if(!(a[F>>0]&1))b=10;else b=(c[F>>2]&-2)+-1|0;o=0;wa(8,F|0,b|0,0);v=o;o=0;a:do if(!(v&1)){t=F+8|0;u=F+1|0;g=(a[F>>0]&1)==0?u:c[t>>2]|0;c[y>>2]=g;c[D>>2]=C;c[z>>2]=0;a[A>>0]=1;a[x>>0]=69;v=F+4|0;s=a[m>>0]|0;r=a[n>>0]|0;b=c[e>>2]|0;b:while(1){if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;m=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;q=o;o=0;if(q&1){H=24;break}if((m|0)==-1){c[e>>2]=0;b=0}}}else b=0;n=(b|0)==0;m=c[f>>2]|0;do if(m){if((c[m+12>>2]|0)!=(c[m+16>>2]|0))if(n)break;else break b;o=0;p=ka(c[(c[m>>2]|0)+36>>2]|0,m|0)|0;q=o;o=0;if(q&1){H=24;break b}if((p|0)!=-1)if(n)break;else break b;else{c[f>>2]=0;H=16;break}}else H=16;while(0);if((H|0)==16){H=0;if(n){m=0;break}else m=0}n=a[F>>0]|0;n=(n&1)==0?(n&255)>>>1:c[v>>2]|0;if((c[y>>2]|0)==(g+n|0)){o=0;wa(8,F|0,n<<1|0,0);q=o;o=0;if(q&1){H=24;break}if(!(a[F>>0]&1))g=10;else g=(c[F>>2]&-2)+-1|0;o=0;wa(8,F|0,g|0,0);q=o;o=0;if(q&1){H=24;break}g=(a[F>>0]&1)==0?u:c[t>>2]|0;c[y>>2]=g+n}p=b+12|0;n=c[p>>2]|0;q=b+16|0;if((n|0)==(c[q>>2]|0)){o=0;n=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;I=o;o=0;if(I&1){H=24;break}}else n=d[n>>0]|0;if(mp(n&255,A,x,g,y,s,r,G,C,D,z,w)|0)break;m=c[p>>2]|0;if((m|0)==(c[q>>2]|0)){o=0;ka(c[(c[b>>2]|0)+40>>2]|0,b|0)|0;I=o;o=0;if(I&1){H=24;break}else continue}else{c[p>>2]=m+1;continue}}if((H|0)==24){b=Na()|0;break}I=a[G>>0]|0;if(!((a[A>>0]|0)==0?1:(((I&1)==0?(I&255)>>>1:c[G+4>>2]|0)|0)==0)?(B=c[D>>2]|0,(B-C|0)<160):0){I=c[z>>2]|0;c[D>>2]=B+4;c[B>>2]=I}o=0;l=+ta(3,g|0,c[y>>2]|0,j|0);I=o;o=0;if(!(I&1)){h[k>>3]=l;Ur(G,C,c[D>>2]|0,j);if(b){if((c[b+12>>2]|0)==(c[b+16>>2]|0)){o=0;g=ka(c[(c[b>>2]|0)+36>>2]|0,b|0)|0;I=o;o=0;if(I&1