# Browser Support

## Overview

To enjoy the best and most secure experience, we recommend you keep your browser and operating system updated. X\_ITE will support the current and previous major releases of:

## Desktop

Since April 2016 **Chrome** supports all WebGL and JavaScript ES 6 features required by X\_ITE. We support the current version and the previous version of Chrome, although X\_ITE also runs fine in older versions.
<https://www.google.com/chrome>

**Firefox** as the first browser that supports everything X\_ITE needs and is extensively tested since years. We have full support for Firefox.
<https://www.mozilla.org/firefox/products/>

**Safari** has excellent support for WebGL and JavaScript ES 6 and is as much popular as other browsers especially on MacOS X. Keep your Mac up to date to have the best experience we can give.
<https://www.apple.com/safari/>

**Opera** uses the same rendering engine used by Safari and Chrome and is therefore fully supported since April 2016. Always use the latest version of Opera to make your Internet experience more secure and enjoyable.
<https://www.opera.com/>

Starting with Windows 10 X\_ITE runs fine in **Microsoft Edge** and is fully supported. Microsoft Edge provides everything X\_ITE needs to give you the best performance.
<https://www.microsoft.com/windows/microsoft-edge>

## Mobile

All stock browser on **Android** 4.0+ support WebGL and JavaScript ES 6 natively. Always keep in mind to keep your files small in size and always consider to optimize for performance.
<https://www.android.com/>

iOS has good support since **Safari** on iOS 7+. Simplify your scenes and test them extensively to achieve the best results how you would like it to be.
<https://www.apple.com/ios/>

**Any problem with X\_ITE in the above browsers should be reported as a bug in X\_ITE. See [Report a Bug](https://github.com/create3000/x_ite/issues).**
{: .notice--info}

We do not support older browsers like Internet Explorer 6-9, Opera 12.1x or Safari 5.1+.

## Unsupported Browsers

While X\_ITE *might* run without major issues in older browser versions, we do not actively test X\_ITE in them and generally do not fix bugs that may appear in them.

Similarly, X\_ITE does not fix bugs in pre-release versions of browsers, such as beta or dev releases. If you find a bug with X\_ITE in a pre-release of a browser, you should report the bug to the browser vendor.

## About Browser Support

X\_ITE is constantly tested with all of its supported browsers via unit tests. However, a web page using X\_ITE may not work in the same set of browsers if its own code takes advantage of (or falls prey to) browser-specific behaviors. Testing is essential to fully support a browser. The Microsoft Edge Developer site makes available [virtual machines](https://dev.windows.com/en-us/microsoft-edge/tools/vms/) for testing many different versions of Internet Explorer. Older versions of other browsers can be found at [oldversion.com](http://oldversion.com/).

Only the most current version of X\_ITE is tested and updated to fix bugs or add features. Users of older versions that find a bug should upgrade to the latest released version to determine if the bug has already been fixed.
