# Introducing X3D

## What is X3D?

X3D is:

- A simple text language for describing 3-D shapes and interactive environments
- X3D text files use a .x3d, x3dj, x3dv, or .x3db extension
  - .x3d (XML) - save to parse
  - .x3dj (JSON) - good for scripting
  - .x3dv (VRML) - easy to learn
  - x3db (Binary) - good for large models

**Note:** all examples are in X3D Classic Encoded file format (.x3dv).

## What do I need to use X3D?

You can view X3D files using a X3D browser:

- A X3D standalone application
- A X3D JavaScript plug-in like to an HTML browser

You can view X3D files from your local hard disk, or from the Internet.

## How can X3D be used on a Web page?

- Fill Web page
- Embed into Web page
- Fill Web page frame
- Embed into Web page frame
- Embed multiple times

## What do I need to develop in X3D?

You can construct X3D files using:

- A text editor
- A authoring tool
- A 3D modeler and format translator
- A shape generator (like a Python, or Perl script)

## Should I use a text editor?

Pros:

- No new software to buy
- Access to all X3D features
- Detailed control of world efficiency

Cons:

- Hard to author complex 3D shapes
- Requires knowledge of X3D syntax

## Should I use a authoring tool?

Pros:

- Easy 3-D drawing and animating user interface
- Little need to learn X3D syntax

Cons:

- May not support all X3D features
- May not produce most efficient X3D

## Should I use a 3D modeler and format translator?

Pros:

- Very powerful drawing and animating features
- Can make photo-realistic images too

Cons:

- May not support all X3D features
- May not produce most efficient X3D
- Not designed for X3D
- Often a one-way path from 3D modeler into X3D
- Easy to make shapes that are too complex

## Should I use a shape generator?

Pros:

- Easy way to generate complex shapes
- Fractal mountains, logos, etc.
- Generate X3D from PHP scripts
- Common to extend science applications to generate X3D

Cons:

- Only suitable for narrow set of shapes
- Best used with other software
