/* -*- Mode: JavaScript; coding: utf-8; tab-width: 3; indent-tabs-mode: tab; c-basic-offset: 3 -*-
 *******************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright create3000, Scheffelstraße 31a, Leipzig, Germany 2011.
 *
 * All rights reserved. Holger Seelig <holger.seelig@yahoo.de>.
 *
 * The copyright notice above does not evidence any actual of intended
 * publication of such source code, and is an unpublished work by create3000.
 * This material contains CONFIDENTIAL INFORMATION that is the property of
 * create3000.
 *
 * No permission is granted to copy, distribute, or create derivative works from
 * the contents of this software, in whole or in part, without the prior written
 * permission of create3000.
 *
 * NON-MILITARY USE ONLY
 *
 * All create3000 software are effectively free software with a non-military use
 * restriction. It is free. Well commented source is provided. You may reuse the
 * source in any way you please with the exception anything that uses it must be
 * marked to indicate is contains 'non-military use only' components.
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2015, 2016 Holger Seelig <holger.seelig@yahoo.de>.
 *
 * This file is part of the X_ITE Project.
 *
 * X_ITE is free software: you can redistribute it and/or modify it under the
 * terms of the GNU General Public License version 3 only, as published by the
 * Free Software Foundation.
 *
 * X_ITE is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License version 3 for more
 * details (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version 3
 * along with X_ITE.  If not, see <http://www.gnu.org/licenses/gpl.html> for a
 * copy of the GPLv3 License.
 *
 * For Silvio, Joy and Adi.
 *
 ******************************************************************************/


define ([
	"x_ite/Fields",
	"x_ite/Basic/X3DFieldDefinition",
	"x_ite/Basic/FieldDefinitionArray",
	"x_ite/Components/Rendering/X3DColorNode",
	"x_ite/Bits/X3DConstants",
	"standard/Math/Numbers/Vector4",
],
function (Fields,
          X3DFieldDefinition,
          FieldDefinitionArray,
          X3DColorNode,
          X3DConstants,
          Vector4)
{
"use strict";

	function Color (executionContext)
	{
		X3DColorNode .call (this, executionContext);

		this .addType (X3DConstants .Color);
	}

	Color .prototype = Object .assign (Object .create (X3DColorNode .prototype),
	{
		constructor: Color,
		fieldDefinitions: new FieldDefinitionArray ([
			new X3DFieldDefinition (X3DConstants .inputOutput, "metadata", new Fields .SFNode ()),
			new X3DFieldDefinition (X3DConstants .inputOutput, "color",    new Fields .MFColor ()),
		]),
		getTypeName: function ()
		{
			return "Color";
		},
		getComponentName: function ()
		{
			return "Rendering";
		},
		getContainerField: function ()
		{
			return "color";
		},
		initialize: function ()
		{
			X3DColorNode .prototype .initialize .call (this);

			this .color_ .addInterest ("set_color__", this);

			this .set_color__ ();
		},
		set_color__: function ()
		{
			this .color  = this .color_ .getValue ();
			this .length = this .color_ .length;
		},
		addColor: function (index, array)
		{
			if (index >= 0 && index < this .length)
			{
				const color = this .color;

				index *= 3;

				array .push (color [index], color [index + 1], color [index + 2], 1);
			}
			else if (this .length)
			{
				const color = this .color;

				index = (this .length - 1) * 3;

				array .push (color [index], color [index + 1], color [index + 2], 1);
			}
			else
			{
				array .push (1, 1, 1, 1);
			}
		},
		addColors: function (array, min)
		{
			if (this .length)
			{
				const color = this .color;

				for (var index = 0, length = this .length * 3; index < length; index += 3)
					array .push (color [index], color [index + 1], color [index + 2], 1);

				var index = (this .length - 1) * 3;

				const
					r = color [index],
					g = color [index + 1],
					b = color [index + 2];

				for (var index = length, length = min * 3; index < length; index += 3)
					array .push (r, g, b, 1);
			}
			else
			{
				for (var index = 0; index < min; ++ index)
					array .push (1, 1, 1, 1);
			}
		},
		getVectors: function (array)
		{
			const color = this .color_;

			for (var i = 0, length = color .length; i < length; ++ i)
			{
				var c = color [i];

				array [i] = new Vector4 (c .r, c .g, c .b, 1);
			}

			array .length = length;

			return array;
		},
	});

	return Color;
});
