!function(){const e=window[Symbol.for("X_ITE.X3D-5.0.0")].define,t=window[Symbol.for("X_ITE.X3D-5.0.0")].require;e("standard/Math/Geometry/Spheroid3",[],(function(){"use strict";function e(e,t){switch(arguments.length){case 0:this.semiMajorAxis=0,this.semiMinorAxis=0;break;case 2:this.semiMajorAxis=e,this.semiMinorAxis=t;break;case 3:const i=arguments[1];this.semiMajorAxis=e,this.semiMinorAxis=e*(1-1/i)}}return e.prototype={constructor:e,getSemiMajorAxis:function(){return this.semiMajorAxis},getSemiMinorAxis:function(){return this.semiMinorAxis},toString:function(){return this.semiMajorAxis+" "+this.semiMinorAxis}},e})),e("standard/Geospatial/ReferenceEllipsoids",["standard/Math/Geometry/Spheroid3"],(function(e){"use strict";return{AA:new e(6377563.396,299.3249646,!0),AM:new e(6377340.189,299.3249646,!0),AN:new e(6378160,298.25,!0),BN:new e(6377483.865,299.1528128,!0),BR:new e(6377397.155,299.1528128,!0),CC:new e(6378206.4,294.9786982,!0),CD:new e(6378249.145,293.465,!0),EA:new e(6377276.345,300.8017,!0),EB:new e(6377298.556,300.8017,!0),EC:new e(6377301.243,300.8017,!0),ED:new e(6377295.664,300.8017,!0),EE:new e(6377304.063,300.8017,!0),EF:new e(6377309.613,300.8017,!0),FA:new e(6378155,298.3,!0),HE:new e(6378200,298.3,!0),HO:new e(6378270,297,!0),ID:new e(6378160,298.247,!0),IN:new e(6378388,297,!0),KA:new e(6378245,298.3,!0),RF:new e(6378137,298.257222101,!0),SA:new e(6378160,298.25,!0),WD:new e(6378135,298.26,!0),WE:new e(6378137,298.257223563,!0),SUN:new e(696342e3,1/9e-6,!0),MERCURY:new e(2439700,2439700),VENUS:new e(6051800,6051800),MOON:new e(1738140,1735970),MARS:new e(3395428,3377678),JUPITER:new e(71492e3,66854e3),SATURN:new e(60268e3,54364e3),URANUS:new e(2555e3,24973e3),NEPTUNE:new e(24764e3,24341e3),PLUTO:new e(1153e3,1153e3)}})),e("standard/Geospatial/Geodetic",["standard/Math/Numbers/Vector3","standard/Math/Algorithm"],(function(e,t){"use strict";function i(e,t,i){this.longitudeFirst=!t,this.degrees=!i,this.a=e.getSemiMajorAxis(),this.c=e.getSemiMinorAxis(),this.c2a2=Math.pow(e.getSemiMinorAxis()/this.a,2),this.ecc2=1-this.c2a2}return i.prototype={constructor:i,convert:function(e,t){const i=e.z;if(this.longitudeFirst)var n=e.y,o=e.x;else n=e.x,o=e.y;return this.degrees&&(n*=Math.PI/180,o*=Math.PI/180),this.convertRadians(n,o,i,t)},convertRadians:function(e,t,i,n){const o=Math.sin(e),s=Math.pow(o,2),r=Math.cos(e),a=this.a/Math.sqrt(1-this.ecc2*s),l=(a+i)*r;return n.set(l*Math.cos(t),l*Math.sin(t),(a*this.c2a2+i)*o)},apply:function(e,t){if(this.applyRadians(e,t),this.degrees&&(t.x*=180/Math.PI,t.y*=180/Math.PI),this.longitudeFirst){const e=t.x;t.x=t.y,t.y=e}return t},applyRadians:function(e,t){const i=e.x,n=e.y,o=e.z,s=Math.sqrt(i*i+n*n);if(0==s)return t.set(Math.PI,0,o-this.c);let r=0,a=Math.atan2(n,i),l=0,h=this.a,c=h,d=this.ecc2;for(let e=0;e<30;++e){const e=l,t=r;r=Math.atan(o/s/(1-d*c/(c+l)));const i=Math.sin(r);if(c=h/Math.sqrt(1-d*i*i),l=s/Math.cos(r)-c,Math.abs(l-e)<.001&&Math.abs(r-t)<1e-10)break}return t.set(r,a,l)},normal:function(e,t){const i=this.applyRadians(e,t),n=i.x,o=i.y,s=Math.cos(n),r=Math.cos(o)*s,a=Math.sin(o)*s,l=Math.sin(n);return t.set(r,a,l)}},i})),e("standard/Geospatial/UniversalTransverseMercator",["standard/Geospatial/Geodetic","standard/Math/Numbers/Vector3","standard/Math/Algorithm"],(function(e,t,i){"use strict";const n=1e7,o=5e5,s=.9996;function r(t,n,o,r){const a=t.getSemiMajorAxis(),l=1-Math.pow(t.getSemiMinorAxis()/a,2),h=l/(1-l),c=(1-Math.sqrt(1-l))/(1+Math.sqrt(1-l));this.southernHemisphere=!o,this.eastingFirst=!r,this.a=a,this.ecc2=l,this.EE=h,this.E8=8*h,this.E9=9*h,this.E252=252*h,this.e1=c,this.A=s*(a*(1-l/4-3*l*l/64-5*l*l*l/256)),this.B=3*c/2-7*c*c*c/32,this.C=21*c*c/16-55*c*c*c*c/32,this.D=151*c*c*c/96,this.E=a*(1-l),this.W=1-l/4-3*l*l/64-5*l*l*l/256,this.X=3*l/8+3*l*l/32+45*l*l*l/1024,this.Y=15*l*l/256+45*l*l*l/1024,this.Z=35*l*l*l/3072,this.longitude0=i.radians(6*n-183),this.geodeticConverter=new e(t,!0,!0)}return r.prototype={constructor:r,convert:function(e,t){if(this.eastingFirst)var i=e.y,r=e.x;else i=e.x,r=e.y;let a=this.southernHemisphere;i<0&&(a=!this.southernHemisphere,i=-i),a&&(i-=n),r-=o;const l=i/this.A,h=l+this.B*Math.sin(2*l)+this.C*Math.sin(4*l)+this.D*Math.sin(6*l),c=Math.pow(Math.sin(h),2),d=Math.cos(h),u=Math.tan(h),p=this.a/Math.sqrt(1-this.ecc2*c),_=Math.pow(u,2),g=Math.pow(u,8),w=this.EE*_,f=w*w,m=this.E/Math.pow(1-this.ecc2*c,1.5),O=r/(p*s),y=(5+3*_+10*w-4*f-this.E9)*Math.pow(O,4)/24,x=(61+90*_+298*w+45*g-this.E252-3*f)*Math.pow(O,6)/720,S=(5-2*w+28*_-3*f+this.E8+24*g)*Math.pow(O,5)/120,F=h-p*u/m*(O*O/2-y+x),C=this.longitude0+(O-(1+2*_+w)*Math.pow(O,3)/6+S)/d;return this.geodeticConverter.convertRadians(F,C,e.z,t)},apply:function(e,t){const i=this.geodeticConverter.applyRadians(e,t),r=i.x,a=i.y,l=Math.tan(r),h=Math.cos(r),c=this.EE,d=this.a/Math.sqrt(1-this.ecc2*Math.pow(Math.sin(r),2)),u=l*l,p=u*u*u,_=c*h*h,g=h*(a-this.longitude0),w=this.a*(this.W*r-this.X*Math.sin(2*r)+this.Y*Math.sin(4*r)-this.Z*Math.sin(6*r)),f=s*d*(g+(1-u+_)*Math.pow(g,3)/6+(5-18*p+72*_-58*c)*Math.pow(g,5)/120)+o;let m=s*(w+d*l*(g*g/2+(5-u+9*_+4*_*_)*Math.pow(g,4)/24+(61-58*p+600*_-330*c)*Math.pow(g,6)/720));return r<0?(m+=n,this.southernHemisphere||(m=-m)):this.southernHemisphere&&(m=-m),this.eastingFirst?t.set(f,m,i.z):t.set(m,f,i.z)}},r})),e("x_ite/Browser/Geospatial/Geocentric",["standard/Math/Numbers/Vector3","standard/Math/Algorithm"],(function(e,t){"use strict";function i(){}return i.prototype={constructor:i,convert:function(e,t){return t.assign(e)},apply:function(e,t){return t.assign(e)},slerp:function(e,i,n){const o=e.abs(),s=i.abs();return e.normalize(),i.normalize(),t.simpleSlerp(e,i,n).multiply(t.lerp(o,s,n))}},i})),e("x_ite/Browser/Geospatial/Geospatial",["standard/Geospatial/ReferenceEllipsoids","standard/Geospatial/Geodetic","standard/Geospatial/UniversalTransverseMercator","x_ite/Browser/Geospatial/Geocentric"],(function(e,t,i,n){"use strict";let o=0;const s=o++,r=o++,a=o++,l={GD:s,GDC:s,UTM:r,GC:a,GCC:a,GS:a},h=/^Z(\d+)$/;return{GD:s,UTM:r,GC:a,getReferenceFrame:function(o,l){switch(this.getCoordinateSystem(o)){case s:return new t(this.getEllipsoid(o),this.getLatitudeFirst(o),l);case r:return new i(this.getEllipsoid(o),this.getZone(o),this.getNorthernHemisphere(o),this.getNorthingFirst(o));case a:return new n}return new t(e.WE,!0,l)},getElevationFrame:function(e,i){return new t(this.getEllipsoid(e),!0,i)},getCoordinateSystem:function(e){for(const t of e){const e=l[t];if(void 0!==e)return e}return s},getEllipsoid:function(t){for(const i of t){const t=e[i];if(void 0!==t)return t}return e.WE},getEllipsoidString:function(t){for(const i of t){if(void 0!==e[i])return i}return"WE"},isStandardOrder:function(e){switch(this.getCoordinateSystem(e)){case s:return this.getLatitudeFirst(e);case r:return this.getNorthingFirst(e);case a:return!0}return this.getLatitudeFirst(e)},getLatitudeFirst:function(e){for(const t of e)if("longitude_first"===t)return!1;return!0},getNorthingFirst:function(e){for(const t of e)if("easting_first"===t)return!1;return!0},getZone:function(e){for(const t of e){const e=t.match(h);if(e)return parseInt(e[1])}return 1},getNorthernHemisphere:function(e){for(const t of e)if("S"===t)return!1;return!0}}})),e("x_ite/Components/Geospatial/X3DGeospatialObject",["x_ite/Base/X3DConstants","x_ite/Browser/Geospatial/Geospatial","x_ite/Base/X3DCast","standard/Math/Numbers/Vector3","standard/Math/Numbers/Matrix4"],(function(e,t,i,n,o){"use strict";var s=new n(0,0,0),r=new n(0,0,0),a=new n(0,0,0),l=new n(0,0,0),h=new n(0,0,0),c=new n(0,0,0);function d(t){this.addType(e.X3DGeospatialObject),this.radians=!1,this.origin=new n(0,0,0),this.originMatrix=new o,this.invOriginMatrix=new o}function u(e,t){return this.invOriginMatrix.multVecMatrix(this.referenceFrame.convert(e,t))}function p(e,t){return this.referenceFrame.apply(this.originMatrix.multVecMatrix(s.assign(e)),t)}function _(e,t){return this.invOriginMatrix.multDirMatrix(this.elevationFrame.normal(this.originMatrix.multVecMatrix(s.assign(e)),t))}function g(e,t){return w.call(this,e,t).multRight(this.invOriginMatrix)}function w(e,t){return this.referenceFrame.convert(e,a),this.elevationFrame.normal(a,h),l.set(0,0,1).cross(h),l.equals(n.Zero)&&l.set(1,0,0),c.assign(l).cross(h),l.normalize(),c.normalize(),t.set(l.x,l.y,l.z,0,h.x,h.y,h.z,0,c.x,c.y,c.z,0,a.x,a.y,a.z,1)}return d.prototype={constructor:d,initialize:function(){this._geoSystem.addInterest("set_geoSystem__",this),this._geoOrigin.addInterest("set_geoOrigin__",this),this.set_geoSystem__(),this.set_geoOrigin__()},set_geoSystem__:function(){this.coordinateSystem=t.getCoordinateSystem(this._geoSystem),this.referenceFrame=t.getReferenceFrame(this._geoSystem,this.radians),this.elevationFrame=t.getElevationFrame(this._geoSystem,this.radians),this.standardOrder=t.isStandardOrder(this._geoSystem)},set_geoOrigin__:function(){this.geoOriginNode&&(this.geoOriginNode.removeInterest("set_origin__",this),this.geoOriginNode.removeInterest("set_rotateYUp__",this),this.geoOriginNode.removeInterest("addNodeEvent",this)),this.geoOriginNode=i(e.GeoOrigin,this._geoOrigin),this.geoOriginNode&&(this.geoOriginNode.addInterest("set_origin__",this),this.geoOriginNode.addInterest("set_rotateYUp__",this),this.geoOriginNode.addInterest("addNodeEvent",this)),this.set_origin__(),this.set_rotateYUp__()},set_origin__:function(){this.geoOriginNode?this.geoOriginNode.getOrigin(this.origin):this.origin.set(0,0,0),this.set_originMatrix__()},set_originMatrix__:function(){try{if(this.geoOriginNode){var e=this.origin;this.elevationFrame.normal(e,h),l.set(0,0,1).cross(h),l.equals(n.Zero)&&l.set(1,0,0),c.assign(l).cross(h),l.normalize(),c.normalize(),this.originMatrix.set(l.x,l.y,l.z,0,h.x,h.y,h.z,0,c.x,c.y,c.z,0,e.x,e.y,e.z,1),this.invOriginMatrix.assign(this.originMatrix).inverse()}}catch(e){}},set_rotateYUp__:function(){this.geoOriginNode&&this.geoOriginNode._rotateYUp.getValue()?(this.getCoord=u,this.getGeoCoord=p,this.getGeoUpVector=_,this.getLocationMatrix=g):(delete this.getCoord,delete this.getGeoCoord,delete this.getGeoUpVector,delete this.getLocationMatrix)},getReferenceFrame:function(){return this.referenceFrame},getStandardOrder:function(){return this.standardOrder},getCoord:function(e,t){return this.referenceFrame.convert(e,t).subtract(this.origin)},getGeoCoord:function(e,t){return this.referenceFrame.apply(s.assign(e).add(this.origin),t)},getGeoElevation:function(e){return this.getGeoCoord(e,r).z},getGeoUpVector:function(e,t){return this.elevationFrame.normal(s.assign(e).add(this.origin),t)},getLocationMatrix:function(e,t){var i=this.origin,n=w.call(this,e,t);return n[12]-=i.x,n[13]-=i.y,n[14]-=i.z,n}},d})),e("x_ite/Components/Geospatial/GeoCoordinate",["x_ite/Fields","x_ite/Base/X3DFieldDefinition","x_ite/Base/FieldDefinitionArray","x_ite/Components/Rendering/X3DCoordinateNode","x_ite/Components/Geospatial/X3DGeospatialObject","x_ite/Base/X3DConstants","standard/Math/Geometry/Triangle3","standard/Math/Numbers/Vector3"],(function(e,t,i,n,o,s,r,a){"use strict";function l(e){n.call(this,e),o.call(this,e),this.addType(s.GeoCoordinate)}var h,c,d,u,p;return l.prototype=Object.assign(Object.create(n.prototype),o.prototype,{constructor:l,[Symbol.for("X_ITE.X3DBaseNode.fieldDefinitions")]:new i([new t(s.inputOutput,"metadata",new e.SFNode),new t(s.initializeOnly,"geoOrigin",new e.SFNode),new t(s.initializeOnly,"geoSystem",new e.MFString("GD","WE")),new t(s.inputOutput,"point",new e.MFVec3d)]),getTypeName:function(){return"GeoCoordinate"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"coord"},initialize:function(){n.prototype.initialize.call(this),o.prototype.initialize.call(this),this._point.addInterest("set_point__",this),this.set_point__()},set_point__:function(){this.point=this._point.getValue(),this.length=this._point.length},isEmpty:function(){return 0===this.length},getSize:function(){return this.length},set1Point:(p=new a(0,0,0),function(e,t){this._point[e]=this.getGeoCoord(t,p)}),get1Point:(u=new a(0,0,0),function(e,t){if(e<this.length){const i=this.point;return e*=3,this.getCoord(u.set(i[e],i[e+1],i[e+2]),t)}return t.set(0,0,0)}),addPoint:function(){var e=new a(0,0,0),t=new a(0,0,0);return function(i,n){if(i<this.length){const o=this.point;i*=3,this.getCoord(e.set(o[i],o[i+1],o[i+2]),t),n.push(t[0],t[1],t[2],1)}else n.push(0,0,0,1)}}(),addPoints:function(){var e=new a(0,0,0),t=new a(0,0,0);return function(i,n){const o=this.point;for(var s=0,r=3*this.length;s<r;s+=3)this.getCoord(e.set(o[s],o[s+1],o[s+2]),t),i.push(t[0],t[1],t[2],1);for(s=r,r=3*n;s<r;s+=3)i.push(0,0,0,1)}}(),getNormal:(h=new a(0,0,0),c=new a(0,0,0),d=new a(0,0,0),function(e,t,i){var n=this.length;return e<n&&t<n&&i<n?r.normal(this.get1Point(e,h),this.get1Point(t,c),this.get1Point(i,d),new a(0,0,0)):new a(0,0,0)}),getQuadNormal:function(){var e=new a(0,0,0),t=new a(0,0,0),i=new a(0,0,0),n=new a(0,0,0);return function(o,s,l,h){var c=this.length;return o<c&&s<c&&l<c&&h<c?r.quadNormal(this.get1Point(o,e),this.get1Point(s,t),this.get1Point(l,i),this.get1Point(h,n),new a(0,0,0)):new a(0,0,0)}}()}),l})),e("x_ite/Components/Geospatial/GeoElevationGrid",["x_ite/Fields","x_ite/Base/X3DFieldDefinition","x_ite/Base/FieldDefinitionArray","x_ite/Components/Rendering/X3DGeometryNode","x_ite/Components/Geospatial/X3DGeospatialObject","x_ite/Base/X3DConstants","x_ite/Base/X3DCast","standard/Math/Geometry/Triangle3","standard/Math/Numbers/Vector2","standard/Math/Numbers/Vector3"],(function(e,t,i,n,o,s,r,a,l,h){"use strict";function c(e){n.call(this,e),o.call(this,e),this.addType(s.GeoElevationGrid),this._creaseAngle.setUnit("angle"),this._height.setUnit("length"),this.colorNode=null,this.texCoordNode=null,this.normalNode=null}return c.prototype=Object.assign(Object.create(n.prototype),o.prototype,{constructor:c,[Symbol.for("X_ITE.X3DBaseNode.fieldDefinitions")]:new i([new t(s.inputOutput,"metadata",new e.SFNode),new t(s.initializeOnly,"geoOrigin",new e.SFNode),new t(s.initializeOnly,"geoSystem",new e.MFString("GD","WE")),new t(s.initializeOnly,"geoGridOrigin",new e.SFVec3d),new t(s.initializeOnly,"xDimension",new e.SFInt32),new t(s.initializeOnly,"zDimension",new e.SFInt32),new t(s.initializeOnly,"xSpacing",new e.SFDouble(1)),new t(s.initializeOnly,"zSpacing",new e.SFDouble(1)),new t(s.inputOutput,"yScale",new e.SFFloat(1)),new t(s.initializeOnly,"solid",new e.SFBool(!0)),new t(s.initializeOnly,"ccw",new e.SFBool(!0)),new t(s.initializeOnly,"creaseAngle",new e.SFDouble),new t(s.initializeOnly,"colorPerVertex",new e.SFBool(!0)),new t(s.initializeOnly,"normalPerVertex",new e.SFBool(!0)),new t(s.inputOutput,"color",new e.SFNode),new t(s.inputOutput,"texCoord",new e.SFNode),new t(s.inputOutput,"normal",new e.SFNode),new t(s.inputOutput,"height",new e.MFDouble(0,0))]),getTypeName:function(){return"GeoElevationGrid"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"geometry"},initialize:function(){n.prototype.initialize.call(this),o.prototype.initialize.call(this),this._color.addInterest("set_color__",this),this._texCoord.addInterest("set_texCoord__",this),this._normal.addInterest("set_normal__",this),this.set_color__(),this.set_texCoord__(),this.set_normal__()},set_color__:function(){this.colorNode&&(this.colorNode.removeInterest("requestRebuild",this),this.colorNode._transparent.removeInterest("set_transparent__",this)),this.colorNode=r(s.X3DColorNode,this._color),this.colorNode?(this.colorNode.addInterest("requestRebuild",this),this.colorNode._transparent.addInterest("set_transparent__",this),this.set_transparent__()):this.setTransparent(!1)},set_transparent__:function(){this.setTransparent(this.colorNode.getTransparent())},set_texCoord__:function(){this.texCoordNode&&this.texCoordNode.removeInterest("requestRebuild",this),this.texCoordNode=r(s.X3DTextureCoordinateNode,this._texCoord),this.texCoordNode&&this.texCoordNode.addInterest("requestRebuild",this),this.setTextureCoordinate(this.texCoordNode)},set_normal__:function(){this.normalNode&&this.normalNode.removeInterest("requestRebuild",this),this.normalNode=r(s.X3DNormalNode,this._normal),this.normalNode&&this.normalNode.addInterest("requestRebuild",this)},getColor:function(){return this.colorNode},getTexCoord:function(){return this.texCoordNode},getNormal:function(){return this.normalNode},getHeight:function(e){return e<this._height.length?this._height[e]*this._yScale.getValue():0},createTexCoords:function(){for(var e=[],t=this._xDimension.getValue(),i=this._zDimension.getValue(),n=t-1,o=i-1,s=0;s<i;++s)for(var r=0;r<t;++r)e.push(new l(r/n,s/o));return e},createNormals:function(e,t,i){for(var n=!this._ccw.getValue(),o=[],s=[],r=0;r<e.length;++r)o[r]=[];for(var l=0;l<t.length;l+=3){var c=t[l],d=t[l+1],u=t[l+2];o[c].push(s.length),o[d].push(s.length+1),o[u].push(s.length+2);var p=a.normal(e[c],e[d],e[u],new h(0,0,0));n&&p.negate(),s.push(p),s.push(p),s.push(p)}return this.refineNormals(o,s,this._creaseAngle.getValue())},createCoordIndex:function(){for(var e=[],t=this._xDimension.getValue(),i=t-1,n=this._zDimension.getValue()-1,o=0;o<n;++o)for(var s=0;s<i;++s){var r=o*t+s,a=(o+1)*t+s,l=(o+1)*t+(s+1),h=o*t+(s+1);e.push(r),e.push(l),e.push(a),e.push(r),e.push(h),e.push(l)}return e},createPoints:function(){var e=[],t=this._xDimension.getValue(),i=this._zDimension.getValue(),n=this._xSpacing.getValue(),o=this._zSpacing.getValue();if(this.getStandardOrder())for(var s=0;s<i;++s)for(var r=0;r<t;++r){(a=new h(o*s,n*r,this.getHeight(r+s*t))).add(this._geoGridOrigin.getValue()),e.push(this.getCoord(a,a))}else for(s=0;s<i;++s)for(r=0;r<t;++r){var a;(a=new h(n*r,o*s,this.getHeight(r+s*t))).add(this._geoGridOrigin.getValue()),e.push(this.getCoord(a,a))}return e},build:function(){if(!(this._xDimension.getValue()<2||this._zDimension.getValue()<2)){var e=this._colorPerVertex.getValue(),t=this._normalPerVertex.getValue(),i=this.createCoordIndex(),n=this.getColor(),o=this.getTexCoord(),s=this.getNormal(),r=this.createPoints(),a=this.getColors(),l=this.getMultiTexCoords(),h=this.getNormals(),c=this.getVertices(),d=0;if(o)o.init(l);else{var u=this.createTexCoords(),p=this.getTexCoords();l.push(p)}for(var _=0;_<i.length;++d)for(var g=0;g<6;++g,++_){var w=i[_],f=r[w];if(n&&(e?n.addColor(w,a):n.addColor(d,a)),o)o.addTexCoord(w,l);else{var m=u[w];p.push(m.x,m.y,0,1)}s&&(t?s.addVector(w,h):s.addVector(d,h)),c.push(f.x,f.y,f.z,1)}if(!s)for(var O=this.createNormals(r,i),y=0;y<O.length;++y){var x=O[y];h.push(x.x,x.y,x.z)}this.setSolid(this._solid.getValue()),this.setCCW(this._ccw.getValue())}}}),c})),e("x_ite/Components/Geospatial/GeoLOD",["x_ite/Fields","x_ite/Base/X3DFieldDefinition","x_ite/Base/FieldDefinitionArray","x_ite/Components/Core/X3DChildNode","x_ite/Components/Grouping/X3DBoundedObject","x_ite/Components/Geospatial/X3DGeospatialObject","x_ite/Base/X3DConstants","x_ite/Rendering/TraverseType","x_ite/Components/Grouping/Group","x_ite/Components/Networking/Inline","standard/Math/Numbers/Vector3","standard/Math/Numbers/Matrix4","standard/Math/Geometry/Box3"],(function(e,t,i,n,o,s,r,a,l,h,c,d,u){"use strict";var p=new c(0,0,0);function _(e){n.call(this,e),o.call(this,e),s.call(this,e),this.addType(r.GeoLOD),this._range.setUnit("length"),this.unload=!1,this.rootGroup=new l(this.getBrowser().getPrivateScene()),this.rootInline=new h(e),this.child1Inline=new h(e),this.child2Inline=new h(e),this.child3Inline=new h(e),this.child4Inline=new h(e),this.childrenLoaded=!1,this.childBBox=new u,this.keepCurrentLevel=!1,this.modelViewMatrix=new d}return _.prototype=Object.assign(Object.create(n.prototype),o.prototype,s.prototype,{constructor:_,[Symbol.for("X_ITE.X3DBaseNode.fieldDefinitions")]:new i([new t(r.inputOutput,"metadata",new e.SFNode),new t(r.initializeOnly,"geoOrigin",new e.SFNode),new t(r.initializeOnly,"geoSystem",new e.MFString("GD","WE")),new t(r.initializeOnly,"rootUrl",new e.MFString),new t(r.initializeOnly,"child1Url",new e.MFString),new t(r.initializeOnly,"child2Url",new e.MFString),new t(r.initializeOnly,"child3Url",new e.MFString),new t(r.initializeOnly,"child4Url",new e.MFString),new t(r.initializeOnly,"center",new e.SFVec3d),new t(r.initializeOnly,"range",new e.SFFloat(10)),new t(r.outputOnly,"level_changed",new e.SFInt32(-1)),new t(r.inputOutput,"visible",new e.SFBool(!0)),new t(r.inputOutput,"bboxDisplay",new e.SFBool),new t(r.initializeOnly,"bboxSize",new e.SFVec3f(-1,-1,-1)),new t(r.initializeOnly,"bboxCenter",new e.SFVec3f),new t(r.initializeOnly,"rootNode",new e.MFNode),new t(r.outputOnly,"children",new e.MFNode)]),getTypeName:function(){return"GeoLOD"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"children"},initialize:function(){n.prototype.initialize.call(this),o.prototype.initialize.call(this),s.prototype.initialize.call(this),this._rootNode.addFieldInterest(this.rootGroup._children),this.rootGroup._children=this._rootNode,this.rootGroup.setPrivate(!0),this.rootGroup.setup(),this.rootInline._loadState.addInterest("set_rootLoadState__",this),this.child1Inline._loadState.addInterest("set_childLoadState__",this),this.child2Inline._loadState.addInterest("set_childLoadState__",this),this.child3Inline._loadState.addInterest("set_childLoadState__",this),this.child4Inline._loadState.addInterest("set_childLoadState__",this),this._rootUrl.addFieldInterest(this.rootInline._url),this._child1Url.addFieldInterest(this.child1Inline._url),this._child2Url.addFieldInterest(this.child2Inline._url),this._child3Url.addFieldInterest(this.child3Inline._url),this._child4Url.addFieldInterest(this.child4Inline._url),this.rootInline._load=!0,this.child1Inline._load=!1,this.child2Inline._load=!1,this.child3Inline._load=!1,this.child4Inline._load=!1,this.rootInline._url=this._rootUrl,this.child1Inline._url=this._child1Url,this.child2Inline._url=this._child2Url,this.child3Inline._url=this._child3Url,this.child4Inline._url=this._child4Url,this.rootInline.setup(),this.child1Inline.setup(),this.child2Inline.setup(),this.child3Inline.setup(),this.child4Inline.setup()},getBBox:function(e,t){if(this._bboxSize.getValue().equals(this.getDefaultBBoxSize())){switch(this.childrenLoaded?this._level_changed.getValue():0){case 0:return this._rootNode.length?this.rootGroup.getBBox(e,t):this.rootInline.getBBox(e,t);case 1:{const i=this.childBBox;return e.set(),e.add(this.child1Inline.getBBox(i,t)),e.add(this.child2Inline.getBBox(i,t)),e.add(this.child3Inline.getBBox(i,t)),e.add(this.child4Inline.getBBox(i,t)),e}}return e.set()}return e.set(this._bboxSize.getValue(),this._bboxCenter.getValue())},set_rootLoadState__:function(){0===this._level_changed.getValue()&&(this._rootNode.length||this.rootInline.checkLoadState()===r.COMPLETE_STATE&&(this._children=this.rootInline.getInternalScene().getRootNodes(),this.childrenLoaded=!1))},set_childLoadState__:function(){if(1===this._level_changed.getValue()){var e=0;if(this.child1Inline.checkLoadState()!==r.COMPLETE_STATE&&this.child1Inline.checkLoadState()!==r.FAILED_STATE||++e,this.child2Inline.checkLoadState()!==r.COMPLETE_STATE&&this.child2Inline.checkLoadState()!==r.FAILED_STATE||++e,this.child3Inline.checkLoadState()!==r.COMPLETE_STATE&&this.child3Inline.checkLoadState()!==r.FAILED_STATE||++e,this.child4Inline.checkLoadState()!==r.COMPLETE_STATE&&this.child4Inline.checkLoadState()!==r.FAILED_STATE||++e,4===e){this.childrenLoaded=!0;var t=this._children;t.length=0;for(var i=0,n=(o=this.child1Inline.getInternalScene().getRootNodes()).length;i<n;++i)t.push(o[i]);for(i=0,n=(o=this.child2Inline.getInternalScene().getRootNodes()).length;i<n;++i)t.push(o[i]);for(i=0,n=(o=this.child3Inline.getInternalScene().getRootNodes()).length;i<n;++i)t.push(o[i]);var o;for(i=0,n=(o=this.child4Inline.getInternalScene().getRootNodes()).length;i<n;++i)t.push(o[i])}}},set_childCameraObject__:function(){this.setCameraObject(this.child1Inline.getCameraObject()||this.child2Inline.getCameraObject()||this.child3Inline.getCameraObject()||this.child4Inline.getCameraObject())},set_childPickableObject__:function(){this.setPickableObject(this.child1Inline.getPickableObject()||this.child2Inline.getPickableObject()||this.child3Inline.getPickableObject()||this.child4Inline.getPickableObject())},getLevel:function(e){return this.getDistance(e)<this._range.getValue()?1:0},getDistance:function(e){return e.translate(this.getCoord(this._center.getValue(),p)),e.origin.abs()},traverse:function(e,t){switch(e){case a.PICKING:var i=t.getBrowser().getPickingHierarchy();return i.push(this),this.traverseChildren(e,t),void i.pop();case a.DISPLAY:var n=this.getLevel(this.modelViewMatrix.assign(t.getModelViewMatrix().get()));if(n!==this._level_changed.getValue())switch(this._level_changed=n,n){case 0:this.child1Inline._isCameraObject.removeInterest("set_childCameraObject__",this),this.child2Inline._isCameraObject.removeInterest("set_childCameraObject__",this),this.child3Inline._isCameraObject.removeInterest("set_childCameraObject__",this),this.child4Inline._isCameraObject.removeInterest("set_childCameraObject__",this),this.child1Inline._isPickableObject.removeInterest("set_childPickableObject__",this),this.child2Inline._isPickableObject.removeInterest("set_childPickableObject__",this),this.child3Inline._isPickableObject.removeInterest("set_childPickableObject__",this),this.child4Inline._isPickableObject.removeInterest("set_childPickableObject__",this),this._rootNode.length?(this.rootGroup._isCameraObject.addFieldInterest(this._isCameraObject),this.rootGroup._isPickableObject.addFieldInterest(this._isPickableObject),this.setCameraObject(this.rootGroup.getCameraObject()),this.setPickableObject(this.rootGroup.getPickableObject()),this._children=this._rootNode,this.childrenLoaded=!1):this.rootInline.checkLoadState()==r.COMPLETE_STATE&&(this.rootInline._isCameraObject.addFieldInterest(this._isCameraObject),this.rootInline._isPickableObject.addFieldInterest(this._isPickableObject),this.setCameraObject(this.rootInline.getCameraObject()),this.setPickableObject(this.rootInline.getPickableObject()),this._children=this.rootInline.getInternalScene().getRootNodes(),this.childrenLoaded=!1),this.unload&&(this.child1Inline._load=!1,this.child2Inline._load=!1,this.child3Inline._load=!1,this.child4Inline._load=!1);break;case 1:this._rootNode.length?(this.rootGroup._isCameraObject.removeFieldInterest(this._isCameraObject),this.rootGroup._isPickableObject.removeFieldInterest(this._isPickableObject)):(this.rootInline._isCameraObject.removeFieldInterest(this._isCameraObject),this.rootInline._isPickableObject.removeFieldInterest(this._isPickableObject)),this.child1Inline._isCameraObject.addInterest("set_childCameraObject__",this),this.child2Inline._isCameraObject.addInterest("set_childCameraObject__",this),this.child3Inline._isCameraObject.addInterest("set_childCameraObject__",this),this.child4Inline._isCameraObject.addInterest("set_childCameraObject__",this),this.child1Inline._isPickableObject.addInterest("set_childPickableObject__",this),this.child2Inline._isPickableObject.addInterest("set_childPickableObject__",this),this.child3Inline._isPickableObject.addInterest("set_childPickableObject__",this),this.child4Inline._isPickableObject.addInterest("set_childPickableObject__",this),this.set_childCameraObject__(),this.set_childPickableObject__(),this.child1Inline._load.getValue()?this.set_childLoadState__():(this.child1Inline._load=!0,this.child2Inline._load=!0,this.child3Inline._load=!0,this.child4Inline._load=!0)}return void this.traverseChildren(e,t);default:return void this.traverseChildren(e,t)}},traverseChildren:function(e,t){switch(this.childrenLoaded?this._level_changed.getValue():0){case 0:this._rootNode.length?this.rootGroup.traverse(e,t):this.rootInline.traverse(e,t);break;case 1:this.child1Inline.traverse(e,t),this.child2Inline.traverse(e,t),this.child3Inline.traverse(e,t),this.child4Inline.traverse(e,t)}}}),_})),e("x_ite/Components/Geospatial/GeoLocation",["x_ite/Fields","x_ite/Base/X3DFieldDefinition","x_ite/Base/FieldDefinitionArray","x_ite/Components/Grouping/X3DTransformMatrix3DNode","x_ite/Components/Geospatial/X3DGeospatialObject","x_ite/Base/X3DConstants","standard/Math/Numbers/Matrix4"],(function(e,t,i,n,o,s,r){"use strict";var a=new r;function l(e){n.call(this,e),o.call(this,e),this.addType(s.GeoLocation)}return l.prototype=Object.assign(Object.create(n.prototype),o.prototype,{constructor:l,[Symbol.for("X_ITE.X3DBaseNode.fieldDefinitions")]:new i([new t(s.inputOutput,"metadata",new e.SFNode),new t(s.initializeOnly,"geoSystem",new e.MFString("GD","WE")),new t(s.inputOutput,"geoCoords",new e.SFVec3d),new t(s.initializeOnly,"geoOrigin",new e.SFNode),new t(s.inputOutput,"visible",new e.SFBool(!0)),new t(s.inputOutput,"bboxDisplay",new e.SFBool),new t(s.initializeOnly,"bboxSize",new e.SFVec3f(-1,-1,-1)),new t(s.initializeOnly,"bboxCenter",new e.SFVec3f),new t(s.inputOnly,"addChildren",new e.MFNode),new t(s.inputOnly,"removeChildren",new e.MFNode),new t(s.inputOutput,"children",new e.MFNode)]),getTypeName:function(){return"GeoLocation"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"children"},initialize:function(){n.prototype.initialize.call(this),o.prototype.initialize.call(this),this.addInterest("eventsProcessed",this),this.eventsProcessed()},eventsProcessed:function(){this.setMatrix(this.getLocationMatrix(this._geoCoords.getValue(),a))}}),l})),e("x_ite/Components/Geospatial/GeoMetadata",["x_ite/Fields","x_ite/Base/X3DFieldDefinition","x_ite/Base/FieldDefinitionArray","x_ite/Components/Core/X3DInfoNode","x_ite/Components/Networking/X3DUrlObject","x_ite/Base/X3DConstants"],(function(e,t,i,n,o,s){"use strict";function r(e){n.call(this,e),o.call(this,e),this.addType(s.GeoMetadata)}return r.prototype=Object.assign(Object.create(n.prototype),o.prototype,{constructor:r,[Symbol.for("X_ITE.X3DBaseNode.fieldDefinitions")]:new i([new t(s.inputOutput,"metadata",new e.SFNode),new t(s.inputOutput,"url",new e.MFString),new t(s.inputOutput,"load",new e.SFBool(!0)),new t(s.inputOutput,"autoRefresh",new e.SFTime),new t(s.inputOutput,"autoRefreshTimeLimit",new e.SFTime(3600)),new t(s.inputOutput,"summary",new e.MFString),new t(s.inputOutput,"data",new e.MFNode)]),getTypeName:function(){return"GeoMetadata"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"children"},initialize:function(){n.prototype.initialize.call(this),o.prototype.initialize.call(this)},requestImmediateLoad:function(e=!0){},requestUnload:function(){},set_load__:function(){},set_url__:function(){}}),r})),e("x_ite/Components/Geospatial/GeoOrigin",["x_ite/Fields","x_ite/Base/X3DFieldDefinition","x_ite/Base/FieldDefinitionArray","x_ite/Components/Core/X3DNode","x_ite/Base/X3DConstants","x_ite/Browser/Geospatial/Geospatial"],(function(e,t,i,n,o,s){"use strict";function r(e){n.call(this,e),this.addType(o.GeoOrigin),this.radians=!1}return r.prototype=Object.assign(Object.create(n.prototype),{constructor:r,[Symbol.for("X_ITE.X3DBaseNode.fieldDefinitions")]:new i([new t(o.inputOutput,"metadata",new e.SFNode),new t(o.initializeOnly,"geoSystem",new e.MFString("GD","WE")),new t(o.inputOutput,"geoCoords",new e.SFVec3d),new t(o.initializeOnly,"rotateYUp",new e.SFBool)]),getTypeName:function(){return"GeoOrigin"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"geoOrigin"},initialize:function(){n.prototype.initialize.call(this),this._geoSystem.addInterest("set_geoSystem__",this),this.set_geoSystem__()},set_geoSystem__:function(){this.referenceFrame=s.getReferenceFrame(this._geoSystem,this.radians)},getOrigin:function(e){return this.referenceFrame.convert(this._geoCoords.getValue(),e)}}),r})),e("x_ite/Components/Geospatial/GeoPositionInterpolator",["x_ite/Fields","x_ite/Base/X3DFieldDefinition","x_ite/Base/FieldDefinitionArray","x_ite/Components/Interpolation/X3DInterpolatorNode","x_ite/Components/Geospatial/X3DGeospatialObject","x_ite/Browser/Geospatial/Geocentric","x_ite/Base/X3DConstants","standard/Math/Numbers/Vector3"],(function(e,t,i,n,o,s,r,a){"use strict";function l(e){n.call(this,e),o.call(this,e),this.addType(r.GeoPositionInterpolator),this._value_changed.setUnit("length"),this.geocentric=new s}return l.prototype=Object.assign(Object.create(n.prototype),o.prototype,{constructor:l,[Symbol.for("X_ITE.X3DBaseNode.fieldDefinitions")]:new i([new t(r.inputOutput,"metadata",new e.SFNode),new t(r.initializeOnly,"geoOrigin",new e.SFNode),new t(r.initializeOnly,"geoSystem",new e.MFString("GD","WE")),new t(r.inputOnly,"set_fraction",new e.SFFloat),new t(r.inputOutput,"key",new e.MFFloat),new t(r.inputOutput,"keyValue",new e.MFVec3d),new t(r.outputOnly,"value_changed",new e.SFVec3d),new t(r.outputOnly,"geovalue_changed",new e.SFVec3d)]),keyValue0:new a(0,0,0),keyValue1:new a(0,0,0),geovalue:new a(0,0,0),value:new a(0,0,0),getTypeName:function(){return"GeoPositionInterpolator"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"children"},setup:function(){o.prototype.initialize.call(this),n.prototype.setup.call(this)},initialize:function(){n.prototype.initialize.call(this),this._keyValue.addInterest("set_keyValue__",this)},set_keyValue__:function(){var t=this._key,i=this._keyValue;i.length<t.length&&i.resize(t.length,i.length?i[i.length-1]:new e.SFVec3f)},interpolate:function(e,t,i){try{this.getCoord(this._keyValue[e].getValue(),this.keyValue0),this.getCoord(this._keyValue[t].getValue(),this.keyValue1);var n=this.geocentric.slerp(this.keyValue0,this.keyValue1,i);this._geovalue_changed=this.getGeoCoord(n,this.geovalue),this._value_changed=n}catch(e){}}}),l})),e("x_ite/Components/Geospatial/GeoProximitySensor",["x_ite/Fields","x_ite/Base/X3DFieldDefinition","x_ite/Base/FieldDefinitionArray","x_ite/Components/EnvironmentalSensor/X3DEnvironmentalSensorNode","x_ite/Components/Geospatial/X3DGeospatialObject","x_ite/Components/EnvironmentalSensor/ProximitySensor","x_ite/Base/X3DConstants","standard/Math/Numbers/Vector3"],(function(e,t,i,n,o,s,r,a){"use strict";var l=new a(0,0,0);function h(e){n.call(this,e),o.call(this,e),this.addType(r.GeoProximitySensor),this._position_changed.setUnit("length"),this._centerOfRotation_changed.setUnit("length"),this.proximitySensor=new s(e),this.setCameraObject(this.proximitySensor.getCameraObject()),this.setPickableObject(this.proximitySensor.getPickableObject())}return h.prototype=Object.assign(Object.create(n.prototype),o.prototype,{constructor:h,[Symbol.for("X_ITE.X3DBaseNode.fieldDefinitions")]:new i([new t(r.inputOutput,"metadata",new e.SFNode),new t(r.initializeOnly,"geoOrigin",new e.SFNode),new t(r.initializeOnly,"geoSystem",new e.MFString("GD","WE")),new t(r.inputOutput,"enabled",new e.SFBool(!0)),new t(r.inputOutput,"size",new e.SFVec3f),new t(r.inputOutput,"center",new e.SFVec3f),new t(r.outputOnly,"isActive",new e.SFBool),new t(r.outputOnly,"enterTime",new e.SFTime),new t(r.outputOnly,"exitTime",new e.SFTime),new t(r.outputOnly,"geoCoord_changed",new e.SFVec3d),new t(r.outputOnly,"position_changed",new e.SFVec3f),new t(r.outputOnly,"orientation_changed",new e.SFRotation),new t(r.outputOnly,"centerOfRotation_changed",new e.SFVec3f)]),getTypeName:function(){return"GeoProximitySensor"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"children"},initialize:function(){n.prototype.initialize.call(this),o.prototype.initialize.call(this),this._enabled.addFieldInterest(this.proximitySensor._enabled),this._size.addFieldInterest(this.proximitySensor._size),this._center.addFieldInterest(this.proximitySensor._center),this.proximitySensor._isCameraObject.addFieldInterest(this._isCameraObject),this.proximitySensor._isPickableObject.addFieldInterest(this._isPickableObject),this.proximitySensor._isActive.addFieldInterest(this._isActive),this.proximitySensor._enterTime.addFieldInterest(this._enterTime),this.proximitySensor._exitTime.addFieldInterest(this._exitTime),this.proximitySensor._position_changed.addFieldInterest(this._position_changed),this.proximitySensor._orientation_changed.addFieldInterest(this._orientation_changed),this.proximitySensor._centerOfRotation_changed.addFieldInterest(this._centerOfRotation_changed),this.proximitySensor._position_changed.addInterest("set_position__",this),this.proximitySensor._enabled=this._enabled,this.proximitySensor._size=this._size,this.proximitySensor._center=this._center,this.proximitySensor.setup()},set_position__:function(e){this._geoCoord_changed=this.getGeoCoord(this.proximitySensor._position_changed.getValue(),l)},traverse:function(e,t){this.proximitySensor.traverse(e,t)}}),h})),e("x_ite/Components/Geospatial/GeoTouchSensor",["x_ite/Fields","x_ite/Base/X3DFieldDefinition","x_ite/Base/FieldDefinitionArray","x_ite/Components/PointingDeviceSensor/X3DTouchSensorNode","x_ite/Components/Geospatial/X3DGeospatialObject","x_ite/Base/X3DConstants","standard/Math/Numbers/Vector3","standard/Math/Numbers/Matrix4"],(function(e,t,i,n,o,s,r,a){"use strict";var l=new a,h=new r(0,0,0);function c(e){n.call(this,e),o.call(this,e),this.addType(s.GeoTouchSensor),this._hitPoint_changed.setUnit("length")}return c.prototype=Object.assign(Object.create(n.prototype),o.prototype,{constructor:c,[Symbol.for("X_ITE.X3DBaseNode.fieldDefinitions")]:new i([new t(s.inputOutput,"metadata",new e.SFNode),new t(s.inputOutput,"description",new e.SFString),new t(s.initializeOnly,"geoOrigin",new e.SFNode),new t(s.initializeOnly,"geoSystem",new e.MFString("GD","WE")),new t(s.inputOutput,"enabled",new e.SFBool(!0)),new t(s.outputOnly,"hitTexCoord_changed",new e.SFVec2f),new t(s.outputOnly,"hitNormal_changed",new e.SFVec3f),new t(s.outputOnly,"hitPoint_changed",new e.SFVec3f),new t(s.outputOnly,"hitGeoCoord_changed",new e.SFVec3d),new t(s.outputOnly,"isOver",new e.SFBool),new t(s.outputOnly,"isActive",new e.SFBool),new t(s.outputOnly,"touchTime",new e.SFTime)]),getTypeName:function(){return"GeoTouchSensor"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"children"},initialize:function(){n.prototype.initialize.call(this),o.prototype.initialize.call(this)},set_over__:function(e,t,i,o,s){try{if(n.prototype.set_over__.call(this,e,t,i,o,s),this._isOver.getValue()){var r=t.intersection;l.assign(i).inverse(),this._hitTexCoord_changed=r.texCoord,this._hitNormal_changed=i.multMatrixDir(r.normal.copy()).normalize(),this._hitPoint_changed=l.multVecMatrix(r.point.copy()),this._hitGeoCoord_changed=this.getGeoCoord(this._hitPoint_changed.getValue(),h)}}catch(e){console.error(e)}}}),c})),e("x_ite/Components/Geospatial/GeoTransform",["x_ite/Fields","x_ite/Base/X3DFieldDefinition","x_ite/Base/FieldDefinitionArray","x_ite/Components/Grouping/X3DTransformMatrix3DNode","x_ite/Components/Geospatial/X3DGeospatialObject","x_ite/Base/X3DConstants","standard/Math/Numbers/Matrix4"],(function(e,t,i,n,o,s,r){"use strict";var a=new r,l=new r;function h(e){n.call(this,e),o.call(this,e),this.addType(s.GeoTransform),this._translation.setUnit("length")}return h.prototype=Object.assign(Object.create(n.prototype),o.prototype,{constructor:h,[Symbol.for("X_ITE.X3DBaseNode.fieldDefinitions")]:new i([new t(s.inputOutput,"metadata",new e.SFNode),new t(s.inputOutput,"translation",new e.SFVec3f),new t(s.inputOutput,"rotation",new e.SFRotation),new t(s.inputOutput,"scale",new e.SFVec3f(1,1,1)),new t(s.inputOutput,"scaleOrientation",new e.SFRotation),new t(s.initializeOnly,"geoOrigin",new e.SFNode),new t(s.initializeOnly,"geoSystem",new e.MFString("GD","WE")),new t(s.inputOutput,"geoCenter",new e.SFVec3d),new t(s.inputOutput,"visible",new e.SFBool(!0)),new t(s.inputOutput,"bboxDisplay",new e.SFBool),new t(s.initializeOnly,"bboxSize",new e.SFVec3f(-1,-1,-1)),new t(s.initializeOnly,"bboxCenter",new e.SFVec3f),new t(s.inputOnly,"addChildren",new e.MFNode),new t(s.inputOnly,"removeChildren",new e.MFNode),new t(s.inputOutput,"children",new e.MFNode)]),getTypeName:function(){return"GeoTransform"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"children"},initialize:function(){n.prototype.initialize.call(this),o.prototype.initialize.call(this),this.addInterest("eventsProcessed",this),this.eventsProcessed()},eventsProcessed:function(){try{this.setHidden(0===this._scale.x||0===this._scale.y||0===this._scale.z),this.getLocationMatrix(this._geoCenter.getValue(),l),a.set(this._translation.getValue(),this._rotation.getValue(),this._scale.getValue(),this._scaleOrientation.getValue()),this.setMatrix(a.multRight(l).multLeft(l.inverse()))}catch(e){this.setHidden(!0)}}}),h})),e("x_ite/Components/Geospatial/GeoViewpoint",["x_ite/Fields","x_ite/Base/X3DFieldDefinition","x_ite/Base/FieldDefinitionArray","x_ite/Components/Navigation/X3DViewpointNode","x_ite/Components/Geospatial/X3DGeospatialObject","x_ite/Components/Interpolation/ScalarInterpolator","x_ite/Components/Navigation/NavigationInfo","x_ite/Base/X3DConstants","standard/Math/Geometry/Camera","standard/Math/Numbers/Vector2","standard/Math/Numbers/Vector3","standard/Math/Numbers/Rotation4","standard/Math/Numbers/Matrix4","standard/Math/Algorithm"],(function(e,t,i,n,o,s,r,a,l,h,c,d,u,p){"use strict";function _(e,t){n.prototype.traverse.call(this,e,t),this.navigationInfoNode.traverse(e,t)}function g(e){switch(n.call(this,e),o.call(this,e),this.addType(a.GeoViewpoint),this._centerOfRotation.setUnit("length"),this._fieldOfView.setUnit("angle"),this.navigationInfoNode=new r(e),this.fieldOfViewInterpolator=new s(this.getBrowser().getPrivateScene()),this.projectionMatrix=new u,this.elevation=0,e.specificationVersion){case"2.0":case"3.0":case"3.1":case"3.2":this.traverse=_}}var w,f,m,O,y,x,S;return g.prototype=Object.assign(Object.create(n.prototype),o.prototype,{constructor:g,[Symbol.for("X_ITE.X3DBaseNode.fieldDefinitions")]:new i([new t(a.inputOutput,"metadata",new e.SFNode),new t(a.initializeOnly,"geoOrigin",new e.SFNode),new t(a.initializeOnly,"geoSystem",new e.MFString("GD","WE")),new t(a.inputOnly,"set_bind",new e.SFBool),new t(a.inputOutput,"description",new e.SFString),new t(a.inputOutput,"position",new e.SFVec3d(0,0,1e5)),new t(a.inputOutput,"orientation",new e.SFRotation),new t(a.inputOutput,"centerOfRotation",new e.SFVec3d),new t(a.inputOutput,"fieldOfView",new e.SFFloat(.7854)),new t(a.inputOutput,"jump",new e.SFBool(!0)),new t(a.inputOutput,"retainUserOffsets",new e.SFBool),new t(a.inputOutput,"navType",new e.MFString("EXAMINE","ANY")),new t(a.inputOutput,"headlight",new e.SFBool(!0)),new t(a.initializeOnly,"speedFactor",new e.SFFloat(1)),new t(a.outputOnly,"isBound",new e.SFBool),new t(a.outputOnly,"bindTime",new e.SFTime)]),getTypeName:function(){return"GeoViewpoint"},getComponentName:function(){return"Geospatial"},getContainerField:function(){return"children"},initialize:function(){n.prototype.initialize.call(this),o.prototype.initialize.call(this),this._position.addInterest("set_position__",this),this._positionOffset.addInterest("set_position__",this),this._navType.addFieldInterest(this.navigationInfoNode._type),this._headlight.addFieldInterest(this.navigationInfoNode._headlight),this.navigationInfoNode.setup(),this.set_position__(),this.fieldOfViewInterpolator._key=[0,1],this.fieldOfViewInterpolator.setup(),this.getEaseInEaseOut()._modifiedFraction_changed.addFieldInterest(this.fieldOfViewInterpolator._set_fraction),this.fieldOfViewInterpolator._value_changed.addFieldInterest(this._fieldOfViewScale)},setInterpolators:function(t,i){if(t.getType().indexOf(a.Viewpoint)>=0){const n=t.getFieldOfView()/i.getFieldOfView();this.fieldOfViewInterpolator._keyValue=new e.MFFloat(n,i._fieldOfViewScale.getValue()),this._fieldOfViewScale=n}else this.fieldOfViewInterpolator._keyValue=new e.MFFloat(i._fieldOfViewScale.getValue(),i._fieldOfViewScale.getValue()),this._fieldOfViewScale=i._fieldOfViewScale.getValue()},setPosition:(S=new c(0,0,0),function(e){this._position.setValue(this.getGeoCoord(e,S))}),getPosition:(x=new c(0,0,0),function(){return this.getCoord(this._position.getValue(),x)}),set_position__:function(){var e=new c(0,0,0);return function(){this.getCoord(this._position.getValue(),e),this.elevation=this.getGeoElevation(e.add(this._positionOffset.getValue()))}}(),setOrientation:(O=new u,y=new d(0,0,1,0),function(e){var t=this.getLocationMatrix(this._position.getValue(),O).submatrix;y.setMatrix(t),this._orientation.setValue(y.inverse().multLeft(e))}),getOrientation:function(){var e=new u,t=new d(0,0,1,0);return function(){var i=this.getLocationMatrix(this._position.getValue(),e).submatrix;return t.setMatrix(i),t.multLeft(this._orientation.getValue())}}(),getCenterOfRotation:(m=new c(0,0,0),function(){return this.getCoord(this._centerOfRotation.getValue(),m)}),getFieldOfView:function(){var e=this._fieldOfView*this._fieldOfViewScale;return e>0&&e<Math.PI?e:Math.PI/4},getMaxFarValue:function(){return this.getBrowser().getRenderingProperty("LogarithmicDepthBuffer")?1e10:1e9},getUpVector:function(){var e=new c(0,0,0),t=new c(0,0,0);return function(){return this.getCoord(this._position.getValue(),e),this.getGeoUpVector.call(this,e.add(this._positionOffset.getValue()),t)}}(),getSpeedFactor:function(){return(Math.max(this.elevation,0)+10)/10*this._speedFactor.getValue()},getScreenScale:(f=new c(0,0,0),function(e,t){var i=t[2],n=t[3],o=Math.abs(e.z)*Math.tan(this.getFieldOfView()/2)*2;return o/=i>n?n:i,f.set(o,o,o)}),getViewportSize:(w=new h(0,0),function(e,t){var i=e[2],n=e[3],o=t*Math.tan(this.getFieldOfView()/2)*2,s=i/n;return s>1?w.set(o*s,o):w.set(o,o/s)}),getLookAtDistance:function(e){return e.size.abs()/2/Math.tan(this.getFieldOfView()/2)},getProjectionMatrixWithLimits:function(e,t,i,n){if(n||this.getBrowser().getRenderingProperty("LogarithmicDepthBuffer"))return l.perspective(this.getFieldOfView(),e,t,i[2],i[3],this.projectionMatrix);var o=Math.max(p.lerp(Math.min(e,1e4),1e4,this.elevation/1e7),1),s=Math.max(p.lerp(1e6,Math.max(t,1e6),this.elevation/1e7),1e6);return l.perspective(this.getFieldOfView(),o,s,i[2],i[3],this.projectionMatrix)}}),g})),e(t.getComponentUrl("geospatial"),["x_ite/Components","x_ite/Components/Geospatial/GeoCoordinate","x_ite/Components/Geospatial/GeoElevationGrid","x_ite/Components/Geospatial/GeoLOD","x_ite/Components/Geospatial/GeoLocation","x_ite/Components/Geospatial/GeoMetadata","x_ite/Components/Geospatial/GeoOrigin","x_ite/Components/Geospatial/GeoPositionInterpolator","x_ite/Components/Geospatial/GeoProximitySensor","x_ite/Components/Geospatial/GeoTouchSensor","x_ite/Components/Geospatial/GeoTransform","x_ite/Components/Geospatial/GeoViewpoint","x_ite/Components/Geospatial/X3DGeospatialObject"],(function(e,t,i,n,o,s,r,a,l,h,c,d,u){"use strict";e.addComponent({name:"Geospatial",types:{GeoCoordinate:t,GeoElevationGrid:i,GeoLOD:n,GeoLocation:o,GeoMetadata:s,GeoOrigin:r,GeoPositionInterpolator:a,GeoProximitySensor:l,GeoTouchSensor:h,GeoTransform:c,GeoViewpoint:d},abstractTypes:{X3DGeospatialObject:u}})}))}();
