# Constants Services

## X3DConstants

The X3DConstants object is used to define constants values used throughout this language binding. Each property is defined as a numeric, read-only value. The individual values are not specified; these are implementation-dependent. These constants can be used anywhere that a service request wishes to return some fixed value such as if or switch statements. The list of known values are defined in the table below.

The X3DConstants object is unique in ECMAScript in that there is exactly one globally available instance of the object, named X3DConstants. Properties can be accessed using the syntax X3DConstants.&lt;property-name&gt;.

The object consists solely of read-only properties. It does not define any additional functions.

### X3DConstant values

#### Browser Event Constants

- INITIALIZED\_EVENT
- SHUTDOWN\_EVENT
- CONNECTION\_ERROR
- INITIALIZED\_ERROR

#### Load State Constants

- NOT\_STARTED\_STATE
- IN\_PROGRESS\_STATE
- COMPLETE\_STATE
- FAILED\_STATE

#### Access Type Constants

- initializeOnly
- inputOnly
- outputOnly
- inputOutput

#### Field Type Constants

- SFBool
- SFColor
- SFColorRGBA
- SFDouble
- SFFloat
- SFImage
- SFInt32
- SFMatrix3d
- SFMatrix3f
- SFMatrix4d
- SFMatrix4f
- SFNode
- SFRotation
- SFString
- SFTime
- SFVec2d
- SFVec2f
- SFVec3d
- SFVec3f
- SFVec4d
- SFVec4f
- SFBool
- MFColor
- MFColorRGBA
- MFDouble
- MFFloat
- MFImage
- MFInt32
- MFMatrix3d
- MFMatrix3f
- MFMatrix4d
- MFMatrix4f
- MFNode
- MFRotation
- MFString
- MFTime
- MFVec2d
- MFVec2f
- MFVec3d
- MFVec3f
- MFVec4d
- MFVec4f

#### Concrete Node Types

All concrete node types from *Anchor, Appearance, …*  to *WorldInfo.*

- Anchor
- Appearance
- Arc2D
- ArcClose2D
- AudioClip
- Background
- BallJoint
- Billboard
- BooleanFilter
- BooleanSequencer
- BooleanToggle
- BooleanTrigger
- BoundedPhysicsModel
- Box
- CADAssembly
- CADFace
- CADLayer
- CADPart
- Circle2D
- ClipPlane
- CollidableOffset
- CollidableShape
- Collision
- CollisionCollection
- CollisionSensor
- CollisionSpace
- Color
- ColorChaser
- ColorDamper
- ColorInterpolator
- ColorRGBA
- ComposedCubeMapTexture
- ComposedShader
- ComposedTexture3D
- Cone
- ConeEmitter
- Contact
- Contour2D
- ContourPolyline2D
- Coordinate
- CoordinateChaser
- CoordinateDamper
- CoordinateDouble
- CoordinateInterpolator
- CoordinateInterpolator2D
- Cylinder
- CylinderSensor
- DISEntityManager
- DISEntityTypeMapping
- DirectionalLight
- Disk2D
- DoubleAxisHingeJoint
- EaseInEaseOut
- ElevationGrid
- EspduTransform
- ExplosionEmitter
- Extrusion
- FillProperties
- FloatVertexAttribute
- Fog
- FogCoordinate
- FontStyle
- ForcePhysicsModel
- GeneratedCubeMapTexture
- GeoCoordinate
- GeoElevationGrid
- GeoLOD
- GeoLocation
- GeoMetadata
- GeoOrigin
- GeoPositionInterpolator
- GeoProximitySensor
- GeoTouchSensor
- GeoTransform
- GeoViewpoint
- Group
- HAnimDisplacer
- HAnimHumanoid
- HAnimJoint
- HAnimSegment
- HAnimSite
- ImageCubeMapTexture
- ImageTexture
- ImageTexture3D
- IndexedFaceSet
- IndexedLineSet
- IndexedQuadSet
- IndexedTriangleFanSet
- IndexedTriangleSet
- IndexedTriangleStripSet
- Inline
- IntegerSequencer
- IntegerTrigger
- KeySensor
- LOD
- Layer
- LayerSet
- Layout
- LayoutGroup
- LayoutLayer
- LinePickSensor
- LineProperties
- LineSet
- LoadSensor
- LocalFog
- Material
- Matrix3VertexAttribute
- Matrix4VertexAttribute
- MetadataBoolean
- MetadataDouble
- MetadataFloat
- MetadataInteger
- MetadataSet
- MetadataString
- MotorJoint
- MovieTexture
- MultiTexture
- MultiTextureCoordinate
- MultiTextureTransform
- NavigationInfo
- Normal
- NormalInterpolator
- NurbsCurve
- NurbsCurve2D
- NurbsOrientationInterpolator
- NurbsPatchSurface
- NurbsPositionInterpolator
- NurbsSet
- NurbsSurfaceInterpolator
- NurbsSweptSurface
- NurbsSwungSurface
- NurbsTextureCoordinate
- NurbsTrimmedSurface
- OrientationChaser
- OrientationDamper
- OrientationInterpolator
- OrthoViewpoint
- PackagedShader
- ParticleSystem
- PickableGroup
- PixelTexture
- PixelTexture3D
- PlaneSensor
- PointEmitter
- PointLight
- PointPickSensor
- PointSet
- Polyline2D
- PolylineEmitter
- Polypoint2D
- PositionChaser
- PositionChaser2D
- PositionDamper
- PositionDamper2D
- PositionInterpolator
- PositionInterpolator2D
- PrimitivePickSensor
- ProgramShader
- ProximitySensor
- QuadSet
- ReceiverPdu
- Rectangle2D
- RigidBody
- RigidBodyCollection
- ScalarChaser
- ScalarDamper
- ScalarInterpolator
- ScreenFontStyle
- ScreenGroup
- Script
- ShaderPart
- ShaderProgram
- Shape
- SignalPdu
- SingleAxisHingeJoint
- SliderJoint
- Sound
- Sphere
- SphereSensor
- SplinePositionInterpolator
- SplinePositionInterpolator2D
- SplineScalarInterpolator
- SpotLight
- SquadOrientationInterpolator
- StaticGroup
- StringSensor
- SurfaceEmitter
- Switch
- TexCoordChaser2D
- TexCoordDamper2D
- Text
- TextureBackground
- TextureCoordinate
- TextureCoordinate3D
- TextureCoordinate4D
- TextureCoordinateGenerator
- TextureProperties
- TextureTransform
- TextureTransform3D
- TextureTransformMatrix3D
- TimeSensor
- TimeTrigger
- TouchGroup
- TouchSensor
- Transform
- TransformSensor
- TransmitterPdu
- TriangleFanSet
- TriangleSet
- TriangleSet2D
- TriangleStripSet
- TwoSidedMaterial
- UniversalJoint
- Viewpoint
- ViewpointGroup
- Viewport
- VisibilitySensor
- VolumeEmitter
- VolumePickSensor
- WindPhysicsModel
- WorldInfo

#### Abstract Node Types

All abstract node types from *X3DAppearanceChildNode, X3DAppearanceNode,* … to *X3DViewportNode.*

- X3DAppearanceChildNode
- X3DAppearanceNode
- X3DBackgroundNode
- X3DBindableNode
- X3DBoundedObject
- X3DChaserNode
- X3DChildNode
- X3DColorNode
- X3DComposedGeometryNode
- X3DCoordinateNode
- X3DDamperNode
- X3DDragSensorNode
- X3DEnvironmentTextureNode
- X3DEnvironmentalSensorNode
- X3DFogObject
- X3DFollowerNode
- X3DFontStyleNode
- X3DGeometricPropertyNode
- X3DGeometryNode
- X3DGeospatialObject
- X3DGroupingNode
- X3DInfoNode
- X3DInterpolatorNode
- X3DKeyDeviceSensorNode
- X3DLayerNode
- X3DLayoutNode
- X3DLightNode
- X3DLineGeometryNode
- X3DMaterialNode
- X3DMetadataObject
- X3DNBodyCollidableNode
- X3DNBodyCollisionSpaceNode
- X3DNetworkSensorNode
- X3DNode
- X3DNormalNode
- X3DNurbsControlCurveNode
- X3DNurbsSurfaceGeometryNode
- X3DParametricGeometryNode
- X3DParticleEmitterNode
- X3DParticlePhysicsModelNode
- X3DPickSensorNode
- X3DPickableObject
- X3DPointingDeviceSensorNode
- X3DProductStructureChildNode
- X3DProgrammableShaderObject
- X3DPrototypeInstance
- X3DRigidJointNode
- X3DScriptNode
- X3DSensorNode
- X3DSequencerNode
- X3DShaderNode
- X3DShapeNode
- X3DSoundNode
- X3DSoundSourceNode
- X3DTexture2DNode
- X3DTexture3DNode
- X3DTextureCoordinateNode
- X3DTextureNode
- X3DTextureTransformNode
- X3DTimeDependentNode
- X3DTouchSensorNode
- X3DTransformMatrix3DNode
- X3DTransformNode
- X3DTriggerNode
- X3DUrlObject
- X3DVertexAttributeNode
- X3DViewpointNode
- X3DViewportNode
