/* -*- Mode: JavaScript; coding: utf-8; tab-width: 3; indent-tabs-mode: tab; c-basic-offset: 3 -*-
 *******************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright create3000, Scheffelstraße 31a, Leipzig, Germany 2011.
 *
 * All rights reserved. Holger Seelig <holger.seelig@yahoo.de>.
 *
 * The copyright notice above does not evidence any actual of intended
 * publication of such source code, and is an unpublished work by create3000.
 * This material contains CONFIDENTIAL INFORMATION that is the property of
 * create3000.
 *
 * No permission is granted to copy, distribute, or create derivative works from
 * the contents of this software, in whole or in part, without the prior written
 * permission of create3000.
 *
 * NON-MILITARY USE ONLY
 *
 * All create3000 software are effectively free software with a non-military use
 * restriction. It is free. Well commented source is provided. You may reuse the
 * source in any way you please with the exception anything that uses it must be
 * marked to indicate is contains 'non-military use only' components.
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2015, 2016 Holger Seelig <holger.seelig@yahoo.de>.
 *
 * This file is part of the X_ITE Project.
 *
 * X_ITE is free software: you can redistribute it and/or modify it under the
 * terms of the GNU General Public License version 3 only, as published by the
 * Free Software Foundation.
 *
 * X_ITE is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License version 3 for more
 * details (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version 3
 * along with X_ITE.  If not, see <http://www.gnu.org/licenses/gpl.html> for a
 * copy of the GPLv3 License.
 *
 * For Silvio, Joy and Adi.
 *
 ******************************************************************************/


define ([
   "x_ite/Fields",
   "x_ite/Base/X3DFieldDefinition",
   "x_ite/Base/FieldDefinitionArray",
   "x_ite/Components/Rendering/X3DLineGeometryNode",
   "x_ite/Base/X3DConstants",
   "standard/Math/Numbers/Complex",
   "standard/Math/Algorithm",
],
function (Fields,
          X3DFieldDefinition,
          FieldDefinitionArray,
          X3DLineGeometryNode,
          X3DConstants,
          Complex,
          Algorithm)
{
"use strict";

   function Arc2D (executionContext)
   {
      X3DLineGeometryNode .call (this, executionContext);

      this .addType (X3DConstants .Arc2D);

      this ._startAngle .setUnit ("angle");
      this ._endAngle   .setUnit ("angle");
      this ._radius     .setUnit ("length");
   }

   Arc2D .prototype = Object .assign (Object .create (X3DLineGeometryNode .prototype),
   {
      constructor: Arc2D,
      [Symbol .for ("X_ITE.X3DBaseNode.fieldDefinitions")]: new FieldDefinitionArray ([
         new X3DFieldDefinition (X3DConstants .inputOutput,    "metadata",   new Fields .SFNode ()),
         new X3DFieldDefinition (X3DConstants .initializeOnly, "startAngle", new Fields .SFFloat ()),
         new X3DFieldDefinition (X3DConstants .initializeOnly, "endAngle",   new Fields .SFFloat (1.5708)),
         new X3DFieldDefinition (X3DConstants .initializeOnly, "radius",     new Fields .SFFloat (1)),
      ]),
      getTypeName: function ()
      {
         return "Arc2D";
      },
      getComponentName: function ()
      {
         return "Geometry2D";
      },
      getContainerField: function ()
      {
         return "geometry";
      },
      set_live__: function ()
      {
         X3DLineGeometryNode .prototype .set_live__ .call (this);

         if (this .isLive () .getValue ())
            this .getBrowser () .getArc2DOptions () .addInterest ("requestRebuild", this);
         else
            this .getBrowser () .getArc2DOptions () .removeInterest ("requestRebuild", this);
      },
      getSweepAngle: function ()
      {
         const
            start = Algorithm .interval (this ._startAngle .getValue (), 0, Math .PI * 2),
            end   = Algorithm .interval (this ._endAngle   .getValue (), 0, Math .PI * 2);

         if (start === end)
            return Math .PI * 2;

         const sweepAngle = Math .abs (end - start);

         if (start > end)
            return (Math .PI * 2) - sweepAngle;

         if (! isNaN (sweepAngle))
            return sweepAngle;

         // We must test for NAN, as NAN to int is undefined.
         return 0;
      },
      build: function ()
      {
         const
            options     = this .getBrowser () .getArc2DOptions (),
            dimension   = options ._dimension .getValue (),
            startAngle  = this ._startAngle .getValue  (),
            radius      = Math .abs (this ._radius .getValue ()),
            sweepAngle  = this .getSweepAngle (),
            steps       = Math .max (3, Math .floor (sweepAngle * dimension / (Math .PI * 2))),
            vertexArray = this .getVertices ();

         for (let n = 0; n < steps; ++ n)
         {
            const
               t1     = n / steps,
               theta1 = startAngle + (sweepAngle * t1),
               point1 = Complex .Polar (radius, theta1),
               t2     = (n + 1) / steps,
               theta2 = startAngle + (sweepAngle * t2),
               point2 = Complex .Polar (radius, theta2);

            vertexArray .push (point1 .real, point1 .imag, 0, 1);
            vertexArray .push (point2 .real, point2 .imag, 0, 1);
         }

         this .getMin () .set (-radius, -radius, 0);
         this .getMax () .set ( radius,  radius, 0);
      },
   });

   return Arc2D;
});
