/* -*- Mode: JavaScript; coding: utf-8; tab-width: 3; indent-tabs-mode: tab; c-basic-offset: 3 -*-
 *******************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright create3000, Scheffelstraße 31a, Leipzig, Germany 2011.
 *
 * All rights reserved. Holger Seelig <holger.seelig@yahoo.de>.
 *
 * The copyright notice above does not evidence any actual of intended
 * publication of such source code, and is an unpublished work by create3000.
 * This material contains CONFIDENTIAL INFORMATION that is the property of
 * create3000.
 *
 * No permission is granted to copy, distribute, or create derivative works from
 * the contents of this software, in whole or in part, without the prior written
 * permission of create3000.
 *
 * NON-MILITARY USE ONLY
 *
 * All create3000 software are effectively free software with a non-military use
 * restriction. It is free. Well commented source is provided. You may reuse the
 * source in any way you please with the exception anything that uses it must be
 * marked to indicate is contains 'non-military use only' components.
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2015, 2016 Holger Seelig <holger.seelig@yahoo.de>.
 *
 * This file is part of the X_ITE Project.
 *
 * X_ITE is free software: you can redistribute it and/or modify it under the
 * terms of the GNU General Public License version 3 only, as published by the
 * Free Software Foundation.
 *
 * X_ITE is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License version 3 for more
 * details (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version 3
 * along with X_ITE.  If not, see <http://www.gnu.org/licenses/gpl.html> for a
 * copy of the GPLv3 License.
 *
 * For Silvio, Joy and Adi.
 *
 ******************************************************************************/


define ([
   "x_ite/Fields",
   "x_ite/Base/X3DFieldDefinition",
   "x_ite/Base/FieldDefinitionArray",
   "x_ite/Components/Shape/X3DAppearanceNode",
   "x_ite/Base/X3DCast",
   "x_ite/Base/X3DConstants",
   "x_ite/Browser/Shape/AlphaMode",
],
function (Fields,
          X3DFieldDefinition,
          FieldDefinitionArray,
          X3DAppearanceNode,
          X3DCast,
          X3DConstants,
          AlphaMode)
{
"use strict";

   function Appearance (executionContext)
   {
      X3DAppearanceNode .call (this, executionContext);

      this .addType (X3DConstants .Appearance);

      this .stylePropertiesNode     = [ ];
      this .materialNode            = null;
      this .backMaterialNode        = null;
      this .textureNode             = null;
      this .textureTransformNode    = null;
      this .textureTransformMapping = new Map ();
      this .shaderNodes             = [ ];
      this .shaderNode              = null;
      this .blendModeNode           = null;
   }

   Appearance .prototype = Object .assign (Object .create (X3DAppearanceNode .prototype),
   {
      constructor: Appearance,
      [Symbol .for ("X_ITE.X3DBaseNode.fieldDefinitions")]: new FieldDefinitionArray ([
         new X3DFieldDefinition (X3DConstants .inputOutput, "metadata",           new Fields .SFNode ()),
         new X3DFieldDefinition (X3DConstants .inputOutput, "alphaMode",          new Fields .SFString ("AUTO")),
         new X3DFieldDefinition (X3DConstants .inputOutput, "alphaCutoff",        new Fields .SFFloat (0.5)),
         new X3DFieldDefinition (X3DConstants .inputOutput, "acousticProperties", new Fields .SFNode ()),
         new X3DFieldDefinition (X3DConstants .inputOutput, "pointProperties",    new Fields .SFNode ()),
         new X3DFieldDefinition (X3DConstants .inputOutput, "lineProperties",     new Fields .SFNode ()),
         new X3DFieldDefinition (X3DConstants .inputOutput, "fillProperties",     new Fields .SFNode ()),
         new X3DFieldDefinition (X3DConstants .inputOutput, "material",           new Fields .SFNode ()),
         new X3DFieldDefinition (X3DConstants .inputOutput, "backMaterial",       new Fields .SFNode ()),
         new X3DFieldDefinition (X3DConstants .inputOutput, "texture",            new Fields .SFNode ()),
         new X3DFieldDefinition (X3DConstants .inputOutput, "textureTransform",   new Fields .SFNode ()),
         new X3DFieldDefinition (X3DConstants .inputOutput, "shaders",            new Fields .MFNode ()),
         new X3DFieldDefinition (X3DConstants .inputOutput, "blendMode",          new Fields .SFNode ()),
      ]),
      getTypeName: function ()
      {
         return "Appearance";
      },
      getComponentName: function ()
      {
         return "Shape";
      },
      getContainerField: function ()
      {
         return "appearance";
      },
      initialize: function ()
      {
         X3DAppearanceNode .prototype .initialize .call (this);

         this .isLive () .addInterest ("set_live__", this);

         this ._alphaMode  		.addInterest ("set_alphaMode__",        this);
         this ._alphaCutoff  		.addInterest ("set_alphaCutoff__",      this);
         this ._pointProperties  .addInterest ("set_pointProperties__",  this);
         this ._lineProperties   .addInterest ("set_lineProperties__",   this);
         this ._fillProperties   .addInterest ("set_fillProperties__",   this);
         this ._material         .addInterest ("set_material__",         this);
         this ._backMaterial     .addInterest ("set_backMaterial__",     this);
         this ._texture          .addInterest ("set_texture__",          this);
         this ._textureTransform .addInterest ("set_textureTransform__", this);
         this ._shaders          .addInterest ("set_shaders__",          this);
         this ._blendMode        .addInterest ("set_blendMode__",        this);

         this ._alphaMode      .addInterest ("set_transparent__", this);
         this ._fillProperties .addInterest ("set_transparent__", this);
         this ._material       .addInterest ("set_transparent__", this);
         this ._texture        .addInterest ("set_transparent__", this);
         this ._blendMode      .addInterest ("set_transparent__", this);

         this .set_live__ ();
         this .set_alphaMode__ ();
         this .set_pointProperties__ ();
         this .set_lineProperties__ ();
         this .set_fillProperties__ ();
         this .set_material__ ();
         this .set_backMaterial__ ();
         this .set_texture__ ();
         this .set_textureTransform__ ();
         this .set_shaders__ ();
         this .set_blendMode__ ();
         this .set_transparent__ ();
      },
      getAlphaMode: function ()
      {
         return this .alphaMode;
      },
      set_live__: function ()
      {
         if (this .isLive () .getValue ())
         {
            this .getBrowser () .getBrowserOptions () ._Shading .addInterest ("set_shading__", this);

            if (this .shaderNode)
               this .getBrowser () .addShader (this .shaderNode);
         }
         else
         {
            this .getBrowser () .getBrowserOptions () ._Shading .removeInterest ("set_shading__", this);

            if (this .shaderNode)
               this .getBrowser () .removeShader (this .shaderNode);
         }
      },
      set_alphaMode__: function ()
      {
         this .alphaMode = AlphaMode [this ._alphaMode .getValue ()] || AlphaMode .AUTO;

         this .set_alphaCutoff__ ();
      },
      set_alphaCutoff__: function ()
      {
         this .alphaCutoff = this .alphaMode === AlphaMode .MASK ? this ._alphaCutoff .getValue () : 0;
      },
      set_pointProperties__: function ()
      {
         this .stylePropertiesNode [0] = X3DCast (X3DConstants .PointProperties, this ._pointProperties);

         if (! this .stylePropertiesNode [0])
            this .stylePropertiesNode [0] = this .getBrowser () .getDefaultPointProperties ();
      },
      set_lineProperties__: function ()
      {
         this .stylePropertiesNode [1] = X3DCast (X3DConstants .LineProperties, this ._lineProperties);

         if (! this .stylePropertiesNode [1])
            this .stylePropertiesNode [1] = this .getBrowser () .getDefaultLineProperties ();
      },
      set_fillProperties__: function ()
      {
         if (this .stylePropertiesNode [2])
            this .stylePropertiesNode [2] ._transparent .removeInterest ("set_transparent__", this);

         this .stylePropertiesNode [2] = X3DCast (X3DConstants .FillProperties, this ._fillProperties);

         if (! this .stylePropertiesNode [2])
            this .stylePropertiesNode [2] = this .getBrowser () .getDefaultFillProperties ();

         if (this .stylePropertiesNode [2])
            this .stylePropertiesNode [2] ._transparent .addInterest ("set_transparent__", this);

         this .stylePropertiesNode [3] = this .stylePropertiesNode [2];
      },
      set_material__: function ()
      {
         if (this .materialNode)
            this .materialNode ._transparent .removeInterest ("set_transparent__", this);

         this .materialNode = X3DCast (X3DConstants .X3DMaterialNode, this ._material);

         if (! this .materialNode)
            this .materialNode = this .getBrowser () .getDefaultMaterial ();

         if (this .materialNode)
            this .materialNode ._transparent .addInterest ("set_transparent__", this);

         // Depreciated TwoSidedMaterial handling.

         if (this .materialNode .getTypeName () === "TwoSidedMaterial")
         {
            console .warn ("TwoSidedMaterial is depreciated, please use Appearance backMaterial.");
            this .set_backMaterial__ ();
         }
      },
      set_backMaterial__: function ()
      {
         if (this .backMaterialNode)
            this .backMaterialNode ._transparent .removeInterest ("set_transparent__", this);

         this .backMaterialNode = X3DCast (X3DConstants .X3DOneSidedMaterialNode, this ._backMaterial);

         if (this .backMaterialNode)
            this .backMaterialNode ._transparent .addInterest ("set_transparent__", this);

         // Depreciated TwoSidedMaterial handling.

         if (!this .backMaterialNode && this .materialNode .getTypeName () === "TwoSidedMaterial")
            this .backMaterialNode = this .materialNode;
      },
      set_texture__: function ()
      {
         if (this .textureNode)
            this .textureNode ._transparent .removeInterest ("set_transparent__", this);

         this .textureNode = X3DCast (X3DConstants .X3DTextureNode, this ._texture);

         if (this .textureNode)
            this .textureNode ._transparent .addInterest ("set_transparent__", this);
      },
      set_textureTransform__: function ()
      {
         if (this .textureTransformNode)
            this .textureTransformNode .removeInterest ("updateTextureTransformMapping", this);

         this .textureTransformNode = X3DCast (X3DConstants .X3DTextureTransformNode, this ._textureTransform);

         if (!this .textureTransformNode)
            this .textureTransformNode = this .getBrowser () .getDefaultTextureTransform ();

         this .textureTransformNode .addInterest ("updateTextureTransformMapping", this);

         this .updateTextureTransformMapping ();
      },
      updateTextureTransformMapping: function ()
      {
         this .textureTransformMapping .clear ();

         this .textureTransformNode .getTextureMapping (this .textureTransformMapping);
      },
      set_shaders__: function ()
      {
         const shaderNodes = this .shaderNodes;

         for (const shaderNode of shaderNodes)
         {
            shaderNode ._isValid        .removeInterest ("set_shader__", this);
            shaderNode ._activationTime .removeInterest ("set_shader__", this);
         }

         shaderNodes .length = 0;

         for (const node of this ._shaders)
         {
            const shaderNode = X3DCast (X3DConstants .X3DShaderNode, node);

            if (shaderNode)
            {
               shaderNodes .push (shaderNode);

               shaderNode ._isValid        .addInterest ("set_shader__", this);
               shaderNode ._activationTime .addInterest ("set_shader__", this);
            }
         }

         this .set_shader__ ();
      },
      set_shader__: function ()
      {
         const shaderNodes = this .shaderNodes;

         if (this .shaderNode)
         {
            this .getBrowser () .removeShader (this .shaderNode);
            this .shaderNode .deselect ();
         }

         this .shaderNode = null;

         for (const shaderNode of shaderNodes)
         {
            if (shaderNode ._isValid .getValue ())
            {
               if (shaderNode ._activationTime .getValue () === this .getBrowser () .getCurrentTime ())
               {
                  this .shaderNode = shaderNode;
                  break;
               }
            }
         }

         if (!this .shaderNode)
         {
            for (const shaderNode of shaderNodes)
            {
               if (shaderNode ._isValid .getValue ())
               {
                  this .shaderNode = shaderNode;
                  break;
               }
            }
         }

         if (this .isLive () .getValue ())
         {
            if (this .shaderNode)
            {
               this .getBrowser () .addShader (this .shaderNode);
               this .shaderNode .select ();
            }
         }
      },
      set_shading__: function ()
      {
         this .set_shader__ ();
      },
      set_blendMode__: function ()
      {
         this .blendModeNode = X3DCast (X3DConstants .BlendMode, this ._blendMode);
      },
      set_transparent__: function ()
      {
         switch (this .alphaMode)
         {
            case AlphaMode .AUTO:
               this .setTransparent (Boolean (this .stylePropertiesNode [3] .getTransparent () ||
                                     (this .materialNode && this .materialNode .getTransparent ()) ||
                                     (this .backMaterialNode && this .backMaterialNode .getTransparent ()) ||
                                     (this .textureNode && this .textureNode .getTransparent ()) ||
                                     this .blendModeNode));
               break;
            case AlphaMode .OPAQUE:
               this .setTransparent (false);
               break;
            case AlphaMode .MASK:
               this .setTransparent (false);
               break;
            case AlphaMode .BLEND:
               this .setTransparent (true);
               break;
         }
      },
      traverse: function (type, renderObject)
      {
         if (this .textureNode)
            this .textureNode .traverse (type, renderObject);

         if (this .shaderNode)
            this .shaderNode .traverse (type, renderObject);
      },
   });

   return Appearance;
});
