# Getting Started

## Overview

X\_ITE is a new 3D JavaScript library entirely written in JavaScript and uses WebGL for 3D rendering. Authors can publish X3D and VRML source online within an HTML5 page with X\_ITE that works with Web browsers **without** prior plugin installation. This gives X3D authors the ability to displays content in 3D, using WebGL 3D graphics technology to display X3D content in several different browsers across several different operating systems. Since X3D is backwardly compatible, X\_ITE can also be used as a VRML viewer.

X3D is an ISO-ratified, royalty-free open standards file format and run-time architecture to represent and communicate 3D scenes and objects specified by the Web 3D Consortium. X3D has evolved from its beginnings as the Virtual Reality Modeling Language (VRML) to the considerably more mature and refined ISO X3D standard. X3D provides a system for the storage, retrieval and playback of real time 3D scene in multiple applications, all within an open architecture to support a wide array of domains and user scenarios.

X\_ITE supports custom shaders, clip planes, reflection mapping, script nodes, prototyping capabilities and event driven programming to provide you with an improved quality level of virtual effects and tools ready for the Internet.

**Developer note:** X\_ITE runs best in fresh installs of Google Chrome, Chromium, Firefox, Safari, Opera, and Microsoft Edge. X\_ITE uses the latest JavaScript standard, but is also compatible with older browser, and is available both on your desktop computer and on your modern smart-phone.
{: .notice--info}

If you ever get in trouble, please [file a bug](https://github.com/create3000/x_ite/issues).

## X3D Examples

<table class="examples">
  <tr>
    <td>
      <a href="https://create3000.github.io/media/examples/X3D/Appartment/example.html" title="X3D » Appartment">
        <img src="https://create3000.github.io/media/examples/X3D/Appartment/screenshot-small.png" alt="Appartment"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/X3D/Approach/example.html" title="X3D » Approach">
        <img src="https://create3000.github.io/media/examples/X3D/Approach/screenshot-small.png" alt="Approach"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/X3D/Arcadia/example.html" title="X3D » Arcadia">
        <img src="https://create3000.github.io/media/examples/X3D/Arcadia/screenshot-small.png" alt="Arcadia"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/X3D/Astronomy/example.html" title="X3D » Astronomy">
        <img src="https://create3000.github.io/media/examples/X3D/Astronomy/screenshot-small.png" alt="Astronomy"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/X3D/BIC/example.html" title="X3D » BIC">
        <img src="https://create3000.github.io/media/examples/X3D/BIC/screenshot-small.png" alt="BIC"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/X3D/BeyondGermany/example.html" title="X3D » BeyondGermany">
        <img src="https://create3000.github.io/media/examples/X3D/BeyondGermany/screenshot-small.png" alt="BeyondGermany"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/X3D/Chomp/example.html" title="X3D » Chomp">
        <img src="https://create3000.github.io/media/examples/X3D/Chomp/screenshot-small.png" alt="Chomp"/>
      </a>
    </td>
  </tr>
  <tr>
    <td>
      <a href="https://create3000.github.io/media/examples/X3D/Circles/example.html" title="X3D » Circles">
        <img src="https://create3000.github.io/media/examples/X3D/Circles/screenshot-small.png" alt="Circles"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/X3D/CrazySpiral/example.html" title="X3D » CrazySpiral">
        <img src="https://create3000.github.io/media/examples/X3D/CrazySpiral/screenshot-small.png" alt="CrazySpiral"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/X3D/Currencies/example.html" title="X3D » Currencies">
        <img src="https://create3000.github.io/media/examples/X3D/Currencies/screenshot-small.png" alt="Currencies"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/X3D/FlashingLights/example.html" title="X3D » FlashingLights">
        <img src="https://create3000.github.io/media/examples/X3D/FlashingLights/screenshot-small.png" alt="FlashingLights"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/X3D/FoldUp/example.html" title="X3D » FoldUp">
        <img src="https://create3000.github.io/media/examples/X3D/FoldUp/screenshot-small.png" alt="FoldUp"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/X3D/LogoPieces/example.html" title="X3D » LogoPieces">
        <img src="https://create3000.github.io/media/examples/X3D/LogoPieces/screenshot-small.png" alt="LogoPieces"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/X3D/LustForLife/example.html" title="X3D » LustForLife">
        <img src="https://create3000.github.io/media/examples/X3D/LustForLife/screenshot-small.png" alt="LustForLife"/>
      </a>
    </td>
  </tr>
  <tr>
    <td>
      <a href="https://create3000.github.io/media/examples/X3D/MagicMushrooms/example.html" title="X3D » MagicMushrooms">
        <img src="https://create3000.github.io/media/examples/X3D/MagicMushrooms/screenshot-small.png" alt="MagicMushrooms"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/X3D/MilkywayAndBeyond/example.html" title="X3D » MilkywayAndBeyond">
        <img src="https://create3000.github.io/media/examples/X3D/MilkywayAndBeyond/screenshot-small.png" alt="MilkywayAndBeyond"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/X3D/NYC/example.html" title="X3D » NYC">
        <img src="https://create3000.github.io/media/examples/X3D/NYC/screenshot-small.png" alt="NYC"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/X3D/Pong/example.html" title="X3D » Pong">
        <img src="https://create3000.github.io/media/examples/X3D/Pong/screenshot-small.png" alt="Pong"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/X3D/SecretLabyrinth/example.html" title="X3D » SecretLabyrinth">
        <img src="https://create3000.github.io/media/examples/X3D/SecretLabyrinth/screenshot-small.png" alt="SecretLabyrinth"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/X3D/SlidingPuzzle/example.html" title="X3D » SlidingPuzzle">
        <img src="https://create3000.github.io/media/examples/X3D/SlidingPuzzle/screenshot-small.png" alt="SlidingPuzzle"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/X3D/SmartyBubbles/example.html" title="X3D » SmartyBubbles">
        <img src="https://create3000.github.io/media/examples/X3D/SmartyBubbles/screenshot-small.png" alt="SmartyBubbles"/>
      </a>
    </td>
  </tr>
  <tr>
    <td>
      <a href="https://create3000.github.io/media/examples/X3D/SmashingBoxes/example.html" title="X3D » SmashingBoxes">
        <img src="https://create3000.github.io/media/examples/X3D/SmashingBoxes/screenshot-small.png" alt="SmashingBoxes"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/X3D/SugarSmack/example.html" title="X3D » SugarSmack">
        <img src="https://create3000.github.io/media/examples/X3D/SugarSmack/screenshot-small.png" alt="SugarSmack"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/X3D/TikiWorld/example.html" title="X3D » TikiWorld">
        <img src="https://create3000.github.io/media/examples/X3D/TikiWorld/screenshot-small.png" alt="TikiWorld"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/X3D/TreasureIsland/example.html" title="X3D » TreasureIsland">
        <img src="https://create3000.github.io/media/examples/X3D/TreasureIsland/screenshot-small.png" alt="TreasureIsland"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/X3D/Vattenfall/example.html" title="X3D » Vattenfall">
        <img src="https://create3000.github.io/media/examples/X3D/Vattenfall/screenshot-small.png" alt="Vattenfall"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/X3D/WaterQuality/example.html" title="X3D » WaterQuality">
        <img src="https://create3000.github.io/media/examples/X3D/WaterQuality/screenshot-small.png" alt="WaterQuality"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/CADGeometry/QuadSet/example.html" title="CADGeometry » QuadSet">
        <img src="https://create3000.github.io/media/examples/CADGeometry/QuadSet/screenshot-small.png" alt="QuadSet"/>
      </a>
    </td>
  </tr>
  <tr>
    <td>
      <a href="https://create3000.github.io/media/examples/CubeMapTexturing/ComposedCubeMapTexture/example.html" title="CubeMapTexturing » ComposedCubeMapTexture">
        <img src="https://create3000.github.io/media/examples/CubeMapTexturing/ComposedCubeMapTexture/screenshot-small.png" alt="ComposedCubeMapTexture"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/CubeMapTexturing/GeneratedCubeMapTexture/example.html" title="CubeMapTexturing » GeneratedCubeMapTexture">
        <img src="https://create3000.github.io/media/examples/CubeMapTexturing/GeneratedCubeMapTexture/screenshot-small.png" alt="GeneratedCubeMapTexture"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/EnvironmentalEffects/Background/example.html" title="EnvironmentalEffects » Background">
        <img src="https://create3000.github.io/media/examples/EnvironmentalEffects/Background/screenshot-small.png" alt="Background"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/EnvironmentalEffects/Fog/example.html" title="EnvironmentalEffects » Fog">
        <img src="https://create3000.github.io/media/examples/EnvironmentalEffects/Fog/screenshot-small.png" alt="Fog"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/EnvironmentalEffects/LocalFog/example.html" title="EnvironmentalEffects » LocalFog">
        <img src="https://create3000.github.io/media/examples/EnvironmentalEffects/LocalFog/screenshot-small.png" alt="LocalFog"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/EnvironmentalEffects/TextureBackground/example.html" title="EnvironmentalEffects » TextureBackground">
        <img src="https://create3000.github.io/media/examples/EnvironmentalEffects/TextureBackground/screenshot-small.png" alt="TextureBackground"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/EnvironmentalSensor/ProximitySensor/example.html" title="EnvironmentalSensor » ProximitySensor">
        <img src="https://create3000.github.io/media/examples/EnvironmentalSensor/ProximitySensor/screenshot-small.png" alt="ProximitySensor"/>
      </a>
    </td>
  </tr>
  <tr>
    <td>
      <a href="https://create3000.github.io/media/examples/EnvironmentalSensor/TransformSensor/example.html" title="EnvironmentalSensor » TransformSensor">
        <img src="https://create3000.github.io/media/examples/EnvironmentalSensor/TransformSensor/screenshot-small.png" alt="TransformSensor"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/EnvironmentalSensor/VisibilitySensor/example.html" title="EnvironmentalSensor » VisibilitySensor">
        <img src="https://create3000.github.io/media/examples/EnvironmentalSensor/VisibilitySensor/screenshot-small.png" alt="VisibilitySensor"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/EventUtilities/IntegerSequencer/example.html" title="EventUtilities » IntegerSequencer">
        <img src="https://create3000.github.io/media/examples/EventUtilities/IntegerSequencer/screenshot-small.png" alt="IntegerSequencer"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Followers/ColorChaser/example.html" title="Followers » ColorChaser">
        <img src="https://create3000.github.io/media/examples/Followers/ColorChaser/screenshot-small.png" alt="ColorChaser"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Followers/ColorDamper/example.html" title="Followers » ColorDamper">
        <img src="https://create3000.github.io/media/examples/Followers/ColorDamper/screenshot-small.png" alt="ColorDamper"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Followers/CoordinateChaser/example.html" title="Followers » CoordinateChaser">
        <img src="https://create3000.github.io/media/examples/Followers/CoordinateChaser/screenshot-small.png" alt="CoordinateChaser"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Followers/ScalarChaser/example.html" title="Followers » ScalarChaser">
        <img src="https://create3000.github.io/media/examples/Followers/ScalarChaser/screenshot-small.png" alt="ScalarChaser"/>
      </a>
    </td>
  </tr>
  <tr>
    <td>
      <a href="https://create3000.github.io/media/examples/Geometry2D/Arc2D/example.html" title="Geometry2D » Arc2D">
        <img src="https://create3000.github.io/media/examples/Geometry2D/Arc2D/screenshot-small.png" alt="Arc2D"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Geometry2D/ArcClose2D/example.html" title="Geometry2D » ArcClose2D">
        <img src="https://create3000.github.io/media/examples/Geometry2D/ArcClose2D/screenshot-small.png" alt="ArcClose2D"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Geometry2D/Circle2D/example.html" title="Geometry2D » Circle2D">
        <img src="https://create3000.github.io/media/examples/Geometry2D/Circle2D/screenshot-small.png" alt="Circle2D"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Geometry2D/Disk2D/example.html" title="Geometry2D » Disk2D">
        <img src="https://create3000.github.io/media/examples/Geometry2D/Disk2D/screenshot-small.png" alt="Disk2D"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Geometry2D/Polyline2D/example.html" title="Geometry2D » Polyline2D">
        <img src="https://create3000.github.io/media/examples/Geometry2D/Polyline2D/screenshot-small.png" alt="Polyline2D"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Geometry2D/Polypoint2D/example.html" title="Geometry2D » Polypoint2D">
        <img src="https://create3000.github.io/media/examples/Geometry2D/Polypoint2D/screenshot-small.png" alt="Polypoint2D"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Geometry2D/Rectangle2D/example.html" title="Geometry2D » Rectangle2D">
        <img src="https://create3000.github.io/media/examples/Geometry2D/Rectangle2D/screenshot-small.png" alt="Rectangle2D"/>
      </a>
    </td>
  </tr>
  <tr>
    <td>
      <a href="https://create3000.github.io/media/examples/Geometry2D/TriangleSet2D/example.html" title="Geometry2D » TriangleSet2D">
        <img src="https://create3000.github.io/media/examples/Geometry2D/TriangleSet2D/screenshot-small.png" alt="TriangleSet2D"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Geometry3D/Box/example.html" title="Geometry3D » Box">
        <img src="https://create3000.github.io/media/examples/Geometry3D/Box/screenshot-small.png" alt="Box"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Geometry3D/Cone/example.html" title="Geometry3D » Cone">
        <img src="https://create3000.github.io/media/examples/Geometry3D/Cone/screenshot-small.png" alt="Cone"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Geometry3D/Cylinder/example.html" title="Geometry3D » Cylinder">
        <img src="https://create3000.github.io/media/examples/Geometry3D/Cylinder/screenshot-small.png" alt="Cylinder"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Geometry3D/ElevationGrid/example.html" title="Geometry3D » ElevationGrid">
        <img src="https://create3000.github.io/media/examples/Geometry3D/ElevationGrid/screenshot-small.png" alt="ElevationGrid"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Geometry3D/Extrusion/example.html" title="Geometry3D » Extrusion">
        <img src="https://create3000.github.io/media/examples/Geometry3D/Extrusion/screenshot-small.png" alt="Extrusion"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Geometry3D/IndexedFaceSet/example.html" title="Geometry3D » IndexedFaceSet">
        <img src="https://create3000.github.io/media/examples/Geometry3D/IndexedFaceSet/screenshot-small.png" alt="IndexedFaceSet"/>
      </a>
    </td>
  </tr>
  <tr>
    <td>
      <a href="https://create3000.github.io/media/examples/Geometry3D/Sphere/example.html" title="Geometry3D » Sphere">
        <img src="https://create3000.github.io/media/examples/Geometry3D/Sphere/screenshot-small.png" alt="Sphere"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Geospatial/GeoElevationGrid/example.html" title="Geospatial » GeoElevationGrid">
        <img src="https://create3000.github.io/media/examples/Geospatial/GeoElevationGrid/screenshot-small.png" alt="GeoElevationGrid"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Geospatial/GeoLOD/example.html" title="Geospatial » GeoLOD">
        <img src="https://create3000.github.io/media/examples/Geospatial/GeoLOD/screenshot-small.png" alt="GeoLOD"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Geospatial/GeoViewpoint/example.html" title="Geospatial » GeoViewpoint">
        <img src="https://create3000.github.io/media/examples/Geospatial/GeoViewpoint/screenshot-small.png" alt="GeoViewpoint"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Grouping/Group/example.html" title="Grouping » Group">
        <img src="https://create3000.github.io/media/examples/Grouping/Group/screenshot-small.png" alt="Group"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Grouping/Switch/example.html" title="Grouping » Switch">
        <img src="https://create3000.github.io/media/examples/Grouping/Switch/screenshot-small.png" alt="Switch"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Grouping/Transform/example.html" title="Grouping » Transform">
        <img src="https://create3000.github.io/media/examples/Grouping/Transform/screenshot-small.png" alt="Transform"/>
      </a>
    </td>
  </tr>
  <tr>
    <td>
      <a href="https://create3000.github.io/media/examples/HAnim/HAnimHumanoid/example.html" title="HAnim » HAnimHumanoid">
        <img src="https://create3000.github.io/media/examples/HAnim/HAnimHumanoid/screenshot-small.png" alt="HAnimHumanoid"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Interpolation/ColorInterpolator/example.html" title="Interpolation » ColorInterpolator">
        <img src="https://create3000.github.io/media/examples/Interpolation/ColorInterpolator/screenshot-small.png" alt="ColorInterpolator"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Interpolation/CoordinateInterpolator/example.html" title="Interpolation » CoordinateInterpolator">
        <img src="https://create3000.github.io/media/examples/Interpolation/CoordinateInterpolator/screenshot-small.png" alt="CoordinateInterpolator"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Interpolation/OrientationInterpolator/example.html" title="Interpolation » OrientationInterpolator">
        <img src="https://create3000.github.io/media/examples/Interpolation/OrientationInterpolator/screenshot-small.png" alt="OrientationInterpolator"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Interpolation/PositionInterpolator/example.html" title="Interpolation » PositionInterpolator">
        <img src="https://create3000.github.io/media/examples/Interpolation/PositionInterpolator/screenshot-small.png" alt="PositionInterpolator"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Interpolation/PositionInterpolator2D/example.html" title="Interpolation » PositionInterpolator2D">
        <img src="https://create3000.github.io/media/examples/Interpolation/PositionInterpolator2D/screenshot-small.png" alt="PositionInterpolator2D"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Interpolation/ScalarInterpolator/example.html" title="Interpolation » ScalarInterpolator">
        <img src="https://create3000.github.io/media/examples/Interpolation/ScalarInterpolator/screenshot-small.png" alt="ScalarInterpolator"/>
      </a>
    </td>
  </tr>
  <tr>
    <td>
      <a href="https://create3000.github.io/media/examples/Interpolation/SplineScalarInterpolator/example.html" title="Interpolation » SplineScalarInterpolator">
        <img src="https://create3000.github.io/media/examples/Interpolation/SplineScalarInterpolator/screenshot-small.png" alt="SplineScalarInterpolator"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Interpolation/SquadOrientationInterpolator/example.html" title="Interpolation » SquadOrientationInterpolator">
        <img src="https://create3000.github.io/media/examples/Interpolation/SquadOrientationInterpolator/screenshot-small.png" alt="SquadOrientationInterpolator"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/KeyDeviceSensor/KeySensor/example.html" title="KeyDeviceSensor » KeySensor">
        <img src="https://create3000.github.io/media/examples/KeyDeviceSensor/KeySensor/screenshot-small.png" alt="KeySensor"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/KeyDeviceSensor/StringSensor/example.html" title="KeyDeviceSensor » StringSensor">
        <img src="https://create3000.github.io/media/examples/KeyDeviceSensor/StringSensor/screenshot-small.png" alt="StringSensor"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Layering/LayerSet/example.html" title="Layering » LayerSet">
        <img src="https://create3000.github.io/media/examples/Layering/LayerSet/screenshot-small.png" alt="LayerSet"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Layering/Viewport/example.html" title="Layering » Viewport">
        <img src="https://create3000.github.io/media/examples/Layering/Viewport/screenshot-small.png" alt="Viewport"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Lighting/DirectionalLight/example.html" title="Lighting » DirectionalLight">
        <img src="https://create3000.github.io/media/examples/Lighting/DirectionalLight/screenshot-small.png" alt="DirectionalLight"/>
      </a>
    </td>
  </tr>
  <tr>
    <td>
      <a href="https://create3000.github.io/media/examples/Lighting/PointLight/example.html" title="Lighting » PointLight">
        <img src="https://create3000.github.io/media/examples/Lighting/PointLight/screenshot-small.png" alt="PointLight"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Lighting/Shadows/example.html" title="Lighting » Shadows">
        <img src="https://create3000.github.io/media/examples/Lighting/Shadows/screenshot-small.png" alt="Shadows"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Lighting/SpotLight/example.html" title="Lighting » SpotLight">
        <img src="https://create3000.github.io/media/examples/Lighting/SpotLight/screenshot-small.png" alt="SpotLight"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/NURBS/NurbsCurve/example.html" title="NURBS » NurbsCurve">
        <img src="https://create3000.github.io/media/examples/NURBS/NurbsCurve/screenshot-small.png" alt="NurbsCurve"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/NURBS/NurbsPatchSurface/example.html" title="NURBS » NurbsPatchSurface">
        <img src="https://create3000.github.io/media/examples/NURBS/NurbsPatchSurface/screenshot-small.png" alt="NurbsPatchSurface"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/NURBS/NurbsSweptSurface/example.html" title="NURBS » NurbsSweptSurface">
        <img src="https://create3000.github.io/media/examples/NURBS/NurbsSweptSurface/screenshot-small.png" alt="NurbsSweptSurface"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Navigation/Billboard/example.html" title="Navigation » Billboard">
        <img src="https://create3000.github.io/media/examples/Navigation/Billboard/screenshot-small.png" alt="Billboard"/>
      </a>
    </td>
  </tr>
  <tr>
    <td>
      <a href="https://create3000.github.io/media/examples/Navigation/Collision/example.html" title="Navigation » Collision">
        <img src="https://create3000.github.io/media/examples/Navigation/Collision/screenshot-small.png" alt="Collision"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Navigation/LogarithmicDepthBuffer/example.html" title="Navigation » LogarithmicDepthBuffer">
        <img src="https://create3000.github.io/media/examples/Navigation/LogarithmicDepthBuffer/screenshot-small.png" alt="LogarithmicDepthBuffer"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Navigation/NavigationInfo/example.html" title="Navigation » NavigationInfo">
        <img src="https://create3000.github.io/media/examples/Navigation/NavigationInfo/screenshot-small.png" alt="NavigationInfo"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Navigation/OrthoViewpoint/example.html" title="Navigation » OrthoViewpoint">
        <img src="https://create3000.github.io/media/examples/Navigation/OrthoViewpoint/screenshot-small.png" alt="OrthoViewpoint"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Navigation/Viewpoint/example.html" title="Navigation » Viewpoint">
        <img src="https://create3000.github.io/media/examples/Navigation/Viewpoint/screenshot-small.png" alt="Viewpoint"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Networking/Anchor/example.html" title="Networking » Anchor">
        <img src="https://create3000.github.io/media/examples/Networking/Anchor/screenshot-small.png" alt="Anchor"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Networking/Inline/example.html" title="Networking » Inline">
        <img src="https://create3000.github.io/media/examples/Networking/Inline/screenshot-small.png" alt="Inline"/>
      </a>
    </td>
  </tr>
  <tr>
    <td>
      <a href="https://create3000.github.io/media/examples/Networking/LoadSensor/example.html" title="Networking » LoadSensor">
        <img src="https://create3000.github.io/media/examples/Networking/LoadSensor/screenshot-small.png" alt="LoadSensor"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/ParticleSystems/ConeEmitter/example.html" title="ParticleSystems » ConeEmitter">
        <img src="https://create3000.github.io/media/examples/ParticleSystems/ConeEmitter/screenshot-small.png" alt="ConeEmitter"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/ParticleSystems/ExplosionEmitter/example.html" title="ParticleSystems » ExplosionEmitter">
        <img src="https://create3000.github.io/media/examples/ParticleSystems/ExplosionEmitter/screenshot-small.png" alt="ExplosionEmitter"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/ParticleSystems/ForcePhysicsModel/example.html" title="ParticleSystems » ForcePhysicsModel">
        <img src="https://create3000.github.io/media/examples/ParticleSystems/ForcePhysicsModel/screenshot-small.png" alt="ForcePhysicsModel"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/ParticleSystems/ParticleSystem/example.html" title="ParticleSystems » ParticleSystem">
        <img src="https://create3000.github.io/media/examples/ParticleSystems/ParticleSystem/screenshot-small.png" alt="ParticleSystem"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/ParticleSystems/PointEmitter/example.html" title="ParticleSystems » PointEmitter">
        <img src="https://create3000.github.io/media/examples/ParticleSystems/PointEmitter/screenshot-small.png" alt="PointEmitter"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/ParticleSystems/PolylineEmitter/example.html" title="ParticleSystems » PolylineEmitter">
        <img src="https://create3000.github.io/media/examples/ParticleSystems/PolylineEmitter/screenshot-small.png" alt="PolylineEmitter"/>
      </a>
    </td>
  </tr>
  <tr>
    <td>
      <a href="https://create3000.github.io/media/examples/ParticleSystems/SurfaceEmitter/example.html" title="ParticleSystems » SurfaceEmitter">
        <img src="https://create3000.github.io/media/examples/ParticleSystems/SurfaceEmitter/screenshot-small.png" alt="SurfaceEmitter"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/ParticleSystems/VolumeEmitter/example.html" title="ParticleSystems » VolumeEmitter">
        <img src="https://create3000.github.io/media/examples/ParticleSystems/VolumeEmitter/screenshot-small.png" alt="VolumeEmitter"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/ParticleSystems/WindPhysicsModel/example.html" title="ParticleSystems » WindPhysicsModel">
        <img src="https://create3000.github.io/media/examples/ParticleSystems/WindPhysicsModel/screenshot-small.png" alt="WindPhysicsModel"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Picking/LinePickSensor/example.html" title="Picking » LinePickSensor">
        <img src="https://create3000.github.io/media/examples/Picking/LinePickSensor/screenshot-small.png" alt="LinePickSensor"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Picking/PointPickSensor/example.html" title="Picking » PointPickSensor">
        <img src="https://create3000.github.io/media/examples/Picking/PointPickSensor/screenshot-small.png" alt="PointPickSensor"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Picking/PrimitivePickSensor/example.html" title="Picking » PrimitivePickSensor">
        <img src="https://create3000.github.io/media/examples/Picking/PrimitivePickSensor/screenshot-small.png" alt="PrimitivePickSensor"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/PointingDeviceSensor/CylinderSensor/example.html" title="PointingDeviceSensor » CylinderSensor">
        <img src="https://create3000.github.io/media/examples/PointingDeviceSensor/CylinderSensor/screenshot-small.png" alt="CylinderSensor"/>
      </a>
    </td>
  </tr>
  <tr>
    <td>
      <a href="https://create3000.github.io/media/examples/PointingDeviceSensor/PlaneSensor/example.html" title="PointingDeviceSensor » PlaneSensor">
        <img src="https://create3000.github.io/media/examples/PointingDeviceSensor/PlaneSensor/screenshot-small.png" alt="PlaneSensor"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/ProjectiveTextureMapping/TextureProjectorPerspective/example.html" title="ProjectiveTextureMapping » TextureProjectorPerspective">
        <img src="https://create3000.github.io/media/examples/ProjectiveTextureMapping/TextureProjectorPerspective/screenshot-small.png" alt="TextureProjectorPerspective"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Rendering/ClipPlane/example.html" title="Rendering » ClipPlane">
        <img src="https://create3000.github.io/media/examples/Rendering/ClipPlane/screenshot-small.png" alt="ClipPlane"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Rendering/Color/example.html" title="Rendering » Color">
        <img src="https://create3000.github.io/media/examples/Rendering/Color/screenshot-small.png" alt="Color"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Rendering/ColorRGBA/example.html" title="Rendering » ColorRGBA">
        <img src="https://create3000.github.io/media/examples/Rendering/ColorRGBA/screenshot-small.png" alt="ColorRGBA"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Rendering/Coordinate/example.html" title="Rendering » Coordinate">
        <img src="https://create3000.github.io/media/examples/Rendering/Coordinate/screenshot-small.png" alt="Coordinate"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Rendering/IndexedLineSet/example.html" title="Rendering » IndexedLineSet">
        <img src="https://create3000.github.io/media/examples/Rendering/IndexedLineSet/screenshot-small.png" alt="IndexedLineSet"/>
      </a>
    </td>
  </tr>
  <tr>
    <td>
      <a href="https://create3000.github.io/media/examples/Rendering/IndexedTriangleFanSet/example.html" title="Rendering » IndexedTriangleFanSet">
        <img src="https://create3000.github.io/media/examples/Rendering/IndexedTriangleFanSet/screenshot-small.png" alt="IndexedTriangleFanSet"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Rendering/IndexedTriangleSet/example.html" title="Rendering » IndexedTriangleSet">
        <img src="https://create3000.github.io/media/examples/Rendering/IndexedTriangleSet/screenshot-small.png" alt="IndexedTriangleSet"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Rendering/LineSet/example.html" title="Rendering » LineSet">
        <img src="https://create3000.github.io/media/examples/Rendering/LineSet/screenshot-small.png" alt="LineSet"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Rendering/PointSet/example.html" title="Rendering » PointSet">
        <img src="https://create3000.github.io/media/examples/Rendering/PointSet/screenshot-small.png" alt="PointSet"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/RigidBodyPhysics/BallJoint/example.html" title="RigidBodyPhysics » BallJoint">
        <img src="https://create3000.github.io/media/examples/RigidBodyPhysics/BallJoint/screenshot-small.png" alt="BallJoint"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/RigidBodyPhysics/CollidableShape/example.html" title="RigidBodyPhysics » CollidableShape">
        <img src="https://create3000.github.io/media/examples/RigidBodyPhysics/CollidableShape/screenshot-small.png" alt="CollidableShape"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/RigidBodyPhysics/CollisionCollection/example.html" title="RigidBodyPhysics » CollisionCollection">
        <img src="https://create3000.github.io/media/examples/RigidBodyPhysics/CollisionCollection/screenshot-small.png" alt="CollisionCollection"/>
      </a>
    </td>
  </tr>
  <tr>
    <td>
      <a href="https://create3000.github.io/media/examples/RigidBodyPhysics/RigidBody/example.html" title="RigidBodyPhysics » RigidBody">
        <img src="https://create3000.github.io/media/examples/RigidBodyPhysics/RigidBody/screenshot-small.png" alt="RigidBody"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/RigidBodyPhysics/RigidBodyCollection/example.html" title="RigidBodyPhysics » RigidBodyCollection">
        <img src="https://create3000.github.io/media/examples/RigidBodyPhysics/RigidBodyCollection/screenshot-small.png" alt="RigidBodyCollection"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/RigidBodyPhysics/SingleAxisHingeJoint/example.html" title="RigidBodyPhysics » SingleAxisHingeJoint">
        <img src="https://create3000.github.io/media/examples/RigidBodyPhysics/SingleAxisHingeJoint/screenshot-small.png" alt="SingleAxisHingeJoint"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/RigidBodyPhysics/SliderJoint/example.html" title="RigidBodyPhysics » SliderJoint">
        <img src="https://create3000.github.io/media/examples/RigidBodyPhysics/SliderJoint/screenshot-small.png" alt="SliderJoint"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Shaders/ComposedShader/example.html" title="Shaders » ComposedShader">
        <img src="https://create3000.github.io/media/examples/Shaders/ComposedShader/screenshot-small.png" alt="ComposedShader"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Shaders/FloatVertexAttribute/example.html" title="Shaders » FloatVertexAttribute">
        <img src="https://create3000.github.io/media/examples/Shaders/FloatVertexAttribute/screenshot-small.png" alt="FloatVertexAttribute"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Shaders/ShaderPart/example.html" title="Shaders » ShaderPart">
        <img src="https://create3000.github.io/media/examples/Shaders/ShaderPart/screenshot-small.png" alt="ShaderPart"/>
      </a>
    </td>
  </tr>
  <tr>
    <td>
      <a href="https://create3000.github.io/media/examples/Shape/Appearance/example.html" title="Shape » Appearance">
        <img src="https://create3000.github.io/media/examples/Shape/Appearance/screenshot-small.png" alt="Appearance"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Shape/FillProperties/example.html" title="Shape » FillProperties">
        <img src="https://create3000.github.io/media/examples/Shape/FillProperties/screenshot-small.png" alt="FillProperties"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Shape/LineProperties/example.html" title="Shape » LineProperties">
        <img src="https://create3000.github.io/media/examples/Shape/LineProperties/screenshot-small.png" alt="LineProperties"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Shape/Material/example.html" title="Shape » Material">
        <img src="https://create3000.github.io/media/examples/Shape/Material/screenshot-small.png" alt="Material"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Shape/TwoSidedMaterial/example.html" title="Shape » TwoSidedMaterial">
        <img src="https://create3000.github.io/media/examples/Shape/TwoSidedMaterial/screenshot-small.png" alt="TwoSidedMaterial"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Sound/AudioClip/example.html" title="Sound » AudioClip">
        <img src="https://create3000.github.io/media/examples/Sound/AudioClip/screenshot-small.png" alt="AudioClip"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Text/FontStyle/example.html" title="Text » FontStyle">
        <img src="https://create3000.github.io/media/examples/Text/FontStyle/screenshot-small.png" alt="FontStyle"/>
      </a>
    </td>
  </tr>
  <tr>
    <td>
      <a href="https://create3000.github.io/media/examples/Text/Text/example.html" title="Text » Text">
        <img src="https://create3000.github.io/media/examples/Text/Text/screenshot-small.png" alt="Text"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Texturing/ImageTexture/example.html" title="Texturing » ImageTexture">
        <img src="https://create3000.github.io/media/examples/Texturing/ImageTexture/screenshot-small.png" alt="ImageTexture"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Texturing/MovieTexture/example.html" title="Texturing » MovieTexture">
        <img src="https://create3000.github.io/media/examples/Texturing/MovieTexture/screenshot-small.png" alt="MovieTexture"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Texturing/MultiTexture/example.html" title="Texturing » MultiTexture">
        <img src="https://create3000.github.io/media/examples/Texturing/MultiTexture/screenshot-small.png" alt="MultiTexture"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Texturing/PixelTexture/example.html" title="Texturing » PixelTexture">
        <img src="https://create3000.github.io/media/examples/Texturing/PixelTexture/screenshot-small.png" alt="PixelTexture"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Texturing3D/ImageTexture3D/example.html" title="Texturing3D » ImageTexture3D">
        <img src="https://create3000.github.io/media/examples/Texturing3D/ImageTexture3D/screenshot-small.png" alt="ImageTexture3D"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/Time/TimeSensor/example.html" title="Time » TimeSensor">
        <img src="https://create3000.github.io/media/examples/Time/TimeSensor/screenshot-small.png" alt="TimeSensor"/>
      </a>
    </td>
  </tr>
  <tr>
    <td>
      <a href="https://create3000.github.io/media/examples/VolumeRendering/EdgeEnhancementVolumeStyle/example.html" title="VolumeRendering » EdgeEnhancementVolumeStyle">
        <img src="https://create3000.github.io/media/examples/VolumeRendering/EdgeEnhancementVolumeStyle/screenshot-small.png" alt="EdgeEnhancementVolumeStyle"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/VolumeRendering/IsoSurfaceVolumeData/example.html" title="VolumeRendering » IsoSurfaceVolumeData">
        <img src="https://create3000.github.io/media/examples/VolumeRendering/IsoSurfaceVolumeData/screenshot-small.png" alt="IsoSurfaceVolumeData"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/VolumeRendering/SegmentedVolumeData/example.html" title="VolumeRendering » SegmentedVolumeData">
        <img src="https://create3000.github.io/media/examples/VolumeRendering/SegmentedVolumeData/screenshot-small.png" alt="SegmentedVolumeData"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/VolumeRendering/ShadedVolumeStyle/example.html" title="VolumeRendering » ShadedVolumeStyle">
        <img src="https://create3000.github.io/media/examples/VolumeRendering/ShadedVolumeStyle/screenshot-small.png" alt="ShadedVolumeStyle"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/VolumeRendering/ToneMappedVolumeStyle/example.html" title="VolumeRendering » ToneMappedVolumeStyle">
        <img src="https://create3000.github.io/media/examples/VolumeRendering/ToneMappedVolumeStyle/screenshot-small.png" alt="ToneMappedVolumeStyle"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/VolumeRendering/VolumeData/example.html" title="VolumeRendering » VolumeData">
        <img src="https://create3000.github.io/media/examples/VolumeRendering/VolumeData/screenshot-small.png" alt="VolumeData"/>
      </a>
    </td>
    <td>
      <a href="https://create3000.github.io/media/examples/X_ITE/BlendMode/example.html" title="X_ITE » BlendMode">
        <img src="https://create3000.github.io/media/examples/X_ITE/BlendMode/screenshot-small.png" alt="BlendMode"/>
      </a>
    </td>
  </tr>
</table>

The VolumeRendering examples are only working if your browser supports WebGL 2, otherwise the examples left black.
{: .notice}

## Download X\_ITE

There is a ZIP archive available to locally install X\_ITE on your server. Compressed and uncompressed copies of X\_ITE files are available. The uncompressed file (x\_ite.js) is best used during development or debugging; the compressed file (x\_ite.min.js) saves bandwidth and improves performance in production.

[Download X\_ITE ZIP archive](https://create3000.github.io/code/x_ite/latest/dist/x_ite.zip)

### You also can get it on NPM

```sh
$ npm install x_ite
```

It can be used in [Electron](https://www.electronjs.org) apps in the **renderer process** like this:

```js
const X3D = require ("x_ite")
```

### Using X\_ITE with a CDN

CDNs can offer a performance benefit by hosting X\_ITE on servers spread across the globe. This also offers an advantage that if the visitor to your webpage has already downloaded a copy of X\_ITE from the same CDN, it won't have to be re-downloaded. To use the X\_ITE CDN, just reference the CSS and JavaScript file in the script element directly from the GitHub CDN or jsDelivr CDN domain.

### GitHub CDN

GitCDN serves raw files directly from GitHub with proper Content-Type headers and a super fast CDN!

#### Latest Stable Version

If you are a developer or you always wanna be up to date:

```html
<link rel="stylesheet" type="text/css" href="https://create3000.github.io/code/x_ite/latest/dist/x_ite.css"/>
<script type="text/javascript" src="https://create3000.github.io/code/x_ite/latest/dist/x_ite.min.js"></script>
```

#### Snipped

If you are on production and everything works fine, then use a numbered version.

```html
<link rel="stylesheet" type="text/css" href="https://create3000.github.io/code/x_ite/5.0.3/dist/x_ite.css"/>
<script type="text/javascript" src="https://create3000.github.io/code/x_ite/5.0.3/dist/x_ite.min.js"></script>
```

### jsDelivr CDN

Open Source CDN, free, fast, and reliable.

#### Snipped

```html
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/gh/create3000/x_ite@latest/dist/x_ite.css"/>
<script type="text/javascript" src="https://cdn.jsdelivr.net/gh/create3000/x_ite@latest/dist/x_ite.min.js"></script>
```

## WordPress Plug-In

WordPress users can use our plug-in to embed X\_ITE into their web page.

[Download WordPress plug-in](https://github.com/create3000/x_ite-wordpress/raw/main/dist/x_ite.zip)

### Installation

1. Unzip package and put it into the *plugins* folder of your WordPress installation.
2. Install and activate the plugin on the Plugins page.
3. Add shortcode `[X3DCanvas src="https://cdn.rawgit.com/create3000/Library/main/Examples/X_ITE/info.x3d" class="x_ite-browser"]` to page or post content.
4. Modify "src" and "class" attribute.

## Embedding X\_ITE within a Web Page

To display your X3D scene in a HTML5 page first save your scene as X3D XML Encoded file, X3D JSON Encoded file, or as X3D Classic Encoded file, i.e. create a file with the extension .x3d, .x3dj, .x3dv, or .wrl.

The HTML5 page is quite easy to create, the HTML5 code below shows you the minimum requirements. The path to the X3D scene is specified in the src attribute of the &lt;X3DCanvas&gt; element.

```html
<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8"/>
    <link rel="stylesheet" type="text/css" href="https://create3000.github.io/code/x_ite/latest/dist/x_ite.css"/>
    <script type="text/javascript" src="https://create3000.github.io/code/x_ite/latest/dist/x_ite.min.js"></script>
    <style type="text/css">
X3DCanvas {
  width: 768px;
  height: 432px;
}
    </style>
  </head>
  <body>
    <X3DCanvas src="path/to/your/X3D/world.x3d">
      <p>Your browser may not support all features required by X_ITE.
         For a better experience, keep your browser up to date.
         <a href="http://outdatedbrowser.com">Check here for latest versions.</a></p>
    </X3DCanvas>
  </body>
</html>
```

To get X\_ITE working you must include the CSS file »x\_ite.css« and the JavaScript file »x\_ite.min.js«. After x\_ite is successfully loaded a new HTML element &lt;X3DCanvas&gt; is available on your page.

**Note:** You can style the &lt;X3DCanvas&gt; element as every HTML element with CSS as well as you can place it everywhere within the DOM tree.
{: .notice--info}

### Supported File Formats

As of version 1.19, X\_ITE can now parse either X3D XML Encoding or X3D Classic Encoding. This gives authors the capability to use X\_ITE also as VRML viewer.

Additionally files can be compressed using GZip compression.

| X3D Encoding | File Extension | MIME Type      |
|--------------|----------------|----------------|
| XML          | .x3d, .x3dz    | model/x3d+xml  |
| JSON         | .x3dj, .x3djz  | model/x3d+json |
| Classic VRML | .x3dv, .x3dvz  | model/x3d+vrml |
| VRML         | .wrl, .wrz     | model/vrml     |

For more information see [How to Configure Your Web Server](/x_ite/How-To-Configure-Your-Web-Server.html).

### Fallback Content

The &lt;X3DCanvas&gt; element is equal to the &lt;canvas&gt; element in that, it is easy to define some fallback content, to be displayed in older browsers not supporting it. You should always provide fallback content to be displayed by those browsers.

Providing fallback content is very straightforward: just insert the alternate content inside the &lt;X3DCanvas&gt; element. Browsers that don't support &lt;X3DCanvas&gt; will ignore the container and render the fallback content inside it. Browsers that do support &lt;X3DCanvas&gt; will ignore the content inside the container, and just render the canvas normally.

For example, we could provide a text description of the X3D element or provide a static image of the dynamically rendered content. This can look something like this:

```html
<X3DCanvas src="world.x3d">
  <p>Current stock price: $3.15 +0.15</p>
</X3DCanvas>
```

```html
<X3DCanvas src="world.x3dv">
  <img src="images/clock.png"/>
</X3DCanvas>
```

## Attributes of the X3DCanvas Tag

The HTML **&lt;X3DCanvas&gt;** element defines the main content of the X3D document. The &lt;X3DCanvas&gt; element has three attributes that define different behaviours. All of these attributes are optional.

### cache

A Boolean value (`true` or `false`) to indicate whether files transferred over the internet should be cached on the local computer. The default value for the cache attribute is `true`. It works by appending "\_={timestamp}" to the GET parameters of every request.
{: .notice}

### contextMenu

A Boolean value (`true` or `false`) to indicate whether a context menu should be displayed on right click. The default value for the contextMenu attribute is `true`. The context menu can also be extended, [see here](#extending-the-context-menu).
{: .notice}

### notifications

A Boolean value (`true` or `false`) to indicate whether the notification bubble should be displayed. The default value for the notifications attribute is `true`.
{: .notice}

### onerror

Type: script code. This event is sent to an X3DCanvas element when an error occurs loading a scene.
{: .notice}

### onload

Type: script code. This event handler will be called on the X3DCanvas element when a scene has finished loading. This applies whether the scene is applied via the src attribute or when a scene is loaded or replaced by another world. If you change the scene, the event will fire again when the new scene loads. This event will not bubble up the element tree.
{: .notice}

### onshutdown

Type: script code. This event handler will be called on the X3DCanvas element when a scene is unloaded or replaced by another world.
{: .notice}

### preserveDrawingBuffer

A Boolean value (`true` or `false`). If the value is true the drawing buffers will not be cleared and will preserve their values. The default value for preserveDrawingBuffer is `false`. Set preserveDrawingBuffer to true if you want to save the image from the canvas. Keep in mind setting preserveDrawingBuffer to true can have performance implications.
{: .notice}

### splashScreen

A Boolean value (`true` or `false`) to indicate whether the splash screen should be displayed. The default value for the splashScreen attribute is `true`. The display of the splash screen can also be toggled via the browser option »SplashScreen« in JavaScript. Call `Browser .setBrowserOption ("SplashScreen", booleanValue)` to toggle the display of the splash screen.
{: .notice}

### src

A String value with the URL that should be loaded on page load. If no src attribute is specified or the src attribute is empty an empty scene is displayed.
{: .notice}

### url

A MFString value with urls that should be loaded on page load. If no url attribute is specified or the attribute is empty an empty scene is displayed. If both src and url attribute are specified the src attribute takes precedence.
{: .notice}

### Example

```html
<X3DCanvas cache="true" src="path/to/your/X3D/world.x3d"></X3DCanvas>
```

### More Options

More options can be adjusted using the [Browser Object](/x_ite/reference/Browser-Services.html#browser-object) and [Browser Options](/x_ite/reference/Browser-Services.html#browser-options) for scene specific adjustments.

## Keyboard Shortcuts

If the X3DCanvas element is focused, the following keyboard shortcuts are available.

### Home (Pos 1)

Go to first viewpoint.

### End

Go to last viewpoint.

### Page Up

Go to previous viewpoint.

### Page Down

Go to next viewpoint.

### Ctrl++

Display browser timings.

### Ctrl+S

If X3DCanvas attribute *debug* is `true`, toggle begin/end update of browser.

### Ctrl+1

If X3DCanvas attribute *debug* is `true`, set shading to POINT.

### Ctrl+2

If X3DCanvas attribute *debug* is `true`, set shading to WIREFRAME.

### Ctrl+3

If X3DCanvas attribute *debug* is `true`, set shading to FLAT.

### Ctrl+4

If X3DCanvas attribute *debug* is `true`, set shading to GOURAUD.

### Ctrl+5

If X3DCanvas attribute *debug* is `true`, set shading to PHONG.

### Shift+F8

Copy the the current viewpoint of the active layer to clipboard.

## Extending the Context Menu

The context menu is the jQuery Context Menu plugin, and it can be extended using the `items` syntax. The full documentation [can be found here](https://swisnl.github.io/jQuery-contextMenu/docs/items.html).

### Example

```js
Browser .getContextMenu () .setUserMenu (function ()
{
  return {
    "command-1": {
      name: "Command 1",
      callback: function (key, opt)
      {
        console .log ("Clicked on " + key);
      },
    },
  };
});
```

## Accessing the External Browser

X\_ITE is designed to provide access to a browser and its contained scene graph via JavaScript, either within an internal X3D Script node or an external HTML script.

[Learn more how to access the external browser.](/x_ite/Accessing-the-External-Browser.html)

## XHTML DOM Integration

XHTML DOM integration allows you to integrate 3D content seamlessly into your webpage, with just a JavaScript file included the scene can be written directly into the XHTML markup. There are no further plug-ins needed anymore.

[Learn more about how XHTML and X3D can operate together.](/x_ite/XHTML-DOM-Integration.html)

We show you a simple example how you can manipulate the X3D DOM in JavaScript like you would do it with any HTML.

## Using Firefox, Chrome and Opera with Local Files

X\_ITE makes use of the XMLHttpRequest object to load files and there's no way round that. But that means files loading using the file:// scheme protocol are subject to the same origin policy and are handled as cross origin requests (CORS) and cross origin requests are only supported for protocol schemes: http, data and https. That means X\_ITE cannot have access to this files.

To work around this problem you must set up a localhost server, than you can access your local files under the web address http://**localhost**/... This can be done using XAMPP from the <https://www.apachefriends.org> website. XAMPP is a completely free, easy to install Apache distribution containing MariaDB, PHP, and Perl. The XAMPP open source package has been set up to be incredibly easy to install and to use.

MacOS users can use [Personal Web Server](https://apps.apple.com/de/app/personal-web-server/id1486323797?mt=12), which can serve files through a web server, and is very easy to use.

## Report a Bug

If you run into any bugs or encounter any other abnormal issues with X\_ITE, let us know!

Here's an example of a helpful bug report:

*I fell through a hole on the Resistance map. I was running along the wall near the pool of water and fell through a black hole in the wall. I got stuck and had to leave the match. This happened while playing Search and Destroy.*
{: .notice--danger}

[X\_ITE Feedback Survey and Bug Report](https://github.com/create3000/x_ite/issues)
