# Grouping Nodes

## Motivation

You can group shapes to compose complex shapes

X3D has several grouping nodes, including:

### XML Encoding

```xml
<Group><!-- ... --></Group>
<Switch><!-- ... --></Switch>
<Transform><!-- ... --></Transform>
<Billboard><!-- ... --></Billboard>
<Anchor><!-- ... --></Anchor>
<Inline/>
<!-- and more -->
```

### Classic Encoding

```js
Group       { ... }
Switch      { ... }
Transform   { ... }
Billboard   { ... }
Anchor      { ... }
Inline      { ... }
and more
```

## Syntax: Group

The [Group](https://www.web3d.org/documents/specifications/19775-1/V3.3/Part01/components/group.html#Group) node creates a basic group.

- Every child node in the group is displayed.

### XML Encoding

```xml
<Group>
  <!-- children ... -->
</Group>
```

### Classic Encoding

```js
Group {
  children [ ... ]
}
```

## Syntax: Switch

The [Switch](https://www.web3d.org/documents/specifications/19775-1/V3.3/Part01/components/group.html#Switch) group node creates a switched group

- Only one child node in the group is displayed
- You select which child
  - Children implicitly numbered from 0
  - A -1 selects no children

### XML Encoding

```xml
<Switch
    whichChoice='0'>
  <!-- children ... -->
</Switch>
```

### Classic Encoding

```js
Switch {
  whichChoice 0
  children [ ... ]
}
```

## Syntax: Transform

The [Transform](https://www.web3d.org/documents/specifications/19775-1/V3.3/Part01/components/group.html#Transform) group node creates a group with its own coordinate system.

- Every child node in the group is displayed.

### XML Encoding

```xml
<Transform
    translation='0.0 0.0 0.0'
    rotation='0.0 1.0 0.0 0.0'
    scale='1.0 1.0 1.0'>
  <!-- children ... -->
</Transform>
```

### Classic Encoding

```js
Transform {
  translation 0.0 0.0 0.0
  rotation 0.0 1.0 0.0 0.0
  scale 1.0 1.0 1.0
  children [ ... ]
}
```

## Syntax: Billboard

The [Billboard](https://www.web3d.org/documents/specifications/19775-1/V3.3/Part01/components/navigation.html#Billboard) group node creates a group with a special coordinate system.

- Every child node in the group is displayed.
- The coordinate system is turned to face viewer.

### XML Encoding

```xml
<Billboard
    axisOfRotation='0.0 1.0 0.0'>
  <!-- children ... -->
</Billboard>
```

### Classic Encoding

```js
Billboard {
  axisOfRotation 0.0 1.0 0.0
  children [ ... ]
}
```

## Billboard rotation axes

- A rotation axis defines a pole to rotate round
- Similar to a Transform node's rotation field, but no angle (auto computed)
- A standard rotation axis limits rotation to spin about that axis
- A zero rotation axis enables rotation around any axis

| Rotate about | Axis        |
|--------------|-------------|
| X-Axis       | 1.0 0.0 0.0 |
| Y-Axis       | 0.0 1.0 0.0 |
| Z-Axis       | 0.0 0.0 1.0 |
| Any Axis     | 0.0 0.0 0.0 |

## A sample billboard group

### XML Encoding

```xml
<!-- Y-axis -->
<Billboard
    axisOfRotation='0.0 1.0 0.0'>
  <Shape><!-- ... --></Shape>
  <Shape><!-- ... --></Shape>
  <Shape><!-- ... --></Shape>
  <!-- ... -->
</Billboard>
```

### Classic Encoding

```js
Billboard {
  # Y-axis
  axisOfRotation 0.0 1.0 0.0
  children [
    Shape { ... }
    Shape { ... }
    Shape { ... }
    ...
  ]
}
```

## Syntax: Anchor

An [Anchor](https://www.web3d.org/documents/specifications/19775-1/V3.3/Part01/components/networking.html#Anchor) node creates a group that acts as a clickable anchor

- Every child node in the group is displayed
- Clicking any child follows a URL
- A description names the anchor

### XML Encoding

```xml
<Anchor
    url='"stairwy.wrl"'
    description='Twisty Stairs'>
  <!-- children ... -->
</Anchor>
```

### Classic Encoding

```js
Anchor {
  url "stairwy.wrl"
  description "Twisty Stairs"
  children [ ... ]
}
```

## Syntax: Inline

An [Inline](https://www.web3d.org/documents/specifications/19775-1/V3.3/Part01/components/networking.html#Inline) node creates a special group from another X3D file's contents

- Children read from file selected by a URL
- Every child node in group is displayed

### XML Encoding

```xml
<Inline
  url='"table.wrl"'/>
```

### Classic Encoding

```js
Inline {
  url "table.wrl"
}
```

## Summary

- The [Group](https://www.web3d.org/documents/specifications/19775-1/V3.3/Part01/components/group.html#Group) node creates a basic group
- The [Switch](https://www.web3d.org/documents/specifications/19775-1/V3.3/Part01/components/group.html#Switch) node creates a group with 1 choice used
- The [Transform](https://www.web3d.org/documents/specifications/19775-1/V3.3/Part01/components/group.html#Transform) node creates a group with a new coordinate system
- The [Billboard](https://www.web3d.org/documents/specifications/19775-1/V3.3/Part01/components/navigation.html#Billboard) node creates a group with a coordinate system that rotates to face the viewer
- The [Anchor](https://www.web3d.org/documents/specifications/19775-1/V3.3/Part01/components/networking.html#Anchor) node creates a clickable group
  - Clicking any child in the group loads a URL
- The [Inline](https://www.web3d.org/documents/specifications/19775-1/V3.3/Part01/components/networking.html#Inline) node creates a special group loaded from another X3D file
