# Tutorials

## Overview

We offer here a couple of introductory X3D tutorials on X3D concepts. It serves as background material for Titania and X\_ITE.

The only hardware and software requirement for most of the tutorials is a computer with the latest version of Titania or your favorite text editor and X\_ITE. Titania has extensive documentation. It is the perfect environment to get started in creating sensational X3D scenes.

## Let’s See What We Can Do…

Simple, fast and efficient, our X3D tutorials give you all the tips and tricks to advance in the construction of your project.

- [Hello, World](/x_ite/tutorials/Hello,-World!.html)
  - First let's go over to the »Hello World« tutorial, which displays a simple earth and the text »Hello World!«.
- [A Quick Overview: Basic Nodes](/x_ite/tutorials/Basic-Nodes.html)
  - Here are the basic nodes described, which are often used in an X3D world.

Shapes, Geometry, and Appearance

- [Introducing X3D](/x_ite/tutorials/Introducing-X3D.html)
- [Building a X3D World](/x_ite/tutorials/Building-a-X3D-world.html)
- [Building Primitive Shapes ](/x_ite/tutorials/Building-primitive-shapes.html)
- [Transforming Shapes](/x_ite/tutorials/Transforming-Shapes.html)
- [Controlling Appearance with Materials ](/x_ite/tutorials/Controlling-appearance-with-materials.html)
- [Grouping Nodes ](/x_ite/tutorials/Grouping-nodes.html)
- [Naming Nodes](/x_ite/tutorials/Naming-nodes.html)

Animation, Sensors, and Geometry

- [Introducing Animation](/x_ite/tutorials/Introducing-animation.html)
- [Animating Transforms](/x_ite/tutorials/Animating-transforms.html)
- [Sensing Viewer Actions](/x_ite/tutorials/Sensing-viewer-actions.html)
- [Building Ahapes out of Points, Lines, and Faces](/x_ite/tutorials/Building-shapes-out-of-points,-lines,-and-faces.html)
- [Building Elevation Grids](/x_ite/tutorials/Building-elevation-grids.html)
- [Building Extruded Shapes](/x_ite/tutorials/Building-extruded-shapes.html)
- [Controlling Color on Coordinate-Based Geometry](/x_ite/tutorials/Controlling-color-on-coordinate-based-geometry.html)
- [Controlling Shading on Coordinate-Based Geometry](/x_ite/tutorials/Controlling-shading-on-coordinate-based-geometry.html)

Textures, Lights, and Environment

- [Mapping Textures](/x_ite/tutorials/Mapping-textures.html)
- [Controlling How Textures are Mapped](/x_ite/tutorials/Controlling-how-textures-are-mapped.html)
- [Lighting Your World](/x_ite/tutorials/Lighting-your-world.html)
- [Adding Backgrounds](/x_ite/tutorials/Adding-backgrounds.html)
- [Adding Fog](/x_ite/tutorials/Adding-fog.html)
- [Adding Sound](/x_ite/tutorials/Adding-sound.html)
- [Controlling the Viewpoint](/x_ite/tutorials/Controlling-the-viewpoint.html)
- [Controlling Navigation](/x_ite/tutorials/Controlling-navigation.html)
- [Sensing the Viewer](/x_ite/tutorials/Sensing-the-viewer.html)

Scripts and Prototypes

- [Controlling Detail](/x_ite/tutorials/Controlling-detail.html)
- [Introducing Script Use](/x_ite/tutorials/Introducing-script-use.html)
- [Writing Program Scripts with ECMAScript](/x_ite/tutorials/Writing-program-scripts-with-ECMAScript.html)
- [Creating New Node Types](/x_ite/tutorials/Creating-new-node-types.html)
- [Providing Tnformation About Your wWorld](/x_ite/tutorials/Providing-information-about-your-world.html)

Some words about optimizing a scene

- [Improve Performance](/x_ite/tutorials/Improving-Performance.html)
  - To optimize a scene is an important task when creating an X3D scene. There are several ways to improve performance.
- [Increasing Rendering Speed](/x_ite/tutorials/Increasing-Rendering-Speed.html)
  - Using WebGL and JavaScript needs to look at speed all the time. Learn ways to increase rendering speed.

### See Also

- [Script Node Authoring Interface](/x_ite/reference/Script-Node-Authoring-Interface.html)
- [ECMAScript Object and Function Definitions](/x_ite/reference/ECMAScript-Object-and-Function-Definitions.html)
- [Custom Shaders](/x_ite/Custom-Shaders.html)

## There are also Books for Further Reading

[X3D: Extensible 3D Graphics for Web Authors](http://www.amazon.com/gp/product/012088500X?ie=UTF8&tag=x3dext3dgrafo-20&linkCode=as2&camp=1789&creative=9325&creativeASIN=012088500X) by Don Brutzman and Leonard Daly

## Don't Compromise on Development Experience

Use the full power of the modern X3D ecosystem – Titania’s got you covered! Enjoy the intelligent build system, powerful navigation and support for JavaScript, on-the-fly error detection, integrated Route Graph Editor, and X\_ITE compatibility.
