#define MANUAL_SRGB

vec4
SRGBtoLINEAR (const in vec4 srgbIn)
{
   #ifdef MANUAL_SRGB
      #ifdef SRGB_FAST_APPROXIMATION
         vec3 linOut = pow (srgbIn .xyz, vec3 (2.2));
      #else //SRGB_FAST_APPROXIMATION
         vec3 bLess  = step (vec3 (0.04045), srgbIn .xyz);
         vec3 linOut = mix (srgbIn .xyz / vec3 (12.92), pow ((srgbIn .xyz + vec3 (0.055)) / vec3 (1.055), vec3 (2.4)), bLess);
      #endif //SRGB_FAST_APPROXIMATION
      return vec4 (linOut, srgbIn .w);
   #else //MANUAL_SRGB
      return srgbIn;
   #endif //MANUAL_SRGB
}

vec4
Gamma (const in vec4 color)
{
   #ifdef MANUAL_SRGB
   return vec4 (pow (color .rgb, vec3 (1.0 / 2.2)), color .a);
   #else
   return color;
   #endif
}
