/* -*- Mode: JavaScript; coding: utf-8; tab-width: 3; indent-tabs-mode: tab; c-basic-offset: 3 -*-
 *******************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright create3000, Scheffelstraße 31a, Leipzig, Germany 2011.
 *
 * All rights reserved. Holger Seelig <holger.seelig@yahoo.de>.
 *
 * The copyright notice above does not evidence any actual of intended
 * publication of such source code, and is an unpublished work by create3000.
 * This material contains CONFIDENTIAL INFORMATION that is the property of
 * create3000.
 *
 * No permission is granted to copy, distribute, or create derivative works from
 * the contents of this software, in whole or in part, without the prior written
 * permission of create3000.
 *
 * NON-MILITARY USE ONLY
 *
 * All create3000 software are effectively free software with a non-military use
 * restriction. It is free. Well commented source is provided. You may reuse the
 * source in any way you please with the exception anything that uses it must be
 * marked to indicate is contains 'non-military use only' components.
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2015, 2016 Holger Seelig <holger.seelig@yahoo.de>.
 *
 * This file is part of the X_ITE Project.
 *
 * X_ITE is free software: you can redistribute it and/or modify it under the
 * terms of the GNU General Public License version 3 only, as published by the
 * Free Software Foundation.
 *
 * X_ITE is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License version 3 for more
 * details (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version 3
 * along with X_ITE.  If not, see <http://www.gnu.org/licenses/gpl.html> for a
 * copy of the GPLv3 License.
 *
 * For Silvio, Joy and Adi.
 *
 ******************************************************************************/


define ([
   "x_ite/Fields",
   "x_ite/Browser/Navigation/ExamineViewer",
   "x_ite/Browser/Navigation/WalkViewer",
   "x_ite/Browser/Navigation/FlyViewer",
   "x_ite/Browser/Navigation/PlaneViewer",
   "x_ite/Browser/Navigation/NoneViewer",
   "x_ite/Browser/Navigation/LookAtViewer",
   "x_ite/Components/Lighting/DirectionalLight",
   "standard/Math/Numbers/Matrix4",
],
function (Fields,
          ExamineViewer,
          WalkViewer,
          FlyViewer,
          PlaneViewer,
          NoneViewer,
          LookAtViewer,
          DirectionalLight,
          Matrix4)
{
"use strict";

   const
      _activeCollisions   = Symbol (),
      _viewerNode         = Symbol (),
      _headlightContainer = Symbol ();


   function getHeadLight (browser)
   {
      const headlight = new DirectionalLight (browser .getPrivateScene ());

      headlight .setup ();

      const headlightContainer = headlight .getLights () .pop ();

      headlightContainer .set (browser, headlight, null, Matrix4 .Identity);
      headlightContainer .dispose = Function .prototype;

      return headlightContainer;
   };

   function X3DNavigationContext ()
   {
      this .addChildObjects ("activeLayer",          new Fields .SFNode (),
                             "activeNavigationInfo", new Fields .SFNode (),
                             "activeViewpoint",      new Fields .SFNode (),
                             "availableViewers",     new Fields .MFString (),
                             "viewer",               new Fields .SFString ("EXAMINE"));

      this [_activeCollisions] = new Set ();
      this [_viewerNode]       = new NoneViewer (this);
   }

   X3DNavigationContext .prototype =
   {
      initialize: function ()
      {
         this ._viewer .addInterest ("set_viewer__", this);

         this .initialized () .addInterest ("set_world__",    this);
         this .shutdown ()    .addInterest ("remove_world__", this);

         this [_headlightContainer] = getHeadLight (this);
         this [_viewerNode] .setup ();
      },
      getHeadlight: function ()
      {
         return this [_headlightContainer];
      },
      getActiveLayer: function ()
      {
         return this ._activeLayer .getValue ();
      },
      getActiveNavigationInfo: function ()
      {
         return this ._activeNavigationInfo .getValue ();
      },
      getActiveViewpoint: function ()
      {
         return this ._activeViewpoint .getValue ();
      },
      getCurrentViewer: function ()
      {
         return this ._viewer .getValue ();
      },
      getViewer: function ()
      {
         return this [_viewerNode];
      },
      addCollision: function (object)
      {
         this [_activeCollisions] .add (object);
      },
      removeCollision: function (object)
      {
         this [_activeCollisions] .delete (object);
      },
      getCollisionCount: function ()
      {
         return this [_activeCollisions] .size;
      },
      remove_world__: function ()
      {
         this .getWorld () ._activeLayer .removeInterest ("set_activeLayer__", this);
      },
      set_world__: function ()
      {
         this .getWorld () ._activeLayer .addInterest ("set_activeLayer__", this);

         this .set_activeLayer__ ();
      },
      set_activeLayer__: function ()
      {
         if (this ._activeLayer .getValue ())
         {
            this ._activeLayer .getValue () .getNavigationInfoStack () .removeInterest ("set_activeNavigationInfo__", this);
            this ._activeLayer .getValue () .getViewpointStack ()      .removeInterest ("set_activeViewpoint__",      this);
         }

         this ._activeLayer = this .getWorld () .getActiveLayer ();

         if (this ._activeLayer .getValue ())
         {
            this ._activeLayer .getValue () .getNavigationInfoStack () .addInterest ("set_activeNavigationInfo__", this);
            this ._activeLayer .getValue () .getViewpointStack ()      .addInterest ("set_activeViewpoint__",      this);
         }

         this .set_activeNavigationInfo__ ();
         this .set_activeViewpoint__ ();
      },
      set_activeNavigationInfo__: function ()
      {
         if (this ._activeNavigationInfo .getValue ())
            this ._activeNavigationInfo .getValue () ._viewer .removeFieldInterest (this ._viewer);

         if (this ._activeLayer .getValue ())
         {
            this ._activeNavigationInfo = this ._activeLayer .getValue () .getNavigationInfo ();

            this ._activeNavigationInfo .getValue () ._viewer .addFieldInterest (this ._viewer);

            this ._viewer = this ._activeNavigationInfo .getValue () ._viewer;
         }
         else
         {
            this ._activeNavigationInfo = null;
            this ._viewer               = "NONE";
         }
      },
      set_activeViewpoint__: function ()
      {
         if (this ._activeLayer .getValue ())
            this ._activeViewpoint = this ._activeLayer .getValue () .getViewpoint ();
         else
            this ._activeViewpoint = null;
      },
      set_viewer__: function (viewer)
      {
         if (this ._activeNavigationInfo .getValue ())
            this ._availableViewers = this ._activeNavigationInfo .getValue () ._availableViewers;
         else
            this ._availableViewers .length = 0;

         // Create viewer node.

         if (this [_viewerNode])
            this [_viewerNode] .dispose ();

         switch (viewer .getValue ())
         {
            case "EXAMINE":
               this [_viewerNode] = new ExamineViewer (this);
               break;
            case "WALK":
               this [_viewerNode] = new WalkViewer (this);
               break;
            case "FLY":
               this [_viewerNode] = new FlyViewer (this);
               break;
            case "PLANE":
            case "PLANE_create3000.de":
               this [_viewerNode] = new PlaneViewer (this);
               break;
            case "NONE":
               this [_viewerNode] = new NoneViewer (this);
               break;
            case "LOOKAT":
               this [_viewerNode] = new LookAtViewer (this);
               break;
            default:
               this [_viewerNode] = new ExamineViewer (this);
               break;
         }

         this [_viewerNode] .setup ();
      },
   };

   return X3DNavigationContext;
});
