/* -*- Mode: JavaScript; coding: utf-8; tab-width: 3; indent-tabs-mode: tab; c-basic-offset: 3 -*-
 *******************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright create3000, Scheffelstraße 31a, Leipzig, Germany 2011.
 *
 * All rights reserved. Holger Seelig <holger.seelig@yahoo.de>.
 *
 * The copyright notice above does not evidence any actual of intended
 * publication of such source code, and is an unpublished work by create3000.
 * This material contains CONFIDENTIAL INFORMATION that is the property of
 * create3000.
 *
 * No permission is granted to copy, distribute, or create derivative works from
 * the contents of this software, in whole or in part, without the prior written
 * permission of create3000.
 *
 * NON-MILITARY USE ONLY
 *
 * All create3000 software are effectively free software with a non-military use
 * restriction. It is free. Well commented source is provided. You may reuse the
 * source in any way you please with the exception anything that uses it must be
 * marked to indicate is contains 'non-military use only' components.
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2015, 2016 Holger Seelig <holger.seelig@yahoo.de>.
 *
 * This file is part of the X_ITE Project.
 *
 * X_ITE is free software: you can redistribute it and/or modify it under the
 * terms of the GNU General Public License version 3 only, as published by the
 * Free Software Foundation.
 *
 * X_ITE is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License version 3 for more
 * details (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version 3
 * along with X_ITE.  If not, see <http://www.gnu.org/licenses/gpl.html> for a
 * copy of the GPLv3 License.
 *
 * For Silvio, Joy and Adi.
 *
 ******************************************************************************/


define ([
   "x_ite/Fields",
   "x_ite/Base/X3DFieldDefinition",
   "x_ite/Base/FieldDefinitionArray",
   "x_ite/Components/Rendering/X3DGeometryNode",
   "x_ite/Base/X3DCast",
   "x_ite/Base/X3DConstants",
   "standard/Math/Geometry/Triangle3",
   "standard/Math/Numbers/Vector2",
   "standard/Math/Numbers/Vector3",
],
function (Fields,
          X3DFieldDefinition,
          FieldDefinitionArray,
          X3DGeometryNode,
          X3DCast,
          X3DConstants,
          Triangle3,
          Vector2,
          Vector3)
{
"use strict";

   function ElevationGrid (executionContext)
   {
      X3DGeometryNode .call (this, executionContext);

      this .addType (X3DConstants .ElevationGrid);

      this ._xSpacing    .setUnit ("length");
      this ._zSpacing    .setUnit ("length");
      this ._creaseAngle .setUnit ("angle");
      this ._height      .setUnit ("length");

      this .fogCoordNode = null;
      this .colorNode    = null;
      this .texCoordNode = null;
      this .normalNode   = null;
      this .coordNode    = null;
   }

   ElevationGrid .prototype = Object .assign (Object .create (X3DGeometryNode .prototype),
   {
      constructor: ElevationGrid,
      [Symbol .for ("X_ITE.X3DBaseNode.fieldDefinitions")]: new FieldDefinitionArray ([
         new X3DFieldDefinition (X3DConstants .inputOutput,    "metadata",        new Fields .SFNode ()),
         new X3DFieldDefinition (X3DConstants .inputOnly,      "set_height",      new Fields .MFFloat ()),
         new X3DFieldDefinition (X3DConstants .initializeOnly, "xDimension",      new Fields .SFInt32 ()),
         new X3DFieldDefinition (X3DConstants .initializeOnly, "zDimension",      new Fields .SFInt32 ()),
         new X3DFieldDefinition (X3DConstants .initializeOnly, "xSpacing",        new Fields .SFFloat (1)),
         new X3DFieldDefinition (X3DConstants .initializeOnly, "zSpacing",        new Fields .SFFloat (1)),
         new X3DFieldDefinition (X3DConstants .initializeOnly, "solid",           new Fields .SFBool (true)),
         new X3DFieldDefinition (X3DConstants .initializeOnly, "ccw",             new Fields .SFBool (true)),
         new X3DFieldDefinition (X3DConstants .initializeOnly, "creaseAngle",     new Fields .SFFloat ()),
         new X3DFieldDefinition (X3DConstants .initializeOnly, "colorPerVertex",  new Fields .SFBool (true)),
         new X3DFieldDefinition (X3DConstants .initializeOnly, "normalPerVertex", new Fields .SFBool (true)),
         new X3DFieldDefinition (X3DConstants .inputOutput,    "attrib",          new Fields .MFNode ()),
         new X3DFieldDefinition (X3DConstants .inputOutput,    "fogCoord",        new Fields .SFNode ()),
         new X3DFieldDefinition (X3DConstants .inputOutput,    "color",           new Fields .SFNode ()),
         new X3DFieldDefinition (X3DConstants .inputOutput,    "texCoord",        new Fields .SFNode ()),
         new X3DFieldDefinition (X3DConstants .inputOutput,    "normal",          new Fields .SFNode ()),
         new X3DFieldDefinition (X3DConstants .initializeOnly, "height",          new Fields .MFFloat ()),
      ]),
      getTypeName: function ()
      {
         return "ElevationGrid";
      },
      getComponentName: function ()
      {
         return "Geometry3D";
      },
      getContainerField: function ()
      {
         return "geometry";
      },
      initialize: function ()
      {
         X3DGeometryNode .prototype .initialize .call (this);

         this ._set_height .addFieldInterest (this ._height);
         this ._attrib     .addInterest ("set_attrib__",   this);
         this ._fogCoord   .addInterest ("set_fogCoord__", this);
         this ._color      .addInterest ("set_color__",    this);
         this ._texCoord   .addInterest ("set_texCoord__", this);
         this ._normal     .addInterest ("set_normal__",   this);

         this .set_attrib__ ();
         this .set_fogCoord__ ();
         this .set_color__ ();
         this .set_texCoord__ ();
         this .set_normal__ ();
      },
      set_attrib__: function ()
      {
         const attribNodes = this .getAttrib ();

         for (const attribNode of attribNodes)
            attribNode .removeInterest ("requestRebuild", this);

         attribNodes .length = 0;

         for (const node of this ._attrib)
         {
            const attribNode = X3DCast (X3DConstants .X3DVertexAttributeNode, node);

            if (attribNode)
               attribNodes .push (attribNode);
         }

         for (const attribNode of attribNodes)
            attribNode .addInterest ("requestRebuild", this);
      },
      set_fogCoord__: function ()
      {
         if (this .fogCoordNode)
            this .fogCoordNode .removeInterest ("requestRebuild", this);

         this .fogCoordNode = X3DCast (X3DConstants .FogCoordinate, this ._fogCoord);

         if (this .fogCoordNode)
            this .fogCoordNode .addInterest ("requestRebuild", this);
      },
      set_color__: function ()
      {
         if (this .colorNode)
         {
            this .colorNode .removeInterest ("requestRebuild", this);
            this .colorNode ._transparent .removeInterest ("set_transparent__", this);
         }

         this .colorNode = X3DCast (X3DConstants .X3DColorNode, this ._color);

         if (this .colorNode)
         {
            this .colorNode .addInterest ("requestRebuild", this);
            this .colorNode ._transparent .addInterest ("set_transparent__", this);

            this .set_transparent__ ();
         }
         else
            this .setTransparent (false);
      },
      set_transparent__: function ()
      {
         this .setTransparent (this .colorNode .getTransparent ());
      },
      set_texCoord__: function ()
      {
         if (this .texCoordNode)
            this .texCoordNode .removeInterest ("requestRebuild", this);

         this .texCoordNode = X3DCast (X3DConstants .X3DTextureCoordinateNode, this ._texCoord);

         if (this .texCoordNode)
            this .texCoordNode .addInterest ("requestRebuild", this);

         this .setTextureCoordinate (this .texCoordNode);
      },
      set_normal__: function ()
      {
         if (this .normalNode)
            this .normalNode .removeInterest ("requestRebuild", this);

         this .normalNode = X3DCast (X3DConstants .X3DNormalNode, this ._normal);

         if (this .normalNode)
            this .normalNode .addInterest ("requestRebuild", this);
      },
      getColor: function ()
      {
         return this .colorNode;
      },
      getTexCoord: function ()
      {
         return this .texCoordNode;
      },
      getNormal: function ()
      {
         return this .normalNode;
      },
      getHeight: function (index)
      {
         if (index < this ._height .length)
            return this ._height [index];

         return 0;
      },
      createTexCoords: function ()
      {
         const
            texCoords  = [ ],
            xDimension = this ._xDimension .getValue (),
            zDimension = this ._zDimension .getValue (),
            xSize      = xDimension - 1,
            zSize      = zDimension - 1;

         for (let z = 0; z < zDimension; ++ z)
         {
            for (let x = 0; x < xDimension; ++ x)
               texCoords .push (new Vector2 (x / xSize, z / zSize));
         }

         return texCoords;
      },
      createNormals: function (points, coordIndex, creaseAngle)
      {
         const
            cw          = ! this ._ccw .getValue (),
            normalIndex = [ ],
            normals     = [ ];

         for (let p = 0, length = points .length; p < length; ++ p)
            normalIndex [p] = [ ];

         for (let c = 0, length = coordIndex .length; c < length; c += 3)
         {
            const
               c0 = coordIndex [c],
               c1 = coordIndex [c + 1],
               c2 = coordIndex [c + 2];

            normalIndex [c0] .push (normals .length);
            normalIndex [c1] .push (normals .length + 1);
            normalIndex [c2] .push (normals .length + 2);

            const normal = Triangle3 .normal (points [c0], points [c1], points [c2], new Vector3 (0, 0, 0));

            if (cw)
               normal .negate ();

            normals .push (normal);
            normals .push (normal);
            normals .push (normal);
         }

         return this .refineNormals (normalIndex, normals, this ._creaseAngle .getValue ());
      },
      createCoordIndex: function ()
      {
         // p1 - p4
         //  | \ |
         // p2 - p3

         const
            coordIndex = [ ],
            xDimension = this ._xDimension .getValue (),
            zDimension = this ._zDimension .getValue (),
            xSize      = xDimension - 1,
            zSize      = zDimension - 1;

         for (let z = 0; z < zSize; ++ z)
         {
            for (let x = 0; x < xSize; ++ x)
            {
               const
                  i1 =       z * xDimension + x,
                  i2 = (z + 1) * xDimension + x,
                  i3 = (z + 1) * xDimension + (x + 1),
                  i4 =       z * xDimension + (x + 1);

               coordIndex .push (i1); // p1
               coordIndex .push (i2); // p2
               coordIndex .push (i3); // p3

               coordIndex .push (i1); // p1
               coordIndex .push (i3); // p3
               coordIndex .push (i4); // p4
            }
         }

         return coordIndex;
      },
      createPoints: function ()
      {
         const
            points     = [ ],
            xDimension = this ._xDimension .getValue (),
            zDimension = this ._zDimension .getValue (),
            xSpacing   = this ._xSpacing .getValue (),
            zSpacing   = this ._zSpacing .getValue ();

         for (let z = 0; z < zDimension; ++ z)
         {
            for (let x = 0; x < xDimension; ++ x)
            {
               points .push (new Vector3 (xSpacing * x,
                                          this .getHeight (x + z * xDimension),
                                          zSpacing * z));
            }
         }

         return points;
      },
      build: function ()
      {
         if (this ._xDimension .getValue () < 2 || this ._zDimension .getValue () < 2)
            return;

         const
            colorPerVertex     = this ._colorPerVertex .getValue (),
            normalPerVertex    = this ._normalPerVertex .getValue (),
            coordIndex         = this .createCoordIndex (),
            attribNodes        = this .getAttrib (),
            numAttrib          = attribNodes .length,
            attribs            = this .getAttribs (),
            fogCoordNode       = this .fogCoordNode,
            colorNode          = this .getColor (),
            texCoordNode       = this .getTexCoord (),
            normalNode         = this .getNormal (),
            points             = this .createPoints (),
            fogDepthArray      = this .getFogDepths (),
            colorArray         = this .getColors (),
            multiTexCoordArray = this .getMultiTexCoords (),
            normalArray        = this .getNormals (),
            vertexArray        = this .getVertices ();

         let face = 0;

         if (texCoordNode)
         {
            texCoordNode .init (multiTexCoordArray);
         }
         else
         {
            var
               texCoords     = this .createTexCoords (),
               texCoordArray = this .getTexCoords ();

            multiTexCoordArray .push (texCoordArray);
         }

         // Build geometry

         for (let c = 0, numCoordIndices = coordIndex .length; c < numCoordIndices; ++ face)
         {
            for (let p = 0; p < 6; ++ p, ++ c)
            {
               const
                  index = coordIndex [c],
                  point = points [index];

               for (let a = 0; a < numAttrib; ++ a)
                  attribNodes [a] .addValue (index, attribs [a]);

               if (fogCoordNode)
                  fogCoordNode .addDepth (index, fogDepthArray);

               if (colorNode)
               {
                  if (colorPerVertex)
                     colorNode .addColor (index, colorArray);
                  else
                     colorNode .addColor (face, colorArray);
               }

               if (texCoordNode)
               {
                  texCoordNode .addTexCoord (index, multiTexCoordArray);
               }
               else
               {
                  const t = texCoords [index];

                  texCoordArray .push (t .x, t .y, 0, 1);
               }

               if (normalNode)
               {
                  if (normalPerVertex)
                     normalNode .addVector (index, normalArray);

                  else
                     normalNode .addVector (face, normalArray);
               }

               vertexArray .push (point .x, point .y, point .z, 1);
            }
         }

         // Add auto-generated normals if needed.

         if (!normalNode)
         {
            const normals = this .createNormals (points, coordIndex);

            for (const normal of normals)
            {
               normalArray .push (normal .x, normal .y, normal .z);
            }
         }

         this .setSolid (this ._solid .getValue ());
         this .setCCW (this ._ccw .getValue ());
      },
   });

   return ElevationGrid;
});
