/* -*- Mode: JavaScript; coding: utf-8; tab-width: 3; indent-tabs-mode: tab; c-basic-offset: 3 -*-
 *******************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright create3000, Scheffelstraße 31a, Leipzig, Germany 2011.
 *
 * All rights reserved. Holger Seelig <holger.seelig@yahoo.de>.
 *
 * The copyright notice above does not evidence any actual of intended
 * publication of such source code, and is an unpublished work by create3000.
 * This material contains CONFIDENTIAL INFORMATION that is the property of
 * create3000.
 *
 * No permission is granted to copy, distribute, or create derivative works from
 * the contents of this software, in whole or in part, without the prior written
 * permission of create3000.
 *
 * NON-MILITARY USE ONLY
 *
 * All create3000 software are effectively free software with a non-military use
 * restriction. It is free. Well commented source is provided. You may reuse the
 * source in any way you please with the exception anything that uses it must be
 * marked to indicate is contains 'non-military use only' components.
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2015, 2016 Holger Seelig <holger.seelig@yahoo.de>.
 *
 * This file is part of the X_ITE Project.
 *
 * X_ITE is free software: you can redistribute it and/or modify it under the
 * terms of the GNU General Public License version 3 only, as published by the
 * Free Software Foundation.
 *
 * X_ITE is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License version 3 for more
 * details (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version 3
 * along with X_ITE.  If not, see <http://www.gnu.org/licenses/gpl.html> for a
 * copy of the GPLv3 License.
 *
 * For Silvio, Joy and Adi.
 *
 ******************************************************************************/


define ([
   "jquery",
   "x_ite/Fields",
   "x_ite/Base/X3DFieldDefinition",
   "x_ite/Base/FieldDefinitionArray",
   "x_ite/Components/Texturing/X3DTexture2DNode",
   "x_ite/Components/Networking/X3DUrlObject",
   "x_ite/Base/X3DConstants",
   "standard/Math/Algorithm",
   "x_ite/DEBUG",
],
function ($,
          Fields,
          X3DFieldDefinition,
          FieldDefinitionArray,
          X3DTexture2DNode,
          X3DUrlObject,
          X3DConstants,
          Algorithm,
          DEBUG)
{
"use strict";

   function ImageTexture (executionContext)
   {
      X3DTexture2DNode .call (this, executionContext);
      X3DUrlObject     .call (this, executionContext);

      this .addType (X3DConstants .ImageTexture);

      this .urlStack = new Fields .MFString ();
   }

   ImageTexture .prototype = Object .assign (Object .create (X3DTexture2DNode .prototype),
      X3DUrlObject .prototype,
   {
      constructor: ImageTexture,
      [Symbol .for ("X_ITE.X3DBaseNode.fieldDefinitions")]: new FieldDefinitionArray ([
         new X3DFieldDefinition (X3DConstants .inputOutput,    "metadata",             new Fields .SFNode ()),
         new X3DFieldDefinition (X3DConstants .inputOutput,    "description",          new Fields .SFString ()),
         new X3DFieldDefinition (X3DConstants .inputOutput,    "load",                 new Fields .SFBool (true)),
         new X3DFieldDefinition (X3DConstants .inputOutput,    "url",                  new Fields .MFString ()),
         new X3DFieldDefinition (X3DConstants .inputOutput,    "autoRefresh",          new Fields .SFTime ()),
         new X3DFieldDefinition (X3DConstants .inputOutput,    "autoRefreshTimeLimit", new Fields .SFTime (3600)),
         new X3DFieldDefinition (X3DConstants .initializeOnly, "repeatS",              new Fields .SFBool (true)),
         new X3DFieldDefinition (X3DConstants .initializeOnly, "repeatT",              new Fields .SFBool (true)),
         new X3DFieldDefinition (X3DConstants .initializeOnly, "textureProperties",    new Fields .SFNode ()),
      ]),
      getTypeName: function ()
      {
         return "ImageTexture";
      },
      getComponentName: function ()
      {
         return "Texturing";
      },
      getContainerField: function ()
      {
         return "texture";
      },
      initialize: function ()
      {
         X3DTexture2DNode .prototype .initialize .call (this);
         X3DUrlObject     .prototype .initialize .call (this);

         this .canvas = $("<canvas></canvas>");

         this .image = $("<img></img>");
         this .image .on ("load", this .setImage .bind (this));
         this .image .on ("error", this .setError .bind (this));
         this .image .bind ("abort", this .setError .bind (this));

         this .image [0] .crossOrigin = "Anonymous";

         this .requestImmediateLoad ();
      },
      unloadNow: function ()
      {
         this .clearTexture ();
      },
      loadNow: function ()
      {
         this .urlStack .setValue (this ._url);
         this .loadNext ();
      },
      loadNext: function ()
      {
         if (this .urlStack .length === 0)
         {
            this .clearTexture ();
            this .setLoadState (X3DConstants .FAILED_STATE);
            return;
         }

         // Get URL.

         this .URL = new URL (this .urlStack .shift (), this .getExecutionContext () .getWorldURL ());

         if (this .URL .protocol !== "data:")
         {
            if (!this .getBrowser () .getBrowserOptions () .getCache () || !this .getCache ())
               this .URL .searchParams .set ("_", Date .now ());
         }

         this .image .attr ("src", this .URL .href);
      },
      setError: function ()
      {
         if (this .URL .protocol !== "data:")
            console .warn ("Error loading image:", decodeURI (this .URL .href));

         this .loadNext ();
      },
      setImage: function ()
      {
         if (DEBUG)
         {
             if (this .URL .protocol !== "data:")
               console .info ("Done loading image:", decodeURI (this .URL .href));
         }

         try
         {
            const
               gl     = this .getBrowser () .getContext (),
               image  = this .image [0],
               canvas = this .canvas [0],
               cx     = canvas .getContext ("2d");

            let
               width  = image .width,
               height = image .height;

            // Scale image if needed and flip vertically.

            if (gl .getVersion () >= 2 || (Algorithm .isPowerOfTwo (width) && Algorithm .isPowerOfTwo (height)))
            {
               // Flip Y

               canvas .width  = width;
               canvas .height = height;

               cx .clearRect (0, 0, width, height);
               cx .save ();
               cx .translate (0, height);
               cx .scale (1, -1);
               cx .drawImage (image, 0, 0);
               cx .restore ();
            }
            else
            {
               // Flip Y and scale image to next power of two.

               width  = Algorithm .nextPowerOfTwo (width);
               height = Algorithm .nextPowerOfTwo (height);

               canvas .width  = width;
               canvas .height = height;

               cx .clearRect (0, 0, width, height);
               cx .save ();
               cx .translate (0, height);
               cx .scale (1, -1);
               cx .drawImage (image, 0, 0, image .width, image .height, 0, 0, width, height);
               cx .restore ();
            }

            // Determine image alpha.

            const data = cx .getImageData (0, 0, width, height) .data;

            let transparent = false;

            for (let i = 3, length = data .length; i < length; i += 4)
            {
               if (data [i] !== 255)
               {
                  transparent = true;
                  break;
               }
            }

            this .setTexture (width, height, transparent, new Uint8Array (data .buffer), false);
            this .setLoadState (X3DConstants .COMPLETE_STATE);
         }
         catch (error)
         {
            // Catch security error from cross origin requests.
            console .log (error .message);
            this .setError ();
         }
      },
   });

   return ImageTexture;
});
