/* -*- Mode: JavaScript; coding: utf-8; tab-width: 3; indent-tabs-mode: tab; c-basic-offset: 3 -*-
 *******************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright create3000, Scheffelstraße 31a, Leipzig, Germany 2011.
 *
 * All rights reserved. Holger Seelig <holger.seelig@yahoo.de>.
 *
 * The copyright notice above does not evidence any actual of intended
 * publication of such source code, and is an unpublished work by create3000.
 * This material contains CONFIDENTIAL INFORMATION that is the property of
 * create3000.
 *
 * No permission is granted to copy, distribute, or create derivative works from
 * the contents of this software, in whole or in part, without the prior written
 * permission of create3000.
 *
 * NON-MILITARY USE ONLY
 *
 * All create3000 software are effectively free software with a non-military use
 * restriction. It is free. Well commented source is provided. You may reuse the
 * source in any way you please with the exception anything that uses it must be
 * marked to indicate is contains 'non-military use only' components.
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Copyright 2015, 2016 Holger Seelig <holger.seelig@yahoo.de>.
 *
 * This file is part of the X_ITE Project.
 *
 * X_ITE is free software: you can redistribute it and/or modify it under the
 * terms of the GNU General Public License version 3 only, as published by the
 * Free Software Foundation.
 *
 * X_ITE is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License version 3 for more
 * details (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version 3
 * along with X_ITE.  If not, see <http://www.gnu.org/licenses/gpl.html> for a
 * copy of the GPLv3 License.
 *
 * For Silvio, Joy and Adi.
 *
 ******************************************************************************/


 define ([
   "x_ite/Components/Texturing/X3DTextureCoordinateNode",
   "x_ite/Components/Rendering/X3DGeometryNode",
   "x_ite/Base/X3DConstants",
],
function (X3DTextureCoordinateNode,
          X3DGeometryNode,
          X3DConstants)
{
"use strict";

   function X3DSingleTextureCoordinateNode (executionContext)
   {
      X3DTextureCoordinateNode .call (this, executionContext);

      this .addType (X3DConstants .X3DSingleTextureCoordinateNode);

      this .texCoordArray = X3DGeometryNode .createArray ();
   }

   X3DSingleTextureCoordinateNode .prototype = Object .assign (Object .create (X3DTextureCoordinateNode .prototype),
   {
      constructor: X3DSingleTextureCoordinateNode,
      init: function (multiArray)
      {
         this .texCoordArray .length = 0;

         multiArray .push (this .texCoordArray);
      },
      addTexCoord: function (index, multiArray)
      {
         this .addTexCoordToChannel (index, multiArray [0]);
      },
      getTextureMapping: function (textureCoordinateMapping, channel = 0)
      {
         if (this ._mapping .getValue ())
            textureCoordinateMapping .set (this ._mapping .getValue (), channel);
      },
      setShaderUniforms: function (gl, shaderObject)
      {
         for (let i = 0, length = shaderObject .x3d_MaxTextures; i < length; ++ i)
            this .setShaderUniformsToChannel (gl, shaderObject, i);
      },
   });

   return X3DSingleTextureCoordinateNode;
});
