/* -*- Mode: JavaScript; coding: utf-8; tab-width: 3; indent-tabs-mode: tab; c-basic-offset: 3 -*-
 *******************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This file is part of the X_ITE Project.
 *
 * NON-MILITARY USE ONLY
 *
 * All create3000 software are effectively free software with a non-military use
 * restriction. It is free. Well commented source is provided. You may reuse the
 * source in any way you please with the exception anything that uses it must be
 * marked to indicate is contains "non-military use only" components.
 *
 * Copyright 2016 Andreas Plesch.
 *
 * X_ITE is free software: you can redistribute it and/or modify it under the
 * terms of the GNU General Public License version 3 only, as published by the
 * Free Software Foundation.
 *
 * X_ITE is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License version 3 for more
 * details (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version 3
 * along with X_ITE.  If not, see <http://www.gnu.org/licenses/gpl.html> for a
 * copy of the GPLv3 License.
 *
 * For Silvio, Joy and Adi.
 *
 ******************************************************************************/


define (function ()
{
"use strict";

   // Maps are set when component is registered.

   const
      nodeTypeNames = new Map (), // (TYPENAME -> TypeName)
      fieldNames    = new Map (); // (fieldname -> fieldName)

   const HTMLSupport =
   {
      addNodeTypeName: function (typeName)
      {
         nodeTypeNames .set (typeName,                 typeName);
         nodeTypeNames .set (typeName .toUpperCase (), typeName);
      },
      getNodeTypeName: function (typeName)
      {
         return nodeTypeNames .get (typeName);
      },
      addFieldName: function (name)
      {
         fieldNames .set (name,                 name);
         fieldNames .set (name .toLowerCase (), name);
      },
      getFieldName: function (name)
      {
         return fieldNames .get (name);
      },
   };

   return HTMLSupport;
});
