"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.authenticate = exports.preAuth = exports.refreshAccessToken = exports.exchangeCodeForAccessToken = exports.getAuthorizeUrl = void 0;
const axios_1 = __importDefault(require("axios"));
const querystring_1 = require("querystring");
const utils_1 = require("../../utils");
const XRError_1 = __importDefault(require("../../classes/XRError"));
const config_1 = __importDefault(require("../../config"));
const config_2 = __importStar(require("./config"));
const getMatchForIndex = (entry, regex, index = 0) => {
    const match = entry.match(regex);
    return (match === null || match === void 0 ? void 0 : match[index]) || void 0;
};
const getAuthorizeUrl = (clientId = config_2.defaultClientId, scope = config_2.defaultScope, responseType = config_2.defaultResponseType, redirectUri = config_2.defaultRedirectUri) => `${config_2.default.urls.authorize}?${querystring_1.stringify({
    client_id: clientId,
    redirect_uri: redirectUri,
    response_type: responseType,
    scope: scope
})}`;
exports.getAuthorizeUrl = getAuthorizeUrl;
const exchangeCodeForAccessToken = (code, clientId, scope, redirectUri, clientSecret) => __awaiter(void 0, void 0, void 0, function* () {
    const payload = {
        code,
        client_id: clientId,
        grant_type: 'authorization_code',
        redirect_uri: redirectUri,
        scope
    };
    if (clientSecret !== void 0) {
        payload.client_secret = clientSecret;
    }
    const response = yield axios_1.default({
        url: config_2.default.urls.token,
        method: 'POST',
        headers: utils_1.getBaseHeaders({
            Accept: 'application/json',
            'Content-Type': 'application/x-www-form-urlencoded'
        }),
        data: querystring_1.stringify(payload)
    })
        .then(res => res.data)
        .catch((err) => {
        var _a, _b;
        throw new XRError_1.default(err.message, {
            statusCode: (_a = err.response) === null || _a === void 0 ? void 0 : _a.status,
            additional: ((_b = err.response) === null || _b === void 0 ? void 0 : _b.data) || null
        });
    });
    return response;
});
exports.exchangeCodeForAccessToken = exchangeCodeForAccessToken;
const refreshAccessToken = (refreshToken, clientId = config_2.defaultClientId, scope = config_2.defaultScope, clientSecret) => __awaiter(void 0, void 0, void 0, function* () {
    const payload = {
        client_id: clientId,
        scope: scope || config_2.defaultScope,
        grant_type: 'refresh_token',
        refresh_token: refreshToken
    };
    if (clientSecret !== void 0) {
        payload.client_secret = clientSecret;
    }
    const response = yield axios_1.default({
        url: config_2.default.urls.token,
        method: 'POST',
        headers: utils_1.getBaseHeaders({
            Accept: 'application/json',
            'Content-Type': 'application/x-www-form-urlencoded'
        }),
        data: querystring_1.stringify(payload)
    })
        .then(res => res.data)
        .catch((err) => {
        var _a, _b;
        throw new XRError_1.default(err.message, {
            statusCode: (_a = err.response) === null || _a === void 0 ? void 0 : _a.status,
            additional: ((_b = err.response) === null || _b === void 0 ? void 0 : _b.data) || null
        });
    });
    return response;
});
exports.refreshAccessToken = refreshAccessToken;
const preAuth = (options) => __awaiter(void 0, void 0, void 0, function* () {
    const response = yield axios_1.default({
        url: exports.getAuthorizeUrl(options === null || options === void 0 ? void 0 : options.clientId, options === null || options === void 0 ? void 0 : options.scope, options === null || options === void 0 ? void 0 : options.responseType, options === null || options === void 0 ? void 0 : options.redirectUri),
        method: 'GET',
        headers: utils_1.getBaseHeaders({
            'Accept-Encoding': 'identity'
        })
    })
        .then(res => {
        const body = (res.data || '');
        const cookie = (res.headers['set-cookie'] || [])
            .map((c) => c.split(';')[0])
            .join('; ');
        const matches = {
            PPFT: getMatchForIndex(body, /sFTTag:'.*value=\"(.*)\"\/>'/, 1),
            urlPost: getMatchForIndex(body, /urlPost:'(.+?(?=\'))/, 1)
        };
        if (matches.PPFT !== void 0 && matches.urlPost !== void 0) {
            return {
                cookie,
                matches: matches
            };
        }
        throw XRError_1.default.internal(`Could not match required "preAuth" parameters, please fill an issue on ${config_1.default.github.createIssue}`);
    })
        .catch(err => {
        if (err.__XboxReplay__ === true)
            throw err;
        throw XRError_1.default.internal(err.message);
    });
    return response;
});
exports.preAuth = preAuth;
const authenticate = (credentials) => __awaiter(void 0, void 0, void 0, function* () {
    const preAuthResponse = yield exports.preAuth();
    const response = yield axios_1.default({
        url: preAuthResponse.matches.urlPost,
        method: 'POST',
        headers: utils_1.getBaseHeaders({
            'Content-Type': 'application/x-www-form-urlencoded',
            Cookie: preAuthResponse.cookie
        }),
        data: querystring_1.stringify({
            login: credentials.email,
            loginfmt: credentials.email,
            passwd: credentials.password,
            PPFT: preAuthResponse.matches.PPFT
        }),
        maxRedirects: 0,
        validateStatus: status => status === 302 || status === 200
    })
        .then(res => {
        if (res.status === 200) {
            throw XRError_1.default.unauthorized(`Invalid credentials or 2FA enabled`);
        }
        const { location = '' } = res.headers || {};
        const hash = location.split('#')[1];
        const output = {};
        for (const part of new URLSearchParams(hash)) {
            if (part[0] === 'expires_in') {
                output[part[0]] = Number(part[1]);
            }
            else
                output[part[0]] = part[1];
        }
        return output;
    })
        .catch(err => {
        if (err.__XboxReplay__ === true)
            throw err;
        throw XRError_1.default.internal(err.message);
    });
    return response;
});
exports.authenticate = authenticate;
