"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EXPERIMENTAL_createDummyWin32DeviceToken = exports.exchangeTokenForXSTSToken = exports.exchangeTokensForXSTSToken = exports.exchangeRpsTicketForUserToken = void 0;
const axios_1 = __importDefault(require("axios"));
const config_1 = __importStar(require("./config"));
const utils_1 = require("../../utils");
const XRError_1 = __importDefault(require("../../classes/XRError"));
const config_2 = __importDefault(require("../../config"));
const XBLContractVersion = 0;
const XBLAdditionalHeaders = {
    Accept: 'application/json',
    'X-Xbl-Contract-Version': String(XBLContractVersion)
};
const exchangeRpsTicketForUserToken = (rpsTicket, preamble = 't', additionalHeaders = {}) => __awaiter(void 0, void 0, void 0, function* () {
    const match = rpsTicket.match(/^([t|d]=)/g);
    if (match === null) {
        rpsTicket = `${preamble}=${rpsTicket}`;
    }
    const response = yield axios_1.default({
        url: config_1.default.urls.userAuthenticate,
        method: 'POST',
        headers: utils_1.getBaseHeaders(Object.assign(Object.assign({}, XBLAdditionalHeaders), additionalHeaders)),
        data: {
            RelyingParty: 'http://auth.xboxlive.com',
            TokenType: 'JWT',
            Properties: {
                AuthMethod: 'RPS',
                SiteName: 'user.auth.xboxlive.com',
                RpsTicket: rpsTicket
            }
        }
    })
        .then(res => res.data)
        .catch(_ => {
        throw XRError_1.default.badRequest('Could not exchange specified "RpsTicket"');
    });
    return response;
});
exports.exchangeRpsTicketForUserToken = exchangeRpsTicketForUserToken;
const exchangeTokensForXSTSToken = (tokens, options = {}, additionalHeaders = {}) => __awaiter(void 0, void 0, void 0, function* () {
    const response = yield axios_1.default({
        url: config_1.default.urls.XSTSAuthorize,
        method: 'POST',
        headers: utils_1.getBaseHeaders(Object.assign(Object.assign({}, XBLAdditionalHeaders), additionalHeaders)),
        data: {
            RelyingParty: options.XSTSRelyingParty || config_1.defaultXSTSRelyingParty,
            TokenType: 'JWT',
            Properties: {
                UserTokens: tokens.userTokens,
                DeviceToken: tokens.deviceToken,
                TitleToken: tokens.titleToken,
                OptionalDisplayClaims: options.optionalDisplayClaims,
                SandboxId: options.sandboxId || 'RETAIL'
            }
        }
    })
        .then(res => res.data)
        .catch((err) => {
        var _a;
        throw new XRError_1.default('Could not exchange specified tokens, please double check used parameters or make sure to use the "EXPERIMENTAL_createDummyWin32DeviceToken" method to handle "Child" and "Teen" accounts', { statusCode: (_a = err.response) === null || _a === void 0 ? void 0 : _a.status });
    });
    return response;
});
exports.exchangeTokensForXSTSToken = exchangeTokensForXSTSToken;
const exchangeTokenForXSTSToken = (userToken, options = {}, additionalHeaders = {}) => exports.exchangeTokensForXSTSToken({ userTokens: [userToken] }, options, additionalHeaders);
exports.exchangeTokenForXSTSToken = exchangeTokenForXSTSToken;
const EXPERIMENTAL_createDummyWin32DeviceToken = () => __awaiter(void 0, void 0, void 0, function* () {
    const trustedParty = 'https://xboxreplay.net/';
    const serviceDeviceId = '21354D2F-352F-472F-5842-5265706C6179';
    const serviceSignature = 'AAAAAQHW6oD31MwA6MAjn67vdCppWCbrMovubA85xejO06rtOAEdZ0tMTZFnu7xbI6lZDNvIWfuMaIPJSUcpvxjKqSFJl1oaWzQGBw==';
    const serviceProofKey = {
        crv: 'P-256',
        alg: 'ES256',
        use: 'sig',
        kty: 'EC',
        x: 'b8Zc6GPFeu41DqiWPJxRa_jqUTSiMA537emKVHt8UO8',
        y: 'CXAuTEHet72GjgSDfDg6psBrwE1waxBsNEIGrRZV_90'
    };
    const response = yield axios_1.default({
        url: config_1.default.urls.deviceAuthenticate,
        method: 'POST',
        headers: utils_1.getBaseHeaders(Object.assign(Object.assign({}, XBLAdditionalHeaders), { Signature: serviceSignature })),
        data: {
            RelyingParty: 'http://auth.xboxlive.com',
            TokenType: 'JWT',
            Properties: {
                AuthMethod: 'ProofOfPossession',
                TrustedParty: trustedParty,
                Id: `{${serviceDeviceId}}`,
                DeviceType: 'Win32',
                Version: '10.0.18363',
                ProofKey: serviceProofKey
            }
        }
    })
        .then(res => res.data)
        .catch(_ => {
        throw XRError_1.default.badRequest(`Could not create a valid device token, please fill an issue on ${config_2.default.github.createIssue}`);
    });
    return response;
});
exports.EXPERIMENTAL_createDummyWin32DeviceToken = EXPERIMENTAL_createDummyWin32DeviceToken;
