export declare type LiveCredentials = {
    email: string;
    password: string;
};
export declare type LiveAuthResponse = {
    token_type: 'bearer';
    expires_in: number;
    access_token: string;
    refresh_token?: string;
    scope: string;
    user_id: string;
};
export declare type LivePreAuthMatchedParameters = {
    PPFT: string;
    urlPost: string;
};
export declare type LivePreAuthResponse = {
    cookie: string;
    matches: LivePreAuthMatchedParameters;
};
export declare type LivePreAuthOptions = {
    clientId?: string;
    scope?: string;
    responseType?: 'token' | 'code';
    redirectUri?: string;
};
export declare type XBLExchangeRpsTicketResponse = {
    IssueInstant: string;
    NotAfter: string;
    Token: string;
    DisplayClaims: {
        xui: Array<{
            uhs: string;
        }>;
    };
};
export declare type XBLExchangeTokensOptions = {
    XSTSRelyingParty?: string;
    optionalDisplayClaims?: string[];
    sandboxId?: string;
};
export declare type XBLExchangeTokensResponse = {
    IssueInstant: string;
    NotAfter: string;
    Token: string;
    DisplayClaims: {
        xui: Array<Record<string, string> & {
            xid?: string;
            uhs: string;
        }>;
    };
};
export declare type XBLDummyDeviceTokenResponse = {
    IssueInstant: string;
    NotAfter: string;
    Token: string;
    DisplayClaims: {
        xdi: {
            did: 'F50CDD8781FF4476';
            dcs: string;
        };
    };
};
export declare type XBLTokens = {
    userTokens: string[];
    deviceToken?: string;
    titleToken?: string;
};
export declare type AuthenticateOptions = XBLExchangeTokensOptions & {
    deviceToken?: string;
    titleToken?: string;
    raw?: boolean;
};
export declare type AuthenticateRefreshOptions = {
    clientId?: string;
    clientSecret?: string;
    scope?: string;
    preamble?: 't' | 'd';
};
export declare type CredentialsAuthenticateInitialResponse = {
    xuid: string | null;
    user_hash: string;
    xsts_token: string;
    display_claims: Record<string, string>;
    expires_on: string;
};
export declare type CredentialsAuthenticateRawResponse = {
    'login.live.com': LiveAuthResponse;
    'user.auth.xboxlive.com': XBLExchangeRpsTicketResponse;
    'xsts.auth.xboxlive.com': XBLExchangeTokensResponse;
};
export declare type CredentialsAuthenticateResponse = CredentialsAuthenticateInitialResponse | CredentialsAuthenticateRawResponse;
export declare const authenticateWithUserCredentials: (email: string, password: string, options?: AuthenticateOptions) => Promise<CredentialsAuthenticateResponse>;
export declare const authenticateWithUserRefreshToken: (refreshToken: string, refreshOptions?: AuthenticateRefreshOptions | null, options?: AuthenticateOptions) => Promise<CredentialsAuthenticateResponse>;
export declare const authenticate: (email: string, password: string, options?: AuthenticateOptions) => Promise<CredentialsAuthenticateResponse>;
export declare const live: {
    preAuth: (options?: LivePreAuthOptions | undefined) => Promise<LivePreAuthResponse>;
    getAuthorizeUrl: (clientId?: string, scope?: string, responseType?: "code" | "token", redirectUri?: string) => string;
    authenticate: (credentials: LiveCredentials) => Promise<LiveAuthResponse>;
    refreshAccessToken: (refreshToken: string, clientId?: string, scope?: string, clientSecret?: string | undefined) => Promise<LiveAuthResponse>;
    exchangeCodeForAccessToken: (code: string, clientId: string, scope: string, redirectUri: string, clientSecret?: string | undefined) => Promise<LiveAuthResponse>;
};
export declare const xbl: {
    EXPERIMENTAL_createDummyWin32DeviceToken: () => Promise<XBLDummyDeviceTokenResponse>;
    exchangeRpsTicketForUserToken: (rpsTicket: string, preamble?: "d" | "t", additionalHeaders?: Record<string, string>) => Promise<XBLExchangeRpsTicketResponse>;
    exchangeTokensForXSTSToken: (tokens: XBLTokens, options?: XBLExchangeTokensOptions, additionalHeaders?: Record<string, string>) => Promise<XBLExchangeTokensResponse>;
    exchangeTokenForXSTSToken: (userToken: string, options?: XBLExchangeTokensOptions, additionalHeaders?: Record<string, string>) => Promise<XBLExchangeTokensResponse>;
};
