"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.xbl = exports.live = exports.authenticate = exports.authenticateWithUserRefreshToken = exports.authenticateWithUserCredentials = void 0;
const live_1 = require("./core/live");
const xboxlive_1 = require("./core/xboxlive");
const postLiveAuthenticate = (liveAuthResponse, preamble = 't', options = {}) => __awaiter(void 0, void 0, void 0, function* () {
    const userTokenResponse = yield xboxlive_1.exchangeRpsTicketForUserToken(liveAuthResponse.access_token, preamble);
    const XSTSResponse = yield xboxlive_1.exchangeTokensForXSTSToken({
        userTokens: [userTokenResponse.Token],
        deviceToken: options.deviceToken,
        titleToken: options.titleToken
    }, {
        XSTSRelyingParty: options.XSTSRelyingParty,
        optionalDisplayClaims: options.optionalDisplayClaims,
        sandboxId: options.sandboxId
    });
    if (options.raw !== true) {
        return {
            xuid: XSTSResponse.DisplayClaims.xui[0].xid || null,
            user_hash: XSTSResponse.DisplayClaims.xui[0].uhs,
            xsts_token: XSTSResponse.Token,
            display_claims: XSTSResponse.DisplayClaims.xui[0],
            expires_on: XSTSResponse.NotAfter
        };
    }
    return {
        'login.live.com': liveAuthResponse,
        'user.auth.xboxlive.com': userTokenResponse,
        'xsts.auth.xboxlive.com': XSTSResponse
    };
});
const authenticateWithUserCredentials = (email, password, options = {}) => __awaiter(void 0, void 0, void 0, function* () {
    const credentials = { email, password };
    const liveAuthResponse = yield live_1.authenticate(credentials);
    return postLiveAuthenticate(liveAuthResponse, 't', options);
});
exports.authenticateWithUserCredentials = authenticateWithUserCredentials;
exports.authenticateWithUserRefreshToken = (() => {
    let __rt;
    return (refreshToken, refreshOptions = null, options = {}) => __awaiter(void 0, void 0, void 0, function* () {
        const liveAuthResponse = yield exports.live.refreshAccessToken(__rt || refreshToken, refreshOptions === null || refreshOptions === void 0 ? void 0 : refreshOptions.clientId, refreshOptions === null || refreshOptions === void 0 ? void 0 : refreshOptions.scope, refreshOptions === null || refreshOptions === void 0 ? void 0 : refreshOptions.clientSecret);
        __rt = liveAuthResponse.refresh_token || refreshToken;
        return postLiveAuthenticate(liveAuthResponse, refreshOptions === null || refreshOptions === void 0 ? void 0 : refreshOptions.preamble, options);
    });
})();
exports.authenticate = exports.authenticateWithUserCredentials;
exports.live = {
    preAuth: live_1.preAuth,
    getAuthorizeUrl: live_1.getAuthorizeUrl,
    authenticate: live_1.authenticate,
    refreshAccessToken: live_1.refreshAccessToken,
    exchangeCodeForAccessToken: live_1.exchangeCodeForAccessToken
};
exports.xbl = {
    EXPERIMENTAL_createDummyWin32DeviceToken: xboxlive_1.EXPERIMENTAL_createDummyWin32DeviceToken,
    exchangeRpsTicketForUserToken: xboxlive_1.exchangeRpsTicketForUserToken,
    exchangeTokensForXSTSToken: xboxlive_1.exchangeTokensForXSTSToken,
    exchangeTokenForXSTSToken: xboxlive_1.exchangeTokenForXSTSToken
};
