'use strict';

var repeat = require('repeat-string');

var splitOnTags = function splitOnTags(str) {
  return str.split(/(<\/?[^>]+>)/g).filter(function (line) {
    return line.trim() !== '';
  });
};
var isTag = function isTag(str) {
  return (/<[^>!]+>/.test(str)
  );
};
var isXMLDeclaration = function isXMLDeclaration(str) {
  return (/<\?[^?>]+\?>/.test(str)
  );
};
var isClosingTag = function isClosingTag(str) {
  return (/<\/+[^>]+>/.test(str)
  );
};
var isSelfClosingTag = function isSelfClosingTag(str) {
  return (/<[^>]+\/>/.test(str)
  );
};
var isOpeningTag = function isOpeningTag(str) {
  return isTag(str) && !isClosingTag(str) && !isSelfClosingTag(str) && !isXMLDeclaration(str);
};

module.exports = function (xml, indent) {
  var depth = 0;
  indent = indent || '    ';
  var ignoreMode = false;
  var deferred = [];

  return splitOnTags(xml).map(function (item) {
    if (item.trim().startsWith("<![CDATA[")) {
      ignoreMode = true;
    }
    if (item.trim().endsWith("]]>")) {
      ignoreMode = false;
      deferred.push(item);
      var cdataBlock = deferred.join("");
      deferred = [];
      return cdataBlock;
    }
    if (ignoreMode) {
      deferred.push(item);
      return null;
    }

    // removes any pre-existing whitespace chars at the end or beginning of the item
    item = item.replace(/^\s+|\s+$/g, '');
    if (isClosingTag(item)) {
      depth--;
    }

    var line = repeat(indent, depth) + item;

    if (isOpeningTag(item)) {
      depth++;
    }

    return line;
  }).filter(function (c) {
    return c;
  }).join('\n');
};