(module
  (memory (export "memory") 10 1000)

  (func (export "xsalsa20_xor")
    (param $ptr i32) (param $c_ptr i32) (param $m_ptr i32) (param $m_len i32) (param $nonce_ptr i32) (param $key_ptr i32)
    (i64.store (get_local $ptr)
      (call $xsalsa20_xor_ic
        (get_local $c_ptr)
        (get_local $m_ptr)
        (get_local $m_len)
        (get_local $nonce_ptr)
        (i64.load (get_local $ptr))
        (get_local $key_ptr)
      )
    )
  )

  (func $xsalsa20_xor_ic
    (param $c_ptr i32) (param $m_ptr i32) (param $m_len i32) (param $nonce_ptr i32) (param $ic i64) (param $key_ptr i32) (result i64)

    ;; subkey --> 112-144
    (call $core_hsalsa20 (i32.const 112) (get_local $nonce_ptr) (get_local $key_ptr))

    (call $salsa20_xor_ic
      (get_local $c_ptr)
      (get_local $m_ptr)
      (get_local $m_len)
      (i32.add (get_local $nonce_ptr) (i32.const 16))
      (get_local $ic)
      (i32.const 112)
    )

    ;; memzero
    (i64.store (i32.const 112) (i64.const 0))
    (i64.store (i32.const 120) (i64.const 0))
    (i64.store (i32.const 128) (i64.const 0))
    (i64.store (i32.const 136) (i64.const 0))
  )

  (func $salsa20_xor_ic
    (param $c_ptr i32) (param $m_ptr i32) (param $m_len i32) (param $nonce_ptr i32) (param $ic i64) (param $key_ptr i32) (result i64)
    (local $i i32)

    ;; in -> 0-16
    ;; block -> 16-80
    ;; kcopy -> 80-112

    (if (i32.eq (get_local $m_len) (i32.const 0))
      (then
        (return (i64.const 0))
      )
    )

    ;; kcopy[i] = k[i];
    (i64.store (i32.const 80) (i64.load (get_local $key_ptr)))
    (i64.store (i32.const 88) (i64.load (i32.add (get_local $key_ptr) (i32.const 8))))
    (i64.store (i32.const 96) (i64.load (i32.add (get_local $key_ptr) (i32.const 16))))
    (i64.store (i32.const 104) (i64.load (i32.add (get_local $key_ptr) (i32.const 24))))

    ;; in[i] = n[i];
    (i64.store (i32.const 0) (i64.load (get_local $nonce_ptr)))

    ;; in[i] = (unsigned char) (ic & 0xff); (LE)
    (i64.store (i32.const 8) (get_local $ic))

    (block $end_loop
      (loop $start_loop
        (br_if $end_loop (i32.lt_u (get_local $m_len) (i32.const 64)))

        (call $core_salsa20 (i32.const 16) (i32.const 0) (i32.const 80))

        (i64.store (get_local $c_ptr)
          (i64.xor (i64.load (get_local $m_ptr)) (i64.load (i32.const 16)))
        )
        (i64.store (i32.add (get_local $c_ptr) (i32.const 8))
          (i64.xor (i64.load (i32.add (get_local $m_ptr) (i32.const 8))) (i64.load (i32.const 24)))
        )
        (i64.store (i32.add (get_local $c_ptr) (i32.const 16))
          (i64.xor (i64.load (i32.add (get_local $m_ptr) (i32.const 16))) (i64.load (i32.const 32)))
        )
        (i64.store (i32.add (get_local $c_ptr) (i32.const 24))
          (i64.xor (i64.load (i32.add (get_local $m_ptr) (i32.const 24))) (i64.load (i32.const 40)))
        )
        (i64.store (i32.add (get_local $c_ptr) (i32.const 32))
          (i64.xor (i64.load (i32.add (get_local $m_ptr) (i32.const 32))) (i64.load (i32.const 48)))
        )
        (i64.store (i32.add (get_local $c_ptr) (i32.const 40))
          (i64.xor (i64.load (i32.add (get_local $m_ptr) (i32.const 40))) (i64.load (i32.const 56)))
        )
        (i64.store (i32.add (get_local $c_ptr) (i32.const 48))
          (i64.xor (i64.load (i32.add (get_local $m_ptr) (i32.const 48))) (i64.load (i32.const 64)))
        )
        (i64.store (i32.add (get_local $c_ptr) (i32.const 56))
          (i64.xor (i64.load (i32.add (get_local $m_ptr) (i32.const 56))) (i64.load (i32.const 72)))
        )

        (i64.store (i32.const 8)
          (i64.add (i64.load (i32.const 8)) (i64.const 1))
        )

        (set_local $c_ptr (i32.add (get_local $c_ptr) (i32.const 64)))
        (set_local $m_ptr (i32.add (get_local $m_ptr) (i32.const 64)))
        (set_local $m_len (i32.sub (get_local $m_len) (i32.const 64)))
        (br $start_loop)
      )
    )

    (set_local $ic (i64.load (i32.const 8)))

    (if (i32.gt_u (get_local $m_len) (i32.const 0))
      (then
        (call $core_salsa20 (i32.const 16) (i32.const 0) (i32.const 80))

        (block $0
          (block $1
            (block $2
              (block $3
                (block $4
                  (block $5
                    (block $6
                      (block $7
                        (br_table $0 $1 $2 $3 $4 $5 $6 $7 (i32.div_u (get_local $m_len) (i32.const 8)))
                      )
                      (i64.store (i32.add (get_local $c_ptr) (i32.const 56))
                        (i64.xor (i64.load (i32.add (get_local $m_ptr) (i32.const 56))) (i64.load (i32.const 72)))
                      )
                    )
                    (i64.store (i32.add (get_local $c_ptr) (i32.const 48))
                      (i64.xor (i64.load (i32.add (get_local $m_ptr) (i32.const 48))) (i64.load (i32.const 64)))
                    )
                  )
                  (i64.store (i32.add (get_local $c_ptr) (i32.const 40))
                    (i64.xor (i64.load (i32.add (get_local $m_ptr) (i32.const 40))) (i64.load (i32.const 56)))
                  )
                )
                (i64.store (i32.add (get_local $c_ptr) (i32.const 32))
                  (i64.xor (i64.load (i32.add (get_local $m_ptr) (i32.const 32))) (i64.load (i32.const 48)))
                )
              )
              (i64.store (i32.add (get_local $c_ptr) (i32.const 24))
                (i64.xor (i64.load (i32.add (get_local $m_ptr) (i32.const 24))) (i64.load (i32.const 40)))
              )
            )
            (i64.store (i32.add (get_local $c_ptr) (i32.const 16))
              (i64.xor (i64.load (i32.add (get_local $m_ptr) (i32.const 16))) (i64.load (i32.const 32)))
            )
          )
          (i64.store (i32.add (get_local $c_ptr) (i32.const 8))
            (i64.xor (i64.load (i32.add (get_local $m_ptr) (i32.const 8))) (i64.load (i32.const 24)))
          )
        )
        (i64.store (get_local $c_ptr)
          (i64.xor (i64.load (get_local $m_ptr)) (i64.load (i32.const 16)))
        )
      )
    )

    ;; memzero
    (i64.store (i32.const 16) (i64.const 0))
    (i64.store (i32.const 24) (i64.const 0))
    (i64.store (i32.const 32) (i64.const 0))
    (i64.store (i32.const 40) (i64.const 0))
    (i64.store (i32.const 48) (i64.const 0))
    (i64.store (i32.const 56) (i64.const 0))
    (i64.store (i32.const 64) (i64.const 0))
    (i64.store (i32.const 72) (i64.const 0))
    (i64.store (i32.const 80) (i64.const 0))
    (i64.store (i32.const 88) (i64.const 0))
    (i64.store (i32.const 96) (i64.const 0))
    (i64.store (i32.const 104) (i64.const 0))

    (return (get_local $ic))
  )

  (func $core_hsalsa20 (param $out_ptr i32) (param $in_ptr i32) (param $key_ptr i32)
    (local $x0 i32)
    (local $x1 i32)
    (local $x2 i32)
    (local $x3 i32)
    (local $x4 i32)
    (local $x5 i32)
    (local $x6 i32)
    (local $x7 i32)
    (local $x8 i32)
    (local $x9 i32)
    (local $x10 i32)
    (local $x11 i32)
    (local $x12 i32)
    (local $x13 i32)
    (local $x14 i32)
    (local $x15 i32)
    (local $i i32)

    (set_local $x0 (i32.const 0x61707865))
    (set_local $x5 (i32.const 0x3320646e))
    (set_local $x10 (i32.const 0x79622d32))
    (set_local $x15 (i32.const 0x6b206574))

    (set_local $x1 (i32.load (get_local $key_ptr)))
    (set_local $x2 (i32.load (i32.add (get_local $key_ptr) (i32.const 4))))
    (set_local $x3 (i32.load (i32.add (get_local $key_ptr) (i32.const 8))))
    (set_local $x4 (i32.load (i32.add (get_local $key_ptr) (i32.const 12))))
    (set_local $x11 (i32.load (i32.add (get_local $key_ptr) (i32.const 16))))
    (set_local $x12 (i32.load (i32.add (get_local $key_ptr) (i32.const 20))))
    (set_local $x13 (i32.load (i32.add (get_local $key_ptr) (i32.const 24))))
    (set_local $x14 (i32.load (i32.add (get_local $key_ptr) (i32.const 28))))
    (set_local $x6 (i32.load (get_local $in_ptr)))
    (set_local $x7 (i32.load (i32.add (get_local $in_ptr) (i32.const 4))))
    (set_local $x8 (i32.load (i32.add (get_local $in_ptr) (i32.const 8))))
    (set_local $x9 (i32.load (i32.add (get_local $in_ptr) (i32.const 12))))

    ;; rounds
    (set_local $i (i32.const 20))
    (block $end_loop
      (loop $start_loop
        (br_if $end_loop (i32.eq (get_local $i) (i32.const 0)))
        (set_local $x4 (i32.xor (get_local $x4) (i32.rotl (i32.add (get_local $x0) (get_local $x12)) (i32.const 7))))
        (set_local $x8 (i32.xor (get_local $x8) (i32.rotl (i32.add (get_local $x4) (get_local $x0)) (i32.const 9))))
        (set_local $x12 (i32.xor (get_local $x12) (i32.rotl (i32.add (get_local $x8) (get_local $x4)) (i32.const 13))))
        (set_local $x0 (i32.xor (get_local $x0) (i32.rotl (i32.add (get_local $x12) (get_local $x8)) (i32.const 18))))
        (set_local $x9 (i32.xor (get_local $x9) (i32.rotl (i32.add (get_local $x5) (get_local $x1)) (i32.const 7))))
        (set_local $x13 (i32.xor (get_local $x13) (i32.rotl (i32.add (get_local $x9) (get_local $x5)) (i32.const 9))))
        (set_local $x1 (i32.xor (get_local $x1) (i32.rotl (i32.add (get_local $x13) (get_local $x9)) (i32.const 13))))
        (set_local $x5 (i32.xor (get_local $x5) (i32.rotl (i32.add (get_local $x1) (get_local $x13)) (i32.const 18))))
        (set_local $x14 (i32.xor (get_local $x14) (i32.rotl (i32.add (get_local $x10) (get_local $x6)) (i32.const 7))))
        (set_local $x2 (i32.xor (get_local $x2) (i32.rotl (i32.add (get_local $x14) (get_local $x10)) (i32.const 9))))
        (set_local $x6 (i32.xor (get_local $x6) (i32.rotl (i32.add (get_local $x2) (get_local $x14)) (i32.const 13))))
        (set_local $x10 (i32.xor (get_local $x10) (i32.rotl (i32.add (get_local $x6) (get_local $x2)) (i32.const 18))))
        (set_local $x3 (i32.xor (get_local $x3) (i32.rotl (i32.add (get_local $x15) (get_local $x11)) (i32.const 7))))
        (set_local $x7 (i32.xor (get_local $x7) (i32.rotl (i32.add (get_local $x3) (get_local $x15)) (i32.const 9))))
        (set_local $x11 (i32.xor (get_local $x11) (i32.rotl (i32.add (get_local $x7) (get_local $x3)) (i32.const 13))))
        (set_local $x15 (i32.xor (get_local $x15) (i32.rotl (i32.add (get_local $x11) (get_local $x7)) (i32.const 18))))
        (set_local $x1 (i32.xor (get_local $x1) (i32.rotl (i32.add (get_local $x0) (get_local $x3)) (i32.const 7))))
        (set_local $x2 (i32.xor (get_local $x2) (i32.rotl (i32.add (get_local $x1) (get_local $x0)) (i32.const 9))))
        (set_local $x3 (i32.xor (get_local $x3) (i32.rotl (i32.add (get_local $x2) (get_local $x1)) (i32.const 13))))
        (set_local $x0 (i32.xor (get_local $x0) (i32.rotl (i32.add (get_local $x3) (get_local $x2)) (i32.const 18))))
        (set_local $x6 (i32.xor (get_local $x6) (i32.rotl (i32.add (get_local $x5) (get_local $x4)) (i32.const 7))))
        (set_local $x7 (i32.xor (get_local $x7) (i32.rotl (i32.add (get_local $x6) (get_local $x5)) (i32.const 9))))
        (set_local $x4 (i32.xor (get_local $x4) (i32.rotl (i32.add (get_local $x7) (get_local $x6)) (i32.const 13))))
        (set_local $x5 (i32.xor (get_local $x5) (i32.rotl (i32.add (get_local $x4) (get_local $x7)) (i32.const 18))))
        (set_local $x11 (i32.xor (get_local $x11) (i32.rotl (i32.add (get_local $x10) (get_local $x9)) (i32.const 7))))
        (set_local $x8 (i32.xor (get_local $x8) (i32.rotl (i32.add (get_local $x11) (get_local $x10)) (i32.const 9))))
        (set_local $x9 (i32.xor (get_local $x9) (i32.rotl (i32.add (get_local $x8) (get_local $x11)) (i32.const 13))))
        (set_local $x10 (i32.xor (get_local $x10) (i32.rotl (i32.add (get_local $x9) (get_local $x8)) (i32.const 18))))
        (set_local $x12 (i32.xor (get_local $x12) (i32.rotl (i32.add (get_local $x15) (get_local $x14)) (i32.const 7))))
        (set_local $x13 (i32.xor (get_local $x13) (i32.rotl (i32.add (get_local $x12) (get_local $x15)) (i32.const 9))))
        (set_local $x14 (i32.xor (get_local $x14) (i32.rotl (i32.add (get_local $x13) (get_local $x12)) (i32.const 13))))
        (set_local $x15 (i32.xor (get_local $x15) (i32.rotl (i32.add (get_local $x14) (get_local $x13)) (i32.const 18))))
        (set_local $i (i32.sub (get_local $i) (i32.const 2)))
        (br $start_loop)
      )
    )

    (i32.store (get_local $out_ptr) (get_local $x0))
    (i32.store (i32.add (get_local $out_ptr) (i32.const 4)) (get_local $x5))
    (i32.store (i32.add (get_local $out_ptr) (i32.const 8)) (get_local $x10))
    (i32.store (i32.add (get_local $out_ptr) (i32.const 12)) (get_local $x15))
    (i32.store (i32.add (get_local $out_ptr) (i32.const 16)) (get_local $x6))
    (i32.store (i32.add (get_local $out_ptr) (i32.const 20)) (get_local $x7))
    (i32.store (i32.add (get_local $out_ptr) (i32.const 24)) (get_local $x8))
    (i32.store (i32.add (get_local $out_ptr) (i32.const 28)) (get_local $x9))
  )

  (func (export "core_salsa20") (param $out_ptr i32) (param $in_ptr i32) (param $key_ptr i32)
    (call $core_salsa20 (get_local $out_ptr) (get_local $in_ptr) (get_local $key_ptr))
  )

  (func $core_salsa20 (param $out_ptr i32) (param $in_ptr i32) (param $key_ptr i32)
    ;; uint32_t x0, x1, x2, x3, x4, x5, x6, x7, x8,
    ;;          x9, x10, x11, x12, x13, x14,  x15;
    ;; int      i;

    (local $x0 i32)
    (local $x1 i32)
    (local $x2 i32)
    (local $x3 i32)
    (local $x4 i32)
    (local $x5 i32)
    (local $x6 i32)
    (local $x7 i32)
    (local $x8 i32)
    (local $x9 i32)
    (local $x10 i32)
    (local $x11 i32)
    (local $x12 i32)
    (local $x13 i32)
    (local $x14 i32)
    (local $x15 i32)
    (local $j0 i32)
    (local $j1 i32)
    (local $j2 i32)
    (local $j3 i32)
    (local $j4 i32)
    (local $j5 i32)
    (local $j6 i32)
    (local $j7 i32)
    (local $j8 i32)
    (local $j9 i32)
    (local $j10 i32)
    (local $j11 i32)
    (local $j12 i32)
    (local $j13 i32)
    (local $j14 i32)
    (local $j15 i32)
    (local $i i32)

    (set_local $x0 (i32.const 0x61707865))
    (set_local $x5 (i32.const 0x3320646e))
    (set_local $x10 (i32.const 0x79622d32))
    (set_local $x15 (i32.const 0x6b206574))

    (set_local $x1 (i32.load (get_local $key_ptr)))
    (set_local $x2 (i32.load (i32.add (get_local $key_ptr) (i32.const 4))))
    (set_local $x3 (i32.load (i32.add (get_local $key_ptr) (i32.const 8))))
    (set_local $x4 (i32.load (i32.add (get_local $key_ptr) (i32.const 12))))
    (set_local $x11 (i32.load (i32.add (get_local $key_ptr) (i32.const 16))))
    (set_local $x12 (i32.load (i32.add (get_local $key_ptr) (i32.const 20))))
    (set_local $x13 (i32.load (i32.add (get_local $key_ptr) (i32.const 24))))
    (set_local $x14 (i32.load (i32.add (get_local $key_ptr) (i32.const 28))))
    (set_local $x6 (i32.load (get_local $in_ptr)))
    (set_local $x7 (i32.load (i32.add (get_local $in_ptr) (i32.const 4))))
    (set_local $x8 (i32.load (i32.add (get_local $in_ptr) (i32.const 8))))
    (set_local $x9 (i32.load (i32.add (get_local $in_ptr) (i32.const 12))))

    (set_local $j0 (get_local $x0))
    (set_local $j1 (get_local $x1))
    (set_local $j2 (get_local $x2))
    (set_local $j3 (get_local $x3))
    (set_local $j4 (get_local $x4))
    (set_local $j5 (get_local $x5))
    (set_local $j6 (get_local $x6))
    (set_local $j7 (get_local $x7))
    (set_local $j8 (get_local $x8))
    (set_local $j9 (get_local $x9))
    (set_local $j10 (get_local $x10))
    (set_local $j11 (get_local $x11))
    (set_local $j12 (get_local $x12))
    (set_local $j13 (get_local $x13))
    (set_local $j14 (get_local $x14))
    (set_local $j15 (get_local $x15))

    ;; rounds
    (set_local $i (i32.const 20))
    (block $end_loop
      (loop $start_loop
        (br_if $end_loop (i32.eq (get_local $i) (i32.const 0)))
        (set_local $x4 (i32.xor (get_local $x4) (i32.rotl (i32.add (get_local $x0) (get_local $x12)) (i32.const 7))))
        (set_local $x8 (i32.xor (get_local $x8) (i32.rotl (i32.add (get_local $x4) (get_local $x0)) (i32.const 9))))
        (set_local $x12 (i32.xor (get_local $x12) (i32.rotl (i32.add (get_local $x8) (get_local $x4)) (i32.const 13))))
        (set_local $x0 (i32.xor (get_local $x0) (i32.rotl (i32.add (get_local $x12) (get_local $x8)) (i32.const 18))))
        (set_local $x9 (i32.xor (get_local $x9) (i32.rotl (i32.add (get_local $x5) (get_local $x1)) (i32.const 7))))
        (set_local $x13 (i32.xor (get_local $x13) (i32.rotl (i32.add (get_local $x9) (get_local $x5)) (i32.const 9))))
        (set_local $x1 (i32.xor (get_local $x1) (i32.rotl (i32.add (get_local $x13) (get_local $x9)) (i32.const 13))))
        (set_local $x5 (i32.xor (get_local $x5) (i32.rotl (i32.add (get_local $x1) (get_local $x13)) (i32.const 18))))
        (set_local $x14 (i32.xor (get_local $x14) (i32.rotl (i32.add (get_local $x10) (get_local $x6)) (i32.const 7))))
        (set_local $x2 (i32.xor (get_local $x2) (i32.rotl (i32.add (get_local $x14) (get_local $x10)) (i32.const 9))))
        (set_local $x6 (i32.xor (get_local $x6) (i32.rotl (i32.add (get_local $x2) (get_local $x14)) (i32.const 13))))
        (set_local $x10 (i32.xor (get_local $x10) (i32.rotl (i32.add (get_local $x6) (get_local $x2)) (i32.const 18))))
        (set_local $x3 (i32.xor (get_local $x3) (i32.rotl (i32.add (get_local $x15) (get_local $x11)) (i32.const 7))))
        (set_local $x7 (i32.xor (get_local $x7) (i32.rotl (i32.add (get_local $x3) (get_local $x15)) (i32.const 9))))
        (set_local $x11 (i32.xor (get_local $x11) (i32.rotl (i32.add (get_local $x7) (get_local $x3)) (i32.const 13))))
        (set_local $x15 (i32.xor (get_local $x15) (i32.rotl (i32.add (get_local $x11) (get_local $x7)) (i32.const 18))))
        (set_local $x1 (i32.xor (get_local $x1) (i32.rotl (i32.add (get_local $x0) (get_local $x3)) (i32.const 7))))
        (set_local $x2 (i32.xor (get_local $x2) (i32.rotl (i32.add (get_local $x1) (get_local $x0)) (i32.const 9))))
        (set_local $x3 (i32.xor (get_local $x3) (i32.rotl (i32.add (get_local $x2) (get_local $x1)) (i32.const 13))))
        (set_local $x0 (i32.xor (get_local $x0) (i32.rotl (i32.add (get_local $x3) (get_local $x2)) (i32.const 18))))
        (set_local $x6 (i32.xor (get_local $x6) (i32.rotl (i32.add (get_local $x5) (get_local $x4)) (i32.const 7))))
        (set_local $x7 (i32.xor (get_local $x7) (i32.rotl (i32.add (get_local $x6) (get_local $x5)) (i32.const 9))))
        (set_local $x4 (i32.xor (get_local $x4) (i32.rotl (i32.add (get_local $x7) (get_local $x6)) (i32.const 13))))
        (set_local $x5 (i32.xor (get_local $x5) (i32.rotl (i32.add (get_local $x4) (get_local $x7)) (i32.const 18))))
        (set_local $x11 (i32.xor (get_local $x11) (i32.rotl (i32.add (get_local $x10) (get_local $x9)) (i32.const 7))))
        (set_local $x8 (i32.xor (get_local $x8) (i32.rotl (i32.add (get_local $x11) (get_local $x10)) (i32.const 9))))
        (set_local $x9 (i32.xor (get_local $x9) (i32.rotl (i32.add (get_local $x8) (get_local $x11)) (i32.const 13))))
        (set_local $x10 (i32.xor (get_local $x10) (i32.rotl (i32.add (get_local $x9) (get_local $x8)) (i32.const 18))))
        (set_local $x12 (i32.xor (get_local $x12) (i32.rotl (i32.add (get_local $x15) (get_local $x14)) (i32.const 7))))
        (set_local $x13 (i32.xor (get_local $x13) (i32.rotl (i32.add (get_local $x12) (get_local $x15)) (i32.const 9))))
        (set_local $x14 (i32.xor (get_local $x14) (i32.rotl (i32.add (get_local $x13) (get_local $x12)) (i32.const 13))))
        (set_local $x15 (i32.xor (get_local $x15) (i32.rotl (i32.add (get_local $x14) (get_local $x13)) (i32.const 18))))
        (set_local $i (i32.sub (get_local $i) (i32.const 2)))
        (br $start_loop)
      )
    )

    (i32.store (get_local $out_ptr) (i32.add (get_local $x0) (get_local $j0)))
    (i32.store (i32.add (get_local $out_ptr) (i32.const 4)) (i32.add (get_local $x1) (get_local $j1)))
    (i32.store (i32.add (get_local $out_ptr) (i32.const 8)) (i32.add (get_local $x2) (get_local $j2)))
    (i32.store (i32.add (get_local $out_ptr) (i32.const 12)) (i32.add (get_local $x3) (get_local $j3)))
    (i32.store (i32.add (get_local $out_ptr) (i32.const 16)) (i32.add (get_local $x4) (get_local $j4)))
    (i32.store (i32.add (get_local $out_ptr) (i32.const 20)) (i32.add (get_local $x5) (get_local $j5)))
    (i32.store (i32.add (get_local $out_ptr) (i32.const 24)) (i32.add (get_local $x6) (get_local $j6)))
    (i32.store (i32.add (get_local $out_ptr) (i32.const 28)) (i32.add (get_local $x7) (get_local $j7)))
    (i32.store (i32.add (get_local $out_ptr) (i32.const 32)) (i32.add (get_local $x8) (get_local $j8)))
    (i32.store (i32.add (get_local $out_ptr) (i32.const 36)) (i32.add (get_local $x9) (get_local $j9)))
    (i32.store (i32.add (get_local $out_ptr) (i32.const 40)) (i32.add (get_local $x10) (get_local $j10)))
    (i32.store (i32.add (get_local $out_ptr) (i32.const 44)) (i32.add (get_local $x11) (get_local $j11)))
    (i32.store (i32.add (get_local $out_ptr) (i32.const 48)) (i32.add (get_local $x12) (get_local $j12)))
    (i32.store (i32.add (get_local $out_ptr) (i32.const 52)) (i32.add (get_local $x13) (get_local $j13)))
    (i32.store (i32.add (get_local $out_ptr) (i32.const 56)) (i32.add (get_local $x14) (get_local $j14)))
    (i32.store (i32.add (get_local $out_ptr) (i32.const 60)) (i32.add (get_local $x15) (get_local $j15)))
  )
)
