"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var CircularList_1 = require("./utils/CircularList");
var Buffer = (function () {
    function Buffer(_terminal) {
        this._terminal = _terminal;
        this.clear();
    }
    Object.defineProperty(Buffer.prototype, "lines", {
        get: function () {
            return this._lines;
        },
        enumerable: true,
        configurable: true
    });
    Buffer.prototype.fillViewportRows = function () {
        if (this._lines.length === 0) {
            var i = this._terminal.rows;
            while (i--) {
                this.lines.push(this._terminal.blankLine());
            }
        }
    };
    Buffer.prototype.clear = function () {
        this.ydisp = 0;
        this.ybase = 0;
        this.y = 0;
        this.x = 0;
        this.scrollBottom = 0;
        this.scrollTop = 0;
        this.tabs = {};
        this._lines = new CircularList_1.CircularList(this._terminal.scrollback);
        this.scrollBottom = this._terminal.rows - 1;
    };
    Buffer.prototype.resize = function (newCols, newRows) {
        if (this._lines.length === 0) {
            return;
        }
        if (this._terminal.cols < newCols) {
            var ch = [this._terminal.defAttr, ' ', 1];
            for (var i = 0; i < this._lines.length; i++) {
                if (this._lines.get(i) === undefined) {
                    this._lines.set(i, this._terminal.blankLine());
                }
                while (this._lines.get(i).length < newCols) {
                    this._lines.get(i).push(ch);
                }
            }
        }
        var addToY = 0;
        if (this._terminal.rows < newRows) {
            for (var y = this._terminal.rows; y < newRows; y++) {
                if (this._lines.length < newRows + this.ybase) {
                    if (this.ybase > 0 && this._lines.length <= this.ybase + this.y + addToY + 1) {
                        this.ybase--;
                        addToY++;
                        if (this.ydisp > 0) {
                            this.ydisp--;
                        }
                    }
                    else {
                        this._lines.push(this._terminal.blankLine());
                    }
                }
            }
        }
        else {
            for (var y = this._terminal.rows; y > newRows; y--) {
                if (this._lines.length > newRows + this.ybase) {
                    if (this._lines.length > this.ybase + this.y + 1) {
                        this._lines.pop();
                    }
                    else {
                        this.ybase++;
                        this.ydisp++;
                    }
                }
            }
        }
        if (this.y >= newRows) {
            this.y = newRows - 1;
        }
        if (addToY) {
            this.y += addToY;
        }
        if (this.x >= newCols) {
            this.x = newCols - 1;
        }
        this.scrollTop = 0;
        this.scrollBottom = newRows - 1;
    };
    return Buffer;
}());
exports.Buffer = Buffer;

//# sourceMappingURL=Buffer.js.map
