# snapshot

## Important Notice

**`snapshot()` has been deprecated**.  Yahoo no longer provides all the info
required for it to function properly.  Use [quote()](./quote.md) instead.

*The documentation below is for reference purposes only.*

### Quick Start:

```js
yahooFinance.snapshot({
  symbol: 'AAPL',
  fields: ['s', 'n', 'd1', 'l1', 'y', 'r'],
}, function (err, snapshot) {
  //...
});
```

### Download Snapshot Data (single symbol)

```js
yahooFinance.snapshot({
  symbol: SYMBOL,
  fields: FIELDS  // ex: ['s', 'n', 'd1', 'l1', 'y', 'r']
}, function (err, snapshot) {
  /*
  {
    symbol: 'AAPL',
    name: 'Apple Inc.',
    lastTradeDate: '11/15/2013',
    lastTradePriceOnly: '524.88',
    dividendYield: '2.23',
    peRatio: '13.29'
  }
  */
});
```

### Download Snapshot Data (multiple symbols)

```js
yahooFinance.snapshot({
  symbols: [SYMBOL1, SYMBOL2],
  fields: FIELDS  // ex: ['s', 'n', 'd1', 'l1', 'y', 'r']
}, function (err, snapshot) {
  /*
  {
    AAPL: {
      symbol: 'AAPL',
      name: 'Apple Inc.',
      lastTradeDate: '11/15/2013',
      lastTradePriceOnly: '524.88',
      dividendYield: '2.23',
      peRatio: '13.29'
    },
    GOOGL: {
      symbol: 'GOOGL',
      name: 'Google Inc.',
      lastTradeDate: '11/15/2013',
      lastTradePriceOnly: '1034.23',
      dividendYield: 'N/A',
      peRatio: '28.17'
    }
  }
  */
});
```



### Fields

```
s:	Symbol
```

#### Pricing

```
a:	Ask
b:	Bid
b2:	Ask (Realtime)
b3:	Bid (Realtime)
p:	Previous Close
o:	Open
```

#### Dividends

```
y:	Dividend Yield
d:	Dividend Per Share
r1:	Dividend Pay Date
q:	Ex-Dividend Date
```

#### Date

```
c1:	Change
c:	Change And Percent Change
c6:	Change (Realtime)
k2:	Change Percent (Realtime)
p2:	Change in Percent
d1:	Last Trade Date
d2:	Trade Date
t1:	Last Trade Time
```

#### Averages

```
c8:	After Hours Change (Realtime)
c3:	Commission
g:	Day’s Low
h:	Day’s High
k1:	Last Trade (Realtime) With Time
l:	Last Trade (With Time)
l1:	Last Trade (Price Only)
t8:	1 yr Target Price
m5:	Change From 200-day Moving Average
m6:	Percent Change From 200-day Moving Average
m7:	Change From 50-day Moving Average
m8:	Percent Change From 50-day Moving Average
m3:	50-day Moving Average
m4:	200-day Moving Average
```

#### Misc

```
w1:	Day’s Value Change
w4:	Day’s Value Change (Realtime)
p1:	Price Paid
m:	Day’s Range
m2:	Day’s Range (Realtime)
g1:	Holdings Gain Percent
g3:	Annualized Gain
g4:	Holdings Gain
g5:	Holdings Gain Percent (Realtime)
g6:	Holdings Gain (Realtime)
```

#### 52 Week Pricing

```
k:	52-week High
j:	52-week Low
j5:	Change From 52-week Low
k4:	Change From 52-week High
j6:	Percent Change From 52-week Low
k5:	Percebt Change From 52-week High
w:	52-week Range
```

#### System Info

```
i:	More Info
j1:	Market Capitalization
j3:	Market Cap (Realtime)
f6:	Float Shares
n:	Name
n4:	Notes
s1:	Shares Owned
x:	Stock Exchange
j2:	Shares Outstanding
```

#### Volume

```
v:	Volume
a5:	Ask Size
b6:	Bid Size
k3:	Last Trade Size
a2:	Average Daily Volume
```

#### Ratio

```
e:	Earnings Per Share
e7:	EPS Estimate Current Year
e8:	EPS Estimate Next Year
e9:	EPS Estimate Next Quarter
b4:	Book Value
j4:	EBITDA
p5:	Price per Sales
p6:	Price per Book
r:	PE Ratio
r2:	PE Ratio (Realtime)
r5:	PEG Ratio
r6:	Price Per EPS Estimate Current Year
r7:	Price Per EPS Estimate Next Year
s7:	Short Ratio
```

#### Misc

```
t7:	Ticker Trend
t6:	Trade Links
i5:	Order Book (Realtime)
l2:	High Limit
l3:	Low Limit
v1:	Holdings Value
v7:	Holdings Value (Realtime)
s6:	Revenue
e1: Error Indication (returned for symbol changed or invalid)
```

### Specifying request options

Optionally request options (such as a proxy) can be specified by inserting an
extra parameter just before the callback:


```js
var httpRequestOptions = {
  proxy: 'http://localproxy.com'
};


yahooFinance.snapshot({
  symbol: SYMBOL,
  fields: FIELDS  // ex: ['s', 'n', 'd1', 'l1', 'y', 'r']
}, httpRequestOptions, function (err, snapshot) {
  // Result
});
```
