"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.seq = exports.map = void 0;

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _Map = _interopRequireDefault(require("./Map"));

var _Pair = _interopRequireDefault(require("./Pair"));

var _Seq = _interopRequireDefault(require("./Seq"));

var _string = require("./_string");

var _parseMap = _interopRequireDefault(require("./parseMap"));

var _parseSeq = _interopRequireDefault(require("./parseSeq"));

function createMap(schema, obj, wrapScalars) {
  var map = new _Map.default();

  if (obj instanceof Map) {
    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
      for (var _iterator = obj[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
        var _step$value = (0, _slicedToArray2.default)(_step.value, 2),
            key = _step$value[0],
            value = _step$value[1];

        var k = schema.createNode(key, wrapScalars);
        var v = schema.createNode(value, wrapScalars);
        map.items.push(new _Pair.default(k, v));
      }
    } catch (err) {
      _didIteratorError = true;
      _iteratorError = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion && _iterator.return != null) {
          _iterator.return();
        }
      } finally {
        if (_didIteratorError) {
          throw _iteratorError;
        }
      }
    }
  } else if (obj && (0, _typeof2.default)(obj) === 'object') {
    map.items = Object.keys(obj).map(function (key) {
      var k = schema.createNode(key, wrapScalars);
      var v = schema.createNode(obj[key], wrapScalars);
      return new _Pair.default(k, v);
    });
  }

  return map;
}

function createSeq(schema, obj, wrapScalars) {
  var seq = new _Seq.default();

  if (obj && obj[Symbol.iterator]) {
    var _iteratorNormalCompletion2 = true;
    var _didIteratorError2 = false;
    var _iteratorError2 = undefined;

    try {
      for (var _iterator2 = obj[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
        var it = _step2.value;
        var v = schema.createNode(it, wrapScalars);
        seq.items.push(v);
      }
    } catch (err) {
      _didIteratorError2 = true;
      _iteratorError2 = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion2 && _iterator2.return != null) {
          _iterator2.return();
        }
      } finally {
        if (_didIteratorError2) {
          throw _iteratorError2;
        }
      }
    }
  }

  return seq;
}

var map = {
  createNode: createMap,
  default: true,
  nodeClass: _Map.default,
  tag: 'tag:yaml.org,2002:map',
  resolve: _parseMap.default,
  stringify: function stringify(value, ctx, onComment, onChompKeep) {
    return value.toString(ctx, onComment, onChompKeep);
  }
};
exports.map = map;
var seq = {
  createNode: createSeq,
  default: true,
  nodeClass: _Seq.default,
  tag: 'tag:yaml.org,2002:seq',
  resolve: _parseSeq.default,
  stringify: function stringify(value, ctx, onComment, onChompKeep) {
    return value.toString(ctx, onComment, onChompKeep);
  }
};
exports.seq = seq;
var _default = [map, seq, _string.str];
exports.default = _default;