"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _Node = require("../cst/Node");

var _errors = require("../errors");

var _Alias = _interopRequireDefault(require("./Alias"));

var _Collection = _interopRequireDefault(require("./Collection"));

var _core = _interopRequireDefault(require("./core"));

var _failsafe = _interopRequireWildcard(require("./failsafe"));

var _json = _interopRequireDefault(require("./json"));

var _Node2 = _interopRequireDefault(require("./Node"));

var _Pair = _interopRequireDefault(require("./Pair"));

var _Scalar = _interopRequireDefault(require("./Scalar"));

var _string = require("./_string");

var _yaml = _interopRequireDefault(require("./yaml-1.1"));

var isMap = function isMap(_ref) {
  var type = _ref.type;
  return type === _Node.Type.FLOW_MAP || type === _Node.Type.MAP;
};

var isSeq = function isSeq(_ref2) {
  var type = _ref2.type;
  return type === _Node.Type.FLOW_SEQ || type === _Node.Type.SEQ;
};

var Schema =
/*#__PURE__*/
function () {
  (0, _createClass2.default)(Schema, null, [{
    key: "defaultStringify",
    value: function defaultStringify(value) {
      return JSON.stringify(value);
    }
  }]);

  function Schema(_ref3) {
    var merge = _ref3.merge,
        schema = _ref3.schema,
        tags = _ref3.tags;
    (0, _classCallCheck2.default)(this, Schema);
    this.merge = !!merge;
    this.name = schema;
    this.tags = Schema.tags[schema];

    if (!this.tags) {
      var keys = Object.keys(Schema.tags).map(function (key) {
        return JSON.stringify(key);
      });
      throw new Error("Unknown schema; use one of ".concat(keys.join(', ')));
    }

    if (Array.isArray(tags)) {
      this.tags = this.tags.concat(tags);
    } else if (typeof tags === 'function') {
      this.tags = tags(this.tags.slice());
    }
  }

  (0, _createClass2.default)(Schema, [{
    key: "createNode",
    value: function createNode(value, wrapScalars, tag, onTagObj) {
      var tagObj;

      if (tag) {
        if (tag.startsWith('!!')) tag = Schema.defaultPrefix + tag.slice(2);
        var match = this.tags.filter(function (t) {
          return t.tag === tag;
        });
        tagObj = match.find(function (t) {
          return !t.format;
        }) || match[0];
        if (!tagObj) throw new Error("Tag ".concat(tag, " not found"));
      } else {
        tagObj = this.tags.find(function (t) {
          return t.class && value instanceof t.class && !t.format;
        });

        if (!tagObj) {
          if (value == null) return new _Scalar.default(null);
          if (typeof value.toJSON === 'function') value = value.toJSON();
          if ((0, _typeof2.default)(value) !== 'object') return wrapScalars ? new _Scalar.default(value) : value;
          tagObj = value instanceof Map ? _failsafe.map : value[Symbol.iterator] ? _failsafe.seq : _failsafe.map;
        }
      }

      if (onTagObj) onTagObj(tagObj);
      return tagObj.createNode ? tagObj.createNode(this, value, wrapScalars) : new _Scalar.default(value);
    } // falls back to string on no match

  }, {
    key: "resolveScalar",
    value: function resolveScalar(str, tags) {
      if (!tags) tags = this.tags;

      for (var i = 0; i < tags.length; ++i) {
        var _tags$i = tags[i],
            format = _tags$i.format,
            test = _tags$i.test,
            resolve = _tags$i.resolve;

        if (test) {
          var match = str.match(test);

          if (match) {
            var res = new _Scalar.default(resolve.apply(null, match));
            if (format) res.format = format;
            return res;
          }
        }
      }

      if (this.tags.scalarFallback) str = this.tags.scalarFallback(str);
      return new _Scalar.default(str);
    } // sets node.resolved on success

  }, {
    key: "resolveNode",
    value: function resolveNode(doc, node, tagName) {
      var tags = this.tags.filter(function (_ref4) {
        var tag = _ref4.tag;
        return tag === tagName;
      });
      var generic = tags.find(function (_ref5) {
        var test = _ref5.test;
        return !test;
      });
      if (node.error) doc.errors.push(node.error);

      try {
        if (generic) {
          var res = generic.resolve(doc, node);
          if (!(res instanceof _Collection.default)) res = new _Scalar.default(res);
          node.resolved = res;
        } else {
          var str = (0, _string.resolve)(doc, node);

          if (typeof str === 'string' && tags.length > 0) {
            node.resolved = this.resolveScalar(str, tags);
          }
        }
      } catch (error) {
        if (!error.source) error.source = node;
        doc.errors.push(error);
        node.resolved = null;
      }

      if (!node.resolved) return null;
      if (tagName) node.resolved.tag = tagName;
      return node.resolved;
    }
  }, {
    key: "resolveNodeWithFallback",
    value: function resolveNodeWithFallback(doc, node, tagName) {
      var res = this.resolveNode(doc, node, tagName);
      if (node.hasOwnProperty('resolved')) return res;
      var fallback = isMap(node) ? Schema.defaultTags.MAP : isSeq(node) ? Schema.defaultTags.SEQ : Schema.defaultTags.STR;

      if (fallback) {
        doc.warnings.push(new _errors.YAMLWarning(node, "The tag ".concat(tagName, " is unavailable, falling back to ").concat(fallback)));

        var _res = this.resolveNode(doc, node, fallback);

        _res.tag = tagName;
        return _res;
      } else {
        doc.errors.push(new _errors.YAMLReferenceError(node, "The tag ".concat(tagName, " is unavailable")));
      }

      return null;
    }
  }, {
    key: "getTagObject",
    value: function getTagObject(item) {
      if (item instanceof _Alias.default) return _Alias.default;

      if (item.tag) {
        var match = this.tags.filter(function (t) {
          return t.tag === item.tag;
        });
        if (match.length > 0) return match.find(function (t) {
          return t.format === item.format;
        }) || match[0];
      }

      if (item.value === null) {
        var _tagObj = this.tags.find(function (t) {
          return t.class === null && !t.format;
        });

        if (!_tagObj) throw new Error('Tag not resolved for null value');
        return _tagObj;
      }

      var tagObj, obj;

      if (item instanceof _Scalar.default) {
        switch ((0, _typeof2.default)(item.value)) {
          case 'boolean':
            obj = new Boolean();
            break;

          case 'number':
            obj = new Number();
            break;

          case 'string':
            obj = new String();
            break;

          default:
            obj = item.value;
        }

        var _match = this.tags.filter(function (t) {
          return t.class && (obj instanceof t.class || obj && obj.constructor === t.class);
        });

        tagObj = _match.find(function (t) {
          return t.format === item.format;
        }) || _match.find(function (t) {
          return !t.format;
        });
      } else {
        obj = item;
        tagObj = this.tags.find(function (t) {
          return t.nodeClass && obj instanceof t.nodeClass;
        });
      }

      if (!tagObj) {
        var name = obj && obj.constructor ? obj.constructor.name : (0, _typeof2.default)(obj);
        throw new Error("Tag not resolved for ".concat(name, " value"));
      }

      return tagObj;
    } // needs to be called before stringifier to allow for circular anchor refs

  }, {
    key: "stringifyProps",
    value: function stringifyProps(node, tagObj, _ref6) {
      var anchors = _ref6.anchors,
          doc = _ref6.doc;
      var props = [];
      var anchor = doc.anchors.getName(node);

      if (anchor) {
        anchors[anchor] = node;
        props.push("&".concat(anchor));
      }

      if (node.tag && node.tag !== tagObj.tag) {
        props.push(doc.stringifyTag(node.tag));
      } else if (!tagObj.default) {
        props.push(doc.stringifyTag(tagObj.tag));
      }

      return props.join(' ');
    }
  }, {
    key: "stringify",
    value: function stringify(item, ctx, onComment, onChompKeep) {
      var tagObj;
      if (!(item instanceof _Node2.default)) item = this.createNode(item, true, null, function (o) {
        return tagObj = o;
      });
      ctx.tags = this;
      if (item instanceof _Pair.default) return item.toString(ctx, onComment, onChompKeep);
      if (!tagObj) tagObj = this.getTagObject(item);
      var props = this.stringifyProps(item, tagObj, ctx);
      var stringify = tagObj.stringify || Schema.defaultStringify;
      var str = stringify(item, ctx, onComment, onChompKeep);
      return props ? item instanceof _Collection.default && str[0] !== '{' && str[0] !== '[' ? "".concat(props, "\n").concat(ctx.indent).concat(str) : "".concat(props, " ").concat(str) : str;
    }
  }]);
  return Schema;
}();

exports.default = Schema;
(0, _defineProperty2.default)(Schema, "defaultPrefix", 'tag:yaml.org,2002:');
(0, _defineProperty2.default)(Schema, "defaultTags", {
  MAP: 'tag:yaml.org,2002:map',
  SEQ: 'tag:yaml.org,2002:seq',
  STR: 'tag:yaml.org,2002:str'
});
(0, _defineProperty2.default)(Schema, "tags", {
  core: _core.default,
  failsafe: _failsafe.default,
  json: _json.default,
  'yaml-1.1': _yaml.default
});
module.exports = exports.default;
module.exports.default = exports.default;