"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.warnFileDeprecation = warnFileDeprecation;
exports.warnOptionDeprecation = warnOptionDeprecation;

/* global global, console */
function warn(msg) {
  if (global && global.process && global.process.emitWarning) {
    global.process.emitWarning(msg, 'DeprecationWarning');
  } else {
    // eslint-disable-next-line no-console
    console.warn("DeprecationWarning: ".concat(msg));
  }
}

function warnFileDeprecation(filename) {
  if (global && global._YAML_SILENCE_DEPRECATION_WARNINGS) return;
  var path = filename.replace(/.*yaml[/\\]/i, '').replace(/\.js$/, '').replace(/\\/g, '/');
  warn("The endpoint 'yaml/".concat(path, "' will be removed in a future release."));
}

var warned = {};

function warnOptionDeprecation(name, alternative) {
  if (global && global._YAML_SILENCE_DEPRECATION_WARNINGS) return;
  if (warned[name]) return;
  warned[name] = true;
  var msg = "The option '".concat(name, "' will be removed in a future release");
  msg += alternative ? ", use '".concat(alternative, "' instead.") : '.';
  warn(msg);
}