"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.YAMLWarning = exports.YAMLSyntaxError = exports.YAMLSemanticError = exports.YAMLReferenceError = exports.YAMLError = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _wrapNativeSuper2 = _interopRequireDefault(require("@babel/runtime/helpers/wrapNativeSuper"));

var _Node = _interopRequireDefault(require("./cst/Node"));

var YAMLError =
/*#__PURE__*/
function (_Error) {
  (0, _inherits2.default)(YAMLError, _Error);

  function YAMLError(name, source, message) {
    var _this;

    (0, _classCallCheck2.default)(this, YAMLError);
    if (!message || !(source instanceof _Node.default)) throw new Error("Invalid arguments for new ".concat(name));
    _this = (0, _possibleConstructorReturn2.default)(this, (0, _getPrototypeOf2.default)(YAMLError).call(this));
    _this.name = name;
    _this.message = message;
    _this.source = source;
    return _this;
  }

  (0, _createClass2.default)(YAMLError, [{
    key: "makePretty",
    value: function makePretty() {
      if (this.source) {
        this.nodeType = this.source.type;
        this.range = this.source.range;
        this.linePos = this.source.rangeAsLinePos;
        delete this.source;
      }
    }
  }]);
  return YAMLError;
}((0, _wrapNativeSuper2.default)(Error));

exports.YAMLError = YAMLError;

var YAMLReferenceError =
/*#__PURE__*/
function (_YAMLError) {
  (0, _inherits2.default)(YAMLReferenceError, _YAMLError);

  function YAMLReferenceError(source, message) {
    (0, _classCallCheck2.default)(this, YAMLReferenceError);
    return (0, _possibleConstructorReturn2.default)(this, (0, _getPrototypeOf2.default)(YAMLReferenceError).call(this, 'YAMLReferenceError', source, message));
  }

  return YAMLReferenceError;
}(YAMLError);

exports.YAMLReferenceError = YAMLReferenceError;

var YAMLSemanticError =
/*#__PURE__*/
function (_YAMLError2) {
  (0, _inherits2.default)(YAMLSemanticError, _YAMLError2);

  function YAMLSemanticError(source, message) {
    (0, _classCallCheck2.default)(this, YAMLSemanticError);
    return (0, _possibleConstructorReturn2.default)(this, (0, _getPrototypeOf2.default)(YAMLSemanticError).call(this, 'YAMLSemanticError', source, message));
  }

  return YAMLSemanticError;
}(YAMLError);

exports.YAMLSemanticError = YAMLSemanticError;

var YAMLSyntaxError =
/*#__PURE__*/
function (_YAMLError3) {
  (0, _inherits2.default)(YAMLSyntaxError, _YAMLError3);

  function YAMLSyntaxError(source, message) {
    (0, _classCallCheck2.default)(this, YAMLSyntaxError);
    return (0, _possibleConstructorReturn2.default)(this, (0, _getPrototypeOf2.default)(YAMLSyntaxError).call(this, 'YAMLSyntaxError', source, message));
  }

  return YAMLSyntaxError;
}(YAMLError);

exports.YAMLSyntaxError = YAMLSyntaxError;

var YAMLWarning =
/*#__PURE__*/
function (_YAMLError4) {
  (0, _inherits2.default)(YAMLWarning, _YAMLError4);

  function YAMLWarning(source, message) {
    (0, _classCallCheck2.default)(this, YAMLWarning);
    return (0, _possibleConstructorReturn2.default)(this, (0, _getPrototypeOf2.default)(YAMLWarning).call(this, 'YAMLWarning', source, message));
  }

  return YAMLWarning;
}(YAMLError);

exports.YAMLWarning = YAMLWarning;