'use strict';

var Node = require('./Node.js');
var toJS = require('./toJS.js');

const isScalarValue = value => !value || typeof value !== 'function' && typeof value !== 'object';
class Scalar extends Node.Node {
  constructor(value) {
    super();
    this.value = value;
  }

  toJSON(arg, ctx) {
    return ctx && ctx.keep ? this.value : toJS.toJS(this.value, arg, ctx);
  }

  toString() {
    return String(this.value);
  }

}

exports.Scalar = Scalar;
exports.isScalarValue = isScalarValue;
