'use strict';

var Node = require('./Node.js');
var Range = require('./Range.js');

class Alias extends Node.Node {
  /**
   * Parses an *alias from the source
   *
   * @param {ParseContext} context
   * @param {number} start - Index of first character
   * @returns {number} - Index of the character after this scalar
   */
  parse(context, start) {
    this.context = context;
    const {
      src
    } = context;
    let offset = Node.Node.endOfIdentifier(src, start + 1);
    this.valueRange = new Range.Range(start + 1, offset);
    offset = Node.Node.endOfWhiteSpace(src, offset);
    offset = this.parseComment(offset);
    return offset;
  }

}

exports.Alias = Alias;
