'use strict';

var constants = require('../constants.js');
var Node = require('./Node.js');
var Range = require('./Range.js');

class Comment extends Node.Node {
  constructor() {
    super(constants.Type.COMMENT);
  }
  /**
   * Parses a comment line from the source
   *
   * @param {ParseContext} context
   * @param {number} start - Index of first character
   * @returns {number} - Index of the character after this scalar
   */


  parse(context, start) {
    this.context = context;
    const offset = this.parseComment(start);
    this.range = new Range.Range(start, offset);
    return offset;
  }

}

exports.Comment = Comment;
