'use strict';

var Collection = require('../ast/Collection.js');
var Pair = require('../ast/Pair.js');
var Scalar = require('../ast/Scalar.js');

const visit = (node, tags) => {
  if (node && typeof node === 'object') {
    const {
      tag
    } = node;

    if (node instanceof Collection.Collection) {
      if (tag) tags[tag] = true;
      node.items.forEach(n => visit(n, tags));
    } else if (node instanceof Pair.Pair) {
      visit(node.key, tags);
      visit(node.value, tags);
    } else if (node instanceof Scalar.Scalar) {
      if (tag) tags[tag] = true;
    }
  }

  return tags;
};

const listTagNames = node => Object.keys(visit(node, {}));

exports.listTagNames = listTagNames;
