'use strict';

var constants = require('./constants.js');
var options = require('./tags/options.js');

const defaultOptions = {
  anchorPrefix: 'a',
  customTags: null,
  indent: 2,
  indentSeq: true,
  keepCstNodes: false,
  keepNodeTypes: true,
  keepUndefined: false,
  logLevel: 'warn',
  mapAsMap: false,
  maxAliasCount: 100,
  prettyErrors: true,
  simpleKeys: false,
  version: '1.2'
};
const scalarOptions = {
  get binary() {
    return options.binaryOptions;
  },

  set binary(opt) {
    Object.assign(options.binaryOptions, opt);
  },

  get bool() {
    return options.boolOptions;
  },

  set bool(opt) {
    Object.assign(options.boolOptions, opt);
  },

  get int() {
    return options.intOptions;
  },

  set int(opt) {
    Object.assign(options.intOptions, opt);
  },

  get null() {
    return options.nullOptions;
  },

  set null(opt) {
    Object.assign(options.nullOptions, opt);
  },

  get str() {
    return options.strOptions;
  },

  set str(opt) {
    Object.assign(options.strOptions, opt);
  }

};
const documentOptions = {
  '1.0': {
    schema: 'yaml-1.1',
    merge: true,
    tagPrefixes: [{
      handle: '!',
      prefix: constants.defaultTagPrefix
    }, {
      handle: '!!',
      prefix: 'tag:private.yaml.org,2002:'
    }]
  },
  1.1: {
    schema: 'yaml-1.1',
    merge: true,
    tagPrefixes: [{
      handle: '!',
      prefix: '!'
    }, {
      handle: '!!',
      prefix: constants.defaultTagPrefix
    }]
  },
  1.2: {
    schema: 'core',
    merge: false,
    resolveKnownTags: true,
    tagPrefixes: [{
      handle: '!',
      prefix: '!'
    }, {
      handle: '!!',
      prefix: constants.defaultTagPrefix
    }]
  }
};

exports.defaultOptions = defaultOptions;
exports.documentOptions = documentOptions;
exports.scalarOptions = scalarOptions;
