'use strict';

var Scalar = require('../ast/Scalar.js');

function resolveScalar(str, tags) {
  for (const {
    format,
    test,
    resolve
  } of tags) {
    if (test && test.test(str)) {
      let res = resolve(str);
      if (!(res instanceof Scalar.Scalar)) res = new Scalar.Scalar(res);
      if (format) res.format = format;
      return res;
    }
  }

  return new Scalar.Scalar(str); // fallback to string
}

exports.resolveScalar = resolveScalar;
