'use strict';

var YAMLSeq = require('../../ast/YAMLSeq.js');
var createNode = require('../../doc/createNode.js');

function createSeq(schema, obj, ctx) {
  const {
    replacer
  } = ctx;
  const seq = new YAMLSeq.YAMLSeq(schema);

  if (obj && obj[Symbol.iterator]) {
    let i = 0;

    for (let it of obj) {
      if (typeof replacer === 'function') {
        const key = obj instanceof Set ? it : String(i++);
        it = replacer.call(obj, key, it);
      }

      seq.items.push(createNode.createNode(it, null, ctx));
    }
  }

  return seq;
}

const seq = {
  createNode: createSeq,
  default: true,
  nodeClass: YAMLSeq.YAMLSeq,
  tag: 'tag:yaml.org,2002:seq',
  resolve: seq => seq
};

exports.seq = seq;
